/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.install;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import oracle.dbtools.plugin.api.i18n.Translatable;

public final class InstallationOptions {
    private final Map<String, Option> options;

    private InstallationOptions(Map<String, Option> options) {
        this.options = options;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstallationOptions other = (InstallationOptions)obj;
        return Objects.equals(this.options, other.options);
    }

    public int hashCode() {
        return Objects.hash(this.options);
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        for (String name : this.options.keySet()) {
            Option option = this.options.get(name);
            builder2.append("InstallationOptions  [name=");
            builder2.append(name);
            builder2.append(option.getDescription().toString());
            builder2.append(" [secure=");
            builder2.append(option.isSecure());
            builder2.append(", type=");
            builder2.append(option.getType());
            builder2.append("]");
        }
        return builder2.toString();
    }

    public Map<String, Option> getOptions() {
        return this.options;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Option {
        private final Translatable description;
        private boolean secure = false;
        private Class<?> type = String.class;

        public Option(Translatable description, boolean secure, Class<?> type) {
            this.secure = secure;
            this.description = description;
            this.type = type == null ? String.class : type;
        }

        public Translatable getDescription() {
            return this.description;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public Class<?> getType() {
            return this.type;
        }
    }

    public static class Builder {
        Map<String, Option> options = new LinkedHashMap<String, Option>(10);

        public InstallationOptions build() {
            return new InstallationOptions(this.options);
        }

        public Builder option(String name, Translatable description) {
            this.option(name, description, false, String.class);
            return this;
        }

        public Builder option(String name, Translatable description, boolean secure) {
            this.option(name, description, secure, String.class);
            return this;
        }

        public Builder option(String name, Translatable description, Class<?> type) {
            this.option(name, description, false, type);
            return this;
        }

        public Builder option(String name, Translatable description, boolean secure, Class<?> type) {
            Option opt = new Option(description, secure, type);
            this.options.put(name, opt);
            return this;
        }
    }
}

