/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.di;

import java.util.Comparator;
import oracle.dbtools.plugin.api.di.Annotations;
import oracle.dbtools.plugin.api.di.annotations.Priority;

public class PriorityComparator
implements Comparator<Class<?>> {
    private static final Priority DEFAULT_PRIORITY = Annotations.INSTANCE.literal(Priority.class);

    @Override
    public int compare(Class<?> o1, Class<?> o2) {
        Priority p1 = this.priority(o1);
        Priority p2 = this.priority(o2);
        int comparison = Integer.compare(p1.ring(), p2.ring());
        if (comparison == 0) {
            comparison = Integer.compare(p2.value(), p1.value());
        }
        return comparison;
    }

    private Priority priority(Class<?> type) {
        Priority priority = type.getAnnotation(Priority.class);
        if (priority == null) {
            priority = DEFAULT_PRIORITY;
        }
        return priority;
    }
}

