/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.di;

import java.util.Iterator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Provider;
import oracle.dbtools.plugin.api.types.TypeQualifier;

public interface InstanceProvider<T>
extends Iterable<T>,
Provider<T>,
Supplier<T> {
    @Override
    public T get();

    default public T orElse(T value) {
        if (this.isAvailable()) {
            return this.get();
        }
        return value;
    }

    default public T getOrNull() {
        return this.orElse(null);
    }

    public boolean hasMultiple();

    default public boolean isAmbiguous() {
        return this.hasMultiple();
    }

    default public boolean isAvailable() {
        return !this.isUnsatisfied();
    }

    default public boolean isUnavailable() {
        return this.isUnsatisfied();
    }

    public boolean isUnsatisfied();

    @Override
    public Iterator<T> iterator();

    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public TypeQualifier<T> qualifier();
}

