/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.di;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import oracle.dbtools.plugin.api.di.DeferredInstanceProviderCycleException;
import oracle.dbtools.plugin.api.di.InstanceLocator;
import oracle.dbtools.plugin.api.di.InstanceProvider;
import oracle.dbtools.plugin.api.types.TypeQualifier;

public class DeferredInstanceProvider<T>
implements InstanceProvider<T> {
    private final transient AtomicReference<InstanceProvider<T>> deferred = new AtomicReference();
    final InstanceLocator locator;
    final TypeQualifier<T> service;

    private DeferredInstanceProvider(TypeQualifier<T> service, InstanceLocator locator) {
        this.locator = locator;
        this.service = service;
    }

    @Override
    public T get() {
        return this.deferred().get();
    }

    @Override
    public boolean hasMultiple() {
        return this.deferred().hasMultiple();
    }

    @Override
    public boolean isUnsatisfied() {
        return this.deferred().isUnsatisfied();
    }

    @Override
    public Iterator<T> iterator() {
        return this.deferred().iterator();
    }

    @Override
    public TypeQualifier<T> qualifier() {
        return this.service;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeferredInstanceProvider [service=");
        builder.append(this.service);
        builder.append(", locator=");
        builder.append(this.locator);
        builder.append("]");
        return builder.toString();
    }

    InstanceLocator locator() {
        return this.locator;
    }

    private InstanceProvider<T> deferred() {
        InstanceProvider<T> existing = this.deferred.get();
        if (existing == null) {
            InstanceProvider<T> deferred = this.locator.select(this.service);
            if (this == deferred) {
                throw new DeferredInstanceProviderCycleException(this);
            }
            if (this.deferred.compareAndSet(null, deferred)) {
                return deferred;
            }
            return this.deferred.get();
        }
        return existing;
    }

    public static <T> DeferredInstanceProvider<T> from(TypeQualifier<T> service, InstanceLocator locator) {
        return new DeferredInstanceProvider<T>(service, locator);
    }
}

