/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NIOAcceptPacket;
import oracle.net.ns.NIOConnectPacket;
import oracle.net.ns.NIONSDataChannel;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NIORedirectPacket;
import oracle.net.ns.NIORefusePacket;
import oracle.net.ns.NIOResendPacket;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.ConnOption;
import oracle.net.nt.TimeoutInterruptHandler;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public class NSProtocolNIO
extends NSProtocol {
    private static final long SEND_BREAK_TIMEOUT_MS = 30L;
    private final AtomicBoolean isWriting = new AtomicBoolean(false);
    private final AtomicBoolean isBreakPending = new AtomicBoolean(false);
    private NIONSDataChannel probePacket;
    static final int MAX_RETRIES = 10;
    DMSFactory.DMSNoun dmsParent = null;

    public NSProtocolNIO(boolean bl, SecuredLogger securedLogger) {
        this.sAtts = new SessionAtts(this, 0x200000, 0x200000, true, bl, securedLogger);
    }

    @Override
    void negotiateConnection(NVFactory nVFactory, NVNavigator nVNavigator, boolean bl, boolean bl2, DMSFactory.DMSNoun dMSNoun) throws IOException, NetException, InterruptedIOException {
        IOException iOException;
        int n2;
        NIOPacket nIOPacket;
        boolean bl3;
        NIOConnectPacket nIOConnectPacket = new NIOConnectPacket(this.sAtts);
        this.dmsParent = dMSNoun;
        do {
            iOException = null;
            nIOPacket = null;
            long l2 = System.currentTimeMillis();
            n2 = 0;
            try {
                nIOConnectPacket.writeToSocketChannel(this.sAtts.cOption.conn_data.toString(), !bl, bl2, this.sAtts.nt.isCharacteristicUrgentSupported(), this.sAtts.getSDU(), this.sAtts.getTDU(), this.sAtts.getANOFlags());
                nIOPacket = NIOPacket.readNIOPacket(this.sAtts);
                n2 = nIOPacket.header.type;
            }
            catch (TimeoutInterruptHandler.IOReadTimeoutException iOReadTimeoutException) {
                this.handleIOTimeoutInterrupt();
                iOException = iOReadTimeoutException;
            }
            catch (InterruptedIOException interruptedIOException) {
                if (this.handleOutboundTimeoutInterrupt(interruptedIOException)) {
                    iOException = new NetException(503);
                }
                throw interruptedIOException;
            }
            catch (IOException iOException2) {
                this.handleIOException();
                iOException = iOException2;
            }
            if (iOException == null) continue;
            String string = String.format("%s, connect lapse %d ms.", iOException.getMessage(), System.currentTimeMillis() - l2);
            iOException = new IOException(string, iOException);
            n2 = 4;
        } while (!(bl3 = this.handleConnectPacketResponse(nVFactory, nVNavigator, nIOPacket, n2, iOException)));
    }

    private void handleIOTimeoutInterrupt() {
        Thread.interrupted();
    }

    private boolean handleOutboundTimeoutInterrupt(InterruptedIOException interruptedIOException) {
        assert (!(interruptedIOException instanceof TimeoutInterruptHandler.IOReadTimeoutException)) : "IO timeout is being handled as an outbound timeout";
        TimeoutInterruptHandler.InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
        if (interruptTask != null && interruptTask.isInterrupted()) {
            Thread.interrupted();
            return true;
        }
        return false;
    }

    private void handleIOException() {
        TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
    }

    private final boolean handleConnectPacketResponse(NVFactory nVFactory, NVNavigator nVNavigator, NIOPacket nIOPacket, int n2, IOException iOException) throws IOException, NetException, InterruptedIOException {
        switch (n2) {
            case 2: {
                this.handleAcceptPacket((NIOAcceptPacket)nIOPacket);
                return true;
            }
            case 5: {
                ConnOption connOption = this.sAtts.cOption.getOriginalConnOption();
                this.handleRedirectPacket((NIORedirectPacket)nIOPacket);
                this.redirectConnection((NIORedirectPacket)nIOPacket, connOption);
                return false;
            }
            case 4: {
                if (this.establishConnectionAfterRefusePacket()) {
                    return false;
                }
                if (iOException != null) {
                    throw iOException;
                }
                if (nIOPacket != null) {
                    throw this.createRefusePacketException(nVFactory, nVNavigator, (NIORefusePacket)nIOPacket);
                }
            }
            case 11: {
                this.handleResendPacket((NIOResendPacket)nIOPacket);
                return false;
            }
        }
        this.sAtts.cOption.nt.disconnect();
        throw new NetException(205);
    }

    private final void redirectConnection(NIORedirectPacket nIORedirectPacket, ConnOption connOption) throws NetException, IOException, InterruptedIOException {
        String string = nIORedirectPacket.redirectData;
        String string2 = null;
        if ((nIORedirectPacket.header.flags & 2) == 2 && nIORedirectPacket.redirectData.indexOf(0) != -1) {
            string = nIORedirectPacket.redirectData.substring(0, nIORedirectPacket.redirectData.indexOf(0));
            this.sAtts.redirecting = true;
            string2 = nIORedirectPacket.redirectData.substring(nIORedirectPacket.redirectData.indexOf(0) + 1, nIORedirectPacket.redirectData.length());
        }
        this.validateRedirectResponse(string);
        if ("WSS".equalsIgnoreCase(this.sAtts.cOption.protocol)) {
            string = this.getWSSRedirectAddress(string, this.sAtts.cOption.addr);
        }
        this.addrRes.setRedirectConnectData(string2 == null ? this.sAtts.cOption.conn_data.toString() : string2);
        this.establishConnection(string, this.dmsParent);
        this.addrRes.setRedirectConnectData(null);
        this.sAtts.cOption.setOriginalConnOption(connOption);
    }

    private final boolean establishConnectionAfterRefusePacket() throws IOException, InterruptedIOException {
        this.sAtts.cOption.nt.disconnect();
        this.sAtts.cOption = null;
        TimeoutInterruptHandler.InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
        if (interruptTask != null && interruptTask.isInterrupted()) {
            Thread.interrupted();
        }
        try {
            this.establishConnection(null, true, this.dmsParent);
        }
        catch (NetException netException) {
            // empty catch block
        }
        return this.sAtts.cOption != null;
    }

    @Override
    final CompletionStage<Void> negotiateConnectionAsync(NVFactory nVFactory, NVNavigator nVNavigator, boolean bl, boolean bl2, DMSFactory.DMSNoun dMSNoun, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        return this.chainAsyncNegotiationIO(nVFactory, nVNavigator, bl, bl2, dMSNoun, new NIOConnectPacket(this.sAtts), asyncOutboundTimeoutHandler, executor);
    }

    private final CompletionStage<Void> chainAsyncNegotiationIO(NVFactory nVFactory, NVNavigator nVNavigator, boolean bl, boolean bl2, DMSFactory.DMSNoun dMSNoun, NIOConnectPacket nIOConnectPacket, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        class ConnectResponse {
            final int packetType;
            final NIOPacket packet;
            final IOException failure;

            ConnectResponse(int n2, NIOPacket nIOPacket, IOException iOException) {
                this.packetType = n2;
                this.packet = nIOPacket;
                this.failure = iOException;
            }
        }
        CompletableFuture completableFuture = new CompletableFuture();
        try {
            nIOConnectPacket.writeToSocketChannel(this.sAtts.cOption.conn_data.toString(), !bl, bl2, this.sAtts.nt.isCharacteristicUrgentSupported(), this.sAtts.getSDU(), this.sAtts.getTDU(), this.sAtts.getANOFlags());
            this.sAtts.cOption.nt.registerForNonBlockingRead(throwable -> executor.execute(() -> {
                if (throwable == null) {
                    completableFuture.complete(null);
                } else {
                    completableFuture.completeExceptionally((Throwable)throwable);
                }
            }));
        }
        catch (IOException iOException2) {
            completableFuture.completeExceptionally(iOException2);
        }
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)completableFuture.thenApply(CompletionStageUtil.normalCompletionHandler(void_ -> {
            NIOPacket nIOPacket = NIOPacket.readNIOPacket(this.sAtts);
            int n2 = nIOPacket.header.type;
            return new ConnectResponse(n2, nIOPacket, null);
        }))).exceptionally(CompletionStageUtil.exceptionalCompletionHandler(IOException.class, iOException -> {
            asyncOutboundTimeoutHandler.cancelTimeout();
            int n2 = 4;
            return new ConnectResponse(n2, null, (IOException)iOException);
        }))).thenCompose(connectResponse -> this.handleConnectPacketResponseAsync(nVFactory, nVNavigator, connectResponse.packet, connectResponse.packetType, connectResponse.failure, asyncOutboundTimeoutHandler, executor))).thenCompose(bl3 -> {
            if (bl3.booleanValue()) {
                return CompletionStageUtil.VOID_COMPLETED_FUTURE;
            }
            return this.chainAsyncNegotiationIO(nVFactory, nVNavigator, bl, bl2, dMSNoun, nIOConnectPacket, asyncOutboundTimeoutHandler, executor);
        });
    }

    private final CompletionStage<Boolean> handleConnectPacketResponseAsync(NVFactory nVFactory, NVNavigator nVNavigator, NIOPacket nIOPacket, int n2, IOException iOException, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        try {
            switch (n2) {
                case 2: {
                    this.handleAcceptPacket((NIOAcceptPacket)nIOPacket);
                    return CompletionStageUtil.completedStage(Boolean.TRUE);
                }
                case 5: {
                    ConnOption connOption = this.sAtts.cOption.getOriginalConnOption();
                    this.handleRedirectPacket((NIORedirectPacket)nIOPacket);
                    return this.redirectConnectionAsync((NIORedirectPacket)nIOPacket, connOption, asyncOutboundTimeoutHandler, executor).thenApply(void_ -> Boolean.FALSE);
                }
                case 4: {
                    return this.establishConnectionAfterRefusePacketAsync(asyncOutboundTimeoutHandler, executor).thenApply(CompletionStageUtil.normalCompletionHandler(bl -> {
                        if (bl.booleanValue()) {
                            return Boolean.FALSE;
                        }
                        if (iOException != null) {
                            throw iOException;
                        }
                        if (nIOPacket != null) {
                            throw this.createRefusePacketException(nVFactory, nVNavigator, (NIORefusePacket)nIOPacket);
                        }
                        throw new NetException(206);
                    }));
                }
                case 11: {
                    this.handleResendPacket((NIOResendPacket)nIOPacket);
                    return CompletionStageUtil.completedStage(Boolean.FALSE);
                }
            }
            this.sAtts.cOption.nt.disconnect();
            return CompletionStageUtil.failedStage(new NetException(205));
        }
        catch (IOException iOException2) {
            return CompletionStageUtil.failedStage(iOException2);
        }
    }

    private final CompletionStage<Void> redirectConnectionAsync(NIORedirectPacket nIORedirectPacket, ConnOption connOption, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        String string;
        String string2;
        if ((nIORedirectPacket.header.flags & 2) == 2 && nIORedirectPacket.redirectData.indexOf(0) != -1) {
            string2 = nIORedirectPacket.redirectData.substring(0, nIORedirectPacket.redirectData.indexOf(0));
            this.sAtts.redirecting = true;
            string = nIORedirectPacket.redirectData.substring(nIORedirectPacket.redirectData.indexOf(0) + 1, nIORedirectPacket.redirectData.length());
        } else {
            string2 = nIORedirectPacket.redirectData;
            string = null;
        }
        try {
            this.validateRedirectResponse(string2);
            if ("WSS".equalsIgnoreCase(this.sAtts.cOption.protocol)) {
                string2 = this.getWSSRedirectAddress(string2, this.sAtts.cOption.addr);
            }
        }
        catch (IOException iOException) {
            return CompletionStageUtil.failedStage(iOException);
        }
        return this.establishConnectionAsync(string2, false, this.dmsParent, asyncOutboundTimeoutHandler, executor).thenAccept(sessionAtts -> {
            this.sAtts.cOption.setOriginalConnOption(connOption);
            if (this.sAtts.redirecting) {
                this.sAtts.cOption.conn_data.setLength(0);
                this.sAtts.cOption.conn_data.append(string);
            } else {
                this.sAtts.cOption.conn_data = connOption.conn_data;
            }
        });
    }

    private final CompletionStage<Boolean> establishConnectionAfterRefusePacketAsync(AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        try {
            this.sAtts.cOption.nt.disconnect();
        }
        catch (IOException iOException) {
            return CompletionStageUtil.failedStage(iOException);
        }
        this.sAtts.cOption = null;
        asyncOutboundTimeoutHandler.cancelTimeout();
        return this.establishConnectionAsync(null, true, this.dmsParent, asyncOutboundTimeoutHandler, executor).exceptionally(CompletionStageUtil.exceptionalCompletionHandler(NetException.class, netException -> null)).thenApply(sessionAtts -> this.sAtts.cOption != null);
    }

    private final void handleAcceptPacket(NIOAcceptPacket nIOAcceptPacket) throws IOException, NetException {
        this.sAtts.setNegotiatedSDUAndTDU(nIOAcceptPacket.sduSize, nIOAcceptPacket.tduSize);
        this.sAtts.setNegotiatedOptions(nIOAcceptPacket.options);
        this.sAtts.setConnectData(nIOAcceptPacket.connectData);
        this.sAtts.cOption.nt.resetInetAddress();
        this.addrRes.clearConnStrategyStack();
        this.sAtts.payloadDataBufferForRead.position(this.sAtts.payloadDataBufferForRead.limit());
        this.sAtts.connected = true;
        if (nIOAcceptPacket.isOOBCheckEnabled) {
            this.tryUrgentByte();
            this.sendMarker(2, (byte)3);
        }
    }

    private final void handleRedirectPacket(NIORedirectPacket nIORedirectPacket) throws IOException {
        this.addrRes.connection_redirected = true;
        this.sAtts.cOption.nt.disconnect();
    }

    private final NetException createRefusePacketException(NVFactory nVFactory, NVNavigator nVNavigator, NIORefusePacket nIORefusePacket) {
        String string = null;
        try {
            NVPair nVPair;
            NVPair nVPair2 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(nIORefusePacket.refuseData), "ERROR");
            if (nVPair2 != null && (nVPair = nVNavigator.findNVPairRecurse(nVPair2, "CODE")) != null) {
                string = nVPair.valueToString();
            }
        }
        catch (NLException nLException) {
        }
        return new NetException(string == null ? 206 : Integer.parseInt(string), "");
    }

    private final void handleResendPacket(NIOResendPacket nIOResendPacket) throws IOException {
        if ((nIOResendPacket.header.flags & 8) == 8) {
            this.sAtts.renegotiateSSLSession();
        }
    }

    private String getWSSRedirectAddress(String string, String string2) throws IOException {
        try {
            NVNavigator nVNavigator = new NVNavigator();
            NVPair nVPair = new NVFactory().createNVPair(string);
            String string3 = nVNavigator.findNVPair(nVPair, "HOST").getAtom();
            String string4 = nVNavigator.findNVPair(nVPair, "PORT").getAtom();
            NVNavigator nVNavigator2 = new NVNavigator();
            NVPair nVPair2 = new NVFactory().createNVPair(string2);
            String string5 = nVNavigator.findNVPair(nVPair2, "HOST").getAtom();
            String string6 = nVNavigator.findNVPair(nVPair2, "PORT").getAtom();
            NVPair nVPair3 = nVNavigator2.findNVPair(nVPair2, "WEBSOCK_URI");
            String string7 = nVPair3 == null ? "/sqlnet" : nVPair3.getAtom();
            String string8 = string7 + "/" + string3 + ":" + string4;
            return String.format("(ADDRESS=(PROTOCOL=WSS)(HOST=%s)(PORT=%s)(WEBSOCK_URI=%s))", string5, string6, string8);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public void writeZeroCopyIO(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        boolean bl = false;
        for (int i2 = n3; i2 > 0; i2 -= n4) {
            if (i2 >= 1703910) {
                n4 = 1703910;
            } else {
                n4 = i2;
                bl = true;
            }
            this.sAtts.prepareWriteBuffer();
            this.sAtts.ddPacket.writeToSocketChannel(n4, bl);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n4);
            while (byteBuffer.hasRemaining()) {
                this.sAtts.socketChannel.write(byteBuffer);
            }
            n2 += n4;
        }
    }

    @Override
    public void writeZeroCopyIOHeader(boolean bl, int n2, boolean bl2) throws IOException {
        this.sAtts.prepareWriteBuffer();
        this.sAtts.ddPacket.writeToSocketChannel(n2, bl2);
    }

    @Override
    public void writeZeroCopyIOData(byte[] byArray, int n2, int n3) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
        while (byteBuffer.hasRemaining()) {
            this.sAtts.socketChannel.write(byteBuffer);
        }
    }

    @Override
    public boolean readZeroCopyIO(byte[] byArray, int n2, int[] nArray) throws IOException {
        boolean bl = false;
        this.sAtts.ddPacket.readFromSocketChannel(true);
        this.sAtts.ddPacket.readPayloadBuffer();
        int n3 = this.sAtts.ddPacket.totalDataLength;
        if ((this.sAtts.ddPacket.descriptorFLaG & 1) != 0) {
            bl = true;
        }
        if (byArray.length < n2 + n3) {
            throw new IOException("Assertion Failed");
        }
        int n4 = 0;
        ByteBuffer byteBuffer = this.sAtts.readBuffer;
        if (byteBuffer.hasRemaining()) {
            int n5 = Math.min(byteBuffer.remaining(), n3);
            byteBuffer.get(byArray, n2, n5);
            n4 += n5;
        }
        while (n4 < n3) {
            byteBuffer.clear();
            byteBuffer.limit(Math.min(byteBuffer.capacity(), n3 - n4));
            while (byteBuffer.hasRemaining()) {
                this.sAtts.socketChannel.read(byteBuffer);
            }
            byteBuffer.rewind();
            byteBuffer.get(byArray, n2 + n4, byteBuffer.limit());
            n4 += byteBuffer.limit();
        }
        nArray[0] = n4;
        return bl;
    }

    @Override
    public void cancelTimeout() {
        TimeoutInterruptHandler.InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, Thread.currentThread());
    }

    @Override
    public void disconnect() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        IOException iOException = null;
        try {
            this.sAtts.dataChannel.sendEOF();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        this.sAtts.connected = false;
        this.dmsParent = null;
        this.sAtts.cOption.nt.disconnect();
        this.sAtts.releaseWriteBuffer();
        if (iOException != null) {
            throw iOException;
        }
    }

    @Override
    public void sendReset() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        TimeoutInterruptHandler.InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, Thread.currentThread());
        this.sendMarker(1, (byte)2);
        while (this.sAtts.onBreakReset) {
            this.sAtts.markerPacket.readFromSocketChannel(true, false);
            this.sAtts.markerPacket.readPayloadBuffer();
            if (!this.sAtts.markerPacket.isResetPkt()) continue;
            this.sAtts.onBreakReset = false;
        }
    }

    @Override
    public void sendInterrupt() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        TimeoutInterruptHandler.InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, this.sAtts.socketChannel);
        super.sendInterrupt();
    }

    @Override
    public NetInputStream getNetInputStream() throws NetException, IOException {
        throw new UnsupportedOperationException("Unsupported operation in NIO");
    }

    @Override
    public InputStream getInputStream() throws NetException, IOException {
        return this.getNetInputStream();
    }

    @Override
    public NetOutputStream getNetOutputStream() throws NetException, IOException {
        throw new UnsupportedOperationException("Unsupported operation in NIO");
    }

    @Override
    public OutputStream getOutputStream() throws NetException, IOException {
        return this.getNetOutputStream();
    }

    @Override
    void initializeSessionAttributes() throws NetException, IOException {
        this.sAtts.socketChannel = this.sAtts.nt.getSocketChannel();
        this.sAtts.initializeBuffer(this.sAtts.getSDU());
        this.sAtts.dataEOF = false;
    }

    @Override
    protected void sendMarker(int n2, byte by) throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.sAtts.markerPacket.writeToSocketChannel(n2, by);
    }

    @Override
    void sendProbePacket() throws IOException {
        if (this.probePacket == null) {
            this.probePacket = new NIONSDataChannel(this.sAtts);
        } else {
            this.probePacket.reinitialize(this.sAtts);
        }
        byte[] byArray = new byte[26];
        this.probePacket.writeDataToSocketChannel(byArray);
    }

    void doSocketRead(int n2) throws IOException {
        int n3 = this.sAtts.readBuffer.position();
        int n4 = 0;
        while (this.sAtts.readBuffer.position() < n2) {
            int n5 = this.sAtts.socketChannel.read(this.sAtts.readBuffer);
            if (n5 < 0) {
                throw new NetException(0);
            }
            if (n5 == 0) {
                if (++n4 < 10) continue;
                throw new NetException(0);
            }
            n4 = 0;
        }
        this.sAtts.readBuffer.flip();
        this.sAtts.readBuffer.position(n3);
    }

    @Override
    public void sendZDP() throws IOException {
        this.sAtts.prepareWriteBuffer();
        this.sAtts.dataChannel.header.type = 6;
        this.sAtts.payloadBufferForWrite.clear();
        this.sAtts.payloadBufferForWrite.limit(2);
        this.sAtts.payloadBufferForWrite.put((byte)0);
        this.sAtts.payloadBufferForWrite.put((byte)0);
        this.sAtts.dataChannel.writeToSocketChannel();
    }

    @Override
    public boolean needsToBeClosed() {
        return this.sAtts.needsToBeClosed;
    }

    @Override
    public void readInbandNotification() {
        try {
            if (this.sAtts.needsToBeClosed) {
                return;
            }
            this.sAtts.dataChannel.readInbandNotificationCtlPacket();
        }
        catch (IOException iOException) {
            this.sAtts.needsToBeClosed = true;
        }
    }

    @Override
    public final void sendBreak() throws IOException, NetException {
        this.isBreakPending.set(true);
        if (this.isWriting.compareAndSet(false, true)) {
            try {
                this.sendPendingBreak();
            }
            finally {
                this.isWriting.set(false);
            }
        }
    }

    final void beginWrite() throws IOException {
        while (!this.isWriting.compareAndSet(false, true)) {
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new InterruptedIOException("Socket write interrupted");
        }
        try {
            this.sendPendingBreak();
        }
        catch (Throwable throwable) {
            this.isWriting.set(false);
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException(throwable);
        }
    }

    final void endWrite(Throwable throwable) throws IOException {
        if (throwable != null) {
            this.isWriting.set(false);
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException(throwable);
        }
        try {
            this.sendPendingBreak();
        }
        finally {
            this.isWriting.set(false);
        }
        while (this.isBreakPending.get()) {
            if (this.isWriting.compareAndSet(false, true)) {
                try {
                    this.sendPendingBreak();
                    continue;
                }
                finally {
                    this.isWriting.set(false);
                    continue;
                }
            }
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new InterruptedIOException("Socket write interrupted");
        }
    }

    private void sendPendingBreak() throws IOException {
        assert (this.isWriting.get()) : "Sending break without the write lock";
        if (!this.isBreakPending.get()) {
            return;
        }
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        if (this.sAtts.isExpediatedAttentionEnabled() && !this.sAtts.nt.awaitWriteReadiness(30L)) {
            throw new IOException("Unable to send break without blocking");
        }
        TimeoutInterruptHandler.InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, this.sAtts.socketChannel);
        int n2 = this.getSocketReadTimeout();
        this.setSocketReadTimeout(30);
        try {
            super.sendBreak();
            this.isBreakPending.set(false);
        }
        finally {
            this.setSocketReadTimeout(n2);
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

