/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.Failoverable;
import oracle.ucp.jdbc.oracle.FailoverActionResult;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.RACManager;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TimerManager;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
class ReplayableRACManagerImpl
extends RACManagerImpl
implements RACManager,
Failoverable {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;

    ReplayableRACManagerImpl(TaskManager taskManager, TimerManager timerManager, boolean isStrictWebSessionAffinity, boolean isStrictXAAffinity) throws UniversalConnectionPoolException {
        super(taskManager, timerManager, isStrictWebSessionAffinity, isStrictXAAffinity);
    }

    @Override
    FailoverActionResult processFailoverAction(FailoverablePooledConnection pc, boolean isAvailableConnection, boolean isPlannedDownEvent, int actionFlag) {
        FailoverActionResult result = FailoverActionResult.NOOP;
        switch (actionFlag) {
            case 0: {
                try {
                    if (!isAvailableConnection && isPlannedDownEvent) {
                        pc.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN);
                        result = FailoverActionResult.MARKED_CLOSE_ON_RETURN;
                        break;
                    }
                    if (!isAvailableConnection) {
                        pc.setStatus(UniversalPooledConnectionStatus.STATUS_RECONNECTING);
                        result = FailoverActionResult.MARKED_BAD;
                        break;
                    }
                    pc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                    result = FailoverActionResult.MARKED_BAD;
                }
                catch (UniversalConnectionPoolException ucpe) {
                    ClioSupport.ilogFinest(null, null, null, null, this.getStackTraceString(ucpe));
                    this.m_errorInfo.append(", ").append(ucpe.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                break;
            }
            case 1: {
                if (pc.getStatus() != UniversalPooledConnectionStatus.STATUS_BAD && pc.getStatus() != UniversalPooledConnectionStatus.STATUS_RECONNECTING) {
                    ClioSupport.ilogFinest(null, null, null, null, "AC replugging already happened - no FCF cleanup");
                    break;
                }
                try {
                    pc.abort();
                }
                catch (Exception exc) {
                    ClioSupport.ilogFinest(null, null, null, null, this.getStackTraceString(exc));
                    this.m_errorInfo.append(", ").append(exc.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                try {
                    pc.close(!isAvailableConnection);
                    result = FailoverActionResult.ABORTED_AND_CLOSED;
                }
                catch (UniversalConnectionPoolException ucpe) {
                    ClioSupport.ilogFinest(null, null, null, null, this.getStackTraceString(ucpe));
                    this.m_errorInfo.append(", ").append(ucpe.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                break;
            }
        }
        return result;
    }

    static {
        try {
            $$$methodRef$$$1 = ReplayableRACManagerImpl.class.getDeclaredConstructor(TaskManager.class, TimerManager.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = ReplayableRACManagerImpl.class.getDeclaredMethod("processFailoverAction", FailoverablePooledConnection.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

