/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc")
@Supports(value={Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class DriverConnectionFactoryAdapter
extends JDBCConnectionFactoryAdapter {
    protected Driver m_driver;
    protected final Properties m_connectionProperties;
    protected final Properties m_connectionFactoryProperties;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    public DriverConnectionFactoryAdapter(Driver driver, String url, Properties connectionFactoryProperties, Properties connectionProperties) throws UniversalConnectionPoolException {
        if (null == driver) {
            UCPErrorHandler.throwUniversalConnectionPoolException(268);
        }
        if (url == null || "".equals(url)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(269);
        }
        this.m_driver = driver;
        this.m_url = url;
        this.m_connectionFactoryProperties = connectionFactoryProperties;
        this.m_connectionProperties = connectionProperties;
    }

    public Driver getDriver() {
        return this.m_driver;
    }

    @Override
    public Object createConnection(ConnectionRetrievalInfo connectionRequestInfo) throws UniversalConnectionPoolException {
        if (!(connectionRequestInfo instanceof JDBCConnectionRetrievalInfo)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(252);
        }
        Connection connection = null;
        try {
            Properties connProps = new Properties();
            connProps.putAll((Map<?, ?>)this.m_connectionProperties);
            connProps.putAll((Map<?, ?>)this.m_connectionFactoryProperties);
            connection = this.m_driver.connect(this.m_url, connProps);
        }
        catch (Throwable e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
            if (null != connection) {
                this.closeConnection(connection);
            }
            UCPErrorHandler.throwUniversalConnectionPoolException(257, e);
        }
        return connection;
    }

    @Override
    public void closeConnection(Object connection) throws UniversalConnectionPoolException {
        if (!(connection instanceof Connection)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(258);
        }
        Connection javaSQLConnection = (Connection)connection;
        try {
            javaSQLConnection.close();
        }
        catch (SQLException sqlException) {
            ClioSupport.ilogThrowing(null, null, null, null, sqlException);
            UCPErrorHandler.throwUniversalConnectionPoolException(255, sqlException);
        }
    }

    static {
        try {
            $$$methodRef$$$3 = DriverConnectionFactoryAdapter.class.getDeclaredConstructor(Driver.class, String.class, Properties.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = DriverConnectionFactoryAdapter.class.getDeclaredMethod("closeConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = DriverConnectionFactoryAdapter.class.getDeclaredMethod("createConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = DriverConnectionFactoryAdapter.class.getDeclaredMethod("getDriver", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

