#/bin/make
###############################################################################
#                       Make file for OCI and OCCI demos
###############################################################################
#  Usage :
# For compiling & linking the cdemo81.c file
#    make -f demo.mk buildoci EXE=cdemo81 OBJS=cdemo81.o 
#
# For compiling & linking the occidml.cpp
#    make -f demo.mk buildocci EXE=occidml OBJS=occidml.o
#
# For compiling & linking the occiobj.cpp
#    make -f demo.mk occiobj 
#
# In general, for any occi program
#    make -f demo.mk buildocci EXE=<exename> OBJS="<list of dependent objs>"
#
# For compiling all demos
#    make -f demo.mk
#
# NOTE: Please change cc and CC to point to the appropiate location on your
#       machine.
#
###############################################################################

.SUFFIXES: .o .c .cpp

CC=/opt/SunProd/SUNWspro6.1/bin/CC
cc=/opt/SunProd/SUNWspro6.1/bin/cc

ICINCHOME=../
ICLIBHOME=../../
ICLIBPATH=-L$(ICLIBHOME)
THREADLIBS=-lthread
CCLIB=$(ICLIBPATH) -locci -lclntsh $(THREADLIBS)

CCINCLUDES = -I$(ICINCHOME)include

CCFLAGS=$(CCINCLUDES) -D_REENTRANT -g -xs 
LDFLAGS=
SO_EXT=.so

REMOVE=rm -rf
MAKE=make
MAKEFILE=demo.mk
CLNCACHE=cleancache
CACHEDIR=SunWS_cache

CDEMOEXE=cdemo81
CDEMOOBJS=cdemo81.o
OCCIDEMO=occidml
OCCIOBJDEMO=occiobj
OTT=../ott
OCCIOTTUSR=scott
OCCIOTTPWD=tiger

.cpp.o:
	$(CC) -c -I$(ICINCHOME)include $(CCFLAGS) $<

.c.o:
	$(cc) -c -I$(ICINCHOME)include $(CCFLAGS) $<

all: clean buildoci $(OCCIDEMO) $(OCCIOBJDEMO)

buildoci: $(CLNCACHE) $(LIBCLNT) $(CDEMOOBJS)
	$(CC) -o $(CDEMOEXE) $(LDFLAGS) $(CDEMOOBJS) $(CCLIB)

buildocci: $(CLNCACHE) $(LIBCLNT) $(OBJS)
	$(CC) -o $(EXE) $(LDFLAGS) $(OBJS) $(CCLIB)

$(OCCIDEMO):
	$(MAKE) -f $(MAKEFILE) buildocci OBJS=$@.o EXE=$@

$(OCCIOBJDEMO):
	$(OTT) userid=$(OCCIOTTUSR)/$(OCCIOTTPWD) \
                intype=$@.typ \
                outtype=$@out.type \
                code=cpp \
                hfile=$@.h \
                cppfile=$@o.cpp \
                attraccess=private \
                unicode=none
	$(MAKE) -f $(MAKEFILE) buildocci OBJS="$@.o $@m.o $@o.o" EXE=$@

cleancache:
	$(REMOVE) $(CACHEDIR)

clean: $(CLNCACHE)
	$(REMOVE) cdemo81 cdemo81.o occidml occidml.o occiobj occiobj.o occiobjo* occiobjm* occiobj.h occiobjout.type



#
# This port-specific file is currently empty on Solaris. Product
# lines may use this file to override compiler definitions and
# flags used in occi.mk.
#

CC=`if [ -d /usr/local/packages/compiler ]; then echo '/usr/local/packages/compiler/opt/aCC/bin/aCC -AA'; else echo '/opt/aCC/bin/aCC -AA'; fi `

cc=`if [ -d /usr/local/packages/compiler ]; then echo '/usr/local/packages/compiler/opt/ansic/bin/cc'; else echo '/opt/ansic/bin/cc'; fi `

# Settings for 32-bit and 64-bit QAs. In the QA environment,
# BUILD64 is set to 'T' if we're in a 64-bit home or is unset
# if we're in a 32-bit home.
ifdef BUILD64
    CCFLAGS = +DD64 $(CCINCLUDES) -DHPUX -DORA_CPP \
              -D_RWSTD_MULTI_THREAD -D_REENTRANT -g
    LDFLAGS = +DD64 -g -D_RWSTD_MULTI_THREAD -D_REENTRANT
    OCCILIBPATH=-L$(SRCHOME)/rdbms/lib -L$(SRCHOME)/lib
else
    CCFLAGS = +DD32 $(CCINCLUDES) -DHPUX -DORA_CPP \
              -D_RWSTD_MULTI_THREAD -D_REENTRANT -g
    LDFLAGS = +DD32 -g -D_RWSTD_MULTI_THREAD -D_REENTRANT
#From 11.2 onwards we have pure 32 & 64 bit labels
#So lib32 is not present in 32-bit labels.
    OCCILIBPATH=-L$(SRCHOME)/rdbms/lib -L$(SRCHOME)/lib
endif
CLNCACHE=

THREADLIBS=-lpthread
#
# This port-specific file is currently empty on Solaris. Product
# lines may use this file to override compiler definitions and
# flags used in demo.mk.
#
#  Usage :
# For compiling & linking the cdemo81.c file with libclntsh_nopthread.so
#    make -f demo.mk buildoci_nopthread EXE=cdemo81 OBJS=cdemo81.o 
#
# For compiling & linking the occidml.cpp file with libclntsh_nopthread.so
#    make -f demo.mk buildocci_nopthread EXE=occidml OBJS=occidml.o
#
CCLIB_NPT=$(ICLIBPATH) -locci -lclntsh_nopthread

buildoci_nopthread: $(CLNCACHE) $(LIBCLNT) $(CDEMOOBJS)
	$(MKLINK) $(ICLIBHOME)libocci$(SO_EXT).11.1 $(ICLIBHOME)libocci$(SO_EXT)
	$(CC) -o $(CDEMOEXE)_nopthread $(LDFLAGS) $(CDEMOOBJS) $(CCLIB_NPT)
	$(REMOVE) $(ICLIBHOME)libocci$(SO_EXT)

buildocci_nopthread: $(CLNCACHE) $(LIBCLNT) $(OBJS)
	$(MKLINK) $(ICLIBHOME)libocci$(SO_EXT).11.1 $(ICLIBHOME)libocci$(SO_EXT)
	$(CC) -o $(EXE) $(LDFLAGS) $(OBJS) $(CCLIB_NPT)
	$(REMOVE) $(ICLIBHOME)libocci$(SO_EXT)
