import { ComponentChildren } from 'preact';
export declare type DynamicSlots = Record<string, Slot>;
export declare type DynamicTemplateSlots<Data extends object> = Record<string, TemplateSlot<Data>>;
export declare type Slot = ComponentChildren;
export declare type TemplateSlot<Data extends object> = (data: Data) => Slot;
export declare type PropertyChanged<T> = (value: T) => void;
export declare type ReadOnlyPropertyChanged<T> = (value: T) => void;
export declare type Action<Detail extends object = {}> = (detail?: Detail) => void;
export declare type CancelableAction<Detail extends object = {}> = (detail?: Detail) => Promise<void>;
export declare type Bubbles = {};
export declare type ElementReadOnly<T> = T;
export declare type GlobalProps = Readonly<Pick<preact.JSX.HTMLAttributes, 'accessKey' | 'autofocus' | 'class' | 'contentEditable' | 'dir' | 'draggable' | 'hidden' | 'id' | 'inputMode' | 'lang' | 'role' | 'slot' | 'spellcheck' | 'style' | 'tabIndex' | 'title' | 'onBlur' | 'onBlurCapture' | 'onClick' | 'onClickCapture' | 'onContextMenu' | 'onContextMenuCapture' | 'onDblClick' | 'onDblClickCapture' | 'onDrag' | 'onDragCapture' | 'onDragEnd' | 'onDragEndCapture' | 'onDragEnter' | 'onDragEnterCapture' | 'onDragExit' | 'onDragExitCapture' | 'onDragLeave' | 'onDragLeaveCapture' | 'onDragOver' | 'onDragOverCapture' | 'onDragStart' | 'onDragStartCapture' | 'onDrop' | 'onDropCapture' | 'onFocus' | 'onFocusCapture' | 'onKeyDown' | 'onKeyDownCapture' | 'onKeyPress' | 'onKeyPressCapture' | 'onKeyUp' | 'onKeyUpCapture' | 'onMouseDown' | 'onMouseDownCapture' | 'onMouseEnter' | 'onMouseEnterCapture' | 'onMouseLeave' | 'onMouseLeaveCapture' | 'onMouseMove' | 'onMouseMoveCapture' | 'onMouseOut' | 'onMouseOutCapture' | 'onMouseOver' | 'onMouseOverCapture' | 'onMouseUp' | 'onMouseUpCapture' | 'onPointerOver' | 'onPointerOverCapture' | 'onPointerEnter' | 'onPointerEnterCapture' | 'onPointerDown' | 'onPointerDownCapture' | 'onPointerMove' | 'onPointerMoveCapture' | 'onPointerUp' | 'onPointerUpCapture' | 'onPointerCancel' | 'onPointerCancelCapture' | 'onPointerOut' | 'onPointerOutCapture' | 'onPointerLeave' | 'onPointerLeaveCapture' | 'onTouchCancel' | 'onTouchCancelCapture' | 'onTouchEnd' | 'onTouchEndCapture' | 'onTouchMove' | 'onTouchMoveCapture' | 'onTouchStart' | 'onTouchStartCapture' | 'onWheel' | 'onWheelCapture' | 'onfocusin' | 'onfocusout'> & {
    'aria-activedescendant'?: string;
    'aria-atomic'?: string;
    'aria-autocomplete'?: string;
    'aria-busy'?: string;
    'aria-checked'?: string;
    'aria-colcount'?: string;
    'aria-colindex'?: string;
    'aria-colspan'?: string;
    'aria-controls'?: string;
    'aria-current'?: string;
    'aria-describedby'?: string;
    'aria-details'?: string;
    'aria-disabled'?: string;
    'aria-errormessage'?: string;
    'aria-expanded'?: string;
    'aria-flowto'?: string;
    'aria-haspopup'?: string;
    'aria-hidden'?: string;
    'aria-invalid'?: string;
    'aria-keyshortcuts'?: string;
    'aria-label'?: string;
    'aria-labelledby'?: string;
    'aria-level'?: string;
    'aria-live'?: string;
    'aria-modal'?: string;
    'aria-multiline'?: string;
    'aria-multiselectable'?: string;
    'aria-orientation'?: string;
    'aria-owns'?: string;
    'aria-placeholder'?: string;
    'aria-posinset'?: string;
    'aria-pressed'?: string;
    'aria-readonly'?: string;
    'aria-relevant'?: string;
    'aria-required'?: string;
    'aria-roledescription'?: string;
    'aria-rowcount'?: string;
    'aria-rowindex'?: string;
    'aria-rowspan'?: string;
    'aria-selected'?: string;
    'aria-setsize'?: string;
    'aria-sort'?: string;
    'aria-valuemax'?: string;
    'aria-valuemin'?: string;
    'aria-valuenow'?: string;
    'aria-valuetext'?: string;
    autocapitalize?: 'on' | 'off' | 'none' | 'sentences' | 'words' | 'characters';
    enterKeyHint?: 'enter' | 'done' | 'go' | 'next' | 'previous' | 'search' | 'send';
    translate?: 'yes' | 'no';
}>;
export declare type ObservedGlobalProps<U extends Exclude<keyof GlobalProps, 'class' | 'style'>> = Pick<GlobalProps, U>;
export declare type ExtendGlobalProps<Props> = Readonly<Props> & GlobalProps;
