/**
 * Copyright (c) 2017, Oracle and/or its affiliates.
 * All rights reserved.
 */

define(["./impl/logger","./impl/PersistenceStoreMetadata","./pouchDBPersistenceStoreFactory"],(function(e,t,r){"use strict";var o=function(){Object.defineProperty(this,"_stores",{value:{},writable:!0}),Object.defineProperty(this,"_factories",{value:{},writable:!0}),Object.defineProperty(this,"_DEFAULT_STORE_FACTORY_NAME",{value:"_defaultFactory",writable:!1}),Object.defineProperty(this,"_METADATA_STORE_NAME",{value:"systemCache-metadataStore",writable:!1}),Object.defineProperty(this,"_storeNameMapping",{value:{},writable:!0})};return o.prototype.registerStoreFactory=function(e,t){if(!t)throw TypeError("A valid factory must be provided.");if(!e)throw TypeError("A valid name must be provided.");var r=this._mapStoreName(e),o=this._factories[r];if(o&&o!==t)throw TypeError("A factory with the same name has already been registered.");this._factories[r]=t},o.prototype.registerDefaultStoreFactory=function(e){this.registerStoreFactory(this._DEFAULT_STORE_FACTORY_NAME,e)},o.prototype.openStore=function(t,r){e.log("Offline Persistence Toolkit PersistenceStoreManager: openStore() for name: "+t);var o=this._mapStoreName(t),n=this._stores[o],a=r&&r.version||"0";if(n&&n[a])return Promise.resolve(n[a]);var i=this._factories[o];if(i||(i=this._factories[this._DEFAULT_STORE_FACTORY_NAME]),!i)return Promise.reject(new Error("no factory is registered to create the store."));var s=this;return e.log("Offline Persistence Toolkit PersistenceStoreManager: Calling createPersistenceStore on factory"),i.createPersistenceStore(o,r).then((function(t){return(n=n||{})[a]=t,s._stores[o]=n,r&&r.skipMetadata?t:s._updateStoreMetadata(o,a).then((function(){return t})).catch((function(r){return e.log("updating store metadata for store "+o+" failed"),t}))}))},o.prototype._updateStoreMetadata=function(e,t){var r=this;return r._getStoresMetadata(e).then((function(o){var n=null;if(o?o.versions.indexOf(t)<0&&(o.versions.push(t),n=o.versions):n=[t],n){var a=r._encodeString(e);return r._metadataStore.upsert(a,{},n)}}))},o.prototype.hasStore=function(e,t){var r=this._mapStoreName(e),o=this._stores[r];return!(!o||0===Object.keys(o).length||t&&t.version&&!o[t.version])},o.prototype.deleteStore=function(t,r){e.log("Offline Persistence Toolkit PersistenceStoreManager: deleteStore() for name: "+t);var o=this,n=this._mapStoreName(t);return o._getStoresMetadata(n).then((function(a){if(a){var i=[],s=[],c=a.versions;if(r&&r.version){var u=c.indexOf(r.version);u<0?s=c:(c.splice(u,1),s=c,i.push(r.version))}else i=c;return!!i.length&&(_=i.map((function(e){var t=this;return t.openStore(n,{version:e,skipMetadata:!0}).then((function(r){return delete t._stores[n][e],r.delete()}))}),o),Promise.all(_).then((function(){var e=o._encodeString(n);return s.length?o._metadataStore.upsert(e,{},s):o._metadataStore.removeByKey(e)})).then((function(){return!0})).catch((function(t){return e.log("failed deleting store "+n),!1})))}var f=[];if(r&&r.version?o._stores[n]&&o._stores[n][r.version]&&(f.push(o._stores[n][r.version]),delete o._stores[n][r.version]):o._stores[n]&&(f=Object.values(o._stores[n]),o._stores[n]={}),f.length){var _=f.map((function(e){return e.delete()}));return Promise.all(_).then((function(){return!0})).catch((function(r){return e.log("failed deleting store "+t),!1}))}return!1}))},o.prototype.getStoresMetadata=function(){var r=this,o=new Map;return this._getMetadataStore().then((function(e){return e.find({fields:["key","value"]})})).then((function(e){return e&&e.length>0&&e.forEach((function(e){var n=r._decodeString(e.key),a=r._factories[n];a||(a=r._factories[r._DEFAULT_STORE_FACTORY_NAME]),o.set(n,new t(n,a,e.value))})),o})).catch((function(t){return e.log("error occured getting store metadata."),o}))},o.prototype._getStoresMetadata=function(r){var o=this;return o._getMetadataStore().then((function(e){var t=o._encodeString(r);return e.findByKey(t)})).then((function(e){if(e){var n=o._factories[r];return n||(n=o._factories[o._DEFAULT_STORE_FACTORY_NAME]),new t(r,n,e)}return null})).catch((function(t){return e.log("error getting store metadata for store "+r),null}))},o.prototype._mapStoreName=function(e,t){var r=this._storeNameMapping[e];return r||(r=e.replace(/(.*):\/\/(.*)/gi,"$1$2"),this._storeNameMapping[e]=r,r)},o.prototype._getMetadataStore=function(){var e=this;return e._metadataStore?Promise.resolve(e._metadataStore):(this._factories[this._DEFAULT_STORE_FACTORY_NAME]||(this._factories[e._METADATA_STORE_NAME]=r),this.openStore(e._METADATA_STORE_NAME,{skipMetadata:!0}).then((function(t){return e._metadataStore=t,e._metadataStore})))},o.prototype._encodeString=function(e){for(var t=[],r=0;r<e.length;r++){var o=Number(e.charCodeAt(r)).toString(16);t.push(o)}return t.join("")},o.prototype._decodeString=function(e){var t,r=e.toString(),o="";for(t=0;t<r.length;t+=2)o+=String.fromCharCode(parseInt(r.substr(t,2),16));return o},new o}));