/**
 * Copyright (c) 2017, Oracle and/or its affiliates.
 * All rights reserved.
 */

define(["./impl/PersistenceXMLHttpRequest","./impl/PersistenceSyncManager","./impl/offlineCacheManager","./impl/logger","./impl/fetch"],(function(e,t,n,r){"use strict";function i(){Object.defineProperty(this,"_registrations",{value:[],writable:!0}),Object.defineProperty(this,"_eventListeners",{value:[],writable:!0}),Object.defineProperty(this,"_forceOffline",{value:!1,writable:!0}),Object.defineProperty(this,"_isOffline",{value:!1,writable:!0}),Object.defineProperty(this,"_cache",{value:null,writable:!0}),Object.defineProperty(this,"_persistenceSyncManager",{value:new t(this.isOnline.bind(this),this.browserFetch.bind(this),this.getCache.bind(this))})}function o(){return"undefined"!=typeof window&&null!=window}function s(e,t){Object.defineProperty(this,"scope",{value:e,enumerable:!0}),Object.defineProperty(this,"_persistenceManager",{value:t}),Object.defineProperty(this,"_eventListeners",{value:[],writable:!0})}function a(e){return function t(n,i){var o=this,s=n,a=i;if(r.log("Offline Persistence Toolkit persistenceRequest: Create New Request"),n._input){for(var l in r.log("Offline Persistence Toolkit persistenceRequest: Input is a PersistenceRequest"),s=n._input,a=Object.assign({},n._init),i)i.hasOwnProperty(l)&&(a[l]=i[l]);if(n.headers&&a&&a.body&&a.body instanceof FormData)if(a.headers){var f=n.headers.get("Content-Type");a.headers.set("Content-Type",f)}else a.headers=n.headers}this._browserRequest=new e._browserRequestConstructor(s,a),this._input=s,this._init=a;var b,h=function(e){var t=Object.getOwnPropertyDescriptor(o._browserRequest,e);t&&(t.writable||t.set)?Object.defineProperty(o,e,{get:function(){return o._browserRequest[e]},set:function(t){o._browserRequest[e]=t},enumerable:!0}):Object.defineProperty(o,e,{get:function(){return o._browserRequest[e]},enumerable:!0})};for(b in this._browserRequest)"body"!=b&&"function"==typeof this._browserRequest[b]||h(b);var p=this.headers.get("Content-Type");null!=p&&p.indexOf("boundary=")>-1&&p.indexOf("form-data")>-1&&(p=p.split("boundary="),this._boundary="--"+p[p.length-1]),this.arrayBuffer=function(){r.log("Offline Persistence Toolkit persistenceRequest: Called arrayBuffer()");var e=this;try{return e._init&&e._init.body&&e._init.body instanceof FormData?function(e,t){return new Promise((function(n,r){var i=[],o=new TextEncoder,s=o.encode(t).buffer,a=o.encode("--").buffer;e.forEach((function(e,n){i.push(function(e,t,n){return new Promise((function(r,i){var o=new TextEncoder,s=o.encode("\r\n"+n).buffer;switch(e.constructor.name){case"File":var a=new FileReader;a.onload=function(n){var i=u([o.encode('\r\nContent-Disposition: form-data; name="'+t.toString()+'"; filename="'+e.name+'"\r\nContent-Type: '+e.type+"\r\n\r\n").buffer,n.target.result,s]);r(i)},a.onerror=function(){a.abort(),i(new DOMException("Problem parsing input file."))},a.readAsArrayBuffer(e);break;case"String":var c=u([o.encode('\r\nContent-Disposition: form-data; name="'+t+'"\r\n\r\n').buffer,o.encode(e).buffer,s]);r(c);break;default:c=u([o.encode('\r\nContent-Disposition: form-data; name="'+t.toString()+'"\r\n\r\n').buffer,o.encode(e.toString()).buffer,s]),r(c)}}))}(e,n,t))})),Promise.all(i).then((function(e){e.forEach((function(e){s=u([s,e])}));var t=u([s,a]);n(t)})).catch((function(e){r(e)}))}))}(e._init.body,e._boundary):e._browserRequest.arrayBuffer()}catch(e){return Promise.reject(e)}},this.blob=function(){r.log("Offline Persistence Toolkit persistenceRequest: Called blob()");var e=this;try{return e._init&&e._init.body&&e._init.body instanceof FormData?c(e._init.body,e._boundary).then((function(t){return new Blob([t],{type:e.headers.get("Content-Type")})})):e._browserRequest.blob()}catch(e){return Promise.reject(e)}},this.formData=function(){r.log("Offline Persistence Toolkit persistenceRequest: Called formData()");var e=this;try{return e._init&&e._init.body&&e._init.body instanceof FormData?Promise.resolve(e._init.body):e._browserRequest.formData()}catch(e){return Promise.reject(e)}},this.json=function(){r.log("Offline Persistence Toolkit persistenceRequest: Called json()");var e=this;try{return e._init&&e._init.body&&e._init.body instanceof FormData?Promise.reject(new SyntaxError("Unexpected number in JSON at position 1")):e._browserRequest.json()}catch(e){return Promise.reject(e)}},this.text=function(){r.log("Offline Persistence Toolkit persistenceRequest: Called text()");var e=this;try{return e._init&&e._init.body&&e._init.body instanceof FormData?c(e._init.body,e._boundary):e._browserRequest.text()}catch(e){return Promise.reject(e)}},this.clone=function(){r.log("Offline Persistence Toolkit persistenceRequest: Called clone()");var e=this;e.headers&&e._init&&e._init.body&&e._init.body instanceof FormData&&(e._init.headers=e.headers);var n=new t(e._input,e._init);return n._browserRequest=e._browserRequest.clone(),n},this.toString=function(){return r.log("Offline Persistence Toolkit persistenceRequest:requestToString()"),this._input.url?this._input.url:this._input}}}function c(e,t){return new Promise((function(n,r){var i=[],o=t;e.forEach((function(e,n){i.push(function(e,t,n){return new Promise((function(r,i){var o;switch(e.constructor.name){case"File":var s=new FileReader;s.onload=function(i){o='\r\nContent-Disposition: form-data; name="'+t.toString()+'"; filename="'+e.name+'"\r\nContent-Type: '+e.type+"\r\n\r\n"+i.target.result+"\r\n"+n,r(o)},s.onerror=function(){s.abort(),i(new DOMException("Problem parsing input file."))},s.readAsText(e);break;case"String":r(o='\r\nContent-Disposition: form-data; name="'+t+'"\r\n\r\n'+e+"\r\n"+n);break;default:o='\r\nContent-Disposition: form-data; name="'+t.toString()+'"\r\n\r\n'+e.toString()+"\r\n"+n,r(o)}}))}(e,n,t))})),Promise.all(i).then((function(e){e.forEach((function(e){o+=e})),n(o+="--")})).catch((function(e){r(e)}))}))}function u(e){var t=new Uint8Array(0);return e.forEach((function(e){var n=new Uint8Array(t.byteLength+e.byteLength);n.set(new Uint8Array(t),0),n.set(new Uint8Array(e),t.byteLength),t=n})),t.buffer}return i.prototype.init=function(){return r.log("Offline Persistence Toolkit PersistenceManager: Initilizing"),function(t){!function(){var e=navigator.userAgent.match(/^(?:(?!chrome|android|iphone|ipad).)*\/([0-9\.]*) safari.*$/i);if(e)return!((t=e[1].split("."))[0]>14||14==t[0]&&0!=t[1]);var t,n=navigator.userAgent.match(/(?:iPad|iPhone).*?os ([0-9\_]*)/i);return!!n&&!((t=n[1].split("_"))[0]>14||14==t[0]&&t[1]>=3)}()||t._browserRequestConstructor||t._persistenceRequestConstructor||(r.log("Offline Persistence Toolkit PersistenceManager: Replacing Safari Browser APIs"),Object.defineProperty(t,"_browserRequestConstructor",{value:self.Request,writable:!1}),Object.defineProperty(t,"_persistenceRequestConstructor",{value:a(t),writable:!1}),self.Request=t._persistenceRequestConstructor,o()||t._browserFetchFunc||(Object.defineProperty(t,"_browserFetchFunc",{value:self.fetch,writable:!1}),self.fetch=function(e){function t(e){Object.defineProperty(this,"isReload",{value:!1,enumerable:!0}),Object.defineProperty(this,"clientId",{value:null,enumerable:!0}),Object.defineProperty(this,"client",{value:null,enumerable:!0}),Object.defineProperty(this,"request",{value:e,enumerable:!0}),Object.defineProperty(this,"_resolveCallback",{value:null,writable:!0}),Object.defineProperty(this,"_rejectCallback",{value:null,writable:!0})}return t.prototype.respondWith=function(e){var t=this;if(e instanceof Promise)e.then((function(e){t._resolveCallback(e)}),(function(e){t._rejectCallback(e)}));else if("function"==typeof e){var n=e();t._resolveCallback(n)}},t.prototype._setPromiseCallbacks=function(e,t){this._resolveCallback=e,this._rejectCallback=t},function(t,n){var i;return i=Request.prototype.isPrototypeOf(t)&&!n?t:new Request(t,n),r.log("Offline Persistence Toolkit serviceWorkerFetch:"+i.url),i._browserRequest&&(i=i._browserRequest),new Promise((function(t,n){e._browserFetchFunc.call(self,i).then((function(e){t(e)}),(function(e){n(e)}))}))}}(t))),!o()||t._browserFetchFunc||t._browserXMLHttpRequest||(r.log("Offline Persistence Toolkit PersistenceManager: Replacing browser APIs"),Object.defineProperty(t,"_browserFetchFunc",{value:window.fetch,writable:!1}),Object.defineProperty(t,"_browserXMLHttpRequest",{value:window.XMLHttpRequest,writable:!1}),window.fetch=function(e){function t(e){Object.defineProperty(this,"isReload",{value:!1,enumerable:!0}),Object.defineProperty(this,"clientId",{value:null,enumerable:!0}),Object.defineProperty(this,"client",{value:null,enumerable:!0}),Object.defineProperty(this,"request",{value:e,enumerable:!0}),Object.defineProperty(this,"_resolveCallback",{value:null,writable:!0}),Object.defineProperty(this,"_rejectCallback",{value:null,writable:!0})}return t.prototype.respondWith=function(e){var t=this;if(e instanceof Promise)e.then((function(e){t._resolveCallback(e)}),(function(e){t._rejectCallback(e)}));else if("function"==typeof e){var n=e();t._resolveCallback(n)}},t.prototype._setPromiseCallbacks=function(e,t){this._resolveCallback=e,this._rejectCallback=t},function(n,i){var o;return o=Request.prototype.isPrototypeOf(n)&&!i?n:new Request(n,i),e.getRegistration(o.url).then((function(n){if(null!=n){var i=new t(o),s=function(e,t,n){var i,o,s,a,c=null,u=e._registrations,l=null!=u?u.length:0;for(i=0;i<l;i++)if(s=u[i],null!=n.request.url.match(s.scope)){for(a=s._eventListeners.length,o=0;o<a;o++)s._eventListeners[o].type==t&&(null===c&&n._setPromiseCallbacks instanceof Function&&(c=new Promise((function(e,t){n._setPromiseCallbacks(e,t)}))),r.log("Offline Persistence Toolkit PersistenceManager: Calling fetch event listener"),s._eventListeners[o].listener(n));if(null!=c)return c}return!0}(e,"fetch",i);if(null!=s&&s instanceof Promise)return s}return e.browserFetch(o)}))}}(t),window.XMLHttpRequest=function(){return null!=t._browserFetchRequest?new t._browserXMLHttpRequest:new e(t._browserXMLHttpRequest)})}(this),function(e){var t=e;o()&&!t._addedBrowserEventListeners&&(r.log("Offline Persistence Toolkit PersistenceManager: Adding browser event listeners"),window.addEventListener("offline",(function(e){t._isOffline=!0}),!1),window.addEventListener("online",(function(e){t._isOffline=!1}),!1),t._addedBrowserEventListeners=!0)}(this),this._cache=n.open("systemCache"),Promise.resolve()},i.prototype.forceOffline=function(e){r.log("Offline Persistence Toolkit PersistenceManager: forceOffline is called with value: "+e),this._forceOffline=e},i.prototype.getCache=function(){return this._cache},i.prototype.isOnline=function(){var e=navigator.onLine;return navigator.network&&navigator.network.connection&&navigator.network.connection.type==Connection.NONE&&(e=!1,r.log("Offline Persistence Toolkit PersistenceManager: Cordova network info plugin is returning online value: "+e)),e&&!this._isOffline&&!this._forceOffline},i.prototype.register=function(e){var t=new s((e=e||{}).scope,this);return this._registrations.push(t),Promise.resolve(t)},i.prototype.getRegistration=function(e){var t,n,r=this._registrations.length;for(t=0;t<r;t++)if(n=this._registrations[t],e.match(n.scope))return Promise.resolve(n);return Promise.resolve()},i.prototype.getRegistrations=function(){return Promise.resolve(this._registrations.slice())},i.prototype.getSyncManager=function(){return this._persistenceSyncManager},i.prototype.browserFetch=function(e){var t=this;r.log("Offline Persistence Toolkit PersistenceManager: browserFetch() for Request with url: "+e.url);var n=e;return o()?(Object.defineProperty(this,"_browserFetchRequest",{value:e,writable:!0}),new Promise((function(i,o){r.log("Offline Persistence Toolkit PersistenceManager: Calling browser fetch function for Request with url: "+e.url),e._browserRequest&&(n=e._browserRequest),t._browserFetchFunc.call(window,n).then((function(e){i(e)}),(function(e){o(e)})),t._browserFetchRequest=null}))):(e._browserRequest&&(n=e._browserRequest),fetch(n))},s.prototype.addEventListener=function(e,t){this._eventListeners.push({type:e.toLowerCase(),listener:t})},s.prototype.unregister=function(){return Promise.resolve(function(e,t){var n=e,r=n._registrations.indexOf(t);return r>-1&&(n._registrations.splice(r,1),!0)}(this._persistenceManager,this))},new i}));