/**
 * Copyright (c) 2017, Oracle and/or its affiliates.
 * All rights reserved.
 */

define(["../PersistenceStore","../impl/storageUtils","pouchdb","./logger"],(function(e,t,r,n){"use strict";var i=function(t){e.call(this,t)};(i.prototype=new e).Init=function(e){this._version=e&&e.version||"0";var t=this._name+this._version,i=e?e.adapter:null,o=this._extractDBOptions(e);if(i)try{i.plugin&&r.plugin(i.plugin),(o=o||{}).adapter=i.name,this._dbOptions=o,this._db=new r(t,o)}catch(e){return n.log("Error creating PouchDB instance with adapter "+i+": ",e.message),n.log("Please make sure the needed plugin and adapter are installed."),Promise.reject(e)}else o?(this._dbOptions=o,this._db=new r(t,o)):(this._dbOptions=null,this._db=new r(t));return e&&e.index&&(Array.isArray(e.index)?(this._index=e.index.filter((function(e){return"key"!==e})),0===this._index.length&&(this._index=null)):n.log("index must be an array")),this._createIndex()},i.prototype._extractDBOptions=function(e){var t=null;if(e){var r=this;Object.keys(e).forEach((function(n){r._isPersistenceStoreKey(n)||(t||(t={}),t[n]=e[n])}))}return t},i.prototype._isPersistenceStoreKey=function(e){return"version"===e||"adapter"===e||"index"===e||"skipMetadata"===e},i.prototype._createIndex=function(){if(this._index&&this._db.createIndex){var e=this,t=e._name+e._index.toString().replace(",","").replace(".",""),r={index:{fields:e._index,name:t}};return e._db.createIndex(r).catch((function(t){n.error("creating index on "+e._index.toString()+" failed with error "+t)}))}return Promise.resolve()},i.prototype.upsert=function(e,t,r,i){n.log("Offline Persistence Toolkit pouchDBPersistenceStore: upsert() for key: "+e);var s=this,a=e.toString();return s._db.get(a).then((function(e){return o(i,e)?e:Promise.reject({status:409})})).catch((function(e){return 404===e.status&&"missing"===e.message?void 0:Promise.reject(e)})).then((function(e){return s._put(a,t,r,i,e)}))},i.prototype._put=function(e,t,r,n,i){var o=[],s=this._prepareUpsert(r,o),a={_id:e,key:e,metadata:t,value:s?null:r};i&&(a._rev=i._rev);var u=this;return u._db.put(a).then((function(t){return u._addAttachments(e,t.rev,o)})).catch((function(e){if(409!==e.status)throw e}))};var o=function(e,t){return!e||t.metadata.versionIdentifier===e};i.prototype._addAttachments=function(e,t,r){if(r&&r.length){var i=this,o=r.map((function(r){var n;return n=r.value instanceof Blob?r.value:new Blob([r.value]),i._db.putAttachment(e,r.path,t,n,"binary")}),this);return Promise.all(o).catch((function(t){n.error("store: "+i._name+" failed add attachment for doc "+e)}))}return Promise.resolve()},i.prototype.upsertAll=function(e){if(n.log("Offline Persistence Toolkit pouchDBPersistenceStore: upsertAll()"),e&&e.length){var t=this,r={},i=e.map((function(e){var n=e.key.toString(),i=e.value,o=[],s=t._prepareUpsert(i,o);o.length>0&&(r[n]=o);var a={_id:n,key:e.key,metadata:e.metadata,value:s?null:i};return t._db.get(n).then((function(e){return a._rev=e._rev,a})).catch((function(e){if(404===e.status&&"missing"===e.message)return a;throw e}))}));return Promise.all(i).then((function(e){return t._db.bulkDocs(e)})).then((function(e){var i=[];if(e.forEach((function(e,o){if(e.ok){var s=r[e.id];s&&i.push(t._addAttachments(e.id,e.rev,s))}else 409===e.status&&n.log("conflict error")})),i.length>0)return Promise.all(i)})).catch((function(e){n.log("error in upsertAll")}))}return Promise.resolve()},i.prototype.find=function(e){n.log("Offline Persistence Toolkit pouchDBPersistenceStore: find() for expression: "+JSON.stringify(e));var r=this;if(e=e||{},r._db.find){var i=r._prepareFind(e);return r._db.find(i).then((function(e){if(e&&e.docs&&e.docs.length){var t=e.docs.map(r._findResultCallback(i.fields),r);return Promise.all(t)}return[]})).catch((function(e){if(404===e.status&&"missing"===e.message)return[];throw e}))}return r._db.allDocs({include_docs:!0}).then((function(n){if(n&&n.rows&&n.rows.length){var i=n.rows.filter((function(r){var n=r.doc;return!(s(r)||!t.satisfy(e.selector,n))}));if(i.length){var o=i.map((function(e){return r._fixKey(e.doc),e.doc})),a=t.sortRows(o,e.sort).map((function(n){return r._fixBinaryValue(n).then((function(r){return e.fields?t.assembleObject(r,e.fields):r.value}))}));return Promise.all(a)}return[]}return[]})).catch((function(e){return n.log("error retrieving all documents from pouch db, returns empty list as find operation.",e),[]}))},i.prototype._findResultCallback=function(e){return function(t){return this._fixValue(t).then((function(t){return e?t:t.value}))}},i.prototype._fixValue=function(e){return this._fixKey(e),this._fixBinaryValue(e)},i.prototype._fixBinaryValue=function(e){var t=e._id||e.id||e.key,r=e._attachments;if(r){var i=this,o=Object.keys(r)[0];return i._db.getAttachment(t,o).then((function(t){if("rootpath"===o)e.value=t;else{for(var r=o.split("."),n=e.value,i=0;i<r.length-1;i++)n=n[r[i]];n[r[r.length-1]]=t}return e})).catch((function(e){n.error("store: "+i._name+" error getting attachment. ")}))}return Promise.resolve(e)},i.prototype.findByKey=function(e){n.log("Offline Persistence Toolkit pouchDBPersistenceStore: findByKey() for key: "+e);var t=this,r=e.toString();return t._db.get(r,{attachments:!0}).then((function(e){return t._fixBinaryValue(e)})).then((function(e){return e.value})).catch((function(e){return 404===e.status&&"missing"===e.message?void 0:Promise.reject(e)}))},i.prototype.removeByKey=function(e){n.log("Offline Persistence Toolkit pouchDBPersistenceStore: removeByKey() for key: "+e);var t=this;if(!e)return Promise.resolve(!1);var r=e.toString();return t._db.get(r).then((function(e){return t._db.remove(e)})).then((function(){return!0})).catch((function(e){return(404!==e.status||"missing"!==e.message)&&Promise.reject(e)}))},i.prototype.delete=function(e){n.log("Offline Persistence Toolkit pouchDBPersistenceStore: delete() for expression: "+JSON.stringify(e));var t=this;if(e){var i=e;return i.fields=["_id","_rev"],t.find(i).then((function(e){if(e&&e.length){var r=e.map((function(e){return{_id:e._id,_rev:e._rev,_deleted:!0}}));return t._db.bulkDocs(r)}})).catch((function(e){n.error("store: "+t._name+" error deleting....")}))}return t._db.destroy().then((function(){var e=t._name+t._version;return t._dbOptions?t._db=new r(e,t._dbOptions):t._db=new r(e),t._createIndex()})).catch((function(e){n.error("store: "+t._name+" error deleting....")}))},i.prototype.keys=function(){n.log("Offline Persistence Toolkit pouchDBPersistenceStore: keys()");var e=this;return e._db.allDocs().then((function(e){var t=e.rows,r=[];if(t&&t.length)for(var n=0;n<t.length;n++)s(t[n])||r.push(t[n].id);return r})).catch((function(t){n.error("store: "+e._name+" error getting all the docs for keys ")}))},i.prototype._prepareFind=function(e){var t={},r=e.selector;r?r&&(t.selector=r):t.selector={_id:{$gt:null}};var n=e.fields;return n&&n.length&&(t.fields=n,-1!==n.indexOf("key")&&-1===n.indexOf("_id")&&t.fields.push("_id")),t},i.prototype._prepareUpsert=function(e,t){return!!e&&(e instanceof Blob||e instanceof ArrayBuffer?(t.push({path:"rootpath",value:e}),!0):(this._inspectValue("",e,t),!1))},i.prototype._inspectValue=function(e,t,r){for(var n in t)if(t.hasOwnProperty(n)){var i=t[n];if(i&&"object"==typeof i)if(i instanceof Blob||i instanceof ArrayBuffer){var o=e;o.length>0&&(o+=".");var s={path:o+n,value:i};r.push(s),t.key=null}else if(void 0===i.length){var a=e;e.length>0&&(e+="."),e+=n,this._inspectValue(e,i,r),e=a}}},i.prototype.updateKey=function(e,t){n.log("Offline Persistence Toolkit PouchDBPersistenceStore: updateKey() with currentKey: "+e+" and new key: "+t);var r=this;return r._db.get(e).then((function(e){return e?r.upsert(t,e.metadata,e.value):Promise.reject("No existing key found to update")})).then((function(){return r.removeByKey(e)})).catch((function(){n.error("store: "+r._name+" error updating key")}))};var s=function(e){return e.id.startsWith("_design/")};return i.prototype._fixKey=function(e){var t=e._id||e.id||e.key;t&&(e.key=t)},i}));