/**
 * Copyright (c) 2017, Oracle and/or its affiliates.
 * All rights reserved.
 */

define(["./persistenceManager","./persistenceUtils","./fetchStrategies","./cacheStrategies","./persistenceStoreManager","./impl/defaultCacheHandler","./impl/logger"],(function(e,t,n,r,o,s,i){"use strict";function l(e){null==(e=e||{}).fetchStrategy&&(e.fetchStrategy=n.getCacheIfOfflineStrategy()),null==e.cacheStrategy&&(e.cacheStrategy=r.getHttpCacheHeaderStrategy()),e.requestHandlerOverride=e.requestHandlerOverride||{},null==e.requestHandlerOverride.handleGet&&(e.requestHandlerOverride.handleGet=this.handleGet),null==e.requestHandlerOverride.handlePost&&(e.requestHandlerOverride.handlePost=this.handlePost),null==e.requestHandlerOverride.handlePut&&(e.requestHandlerOverride.handlePut=this.handlePut),null==e.requestHandlerOverride.handlePatch&&(e.requestHandlerOverride.handlePatch=this.handlePatch),null==e.requestHandlerOverride.handleDelete&&(e.requestHandlerOverride.handleDelete=this.handleDelete),null==e.requestHandlerOverride.handleHead&&(e.requestHandlerOverride.handleHead=this.handleHead),null==e.requestHandlerOverride.handleOptions&&(e.requestHandlerOverride.handleOptions=this.handleOptions),Object.defineProperty(this,"_options",{value:e})}function u(t){return e.isOnline()?e.browserFetch(t):Promise.resolve(new Response(null,{status:503,statusText:"Must provide handlePost override for offline"}))}function a(e,t){var n=e;return(0,n._options.fetchStrategy)(t,n._options)}function d(e,n){return i.log("Offline Persistence Toolkit DefaultResponseProxy: Processing offline logic for default PUT Handler"),t.requestToJSON(n).then((function(e){e.status=200,e.statusText="OK",e.headers["content-type"]="application/json",e.headers["x-oracle-jscpt-cache-expiration-date"]="";var n=e.headers["if-match"],r=e.headers["if-none-match"];if(n||r){i.log("Offline Persistence Toolkit DefaultResponseProxy: Generating ETag for offline Response for default PUT Handler");var o=Math.floor(1e6*Math.random());e.headers.etag=(Date.now()+o).toString(),e.headers["x-oracle-jscpt-etag-generated"]=e.headers.etag,delete e.headers["if-match"],delete e.headers["if-none-match"]}return t.responseFromJSON(e)}))}function f(e,n){var r=e;return i.log("Offline Persistence Toolkit DefaultResponseProxy: Processing offline logic for default DELETE Handler"),t.requestToJSON(n).then((function(e){return e.status=200,e.statusText="OK",e.headers["content-type"]="application/json",e.headers["x-oracle-jscpt-cache-expiration-date"]="",t.responseFromJSON(e).then((function(s){var i=h(n),l=null;return r._options&&r._options.jsonProcessor&&r._options.jsonProcessor.shredder&&(l=r._options.jsonProcessor.shredder),l?l(s).then((function(n){if(n){var r=n[0].name;return o.openStore(r).then((function(n){return n.findByKey(i).then((function(n){return n?t.responseFromJSON(e).then((function(e){return t.setResponsePayload(e,n).then((function(e){return e}))})):s}))}))}return s})):s}))}))}function c(e,t,n,r){var o=e;return n.status<500?Promise.resolve(n):r(o,t)}function h(e){var t=e.url.split("/");return t[t.length-1]}function p(t,n,r){return!e.isOnline()||r?e.getSyncManager().insertRequest(t,{undoRedoDataArray:n}):Promise.resolve()}function h(e){var t=e.url.split("/");return t.length>1?t[t.length-1].split("?")[0]:null}return l.prototype.getFetchEventListener=function(){var e=this;return function(t){t.respondWith(e.processRequest(t.request))}},l.prototype.processRequest=function(n){var r=this,l=t.buildEndpointKey(n);return new Promise((function(u,a){s.registerEndpointOptions(l,r._options);var d=function(e,n){var r=e,o=r._options,s=null;return t.isReplayRequest(n)?s=r.handleSyncReplay:"POST"===n.method?s=o.requestHandlerOverride.handlePost:"GET"===n.method?s=o.requestHandlerOverride.handleGet:"PUT"===n.method?s=o.requestHandlerOverride.handlePut:"PATCH"===n.method?s=o.requestHandlerOverride.handlePatch:"DELETE"===n.method?s=o.requestHandlerOverride.handleDelete:"HEAD"===n.method?s=o.requestHandlerOverride.handleHead:"OPTIONS"===n.method&&(s=o.requestHandlerOverride.handleOptions),s}(r,n),f={};f.isReplayRequest=t.isReplayRequest(n);var c=n.clone();i.log("Offline Persistence Toolkit DefaultResponseProxy: Calling requestHandler for request with enpointKey: "+l),d.call(r,n).then((function(e){return t.isCachedResponse(e)&&(i.log("Offline Persistence Toolkit DefaultResponseProxy: Response is cached for request with enpointKey: "+l),f.isCachedResponse=!0),e.ok?(i.log("Offline Persistence Toolkit DefaultResponseProxy: Response is ok for request with enpointKey: "+l),function(e,t,n){var r=e;return"GET"===t.method||"HEAD"===t.method?(0,r._options.cacheStrategy)(t,n,r._options):Promise.resolve(n)}(r,n,e)):(i.log("Offline Persistence Toolkit DefaultResponseProxy: Response is not ok for request with enpointKey: "+l),e)})).then((function(e){return f.response=e,e.ok?(i.log("Offline Persistence Toolkit DefaultResponseProxy: Response is ok after cacheStrategy for request with enpointKey: "+l),function(e,t){return"GET"==e.method||"HEAD"==e.method?Promise.resolve():function(e,t){return s.constructShreddedData(e,t).then((function(t){return t?function(e,t){var n=[];return t.forEach((function(t){var r=Object.keys(t)[0];n.push(function(e,t,n){return function(e,t,n){var r,s,i=[],l=function(n,u){return n<u.length&&"GET"!==e.method&&"HEAD"!==e.method?u[n].key?(r=u[n].key.toString(),s="DELETE"!==e.method?u[n].value:null,o.openStore(t).then((function(e){return e.findByKey(r).then((function(e){return i.push({key:r,undo:e,redo:s}),l(++n,u)}),(function(e){return i.push({key:r,undo:null,redo:s}),l(++n,u)}))}))):l(++n,u):Promise.resolve(i)};return l(0,n)}(e,t,n).then((function(r){if("DELETE"===e.method){if(!n||0===n.length){var s=h(e);n=[{key:s}]}return function(e,t,n){return o.openStore(e).then((function(e){return e.removeByKey(t[0].key)})).then((function(){return n.length>0?{storeName:e,operation:"remove",undoRedoData:n}:null}))}(t,n,r)}return function(e,t,n){return o.openStore(e).then((function(e){return e.upsertAll(t)})).then((function(){return n.length>0?{storeName:e,operation:"upsert",undoRedoData:n}:null}))}(t,n,r)}))}(e,r,t[r]))})),Promise.all(n)}(e,t):Promise.resolve()}))}(e,t)}(n,e)):(i.log("Offline Persistence Toolkit DefaultResponseProxy: Response is not ok after cacheStrategy for request with enpointKey: "+l),null)})).then((function(t){if(!f.isReplayRequest)return p(n,t,f.isCachedResponse&&!e.isOnline())})).then((function(){s.unregisterEndpointOptions(l),u(f.response)})).catch((function(e){i.log("Offline Persistence Toolkit DefaultResponseProxy: Insert Response in syncManager after error for request with enpointKey: "+l),f.isReplayRequest?(s.unregisterEndpointOptions(l),a(e)):p(c,null,!0).then((function(){s.unregisterEndpointOptions(l),a(e)}),(function(){s.unregisterEndpointOptions(l),a(e)}))}))}))},l.prototype.handlePost=function(e){return i.log("Offline Persistence Toolkit DefaultResponseProxy: Processing Request with default POST Handler"),u(e)},l.prototype.handleSyncReplay=function(n){return i.log("Offline Persistence Toolkit DefaultResponseProxy: Processing Request from Sync Replay"),t.markReplayRequest(n,!1),e.browserFetch(n)},l.prototype.handleGet=function(e){return i.log("Offline Persistence Toolkit DefaultResponseProxy: Processing Request with default GET Handler"),a(this,e)},l.prototype.handleHead=function(e){return i.log("Offline Persistence Toolkit DefaultResponseProxy: Processing Request with default HEAD Handler"),a(this,e)},l.prototype.handleOptions=function(e){return i.log("Offline Persistence Toolkit DefaultResponseProxy: Processing Request with default OPTIONS Handler"),u(e)},l.prototype.handlePut=function(t){return i.log("Offline Persistence Toolkit DefaultResponseProxy: Processing Request with default PUT Handler"),function(t,n){var r=t;return e.isOnline()?e.browserFetch(n.clone()).then((function(e){return e.ok?(i.log("Offline Persistence Toolkit DefaultResponseProxy: Response is ok for default PUT Handler"),e):c(r,n,e,d)}),(function(e){return d(0,n)})):d(0,n)}(this,t)},l.prototype.handlePatch=function(e){return i.log("Offline Persistence Toolkit DefaultResponseProxy: Processing Request with default PATCH Handler"),u(e)},l.prototype.handleDelete=function(t){return i.log("Offline Persistence Toolkit DefaultResponseProxy: Processing Request with default DELETE Handler"),function(t,n){var r=t;return e.isOnline()?e.browserFetch(n.clone()).then((function(e){return e.ok?(i.log("Offline Persistence Toolkit DefaultResponseProxy: Response is ok for default DELETE Handler"),e):c(r,n,e,f)}),(function(e){return f(r,n)})):f(r,n)}(this,t)},{getResponseProxy:function(e){return new l(e)}}}));