'use strict';

var chai = require('chai');

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n["default"] = e;
  return Object.freeze(n);
}

// CJS-only
if (typeof process !== 'undefined') {
    describe('Aggregate index test', () => {
        it('index.js', async () => {
            // @ts-ignore
            const index = await Promise.resolve().then(function () { return /*#__PURE__*/_interopNamespace(require('./index')); });
            // Expect title-case named exports
            const keys = Object.keys(index);
            chai.expect(keys.length).at.least(1);
            keys.forEach(key => {
                chai.expect(key).match(/^[A-Z][a-z].+/);
                chai.expect(key).not.match(/^UNSAFE_/);
            });
        });
        it('types/index.d.ts', async () => {
            const { default: fs } = await Promise.resolve().then(function () { return /*#__PURE__*/_interopNamespace(require('fs')); });
            const contents = fs.readFileSync('./dist/types/index.d.ts').toString();
            chai.expect(contents.length).greaterThan(0);
        });
    });
}
//# sourceMappingURL=index.spec.js.map
