'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var preact = require('preact');

const hiddenAccessibleStyle = "oj-hidden-accessible-hiddenAccessibleStyle-hbvw96q";
/**
 * HiddenAccessible is a helper component that hides its children visually,
 * but keeps them visible to screen readers.
 *
 */

function HiddenAccessible({
  children
}) {
  return preact.h("span", {
    class: hiddenAccessibleStyle
  }, children);
}

exports.HiddenAccessible = HiddenAccessible;
