'use strict';

var preact$1 = require('preact');
var preact = require('@testing-library/preact');
var chai = require('chai');
var UNSAFE_Message = require('@oracle/oraclejet-preact/UNSAFE_Message');

describe('Test MessageStartIcon component', () => {
    for (const severity in UNSAFE_Message.severities) {
        if (severity === 'none') {
            continue;
        }
        it(`severity ${severity}`, async function () {
            const content = preact.render(preact$1.h(UNSAFE_Message.MessageStartIcon, { severity: severity }));
            const icon = content.container.firstElementChild;
            chai.expect(icon).not.null;
        });
    }
});
//# sourceMappingURL=MessageStartIcon.spec.js.map
