'use strict';

var chai = require('chai');
var UNSAFE_Message = require('@oracle/oraclejet-preact/UNSAFE_Message');

describe('Test MessageFormattingUtils', () => {
    it('isValidValueForProp', function () {
        // severity prop:
        // valid severities
        UNSAFE_Message.severities.forEach(severity => {
            chai.expect(UNSAFE_Message.isValidValueForProp(severity, 'severity')).to.be.true;
        });
        // invalid severity
        chai.expect(UNSAFE_Message.isValidValueForProp('foo', 'severity')).to.be.false;
        // timestamp prop:
        // valid ISO string
        chai.expect(UNSAFE_Message.isValidValueForProp(new Date().toISOString(), 'timestamp')).to.be.true;
        // invalid ISO string
        chai.expect(UNSAFE_Message.isValidValueForProp('foo', 'timestamp')).to.be.false;
        // string prop:
        // valid string
        chai.expect(UNSAFE_Message.isValidValueForProp('foo', 'string')).to.be.true;
        // invalid strings
        chai.expect(UNSAFE_Message.isValidValueForProp('', 'string')).to.be.false;
        chai.expect(UNSAFE_Message.isValidValueForProp(null, 'string')).to.be.false;
        chai.expect(UNSAFE_Message.isValidValueForProp(undefined, 'string')).to.be.false;
    });
    it('formatTimestamp', function () {
        const validTimestamp = UNSAFE_Message.formatTimestamp(new Date().toISOString());
        chai.expect(UNSAFE_Message.isValidValueForProp(validTimestamp, 'string')).to.be.true;
        // formatting an invalid timestamp should throw an error, but if not, verify that it's
        // not a valid string prop
        try {
            const invalidTimestamp = UNSAFE_Message.formatTimestamp('foo');
            chai.expect(UNSAFE_Message.isValidValueForProp(invalidTimestamp, 'timestamp')).to.be.false;
        }
        catch (e) {
            chai.expect(e).not.null;
        }
    });
});
//# sourceMappingURL=MessageFormattingUtils.spec.js.map
