'use strict';

var preact$1 = require('preact');
var preact = require('@testing-library/preact');
var chai = require('chai');
var UNSAFE_Message = require('@oracle/oraclejet-preact/UNSAFE_Message');

const messageTemplateItem = {
    data: {
        detail: 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.'
    },
    index: 0,
    key: 'ConfirmationMessage',
    metadata: { key: 'ConfirmationMessage' }
};
describe('Test MessageDetail component', () => {
    it('default renderer', async function () {
        const content = preact.render(preact$1.h(UNSAFE_Message.MessageDetail, { item: messageTemplateItem }));
        const detail = await content.findByText('Lorem Ipsum is simply dummy text of the printing and typesetting industry.');
        chai.expect(detail).not.null;
    });
    it('custom renderer', async function () {
        const detailRenderer = ({ data, index, key, metadata }) => (preact$1.h("div", { style: 'border: 1px solid gray; padding: 5px; background-color: orange;', "data-testid": 'customWrapper' },
            preact$1.h("div", null,
                "index: ",
                index),
            preact$1.h("div", null,
                "key: ",
                key),
            preact$1.h("div", null,
                "detail: ",
                data.detail),
            preact$1.h("div", null,
                "metadata key: ", metadata === null || metadata === void 0 ? void 0 :
                metadata.key)));
        const content = preact.render(preact$1.h(UNSAFE_Message.MessageDetail, { item: messageTemplateItem, renderer: detailRenderer }));
        const customWrapper = await content.findByTestId('customWrapper');
        chai.expect(customWrapper).not.null;
        chai.expect(customWrapper === null || customWrapper === void 0 ? void 0 : customWrapper.style.backgroundColor).to.equal('orange');
        const index = await content.findByText('index: 0');
        chai.expect(index).not.null;
        const key = await content.findByText('key: ConfirmationMessage');
        chai.expect(key).not.null;
        const detail = await content.findByText('detail: Lorem Ipsum is simply dummy text of the printing and typesetting industry.');
        chai.expect(detail).not.null;
        const metadataKey = await content.findByText('metadata key: ConfirmationMessage');
        chai.expect(metadataKey).not.null;
    });
});
//# sourceMappingURL=MessageDetail.spec.js.map
