'use strict';

var preact$1 = require('preact');
var preact = require('@testing-library/preact');
var userEvent = require('@testing-library/user-event');
var chai = require('chai');
var UNSAFE_Message = require('@oracle/oraclejet-preact/UNSAFE_Message');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var userEvent__default = /*#__PURE__*/_interopDefaultLegacy(userEvent);

describe('Test MessageCloseButton component', () => {
    it('default renderer', async function () {
        const clickListenerObj = {
            clicked: false
        };
        const handleClick = function () {
            clickListenerObj.clicked = true;
        };
        const content = preact.render(preact$1.h(UNSAFE_Message.MessageCloseButton, { onAction: handleClick }));
        const button = await content.findByText('X');
        chai.expect(button).not.null;
        userEvent__default["default"].click(button);
        chai.expect(clickListenerObj.clicked).to.be.true;
    });
    it('custom button renderer', async function () {
        const buttonRenderer = (title, onAction, _variant) => (preact$1.h("button", { style: 'background-color: orange;', "aria-label": title, onClick: onAction, title: title }, title));
        const clickListenerObj = {
            clicked: false
        };
        const handleClick = function () {
            clickListenerObj.clicked = true;
        };
        const content = preact.render(preact$1.h(UNSAFE_Message.MessageCloseButton, { onAction: handleClick, buttonRenderer: buttonRenderer }));
        const button = await content.findByText('Close');
        chai.expect(button).not.null;
        chai.expect(button.style.backgroundColor).to.equal('orange');
        userEvent__default["default"].click(button);
        chai.expect(clickListenerObj.clicked).to.be.true;
    });
});
//# sourceMappingURL=MessageCloseButton.spec.js.map
