'use strict';

var preact$1 = require('preact');
var preact = require('@testing-library/preact');
var chai = require('chai');
var UNSAFE_Flex = require('@oracle/oraclejet-preact/UNSAFE_Flex');
var UNSAFE_HiddenAccessible = require('@oracle/oraclejet-preact/UNSAFE_HiddenAccessible');

describe('Test HiddenAccessible component', () => {
    it('render', async function () {
        const content = preact.render(preact$1.h(UNSAFE_HiddenAccessible.HiddenAccessible, null, "Text"));
        const sampleText = await content.findByText('Text');
        chai.expect(sampleText).not.null;
    });
    it('render with <Flex> inside', async function () {
        const content = preact.render(preact$1.h(UNSAFE_HiddenAccessible.HiddenAccessible, null,
            preact$1.h(UNSAFE_Flex.Flex, null, "flex text")));
        const sampleText = await content.findByText('flex text');
        chai.expect(sampleText).not.null;
    });
});
//# sourceMappingURL=HiddenAccessible.spec.js.map
