define(['chai', '@oracle/oraclejet-preact/utils/stringUtils'], (function (chai, StringUtils) { 'use strict';

  function _interopNamespace(e) {
    if (e && e.__esModule) return e;
    var n = Object.create(null);
    if (e) {
      Object.keys(e).forEach(function (k) {
        if (k !== 'default') {
          var d = Object.getOwnPropertyDescriptor(e, k);
          Object.defineProperty(n, k, d.get ? d : {
            enumerable: true,
            get: function () { return e[k]; }
          });
        }
      });
    }
    n["default"] = e;
    return Object.freeze(n);
  }

  var StringUtils__namespace = /*#__PURE__*/_interopNamespace(StringUtils);

  describe('Test StringUtils', () => {
      it('isEmpty', function () {
          // null
          chai.expect(StringUtils__namespace.isEmpty(null)).to.be.true;
          // string
          chai.expect(StringUtils__namespace.isEmpty('')).to.be.true;
          chai.expect(StringUtils__namespace.isEmpty('     ')).to.be.true;
          chai.expect(StringUtils__namespace.isEmpty('foo')).to.be.false;
          // object
          chai.expect(StringUtils__namespace.isEmpty({})).to.be.true;
          chai.expect(StringUtils__namespace.isEmpty({ foo: 'bar' })).to.be.true;
          chai.expect(StringUtils__namespace.isEmpty([])).to.be.true;
          chai.expect(StringUtils__namespace.isEmpty(['foo'])).to.be.false;
      });
      it('isEmptyOrUndefined', function () {
          // undefined
          chai.expect(StringUtils__namespace.isEmptyOrUndefined(undefined)).to.be.true;
          // null
          chai.expect(StringUtils__namespace.isEmptyOrUndefined(null)).to.be.true;
          // string
          chai.expect(StringUtils__namespace.isEmptyOrUndefined('')).to.be.true;
          chai.expect(StringUtils__namespace.isEmptyOrUndefined('     ')).to.be.true;
          chai.expect(StringUtils__namespace.isEmptyOrUndefined('foo')).to.be.false;
          // object
          chai.expect(StringUtils__namespace.isEmptyOrUndefined({})).to.be.true;
          chai.expect(StringUtils__namespace.isEmptyOrUndefined({ foo: 'bar' })).to.be.true;
          chai.expect(StringUtils__namespace.isEmptyOrUndefined([])).to.be.true;
          chai.expect(StringUtils__namespace.isEmptyOrUndefined(['foo'])).to.be.false;
      });
      it('isString', function () {
          // null
          chai.expect(StringUtils__namespace.isString(null)).to.be.false;
          // string
          chai.expect(StringUtils__namespace.isString('')).to.be.true;
          chai.expect(StringUtils__namespace.isString('     ')).to.be.true;
          chai.expect(StringUtils__namespace.isString('foo')).to.be.true;
          // object
          chai.expect(StringUtils__namespace.isString({})).to.be.false;
          chai.expect(StringUtils__namespace.isString({ foo: 'bar' })).to.be.false;
          chai.expect(StringUtils__namespace.isString([])).to.be.false;
          chai.expect(StringUtils__namespace.isString(['foo'])).to.be.false;
          chai.expect(StringUtils__namespace.isString(new String('foo'))).to.be.true;
      });
      it('trim', function () {
          let str;
          // null
          chai.expect(StringUtils__namespace.trim(null)).null;
          // string
          str = '';
          chai.expect(StringUtils__namespace.trim(str)).equal(str);
          chai.expect(StringUtils__namespace.trim('     ')).equal(str);
          str = 'foo';
          chai.expect(StringUtils__namespace.trim(str)).equal(str);
          chai.expect(StringUtils__namespace.trim('  foo  ')).equal(str);
          // object
          str = {};
          chai.expect(StringUtils__namespace.trim(str)).equal(str);
          str = { foo: 'bar' };
          chai.expect(StringUtils__namespace.trim(str)).equal(str);
          str = [];
          chai.expect(StringUtils__namespace.trim(str)).equal(str);
          str = ['foo'];
          chai.expect(StringUtils__namespace.trim(str)).equal(str);
          str = new String('  foo  ');
          chai.expect(StringUtils__namespace.trim(str)).equal('foo');
      });
      it('hashCode', function () {
          const hash1 = StringUtils__namespace.hashCode('foo');
          const hash2 = StringUtils__namespace.hashCode('bar');
          chai.expect(typeof hash1).equal('number');
          chai.expect(typeof hash2).equal('number');
          chai.expect(hash1).not.equal(hash2);
          chai.expect(StringUtils__namespace.hashCode('foo')).equal(hash1);
      });
  });

}));
//# sourceMappingURL=stringUtils.spec.js.map
