define(['preact', '@testing-library/preact', 'chai', '@oracle/oraclejet-preact/UNSAFE_Message'], (function (preact$1, preact, chai, UNSAFE_Message) { 'use strict';

  const DATA = [
      {
          key: "ErrorMessage",
          data: {
              severity: "error",
              summary: "Primary Text",
              detail: "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum is simply dummy text of the printing and typesetting industry.",
              closeAffordance: "on",
              timestamp: new Date().toISOString()
          }
      },
      {
          key: "WarningMessage",
          data: {
              severity: "warning",
              summary: "Primary Text",
              detail: "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum is simply dummy text of the printing and typesetting industry.",
              closeAffordance: "on",
              timestamp: new Date().toISOString()
          }
      },
      {
          key: "ConfirmationMessage",
          data: {
              severity: "confirmation",
              summary: "Primary Text",
              detail: "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum is simply dummy text of the printing and typesetting industry.",
              closeAffordance: "on",
              timestamp: new Date().toISOString()
          }
      },
      {
          key: "InfoMessage",
          data: {
              severity: "info",
              summary: "Primary Text",
              detail: "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum is simply dummy text of the printing and typesetting industry.",
              closeAffordance: "on",
              timestamp: new Date().toISOString()
          }
      }
  ];
  const START_ANIM = (_element, _action, _effects, _component) => Promise.resolve(true);
  describe('Test MessagesManager component', () => {
      it('child renderer', async function () {
          const content = preact.render(preact$1.h(UNSAFE_Message.MessagesManager, { data: DATA, startAnimation: START_ANIM }, ({ index, item }) => (preact$1.h("div", { style: "border: 1px solid gray; padding: 5px; background-color: orange;", "data-testid": item.key },
              preact$1.h("div", null,
                  "index: ",
                  index),
              preact$1.h("div", null,
                  "key: ",
                  item.key),
              preact$1.h("div", null,
                  "severity: ",
                  item.data.severity),
              preact$1.h("div", null,
                  "summary: ",
                  item.data.summary),
              preact$1.h("div", null,
                  "detail: ",
                  item.data.detail),
              preact$1.h("div", null,
                  "timestamp: ",
                  item.data.timestamp)))));
          // since the function we're passing to Array.map is async, we need to wait on all
          // those return promises before continuing, hence the "await Promise.all()"
          await Promise.all(DATA.map(async (item) => {
              const message = await content.findByTestId(item.key);
              chai.expect(message).not.null;
              chai.expect(message.style.backgroundColor).to.equal('orange');
              // just look for a single field as an example, no need to find every field
              const sevElem = await content.findByText(`severity: ${item.data.severity}`);
              chai.expect(sevElem).not.null;
          }));
      });
  });

}));
//# sourceMappingURL=MessagesManager.spec.js.map
