define(['preact', 'chai', '@oracle/oraclejet-preact/UNSAFE_Message'], (function (preact, chai, MessageUtils) { 'use strict';

  function _interopNamespace(e) {
    if (e && e.__esModule) return e;
    var n = Object.create(null);
    if (e) {
      Object.keys(e).forEach(function (k) {
        if (k !== 'default') {
          var d = Object.getOwnPropertyDescriptor(e, k);
          Object.defineProperty(n, k, d.get ? d : {
            enumerable: true,
            get: function () { return e[k]; }
          });
        }
      });
    }
    n["default"] = e;
    return Object.freeze(n);
  }

  var MessageUtils__namespace = /*#__PURE__*/_interopNamespace(MessageUtils);

  describe('Test MessageUtils', () => {
      it('throwError', function () {
          try {
              MessageUtils__namespace.throwError('foo');
              chai.expect(true).to.be.false;
          }
          catch (e) {
              chai.expect(e).not.null;
          }
      });
      it('getRenderer', function () {
          const message = {
              data: {
                  detail: 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.'
              },
              index: 0,
              key: 'ConfirmationMessage',
              metadata: { key: 'ConfirmationMessage' }
          };
          const renderers = {
              testRenderer: () => preact.h("div", null)
          };
          // don's pass any renderers
          const noRenderers = MessageUtils__namespace.getRenderer(message, 'testRenderer');
          chai.expect(noRenderers).undefined;
          // get renderer by valid id
          const rendererByIdValid = MessageUtils__namespace.getRenderer(message, 'testRenderer', renderers);
          chai.expect(rendererByIdValid).to.equal(renderers.testRenderer);
          // get renderer by invalid id
          // (this should throw an error, but if not, verify that the renderer is null)
          try {
              const rendererByIdInvalid = MessageUtils__namespace.getRenderer(message, 'foo', renderers);
              chai.expect(rendererByIdInvalid).null;
          }
          catch (e) {
              chai.expect(e).not.null;
          }
          // get renderer by undefined id
          const rendererIdUndefined = MessageUtils__namespace.getRenderer(message, undefined, renderers);
          chai.expect(rendererIdUndefined).undefined;
          // get renderer by function that returns a valid id
          const rendererByFuncValid = MessageUtils__namespace.getRenderer(message, () => 'testRenderer', renderers);
          chai.expect(rendererByFuncValid).to.equal(renderers.testRenderer);
          // get renderer by function that returns an invalid id
          // (this should throw an error, but if not, verify that the renderer is null)
          try {
              const rendererByFuncInvalid = MessageUtils__namespace.getRenderer(message, () => 'foo', renderers);
              chai.expect(rendererByFuncInvalid).null;
          }
          catch (e) {
              chai.expect(e).not.null;
          }
          // get renderer by function that returns a null id
          const rendererByFuncNull = MessageUtils__namespace.getRenderer(message, () => null, renderers);
          chai.expect(rendererByFuncNull).undefined;
      });
  });

}));
//# sourceMappingURL=MessageUtils.spec.js.map
