define(['preact', '@testing-library/preact', 'chai', '@oracle/oraclejet-preact/UNSAFE_Message'], (function (preact$1, preact, chai, UNSAFE_Message) { 'use strict';

  const todaysDate = new Date();
  const pastDate = new Date(todaysDate);
  pastDate.setUTCFullYear(2020);
  describe('Test MessageTimestamp component', () => {
      it("today's date", async function () {
          const isoString = todaysDate.toISOString();
          const content = preact.render(preact$1.h(UNSAFE_Message.MessageTimestamp, { value: isoString }));
          const text = UNSAFE_Message.formatTimestamp(isoString);
          const timestamp = await content.findByText(text);
          chai.expect(timestamp).not.null;
      });
      it("past date", async function () {
          const isoString = pastDate.toISOString();
          const content = preact.render(preact$1.h(UNSAFE_Message.MessageTimestamp, { value: isoString }));
          const text = UNSAFE_Message.formatTimestamp(isoString);
          const timestamp = await content.findByText(text);
          chai.expect(timestamp).not.null;
      });
  });

}));
//# sourceMappingURL=MessageTimestamp.spec.js.map
