define(['preact', '@testing-library/preact', 'chai', '@oracle/oraclejet-preact/UNSAFE_Message'], (function (preact$1, preact, chai, UNSAFE_Message) { 'use strict';

  describe('Test MessageStartIcon component', () => {
      for (const severity in UNSAFE_Message.severities) {
          if (severity === 'none') {
              continue;
          }
          it(`severity ${severity}`, async function () {
              const content = preact.render(preact$1.h(UNSAFE_Message.MessageStartIcon, { severity: severity }));
              const icon = content.container.firstElementChild;
              chai.expect(icon).not.null;
          });
      }
  });

}));
//# sourceMappingURL=MessageStartIcon.spec.js.map
