define(['preact', '@testing-library/preact', 'chai', '@oracle/oraclejet-preact/UNSAFE_Flex', '@oracle/oraclejet-preact/UNSAFE_HiddenAccessible'], (function (preact$1, preact, chai, UNSAFE_Flex, UNSAFE_HiddenAccessible) { 'use strict';

  describe('Test HiddenAccessible component', () => {
      it('render', async function () {
          const content = preact.render(preact$1.h(UNSAFE_HiddenAccessible.HiddenAccessible, null, "Text"));
          const sampleText = await content.findByText('Text');
          chai.expect(sampleText).not.null;
      });
      it('render with <Flex> inside', async function () {
          const content = preact.render(preact$1.h(UNSAFE_HiddenAccessible.HiddenAccessible, null,
              preact$1.h(UNSAFE_Flex.Flex, null, "flex text")));
          const sampleText = await content.findByText('flex text');
          chai.expect(sampleText).not.null;
      });
  });

}));
//# sourceMappingURL=HiddenAccessible.spec.js.map
