define(['preact', '@testing-library/preact', '@testing-library/user-event', 'chai', './Avatar'], (function (preact$1, preact, userEvent, chai, Avatar) { 'use strict';

  function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

  var userEvent__default = /*#__PURE__*/_interopDefaultLegacy(userEvent);

  describe('Test Avatar component', () => {
      it('render', async function () {
          const content = preact.render(preact$1.h(Avatar.Avatar, null, "TN"));
          const initials = await content.findByText('TN');
          chai.expect(initials).not.null;
          userEvent__default["default"].click(initials);
      });
      it('applies Linaria CSS classes', async () => {
          const content = preact.render(preact$1.h(Avatar.Avatar, null));
          const firstElement = content.container.firstElementChild;
          // @ts-ignore
          const classList = firstElement.classList;
          chai.expect(classList.length).equals(3);
          chai.expect(Array.from(classList).some((c) => c.match(/^oj-avatar-base-[a-z0-9]+/))).true;
      });
  });

}));
//# sourceMappingURL=Avatar.spec.js.map
