/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["require","ojs/ojcore-base","jquery","ojs/ojcontext","ojs/ojthemeutils","ojs/ojcomponentcore","ojs/ojanimation","ojs/ojdomutils","ojs/ojlogger","ojs/ojconfig","ojs/ojkeyset","ojs/ojselector","ojdnd","ojs/ojcustomelement-utils","ojs/ojdatacollection-common","ojs/ojtranslation"],function(e,t,s,n,i,a,o,r,l,d,h,c,_,u,E,f){"use strict";t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t,s=s&&Object.prototype.hasOwnProperty.call(s,"default")?s.default:s,n=n&&Object.prototype.hasOwnProperty.call(n,"default")?n.default:n;class p{constructor(e,t={keyAttributes:"id",childrenAttribute:"children"},s=(e=>new Map(e)),n=(e=>new Set(e))){this.data=e,this.createOptimizedKeyMap=s,this.createOptimizedKeySet=n,this.keyAttr=t.keyAttributes,this.childrenAttr=t.childrenAttribute;const i=(e,t,s)=>{e.forEach(e=>{s.add(e[this.keyAttr]),e[this.childrenAttr]&&e[this.childrenAttr].length>0&&(t.set(e[this.keyAttr],e),i(e[this.childrenAttr],t,s))})};this.parentKeyNodeMap=this.createOptimizedKeyMap(),this.allKeys=this.createOptimizedKeySet(),i(this.data,this.parentKeyNodeMap,this.allKeys)}computeSelection(e,t=new h.KeySetImpl){const s=this.normalizeKeySet(e),n=this.normalizeKeySet(t),i=s.delete(n.values()),a=n.delete(s.values()),o=this.reduceToLeaves(a.values()),r={selectedLeaves:this.createOptimizedKeySet(new Set([...[...s.values()].filter(e=>!this.parentKeyNodeMap.has(e)),...this.reduceToLeaves(i.values())].filter(e=>!o.has(e)))),selectedParents:this.createOptimizedKeySet(),partialParents:this.createOptimizedKeySet()};return this.assignParentSelection({children:this.data},{selected:0,partial:0},r),r.selected=this.createOptimizedKeySet([...r.selectedLeaves.values(),...r.selectedParents.values()]),{selected:new h.KeySetImpl(r.selected),selectedLeaves:new h.KeySetImpl(r.selectedLeaves),selectedParents:new h.KeySetImpl(r.selectedParents),partialParents:new h.KeySetImpl(r.partialParents)}}reduceToLeaves(e){const t=(e,s)=>{this.parentKeyNodeMap.has(e[this.keyAttr])?e[this.childrenAttr].forEach(e=>t(e,s)):s.add(e[this.keyAttr])},s=this.createOptimizedKeySet();return e.forEach(e=>this.parentKeyNodeMap.has(e)?t(this.parentKeyNodeMap.get(e),s):s.add(e),this),s}assignParentSelection(e,t,s){if(void 0!==e[this.keyAttr]&&!this.parentKeyNodeMap.has(e[this.keyAttr]))s.selectedLeaves.has(e[this.keyAttr])&&(t.selected+=1);else{const n={selected:0,partial:0};if(e[this.childrenAttr].forEach(e=>this.assignParentSelection(e,n,s)),void 0===e[this.keyAttr]||n.selected+n.partial===0)return;n.selected===e[this.childrenAttr].length?(s.selectedParents.add(e[this.keyAttr]),t.selected+=1):(s.partialParents.add(e[this.keyAttr]),t.partial+=1)}}normalizeKeySet(e){return e.isAddAll()?new h.KeySetImpl(this.allKeys).delete(e.deletedValues()):e}}t.__registerWidget("oj.ojTreeView",s.oj.baseComponent,{version:"1.0.0",defaultElement:"<div>",widgetEventPrefix:"oj",options:{currentItem:null,data:null,dnd:{drag:null,drop:null},expanded:new h.KeySetImpl,item:{focusable:null,renderer:null,selectable:null},scrollPolicyOptions:{maxCount:500},selected:new h.KeySetImpl,selection:[],selectionMode:"none",animateEnd:null,animateStart:null,beforeCollapse:null,beforeCurrentItem:null,beforeExpand:null,collapse:null,expand:null},constants:{TREEVIEW_CONTENT_PADDING_REM:.5,PERIOD:".",OJ_COMPLETE:"oj-complete",OJ_TREEVIEW_LIST:"oj-treeview-list",ERROR_FETCHING_DATA:"Error fetching data: ",OJ_ITEM_DATA:"oj-item-data",OJ_ITEM_METADATA:"oj-item-metadata",OJ_TREEVIEW_ITEM_CONTENT:"oj-treeview-item-content",OJ_TREEVIEW_SELECTOR:"oj-treeview-selector",OJ_COMPONENT_ICON:"oj-component-icon",OJ_DRAGGABLE:"oj-draggable",OJ_TREEVIEW_SPACER:"oj-treeview-spacer",OJ_TREEVIEW_LEAF:"oj-treeview-leaf",OJ_TREEVIEW_DISCLOSURE_ICON:"oj-treeview-disclosure-icon",OJ_DEFAULT:"oj-default",OJ_EXPANDED:"oj-expanded",OJ_TREEVIEW_SKELETON_CONTAINER:"oj-treeview-skeleton-container",OJ_COLLAPSED:"oj-collapsed",OJ_TREEVIEW_ANIMATED:"oj-treeview-animated",OJ_SELECTED:"oj-selected",OJ_TREEVIEW_DRAG_SOURCE:"oj-treeview-drag-source",OJ_TREEVIEW_SKELETON_CONTENT:"oj-treeview-skeleton-content",OJ_ANIMATION_SKELETON:"oj-animation-skeleton",OJ_TREEVIEW_ITEM:"oj-treeview-item",OJ_HOVER:"oj-hover",OJ_CLICKABLE_ICON_NOCONTEXT:"oj-clickable-icon-nocontext",OJ_TREEVIEW_DROPLINE:"oj-treeview-drop-line",OJ_TREEVIEW_SELECT_SINGLE:"oj-treeview-select-single",OJ_TREEVIEW_ICON:"oj-treeview-icon",OJ_TREEVIEW_DRAG_IMAGE:"oj-treeview-drag-image",OJ_TREEVIEW_DRAG_IMAGE_ITEM:"oj-treeview-drag-image-item",OJ_FOCUS:"oj-focus",OJ_TREEVIEW_DROP_ZONE:"oj-treeview-drop-zone",OJ_FOCUS_HIGHLIGHT:"oj-focus-highlight",OJ_ANIMATION_SKELETON_FADE_IN:"oj-animation-skeleton-fade-in",OJ_TREEVIEW_SKELETON_CHILD:"oj-treeview-skeleton-child",OJ_TREEVIEW_SKELETON_CARROT:"oj-treeview-skeleton-carrot",OJ_TREEVIEW_SKELETON_ITEM:"oj-treeview-skeleton-item",OJ_TREEVIEW_SKELETON_LEAF:"oj-treeview-skeleton-leaf",OJ_TREEVIEW_ITEM_ICON:"oj-treeview-item-icon",OJ_TREEVIEW_SELECTED_TOP_ITEM:"oj-selected-item-content-top",OJ_TREEVIEW_SELECTED_BOTTOM_ITEM:"oj-selected-item-content-bottom",OJ_TREEVIEW_CSS_VARS:{expandAnimation:"--oj-private-tree-view-global-expand-animation",collapseAnimation:"--oj-private-tree-view-global-collapse-animation",dataFadeInDuration:"--oj-private-tree-view-global-data-fadein-duration",multipleSelectionAffordance:"--oj-private-tree-view-global-selection-affordance-default",loadIndicator:"--oj-private-tree-view-global-load-indicator-default",showIndicatorDelay:"--oj-private-core-global-loading-indicator-delay-duration"}},_ComponentCreate:function(){this._super()},_AfterCreate:function(){this._super(),this._initRender(),this._render()},_CompareOptionValues:function(e,s,n){switch(e){case"selection":return s&&void 0===s.inverted&&(s.inverted=!1),n&&void 0===n.inverted&&(n.inverted=!1),(!s||!n||s.inverted===n.inverted)&&t.KeyUtils.equals(s,n);case"selected":return E.areKeySetsEqual(s,n);default:return this._super(e,s,n)}},_initRender:function(){var e=this;this._on(this.element,{click:function(t){e._handleClick(t)},mouseover:function(t){e._handleMouseOver(t)},mouseout:function(t){e._handleMouseOut(t)},mousedown:function(t){e._handleMouseDown(t)},mouseup:function(t){e._handleMouseUp(t)},keydown:function(t){e._handleKeyDown(t)},dragstart:function(t){e._handleDragStart(t)},drag:function(t){e._handleDragSourceEvent(t,"drag")},dragend:function(t){e._handleDragSourceEvent(t,"dragEnd")},dragenter:function(t){e._handleDropTargetEvent(t,"dragEnter")},dragover:function(t){e._handleDropTargetEvent(t,"dragOver")},dragleave:function(t){e._handleDropTargetEvent(t,"dragLeave")},drop:function(t){e._handleDropTargetEvent(t,"drop")}}),r.isTouchSupported()&&(this.element[0].addEventListener("touchstart",function(t){e.touchStartEvent=t},{passive:!0}),this.element[0].addEventListener("touchmove",function(t){e.ojTreeViewDragEvent&&t.preventDefault()},{passive:!1}),this.element[0].addEventListener("touchcancel",function(){e.touchStartEvent=null,e.ojTreeViewDragEvent=!1}),this.element[0].addEventListener("touchend",function(t){e.touchStartEvent&&t.changedTouches.length&&document.elementFromPoint(t.changedTouches[0].clientX,t.changedTouches[0].clientY)!==e.touchStartEvent.target&&(e.touchStartEvent=null),e.ojTreeViewDragEvent=!1,e._handleMouseOut(t)})),this._dropLine=document.createElement("div"),this._dropLine.classList.add(this.constants.OJ_TREEVIEW_DROPLINE),this.element[0].appendChild(this._dropLine);const t=document.createElement("div");t.classList.add("oj-helper-hidden-accessible"),t.setAttribute("role","status"),this.element[0].appendChild(t),this._dropLine.style.display="none",this._refreshId=0,this._uiExpanded=new h.KeySetImpl,this.m_fetching=new Set,this._expandedChildrenMap=new Map,this._syncSelectionState()},_syncSelectionState:function(){var e=h.KeySetUtils.toArray(this.options.selected),t=h.KeySetUtils.toKeySet(this.options.selection);e.length>0||e.inverted?this._userOptionChange("selection",e,null):(this.options.selection.length>0||this.options.selection.inverted)&&this._userOptionChange("selected",t,null)},_render:function(){var e=this;this.element[0].classList.remove(this.constants.OJ_COMPLETE),this._keyList=new Set;var t,s=this.element[0].querySelectorAll("ul");if(this.options.data){for(t=0;t<s.length;t++)s[t].parentNode.removeChild(s[t]);this._fetchChildren(null,function(t){var s=t.values[0];e._truncateIfOverMaxCount(s.value);var n={fetchListResult:s.value,parentElem:e.element[0]};e._renderItems(n).then(function(){e._resetFocus(),e.element[0].classList.add(e.constants.OJ_COMPLETE),e._decorateTree(),e._lastSelectedItem=null})})}else{for(t=0;t<s.length;t++)s[t].classList.add(this.constants.OJ_TREEVIEW_LIST),s[t].setAttribute("role","group");var n=this.element[0].querySelectorAll("li");for(t=0;t<n.length;t++){var i=this._getItemContent(n[t]);if(i){var a=this._getItemDisclosureIcon(i);a&&i.removeChild(a)}e._decorateItem(n[t])}this._resetFocus(),this._decorateTree(),this._lastSelectedItem=null,this.element[0].classList.add(this.constants.OJ_COMPLETE)}},_getDataProvider:function(){var s;if(null==this.m_dataSource){if(s=this.options.data,!t.DataProviderFeatureChecker.isTreeDataProvider(s)){var n=new Promise(function(t,s){e(["ojs/ojtreedataprovideradapter"],function(e){t(function(e){if(e&&e.__esModule)return e;var t={};return e&&Object.keys(e).forEach(function(s){var n=Object.getOwnPropertyDescriptor(e,s);Object.defineProperty(t,s,n.get?n:{enumerable:!0,get:function(){return e[s]}})}),t.default=e,t}(e))},s)});if(!n)throw new Error("Error adapting a TreeDataSource");return n.then(e=>new e.default(s))}}else s=this.m_dataSource;return Promise.resolve(s)},_fetchChildren:function(e,t){var s=this,n=s._addBusyState("getting data provider",e),i=s._getDataProvider(),a=this._refreshId;i.then(function(i){if(n(),s._refreshId===a){s.m_dataSource=i;var o=null===e?i:i.getChildDataProvider(e);if(null!=o){var r=s._addBusyState("fetching data",e),d=s._getShowStatusDelay();s._isSkeletonSupported()&&(s._skeletonTimeout=setTimeout(function(){var t=s._expandedChildrenMap.get(null);if(null===e)s._renderInitialSkeletons();else if(!t&&!s._isParentSkeletonRendered(e)&&!s._isLeafOnlySelectionEnabled()){var n=s._getItemByKey(e);n&&(s._getSubtree(n)||s._renderChildSkeletons(e))}},d));var h=s._loadTemplateEngine();s._clientId=s._clientId||Symbol();var c={clientId:s._clientId,size:-1},_=o.fetchFirst(c)[Symbol.asyncIterator](),u=_.next(),E=function(t){if(t[0].done){if(s._clearSkeletonTimeout(),s._isLeafOnlySelectionEnabled()&&s._buildRawData(e,t[0]),s._isSkeletonSupported()){for(var n=[],i=t[0].value.data,o=0;o<i.length;o++){var d=t[0].value.metadata[o].key;s._isInitExpanded(d)&&s.m_dataSource.getChildDataProvider(d)&&n.push(d)}s._expandedChildrenMap.set(e,n);var h=s._expandedChildrenMap.get(e);if(h){var c=h.indexOf(e);c>-1&&h.splice(c,1)}if(!h||0===h.length)return{values:t,shouldRemoveSkeleton:!0}}return{values:t,shouldRemoveSkeleton:!1}}return _.next().then(function(e){return s._refreshId!==a?null:(t[0].done=e.done,t[0].value.data=t[0].value.data.concat(e.value.data),t[0].value.metadata=t[0].value.metadata.concat(e.value.metadata),E(t))},function(e){l.error(s.constants.ERROR_FETCHING_DATA+e),r()})};Promise.all([u,h]).then(function(e){return s._refreshId!==a?null:E(e)},function(e){return Promise.reject(e)}).then(function(e){s._refreshId===a?(t(e),r()):r()},function(e){l.error(s.constants.ERROR_FETCHING_DATA+e);var t=s._getSkeletonContainer(s.element[0]);s._isSkeletonSupported()&&t&&s._removeSkeleton(null),r()})}}},function(e){l.error(s.constants.ERROR_FETCHING_DATA+e),n(),s._expandedChildrenMap=new Map,s.m_fetching=new Set})},_clearSkeletonTimeout:function(){this._skeletonTimeout&&(clearTimeout(this._skeletonTimeout),this._skeletonTimeout=null)},_buildRawData:function(e,t){null===e?this._rawData=t.value.metadata:this._findParentAndAddChildren(this._rawData,t.value.metadata,e)},_findParentAndAddChildren:function(e,t,s){for(var n=0;n<e.length;n++){if(e[n].key===s)return void(e[n].children=t);e[n].children&&this._findParentAndAddChildren(e[n].children,t,s)}},_isParentSkeletonRendered:function(e){for(var t=this._getItemByKey(e),s=this._getParents(t,this.constants.PERIOD+this.constants.OJ_TREEVIEW_ITEM),n=0;n<s.length;n++){var i=this._getKey(s[n]);if(this._expandedChildrenMap.get(i))return!0}return!1},_getShowStatusDelay:function(){var e=this._getOptionDefaults(),t=parseInt(e.showIndicatorDelay,10);return isNaN(t)?0:t},_renderItems:function(e){return new Promise(function(t){var s=document.createElement("ul");s.classList.add(this.constants.OJ_TREEVIEW_LIST),s.setAttribute("role","group");var n=this._getSkeletonContainer(this.element[0]);(n&&this._isSkeletonSupported()||this._isLeafOnlySelectionEnabled())&&(s.style.display="none"),e.parentElem.appendChild(s);for(var i=0;i<e.fetchListResult.data.length;i++)this._renderItem(s,e.fetchListResult,i);n&&this._isSkeletonSupported()&&!this._isLeafOnlySelectionEnabled()?this._toggleParentDisplay(e.parentElem,t):t()}.bind(this))},_getScrollPolicyOptions:function(){return this.options.scrollPolicyOptions},_validateScrollPolicyOptions:function(e){var t=this._getScrollPolicyOptions(),s=this._getTreeViewItemCount()+e;return t.maxCount<s&&l.info("ScrollPolicyOptions max count of ["+t.maxCount+"] has been reached."),s-t.maxCount},_truncateIfOverMaxCount:function(e){const t=e.data.length,s=this._validateScrollPolicyOptions(t);s===t?(e.data=[],e.metadata=[]):s>0&&(e.data.splice(-s,t),e.metadata.splice(-s,t))},_toggleParentDisplay:function(e,t){var s=this._getKey(e);e===this.element[0]&&(s=null);var n=this._expandedChildrenMap.get(s);if(n&&n.length>0)t();else{let e=null;for(e of this._expandedChildrenMap.keys()){var i,a,o=this._expandedChildrenMap.get(e);null===e?(i=this.element[0],a=this._getRoot()):(i=this._getItemByKey(e),a=this._getSubtree(i),this._setItemExpanded(i)),a&&0===o.length&&this._resolveNoChildren(e,i,a,t);for(var r=o.length-1;r>=0;r--)o[r]===s&&a&&(o.splice(r,1),0===o.length&&this._resolveNoChildren(e,i,a,t))}t()}},_resolveNoChildren:function(e,t,s,n){this._expandedChildrenMap.delete(e),this._getSkeletonContainer(t)&&!this._isLeafOnlySelectionEnabled()?this._foundSkeleton(e,s,n):this._isLeafOnlySelectionEnabled()||(s&&(s.style.display="block"),this._toggleParentDisplay(t,n))},_foundSkeleton:function(e,t,s){this._removeSkeleton(e).then(function(){t&&(t.style.display="block");var e=this._getOptionDefaults();o.fadeIn(t,{duration:e.dataFadeInDuration}),s()}.bind(this))},_renderItem:function(e,t,n,i,o){var r,l,d=t.data[n],h=t.metadata[n],c=h.key;if(!o){if(this._keyList.has(c))throw new Error("JET TreeView nodes should not have duplicated keys: "+c);this._keyList.add(c)}var _=document.createElement("li");if(o){var u=this._getItemByKey(c);if(!u)return;e=u.parentNode;var E=this._getSubtree(u);u.parentNode.replaceChild(_,u)}else null==i||i>=e.children.length?e.appendChild(_):e.insertBefore(_,e.children[i]);var f={parentElement:s(_),index:n,data:d,datasource:this.options.data,parentKey:this._getKey(this._getParentItem(_)),metadata:h,component:a.__GetWidgetConstructor(this.element)};this._FixRendererContext&&(f=this._FixRendererContext(f));var p=this.m_dataSource.getChildDataProvider(c);h.leaf=null===p,h.depth=this._getDepth(_);var m=Object.keys(h);for(r=0;r<m.length;r++){var g=m[r];f[g]=h[g]}var v=this.options.item.renderer;v=this._WrapCustomElementRenderer(v);var I=this._getItemTemplate(),y=this._getTemplateEngine();if(null!=v){var S=v.call(this,f);null!=S&&(null===S.parentNode||S.parentNode instanceof DocumentFragment?_.appendChild(S):null!=S.parentNode||S.toString&&((l=document.createElement("span")).appendChild(document.createTextNode(S.toString())),_.appendChild(l)))}else if(null!=I&&null!=y){var O=this.element[0],T=y.execute(O,I,f,null);for(r=0;r<T.length;r++){if("LI"===T[r].tagName){_.parentNode.replaceChild(T[r],_);break}_.appendChild(T[r])}}else(l=document.createElement("span")).appendChild(document.createTextNode(null==d?"":d.toString())),_.appendChild(l);o&&E&&_.appendChild(E),_=e.children[null!=i?i:n],f.parentElement=s(_),_.hasAttribute("id")||_.setAttribute("id",this._getUniqueItemId()),_[this.constants.OJ_ITEM_DATA]=d,_[this.constants.OJ_ITEM_METADATA]=h,this._decorateItem(_)},_getDepth:function(e){for(var t=0,s=e;s&&s!==this.element[0];)s=s.parentElement.parentElement,t+=1;return t},_loadTemplateEngine:function(){var e=this;return null!=this._getItemTemplate()&&null==e.options.item.renderer?new Promise(function(t){d.__getTemplateEngine().then(function(s){e.m_engine=s,t(s)},function(e){throw new Error("Error loading template engine: "+e)})}):Promise.resolve(null)},_getTemplateEngine:function(){return this.m_engine},_getItemTemplate:function(){if(void 0===this.m_template){this.m_template=null;var e=this._getSlotMap().itemTemplate;e&&e.length>0&&"template"===e[0].tagName.toLowerCase()&&(this.m_template=e[0])}return this.m_template},_getSlotMap:function(){return u.CustomElementUtils.getSlotMap(this.element[0])},_decorateTree:function(){var e=this,t=this._getRoot();if(t){this._focusable({element:s(t),applyHighlight:!0,setupHandlers:function(t,s){e._focusInHandler=t,e._focusOutHandler=s}}),t.setAttribute("tabIndex",0),s(t).on("focus",function(){e._focusInHandler(s(e._getItemContent(e._currentItem)))}).on("blur",function(){e._focusOutHandler(s(e._getItemContent(e._currentItem)))}),t.setAttribute("role","tree"),t.setAttribute("aria-labelledby",this.element[0].getAttribute("id"));var n=this.options.selectionMode;"none"!==n?t.setAttribute("aria-multiselectable",this._isMultiSelectionEnabled()||this._isLeafOnlySelectionEnabled()?"true":"false"):t.removeAttribute("aria-multiselectable"),"single"===n&&this.element[0].classList.add(this.constants.OJ_TREEVIEW_SELECT_SINGLE),this.element[0].setAttribute("tabIndex",-1),this.element[0].addEventListener("focus",()=>{this._getRoot().focus()}),this.element[0].addEventListener("blur",()=>{this._getRoot().blur()})}},_isMultiSelectionEnabled:function(){return"multiple"===this.options.selectionMode},_isLeafOnlySelectionEnabled:function(){return"leafOnly"===this.options.selectionMode},_isDefaultCheckBoxesEnabled:function(){return"selector"===this._getOptionDefaults().multipleSelectionAffordance&&(this._isMultiSelectionEnabled()||this._isLeafOnlySelectionEnabled())},_refreshSelectionItems:function(){if("none"!==this.options.selectionMode){var e,t,s=this._getSelected(),n=Array.from(this._getItemsInSelectedKeySet(s));if(s.isAddAll())for(e=0;e<n.length;e++){t=n[e];var i=this._getKey(t);s.has(i)&&this._isActionable(t,"select")?this._setSelected(t):this._setUnselected(t)}else{var a=this._getSelectedItemContents();for(e=a.length-1;e>=0;e--){var o=a[e].parentElement,r=n.indexOf(o);-1!==r?n.splice(r,1):this._setUnselected(o)}for(e=0;e<n.length;e++)t=n[e],this._setSelected(t)}this._isLeafOnlySelectionEnabled()&&this._updateIndeterminateState(this._selectedKeysets.partialParents)}},_getItemsInSelectedKeySet:function(e){var t=[];return e.isAddAll()?this._getItems():(e.values().forEach(e=>{var s=this._getItemByKey(e);s&&this._isActionable(s,"select")&&t.push(s)}),t)},_decorateItem:function(e){var t;e.classList.add(this.constants.OJ_TREEVIEW_ITEM),e.setAttribute("role","treeitem");var s=this._getKey(e),i=this._getItemContent(e);if(!i){if((i=document.createElement("div")).classList.add(this.constants.OJ_TREEVIEW_ITEM_CONTENT),this._isDefaultCheckBoxesEnabled()&&this._isActionable(e,"focus")&&this._isActionable(e,"select")){var a=document.createElement("span");a.classList.add(this.constants.OJ_TREEVIEW_SELECTOR);var o=document.createElement("oj-selector");this._getSelected().has(s)?o.selectedKeys=new h.KeySetImpl([s]):o.selectedKeys=new h.KeySetImpl,o.setAttribute("data-oj-binding-provider","none"),o.setAttribute("selection-mode","multiple"),o.setAttribute("aria-label",f.getTranslatedString("oj-ojTreeView.treeViewSelectorAria",{rowKey:s})),o.addEventListener("selectedKeysChanged",function(e){if("internal"===e.detail.updatedFrom){var t=this._getItemByKey(e.target.rowKey);this._focus(t,e);var s=this._getSelected();s=s.has(e.target.rowKey)?s.delete([e.target.rowKey]):s.add([e.target.rowKey]),this._userSelectedOptionChange(s,e)}}.bind(this)),o.rowKey=s,a.appendChild(o),i.appendChild(a),n.getContext(o).getBusyContext().whenReady().then(()=>{E.disableAllFocusableElements(o)})}if(e.firstChild)do{i.appendChild(e.firstChild)}while(e.childNodes.length>0);e.appendChild(i);var r=i.getElementsByTagName("ul")[0];r&&e.appendChild(r);var l=i.querySelectorAll(this.constants.PERIOD+this.constants.OJ_TREEVIEW_ITEM_ICON);for(t=0;t<l.length;t++)l[t].classList.add(this.constants.OJ_TREEVIEW_ICON),l[t].classList.add(this.constants.OJ_COMPONENT_ICON)}this._select(e),i.setAttribute("draggable",this._isDnD()?"true":"false");var d=this._getItemDisclosureIcon(i),c=this._getItemSpacer(i);d||(d=document.createElement("ins"),this._addTreeViewIconClass(d),c?i.insertBefore(d,c.nextElementSibling):i.insertBefore(d,i.children[0])),c||(c=document.createElement("span"),this._addTreeviewSpacerClass(c),i.insertBefore(c,d)),this._addIndentation(e,c),this._isDnD()&&(e.classList.add(this.constants.OJ_DRAGGABLE),i.classList.add(this.constants.OJ_DRAGGABLE)),this._isLeaf(e)?this._addTreeviewLeafClass(e):(this._isInitExpanded(s)?this._expand(e,!1):this._collapse(e,!1),this._addDisclosureClasses(d))},_addIndentation:function(e,t){let s=this._getDepth(e)-1;const n=t.style,a="redwood"===i.parseJSONFromFontFamily("oj-theme-json").behavior;let o=0;this._hasIcon(e)&&a&&(o=s*this.constants.TREEVIEW_CONTENT_PADDING_REM),this._isLeaf(e)&&(s+=1),n.width="calc(calc("+s+" * var(--oj-tree-view-indent-width)) + "+o+"rem)"},_hasIcon:function(e){return e.querySelectorAll(".oj-treeview-icon.oj-component-icon").length>0},_removeIndentation:function(e){e.style.removeProperty("width"),e.removeAttribute("class"),e.classList.add(this.constants.OJ_TREEVIEW_SPACER)},_addTreeviewSpacerClass:function(e){e.classList.add(this.constants.OJ_TREEVIEW_SPACER)},_addTreeViewIconClass:function(e){e.classList.add(this.constants.OJ_TREEVIEW_ICON)},_addTreeviewLeafClass:function(e){e.classList.add(this.constants.OJ_TREEVIEW_LEAF)},_removeTreeviewLeafClass:function(e){e.classList.remove(this.constants.OJ_TREEVIEW_LEAF)},_addDisclosureClasses:function(e){e.classList.add(this.constants.OJ_TREEVIEW_DISCLOSURE_ICON),e.classList.add(this.constants.OJ_COMPONENT_ICON),e.classList.add(this.constants.OJ_CLICKABLE_ICON_NOCONTEXT),e.classList.add(this.constants.OJ_DEFAULT)},_removeDisclosureClasses:function(e){e.classList.remove(this.constants.OJ_TREEVIEW_DISCLOSURE_ICON),e.classList.remove(this.constants.OJ_COMPONENT_ICON),e.classList.remove(this.constants.OJ_CLICKABLE_ICON_NOCONTEXT),e.classList.remove(this.constants.OJ_DEFAULT)},_getItems:function(){return this.element[0].querySelectorAll(this.constants.PERIOD+this.constants.OJ_TREEVIEW_ITEM)},_getKey:function(e){if(!e)return null;var t=e[this.constants.OJ_ITEM_METADATA];return t?t.key:e.getAttribute("id")},_getItemByKey:function(e){for(var s,n=this.element[0].getElementsByTagName("li"),i=0;i<n.length;i++){var a=n[i][this.constants.OJ_ITEM_METADATA];if(a&&t.KeyUtils.equals(a.key,e)){s=n[i];break}}if(s)return s;if("string"==typeof e){var o=document.getElementById(e),r=this._getRoot();if(r&&o&&r.contains(o))return o}},_getItemContent:function(e){if(!e)return null;for(var t=e.children,s=0;s<t.length;s++)if(e.children[s].classList&&e.children[s].classList.contains(this.constants.OJ_TREEVIEW_ITEM_CONTENT))return e.children[s];return null},_getChildItems:function(e){var t=[],s=e.getElementsByClassName(this.constants.OJ_TREEVIEW_LIST)[0];if(s)for(var n=s.children,i=0;i<n.length;i++)t.push(n[i]);return t},_getParentItem:function(e){var t=this._getParents(e,".oj-treeview-list")[0];return this._getParents(t,this.constants.PERIOD+this.constants.OJ_TREEVIEW_ITEM)[0]},_getSubtree:function(e){return e.getElementsByClassName(this.constants.OJ_TREEVIEW_LIST)[0]},_getRoot:function(){return this.element[0].getElementsByClassName(this.constants.OJ_TREEVIEW_LIST)[0]},_isLeaf:function(e){if(!e)return null;var t=e[this.constants.OJ_ITEM_METADATA];return!(t?!t.leaf:void 0!==this._getSubtree(e))},_isInitExpanded:function(e,t){var s=null!=t?t:this.options.expanded;return!(!s||!s.has)&&s.has(e)},_isExpanded:function(e){return e.classList.contains(this.constants.OJ_EXPANDED)},_isDisclosing:function(e){return!(!e||!this.m_disclosing)&&this.m_disclosing.indexOf(e)>-1},_setDisclosing:function(e,t){if(null!=e)if(null==this.m_disclosing&&(this.m_disclosing=[]),t)this.m_disclosing.push(e);else for(var s=this.m_disclosing.indexOf(e);s>-1;)this.m_disclosing.splice(s,1),s=this.m_disclosing.indexOf(e)},_expand:function(e,t,s,n){var i=this;if(!(this._isExpanded(e)||this._isLeaf(e)||t&&this._isDisclosing(this._getKey(e)))){if(t&&!this._trigger("beforeExpand",s,this._getEventPayload(e))&&!1!==n)return;s&&this._isActionable(e,"focus")&&this._focus(e,s),this._lastSelectedItem=null;var a=this._getSubtree(e),o=i._getKey(e);if(!a)return this._uiExpanded=this._uiExpanded.add([o]),void this._fetchChildren(o,function(n){if((!i._isExpanded(e)||i._isSkeletonSupported())&&(i._isInitExpanded(o)||i._isInitExpanded(o,i._uiExpanded))){var r=n.values[0];i._truncateIfOverMaxCount(r.value);var l=e.getElementsByClassName(i.constants.OJ_TREEVIEW_SKELETON_CONTAINER).length,d={fetchListResult:r.value,parentElem:e};i._isSkeletonSupported()&&l>0&&n.shouldRemoveSkeleton&&!i._isLeafOnlySelectionEnabled()?i._renderItems(d).then(function(){var t=e.offsetHeight,n=3*t,o=t*r.value.data.length;a=i._getSubtree(e);var l={startMaxHeight:n+"px",endMaxHeight:o+"px"};o>n?i._animateSkeletonRemoval("expand",e,a,l,s):o<n?i._animateSkeletonRemoval("collapse",e,a,l,s):i._animateSkeletonRemoval("fadeIn",e,a,l,s)}):i._isSkeletonSupported()&&l>0?i._renderItems(d).then(function(){i._setExpandedState(i,e,s),i.isReady()&&i._isLeafOnlySelectionEnabled()&&i._initLeafOnlySelectionMode()}):i._renderItems(d).then(function(){i._expandAfterFetch(e,t,s),i.isReady()&&i._isLeafOnlySelectionEnabled()&&i._initLeafOnlySelectionMode()})}});i._expandAfterFetch(e,t,s)}},_initLeafOnlySelectionMode:function(){let e=e=>new Map(e);this.options.data.createOptimizedKeyMap&&(e=e=>this.options.data.createOptimizedKeyMap(e));let t=e=>new Set(e);this.options.data.createOptimizedKeySet&&(t=e=>this.options.data.createOptimizedKeySet(e)),this.treeviewSelectionManager=new p(this._rawData,{keyAttributes:"key",childrenAttribute:"children"},e,t),this._userSelectedOptionChange(this._filterOutParentKeys(this._getSelected()),null,!0);var s=this._getRoot();this._getSkeletonContainer(this.element[0])?this._removeSkeleton(null).then(function(){s&&(s.style.display="block");var e=this._getOptionDefaults();o.fadeIn(s,{duration:e.dataFadeInDuration})}.bind(this)):s&&(s.style.display="block")},_setItemExpanded:function(e){e.classList.remove(this.constants.OJ_COLLAPSED),e.classList.add(this.constants.OJ_EXPANDED),this._setAriaExpanded(e,"true")},_animateSkeletonRemoval:function(e,t,s,n,i){var a=this._getKey(t);this._removeSkeleton(a).then(function(){this._setItemExpanded(t);var r=this,l=this._getOptionDefaults();s.style.display="block",o.fadeIn(s,{duration:l.dataFadeInDuration}).then(function(){var o=this._addBusyState("animating skeleton removal",a);t.classList.add(this.constants.OJ_TREEVIEW_ANIMATED),this._setDisclosing(this._getKey(t),!0),"expand"===e?this._startAnimation(s,"expand",n).then(this._resolveAnimationPromise(r,t,i,o)):"collapse"===e?this._startAnimation(s,"collapse",n).then(this._resolveAnimationPromise(r,t,i,o)):this._resolveAnimationPromise(r,t,i,o)()}.bind(this))}.bind(this))},_expandAfterFetch:function(e,t,s){this._setItemExpanded(e);var n=this._getKey(e),i=this._getSubtree(e);if(i&&(i.style.display="block"),t){var a=this._addBusyState("animating expand",n);e.classList.add(this.constants.OJ_TREEVIEW_ANIMATED),this._setDisclosing(n,!0),this._startAnimation(i,"expand").then(this._resolveAnimationPromise(this,e,s,a))}this._refreshTopAndBottomSelectionClasses()},_setExpandedState:function(e,t,s){e._setDisclosing(e._getKey(t),!1),t.classList.remove(e.constants.OJ_TREEVIEW_ANIMATED),e._trigger("expand",s,e._getEventPayload(t));var n=e.options.expanded.add([e._getKey(t)]);e._userOptionChange("expanded",n,s)},_resolveAnimationPromise:function(e,t,s,n){return function(){this._setExpandedState(e,t,s),n()}.bind(this)},_collapse:function(e,t,s,n){var i=this,a=this._getKey(e);if(!(e.classList.contains(this.constants.OJ_COLLAPSED)||this._isLeaf(e)||t&&this._isDisclosing(a))){if(s&&this._isActionable(e,"focus"))this._focus(e,s);else if(e.contains(this._currentItem)){var o=e;this._isActionable(o,"focus")||(o=this._getPreviousActionableItem(e,"focus"))||(o=this._getNextActionableItem(e,"focus")),o?this._focus(o,s):(this.options.currentItem=null,this._resetFocus())}if(t){if(!this._trigger("beforeCollapse",s,this._getEventPayload(e))&&!1!==n)return;this._setDisclosing(a,!0)}e.classList.remove(this.constants.OJ_EXPANDED),e.classList.add(this.constants.OJ_COLLAPSED),this._setAriaExpanded(e,"false"),this._lastSelectedItem=null;var r=this._getSubtree(e);if(t){var l=this._addBusyState("animating collapse",a);e.classList.add(this.constants.OJ_TREEVIEW_ANIMATED),this._uiExpanded=this._uiExpanded.delete([a]),this._startAnimation(r,"collapse").then(function(){i._setDisclosing(a,!1),r.style.display="none",e.classList.remove(i.constants.OJ_TREEVIEW_ANIMATED),i._trigger("collapse",s,i._getEventPayload(e)),i._refreshTopAndBottomSelectionClasses();var t=i.options.expanded.delete([a]);i._userOptionChange("expanded",t,s),l()})}else r&&(r.style.display="none",this._refreshTopAndBottomSelectionClasses());this._isLeafOnlySelectionEnabled()&&!r&&this._fetchChildren(a,function(t){var s=t.values[0];i._truncateIfOverMaxCount(s.value);var n={fetchListResult:s.value,parentElem:e};i._renderItems(n).then(function(){i.isReady()&&i._isLeafOnlySelectionEnabled()&&i._initLeafOnlySelectionMode()})})}},_startAnimation:function(e,t,s){var n={};null==n[t]&&(n[t]=JSON.parse(this._getOptionDefaults()[t+"Animation"]));var i=n[t];return s&&("expand"!==i.effect&&"collapse"!==i.effect||Object.assign(i,s)),o.startAnimation(e,t,i,this)},_getEventPayload:function(e){return{key:this._getKey(e),item:e}},_isActionable:function(e,t){var s=this.options.item[t+"able"];return!1!==s&&("function"!=typeof s||s(this.getContextByNode(e)))},_isSelected:function(e){var t=this.options.selectionMode,s=this._getSelected();if("none"===t)return!1;var n=this._getKey(e);return s.has(n)},_getSelected:function(){return this._isLeafOnlySelectionEnabled()&&this._selectedKeysets?this._selectedKeysets.selected:this.options.selected},_select:function(e,t){if("none"!==this.options.selectionMode&&this._isActionable(e,"focus")&&this._isActionable(e,"select")){var s=this._isSelected(e);if(t){var n=t.key||t.keyCode,i=t.originalEvent.sourceCapabilities&&t.originalEvent.sourceCapabilities.firesTouchEvents,a=r.isTouchSupported()&&(i||null!=this.touchStartEvent&&this.touchStartEvent.target===t.target),o=r.isMetaKeyPressed(t),l=E.isArrowUpKeyEvent(n)||E.isArrowDownKeyEvent(n),d=this._getKey(e),c=new h.KeySetImpl;if((this._isMultiSelectionEnabled()||this._isLeafOnlySelectionEnabled())&&t.shiftKey&&!l){o?c=this._getSelected():this._clearSelection();for(var _=this._lastSelectedItem,u=_&&_.offsetTop<e.offsetTop?this._getNextActionableItem.bind(this):this._getPreviousActionableItem.bind(this);_&&_!==e;){var f=this._getKey(_);c.has(f)||(c=c.add([f]),this._setSelected(_)),_=u(_,"select")}s=!0,c=c.add([d])}else(this._isMultiSelectionEnabled()||this._isLeafOnlySelectionEnabled())&&(o||a||l)?(s=!s,c=this._getSelected(),c=s?c.add([d]):c.delete([d])):(a||E.isSpaceBarKeyEvent(n))&&s?(s=!1,c=new h.KeySetImpl):(s=!0,c=new h.KeySetImpl([d]));this._userSelectedOptionChange(c,t,!o&&!l&&!a),this._lastSelectedItem=e}s?this._setSelected(e):this._setUnselected(e)}},_getSelectorByItem:function(e){return e.getElementsByTagName("oj-selector")[0]},_updateIndeterminateState:function(e){if(this._isDefaultCheckBoxesEnabled()){var t,s,n=Array.from(this.element[0].getElementsByClassName("oj-indeterminate")),i=Array.from(e.values());for(s=n.length-1;s>=0;s--){var a=(t=n[s].parentElement).rowKey,o=i.indexOf(a);-1!==o?i.splice(o,1):t.indeterminate=!1}for(s=0;s<i.length;s++){var r=this._getItemByKey(i[s]);(t=this._getSelectorByItem(r)).indeterminate=!0}}},_setSelected:function(e){this._getItemContent(e).classList.add(this.constants.OJ_SELECTED),e.setAttribute("aria-selected","true");var t=this._getKey(e);this._setupSelector(t,e,!1),(this._isLeafOnlySelectionEnabled()||this._isMultiSelectionEnabled())&&this._setTopAndBottomSelectionClasses(e)},_setTopAndBottomSelectionClasses:function(e){let t=e,s=this._getItemContent(e);do{s=this._getItemContent(t),s.classList.remove(this.constants.OJ_TREEVIEW_SELECTED_TOP_ITEM),s.classList.remove(this.constants.OJ_TREEVIEW_SELECTED_BOTTOM_ITEM),t=this._getPreviousItem(t)}while(t&&this._isSelected(t)&&!this._isHiddenElement(e));s.classList.add(this.constants.OJ_TREEVIEW_SELECTED_TOP_ITEM);let n=e,i=this._getItemContent(e);do{i=this._getItemContent(n),i!==s&&i.classList.remove(this.constants.OJ_TREEVIEW_SELECTED_TOP_ITEM),i.classList.remove(this.constants.OJ_TREEVIEW_SELECTED_BOTTOM_ITEM),n=this._getNextItem(n)}while(n&&this._isSelected(n)&&!this._isHiddenElement(e));i.classList.add(this.constants.OJ_TREEVIEW_SELECTED_BOTTOM_ITEM)},_removeTopAndBottomSelectionClasses:function(e){const t=this._getPreviousItem(e);this._getItemContent(e).classList.remove(this.constants.OJ_TREEVIEW_SELECTED_TOP_ITEM),t&&this._isSelected(t)&&!this._isHiddenElement(e)&&this._getItemContent(t).classList.add(this.constants.OJ_TREEVIEW_SELECTED_BOTTOM_ITEM);const s=this._getNextItem(e);this._getItemContent(e).classList.remove(this.constants.OJ_TREEVIEW_SELECTED_BOTTOM_ITEM),s&&this._isSelected(s)&&!this._isHiddenElement(e)&&this._getItemContent(s).classList.add(this.constants.OJ_TREEVIEW_SELECTED_TOP_ITEM)},_isHiddenElement:function(e){const t=this._getParents(e,this.constants.PERIOD+this.constants.OJ_TREEVIEW_ITEM);for(let s=1;s<t.length;s++){const n=this._getSubtree(t[s]);if(n&&"none"===n.style.display&&e!==t[s])return!0}return!1},_refreshTopAndBottomSelectionClasses:function(){const e=this._getSelected();let t;t=e.isAddAll()?this._getAllTreeviewKeys():[...e.values()],t.forEach(e=>{const t=this._getItemByKey(e);t&&this._setTopAndBottomSelectionClasses(t)})},_setUnselected:function(e){this._getItemContent(e).classList.remove(this.constants.OJ_SELECTED),e.setAttribute("aria-selected","false");var t=this._getKey(e);this._setupSelector(t,e,!0),(this._isLeafOnlySelectionEnabled()||this._isMultiSelectionEnabled())&&this._removeTopAndBottomSelectionClasses(e)},_clearSelection:function(){for(var e=this._getSelectedItemContents(),t=e.length-1;t>=0;t--)this._setUnselected(e[t].parentElement)},_setupSelector:function(e,t,s){if(this._isDefaultCheckBoxesEnabled()){var n=this._getSelectorByItem(t),i=s?[]:[e];n&&(n.selectedKeys=new h.KeySetImpl(i))}},_getSelectedItemContents:function(){return this.element[0].querySelectorAll(this.constants.PERIOD+this.constants.OJ_TREEVIEW_ITEM_CONTENT+this.constants.PERIOD+this.constants.OJ_SELECTED)},_focus:function(e,t){if(this._isActionable(e,"focus")){if(t){var n=this._getEventPayload(e);if(this._currentItem&&(n.previousKey=this._getKey(this._currentItem),n.previousItem=this._currentItem),!this._trigger("beforeCurrentItem",t,n))return;this._userOptionChange("currentItem",this._getKey(e),t)}this._focusOutHandler(s(this._getItemContent(this._currentItem))),this._focusInHandler(s(this._getItemContent(e))),this._setCurrentItem(e)}},_resetFocus:function(){if(this.options.currentItem){var e=this._getItemByKey(this.options.currentItem);if(e)return void this._setCurrentItem(e)}var t=this._getItems()[0];this._isActionable(t,"focus")||(t=this._getNextActionableItem(t,"focus")),this._setCurrentItem(t),this._userOptionChange("currentItem",this._getKey(this._currentItem),null)},_setCurrentItem:function(e){this._currentItem=e;var t=this._getRoot();t&&e&&t.setAttribute("aria-activedescendant",this._getItemId(e))},_getItemId:function(e){return e.getAttribute("id")},_getUniqueItemId:function(){return u.ElementUtils.getUniqueId(this.element[0].getAttribute("id")).concat("_"+this._getTreeViewItemCount())},_getTreeViewItemCount:function(){return this._getItems().length},_addBusyState:function(e,t){var s=n.getContext(this.element[0]).getBusyContext(),i=this.element.attr("id"),a=s.addBusyState({description:"The component identified by '"+i+"', "+e});return this.m_fetching.add(t),this._changeStatusMessage(t,!1),function(){this._changeStatusMessage(t,!0),this.m_fetching.delete(t),a(),Promise.resolve(this._processEventQueue())}.bind(this)},_changeStatusMessage:function(e,t){const s=this.element[0].getElementsByClassName("oj-helper-hidden-accessible")[0];let n;const i=null!==e?this._getNodeTextByKey(e):this.element[0].getAttribute("id");n=t?f.getTranslatedString("oj-ojTreeView.receivedDataAria",{nodeText:i}):f.getTranslatedString("oj-ojTreeView.retrievingDataAria",{nodeText:i}),s.textContent=n},_getNodeTextByKey:function(e){const t=this._getItemByKey(e);if(t){const e=/[\n\r]+|[\s]{2,}/g;return this._getItemContent(t).textContent.replace(e," ").trim()}return null},_userOptionChange:function(e,t,s){this.option(e,t,{_context:{originalEvent:s,writeback:!0,internalSet:!0}})},_userSelectedOptionChange:function(e,t,s){let n=e;if(this._isLeafOnlySelectionEnabled()){let e=s?this._getEmptyKeySet(n):this._getSelected();this._selectedKeysets=this.treeviewSelectionManager.computeSelection(n,e),n=this._selectedKeysets.selectedLeaves}this._userOptionChange("selected",n,t),this._userOptionChange("selection",h.KeySetUtils.toArray(n),t),this._refreshSelectionItems()},_getEmptyKeySet:function(e){return e.isAddAll()?new h.AllKeySetImpl:new h.KeySetImpl},_filterOutParentKeys:function(e){if(e.isAddAll()){let t=new h.AllKeySetImpl,s=[...e.deletedValues()].filter(e=>!this.treeviewSelectionManager.parentKeyNodeMap.has(e));return t=t.delete(s),t}return new h.KeySetImpl([...e.values()].filter(e=>!this.treeviewSelectionManager.parentKeyNodeMap.has(e)))},_getDragOptions:function(){return((this.options.dnd||{}).drag||{}).items||{}},_getDropOptions:function(){return((this.options.dnd||{}).drop||{}).items||{}},_getClosestItem:function(e){return this._closest(e,this.constants.PERIOD+this.constants.OJ_TREEVIEW_ITEM)},_getClosestItemContent:function(e){return this._closest(e,".oj-treeview-item-content")},_getClosestDisclosureIcon:function(e){return this._closest(e,".oj-treeview-disclosure-icon")},_handleClick:function(e){if(!E.isFromDefaultSelector(e)){var t,s=this._getClosestDisclosureIcon(e.target);if(s){t=this._getClosestItem(s);var n=this._getKey(t);if(this.m_fetching.has(n))return;return this._isExpanded(t)?this._collapse(t,!0,e):this._expand(t,!0,e),void(this.touchStartEvent=null)}var i=this._getClosestItemContent(e.target);if(i)return t=i.parentNode,this._select(t,e),this._focus(t,e),void(this.touchStartEvent=null);"none"!==this.options.selectionMode&&(this._clearSelection(),this._lastSelectedItem=null,this._userSelectedOptionChange(new h.KeySetImpl,e)),this.touchStartEvent=null}},_isDnD:function(){var e=this._getDragOptions();return Object.keys(e).length>0},_handleMouseOver:function(e){if((!r.isTouchSupported()||!this.touchStartEvent)&&("none"!==this.options.selectionMode||this._isDnD())){var t=this._getClosestDisclosureIcon(e.target);t||(t=this._getClosestItemContent(e.target)),t&&(t.classList.remove(this.constants.OJ_DEFAULT),t.classList.add(this.constants.OJ_HOVER))}},_handleMouseOut:function(e){var t=this._getClosestDisclosureIcon(e.target);t&&t.classList.remove(this.constants.OJ_SELECTED),t||(t=this._getClosestItemContent(e.target)),t&&(t.classList.add(this.constants.OJ_DEFAULT),t.classList.remove(this.constants.OJ_HOVER))},_handleMouseDown:function(e){if(!E.isFromDefaultSelector(e)){var t=this._getClosestDisclosureIcon(e.target);t&&t.classList.add(this.constants.OJ_SELECTED)}},_handleMouseUp:function(e){var t=this._getClosestDisclosureIcon(e.target);t&&t.classList.remove(this.constants.OJ_SELECTED)},_handleKeyDown:function(e){var t,s=this._currentItem,n=e.key||e.keyCode;if(E.isArrowUpKeyEvent(n)||E.isArrowDownKeyEvent(n))(t=E.isArrowDownKeyEvent(n)?this._getNextActionableItem(s,"focus"):this._getPreviousActionableItem(s,"focus"))&&(e.preventDefault(),this._isSelected(s)&&e.shiftKey&&this._select(this._isSelected(t)?s:t,e),this._scrollToVisible(t,n),this._focus(t,e));else if(E.isArrowLeftKeyEvent(n)||E.isArrowRightKeyEvent(n)){var i="rtl"===this._GetReadingDirection(),a=!i&&E.isArrowRightKeyEvent(n)||i&&E.isArrowLeftKeyEvent(n);!a||this._isLeaf(s)||this._isExpanded(s)?a||this._isLeaf(s)||!this._isExpanded(s)?(t=a?this._getNextActionableItem(s,"focus"):this._getPreviousActionableItem(s,"focus"))&&(e.preventDefault(),this._focus(t,e)):(e.preventDefault(),this._collapse(s,!0,e)):(e.preventDefault(),this._expand(s,!0,e))}else if(E.isEnterKeyEvent(n)||E.isSpaceBarKeyEvent(n))e.preventDefault(),this._select(s,e);else if(E.isLetterAKeyEvent(n)&&r.isMetaKeyPressed(e)&&(this._isLeafOnlySelectionEnabled()||this._isMultiSelectionEnabled())){e.preventDefault();for(var o=this._getItems(),l=new h.AllKeySetImpl,d=0;d<o.length;d++)this._isActionable(o[d],"select")&&this._setSelected(o[d]);this._userSelectedOptionChange(l,e)}},_scrollToVisible:function(e,t){var s,n=this._getItemSpacer(e).offsetHeight,i=this.element[0],a=i.scrollTop,o=n,r=a,l=a+this.element[0].offsetHeight;s=e.offsetTop-this.element[0].offsetTop,E.isArrowUpKeyEvent(t)&&(s+=o),s<r?i.scrollTop=a+(s-r-1):s>l&&(i.scrollTop=a+(s-l+1))},_getNextItem:function(e){if(!this._isLeaf(e)&&this._isExpanded(e)){var t=this._getChildItems(e)[0];if(t)return t}for(var s=e;s;){var n=this._getNextSibling(s,this.constants.PERIOD+this.constants.OJ_TREEVIEW_ITEM);if(n)return n;s=this._getParentItem(s)}return null},_getNextActionableItem:function(e,t){for(;null!=e;)if(null!=(e=this._getNextItem(e))&&this._isActionable(e,t))return e;return null},_getPreviousItem:function(e){for(var t=this._getPreviousSibling(e,this.constants.PERIOD+this.constants.OJ_TREEVIEW_ITEM);t;){if(this._isLeaf(t)||!this._isExpanded(t))return t;var s=this._getChildItems(t),n=s[s.length-1];if(!n)return t;t=n}var i=this._getParentItem(e);return i||null},_getPreviousActionableItem:function(e,t){for(;null!=e;)if(null!=(e=this._getPreviousItem(e))&&this._isActionable(e,t))return e;return null},_handleDragStart:function(e){r.isTouchSupported()&&(this.ojTreeViewDragEvent=!0);var s=this,n="rtl"===this._GetReadingDirection(),i=this._getClosestItem(e.target);if(i){var a,o=[];if(this._isSelected(i)){var l=this.options.selection;for(a=0;a<l.length;a++){var d=this._getItemByKey(l[a]);d&&o.push(d)}}else this._select(i,e),o.push(i);var h=this._getDragOptions(),c=e.originalEvent.dataTransfer,_=document.createElement("ul");_.classList.add(this.constants.OJ_TREEVIEW_DRAG_IMAGE),_.classList.add(this.constants.OJ_TREEVIEW_LIST),t.AgentUtils.getAgentInfo().browser===t.AgentUtils.BROWSER.SAFARI&&(_.style.position="absolute");var u,E=[],f=1/0,p=1/0;for(o.forEach(function(e){const t=e[s.constants.OJ_ITEM_DATA];t?E.push(t):E.push(e.parentElement.innerHTML);var i=s._getItemSpacer(e),a=e.getBoundingClientRect(),o=a.top,r=void 0===i?0:i.offsetWidth;if(n){for(var l=s._getItemContent(e).children,d=0,h=0;h<l.length;h++)d+=l[h].offsetWidth;r=s._getTreeviewWidth()+a.x-d-r}o+=document.body.scrollTop,r+=document.body.scrollLeft;var c=e.cloneNode(!0);c.style.top=o+"px",c.style.left=r+"px",e.classList.add(s.constants.OJ_TREEVIEW_DRAG_SOURCE),c.classList.add(s.constants.OJ_TREEVIEW_DRAG_IMAGE),c.classList.add(s.constants.OJ_TREEVIEW_DRAG_IMAGE_ITEM);var u=s._getSubtree(c);u&&c.removeChild(u);var m=s._getItemContent(c);s._setUnselected(c),m.classList.remove(s.constants.OJ_FOCUS),m.classList.remove(s.constants.OJ_HOVER),m.classList.remove(s.constants.OJ_FOCUS_HIGHLIGHT),m.classList.remove(s.constants.OJ_DRAGGABLE);var g=c.getElementsByClassName(s.constants.OJ_TREEVIEW_SPACER)[0];if(g){var v=document.createElement("span");s._addTreeviewSpacerClass(v),m.insertBefore(v,g),m.removeChild(g)}if(s._isDefaultCheckBoxesEnabled()&&s._isActionable(e,"focus")&&s._isActionable(e,"select")){var I=c.getElementsByClassName(s.constants.OJ_TREEVIEW_SELECTOR)[0];I.firstChild.selectedKeys=s.options.selected,I.firstChild.rowKey=s._getKey(e)}o<f&&(f=o),r<p&&(p=r),_.appendChild(c)}),a=0;a<_.children.length;a++)(u=_.children[a]).style.top=parseFloat(u.style.top)-f+"px",u.style.left=parseFloat(u.style.left)-p+"px";var m=h.dataTypes,g="string"==typeof m?[m]:m||[];for(a=0;a<g.length;a++)c.setData(g[a],JSON.stringify(E));document.body.appendChild(_),c.setDragImage(_,e.pageX-p,e.pageY-f),setTimeout(function(){_.parentElement.removeChild(_)},0);var v=h.dragStart;v&&v(e.originalEvent,{items:E})}},_handleDragSourceEvent:function(e,t){"dragEnd"===t&&(this._removeGhostElements(),this._dropLine.style.display="none"),"dragEnd"===t&&r.isTouchSupported()&&(this.ojTreeViewDragEvent=!1);var s=this._getDragOptions()[t];s&&s(e.originalEvent)},_getTreeviewWidth:function(){return this.element[0].offsetWidth},_getItemSpacer:function(e){return e.getElementsByClassName(this.constants.OJ_TREEVIEW_SPACER)[0]},_handleDropTargetEvent:function(e,t){var s=this._getDropOptions(),n=s.dataTypes,i="string"==typeof n?[n]:n||[],a=s[t],o=this._getClosestItem(e.target);if(o){var l=this._getItemSpacer(o).getBoundingClientRect(),d="inside",h=e.originalEvent.clientY-l.top;h<.25*l.height?d="before":h>.75*l.height&&(d=this._isExpanded(o)?"first":"after"),a&&a(e.originalEvent,{item:o,position:d});for(var c=0;c<i.length;c++){var _=e.originalEvent.dataTransfer.types;if(_&&_.indexOf(i[c])>=0){e.preventDefault();break}}if("dragEnter"!==t&&"dragOver"!==t||!e.originalEvent.defaultPrevented){if("drop"===t&&(this._removeGhostElements(),this._dropLine.style.display="none",this._removeDropClass(o)),"drop"===t&&r.isTouchSupported()&&(this.ojTreeViewDragEvent=!1),"dragLeave"===t){var u=o.offsetWidth;if("DIV"===e.target.nodeName&&e.target.classList.contains(this.constants.OJ_TREEVIEW_ITEM_CONTENT)&&(e.offsetX>=u||e.offsetX<=0))this._dropLine.style.display="none",r.isTouchSupported()&&(this.ojTreeViewDragEvent=!1),this._removeDropClass(o);else if(e.offsetY>=o.offsetHeight||e.offsetY<=0){var E=this._getItems();if(E.length>0){var f=E[0];(o===E[E.length-1]&&"after"===d||o===f&&"before"===d)&&(this._dropLine.style.display="none",r.isTouchSupported()&&(this.ojTreeViewDragEvent=!1))}else 0===E.length&&(this._dropLine.style.display="none",r.isTouchSupported()&&(this.ojTreeViewDragEvent=!1))}"inside"!==d&&this._removeDropClass(o)}}else{"dragEnter"===t&&r.isTouchSupported()&&(this.ojTreeViewDragEvent=!0);var p="rtl"===this._GetReadingDirection(),m=o.offsetTop;if("before"!==d&&(m+=l.height),"inside"!==d){var g,v=this._getParentItem(o);v&&this._isLeaf(o)?(g=l.width,g-=this._getItemDisclosureIcon(v).offsetHeight):v&&!this._isLeaf(o)?(g=l.width,"first"===d&&(g+=this._getItemDisclosureIcon(o).offsetHeight)):v||(g=0,"first"===d&&(g+=this._getItemDisclosureIcon(o).offsetHeight)),this._removeDropClass(o);var I=this._getTreeviewWidth()-parseInt(g,10)+"px",y=p?"0px":g+"px";this._dropLine.style.width=I,this._dropLine.style.left=y,this._dropLine.style.top=m+"px",this._dropLine.style.display=""}else this._dropLine.style.display="none",this._addDropClass(o)}}},_addDropClass:function(e){this._getItemContent(e).classList.add(this.constants.OJ_TREEVIEW_DROP_ZONE)},_removeDropClass:function(e){this._getItemContent(e).classList.remove(this.constants.OJ_TREEVIEW_DROP_ZONE)},_removeGhostElements:function(){for(var e=this.element[0].querySelectorAll(this.constants.PERIOD+this.constants.OJ_TREEVIEW_DRAG_SOURCE),t=e.length-1;t>=0;t--)e[t].classList.remove(this.constants.OJ_TREEVIEW_DRAG_SOURCE)},_NotifyContextMenuGesture:function(e,t,s){if("keyboard"===s){var n=this._currentItem?this._getItemContent(this._currentItem):this.element,i={launcher:this._getRoot(),initialFocus:"menu",position:{my:"start top",at:"start bottom",of:n}};this._OpenContextMenu(t,s,i)}else if(!this.ojTreeViewDragEvent){var a=this._getClosestItem(t.target);a&&(this._setCurrentItem(a),this._userOptionChange("currentItem",this._getKey(this._currentItem),t),this._superApply(arguments))}},refresh:function(){this._super(),this._refreshId+=1,delete this.m_template,delete this.m_engine,delete this.m_dataSource,this._expandedChildrenMap=new Map,this.m_fetching=new Set,this._render()},getNodeBySubId:function(e){if(null==e)return this.element?this.element[0]:null;var t,s=e.key,n=e.subId,i=this._getItemByKey(s);return"oj-treeview-disclosure"===n&&i?t=i.getElementsByClassName(this.constants.OJ_TREEVIEW_DISCLOSURE_ICON)[0]:n===this.constants.OJ_TREEVIEW_ITEM&&i&&(t=i.getElementsByClassName(this.constants.OJ_TREEVIEW_ITEM_CONTENT)[0]),t||null},getSubIdByNode:function(e){if(!this.element[0].contains(e))return null;var t,s=this._getClosestDisclosureIcon(e),n=this._getClosestItem(e);if(s)t="oj-treeview-disclosure";else{if(!n)return null;t=this.constants.OJ_TREEVIEW_ITEM}return{subId:t,key:this._getKey(n)}},getContextByNode:function(e){if(!this.element[0].contains(e))return null;var t,s=this._getClosestItem(e);if(!s)return null;var n=s.parentNode.children,i=[];for(t=0;t<n.length;t++)n[t].classList.contains(this.constants.OJ_TREEVIEW_ITEM)&&i.push(n[t]);var o={subId:this.constants.OJ_TREEVIEW_ITEM,index:i.indexOf(s),parentKey:this._getKey(this._getParentItem(s))};o.component=a.__GetWidgetConstructor(this.element),this._FixRendererContext&&(o=this._FixRendererContext(o));var r=s[this.constants.OJ_ITEM_METADATA];if(r){o.metadata=r,o.data=s[this.constants.OJ_ITEM_DATA],o.datasource=this.options.data;var l=Object.keys(r);for(t=0;t<l.length;t++){var d=l[t];o[d]=r[d]}}else o.key=this._getKey(s),o.leaf=this._isLeaf(s),o.depth=this._getParents(s,".oj-treeview-list").length;return o},_setOption:function(e,t,s){var n,i,a=this;if(this._isLeafOnlySelectionEnabled()&&(!this._isLeafOnlySelectionEnabled()||"selected"===e&&"selection"===e)||this._superApply(arguments),"expanded"===e)for(this._uiExpanded=a._uiExpanded.clear(),this._expandedChildrenMap=new Map,i=this._getItems(),n=0;n<i.length;n++){var o=this._getKey(i[n]);a._isInitExpanded(o)?a._expand(i[n],!0):a._collapse(i[n],!0)}else if("selected"===e){if(this._isLeafOnlySelectionEnabled()){let e=t;e=this._filterOutParentKeys(e);let s=this._getEmptyKeySet(e);this._selectedKeysets=this.treeviewSelectionManager.computeSelection(e,s),t=this._selectedKeysets.selectedLeaves,arguments[1]=t,this._superApply(arguments)}var r=h.KeySetUtils.toArray(t);this._userOptionChange("selection",r,null),this._refreshSelectionItems()}else if("selection"===e){var l=h.KeySetUtils.toKeySet(t);if(this._isLeafOnlySelectionEnabled()){let e=l;e=this._filterOutParentKeys(e);let t=this._getEmptyKeySet(e);this._selectedKeysets=this.treeviewSelectionManager.computeSelection(e,t),l=this._selectedKeysets.selectedLeaves,arguments[1]=h.KeySetUtils.toArray(l),this._superApply(arguments)}this._userOptionChange("selected",l,null),this._refreshSelectionItems()}else"currentItem"===e?this._resetFocus():"data"===e?(this._removeDataProviderEventListeners(),this.options.data=t,this.options.data||this._getRoot().remove(),this._addDataProviderEventListeners(),this.refresh()):this.refresh()},_SetupResources:function(){this._super(),this._addDataProviderEventListeners()},_ReleaseResources:function(){this._super(),this._removeDataProviderEventListeners()},_destroy:function(){this._removeDataProviderEventListeners(),this._super()},_addDataProviderEventListeners:function(){var e=this.options.data;e&&t.DataProviderFeatureChecker.isTreeDataProvider(e)&&(this.m_handleModelMutateEventListener=this.handleModelMutateEvent.bind(this),this.m_handleModelRefreshEventListener=this.handleModelRefreshEvent.bind(this),e.addEventListener("mutate",this.m_handleModelMutateEventListener),e.addEventListener("refresh",this.m_handleModelRefreshEventListener))},_removeDataProviderEventListeners:function(){var e=this.options.data;e&&t.DataProviderFeatureChecker.isTreeDataProvider(e)&&(e.removeEventListener("mutate",this.m_handleModelMutateEventListener),e.removeEventListener("refresh",this.m_handleModelRefreshEventListener))},handleModelMutateEvent:function(e){this._isLeafOnlySelectionEnabled()?l.error("Mutations are not supported in selectionMode: leafOnly  "):this.isReady()?(null!=e.detail.remove&&this.handleModelRemoveEvent(e),null!=e.detail.add&&this.handleModelAddEvent(e),null!=e.detail.update&&this.handleModelChangeEvent(e),this._processEventQueue()):this._pushToEventQueue(e)},_pushToEventQueue:function(e){null==this.m_eventQueue&&(this.m_eventQueue=[]),this.m_eventQueue.push(e)},_clearEventQueue:function(){null!=this.m_eventQueue&&(this.m_eventQueue.length=0)},_processEventQueue:function(){if(!this.isReady())return;let e;if(null!=this.m_eventQueue&&this.m_eventQueue.length>0){for(var t=0;t<this.m_eventQueue.length;t++)if(e=this.m_eventQueue[t],"refresh"===e.type&&(!e.detail||e.detail&&!e.detail.keys))return void this.handleModelRefreshEvent(e);e=this.m_eventQueue.shift(),"mutate"===e.type&&this.handleModelMutateEvent(e),"refresh"===e.type&&e.detail&&e.detail.keys&&this.handleModelMutateEvent(e)}},isReady:function(){return 0===this.m_fetching.size},handleModelRemoveEvent:function(e){var t=this,s=e.detail.remove.keys,n=[];if(null!=s&&0!==s.size&&(s.forEach(function(s){(!e.detail.add||e.detail.add&&!e.options.detail.add.keys.has(s))&&(n=n.concat(t._removeAllChildrenOfParentKey(s)))}),0!==n.length)){var i=this._getSelected();if(null!=i){var a=i.delete(n);i!==a&&this._userSelectedOptionChange(a,e)}var o=this.options.expanded;if(null!=o){var r=o.delete(n);this._uiExpanded.delete(n),o!==r&&this._userOptionChange("expanded",r,null)}this._resetFocus()}},_changeNodeToLeaf:function(e,t){if(e!==this.element[0]){e.removeChild(t),e[this.constants.OJ_ITEM_METADATA].leaf=!0,e.classList.add(this.constants.OJ_TREEVIEW_LEAF),e.classList.remove(this.constants.OJ_EXPANDED),e.removeAttribute("aria-expanded"),e.classList.remove(this.constants.OJ_COLLAPSED);var s=this._getItemSpacer(e);this._removeIndentation(s),this._addIndentation(e,s);var n=this._getKey(e),i=[];i.push(n);var a=this.options.expanded;if(null!=a){var o=a.delete(i);this._uiExpanded.delete(i),a!==o&&this._userOptionChange("expanded",o,null)}var r=this._getItemDisclosureIcon(e);this._removeDisclosureClasses(r)}},_changeNodeToParent:function(e){e[this.constants.OJ_ITEM_METADATA].leaf=!1,e.classList.remove(this.constants.OJ_TREEVIEW_LEAF),e.classList.add(this.constants.OJ_COLLAPSED),this._setAriaExpanded(e,"false"),this._refreshTopAndBottomSelectionClasses();var t=this._getItemSpacer(e);this._removeIndentation(t),this._addIndentation(e,t);var s=this._getItemDisclosureIcon(e);this._addDisclosureClasses(s)},_setAriaExpanded:function(e,t){e.setAttribute("aria-expanded",t)},_getItemDisclosureIcon:function(e){return e.getElementsByTagName("ins")[0]},_removeAllChildrenOfParentKey:function(e,s){var n=this,i=[],a=this._getItemByKey(e);if(a){this._getChildItems(a).forEach(function(e){var t=n._getKey(e),a=n._removeAllChildrenOfParentKey(t,s);i=i.concat(a)});var o=a.parentNode;t.KeyUtils.equals(e,s)||(o.removeChild(a),this._keyList.delete(e),i.push(e)),0!==o.getElementsByTagName("li").length||s||this._changeNodeToLeaf(o.parentNode,o)}return i},_isLeafIcon:function(e){return e.classList.contains(this.constants.OJ_TREEVIEW_LEAF)},handleModelReorder:function(e,t,s){var n=this._getItemByKey(t),i=n.parentElement,a=this._getItemByKey(e),o=a.parentElement,r=a.parentNode;o.removeChild(a),0===o.getElementsByTagName("li").length&&this._changeNodeToLeaf(r.parentNode,r),s?i.insertBefore(a,n.nextSibling):i.insertBefore(a,n)},getLastItemKey(e){return this._getKey(e[e.length-1])},handleModelAddEvent:function(e){var t=e.detail.add,s=t.parentKeys,n=t.indexes,i=0,a=this,o=e.detail.add.keys;const r=[],l=this._addBusyState("validating mutation data for add event",null);this._fetchEventDataForKeys(t).then(d=>{if(null===d)return void l();this._truncateIfOverMaxCount(d);const h=d.data,c=d.metadata;o.forEach(s=>{if(!e.detail.remove||e.detail.remove&&!e.options.detail.remove.keys.has(s))r.push(s);else if(t.addBeforeKeys&&t.addBeforeKeys[i]&&0!==t.addBeforeKeys.length)this.handleModelReorder(s,t.addBeforeKeys[i],!1);else{var n;if(t.parentKeys&&t.parentKeys[i]&&0!==t.parentKeys.length){var a=this._getItemByKey(t.parentKeys[i]),o=this._getChildItems(a);n=this.getLastItemKey(o)}else{var l=this._getItems();n=this.getLastItemKey(l)}n&&this.handleModelReorder(s,n,!0)}i+=1}),s.forEach(function(e){var t=a._getItemByKey(e);t&&a._isLeafIcon(t)&&a._changeNodeToParent(t)});const _=this._getAllTreeviewKeys(),u=E.getAddEventKeysResult(_,t,!0);if(h&&r.length>0&&h.length>0&&r.length===h.length&&(null==n||n.length===h.length))for(i=0;i<h.length;i++){var f=s[i],p=this._getInsertIndex(c[i].key,f,u);if(null!==p){var m,g=this._getItemByKey(f);null==f?(m=this._getRoot())&&this._renderItem(m,{data:[h[i]],metadata:[c[i]]},0,p):g&&(m=this._getSubtree(g))&&this._renderItem(m,{data:[h[i]],metadata:[c[i]]},0,p)}}l()})},_getInsertIndex:function(e,t,s){let n;if(n=t?this._getItemByKey(t):this.element[0],!n)return null;let i=s.indexOf(e);if(-1===i)return null;let a=this._getChildItems(n),o=a.length;for(let e=0;e<a.length;e++){let t=a[e],n=this._getKey(t);if(s.indexOf(n)>i){o=e;break}}return o},_getAllTreeviewKeys:function(){const e=[],t=this._getItems();for(let s=0;s<t.length;s++)e.push(this._getKey(t[s]));return e},handleModelChangeEvent:function(e){const t=e.detail.update,s=this._addBusyState("validating mutation data for change event",null);this._fetchEventDataForKeys(t).then(e=>{if(null===e)return void s();const t=[...e.keys];for(let s=0;s<t.length;s++){const n=this._getItemByKey(t[s]);if(null!=n){const t=this._indexToParent(n);this._renderItem(null,{data:[e.data[s]],metadata:[e.metadata[s]]},0,t,!0)}}this._resetFocus(),s()})},_fetchEventDataForKeys:function(e){return new Promise(t=>{const s=this._addBusyState("getting data provider",null);this._getDataProvider().then(n=>{t(E.getEventDetail(n,e)),s()},function(e){l.error(this.constants.ERROR_FETCHING_DATA+e),s()})})},_indexToParent:function(e){for(var t=0,s=0;s<e.parentNode.children.length;s++)if(e.parentNode.children[s]===e){t=s;break}return t},handleModelRefreshEvent:function(e){this.isReady()?e.detail&&e.detail.keys?e.detail.keys.forEach(e=>{const t=this._getItemByKey(e);if(t&&!this._isLeaf(t)){this._removeAllChildrenOfParentKey(e,e);const s=this._getSubtree(t);s&&t.removeChild(s),this._isExpanded(t)&&(t.classList.remove(this.constants.OJ_EXPANDED),this._expand(t,!0))}}):(this._clearEventQueue(),this.refresh()):this._pushToEventQueue(e)},_isSkeletonSupported:function(){return"skeleton"===this._getOptionDefaults().loadIndicator},_getOptionDefaults:function(){if(null==this.defaultOptions){this.defaultOptions={};const e=Object.keys(this.constants.OJ_TREEVIEW_CSS_VARS),t=e.map(e=>this.constants.OJ_TREEVIEW_CSS_VARS[e]),s=i.getCachedCSSVarValues(t);e.forEach((e,t)=>{this.defaultOptions[e]=s[t]})}return this.defaultOptions},_renderChildSkeletons:function(e){var t=this._getItemByKey(e);this._removeExistingSkeletons(t);var s=this._getItemDisclosureIcon(t).offsetWidth,n="rtl"===this._GetReadingDirection(),i=this._buildThreeItemedSkeleton(),a=this._buildSkeletonContainer(),o=s,r=this._getDepth(t);n?a.style.marginRight=o+s/r+"px":a.style.marginLeft=o+s/r+"px",a.appendChild(i),t.appendChild(a)},_renderInitialSkeletons:function(){this._removeExistingSkeletons(this.element[0]);var e=this._buildThreeItemedSkeleton(),t=this._buildTwoItemedSkeleton(),s=this._buildSkeletonContainer();s.appendChild(e),s.appendChild(t),this.element[0].classList.add(this.constants.OJ_COMPLETE),this.element[0].appendChild(s);var n=s.offsetHeight,i=this.element[0].offsetHeight,a=n/5,o=0;if(n<i)do{o%2==0?(n+=3*a,s.appendChild(this._buildThreeItemedSkeleton())):(n+=2*a,s.appendChild(this._buildTwoItemedSkeleton())),o+=1}while(n<=i);if(n>i){var r=s.querySelectorAll(this.constants.PERIOD+this.constants.OJ_TREEVIEW_SKELETON_CONTENT);for(o=r.length-1;o>=0&&(n-=a,s.removeChild(r[o]),!(n<=i));o--);}},_removeExistingSkeletons:function(e){for(var t=e.querySelectorAll(this.constants.PERIOD+this.constants.OJ_TREEVIEW_SKELETON_CONTAINER),s=0;s<t.length;s++)e.removeChild(t[s])},_getSkeletonContainer:function(e){return e.getElementsByClassName(this.constants.OJ_TREEVIEW_SKELETON_CONTAINER)[0]},_removeSkeleton:function(e){return new Promise(function(t){var s,n=this._addBusyState("removing skeleton",e);(s=null===e?this._getSkeletonContainer(this.element[0]):this._getSkeletonContainer(this._getItemByKey(e)))?o.fadeOut(s,{duration:"100ms"}).then(function(){s.parentElement&&s.parentElement.removeChild(s),n(),t()}):(n(),t())}.bind(this))},_buildThreeItemedSkeleton:function(){var e=this._buildTwoItemedSkeleton(),t=this._buildSkeletonLeafContent();return e.appendChild(t),e},_buildTwoItemedSkeleton:function(){var e=new DocumentFragment,t=this._buildSkeletonContent(!1);e.appendChild(t);var s=this._buildSkeletonContent(!0);return e.appendChild(s),e},_buildSkeletonContainer:function(){var e=document.createElement("div");return e.classList.add(this.constants.OJ_TREEVIEW_SKELETON_CONTAINER),e.classList.add(this.constants.OJ_ANIMATION_SKELETON_FADE_IN),e},_buildSkeletonContent:function(e){var t=document.createElement("div");t.classList.add(this.constants.OJ_TREEVIEW_SKELETON_CONTENT);var s=this._buildSkeletonCarrot();return e&&s.classList.add(this.constants.OJ_TREEVIEW_SKELETON_CHILD),t.appendChild(s),t.appendChild(this._buildSkeletonItem()),t},_buildSkeletonCarrot:function(){var e=document.createElement("div");return e.classList.add(this.constants.OJ_TREEVIEW_SKELETON_CARROT),e.classList.add(this.constants.OJ_ANIMATION_SKELETON),e},_buildSkeletonItem:function(){var e=document.createElement("div");return e.classList.add(this.constants.OJ_TREEVIEW_SKELETON_ITEM),e.classList.add(this.constants.OJ_ANIMATION_SKELETON),e},_buildSkeletonLeafContent:function(){var e=document.createElement("div");return e.classList.add(this.constants.OJ_TREEVIEW_SKELETON_CONTENT),e.appendChild(this._buildSkeletonLeafItem()),e},_buildSkeletonLeafItem:function(){var e=document.createElement("div");return e.classList.add(this.constants.OJ_TREEVIEW_SKELETON_LEAF),e.classList.add(this.constants.OJ_ANIMATION_SKELETON),e},_closest:function(e,t){if(!e)return null;if(!e.closest){do{if(this._matches(e,t))return e;e=e.parentElement||e.parentNode}while(null!==e&&1===e.nodeType);return null}return e.closest(t)},_getParents:function(e,t){for(var s=[];e&&e!==document;e=e.parentNode)this._matches(e,t)&&s.push(e);return s},_getNextSibling:function(e,t){var s=e.nextElementSibling;if(!t)return s;for(;s;){if(this._matches(s,t))return s;s=s.nextElementSibling}return null},_getPreviousSibling:function(e,t){var s=e.previousElementSibling;if(!t)return s;for(;s;){if(this._matches(s,t))return s;s=s.previousElementSibling}return null},_matches:function(e,t){return e.matches||(e.matches=Element.prototype.msMatchesSelector||Element.prototype.webkitMatchesSelector),e.matches(t)}});var m={properties:{currentItem:{type:"any",writeback:!0,readOnly:!0},data:{type:"object",extension:{webelement:{exceptionStatus:[{type:"deprecated",since:"11.0.0",description:"Data sets from a DataProvider cannot be sent to WebDriverJS; use ViewModels or page variables instead."}]}}},dnd:{type:"object",properties:{drag:{type:"object",properties:{items:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},drag:{type:"function"},dragEnd:{type:"function"},dragStart:{type:"function"}}}}},drop:{type:"object",properties:{items:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},dragEnter:{type:"function"},dragLeave:{type:"function"},dragOver:{type:"function"},drop:{type:"function"}}}}}}},expanded:{type:"KeySet",writeback:!0},item:{type:"object",properties:{focusable:{type:"function"},renderer:{type:"function"},selectable:{type:"function"}}},scrollPolicyOptions:{type:"Object<number>",properties:{maxCount:{type:"number",value:500}}},selected:{type:"KeySet",writeback:!0},selection:{type:"Array<any>",writeback:!0,value:[]},selectionMode:{type:"string",enumValues:["leafOnly","multiple","none","single"],value:"none"},translations:{type:"object",value:{},properties:{receivedDataAria:{type:"string"},retrievingDataAria:{type:"string"},treeViewSelectorAria:{type:"string"}}}},methods:{getContextByNode:{},getProperty:{},refresh:{},setProperties:{},setProperty:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojAnimateEnd:{},ojAnimateStart:{},ojBeforeCollapse:{},ojBeforeCurrentItem:{},ojBeforeExpand:{},ojCollapse:{},ojExpand:{}},extension:{}};m.extension._WIDGET_NAME="ojTreeView",t.CustomElementBridge.register("oj-tree-view",{metadata:m})});
//# sourceMappingURL=ojtreeview.js.map