/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","ojs/ojdvt-toolkit","ojs/ojdvt-timecomponent","ojs/ojtimeaxis-toolkit","ojs/ojkeyboardfocus-utils","ojs/ojdvt-overview"],function(e,t,i,s,a,r){"use strict";class n extends i.TimeComponentKeyboardHandler{isMoveInitiationEvent(e){return e.keyCode===t.KeyboardEvent.M&&e.ctrlKey}isResizeStartInitiationEvent(e){return 83===e.keyCode&&e.altKey}isResizeEndInitiationEvent(e){return 69===e.keyCode&&e.altKey}isDnDScaleUpEvent(e){return this._eventManager.getKeyboardDnDMode()&&e.keyCode===t.KeyboardEvent.PAGE_UP}isDnDScaleDownEvent(e){return this._eventManager.getKeyboardDnDMode()&&e.keyCode===t.KeyboardEvent.PAGE_DOWN}isDnDForwardEvent(e){var i=t.Agent.isRightToLeft(this._eventManager._component.getCtx());return this._eventManager.getKeyboardDnDMode()&&e.keyCode===(i?t.KeyboardEvent.LEFT_ARROW:t.KeyboardEvent.RIGHT_ARROW)}isDnDBackwardEvent(e){var i=t.Agent.isRightToLeft(this._eventManager._component.getCtx());return this._eventManager.getKeyboardDnDMode()&&e.keyCode===(i?t.KeyboardEvent.RIGHT_ARROW:t.KeyboardEvent.LEFT_ARROW)}isDnDFinalizeEvent(e){return this._eventManager.getKeyboardDnDMode()&&e.keyCode===t.KeyboardEvent.ENTER}isDnDCancelEvent(e){return this._eventManager.getKeyboardDnDMode()&&e.keyCode===t.KeyboardEvent.ESCAPE}processKeyDown(e){var i=this._eventManager._component.getOptions()._keyboardUtils,s=this._eventManager.getFocus();if(this.isMoveInitiationEvent(e)&&s&&this._eventManager._component.isDnDMoveEnabled()&&!this._eventManager.isDnDDragging())return this._eventManager.handleKeyboardMoveInitiation(e,s),t.EventManager.consumeEvent(e),null;if(this.isResizeStartInitiationEvent(e)&&s&&this._eventManager._component.isDnDResizeEnabled()&&!this._eventManager.isDnDDragging())return this._eventManager.handleKeyboardResizeStartInitiation(e,s),t.EventManager.consumeEvent(e),null;if(this.isResizeEndInitiationEvent(e)&&s&&this._eventManager._component.isDnDResizeEnabled()&&!this._eventManager.isDnDDragging())return this._eventManager.handleKeyboardResizeEndInitiation(e,s),t.EventManager.consumeEvent(e),null;if(this.isDnDCancelEvent(e))return this._eventManager.handleKeyboardDnDCancel(),t.EventManager.consumeEvent(e),null;if(this.isDnDScaleUpEvent(e))return this._eventManager.handleKeyboardDnDScaleUp(e),t.EventManager.consumeEvent(e),null;if(this.isDnDScaleDownEvent(e))return this._eventManager.handleKeyboardDnDScaleDown(e),t.EventManager.consumeEvent(e),null;if(this.isDnDForwardEvent(e))return this._eventManager.handleKeyboardDnDForward(e),t.EventManager.consumeEvent(e),null;if(this.isDnDBackwardEvent(e))return this._eventManager.handleKeyboardDnDBackward(e),t.EventManager.consumeEvent(e),null;if(this.isDnDFinalizeEvent(e))return this._eventManager.handleKeyboardDnDFinalize(),t.EventManager.consumeEvent(e),null;if(e.keyCode===t.KeyboardEvent.F2){var a=i.enableAllFocusable(s._displayable.getElem());a.length>0&&(a[0].focus(),this._eventManager._component.activeInnerElems=a,s.hasActiveInnerElems=!0,this._eventManager._component.activeInnerElemsNode=s)}if(e.keyCode===t.KeyboardEvent.ESCAPE&&this._eventManager._component.activeInnerElems&&s&&(this._eventManager._component.activeInnerElems=null,this._eventManager._component.activeInnerElemsNode=null,i.disableAllFocusable(s._displayable.getElem(),!0),this._eventManager._component._context._parentDiv.focus(),s.hasActiveInnerElems=!1,this._eventManager.ShowFocusEffect(e,s),e.preventDefault(),e.stopPropagation()),!this._eventManager._component.isDiscreteNavigationMode())return super.processKeyDown(e);if(e.keyCode&&e.keyCode==t.KeyboardEvent.SPACE||e.keyCode==t.KeyboardEvent.ENTER)return this._eventManager.handleArrowPress(e);if(t.KeyboardEvent.isPlus(e)||t.KeyboardEvent.isEquals(e)||t.KeyboardEvent.isMinus(e)||t.KeyboardEvent.isUnderscore(e))t.EventManager.consumeEvent(e);else if(e.keyCode===t.KeyboardEvent.PAGE_UP&&e.shiftKey)this._eventManager.prevPage();else{if(e.keyCode!==t.KeyboardEvent.PAGE_DOWN||!e.shiftKey)return super.processKeyDown(e);this._eventManager.nextPage()}}static getNextNavigable(e,i,s){var a=e.getSeries(),r=e.getSeriesIndex(),l=t.Agent.isRightToLeft(a.getCtx()),o=a.isVertical(),h=s.length>1;if(null==e._timeline.activeInnerElems){if(!l&&t.KeyboardEvent.RIGHT_ARROW===i.keyCode||l&&t.KeyboardEvent.LEFT_ARROW===i.keyCode){if(!o)return n.getNextItem(e,s[r],!0);if(h&&1!==r)return n.getClosestItem(e,s[1])}else if(!l&&t.KeyboardEvent.LEFT_ARROW===i.keyCode||l&&t.KeyboardEvent.RIGHT_ARROW===i.keyCode){if(!o)return n.getNextItem(e,s[r],!1);if(h&&0!==r)return n.getClosestItem(e,s[0])}else if(t.KeyboardEvent.DOWN_ARROW===i.keyCode){if(o)return n.getNextItem(e,s[r],!0);if(h&&1!==r)return n.getClosestItem(e,s[1])}else if(t.KeyboardEvent.UP_ARROW===i.keyCode){if(o)return n.getNextItem(e,s[r],!1);if(h&&0!==r)return n.getClosestItem(e,s[0])}return null}}static getNextItem(e,t,i){var s=t.indexOf(e)+(i?1:-1);return s>=0&&s<t.length?t[s]:null}static getClosestItem(e,t){if(t.length>0){for(var i=t[0],s=e.getLoc(),a=Math.abs(s-i.getLoc()),r=1;r<t.length;r++){var n=Math.abs(s-t[r].getLoc());n<a&&(a=n,i=t[r])}return i}return null}}const l={getDatatipColor:e=>{var t=e.getDurationFillColor();return t||null},getDatatip:(e,i,s)=>{var a=e._timeline,r=a.getOptions().tooltip,n=r?r.renderer:null;if(i&&n){var o=a.getCtx().getTooltipManager(),h=e.getDataContext();return o.getCustomTooltip(n,h)}var _=e.getShortDesc();if(null!=_)return _;if(s&&!a.getCtx().isCustomElement()){var d=a.getOptions().translations,g=e.getDragStartTime(),c=a.getTimeAxis().formatDate(new Date(g),null,"general"),m=t.ResourceUtils.format(d.accessibleItemStart,[c]),v=e.getDragEndTime();if(v&&v!==g){var u=a.getTimeAxis().formatDate(new Date(v),null,"general");m=m+" "+t.ResourceUtils.format(d.accessibleItemEnd,[u])}var p=e.getTitle();null!=p&&""!==p&&(m=m+" "+t.ResourceUtils.format(d.accessibleItemTitle,[p]));var S=e.getDescription();return null!=S&&""!==S&&(m=m+" "+t.ResourceUtils.format(d.accessibleItemDesc,[S])),m}var b=[];return l._addItemDatatip(b,e,i),l._processDatatip(b,i)},_processDatatip:(e,i)=>0===e.length?null:i?t.HtmlTooltipManager.createElement("table",null,e,["oj-dvt-datatip-table"]):e.join(""),_addItemDatatip:(e,t,i)=>{var s=t._timeline,a=t.getTitle();a&&l._addDatatipRow(e,s,"title","Title",a,i);var r=t.getDescription();r&&l._addDatatipRow(e,s,"description","Description",r,i);var n=s.getEventManager()._isDndDragging?t.getDragStartTime():t.getStartTime(),o=s.getEventManager()._isDndDragging?t.getDragEndTime():t.getEndTime();n&&o&&o!==n?(l._addDatatipRow(e,s,"start","Start",n,i),l._addDatatipRow(e,s,"end","End",o,i)):l._addDatatipRow(e,s,"date","Date",n,i);var h=t._series.getLabel();null==h&&(h=t._series.getId()),l._addDatatipRow(e,s,"series","Series",h,i)},_addDatatipRow:(e,i,s,a,r,n)=>{if(null!=r&&""!==r){var o,h=i.getOptions().styleDefaults,_=l.getValueFormat(i,s),d=_.tooltipDisplay,g=i.getOptions().translations;if("off"!==d)if("string"==typeof _.tooltipLabel&&(o=_.tooltipLabel),null==o&&(o=null==a?"":g["label"+a]),r=l.formatValue(i,s,_,r),n){var c=[t.HtmlTooltipManager.createElement("td",h.tooltipLabelStyle,o,["oj-dvt-datatip-label"]),t.HtmlTooltipManager.createElement("td",h.tooltipValueStyle,r,["oj-dvt-datatip-value"])];e.push(t.HtmlTooltipManager.createElement("tr",null,c))}else e.push((e.length>0?"<br>":"")+t.ResourceUtils.format(g.labelAndValue,[o,r]))}},getValueFormat:(e,t)=>{var i=e.getOptions().valueFormats;if(!i)return{};if(i instanceof Array){for(var s={},a=0;a<i.length;a++){var r=i[a];s[r.type]=r}e.getOptions().valueFormats=s,i=s}return i[t]?i[t]:{}},formatValue:(e,t,i,s)=>{var a=i.converter;return"start"===t||"end"===t||"date"===t?e.getTimeAxis().formatDate(new Date(s),a,"general"):a&&a.format?a.format(s):s}},o={_DEFAULT_ZOOM_CONTROL_DIAMETER:31,_DEFAULT_ZOOM_CONTROL_PADDING:10.5,_DEFAULT_ZOOM_CONTROL_SPACING:9,getItemDescriptionStyle:e=>{var i=e._series.getOptions().styleDefaults.item.descriptionStyle,s=e.getStyle();if(s){var a=new t.CSSStyle(s);i.parseInlineStyle(a)}return i},getItemTitleStyle:e=>{var i=e._series.getOptions().styleDefaults.item.titleStyle,s=e.getStyle();if(s){var a=new t.CSSStyle(s);i.parseInlineStyle(a)}return i},getReferenceObjectColor:e=>e.styleDefaults.referenceObject.color,getSeriesLabelStyle:e=>e.styleDefaults.series.labelStyle,getSeriesLabelBackgroundStyle:()=>"background-color:#f9f9f9",getSeriesLabelBackgroundOpacity:()=>.8,getSeriesLabelPadding:()=>2,getSeriesLabelSpacing:()=>20,getEmptyTextStyle:e=>e.styleDefaults.series.emptyTextStyle,getBubbleOffset:e=>"alta"===e.getCtx().getThemeBehavior()||e.isFeelerEnabled()?20:0,getBubbleSpacing:()=>15,getBubblePadding:e=>o.getNumberFromString(e.styleDefaults.item.padding),getBubbleRadius:e=>o.getNumberFromString(e.styleDefaults.item.borderRadius),getItemContentSpacing:()=>2,getItemFillColor:e=>{var i=e.getStyle();if(i){var s=new t.CSSStyle(i).getStyle(t.CSSStyle.BACKGROUND_COLOR);if(s)return s}return e._series.getOptions().styleDefaults.item.backgroundColor},getItemStrokeColor:e=>{var i=e.getStyle();if(i){var s=new t.CSSStyle(i).getStyle(t.CSSStyle.BORDER_COLOR);if(s)return s}return e._series.getOptions().styleDefaults.item.borderColor},getItemStrokeWidth:()=>1,getItemHoverFillColor:e=>{var t=e._series.getOptions().styleDefaults.item.hoverBackgroundColor;return t||o.getItemFillColor(e)},getItemHoverStrokeColor:e=>{var t=e._series.getOptions().styleDefaults.item.hoverBorderColor;return t||o.getItemStrokeColor(e)},getItemHoverStrokeWidth:e=>o.getNumberFromString(e.styleDefaults.item.hoverStrokeWidth),getItemSelectedFillColor:e=>{var t=e._series.getOptions().styleDefaults.item.selectedBackgroundColor;return t||o.getItemFillColor(e)},getItemSelectedStrokeColor:e=>{var t=e._series.getOptions().styleDefaults.item.selectedBorderColor;return t||o.getItemStrokeColor(e)},getItemSelectedStrokeWidth:()=>2,getSeriesStyle:()=>"background-color:#f9f9f9;",getColorsArray:e=>e.styleDefaults.series.colors,getDurationFeelerOffset:()=>10,getThumbnailWidth:()=>32,getThumbnailHeight:()=>32,getSeriesAxisSeparatorStyle:()=>"color:#bcc7d2",getItemInnerActiveStrokeColor:()=>"#e4f0fa",getItemInnerFillColor:()=>"rgba(249,249,249,0)",getItemInnerStrokeColor:()=>"rgba(249,249,249,0)",getItemInnerStrokeWidth:()=>2,getTimelineStyle:()=>"border:1px #d9dfe3;background-color:#f9f9f9;",getOverviewWidth:()=>60,getOverviewHeight:()=>100,getNavigationArrowWidth:()=>32,getNavigationArrowPadding:()=>8,getOverviewWindowBackgroundColor:e=>e.styleDefaults.overview.window.backgroundColor,getOverviewWindowBorderColor:e=>e.styleDefaults.overview.window.borderColor,getOverviewBackgroundColor:e=>e.styleDefaults.overview.backgroundColor,getOverviewLabelStyle:e=>e.styleDefaults.overview.labelStyle,getSeriesAxisLabelStyle:e=>e.styleDefaults.majorAxis.labelStyle,getSeriesAxisLabelBackgroundStyle:()=>"background-color:#f9f9f9",getSeriesAxisLabelBackgroundOpacity:()=>.8,getAxisSeparatorStyle:()=>"color:#bcc7d2;",getSeriesAxisLabelPadding:()=>1,getAnimationDuration:e=>t.CSSStyle.getTimeMilliseconds(e.styleDefaults.animationDuration)/1e3,convertToCSSStyle:e=>null==e||e instanceof t.CSSStyle?e:new t.CSSStyle(e),getNumberFromString:e=>e?e.match(/(\d+)/)[0]:null,getMinDurationEvent:()=>8,getContentBubbleArrow:()=>7.5,getContentBubbleSpacing:()=>15.5,getNavButtonBackgroundWidth:()=>60,getNavButtonWidth:()=>36,getContentBubbleBackgroundColor:e=>e.styleDefaults.durationEventOverflow.backgroundColor};class h{constructor(e,t,i){this._timeline=e,this._seriesIndex=t,this._series=e._series[t],this._props=i,this._id=i.id,this._rowKey=i.rowKey,this._startTime=parseInt(i.startTime),i.endTime&&(this._endTime=parseInt(i.endTime)),this._title=i.title,this._desc=i.desc,this._thumbnail=i.thumbnail,this._shortDesc=i.shortDesc,this._style=i.style,this._data=i.data,this._durationFillColor=i.durationFillColor,this._durationSize=0,this._markerShape=i.markerShape,this._markerScaleX=i.markerScaleX,this._markerScaleY=i.markerScaleY,this._markerShortDesc=i.markerShortDesc,this._markerFillColor=i.markerFillColor,this._markerGradientFill=i.markerGradientFill,this._markerOpacity=i.markerOpacity,this._markerSD=i.markerSD,this._data=i.data,this._state={focused:!1,hovered:!1,selected:!1},this._previousState={focused:!1,hovered:!1,selected:!1}}getId(){return this._id}getSeries(){return this._series}getSeriesIndex(){return this._seriesIndex}getRowKey(){return this._rowKey}getStartTime(){return this._startTime}setStartTime(e){this._startTime=e}getEndTime(){return this._endTime}setEndTime(e){this._endTime=e}getTitle(){return this._title}getDescription(){return this._desc}getThumbnail(){return this._thumbnail}getShortDesc(){var e=this._shortDesc;return"function"==typeof e?e(h.getShortDescContext(this)):e}getStyle(){return this._style}setStyle(e){this._style=e}getBubble(){return this._displayable}setBubble(e){this._displayable=e}getContentBubble(){return this._displayableContent}setContentBubble(e){this._displayableContent=e}getFeeler(){return this._feeler}setFeeler(e){this._feeler=e}getDurationBar(){return this._durationBar}setDurationBar(e){this._durationBar=e}getLoc(){return this._loc}setLoc(e){this._loc=e}getSpacing(){return this._spacing}setSpacing(e){this._spacing=e}getEndViewportCollision(){return this._endViewportCollision}setEndViewportCollision(e){this._endViewportCollision=e}getDurationLevel(){return this._durationLevel}setDurationLevel(e){this._durationLevel=e}getDurationSize(){return this._durationSize}setDurationSize(e){this._durationSize=e}getDurationFillColor(){return this._durationFillColor}setDurationFillColor(e){this._durationFillColor=e}getLabel(){var e=this._timeline.getOptions().translations,i=this.getStartTime(),s=this._timeline.getTimeAxis().formatDate(new Date(i),null,"general"),a=t.ResourceUtils.format(e.accessibleItemStart,[s]),r=this.getEndTime();if(null!=r&&r!==i){var n=this._timeline.getTimeAxis().formatDate(new Date(r),null,"general");a=a+" "+t.ResourceUtils.format(e.accessibleItemEnd,[n])}var l=this.getTitle();null!=l&&""!==l&&(a=a+" "+t.ResourceUtils.format(e.accessibleItemTitle,[l]));var o=this.getDescription();return null!=o&&""!==o&&(a=a+" "+t.ResourceUtils.format(e.accessibleItemDesc,[o])),a}getWidth(){return this._w}setWidth(e){this._w=e}getContentWidth(){return this._cw}setContentWidth(e){this._cw=e}getDurationWidth(){return this._dw}setDurationWidth(e){this._dw=e}getHeight(){return this._h}setHeight(e){this._h=e}getResizeHandleEnd(){return this._resizeHandleEnd}setResizeHandleEnd(e){this._resizeHandleEnd=e}getResizeHandleStart(){return this._resizeHandleStart}setResizeHandleStart(e){this._resizeHandleStart=e}getMarkerShape(){return this._markerShape}getMarkerScaleX(){return this._markerScaleX}getMarkerScaleY(){return this._markerScaleY}getMarkerShortDesc(){return this._markerShortDesc}getMarkerFillColor(){return this._markerFillColor}getMarkerGradientFill(){return this._markerGradientFill}getMarkerOpacity(){return this._markerOpacity}getMarkerSD(){return this._markerSD}getNextNavigable(e){var i=this._timeline.EventManager.getKeyboardHandler();if(e.type===t.MouseEvent.CLICK||i.isMultiSelectEvent(e))return this;if(i.isNavigationEvent(e)){for(var s=[],a=0;a<this._timeline._series.length;a++)s.push(this._timeline._series[a]._items);return n.getNextNavigable(this,e,s)}return null}getTargetElem(){return this._displayable.getElem()}getKeyboardBoundingBox(e){return this._displayable.getDimensions(e)}showKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!0,this.showHoverEffect(),this._timeline.updateScrollForItemNavigation(this)}hideKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!1,this.hideHoverEffect()}isShowingKeyboardFocusEffect(){return this._isShowingKeyboardFocusEffect}getDisplayables(){return[this._displayable]}getAriaLabel(){var e=[];this.isSelectable()&&e.push(this._timeline.getOptions().translations[this.isSelected()?"stateSelected":"stateUnselected"]);var i=l.getDatatip(this,!1);return t.Displayable.generateAriaLabel(i,e)}getData(e){return e?i.TimeComponent.sanitizeData(this._data,"item"):this._data}setData(e){this._data=e}getItemType(){var e=this._data.itemType;return e&&"auto"!==e?this._endTime?"event"===e||!this._series.isVertical()&&"alta"!==this._timeline.getCtx().getThemeBehavior()?e:h.DURATION_BAR:"event":this._endTime?h.DURATION_BAR:"event"}getRendererContext(){var e=this.getData()._itemData,t=this.getItemType()===h.DURATION_EVENT?Math.max(this._timeline.getDatePos(this._endTime)-this._timeline.getDatePos(this._startTime),o.getMinDurationEvent()):null;return{data:this.getData(!0),itemData:e||null,seriesData:this._series.getData(!0),previousState:this._previousState,state:this._state,durationWidth:t}}getDataContext(){var e=this.getData()._itemData;return{data:this.getData(!0),seriesData:this._series.getData(!0),itemData:e||null,color:l.getDatatipColor(this),component:this._timeline.getOptions()._widgetConstructor}}static getShortDescContext(e){var t=e.getData()._itemData;return{data:e.getData(!0),seriesData:e._series.getData(!0),itemData:t||null}}getDatatip(){return l.getDatatip(this,!0)}getDatatipColor(){return l.getDatatipColor(this)}setSelectable(e){this._isSelectable=e}isSelectable(){return this._isSelectable}isSelected(){return this._isSelected}setSelected(e){this._isSelected=e,this._displayable.setSelected(e),this._updateAriaLabel(),this._timeline._hasOverview&&this._timeline._overview&&(e?(this.changeState("selected",!0,!0),this._timeline._overview.selSelectItem(this.getId())):(this.changeState("selected",!1,!0),this._timeline._overview.selUnselectItem(this.getId())))}changeState(e,t,i){i?(this._previousState=this._state,this._state={focused:!1,hovered:!1,selected:!1},this._state[e]=t):this._state[e]=t}showHoverEffect(e){var t=this._timeline.EventManager.getFocus()===this;this.changeState("focused",t,!0),this._displayable.showHoverEffect(t),this.changeState("hovered",!0),!e&&this._timeline._hasOverview&&this._timeline._overview.highlightItem(this.getId()),(this._timeline._isVertical||this._series._isRandomItemLayout)&&(this._index||(this._index=this._series._blocks[0].getChildIndex(this.getBubble())),this._series._blocks[0].addChild(this.getBubble()))}hideHoverEffect(e){var t=this._timeline.EventManager.getFocus()===this;this.changeState("focused",t,!0),this._displayable.hideHoverEffect(t),this.changeState("hovered",!1),!e&&this._timeline._hasOverview&&this._timeline._overview.unhighlightItem(this.getId()),(this._timeline._isVertical||this._series._isRandomItemLayout)&&this._index&&!this._isSelected&&this._series._blocks[0].addChildAt(this.getBubble(),this._index)}_updateAriaLabel(){t.Agent.deferAriaCreation()||this._displayable.setAriaProperty("label",this.getAriaLabel())}isDragAvailable(){return!0}getDragTransferable(){return[this.getId()]}getDragFeedback(){return null}setDraggedObj(e){this._draggedObj=e}showDragFeedback(e,i,s,a,r,n){var l=this._timeline.getEventManager();if(s&&l){var h,_,d=l.getDnDTaskSubType(s),g=t.Agent.isRightToLeft(this._timeline.getCtx()),c=g?-1:1;switch(h={deltaX:null==l._keyboardDnDMode?l._dragInitialX-this._timeline.getTimeZoomCanvas().getTranslateX():0,deltaY:0},_=a.x+i.x+h.deltaX,d){case"event":var m=s._displayable._initialDragOffset.offsetX-_,v=this._displayable._initialPosition.initialX-m;this._displayable.setTranslateX(v);var u=this._timeline.getDatePos(this._startTime)-m*c,p=this._timeline.getDatePos(this._endTime)-m*c;this._dragStartTime=this._timeline.getPosDate(u),this._dragEndTime=this._timeline.getPosDate(p),n&&this._showDragFeedbackTooltip(e,this._displayable,"center");break;case"resize-handle":h={deltaX:0,deltaY:0};m=s._displayable._initialDragOffset.offsetX-_;var S="end"===s._displayable._resizeEdge,b=g&&!S||!g&&S?null:this._displayable._initialPosition.initialX-m,D=(u=this._timeline.getDatePos(this._startTime)-m*c,p=this._timeline.getDatePos(this._endTime)-m*c,this._timeline.getDatePos(this._startTime)+o.getMinDurationEvent()),f=this._timeline.getDatePos(this._endTime)-o.getMinDurationEvent();if(S&&p>D){var T=this._timeline.getPosDate(p);this._dragEndTime=T,this._timeline.getEventManager().handleDurationEventResize(this,this._series,b)}else if(!S&&u<f){var C=this._timeline.getPosDate(u);this._dragStartTime=C,this._timeline.getEventManager().handleDurationEventResize(this,this._series,b)}n&&this._showDragFeedbackTooltip(e,this._displayable,S?"end":"start")}}}_showDragFeedbackTooltip(e,i,s){var a=t.Agent.isRightToLeft(this._timeline.getCtx()),r=i.getDimensions(),n=i.getChildAt(0).getDimensions().getCenter(),l=this._timeline.Height-this._timeline._overviewSize,o=this._timeline.getDiscreteOffset(),h=i.getTranslateX()+r.x+this._timeline._startPos+o+(a?28:r.w),_=i.getTranslateY()-n.y+i._node._series.getTranslateY()+i._node._series._canvas.getTranslateY()+l-r.h;this._timeline.getEventManager().ProcessObjectTooltip(e,h,_,this,i.getElem())}_dropCleanup(){this._displayable&&(this._displayable._initialDragOffset=null,this._displayable._initialPosition=null,this._displayable._resizeEdge=null,this._type=null),this._dragStartTime=null,this._dragEndTime=null,this._timeline.getEventManager().handleDurationEventReset(this,this._series)}dragStartSetup(e){null!=e&&(this._displayable._initialDragOffset={offsetX:e.offsetX,offsetY:e.offsetY}),this._displayable._initialPosition={initialX:this._displayable.getTranslateX(),initialY:this._displayable.getTranslateY()}}getDragStartTime(){return null!=this._dragStartTime&&this._timeline.getEventManager()._isDndDragging?this._dragStartTime:this._startTime}getDragEndTime(){return null!=this._dragEndTime&&this._timeline.getEventManager()._isDndDragging?this._dragEndTime:this._endTime}updateDragFeedback(e){var i=t.Agent.isRightToLeft(this._timeline.getCtx()),s=this._timeline.getEventManager();if(s){var a,r,n,l=i?-1:1;switch(s.getDnDTaskSubType(e)){case"event":r=this._timeline.getDatePos(this._dragStartTime),a=(this._timeline.getDatePos(this._startTime)-r)*l;var o=this._displayable.getTranslateX()-a;this._displayable.setTranslateX(o);break;case"resize-handle":var h="end"===e._displayable._resizeEdge;h?(n=this._timeline.getDatePos(this._dragEndTime),a=(this._timeline.getDatePos(this._endTime)-n)*l):h||(r=this._timeline.getDatePos(this._dragStartTime),a=(this._timeline.getDatePos(this._startTime)-r)*l);var _=i&&!h||!i&&h?null:this._displayable.getTranslateX()-a;this._timeline.getEventManager().handleDurationEventResize(this,this._series,_)}}}getDragType(){return this._type}setDragType(e){this._type=e}_disableAllTabElements(){this._timeline.getOptions()._keyboardUtils.disableAllFocusable(this._displayable.getElem())}_enableAllTabElements(){this._timeline.getOptions()._keyboardUtils.enableAllFocusable(this._displayable.getElem())}}h.DURATION_EVENT="duration-event",h.DURATION_BAR="duration-bar";class _ extends t.Automation{GetSubIdForDomElement(e){var t=this._comp.EventManager.GetLogicalObject(e);if(t&&t instanceof h)for(var i=0;i<this._comp._series.length;i++){var s=this._comp._series[i]._items.indexOf(t);if(-1!==s)return"timelineItem["+i+"]["+s+"]"}return null}getDomElementForSubId(e){if(e===t.Automation.TOOLTIP_SUBID)return this.GetTooltipElement(this._comp);if(e&&this._comp.hasValidOptions()){var i=e.indexOf("[");if(i>0&&"timelineItem"===e.substring(0,i)){var s=e.indexOf("]");if(s>0){var a=parseInt(e.substring(i+1,s)),r=parseInt(e.substring(s+2,e.length-1)),n=this._comp._series[a];if(n){var l=n._items[r];if(l)return l.getDisplayables()[0].getElem()}}}}return null}}class d extends t.BaseComponentDefaults{constructor(e){super({alta:{}},e)}getNoCloneObject(){return{majorAxis:{converter:!0,scale:!0},minorAxis:{converter:!0,scale:!0,zoomOrder:!0},valueFormats:{date:{converter:!0},end:{converter:!0},start:{converter:!0}},_resources:{converter:!0,converterVert:!0,defaultDateConverter:!0,defaultDateTimeConverter:!0}}}}class g extends t.Container{constructor(e,t){super(e,"g",t),this.SELECTED_STATE_KEY="sel",this.ACTIVE_SELECTED_STATE_KEY="asel",this.HOVER_STATE_KEY="hl"}setSelected(e){this._isSelected!==e&&(this._isSelected=e,e?this._isShowingHoverEffect?this.applyState(this.ACTIVE_SELECTED_STATE_KEY):this.applyState(this.SELECTED_STATE_KEY):this.applyState(g.ENABLED_STATE_KEY))}showHoverEffect(e){this._isShowingHoverEffect||(this._isShowingHoverEffect=!0,this._isSelected&&e?this.applyState(this.ACTIVE_SELECTED_STATE_KEY):this._isSelected?this.applyState(this.SELECTED_STATE_KEY):this.applyState(this.HOVER_STATE_KEY))}hideHoverEffect(e){this._isSelected&&e?this.applyState(this.ACTIVE_SELECTED_STATE_KEY):this._isSelected?this.applyState(this.SELECTED_STATE_KEY):this.applyState(g.ENABLED_STATE_KEY),this._isShowingHoverEffect=!1}applyState(e){var i=this._node,s=i.getBubble();if(null!=s){var a=s.getChildAt(0),r=a.getChildAt(0),n=i.getDurationBar();if(e===this.ACTIVE_SELECTED_STATE_KEY)var l=o.getItemSelectedFillColor(i),h=o.getItemSelectedStrokeColor(i),_=o.getItemSelectedStrokeWidth(),d=o.getItemInnerActiveStrokeColor();else e===this.SELECTED_STATE_KEY?(l=o.getItemSelectedFillColor(i),h=o.getItemSelectedStrokeColor(i),_=o.getItemSelectedStrokeWidth(),d=o.getItemInnerStrokeColor()):e===this.HOVER_STATE_KEY?(l=o.getItemHoverFillColor(i),h=o.getItemHoverStrokeColor(i),_=o.getItemHoverStrokeWidth(i._timeline.Options),d=o.getItemInnerActiveStrokeColor()):(l=o.getItemFillColor(i),h=o.getItemStrokeColor(i),_=o.getItemStrokeWidth(),d=o.getItemInnerStrokeColor());var g=o.getItemInnerStrokeWidth(),c=new t.Stroke(h,1,_),m=new t.Stroke(d,1,g);if(a.setStroke(c),r.setStroke(m),e===this.HOVER_STATE_KEY){var v=o.getContentBubbleBackgroundColor(i._timeline.Options);a.setSolidFill(v),r.setSolidFill(l)}else a.setSolidFill(l),r.setSolidFill(o.getItemInnerFillColor());var u=i.getFeeler();u&&i._timeline.isFeelerEnabled()&&u.setStroke(c),n&&n.setStroke(c)}}}g.ENABLED_STATE_KEY="en";const c={renderItem:(e,t,i,s,a,r)=>{e._content?(c._renderBubble(e,t,i,a),c._displayBubble(e,t,s,null,!1)):(t._hasMvAnimations=!0,c._displayBubble(e,t,s,r,!0)),!t.isVertical()&&e._timeline.isFeelerEnabled()&&(e.getFeeler()&&t._allowUpdates?c._updateFeeler(e,t,s,r):c._renderFeeler(e,t,i.feelers,s,a))},initializeItem:(e,t,i)=>{e.getBubble()&&t._allowUpdates?c._updateBubble(e,t,i):c._createBubble(e,t,i)},_createBubble:(e,i,s)=>{var a,r,n,l=i.getCtx(),_=t.Agent.isRightToLeft(l),d=Number(o.getBubblePadding(e._timeline.Options)),g=c._getBubbleContent(e,i);e._timeline.getOptions().itemBubbleContentRenderer?(a=Math.max(0,g._w+g._x+2*d),r=g._h+g._y+2*d):(a=g._w+2*d,r=g._h+2*d),e.setContentWidth(a);var m=e.getStartTime(),v=e.getEndTime(),u=e._timeline.getDatePos(m),p=e._timeline.getDatePos(v);e.getItemType()===h.DURATION_EVENT&&(a=(n=Math.max(p-u,o.getMinDurationEvent()))<a?n+a+o.getContentBubbleSpacing():n),c.checkEndViewportCollision(e,i,_,a),e.getEndViewportCollision()&&null===n&&(a=2*a+o.getContentBubbleSpacing()),e.setWidth(a),e.setHeight(r),e.setDurationWidth(n),e._content=g;var S=i.calculateSpacing(e,s);e.setSpacing(S)},_renderBubble:(e,i,a,r)=>{var n,l,_,d,m,v,u,p=i.getCtx(),S=t.Agent.isRightToLeft(p),b=e.getId(),D=Number(o.getBubblePadding(e._timeline.Options)),f=Number(o.getBubbleRadius(e._timeline.Options)),T=e._content,C=c._isOverflow(e);e._content=null;var y=e.getWidth(),E=e.getContentWidth(),w=e.getDurationWidth(),O=e.getHeight(),A="_bubble_"+b;if("alta"===e._timeline.getCtx().getThemeBehavior()){if(i.isVertical()){var k=O/2,x=k-6,M=k+6;!S&&i.isInverted()||S&&!i.isInverted()?(m=[0,0,0,x,-6,k,0,M,0,O,y,O,y,0,0,0],v=[2,2,2,x,-4,k,2,M,2,O-2,y-2,O-2,y-2,2,2,2]):(m=[0,0,0,O,y,O,y,M,y+6,k,y,x,y,0,0,0],v=[2,2,2,O-2,y-2,O-2,y-2,M,y+4,k,y-2,x,y-2,2,2,2])}else x=(k=S?y-o.getBubbleOffset(e._timeline):o.getBubbleOffset(e._timeline))-6,M=k+6,i.isInverted()?(m=[0,0,x,0,k,-6,M,0,y,0,y,O,0,O,0,0],v=[2,2,x,2,k,-4,M,2,y-2,2,y-2,O-2,2,O-2,2,2]):(m=[0,0,0,O,x,O,k,O+6,M,O,y,O,y,0,0,0],v=[2,2,2,O-2,x,O-2,k,O+4,M,O-2,y-2,O-2,y-2,2,2,2]);n=new t.Polygon(p,m,A),l=new t.Polygon(p,v,A+"_i")}else{var I=o.getContentBubbleArrow();d=e.getEndViewportCollision(),u=S&&!d||!S&&d?[0,0,E,0,E,O/2-I,E+I,O/2,E,O/2+I,E,O,0,O,0,0]:[0,0,0,O/2-I,-I,O/2,0,O/2+I,0,O,E,O,E,0,0,0],(_=new t.Polygon(p,u,A+"_ct")).setSolidFill(o.getContentBubbleBackgroundColor(e._timeline.getOptions())),w&&(y=w),n=new t.Rect(p,0,0,y,O,A),l=new t.Rect(p,2,2,y-4,O-4,A+"_i"),n.setCornerRadius(f),l.setCornerRadius(f)}l.setSolidFill(o.getItemInnerFillColor()),n.addChild(l);var P=new g(p,"_bt_"+b);P._node=e,e.setBubble(P),e.setContentBubble(_),r&&(P.setAlpha(0),r.push(P));var R,L,V=c.calcPadding(e,S,D,y,C,T);if(C&&(e.getItemType()===h.DURATION_EVENT||e._timeline.isDiscreteNavigationMode())){d=e.getEndViewportCollision();var N=(V+15.5)*(S&&!d||!S&&d?-1:1);_.setTranslateX(N),_.addChild(T),T.setTranslate(D,D),P.addChild(n),P.addChild(_)}else{var F=e._timeline._viewStartTime>e.getEndTime()||e._timeline._viewEndTime<e.getStartTime();e._timeline.isDiscreteNavigationMode()&&F&&e.getItemType()===h.DURATION_EVENT&&T.setVisible(),T.setTranslate(V,D),n.addChild(T),P.addChild(n)}(s.TimeAxisUtils.supportsTouch()&&t.ToolkitUtils.setAttrNullNS(P._elem,"id",P._id),P.applyState(g.ENABLED_STATE_KEY),P.setClassName("oj-timeline-item-bubble"),e.getLoc()>=0&&a.addChild(P),P.setAriaRole("img"),i._callbackObj.EventManager.associate(P,e),e._timeline.isDnDResizeEnabled())&&(R=new t.Rect(p,0,0,1,O,"resize-handle-start_"+A),L=new t.Rect(p,0,0,1,O,"resize-handle-end_"+A),S?(R.setTranslateX(y),L.setTranslateX(-1)):(R.setTranslateX(-1),L.setTranslateX(y)),R.setHollow("#00000000"),L.setHollow("#00000000"),P.addChild(R),P.addChild(L),R.setClassName("oj-timeline-resize-handle-start oj-draggable"),L.setClassName("oj-timeline-resize-handle-end oj-draggable"),i._callbackObj.EventManager.associate(R,e),i._callbackObj.EventManager.associate(L,e),e.setResizeHandleStart(R),e.setResizeHandleEnd(L));n.setClassName("oj-timeline-bubble"),e._timeline.isDnDMoveEnabled()?(l.setClassName("oj-timeline-inner-bubble oj-timeline-move-handle oj-draggable"),i._callbackObj.EventManager.associate(l,e)):l.setClassName("oj-timeline-inner-bubble")},_displayBubble:(e,i,s,a,r)=>{var n,l,_=i.getCtx(),d=t.Agent.isRightToLeft(_),m=e.getLoc(),v=e.getWidth(),u=e.getHeight(),p=e.getSpacing(),S=e.getBubble();if(r&&S.applyState(g.ENABLED_STATE_KEY),i.isVertical())l=m-u/2,d&&i.isInverted()||!d&&!i.isInverted()?n=i._size-(v+i._initialSpacing)+s:(n=i._initialSpacing,s=0);else{var b=e.getItemType()===h.DURATION_EVENT?0:o.getBubbleOffset(e._timeline);if(d)n=(e._timeline.isDiscreteNavigationMode()?e._timeline._discreteContentLength:i._length)-m-v+b,c._isOverflow(e)&&(n+=e.getContentWidth()+15.5);else n=m-b;i.isInverted()?(l=i.isTopToBottom()?p:i.Height-p-u+s+i._initialSpacing-o.getBubbleSpacing(),s=0):l=i.isTopToBottom()?p-i._initialSpacing+o.getBubbleSpacing():i.Height-p-u+s}a?(i.isVertical()?S.setTranslateX(S.getTranslateX()+i._canvasOffsetX+s):S.setTranslateY(S.getTranslateY()+i._canvasOffsetY+s),a.addProp(t.Animator.TYPE_NUMBER,S,S.getTranslateX,S.setTranslateX,n),a.addProp(t.Animator.TYPE_NUMBER,S,S.getTranslateY,S.setTranslateY,l)):S.setTranslate(n,l),e._updateAriaLabel(),e._disableAllTabElements()},_createEventMoveDragOutline:e=>{var i=e.getId(),s=e._series.getCtx(),a=e._displayable.getChildAt(0).getWidth()+2,r=e.getHeight()+2,n=e._displayable,l="_bubble_move_"+i,h=Number(o.getBubbleRadius(e._timeline.Options)),_=new t.Rect(s,0,0,a,r,l);_.setCornerRadius(h),_.setClassName("oj-timeline-move-outline"),_.setTranslateX(n.getTranslateX()-1),_.setTranslateY(n.getTranslateY()-1),_.setSolidFill("transparent");var d=new t.Stroke("#000000",1,1,!1,{dashArray:"3"});_.setStroke(d),e._moveDragOutline=_},_updateEventMoveDragOutline:e=>{var t=e._displayable,i=t.getChildAt(0).getWidth(),s=e.getHeight();e._moveDragOutline.setWidth(i+2),e._moveDragOutline.setHeight(s+2),e._moveDragOutline.setTranslateX(t.getTranslateX()-1),e._moveDragOutline.setTranslateY(t.getTranslateY()-1)},_renderEventMoveDragOutline:e=>{var t=e._series._blocks[0];null==e._moveDragOutline?c._createEventMoveDragOutline(e):c._updateEventMoveDragOutline(e),t.addChild(e._moveDragOutline)},_hideEventMoveDragOutline:e=>{var t=e._series._blocks[0];null!=e._moveDragOutline&&t.removeChild(e._moveDragOutline)},_getBubbleContent:(e,i)=>{var s,a=i.getCtx(),r=t.Agent.isRightToLeft(a),n=e.getTitle(),l=e.getDescription(),h=e.getThumbnail(),_=new t.Container(a),d=0,g=0,c=0,m=0,v=0,u=e._timeline.getOptions().itemBubbleContentRenderer;if(u&&(s=u(e.getRendererContext()))){var p=_.getContainerElem();Array.isArray(s)?s.forEach(e=>{t.ToolkitUtils.appendChildElem(p,e)}):t.ToolkitUtils.appendChildElem(p,s);var S=i._blocks[i._blocks.length-1];S.setClassName("oj-timeline-item-bubble"),S.addChild(_);var b=_.getDimensions();return _._w=b.w,_._h=b.h,_._x=r?b.w+b.x:b.x,_._y=b.y,S.removeChild(_),_}if(r){if(n&&((y=new t.OutputText(a,n,0,0)).setCSSStyle(o.getItemTitleStyle(e)),d=(E=y.getDimensions()).w,g=v=E.h,_.addChild(y),e._titleText=y),l){(w=new t.OutputText(a,l,0,g)).setCSSStyle(o.getItemDescriptionStyle(e));var D=(E=w.getDimensions()).w;0!==d&&D!==d?D>d?(y.setX(D-d),d=D):w.setX(d-D):d=D,v=g+E.h,_.addChild(w),e._descText=w}h&&(f=o.getThumbnailWidth(),T=o.getThumbnailHeight(),d=0===d?0:d+o.getItemContentSpacing(),(C=new t.Image(a,h,d,0,f,T,"_tn")).setMouseEnabled(!1),_.addChild(C),c=f,m=T),_._w=d+c}else{if(h){var f=o.getThumbnailWidth(),T=o.getThumbnailHeight(),C=new t.Image(a,h,0,0,f,T,"_tn");C.setMouseEnabled(!1),_.addChild(C),d=f+o.getItemContentSpacing(),m=T}if(n){var y=new t.OutputText(a,n,d,0);y.setCSSStyle(o.getItemTitleStyle(e));var E=y.getDimensions();c=E.w,g=v=E.h,_.addChild(y),e._titleText=y}if(l){var w=new t.OutputText(a,l,d,g);w.setCSSStyle(o.getItemDescriptionStyle(e)),E=w.getDimensions(),c=Math.max(c,E.w),v=g+E.h,_.addChild(w),e._descText=w}_._w=0===c?Math.max(d-o.getItemContentSpacing(),0):d+c}return _._h=Math.max(m,v),_},_updateBubble:(e,t,i)=>{e.getItemType()===h.DURATION_EVENT&&c._updateDurationEvent(e,t);var s=t.calculateSpacing(e,i);e.setSpacing(s);var a=o.getItemTitleStyle(e),r=o.getItemDescriptionStyle(e);e._titleText&&e._titleText.getCSSStyle()!==a&&e._titleText.setCSSStyle(a),e._descText&&e._descText.getCSSStyle()!==r&&e._descText.setCSSStyle(r)},_renderFeeler:(e,i,s,a,r)=>{var n=i.getCtx(),l=t.Agent.isRightToLeft(n),_=e.getId(),d=e.getLoc(),g=e.getSpacing(),c=e._timeline.isDiscreteNavigationMode()?e._timeline._discreteContentLength:i._length;if(e.getItemType()!==h.DURATION_EVENT){var m,v="_feeler_"+_,u=e.getItemType()===h.DURATION_BAR?e.getDurationSize():0;if(i.isInverted())p=u,S=i.isTopToBottom()?g:i.Height-g-e.getHeight()+a+i._initialSpacing-o.getBubbleSpacing();else{var p=i.Height+a-u;if(i.isTopToBottom())S=g-i._initialSpacing+o.getBubbleSpacing()+e.getHeight();else var S=i.Height-g+a}m=l?c-d:d;var b=e._timeline.getTimeAxisSize(),D=new t.Line(n,m,p-b,m,S,v);r&&(D.setAlpha(0),r.push(D)),s.addChild(D);var f=o.getItemStrokeWidth(),T=o.getItemStrokeColor(e),C=new t.Stroke(T,1,f);D.setStroke(C),D._node=e,e.setFeeler(D)}else e.setFeeler(null)},_updateFeeler:(e,i,s,a)=>{var r=e._timeline.isDiscreteNavigationMode()?e._timeline._discreteContentLength:i._length;if(!i.isVertical()&&e.getItemType()!==h.DURATION_EVENT&&e._timeline.isFeelerEnabled()){var n,l=i.getCtx(),_=t.Agent.isRightToLeft(l),d=e.getFeeler(),g=e.getItemType()===h.DURATION_BAR?e.getDurationSize():0;if(i.isInverted())c=g,m=i.isTopToBottom()?e.getSpacing():i.Height-e.getSpacing()-e.getHeight()+s+i._initialSpacing-o.getBubbleSpacing(),s=0;else{var c=i.Height+s-g;if(i.isTopToBottom())m=e.getSpacing()-i._initialSpacing+o.getBubbleSpacing()+e.getHeight();else var m=i.Height-e.getSpacing()+s}n=_?r-e.getLoc():e.getLoc(),a?(d.setY1(d.getY1()+i._canvasOffsetY+s),d.setY2(d.getY2()+i._canvasOffsetY+s),a.addProp(t.Animator.TYPE_NUMBER,d,d.getX1,d.setX1,n),a.addProp(t.Animator.TYPE_NUMBER,d,d.getY1,d.setY1,c),a.addProp(t.Animator.TYPE_NUMBER,d,d.getX2,d.setX2,n),a.addProp(t.Animator.TYPE_NUMBER,d,d.getY2,d.setY2,m)):(d.setX1(n),d.setY1(c),d.setX2(n),d.setY2(m))}else e.setFeeler(null)},renderDuration:(e,t,i,s,a,r)=>{e.getDurationBar()?c._updateDuration(e,t,s,r):c._renderDuration(e,t,i,s,a)},_renderDuration:(e,i,s,a,r)=>{var n=i.getCtx(),l=t.Agent.isRightToLeft(n),h=e.getStartTime(),_=e.getEndTime(),d=e._timeline.getDatePos(h),g="_duration_"+e.getId(),c=22+10*e.getDurationLevel(),m=e._timeline.getDatePos(_),v=e._timeline.isDiscreteNavigationMode()?e._timeline._discreteContentLength:i._length;if(i.isVertical()){if(!l&&!i.isInverted()||l&&i.isInverted())var u=new t.Rect(n,i._size-c+5,d,c,m-d,g);else u=new t.Rect(n,-5,d,c,m-d,g),a=0;u.setTranslateX(a),u.setY(d),u.setWidth(c),u.setHeight(m-d)}else{var p=m-d;if(l)S=v-d-p;else var S=d;i.isInverted()?(u=new t.Rect(n,S,-5,p,c,g)).setTranslateY(0):(u=new t.Rect(n,S,i._size-c+5,p,c,g)).setTranslateY(a)}r&&(u.setAlpha(0),r.push(u)),u.setCornerRadius(5),u.setSolidFill(e.getDurationFillColor());var b=o.getItemStrokeWidth(),D=o.getItemStrokeColor(e),f=new t.Stroke(D,1,b);u.setStroke(f),u._node=e,i._callbackObj.EventManager.associate(u,e),s.addChild(u),e.setDurationBar(u)},_updateDuration:(e,i,s,a)=>{var r,n,l=i.getCtx(),o=t.Agent.isRightToLeft(l),h=e.getDurationBar(),_=e._timeline.isDiscreteNavigationMode()?e._timeline._discreteContentLength:i._length;if(null!=h){r=e._timeline.getDatePos(e.getStartTime());var d=22+10*e.getDurationLevel();if(n=e._timeline.getDatePos(e.getEndTime()),i.isVertical()){var g=0;if(!o&&!i.isInverted()||o&&i.isInverted())var c=i._size-d+5;else c=-5,s=0;var m=s,v=r,u=d,p=n-r}else{m=0;var S=n-r;c=o?_-r-S:r,i.isInverted()?(s=0,g=0,v=-5,u=S,p=d):(g=s,v=i._size-d+5,u=S,p=d)}a?(i.isVertical()?h.setTranslateX(h.getTranslateX()+i._canvasOffsetX+s):h.setTranslateY(h.getTranslateY()+i._canvasOffsetY+s),a.addProp(t.Animator.TYPE_NUMBER,h,h.getTranslateX,h.setTranslateX,m),a.addProp(t.Animator.TYPE_NUMBER,h,h.getTranslateY,h.setTranslateY,g),a.addProp(t.Animator.TYPE_NUMBER,h,h.getX,h.setX,c),a.addProp(t.Animator.TYPE_NUMBER,h,h.getY,h.setY,v),a.addProp(t.Animator.TYPE_NUMBER,h,h.getWidth,h.setWidth,u),a.addProp(t.Animator.TYPE_NUMBER,h,h.getHeight,h.setHeight,p)):(h.setTranslateX(m),h.setTranslateY(g),h.setX(c),h.setY(v),h.setWidth(u),h.setHeight(p))}},_resetDragPosition:e=>{e.setTranslate(e._initialPosition.initialX,e._initialPosition.initialY)},_updateDurationEvent:(e,i,s=null)=>{var a,r,n,l=i.getCtx(),h=t.Agent.isRightToLeft(l),_=e._timeline.getDatePos(e.getDragStartTime()),d=e._timeline.getDatePos(e.getDragEndTime()),g=e.getBubble(),m=g.getChildAt(0),v=m.getChildAt(0),u=e.getContentBubble(),p=e.getHeight(),S=Math.max(d-_,o.getMinDurationEvent()),b=e.getContentWidth(),D=o.getContentBubbleArrow(),f=e._timeline.isDiscreteNavigationMode();m.setWidth(S),v.setWidth(S-4);var T=h?e.getResizeHandleStart():e.getResizeHandleEnd();T&&T.setTranslateX(S);var C=e.getEndViewportCollision(),y=b<S?S:S+b;c.checkEndViewportCollision(e,i,h,y);var E=e.getEndViewportCollision(),w=h&&!E||!h&&E;C!==E&&(n=w?[0,0,b,0,b,p/2-D,b+D,p/2,b,p/2+D,b,p,0,p,0,0]:[0,0,0,p/2-D,-D,p/2,0,p/2+D,0,p,b,p,b,0,0,0],u.setPoints(n));var O=e._timeline.getEventManager();if(c._isOverflow(e)||O._isDndDragging&&e===O.DragSource.getDragObject()){a=S+b+o.getContentBubbleSpacing(),m.getNumChildren()>1?(r=m.getChildAt(1),u.addChild(r),g.addChild(u)):r=u.getChildAt(0);var A=Number(o.getBubblePadding(e._timeline.Options)),k=((x=c.calcPadding(e,h,A,S,!0,r))+15.5)*(w?-1:1);u.setTranslateX(k),f&&(r.setVisible("visible"),r.setTranslateX(A),e._timeline.isDnDMoveEnabled()&&g.setClassName("oj-timeline-item-bubble"))}else{a=S,u.getNumChildren()>0?(r=u.getChildAt(0),m.addChild(r),g.removeChild(u)):r=m.getChildAt(1);A=Number(o.getBubblePadding(e._timeline.Options));var x=c.calcPadding(e,h,A,S,!1,r),M=e._timeline._viewStartTime>e.getEndTime()||e._timeline._viewEndTime<e.getStartTime();f&&M?(r.setVisible(),e._timeline.isDnDMoveEnabled()&&g.setClassName("oj-timeline-item-bubble")):(r.setVisible("visible"),r.setTranslateX(x),e._timeline.isDnDMoveEnabled()&&g.setClassName("oj-timeline-item-bubble oj-timeline-move-handle oj-draggable"))}s&&g.setTranslateX(s),e.setWidth(a),e.setDurationWidth(Math.max(S,o.getMinDurationEvent()))},_isOverflow:e=>{var t=e.getContentWidth(),i=e.getDurationWidth(),s=(e.getEndViewportCollision(),e._timeline.isDiscreteNavigationMode());if(e.getItemType()!==h.DURATION_EVENT)return!1;var a=e._timeline._viewStartTime>e.getEndTime()||e._timeline._viewEndTime<e.getStartTime();if(s&&a&&e!=e._timeline.getEventManager()._keyboardDragObject)return!1;if(s){var r=e._timeline.getDatePos(Math.max(e.getDragStartTime(),e._timeline.getDiscreteViewportStartDate()));i=e._timeline.getDatePos(Math.min(e.getDragEndTime(),e._timeline.getDiscreteViewportEndDate()))-r}return i<t},calcPadding:(e,t,i,s,a,r)=>{var n=i,l=e._timeline.getOptions().itemBubbleContentRenderer;t&&l&&(n=s-i-2*r._x);var o=e.getEndViewportCollision();a?((t&&!o||!t&&o)&&(s=e.getContentWidth()),n+=s-i):t&&!l&&(n=Math.max(n,s-i-r._w));if(e._timeline.isDiscreteNavigationMode()&&!a&&e.getItemType()===h.DURATION_EVENT&&c.checkStartViewportCollision(e)){var _=e._timeline.getDiscreteViewportDatePos(e._timeline.getDiscreteViewportStartDate()),d=e._timeline.getDatePos(e.getDragStartTime()),g=Math.max(0,_-d);t?n-=g:n+=g}return n},checkStartViewportCollision:e=>e._timeline._viewStartTime>=e.getStartTime()&&e._timeline._viewStartTime<=e.getEndTime(),checkEndViewportCollision:(e,t,i,s)=>{var a=o.getNavButtonBackgroundWidth(),r=e.getDragStartTime(),n=e._timeline.getDatePos(r),l=e._timeline.isDiscreteNavigationMode(),_=l?e._timeline._discreteContentLength:t._length,d=(e._timeline.getDiscreteViewportEndDate(),e._timeline.getDatePos(e._timeline._viewEndTime));if(e.setEndViewportCollision(!1),e.getItemType()===h.DURATION_EVENT){var g=a/2;if(i){var c=_-d;l&&(c-=a),c+g>_-n-s-o.getContentBubbleSpacing()&&e.setEndViewportCollision(!0)}else n+o.getContentBubbleSpacing()+s>d+g&&e.setEndViewportCollision(!0)}}};class m extends i.TimeComponentEventManager{constructor(e){super(e),this._HIGH_LEVEL_DND_NAV_SCALES=["milliseconds","seconds","minutes","hours","days","weeks","months","quarters","years"]}addListeners(e){if(super.addListeners(e),!t.Agent.isTouchDevice()){var i=this.getCtx().getStage();"ie"!==t.Agent.browser&&"edge"!==t.Agent.browser||(i.addEvtListener("mouseenter",this.OnMouseEnter,!1,this),i.addEvtListener("mouseleave",this.OnMouseLeave,!1,this)),this._component.addEvtListener("focusout",this._handleFocusout,!1,this),this._component.addEvtListener("focusin",this._handleFocusin,!1,this)}}RemoveListeners(e){if(super.RemoveListeners(e),!t.Agent.isTouchDevice()){var i=this.getCtx().getStage();"ie"!==t.Agent.browser&&"edge"!==t.Agent.browser||(i.removeEvtListener("mouseenter",this.OnMouseEnter,!1,this),i.removeEvtListener("mouseleave",this.OnMouseLeave,!1,this)),this._component.removeEvtListener("focusout",this._handleFocusout,!1,this),this._component.removeEvtListener("focusin",this._handleFocusin,!1,this),this._clearOpenPopupListeners()}}_clearOpenPopupListeners(){null!=this._openPopup&&(this._openPopup.removeEventListener("focusin",this._handlePopupFocusinListener),this._openPopup.removeEventListener("focusout",this._handlePopupFocusoutListener),this._openPopup=null),this._handlePopupFocusinListener=null,this._handlePopupFocusoutListener=null}_handlePopupFocusout(e){this._handleFocusout(e,!0)}_handlePopupFocusin(e){this._handleFocusin(e,!0)}_clearFocusoutTimeout(){this._focusoutTimeout&&(clearTimeout(this._focusoutTimeout),this._focusoutTimeout=null)}_handleFocusout(e,t){if(this._clearFocusoutTimeout(),!t){this._clearOpenPopupListeners();var i=a.getLogicalChildPopup(this._component.getElem());if(null!=i)return this._openPopup=i,this._handlePopupFocusinListener=this._handlePopupFocusin.bind(this),this._handlePopupFocusoutListener=this._handlePopupFocusout.bind(this),i.addEventListener("focusin",this._handlePopupFocusinListener),void i.addEventListener("focusout",this._handlePopupFocusoutListener)}this._focusoutTimeout=setTimeout(function(){this._clearOpenPopupListeners();var e=this._component.getOptions()._keyboardUtils;this._component.activeInnerElemsNode&&(e.disableAllFocusable(this._component.activeInnerElemsNode._displayable.getElem(),!0),this._component.activeInnerElemsNode.hasActiveInnerElems=!1,this._component.activeInnerElems=null,this._component.activeInnerElemsNode=null)}.bind(this),100)}_handleFocusin(e,t){this._clearFocusoutTimeout(),t||this._clearOpenPopupListeners()}ProcessKeyboardEvent(e){var i=!0,s=e.keyCode,a=this.getFocus();if(s==t.KeyboardEvent.TAB&&a){var r=this._component.activeInnerElems?this._component.activeInnerElems.length:void 0;if(r)return(e.shiftKey?this._component.activeInnerElems[0]:this._component.activeInnerElems[r-1])===document.activeElement&&(e.shiftKey?this._component.activeInnerElems[r-1].focus():this._component.activeInnerElems[0].focus(),e.preventDefault()),i;this._component.Options._keyboardUtils.disableAllFocusable(this._component.getTimeZoomCanvas().getElem(),!0,!0)}return i=super.ProcessKeyboardEvent(e)}PreOnMouseOver(e){this._mouseOutTimer&&this._mouseOutTimer.isRunning()&&this._mouseOutTimer.stop(),super.PreOnMouseOver(e),"ie"===t.Agent.browser||"edge"===t.Agent.browser||this.isMouseOver||(this.isMouseOver=!0)}OnMouseEnter(e){this._mouseOutTimer&&this._mouseOutTimer.isRunning()&&this._mouseOutTimer.stop(),this.isMouseOver||(this.isMouseOver=!0)}OnMouseLeave(e){this._mouseOutTimer||(this._mouseOutTimer=new t.Timer(this.getCtx(),10,this._onMouseOutTimerEnd,this,1)),this._mouseOutTimer.reset(),this._mouseOutTimer.start()}PreOnMouseOut(e){super.PreOnMouseOut(e),"ie"!==t.Agent.browser&&"edge"!==t.Agent.browser&&(this._mouseOutTimer||(this._mouseOutTimer=new t.Timer(this.getCtx(),10,this._onMouseOutTimerEnd,this,1)),this._mouseOutTimer.reset(),this._mouseOutTimer.start())}_onMouseOutTimerEnd(){this.isMouseOver=!1}OnMouseDown(e){var t=this.setDraggedObj(e);super.OnMouseDown(t)}setDraggedObj(e){var t=this.GetLogicalObjectAndDisplayable(e.target);if(t.displayable&&-1!==t.displayable.getClassName().indexOf("oj-draggable")){var i=null;-1!==t.displayable.getClassName().indexOf("oj-timeline-move-handle")?i="event":-1!==t.displayable.getClassName().indexOf("oj-timeline-resize-handle-start")?(i="resize-handle",t.logicalObject._displayable._resizeEdge="start"):-1!==t.displayable.getClassName().indexOf("oj-timeline-resize-handle-end")&&(i="resize-handle",t.logicalObject._displayable._resizeEdge="end"),t.logicalObject.setDragType(i),this.IsDragSupported(t.logicalObject.getDragType())&&(this._component.SetPanningEnabled(!1),this._component.SetMarqueeEnabled(!1),t.logicalObject.setDraggedObj(t.logicalObject._displayable))}return e}prevPage(){-1===this._component._prevArrowContainer.getClassName().indexOf("oj-timeline-nav-arrow-disabled")&&(this._component._discreteViewportCurrentIndexOffset--,this._component.handlePageChangeDiscreteViewport())}nextPage(){-1===this._component._nextArrowContainer.getClassName().indexOf("oj-timeline-nav-arrow-disabled")&&(this._component._discreteViewportCurrentIndexOffset++,this._component.handlePageChangeDiscreteViewport())}handleArrowPress(e){var t=this.getFocus();return"prevNavArrow"===t._id?this.prevPage():"nextNavArrow"===t._id&&this.nextPage(),t}panBy(e,t){var i=this.getFocus();i&&(this._comp._dragPanSeries=i._series),super.panBy(e,t)}_handleDragCancel(e){this.handleDurationEventReset(e,e._series)}handleDurationEventResize(e,t,i){c._updateDurationEvent(e,t,i)}handleDurationEventReset(e,t){c._updateDurationEvent(e,t)}GetDragSourceType(e){var i=this.DragSource.getDragObject();if(i&&"duration-event"===i.getItemType()){if(e&&"dragstart"===e.getNativeEvent().type){var s=e.getNativeEvent(),a=s.clientX,r=s.clientY,n=s.offsetX,l=s.offsetY;null==a&&null==r||("ie"===t.Agent.browser||"edge"===t.Agent.browser)&&isNaN(n)&&isNaN(l)}return this.getDragType(i)}return null}GetDropTargetType(e){return"canvas"}GetDropEventPayload(e){var t=this.DragSource.getDragObject()?this.DragSource.getDragObject():this._keyboardDragObject,i=this._context.pageToStageCoords(e.pageX,e.pageY),s=t._displayable._initialDragOffset.offsetX-i.x,a={value:new Date(this._component.getPosDate(t._displayable._initialDragOffset.offsetX-s)).toISOString(),start:null,end:null};if((t=this.DragSource.getDragObject())&&"duration-event"===t.getItemType()){var r=t._dragStartTime,n=t._dragEndTime,l=this.getDnDTaskSubType(t);return"event"===l?(a.start=r,a.end=n,a.start=new Date(a.start).toISOString(),a.end=new Date(a.end).toISOString()):"resize-handle"===l&&("start"===t._displayable._resizeEdge?(a.start=new Date(r).toISOString(),a.end=new Date(t._endTime).toISOString()):(a.start=new Date(t._startTime).toISOString(),a.end=new Date(n).toISOString())),a}}IsDragSupported(e){if(this.isDndSupported()){var t=this._component.getOptions(),i=t.dnd&&t.dnd.drag?t.dnd.drag:null;return i&&i[e]&&i[e].dataTypes&&i[e].dataTypes.length>0}return!1}getDragType(e){return e?e.getDragType():null}isDndSupported(){return!0}isDnDDragging(){return this._isDndDragging}_dragStartSetup(){this._dragInitialX=this._component.getTimeZoomCanvas().getTranslateX(),this._dragInitialY=this._component.getTimeZoomCanvas().getTranslateY(),this._dragInitialViewportStart=this._component.getViewportStartTime(),this._dragInitialViewportEnd=this._component.getViewportEndTime()}_setupObjMoveAffordance(e){c._renderEventMoveDragOutline(e),e._series._blocks[0].removeChild(e._displayable),e._series._blocks[0].addChild(e._displayable)}_setupMoveAffordance(e){"event"===e.getDragType()&&(this._setupObjMoveAffordance(e),this._applyToSelection(t=>{t&&e!=t&&this._setupObjMoveAffordance(t)}))}_hideMoveAffordance(e){"event"===e.getDragType()&&(c._hideEventMoveDragOutline(e),this._applyToSelection(t=>{t&&t!=e&&c._hideEventMoveDragOutline(t)}))}_dragCancelCleanup(){if(this._dragInitialX){var e=this._component.getTimeZoomCanvas().getTranslateX()-this._dragInitialX,t=this._component.getTimeZoomCanvas().getTranslateY()-this._dragInitialY;if(0!==e||0!==t){var i=this._keyboardDragObject?this._keyboardDragObject:this.DragSource.getDragObject();this._component.isDiscreteNavigationMode()?this._component.discreteScrollIntoViewport(i):(this._component.panZoomCanvasBy(e),this._component.setViewportStartTime(this._dragInitialViewportStart),this._component.setViewportEndTime(this._dragInitialViewportEnd))}}this._dragInitialX=null,this._dragInitialY=null,this._dragInitialViewportStart=null,this._dragInitialViewportEnd=null}_dropCleanup(){null==this._dragInitialViewportStart||this._dragInitialViewportStart===this._component.getViewportStartTime()&&this._dragInitialViewportEnd===this._component.getViewportEndTime()||this._component.dispatchEvent(this._component.createViewportChangeEvent()),this._dragInitialX=null,this._dragInitialY=null,this._dragInitialViewportStart=null,this._dragInitialViewportEnd=null,this._isDndDragging=!1}getKeyboardDnDMode(){return this._keyboardDnDMode}updateDnd(){if(null!=this._keyboardDnDMode)this._setupMoveAffordance(this._keyboardDragObject),this._keyboardDragObject.dragStartSetup(),this._keyboardDragObject.updateDragFeedback(this._keyboardDragObject),this._applyToSelection(e=>{e&&e!=this._keyboardDragObject&&e.updateDragFeedback(this._keyboardDragObject)});else{var e=this.DragSource.getDragObject();this._setupMoveAffordance(e),e.dragStartSetup(),e.updateDragFeedback(e),this._applyToSelection(t=>{t&&t!=e&&t.updateDragFeedback(e)})}}OnDndDragStart(e){super.OnDndDragStart(e),this._isDndDragging&&e.preventDefault();var i=e.getNativeEvent();if(i.defaultPrevented)this._component.SetPanningEnabled(!0),this._component.SetMarqueeEnabled(!0);else{this._isDndDragging=!0,this._dragStartSetup();var s=this.DragSource.getDragObject();this._applyToSelection(e=>{e&&e!=s&&("event"===s.getDragType()&&this._setupMoveAffordance(e),e.dragStartSetup(i))}),"event"===s.getDragType()&&(this._setupMoveAffordance(s),this._applyToSelection(e=>{e&&e!=s&&this._setupMoveAffordance(e)})),s.dragStartSetup(i),this._applyToSelection(e=>{e&&e!=s&&e.dragStartSetup(i)}),this._dropOffset=new t.Point(0,0)}}OnDndDragOver(e){super.OnDndDragOver(e);var i=this;this._lastKnownDragOverEvent=e,i._isDndDragging=!0,this._isDragOverTicking||this._lastProcessedDragOverEvent&&this._lastKnownDragOverEvent.pageX===this._lastProcessedDragOverEvent.pageX&&this._lastKnownDragOverEvent.pageY===this._lastProcessedDragOverEvent.pageY||(requestAnimationFrame(()=>{var e=i.DragSource.getDragObject();if(e&&i._isDndDragging&&i._lastKnownDragOverEvent.getNativeEvent().defaultPrevented&&(i._handleDndPan(e),i._dragShowFeedback(e),t.Agent.isTouchDevice())){var s=t.AriaUtils.processAriaLabel(l.getDatatip(e,!1));if(i._component.isItemSelectionEnabled()&&e.isSelected()){var a=i._component.SelectionHandler.getSelectedCount();a>1&&(s+=". "+t.ResourceUtils.format(i._component.getOptions().translations.itemMoveSelectionInfo,[a-1]))}i._prevScreenReaderDragText&&i._prevScreenReaderDragText===s||i._component.updateLiveRegionText(s),i._prevScreenReaderDragText=s}i._lastProcessedDragOverEvent=i._lastKnownDragOverEvent,i._isDragOverTicking=!1}),this._isDragOverTicking=!0)}OnDndDragEnd(e){super.OnDndDragEnd(e);var t=this.DragSource.getDragObject();"event"===t.getDragType()&&(this._hideMoveAffordance(t),this._applyToSelection(e=>{e&&e!=t&&this._hideMoveAffordance(t)})),this._isDndDragging=!1,"none"===e.getNativeEvent().dataTransfer.dropEffect&&(this.handleKeyboardDnDCancel(),this._handleDragCancel(t),this._dropCleanup()),t._dropCleanup(),this._applyToSelection(e=>{e&&e!=t&&e._dropCleanup()}),this._component.SetPanningEnabled(!0),this._component.SetMarqueeEnabled(!0)}_dragShowFeedback(e){var t=this._component.getCtx().pageToStageCoords(this._lastKnownDragOverEvent.pageX,this._lastKnownDragOverEvent.pageY);e.showDragFeedback(this._lastKnownDragOverEvent,t,e,this._dropOffset,!1,!0),this._applyToSelection(i=>{i&&i!=e&&i.showDragFeedback(this._lastKnownDragOverEvent,t,e,this._dropOffset,!1,!1)})}OnDndDrop(e){if(super.OnDndDrop(e),e.getNativeEvent().defaultPrevented){var i=this.DragSource.getDragObject(),s=i.getDragType();if(this._component.isDnDMoveEnabled()&&"event"===s){t.Agent.isTouchDevice()&&this._component.updateLiveRegionText(this._component.getOptions().translations.itemMoveFinalized);for(var a=this.GetDropEventPayload(e),r=this._component.SelectionHandler.getSelection(),n=[],l=0;l<r.length;l++){var o=r[l];n.push(o.getDataContext())}var h=a.value,_=a.start,d=a.end,g=t.EventFactory.newTimelineMoveEvent(n,h,_,d);this._component.dispatchEvent(g)}else if(this._component.isDnDResizeEnabled()&&"resize-handle"===s){t.Agent.isTouchDevice()&&this._component.updateLiveRegionText(this._component.getOptions().translations.itemResizeFinalized);for(a=this.GetDropEventPayload(e),r=this._component.SelectionHandler.getSelection(),n=[],l=0;l<r.length;l++){o=r[l];n.push(o.getDataContext())}h=a.value,_=a.start,d=a.end,g=t.EventFactory.newTimelineResizeEvent(n,h,_,d,i._displayable._resizeEdge);this._component.dispatchEvent(g)}}}getDnDTaskSubType(e){return this.getDragType(e)}_applyToSelection(e){for(var t=this._component.SelectionHandler.getSelection(),i=0;i<t.length;i++){e(t[i])}}_handleKeyboardDnDInitiation(e,i,s,a){if(i&&"duration-event"!==i.getItemType()||this._isDndDragging)return e.preventDefault(),null;var r=t.Agent.isRightToLeft(this._component.getCtx())?-1:1;this._isDndDragging=!0,this._keyboardDragObject=i,this._dragStartSetup(),this._component.registerAndConstructGlassPane();var n=this._component.installGlassPane();this._keyboardDnDScaleRampIndex=this._HIGH_LEVEL_DND_NAV_SCALES.indexOf(this._component.getTimeAxis().getScale()),i.setDraggedObj(i._displayable),"move"===this._keyboardDnDMode?i.setDragType("event"):"resizeStart"!==this._keyboardDnDMode&&"resizeEnd"!==this._keyboardDnDMode||(i.setDragType("resize-handle"),i._displayable._resizeEdge=s),this._keyboardDnDFeedbackLocalPos={x:i._displayable.getTranslateX()+("end"===s)*r*i._displayable.getDimensions().w,y:i._displayable.getTranslateY()};var l={offsetX:this._keyboardDnDFeedbackLocalPos.x,offsetY:this._keyboardDnDFeedbackLocalPos.y};i.dragStartSetup(l),this._setupMoveAffordance(i),i.showDragFeedback(e,this._keyboardDnDFeedbackLocalPos,i,{x:0,y:0},!0,!0),this._applyToSelection(t=>{t&&t!=i&&(t.dragStartSetup(l),"move"===this._keyboardDnDMode&&this._setupMoveAffordance(t),t.showDragFeedback(e,this._keyboardDnDFeedbackLocalPos,i,{x:0,y:0},!0,!1))}),n&&(this._preventHideTooltip=!0),this._keyboardDnDTargetObj=null;var o=i.getStartTime(),h=i.getEndTime();this._keyboardDnDFeedbackTime={start:o,end:h};var _=this._component.getOptions().translations,d=_[a.initiated];if(this._component.isItemSelectionEnabled()&&this._keyboardDragObject.isSelected()){var g=this._component.SelectionHandler.getSelectedCount();g>1&&(d+=". "+t.ResourceUtils.format(_[a.selectionInfo],[g-1]))}d+=". "+_[a.instruction]+".",this._component.updateLiveRegionText(d)}handleKeyboardMoveInitiation(e,t){this._keyboardDnDMode="move";this._handleKeyboardDnDInitiation(e,t,"start",{initiated:"itemMoveInitiated",selectionInfo:"itemMoveSelectionInfo",instruction:"itemMoveInitiatedInstruction"})}handleKeyboardResizeStartInitiation(e,t){this._keyboardDnDMode="resizeStart";this._handleKeyboardDnDInitiation(e,t,"start",{initiated:"itemResizeStartInitiated",selectionInfo:"itemResizeSelectionInfo",instruction:"itemResizeInitiatedInstruction"})}handleKeyboardResizeEndInitiation(e,t){this._keyboardDnDMode="resizeEnd";this._handleKeyboardDnDInitiation(e,t,"end",{initiated:"itemResizeEndInitiated",selectionInfo:"itemResizeSelectionInfo",instruction:"itemResizeInitiatedInstruction"})}_handleKeyboardDnDChronologically(e,i){var s,a,r=t.Agent.isRightToLeft(this._component.getCtx()),n=this.getKeyboardDnDNavigationScale(),h=o.getNavButtonBackgroundWidth(),_=this._component.isDiscreteNavigationMode()?this._component.getPosDate(this._component.getDatePos(this._component._start)+h):this._component._start,d=this._component.isDiscreteNavigationMode()?this._component.getPosDate(this._component.getDatePos(this._component._end)-h):this._component._end,g=this._component.isDiscreteNavigationMode()?this._component._discreteContentLength:this._component.getContentLength(),c=this._component.getTimeAxis(),m="forward"===i?"next":"previous",v=c.getAdjacentDate(this._keyboardDnDFeedbackTime.start,n,m).getTime(),u=c.getAdjacentDate(this._keyboardDnDFeedbackTime.end,n,m).getTime();switch(this._keyboardDnDMode){case"move":("forward"===i&&v<=d||"backward"===i&&u>=_)&&(a=this._component.getDatePos(this._keyboardDnDFeedbackTime.start),this._keyboardDnDFeedbackTime.start=v,this._keyboardDnDFeedbackTime.end=u,s=this._component.getDatePos(this._keyboardDnDFeedbackTime.start));break;case"resizeStart":var p=this._keyboardDragObject.getEndTime();("forward"===i&&v<=p||"backward"===i&&v>=_)&&(a=this._component.getDatePos(this._keyboardDnDFeedbackTime.start),this._keyboardDnDFeedbackTime.start=v,s=this._component.getDatePos(this._keyboardDnDFeedbackTime.start)),"start";break;case"resizeEnd":var S=this._keyboardDragObject.getStartTime();("forward"===i&&u<=d||"backward"===i&&u>=S)&&(a=this._component.getDatePos(this._keyboardDnDFeedbackTime.end),this._keyboardDnDFeedbackTime.end=u,s=this._component.getDatePos(this._keyboardDnDFeedbackTime.end)),"end"}if(null!=s){var b=(r?g-s:s)-(r?g-a:a);this._keyboardDnDFeedbackLocalPos.x+=b,this._component.isDiscreteNavigationMode()?this._component.getPosDate(s)<this._component.getViewportStartTime()?this.prevPage():this._component.getPosDate(s)>this._component.getViewportEndTime()&&this.nextPage():this._component.panBy(b,0)}this._keyboardDragObject.showDragFeedback(e,this._keyboardDnDFeedbackLocalPos,this._keyboardDragObject,{x:0,y:0},!0,!0),this._applyToSelection(t=>{t&&t!=this._keyboardDragObject&&t.showDragFeedback(e,this._keyboardDnDFeedbackLocalPos,this._keyboardDragObject,{x:0,y:0},!0,!1)}),this._component.updateLiveRegionText(t.AriaUtils.processAriaLabel(l.getDatatip(this._keyboardDragObject,!1)))}handleKeyboardDnDForward(e){this._handleKeyboardDnDChronologically(e,"forward")}handleKeyboardDnDBackward(e){this._handleKeyboardDnDChronologically(e,"backward")}_handleKeyboardDnDScaleChange(e,i){this._isKeyboardDnDScaleChanged=!0,this._keyboardDnDScaleRampIndex=Math.max(0,Math.min(this._keyboardDnDScaleRampIndex+i,this._HIGH_LEVEL_DND_NAV_SCALES.length-1)),this._keyboardDragObject.showDragFeedback(e,this._keyboardDnDFeedbackLocalPos,this._keyboardDnDTargetObj,{x:0,y:0},!0),this._component.updateLiveRegionText(t.AriaUtils.processAriaLabel(l.getDatatip(this._keyboardDragObject,!1))),this._isKeyboardDnDScaleChanged=!1}isKeyboardDnDScaleChanged(){return this._isKeyboardDnDScaleChanged}getKeyboardDnDNavigationScale(){return this._HIGH_LEVEL_DND_NAV_SCALES[this._keyboardDnDScaleRampIndex]}handleKeyboardDnDScaleUp(e){this._handleKeyboardDnDScaleChange(e,1)}handleKeyboardDnDScaleDown(e){this._handleKeyboardDnDScaleChange(e,-1)}handleKeyboardDnDFinalize(){var e,i,s,a,r;this._dropCleanup();var n=this._component.getOptions().translations,l=this._component.SelectionHandler.getSelection(),o=[this._keyboardDragObject.getDataContext()];if("move"===this._keyboardDnDMode){for(var h=0;h<l.length;h++){var _=l[h];o.push(_.getDataContext())}e=new Date(this._keyboardDnDFeedbackTime.start).toISOString(),i=new Date(this._keyboardDnDFeedbackTime.end).toISOString(),s=e,a=t.EventFactory.newTimelineMoveEvent(o,s,e,i),r=n.itemMoveFinalized}else if("resizeEnd"===this._keyboardDnDMode||"resizeStart"===this._keyboardDnDMode){for(h=0;h<l.length;h++){_=l[h];o.push(_.getDataContext())}var d;e=new Date(this._keyboardDnDFeedbackTime.start).toISOString(),i=new Date(this._keyboardDnDFeedbackTime.end).toISOString(),"resizeEnd"===this._keyboardDnDMode?(s=i,d="end"):"resizeStart"===this._keyboardDnDMode&&(s=e,d="start"),a=t.EventFactory.newTimelineResizeEvent(o,s,e,i,d),r=n.itemResizeFinalized}a&&(this._component.dispatchEvent(a),this._component.updateLiveRegionText(r)),this._keyboardDnDCleanup()}handleKeyboardDnDCancel(){var e=this._component.getOptions().translations;"move"===this._keyboardDnDMode?this._component.updateLiveRegionText(e.itemMoveCancelled):"resizeEnd"!==this._keyboardDnDMode&&"resizeStart"!==this._keyboardDnDMode||this._component.updateLiveRegionText(e.itemResizeCancelled),this._keyboardDragObject&&(this._hideMoveAffordance(this._keyboardDragObject),this._keyboardDragObject._dropCleanup(),this._applyToSelection(e=>{e&&e!=this._keyboardDragObject&&(this._hideMoveAffordance(e),e._dropCleanup())})),this._dragCancelCleanup(),this._keyboardDnDCleanup()}_keyboardDnDCleanup(){null!=this._keyboardDnDMode&&(this._keyboardDnDMode=null,this._isDndDragging=!1,this._keyboardDnDTargetObj=null,this._keyboardDnDFeedbackTime=null,this._keyboardDnDScaleRampIndex=null,this._keyboardDragObject=null,this._component.unregisterAndDestroyGlassPane())}_isMouseInStartPreview(){var e=t.Agent.isRightToLeft(this._component.getCtx()),i=o.getNavButtonBackgroundWidth(),s=this._component.getCtx().pageToStageCoords(this._lastKnownDragOverEvent.pageX,this._lastKnownDragOverEvent.pageY),a=e?this._component._backgroundWidth-i:0;return s.x>a&&s.x<a+i}_isMouseInEndPreview(){var e=t.Agent.isRightToLeft(this._component.getCtx()),i=o.getNavButtonBackgroundWidth(),s=this._component.getCtx().pageToStageCoords(this._lastKnownDragOverEvent.pageX,this._lastKnownDragOverEvent.pageY),a=e?i:this._component._backgroundWidth;return s.x>a-i&&s.x<a}_handleDndPan(e){this._component.isDiscreteNavigationMode()?this._handleDndDiscretePan(e):(this._isMouseInStartPreview()||this._isMouseInEndPreview())&&(this._handleIntervalPan(e),null!=this._isDndPanWaiting&&(clearTimeout(this._isDndPanWaiting),this._isDndPanWaiting=null))}_handleDndDiscretePan(e){this._component.startPanAllowed()&&this._isMouseInStartPreview()?(null==this._isDndStartPanWaiting&&(this._isDndStartPanWaiting=setTimeout(()=>{this._handleStartPan(e)},2e3)),clearTimeout(this._isDndEndPanWaiting),this._isDndEndPanWaiting=null):this._component.endPanAllowed()&&this._isMouseInEndPreview()?(null==this._isDndEndPanWaiting&&(this._isDndEndPanWaiting=setTimeout(()=>{this._handleEndPan(e)},2e3)),clearTimeout(this._isDndStartPanWaiting),this._isDndStartPanWaiting=null):(clearTimeout(this._isDndEndPanWaiting),clearTimeout(this._isDndStartPanWaiting),this._isDndStartPanWaiting=null,this._isDndEndPanWaiting=null)}_handleStartPan(e){this._component.startPanAllowed()&&this._isMouseInStartPreview()&&this._isDndDragging?(this.prevPage(),this._dragShowFeedback(e),this._isDndStartPanWaiting=setTimeout(()=>{this._handleStartPan(e)},2e3)):(clearTimeout(this._isDndStartPanWaiting),this._isDndStartPanWaiting=null)}_handleEndPan(e){this._component.endPanAllowed()&&this._isMouseInEndPreview()&&this._isDndDragging?(this.nextPage(),this._dragShowFeedback(e),this._isDndEndPanWaiting=setTimeout(()=>{this._handleEndPan(e)},2e3)):(clearTimeout(this._isDndEndPanWaiting),this._isDndEndPanWaiting=null)}_handleIntervalPan(e){if(this._isDndDragging){var t=null;if(this._isMouseInEndPreview(e))t="next";else if(this._isMouseInStartPreview(e))t="previous";if(null!==t){var i=this._component.getTimeAxis(),s=this.getKeyboardDnDNavigationScale();s=s||this._component._scale;var a=e.getDragStartTime(),r=i.getAdjacentDate(a,s,t).getTime(),n=this._component.getDatePos(r)-this._component.getDatePos(a);return this._component.panBy(n),this._dragShowFeedback(e),void(this._isDndPanWaiting=setTimeout(()=>{this._handleIntervalPan(e)},250))}}clearTimeout(this._isDndPanWaiting),this._isDndPanWaiting=null}}class v{parse(e){var t=new Object;t.start=new Date(e.start).getTime(),t.end=new Date(e.end).getTime(),e.viewportStart&&(t.viewStart=new Date(e.viewportStart).getTime()),e.viewportEnd&&(t.viewEnd=new Date(e.viewportEnd).getTime()),e.selectionMode?t.selectionMode=e.selectionMode:t.selectionMode="none",t.inlineStyle=e.style,e.svgStyle&&(t.inlineStyle=e.svgStyle);var i=e.minorAxis;if(i){var s=i.scale;t.scale=s,t.customFormatScales=i._cfs}var a=e.majorAxis;a&&(t.seriesScale=a.scale,t.seriesConverter=a.converter,t.seriesCustomFormatScales=a._cfs),t.shortDesc=e.shortDesc,t.orientation=e.orientation;var r=e.referenceObjects;if(r&&r.length>0){for(var n=[],l=0;l<r.length;l++)n.push(new Date(r[l].value));t.referenceObjects=n}var o=e.overview;return null!=o&&"on"===o.rendered?t.hasOverview=!0:t.hasOverview=!1,t.itemPosition=e._ip,t.customTimeScales=e._cts,t}}class u extends t.BaseComponentDefaults{constructor(){super({alta:{overviewPosition:"below",style:{borderTopStyle:"none",currentTimeIndicatorColor:"#c000d1",handleFillColor:"#ffffff",handleTextureColor:"#b3c6db",leftFilterPanelAlpha:.7,leftFilterPanelColor:"#ffffff",overviewBackgroundColor:"#e6ecf3",rightFilterPanelAlpha:.7,rightFilterPanelColor:"#ffffff",timeAxisBarColor:"#d9dfe3",timeAxisBarAlpha:0,timeIndicatorColor:"#bcc7d2",windowBackgroundAlpha:1,windowBackgroundColor:"#ffffff",windowBorderBottomColor:"#4f4f4f",windowBorderBottomStyle:"solid",windowBorderLeftColor:"#4f4f4f",windowBorderLeftStyle:"solid",windowBorderRightColor:"#4f4f4f",windowBorderRightStyle:"solid",windowBorderTopColor:"#4f4f4f",windowBorderTopStyle:"solid"},_fc:"#aadd77",_do:0,_bc:"#648baf",_bof:"0px",_bs:"solid",_bw:"1px",_dbc:"#648baf",_dbs:"solid",_dbw:"1px",_hbc:"#85bbe7",_hbs:"solid",_hbw:"2px",_hbof:"0px",_hgc:"#ebeced",_hgo:1,_hdbs:"solid",_hdbc:"#85bbe7",_hdbw:"2px",_sbs:"solid",_sbc:"#000000",_sbw:"2px",_sbof:"0px",_sbo:1,_sdbs:"solid",_sdbc:"#000000",_sdbw:"2px",_asbs:"solid",_asbc:"#000000",_asbw:"2px",_asbof:"0px",_asbo:1,_asgc:"#e4f0fa",_asgo:1,_asdbs:"solid",_asdbc:"#000000",_asdbw:"2px",_aoc:"off"}})}}class p{constructor(e,i){this._view=e,this._rowKey=i.rowKey,this._id=i.id,this._seriesId=i.seriesId,this._time=parseInt(i.time),this._endTime=null==i.endTime?null:parseInt(i.endTime),this._shape=t.SimpleMarker.CIRCLE,"square"===i.shape?this._shape=t.SimpleMarker.RECTANGLE:"plus"===i.shape?this._shape=t.SimpleMarker.PLUS:"diamond"===i.shape?this._shape=t.SimpleMarker.DIAMOND:"triangleUp"===i.shape?this._shape=t.SimpleMarker.TRIANGLE_UP:"triangleDown"===i.shape&&(this._shape=t.SimpleMarker.TRIANGLE_DOWN),this._desc=i.desc,this._color=i.color,this._gradient=i.gradient,null!=i.opacity&&(this._opacity=parseFloat(i.opacity)),null!=i.scaleX&&(this._scaleX=parseFloat(i.scaleX)),null!=i.scaleY&&(this._scaleY=parseFloat(i.scaleY)),null!=i.durationFillColor&&(this._durationFillColor=i.durationFillColor)}getId(){return this._id}getSeriesId(){return this._seriesId}getRowKey(){return this._rowKey}getTime(){return this._time}getEndTime(){return this._endTime}getScaleX(){return this._scaleX}getScaleY(){return this._scaleY}getDescription(){return this._desc}getColor(){return this._color}isGradient(){return this._gradient}getShape(){return this._shape}getOpacity(){return this._opacity}getDisplayable(){return this._displayable}setDisplayable(e){this._displayable=e}getX(){return this._x}setX(e){this._x=e}getY(){return this._y}setY(e){this._y=e}}const S=e=>e._ds,b=e=>e._dsx,D=e=>e._dsy,f=e=>e._do,T=e=>e._fc,C=e=>e._ph,y=e=>{var t=new Object;return t._bs=e._bs,t._bc=e._bc,t._bw=e._bw,t._bof=e._bof,t._bo=e._bo,t._gc=e._gc,t._go=e._go,t._dbs=e._dbs,t._dbc=e._dbc,t._dbw=e._dbw,t._hbs=e._hbs,t._hbc=e._hbc,t._hbw=e._hbw,t._hbof=e._hbof,t._hbo=e._hbo,t._hgc=e._hgc,t._hgo=e._hgo,t._hdbs=e._hdbs,t._hdbc=e._hdbc,t._hdbw=e._hdbw,t._sbs=e._sbs,t._sbc=e._sbc,t._sbw=e._sbw,t._sbof=e._sbof,t._sbo=e._sbo,t._sgc=e._sgc,t._sgo=e._sgo,t._sdbs=e._sdbs,t._sdbc=e._sdbc,t._sdbw=e._sdbw,t._asbs=e._asbs,t._asbc=e._asbc,t._asbw=e._asbw,t._asbof=e._asbof,t._asbo=e._asbo,t._asgc=e._asgc,t._asgo=e._asgo,t._asdbs=e._asdbs,t._asdbc=e._asdbc,t._asdbw=e._asdbw,t};class E extends r.OverviewParser{parse(e){var t=this.ParseRootAttributes(e);return t.timeAxisInfo=this._parseTimeAxis(e.axisTicks),t.markers=this._parseDataNode(e.markers,t.defaultMarkerStyles),t.formattedTimeRanges=e.formattedTimeRanges,t}ParseRootAttributes(e){var t=super.ParseRootAttributes(e);t.currentTime=parseInt(e.ocd),t.orientation=e.orn,t.selectionMode=e.selmode,t.isRtl=e.rtl.toString(),t.seriesIds=e.sid,t.animationOnClick=e._aoc;var i=new Object;return i.shape=S(e),i.scaleX=b(e),i.scaleY=D(e),i.opacity=f(e),i.color=T(e),i.pixelHinting=C(e),t.defaultMarkerStyles=i,t.labelStyle=e._ls,t}_parseDataNode(e,t){if(e){for(var i=[],s=0;s<e.length;s++){var a=this.ParseNodeAttributes(e[s],t),r=new p(this._view,a);i.push(r)}return i}return null}ParseNodeAttributes(e,t){var i=new Object,s="true"===e._sd;return i.id=e.tid,i.seriesId=e.sid,i.rowKey=e.rk,i.time=e.t,i.endTime=e.et,i.shape=e.s,s&&null==i.shape&&(i.shape=t.shape),i.desc=e.d,i.color=e.c,i.durationFillColor=e.dfc,s&&null==i.color&&(i.color=t.color),i.scaleX=e.sx,s&&null==i.scaleX&&(i.scaleX=t.scaleX),i.scaleY=e.sy,s&&null==i.scaleY&&(i.scaleY=t.scaleY),i.gradient=e.g,i.opacity=e.o,s&&null==i.opacity&&(i.opacity=t.opacity),i}_parseTimeAxis(e){if(e){var t=new Object;return t.width=null,t.height=null,t.ticks=e,t}return null}}class w extends r.Overview{constructor(e,i,s){super(e,i,s);var a=[t.ColorUtils.getPound(t.ColorUtils.getBrighter("#aadd77",.35)),"#aadd77",t.ColorUtils.getPound(t.ColorUtils.getDarker("#aadd77",.5))];r.OverviewUtils.supportsTouch()&&(a=["#aadd77"]),null!=s&&(this._durationColors=s.getOptions().styleDefaults.series.colors),this._defColors=a,this._markerBorderFill=t.SolidFill.invisibleFill(),this._markerSize=12,this.ENABLED_STATE="_",this.HOVER_STATE="_h",this.SELECTED_STATE="_s",this.ACTIVE_SELECTED_STATE="_as",this.BORDER_STYLE="bs",this.BORDER_COLOR="bc",this.BORDER_WIDTH="bw",this.DURATION_BORDER_COLOR="dbc",this.DURATION_BORDER_WIDTH="dbw",this.BORDER_OFFSET="bof",this.BORDER_OPACITY="bo",this.GLOW_COLOR="gc",this.GLOW_OPACITY="go"}initDefaults(){this.Defaults=new u}getParser(){return new E(this)}_applyParsedProperties(e){super._applyParsedProperties(e),this._selectionMode=e.selectionMode,this._markers=e.markers,this._seriesIds=e.seriesIds,this._defaultMarkerStyles=e.defaultMarkerStyles,this._borderStyles=y(this.Options),e.labelStyle&&(this._labelStyle=new t.CSSStyle(e.labelStyle));if("solid"===this.getStyle(this.ENABLED_STATE,this.BORDER_STYLE))var i=parseInt(this.getStyle(this.ENABLED_STATE,this.BORDER_OFFSET),10);else i=1;if("solid"===this.getStyle(this.ACTIVE_SELECTED_STATE,this.BORDER_STYLE))var s=parseInt(this.getStyle(this.ACTIVE_SELECTED_STATE,this.BORDER_OFFSET),10);else s=1;if("solid"===this.getStyle(this.SELECTED_STATE,this.BORDER_STYLE))var a=parseInt(this.getStyle(this.SELECTED_STATE,this.BORDER_OFFSET),10);else a=1;this.isItemSelectionEnabled()?this._markerSpacingOffset=Math.max(s,a,i,1)/2+1:this._markerSpacingOffset=1,this._defOpacity=this.isVertical()?0:.75,this._defAlphas=[this._defOpacity,this._defOpacity,this._defOpacity],this._radialFill=new t.LinearGradientFill(250,this._defColors,this._defAlphas),this._linearFill=new t.LinearGradientFill(180,this._defColors,this._defAlphas);var r=this.isVertical()?0:1;this._border=new t.Stroke("#aadd77",r)}getSeriesIds(){return null==this._seriesIds?null:this._seriesIds.split(" ")}isItemSelectionEnabled(){return"none"!==this._selectionMode}getDrawableById(e){for(var i=this.getNumChildren(),s=0;s<i;s++){var a=this.getChildAt(s);if(a&&a._node&&t.Obj.compareValues(this.getCtx(),e,a._node.getId()))return a}return null}getItemId(e){return e._node?e._node.getId():e.getId().substr(5)}getStyle(e,t){return this._borderStyles[e+t]}getX(e){return null!=e._node?e._node.getX():e.getMatrix().getTx()}getY(e){return null!=e._node?e._node.getY():e.getMatrix().getTy()}getScaleX(e){var t=e.getScaleX();return null==t&&(t=this.isVertical()?(this.Width-this.getTimeAxisWidth()-4)/2:1),t}getScaleY(e){var t=e.getScaleY();return null==t&&(t=1),t}renderData(e,t){if(super.renderData(e,t),null!=this._markers){if(this.isVertical())var i=this._yMin,s=this._yMax;else i=this._xMin,s=this._xMax;for(var a=this.calculateOptimalSize(i,s,e,t,this._markerSize),r=[],n=0;n<this._markers.length;n++){var l=this._markers[n];null==l._endTime?this.addMarker(l,a):r[r.length]=l}this.prepareDurations(r),this.addDurations(r,i,s),this._markerSize=a}}prepareDurations(e){this._maxDurationY=0;var t=null;null==this._durationColorMap&&(this._durationColorMap=new Object);for(var i=0;i<e.length;i++){var s=e[i],a=s.getId(),r=s.getSeriesId();r!==t&&(this._colorCount=0,t=r),s._durationLevel=this.calculateDurationY(s,e),null==s._durationFillColor&&(null==this._durationColorMap[a]?(this._durationColorMap[a]=this._colorCount,s._durationFillColor=this._durationColors[this._colorCount],this._colorCount++,this._colorCount===this._durationColors.length&&(this._colorCount=0)):s._durationFillColor=this._durationColors[this._durationColorMap[a]])}}getDurationColorMap(){return this._durationColorMap?this._durationColorMap:null}calculateOptimalSize(e,t,i,s,a){var n=new Object;n.max=1,n.arr=[];for(var l=this.isVertical()?s:i,o=0;o<this._markers.length;o++){var h=this._markers[o];if(null!=h._endTime){var _=r.OverviewUtils.getDatePosition(e,t,h.getTime(),l);this.isHorizontalRTL()&&(_=l-_),h.setX(_)}else if(this.calculateSize(h,e,t,l,a/2,n,s),n.max>s)break}return n.max>s&&a>1?this.calculateOptimalSize(e,t,i,s,a-1):a}addMarker(e,i){var s,a,n="_mrk_"+e.getId(),l=e.getColor(),o=e.isGradient(),h=e.getOpacity();null==h&&0===(h=this._defOpacity)&&null!=l&&(h=1);var _=this.getScaleX(e),d=this.getScaleY(e),g=e.getShape();if(this.isVertical()){g=t.SimpleMarker.RECTANGLE;var c=2*_,m=2*d,v=e.getY()+c/2,u=e.getX()+m/2}else c=i*_,m=i*d,v=e.getX()+c/2,u=e.getY()+m/2;var p=new t.SimpleMarker(this.getCtx(),g,v,u,c,m,null,null,null,n);if(p._node=e,null==l&&h===this._defOpacity&&null==o)s=g===t.SimpleMarker.CIRCLE?this._radialFill:this._linearFill,a=this._border;else{var S=this._defColors;if(null!=l)if(r.OverviewUtils.supportsTouch())S=[l];else S=[t.ColorUtils.getBrighter(l,.5),l,t.ColorUtils.getDarker(l,.5)];var b=[h,h,h];s=null==o?g===t.SimpleMarker.CIRCLE?new t.LinearGradientFill(250,S,b):new t.LinearGradientFill(180,S,b):new t.SolidFill(l,b[0]),a=new t.Stroke(l,h)}p.setFill(s),p.setStroke(a),this.isItemSelectionEnabled()&&p.setSelectable(!0);var D=this.getNumChildren(),f=this.getChildAt(D-1);return D>this._lastChildIndex&&("tb"===f.getId()||"arr"===f.getId())?this.addChildAt(p,D-this._lastChildIndex):this.addChild(p),e.setDisplayable(p),this.applyState(p,this.ENABLED_STATE),!this.isVertical()&&g!==t.SimpleMarker.RECTANGLE&&g!==t.SimpleMarker.DIAMOND&&g!==t.SimpleMarker.TRIANGLE_UP&&g!==t.SimpleMarker.TRIANGLE_DOWN&&g!==t.SimpleMarker.PLUS||"false"===this._defaultMarkerStyles.pixelHinting||p.setPixelHinting(!0),p}addDurations(e,i,s){for(var a=this.getCtx(),n=this._maxDurationY;n>0;n--)for(var l=0;l<e.length;l++){var o=e[l];if(n===o._durationLevel){var h=r.OverviewUtils.getDatePosition(i,s,o.getTime(),this.isVertical()?this.Height:this.Width),_="_drn_"+o.getId(),d=9+5*o._durationLevel,g=r.OverviewUtils.getDatePosition(i,s,o.getEndTime(),this.isVertical()?this.Height:this.Width);if(this.isVertical())if(this.isRTL())var c=new t.Rect(a,0,h,d,g-h,_);else c=new t.Rect(a,this.Width-d,h,d,g-h,_);else c=this.isRTL()?new t.Rect(a,this.Width-g,this.Height-d-20,g-h,d,_):new t.Rect(a,h,this.Height-d-20,g-h,d,_);c.setFill(new t.SolidFill(o._durationFillColor));var m=new t.Stroke(this.getStyle(this.ENABLED_STATE,this.DURATION_BORDER_COLOR),1,1);c.setStroke(m),c.setPixelHinting(!0),c._node=o,this.addChild(c),o._durationBar=c,o._durationY=d-2}}this.removeChild(this._timeAxisTopBar),this.addChild(this._timeAxisTopBar)}calculateSize(e,t,i,s,a,n,l){var o=a*this.getScaleX(e)+this._markerSpacingOffset,h=a*this.getScaleY(e)+this._markerSpacingOffset,_=e.getTime(),d=r.OverviewUtils.getDatePosition(t,i,_,s);if(this.isHorizontalRTL()&&(d=s-d-2*o),this.isVertical()){var g=0;"solid"===this.getStyle(this.ENABLED_STATE,this.BORDER_STYLE)&&(g=parseInt(this.getStyle(this.ENABLED_STATE,this.BORDER_WIDTH),10)),c=this.isRTL()?g+4:this.Width-2*this.getScaleX(e)-g-4}else{var c=3;this.isOverviewAbove()&&(c+=this.getTimeAxisHeight());for(var m=0,v=[],u=0;u<n.arr.length;u++){var p=n.arr[u],S=p.getX(),b=this.getScaleX(p);Math.abs(d-S)<a*b+this._markerSpacingOffset+o&&v.push(p)}for(u=0;u<v.length;u++){var D=this.calculateY(v,e.getShape(),d,c,o,h,m,a,l);if(m=D.maxy,D.cy===c){c=D.cy;break}c=D.cy}}e.setX(d),e.setY(c),n.arr.push(e),null!=m&&m>n.max&&(n.max=m)}calculateY(e,i,s,a,r,n,l,o,h){for(var _=0;_<e.length;_++){var d=e[_],g=d.getX(),c=d.getY(),m=d.getShape(),v=this.getScaleX(d),u=this.getScaleY(d);if(i===t.SimpleMarker.CIRCLE&&m===t.SimpleMarker.CIRCLE&&r===n&&v===u)var p=Math.abs(s-g),S=o*v+this._markerSpacingOffset+r,b=Math.sqrt(S*S-p*p);else b=o*u+this._markerSpacingOffset+n;if(b>Math.abs(a-c)&&(a=c+b,l=Math.max(l,a+b),o>=1&&void 0!==h&&l>h))break}return{cy:a,maxy:l}}calculateDurationY(e,t){var i=t.length,s=e.getTime(),a=e._durationLevel;null==a&&(a=1);for(var r=0;r<i;r++){var n=t[r];if(n!==e){var l=n.getEndTime();if(null!=l){var o=n.getTime(),h=n._durationLevel;null==h&&(h=1),s>=o&&s<=l&&a===h&&(a=h+1,e._durationLevel=a,a=this.calculateDurationY(e,t))}}}return a>this._maxDurationY&&(this._maxDurationY=a),a}HandleShapeMouseOver(e){var i=super.HandleShapeMouseOver(e);if(null!=i){if(null!=i._node){var s=i._node.getDescription();null!=s&&this.getCtx().getTooltipManager().showDatatip(e.pageX,e.pageY,s,"#000000")}if(this.isItemSelectionEnabled()){var a=!1;if(null!=this._selectedMarkers)for(var r=0;r<this._selectedMarkers.length;r++)if(i===this._selectedMarkers[r]){a=!0;break}if(!a){var n=this.getItemId(i),l=t.EventFactory.newTimelineOverviewEvent("highlight",n);this.dispatchEvent(l),this.highlightMarker(i)}}}}HandleShapeMouseOut(e){var i=super.HandleShapeMouseOut(e);if(null!=i&&!this.isMovable(i)){this.getCtx().getTooltipManager().hideTooltip();var s=!1;if(null!=this._selectedMarkers)for(var a=0;a<this._selectedMarkers.length;a++)if(i===this._selectedMarkers[a]){s=!0;break}if(!s){var r=this.getItemId(i),n=t.EventFactory.newTimelineOverviewEvent("unhighlight",r);this.dispatchEvent(n),this.unhighlightMarker(i)}}}HandleShapeClick(e,i,s){var a=super.HandleShapeClick(e,i,s);null!=a&&this.HandleMarkerClick(a,e.ctrlKey||e.shiftKey||t.Agent.isTouchDevice())}HandleMarkerClick(e,t){if(this.isItemSelectionEnabled()&&(this.selectItem(e,t),null!=e._node.getTime())){var i,s=this.getSlidingWindow();this.isVertical()?(i=this.getX(e)-s.getHeight()/2,this.animateSlidingWindow(null,i)):(i=this.getX(e)-s.getWidth()/2,this.animateSlidingWindow(i))}}highlightItem(e){var t=this.getDrawableById(e);null!=t&&this.highlightMarker(t)}unhighlightItem(e){var t=this.getDrawableById(e);null!=t&&this.unhighlightMarker(t)}highlightMarker(e){if(null!=this._selectedMarkers)for(var t=0;t<this._selectedMarkers.length;t++){if(e===this._selectedMarkers[t])return}this.applyState(e,this.HOVER_STATE)}unhighlightMarker(e){if(null!=this._selectedMarkers)for(var t=0;t<this._selectedMarkers.length;t++){if(e===this._selectedMarkers[t])return}this.applyState(e,this.ENABLED_STATE)}selSelectItem(e){var t=this.getDrawableById(e);null!=t&&this.addSelectedMarker(t)}selUnselectItem(e){var t=this.getDrawableById(e);null!=t&&this.removeSelectedMarker(t)}selectItem(e,i){var s=this.getItemId(e),a=t.EventFactory.newTimelineOverviewEvent("selection",s,i);this.dispatchEvent(a)}addSelectedMarker(e){null==this._selectedMarkers&&(this._selectedMarkers=[]);var t=null;this._selectedMarkers.length>0&&(t=this._selectedMarkers[this._selectedMarkers.length-1]),this._selectedMarkers.push(e),null!=t&&this.applyState(t,this.SELECTED_STATE),this.applyState(e,this.ACTIVE_SELECTED_STATE)}removeSelectedMarker(e){if(null!=this._selectedMarkers){for(var t=-1,i=0;i<this._selectedMarkers.length;i++){if(e===this._selectedMarkers[i]){t=i;break}}-1!=t&&(this.applyState(e,this.ENABLED_STATE),this._selectedMarkers.splice(t,1))}}removeAllSelectedMarkers(){if(null!=this._selectedMarkers){for(var e=0;e<this._selectedMarkers.length;e++){var t=this._selectedMarkers[e];this.applyState(t,this.ENABLED_STATE)}delete this._selectedMarkers,this._selectedMarkers=null}}applyState(e,i){if(e instanceof t.SimpleMarker){var s=!1,a=!1;if("solid"===this.getStyle(i,this.BORDER_STYLE)){s=!0;var r=this.getStyle(i,this.BORDER_COLOR);null==r&&(r="#000000");var n=this.getStyle(i,this.GLOW_COLOR);null!=n&&"none"!==n&&(a=!0)}var l=e._borderMarker,o=e._glowMarker;s||null==l?a||null==o||(this.removeChild(o),e._glowMarker=null):(this.removeChild(l),e._borderMarker=null,null!=o&&(this.removeChild(o),e._glowMarker=null));var h=e.getType();if(s){var _=parseInt(this.getStyle(i,this.BORDER_WIDTH),10),d=parseInt(this.getStyle(i,this.BORDER_OFFSET),10);if(null==l){if(h===t.SimpleMarker.CIRCLE)var g=(e.getDimensions().w+2*d)*e.getScaleX(),c=(e.getDimensions().h+2*d)*e.getScaleY(),m=this.getX(e)-d+g/2,v=this.getY(e)-d+c/2;else this.isVertical()?(g=(e.getDimensions().w+(_+1))*e.getScaleX(),c=(e.getDimensions().h+(_+1))*e.getScaleY(),m=this.getY(e)-(_+1)/2+g/2,v=this.getX(e)-(_+1)/2+c/2):(g=(e.getDimensions().w+2*d)*e.getScaleX(),c=(e.getDimensions().h+2*d)*e.getScaleY(),m=this.getX(e)-d+g/2,v=this.getY(e)-d+c/2);l=new t.SimpleMarker(this.getCtx(),h,m,v,g,c,null,null,null,e.getId()+"_border"),this.addChildAt(l,this.getChildIndex(e)),e._borderMarker=l,l.setFill(this._markerBorderFill)}var u=new t.Stroke(r,this.getStyle(i,this.BORDER_OPACITY),_);if(l.setStroke(u),!this.isVertical()&&h!==t.SimpleMarker.RECTANGLE&&h!==t.SimpleMarker.DIAMOND&&h!==t.SimpleMarker.TRIANGLE_UP&&h!==t.SimpleMarker.TRIANGLE_DOWN&&h!==t.SimpleMarker.PLUS||"false"===this._defaultMarkerStyles.pixelHinting||l.setPixelHinting(!0),a){if(null==o){var p=d-_;h===t.SimpleMarker.CIRCLE?(g=(e.getDimensions().w+2*p)*e.getScaleX(),c=(e.getDimensions().h+2*p)*e.getScaleY(),m=this.getX(e)-p+g/2,v=this.getY(e)-p+c/2):this.isVertical()?(g=(e.getDimensions().w+3)*e.getScaleX(),c=(e.getDimensions().h+3)*e.getScaleY(),m=this.getY(e)+g/2,v=this.getX(e)-1+c/2):(g=(e.getDimensions().w+2*p)*e.getScaleX(),c=(e.getDimensions().h+2*p)*e.getScaleY(),m=this.getX(e)-p+g/2,v=this.getY(e)-p+c/2),o=new t.SimpleMarker(this.getCtx(),h,m,v,g,c,null,null,null,e.getId()+"_glow"),this.addChildAt(o,this.getChildIndex(l)),e._glowMarker=o,o.setFill(this._markerBorderFill)}var S=new t.Stroke(n,this.getStyle(i,this.GLOW_OPACITY),4);o.setStroke(S),!this.isVertical()&&h!==t.SimpleMarker.RECTANGLE&&h!==t.SimpleMarker.DIAMOND&&h!==t.SimpleMarker.TRIANGLE_UP&&h!==t.SimpleMarker.TRIANGLE_DOWN&&h!==t.SimpleMarker.PLUS||"false"===this._defaultMarkerStyles.pixelHinting||o.setPixelHinting(!0)}}}else{var b=e.getId();b&&"_drn_"===b.substring(0,5)&&this.applyDurationState(e,i)}}applyDurationState(e,i){var s=this.getStyle(i,this.DURATION_BORDER_COLOR);null==s&&(s="#000000");var a=parseInt(this.getStyle(i,this.DURATION_BORDER_WIDTH),10);e.setStroke(new t.Stroke(s,1,a))}getMarkers(){return this._markers}}class O extends t.IconButton{constructor(e,t,i,s,a,r,n,l){super(t,i,s,a,r,n,l),this._id=r,this._timeline=e,this._enabledState=!0,this.setAriaRole("button")}getNextNavigable(e){var i=this._timeline.EventManager.getKeyboardHandler(),s=t.Agent.isRightToLeft(this._timeline.getCtx());if(e.type===t.MouseEvent.CLICK||i.isMultiSelectEvent(e))return this;if(!i.isNavigationEvent(e))return null;if(!s&&t.KeyboardEvent.RIGHT_ARROW===e.keyCode||s&&t.KeyboardEvent.LEFT_ARROW===e.keyCode){if("prevNavArrow"===this._id)return this._timeline._nextArrow;for(var a=0;a<this._timeline._series.length;a++){var r=this._timeline._series[a];if(r._items&&r._items.length>0)return r._items[0]}}else if(!s&&t.KeyboardEvent.LEFT_ARROW===e.keyCode||s&&t.KeyboardEvent.RIGHT_ARROW===e.keyCode)return"nextNavArrow"===this._id?this._timeline._prevArrow:this}getAriaLabel(){var e=this._callbackObj.getComponent().getOptions().translations,i=this._enabledState?[]:[e.navArrowDisabledState];return t.Displayable.generateAriaLabel(this.getAriaString(),i)}getAriaString(){var e=this._callbackObj.getComponent().getOptions().translations;return"prevNavArrow"===this._id?e.labelAccNavPreviousPage:"nextNavArrow"===this._id?e.labelAccNavNextPage:void 0}getKeyboardBoundingBox(e){return this.getDimensions(e)}setEnabled(e){this._enabledState=e,this.setAriaProperty("label",this.getAriaLabel()),super.setEnabled(e)}getTargetElem(){return this.getElem()}}const A={renderTimeline:e=>{var t;if(A._removeEmptyText(e),A._renderBackground(e),A._renderScrollableCanvas(e),e.hasValidOptions()){e.renderTimeZoomCanvas(e._canvas);var i=e.getTimeZoomCanvas();if(A._renderSeries(e,i),A._renderSeriesLabels(e),A._renderAxis(e,i),e.isDiscreteNavigationMode()?A._renderNavigationArrows(e,i):A._hideNavigationArrows(e,i),e._hasOverview?A._renderOverview(e):e.clearOverview(),e._keyboardHandler)for(var a=0;a<e._series.length;a++)if((t=e._series[a])._items&&t._items.length>0&&null==e.EventManager.getFocus()){e.EventManager.setFocusObj(t._items[0]);break}(e.isTimeDirScrollbarOn()||e.isContentDirScrollbarOn())&&A._renderScrollbars(e),A._renderZoomControls(e),e.SelectionHandler&&e.applyInitialSelections(),s.TimeAxisUtils.supportsTouch()&&e._setAriaProperty("flowto",e._series[0].getId());for(var r=0;r<e._series.length;r++)(t=e._series[r]).triggerAnimations()}else A._renderEmptyText(e)},_renderBackground:e=>{e._background?(e._background.setClipPath(null),e._background.setWidth(e._backgroundWidth),e._background.setHeight(e._backgroundHeight)):e._background=new t.Rect(e.getCtx(),0,0,e._backgroundWidth,e._backgroundHeight,"bg");var i=e.getBackgroundXOffset();e._background.setTranslateX(i),e._background.setCSSStyle(e._style),e._background.setPixelHinting(!0);var s=new t.ClipPath;s.addRect(i,0,e._backgroundWidth,e._backgroundHeight),e._background.setClipPath(s),e._background.getParent()!==e&&e.addChild(e._background)},_renderScrollableCanvas:e=>{e._canvas||(e._canvas=new t.Container(e.getCtx(),"g","canvas"),e.addChild(e._canvas))},_renderSeries:(e,i)=>{var s=e.getTimeAxis();if(e._series){var a=e.getCtx(),r=t.Agent.isRightToLeft(a),n=e._series.length,l=e.getTimeAxisVisibleSize(n);e.isVertical()||n>1&&e._canvasSize%2!=l%2&&(s.setContentSize(s.getContentSize()+1),l=e.getTimeAxisVisibleSize(n)),e._seriesSize=(e._canvasSize-l)/n;for(var o=0;o<n;o++){var h=e._series[o];h.setClipPath(null);var _=new t.ClipPath;if(e.isVertical()){if(r)var d=Math.abs(o-1);else d=o;if(r&&1===e._series.length){_.addRect(l,0,e._seriesSize,e.getContentLength());var g=new t.Matrix(1,0,0,1,l,0)}else _.addRect(d*(e._seriesSize+l),0,e._seriesSize,e.getContentLength()),g=new t.Matrix(1,0,0,1,d*(e._seriesSize+l),0);var c=e._seriesSize,m=e.getContentLength()}else _.addRect(0,o*(e._seriesSize+l),e.getContentLength(),e._seriesSize),g=new t.Matrix(1,0,0,1,0,o*(e._seriesSize+l)),c=e.getContentLength(),m=e._seriesSize;h.setClipPath(_),h.setMatrix(g),h.getParent()!==i&&i.addChild(h),h.render(e._seriesOptions[o],c,m)}}},_renderSeriesLabels:e=>{var i,s;if(e._series){var a=e.getCtx(),r=t.Agent.isRightToLeft(a);if(e._seriesLabels)for(var n=0;n<e._seriesLabels.length;n++)e.removeChild(e._seriesLabels[n]);e._seriesLabels=[];for(var l=e._series.length,h=o.getSeriesLabelSpacing(),_=2*t.TransientButton._DEFAULT_RADIUS+6,d=2*h,g=0;g<l;g++){var c=e._series[g],m=c.getLabel();if(null!=m){var v=o.getSeriesLabelStyle(e.Options),u=new t.CSSStyle(o.getSeriesLabelBackgroundStyle());if(c._style){var p=c._style.getStyle(t.CSSStyle.BACKGROUND_COLOR);p&&u.setStyle(t.CSSStyle.BACKGROUND_COLOR,p)}var S=new t.OutputText(a,m,0,0,"sl_s"+g);if(S.setCSSStyle(v),i=S.getDimensions(),e.isVertical())var b=e._seriesSize;else b=e._canvasLength;var D=Math.min(i.w,b-(g-1)*-_-d),f=o.getSeriesLabelPadding(),T=new t.Rect(a,0,0,D+2*f,i.h+2*f,"slb_s"+g);if(T.setCSSStyle(u),T.setAlpha(o.getSeriesLabelBackgroundOpacity()),T.setCornerRadius(3),e.isVertical())C=r?Math.abs(g-1)*(e._canvasSize-D-d)+h+e._startX+(g-1)*_:g*(e._canvasSize-D-d)+h+e._startX+(g-1)*-_,y=e._startY+h;else{if(r)var C=e._canvasLength-D-h-(g-1)*-_;else C=e._startX+h+(g-1)*-_;var y=g*(e._canvasSize-i.h-d)+h+e._startY}s=new t.Matrix(1,0,0,1,C,y),S.setMatrix(s),s=new t.Matrix(1,0,0,1,C-f,y-f),T.setMatrix(s),e.addChild(T),t.TextUtils.fitText(S,D,1/0,e),e._seriesLabels.push(T),e._seriesLabels.push(S)}if(c._isEmpty){var E=c.getEmptyText();if(null!=E){var w=new t.OutputText(a,E,0,0,"et_s"+g);if(w.setCSSStyle(o.getEmptyTextStyle(e.Options)),i=w.getDimensions(),e.isVertical())A=(e._canvasLength-i.h)/2+e._startY,O=r?Math.abs(g-1)*((l-1)*e._seriesSize+e.getTimeAxisVisibleSize(l))+(e._seriesSize-i.w)/2+e._startX:g*(e._seriesSize+e.getTimeAxisVisibleSize(l))+(e._seriesSize-i.w)/2+e._startX;else var O=(e._canvasLength-i.w)/2+e._startX,A=g*(e._seriesSize+e.getTimeAxisVisibleSize(l))+(e._seriesSize-i.h)/2+e._startY;s=new t.Matrix(1,0,0,1,O,A),w.setMatrix(s),e.addChild(w),e._seriesLabels.push(w)}}}}},_renderNavigationArrows:(e,i)=>{var s=e.getCtx(),a=t.Agent.isRightToLeft(s),r=e._discreteContentLength,n=e._series.length,l=e.getTimeAxisVisibleSize(n),h=o.getNavButtonBackgroundWidth(),_=o.getNavButtonWidth(),d=1===n?e._canvasSize-l:e._canvasSize/n-l/2,g=e.getDatePos(e._viewStartTime)+e._discreteOffset-h,c=e._backgroundWidth+g-h;a&&(c=r-c-h-e.getScrollbarPadding()+2*e._discreteOffset,g=r-g-h+2*e._discreteOffset);var m=e.Options.styleDefaults.item.borderColor,v=new t.Stroke(m,1,1),u=e.Options.styleDefaults.series.backgroundColor;if(null==e._prevArrowContainer){var p=new t.Container(s),S=new t.Rect(s,0,0,h,h,"prevNavContainer"),b=new t.Rect(s,0,0,_,_,"prevNavContainer_i");b.setCornerRadius(4),b.setTranslate(8,8),S.addChild(b),p.addChild(S),p.setTranslate(g,d-_),p.setClassName("oj-timeline-nav-arrow oj-timeline-nav-arrow-previous"),b.setStroke(v),p.setSolidFill(u);var D=t.ToolkitUtils.getIconStyle(s,e._resources.prev),f=new O(e,s,"outlined",{style:D,size:28},null,"prevNavArrow",e.EventManager.prevPage,e.EventManager);f.setTranslate(4,4),b.addChild(f),i.addChild(p),e._prevArrowContainer=p,e._prevArrow=f}else e._prevArrowContainer.setVisible("visible"),e._prevArrowContainer.setTranslate(g,d-_),i.removeChild(e._prevArrowContainer),i.addChild(e._prevArrowContainer);if(null==e._nextArrowContainer){var T=new t.Container(s),C=new t.Rect(s,0,0,h,h,"nextNavContainer"),y=new t.Rect(s,0,0,_,_,"nextNavContainer_i");y.setCornerRadius(4),y.setTranslate(16,8),C.addChild(y),T.addChild(C),T.setTranslate(c,d-_),T.setClassName("oj-timeline-nav-arrow oj-timeline-nav-arrow-next"),y.setStroke(v),T.setSolidFill(u);D=t.ToolkitUtils.getIconStyle(s,e._resources.next);var E=new O(e,s,"outlined",{style:D,size:28},null,"nextNavArrow",e.EventManager.nextPage,e.EventManager);E.setTranslate(4,4),y.addChild(E),i.addChild(T),e._nextArrowContainer=T,e._nextArrow=E}else e._nextArrowContainer.setVisible("visible"),e._nextArrowContainer.setTranslate(c,d-_),i.removeChild(e._nextArrowContainer),i.addChild(e._nextArrowContainer);A._checkDisabledArrows(e)},_hideNavigationArrows:e=>{null!=e._prevArrowContainer&&e._prevArrowContainer.setVisible(),null!=e._nextArrowContainer&&e._nextArrowContainer.setVisible()},_checkDisabledArrows:e=>{e.startPanAllowed()?(e._prevArrowContainer.removeClassName("oj-timeline-nav-arrow-disabled"),e._prevArrow.setEnabled(!0)):(e._prevArrowContainer.addClassName("oj-timeline-nav-arrow-disabled"),e._prevArrow.setEnabled(!1)),e.endPanAllowed()?(e._nextArrowContainer.removeClassName("oj-timeline-nav-arrow-disabled"),e._nextArrow.setEnabled(!0)):(e._nextArrowContainer.addClassName("oj-timeline-nav-arrow-disabled"),e._nextArrow.setEnabled(!1))},_renderAxis:(e,i,s)=>{var a=e.getCtx(),r=t.Agent.isRightToLeft(a),n=e.getTimeAxis(),l=e._series.length,h=e.getTimeAxisSize(),_=e.getTimeAxisVisibleSize(l),d=1===l?e._canvasSize-_:e._canvasSize/l-_/2,g=e.getContentLength();if(r&&e.isVertical()&&1===e._series.length&&(d=0),n.getParent()!==i&&i.addChild(n),e.isVertical()){var c=new t.Matrix(1,0,0,1,d,0);n.render({_viewStartTime:e._viewStartTime,_viewEndTime:e._viewEndTime,_referenceObjects:{referenceObjects:[]},_throttle:s},h,g)}else{var m=e.isDiscreteNavigationMode();o.getNavButtonBackgroundWidth();g=m?e._discreteContentLength:g;var v=e.getDiscreteViewportStartDate(),u=e.getDiscreteViewportEndDate(),p=e.getOptions(),S=m?v:e._viewStartTime,b=m?u:e._viewEndTime,D=e._seriesScale?h:0;c=new t.Matrix(1,0,0,1,e.getDiscreteOffset(),d-D),n.render({_viewStartTime:S,_viewEndTime:b,_referenceObjects:{referenceObjects:p.referenceObjects,defaultStyleClass:null,defaultStroke:new t.Stroke(o.getReferenceObjectColor(p))},_throttle:s},g,h)}n.setMatrix(c),e._majorAxis&&e._majorAxis.setContentLength(n._contentLength,n._contentLength),e._fetchEndPos=n._contentLength,A._renderSeriesTimeAxis(e,e._fetchStartPos,e._fetchEndPos,e.getTimeZoomCanvas(),g)},_renderSeriesTimeAxis:(e,i,s,a,r)=>{var n=e.getCtx(),l=e.getTimeAxisSize(),h=t.Agent.isRightToLeft(n),_=(e.isDiscreteNavigationMode()?e._discreteOffset:0)*(h?-1:1);if(e._majorAxisLabels)for(var d=0;d<e._majorAxisLabels.length;d++)a.removeChild(e._majorAxisLabels[d]);if(e._majorAxisLabels=[],e._seriesScale){var g,c;e._start,e._end;if(e._customTimeScales&&e._customTimeScales[e._seriesScale]){var m=e._customTimeScales[e._seriesScale];g=m.times,c=m.labels}else if(e._seriesCustomFormatScales&&e._seriesCustomFormatScales[e._seriesScale]){var v=e._seriesCustomFormatScales[e._seriesScale];g=v.times,c=v.labels}else{g=[],c=[];var u=e.getPosDate(i),p=e._seriesTimeAxis.adjustDate(u),S=e.getDatePos(p);for(g.push(p.getTime());S<s;)c.push(e._seriesTimeAxis.formatDate(p)),p=e._seriesTimeAxis.getNextDate(p.getTime()),S=e.getDatePos(p),g.push(p.getTime())}var b=o.getSeriesAxisLabelStyle(e.Options),D=o.getSeriesAxisLabelPadding(),f=new t.CSSStyle(o.getSeriesAxisLabelBackgroundStyle());if(e._series[0]&&e._series[0]._style){var T=e._series[0]._style.getStyle(t.CSSStyle.BACKGROUND_COLOR);T&&f.setStyle(t.CSSStyle.BACKGROUND_COLOR,T)}for(var C=o.getSeriesAxisLabelBackgroundOpacity(),y=0;y<c.length;y++){var E=c[y],w=g[y];S=e.getDatePos(w)+_;var O=e.getDatePos(g[y+1])+_-S;if(h)k=e.isVertical()?A._addLabel(n,a,e._canvasSize-5,E,O,S+18,b,"o_label"+S+"_s0",!0,f,C,D,e._majorAxisLabels,h):A._addLabel(n,a,r-(S+5),E,O,e._seriesSize-2+l,b,"o_label"+S+"_s0",!0,f,C,D,e._majorAxisLabels,h);else if(e.isVertical())var k=A._addLabel(n,a,5,E,O,S+18,b,"o_label"+S+"_s0",!0,f,C,D,e._majorAxisLabels,h);else k=A._addLabel(n,a,S+5,E,O,e._seriesSize-2+l,b,"o_label"+S+"_s0",!0,f,C,D,e._majorAxisLabels,h);k.time=g[y]}}},_renderOverview:e=>{var i=e.getCtx(),s=t.Agent.isRightToLeft(i);if(null==e._overviewCanvas){var a=!0;e._overviewCanvas=new t.Container(i,"g","oCanvas")}else e._overviewCanvas.removeChildren(),e._overviewCanvas.setClipPath(null);var r,n,l,o,h=e._style.getBorderWidth(),_=h/2;e.isVertical()?(r=e._overviewSize,n=e._backgroundHeight-h,o=_,l=s?_:e._backgroundWidth-e._overviewSize-_):(r=e._backgroundWidth-h,n=e._overviewSize,o=e._backgroundHeight-e._overviewSize-_,l=_+e.getBackgroundXOffset()),e._overviewCanvas.setTranslateX(l),e._overviewCanvas.setTranslateY(o);var d=new t.ClipPath;d.addRect(l,o,r,n),e._overviewCanvas.setClipPath(d),a&&e.addChild(e._overviewCanvas),e._overview=new w(i,e.HandleEvent,e),e._overviewCanvas.addChild(e._overview);var g=e._getOverviewObject();e._overview.render(g,r,n),e.isDiscreteNavigationMode()&&(e._overview.setMouseEnabled(!1),e._overview._windowLeftGrippy.setVisible(),e._overview._windowRightGrippy.setVisible())},_renderScrollbars:e=>{var i=e.getCtx(),s=e.getScrollbarPadding(),a=e._series.length;if(null==e._scrollbarsCanvas?(e._scrollbarsCanvas=new t.Container(i,"g","sbCanvas"),e.addChild(e._scrollbarsCanvas)):(e._scrollbarsCanvas.removeChildren(),e.setTimeDirScrollbar(null),e.setContentDirScrollbar(null)),e.isTimeDirScrollbarOn()){if(e.isVertical()){if(t.Agent.isRightToLeft(e.getCtx()))var r=2*s+1;else r=e.Width-1.5*s;var n=e.getCanvasLength()}else r=e.getCanvasLength(),n=e.Height-1.5*s;var l=A._prerenderTimeDirScrollbar(e,e._scrollbarsCanvas,new t.Rectangle(0,0,r,n))}if(e.isContentDirScrollbarOn()){e.isVertical()?(r=e._seriesSize,n=e.Height-1.5*s):(r=t.Agent.isRightToLeft(e.getCtx())?2*s+1:e.Width-1.5*s,n=e._seriesSize);for(var o=[],h=0;h<a;h++)o[h]=A._prerenderContentDirScrollbar(e,e._scrollbarsCanvas,new t.Rectangle(0,0,r,n),h)}if(e.timeDirScrollbar){var _={};_.color=e.timeDirScrollbarStyles.getStyle(t.CSSStyle.COLOR),_.backgroundColor=e.timeDirScrollbarStyles.getStyle(t.CSSStyle.BACKGROUND_COLOR),_.min=e._start,_.max=e._end,e.isVertical()?(_.isReversed=!1,_.isHorizontal=!1,e.timeDirScrollbar.setTranslateY(e.getStartYOffset())):(_.isReversed=t.Agent.isRightToLeft(i),_.isHorizontal=!0,e.timeDirScrollbar.setTranslateX(e.getStartXOffset())),null!=l&&(e.timeDirScrollbar.render(_,l.w,l.h),e.timeDirScrollbar.setViewportRange(e._viewStartTime,e._viewEndTime))}if(e.contentDirScrollbar)for(h=0;h<a;h++){if((_={}).color=e.contentDirScrollbarStyles.getStyle(t.CSSStyle.COLOR),_.backgroundColor=e.contentDirScrollbarStyles.getStyle(t.CSSStyle.BACKGROUND_COLOR),_.isHorizontal=e.isVertical(),0==h){_.min=0;var d=null!=o&&null!=o[h]&&null!=o[h].h?o[h].h:0;_.max=Math.max(e._series[h]._maxOverflowValue,d),e.isVertical()?t.Agent.isRightToLeft(i)?(_.isReversed=!1,2===a?e.contentDirScrollbar[h].setTranslateX(e.getStartXOffset()+e._seriesSize+e.getTimeAxisVisibleSize(a)):e.contentDirScrollbar[h].setTranslateX(e.getStartXOffset()+e.getTimeAxisVisibleSize(a))):(_.isReversed=!0,e.contentDirScrollbar[h].setTranslateX(e.getStartXOffset())):(_.isReversed=!0,e.contentDirScrollbar[h].setTranslateY(e.getStartYOffset()))}else _.min=0,_.max=Math.max(e._series[h]._maxOverflowValue,o[h].h),e.isVertical()?t.Agent.isRightToLeft(i)?(_.isReversed=!0,e.contentDirScrollbar[h].setTranslateX(e.getStartXOffset())):(_.isReversed=!1,e.contentDirScrollbar[h].setTranslateX(e.getStartXOffset()+e._seriesSize+e.getTimeAxisVisibleSize(a))):(_.isReversed=!1,e.contentDirScrollbar[h].setTranslateY(e.getStartYOffset()+e._seriesSize+e.getTimeAxisVisibleSize(a)));e.contentDirScrollbar[h].render(_,o[h].w,o[h].h),e.contentDirScrollbar[h].setViewportRange(0,e._seriesSize)}},_prerenderTimeDirScrollbar:(e,i,s)=>{if(e.setTimeDirScrollbar(new t.SimpleScrollbar(e.getCtx(),e.HandleEvent,e)),i.addChild(e.timeDirScrollbar),e.isVertical())var a="right",r=t.CSSStyle.toNumber(e.timeDirScrollbarStyles.getWidth()),n=s.h;else a="bottom",r=s.w,n=t.CSSStyle.toNumber(e.timeDirScrollbarStyles.getHeight());return t.LayoutUtils.position(s,a,e.timeDirScrollbar,r,n,0),new t.Dimension(r,n)},_prerenderContentDirScrollbar:(e,i,s,a)=>{if(e.setContentDirScrollbar(new t.SimpleScrollbar(e.getCtx(),e.HandleEvent,e),a),i.addChild(e.contentDirScrollbar[a]),e.isVertical())var r="bottom",n=s.w,l=t.CSSStyle.toNumber(e.contentDirScrollbarStyles.getHeight());else r="right",n=t.CSSStyle.toNumber(e.contentDirScrollbarStyles.getWidth()),l=s.h;return t.LayoutUtils.position(s,r,e.contentDirScrollbar[a],n,l,0),new t.Dimension(n,l)},_renderZoomControls:e=>{var i=e.getCtx(),s=e._resources,a=t.Agent.isRightToLeft(i);if(e.isDiscreteNavigationMode())e.zoomin&&(e.zoomin.setVisible(),e.zoomout.setVisible());else{var r={zoomInProps:{imageSize:16,class:s.zoomIn},zoomOutProps:{imageSize:16,class:s.zoomOut}},n=e.getStartXOffset()+o._DEFAULT_ZOOM_CONTROL_PADDING;a&&(e._isVertical&&e._hasOverview?n-=e._overviewSize:n-=e.getBackgroundXOffset(),n=e._backgroundWidth-n-o._DEFAULT_ZOOM_CONTROL_DIAMETER),r.zoomInProps.posX=n,r.zoomOutProps.posX=n;var l=e._startY+o._DEFAULT_ZOOM_CONTROL_PADDING;r.zoomInProps.posY=l,r.zoomOutProps.posY=l+o._DEFAULT_ZOOM_CONTROL_DIAMETER+o._DEFAULT_ZOOM_CONTROL_SPACING,e.renderZoomControls(r),e.zoomin.setVisible("visible"),e.zoomout.setVisible("visible")}},_renderEmptyText:e=>{var i=e.Options.series,s=null!=i&&i.length>0?i[0].items:null;if(i&&s&&s.length>0)var a=e.Options.translations.labelInvalidData;else a=e.Options.translations.labelNoData;e.clearComponent();var r=e.renderEmptyText(e._canvas,a,new t.Rectangle(0,0,e._backgroundWidth,e._backgroundHeight),e.EventManager,o.getEmptyTextStyle(e.Options));A.setEmptyText(r,e)},setEmptyText:(e,t)=>{t._emptyText=e},_removeEmptyText:e=>{e._emptyText&&e._emptyText.getParent()&&(e._emptyText.getParent().removeChild(e._emptyText),e._emptyText=null)},_addLabel:(e,i,s,a,r,n,l,o,h,_,d,g,c,m)=>{var v=new t.OutputText(e,a,s,0,o);null!=l&&v.setCSSStyle(l);var u=v.getDimensions();if(n-=u.h,v.setY(n),m&&v.setX(s-u.w),h){var p=Math.min(u.w+2*g,r);if(m)S=s-p+2*g;else var S=s;var b=new t.Rect(e,S-g,n-g,p,u.h+2*g,"ob_"+o);b.setCSSStyle(_),b.setCornerRadius(3),b.setAlpha(d),i.addChild(b),c&&c.push(b)}return t.TextUtils.fitText(v,r,1/0,i),c&&c.push(v),v}};class k{constructor(e){this._context=e}parse(e,t){var i=this.buildData(e),s=new Object;return s.start=new Date(e.start).getTime(),s.end=new Date(e.end).getTime(),s.inlineStyle=e.style,e.svgStyle&&(s.inlineStyle=e.svgStyle),s.scale=e.scale,s.timeAxis=e.timeAxis,s.label=e.label,s.emptyText=e.emptyText,s.isIRAnimationEnabled="auto"===e.animationOnDisplay,s.isDCAnimationEnabled="auto"===e.animationOnDataChange,s.items=this._parseDataNode(e.timeline,e.index,i.data,t,s.start,s.end),s.rtl="false",s.isRandomItemLayout=e._isRandomItemLayout,s.customTimeScales=e._cts,s.customFormatScales=e._cfs,null==e.itemLayout||"auto"===e.itemLayout?s.isTopToBottom=e.inverted:s.isTopToBottom="topToBottom"===e.itemLayout,s.data=e._data,s}buildData(e){var t={},i=[],s=e.items;if(s)for(var a=0;a<s.length;a++){var r=s[a];i.push(r)}return t.data=i,t}_parseDataNode(e,t,i,s,a,r){var n=[],l=e._series[t];if(i)for(var o=0;o<i.length;o++){var _=this.ParseNodeAttributes(i[o],a,r);if(_){if(l._allowUpdates){var d=this._findExistingItem(_,s);if(d){var g=s.indexOf(d);s.splice(g,1),d.setSpacing(null),d.setDurationLevel(null),d.setLoc(null),d.setSelected(!1),d.setStartTime(_.startTime),d.setEndTime(_.endTime),d.setStyle(_.style),d.setData(_.data)}else(d=new h(e,t,_)).setSelectable(!0)}else(d=new h(e,t,_)).setSelectable(!0);for(var c=d.getStartTime(),m=!0,v=0;v<n.length;v++)if(c<n[v].getStartTime()){n.splice(v,0,d),m=!1;break}m&&n.push(d)}}return n}_findExistingItem(e,i){if(i)for(var s=0;s<i.length;s++){var a=i[s];if(t.Obj.compareValues(this._context,e.id,a.getId())&&e.title===a.getTitle()&&e.desc===a.getDescription()&&e.thumbnail===a.getThumbnail())return a}return null}getDate(e){return null==e?null:e.getTime?e.getTime():isNaN(e)?new Date(e).getTime()+0:e}ParseNodeAttributes(e,t,i){var s=new Object;return s.id=e.id,s.rowKey=s.id,s.startTime=this.getDate(e.start),s.endTime=this.getDate(e.end),(s.endTime?s.endTime:s.startTime)<t||s.startTime>i?null:(s.title=e.title,s.desc=e.description,s.thumbnail=e.thumbnail,s.shortDesc=e.shortDesc,s.data=e,s.style=e.style,e.svgStyle&&(s.style=e.svgStyle),s.durationFillColor=e.durationFillColor,s.markerShape=e._markerShape,s.markerScaleX=e._markerScaleX,s.markerScaleY=e._markerScaleY,s.markerShortDesc=e._markerShortDesc,s.markerFillColor=e._markerFillColor,s.markerGradientFill=e._markerGradientFill,s.markerOpacity=e._markerOpacity,null==e._markerSD||e._markerSD?s.markerSD="true":s.markerSD="false",s.data=e,s)}}const x={renderSeries:(e,i,s)=>{if(x._renderBackground(e,i,s),x._renderScrollableCanvas(e),x._renderReferenceObjects(e,e._canvas),x._renderSeriesTicks(e),null!=e._items){if(0===e._blocks.length){var a=e.getCtx(),r=new t.Container(a,"g","itemBlock_"+e._fetchStartPos+"_"+e._fetchEndPos);r.startPos=e._fetchStartPos,r.endPos=e._fetchEndPos;var n=new t.Container(a,"g","feelers");r.addChild(n),r.feelers=n;var l=new t.Container(a,"g","durations");r.addChild(l),r.durations=l,e._canvas.addChild(r),e._blocks.push(r)}else r=e._blocks[0];e.prepareDurations(),e.prepareItems(e._items),e._isInitialRender?(e._isIRAnimationEnabled?e._frAnimationElems=[]:e._frAnimationElems=null,e._mvAnimator=null,e._rmAnimationElems=null):e._allowUpdates&&e._isDCAnimationEnabled?(e._frAnimationElems=[],e._mvAnimator=new t.Animator(e.getCtx(),o.getAnimationDuration(e.Options),0,t.Easing.cubicInOut),e._rmAnimationElems=[]):(e._frAnimationElems=null,e._mvAnimator=null,e._rmAnimationElems=null),e._hasMvAnimations=!1;var h=Math.max(0,e._maxOverflowValue-e._size);e._overflowOffset=h,x._adjustBackground(e,h),e._oldItems&&x._removeItems(e._oldItems,e,r,e._rmAnimationElems),e._oldItems=null,e.isVertical()&&r.feelers.removeChildren(),x._renderItems(e._items,e,r,e._fetchStartPos,e._fetchEndPos,h,e._frAnimationElems,e._mvAnimator),e._callbackObj.SelectionHandler&&r.setCursor(t.SelectionEffectUtils.getSelectingCursor()),x._updateReferenceObjects(e),x._updateSeriesTicks(e),x._updateMinorSeriesTicks(e)}},updateSeriesForZoom:e=>{x._updateItemsForZoom(e._items,e),x._updateReferenceObjects(e),x._updateSeriesTicks(e),x._updateMinorSeriesTicks(e)},_renderBackground:(e,i,s)=>{if(e._background){var a=!1;e._background.setWidth(i),e._background.setHeight(s)}else a=!0,e._background=new t.Rect(e.getCtx(),0,0,i,s,"bg");e._background.setCSSStyle(e._style),e._background.setPixelHinting(!0),a&&e.addChild(e._background)},_adjustBackground:(e,i)=>{var s=e.getCtx(),a=t.Agent.isRightToLeft(s);i>0&&(e.isVertical()?e._background.setWidth(e._maxOverflowValue):e._background.setHeight(e._maxOverflowValue)),e.isVertical()?(!e.isInverted()&&!a||e.isInverted()&&a)&&(e._background.setTranslateY(0),e._background.setTranslateX(-i),e.setHScrollPos(i)):e.isInverted()||(e._background.setTranslateX(0),e._background.setTranslateY(-i),e.setVScrollPos(i))},_renderScrollableCanvas:e=>{if(e._canvas)return e._canvasOffsetX=e._canvas.getTranslateX(),e._canvasOffsetY=e._canvas.getTranslateY(),e._canvas.setTranslateX(e._offset),void e._canvas.setTranslateY(0);e._canvas=new t.Container(e.getCtx(),"g","canvas"),e._canvas.setTranslateX(e._offset),e.addChild(e._canvas)},_renderItems:(e,t,i,a,r,n,l,o)=>{for(var h,_=0;_<e.length;_++){var d=(h=e[_])._timeline.getDatePos(h.getStartTime());d>=a&&d<=r&&c.renderItem(h,t,i,n,l,o)}if(s.TimeAxisUtils.supportsTouch())for(var g=0;g<e.length-1;g++){var m=(h=e[g]).getBubble();if(m){var v=e[g+1];if(!v.getBubble())break;m._setAriaProperty("flowto","_bt_"+v.getId())}}x._renderDurations(e,t,i,n,l,o)},_updateItemsForZoom:(e,t)=>{var i,s;if(null!=e&&0!==e.length){var a=t._fetchStartPos,r=t._fetchEndPos,n=t._blocks[0];for(n.startPos=a,n.endPos=r,t.isVertical()?t._initialSpacing=20*(t._maxDurationSize>0?1:0)+o.getBubbleSpacing()+10*t._maxDurationSize:t._initialSpacing=20+o.getBubbleSpacing()+10*t._maxDurationSize,s=0;s<e.length;s++){var l=(i=e[s]).getStartTime(),h=i._timeline.getDatePos(l),_=i.getEndTime();if(_&&_!==l){var d=i._timeline.getDatePos(_)-h;h+=Math.min(o.getDurationFeelerOffset(),d/2)}i.setLoc(h),t._isRandomItemLayout||i.setSpacing(null)}for(s=0;s<e.length;s++){var g=(i=e[s]).getStartTime();g>=t._start&&g<=t._end&&c._updateBubble(i,t,s)}var m=Math.max(0,t._maxOverflowValue-t._size);for(x._adjustBackground(t,m),s=0;s<e.length;s++)i=e[s],c._displayBubble(i,t,m,null,!1),c._updateFeeler(i,t,m,null),c._updateDuration(i,t,m,null)}},_renderDurations:(e,t,i,s,a,r)=>{for(var n=i.durations,l=t._maxDurationSize;l>0;l--)for(var o=0;o<e.length;o++){var _=e[o],d=_.getStartTime(),g=_.getEndTime();g&&g!==d&&l===_.getDurationLevel()&&_.getItemType()===h.DURATION_BAR&&c.renderDuration(_,t,n,s,a,r)}},_renderSeriesTicks:e=>{null==e._seriesTicks?(e._seriesTicks=new t.Container(e.getCtx()),e._seriesMinorTicks=new t.Container(e.getCtx()),e._callbackObj._timeZoomCanvas.addChild(e._seriesTicks),e._canvas.addChild(e._seriesMinorTicks)):(e._seriesTicks.removeChildren(),e._seriesTicksArray=[],e._seriesMinorTicks.removeChildren(),e._seriesMinorTicksArray=[]);var i=new t.CSSStyle(o.getSeriesAxisSeparatorStyle());if(e._axisStyleDefaults){var s=e._axisStyleDefaults.separatorColor;s&&i.parseInlineStyle("color:"+s+";")}e._separatorStroke=new t.Stroke(i.getStyle(t.CSSStyle.COLOR),1,1,!1,{dashArray:"3"}),e._majorSeparatorStroke=new t.Stroke(i.getStyle(t.CSSStyle.COLOR),1,1,!1,{dashArray:"0"}),e._scale&&e._timeAxis&&x._renderSeriesTimeAxis(e,e._fetchStartPos,e._fetchEndPos,e._seriesTicks),x._renderSeriesMinorTimeAxis(e,e._fetchStartPos,e._fetchEndPos,e._seriesMinorTicks)},_updateSeriesTicks:e=>{for(var i=e.getCtx(),s=t.Agent.isRightToLeft(i),a=e._callbackObj.isDiscreteNavigationMode()?e._callbackObj._discreteContentLength:e._length,r=e._callbackObj.getTimeAxisSize(),n=0;n<e._seriesTicksArray.length;n++){var l=e._seriesTicksArray[n],o=e._callbackObj.getDiscreteOffset();if(!e.isVertical()&&s)var h=a-e._callbackObj.getDatePos(l.time)+o;else h=e._callbackObj.getDatePos(l.time)+o;if(e.isVertical()){var _=s?r:0;l.setX1(_),l.setY1(h),l.setX2(e._maxOverflowValue+_),l.setY2(h)}else l.setX1(h),l.setY1(e.Height-2),l.setX2(h),l.setY2(e.Height+r)}},_updateMinorSeriesTicks:e=>{var i=e.getCtx(),a=t.Agent.isRightToLeft(i),r=e._callbackObj.getTimeAxisSize(),n=e._callbackObj._seriesScale?r:0;if(e.isVertical())return e._seriesMinorTicks.removeChildren(),void(e._seriesMinorTicksArray=[]);if(x._minorTimeAxisScale!==e._callbackObj._timeAxis._scale)e._seriesMinorTicks.removeChildren(),e._seriesMinorTicksArray=[],x._renderSeriesMinorTimeAxis(e,e._fetchStartPos,e._fetchEndPos,e._seriesMinorTicks);else for(var l=0;l<e._seriesMinorTicksArray.length;l++){var o=e._seriesMinorTicksArray[l];if(!e.isVertical()&&a)var h=e._length-s.TimeAxisUtils.getDatePosition(e._start,e._end,o.time,e._length);else h=s.TimeAxisUtils.getDatePosition(e._start,e._end,o.time,e._length);o.setX1(h),o.setY1(0),o.setX2(h),o.setY2(e._maxOverflowValue-n)}},_renderSeriesMinorTimeAxis:(e,i,a,r)=>{var n=e.getCtx(),l=t.Agent.isRightToLeft(n),o=e._callbackObj.getTimeAxisSize(),h=e._callbackObj._seriesScale?o:0;if(!e.isVertical()){var _,d=e._start,g=e._end,c=e._callbackObj._timeAxis;x._minorTimeAxisScale=c._scale,_=[];var m=s.TimeAxisUtils.getPositionDate(d,g,i,e._length),v=c.adjustDate(m),u=s.TimeAxisUtils.getDatePosition(d,g,v,e._length);for(_.push(v.getTime());u<a;)v=e._callbackObj._timeAxis.getNextDate(v.getTime()),u=s.TimeAxisUtils.getDatePosition(d,g,v,e._length),_.push(v.getTime());for(var p=0;p<_.length-1;p++){var S=_[p];if(u=s.TimeAxisUtils.getDatePosition(d,g,S,e._length),!e.isVertical()&&l)var b=e._length-u;else b=u;var D=b,f=b,T=e._maxOverflowValue-h;if(null!=x._majorTickDates&&-1!==x._majorTickDates.indexOf(S))var C=e.addTick(r,D,f,0,T,e._majorSeparatorStroke,"o_minor_tick"+u);else C=e.addTick(r,D,f,0,T,e._separatorStroke,"o_minor_tick"+u);C.time=S,e._seriesMinorTicksArray.push(C)}}},_renderSeriesTimeAxis:(e,i,s,a)=>{var r,n=e.getCtx(),l=t.Agent.isRightToLeft(n),o=e._callbackObj.getTimeAxisSize(),h=e._callbackObj._seriesScale?o:0,_=e._callbackObj.isDiscreteNavigationMode()?e._callbackObj._discreteContentLength:e._length;if(e._customTimeScales&&e._customTimeScales[e._scale])r=e._customTimeScales[e._scale].times;else if(e._customFormatScales&&e._customFormatScales[e._scale]){r=e._customFormatScales[e._scale].times}else{r=[];var d=e._callbackObj.getPosDate(i),g=e._timeAxis.adjustDate(d),c=e._callbackObj.getDatePos(g);for(r.push(g.getTime());c<s;)g=e._timeAxis.getNextDate(g.getTime()),c=e._callbackObj.getDatePos(g),r.push(g.getTime())}x._majorTickDates=r;for(var m=0;m<r.length-1;m++){var v=r[m];if(c=e._callbackObj.getDatePos(v),!e.isVertical()&&l)var u=_-c;else u=c;if(e.isVertical())var p=l?o:0,S=p,b=u,D=e._maxOverflowValue+p,f=u;else S=u,b=e.Height-2,D=u,f=e.Height+h;var T=e.addTick(a,S,D,b,f,e._majorSeparatorStroke,"o_tick"+c);T.time=v,e._seriesTicksArray.push(T)}},_renderReferenceObjects:(e,i)=>{var s=e.getCtx(),a=t.Agent.isRightToLeft(s),r=e._callbackObj.isDiscreteNavigationMode()?e._callbackObj._discreteContentLength:e._length,n=e._callbackObj.getTimeAxisSize(),l=e._callbackObj._seriesScale?n:0;null==e._refObjectsContainer&&(e._refObjectsContainer=new t.Container(s),i.addChild(e._refObjectsContainer));var h=e._referenceObjects;if(h)for(var _=Math.min(1,h.length),d=0;d<_;d++){var g=h[d];if(g){var c=e._callbackObj.getDatePos(g);if(0===e._renderedReferenceObjects.length){if(e.isVertical())var m=new t.Line(s,0,c,e._maxOverflowValue,c,"zoomOrder[i]");else a&&(c=r-c),m=new t.Line(s,c,0,c,e._maxOverflowValue,"zoomOrder[i]");var v=new t.Stroke(o.getReferenceObjectColor(e.Options));m.setStroke(v),m.setPixelHinting(!0),m.date=g,e._refObjectsContainer.addChild(m),e._renderedReferenceObjects[d]=m}else(m=e._renderedReferenceObjects[d]).date=g,c=e._callbackObj.getDatePos(m.date),e.isVertical()?(m.setX1(0),m.setY1(c),m.setX2(e._maxOverflowValue),m.setY2(c)):(a&&(c=r-c),m.setX1(c),m.setY1(0),m.setX2(c),m.setY2(e._maxOverflowValue-l))}}else e._refObjectsContainer.removeChildren(),e._renderedReferenceObjects=[]},_updateReferenceObjects:e=>{for(var i=e.getCtx(),s=t.Agent.isRightToLeft(i),a=e._callbackObj.isDiscreteNavigationMode()?e._callbackObj._discreteContentLength:e._length,r=e._callbackObj.getTimeAxisSize(),n=e._callbackObj._seriesScale?r:0,l=0;l<e._renderedReferenceObjects.length;l++){var o=e._renderedReferenceObjects[l],h=e._callbackObj.getDatePos(o.date);e.isVertical()?(o.setX1(0),o.setY1(h),o.setX2(e._maxOverflowValue),o.setY2(h)):(s&&(h=a-h),o.setX1(h),o.setY1(0),o.setX2(h),o.setY2(e._maxOverflowValue-n))}},_removeItems:(e,t,i,s)=>{if(s)x._animateItemRemoval(e,t,s);else for(var a=0;a<e.length;a++){var r=e[a],n=r.getBubble();if(i.removeChild(n),!t.isVertical()&&r._timeline.isFeelerEnabled()){var l=i.feelers,o=r.getFeeler();l.removeChild(o)}var h=r.getStartTime(),_=r.getEndTime();if(_&&_!==h){var d=i.durations,g=r.getDurationBar();d.removeChild(g)}}},_animateItemRemoval:(e,t,i)=>{for(var s=0;s<e.length;s++){var a=e[s],r=a.getBubble();if(t.isVertical()?r.setTranslateX(r.getTranslateX()+t._canvasOffsetX+t._overflowOffset):r.setTranslateY(r.getTranslateY()+t._canvasOffsetY+t._overflowOffset),i.push(r),!t.isVertical()&&a._timeline.isFeelerEnabled()){var n=a.getFeeler();n.setTranslateY(n.getTranslateY()+t._canvasOffsetY+t._overflowOffset),i.push(n)}var l=a.getStartTime(),o=a.getEndTime();if(o&&o!==l){var h=a.getDurationBar();t.isVertical()?h.setTranslateX(h.getTranslateX()+t._canvasOffsetX+t._overflowOffset):h.setTranslateY(h.getTranslateY()+t._canvasOffsetY+t._overflowOffset),i.push(h)}}}};class M extends t.BaseComponent{constructor(e,t,i){super(e),this._callback=t,this._callbackObj=i,this._blocks=[],this._renderedReferenceObjects=[],this._seriesTicksArray=[],this._seriesMinorTicksArray=[]}triggerAnimations(){var e=this.getCtx();if(this._rmAnimationElems&&0!==this._rmAnimationElems.length){this._callbackObj.EventManager.removeListeners(this._callbackObj);var i=new t.ParallelPlayable(e,new t.AnimFadeOut(e,this._rmAnimationElems,o.getAnimationDuration(this.Options)));t.Playable.appendOnEnd(i,this._onRmAnimationEnd,this),this._callbackObj.Animation=i,i.play()}else if(this._mvAnimator&&this._hasMvAnimations)this._callbackObj.EventManager.removeListeners(this._callbackObj),t.Playable.appendOnEnd(this._mvAnimator,this._onMvAnimationEnd,this),this._callbackObj.Animation=this._mvAnimator,this._mvAnimator.play();else if(this._frAnimationElems&&0!==this._frAnimationElems.length){this._callbackObj.EventManager.removeListeners(this._callbackObj);var s=new t.ParallelPlayable(e,new t.AnimFadeIn(e,this._frAnimationElems,o.getAnimationDuration(this.Options),(this._isInitialRender,0)));t.Playable.appendOnEnd(s,this._onAnimationEnd,this),this._callbackObj.Animation=s,s.play()}}_onRmAnimationEnd(){for(var e=0;e<this._rmAnimationElems.length;e++){var i=this._rmAnimationElems[e],s=i.getParent();s&&s.removeChild(i)}this._mvAnimator&&this._hasMvAnimations?(this._callbackObj.Animation=this._mvAnimator,t.Playable.appendOnEnd(this._mvAnimator,this._onMvAnimationEnd,this),this._mvAnimator.play()):this._onMvAnimationEnd()}_onMvAnimationEnd(){if(this._frAnimationElems&&0!==this._frAnimationElems.length){var e=new t.ParallelPlayable(this.getCtx(),new t.AnimFadeIn(this.getCtx(),this._frAnimationElems,o.getAnimationDuration(this.Options),(this._isInitialRender,0)));t.Playable.appendOnEnd(e,this._onAnimationEnd,this),this._callbackObj.Animation=e,e.play()}else this._onAnimationEnd()}_onAnimationEnd(){this._callbackObj.onAnimationEnd()}render(e,i,a){if(e){this.SetOptions(e),this.Width?this._isInitialRender=!1:this._isInitialRender=!0,this.Width=i,this.Height=a;var r=this.Options.orientation;if(r&&"vertical"===r?(this._isVertical?this._allowUpdates=!0:this._allowUpdates=!1,this._isVertical=!0):(this._isVertical?this._allowUpdates=!1:this._allowUpdates=!0,this._isVertical=!1),this.Options){var n=this.Parse(this.Options);this._applyParsedProperties(n)}this._fetchStartPos=0,this._isVertical?(this._fetchEndPos=a,this._maxOverflowValue=i,this._length=a,this._size=i,this._offset=0):(this._maxOverflowValue=a,this._callbackObj.isDiscreteNavigationMode()?(this._offset=this._callbackObj._discreteOffset,this._length=i-2*this._offset,this._fetchEndPos=i-2*this._offset):(this._length=i,this._fetchEndPos=i,this._offset=0),this._size=a),this._isInverted=this.Options.inverted,this._colorCount=0,this._maxDurationSize=0,x.renderSeries(this,i,a),s.TimeAxisUtils.supportsTouch()&&this._items.length>0&&this._setAriaProperty("flowto","_bt_"+this._items[0].getId());var l=this.GetComponentDescription();l&&(t.ToolkitUtils.setAttrNullNS(this.getElem(),"role","img"),t.ToolkitUtils.setAttrNullNS(this.getElem(),"aria-label",t.AriaUtils.processAriaLabel(l)))}else this._handleResize(i,a)}GetComponentDescription(){var e=this.Options.translations,i=[e.labelSeries];return this._label?i.push(this._label):i.push(this.Options.index+1),t.ResourceUtils.format(e.labelAndValue,i)}_handleResize(e,t){this._canvas.setTranslateY(0),this._callbackObj.isDiscreteNavigationMode()||this._canvas.setTranslateX(0),this.Width=e,this.Height=t,this._fetchStartPos=0,this._isVertical?(this._fetchEndPos=t,this._maxOverflowValue=e,this._length=t,this._size=e,this._offset=0):(this._maxOverflowValue=t,this._callbackObj.isDiscreteNavigationMode()?(this._offset=this._callbackObj._discreteOffset,this._length=e-2*this._offset,this._fetchEndPos=e-2*this._offset,this._canvas.setTranslateX(this._offset)):(this._length=e,this._fetchEndPos=e,this._offset=0),this._size=t),this._background.setWidth(e),this._background.setHeight(t),x.updateSeriesForZoom(this),this._callbackObj.getEventManager()._isDndDragging&&this._callbackObj.getEventManager().updateDnd()}applyStyleValues(){if(this._style=new t.CSSStyle(o.getSeriesStyle()),this._seriesStyleDefaults=this.Options.seriesStyleDefaults,this._axisStyleDefaults=this.Options.axisStyleDefaults,this._colors=o.getColorsArray(this.Options),this._referenceObjects=this.Options.referenceObjects,this._seriesStyleDefaults){var e=this._seriesStyleDefaults.backgroundColor;e&&this._style.parseInlineStyle("background-color:"+e+";")}this._style.parseInlineStyle(this._inlineStyle)}SetOptions(e){this.Options=e}Parse(e){return this._parser=new k(this.getCtx()),this._parser.parse(e,this._items)}_applyParsedProperties(e){this._items&&(this._oldItems=this._items),this._items=e.items,this._items&&this._items.length>0?this._isEmpty=!1:this._isEmpty=!0,this._isIRAnimationEnabled=e.isIRAnimationEnabled,this._isDCAnimationEnabled=e.isDCAnimationEnabled,this._label=e.label,this._timeAxis=e.timeAxis,this._emptyText=e.emptyText,null==this._emptyText&&(this._emptyText=this.Options.translations.labelNoData),this._isTopToBottom=e.isTopToBottom,this._isRandomItemLayout=e.isRandomItemLayout,this._customTimeScales=e.customTimeScales,this._customFormatScales=e.customFormatScales,this._start=e.start,this._end=e.end,this._inlineStyle=e.inlineStyle,this._scale=e.scale,this._converter=e.converter,this._data=e.data,this.applyStyleValues()}calculateSpacing(e,t){var i,s,a;if(null==this._items||0===this._items.length)return null;var r=this._maxOverflowValue,n=e.getSpacing();if(this._isRandomItemLayout){if(null==n){var l=e.getHeight(),h=this._initialSpacing,_=this._maxOverflowValue-l-h;_<0&&(_=0),n=Math.round(Math.random()*_)+h,this._maxOverflowValue<n+l&&(this._maxOverflowValue=n+l+o.getBubbleSpacing())}return n}if(null==n&&(n=this._initialSpacing),this._isVertical)for(i=0;i<t;i++)r<n+(a=(s=this._items[i]).getWidth()+10)&&(r=n+a);else{var d=e.getEndViewportCollision()?e.getContentWidth():0,g=e.getLoc()-d,c=e.getWidth()+16,m=o.getBubbleSpacing(),v=[];for(i=0;i<t;i++){a=(s=this._items[i]).getWidth()+16,d=s.getEndViewportCollision()?s.getContentWidth():0;var u=s.getLoc()-d;(g>=u&&g<=u+a||u>=g&&u<=g+c)&&v.push(s)}for(i=0;i<v.length;i++){for(var p=!1,S=0;S<v.length;S++){var b=(s=v[S]).getHeight(),D=s.getSpacing();if(n>=D&&n<=D+b){n=D+b+m,e.setSpacing(n),p=!0;break}}if(!p)break}r<n+b&&(r=n+b)}return r>this._maxOverflowValue&&(this._maxOverflowValue=r+o.getBubbleSpacing()),n}calculateDurationSize(e,t){var i,s;if(null==this._items||0===this._items.length||"duration-bar"!==e.getItemType())return null;var a=e.getStartTime(),r=e.getEndTime();if(!r||r===a)return null;var n=e.getDurationLevel();null==n&&(n=1);var l=[];for(i=0;i<t;i++){var o=(s=this._items[i]).getStartTime(),h=s.getEndTime();h&&h!==o&&a>=o&&a<=h&&l.push(s)}for(i=0;i<l.length;i++){for(var _=!1,d=0;d<l.length;d++){var g=(s=l[d]).getDurationLevel();if(n===g){n=g+1,e.setDurationLevel(n),_=!0;break}}if(!_)break}return n>this._maxDurationSize&&(this._maxDurationSize=n),n}prepareDurations(){for(var e=0;e<this._items.length;e++){var t=this._items[e],i=t.getStartTime(),s=t.getEndTime();s&&s!==i&&(t.setDurationLevel(this.calculateDurationSize(t,e)),t.setDurationSize(22+10*t.getDurationLevel()-5),null==t.getDurationFillColor()&&(t.setDurationFillColor(this._colors[this._colorCount]),this._colorCount++,this._colorCount===this._colors.length&&(this._colorCount=0)))}}prepareItems(e){var t,i,s;for(this.isVertical()?this._initialSpacing=20*(this._maxDurationSize>0?1:0)+o.getBubbleSpacing()+10*this._maxDurationSize:this._initialSpacing=20+o.getBubbleSpacing()+10*this._maxDurationSize,t=0;t<e.length;t++){i=e[t],s=this._callbackObj.getDatePos(i.getStartTime());var a=i.getEndTime();if(a&&a!==i.getStartTime()){var r=this._callbackObj.getDatePos(a)-s;i.getItemType()!==h.DURATION_EVENT&&(s+=Math.min(o.getDurationFeelerOffset(),r/2))}i.setLoc(s)}for(t=0;t<this._items.length;t++)i=this._items[t],(s=this._callbackObj.getDatePos(i.getStartTime()))>=this._fetchStartPos&&s<=this._fetchEndPos&&c.initializeItem(i,this,t)}getData(e){if(e){var t={emptyText:this._data.emptyText,id:this._data.id,itemLayout:this._data.itemLayout,label:this._data.label,svgStyle:this._data.svgStyle,items:this._data.items};return i.TimeComponent.sanitizeData(t,"series")}return this._data}getLabel(){return this._label}getEmptyText(){return this._emptyText}findItem(e){if(null!=this._items)for(var i=0;i<this._items.length;i++){var s=this._items[i];if(t.Obj.compareValues(this.getCtx(),s.getId(),e))return s}return null}isInverted(){return this._isInverted}isTopToBottom(){return this._isTopToBottom}isVertical(){return this._isVertical}addTick(e,i,s,a,r,n,l){var o=new t.Line(this.getCtx(),i,a,s,r,l);return o.setStroke(n),o.setPixelHinting(!0),e.addChild(o),o}setVScrollPos(e){null!=this._canvas&&this._canvas.setTranslateY(0-e)}setHScrollPos(e){null!=this._canvas&&this._canvas.setTranslateX(this._offset-e)}}class I extends i.TimeComponent{constructor(e,i,s){super(e,i,s),this.Defaults=new d(e),this.EventManager=new m(this),this.EventManager.addListeners(this),t.Agent.isTouchDevice()?this._keyboardHandler=null:(this._keyboardHandler=new n(this.EventManager),this.EventManager.setKeyboardHandler(this._keyboardHandler))}Parse(e){return this._parser=new v,this._parser.parse(e)}_applyParsedProperties(e){var i=this.Options.orientation;this._isVertical=!(!i||"vertical"!==i),this._viewportNavigationMode=this.Options.viewportNavigationMode,this._hasOverview=e.hasOverview,this._viewStartTime=e.viewStart,this._viewEndTime=e.viewEnd,this._initialViewportTimeDuration=this._viewEndTime-this._viewStartTime,this._selectionMode=e.selectionMode,"single"===this._selectionMode?this.SelectionHandler=new t.SelectionHandler(this.getCtx(),t.SelectionHandler.TYPE_SINGLE):"multiple"===this._selectionMode?this.SelectionHandler=new t.SelectionHandler(this.getCtx(),t.SelectionHandler.TYPE_MULTIPLE):this.SelectionHandler=null,this.EventManager.setSelectionHandler(this.SelectionHandler);var a=this.isDnDMoveEnabled(),r=this.isDnDResizeEnabled();if(a||r){this.Options.dnd=t.JsonUtils.merge(this.Options.dnd,{drag:{event:{dataTypes:[]},"resize-handle":{dataTypes:[]}},drop:{canvas:{dataTypes:[]}}});var n=this,l=(e,t)=>{var i=n.Options.dnd.drag[t].dataTypes;Array.isArray(i)||(n.Options.dnd.drag[t].dataTypes=[i],i=n.Options.dnd.drag[t].dataTypes),i.push(e);var s=n.Options.dnd.drop.canvas.dataTypes;Array.isArray(s)||(n.Options.dnd.drop.canvas.dataTypes=[s],s=n.Options.dnd.drop.canvas.dataTypes),s.push(e)};r&&l("text/_dvtdndresizeitems","resize-handle"),a&&l("text/_dvtdndmoveitems","event")}this._shortDesc=e.shortDesc?e.shortDesc:this._shortDesc,this._referenceObjects=e.referenceObjects?e.referenceObjects:this._referenceObjects,this._seriesScale=e.seriesScale?e.seriesScale:this._seriesScale,this._seriesScale?(this._seriesConverter=e.seriesConverter,this._seriesTimeAxis=new s.TimeAxis(this.getCtx(),null,null),this._seriesTimeAxis.setIsVertical(this._isVertical),this._seriesTimeAxis.setScale(this._seriesScale),this._seriesTimeAxis.setConverter(this._seriesConverter),this._seriesCustomFormatScales=e.seriesCustomFormatScales,this._isVertical?this._seriesTimeAxis.setDefaultConverter(this._resources.converterVert):this._seriesTimeAxis.setDefaultConverter(this._resources.converter)):this._seriesTimeAxis=null,this._defaultInversions=[!1,!0],this._itemPosition=e.itemPosition,this._customTimeScales=e.customTimeScales,this._customFormatScales=e.customFormatScales,this._scale=e.scale,super._applyParsedProperties(e)}getTimeAxis(){return this._timeAxis}getTimeAxisSize(){return this._timeAxis.getSize()}getTimeAxisVisibleSize(e){return this._hasOverview||1!==e?this.getTimeAxisSize():this.getTimeAxisSize()-this._timeAxis.getBorderWidth()}select(e){this.Options.selection=t.JsonUtils.clone(e),this.SelectionHandler&&this.applyInitialSelections()}_bundleTimeAxisOptions(e,t){var i=this._resources;"majorAxis"===t?(i.axisSeparatorClass="oj-timeline-major-axis-separator",i.axisLabelClass="oj-timeline-major-axis-label"):"minorAxis"===t&&(i.axisClass="oj-timeline-minor-axis",i.axisSeparatorClass="oj-timeline-minor-axis-separator",i.axisLabelClass="oj-timeline-minor-axis-label");var s={start:e.start,end:e.end,_resources:i,shortDesc:e.shortDesc,_tzo:e._tzo,_ip:e._ip,_cts:this._customTimeScales,_cfs:this._customFormatScales,orientation:e.orientation};if(e.styleDefaults&&e.styleDefaults.minorAxis){var a=e.styleDefaults.minorAxis;s.backgroundColor=a.backgroundColor,s.borderColor=a.borderColor,s.separatorColor=a.separatorColor,s.labelStyle=a.labelStyle}if(e[t]){var r=e[t];r.scale&&(s.scale=r.scale),r.converter&&(s.converter=r.converter),s.zoomOrder=r.zoomOrder||[r.scale]}if(e.minorAxis){var n=e.minorAxis;"alta"===this.getCtx().getThemeBehavior()?(s._scaleLabelPosition={seconds:"center",minutes:"center",hours:"center",days:"center",weeks:"center",months:"center",quarters:"center",years:"center"},s._labelAlignment={horizontal:"middle",vertical:"middle"}):(s._scaleLabelPosition={seconds:"start",minutes:"start",hours:"start",days:"center",weeks:"start",months:"start",quarters:"start",years:"start"},s._labelAlignment={horizontal:"middle",vertical:"middle"}),s.zoomOrder.forEach(e=>{if(e&&e.name){const t=e.labelPosition||"auto",i="auto"===t?"start":t;s._scaleLabelPosition[e.name]=i}}),s.style=n.style,n.svgStyle&&(s.style=n.svgStyle)}return s}render(e,t,i){if(e){if(super.render(e,t,i),this.isDndEnabled()){var a=this.getCtx();this.renderAriaLiveRegion("_dvtTimelineAriaLiveRegion"+a.getStage().getId())}else this.removeAriaLiveRegion();this.StopAnimation(),this._fetchStartPos=0,this._isVertical?this._fetchEndPos=i:this._fetchEndPos=t,this.Options.styleDefaults&&(this.Options.styleDefaults.item.descriptionStyle=o.convertToCSSStyle(this.Options.styleDefaults.item.descriptionStyle),this.Options.styleDefaults.item.titleStyle=o.convertToCSSStyle(this.Options.styleDefaults.item.titleStyle),this.Options.styleDefaults.majorAxis.labelStyle=o.convertToCSSStyle(this.Options.styleDefaults.majorAxis.labelStyle),this.Options.styleDefaults.minorAxis.labelStyle=o.convertToCSSStyle(this.Options.styleDefaults.minorAxis.labelStyle),this.Options.styleDefaults.overview.labelStyle=o.convertToCSSStyle(this.Options.styleDefaults.overview.labelStyle),this.Options.styleDefaults.series.emptyTextStyle=o.convertToCSSStyle(this.Options.styleDefaults.series.emptyTextStyle),this.Options.styleDefaults.series.labelStyle=o.convertToCSSStyle(this.Options.styleDefaults.series.labelStyle),this.Options.styleDefaults.tooltipLabelStyle=o.convertToCSSStyle(this.Options.styleDefaults.tooltipLabelStyle),this.Options.styleDefaults.tooltipValueStyle=o.convertToCSSStyle(this.Options.styleDefaults.tooltipValueStyle),this._majorAxisStyleDefaults=this.Options.styleDefaults.majorAxis,this._seriesStyleDefaults=this.Options.styleDefaults.series);var r=e.majorAxis;if(r)if(r.scale){var n=this._bundleTimeAxisOptions(this.Options,"majorAxis");null==this._majorAxis&&(this._majorAxis=new s.TimeAxis(this.getCtx(),null,null)),this._majorAxis.setCanvasSize(null),this._majorAxis.getPreferredLength(n,this._canvasLength)}else this._majorAxis=null;else this._majorAxis=null;if(this._scale&&(this._timeAxisOptions=this._bundleTimeAxisOptions(this.Options,"minorAxis"),this._majorAxis&&(this._timeAxisOptions._secondaryAxis=this._majorAxis),this.applyAxisStyleValues(),this._timeAxis||(this._timeAxis=new s.TimeAxis(this.getCtx(),null,null)),this._isVertical?this._timeAxis.setBorderVisibility(!1,!0,!1,!0):this._timeAxis.setBorderVisibility(!0,!1,!0,!1),this._timeAxis.setCanvasSize(null),!this.hasMatchingViewportDates())){var l=this._timeAxis.getPreferredLength(this._timeAxisOptions,this._canvasLength);l&&this.setContentLength(l),this._timeAxis.hasValidOptions()&&this.prepareViewportLength()}if(this.isDiscreteNavigationMode()){this.hasMatchingViewportDates()||(this._discreteViewportStartIndex=0,this._discreteViewportCurrentIndexOffset=0,this._discreteViewportDatePositions=[this._viewStartTime,this._viewEndTime]);var h=o.getNavButtonBackgroundWidth();this._timeAxisRatio=(this._canvasLength-2*h)/this._canvasLength,this._discreteOffset=(this.getContentLength()-this.getContentLength()*this._timeAxisRatio)/2,this._discreteContentLength=this.getContentLength()*this._timeAxisRatio}this._populateSeries(),A.renderTimeline(this),this.isDiscreteNavigationMode()&&this.doInitialPan(),this.UpdateAriaAttributes(),s.TimeAxisUtils.supportsTouch()||this.getCtx().setKeyboardFocusArray([this]),this.Animation||this.RenderComplete()}else this._handleResize(t,i)}hasMatchingViewportDates(){return this.isVertical()?(this._discreteViewportDatePositions=null,!1):this.isDiscreteNavigationMode()&&null!=this._discreteViewportDatePositions&&-1!=this._discreteViewportDatePositions.indexOf(this._viewStartTime)&&-1!=this._discreteViewportDatePositions.indexOf(this._viewEndTime)}hasValidSeriesItems(){for(var e=0;e<this._seriesOptions.length;e++){var t=this._seriesOptions[e];if(t.items)for(var i=0;i<t.items.length;i++){var s=t.items[i],a=new Date(s.start).getTime();if(null==a||isNaN(a)||null==s.start)return!1;if(s.hasOwnProperty("end")){var r=new Date(s.end).getTime();if(!isNaN(r)&&r<a)return!1}}}return!0}hasValidOptions(){var e=this._scale&&(-1!==s.TimeAxis.VALID_SCALES.indexOf(this._scale)||this.isTimeComponentScale(this._scale)),t=this._scale&&this._customTimeScales&&this._customTimeScales[this._scale],i=this._start&&this._end&&this._end>this._start,a=this._series&&this._series.length>0,r=!!a&&this.hasValidSeriesItems(),n=!this._seriesScale||(-1!==s.TimeAxis.VALID_SCALES.indexOf(this._seriesScale)||this.isTimeComponentScale(this._seriesScale)),l=!this._seriesScale||this._customTimeScales&&this._customTimeScales[this._seriesScale],o=!this._viewStartTime||!this._viewEndTime||this._viewEndTime>this._viewStartTime,h=!this._viewStartTime||this._viewStartTime>=this._start&&this._viewStartTime<this._end,_=!this._viewEndTime||this._viewEndTime>this._start&&this._viewEndTime<=this._end;return(e||t)&&(n||l)&&i&&a&&r&&o&&h&&_}isTimeComponentScale(e){return null!=e.getNextDate&&null!=e.getPreviousDate&&null!=e.formatter&&null!=e.name}GetComponentDescription(){return this._shortDesc?this._shortDesc:this.Options.translations.componentName}applyStyleValues(){if(this._style=new t.CSSStyle(o.getTimelineStyle()),this.Options.styleDefaults){var e=this.Options.styleDefaults.borderColor;e&&this._style.parseInlineStyle("border-color:"+e+";")}if(this._hasOverview){this._overviewSize=this._isVertical?o.getOverviewWidth():o.getOverviewHeight();var i=this.Options.overview,s=i.svgStyle?i.svgStyle:i.style;if(s){var a=new t.CSSStyle(s),r=this._isVertical?a.getWidth():a.getHeight();null!=r&&(this._overviewSize=t.CSSStyle.toNumber(r))}}super.applyStyleValues();var n=this._style.getBorderWidth(),l=2*n,h="border:"+l+"px;";this._style.parseInlineStyle(h),this.setStartXOffset(n),this.setStartYOffset(n),this.setBackgroundXOffset(0);var _=3*this.getScrollbarPadding();this.timeDirScrollbarStyles=this.getTimeDirScrollbarStyle(),this.contentDirScrollbarStyles=this.getContentDirScrollbarStyle(),this._backgroundWidth=this.Width,this._backgroundHeight=this.Height,this._isVertical?(this.isContentDirScrollbarOn()&&(this._backgroundHeight=this._backgroundHeight-t.CSSStyle.toNumber(this.contentDirScrollbarStyles.getHeight())-_),this._canvasLength=this._backgroundHeight-l,this._hasOverview?(this._canvasSize=this._backgroundWidth-this._overviewSize-l,this.isRTL()&&this.setStartXOffset(n+this._overviewSize)):(this.isTimeDirScrollbarOn()&&(this._backgroundWidth=this._backgroundWidth-t.CSSStyle.toNumber(this.timeDirScrollbarStyles.getWidth())-_),this._canvasSize=this._backgroundWidth-l,this.isRTL()&&(this.setBackgroundXOffset(this.Width-this._backgroundWidth),this.setStartXOffset(this.getStartXOffset()+this.getBackgroundXOffset())))):(this.isContentDirScrollbarOn()&&(this._backgroundWidth=this._backgroundWidth-t.CSSStyle.toNumber(this.contentDirScrollbarStyles.getWidth())-_),this._canvasLength=this._backgroundWidth-l,this.isRTL()&&(this.setBackgroundXOffset(this.Width-this._backgroundWidth),this.setStartXOffset(this.getStartXOffset()+this.getBackgroundXOffset())),this._hasOverview?this._canvasSize=this._backgroundHeight-this._overviewSize-l:(this.isTimeDirScrollbarOn()&&(this._backgroundHeight=this._backgroundHeight-t.CSSStyle.toNumber(this.timeDirScrollbarStyles.getHeight())-_),this._canvasSize=this._backgroundHeight-l))}applyAxisStyleValues(){if(this._seriesStyleDefaults&&this._seriesStyleDefaults.backgroundColor){var e=this._seriesStyleDefaults.backgroundColor,i=t.ColorUtils.getRed(e),s=t.ColorUtils.getGreen(e),a=t.ColorUtils.getBlue(e);this._seriesBackgroundOverlayStyle="background-color:rgba("+i+","+s+","+a+",0.8);"}}_populateSeries(){var e,t=this.Options.series;if(t){var i=Math.min(t.length,2);if(this._seriesOptions=[],this._series)if(i!==this._series.length){for(e=0;e<this._series.length;e++)this._timeZoomCanvas.removeChild(this._series[e]);this._series=[]}else for(e=0;e<this._series.length;e++)this._series[e]._items&&t[e].items&&this._series[e]._items[0]._data.itemType!==t[e].items[0].itemType&&(this._timeZoomCanvas.removeChild(this._series[e]),this._series[e]=null);else this._series=[];for(e=0;e<i;e++){var s=t[e];if(s.start=this._start,s.end=this._end,s.inverted=this._defaultInversions[e],s.orientation=this.Options.orientation,s.referenceObjects=this._referenceObjects,s.timeline=this,s.index=e,s.animationOnDisplay=this.Options.animationOnDisplay,s.animationOnDataChange=this.Options.animationOnDataChange,this.Options.majorAxis&&(s.scale=void 0===this.Options.majorAxis.scale?this._seriesScale:this.Options.majorAxis.scale,s.timeAxis=this._seriesTimeAxis,s._cfs=this._seriesCustomFormatScales),s.styleDefaults=this.Options.styleDefaults,this.Options.styleDefaults&&(s.seriesStyleDefaults=this._seriesStyleDefaults,s.axisStyleDefaults=this._majorAxisStyleDefaults),s._isRandomItemLayout="random"===this._itemPosition,s._cts=this.Options._cts,s._data=t[e],s.translations=this.Options.translations,this._seriesOptions.push(s),null==this._series[e]){var a=new M(this.getCtx(),this.HandleEvent,this);this._series[e]=a}}}else this._series=[]}onAnimationEnd(){this.AnimationStopped||this.RenderComplete(),this.EventManager.addListeners(this),this.Animation=null,this.AnimationStopped=!1}_getOverviewObject(){var e=new Object;e.width=this._contentLength,e.selmode=this._selectionMode,e.rtl=this.isRTL(),e.sid="ts1";var t=o.getOverviewWindowBackgroundColor(this.Options);e._wbc=t,e._hfc=t;var i=o.getOverviewWindowBorderColor(this.Options);return e._wbtc=i,e._wbrc=i,e._wbbc=i,e._wblc=i,e._ls=o.getOverviewLabelStyle(this.Options).toString(),e._obc=o.getOverviewBackgroundColor(this.Options),e._ctic=o.getReferenceObjectColor(this.Options),this._referenceObjects&&this._referenceObjects.length>0&&this._referenceObjects[0]&&(e.ocd=this._referenceObjects[0].getTime()),this._isVertical?(e.orn="vertical",e.yMin=this._start,e.yMax=this._end,e.y1=this._viewStartTime,e.y2=this._viewEndTime):(e.orn="horizontal",e.xMin=this._start,e.xMax=this._end,e.x1=this._viewStartTime,e.x2=this._viewEndTime,e._ds="square",e._dsx="1.3d",e._dsy="0.9d"),this._resources.overviewHandleVert&&(e._vhbc=this._resources.overviewHandleVert,e._vhs=16),this._resources.overviewHandleHor&&(e._hbc=this._resources.overviewHandleHor,e._hs=16),e.axisTicks=this._getOverviewAxisOptions(),e.markers=this._getOverviewMarkerOptions(),e}_getOverviewAxisOptions(){var e=[];if(this._seriesTimeAxis){var t,i;if(this._customTimeScales&&this._customTimeScales[this._seriesScale]){var s=this._customTimeScales[this._seriesScale];t=s.times,i=s.labels}else if(this._seriesCustomFormatScales&&this._seriesCustomFormatScales[this._seriesScale]){var a=this._seriesCustomFormatScales[this._seriesScale];t=a.times,i=a.labels}else{t=[],i=[];this._start,this._end,this._isVertical?this.Height:this.Width;for(var r=this.getPosDate(this._fetchStartPos),n=this._seriesTimeAxis.adjustDate(r),l=this.getDatePos(n);l<this._fetchEndPos;)i.push(this._seriesTimeAxis.formatDate(n)),t.push(n.getTime()),n=this._seriesTimeAxis.getNextDate(n.getTime()),l=this.getDatePos(n)}for(var o=0;o<i.length;o++){var h=new Object;h.time=t[o],h.label=i[o],e.push(h)}}return e}_getOverviewMarkerOptions(){if(this._series){for(var e=[],t=this._series.length,i=0;i<t;i++)for(var s=this._series[i]._items,a=0;a<s.length;a++){var r=s[a],n=new Object;n.rk=a,n.sid=i,n.tid=r.getId(),n.t=r.getStartTime(),n._sd=r.getMarkerSD(),this._isVertical||(r.getMarkerShape()&&(n.s=r.getMarkerShape()),r.getMarkerScaleX()&&(n.sx=r.getMarkerScaleX()),r.getMarkerScaleY()&&(n.sy=r.getMarkerScaleY())),r.getMarkerShortDesc()&&(n.d=r.getMarkerShortDesc()),r.getMarkerFillColor()&&(n.c=r.getMarkerFillColor()),r.getMarkerGradientFill()&&(n.g=r.getMarkerGradientFill()),r.getMarkerOpacity()&&(n.o=r.getMarkerOpacity());var l=r.getEndTime();if(l){n.et=l;var o=r.getDurationFillColor();o&&r.getItemType()===h.DURATION_BAR&&(n.dfc=o)}e.push(n)}return e}return null}createViewportChangeEvent(){var e=this._timeAxis.getScale();return"string"!=typeof e&&(e=e.name),t.EventFactory.newTimelineViewportChangeEvent(this._viewStartTime,this._viewEndTime,e)}HandleTouchStart(e){var t=e.touches,i=e.target.getClassName();1!==t.length||i||(this._dragPanSeries=this._findSeries(e.target))}HandleMouseWheel(e){if(super.HandleMouseWheel(e),this.hasValidOptions()&&!this.isDiscreteNavigationMode()&&e.zoomWheelDelta){var t=this.getCtx().pageToStageCoords(e.pageX,e.pageY);if(this.getGraphicalAreaBounds().containsPoint(t.x,t.y)){var i=this.getContentLength()*e.zoomWheelDelta,s=e.zoomTime,a=e.zoomCompLoc;this.handleZoomWheel(i,s,a,!0)}}}handleZoomWheel(e,t,i,s){var a;e>this._timeAxis.getMaxContentLength()?(e=this._timeAxis.getMaxContentLength(),this.disableZoomButton(!0)):this.enableZoomButton(!0),this._canvasLength>e?(e=this._canvasLength,this.disableZoomButton(!1)):this.enableZoomButton(!1);var r=this.getContentLength()<=e;super.handleZoomWheel(e,t,i,s);var n=this._timeAxis.getZoomLevelLengths();if(r)for(;this._timeAxis.getZoomLevelOrder()>0&&(a=n[this._timeAxis.getZoomLevelOrder()-1],this.getContentLength()>=a);)this._timeAxis.setZoomLevelOrder(this._timeAxis.getZoomLevelOrder()-1),this._timeAxis.decreaseScale();else for(;this._timeAxis.getZoomLevelOrder()<n.length-1&&(a=n[this._timeAxis.getZoomLevelOrder()],this.getContentLength()<a);)this._timeAxis.setZoomLevelOrder(this._timeAxis.getZoomLevelOrder()+1),this._timeAxis.increaseScale();if(this._hasOverview&&(this._isVertical?this._overview.setViewportRange(null,null,this._viewStartTime,this._viewEndTime):this._overview.setViewportRange(this._viewStartTime,this._viewEndTime,null,null)),this.isTimeDirScrollbarOn()&&this.timeDirScrollbar.setViewportRange(this._viewStartTime,this._viewEndTime),this.applyAxisStyleValues(),A._renderAxis(this,this._timeZoomCanvas,!0),this.updateSeries(),this.isContentDirScrollbarOn())for(var l=0;l<this._series.length;l++)this.contentDirScrollbar[l].setViewportRange(0,this._seriesSize,0,Math.max(this._series[l]._maxOverflowValue,this._seriesSize));s&&this.dispatchEvent(this.createViewportChangeEvent())}updateSeries(){if(this._series){var e=this._series.length,i=this.getTimeAxisVisibleSize(e);this._seriesSize=(this._canvasSize-i)/e;for(var s=0;s<e;s++){var a=this._series[s];a.setClipPath(null);var r=new t.ClipPath;if(this._isVertical){if(this.isRTL())var n=Math.abs(s-1);else n=s;if(this.isRTL()&&1===this._series.length){r.addRect(i,0,this._seriesSize,this.getContentLength());var l=new t.Matrix(1,0,0,1,i,0)}else r.addRect(n*(this._seriesSize+i),0,this._seriesSize,this.getContentLength()),l=new t.Matrix(1,0,0,1,n*(this._seriesSize+i),0);var o=this._seriesSize,h=this.getContentLength()}else r.addRect(0,s*(this._seriesSize+i),this.getContentLength(),this._seriesSize),l=new t.Matrix(1,0,0,1,0,s*(this._seriesSize+i)),o=this.getContentLength(),h=this._seriesSize;a.setClipPath(r),a.setMatrix(l),a.render(null,o,h)}}}_handleResize(e,t){if(this.Width=e,this.Height=t,this.applyStyleValues(),this._fetchStartPos=0,this._isVertical?this._fetchEndPos=t:this._fetchEndPos=e,this.prepareViewportLength(),A._removeEmptyText(this),A._renderBackground(this),this.isDiscreteNavigationMode()){var i=o.getNavButtonBackgroundWidth();this._timeAxisRatio=(this._canvasLength-2*i)/this._canvasLength,this._discreteOffset=(this.getContentLength()-this.getContentLength()*this._timeAxisRatio)/2,this._discreteContentLength=this.getContentLength()*this._timeAxisRatio}if(this.hasValidOptions()){if(this.renderTimeZoomCanvas(this._canvas),this.applyAxisStyleValues(),this.updateSeries(),A._renderAxis(this,this._timeZoomCanvas),A._renderSeriesLabels(this),A._renderZoomControls(this),this.isDiscreteNavigationMode()&&(A._renderNavigationArrows(this,this._timeZoomCanvas),this.doInitialPan()),this._hasOverview&&(A._renderOverview(this),this.SelectionHandler)){var s=this.SelectionHandler.getSelectedIds();if(s&&0!==s.length)for(var a=0;a<s.length;a++)this._overview.selSelectItem(s[a])}(this.isTimeDirScrollbarOn()||this.isContentDirScrollbarOn())&&A._renderScrollbars(this)}else A._renderEmptyText(this);this.Animation||this.RenderComplete()}HandleKeyDown(e){t.KeyboardEvent.RIGHT_ARROW!==e.keyCode&&t.KeyboardEvent.LEFT_ARROW!==e.keyCode&&t.KeyboardEvent.DOWN_ARROW!==e.keyCode&&t.KeyboardEvent.UP_ARROW!==e.keyCode||this.getEventManager()._isDndDragging||this.updateScrollForItemNavigation(this.EventManager.getFocus())}HandleMouseDown(e){e.target.getClassName()||(this._dragPanSeries=this._findSeries(e.target))}endDragPan(){this._dragPanSeries=null,this.endPan()}endPan(){this._triggerViewportChange&&(this._triggerViewportChange=!1,this.dispatchEvent(this.createViewportChangeEvent()))}panBy(e,t){var i,s=this._series.length,a=this.getTimeAxisVisibleSize(s);if(this._isVertical){if(this._dragPanSeries){var r=this._dragPanSeries.getTranslateX()-e;if(this._series.length>1&&(!this.isRTL()&&this._dragPanSeries._isInverted||this.isRTL()&&!this._dragPanSeries._isInverted))var n=a+2*this._dragPanSeries.Width-this._dragPanSeries._maxOverflowValue,l=this._dragPanSeries.Width+a;else this.isRTL()&&!this._dragPanSeries._isInverted?(n=this._dragPanSeries.Width-this._dragPanSeries._maxOverflowValue+a,l=a):(n=0,l=this._dragPanSeries._maxOverflowValue-this._dragPanSeries.Width);r<n?r=n:r>l&&(r=l),this._dragPanSeries.setTranslateX(r),this.isContentDirScrollbarOn()&&(this._series[0]===this._dragPanSeries?this.isRTL()?(i=2===s?this.getTimeAxisVisibleSize()+this._seriesSize-r:this.getTimeAxisVisibleSize()-r,this.contentDirScrollbar[0].setViewportRange(i,i+this._seriesSize)):this.contentDirScrollbar[0].setViewportRange(r,r+this._seriesSize):this.isRTL()?this.contentDirScrollbar[1].setViewportRange(r,r+this._seriesSize):(i=this.getTimeAxisVisibleSize()+this._seriesSize-r,this.contentDirScrollbar[1].setViewportRange(i,i+this._seriesSize)))}this.panZoomCanvasBy(t),this._hasOverview&&this._overview.setViewportRange(null,null,this._viewStartTime,this._viewEndTime),this.isTimeDirScrollbarOn()&&this.timeDirScrollbar.setViewportRange(this._viewStartTime,this._viewEndTime),A._renderAxis(this,this._timeZoomCanvas,!0)}else if(this.isDiscreteNavigationMode()||(this.panZoomCanvasBy(e),this._hasOverview&&this._overview.setViewportRange(this._viewStartTime,this._viewEndTime,null,null),this.isTimeDirScrollbarOn()&&this.timeDirScrollbar.setViewportRange(this._viewStartTime,this._viewEndTime),A._renderAxis(this,this._timeZoomCanvas,!0)),this._dragPanSeries){var o=this._dragPanSeries.getTranslateY()-t;if(this._dragPanSeries._isInverted)var h=a+2*this._dragPanSeries.Height-this._dragPanSeries._maxOverflowValue,_=this._dragPanSeries.Height+a;else h=0,_=this._dragPanSeries._maxOverflowValue-this._dragPanSeries.Height;o<h?o=h:o>_&&(o=_),this._dragPanSeries.setTranslateY(o),this.isContentDirScrollbarOn()&&(this._series[0]===this._dragPanSeries?this.contentDirScrollbar[0].setViewportRange(o,o+this._seriesSize):(i=this.getTimeAxisVisibleSize()+this._seriesSize-o,this.contentDirScrollbar[1].setViewportRange(i,i+this._seriesSize)))}}isDnDMoveEnabled(){var e=this.Options.dnd;return e&&"enabled"===e.move.items}isDnDResizeEnabled(){var e=this.Options.itemDefaults;return e&&"enabled"===e.resizable}isDndEnabled(){var e=this.isDnDMoveEnabled(),t=this.isDnDResizeEnabled();return this.getEventManager().isDndSupported()&&(e||t)}HandleEvent(e,i){var s,a,r,n,l,o,h,_,d,g=e.type;if("dvtSimpleScrollbar"===g)e=this.processScrollbarEvent(e,i);else if("selection"===g)this.dispatchEvent(e);else if("overview"===g){if("rangeChanging"===(n=e.subtype)||"rangeChange"===n){var c=this._viewEndTime-this._viewStartTime;this._isVertical?(this._viewStartTime=e.newY1,this._viewEndTime=e.newY2):(this._viewStartTime=e.newX1,this._viewEndTime=e.newX2);var m=this._viewEndTime-this._viewStartTime;if(m>0){r=this._canvasLength/m,this.setContentLength(r*(this._end-this._start)),this.setRelativeStartPos(r*(this._start-this._viewStartTime));var v=this._timeAxis.getZoomLevelLengths();if(c>m){for(a=v[(s=v.length)-1];this.getContentLength()>=a&&s>0;)a=v[--s-1];s===v.length&&s--,this._timeAxis.setZoomLevelOrder(s),this._timeAxis.setScale(this._timeAxis.getZoomOrder()[s])}else{for(a=v[s=0];this.getContentLength()<a&&s<v.length-1;)a=v[++s];this._timeAxis.setZoomLevelOrder(s),this._timeAxis.setScale(this._timeAxis.getZoomOrder()[s])}this.applyAxisStyleValues(),A._renderAxis(this,this._timeZoomCanvas,!0),this.updateSeries(),this.applyTimeZoomCanvasPosition()}"rangeChange"===n&&this.dispatchEvent(this.createViewportChangeEvent())}"scrollPos"!==n&&"scrollTime"!==n||(this._isVertical?(this._viewStartTime=e.newY1,this._viewEndTime=e.newY2):(this._viewStartTime=e.newX1,this._viewEndTime=e.newX2),r=this.getContentLength()/(this._end-this._start),this.setRelativeStartPos(r*(this._start-this._viewStartTime)),this.applyTimeZoomCanvasPosition(),A._renderAxis(this,this._timeZoomCanvas,!0),this.dispatchEvent(this.createViewportChangeEvent()))}else if("timeline"===g)if("selection"===(n=e.subtype)){var u=e.itemId,p=e.isMultiSelect&&"multiple"===this._selectionMode;for(l=0;l<this._series.length;l++)for(h=this._series[l],o=0;o<h._items.length;o++)if(_=h._items[o],t.Obj.compareValues(this.getCtx(),_.getId(),u)){this.EventManager.setFocusObj(_),this.updateScrollForItemSelection(_),this.SelectionHandler._addToSelection(_,p)&&this.EventManager.fireSelectionEvent(_);break}}else if("highlight"===n){for(d=e.itemId,l=0;l<this._series.length;l++)for(h=this._series[l],o=0;o<h._items.length;o++)if(_=h._items[o],t.Obj.compareValues(this.getCtx(),_.getId(),d)){_.showHoverEffect(!0);break}}else if("unhighlight"===n)for(d=e.itemId,l=0;l<this._series.length;l++)for(h=this._series[l],o=0;o<h._items.length;o++)if(_=h._items[o],t.Obj.compareValues(this.getCtx(),_.getId(),d)){_.hideHoverEffect(!0);break}}processScrollbarEvent(e,t){super.processScrollbarEvent(e,t),t===this.timeDirScrollbar&&A._renderAxis(this,this._timeZoomCanvas,!0);var i=e.newMin;t===this.contentDirScrollbar[0]?this.isVertical()?2===this._series.length?this._series[0].setTranslateX(this.isRTL()?this.getTimeAxisVisibleSize()+this._seriesSize-i:i):this._series[0].setTranslateX(this.isRTL()?this.getTimeAxisVisibleSize()-i:i):this._series[0].setTranslateY(i):t===this.contentDirScrollbar[1]&&(this.isVertical()?this._series[1].setTranslateX(this.isRTL()?i:this.getTimeAxisVisibleSize()+this._seriesSize-i):this._series[1].setTranslateY(this.getTimeAxisVisibleSize()+this._seriesSize-i))}discreteScrollIntoViewport(e){if(this.isDiscreteNavigationMode()){var t=e.getStartTime(),i=Math.floor((t-this._viewStartTime)/this._initialViewportTimeDuration);0!==i&&(this._discreteViewportCurrentIndexOffset+=i,this.handlePageChangeDiscreteViewport())}}updateScrollForItemSelection(e){if(this.isDiscreteNavigationMode())this.discreteScrollIntoViewport(e);else{var t=this._viewEndTime-this._viewStartTime;this._viewStartTime=e.getStartTime()-t/2,this._viewStartTime<this._start?this._viewStartTime=this._start:this._viewStartTime+t>this._end&&(this._viewStartTime=this._end-t),this._viewEndTime=this._viewStartTime+t;var i=this.getContentLength()/(this._end-this._start);this.setRelativeStartPos(i*(this._start-this._viewStartTime)),this.applyTimeZoomCanvasPosition(),A._renderAxis(this,this._timeZoomCanvas),this.dispatchEvent(this.createViewportChangeEvent())}}updateScrollForItemNavigation(e){if(e instanceof h&&!this.getEventManager()._isDndDragging)if(this.isDiscreteNavigationMode())this.discreteScrollIntoViewport(e);else{var t=this._isVertical?e.getHeight():e.getWidth(),i=o.getItemHoverStrokeWidth(e._timeline.Options),s=e.getLoc()-(this._isVertical?t/2+i:o.getBubbleOffset(this)+i),a=this.getRelativeStartPos();this.isRTL()&&!this._isVertical&&(s-=i);var r=s+t+2*i,n=a-this._canvasLength;-s>a?a=-s:-r<n&&(a=-r+this._canvasLength);var l=this.getContentLength()/(this._end-this._start),_=this._viewEndTime-this._viewStartTime;this._viewStartTime=this._start-a/l,this._viewStartTime<this._start&&(this._viewStartTime=this._start,a=(this._start-this._viewStartTime)*l),this._viewEndTime=this._viewStartTime+_,this._viewEndTime>this._end&&(this._viewEndTime=this._end,this._viewStartTime=this._viewEndTime-_,a=(this._start-this._viewStartTime)*l),this.setRelativeStartPos(a),this.applyTimeZoomCanvasPosition(),this._hasOverview&&(this._isVertical?this._overview.setViewportRange(null,null,this._viewStartTime,this._viewEndTime):this._overview.setViewportRange(this._viewStartTime,this._viewEndTime,null,null)),this.isTimeDirScrollbarOn()&&this.timeDirScrollbar.setViewportRange(this._viewStartTime,this._viewEndTime),A._renderAxis(this,this._timeZoomCanvas),this.dispatchEvent(this.createViewportChangeEvent())}}isItemSelectionEnabled(){return"none"!==this._selectionMode}isFeelerEnabled(){return this.Options.itemDefaults&&"on"===this.Options.itemDefaults.feelers}applyInitialSelections(){if(this.Options.selection)for(var e=[],t=0;t<this._series.length;t++)for(var i=this._series[t],s=0;s<i._items.length;s++)e.push(i._items[s]);this.SelectionHandler.processInitialSelections(this.Options.selection,e)}_findSeries(e){if(this.hasValidOptions()&&e&&e!==this){var t=e.getId();return e===this._series[0]||this._series.length>1&&e===this._series[1]?e:t&&"_s0"===t.substring(t.length-3,t.length)?this._series[0]:t&&"_s1"===t.substring(t.length-3,t.length)?this._series[1]:this._findSeries(e.getParent())}return null}_findDrawable(e){if(e){var t=e.getId();if(t&&"_duration_"===t.substring(0,10)&&e._node)return e;var i=e.getParent();if(i){if(t&&"zoom"===t.substring(0,4))return e;if(t&&"_bubble_"===t.substring(0,8)&&i._node)return i;var s=i.getParent();if(s){if(t&&"_bubble_"===t.substring(0,8)&&s._node)return s;if((t=s.getId())&&"_bubble_"===t.substring(0,8)&&s.getParent())return s.getParent()}}}return null}getAutomation(){return this.Automation||(this.Automation=new _(this)),this.Automation}clearComponent(){this.getEventManager().RemoveListeners(this),super.clearComponent(),this.clearOverview()}clearOverview(){this._overviewCanvas&&(this.removeChild(this._overviewCanvas),this._overviewCanvas=null)}isTimeDirScrollbarOn(){return!this._hasOverview&&!this.isDiscreteNavigationMode()}isContentDirScrollbarOn(){return!0}isDiscreteNavigationMode(){return"discrete"===this._viewportNavigationMode&&"redwood"===this.getCtx().getThemeBehavior()&&!this.isVertical()}getBackgroundXOffset(){return this._backgroundX}setBackgroundXOffset(e){this._backgroundX=e}getDiscreteOffset(){return this._discreteOffset?this._discreteOffset:0}getDiscreteViewportDateOffsetPos(e){var t,i,s=this._discreteViewportStartIndex+e;if(s<0)for(t=this._discreteViewportDatePositions[0],i=this._discreteViewportDatePositions[1];s<0;){var a=this.getClosestDate(t-this._initialViewportTimeDuration);this._discreteViewportDatePositions.unshift(a),i=t,t=a,this._discreteViewportStartIndex++,s++}else if(s>this._discreteViewportDatePositions.length-2)for(t=this._discreteViewportDatePositions[this._discreteViewportDatePositions.length-2],i=this._discreteViewportDatePositions[this._discreteViewportDatePositions.length-1];s>this._discreteViewportDatePositions.length-2;){var r=this.getClosestDate(i+this._initialViewportTimeDuration);this._discreteViewportDatePositions.push(r),t=i,i=r}else t=this._discreteViewportDatePositions[s],i=this._discreteViewportDatePositions[s+1];return{startDate:t,endDate:i}}getClosestDate(e){var t=(e,t)=>{var i=this._timeAxis.adjustDate(e,t),s=this._timeAxis.getNextDate(i,t);return Date.parse(e-i>s-e?s:i)},i=t(e),s=t(e,this.Options.majorAxis.scale);if(null!=s)return Math.abs(e-i)>Math.abs(e-s)?s:i}getDiscreteViewportPanningLength(e,i){var s=this.getCtx(),a=t.Agent.isRightToLeft(s),r=this.getDatePos(e);return(this.getDatePos(i)-r)*(a?-1:1)}getDatePos(e){var t=this.isDiscreteNavigationMode()?this._discreteContentLength:this._contentLength;return s.TimeAxisUtils.getDatePosition(this._start,this._end,e,t)}getPosDate(e){var t=this.isDiscreteNavigationMode()?this._discreteContentLength:this._contentLength;return s.TimeAxisUtils.getPositionDate(this._start,this._end,e,t)}getDiscreteViewportDatePos(e){return s.TimeAxisUtils.getDatePosition(this._start,this._end,e,this._discreteContentLength)}getDiscreteViewportPosDate(e){return s.TimeAxisUtils.getPositionDate(this._start,this._end,e,this._discreteContentLength)}getDiscreteViewportStartDate(){var e=o.getNavButtonBackgroundWidth(),t=this.getDiscreteViewportDatePos(this._viewStartTime);return Math.max(this.getDiscreteViewportPosDate(t-e),this._start)}getDiscreteViewportEndDate(){var e=o.getNavButtonBackgroundWidth(),t=this.getDiscreteViewportDatePos(this._viewEndTime);return Math.min(this.getDiscreteViewportPosDate(t+e),this._end)}updateDiscreteViewport(){A._renderAxis(this,this.getTimeZoomCanvas(),!0),A._renderNavigationArrows(this,this.getTimeZoomCanvas()),this._hasOverview&&A._renderOverview(this),this.updateSeries(),A._renderScrollbars(this)}handlePageChangeDiscreteViewport(){var e=this.getDiscreteViewportDateOffsetPos(this._discreteViewportCurrentIndexOffset);if(e.startDate>this._start&&e.endDate<this._end){var t=this.getDiscreteViewportPanningLength(this._viewStartTime,e.startDate);this.panZoomCanvasBy(t),this._viewStartTime=e.startDate,this._viewEndTime=e.endDate,this.updateDiscreteViewport(),this.dispatchEvent(this.createViewportChangeEvent())}}doInitialPan(){var e=this.getCtx(),i=t.Agent.isRightToLeft(e),s=this._viewStartTime,a=this._viewEndTime,r=this.getDiscreteViewportStartDate(),n=this.getDiscreteViewportPanningLength(this._start,r);if(i){var l=o.getNavButtonBackgroundWidth(),h=this.getDatePos(this._viewEndTime),_=this.getPosDate(h+l);n=this._discreteContentLength+this.getDiscreteViewportPanningLength(this._start,_)}var d=n+this.getDiscreteOffset()+this._startPos;this.panZoomCanvasBy(d),this._viewStartTime=s,this._viewEndTime=a}startPanAllowed(){return this.getDiscreteViewportDateOffsetPos(this._discreteViewportCurrentIndexOffset-1).startDate>this._start}endPanAllowed(){return this.getDiscreteViewportDateOffsetPos(this._discreteViewportCurrentIndexOffset+1).endDate<this._end}}e.Timeline=I,e.TimelineOverview=w,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=ojtimeline-toolkit.js.map