/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","ojs/ojdvt-toolkit","ojs/ojdvt-timecomponent","ojs/ojtimeaxis-toolkit"],function(t,e,i,a){"use strict";var n=new Object;e.Obj.createSubclass(n,e.Obj),n._DEFAULT_TIMEAXES_LABEL_STYLE=e.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color: #333333;",n._DEFAULT_ZOOM_CONTROL_DIAMETER=31,n._DEFAULT_ZOOM_CONTROL_PADDING=10.5,n._DEFAULT_ZOOM_CONTROL_SPACING=9,n._DEFAULT_STANDALONE_TASK_HEIGHT=22,n._DEFAULT_BASELINE_MARGIN_TOP=0,n._DEFAULT_BASELINE_TASK_HEIGHT=6,n._DEFAULT_TASK_DOWNTIME_HEIGHT=4,n._DEFAULT_TASK_ATTRIBUTE_HEIGHT=5,n._DEFAULT_SUMMARY_THICKNESS=3,n._DEFAULT_TASK_LABEL_PADDING=5,n._DEFAULT_TASK_PADDING=5,n._DEFAULT_TASK_EFFECT_MARGIN=2,n._DEFAULT_TASK_TINT_FILTER_ID="ojGanttTaskTintFilter",n._DEFAULT_TASK_SHADE_FILTER_ID="ojGanttTaskShadeFilter",n._DEFAULT_TASK_TINT_ALPHA=.3,n._DEFAULT_TASK_SHADE_ALPHA=.35,n._DEFAULT_AXIS_HEIGHT=23,n._ROW_LABELS_AXIS_GAP=0,n._ROW_LABEL_EXPAND_COLLAPSE_BUTTON_SIZE=24,n._ROW_LABEL_INDENT_SIZE=n._ROW_LABEL_EXPAND_COLLAPSE_BUTTON_SIZE,n._ROW_LABEL_BUTTON_CONTENT_GAP_SIZE=8,n._ROW_LABEL_CONTAINER_PADDING=8,n._DEFAULT_DEPENDENCY_LINE_INNER_COLOR="#ffffff",n._DEFAULT_DEPENDENCY_LINE_INNER_WIDTH=2,n._DEFAULT_ANIMATION_DURATION=.5,n._DEPENDENCY_LINE_ARC_RADIUS=6,n._DEPENDENCY_LINE_TASK_FLANK_LENGTH=20,n._DEPENDENCY_TRIANGLE_MARKER_HEIGHT=8,n._DEPENDENCY_TRIANGLE_MARKER_WIDTH=6,n._DEPENDENCY_ANGLE_MARKER_HEIGHT=12,n._DEPENDENCY_ANGLE_MARKER_WIDTH=8,n._DEPENDENCY_CIRCLE_MARKER_RADIUS=3,n._DEPENDENCY_TRIANGLE_MARKER_ID="ojGanttDependencyMarkerEndTriangle",n._DEPENDENCY_ANGLE_MARKER_ID="ojGanttDependencyMarkerEndAngle",n._DEPENDENCY_OPEN_CIRCLE_MARKER_ID="ojGanttDependencyMarkerOpenCircle",n._DEPENDENCY_CLOSED_CIRCLE_MARKER_ID="ojGanttDependencyMarkerClosedCircle",n._AUTOPAN_EDGE_THRESHOLD=20,n._DEFAULT_TASK_RESIZE_HANDLE_WIDTH=5,n._DEFAULT_TASK_RESIZE_HANDLE_WIDTH_TOUCH=20,n.getHorizontalScrollbarStyle=function(){return new e.CSSStyle(n._DEFAULT_HORIZONTAL_SCROLLBAR_STYLE)},n.getVerticalScrollbarStyle=function(){return new e.CSSStyle(n._DEFAULT_VERTICAL_SCROLLBAR_STYLE)},n.getStandaloneTaskHeight=function(t){var e=t?t._resources:null;return e&&e.taskDefaults&&null!=e.taskDefaults.height?n.getSizeInPixels(e.taskDefaults.height):n._DEFAULT_STANDALONE_TASK_HEIGHT},n.getActualTaskHeight=function(t,e){return"alta"===e.getThemeBehavior()?n.getStandaloneTaskHeight(t)-n.getBaselineMarginTop(t)-n.getBaselineTaskHeight(t):n.getStandaloneTaskHeight(t)},n.getBaselineMarginTop=function(t){var e=t?t._resources:null;return e&&e.baselineMarginTop?this.getSizeInPixels(e.baselineMarginTop):n._DEFAULT_BASELINE_MARGIN_TOP},n.getBaselineTaskHeight=function(t){var e=t?t._resources:null;return e&&e.taskDefaults&&e.taskDefaults.baseline&&null!=e.taskDefaults.baseline.height?n.getSizeInPixels(e.taskDefaults.baseline.height):n._DEFAULT_BASELINE_TASK_HEIGHT},n.getTaskDowntimeHeight=function(t){var e=t?t._resources:null;return e&&e.taskDowntimeHeight?n.getSizeInPixels(e.taskDowntimeHeight):n._DEFAULT_TASK_DOWNTIME_HEIGHT},n.getTaskAttributeHeight=function(t){var e=t?t._resources:null;return e&&e.taskAttributeHeight?n.getSizeInPixels(e.taskAttributeHeight):n._DEFAULT_TASK_ATTRIBUTE_HEIGHT},n.getMilestoneBaselineYOffset=function(t){return n.getBaselineTaskHeight(t)},n.getSummaryThickness=function(){return n._DEFAULT_SUMMARY_THICKNESS},n.getRowPaddingTop=function(t){var e=t?t._resources:null;return e&&null!=e.rowPaddingTop?n.getSizeInPixels(e.rowPaddingTop):n._DEFAULT_TASK_PADDING},n.getRowPaddingBottom=function(t){var e=t?t._resources:null;return e&&null!=e.rowPaddingBottom?n.getSizeInPixels(e.rowPaddingBottom):n._DEFAULT_TASK_PADDING},n.getTaskPadding=function(t){var e=t?t._resources:null;return e&&null!=e.taskPaddingLeft?n.getSizeInPixels(e.taskPaddingLeft):n._DEFAULT_TASK_LABEL_PADDING},n.getTaskMargin=function(t){var e=t?t._resources:null;return e&&null!=e.taskMarginLeft?n.getSizeInPixels(e.taskMarginLeft):n._DEFAULT_TASK_LABEL_PADDING},n.getTaskLabelMargin=function(t){var e=t?t._resources:null;return e&&null!=e.taskLabelMarginLeft?n.getSizeInPixels(e.taskLabelMarginLeft):n._DEFAULT_TASK_LABEL_PADDING},n.getTaskEffectMargin=function(){return n._DEFAULT_TASK_EFFECT_MARGIN},n.getTaskTintFilterId=function(){return n._DEFAULT_TASK_TINT_FILTER_ID},n.getTaskShadeFilterId=function(){return n._DEFAULT_TASK_SHADE_FILTER_ID},n.getTaskTintAlpha=function(){return n._DEFAULT_TASK_TINT_ALPHA},n.getTaskShadeAlpha=function(){return n._DEFAULT_TASK_SHADE_ALPHA},n.getTimeAxisHeight=function(t,e){var i=t[e];if(i&&i.height)return i.height;var a=t._resources;return a&&a[e]&&null!=a[e].height?n.getSizeInPixels(a[e].height):n._DEFAULT_AXIS_HEIGHT},n.getMajorAxisLabelStyle=function(t){var i=t._resources,a=n._DEFAULT_TIMEAXES_LABEL_STYLE;return i&&(a=i.majorAxisLabelFontProp),new e.CSSStyle(a)},n.getMinorAxisLabelStyle=function(t){var i=t._resources,a=n._DEFAULT_TIMEAXES_LABEL_STYLE;return i&&(a=i.minorAxisLabelFontProp),new e.CSSStyle(a)},n.getRowAxisGap=function(){return n._ROW_LABELS_AXIS_GAP},n.getDependencyLineTaskFlankLength=function(){return n._DEPENDENCY_LINE_TASK_FLANK_LENGTH},n.getDependencyLineArcRadius=function(t){return"alta"===t.getThemeBehavior()?0:n._DEPENDENCY_LINE_ARC_RADIUS},n.getDependencyLineTriangleMarkerWidth=function(){return n._DEPENDENCY_TRIANGLE_MARKER_WIDTH},n.getDependencyLineTriangleMarkerHeight=function(){return n._DEPENDENCY_TRIANGLE_MARKER_HEIGHT},n.getDependencyLineAngleMarkerWidth=function(){return n._DEPENDENCY_ANGLE_MARKER_WIDTH},n.getDependencyLineAngleMarkerHeight=function(){return n._DEPENDENCY_ANGLE_MARKER_HEIGHT},n.getDependencyLineCircleMarkerRadius=function(){return n._DEPENDENCY_CIRCLE_MARKER_RADIUS},n.getDependencyLineTriangleMarkerId=function(){return n._DEPENDENCY_TRIANGLE_MARKER_ID},n.getDependencyLineAngleMarkerId=function(){return n._DEPENDENCY_ANGLE_MARKER_ID},n.getDependencyLineOpenCircleMarkerId=function(){return n._DEPENDENCY_OPEN_CIRCLE_MARKER_ID},n.getDependencyLineClosedCircleMarkerId=function(){return n._DEPENDENCY_CLOSED_CIRCLE_MARKER_ID},n.getDependencyLineTaskGap=function(t){return n.getRowPaddingTop(t)-1},n.getAutoPanEdgeThreshold=function(){return n._AUTOPAN_EDGE_THRESHOLD},n.getTaskLabelStyle=function(t){var i=t._resources,a="";return i&&(a=i.taskLabelFontProp),new e.CSSStyle(a)},n.getRowLabelStyle=function(t){var i=t._resources,a="";return i&&(a=i.rowLabelFontProp),new e.CSSStyle(a)},n.getRowLabelPadding=function(t){var e=t?t._resources:null;return e&&null!=e.rowLabelPaddingLeft?n.getSizeInPixels(e.rowLabelPaddingLeft):n._ROW_LABEL_CONTAINER_PADDING},n.getRowLabelButtonSize=function(){return n._ROW_LABEL_EXPAND_COLLAPSE_BUTTON_SIZE},n.getRowLabelIndentSize=function(){return n._ROW_LABEL_INDENT_SIZE},n.getRowLabelButtonContentGapSize=function(){return n._ROW_LABEL_BUTTON_CONTENT_GAP_SIZE},n.getChartStrokeWidth=function(t){var i=t._resources;if(i){var a=i.chartArea;if(a){var n=a.strokeWidth;if(n)return e.CSSStyle.toNumber(n)}}return 1},n.getHorizontalGridlineWidth=function(t){return t._resources?e.CSSStyle.toNumber(t._resources.horizontalGridlineWidth):1},n.getAnimationDuration=function(t){var i,a=n._DEFAULT_ANIMATION_DURATION;return t._resources&&(i=t._resources.animationDuration)&&(a=e.CSSStyle.getTimeMilliseconds(i)/1e3),a},n.getFocusedDependencyLineInnerColor=function(t){return n._DEFAULT_DEPENDENCY_LINE_INNER_COLOR},n.getFocusedDependencyLineInnerWidth=function(t){return n._DEFAULT_DEPENDENCY_LINE_INNER_WIDTH},n.getTaskResizeHandleWidth=function(){return e.Agent.isTouchDevice()?n._DEFAULT_TASK_RESIZE_HANDLE_WIDTH_TOUCH:n._DEFAULT_TASK_RESIZE_HANDLE_WIDTH},n.getSizeInPixels=function(t,e){if("string"==typeof t){if("%"===t.slice(-1))return e*Number(t.slice(0,-1))/100;if("px"===t.slice(-2))return Number(t.slice(0,-2));t=Number(t)}return"number"==typeof t?t<=1&&null!=e?e*t:t:0};var s=function(t){this.Init(t)};e.Obj.createSubclass(s,e.Container),s.prototype.nodeType="dependency",s.START_START="startStart",s.START_FINISH="startFinish",s.FINISH_START="finishStart",s.FINISH_FINISH="finishFinish",s.CONFLICT_NONE=0,s.CONFLICT_PREDECESSOR=1,s.CONFLICT_SUCCESSOR=2,s.CONFLICT_BOTH=3,s.prototype.Init=function(t){s.superclass.Init.call(this,t.getCtx(),null),this._gantt=t,this._gantt.getEventManager().associate(this,this)},s.prototype.getGantt=function(){return this._gantt},s.prototype.getId=function(){return this._dependencyObj.id},s.prototype.setLayoutObject=function(t){this._dependencyObj=t},s.prototype.getLayoutObject=function(){return this._dependencyObj},s.prototype.getValue=function(t){var e;switch(t){case"type":e=this._dependencyObj.type;break;case"predecessorTaskId":e=this._dependencyObj.predecessorTaskObj.id;break;case"successorTaskId":e=this._dependencyObj.successorTaskObj.id;break;default:e=this._dependencyObj.data[t]}return e},s.prototype.getPredecessorNode=function(){return this._dependencyObj.predecessorTaskObj.node},s.prototype.getSuccessorNode=function(){return this._dependencyObj.successorTaskObj.node},s._getTaskStart=function(t,i){var a=e.Agent.isRightToLeft(t.getGantt().getCtx()),s=t.getGantt().getOptions(),r=t.getTask().getShape("main"),o=t.getTaskLabel(),h=o.getLabelOutputText(),l=o.getEffectiveLabelPosition(),d=n.getTaskLabelMargin(s),g=i?0:n.getTaskMargin(s);return a?i||null==h||null==h.getParent()||"end"!==l?t.getFinalX()+r.getFinalX()-r.getFinalWidth()-r.getPhysicalEndOffset()-g:t.getFinalX()+r.getFinalX()-r.getFinalWidth()-r.getPhysicalEndOffset()-h.getDimensions().w-2*d:i||null==h||null==h.getParent()||"start"!==l?t.getFinalX()+r.getFinalX()-r.getPhysicalStartOffset()-g:t.getFinalX()+r.getFinalX()-r.getPhysicalStartOffset()-h.getDimensions().w-2*d},s._getTaskMiddle=function(t){var e=t.getTask(),i=e.getShape("main"),a=t.getGantt().getCtx().getThemeBehavior(),n=e.isSummary("main")&&"alta"===a?t.getLayoutObject().height:i.getFinalHeight();return s._getTaskTop(t)+i.getFinalY()+Math.round(n/2)},s._getTaskEnd=function(t,i){var a=e.Agent.isRightToLeft(t.getGantt().getCtx()),s=t.getGantt().getOptions(),r=t.getTask().getShape("main"),o=t.getTaskLabel(),h=o.getLabelOutputText(),l=o.getEffectiveLabelPosition(),d=n.getTaskLabelMargin(s),g=i?0:n.getTaskMargin(s);return a?i||null==h||null==h.getParent()||"start"!==l?t.getFinalX()+r.getFinalX()+r.getPhysicalStartOffset()+g:t.getFinalX()+r.getFinalX()+r.getPhysicalStartOffset()+h.getDimensions().w+2*d:i||null==h||null==h.getParent()||"end"!==l?t.getFinalX()+r.getFinalX()+r.getFinalWidth()+r.getPhysicalEndOffset()+g:t.getFinalX()+r.getFinalX()+r.getFinalWidth()+r.getPhysicalEndOffset()+h.getDimensions().w+2*d},s._getTaskTop=function(t){return t.getFinalY()},s._getTaskBottom=function(t,e){var i=e?t.getLayoutObject().height:t.getFinalHeight();return s._getTaskTop(t)+i},s._isValidType=function(t){return t===s.START_START||t===s.START_FINISH||t===s.FINISH_START||t===s.FINISH_FINISH},s.prototype.isCustomContent=function(){var t=this._gantt.getOptions();return t.dependencyContent&&t.dependencyContent.renderer},s.prototype.getRendererContext=function(t){var e=this._gantt.getOptions(),i=this._gantt.getCtx(),a=this.getValue("type"),n=this.getPredecessorNode(),r=this.getSuccessorNode(),o=s._getRenderingTypeState(i,a),h=s._getEndPoints(n,r,o.isTypeBeginFinish,o.isTypeEndFinish,!0,!0),l={data:this.getLayoutObject().data,itemData:e.dependencyData?this.getLayoutObject()._itemData:null,content:{predecessorX:h.predecessorX,predecessorY:h.predecessorY,successorX:h.successorX,successorY:h.successorY},state:t};return i.fixRendererContext(l)},s.prototype._renderCustomContent=function(t){var i=this.getGantt(),a=i.getOptions();this._content&&this.removeChild(this._content),this._content=new e.Container(i.getCtx()),this._content.setClassName(i.GetStyleClass("dependencyLineCustom")),this.addChild(this._content);var n=this._content.getContainerElem(),s=(0,a.dependencyContent.renderer)(this.getRendererContext(t));s&&(Array.isArray(s)?s.forEach(function(t){e.ToolkitUtils.appendChildElem(n,t)}):e.ToolkitUtils.appendChildElem(n,s))},s.prototype.render=function(t,i){i=!1!==i;this.getParent()!=t&&t.addChild(this),this.setAriaRole("img");var a=this.getGantt(),r=a.getCtx(),o=this.getValue("type"),h=this.getPredecessorNode(),l=this.getSuccessorNode();if(e.Agent.deferAriaCreation()||this.setAriaProperty("label",this.getAriaLabel()),this.isCustomContent())this._content&&!i||this._renderCustomContent({focused:!1});else{if("ie"!==e.Agent.browser&&"edge"!==e.Agent.browser||this._cleanup(),null!=this._line){this._line.setCmds(s._calcDepLine(r,h,l,o));var d=this._line.getElem()}else{var g=new e.Path(r,s._calcDepLine(r,h,l,o));0===n.getDependencyLineArcRadius(r)&&g.setPixelHinting(!0),d=g.getElem(),this.addChild(g);var c=new e.Stroke(n.getFocusedDependencyLineInnerColor(),1,n.getFocusedDependencyLineInnerWidth()),_=new e.Stroke("#000",1,1);g.setHoverStroke(c,_),this._line=g}var p=this.getValue("svgStyle");p&&this._line.setStyle(p);var u=a.GetStyleClass("dependencyLine");"straight"===a.getOptions().dependencyLineShape?(u+=" "+a.GetStyleClass("dependencyStraightLine"),h.isSelected()?u+=" "+a.GetStyleClass("dependencyStartOpenStraightLine"):u+=" "+a.GetStyleClass("dependencyStartClosedStraightLine"),l.isSelected()?u+=" "+a.GetStyleClass("dependencyEndOpenStraightLine"):u+=" "+a.GetStyleClass("dependencyEndClosedStraightLine")):u+=" "+a.GetStyleClass("dependencyRectilinearLine");var m=this.getValue("svgClassName");m?e.ToolkitUtils.setAttrNullNS(d,"class",u+" "+m):e.ToolkitUtils.setAttrNullNS(d,"class",u)}},s.prototype.hide=function(){this.setAlpha(0)},s.prototype.show=function(){this.setAlpha(1)},s.prototype._cleanup=function(){null!=this._line&&(this.removeChild(this._line),this._line=null)},s.prototype._calcConflict=function(){var t=!1,e=!1,i=this.getValue("type"),a=this.getGantt().getNavigableDependencyLinesForTask(this.getPredecessorNode(),"predecessor");if(null!=a)for(var n=0;n<a.length;n++){var r=a[n].getValue("type");(i!==s.START_START&&i!==s.START_FINISH||r!==s.START_START&&r!==s.FINISH_START)&&(i!==s.FINISH_FINISH&&i!==s.FINISH_START||r!==s.FINISH_FINISH&&r!==s.START_FINISH)||(t=!0)}if(null!=(a=this.getGantt().getNavigableDependencyLinesForTask(this.getSuccessorNode(),"successor")))for(n=0;n<a.length;n++)r=a[n].getValue("type"),(i!==s.START_START&&i!==s.FINISH_START||r!==s.START_START&&r!==s.START_FINISH)&&(i!==s.FINISH_FINISH&&i!==s.START_FINISH||r!==s.FINISH_FINISH&&r!==s.FINISH_START)||(e=!0);return t&&e?s.CONFLICT_BOTH:t?s.CONFLICT_PREDECESSOR:e?s.CONFLICT_SUCCESSOR:s.CONFLICT_NONE},s._getEndPoints=function(t,e,i,a,n,r){return{predecessorX:i?s._getTaskEnd(t,n):s._getTaskStart(t,n),predecessorY:r||t.getTask().isMilestone("main")?s._getTaskMiddle(t):s._getTaskBottom(t,!0),successorX:a?s._getTaskEnd(e,n):s._getTaskStart(e,n),successorY:r||e.getTask().isMilestone("main")?s._getTaskMiddle(e):s._getTaskTop(e)}},s._getRenderingTypeState=function(t,i){var a=e.Agent.isRightToLeft(t);switch(i){case s.START_START:return a?{isTypeBeginFinish:!0,isTypeEndFinish:!0}:{isTypeBeginFinish:!1,isTypeEndFinish:!1};case s.START_FINISH:return a?{isTypeBeginFinish:!0,isTypeEndFinish:!1}:{isTypeBeginFinish:!1,isTypeEndFinish:!0};case s.FINISH_START:return a?{isTypeBeginFinish:!1,isTypeEndFinish:!0}:{isTypeBeginFinish:!0,isTypeEndFinish:!1};case s.FINISH_FINISH:return a?{isTypeBeginFinish:!1,isTypeEndFinish:!1}:{isTypeBeginFinish:!0,isTypeEndFinish:!0}}return null},s._calcDepLine=function(t,e,i,a){var n=this._getRenderingTypeState(t,a);return"straight"===e.getGantt().getOptions().dependencyLineShape?s._calcStraightLine(e,i,n.isTypeBeginFinish,n.isTypeEndFinish):s._calcRectilinearLine(e,i,n.isTypeBeginFinish,n.isTypeEndFinish)},s._calcStraightLine=function(t,i,a,n){var r=s._getEndPoints(t,i,a,n,!0,!1),o=r.predecessorX,h=r.successorX,l=r.predecessorY,d=r.successorY;return e.PathUtils.moveTo(o,l)+e.PathUtils.lineTo(h,d)},s._calcRectilinearLine=function(t,i,a,r){var o=t.getGantt(),h=n.getDependencyLineArcRadius(o.getCtx()),l=n.getDependencyLineTaskFlankLength(),d=s._getEndPoints(t,i,a,r,!1,!0),g=d.predecessorX,c=d.successorX,_=d.predecessorY,p=d.successorY,u=o.getOptions(),m=n.getDependencyLineTaskGap(u),b=p>=_?s._getTaskBottom(t)+m:s._getTaskTop(t)-m;g=Math.round(g)+.5,c=Math.round(c)+.5,_=Math.round(_)+.5,p=Math.round(p)+.5,b=Math.round(b)+.5;var f=g+(a?1:-1)*l,y=r?c+l:c-l,v=e.PathUtils.moveTo(g,_);return a&&y<f||!a&&y>f?(v+=e.PathUtils.horizontalLineTo(f+(a?-1:1)*h),p>_?(v+=e.PathUtils.arcTo(h,h,Math.PI/2,a?1:0,f,_+h),a&&r||!a&&!r?(v+=e.PathUtils.verticalLineTo(p-h),v+=e.PathUtils.arcTo(h,h,Math.PI/2,a?1:0,f+(a?-1:1)*h,p)):(v+=e.PathUtils.verticalLineTo(b-h),v+=e.PathUtils.arcTo(h,h,Math.PI/2,a?1:0,f+(a?-1:1)*h,b),v+=e.PathUtils.horizontalLineTo(y+(a?1:-1)*h),v+=e.PathUtils.arcTo(h,h,Math.PI/2,a?0:1,y,b+h),v+=e.PathUtils.verticalLineTo(p-h),v+=e.PathUtils.arcTo(h,h,Math.PI/2,a?0:1,y+(a?1:-1)*h,p))):p<_?(v+=e.PathUtils.arcTo(h,h,Math.PI/2,a?0:1,f,_-h),a&&r||!a&&!r?(v+=e.PathUtils.verticalLineTo(p+h),v+=e.PathUtils.arcTo(h,h,Math.PI/2,a?0:1,f+(a?-1:1)*h,p)):(v+=e.PathUtils.verticalLineTo(b+h),v+=e.PathUtils.arcTo(h,h,Math.PI/2,a?0:1,f+(a?-1:1)*h,b),v+=e.PathUtils.horizontalLineTo(y+(a?1:-1)*h),v+=e.PathUtils.arcTo(h,h,Math.PI/2,a?1:0,y,b-h),v+=e.PathUtils.verticalLineTo(p+h),v+=e.PathUtils.arcTo(h,h,Math.PI/2,a?1:0,y+(a?1:-1)*h,p))):(v+=e.PathUtils.arcTo(h,h,Math.PI/2,a?1:0,f,_+h),v+=e.PathUtils.verticalLineTo(b-h),v+=e.PathUtils.arcTo(h,h,Math.PI/2,a?1:0,f+(a?-1:1)*h,b),v+=e.PathUtils.horizontalLineTo(y+(a?1:-1)*h),v+=e.PathUtils.arcTo(h,h,Math.PI/2,a?1:0,y,b-h),v+=e.PathUtils.verticalLineTo(p+h),v+=r?e.PathUtils.arcTo(h,h,Math.PI/2,0,y-h,p):e.PathUtils.arcTo(h,h,Math.PI/2,1,y+h,p))):p>_?(v+=e.PathUtils.horizontalLineTo(y+(a?-1:1)*h),v+=e.PathUtils.arcTo(h,h,Math.PI/2,a?1:0,y,_+h),v+=e.PathUtils.verticalLineTo(p-h),v+=r?e.PathUtils.arcTo(h,h,Math.PI/2,1,y-h,p):e.PathUtils.arcTo(h,h,Math.PI/2,0,y+h,p)):p<_?(v+=e.PathUtils.horizontalLineTo(y+(a?-1:1)*h),v+=e.PathUtils.arcTo(h,h,Math.PI/2,a?0:1,y,_-h),v+=e.PathUtils.verticalLineTo(p+h),v+=r?e.PathUtils.arcTo(h,h,Math.PI/2,0,y-h,p):e.PathUtils.arcTo(h,h,Math.PI/2,1,y+h,p)):(a&&r||!a&&!r)&&(v+=e.PathUtils.horizontalLineTo(f+(a?-1:1)*h),v+=e.PathUtils.arcTo(h,h,Math.PI/2,a?1:0,f,_+h),v+=e.PathUtils.verticalLineTo(b-h),v+=e.PathUtils.arcTo(h,h,Math.PI/2,a?0:1,f+(a?1:-1)*h,b),v+=e.PathUtils.horizontalLineTo(y-h),v+=e.PathUtils.arcTo(h,h,Math.PI/2,a?0:1,y,b-h),v+=e.PathUtils.verticalLineTo(p+h),v+=e.PathUtils.arcTo(h,h,Math.PI/2,a?0:1,y+(a?-1:1)*h,p)),v+=e.PathUtils.lineTo(c,p)},s.prototype.getNextNavigable=function(t){if(t.keyCode===e.KeyboardEvent.UP_ARROW||t.keyCode===e.KeyboardEvent.DOWN_ARROW){var i=this.getKeyboardFocusTask();i||(i=this.getPredecessorNode());var a=this,n=this.getGantt().getEventManager().getKeyboardHandler();if(n&&n.getNextNavigableDependencyLine){var s=i===this.getPredecessorNode()?"successor":"predecessor",r=this.getGantt().getNavigableDependencyLinesForTask(i,s);a=n.getNextNavigableDependencyLine(i,this,t,r)}return a.setKeyboardFocusTask(i),a}return t.keyCode===e.KeyboardEvent.RIGHT_ARROW||t.keyCode===e.KeyboardEvent.LEFT_ARROW?e.Agent.isRightToLeft(this.getGantt().getCtx())?t.keyCode===e.KeyboardEvent.LEFT_ARROW?this.getSuccessorNode():this.getPredecessorNode():t.keyCode===e.KeyboardEvent.RIGHT_ARROW?this.getSuccessorNode():this.getPredecessorNode():t.type===e.MouseEvent.CLICK?this:null},s.prototype.setKeyboardFocusTask=function(t){this._keyboardNavNode=t},s.prototype.getKeyboardFocusTask=function(){return this._keyboardNavNode},s.prototype.getKeyboardBoundingBox=function(t){return this.getDimensions(t)},s.prototype.getTargetElem=function(){return this._content?this._content.getContainerElem():this._line.getElem()},s.prototype.showKeyboardFocusEffect=function(){this.isCustomContent()?(this._renderCustomContent({focused:!0}),this._isShowingKeyboardFocusEffect=!0):this._line&&(e.ToolkitUtils.addClassName(this._line.getElem(),this._gantt.GetStyleClass("focus")),this._line.showHoverEffect(),this._isShowingKeyboardFocusEffect=!0)},s.prototype.hideKeyboardFocusEffect=function(){this.isShowingKeyboardFocusEffect()&&(this.isCustomContent()?this._renderCustomContent({focused:!1}):(this._line.hideHoverEffect(),e.ToolkitUtils.removeClassName(this._line.getElem(),this._gantt.GetStyleClass("focus"))),this._isShowingKeyboardFocusEffect=!1)},s.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},s.prototype.getDatatip=function(t,e,i){return this.getAriaLabel()},s.prototype.getAriaLabel=function(){return this._dependencyObj.ariaLabel};var r=function(t,e){this.Init(t,e)};e.Obj.createSubclass(r,e.Obj),r.prototype.nodeType="rowLabel",r.prototype.Init=function(t,e){this._rowAxis=t,this._gantt=t._gantt,this._contentType=e},r.prototype.render=function(t){var i=t.data;this._labelString=null!=i.label?i.label:"";var a=null!=i.shortDesc?i.shortDesc:"";this._shortDesc="function"==typeof a?a({data:t.data,itemData:t.data._itemData}):a;var n=e.Agent.isRightToLeft(this._gantt.getCtx()),s=this._rowAxis.getAvailableWidth();this._contentBackground||(this._contentBackground=new e.Rect(this._gantt.getCtx(),0,t.y,0,t.height),this._contentBackground.setPixelHinting(!0),this._contentBackground.setClassName(this._gantt.GetStyleClass("row")),this._gantt.getEventManager().associate(this._contentBackground,this,!0)),this._contentBackground.getParent()||this._rowAxis.addLabelBackground(this._contentBackground),this._content||(this._content="custom"===this._contentType?this._getCustomContent(t,s):this._getTextContent(t)),this._contentDisplayable||(this._contentDisplayable=this._gantt.isRowsHierarchical()?this._addExpandCollapseButton(this._content,t):this._content,this._gantt.getEventManager().associate(this._contentDisplayable,this,!0)),this._contentDisplayable.getParent()||this._rowAxis.addLabelContent(this._contentDisplayable);var r=this._contentDisplayable.getDimensions();"g"===this.getDisplayableType()?(this._width=n?-Math.min(0,r.x):r.x+r.w,this._width=Math.max(0,this._width),this._yTopOFfset=r.y):(this._width=Math.min(r.w,s.calculatedWidth),this._yTopOFfset=0),this._height=r.h,this._contentDisplayable.setAriaProperty("label",this.getAriaLabel()),this._contentDisplayable.setAriaProperty("hidden",null)},r.prototype._getCustomContent=function(t,i){var a=t.data,s=new e.Container(this._gantt.getCtx());s.setClassName(this._gantt.GetStyleClass("rowLabel"));var r=a.labelStyle;null!=r&&s.setStyle(r);var o=this._gantt.getOptions(),h=o.rowAxis.label.renderer,l=n.getRowLabelPadding(o),d=this._gantt.getRowAxisMaxWidth();if(-1===i.width&&null!=d&&"none"===d)var g=-1;else g=this._gantt.isRowsHierarchical()?Math.max(0,i.calculatedWidth-this._rowAxis.getLabelContentIndentSize(t))-2*l:Math.max(0,i.calculatedWidth-2*l);var c=t.height,_=s.getContainerElem(),p=h(this.getRendererContext(t,g,c,_));return p&&(Array.isArray(p)?p.forEach(function(t){e.ToolkitUtils.appendChildElem(_,t)}):e.ToolkitUtils.appendChildElem(_,p)),s},r.prototype._getTextContent=function(t){var i=t.data,a=new e.OutputText(this._gantt.getCtx(),this._labelString,0,0);a.setClassName(this._gantt.GetStyleClass("rowLabel"));var n=i.labelStyle;return null!=n&&""!==n&&0!==Object.keys(n).length&&a.setStyle(n),a.setCSSStyle(this._rowAxis._getCSSStyle(n)),a},r.prototype._addExpandCollapseButton=function(t,i){var a=e.Agent.isRightToLeft(this._gantt.getCtx()),s=new e.Container(this._gantt.getCtx()),r=this._rowAxis.getLabelContentIndentSize(i),o=a?-r:r;if(a&&"text"===this._contentType&&(o-=t.getDimensions().w),t.setTranslateX(o),s.addChild(t),this._rowAxis.addLabelContent(s),null!=i.expanded){var h=n.getRowLabelButtonSize(),l=r-(h+n.getRowLabelButtonContentGapSize());l=a?-(l+h):l;var d=(t.getDimensions().h-h)/2,g=this._gantt.getEventManager(),c=this._createExpandCollapseButton(this._gantt.getCtx(),this._gantt.getOptions()._resources,i.expanded?"open":"closed",l,d,h,g.onExpandCollapseButtonClick,g);this._button=c,s.addChild(c)}else this._button=null;return s},r.prototype._createExpandCollapseButton=function(t,i,a,n,s,r,o,h){var l=e.ToolkitUtils.getIconStyle(t,i[a]),d=new e.IconButton(t,"borderless",{style:l,size:r},null,null,o,h);return d.setTranslate(n,s),d.setAriaRole("button"),d.setAriaProperty("label",this.getAriaLabel()),this._gantt.getEventManager().associate(d,this),d},r.prototype.getRendererContext=function(t,e,a,n){var s=this._gantt.getOptions(),r=this._gantt.getDataLayoutManager(),o=t.data,h=o.tasks,l=[],d=s.rowData||s.taskData;if(d)for(var g=0;g<h.length;g++)l.push(h[g]._itemData);var c=r.getParentRowObj(t),_={component:s._widgetConstructor,parentElement:n,rowData:i.TimeComponent.sanitizeData(o,"row"),itemData:d?l:null,maxWidth:e,maxHeight:a,data:s.rowData?o._itemData:null,depth:t.depth,leaf:null==t.expanded,parentKey:c?c.id:null};return this._gantt.getCtx().fixRendererContext(_)},r.prototype.getRow=function(){return this._rowNode},r.prototype.setRow=function(t){this._rowNode=t},r.prototype.getRowIndex=function(){return this._rowIndex},r.prototype.setRowIndex=function(t){this._rowIndex=t},r.prototype.getRowLayoutObject=function(){return this._gantt.getRowLayoutObjs()[this.getRowIndex()]},r.prototype.getDisplayable=function(){return this._contentDisplayable},r.prototype.getBackground=function(){return this._contentBackground},r.prototype.getExpandCollapseButton=function(){return this._button},r.prototype.getLabelString=function(){return this._labelString},r.prototype.getDisplayableType=function(){return this._gantt.isRowsHierarchical()||"custom"===this._contentType?"g":"text"},r.prototype.getContentType=function(){return this._contentType},r.prototype.getX=function(){return"text"===this.getDisplayableType()?this._contentDisplayable.getX():this._contentDisplayable.getTranslateX()},r.prototype.setX=function(t){"text"===this.getDisplayableType()?this._contentDisplayable.setX(t):this._contentDisplayable.setTranslateX(t)},r.prototype.getY=function(){return"text"===this.getDisplayableType()?this._contentDisplayable.getY():this._contentDisplayable.getTranslateY()},r.prototype.setY=function(t){"text"===this.getDisplayableType()?this._contentDisplayable.setY(t):this._contentDisplayable.setTranslateY(t)},r.prototype.getWidth=function(){return this._width},r.prototype.getHeight=function(){return this._height},r.prototype.getYTopOffset=function(){return this._yTopOFfset},r.prototype.getAriaLabel=function(){var t=this._gantt.getOptions().translations,i=[],a=this.getRowLayoutObject();null!=a.expanded&&i.push(t[a.expanded?"stateExpanded":"stateCollapsed"]);var n=this._shortDesc||this.getLabelString();return this._gantt.isRowsHierarchical()&&(n=t.labelLevel+" "+a.depth+", "+n),e.Displayable.generateAriaLabel(n,i)},r.prototype.ensureInDOM=function(){null===this._contentDisplayable.getParent()&&(this._rowAxis.addLabelBackground(this._contentBackground),this._rowAxis.addLabelContent(this._contentDisplayable))},r.prototype.remove=function(){this._rowAxis.removeLabelBackground(this._contentBackground),this._rowAxis.removeLabelContent(this._contentDisplayable)},r.prototype.getNextNavigable=function(t){var i=e.Agent.isRightToLeft(this._gantt.getCtx()),a=this._gantt.getEventManager(),n=this._gantt.getDataLayoutManager(),s=this._gantt.getRowLayoutObjs(),r=this.getRowLayoutObject();if(t.altKey&&(!i&&t.keyCode===e.KeyboardEvent.RIGHT_ARROW||i&&t.keyCode===e.KeyboardEvent.LEFT_ARROW)){if(0===r.taskObjs.length)return this;var o=a.getLastFocusedTask();if(o&&e.Obj.compareValues(this._gantt.getCtx(),o.getLayoutObject().rowObj.id,r.id))return n.ensureInDOM(o.getLayoutObject(),"task"),o;var h=r.taskObjs[0];n.ensureInDOM(h,"task");var l=h.node;return a.setLastFocusedTask(l),l}if(t.keyCode===e.KeyboardEvent.UP_ARROW){var d=s[Math.max(0,r.index-1)];return n.ensureInDOM(d,"row"),d.node.getRowLabelContent()}if(t.keyCode===e.KeyboardEvent.DOWN_ARROW){var g=s[Math.min(s.length-1,r.index+1)];return n.ensureInDOM(g,"row"),g.node.getRowLabelContent()}return this},r.prototype.getTargetElem=function(){return this._contentDisplayable.getElem()},r.prototype.getKeyboardBoundingBox=function(t){return this._contentDisplayable.getDimensions(t)},r.prototype.showKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!0,this.getRowLayoutObject().node.scrollIntoView();var t=this._contentBackground.getElem();e.ToolkitUtils.addClassName(t,this._gantt.GetStyleClass("focusHighlight"))},r.prototype.hideKeyboardFocusEffect=function(){var t=this._contentBackground.getElem();e.ToolkitUtils.removeClassName(t,this._gantt.GetStyleClass("focusHighlight")),this._isShowingKeyboardFocusEffect=!1},r.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},r.prototype.getDatatip=function(){return this._shortDesc};var o=function(t,e,i,a,n,s,r,o,h){this.Init(t,e,i,a,n,s,r,o,h)};e.Obj.createSubclass(o,e.Path),o.MAIN_TYPES=["main","mainBackground","mainSelect","mainHover","mainFocus"],o.MAIN_EFFECT_TYPES=["mainSelect","mainHover","mainFocus"],o.BASELINE_TYPES=["baseline","baselineSelect","baselineHover"],o.BASELINE_EFFECT_TYPES=["baselineSelect","baselineHover"],o.PROGRESS_TYPES=["progress","progressZero","progressFull"],o.prototype.Init=function(t,e,i,a,n,s,r,h,l){var d;switch(this._context=t,this._x=e,this._y=i,this._w=a,this._h=n,this._r=null!=s?s:"0",this._task=r,this._type=h,this._isHighlighted=!1,this._renderState="add",this._typeCmdGeneratorMap={main:this._generateRepShapeCmd,mainBackground:this._generateRepShapeCmd,mainSelect:this._generateRepShapeCmd,mainHover:this._generateRepShapeCmd,mainFocus:this._generateRepShapeCmd,mainDragFeedback:this._generateRepShapeCmd,mainResizeHandleStart:this._generateRectCmd,mainResizeHandleEnd:this._generateRectCmd,mainResizeHandleDragFeedback:this._generateRectCmd,progress:this._generateRectCmd,progressZero:this._generateRectCmd,progressFull:this._generateRectCmd,baseline:this._generateRepShapeCmd,baselineSelect:this._generateRepShapeCmd,baselineHover:this._generateRepShapeCmd,overtime:this._generateRectCmd,downtime:this._generateRectCmd,attribute:this._generateRectCmd},d=this._typeCmdGeneratorMap[this._type].call(this,this._x,this._y,this._w,this._h,this._r),o.superclass.Init.call(this,t,d,l),this.applyDefaultStyleClasses(),this._type){case"mainDragFeedback":case"mainResizeHandleDragFeedback":this.setMouseEnabled(!1);case"mainResizeHandleStart":case"mainResizeHandleEnd":r.getGantt().getEventManager().associate(this,r.getContainer());case"main":case"progress":case"progressZero":case"progressFull":case"baseline":case"overtime":case"downtime":case"attribute":this.setPixelHinting("alta"===t.getThemeBehavior())}},o.prototype._generateRepShapeCmd=function(t,i,a,s,r){var h,l=e.Agent.isRightToLeft(this._context),d=(o.MAIN_EFFECT_TYPES.indexOf(this._type)>-1||o.BASELINE_EFFECT_TYPES.indexOf(this._type)>-1)*n.getTaskEffectMargin();return"alta"!==this._context.getThemeBehavior()&&"mainHover"===this._type&&(d=0),this._task.isMilestone(this._type)&&0===a?(h=d*Math.sqrt(2),this._generateDiamondCmd(t,i-h,s+2*h,r)):this._task.isSummary(this._type)&&"main"===this._type?this._generateSummaryCmd(t,i,a,s,r):this._generateRectCmd(l?t+d:t-d,i-d,a+2*d,s+2*d,r)},o.prototype._generateRectCmd=function(t,i,a,n,s){var r=e.Agent.isRightToLeft(this._context);return"0"===s||"0px"===s?e.PathUtils.moveTo(t,i)+e.PathUtils.horizontalLineTo(r?t-a:t+a)+e.PathUtils.verticalLineTo(i+n)+e.PathUtils.horizontalLineTo(t)+e.PathUtils.closePath():e.PathUtils.rectangleWithBorderRadius(t-r*a,i,a,n,s,Math.min(a,n),"0")},o.prototype._generateSummaryCmd=function(t,i,a,s,r){if("alta"===this._context.getThemeBehavior()){var o=e.Agent.isRightToLeft(this._context),h=n.getSummaryThickness();if("0"===r||"0px"===r)return a>2*h?e.PathUtils.moveTo(t,i+s)+e.PathUtils.verticalLineTo(i)+e.PathUtils.horizontalLineTo(o?t-a:t+a)+e.PathUtils.verticalLineTo(i+s)+e.PathUtils.horizontalLineTo(o?t-a+h:t+a-h)+e.PathUtils.verticalLineTo(i+h)+e.PathUtils.horizontalLineTo(o?t-h:t+h)+e.PathUtils.verticalLineTo(i+s)+e.PathUtils.closePath():this._generateRectCmd(t,i,a,s,r);var l=Math.min(new e.CSSStyle({"border-radius":r}).getBorderRadius(),Math.min(a,s)),d=Math.max(l-h,0);return a>2*h?e.PathUtils.moveTo(t,i+s)+e.PathUtils.verticalLineTo(i+l)+e.PathUtils.arcTo(l,l,Math.PI/2,o?0:1,o?t-l:t+l,i)+e.PathUtils.horizontalLineTo(o?t-a+l:t+a-l)+e.PathUtils.arcTo(l,l,Math.PI/2,o?0:1,o?t-a:t+a,i+l)+e.PathUtils.verticalLineTo(i+s)+e.PathUtils.horizontalLineTo(o?t-a+h:t+a-h)+e.PathUtils.verticalLineTo(i+h+d)+e.PathUtils.arcTo(d,d,Math.PI/2,o?1:0,o?t-a+h+d:t+a-h-d,i+h)+e.PathUtils.horizontalLineTo(o?t-h-d:t+h+d)+e.PathUtils.arcTo(d,d,Math.PI/2,o?1:0,o?t-h:t+h,i+h+d)+e.PathUtils.verticalLineTo(i+s)+e.PathUtils.closePath():e.PathUtils.rectangleWithBorderRadius(t-o*a,i,a,s,l+"px "+l+"px 0px 0px",Math.min(a,s),"0")}return this._generateRectCmd(t,i,a,s,r)},o.prototype._generateDiamondCmd=function(t,i,a,n){var s=a/2;if("0"===n||"0px"===n)return e.PathUtils.moveTo(t,i)+e.PathUtils.lineTo(t+s,i+s)+e.PathUtils.lineTo(t,i+a)+e.PathUtils.lineTo(t-s,i+s)+e.PathUtils.closePath();var r=Math.min(new e.CSSStyle({"border-radius":n}).getBorderRadius(),a/(2*Math.sqrt(2))),o=r/Math.sqrt(2),h=r,l=r;return e.PathUtils.moveTo(t-o,i+o)+e.PathUtils.arcTo(h,l,0,1,t+o,i+o)+e.PathUtils.lineTo(t+s-o,i+s-o)+e.PathUtils.arcTo(h,l,0,1,t+s-o,i+s+o)+e.PathUtils.lineTo(t+o,i+a-o)+e.PathUtils.arcTo(h,l,0,1,t-o,i+a-o)+e.PathUtils.lineTo(t-s+o,i+s+o)+e.PathUtils.arcTo(h,l,0,1,t-s+o,i+s-o)+e.PathUtils.closePath()},o.prototype.applyDefaultStyleClasses=function(){var t,i,a,n,s,r,h=this._task.getGantt(),l=h.getEventManager().IsDragSupported("tasks");o.PROGRESS_TYPES.indexOf(this._type)>-1?(t=h.GetStyleClass("taskProgress"),this._task.isSummary("main")&&(t+=" "+h.GetStyleClass("taskSummaryProgress")),l&&(t+=" "+h.GetStyleClass("draggable")),this.setClassName(t)):o.MAIN_TYPES.indexOf(this._type)>-1?(t=h.GetStyleClass("task"),i=h.GetStyleClass("taskMilestone"),a=h.GetStyleClass("taskBar"),n=h.GetStyleClass("taskSummary"),this._task.isMilestone(this._type)&&0===this._w?t+=" "+i:(t+=" "+(this._task.isSummary(this._type)?n:a),"main"===this._type&&null!=this._task.getProgressValue()&&(t+=" "+h.GetStyleClass("taskUnprogress"))),"mainBackground"===this._type?t=h.GetStyleClass("taskBackdrop"):"mainSelect"===this._type?t+=" "+h.GetStyleClass("selected"):"mainHover"===this._type||"mainFocus"===this._type?(t+=" "+h.GetStyleClass("mainHover"===this._type?"hover":"focus"),"alta"===this._context.getThemeBehavior()&&(r={fill:"none"},null!=(s=this._task.getFillColor())&&(this.setStroke(e.SelectionEffectUtils.createSelectingStroke(s.fill)),r.stroke=s.fill,"none"===s.filter&&(r.filter="none")),this.setStyle(r))):"main"===this._type&&l&&(t+=" "+h.GetStyleClass("draggable")),this.setClassName(t)):o.BASELINE_TYPES.indexOf(this._type)>-1?(t=h.GetStyleClass("baseline"),i=h.GetStyleClass("baselineMilestone"),a=h.GetStyleClass("baselineBar"),this._task.isMilestone(this._type)&&0===this._w?t+=" "+i:t+=" "+a,this.setClassName(t)):"overtime"===this._type?(t=h.GetStyleClass("taskOvertime"),l&&(t+=" "+h.GetStyleClass("draggable")),this.setClassName(t)):"downtime"===this._type?(t=h.GetStyleClass("taskDowntime"),l&&(t+=" "+h.GetStyleClass("draggable")),this.setClassName(t)):"attribute"===this._type?(t=h.GetStyleClass("taskAttribute"),l&&(t+=" "+h.GetStyleClass("draggable")),this.setClassName(t)):"mainDragFeedback"===this._type||"mainResizeHandleDragFeedback"===this._type?(t=h.GetStyleClass("taskDragImage"),this.setClassName(t)):"mainResizeHandleStart"!==this._type&&"mainResizeHandleEnd"!==this._type||(t=h.GetStyleClass("taskResizeHandle"),this.setClassName(t+" "+this._task.getGantt().GetStyleClass("draggable")))},o.prototype.highlight=function(){e.ToolkitUtils.addClassName(this.getElem(),this._task.getGantt().GetStyleClass("taskHighlight")),this._isHighlighted=!0},o.prototype.unhighlight=function(){e.ToolkitUtils.removeClassName(this.getElem(),this._task.getGantt().GetStyleClass("taskHighlight")),this._isHighlighted=!1},o.prototype.isHighlighted=function(){return this._isHighlighted},o.prototype.getFillColor=function(){var t,i,a,s,r,o,h,l;t=(t=null!=(t=this.getElem()).firstChild?t.firstChild:t).cloneNode(!1),(i=this._task.getGantt().getCtx().getSvgDocument()).appendChild(t);try{if(s=(a=window.getComputedStyle(t)).fill,l=Number(a.fillOpacity),o=a.filter,!(String.prototype.startsWith?s.startsWith("url("):0===s.indexOf("url("))){switch(o){case"url("+JSON.stringify("#"+n.getTaskTintFilterId())+")":case"url(#"+n.getTaskTintFilterId()+")":r=e.ColorUtils.getBrighter(s,n.getTaskTintAlpha());break;case"url("+JSON.stringify("#"+n.getTaskShadeFilterId())+")":case"url(#"+n.getTaskShadeFilterId()+")":r=e.ColorUtils.getDarker(s,n.getTaskShadeAlpha());break;default:r=s}1===l||Number.isNaN(l)||(r=e.ColorUtils.getBrighter(r,1-l)),h={fill:s,computedFill:r,filter:o,stroke:a.stroke}}}finally{i.removeChild(t)}return h},o.prototype.getType=function(){return this._type},o.prototype.setType=function(t){this._type=t},o.prototype.getTask=function(){return this._task},o.prototype.getPhysicalStartOffset=function(){return(o.MAIN_TYPES.indexOf(this._type)>-1||o.BASELINE_TYPES.indexOf(this._type)>-1)&&this._task.isMilestone(this._type)?this._finalHeight/2:0},o.prototype.getPhysicalEndOffset=function(){return(o.MAIN_TYPES.indexOf(this._type)>-1||o.BASELINE_TYPES.indexOf(this._type)>-1)&&this._task.isMilestone(this._type)?this._finalHeight/2:0},o.prototype.getType=function(){return this._type},o.prototype.getRenderState=function(){return this._renderState},o.prototype.setRenderState=function(t){this._renderState=t},o.prototype.getWidth=function(){return this._w},o.prototype.getFinalWidth=function(){return this._finalWidth},o.prototype.setWidth=function(t){var e;!(o.MAIN_TYPES.indexOf(this._type)>-1||o.BASELINE_TYPES.indexOf(this._type)>-1)||0!==this._w&&0!==t||(this._w=t,this.applyDefaultStyleClasses()),this._w=t,e=this._typeCmdGeneratorMap[this._type].call(this,this._x,this._y,this._w,this._h,this._r),this.setCmds(e)},o.prototype.setFinalWidth=function(t){this._finalWidth=t},o.prototype.getHeight=function(){return this._h},o.prototype.getFinalHeight=function(){return this._finalHeight},o.prototype.setHeight=function(t){var e;this._h=t,e=this._typeCmdGeneratorMap[this._type].call(this,this._x,this._y,this._w,this._h,this._r),this.setCmds(e)},o.prototype.setFinalHeight=function(t){this._finalHeight=t},o.prototype.getX=function(){return this._x},o.prototype.getFinalX=function(){return this._finalX},o.prototype.setX=function(t){var e;this._x=t,e=this._typeCmdGeneratorMap[this._type].call(this,this._x,this._y,this._w,this._h,this._r),this.setCmds(e)},o.prototype.setFinalX=function(t){this._finalX=t},o.prototype.getY=function(){return this._y},o.prototype.getFinalY=function(){return this._finalY},o.prototype.setY=function(t){var e;this._y=t,e=this._typeCmdGeneratorMap[this._type].call(this,this._x,this._y,this._w,this._h,this._r),this.setCmds(e)},o.prototype.setFinalY=function(t){this._finalY=t},o.prototype.getBorderRadius=function(){return this._r},o.prototype.setBorderRadius=function(t){var e;this._r=null!=t?t:"0",e=this._typeCmdGeneratorMap[this._type].call(this,this._x,this._y,this._w,this._h,this._r),this.setCmds(e)},o.prototype.setDimensions=function(t,e,i,a,n){var s;!(o.MAIN_TYPES.indexOf(this._type)>-1||o.BASELINE_TYPES.indexOf(this._type)>-1)||0!==this._w&&0!==i||(this._w=i,this.applyDefaultStyleClasses()),this._x=t,this._y=e,this._w=i,this._h=a,this._r=null!=n?n:"0",s=this._typeCmdGeneratorMap[this._type].call(this,this._x,this._y,this._w,this._h,this._r),this.setCmds(s)};var h=new Object;e.Obj.createSubclass(h,e.Obj),h.getDatatipColor=function(t){var e=t.getCtx(),i=t.getTask().getFillColor();return i?"alta"===e.getThemeBehavior()?i.fill:i.stroke:null},h.getDatatip=function(t,i,a){var n=t.getGantt();if(n.getEventManager().isKeyboardDnDScaleChanged()){var s=n.getEventManager().getKeyboardDnDNavigationScale(),r="move"===n.getEventManager().getKeyboardDnDMode()?"MoveBy":"ResizeBy",o=h._addDatatipRow("",n,"",r,s.charAt(0).toUpperCase()+s.slice(1),i);return h._processDatatip(o,n,i)}var l=n.getOptions().tooltip,d=l?l.renderer:null;if(i&&d){var g=n.getCtx().getTooltipManager(),c=n.getEventManager().isDnDDragging()?t.getSandboxDataContext():t.getDataContext();return g.getCustomTooltip(d,c)}var _=t.getValue("shortDesc");if(null!=_)return _;if(a&&!n.getCtx().isCustomElement()){var p=n.getOptions().valueFormats;if(!p||0===p.length){var u=t.getTask(),m=t.getValue("start"),b=t.getValue("end"),f=t.getValue("baseline","start"),y=t.getValue("baseline","end"),v=u.getProgressValue(),S=n.getOptions(),T=S.translations,D=u.isMilestone("main"),C=u.isMilestone("baseline"),E=!(null==m&&null==b),O=!(null==f&&null==y);if(E)if(D)var k=n.getTimeAxis().formatDate(new Date(null!=m?m:b),null,"general"),w=e.ResourceUtils.format(T.accessibleMilestoneInfo,[k]);else{var A=n.getTimeAxis().formatDate(new Date(m),null,"general"),R=n.getTimeAxis().formatDate(new Date(b),null,"general"),x=t.getDuration(m,b);w=e.ResourceUtils.format(T.accessibleTaskInfo,[A,R,x])}if(O)if(C)var L=n.getTimeAxis().formatDate(new Date(null!=f?f:y),null,"general"),P=T.labelBaselineDate+": "+L;else{var M=n.getTimeAxis().formatDate(new Date(f),null,"general"),j=n.getTimeAxis().formatDate(new Date(y),null,"general");P=(P=T.labelBaselineStart+": "+M)+"; "+T.labelBaselineEnd+": "+j}if(E){var I=t.getValue("label");if(null!=I)var F=T.labelLabel+": "+I;if(null!=v){var N=S._resources;if(N){var H=N.percentConverter;if(H){var B=H.format(v);if(null!=B)var U=T.labelProgress+": "+B}}}}var Y=t.getRowNode(),V=Y.getLabel();null==V&&(V=Y.getIndex()+1);var G=e.ResourceUtils.format(T.accessibleRowInfo,[V]);return w&&(G=G+"; "+w),P&&(G=G+"; "+P),F&&(G=G+"; "+F),U&&(G=G+"; "+U),G}}var z="";return z=h._addRowDatatip(z,t,i),z=h._addTaskDatatip(z,t,i),h._processDatatip(z,n,i)},h._processDatatip=function(t,e,i){return""===t?null:i?'<table class="'+e.GetStyleClass("tooltipTable")+'">'+t+"</table>":t},h._addRowDatatip=function(t,e,i){var a=e.getGantt();if(a.getEventManager().isDnDDragging())var n=e.getSandboxValue("_rowNode");else n=e.getRowNode();var s=n.getLabel();return null==s&&(s=n.getIndex()+1),h._addDatatipRow(t,a,"row","Row",s,i)},h._addTaskDatatip=function(t,e,i){var a=e.getGantt(),n=a.getEventManager().isDnDDragging()?e.getSandboxValue:e.getValue,s=e.getTask(),r=n.call(e,"start"),o=n.call(e,"end"),l=n.call(e,"overtime","start"),d=n.call(e,"overtime","end"),g=n.call(e,"downtime","start"),c=n.call(e,"downtime","end"),_="on"===n.call(e,"attribute","rendered")?n.call(e,"attribute","shortDesc"):null,p=n.call(e,"baseline","start"),u=n.call(e,"baseline","end"),m=n.call(e,"label"),b=s.getProgressValue(),f=!(null==r&&null==o),y=!(null==p&&null==u),v=!(null==l&&null==d),S=!(null==g&&null==c),T=null!=_,D=s.isMilestone("main"),C=s.isMilestone("baseline");return f?(D?(t=h._addDatatipRow(t,a,"date","Date",null!=r?r:o,i),C?t=h._addDatatipRow(t,a,"baselineDate","BaselineDate",null!=p?p:u,i):y&&(t=h._addDatatipRow(t,a,"baselineStart","BaselineStart",p,i),t=h._addDatatipRow(t,a,"baselineEnd","BaselineEnd",u,i))):C?(t=h._addDatatipRow(t,a,"start","Start",r,i),t=h._addDatatipRow(t,a,"end","End",o,i),t=h._addDatatipRow(t,a,"baselineDate","BaselineDate",null!=p?p:u,i)):y?(t=h._addDatatipRow(t,a,"start","Start",r,i),t=h._addDatatipRow(t,a,"baselineStart","BaselineStart",p,i),t=h._addDatatipRow(t,a,"end","End",o,i),t=h._addDatatipRow(t,a,"baselineEnd","BaselineEnd",u,i)):(t=h._addDatatipRow(t,a,"start","Start",r,i),t=h._addDatatipRow(t,a,"end","End",o,i)),v&&(t=h._addDatatipRow(t,a,"overtimeStart","OvertimeStart",l,i),t=h._addDatatipRow(t,a,"overtimeEnd","OvertimeEnd",d,i)),S&&(t=h._addDatatipRow(t,a,"downtimeStart","DowntimeStart",g,i),t=h._addDatatipRow(t,a,"downtimeEnd","DowntimeEnd",c,i)),T&&(t=h._addDatatipRow(t,a,"attribute","Attribute",_,i)),t=h._addDatatipRow(t,a,"label","Label",m,i),null!=b&&(t=h._addDatatipRow(t,a,"progress","Progress",b,i))):y&&(t=h._addDatatipRow(t,a,"baselineStart","BaselineStart",p,i),t=h._addDatatipRow(t,a,"baselineEnd","BaselineEnd",u,i)),t},h._addDatatipRow=function(t,i,a,n,s,r,o){if(null==s||""===s)return t;var l,d=h.getValueFormat(i,a);return"off"===d.tooltipDisplay?t:("string"==typeof d.tooltipLabel&&(l=d.tooltipLabel),null==l&&(l=null==n?"":i.getOptions().translations["label"+n]),s=h.formatValue(i,a,d,s),r?t+'<tr><td class="'+i.GetStyleClass("tooltipLabel")+'">'+l+'</td><td class="'+i.GetStyleClass("tooltipValue")+'">'+s+"</td></tr>":(t.length>0&&(t+="<br>"),t+e.ResourceUtils.format(i.getOptions().translations.labelAndValue,[l,s])))},h.getValueFormat=function(t,e){var i=t.getOptions().valueFormats;if(!i)return{};if(i instanceof Array){for(var a={},n=0;n<i.length;n++){var s=i[n];a[s.type]=s}t.getOptions().valueFormats=a,i=a}return i[e]?i[e]:{}},h.formatValue=function(t,e,i,a){var n=i.converter;if("start"===e||"end"===e||"date"===e||"baselineStart"===e||"baselineEnd"===e||"baselineDate"===e||"overtimeStart"===e||"overtimeEnd"===e||"downtimeStart"===e||"downtimeEnd"===e)return t.getTimeAxis().formatDate(new Date(a),n,"general");if(n&&n.format)return n.format(a);if("progress"===e){var s=t.getOptions()._resources;if(s){var r=s.percentConverter;if(r)return r.format(a)}}return a};var l=function(t){l.superclass.Init.call(this,t),this._gantt=this._comp};e.Obj.createSubclass(l,i.TimeComponentEventManager),l.prototype.getFocus=function(){var t=l.superclass.getFocus.call(this);if(t&&"task"===t.nodeType&&null==t.getRowNode().getParent()){for(var e=t.getLayoutObject(),i=e.rowObj,a=this._gantt.getDataLayoutManager();null==e||!a.isRoot(i)&&a.isHiddenCollapsed(i);){var n=(i=a.getParentRowObj(i)).taskObjs;e=n.length>0?n[0]:null}return e?e.node:null}return t},l.prototype.setFocus=function(t){l.superclass.setFocus.call(this,t);var e=this.getFocus();e&&"task"===e.nodeType&&(this._lastFocusedTask=e)},l.prototype.getLastFocusedTask=function(){return this._lastFocusedTask},l.prototype.setLastFocusedTask=function(t){this._lastFocusedTask=t},l.prototype.hideTooltip=function(){this._preventHideTooltip||l.superclass.hideTooltip.call(this),this._preventHideTooltip=!1},l.MOVE_TASKS_DATA_TYPE="text/_dvtdndmovetasks",l.RESIZE_TASKS_DATA_TYPE="text/_dvtdndresizetasks",l._HIGH_LEVEL_DND_NAVIGATION_SCALES=["milliseconds","seconds","minutes","hours","days","weeks","months","quarters","years"],l.KEYBOARD_MOVE="move",l.KEYBOARD_RESIZE_START="resizeStart",l.KEYBOARD_RESIZE_END="resizeEnd",l.prototype.ProcessMarqueeEvent=function(t){if(this._gantt.isMarqueeSelectEnabled()){var i=this.getSelectionHandler();if("start"===t.subtype)this._initSelection=t.ctrlKey?i.getSelectedIds():[],this._initSelectionTargets=t.ctrlKey?i.getSelection():[];else if("move"===t.subtype){var a=this._gantt.getMarqueeArtifactsContainer().stageToLocal(t._relPos);this._gantt.autoPanOnEdgeDrag(a,n.getAutoPanEdgeThreshold(),!1,!1);var s=this._gantt.getDataLayoutManager().getLayoutObjectsInBBox(new e.Rectangle(t.x,t.y,t.w,t.h)).taskObjs.map(function(t){return t.node});i.processInitialSelections(this._initSelection,this._initSelectionTargets),i.processGroupSelection(s,!0)}else"end"===t.subtype&&this.fireSelectionEvent()}},l.prototype.isDndSupported=function(){return!0},l.prototype.isDnDDragging=function(){return this._isDndDragging},l.prototype._dragStartSetup=function(){this._dragInitialX=this._gantt.getTimeZoomCanvas().getTranslateX(),this._dragInitialY=this._gantt.getDatabody().getTranslateY(),this._dragInitialViewportStart=this._gantt.getViewportStartTime(),this._dragInitialViewportEnd=this._gantt.getViewportEndTime(),this._gantt.getReferenceLinesContainer().setMouseEnabled(!1),this._gantt.getReferenceAreasContainer().setMouseEnabled(!1),this._gantt.getDependenciesContainer()&&this._gantt.getDependenciesContainer().setMouseEnabled(!1),"highlightDependencies"===this._gantt.getOptions().selectionBehavior&&this._gantt.undimDatabody()},l.prototype._dragCancelCleanup=function(){if(this._dragInitialX){var t=this._gantt.getTimeZoomCanvas().getTranslateX()-this._dragInitialX,e=this._gantt.getDatabody().getTranslateY()-this._dragInitialY;0===t&&0===e||(this._gantt.panBy(t,e,!0),this._gantt.setViewportStartTime(this._dragInitialViewportStart),this._gantt.setViewportEndTime(this._dragInitialViewportEnd))}this._dragInitialX=null,this._dragInitialY=null,this._dragInitialViewportStart=null,this._dragInitialViewportEnd=null,this._gantt.getReferenceLinesContainer().setMouseEnabled(!0),this._gantt.getReferenceAreasContainer().setMouseEnabled(!0),this._gantt.getDependenciesContainer()&&this._gantt.getDependenciesContainer().setMouseEnabled(!0);var i=this.DragSource.getDragObject();i&&"task"===i.nodeType&&i.dragCancelCleanup()},l.prototype._dropCleanup=function(){null==this._dragInitialViewportStart||this._dragInitialViewportStart===this._gantt.getViewportStartTime()&&this._dragInitialViewportEnd===this._gantt.getViewportEndTime()||this._gantt.dispatchEvent(this._gantt.createViewportChangeEvent()),this._dragInitialX=null,this._dragInitialY=null,this._dragInitialViewportStart=null,this._dragInitialViewportEnd=null,this._gantt.getReferenceLinesContainer().setMouseEnabled(!0),this._gantt.getReferenceAreasContainer().setMouseEnabled(!0),this._gantt.getDependenciesContainer()&&this._gantt.getDependenciesContainer().setMouseEnabled(!0),this._isDndDragging=!1},l.prototype.getKeyboardDnDMode=function(){return this._keyboardDnDMode},l.prototype._handleKeyboardDnDInitiation=function(t,i,a,n,s){var r=e.Agent.isRightToLeft(this._gantt.getCtx())?-1:1;this._isDndDragging=!0,this._dragStartSetup();var o=i.getTask().getShape("main");this._gantt.registerAndConstructGlassPane();var h=this._gantt.installGlassPane();this._keyboardDnDScaleRampIndex=l._HIGH_LEVEL_DND_NAVIGATION_SCALES.indexOf(this._gantt.getTimeAxis().getScale()),i.setDraggedObject(a),i.dragStartSetup();var d=i.localToStage({x:o.getFinalX()+("end"===n)*r*o.getFinalWidth(),y:o.getFinalY()});this._keyboardDnDFeedbackLocalPos=this._gantt.getDnDArtifactsContainer().stageToLocal(d),i.showDragFeedback(t,this._keyboardDnDFeedbackLocalPos,i.getRowNode(),{x:0,y:0},!0),h&&(this._preventHideTooltip=!0),this._keyboardDnDSourceObj=i,this._keyboardDnDTargetObj=i.getRowNode();var g=i.getValue("start"),c=i.getValue("end"),_=i.getValue("baseline","start")||null,p=i.getValue("baseline","end")||null;this._keyboardDnDFeedbackTime={start:g,end:c,baselineStart:_,baselineEnd:p};var u=this._gantt.getOptions().translations,m=u[s.initiated];if(this._gantt.isSelectionSupported()&&this._keyboardDnDSourceObj.isSelected()){var b=this._gantt.getSelectionHandler().getSelectedCount();b>1&&(m+=". "+e.ResourceUtils.format(u[s.selectionInfo],[b-1]))}m+=". "+u[s.instruction]+".",this._gantt.updateLiveRegionText(m)},l.prototype.handleKeyboardMoveInitiation=function(t,e){this._keyboardDnDMode=l.KEYBOARD_MOVE;var i=e.getTask().getShape("main");this._handleKeyboardDnDInitiation(t,e,i,"start",{initiated:"taskMoveInitiated",selectionInfo:"taskMoveSelectionInfo",instruction:"taskMoveInitiatedInstruction"})},l.prototype.handleKeyboardResizeStartInitiation=function(t,e){this._keyboardDnDMode=l.KEYBOARD_RESIZE_START;var i=e.getTask().getShape("mainResizeHandleStart");this._handleKeyboardDnDInitiation(t,e,i,"start",{initiated:"taskResizeStartInitiated",selectionInfo:"taskResizeSelectionInfo",instruction:"taskResizeInitiatedInstruction"})},l.prototype.handleKeyboardResizeEndInitiation=function(t,e){this._keyboardDnDMode=l.KEYBOARD_RESIZE_END;var i=e.getTask().getShape("mainResizeHandleEnd");this._handleKeyboardDnDInitiation(t,e,i,"end",{initiated:"taskResizeEndInitiated",selectionInfo:"taskResizeSelectionInfo",instruction:"taskResizeInitiatedInstruction"})},l.prototype._handleKeyboardDnDChronologically=function(t,i){var n,s,r=e.Agent.isRightToLeft(this._gantt.getCtx()),o=this.getKeyboardDnDNavigationScale(),d=this._gantt.getStartTime(),g=this._gantt.getEndTime(),c=this._gantt.getContentLength(),_=this._gantt.getTimeAxis(),p="forward"===i?"next":"previous",u=_.getAdjacentDate(this._keyboardDnDFeedbackTime.start,o,p).getTime(),m=_.getAdjacentDate(this._keyboardDnDFeedbackTime.end,o,p).getTime(),b="auto";switch(this._keyboardDnDMode){case l.KEYBOARD_MOVE:("forward"===i&&u<=g||"backward"===i&&m>=d)&&(s=a.TimeAxisUtils.getDatePosition(d,g,this._keyboardDnDFeedbackTime.start,c),this._keyboardDnDFeedbackTime.start=u,this._keyboardDnDFeedbackTime.end=m,this._keyboardDnDFeedbackTime.baselineStart&&(this._keyboardDnDFeedbackTime.baselineStart=_.getAdjacentDate(this._keyboardDnDFeedbackTime.baselineStart,o,p).getTime(),this._keyboardDnDFeedbackTime.baselineEnd=_.getAdjacentDate(this._keyboardDnDFeedbackTime.baselineEnd,o,p).getTime()),n=a.TimeAxisUtils.getDatePosition(d,g,this._keyboardDnDFeedbackTime.start,c));break;case l.KEYBOARD_RESIZE_START:var f=this._keyboardDnDSourceObj.getValue("end");("forward"===i&&u<=f||"backward"===i&&u>=d)&&(s=a.TimeAxisUtils.getDatePosition(d,g,this._keyboardDnDFeedbackTime.start,c),this._keyboardDnDFeedbackTime.start=u,n=a.TimeAxisUtils.getDatePosition(d,g,this._keyboardDnDFeedbackTime.start,c)),b="start";break;case l.KEYBOARD_RESIZE_END:var y=this._keyboardDnDSourceObj.getValue("start");("forward"===i&&m<=g||"backward"===i&&m>=y)&&(s=a.TimeAxisUtils.getDatePosition(d,g,this._keyboardDnDFeedbackTime.end,c),this._keyboardDnDFeedbackTime.end=m,n=a.TimeAxisUtils.getDatePosition(d,g,this._keyboardDnDFeedbackTime.end,c)),b="end"}null!=n&&(n=r?c-n:n,s=r?c-s:s,this._keyboardDnDFeedbackLocalPos.x+=n-s),this._keyboardDnDSourceObj.showDragFeedback(t,this._keyboardDnDFeedbackLocalPos,this._keyboardDnDTargetObj,{x:0,y:0},!0),this._keyboardDnDSourceObj.scrollIntoView(b,"auto"),this._gantt.updateLiveRegionText(e.AriaUtils.processAriaLabel(h.getDatatip(this._keyboardDnDSourceObj,!1)))},l.prototype.handleKeyboardDnDForward=function(t){this._handleKeyboardDnDChronologically(t,"forward")},l.prototype.handleKeyboardDnDBackward=function(t){this._handleKeyboardDnDChronologically(t,"backward")},l.prototype._handleKeyboardDnDScaleChange=function(t,i){this._isKeyboardDnDScaleChanged=!0,this._keyboardDnDScaleRampIndex=Math.max(0,Math.min(this._keyboardDnDScaleRampIndex+i,l._HIGH_LEVEL_DND_NAVIGATION_SCALES.length-1)),this._keyboardDnDSourceObj.showDragFeedback(t,this._keyboardDnDFeedbackLocalPos,this._keyboardDnDTargetObj,{x:0,y:0},!0),this._gantt.updateLiveRegionText(e.AriaUtils.processAriaLabel(h.getDatatip(this._keyboardDnDSourceObj,!1))),this._isKeyboardDnDScaleChanged=!1},l.prototype.isKeyboardDnDScaleChanged=function(){return this._isKeyboardDnDScaleChanged},l.prototype.getKeyboardDnDNavigationScale=function(){return l._HIGH_LEVEL_DND_NAVIGATION_SCALES[this._keyboardDnDScaleRampIndex]},l.prototype.handleKeyboardDnDScaleUp=function(t){this._handleKeyboardDnDScaleChange(t,1)},l.prototype.handleKeyboardDnDScaleDown=function(t){this._handleKeyboardDnDScaleChange(t,-1)},l.prototype._handleKeyboardMoveRowDirection=function(t,i){var a=this._gantt.getRowLayoutObjs(),s=this._keyboardDnDTargetObj.getIndex();if("above"===i&&s>0)var r=a[s-1];else"below"===i&&s<a.length-1&&(r=a[s+1]);if(r){this._gantt.getDataLayoutManager().ensureInDOM(r,"row"),this._keyboardDnDTargetObj=r.node;var o=this._gantt.getOptions(),l=this._keyboardDnDTargetObj.localToStage({x:0,y:this._keyboardDnDTargetObj.getFinalY()+n.getRowPaddingTop(o)});this._keyboardDnDFeedbackLocalPos.y=this._gantt.getDnDArtifactsContainer().stageToLocal(l).y}this._keyboardDnDSourceObj.showDragFeedback(t,this._keyboardDnDFeedbackLocalPos,this._keyboardDnDTargetObj,{x:0,y:0},!0),this._keyboardDnDSourceObj.scrollIntoView("auto","below"===i?"bottom":"top"),this._gantt.updateLiveRegionText(e.AriaUtils.processAriaLabel(h.getDatatip(this._keyboardDnDSourceObj,!1)))},l.prototype.handleKeyboardMoveRowAbove=function(t){this._handleKeyboardMoveRowDirection(t,"above")},l.prototype.handleKeyboardMoveRowBelow=function(t){this._handleKeyboardMoveRowDirection(t,"below")},l.prototype.handleKeyboardDnDFinalize=function(t){var i,a,n,s,r,o;this._dropCleanup();var h=this._gantt.getOptions().translations;if(this._keyboardDnDMode===l.KEYBOARD_MOVE){i=this._getDragDataContexts(this._keyboardDnDSourceObj),a=new Date(this._keyboardDnDFeedbackTime.start).toISOString(),n=new Date(this._keyboardDnDFeedbackTime.end).toISOString();var d=null==this._keyboardDnDFeedbackTime.baselineStart?null:new Date(this._keyboardDnDFeedbackTime.baselineStart).toISOString(),g=null==this._keyboardDnDFeedbackTime.baselineEnd?null:new Date(this._keyboardDnDFeedbackTime.baselineEnd).toISOString();s=a;var c=this._keyboardDnDTargetObj.getDataContext();r=e.EventFactory.newGanttMoveEvent(i,s,a,n,d,g,c),o=h.taskMoveFinalized}else if(this._keyboardDnDMode===l.KEYBOARD_RESIZE_END||this._keyboardDnDMode===l.KEYBOARD_RESIZE_START){var _;i=this._getDragDataContexts(this._keyboardDnDSourceObj).map(function(t){return t.dataContext}),a=new Date(this._keyboardDnDFeedbackTime.start).toISOString(),n=new Date(this._keyboardDnDFeedbackTime.end).toISOString(),this._keyboardDnDMode===l.KEYBOARD_RESIZE_END?(s=n,_="end"):this._keyboardDnDMode===l.KEYBOARD_RESIZE_START&&(s=a,_="start"),r=e.EventFactory.newGanttResizeEvent(i,s,a,n,_),o=h.taskResizeFinalized}r&&(this._gantt.dispatchEvent(r),this._gantt.updateLiveRegionText(o)),this._keyboardDnDCleanup()},l.prototype.handleKeyboardDnDCancel=function(){var t=this._gantt.getOptions().translations;this._keyboardDnDMode===l.KEYBOARD_MOVE?this._gantt.updateLiveRegionText(t.taskMoveCancelled):this._keyboardDnDMode!==l.KEYBOARD_RESIZE_END&&this._keyboardDnDMode!==l.KEYBOARD_RESIZE_START||this._gantt.updateLiveRegionText(t.taskResizeCancelled),this._dragCancelCleanup(),this._keyboardDnDCleanup()},l.prototype._keyboardDnDCleanup=function(){null!=this._keyboardDnDMode&&(this._keyboardDnDSourceObj.dragEndCleanup(),this._keyboardDnDMode=null,this._isDndDragging=!1,this._keyboardDnDSourceObj=null,this._keyboardDnDTargetObj=null,this._keyboardDnDFeedbackTime=null,this._keyboardDnDScaleRampIndex=null,this._gantt.unregisterAndDestroyGlassPane())},l.prototype.getDnDTaskSubType=function(t){if(t instanceof o){var e=t.getType();if("main"===e||"progress"===e)return"tasks";if("mainResizeHandleStart"===e||"mainResizeHandleEnd"===e)return"taskResizeHandles";if("baseline"===e)return null}return"tasks"},l.prototype.GetDragSourceType=function(t){switch(this._keyboardDnDMode){case l.KEYBOARD_MOVE:return this.IsDragSupported("tasks")?"tasks":null;case l.KEYBOARD_RESIZE_END:case l.KEYBOARD_RESIZE_START:return this.IsDragSupported("taskResizeHandles")?"taskResizeHandles":null}var i=this.DragSource.getDragObject();if(i&&"task"===i.nodeType){if(t&&"dragstart"===t.getNativeEvent().type){var a=t.getNativeEvent(),n=a.clientX,s=a.clientY,r=a.offsetX,o=a.offsetY;if(null==n&&null==s||("ie"===e.Agent.browser||"edge"===e.Agent.browser)&&isNaN(r)&&isNaN(o)){var h=t.target?t.target:i.getTask().getShape("main");i.setDraggedObject(h)}}var d=this.getDnDTaskSubType(i.getDraggedObject());return this.IsDragSupported(d)?d:null}return null},l.prototype._getDragDataContexts=function(t,i){if(t&&"task"===t.nodeType){var a=t.getDraggedObject(),n=a.getType?a.getType():null;if(null!=this.getDnDTaskSubType(a)){var s=function(t){var a=t.getDataContext();switch(i&&e.ToolkitUtils.cleanDragDataContext(a),n){case"mainResizeHandleStart":return{dataContext:a,type:"start"};case"mainResizeHandleEnd":return{dataContext:a,type:"end"}}return a},r=[s(t)];if(this._gantt.isSelectionSupported()&&t.isSelected()&&this._gantt.getSelectionHandler().getSelectedCount()>1)for(var o=this._gantt.getSelectionHandler().getSelection(),h=0;h<o.length;h++){var l=o[h];l&&"task"===l.nodeType&&l!==t&&r.push(s(l))}return r}}return null},l.prototype.GetDragDataContexts=function(t){var e=this.DragSource.getDragObject();return this._getDragDataContexts(e,t)},l.prototype.GetDropOffset=function(t){var i=this.DragSource.getDragObject();if(i&&"task"===i.nodeType&&"tasks"===this.getDnDTaskSubType(i.getDraggedObject())){var a=i.getValue("start"),n=i.getValue("end"),s=i.getTask().getTimeSpanDimensions(a,n),r=this._context.pageToStageCoords(t.pageX,t.pageY),o=this._gantt.getDnDArtifactsContainer().stageToLocal(r);return new e.Point(s.startPos-o.x,i.getFinalY()-o.y)}return new e.Point(0,0)},l.prototype._getDropObject=function(t){if(t){var e=this.GetLogicalObject(t.target),i=this._gantt.getOptions().dnd,a=this._gantt.isTaskMoveEnabled()||this._gantt.isTaskResizeEnabled(),n=i.drop.tasks&&(i.drop.tasks.dataTypes||i.drop.tasks.drop);e&&"task"===e.nodeType&&a&&!n?this._dropObj=e.getRowNode():this._dropObj=e}return this._dropObj},l.prototype.GetDropTargetType=function(t){var e=this._getDropObject(t);return null==e?null:"row"===e.nodeType?"rows":"task"===e.nodeType?"tasks":null},l.prototype.GetDropEventPayload=function(t){var i=t.getNativeEvent().dataTransfer,n=Number(i.getData(e.EventManager.DROP_OFFSET_X_DATA_TYPE))||0,s=e.Agent.isRightToLeft(this._gantt.getCtx()),r=this._getDropObject(t);if(null==r)return null;if("row"===r.nodeType||"task"===r.nodeType){var o=this._context.pageToStageCoords(t.pageX,t.pageY),h=this._gantt.getTimeZoomCanvas().stageToLocal(o),l=this._gantt.getStartTime(),d=this._gantt.getEndTime(),g=this._gantt.getContentLength(),c={value:new Date(a.TimeAxisUtils.getPositionDate(l,d,s?g-h.x:h.x,g)).toISOString(),start:null,end:null,baselineStart:null,baselineEnd:null,dataContext:r.getDataContext()},_=this.DragSource.getDragObject();if(_&&"task"===_.nodeType){var p=_.getValue("start"),u=_.getValue("end"),m=_.getValue("baseline","start")||null,b=_.getValue("baseline","end")||null,f=_.getDraggedObject(),y=this.getDnDTaskSubType(f);if("tasks"===y)c.start=a.TimeAxisUtils.getPositionDate(l,d,s?g-(h.x+n):h.x+n,g),c.end=c.start+(u-p),null==m&&null==b||(c.baselineStart=new Date(m-p+c.start).toISOString(),c.baselineEnd=new Date(b-u+c.end).toISOString()),c.start=new Date(c.start).toISOString(),c.end=new Date(c.end).toISOString();else if("taskResizeHandles"===y){"mainResizeHandleEnd"===(f.getType?f.getType():null)?(c.start=new Date(p).toISOString(),c.end=new Date(c.value).getTime()-p<0?p:c.value):(c.start=u-new Date(c.value).getTime()<0?u:c.value,c.end=new Date(u).toISOString())}}return c}return null},l.prototype.ShowDropEffect=function(t){var i=this._getDropObject(t);if(this._gantt.isTaskResizeEnabled()){var n=this.DragSource.getDragObject();if(n&&"task"===n.nodeType){var s=n.getDraggedObject();if("taskResizeHandles"===this.getDnDTaskSubType(s))return}}if(i&&"row"===i.nodeType){if("firefox"===e.Agent.browser||a.TimeAxisUtils.supportsTouch())for(var r=this._gantt.getRowLayoutObjs(),o=this._gantt.getViewportYBounds(),h=(this._gantt.getDataLayoutManager().findRowIndRange(r,o.yMin,o.yMax),0);h<r.length;h++){var l=r[h].node;l&&l!==i&&(l.removeEffect("invalidDrop"),l.removeEffect("activeDrop"))}i.showEffect("activeDrop")}},l.prototype.ShowRejectedDropEffect=function(t){var e=this._getDropObject(t);if(this._gantt.isTaskResizeEnabled()){var i=this.DragSource.getDragObject();if(i&&"task"===i.nodeType){var a=i.getDraggedObject();if("taskResizeHandles"===this.getDnDTaskSubType(a))return}}e&&"row"===e.nodeType&&e.showEffect("invalidDrop")},l.prototype.ClearDropEffect=function(){var t=this._getDropObject();t&&"row"===t.nodeType&&(t.removeEffect("invalidDrop"),t.removeEffect("activeDrop"))},l.prototype.OnDndDragStart=function(t){l.superclass.OnDndDragStart.call(this,t),this._isDndDragging&&t.preventDefault();var i=t.getNativeEvent();if(i.defaultPrevented)this._gantt.SetPanningEnabled(!0),this._gantt.SetMarqueeEnabled(!0);else{this._isDndDragging=!0,this._dragStartSetup();var a=this.DragSource.getDragObject();if(a&&"task"===a.nodeType){a.dragStartSetup(t);var n=i.dataTransfer;this._dropOffset=new e.Point(Number(n.getData(e.EventManager.DROP_OFFSET_X_DATA_TYPE))||0,Number(n.getData(e.EventManager.DROP_OFFSET_Y_DATA_TYPE))||0)}else this._dropOffset=new e.Point(0,0)}},l.prototype.OnDndDragOver=function(t){l.superclass.OnDndDragOver.call(this,t);var i=this;this._lastKnownDragOverEvent=t,i._isDndDragging=!0,this._isDragOverTicking||this._lastProcessedDragOverEvent&&this._lastKnownDragOverEvent.pageX===this._lastProcessedDragOverEvent.pageX&&this._lastKnownDragOverEvent.pageY===this._lastProcessedDragOverEvent.pageY||(requestAnimationFrame(function(){var t=i.DragSource.getDragObject();if(t&&"task"===t.nodeType&&i._isDndDragging)if(i._lastKnownDragOverEvent.getNativeEvent().defaultPrevented){var a=i._gantt.getCtx().pageToStageCoords(i._lastKnownDragOverEvent.pageX,i._lastKnownDragOverEvent.pageY),n=i._gantt.getDnDArtifactsContainer().stageToLocal(a);if(t.showDragFeedback(i._lastKnownDragOverEvent,n,i._getDropObject(),i._dropOffset),e.Agent.isTouchDevice()){var s=e.AriaUtils.processAriaLabel(h.getDatatip(t,!1));if(i._gantt.isSelectionSupported()&&t.isSelected()){var r=i._gantt.getSelectionHandler().getSelectedCount();r>1&&(s+=". "+e.ResourceUtils.format(i._gantt.getOptions().translations.taskMoveSelectionInfo,[r-1]))}i._prevScreenReaderDragText&&i._prevScreenReaderDragText===s||i._gantt.updateLiveRegionText(s),i._prevScreenReaderDragText=s}}else t.removeDragFeedbacks();i._lastProcessedDragOverEvent=i._lastKnownDragOverEvent,i._isDragOverTicking=!1}),this._isDragOverTicking=!0)},l.prototype.OnDndDragEnd=function(t){l.superclass.OnDndDragEnd.call(this,t);var i=this.DragSource.getDragObject();i&&"task"===i.nodeType&&i.dragEndCleanup(),this._isDndDragging=!1,this._dropOffset=new e.Point(0,0),"none"===t.getNativeEvent().dataTransfer.dropEffect&&this.handleKeyboardDnDCancel(),this._gantt.SetPanningEnabled(!0),this._gantt.SetMarqueeEnabled(!0),"highlightDependencies"===this._gantt.getOptions().selectionBehavior&&this._gantt.dimDatabody()},l.prototype.OnDndDrop=function(t){l.superclass.OnDndDrop.call(this,t),this._dropCleanup();var i=t.getNativeEvent();if(i.defaultPrevented){var a=this.DragSource.getDragObject(),n=a.getDraggedObject?this.getDnDTaskSubType(a.getDraggedObject()):"tasks";if(this._gantt.isTaskMoveEnabled()&&"tasks"===n){e.Agent.isTouchDevice()&&this._gantt.updateLiveRegionText(this._gantt.getOptions().translations.taskMoveFinalized);var s=this.GetDropEventPayload(t),r=JSON.parse(i.dataTransfer.getData(l.MOVE_TASKS_DATA_TYPE)),o=s.value,h=s.start,d=s.end,g=s.baselineStart,c=s.baselineEnd,_=s.dataContext,p=e.EventFactory.newGanttMoveEvent(r,o,h,d,g,c,_);this._gantt.dispatchEvent(p)}else if(this._gantt.isTaskResizeEnabled()&&"taskResizeHandles"===n){e.Agent.isTouchDevice()&&this._gantt.updateLiveRegionText(this._gantt.getOptions().translations.taskResizeFinalized);s=this.GetDropEventPayload(t);var u=JSON.parse(i.dataTransfer.getData(l.RESIZE_TASKS_DATA_TYPE)),m=u[0].type;r=u.map(function(t){return t.dataContext}),o=s.value,h=s.start,d=s.end,p=e.EventFactory.newGanttResizeEvent(r,o,h,d,m);this._gantt.dispatchEvent(p)}}},l.prototype.IsDragSupported=function(t){if(this.isDndSupported()){var e=this._gantt.getOptions(),i=e.dnd&&e.dnd.drag?e.dnd.drag:null;return i&&i[t]&&i[t].dataTypes&&i[t].dataTypes.length>0}return!1},l.prototype.IsDropSupported=function(t){if(this.isDndSupported()){var e=this._gantt.getOptions(),i=e.dnd&&e.dnd.drop?e.dnd.drop:null;return i&&i[t]&&i[t].dataTypes}return!1},l.prototype.OnMouseDown=function(t){var e=this.GetLogicalObjectAndDisplayable(t.target);if(e.logicalObject&&"task"===e.logicalObject.nodeType){var i=this.getDnDTaskSubType(e.displayable);this.IsDragSupported(i)&&(this._gantt.SetPanningEnabled(!1),this._gantt.SetMarqueeEnabled(!1),e.logicalObject.setDraggedObject(e.displayable))}l.superclass.OnMouseDown.call(this,t)},l.prototype.OnMouseOut=function(t){l.superclass.OnMouseOut.call(this,t);var e=this._gantt.getTimeCursor();e&&e.hide()},l.prototype.OnMouseMove=function(t){if(l.superclass.OnMouseMove.call(this,t),this._gantt.IsTimeCursorEnabled()){var i=this._gantt.getTimeCursor();if(i){var n=e.Agent.isRightToLeft(this._gantt.getCtx()),s=this._gantt.getTimeCursorContainer(),r=this._gantt.getStartTime(),o=this._gantt.getEndTime(),h=this._gantt.getContentLength(),d=this._gantt.getCtx().pageToStageCoords(t.pageX,t.pageY),g=s.stageToLocal(d),c=a.TimeAxisUtils.getPositionDate(r,o,n?h-g.x:g.x,h);i.updateRefObjs([{type:"line",value:new Date(c).toISOString()}]),i.show()}}},l.prototype.ProcessSelectionEventHelper=function(t,e){if(l.superclass.ProcessSelectionEventHelper.call(this,t,e),"highlightDependencies"===this._gantt.getOptions().selectionBehavior){var i=this._gantt.getViewPort();this._gantt.getDataLayoutManager().renderViewportDependencyLines(i,"vpc_translate")}},l.prototype.onExpandCollapseButtonClick=function(t,e){var i=this.GetLogicalObject(e).getRowLayoutObject();this.toggleRowExpandCollapse(t,i)},l.prototype.toggleRowExpandCollapse=function(t,i){if(null!=i.expanded){var a,n,s,r,o=this._gantt.getOptions(),h=o.expanded,l=i.id,d=i.data;if(o.rowData)a=d.id,n=d._itemData;else{var g=i.taskObjs[0].data;a=g.id,n=g._itemData}h.has(l)?(r=h.delete([l]),s="collapse"):(r=h.add([l]),s="expand"),this._gantt.setRenderState({state:s,payload:i}),this._gantt.isSelectionSupported()&&this._gantt.getSelectionHandler().clearSelection();var c=e.EventFactory.newGanttExpandCollapseEvent(s,a,d,n,r);this._gantt.dispatchEvent(c)}},l.prototype.HandleImmediateTouchStartInternal=function(t){if(1===t.targetTouches.length){var e=this.GetLogicalObjectAndDisplayable(t.target);if(e.logicalObject&&"task"===e.logicalObject.nodeType){var i=this.getDnDTaskSubType(e.displayable);this.IsDragSupported(i)&&(this._gantt.SetPanningEnabled(!1),this._gantt.SetMarqueeEnabled(!1),e.logicalObject.setDraggedObject(e.displayable))}}},l.prototype.OnTouchMoveBubble=function(t){this._isDndDragging&&(this._preventHideTooltip=!0),l.superclass.OnTouchMoveBubble.call(this,t)};var d=function(t,e){this.Init(t,e)};e.Obj.createSubclass(d,i.TimeComponentKeyboardHandler),d.prototype.Init=function(t,e){d.superclass.Init.call(this,e),this._gantt=t},d._findPreviousTask=function(t,e,i,a,n){var s=i.taskObjs;if(0===s.length)return 0===a?n:d._findPreviousTask(t,e,e[a-1],a-1,n);var r=s[s.length-1];return t.getDataLayoutManager().ensureInDOM(r,"task"),r.node},d._findNextTask=function(t,e,i,a,n){var s=i.taskObjs;if(0===s.length)return a===e.length-1?n:d._findNextTask(t,e,e[a+1],a+1,n);var r=s[0];return t.getDataLayoutManager().ensureInDOM(r,"task"),r.node},d.getNextNavigable=function(t,i,a,n){if(null==i||"task"!==i.nodeType)return null;var s=i.getRowNode(),r=t.getRowLayoutObjs(),o=s.getTaskObjs(),h=e.Agent.isRightToLeft(t.getCtx()),l=s.getIndex();switch(a.keyCode){case h?e.KeyboardEvent.RIGHT_ARROW:e.KeyboardEvent.LEFT_ARROW:var g=o.map(function(t){return t.node}).indexOf(i);if(0!==g){var c=o[g-1];return t.getDataLayoutManager().ensureInDOM(c,"task"),c.node}if(l>0)return d._findPreviousTask(t,r,r[l-1],l-1,i);break;case h?e.KeyboardEvent.LEFT_ARROW:e.KeyboardEvent.RIGHT_ARROW:if((g=o.map(function(t){return t.node}).indexOf(i))!==o.length-1){c=o[g+1];return t.getDataLayoutManager().ensureInDOM(c,"task"),c.node}if(l<r.length-1)return d._findNextTask(t,r,r[l+1],l+1,i);break;case e.KeyboardEvent.UP_ARROW:if(l>0&&null!=(i=d._findPreviousTask(t,r,r[l-1],l-1,i))){c=i.getRowNode().getTaskObjs()[0];return t.getDataLayoutManager().ensureInDOM(c,"task"),c.node}break;case e.KeyboardEvent.DOWN_ARROW:if(l<r.length-1&&null!=(i=d._findNextTask(t,r,r[l+1],l+1,i))){c=i.getRowNode().getTaskObjs()[0];return t.getDataLayoutManager().ensureInDOM(c,"task"),c.node}}return i},d.prototype.isNavigationEvent=function(t){var i=!1;switch(t.keyCode){case e.KeyboardEvent.OPEN_ANGLED_BRACKET:case e.KeyboardEvent.CLOSE_ANGLED_BRACKET:i=!!t.altKey;break;default:i=d.superclass.isNavigationEvent.call(this,t)}return i},d.prototype._getDistance=function(t){var e=t.getValue("type"),i=t.getPredecessorNode(),a=t.getSuccessorNode(),n=e===s.START_START||e===s.START_FINISH?i.getValue("start"):i.getValue("end");if(e===s.START_START||e===s.FINISH_START)var r=a.getValue("start");else r=a.getValue("end");return Math.abs(r-n)},d.prototype._getDependencyComparator=function(){var t=this;return function(e,i){var a=t._getDistance(e),n=t._getDistance(i);return a<n?-1:a>n?1:0}},d.prototype.getFirstNavigableDependencyLine=function(t,i,a){var n=this._gantt.getCtx(),s=i.keyCode;if(!a||a.length<1||!t)return null;for(var r=e.Agent.isRightToLeft(this._gantt.getCtx()),o=null,h=0,l=0;l<a.length;l++){var d=a[l];if(s===e.KeyboardEvent.CLOSE_ANGLED_BRACKET)var g=r?d.getValue("predecessorTaskId"):d.getValue("successorTaskId");else g=r?d.getValue("successorTaskId"):d.getValue("predecessorTaskId");if(!e.Obj.compareValues(n,t.getId(),g)){var c=this._getDistance(d);(null==o||c<h)&&(h=c,o=d)}}return o},d.prototype.getNextNavigableDependencyLine=function(t,i,a,n){if(!n)return null;if(!i)return n[0];if(!t)return i;n.sort(this._getDependencyComparator());for(var s=a.keyCode===e.KeyboardEvent.DOWN_ARROW,r=0,o=0;o<n.length;o++){if(n[o]===i){r=s?o===n.length-1?0:o+1:0===o?n.length-1:o-1;break}}return n[r]},d.prototype.isMoveInitiationEvent=function(t){return t.keyCode===e.KeyboardEvent.M&&t.ctrlKey},d.prototype.isResizeStartInitiationEvent=function(t){return 83===t.keyCode&&t.altKey},d.prototype.isResizeEndInitiationEvent=function(t){return 69===t.keyCode&&t.altKey},d.prototype.isDnDScaleUpEvent=function(t){return this._eventManager.getKeyboardDnDMode()&&t.keyCode===e.KeyboardEvent.PAGE_UP},d.prototype.isDnDScaleDownEvent=function(t){return this._eventManager.getKeyboardDnDMode()&&t.keyCode===e.KeyboardEvent.PAGE_DOWN},d.prototype.isDnDForwardEvent=function(t){var i=e.Agent.isRightToLeft(this._gantt.getCtx());return this._eventManager.getKeyboardDnDMode()&&t.keyCode===(i?e.KeyboardEvent.LEFT_ARROW:e.KeyboardEvent.RIGHT_ARROW)},d.prototype.isDnDBackwardEvent=function(t){var i=e.Agent.isRightToLeft(this._gantt.getCtx());return this._eventManager.getKeyboardDnDMode()&&t.keyCode===(i?e.KeyboardEvent.RIGHT_ARROW:e.KeyboardEvent.LEFT_ARROW)},d.prototype.isMoveRowAboveEvent=function(t){return this._eventManager.getKeyboardDnDMode()===l.KEYBOARD_MOVE&&t.keyCode===e.KeyboardEvent.UP_ARROW},d.prototype.isMoveRowBelowEvent=function(t){return this._eventManager.getKeyboardDnDMode()===l.KEYBOARD_MOVE&&t.keyCode===e.KeyboardEvent.DOWN_ARROW},d.prototype.isDnDFinalizeEvent=function(t){return this._eventManager.getKeyboardDnDMode()&&t.keyCode===e.KeyboardEvent.ENTER},d.prototype.isDnDCancelEvent=function(t){return this._eventManager.getKeyboardDnDMode()&&t.keyCode===e.KeyboardEvent.ESCAPE},d.prototype.processKeyDown=function(t){var i=e.Agent.isRightToLeft(this._gantt.getCtx()),a=t.keyCode;if(a===e.KeyboardEvent.TAB){if(h=this._eventManager.getFocus())return e.EventManager.consumeEvent(t),h;for(var n=this._gantt.getRowLayoutObjs(),s=0;s<n.length;s++){var r=(l=n[s]).taskObjs;if(r.length>0){e.EventManager.consumeEvent(t);var o=r[0];return this._gantt.getDataLayoutManager().ensureInDOM(o,"task"),o.node}}}if(this.isMoveInitiationEvent(t)&&((h=this._eventManager.getFocus())&&"task"===h.nodeType&&h.isSelected()&&this._gantt.isTaskMoveEnabled()&&!this._eventManager.isDnDDragging()))return this._eventManager.handleKeyboardMoveInitiation(t,h),e.EventManager.consumeEvent(t),null;if(this.isResizeStartInitiationEvent(t)&&((h=this._eventManager.getFocus())&&"task"===h.nodeType&&h.isSelected()&&this._gantt.isTaskResizeEnabled()&&!this._eventManager.isDnDDragging()))return this._eventManager.handleKeyboardResizeStartInitiation(t,h),e.EventManager.consumeEvent(t),null;if(this.isResizeEndInitiationEvent(t)&&((h=this._eventManager.getFocus())&&"task"===h.nodeType&&h.isSelected()&&this._gantt.isTaskResizeEnabled()&&!this._eventManager.isDnDDragging()))return this._eventManager.handleKeyboardResizeEndInitiation(t,h),e.EventManager.consumeEvent(t),null;if(this.isDnDCancelEvent(t))return this._eventManager.handleKeyboardDnDCancel(),e.EventManager.consumeEvent(t),null;if(this.isDnDScaleUpEvent(t))return this._eventManager.handleKeyboardDnDScaleUp(t),e.EventManager.consumeEvent(t),null;if(this.isDnDScaleDownEvent(t))return this._eventManager.handleKeyboardDnDScaleDown(t),e.EventManager.consumeEvent(t),null;if(this.isDnDForwardEvent(t))return this._eventManager.handleKeyboardDnDForward(t),e.EventManager.consumeEvent(t),null;if(this.isDnDBackwardEvent(t))return this._eventManager.handleKeyboardDnDBackward(t),e.EventManager.consumeEvent(t),null;if(this.isMoveRowAboveEvent(t))return this._eventManager.handleKeyboardMoveRowAbove(t),e.EventManager.consumeEvent(t),null;if(this.isMoveRowBelowEvent(t))return this._eventManager.handleKeyboardMoveRowBelow(t),e.EventManager.consumeEvent(t),null;if(this.isDnDFinalizeEvent(t))return this._eventManager.handleKeyboardDnDFinalize(t),e.EventManager.consumeEvent(t),null;if(a===e.KeyboardEvent.SPACE&&t.ctrlKey&&t.shiftKey&&((h=this._eventManager.getFocus())&&"task"===h.nodeType))return e.EventManager.consumeEvent(t),this._eventManager.toggleRowExpandCollapse(t,h.getLayoutObject().rowObj),null;if(a===(i?e.KeyboardEvent.LEFT_ARROW:e.KeyboardEvent.RIGHT_ARROW)&&t.ctrlKey){var h=this._eventManager.getFocus();this._gantt.getDataLayoutManager();if(h&&"rowLabel"===h.nodeType){var l=h.getRowLayoutObject();if(this._gantt.getDataLayoutManager().isRowExpandable(l))return e.EventManager.consumeEvent(t),this._eventManager.toggleRowExpandCollapse(t,h.getRowLayoutObject()),null}}if(a===(i?e.KeyboardEvent.RIGHT_ARROW:e.KeyboardEvent.LEFT_ARROW)&&t.ctrlKey&&((h=this._eventManager.getFocus())&&"rowLabel"===h.nodeType)){l=h.getRowLayoutObject();if(this._gantt.getDataLayoutManager().isRowCollapsible(l))return e.EventManager.consumeEvent(t),this._eventManager.toggleRowExpandCollapse(t,l),null}return a===e.KeyboardEvent.ESCAPE?(this._eventManager.cancelMarquee(t),null):d.superclass.processKeyDown.call(this,t)};const g=function(t,e){this.Init(t,e)};e.Obj.createSubclass(g,e.Container),g.prototype.Init=function(t,e){g.superclass.Init.call(this,t.getCtx(),null),this._gantt=t,this._task=e,this._isHighlighted=!1},g.prototype.render=function(t){const i=this._gantt.getOptions();this._content&&this.removeChild(this._content),this._content=new e.Container(this._gantt.getCtx()),this._content.setClassName(this._gantt.GetStyleClass("taskCustom")),this.addChild(this._content);const a=this._content.getContainerElem(),n=(0,i.taskContent.renderer)(this.getRendererContext(t));n&&(Array.isArray(n)?n.forEach(function(t){e.ToolkitUtils.appendChildElem(a,t)}):e.ToolkitUtils.appendChildElem(a,n));const s=new e.ClipPath,r=this._getClipPathDim();s.addRect(r.x,r.y,r.w,r.h,r.r,r.r),this.setClipPath(s),this._isHighlighted?this.highlight():this.unhighlight()},g.prototype.destroy=function(){this.setClipPath(null),this.removeFromParent()},g.prototype.getRendererContext=function(t){const e=this._gantt.getCtx(),i=this._task.getShape("main"),a=this._task.getContainer(),n=a.getRowNode(),s=n.getLayoutObject(),r=a.getData()._itemData,o={data:a.getData(!0),rowData:n.getData(!0),itemData:r||null,content:{height:i.getHeight(),width:i.getWidth()+i.getPhysicalStartOffset()+i.getPhysicalEndOffset()},state:{expanded:!!s.expanded,focused:!!a.isShowingKeyboardFocusEffect(),hovered:t,selected:!!a.isSelected()}};return e.fixRendererContext(o)},g.prototype.highlight=function(){this._isHighlighted=!0,this._content&&e.ToolkitUtils.addClassName(this._content.getElem(),this._gantt.GetStyleClass("taskHighlight"))},g.prototype.unhighlight=function(){this._isHighlighted=!1,this._content&&e.ToolkitUtils.removeClassName(this._content.getElem(),this._gantt.GetStyleClass("taskHighlight"))},g.prototype._getClipPathDim=function(t){const i=t||{},a=this._task.getShape("main"),n=e.Agent.isRightToLeft(this._gantt.getCtx()),s=null!=i.w?i.w:a.getWidth();return{x:n?0-s-a.getPhysicalEndOffset():0-a.getPhysicalStartOffset(),translateX:n?0+a.getPhysicalStartOffset():0-a.getPhysicalStartOffset(),y:0,translateY:0,w:s+a.getPhysicalStartOffset()+a.getPhysicalEndOffset(),h:null!=i.h?i.h:a.getHeight(),r:null!=i.r?i.r:a.getBorderRadius()}},g.prototype.setWidth=function(t){const i=new e.ClipPath,a=this._getClipPathDim({w:t});i.addRect(a.x,a.y,a.w,a.h,a.r,a.r),this.setClipPath(i)},g.prototype.setHeight=function(t){const i=new e.ClipPath,a=this._getClipPathDim({h:t});i.addRect(a.x,a.y,a.w,a.h,a.r,a.r),this.setClipPath(i)},g.prototype.setX=function(t){const i=this._getClipPathDim({x:t});this.setTranslateX(i.translateX);const a=new e.ClipPath;a.addRect(i.x,i.y,i.w,i.h,i.r,i.r),this.setClipPath(a)},g.prototype.setY=function(t){const i=this._getClipPathDim({y:t});this.setTranslateY(i.translateY);const a=new e.ClipPath;a.addRect(i.x,i.y,i.w,i.h,i.r,i.r),this.setClipPath(a)},g.prototype.setBorderRadius=function(t){const i=new e.ClipPath,a=this._getClipPathDim({r:t});i.addRect(a.x,a.y,a.w,a.h,a.r,a.r),this.setClipPath(i)},g.prototype.setDimensions=function(t,i,a,n,s){const r=this._getClipPathDim({x:t,y:i,w:a,h:n,r:s});this.setTranslate(r.translateX,r.translateY);const o=new e.ClipPath;o.addRect(r.x,r.y,r.w,r.h,r.r,r.r),this.setClipPath(o)};var c=function(t,e){this.Init(t,e)};e.Obj.createSubclass(c,e.Obj),c.prototype.Init=function(t,e){this._gantt=t,this._container=e},c.prototype.getGantt=function(){return this._gantt},c.prototype.getContainer=function(){return this._container},c.prototype.getShape=function(t){return"main"===t?this._mainShape:"progress"===t?this._progressShape:"baseline"===t?this._baselineShape:"overtime"===t?this._overtimeShape:"downtime"===t?this._downtimeShape:"attribute"===t?this._attributeShape:"mainResizeHandleStart"===t?this._mainHandleStart:"mainResizeHandleEnd"===t?this._mainHandleEnd:void 0},c.prototype.getSvgStyle=function(t){return null==t?this._container.getValue("svgStyle"):this._container.getValue(t,"svgStyle")},c.prototype.getSvgClassName=function(t){return null==t?this._container.getValue("svgClassName")||this._container.getValue("className"):this._container.getValue(t,"svgClassName")||this._container.getValue(t,"className")},c.prototype._applyStyles=function(t,e){var i=this.getSvgClassName(e),a=this.getSvgStyle(e);i&&(t.applyDefaultStyleClasses(),t.setClassName(t.getClassName()+" "+i)),a&&t.setStyle(a)},c.prototype.isMilestone=function(t){var e,i,a=this._container.getValue("type");return"milestone"===a||"auto"===a&&("mainDragFeedback"===t||o.MAIN_TYPES.indexOf(t)>-1?(e=this._container.getValue("start"),i=this._container.getValue("end")):o.BASELINE_TYPES.indexOf(t)>-1&&(e=this._container.getValue("baseline","start"),i=this._container.getValue("baseline","end")),null!=e&&e==i)},c.prototype.isSummary=function(t){return"main"===t&&"summary"===this._container.getValue("type")},c.prototype.getTimeSpanDimensions=function(t,i){var n,s,r=this._gantt.getStartTime(),o=this._gantt.getEndTime(),h=this._gantt.getContentLength(),l=e.Agent.isRightToLeft(this._gantt.getCtx());return null!=t||null!=i?(n=a.TimeAxisUtils.getDatePosition(r,o,t,h),s=a.TimeAxisUtils.getDatePosition(r,o,i,h),l&&(n=h-n,s=h-s),{startPos:n,endPos:s,distance:s-n}):null},c.prototype.getFillColor=function(){if(null==this._fillColor){if(null==this._mainShape)return null;this._fillColor=this._mainShape.getFillColor()}return this._fillColor},c.prototype.getFinalHeight=function(t){var e=this._container.getLayoutObject();return t?e.overallHeightNoProgress:e.overallHeight},c.prototype.showEffect=function(t){(this.showMainEffect(t),"selected"===t)&&this._container.getRowNode().showEffect("selected")},c.prototype.removeEffect=function(t,e){(this.removeMainEffect(t,e),"selected"===t)&&this._container.getRowNode().removeEffect("selected")},c.prototype.render=function(t){var e=this._container.getValue("progress","height");this.renderBaseline(e),this.renderMain(e,t),this.renderProgress(e),this.renderOvertime(),this.renderDowntime(),this.renderAttribute(),"summary"===this._container.getValue("type")&&this._mainShape&&"alta"===this._gantt.getCtx().getThemeBehavior()&&this._container.addChild(this._mainShape),this._mainCustomContent&&this._container.addChild(this._mainCustomContent)},c.prototype.isMainCustomContent=function(){var t=this._gantt.getOptions();return t.taskContent&&t.taskContent.renderer},c.prototype.getRenderState=function(t){return"main"===t?this._mainShape.getRenderState():"progress"===t?this._progressShape.getRenderState():"baseline"===t?this._baselineShape.getRenderState():"overtime"===t?this._overtimeShape.getRenderState():"downtime"===t?this._downtimeShape.getRenderState():"attribute"===t?this._attributeShape.getRenderState():void 0},c.prototype.renderBaseline=function(t){var e,i,a,s,r,h,l,d,g,c,_,p,u,m=this._gantt.getOptions(),b=this._container.getValue("baseline"),f=this;b?(i=this._container.getValue("baseline","start"),a=this._container.getValue("baseline","end"),(d=this.getTimeSpanDimensions(i,"milestone"===this._container.getValue("type")&&i!=a?i:a))?(h=this.getTimeSpanDimensions(this._container.getValue("start"),i),e=this.isMilestone("baseline"),g=h?h.distance:0,_=Math.abs(d.distance),p=this._container.getValue("baseline","height"),s=e?Math.max(this._container.getValue("height"),p)+n.getMilestoneBaselineYOffset(m)-p:this._container.getValue("height")+n.getBaselineMarginTop(m),c=Math.max(0,(t-this._container.getValue("height"))/2)+s,u=e?m._resources.milestoneBaselineBorderRadius:b.borderRadius,null==this._baselineShape?(this._baselineShape=new o(this._gantt.getCtx(),g,c,_,p,u,this,"baseline"),e?this._container.addChildAt(this._baselineShape,0):this._container.addChild(this._baselineShape),this._baselineShape.setRenderState("add")):(this._baselineShape.setRenderState("exist"),e&&this._container.addChildAt(this._baselineShape,0)),this._baselineShape.setFinalWidth(_),this._baselineShape.setFinalHeight(p),this._baselineShape.setFinalX(g),this._baselineShape.setFinalY(c),l=function(){f._applyStyles(f._baselineShape,"baseline")},r={x:g,y:c,w:_,h:p,r:u},this._gantt.getAnimationManager().preAnimateTaskBaseline(this,this._baselineShape,r,l)):this.removeBaseline()):this.removeBaseline()},c.prototype.removeBaseline=function(){var t,e=this;this._baselineShape&&(t=function(){e._container.removeChild(e._baselineShape),e._baselineShape=null},this._gantt.getAnimationManager().preAnimateTaskBaselineRemove(this._baselineShape,t))},c.prototype.renderMain=function(t,i){var a,n,s,r,h,l,d,c,_=this._container.getData(),p=this._container.getValue("height"),u=this._container.getValue("start"),m=this._container.getValue("end"),b=e.Agent.isRightToLeft(this._gantt.getCtx()),f=this,y=this._gantt.getOptions();if(_)if(s=this.getTimeSpanDimensions(u,"milestone"===this._container.getValue("type")&&u!=m?u:m)){switch(0,r=Math.max(0,(t-p)/2),h=Math.abs(s.distance),l=this.isSummary("main")&&"alta"===this._gantt.getCtx().getThemeBehavior()?this._container.getFinalHeight(!0):p,c=this.isMilestone("main")?y._resources.milestoneBorderRadius:this._container.getValue("borderRadius"),this._container.getLayoutObject().aggregation){case"stackStart":d=b?`0px ${c} ${c} 0px`:`${c} 0px 0px ${c}`;break;case"stackMiddle":d="0";break;case"stackEnd":d=b?`${c} 0px 0px ${c}`:`0px ${c} ${c} 0px`;break;case"stackSolo":default:d=c}if(null==this._mainShape?("alta"!==this._gantt.getCtx().getThemeBehavior()&&(this._mainBackgroundShape=new o(this._gantt.getCtx(),0,r,h,l,d,this,"mainBackground"),this._container.addChild(this._mainBackgroundShape)),this._mainShape=new o(this._gantt.getCtx(),0,r,h,l,d,this,"main"),this._container.addChild(this._mainShape),this._mainShape.setRenderState("add"),this.isMainCustomContent()&&(this._mainCustomContent&&this._mainCustomContent.destroy(),this._mainCustomContent=new g(this._gantt,this),this._mainCustomContent.render(!1))):this._mainShape.setRenderState("exist"),null==this._mainContainer){var v="on"===this._container.getValue("attribute","rendered"),S=null!=this.getProgressValue(),T=null!=this._container.getValue("downtime","start")||null!=this._container.getValue("downtime","end"),D=null!=this._container.getValue("overtime","start")||null!=this._container.getValue("overtime","end");if(v||S||T||D){this._mainContainer=new e.Container(this._gantt.getCtx());var C=new e.ClipPath;C.addPath(this._mainShape.getCmds()),this._mainContainer.setClipPath(C),this._container.addChild(this._mainContainer)}}this._mainShape.setFinalWidth(h),this._mainShape.setFinalHeight(l),this._mainShape.setFinalX(0),this._mainShape.setFinalY(r),n=function(){f._fillColor=null,f._applyStyles(f._mainShape),i&&f._mainCustomContent&&"exist"===f._mainShape.getRenderState()&&f._mainCustomContent.render(!1)},a={x:0,y:r,w:h,h:l,r:d},this._gantt.getAnimationManager().preAnimateTaskMain(this,a,n)}else this.removeMain();else this.removeMain()},c.prototype.showMainEffect=function(t){var e=this._mainShape.getX(),i=this._mainShape.getY(),a=this._mainShape.getWidth(),n=this._mainShape.getHeight(),s=this._mainShape.getBorderRadius(),r=function(t){var e=t.getRowNode().getLayoutObject(),i=t.getLayoutObject(),a=e.earliestOverlayTaskObj,n=t.getParent();if(a&&"overlay"!==i._overlayBehavior){var s=a.node;if(s.getParent()){var r=n.getChildIndex(s);n.addChildAt(t,r-1)}else n.addChild(t)}else n.addChild(t)};if("selected"===t)null==this._mainSelectShape&&(this._mainSelectShape=new o(this._gantt.getCtx(),e,i,a,n,s,this,"mainSelect"),this._container.addChildAt(this._mainSelectShape,0),this._mainCustomContent&&this._mainCustomContent.render(!1),r(this._container));else if(("hover"===t||"focus"===t)&&null==this._mainHoverShape){var h="hover"===t?"mainHover":"mainFocus";this._mainHoverShape=new o(this._gantt.getCtx(),e,i,a,n,s,this,h),this._container.addChildAt(this._mainHoverShape,this._container.getChildIndex(this._mainShape)),this._mainCustomContent&&this._mainCustomContent.render("hover"===t),"on"!==this._gantt.getOptions().taskAggregation&&r(this._container)}this._mainShape.isHighlighted()&&(this._mainSelectShape&&this._mainSelectShape.highlight(),this._mainHoverShape&&this._mainHoverShape.highlight())},c.prototype.removeMainEffect=function(t,e){var i="on"===this._gantt.getOptions().taskAggregation;if(e=(void 0===e||e)&&!i,"selected"===t?(null!=this._mainSelectShape&&this._container.removeChild(this._mainSelectShape),this._mainSelectShape=null):"hover"!==t&&"focus"!==t||(null!=this._mainHoverShape&&this._container.removeChild(this._mainHoverShape),this._mainHoverShape=null),this._mainCustomContent&&this._mainCustomContent.render(!1),e){var a=this._container.getRowNode().getRenderOrderTaskObjs();if(a.length<2)return;var n=this._container.getParent();if(!n)return;for(var s=this._container.getLayoutObject(),r=this._container,o=a.indexOf(s)-1;o>=0;o--){var h=a[o].node;if(h&&!h.isSelected()&&h.getParent()){var l=n.getChildIndex(h);return void n.addChildAt(r,l)}}n.addChildAt(r,0)}},c.prototype.getMainWidth=function(){return this._mainShape.getWidth()},c.prototype.setMainWidth=function(t){if(this._mainShape.setWidth(t),this._mainBackgroundShape&&this._mainBackgroundShape.setWidth(t),this._mainSelectShape&&this._mainSelectShape.setWidth(t),this._mainHoverShape&&this._mainHoverShape.setWidth(t),this._mainCustomContent&&this._mainCustomContent.setWidth(t),this._mainContainer){var i=new e.ClipPath;i.addPath(this._mainShape.getCmds()),this._mainContainer.setClipPath(i)}},c.prototype.getMainHeight=function(){return this._mainShape.getHeight()},c.prototype.setMainHeight=function(t){if(this._mainShape.setHeight(t),this._mainBackgroundShape&&this._mainBackgroundShape.setHeight(t),this._mainSelectShape&&this._mainSelectShape.setHeight(t),this._mainHoverShape&&this._mainHoverShape.setHeight(t),this._mainCustomContent&&this._mainCustomContent.setHeight(t),this._mainContainer){var i=new e.ClipPath;i.addPath(this._mainShape.getCmds()),this._mainContainer.setClipPath(i)}},c.prototype.getMainX=function(){return this._mainShape.getX()},c.prototype.setMainX=function(t){if(this._mainShape.setX(t),this._mainBackgroundShape&&this._mainBackgroundShape.setX(t),this._mainSelectShape&&this._mainSelectShape.setX(t),this._mainHoverShape&&this._mainHoverShape.setX(t),this._mainCustomContent&&this._mainCustomContent.setX(t),this._mainContainer){var i=new e.ClipPath;i.addPath(this._mainShape.getCmds()),this._mainContainer.setClipPath(i)}},c.prototype.getMainY=function(){return this._mainShape.getY()},c.prototype.setMainY=function(t){if(this._mainShape.setY(t),this._mainBackgroundShape&&this._mainBackgroundShape.setY(t),this._mainSelectShape&&this._mainSelectShape.setY(t),this._mainHoverShape&&this._mainHoverShape.setY(t),this._mainCustomContent&&this._mainCustomContent.setY(t),this._mainContainer){var i=new e.ClipPath;i.addPath(this._mainShape.getCmds()),this._mainContainer.setClipPath(i)}},c.prototype.getMainBorderRadius=function(){return this._mainShape.getBorderRadius()},c.prototype.setMainBorderRadius=function(t){if(this._mainShape.setBorderRadius(t),this._mainBackgroundShape&&this._mainBackgroundShape.setBorderRadius(t),this._mainSelectShape&&this._mainSelectShape.setBorderRadius(t),this._mainHoverShape&&this._mainHoverShape.setBorderRadius(t),this._mainCustomContent&&this._mainCustomContent.setBorderRadius(t),this._mainContainer){var i=new e.ClipPath;i.addPath(this._mainShape.getCmds()),this._mainContainer.setClipPath(i)}},c.prototype.setMainDimensions=function(t,i,a,n,s){if(this._mainShape.setDimensions(t,i,a,n,s),this._mainBackgroundShape&&this._mainBackgroundShape.setDimensions(t,i,a,n,s),this._mainSelectShape&&this._mainSelectShape.setDimensions(t,i,a,n,s),this._mainHoverShape&&this._mainHoverShape.setDimensions(t,i,a,n,s),this._mainCustomContent&&this._mainCustomContent.setDimensions(t,i,a,n,s),this._mainContainer){var r=new e.ClipPath;r.addPath(this._mainShape.getCmds()),this._mainContainer.setClipPath(r)}},c.prototype.removeMain=function(){var t,e=this;this._mainShape&&(t=function(){e._mainCustomContent&&(e._mainCustomContent.destroy(),e._mainCustomContent=null),e.removeMainEffect("selected",!1),e._mainBackgroundShape&&(e._container.removeChild(e._mainBackgroundShape),e._mainBackgroundShape=null),e._container.removeChild(e._mainShape),e._mainShape=null,e._mainContainer&&(e._container.removeChild(e._mainContainer),e._mainContainer=null)},this._gantt.getAnimationManager().preAnimateTaskMainRemove(this._mainShape,this._mainBackgroundShape,this._mainSelectShape,this._mainHoverShape,this._mainCustomContent,this._mainContainer,t))},c.prototype.getProgressValue=function(){var t=this._container.getValue("progress","value");return this.isMilestone("main")||"number"!=typeof t?null:t},c.prototype.renderProgress=function(t){this._container.getValue("progress");var e,i,a,n,s,r,h=this._container.getValue("height"),l=this.getProgressValue(),d=this;null!==l&&this._mainShape&&this._mainContainer&&!this.isMilestone("main")?(0,a=Math.max(0,(h-t)/2),n=l*this._mainShape.getFinalWidth(),s=this._container.getValue("progress","borderRadius"),r="progress",0===l?r="progressZero":1===l&&(r="progressFull"),null==this._progressShape?(this._progressShape=new o(this._gantt.getCtx(),0,a,n,t,s,this,r),this._mainContainer.addChild(this._progressShape),this._progressShape.setRenderState("add")):(this._progressShape.setType(r),this._progressShape.setRenderState("exist")),this._progressShape.setFinalWidth(n),this._progressShape.setFinalHeight(t),this._progressShape.setFinalX(0),this._progressShape.setFinalY(a),e=function(){d._applyStyles(d._progressShape,"progress")},i={x:0,y:a,w:n,h:t,r:s},this._gantt.getAnimationManager().preAnimateTaskProgress(this,this._progressShape,i,e)):this.removeProgress()},c.prototype.removeProgress=function(){var t,e=this;this._progressShape&&(t=function(){e._progressShape&&(e._progressShape.removeFromParent(),e._progressShape=null)},this._gantt.getAnimationManager().preAnimateTaskProgressRemove(this._progressShape,t))},c.prototype.renderOvertime=function(){var t=this;if(this._mainShape&&this._mainContainer&&!this.isMilestone("main")){var i=this._container.getValue("overtime","start"),a=this._container.getValue("overtime","end"),n=this.getTimeSpanDimensions(i,a);if(n){var s=e.Agent.isRightToLeft(this._gantt.getCtx()),r=this._container.getValue("start"),h=this._container.getLayoutObject(),l=(s?-1:1)*this.getTimeSpanDimensions(r,i).distance,d=h.overtimeHeight,g=Math.abs(n.distance);null==this._overtimeShape?(this._overtimeShape=new o(this._gantt.getCtx(),l,0,g,d,"0",this,"overtime"),this._mainContainer.addChild(this._overtimeShape),this._overtimeShape.setRenderState("add")):this._overtimeShape.setRenderState("exist"),this._overtimeShape.setFinalWidth(g),this._overtimeShape.setFinalHeight(d),this._overtimeShape.setFinalX(l),this._overtimeShape.setFinalY(0);var c={x:l,y:0,w:g,h:d,r:"0"};this._gantt.getAnimationManager().preAnimateTaskOvertime(this,this._overtimeShape,c,function(){t._applyStyles(t._overtimeShape,"overtime")})}else this.removeOvertime()}else this.removeOvertime()},c.prototype.removeOvertime=function(){var t,e=this;this._overtimeShape&&(t=function(){e._overtimeShape&&(e._overtimeShape.removeFromParent(),e._overtimeShape=null)},this._gantt.getAnimationManager().preAnimateTaskOvertimeRemove(this._overtimeShape,t))},c.prototype.renderDowntime=function(){var t=this;if(this._mainShape&&this._mainContainer&&!this.isMilestone("main")){var i=this._container.getValue("downtime","start"),a=this._container.getValue("downtime","end"),n=this.getTimeSpanDimensions(i,a);if(n){var s=this._gantt.getOptions(),r=e.Agent.isRightToLeft(this._gantt.getCtx()),h=this._container.getValue("start"),l=this._container.getLayoutObject(),d=(r?-1:1)*this.getTimeSpanDimensions(h,i).distance,g=l.downtimeHeight,c=this._mainShape.getFinalHeight()-g,_=Math.abs(n.distance),p=s._resources.taskDowntimeBorderRadius,u=`${p} ${p} 0px 0px`;null==this._downtimeShape?(this._downtimeShape=new o(this._gantt.getCtx(),d,c,_,g,u,this,"downtime"),this._mainContainer.addChild(this._downtimeShape),this._downtimeShape.setRenderState("add")):this._downtimeShape.setRenderState("exist"),this._downtimeShape.setFinalWidth(_),this._downtimeShape.setFinalHeight(g),this._downtimeShape.setFinalX(d),this._downtimeShape.setFinalY(c);var m={x:d,y:c,w:_,h:g,r:u};this._gantt.getAnimationManager().preAnimateTaskDowntime(this,this._downtimeShape,m,function(){t._applyStyles(t._downtimeShape,"downtime")})}else this.removeDowntime()}else this.removeDowntime()},c.prototype.removeDowntime=function(){var t,e=this;this._downtimeShape&&(t=function(){e._downtimeShape&&(e._downtimeShape.removeFromParent(),e._downtimeShape=null)},this._gantt.getAnimationManager().preAnimateTaskDowntimeRemove(this._downtimeShape,t))},c.prototype.renderAttribute=function(){var t=this;if("on"===this._container.getValue("attribute","rendered")&&this._mainShape&&this._mainContainer&&!this.isMilestone("main")){var e=this._container.getLayoutObject().attributeHeight,i=this._mainShape.getFinalWidth();null==this._attributeShape?(this._attributeShape=new o(this._gantt.getCtx(),0,0,i,e,"0",this,"attribute"),this._mainContainer.addChild(this._attributeShape),this._attributeShape.setRenderState("add")):this._attributeShape.setRenderState("exist"),this._attributeShape.setFinalWidth(i),this._attributeShape.setFinalHeight(e),this._attributeShape.setFinalX(0),this._attributeShape.setFinalY(0);var a={x:0,y:0,w:i,h:e,r:"0"};this._gantt.getAnimationManager().preAnimateTaskAttribute(this,this._attributeShape,a,function(){t._applyStyles(t._attributeShape,"attribute")})}else this.removeAttribute()},c.prototype.removeAttribute=function(){var t,e=this;this._attributeShape&&(t=function(){e._attributeShape&&(e._attributeShape.removeFromParent(),e._attributeShape=null)},this._gantt.getAnimationManager().preAnimateTaskAttributeRemove(this._attributeShape,t))},c.prototype.renderMainResizeHandles=function(t){var i,a,s,r,h,l=e.Agent.isRightToLeft(this._gantt.getCtx())?-1:1;if(this._mainShape){i=n.getTaskResizeHandleWidth(),a=this._mainShape.getX()-l*this._mainShape.getPhysicalStartOffset(),s=this._mainShape.getY(),r=this._mainShape.getWidth()+this._mainShape.getPhysicalStartOffset()+this._mainShape.getPhysicalEndOffset(),h=this._mainShape.getHeight();var d=this,g=function(t,i){if(e.Agent.isTouchDevice()||e.Agent.isEnvironmentTest()){var a=d._gantt.getOptions().translations,n="start"===i?a.taskResizeStartHandle:a.taskResizeEndHandle;t.setAriaRole("img"),t.setAriaProperty("label",n)}};this._mainHandleStart?this._mainHandleStart.setDimensions(a,s,i,h,"0"):(this._mainHandleStart=new o(this._gantt.getCtx(),a,s,i,h,"0",this,"mainResizeHandleStart"),g(this._mainHandleStart,"start")),t.addChild(this._mainHandleStart),this._mainHandleEnd?this._mainHandleEnd.setDimensions(a+l*(r-i),s,i,h,"0"):(this._mainHandleEnd=new o(this._gantt.getCtx(),a+l*(r-i),s,i,h,"0",this,"mainResizeHandleEnd"),g(this._mainHandleEnd,"end")),t.addChild(this._mainHandleEnd)}},c.prototype.removeHandles=function(t){this._mainHandleStart&&t!==this._mainHandleStart&&(this._mainHandleStart.getParent().removeChild(this._mainHandleStart),this._mainHandleStart=null),this._mainHandleEnd&&t!==this._mainHandleEnd&&(this._mainHandleEnd.getParent().removeChild(this._mainHandleEnd),this._mainHandleEnd=null)},c.prototype.highlight=function(){this._mainShape&&this._mainShape.highlight(),this._mainSelectShape&&this._mainSelectShape.highlight(),this._mainHoverShape&&this._mainHoverShape.highlight(),this._mainCustomContent&&this._mainCustomContent.highlight(),this._baselineShape&&this._baselineShape.highlight(),this._progressShape&&this._progressShape.highlight(),this._attributeShape&&this._attributeShape.highlight(),this._overtimeShape&&this._overtimeShape.highlight(),this._downtimeShape&&this._downtimeShape.highlight()},c.prototype.unhighlight=function(){this._mainShape&&this._mainShape.unhighlight(),this._mainSelectShape&&this._mainSelectShape.unhighlight(),this._mainHoverShape&&this._mainHoverShape.unhighlight(),this._mainCustomContent&&this._mainCustomContent.unhighlight(),this._baselineShape&&this._baselineShape.unhighlight(),this._progressShape&&this._progressShape.unhighlight(),this._attributeShape&&this._attributeShape.unhighlight(),this._overtimeShape&&this._overtimeShape.unhighlight(),this._downtimeShape&&this._downtimeShape.unhighlight()};var _=function(t,e,i){this.Init(t,e,i)};e.Obj.createSubclass(_,e.Obj),_.prototype.Init=function(t,e,i){this._gantt=t,this._container=e,this._associatedShape=i,this._renderState="add"},_.prototype.getGantt=function(){return this._gantt},_.prototype.getAssociatedShape=function(){return this._associatedShape},_.prototype.setAssociatedShape=function(t){this._associatedShape=t},_.prototype.getLabelOutputText=function(){return this._labelOutputText},_.prototype.getEffectiveLabelPosition=function(){return this._effectiveLabelPosition},_.prototype.getRenderState=function(){return this._renderState},_.prototype._applyStyles=function(t){var e;null!=t?((e=n.getTaskLabelStyle(this._gantt.getOptions())).parseInlineStyle(t),this._labelOutputText.setStyle(t)):e=this._gantt.getCache().getFromCache("baseTaskLabelCSSStyle"),this._labelOutputText.setCSSStyle(e)},_.prototype._placeLabel=function(t){var i,a,s,r,o,h,l=this._labelOutputText.getDimensions(),d=e.Agent.isRightToLeft(this._gantt.getCtx()),g=this._gantt.getOptions(),c=n.getTaskPadding(g),_=n.getTaskLabelMargin(g),p=c+_;switch("progress"!==t&&"progressStart"!==t||this.setAssociatedShape(this._container.getTask().getShape("progress")),h="main"===this._associatedShape.getType()&&this._container.getTask().isSummary("main")&&"alta"===this._gantt.getCtx().getThemeBehavior()?this._container.getLayoutObject().height:this._associatedShape.getFinalHeight(),o=this._associatedShape.getFinalY()+(h-l.h)/2,this.setFinalY(o),s=this._associatedShape.getFinalWidth(),i=d?this._associatedShape.getPhysicalEndOffset():this._associatedShape.getPhysicalStartOffset(),a=d?this._associatedShape.getPhysicalStartOffset():this._associatedShape.getPhysicalEndOffset(),t){case"end":d?this._labelOutputText.alignRight():this._labelOutputText.alignLeft(),r=s+a+_;break;case"progress":d?this._labelOutputText.alignLeft():this._labelOutputText.alignRight(),r=s-p;break;case"oProgress":d?this._labelOutputText.alignRight():this._labelOutputText.alignLeft(),r=this._container.getTask().getShape("progress").getFinalWidth()+p;break;case"innerStart":case"progressStart":d?this._labelOutputText.alignRight():this._labelOutputText.alignLeft(),r=-i+p;break;case"innerEnd":d?this._labelOutputText.alignLeft():this._labelOutputText.alignRight(),r=s+a-p;break;case"innerCenter":this._labelOutputText.alignCenter(),r=s/2;break;case"start":d?this._labelOutputText.alignLeft():this._labelOutputText.alignRight(),r=-(i+_)}d&&(r=-r),this.setFinalX(r),this._effectiveLabelPosition=t},_.prototype._getAvailableWidth=function(t){var i,a,s,r,o,h,l,d,g,c,_,p,u,m,b,f,y,v,S,T,D,C,E=this._container.getLayoutObject(),O=this._container.getTask(),k=n.getTaskPadding(this._gantt.getOptions()),w=n.getTaskLabelMargin(this._gantt.getOptions()),A=k+w,R=e.Agent.isRightToLeft(this._gantt.getCtx()),x=this._gantt.getContentLength(),L=!1;switch(C=x-(D=R?x:0),t){case"end":case"end_ABSOLUTE":if(v="end",a=C,r=E.nextAdjacentTaskObj,o=E.nextAdjMilestoneBaselineTaskObj,r&&r.startTime<E.endTime&&r.endTime>E.endTime){y=0;break}for(;r&&r.startTime<E.endTime&&r.endTime<E.endTime;)r=r.nextAdjacentTaskObj;if(r)if((d=r.node)&&d.getParent())a=d.getTaskShapePhysicalBounds("main").startPos;else if(null!=r.startTime||null!=r.endTime){a=O.getTimeSpanDimensions(r.startTime,r.endTime).startPos}if(o)if((g=o.node)&&g.getParent())a=R?Math.max(a,g.getTaskShapePhysicalBounds("baseline").startPos):Math.min(a,g.getTaskShapePhysicalBounds("baseline").startPos);else if(null!=o.startTime||null!=o.endTime){var P=O.getTimeSpanDimensions(o.baselineStartTime,o.baselineEndTime).startPos;a=R?Math.max(a,P):Math.min(a,P)}y=Math.abs(this._container.getTaskShapePhysicalBounds("main").endPos-a)-2*w;break;case"innerCenter":case"innerStart":case"innerEnd":(r=E.nextAdjacentTaskObj)&&("innerCenter"===t?L=r.startTime<E.startTime+(E.endTime-E.startTime)/2:"innerEnd"===t&&(L=r.startTime<E.endTime));case"innerCenter_ABSOLUTE":case"innerStart_ABSOLUTE":case"innerEnd_ABSOLUTE":if("_ABSOLUTE"===t.slice(-"_ABSOLUTE".length)&&(t=t.slice(0,-"_ABSOLUTE".length)),T="number"==typeof this._container.getValue("progress","value"),!O.isMilestone("main")){if(L){y=0,v=t;break}if(_=this._container.getTaskShapePhysicalBounds("main"),b=Math.abs(_.endPos-_.startPos),T){if(S=this._labelOutputText.getDimensions(),(p=O.getShape("progress"))?(u=p.getFinalWidth(),m=p.getFinalHeight()):(u=0,m=0),f=b-u,"innerStart"===t){if(y=u-2*A,S.w<=y&&S.h<=m){v="progressStart";break}}else if("innerEnd"===t&&(y=f-2*A,S.w<y)){v="innerEnd";break}S.h<=m&&u>f?(y=u-2*A,v="progress"):(y=f-2*A,v="oProgress");break}y=b-2*A,v=t;break}y=0,v=t;break;case"start":case"start_ABSOLUTE":if(v="start",i=D,s=E.previousAdjacentTaskObj,h=E.previousAdjacentMilestoneBaselineTaskObj,s&&s.endTime>E.startTime&&s.startTime<E.startTime){y=0;break}if(s)if((l=s.node)&&l.getParent())i=l.getTaskShapePhysicalBounds("main",!0).endPos;else if(null!=s.startTime||null!=s.endTime){i=O.getTimeSpanDimensions(s.startTime,s.endTime).endPos}if(h)if((c=h.node)&&c.getParent())i=R?Math.min(i,c.getTaskShapePhysicalBounds("baseline").endPos):Math.max(i,c.getTaskShapePhysicalBounds("baseline").endPos);else if(null!=h.startTime||null!=h.endTime){var M=O.getTimeSpanDimensions(h.baselineStartTime,h.baselineEndTime).endPos;i=R?Math.max(i,M):Math.min(i,M)}y=Math.abs(i-this._container.getTaskShapePhysicalBounds("main").startPos)-2*w;break;default:return null}return[v,y]},_.prototype._preprocessLabelPosition=function(t){var e=this._container.getTask().isMilestone("main");if("string"==typeof t){if(e)switch(t){case"innerCenter":case"innerEnd":t="end";break;case"innerStart":t="start"}return[t+"_ABSOLUTE"]}return Array.isArray(t)?e?t.map(function(t){switch(t){case"innerCenter":case"innerEnd":return"end";case"innerStart":return"start";default:return t}}):t:[]},_.prototype._evaluatePosition=function(t){for(var i,a,n,s={},r=this._labelOutputText.getDimensions(),o=r.w,h=(r.h,t=this._preprocessLabelPosition(t),0),l=0;l<t.length;l++){var d=t[l];if("max"!==d){if(s[d]?g=s[d]:(g=this._getAvailableWidth(d),s[d]=g),g){if(i=g[0],o<=(a=g[1]))break;a>h&&(h=a,n=d)}}else if(null!=n){var g=s[n];i=g[0],a=g[1];break}}return null!=i&&(o>a&&e.TextUtils.fitText(this._labelOutputText,a,1/0,this._container,1),this._placeLabel(i),!0)},_.prototype.render=function(){var t,i,a=this._container.getValue("label"),n=this._container.getValue("labelPosition"),s=this._container.getValue("labelStyle"),r=this,o=this._gantt.GetStyleClass("taskLabel");this._renderState="exist",null!=a&&a.length>0&&"none"!==n&&this._associatedShape?(null==this._labelOutputText&&(this._labelOutputText=new e.OutputText(this._gantt.getCtx(),a,0,0),this._gantt.getEventManager().IsDragSupported("tasks")&&(o+=" "+this._gantt.GetStyleClass("draggable")),this._labelOutputText.setClassName(o),this._renderState="add"),null==this._labelOutputText.getParent()&&this._container.addChild(this._labelOutputText),this._labelOutputText.setTextString(a),this._applyStyles(s),this._evaluatePosition(n)?(i=function(){var t,i;switch(r._effectiveLabelPosition){case"innerCenter":case"innerEnd":case"innerStart":case"progressStart":case"progress":case"oProgress":i=r._associatedShape.getFillColor(),null!=(t=e.ColorUtils.getContrastingTextColor(i?i.computedFill:null))&&r._labelOutputText.setFill(new e.SolidFill(t))}},t={x:this.getFinalX(),y:this.getFinalY()},this._gantt.getAnimationManager().preAnimateTaskLabel(this._container,t,i)):this.remove()):this.remove()},_.prototype.remove=function(){var t,e=this;this._labelOutputText&&(t=function(){e._container.removeChild(e._labelOutputText),e._labelOutputText=null,e._effectiveLabelPosition=null},this._gantt.getAnimationManager().preAnimateTaskLabelRemove(this._labelOutputText,t))},_.prototype.highlight=function(){this._labelOutputText&&e.ToolkitUtils.addClassName(this._labelOutputText.getElem(),this._gantt.GetStyleClass("taskHighlight"))},_.prototype.unhighlight=function(){this._labelOutputText&&e.ToolkitUtils.removeClassName(this._labelOutputText.getElem(),this._gantt.GetStyleClass("taskHighlight"))},_.prototype.getFinalX=function(){return this._finalX},_.prototype.setFinalX=function(t){this._finalX=t},_.prototype.getFinalY=function(){return this._finalY},_.prototype.setFinalY=function(t){this._finalY=t};var p=function(t){this.Init(t)};e.Obj.createSubclass(p,e.Container),p.prototype.nodeType="task",p.prototype.Init=function(t){p.superclass.Init.call(this,t.getCtx(),null),this._gantt=t,this._task=new c(t,this),this._taskLabel=new _(t,this),this._gantt.getEventManager().associate(this,this)},p.prototype.getId=function(){return this._taskObj.id},p.prototype.setLayoutObject=function(t){this._taskObj=t},p.prototype.getLayoutObject=function(){return this._taskObj},p.prototype.getData=function(t){return t?i.TimeComponent.sanitizeData(this._taskObj.data,"task"):this._taskObj.data},p.prototype.getValue=function(t,e){var i,a=this._gantt.getOptions().taskDefaults;switch(t){case"start":i=this._taskObj.startTime;break;case"end":i=this._taskObj.endTime;break;case"height":i=this._taskObj.height;break;case"baseline":if("height"===e){i=this._taskObj.baselineHeight;break}if((i=this._taskObj.data.baseline)&&null!=e)switch(e){case"start":i=this._taskObj.baselineStartTime;break;case"end":i=this._taskObj.baselineEndTime;break;default:i=null!=i[e]?i[e]:a.baseline[e]}break;case"overtime":if((i=this._taskObj.data.overtime)&&null!=e)switch(e){case"start":i=this._taskObj.overtimeStartTime;break;case"end":i=this._taskObj.overtimeEndTime;break;default:i=null!=i[e]?i[e]:a.overtime[e]}break;case"downtime":if((i=this._taskObj.data.downtime)&&null!=e)switch(e){case"start":i=this._taskObj.downtimeStartTime;break;case"end":i=this._taskObj.downtimeEndTime;break;default:i=null!=i[e]?i[e]:a.downtime[e]}break;case"attribute":if((i=this._taskObj.data.attribute)&&null!=e&&(i=null!=i[e]?i[e]:a.attribute[e],"shortDesc"===e&&"function"==typeof i))return i(p.getShortDescContext(this));break;case"progress":if("height"===e){i=this._taskObj.progressHeight;break}(i=this._taskObj.data.progress)&&null!=e&&(i=null!=i[e]?i[e]:a.progress[e]);break;default:i=null!=this._taskObj.data[t]?this._taskObj.data[t]:a[t]}return"shortDesc"===t&&"function"==typeof i?i(p.getShortDescContext(this)):i},p.prototype.getSandboxValue=function(t,e){var i=this.getSandboxData(),a=this._gantt.getOptions().taskDefaults,n=i[t],s=a[t];return n&&null!=e&&(n=n[e]),s&&null!=e&&(s=s[e]),null!=n?n:s},p.prototype.getSandboxData=function(){if(!this._sandboxData){this._sandboxData=e.JsonUtils.clone(i.TimeComponent.sanitizeData(this._taskObj.data,"task")),this._sandboxData._rowNode=this.getRowNode(),this._sandboxData.start=this._taskObj.startTime,this._sandboxData.end=this._taskObj.endTime,this._sandboxData.height=this._taskObj.height;var t=this._sandboxData.baseline;t&&(t.start=this._taskObj.baselineStartTime,t.end=this._taskObj.baselineEndTime,t.height=this._taskObj.baselineHeight);var a=this._sandboxData.progress;a&&(a.height=this._taskObj.progressHeight)}return this._sandboxData},p.prototype.getRowNode=function(){return this._taskObj.rowObj.node},p.prototype.getGantt=function(){return this._gantt},p.prototype.getRenderState=function(){return this._taskObj.renderState},p.prototype.getPreviousAdjacentTaskObj=function(){return this._taskObj.previousAdjacentTaskObj},p.prototype.getNextAdjacentTaskObj=function(){return this._taskObj.nextAdjacentTaskObj},p.prototype.getPrevAdjMilestoneBaselineTaskObj=function(){return this._taskObj.prevAdjMilestoneBaselineTaskObj},p.prototype.getNextAdjMilestoneBaselineTaskObj=function(){return this._taskObj.nextAdjMilestoneBaselineTaskObj},p.prototype.getTaskShapePhysicalBounds=function(t,i){var a=e.Agent.isRightToLeft(this._gantt.getCtx()),s=this._gantt.getOptions(),r=a?-1:1,o=this._task.getShape(t),h=o.getFinalX()+this.getFinalX(),l=o.getFinalWidth()+o.getPhysicalEndOffset(),d=h-r*o.getPhysicalStartOffset(),g=h+r*l;if(i){var c=this._taskLabel.getLabelOutputText();if(c&&null!=c.getParent()){var _=this._taskLabel.getEffectiveLabelPosition();"end"===_?g+=r*(n.getTaskLabelMargin(s)+c.getDimensions().w):"start"===_&&(d-=r*(n.getTaskLabelMargin(s)+c.getDimensions().w))}}return{startPos:d,endPos:g}},p.prototype.scrollIntoView=function(t,i){var a,s,r,o,h=e.Agent.isRightToLeft(this._gantt.getCtx()),d=this._gantt.getDatabody(),g=this._gantt.getOptions();this._gantt.getDataLayoutManager().ensureInDOM(this.getLayoutObject(),"task");var c,_,p=this._gantt.getEventManager().getKeyboardDnDMode();p===l.KEYBOARD_MOVE&&this._mainDragFeedbacks&&this._mainDragFeedbacks.length>0?(c=this._mainDragFeedbacks[0].getTask().getShape("main"),_=this._mainDragFeedbacks[0]):(p===l.KEYBOARD_RESIZE_START||p===l.KEYBOARD_RESIZE_END)&&this._mainResizeHandleDragFeedbacks&&this._mainResizeHandleDragFeedbacks.length>0?(c=this._mainResizeHandleDragFeedbacks[0].getTask().getShape("main"),_=this._mainResizeHandleDragFeedbacks[0]):(c=(c=this.getTask().getShape("main"))||this.getTask().getShape("baseline"),_=this),r=c.getWidth()+c.getPhysicalStartOffset()+c.getPhysicalEndOffset(),o=c.getHeight(),a=h?c.getX()-r+c.getPhysicalStartOffset():c.getX()-c.getPhysicalStartOffset(),s=c.getY();var u=d.stageToLocal(_.localToStage({x:a,y:s})),m=new e.Rectangle(u.x,u.y,r,o);this._gantt.scrollIntoView(m,t,i,n.getRowPaddingTop(g))},p.prototype.highlight=function(){this._task.highlight(),this._taskLabel.highlight()},p.prototype.unhighlight=function(){this._task.unhighlight(),this._taskLabel.unhighlight()},p.prototype.getDraggedObject=function(){return this._draggedObj},p.prototype.setDraggedObject=function(t){this._draggedObj=t},p.prototype.dragStartSetup=function(){this.hideDnDArtifacts(this._draggedObj)},p.prototype.dragEndCleanup=function(){if(this.hideDnDArtifacts(),this._sandboxData=null,this._gantt.isSelectionSupported()&&this.isSelected())for(var t=this._gantt.getSelectionHandler().getSelection(),e=0;e<t.length;e++){var i=t[e];i&&"task"===i.nodeType&&(i.show(),i.getPredecessorDependencies().forEach(t=>t.show()),i.getSuccessorDependencies().forEach(t=>t.show()))}},p.prototype.dragCancelCleanup=function(){if(this._gantt.isSelectionSupported()&&this.isSelected())for(var t=this._gantt.getSelectionHandler().getSelection(),e=0;e<t.length;e++){var i=t[e];if(i&&"task"===i.nodeType){var a=i.getRowNode();a&&a.showEffect("selected")}}},p.prototype._renderClone=function(t){var e=new p(this._gantt),i=Object.assign({},this._taskObj);i.node=e,e.setLayoutObject(i);var a=this._gantt.getAnimationManager(),n=a.getAnimationMode();a.setAnimationMode("none"),e.render(t);var s=e.getTask(),r=e.getTaskLabel();return r.setAssociatedShape(s.getShape("main")),r.render(),e._selected=!0,s.showMainEffect("selected"),e.setMouseEnabled(!1),a.setAnimationMode(n),e},p.prototype._renderOutlineClone=function(t){var e=this.getTask(),i=e.getShape("main"),a=new o(this._gantt.getCtx(),this.getTranslateX()+i.getFinalX(),this.getTranslateY()+i.getFinalY(),i.getFinalWidth(),i.getFinalHeight(),i.getBorderRadius(),e,"mainDragFeedback");return t.addChildAt(a,0),a},p.prototype._setWidth=function(t){var i=e.Agent.isRightToLeft(this._gantt.getCtx()),n=i?1:-1,s=this._gantt.getStartTime(),r=this._gantt.getEndTime(),o=this._gantt.getContentLength(),h=i?o-this.getTranslateX():this.getTranslateX(),l=a.TimeAxisUtils.getPositionDate(s,r,h,o),d=this.getTranslateX()-n*t;d=i?o-d:d;var g=a.TimeAxisUtils.getPositionDate(s,r,d,o);this._taskObj.startTime=l,this._taskObj.endTime=g,this._taskObj.x=this.getTranslateX(),this._taskObj.y=this.getTranslateY();var c=this._gantt.getAnimationManager(),_=c.getAnimationMode();c.setAnimationMode("none"),this.render(this.getParent(),!0),this.getTaskLabel().render(),this.getTask().showMainEffect("selected"),c.setAnimationMode(_)},p.prototype._getWidth=function(t){return this.getTask().getShape("main").getWidth()},p.prototype.hide=function(t){this.setAlpha(0);var e=this.getRowNode();t&&e&&e.removeEffect("selected")},p.prototype.show=function(){this.setAlpha(1)},p.prototype.showDragFeedback=function(t,i,s,r,o){var h=this._gantt.getEventManager();if(this._draggedObj&&h){var l,d,g,c,_,p,u,m,b=h.getDnDTaskSubType(this._draggedObj),f=e.Agent.isRightToLeft(this._gantt.getCtx()),y=f?1:-1,v=this._gantt.getDnDArtifactsContainer(),S=this._gantt.getStartTime(),T=this._gantt.getEndTime(),D=this._gantt.getContentLength();switch(b){case"tasks":l=o?{deltaX:0,deltaY:0}:this._gantt.autoPanOnEdgeDrag(i,n.getAutoPanEdgeThreshold(),!1,!1),d=r.x+i.x+l.deltaX,g=r.y+i.y+l.deltaY,s&&(s&&"row"===s.nodeType?m=s:s&&"task"===s.nodeType&&(m=s.getRowNode())),this._renderTaskMoveDragFeedback(d,g,v,m),this._renderDependencyLinesDragFeedback(this._mainDragFeedbacks,v);var C=this.getTask().getShape("main");c=f?D-d:d,p=f?D-(d-C.getFinalWidth()):d+C.getFinalWidth(),_=a.TimeAxisUtils.getPositionDate(S,T,c,D),u=a.TimeAxisUtils.getPositionDate(S,T,p,D),this._showDragFeedbackTooltip(t,_,u,this._mainDragFeedbacks[0],"center",m);break;case"taskResizeHandles":l=o?{deltaX:0,deltaY:0}:this._gantt.autoPanOnEdgeDrag(i,n.getAutoPanEdgeThreshold(),!1,!0),d=i.x+l.deltaX,this._renderTaskResizeDragFeedback(d,v),this._renderDependencyLinesDragFeedback(this._mainResizeHandleDragFeedbacks,v);var E="mainResizeHandleEnd"===this._draggedObj.getType();E?(_=this.getValue("start"),p=this._mainResizeHandleDragFeedbacks[0].getTranslateX()-y*this._mainResizeHandleDragFeedbacks[0]._getWidth(),p=f?D-p:p,u=a.TimeAxisUtils.getPositionDate(S,T,p,D)):(c=this._mainResizeHandleDragFeedbacks[0].getTranslateX(),c=f?D-c:c,_=a.TimeAxisUtils.getPositionDate(S,T,c,D),u=this.getValue("end")),this._showDragFeedbackTooltip(t,_,u,this._mainResizeHandleDragFeedbacks[0],E?"end":"start")}}},p.prototype._showDragFeedbackTooltip=function(t,i,a,n,s,r){var o=e.Agent.isRightToLeft(this._gantt.getCtx()),h=this.getSandboxData();r&&(h._rowNode=r),h.start=i,h.end=a;var l,d=n.getDimensions(this.getCtx().getStage());switch(s){case"start":l=new e.Point(d.x+o*d.w,d.y);break;case"end":l=new e.Point(d.x+!o*d.w,d.y);break;default:l=d.getCenter()}var g=this.getCtx().stageToPageCoords(l.x,l.y);this._gantt.getEventManager().ProcessObjectTooltip(t,g.x,g.y,this,n.getElem())},p.prototype._renderTaskMoveDragFeedback=function(t,i,s,r){var o=this._gantt.getOptions(),h=e.Agent.isRightToLeft(this._gantt.getCtx()),l=this._gantt.getStartTime(),d=this._gantt.getEndTime(),g=this._gantt.getContentLength(),c=this.getTask().getShape("main"),_=r.localToStage({x:0,y:r.getFinalY()+n.getRowPaddingTop(o)}),p=this._gantt.getDnDArtifactsContainer().stageToLocal(_).y,u=function(t,e,i){t.setTranslate(e,i),t._taskObj.x=e,t._taskObj.y=i};if(this._mainDragFeedbacks)for(var m=0;m<this._mainDragFeedbacks.length;m++){var b=this._mainDragFeedbacks[m],f=this._mainDragFeedbackOffsets[m],y=t+f.x;if(u(b,y,i+f.y),0===m){var v=this._mainDropOutlineFeedbacks[m];v.setX(y),v.setY(p)}this._mainDragFeedbackStartTimes[m]=a.TimeAxisUtils.getPositionDate(l,d,h?g-y:y,g)}else{this.hide(!0);var S=this._renderOutlineClone(s),T=this._renderOutlineClone(s);T.setX(t),T.setY(i);var D=this._renderClone(s);if(u(D,t,i),this._mainDragFeedbacks=[D],this._mainDragOutlineFeedbacks=[S],this._mainDropOutlineFeedbacks=[T],this._mainDragFeedbackOffsets=[new e.Point(0,0)],this._mainDragFeedbackStartTimes=[this.getValue("start")],this._gantt.isSelectionSupported()&&this.isSelected()&&this._gantt.getSelectionHandler().getSelectedCount()>1){var C=this._gantt.getSelectionHandler().getSelection();for(m=0;m<C.length;m++){var E=C[m];if(E&&"task"===E.nodeType&&E!==this){var O=E.getTask().getShape("main"),k=O.getX()+E.getTranslateX()-(c.getX()+this.getTranslateX()),w=O.getY()+E.getTranslateY()-(c.getY()+this.getTranslateY()),A=t+k,R=i+w;E.hide(!0);var x=E._renderOutlineClone(s);u(b=E._renderClone(s),A,R),this._mainDragFeedbacks.push(b),this._mainDragOutlineFeedbacks.push(x),this._mainDragFeedbackOffsets.push(new e.Point(k,w)),this._mainDragFeedbackStartTimes.push(E.getValue("start"))}}}}},p.prototype._renderTaskResizeDragFeedback=function(t,i){var a,n,s=e.Agent.isRightToLeft(this._gantt.getCtx()),r=s?1:-1,o=this.getTask().getShape("main"),h="mainResizeHandleEnd"===this._draggedObj.getType();h?(a=o.getFinalX()+this.getTranslateX(),n=s?Math.min(t,a):Math.max(t,a)):(a=o.getFinalX()-r*o.getFinalWidth()+this.getTranslateX(),n=s?Math.max(t,a):Math.min(t,a));var l=Math.abs(n-a)-o.getFinalWidth(),d=function(t,e,i){t.setTranslate(e,i),t._taskObj.x=e,t._taskObj.y=i};if(this._mainResizeHandleDragFeedbacks)for(var g=0;g<this._mainResizeHandleDragFeedbacks.length;g++){var c=this._mainResizeHandleDragFeedbacks[g],_=this._mainResizeHandleDragFeedbackSources[g],p=_.getTask().getShape("main"),u=Math.max(0,p.getFinalWidth()+l);if(!h){var m=p.getFinalX()-r*p.getFinalWidth()+_.getTranslateX();c.setTranslateX(m+r*u),c._taskObj.x=c.getTranslateX()}c._setWidth(u)}else{this.hide();var b=this._renderClone(i);if(d(b,h?a:n,o.getFinalY()+this.getTranslateY()),this._mainResizeHandleDragFeedbacks=[b],this._mainResizeHandleDragFeedbackSources=[this],this._gantt.isSelectionSupported()&&this.isSelected()&&this._gantt.getSelectionHandler().getSelectedCount()>1){var f=this._gantt.getSelectionHandler().getSelection();for(g=0;g<f.length;g++){var y=f[g];if(y&&"task"===y.nodeType&&y!==this){var v,S=y.getTask().getShape("main"),T=S.getFinalWidth()+l;v=h?S.getFinalX()+y.getTranslateX():S.getFinalX()-r*S.getFinalWidth()+y.getTranslateX()+r*T,y.hide(),d(c=y._renderClone(i),v,S.getFinalY()+y.getTranslateY()),this._mainResizeHandleDragFeedbacks.push(c),this._mainResizeHandleDragFeedbackSources.push(y)}}}}},p.prototype._renderDependencyLinesDragFeedback=function(t,e){if(this._mainDependencyLineDragFeedbacks)this._mainDependencyLineDragFeedbacks.forEach(t=>t.render(e,!0));else{this._mainDependencyLineDragFeedbacks=[];const i=new Map;if(this._gantt.isSelectionSupported()&&this.isSelected()){this._gantt.getSelectionHandler().getSelection().forEach(t=>{const e=t.getPredecessorDependencies(),a=t.getSuccessorDependencies();e.forEach(t=>{t.hide(),i.set(t.getLayoutObject(),Object.assign({},t.getLayoutObject()))}),a.forEach(t=>{t.hide(),i.set(t.getLayoutObject(),Object.assign({},t.getLayoutObject()))})})}t.forEach(t=>{const e=t.getLayoutObject();e.predecessorDepObjs=e.predecessorDepObjs.map(t=>{const a=i.get(t);return a.successorTaskObj=e,a}),e.successorDepObjs=e.successorDepObjs.map(t=>{const a=i.get(t);return a.predecessorTaskObj=e,a})}),i.forEach((t,i)=>{const a=new s(this._gantt);a.setLayoutObject(t),t.node=a,a.render(e),a.setMouseEnabled(!1),this._mainDependencyLineDragFeedbacks.push(a)})}},p.prototype._updateDragFeedbacks=function(){var t,i,n,s,r=e.Agent.isRightToLeft(this._gantt.getCtx()),o=this._gantt.getStartTime(),h=this._gantt.getEndTime(),l=this._gantt.getContentLength();if(this._mainDragFeedbacks){var d=a.TimeAxisUtils.getDatePosition(o,h,this._mainDragFeedbackStartTimes[0],l);d=r?l-d:d;for(var g=0;g<this._mainDragFeedbacks.length;g++){t=this._mainDragFeedbacks[g],n=this._mainDragOutlineFeedbacks[g],i=a.TimeAxisUtils.getDatePosition(o,h,this._mainDragFeedbackStartTimes[g],l),i=r?l-i:i,this._mainDragFeedbackOffsets[g].x=i-d;var c=this.getTask().getShape("main"),_=c.getFinalWidth();t.setTranslateX(i),t._taskObj.x=t.getTranslateX(),t._setWidth(_),n.setX(c.getFinalX()+this.getFinalX()),n.setWidth(_),0===g&&((s=this._mainDropOutlineFeedbacks[g]).setX(i),s.setWidth(_)),0===g&&this._gantt.getEventManager()._keyboardDnDFeedbackLocalPos&&(this._gantt.getEventManager()._keyboardDnDFeedbackLocalPos.x=i)}}if(this._mainResizeHandleDragFeedbacks)for(g=0;g<this._mainResizeHandleDragFeedbacks;g++){t=this._mainResizeHandleDragFeedbacks[g];var p=a.TimeAxisUtils.getDatePosition(o,h,this._mainResizeHandleDragFeedbackSources[g].getValue("start"),l),u=a.TimeAxisUtils.getDatePosition(o,h,this._mainResizeHandleDragFeedbackSources[g].getValue("end"),l);i=r?l-p:p,t.setTranslateX(i),t._taskObj.x=t.getTranslateX(),t._setWidth(Math.abs(u-p)),0===g&&this._gantt.getEventManager()._keyboardDnDFeedbackLocalPos&&(this._gantt.getEventManager()._keyboardDnDFeedbackLocalPos.x=i)}this._mainDependencyLineDragFeedbacks&&this._mainDependencyLineDragFeedbacks.forEach(t=>t.render(t.getParent(),!0))},p.prototype.removeDragFeedbacks=function(){if(this._mainDragFeedbacks){for(var t=0;t<this._mainDragFeedbacks.length;t++)this._mainDragFeedbacks[t].getParent().removeChild(this._mainDragFeedbacks[t]),this._mainDragOutlineFeedbacks[t].getParent().removeChild(this._mainDragOutlineFeedbacks[t]);this._mainDropOutlineFeedbacks[0].getParent().removeChild(this._mainDropOutlineFeedbacks[0]),this._mainDragFeedbacks=null,this._mainDragOutlineFeedbacks=null,this._mainDropOutlineFeedbacks=null,this._mainDragFeedbackOffsets=null,this._mainDragFeedbackStartTimes=null}if(this._mainDependencyLineDragFeedbacks){for(t=0;t<this._mainDependencyLineDragFeedbacks.length;t++)this._mainDependencyLineDragFeedbacks[t].getParent().removeChild(this._mainDependencyLineDragFeedbacks[t]);this._mainDependencyLineDragFeedbacks=null}if(this._mainResizeHandleDragFeedbacks){for(t=0;t<this._mainResizeHandleDragFeedbacks.length;t++)this._mainResizeHandleDragFeedbacks[t].getParent().removeChild(this._mainResizeHandleDragFeedbacks[t]);this._mainResizeHandleDragFeedbacks=null,this._mainResizeHandleDragFeedbackSources=null}this._gantt.getEventManager().hideTooltip()},p.prototype.hideDnDArtifacts=function(t){this.removeDragFeedbacks()},p.prototype.getTask=function(){return this._task},p.prototype.getTaskLabel=function(){return this._taskLabel},p.prototype.render=function(t,i){var a;i=!1!==i;this._gantt.getEventManager().isDnDDragging()||this.show(),this.isSelectable()&&this.setCursor(e.SelectionEffectUtils.getSelectingCursor()),this.getParent()!=t&&t.addChild(this),this._task.render(i),this._getAriaTarget().setAriaRole("img"),this.refreshAriaLabel(),this._updateDragFeedbacks(),a={x:this.getFinalX(),y:this.getFinalY()},this._gantt.getAnimationManager().preAnimateTaskNode(this,a)},p.prototype.remove=function(){var t,e=this;t=function(){e.getRowNode().removeChild(e)},this._gantt.getAnimationManager().preAnimateTaskNodeRemove(this,t)},p.prototype.getPredecessorDependencies=function(){var t=this._gantt.getDataLayoutManager();return this._taskObj.predecessorDepObjs.map(function(e){return e.node||t.ensureInDOM(e,"dependency"),e.node})},p.prototype.getSuccessorDependencies=function(){var t=this._gantt.getDataLayoutManager();return this._taskObj.successorDepObjs.map(function(e){return e.node||t.ensureInDOM(e,"dependency"),e.node})},p.prototype.getFinalX=function(){return this._taskObj.x},p.prototype.getFinalY=function(){return this._taskObj.y},p.prototype.getFinalHeight=function(t){return this._task.getFinalHeight(t)},p.prototype.getDuration=function(t,i){var a=this._gantt.getOptions().translations,n=i-t,s=this._gantt.getMinorAxis().getScale();return"hours"===s||"minutes"===s||"seconds"===s?(n=Math.round(n/36e5*100)/100,e.ResourceUtils.format(a.accessibleDurationHours,[n])):(n=Math.round(n/864e5*100)/100,e.ResourceUtils.format(a.accessibleDurationDays,[n]))},p.prototype.getAriaLabel=function(){var t=[],i=this._gantt.getOptions().translations,n=this.getLayoutObject().rowObj,s="";if(this._gantt.isRowsHierarchical()&&(s=i.labelLevel+" "+n.depth+", "),null!=this._gantt.getRenderState()){var r=n.data.label;return null==r&&(r=i.labelRow+" "+n.index+1),r=s+r,null!=n.expanded&&t.push(i[n.expanded?"stateExpanded":"stateCollapsed"]),e.Displayable.generateAriaLabel(r,t)}this.isSelectable()&&t.push(i[this.isSelected()?"stateSelected":"stateUnselected"]),null!=(n=this.getLayoutObject().rowObj).expanded&&t.push(i.labelRow+" "+i[n.expanded?"stateExpanded":"stateCollapsed"]);var o=h.getDatatip(this,!1,!0);this._task.isMilestone("main")?o=i.accessibleTaskTypeMilestone+", "+o:this._task.isSummary("main")&&(o=i.accessibleTaskTypeSummary+", "+o),o=s+o;var l=this._taskObj.predecessorDepObjs,d=this._taskObj.successorDepObjs;if(l.length>0||d.length>0){var g="";if(l.length>0&&(g=e.ResourceUtils.format(i.accessiblePredecessorInfo,[l.length]),a.TimeAxisUtils.supportsTouch()||e.Agent.isEnvironmentTest()))for(var c=0;c<l.length;c++)g=g+", "+l[c].ariaLabel;if(d.length>0&&(g.length>0&&(g+=", "),g+=e.ResourceUtils.format(i.accessibleSuccessorInfo,[d.length]),a.TimeAxisUtils.supportsTouch()||e.Agent.isEnvironmentTest()))for(c=0;c<d.length;c++)g=g+", "+d[c].ariaLabel;g.length>0&&(o=o+", "+g)}var _=e.Displayable.generateAriaLabel(o,t),p=this.getAriaProperty("label");return null!=p&&p.indexOf(_)>-1?null:_},p.prototype._getAriaTarget=function(){var t=this.getTask().getShape("main");return e.Agent.isTouchDevice()&&this._gantt.isTaskResizeEnabled()&&t?t:this},p.prototype.refreshAriaLabel=function(){this._updateAriaLabel()},p.prototype._updateAriaLabel=function(){e.Agent.deferAriaCreation()||this._getAriaTarget().setAriaProperty("label",this.getAriaLabel())},p.prototype.getDataContext=function(){var t=this.getData()._itemData,e=this.getTask().getFillColor();return{data:this.getData(!0),rowData:this.getRowNode().getData(!0),itemData:t||null,color:e?e.fill:null,component:this._gantt.getOptions()._widgetConstructor}},p.getShortDescContext=function(t){var e=t.getData()._itemData;return{data:t.getData(!0),rowData:t.getRowNode().getData(!0),itemData:e||null}},p.prototype.getSandboxDataContext=function(){var t=this.getSandboxData();if(t.start=new Date(t.start).toISOString(),t.end=new Date(t.end).toISOString(),t.baseline){var e=t.baseline.start,i=t.baseline.end;t.baseline.start=null!=e?new Date(e).toISOString():null,t.baseline.end=null!=i?new Date(i).toISOString():null}var a=this._taskObj.data._itemData;return{data:t,rowData:t._rowNode.getData(!0),itemData:a||null,color:h.getDatatipColor(this),component:this._gantt.getOptions()._widgetConstructor}},p.prototype._setSelected=function(t,e){if(this._selected=t,this._selected?this._task.showEffect("selected"):this._task.removeEffect("selected",e),this.refreshAriaLabel(),this._gantt.setCurrentRow(this.getRowNode().getId()),"straight"===this._gantt.getOptions().dependencyLineShape&&"normal"===this._gantt.getOptions().selectionBehavior){var i=this._gantt.getDependenciesContainer();this.getPredecessorDependencies().forEach(function(t){t.render(i,!1)}),this.getSuccessorDependencies().forEach(function(t){t.render(i,!1)})}},p.prototype.clearSelectionState=function(){this._setSelected(!1,!1)},p.prototype.getDatatip=function(){return h.getDatatip(this,!0)},p.prototype.getDatatipColor=function(){return h.getDatatipColor(this)},p.prototype.isSelectable=function(){return"none"!=this._gantt.getOptions().selectionMode},p.prototype.isSelected=function(){return this._selected},p.prototype.setSelected=function(t){this._setSelected(t,!0)},p.prototype.showHoverEffect=function(){this._task.showEffect("hover")},p.prototype.hideHoverEffect=function(){this._task.removeEffect("hover")},p.prototype.getNextNavigable=function(t){var i=e.Agent.isRightToLeft(this._gantt.getCtx()),a=this._gantt.getEventManager().getKeyboardHandler();if(t.type===e.MouseEvent.CLICK||a.isMultiSelectEvent(t))return this;if(t.altKey&&(t.keyCode===e.KeyboardEvent.OPEN_ANGLED_BRACKET||t.keyCode===e.KeyboardEvent.CLOSE_ANGLED_BRACKET)&&a&&a.getFirstNavigableDependencyLine){var n;n=e.Agent.isRightToLeft(this.getGantt().getCtx())?t.keyCode===e.KeyboardEvent.CLOSE_ANGLED_BRACKET?"predecessor":"successor":t.keyCode===e.KeyboardEvent.OPEN_ANGLED_BRACKET?"predecessor":"successor";var s=this._gantt.getNavigableDependencyLinesForTask(this,n),r=a.getFirstNavigableDependencyLine(this,t,s);return r&&r.setKeyboardFocusTask(this),r}return this._gantt.isRowAxisEnabled()&&t.altKey&&(!i&&t.keyCode===e.KeyboardEvent.LEFT_ARROW||i&&t.keyCode===e.KeyboardEvent.RIGHT_ARROW)?this.getRowNode().getRowLabelContent():a.isNavigationEvent(t)&&null==this._gantt.getEventManager().getKeyboardDnDMode()?d.getNextNavigable(this._gantt,this,t):null},p.prototype.getTargetElem=function(){return this._task.getShape("main").getElem()},p.prototype.getKeyboardBoundingBox=function(t){return this.getDimensions(t)},p.prototype.showKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!0,this._task.showEffect("focus");var t=this._gantt.getViewportStartTime(),e=this._gantt.getViewportEndTime();this.scrollIntoView(),this._gantt.getViewportStartTime()===t&&this._gantt.getViewportEndTime()===e||this._gantt.dispatchEvent(this._gantt.createViewportChangeEvent())},p.prototype.hideKeyboardFocusEffect=function(){this.isShowingKeyboardFocusEffect()&&(this._isShowingKeyboardFocusEffect=!1,this.hideHoverEffect())},p.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},p.prototype.isDragAvailable=function(t){return!0},p.prototype.getDragTransferable=function(t,e){return[this.getId()]},p.prototype.getDragFeedback=function(t,e){return null};var u=function(t){this.Init(t)};e.Obj.createSubclass(u,e.Container),u.prototype.nodeType="row",u.prototype.Init=function(t){u.superclass.Init.call(this,t.getCtx(),null),this._gantt=t,this._referenceObjects=[],this._gantt.getEventManager().associate(this,this)},u.prototype.getId=function(){return this._rowObj.id},u.prototype.getGantt=function(){return this._gantt},u.prototype.setLayoutObject=function(t){this._rowObj=t},u.prototype.getLayoutObject=function(){return this._rowObj},u.prototype.getData=function(t){return t?i.TimeComponent.sanitizeData(this._rowObj.data,"row"):this._rowObj.data},u.prototype.getIndex=function(){return this._rowObj.index},u.prototype.getFinalY=function(){return this._rowObj.y},u.prototype.getLabel=function(){return this._rowObj.data.label},u.prototype.setRowLabelContent=function(t){var e=this._gantt.getEventManager(),i=e.getFocus();this._rowLabelContent!==i&&i instanceof r&&i.getRow()===this&&(e.setFocus(t),t.showKeyboardFocusEffect()),this._rowLabelContent=t},u.prototype.getRowLabelContent=function(){return this._rowLabelContent},u.prototype.getRowAxisHorizontalLine=function(){return this._rowAxisHorizontalLine},u.prototype.getRenderState=function(){return this._rowObj.renderState},u.prototype.getTaskObjs=function(){return this._rowObj.taskObjs},u.prototype.getRenderOrderTaskObjs=function(t){var e=t?t.sort(function(t,e){return t.startTime-e.startTime}):this._rowObj.taskObjs;if(this._rowObj.earliestOverlayTaskObj){var i=[],a=[];return e.forEach(function(t){"overlay"===t.overlapBehavior?i.push(t):a.push(t)}),a.concat(i)}return e},u.prototype._renderTasks=function(t){t&&t.tasksDelete.forEach(function(t){t.node.remove()});var e,i=this.getRenderOrderTaskObjs(t?[...t.tasksAdd,...t.tasksUpdate]:null),a=t?t.tasksAdd:new Set,n=!t||t.updateRender;for(let t=0;t<i.length;t++){var s=(d=i[t]).node;s||((s=new p(this._gantt)).setLayoutObject(d),d.node=s);var r=a.has(d);if(n||r){var o=s.getTask(),h=o.getTimeSpanDimensions(s.getValue("start"),s.getValue("end"));h||(h=o.getTimeSpanDimensions(s.getValue("baseline","start"),s.getValue("baseline","end"))),d.x=h.startPos,s.render(this,!0)}!r&&e&&a.has(e)&&this.addChild(s),e=d}var l=function(t){var e=t.node,i=e.getTaskLabel(),a=e.getTask();i.setAssociatedShape(a.getShape("main")),i.render(),this._gantt.isTaskResizeEnabled()?a.renderMainResizeHandles(e):a.removeHandles()}.bind(this);for(let t=0;t<i.length;t++){var d=i[t];r=a.has(d);if(n||r)r&&!n&&d.previousAdjacentTaskObj&&!a.has(d.previousAdjacentTaskObj)&&d.previousAdjacentTaskObj.node&&d.previousAdjacentTaskObj.node.getParent()&&l(d.previousAdjacentTaskObj),l(d);else if(a.has(d.previousAdjacentTaskObj))for(var g=d;g&&!a.has(g);){var c=g.node.getTaskLabel(),_=c.getEffectiveLabelPosition();l(g),g=_===c.getEffectiveLabelPosition()?null:g.nextAdjacentTaskObj}}},u.prototype.render=function(t,e){this._renderTasks(e),this._renderBackground(this._gantt,this._gantt.getDatabodyBackground()),this._renderReferenceObjects(this._gantt,this._gantt.getRowReferenceObjectsContainer()),this._renderHorizontalGridline(this._gantt,this),t&&(this._gantt.isRowAxisEnabled()&&this._gantt.getRowAxis()&&this._finalizeRowLabelRender(this._gantt),t.addChild(this))},u.prototype._finalizeRowLabelRender=function(t){var i=e.Agent.isRightToLeft(t.getCtx()),a=this.getRowLabelContent(),s=this.getFinalY(),r=this._rowObj.height,o=n.getRowLabelPadding(t.getOptions()),h=t.getRowAxis();if("g"===a.getDisplayableType())var l=i?h.getWidth()-o:o;else{var d=a.getDisplayable();d.isTruncated()&&d.setTextString(d.getUntruncatedTextString()),e.TextUtils.fitText(d,h.getWidth()-2*o,r,d.getParent(),1),i?(d.alignRight(),l=h.getWidth()-o):l=o}var g=s-a.getYTopOffset()+(r-a.getHeight())/2;a.setRow(this);var c={x:l,y:g,backgroundX:.5,backgroundY:this._rowObj.y+.5,backgroundWidth:h.getWidth()-.5,backgroundHeight:this._rowObj.height-.5},_=this.getLabelState();_&&(a.setY(_.y),a.setX(_.x),a.getBackground().setRect(_.backgroundX,_.backgroundY,h.getWidth(),_.backgroundHeight));this.recordLabelState(c),this._gantt.getAnimationManager().preAnimateRowLabel(this,a,c)},u.prototype._renderBackground=function(t,i){var a,n=this._rowObj.y,s=t.getContentLength(),r=this._rowObj.height,o="exist";this._background||(this._background=new e.Rect(t.getCtx(),0,n,s,r),this._background.setPixelHinting(!0),this._background.setClassName(t.GetStyleClass("row")),o="add",this._gantt.getEventManager().associate(this._background,this)),i.addChild(this._background),a={y:n,w:s,h:r},this._gantt.getAnimationManager().preAnimateRowBackground(this._background,a,o)},u.prototype._renderReferenceObjects=function(t,e){var i=this._rowObj.data.referenceObjects||[],a=t.getEventManager(),n=t.getAnimationManager(),s=this._rowObj.y,r=s+this._rowObj.height,o=s,h=r;this._referenceObjects.length>0&&(o=this._referenceObjects[0].getY1(),h=this._referenceObjects[0].getY2()),this._referenceObjects.forEach(t=>e.removeChild(t)),this._referenceObjects=t.generateReferenceObjects(i,"area"),this._referenceObjects.forEach(t=>{a.associate(t,this),t.render(e,o,h),n.preAnimateRowReferenceObject(t,{y1:s,y2:r})})},u.prototype.getBackground=function(){return this._background},u.prototype._renderHorizontalGridline=function(t,i){var a,s,r,o,h="exist",l=t.GetStyleClass("hgridline"),d=n.getHorizontalGridlineWidth(t.getOptions())%2*.5,g=this._gantt.getRowAxis(),c=this._gantt.isRowAxisEnabled()&&g;if(t.isHorizontalGridlinesVisible()){if(r=s=this._rowObj.y+this._rowObj.height+d,0,a=t.getContentLength(),this._horizontalLine||(this._horizontalLine=new e.Line(t.getCtx(),0,s,a,r),this._horizontalLine.setPixelHinting(!0),this._horizontalLine.setMouseEnabled(!1),this._horizontalLine.setClassName(l,!0),i.addChild(this._horizontalLine),h="add"),o={x1:0,x2:a,y1:s,y2:r},this._gantt.getAnimationManager().preAnimateHorizontalGridline(this._horizontalLine,o,h),c){var _={x1:0,x2:g.getWidth(),y1:s,y2:r};this._rowAxisHorizontalLine||(this._rowAxisHorizontalLine=new e.Line(this._gantt.getCtx(),this._horizontalLine.getX1(),this._horizontalLine.getY1(),_.x2,this._horizontalLine.getY2()),this._rowAxisHorizontalLine.setPixelHinting(!0),this._rowAxisHorizontalLine.setClassName(l,!0)),g.addHorizontalLine(this._rowAxisHorizontalLine),this._gantt.getAnimationManager().preAnimateHorizontalGridline(this._rowAxisHorizontalLine,_,h)}}else this._horizontalLine&&i.removeChild(this._horizontalLine),this._horizontalLine=null,this._rowAxisHorizontalLine&&g.removeHorizontalLine(this._rowAxisHorizontalLine),this._rowAxisHorizontalLine=null},u.prototype.showEffect=function(t){e.ToolkitUtils.addClassName(this._background.getElem(),this._gantt.GetStyleClass(t));var i=this.getRowLabelContent();if(i){var a=i.getBackground();a&&e.ToolkitUtils.addClassName(a.getElem(),this._gantt.GetStyleClass(t))}},u.prototype.removeEffect=function(t){e.ToolkitUtils.removeClassName(this._background.getElem(),this._gantt.GetStyleClass(t));var i=this.getRowLabelContent();if(i){var a=i.getBackground();a&&e.ToolkitUtils.removeClassName(a.getElem(),this._gantt.GetStyleClass(t))}},u.prototype.recordLabelState=function(t){this._rowLabelState=t},u.prototype.getLabelState=function(){return this._rowLabelState},u.prototype.remove=function(){var t,e=this;t=function(){if(e._background){var t=e._background.getParent();t&&t.removeChild(e._background)}var i=e.getParent();i&&i.removeChild(e)},this._gantt.getAnimationManager().preAnimateRowNodeRemove(this,t),this._removeRowLabel()},u.prototype._removeRowLabel=function(){var t,e,i=this.getRowLabelContent(),a=this._gantt.getRowAxis(),n=this;i&&a&&(t=i.getDisplayable())&&(null==t.getParent()&&(i.ensureInDOM(),this._gantt.isHorizontalGridlinesVisible()&&a.addHorizontalLine(this._rowAxisHorizontalLine)),e=function(){i.remove(),a.removeHorizontalLine(n._rowAxisHorizontalLine)},this._gantt.getAnimationManager().preAnimateRowLabelRemove(i,this._rowAxisHorizontalLine,e))},u.prototype.getDataContext=function(){return{rowData:this.getData(!0),component:this._gantt.getOptions()._widgetConstructor}},u.prototype.scrollIntoView=function(){var t=this._gantt.getViewportDimensions(),e=Math.min(this._rowObj.y-t.y,0),i=Math.max(0,this._rowObj.y+this._rowObj.height-(t.y+t.h)),a=e<0?e:i;this._gantt.panBy(0,a)};var m=function(t){this.Init(t)};e.Obj.createSubclass(m,e.Obj),m.VPC_TRANSLATE="vpc_translate",m.VPC_SCALE="vpc_scale",m.VPC_ANIMATE="vpc_animate",m.VPC_REFRESH="vpc_refresh",m.prototype.Init=function(t){this._gantt=t,this._ctx=t.getCtx(),this._rowObjs=[],this._dependencyObjs=[],this._contentHeight=0,this._prevHighlightedTaskObjs=[]},m.prototype.clear=function(){this._rowObjs=[],this._dependencyObjs=[],this._contentHeight=0,this._prevViewport=null},m.prototype.getRowObjs=function(){return this._rowObjs},m.prototype.getDependencyObjs=function(){return this._dependencyObjs},m.prototype.getContentHeight=function(){return this._contentHeight},m.prototype._getTime=function(t){if(null==t||""===t)return null;var e=new Date(t).getTime();return isNaN(e)?null:e},m.prototype._isIntervalOverlap=function(t,e,i,a,n){return(n=!1!==n)?t<=a&&i<=e:t<a&&i<e},m.prototype._isOverlap=function(t,e){return this._isIntervalOverlap(t.overallStartTime,t.overallEndTime,e.overallStartTime,e.overallEndTime,!1)},m.prototype._calcTaskHeight=function(t){var e=this._gantt.getOptions(),i=this._gantt.getCtx(),a=e.taskDefaults,s=t.data,r=s.progress,o=s.baseline,h=!1,l=s.type?s.type:a.type,d=null!=s.height?s.height:a.height,g=0,c=n.getBaselineMarginTop(e);!o||null==t.baselineStartTime&&null==t.baselineEndTime||(g=null!=o.height?o.height:a.baseline.height,h="milestone"===l||"auto"===l&&t.baselineStartTime===t.baselineEndTime,null==o.height&&a.baseline.height===n.getBaselineTaskHeight(e)&&(g=h?n.getActualTaskHeight(e,i):a.baseline.height),null==s.height&&a.height===n.getStandaloneTaskHeight(e)&&(d=n.getActualTaskHeight(e,i))),t.height=d,t.baselineHeight=g,t.overtimeHeight=d,t.downtimeHeight=n.getTaskDowntimeHeight(e),t.attributeHeight=n.getTaskAttributeHeight(e);var _=g>0?c:0,p=h?n.getMilestoneBaselineYOffset(e)+Math.max(g,d):d+_+g;if(t.overallHeightNoProgress=p,t.overallHeight=p,t.progressHeight=0,!("milestone"===l||"auto"===l&&t.startTime===t.endTime&&null!=t.startTime)&&r&&"number"==typeof r.value){var u=null!=r.height?r.height:a.progress.height;u="100%"===u?d:n.getSizeInPixels(u,d),t.progressHeight=u,d<u&&(t.overallHeight=Math.max(u,(u-d)/2+p))}},m.prototype._clearAdjacency=function(t){t.previousAdjacentTaskObj=null,t.nextAdjacentTaskObj=null,t.prevAdjMilestoneBaselineTaskObj=null,t.nextAdjMilestoneBaselineTaskObj=null},m.prototype._trackRowLevelBaselineMilestones=function(t,e){for(var i=t.taskObjs,a=[],n=0;n<e;n++)a.push([]);for(var s=0;s<i.length;s++){var r=i[s],o=this._gantt.getOptions().taskDefaults,h=r.data,l=h.type?h.type:o.type;("milestone"===l||"auto"===l&&r.baselineStartTime===r.baselineEndTime)&&a[r._rowLevel].push(r)}for(n=0;n<e;n++)a[n].sort(function(t,e){return e.baselineStartTime-t.baselineStartTime});for(s=0;s<i.length;s++){var d=a[(r=i[s])._rowLevel],g=d.length;if(g>0){var c=d[g-1],_=c.baselineStartTime,p=r.startTime,u=r.endTime;_<p?(r.prevAdjMilestoneBaselineTaskObj=c,d.pop()):_>u&&null==r.nextAdjMilestoneBaselineTaskObj?r.nextAdjMilestoneBaselineTaskObj=c:_!==p&&_!==u||d.pop()}}},m.prototype._calcRowTaskYHeight=function(t,e){for(var i,a=t.taskObjs,s=this._gantt.getOptions(),r=s.rowDefaults.height,o=s.taskDefaults.overlap.behavior,h=s.taskDefaults.overlap.offset,l=[],d=[],g=0;g<a.length;g++){var c=a[g];this._calcTaskHeight(c),this._clearAdjacency(c);var _=c.data,p=_.overlap?_.overlap.behavior:null,u=null!=p?p:o;u="auto"===u?null==r?"stack":"stagger":u,c.overlapBehavior=u;var m=h;if("overlay"===u&&null==i&&(i=c),0!==g){var b=a[g-1],f=this._isOverlap(c,b);f?C.push(c):(C=[c],l.push(C));var y=m||0,v=0;switch(u){case"stack":for(var S=!0,T=0;T<d.length;T++){var D=null;if(!this._isOverlap(c,d[T])){D=d[T],d[T]=c,S=!1;break}v+=1}S&&d.push(c),c.y=null!=m?v*m:0,D&&(c.previousAdjacentTaskObj=D,D.nextAdjacentTaskObj=c);break;case"stagger":f?(c._rowLevel=b._rowLevel,d[b._rowLevel]=c,c._staggerDirection=null!=b._staggerDirection?-b._staggerDirection:-1,c.y=b.y-c._staggerDirection*y):(d[v]=c,c._staggerDirection=1,c.y=0),c.previousAdjacentTaskObj=b,b.nextAdjacentTaskObj=c;break;case"overlay":d[v]=c,c.y=0}c._rowLevel=v}else{d.push(c),c._rowLevel=0;var C=[c];l.push(C),"stagger"===u&&(c._staggerDirection=1),c.y=0}}t.earliestOverlayTaskObj=i;var E=n.getRowPaddingTop(s),O=n.getRowPaddingBottom(s),k="alta"===this._gantt.getCtx().getThemeBehavior()?"overallHeight":"height";if(null==r)if(null==m){var w=d.map(function(){return 0});a.forEach(function(t){t[k]>w[t._rowLevel]&&(w[t._rowLevel]=t[k])});var A=w.map(function(t){return t+E+O}).reduce(function(t,e,i){return t.push((t[i-1]||0)+e),t},[]);a.forEach(function(t){t.y+=(A[t._rowLevel-1]||0)+E}),this._trackRowLevelBaselineMilestones(t,d.length)}else a.forEach(function(t){0===t._rowLevel&&(t.y+=E)});var R=l.map(function(t){var e=0;return t.forEach(function(t){var i=t.y+t[k];i>e&&(e=i)}),e});if(null==r){if(0===a.length)return void(t.height=n.getStandaloneTaskHeight(s)+E+O);t.height=R.reduce(function(t,e){return Math.max(t,e)})+E,null==m?l.forEach(function(e,i){e.forEach(function(e){var i=w[e._rowLevel];e.y+=(i-e.overallHeight)/2+t.y})}):l.forEach(function(e,i){e.forEach(function(e){e.y+=t.y})})}else t.height=r-e,l.forEach(function(e,i){var a=R[i],n=Number.MAX_VALUE;e.forEach(function(e){e.y+=Math.floor((t.height-e[k])/2),e.y<n&&(n=e.y)});var s=Math.floor((t.height-a)/2)-n;e.forEach(function(e){"overlay"===e.overlapBehavior?e.y+=t.y:e.y+=t.y+s})})},m.prototype._calcTaskAggregation=function(t){var e=function(t,e){return t.endTime===e.startTime&&t.startTime!==t.endTime&&e.startTime!==e.endTime&&t.height==e.height&&t.data.borderRadius==e.data.borderRadius},i=t.taskObjs;if(0!==i.length)if(1!==i.length)if(2!==i.length){i[0].aggregation=e(i[0],i[1])?"stackStart":"stackSolo",i[i.length-1].aggregation=e(i[i.length-2],i[i.length-1])?"stackEnd":"stackSolo";for(var a=1;a<i.length-1;a++){var n=i[a-1],s=i[a],r=i[a+1];e(n,s)&&e(s,r)?s.aggregation="stackMiddle":e(n,s)?s.aggregation="stackEnd":e(s,r)?s.aggregation="stackStart":s.aggregation="stackSolo"}}else e(i[0],i[1])?(i[0].aggregation="stackStart",i[1].aggregation="stackEnd"):(i[0].aggregation="stackSolo",i[1].aggregation="stackSolo");else i[0].aggregation="stackSolo"},m.prototype._generateRowObjs=function(t){var e=this._gantt.getOptions(),i=0;this._gantt.isHorizontalGridlinesVisible()&&(i=n.getHorizontalGridlineWidth(e));for(var a=[],s=0,r=0;r<t.length;r++){var o=t[r],h=o.tasks;if(null!=h){var l={id:null!=o.id?o.id:h.length>0?h[0].id:null,data:o,index:r,y:s,renderState:"add"};null!=o._depth&&(l.depth=o._depth,l.expanded=o._expanded,l.parentRowIndex=o._parentFlatIndex,o._depth=void 0,o._expanded=void 0,o._parentFlatIndex=void 0,o._flatIndex=void 0);for(var d=[],g=0;g<h.length;g++){var c=h[g],_={id:c.id,data:c,startTime:c.start&&""!==c.start?this._getTime(c.start):this._getTime(c.end),endTime:c.end&&""!==c.end?this._getTime(c.end):this._getTime(c.start),rowObj:l,predecessorDepObjs:[],successorDepObjs:[],renderState:"add"},p=_.startTime,u=_.endTime,m=c.baseline;if(m){var b=m.start&&""!==m.start?this._getTime(m.start):this._getTime(m.end),f=m.end&&""!==m.end?this._getTime(m.end):this._getTime(m.start);null==b&&null==f||(_.baselineStartTime=b,_.baselineEndTime=f,(b<p||null==p)&&(p=b),(f>u||null==u)&&(u=f))}var y=c.overtime;if(y){var v=y.start&&_.startTime?Math.max(this._getTime(y.start),_.startTime):null,S=y.end&&_.endTime?Math.min(this._getTime(y.end),_.endTime):null;_.overtimeStartTime=v,_.overtimeEndTime=S}var T=c.downtime;if(T){var D=T.start&&_.startTime?Math.max(this._getTime(T.start),_.startTime):null,C=T.end&&_.endTime?Math.min(this._getTime(T.end),_.endTime):null;_.downtimeStartTime=D,_.downtimeEndTime=C}null!=p&&null!=u&&(_.overallStartTime=p,_.overallEndTime=u,d.push(_))}d.sort(function(t,e){return t.startTime-e.startTime}),l.taskObjs=d,a.push(l),this._calcRowTaskYHeight(l,i),s+=l.height+i,"on"===e.taskAggregation&&this._calcTaskAggregation(l)}}return a},m.prototype._generateDependencyObjs=function(t,i){(i=i||this._createIdObjMap(this._rowObjs,"taskObjs")).forEach((t,e)=>{t.successorDepObjs=[],t.predecessorDepObjs=[]});for(var a=[],n=0;n<t.length;n++){var r=t[n],o=r.predecessorTaskId,h=r.successorTaskId,l=null==r.type?s.FINISH_START:r.type,d=null!=o&&i.has(o),g=null!=h&&i.has(h);if(s._isValidType(l)&&d&&g&&!e.Obj.compareValues(this._ctx,o,h)){var c,_,p=i.get(o),u=i.get(h),m=p.rowObj,b=u.rowObj;m.index<=b.index?(c=m,_=b):(c=b,_=m);var f=r.shortDesc;if(null==f){var y=this._gantt.getOptions().translations,v=y[l+"DependencyAriaDesc"];f=e.ResourceUtils.format(y.accessibleDependencyInfo,[v,o,h])}var S={id:r.id,data:r,index:n,type:l,predecessorTaskObj:p,successorTaskObj:u,rowObjTop:c,rowObjBottom:_,ariaLabel:f};p.successorDepObjs.push(S),u.predecessorDepObjs.push(S),a.push(S)}}a.sort(function(t,e){return t.rowObjTop.index-e.rowObjTop.index});for(var T=0;T<a.length-1;T++)a[T].nextTopDependencyObj=a[T+1],a[T+1].prevTopDependencyObj=a[T];return a.sort(function(t,e){return t.rowObjBottom.index-e.rowObjBottom.index}),a},m.prototype._createIdObjMap=function(t,e){for(var i=new this._ctx.ojMap,a=0;a<t.length;a++){var n=t[a];if(e)for(var s=n[e],r=0;r<s.length;r++){var o=s[r];i.set(o.id,o)}else i.set(n.id,n)}return i},m.prototype._setDifferenceRenderState=function(t,e,i,a){for(var n=0;n<t.length;n++){var s=t[n];if(a)for(var r=s[a],o=0;o<r.length;o++){var h=r[o];if(!e.has(h.id)&&(h.renderState=i,"delete"===i)){var l=h.node;if(l&&l.getParent())"delete"!==s.renderState&&l.remove()}}else if(!e.has(s.id)&&(s.renderState=i,"delete"===i)){var d=s.node;d&&d.getParent()&&d.remove()}}},m.prototype._setIntersectionRenderState=function(t,i,a){for(var n=0;n<i.length;n++){var s=i[n];if(a)for(var r=s[a],o=0;o<r.length;o++){var h=r[o],l=t.get(h.id);if(l){if(e.Obj.compareValues(this._ctx,l.rowObj.id,s.id))h.renderState="exist";else{h.renderState="migrate";var d=l.node;d&&d.getParent()&&"none"===this._gantt.getAnimationManager().getAnimationMode()&&d.getRowNode().removeChild(d)}h._oldObj=l}}else{var g=t.get(s.id);g&&(s.renderState="exist",s._oldObj=g)}}},m.prototype._addAnimationFinalStateRowObjs=function(t,e){this._animationFinalStateRowObjs=this._animationFinalStateRowObjs||new Map,this._animationFinalStateRowObjs.has(t)||this._animationFinalStateRowObjs.set(t,new Set),e&&this._animationFinalStateRowObjs.get(t).add(e)},m.prototype._prepareAnimationDOM=function(t,i,a,n,s){var r=this._gantt.getAnimationManager(),o=r.getAnimationMode();r.setAnimationMode("none"),this._animationInitialStateRowObjsDelete=[];var h=this._contentHeight,l=t[t.length-1];this._contentHeight=l.y+l.height;var d=this._gantt.scrollPositionToTranslateY(this._gantt.getOptions().scrollPosition),g=this._gantt.getViewportYBounds(d),c=g.yMin,_=g.yMax;this._contentHeight=h;for(var p=this.findRowIndRange(this._rowObjs,c,_),u=p.minRowInd,m=p.maxRowInd,b=u;b<=m;b++){var f=this._rowObjs[b];if(f){this.ensureInDOM(f,"row"),"delete"===f.renderState&&f.node.getRowLabelContent()&&this._animationInitialStateRowObjsDelete.push(f);var y=a.get(f.id);y&&this._addAnimationFinalStateRowObjs(y);for(var v=f.taskObjs,S=0;S<v.length;S++){var T=v[S],D=s.get(T.id);if(D){var C=D.rowObj;if(!e.Obj.compareValues(this._ctx,C.id,f.id)){var E=i.get(C.id);E&&this.ensureInDOM(E,"row"),this._addAnimationFinalStateRowObjs(C,D)}}}}}var O=this.findRowIndRange(t,c,_),k=O.minRowInd,w=O.maxRowInd;for(b=k;b<=w;b++){var A=t[b];if(A){this._addAnimationFinalStateRowObjs(A);var R=i.get(A.id);R&&this.ensureInDOM(R,"row");var x=A.taskObjs;for(S=0;S<x.length;S++){var L=x[S],P=n.get(L.id);if(P){var M=P.rowObj;if(!e.Obj.compareValues(this._ctx,M.id,A.id)){this.ensureInDOM(P,"task");var j=a.get(M.id);j&&this._addAnimationFinalStateRowObjs(j,L)}}}}}r.setAnimationMode(o)},m.prototype._associateOldNodesAndNewLayoutObjs=function(t){for(var e=0;e<t.length;e++){var i=t[e],a=i._oldObj;if(a){var n=a.node;n&&(i.node=n,n.setLayoutObject(i)),i._oldObj=null}for(var s=i.taskObjs,r=0;r<s.length;r++){var o=s[r],h=o._oldObj;if(h){var l=h.node;l&&(o.node=l,l.setLayoutObject(o),l.isSelected()&&l.clearSelectionState()),o._oldObj=null}}}},m.prototype.calcLayout=function(){var t=this._gantt.getOptions(),e=this._gantt.getRenderState();if(null==e)var i=this._calcRowsLayout(t);else this._expandCollapseRowObject(t,e.state,e.payload);if(this._rowObjs.length>0){var a=this._rowObjs[this._rowObjs.length-1];this._contentHeight=a.y+a.height;var n=t.dependencies;null!=n&&n.length>0&&(this._dependencyObjs=this._generateDependencyObjs(n,i))}},m.prototype._calcRowsLayout=function(t){var e=t.rows;if(null!=e&&0!==e.length){var i=e;this._gantt.isRowsHierarchical()&&(i=this._flattenRows(e,t.expanded));var a=this._generateRowObjs(i);if(this._rowObjs&&!this._gantt.isInitialRender()&&this._gantt.isLastRenderValid()){var n=this._createIdObjMap(this._rowObjs),s=this._createIdObjMap(a),r=this._createIdObjMap(this._rowObjs,"taskObjs"),o=this._createIdObjMap(a,"taskObjs");this._setDifferenceRenderState(this._rowObjs,s,"delete"),this._setDifferenceRenderState(a,n,"add"),this._setIntersectionRenderState(n,a),this._setDifferenceRenderState(this._rowObjs,o,"delete","taskObjs"),this._setDifferenceRenderState(a,r,"add","taskObjs"),this._setIntersectionRenderState(r,a,"taskObjs"),"none"!==this._gantt.getAnimationManager().getAnimationMode()&&this._prepareAnimationDOM(a,n,s,r,o),this._associateOldNodesAndNewLayoutObjs(a)}return this._rowObjs=a,o}this._rowObjs=[]},m.prototype.isRowExpandable=function(t){if(null==t.expanded)return!1;var e=this._gantt.getOptions().expanded,i=t.id;return!e.has(i)},m.prototype.isRowCollapsible=function(t){if(null==t.expanded)return!1;var e=this._gantt.getOptions().expanded,i=t.id;return e.has(i)},m.prototype._expandCollapseRowObject=function(t,e,i){var a=this,s=i.index,r=i.data,o=r.rows,h=t.expanded,l=this._gantt.getAnimationManager(),d=l.getAnimationMode(),g="none"!==d;if(g)var c=this._gantt.getViewportYBounds(A),_=c.yMin,p=c.yMax-_,u=function(t,e,i){l.setAnimationMode("none");for(var n=0,s=e;s<t.length;s++){var r=t[s];if(a.ensureInDOM(r,"row"),a._addAnimationFinalStateRowObjs(r),(n+=r.height)>i)break}l.setAnimationMode(d)};var m=function(t,e,i,a){for(var n=i;n<a;n++){var s=t[n];if(s.renderState=e,"delete"===e){var r=s.node;r&&r.getParent()&&r.remove()}for(var o=s.taskObjs,h=0;h<o.length;h++){o[h].renderState=e}}};if(i.expanded="expand"===e,r._expanded=i.expanded,m(this._rowObjs,"exist",0,this._rowObjs.length),"expand"===e){var b=this._flattenRows(o,h,i.index+1,i.depth+1),f=this._generateRowObjs(b);m(f,"add",0,f.length),g&&u(this._rowObjs,s,p),this._rowObjs=this._rowObjs.slice(0,s+1).concat(f,this._rowObjs.slice(s+1,this._rowObjs.length))}else{var y=this._calcFlattenedRowsLength(o,h);m(this._rowObjs,"delete",s+1,s+1+y),g&&u(this._rowObjs,s+1+y,p);var v=this._rowObjs.splice(s+1,y);g&&(this._animationInitialStateRowObjsDelete=v)}var S=0;this._gantt.isHorizontalGridlinesVisible()&&(S=n.getHorizontalGridlineWidth(t));for(var T=i.y+i.height+S,D=s+1;D<this._rowObjs.length;D++){var C=this._rowObjs[D];C.index=D;for(var E=C.taskObjs,O=0;O<E.length;O++){var k=E[O];k.y=k.y-C.y+T}C.y=T,T+=C.height+S}if(g){var w=this._rowObjs[this._rowObjs.length-1];this._contentHeight=w.y+w.height;for(var A=this._gantt.scrollPositionToTranslateY(this._gantt.getOptions().scrollPosition),R=this._gantt.getViewportYBounds(A),x=R.yMin,L=R.yMax,P=this.findRowIndRange(this._rowObjs,x,L),M=P.minRowInd,j=P.maxRowInd,I=M;I<=j;I++)this._addAnimationFinalStateRowObjs(this._rowObjs[I])}},m.prototype._flattenRows=function(t,e,i,a){i=i||0,a=a||0;var n=this._gantt.getOptions(),s=n.rowData||n.taskData,r=function(t,e,a,n){return t.reduce(function(t,o){o._depth=n,o._parentFlatIndex=a?a._flatIndex:null,o._flatIndex=i,i+=1;var h=o.rows;if(h){if(e.has(o.id))return o._expanded=!0,t.concat(o,r(h,e,o,n+1));o._expanded=!1}else if(s){var l=s.getChildDataProvider(o.id),d=!l||"yes"===l.isEmpty();o._expanded=!!d&&null}else o._expanded=null;return t.concat(o)},[])};return r(t,e,null,a)},m.prototype._calcFlattenedRowsLength=function(t,e){var i=function(t){return t.reduce(function(t,a){var n=a.rows;return n&&e.has(a.id)?t+1+i(n):t+1},0)};return i(t)},m.prototype.isRoot=function(t){return null==t.parentRowIndex},m.prototype.isHiddenCollapsed=function(t){for(var e=0;e<this._rowObjs;e++)if(this._rowObjs[e]===t)return!1;return!0},m.prototype.getParentRowObj=function(t){var e=t.parentRowIndex;return null!=e?this._rowObjs[e]:null},m.prototype._renderRowObj=function(t,e,i){var a=this._gantt.getDatabody(),n=t.node;if("update"===i)n.render(null,e);else{if(n||((n=new u(this._gantt)).setLayoutObject(t),t.node=n),this._gantt.isRowAxisEnabled()){var s=this._gantt.getRowAxis();if(s){var o=s.getRowLabelContents(),h=t.index,l=o[h];l||((l=new r(s,s.getLabelContentType())).setRowIndex(h),o[h]=l),l.render(t),n.setRowLabelContent(l)}}n.render(a,e)}},m.prototype._renderTaskObj=function(t,e){var i=t.rowObj,a=i.node,n=t.node;e&&n&&a&&n.getParent()===a||this._renderRowObj(i,{rowObj:i,tasksAdd:new Set([t]),tasksUpdate:new Set,tasksDelete:new Set,updateRender:!e},a&&a.getParent()?"update":"add")},m.prototype._renderDependencyObj=function(t,e){var i=this._gantt.getDependenciesContainer(),a=t.node;if(a&&a.getParent())return!1;var n=this._gantt.getAnimationManager(),r=n.getAnimationMode();n.setAnimationMode("none");var o=t.predecessorTaskObj,h=t.successorTaskObj;if(this._animationFinalStateRowObjs){var l=o.rowObj,d=h.rowObj;this._animationFinalStateRowObjs.has(l)&&this._animationFinalStateRowObjs.get(l).has(o)||this.ensureInDOM(o,"task",e),this._animationFinalStateRowObjs.has(d)&&this._animationFinalStateRowObjs.get(d).has(h)||this.ensureInDOM(h,"task",e)}else this.ensureInDOM(o,"task",e),this.ensureInDOM(h,"task",e);return n.setAnimationMode(r),a||((a=new s(this._gantt)).setLayoutObject(t),t.node=a),a.render(i),!0},m.prototype.ensureInDOM=function(t,e,i){switch(e){case"row":return void this._renderRowObj(t);case"task":return void this._renderTaskObj(t,i);case"dependency":return void this._renderDependencyObj(t,!0);case"rowLabel":return void this._renderRowObj(t,{rowObj:t,tasksAdd:new Set,tasksUpdate:new Set,tasksDelete:new Set,updateRender:!1},"add")}},m.prototype._binarySearchLeftMost=function(t,e,i,a,n){if(0===t.length)return 0;for(var s=0,r=t.length;s<r;){var o=Math.floor((s+r)/2),h=a?n?t[o][a][n]:t[o][a]:t[o];h<e?s=o+1:r=o}return s<t.length&&((h=a?n?t[s][a][n]:t[s][a]:t[s])===e||"successor"===i)?s:s>0?s-1:0},m.prototype.findRowIndRange=function(t,e,i){for(var a=this._binarySearchLeftMost(t,e,"predecessor","y"),n=a,s=a;s<t.length;s++){if(!(t[s].y<=i))break;n=s}return{minRowInd:a,maxRowInd:n}},m.prototype.findTaskObjsRange=function(t,e,i,a,n){for(var s=[],r=t.taskObjs,o=0;o<r.length;o++){var h=r[o];this._isIntervalOverlap(h.overallStartTime,h.overallEndTime,e,a)&&(i&&n?s.push(h):i||n?n?h.overallStartTime>e&&s.push(h):h.overallEndTime<a&&s.push(h):h.overallStartTime>e&&h.overallEndTime<a&&s.push(h))}return s},m.prototype.findBufferTaskObjsRange=function(t,e,i){for(var a=[],n=t.taskObjs,s=0;s<n.length;s++){var r=n[s],o=r.previousAdjacentTaskObj,h=r.nextAdjacentTaskObj,l=!o&&!h&&!this._isIntervalOverlap(r.overallStartTime,r.overallEndTime,e,i),d=r.overallEndTime<e&&(!h||h&&h.overallEndTime>=e),g=r.overallStartTime>i&&(!o||o&&o.overallStartTime<=i);(l||d||g)&&a.push(r)}return a},m.prototype.getLayoutObjectsInBBox=function(t){for(var i=this.findRowIndRange(this._rowObjs,t.y,t.y+t.h),n=i.minRowInd,s=i.maxRowInd,r=e.Agent.isRightToLeft(this._gantt.getCtx()),o=this._gantt.getStartTime(),h=this._gantt.getEndTime(),l=this._gantt.getContentLength(),d=a.TimeAxisUtils.getPositionDate(o,h,r?l-(t.x+t.w):t.x,l),g=a.TimeAxisUtils.getPositionDate(o,h,r?l-t.x:t.x+t.w,l),c=[],_=[],p=n;p<=s;p++){var u=this._rowObjs[p];c.push(u);for(var m=u.taskObjs,b=0;b<m.length;b++){var f=m[b];this._isIntervalOverlap(f.overallStartTime,f.overallEndTime,d,g)&&this._isIntervalOverlap(f.y,f.y+f.height,t.y,t.y+t.h)&&_.push(m[b])}}return{rowObjs:c,taskObjs:_}},m.prototype._getSelectionDependencies=function(t){var e=this._createIdObjMap(this._rowObjs,"taskObjs"),i=[];t===m.VPC_REFRESH?i=this._gantt.getOptions().selection.map(t=>e.get(t)).filter(t=>void 0!==t):i=this._gantt.getSelectionHandler().getSelection().map(t=>t.getLayoutObject());var a=new Set,n=new Set,s=t=>{null!=t&&!a.has(t)&&e.has(t.id)&&(a.add(t),new Set(t.predecessorDepObjs.map(t=>t.predecessorTaskObj).concat(t.successorDepObjs.map(t=>t.successorTaskObj))).forEach(t=>s(t)))};return i.forEach(t=>s(t)),a.forEach(t=>{t.predecessorDepObjs.forEach(t=>{n.add(t)}),t.successorDepObjs.forEach(t=>{n.add(t)})}),{taskObjs:Array.from(a),dependencyObjs:n}},m.prototype.highlightTasks=function(t){this._gantt.getDatabody()&&(0===t.length?this._gantt.undimDatabody():this._gantt.dimDatabody(),this._prevHighlightedTaskObjs.forEach(t=>{t.node&&t.node.unhighlight()}),t.forEach(t=>{t.node&&t.node.highlight()}),this._prevHighlightedTaskObjs=t)},m.prototype.renderViewportDependencyLines=function(t,e){var i,a=this._gantt.getDependenciesContainer();if(a&&a.removeChildren(),"highlightDependencies"===this._gantt.getOptions().selectionBehavior){var n=this._getSelectionDependencies(e);this.highlightTasks(n.taskObjs),i=n.dependencyObjs}else i=new Set(this._dependencyObjs),this.highlightTasks([]);if(i.size>0){for(var r=function(t,e){var i,a,n=t.predecessorTaskObj,r=t.successorTaskObj;switch(t.type){case s.START_FINISH:i=n.startTime,a=r.endTime;break;case s.START_START:i=n.startTime,a=r.startTime;break;case s.FINISH_FINISH:i=n.endTime,a=r.endTime;break;case s.FINISH_START:default:i=n.endTime,a=r.startTime}return this._isIntervalOverlap(Math.min(i,a),Math.max(i,a),e.viewStartTime,e.viewEndTime)}.bind(this),o=this._binarySearchLeftMost(this._dependencyObjs,t.minRowInd,"successor","rowObjBottom","index"),h=this._dependencyObjs[o],l=h.prevTopDependencyObj,d=e===m.VPC_TRANSLATE||e===m.VPC_REFRESH;h&&h.rowObjTop.index<=t.maxRowInd;)i.has(h)&&r(h,t)&&this._renderDependencyObj(h,d),h=h.nextTopDependencyObj;for(;l;){l.rowObjBottom.index>=t.minRowInd&&i.has(l)&&r(l,t)&&this._renderDependencyObj(l,d),l=l.prevTopDependencyObj}}},m.prototype._detachRowObjNode=function(t){var e=t.node;e&&(t.taskObjs.forEach(function(t){var e=t.node;e&&e.remove()}),e.remove())},m.prototype._prepareViewport=function(t,e){var i=this._gantt.getDatabody();e===m.VPC_REFRESH&&(this._rowObjs.forEach(this._detachRowObjNode,this),i.removeChildren(),this._gantt.getDatabodyBackground().removeChildren(),this._gantt.getRowReferenceObjectsContainer().removeChildren());var a=this._gantt.getRowAxis();this._gantt.isRowAxisEnabled()&&a&&e!==m.VPC_TRANSLATE&&e!==m.VPC_SCALE&&a.clear()},m.prototype._computeViewportRenderOperations=function(t,e){var i=[],n=[],s=[];if(e===m.VPC_REFRESH)for(var r=t.minRowInd;r<=t.maxRowInd;r++){var o=this._rowObjs[r],h=this.findTaskObjsRange(o,t.viewStartTime,!0,t.viewEndTime,!0);this.findBufferTaskObjsRange(o,t.viewStartTime,t.viewEndTime).forEach(function(t){h.push(t)}),n.push({rowObj:o,tasksAdd:new Set(h),tasksUpdate:new Set,tasksDelete:new Set,updateRender:!0})}else if(e===m.VPC_ANIMATE){this._animationFinalStateRowObjs.forEach(function(e,i){var a=new Set,s=this.findTaskObjsRange(i,t.viewStartTime,!0,t.viewEndTime,!0),r=this.findBufferTaskObjsRange(i,t.viewStartTime,t.viewEndTime);s.forEach(function(t){e.has(t)||a.add(t)}),r.forEach(function(t){e.has(t)||a.add(t)}),e.forEach(function(t){a.add(t)}),this._animationFinalStateRowObjs.set(i,a),n.push({rowObj:i,tasksAdd:a,tasksUpdate:new Set,tasksDelete:new Set,updateRender:!0})},this);var l=this._gantt.getRowAxis();for(r=0;r<this._animationInitialStateRowObjsDelete.length;r++){var d=this._animationInitialStateRowObjsDelete[r].node;if(d&&l)d.getRowLabelContent().ensureInDOM(),this._gantt.isHorizontalGridlinesVisible()&&l.addHorizontalLine(d.getRowAxisHorizontalLine())}}else{var g=this._gantt.getEventManager(),c=a.TimeAxisUtils.supportsTouch()&&g&&g.isDnDDragging();for(r=this._prevViewport.minRowInd;r<Math.min(t.minRowInd,this._prevViewport.maxRowInd);r++)i.push(this._rowObjs[r]);for(r=Math.max(t.maxRowInd+1,this._prevViewport.minRowInd);r<=this._prevViewport.maxRowInd;r++)i.push(this._rowObjs[r]);for(r=t.minRowInd;r<Math.min(this._prevViewport.minRowInd,t.maxRowInd);r++){o=this._rowObjs[r],h=this.findTaskObjsRange(o,t.viewStartTime,!0,t.viewEndTime,!0);this.findBufferTaskObjsRange(o,t.viewStartTime,t.viewEndTime).forEach(function(t){h.push(t)}),n.push({rowObj:o,tasksAdd:new Set(h),tasksUpdate:new Set,tasksDelete:new Set,updateRender:!0})}for(r=Math.max(this._prevViewport.maxRowInd+1,t.minRowInd);r<=t.maxRowInd;r++){o=this._rowObjs[r],h=this.findTaskObjsRange(o,t.viewStartTime,!0,t.viewEndTime,!0);this.findBufferTaskObjsRange(o,t.viewStartTime,t.viewEndTime).forEach(function(t){h.push(t)}),n.push({rowObj:o,tasksAdd:new Set(h),tasksUpdate:new Set,tasksDelete:new Set,updateRender:!0})}var _=e===m.VPC_SCALE;if(this._prevViewport.maxRowInd>=t.minRowInd&&this._prevViewport.minRowInd<=t.maxRowInd){var p=this._prevViewport.viewStartTime,u=this._prevViewport.viewEndTime,b=t.viewStartTime,f=t.viewEndTime;for(r=Math.max(t.minRowInd,this._prevViewport.minRowInd);r<=Math.min(t.maxRowInd,this._prevViewport.maxRowInd);r++){o=this._rowObjs[r];var y=new Set,v=new Set,S=new Set;p<b&&this.findTaskObjsRange(o,p,!0,Math.min(b,u),u<b).forEach(function(t){y.add(t)}),u>f&&this.findTaskObjsRange(o,Math.max(f,p),p>f,u,!0).forEach(function(t){y.add(t)}),b<p&&this.findTaskObjsRange(o,b,!0,Math.min(f,p),f<p).forEach(function(t){v.add(t)}),f>u&&this.findTaskObjsRange(o,Math.max(u,b),b>u,f,!0).forEach(function(t){v.add(t)}),u>=b&&p<=f&&(S=new Set(this.findTaskObjsRange(o,Math.max(b,p),!0,Math.min(f,u),!0))),this.findBufferTaskObjsRange(o,this._prevViewport.viewStartTime,this._prevViewport.viewEndTime).forEach(function(t){y.add(t)}),this.findBufferTaskObjsRange(o,t.viewStartTime,t.viewEndTime).forEach(function(t){v.add(t)});var T=[];y.forEach(function(t){v.has(t)&&T.push(t)}),T.forEach(function(t){S.add(t),y.delete(t),v.delete(t)}),c&&(y=new Set),s.push({rowObj:o,tasksAdd:v,tasksUpdate:S,tasksDelete:y,updateRender:_})}}}return c&&(i=[]),{rowsDelete:i,rowsAdd:n,rowsUpdate:s}},m.prototype._executeViewportRenderOperations=function(t){t.rowsDelete.forEach(this._detachRowObjNode,this),t.rowsAdd.forEach(function(t){this._renderRowObj(t.rowObj,t,"add")},this),t.rowsUpdate.forEach(function(t){this._renderRowObj(t.rowObj,t,"update")},this)},m.prototype.renderViewport=function(t,e){this._prepareViewport(t,e);var i=this._computeViewportRenderOperations(t,e);this._executeViewportRenderOperations(i),this.renderViewportDependencyLines(t,e),this._prevViewport=t,this._animationFinalStateRowObjs=null,this._animationInitialStateRowObjsDelete=[]};var b=function(t){this.Init(t)};e.Obj.createSubclass(b,e.Obj),b.prototype.Init=function(t){this._gantt=t},b.prototype.prepareForAnimations=function(){var t=this._gantt.getCtx();this._gantt.StopAnimation(),this._animationMode="none",this._animationDuration=n.getAnimationDuration(this._gantt.getOptions()),this._gantt.isInitialRender()?this._gantt.isIRAnimationEnabled&&(this._animationMode="onDisplay"):this._gantt.isDCAnimationEnabled&&(this._animationMode="dataChange"),"onDisplay"===this._animationMode?(this.fadeInElemsIR=[],this.fadeInPlayableIR=new e.AnimFadeIn(t,this.fadeInElemsIR,this._animationDuration,0),this.dimensionsPlayableIR=this._createCustomPlayable(e.Easing.linear),this.translationsPlayableIR=this._createCustomPlayable(e.Easing.cubicInOut)):"dataChange"===this._animationMode&&(this.fadeInElemsDC=[],this.fadeInPlayableDC=new e.AnimFadeIn(t,this.fadeInElemsDC,this._animationDuration,0),this.fadeOutElemsDC=[],this.fadeOutPlayableDC=new e.AnimFadeOut(t,this.fadeOutElemsDC,this._animationDuration,0),this.dimensionsPlayableDC=this._createCustomPlayable(e.Easing.linear),this.translationsPlayableDC=this._createCustomPlayable(e.Easing.cubicInOut)),this._onEnds=[]},b.prototype.getAnimationMode=function(){return this._animationMode},b.prototype.setAnimationMode=function(t){this._animationMode=t},b.prototype._createCustomPlayable=function(t){var i;return(i=new e.CustomAnimation(this._gantt.getCtx(),this._gantt,this._animationDuration)).setEasing(t),i},b.prototype.triggerAnimations=function(){var t,i;if(this._gantt.StopAnimation(),i=this._gantt.getCtx(),"onDisplay"===this._animationMode?(t=[this.fadeInPlayableIR,this.translationsPlayableIR,this.dimensionsPlayableIR],this._gantt.Animation=new e.ParallelPlayable(i,t,this._animationDuration,0)):"dataChange"===this._animationMode&&(t=[this.fadeInPlayableDC,this.translationsPlayableDC,this.dimensionsPlayableDC,this.fadeOutPlayableDC],this._gantt.Animation=new e.ParallelPlayable(i,t,this._animationDuration,0)),this._gantt.Animation){this._hideDepLines(),e.Playable.appendOnEnd(this._gantt.Animation,this._showDepLines,this),this._gantt.isDndEnabled()||(this._gantt.EventManager.removeListeners(this._gantt),this._bListenersRemoved=!0);for(var a=0;a<this._onEnds.length;a++)e.Playable.appendOnEnd(this._gantt.Animation,this._onEnds[a],this);e.Playable.appendOnEnd(this._gantt.Animation,this._onAnimationEnd,this),this._gantt.Animation.play()}},b.prototype._hideDepLines=function(){var t=this._gantt.getDependenciesContainer();null!=t&&e.ToolkitUtils.setAttrNullNS(t.getElem(),"display","none")},b.prototype._showDepLines=function(){var t=this._gantt.getDependenciesContainer();null!=t&&e.ToolkitUtils.removeAttrNullNS(t.getElem(),"display")},b.prototype._onAnimationEnd=function(){this._gantt.AnimationStopped||this._gantt.RenderComplete(),this._bListenersRemoved&&this._gantt.EventManager.addListeners(this._gantt),this._gantt.Animation=null,this._gantt.AnimationStopped=!1,this._animationMode="none",this._gantt.renderViewport(m.VPC_REFRESH,!1)},b.prototype.preAnimateGanttIR=function(t){"onDisplay"===this._animationMode&&this.fadeInElemsIR.push(t._canvas)},b.prototype.preAnimateTaskNode=function(t,i){var a,n=t.getRenderState();"dataChange"===this._animationMode?"add"===n?(t.setTranslate(i.x,i.y),this.fadeInElemsDC.push(t)):"exist"!==n&&"migrate"!==n||((a=this.translationsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,t,t.getTranslateX,t.setTranslateX,i.x),a.addProp(e.Animator.TYPE_NUMBER,t,t.getTranslateY,t.setTranslateY,i.y)):t.setTranslate(i.x,i.y)},b.prototype.preAnimateTaskNodeRemove=function(t,e){"dataChange"===this._animationMode?(this.fadeOutElemsDC.push(t),this._onEnds.push(e)):e()},b.prototype.preAnimateTaskBaseline=function(t,i,a,n){var s,r,o=t.getRenderState("baseline");"onDisplay"===this._animationMode?(i.setDimensions(a.x,a.y,0,a.h,a.r),n(),(s=this.dimensionsPlayableIR.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getWidth,i.setWidth,a.w)):"dataChange"===this._animationMode?"add"===o?(i.setDimensions(a.x,a.y,0,a.h,a.r),n(),(s=this.dimensionsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getWidth,i.setWidth,a.w)):"exist"===o&&((r=this.translationsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getX,i.setX,a.x),r.addProp(e.Animator.TYPE_NUMBER,i,i.getY,i.setY,a.y),(s=this.dimensionsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getWidth,i.setWidth,a.w),s.addProp(e.Animator.TYPE_NUMBER,i,i.getHeight,i.setHeight,a.h),i.setBorderRadius(a.r),this._onEnds.push(n)):(i.setDimensions(a.x,a.y,a.w,a.h,a.r),n())},b.prototype.preAnimateTaskBaselineRemove=function(t,e){"dataChange"===this._animationMode?(this.fadeOutElemsDC.push(t),this._onEnds.push(e)):e()},b.prototype.preAnimateTaskMain=function(t,i,a){var n,s,r=t.getRenderState("main");"onDisplay"===this._animationMode?(t.setMainDimensions(i.x,i.y,0,i.h,i.r),a(),(n=this.dimensionsPlayableIR.getAnimator()).addProp(e.Animator.TYPE_NUMBER,t,t.getMainWidth,t.setMainWidth,i.w)):"dataChange"===this._animationMode?"add"===r?(t.setMainDimensions(i.x,i.y,0,i.h,i.r),a(),(n=this.dimensionsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,t,t.getMainWidth,t.setMainWidth,i.w)):"exist"===r&&((s=this.translationsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,t,t.getMainX,t.setMainX,i.x),s.addProp(e.Animator.TYPE_NUMBER,t,t.getMainY,t.setMainY,i.y),(n=this.dimensionsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,t,t.getMainWidth,t.setMainWidth,i.w),n.addProp(e.Animator.TYPE_NUMBER,t,t.getMainHeight,t.setMainHeight,i.h),t.setMainBorderRadius(i.r),this._onEnds.push(a)):(t.setMainDimensions(i.x,i.y,i.w,i.h,i.r),a())},b.prototype.preAnimateTaskMainRemove=function(t,e,i,a,n,s,r){"dataChange"===this._animationMode?(this.fadeOutElemsDC.push(t),e&&this.fadeOutElemsDC.push(e),i&&this.fadeOutElemsDC.push(i),a&&this.fadeOutElemsDC.push(a),n&&this.fadeOutElemsDC.push(n),s&&this.fadeOutElemsDC.push(s),this._onEnds.push(r)):r()},b.prototype.preAnimateTaskProgress=function(t,i,a,n){var s,r,o=t.getRenderState("progress");"onDisplay"===this._animationMode?(i.setDimensions(a.x,a.y,0,a.h,a.r),n(),(s=this.dimensionsPlayableIR.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getWidth,i.setWidth,a.w)):"dataChange"===this._animationMode?"add"===o?(i.setDimensions(a.x,a.y,0,a.h,a.r),n(),(s=this.dimensionsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getWidth,i.setWidth,a.w)):"exist"===o&&((r=this.translationsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getX,i.setX,a.x),r.addProp(e.Animator.TYPE_NUMBER,i,i.getY,i.setY,a.y),(s=this.dimensionsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getWidth,i.setWidth,a.w),s.addProp(e.Animator.TYPE_NUMBER,i,i.getHeight,i.setHeight,a.h),i.setBorderRadius(a.r),this._onEnds.push(n)):(i.setDimensions(a.x,a.y,a.w,a.h,a.r),n())},b.prototype.preAnimateTaskProgressRemove=function(t,e){"dataChange"===this._animationMode?(this.fadeOutElemsDC.push(t),this._onEnds.push(e)):e()},b.prototype.preAnimateTaskOvertime=function(t,i,a,n){var s,r,o=t.getRenderState("overtime");"onDisplay"===this._animationMode?(i.setDimensions(a.x,a.y,0,a.h,a.r),n(),(s=this.dimensionsPlayableIR.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getWidth,i.setWidth,a.w)):"dataChange"===this._animationMode?"add"===o?(i.setDimensions(a.x,a.y,0,a.h,a.r),n(),(s=this.dimensionsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getWidth,i.setWidth,a.w)):"exist"===o&&((r=this.translationsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getX,i.setX,a.x),r.addProp(e.Animator.TYPE_NUMBER,i,i.getY,i.setY,a.y),(s=this.dimensionsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getWidth,i.setWidth,a.w),s.addProp(e.Animator.TYPE_NUMBER,i,i.getHeight,i.setHeight,a.h),i.setBorderRadius(a.r),this._onEnds.push(n)):(i.setDimensions(a.x,a.y,a.w,a.h,a.r),n())},b.prototype.preAnimateTaskOvertimeRemove=function(t,e){"dataChange"===this._animationMode?(this.fadeOutElemsDC.push(progressShape),this._onEnds.push(e)):e()},b.prototype.preAnimateTaskDowntime=function(t,i,a,n){var s,r,o=t.getRenderState("downtime");"onDisplay"===this._animationMode?(i.setDimensions(a.x,a.y,0,a.h,a.r),n(),(s=this.dimensionsPlayableIR.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getWidth,i.setWidth,a.w)):"dataChange"===this._animationMode?"add"===o?(i.setDimensions(a.x,a.y,0,a.h,a.r),n(),(s=this.dimensionsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getWidth,i.setWidth,a.w)):"exist"===o&&((r=this.translationsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getX,i.setX,a.x),r.addProp(e.Animator.TYPE_NUMBER,i,i.getY,i.setY,a.y),(s=this.dimensionsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getWidth,i.setWidth,a.w),s.addProp(e.Animator.TYPE_NUMBER,i,i.getHeight,i.setHeight,a.h),i.setBorderRadius(a.r),this._onEnds.push(n)):(i.setDimensions(a.x,a.y,a.w,a.h,a.r),n())},b.prototype.preAnimateTaskDowntimeRemove=function(t,e){"dataChange"===this._animationMode?(this.fadeOutElemsDC.push(t),this._onEnds.push(e)):e()},b.prototype.preAnimateTaskAttribute=function(t,i,a,n){var s,r,o=t.getRenderState("attribute");"onDisplay"===this._animationMode?(i.setDimensions(a.x,a.y,a.w,0,a.r),n(),(s=this.dimensionsPlayableIR.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getHeight,i.setHeight,a.h)):"dataChange"===this._animationMode?"add"===o?(i.setDimensions(a.x,a.y,a.w,0,a.r),n(),(s=this.dimensionsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getHeight,i.setHeight,a.h)):"exist"===o&&((r=this.translationsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getX,i.setX,a.x),r.addProp(e.Animator.TYPE_NUMBER,i,i.getY,i.setY,a.y),(s=this.dimensionsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getWidth,i.setWidth,a.w),s.addProp(e.Animator.TYPE_NUMBER,i,i.getHeight,i.setHeight,a.h),i.setBorderRadius(a.r),this._onEnds.push(n)):(i.setDimensions(a.x,a.y,a.w,a.h,a.r),n())},b.prototype.preAnimateTaskAttributeRemove=function(t,e){"dataChange"===this._animationMode?(this.fadeOutElemsDC.push(t),this._onEnds.push(e)):e()},b.prototype.preAnimateTaskLabel=function(t,i,a){var n,s=t.getTask(),r=t.getTaskLabel(),o=r.getLabelOutputText(),h=r.getRenderState(),l=s.getRenderState("main");"onDisplay"===this._animationMode?(a(),o.setY(i.y),o.setX(s.getShape("main").getX()),(n=this.translationsPlayableIR.getAnimator()).addProp(e.Animator.TYPE_NUMBER,o,o.getX,o.setX,i.x),n.addProp(e.Animator.TYPE_NUMBER,o,o.getY,o.setY,i.y)):"dataChange"===this._animationMode?"add"===h?(o.setX(i.x),o.setY(i.y),a(),"add"===l?(o.setX(s.getShape("main").getX()),(n=this.translationsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,o,o.getX,o.setX,i.x),n.addProp(e.Animator.TYPE_NUMBER,o,o.getY,o.setY,i.y)):"exist"===l&&this.fadeInElemsDC.push(o)):"exist"===h&&((n=this.translationsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,o,o.getX,o.setX,i.x),n.addProp(e.Animator.TYPE_NUMBER,o,o.getY,o.setY,i.y),this._onEnds.push(a)):(o.setX(i.x),o.setY(i.y),a())},b.prototype.preAnimateTaskLabelRemove=function(t,e){"dataChange"===this._animationMode?(this.fadeOutElemsDC.push(t),this._onEnds.push(e)):e()},b.prototype.preAnimateHorizontalGridline=function(t,i,a){var n;"dataChange"===this._animationMode?"add"===a?(t.setY1(i.y1),t.setY2(i.y2),t.setX1(i.x1),t.setX2(i.x2),this.fadeInElemsDC.push(t)):"exist"===a&&((n=this.translationsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,t,t.getX1,t.setX1,i.x1),n.addProp(e.Animator.TYPE_NUMBER,t,t.getX2,t.setX2,i.x2),n.addProp(e.Animator.TYPE_NUMBER,t,t.getY1,t.setY1,i.y1),n.addProp(e.Animator.TYPE_NUMBER,t,t.getY2,t.setY2,i.y2)):(t.setY1(i.y1),t.setY2(i.y2),t.setX1(i.x1),t.setX2(i.x2))},b.prototype.preAnimateRowBackground=function(t,i,a){var n;"dataChange"===this._animationMode?("add"===a&&this.fadeInElemsDC.push(t),(n=this.dimensionsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,t,t.getHeight,t.setHeight,i.h),n.addProp(e.Animator.TYPE_NUMBER,t,t.getWidth,t.setWidth,i.w),this.translationsPlayableDC.getAnimator().addProp(e.Animator.TYPE_NUMBER,t,t.getY,t.setY,i.y)):(t.setY(i.y),t.setHeight(i.h),t.setWidth(i.w))},b.prototype.preAnimateRowReferenceObject=function(t,i){"dataChange"===this._animationMode?this.dimensionsPlayableDC.getAnimator().addProp(e.Animator.TYPE_NUMBER,t,t.getY2,t.setY2,i.y2):t.updateRefObjs(t._refObjs,i.y1,i.y2)},b.prototype.preAnimateRowNodeRemove=function(t,e){"dataChange"===this._animationMode?(this.fadeOutElemsDC.push(t),this.fadeOutElemsDC.push(t.getBackground()),this._onEnds.push(e)):e()},b.prototype.preAnimateRowLabel=function(t,i,a){var n,s,r=t.getRenderState(),o=i.getBackground();"dataChange"===this._animationMode?"add"===r?(i.setY(a.y),i.setX(a.x),this.fadeInElemsDC.push(i.getDisplayable()),o.setRect(a.backgroundX,a.backgroundY,a.backgroundWidth,a.backgroundHeight),this.fadeInElemsDC.push(o)):"exist"===r&&((n=this.translationsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,i,i.getX,i.setX,a.x),n.addProp(e.Animator.TYPE_NUMBER,i,i.getY,i.setY,a.y),n.addProp(e.Animator.TYPE_NUMBER,o,o.getX,o.setX,a.backgroundX),n.addProp(e.Animator.TYPE_NUMBER,o,o.getY,o.setY,a.backgroundY),(s=this.dimensionsPlayableDC.getAnimator()).addProp(e.Animator.TYPE_NUMBER,o,o.getWidth,o.setWidth,a.backgroundWidth),s.addProp(e.Animator.TYPE_NUMBER,o,o.getHeight,o.setHeight,a.backgroundHeight)):(i.setY(a.y),i.setX(a.x),o.setRect(a.backgroundX,a.backgroundY,a.backgroundWidth,a.backgroundHeight))},b.prototype.preAnimateRowLabelRemove=function(t,e,i){"dataChange"===this._animationMode?(this.fadeOutElemsDC.push(t.getBackground()),this.fadeOutElemsDC.push(t.getDisplayable()),this.fadeOutElemsDC.push(e),this._onEnds.push(i)):i()};var f=function(t){this._gantt=t};e.Obj.createSubclass(f,e.Automation),f.prototype.GetSubIdForDomElement=function(t){var e=this._gantt.getEventManager().GetLogicalObject(t);if(e&&e instanceof p){var i=e.getLayoutObject().rowObj;return"taskbar["+i.index+"]["+i.taskObjs.map(function(t){return t.node}).indexOf(e)+"]"}return e&&e instanceof r?"rowLabel["+e.getRowIndex()+"]":e&&e instanceof s?e.getLayoutObject().index:null},f.prototype.getDomElementForSubId=function(t){if(t===e.Automation.TOOLTIP_SUBID)return this.GetTooltipElement(this._gantt);var i=t.indexOf("["),a=t.indexOf("]"),n=t.substring(0,i);if(i>-1&&a>-1)if("taskbar"===n){var s=t.indexOf("[",i+1),r=t.indexOf("]",s+1);if(s>-1&&r>-1){var o=parseInt(t.substring(i+1,a)),h=parseInt(t.substring(s+1,r));if(isNaN(o)||isNaN(h))return null;if((c=this._gantt.getRowLayoutObjs()).length>o){var l=c[o].taskObjs;if(l.length>h){var d=l[h];this._gantt.getDataLayoutManager().ensureInDOM(d,"task",!0);var g=d.node.getTask().getShape("main");if(null!=g)return g.getElem()}}}}else if("rowLabel"===n){var c;if(o=parseInt(t.substring(i+1,a)),(c=this._gantt.getRowLayoutObjs()).length>o){var _=c[o];this._gantt.getDataLayoutManager().ensureInDOM(_,"rowLabel");var p=_.node.getRowLabelContent();if(null!=p)return p.getDisplayable().getElem()}}else if("dependency"===n){var u=parseInt(t.substring(i+1,a)),m=this._gantt.getDependencyLayoutObjs();if(m.length>u)for(var b=0;b<m.length;b++){var f=m[b];if(f.index===u){this._gantt.getDataLayoutManager().ensureInDOM(f,"dependency");var y=f.node;if(null!=y)return y.getElem()}}}return null};var y=function(t){this.Init({alta:y.VERSION_1},t)};e.Obj.createSubclass(y,e.BaseComponentDefaults),y.VERSION_1={axisPosition:"top",animationOnDataChange:"none",animationOnDisplay:"none",scrollbar:{horizontal:"off",vertical:"off"},gridlines:{horizontal:"hidden",vertical:"visible"},selectionMode:"none",scrollPosition:{y:0},rowDefaults:{height:null},taskDefaults:{labelPosition:["end","innerCenter","start","max"],borderRadius:"0",overlap:{behavior:"auto",offset:null},progress:{height:"100%",borderRadius:"0"},baseline:{borderRadius:"0"},type:"auto"},rowAxis:{rendered:"off",width:"max-content",maxWidth:"none"}},y.prototype.getNoCloneObject=function(){return{start:!0,end:!0,viewportStart:!0,viewportEnd:!0,rows:!0,dependencies:!0,referenceObjects:{value:!0},majorAxis:{converter:!0,scale:!0,zoomOrder:!0},minorAxis:{converter:!0,scale:!0,zoomOrder:!0},valueFormats:{baselineDate:{converter:!0},baselineEnd:{converter:!0},baselineStart:{converter:!0},date:{converter:!0},downtimeEnd:{converter:!0},downtimeStart:{converter:!0},end:{converter:!0},overtimeEnd:{converter:!0},overtimeStart:{converter:!0},progress:{converter:!0},start:{converter:!0}},_resources:{converter:!0,defaultDateConverter:!0,defaultDateTimeConverter:!0,percentConverter:!0}}},y.prototype.getAnimationDuration=function(t){return t._resources?t._resources.animationDuration:null};var v=function(){};e.Obj.createSubclass(v,e.Obj),v.prototype.parse=function(t){var e=new Object,i=function(e){var i=typeof t[e];if("number"===i||"string"===i){var a=new Date(t[e]).getTime();if(!isNaN(a))return a}return null};return e.start=i("start"),e.end=i("end"),t.viewportStart&&(e.viewStart=i("viewportStart")),t.viewportEnd&&(e.viewEnd=i("viewportEnd")),e.rows=t.rows,e.dependencies=t.dependencies,e.axisPosition="top",null!=t.axisPosition&&(e.axisPosition=t.axisPosition),e.selectionMode="none",null!=t.selectionMode&&(e.selectionMode=t.selectionMode),e.horizontalGridline="hidden",e.verticalGridline="hidden",null!=t.gridlines&&(null!=t.gridlines.horizontal&&(e.horizontalGridline=t.gridlines.horizontal),null!=t.gridlines.vertical&&(e.verticalGridline=t.gridlines.vertical)),e.xScrollbar="off",e.yScrollbar="off",t.scrollbars&&(t.scrollbars.horizontal&&(e.xScrollbar=t.scrollbars.horizontal),t.scrollbars.vertical&&(e.yScrollbar=t.scrollbars.vertical)),e.isIRAnimationEnabled="auto"===t.animationOnDisplay,e.isDCAnimationEnabled="auto"===t.animationOnDataChange,null!=t.rowAxis&&(e.rowAxisRendered=t.rowAxis.rendered,e.rowAxisWidth=t.rowAxis.width,e.rowAxisMaxWidth=t.rowAxis.maxWidth),e.referenceObjects=t.referenceObjects,e.styleClass=t.className,e.inlineStyle=t.style,e};var S=function(t){this.Init(t)};e.Obj.createSubclass(S,e.Container),S.prototype.Init=function(t){S.superclass.Init.call(this,t.getCtx()),this._gantt=t;var i=t.getEventManager();this.addEvtListener(e.MouseEvent.MOUSEMOVE,i.OnMouseMove.bind(i),!1,this),this.addEvtListener(e.MouseEvent.MOUSEOVER,i.PreOnMouseOver.bind(i),!1,this),this.addEvtListener(e.MouseEvent.MOUSEOUT,i.PreOnMouseOut.bind(i),!1,this),this._labelBackgroundContainer=new e.Container(t.getCtx()),this.addChild(this._labelBackgroundContainer),this._labelContentContainer=new e.Container(t.getCtx()),this.addChild(this._labelContentContainer)},S.prototype.getDefaultRowLabelStyle=function(t){var e=this._gantt.getOptions();return t?(this._defaultLabelCSSStyle||(this._defaultLabelCSSStyle=n.getRowLabelStyle(e)),this._defaultLabelCSSStyle):n.getRowLabelStyle(e)},S.prototype._getCSSStyle=function(t){if(null!=t&&""!==t&&0!==Object.keys(t).length){var e=this.getDefaultRowLabelStyle(!1);return e.parseInlineStyle(t),e}return this.getDefaultRowLabelStyle(!0)},S.prototype.getLabelContentType=function(){var t=this._gantt.getOptions().rowAxis;return t.label&&t.label.renderer?"custom":"text"},S.prototype._getAvailableWidth=function(t){var e,i,a=this._gantt.getRowAxisMaxWidth(),s=this._gantt.getRowAxisWidth();return null!=a&&"none"!==a&&(e=Math.min(n.getSizeInPixels(a,t),t)),e=null==e||isNaN(e)?t:e,null!=s&&"max-content"!==s&&(i=n.getSizeInPixels(this._gantt.getRowAxisWidth(),t)),{maxWidth:e,width:i=null==i||isNaN(i)?-1:i,calculatedWidth:-1!==i?Math.min(i,e):e}},S.prototype.getAvailableWidth=function(){return this._availableWidth},S.prototype.getWidth=function(){return this._width},S.prototype.getLabelContentIndentSize=function(t){return t.depth*n.getRowLabelIndentSize()+n.getRowLabelButtonSize()+n.getRowLabelButtonContentGapSize()},S.prototype._getMaxTextContentWidth=function(t,i,a){if(!this._gantt.isRowsHierarchical())return e.TextUtils.getMaxTextStringWidth(t,i,a);for(var n=this._gantt.getRowLayoutObjs(),s=0,r=0;r<i.length;r++){var o=i[r]?i[r]:"",h=a[r],l=e.TextUtils.getTextStringWidth(t,o,h),d=(null==n[r].expanded&&0===o.length?0:this.getLabelContentIndentSize(n[r]))+l;d>s&&(s=d)}return s},S.prototype.render=function(t,e){if(this._availableWidth=this._getAvailableWidth(t),e)-1!==this._availableWidth.width&&(this._width=this._availableWidth.calculatedWidth);else{this._rowLabelContents=[];var i=this.getLabelContentType(),a=this._gantt.getRowLayoutObjs();if(-1===this._availableWidth.width){if("text"===i){for(var s=[],o=[],h=0;h<a.length;h++){var l=a[h].data,d=null!=l.label?l.label:"",g=this._getCSSStyle(l.labelStyle);s.push(d),o.push(g),this._rowLabelContents.push(null)}this._width=this._getMaxTextContentWidth(this._gantt.getCtx(),s,o)}else if("custom"===i){this._width=0;for(h=0;h<a.length;h++){var c=a[h],_=new r(this,i);_.setRowIndex(h),_.render(c),this._width=Math.max(this._width,_.getWidth()),this._rowLabelContents.push(_)}}this._width+=2*n.getRowLabelPadding(this._gantt.getOptions())}else{this._width=this._availableWidth.calculatedWidth;for(h=0;h<a.length;h++)this._rowLabelContents.push(null)}this._width=Math.ceil(Math.min(this._width,this._availableWidth.maxWidth))}},S.prototype.addLabelContent=function(t){this._labelContentContainer.addChild(t)},S.prototype.removeLabelContent=function(t){this._labelContentContainer.removeChild(t)},S.prototype.addLabelBackground=function(t){this._labelBackgroundContainer.addChild(t)},S.prototype.removeLabelBackground=function(t){this._labelBackgroundContainer.removeChild(t)},S.prototype.addHorizontalLine=function(t){this._labelContentContainer.addChild(t)},S.prototype.removeHorizontalLine=function(t){this._labelContentContainer.removeChild(t)},S.prototype.getRowLabelContents=function(){return this._rowLabelContents},S.prototype.setBackgroundContainer=function(t){this._backgroundContainer=t},S.prototype.getBackgroundContainer=function(){return this._backgroundContainer},S.prototype.setBackgroundDivider=function(t){this._backgroundDivider=t},S.prototype.getBackgroundDivider=function(){return this._backgroundDivider},S.prototype.adjustPosition=function(){var t=e.Agent.isRightToLeft(this._gantt.getCtx()),i=this._width,a=this._gantt.getCanvasSize()-this._gantt.getAxesHeight(),s=t?this._gantt.getStartXOffset()+this._gantt.getCanvasLength()+this._gantt.getBorderWidth()+n.getRowAxisGap():0;this.setTranslateX(s);var r=new e.ClipPath;r.addRect(this.getTranslateX(),this._gantt.getDatabodyStart()+this._gantt.getStartYOffset(),i,a),this.setClipPath(r),this._backgroundContainer.setTranslateX(t?s-1:s);var o=new e.ClipPath;if(o.addRect(this.getTranslateX(),0,i,this._gantt._backgroundHeight),this._backgroundContainer.setClipPath(o),this._backgroundDivider){var h=this._gantt.getDatabodyStart()+this._gantt.getStartYOffset()+("top"!==this._gantt.getAxisPosition())*(this._gantt.getDatabodyHeight()+1);this._backgroundDivider.setY1(h),this._backgroundDivider.setY2(h)}},S.prototype.clear=function(){this._labelContentContainer.removeChildren(),this._labelBackgroundContainer.removeChildren()};var T=function(t,e,i){this.Init(t,e,i)};e.Obj.createSubclass(T,e.Container),T.prototype.Init=function(t,e,i){T.superclass.Init.call(this,t.getCtx(),null),this._gantt=t,this._type=e,this._refObjs=i,this._gantt.getEventManager().associate(this,this)},T.prototype._applyStyles=function(){var t,e=this._refObjs[0].svgStyle,i=this._refObjs[0].svgClassName;switch(null!=e&&this._ref.setStyle(e),this._type){case"line":t=this._gantt.GetStyleClass("referenceObjectLine");break;case"timeCursor":t=this._gantt.GetStyleClass("timeCursorLine");break;case"area":t=this._gantt.GetStyleClass("referenceObjectArea");break;default:t=this._gantt.GetStyleClass("referenceObjectLine")}var a=null!=i?t+" "+i:t;this._ref.setClassName(a,!0)},T.prototype._calcCmds=function(t,i,n){var s=e.Agent.isRightToLeft(this._gantt.getCtx()),r=this._gantt.getStartTime(),o=this._gantt.getEndTime(),h=this._gantt.getContentLength(),l="";return"line"===this._type||"timeCursor"===this._type?this._refObjs.forEach(function(d){var g=new Date(d.value).getTime(),c=a.TimeAxisUtils.getDatePosition(r,o,g,h)+(n||0);s&&(c=h-c),l+=e.PathUtils.moveTo(c,t)+e.PathUtils.verticalLineTo(i)},this):this._refObjs.forEach(function(n){var d=new Date(n.start).getTime(),g=new Date(n.end).getTime(),c=a.TimeAxisUtils.getDatePosition(r,o,d,h),_=a.TimeAxisUtils.getDatePosition(r,o,g,h),p=s?h-_:c,u=s?h-c:_;l+=e.PathUtils.moveTo(p,t)+e.PathUtils.horizontalLineTo(u)+e.PathUtils.verticalLineTo(i)+e.PathUtils.horizontalLineTo(p)+e.PathUtils.verticalLineTo(t)},this),l},T.prototype.render=function(t,i,a){if(0!==this._refObjs.length){if(this._y1=null==i?this._gantt.getDatabodyStart():i,this._y2=null==a?this._gantt.getDatabodyStart()+this._gantt._canvasSize-this._gantt.getAxesHeight():a,this._ref=new e.Path(this._gantt.getCtx(),this._calcCmds(this._y1,this._y2,0)),"line"===this._type||"timeCursor"===this._type){this._partnerRef=new e.Path(this._gantt.getCtx(),this._calcCmds(this._y1,this._y2,1));var n=this._gantt.GetStyleClass("timeCursor"===this._type?"timeCursorInnerLine":"referenceObjectInnerLine");this._partnerRef.setClassName(n,!0),this.addChild(this._partnerRef)}this._applyStyles(),this.addChild(this._ref),t.addChild(this)}},T.prototype.updateRefObjs=function(t,e,i){this._refObjs=t,this._y1=null==e?this._y1:e,this._y2=null==i?this._y2:i,this._ref.setCmds(this._calcCmds(this._y1,this._y2,0)),this._partnerRef&&this._partnerRef.setCmds(this._calcCmds(this._y1,this._y2,1))},T.prototype.getY1=function(){return this._y1},T.prototype.getY2=function(){return this._y2},T.prototype.setY2=function(t){this.updateRefObjs(this._refObjs,this._y1,t)},T.prototype.hide=function(){this.setAlpha(0)},T.prototype.show=function(){this.setAlpha(1)},T.prototype.getDatatip=function(){return this._refObjs[0].shortDesc};var D={};e.Obj.createSubclass(D,e.Obj),D.renderGantt=function(t){if(D._renderBackground(t),D._renderScrollableCanvas(t),t.getAnimationManager().preAnimateGanttIR(t),t.removeEmptyText(),t.hasValidOptions()){D._prepareTaskFillFilters(t),t.renderTimeZoomCanvas(t._canvas);var e=t.getTimeZoomCanvas();if(D._renderAxes(t,e),D._renderDatabodyBackground(t,e),D._renderRowReferenceObjectsContainer(t,e),D._renderReferenceObjects(t,e,"area"),D._renderVerticalGridline(t,e),t.isRowAxisEnabled()&&t.getRowAxis().adjustPosition(),D._renderData(t,e,m.VPC_REFRESH),D._renderReferenceObjects(t,e,"line"),D._renderTimeCursor(t,e),D._renderZoomControls(t),t.isMarqueeSelectEnabled())D._renderMarqueeArtifactsContainer(t,e);else{var i=t.getMarqueeArtifactsContainer();i&&(i.getParent().removeChild(i),t.setMarqueeArtifactsContainer(null))}if(t.isDndEnabled()&&D._renderDnDArtifactsContainer(t,e),null!=t.getRenderState()){var a=t.getEventManager().getFocus();a&&a instanceof p&&a.refreshAriaLabel()}t._processInitialSelections(),(t.isTimeDirScrollbarOn()||t.isContentDirScrollbarOn())&&D._renderScrollbars(t,t),t.setIsLastRenderValid(!0)}else D._renderEmptyText(t),t.setIsLastRenderValid(!1);D.renderRowAxisVerticalDivider(t,t._canvas)},D._prepareTaskFillFilters=function(t){if(!document.getElementById(n.getTaskTintFilterId())){var i=n.getTaskTintAlpha(),a=e.SvgShapeUtils.createElement("filter",n.getTaskTintFilterId()),s=e.SvgShapeUtils.createElement("feColorMatrix");s.setAttribute("color-interpolation-filters","sRGB"),s.setAttribute("type","matrix"),s.setAttribute("values",1-i+" 0 0 0 "+i+" 0 "+(1-i)+" 0 0 "+i+" 0 0 "+(1-i)+" 0 "+i+" 0 0 0 1 0"),a.appendChild(s);var r=n.getTaskShadeAlpha(),o=e.SvgShapeUtils.createElement("filter",n.getTaskShadeFilterId()),h=e.SvgShapeUtils.createElement("feColorMatrix");h.setAttribute("color-interpolation-filters","sRGB"),h.setAttribute("type","matrix"),h.setAttribute("values",1-r+" 0 0 0 0 0 "+(1-r)+" 0 0 0 0 0 "+(1-r)+" 0 0 0 0 0 1 0"),o.appendChild(h),t.appendSharedDefs(a),t.appendSharedDefs(o)}},D._prerenderTimeDirScrollbar=function(t,i,a){var n=a.w,s=e.CSSStyle.toNumber(t.timeDirScrollbarStyles.getHeight());return t.setTimeDirScrollbar(new e.SimpleScrollbar(t.getCtx(),t.HandleEvent,t)),i.addChild(t.timeDirScrollbar),e.LayoutUtils.position(a,"bottom",t.timeDirScrollbar,n,s,0),new e.Dimension(n,s)},D._prerenderContentDirScrollbar=function(t,i,a){var n=e.CSSStyle.toNumber(t.contentDirScrollbarStyles.getWidth()),s=a.h;return t.setContentDirScrollbar(new e.SimpleScrollbar(t.getCtx(),t.HandleEvent,t)),i.addChild(t.contentDirScrollbar),e.LayoutUtils.position(a,e.Agent.isRightToLeft(t.getCtx())?"left":"right",t.contentDirScrollbar,n,s,0),new e.Dimension(n,s)},D._renderScrollbars=function(t,i){var a=t.getDatabody();if(null!=a){var n=t.getDatabodyStart(),s=t.getCtx(),r=t.getScrollbarPadding();if(null==t._scrollbarsCanvas?(t._scrollbarsCanvas=new e.Container(s,"g","sbCanvas"),i.addChild(t._scrollbarsCanvas)):t._scrollbarsCanvas.removeChildren(),t.isTimeDirScrollbarOn())var o=t.getCanvasLength(),h=t.Height-r,l=D._prerenderTimeDirScrollbar(t,t._scrollbarsCanvas,new e.Rectangle(0,0,o,h));if(t.isContentDirScrollbarOn()){o=t.Width-r,h=t.getCanvasSize()-t.getAxesHeight();var d=e.Agent.isRightToLeft(t.getCtx())?t.getScrollbarPadding():0,g=D._prerenderContentDirScrollbar(t,t._scrollbarsCanvas,new e.Rectangle(d,0,o-d,h))}if(t.timeDirScrollbar&&l){var c={};c.color=t.timeDirScrollbarStyles.getStyle(e.CSSStyle.COLOR),c.backgroundColor=t.timeDirScrollbarStyles.getStyle(e.CSSStyle.BACKGROUND_COLOR),c.min=t._start,c.max=t._end,c.isHorizontal=!0,c.isReversed=e.Agent.isRightToLeft(t.getCtx()),t.timeDirScrollbar.setTranslateX(t.getStartXOffset()),t.timeDirScrollbar.render(c,l.w,l.h),t.timeDirScrollbar.setViewportRange(t._viewStartTime,t._viewEndTime)}if(t.contentDirScrollbar&&g){(c={}).color=t.contentDirScrollbarStyles.getStyle(e.CSSStyle.COLOR),c.backgroundColor=t.contentDirScrollbarStyles.getStyle(e.CSSStyle.BACKGROUND_COLOR),c.min=-(Math.max(t.getContentHeight(),g.h)-n),c.max=n,c.isHorizontal=!1,c.isReversed=!0,t.contentDirScrollbar.setTranslateY(n+t.getStartYOffset()),t.contentDirScrollbar.render(c,g.w,g.h);var _=0;"bottom"===t.getAxisPosition()&&(_=t.getAxesHeight()),t.contentDirScrollbar.setViewportRange(a.getTranslateY()-(t.getCanvasSize()-n-_),a.getTranslateY())}}else null!=t._scrollbarsCanvas&&t._scrollbarsCanvas.removeChildren()},D.renderRowAxisVerticalDivider=function(t,i){var a=t.getCtx();if("alta"!==a.getThemeBehavior()&&t.isRowAxisEnabled()){var n=e.Agent.isRightToLeft(a)?t.getStartXOffset()+t.getCanvasLength():Math.round(t.getStartXOffset())+.5;t._rowAxisVerticalDivider?t._rowAxisVerticalDivider.setX1(n).setX2(n):(t._rowAxisVerticalDivider=new e.Line(a,n,t.getStartYOffset(),n,t._canvasSize+2*t.getBorderWidth()),t._rowAxisVerticalDivider.setPixelHinting(!0),t._rowAxisVerticalDivider.setClassName(t.GetStyleClass("majorvgridline"),!0),i.addChild(t._rowAxisVerticalDivider))}},D.renderRowAxis=function(t,i){var a=e.Agent.isRightToLeft(t.getCtx()),s=t.getRowAxis();if(t.isRowAxisEnabled()){s||((s=new S(t)).setPixelHinting(!0),t.setRowAxis(s),s.setBackgroundContainer(new e.Container(t.getCtx()))),i&&(i.addChild(s),t.getParent().addChildAt(s.getBackgroundContainer(),0)),s.render(t.Width-n.getRowAxisGap(),null==i);var r=s.getWidth(),o=r>0?r+n.getRowAxisGap():0;t._backgroundWidth=t._backgroundWidth-o,a||(t._widthOffset=t._widthOffset+o,t.setStartXOffset(t.getStartXOffset()+o)),t._canvasLength=t._canvasLength-o;var h=s.getBackgroundContainer();h.removeChildren(),s.setBackgroundDivider();var l=new e.Rect(t.getCtx(),0,0,r+1,t._backgroundHeight);if(l.setClassName(t.GetStyleClass("databody")),l.setPixelHinting(!0),h.addChild(l),"alta"===t.getCtx().getThemeBehavior()||t.isHorizontalGridlinesVisible()){var d=new e.Line(t.getCtx(),0,0,r,0);d.setPixelHinting(!0),d.setClassName(t.GetStyleClass("hgridline"),!0),h.addChild(d),s.setBackgroundDivider(d)}}else i&&s&&(t.getParent().removeChild(s.getBackgroundContainer()),i.removeChild(s)),t.setRowAxis(null)},D._renderBackground=function(t){var i=t._backgroundWidth,a=t._backgroundHeight;t._background?(t._background.setClipPath(null),t._background.setWidth(i),t._background.setHeight(a),t._background.setX(t._widthOffset)):t._background=new e.Rect(t.getCtx(),t._widthOffset,0,i,a,"bg"),t._background.setClassName(t.GetStyleClass("databody")),t._background.setPixelHinting(!0);var n=new e.ClipPath;n.addRect(t._widthOffset,0,i,a),t._background.setClipPath(n),t._background.getParent()!=t&&t.addChild(t._background)},D._renderDatabodyBackground=function(t,i){var a=t.getDatabodyBackground();null==a&&(a=new e.Container(t.getCtx()),i.addChild(a),t.setDatabodyBackground(a)),null==t.getDatabody()&&a.setTranslateY(t.scrollPositionToTranslateY(t.getOptions().scrollPosition));var n=new e.ClipPath;n.addRect(0,t.getDatabodyStart(),t.getContentLength(),t.getDatabodyHeight()),a.setClipPath(n)},D._renderRowReferenceObjectsContainer=function(t,i){var a=t.getRowReferenceObjectsContainer();null==a&&(a=new e.Container(t.getCtx()),i.addChild(a),t.setRowReferenceObjectsContainer(a)),null==t.getDatabody()&&a.setTranslateY(t.getDatabodyBackground().getTranslateY());var n=new e.ClipPath;n.addRect(0,t.getDatabodyStart(),t.getContentLength(),t.getDatabodyHeight()),a.setClipPath(n)},D._renderDnDArtifactsContainer=function(t,i){var a=t.getDatabody();if(a){var n=t.getDnDArtifactsContainer();null==n&&(n=new e.Container(t.getCtx()),t.setDnDArtifactsContainer(n),n.setTranslateY(a.getTranslateY())),i.addChild(n);var s=new e.ClipPath;s.addRect(0,t.getDatabodyStart(),t.getContentLength(),t.getDatabodyHeight()),n.setClipPath(s)}},D._renderMarqueeArtifactsContainer=function(t,i){var a=t.getDatabody();if(a){var n=t.getMarqueeArtifactsContainer();null==n&&(n=new e.Container(t.getCtx()),t.setMarqueeArtifactsContainer(n),n.setTranslateY(a.getTranslateY())),i.addChild(n);var s=new e.ClipPath;s.addRect(0,t.getDatabodyStart(),t.getContentLength(),t.getDatabodyHeight()),n.setClipPath(s);var r=t.getEventManager();if("multiple"===t.getOptions().selectionMode){var o=new e.Rectangle(1,1,t.getContentLength()-1,t.getContentHeight()-1),h=new e.SolidFill(""),l=new e.Stroke(""),d=new e.MarqueeHandler(n,o,o,h,l,!0,!0);r.setMarqueeSelectHandler(d)}}},D._renderScrollableCanvas=function(t){t._canvas||(t._canvas=new e.Container(t.getCtx(),"g","canvas"),t.addChild(t._canvas))},D._renderAxes=function(t,e,i){var a=t.getMajorAxis(),n=t.getMinorAxis(),s=t.getAxisPosition(),r=t.getOptions(),o=t.getReferenceObjects();if("top"===s){var h=0;a&&(D._renderAxis(t,e,a,h,t.getAxisHeight(r,"majorAxis"),[],i),h+=a.getSize()),n&&(D._renderAxis(t,e,n,h,t.getAxisHeight(r,"minorAxis"),o,i),h+=n.getSize()),t.setDatabodyStart(h)}else h=t._canvasSize,a&&(D._renderAxis(t,e,a,null,t.getAxisHeight(r,"majorAxis"),[],i),h-=a.getSize(),D._positionAxis(a,h)),n&&(D._renderAxis(t,e,n,h,t.getAxisHeight(r,"minorAxis"),o,i),h-=n.getSize(),D._positionAxis(n,h)),t.setDatabodyStart(0)},D._renderAxis=function(t,e,i,a,n,s,r){i.getParent()!==e&&e.addChild(i),i.render({_viewStartTime:t._viewStartTime,_viewEndTime:t._viewEndTime,_referenceObjects:{referenceObjects:s,defaultStyleClass:t.GetStyleClass("referenceObjectLine"),defaultStroke:null},_throttle:r},t.getContentLength(),n),null!=a&&D._positionAxis(i,a)},D._positionAxis=function(t,i){var a=new e.Matrix(1,0,0,1,0,i);t.setMatrix(a)},D._renderZoomControls=function(t){var i=t.getCtx(),a=t._resources,s=e.Agent.isRightToLeft(i),r={zoomInProps:{imageSize:16,class:a.zoomIn},zoomOutProps:{imageSize:16,class:a.zoomOut}};if(s)var o=t.getStartXOffset()+n._DEFAULT_ZOOM_CONTROL_PADDING;else o=t.getCanvasLength()+t.getStartXOffset()-(n._DEFAULT_ZOOM_CONTROL_PADDING+n._DEFAULT_ZOOM_CONTROL_DIAMETER);r.zoomInProps.posX=o,r.zoomOutProps.posX=o;var h=t._startY+n._DEFAULT_ZOOM_CONTROL_PADDING;if("top"===t.getAxisPosition())var l=h;else l=t._backgroundHeight-h;if("top"===t.getAxisPosition())var d=l,g=l+n._DEFAULT_ZOOM_CONTROL_DIAMETER+n._DEFAULT_ZOOM_CONTROL_SPACING;else d=l-2*n._DEFAULT_ZOOM_CONTROL_DIAMETER-n._DEFAULT_ZOOM_CONTROL_SPACING,g=l-n._DEFAULT_ZOOM_CONTROL_DIAMETER;r.zoomInProps.posY=d,r.zoomOutProps.posY=g,t.renderZoomControls(r)},D._renderEmptyText=function(t,i){if(i){var a=t.getDatabody();a&&a.getParent()&&(a.getParent().removeChild(a),t.setDatabody(null)),t.getDataLayoutManager().clear();var n=t.getOptions().translations.labelNoData;t.removeEmptyText()}else n=t.getOptions().translations.labelInvalidData,t.clearComponent();var s=t.getAxesHeight(),r=t.renderEmptyText(t._canvas,n,new e.Rectangle(t.getStartXOffset(),t.getStartYOffset()+s*("top"===t.getAxisPosition()),t.getCanvasLength(),t.getCanvasSize()-s),t.EventManager,null);r.setClassName(t.GetStyleClass("nodata")),t.setEmptyText(r)},D._renderDatabody=function(t,i){var a=t.getDatabody();null==a&&(a=new e.Container(t.getCtx(),"g","db"),i.addChild(a),t.setDatabody(a),a.setTranslateY(t.getDatabodyBackground().getTranslateY()));var n=new e.ClipPath;n.addRect(0,t.getDatabodyStart(),t.getContentLength(),t.getDatabodyHeight()),a.setClipPath(n)},D._renderVerticalGridline=function(t,i){var n=t.getVerticalGridlines();if(null!=n&&n.removeChildren(),t.isVerticalGridlinesVisible()){null==n&&(n=new e.Container(t.getCtx()),i.addChild(n),t.setVerticalGridlines(n));const s=t.getStartTime(),r=t.getEndTime(),o=t.getContentLength(),h=function(i,n,h){var l=t.getCtx(),d=e.Agent.isRightToLeft(l);n.forEach((g,c)=>{let _=a.TimeAxisUtils.getDatePosition(s,r,g.getTime(),o);d&&(_=o-_),(!d&&0===c||d&&c===n.length-1)&&(_=Math.round(_)+.5);const p=new e.Line(l,_,t.getDatabodyStart(),_,t.getDatabodyStart()+t._canvasSize-t.getAxesHeight());p.setPixelHinting(!0),p.setMouseEnabled(!1),p.setClassName(h,!0),i.addChild(p)})},l=function(e,i){const a=i?i.getViewportDates(i.getScale(),s,r):[],n=e.getViewportDates(e.getScale(),s,r);if("alta"===t.getCtx().getThemeBehavior())return{major:a,minor:i?[]:n};const o=new Set(a.map(t=>t.getTime())),h=new Set(n.map(t=>t.getTime())),l=0===a.filter(t=>t.getTime()>s&&t.getTime()<r&&!h.has(t.getTime())).length;return{major:l?a:[],minor:l?n.filter(t=>!o.has(t.getTime())):n}}(t.getMinorAxis(),t.getMajorAxis());h(n,l.minor,t.GetStyleClass("minorvgridline")),h(n,l.major,t.GetStyleClass("majorvgridline"))}},D._renderReferenceObjects=function(t,i,a){var n="line"===a?t.getReferenceLinesContainer():t.getReferenceAreasContainer();null==n&&(n=new e.Container(t.getCtx()),i.addChild(n),"line"===a?t.setReferenceLinesContainer(n):t.setReferenceAreasContainer(n)),n.removeChildren();var s=function(t){return null!=t&&!isNaN(new Date(t).getTime())},r=t.getReferenceObjects().filter(function(t){return"line"===a?("line"===t.type||null==t.type)&&s(t.value):"area"===t.type&&s(t.start)&&s(t.end)});t.generateReferenceObjects(r,a).forEach(t=>t.render(n))},D._renderTimeCursor=function(t,i){var a=t.getTimeCursorContainer();null==a&&(a=new e.Container(t.getCtx()),i.addChild(a),t.setTimeCursorContainer(a)),a.removeChildren();var n=new T(t,"timeCursor",[{type:"line",value:new Date(t.getStartTime()).toISOString()}]);n.render(a),n.setMouseEnabled(!1),n.hide(),t.setTimeCursor(n)},D._renderData=function(t,e,i){var a=t.getOptions(),s=t.getRowLayoutObjs(),r=t.getDependencyLayoutObjs();if(0!==s.length){D._renderDatabody(t,e),r.length>0&&D._renderDependenciesContainer(t,e),t.getCache().getFromCache("baseTaskLabelCSSStyle")||t.getCache().putToCache("baseTaskLabelCSSStyle",n.getTaskLabelStyle(a)),t.setDataRegionTranslateY(t.getBoundedContentTranslateY(t.getDatabody().getTranslateY()));var o=!t.isInitialRender()&&t.isLastRenderValid()&&"none"!==t.getAnimationManager().getAnimationMode();t.renderViewport(o?m.VPC_ANIMATE:i,!0)}else D._renderEmptyText(t,!0)},D._renderDependenciesContainer=function(t,i){var a=t.getDependenciesContainer();null==a&&((a=new e.Container(t.getCtx())).setTranslateY(t.getDatabody().getTranslateY()),i.addChild(a),t.setDependenciesContainer(a),D._prepareDependencyMarkers(t));var n=new e.ClipPath;n.addRect(0,t.getDatabodyStart(),t.getContentLength(),t.getDatabodyHeight()),a.setClipPath(n)},D._prepareDependencyMarkers=function(t){if(!document.getElementById(n.getDependencyLineAngleMarkerId())){var e=D._createTriangleMarker(t),i=D._createAngleMarker(t),a=D._createOpenCircleMarker(t),s=D._createClosedCircleMarker(t);t.appendSharedDefs(e),t.appendSharedDefs(i),t.appendSharedDefs(a),t.appendSharedDefs(s)}},D._createTriangleMarker=function(t){var e=n.getDependencyLineTriangleMarkerId(),i=n.getDependencyLineTriangleMarkerWidth(),a=n.getDependencyLineTriangleMarkerHeight(),s=t.GetStyleClass("dependencyLineConnector"),r="M0,0L"+i+","+a/2+",0,"+a+"V0Z";return this._createMarker(t,e,i,a,r,s)},D._createAngleMarker=function(t){var e=n.getDependencyLineAngleMarkerId(),i=n.getDependencyLineAngleMarkerWidth(),a=n.getDependencyLineAngleMarkerHeight(),s=t.GetStyleClass("dependencyRectilinearLineArrowConnector"),r="M0,0L"+i+","+a/2+",0,"+a;return this._createMarker(t,e,i,a,r,s)},D._createMarker=function(t,i,a,n,s,r){var o=t.GetStyleClass("dependencyLineConnector")+" "+r,h=e.SvgShapeUtils.createElement("marker",i);e.ToolkitUtils.setAttrNullNS(h,"class",o),e.ToolkitUtils.setAttrNullNS(h,"markerUnits","userSpaceOnUse");var l=e.SvgShapeUtils.createElement("path");return e.ToolkitUtils.setAttrNullNS(h,"viewBox","0 0 "+a+" "+n),e.ToolkitUtils.setAttrNullNS(h,"refX",a),e.ToolkitUtils.setAttrNullNS(h,"refY",n/2),e.ToolkitUtils.setAttrNullNS(h,"markerWidth",a),e.ToolkitUtils.setAttrNullNS(h,"markerHeight",n),e.ToolkitUtils.setAttrNullNS(h,"orient","auto"),e.ToolkitUtils.setAttrNullNS(l,"d",s),h.appendChild(l),h},D._createOpenCircleMarker=function(t){var e=n.getDependencyLineOpenCircleMarkerId(),i=n.getDependencyLineCircleMarkerRadius(),a=t.GetStyleClass("dependencyStraightLineOpenCircleConnector");return this._createCircleMarker(t,e,i,a)},D._createClosedCircleMarker=function(t){var e=n.getDependencyLineClosedCircleMarkerId(),i=n.getDependencyLineCircleMarkerRadius(),a=t.GetStyleClass("dependencyStraightLineClosedCircleConnector");return this._createCircleMarker(t,e,i,a)},D._createCircleMarker=function(t,i,a,n){var s=t.GetStyleClass("dependencyLineConnector")+" "+n,r=e.SvgShapeUtils.createElement("marker",i);e.ToolkitUtils.setAttrNullNS(r,"class",s),e.ToolkitUtils.setAttrNullNS(r,"markerUnits","userSpaceOnUse");var o=e.SvgShapeUtils.createElement("circle"),h=2*a+2,l=2*a+2;return e.ToolkitUtils.setAttrNullNS(r,"viewBox","0 0 "+h+" "+l),e.ToolkitUtils.setAttrNullNS(r,"refX",h/2),e.ToolkitUtils.setAttrNullNS(r,"refY",l/2),e.ToolkitUtils.setAttrNullNS(r,"markerWidth",h),e.ToolkitUtils.setAttrNullNS(r,"markerHeight",l),e.ToolkitUtils.setAttrNullNS(r,"orient","auto"),e.ToolkitUtils.setAttrNullNS(o,"cx",h/2),e.ToolkitUtils.setAttrNullNS(o,"cy",l/2),e.ToolkitUtils.setAttrNullNS(o,"r",a),r.appendChild(o),r};const C=function(t,e,i){this.Init(t,e,i)};e.Obj.createSubclass(C,i.TimeComponent),C.newInstance=function(t,e,i){return new C(t,e,i)},C.prototype.Init=function(t,i,a){this._isInitialRender=!0,C.superclass.Init.call(this,t,i,a),this.Defaults=new y(t),this.EventManager=new l(this,t,i,a),this.EventManager.addListeners(this),e.Agent.isTouchDevice()?this._keyboardHandler=null:(this._keyboardHandler=new d(this,this.EventManager),this.EventManager.setKeyboardHandler(this._keyboardHandler))},C.prototype.SetOptions=function(t){null==t.taskDefaults&&(t.taskDefaults={baseline:{}}),null==t.taskDefaults.baseline&&(t.taskDefaults.baseline={}),null==t.taskDefaults.height&&(t.taskDefaults.height=n.getStandaloneTaskHeight(t)),null==t.taskDefaults.baseline.height&&(t.taskDefaults.baseline.height=n.getBaselineTaskHeight(t)),C.superclass.SetOptions.call(this,t),this.setSelectionMode(this.Options.selectionMode);var i=this.isTaskMoveEnabled(),a=this.isTaskResizeEnabled();if(i||a){this.Options.dnd=e.JsonUtils.merge(this.Options.dnd,{drag:{tasks:{dataTypes:[]},taskResizeHandles:{dataTypes:[]}},drop:{rows:{dataTypes:[]}}});var s=this,r=function(t,e){var i=s.Options.dnd.drag[e].dataTypes;Array.isArray(i)||(s.Options.dnd.drag[e].dataTypes=[i],i=s.Options.dnd.drag[e].dataTypes),i.push(t);var a=s.Options.dnd.drop.rows.dataTypes;Array.isArray(a)||(s.Options.dnd.drop.rows.dataTypes=[a],a=s.Options.dnd.drop.rows.dataTypes),a.push(t)};a&&r(l.RESIZE_TASKS_DATA_TYPE,"taskResizeHandles"),i&&r(l.MOVE_TASKS_DATA_TYPE,"tasks")}},C.prototype.getAutomation=function(){return this.Automation||(this.Automation=new f(this)),this.Automation},C.prototype.GetStyleClass=function(t){var e=this.getCtx().styleClasses;return null!=e?e[t]:t},C.prototype.Parse=function(t){return this._parser=new v,this._parser.parse(t)},C.prototype._applyParsedProperties=function(t){this._axisPosition=t.axisPosition,this._selectionMode=t.selectionMode,this._horizontalGridline=t.horizontalGridline,this._verticalGridline=t.verticalGridline,this._viewStartTime=t.viewStart,this._viewEndTime=t.viewEnd,this._rowsData=t.rows,this.isIRAnimationEnabled=t.isIRAnimationEnabled,this.isDCAnimationEnabled=t.isDCAnimationEnabled,this._rowAxisRendered=t.rowAxisRendered,this._rowAxisWidth=t.rowAxisWidth,this._rowAxisMaxWidth=t.rowAxisMaxWidth,this._referenceObjects=t.referenceObjects,C.superclass._applyParsedProperties.call(this,t)},C.prototype._bundleTimeAxisOptions=function(t,e){var i=this._resources;i.axisClass=this.GetStyleClass(e),i.axisSeparatorClass=this.GetStyleClass(e+"Ticks"),i.axisLabelClass=this.GetStyleClass(e+"Labels");var a,s={start:t.start,end:t.end,_resources:i,shortDesc:t.shortDesc,orientation:"horizontal"};if(t[e]){var r=t[e];r.scale&&(s.scale=r.scale),r.converter&&(s.converter=r.converter),s.zoomOrder=r.zoomOrder||[r.scale];"alta"===this.getCtx().getThemeBehavior()?(s._scaleLabelPosition={seconds:"center",minutes:"center",hours:"center",days:"center",weeks:"center",months:"center",quarters:"center",years:"center"},s._labelAlignment={horizontal:"middle",vertical:"middle"}):(s._scaleLabelPosition={seconds:"start",minutes:"start",hours:"start",days:"minorAxis"===e?"center":"start",weeks:"start",months:"start",quarters:"start",years:"start"},s._labelAlignment={horizontal:"top",vertical:"middle"}),s.zoomOrder.forEach(t=>{if(t&&t.name){const e=t.labelPosition||"auto",i="auto"===e?"start":e;s._scaleLabelPosition[t.name]=i}})}return"majorAxis"===e?a=n.getMajorAxisLabelStyle(t):"minorAxis"===e&&(a=n.getMinorAxisLabelStyle(t)),s.labelStyle=a,s},C.prototype._getPreferredSize=function(t,i){return new e.Dimension(t,i)},C.prototype.render=function(t,e,i){if(this.getCache().clearCache(),t){if(C.superclass.render.call(this,t,e,i),this.isDndEnabled()){var n=this.getCtx();this.renderAriaLiveRegion("_dvtGanttAriaLiveRegion"+n.getStage().getId())}else this.removeAriaLiveRegion();this._animationManager=new b(this),this._animationManager.prepareForAnimations(),this._dataLayoutManager||(this._dataLayoutManager=new m(this)),this._dataLayoutManager.calcLayout(),D.renderRowAxis(this,this.getParent());var s,r,o=this.getAxisPosition(),h=t.majorAxis;if(h)if(h.scale){if(s=this._bundleTimeAxisOptions(this.Options,"majorAxis"),null==this._majorAxis){this._majorAxis=new a.TimeAxis(this.getCtx(),null,null);var l="alta"===this.getCtx().getThemeBehavior();"top"===o?this._majorAxis.setBorderVisibility(!1,!1,l,!1):this._majorAxis.setBorderVisibility(l,!1,!1,!1),this._slaveAxis=this._majorAxis}this._majorAxis.setCanvasSize(null);var d=this._majorAxis.getPreferredLength(s,this._canvasLength);r&&d>r&&(this._masterAxis=this._majorAxis,this._slaveAxis=this._minorAxis,r=d)}else this._majorAxis=null;if(t.minorAxis){if((s=this._bundleTimeAxisOptions(this.Options,"minorAxis"))._secondaryAxis=this._majorAxis,null==this._minorAxis){var g="alta"===this.getCtx().getThemeBehavior();this._minorAxis=new a.TimeAxis(this.getCtx(),null,null),"top"===o?this._minorAxis.setBorderVisibility(!1,!1,g,!1):this._minorAxis.setBorderVisibility(g,!1,!1,!1),this._masterAxis=this._minorAxis}this._minorAxis.setCanvasSize(null),r=this._minorAxis.getPreferredLength(s,this._canvasLength)}r&&this.setContentLength(r),this._minorAxis&&this._minorAxis.hasValidOptions()&&this.prepareViewportLength(),D.renderGantt(this),this._animationManager.triggerAnimations(),this.UpdateAriaAttributes(),this.Animation||this.RenderComplete(),this._renderState=null,this._isInitialRender=!1}else this._handleResize(e,i)},C.prototype.getAnimationManager=function(){return this._animationManager},C.prototype.getDataLayoutManager=function(){return this._dataLayoutManager},C.prototype.isRowsHierarchical=function(){var t=this.getOptions(),i=t.rowData||t.taskData;return i&&i.getChildDataProvider||e.Agent.isEnvironmentTest()&&this.getOptions().expanded instanceof Set},C.prototype.getViewportYBounds=function(t){var e=this._backgroundHeight-this.getAxesHeight(),i=0;return null!=t?i=this._translateYToScrollPositionY(t):this._databody&&(i=this._translateYToScrollPositionY(this._databody.getTranslateY())),{yMin:i,yMax:i+e}},C.prototype.getViewPort=function(){var t=this.getViewportYBounds(),e=this._dataLayoutManager.findRowIndRange(this.getRowLayoutObjs(),t.yMin,t.yMax);return{minRowInd:e.minRowInd,maxRowInd:e.maxRowInd,viewStartTime:this._viewStartTime,viewEndTime:this._viewEndTime}},C.prototype.renderViewport=function(t,i){if(null!=this._databody){var a=this.getViewPort();if(this._dataLayoutManager.renderViewport(a,t),i){var n=this._translateYToScrollPositionY(this._databody.getTranslateY()),s=n-this.getRowLayoutObjs()[a.minRowInd].y,r=e.EventFactory.newGanttScrollPositionChangeEvent(n,a.minRowInd,s);this.dispatchEvent(r)}}},C.prototype.isInitialRender=function(){return this._isInitialRender},C.prototype.isLastRenderValid=function(){return this._isLastRenderValid},C.prototype.setIsLastRenderValid=function(t){this._isLastRenderValid=t},C.prototype.getRenderState=function(){return this._renderState},C.prototype.setRenderState=function(t){this._renderState=t},C.prototype.isDndEnabled=function(){var t=this.isTaskMoveEnabled(),e=this.isTaskResizeEnabled();return this.getEventManager().isDndSupported()&&(t||e)},C.prototype.isTaskMoveEnabled=function(){var t=this.Options.dnd;return t&&t.move&&"enabled"===t.move.tasks},C.prototype.isTaskResizeEnabled=function(){var t=this.Options.taskDefaults;return t&&"enabled"===t.resizable},C.prototype.scroll=function(t){if(this.getDatabody()){var e=this.scrollPositionToTranslateY(t);this.isContentDirScrollbarOn()&&this.contentDirScrollbar&&this.contentDirScrollbar.setViewportRange(e-this.getDatabodyHeight(),e),this.setDataRegionTranslateY(e),this.renderViewport(m.VPC_TRANSLATE,!0)}},C.prototype.scrollPositionToTranslateY=function(t){var e=t.rowIndex,i=this.getRowLayoutObjs(),a=0;if(null!=e){var n=i[e=Math.min(Math.max(0,e),i.length-1)];if(null!=n){var s=null!=t.offsetY?t.offsetY:0;a=n.y+s}}else null!=t.y&&(a=t.y);return this._scrollPositionYToTranslateY(a)},C.prototype._scrollPositionYToTranslateY=function(t){return this.getBoundedContentTranslateY(this.getDatabodyStart()-t)},C.prototype._translateYToScrollPositionY=function(t){return this._databody?-(t-this.getDatabodyStart()):0},C.prototype.setDataRegionTranslateY=function(t){this._databody&&this._databody.setTranslateY(t),this._databodyBackground&&this._databodyBackground.setTranslateY(t),this._rowReferenceObjectsContainer&&this._rowReferenceObjectsContainer.setTranslateY(t),this.isMarqueeSelectEnabled()&&this._marqueeArtifactsContainer&&this._marqueeArtifactsContainer.setTranslateY(t),this.isDndEnabled()&&this._dndArtifactsContainer&&this._dndArtifactsContainer.setTranslateY(t),this.isRowAxisEnabled()&&this.getRowAxis().setTranslateY(t+this.getStartYOffset()),this._dependenciesContainer&&this._dependenciesContainer.setTranslateY(t)},C.prototype.processScrollbarEvent=function(t,e){if(C.superclass.processScrollbarEvent.call(this,t,e),e===this.timeDirScrollbar&&D._renderAxes(this,this.getTimeZoomCanvas(),!0),e===this.contentDirScrollbar){var i=t.newMax;this.setDataRegionTranslateY(i,!0)}this.renderViewport(m.VPC_TRANSLATE,e===this.contentDirScrollbar)},C.prototype.createViewportChangeEvent=function(){var t=this._majorAxis?this._majorAxis.getScale():null,i=this._minorAxis?this._minorAxis.getScale():null;return e.EventFactory.newGanttViewportChangeEvent(this._viewStartTime,this._viewEndTime,t,i)},C.prototype._handleResize=function(t,e){this.Width=t,this.Height=e,this.applyStyleValues();var i=this.hasValidOptions();if(i&&D.renderRowAxis(this),this.prepareViewportLength(),D._renderBackground(this),i){this.renderTimeZoomCanvas(this._canvas),this.isRowAxisEnabled()&&this.getRowAxis().adjustPosition();var a=this.getTimeZoomCanvas();D._renderAxes(this,a),D._renderDatabodyBackground(this),D._renderRowReferenceObjectsContainer(this),D._renderReferenceObjects(this,a,"area"),D._renderVerticalGridline(this,a),D._renderData(this,null,m.VPC_SCALE),D._renderReferenceObjects(this,a,"line"),D._renderTimeCursor(this,a),D._renderZoomControls(this),this.isMarqueeSelectEnabled()&&D._renderMarqueeArtifactsContainer(this,a),this.isDndEnabled()&&D._renderDnDArtifactsContainer(this,a),(this.isTimeDirScrollbarOn()||this.isContentDirScrollbarOn())&&D._renderScrollbars(this,this)}else D._renderEmptyText(this);D.renderRowAxisVerticalDivider(this,this._canvas),this.Animation||this.RenderComplete()},C.prototype.applyStyleValues=function(){var t=e.Agent.isRightToLeft(this.getCtx()),i=this.getScrollbarPadding();this._borderWidth=n.getChartStrokeWidth(this.Options);var a=2*this._borderWidth;if(this._widthOffset=0,this.timeDirScrollbarStyles=this.getTimeDirScrollbarStyle(),this.contentDirScrollbarStyles=this.getContentDirScrollbarStyle(),this._backgroundWidth=this.Width,this._backgroundHeight=this.Height,this.isTimeDirScrollbarOn()&&(this._backgroundHeight=this._backgroundHeight-e.CSSStyle.toNumber(this.timeDirScrollbarStyles.getHeight())-3*i),this.isContentDirScrollbarOn()){var s=3*i+e.CSSStyle.toNumber(this.contentDirScrollbarStyles.getWidth());this._backgroundWidth=this._backgroundWidth-s,t&&(this._widthOffset=s)}this.setStartXOffset(this._widthOffset+this._borderWidth),this.setStartYOffset(this._borderWidth),this._canvasLength=this._backgroundWidth-a,this._canvasSize=this._backgroundHeight-a},C.prototype.getBorderWidth=function(){return this._borderWidth},C.prototype.HandleMouseWheel=function(t){if(C.superclass.HandleMouseWheel.call(this,t),this.hasValidOptions())if(!t||t.ctrlKey||e.Agent.isTouchDevice()){if(t.zoomWheelDelta){var a=this.getCtx().pageToStageCoords(t.pageX,t.pageY);if(this.getGraphicalAreaBounds().containsPoint(a.x,a.y)){var n=this.getContentLength()*t.zoomWheelDelta,s=t.zoomTime,r=t.zoomCompLoc;this.handleZoomWheel(n,s,r,!0)}}}else{var o=t.wheelDelta?t.wheelDelta*i.TimeComponent.SCROLL_LINE_HEIGHT:0,h=t.wheelDeltaX?t.wheelDeltaX*i.TimeComponent.SCROLL_LINE_HEIGHT:0;if(this.panBy(-h,-o),t.wheelDeltaX){var l=this.createViewportChangeEvent();this.dispatchEvent(l)}}},C.prototype.handleZoomWheel=function(t,e,i,a){if(this.isZoomingEnabled()){t>this._masterAxis.getMaxContentLength()?(t=this._masterAxis.getMaxContentLength(),this.disableZoomButton(!0)):this.enableZoomButton(!0),this._canvasLength>t?(t=this._canvasLength,this.disableZoomButton(!1)):this.enableZoomButton(!1);var n=this.getContentLength()<=t;C.superclass.handleZoomWheel.call(this,t,e,i,a);var s=this._masterAxis.getZoomLevelLengths();if(n)for(;this._masterAxis.getZoomLevelOrder()>0&&(!this._slaveAxis||this._slaveAxis.getZoomLevelOrder()>0);){var r=s[this._masterAxis.getZoomLevelOrder()-1];if(!(this.getContentLength()>=r))break;this._masterAxis.setZoomLevelOrder(this._masterAxis.getZoomLevelOrder()-1),this._masterAxis.decreaseScale(),this._slaveAxis&&(this._slaveAxis.setZoomLevelOrder(this._slaveAxis.getZoomLevelOrder()-1),this._slaveAxis.decreaseScale())}else for(;this._masterAxis.getZoomLevelOrder()<s.length-1&&(!this._slaveAxis||this._slaveAxis.getZoomLevelOrder()<this._slaveAxis.getZoomLevelLengths().length-1)&&(r=s[this._masterAxis.getZoomLevelOrder()],this.getContentLength()<r);)this._masterAxis.setZoomLevelOrder(this._masterAxis.getZoomLevelOrder()+1),this._masterAxis.increaseScale(),this._slaveAxis&&(this._slaveAxis.setZoomLevelOrder(this._slaveAxis.getZoomLevelOrder()+1),this._slaveAxis.increaseScale());this.isTimeDirScrollbarOn()&&this.timeDirScrollbar&&this.timeDirScrollbar.setViewportRange(this._viewStartTime,this._viewEndTime);var o=this.getTimeZoomCanvas();if(D._renderAxes(this,o,!0),D._renderDatabodyBackground(this),D._renderRowReferenceObjectsContainer(this),D._renderReferenceObjects(this,o,"area"),D._renderVerticalGridline(this,o),D._renderData(this,null,m.VPC_SCALE),D._renderReferenceObjects(this,o,"line"),D._renderTimeCursor(this,o),this.isMarqueeSelectEnabled()&&D._renderMarqueeArtifactsContainer(this,o),this.isDndEnabled()&&D._renderDnDArtifactsContainer(this,o),a){var h=this.createViewportChangeEvent();this.dispatchEvent(h)}}},C.prototype.getMajorAxis=function(){return this._majorAxis},C.prototype.getMinorAxis=function(){return this._minorAxis},C.prototype.getTimeAxis=function(){return this._minorAxis?this._minorAxis:this._majorAxis},C.prototype.getDatabody=function(){return this._databody},C.prototype.setDatabody=function(t){this._databody=t},C.prototype.dimDatabody=function(){this._databody&&e.ToolkitUtils.addClassName(this._databody.getElem(),this.GetStyleClass("databodyDim"))},C.prototype.undimDatabody=function(){this._databody&&e.ToolkitUtils.removeClassName(this._databody.getElem(),this.GetStyleClass("databodyDim"))},C.prototype.getDatabodyBackground=function(){return this._databodyBackground},C.prototype.setDatabodyBackground=function(t){this._databodyBackground=t},C.prototype.getDatabodyStart=function(){return this._databodyStart},C.prototype.setDatabodyStart=function(t){this._databodyStart=t},C.prototype.getDatabodyHeight=function(){return this.getCanvasSize()-this.getAxesHeight()},C.prototype.getVerticalGridlines=function(){return this._gridlines},C.prototype.setVerticalGridlines=function(t){this._gridlines=t},C.prototype.getReferenceObjects=function(){return this._referenceObjects||[]},C.prototype.generateReferenceObjects=function(t,e){const i=[];let a=0,n=0;for(;n<t.length;){var s=t[n];(s.svgStyle||s.svgClassName||s.shortDesc)&&(n>a&&i.push(new T(this,e,t.slice(a,n))),i.push(new T(this,e,[t[n]])),a=n+1),n+=1}return n>a&&i.push(new T(this,e,t.slice(a,n))),i},C.prototype.getReferenceLinesContainer=function(){return this._refLinesContainer},C.prototype.setReferenceLinesContainer=function(t){this._refLinesContainer=t},C.prototype.getReferenceAreasContainer=function(){return this._refAreasContainer},C.prototype.setReferenceAreasContainer=function(t){this._refAreasContainer=t},C.prototype.getTimeCursorContainer=function(){return this._timeCursorContainer},C.prototype.setTimeCursorContainer=function(t){this._timeCursorContainer=t},C.prototype.getTimeCursor=function(){return this._timeCursor},C.prototype.setTimeCursor=function(t){this._timeCursor=t},C.prototype.getMarqueeArtifactsContainer=function(){return this._marqueeArtifactsContainer},C.prototype.setMarqueeArtifactsContainer=function(t){this._marqueeArtifactsContainer=t},C.prototype.getDnDArtifactsContainer=function(){return this._dndArtifactsContainer},C.prototype.setDnDArtifactsContainer=function(t){this._dndArtifactsContainer=t},C.prototype.getRowReferenceObjectsContainer=function(){return this._rowReferenceObjectsContainer},C.prototype.setRowReferenceObjectsContainer=function(t){this._rowReferenceObjectsContainer=t},C.prototype.setEmptyText=function(t){this._emptyText=t},C.prototype.removeEmptyText=function(){this._emptyText&&this._emptyText.getParent()&&(this._emptyText.getParent().removeChild(this._emptyText),delete this._emptyText,this._emptyText=null)},C.prototype.getRowsData=function(){return this._rowsData},C.prototype.getRowLayoutObjs=function(){return this._dataLayoutManager.getRowObjs()},C.prototype.getDependencyLayoutObjs=function(){return this._dataLayoutManager.getDependencyObjs()},C.prototype.setRows=function(t){this._rows=t},C.prototype.getCurrentRow=function(){return this._currentRow},C.prototype.setCurrentRow=function(t){this._currentRow=t},C.prototype.getAxisPosition=function(){return this._axisPosition},C.prototype.getAxisHeight=function(t,e){return n.getTimeAxisHeight(t,e)},C.prototype.getStartTime=function(){return this._start},C.prototype.getEndTime=function(){return this._end},C.prototype.getHoverBehavior=function(){return"none"},C.prototype.isHorizontalGridlinesVisible=function(){return"visible"===this._horizontalGridline},C.prototype.isVerticalGridlinesVisible=function(){return"visible"===this._verticalGridline},C.prototype.getContentHeight=function(){return this._dataLayoutManager.getContentHeight()},C.prototype.getAxesHeight=function(){var t=0;return this._majorAxis&&(t+=this._majorAxis.getSize()),this._minorAxis&&(t+=this._minorAxis.getSize()),t},C.prototype.isRowAxisEnabled=function(){var t="on"===this._rowAxisRendered,e=this.getRowLayoutObjs().length>0;return t&&e},C.prototype.getRowAxisWidth=function(){return this._rowAxisWidth},C.prototype.getRowAxisMaxWidth=function(){return this._rowAxisMaxWidth},C.prototype.getRowAxis=function(){return this._rowAxis},C.prototype.setRowAxis=function(t){this._rowAxis=t},C.prototype.getViewportDimensions=function(){return new e.Rectangle(this.getStartXOffset()-this.getTimeZoomCanvas().getTranslateX(),this._databodyStart-this._databody.getTranslateY(),this._canvasLength,this._canvasSize-this.getAxesHeight())},C.prototype.scrollIntoView=function(t,i,a,n){var s=e.Agent.isRightToLeft(this.getCtx()),r=this.getViewportDimensions(),o=0,h=0;i=i||"auto",a=a||"auto",n=n||0;var l=Math.min(t.x-r.x-n,0),d=Math.max(0,t.x+t.w-(r.x+r.w)+n),g=s?d:l,c=s?l:d;switch(i){case"start":o=g;break;case"end":o=c;break;default:o=(s?c<0:c>0)?c:g}var _=Math.min(t.y-r.y-n,0),p=Math.max(0,t.y+t.h-(r.y+r.h)+n);switch(a){case"top":h=_;break;case"bottom":h=p;break;default:h=_<0?_:p}this.panBy(o,h,!0)},C.prototype.autoPanOnEdgeDrag=function(t,e,i,a){var n=this.getViewportDimensions(),s=0,r=0;if(!i){var o=Math.max(t.x-n.x,0),h=Math.max(n.x+n.w-t.x,0);o<e?(s=o-e,s=Math.max(s,-n.x)):h<e&&(s=e-h,s=Math.min(s,this.getContentLength()-(n.x+n.w)))}if(!a){var l=Math.max(t.y-n.y,0),d=Math.max(n.y+n.h-t.y,0);l<e?(r=l-e,r=Math.max(r,-n.y)):d<e&&(r=e-d,r=this.getContentHeight()+this._databodyStart>=this._canvasSize?"bottom"===this.getAxisPosition()?Math.min(r,this._databody.getTranslateY()+this.getContentHeight()-n.h):Math.min(r,this._databody.getTranslateY()+this.getContentHeight()-this._canvasSize):Math.min(r,-n.y))}return this.panBy(s,r,!0),{deltaX:s,deltaY:r}},C.prototype.panBy=function(t,e,i){if(0!==t||0!==e){i=void 0!==i?i:"alta"!==this.getCtx().getThemeBehavior();var a=0!==t&&(i||Math.abs(t)>Math.abs(e)),n=this._databody&&0!==e&&(i||Math.abs(e)>Math.abs(t));if(a&&C.superclass.panBy.call(this,t,0),n){var s=this.getBoundedContentTranslateY(this._databody.getTranslateY()-e);this.isContentDirScrollbarOn()&&this.contentDirScrollbar.setViewportRange(s-this.getDatabodyHeight(),s),this.setDataRegionTranslateY(s,!0)}this.isTimeDirScrollbarOn()&&this.timeDirScrollbar&&this.timeDirScrollbar.setViewportRange(this._viewStartTime,this._viewEndTime),this.renderViewport(m.VPC_TRANSLATE,n),a&&D._renderAxes(this,this.getTimeZoomCanvas(),!0)}},C.prototype.getBoundedContentTranslateY=function(t){var e=this.getContentHeight();if(null==e)return t;var i=this.getDatabodyHeight(),a=this.getDatabodyStart(),n=a+Math.min(0,i-e);return Math.min(a,Math.max(t,n))},C.prototype.beginDragPan=function(t,e){C.superclass.beginDragPan.call(this,t,e),this._currentViewStartTime=this._viewStartTime,this._currentViewEndTime=this._viewEndTime},C.prototype.endDragPan=function(t,e){this._currentViewStartTime===this._viewStartTime&&this._currentViewEndTime===this._viewEndTime&&(this._triggerViewportChange=!1),C.superclass.endDragPan.call(this,t,e)},C.prototype.setTaskBrightness=function(t,e){null!=(t=this.findTaskNodeById(t.getId()))&&(e?t.darken():t.brighten())},C.prototype.findTaskNodeById=function(t){var i=this.getCtx(),a=this.getRows();if(a)for(var n=0;n<a.length;n++)for(var s=a[n].getTasks(),r=0;r<s.length;r++)if(e.Obj.compareValues(i,t,s[r].getId()))return s[r];return null},C.prototype.hasValidOptions=function(){var t=!this._majorAxis||this._majorAxis.hasValidOptions(),e=this._minorAxis&&this._minorAxis.hasValidOptions(),i=this._start&&this._end&&this._end>this._start,a=!this._viewStartTime||!this._viewEndTime||this._viewEndTime>this._viewStartTime,n=!this._viewStartTime||this._viewStartTime>=this._start&&this._viewStartTime<this._end,s=!this._viewEndTime||this._viewEndTime>this._start&&this._viewEndTime<=this._end;return t&&e&&i&&a&&n&&s},C.prototype.getSelectionHandler=function(){return this._selectionHandler},C.prototype.isSelectionSupported=function(){return!!this._selectionHandler},C.prototype.setSelectionMode=function(t){this._selectionHandler="single"===t?new e.SelectionHandler(this.getCtx(),e.SelectionHandler.TYPE_SINGLE):"multiple"===t?new e.SelectionHandler(this.getCtx(),e.SelectionHandler.TYPE_MULTIPLE):null,this.getEventManager().setSelectionHandler(this._selectionHandler)},C.prototype.select=function(t){this.isLastRenderValid()&&(this.Options.selection=e.JsonUtils.clone(t),this._processInitialSelections())},C.prototype._processInitialSelections=function(){var t=this.Options.selection;if(null!=t&&0!==t.length&&this.isSelectionSupported()){for(var e=new this._context.KeySetImpl(t),i=this.getRowLayoutObjs(),a=[],n=0;n<i.length;n++)for(var s=i[n].taskObjs,r=0;r<s.length;r++){var o=s[r];if(e.has(o.id)){this._dataLayoutManager.ensureInDOM(o,"task");var h=o.node;a.push(h)}}this.getSelectionHandler().processInitialSelections(t,a)}},C.prototype.getDependenciesContainer=function(){return this._dependenciesContainer},C.prototype.setDependenciesContainer=function(t){this._dependenciesContainer=t},C.prototype.setDefaultMarkerId=function(t){this._markerId=t},C.prototype.getDefaultMarkerId=function(){return this._markerId},C.prototype.getNavigableDependencyLinesForTask=function(t,e){return"successor"===e?t.getSuccessorDependencies():t.getPredecessorDependencies()},C.prototype.HandleTouchStart=function(t){},t.Gantt=C,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ojgantt-toolkit.js.map