/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["ojs/ojcore-base","ojs/ojrowexpander","ojs/ojdatasource-common"],function(t,e,s){"use strict";const r=function(e,s,r,n,o,a){t.Assert.assertArrayOrNull(a),this.m_startRow=e,this.m_endRow=s,this.m_startColumn=r,this.m_endColumn=n,this.m_nodeSet=o,this.m_columns=a};(t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t)._registerLegacyNamespaceProp("FlattenedTreeCellSet",r),r.prototype.getData=function(e){var s=this._getRelIndexes(e);if(null==s)return null;var r=s[0],n=s[1];t.Assert.assert(r<this.m_nodeSet.getStart()+this.m_nodeSet.getCount()&&n<this.m_columns.length);var o=this.m_columns[n],a=this.m_nodeSet.getData(r);if(null!=a){var u,l,c={};return u=a.get?function(){return a.get(o)}:function(){return a[o]},l=a.set?function(t){return a.set(o,t)}:function(t){a[o]=t},Object.defineProperty(c,"data",{enumerable:!0,get:u,set:l}),c}return null},r.prototype.getMetadata=function(e){var s=this._getRelIndexes(e);if(null==s)return null;var r=s[0],n=s[1];t.Assert.assert(r<this.m_nodeSet.getStart()+this.m_nodeSet.getCount()&&n<this.m_columns.length);var o=this.m_columns[n],a=this.m_nodeSet.getMetadata(r),u=a.key;return a.keys={row:u,column:o},a},r.prototype._getRelIndexes=function(e){if(t.Assert.assertObject(e),null==this.m_nodeSet||0===this.m_nodeSet.length)return null;var s=e.row-this.m_startRow+this.m_nodeSet.getStart(),r=e.column;return t.Assert.assertNumber(s,null),t.Assert.assertNumber(r,null),t.Assert.assert(s>=0&&r>=0),[s,r]},r.prototype.getStart=function(t){return"row"===t?this.m_startRow:"column"===t?this.m_startColumn:0},r.prototype.getCount=function(t){return"row"===t?Math.min(this.m_endRow-this.m_startRow,this.m_nodeSet.getCount()):"column"===t?this.m_endColumn-this.m_startColumn:0},r.prototype.getExtent=function(t){return{row:{extent:1,more:{before:!1,after:!1}},column:{extent:1,more:{before:!1,after:!1}}}};const n=function(t,e){n.superclass.constructor.call(this,t,e)};t._registerLegacyNamespaceProp("FlattenedTreeDataGridDataSource",n),t.Object.createSubclass(n,t.FlattenedTreeDataSource,"oj.FlattenedTreeDataGridDataSource"),n.prototype.Init=function(){n.superclass.Init.call(this),this.m_columns=n.superclass.getOption.call(this,"columns"),this.m_rowHeader=n.superclass.getOption.call(this,"rowHeader")},n.prototype.getCountPrecision=function(t){return"row"===t?"estimate":"actual"},n.prototype.getCount=function(t){return"row"===t?-1:"column"===t?this.m_columns.length:0},n.prototype.fetchHeaders=function(e,s,r){var n,o=e.axis;if("column"===o){var a=e.start+e.count;a>this.getCount("column")&&(a=this.getCount("column")-e.start),n=new t.FlattenedTreeHeaderSet(e.start,a,this.m_columns)}else if("row"===o&&null!=this.m_rowHeader)return void(this.m_fetchHeaderRequest={range:e,callbacks:s,callbackObjects:r});null!=s&&null!=s.success&&(null==r&&(r={}),s.success.call(r.success,n,e,null))},n.prototype.fetchCells=function(t,e,s){for(var r,o,a=0;a<t.length;a++){var u=t[a];if("row"===u.axis){r=u.start,o=u.count;break}}var l=this.m_fetchSize;this.m_fetchSize=o,n.superclass.fetchRows.call(this,{start:r,count:o},{success:function(r){this._handleFetchRowsSuccess(r,t,e,s,0)}.bind(this),error:function(t){this._handleFetchRowsError(t,{start:r,count:o},e,s)}.bind(this)}),this.m_fetchSize=l},n.prototype.keys=function(t){var e=t.row,s=t.column;return new Promise(function(t){e>n.superclass.getFetchedRange.call(this).end||s>this.m_columns.length?t(null):t({row:n.superclass.getKey.call(this,e),column:this.m_columns[s]})}.bind(this))},n.prototype.indexes=function(t){var e=t.row,s=t.column;return new Promise(function(t){for(var r,o=n.superclass.getIndex.call(this,e),a=0;a<this.m_columns.length;a++)if(this.m_columns[a]===s){r=a;break}t(o>=0||r>=0?{row:o,column:r}:null)}.bind(this))},n.prototype.sort=function(t,e,s){return n.superclass.getWrappedDataSource.call(this).sort(t,{success:function(){this._handleSortSuccess(e,s)}.bind(this),error:e.error})},n.prototype._handleSortSuccess=function(t,e){this.refresh(),t.success&&(null==e&&(e={}),t.success.call(e.success))},n.prototype.move=function(t,e,s,r){n.superclass.getWrappedDataSource.call(this).move(t,e,s,r)},n.prototype.getCapability=function(t){return"default"===n.superclass.getWrappedDataSource.call(this).getCapability(t)?"column":"none"},n.prototype.insertMetadata=function(t,e){n.superclass.insertMetadata.call(this,t,e)},n.prototype._handleFetchRowsSuccess=function(e,s,r,n){for(var o,a,u,l,c=0;c<s.length;c++){var i=s[c];"row"===i.axis?(o=i.start,a=i.count):"column"===i.axis&&(u=i.start)+(l=i.count)>this.getCount("column")&&(l=this.getCount("column")-u)}if(this.m_fetchHeaderRequest){var h=this.m_fetchHeaderRequest.range;h.start===o&&h.count===a&&(this._handleRowHeaderFetchSuccess(e,h,this.m_fetchHeaderRequest.callbacks,this.m_fetchHeaderRequest.callbackObjects),this.m_fetchHeaderRequest=null)}var m=new t.FlattenedTreeCellSet(o,o+a,u,u+l,e,this.m_columns);r.success&&(null==n&&(n={}),r.success.call(n.success,m,s))},n.prototype._handleFetchRowsError=function(t,e,s,r){if(this.m_fetchHeaderRequest){var n=this.m_fetchHeaderRequest.range;if(n.start===e.start&&n.count===e.count){var o=this.m_fetchHeaderRequest.callbacks,a=this.m_fetchHeaderRequest.callbackObjects;o.error&&(null==a&&(a={}),o.error.call(a.error,t))}this.m_fetchHeaderRequest=null}s.error&&(null==r&&(r={}),s.success.call(r.error,t))},n.prototype._handleRowHeaderFetchSuccess=function(e,s,r,n){var o=new t.FlattenedTreeHeaderSet(s.start,s.start+s.count,this.m_columns,e,this.m_rowHeader);r.success&&(null==n&&(n={}),r.success.call(n.success,o,s,null))},n.prototype.insertRows=function(e,s,r){var o=null;this.m_rowHeader&&(o=new t.FlattenedTreeHeaderSet(e,e+r.getCount(),this.m_columns,r,this.m_rowHeader));for(var a=new t.FlattenedTreeCellSet(e,e+r.getCount(),0,this.m_columns.length,r,this.m_columns),u=[],l=[],c=0;c<r.getCount();c++)u.push({row:this._getEntry(e+c).key}),l.push({row:e+c,column:-1});var i={};i.source=this,i.operation="insert",i.result=a,o&&(i.header=o),i.keys=u,i.indexes=l,n.superclass.handleEvent.call(this,"change",i)},n.prototype.removeRows=function(t){for(var e=[],s=[],r=0;r<t.length;r++)e.push({row:t[r].key}),s.push({row:t[r].index,column:-1});var o={};o.source=this,o.operation="delete",o.keys=e,o.indexes=s,n.superclass.handleEvent.call(this,"change",o)},n.prototype.handleMaxCountReached=function(e,s){var r=new t.EmptyNodeSet(null,e.start);s.success.call(null,r)};const o=function(e,s,r,n,o){t.Assert.assertArrayOrNull(r),this.m_start=e,this.m_end=s,this.m_headers=r,this.m_nodeSet=n,this.m_rowHeader=o};t._registerLegacyNamespaceProp("FlattenedTreeHeaderSet",o),o.prototype.getData=function(e,s){var r;return t.Assert.assert(e<=this.m_end&&e>=this.m_start,"index out of bounds"),t.Assert.assert(null==s||0===s,"level out of bounds"),null!=this.m_rowHeader&&null!=this.m_nodeSet?null!=(r=this.m_nodeSet.getData(e-this.m_start+this.m_nodeSet.getStart()))?r.get?r.get(this.m_rowHeader):r[this.m_rowHeader]:null:this.m_headers[e]},o.prototype.getMetadata=function(e,s){return t.Assert.assert(e<=this.m_end&&e>=this.m_start,"index out of bounds"),t.Assert.assert(null==s||0===s,"level out of bounds"),null!=this.m_rowHeader&&null!=this.m_nodeSet?this.m_nodeSet.getMetadata(e-this.m_start+this.m_nodeSet.getStart()):{key:this.getData(e)}},o.prototype.getCount=function(){return null!=this.m_rowHeader&&null!=this.m_nodeSet?Math.min(this.m_nodeSet.getCount(),this.m_end-this.m_start):Math.max(0,this.m_end-this.m_start)},o.prototype.getLevelCount=function(){return this.getCount()>0?1:0},o.prototype.getExtent=function(e,s){return t.Assert.assert(e<=this.m_end&&e>=this.m_start,"index out of bounds"),t.Assert.assert(null==s||0===s,"level out of bounds"),{extent:1,more:{before:!1,after:!1}}},o.prototype.getDepth=function(e,s){return t.Assert.assert(e<=this.m_end&&e>=this.m_start,"index out of bounds"),t.Assert.assert(null==s||0===s,"level out of bounds"),1},o.prototype.getLabel=function(){return null};var a={};return a.FlattenedTreeDataGridDataSource=oj.FlattenedTreeDataGridDataSource,a.FlattenedTreeHeaderSet=oj.FlattenedTreeHeaderSet,a.FlattenedTreeCellSet=oj.FlattenedTreeCellSet,a});
//# sourceMappingURL=ojflattenedtreedatagriddatasource.js.map