/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","ojs/ojdvt-toolkit"],function(t,e){"use strict";class i{constructor(t,i){this._view=t,this._options=i;var s=this._view.getOptions();this._id=i.id||i.label,this._color=i.color?i.color:"#000000",this._textStr=i.label,this._labelStyle=i.labelStyle?new e.CSSStyle(i.labelStyle):null,this._pattern=i.pattern,this._selectable=i.selectable,this._shortDesc=i.shortDesc?i.shortDesc:i.tooltip,this._size=i.value;var a=i.drilling;this._drilling="on"==a||"off"==a?a:s.drilling,this._stampId=i.S,this._bArtificialRoot=i.bArtificialRoot,this._alpha=1,this._lastVisitedChild=null,this._isShowingKeyboardFocusEffect=!1,this.IsHover=!1,this._ANIMATION_DELETE_PRIORITY=0,this._ANIMATION_UPDATE_PRIORITY=1,this._ANIMATION_INSERT_PRIORITY=2,this._DEFAULT_TEXT_SIZE=11}setChildNodes(t){if(null!=t)for(var e=0;e<t.length;e++)t[e]._parent=this;this._children=t}getChildNodes(){return this._children?this._children:[]}getDescendantNodes(){var t,e,i=[];if(!this.hasChildren())return i;for(var s=0;s<this._children.length;s++)t=(e=this._children[s]).getDescendantNodes(),i.push(e),i=i.concat(t);return i}SetLastVisitedChild(t){this._lastVisitedChild=t}GetLastVisitedChild(){return this._lastVisitedChild}MarkAsLastVisitedChild(){var t=this.GetParent();t&&t.SetLastVisitedChild(this)}isDescendantOf(t){return!(!t||!this.GetParent())&&(this.GetParent()==t||this.GetParent().isDescendantOf(t))}GetNodesAtDepth(t,e){var i=[];if(e<0)return i;if(0==e)return[this];if(t.hasChildren())for(var s,a=t.getChildNodes(),r=0;r<a.length;r++)s=a[r],i=i.concat(s.GetNodesAtDepth(s,e-1));return i}static getNodeById(t,s){if(e.Obj.compareValues(t.getView().getCtx(),t.getId(),s))return t;for(var a=null,r=t.getChildNodes(),n=r.length,h=null,o=0;o<n;o++)if(h=r[o],a=i.getNodeById(h,s))return a;return null}getView(){return this._view}getStampId(){return this._stampId}getOptions(){return this._options}getCategories(){if(this.isArtificialRoot())return[];var t=this.getOptions().categories;if(!t&&!this.getView().hasDataProvider()){var e=this.GetParent(),i=e?e.getCategories():null;(t=i?i.slice():[]).push(this.getId())}return t}getId(){return this._id}getSize(){return this._size}getColor(){return this._color}getDatatip(){var t=this._view.getOptions().tooltip,s=t?t.renderer:null;return s?this.getView().getCtx().getTooltipManager().getCustomTooltip(s,this.getDataContext()):e.Displayable.resolveShortDesc(this._shortDesc,()=>i.getShortDescContext(this))}getDatatipColor(){return this._color}getShortDesc(){return this._shortDesc}static getShortDescContext(t){var i,s=t.getOptions(),a=s;return s._noTemplate?(i=s._itemData,a=s._itemData):s._itemData&&(i=s._itemData,a=s=e.JsonUtils.clone(s),delete s._itemData),{id:t.getId(),label:t.getLabel(),value:t.getSize(),data:a,itemData:i}}getDataContext(){var t,i=this.getOptions(),s=i;return i._noTemplate?(t=i._itemData,s=i._itemData):i._itemData&&(t=i._itemData,s=i=e.JsonUtils.clone(i),delete i._itemData),{id:this.getId(),label:this.getLabel(),value:this.getSize(),color:this.getColor(),data:s,itemData:t,component:this.getView().getOptions()._widgetConstructor}}getIndex(){return this.getOptions()._index}getAlpha(){return this._alpha}setAlpha(t){this._alpha=t,this._shape&&this._shape.setAlpha(this._alpha)}setDisclosed(t){this.getOptions()._expanded=t}isDisclosed(){return!1!==this.getOptions()._expanded}isArtificialRoot(){return this._bArtificialRoot}isDrillReplaceEnabled(){return"on"==this._drilling}render(t){}renderChildren(t){var e=this.getChildNodes();if(null!=e)for(var i=0;i<e.length;i++)e[i].render(t)}getNextNavigable(t){return this.MarkAsLastVisitedChild(),this}getKeyboardBoundingBox(){return new e.Rectangle(0,0,0,0)}getTargetElem(){return null}showKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!0,this.showHoverEffect(),this.handleMouseOver&&this.handleMouseOver()}hideKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect&&(this._isShowingKeyboardFocusEffect=!1,this.hideHoverEffect()),this.handleMouseOut&&this.handleMouseOut()}isShowingKeyboardFocusEffect(){return this._isShowingKeyboardFocusEffect}handleMouseOver(){this.IsHover=!0}handleMouseOut(){this.IsHover=!1}isSelectable(){return"off"!=this._selectable&&null!=this.getView().__getNodeSelection()}isSelected(){return this._selected}setSelected(t){this._selected=t,this.UpdateAriaLabel()}showHoverEffect(){}hideHoverEffect(){}highlight(t,e){this.setAlpha(e)}isDragAvailable(t){return this.getView().__isDragAvailable(t)}getDragTransferable(){return this.getView().__getDragTransferable(this)}getDragFeedback(){return this.getView().__getDragFeedback()}getDropSiteFeedback(){return null}contains(t,e){return!1}getNodeUnderPoint(t,e){return null}GetAnimParams(){return[]}SetAnimParams(t){}animateUpdate(t,i){t.isDrillAnimation()||t.constructAnimation(i.getChildNodes(),this.getChildNodes());var s,a=this.GetAnimParams(),r=i.GetAnimParams(a);if(!e.ArrayUtils.equals(r,a)){(s=new e.CustomAnimation(this.getView().getCtx(),this,this.getView().__getAnimDur())).getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this,this.GetAnimParams,this.SetAnimParams,a),t.add(s,this._ANIMATION_UPDATE_PRIORITY);var n=this._size!=i._size,h=e.ColorUtils.getRGBA(this._color)!=e.ColorUtils.getRGBA(i._color);this.SetAnimParams(r);var o=this._view.getOptions().animationUpdateColor;o&&(n||h)&&(this._color=o)}}animateInsert(t){if(!t.isDrillAnimation()||!t.isAncestorInsert(this)){this.setAlpha(0);var i=new e.AnimFadeIn(this.getView().getCtx(),this,this.getView().__getAnimDur());if(t.add(i,this._ANIMATION_INSERT_PRIORITY),this.hasChildren())for(var s=0;s<this._children.length;s++)this._children[s].animateInsert(t)}}animateDelete(t,i){i.addChild(this._shape);var s=new e.AnimFadeOut(this.getView().getCtx(),this,this.getView().__getAnimDur());if(t.add(s,this._ANIMATION_DELETE_PRIORITY),!t.isDrillAnimation()&&this.hasChildren())for(var a=0;a<this._children.length;a++)this._children[a].animateDelete(t,i)}hasChildren(){return null!=this._children&&this._children.length>0}hasDPChildren(){var t=this.getView().getOptions().data;if(t){var e=t.getChildDataProvider(this.getId());return!!e&&"yes"!==e.isEmpty()}return!1}hasPattern(){return this._pattern&&"none"!=this._pattern}GetParent(){return this._parent}GetDepth(){for(var t=0,e=this.GetParent();e;)t++,e=e.GetParent();return t}GetFill(){return this.hasPattern()?new e.PatternFill(this._pattern,this._color):new e.SolidFill(this._color)}static GetNodeTextColor(t){return t.hasPattern()?"#000000":e.ColorUtils.getContrastingTextColor(t._color)}ApplyLabelTextStyle(t){var s=i.GetNodeTextColor(this);t.setSolidFill(s),t.setCSSStyle(this.getMergedLabelTextStyle()),e.Agent.isHighContrast()&&t.setSolidFill(s)}getMergedLabelTextStyle(){var t=[];return t.push(this._view.getOptions().nodeDefaults.labelStyle),this._labelStyle&&t.push(this._labelStyle),e.CSSStyle.mergeStyles(t)}GetTextSize(){var t=this._DEFAULT_TEXT_SIZE,e=this._view.getOptions().nodeDefaults.labelStyle.getFontSize();return e&&(t=parseFloat(e)),t}getLabelBackgroundColor(){var t=this._labelStyle,e=t?t.getStyle("background-color"):null;return e||this._view.getOptions().nodeDefaults.labelStyle.getStyle("background-color")}getDisplayable(){return this._shape}getLabel(){return this._textStr}isDoubleClickable(){return this.isDrillReplaceEnabled()}UpdateAriaLabel(){}isRootNode(){return e.Obj.compareValues(this.getView().getCtx(),this.getId(),this.getView().getRootNode().getId())||this.isArtificialRoot()}}i.__NODE_SELECTED_SHADOW=new e.Shadow(Math.sqrt(2),Math.sqrt(2),5/3,"rgba(0, 0, 0, 0.5)");class s extends e.SimpleObjPeer{constructor(t,e,i,s,a){super(i,s,a),this._node=t,this._id=e,this._bDrillable=!1}getId(){return this._id}isDrillable(){return this._bDrillable}setDrillable(t){this._bDrillable=t}handleMouseOver(){this._node&&this._node.handleMouseOver&&this._node.handleMouseOver()}handleMouseOut(){this._node&&this._node.handleMouseOut&&this._node.handleMouseOut()}}const a={calcMaxDepth:(t,e)=>{var i=e,s=t.getChildNodes();if(s)for(var r=0;r<s.length;r++){var n=a.calcMaxDepth(s[r],e+1);i=Math.max(i,n)}return i},calcNodeCount:t=>{var e=1,i=t.getChildNodes();if(i)for(var s=0;s<i.length;s++)e+=a.calcNodeCount(i[s]);return e},getAllNodes:t=>{var e=[];return a._addNodesToArray(t,e),e},getAllIds:t=>a.getAllNodes(t).map(t=>t.getId()),getAllVisibleNodes:t=>{var e=[];return a._addNodesToArray(t,e,!1,!0),e},getLeafNodes:t=>{var e=[];return a._addNodesToArray(t,e,!0),e},isHiddenNode:(t,i)=>e.ArrayUtils.hasAnyMapItem(t,i.categories),_addNodesToArray:(t,e,i,s)=>{if(t){var r=t.getChildNodes(),n=r?r.length:0;i&&0!=n||s&&!t.getDisplayable()||e.push(t);for(var h=0;h<n;h++)a._addNodesToArray(r[h],e,i,s)}},findRootAndAncestors:(t,i,s,r)=>{for(var n=0;n<i.length;n++){if(e.Obj.compareValues(t,i[n].id,s))return{root:i[n],ancestors:r};if(i[n].nodes){r.unshift(i[n]);var h=a.findRootAndAncestors(t,i[n].nodes,s,r);if(null!=h)return h;r.shift()}}return null}};class r extends e.DataAnimationHandler{animate(t,e,i,s){if(this._bDrill=!1,this._oldRoot=t,this._oldAncestors=i,r._isAncestor(s,t)||r._isAncestor(i,e)){this._bDrill=!0;var a=t.getDescendantNodes(),n=e.getDescendantNodes();a.push(t),n.push(e),this.constructAnimation(a,n)}else this.constructAnimation([t],[e])}isDrillAnimation(){return this._bDrill}isAncestorInsert(t){return!!this._bDrill&&(e.Obj.compareValues(this.getCtx(),this._oldRoot.getId(),t.getId())||r._isAncestor(this._oldAncestors,t))}static _isAncestor(t,e){if(!e||!t)return!1;for(var i=0;i<t.length;i++)if(t[i].id==e.getId())return!0;return!1}}const n={VERSION_1:{labelStyle:e.BaseComponentDefaults.FONT_FAMILY_ALTA_11+"color: #003286;",disabledLabelStyle:e.BaseComponentDefaults.FONT_FAMILY_ALTA_11,__labelGap:4,__labelSeparator:">"},calcOptions:t=>{var i=n._getDefaults();return t?e.JsonUtils.merge(t,i):i},_getDefaults:()=>e.JsonUtils.clone(n.VERSION_1),getGapSize:(t,e)=>Math.ceil(e*t.layout.gapRatio)};class h extends e.SimpleObjPeer{constructor(t,e,i){super(),this._id=t,this._bDrillable=!1,this._displayable=e,this._displayableText=i,this._truncated=!1}getId(){return this._id}isDrillable(){return this._bDrillable}setDrillable(t){this._bDrillable=t}getDisplayable(){return this._displayable}getTooltip(){return this._truncated?this._displayableText:null}setTruncated(t){this._truncated=t}}class o extends e.EventManager{constructor(t,e,i,s){super(e,i,s),this._breadcrumbs=t}OnClick(t){super.OnClick(t),this._processBreadcrumbs(this.GetLogicalObject(t.target))}HandleTouchClickInternal(t){this._processBreadcrumbs(this.GetLogicalObject(t.target))}_processBreadcrumbs(t){if(t&&t instanceof h&&t.isDrillable()){var i=e.EventFactory.newBreadcrumbsDrillEvent(t.getId());this.FireEvent(i,this._breadcrumbs)}}handleKeyboardEvent(t){var i=!0,s=t.keyCode;if(s==e.KeyboardEvent.TAB){var a=this._breadcrumbs.updateCrumbFocus(t.shiftKey);-1==a?i=!1:this.UpdateActiveElement(this._breadcrumbs.getCrumb(a))}else if(s==e.KeyboardEvent.ENTER){var r=this._breadcrumbs.getCrumb(this._breadcrumbs.getCurrentCrumbIndex());this._processBreadcrumbs(this.GetLogicalObject(r))}return i&&e.EventManager.consumeEvent(t),i}}const l={_TOUCH_BUFFER:3,render:(t,i,s)=>{for(var a=t.getCtx(),r=t.__getData().items?t.__getData().items:[],n=t.__getOptions(),o=t.getEventManager(),_=[],d=[],g=0;g<r.length;g++){var u=r[g];if(u){var c=u.label?u.label:"",p=l._createLabel(a,c,n,g<r.length-1);_.push(p);var v=new h(u.id,p,c);o.associate(p,v),d.push(v),g<r.length-1&&v.setDrillable(!0)}}t.SetCrumbs(_),e.Agent.isRightToLeft(a)?l._positionLabelsBidi(t,i,s,_,d):l._positionLabels(t,i,s,_,d)},_createButtonState:(t,i,s)=>{var a=new e.OutputText(t,i,0,0);a.setMouseEnabled(!1),a.setCSSStyle(s);var r=s.getPadding(e.CSSStyle.PADDING_TOP),n=s.getPadding(e.CSSStyle.PADDING_RIGHT),h=s.getPadding(e.CSSStyle.PADDING_BOTTOM),o=s.getPadding(e.CSSStyle.PADDING_LEFT),l=e.DisplayableUtils.getDimensionsForced(t,a),_=new e.Rect(t,0,0,l.w+o+n,l.h+r+h);return _.setInvisibleFill(),_.setCSSStyle(s),a.setTranslate(o,r),_.addChild(a),_},_createLabel:(t,i,s,a)=>{var r;if(a&&(s.labelStyleOver||s.labelStyleDown)){var n=new e.CSSStyle(s.labelStyle),h=new e.CSSStyle(s.labelStyleOver),o=new e.CSSStyle(s.labelStyleDown),_=l._createButtonState(t,i,n),d=l._createButtonState(t,i,h),g=l._createButtonState(t,i,o);(r=new e.Button(t,_,d,g)).setAriaRole("link"),r.setAriaProperty("label",i)}else{var u=a?s.labelStyle:s.disabledLabelStyle,c=new e.CSSStyle(u);c.getPadding(e.CSSStyle.PADDING_LEFT)||c.getPadding(e.CSSStyle.PADDING_RIGHT)||c.getPadding(e.CSSStyle.PADDING_TOP)||c.getPadding(e.CSSStyle.PADDING_BOTTOM)?r=l._createButtonState(t,i,c):(r=new e.OutputText(t,i,0,0)).setCSSStyle(c)}return r},_getLabelTextString:t=>t instanceof e.Button?t.upState.getChildAt(0).getTextString():t instanceof e.Rect?t.getChildAt(0).getTextString():t.getTextString(),_truncateLabels:(t,i)=>{var s;return t instanceof e.Button?(s=t.upState.getChildAt(0),e.TextUtils.fitText(s,Math.max(i-s.getTranslateX(),0),1/0,s.getParent()),s=t.overState.getChildAt(0),e.TextUtils.fitText(s,Math.max(i-s.getTranslateX(),0),1/0,s.getParent()),s=t.downState.getChildAt(0),void e.TextUtils.fitText(s,Math.max(i-s.getTranslateX(),0),1/0,s.getParent())):t instanceof e.Rect?(s=t.getChildAt(0),void e.TextUtils.fitText(s,Math.max(i-s.getTranslateX(),0),1/0,s.getParent())):void e.TextUtils.fitText(t,i,1/0,t.getParent())},_positionLabels:(t,i,s,a,r)=>{for(var n=t.__getOptions(),h=t.getEventManager(),o=[],_=0,d=0;d<a.length;d++){i.addChild(a[d]);var g=a[d].getDimensions();o[d]=g,_=Math.max(g.h,_),i.removeChild(a[d])}for(var u=0,c=0;c<a.length;c++){i.addChild(a[c]);var p=o[c];if(a[c].setTranslate(u,.5*(_-p.h)),e.Agent.isTouchDevice()){var v=new e.Rect(i.getCtx(),-l._TOUCH_BUFFER,-l._TOUCH_BUFFER,p.w+2*l._TOUCH_BUFFER,p.h+2*l._TOUCH_BUFFER);v.setInvisibleFill(),a[c].addChild(v),c<r.length&&h.associate(v,r[c])}if(u+p.w>s){var E=l._getLabelTextString(a[c]);return l._truncateLabels(a[c],s-u),void(c<r.length?r[c].setTruncated(!0):h.associate(a[c],new e.SimpleObjPeer(E)))}if(u+=p.w+n.__labelGap,c<a.length-1){var S=l._newSeparator(t);i.addChild(S);var C=S.getDimensions();S.setTranslate(u,.5*(_-C.h));var b=C.w;if(u+b>s)return void i.removeChild(S);u+=b+n.__labelGap}}},_positionLabelsBidi:(t,i,s,a,r)=>{for(var n=t.__getOptions(),h=t.getEventManager(),o=s,_=0;_<a.length;_++){i.addChild(a[_]);var d=a[_].getDimensions();if(e.Agent.isTouchDevice()){var g=new e.Rect(i.getCtx(),-l._TOUCH_BUFFER,-l._TOUCH_BUFFER,d.w+2*l._TOUCH_BUFFER,d.h+2*l._TOUCH_BUFFER);g.setInvisibleFill(),a[_].addChild(g),_<r.length&&h.associate(g,r[_])}if(o-d.w<0){var u=l._getLabelTextString(a[_]);return l._truncateLabels(a[_],o),a[_].setTranslateX(0),void(_<r.length?r[_].setTruncated(!0):h.associate(a[_],new e.SimpleObjPeer(u)))}if(a[_].setTranslateX(o-d.w),o-=d.w+n.__labelGap,_<a.length-1){var c=l._newSeparator(t);i.addChild(c);var p=c.getDimensions().w;if(o-p<0)return void i.removeChild(c);c.setTranslateX(o-p),o-=p+n.__labelGap}}},_newSeparator:t=>{var i=t.__getOptions(),s=new e.OutputText(t.getCtx(),i.__labelSeparator,0,0);return s.setCSSStyle(new e.CSSStyle(i.labelStyle)),s}};class _ extends e.Container{constructor(t,e,i,s){super(t),this.setOptions(s),this._eventHandler=new o(this,t,e,i),this._eventHandler.addListeners(this),this.setId("breadcrumbs1000"+Math.floor(1e9*Math.random())),this._curCrumbIdx=-1,this._keyboardFocusRect=null,this._crumbs=null}setOptions(t){this._options=n.calcOptions(t)}render(t,i){this._data=t?e.JsonUtils.clone(t):this._data,this.removeChildren(),this.SetCrumbs(null),l.render(this,this,i)}__getData(){return this._data?this._data:{}}__getOptions(){return this._options}getEventManager(){return this._eventHandler}hideKeyboardFocusEffect(){this._curCrumbIdx=-1,this._updateKeyboardFocusEffect(this._curCrumbIdx)}getCurrentCrumbIndex(){return this._curCrumbIdx}getNumCrumbs(){return this._data.items.length}updateCrumbFocus(t){var e=this._curCrumbIdx;return this._curCrumbIdx=this._getUpdatedCrumbIndex(e,!t),this._updateKeyboardFocusEffect(this._curCrumbIdx),this._curCrumbIdx}_getUpdatedCrumbIndex(t,e){return-1==t?e?0:this._data.items.length-2:e?t==this._data.items.length-2?-1:++t:0==t?-1:--t}_updateKeyboardFocusEffect(t){var i=this._keyboardFocusRect,s=null,a=this.getCrumb(t);if(a){var r=this._eventHandler.GetLogicalObject(a);if(r&&r.isDrillable&&r.isDrillable()){var n=this.getCtx(),h=a.getDimensions(),o=a.getMatrix();s=new e.KeyboardFocusEffect(n,this,h,o),this._keyboardFocusRect=s}else this._keyboardFocusRect=null}i&&i.hide(),s&&s.show()}getCrumb(t){var e=this.GetCrumbs();return t<0||!e||t>=e.length?null:e[t]}getCrumbIndex(t){for(var e=this.GetCrumbs(),i=0;i<e.length;i++)if(e[i]==t)return i;return-1}SetCrumbs(t){this._crumbs=t}GetCrumbs(){return this._crumbs}}class d extends e.IconButton{OnMouseOver(t){super.OnMouseOver(t),this._callbackObj.showHoverEffect()}OnMouseOut(t){super.OnMouseOver(t),this._callbackObj.hideHoverEffect()}}class g extends i{constructor(t,e){super(t,e);var i=this._view.getOptions().nodeDefaults;this._labelDisplay=e.labelDisplay?e.labelDisplay:i.labelDisplay,this._evaluateExpanded(t,e),this._labelHalign=e.labelHalign?e.labelHalign:i.labelHalign,this._radius=e.radius,this._className=e.className||e.svgClassName,this._style=e.style||e.svgStyle,this._showDisclosure="on"===e.showDisclosure||"off"!==e.showDisclosure&&"on"===i.showDisclosure,this.TEXT_BUFFER_HORIZ=6,this._EXPAND_ICON_SIZE=16,this._MIN_ARC_LENGTH=1.5,this._MIN_ANGLE_EXTENT=6e-4,this.LARGE_DATASET_THRESHOLD=1e3,this._CENTER_ARTIFICIAL_ROOT_RADIUS=.25,this._CENTER_NODE_RADIUS=.5}render(t){if(this._hasLayout){if(this._nodeContainer=t,this._shape=this._createShapeNode(),t.addChild(this._shape),!(this.isRootNode()&&this._createRootNodeContent()||(this._text=this._createTextNode(this._shape),null==this._text))){this._shape.addChild(this._text);var i=this.getLabelBackgroundColor();if(this.hasPattern()||i){var s=this._text.getDimensions();this._textBackground=new e.Rect(this.getView().getCtx(),s.x,s.y,s.w,s.h),i?this._textBackground.setSolidFill(i):this._textBackground.setSolidFill("#FFFFFF"),this._textBackground.setMouseEnabled(!1),this._shape.addChild(this._textBackground);var a=this._text.getMatrix();a.isIdentity()||this._textBackground.setMatrix(a),this._shape.addChild(this._text)}}this._shape.setAriaRole("img"),this._shape.setStyle(this._style),this._shape.setClassName(this._className),this.UpdateAriaLabel(),this.renderChildren(t)}}renderChildren(t){var e=this.getChildNodes(),i=this.getView().__getNodeCount()>=this.LARGE_DATASET_THRESHOLD;if(null!=e)for(var s=0,a=0;a<e.length;a++){var r=!0,n=e[a]._angleExtent;if(n>=this._MIN_ANGLE_EXTENT){if(i){var h=e[a]._getOuterRadius(),o=n*h,l=(e[a]._startAngle+n)*h;o<this._MIN_ARC_LENGTH&&Math.abs(s-l)<this._MIN_ARC_LENGTH?r=!1:s=l}r&&e[a].render(t)}}}setSelected(t){super.setSelected(t),null!=this._shape&&(this.isSelected()?(this._shape.setSelected(!0),this.getView().__moveToSelectedLayer(this._shape)):(this._shape.setSelected(!1),e.Agent.isTouchDevice()&&this._expandButton?this.getView().__moveToSelectedLayer(this._shape):this._nodeContainer&&this._nodeContainer.addChild(this._shape)))}showHoverEffect(){this._shape&&this._hasLayout&&(this._shape.showHoverEffect(),this.isSelected()?this.getView().__moveToSelectedLayer(this._shape):this.getView().__moveToHoverLayer(this._shape))}hideHoverEffect(){this._shape&&this._hasLayout&&!this.isShowingKeyboardFocusEffect()&&(this._shape.hideHoverEffect(),!this.isSelected()&&this._nodeContainer&&this._nodeContainer.addChild(this._shape))}isExpandCollapseEnabled(){return this._showDisclosure}getNextNavigable(t){var i,s,a,r,n;if(t.type===e.MouseEvent.CLICK)return super.getNextNavigable(t);if((i=t.keyCode)===e.KeyboardEvent.SPACE&&t.ctrlKey)return this;for(n=this;n.GetParent();)n=n.GetParent();a=this.GetNodesAtDepth(n,this.GetDepth()),r=g._findNodeIndex(this,a);var h,o,l=this._startAngle+this._angleExtent/2;switch(l=g._normalizedRadToDeg(l),i){case e.KeyboardEvent.UP_ARROW:if(this===n||l>180){if((h=this.GetLastVisitedChild())&&(o=h._startAngle+h._angleExtent/2,(o=g._normalizedRadToDeg(o))>180))return h;s=e.KeyboardHandler.getNextAdjacentNavigable(this,t,this.getDescendantNodes())}else s=this._navigateToParent();break;case e.KeyboardEvent.DOWN_ARROW:if(this===n||l>=0&&l<=180){if((h=this.GetLastVisitedChild())&&(o=h._startAngle+h._angleExtent/2,(o=g._normalizedRadToDeg(o))>=0&&o<=180))return h;s=e.KeyboardHandler.getNextAdjacentNavigable(this,t,this.getDescendantNodes())}else s=this._navigateToParent();break;case e.KeyboardEvent.LEFT_ARROW:s=1===a.length?this:0===r?a[a.length-1]:a[r-1];break;case e.KeyboardEvent.RIGHT_ARROW:s=1===a.length?this:r===a.length-1?a[0]:a[r+1];break;default:s=this}return s.MarkAsLastVisitedChild(),s}_navigateToParent(){var t,e=this.GetParent();return e?(t=e,e.MarkAsLastVisitedChild()):t=this,t.MarkAsLastVisitedChild(),t}static _normalizedRadToDeg(t){var i=e.Math.radsToDegrees(t);return i<0?i+=360:i>360&&(i-=360),i}getKeyboardBoundingBox(){if(this._shape){var t=this._shape.getDimensions(),i=new e.Point(t.x,t.y);return i=this._shape.localToStage(i),t.x=i.x,t.y=i.y,t}return new e.Rectangle(0,0,0,0)}getTargetElem(){return this._shape?this._shape.getElem():null}setLayoutParams(t,e,i,s){this._innerRadius=t,this._outerRadius=e,this._startAngle=i,this._angleExtent=s,this._hasLayout=!0}GetFill(){return this.isArtificialRoot()?e.SolidFill.invisibleFill():super.GetFill()}GetAnimParams(t){var i=e.ColorUtils.getRed(this._color),s=e.ColorUtils.getGreen(this._color),a=e.ColorUtils.getBlue(this._color),r=this._startAngle;if(t&&!isNaN(t[2])){var n=t[2];n-this._startAngle>Math.PI?r+=g.TWO_PI:this._startAngle-n>Math.PI&&(r-=g.TWO_PI)}return[this._innerRadius,this._outerRadius,r,this._angleExtent,i,s,a]}SetAnimParams(t){this.setLayoutParams(t[0],t[1],t[2],t[3]);var i=Math.round(t[4]),s=Math.round(t[5]),a=Math.round(t[6]);this._color=e.ColorUtils.makeRGB(i,s,a),this.updateShapes(!1)}animateUpdate(t,e){!this.isRootNode()||e._getOuterRadius()===this._getOuterRadius()&&e.getId()===this.getId()||this._removeRootNodeContentOverlay();var i=e._hasLayout&&e._angleExtent>0,s=this._hasLayout&&this._angleExtent>0;i&&s?super.animateUpdate(t,e):s?this.animateInsert(t):i&&this.animateDelete(t,t.getDeleteContainer())}animateInsert(t,e){this.isRootNode()&&this._removeRootNodeContentOverlay(),super.animateInsert(t,e)}animateDelete(t,e){this.isRootNode()&&this._removeRootNodeContentOverlay(),super.animateDelete(t,e)}getNodeUnderPoint(t,e){if(this.contains(t,e))return this;for(var i=this.getChildNodes(),s=0;s<i.length;s++){var a=i[s].getNodeUnderPoint(t,e);if(a)return a}return null}contains(t,e){var i=g._calcRadius(t,e),s=g._calcAngle(t,e);return this.ContainsRadius(i)&&this.ContainsAngle(s)}ContainsAngle(t){for(;t<this._startAngle;)t+=g.TWO_PI;for(;t-this._startAngle>g.TWO_PI;)t-=g.TWO_PI;return t>=this._startAngle&&t<=this._startAngle+this._angleExtent}ContainsRadius(t){return t>=this._innerRadius&&t<=this._outerRadius}static _calcPointOnArc(t,e){return{x:Math.cos(e)*t,y:Math.sin(e)*t}}static _calcAngle(t,e){var i=Math.atan2(e,t);return i<0?i+=g.TWO_PI:i>g.TWO_PI&&(i-=g.TWO_PI),i}static _calcRadius(t,e){return Math.sqrt(t*t+e*e)}_createShapeNode(){if(!this._angleExtent||this._angleExtent<=0)return null;var t=this._createPathCmd(),i=new e.Path(this.getView().getCtx(),t);this.getView().getEventManager().associate(i,this),i.setAlpha(this.getAlpha()),i.setFill(this.GetFill());var s=this._view.getOptions().nodeDefaults,a=this.getOptions(),r=a.borderColor||s.borderColor,n=null==a.borderWidth?s.borderWidth:a.borderWidth;if(i.setStroke(new e.Stroke(r,1,n)),"redwood"!==i.getCtx().getThemeBehavior())i.setHoverStroke(new e.Stroke(s.hoverColor,1,3)),i.setSelectedStroke(new e.Stroke(s.selectedInnerColor,1,1.5),new e.Stroke(s.selectedOuterColor,1,3.5)),i.setSelectedHoverStroke(new e.Stroke(s.hoverColor,1,3));else{var h=this.getColor();i.setHoverStroke(new e.Stroke(s.selectedInnerColor,1,1),new e.Stroke(h,1,3.5)),i.setSelectedStroke(new e.Stroke(s.selectedInnerColor,1,1),new e.Stroke(s.selectedOuterColor,1,3.5)),i.setSelectedHoverStroke(new e.Stroke(s.selectedInnerColor,1,1),new e.Stroke(s.selectedOuterColor,1,3.5))}return i.setSelectable(this.isSelectable()),this.isDrillReplaceEnabled()&&i.setCursor("pointer"),this.isArtificialRoot()&&(i.setAlpha(.001),i.setMouseEnabled(!1)),i}_createPathCmd(){var t,i,s,a,r;return this._angleExtent<g.TWO_PI?(i=g._calcPointOnArc(this._outerRadius,this._startAngle),s=g._calcPointOnArc(this._outerRadius,this._startAngle+this._angleExtent),a=g._calcPointOnArc(this._innerRadius,this._startAngle+this._angleExtent),r=g._calcPointOnArc(this._innerRadius,this._startAngle),t=e.PathUtils.moveTo(i.x,i.y)+e.PathUtils.arcTo(this._outerRadius,this._outerRadius,this._angleExtent,1,s.x,s.y)+e.PathUtils.lineTo(a.x,a.y)+e.PathUtils.arcTo(this._innerRadius,this._innerRadius,this._angleExtent,0,r.x,r.y)+e.PathUtils.closePath()):(i=g._calcPointOnArc(this._outerRadius,this._startAngle),s=g._calcPointOnArc(this._outerRadius,this._startAngle+this._angleExtent/2),a=g._calcPointOnArc(this._innerRadius,this._startAngle),r=g._calcPointOnArc(this._innerRadius,this._startAngle+this._angleExtent/2),t=e.PathUtils.moveTo(i.x,i.y)+e.PathUtils.arcTo(this._outerRadius,this._outerRadius,this._angleExtent/2,1,s.x,s.y)+e.PathUtils.arcTo(this._outerRadius,this._outerRadius,this._angleExtent/2,1,i.x,i.y),this._innerRadius>0&&(t+=e.PathUtils.moveTo(r.x,r.y)+e.PathUtils.arcTo(this._innerRadius,this._innerRadius,this._angleExtent/2,0,a.x,a.y)+e.PathUtils.arcTo(this._innerRadius,this._innerRadius,this._angleExtent/2,0,r.x,r.y)),t+=e.PathUtils.closePath()),t}_createExpandCollapseButton(t){var e=this.isDisclosed();if(!t||!this.isExpandCollapseEnabled()||!this.hasChildren()&&e||this.getView().hasDataProvider()&&!this.hasDPChildren())return null;var i=e?this._getCollapseButton():this._getExpandButton();this._positionButton(i),t.addChild(i);var a=this.getView().getOptions().translations[this.isDisclosed()?"tooltipCollapse":"tooltipExpand"];return this.getView().getEventManager().associate(i,new s(this,this.getId(),a)),i}_positionButton(t){var e=g._calcPointOnArc(this._outerRadius,this._startAngle+this._angleExtent/2);t.setTranslate(e.x-this._EXPAND_ICON_SIZE/2,e.y-this._EXPAND_ICON_SIZE/2)}_createTextNode(t){if(!this._textStr||!t||!this._labelDisplay||"off"===this._labelDisplay)return null;if(this===this.getView().getRootNode()&&this._angleExtent<g.TWO_PI)return null;var i=!1;return"auto"===this._labelDisplay?i="ie"===e.Agent.browser||"edge"===e.Agent.browser||"windows"!==e.Agent.os||e.Agent.isEnvironmentTest():"rotated"===this._labelDisplay&&(i=!0),i&&this._angleExtent<this.getView().__getAngleExtent()?this._createTextRotated(t):this._createTextHoriz(t)}_createTextHoriz(t){var i;if(0===this._innerRadius)i={x:0,y:0};else{i=g._calcPointOnArc((this._innerRadius+this._outerRadius)/2,this._startAngle+this._angleExtent/2);var s=3*this.GetTextSize()/2,a=g._calcAngle(i.x-s/2,i.y),r=g._calcAngle(i.x+s/2,i.y);this.ContainsAngle(a)&&this.ContainsAngle(r)||(i=null)}if(!i)return null;var n=new e.OutputText(this.getView().getCtx(),this._textStr,i.x,i.y,null);n.setFontSize(this.GetTextSize()),this.ApplyLabelTextStyle(n),n.alignCenter(),n.alignMiddle(),n.setMouseEnabled(!1);for(var h=n.getDimensions(),o=i.x,l=i.x,_=i.y-h.h/2,d=i.y+h.h/2,u=!0;this.contains(o,_)&&this.contains(o,d)&&u;)o--,this._angleExtent>Math.PI&&i.x-o>=h.w&&(u=!1);for(var c=!0;this.contains(l,_)&&this.contains(l,d)&&c;)l++,this._angleExtent>Math.PI&&l-i.x>=h.w&&(c=!1);o+=3,l-=3;var p=2*Math.min(i.x-o,l-i.x);p<h.w&&(n.setX((o+l)/2),p=l-o);var v=this.getView().getOptions().nodeDefaults.labelMinLength;return e.TextUtils.fitText(n,p,h.h,t,v)?n:null}_createTextRotated(t){var i=Math.max(this._innerRadius,10),s=this._outerRadius-i-this.TEXT_BUFFER_HORIZ,a=this._angleExtent*(i+this.TEXT_BUFFER_HORIZ)*1.1;if(a<=6)return null;var r=new e.OutputText(this.getView().getCtx(),this._textStr,0,0);if(r.setFontSize(this.GetTextSize()),this.ApplyLabelTextStyle(r),!e.TextUtils.fitText(r,s,a,t))return null;var n=(i+this._outerRadius)/2;if("inner"===this._labelHalign||"outer"===this._labelHalign){t.addChild(r);var h=r.getDimensions().w,o=.75*this.TEXT_BUFFER_HORIZ;"inner"===this._labelHalign?n=i+o+h/2:"outer"===this._labelHalign&&(n=this._outerRadius-o-h/2)}var l=g._calcPointOnArc(n,this._startAngle+this._angleExtent/2);r.alignCenter(),r.alignMiddle();var _=this._startAngle+this._angleExtent/2;return(_=(_=_>=g.TWO_PI?_-g.TWO_PI:_)<0?_+g.TWO_PI:_)>.5*Math.PI&&_<1.5*Math.PI&&(_+=Math.PI),r.setRotation(_),r.setTranslate(l.x,l.y),r.setMouseEnabled(!1),r}static _findNodeIndex(t,e){for(var i=0;i<e.length;i++)if(t===e[i])return i;return-1}handleMouseOver(){this._expandButton||(this._expandButton=this._createExpandCollapseButton(this._shape)),super.handleMouseOver()}handleMouseOut(){this._expandButton&&this._shape&&(this._shape.removeChild(this._expandButton),this._expandButton=null),super.handleMouseOut()}updateShapes(t){if(this._shape){var i=this._createPathCmd();if(this._shape.setCmds(i),!this._showRootContent()){this._text&&this._shape.removeChild(this._text),this._text=this._createTextNode(this._shape);var s=this.getLabelBackgroundColor();if(this._text&&(this.hasPattern()||s)){var a=this._text.getDimensions();this._textBackground?this._textBackground.setRect(a.x,a.y,a.w,a.h):(this._textBackground=new e.Rect(this.getView().getCtx(),a.x,a.y,a.w,a.h),s?this._textBackground.setSolidFill(s):this._textBackground.setSolidFill("#FFFFFF"),this._textBackground.setMouseEnabled(!1),this._shape.addChild(this._textBackground));var r=this._text.getMatrix();r.isIdentity()||this._textBackground.setMatrix(r)}else this._textBackground&&(this._shape.removeChild(this._textBackground),this._textBackground=null)}if(e.Agent.isTouchDevice()&&this._expandButton&&this._positionButton(this._expandButton),this._shape.setFill(this.GetFill()),t)for(var n=this.getChildNodes(),h=0;h<n.length;h++)n[h].updateShapes(!0)}}getDropSiteFeedback(){return this._shape instanceof e.Circle?new e.Circle(this.getView().getCtx(),this._shape.getCx(),this._shape.getCy(),this._shape.getRadius()):this._shape instanceof e.Path?new e.Path(this.getView().getCtx(),this._shape.getCmds()):null}_getExpandButton(){return this._getButtonHelper("expand")}_getCollapseButton(){return this._getButtonHelper("collapse")}_getButtonHelper(t){var i=this.getView().getCtx(),s=this._EXPAND_ICON_SIZE/2,a=new e.Circle(i,s,s,s+2),r=this.getView().getOptions()._resources[t],n=e.ToolkitUtils.getIconStyle(i,r);return new d(i,"outlined",{style:n,size:this._EXPAND_ICON_SIZE},a,null,this.expandCollapse,this)}__isIsolated(){return this._bIsolated}expandCollapse(t){this.getView().expandCollapseNode(this.getId()),t.stopPropagation()}getExpandCollapseButton(){return this._expandButton}_showRootContent(){return!this._parent&&0===this._innerRadius&&this._angleExtent===g.TWO_PI}__getRadius(){return null!=this._radius?Number(this._radius):this.GetParent()?1:this.isArtificialRoot()?this._CENTER_ARTIFICIAL_ROOT_RADIUS:this._CENTER_NODE_RADIUS}getAriaLabel(){var t=this.getView().getOptions().translations,s=[];return this.isSelectable()&&s.push(t[this.isSelected()?"stateSelected":"stateUnselected"]),this.isExpandCollapseEnabled()&&s.push(t[this.isDisclosed()?"stateExpanded":"stateCollapsed"]),this.isDrillReplaceEnabled()&&s.push(t.stateDrillable),e.Displayable.generateAriaLabel(this.getShortDesc(),s,()=>i.getShortDescContext(this))}UpdateAriaLabel(){!e.Agent.deferAriaCreation()&&this._shape&&this._shape.setAriaProperty("label",this.getAriaLabel())}getDataContext(){var t=super.getDataContext();return t.radius=this.__getRadius(),t}_createRootNodeContent(){var t=this.getView(),i=t.getOptions(),s=i.rootNodeContent.renderer;if(this._removeRootNodeContentOverlay(),!s)return!1;var a,r=t.getCtx(),n=t.getCenterPoint(),h=this._outerRadius,o=h*Math.sqrt(2),l=this.getOptions(),_=l;l._noTemplate?(a=l._itemData,_=l._itemData):l._itemData&&(a=l._itemData,_=l=e.JsonUtils.clone(l),delete l._itemData);var d={outerBounds:{x:n.x-h,y:n.y-h,width:2*h,height:2*h},innerBounds:{x:n.x-o/2,y:n.y-o/2,width:o,height:o},id:this._id,data:_,itemData:a,component:i._widgetConstructor};d=r.fixRendererContext(d);var g=r.getContainer(),u=s(d);if(!u)return!1;var c=r.createOverlayDiv();Array.isArray(u)?u.forEach(t=>{c.appendChild(t)}):c.appendChild(u),t.rootNodeContent=c,g.appendChild(c);var p=r.getOverlayAttachedCallback();return p&&p(c),!0}_getOuterRadius(){return this._outerRadius}_removeRootNodeContentOverlay(){var t=this.getView(),e=t.rootNodeContent;e&&t.getCtx().getContainer().removeChild(e),t.rootNodeContent=null}_evaluateExpanded(t,i){var s=t.getOptions(),a=s.expanded;i.bArtificialRoot||i._expanded||(a.has?a.has(i.id)||this.setDisclosed(!1):a instanceof Array&&!e.ArrayUtils.hasAnyMapItem(s._expandedNodes,[i.id])&&this.setDisclosed(!1))}}g.TWO_PI=2*Math.PI;class u extends i{constructor(t,i){super(t,i);var s=this._view.getOptions(),a=s.nodeDefaults,r=a.header,n=i.header?i.header:{};this._groupLabelDisplay=i.groupLabelDisplay?i.groupLabelDisplay:a.groupLabelDisplay,this._labelDisplay=i.labelDisplay?i.labelDisplay:a.labelDisplay,this._labelHalign=i.labelHalign?i.labelHalign:a.labelHalign,this._labelValign=i.labelValign?i.labelValign:a.labelValign,this._headerHalign=n.labelHalign?n.labelHalign:r.labelHalign,this._headerLabelStyle=n.labelStyle?new e.CSSStyle(n.labelStyle):null,this._bHeaderUseNodeColor="on"===(n.useNodeColor?n.useNodeColor:r.useNodeColor),this._className=i.className||i.svgClassName,this._style=i.style||i.svgStyle,this._isolate=n.isolate?n.isolate:r.isolate,"auto"===this._isolate&&(this._isolate=e.Agent.isTouchDevice()?"off":"on"),this._bIsolated=null!=s.isolatedNode&&e.Obj.compareValues(this.getView().getCtx(),s.isolatedNode,this.getId()),this.TEXT_STYLE_HEADER="header",this.TEXT_STYLE_NODE="node",this.TEXT_STYLE_OFF="off",this.TEXT_BUFFER_HORIZ=5,this.TEXT_BUFFER_VERT=2,this.MIN_TEXT_BUFFER=2,this._LINE_FUDGE_FACTOR=1,this._ANIMATION_ISOLATE_DURATION=.3,this._MIN_TITLE_BAR_HEIGHT=22,this._MIN_TITLE_BAR_HEIGHT_ISOLATE=22,this.DEFAULT_HEADER_BORDER_WIDTH=1,this.DEFAULT_HEADER_WITH_NODE_COLOR_ALPHA=.5,this._ISOLATE_ICON_SIZE=12,this._ISOLATE_GAP_SIZE=4,this._ISOLATE_TOUCH_BUFFER=3,this.DEFAULT_NODE_TOP_BORDER_COLOR="#FFFFFF",this.DEFAULT_NODE_BOTTOM_BORDER_COLOR="#000000",this.DEFAULT_NODE_BORDER_WIDTH=1,this.DEFAULT_NODE_BORDER_OPACITY=.3,this.MIN_SIZE_FOR_BORDER=2*this.DEFAULT_NODE_BORDER_WIDTH,this.GROUP_HOVER_INNER_OPACITY=.8,this.GROUP_HOVER_INNER_WIDTH=3,this.NODE_HOVER_OPACITY=1,this.NODE_SELECTION_WIDTH=2}render(t){if(this._hasLayout){if(this._shape=this._createShapeNode(),t.addChild(this._shape),this.hasChildren()&&(this._childNodeGroup=new e.Container(this.getView().getCtx()),this._shape.addChild(this._childNodeGroup),this.renderChildren(this._childNodeGroup)),!this._createCustomNodeContent()&&(this._text=this._createTextNode(this._shape),null!=this._text)){var i=this.getLabelBackgroundColor();if(this._textStyle!==this.TEXT_STYLE_HEADER&&(this.hasPattern()||i)){var s=this._text.getDimensions();this._textBackground=new e.Rect(this.getView().getCtx(),s.x,s.y,s.w,s.h),i?this._textBackground.setSolidFill(i):this._textBackground.setSolidFill("#FFFFFF"),this._textBackground.setMouseEnabled(!1),this._shape.addChild(this._textBackground),this._addChildText(this._text)}}this.hasChildren()?this._shape.setAriaRole("group"):this._shape.setAriaRole("img"),this.UpdateAriaLabel()}}setSelected(t){if(super.setSelected(t),this._shape){var s=this.getView().getOptions().nodeDefaults,a=s.header;if(this.isSelected()){var r=this._x,n=this._y+this._LINE_FUDGE_FACTOR,h=Math.max(this._width-this._LINE_FUDGE_FACTOR,0),o=Math.max(this._height-this._LINE_FUDGE_FACTOR,0);"safari"!==e.Agent.browser&&"blink"!==e.Agent.engine||(n-=this._LINE_FUDGE_FACTOR),this._removeChildShape(this._selectionOuter),this._removeChildShape(this._selectionInner),this._selectionOuter=null,this._selectionInner=null,"redwood"===this._shape.getCtx().getThemeBehavior()&&this._textStyle!==this.TEXT_STYLE_HEADER?(this._selectionOuter=new e.Rect(this.getView().getCtx(),r+.5,n+.5,Math.max(h-1,0),Math.max(o-1,0)),this._selectionInner=new e.Rect(this.getView().getCtx(),r+1.5,n+1.5,Math.max(h-3,0),Math.max(o-3,0))):(this._selectionOuter=new e.Rect(this.getView().getCtx(),r,n,h,o),this._selectionInner=new e.Rect(this.getView().getCtx(),r+1,n+1,Math.max(h-2,0),Math.max(o-2,0))),this._selectionOuter.setMouseEnabled(!1),this._selectionOuter.setFill(null),this._selectionOuter.setPixelHinting(!0),this._shape.addChild(this._selectionOuter),this._selectionInner.setMouseEnabled(!1),this._selectionInner.setFill(null),this._selectionInner.setPixelHinting(!0),this._shape.addChild(this._selectionInner),this._textStyle===this.TEXT_STYLE_HEADER?(this.IsHover||this.isShowingKeyboardFocusEffect()?this._innerShape.setSolidFill(a.hoverBackgroundColor):(this._innerShape.setSolidFill(a.selectedBackgroundColor),this._text&&this.ApplyHeaderTextStyle(this._text,"_selectedLabelStyle")),this._selectionOuter.setSolidStroke(a.selectedOuterColor),this._selectionInner.setSolidStroke(a.selectedInnerColor),e.Agent.isTouchDevice()&&(this._isolateButton=this._createIsolateRestoreButton(this._shape))):(this._selectionOuter.setSolidStroke(s.selectedOuterColor),this._selectionInner.setSolidStroke(s.selectedInnerColor),"safari"!==e.Agent.browser&&"firefox"!==e.Agent.browser&&this._shape.addDrawEffect(i.__NODE_SELECTED_SHADOW),this.getView().__moveToSelectedLayer(this._shape))}else if(this._removeChildShape(this._selectionInner),this._selectionInner=null,e.Agent.isTouchDevice()&&this._removeIsolateRestoreButton(),this._textStyle===this.TEXT_STYLE_HEADER)this.IsHover||this.isShowingKeyboardFocusEffect()?this._innerShape.setSolidFill(a.hoverBackgroundColor):(this.ApplyHeaderStyle(this._shape,this._innerShape),this._text&&(this.isDrillReplaceEnabled()?this.ApplyHeaderTextStyle(this._text,"_drillableLabelStyle"):this.ApplyHeaderTextStyle(this._text,"labelStyle"))),this._selectionOuter&&(this.IsHover||this.isShowingKeyboardFocusEffect()?this._selectionOuter.setSolidStroke(a.hoverOuterColor):(this._removeChildShape(this._selectionOuter),this._selectionOuter=null));else{this._shape.removeAllDrawEffects(),this._selectionOuter&&(this._removeChildShape(this._selectionOuter),this._selectionOuter=null);var l=this.GetParent();l&&l._childNodeGroup&&l._childNodeGroup.addChild(this._shape)}}}showHoverEffect(){if(this._shape&&this._hasLayout){var t,i,s,a,r,n=this.getView().getOptions().nodeDefaults,h=n.header,o=this._view.__getLastIsolatedNode();if(null==o||o===this||this.isDescendantOf(o))this._textStyle===this.TEXT_STYLE_HEADER?(this._innerShape.setSolidFill(h.hoverBackgroundColor),this._selectionOuter||(i=this._x,s=this._y,a=this._width-this._LINE_FUDGE_FACTOR,r=this._height-this._LINE_FUDGE_FACTOR,this._selectionOuter=new e.Rect(this.getView().getCtx(),i,s,a,r),this._selectionOuter.setMouseEnabled(!1),this._selectionOuter.setFill(null),this._selectionOuter.setPixelHinting(!0),this._shape.addChild(this._selectionOuter)),this._selectionOuter.setSolidStroke(this.isSelected()?h.selectedOuterColor:h.hoverOuterColor),i=this._x+this.GROUP_HOVER_INNER_WIDTH/2,s=this._y+this._titleBarHeight+this.GROUP_HOVER_INNER_WIDTH/2,a=this._width-this.GROUP_HOVER_INNER_WIDTH-this._LINE_FUDGE_FACTOR,r=this._height-this._titleBarHeight-this.GROUP_HOVER_INNER_WIDTH-this._LINE_FUDGE_FACTOR,t=new e.Stroke(h.hoverInnerColor,this.GROUP_HOVER_INNER_OPACITY,this.GROUP_HOVER_INNER_WIDTH),this._text&&(this.isDrillReplaceEnabled()?this.ApplyHeaderTextStyle(this._text,"_drillableHoverLabelStyle"):this.ApplyHeaderTextStyle(this._text,"_hoverLabelStyle"))):("redwood"===this._shape.getCtx().getThemeBehavior()?(i=this._x+1.5,s=this._y+1.5,a=this._width-3-this._LINE_FUDGE_FACTOR,r=this._height-3-this._LINE_FUDGE_FACTOR,t=new e.Stroke(n.selectedInnerColor,1,1)):(i=this._x+this.NODE_SELECTION_WIDTH/2,s=this._y+this.NODE_SELECTION_WIDTH/2,a=this._width-this.NODE_SELECTION_WIDTH-this._LINE_FUDGE_FACTOR,r=this._height-this.NODE_SELECTION_WIDTH-this._LINE_FUDGE_FACTOR,t=new e.Stroke(n.hoverColor,this.NODE_HOVER_OPACITY,this.NODE_SELECTION_WIDTH)),r=Math.max(r,0),a=Math.max(a,0),this.getView().__showHoverEffect(i,s,a,r,t))}}hideHoverEffect(){if(this._shape&&this._hasLayout){var t=this.getView().getOptions().nodeDefaults.header;this._textStyle===this.TEXT_STYLE_HEADER&&(this.isSelected()?(this._innerShape.setSolidFill(t.selectedBackgroundColor),this._selectionOuter.setSolidStroke(t.selectedOuterColor),this._text&&(this.isDrillReplaceEnabled()?this.ApplyHeaderTextStyle(this._text,"_drillableSelectedLabelStyle"):this.ApplyHeaderTextStyle(this._text,"_selectedLabelStyle"))):(this.ApplyHeaderStyle(this._shape,this._innerShape),this._selectionOuter&&(this._shape.removeChild(this._selectionOuter),this._selectionOuter=null),this._text&&(this.isDrillReplaceEnabled()?this.ApplyHeaderTextStyle(this._text,"_drillableLabelStyle"):this.ApplyHeaderTextStyle(this._text,"labelStyle")))),this.getView().__hideHoverEffect()}}highlight(t,e){this.hasChildren()?(this._text&&this._text.setAlpha(e),this._textStyle===this.TEXT_STYLE_HEADER&&this._bHeaderUseNodeColor&&this._innerShape&&this._innerShape.setAlpha(e)):super.highlight(t,e)}isIsolateEnabled(){return"off"!==this._isolate&&this._textStyle===this.TEXT_STYLE_HEADER}getNextNavigable(t){var i,s,a;if(t.type===e.MouseEvent.CLICK)return super.getNextNavigable(t);if((i=t.keyCode)===e.KeyboardEvent.SPACE&&t.ctrlKey)return this;if(i===e.KeyboardEvent.UP_ARROW&&t.altKey||i===e.KeyboardEvent.CLOSE_BRACKET)(s=this.GetParent())&&s.getId()!==this.getView().getRootNode().getId()?(a=s,s.MarkAsLastVisitedChild()):a=this;else if(i===e.KeyboardEvent.DOWN_ARROW&&t.altKey||i===e.KeyboardEvent.OPEN_BRACKET)a=this.GetLastVisitedChild()||(this.hasChildren()?this.getView().__getDefaultNavigable(this.getChildNodes()):this);else{var r=this.getView().__getLastIsolatedNode(),n=0;if(r){if(this!==r)for(s=this.GetParent(),n=1;r!==s;)n++,s=s.GetParent()}else{for(r=this;r.GetParent();)r=r.GetParent();n=this.GetDepth()}var h=this.GetNodesAtDepth(r,n);a=e.KeyboardHandler.getNextNavigable(this,t,h)}return a.MarkAsLastVisitedChild(),a}getKeyboardBoundingBox(){return new e.Rectangle(this._x,this._y,this._width,this._height)}getTargetElem(){return this._shape?this._shape.getElem():null}setZIndex(t){this._zIndex=t}setLayoutParams(t,i,s,a){if(!(s<=0||a<=0)){if(this._hasLayout=!0,this._oldState=this.GetAnimParams(),this._x=t,this._y=i,this._width=s||0,this._height=a||0,this.hasChildren()?this._textStyle=this._groupLabelDisplay:this._textStyle=this._labelDisplay,this._textStr||(this._textStyle=this.TEXT_STYLE_OFF),this._textStyle===this.TEXT_STYLE_HEADER){this._titleBarHeight=this._MIN_TITLE_BAR_HEIGHT;var r=new e.OutputText(this.getView().getCtx(),this._textStr);r.setFontSize(this.GetTextSize()),this.ApplyHeaderTextStyle(r,"labelStyle");var n=r.getDimensions().h;this._titleBarHeight=Math.max(this._titleBarHeight,n),this.isIsolateEnabled()&&(this._titleBarHeight=Math.max(this._titleBarHeight,this._MIN_TITLE_BAR_HEIGHT_ISOLATE));var h=this._x,o=this._y+this._titleBarHeight,l=this._width,_=this._height-this._titleBarHeight;if(l>=0&&_>=0)return new e.Rectangle(h,o,l,_);this._textStyle=null}return new e.Rectangle(this._x,this._y,this._width,this._height)}}getNodeUnderPoint(t,e){if(this.contains(t,e)||!this._hasLayout){for(var i=this.getChildNodes(),s=0;s<i.length;s++)if(i[s].contains(t,e))return i[s].getNodeUnderPoint(t,e);if(this._hasLayout)return this}return null}contains(t,e){return t>=this._x&&t<=this._x+this._width&&e>=this._y&&e<=this._y+this._height}GetAnimParams(){var t=e.ColorUtils.getRed(this._color),i=e.ColorUtils.getGreen(this._color),s=e.ColorUtils.getBlue(this._color);return[this._x,this._y,this._width,this._height,t,i,s,this.hasChildren()?0:Math.random()]}SetAnimParams(t){this.setLayoutParams(t[0],t[1],t[2],t[3]);var i=Math.round(t[4]),s=Math.round(t[5]),a=Math.round(t[6]);this._color=e.ColorUtils.makeRGB(i,s,a),this._updateShapes()}getIsolateAnimation(){for(var t=[this._getIsolateAnimation()],e=this.getDescendantNodes(),i=0;i<e.length;i++)t.push(e[i]._getIsolateAnimation());return t}_getIsolateAnimation(){if(this._oldState){var t=new e.CustomAnimation(this.getView().getCtx(),this,this._ANIMATION_ISOLATE_DURATION);return t.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this,this.GetAnimParams,this.SetAnimParams,this.GetAnimParams()),this.SetAnimParams(this._oldState),t}return null}animateUpdate(t,e){this._removeAllNodeContent();var i=e._hasLayout&&e._width>0&&e._height>0,s=this._hasLayout&&this._width>0&&this._height>0;return 0===this.GetDepth()||i&&s?super.animateUpdate(t,e):s?this.animateInsert(t):i?this.animateDelete(t,t.getDeleteContainer()):null}animateInsert(t,e){this._removeAllNodeContent(),super.animateInsert(t,e)}animateDelete(t,e){this._removeAllNodeContent(),super.animateDelete(t,e)}_createShapeNode(){var t,i=this.getView().getCtx(),s="gaps"===this.getView().getOptions().nodeSeparators;if(this._textStyle===this.TEXT_STYLE_HEADER){if(s){var a=this._getGeometriesWithGaps();t=new e.Rect(i,a._shape.x,a._shape.y,a._shape.w,a._shape.h),this._innerShape=new e.Rect(i,a._innerShape.x,a._innerShape.y,a._innerShape.w,a._innerShape.h),this._backgroundShape=new e.Rect(i,a._backgroundShape.x,a._backgroundShape.y,a._backgroundShape.w,a._backgroundShape.h),this._backgroundShape.setSolidFill("#FFFFFF"),t.addChild(this._backgroundShape)}else t=new e.Rect(i,this._x,this._y,this._width,this._height),this._innerShape=new e.Rect(i,this._x+1,this._y+1,this._width-2,this._height-2);this.ApplyHeaderStyle(t,this._innerShape),this._innerShape.setMouseEnabled(!1),t.addChild(this._innerShape),this.__isIsolated()&&(this._isolateButton=this._createIsolateRestoreButton(t))}else{var r=this.GetFill();if(s){var n=this._getGeometriesWithGaps();(t=new e.Rect(i,n._shape.x,n._shape.y,n._shape.w,n._shape.h)).setFill(this.hasChildren()?e.SolidFill.invisibleFill():r)}else{if(t=new e.Rect(i,this._x,this._y,this._width,this._height),(this.getView().__getNodeCount()<1e3||!e.Agent.isTouchDevice())&&this._width>=this.MIN_SIZE_FOR_BORDER&&this._height>=this.MIN_SIZE_FOR_BORDER){var h=this.getColor(),o=e.ColorUtils.interpolateColor(this.DEFAULT_NODE_TOP_BORDER_COLOR,h,1-this.DEFAULT_NODE_BORDER_OPACITY),l=e.ColorUtils.interpolateColor(this.DEFAULT_NODE_BOTTOM_BORDER_COLOR,h,1-this.DEFAULT_NODE_BORDER_OPACITY),_=Math.min(this._width,this._height);_>=4?(t.setSolidFill(l),this._topLeftShape=new e.Rect(i,this._x,this._y,this._width-1,this._height-1),this._topLeftShape.setSolidFill(o),this._topLeftShape.setMouseEnabled(!1),t.addChild(this._topLeftShape),this._fillShape=new e.Rect(i,this._x+1,this._y+1,this._width-2,this._height-2),this._fillShape.setFill(r),this._fillShape.setMouseEnabled(!1),t.addChild(this._fillShape)):_>=2?(t.setSolidFill(l),this._fillShape=new e.Rect(i,this._x,this._y,this._width-1,this._height-1),this._fillShape.setFill(r),this._fillShape.setMouseEnabled(!1),t.addChild(this._fillShape)):t.setFill(r)}else t.setFill(r)}t.setStyle(this._style),t.setClassName(this._className)}return this.getView().getEventManager().associate(t,this),this.isSelectable()?t.setSelectable(!0):this.isDrillReplaceEnabled()?t.setCursor("pointer"):t.setCursor("default"),t.zIndex=this._zIndex,t}_createIsolateRestoreButton(t){if(this._textStyle!==this.TEXT_STYLE_HEADER||!this.isIsolateEnabled())return null;var i=null,s=this._x,a=this._x+this._width-this._LINE_FUDGE_FACTOR,r=this._y+this._LINE_FUDGE_FACTOR,n=this._y+this._titleBarHeight;if(a-s-2*this._ISOLATE_GAP_SIZE>this._ISOLATE_ICON_SIZE){var h;if(i=this.__isIsolated()?this._getRestoreButton():this._getIsolateButton(),h=e.Agent.isRightToLeft(t.getCtx())?s+this._ISOLATE_GAP_SIZE:a-this._ISOLATE_ICON_SIZE-this._ISOLATE_GAP_SIZE,i.setTranslate(h,(n+r-this._ISOLATE_ICON_SIZE)/2),t.addChild(i),e.Agent.isTouchDevice()){var o=new e.Rect(t.getCtx(),-this._ISOLATE_TOUCH_BUFFER,-this._ISOLATE_TOUCH_BUFFER,this._ISOLATE_ICON_SIZE+2*this._ISOLATE_TOUCH_BUFFER,this._ISOLATE_ICON_SIZE+2*this._ISOLATE_TOUCH_BUFFER);o.setInvisibleFill(),i.addChild(o)}this.getView().getEventManager().associate(i,this)}return i}_removeIsolateRestoreButton(){this._isolateButton&&(this._removeChildShape(this._isolateButton),this._isolateButton=null)}_createTextNode(t){var i=e.Agent.isRightToLeft(t.getCtx());if(!this._textStr||!t||!this._textStyle||this._textStyle===this.TEXT_STYLE_OFF)return null;var a=this._height,r=this.GetTextSize();if(r>a)return null;var n=this._textStyle===this.TEXT_STYLE_NODE?this._labelHalign:this._headerHalign;i&&("start"===n?n="end":"end"===n&&(n="start"));var h,o=this._width-(this.TEXT_BUFFER_HORIZ+this.MIN_TEXT_BUFFER),l=0;if(this.isIsolateEnabled()&&(l=this._ISOLATE_ICON_SIZE+this._ISOLATE_GAP_SIZE,o-="center"===n?2*l:l),o<=0)return null;var _=this.getMergedLabelTextStyle();if(h=this._textStyle===this.TEXT_STYLE_NODE&&a>2*r&&"nowrap"!==_.getStyle(e.CSSStyle.WHITE_SPACE)&&e.TextUtils.getTextStringWidth(this.getView().getCtx(),this._textStr,_)>o?new e.MultilineText(this.getView().getCtx(),this._textStr):new e.OutputText(this.getView().getCtx(),this._textStr),"start"===n?(i?h.setX(this._x+this.TEXT_BUFFER_HORIZ+l):h.setX(this._x+this.TEXT_BUFFER_HORIZ),h.alignLeft()):"center"===n?(h.setX(this._x+this._width/2),h.alignCenter()):"end"===n&&(i?h.setX(this._x+this._width-this.TEXT_BUFFER_HORIZ):h.setX(this._x+this._width-this.TEXT_BUFFER_HORIZ-l),h.alignRight()),this._textStyle===this.TEXT_STYLE_NODE)this.ApplyLabelTextStyle(h),a=this._height-2*this.TEXT_BUFFER_VERT;else if(this._textStyle===this.TEXT_STYLE_HEADER){var d="safari"===e.Agent.browser||"blink"===e.Agent.engine?this._LINE_FUDGE_FACTOR:0;h.setY(this._y+this.DEFAULT_HEADER_BORDER_WIDTH+this._titleBarHeight/2+d),h.alignMiddle(),this.ApplyHeaderTextStyle(h,"labelStyle")}if(this._textStyle===this.TEXT_STYLE_HEADER&&this.isDrillReplaceEnabled()){this.ApplyHeaderTextStyle(h,"_drillableLabelStyle"),h.setCursor("pointer");var g=new s(this,this.getId(),null,this.getDatatip.bind(this),this.getDatatipColor.bind(this));g.setDrillable(!0),this.getView().getEventManager().associate(h,g)}else h.setMouseEnabled(!1);var u=this.getView().getOptions().nodeDefaults.labelMinLength,c=e.TextUtils.fitText(h,o,a,t,u);if(this._textStyle===this.TEXT_STYLE_NODE){var p=h.getDimensions().h;"top"===this._labelValign?h.setY(this._y+this.TEXT_BUFFER_VERT):"center"===this._labelValign?h.setY(this._y+this._height/2-p/2):"bottom"===this._labelValign&&h.setY(this._y+this._height-this.TEXT_BUFFER_VERT-p)}return c?h:null}ApplyHeaderStyle(t,i){var s=this.getView().getOptions().nodeDefaults.header;if(this._bHeaderUseNodeColor){var a=this.getColor();i.setSolidFill(a);var r=e.ColorUtils.interpolateColor(s.borderColor,a,1-this.DEFAULT_HEADER_WITH_NODE_COLOR_ALPHA);t.setSolidFill(r)}else t.setSolidFill(s.borderColor),i.setSolidFill(s.backgroundColor);this._backgroundShape&&this._backgroundShape.setFill(i.getFill())}ApplyHeaderTextStyle(t,s){var a=[];this.GetDepth()<=1&&this.getView().__getMaxDepth()>=3&&a.push(new e.CSSStyle("font-weight:bold;")),a.push(this.getView().getOptions().nodeDefaults.header._labelStyle),a.push(this.getView().getOptions().nodeDefaults.header[s]),this._headerLabelStyle&&a.push(this._headerLabelStyle),a.push(new e.CSSStyle(this.getView().getOptions().nodeDefaults.header.labelStyle)),!this._bHeaderUseNodeColor||"labelStyle"!==s&&"_drillableLabelStyle"!==s||a.push(new e.CSSStyle("color: "+i.GetNodeTextColor(this))),t.setCSSStyle(e.CSSStyle.mergeStyles(a))}handleMouseOver(){this._isolateButton||e.Agent.isTouchDevice()||(this._isolateButton=this._createIsolateRestoreButton(this._shape)),super.handleMouseOver()}handleMouseOut(){!0===this.__isIsolated()||e.Agent.isTouchDevice()||this._removeIsolateRestoreButton(),super.handleMouseOut()}_getGeometriesWithGaps(){var t={};if(this._textStyle===this.TEXT_STYLE_HEADER){t._shape=new e.Rectangle(this._x,this._y,this._width-1,this._titleBarHeight),t._innerShape=new e.Rectangle(this._x+1,this._y+1,this._width-3,this._titleBarHeight-1);var i=Math.max(this._width-1,0),s=Math.max(this._height-this._titleBarHeight-1,0);t._backgroundShape=new e.Rectangle(this._x,this._y+this._titleBarHeight,i,s)}else if(this.hasChildren())t._shape=new e.Rectangle(this._x,this._y,0,0);else{var a=Math.max(this._width-1,0),r=Math.max(this._height-1,0);t._shape=new e.Rectangle(this._x,this._y,a,r)}return t}_updateShapes(){if(this._shape){var t=this.getView().getOptions();if("gaps"===t.nodeSeparators){var e=this._getGeometriesWithGaps();this._shape.setRect(e._shape),this._innerShape&&this._innerShape.setRect(e._innerShape),this._backgroundShape&&this._backgroundShape.setRect(e._backgroundShape)}else this._shape.setRect(this._x,this._y,this._width,this._height),this._innerShape&&this._innerShape.setRect(this._x+1,this._y+1,this._width-2,this._height-2);(this._textStyle!==this.TEXT_STYLE_HEADER||this._bHeaderUseNodeColor)&&this._shape.setFill(this.GetFill()),this.isSelected()&&this.setSelected(!1),this._removeChildShape(this._fillShape),this._removeChildShape(this._topLeftShape),this._fillShape=null,this._topLeftShape=null,this._removeIsolateRestoreButton(),t.nodeContent&&t.nodeContent.renderer&&this._textStyle!==this.TEXT_STYLE_HEADER?this._removeAllNodeContent():(this._removeChildShape(this._textBackground),this._textBackground=null,this._text&&this._text.getParent().removeChild(this._text),this._text=this._createTextNode(this._shape))}}getDropSiteFeedback(){return this._shape?new e.Rect(this.getView().getCtx(),this._shape.getX(),this._shape.getY(),this._shape.getWidth(),this._shape.getHeight()):null}_addChildText(t){this._textStyle===this.TEXT_STYLE_NODE&&this.hasChildren()?this.getView().__getGroupTextLayer().addChild(t):this._shape.addChild(t)}_removeChildShape(t){t&&this._shape.removeChild(t)}_getIsolateButton(){return this._getButtonHelper("isolate",this.__isolateNode)}_getRestoreButton(){return this._getButtonHelper("restore",this.__restoreNode)}_getButtonHelper(t,i){var s=this.getView().getCtx(),a=this.getView().getOptions()._resources[t],r=e.ToolkitUtils.getIconStyle(s,a),n=new e.IconButton(s,"borderless",{style:r,size:this._ISOLATE_ICON_SIZE});return n.addEvtListener(e.MouseEvent.CLICK,i,!1,this),n}__isIsolated(){return this._bIsolated}__isolateNode(t){this._bIsolated=!0,this._removeAllNodeContent(),this.hideHoverEffect(),this.getView().__isolate(this),this._removeIsolateRestoreButton(),this.UpdateAriaLabel(),t&&t.stopPropagation()}__restoreNode(t){this._bIsolated=!1,this.hideHoverEffect(),this.getView().__restore(),this._removeIsolateRestoreButton(),this.UpdateAriaLabel(),t&&t.stopPropagation()}getIsolateRestoreButton(){return this._isolateButton}getDatatip(t,i,s){return t&&t instanceof e.IconButton?null:super.getDatatip(t,i,s)}getDatatipColor(t){return t&&t instanceof e.IconButton?null:super.getDatatipColor(t)}getTooltip(t){return t&&t instanceof e.IconButton?this.getView().getOptions().translations[this.__isIsolated()?"tooltipRestore":"tooltipIsolate"]:null}getAriaLabel(){var t=this.getView().getOptions().translations,s=[];return this.isSelectable()&&s.push(t[this.isSelected()?"stateSelected":"stateUnselected"]),this.__isIsolated()&&s.push(t.stateIsolated),this.isDrillReplaceEnabled()&&s.push(t.stateDrillable),e.Displayable.generateAriaLabel(this.getShortDesc(),s,()=>i.getShortDescContext(this))}UpdateAriaLabel(){!e.Agent.deferAriaCreation()&&this._shape&&this._shape.setAriaProperty("label",this.getAriaLabel())}_createCustomNodeContent(){var t=this.getView(),i=t.getOptions(),s=this.getId();this._removeNodeContent(s);var a=i.nodeContent.renderer;if(!a||this.hasChildren())return!1;var r=t.getIsolatedNodes();if(r.length<=0||this.isDescendantOf(r[t._isolatedNodes.length-1])){var n,h=t.getCtx(),o=this.getOptions(),l=o;o._noTemplate?(n=o._itemData,l=o._itemData):o._itemData&&(n=o._itemData,l=o=e.JsonUtils.clone(o),delete o._itemData);var _={bounds:{x:this._x,y:this._y,width:this._width-this.DEFAULT_NODE_BORDER_WIDTH,height:this._height-this.DEFAULT_NODE_BORDER_WIDTH},id:s,data:l,itemData:n,component:o._widgetConstructor};_=h.fixRendererContext(_);var d=h.getContainer(),g=a(_);if(!g)return!1;var u=h.createOverlayDiv();Array.isArray(g)?g.forEach(t=>{u.appendChild(t)}):u.appendChild(g),t.getNodeContent()[s]=u,d.appendChild(u);var c=h.getOverlayAttachedCallback();c&&c(u)}return!0}_removeNodeContent(t){var e=this.getView(),i=e.getNodeContent(),s=i[t];s&&(e.getCtx().getContainer().removeChild(s),delete i[t])}_removeAllNodeContent(){for(var t in this.getView().getNodeContent())this._removeNodeContent(t)}}class c extends e.Automation{GetSubIdForDomElement(t){var a=this._comp.getLogicalObject(t),r=this._comp.getRootNode(),n=t instanceof e.Button||t instanceof e.IconButton,h=t.getParent();if((h instanceof e.Button||h instanceof e.IconButton)&&(t=h,n=!0),!a)return(h=t.getParent())instanceof _?"breadcrumbs["+h.getCrumbIndex(t)+"]":null;var o=null;if(a instanceof s&&n){var l=a._node;return o=this.GetSubIdForDomElement(l.getDisplayable()),this._getSubIdForButton(o,l,t)}if(a instanceof i){var d=a,g="";if(!r.isArtificialRoot()){if(d==r)return"node[0]";g+="[0]"}var u=this._getIndicesFromNode(d,r.getChildNodes());return(g=u?g+u:g).length>0&&(o="node"+g),n?this._getSubIdForButton(o,a,t):o}return null}_getSubIdForButton(t,e,i){if(t){if(e instanceof u){var s=i.getAriaProperty("label"),a=e.getView().getOptions().translations.stateIsolated;return s.indexOf(a)>=0?"restore":t+":isolate"}if(e instanceof g)return t+":disclosure"}return null}_getIndicesFromNode(t,e){if(e&&e.length>0)for(var i=0;i<e.length;i++){if(e[i]==t)return"["+i+"]";var s=this._getIndicesFromNode(t,e[i].getChildNodes());if(s)return"["+i+"]"+s}return null}getDomElementForSubId(t){if(!t)return null;var i=this._comp.getRootNode();if(t==e.Automation.TOOLTIP_SUBID)return this.GetTooltipElement(this._comp);if(0==t.indexOf("breadcrumbs")){var s=t.substring(t.indexOf("[")+1,t.indexOf("]")),a=i.getView().getBreadcrumbs().getCrumb(s);return a?a.getElem():null}if("restore"==t){var r=this._comp._restoreNode||this._comp.__getLastIsolatedNode();if(r)return r.getIsolateRestoreButton().getElem()}i.isArtificialRoot()||(t=t.substring(0,t.indexOf("["))+t.substring(t.indexOf("]")+1));var n=-1==t.indexOf("[")?i:this._getNodeFromSubId(i,t);if(n){var h=t.indexOf(":");if(!(h>=0))return n.getDisplayable().getElem();if(t=t.substring(h+1),n instanceof g&&"disclosure"==t){var o=n.getExpandCollapseButton();if(o)return o.getElem()}if(n instanceof u&&"isolate"==t){var l=n.getIsolateRestoreButton();if(l)return l.getElem()}}return null}_getNodeFromSubId(t,e){var i=e.indexOf("["),s=e.indexOf("]");if(i>=0&&s>=0){var a=e.substring(i+1,s),r=(e=e.substring(s+1)).indexOf("["),n=e.indexOf("]"),h=c._getNodeByIndex(t.getChildNodes(),a);return h&&r>=0&&n>=0?this._getNodeFromSubId(h,e):h}return null}_getNodeFromPath(t,e){var i=e.shift(),s=c._getNodeByIndex(t.getChildNodes(),i);return 0==e.length?s:e.length>0?this._getNodeFromPath(s,e):null}getNode(t){var e=this._comp.getRootNode();if(!e)return null;e.isArtificialRoot()||0!=t[0]||t.shift();var i=0==t.length?e:this._getNodeFromPath(e,t);return i?{color:i.getColor(),label:i.getLabel(),selected:null!=i.isSelected()&&i.isSelected(),size:i.getSize(),tooltip:i.getShortDesc()}:null}static _getNodeByIndex(t,e){for(var i=0;i<t.length;i++)if(e==t[i].getIndex())return t[i];return null}}const p={_COMPONENT_GAP:6,_ENABLED_INLINE_STYLE:"color: #003286;",render:(t,i,s,a)=>{var r=t.getCtx(),n=t.getOptions().styleDefaults,h=[];h.push(new e.CSSStyle(p._ENABLED_INLINE_STYLE)),h.push(n._drillTextStyle);var o=e.CSSStyle.mergeStyles(h).toString(),l=o+"text-decoration: underline;",d=[];d.push(n._currentTextStyle);var g={labelStyle:o,labelStyleOver:l,labelStyleDown:l,disabledLabelStyle:e.CSSStyle.mergeStyles(d).toString()},u=new _(r,t.__processBreadcrumbsEvent,t,g);t.addChild(u);var c=s.slice(0).reverse();c.push({label:a});var v={items:c};u.render(v,i.w);var E=u.getDimensions();u.setTranslate(i.x,i.y);var S=E.h+p._COMPONENT_GAP;return i.y+=S,i.h-=S,t.removeChild(u),u}};class v extends e.CategoryRolloverHandler{GetRolloverCallback(t){return()=>{this.SetHighlightMode(!0),this._processHighlighting(),this.FireCallback(t)}}_highlightDescendants(t){for(var i,s,r=new Set(a.getAllIds(t)),n=a.getAllNodes(this._callbackObj.getRootNode()),h=0;h<n.length;h++)i=n[h],s=t&&!r.has(i.getId()),i.highlight(s,s?e.CategoryRolloverHandler._FADE_OUT_OPACITY:1)}GetRolloutCallback(t){return()=>{this.SetHighlightModeTimeout(),this._processHighlighting(),this.FireCallback(t)}}_processHighlighting(){var t=this._callbackObj,i=t.getOptions();if("descendants"===i.highlightMode){var s=t.EventManager.getCurrentHoverObj();this._highlightDescendants(s)}else e.CategoryRolloverHandler.highlight(i.highlightedCategories,a.getAllNodes(t.getRootNode()),"any"==i.highlightMatch)}}class E extends e.EventManager{constructor(t,e,i,s){super(e,i,s,t),this._view=t}GetView(){return this._view}OnDblClickInternal(t){var e=this.GetLogicalObject(t.target);e&&e.isSelectable&&e.isSelectable()&&this._processDrill(e,t.shiftKey)}OnClick(t){super.OnClick(t);var e=this.GetLogicalObject(t.target);this._processNodeLabel(e),!e||e.isSelectable&&e.isSelectable()||this._processDrill(e,t.shiftKey)}OnMouseOver(t){super.OnMouseOver(t);var e=this.GetLogicalObject(t.target);e&&e.handleMouseOver&&e.handleMouseOver()}OnMouseOut(t){super.OnMouseOut(t);var i=this.GetLogicalObject(t.target);if(i&&i.handleMouseOut){var s=this.GetLogicalObject(t.relatedTarget),a=s&&s.getId?s.getId():null;null!=i.getId()&&e.Obj.compareValues(this.getCtx(),a,i.getId())||i.handleMouseOut()}}ProcessKeyboardEvent(t){var i=!1;if(t.keyCode!=e.KeyboardEvent.ENTER||t.ctrlKey)i=super.ProcessKeyboardEvent(t);else{var s=this.getFocus();s.isDrillReplaceEnabled&&s.isDrillReplaceEnabled()&&(t.shiftKey&&(s=this._view.getRootNode()),this._view.__drill(s.getId(),t.shiftKey)),e.EventManager.consumeEvent(t),i=!0}return i}HandleTouchClickInternal(t){var e=t.target,s=this.GetLogicalObject(e);this._processNodeLabel(s),this._currentHoverItem&&this._currentHoverItem!=s&&(this._currentHoverItem.handleMouseOut(),this._currentHoverItem=null),s&&(s instanceof i&&this._currentHoverItem!=s&&(this._currentHoverItem=s,s.handleMouseOver()),s.isSelectable&&s.isSelectable()||this._processDrill(s,t.shiftKey))}HandleTouchDblClickInternal(t){var e=t.target,i=this.GetLogicalObject(e);i&&i.isSelectable&&i.isSelectable()&&this._processDrill(i,!1)}_processNodeLabel(t){t&&t instanceof s&&t.isDrillable()&&this._view.__drill(t.getId(),!1)}_processDrill(t,e){t.isDrillReplaceEnabled&&t.isDrillReplaceEnabled()&&this._view.__drill(t.getId(),e)}ProcessRolloverEvent(t,i,s){var r=this._view.getOptions();if("dim"==r.hoverBehavior){this._currentHoverItem=s?i:null;var n=i.getCategories?i.getCategories():[];r.highlightedCategories=s?n.slice():null;var h=e.EventFactory.newCategoryHighlightEvent(r.highlightedCategories,s),o=a.getAllNodes(this.GetView().getRootNode()),l=e.CSSStyle.getTimeMilliseconds(r.hoverBehaviorDelay);this.RolloverHandler.processEvent(h,o,l,"any"==r.highlightMatch)}}CreateCategoryRolloverHandler(t,e){return new v(t,e)}getCurrentHoverObj(){return this._currentHoverItem}GetTouchResponse(){return this._view.getOptions().touchResponse}}class S extends e.KeyboardHandler{isSelectionEvent(t){return this.isNavigationEvent(t)&&!t.ctrlKey}isMultiSelectEvent(t){return t.keyCode==e.KeyboardEvent.SPACE&&t.ctrlKey}}const C={_LEGEND_GAP:4,_LEGEND_LABEL_GAP:7,_LEGEND_SECTION_GAP:24,render:(t,i)=>{var s=t.getOptions(),a=s.sizeLabel,r=s.colorLabel;if(!(null!=a&&""!=a||null!=r&&""!=r))return null;var n=t.getCtx(),h=new e.Container(n);t.addChild(h);var o=C._renderLabels(n,t,h,i.w,a,r),l=o?o.getDimensions():null;o&&o.setTranslateX(i.y+(i.w-l.w)/2);var _=h.getDimensions();return h.setTranslateY(i.y+i.h-_.h),i.h-=_.h+C._LEGEND_GAP,t.removeChild(h),h},_renderLabels:(t,i,s,a,r,n)=>{var h=e.Agent.isRightToLeft(t),o=i.getEventManager(),l=i.getOptions().styleDefaults,_=null;if(r||n){_=new e.Container(t),s.addChild(_);var d=[];d.push(l._attributeTypeTextStyle);var g=e.CSSStyle.mergeStyles(d);(d=[]).push(l._attributeValueTextStyle);var u,c,p,v,E,S,b,A,T=e.CSSStyle.mergeStyles(d),y=0;if(r){var x=i.getOptions().translations.labelSize;(u=new e.OutputText(t,x,0,0)).setCSSStyle(g),_.addChild(u),p=u.getDimensions().w,(c=new e.OutputText(t,r,0,0)).setCSSStyle(T),_.addChild(c),y=p+(v=c.getDimensions().w)+C._LEGEND_LABEL_GAP}var O=0;if(n){var f=i.getOptions().translations.labelColor;(E=new e.OutputText(t,f,0,0)).setCSSStyle(g),_.addChild(E),b=E.getDimensions().w,(S=new e.OutputText(t,n,0,0)).setCSSStyle(T),_.addChild(S),O=b+(A=S.getDimensions().w)+C._LEGEND_LABEL_GAP}if(y+O>(a-=C._LEGEND_SECTION_GAP)){var R=a/2;if(y>R&&O>R){var D=isNaN(p)?0:R-p-C._LEGEND_LABEL_GAP;e.TextUtils.fitText(c,D,1/0,_)?(v=c.getDimensions().w,o.associate(c,new e.SimpleObjPeer(r))):(_.removeChild(u),_.removeChild(c),c=null,v=0);var I=R-b-C._LEGEND_LABEL_GAP;e.TextUtils.fitText(S,I,1/0,_)?(A=S.getDimensions().w,o.associate(S,new e.SimpleObjPeer(n))):(_.removeChild(E),_.removeChild(S),S=null,A=0)}else if(y>O)e.TextUtils.fitText(c,a-O-p-C._LEGEND_LABEL_GAP,1/0,_)?(v=c.getDimensions().w,o.associate(c,new e.SimpleObjPeer(r))):(_.removeChild(u),_.removeChild(c),c=null,v=0);else{var m=isNaN(b)?0:a-y-b-C._LEGEND_LABEL_GAP;e.TextUtils.fitText(S,m,1/0,_)?(A=S.getDimensions().w,o.associate(S,new e.SimpleObjPeer(n))):(_.removeChild(E),_.removeChild(S),S=null,A=0)}}var N=0;h?(E&&S&&(S.setX(N),N+=A+C._LEGEND_LABEL_GAP,E.setX(N),N+=b+C._LEGEND_SECTION_GAP),u&&c&&(c.setX(N),N+=v+C._LEGEND_LABEL_GAP,u.setX(N))):(u&&c&&(u.setX(N),N+=p+C._LEGEND_LABEL_GAP,c.setX(N),N+=v+C._LEGEND_SECTION_GAP),E&&S&&(E.setX(N),N+=b+C._LEGEND_LABEL_GAP,S.setX(N)))}return _}};class b extends e.BaseComponent{constructor(t,e,i){super(t,e,i),this.EventManager=this.CreateEventManager(this,t,this.dispatchEvent,this),this.EventManager.addListeners(this),this._legend=null,this._hasFocus=!1,this._navigableIdToFocus=null}SetOptions(t){if(t){if(this.Options=this.Defaults.calcOptions(t),e.Agent.isEnvironmentTest()&&(this.Options.animationOnDisplay="none",this.Options.animationOnDataChange="none"),this.Options._nodes=this.Options.nodes,this.Options.rootNode){this.Options._ancestors=null;var i=a.findRootAndAncestors(this.getCtx(),this.Options.nodes,this.Options.rootNode,[]);i&&i.root&&(this.Options.nodes=[i.root]),i&&i.ancestors&&(this.Options._ancestors=i.ancestors)}}else this.Options||(this.Options=this.GetDefaults())}render(t,i,s){var a=t||!this.Options;this.SetOptions(t);var n=this._processNodes();this.ApplyParsedProps({root:n}),isNaN(i)||isNaN(s)||(this.Width=i,this.Height=s),this.EventManager&&this.EventManager.hideTooltip();var h=new e.Rectangle(0,0,this.Width,this.Height);this.Layout(h);var o=new e.Container(this.getCtx());this.addChild(o),this.Render(o,h),this.StopAnimation();var l=this.getOptions().animationOnDataChange,_=new e.Rectangle(0,0,this.Width,this.Height),d=!1;if(this._container){if(l&&a)if(e.BlackBoxAnimationHandler.isSupported(l))this.Animation=e.BlackBoxAnimationHandler.getCombinedAnimation(this.getCtx(),l,this._container,o,_,this.AnimationDuration),d=!0;else if(this._oldRoot&&"auto"==l){this._deleteContainer=this.GetDeleteContainer(),this.addChild(this._deleteContainer);var g=new r(this.getCtx(),this._deleteContainer);g.animate(this._oldRoot,this._root,this._oldAncestors,this._ancestors),this.Animation=g.getAnimation(!0)}}else this.Animation=this.GetDisplayAnim(o,_);this._oldRoot=null,this._oldAncestors=null,this.Animation&&(this.EventManager.removeListeners(this),this.Animation.setOnEnd(this.OnAnimationEnd,this),this.Animation.play()),d?this._oldContainer=this._container:this._container&&this.removeChild(this._container),this._container=o,a?this._processInitialSelections():this.ReselectNodes(),this._processInitialFocus(!this.Animation),this.Animation||this._processInitialHighlighting(),this.UpdateAriaAttributes(),this.Animation||this.RenderComplete()}Parse(t){return null}Layout(t){}Render(t,e){}RenderBackground(t){var i=new e.Rect(this.getCtx(),0,0,this.Width,this.Height);i.setInvisibleFill(),t.addChild(i)}LayoutBreadcrumbs(t){if(this._ancestors.length>0){var e=this._root?this._root.getLabel():null;this._breadcrumbs&&this.EventManager.removeComponentKeyboardHandler(this._breadcrumbs.getEventManager()),this._breadcrumbs=p.render(this,t,this._ancestors,e),this.EventManager.addComponentKeyboardHandlerAt(this._breadcrumbs.getEventManager(),0)}else this._breadcrumbs&&this.EventManager.removeComponentKeyboardHandler(this._breadcrumbs.getEventManager()),this._breadcrumbs=null}RenderBreadcrumbs(t){this._breadcrumbs&&t.addChild(this._breadcrumbs)}LayoutLegend(t){this._legend=C.render(this,t,this._legendSource)}RenderLegend(t){this._legend&&(t.addChild(this._legend),this._legend=null)}RenderEmptyText(t){var i=this.getOptions(),s=i.emptyText;s||(s=i.translations.labelNoData),this.renderEmptyText(t,s,new e.Rectangle(0,0,this.Width,this.Height),this.getEventManager(),i._statusMessageStyle)}HasValidData(){return this._root&&this._root.getSize()>0}GetDisplayAnim(t,i){var s=this.getOptions().animationOnDisplay;return e.BlackBoxAnimationHandler.isSupported(s)?e.BlackBoxAnimationHandler.getInAnimation(this.getCtx(),s,t,i,this.AnimationDuration):null}OnAnimationEnd(){this._deleteContainer&&(this.removeChild(this._deleteContainer),this._deleteContainer=null),this._oldContainer&&(this.removeChild(this._oldContainer),this._oldContainer=null),this.EventManager.addListeners(this),this._processInitialFocus(!0),this._processInitialHighlighting(),this.AnimationStopped||this.RenderComplete(),this.Animation=null,this.AnimationStopped=!1}GetDeleteContainer(){return new e.Container(this.getCtx())}CreateKeyboardHandler(t){return new S(t)}CreateEventManager(t,e,i,s){return new E(t,e,i,s)}GetInitialFocusedItem(t){if(t&&t.isArtificialRoot()){var e=t.getChildNodes();if(e&&e.length>0)return e[0]}return t}highlight(t){this.getOptions().highlightedCategories=e.JsonUtils.clone(t),e.CategoryRolloverHandler.highlight(t,a.getAllNodes(this._root),"any"==this.getOptions().highlightMatch)}select(t){var i=this.getOptions();if(i.selection=e.JsonUtils.clone(t),this._selectionHandler){var s=a.getAllNodes(this._root);this._selectionHandler.processInitialSelections(i.selection,s)}}__getMaxDepth(){return this._maxDepth}__getNodeCount(){return this._nodeCount}ApplyParsedProps(t){var i=this.getOptions();this._oldRoot=this._root,this._oldAncestors=this._ancestors,this._root=t.root,this._ancestors=i._ancestors?i._ancestors:[],this._nodeCount=this._root?a.calcNodeCount(this._root):0,this._maxDepth=this._root?a.calcMaxDepth(this._root,0):0,this.AnimationDuration=e.CSSStyle.getTimeMilliseconds(i.animationDuration)/1e3,this._styles=t.styles?t.styles:{},"none"==i.selectionMode?this._nodeSelection=null:"single"==i.selectionMode?this._nodeSelection=e.SelectionHandler.TYPE_SINGLE:this._nodeSelection=e.SelectionHandler.TYPE_MULTIPLE,this._nodeSelection?(this._selectionHandler=new e.SelectionHandler(this.getCtx(),this._nodeSelection),this._initialSelection=i.selection):this._selectionHandler=null,this.EventManager.setSelectionHandler(this._selectionHandler),this.EventManager.setKeyboardHandler(this.CreateKeyboardHandler(this.EventManager)),this._legendSource=null}ReselectNodes(){for(var t=this._selectionHandler?this._selectionHandler.getSelection():[],e=0;e<t.length;e++)t[e].setSelected(!0)}_processInitialSelections(){if(this._selectionHandler&&this._initialSelection){var t=a.getAllNodes(this._root);this._selectionHandler.processInitialSelections(this._initialSelection,t),this._initialSelection=null}}_processInitialHighlighting(){var t=this.getOptions().highlightedCategories;t&&t.length>0&&this.highlight(t)}_processInitialFocus(t){var e=null,s=this.__getNavigableIdToFocus();s&&(e=i.getNodeById(this._root,s),this.EventManager.setFocus(e)),t&&this.__setNavigableIdToFocus(null),e||(e=this.GetInitialFocusedItem(this._root),this.EventManager.setFocus(e)),t&&this.setFocused(this.isFocused())}setFocused(t){this._hasFocus=t,this.EventManager.setFocused(t)}isFocused(){return this._hasFocus}__getAnimDur(){return this.AnimationDuration}__getNodeUnderPoint(t,e){return this._root.getNodeUnderPoint(t,e)}__isDragAvailable(t){return this._selectionHandler?t[0]:null}__getDragTransferable(t){t.isSelected()||(this._selectionHandler.processClick(t,!1),this.EventManager.fireSelectionEvent());for(var e=[],i=this._selectionHandler.getSelection(),s=0;s<i.length;s++)e.push(i[s].getId());return e}__getDragFeedback(){for(var t=[],e=this._selectionHandler.getSelection(),i=0;i<e.length;i++)t.push(e[i].getDisplayable());return t}__showDropSiteFeedback(t){if(this._dropSiteFeedback&&(this.removeChild(this._dropSiteFeedback),this._dropSiteFeedback=null),t&&(this._dropSiteFeedback=t.getDropSiteFeedback(),this._dropSiteFeedback)){var e=this.getOptions().styleDefaults;this._dropSiteFeedback.setSolidFill(e._dropSiteFillColor,e._dropSiteOpacity),this._dropSiteFeedback.setSolidStroke(e._dropSiteBorderColor),this.addChild(this._dropSiteFeedback)}return this._dropSiteFeedback}__processBreadcrumbsEvent(t){"breadcrumbsDrill"===t.type&&this.__drill(t.id,!1)}__drill(t,i){var s=this.getOptions()._widgetConstructor;i&&this._root&&t==this._root.getId()&&this._ancestors.length>0?(this.__setNavigableIdToFocus(t),this.dispatchEvent(e.EventFactory.newTreeDrillEvent(this._ancestors[0].id,a.findRootAndAncestors(this.getCtx(),this.getOptions()._nodes,this._ancestors[0].id,[]).root,s))):i||this.dispatchEvent(e.EventFactory.newTreeDrillEvent(t,a.findRootAndAncestors(this.getCtx(),this.getOptions()._nodes,t,[]).root,s)),this.getCtx().getTooltipManager().hideTooltip()}getLogicalObject(t){return this.EventManager.GetLogicalObject(t)}getRootNode(){return this._root}__getNavigableIdToFocus(){return this._navigableIdToFocus}__setNavigableIdToFocus(t){this._navigableIdToFocus=t}__getNodeSelection(){return this._nodeSelection}CreateNode(t){return null}getAutomation(){return new c(this)}getBreadcrumbs(){return this._breadcrumbs}_processNodes(){var t=this.getOptions();if(null==t.nodes||0==t.displayLevels)return null;for(var i=[],s=e.ArrayUtils.createBooleanMap(t.hiddenCategories),a=0;a<t.nodes.length;a++){var r=t.nodes[a];r._index=a;var n=this._processNode(s,r,t.displayLevels);n&&i.push(n)}if(1==i.length)return i[0];for(var h=0,o=0;o<i.length;o++)h+=i[o].getSize();var l={value:h,bArtificialRoot:!0,id:this._id},_=this.CreateNode(l);return _.setChildNodes(i),_}_processNode(t,e,i){if(a.isHiddenNode(t,e))return null;var s=this.CreateNode(e);if(s.isDisclosed()&&i>1){for(var r=[],n=e.nodes?e.nodes:[],h=0;h<n.length;h++){var o=n[h];o._index=h;var l=this._processNode(t,o,null!=i?i-1:i);l&&r.push(l)}s.setChildNodes(r)}return s}UpdateAriaNavigation(t){if(e.Agent.isTouchDevice()||e.Agent.isEnvironmentTest())for(var i=a.getAllVisibleNodes(t),s=0;s<i.length-1;s++){var r=this.getId()+(i[s+1].getId()?i[s+1].getId():i[s+1].getLabel());r=r.replace(/\s+/g,""),i[s+1].getDisplayable().setId(r,!0),i[s].getDisplayable().setAriaProperty("flowto",r)}}hasDataProvider(){return!!this.getOptions().data}}class A extends e.BaseComponentDefaults{constructor(t,i){const s={skin:e.CSSStyle.SKIN_ALTA,animationDuration:500,animationOnDataChange:"none",animationOnDisplay:"none",drilling:"off",displayLevels:Number.MAX_VALUE,highlightMatch:"all",hoverBehavior:"none",hoverBehaviorDelay:200,nodeDefaults:{labelStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_11),labelMinLength:1},selectionMode:"multiple",sorting:"off",_statusMessageStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA),styleDefaults:{_attributeTypeTextStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_BOLD_12+"color:#4F4F4F"),_attributeValueTextStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_12),_currentTextStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_12),_drillTextStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_12),_labelStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA)},touchResponse:"auto",_resources:{}};super({alta:e.JsonUtils.merge(t.alta,s)},i)}}class T extends A{constructor(t){super({alta:{nodeDefaults:{borderColor:"rgba(255,255,255,0.3)",borderWidth:1,hoverColor:"#FFFFFF",labelDisplay:"auto",labelHalign:"center",selectedInnerColor:"#FFFFFF",selectedOuterColor:"#000000"},rootNodeContent:{},rotation:"on",expanded:"all",startAngle:90}},t)}}class y extends E{constructor(t,e,i,s){super(t,e,i,s),this.ROTATE_KEY="rotateKey"}OnMouseDown(t){var e=this.GetLogicalObject(t.target);if(e&&e.getId&&e.getId()===y.ROTATION_ID&&!this._bRotating){this._bRotating=!0;var i=this._context.pageToStageCoords(t.pageX,t.pageY);this.GetView().__startRotation(i.x,i.y)}else super.OnMouseDown(t)}OnMouseMove(t){if(this._bRotating){var e=this._context.pageToStageCoords(t.pageX,t.pageY);this.GetView().__continueRotation(e.x,e.y)}else super.OnMouseMove(t)}OnMouseUp(t){this._bRotating?(this._bRotating=!1,this.GetView().__endRotation()):super.OnMouseUp(t)}ProcessKeyboardEvent(t){var i=!0,s=t.keyCode,a=this.getFocus(),r=this.GetView();if(a.isExpandCollapseEnabled()&&(e.KeyboardEvent.isPlus(t)&&!a.isDisclosed()||e.KeyboardEvent.isMinus(t)&&a.isDisclosed()||t.ctrlKey&&s===e.KeyboardEvent.ENTER))r.expandCollapseNode(a.getId()),e.EventManager.consumeEvent(t);else if(r&&r.__isRotationEnabled()&&(s===e.KeyboardEvent.LEFT_ARROW||s===e.KeyboardEvent.RIGHT_ARROW)&&!t.ctrlKey&&t.altKey&&t.shiftKey){var n;n=s===e.KeyboardEvent.LEFT_ARROW?Math.PI/180*-5:Math.PI/180*5,r.__setRotationAnchor(0),r.__rotate(n),r.__endRotation(),e.EventManager.consumeEvent(t)}else i=super.ProcessKeyboardEvent(t);return i}HandleImmediateTouchStartInternal(t){var e=this.GetLogicalObject(t.target);e&&e.getId&&e.getId()===y.ROTATION_ID&&this.TouchManager.processAssociatedTouchAttempt(t,this.ROTATE_KEY,this.RotateStartTouch,this)}HandleImmediateTouchMoveInternal(t){this.TouchManager.processAssociatedTouchMove(t,this.ROTATE_KEY)}HandleImmediateTouchEndInternal(t){this.TouchManager.processAssociatedTouchEnd(t,this.ROTATE_KEY)}RotateStartTouch(t,e){if(this.TouchManager.getTouchIdsForObj(this.ROTATE_KEY).length<=1){this.TouchManager.saveProcessedTouch(e.identifier,this.ROTATE_KEY,null,this.ROTATE_KEY,this.ROTATE_KEY,this.RotateMoveTouch,this.RotateEndTouch,this),this.TouchManager.setTooltipEnabled(e.identifier,!1);var i=this._context.pageToStageCoords(e.pageX,e.pageY);this.GetView().__startRotation(i.x,i.y),t.blockTouchHold()}}RotateMoveTouch(t,e){var i=this._context.pageToStageCoords(e.pageX,e.pageY);this.GetView().__continueRotation(i.x,i.y),t.preventDefault()}RotateEndTouch(){this.GetView().__endRotation()}}y.ROTATION_ID="_rotationShape";const x={layout:(t,e,i,s,a)=>{var r=t/x._calcLargestRadius(e);x._layout(r,e,i,s,a,0)},_layout:(t,i,s,a,r,n)=>{var h=n+i.__getRadius()*t;i.setLayoutParams(n,h,s,a);var o=i.getChildNodes();if(null!=o&&i.isDisclosed()){var l,_=s;"on"===r&&(o=o.slice(0)).sort((t,e)=>e.getSize()-t.getSize()),e.Agent.isRightToLeft(i.getView().getCtx())&&(o=o.slice(0).reverse());var d=0;for(l=0;l<o.length;l++)d+=o[l].getSize()>0?o[l].getSize():0;for(l=0;l<o.length;l++){var g=o[l];if(g.getSize()>0){var u=g.getSize()/d*a;x._layout(t,g,_,u,r,h),_+=u}}}},_calcLargestRadius:t=>{var e=0,i=t.getChildNodes();if(i&&i.length>0){for(var s=0;s<i.length;s++){var a=x._calcLargestRadius(i[s]);e=Math.max(e,a)}return e+t.__getRadius()}return t.__getRadius()}};class O extends A{constructor(t){super({alta:{groupGaps:"outer",nodeDefaults:{header:{backgroundColor:"#FFFFFF",borderColor:"#d6dfe6",hoverBackgroundColor:"#ebeced",hoverOuterColor:"#ebeced",hoverInnerColor:"#d6d7d8",isolate:"auto",labelHalign:"start",_labelStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color:#252525;"),selectedBackgroundColor:"#dae9f5",selectedInnerColor:"#FFFFFF",selectedOuterColor:"#000000",useNodeColor:"off",_hoverLabelStyle:new e.CSSStyle("color:#252525;"),_selectedLabelStyle:new e.CSSStyle("color:#252525;"),_drillableLabelStyle:new e.CSSStyle("color:#145c9e;"),_drillableHoverLabelStyle:new e.CSSStyle("color:#145c9e;"),_drillableSelectedLabelStyle:new e.CSSStyle("color:#145c9e;")},hoverColor:"#ebeced",groupLabelDisplay:"header",labelDisplay:"node",labelHalign:"center",labelValign:"center",selectedInnerColor:"#FFFFFF",selectedOuterColor:"#000000"},nodeSeparators:"gaps",nodeContent:{}}},t)}}class f extends E{ProcessKeyboardEvent(t){var i=!0;if(t.keyCode===e.KeyboardEvent.ENTER&&t.ctrlKey){var s=this.getFocus();s.isIsolateEnabled()&&(s.__isIsolated()?s.__restoreNode():s.__isolateNode()),e.EventManager.consumeEvent(t)}else i=super.ProcessKeyboardEvent(t);return i}}class R extends S{isNavigationEvent(t){var i=super.isNavigationEvent(t);if(!i){var s=t.keyCode;s!==e.KeyboardEvent.OPEN_BRACKET&&s!==e.KeyboardEvent.CLOSE_BRACKET||(i=!0)}return i}}class D{constructor(){this._zIndex=0,this._GROUP_GAP=2}layout(t,e,i,s,a,r,n){}setNodeBounds(t,i,s,a,r,n){if(t.setZIndex(this._zIndex),this._zIndex++,!n||!t.hasChildren()){var h=this.getGapSize(t.getView(),t.GetDepth()),o=Math.round(i+h),l=Math.round(s+h),_=Math.round(i+a-h)-o,d=Math.round(s+r-h)-l,g=t.setLayoutParams(o,l,_,d);if(g)return g}return new e.Rectangle(i,s,a,r)}getGapSize(t,e){var i=t.getOptions().groupGaps;return"outer"===i?1===e&&t.__getMaxDepth()>=2?this._GROUP_GAP:0:"all"===i&&e<t.__getMaxDepth()?this._GROUP_GAP:0}}class I extends D{constructor(t){super(),this._isHoriz=t}layout(t,e,i,s,a,r,n){var h=!n;this._layout(this._isHoriz,t,e,i,s,a,r,h)}_layout(t,i,s,a,r,n,h,o){var l=i.getOptions(),_=this.setNodeBounds(s,a,r,n,h,o),d=s.getChildNodes();if(null!=d){var g,u=_.x,c=_.y,p=_.w,v=_.h,E=0;for(g=0;g<d.length;g++)E+=d[g].getSize()>0?d[g].getSize():0;for("on"===l.sorting&&(d=d.slice(0)).sort((t,e)=>e.getSize()-t.getSize()),t&&e.Agent.isRightToLeft(i.getCtx())&&(d=d.slice(0).reverse()),g=0;g<d.length;g++){var S=d[g];if(S.getSize()>0){var C=S.getSize()/E;t?p=_.w*C:v=_.h*C,this._layout(!t,i,S,u,c,p,v,!1),t?u+=p:c+=v}}}}}class m extends D{layout(t,e,i,s,a,r,n){var h=!n;this._layout(e,i,s,a,r,h)}_layout(t,i,s,a,r,n){var h=this.setNodeBounds(t,i,s,a,r,n),o=t.getChildNodes();if(null!=o&&o.length>0){this._calcPixelSize(o,h.w*h.h),o=o.slice(0).sort((t,e)=>t.getSize()-e.getSize());var l=Math.min(h.w,h.h),_=new e.Rectangle(h.x,h.y,h.w,h.h);this._squarify(o,[],l,_,1/0)}}_calcPixelSize(t,e){for(var i=0,s=0;s<t.length;s++)i+=t[s].getSize()>0?t[s].getSize():0;for(var a=0===e?0:e/i,r=0;r<t.length;r++){var n=t[r];n.__pxSize=n.getSize()*a}}_squarify(t,e,i,s,a){if(null!=t&&0!==t.length)for(;t.length>0;){var r=t.pop();if(r.__pxSize<0)return void this._layoutRow(e,i,s);e.push(r);var n=this._getWorst(e,i);if(n>a)return t.push(r),e.pop(),s=this._layoutRow(e,i,s),void this._squarify(t,[],Math.min(s.w,s.h),s,1/0);if(0===t.length)return void this._layoutRow(e,i,s);a=n}else this._layoutRow(e,i,s)}_getWorst(t,e){for(var i=0,s=1/0,a=-1/0,r=0;r<t.length;r++)i+=t[r].__pxSize,s=Math.min(s,t[r].__pxSize),a=Math.max(a,t[r].__pxSize);var n=i*i,h=e*e;return Math.max(h*a/n,n/(h*s))}_layoutRow(t,i,s){var a,r=0;for(a=0;a<t.length;a++)r+=t[a].__pxSize;var n,h,o=s.x,l=s.y;if(i===s.w){for(h=0===i?0:r/i,a=0;a<t.length;a++)n=t[a].__pxSize/h,this._layout(t[a],o,l,n,h,!1),o+=n;return new e.Rectangle(s.x,s.y+h,s.w,s.h-h)}for(n=0===i?0:r/i,a=0;a<t.length;a++)h=t[a].__pxSize/n,this._layout(t[a],o,l,n,h,!1),l+=h;return new e.Rectangle(s.x+n,s.y,s.w-n,s.h)}}t.Sunburst=class extends b{constructor(t,e,i){super(t,e,i),this.Defaults=new T(t),this._angleExtent=2*Math.PI,this.setId("sunburst"),this._ROTATION_SHAPE_RADIUS=15,this._ROTATION_SHAPE_RADIUS_TOUCH=60,this._BUFFER_SPACE=3,this._MIN_BUFFER_SPACE=2}ApplyParsedProps(t){super.ApplyParsedProps(t);var i=this.getOptions();"ie"===e.Agent.browser||"edge"===e.Agent.browser?this._rotateCursor="url("+i._resources.rotateCursor+"), auto":this._rotateCursor="url("+i._resources.rotateCursor+") 8 8, auto",this._startAngle=(360-i.startAngle)*g.TWO_PI/360,this._startAngle>Math.PI&&(this._startAngle-=g.TWO_PI),"auto"===i.animationOnDisplay&&(i.animationOnDisplay="fan")}Layout(t){var e=Math.max(Math.ceil(this._BUFFER_SPACE*Math.min(t.w,t.h)/400),this._MIN_BUFFER_SPACE);t.x+=e,t.y+=e,t.w-=2*e,t.h-=2*e,this.LayoutBreadcrumbs(t),this.LayoutLegend(t),this._totalRadius=Math.floor(Math.min(t.w,t.h)/2),this._root&&x.layout(this._totalRadius,this._root,this._startAngle,this._angleExtent,this.getOptions().sorting)}Render(t,i){if(this.RenderBackground(t),this.RenderBreadcrumbs(t),this.RenderLegend(t),this._translatePt=new e.Point(i.x+i.w/2,i.y+i.h/2),this.__isRotationEnabled()&&this.HasValidData()){var a=e.Agent.isTouchDevice()?this._ROTATION_SHAPE_RADIUS_TOUCH:this._ROTATION_SHAPE_RADIUS,r=new e.Circle(this.getCtx(),i.x+i.w/2,i.y+i.h/2,this._totalRadius+a);r.setInvisibleFill(),r.setCursor(this._rotateCursor),t.addChild(r),this.getEventManager().associate(r,new s(null,y.ROTATION_ID))}var n=new e.Container(this.getCtx());if(n.setTranslate(this._translatePt.x,this._translatePt.y),t.addChild(n),this.HasValidData()){var h=new e.Container(this.getCtx());n.addChild(h),this._root.render(h),this.UpdateAriaNavigation(this._root),this._selectedLayer=new e.Container(this.getCtx()),n.addChild(this._selectedLayer),this._hoverLayer=new e.Container(this.getCtx()),n.addChild(this._hoverLayer)}else this.RenderEmptyText(t)}CreateEventManager(t,e,i,s){return new y(t,e,i,s)}GetDisplayAnim(t,i){if("fan"===this.getOptions().animationOnDisplay&&this.HasValidData()){this._animateAngleExtent(0);var s=new e.CustomAnimation(this.getCtx(),this,this.AnimationDuration);return s.getAnimator().addProp(e.Animator.TYPE_NUMBER,this,this.__getAngleExtent,this._animateAngleExtent,2*Math.PI),s}return super.GetDisplayAnim(t,i)}GetDeleteContainer(){var t=super.GetDeleteContainer();return t&&t.setTranslate(this._translatePt.x,this._translatePt.y),t}OnAnimationEnd(){if(!this.AnimationStopped){this._container.removeChildren();var t=new e.Rectangle(0,0,this.Width,this.Height);this.Layout(t),this.Render(this._container,t);for(var i=this._selectionHandler?this._selectionHandler.getSelection():[],s=0;s<i.length;s++)i[s].setSelected(!0)}this._angleExtent<2*Math.PI&&this._animateAngleExtent(2*Math.PI),super.OnAnimationEnd()}__moveToHoverLayer(t){this._hoverLayer.addChild(t)}__moveToSelectedLayer(t){this._selectedLayer.addChild(t),"safari"!==e.Agent.browser&&"firefox"!==e.Agent.browser&&(this._selectedLayer.removeAllDrawEffects(),this._selectedLayer.addDrawEffect(i.__NODE_SELECTED_SHADOW))}__getAngleExtent(){return this._angleExtent}_animateAngleExtent(t){this._angleExtent=t;var i=new e.Rectangle(0,0,this.Width,this.Height);this.Layout(i),this._root&&this._root.updateShapes(!0)}__startRotation(t,e){this.__setRotationAnchor(this._calcAngle(t,e))}__setRotationAnchor(t){this._currentAngle=t,this._rotationMask=new e.Rect(this.getCtx(),0,0,this.Width,this.Height),this._rotationMask.setInvisibleFill(),this._rotationMask.setCursor(this._rotateCursor),this.addChild(this._rotationMask),this.getEventManager().associate(this._rotationMask,new s(null,y.ROTATION_ID))}__continueRotation(t,e){this.__rotate(this._calcAngle(t,e))}__rotate(t){var i=t-this._currentAngle;this._currentAngle=t,this._updateStartAngle(i);var s=360-Math.round(180*this._startAngle/Math.PI);this.dispatchEvent(e.EventFactory.newSunburstRotationEvent(s,!1))}__endRotation(){this._currentAngle=null,this.removeChild(this._rotationMask),this._rotationMask=null;var t=360-Math.round(180*this._startAngle/Math.PI);this.dispatchEvent(e.EventFactory.newSunburstRotationEvent(t,!1)),this.dispatchEvent(e.EventFactory.newSunburstRotationEvent(t,!0))}SetOptions(t){super.SetOptions(t),this.Options.expanded instanceof Array&&(this.Options._expandedNodes=e.ArrayUtils.createBooleanMap(this.Options.expanded))}expandCollapseNode(t){var s=this.getRootNode(),r=!i.getNodeById(s,t).isDisclosed(),n=this.getOptions().expanded;if("all"===n){for(var h=a.getAllNodes(this._root),o=0;o<h.length;o++)h[o]=h[o].getId();n=h}if(n instanceof Array)if(r)n.push(t);else{var l=n.indexOf(t);l>-1&&n.splice(l,1)}else n.has&&(n=r?n.add([t]):n.delete([t]));var _=a.findRootAndAncestors(this.getCtx(),this.getOptions()._nodes,t,[]).root;this.dispatchEvent(new e.EventFactory.newExpandCollapseEvent(r?"expand":"collapse",t,_,this.getOptions()._widgetConstructor,n)),this.__setNavigableIdToFocus(t)}_calcAngle(t,e){return Math.atan2(e-this._translatePt.y,t-this._translatePt.x)}_updateStartAngle(t){this._startAngle+=t,this._startAngle<-Math.PI?this._startAngle+=2*Math.PI:this._startAngle>Math.PI&&(this._startAngle-=2*Math.PI);var i=new e.Rectangle(0,0,this.Width,this.Height);this.Layout(i),this._root&&this._root.updateShapes(!0)}__getNodeUnderPoint(t,e){return this._root.getNodeUnderPoint(t-this._translatePt.x,e-this._translatePt.y)}__showDropSiteFeedback(t){var e=super.__showDropSiteFeedback(t);return e&&e.setTranslate(this._translatePt.x,this._translatePt.y),e}__isRotationEnabled(){return"off"!==this.getOptions().rotation}CreateNode(t){return new g(this,t)}getCenterPoint(){return this._translatePt}},t.Treemap=class extends b{constructor(t,e,i){super(t,e,i),this.Defaults=new O(t),this._nodeContent={},this.setId("treemap1000"+Math.floor(1e9*Math.random())),this._MIN_BUFFER_SPACE=1}ApplyParsedProps(t){super.ApplyParsedProps(t);var e=this.getOptions();"sliceAndDiceHorizontal"===e.layout?this._layout=new I(!0):"sliceAndDiceVertical"===e.layout?this._layout=new I(!1):this._layout=new m,this._isolatedNodes=[],this._processInitialIsolate(e.isolatedNode),"auto"===e.animationOnDisplay&&(e.animationOnDisplay="alphaFade")}Layout(t){var e=this._MIN_BUFFER_SPACE;e=Math.max(Math.ceil(e*Math.min(t.w,t.h)/400),this._MIN_BUFFER_SPACE),t.x+=e,t.y+=e,t.w-=2*e,t.h-=2*e;var i=this._layout.getGapSize(this,1);t.x+=i,t.w-=2*i,this.LayoutBreadcrumbs(t),this.LayoutLegend(t),t.x-=i,t.w+=2*i;var s=this._isolatedNodes.length;if(s>0&&this._isolateRestoreLayout){var a=this._isolatedNodes[s-1];this._layout.layout(this,a,t.x,t.y,t.w,t.h,!0)}else{this._root&&this._layout.layout(this,this._root,t.x,t.y,t.w,t.h,!1);for(var r=0;r<s;r++){var n=this._isolatedNodes[r];this._layout.layout(this,n,t.x,t.y,t.w,t.h,!0)}}}Render(t){if(this.RenderBackground(t),this.RenderBreadcrumbs(t),this.RenderLegend(t),this.HasValidData()){this._groupTextLayer=new e.Container(this.getCtx()),t.addChild(this._groupTextLayer),this._isolatedNode?this._isolatedNode.render(t):this._root.hasChildren()?(this._root.renderChildren(t),this.UpdateAriaNavigation(this._root)):this._root.render(t),this._isolatedLayer=new e.Container(this.getCtx()),t.addChild(this._isolatedLayer),this._selectedLayer=new e.Container(this.getCtx()),t.addChild(this._selectedLayer),t.addChild(this._groupTextLayer),this._hoverEffect=new e.Rect(this.getCtx(),0,0,0,0),this._hoverEffect.setVisible(!1),this._hoverEffect.setMouseEnabled(!1),this._hoverEffect.setPixelHinting(!0),this._hoverEffect.setInvisibleFill(),t.addChild(this._hoverEffect);for(var i=0;i<this._isolatedNodes.length;i++){var s=this._isolatedNodes[i].getDisplayable();this._isolatedLayer.addChild(s)}}else this.RenderEmptyText(t)}OnAnimationEnd(){if(!this.AnimationStopped){this._container.removeChildren();var t=new e.Rectangle(0,0,this.Width,this.Height);this.Layout(t),this.Render(this._container),this.ReselectNodes()}super.OnAnimationEnd()}ReselectNodes(){for(var t=this._selectionHandler?this._selectionHandler.getSelection():[],e=0;e<t.length;e++)if(this._isolatedNodes.length>0){var i=this._isolatedNodes[this._isolatedNodes.length-1];(t[e]===i||t[e].isDescendantOf(i))&&t[e].setSelected(!0)}else t[e].setSelected(!0)}CreateKeyboardHandler(t){return new R(t)}CreateEventManager(t,e,i,s){return new f(t,e,i,s)}GetInitialFocusedItem(t){var e=this.__getLastIsolatedNode();return e?this.__getDefaultNavigable(a.getLeafNodes(e)):t?this.__getDefaultNavigable(a.getLeafNodes(t)):null}__showHoverEffect(t,e,i,s,a){this._hoverEffect.setX(t).setY(e).setWidth(i).setHeight(s),this._hoverEffect.setStroke(a),this._hoverEffect.setVisible(!0)}__hideHoverEffect(){this._hoverEffect.setVisible(!1)}__getGroupTextLayer(){return this._groupTextLayer}__moveToSelectedLayer(t){for(var e=0,i=this._selectedLayer.getNumChildren(),s=0;s<i;s++){var a=this._selectedLayer.getChildAt(s);t.zIndex>a.zIndex&&(e=s+1)}e<i?this._selectedLayer.addChildAt(t,e):this._selectedLayer.addChild(t)}__getNodeUnderPoint(t,e){return this._isolatedNodes.length>0?this._isolatedNodes[this._isolatedNodes.length-1].getNodeUnderPoint(t,e):this._root.getNodeUnderPoint(t,e)}__isolate(t){var i=this.getEventManager().getFocus();i&&i.hideKeyboardFocusEffect(),this._isolatedNodes.push(t),this.getOptions().isolatedNode=t.getId(),this.dispatchEvent(e.EventFactory.newTreemapIsolateEvent(t.getId())),this._isolateRestoreLayout=!0,this.Layout(new e.Rectangle(0,0,this.Width,this.Height)),this._isolateRestoreLayout=!1;var s=t.getDisplayable();this._isolatedLayer.addChild(s),this._renderIsolateRestore(t)}__restore(){this._restoreNode=this._isolatedNodes.pop(),this.getOptions().isolatedNode=this._isolatedNodes.length>0?this._isolatedNodes[this._isolatedNodes.length-1].getId():null;var t=this.getEventManager().getFocus();t&&t.hideKeyboardFocusEffect(),this.__setNavigableIdToFocus(this._restoreNode.getId()),this.dispatchEvent(e.EventFactory.newTreemapIsolateEvent()),this._isolateRestoreLayout=!0,this.Layout(new e.Rectangle(0,0,this.Width,this.Height)),this._isolateRestoreLayout=!1,this._renderIsolateRestore(this._restoreNode),this._restoreNode=null}__getLastIsolatedNode(){return this._isolatedNodes&&this._isolatedNodes.length>0?this._isolatedNodes[this._isolatedNodes.length-1]:null}_renderIsolateRestore(t){if("none"!==this.getOptions().animationOnDataChange){for(var i=this._selectionHandler?this._selectionHandler.getSelection():[],s=0;s<i.length;s++)i[s].setSelected(!1);var a=t.getIsolateAnimation();this.Animation=new e.ParallelPlayable(this.getCtx(),a),this.Animation.setOnEnd(this.OnAnimationEnd,this),this.getEventManager().removeListeners(this),this.Animation.play()}else this.render(null,this.Width,this.Height,!0)}_processInitialIsolate(t){if(t&&this._root){var i=this._root.getDescendantNodes();i.push(this._root);for(var s=0;s<i.length;s++)if(e.Obj.compareValues(this.getCtx(),i[s].getId(),t))return void this._isolatedNodes.push(i[s])}}__getDefaultNavigable(t){var e=this.getEventManager().getKeyboardHandler();return e?e.getDefaultNavigable(t):t&&t.length>0?t[0]:null}CreateNode(t){return new u(this,t)}getIsolatedNodes(){return this._isolatedNodes}getNodeContent(){return this._nodeContent}},Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ojdvt-treeview.js.map