/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","ojs/ojthemeutils"],function(t,e){"use strict";const i=function(){};i._GET_FUNCTION_NAME_REGEXP=/function\s+([\S^]+)\s*\(/,i.createSubclass=function(t,e){var n=i._tempSubclassConstructor;n.prototype=e.prototype,t.prototype=new n,t.prototype.constructor=t,t.superclass=e.prototype},i._tempSubclassConstructor=function(){},i.prototype.clone=function(){return null},i.createCallback=function(t,e){return function(){return e.apply(t,arguments)}},i.compareValues=function(t,e,i){return t.oj.KeyUtils.equals(e,i)};const n=function(t,e){this.x=null===t||isNaN(t)?0:t,this.y=null===e||isNaN(e)?0:e};n.prototype.equals=function(t){return t instanceof n&&this.x===t.x&&this.y===t.y};const r=function(){};var o;r.setAgentInfo=function(t){o=t},r.getAgentInfo=function(){return o},Object.defineProperty(r,"browser",{enumerable:!0,get:function(){return r.getAgentInfo().browser}}),Object.defineProperty(r,"engine",{enumerable:!0,get:function(){return r.getAgentInfo().engine}}),Object.defineProperty(r,"version",{enumerable:!0,get:function(){return r.getAgentInfo().browserVersion}}),Object.defineProperty(r,"os",{enumerable:!0,get:function(){return r.getAgentInfo().os.toLowerCase()}}),i.createSubclass(r,i),r.FOCUS_COLOR_DEFAULT="#0645AD",r.FOCUS_COLOR_IE="#090909",r.deferAriaCreation=function(){return!r.isTouchDevice()&&!r.isEnvironmentTest()},r.getDevicePixelRatio=function(){return r._initialize(),r._devicePixelRatio},r.getElementPosition=function(t){return"ie"===r.browser||"edge"===r.browser?r._getElementPositionIE(t):r._getElementPositionDefault(t)},r.isRightToLeft=function(t){return r._initialize(),t&&null!=t.getReadingDirection()?"rtl"==t.getReadingDirection():r._bRtl},r.isTouchDevice=function(){return r._initialize(),r._bTouchDevice},r.setEnvironment=function(t){r._environment=t},r.isEnvironmentTest=function(){return"test"==r._environment},r.setHighContrast=function(t){r._highContrast=t},r.isHighContrast=function(){return!0===r._highContrast},r.workaroundFirefoxRepaint=function(t){if("firefox"===r.browser){var e=t.getParent();if(e){var i=e.getChildIndex(t);e.removeChildAt(i),e.addChildAt(t,i)}}},r._initialize=function(){r._bInitialized||(r._bRtl=!(!document||!document.documentElement)&&"rtl"==document.documentElement.dir,r._bTouchDevice="ios"===r.os||"android"===r.os,r._devicePixelRatio=window&&null!=window.devicePixelRatio?window.devicePixelRatio:1,r._bInitialized=!0)},r._getElementPositionDefault=function(t){var e=t.getBoundingClientRect(),i=Math.round(e.top),r=e.left,o=t.ownerDocument.documentElement,s=t.ownerDocument.body;return r+=o.scrollLeft||s.scrollLeft,i+=o.scrollTop||s.scrollTop,new n(r,i)},r._getElementPositionIE=function(t){var e=t.getBoundingClientRect(),i=e.top,r=e.left,o=t.ownerDocument.documentElement,s=o.scrollLeft;return r-=o.clientLeft-s,i-=o.clientTop-o.scrollTop,new n(r,i)},r.getFocusColor=function(){if(r._initialize(),!r._focusColor){var t;if("blink"===r.engine||"safari"===r.browser){var e=document.getElementsByTagName("body")[0],i=document.createElement("div");e.appendChild(i),i.style.outline="-webkit-focus-ring-color",t=window.getComputedStyle(i).getPropertyValue("outline-color"),e.removeChild(i)}else"ie"!==r.browser&&"edge"!==r.browser||(t=r.FOCUS_COLOR_IE);r._focusColor=t||r.FOCUS_COLOR_DEFAULT}return r._focusColor};const s={};i.createSubclass(s,i),s.getDragFeedbackBounds=function(t,e){if(!t)return null;var i=null;if(t instanceof Array){if(t.length>0){i=t[0].getDimensions(e||t[0].getParent());for(var n=1;n<t.length;n++){var r=t[n],o=r.getDimensions(e||r.getParent());o.x<i.x&&(i.w+=i.x-o.x,i.x=o.x),o.y<i.y&&(i.h+=i.y-o.y,i.y=o.y),o.x+o.w>i.x+i.w&&(i.w=o.x+o.w-i.x),o.y+o.h>i.y+i.h&&(i.h=o.y+o.h-i.y)}}}else i=t.getDimensions(e||t.getParent());return i};const a=function(t){this.Init(t)};i.createSubclass(a,i),a.DRAG_FEEDBACK_MARGIN=2,a.prototype.Init=function(t){this._context=t,this._dragCandidate=null,this._dragObj=null,this._dragCoords=null},a.prototype.getDragCandidate=function(){return this._dragCandidate},a.prototype.setDragCandidate=function(t){t&&t.isDragAvailable&&t.getDragTransferable?this._dragCandidate=t:this._dragCandidate=null},a.prototype.isDragAvailable=function(t){return null!=this._dragCandidate?this._dragCandidate.isDragAvailable(t):null},a.prototype.getDragTransferable=function(t,e){return this._dragCandidate?(this._dragObj=this._dragCandidate,this._dragCoords={x:t,y:e},this._dragCandidate.getDragTransferable(t,e)):null},a.prototype.getDragOverFeedback=function(t,e){this._context.getTooltipManager().hideTooltip();var i=this.getDragObject();return i&&i.getDragFeedback?i.getDragFeedback(t,e):null},a.prototype.getDragContext=function(t,e){return this._dragObj&&this._dragObj.getDragContext?this._dragObj.getDragContext(t,e):null},a.prototype.getDragObject=function(){return this._dragObj},a.prototype.getDragCoords=function(){return this._dragCoords},a.prototype.getDragOffset=function(t,e){var i={},n=this.getDragOverFeedback(t,e);if(n){var r=s.getDragFeedbackBounds(n,this._context.getStage()),o=this.getDragObject();o&&o.afterDragOverFeedback&&o.afterDragOverFeedback(n),r&&(i.x=t-r.x,i.y=e-r.y,i.x+=a.DRAG_FEEDBACK_MARGIN,i.y+=a.DRAG_FEEDBACK_MARGIN)}else i.x=0,i.y=0;return i},a.prototype.getPointerOffset=function(t,e){return{x:0,y:0}},a.prototype.initiateDrag=function(){var t=this.getTouchManager();r.isTouchDevice()&&t&&t.cancelTouchHold()},a.prototype.dragDropEnd=function(){this._dragCandidate=null,this._dragObj=null,this._dragCoords=null},a.prototype.setTouchManager=function(t){this._touchManager=t},a.prototype.getTouchManager=function(){return this._touchManager};const h=function(t,e){this.w=null===t||isNaN(t)?0:t,this.h=null===e||isNaN(e)?0:e},l=function(t,e,i,n,r,o){this._a=null==t?1:t,this._b=null==e?0:e,this._c=null==i?0:i,this._d=null==n?1:n,this._tx=null==r?0:r,this._ty=null==o?0:o,this._u=0,this._v=0,this._w=1};i.createSubclass(l,i),l._DECOMP_TX=0,l._DECOMP_TY=1,l._DECOMP_R=2,l._DECOMP_SKEWX=3,l._DECOMP_SX=4,l._DECOMP_SY=5,l.prototype.getA=function(){return this._a},l.prototype.getB=function(){return this._b},l.prototype.getC=function(){return this._c},l.prototype.getD=function(){return this._d},l.prototype.getTx=function(){return this._tx},l.prototype.getTy=function(){return this._ty},l.prototype.concat=function(t){var e=this._a*t.getA()+this._c*t.getB()+this._u*t.getTx(),i=this._b*t.getA()+this._d*t.getB()+this._v*t.getTx(),n=this._tx*t.getA()+this._ty*t.getB()+this._w*t.getTx(),r=this._a*t.getC()+this._c*t.getD()+this._u*t.getTy(),o=this._b*t.getC()+this._d*t.getD()+this._v*t.getTy(),s=this._tx*t.getC()+this._ty*t.getD()+this._w*t.getTy();return new l(e,i,r,o,n,s)},l.prototype.translate=function(t,e){return this.concat(new l(1,0,0,1,t,e))},l.prototype.scale=function(t,e,i,n){var r=this;(i||n)&&(r=this.translate(-i,-n));var o=new l(t,0,0,e);return r=r.concat(o),(i||n)&&(r=r.translate(i,n)),r},l.prototype.rotate=function(t){var e=Math.cos(t),i=Math.sin(t),n=new l(e,-i,i,e);return this.concat(n)},l.prototype.skew=function(t,e){var i=new l(1,Math.tan(t),Math.tan(e),1);return this.concat(i)},l.prototype._determinant=function(){return this._a*(this._d*this._w-this._ty*this._v)-this._b*(this._c*this._w-this._ty*this._u)+this._tx*(this._c*this._v-this._d*this._u)},l.prototype.invert=function(){var t=this._determinant(),e=this._d*this._w-this._ty*this._v,i=this._tx*this._v-this._b*this._w,n=this._b*this._ty-this._tx*this._d,r=this._ty*this._u-this._c*this._w,o=this._a*this._w-this._tx*this._u,s=this._tx*this._c-this._a*this._ty;return new l(e/t,i/t,r/t,o/t,n/t,s/t)},l.prototype._decompose=function(){var t=this._a,e=this._b,i=this._c,n=this._d,r=this._tx,o=this._ty;if(t*n-e*i==0)return null;var s=Math.sqrt(t*t+i*i),a=(t/=s)*e+(i/=s)*n;e-=t*a,n-=i*a;var h=Math.sqrt(e*e+n*n);return a/=h,-1===t*(n/=h)-(e/=h)*i&&(a=-a,h=-h),[r,o,Math.atan2(i,t),Math.atan(a),s,h]},l.prototype._recompose=function(t){var e=new l,i=t[0],n=t[1],r=t[2],o=t[3],s=t[4],a=t[5];return(e=(e=(e=e.scale(s,a)).skew(o,0)).rotate(r)).translate(i,n)},l.prototype.equals=function(t){return!(!this&&t)&&(!(this&&!t)&&(!this&&!t||this._a===t.getA()&&this._b===t.getB()&&this._c===t.getC()&&this._d===t.getD()&&this._tx===t.getTx()&&this._ty===t.getTy()))},l.prototype.transformPoint=function(t){var e=this._a*t.x+this._b*t.y+1*this._tx,i=this._c*t.x+this._d*t.y+1*this._ty;return new n(e,i)},l.prototype.isIdentity=function(){return 1===this._a&&0===this._b&&0===this._c&&1===this._d&&0===this._tx&&0===this._ty};const u={};i.createSubclass(u,i),u.SVG_NS="http://www.w3.org/2000/svg",u.XLINK_NS="http://www.w3.org/1999/xlink",u._IMAGE_URL_CACHE={},u._ICON_CACHE={},u.createSvgDocument=function(t){var e=document.createElementNS(u.SVG_NS,"svg");return null!=t&&u.setAttrNullNS(e,"id",t),u.setAttrNullNS(e,"width","100%"),u.setAttrNullNS(e,"height","100%"),"ie"!==r.browser&&"edge"!==r.browser||u.setAttrNullNS(e,"focusable","false"),e},u.getDragFeedback=function(t,e){var i=new Object;if(!t)return i.width=1,i.height=1,i.svg=u.createSvgDocument("dnd"),i;t instanceof Array||(t=[t]);var n=s.getDragFeedbackBounds(t,e),r=u._getDragFeedbackSVG(t,n);return i.width=n.w+2*a.DRAG_FEEDBACK_MARGIN,i.height=n.h+2*a.DRAG_FEEDBACK_MARGIN,r&&(i.svg=r),i},u._getDragFeedbackSVG=function(t,e){var i=u.createSvgDocument("dnd");u.setAttrNullNS(i,"class","oj-drag");var n="translate("+(a.DRAG_FEEDBACK_MARGIN-e.x)+","+(a.DRAG_FEEDBACK_MARGIN-e.y)+")",r=document.createElementNS(u.SVG_NS,"g");u.setAttrNullNS(r,"transform",n),u.appendChildElem(i,r);for(var o=0;o<t.length;o++){var s=t[o],h=s.getElem().cloneNode(!0);u.getAttrNullNS(h,"filter")&&u.setAttrNullNS(h,"filter",null);var l=document.createElementNS(u.SVG_NS,"g");u.appendChildElem(r,l);for(var c=s.getPathToStage(),_=null,p=1;p<c.length;p++)_=_?_.concat(c[p].getMatrix()):c[p].getMatrix();if(_){var d="matrix("+_.getA()+","+_.getC()+","+_.getB()+","+_.getD()+","+_.getTx()+","+_.getTy()+")";u.setAttrNullNS(l,"transform",d)}u.appendChildElem(l,h)}return i},u.addDomEventListener=function(t,e,i,n){t&&t.addEventListener&&t.addEventListener(e,i,n)},u.removeDomEventListener=function(t,e,i,n){t&&t.removeEventListener&&t.removeEventListener(e,i,n)},u.appendChildElem=function(t,e){return t.appendChild(e)},u.removeChildElem=function(t,e){return e.parentNode!=t?null:t.removeChild(e)},u.getAttrNullNS=function(t,e){return t.getAttribute(e)},u.hasAttrNullNS=function(t,e){return t.hasAttribute(e)},u.setAttrNullNS=function(t,e,i,n){null==n||i!=n?t.setAttribute(e,i):u.hasAttrNullNS(t,e)&&u.removeAttrNullNS(t,e)},u.removeAttrNullNS=function(t,e){u.hasAttrNullNS(t,e)&&t.removeAttribute(e)},u.setHref=function(t,e){"safari"===r.browser||"firefox"===r.browser&&r.version<51?t.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",e):u.setAttrNullNS(t,"href",e)},u.getLinkCallback=function(t,e){if(t||e){var i=this;return function(){if(null==t)i.location=e;else{var n=window.open(e,t);n&&n.focus()}}}return null},u.getUrlPathById=function(t){return(("ie"===r.browser||"edge"===r.browser?null!=document.querySelector("base"):document.URL!=document.baseURI)?document.URL.split("#")[0]+"#":"#")+t},u.getUrlById=function(t){return"url("+u.getUrlPathById(t)+")"},u.setSvgSize=function(t,e,i){var n=t.getSvgDocument();u.setAttrNullNS(n,"width",e+"px"),u.setAttrNullNS(n,"height",i+"px")},u.getOuterDivSize=function(t){var e=t.getSvgDocument().parentNode,i=window.getComputedStyle(e);return new h(parseFloat(i.width),parseFloat(i.height))},u.getEventForSyntax=function(t,e){var i=e.getNativeEvent();if(!t.isCustomElement()&&"undefined"!=typeof $){var n=$.event.fix(i);return n.dataTransfer=i.dataTransfer,n}return i},u.getImageUrl=function(t,e){return null==e||-1!==e.indexOf(".")?e:u.getImageUrls(t,[e])[e]},u.getImageUrls=function(t,e){if(0==e.length)return{};var i={},n=document.createElement("div");n.style.display="none";for(var r=0;r<e.length;r++){var o,s,a=e[r];null!=a&&(-1===a.indexOf(".")?null==(o=u._IMAGE_URL_CACHE[a])?((s=document.createElement("div")).className=a,u.appendChildElem(n,s)):i[a]=o:i[a]=a)}return n.hasChildNodes()?(u.appendChildElem(t.getContainer(),n),Array.prototype.forEach.call(n.childNodes,function(t){var e=t.className,n=window.getComputedStyle(t).getPropertyValue("background-image");n=n&&-1!==n.indexOf("url(")?n.slice(n.indexOf("url(")+4,n.length-1).replace(/["']/g,""):e,i[e]=n,u._IMAGE_URL_CACHE[e]=n}),u.removeChildElem(t.getContainer(),n),i):i},u.getIconStyle=function(t,e){return u.getIconStyles(t,[e])[e]},u.getIconStyles=function(t,e){if(0==e.length)return{};var i={},n=document.createElement("div"),r=n.style;r.width="0px",r.height="0px",r.visibility="hidden";for(var o=0;o<e.length;o++){var s,a,h=e[o];null!=h&&(null==(s=u._ICON_CACHE[h])?((a=document.createElement("div")).className=h,u.appendChildElem(n,a)):i[h]=s)}return n.hasChildNodes()?(u.appendChildElem(t.getContainer(),n),Array.prototype.forEach.call(n.childNodes,function(t){var e,n=t.className,r=window.getComputedStyle(t,":before"),o=r.getPropertyValue("content"),s=o.charAt('"'===o.charAt(0)?1:0),a=r.getPropertyValue("transform");if("none"===a)e=new l;else{var h=a.match(/matrix\((.*)\)/)[1].split(", ").map(t=>Number(t));e=new l(...h)}var c={character:s,transform:e};i[n]=c,u._ICON_CACHE[n]=c}),u.removeChildElem(t.getContainer(),n),i):i},u.addClassName=function(t,e){if(t&&e)if(u.hasAttrNullNS(t,"class")){var i=u.getAttrNullNS(t,"class").split(" ");-1==i.indexOf(e)&&(i.push(e),u.setAttrNullNS(t,"class",i.join(" ")))}else u.setAttrNullNS(t,"class",e)},u.removeClassName=function(t,e){if(t&&e&&u.hasAttrNullNS(t,"class")){var i=u.getAttrNullNS(t,"class").split(" "),n=i.indexOf(e);n>=0&&(i.splice(n,1),u.setAttrNullNS(t,"class",i.join(" ")))}},u.getGrabCursor=function(){return"ie"===r.browser?"move":"grab"},u.getGrabbingCursor=function(){return"ie"===r.browser?"move":"grabbing"},u.cleanDragDataContext=function(t){return delete t.componentElement,delete t.component,t},u.getUseCaptureFromOptions=function(t){return null!=t&&("boolean"==typeof t?t:t.capture||!1)};const c=function(t){return r.isTouchDevice()&&"chrome"===r.browser?window.setTimeout(t,1e3/60):window.requestAnimationFrame(t)},_=function(t){r.isTouchDevice()&&"chrome"===r.browser?clearTimeout(t):window.cancelAnimationFrame(t)},p=function(t){this._id=(t?t+"$":"")+"cp"+p._uniqueSeed++,this._regions=[]};i.createSubclass(p,i),p._uniqueSeed=0,p.NONE=0,p.RECT=1,p.PATH=2,p.POLYGON=3,p.CIRCLE=5,p.prototype.getId=function(){return this._id},p.prototype.getRegions=function(t){return this._regions},p.prototype.addRect=function(t,e,i,n,r,o){var s={type:p.RECT,x:t,y:e,w:i,h:n,rx:r,ry:o};this._regions.push(s)},p.prototype.addCircle=function(t,e,i){var n={type:p.CIRCLE,cx:t,cy:e,r:i};this._regions.push(n)},p.prototype.addPolygon=function(t){var e={type:p.POLYGON,points:t};this._regions.push(e)},p.prototype.addPath=function(t){var e={type:p.PATH,d:t};this._regions.push(e)};const d=new Object;i.createSubclass(d,i),d.removeItem=function(t,e){var i=t.indexOf(e);i>-1&&t.splice(i,1)},d.insert=function(t,e,i){if(!Array.isArray(t))return null;if(!Array.isArray(e))return t;var n;if(0===i)n=e.concat(t);else if(i>0&&i<t.length){var r=t.splice(0,i);n=(r=r.concat(e)).concat(t)}else n=t.concat(e);return n},d.equals=function(t,e){if(!t&&e)return!1;if(t&&!e)return!1;if(t||e){if(t.length!=e.length)return!1;for(var i=0;i<=t.length;i++)if(t[i]!==e[i])return!1;return!0}return!0},d.hasAnyMapItem=function(t,e){if(!t||!e)return!1;for(var i=0;i<e.length;i++)if(t[e[i]])return!0;return!1},d.hasAllMapItems=function(t,e){if(!t||!e)return!1;for(var i=0;i<e.length;i++)if(!t[e[i]])return!1;return!0},d.hasAnyItem=function(t,e){return d.hasAnyMapItem(d.createBooleanMap(t),e)},d.hasAllItems=function(t,e){return d.hasAllMapItems(d.createBooleanMap(t),e)},d.createBooleanMap=function(t){if(!t)return null;for(var e={},i=0;i<t.length;i++)e[t[i]]=!0;return e};const g=function(t,e,i,n){this.Init(t,e,i,n)};i.createSubclass(g,i),g.prototype.getAlphas=function(){return this._arAlphas},g.prototype.getBounds=function(){return this._arBounds},g.prototype.getColors=function(){return this._arColors},g.prototype.getStops=function(){return this._arStops},g.prototype.Init=function(t,e,i,n){if(!e&&(e=[],t))for(var r=0;r<t.length;r++)e.push(1);var o=t?t.length-1:0;if(!i){i=[];var s=o>0?1/o:0,a=0;do{i.push(a),a+=s}while(--o>0);i.push(1)}this._arColors=t,this._arAlphas=e,this._arStops=i,this._arBounds=n},g.prototype.equals=function(t){return t instanceof g&&d.equals(this.getColors(),t.getColors())&&d.equals(this.getStops(),t.getStops())&&d.equals(this.getAlphas(),t.getAlphas())&&d.equals(this.getBounds(),t.getBounds())};const f=function(){};i.createSubclass(f,i),f.createElem=function(t,e){var i,n=document.createElementNS(u.SVG_NS,"linearGradient");u.setAttrNullNS(n,"id",e);var r=t.getColors(),o=t.getAlphas(),s=t.getStops(),a=t.getBounds(),h=r.length;for(i=0;i<h;i++){var l=document.createElementNS(u.SVG_NS,"stop");u.setAttrNullNS(l,"offset",100*s[i]+"%");var c=r[i];if(c){var _=o[i];u.setAttrNullNS(l,"stop-color",c),null!=_&&u.setAttrNullNS(l,"stop-opacity",_,1)}u.appendChildElem(n,l)}var p=!a||0==a[0]&&0==a[1]&&0==a[2]&&0==a[3],d=t.getAngle(),g="0%",f="0%",y="100%",v="0%",S=!0;if(p)45===d?(f="100%",y="100%"):90===d?(f="100%",y="0%"):135===d?(g="100%",y="0%",v="100%"):270===d?(y="0%",v="100%"):0!==d&&(d=-d,u.setAttrNullNS(n,"gradientTransform","rotate("+d+" .5 .5)"),S=!1);else{u.setAttrNullNS(n,"gradientUnits","userSpaceOnUse"),g="0",f="0.5",y="1",v="0.5";var T=a[2],E=a[3],m=a[0],b=a[1],C="scale("+T+" "+E+")"+" "+("rotate("+(d=-d)+" .5 .5)");0==m&&0==b||(C="translate("+m+" "+b+")"+" "+C),u.setAttrNullNS(n,"gradientTransform",C)}return S&&(u.setAttrNullNS(n,"x1",g),u.setAttrNullNS(n,"y1",f),u.setAttrNullNS(n,"x2",y),u.setAttrNullNS(n,"y2",v)),n};const y=function(t,e,i,n){this._pattern=t?y._convertPatternValue(t):y.SM_DIAG_UP_LT,this._fillColor=e||"#000000",this._backgroundColor=i||"#ffffff",this._matrix=n};i.createSubclass(y,i),y.SM_DIAG_UP_LT="sDUL",y.LG_DIAG_UP_LT="lDUL",y.SM_DIAG_UP_RT="sDUR",y.LG_DIAG_UP_RT="lDUR",y.SM_CROSSHATCH="sC",y.LG_CROSSHATCH="lC",y.SM_CHECK="sCh",y.LG_CHECK="lCh",y.SM_TRIANGLE_CHECK="sTCh",y.LG_TRIANGLE_CHECK="lTCh",y.SM_DIAMOND_CHECK="sDCh",y.LG_DIAMOND_CHECK="lDCh",y.prototype.getPattern=function(){return this._pattern},y.prototype.getColor=function(){return this._fillColor},y.prototype.getBackgroundColor=function(){return this._backgroundColor},y.prototype.equals=function(t){return t instanceof y&&t.getPattern()==this.getPattern()&&t.getColor()==this.getColor()&&t.getBackgroundColor()==this.getBackgroundColor()},y.prototype.getMatrix=function(){return this._matrix||new l},y._convertPatternValue=function(t){return"smallDiagonalLeft"==t?y.SM_DIAG_UP_LT:"largeDiagonalLeft"==t?y.LG_DIAG_UP_LT:"smallDiagonalRight"==t?y.SM_DIAG_UP_RT:"largeDiagonalRight"==t?y.LG_DIAG_UP_RT:"smallCrosshatch"==t?y.SM_CROSSHATCH:"largeCrosshatch"==t?y.LG_CROSSHATCH:"smallChecker"==t?y.SM_CHECK:"largeChecker"==t?y.LG_CHECK:"smallTriangle"==t?y.SM_TRIANGLE_CHECK:"largeTriangle"==t?y.LG_TRIANGLE_CHECK:"smallDiamond"==t?y.SM_DIAMOND_CHECK:"largeDiamond"==t?y.LG_DIAMOND_CHECK:t};const v=function(t){this.Init(t)};i.createSubclass(v,i),v._TARGET_SIZE=1e3,v._BUFFER_SIZE=.5,v.prototype.Init=function(t){this._targetSize=null!=t?t:v._TARGET_SIZE,this._maxSize=Math.ceil(this._targetSize*(1+v._BUFFER_SIZE)),this._cache={},this._lruArray=[],this._hits=0,this._misses=0},v.prototype.get=function(t){var e=this._cache[t];return null!=e?(this._hits++,e):(this._misses++,null)},v.prototype.put=function(t,e){var i=null!=this._cache[t];if(this._cache[t]=e,i){var n=this._lruArray.indexOf(t);this._lruArray.splice(n,1),this._lruArray.push(t)}else if(this._lruArray.push(t),this._lruArray.length>this._maxSize)for(var r=this._lruArray.splice(0,this._maxSize-this._targetSize),o=0;o<r.length;o++)delete this._cache[r[o]]},v.prototype.toString=function(){var t="Cache Size: "+this._lruArray.length;return t+="\nHits: "+this._hits,t+="\nMisses: "+this._misses,t+="\nHit %: "+Math.round(1e4*this._hits/(this._hits+this._misses))/100};const S=new Object;i.createSubclass(S,i),S.RADS_PER_DEGREE=Math.PI/180,S.DEGREES_PER_RAD=180/Math.PI,S.TWO_PI=2*Math.PI,S.HALF_PI=Math.PI/2,S.QUARTER_PI=Math.PI/4,S.TOLERANCE=.1,S.degreesToRads=function(t){return t*S.RADS_PER_DEGREE},S.radsToDegrees=function(t){return t*S.DEGREES_PER_RAD},S.interpolateNumber=function(t,e,i){return t+i*(e-t)},S.log10=function(t){return Math.log(t)/Math.LN10},S.calculateAngleBetweenTwoVectors=function(t,e,i,n){var r=Math.atan2(n,i)-Math.atan2(e,t);return r<0?r+S.TWO_PI:r};const T={};i.createSubclass(T,i),T._RED=0,T._GREEN=1,T._BLUE=2,T._ALPHA=3,T._RGBA="rgba(",T._RGB="rgb(",T._POUND="#",T._FACTOR=.15,T._names,T._CONTRASTING_TEXT_COLOR_CACHE={},T.getColorFromName=function(t){if(!T._names){var e={aliceblue:"#f0f8ff",antiquewhite:"#faEbd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffE4c4",black:"#000000",blanchedalmond:"#ffEbcd",blue:"#0000ff",blueviolet:"#8a2bE2",brown:"#a52a2a",burlywood:"#dEb887",cadetblue:"#5f9Ea0",chartreuse:"#7fff00",chocolate:"#d2691E",coral:"#ff7f50",cornflowerblue:"#6495Ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#E9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00cEd1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1E90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4","indianred ":"#cd5c5c","indigo ":"#4b0082",ivory:"#fffff0",khaki:"#f0E68c",lavender:"#E6E6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8E6",lightcoral:"#f08080",lightcyan:"#E0ffff",lightgoldenrodyellow:"#fafad2",lightgray:"#d3d3d3",lightgreen:"#90EE90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cEfa",lightslategray:"#778899",lightsteelblue:"#b0c4dE",lightyellow:"#ffffE0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0E6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370db",mediumseagreen:"#3cb371",mediumslateblue:"#7b68EE",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffE4E1",moccasin:"#ffE4b5",navajowhite:"#ffdEad",navy:"#000080",oldlace:"#fdf5E6",olive:"#808000",olivedrab:"#6b8E23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#EEE8aa",palegreen:"#98fb98",paleturquoise:"#afEEEE",palevioletred:"#db7093",papayawhip:"#ffEfd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0E0E6",purple:"#800080",rebeccapurple:"#663399",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169E1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2E8b57",seashell:"#fff5EE",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87cEEb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40E0d0",violet:"#EE82EE",wheat:"#f5dEb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32",transparent:"rgba(255,255,255,0)"};T._names=e}return T._names[t.toLowerCase()]},T._getChannel=function(t,e){var i=e,n=null,r=T.getColorFromName(i);if(r&&(i=r),t===T._ALPHA){if("#"===i.charAt(0))return i.length>7?parseInt(i.substring(1,3),16)/255:1;if("none"===i)return 0}var o,s=i.indexOf("(");return s<0?(o=[],i.length>7?(o[0]=parseInt(i.substr(3,2),16),o[1]=parseInt(i.substr(5,2),16),o[2]=parseInt(i.substr(7,2),16),o[3]=parseInt(i.substr(1,2),16)/255):(o[0]=parseInt(i.substr(1,2),16),o[1]=parseInt(i.substr(3,2),16),o[2]=parseInt(i.substr(5,2),16),o[3]=1),n=o[t]):n=3===(o=i.substring(s+1).match(/[^,|)]+/gm)).length&&t===T._ALPHA?1:parseFloat(o[t]),n},T.getDarker=function(t,e){var i=T.getRed(t),n=T.getGreen(t),r=T.getBlue(t),o=T.getAlpha(t);return e||(e=T._FACTOR),i=Math.max(parseInt(i*(1-e)),0),n=Math.max(parseInt(n*(1-e)),0),r=Math.max(parseInt(r*(1-e)),0),T.makeRGBA(i,n,r,o)},T.getBrighter=function(t,e){var i=T.getAlpha(t),n=T.getRed(t),r=T.getGreen(t),o=T.getBlue(t);e||(e=T._FACTOR);var s=Math.min(n+parseInt((255-n)*e),255),a=Math.min(r+parseInt((255-r)*e),255),h=Math.min(o+parseInt((255-o)*e),255);return T.makeRGBA(s,a,h,i)},T.makeRGB=function(t,e,i){return i=null===i||isNaN(i)?0:i,e=null===e||isNaN(e)?0:e,t=null===t||isNaN(t)?0:t,T._RGB+t+","+e+","+i+")"},T.makeRGBA=function(t,e,i,n){return i=null===i||isNaN(i)?0:Math.round(i),e=null===e||isNaN(e)?0:Math.round(e),t=null===t||isNaN(t)?0:Math.round(t),n=null===n||isNaN(n)?1:n,T._RGBA+t+","+e+","+i+","+n+")"},T.makePound=function(t,e,i){var n=Math.round(t),r=Math.round(e),o=Math.round(i),s=n.toString(16),a=r.toString(16),h=o.toString(16);return"#"+(1===s.length?"0":"")+s+(1===a.length?"0":"")+a+(1===h.length?"0":"")+h},T.getPound=function(t){var e;if("#"===t.charAt(0)){if(t.length<=7)return t;e=T._POUND,e+=t.substring(3,5)+t.substring(5,7)+t.substring(7,9)}else{var i=T.getRed(t),n=T.getGreen(t),r=T.getBlue(t);e=T.makePound(i,n,r)}return e},T.getRGB=function(t){var e,i=T.getColorFromName(t);if(i&&(t=i),"#"===t.charAt(0)){e=T._RGB;var n=t.length;if(n>7)e+=parseInt(t.substring(3,5),16)+","+parseInt(t.substring(5,7),16)+","+parseInt(t.substring(7,9),16);else if(7===n)e+=parseInt(t.substring(1,3),16)+","+parseInt(t.substring(3,5),16)+","+parseInt(t.substr(5),16);else if(4===n){var r=t.substring(1,2);r+=r;var o=t.substring(2,3);o+=o;var s=t.substring(3);s+=s,e+=parseInt(r,16)+","+parseInt(o,16)+","+parseInt(s,16)}else 5===n?e+=parseInt(t.substring(1,3),16)+","+parseInt(t.substring(3,5),16)+",0,1":3===n&&(e+=parseInt(t.substring(1,3),16)+",0,0,1");e+=")"}else if(t.substr(0,5)===T._RGBA){var a=t.lastIndexOf(",");e=T._RGB,e+=t.substring(5,a),e+=")"}else e=t;return e},T.getRGBA=function(t){var e,i=T.getColorFromName(t);if(i&&(t=i),"#"===t.charAt(0)){e=T._RGBA;var n=t.length;if(n>7)e+=parseInt(t.substring(3,5),16)+","+parseInt(t.substring(5,7),16)+","+parseInt(t.substring(7,9),16)+","+parseInt(t.substring(1,3),16)/255;else if(7===n)e+=parseInt(t.substring(1,3),16)+","+parseInt(t.substring(3,5),16)+","+parseInt(t.substr(5),16)+",1";else if(5===n)e+=parseInt(t.substring(1,3),16)+","+parseInt(t.substring(3,5),16)+",0,1";else if(4===n){var r=t.substring(1,2);r+=r;var o=t.substring(2,3);o+=o;var s=t.substring(3);s+=s,e+=parseInt(r,16)+","+parseInt(o,16)+","+parseInt(s,16)+",1"}else 3===n&&(e+=parseInt(t.substring(1,3),16)+",0,0,1");e+=")"}else t.substr(0,4)===T._RGB?(e=T._RGBA,e+=t.substring(4,t.length-1)+",1)"):e=t;return e},T._setChannel=function(t,e,i){if(void 0===t||void 0===i||t<T._RED||t>T._ALPHA)return e;var n,r=T.getColorFromName(e);r&&(e=r);var o,s="#"===e.charAt(0);if(s)(n=[]).push(parseInt(e.substr(1,2),16)),n.push(parseInt(e.substr(3,2),16)),n.push(parseInt(e.substr(5,2),16)),t===T._ALPHA&&(n.push(i),s=!1,o=!0);else{o=e.substr(0,5)===T._RGBA;var a=e.indexOf("("),h=e.indexOf(")");n=e.substring(a+1,h).split(","),o||t!==T._ALPHA||(n.push(i),o=!0)}return n[t]=i,s?T.makePound(n[0],n[1],n[2]):o?T.makeRGBA(n[0],n[1],n[2],n[3]):T.makeRGB(n[0],n[1],n[2])};["Red","Green","Blue","Alpha"].forEach(function(t){T["get"+t]=T._getChannel.bind(null,T["_"+t.toUpperCase()]),T["set"+t]=T._setChannel.bind(null,T["_"+t.toUpperCase()])}),T.rgb2hsl=function(t,e,i){t/=255,e/=255,i/=255;var n,r,o=Math.max(t,e,i),s=Math.min(t,e,i),a=o+s,h=a/2;if(o==s)n=0,r=0;else{var l=o-s;r=h>.5?l/(2-a):l/a,n=o==t?(e-i)/l+(e<i?6:0):o==e?(i-t)/l+2:o==i?(t-e)/l+4:0,n/=6}return{h:360*n,s:r,l:h}},T.hsl2rgb=function(t,e,i){var n,r,o;if(t/=360,0==e)n=r=o=i;else{var s=i<.5?i*(1+e):i+e-i*e,a=2*i-s;n=T._hue2rgb(a,s,t+1/3),r=T._hue2rgb(a,s,t),o=T._hue2rgb(a,s,t-1/3)}return{r:255*n,g:255*r,b:255*o}},T._hue2rgb=function(t,e,i){return i<0?i+=1:i>1&&(i-=1),i<1/6?t+6*(e-t)*i:i<.5?e:i<2/3?t+(e-t)*(2/3-i)*6:t},T.adjustHSL=function(t,e,i,n){T._hslCache||(T._hslCache=new v(100));var r=t+":"+e+":"+i+":"+n,o=T._hslCache.get(r);if(null!=o)return o;var s=T.getRed(t),a=T.getGreen(t),h=T.getBlue(t),l=T.getAlpha(t),u=T.rgb2hsl(s,a,h),c=Math.min(Math.max(0,u.h+e),360),_=Math.min(Math.max(0,u.s+i),1),p=Math.min(Math.max(0,u.l+n),1),d=T.hsl2rgb(c,_,p);return o=1==l?T.makePound(d.r,d.g,d.b):T.makeRGBA(d.r,d.g,d.b,l),T._hslCache.put(r,o),o},T.interpolateColor=function(t,e,i){var n=T.getRed(t),r=T.getGreen(t),o=T.getBlue(t),s=T.getAlpha(t),a=T.getRed(e),h=T.getGreen(e),l=T.getBlue(e),u=T.getAlpha(e),c=Math.round(S.interpolateNumber(n,a,i)),_=Math.round(S.interpolateNumber(r,h,i)),p=Math.round(S.interpolateNumber(o,l,i)),d=S.interpolateNumber(s,u,i);return T.makeRGBA(c,_,p,d)},T.getLuminance=function(t){var e=function(t){var e=t/255;return e<.03928?e/12.92:Math.pow((e+.055)/1.055,2.4)},i=T.getRed(t),n=T.getGreen(t),r=T.getBlue(t);return.2126*e(i)+.7152*e(n)+.0722*e(r)},T.getContrastRatio=function(t,e){return T.getContrastRatioByLuminance(T.getLuminance(t),T.getLuminance(e))},T.getContrastRatioByLuminance=function(t,e){var i=t+.05,n=e+.05;return i>n?i/n:n/i},T.getContrastingTextColor=function(t){if(!T._CONTRASTING_TEXT_COLOR_CACHE[t]){var e=T.getLuminance(t),i=T.getContrastRatioByLuminance(e,1)>T.getContrastRatioByLuminance(e,0)?"#FFFFFF":"#000000";T._CONTRASTING_TEXT_COLOR_CACHE[t]=i}return T._CONTRASTING_TEXT_COLOR_CACHE[t]},T.fixColorForPlatform=function(t,e){if(!t)return null;"#"==t.charAt(0)&&t.length>8&&(t=T.getRGBA(t));var i={};return i.color=t,null!=e&&(i.alpha=e),i};const E={};i.createSubclass(E,i),E.lineLinear=function(t){return t.join("L")},E.lineCardinalClosed=function(t,e){return t.length<3?E.lineLinear(t):t[0]+E.lineHermite((t.push(t[0]),t),E.lineCardinalTangents([t[t.length-2]].concat(t,[t[1]]),e))},E.lineCardinal=function(t,e){return t.length<3?E.lineLinear(t):t[0]+E.lineHermite(t,E.lineCardinalTangents(t,e))},E.lineHermite=function(t,e){if(e.length<1||t.length!=e.length&&t.length!=e.length+2)return E.lineLinear(t);var i=t.length!=e.length,n="",r=t[0],o=t[1],s=e[0],a=s,h=1;if(i&&(n+="Q"+Math.round(o[0]-2*s[0]/3)+","+Math.round(o[1]-2*s[1]/3)+","+Math.round(o[0])+","+Math.round(o[1]),r=t[1],h=2),e.length>1){a=e[1],o=t[h],h++,n+="C"+Math.round(r[0]+s[0])+","+Math.round(r[1]+s[1])+","+Math.round(o[0]-a[0])+","+Math.round(o[1]-a[1])+","+Math.round(o[0])+","+Math.round(o[1]);for(var l=2;l<e.length;l++,h++)o=t[h],a=e[l],n+="S"+Math.round(o[0]-a[0])+","+Math.round(o[1]-a[1])+","+Math.round(o[0])+","+Math.round(o[1])}if(i){var u=t[h];n+="Q"+Math.round(o[0]+2*a[0]/3)+","+Math.round(o[1]+2*a[1]/3)+","+Math.round(u[0])+","+Math.round(u[1])}return n},E.lineCardinalTangents=function(t,e){for(var i,n=[],r=(1-e)/2,o=t[0],s=t[1],a=1,h=t.length;++a<h;)i=o,o=s,s=t[a],n.push([r*(s[0]-i[0]),r*(s[1]-i[1])]);return n},E.lineSlope=function(t,e){return(e[1]-t[1])/(e[0]-t[0])},E.lineFiniteDifferences=function(t){for(var e=0,i=t.length-1,n=[],r=t[0],o=t[1],s=n[0]=E.lineSlope(r,o);++e<i;)n[e]=(s+(s=E.lineSlope(r=o,o=t[e+1])))/2;return n[e]=s,n},E.lineMonotoneTangents=function(t,e){e&&(t=E._rotatePoints(t));for(var i,n,r,o,s=[],a=E.lineFiniteDifferences(t),h=-1,l=t.length-1;++h<l;)i=E.lineSlope(t[h],t[h+1]),Math.abs(i)<1e-6?a[h]=a[h+1]=0:(o=(n=a[h]/i)*n+(r=a[h+1]/i)*r)>9&&(o=3*i/Math.sqrt(o),a[h]=o*n,a[h+1]=o*r);for(h=-1;++h<=l;)o=(t[Math.min(l,h+1)][0]-t[Math.max(0,h-1)][0])/(6*(1+a[h]*a[h])),s.push([o||0,a[h]*o||0]);return e&&(s=E._rotatePoints(s)),s},E.lineMonotone=function(t,e){return t.length<3?E.lineLinear(t):t[0]+E.lineHermite(t,E.lineMonotoneTangents(t,e))},E._rotatePoints=function(t){for(var e=[],i=0;i<t.length;i++)e.push([t[i][1],t[i][0]]);return e};const m=function(t,e,i,n){this.x=null===t||isNaN(t)?0:t,this.y=null===e||isNaN(e)?0:e,this.w=null===i||isNaN(i)?0:i,this.h=null===n||isNaN(n)?0:n};i.createSubclass(m,i),m.create=function(t){return new m(t[0],t[1],t[2],t[3])},m.prototype.containsPoint=function(t,e){return t>=this.x&&t<=this.x+this.w&&e>=this.y&&e<=this.y+this.h},m.prototype.getCenter=function(){return new n(this.x+this.w/2,this.y+this.h/2)},m.prototype.getUnion=function(t){var e=new m;if(t&&0!==t.w&&0!==t.h)if(0!==this.w&&0!==this.h){var i=this.x+this.w,n=this.y+this.h,r=t.x+t.w,o=t.y+t.h,s=Math.min(this.x,t.x),a=Math.min(this.y,t.y);e.w=i<r?r-s:i-s,e.h=n>o?n-a:o-a,e.x=s,e.y=a}else e.x=t.x,e.y=t.y,e.w=t.w,e.h=t.h;else e.x=this.x,e.y=this.y,e.w=this.w,e.h=this.h;return e},m.prototype.getIntersection=function(t){var e=new m;if(!t||0===t.w||0===t.h)return null;if(0===this.w||0===this.h)return null;var i=this.x+this.w,n=this.y+this.h,r=t.x+t.w,o=t.y+t.h,s=Math.max(this.x,t.x),a=Math.max(this.y,t.y);return s>=i||s>=r||a>=n||a>=o?null:(e.w=i<r?i-s:r-s,e.h=n>o?o-a:n-a,e.x=s,e.y=a,e)},m.prototype.intersects=function(t){if(t&&0!==t.w&&0!==t.h&&0!==this.w&&0!==this.h){var e=this.x+this.w,i=this.y+this.h,n=t.x+t.w,r=t.y+t.h;return!(t.x>e||n<this.x||t.y>i||r<this.y)}return!1},m.prototype.clone=function(){return new m(this.x,this.y,this.w,this.h)},m.prototype.equals=function(t){return t instanceof m&&this.x==t.x&&this.y==t.y&&this.w==t.w&&this.h==t.h},m.prototype.toString=function(){return this.x+", "+this.y+", "+this.w+", "+this.h};const b={};i.createSubclass(b,i),b.SPLINE_TYPE_MONOTONE_VERTICAL="mv",b.SPLINE_TYPE_MONOTONE_HORIZONTAL="mh",b.SPLINE_TYPE_CARDINAL_CLOSED="cc",b.SPLINE_TYPE_CARDINAL="c",b.moveTo=function(t,e){return"M"+t+","+e},b.lineTo=function(t,e){return"L"+t+","+e},b.quadTo=function(t,e,i,n){return"Q"+t+","+e+","+i+","+n},b.horizontalLineTo=function(t){return"H"+t},b.verticalLineTo=function(t){return"V"+t},b.cubicTo=function(t,e,i,n,r,o){return"C"+t+","+e+","+i+","+n+","+r+","+o},b.arcTo=function(t,e,i,n,r,o){var s="A"+t+","+e+",0,";return i>Math.PI?s+="1,":s+="0,",s+=n+","+r+","+o},b.closePath=function(){return"Z"},b.roundedRectangle=function(t,e,i,n,r,o,s,a){return b._roundedRectangle(t,e,i,n,r,r,o,o,s,s,a,a)},b.rectangleWithBorderRadius=function(t,e,i,n,r,o,s){var a=s,h=s,l=s,u=s,c=s,_=s,p=s,d=s;if(r)if(-1!=r.indexOf("/")){var g=r.split("/"),f=g[0].trim().split(/\s+/),y=g[1].trim().split(/\s+/);1==f.length?a=l=c=p=f[0]:2==f.length?(a=c=f[0],l=p=f[1]):3==f.length?(a=f[0],l=p=f[1],c=f[2]):4==f.length&&(a=f[0],l=f[1],c=f[2],p=f[3]),1==y.length?h=u=_=d=y[0]:2==y.length?(h=_=y[0],u=d=y[1]):3==y.length?(h=y[0],u=d=y[1],_=y[2]):4==y.length&&(h=y[0],u=y[1],_=y[2],d=y[3])}else if("auto"!=r){var v=r.trim().split(/\s+/);1==v.length?a=l=c=p=h=u=_=d=v[0]:2==v.length?(a=c=h=_=v[0],l=p=u=d=v[1]):3==v.length?(a=h=v[0],l=p=u=d=v[1],c=_=v[2]):4==v.length&&(a=h=v[0],l=u=v[1],c=_=v[2],p=d=v[3])}return r&&"0"!=r?b._roundedRectangle(t,e,i,n,b._parseBorderRadiusItem(a,o),b._parseBorderRadiusItem(h,o),b._parseBorderRadiusItem(l,o),b._parseBorderRadiusItem(u,o),b._parseBorderRadiusItem(c,o),b._parseBorderRadiusItem(_,o),b._parseBorderRadiusItem(p,o),b._parseBorderRadiusItem(d,o)):b._rectangle(t,e,i,n)},b._parseBorderRadiusItem=function(t,e){var i=Math.min(parseFloat(t),e/2);return-1!=t.indexOf("%")&&(i=.01*Math.min(50,parseFloat(t))*e),i},b._roundedRectangle=function(t,e,i,n,r,o,s,a,h,l,u,c){return o=Math.min(o,.5*n),a=Math.min(a,.5*n),l=Math.min(l,.5*n),c=Math.min(c,.5*n),r=Math.min(r,.5*i),s=Math.min(s,.5*i),h=Math.min(h,.5*i),u=Math.min(u,.5*i),b.moveTo(t+r,e)+b.lineTo(t+i-s,e)+b.arcTo(s,a,Math.PI/2,1,t+i,e+a)+b.lineTo(t+i,e+n-l)+b.arcTo(h,l,Math.PI/2,1,t+i-h,e+n)+b.lineTo(t+u,e+n)+b.arcTo(u,c,Math.PI/2,1,t,e+n-c)+b.lineTo(t,e+o)+b.arcTo(r,o,Math.PI/2,1,t+r,e)+b.closePath()},b.polyline=function(t,e){if(t.length<2)return"";for(var i=e?b.lineTo(t[0],t[1]):b.moveTo(t[0],t[1]),n=2;n<t.length;n+=2)i+=b.lineTo(t[n],t[n+1]);return i},b.curveThroughPoints=function(t,e,i){if(0==t.length)return"";for(var n=[],r=0;r<t.length;r+=2)n.push([t[r],t[r+1]]);var o=e?"L":"M";return i==b.SPLINE_TYPE_MONOTONE_VERTICAL?o+E.lineMonotone(n,!1):i==b.SPLINE_TYPE_MONOTONE_HORIZONTAL?o+E.lineMonotone(n,!0):i==b.SPLINE_TYPE_CARDINAL_CLOSED?o+E.lineCardinalClosed(n,.7):o+E.lineCardinal(n,.7)},b.createPathArray=function(t){if(!t)return null;var e,i=(t=t.replace(/([0-9])([\-])/g,"$1 $2")).replace(/([mlqhvzcast])/gi,",$1,").split(/[ ,]/g),n=i.length;for(e=0;e<n;e++){var r=i[e];r?isNaN(r)||(i[e]=parseFloat(r)):(i.splice(e,1),e--,n--)}return i},b.getDimensions=function(t){if(!t||!t.length)return new m;var e,i,n,r,o,s,a,h,l,u,c,_,p=t.length,d=!0,g=Number.MAX_VALUE,f=-1*Number.MAX_VALUE,y=Number.MAX_VALUE,v=-1*Number.MAX_VALUE,S=[];for(u=0;u<p;u++){n=!1;var T=0;switch(c=0,t[u]){case"m":n=!0;case"M":do{r=t[u+1],o=t[u+2],d?d=!1:n&&(r+=e,o+=i),e=r,i=o,S[c++]=r,S[c++]=o,T++,u+=2}while(!isNaN(t[u+1]));break;case"c":n=!0;case"C":do{r=t[u+1],o=t[u+2],s=t[u+3],a=t[u+4],h=t[u+5],l=t[u+6],n&&(r+=e,o+=i,s+=e,a+=i,h+=e,l+=i),e=h,i=l,S[c++]=h,S[c++]=l,T++,u+=6}while(!isNaN(t[u+1]));break;case"q":n=!0;case"Q":do{r=t[u+1],o=t[u+2],s=t[u+3],a=t[u+4],n&&(r+=e,o+=i,s+=e,a+=i),e=s,i=a,S[c++]=s,S[c++]=a,T++,u+=4}while(!isNaN(t[u+1]));break;case"l":n=!0;case"L":do{r=t[u+1],o=t[u+2],n&&(r+=e,o+=i),e=r,i=o,S[c++]=r,S[c++]=o,T++,u+=2}while(!isNaN(t[u+1]));break;case"h":n=!0;case"H":do{r=t[u+1],n&&(r+=e),e=r,S[c++]=r,S[c++]=i,T++,u+=1}while(!isNaN(t[u+1]));break;case"v":n=!0;case"V":do{o=t[u+1],n&&(o+=i),i=o,S[c++]=e,S[c++]=o,T++,u+=1}while(!isNaN(t[u+1]));break;case"a":n=!0;case"A":do{var E=t[u+1],C=t[u+2],A=t[u+3],O=t[u+4],I=t[u+5],N=t[u+6],R=t[u+7];n&&(N+=e,R+=i);var D=b._getArcDims(e,i,E,C,A,O,I,N,R);S[c++]=D[0],S[c++]=D[1],S[c++]=D[2],S[c++]=D[3],T+=2,e=N,i=R,u+=7}while(!isNaN(t[u+1]))}for(c=0,_=0;_<T;_++)r=S[c++],o=S[c++],g=Math.min(g,r),f=Math.max(f,r),y=Math.min(y,o),v=Math.max(v,o)}return new m(g,y,Math.abs(f-g),Math.abs(v-y))},b.getPathString=function(t){for(var e="",i=t.length,n=0;n<i;n++)null!=t[n]&&(e+=(n>0?" ":"")+t[n]);return e},b.transformPath=function(t,e,i,n,r){if(t){for(var o,s="",a="",h=0;h<t.length;h++){"string"==typeof t[h]&&(o=(a=t[h])===a.toUpperCase(),s+=a+" ");for(var l=[];h<t.length-1&&"number"==typeof t[h+1];)h++,l.push(t[h]);if("A"===a.toUpperCase())for(var u=0;u<l.length;u+=7)s+=parseFloat(l[u])*n+" ",s+=parseFloat(l[u+1])*r+" ",s+=l[u+2]+" ",s+=l[u+3]+" ",s+=l[u+4]+" ",s+=parseFloat(l[u+5])*n+(o?e:0)+" ",s+=parseFloat(l[u+6])*r+(o?i:0)+" ";else{var c=[],_=[];"H"===a.toUpperCase()?(c.push(n),_.push(o?e:0)):"V"===a.toUpperCase()?(c.push(r),_.push(o?i:0)):(c.push(n),c.push(r),_.push(o?e:0),_.push(o?i:0));for(u=0;u<l.length;u++){var p=c[u%c.length],d=_[u%_.length];s+=parseFloat(l[u])*p+d+" "}}}return s}},b._fitsInScale=function(t,e,i){return Math.abs(t)>i||Math.abs(e)>i},b.simplifyPath=function(t,e){for(var i,n,r="",o="",s=0,a=0,h=0,l=0,u=0,c=0;c<t.length;c++)if(isNaN(t[c]))"Z"!=(i=t[c])&&"z"!=i||(n=i,o+=i,u>0&&(r+=o,h=0,l=0),o="",u=0,s=0,a=0);else switch(i){case"M":h=0,l=0;case"m":o=o+i+(h+=t[c])+" "+(l+=t[c+1]),n=i,c++;break;case"l":s+=t[c],a+=t[c+1],b._fitsInScale(s,a,e)&&(n!=i?(n=i,o+=i):o+=" ",o=o+s+" "+a,s=0,a=0,u++),c++;break;case"h":case"v":"h"==i?s+=t[c]:a+=t[c],b._fitsInScale(s,a,e)&&(0!=s&&0!=a?("l"!=n?(n="l",o+="l"):o+=" ",o=o+s+" "+a):(n=i,o=o+i+("h"==i?s:a)),s=0,a=0,u++)}return r},b._rectangle=function(t,e,i,n){return b.moveTo(t,e)+b.horizontalLineTo(t+i)+b.verticalLineTo(e+n)+b.horizontalLineTo(t)+b.closePath()},b._getArcDims=function(t,e,i,r,o,s,a,h,l){let u=b._convertArc(t,e,i,r,o,s,a,h,l);i=u[2],r=u[3];const c=new n(t,e),_=new n(h,l),p=new n(u[0],u[1]),d=[new n(p.x+i,p.y),new n(p.x,p.y+r),new n(p.x-i,p.y),new n(p.x,p.y-r)];let g=[c,_];const f=b._getClockwiseAngle(c,_),y=0===a?[f,f+Math.PI]:[f+Math.PI,f+2*Math.PI];d.forEach(t=>{var e=b._getClockwiseAngle(c,t);(e>=y[0]&&e<=y[1]||e+2*Math.PI>=y[0]&&e+2*Math.PI<=y[1])&&g.push(t)});const v=g.map(t=>t.x),S=g.map(t=>t.y);return[Math.min(...v),Math.min(...S),Math.max(...v),Math.max(...S)]},b._getClockwiseAngle=function(t,e){var i=Math.atan2(e.y-t.y,e.x-t.x);return i=i<0?i+2*Math.PI:i},b._convertArc=function(t,e,i,n,r,o,s,a,h){var l=(t-a)/2,u=(e-h)/2,c=(r=Math.PI*(r%360)/180,Math.cos(r)),_=Math.sin(r),p=c*l+_*u,d=-_*l+c*u,g=(i=Math.abs(i))*i,f=(n=Math.abs(n))*n,y=p*p,v=d*d,S=y/g+v/f;S>1&&(g=(i=Math.sqrt(S)*i)*i,f=(n=Math.sqrt(S)*n)*n);var T=o==s?-1:1,E=(g*f-g*v-f*y)/(g*v+f*y);E=E<0?0:E;var m,b,C=T*Math.sqrt(E),A=C*(i*d/n),O=C*(-n*p/i),I=(t+a)/2+(c*A-_*O),N=(e+h)/2+(_*A+c*O),R=(p-A)/i,D=(d-O)/n,x=(-p-A)/i,M=(-d-O)/n;b=Math.sqrt(R*R+D*D),m=R;var w=(T=D<0?-1:1)*Math.acos(m/b)*180/Math.PI;b=Math.sqrt((R*R+D*D)*(x*x+M*M)),m=R*x+D*M;var L=(T=R*M-D*x<0?-1:1)*Math.acos(m/b)*180/Math.PI;return!s&&L>0?L-=360:s&&L<0&&(L+=360),[I,N,i,n,w%=360,L%=360,r]};const C=function(){};i.createSubclass(C,i),C._SM_WIDTH=8,C._SM_HEIGHT=8,C._LG_WIDTH=16,C._LG_HEIGHT=16,C.createElem=function(t,e){var i=document.createElementNS(u.SVG_NS,"pattern");u.setAttrNullNS(i,"id",e);var n,r,o=t.getPattern();C.IsSmallPattern(o)?(n=C._SM_WIDTH,r=C._SM_HEIGHT):(n=C._LG_WIDTH,r=C._LG_HEIGHT),u.setAttrNullNS(i,"x",0),u.setAttrNullNS(i,"y",0),u.setAttrNullNS(i,"width",n),u.setAttrNullNS(i,"height",r),u.setAttrNullNS(i,"patternUnits","userSpaceOnUse");var s=t.getMatrix();if(s){var a="matrix("+s.getA()+","+s.getC()+","+s.getB()+","+s.getD()+","+s.getTx()+","+s.getTy()+")";u.setAttrNullNS(i,"patternTransform",a)}return C.CreatePatternElems(t,i),i},C.IsSmallPattern=function(t){return"s"===t.charAt(0)},C.CreatePatternElems=function(t,e){var i,n,r,o,s,a,h;var l=t.getPattern(),c=t.getColor(),_=T.getRGB(c),p=T.getAlpha(c),d=t.getBackgroundColor(),g=T.getRGB(d),f=T.getAlpha(d);C.IsSmallPattern(l)?(i=C._SM_WIDTH,n=C._SM_HEIGHT,r=C._SM_WIDTH,o=C._SM_HEIGHT):(i=C._LG_WIDTH,n=C._LG_HEIGHT,r=C._LG_WIDTH,o=C._LG_HEIGHT),g&&f>0&&(h=document.createElementNS(u.SVG_NS,"rect"),u.setAttrNullNS(h,"stroke",g),u.setAttrNullNS(h,"stroke-opacity",f),u.setAttrNullNS(h,"stroke-width",1),u.setAttrNullNS(h,"fill",g),u.setAttrNullNS(h,"fill-opacity",f),u.setAttrNullNS(h,"x",0),u.setAttrNullNS(h,"y",0),u.setAttrNullNS(h,"width",i),u.setAttrNullNS(h,"height",n),u.appendChildElem(e,h)),l===y.SM_DIAG_UP_LT||l===y.LG_DIAG_UP_LT?(h=document.createElementNS(u.SVG_NS,"path"),u.setAttrNullNS(h,"stroke",_),u.setAttrNullNS(h,"stroke-opacity",p),u.setAttrNullNS(h,"stroke-width",1),u.setAttrNullNS(h,"stroke-linecap","square"),u.setAttrNullNS(h,"d",b.moveTo(0,-o/2)+b.lineTo(3*r/2,o)+b.moveTo(-r/2,0)+b.lineTo(r/2,o)),u.appendChildElem(e,h)):l===y.SM_DIAG_UP_RT||l===y.LG_DIAG_UP_RT?(h=document.createElementNS(u.SVG_NS,"path"),u.setAttrNullNS(h,"stroke",_),u.setAttrNullNS(h,"stroke-opacity",p),u.setAttrNullNS(h,"stroke-width",1),u.setAttrNullNS(h,"stroke-linecap","square"),u.setAttrNullNS(h,"d",b.moveTo(-r/2,o)+b.lineTo(r,-o/2)+b.moveTo(0,3*o/2)+b.lineTo(3*r/2,0)),u.appendChildElem(e,h)):l===y.SM_CROSSHATCH||l===y.LG_CROSSHATCH?(h=document.createElementNS(u.SVG_NS,"path"),u.setAttrNullNS(h,"stroke",_),u.setAttrNullNS(h,"stroke-opacity",p),u.setAttrNullNS(h,"stroke-width",1),u.setAttrNullNS(h,"d","M0,0L"+i+","+n+"M"+i+",0L0,"+n),u.appendChildElem(e,h)):l===y.SM_CHECK||l===y.LG_CHECK?(s=r/2,a=o/2,h=document.createElementNS(u.SVG_NS,"path"),u.setAttrNullNS(h,"stroke",_),u.setAttrNullNS(h,"stroke-opacity",p),u.setAttrNullNS(h,"stroke-width",1),u.setAttrNullNS(h,"fill",_),u.setAttrNullNS(h,"fill-opacity",p),u.setAttrNullNS(h,"d","M"+s+",0L"+r+",0L"+r+","+a+"L"+s+","+a+"ZM0,"+a+"L"+s+","+a+"L"+s+","+o+"L0,"+o+"Z"),u.appendChildElem(e,h)):l===y.SM_TRIANGLE_CHECK||l===y.LG_TRIANGLE_CHECK?(h=document.createElementNS(u.SVG_NS,"polygon"),u.setAttrNullNS(h,"stroke",_),u.setAttrNullNS(h,"stroke-opacity",p),u.setAttrNullNS(h,"stroke-width",1),u.setAttrNullNS(h,"fill",_),u.setAttrNullNS(h,"fill-opacity",p),u.setAttrNullNS(h,"points","0,"+n+" "+i+",0 "+i+","+n),u.appendChildElem(e,h)):l!==y.SM_DIAMOND_CHECK&&l!==y.LG_DIAMOND_CHECK||(s=r/2,a=o/2,h=document.createElementNS(u.SVG_NS,"polygon"),u.setAttrNullNS(h,"stroke",_),u.setAttrNullNS(h,"stroke-opacity",p),u.setAttrNullNS(h,"stroke-width",1),u.setAttrNullNS(h,"fill",_),u.setAttrNullNS(h,"fill-opacity",p),u.setAttrNullNS(h,"points","0,"+a+" "+s+",0 "+i+","+s+" "+s+","+n),u.appendChildElem(e,h))};const A=function(){};i.createSubclass(A,i),A._uniqueSeed=0,A.addClipPath=function(t,e){var i=t.getId();if(!i)return!1;var n=e.getDefs();if(!n)return!1;for(var r=n.childNodes,o=r.length,s=0;s<o;s++){if(r[s].id===i)return!0}var a=A.createElement("clipPath",i);e.appendDefs(a);var h=t.getRegions();for(s=0;s<h.length;s++){var l=h[s];if(l){var c=null;l.type===p.RECT?(c=A.createElement("rect"),u.setAttrNullNS(c,"x",l.x),u.setAttrNullNS(c,"y",l.y),u.setAttrNullNS(c,"width",l.w),u.setAttrNullNS(c,"height",l.h),l.rx&&u.setAttrNullNS(c,"rx",l.rx),l.ry&&u.setAttrNullNS(c,"ry",l.ry)):l.type===p.PATH?(c=A.createElement("path"),u.setAttrNullNS(c,"d",l.d)):l.type===p.POLYGON?(c=A.createElement("polygon"),u.setAttrNullNS(c,"points",l.points)):l.type===p.ELLIPSE?(c=A.createElement("ellipse"),u.setAttrNullNS(c,"cx",l.cx),u.setAttrNullNS(c,"cy",l.cy),u.setAttrNullNS(c,"rx",l.rx),u.setAttrNullNS(c,"ry",l.ry)):l.type===p.CIRCLE&&(c=A.createElement("circle"),u.setAttrNullNS(c,"cx",l.cx),u.setAttrNullNS(c,"cy",l.cy),u.setAttrNullNS(c,"r",l.r)),c&&u.appendChildElem(a,c)}}return!0},A.addMask=function(t,e){var i=t.getId();if(!i)return!1;var n=e.getDefs();if(!n)return!1;for(var r=n.childNodes,o=r.length,s=0;s<o;s++){if(r[s].id===i)return!0}var a=A.createElement("mask",i);e.appendDefs(a);var h=t.getGradient(),l=A.addSpecialFill(h,e),c=t.getBounds(),_=A.createElement("rect");return u.setAttrNullNS(_,"x",c.x),u.setAttrNullNS(_,"y",c.y),u.setAttrNullNS(_,"width",c.w),u.setAttrNullNS(_,"height",c.h),u.setAttrNullNS(_,"fill",u.getUrlById(l)),u.appendChildElem(a,_),!0},A.addSpecialFill=function(t,e){if(!t._defPresent){var i=t._defElem;i||(t instanceof g?(t._id=A.getUniqueId("Gr"),i=f.createElem(t,t._id)):t instanceof y&&(t._id=A.getUniqueId("pat"),i=C.createElem(t,t._id))),t._defElem=i,e.appendDefs(i),t._defPresent=!0}return t._id},A.createElement=function(t,e){var i=document.createElementNS(u.SVG_NS,t);return e&&u.setAttrNullNS(i,"id",e),i},A.getUniqueId=function(t){return(t||"$")+A._uniqueSeed++},A.convertPointsArray=function(t){for(var e=t.length,i="",n=0;n<e;n++)n>0&&(i+=" "),i+=t[n];return i};const O={ARIA_LABEL_STATE_DELIMITER:", ",ARIA_LABEL_DESC_DELIMITER:". ",processAriaLabel:function(t){var e=t;return e&&(e=(e=(e=(e=(e=(e=(e=(e=(e=(e=e.replace(/(<|&#60;)/g,"&lt;")).replace(/(>|&#62;)/g,"&gt;")).replace(/&lt;b&gt;/g,"")).replace(/&lt;\/b&gt;/g,"")).replace(/&lt;i&gt;/g,"")).replace(/&lt;\/i&gt;/g,"")).replace(/\n/g,"; ")).replace(/&#92;n/g,"; ")).replace(/&lt;br&gt;/g,"; ")).replace(/&lt;br\/&gt;/g,"; ")),e}},I=function(){this.Init()};i.createSubclass(I,i),I.prototype.Init=function(){this._regionPctRect=new m(-10,-10,120,120),this._counter=0},I.prototype.getRegionPctRect=function(){return this._regionPctRect},I.prototype.createResultId=function(t){return t||(t="filtRes"),t+this._counter++};const N=function(t,e,i,n){this.__type="shadow",this._dx=t,this._dy=e,this._stdDeviation=i,this._floodColor=n,this._Id="ds"+N._uniqueId++};i.createSubclass(N,i),N._uniqueId=1;const R=function(){};i.createSubclass(R,i),R.RADS_PER_DEGREE=Math.PI/180,R.createFilterPrimitives=function(t,e,i,n){var o=e._dx,s=e._dy,a=e._stdDeviation,h=e._floodColor;var l=i.getDimensions(i.getParent());if(l){var c=2*a,_=c,p=c,d=c,g=c;(_-=o)<0&&(_=0),(d-=s)<0&&(d=0),(p+=o)<0&&(p=0),(g+=s)<0&&(g=0);var f=_/l.w*100,y=p/l.w*100,v=d/l.h*100,S=g/l.h*100;n.getRegionPctRect().x>-f&&(n.getRegionPctRect().x=-f),n.getRegionPctRect().y>-v&&(n.getRegionPctRect().y=-v),n.getRegionPctRect().w<100+f+y&&(n.getRegionPctRect().w=100+f+y),n.getRegionPctRect().h<100+v+S&&(n.getRegionPctRect().h=100+v+S)}if(i.requiresStrokeAdjustmentForShadow()){var T=i.getStroke().getWidth();T>1&&(n.getRegionPctRect().h=n.getRegionPctRect().h+T,n.getRegionPctRect().y=n.getRegionPctRect().y-T)}if("ie"!==r.browser&&"edge"!==r.browser){var E=A.createElement("feDropShadow");u.setAttrNullNS(E,"dx",o),u.setAttrNullNS(E,"dy",s),u.setAttrNullNS(E,"stdDeviation",a),u.setAttrNullNS(E,"flood-color",h),u.appendChildElem(t,E)}else{var m=A.createElement("feGaussianBlur");u.setAttrNullNS(m,"stdDeviation",a);var b=A.createElement("feOffset"),C=n.createResultId("offset");u.setAttrNullNS(b,"dx",o),u.setAttrNullNS(b,"dy",s),u.setAttrNullNS(b,"result",C);var O=A.createElement("feFlood"),I=h.split(/[\(,\)]/);6===I.length?(u.setAttrNullNS(O,"flood-color",`${I[0].substr(0,3)}(${I[1]},${I[2]},${I[3]})`),u.setAttrNullNS(O,"flood-opacity",I[4])):u.setAttrNullNS(O,"flood-color",h);var N=A.createElement("feComposite");u.setAttrNullNS(N,"in2",C),u.setAttrNullNS(N,"operator","in");var R=A.createElement("feMerge"),D=A.createElement("feMergeNode"),x=A.createElement("feMergeNode");u.setAttrNullNS(x,"in","SourceGraphic"),u.appendChildElem(R,D),u.appendChildElem(R,x),u.appendChildElem(t,m),u.appendChildElem(t,b),u.appendChildElem(t,O),u.appendChildElem(t,N),u.appendChildElem(t,R)}};const D=function(){};i.createSubclass(D,i),D._counter=0,D.createFilter=function(t,e){for(var i=A.createElement("filter",D.CreateFilterId()),n=new I,r=0;r<t.length;r++){var o=t[r];o&&D.CreateFilterPrimitives(i,o,e,n)}var s=!1;if(e){var a=e.getElem().getBBox();if(a){var h=a.width,l=a.height;if(0==l||0==h){var c;e.getStroke&&(c=e.getStroke());var _=10;c&&(_=c.getWidth());var p=a.x,d=a.y;0==l&&(l=2*_,d-=_),0==h&&(h=2*_,p-=_),u.setAttrNullNS(i,"x",p),u.setAttrNullNS(i,"y",d),u.setAttrNullNS(i,"width",h),u.setAttrNullNS(i,"height",l),u.setAttrNullNS(i,"filterUnits","userSpaceOnUse"),s=!0}}}return s||(-10!=n.getRegionPctRect().x&&"Infinity"!=n.getRegionPctRect().x&&"-Infinity"!=n.getRegionPctRect().x&&u.setAttrNullNS(i,"x",n.getRegionPctRect().x+"%"),-10!=n.getRegionPctRect().y&&"Infinity"!=n.getRegionPctRect().y&&"-Infinity"!=n.getRegionPctRect().y&&u.setAttrNullNS(i,"y",n.getRegionPctRect().y+"%"),120!=n.getRegionPctRect().w&&"Infinity"!=n.getRegionPctRect().w&&"-Infinity"!=n.getRegionPctRect().w&&u.setAttrNullNS(i,"width",n.getRegionPctRect().w+"%"),120!=n.getRegionPctRect().h&&"Infinity"!=n.getRegionPctRect().h&&"-Infinity"!=n.getRegionPctRect().h&&u.setAttrNullNS(i,"height",n.getRegionPctRect().h+"%")),i},D.CreateFilterPrimitives=function(t,e,i,n){return e instanceof N&&R.createFilterPrimitives(t,e,i,n),null},D.CreateFilterId=function(){return"filt"+D._counter++};const x={addDrawEffect:function(t){this._drawEffects||(this._drawEffects=[]),this._drawEffects.push(t),this._applyDrawEffects()},removeAllDrawEffects:function(){this._drawEffects&&(this._drawEffects=null,this._applyDrawEffects(this._drawEffects))},_applyDrawEffects:function(){var t=this._drawEffects;if(this._filter&&(u.removeAttrNullNS(this.getOuterElem(),"filter"),this.getCtx().removeDefs(this._filter),this._filter=null),!this._outerElem&&this._matrix&&this._createOuterGroupElem(),t&&t.length>0&&(this._filter=D.createFilter(t,this),this._filter)){this.getCtx().appendDefs(this._filter);var e=u.getAttrNullNS(this._filter,"id");u.setAttrNullNS(this.getOuterElem(),"filter",u.getUrlById(e))}},requiresStrokeAdjustmentForShadow:function(){return!1}},M=function(){};i.createSubclass(M,i),M.prototype.Init=function(t){this.type=t.type,this.target=M.FindDisplayable(t.target),this._isPropagationStopped=!1,this._event=t},M.prototype.getNativeEvent=function(){return this._event},M.prototype.preventDefault=function(){this._event.cancelable&&this._event.preventDefault()},M.prototype.stopPropagation=function(){this._event.stopPropagation&&this._event.stopPropagation(),this._event.cancelBubble=!0,this._event.cancel=!0,this._event.returnValue=!1,this._isPropagationStopped=!0},M.prototype.isPropagationStopped=function(){return this._isPropagationStopped},M.FindDisplayable=function(t){for(;t;){if(t._obj)return t._obj;t=t.parentNode}return null};const w=function(t){this.Init(t)};i.createSubclass(w,i),w.prototype.Init=function(t){this.clientX=t.clientX,this.clientY=t.clientY,this.screenX=t.screenX,this.screenY=t.screenY,this.pageX=t.pageX,this.pageY=t.pageY,this.target=t.target,this.identifier=null==t.identifier||isNaN(t.identifier)?1:t.identifier};const L=function(t){this.Init(t)};i.createSubclass(L,M),L.TOUCHSTART="touchstart",L.TOUCHMOVE="touchmove",L.TOUCHEND="touchend",L.TOUCHCANCEL="touchcancel",L.prototype.Init=function(t){L.superclass.Init.call(this,t),t.type==L.TOUCHCANCEL&&(this.type=L.TOUCHEND),this.touches=L.createTouchArray(t.touches),this.targetTouches=L.createTouchArray(t.targetTouches),this.changedTouches=L.createTouchArray(t.changedTouches),this._touchManager=null},L.prototype.blockTouchHold=function(){this.getNativeEvent()._touchHoldBlocked=!0},L.prototype.isInitialTouch=function(){return this.touches.length-this.changedTouches.length==0},L.prototype.isTouchHoldBlocked=function(){return!!this.getNativeEvent()._touchHoldBlocked},L.createTouchArray=function(t){for(var e=new Array,i=0;i<t.length;i++){var n=t[i],r=new w(n);e.push(r)}return e},L.prototype.stopPropagation=function(){L.superclass.stopPropagation.call(this),this._touchManager&&this._touchManager.postEventBubble(this)},L.prototype.setTouchManager=function(t){this._touchManager=t};const P=function(t){this.Init(t)};i.createSubclass(P,M),P.KEYDOWN="keydown",P.KEYUP="keyup",P.KEYPRESS="keypress",P.TAB=9,P.ENTER=13,P.SHIFT=16,P.CONTROL=17,P.ESCAPE=27,P.SPACE=32,P.PAGE_UP=33,P.PAGE_DOWN=34,P.UP_ARROW=38,P.DOWN_ARROW=40,P.LEFT_ARROW=37,P.RIGHT_ARROW=39,P.F2=113,P.OPEN_BRACKET=219,P.CLOSE_BRACKET=221,P.ZERO=48,P.NUMPAD_ZERO=96,P.NUMPAD_PLUS=107,P.NUMPAD_MINUS=109,P.WEBKIT_PLUS=187,P.WEBKIT_MINUS=189,P.GECKO_PLUS=61,P.GECKO_MINUS=173,P.M=77,P.OPEN_ANGLED_BRACKET=188,P.CLOSE_ANGLED_BRACKET=190,P.prototype.Init=function(t){P.superclass.Init.call(this,t),this.bubbles=t.bubbles,this.cancelable=t.cancelable,this.view=t.view,this.charCode=t.charCode,this.keyCode=t.keyCode,this.location=t.location,this.ctrlKey=t.ctrlKey||t.metaKey,this.altKey=t.altKey,this.shiftKey=t.shiftKey,this.repeat=t.repeat,this.locale=t.locale},P.isPlus=function(t){var e=t.keyCode;return e==P.NUMPAD_PLUS||("firefox"===r.browser?!(e!=P.GECKO_PLUS||!t.shiftKey):!(e!=P.WEBKIT_PLUS||!t.shiftKey))},P.isEquals=function(t){var e=t.keyCode;return"firefox"===r.browser?e==P.GECKO_PLUS&&!t.shiftKey:e==P.WEBKIT_PLUS&&!t.shiftKey},P.isMinus=function(t){var e=t.keyCode;return e==P.NUMPAD_MINUS||("firefox"===r.browser?e==P.GECKO_MINUS&&!t.shiftKey:e==P.WEBKIT_MINUS&&!t.shiftKey)},P.isUnderscore=function(t){var e=t.keyCode;return"firefox"===r.browser?!(e!=P.GECKO_MINUS||!t.shiftKey):!(e!=P.WEBKIT_MINUS||!t.shiftKey)};const H=function(t){this.Init(t)};i.createSubclass(H,M),H.FOCUS="focus",H.FOCUSIN="focusin",H.FOCUSOUT="focusout",H.BLUR="blur",H.prototype.Init=function(t){H.superclass.Init.call(this,t),this.bubbles=t.bubbles,this.cancelable=t.cancelable,this.view=t.view,null!=t.relatedTarget&&(this.relatedTarget=M.FindDisplayable(t.relatedTarget))};const F=function(t){this.Init(t)};i.createSubclass(F,M),F.CLICK="click",F.DBLCLICK="dblclick",F.MOUSEOVER="mouseover",F.MOUSEOUT="mouseout",F.MOUSEDOWN="mousedown",F.MOUSEUP="mouseup",F.MOUSEMOVE="mousemove",F.MOUSEWHEEL="wheel",F.RIGHT_CLICK_BUTTON=2,F.prototype.Init=function(t){F.superclass.Init.call(this,t),null!=t.relatedTarget&&(this.relatedTarget=M.FindDisplayable(t.relatedTarget)),this.button=t.button,this.ctrlKey=t.ctrlKey||t.metaKey,this.shiftKey=t.shiftKey,this.pageX=t.pageX,this.pageY=t.pageY,this._isEventModifiedForIE=!1,null!=t.wheelDeltaY?this.wheelDelta=t.wheelDeltaY/40:null!=t.deltaY?(this.deltaMode=t.deltaMode,this.deltaY=t.deltaY,t.deltaMode==t.DOM_DELTA_LINE?this.wheelDelta=-t.deltaY:t.deltaMode==t.DOM_DELTA_PIXEL&&(this.wheelDelta=-t.deltaY/15)):null!=t.wheelDelta?this.wheelDelta=t.wheelDelta/40:this.wheelDelta=t.detail},F.prototype.modifyEventForIE=function(t,e){this._isEventModifiedForIE||(this.type=t,this.relatedTarget=this.target,this.target=M.FindDisplayable(e),this._isEventModifiedForIE=!0)};const k=new Object;i.createSubclass(k,i),k.newEvent=function(t,e){var i=t.type;return i==L.TOUCHSTART||i==L.TOUCHMOVE||i==L.TOUCHEND||i==L.TOUCHCANCEL?new L(t):i==P.KEYDOWN||i==P.KEYUP||i==P.KEYPRESS?new P(t):(e._nativeEvent!=t&&(e._nativeEvent=t,e._logicalEvent=i==H.FOCUS||i==H.FOCUSIN||i==H.FOCUSOUT||i==H.BLUR?new H(t):new F(t)),e._logicalEvent)};const G=function(){};i.createSubclass(G,i),G.getListener=function(t){return t?G._captureListener:G._bubbleListener},G._bubbleListener=function(t){G._commonListener.call(this,t,!1)},G._captureListener=function(t){G._commonListener.call(this,t,!0)},G._commonListener=function(t,e){var i;if(this._currentObj){if("focus"==t.type)return void(this._focusEvent=t);var n=this._currentObj.getCtx();this._focusEvent&&(n.resetCurrentKeyboardFocus(t),i=k.newEvent(this._focusEvent,n),this._currentObj.FireListener(i,e),this._focusEvent=null),i=k.newEvent(t,n),this._currentObj.FireListener(i,e)}else if(Array.isArray(this._keyboardListeners))for(var r,o=this._keyboardListeners.length,s=0;s<o;s++)r=this._keyboardListeners[s],i=k.newEvent(t,r.getCtx()),r.FireListener(i,e)};const B={addEvtListener:function(t,e,i,n){var r=u.getUseCaptureFromOptions(i),o=this._getListeners(t,r,!0);o.push(e),o.push(n),this._addListener(t,i)},removeEvtListener:function(t,e,i,n){var r=u.getUseCaptureFromOptions(i),o=this._getListeners(t,r,!1);if(o)for(var s=0;s<o.length;s+=2)if(o[s]===e&&o[s+1]===n){o.splice(s,2);break}o&&o.length<=0&&this._removeListener(t,i)},AddElemListener:function(t,e,i){u.addDomEventListener(this.getElem(),t,e,i),t==L.TOUCHEND&&u.addDomEventListener(this.getElem(),L.TOUCHCANCEL,e,i)},FireListener:function(t,e){var i=this._getListeners(t.type,e,!1);if(i)for(var n=0;n<i.length;n+=2){var r=i[n+1];i[n]&&i[n].call(r,t)}},fireKeyboardListener:function(t,e){this.FireListener(t,e)},_getListeners:function(t,e,i){if(!this._listenerObj){if(!i)return null;this._listenerObj={}}var n=t+"_"+!!e,r=this._listenerObj[n];return!r&&i&&(r=[],this._listenerObj[n]=r),r},_addListener:function(t,e){var i=u.getUseCaptureFromOptions(e),n=this._getListener(i);if(t==P.KEYUP||t==P.KEYDOWN||t==P.KEYPRESS||t==H.FOCUS||t==H.FOCUSIN||t==H.FOCUSOUT||t==H.BLUR){var r=this.getCtx().getStage().getSVGRoot().parentNode;if(!r)return;r._keyboardListeners||(r._keyboardListeners=[]),-1==r._keyboardListeners.indexOf(this)&&r._keyboardListeners.push(this),n=G.getListener(i),u.addDomEventListener(r,t,n,e)}else this.AddElemListener(t,n,e)},_removeListener:function(t,e){var i=u.getUseCaptureFromOptions(e),n=this._getListener(i);if(t==P.KEYUP||t==P.KEYDOWN||t==P.KEYPRESS||t==H.FOCUS||t==H.FOCUSIN||t==H.FOCUSOUT||t==H.BLUR){var r=this.getCtx().getStage().getSVGRoot().parentNode;u.removeDomEventListener(r,t,n,e);var o=r._keyboardListeners.indexOf(this);-1!==o&&r._keyboardListeners.splice(o,1)}else u.removeDomEventListener(this.getElem(),t,n,e)},_getListener:function(t){var e=this;return t?(this._captureClosure||(this._captureClosure=function(t){e._captureListener(t)}),this._captureClosure):(this._bubbleClosure||(this._bubbleClosure=function(t){e._bubbleListener(t)}),this._bubbleClosure)},_shouldIgnoreEvent:function(t,e){var i=e?this._captureHoverItem:this._bubbleHoverItem;if(i){if(t.type===F.MOUSEOVER)return i===t.target;if(t.type===F.MOUSEOUT)return i===t.relatedTarget}return!1},_fireMissedEvent:function(t,e){if(t.type===F.MOUSEOVER||F.MOUSEOUT){var i=e?this._captureHoverItem:this._bubbleHoverItem;if(i&&i!==t.target){var n=k.newEvent(t,this.getCtx());n.modifyEventForIE(F.MOUSEOUT,i),this.FireListener(n,e)}}},_bubbleListener:function(t){if("ie"===r.browser||"edge"===r.browser){if(this._shouldIgnoreEvent(t,!1))return;this._fireMissedEvent(t,!1),t.type==F.MOUSEOVER?this._bubbleHoverItem=t.target:t.type==F.MOUSEOUT&&(this._bubbleHoverItem=null)}var e=k.newEvent(t,this.getCtx());this.FireListener(e,!1)},_captureListener:function(t){if("ie"===r.browser||"edge"===r.browser){if(this._shouldIgnoreEvent(t,!0))return;this._fireMissedEvent(t,!0),t.type==F.MOUSEOVER?this._captureHoverItem=t.target:t.type==F.MOUSEOUT&&(this._captureHoverItem=null)}var e=k.newEvent(t,this.getCtx());this.FireListener(e,!0)}},U=function(t){this.Init(t)};i.createSubclass(U,i),U.LINEAR=0,U.RADIAL=1,U.prototype.Init=function(t){this._type=t},U.prototype.getAlphas=function(){return this._arAlphas},U.prototype.setAlphas=function(t){this._arAlphas=t},U.prototype.getColors=function(){return this._arColors},U.prototype.setColors=function(t){this._arColors=t},U.prototype.getRatios=function(){return this._arRatios},U.prototype.setRatios=function(t){this._arRatios=t};const Y=function(){this.Init()};i.createSubclass(Y,U),Y.LEFT=0,Y.BOTTOM_LEFT=45,Y.BOTTOM=90,Y.BOTTOM_RIGHT=135,Y.RIGHT=180,Y.TOP_RIGHT=225,Y.TOP=270,Y.TOP_LEFT=315,Y.prototype.Init=function(){Y.superclass.Init.call(this,U.LINEAR)},Y.prototype.getAngle=function(){return this._angle},Y.prototype.setAngle=function(t){this._angle=t};const W={parseLeadingColor:function(t,e){var i,n=t.trim(),r=n.length,o=-1;if(!n)return n;if(0==n.indexOf("rgb"))o=n.indexOf(")")+1,i=n.slice(0,o);else{-1==(o=n.indexOf(" "))&&(o=r);var s=n.slice(0,o);(i=T.getColorFromName(s))||(i=W.parseHexColor(s))}return i&&(e.push(i),n=n.slice(o)),n},parseHexColor:function(t){return t?"#"!==t.charAt(0)||isNaN("0x"+t.substring(1))?"#000000":t:null}},V=function(){};i.createSubclass(V,i),V.GD_LINEAR="linear-gradient",V.GD_TOP="top",V.GD_BOTTOM="bottom",V.GD_LEFT="left",V.GD_RIGHT="right",V.GD_TO="to",V.parseCSSGradient=function(t){return null!=t&&(t=t.trim(),V._startsWith(t,V.GD_LINEAR))?(t=V._removeParenthesis(t,V.GD_LINEAR),V._parseLinearGradient(t)):null},V._parseLinearGradient=function(t){var e=new RegExp("(-?(?:\\d*\\.)?\\d+)"),i=new RegExp("(deg|rad|grad|turn)"),n=new RegExp("(left|right)"),r=new RegExp("(top|bottom)"),o=new RegExp("(?:(to)\\s+)"),s=new RegExp("(?:"+e.source+i.source+")"),a=new RegExp("(?:"+n.source+"(?:\\s+"+r.source+")?)"),h=new RegExp("(?:"+r.source+"(?:\\s+"+n.source+")?)"),l=new RegExp("(?:"+a.source+"|"+h.source+")"),u=new RegExp("(?:"+s.source+"|(?:"+o.source+"?"+l.source+"))"),c=new RegExp("(?:\\s*"+u.source+"\\s*,\\s*)","i"),_=t.match(c);if(null==_||0==_.length)return null;_.length;var p=new Y,d=_[5]==V.GD_TOP||_[6]==V.GD_TOP,g=_[5]==V.GD_BOTTOM||_[6]==V.GD_BOTTOM,f=_[4]==V.GD_LEFT||_[7]==V.GD_LEFT,y=_[4]==V.GD_RIGHT||_[7]==V.GD_RIGHT;if(_[3]==V.GD_TO&&((d||g)&&(d=!d,g=!g),(f||y)&&(f=!f,y=!y)),d)f?p.setAngle(Y.TOP_LEFT):y?p.setAngle(Y.TOP_RIGHT):p.setAngle(Y.TOP);else if(g)f?p.setAngle(Y.BOTTOM_LEFT):y?p.setAngle(Y.BOTTOM_RIGHT):p.setAngle(Y.BOTTOM);else if(f)p.setAngle(Y.LEFT);else if(y)p.setAngle(Y.RIGHT);else if(_[2]){s=parseFloat(_[1]);isNaN(s)||("grad"==_[2]?s=s/200*180:"rad"==_[2]?s=s/Math.PI*180:"turn"==_[2]&&(s=s/.5*180),p.setAngle(s))}return t=t.substring(_[0].length),V._parseCSSColorStops(t,p),p},V._parseCSSColorStops=function(t,e){var i=t.match(/(#[0-9a-f]+|rgb\(\s*(\d+),\s*(\d+),\s*(\d+)\s*\)|rgba\(\s*(\d+),\s*(\d+),\s*(\d+),\s*(\d?)(\.\d+)?\s*\)|[a-z]+)(\s+\d+\.?\d*%)?/gi);null!=i&&i.length>0&&V._parseColorStops(i,e)},V._parseColorStops=function(t,e){for(var i,n,r,o=t.length,s=[],a=[],h=[],l=!0,u=[],c=0;c<t.length;c++)r=W.parseLeadingColor(t[c],u),i=u.pop(),a[c]=i,s[c]=T.getAlpha(i),(r=r.trim()).length>0&&(n=parseFloat(r),isNaN(n)||r.endsWith("%")&&(h[c]=n/100,l=!1));if(o>1&&l)for(var _=0;_<o;_++)h[_]=_/(o-1);else l&&(h[0]=0);e.setColors(a),e.setAlphas(s),e.setRatios(h)},V._removeParenthesis=function(t,e){return")"!=t.charAt(t.length-1)?null:(t=t.substring(e.length),V.removeQuotes(t,"(",")"))},V.removeQuotes=function(t,e,i){if((t=t.trim()).charAt(0)!=e)return t;null==i&&(i=e);var n=t.lastIndexOf(i);return n<0?t.substring(1):t.substring(1,n)},V._startsWith=function(t,e){return 0==t.indexOf(e)};const j=function(t){this.Init(t)};i.createSubclass(j,i),j.DEFAULT_FONT_SIZE="12px",j.SKIN_ALTA="alta",j.BACKGROUND="background",j.BACKGROUND_COLOR="background-color",j.BACKGROUND_IMAGE="background-image",j.BACKGROUND_REPEAT="background-repeat",j.BACKGROUND_POSITION="background-position",j.BORDER="border",j.BORDER_TOP="border-top",j.BORDER_BOTTOM="border-bottom",j.BORDER_LEFT="border-left",j.BORDER_RIGHT="border-right",j.BORDER_WIDTH="border-width",j.BORDER_TOP_WIDTH="border-top-width",j.BORDER_BOTTOM_WIDTH="border-bottom-width",j.BORDER_LEFT_WIDTH="border-left-width",j.BORDER_RIGHT_WIDTH="border-right-width",j.BORDER_COLOR="border-color",j.BORDER_TOP_COLOR="border-top-color",j.BORDER_BOTTOM_COLOR="border-bottom-color",j.BORDER_LEFT_COLOR="border-left-color",j.BORDER_RIGHT_COLOR="border-right-color",j.BORDER_STYLE="border-style",j.BORDER_RADIUS="border-radius",j.BORDER_TOP_LEFT_RADIUS="border-top-left-radius",j.BORDER_TOP_RIGHT_RADIUS="border-top-right-radius",j.BORDER_BOTTOM_RIGHT_RADIUS="border-bottom-right-radius",j.BORDER_BOTTOM_LEFT_RADIUS="border-bottom-left-radius",j.MARGIN="margin",j.MARGIN_TOP="margin-top",j.MARGIN_BOTTOM="margin-bottom",j.MARGIN_LEFT="margin-left",j.MARGIN_RIGHT="margin-right",j.PADDING="padding",j.PADDING_TOP="padding-top",j.PADDING_BOTTOM="padding-bottom",j.PADDING_LEFT="padding-left",j.PADDING_RIGHT="padding-right",j.COLOR="color",j.FONT_FAMILY="font-family",j.FONT_SIZE="font-size",j.FONT_STYLE="font-style",j.FONT_WEIGHT="font-weight",j.TEXT_DECORATION="text-decoration",j.TEXT_ALIGN="text-align",j.HEIGHT="height",j.WIDTH="width",j.MAX_WIDTH="max-width",j.NO_REPEAT="no-repeat",j.REPEAT="repeat",j.REPEAT_X="repeat-x",j.REPEAT_Y="repeat-y",j.AUTO="auto",j.AUTO_MARGIN="8",j.WHITE_SPACE="white-space",j._NAMED_FONT_SIZE_MAP={"xx-small":"9","x-small":"10",small:"13",medium:"16",large:"18","x-large":"24","xx-large":"32"},j._NAMED_WIDTH_MAP={thin:"2",medium:"4",thick:"6"},j._numericAttrsList=[j.MAX_WIDTH,j.WIDTH,j.HEIGHT,j.BORDER_WIDTH,j.BORDER_TOP_WIDTH,j.BORDER_BOTTOM_WIDTH,j.BORDER_LEFT_WIDTH,j.BORDER_RIGHT_WIDTH,j.MARGIN,j.MARGIN_TOP,j.MARGIN_BOTTOM,j.MARGIN_LEFT,j.MARGIN_RIGHT,j.PADDING,j.PADDING_TOP,j.PADDING_BOTTOM,j.PADDING_LEFT,j.PADDING_RIGHT],j._DOUBLE_QUOTE='"',j._SINGLE_QUOTE="'",j.COLORS_ALTA=["#237bb1","#68c182","#fad55c","#ed6647","#8561c8","#6ddbdb","#ffb54d","#e371b2","#47bdef","#a2bf39","#a75dba","#f7f37b"],j.prototype.Init=function(t){this._styleMap={},this.parseInlineStyle(t)},j.prototype.parseInlineStyle=function(t){if(t){var e=this;if(t instanceof Object)for(var i in t){var n=t[i];i=i.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase(),e.setStyle(i,n)}else j._parseStyleString(t,function(t,i){e.setStyle(t,i)})}},j.prototype.setStyle=function(t,e){if(null==e)this._setStyleAttr(t,e);else switch(t){case"background-repeat":this._setBackgroundRepeat(t,e);break;case"color":case"background-color":case"border-top-color":case"border-bottom-color":case"border-left-color":case"border-right-color":this._setColorAttr(t,e);break;case"border-top":case"border-bottom":case"border-left":case"border-right":this._setBorderSide(t,e);break;case"border":this._setBorderShorthand(t,e);break;case"border-color":this._setBorderColorShorthand(t,e);break;case"border-width":this._setBorderWidthShorthand(t,e);break;case"border-radius":this._setBorderRadius(t,e);break;case"padding":this._setPaddingShorthand(t,e);break;case"margin":this._setMarginShorthand(t,e);break;case"font-size":this.setFontSize(t,e);break;case"background-image":var i=V.parseCSSGradient(e);i&&(e=i),this._setStyleAttr(t,e);break;default:this._setStyleAttr(t,e)}return this},j.prototype.getStyle=function(t){return this._styleMap[t]},j.prototype._setStyleAttr=function(t,e){return null!=e?this._styleMap[t]=e:delete this._styleMap[t],this},j.prototype.setFontSize=function(t,e,i){var n=e.trim(),r=j._NAMED_FONT_SIZE_MAP[n];if(r)this._setStyleAttr(t,String(r)+"px");else{var o=i?i.getDefaultFontSize():j.DEFAULT_FONT_SIZE;this._setStyleAttr(t,isNaN(parseFloat(n))?o:n)}},j.prototype._setBorderWidthShorthand=function(t,e){var i=e.split(" "),n=null;switch(i.length){case 1:this._setStyleAttr(t,j._getBorderWidth(i[0])),this._setStyleAttr(j.BORDER_TOP_WIDTH,null),this._setStyleAttr(j.BORDER_BOTTOM_WIDTH,null),this._setStyleAttr(j.BORDER_RIGHT_WIDTH,null),this._setStyleAttr(j.BORDER_LEFT_WIDTH,null);break;case 2:n=j._getBorderWidth(i[0]),this._setStyleAttr(j.BORDER_TOP_WIDTH,n),this._setStyleAttr(j.BORDER_BOTTOM_WIDTH,n),n=j._getBorderWidth(i[1]),this._setStyleAttr(j.BORDER_LEFT_WIDTH,n),this._setStyleAttr(j.BORDER_RIGHT_WIDTH,n);break;case 3:this._setStyleAttr(j.BORDER_TOP_WIDTH,j._getBorderWidth(i[0])),n=j._getBorderWidth(i[1]),this._setStyleAttr(j.BORDER_LEFT_WIDTH,n),this._setStyleAttr(j.BORDER_RIGHT_WIDTH,n),this._setStyleAttr(j.BORDER_BOTTOM_WIDTH,j._getBorderWidth(i[2]));break;case 4:this._setStyleAttr(j.BORDER_TOP_WIDTH,j._getBorderWidth(i[0])),this._setStyleAttr(j.BORDER_RIGHT_WIDTH,j._getBorderWidth(i[1])),this._setStyleAttr(j.BORDER_BOTTOM_WIDTH,j._getBorderWidth(i[2])),this._setStyleAttr(j.BORDER_LEFT_WIDTH,j._getBorderWidth(i[3]))}},j._getBorderWidth=function(t){var e=t.trim(),i=j._NAMED_WIDTH_MAP[e];return i||(i=isNaN(parseFloat(e))?"0px":e),i},j.prototype._setBorderSide=function(t,e){for(var i,n=e.split(" "),r=null,o=!1,s=0;s<n.length;s++)if(i=t,0==(r=n[s]).indexOf("rgb")){for(var a=s+1;a<n.length&&(r+=n[a],s++,-1==n[a].indexOf(")"));a++);t.endsWith("-"+j.COLOR)||(i=t+"-"+j.COLOR),this._setStyleAttr(i,r)}else j._isColorValue(r)?(t.endsWith("-"+j.COLOR)||(i=t+"-"+j.COLOR),this._setStyleAttr(i,W.parseHexColor(r))):j._isBorderWidthValue(r)?(t.endsWith("-"+j.WIDTH)||(i=t+"-"+j.WIDTH),this._setStyleAttr(i,r)):"none"==e&&(o=!0);o&&this._setStyleAttr(t+"-"+j.WIDTH,"0")},j.prototype.getMargin=function(t){return this._getSideWidth(t,j.MARGIN)},j.prototype.getPadding=function(t){return this._getSideWidth(t,j.PADDING)},j.prototype.getBorderWidth=function(){var t=this.getStyle(j.BORDER_WIDTH);return t||(t=this.getStyle(j.BORDER_TOP_WIDTH))||(t=this.getStyle(j.BORDER_RIGHT_WIDTH))||(t=this.getStyle(j.BORDER_BOTTOM_WIDTH))||(t=this.getStyle(j.BORDER_LEFT_WIDTH))?j.toNumber(t):0},j.prototype.getMaxWidth=function(){return this.getStyle(j.MAX_WIDTH)},j.prototype.getWidth=function(){return this.getStyle(j.WIDTH)},j.prototype.getHeight=function(){return this.getStyle(j.HEIGHT)},j.toNumber=function(t){return t?(t=parseFloat(t),isNaN(t)?0:t):0},j.prototype._setBorderColorShorthand=function(t,e){var i,n=j._parseBorderColorString(t,e);switch(n.length){case 1:this._setStyleAttr(t,n[0]),this._setStyleAttr(j.BORDER_TOP_COLOR,null),this._setStyleAttr(j.BORDER_BOTTOM_COLOR,null),this._setStyleAttr(j.BORDER_RIGHT_COLOR,null),this._setStyleAttr(j.BORDER_LEFT_COLOR,null);break;case 2:i=n[0],this._setStyleAttr(j.BORDER_TOP_COLOR,i),this._setStyleAttr(j.BORDER_BOTTOM_COLOR,i),i=n[1],this._setStyleAttr(j.BORDER_LEFT_COLOR,i),this._setStyleAttr(j.BORDER_RIGHT_COLOR,i);break;case 3:this._setStyleAttr(j.BORDER_TOP_COLOR,n[0]),i=n[1],this._setStyleAttr(j.BORDER_LEFT_COLOR,i),this._setStyleAttr(j.BORDER_RIGHT_COLOR,i),this._setStyleAttr(j.BORDER_BOTTOM_COLOR,n[2]);break;case 4:this._setStyleAttr(j.BORDER_TOP_COLOR,n[0]),this._setStyleAttr(j.BORDER_RIGHT_COLOR,n[1]),this._setStyleAttr(j.BORDER_BOTTOM_COLOR,n[2]),this._setStyleAttr(j.BORDER_LEFT_COLOR,n[3])}},j.prototype._setPaddingShorthand=function(t,e){var i=e.split(" "),n=null;switch(i.length){case 1:this._setStyleAttr(t,this._getPercent(i[0])),this._setStyleAttr(j.PADDING_TOP,null),this._setStyleAttr(j.PADDING_BOTTOM,null),this._setStyleAttr(j.PADDING_RIGHT,null),this._setStyleAttr(j.PADDING_LEFT,null);break;case 2:n=this._getPercent(i[0]),this._setStyleAttr(j.PADDING_TOP,n),this._setStyleAttr(j.PADDING_BOTTOM,n),n=this._getPercent(i[1]),this._setStyleAttr(j.PADDING_LEFT,n),this._setStyleAttr(j.PADDING_RIGHT,n);break;case 3:this._setStyleAttr(j.PADDING_TOP,this._getPercent(i[0])),n=this._getPercent(i[1]),this._setStyleAttr(j.PADDING_LEFT,n),this._setStyleAttr(j.PADDING_RIGHT,n),this._setStyleAttr(j.PADDING_BOTTOM,this._getPercent(i[2]));break;case 4:this._setStyleAttr(j.PADDING_TOP,this._getPercent(i[0])),this._setStyleAttr(j.PADDING_RIGHT,this._getPercent(i[1])),this._setStyleAttr(j.PADDING_BOTTOM,this._getPercent(i[2])),this._setStyleAttr(j.PADDING_LEFT,this._getPercent(i[3]))}},j.prototype._setMarginShorthand=function(t,e){var i=e.split(" "),n=null;switch(i.length){case 1:this._setStyleAttr(t,this._getMargin(i[0])),this._setStyleAttr(j.MARGIN_TOP,null),this._setStyleAttr(j.MARGIN_BOTTOM,null),this._setStyleAttr(j.MARGIN_RIGHT,null),this._setStyleAttr(j.MARGIN_LEFT,null);break;case 2:n=this._getMargin(i[0]),this._setStyleAttr(j.MARGIN_TOP,n),this._setStyleAttr(j.MARGIN_BOTTOM,n),n=this._getMargin(i[1]),this._setStyleAttr(j.MARGIN_LEFT,n),this._setStyleAttr(j.MARGIN_RIGHT,n);break;case 3:this._setStyleAttr(j.MARGIN_TOP,this._getMargin(i[0])),n=this._getMargin(i[1]),this._setStyleAttr(j.MARGIN_LEFT,n),this._setStyleAttr(j.MARGIN_RIGHT,n),this._setStyleAttr(j.MARGIN_BOTTOM,this._getMargin(i[2]));break;case 4:this._setStyleAttr(j.MARGIN_TOP,this._getMargin(i[0])),this._setStyleAttr(j.MARGIN_RIGHT,this._getMargin(i[1])),this._setStyleAttr(j.MARGIN_BOTTOM,this._getMargin(i[2])),this._setStyleAttr(j.MARGIN_LEFT,this._getMargin(i[3]))}},j.prototype._getMargin=function(t){var e=t.trim();return j.AUTO==e?j.AUTO_MARGIN:this._getPercent(e)},j.prototype._getPercent=function(t){return t.trim()},j.prototype._setBorderShorthand=function(t,e){for(var i=e.split(" "),n=null,r=!1,o=0;o<i.length;o++)if(0==(n=i[o]).indexOf("rgb")){for(var s=o+1;s<i.length&&(n+=i[s],o++,-1==i[s].indexOf(")"));s++);this._setBorderColorShorthand(j.BORDER_COLOR,n)}else j._isColorValue(n)?this._setBorderColorShorthand(j.BORDER_COLOR,n):j._isBorderWidthValue(n)?this._setBorderWidthShorthand(j.BORDER_WIDTH,n):"none"==e&&(r=!0);r&&this._setBorderWidthShorthand(j.BORDER_WIDTH,"0")},j._getBorderRadius=function(t){var e=t.trim();return isNaN(parseFloat(e))?"0px":e},j.prototype._setBorderRadius=function(t,e){var i=e.split("/");if(null!=i[0]){var n=i[0].trim().split(" ");switch(n.length){case 1:default:this._setStyleAttr(t,j._getBorderRadius(n[0])),this._setStyleAttr(j.BORDER_TOP_LEFT_RADIUS,null),this._setStyleAttr(j.BORDER_TOP_RIGHT_RADIUS,null),this._setStyleAttr(j.BORDER_BOTTOM_RIGHT_RADIUS,null),this._setStyleAttr(j.BORDER_BOTTOM_LEFT_RADIUS,null)}if(2==i.length&&null!=i[1]){var r=i[1].trim().split(" ");switch(r.length){case 1:this.getStyle(t)?this._setStyleAttr(t,this.getStyle(t)+" "+j._getBorderRadius(r[0])):this._setStyleAttr(t,j._getBorderRadius(r[0]))}}}else this._setStyleAttr(t,"0px")},j.prototype.getBorderRadius=function(){return"undefined"!==this.getStyle(j.BORDER_RADIUS)&&null!==this.getStyle(j.BORDER_RADIUS)?j.toNumber(this.getStyle(j.BORDER_RADIUS)):0},j.prototype._setBackgroundRepeat=function(t,e){var i=e.split(" ");2==i.length&&(i[0]==i[1]?e=i[0]:i[0]==j.REPEAT&&i[1]==j.NO_REPEAT&&(e=j.REPEAT_X),i[0]==j.NO_REPEAT&&i[1]==j.REPEAT&&(e=j.REPEAT_Y)),this._setStyleAttr(t,e)},j.prototype._setColorAttr=function(t,e){var i=T.getColorFromName(e);i?this._setStyleAttr(t,i):j._isColorValue(e)&&this._setStyleAttr(t,e)},j.prototype.clone=function(){var t=new j;for(var e in this._styleMap)t._setStyleAttr(e,this.getStyle(e));return t},j.prototype.merge=function(t){if(t)for(var e in t._styleMap)this._setStyleAttr(e,t.getStyle(e));return this},j.prototype.mergeUnder=function(t){if(t)for(var e in t._styleMap)this.getStyle(e)||this._setStyleAttr(e,t.getStyle(e));return this},j.prototype.toString=function(){var t="";for(var e in this._styleMap)t+=e+":"+this.getStyle(e)+"; ";return t},j.prototype.hasBackgroundStyles=function(){return!!(this.getStyle(j.BORDER_COLOR)||this.getStyle(j.BORDER_WIDTH)||this.getStyle(j.BORDER_RADIUS)||this.getStyle(j.BACKGROUND_COLOR))},j._isColorValue=function(t){return 0==(t=t.trim()).indexOf("rgb")||0==t.indexOf("#")||!!T.getColorFromName(t)},j._isBorderWidthValue=function(t){var e=t.trim();return!!j._NAMED_WIDTH_MAP[e]||!isNaN(parseFloat(e))},j._parseBorderColorString=function(t,e){e=e.trim();for(var i=[];null!=e&&e.length>0;)e=W.parseLeadingColor(e,i);return i},j.prototype._getSideWidth=function(t,e){var i=this.getStyle(t);return i||(i=this.getStyle(e)),j.toNumber(i)},j.prototype.getFontSize=function(){return this.getStyle(j.FONT_SIZE)},j.mergeStyles=function(t){var e=new j;if(t)for(var i=0;i<t.length;i++)e.merge(t[i]);return e},j.prototype.isEmpty=function(){for(var t in this._styleMap)return!1;return!0},j.prototype.hashCodeForTextMeasurement=function(){for(var t="",e=j.getTextMeasurementProperties(),i=0;i<e.length;i++){var n=this.getStyle(e[i]);n&&(t+=n)}return t},j.getTextMeasurementProperties=function(){return[j.FONT_FAMILY,j.FONT_SIZE,j.FONT_STYLE,j.FONT_WEIGHT]},j.cssObjectToString=function(t){var e="";return t&&JSON.parse(JSON.stringify(t),function(t,i){t&&(t=t.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase(),e+=t+":"+i+";")}),e},j.cssStringToObject=function(t){var e={};return j._parseStyleString(t,function(t,i){t=j.cssStringToObjectProperty(t),e[t]=i}),e},j.cssStringToObjectProperty=function(t){return t&&(t=t.replace(/-([a-z])/g,function(t){return t[1].toUpperCase()})),t},j._parseStyleString=function(t,e){if(t&&t.length>0)for(var i=t.split(";"),n=0;n<i.length;n++){var r=i[n];if(r&&r.length>0){var o=r.indexOf(":");if(o>-1){var s=r.substring(0,o).trim(),a=r.substring(o+1).trim();s&&s.length>0&&a&&a.length>0&&(s==j.BACKGROUND_IMAGE&&a.indexOf("data:image/")>=0&&(a=a+";"+i[n+1],n++),e(s,a))}}}},j.getTimeMilliseconds=function(t){return"string"==typeof t&&(t="ms"==t.slice(-2)?parseInt(t.slice(0,-2)):"s"==t.slice(-1)?1e3*parseFloat(t.slice(0,-1)):parseInt(t)),t},j.prototype.applyStylesToElement=function(t){j.applyCssObjectToElement(this._styleMap,t)},j.applyCssObjectToElement=function(t,e){for(var i=Object.keys(t),n=0;n<i.length;n++){var r=i[n];e.style[j.cssStringToObjectProperty(r)]=t[r]}};const K=function(t,e){this._fc=t,this._fa=null!=e?e:1};i.createSubclass(K,i),K.prototype.getColor=function(){return this._fc},K.prototype.getAlpha=function(){return this._fa},K.invisibleFill=function(){return K._INVISIBLE_FILL||(K._INVISIBLE_FILL=new K("rgba(0,0,0,0)")),K._INVISIBLE_FILL},K.prototype.equals=function(t){return t instanceof K&&t.getColor()==this.getColor()&&t.getAlpha()==this.getAlpha()};const z=function(t,e,i,n,r,o){this._color=t,this._alpha=null!=e?e:1,this._width=null===i||isNaN(i)?1:i,this._fixedWidth=n||!1,this._dashProps=r,this._lineProps=o};i.createSubclass(z,i),z.prototype.getLineProps=function(){return this._lineProps},z.prototype.getDashProps=function(){return this._dashProps},z.prototype.getAlpha=function(){return this._alpha},z.prototype.getColor=function(){return this._color},z.prototype.getWidth=function(){return this._width},z.prototype.isFixedWidth=function(){return this._fixedWidth},z.getDefaultDashProps=function(t,e){return"solid"===t?null:(e=Math.ceil(e),"dashed"==t?{dashArray:""+Math.max(6,2*e)}:"dotted"==t?{dashArray:""+Math.max(2,e)}:null)};const X={getFill:function(){return this.GetProperty("fill")},setFill:function(t){if(this._manageDefinitions(this.GetProperty("fill"),t),!t)return u.setAttrNullNS(this._elem,"fill","none"),u.removeAttrNullNS(this._elem,"fill-opacity"),void this.SetProperty("fill",null);if(this.GetProperty("fill")!==t){if(this.SetProperty("fill",t),t instanceof g||t instanceof y){var e=A.addSpecialFill(t,this.getCtx());u.setAttrNullNS(this._elem,"fill",u.getUrlById(e))}else{var i=T.fixColorForPlatform(t.getColor(),t.getAlpha());i&&i.color&&(u.setAttrNullNS(this._elem,"fill",i.color),null!=i.alpha&&u.setAttrNullNS(this._elem,"fill-opacity",i.alpha,1))}this.UpdateSelectionEffect()}},getClassName:function(){return this._className},setClassName:function(t){return this._className&&!t?u.removeAttrNullNS(this._elem,"class"):t&&u.setAttrNullNS(this._elem,"class",t),this._className=t,this},addClassName:function(t){u.addClassName(this._elem,t),this._className=u.getAttrNullNS(this._elem,"class")},removeClassName:function(t){u.removeClassName(this._elem,t),this._className=u.getAttrNullNS(this._elem,"class")},getStyle:function(){return this._style},setStyle:function(t){return this._style&&u.removeAttrNullNS(this._elem,"style"),t&&j.applyCssObjectToElement(t,this._elem),this._style=t,this},setSolidFill:function(t,e){this.setFill(new K(t,e))},setInvisibleFill:function(){this.setFill(K.invisibleFill())},getStroke:function(){return this._stroke},setStroke:function(t){this._manageDefinitions(this._stroke,t),this._stroke=t;if(!t)return u.removeAttrNullNS(this._elem,"stroke"),u.removeAttrNullNS(this._elem,"stroke-opacity"),u.removeAttrNullNS(this._elem,"stroke-width"),u.removeAttrNullNS(this._elem,"stroke-dasharray"),u.removeAttrNullNS(this._elem,"stroke-dashoffset"),u.removeAttrNullNS(this._elem,"stroke-linejoin"),u.removeAttrNullNS(this._elem,"stroke-linecap"),void u.removeAttrNullNS(this._elem,"stroke-miterlimit");var e=T.fixColorForPlatform(t.getColor(),t.getAlpha());e&&e.color?(u.setAttrNullNS(this._elem,"stroke",e.color),null!=e.alpha&&u.setAttrNullNS(this._elem,"stroke-opacity",e.alpha,1)):(u.removeAttrNullNS(this._elem,"stroke"),u.removeAttrNullNS(this._elem,"stroke-opacity")),u.setAttrNullNS(this._elem,"stroke-width",t.getWidth(),1),t.isFixedWidth()&&u.setAttrNullNS(this._elem,"vector-effect","non-scaling-stroke");var i=t.getDashProps();i&&i.dashArray?u.setAttrNullNS(this._elem,"stroke-dasharray",i.dashArray):u.removeAttrNullNS(this._elem,"stroke-dasharray"),i&&i.dashOffset?u.setAttrNullNS(this._elem,"stroke-dashoffset",i.dashOffset):u.removeAttrNullNS(this._elem,"stroke-dashoffset");var n=t.getLineProps();n&&n.lineJoin?u.setAttrNullNS(this._elem,"stroke-linejoin",n.lineJoin):u.removeAttrNullNS(this._elem,"stroke-linejoin"),n&&n.lineCap?u.setAttrNullNS(this._elem,"stroke-linecap",n.lineCap):u.removeAttrNullNS(this._elem,"stroke-linecap"),n&&n.miterLimit?u.setAttrNullNS(this._elem,"stroke-miterlimit",n.miterLimit):u.removeAttrNullNS(this._elem,"stroke-miterlimit")},setSolidStroke:function(t,e,i){this.setStroke(new z(t,e,i))},_manageDefinitions:function(t,e){t!=e&&(t&&(t._referenceCount--,0==t._referenceCount&&t._defElem&&(this.getCtx().removeDefs(t._defElem),t._defPresent=!1)),e&&(e._referenceCount||(e._referenceCount=0),e._referenceCount++))}},q=function(){};i.createSubclass(q,i),q.ATTRS_TRANSFERABLE_TO_OUTER=["clip-path"],q.getDimensionsForced=function(t,e){var i,n=e.getParent();n&&(i=n.getChildIndex(e));var r=t.getStage();r.addChild(e);var o=e.getDimensions();return r.removeChild(e),n&&n.addChildAt(e,i),o},q.getSvgDimensions=function(t){try{var e=t.getBBox()}catch(t){return null}return new m(e.x,e.y,e.width,e.height)},q.getDimForced=function(t,e){if(e._dim||!t)return e._dim;var i=q.getDimensionsForced(t,e);return q._setDimForced(e,i),i},q._setDimForced=function(t,e){t._dim=e},q.hasAttributes=function(t,e){if(e)for(var i=e.length,n=0;n<i;n++)if(u.getAttrNullNS(t,e[n]))return!0;return!1};const Z={setTranslate:function(t,e){this._modifyMatrix(null,null,t,e)},getTranslateX:function(){var t=this.getMatrix();return t?t._decompose()[l._DECOMP_TX]:0},setTranslateX:function(t){this._modifyMatrix(null,null,t)},getTranslateY:function(){var t=this.getMatrix();return t?t._decompose()[l._DECOMP_TY]:0},setTranslateY:function(t){this._modifyMatrix(null,null,null,t)},setScale:function(t,e){this._modifyMatrix(t,e)},getScaleX:function(){var t=this.getMatrix();return t?t._decompose()[l._DECOMP_SX]:1},setScaleX:function(t){this._modifyMatrix(t)},getScaleY:function(){var t=this.getMatrix();return t?t._decompose()[l._DECOMP_SY]:1},setScaleY:function(t){this._modifyMatrix(null,t)},getRotation:function(){var t=this.getMatrix();return t?t._decompose()[l._DECOMP_R]:0},setRotation:function(t){this._modifyMatrix(null,null,null,null,t)},getMatrix:function(){return this._matrix?this._matrix:new l},setMatrix:function(t){if(t&&t.isIdentity()&&(t=null),this._matrix!=t)if(this._matrix=t,!this._outerElem&&q.hasAttributes(this.getElem(),q.ATTRS_TRANSFERABLE_TO_OUTER)&&this._createOuterGroupElem(),this._matrix=t,t){var e="matrix("+t.getA()+","+t.getC()+","+t.getB()+","+t.getD()+","+t.getTx()+","+t.getTy()+")";u.setAttrNullNS(this.getElem(),"transform",e,"matrix(1,0,0,1,0,0)")}else{u.getAttrNullNS(this.getElem(),"transform")&&(u.removeAttrNullNS(this.getElem(),"transform"),"ie"!==r.browser&&"edge"!==r.browser||u.setAttrNullNS(this.getElem(),"transform",null))}},_modifyMatrix:function(t,e,i,n,r){var o=this.getMatrix()._decompose(),s=o[l._DECOMP_SX],a=o[l._DECOMP_SY],h=o[l._DECOMP_TX],u=o[l._DECOMP_TY],c=o[l._DECOMP_R],_=!1;if(null!=t&&s!=t&&(o[l._DECOMP_SX]=t,_=!0),null!=e&&a!=e&&(o[l._DECOMP_SY]=e,_=!0),null!=i&&h!=i&&(o[l._DECOMP_TX]=i,_=!0),null!=n&&u!=n&&(o[l._DECOMP_TY]=n,_=!0),null!=r&&c!=r&&(o[l._DECOMP_R]=r,_=!0),_){var p=this.getMatrix();this.setMatrix(p._recompose(o))}}},Q=function(){};i.createSubclass(Q,i),Q.SET_ID_ON_DOM=!1,Q.prototype.Init=function(t,e,i){this._context=t,this._elem=A.createElement(e),this._elem._obj=this,this.setId(i),this._bVisible=!0,this._cursor=null,this._alpha=1,this._matrix=null,this._ariaProperties={},this._properties={}},Q.prototype.getCtx=function(){return this._context},Q.prototype.getElem=function(){return this._elem},Q.prototype.getOuterElem=function(){return this._outerElem?this._outerElem:this.getElem()},Q.prototype.getId=function(){return this._id},Q.prototype.setId=function(t,e){this._id!==t&&(t&&0===t.length&&(t=null),this._id=t,(Q.SET_ID_ON_DOM||e)&&(t?u.setAttrNullNS(this.getOuterElem(),"id",t):u.removeAttrNullNS(this.getOuterElem(),"id")))},Q.prototype.getParent=function(){return this._parent},Q.prototype.setParent=function(t){this._parent=t},Q.prototype.isDescendantOf=function(t){return!(!t||!this.getParent())&&(this.getParent()==t||this.getParent().isDescendantOf(t))},Q.prototype.setPixelHinting=function(t){t?u.setAttrNullNS(this._elem,"shape-rendering","crispEdges"):u.removeAttrNullNS(this._elem,"shape-rendering")},Q.prototype.getVisible=function(){return this._bVisible},Q.prototype.setVisible=function(t){if(this._bVisible!==t){this._bVisible=t;var e=this.getElem();t?u.removeAttrNullNS(e,"visibility"):u.setAttrNullNS(e,"visibility","hidden")}},Q.prototype.setClipPath=function(t){if(t){if(this.ClipPathId==t.getId())return;this.ClipPathId&&this._context.decreaseGlobalDefReference(this.ClipPathId),this.ClipPathId=t.getId(),this._context.increaseGlobalDefReference(this.ClipPathId),!this._outerElem&&this._matrix&&this._createOuterGroupElem();var e=t.getId();if(e){var i=this.getCtx();A.addClipPath(t,i)&&u.setAttrNullNS(this.getOuterElem(),"clip-path",u.getUrlById(e))}}else if(this.ClipPathId)return this._context.decreaseGlobalDefReference(this.ClipPathId),this.ClipPathId=null,void u.removeAttrNullNS(this.getOuterElem(),"clip-path")},Q.prototype.setMask=function(t){if(t){if(this.MaskId==t.getId())return;this.MaskId&&this._context.decreaseGlobalDefReference(this.MaskId),this.MaskId=t.getId(),this._context.increaseGlobalDefReference(this.MaskId),!this._outerElem&&this._matrix&&this._createOuterGroupElem();var e=t.getId();if(e){var i=this.getCtx();A.addMask(t,i)&&u.setAttrNullNS(this.getOuterElem(),"mask",u.getUrlById(e))}}else if(this.MaskId)return this._context.decreaseGlobalDefReference(this.MaskId),this.MaskId=null,void u.removeAttrNullNS(this.getOuterElem(),"mask")},Q.prototype.ConvertCoordSpaceRect=function(t,e){if(!e||e===this)return t;var i=this.localToStage(new n(t.x,t.y)),r=this.localToStage(new n(t.x+t.w,t.y+t.h)),o=e.stageToLocal(i),s=e.stageToLocal(r);return new m(Math.min(o.x,s.x),Math.min(o.y,s.y),Math.abs(s.x-o.x),Math.abs(s.y-o.y))},Q.prototype.GetSvgDimensions=function(){return q.getSvgDimensions(this.getElem())},Q.prototype.getDimensions=function(t){var e=this.GetSvgDimensions();return this.ConvertCoordSpaceRect(e,t)},Q.prototype.getDimensionsWithStroke=function(t){var e=this.GetDimensionsWithStroke();return this.ConvertCoordSpaceRect(e,t)},Q.prototype.GetDimensionsWithStroke=function(t){var e=this.GetElemDimensionsWithStroke();return t&&t!==this?this.ConvertCoordSpaceRect(e,t):e},Q.prototype.GetElemDimensionsWithStroke=function(){return this.GetSvgDimensions()},Q.TransferAttributes=function(t,e,i){if(i)for(var n,o,s=i.length,a=0;a<s;a++)n=i[a],(o=u.getAttrNullNS(t,n))&&(u.removeAttrNullNS(t,n),u.setAttrNullNS(e,n,o),"ie"!==r.browser&&"edge"!==r.browser||u.setAttrNullNS(t,n,null))},Q.prototype._createOuterGroupElem=function(){if(!this._outerElem){var t=this._id?this._id+"_outer":null;this._outerElem=A.createElement("g",t);var e=this.getParent();if(e)e.getElem().replaceChild(this._outerElem,this.getElem());u.appendChildElem(this._outerElem,this.getElem()),Q.TransferAttributes(this.getElem(),this._outerElem,q.ATTRS_TRANSFERABLE_TO_OUTER)}},Q.prototype.getCSSStyle=function(){return this._cssStyle},Q.prototype.setCSSStyle=function(t){this._cssStyle=t},Q.prototype.setCursor=function(t){this._cursor=t,t?u.setAttrNullNS(this.getElem(),"cursor",t):u.removeAttrNullNS(this.getElem(),"cursor")},Q.prototype.getCursor=function(){return this._cursor},Q.prototype.setMouseEnabled=function(t){var e=t?"visiblePainted":"none";u.setAttrNullNS(this.getElem(),"pointer-events",e)},Q.prototype.getAlpha=function(){return this._alpha},Q.prototype.setAlpha=function(t){t<1e-5&&(t=0),t!==this._alpha&&(this._alpha=t,u.setAttrNullNS(this.getElem(),"opacity",this._alpha,1))},Q.prototype.applyAriaProperties=function(){if(r.deferAriaCreation())for(var t in this._ariaRole&&this._setAriaRole(this._ariaRole),this._ariaProperties)this._setAriaProperty(t,this._ariaProperties[t])},Q.prototype.setAriaRole=function(t,e){r.deferAriaCreation()&&!e||this._setAriaRole(t),this._ariaRole=t},Q.prototype._setAriaRole=function(t){var e=this.GetAriaElem();t?u.setAttrNullNS(e,"role",t):u.removeAttrNullNS(e,"role")},Q.prototype.getAriaRole=function(){return this._ariaRole},Q.prototype.GetAriaElem=function(){return this.getElem()},Q.prototype.setAriaProperty=function(t,e,i){t&&(r.deferAriaCreation()&&!i||this._setAriaProperty(t,e),this._ariaProperties[t]=e)},Q.prototype._setAriaProperty=function(t,e){var i=this.GetAriaElem();null!=e&&""!==e?("label"===t&&(e=O.processAriaLabel(e)),u.setAttrNullNS(i,"aria-"+t,e)):u.removeAttrNullNS(i,"aria-"+t)},Q.prototype.getAriaProperty=function(t){return t?this._ariaProperties[t]:null},Q.prototype.stageToLocal=function(t){for(var e=this.getPathToStage(),i=t,n=e.length-1;n>=0;n--)i=e[n].getMatrix().invert().transformPoint(i);return i},Q.prototype.localToStage=function(t){for(var e=this.getPathToStage(),i=t,n=0;n<e.length;n++)i=e[n].getMatrix().transformPoint(i);return i},Q.prototype.getPathToStage=function(){for(var t=this,e=[];t;)e.push(t),t=t.getParent();return e},Q.prototype.removeFromParent=function(){this._parent&&this._parent.removeChild(this)},Q.prototype.destroy=function(){this.removeAllDrawEffects(),this.ClipPathId&&this.setClipPath(null)},Q.prototype.GetProperty=function(t){return this._properties[t]},Q.prototype.SetProperty=function(t,e){return e!==this._properties[t]&&(this._properties[t]=e),this},Q.prototype.SetSvgProperty=function(t,e,i){return e!==this._properties[t]&&(this._properties[t]=e,u.setAttrNullNS(this._elem,t,e,i),this.SvgPropertyChanged(t)),this},Q.defineProps=function(t,e){Object.keys(e).forEach(function(i){var n=e[i],r=n.name||i;r=r.charAt(0).toUpperCase()+r.slice(1),t.prototype["get"+r]=function(){return this.GetProperty(i)},t.prototype["set"+r]=function(t){return this.SetSvgProperty(i,t,n.value)}})},Q.prototype.SvgPropertyChanged=function(t){},Q.generateAriaLabel=function(t,e,i){var n=[],r=e&&e.length>0;return t&&n.push(Q.resolveShortDesc(t,i)),r&&n.push(e.join(O.ARIA_LABEL_STATE_DELIMITER)),n.join(O.ARIA_LABEL_DESC_DELIMITER)},Q.resolveShortDesc=function(t,e){return"function"==typeof t?t(e()):t},Object.assign(Q.prototype,x),Object.assign(Q.prototype,B),Object.assign(Q.prototype,X),Object.assign(Q.prototype,Z);const J=function(t,e,i,n){this.Init(t,e,i,n)};i.createSubclass(J,Q),J.prototype.Init=function(t,e,i,n){this._bShapeContainer=!!n,J.superclass.Init.call(this,t,null!=e?e:"g",i),this._childGroupElem=null},J.AttributesTransferableToGroup=["transform","opacity","visibility","pointer-events","clip-path","cursor"],J.prototype.addChild=function(t){if(t){var e=t.getParent();e&&e.removeChild(t),this._arList||(this._arList=[]),t.setParent(this),this._bShapeContainer&&this.CreateChildGroupElem(!1);var i=this.getContainerElem();u.appendChildElem(i,t.getOuterElem()),this._arList.push(t)}},J.prototype.addChildAt=function(t,e){this.AddChildAt(t,e)},J.prototype.AddChildAt=function(t,e){if(e>=0&&e<=this.getNumChildren()&&t){var i=this._findChild(t);if(i>=0&&i==e)return;var n=t.getParent();n&&n.removeChild(t),t.setParent(this),i>=0&&e==this.getNumChildren()+1&&e--;var r=e;this._bShapeContainer&&(this.CreateChildGroupElem(!1),r++);var o=this.getContainerElem(),s=o.childNodes[r];s||(s=null),o.insertBefore(t.getOuterElem(),s),this._arList||(this._arList=[]),this._arList.splice(e,0,t)}},J.prototype.contains=function(t){return this._findChild(t)>=0},J.prototype._findChild=function(t){var e=-1;if(this._arList)for(var i=this._arList.length,n=0;n<i;n++)if(this._arList[n]===t){e=n;break}return e},J.prototype.getChildAfter=function(t){var e=null,i=this._findChild(t);return i>=0&&++i<this._arList.length&&(e=this._arList[i]),e},J.prototype.getChildBefore=function(t){var e=null,i=this._findChild(t);return i>0&&(e=this._arList[i-1]),e},J.prototype.getChildAt=function(t){var e=null;return this._arList&&this._arList.length>t&&t>=0&&(e=this._arList[t]),e},J.prototype.getChildIndex=function(t){return this._findChild(t)},J.prototype.getNumChildren=function(){return this._arList?this._arList.length:0},J.prototype.removeChild=function(t){var e=this._findChild(t);-1!==e&&this._removeObj(t,e)},J.prototype.removeChildImpl=function(t){var e=t.getOuterElem(),i=t.getParent();e&&i&&this.getContainerElem().removeChild(e);if(!this._anchorElem&&this._bShapeContainer&&1===this.getNumChildren()){var n=this._childGroupElem,r=n?n.parentNode:null;r&&(Q.TransferAttributes(n,this._elem,this.GetAttributesTransferableToGroup()),r.replaceChild(this._elem,n),this._childGroupElem=null)}},J.prototype.removeChildAt=function(t){var e=this.getChildAt(t);return e&&this._removeObj(e,t),e},J.prototype.removeChildren=function(){if(this._arList)for(var t=this._arList;this.getNumChildren()>0;)this._removeObj(t[0],0)},J.prototype._removeObj=function(t,e){this.removeChildImpl(t),t.setParent(null),this._arList.splice(e,1),0===this._arList.length&&(this._arList=null)},J.prototype.destroy=function(){J.superclass.destroy.call(this);for(var t=this.getNumChildren(),e=0;e<t;e++){this.getChildAt(e).destroy()}},J.prototype.GetAttributesTransferableToGroup=function(){return J.AttributesTransferableToGroup},J.prototype.getElem=function(){return this._childGroupElem?this._childGroupElem:this._elem},J.prototype.CreateChildGroupElem=function(t,e){if(this._childGroupElem||!e&&0!==this.getNumChildren())t&&this.removeChildren();else{var i=Q.SET_ID_ON_DOM&&this._id?this._id+"_g":null;this._childGroupElem=A.createElement("g",i);var n=this.getParent();n&&n.getElem().replaceChild(this._childGroupElem,this._elem),t||u.appendChildElem(this._childGroupElem,this._elem),Q.TransferAttributes(this._elem,this._childGroupElem,this.GetAttributesTransferableToGroup()),this._elem._obj&&(this._childGroupElem._obj=this._elem._obj)}},J.prototype.getDimensions=function(t){if(!r.isEnvironmentTest()||0===this.getNumChildren()||!this.CanOptimizeDimensions())return J.superclass.getDimensions.call(this,t);let e=this._getDimensionsHelper(t=>t.getDimensions(this));if(this._bShapeContainer){const t=q.getSvgDimensions(this._elem);e=e.getUnion(t)}return this.ConvertCoordSpaceRect(e,t)},J.prototype.CanOptimizeDimensions=function(){return!0},J.prototype.getDimensionsWithStroke=function(){return this._getDimensionsHelper(t=>t.GetDimensionsWithStroke(this))},J.prototype._getDimensionsHelper=function(t){for(var e=[],i=this.getNumChildren(),n=0;n<i;n++)e.push(this.getChildAt(n));for(var r=null;e.length>0;){var o=e.shift(),s=t(o);if(s&&(r=r?r.getUnion(s):s),!o.includeChildSubtree||o.includeChildSubtree()){i=o.getNumChildren();for(var a=0;a<i;a++)e.push(o.getChildAt(a))}}return r},J.prototype.GetDimensionsWithStroke=function(t){return null},J.prototype.getContainerElem=function(){return this._anchorElem?this._anchorElem:this.getElem()},J.prototype.UpdateSelectionEffect=function(){},J.prototype.setHollow=function(t,e){for(var i=0;i<this.getNumChildren();i++){var n=this.getChildAt(i),r=n.getFill()?n.getFill().getColor():t;n.setHollow(r,e)}},J.prototype.includeChildSubtree=function(){return!0};const tt=function(t,e,i){this.Init(t,"g",i),this._SVGRoot=e,this.disableSelection(this._elem),this.setCursor("default")};i.createSubclass(tt,J),tt.prototype.addChild=function(t){tt.superclass.addChild.call(this,t)},tt.prototype.getSVGRoot=function(){return this._SVGRoot},tt.prototype.disableSelection=function(t){t.onselectstart=function(){return!1}};const et=function(t){this.Init(t)};i.createSubclass(et,i),et.prototype.Init=function(t){this._scheduledItems=new Array,this._bRunning=!1},et.prototype.HandleTimer=function(){for(var t=(new Date).getTime(),e=0;e<this._scheduledItems.length;e++){var n=this._scheduledItems[e];n.processTime(t)&&this.removeScheduled(n)}this._scheduledItems.length<1?(this._bRunning&&(this._bRunning=!1,this._animationRequestId&&_(this._animationRequestId)),this._animationRequestId=null):this._animationRequestId=c(i.createCallback(this,this.HandleTimer)),et._frameCount++},et.prototype.addScheduled=function(t){this._scheduledItems.indexOf(t)<0&&this._scheduledItems.push(t),this.play()},et.prototype.removeScheduled=function(t){var e=this._scheduledItems.indexOf(t);e>=0&&this._scheduledItems.splice(e,1)},et.prototype.play=function(){if(!this._bRunning){for(var t=0;t<this._scheduledItems.length;t++){var e=this._scheduledItems[t];e.isRunning()||e.play()}this._bRunning=!0,this._animationRequestId=c(i.createCallback(this,this.HandleTimer))}};const it=function(t,e){this.Init(t,e)};let nt;i.createSubclass(it,i),it._TOOLTIP_DIV_ID="_dvtTooltip",it._SHOW_DELAY=500,it._BORDER_COLOR="#9ba2b0",it._FONT_COLOR="#383a47",it._VIEWPORT_BUFFER=15,it.prototype.Init=function(t,e){this._context=t,this._domElementId=e||it._TOOLTIP_DIV_ID,this._isTooltip=!0},it.prototype.showDatatip=function(t,e,i,n,r){null==r&&(r=!0),this._isTooltip=!1,this._showTextAtPosition(t,e,i,n,r,"oj-dvt-datatip")},it.prototype._showTextAtPosition=function(t,e,i,n,r,o){var s,a=this.getTooltipElem(),h=!0!==i;if(h)for(;a.hasChildNodes();)a.removeChild(a.firstChild);"string"==typeof i?(i=(i=i.replace(/(<|&#60;)/g,"&lt;")).replace(/(>|&#62;)/g,"&gt;"),i=it._restoreTag(i,"b"),i=it._restoreTag(i,"i"),i=it._restoreTag(i,"table"),i=it._restoreTag(i,"tr"),i=(i=(i=(i=it._restoreTag(i,"td")).replace(/\n/g,"<br>")).replace(/\\n/g,"<br>")).replace(/&#92;n/g,"<br>"),i=it._restoreTag(i,"br"),(s=document.createElement("span")).style.visibility="inherit",s.style.width=null,s.style.height=null,s.innerHTML=i):h&&(s=i),this._isCustomClassName||(a.className=o),this._isCustomClassName=!1,n||(n=it._BORDER_COLOR),this._isCustomBorderColor||(a.style.borderColor=n),this._isCustomBorderColor=!1,a.style.position="absolute",a.style.zIndex=2147483647,null!=s&&(Array.isArray(s)?s.forEach(function(t){a.appendChild(t)}):a.appendChild(s)),this.PostElement(a,t,e,!0,r)},it.prototype.PostElement=function(t,e,i,n,r){if(t.style["pointer-events"]=n?"none":"auto",t.style.width=null,t.style.height=null,t.style.left="0px",t.style.top="0px",r){var o=this._getOffsets(t);this.positionTip(e+o.x,i+o.y,e,i)}else this.positionTip(e,i,e,i);t.style.visibility="visible";var s=this._context.getTooltipAttachedCallback();s&&s(t)},it.prototype.hideTooltip=function(){this.clearTooltip(),this._tooltipDisplayed=!1,this._timerIsRunning=!1;var t=document.getElementById(this._domElementId);t&&(t.style.visibility="hidden",t.style.overflow=null,t.style.width="0px",t.style.height="0px",r.isRightToLeft(this._context)?t.style.left=t.style.right:t.style.left="0px",t.style.top="0px","undefined"!=typeof $&&this._bCleanupChildren&&$(t).children().remove())},it.prototype.releaseTooltipResources=function(){var t=document.getElementById(this._domElementId);t&&this._getTooltipContainer().removeChild(t)},it.prototype.getTooltipElem=function(){var t=document.getElementById(this._domElementId);return t||(t=this.InitializeTooltipElem()),t},it.prototype._getTooltipContainer=function(){if(nt)return nt;if(nt=document.getElementById("_dvtTooltip_shared_container"),!nt){var t=document.createElement("div");t.id="_dvtTooltip_shared_container",document.body.appendChild(t),nt=t}return nt},it.prototype.InitializeTooltipElem=function(){var t=document.createElement("div");return t.id=this._domElementId,t.style.visibility="hidden",this._getTooltipContainer().appendChild(t),this.InitContent(t),t},it.prototype.InitContent=function(t){},it.prototype.showTooltip=function(t,e,i,n,o,s){i&&0!=i.length&&(this._x=t,this._y=e,this._text=i,this._trackMouse=o,this._timerIsRunning||(s||(s=it._BORDER_COLOR),this.getTooltipElem().style.borderColor=s,r.isTouchDevice()||this._tooltipDisplayed&&this._trackMouse?this._displayTooltip(this._x,this._y,this._text,this._borderColor):(this._timerIsRunning=!0,this._showTimerId=window.setTimeout(this._handleShowTimer.bind(this),it._SHOW_DELAY))))},it.prototype.clearTooltip=function(){this._showTimerId&&(window.clearTimeout(this._showTimerId),this._showTimerId=void 0,this._x=void 0,this._y=void 0,this._text=void 0,this._trackMouse=void 0),this._hideTimerId&&(window.clearTimeout(this._hideTimerId),this._hideTimerId=void 0)},it.prototype._handleShowTimer=function(t){this._timerIsRunning=!1,this._displayTooltip(this._x,this._y,this._text,this._borderColor),this._tooltipDisplayed=!0},it.prototype._displayTooltip=function(t,e,i,n){this._isTooltip=!0,this._showTextAtPosition(t,e,i,n,!0,"oj-dvt-tooltip")},it.prototype._getOffsets=function(t){var e=this.getTooltipBounds(t);if(r.isTouchDevice())return new n(0-e.w/2,-30-e.h);var i=-8-e.h,o=8;return this._isTooltip&&(i=22,o=0),r.isRightToLeft(this._context)&&(o=-o-e.w),new n(o,i)},it.prototype.getTooltipBounds=function(){var t=this.getTooltipElem();return t.style.height="auto",new m(parseInt(t.style.left),parseInt(t.style.top),t.offsetWidth,t.offsetHeight)},it.prototype.positionTip=function(t,e){var i=this.getTooltipElem(),n=this.getTooltipBounds(),r=n.w,o=n.h,s=new m(window.pageXOffset+it._VIEWPORT_BUFFER,window.pageYOffset+it._VIEWPORT_BUFFER,window.innerWidth-2*it._VIEWPORT_BUFFER,window.innerHeight-2*it._VIEWPORT_BUFFER);r>s.w-2*it._VIEWPORT_BUFFER&&(r=s.w-2*it._VIEWPORT_BUFFER,i.style.width=r+"px");var a=t;a=Math.max(a,s.x),a=Math.min(a,s.x+s.w-r),Math.abs(s.x)>it._VIEWPORT_BUFFER&&(i.style.width=Math.min(i.clientWidth,s.x+s.w-a)+"px",e+=o-i.offsetHeight,o=i.offsetHeight,i.style.overflow="hidden");var h=e;h=Math.min(h,s.y+s.h-o),h=Math.max(h,s.y),i.style.left=a+"px",i.style.top=h+"px"},it.prototype.getCustomTooltip=function(t,e){for(var i=this.getTooltipElem();i.hasChildNodes();)i.removeChild(i.firstChild);e.parentElement=i,i.className="",i.style.borderColor="";var n=t(e=this._context.fixRendererContext(e));return i.className&&(this._isCustomClassName=!0),i.style.borderColor&&(this._isCustomBorderColor=!0),this._bCleanupChildren=null!=e._templateCleanup,!(n||!i.hasChildNodes())||n},it._restoreTag=function(t,e){var i=new RegExp("&lt;(/?)("+e+")(?=[\\s&/])([^&]*)(/?)&gt;","g");return t.replace(i,"<$1"+e+"$3$4>")},it.createElement=function(t,e,i,n){var r=document.createElement(t);if(e&&e.applyStylesToElement(r),n&&r.classList.add.apply(r.classList,n),null!=i)if(Array.isArray(i))for(var o=0;o<i.length;o++)r.appendChild(i[o]);else r.appendChild(document.createTextNode(i));return r};const rt={};i.createSubclass(rt,i),rt.getHoverBorderColor=function(t){return T.adjustHSL(t,0,0,.15)},rt.createSelectingStroke=function(t){return new z(rt.getHoverBorderColor(t),1,2,!1,null,{miterLimit:1})},rt.getSelectingCursor=function(){return"pointer"};const ot=function(t,e,i){this.Init(t,e,i)};i.createSubclass(ot,J),ot.prototype.Init=function(t,e,i){ot.superclass.Init.call(this,t,e,i,!0),this._bSelectable=!1,this.IsSelected=!1,this.InnerShape=null,this.HoverInnerStroke=null,this.HoverOuterStroke=null,this.SelectedInnerStroke=null,this.SelectedOuterStroke=null,this.SelectedHoverInnerStroke=null,this.SelectedHoverOuterStroke=null,this.OriginalStroke=null,this._isOriginalStrokeSet=!1,this.IsShowingHoverEffect=!1,this._feedbackClassName=null},ot.prototype.setHollow=function(t,e){if(this._bHollow)this.setFill(this._origFill),this.setStroke(this._origStroke),this._bHollow=!1;else{this._origFill=this.GetProperty("fill"),this._origStroke=this.getStroke();var i,n=K.invisibleFill();i=t?new z(T.getRGB(t),T.getAlpha(t),e):new z(this.GetProperty("fill").getColor(),this.GetProperty("fill").getAlpha(),e),this.setFill(n),this.setStroke(i),this._bHollow=!0}},ot.prototype.isHollow=function(){return this._bHollow},ot.prototype.destroy=function(){ot.superclass.destroy.call(this),this.setFill(null),this.setStroke(null)},ot.prototype.getDimensionsWithStroke=function(){var t=this.GetElemDimensionsWithStroke(),e=ot.superclass.getDimensionsWithStroke.call(this);return t&&e?t=t.getUnion(e):e&&(t=e),t},ot.prototype.GetDimensionsWithStroke=function(t){var e=this.GetElemDimensionsWithStroke();return t&&t!==this?this.ConvertCoordSpaceRect(e,t):e},ot.prototype.GetElemDimensionsWithStroke=function(){var t=this.getDimensionsSelf&&this.getNumChildren()-this._getInnerShapeCount()==0?this.getDimensionsSelf():ot.superclass.getDimensions.call(this),e=this.getStroke();if(t&&e){var i=e.getWidth();if(i){var n=.5*i;t.x-=n,t.y-=n,t.w+=i,t.h+=i}}return t},ot.prototype.UpdateSelectionEffect=function(){var t;(this.isSelected()||this.isHoverEffectShown())&&(this.InnerShape&&(t=this.InnerShape.getStroke(),this.removeChild(this.InnerShape)),this.InnerShape=this.copyShape(),this.InnerShape._setOuterShape(this),this.InnerShape.setMouseEnabled(!1),this.InnerShape.setFill(this.getFill()),this.InnerShape.setStroke(t||this.getStroke()),this.InnerShape.setStyle(this.getStyle()).setClassName(this.getClassName()),this._feedbackClassName&&(this.InnerShape.removeClassName("oj-dvt-default-border-width"),this.InnerShape.removeClassName("oj-dvt-default-border-color"),this.InnerShape.removeClassName(this._feedbackClassName),this.InnerShape.addClassName(this._feedbackClassName+"-inner-shape")),this.InnerShape.setMouseEnabled(!1),this.InnerShape.setCursor(rt.getSelectingCursor()),this.AddChildAt(this.InnerShape,0))},ot.prototype._setOuterShape=function(t){this._outerShape=t},ot.prototype.GetHoverSelectionInnerStroke=function(){var t;return this.InnerShape&&(this.isSelected()?t=this.isHoverEffectShown()?this.SelectedHoverInnerStroke:this.SelectedInnerStroke:this.isHoverEffectShown()&&(t=this.HoverInnerStroke)),t},ot.prototype.GetHoverSelectionOuterStroke=function(){var t;return this._outerShape&&(this._outerShape.isSelected()?t=this._outerShape.isHoverEffectShown()?this._outerShape.SelectedHoverOuterStroke:this._outerShape.SelectedOuterStroke:this._outerShape.isHoverEffectShown()&&(t=this._outerShape.HoverOuterStroke)),t},ot.prototype.setHoverStroke=function(t,e){return this.HoverInnerStroke=t,this.HoverOuterStroke=e,this},ot.prototype.setSelectedStroke=function(t,e){return this.SelectedInnerStroke=t,this.SelectedOuterStroke=e,this},ot.prototype.setSelectedHoverStroke=function(t,e){return this.SelectedHoverInnerStroke=t,this.SelectedHoverOuterStroke=e,this},ot.prototype.setSelectable=function(t){this._bSelectable=t,this._bSelectable?this.setCursor(rt.getSelectingCursor()):this.setCursor(null)},ot.prototype.isSelectable=function(){return this._bSelectable},ot.prototype.isSelected=function(){return this.IsSelected},ot.prototype.setSelected=function(t){this.IsSelected!=t&&(this._isOriginalStrokeSet||(this._isOriginalStrokeSet=!0,this.OriginalStroke=this.getStroke()),this.IsSelected=t,this.isSelected()?(this.UpdateSelectionEffect(),this._feedbackClassName?(this.addClassName("oj-selected"),this.InnerShape.addClassName("oj-selected")):this.isHoverEffectShown()?(this.CreateSelectedHoverStrokes(),this.InnerShape.setStroke(this.SelectedHoverInnerStroke),this.setStroke(this.SelectedHoverOuterStroke)):(this.InnerShape.setStroke(this.SelectedInnerStroke),this.setStroke(this.SelectedOuterStroke))):(this._feedbackClassName&&(this.removeClassName("oj-selected"),this.InnerShape.removeClassName("oj-selected")),this.IsShowingHoverEffect?this._feedbackClassName||(this.InnerShape.setStroke(this.HoverInnerStroke),this.setStroke(this.HoverOuterStroke)):(this.removeChild(this.InnerShape),this.setStroke(this.OriginalStroke))))},ot.prototype.setFeedbackClassName=function(t){this.addClassName(t),this._feedbackClassName=t},ot.prototype.showHoverEffect=function(){this.IsShowingHoverEffect||(this.IsShowingHoverEffect=!0,this._isOriginalStrokeSet||(this._isOriginalStrokeSet=!0,this.OriginalStroke=this.getStroke()),this.UpdateSelectionEffect(),this._feedbackClassName?(this.addClassName("oj-hover"),this.InnerShape.addClassName("oj-hover")):this.isSelected()?(this.CreateSelectedHoverStrokes(),this.InnerShape.setStroke(this.SelectedHoverInnerStroke),this.setStroke(this.SelectedHoverOuterStroke)):(this.InnerShape.setStroke(this.HoverInnerStroke),this.setStroke(this.HoverOuterStroke)))},ot.prototype.CreateSelectedHoverStrokes=function(){this.SelectedHoverInnerStroke||(this.SelectedHoverInnerStroke=this.HoverInnerStroke),this.SelectedHoverOuterStroke||(this.SelectedHoverOuterStroke=new z(this.SelectedOuterStroke.getColor(),this.SelectedOuterStroke.getAlpha(),this.SelectedOuterStroke.getWidth()+(this.HoverInnerStroke.getWidth()-this.SelectedInnerStroke.getWidth())))},ot.prototype.hideHoverEffect=function(){this.IsShowingHoverEffect&&(this.IsShowingHoverEffect=!1,this._feedbackClassName&&(this.removeClassName("oj-hover"),this.InnerShape.removeClassName("oj-hover")),this.isSelected()?this._feedbackClassName||(this.InnerShape.setStroke(this.SelectedInnerStroke),this.setStroke(this.SelectedOuterStroke)):(this.removeChild(this.InnerShape),this.setStroke(this.OriginalStroke)))},ot.prototype.isHoverEffectShown=function(){return this.IsShowingHoverEffect},ot.prototype.addChildAt=function(t,e){ot.superclass.addChildAt.call(this,t,e+this._getInnerShapeCount())},ot.prototype.getChildAt=function(t,e){return ot.superclass.getChildAt.call(this,t,e+this._getInnerShapeCount())},ot.prototype.getChildIndex=function(t){return ot.superclass.getChildIndex.call(this,t)-this._getInnerShapeCount()},ot.prototype.removeChildAt=function(t){ot.superclass.removeChildAt.call(this,t+this._getInnerShapeCount())},ot.prototype.getDimensions=function(t){return this.getDimensionsSelf&&this.getNumChildren()-this._getInnerShapeCount()==0?this.getDimensionsSelf(t):ot.superclass.getDimensions.call(this,t)},ot.prototype._getInnerShapeCount=function(){return this.isSelected()||this.isHoverEffectShown()?1:0},ot.prototype.SvgPropertyChanged=function(t){this.UpdateSelectionEffect()},ot.prototype.copyShape=function(){return null};const st={};i.createSubclass(st,i),st._cachedTextWidth={},st._cachedRepTextDimensions={},st._canvasCtx=null,st._wordSpacing,st._letterSpacing,st._fontVariantNumeric,st.EMPTY_TEXT_BUFFER=2,st.ELLIPSIS="…",st.REPRESENTATIVE_TEXT="MW",st.V_ALIGN_TOP="top",st.V_ALIGN_MIDDLE="middle",st.V_ALIGN_CENTRAL="central",st.V_ALIGN_BOTTOM="bottom",st.V_ALIGN_AUTO="auto",st._rep_text_constructor=null,st.getMaxTextDimensions=function(t){for(var e=0,i=0,n=0;n<t.length;n++)if(null!=t[n]){var r=t[n].getDimensions();e=Math.max(e,r.w),i=Math.max(i,r.h)}return new h(e,i)},st.getMaxTextStringWidth=function(t,e,i){for(var n=0,r=Array.isArray(i),o=0;o<e.length;o++)if(null!=e[o]&&0!=e[o].length){var s=i?r?i[o]:i:null,a=st.getTextStringWidth(t,e[o],s);a>n&&(n=a)}return n},st.getTextStringDimensions=function(t,e,i){var n=st._getRepresentativeDimensions(t,i);return new m(0,n.y,st.getTextStringWidth(t,e,i),n.h)},st.getTextStringWidth=function(t,e,i){if(null==e||0==e.length)return 0;var n=t.letterSpacing||"normal",o=t.wordSpacing||"normal",s=t.fontVariantNumeric||"normal",a=st._createCacheKey(t,i,e),h=st._cachedTextWidth[a];if(null!=h)return h;var l,u=st._isNormalSpacing(n),c=st._isNormalSpacing(o);if(u&&c&&"normal"===s){var _=st._wordSpacing||st._letterSpacing||st._fontVariantNumeric;st._storeCanvasContext(_),st._setSpacing(null,null,null),l=st._getCanvasTextWidth(t,e,i)}else if("chrome"===r.browser)st._letterSpacing==n&&st._wordSpacing==o&&st._fontVariantNumeric==s||(st._clearCanvasContext(),st._setSpacing(o,n,s)),st._storeCanvasContext(),st._attachCanvas(t),l=st._getCanvasTextWidth(t,e,i);else if("safari"===r.browser&&u&&c)st._fontVariantNumeric!=s&&(st._clearCanvasContext(),st._setSpacing(o,n,s)),st._storeCanvasContext(),st._attachCanvas(t),l=st._getCanvasTextWidth(t,e,i);else{var p=new st._rep_text_constructor(t,e);p.setCSSStyle(i);var d=p.getCtx().getStage();d.addChild(p),l=p.GetSvgDimensions().w,d.removeChild(p)}return st._cachedTextWidth[a]=l,l},st._isNormalSpacing=function(t){return"normal"===t||"0px"===t},st._setSpacing=function(t,e,i){st._wordSpacing=t,st._letterSpacing=e,st._fontVariantNumeric=i},st._storeCanvasContext=function(t){var e=st._canvasCtx?st._canvasCtx.canvas:null;e?t&&(st._canvasCtx=st._canvasCtx.canvas.getContext("2d")):(e=document.createElement("CANVAS"),st._canvasCtx=e.getContext("2d"))},st._clearCanvasContext=function(){if(st._canvasCtx){var t=st._canvasCtx.canvas;t.parentNode&&t.parentNode.removeChild(t),st._canvasCtx=null}},st._attachCanvas=function(t){var e=st._canvasCtx.canvas;e.parentNode||(e.style.display="none",t.getContainer().appendChild(e),st._canvasCtx=e.getContext("2d"))},st._createCacheKey=function(t,e,i){return(i||"")+(null!=e?e.hashCodeForTextMeasurement():"")+t.letterSpacing+t.wordSpacing+t.fontVariantNumeric},st.getTextStringHeight=function(t,e){return st._getRepresentativeDimensions(t,e).h},st.fitText=function(t,e,i,n,r,o){var s=t.getTextString();if(!t.hasBackground()&&!t.isMultiline()){var a=st.getTextStringDimensions(t.getCtx(),s,t.getCSSStyle());if(a.h>i)return o||t.removeFromParent(),!1;if(a.w<=e)return n.addChild(t),!0}if(n.addChild(t),r="number"!=typeof r||null==r?1:r,t.isMultiline())return t.__fitText(e,i,r);if(t.isMultiline())throw t.setMaxWidth(e,r),new Error("TextUtils.fitText called with a non-text class");return st._truncateOutputText(t,e,r),""==t.getTextString()?(o||n.removeChild(t),t.setTextString(s),!1):(t.getTextString()!=s&&t.setUntruncatedTextString(s),!0)},st.centerTextVertically=function(t,e){"ie"===r.browser||"edge"===r.browser?(t.setY(e),t.alignMiddle()):t.setY(e-t.getDimensions().h/2)},st._truncateOutputText=function(t,e,i){if(e<=0)t.setTextString("");else{var n=t.getDimensions();if(!(n.w<=e)){var r=t.getTextString(),o=r.length,s=n.w/st._getTextLength(r),a=Math.max(Math.floor(e/s)-2,i),h=r.substring(0,a)+st.ELLIPSIS;t.setTextString(h);for(var l=h,u=n=t.getDimensions();n.w<e&&!(a>=r.length);){var c=e-n.w,_=Math.min(o-a,Math.max(Math.floor(c/s),1));if(a+=_,h=r.substring(0,a)+st.ELLIPSIS,t.setTextString(h),n=t.getDimensions(),1==_&&n.w>e){t.setTextString(l),n=u;break}l=h,u=n}for(;n.w>e;){if(a<=i){t.setTextString("");break}a-=1,h=r.substring(0,a)+st.ELLIPSIS,t.setTextString(h),n=t.getDimensions()}}}},st._getTextLength=function(t){return(t=t.replace(/[\u200A\u200B\u200C\u200D\u200E\u200F\uFEFF]/g,"")).length},st._getRepresentativeDimensions=function(t,e){var i=st._createCacheKey(t,e),n=st._cachedRepTextDimensions[i];if(null==n){var r=new st._rep_text_constructor(t,st.REPRESENTATIVE_TEXT);r.alignAuto(),r.setCSSStyle(e);var o=r.getCtx().getStage();o.addChild(r);var s=r.GetSvgDimensions();o.removeChild(r),n={x:s.x,y:s.y,w:.5*s.w,h:s.h},st._cachedRepTextDimensions[i]=n}return n},st.setRepresentativeTextConstructor=function(t){st._rep_text_constructor=t},st.getBaselineTranslation=function(t){var e=t.getVertAlignment();if(e!=st.V_ALIGN_AUTO){var i=st._getRepresentativeDimensions(t.getCtx(),t.getCSSStyle());if(e==st.V_ALIGN_TOP)return-i.y;if(e==st.V_ALIGN_MIDDLE)return-i.y-i.h/2;if(e==st.V_ALIGN_CENTRAL)return-i.y/2;if(e==st.V_ALIGN_BOTTOM)return-i.y-i.h}return 0},st._getCanvasTextWidth=function(t,e,i){var n=(i?i.getStyle("font-style"):null)||"normal",r=(i?i.getStyle("font-variant"):null)||"normal",o=(i?i.getStyle("font-weight"):null)||"normal",s=(i?i.getStyle("font-family"):null)||t.getDefaultFontFamily()||"",a=(i?i.getFontSize():null)||t.getDefaultFontSize()||"12px";isNaN(a)||(a+="px");var h=n+" "+r+" "+o+" "+a+" "+s;return st._configureCanvas(t,h),st._canvasCtx.measureText(e).width},st._configureCanvas=function(t,e){"ie"!==r.browser&&"edge"!==r.browser||(e=e.replace(/-apple-system(-\w+)*,?/g,""),st._attachCanvas(t)),st._canvasCtx.font=e},st.clearCaches=function(){st._cachedTextWidth={},st._cachedRepTextDimensions={}},st.getOptimalFontSize=function(t,e,i,n){i=i?i.clone():new j;for(var r=Math.max(Math.round(Math.min(n.w/e.length,n.h/2)),9);r<51;r+=1){i.setFontSize("font-size",r+"px",t);var o=st.getTextStringDimensions(t,e,i);if(o.w>n.w||o.h>n.h)return Math.min(r-1,50)+"px"}return"50px"};const at=function(t,e,i,n,r){this.Init(t,e,i,n,r)};var ht;st.setRepresentativeTextConstructor(at),i.createSubclass(at,ot),at.ELLIPSIS=st.ELLIPSIS,at.REPRESENTATIVE_TEXT=st.REPRESENTATIVE_TEXT,at.BIDI_ZERO_WIDTH="​",at.H_ALIGN_LEFT="left",at.H_ALIGN_CENTER="center",at.H_ALIGN_RIGHT="right",at.TEXT_ANCHOR="text-anchor",at.V_ALIGN_TOP=st.V_ALIGN_TOP,at.V_ALIGN_MIDDLE=st.V_ALIGN_MIDDLE,at.V_ALIGN_CENTRAL=st.V_ALIGN_CENTRAL,at.V_ALIGN_BOTTOM=st.V_ALIGN_BOTTOM,at.V_ALIGN_AUTO=st.V_ALIGN_AUTO,at.prototype.Init=function(t,e,i,n,o){at.superclass.Init.call(this,t,"text",o),this._x=null!=i?i:0,this._baseline=!1,!r.isRightToLeft(t)||"ie"!==r.browser&&"edge"!==r.browser||u.setAttrNullNS(this.getElem(),"unicode-bidi","embed"),this.alignLeft(),this.alignTop(),this.setTextString(e),this.setX(i),this.setY(n),u.removeAttrNullNS(this.getElem(),"fill"),this.setAriaProperty("hidden","true")},at.prototype.getTextString=function(){return this._textString},at.prototype.setTextString=function(t){t=null!=t?String(t).trim():"",!this._needsTextAnchorAdjustment()||"ie"!==r.browser&&"edge"!==r.browser||t.charAt(0)==at.BIDI_ZERO_WIDTH||(t=at.BIDI_ZERO_WIDTH+t),this._textString=t;var e=this.getElem().firstChild;return null!==e?e.nodeValue=t:(e=document.createTextNode(t),u.appendChildElem(this.getElem(),e)),"ie"!==r.browser&&"edge"!==r.browser||this.setX(this._x),this},at.prototype.isTruncated=function(){return null!=this.getUntruncatedTextString()},at.prototype.getUntruncatedTextString=function(){return this._untruncatedTextString},at.prototype.setUntruncatedTextString=function(t){t!=this.getTextString()&&(this._untruncatedTextString=t)},at.prototype.getX=function(){return("ie"===r.browser||"edge"===r.browser?this._x:this.GetProperty("x"))||0},at.prototype.setX=function(t){return this._x=null!=t?t:0,"ie"===r.browser||"edge"===r.browser?this.SetSvgProperty("x",this._x+this._getIEAlignmentOffset(),0):this.SetSvgProperty("x",t,0)},at.prototype._getIEAlignmentOffset=function(){var t=this.getHorizAlignment(),e=r.isRightToLeft(this.getCtx());return t==at.H_ALIGN_LEFT?e?st.getTextStringWidth(this.getCtx(),this.getTextString(),this.getCSSStyle()):0:t==at.H_ALIGN_CENTER?e?st.getTextStringWidth(this.getCtx(),this.getTextString(),this.getCSSStyle())/2:st.getTextStringWidth(this.getCtx(),this.getTextString(),this.getCSSStyle())/2*-1:t==at.H_ALIGN_RIGHT?e?0:-1*st.getTextStringWidth(this.getCtx(),this.getTextString(),this.getCSSStyle()):0},at.prototype.getY=function(){var t=this.GetProperty("y");return t||0},at.prototype.setY=function(t){return this.SetSvgProperty("y",t,0)},at.prototype.setFontSize=function(t){var e=this.getCSSStyle();(e=e?e.clone():new j).setFontSize(j.FONT_SIZE,String(t),this.getCtx()),this.setCSSStyle(e)},at.prototype.getHorizAlignment=function(){return this._horizAlign},at.prototype.setHorizAlignment=function(t){t==at.H_ALIGN_LEFT?this.alignLeft():t==at.H_ALIGN_CENTER?this.alignCenter():t==at.H_ALIGN_RIGHT&&this.alignRight()},at.prototype.getVertAlignment=function(){return this._vertAlign},at.prototype.setVertAlignment=function(t){t==at.V_ALIGN_TOP?this.alignTop():t==at.V_ALIGN_MIDDLE?this.alignMiddle():t==at.V_ALIGN_CENTRAL?this.alignCentral():t==at.V_ALIGN_BOTTOM?this.alignBottom():t==at.V_ALIGN_AUTO&&this.alignAuto()},at.prototype.alignLeft=function(){if(this._horizAlign!=at.H_ALIGN_LEFT)if(this._horizAlign=at.H_ALIGN_LEFT,"ie"===r.browser||"edge"===r.browser)this.setX(this._x);else{var t=this._needsTextAnchorAdjustment();u.setAttrNullNS(this.getElem(),at.TEXT_ANCHOR,t?"end":"start","start")}},at.prototype.alignCenter=function(){this._horizAlign!=at.H_ALIGN_CENTER&&(this._horizAlign=at.H_ALIGN_CENTER,"ie"===r.browser||"edge"===r.browser?this.setX(this._x):u.setAttrNullNS(this.getElem(),at.TEXT_ANCHOR,"middle","start"))},at.prototype.alignRight=function(){if(this._horizAlign!=at.H_ALIGN_RIGHT)if(this._horizAlign=at.H_ALIGN_RIGHT,"ie"===r.browser||"edge"===r.browser)this.setX(this._x);else{var t=this._needsTextAnchorAdjustment();u.setAttrNullNS(this.getElem(),at.TEXT_ANCHOR,t?"start":"end","start")}},at.prototype.alignTop=function(){this._vertAlign!=at.V_ALIGN_TOP&&(this._vertAlign==at.V_ALIGN_BOTTOM&&"safari"===r.browser&&this._setBaseline(!1),this._vertAlign=at.V_ALIGN_TOP,"ie"===r.browser||"edge"===r.browser?this._setBaseline(!0):this.SetDominantBaselineAttr("text-before-edge"))},at.prototype.alignMiddle=function(){this._vertAlign!=at.V_ALIGN_MIDDLE&&(this._vertAlign==at.V_ALIGN_BOTTOM&&"safari"===r.browser&&this._setBaseline(!1),this._vertAlign=at.V_ALIGN_MIDDLE,"ie"===r.browser||"edge"===r.browser?this._setBaseline(!0):this.SetDominantBaselineAttr("middle"))},at.prototype.alignCentral=function(){this._vertAlign!=at.V_ALIGN_CENTRAL&&(this._vertAlign==at.V_ALIGN_BOTTOM&&"safari"===r.browser&&this._setBaseline(!1),this._vertAlign=at.V_ALIGN_CENTRAL,"ie"===r.browser||"edge"===r.browser?this._setBaseline(!0):this.SetDominantBaselineAttr("central"))},at.prototype.alignBottom=function(){this._vertAlign!=at.V_ALIGN_BOTTOM&&(this._vertAlign=at.V_ALIGN_BOTTOM,"ie"===r.browser||"edge"===r.browser?this._setBaseline(!0):"safari"===r.browser?(this._setBaseline(!0),this.SetDominantBaselineAttr(null)):this.SetDominantBaselineAttr("text-after-edge"))},at.prototype.alignAuto=function(){this._vertAlign!=at.V_ALIGN_AUTO&&(this._vertAlign==at.V_ALIGN_BOTTOM&&"safari"===r.browser&&this._setBaseline(!1),this._vertAlign=at.V_ALIGN_AUTO,"ie"===r.browser||"edge"===r.browser?this._setBaseline(!1):this.SetDominantBaselineAttr(null))},at.prototype._setBaseline=function(t){this._baseline=t,this.setMatrix(this.getMatrix())},at.prototype.SetDominantBaselineAttr=function(t){t?u.setAttrNullNS(this.getElem(),"dominant-baseline",t):u.removeAttrNullNS(this.getElem(),"dominant-baseline")},at.prototype.setCSSStyle=function(t){at.superclass.setCSSStyle.call(this,t);var e=this.getOuterElem();if(t){var i=t.getStyle("color"),n=T.fixColorForPlatform(i);n&&n.color&&(u.setAttrNullNS(e,"fill",n.color),null!=n.alpha&&u.setAttrNullNS(e,"fill-opacity",n.alpha,1));const o="font-family";(i=t.getStyle(o))&&!this.getCtx().isDefaultFontFamily(i)?u.setAttrNullNS(e,o,i):u.removeAttrNullNS(e,o),(i=t.getStyle("font-size"))&&i!=this.getCtx().getDefaultFontSize()?(u.setAttrNullNS(e,"font-size",i),"ie"!==r.browser&&"edge"!==r.browser&&"safari"!==r.browser||this.setMatrix(this.getMatrix())):u.removeAttrNullNS(e,"font-size"),(i=t.getStyle("font-style"))&&u.setAttrNullNS(e,"font-style",i);const s="font-weight";(i=t.getStyle(s))&&i!=this.getCtx().getDefaultFontWeight()?u.setAttrNullNS(e,s,i):u.removeAttrNullNS(e,s),(i=t.getStyle("text-decoration"))&&u.setAttrNullNS(e,"text-decoration",i),(i=t.getStyle("cursor"))&&u.setAttrNullNS(e,"cursor",i),"ie"!==r.browser&&"edge"!==r.browser||this.setX(this._x)}},at.prototype._getBaselineTranslation=function(){if(this._baseline){if(this._textString&&!this._isRepresentativeText())return st.getBaselineTranslation(this);var t=this.getVertAlignment();if(t!=at.V_ALIGN_AUTO){var e=u.getAttrNullNS(this.getElem(),"font-size");if(e||(e=u.getAttrNullNS(this.getOuterElem(),"font-size")),(!e||isNaN(e)&&-1==e.indexOf("px"))&&(e=this.getCtx().getDefaultFontSize()),e=parseFloat(e),t==at.V_ALIGN_TOP)return.8*e;if(t==at.V_ALIGN_MIDDLE)return.3*e;if(t==at.V_ALIGN_CENTRAL)return.4*e;if(t==at.V_ALIGN_BOTTOM)return-.2*e}}return 0},at.prototype._getBaselineAdjustedMatrix=function(t){this._baseline&&(t||(t=new l),t=new l(null,null,null,null,null,this._getBaselineTranslation()).concat(t));return t},at.prototype.setMatrix=function(t){"ie"!==r.browser&&"edge"!==r.browser&&"safari"!==r.browser||(this._matrixForIE=t,t=this._getBaselineAdjustedMatrix(t)),at.superclass.setMatrix.call(this,t)},at.prototype.getMatrix=function(){var t=null;return"ie"!==r.browser&&"edge"!==r.browser&&"safari"!==r.browser||(t=this._matrixForIE),t||(t=at.superclass.getMatrix.call(this)),t},at.prototype._isRepresentativeText=function(){return this._textString==at.REPRESENTATIVE_TEXT||this._textString==at.BIDI_ZERO_WIDTH||this._textString==at.BIDI_ZERO_WIDTH+at.REPRESENTATIVE_TEXT},at.prototype.GetSvgDimensions=function(){var t=at.superclass.GetSvgDimensions.call(this);return t&&(t.y+=this._getBaselineTranslation(),this._isRepresentativeText()||(t.h=st.getTextStringHeight(this.getCtx(),this.getCSSStyle()))),t},at.prototype.UpdateSelectionEffect=function(){},at.prototype.getDimensions=function(t){var e=this.getHorizAlignment(),i=this.getVertAlignment(),n=st.getTextStringDimensions(this.getCtx(),this.getTextString(),this.getCSSStyle());return n.x=this.getX(),e===at.H_ALIGN_RIGHT?n.x-=n.w:e===at.H_ALIGN_CENTER&&(n.x-=n.w/2),i===at.V_ALIGN_TOP?n.y=this.getY():i===at.V_ALIGN_BOTTOM?n.y=this.getY()-n.h:i===at.V_ALIGN_MIDDLE?n.y=this.getY()-n.h/2:i===at.V_ALIGN_CENTRAL?n.y=this.getY()-.4*n.h:i===at.V_ALIGN_AUTO&&(n.y+=this.getY()),t&&t!==this?this.ConvertCoordSpaceRect(n,t):n},at.prototype.copyShape=function(){var t=new at(this.getCtx(),this.getTextString(),this.getX(),this.getY());return t.setCSSStyle(this.getCSSStyle()),t.setHorizAlignment(this.getHorizAlignment()),t.setVertAlignment(this.getVertAlignment()),t},at.prototype._needsTextAnchorAdjustment=function(){return r.isRightToLeft(this.getCtx())},at.createIcon=(ht={},function(t,e){var i=e.style,n=e.size,o=e.pos||{x:n/2,y:n/2},s=new at(t,i.character);if(s.setClassName("oj-fwk-icon oj-dvt-icon"),s.getElem().style.fontSize=n+"px","ie"===r.browser||"edge"===r.browser){s.SetSvgProperty("x",0,0);var a="ie"===r.browser?.8*n:function(t,e,i){if(!ht[e]){var n=new at(t,i);n.setClassName("oj-fwk-icon oj-dvt-icon"),n.getElem().style.fontSize=e+"px",n.alignAuto();var r=t.getStage();r.addChild(n);var o=n.GetSvgDimensions();r.removeChild(n),ht[e]=-o.y}return ht[e]}(t,n,i.character),h=r.isRightToLeft(t),u=new l(1,0,0,1,h?n/2:-n/2,a-n/2);at.superclass.setMatrix.call(s,u.concat(i.transform).translate(o.x,o.y))}else s.alignCenter(),s.alignCentral(),s.setMatrix(i.transform.translate(o.x,o.y));return s}),at.prototype.isMultiline=function(){return!1},at.prototype.hasBackground=function(){return!1};const lt=function(t,e,i,n,r,o){this.Init(t,e,i,n,r,o)};i.createSubclass(lt,ot),lt._cssAttrs=["background-color","border-color","border-width"],lt.prototype.Init=function(t,e,i,n,r,o){lt.superclass.Init.call(this,t,"rect",o),this._strokeAlignment="center",this.setX(e).setY(i).setWidth(n).setHeight(r)},Q.defineProps(lt,{x:{value:0},y:{value:0},width:{value:0},height:{value:0},rx:{},ry:{}}),lt.prototype.setCSSStyle=function(t){lt.superclass.setCSSStyle.call(this,t);var e=this._elem;if(t){var i=t.getStyle("background-color");if(i&&u.setAttrNullNS(e,"fill",i),(i=t.getStyle("border-color"))&&u.setAttrNullNS(e,"stroke",i),(i=t.getStyle("border-width"))&&u.setAttrNullNS(e,"stroke-width",i),i=t.getStyle("border-radius")){var n=i.trim().split(" ");n.length>0&&n[0]&&this.setRx(n[0]),n.length>1&&n[1]&&this.setRy(n[1])}}else u.removeAttrNullNS(this._elem,"style")},lt.prototype.SetSvgProperty=function(t,e,i){return e!==this.GetProperty(t)&&(this.SetProperty(t,e),this._setAttributeWithStroke(t,e,i),this.SvgPropertyChanged(t)),this},lt.prototype._setAttributeWithStroke=function(t,e,i){if(null!=e&&"center"!=this._strokeAlignment){var n=this._getStrokeOffset();switch(t){case"x":case"y":e-=n;break;case"width":case"height":e+=2*n}}u.setAttrNullNS(this._elem,t,e,i)},lt.prototype.setStrokeAlignment=function(t){this._strokeAlignment!=t&&(this._strokeAlignment=t,this._updateElemStrokeDimensions())},lt.prototype.getStrokeAlignment=function(){return this._strokeAlignment},lt.prototype._updateElemStrokeDimensions=function(){this._setAttributeWithStroke("x",this.getX(),0),this._setAttributeWithStroke("y",this.getY(),0),this._setAttributeWithStroke("width",this.getWidth()),this._setAttributeWithStroke("height",this.getHeight())},lt.prototype._getStrokeOffset=function(){var t=0,e=this.getStroke();if(e)if("outer"==this._strokeAlignment){t=e.getWidth()/2;var i=this.GetHoverSelectionInnerStroke();null!=i&&(t+=i.getWidth())}else if("inner"==this._strokeAlignment){t=-e.getWidth()/2;var n=this.GetHoverSelectionOuterStroke();null!=n&&(t-=n.getWidth())}return t},lt.prototype.setStroke=function(t){lt.superclass.setStroke.call(this,t),"center"!=this._strokeAlignment&&this._updateElemStrokeDimensions()},lt.prototype.GetElemDimensionsWithStroke=function(){var t=lt.superclass.GetElemDimensionsWithStroke.call(this);if(t&&"center"!=this._strokeAlignment){var e=this._getStrokeOffset();t.x-=e,t.y-=e,t.w+=2*e,t.h+=2*e}return t},lt.prototype.setCornerRadius=function(t,e){this.setRx(t).setRy(e)},lt.prototype.setRect=function(t,e,i,n){t instanceof m?this.setX(t.x).setY(t.y).setWidth(t.w).setHeight(t.h):this.setX(t).setY(e).setWidth(i).setHeight(n)},lt.prototype.copyShape=function(){var t=new lt(this.getCtx(),this.getX(),this.getY(),this.getWidth(),this.getHeight());return t.setRx(this.getRx()).setRy(this.getRy()),t.setStrokeAlignment(this.getStrokeAlignment()),t},lt.prototype.getDimensionsSelf=function(t){var e=new m(this.getX(),this.getY(),this.getWidth(),this.getHeight());return this.ConvertCoordSpaceRect(e,t)};const ut=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass(ut,i),ut.prototype.Init=function(t,e,i,n,r){this._interval=e,this._callback=i,this._callbackObj=n,this._repeatCount=r,this._bRunning=!1,this._numIterations=0},ut.prototype.start=function(){this._bRunning||(this._bRunning=!0,this.StartTimer())},ut.prototype.stop=function(){this._bRunning&&(this._bRunning=!1,this.StopTimer())},ut.prototype.reset=function(){this._bRunning&&this.stop(),this._numIterations=0},ut.prototype.isRunning=function(){return this._bRunning},ut.prototype.HandleTimer=function(){this._callback&&(this._callback.call(this._callbackObj),this._repeatCount&&(this._numIterations++,this._numIterations>=this._repeatCount&&this.stop()))},ut.prototype.setInterval=function(t){var e=t;e<0&&(e=0);var i=this._bRunning;i&&this.stop(),this._interval=e,i&&this.start()},ut.prototype.getInterval=function(){return this._interval},ut.prototype.StartTimer=function(){var t=this,e=this.HandleTimer;this._timerId=window.setInterval(function(){e.call(t)},this.getInterval())},ut.prototype.StopTimer=function(){this._timerId&&(window.clearInterval(this._timerId),this._timerId=null)};const ct=function(t,e){this._Init(t,e)};i.createSubclass(ct,J),ct.DEFAULT_BORDER_COLOR="gray",ct.DEFAULT_BACKGROUND_COLOR="#ffffff",ct.prototype._Init=function(t,e){this._context=t,ct.superclass.Init.call(this,t),this._tooltipText=null,this._tooltipBorderColor=null,this._menuFontSize=11,this._tooltipFill=new K(ct.DEFAULT_BACKGROUND_COLOR),this._fontSize=11},ct.prototype.getRootDisplayable=function(){return this},ct.prototype.UpdateTooltipSize=function(t,e){this._displayWidth=t,this._displayHeight=e},ct.prototype.getDisplayWidth=function(){return this._displayWidth},ct.prototype.getDisplayHeight=function(){return this._displayHeight},ct.prototype.clearContent=function(){this.clearMenuItems(),this.setTooltipBorderColor(null),this.setTooltipText(null)},ct.prototype.setTooltipBorderColor=function(t){this._tooltipBorderColor=t},ct.prototype.getTooltipBorderColor=function(){return this._tooltipBorderColor},ct.prototype.setTooltipText=function(t){this._tooltipText=t},ct.prototype.addMenuItem=function(t){this.getMenuItems().push(t)},ct.prototype.hasMenuItems=function(){var t=this.getMenuItems();return t&&t.length>0},ct.prototype.clearMenuItems=function(){this._menuItems&&(this._menuItems=[])},ct.prototype.getMenuItems=function(){return this._menuItems||(this._menuItems=new Array),this._menuItems},ct.prototype.containsMenuId=function(t){for(var e=this.getMenuItems(),i=0;i<e.length;i++){if(e[i].getId()==t)return!0}return!1},ct.prototype.Render=function(){var t=this.getRootDisplayable();if(t.removeChildren(),this.hasMenuItems()){var e=0,i=0;t.setAlpha(1);var n=new Array,r=new Array;e+=2.5;for(var o=this.getMenuItems(),s=0;s<o.length;s++){var a=o[s],h=new at(this._context,a.getText(),0,0,null);h.alignBottom(),h.setFontSize(this._menuFontSize),h._menu=a;var l=h.getDimensions();l.y=5+e;var u=l.w;r.push(l),i=Math.max(u+21+10,i),h.setY(l.y),e+=l.h,s<o.length-1&&(e+=5),n.push(h),h.alignLeft(),h.alignTop()}var c=i+8+2,_=5+(e+=2.5)+4+1;this.UpdateTooltipSize(c+2,_+2),t.setTranslate(1,1);var p=new lt(this._context,0,0,c,_);p.setSolidStroke("rgb(229,232,238)"),p.setFill(this._tooltipFill),t.addChildAt(p,0);for(s=0;s<n.length;s++){var d=n[s];t.addChild(d);u=r[s].w;if(d._menu){var g=new m(0,r[s].y-2.5,c,r[s].h+5),f=new lt(this._context,g.x,g.y,g.w,g.h);f.setInvisibleFill(),f._menu=d._menu,t.addChild(f)}d.setTranslateX(21)}}};var _t=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass(_t,i),_t.prototype.Init=function(t,e,i,n,r){this._context=t,this._id=e,this._text=i,this._listener=n,this._listenerObj=r},_t.prototype.getId=function(){return this._id},_t.prototype.getText=function(){return this._text},_t.prototype.FireActionTooltipItem=function(t){if(this._listenerObj&&this._listener){var e=new Object;e.target=t,e.menuItem=this._menuItem,this._menuItemTimer=new ut(this._context,1,this._handleMenuTimer,this),this._menuItemTimer.evt=e,this._menuItemTimer.start()}},_t.prototype._handleMenuTimer=function(){this._menuItemTimer&&this._menuItemTimer.stop(),this._listener.call(this._listenerObj,this._menuItemTimer.evt)};const pt=function(t,e){this.Init(t,e)};i.createSubclass(pt,it),pt.prototype.Init=function(t,e){this._storedContexts=new Object,pt.superclass.Init.call(this,t,e)},pt.prototype.InitContent=function(t){t.innerHTML="";var e=this._context.createContext(t,"DvtCustomTooltip");e.removeSizingSvg(),this._storedContexts[this._domElementId]=e},pt.prototype.GetStoredContext=function(){return this._storedContexts[this._domElementId]},pt.prototype.showRichElement=function(t,e,i,n){this.showRichElementAtPosition(t,e,i,n,!1)},pt.prototype.showRichElementAtPosition=function(t,e,i,n,r){var o=this.getTooltipElem();o.style.position="absolute",o.style.zIndex=2147483647;var s=this.GetStoredContext();if(s){var a=s.getStage();a.removeChildren();var h=i.getRootDisplayable();a.addChild(h),i&&i.Render&&i.Render();var l=a.getSVGRoot();u.setAttrNullNS(l,"width",i.getDisplayWidth()),u.setAttrNullNS(l,"height",i.getDisplayHeight()),this.PostElement(o,t,e,r,n)}},pt.prototype.hideTooltip=function(){pt.superclass.hideTooltip.call(this);var t=this.GetStoredContext();t&&t.getStage().removeChildren()};const dt=function(t,e,i,n,r){this.type=t,this.touch=e,this.target=i,this.relatedTarget=n,this._nativeEvent=r,this._isPropagationStopped=!1};dt.TOUCH_HOLD_START_TYPE="touchholdstart",dt.TOUCH_HOLD_MOVE_TYPE="touchholdmove",dt.TOUCH_HOLD_END_TYPE="touchholdend",dt.TOUCH_HOVER_START_TYPE="touchhoverstart",dt.TOUCH_HOVER_MOVE_TYPE="touchhovermove",dt.TOUCH_HOVER_END_TYPE="touchhoverend",dt.TOUCH_HOVER_OVER_TYPE="touchhoverover",dt.TOUCH_HOVER_OUT_TYPE="touchhoverout",dt.TOUCH_CLICK_TYPE="touchclick",dt.TOUCH_DOUBLE_CLICK_TYPE="touchdblclick",dt.prototype.preventDefault=function(){},dt.prototype.stopPropagation=function(){this._isPropagationStopped=!0},dt.prototype.isPropagationStopped=function(){return this._isPropagationStopped},dt.prototype.getNativeEvent=function(){return this._nativeEvent};const gt=function(){};i.createSubclass(gt,i),gt.elementFromPoint=function(t,e){for(var i=document.elementFromPoint(t,e);i;){if(i._obj)return i._obj;i=i.parentNode}return null},gt.elementFromTouch=function(t){return this.elementFromPoint(t.clientX,t.clientY)},gt.addDragListeners=function(t,e,i,n,o,s){var a,h=r.isTouchDevice(),l=t.getCtx(),u=document.body.style,c=function(t){t.stopPropagation()},_=function(t){e.call(o,t)&&(h?(document.addEventListener("touchmove",p,{capture:!0,passive:!1}),document.addEventListener("touchend",d,!0)):(document.addEventListener("mousemove",p,!0),document.addEventListener("mouseup",d,!0),a=!1,s&&document.addEventListener("click",c,!0)),gt._webkitUserSelect=u.webkitUserSelect,gt._mozUserSelect=u.MozUserSelect,u.webkitUserSelect="none",u.MozUserSelect="none")},p=function(t){a=!0;var e=k.newEvent(t,l);i.call(o,e)},d=function(t){h?(document.removeEventListener("touchmove",p,!0),document.removeEventListener("touchend",d,!0)):(document.removeEventListener("mousemove",p,!0),document.removeEventListener("mouseup",d,!0),"firefox"===r.browser&&a&&!s&&(document.addEventListener("click",c,{capture:!0,once:!0}),setTimeout(function(){document.removeEventListener("click",c,{capture:!0,once:!0})},0)),a=!1,s&&setTimeout(function(){document.removeEventListener("click",c,!0)},50)),u.webkitUserSelect=gt._webkitUserSelect,u.MozUserSelect=gt._mozUserSelect;var e=k.newEvent(t,l);n.call(o,e)};h?t.addEvtListener(L.TOUCHSTART,_):t.addEvtListener(F.MOUSEDOWN,_)},gt.createStaticCallback=function(t,e,i){return function(n){var r=k.newEvent(n,t);e.call(i,r)}},gt.disableMouseEvents=function(t){if(t.style&&(t.style.pointerEvents="none"),t.childNodes)for(var e=0;e<t.childNodes.length;e++)gt.disableMouseEvents(t.childNodes[e])};const ft=function(t,e,i){this.Init(t,e,i)};i.createSubclass(ft,i),ft.TOUCH_MODE="mode",ft.TOUCH_MODE_DEFAULT="defaultMode",ft.TOUCH_MODE_LONG_PRESS="longPressMode",ft.PREV_HOVER_OBJ="prevHoverObj",ft.HOVER_TOUCH_KEY="hoverTouch",ft.prototype.Init=function(t,e,i){this._context=e,this._id=t,this._eventManager=i,this._touchCount=0,this._touchHoldTimer=new ut(this._context,200,this._handleTouchHoldStartTimer,this),this._blockTouchHold=!1,this._touchMap=new Object,this._savedTouchInfo=new Array,this._addTouchHoldMoveEventListener(this._onTouchHoldHover,this),this._doubleTapTimer=new ut(this._context,600,this._handleDoubleTapTimer,this,1),this._dvtTouchEvent=null},ft.prototype.blockTouchHold=function(){this._stopTouchHoldTimer(),this._blockTouchHold=!0},ft.prototype.unblockTouchHold=function(){this._blockTouchHold=!1},ft.prototype._addTouchHoldMoveEventListener=function(t,e){this.addTouchEventListener(dt.TOUCH_HOLD_START_TYPE,t,e),this.addTouchEventListener(dt.TOUCH_HOLD_MOVE_TYPE,t,e),this.addTouchEventListener(dt.TOUCH_HOLD_END_TYPE,t,e)},ft.prototype._onTouchHoldHover=function(t){var e=t.type,i=t.touch,n=t.getNativeEvent(),r=this._touchMap[i.identifier],o=t.target;if(e==dt.TOUCH_HOLD_END_TYPE){var s=new dt(dt.TOUCH_HOVER_END_TYPE,i,o,null,n);s._isCancelEvent=this._isCancelEvent,null!=o&&this.FireListener(new dt(dt.TOUCH_HOVER_OUT_TYPE,i,o,null,n)),r[ft.PREV_HOVER_OBJ]=null,this.FireListener(s)}else e==dt.TOUCH_HOLD_START_TYPE?(r[ft.PREV_HOVER_OBJ]=null,null!=o&&this.FireListener(new dt(dt.TOUCH_HOVER_OVER_TYPE,i,o,null,n)),r[ft.PREV_HOVER_OBJ]=o,this.FireListener(new dt(dt.TOUCH_HOVER_START_TYPE,i,o,null,n))):e==dt.TOUCH_HOLD_MOVE_TYPE&&(this._fireHoverOverOutEvents(o,r[ft.PREV_HOVER_OBJ],i,n),r[ft.PREV_HOVER_OBJ]=o,this.FireListener(new dt(dt.TOUCH_HOVER_MOVE_TYPE,i,o,null,n)))},ft.prototype._getObjFromTouch=function(t){return t?gt.elementFromTouch(t):null},ft.prototype._fireHoverOverOutEvents=function(t,e,i,n){e!=t&&(null!=e&&this.FireListener(new dt(dt.TOUCH_HOVER_OUT_TYPE,i,e,t,n)),null!=t&&this.FireListener(new dt(dt.TOUCH_HOVER_OVER_TYPE,i,t,e,n)))},ft.prototype.addTouchEventListener=function(t,e,i){var n=this._getListeners(t,!0);n.push(e),n.push(i)},ft.prototype.removeTouchEventListener=function(t,e,i){var n=this._getListeners(t,!1);if(n)for(var r=0;r<n.length;r+=2)if(n[r]===e&&n[r+1]===i){n.splice(r,2);break}},ft.prototype._getListeners=function(t,e){if(!this._listenerObj){if(!e)return null;this._listenerObj={}}var i=t,n=this._listenerObj[i];return!n&&e&&(n=[],this._listenerObj[i]=n),n},ft.prototype.FireListener=function(t){var e=this._getListeners(t.type,!1);if(e)for(var i=0;i<e.length;i+=2){var n=e[i+1];e[i].call(n,t)}},ft.prototype.startTouchHold=function(t){var e=this._startSingleFingerTouchId;if(null!=e&&!isNaN(e)){var i=this._touchMap[e];if(i){for(var n=i.startTarget,r=i.startTouch,o=t.getNativeEvent(),s=this._findMatches("touchId",e),a=0;a<s.length;a++){var h=s[a],l=h.touchObj,u=h.touchId;if(l!=ft.HOVER_TOUCH_KEY){var c=this.getTouchInfo(u).startTouch;this.performAssociatedTouchEnd(c,l,null)}}i[ft.TOUCH_MODE]=ft.TOUCH_MODE_LONG_PRESS,this.saveProcessedTouch(e,ft.HOVER_TOUCH_KEY,null,ft.HOVER_TOUCH_KEY,ft.HOVER_TOUCH_KEY,this.HoverMoveInternal,this.HoverEndInternal,this);var _=new dt(dt.TOUCH_HOLD_START_TYPE,r,n,null,o);this.FireListener(_)}}},ft.prototype.fireLogicalEvents=function(t){var e=t.type,i=t.getNativeEvent();if(e==L.TOUCHSTART?(t.isTouchHoldBlocked()||this.processAssociatedTouchAttempt(t,ft.HOVER_TOUCH_KEY,this.HoverStartInternal,this),this._doubleTapAttemptStarted&&t.preventDefault()):e==L.TOUCHMOVE?this.processAssociatedTouchMove(t,ft.HOVER_TOUCH_KEY):e==L.TOUCHEND&&this.processAssociatedTouchEnd(t,ft.HOVER_TOUCH_KEY),e==L.TOUCHEND){this._context.oj.Logger.log("received touch end:"+performance.now());for(var n=this._getStoredTouches(t.changedTouches),r=0;r<n.length;r++){var o=n[r],s=o.identifier,a=this.getTouchInfo(s),h=a.currentObj;if(a[ft.TOUCH_MODE]!=ft.TOUCH_MODE_LONG_PRESS&&a.fireClick){var l=new dt(dt.TOUCH_CLICK_TYPE,o,h,null,i);if(l.touchEvent=t,this._context.oj.Logger.log("doubleTapAttemptStarted:"+this._doubleTapAttemptStarted),this._doubleTapAttemptStarted){var u=this._doubleTapAttemptObj;if(this.resetDoubleTap(),h==u||u.contains(h)){var c=new dt(dt.TOUCH_DOUBLE_CLICK_TYPE,o,h,null,i);c.touchEvent=t,this._context.oj.Logger.log("firing double tap"),this.FireListener(c)}else this.FireListener(l)}else this._context.oj.Logger.log("firing tap"),this.FireListener(l),this.resetDoubleTap(),this._context.oj.Logger.log("starting double tap timer"),this._doubleTapTimer.start(),this._doubleTapAttemptStarted=!0,this._doubleTapAttemptObj=h}}}},ft.prototype.getTouchInfo=function(t){return this._touchMap[t]},ft.prototype.HoverStartInternal=function(t,e){if(!this._blockTouchHold){var i=e.identifier;this._startSingleFingerTouchId=i,this._stopTouchHoldTimer(),this._startTouchHoldTimer(t)}},ft.prototype.HoverMoveInternal=function(t,e){var i=e.identifier,n=this.getTouchInfo(i).currentObj,r=new dt(dt.TOUCH_HOLD_MOVE_TYPE,e,n,null,t.getNativeEvent());this.FireListener(r),t.preventDefault()},ft.prototype.HoverEndInternal=function(t,e){var i=e.identifier,n=this.getTouchInfo(i).currentObj,r=new dt(dt.TOUCH_HOLD_END_TYPE,e,n,null,t.getNativeEvent());this.FireListener(r),t&&t.preventDefault()},ft.prototype.resetTouchHold=function(){this._startSingleFingerTouchId=null,this._stopTouchHoldTimer()},ft.prototype.preEventBubble=function(t){t.setTouchManager&&t.setTouchManager(this);var e=t.type;e==L.TOUCHSTART?this.processTouchStart(t):e==L.TOUCHMOVE?this.processTouchMove(t):e==L.TOUCHEND&&this.processTouchEnd(t)},ft.prototype.postEventBubble=function(t){var e=t.type;if(e==L.TOUCHSTART);else if(e==L.TOUCHMOVE);else if(e==L.TOUCHEND)for(var i=this._getStoredTouches(t.changedTouches),n=0;n<i.length;n++){var r=i[n].identifier;delete this._touchMap[r],this._startSingleFingerTouchId==r&&(this._startSingleFingerTouchId=null);for(var o=this._findMatches("touchId",r),s=0;s<o.length;s++){var a=o[s];this.removeTooltipInfo(a.touchId,a.touchObj)}}},ft.prototype.saveProcessedTouch=function(t,e,i,n,r,o,s,a){if(null!=t&&!isNaN(t)){var h=ft.createSavedTouchInfo(t,e,i,n,r,o,s,a);return this._savedTouchInfo.push(h),!0}return!1},ft.prototype.cancelTouchHold=function(){for(var t=ft.HOVER_TOUCH_KEY,e=this.getTouchIdsForObj(t),i=0;i<e.length;i++){var n=e[i],r=this.getTouchInfo(n).startTouch;r&&(this._isCancelEvent=!0,this.performAssociatedTouchEnd(r,t,null),this._isCancelEvent=!1,delete this._touchMap[n])}},ft.prototype.performAssociatedTouchEnd=function(t,e,i){for(var n=t.identifier,r=this._getSavedTouchInfo(n,e),o=0;o<r.length;o++){var s=r[o],a=s.listenerObj,h=s.endListener;this.removeTooltipInfo(n,e),h&&h.call(a,i,t,s)}},ft.prototype.processAssociatedTouchAttempt=function(t,e,i,n){for(var r=t.changedTouches,o=0;o<r.length;o++){var s=r[o];s&&i&&i.call(n,t,s)}},ft.prototype.processAssociatedTouchMove=function(t,e){for(var i=this.getTouchIdsForObj(e),n=0;n<i.length;n++){var r=i[n];if(null!=r&&!isNaN(r)){var o=ft.getTouchById(r,this._getStoredTouches(t.changedTouches));if(o){var s=this._getSavedTouchInfo(o.identifier,e);for(n=0;n<s.length;n++){var a=s[n],h=a.listenerObj,l=a.moveListener;l&&l.call(h,t,o)}}}}},ft.prototype.processAssociatedTouchEnd=function(t,e){for(var i=this.getTouchIdsForObj(e),n=0;n<i.length;n++){var r=i[n],o=ft.getTouchById(r,this._getStoredTouches(t.changedTouches));o&&this.performAssociatedTouchEnd(o,e,t)}},ft.prototype._findMatches=function(t,e){for(var i=new Array,n=0;n<this._savedTouchInfo.length;n++){var r=this._savedTouchInfo[n];r[t]==e&&i.push(r)}return i},ft.prototype._getSavedTouchInfo=function(t,e){for(var i=this._findMatches("touchId",t),n=[],r=0;r<i.length;r++){var o=i[r];o.touchObj==e&&n.push(o)}return n},ft.prototype.getTouchIdsForObj=function(t){for(var e=new Array,i=this._findMatches("touchObj",t),n=0;n<i.length;n++){var r=i[n].touchId;e.push(r)}return e},ft.prototype.removeTooltipInfo=function(t,e){for(var i=this._findMatches("touchId",t),n=new Array,r=0;r<i.length;r++){(h=i[r]).touchObj==e&&n.push(h)}for(r=0;r<n.length;r++){for(var o=n[r],s=-1,a=0;a<this._savedTouchInfo.length;a++){var h;(h=this._savedTouchInfo[a])==o&&(s=a)}-1!=s&&(this._savedTouchInfo.splice(s,1),0==this._savedTouchInfo.length&&this._context.getTooltipManager().hideTooltip())}},ft.prototype.setTooltipEnabled=function(t,e){for(var i=this._savedTouchInfo,n=0;n<i.length;n++){var r=i[n];r.touchId==t&&(r.allowTooltips=e)}},ft.prototype.getTooltipInfo=function(){for(var t=new Object,e=new Array,i=null,n=null,r=!1,o=this._findMatches("allowTooltips",!0),s=0;s<o.length;s++){var a,h=o[s],l=h.touchId;n?h.grouping!=n&&(r=!0):n=h.grouping;var u=this._touchMap[l];u&&(a=u.currentObj),h.tooltipObjOverride&&(a=h.tooltipObjOverride),e.push(l),i=a}return r&&(e=new Array),t.touchIds=e,t.tooltipTarget=i,t},ft.prototype.processTouchStart=function(t){var e=t.changedTouches,i=t.touches;this._touchCount=i.length;for(var n=0;n<e.length;n++){var r=e[n],o=r.screenX,s=r.screenY,a=r.identifier,h=this._getObjFromTouch(r),l={x:o,y:s,prevX:o,prevY:s,pageX:r.pageX,pageY:r.pageY,prevPageX:r.pageX,prevPageY:r.pageY,dx:0,dy:0,fireClick:!0,startTarget:h,currentObj:h,touchMoved:!1,touchtype:null,startTouch:r};l[ft.TOUCH_MODE]=ft.TOUCH_MODE_DEFAULT,l.origx=o,l.origy=s,this._touchMap[a]=l}return!this._isHovering()&&this._isTouchHoldAllowed()||t.blockTouchHold(),!0},ft.prototype._isTouchHoldAllowed=function(){var t=!1,e=0;for(var i in this._touchMap){this.getTouchInfo(i).touchMoved&&(t=!0),e++}return!(e>1&&!t)||(this.resetTouchHold(),!1)},ft.prototype._isHovering=function(){for(var t in this._touchMap){if(this.getTouchInfo(t)[ft.TOUCH_MODE]==ft.TOUCH_MODE_LONG_PRESS)return!0}return!1},ft.prototype._getStoredTouches=function(t){for(var e=new Array,i=0;i<t.length;i++){var n=t[i],r=n.identifier;this.getTouchInfo(r)&&e.push(n)}return e},ft.prototype.processTouchMove=function(t){for(var e=this._getStoredTouches(t.changedTouches),i=this._getStoredTouches(t.touches),n=0;n<e.length;n++){var r=e[n],o=this._getObjFromTouch(r),s=r.identifier;if((u=this.getTouchInfo(s)).currentObj=o,u.touchMoved=!0,u[ft.TOUCH_MODE]!=ft.TOUCH_MODE_LONG_PRESS){var a=Math.abs(u.pageX-r.pageX),h=Math.abs(u.pageY-r.pageY);this._startSingleFingerTouchId==s&&(a>0||h>0)&&this.resetTouchHold(),u.touchMoved=a>3||h>3}(u.touchMoved||u.fireClick&&u[ft.TOUCH_MODE]!=ft.TOUCH_MODE_LONG_PRESS&&u.currentObj!=u.startTarget&&u.currentObj!=this._eventManager.getMarqueeGlassPane())&&(u.fireClick=!1)}for(n=0;n<i.length;n++){var l=(r=i[n]).identifier,u=this.getTouchInfo(l),c=r.screenX,_=r.screenY,p=c-u.x,d=_-u.y;u.prevX=u.x,u.prevY=u.y,u.dx=p,u.dy=d,u.x=c,u.y=_,u.prevPageX=u.pageX,u.prevPageY=u.pageY,u.pageX=r.pageX,u.pageY=r.pageY}return!0},ft.prototype.processTouchEnd=function(t){var e=t.changedTouches;this._touchCount=t.touches.length;for(var i=0;i<e.length;i++){var n=e[i],r=this._getObjFromTouch(n),o=n.identifier,s=this.getTouchInfo(o);if(s&&s.fireClick)if(s[ft.TOUCH_MODE]==ft.TOUCH_MODE_LONG_PRESS)this._startSingleFingerTouchId=null;else{var a=r==s.startTarget,h=s.touchMoved,l=a&&!h;s.fireClick=l}}return!0},ft.getTouchById=function(t,e){if(null!=t&&!isNaN(t))for(var i=0;i<e.length;i++){var n=e[i];if(n.identifier==t)return n}return null},ft.createSavedTouchInfo=function(t,e,i,n,r,o,s,a){var h={touchId:t,tooltipObjOverride:i,grouping:n,type:r,touchObj:e,allowTooltips:!0};return h.moveListener=o,h.endListener=s,h.listenerObj=a,h},ft.prototype._handleTouchHoldStartTimer=function(){var t=this._dvtTouchEvent;this._stopTouchHoldTimer(),this.startTouchHold(t)},ft.prototype._startTouchHoldTimer=function(t){this._dvtTouchEvent=t,this._touchHoldTimer&&this._touchHoldTimer.start()},ft.prototype._stopTouchHoldTimer=function(){this._dvtTouchEvent=null,this._touchHoldTimer&&this._touchHoldTimer.stop()},ft.prototype._handleDoubleTapTimer=function(){this._context.oj.Logger.log("double tap timer expired"),this.resetDoubleTap()},ft.prototype.resetDoubleTap=function(){this._doubleTapAttemptStarted=!1,this._doubleTapAttemptObj=null,this._doubleTapTimer.stop()},ft.prototype.getMultiTouchData=function(t){if(2==t.length){var e=this._touchMap[t[0]],i=this._touchMap[t[1]];if(null==e||null==i)return null;if(0==e.dx&&0==i.dy)return null;var n=e.pageX-i.pageX,r=e.pageY-i.pageY,o=Math.sqrt(n*n+r*r),s=e.prevPageX-i.prevPageX,a=e.prevPageY-i.prevPageY,h=o-Math.sqrt(s*s+a*a),l=(e.pageX+i.pageX)/2,u=(e.pageY+i.pageY)/2;return{dz:h,cx:l,cy:u,dcx:l-(e.prevPageX+i.prevPageX)/2,dcy:u-(e.prevPageY+i.prevPageY)/2,dist:o}}return null},ft.prototype.calcAveragePosition=function(t){for(var e=0,i=0,r=t.length,o=0;o<r;o++){var s=t[o],a=this.getTouchInfo(s);e+=a.pageX,i+=a.pageY}return new n(e/=r,i/=r)},ft.prototype.getStartTargetsByIds=function(t){for(var e=new Array,i=0;i<t.length;i++){var n=this.getTouchInfo(t[i]);e.push(n.startTarget)}return e},ft.prototype.reset=function(){this._touchMap=new Object,this._savedTouchInfo=new Array,this.resetTouchHold(),this.resetDoubleTap()};const yt=new Object;i.createSubclass(yt,i),yt.newEvent=function(t,e){var i={type:t};return e&&(i.id=e),i},yt.newOptionChangeEvent=function(t,e,i){var n=yt.newEvent("optionChange");return n.key=t,n.value=e,n.optionMetadata=i,n},yt.newRenderEvent=function(){return yt.newEvent("dvtRender")},yt.newCategoryHideEvent=function(t,e){var i=yt.newEvent("categoryHide");return i.category=t,i.hiddenCategories=e,i},yt.newCategoryShowEvent=function(t,e){var i=yt.newEvent("categoryShow");return i.category=t,i.hiddenCategories=e,i},yt.newCategoryHighlightEvent=function(t,e){var i=yt.newEvent("categoryHighlight");return i._highlightType=e?"over":"out",t=t||[],i.categories=t instanceof Array?t:[t],i},yt.newDrillEvent=function(t,e){var i=yt.newEvent("drill",t);return e&&(i.subType=e),i},yt.newReadyEvent=function(){return yt.newEvent("ready")},yt.newSelectionEvent=function(t){var e=yt.newEvent("selection");return e.selection=t,e},yt.newTouchHoldReleaseEvent=function(t){var e=yt.newEvent("touchHoldRelease");return e.nativeEvent=t,e},yt.newValueChangeEvent=function(t,e,i){var n=yt.newEvent("valueChange");return n.oldValue=t,n.newValue=e,n.complete=i,n},yt.newActionTooltipEvent=function(t,e){var i=yt.newEvent(t);return i.target=e,i},yt.newPanZoomEvent=function(t,e,i,n,r,o,s,a,h){var l=yt.newEvent("dvtPanZoom");return l.subtype=t,l.dxMin=e,l.dxMax=i,l.dyMin=n,l.dyMax=r,l.dxMinTotal=o,l.dxMaxTotal=s,l.dyMinTotal=a,l.dyMaxTotal=h,l},yt.newSimpleScrollbarEvent=function(t,e,i){var n=yt.newEvent("dvtSimpleScrollbar");return n.subtype=t,n.newMin=e,n.newMax=i,n},yt.newOverviewEvent=function(t,e,i,n,r,o,s,a,h){var l=yt.newEvent("overview");return l.subtype=t,l.newX1=e,l.newX2=i,l.newY1=n,l.newY2=r,l.oldX1=o,l.oldX2=s,l.oldY1=a,l.oldY2=h,l},yt.newChartDrillEvent=function(t,e,i,n){var r=yt.newDrillEvent(t,n);return r.series=e,r.group=i,r},yt.newChartSelectionEvent=function(t,e,i,n,r,o,s,a,h,l){var u=yt.newSelectionEvent(t);return u.complete=e,u.xMin=i,u.xMax=n,u.startGroup=r,u.endGroup=o,u.yMin=s,u.yMax=a,u.y2Min=h,u.y2Max=l,u},yt.newChartViewportChangeEvent=function(t,e,i,n,r,o,s){var a=yt.newEvent("viewportChange");return a.complete=t,a.xMin=e,a.xMax=i,a.startGroup=n,a.endGroup=r,a.yMin=o,a.yMax=s,a},yt.newMarqueeEvent=function(t,e,i,n,r,o){var s=yt.newEvent("dvtMarquee");return s.subtype=t,s.x=e,s.y=i,s.w=n,s.h=r,s.ctrlKey=o,s},yt.newExpandCollapseEvent=function(t,e,i,n,r){var o=yt.newEvent(t,e);return o.expanded=r,o.data=i,o.component=n,o},yt.newTreeDrillEvent=function(t,e,i){var n=yt.newDrillEvent(t);return n.data=e,n.component=i,n},yt.newBreadcrumbsDrillEvent=function(t){return yt.newEvent("breadcrumbsDrill",t)},yt.newSunburstRotationEvent=function(t,e){var i=yt.newEvent("rotation");return i.complete=e,i.startAngle=t%360,i},yt.newThematicMapViewportChangeEvent=function(t,e,i){var n=yt.newEvent("viewportChange");return n.panX=t,n.panY=e,n.zoom=i,n},yt.newTimelineMoveEvent=function(t,e,i,n){var r=yt.newEvent("move");return r.itemContexts=t,r.value=e,r.start=i,r.end=n,r},yt.newTimelineResizeEvent=function(t,e,i,n,r){var o=yt.newEvent("resize");return o.itemContexts=t,o.value=e,o.start=i,o.end=n,o.typeDetail=r,o},yt.newTimelineViewportChangeEvent=function(t,e,i){var n=yt.newEvent("viewportChange");return n.viewportStart=t,n.viewportEnd=e,n.minorAxisScale=i,n},yt.newGanttViewportChangeEvent=function(t,e,i,n){var r=yt.newTimelineViewportChangeEvent(t,e,n);return r.majorAxisScale=i,r},yt.newGanttMoveEvent=function(t,e,i,n,r,o,s){var a=yt.newEvent("move");return a.taskContexts=t,a.value=e,a.start=i,a.end=n,a.baselineStart=r,a.baselineEnd=o,a.rowContext=s,a},yt.newGanttResizeEvent=function(t,e,i,n,r){var o=yt.newEvent("resize");return o.taskContexts=t,o.value=e,o.start=i,o.end=n,o.typeDetail=r,o},yt.newGanttScrollPositionChangeEvent=function(t,e,i){var n=yt.newEvent("scrollPositionChange");return n.y=t,n.rowIndex=e,n.offsetY=i,n},yt.newGanttExpandCollapseEvent=function(t,e,i,n,r){var o=yt.newEvent(t,e);return o.rowData=i,o.itemData=n,o.expanded=r,o},yt.newTreemapIsolateEvent=function(t){return yt.newEvent("isolate",t)},yt.newPanEvent=function(t,e,i,n,r,o){var s=yt.newEvent("dvtPan");return s.subtype=t,s.newX=e,s.newY=i,s.oldX=n,s.oldY=r,s.animator=o,s},yt.newZoomEvent=function(t,e,i,n,r,o,s){var a=yt.newEvent("dvtZoom");return a.subtype=t,a.newZoom=e,a.oldZoom=i,a.animator=n,a.centerPoint=r,a.tx=o,a.ty=s,a},yt.newTimelineOverviewEvent=function(t,e,i){var n=yt.newEvent("timeline");return n.subtype=t,n.itemId=e,n.isMultiSelect=i,n};const vt=function(){this.Init()};i.createSubclass(vt,i),vt.prototype.Init=function(){this._map={}},vt.prototype.get=function(t,e){return this._getInnerMap(t)[e]},vt.prototype.put=function(t,e,i){var n=this._getInnerMap(t),r=n[e];return n[e]=i,r},vt.prototype._getInnerMap=function(t){var e=this._map[t];return e||(e={},this._map[t]=e),e};const St=function(){this.Init()};St.prototype.Init=function(){this.Cache={}},St.prototype.clearCache=function(){this.Cache={}},St.prototype.getFromCache=function(t){return this.Cache[t]},St.prototype.putToCache=function(t,e){this.Cache[t]=e},St.prototype.getFromCachedMap=function(t,e){return this._getCachedMap(t)[e]},St.prototype._getCachedMap=function(t){var e=this.getFromCache(t);return e||(e={},this.putToCache(t,e)),e},St.prototype.putToCachedMap=function(t,e,i){this._getCachedMap(t)[e]=i},St.prototype.getFromCachedMap2D=function(t,e,i){return this._getCachedMap2D(t).get(e,i)},St.prototype._getCachedMap2D=function(t){var e=this.getFromCache(t);return e||(e=new vt,this.putToCache(t,e)),e},St.prototype.putToCachedMap2D=function(t,e,i,n){this._getCachedMap2D(t).put(e,i,n)};const Tt={format:function(t,e){return t?t.replace(/\{(\d+)\}/g,function(){return e[arguments[1]]}):t}},Et=new Object;i.createSubclass(Et,i),Et.clone=function(t,e,i){if(null==t)return null;var n=null;if(t instanceof Array){n=[];for(var r=0;r<t.length;r++)Et._isDeepClonable(t[r])?n[r]=Et.clone(t[r],e,i):n[r]=t[r]}else if(t instanceof j)n=t.clone();else if(t instanceof Date)n=t.getTime();else if(Et._isClonableObject(t))for(var o in n={},t)if(!e||e(o)){var s=t[o];if(i&&1==i[o]||!Et._isDeepClonable(s)||"_widgetConstructor"==o)n[o]=s;else{var a=i?i[o]:null;n[o]=Et.clone(s,e,a)}}return n},Et.merge=function(t,e,i){var n=t&&t._dvtNoClone?t:Et.clone(t,null,i);if(e&&e._dvtNoClone)throw new Error("Do not merge because content will be modified.");var r=Et.clone(e,null,i);if(null==n)return r;if(null==r&&n._dvtNoClone)throw new Error("Do not return an uncloned object.");return null==r?n:(Et._copy(n,r),r)},Et._copy=function(t,e){for(var i in t){var n=t[i];void 0!==n&&(n&&n instanceof Array||"_widgetConstructor"==i?e[i]=n:e[i]&&e[i]instanceof j?n instanceof j?e[i].merge(n):e[i].merge(new j(n)):Et._isDeepClonable(n)&&e[i]?Et._copy(n,e[i]):e[i]=n)}},Et._isDeepClonable=function(t){return t instanceof Object&&(!t.has&&(!t._dvtNoClone&&!(t instanceof Boolean||t instanceof String||t instanceof Number||t instanceof Function||t.then)))},Et._isClonableObject=function(t){return t instanceof Object&&(!t.then&&(!t.jquery&&(!t.has&&(!("undefined"!=typeof NodeList&&t instanceof NodeList)&&(!("undefined"!=typeof Node&&t instanceof Node)&&!t._dvtNoClone)))))};const mt=function(t,e,i,n,r,o){this.Init(t,e,i,n,r,o)};i.createSubclass(mt,J),mt._LINE_SPACE=0,mt.H_ALIGN_LEFT="left",mt.H_ALIGN_CENTER="center",mt.H_ALIGN_RIGHT="right",mt.V_ALIGN_TOP="top",mt.V_ALIGN_MIDDLE="middle",mt.V_ALIGN_CENTRAL="central",mt.V_ALIGN_BOTTOM="bottom",mt.prototype.Init=function(t,e,i,n,r,o){mt.superclass.Init.call(this,t,null,r),this._textInstance=null,this._additionalLines=[],this._lineHeight=null,this._yCoord=null,this._noWrap=!1,this._preserveNewLine=o||!1,this._preservedLines=[],this.setTextString(e),this.setX(i||0),this.setY(n||0),this.setMaxLines(1/0)},mt.prototype.getTextString=function(){return this._textString},mt.prototype.setTextString=function(t){this._textString=null!=t?String(t):null,this._textInstance?(this._textInstance.setTextString(t),this._removeAdditionalLines()):(this._textInstance=new at(this.getCtx(),this._textString),this.addChild(this._textInstance)),this._preserveNewLine&&(this._generatePreservedLines(),this.wrapText(1/0,1/0,1,!1)),this._bTruncated=!1},mt.prototype._getTextLines=function(){var t=this._additionalLines.slice();return this._textInstance.getParent()==this&&t.unshift(this._textInstance),t},mt.prototype.getX=function(){return this._textInstance.getX()},mt.prototype.setX=function(t){return this._getTextLines().forEach(function(e){e.setX(t)}),this},mt.prototype.getY=function(){return this._textInstance.getY()},mt.prototype.getYAlignCoord=function(){return this._yCoord},mt.prototype.setY=function(t){if(this._yCoord=t,this._vertAlign)this._alignVerticalText();else{var e=t-this._textInstance.getY();e||(e=t),this._getTextLines().forEach(function(t){var i=t.getY();t.setY(i?i+e:e)})}return this},mt.prototype.getMaxLines=function(){return this.GetProperty("maxLines")},mt.prototype.setMaxLines=function(t){return t>0?this.SetProperty("maxLines",t):null},mt.prototype.isTruncated=function(){return this._bTruncated},mt.prototype.getHorizAlignment=function(){return this._textInstance.getHorizAlignment()},mt.prototype.setHorizAlignment=function(t){return this._getTextLines().forEach(function(e){e.setHorizAlignment(t)}),this},mt.prototype.alignLeft=function(){this._horizAlign!=mt.H_ALIGN_LEFT&&(this._horizAlign=mt.H_ALIGN_LEFT,this._getTextLines().forEach(function(t){t.alignLeft()}))},mt.prototype.alignCenter=function(){this._horizAlign!=mt.H_ALIGN_CENTER&&(this._horizAlign=mt.H_ALIGN_CENTER,this._getTextLines().forEach(function(t){t.alignCenter()}))},mt.prototype.alignRight=function(){this._horizAlign!=mt.H_ALIGN_RIGHT&&(this._horizAlign=mt.H_ALIGN_RIGHT,this._getTextLines().forEach(function(t){t.alignRight()}))},mt.prototype.alignTop=function(){this._vertAlign!=mt.V_ALIGN_TOP&&(this._vertAlign=mt.V_ALIGN_TOP,this._alignVerticalText(),this._getTextLines().forEach(function(t){t.alignTop()}))},mt.prototype.alignMiddle=function(){this._vertAlign!=mt.V_ALIGN_MIDDLE&&(this._vertAlign=mt.V_ALIGN_MIDDLE,this._alignVerticalText(),this._getTextLines().forEach(function(t){t.alignMiddle()}))},mt.prototype.alignCentral=function(){this._vertAlign!=mt.V_ALIGN_CENTRAL&&(this._vertAlign=mt.V_ALIGN_CENTRAL,this._alignVerticalText(),this._getTextLines().forEach(function(t){t.alignCentral()}))},mt.prototype.alignBottom=function(){this._vertAlign!=mt.V_ALIGN_BOTTOM&&(this._vertAlign=mt.V_ALIGN_BOTTOM,this._alignVerticalText(),this._getTextLines().forEach(function(t){t.alignBottom()}))},mt.prototype._alignVerticalText=function(){if(this._vertAlign)for(var t=this.getYAlignCoord(),e=this.getLineCount(),i=this.getLineHeight(),n=this._getTextLines(),r=0,o=0;o<n.length;o++){var s=n[o];if(this._vertAlign==mt.V_ALIGN_TOP)r=i*o;else if(this._vertAlign==mt.V_ALIGN_MIDDLE||this.vertAlign==mt.V_ALIGN_CENTRAL){r=i*o-i*(e-1)/2}else this._vertAlign==mt.V_ALIGN_BOTTOM&&(r=-i*(e-o-1));s.setY(t+r)}},mt.prototype.getCSSStyle=function(){return this._textInstance.getCSSStyle()},mt.prototype.setCSSStyle=function(t){return this._lineHeight=null,this._getTextLines().forEach(function(e){e.setCSSStyle(t)}),this},mt.prototype.copyShape=function(){var t=new mt(this.getCtx(),this.getTextString(),this.getX(),this.getY());return t.setCSSStyle(this.getCSSStyle()).setHorizAlignment(this.getHorizAlignment()).setMaxLines(this.getMaxLines()),t},mt.prototype._removeAdditionalLines=function(){for(var t=0;t<this._additionalLines.length;t++)this.removeChild(this._additionalLines[t]);this._additionalLines=[]},mt.prototype._generatePreservedLines=function(){if(this._preserveNewLine){this._preservedLines=[];var t=this.getTextString().split(/\n+/),e=this._textInstance,i=null;this._preservedLines.push(e);for(var n=0;n<t.length;n++)if(i=t[n].replace(/\s+/g," "),e.setTextString(i),n<t.length-1){var r=e.copyShape();this._preservedLines.push(r),e=r}}},mt.prototype.__fitText=function(t,e,i){if(!this._preserveNewLine){if(this._textInstance.setTextString(this.getTextString()),this._removeAdditionalLines(),!st.fitText(this._textInstance,t,e,this,i))return this.getParent().removeChild(this),!1;if(!this._textInstance.isTruncated())return!0;if(!this.isWrapEnabled())return this._bTruncated=!0,!0}return this.wrapText(t,e,i,!1)},mt.prototype.wrapText=function(t,e,i,n){this.getLineCount()>1&&this._removeAdditionalLines();var r,o=this.getLineHeight(),s=o*mt._LINE_SPACE,a=this.getMaxLines(),h=Math.min(e,a*(o+s)-s)-o-s;if(this._preserveNewLine){for(var l=!1,u=null,c=0;c<this._preservedLines.length;c++){if(r=this._preservedLines[c],h<s+o)return this._bTruncated=!0,l;if(st.fitText(r,t,1/0,this,i)){if(l=!0,h-=s+o,r.isTruncated()&&!this.isTruncated()&&(this._bTruncated=!0),c>0){this._additionalLines.push(r);var _=u?u.getY()+s+o:this.getY();r.setY(_),this.addChild(r)}u=r}}return l}r=this._textInstance;var p=null,d=null,g=null,f=this.getTextString().split(/\s+/);f.reverse();for(var y=function(){var t=r.copyShape();t.setY(r.getY()+s+o),this.addChild(t),this._additionalLines.push(t),r=t,p=null,h-=s+o}.bind(this),v=!0;f.length>0;){var S=f.pop(),T=p?p+" "+S:S;if(r.setTextString(T),r.setUntruncatedTextString(null),st.fitText(r,t,1/0,this,i,!0))if(r.isTruncated()){if(h<s+o)return this._bTruncated=!0,!0;if(g=r.getTextString(),d=r,p)r.setTextString(p),f.push(S);else{if(n)return this._textInstance.setTextString(this.getTextString()),this._removeAdditionalLines(),!1;this._bTruncated=!0}f.length>0&&y()}else p=T;else{if(null==p){if(v||!d)return this._textInstance.setTextString(null),this._removeAdditionalLines(),!1;d.setTextString(g);for(var E=this._additionalLines.pop();E&&E!==d;)this.removeChild(E),E=this._additionalLines.pop();return E&&this._additionalLines.push(E),!0}f.push(S),y()}v=!1}return!0},mt.prototype.GetSvgDimensions=function(t){var e=this._getTextLines();if(0==e.length)return new m(0,0,0,0);var i=new m(1/0,1/0,0,0);return e.forEach(function(t){var e=t.getDimensions();i.x=Math.min(i.x,e.x),i.y=Math.min(i.y,e.y),i.w=Math.max(i.w,e.w),i.h+=e.h}),this.ConvertCoordSpaceRect(i,t)},mt.prototype.getLineCount=function(){return this._additionalLines.length+1},mt.prototype.getLineHeight=function(){return this._lineHeight||(this._lineHeight=st.getTextStringHeight(this.getCtx(),this.getCSSStyle())),this._lineHeight},mt.prototype.setWrapEnabled=function(t){t||(this._textInstance.getParent()!=this&&this.addChild(this._textInstance),this._textInstance.getTextString()||this._textInstance.setTextString(this.getTextString()),this._removeAdditionalLines()),this._noWrap=!t},mt.prototype.isWrapEnabled=function(){return!this._noWrap},mt.prototype.getUntruncatedTextString=function(){return this.isTruncated()?this.getTextString():null},mt.prototype.setUntruncatedTextString=function(t){},mt.prototype.getDimensions=function(t){return this.GetSvgDimensions(t)},mt.prototype.UpdateSelectionEffect=function(){},mt.prototype.getHorizAlignment=function(){return this._horizAlign},mt.prototype.setHorizAlignment=function(t){t==mt.H_ALIGN_LEFT?this.alignLeft():t==mt.H_ALIGN_CENTER?this.alignCenter():t==mt.H_ALIGN_RIGHT&&this.alignRight()},mt.prototype.getVertAlignment=function(){return this._vertAlign},mt.prototype.setVertAlignment=function(t){t==mt.V_ALIGN_TOP?this.alignTop():t==mt.V_ALIGN_MIDDLE?this.alignMiddle():t==mt.V_ALIGN_CENTRAL?this.alignCentral():t==mt.V_ALIGN_BOTTOM&&this.alignBottom()},mt.prototype.isMultiline=function(){return!0},mt.prototype.hasBackground=function(){return!1};const bt=function(t,e,i,n){this.Init(t,e,i,n)};i.createSubclass(bt,i),bt.prototype.Init=function(t,e,i,n){this._tooltip=t,this._datatip=e,this._datatipColor=i,this._params=n},bt.prototype.getParams=function(){return this._params},bt.prototype.getTooltip=function(t){return this._tooltip},bt.prototype.getDatatip=function(t){return"function"==typeof this._datatip?this._datatip():this._datatip},bt.prototype.getDatatipColor=function(t){return"function"==typeof this._datatipColor?this._datatipColor():this._datatipColor};const Ct=function(t,e,i,n){n||this.Init(t,e,i)};i.createSubclass(Ct,J),Ct.prototype.Init=function(t,e,i){Ct.superclass.Init.call(this,t),this._callback=e,this._callbackObj=i,this.Defaults=null,this.Options=null,this.Width=0,this.Height=0,this.EventManager=null,this.Animation=null,this.AnimationStopped=!1,this._optionsCache=new St,this._cache=new St,this._SHARED_DEFS_DIV_ID="_dvtSharedDefs"},Ct.prototype.GetDefaults=function(t){return this.Defaults?this.Defaults.getDefaults(t):{}},Ct.prototype.GetComponentDescription=function(){return this.getOptions().translations.componentName},Ct.prototype.IsParentRoot=function(){return this.getParent()==this.getCtx().getStage()},Ct.prototype.UpdateAriaAttributes=function(){if(this.IsParentRoot()){var t=this.getOptions().translations;this.getCtx().setAriaRole("application"),this.getCtx().setAriaLabel(Tt.format(t.labelAndValue,[t.labelDataVisualization,O.processAriaLabel(this.GetComponentDescription())]))}},Ct.prototype.SetOptions=function(t){},Ct.prototype.getOptions=function(){return this.Options||(this.Options=this.GetDefaults()),this.Options},Ct.prototype.applyOptions=function(t,e){this.Options&&t&&this.SetOptions(Et.merge(t,this.Options,e))},Ct.prototype.render=function(t,e,i){},Ct.prototype.RenderComplete=function(){this.Animation=null,this.AnimationStopped=!1,this.getCtx().resetIsOffscreen(),this.dispatchEvent(yt.newReadyEvent())},Ct.prototype.getWidth=function(){return this.Width},Ct.prototype.getHeight=function(){return this.Height},Ct.prototype.highlight=function(t){},Ct.prototype.select=function(t){},Ct.prototype.dispatchEvent=function(t){this._callback&&this._callback.call&&this._callback.call(this._callbackObj,t,this)},Ct.prototype.getDimensionsWithStroke=function(t){return this.getDimensions(t)},Ct.prototype.getEventManager=function(){return this.EventManager},Ct.prototype.getKeyboardFocus=function(){var t=this.getEventManager();return t&&t.getFocus()?t.getFocus().getTargetElem():null},Ct.prototype.getCache=function(){return this._cache},Ct.prototype.getOptionsCache=function(){return this._optionsCache},Ct.prototype.StopAnimation=function(t){this.Animation&&(this.AnimationStopped=!0,this.Animation.stop(t||!1),this.Animation=null)},Ct.prototype.appendSharedDefs=function(t){var e=document.getElementById(this._SHARED_DEFS_DIV_ID);if(!e){(e=document.createElement("div")).id=this._SHARED_DEFS_DIV_ID,e.style.width="0px",e.style.height="0px",e.style.left="0px",e.style.top="0px",e.style.position="absolute";var i=u.createSvgDocument();u.setAttrNullNS(i,"width","0px"),u.setAttrNullNS(i,"height","0px");var n=A.createElement("defs");i.appendChild(n),e.appendChild(i),document.body.appendChild(e)}return(n=e.childNodes[0].childNodes[0]).appendChild(t),t},Ct.prototype.destroy=function(){this.StopAnimation(),this.EventManager&&(this.EventManager.removeListeners(this),this.EventManager.destroy(),this.EventManager=null);var t=1===document.getElementsByClassName("oj-dvtbase").length,e=document.getElementById(this._SHARED_DEFS_DIV_ID);t&&e&&document.body.removeChild(e),Ct.superclass.destroy.call(this)},Ct.prototype.renderEmptyText=function(t,e,i,n,r){var o=new mt(t.getCtx(),e,i.x+i.w/2,i.y+i.h/2);r&&o.setCSSStyle(r),o.alignCenter(),o.alignMiddle();var s=i.w-2*st.EMPTY_TEXT_BUFFER;return st.fitText(o,s,1/0,t,0)&&(o.isTruncated()&&n.associate(o,new bt(o.getUntruncatedTextString())),o.setAriaProperty("hidden",null)),o},Ct.prototype.setContextMenu=function(t){this._hasContextMenu=t},Ct.prototype.hasContextMenu=function(){return this._hasContextMenu};const At=function(t,e){this.Init(t,e)};i.createSubclass(At,i),At.TYPE_SINGLE="s",At.TYPE_MULTIPLE="m",At.prototype.Init=function(t,e){this._context=t,this._selection=[],this._type=e||At.TYPE_SINGLE,this._hiddenSelectedIds=[]},At.prototype.getType=function(){return this._type},At.prototype.getSelectedCount=function(){return this._selection.length},At.prototype.getSelection=function(){return this._selection.slice(0)},At.prototype.getSelectedIds=function(){for(var t=[],e=0;e<this._selection.length;e++)t.push(this._selection[e].getId());return t.concat(this._hiddenSelectedIds)},At.prototype.processInitialSelections=function(t,e){if(this.clearSelection(!0),t&&e){for(var i=new this._context.KeySetImpl(t),n=new Map,r=0,o=0;r!==t.length&&o<e.length;o++){if((a=e[o]).isSelectable&&a.isSelectable()){var s=i.get(a.getId());s!==i.NOT_A_KEY&&(r++,n.set(s,a))}}for(o=0;o<t.length;o++){var a;(a=n.get(t[o]))?this._addToSelection(a,!0,!0):this._hiddenSelectedIds.push(t[o])}}},At.prototype.processClick=function(t,e){if(t&&t.isUnrelatedToSelection&&t.isUnrelatedToSelection())return!1;var i=!1;return e&&this._type==At.TYPE_MULTIPLE?t&&t.isSelectable&&t.isSelectable()&&(i=t.isSelected()?this._removeFromSelection(t):this._addToSelection(t,!0)):i=t&&t.isSelectable&&t.isSelectable()?this._addToSelection(t,!1):this.clearSelection(),i},At.prototype.processGroupSelection=function(t,e){var i;e||this.clearSelection();for(var n=0;n<t.length;n++)(i=t[n])&&i.isUnrelatedToSelection&&i.isUnrelatedToSelection()||this._addToSelection(i,!0)},At.prototype.processMouseOver=function(t){t&&t.isSelectable&&t.isSelectable()&&t.showHoverEffect&&t.showHoverEffect()},At.prototype.processMouseOut=function(t){t&&t.isSelectable&&t.isSelectable()&&t.hideHoverEffect&&t.hideHoverEffect()},At.prototype._addToSelection=function(t,e,i){return!(t.isSelected()||t.isSelectable&&!t.isSelectable())&&(e||this.clearSelection(i),t.setSelected(!0,i),this._selection.push(t),!0)},At.prototype._removeFromSelection=function(t){if(!t.isSelected())return!1;t.setSelected(!1);for(var e=0;e<this._selection.length;e++)if(this._selection[e]==t){this._selection.splice(e,1);break}return!0},At.prototype.clearSelection=function(t){if(this._selection.length<=0&&this._hiddenSelectedIds.length<=0)return!1;for(;this._selection.length>0;){this._selection.pop().setSelected(!1,t)}return this._hiddenSelectedIds.length=0,!0};const Ot=function(t,e){this._callback=t,this._callbackObj=e,this._source=e,this._bHighlightMode=!1,this._hoverDelayCallback=null,this._highlightModeTimeout=null,this._hoverDelay=Ot._HOVER_DELAY};i.createSubclass(Ot,i),Ot._HOVER_DELAY=50,Ot._HOVER_TIMEOUT=1e3,Ot._ROLLOUT_TIMEOUT=250,Ot._FADE_OUT_OPACITY=.35,Ot.prototype.processEvent=function(t,e,i,n,r){if(t&&e&&0!=e.length){this._hoverDelayCallback&&(clearTimeout(this._hoverDelayCallback),this._hoverDelayCallback=null);var o=t._highlightType;if("over"==o){var s=this._bHighlightMode?this._hoverDelay:i;this._hoverDelayCallback=setTimeout(this.GetRolloverCallback(t,e,n,r),s),this._highlightModeTimeout&&(clearInterval(this._highlightModeTimeout),this._highlightModeTimeout=null)}else if("out"==o){var a=this._bHighlightMode?this._hoverDelay:Ot._ROLLOUT_TIMEOUT;this._hoverDelayCallback=setTimeout(this.GetRolloutCallback(t,e,n,r),a)}}},Ot.prototype.GetRolloverCallback=function(t,e,n,r){return i.createCallback(this,function(){this._bHighlightMode=!0,Ot.highlight(t.categories,e,n,r),this.FireCallback(t)})},Ot.prototype.GetRolloutCallback=function(t,e,n,r){return i.createCallback(this,function(){Ot.highlight(t.categories,e,n,r),this.SetHighlightModeTimeout(),this.FireCallback(t)})},Ot.prototype.FireCallback=function(t){this._callback&&this._callback.call(this._callbackObj,t,this._source)},Ot.highlight=function(t,e,i,n){if(e)for(var r=n||Ot._FADE_OUT_OPACITY,o=0;o<e.length;o++){var s=e[o];if(s&&s.getCategories){var a=i?Ot._hasAnyCategory(s,t):Ot._hasAllCategories(s,t),h=t&&t.length>0&&!a;Ot._highlightObj(s,h,r)}}},Ot._highlightObj=function(t,e,i){var n=e?i:1;if(t.highlight)t.highlight(e,n);else{var r=t.getDisplayables();Ot._updateAlpha(r,n)}},Ot._updateAlpha=function(t,e){if(t)for(var i=0;i<t.length;i++)t[i].setAlpha(e)},Ot._hasAnyCategory=function(t,e){return!(!t||!t.getCategories)&&d.hasAnyItem(t.getCategories(),e)},Ot._hasAllCategories=function(t,e){return!(!t||!t.getCategories)&&d.hasAllItems(t.getCategories(),e)},Ot.prototype.SetHighlightMode=function(t){this._bHighlightMode=t},Ot.prototype.SetHighlightModeTimeout=function(){var t=i.createCallback(this,function(){this.SetHighlightMode(!1)});this._highlightModeTimeout=setTimeout(t,Ot._HOVER_TIMEOUT)},Ot.prototype.setHoverDelay=function(t){this._hoverDelay=t};const It=function(t,e,i,n){this.Init(t,e,i,n)};i.createSubclass(It,i),It.CLEAR_SELECTION_ACTION_TYPE="clearSelectionActionType",It.TOUCH_RESPONSE_TOUCH_START="touchStart",It.TOUCH_RESPONSE_TOUCH_HOLD="touchHold",It.TOUCH_RESPONSE_AUTO="auto",It._TOUCH_RESPONSE_PADDING_CHECK=10,It._EVENT_INFO_TOOLTIP_DISPLAYED_KEY="tooltipDisplayed",It.prototype.Init=function(t,e,i,n){this._context=t,this._callback=e,this._callbackObj=i,this._component=n,this._touchMap={},this._selectionHandler=null,this.KeyboardHandler=null,this.RolloverHandler=this.CreateCategoryRolloverHandler(e,i),this.setTooltipsEnabled(!0);var o=t.getStage().getId();o||(o="undefinedId"),this.CustomTooltipManager=this._context.getCustomTooltipManager(),this.CustomTooltipManager.addTooltipEventListener("actionTooltipClosed",this.OnActionTooltipClosed,this),this.CustomTooltipManager.addTooltipEventListener("actionTooltipStarted",this.OnActionTooltipStarted,this),this.TouchManager=null,r.isTouchDevice()&&(this.TouchManager=new ft("touchmanager",this._context,this)),this._focusedObj=null,this._shouldDisplayKeyboardFocus=!1,this._keyboardHandlers=[this],this._currentKeyboardHandlerIdx=-1,this._dndListeners={}},It.prototype.getCtx=function(){return this._context},It.prototype.associate=function(t,e,i){t&&(t._logicalObjects&&!i||(t._logicalObjects=[]),t._logicalObjects.push({logicalObject:e,eventManager:this}))},It.prototype.addListeners=function(t){if(t&&(r.isTouchDevice()?(this.hideTooltip(),t.addEvtListener(L.TOUCHSTART,this.OnTouchStartBubble,!1,this),t.addEvtListener(L.TOUCHMOVE,this.OnTouchMoveBubble,!1,this),t.addEvtListener(L.TOUCHEND,this.OnTouchEndBubble,!1,this),this.TouchManager.addTouchEventListener(dt.TOUCH_HOVER_START_TYPE,this.OnComponentTouchHoverStart,this),this.TouchManager.addTouchEventListener(dt.TOUCH_HOVER_MOVE_TYPE,this.OnComponentTouchHoverMove,this),this.TouchManager.addTouchEventListener(dt.TOUCH_HOVER_END_TYPE,this.OnComponentTouchHoverEnd,this),this.TouchManager.addTouchEventListener(dt.TOUCH_HOVER_OUT_TYPE,this.OnComponentTouchHoverOut,this),this.TouchManager.addTouchEventListener(dt.TOUCH_HOVER_OVER_TYPE,this.OnComponentTouchHoverOver,this),this.TouchManager.addTouchEventListener(dt.TOUCH_CLICK_TYPE,this.OnComponentTouchClick,this),this.TouchManager.addTouchEventListener(dt.TOUCH_DOUBLE_CLICK_TYPE,this.OnComponentTouchDblClick,this)):(t.addEvtListener(F.CLICK,this._onClick,!1,this),t.addEvtListener(F.DBLCLICK,this._onDblClick,!1,this),t.addEvtListener("contextmenu",this.OnContextMenu,!1,this),t.addEvtListener(F.MOUSEMOVE,this.OnMouseMove,!1,this),t.addEvtListener(F.MOUSEOVER,this.PreOnMouseOver,!1,this),t.addEvtListener(F.MOUSEOUT,this.PreOnMouseOut,!1,this),t.addEvtListener(F.MOUSEDOWN,this.PreOnMouseDown,!1,this),t.addEvtListener(F.MOUSEUP,this.OnMouseUp,!1,this),t.addEvtListener(P.KEYDOWN,this.OnKeyDown,!1,this),t.addEvtListener(P.KEYUP,this.OnKeyUp,!1,this),t.addEvtListener(H.FOCUS,this.OnFocus,!1,this),t.addEvtListener(H.BLUR,this.OnBlur,!1,this),"safari"===r.browser&&this.getCtx()._parentDiv.addEventListener("wheel",()=>{})),this.isDndSupported())){var e=this.getCtx();this.setDragSource(new a(e)),this._addDndListener("dragstart",this.OnDndDragStart),this._addDndListener("drag",this.OnDndDrag),this._addDndListener("dragend",this.OnDndDragEnd),this._addDndListener("dragenter",this.OnDndDragEnter),this._addDndListener("dragover",this.OnDndDragOver),this._addDndListener("dragleave",this.OnDndDragLeave),this._addDndListener("drop",this.OnDndDrop);var i=e.getContainer();for(var n in this._dndListeners)u.addDomEventListener(i,n,this._dndListeners[n],!1);this._context.addDndEventManager(this)}},It.prototype._addDndListener=function(t,e){var i=gt.createStaticCallback(this.getCtx(),e,this);this._dndListeners[t]=i},It.prototype.removeListeners=function(t,e){t&&(e||this.hideTooltip(),this.RemoveListeners(t))},It.prototype.RemoveListeners=function(t){if(r.isTouchDevice()?(t.removeEvtListener(L.TOUCHSTART,this.OnTouchStartBubble,!1,this),t.removeEvtListener(L.TOUCHMOVE,this.OnTouchMoveBubble,!1,this),t.removeEvtListener(L.TOUCHEND,this.OnTouchEndBubble,!1,this),this.TouchManager.removeTouchEventListener(dt.TOUCH_HOVER_START_TYPE,this.OnComponentTouchHoverStart,this),this.TouchManager.removeTouchEventListener(dt.TOUCH_HOVER_MOVE_TYPE,this.OnComponentTouchHoverMove,this),this.TouchManager.removeTouchEventListener(dt.TOUCH_HOVER_END_TYPE,this.OnComponentTouchHoverEnd,this),this.TouchManager.removeTouchEventListener(dt.TOUCH_HOVER_OUT_TYPE,this.OnComponentTouchHoverOut,this),this.TouchManager.removeTouchEventListener(dt.TOUCH_HOVER_OVER_TYPE,this.OnComponentTouchHoverOver,this),this.TouchManager.removeTouchEventListener(dt.TOUCH_CLICK_TYPE,this.OnComponentTouchClick,this),this.TouchManager.removeTouchEventListener(dt.TOUCH_DOUBLE_CLICK_TYPE,this.OnComponentTouchDblClick,this)):(t.removeEvtListener(F.CLICK,this._onClick,!1,this),t.removeEvtListener(F.DBLCLICK,this._onDblClick,!1,this),t.removeEvtListener("contextmenu",this.OnContextMenu,!1,this),t.removeEvtListener(F.MOUSEMOVE,this.OnMouseMove,!1,this),t.removeEvtListener(F.MOUSEOVER,this.PreOnMouseOver,!1,this),t.removeEvtListener(F.MOUSEOUT,this.PreOnMouseOut,!1,this),t.removeEvtListener(F.MOUSEDOWN,this.PreOnMouseDown,!1,this),t.removeEvtListener(F.MOUSEUP,this.OnMouseUp,!1,this),t.removeEvtListener(P.KEYDOWN,this.OnKeyDown,!1,this),t.removeEvtListener(P.KEYUP,this.OnKeyUp,!1,this),t.removeEvtListener(H.FOCUS,this.OnFocus,!1,this),t.removeEvtListener(H.BLUR,this.OnBlur,!1,this)),this.isDndSupported()){var e=this.getCtx().getContainer();for(var i in this._dndListeners)u.removeDomEventListener(e,i,this._dndListeners[i],!1);this._dndListeners={},this._context.removeDndEventManager(this)}},It.prototype.destroy=function(){this.CustomTooltipManager&&(this.CustomTooltipManager.removeTooltipEventListener("actionTooltipClosed",this.OnActionTooltipClosed,this),this.CustomTooltipManager.removeTooltipEventListener("actionTooltipStarted",this.OnActionTooltipStarted,this))},It.prototype.PreEventBubble=function(t){this.TouchManager.preEventBubble(t)},It.prototype.setSelectionHandler=function(t){this._selectionHandler=t},It.prototype.getSelectionHandler=function(t){return this._selectionHandler},It.prototype.getMarqueeGlassPane=function(){return null},It.prototype.setDragSource=function(t){this.DragSource=t,r.isTouchDevice()&&this.DragSource.setTouchManager(this.TouchManager)},It.prototype.setKeyboardHandler=function(t){r.isTouchDevice()||(this.KeyboardHandler=t)},It.prototype.getKeyboardHandler=function(){return this.KeyboardHandler},It.prototype.setFocusObj=function(t){var e=this.getFocus();if(t!=e&&(this.setFocus(t),e&&e.hideKeyboardFocusEffect(),this._currentKeyboardHandlerIdx>-1&&this._currentKeyboardHandlerIdx<this._keyboardHandlers.length)){var i=this._keyboardHandlers[this._currentKeyboardHandlerIdx];i!=this&&i.hideKeyboardFocusEffect()}this.setCurrentKeyboardHandler(this)},It.prototype.setFocus=function(t){this.KeyboardHandler&&(this._focusedObj=t)},It.prototype.getFocus=function(){return this.KeyboardHandler?this._focusedObj:null},It.prototype.setFocused=function(t){var e=this.getFocus();e&&this.KeyboardHandler&&(t?this._shouldDisplayKeyboardFocus&&this._currentKeyboardHandlerIdx>=0&&this._currentKeyboardHandlerIdx<this._keyboardHandlers.length&&this._keyboardHandlers[this._currentKeyboardHandlerIdx]===this&&e.showKeyboardFocusEffect():e.hideKeyboardFocusEffect()),t||(this._shouldDisplayKeyboardFocus=!1)},It.prototype.setTooltipsEnabled=function(t){this._tooltipsEnabled=t},It.prototype.getTooltipsEnabled=function(t){return this._tooltipsEnabled},It.prototype.GetLogicalObject=function(t,e){return this.GetLogicalObjectAndDisplayable(t,e).logicalObject},It.prototype.GetLogicalObjectAndDisplayable=function(t,e){for(var i=t;i;){if(i._logicalObjects)for(var n=0;n<i._logicalObjects.length;n++){var r=i._logicalObjects[n];if(r.eventManager==this){var o={};return o.logicalObject=r.logicalObject,o.displayable=i,o}}i=e?null:i.getParent()}return{}},It.prototype._getTooltipColor=function(t,e,i){if(t&&t.getDatatipColor)return t.getDatatipColor()},It.prototype.FireEvent=function(t,e){this._callback&&this._callback.call(this._callbackObj,t,e)},It.prototype.fireSelectionEvent=function(t){var e=this.getSelectionHandler(t);if(e){var i=e.getSelectedIds(),n=yt.newSelectionEvent(i);this._callback.call(this._callbackObj,n)}},It.prototype._onClick=function(t){if(this.IsDoubleClickable(t)){if(this._clickTimer&&this._clickTimer.isRunning()){var e=this._savedClickEvent;if(t.pageX==e.pageX&&t.pageY==e.pageY)return void this._savedClickCount++;this._clickTimer.stop(),this._onClickTimerEnd()}this._savedClickEvent=t,this._savedClickCount=1,this._clickTimer||(this._clickTimer=new ut(this._context,250,this._onClickTimerEnd,this,1)),this._clickTimer.reset(),this._clickTimer.start()}else this.OnClick(t)},It.prototype._onClickTimerEnd=function(){var t=this._savedClickEvent;this._savedClickEvent=null,this._savedClickCount=0,t&&this.OnClick(t)},It.prototype.OnClick=function(t){var e=this.GetLogicalObject(t.target);if(this.OnClickInternal(t),this.ProcessSelectionEventHelper(e,t.ctrlKey),this._shouldDisplayKeyboardFocus=!1,e&&this.KeyboardHandler&&e.getNextNavigable){var i=e.getNextNavigable(t);this.setFocusObj(i)}},It.prototype.IsDoubleClickable=function(t){var e=this.GetLogicalObject(t.target);return!!(e&&e.isDoubleClickable&&e.isDoubleClickable())},It.prototype.ProcessSelectionEventHelper=function(t,e){var i=this.getSelectionHandler(t);i&&(i.processClick(t,e)&&this.fireSelectionEvent(t))},It.prototype._onDblClick=function(t){var e=this.IsDoubleClickable(t);(e&&2===this._savedClickCount||!e)&&this.OnDblClick(t),this._savedClickCount=0},It.prototype.OnDblClick=function(t){this._clickTimer&&this._clickTimer.isRunning()&&(this._clickTimer.stop(),this._savedClickEvent=null),this.OnDblClickInternal(t)},It.prototype.OnContextMenu=function(t){var e=this.GetLogicalObject(t.target);e&&e.getNextNavigable&&this.setFocus(e),this._onContextMenuHelper(t,e)},It.prototype._onContextMenuHelper=function(t,e){(this._processActionPopup(t.target,new n(t.pageX,t.pageY))&&t.preventDefault(),e&&e.isSelectable&&e.isSelectable())&&("mac"===r.os&&e.isSelected()||this.ProcessSelectionEventHelper(e,t.ctrlKey))},It.prototype.OnKeyDown=function(t){this._bKeyDown=!0;var e,i,n=t.keyCode,r=!1;for(e=this._currentKeyboardHandlerIdx<0||this._currentKeyboardHandlerIdx>this._keyboardHandlers.length?n==P.TAB&&t.shiftKey?this._keyboardHandlers.length-1:0:this._currentKeyboardHandlerIdx,i=n==P.TAB&&t.shiftKey?-1:1;e>=0&&e<this._keyboardHandlers.length&&!r;e+=i){var o=this._keyboardHandlers[e];(r=o===this?this.ProcessKeyboardEvent(t):o.handleKeyboardEvent(t))&&(this._currentKeyboardHandlerIdx=e)}return r||t.keyCode!=P.UP_ARROW&&t.keyCode!=P.DOWN_ARROW&&t.keyCode!=P.LEFT_ARROW&&t.keyCode!=P.RIGHT_ARROW||It.consumeEvent(t),r||n!=P.TAB||(this._currentKeyboardHandlerIdx=-1),r},It.prototype.handleKeyboardEvent=function(t){return this.OnKeyDown(t)},It.prototype.hideKeyboardFocusEffect=function(){var t=this.getFocus();t&&t.isShowingKeyboardFocusEffect()&&t.hideKeyboardFocusEffect()},It.prototype.ProcessKeyboardEvent=function(t){if(!this.KeyboardHandler)return!1;this.hideTooltip();var e,i,n=this.getFocus();return t.keyCode==P.TAB&&n?n.isShowingKeyboardFocusEffect()?(this._bKeyDown=!1,n.hideKeyboardFocusEffect(),this.ProcessRolloverEvent(t,n,!1),!!(i=t.shiftKey?this._context.previousKeyboardFocus():this._context.nextKeyboardFocus())&&(i.FireListener(t,!1),It.consumeEvent(t),!0)):(this.ShowFocusEffect(t,n),this.ProcessRolloverEvent(t,n,!0),It.consumeEvent(t),!0):!!(e=this.KeyboardHandler.processKeyDown(t))&&(this.setFocus(e),this._shouldDisplayKeyboardFocus=!0,n&&(n.hideKeyboardFocusEffect(),this.ProcessRolloverEvent(t,n,!1)),this.KeyboardHandler.isSelectionEvent(t)?this.ProcessSelectionEventHelper(e,t.shiftKey):this.KeyboardHandler.isMultiSelectEvent(t)&&this.ProcessSelectionEventHelper(e,t.ctrlKey),this.ShowFocusEffect(t,e),this.ProcessRolloverEvent(t,e,!0),!0)},It.prototype.ShowFocusEffect=function(t,e){e.showKeyboardFocusEffect();var i=e.getKeyboardTooltipLocation?e.getKeyboardTooltipLocation():e.getKeyboardBoundingBox(this.getCtx().getStage()).getCenter(),n=this.getCtx().stageToPageCoords(i.x,i.y);this.ProcessObjectTooltip(t,n.x,n.y,e,e.getTargetElem()),this.UpdateActiveElement(e)},It.prototype.OnKeyUp=function(t){if(this._bKeyDown=!1,!0===this._handleExternalKeyboardFocus&&t.keyCode==P.TAB&&(this._handleExternalKeyboardFocus=!1,document.createEvent)){var e=document.createEvent("KeyboardEvent"),i=t.keyCode,n=t.ctrlKey,r=t.shiftKey;void 0!==e.initKeyboardEvent?e.initKeyboardEvent(P.KEYDOWN,!0,!0,window,n,!1,r,!1,i,i):e.initKeyEvent(P.KEYDOWN,!0,!0,window,n,!1,!1,r,i,i);var o=k.newEvent(e);o.keyCode=i,o.ctrlKey=n,o.shiftKey=r;var s=this.getCtx().getStage().getSVGRoot().parentNode;G._bubbleListener.call(s,o)}},It.prototype.OnMouseMove=function(t){var e=t.pageX,i=t.pageY,n=this.GetLogicalObjectAndDisplayable(t.target),r=n.logicalObject,o=n.displayable;r&&this.ProcessObjectTooltip(t,e,i,r,o)},It.prototype.PreOnMouseOver=function(t){this.OnMouseOver(t)},It.prototype.OnMouseOver=function(t){var e=this.GetLogicalObjectAndDisplayable(t.target),i=e.logicalObject,n=e.displayable;if(i){var r=this.getSelectionHandler(i);r&&r.processMouseOver(i),this.ProcessRolloverEvent(t,i,!0),this.UpdateActiveElement(i,n)}},It.prototype.PreOnMouseOut=function(t){var e=this.GetLogicalObject(t.relatedTarget),i=this.GetLogicalObject(t.target);i&&i===e||this.OnMouseOut(t)},It.prototype.OnMouseOut=function(t){var e=this.GetLogicalObject(t.target);if(e&&e!=this.GetLogicalObject(t.relatedTarget)){var i=this.getSelectionHandler(e);i&&i.processMouseOut(e),this.ProcessRolloverEvent(t,e,!1),this.hideTooltip()}},It.prototype.PreOnMouseDown=function(t){this.OnMouseDown(t)},It.prototype.OnMouseDown=function(t){this.isInActionPopup()&&this.CustomTooltipManager.closeActionTooltip();var e=this.GetLogicalObject(t.target);this.DragSource&&!t.dragSourceSet&&this.IsDragCandidate(e)&&(this.DragSource.setDragCandidate(e),t.dragSourceSet=!0)},It.prototype.OnMouseUp=function(t){},It.prototype._processTouchTooltip=function(t){var e=this.TouchManager.getTooltipInfo(),i=e.touchIds,n=e.tooltipTarget;if(this.GetEventInfo(t,It._EVENT_INFO_TOOLTIP_DISPLAYED_KEY)||0!=i.length&&n){var r=this.TouchManager.calcAveragePosition(i),o=this.GetLogicalObject(n);this.ProcessObjectTooltip(t,r.x,r.y,o,null)}else this.hideTooltip()},It.prototype.OnTouchStartBubble=function(t){if(this.PreEventBubble(t),t.isInitialTouch()&&(this._popupJustClosed=!1),this.DragSource){var e=this.GetLogicalObject(t.target);!t.dragSourceSet&&this.IsDragCandidate(e)&&(this.DragSource.setDragCandidate(e),t.dragSourceSet=!0)}this.isInActionPopup()&&(this.CustomTooltipManager.closeActionTooltip(),this.TouchManager.resetTouchHold()),this.HandleImmediateTouchStartInternal(t),this.TouchManager.fireLogicalEvents(t),this.TouchManager.postEventBubble(t),this.isTouchResponseTouchStart()?(this._touchResponseHandled=!0,this.TouchManager.processAssociatedTouchAttempt(t,It.TOUCH_RESPONSE_TOUCH_START,this._saveTouchStart,this)):(this._touchResponseHandled=!1,this._processTouchTooltip(t))},It.prototype.OnTouchMoveBubble=function(t){this.PreEventBubble(t),this.TouchManager&&(this._prevActionClear=!1,this.HandleImmediateTouchMoveInternal(t),this.TouchManager.fireLogicalEvents(t),this.TouchManager.postEventBubble(t),this._processTouchTooltip(t))},It.prototype._handleTouchEndTimer=function(){for(var t=0;t<this._touchEndTimer.length;t++){var e=this._touchEndTimer[t];e.timer.stop();var i=e.event;this.TouchManager&&(this.HandleImmediateTouchEndInternal(i),this.TouchManager.fireLogicalEvents(i),this.TouchManager.postEventBubble(i))}this._touchEndTimer=new Array},It.prototype.OnTouchEndBubble=function(t){this.PreEventBubble(t);var e=new ut(this._context,0,this._handleTouchEndTimer,this,1);this._touchEndTimer||(this._touchEndTimer=new Array),this._touchEndTimer.push({event:t,timer:e}),e.start()},It.prototype.HandleImmediateTouchStartInternal=function(t){},It.prototype.HandleImmediateTouchMoveInternal=function(t){},It.prototype.HandleImmediateTouchEndInternal=function(t){},It.prototype.OnComponentTouchHoverStart=function(t){this.HandleTouchHoverStartInternal(t),this._touchResponseHandled||this.HandleTouchActionsStart(t)},It.prototype.OnComponentTouchHoverMove=function(t){this.HandleTouchHoverMoveInternal(t),this._touchResponseHandled||this.HandleTouchActionsMove(t)},It.prototype.OnComponentTouchHoverEnd=function(t){if(this.HandleTouchHoverEndInternal(t),this._callbackObj instanceof Ct){var e=this.getCtx().getStageAbsolutePosition(),i=t.touch.pageX,n=t.touch.pageY;i<=e.x+this._callbackObj.getWidth()&&i>=e.x&&n<=e.y+this._callbackObj.getHeight()&&n>=e.y&&this._callback.call(this._callbackObj,yt.newTouchHoldReleaseEvent(t.getNativeEvent()))}this._touchResponseHandled||this.HandleTouchActionsEnd(t)},It.prototype.OnComponentTouchHoverOut=function(t){var e=this.GetLogicalObject(t.relatedTarget),i=this.GetLogicalObject(t.target);i&&i===e||(this.HandleTouchHoverOutInternal(t),this._touchResponseHandled||this.HandleTouchActionsOut(t))},It.prototype.OnComponentTouchHoverOver=function(t){this.HandleTouchHoverOverInternal(t),this._touchResponseHandled||this.HandleTouchActionsOver(t)},It.prototype.OnComponentTouchDblClick=function(t){this.HandleTouchDblClickInternal(t)},It.prototype.OnComponentTouchClick=function(t){var e=this.GetLogicalObjectAndDisplayable(t.target),i=e.logicalObject,r=e.displayable,o=t.touch;this.HandleTouchClickInternal(t)||(this.isTouchResponseTouchStart()||this._processTouchSelection(i),this._popupJustClosed||this._processTouchSelectionClear(i),this.CustomTooltipManager.displayActionPopup()&&(this.UpdateActionTooltipLaunchedFeedback(r,new n(o.pageX,o.pageY)),this.CustomTooltipManager.startActionPopupAtPosition(o.pageX,o.pageY,r)))},It.prototype._processTouchSelection=function(t,e){var i=this.getSelectionHandler(t);!(i&&t&&t.isSelectable&&t.isSelectable())||e&&t.isSelected()||i.processClick(t,!0)&&this.fireSelectionEvent(t),this._prevActionClear=!1},It.prototype._processTouchSelectionClear=function(t){var e=this.getSelectionHandler(t);if(e&&(!t||!t.isSelectable||!t.isSelectable())&&!this._prevActionClear){var i=!1;e.getType()==At.TYPE_MULTIPLE&&e.getSelectedCount()>1&&(i=!0),i?this.addClearAllActionItem():e.processClick(null,!1)&&this.fireSelectionEvent(t)}},It.prototype.OnActionTooltipClosed=function(t){this._popupJustClosed=!0,this._isInActionPopup=!1,this.CustomTooltipManager.getActionTooltip().containsMenuId(It.CLEAR_SELECTION_ACTION_TYPE)&&(this._prevActionClear=!0),this.CustomTooltipManager.clearActionTooltip(),this.UpdateActionTooltipClosedFeedback(t.target)},It.prototype.OnActionTooltipStarted=function(t){this._isInActionPopup=!0},It.prototype._getTooltipInfo=function(t,e,i,n){var r=null,o=!1;return e&&e.getDatatip&&(r=e.getDatatip(t,i,n))&&(o=!0),!r&&e&&e.getTooltip&&(r=e.getTooltip(t,i,n)),{text:r,isDatatip:o}},It.prototype._processShowTooltip=function(t,e,i,n){if(this.getTooltipsEnabled(e)){var r=this._context.pageToStageCoords(i,n),o=r.x,s=r.y,a=this._getTooltipInfo(t,e,o,s),h=a.isDatatip,l=a.text;if(l){this.CustomTooltipManager.clearActionTooltip();var u=this._getTooltipColor(e,o,s),c=this._context.getTooltipManager();return h?c.showDatatip(i,n,l,u):c.showTooltip(i,n,l,null,!0,u),this._hideTooltipListener||(this._hideTooltipListener=this._keyboardHideTooltip.bind(this),document.documentElement.addEventListener(P.KEYDOWN,this._hideTooltipListener,{capture:!0})),this.TooltipLaunched(l,u),this.DispatchElementEvent("tooltiplaunched"),!0}this.hideTooltip()}else this.hideTooltip();return!1},It.prototype._keyboardHideTooltip=function(t){t.keyCode===P.ESCAPE&&(this.hideTooltip(),t.preventDefault())},It.prototype.hideTooltip=function(){var t=this._context.getTooltipManager();t&&t.hideTooltip(),this.TooltipHidden(),this._hideTooltipListener&&(document.documentElement.removeEventListener(P.KEYDOWN,this._hideTooltipListener,{capture:!0}),this._hideTooltipListener=null)},It.prototype._processActionPopup=function(t,e){return this.CustomTooltipManager.displayActionPopup()?(this.SetupTouchTooltip(t),this.UpdateActionPopupShownFeedback(t),this.CustomTooltipManager.startActionPopupAtPosition(e.x,e.y,t),!0):(this.UpdateActionPopupHiddenFeedback(t),!1)},It.prototype.TooltipLaunched=function(t,e){},It.prototype.TooltipHidden=function(){},It.prototype.SetupTouchTooltip=function(t){var e=this.GetLogicalObject(t),i=this.CustomTooltipManager.getActionTooltip();if(null==i.getTooltipBorderColor()){var n=this._getTooltipColor(e);i.setTooltipBorderColor(n)}},It.prototype.OnClickInternal=function(t){},It.prototype.OnDblClickInternal=function(t){},It.prototype.HandleTouchHoverStartInternal=function(t){},It.prototype.HandleTouchHoverMoveInternal=function(t){},It.prototype.HandleTouchHoverEndInternal=function(t){},It.prototype.HandleTouchHoverOverInternal=function(t){},It.prototype.HandleTouchHoverOutInternal=function(t){},It.prototype.HandleTouchClickInternal=function(t){return!1},It.prototype.HandleTouchDblClickInternal=function(t){},It.prototype.UpdateActionPopupShownFeedback=function(t){},It.prototype.UpdateActionPopupHiddenFeedback=function(t){},It.prototype.UpdateActionTooltipClosedFeedback=function(t){},It.prototype.UpdateActionTooltipLaunchedFeedback=function(t,e){},It.prototype.isInActionPopup=function(){return this._isInActionPopup},It.prototype.GetClearSelectionText=function(){var t=this.getComponent();return t&&t.getOptions().translations.labelClearSelection},It.prototype.addClearAllActionItem=function(){var t=this.CustomTooltipManager.getActionTooltip(),e=t.getMenuItems();t&&e.length>0&&e[e.length-1].getId()===It.CLEAR_SELECTION_ACTION_TYPE||(this.addActionTooltipMenuItem(It.CLEAR_SELECTION_ACTION_TYPE,this.GetClearSelectionText(),this._actionTooltipClearListener,this),t&&t.setTooltipBorderColor(ct.DEFAULT_BORDER_COLOR))},It.prototype.addActionTooltipMenuItem=function(t,e,i,n){this.CustomTooltipManager.getActionTooltip().addMenuItem(new _t(this._context,t,e,i,n))},It.prototype._actionTooltipClearListener=function(t){var e=this.GetLogicalObject(t.target);this.getSelectionHandler(e).processClick(null,!1)&&this.fireSelectionEvent(e)},It.consumeEvent=function(t){t&&(t.preventDefault(),t.stopPropagation())},It.prototype.addComponentKeyboardHandlerAt=function(t,e){e>this._keyboardHandlers.length||t&&(this._keyboardHandlers.splice(e,0,t),e<=this._currentKeyboardHandlerIdx&&this._currentKeyboardHandlerIdx++)},It.prototype.removeComponentKeyboardHandler=function(t){if(t){var e=this._findHandler(t);e>-1&&(this._currentKeyboardHandlerIdx==e&&0==e?this._currentKeyboardHandlerIdx=0:e<=this._currentKeyboardHandlerIdx&&this._currentKeyboardHandlerIdx--,this._keyboardHandlers.splice(e,1))}},It.prototype._findHandler=function(t){for(var e=-1,i=this._keyboardHandlers.length,n=0;n<i;n++)this._keyboardHandlers[n]===t&&(e=n);return e},It.prototype.setCurrentKeyboardHandler=function(t){var e=this._findHandler(t);e>=0&&(this._currentKeyboardHandlerIdx=e)},It.prototype.IsDragCandidate=function(t){return!0},It.prototype.UpdateActiveElement=function(t,e){if(e||(e=t.getDisplayable?t.getDisplayable():t.getDisplayables?t.getDisplayables()[0]:t),e instanceof Q){if(t.getAriaLabel){var i=t.getAriaLabel();i&&e.setAriaProperty("label",i)}else for(;!e.getAriaRole()&&e.getParent();)e=e.getParent();e!=this.getCtx().getStage()&&this.getCtx().setActiveElement(e)}},It.prototype.getTouchManager=function(){return this.TouchManager},It.prototype.endDrag=function(){return null},It.prototype._hasEventInfo=function(t){return null!=t&&!!t.getNativeEvent()._eventInfo},It.prototype.GetEventInfo=function(t,e){return this._hasEventInfo(t)&&null!=e&&(i=this.StoreInfoByEventType(e)?t.getNativeEvent()._eventInfo[t.type]:t.getNativeEvent()._eventInfo)?i[e]:null;var i},It.prototype.SetEventInfo=function(t,e,i){if(null!=t&&null!=e){var n=t.getNativeEvent();if(n._eventInfo||(n._eventInfo={}),this.StoreInfoByEventType(e)){var r=t.type;n._eventInfo[r]||(n._eventInfo[r]={}),n._eventInfo[r][e]=i}else n._eventInfo[e]=i}},It.prototype.StoreInfoByEventType=function(t){return t!=It._EVENT_INFO_TOOLTIP_DISPLAYED_KEY},It.prototype.ProcessObjectTooltip=function(t,e,i,n,r){this.GetEventInfo(t,It._EVENT_INFO_TOOLTIP_DISPLAYED_KEY)||this._processShowTooltip(r,n,e,i)&&this.SetEventInfo(t,It._EVENT_INFO_TOOLTIP_DISPLAYED_KEY,!0)},It.prototype._resetExternalKeyboardFocus=function(){this._handleExternalKeyboardFocus=!1},It.prototype.OnFocus=function(t){this._handleExternalKeyboardFocus=!1,this._bKeyDown||t.isPropagationStopped()||(this._handleExternalKeyboardFocus=!0,this._keyboardFocusTimer||(this._keyboardFocusTimer=new ut(this._context,200,this._resetExternalKeyboardFocus,this,1)),this._keyboardFocusTimer.reset(),this._keyboardFocusTimer.start(),t.stopPropagation())},It.prototype.OnBlur=function(t){this._bKeyDown=!1;var e=this.getFocus();e&&e.isShowingKeyboardFocusEffect()&&e.hideKeyboardFocusEffect()},It.prototype.ProcessRolloverEvent=function(t,e,i){},It.prototype.CreateCategoryRolloverHandler=function(t,e){return new Ot(t,e)},It.prototype.GetTouchResponse=function(){return It.TOUCH_RESPONSE_TOUCH_START},It.prototype.isTouchResponseTouchStart=function(){var t=this.GetTouchResponse();if(t===It.TOUCH_RESPONSE_TOUCH_START)return!0;if(t===It.TOUCH_RESPONSE_TOUCH_HOLD)return!1;for(var e=this.getCtx().getSvgDocument().parentElement.parentElement;e;){var i=window.getComputedStyle(e);if("hidden"!==i.overflow&&(e.scrollWidth>e.clientWidth+It._TOUCH_RESPONSE_PADDING_CHECK&&"hidden"!==i["overflow-x"]||e.scrollHeight>e.clientHeight+It._TOUCH_RESPONSE_PADDING_CHECK&&"hidden"!==i["overflow-y"])||window.frameElement&&"IFRAME"==window.frameElement.nodeName)return!1;if("HTML"===e.nodeName)break;e=e.parentElement}return!0},It.prototype._saveTouchStart=function(t,e){this.TouchManager.getTouchIdsForObj(It.TOUCH_RESPONSE_TOUCH_START).length<=1&&(this.TouchManager.saveProcessedTouch(e.identifier,ft.HOVER_TOUCH_KEY,null,ft.HOVER_TOUCH_KEY,ft.HOVER_TOUCH_KEY,this.HandleTouchActionsMove,this.HandleTouchActionsEnd,this),this.HandleTouchActionsStart(t))},It.prototype.HandleTouchActionsStart=function(t){var e=this.GetLogicalObject(t.target),i=t instanceof dt?t.touch:t.touches[0];t instanceof dt||(this._touchMap[i.identifier]||(this._touchMap[i.identifier]={}),this._touchMap[i.identifier][ft.PREV_HOVER_OBJ]=null,e&&this.HandleTouchActionsOver(t),this._touchMap[i.identifier][ft.PREV_HOVER_OBJ]=e),e&&this.ProcessRolloverEvent(t,e,!0),this._processTouchTooltip(t),this._prevActionClear=!1},It.prototype.HandleTouchActionsMove=function(t){var e,i=t instanceof dt?t.touch:t.touches[0];if(t instanceof dt)e=this.GetLogicalObject(t.target);else{t.preventDefault();var n=gt.elementFromTouch(i);e=this.GetLogicalObject(n);var r=this._touchMap[i.identifier][ft.PREV_HOVER_OBJ];if(r!=e){var o;if(r)r.getDisplayable?o=r.getDisplayable():r.getDisplayables&&(o=r.getDisplayables()[0]),o&&(t.target=o,this.HandleTouchActionsOut(t,i));t.target=n,e&&this.HandleTouchActionsOver(t)}this._touchMap[i.identifier][ft.PREV_HOVER_OBJ]=e}e&&this.ProcessRolloverEvent(t,e,!0)},It.prototype.HandleTouchActionsEnd=function(t,e){var i,r;if(t instanceof dt){var o=this.GetLogicalObjectAndDisplayable(t.target);i=o.displayable,r=o.logicalObject,e=t.touch}else{var s;t.preventDefault(),i=gt.elementFromTouch(e),(r=this.GetLogicalObject(i))&&(r.getDisplayable?s=r.getDisplayable():r.getDisplayables&&(s=r.getDisplayables()[0])),s&&(t.target=s,this.HandleTouchActionsOut(t,e)),this._touchMap[e.identifier][ft.PREV_HOVER_OBJ]=null}var a=e.pageX,h=e.pageY;this._processTouchSelection(r,this._component?this._component.hasContextMenu():null),this._processActionPopup(i,new n(a,h))},It.prototype.HandleTouchActionsOver=function(t){var e=this.GetLogicalObject(t.target);e&&this.ProcessRolloverEvent(t,e,!0);var i=this.getSelectionHandler(e);i&&i.processMouseOver(e)},It.prototype.HandleTouchActionsOut=function(t,e){var i=this.GetLogicalObject(t.target);t instanceof dt&&t.touch,i&&this.ProcessRolloverEvent(t,i,!1);var n=this.getSelectionHandler(i);n&&n.processMouseOut(i)},It.prototype.getComponent=function(){return this._component},It.DROP_OFFSET_X_DATA_TYPE="text/_dvtDropOffsetX",It.DROP_OFFSET_Y_DATA_TYPE="text/_dvtDropOffsetY",It.prototype.isDndSupported=function(){return!1},It.prototype.OnDndDragStart=function(t){var e=u.getEventForSyntax(this._context,t),i=e.dataTransfer;if(!(e.dataTransfer.types&&e.dataTransfer.types.length>0)){var n=this._context.pageToStageCoords(t.pageX,t.pageY),r=this.DragSource.getDragTransferable(n.x,n.y),o=this.GetDragSourceType(t);if(null!=r&&null!=o){this._context.getTooltipManager().hideTooltip();var s=this._getDragOptions(t),a=s.dataTypes,h=s.dragStart;if(null!=a||h){var l=this.DragSource.getDragObject();if(this.ProcessSelectionEventHelper(l,!1),l.hideHoverEffect&&l.hideHoverEffect(),null!=a){Array.isArray(a)||(a=[a]);for(var _=this._getDragData(t),p=0;p<a.length;p++)i.setData(a[p],_)}var d=u.getDragFeedback(this.DragSource.getDragOverFeedback(n.x,n.y),this._context.getStage()),g=d.svg,f=this.DragSource.getDragOffset(n.x,n.y);g.style.width=d.width+"px",g.style.height=d.height+"px",g.style.left=t.pageX-f.x+"px",g.style.top=t.pageY-f.y+"px",g.style.position="absolute",g.style.fontFamily=this._context.getDefaultFontFamily(),g.style.fontSize=this._context.getDefaultFontSize(),gt.disableMouseEvents(g),document.body.appendChild(g),c(function(){document.body.removeChild(g)}),i.setDragImage(g,f.x,f.y);var y=this.GetDropOffset(t);if(y&&(i.setData(It.DROP_OFFSET_X_DATA_TYPE,y.x),i.setData(It.DROP_OFFSET_Y_DATA_TYPE,y.y)),h)h(e,this._getDragEventPayload(t))}else this._context.isLastDndEventManager(this)&&t.preventDefault()}else this._context.isLastDndEventManager(this)&&t.preventDefault()}},It.prototype.OnDndDrag=function(t){this._handleDragSourceEvent(t,"drag")},It.prototype.OnDndDragEnd=function(t){this.DragSource.setDragCandidate(null),this._handleDragSourceEvent(t,"dragEnd")},It.prototype.GetDragSourceType=function(t){return null},It.prototype.GetDragDataContexts=function(t){return[]},It.prototype.GetDropOffset=function(t){return null},It.prototype._getDragOptions=function(t){var e=this.GetDragSourceType(t);return this.getComponent().getOptions().dnd.drag[e]},It.prototype._getDragEventPayload=function(t){var e={};return e[this.GetDragSourceType(t)]=this.GetDragDataContexts(),e},It.prototype._getDragData=function(t){return JSON.stringify(this.GetDragDataContexts(!0))},It.prototype._handleDragSourceEvent=function(t,e){if(null!=this.GetDragSourceType(t)){var i=this._getDragOptions(t)[e];if(i)i(u.getEventForSyntax(this._context,t))}},It.prototype.OnDndDragEnter=function(t){this._handleDropTargetEvent(t,"dragEnter",!0)},It.prototype.OnDndDragOver=function(t){this._handleDropTargetEvent(t,"dragOver",!0)},It.prototype.OnDndDragLeave=function(t){this._handleDropTargetEvent(t,"dragLeave",!1)},It.prototype.OnDndDrop=function(t){this._handleDropTargetEvent(t,"drop",!1)},It.prototype.GetDropTargetType=function(t){return null},It.prototype.GetDropEventPayload=function(t){return null},It.prototype.ShowDropEffect=function(t){},It.prototype.ShowRejectedDropEffect=function(t){this.ClearDropEffect()},It.prototype.ClearDropEffect=function(){},It.prototype._getDropOptions=function(t){var e=this.GetDropTargetType(t);return this.getComponent().getOptions().dnd.drop[e]},It.prototype._handleDropTargetEvent=function(t,e,i){var n=this._handleDropTargetEventHelper(t,e);n||t.preventDefault(),!n&&i?this.ShowDropEffect(t):n&&i?this.ShowRejectedDropEffect(t):this.ClearDropEffect()},It.prototype._handleDropTargetEventHelper=function(t,e){if(null==this.GetDropTargetType(t))return!0;var i=u.getEventForSyntax(this._context,t),n=this._getDropOptions(t),r=n[e];if(r){var o=r(i,this.GetDropEventPayload(t));if(t.getNativeEvent().defaultPrevented)return!1;if(null!=o&&!this._context.isCustomElement())return o}var s=n.dataTypes;if(null!=s){Array.isArray(s)||(s=[s]);for(var a=0;a<s.length;a++)if(i.dataTransfer.types&&i.dataTransfer.types.indexOf(s[a])>=0)return!1}return!0},It.prototype.DispatchElementEvent=function(t,e){this.getCtx().getSvgDocument().dispatchEvent(new CustomEvent(t,{detail:e}))};const Nt=function(t,e,i,n){this._customTooltipManager=e,this.Init(t,i,n)};i.createSubclass(Nt,It),Nt.prototype.OnClickInternal=function(t){var e=t.target;this._handleMenuClick(e)},Nt.prototype.HandleImmediateTouchStartInternal=function(t,e){t.blockTouchHold(),this._handleMenuClick(t.target)},Nt.prototype.HandleTouchClickInternal=function(t){var e=t.target;this._handleMenuClick(e)},Nt.prototype._handleMenuClick=function(t){var e=this._customTooltipManager._actionPopupObj,i=t._menu;i&&(this._customTooltipManager.closeActionTooltip(),i.FireActionTooltipItem(e))};const Rt=function(t,e){this.Init(t,e)};i.createSubclass(Rt,i),Rt.prototype.Init=function(t,e){this._context=t,this._id=e,this._actionTooltip=new ct(this._context,this._id+"ActionPopup")},Rt.prototype.GetRichTooltipManager=function(){if(!this._RichTooltipManager){var t=this._id+"Tooltip";this._RichTooltipManager=new pt(this._context,t),this._RichTooltipManager.InitializeTooltipElem();var e=this._RichTooltipManager.GetStoredContext();if(e)new Nt(e,this,null,null).addListeners(this._actionTooltip)}return this._RichTooltipManager},Rt.prototype.clearActionTooltip=function(){this._actionTooltip&&this._actionTooltip.clearContent()},Rt.prototype.getActionTooltip=function(){return this._actionTooltip},Rt.prototype.hideTooltip=function(){this.clearActionTooltip(),this._RichTooltipManager&&this._RichTooltipManager.hideTooltip()},Rt.prototype.closeActionTooltip=function(){var t=yt.newActionTooltipEvent("actionTooltipClosed",this._actionPopupObj);this.FireListener(t),this._actionPopupObj=null,this.hideTooltip()},Rt.prototype.displayActionPopup=function(){var t=this.getActionTooltip();return!(!t||!t.hasMenuItems())},Rt.prototype.startActionPopupAtPosition=function(t,e,i,n){var r=this.getActionTooltip();if(r){this.GetRichTooltipManager().showRichElementAtPosition(t,e,r,!0,!1);var o=yt.newActionTooltipEvent("actionTooltipStarted",i);this.FireListener(o),this._actionPopupObj=i}},Rt.prototype.addTooltipEventListener=function(t,e,i){var n=this._getListeners(t,!0);n.push(e),n.push(i)},Rt.prototype.removeTooltipEventListener=function(t,e,i){var n=this._getListeners(t,!1);if(null!==n)for(var r=0;r<n.length;r+=2)if(n[r]===e&&n[r+1]===i){n.splice(r,2);break}},Rt.prototype._getListeners=function(t,e){if(!this._listenerObj){if(!e)return null;this._listenerObj={}}var i=t,n=this._listenerObj[i];return!n&&e&&(n=[],this._listenerObj[i]=n),n},Rt.prototype.FireListener=function(t){var e=this._getListeners(t.type,!1);if(e)for(var i=0;i<e.length;i+=2){var n=e[i+1];e[i].call(n,t)}},Rt._formatTextString=function(t){var e="";if(!t)return e;var i=(t=t.replace(/\n/g,"<br>")).split("<br>");if(i){for(var n=new Array,r=0;r<i.length;r++){var o=i[r];null!=o&&""!=o&&n.push(o)}for(r=0;r<n.length;r++)e+=n[r],r<n.length-1&&(e+="\n")}return e};const Dt=function(t,e){this._id="mask"+Dt._uniqueSeed++,this._gradient=t,this._bounds=e};i.createSubclass(Dt,i),Dt._uniqueSeed=0,Dt.prototype.getId=function(){return this._id},Dt.prototype.getGradient=function(){return this._gradient},Dt.prototype.getBounds=function(){return this._bounds};const xt=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass(xt,Q),xt._uniqueSeed=0,xt.prototype.Init=function(t,e,i,n,r){xt.superclass.Init.call(this,t,"use",r);var o=n.getId();if(o||(o="use"+xt._uniqueSeed++,n.setId(o)),t.existsGlobalDefReference(o))t.increaseGlobalDefReference(o);else{var s=n.getElem();u.setAttrNullNS(s,"id",o),t.appendDefs(s),t.increaseGlobalDefReference(o)}this._targetId=o,u.setHref(this._elem,u.getUrlPathById(o)),this.setX(e).setY(i)},Q.defineProps(xt,{x:{value:0},y:{value:0}}),xt.prototype.destroy=function(){this.getCtx().decreaseGlobalDefReference(this._targetId),xt.superclass.destroy.call(this)};const Mt=function(t,e,i){var n=e?e+"_svg":null;this._root=u.createSvgDocument(n),t.appendChild(this._root),this._parentDiv=t,this.addSizingSvg(),this._appAriaRole=this._parentDiv.getAttribute("role"),this._role=this._appAriaRole,this._referenceDiv=i,this._defs=A.createElement("defs"),u.appendChildElem(this._root,this._defs),this._keyboardFocusArray=[],this._keyboardFocusIndex=0,this._dndEventManagers=[],this.Init(this._root,e),u.appendChildElem(this._root,this._stage.getElem()),this.oj=null};i.createSubclass(Mt,i),Mt._DEFAULT_FONT_FAMILY="-apple-system, BlinkMacSystemFont, 'Segoe UI', 'Helvetica Neue', Arial, sans-serif",Mt._DEFAULT_FONT_WEIGHT="400",Mt._id=0,Mt.DEFAULT_FONT_SIZE=j.DEFAULT_FONT_SIZE;const wt=Symbol("componentAriaLabel");Mt.prototype.Init=function(t,e){var i=(e||"_dvt"+Mt._id)+"_stage";this._stage=new tt(this,t,i),Mt._id++,this._normalizedFontFamilyCache={},this.setDefaultFontSize(Mt.DEFAULT_FONT_SIZE),this.setDefaultFontFamily(Mt._DEFAULT_FONT_FAMILY),this.setDefaultFontWeight(Mt._DEFAULT_FONT_WEIGHT),this._tooltipManagers=new Object,this._customTooltipManagers=new Object,this._scheduler=null,this._globalDefsMap={}},Mt.prototype.getDefaultFontFamily=function(){return this._defaultFontFamily},Mt.prototype.setDefaultFontFamily=function(t){t&&(this._defaultFontFamily=this._normalizeFontFamily(t),u.setAttrNullNS(this._stage.getElem(),"font-family",this.getDefaultFontFamily()))},Mt.prototype.isDefaultFontFamily=function(t){return!!t&&this._defaultFontFamily===this._normalizeFontFamily(t)},Mt.prototype.getDefaultFontSize=function(){return this._defaultFontSize},Mt.prototype.getThemeBehavior=function(){return e.parseJSONFromFontFamily("oj-theme-json").behavior},Mt.prototype.setDefaultFontSize=function(t){t&&(this._defaultFontSize=t,u.setAttrNullNS(this._stage.getElem(),"font-size",this.getDefaultFontSize()))},Mt.prototype.getDefaultFontWeight=function(){return this._defaultFontWeight},Mt.prototype.setDefaultFontWeight=function(t){t&&(this._defaultFontWeight=t,u.setAttrNullNS(this._stage.getElem(),"font-weight",this.getDefaultFontWeight()))},Mt.prototype._normalizeFontFamily=function(t){var e=this._normalizedFontFamilyCache[t];return e||(e=t.replace(/, /g,",").replace(/"/g,"'"),this._normalizedFontFamilyCache[t]=e),e},Mt.prototype.getStage=function(){return this._stage},Mt.prototype.isReadyToRender=function(){if(this._destroyed)return!1;if(null!=this._parentDiv.offsetParent)return!0;var t=window.getComputedStyle(this._parentDiv);return!(!t||"fixed"!=t.position)&&"none"!=t.display},Mt.prototype.getSvgDocument=function(){return this._root},Mt.prototype.getSizingSvg=function(){return this._sizingSvg},Mt.prototype.addSizingSvg=function(){this._sizingSvg||"blink"!==r.engine&&"safari"!==r.browser||(this._root.style.position="absolute",this._root.style.left="0px",this._root.style.top="0px",this._root.style.padding="inherit",this._sizingSvg=document.createElementNS(u.SVG_NS,"svg"),this._sizingSvg.style.width="100%",this._sizingSvg.style.height="100%",this.getContainer().appendChild(this._sizingSvg))},Mt.prototype.removeSizingSvg=function(){this._sizingSvg&&(this._root.style.removeProperty("position"),this._root.style.removeProperty("left"),this._root.style.removeProperty("top"),this._root.style.removeProperty("padding"),this.getContainer().removeChild(this._sizingSvg),this._sizingSvg=null)},Mt.prototype.setReadingDirection=function(t){this._readingDirection=t},Mt.prototype.getReadingDirection=function(){return this._readingDirection},Mt.prototype.existsGlobalDefReference=function(t){return this._globalDefsMap[t]>0},Mt.prototype.increaseGlobalDefReference=function(t){null!=t&&(this._globalDefsMap[t]?this._globalDefsMap[t]++:this._globalDefsMap[t]=1)},Mt.prototype.decreaseGlobalDefReference=function(t){if(null!=t){var e=this._globalDefsMap[t];e&&(1==e?delete this._globalDefsMap[t]:this._globalDefsMap[t]=e-1),this._globalDefsMap[t]||this.removeDefsById(t)}},Mt.prototype.getTooltipManager=function(t){return t||(t="_dvtTooltip"),t+=this.getStage().getId(),this._tooltipManagers[t]||(this._tooltipManagers[t]=new it(this,t)),this._tooltipManagers[t]},Mt.prototype.hideTooltips=function(){for(var t in this._tooltipManagers)this._tooltipManagers[t].hideTooltip()},Mt.prototype.releaseTooltipResources=function(){for(var t in this._tooltipManagers)this._tooltipManagers[t].releaseTooltipResources()},Mt.prototype.getScheduler=function(){return this._scheduler||(this._scheduler=new et(this)),this._scheduler},Mt.prototype.pageToStageCoords=function(t,e){var i=this.getStageAbsolutePosition(),r=t-i.x,o=e-i.y;return new n(r,o)},Mt.prototype.stageToPageCoords=function(t,e){var i=this.getStageAbsolutePosition(),r=t+i.x,o=e+i.y;return new n(r,o)},Mt.prototype.getStageAbsolutePosition=function(){var t=this._referenceDiv;if(!t){var e=this.getStage().getSVGRoot();t=e.parentNode?e.parentNode:e}var i=r.getElementPosition(t);return new n(parseInt(i.x),parseInt(i.y))},Mt.prototype.isOffscreen=function(t){if(null!=this._bOffscreen&&!t)return this._bOffscreen;var e,i=this.getStage().getSVGRoot();try{var n=i.getBoundingClientRect();e=n.bottom<0||n.right<0||n.top>(window.innerHeight||document.documentElement.clientHeight)||n.left>(window.innerWidth||document.documentElement.clientWidth)}catch(t){e=!0}return t||(this._bOffscreen=e),e},Mt.prototype.resetIsOffscreen=function(){this._bOffscreen=null},Mt.prototype.getCustomTooltipManager=function(t){return t||(t="_dvtCustomTooltip"),t+=this.getStage().getId(),this._customTooltipManagers[t]||(this._customTooltipManagers[t]=new Rt(this,t)),this._customTooltipManagers[t]},Mt.prototype.appendDefs=function(t){u.appendChildElem(this._defs,t)},Mt.prototype.getDefs=function(){return this._defs},Mt.prototype.removeDefs=function(t){t._obj&&t._obj.destroy(),this._defs.removeChild(t)},Mt.prototype.removeDefsById=function(t){for(var e=this._defs.childNodes,i=e.length,n=0;n<i;n++){var r=e[n];if(r.id===t)return void this.removeDefs(r)}},Mt.prototype.getRootAttribute=function(t){return u.getAttrNullNS(this._root,t)},Mt.resetUniqueSeeds=function(){D._counter=0,p._uniqueSeed=0,A._uniqueSeed=0,Dt._uniqueSeed=0,xt._uniqueSeed=0,r._bInitialized=!1},Mt.resetCaches=function(){st.clearCaches()},Mt.prototype.setActiveElement=function(t){this._activeElement&&(u.removeAttrNullNS(this._activeElement.getElem(),"id"),this._activeElement=null);var e=t.getElem(),i=u.getAttrNullNS(e,"id");i||(i=Mt._generateActiveElementId(t),u.setAttrNullNS(e,"id",i),this._activeElement=t),t.applyAriaProperties(),"application"==this._role&&this._parentDiv.setAttribute("aria-activedescendant",i)},Mt._generateActiveElementId=function(t){var e="_dvtActiveElement"+(r.isEnvironmentTest()?"":Math.floor(1e9*Math.random())),i=t.getId();return"string"==typeof i||i instanceof String||"number"==typeof i||i instanceof Number?e+"_"+i:e},Mt.prototype.setAriaLabel=function(t){this._parentDiv.getAttribute("aria-label")&&!this._parentDiv[wt]||(this._parentDiv[wt]=!0,t?this._parentDiv.setAttribute("aria-label",O.processAriaLabel(t)):this._parentDiv.removeAttribute("aria-label"))},Mt.prototype.setAriaRole=function(t){this._appAriaRole||(t?this._parentDiv.setAttribute("role",t):this._parentDiv.removeAttribute("role"),this._role=t)},Mt.prototype.setTooltipAttachedCallback=function(t){this._tooltipAttachedCallback=t},Mt.prototype.getTooltipAttachedCallback=function(){return this._tooltipAttachedCallback},Mt.prototype.resetCurrentKeyboardFocus=function(t){this._keyboardFocusArray&&0!==this._keyboardFocusArray.length&&(t.keyCode==P.TAB&&t.shiftKey?this.setCurrentKeyboardFocus(this._keyboardFocusArray[this._keyboardFocusArray.length-1]):t.keyCode==P.TAB&&this.setCurrentKeyboardFocus(this._keyboardFocusArray[0]))},Mt.prototype.setKeyboardFocusArray=function(t){(this._keyboardFocusArray=t,this._keyboardFocusIndex=0,t.length>0)&&(this._root.parentNode._currentObj=this._keyboardFocusArray[this._keyboardFocusIndex])},Mt.prototype.getCurrentKeyboardFocus=function(){return this._keyboardFocusArray.length<=this._keyboardFocusIndex?null:this._keyboardFocusArray[this._keyboardFocusIndex]},Mt.prototype.setCurrentKeyboardFocus=function(t){var e=this._keyboardFocusArray.indexOf(t);if(-1==e)return!1;var i=this._keyboardFocusArray[e];return this._keyboardFocusIndex=e,this._root.parentNode._currentObj=i,!0},Mt.prototype.nextKeyboardFocus=function(){var t=this._keyboardFocusArray[this._keyboardFocusIndex+1];return t?(this._keyboardFocusIndex++,this._root.parentNode._currentObj=t,t):null},Mt.prototype.previousKeyboardFocus=function(){var t=this._keyboardFocusArray[this._keyboardFocusIndex-1];return t?(this._keyboardFocusIndex--,this._root.parentNode._currentObj=t,t):null},Mt.prototype.getNumberConverter=function(t){var e=this.getLocaleHelpers();return e.createNumberConverter?e.createNumberConverter(t):null},Mt.prototype.getLocaleHelpers=function(){return this._localeHelpers?this._localeHelpers:{}},Mt.prototype.setLocaleHelpers=function(t){this._localeHelpers=t},Mt.requestAnimationFrame=c,Mt.cancelAnimationFrame=_,Mt.prototype.getContainer=function(){return this._parentDiv},Mt.prototype.createOverlayDiv=function(){var t=document.createElement("div");return t.style.top="-100%",t.style.position="relative",t},Mt.prototype.setOverlayAttachedCallback=function(t){this._overlayAttachedCallback=t},Mt.prototype.getOverlayAttachedCallback=function(){return this._overlayAttachedCallback},Mt.prototype.addDndEventManager=function(t){this._dndEventManagers.push(t)},Mt.prototype.removeDndEventManager=function(t){var e=this._dndEventManagers.indexOf(t);this._dndEventManagers.splice(e,1)},Mt.prototype.isLastDndEventManager=function(t){return this._dndEventManagers[this._dndEventManagers.length-1]===t},Mt.prototype.setFixContextCallback=function(t){this._fixContextCallback=t},Mt.prototype.fixRendererContext=function(t){return this._fixContextCallback?this._fixContextCallback(t):t},Mt.prototype.setCustomElement=function(t){this._customElement=t},Mt.prototype.isCustomElement=function(){return this._customElement},Mt.prototype.destroy=function(){this._destroyed=!0},Mt.prototype.setJetProperties=function(t){this._jetProps=t,Object.assign(this,t)},Mt.prototype.getJetProperties=function(){return this._jetProps},Mt.prototype.createContext=function(t,e,i){var n=new Mt(t,e,i);return n.setJetProperties(this.getJetProperties()),n};const Lt=function(){this.Init()};i.createSubclass(Lt,i),Lt.linear=function(t){return t},Lt.quadraticIn=function(t){return Lt.PolyIn(t,2)},Lt.quadraticOut=function(t){return Lt.PolyOut(t,2)},Lt.quadraticInOut=function(t){return Lt.PolyInOut(t,2)},Lt.cubicIn=function(t){return Lt.PolyIn(t,3)},Lt.cubicOut=function(t){return Lt.PolyOut(t,3)},Lt.cubicInOut=function(t){return Lt.PolyInOut(t,3)},Lt.backOut=function(t,e){return e||(e=1.70158),1-(t=1-t)*t*((e+1)*t-e)},Lt.backIn=function(t,e){return e||(e=1.70158),t*t*((e+1)*t-e)},Lt.elasticIn=function(t,e,i){return t<=0||t>=1?t:(i||(i=.45),!e||e<1?(e=1,n=i/4):n=i/(2*Math.PI)*Math.asin(1/e),-e*Math.pow(2,10*(t-=1))*Math.sin((t-n)*(2*Math.PI)/i));var n},Lt.elasticOut=function(t,e,i){return 1-Lt.elasticIn(1-t,e,i)},Lt.PolyIn=function(t,e){return t<0?0:t>1?1:Math.pow(t,e)},Lt.PolyOut=function(t,e){return t<0?0:t>1?1:1-Math.pow(1-t,e)},Lt.PolyInOut=function(t,e){return t<0?0:t>1?1:t<.5?.5*Math.pow(2*t,e):.5*(2-Math.pow(2*(1-t),e))},Lt.prototype.Init=function(){};const Pt=function(){this.Init()};i.createSubclass(Pt,i),Pt.TYPE_NUMBER="typeNumber",Pt.TYPE_MATRIX="typeMatrix",Pt.TYPE_NUMBER_ARRAY="typeNumberArray",Pt.TYPE_COLOR="typeColor",Pt.TYPE_COLOR_ARRAY="typeColorArray",Pt.TYPE_GROW_POLYLINE="typeGrowPolyline",Pt.TYPE_RECTANGLE="typeRectangle",Pt.TYPE_POINT="typePoint",Pt.TYPE_PATH="typePath",Pt.TYPE_GROW_PATH="typeGrowPath",Pt.TYPE_FILL="typeFill",Pt.TYPE_STROKE="typeStroke",Pt.TYPE_POLYLINE="typePolyline",Pt.interpolate=function(t,e,i,n,r){var o=Pt._getInterpolator(e);return o?o(t,i,n,r):n},Pt._getInterpolator=function(t){return Pt._map[t]},Pt.InterpolateNumber=function(t,e,i,n){return S.interpolateNumber(e,i,n)},Pt.InterpolateNumberArray=function(t,e,i,n){for(var r=e.length,o=i.length,s=[],a=0;a<Math.max(r,o);a++){var h,l;h=a<r?e[a]:e[r-1],l=a<o?i[a]:i[o-1],s.push(Pt.InterpolateNumber(t,h,l,n))}return s},Pt.InterpolateMatrix=function(t,e,i,n){var r=Pt.InterpolateNumber(t,e.getA(),i.getA(),n),o=Pt.InterpolateNumber(t,e.getB(),i.getB(),n),s=Pt.InterpolateNumber(t,e.getC(),i.getC(),n),a=Pt.InterpolateNumber(t,e.getD(),i.getD(),n),h=Pt.InterpolateNumber(t,e.getTx(),i.getTx(),n),u=Pt.InterpolateNumber(t,e.getTy(),i.getTy(),n);return new l(r,o,s,a,h,u)},Pt.InterpolateColor=function(t,e,i,n){return T.interpolateColor(e,i,n)},Pt.InterpolateColorArray=function(t,e,i,n){for(var r=e.length,o=i.length,s=[],a=0;a<Math.max(r,o);a++){var h,l;h=a<r?e[a]:e[r-1],l=a<o?i[a]:i[o-1],s.push(Pt.InterpolateColor(t,h,l,n))}return s},Pt.InterpolateGrowPolyline=function(t,e,i,n){if(0===n)return[i[0],i[1]];if(1===n)return i;for(var r,o=i.length,s=[i[0],i[1]],a=n*Pt.CalcPolylineLength(i),h=0,l=2;l<o-1;l+=2){var u=i[l-2],c=i[l-1],_=i[l],p=i[l+1];if(h+(r=Pt.CalcPolylineLength([u,c,_,p]))>a){var d=(a-h)/r,g=_-u,f=p-c;s.push(u+d*g),s.push(c+d*f);break}h+=r,s.push(_),s.push(p)}return s},Pt.InterpolateGrowPath=function(t,e,i,n){if(0===n)return[i[0],i[1]];if(1===n)return i;for(var r,o,s,a,h,l,u,c,_,p=i.length,d=[],g=n*Pt.CalcPathLength(i),f=0,y=0;y<p;y++){var v,S=i[y];switch(S){case"M":v=[c=o=i[++y],_=s=i[++y],c,_];break;case"L":v=[c,_,o=i[++y],s=i[++y]];break;case"Q":a=i[++y],h=i[++y],v=[c,_,o=i[++y],s=i[++y]];break;case"C":a=i[++y],h=i[++y],l=i[++y],u=i[++y],v=[c,_,o=i[++y],s=i[++y]]}if(f+(r=Pt.CalcPolylineLength(v))>g){var T=(g-f)/r;switch(d.push(S),S){case"Q":d.push(c+T*(a-c),_+T*(h-_));break;case"C":d.push(c+T*(a-c),_+T*(h-_),c+T*(l-c),_+T*(u-_))}d.push(c+T*(o-c),_+T*(s-_));break}switch(f+=r,d.push(S),S){case"Q":d.push(a,h);break;case"C":d.push(a,h,l,u)}d.push(o),d.push(s),c=o,_=s}return d},Pt.CalcPolylineLength=function(t){for(var e,i,n,r,o=0,s=0;s<t.length;s+=2){if(n=t[s],r=t[s+1],s>0)if(n===e)o+=Math.abs(r-i);else if(r===i)o+=Math.abs(n-e);else{var a=Math.abs(n-e),h=Math.abs(r-i);o+=Math.sqrt(a*a+h*h)}e=n,i=r}return o},Pt.CalcPathLength=function(t){for(var e,i,n,r,o=0,s=0;s<t.length;){switch(t[s]){case"M":e=n=t[s+1],i=r=t[s+2],s+=3;continue;case"L":n=t[s+1],r=t[s+2],s+=3;break;case"Q":n=t[s+3],r=t[s+4],s+=5;break;case"C":n=t[s+5],r=t[s+6],s+=7}if(s>0)if(n===e)o+=Math.abs(r-i);else if(r===i)o+=Math.abs(n-e);else{var a=Math.abs(n-e),h=Math.abs(r-i);o+=Math.sqrt(a*a+h*h)}e=n,i=r}return o},Pt.InterpolateRectangle=function(t,e,i,n){var r=Pt.InterpolateNumber(t,e.x,i.x,n),o=Pt.InterpolateNumber(t,e.y,i.y,n),s=Pt.InterpolateNumber(t,e.w,i.w,n),a=Pt.InterpolateNumber(t,e.h,i.h,n);return new m(r,o,s,a)},Pt.InterpolatePoint=function(t,e,i,r){var o=Pt.InterpolateNumber(t,e.x,i.x,r),s=Pt.InterpolateNumber(t,e.y,i.y,r);return new n(o,s)},Pt.InterpolatePath=function(t,e,i,n){var r=e.length,o=i.length;if(r!=o)return i;for(var s=[],a=0,h=0;a<r&&h<o;){var l=e[a],u=i[h],c=!isNaN(l),_=!isNaN(u);c||_?c&&_&&s.push(Pt.InterpolateNumber(t,l,u,n)):l===u&&s.push(l),a++,h++}return s},Pt.InterpolateFill=function(t,e,i,n){if(e instanceof K&&i instanceof K){var r=Pt.InterpolateColor(t,e.getColor(),i.getColor(),n),o=Pt.InterpolateNumber(t,e.getAlpha(),i.getAlpha(),n);return new K(r,o)}return i},Pt.InterpolateStroke=function(t,e,i,n){if(e instanceof z&&i instanceof z){var r=Pt.InterpolateColor(t,e.getColor(),i.getColor(),n),o=Pt.InterpolateNumber(t,e.getAlpha(),i.getAlpha(),n),s=Pt.InterpolateNumber(t,e.getWidth(),i.getWidth(),n);return new z(r,o,s,i.isFixedWidth(),i.getDashProps(),i.getLineProps())}return i},Pt.InterpolatePolyline=function(t,e,i,n){for(var r=e.length,o=i.length,s=[],a=0;a<Math.max(r,o);a++){var h,l,u=2;a%2==1&&(u=1),h=a<r?e[a]:e[r-u],l=a<o?i[a]:i[o-u],s.push(Pt.InterpolateNumber(t,h,l,n))}if(o<r){var c=s.length,_=s[c-2],p=s[c-1];for(a=c-4;a>=0;a-=2){var d=s[a],g=s[a+1];if(d!=_||g!=p)break;s.splice(a,2)}}return s},Pt.prototype.Init=function(){},(Pt._map={})[Pt.TYPE_NUMBER]=Pt.InterpolateNumber,Pt._map[Pt.TYPE_MATRIX]=Pt.InterpolateMatrix,Pt._map[Pt.TYPE_NUMBER_ARRAY]=Pt.InterpolateNumberArray,Pt._map[Pt.TYPE_COLOR]=Pt.InterpolateColor,Pt._map[Pt.TYPE_COLOR_ARRAY]=Pt.InterpolateColorArray,Pt._map[Pt.TYPE_GROW_POLYLINE]=Pt.InterpolateGrowPolyline,Pt._map[Pt.TYPE_RECTANGLE]=Pt.InterpolateRectangle,Pt._map[Pt.TYPE_POINT]=Pt.InterpolatePoint,Pt._map[Pt.TYPE_PATH]=Pt.InterpolatePath,Pt._map[Pt.TYPE_GROW_PATH]=Pt.InterpolateGrowPath,Pt._map[Pt.TYPE_FILL]=Pt.InterpolateFill,Pt._map[Pt.TYPE_STROKE]=Pt.InterpolateStroke,Pt._map[Pt.TYPE_POLYLINE]=Pt.InterpolatePolyline;var Ht=function(t,e,i){this.type=t,this.setter=e,this.destVal=i,this.startVal=null};const Ft=function(t,e,i,n){this._context=t,this._scheduler=t.getScheduler(),this._duration=e||.5,this._delay=i||0,this.setEasing(n),this._bRunning=!1,this._startTime=null,this._progress=0,this._state=0,this._onInit=null,this._onInitObj=null,this._onEnd=null,this._onEndObj=null,this._context=t,this._props=new Map};Ft.TYPE_NUMBER=Pt.TYPE_NUMBER,Ft.TYPE_MATRIX=Pt.TYPE_MATRIX,Ft.TYPE_NUMBER_ARRAY=Pt.TYPE_NUMBER_ARRAY,Ft.TYPE_COLOR=Pt.TYPE_COLOR,Ft.TYPE_COLOR_ARRAY=Pt.TYPE_COLOR_ARRAY,Ft.TYPE_GROW_POLYLINE=Pt.TYPE_GROW_POLYLINE,Ft.TYPE_RECTANGLE=Pt.TYPE_RECTANGLE,Ft.TYPE_POINT=Pt.TYPE_POINT,Ft.TYPE_PATH=Pt.TYPE_PATH,Ft.TYPE_GROW_PATH=Pt.TYPE_GROW_PATH,Ft.TYPE_FILL=Pt.TYPE_FILL,Ft.TYPE_STROKE=Pt.TYPE_STROKE,Ft.TYPE_POLYLINE=Pt.TYPE_POLYLINE,Ft.prototype.addProp=function(t,e,i,n,r){var o=this._getPropItem(e,i);o?o.destVal=r:(o=new Ht(t,n,r),this._setPropItem(e,i,o))},Ft.prototype.getDestVal=function(t,e,i){var n=this._getPropItem(t,e);return n?n.destVal:i?e.call(t):null},Ft.prototype.setEasing=function(t){this._easing=t||Lt.cubicInOut},Ft.prototype.getOnEnd=function(){return[this._onEnd,this._onEndObj]},Ft.prototype.setOnEnd=function(t,e){this._onEnd=t,this._onEndObj=e||null},Ft.prototype.getOnInit=function(){return[this._onInit,this._onInitObj]},Ft.prototype.setOnInit=function(t,e){this._onInit=t,this._onInitObj=e||null},Ft.prototype.isRunning=function(){return this._bRunning},Ft.prototype.play=function(t){t?this._play():this._animationRequestId=Mt.requestAnimationFrame(i.createCallback(this,this._play))},Ft.prototype.processTime=function(t){if(this._bRunning){var e=t-this._startTime;if(e<0)return!1;var i=1e3*this._getTotalDuration(),n=1;0!=i&&(n=e/i),n>1&&(n=1),this._processStep(n);var r=n>=1;return r&&this._processEnd(),r}},Ft.prototype.stop=function(t){this._animationRequestId&&(Mt.cancelAnimationFrame(this._animationRequestId),this._animationRequestId=null),this._scheduler.removeScheduled(this),t&&this._processStep(1),this._processEnd()},Ft.prototype._getPropItem=function(t,e){var i=this._props.get(t);return i?i.get(e):null},Ft.prototype._setPropItem=function(t,e,i){var n=this._props.get(t);n||(n=new Map,this._props.set(t,n)),n.set(e,i)},Ft.prototype._getTotalDuration=function(){return this._delay+this._duration},Ft.prototype._play=function(){this._bRunning||(this._bRunning=!0,this._processPlay(),this._scheduler.addScheduled(this)),this._context.isOffscreen()&&this.stop(!0),this._animationRequestId=null},Ft.prototype._processEnd=function(){this._bRunning&&(this._bRunning=!1,this._progress=1,this._state=1),this._onEnd&&!this._ended&&(this._onEnd.call(this._onEndObj),this._ended=!0)},Ft.prototype._processInitialize=function(){this._onInit&&this._onInit.call(this._onInitObj),this._props.forEach(function(t,e){t.forEach(function(t,i){t.startVal=i.call(e)})}),this._state=1},Ft.prototype._processPlay=function(){if(0==this._state&&this._processInitialize(),1==this._state)this._startTime=(new Date).getTime(),this._bRunning=!0,this._progress=0;else{var t=1e3*this._progress*this._getTotalDuration();this._startTime=(new Date).getTime()-t}this._state=2},Ft.prototype._processStep=function(t){this._progress=t;var e=t;if(this._delay>0){var i=this._delay/this._getTotalDuration(),n=1-i;e=0===n?.5:Math.min(1,(t-i)/n)}if(e>=0){this._easing&&(e=this._easing(e));var r=this._context;this._props.forEach(function(t,i){t.forEach(function(t,n){var o=Pt.interpolate(r,t.type,t.startVal,t.destVal,e);t.setter.call(i,o)})})}};const kt=function(t){this.Init(t)};i.createSubclass(kt,i),kt.appendOnEnd=function(t,e,i){if(t&&e){var n=t.getOnEnd();if(n&&n[0]){t.setOnEnd(function(){n[0].call(n[1]),e.call(i)})}else t.setOnEnd(e,i)}},kt.prependOnInit=function(t,e,i){if(t&&e&&t.getOnInit&&t.setOnInit){var n=t.getOnInit();if(n&&n[0]){t.setOnInit(function(){e.call(i),n[0].call(n[1])})}else t.setOnInit(e,i)}},kt.prototype.Init=function(t){this.Context=t,this._onEnd=null,this._onEndObj=null},kt.prototype.setOnEnd=function(t,e){this._onEnd=t,this._onEndObj=e||null,this.OnEndUpdated()},kt.prototype.CallOnEnd=function(){this._onEnd&&!this._ended&&(this._onEnd.call(this._onEndObj),this._ended=!0)},kt.prototype.getOnEnd=function(){return[this._onEnd,this._onEndObj]},kt.prototype.OnEndUpdated=function(){},kt.prototype.getDuration=function(){return 0},kt.prototype.initialize=function(){},kt.prototype.play=function(t){},kt.prototype.stop=function(t){};const Gt=function(t){var e;arguments&&arguments.length>1&&arguments[1]instanceof Array?e=arguments[1]:(e=[].slice.call(arguments)).splice(0,1),this.Init(t,e)};i.createSubclass(Gt,kt),Gt.prototype.Init=function(t,e){Gt.superclass.Init.call(this,t),this._runningCounter=0,this._arPlayables=e||[],this._bStarted=!1},Gt.prototype.getDuration=function(){for(var t=0,e=0;e<this._arPlayables.length;e++){var i=this._arPlayables[e];i instanceof kt&&(t=Math.max(t,i.getDuration()))}return t},Gt.prototype.initialize=function(){for(var t=0;t<this._arPlayables.length;t++)this._arPlayables[t]instanceof kt&&this._arPlayables[t].initialize()},Gt.prototype.play=function(t){this._arPlayables.length>0?t?this._play():(this.initialize(),this._animationRequestId=Mt.requestAnimationFrame(i.createCallback(this,this._play))):this._animationRequestId=Mt.requestAnimationFrame(i.createCallback(this,this.DoEnd))},Gt.prototype._play=function(){var t;if(!this._bStarted)for(var e=0;e<this._arPlayables.length;e++)(t=this._arPlayables[e])instanceof kt&&(this._runningCounter++,kt.appendOnEnd(t,this.OnPlayableEnd,this));for(e=0;e<this._arPlayables.length;e++)(t=this._arPlayables[e])instanceof kt&&t.play(!0);this._bStarted=!0,this._animationRequestId=null},Gt.prototype.stop=function(t){if(this._animationRequestId)return Mt.cancelAnimationFrame(this._animationRequestId),void this.DoEnd();for(var e,i=0;i<this._arPlayables.length;i++)(e=this._arPlayables[i])instanceof kt&&e.stop(t)},Gt.prototype.OnPlayableEnd=function(){this._runningCounter--,this._runningCounter<1&&this.DoEnd()},Gt.prototype.DoEnd=function(){this.CallOnEnd(),this._animationRequestId=null};const Bt=function(t){var e;arguments&&arguments.length>1&&arguments[1]instanceof Array?e=arguments[1]:(e=[].slice.call(arguments)).splice(0,1),this.Init(t,e)};i.createSubclass(Bt,kt),Bt.prototype.Init=function(t,e){Bt.superclass.Init.call(this,t),this._arPlayables=e||[],this._currIndex=-1,this._bStarted=!1},Bt.prototype.getDuration=function(){for(var t=0,e=0;e<this._arPlayables.length;e++){var i=this._arPlayables[e];i instanceof kt&&(t+=i.getDuration())}return t},Bt.prototype.initialize=function(){this._arPlayables.length>0&&this._arPlayables[0]instanceof kt&&this._arPlayables[0].initialize()},Bt.prototype.play=function(t){this._arPlayables&&this._arPlayables.length>0?t?this._play():(this.initialize(),this._animationRequestId=Mt.requestAnimationFrame(i.createCallback(this,this._play))):this._animationRequestId=Mt.requestAnimationFrame(i.createCallback(this,this.DoEnd))},Bt.prototype._play=function(){if(this._bStarted){var t=this._arPlayables[this._currIndex];t instanceof kt&&t.play(!0)}else{var e,i,n;this._arPlayables[0]instanceof kt&&(e=this._arPlayables[0]),this._arPlayables[this._arPlayables.length-1]instanceof kt&&(i=this._arPlayables[this._arPlayables.length-1]);for(var r=0;r<this._arPlayables.length-1;r++)(n=this._arPlayables[r])instanceof kt&&kt.appendOnEnd(n,this.DoSequenceStep,this);i&&kt.appendOnEnd(i,this.DoEnd,this),this._bStarted=!0,this._currIndex=0,e&&e.play(!0),this._animationRequestId=null}},Bt.prototype.DoSequenceStep=function(){var t=this._arPlayables[++this._currIndex];t instanceof kt?t.play(!0):this.DoSequenceStep()},Bt.prototype.stop=function(t){if(this._animationRequestId)return Mt.cancelAnimationFrame(this._animationRequestId),void this.DoEnd();if(this._arPlayables)for(var e,i=this._currIndex;i<this._arPlayables.length;i++)(e=this._arPlayables[i])&&e instanceof kt&&e.stop(t)},Bt.prototype.DoEnd=function(){this.CallOnEnd(),this._animationRequestId=null};const Ut=function(t,e,i,n){this.Init(t,e,i,n)};i.createSubclass(Ut,kt),Ut.EASING_LINEAR=1,Ut.EASING_CUBIC_IN_OUT=2,Ut.EASING_CUBIC_IN=3,Ut.EASING_CUBIC_OUT=4,Ut.EASING_QUADRATIC_IN_OUT=5,Ut.EASING_QUADRATIC_IN=6,Ut.EASING_QUADRATIC_OUT=7,Ut.EASING_BOUNCE_IN=8,Ut.EASING_BOUNCE_OUT=9,Ut.EASING_ELASTIC_IN=10,Ut.EASING_ELASTIC_OUT=11,Ut.DIR_C=1,Ut.DIR_N=2,Ut.DIR_NE=3,Ut.DIR_E=4,Ut.DIR_SE=5,Ut.DIR_S=6,Ut.DIR_SW=7,Ut.DIR_W=8,Ut.DIR_NW=9,Ut.AXIS_X=1,Ut.AXIS_Y=2,Ut.ROT_DIR_CLOCKWISE=1,Ut.ROT_DIR_COUNTERCLOCKWISE=2,Ut.GetEasingFunction=function(t){switch(t){case Ut.EASING_LINEAR:return Lt.linear;case Ut.EASING_CUBIC_IN:return Lt.cubicIn;case Ut.EASING_CUBIC_OUT:return Lt.cubicOut;case Ut.EASING_QUADRATIC_IN_OUT:return Lt.quadraticInOut;case Ut.EASING_QUADRATIC_IN:return Lt.quadraticIn;case Ut.EASING_QUADRATIC_OUT:return Lt.quadraticOut;case Ut.EASING_BOUNCE_IN:return Lt.backIn;case Ut.EASING_BOUNCE_OUT:return Lt.backOut;case Ut.EASING_ELASTIC_IN:return Lt.elasticIn;case Ut.EASING_ELASTIC_OUT:return Lt.elasticOut;case Ut.EASING_CUBIC_IN_OUT:default:return Lt.cubicInOut}},Ut.GetCompassPoint=function(t,e){switch(e){case Ut.DIR_N:return new n(t.x+.5*t.w,t.y);case Ut.DIR_NE:return new n(t.x+t.w,t.y);case Ut.DIR_E:return new n(t.x+t.w,t.y+.5*t.h);case Ut.DIR_SE:return new n(t.x+t.w,t.y+t.h);case Ut.DIR_S:return new n(t.x+.5*t.w,t.y+t.h);case Ut.DIR_SW:return new n(t.x,t.y+t.h);case Ut.DIR_W:return new n(t.x,t.y+.5*t.h);case Ut.DIR_NW:return new n(t.x,t.y);case Ut.DIR_C:default:return new n(t.x+.5*t.w,t.y+.5*t.h)}},Ut.GetAlignCompassPoint=function(t,e,i){var r=Ut.GetCompassPoint(e,i);switch(i){case Ut.DIR_N:return new n(r.x-.5*t.w,r.y);case Ut.DIR_NE:return new n(r.x-t.w,r.y);case Ut.DIR_E:return new n(r.x-t.w,r.y-.5*t.h);case Ut.DIR_SE:return new n(r.x-t.w,r.y-t.h);case Ut.DIR_S:return new n(r.x-.5*t.w,r.y-t.h);case Ut.DIR_SW:return new n(r.x,r.y-t.h);case Ut.DIR_W:return new n(r.x,r.y-.5*t.h);case Ut.DIR_NW:return new n(r.x,r.y);case Ut.DIR_C:default:return new n(r.x-.5*t.w,r.y-.5*t.h)}},Ut.prototype.Init=function(t,e,i,n){Ut.superclass.Init.call(this,t),this._context=t,this._arObjects=e instanceof Array?e:[e],this._duration=i||.5,this._delay=n||0,this._easing=Ut.EASING_CUBIC_IN_OUT,this._bInitialized=!1,this._bSaveAndRestoreOriginalMatrices=!1,this._origMatrixArray=null,this._bHideObjectsOnEnd=!1,this.CreateAnimator(t)},Ut.prototype.GetContext=function(){return this._context},Ut.prototype.isRunning=function(){return!!this._animator&&this._animator.isRunning()},Ut.prototype.initialize=function(){this._bInitialized||(this._initializeEndStates(this._arObjects),this._initializeStartStates(this._arObjects),this.InitializePlay(),this._bInitialized=!0)},Ut.prototype.play=function(t){this.initialize(),this._animator&&this._animator.play(t)},Ut.prototype.stop=function(t){this._animator&&this._animator.stop(t)},Ut.prototype.getDuration=function(){return this._duration},Ut.prototype.setEasing=function(t){this._easing=t,this._animator&&this._animator.setEasing(Ut.GetEasingFunction(this._easing))},Ut.prototype.CreateAnimator=function(t){this._animator=new Ft(t,this._duration,this._delay,Ut.GetEasingFunction(this._easing)),this._animator.setOnEnd(this.OnAnimEnd,this)},Ut.prototype.OnAnimEnd=function(){this._bHideObjectsOnEnd&&this.SetObjectsVisible(!1),this._bSaveAndRestoreOriginalMatrices&&this.RestoreOriginalMatrices(),this.CallOnEnd()},Ut.prototype.InitializePlay=function(){},Ut.prototype._initializeStartStates=function(t){if(t)for(var e,i=0;i<t.length;i++)(e=t[i])&&(this._bSaveAndRestoreOriginalMatrices&&(this._origMatrixArray||(this._origMatrixArray=[]),this._origMatrixArray.push(e.getMatrix())),this.InitStartState(e))},Ut.prototype._initializeEndStates=function(t){if(t)for(var e,i=0;i<t.length;i++)(e=t[i])&&this.InitEndState(e)},Ut.prototype.InitStartState=function(t){},Ut.prototype.InitEndState=function(t){},Ut.prototype.SetObjectsVisible=function(t){if(this._arObjects)for(var e,i=this._arObjects.length-1;i>=0;i--)(e=this._arObjects[i])&&e.setVisible(t)},Ut.prototype.RestoreOriginalMatrices=function(){if(this._arObjects)for(var t,e=this._arObjects.length-1;e>=0;e--)(t=this._arObjects[e])&&this._origMatrixArray&&t.setMatrix(this._origMatrixArray.pop())};const Yt=function(t,e,i,n){this.Init(t,e,i,n)};i.createSubclass(Yt,Ut),Yt.prototype.Init=function(t,e,i,n){Yt.superclass.Init.call(this,t,e,i,n)},Yt.prototype.InitStartState=function(t){t.setAlpha(0)},Yt.prototype.InitEndState=function(t){this._animator.addProp(Ft.TYPE_NUMBER,t,t.getAlpha,t.setAlpha,1)};const Wt=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass(Wt,Ut),Wt.prototype.Init=function(t,e,i,r,o){this._arOffsets=i instanceof Array?i:i instanceof n?[i]:[new n(0,0)],this._currIndex=0,Wt.superclass.Init.call(this,t,e,r,o)},Wt.prototype.InitEndState=function(t){var e;e=this._currIndex<this._arOffsets.length?this._arOffsets[this._currIndex]:this._arOffsets[this._arOffsets.length-1],this._animator.addProp(Ft.TYPE_NUMBER,t,t.getTranslateX,t.setTranslateX,t.getTranslateX()+e.x),this._animator.addProp(Ft.TYPE_NUMBER,t,t.getTranslateY,t.setTranslateY,t.getTranslateY()+e.y),this._currIndex++};const Vt=function(t,e,i,n,r,o,s){this.Init(t,e,i,n,r,o,s)};i.createSubclass(Vt,Yt),Vt.prototype.Init=function(t,e,i,n,r,o,s){this._boundsRect=i,this._direction=n||Ut.DIR_NW,this._minScale=r||.5,Vt.superclass.Init.call(this,t,e,o,s),this._bSaveAndRestoreOriginalMatrices=!0},Vt.prototype.InitStartState=function(t){Vt.superclass.InitStartState.call(this,t);var e=this._minScale*t.getScaleX(),i=this._minScale*t.getScaleY(),n=t.getDimensions(),r=new m(0,0,e*n.w,i*n.h),o=Ut.GetAlignCompassPoint(r,this._boundsRect,this._direction);t.setTranslate(o.x,o.y),t.setScale(e,i)},Vt.prototype.InitEndState=function(t){Vt.superclass.InitEndState.call(this,t);var e=t.getMatrix();this._animator.addProp(Ft.TYPE_MATRIX,t,t.getMatrix,t.setMatrix,e)};const jt=function(t,e,i,n){this.Init(t,e,i,n)};i.createSubclass(jt,Ut),jt.prototype.Init=function(t,e,i,n){jt.superclass.Init.call(this,t,e,i,n)},jt.prototype.InitEndState=function(t){this._animator.addProp(Ft.TYPE_NUMBER,t,t.getAlpha,t.setAlpha,0)};const Kt=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass(Kt,Gt),Kt.prototype.Init=function(t,e,i,n,r){n||(n=.5),r||(r=0);var o=new jt(t,e,n,r),s=new Yt(t,i,n,.5*o.getDuration()+r);Kt.superclass.Init.call(this,t,[o,s])};const zt=function(t,e,i,n,r,o,s){this.Init(t,e,i,n,r,o,s)};i.createSubclass(zt,Gt),zt.prototype.Init=function(t,e,i,n,r,o,s){o||(o=.5),s||(s=0);var a=new Wt(t,e,n,o,s),h=new Wt(t,i,r,o,s);zt.superclass.Init.call(this,t,[a,h])};const Xt=function(t,e,i,n,r,o,s,a,h){this.Init(t,e,i,n,r,o,s,a,h)};i.createSubclass(Xt,Gt),Xt.prototype.Init=function(t,e,i,n,r,o,s,a,h){r||(r=Ut.DIR_NE),o||(o=Ut.DIR_NW),s||(s=.5),a||(a=.5),h||(h=0);var l=new Vt(t,i,n,o,s,a,.3+h);Xt.superclass.Init.call(this,t,[null,l])};const qt=function(){};i.createSubclass(qt,i),qt.ALPHA_FADE="alphaFade",qt.SLIDE_TO_RIGHT="slideToRight",qt.SLIDE_TO_LEFT="slideToLeft",qt.ZOOM="zoom",qt.isSupported=function(t){return t==qt.ALPHA_FADE||t==qt.SLIDE_TO_RIGHT||t==qt.SLIDE_TO_LEFT||t==qt.ZOOM},qt.getInAnimation=function(t,e,i,r,o){return e==qt.ALPHA_FADE?new Yt(t,i,o):e==qt.SLIDE_TO_RIGHT?(qt._offsetObjects(i,-r.w,0),new Wt(t,i,new n(r.w,0),o)):e==qt.SLIDE_TO_LEFT?(qt._offsetObjects(i,r.w,0),new Wt(t,i,new n(-r.w,0),o)):e==qt.ZOOM?new Vt(t,i,r,Ut.DIR_C,.5,o):null},qt.getCombinedAnimation=function(t,e,i,r,o,s){return e==qt.ALPHA_FADE?new Kt(t,i,r,s):e==qt.SLIDE_TO_RIGHT?(qt._offsetObjects(r,-o.w,0),new zt(t,i,r,new n(o.w,0),new n(o.w,0),s)):e==qt.SLIDE_TO_LEFT?(qt._offsetObjects(r,o.w,0),new zt(t,i,r,new n(-o.w,0),new n(-o.w,0),s)):e==qt.ZOOM?new Xt(t,i,r,o,Ut.DIR_C,Ut.DIR_C,.5,s):null},qt._offsetObjects=function(t,e,i){if(t.length)for(var n=0;n<t.length;n++)qt._offsetObjects(t[n],e,i);else t&&t.setTranslate(t.getTranslateX()+e,t.getTranslateY()+i)};const Zt=function(t,e,i,n){this.Init(t,e,i,n)};i.createSubclass(Zt,Ut),Zt.prototype.getAnimator=function(){return this._animator};const Qt=function(t,e){this.Init(t,e)};i.createSubclass(Qt,i),Qt._OVERLAP_RATIO=.4,Qt.prototype.Init=function(t,e){this._context=t,this._deleteContainer=e,this._playables=[]},Qt.prototype.getCtx=function(){return this._context},Qt.prototype.constructAnimation=function(t,e){if(e&&!this._context.isOffscreen()){e=e.slice(0);var i=[];if(t){for(var n=new this._context.ojMap,r=0;r<e.length;r++){(s=e[r])&&s.getId()&&n.set(s.getId(),s)}for(var o=0;o<t.length;o++){var s,a=t[o],h=a?a.getId():void 0;(s=h?n.get(h):void 0)?(i.push(s.getId()),s.animateUpdate(this,a)):a&&a.animateDelete(this,this._deleteContainer)}}for(var l=new this._context.KeySetImpl(i),u=0;u<e.length;u++)!e[u]||e[u].getId()&&l.has(e[u].getId())||e[u].animateInsert(this)}},Qt.prototype.getDeleteContainer=function(){return this._deleteContainer},Qt.prototype.add=function(t,e){if(t){for(e||(e=0);this._playables.length<=e;)this._playables.push(new Array);this._playables[e].push(t)}},Qt.prototype.getAnimation=function(t){for(var e=[],i=0;i<this._playables.length;i++)if(this._playables[i].length>0){var n=new Gt(this._context,this._playables[i]);e.push(n)}if(t){for(var r=[],o=0,s=0;s<e.length;s++){if(o>0){var a=new Zt(this._context,null,o);r.push(new Bt(this._context,[a,e[s]]))}else r.push(e[s]);o+=(1-Qt._OVERLAP_RATIO)*e[s].getDuration()}return new Gt(this._context,r)}return new Bt(this._context,e)},Qt.prototype.getNumPlayables=function(){return this._playables.length};const $t=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass($t,Ut),$t.prototype.Init=function(t,e,i,r,o){this._arPoints=i instanceof Array?i:i instanceof n?[i]:[new n(0,0)],this._currIndex=0,$t.superclass.Init.call(this,t,e,r,o)},$t.prototype.InitEndState=function(t){var e;e=this._currIndex<this._arPoints.length?this._arPoints[this._currIndex]:this._arPoints[this._arPoints.length-1],this._animator.addProp(Ft.TYPE_NUMBER,t,t.getTranslateX,t.setTranslateX,e.x),this._animator.addProp(Ft.TYPE_NUMBER,t,t.getTranslateY,t.setTranslateY,e.y),this._currIndex++};const Jt=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass(Jt,Ut),Jt.prototype.Init=function(t,e,i,r,o){this._arScales=i instanceof Array?i:i instanceof n?[i]:[new n(1,1)],this._currIndex=0,Jt.superclass.Init.call(this,t,e,r,o)},Jt.prototype.InitEndState=function(t){var e;e=this._currIndex<this._arScales.length?this._arScales[this._currIndex]:this._arScales[this._arScales.length-1],this._animator.addProp(Ft.TYPE_NUMBER,t,t.getScaleX,t.setScaleX,e.x),this._animator.addProp(Ft.TYPE_NUMBER,t,t.getScaleY,t.setScaleY,e.y),this._currIndex++};const te=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass(te,Ut),te.BackOut=function(t){return Lt.backOut(t,2.5)},te.prototype.Init=function(t,e,i,n,r){this._bCenter=i,this._bCenter&&(this._tempContainers=[],this._currIndex=0),te.superclass.Init.call(this,t,e,n,r)},te.prototype.setEasing=function(t){},te.prototype.CreateAnimator=function(t){te.superclass.CreateAnimator.call(this,t),this._animator.setEasing(te.BackOut),this._bCenter&&kt.appendOnEnd(this._animator,this.RemoveTempContainers,this)},te.prototype.InitStartState=function(t){if(this._bCenter){var e=this._tempContainers[this._currIndex],i=t.getDimensions();e._dvtAnimPopInOrigTx=t.getTranslateX(),e._dvtAnimPopInOrigTy=t.getTranslateY();var n=i.x+.5*i.w,r=i.y+.5*i.h;e.setTranslate(e._dvtAnimPopInOrigTx+n,e._dvtAnimPopInOrigTy+r),t.setTranslate(-n,-r);var o=t.getParent().getChildIndex(t);e._dvtAnimPopInChildIndex=o,t.getParent().addChildAt(e,o),e.addChild(t),e.setScale(.01,.01),this._currIndex++}else t.setScale(.01,.01);t.setVisible(!0)},te.prototype.InitEndState=function(t){if(this._bCenter){var e=new J(this._context);this._tempContainers.push(e),this._animator.addProp(Ft.TYPE_NUMBER,e,e.getScaleX,e.setScaleX,1),this._animator.addProp(Ft.TYPE_NUMBER,e,e.getScaleY,e.setScaleY,1)}else this._animator.addProp(Ft.TYPE_NUMBER,t,t.getScaleX,t.setScaleX,1),this._animator.addProp(Ft.TYPE_NUMBER,t,t.getScaleY,t.setScaleY,1)},te.prototype.RemoveTempContainers=function(){if(this._tempContainers){for(var t=0;t<this._tempContainers.length;t++){var e=this._tempContainers[t];if(this._tempContainers[t]=null,e.getNumChildren()>0){var i=e.getChildAt(0);i&&(i.setTranslate(e._dvtAnimPopInOrigTx,e._dvtAnimPopInOrigTy),e.getParent().addChildAt(i,e._dvtAnimPopInChildIndex))}e.getParent().removeChild(e)}this._tempContainers=null}};const ee=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass(ee,g),ee.prototype.Init=function(t,e,i,n,r){ee.superclass.Init.call(this,e,i,n,r),null===t||isNaN(t)?t=0:Math.abs(t)>360&&(t%=360),this._angle=t},ee.prototype.getAngle=function(){return this._angle},ee.prototype.equals=function(t){return t instanceof ee&&t.getAngle()==this.getAngle()&&ee.superclass.equals.call(this,t)};const ie=function(t,e,i,n,r,o){this.Init(t,e,i,n,r,o)};i.createSubclass(ie,i),ie.FOCUS_BORDER_RADIUS=1,ie.FOCUS_STROKE_WIDTH=1,ie.FOCUS_STROKE_ALPHA=1,ie.prototype.Init=function(t,e,i,n,r,o){this._container=e,this._focusEffect=new lt(t,i.x,i.y,i.w,i.h,r);var s=this.CreateStroke();this._focusEffect.setStroke(s),this._focusEffect.setRx(ie.FOCUS_BORDER_RADIUS),this._focusEffect.setRy(ie.FOCUS_BORDER_RADIUS),n&&this._focusEffect.setMatrix(n),this._focusEffect.setFill(null),this._appendLast=o},ie.prototype.CreateStroke=function(){var t,e=r.getFocusColor(),i=ie.FOCUS_STROKE_WIDTH;return"safari"===r.browser||"blink"===r.engine?i=2:t={dashArray:i,dashOffset:i},new z(e,ie.FOCUS_STROKE_ALPHA,i,!1,t)},ie.prototype.getEffect=function(){return this._focusEffect},ie.prototype.setEffect=function(t){this._focusEffect=t},ie.prototype.show=function(){this._focusEffect instanceof ot&&(this._appendLast?this._container.addChild(this._focusEffect):this._container.addChildAt(this._focusEffect,0))},ie.prototype.hide=function(){this._focusEffect instanceof ot&&this._container.removeChild(this._focusEffect)};const ne=function(){this.Init()};i.createSubclass(ne,i),ne.prototype.Init=function(){this._data=[]},ne.prototype.get=function(t,e){return this._getInner(t)[e]},ne.prototype.put=function(t,e,i){var n=this._getInner(t),r=n[e];return n[e]=i,r},ne.prototype._getInner=function(t){var e=this._data[t];return e||(e=[],this._data[t]=e),e};const re={};i.createSubclass(re,i),re.position=function(t,e,i,n,o,s){i&&(s=n*o>0?s:0,"start"==e?e=r.isRightToLeft(i.getCtx())?"right":"left":"end"==e&&(e=r.isRightToLeft(i.getCtx())?"left":"right"),"top"==e?(i.setTranslate(t.x+t.w/2-n/2,t.y),t.y+=o+s,t.h-=o+s):"bottom"==e?(i.setTranslate(t.x+t.w/2-n/2,t.y+t.h-o),t.h-=o+s):"left"==e?(i.setTranslate(t.x,t.y+t.h/2-o/2),t.x+=n+s,t.w-=n+s):"right"==e&&(i.setTranslate(t.x+t.w-n,t.y+t.h/2-o/2),t.w-=n+s))},re.align=function(t,e,i,n){if(i){var o=e;"start"==o?o=r.isRightToLeft(i.getCtx())?"right":"left":"end"==o&&(o=r.isRightToLeft(i.getCtx())?"left":"right"),"left"==o?i.setX(t.x):"center"==o?i.setX(t.x+t.w/2-n/2):"right"==o&&i.setX(t.x+t.w-n)}},re.getBubbleSize=function(t,e,i,n,r){if(t<=0)return 0;var o=n*n,s=r*r;if(i/e<s/o){var a=Math.sqrt(o*s),h=Math.sqrt(e*i);if(t==h)return Math.sqrt(a);s=i/h*a,o=e/h*a}var l=o+(t-e)/(i-e)*(s-o);return Math.sqrt(l)};const oe=function(t,e){this.Init(t,e)};i.createSubclass(oe,ne),oe._INITIAL_SIZE=1500,oe.prototype.Init=function(t,e){oe.superclass.Init.call(this),this._innerMap=e,this._innerMap&&(this._innerMap._outerMap=this,this._innerMap._bOuterMap=!0),this._scale=t||1,this._capacity=this._scale*this._scale,this._bInnerMap=null!=this._innerMap,this._bOuterMap=!1;for(var i=oe._INITIAL_SIZE/this._scale,n=0;n<i;n++)for(var r=0;r<i;r++)this.put(n,r,0)},oe.prototype.isObscured=function(t,e,i,n){for(var r=this._adjustForScale(t),o=this._adjustForScale(e),s=this._adjustForScale(i),a=this._adjustForScale(n),h=r;h<=s;h++)for(var l=o;l<=a;l++){if(!0!==this.get(h,l)){if(!this._bInnerMap)return!1;var u=Math.max(t,h*this._scale),c=Math.max(e,l*this._scale),_=Math.min(i,(h+1)*this._scale-1),p=Math.min(n,(l+1)*this._scale-1);if(!this._innerMap.isObscured(u,c,_,p))return!1}}return!0},oe.prototype.obscure=function(t,e,i,n,r){for(var o=this._adjustForScale(t),s=this._adjustForScale(e),a=this._adjustForScale(i),h=this._adjustForScale(n),l=o;l<=a;l++)for(var u=s;u<=h;u++){if(!0!==this.get(l,u))if(this._bInnerMap){var c=Math.max(t,l*this._scale),_=Math.max(e,u*this._scale),p=Math.min(i,(l+1)*this._scale-1),d=Math.min(n,(u+1)*this._scale-1);this._innerMap.obscure(c,_,p,d,r)}else this._increment(l,u,r)}},oe.prototype._increment=function(t,e,i){var n=this._adjustForScale(t),r=this._adjustForScale(e),o=this.get(n,r);(o=null!=o?o+i:i)>=this._capacity&&(o=!0),this.put(n,r,o),!0===o&&this._bOuterMap&&this._outerMap._increment(t,e,this._capacity)},oe.prototype._adjustForScale=function(t){return Math.floor(t/this._scale)};const se={_cache:{}};i.createSubclass(se,i),se.addBubbleEventListener=function(t,e,i){return window.addEventListener?(u.addDomEventListener(t,e,i,!1),!0):!!window.attachEvent&&(t.attachEvent("on"+e,i),!0)},se.loadImage=function(t,e){var i=this._cache[t];if(i){if(!i._image)return e&&e(i),i;se._addListenerToQueue(i._listeners,e)}else this.loadNewImage(t,e);return null},se.loadNewImage=function(t,e){var i=document.createElement("img"),n={_listeners:[],url:t,_image:i};e&&se._addListenerToQueue(n._listeners,e),this._cache[t]=n,se.addBubbleEventListener(i,"load",function(t){var e;n.width=i.width,n.height=i.height,delete n._image;var r=n._listeners.length;for(e=0;e<r;e++)n._listeners[e]&&n._listeners[e](n);delete n._listeners}),i.src=t},se._addListenerToQueue=function(t,e){if(e){for(var i=0;i<t.length;i++)if(t[i]===e)return;t.push(e)}};const ae={};i.createSubclass(ae,i),ae.getDimensions=function(t){if(!t||0===t.length)return new m;for(var e,i,n=Number.MAX_VALUE,r=-1*Number.MAX_VALUE,o=Number.MAX_VALUE,s=-1*Number.MAX_VALUE,a=t.length,h=0;h<a;h++)e=t[h++],i=t[h],n=Math.min(n,e),r=Math.max(r,e),o=Math.min(o,i),s=Math.max(s,i);return new m(n,o,Math.abs(r-n),Math.abs(s-o))},ae.getRegularPolygonPoints=function(t,e,i,n,r,o){for(var s,a=[],h=0;h<i;h++)s=r+h/i*2*Math.PI*(0==o?-1:1),a.push(t+n*Math.sin(s),e-n*Math.cos(s));return a},ae.scale=function(t,e,i){for(var n=[],r=0;r<t.length-1;r+=2)n.push(t[r]*e),n.push(t[r+1]*i);return n},ae.translate=function(t,e,i){for(var n=[],r=0;r<t.length-1;r+=2)n.push(t[r]+e),n.push(t[r+1]+i);return n};const he=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass(he,ot),he.prototype.Init=function(t,e,i,n,r){he.superclass.Init.call(this,t,"circle",r),this.setCx(e).setCy(i),this.setRadius(n)},Q.defineProps(he,{r:{name:"radius"},cx:{value:0},cy:{value:0}}),he.prototype.copyShape=function(){return new he(this.getCtx(),this.getCx(),this.getCy(),this.getRadius())},he.prototype.getDimensionsSelf=function(t){var e=new m(this.getCx()-this.getRadius(),this.getCy()-this.getRadius(),2*this.getRadius(),2*this.getRadius());return this.ConvertCoordSpaceRect(e,t)};const le=function(t,e,i,n,r,o,s){this.Init(t,e,i,n,r,o,s)};i.createSubclass(le,ot),le.prototype.Init=function(t,e,i,n,o,s,a){le.superclass.Init.call(this,t,"image",a),e=u.getImageUrl(t,e),"ie"!==r.browser&&"edge"!==r.browser||(u.setAttrNullNS(this._elem,"fill","#FFFFFF"),u.setAttrNullNS(this._elem,"fill-opacity","0")),this.setSrc(e),this.setX(i).setY(n),this.setWidth(o),this.setHeight(s),u.setAttrNullNS(this._elem,"preserveAspectRatio","none"),this.setAriaProperty("hidden","true")},Q.defineProps(le,{x:{},y:{},width:{},height:{}}),le.prototype.getSrc=function(){return this._src},le.prototype.setSrc=function(t){if(t!==this._src){var e=t;this._src=t,u.setHref(this._elem,e)}return this},le.prototype.getDimensions=function(t){if(this.getDimensionsSelf&&this.getNumChildren()-this._getInnerShapeCount()==0)return this.getDimensionsSelf(t);var e=this.getElem().getBBox();return e=e.width&&e.height?new m(e.x,e.y,e.width,e.height):new m(e.x,e.y,this.getWidth(),this.getHeight()),this.ConvertCoordSpaceRect(e,t)},le.prototype.__setDimensions=function(t){this.setWidth(t.width),this.setHeight(t.height)},le.prototype.UpdateSelectionEffect=function(){},le.prototype.copyShape=function(){return new le(this.getCtx(),this.getSrc(),this.getX(),this.getY(),this.getWidth(),this.getHeight())},le.prototype.getDimensionsSelf=function(t){var e=new m(this.getX(),this.getY(),this.getWidth(),this.getHeight());return this.ConvertCoordSpaceRect(e,t)},le.prototype.setAriaProperty=function(t,e){le.superclass.setAriaProperty.call(this,t,e),"hidden"!=t&&le.superclass.setAriaProperty.call(this,"hidden",null)};const ue=function(t,e,i,n,r,o){this.Init(t,e,i,n,r,o)};i.createSubclass(ue,ot),ue.prototype.Init=function(t,e,i,n,r,o){ue.superclass.Init.call(this,t,"line",o),this.setX1(e).setY1(i).setX2(n).setY2(r),this._bHollow=!1},Q.defineProps(ue,{x1:{value:0},x2:{value:0},y1:{value:0},y2:{value:0}}),ue.prototype.setHollow=function(){var t=this._elem.parentNode;if(this._bHollow)this._origElem&&(t.replaceChild(this._origElem,this._elem),u.setAttrNullNS(this._origElem,"opacity",this._alpha),this._elem=this._origElem,this._origElem=null,this._bHollow=!1);else{var e;this._origElem=this._elem;var i=this.getX2()-this.getX1(),n=i,o=this.getY1()-i/2,s=this.getStroke();e=A.createElement("rect"),u.setAttrNullNS(e,"x",this.getX1()),u.setAttrNullNS(e,"y",o),u.setAttrNullNS(e,"width",this.getX2()-this.getX1()),u.setAttrNullNS(e,"height",n);var a=s.getColor();const l="stroke-opacity";if(a){var h=s.getAlpha();"safari"===r.browser&&-1!==a.indexOf("rgba")?(u.setAttrNullNS(e,"stroke",T.getRGB(a)),null!=h?u.setAttrNullNS(e,l,T.getAlpha(a)*h):u.setAttrNullNS(e,l,T.getAlpha(a))):(u.setAttrNullNS(e,"stroke",a),null!=h&&u.setAttrNullNS(e,l,h))}u.setAttrNullNS(e,"fill","#ffffff"),u.setAttrNullNS(e,"fill-opacity","0.001"),u.setAttrNullNS(e,"shape-rendering","crispEdges"),e._obj=this,t.replaceChild(e,this._elem),this._elem=e,u.setAttrNullNS(this._elem,"opacity",this._alpha),this._bHollow=!0}},ue.prototype.getDimensions=function(t){var e=ue.superclass.getDimensions.call(this,t);if(this._childGroupElem&&this._elem){var i=this._childGroupElem.getBBox();if(0==i.x&&0==i.y&&0==i.width&&0==i.height){var n=this._elem.getBBox();e=new m(n.x,n.y,n.width,n.height)}}return e},ue.prototype.copyShape=function(){return new ue(this.getCtx(),this.getX1(),this.getY1(),this.getX2(),this.getY2())},ue.prototype.getDimensionsSelf=function(t){var e=Math.min(this.getX1(),this.getX2()),i=Math.min(this.getY1(),this.getY2()),n=Math.abs(this.getX1()-this.getX2()),r=Math.abs(this.getY1()-this.getY2()),o=new m(e,i,n,r);return this.ConvertCoordSpaceRect(o,t)},ue.prototype._adjustDimensionsForStyle=function(){this.getX1()==this.getX2()?this.setX2(this.getX2()+.001):this.getY1()==this.getY2()&&this.setY2(this.getY2()+.001)},ue.prototype.setStyle=function(t,e){return t&&!e&&this._adjustDimensionsForStyle(),ue.superclass.setStyle.call(this,t)},ue.prototype.setClassName=function(t,e){return t&&!e&&this._adjustDimensionsForStyle(),ue.superclass.setClassName.call(this,t)};const ce=function(t,e,i){this.Init(t,e,i)};i.createSubclass(ce,ot),ce.prototype.Init=function(t,e,i){ce.superclass.Init.call(this,t,"path",i),Array.isArray(e)?this.setCmds(b.getPathString(e)):this.setCmds(e)},ce.prototype.getCmds=function(){return this.GetProperty("d")},ce.prototype.setCmds=function(t){return t&&this.SetSvgProperty("d",t),this.SetProperty("arCmds",null),this},ce.prototype.getCommandsArray=function(){var t=this.GetProperty("arCmds");return t||(t=b.createPathArray(this.getCmds()),this.SetProperty("arCmds",t)),t},ce.prototype.setCommandsArray=function(t){var e=t?b.getPathString(t):null;return this.setCmds(e),this.SetProperty("arCmds",t),this},ce.prototype.copyShape=function(){return new ce(this.getCtx(),this.getCmds())},ce.prototype.GetAriaElem=function(){return r.isTouchDevice()&&this.CreateChildGroupElem(!1,!0),ce.superclass.GetAriaElem.call(this)};const _e=function(t,e,i,n,r,o,s,a,h,l){this.Init(t,e,i,n,r,o,s,a,h,l)};i.createSubclass(_e,ot),_e.CIRCLE="circle",_e.ELLIPSE="ellipse",_e.SQUARE="square",_e.RECTANGLE="rectangle",_e.DIAMOND="diamond",_e.TRIANGLE_UP="triangleUp",_e.TRIANGLE_DOWN="triangleDown",_e.PLUS="plus",_e.HUMAN="human",_e.STAR="star",_e._CIRCLE_ELEM="circle",_e._ELLIPSE_ELEM="ellipse",_e._RECT_ELEM="rect",_e._PATH_ELEM="path",_e._POLYGON_ELEM="polygon",(_e._SHAPE_ELEM_MAP={})[_e.CIRCLE]=_e._CIRCLE_ELEM,_e._SHAPE_ELEM_MAP[_e.ELLIPSE]=_e._ELLIPSE_ELEM,_e._SHAPE_ELEM_MAP[_e.SQUARE]=_e._PATH_ELEM,_e._SHAPE_ELEM_MAP[_e.RECTANGLE]=_e._PATH_ELEM,_e._SHAPE_ELEM_MAP[_e.DIAMOND]=_e._POLYGON_ELEM,_e._SHAPE_ELEM_MAP[_e.TRIANGLE_UP]=_e._POLYGON_ELEM,_e._SHAPE_ELEM_MAP[_e.TRIANGLE_DOWN]=_e._POLYGON_ELEM,_e._SHAPE_ELEM_MAP[_e.PLUS]=_e._POLYGON_ELEM,_e._SHAPE_ELEM_MAP[_e.HUMAN]=_e._PATH_ELEM,_e._SHAPE_ELEM_MAP[_e.STAR]=_e._POLYGON_ELEM,_e.DEFAULT_BORDER_RADIUS="6",_e._HUMAN_CMDS="M 306.40625 386.78125 C 304.19988 386.78125 302.40625 389.07579 302.40625 391.90625 C 302.40625 394.73671 304.19988 397.03125 306.40625 397.03125 C 308.61263 397.03125 310.40625 394.73671 310.40625 391.90625 C 310.40625 389.07579 308.61263 386.78125 306.40625 386.78125 z M 301.78125 396.0625 C 300.43025 397.2945 298.28125 400.28125 298.90625 403.15625 C 302.41725 405.79925 309.20225 406.154 314.03125 403 C 314.21825 399.828 312.68325 397.5635 310.90625 396.0625 C 308.65625 400.7185 304.28125 399.7815 301.78125 396.0625 z ",_e._SHAPE_STAR_CMDS=[-50,-11.22,-16.69,-17.94,0,-47.55,16.69,-17.94,50,-11.22,26.69,13.8,30.9,47.56,0,33.42,-30.9,47.56,-26.69,13.8],_e.prototype.Init=function(t,e,i,n,r,o,s,a,h,l){h&&(i=Math.round(i),n=Math.round(n),r=Math.round(r),o=(o=Math.round(o))%2==1?o+1:o,r=r%2==1?r+1:r),this._bMaintainAspectRatio=!0,!1===a&&(this._bMaintainAspectRatio=!1,e==_e.CIRCLE&&(e=_e.ELLIPSE)),s&&"0"!=s&&(this._borderRadius=s),this._shape=e||_e.RECTANGLE,this._dataColor="#000000";var u=e?_e._SHAPE_ELEM_MAP[e]:_e._PATH_ELEM;null==u&&(this._isCustomShape=!0,this._path=new ce(t,e),u=_e._PATH_ELEM),_e.superclass.Init.call(this,t,u,l),this._shape!=_e.SQUARE&&this._shape!=_e.RECTANGLE||(this._path=this._getBorderRadiusPath(t,i,n,r,o,s)),this._shape==_e.HUMAN&&(this._path=new ce(t,_e._HUMAN_CMDS)),this._propertyChange={},this.setCenter(i,n,!0).setSize(r,o)},_e.prototype.setCenterDimensions=function(t){return this.setCenter(t.x,t.y,!0).setSize(t.w,t.h)},_e.prototype.getCenterDimensions=function(){return new m(this._cx,this._cy,this._width,this._height)},_e.prototype.setSize=function(t,e,i){return this.setWidth(t,!0).setHeight(e,i)},_e.prototype.setCenter=function(t,e,i){return this.setCx(t,!0).setCy(e,i)},_e.prototype._updateSvgProperties=function(){if(this._propertyChange.width||this._propertyChange.height){var t=Math.min(this._width,this._height);this._propertyChange.s=this._s!=t,this._s=t}if(this._shape!=_e.RECTANGLE&&this._shape!=_e.SQUARE||this._borderRadius)this._shape==_e.CIRCLE||this._shape==_e.ELLIPSE?(this._propertyChange.cx&&u.setAttrNullNS(this._elem,"cx",this._cx,0),this._propertyChange.cy&&u.setAttrNullNS(this._elem,"cy",this._cy,0),this._shape==_e.CIRCLE?this._propertyChange.s&&u.setAttrNullNS(this._elem,"r",this._s/2,0):(this._propertyChange.width&&u.setAttrNullNS(this._elem,"rx",this._width/2,0),this._propertyChange.height&&u.setAttrNullNS(this._elem,"ry",this._height/2,0))):this._isPolygon()?(this._propertyChange.s||this._propertyChange.cx||this._propertyChange.cy)&&this._setPolygon(this._getPolygonArray()):this._isPath()&&(this._propertyChange.width||this._propertyChange.height||this._propertyChange.cx||this._propertyChange.cy)&&this._setCmds(this._getCmds());else if(this._propertyChange.width||this._propertyChange.height||this._propertyChange.cx||this._propertyChange.cy){var e=b.rectangleWithBorderRadius(this._cx-this._width/2,this._cy-this._height/2,this._width,this._height);this._setCmds(e)}return this.UpdateSelectionEffect(),this._propertyChange={},this},_e.prototype.getCx=function(){return this._cx},_e.prototype.setCx=function(t,e){return this._propertyChange.cx=this._cx!=t,this._cx=t,e?this:this._updateSvgProperties()},_e.prototype.getCy=function(){return this._cy},_e.prototype.setCy=function(t,e){return this._propertyChange.cy=this._cy!=t,this._cy=t,e?this:this._updateSvgProperties()},_e.prototype.getSize=function(){return this._s},_e.prototype.getWidth=function(){return this._width},_e.prototype.setWidth=function(t,e){return this._propertyChange.width=this._width!=t,this._width=t,e?this:this._updateSvgProperties()},_e.prototype.getHeight=function(){return this._height},_e.prototype.setHeight=function(t,e){return this._propertyChange.height=this._height!=t,this._height=t,e?this:this._updateSvgProperties()},_e.prototype._getPolygonArray=function(){var t=[],e=this._cx,i=this._cy,n=this.getMaintainAspectRatio()?this._s/2:this._width/2,r=this.getMaintainAspectRatio()?this._s/2:this._height/2,o=this.getMaintainAspectRatio()?this._s/6:this._width/6,s=this.getMaintainAspectRatio()?this._s/6:this._height/6;return this._shape==_e.TRIANGLE_UP?t=[e-n,i+r,e,i-r,e+n,i+r]:this._shape==_e.TRIANGLE_DOWN?t=[e-n,i-r,e,i+r,e+n,i-r]:this._shape==_e.DIAMOND?t=[e-n,i,e,i-r,e+n,i,e,i+r]:this._shape==_e.PLUS?t=[e-n,i-s,e-o,i-s,e-o,i-r,e+o,i-r,e+o,i-s,e+n,i-s,e+n,i+s,e+o,i+s,e+o,i+r,e-o,i+r,e-o,i+s,e-n,i+s]:this._shape==_e.STAR&&(t=_e._SHAPE_STAR_CMDS,t=ae.scale(t,this.getMaintainAspectRatio()?this._s/100:this._width/100,this.getMaintainAspectRatio()?this._s/100:this._height/100),t=ae.translate(t,e,i)),t},_e.prototype._setPolygon=function(t){u.setAttrNullNS(this._elem,"points",A.convertPointsArray(t))},_e.prototype._getCmds=function(){var t=q.getDimForced(this.getCtx(),this._path),e=Math.max(t.w,t.h),i=this.getMaintainAspectRatio();this._shape==_e.RECTANGLE&&(i=!1);var n=i?this._s/e:this._width/t.w,r=i?this._s/e:this._height/t.h,o=this._cx-t.x*n-t.w*n/2,s=this._cy-t.y*r-t.h*r/2;return b.transformPath(this._path.getCommandsArray(),o,s,n,r)},_e.prototype._setCmds=function(t){u.setAttrNullNS(this._elem,"d",t)},_e.prototype.getType=function(){return this._shape},_e.prototype._isPolygon=function(){return _e._SHAPE_ELEM_MAP[this._shape]==_e._POLYGON_ELEM},_e.prototype._isPath=function(){return _e._SHAPE_ELEM_MAP[this._shape]==_e._PATH_ELEM||this._isCustomShape},_e.prototype.GetStrokeWidth=function(){var t=this.getStroke();return t?t.getWidth():0},_e.prototype._getBorderRadiusPath=function(t,e,i,n,r,o){if(this._shape==_e.SQUARE||this._shape==_e.RECTANGLE){var s=Math.min(n,r),a=this._shape==_e.SQUARE?s:n,h=this._shape==_e.SQUARE?s:r,l=e-a/2,u=i-h/2,c=b.rectangleWithBorderRadius(l,u,a,h,o,s,"0");return new ce(t,c)}return null},_e.prototype._getBorderRadius=function(){return this._borderRadius},_e.prototype.setDataColor=function(t,e){if(this._dataColor=t,!e){var i=rt.getHoverBorderColor(t);this.setHoverStroke(new z("#FFFFFF",1,1,!0),new z(i,1,3.5,!0)),this.setSelectedStroke(new z("#FFFFFF",1,1.5,!0),new z("#5A5A5A",1,4.5,!0)),this.setSelectedHoverStroke(new z("#FFFFFF",1,1.5,!0),new z(i,1,4.5,!0))}},_e.prototype.getDataColor=function(){return this._dataColor},_e.prototype.setHollow=function(t){var e=this.GetStrokeWidth();e=e||1,_e.superclass.setHollow.call(this,t,e)},_e.prototype.setText=function(t){this._markerText=t},_e.prototype.setAlpha=function(t){_e.superclass.setAlpha.call(this,t),t!==this.getAlpha()&&(this._markerText&&this._markerText.setAlpha(t),this.UpdateSelectionEffect())},_e.prototype.copyShape=function(){return new _e(this.getCtx(),this._shape,this.getCx(),this.getCy(),this.getWidth(),this.getHeight(),this._getBorderRadius(),this.getMaintainAspectRatio())},_e.prototype.getDimensions=function(t){return this.getDimensionsSelf(t)},_e.prototype.getDimensionsSelf=function(t){var e=this.getCx()-this.getWidth()/2,i=this.getCy()-this.getHeight()/2,n=new m(e,i,this.getWidth(),this.getHeight());return this.ConvertCoordSpaceRect(n,t)},_e.prototype.setMaintainAspectRatio=function(t){this._bMaintainAspectRatio=t},_e.prototype.getMaintainAspectRatio=function(){return this._bMaintainAspectRatio};const pe=function(t,e,i,n,r,o,s,a,h,l,u){this.Init(t,e,i,n,r,o,s,a,h,l,u)};i.createSubclass(pe,ot),pe.prototype.Init=function(t,e,i,n,o,s,a,h,l,c,_){pe.superclass.Init.call(this,t,"image",_),this._setMarkerImageStates(a,h,l,c);var p=this._getImage();this._setSource(p),this._propertyChange={},this.setCenter(e,i,!0).setSize(n,o),this._updateBorder(s),"ie"!==r.browser&&"edge"!==r.browser||(u.setAttrNullNS(this._elem,"fill","#FFFFFF"),u.setAttrNullNS(this._elem,"fill-opacity","0"))},pe.prototype.setPreserveAspectRatio=function(t){u.setAttrNullNS(this._elem,"preserveAspectRatio",t,"xMidYMid")},pe.prototype.setCenterDimensions=function(t){return this.setCenter(t.x,t.y,!0).setSize(t.w,t.h)},pe.prototype.getCenterDimensions=function(){return new m(this._cx,this._cy,this._width,this._height)},pe.prototype.setSize=function(t,e,i){return this.setWidth(t,!0).setHeight(e,i)},pe.prototype.getSize=function(){return Math.max(this.getWidth(),this.getHeight())},pe.prototype.setCenter=function(t,e,i){return this.setCx(t,!0).setCy(e,i)},pe.prototype._updateSvgProperties=function(){return(this._propertyChange.cx||this._propertyChange.width)&&u.setAttrNullNS(this._elem,"x",this._cx-this._width/2,0),(this._propertyChange.cy||this._propertyChange.height)&&u.setAttrNullNS(this._elem,"y",this._cy-this._height/2,0),this._propertyChange.width&&u.setAttrNullNS(this._elem,"width",this._width,0),this._propertyChange.height&&u.setAttrNullNS(this._elem,"height",this._height,0),this._updateBorder(this._borderRadius),this.UpdateSelectionEffect(),this._propertyChange={},this},pe.prototype.getCx=function(){return this._cx},pe.prototype.setCx=function(t,e){return this._propertyChange.cx=this._cx!=t,this._cx=t,e?this:this._updateSvgProperties()},pe.prototype.getCy=function(){return this._cy},pe.prototype.setCy=function(t,e){return this._propertyChange.cy=this._cy!=t,this._cy=t,e?this:this._updateSvgProperties()},pe.prototype.getWidth=function(){return this._width},pe.prototype.setWidth=function(t,e){return this._propertyChange.width=this._width!=t,this._width=t,e?this:this._updateSvgProperties()},pe.prototype.getHeight=function(){return this._height},pe.prototype.setHeight=function(t,e){return this._propertyChange.height=this._height!=t,this._height=t,e?this:this._updateSvgProperties()},pe.prototype._setSource=function(t){u.setHref(this._elem,u.getImageUrl(this.getCtx(),t))},pe.prototype._setMarkerImageStates=function(t,e,i,n){var r=t;this._imageStates=[r],this._imageStates.push(e||r),this._imageStates.push(i||r),this._imageStates.push(n||this._imageStates[1])},pe.prototype._getImage=function(){return this._imageStates[0]},pe.prototype._getImageSelected=function(){return this._imageStates[1]},pe.prototype._getImageHover=function(){return this._imageStates[2]},pe.prototype._getImageHoverSelected=function(){return this._imageStates[3]},pe.prototype.showHoverEffect=function(){this.IsShowingHoverEffect=!0,this.isSelected()?this._setSource(this._getImageHoverSelected()):this._setSource(this._getImageHover())},pe.prototype.hideHoverEffect=function(){this.IsShowingHoverEffect=!1,this.isSelected()?this._setSource(this._getImageSelected()):this._setSource(this._getImage())},pe.prototype.setSelected=function(t){this.IsSelected!=t&&(this.IsSelected=t,t?this.isHoverEffectShown()?this._setSource(this._getImageHoverSelected()):this._setSource(this._getImageSelected()):this._setSource(this._getImage()))},pe.prototype._updateBorder=function(t){if(t||this._borderPath){if(t&&"0"!=t){var e=b.rectangleWithBorderRadius(this._cx-this._width/2,this._cy-this._height/2,this._width,this._height,t,Math.min(this._width,this._height),"0"),i=new p;i.addPath(e),this.setClipPath(i)}if(this._borderPath){var n=b.rectangleWithBorderRadius(this._cx-this._width/2+this._borderWidth/2,this._cy-this._height/2+this._borderWidth/2,this._width-this._borderWidth,this._height-this._borderWidth,t,Math.min(this._width,this._height),"0");this._borderPath.setCmds(n)}}this._borderRadius=t},pe.prototype._getBorderRadius=function(){return this._borderRadius},pe.prototype.setStroke=function(t){if(!t||t.getWidth()<=0)return this._borderWidth=0,void(this._borderPath&&(this.removeChild(this._borderPath),this._borderPath=null));var e=t.getWidth();if(!this._borderPath||e!=this._borderWidth){var i=b.rectangleWithBorderRadius(this._cx-this._width/2+e/2,this._cy-this._height/2+e/2,this._width-e,this._height-e,this._borderRadius,Math.min(this._width,this._height),"0");this._borderPath?this._borderPath.setCmds(i):(this._borderPath=new ce(this.getCtx(),i),this._borderPath.setInvisibleFill(),this.addChild(this._borderPath))}this._borderWidth=e,this._borderPath.setStroke(t)},pe.prototype.setHollow=function(t,e){pe.superclass.setHollow.call(this,t,e),this.isHollow()?(this._imageContainer=this._elem.parentNode,this._imageContainer.removeChild(this._elem)):this._imageContainer&&this._imageContainer.appendChild(this._elem)},pe.prototype.copyShape=function(){return new pe(this.getCtx(),this.getCx(),this.getCy(),this.getWidth(),this.getHeight(),this._getBorderRadius(),this._getImage(),this._getImageSelected(),this._getImageHover(),this._getImageHoverSelected(),null)},pe.prototype.getDimensionsSelf=function(t){var e=this.getCx()-this.getWidth()/2,i=this.getCy()-this.getHeight()/2,n=new m(e,i,this.getWidth(),this.getHeight());return this.ConvertCoordSpaceRect(n,t)};const de=function(){};i.createSubclass(de,ot),de.prototype.Init=function(t,e,i,n){de.superclass.Init.call(this,t,e,n),i&&this.setPoints(i)},de.prototype.getPoints=function(){return this.GetProperty("arPoints")},de.prototype.setPoints=function(t){return this.SetProperty("arPoints",t),this.SetSvgProperty("points",A.convertPointsArray(t))},de.prototype.getDimensionsSelf=function(t){var e=ae.getDimensions(this.getPoints());return this.ConvertCoordSpaceRect(e,t)};const ge=function(t,e,i,n){n||this.Init(t,e,i)};i.createSubclass(ge,de),ge.prototype.Init=function(t,e,i){ge.superclass.Init.call(this,t,"polygon",e,i)},ge.prototype.copyShape=function(){return new ge(this.getCtx(),this.getPoints())},ge.prototype.GetAriaElem=function(){return r.isTouchDevice()&&this.CreateChildGroupElem(!1,!0),ge.superclass.GetAriaElem.call(this)};const fe=function(t,e,i){this.Init(t,e,i)};i.createSubclass(fe,de),fe.prototype.Init=function(t,e,i){fe.superclass.Init.call(this,t,"polyline",e,i),u.setAttrNullNS(this._elem,"fill","none")},fe.prototype.copyShape=function(){return new fe(this.getCtx(),this.getPoints())},fe.prototype.requiresStrokeAdjustmentForShadow=function(){return!0};const ye=function(t,e,i,n,r,o){this.Init(t,e,i,n,r,o)};i.createSubclass(ye,J),ye._PADDING=.15,ye.prototype.Init=function(t,e,i,n,r,o){ye.superclass.Init.call(this,t,"g",o),this.TextInstance=this.CreateTextInstance(t,e,i,n,o),this._backgroundRect=null,r&&this.setCSSStyle(r),this.addChild(this.TextInstance)},ye.prototype.getTextString=function(){return this.TextInstance.getTextString()},ye.prototype.setTextString=function(t){return this.TextInstance.setTextString(t),this},ye.prototype.isTruncated=function(){return this.TextInstance.isTruncated()},ye.prototype.getUntruncatedTextString=function(){return this.TextInstance.getUntruncatedTextString()},ye.prototype.setUntruncatedTextString=function(t){this.TextInstance.setUntruncatedTextString(t)},ye.prototype.getX=function(){return this.TextInstance.getX()},ye.prototype.setX=function(t){return this.TextInstance=this.TextInstance.setX(t),this._realignBackground(),this},ye.prototype.getY=function(){return this.TextInstance.getY()},ye.prototype.setY=function(t){return this.TextInstance=this.TextInstance.setY(t),this._realignBackground(),this},ye.prototype.setFontSize=function(t){this.TextInstance.setFontSize(t),this._style.setFontSize(j.FONT_SIZE,String(t),this.getCtx()),this._realignBackground()},ye.prototype.getHorizAlignment=function(){return this.TextInstance.getHorizAlignment()},ye.prototype.setHorizAlignment=function(t){this.TextInstance.setHorizAlignment(t),this._realignBackground()},ye.prototype.getVertAlignment=function(){return this.TextInstance.getVertAlignment()},ye.prototype.setVertAlignment=function(t){this.TextInstance.setVertAlignment(t),this._realignBackground()},ye.prototype.alignLeft=function(){this.TextInstance.alignLeft(),this._realignBackground()},ye.prototype.alignCenter=function(){this.TextInstance.alignCenter(),this._realignBackground()},ye.prototype.alignRight=function(){this.TextInstance.alignRight(),this._realignBackground()},ye.prototype.alignTop=function(){this.TextInstance.alignTop(),this._realignBackground()},ye.prototype.alignMiddle=function(){this.TextInstance.alignMiddle(),this._realignBackground()},ye.prototype.alignBottom=function(){this.TextInstance.alignBottom(),this._realignBackground()},ye.prototype.alignAuto=function(){this.TextInstance.alignAuto(),this._realignBackground()},ye.prototype.setCSSStyle=function(t){t.getStyle(j.BACKGROUND_COLOR)&&!t.getStyle(j.COLOR)&&t.setStyle(j.COLOR,T.getContrastingTextColor(t.getStyle(j.BACKGROUND_COLOR))),this.TextInstance&&this.TextInstance.setCSSStyle(t),(this._backgroundRect||ye._hasBackgroundStyles(t))&&(this._backgroundRect||(this._backgroundRect=this.CreateBackground(this.getCtx(),this.TextInstance),this.addChildAt(this._backgroundRect,0)),this._setBackgroundCSSStyle(this._backgroundRect,t)),this._style=t},ye.prototype.getCSSStyle=function(){return this._style},ye.prototype.setMatrix=function(t){this.TextInstance.setMatrix(t),this._backgroundRect&&this._backgroundRect.setMatrix(t)},ye.prototype.getMatrix=function(){return this.TextInstance.getMatrix()},ye.prototype.getTextDimensions=function(t){return this.TextInstance.getDimensions(t)},ye.prototype.getDimensions=function(t){var e=this.TextInstance.getDimensions(),i=e.h*ye._PADDING;return e.x-=i,e.w+=2*i,this.ConvertCoordSpaceRect(e,t)},ye.prototype.getDimensionsWithStroke=function(){return this.GetElemDimensionsWithStroke()},ye.prototype.GetDimensionsWithStroke=function(t){var e=this.GetElemDimensionsWithStroke();return t&&t!==this?this.ConvertCoordSpaceRect(e,t):e},ye.prototype.GetElemDimensionsWithStroke=function(){var t=this.getDimensions(),e=(this._backgroundRect?this._backgroundRect:this.TextInstance).getStroke();if(t&&e){var i=e.getWidth();if(i){var n=.5*i;t.x-=n,t.y-=n,t.w+=i,t.h+=i}}return t},ye.prototype.copyShape=function(){return this.TextInstance.copyShape()},ye.prototype.CreateTextInstance=function(t,e,i,n,r){return new at(t,e,i,n,r)},ye.prototype.CreateBackground=function(t,e){var i=e.getDimensions(),n=i.h*ye._PADDING;return new lt(t,i.x-n,i.y,i.w+2*n,i.h)},ye.prototype._realignBackground=function(){if(this._backgroundRect){var t=this.TextInstance.getDimensions(),e=.15*t.h,i=this.getHorizAlignment(),n=this.getVertAlignment();i==at.H_ALIGN_LEFT?this._backgroundRect.setX(this.getX()-e):i==at.H_ALIGN_CENTER?this._backgroundRect.setX(this.getX()-.5*t.w-e):i==at.H_ALIGN_RIGHT&&this._backgroundRect.setX(this.getX()-t.w-e);var o=parseFloat(this._style.getFontSize());isNaN(o)&&(o=0);var s=0;"blink"===r.engine&&n==at.V_ALIGN_MIDDLE?s=.12*o:"ie"!==r.browser&&"edge"!==r.browser||n!=at.V_ALIGN_BOTTOM||(s=.4*-o);var a=this.GetTextDimensionsForRealign(t);n==at.V_ALIGN_TOP?this._backgroundRect.setY(this.getY()):n==at.V_ALIGN_MIDDLE?this._backgroundRect.setY(this.getY()-.5*a-s):n==at.V_ALIGN_CENTRAL?this._backgroundRect.setY(this.getY()-.5*a):n==at.V_ALIGN_BOTTOM?this._backgroundRect.setY(this.getY()-a-s):n==at.V_ALIGN_AUTO&&this._backgroundRect.setY(t.y),this._backgroundRect.setWidth(t.w+2*e),this._backgroundRect.setHeight(t.h)}},ye.prototype._setBackgroundCSSStyle=function(t,e){if(e){var i=e.getStyle(j.BACKGROUND_COLOR);null!=i?t.setSolidFill(i):t.setInvisibleFill();var n=e.getStyle(j.BORDER_COLOR),r=e.getStyle(j.BORDER_WIDTH),o=e.getStyle(j.BORDER_RADIUS);if(n||r||o){var s=new j;s.setStyle(j.BORDER_COLOR,n),s.setStyle(j.BORDER_WIDTH,r),s.setStyle(j.BORDER_RADIUS,o),t.setCSSStyle(s)}}else t.setInvisibleFill();t.setMouseEnabled(!1)},ye.prototype.GetTextDimensionsForRealign=function(t){return t.h},ye._hasBackgroundStyles=function(t){return!!t&&t.hasBackgroundStyles()},ye.prototype.includeChildSubtree=function(){return!1},ye.prototype.isMultiline=function(){return!1},ye.prototype.hasBackground=function(){return!0};const ve=function(t,e,i,n,r,o,s){this.Init(t,e,i,n,r,o,s)};i.createSubclass(ve,ye),ve.prototype.Init=function(t,e,i,n,r,o,s){this._preserveNewLine=s||!1,ve.superclass.Init.call(this,t,e,i,n,r,o)},ve.prototype.wrapText=function(t,e,i,n){return this.TextInstance.wrapText(t,e,i,n)},ve.prototype.CreateTextInstance=function(t,e,i,n,r){return new mt(t,e,i,n,r,this._preserveNewLine)},ve.prototype.GetTextDimensionsForRealign=function(){return this.getLineHeight()},ve.prototype.getDimensions=function(t){var e=this.TextInstance.getDimensions(),i=e.h*ye._PADDING/this.getLineCount();return e.x-=i,e.w+=2*i,this.ConvertCoordSpaceRect(e,t)},ve.prototype.__fitText=function(t,e,i){return this.TextInstance.__fitText(t,e,i)},ve.prototype._getTextLines=function(){return this.TextInstance._getTextLines()},ve.prototype.getLineHeight=function(){return this.TextInstance.getLineHeight()},ve.prototype.getLineCount=function(){return this.TextInstance.getLineCount()},ve.prototype.getYAlignCoord=function(){return this.TextInstance.getYAlignCoord()},ve.prototype.setWrapEnabled=function(t){this.TextInstance.setWrapEnabled(t)},ve.prototype.isWrapEnabled=function(){return this.TextInstance.isWrapEnabled()},ve.prototype.UpdateSelectionEffect=function(){},ve.prototype.isMultiline=function(){return!0};const Se=function(t,e){this.Init(t,e)};i.createSubclass(Se,i),Se.FONT_SIZE_11=(Se.FONT_SIZE="font-size: ")+"11px;",Se.FONT_SIZE_12=Se.FONT_SIZE+"12px;",Se.FONT_SIZE_13=Se.FONT_SIZE+"13px;",Se.FONT_SIZE_14=Se.FONT_SIZE+"14px;",Se.FONT_WEIGHT_BOLD="font-weight: bold;",Se.FONT_FAMILY_ALTA_11=(Se.FONT_FAMILY_ALTA="font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;")+Se.FONT_SIZE_11,Se.FONT_FAMILY_ALTA_12=Se.FONT_FAMILY_ALTA+Se.FONT_SIZE_12,Se.FONT_FAMILY_ALTA_13=Se.FONT_FAMILY_ALTA+Se.FONT_SIZE_13,Se.FONT_FAMILY_ALTA_14=Se.FONT_FAMILY_ALTA+Se.FONT_SIZE_14,Se.FONT_FAMILY_ALTA_BOLD_11=(Se.FONT_FAMILY_ALTA_BOLD=Se.FONT_FAMILY_ALTA+Se.FONT_WEIGHT_BOLD)+Se.FONT_SIZE_11,Se.FONT_FAMILY_ALTA_BOLD_12=Se.FONT_FAMILY_ALTA_BOLD+Se.FONT_SIZE_12,Se.FONT_FAMILY_ALTA_BOLD_13=Se.FONT_FAMILY_ALTA_BOLD+Se.FONT_SIZE_13,Se.FONT_FAMILY_ALTA_BOLD_14=Se.FONT_FAMILY_ALTA_BOLD+Se.FONT_SIZE_14,Se._SKINS=[j.SKIN_ALTA],Se.prototype.Init=function(t,e){this._defaults=t||{},this._context=e,this.constructor.defaultsCache||(this.constructor.defaultsCache={})},Se.prototype.getBaseSkinName=function(){return j.SKIN_ALTA},Se.prototype.calcOptions=function(t){var e=t?t.skin:null,i=this.getDefaults(e);if(!t)return i;var n=this.getNoCloneObject();if(this._context&&this._context.dataProviderProps)for(var r=this._context.dataProviderProps,o=0;o<r.length;o++)n[r[o]]=!0;var s=Et.merge(t,i,n);return 0==this.getAnimationDuration(s)&&(s.animationOnDataChange="none",s.animationOnDisplay="none"),s},Se.prototype.getDefaults=function(t){if(t||(t=this.getBaseSkinName()),this.constructor.defaultsCache[t])return Et.clone(this.constructor.defaultsCache[t]);for(var e=Math.max(Se._SKINS.indexOf(t),0),i=Et.clone(this._defaults[Se._SKINS[0]]),n=1;n<=e;n++)i=Et.merge(this._defaults[Se._SKINS[n]],i);return this.constructor.defaultsCache[t]=Et.clone(i),i},Se.prototype.getNoCloneObject=function(){return{}},Se.prototype.getAnimationDuration=function(t){return t.styleDefaults&&t.styleDefaults.animationDuration?t.styleDefaults.animationDuration:t.animationDuration?t.animationDuration:null};const Te=function(t,e,i,n){Te.superclass.Init.call(this,t),this._callback=e,this._callbackObj=i,this._dragTarget=n};i.createSubclass(Te,J),Te._THUMB_MIN_SIZE=12,Te.prototype.render=function(t,e,i){this._width=e,this._height=i,this._globalMin=t.min,this._globalMax=t.max,this._isHoriz=t.isHorizontal,this._isReversed=t.isReversed;var n=new lt(this.getCtx(),0,0,e,i);n.setSolidFill(t.backgroundColor),n.setPixelHinting(!0),this.addChild(n),this._thumb=new lt(this.getCtx(),0,0,e,i),this._thumb.setSolidFill(t.color),this._thumb.setPixelHinting(!0),this.addChild(this._thumb),this._thumbMin=this._globalMin,this._thumbMax=this._globalMax,this._renderedThumbMin=this._thumbMin,this._renderedThumbMax=this._thumbMax;var o=r.isTouchDevice()?8:4,s=new lt(this.getCtx(),-o,-o,this._width+2*o,this._height+2*o);s.setInvisibleFill(),this.addChild(s);var a=null!=this._dragTarget;gt.addDragListeners(a?this._dragTarget:this,this._onDragStart,this._onDragMove,this._onDragEnd,this,!a),r.isTouchDevice()||a||this.addEvtListener(F.CLICK,this._onClick,!1,this),this._dragged=!1},Te.prototype.setViewportRange=function(t,e,i,n){null!=i&&(this._globalMin=i),null!=n&&(this._globalMax=n),this._thumbMin=t,this._thumbMax=e;var r=e-t,o=this._globalMax-this._globalMin,s=Math.min(Te._THUMB_MIN_SIZE/(this._isHoriz?this._width:this._height)*o,o);r<s&&(e+=(s-r)/2,(t-=(s-r)/2)<this._globalMin&&(t=this._globalMin,e=this._globalMin+s),e>this._globalMax&&(e=this._globalMax,t=this._globalMax-s)),this._renderedThumbMin=t,this._renderedThumbMax=e;var a=this._getCoord(t),h=this._getCoord(e);this._isHoriz?(this._thumb.setX(Math.min(a,h)),this._thumb.setWidth(Math.abs(h-a))):(this._thumb.setY(Math.min(a,h)),this._thumb.setHeight(Math.abs(h-a)))},Te.prototype._getCoord=function(t){var e=(t-this._globalMin)/(this._globalMax-this._globalMin);return this._isReversed&&(e=1-e),this._isHoriz?e*this._width:e*this._height},Te.prototype._getValue=function(t,e){var i=this.stageToLocal(this.getCtx().pageToStageCoords(t,e)),n=this._isHoriz?i.x/this._width:i.y/this._height;return this._isReversed&&(n=1-n),n=Math.min(Math.max(n,0),1),this._globalMin+n*(this._globalMax-this._globalMin)},Te.prototype._onClick=function(t){var e=this._getValue(t.pageX,t.pageY);if(!(e>=this._renderedThumbMin&&e<=this._renderedThumbMax)){var i=this._thumbMax-this._thumbMin;this._setViewportRange(e-i/2,e+i/2,"end")}},Te.prototype._onDragStart=function(t){var e;if(t.touches){if(1!=t.touches.length)return!1;e=this._getValue(t.touches[0].pageX,t.touches[0].pageY)}else e=this._getValue(t.pageX,t.pageY);return!!(this._dragTarget||e>=this._renderedThumbMin&&e<=this._renderedThumbMax)&&(this._prevVal=Math.min(Math.max(e,this._thumbMin),this._thumbMax),this._dragged=!0,!0)},Te.prototype._onDragMove=function(t){if(this._dragged){var e;if(t.touches){if(1!=t.touches.length)return;e=this._getValue(t.touches[0].pageX,t.touches[0].pageY)}else e=this._getValue(t.pageX,t.pageY);var i=e-this._prevVal;this._dragTarget&&(i*=-1),this._setViewportRange(this._thumbMin+i,this._thumbMax+i,"move"),this._prevVal=e,t.preventDefault()}},Te.prototype._onDragEnd=function(t){if(this._dragged){if(t.touches)this._setViewportRange(this._thumbMin,this._thumbMax,"end");else{var e=this._getValue(t.pageX,t.pageY)-this._prevVal;this._setViewportRange(this._thumbMin+e,this._thumbMax+e,"end")}this._dragged=!1}},Te.prototype._setViewportRange=function(t,e,i){var n=e-t;if(t<this._globalMin&&(t=this._globalMin,e=this._globalMin+n),e>this._globalMax&&(e=this._globalMax,t=this._globalMax-n),this.setViewportRange(t,e),this._callback){var r=yt.newSimpleScrollbarEvent(i,t,e);this._callback.call(this._callbackObj,r,this)}};const Ee=function(t,e,i,n,o){Ee.superclass.Init.call(this,t),this._contentSize=o?e:i,this._width=e,this._height=i,this._background=new lt(t,0,0,e,i),this._background.setInvisibleFill(),this.addChild(this._background),this._container=new J(t),this.addChild(this._container),this._isHorizontalScrolling=o,this._isScrollbarVisible=!1,this.scrolling=n,r.isTouchDevice()||this.addEvtListener(F.MOUSEWHEEL,this._onMouseWheel,!1,this)};i.createSubclass(Ee,J),Ee._SCROLLBAR_WIDTH=3,Ee._SCROLLBAR_GAP=2,Ee.prototype.getScrollingPane=function(){return this._container},Ee.prototype.prepareContentPane=function(){var t=this._container.getDimensions();if(this._isHorizontalScrolling?this._contentSize=t.w+t.x:this._contentSize=t.h+t.y,this.hasScrollingContent()){if(this._isHorizontalScrolling?this._contentSize+=t.x:this._contentSize+=t.y,!this._maskContainer){var e=new m(0,0,this._width,this._height);this._fadeTop=new Dt(new ee(this._isHorizontalScrolling?0:270,["#FFFFFF","#FFFFFF"],[0,1],[0,.1]),e),this._fadeBottom=new Dt(new ee(this._isHorizontalScrolling?180:90,["#FFFFFF","#FFFFFF"],[0,1],[0,.1]),e),this._fadeTopBottom=new Dt(new ee(this._isHorizontalScrolling?180:90,["#FFFFFF","#FFFFFF","#FFFFFF","#FFFFFF"],[0,1,1,0],[0,.1,.9,1]),e),this._maskContainer=new J(this.getCtx()),this.addChild(this._maskContainer);var i=new p;i.addRect(0,0,this._width,this._height),this._container.setClipPath(i),this._maskContainer.addChild(this._container),this._scrollbar=new Te(this.getCtx(),this._handleScrollbar,this,this),this._scrollbarTimer=new ut(this.getCtx(),100,this._hideScrollbar,this)}this._maskContainer.setMask(this._fadeBottom);var n={color:"#9E9E9E",backgroundColor:"#F0F0F0",isHorizontal:this._isHorizontalScrolling,isReversed:!1,min:0,max:this._contentSize};this._isHorizontalScrolling?(this._scrollbar.render(n,this._getScrollbarWidth(),Ee._SCROLLBAR_WIDTH),this._scrollbar.setTranslate(Ee._SCROLLBAR_GAP,this._height-(Ee._SCROLLBAR_WIDTH+Ee._SCROLLBAR_GAP))):(this._scrollbar.render(n,Ee._SCROLLBAR_WIDTH,this._getScrollbarWidth()),this._scrollbar.setTranslate(r.isRightToLeft(this.getCtx())?Ee._SCROLLBAR_GAP:this._width-(Ee._SCROLLBAR_WIDTH+Ee._SCROLLBAR_GAP),Ee._SCROLLBAR_GAP)),this._scrollbar.setViewportRange(0,this._getAvailSize()),r.isEnvironmentTest()||this._scrollbar.setAlpha(0),this.addChild(this._scrollbar),"always"===this.scrolling&&this._showScrollbar()}else this.addChild(this._container),this.removeChild(this._maskContainer),this.removeChild(this._scrollbar)},Ee.prototype._getScrollbarWidth=function(){return(this._isHorizontalScrolling?this._width:this._height)-2*Ee._SCROLLBAR_GAP},Ee.prototype._getAvailSize=function(){return this._isHorizontalScrolling?this._width:this._height},Ee.prototype._hideScrollbar=function(t){this._isScrollbarVisible&&"always"!==this.scrolling&&(this._isScrollbarVisible=!1,this._scrollbarTimer.reset(),this._fadeOutAnim=new jt(this.getCtx(),this._scrollbar,.2),this._fadeOutAnim.play())},Ee.prototype._showScrollbar=function(t){this._isScrollbarVisible?(this._scrollbarTimer.reset(),this._scrollbarTimer.start()):(this._fadeOutAnim&&(this._fadeOutAnim.stop(!0),this._fadeOutAnim=null),this._scrollbar.setAlpha(1),this._isScrollbarVisible=!0,this._scrollbarTimer.start())},Ee.prototype._updateFade=function(t){0==t?this._maskContainer.setMask(this._fadeBottom):t+this._getAvailSize()>=this._contentSize?this._maskContainer.setMask(this._fadeTop):this._maskContainer.setMask(this._fadeTopBottom)},Ee.prototype._onMouseWheel=function(t){if(this.hasScrollingContent()){this._showScrollbar();var e=null!=t.wheelDelta?t.wheelDelta:0,i=-1*(this._isHorizontalScrolling?this._container.getTranslateX():this._container.getTranslateY())-4*e,n=Math.max(this._contentSize-this._getAvailSize(),0),r=Math.max(Math.min(i,n),0);this._isHorizontalScrolling?(this._container.setTranslateX(-1*r),this._scrollbar.setViewportRange(r+this._width,r)):(this._container.setTranslateY(-1*r),this._scrollbar.setViewportRange(r,r+this._height)),this._updateFade(r),t.preventDefault()}},Ee.prototype._handleScrollbar=function(t){this._showScrollbar(),this._isHorizontalScrolling?this._container.setTranslateX(-1*t.newMin):this._container.setTranslateY(-1*t.newMin),this._updateFade(t.newMin)},Ee.prototype.getWidth=function(){return this._width},Ee.prototype.getHeight=function(){return this._height},Ee.prototype.scrollIntoView=function(t){if(this.hasScrollingContent()){var e,i=t.getDimensions(t.getParent()),n=this._container.getDimensions();if(this._isHorizontalScrolling){var r=-1*this._container.getTranslateX(),o=i.x-n.x,s=i.x+i.w-this._width+n.x;r<s?(this._container.setTranslateX(-1*s),this._scrollbar.setViewportRange(s+this._width,s),e=s):r>o&&(this._container.setTranslateX(-1*o),this._scrollbar.setViewportRange(o+this._width,o),e=o)}else{var a=-1*this._container.getTranslateY(),h=i.y-n.y,l=i.y+i.h-this._height+n.y;a<l?(this._container.setTranslateY(-1*l),this._scrollbar.setViewportRange(l,l+this._height),e=l):a>h&&(this._container.setTranslateY(-1*h),this._scrollbar.setViewportRange(h,h+this._height),e=h)}null!=e&&this._updateFade(e)}},Ee.prototype.hasScrollingContent=function(){return this._contentSize>this._getAvailSize()};const me=function(t,e,i,n,r,o,s,a){this.Init(t,e,i,n,r,o,s,a)};i.createSubclass(me,J),me.STATE_ENABLED=0,me.STATE_OVER=1,me.STATE_DOWN=2,me.STATE_DISABLED=3,me.NO_EVENT_LISTENERS=!0,me.prototype.Init=function(t,e,i,n,r,o,s,a){me.superclass.Init.call(this,t,null,o),this.setCallback(s,a),this._bDuringInit=!0,this.setUpState(e),this.setOverState(i),this.setDownState(n),r&&this.setDisabledState(r),this.setEnabled(!0),this.drawUpState(),this._tooltip=null,this._bToggleEnabled=!1,this._bToggled=!1,this._bDuringInit=!1},me.prototype.isEnabled=function(){return this._enabled},me.prototype.setEnabled=function(t){if(this._enabled!=t){this._enabled=t;var e=r.isTouchDevice(),i=e?L.TOUCHSTART:F.CLICK,n=e?{capture:!1,passive:!1}:{capture:!1};t?(this.addEvtListener(F.MOUSEOVER,this.OnMouseOver,!1,this),this.addEvtListener(F.MOUSEOUT,this.OnMouseOut,!1,this),this.addEvtListener(F.MOUSEDOWN,this.OnMouseDown,!1,this),this.addEvtListener(F.MOUSEUP,this.OnMouseUp,!1,this),this.addEvtListener(i,this.OnClick,n,this),this.setCursor(rt.getSelectingCursor())):(this.removeEvtListener(F.MOUSEOVER,this.OnMouseOver,!1,this),this.removeEvtListener(F.MOUSEOUT,this.OnMouseOut,!1,this),this.removeEvtListener(F.MOUSEDOWN,this.OnMouseDown,!1,this),this.removeEvtListener(F.MOUSEUP,this.OnMouseUp,!1,this),this.removeEvtListener(i,this.OnClick,n,this),this.setCursor(null)),this.initState()}},me.prototype.OnMouseOver=function(t){this._bToggled?this.drawOverDownState():this.drawOverState()},me.prototype.OnMouseOut=function(t){this._bToggled?this.drawDownState():this.drawUpState()},me.prototype.OnMouseDown=function(t){this.drawDownState()},me.prototype.OnMouseUp=function(t){this._bToggled?r.isTouchDevice()?this.drawDownState():this.drawOverDownState():r.isTouchDevice()?this.drawUpState():this.drawOverState()},me.prototype.OnClick=function(t){this._bToggleEnabled&&(this._bToggled=!this._bToggled,this._bToggled?r.isTouchDevice()?this.drawDownState():this.drawOverDownState():r.isTouchDevice()?this.drawUpState():this.drawOverState()),this._callback&&(this._callback.call(this._callbackObj,t,this),t.stopPropagation(),t.preventDefault())},me.prototype.drawUpState=function(){this._enableButton(this.upState,!0),this._enableButton(this.downState,!1),this._enableButton(this.overState,!1),this._enableButton(this.disabledState,!1),this._enableButton(this.overDownState,!1)},me.prototype.drawOverState=function(){this._enableButton(this.upState,!1),this._enableButton(this.downState,!1),this._enableButton(this.overState,!0),this._enableButton(this.disabledState,!1),this._enableButton(this.overDownState,!1)},me.prototype.drawDownState=function(){this._enableButton(this.upState,!1),this._enableButton(this.downState,!0),this._enableButton(this.overState,!1),this._enableButton(this.disabledState,!1),this._enableButton(this.overDownState,!1)},me.prototype.drawDisabledState=function(){this._enableButton(this.upState,!1),this._enableButton(this.overState,!1),this._enableButton(this.downState,!1),this._enableButton(this.disabledState,!0),this._enableButton(this.overDownState,!1)},me.prototype.drawOverDownState=function(){this.overDownState?(this._enableButton(this.upState,!1),this._enableButton(this.overState,!1),this._enableButton(this.downState,!1),this._enableButton(this.disabledState,!1),this._enableButton(this.overDownState,!0)):this.drawDownState()},me.prototype._enableButton=function(t,e){t&&t.setAlpha(e?1:0)},me.prototype._enableMouseEvents=function(t,e){t.setMouseEnabled&&t.setMouseEnabled(e);for(var i=t.firstChild;null!=i;)this._enableMouseEvents(i,e),i=i.nextSibling},me.prototype.setUpState=function(t){if(!this.upState||this.upState!=t){var e=!1;if(this.upState)e=this._isButtonEnabled(this.upState),this.removeChild(this.upState);else if(!this._bDuringInit){var i=!1,n=!1,r=!1;this.downState&&(i=this._isButtonEnabled(this.downState)),this.overState&&(n=this._isButtonEnabled(this.overState)),this.disabledState&&(r=this._isButtonEnabled(this.disabledState)),i||n||r||(e=!0)}t&&this.addChild(t),this.upState=t,this._enableButton(this.upState,e)}},me.prototype.setDownState=function(t){if(!this.downState||this.downState!=t){var e=!1;this.downState&&(e=this._isButtonEnabled(this.downState),this.removeChild(this.downState)),t&&this.addChild(t),this.downState=t,this._enableButton(this.downState,e)}},me.prototype.setOverState=function(t){if(!this.overState||this.overState!=t){var e=!1;this.overState&&(e=this._isButtonEnabled(this.overState),this.removeChild(this.overState)),t&&this.addChild(t),this.overState=t,this._enableButton(this.overState,e)}},me.prototype.setDisabledState=function(t){if(!this.disabledState||this.disabledState==t){var e=!1;this.disabledState&&(e=this._isButtonEnabled(this.disabledState),this.removeChild(this.disabledState)),t&&this.addChild(t),this.disabledState=t,this._enableButton(this.disabledState,e)}},me.prototype.setOverDownState=function(t){if(!this.overDownState||this.overDownState==t){var e=!1;this.overDownState&&(e=this._isButtonEnabled(this.overDownState),this.removeChild(this.overDownState)),t&&this.addChild(t),this.overDownState=t,this._enableButton(this.overDownState,e)}},me.prototype.setCallback=function(t,e){this._callback=t,this._callbackObj=e},me.prototype.setTooltip=function(t){this._tooltip=t,t&&(this.setAriaRole("button"),this.setAriaProperty("label",t))},me.prototype.getTooltip=function(){return this._tooltip},me.prototype.initState=function(){this.isEnabled()?this.drawUpState():this.drawDisabledState()},me.prototype.setToggleEnabled=function(t){this._bToggleEnabled=t},me.prototype.setToggled=function(t){this._bToggleEnabled&&(this._bToggled=t,this._bToggled?this.drawDownState():this.drawUpState())},me.prototype.isToggled=function(){return this._bToggled},me.prototype._isButtonEnabled=function(t){var e=!1;return t&&(e=t.getAlpha()>0),e},me.prototype.showKeyboardFocusEffect=function(){this._keyboardFocusEffect||(this._keyboardFocusEffect=this.CreateKeyboardFocusEffect()),this._keyboardFocusEffect.show(),this._isShowingKeyboardFocusEffect=!0,this.getCtx().setActiveElement(this)},me.prototype.hideKeyboardFocusEffect=function(){this._keyboardFocusEffect&&this._keyboardFocusEffect.hide(),this._isShowingKeyboardFocusEffect=!1},me.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},me.prototype.CreateKeyboardFocusEffect=function(){return new ie(this.getCtx(),this,this.getDimensions(),null,null,!0)},me.prototype.handleKeyboardEvent=function(t){var e=t.keyCode;e!=P.ENTER&&e!=P.SPACE||this._callback&&(this._callback.call(this._callbackObj,t,this),t.stopPropagation(),t.preventDefault())};const be=function(t,e,i,n,r,o,s){this.Init(t,e,i,n,r,o,s)};i.createSubclass(be,J),be.prototype.Init=function(t,e,i,n,r,o,s){be.superclass.Init.call(this,t,null,r),this.setCallback(o,s),this._chroming=e,n||(n=this._createDefaultBackground(i.size));var a=n.copyShape();a.setClassName("oj-dvt-button-background"),this.addChild(a),this.addChild(n);var h=at.createIcon(this.getCtx(),i);this.addChild(h),this._tooltip=null,this._bToggleEnabled=!1,this._bToggled=!1,this._bMouseOver=!1,this._bMouseDown=!1,this.setEnabled(!0)},be.prototype._createDefaultBackground=function(t){var e=b.roundedRectangle(-4,-4,t+8,t+8,4,4,4,4),i=new ce(this.getCtx(),e);return i.setPixelHinting(r.getDevicePixelRatio()>1),i},be.prototype.isEnabled=function(){return this._enabled},be.prototype.setEnabled=function(t){if(this._enabled!=t){this._enabled=t;var e=r.isTouchDevice(),i=e?L.TOUCHSTART:F.CLICK,n=e?{capture:!1,passive:!1}:{capture:!1};t?(this.addEvtListener(F.MOUSEOVER,this.OnMouseOver,!1,this),this.addEvtListener(F.MOUSEOUT,this.OnMouseOut,!1,this),this.addEvtListener(F.MOUSEDOWN,this.OnMouseDown,!1,this),this.addEvtListener(F.MOUSEUP,this.OnMouseUp,!1,this),this.addEvtListener(i,this.OnClick,n,this),this.setCursor(rt.getSelectingCursor())):(this.removeEvtListener(F.MOUSEOVER,this.OnMouseOver,!1,this),this.removeEvtListener(F.MOUSEOUT,this.OnMouseOut,!1,this),this.removeEvtListener(F.MOUSEDOWN,this.OnMouseDown,!1,this),this.removeEvtListener(F.MOUSEUP,this.OnMouseUp,!1,this),this.removeEvtListener(i,this.OnClick,n,this),this.setCursor(null),this._bMouseOver=!1,this._bMouseDown=!1),this._updateClasses()}},be.prototype.OnMouseOver=function(t){this._bMouseOver=!0,this._updateClasses()},be.prototype.OnMouseOut=function(t){this._bMouseOver=!1,this._updateClasses()},be.prototype.OnMouseDown=function(t){this._bMouseDown=!0,this._updateClasses()},be.prototype.OnMouseUp=function(t){this._bMouseDown=!1,this._updateClasses()},be.prototype.OnClick=function(t){this._bToggleEnabled&&this.setToggled(!this._bToggled),this._callback&&(this._callback.call(this._callbackObj,t,this),t.stopPropagation(),t.preventDefault())},be.prototype.setCallback=function(t,e){this._callback=t,this._callbackObj=e},be.prototype.setTooltip=function(t){this._tooltip=t,t&&(this.setAriaRole("button"),this.setAriaProperty("label",t))},be.prototype.getTooltip=function(){return this._tooltip},be.prototype.setToggleEnabled=function(t){this._bToggleEnabled=t,this._updateClasses()},be.prototype.setToggled=function(t){this._bToggleEnabled&&(this._bToggled=t,this._updateClasses())},be.prototype.isToggled=function(){return this._bToggled},be.prototype.showKeyboardFocusEffect=function(){this._keyboardFocusEffect||(this._keyboardFocusEffect=this.CreateKeyboardFocusEffect()),this._keyboardFocusEffect.show(),this._isShowingKeyboardFocusEffect=!0,this.getCtx().setActiveElement(this)},be.prototype.hideKeyboardFocusEffect=function(){this._keyboardFocusEffect&&this._keyboardFocusEffect.hide(),this._isShowingKeyboardFocusEffect=!1},be.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},be.prototype.CreateKeyboardFocusEffect=function(){return new ie(this.getCtx(),this,this.getDimensions(),null,null,!0)},be.prototype.handleKeyboardEvent=function(t){var e=t.keyCode;e!=P.ENTER&&e!=P.SPACE||this._callback&&(this._callback.call(this._callbackObj,t,this),t.stopPropagation(),t.preventDefault())},be.prototype._updateClasses=function(){this.getElem();var t=!1,e=!1,i=!1,n=this._bToggleEnabled&&this._bToggled,r=this._bToggleEnabled&&!this._bToggled;this._enabled?(e=this._bMouseOver,i=this._bMouseDown):t=!0,this.setClassName(`oj-dvt-button-${this._chroming}${n?" oj-selected":""}${r?" oj-unselected":""}${t?" oj-disabled":""}${e?" oj-hover":""}${i?" oj-active":""}`)};const Ce=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass(Ce,be),Ce._DEFAULT_RADIUS=15.5,Ce.prototype.Init=function(t,e,i,n,o){var s=Ce._DEFAULT_RADIUS,a=new he(t,s,s,s);Ce.superclass.Init.call(this,t,"outlined",{style:e,size:i,pos:{x:s,y:s}},a,null,o,n);var h=t.getStage();h.addEvtListener(H.FOCUS,this._onFocus,!0,this),h.addEvtListener(H.BLUR,this._onBlur,!0,this),r.isTouchDevice()||("ie"===r.browser||"edge"===r.browser?(h.addEvtListener("mouseenter",this._onMouseOver,!1,this),h.addEvtListener("mouseleave",this._onMouseOut,!1,this)):(h.addEvtListener(F.MOUSEOVER,this._onMouseOver,!1,this),h.addEvtListener(F.MOUSEOUT,this._onMouseOut,!1,this)))},Ce.prototype.show=function(){this.setAlpha(1)},Ce.prototype.hide=function(){this.setAlpha(0)},Ce.prototype._onFocus=function(t){this._isFocused=!0,this.show()},Ce.prototype._onBlur=function(t){this._isFocused=!1,this._isMouseOver||this.hide()},Ce.prototype._onMouseOver=function(t){this._mouseOutTimer&&this._mouseOutTimer.isRunning()&&this._mouseOutTimer.stop(),this._isMouseOver=!0,this.show()},Ce.prototype._onMouseOut=function(t){this._mouseOutTimer||(this._mouseOutTimer=new ut(this.getCtx(),10,this._onMouseOutTimerEnd,this,1)),this._mouseOutTimer.reset(),this._mouseOutTimer.start()},Ce.prototype._onMouseOutTimerEnd=function(){this._isMouseOver=!1,this._isFocused||this.hide()},Ce.prototype.OnMouseDown=function(t){Ce.superclass.OnMouseDown.call(this,t),t.stopPropagation()},Ce.prototype.OnMouseUp=function(t){Ce.superclass.OnMouseUp.call(this,t),t.stopPropagation()};const Ae=function(t,e,i,n){this.Init(t,e,i,n)};i.createSubclass(Ae,i),Ae.prototype.Init=function(t,e,i,n){this._tooltipManager=t,this._tooltipFunc=e,this._datatipColor=i,this._dataContext=n},Ae.prototype.getDatatip=function(t){return this._tooltipManager.getCustomTooltip(this._tooltipFunc,this._dataContext)},Ae.prototype.getDatatipColor=function(t){return this._datatipColor};const Oe=function(t){this.Init(t)};i.createSubclass(Oe,i),Oe.prototype.Init=function(t){this._comp=t},Oe.TOOLTIP_SUBID="tooltip",Oe.prototype.getSubIdForDomElement=function(t){var e=Oe._findDisplayable(t);return!e||e instanceof Array?t&&this.IsTooltipElement(t)?Oe.TOOLTIP_SUBID:null:this.GetSubIdForDomElement(e)},Oe.prototype.GetSubIdForDomElement=function(t){return null},Oe.prototype.getDomElementForSubId=function(t){return null},Oe._findDisplayable=function(t){for(;t;){if(t._obj)return t._obj;t=t.parentNode}return null},Oe.prototype.GetTooltipElement=function(t,e){if(t){var i=t.getCtx().getTooltipManager(e).getTooltipElem();return"hidden"==i.style.visibility?null:i}return null},Oe.prototype.IsTooltipElement=function(t){var e=t.getAttribute("id");return!(!e||0!=e.indexOf(it._TOOLTIP_DIV_ID))};const Ie=function(t){this.Init(t)};i.createSubclass(Ie,i),Ie.prototype.Init=function(t){this._eventManager=t},Ie.prototype.processKeyDown=function(t){var e=this._eventManager.getFocus();return e&&(this.isNavigationEvent(t)||this.isMultiSelectEvent(t))?(It.consumeEvent(t),e.getNextNavigable(t)):null},Ie.getNextNavigable=function(t,e,i,n,r){var o=null,s=0,a=0,h=e.keyCode;if(!t)return!i||i.length<1?null:i[0];for(var l,u=t.getKeyboardBoundingBox(r),c=0;c<i.length;c++){var _=i[c];t!==_&&(l=_.getKeyboardBoundingBox(r),(n||Ie._isInBounds(u,l,h))&&(a=Ie._computeDelta(u,l,h),((h==P.UP_ARROW||h==P.LEFT_ARROW)&&a<0&&(!o||a>s)||(h==P.DOWN_ARROW||h==P.RIGHT_ARROW)&&a>0&&(!o||a<s))&&(o=_,s=a)))}return o||t},Ie.prototype.getDefaultNavigable=function(t){if(!t||t.length<=0)return null;for(var e,i,n=t[0],o=n.getKeyboardBoundingBox(),s=1;s<t.length;s++)(((i=(e=t[s]).getKeyboardBoundingBox()).x==o.x&&i.y<o.y||i.x<o.x)&&!r.isRightToLeft(this._eventManager.getCtx())||(i.x+i.w==o.x+o.w&&i.y<o.y||i.x+i.w>o.x+o.w)&&r.isRightToLeft(this._eventManager.getCtx()))&&(o=(n=e).getKeyboardBoundingBox());return n},Ie.prototype.isNavigationEvent=function(t){switch(t.keyCode){case P.UP_ARROW:case P.DOWN_ARROW:case P.LEFT_ARROW:case P.RIGHT_ARROW:return!0}return!1},Ie.prototype.isSelectionEvent=function(t){return!1},Ie.prototype.isMultiSelectEvent=function(t){return!1},Ie._isInBounds=function(t,e,i){if(i==P.UP_ARROW||i==P.DOWN_ARROW){var n=t.x,r=n+t.w,o=e.x;return!(n>=o+e.w||r<=o)}if(i==P.LEFT_ARROW||i==P.RIGHT_ARROW){var s=t.y,a=s+t.h,h=e.y;return!(s>=h+e.h||a<=h)}},Ie._computeDelta=function(t,e,i){var n=0,r=t.getCenter().x,o=t.getCenter().y,s=e.getCenter().x,a=e.getCenter().y;return i==P.UP_ARROW||i==P.DOWN_ARROW?n=a-o:i!=P.LEFT_ARROW&&i!=P.RIGHT_ARROW||(n=s-r),n},Ie.getNextAdjacentNavigable=function(t,e,i){var n=e.keyCode;if(!i)return null;if(!t)return i[0];for(var r=t,o=Number.MAX_VALUE,s=!1,a=!1,h=0;h<i.length;h++){var l=i[h];if(l!==t){if(Ie._isValidDestination(l,t,n)){var u=Ie._calcInContact(l,t,n);if(!s||u){var c=Ie._calcDistanceAngleWeighted(l,t,n);(0!=c||a)&&(!s&&u||c<o&&(s&&u||!s))&&(o=c,r=l,s=u)}}}else a=!0}return r},Ie._calcInContact=function(t,e,i){var n=t.getKeyboardBoundingBox(),r=e.getKeyboardBoundingBox();switch(i){case P.UP_ARROW:return Ie._isVerticallyAligned(n,r)&&(r.y<=n.y+n.h||Ie._areEqualWithinTolerance(r.y,n.y+n.h));case P.DOWN_ARROW:return Ie._isVerticallyAligned(n,r)&&(n.y<=r.y+r.h||Ie._areEqualWithinTolerance(n.y,r.y+r.h));case P.RIGHT_ARROW:return Ie._isHorizontallyAligned(n,r)&&(n.x<=r.x+r.w||Ie._areEqualWithinTolerance(n.x,r.x+r.w));case P.LEFT_ARROW:return Ie._isHorizontallyAligned(n,r)&&(r.x<=n.x+n.w||Ie._areEqualWithinTolerance(r.x,n.x+n.w))}return!1},Ie._isVerticallyAligned=function(t,e){return t.x>=e.x&&t.x<=e.x+e.w||e.x>=t.x&&e.x<=t.x+t.w},Ie._isHorizontallyAligned=function(t,e){return t.y>=e.y&&t.y<=e.y+e.h||e.y>=t.y&&e.y<=t.y+t.h},Ie._calcDistanceAngleWeighted=function(t,e,i){var n=15/180*Math.PI,r=40/180*Math.PI,o=t.getKeyboardBoundingBox(),s=o.x+o.w/2,a=o.y+o.h/2,h=e.getKeyboardBoundingBox(),l=h.x+h.w/2,u=h.y+h.h/2,c=Math.abs(s-l),_=Math.abs(a-u),p=Math.atan2(_,c),d=Math.sqrt(c*c+_*_);return(p>n&&(i==P.RIGHT_ARROW||i==P.LEFT_ARROW)||p<S.HALF_PI-n&&(i==P.UP_ARROW||i==P.DOWN_ARROW))&&(p>r&&(i==P.RIGHT_ARROW||i==P.LEFT_ARROW)||p<S.HALF_PI-r&&(i==P.UP_ARROW||i==P.DOWN_ARROW)?d*=6:d*=2),d},Ie._isValidDestination=function(t,e,i){var n=t.getKeyboardBoundingBox(),r=e.getKeyboardBoundingBox();switch(i){case P.UP_ARROW:return n.y<r.y||Ie._areEqualWithinTolerance(n.y,r.y);case P.DOWN_ARROW:return n.y>r.y||Ie._areEqualWithinTolerance(n.y,r.y);case P.RIGHT_ARROW:return n.x>r.x||Ie._areEqualWithinTolerance(n.x,r.x);case P.LEFT_ARROW:return n.x<r.x||Ie._areEqualWithinTolerance(n.x,r.x)}return!0},Ie._areEqualWithinTolerance=function(t,e){return Math.abs(t-e)<=1e-7};const Ne=function(t,e,i,n,r,o,s,a,h){this.Init(t,e,i,n,r,o,s,a,h)};i.createSubclass(Ne,i),Ne.prototype.Init=function(t,e,i,n,r,o,s,a,h){this._context=t.getCtx(),this._container=t,this._bounds=e,this._fill=n,this._stroke=r,this._strokeWidth=1,this._allowHoriz=null==o||o,this._allowVert=null==s||s,this._horizBounds=a,this._vertBounds=h,this._glassPane=new lt(this._context,i.x,i.y,i.w,i.h),this._glassPane.setInvisibleFill(),this._marqueeOn=!1,this._marqueeDrawn=!1,this._resizeHoriz=!1,this._resizeVert=!1},Ne.prototype.processDragStart=function(t,e){if(!this._marqueeOn){if(this._origPt=this._container.stageToLocal(t),this._resizeHoriz=this._allowHoriz,this._resizeVert=this._allowVert,!this._bounds.containsPoint(this._origPt.x,this._origPt.y))if(this._vertBounds&&this._vertBounds.containsPoint(this._origPt.x,this._origPt.y))this._resizeHoriz=!1;else{if(!this._horizBounds||!this._horizBounds.containsPoint(this._origPt.x,this._origPt.y))return null;this._resizeVert=!1}return this._marqueeOn=!0,this._marquee=null,this._marqueeInnerArea=null,this._createMarqueeEvent("start",e)}return null},Ne.prototype.processDragMove=function(t,e){if(!this._marqueeOn)return null;this._marqueeDrawn||(this._container.addChild(this._glassPane),this._marquee=new lt(this._context,this._bounds.x,this._bounds.y,this._bounds.w,this._bounds.h),this._marqueeInnerArea=new lt(this._context,this._bounds.x,this._bounds.y,this._bounds.w,this._bounds.h),this._marquee.getElem().setAttribute("pointer-events","none"),this._marqueeInnerArea.getElem().setAttribute("pointer-events","none"),this._resizeHoriz&&(this._marquee.setX(this._origPt.x),this._marquee.setWidth(0),this._marqueeInnerArea.setX(this._origPt.x),this._marqueeInnerArea.setWidth(0)),this._resizeVert&&(this._marquee.setY(this._origPt.y),this._marquee.setHeight(0),this._marqueeInnerArea.setY(this._origPt.y),this._marqueeInnerArea.setHeight(0)),this._marquee.setClassName("oj-dvt-marquee"),this._marquee.setStyle({stroke:this._stroke.getColor(),fill:this._fill.getColor()}),this._marquee.setPixelHinting(!0),this._glassPane.addChild(this._marquee),this._marqueeInnerArea.setClassName("oj-dvt-marquee-inner-area"),this._marqueeInnerArea.setPixelHinting(!0),this._glassPane.addChild(this._marqueeInnerArea),this._marqueeDrawn=!0);var i=this._container.stageToLocal(t);if(i.x=Math.max(i.x,this._bounds.x),i.x=Math.min(i.x,this._bounds.x+this._bounds.w),i.y=Math.max(i.y,this._bounds.y),i.y=Math.min(i.y,this._bounds.y+this._bounds.h),this._resizeHoriz){var n=Math.abs(i.x-this._origPt.x),r=i.x<this._origPt.x?i.x:this._origPt.x;this._marquee.setWidth(n),this._marquee.setX(r);var o=n-2*this._strokeWidth;this._marqueeInnerArea.setWidth(Math.max(0,o)),this._marqueeInnerArea.setX(r+this._strokeWidth)}if(this._resizeVert){var s=Math.abs(i.y-this._origPt.y),a=i.y<this._origPt.y?i.y:this._origPt.y;this._marquee.setHeight(s),this._marquee.setY(a);var h=s-2*this._strokeWidth;this._marqueeInnerArea.setHeight(Math.max(0,h)),this._marqueeInnerArea.setY(a+this._strokeWidth)}return this._createMarqueeEvent("move",e)},Ne.prototype.processDragEnd=function(t,e){return this._marqueeOn&&(this._marqueeOn=!1,this._marqueeDrawn)?(this._glassPane.removeChild(this._marquee),this._glassPane.removeChild(this._marqueeInnerArea),this._container.removeChild(this._glassPane),this._marqueeDrawn=!1,this._createMarqueeEvent("end",e)):null},Ne.prototype.cancelMarquee=function(){return!(!this._marqueeOn||(this._marqueeOn=!1,!this._marqueeDrawn))&&(this._glassPane.removeChild(this._marquee),this._glassPane.removeChild(this._marqueeInnerArea),this._container.removeChild(this._glassPane),this._marqueeDrawn=!1,!0)},Ne.prototype._createMarqueeEvent=function(t,e){var i=null,n=null,r=null,o=null;return this._resizeHoriz&&(i=this._marquee?this._marquee.getX():this._origPt.x,r=this._marquee?this._marquee.getWidth():0),this._resizeVert&&(n=this._marquee?this._marquee.getY():this._origPt.y,o=this._marquee?this._marquee.getHeight():0),new yt.newMarqueeEvent(t,i,n,r,o,e)},Ne.prototype.getCursor=function(t){var e=this._container.stageToLocal(t),i=this._bounds.containsPoint(e.x,e.y),n=this._vertBounds&&this._vertBounds.containsPoint(e.x,e.y),r=this._horizBounds&&this._horizBounds.containsPoint(e.x,e.y);return i||n||r?"crosshair":"inherit"},Ne.prototype.getGlassPane=function(){return this._glassPane};const Re=function(t,e,i,n){this.Init(t,e,i,n)};i.createSubclass(Re,i),Re.prototype.Init=function(t,e,i,n){this._context=t.getCtx(),this._container=t,this._bounds=e,this._zoomRate=n,this._glassPane=new lt(this._context,i.x,i.y,i.w,i.h),this._glassPane.setInvisibleFill(),this._panOn=!1,this._glassPaneDrawn=!1,this._pinchOn=!1},Re.prototype.processDragStart=function(t){return this._panOn?null:(this._origPt=this._container.stageToLocal(t),this._lastPt=this._origPt,this._bounds.containsPoint(this._origPt.x,this._origPt.y)?(this._panOn=!0,yt.newPanZoomEvent("panStart",0,0,0,0,0,0,0,0)):null)},Re.prototype.processDragMove=function(t){if(!this._panOn)return null;this._glassPaneDrawn||(this._container.addChild(this._glassPane),this._glassPaneDrawn=!0);var e=this._container.stageToLocal(t),i=e.x-this._lastPt.x,n=e.y-this._lastPt.y,r=e.x-this._origPt.x,o=e.y-this._origPt.y;return this._lastPt=e,yt.newPanZoomEvent("panMove",-i,-i,-n,-n,-r,-r,-o,-o)},Re.prototype.processDragEnd=function(t){if(this._panOn&&(this._panOn=!1,this._glassPaneDrawn)){this._container.removeChild(this._glassPane),this._glassPaneDrawn=!1;var e=t?this._container.stageToLocal(t):this._lastPt,i=e.x-this._lastPt.x,n=e.y-this._lastPt.y,r=e.x-this._origPt.x,o=e.y-this._origPt.y;return this._lastPt=null,yt.newPanZoomEvent("panEnd",-i,-i,-n,-n,-r,-r,-o,-o)}return null},Re.prototype.processMouseWheel=function(t,e){var i=this._container.stageToLocal(t);if(!this._bounds.containsPoint(i.x,i.y))return null;var n=(e*=this._zoomRate)*(i.x-this._bounds.x),r=-e*(this._bounds.x+this._bounds.w-i.x),o=e*(i.y-this._bounds.y),s=-e*(this._bounds.y+this._bounds.h-i.y);return yt.newPanZoomEvent("zoom",n,r,o,s,n,r,o,s)},Re.prototype.processPinchStart=function(t,e){return this._pinchOn?null:(this._origPt1=this._container.stageToLocal(t),this._origPt2=this._container.stageToLocal(e),this._lastPt1=this._origPt1,this._lastPt2=this._origPt2,this._bounds.containsPoint(this._origPt1.x,this._origPt1.y)&&this._bounds.containsPoint(this._origPt2.x,this._origPt2.y)?(this._pinchOn=!0,yt.newPanZoomEvent("pinchStart",0,0,0,0,0,0,0,0)):null)},Re.prototype.processPinchMove=function(t,e){if(!this._pinchOn)return null;var i=this._container.stageToLocal(t),n=this._container.stageToLocal(e),r=this._computePinchDeltas(i,n,this._lastPt1,this._lastPt2),o=this._computePinchDeltas(i,n,this._origPt1,this._origPt2);return this._lastPt1=i,this._lastPt2=n,yt.newPanZoomEvent("pinchMove",r.dxMin,r.dxMax,r.dyMin,r.dyMax,o.dxMin,o.dxMax,o.dyMin,o.dyMax)},Re.prototype.processPinchEnd=function(){if(this._pinchOn){this._pinchOn=!1;var t=this._computePinchDeltas(this._lastPt1,this._lastPt2,this._origPt1,this._origPt2);return this._lastPt1=null,this._lastPt2=null,yt.newPanZoomEvent("pinchEnd",0,0,0,0,t.dxMin,t.dxMax,t.dyMin,t.dyMax)}return null},Re.prototype._computePinchDeltas=function(t,e,i,n){var r=Math.abs(t.x-e.x),o=Math.abs(t.y-e.y),s=Math.abs(i.x-n.x),a=Math.abs(i.y-n.y),h=r>o/2?s/r:1,l=o>r/2?a/o:1,u=(t.x+e.x)/2,c=(t.y+e.y)/2,_=u-(i.x+n.x)/2,p=c-(i.y+n.y)/2,d=(1-h)*(u-this._bounds.x),g=(h-1)*(this._bounds.x+this._bounds.w-u),f=(1-l)*(c-this._bounds.y),y=(l-1)*(this._bounds.y+this._bounds.h-c);return{dxMin:d-=_,dxMax:g-=_,dyMin:f-=p,dyMax:y-=p}},Re.prototype.zoomBy=function(t){var e=(1/t-1)/2,i=-e*this._bounds.w,n=e*this._bounds.w,r=-e*this._bounds.h,o=e*this._bounds.h;return yt.newPanZoomEvent("zoom",i,n,r,o,i,n,r,o)},Re.prototype.panBy=function(t,e){var i=t*this._bounds.w*(r.isRightToLeft(this._context)?-1:1),n=e*this._bounds.h;return yt.newPanZoomEvent("panEnd",i,i,n,n,i,i,n,n)},Re.prototype.getCursor=function(t){return null==t||this.isWithinBounds(t)?this._panOn?u.getGrabbingCursor():u.getGrabCursor():"inherit"},Re.prototype.isWithinBounds=function(t){var e=this._container.stageToLocal(t);return this._bounds.containsPoint(e.x,e.y)},t.Agent=r,t.AnimFadeIn=Yt,t.AnimFadeOut=jt,t.AnimMoveBy=Wt,t.AnimMoveTo=$t,t.AnimPopIn=te,t.AnimScaleFadeIn=Vt,t.AnimScaleTo=Jt,t.Animator=Ft,t.AriaUtils=O,t.Array2D=ne,t.ArrayUtils=d,t.Automation=Oe,t.BackgroundMultilineText=ve,t.BackgroundOutputText=ye,t.BaseAnimation=Ut,t.BaseComponent=Ct,t.BaseComponentCache=St,t.BaseComponentDefaults=Se,t.BaseEvent=M,t.BlackBoxAnimationHandler=qt,t.Button=me,t.CSSGradient=U,t.CSSStyle=j,t.Cache=v,t.CategoryRolloverHandler=Ot,t.Circle=he,t.ClipPath=p,t.ColorUtils=T,t.CombinedAnimMoveBy=zt,t.ComponentTouchEvent=dt,t.Container=J,t.Context=Mt,t.CustomAnimation=Zt,t.CustomDatatipPeer=Ae,t.DataAnimationHandler=Qt,t.Dimension=h,t.Displayable=Q,t.DisplayableUtils=q,t.DomEventFactory=k,t.DragAndDropUtils=s,t.DragSource=a,t.Easing=Lt,t.EventFactory=yt,t.EventManager=It,t.GradientFill=g,t.GradientParser=V,t.HtmlKeyboardListenerUtils=G,t.HtmlTooltipManager=it,t.IconButton=be,t.Image=le,t.ImageLoader=se,t.ImageMarker=pe,t.JsonUtils=Et,t.KeyboardEvent=P,t.KeyboardFocusEffect=ie,t.KeyboardHandler=Ie,t.LayoutUtils=re,t.Line=ue,t.LinearGradientFill=ee,t.Map2D=vt,t.MarqueeHandler=Ne,t.Mask=Dt,t.Math=S,t.Matrix=l,t.MouseEvent=F,t.MultilineText=mt,t.Obj=i,t.OutputText=at,t.PanZoomHandler=Re,t.ParallelPlayable=Gt,t.Path=ce,t.PathUtils=b,t.PatternFill=y,t.PixelMap=oe,t.Playable=kt,t.Point=n,t.Polygon=ge,t.PolygonUtils=ae,t.Polyline=fe,t.Rect=lt,t.Rectangle=m,t.ResourceUtils=Tt,t.SelectionEffectUtils=rt,t.SelectionHandler=At,t.SequentialPlayable=Bt,t.Shadow=N,t.Shape=ot,t.SimpleMarker=_e,t.SimpleObjPeer=bt,t.SimpleScrollableContainer=Ee,t.SimpleScrollbar=Te,t.SolidFill=K,t.Stroke=z,t.SvgDocumentUtils=gt,t.SvgShapeUtils=A,t.TextUtils=st,t.Timer=ut,t.ToolkitUtils=u,t.Touch=w,t.TouchEvent=L,t.TouchManager=ft,t.TransientButton=Ce,t.Use=xt,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ojdvt-toolkit.js.map