/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["touchr","ojs/ojdatasource-common","ojs/ojdatacollection-utils","ojs/ojinputnumber","ojs/ojmenu","ojs/ojmenuselectmany","ojs/ojdialog","ojs/ojbutton","ojs/ojcore-base","ojs/ojcomponentcore","ojs/ojcontext","ojs/ojdatacollection-common","ojs/ojdomutils","ojs/ojconfig","ojs/ojcustomelement-utils","ojs/ojkeyboardfocus-utils","jquery","ojs/ojlogger","ojs/ojthemeutils"],function(e,t,i,s,n,o,r,l,a,h,d,c,m,u,_,p,g,f,C){"use strict";var y;a=a&&Object.prototype.hasOwnProperty.call(a,"default")?a.default:a,d=d&&Object.prototype.hasOwnProperty.call(d,"default")?d.default:d,g=g&&Object.prototype.hasOwnProperty.call(g,"default")?g.default:g,(y={properties:{bandingInterval:{type:"object",properties:{column:{type:"number",value:0},row:{type:"number",value:0}}},cell:{type:"object",properties:{className:{type:"function|string"},renderer:{type:"function"},style:{type:"function|string"}}},currentCell:{type:"object",writeback:!0},data:{type:"DataGridProvider",extension:{webelement:{exceptionStatus:[{type:"deprecated",since:"11.0.0",description:"Data sets from a DataProvider cannot be sent to WebDriverJS; use ViewModels or page variables instead."}]}}},dataTransferOptions:{type:"object",properties:{copy:{type:"string",enumValues:["disable","enable"],value:"disable"},cut:{type:"string",enumValues:["disable","enable"],value:"disable"},fill:{type:"string",enumValues:["disable","enable"],value:"disable"},paste:{type:"string",enumValues:["disable","enable"],value:"disable"}}},dnd:{type:"object",properties:{reorder:{type:"object",properties:{row:{type:"string",enumValues:["disable","enable"],value:"disable"}}}}},editMode:{type:"string",writeback:!0,enumValues:["cellEdit","cellNavigation","none"],value:"none"},gridlines:{type:"object",properties:{horizontal:{type:"string",enumValues:["hidden","visible"],value:"visible"},vertical:{type:"string",enumValues:["hidden","visible"],value:"visible"}}},header:{type:"object",properties:{column:{type:"object",properties:{className:{type:"function|string"},label:{type:"object",properties:{className:{type:"function|string"},renderer:{type:"function"},style:{type:"function|string"}}},renderer:{type:"function"},resizable:{type:"object",properties:{height:{type:"string",enumValues:["disable","enable"],value:"disable"},width:{type:"string|function",enumValues:["disable","enable"],value:"disable"}}},sortable:{type:"function|string",enumValues:["auto","disable","enable"],value:"auto"},style:{type:"function|string"}}},columnEnd:{type:"object",properties:{className:{type:"function|string"},label:{type:"object",properties:{className:{type:"function|string"},renderer:{type:"function"},style:{type:"function|string"}}},renderer:{type:"function"},resizable:{type:"object",properties:{height:{type:"string",enumValues:["disable","enable"],value:"disable"},width:{type:"string|function",enumValues:["disable","enable"],value:"disable"}}},style:{type:"function|string"}}},row:{type:"object",properties:{className:{type:"function|string"},label:{type:"object",properties:{className:{type:"function|string"},renderer:{type:"function"},style:{type:"function|string"}}},renderer:{type:"function"},resizable:{type:"object",properties:{height:{type:"string|function",enumValues:["disable","enable"],value:"disable"},width:{type:"string",enumValues:["disable","enable"],value:"disable"}}},sortable:{type:"function|string",enumValues:["auto","disable","enable"],value:"auto"},style:{type:"function|string"}}},rowEnd:{type:"object",properties:{className:{type:"function|string"},label:{type:"object",properties:{className:{type:"function|string"},renderer:{type:"function"},style:{type:"function|string"}}},renderer:{type:"function"},resizable:{type:"object",properties:{height:{type:"string|function",enumValues:["disable","enable"],value:"disable"},width:{type:"string",enumValues:["disable","enable"],value:"disable"}}},style:{type:"function|string"}}}}},scrollPolicy:{type:"string",enumValues:["auto","loadMoreOnScroll","scroll"],value:"auto"},scrollPolicyOptions:{type:"object",properties:{maxColumnCount:{type:"number",value:500},maxRowCount:{type:"number",value:500}}},scrollPosition:{type:"object",writeback:!0,value:{x:0,y:0},properties:{columnIndex:{type:"number"},columnKey:{type:"any"},offsetX:{type:"number"},offsetY:{type:"number"},rowIndex:{type:"number"},rowKey:{type:"any"},x:{type:"number"},y:{type:"number"}}},scrollToKey:{type:"string",enumValues:["always","auto","capability","never"],value:"auto"},selection:{type:"Array<Object>",writeback:!0,value:[]},selectionMode:{type:"object",properties:{cell:{type:"string",enumValues:["multiple","none","single"],value:"none"},row:{type:"string",enumValues:["multiple","none","single"],value:"none"}}},translations:{type:"object",value:{},properties:{accessibleActionableMode:{type:"string"},accessibleCollapsed:{type:"string"},accessibleColumnContext:{type:"string"},accessibleColumnEndHeaderContext:{type:"string"},accessibleColumnEndHeaderLabelContext:{type:"string"},accessibleColumnHeaderContext:{type:"string"},accessibleColumnHeaderLabelContext:{type:"string"},accessibleColumnSelected:{type:"string"},accessibleColumnSpanContext:{type:"string"},accessibleContainsControls:{type:"string"},accessibleExpanded:{type:"string"},accessibleFirstColumn:{type:"string"},accessibleFirstRow:{type:"string"},accessibleLastColumn:{type:"string"},accessibleLastRow:{type:"string"},accessibleLevelContext:{type:"string"},accessibleMultiCellSelected:{type:"string"},accessibleNavigationMode:{type:"string"},accessibleRangeSelectModeOff:{type:"string"},accessibleRangeSelectModeOn:{type:"string"},accessibleRowCollapsed:{type:"string"},accessibleRowContext:{type:"string"},accessibleRowEndHeaderContext:{type:"string"},accessibleRowEndHeaderLabelContext:{type:"string"},accessibleRowExpanded:{type:"string"},accessibleRowHeaderContext:{type:"string"},accessibleRowHeaderLabelContext:{type:"string"},accessibleRowSelected:{type:"string"},accessibleRowSpanContext:{type:"string"},accessibleSelectionAffordanceBottom:{type:"string"},accessibleSelectionAffordanceTop:{type:"string"},accessibleSortAscending:{type:"string"},accessibleSortDescending:{type:"string"},accessibleStateSelected:{type:"string"},accessibleSummaryEstimate:{type:"string"},accessibleSummaryExact:{type:"string"},accessibleSummaryExpanded:{type:"string"},collapsedText:{type:"string"},columnWidth:{type:"string"},expandedText:{type:"string"},labelCopyCells:{type:"string"},labelCut:{type:"string"},labelCutCells:{type:"string"},labelDisableNonContiguous:{type:"string"},labelEnableNonContiguous:{type:"string"},labelFillCells:{type:"string"},labelPaste:{type:"string"},labelPasteCells:{type:"string"},labelResize:{type:"string"},labelResizeColumn:{type:"string"},labelResizeDialogApply:{type:"string"},labelResizeDialogCancel:{type:"string"},labelResizeDialogSubmit:{type:"string"},labelResizeFitToContent:{type:"string"},labelResizeHeight:{type:"string"},labelResizeRow:{type:"string"},labelResizeWidth:{type:"string"},labelSelectMultiple:{type:"string"},labelSortCol:{type:"string"},labelSortColAsc:{type:"string"},labelSortColDsc:{type:"string"},labelSortRow:{type:"string"},labelSortRowAsc:{type:"string"},labelSortRowDsc:{type:"string"},msgFetchingData:{type:"string"},msgNoData:{type:"string"},resizeColumnDialog:{type:"string"},resizeRowDialog:{type:"string"},rowHeight:{type:"string"}}}},methods:{getContextByNode:{},getProperty:{},refresh:{},setProperties:{},setProperty:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojBeforeCurrentCell:{},ojBeforeEdit:{},ojBeforeEditEnd:{},ojCollapseRequest:{},ojCopyRequest:{},ojCutRequest:{},ojExpandRequest:{},ojFillRequest:{},ojPasteRequest:{},ojResize:{},ojScroll:{},ojSort:{},ojSortRequest:{}},extension:{}}).extension._WIDGET_NAME="ojDataGrid",a.CustomElementBridge.register("oj-data-grid",{metadata:y});const v=function(e,t,i,s){this.rtlMode=e,this.translationFunction=t,this.defaultOptions=i,this.widgetName=s,this.styles={},this.styles.datagrid="oj-datagrid",this.styles.cell="oj-datagrid-cell",this.styles.banded="oj-datagrid-banded",this.styles.row="oj-datagrid-row",this.styles.databody="oj-datagrid-databody",this.styles.topcorner="oj-datagrid-top-corner",this.styles.bottomcorner="oj-datagrid-bottom-corner",this.styles.rowheaderspacer="oj-datagrid-row-header-spacer",this.styles.colheaderspacer="oj-datagrid-column-header-spacer",this.styles.status="oj-datagrid-status",this.styles.loadingicon="oj-icon oj-datagrid-loading-icon",this.styles.emptytext="oj-datagrid-empty-text",this.styles.header="oj-datagrid-header",this.styles.endheader="oj-datagrid-end-header",this.styles.groupingcontainer="oj-datagrid-header-grouping",this.styles.headercell="oj-datagrid-header-cell",this.styles.rowheader="oj-datagrid-row-header",this.styles.colheader="oj-datagrid-column-header",this.styles.colheadercell="oj-datagrid-column-header-cell",this.styles.rowheadercell="oj-datagrid-row-header-cell",this.styles.endheadercell="oj-datagrid-end-header-cell",this.styles.rowendheader="oj-datagrid-row-end-header",this.styles.colendheader="oj-datagrid-column-end-header",this.styles.colendheadercell="oj-datagrid-column-end-header-cell",this.styles.rowendheadercell="oj-datagrid-row-end-header-cell",this.styles.headerlabel="oj-datagrid-header-label",this.styles.rowheaderlabel="oj-datagrid-row-header-label",this.styles.columnheaderlabel="oj-datagrid-column-header-label",this.styles.rowendheaderlabel="oj-datagrid-row-end-header-label",this.styles.columnendheaderlabel="oj-datagrid-column-end-header-label",this.styles["scroller-mobile"]="oj-datagrid-scroller-touch",this.styles.scroller="oj-datagrid-scroller",this.styles.scrollers="oj-datagrid-scrollers",this.styles.scrollbarForce="oj-scrollbar-force",this.styles.focus="oj-focus",this.styles.hover="oj-hover",this.styles.active="oj-active",this.styles.selected="oj-selected",this.styles.topSelected="oj-datagrid-selected-top",this.styles.bottomSelected="oj-datagrid-selected-bottom",this.styles.startSelected="oj-datagrid-selected-start",this.styles.endSelected="oj-datagrid-selected-end",this.styles.topEdit="oj-datagrid-cell-edit-top",this.styles.bottomEdit="oj-datagrid-cell-edit-bottom",this.styles.startEdit="oj-datagrid-cell-edit-start",this.styles.endEdit="oj-datagrid-cell-edit-end",this.styles.topFloodfill="oj-datagrid-floodfill-top",this.styles.bottomFloodfill="oj-datagrid-floodfill-bottom",this.styles.startFloodfill="oj-datagrid-floodfill-start",this.styles.endFloodfill="oj-datagrid-floodfill-end",this.styles.topResized="oj-datagrid-resized-top",this.styles.bottomResized="oj-datagrid-resized-bottom",this.styles.endResized="oj-datagrid-resized-end",this.styles.startResized="oj-datagrid-resized-start",this.styles.disabled="oj-disabled",this.styles.enabled="oj-enabled",this.styles.default="oj-default",this.styles.sortIcon="oj-datagrid-sort-icon",this.styles.sortascending="oj-datagrid-sort-ascending-icon",this.styles.sortdescending="oj-datagrid-sort-descending-icon",this.styles.sortdefault="oj-datagrid-sort-default-icon",this.styles.icon="oj-component-icon",this.styles.clickableicon="oj-clickable-icon-nocontext",this.styles.info="oj-helper-hidden-accessible",this.styles.rowexpander="oj-rowexpander",this.styles.cut="oj-datagrid-cut",this.styles.selectaffordance="oj-datagrid-touch-selection-affordance",this.styles.selectaffordancetopcornerbounded="oj-datagrid-touch-selection-affordance-top-corner-bounded",this.styles.selectaffordancebottomcornerbounded="oj-datagrid-touch-selection-affordance-bottom-corner-bounded",this.styles.selectaffordancetoprow="oj-datagrid-touch-selection-affordance-top-row",this.styles.selectaffordancebottomrow="oj-datagrid-touch-selection-affordance-bottom-row",this.styles.selectaffordancetopcolumn="oj-datagrid-touch-selection-affordance-top-column",this.styles.selectaffordancebottomcolumn="oj-datagrid-touch-selection-affordance-bottom-column",this.styles.floodfillaffordance="oj-datagrid-floodfill-affordance",this.styles.toucharea="oj-datagrid-touch-area",this.styles.readOnly="oj-read-only",this.styles.editable="oj-datagrid-editable",this.styles.cellEdit="oj-datagrid-cell-edit",this.styles.draggable="oj-draggable",this.styles.drag="oj-drag",this.styles.drop="oj-drop",this.styles.activedrop="oj-active-drop",this.styles.validdrop="oj-valid-drop",this.styles.invaliddrop="oj-invalid-drop",this.styles.formcontrol="oj-form-control-inherit",this.styles.borderHorizontalNone="oj-datagrid-border-horizontal-none",this.styles.borderVerticalNone="oj-datagrid-border-vertical-none",this.styles.borderHorizontalSmall="oj-datagrid-small-content-border-horizontal",this.styles.borderVerticalSmall="oj-datagrid-small-content-border-vertical",this.styles.offsetOutline="oj-datagrid-focus-offset",this.styles.depth="oj-datagrid-depth-",this.styles.popupHeader="oj-datagrid-popup-header",this.styles.popupContent="oj-datagrid-popup-content",this.styles.popupFooter="oj-datagrid-popup-footer",this.styles.dialogTitle="oj-dialog-title",this.styles.resizeDialog="oj-datagrid-resize-dialog",this.styles.headerAllSelected="oj-selected",this.styles.headerPartialSelected="oj-partial-selected",this.styles.disclosureContainer="oj-datagrid-disclosure-icon-container",this.styles.disclosureIcon="oj-datagrid-disclosure-icon",this.styles.expanded="oj-datagrid-expanded-icon",this.styles.collapsed="oj-datagrid-collapsed-icon",this.styles.spacer="oj-datagrid-tree-spacer",this.styles.hierarchicalTree="oj-datagrid-hierarchical-tree",this.styles.hierarchicalGroup="oj-datagrid-hierarchical-group",this.styles.iconContainer="oj-datagrid-icon-container",this.commands={},this.commands.sortCol="oj-datagrid-sortCol",this.commands.sortColAsc="oj-datagrid-sortColAsc",this.commands.sortColDsc="oj-datagrid-sortColDsc",this.commands.sortRow="oj-datagrid-sortRow",this.commands.sortRowAsc="oj-datagrid-sortRowAsc",this.commands.sortRowDsc="oj-datagrid-sortRowDsc",this.commands.resize="oj-datagrid-resize",this.commands.resizeWidth="oj-datagrid-resizeWidth",this.commands.resizeHeight="oj-datagrid-resizeHeight",this.commands.resizeFitToContent="oj-datagrid-resizeFitToContent",this.commands.cut="oj-datagrid-cut",this.commands.paste="oj-datagrid-paste",this.commands.cutCells="oj-datagrid-cutCells",this.commands.copyCells="oj-datagrid-copyCells",this.commands.pasteCells="oj-datagrid-pasteCells",this.commands.autoFill="oj-datagrid-fillCells",this.commands.discontiguousSelection="oj-datagrid-discontiguousSelection",this.attributes={},this.attributes.busyContext=d._OJ_CONTEXT_ATTRIBUTE,this.attributes.context="data-oj-cellContext",this.attributes.resizable="data-oj-resizable",this.attributes.sortable="data-oj-sortable",this.attributes.sortDir="data-oj-sortdir",this.attributes.expander="data-oj-expander",this.attributes.expanderIndex="data-oj-expander-index",this.attributes.container=h._OJ_CONTAINER_ATTR,this.attributes.extent="data-oj-extent",this.attributes.start="data-oj-start",this.attributes.depth="data-oj-depth",this.attributes.level="data-oj-level",this.attributes.metadata="data-oj-metaData"};a._registerLegacyNamespaceProp("DataGridResources",v),v.prototype.setRTLMode=function(e){this.rtlMode=e},v.prototype.isRTLMode=function(){return"rtl"===this.rtlMode},v.prototype.getTranslatedText=function(e,t){return this.translationFunction(e,t)},v.prototype.getDefaultOption=function(e){return this.defaultOptions[e]},v.prototype.getMappedStyle=function(e){return null!=e?this.styles[e]:null},v.prototype.getMappedCommand=function(e){return null!=e?this.commands[e]:null},v.prototype.getMappedAttribute=function(e){return null!=e?this.attributes[e]:null};const E=function(e){this.dataprovider=e,this.pendingHeaderCallback={},e.options&&e.options.implicitSort&&(this.currentSortCriteria=e.options.implicitSort),this.sortUpdated=!1;var t=this.dataprovider.getCapability("fetchByOffset");this.fetchByOffset=null!=t&&"randomAccess"===t.implementation,this._registerEventListeners(),E.superclass.constructor.call(this)};function S(e,t,i,s){this.indexes=e,this.data=i,this.metadata=t,this.columns=s}function w(e,t,i){this.response=e,this.results=e.results,this.cellRanges=t,this.columns=i,this._setBounds(e,t,i)}function H(e,t,i,s){this.start=e,this.end=t,this.headers=i,this.sortCriteria=s}a.Object.createSubclass(E,a.DataGridDataSource,"DataProviderDataGridDataSource"),E.prototype._registerEventListeners=function(){this._mutationListener=this._handlDataProviderMutationEvent.bind(this),this._refreshListener=this._handlDataProviderRefreshEvent.bind(this),this.dataprovider.addEventListener("mutate",this._mutationListener),this.dataprovider.addEventListener("refresh",this._refreshListener)},E.prototype._handlDataProviderMutationEvent=function(e){var t,i=e.detail.add;if(null!=i){var s={indexes:[],keys:[]},n=[],o=[],r=[];for(t=0;t<i.data.length;t++)s.source=this,s.operation="insert",s.keys.push({row:i.metadata[t].key,column:null}),s.indexes.push({row:i.indexes[t],column:-1}),r.push(i.indexes[t]),n.push(i.data[t]),o.push(i.metadata[t]),t!==i.data.length-1&&i.indexes[t+1]===i.indexes[t]+1||(s.result=new S(r,o,n,this.columns),this.handleEvent("change",s),(s={}).indexes=[],s.keys=[],n=[],o=[],r=[])}var l=e.detail.remove;if(null!=l){var a={source:this,operation:"delete",keys:[],indexes:[]};for(t=0;t<l.data.length;t++)a.keys.push({row:l.metadata[t].key,column:null}),a.indexes.push({row:l.indexes[t],column:-1});this.handleEvent("change",a)}var h=e.detail.update;if(null!=h)for(t=0;t<h.data.length;t++){var d={source:this,operation:"update",keys:{row:h.metadata[t].key,column:null},indexes:{row:h.indexes[t],column:-1}};d.result=new S([h.indexes[t]],[h.metadata[t]],[h.data[t]],this.columns),this.handleEvent("change",d)}},S.prototype.getData=function(e){var t=this,i={};return Object.defineProperty(i,"data",{enumerable:!0,get:function(){return t.data[e.row-t.getStart("row")][t.columns[e.column]]},set:function(i){t.data[e.row-t.getStart("row")][t.columns[e.column]]=i}}),i},S.prototype.getMetadata=function(e){var t=this.metadata[e.row-this.getStart("row")];return t.keys={row:t.key,column:this.columns[e.column]},t},S.prototype.getStart=function(e){return"row"===e?this.indexes[0]:0},S.prototype.getCount=function(e){return"row"===e?this.data.length:"column"===e?this.columns.length:0},S.prototype.getExtent=function(){return{row:{extent:1,more:{before:!1,after:!1}},column:{extent:1,more:{before:!1,after:!1}}}},E.prototype._handlDataProviderRefreshEvent=function(){this._asyncIterator=null,this.handleEvent("change",{operation:"refresh"})},E.prototype.fetchHeaders=function(e,t,i){if(null!=t){var s=e.axis,n={headerRange:e,callbacks:t,callbackObjects:i};this.pendingHeaderCallback[s]=n}},E.prototype._processPendingHeaderCallbacks=function(e){var t=this.pendingHeaderCallback[e];if(null!=t){var i=t.headerRange,s=t.callbacks,n=t.callbackObjects;this._handleHeaderFetchSuccess(i,s,n),this.pendingHeaderCallback[e]=null}},E.prototype._handleHeaderFetchSuccess=function(e,t,i){var s,n=e.axis,o=e.start,r=e.count;"column"===n&&null!=this.columns?s=new H(o,Math.min(this.columns.length,o+r),this.columns,this.currentSortCriteria):s=null;null!=t&&t.success&&t.success.call(i.success,s,e,null)},w.prototype._setBounds=function(e,t,i){for(var s=0;s<t.length;s+=1){var n=t[s];"row"===n.axis?(this.rowStart=e.fetchParameters.offset?e.fetchParameters.offset:n.start,this.rowEnd=this.rowStart+e.results.length-1):"column"===n.axis&&(this.colStart=n.start,this.colEnd=Math.min(this.colStart+n.count-1,this.colStart+i.length-1))}},w.prototype.getData=function(e){var t=this,i={};return Object.defineProperty(i,"data",{enumerable:!0,get:function(){return t.results[e.row-t.rowStart].data[t.columns[e.column]]},set:function(i){t.results[e.row-t.rowStart].data[t.columns[e.column]]=i}}),i},w.prototype.getMetadata=function(e){var t=this.results[e.row-this.rowStart].metadata;return t.keys={row:this.results[e.row-this.rowStart].metadata.key,column:this.columns[e.column]},t},w.prototype.getCount=function(e){return"row"===e?this.rowEnd-this.rowStart+1:"column"===e?this.colEnd-this.colStart+1:0},w.prototype.getExtent=function(){return{row:{extent:1,more:{before:!1,after:!1}},column:{extent:1,more:{before:!1,after:!1}}}},E.prototype.setUpColumns=function(e){if(null==this.columns||0===this.columns.length){var t=[];if(e.results.length)for(var i=Object.keys(e.results[0].data),s=0;s<i.length;s++)t.push(i[s]);this.columns=t}},E.prototype.getRangeInfo=function(e){for(var t={},i=0;i<e.length;i+=1){var s=e[i];"row"===s.axis?(t.rowStart=s.start,t.rowEnd=t.rowStart+s.count-1):"column"===s.axis&&(t.colStart=s.start,t.colEnd=t.colStart+s.count-1)}return t},E.prototype._createResults=function(e){e.results=[];for(var t=0;t<e.value.data.length;t++){var i={data:e.value.data[t],metadata:e.value.metadata[t]};e.results.push(i)}},E.prototype.handleFetchResult=function(e,t,i,s){var n=s[0];n.results||(this._createResults(n),n.fetchParameters=n.value.fetchParameters),this.setUpColumns(n),this._processPendingHeaderCallbacks("column"),this._processPendingHeaderCallbacks("row");var o=new w(n,e,this.columns);if(null!=t&&null!=t.success){var r=i?i.success:null;t.success.call(r,o,e)}},E.prototype.fetchCells=function(e,t,i){this.getCount("row");var s=this.getRangeInfo(e),n=s.rowEnd-s.rowStart+1;if(this.fetchByOffset){var o=s.rowStart;this._fetchPromise=this.dataprovider.fetchByOffset({size:n,offset:o,sortCriteria:this.currentSortCriteria})}else(null==this._asyncIterator||this.sortUpdated)&&(this._clientId=this._clientId||Symbol(),this._asyncIterator=this.dataprovider.fetchFirst({clientId:this._clientId,size:n,sortCriteria:this.currentSortCriteria})[Symbol.asyncIterator]()),this._fetchPromise=this._asyncIterator.next();this.sortUpdated=!1,Promise.all([this._fetchPromise,this._getCountPromise]).then(this.handleFetchResult.bind(this,e,t,i))},E.prototype.getCapability=function(e){if("sort"===e){var t=this.dataprovider.getCapability(e).attributes;return"multiple"===t||"single"===t?"column":t}return"none"},E.prototype.getCount=function(e){var t=this;if("row"===e){if(void 0!==t.totalRowCount)return t.totalRowCount;t._getCountPromise=this.dataprovider.getTotalSize(),t._getCountPromise.then(function(e){t.totalRowCount=e})}else if("column"===e&&null!=this.columns)return this.columns.length;return-1},E.prototype.getCountPrecision=function(){return"estimate"},E.prototype.indexes=function(){return{row:-1,column:-1}},E.prototype.keys=function(){return{row:null,column:null}},E.prototype.move=function(){return!1},E.prototype.moveOK=function(){return"invalid"},E.prototype.sort=function(e,t,i){this.sortUpdated=!0,this.currentSortCriteria=[{attribute:e.key,direction:e.direction}],null==i&&(i={}),null!=t&&null!=t.success&&t.success.call(i.success)},H.prototype.getData=function(e){return this.headers[e]},H.prototype.getMetadata=function(e){var t=this.getData(e),i={key:t};if(null!=this.sortCriteria)for(var s=0;s<this.sortCriteria.length;s++)this.sortCriteria[s].attribute===t&&(i.sortDirection=this.sortCriteria[s].direction);return i},H.prototype.getLevelCount=function(){return 1},H.prototype.getExtent=function(){return{extent:1,more:{before:!1,after:!1}}},H.prototype.getLabel=function(){return null},H.prototype.getDepth=function(){return 1},H.prototype.getCount=function(){return Math.max(0,this.end-this.start)};const b=function(e){this.grid=e};b.prototype.getAction=function(e,t){var i=e.keyCode,s=this.grid.m_utils.ctrlEquivalent(e),n=e.shiftKey,o=e.altKey,r=this.grid.keyCodes,l=t.cellOrHeader,a=t.readOnly,h=t.currentMode,d=t.activeMove,c=t.rowMove,m=t.columnSort,u=t.selection,_=t.selectionMode,p=t.multipleSelection,g=t.expandCollapse,f=t.copyCells,C=t.cutCells,y=t.pasteCells,v=t.fill;switch(i){case r.TAB_KEY:if("actionable"===h)return n?"TAB_PREV_IN_CELL":"TAB_NEXT_IN_CELL";if(!a)return n?"FOCUS_LEFT":"FOCUS_RIGHT";break;case r.ENTER_KEY:if("column"===l&&m)return"SORT";if(!o&&a&&"navigation"===h||"cell"!==l)return"ACTIONABLE";if(!a&&!o)return n?"FOCUS_UP":"FOCUS_DOWN";if(o&&a&&"navigation"===h)return"EDITABLE";if(!a&&("navigation"===h||"edit"===h))return"EDIT";break;case r.ESC_KEY:if("actionable"===h)return"EXIT_ACTIONABLE";if(d)return"CANCEL_REORDER";if(a){if(this.grid.m_discontiguousSelection)return"SELECT_DISCONTIGUOUS"}else{if("navigation"===h)return"EXIT_EDITABLE";if("edit"===h)return"CANCEL_EDIT"}break;case r.SPACE_KEY:if(-1!==l.indexOf("row")&&u&&("cell"===_&&p||"row"===_))return"SELECT_ROW";if(-1!==l.indexOf("column")&&u&&"cell"===_&&p)return"SELECT_COLUMN";if("cell"===l)if(a&&"navigation"===h){if(s&&u&&"cell"===_&&p)return"SELECT_COLUMN";if(n&&u&&("cell"===_&&p||"row"===_))return"SELECT_ROW"}else if("navigation"===h)return"DATA_ENTRY";break;case r.PAGEUP_KEY:if("edit"!==h)return"FOCUS_ROW_FIRST";break;case r.PAGEDOWN_KEY:if("edit"!==h)return"FOCUS_ROW_LAST";break;case r.END_KEY:if("edit"!==h)return"FOCUS_COLUMN_LAST";break;case r.HOME_KEY:if("edit"!==h)return"FOCUS_COLUMN_FIRST";break;case r.LEFT_KEY:if(s&&g&&this.grid._isHeaderExpanded(e.target))return"COLLAPSE";if("actionable"===h)return"NO_OP";if("edit"!==h)return n&&u&&"cell"===_&&p?"SELECT_EXTEND_LEFT":s?"FOCUS_ROW_HEADER":"FOCUS_LEFT";break;case r.UP_KEY:if("actionable"===h)return"NO_OP";if("edit"!==h)return n&&u&&p?"SELECT_EXTEND_UP":s?"FOCUS_COLUMN_HEADER":"FOCUS_UP";break;case r.RIGHT_KEY:if(s&&g&&this.grid._isHeaderCollapsed(e.target))return"EXPAND";if("actionable"===h)return"NO_OP";if("edit"!==h)return n&&u&&"cell"===_&&p?"SELECT_EXTEND_RIGHT":s?"FOCUS_ROW_END_HEADER":"FOCUS_RIGHT";break;case r.DOWN_KEY:if("actionable"===h)return"NO_OP";if("edit"!==h)return n&&u&&p?"SELECT_EXTEND_DOWN":s?"FOCUS_COLUMN_END_HEADER":"FOCUS_DOWN";break;case r.F2_KEY:if("cell"!==l)return"ACTIONABLE";if(a&&"navigation"===h)return"EDITABLE";if(!a&&"navigation"===h)return"EDIT";break;case r.F8_KEY:if(n&&u&&p)return"SELECT_DISCONTIGUOUS";break;case r.F10_KEY:if(n)return"NO_OP";break;case r.V_KEY:if("navigation"===h&&s){if(c)return"PASTE";if(y)return"PASTE_CELLS"}if(!a&&"navigation"===h)return"DATA_ENTRY";break;case r.X_KEY:if("navigation"===h&&s){if(c)return"CUT";if(C)return"CUT_CELLS"}if(!a&&"navigation"===h)return"DATA_ENTRY";break;case r.C_KEY:if("navigation"===h&&s&&f)return"COPY_CELLS";if(!a&&"navigation"===h)return"DATA_ENTRY";break;case r.D_KEY:case r.R_KEY:if("navigation"===h&&s&&v)return"FILL";break;case r.SHIFT_KEY:case r.CTRL_KEY:case r.ALT_KEY:break;case r.A_KEY:if(s&&u&&p)return"SELECT_ALL";case r.NUM5_KEY:if(s&&o)return"READ_CELL";default:if((i<r.F1_KEY||i>r.F15_KEY)&&!a&&"navigation"===h&&"cell"===l&&!s)return"DATA_ENTRY"}return"NO_OP"};const x=function(e,t){this.options=e,this.rendererWrapperFunction=t};x.prototype.extract=function(e,t,i,s){if(null!=e){var n=this.options[e];if(null!=t&&null!=n){var o=n[t];if(null!=i&&null!=o){var r=o[i];return null!=s&&null!=r?r[s]:r}return o}return n}return null},x.prototype.evaluate=function(e,t){return"function"==typeof e?e.call(this,t):e},x.prototype.getRawProperty=function(e,t,i){var s,n,o,r;return"row"===t||"column"===t||"rowEnd"===t||"columnEnd"===t?(s="header",n=t,i?(o="label",r=e):o=e):"cell"===t&&(s="cell",n=e),this.extract(s,n,o,r)},x.prototype.getProperty=function(e,t,i,s){return void 0===i?this.extract(e,t,s):this.evaluate(this.getRawProperty(e,t,s),i)},x.prototype.getRowBandingInterval=function(){var e=this.getProperty("bandingInterval","row");return null!=e?e:0},x.prototype.getColumnBandingInterval=function(){var e=this.getProperty("bandingInterval","column");return null!=e?e:0},x.prototype.getEmptyText=function(){return this.getProperty("emptyText")},x.prototype.getHorizontalGridlines=function(){var e=this.extract("gridlines","horizontal");return null!=e?e:"visible"},x.prototype.getVerticalGridlines=function(){var e=this.extract("gridlines","vertical");return null!=e?e:"visible"},x.prototype.getScrollToKey=function(){var e=this.getProperty("scrollToKey");return null!=e?e:"auto"},x.prototype.getScrollPosition=function(){var e=this.getProperty("scrollPosition");return null!=e?e:null},x.prototype.getSelectionCardinality=function(){var e=this.getProperty("selectionMode");if(null==e)return"none";var t=e[this.getSelectionMode()];return null!=t?t:"none"},x.prototype.getSelectionMode=function(){var e=this.getProperty("selectionMode");if(null==e)return"cell";var t=e.row;return null!=t&&"none"!==t?"row":"cell"},x.prototype.getSelection=function(){return this.getProperty("selection")},x.prototype.getCurrentCell=function(){return this.getProperty("currentCell")},x.prototype.getEditMode=function(){return this.getProperty("editMode")},x.prototype.isSortable=function(e,t){return this.getProperty("sortable",e,t)},x.prototype.isResizable=function(e,t,i){var s=this.extract("header",e,"resizable",t);return null!=i?this.evaluate(s,i):s},x.prototype.isMoveable=function(e){return this.extract("dnd","reorder",e)},x.prototype.isFloodFillEnabled=function(){let e=!1;return"enable"===this.extract("dataTransferOptions","fill")&&(e=!0),e},x.prototype.isCopyEnabled=function(){let e=!1;return"enable"===this.extract("dataTransferOptions","copy")&&(e=!0),e},x.prototype.isCutEnabled=function(){let e=!1;return"enable"===this.extract("dataTransferOptions","cut")&&(e=!0),e},x.prototype.isPasteEnabled=function(){let e=!1;return"enable"===this.extract("dataTransferOptions","paste")&&(e=!0),e},x.prototype.getInlineStyle=function(e,t,i){return this.getProperty("style",e,t,i)},x.prototype.getStyleClass=function(e,t,i){return this.getProperty("className",e,t,i)},x.prototype.getRenderer=function(e,t){return this.rendererWrapperFunction?this.rendererWrapperFunction(this.getRawProperty("renderer",e,t)):this.getRawProperty("renderer",e,t)},x.prototype.getScrollPolicy=function(){var e=this.getProperty("scrollPolicy");return null==e&&(e="auto"),e},x.prototype.getScrollPolicyOptions=function(){return this.getProperty("scrollPolicyOptions")};const R=function(){this.sizes={column:new Map,row:new Map}};R.prototype.setSize=function(e,t,i){this.sizes[e].set(t,i)},R.prototype.getSize=function(e,t){var i=this.sizes[e].get(t);return null!=i||this.sizes[e].forEach(function(e,s){null==i&&a.Object.compareValues(s,t)&&(i=e)}),i},R.prototype.clear=function(){this.sizes.column.clear(),this.sizes.row.clear()};const M=function(e){this.scrollbarSize=-1,this.dataGrid=e;let t=oj.AgentUtils.getAgentInfo();this.os=t.os,this.browser=t.browser,this.engine=t.engine};M.prototype._getMaxDivHeightForScrolling=function(){return null==this.m_maxDivHeightForScrolling&&this._setMaxValuesForScrolling(),this.m_maxDivHeightForScrolling},M.prototype._getMaxDivWidthForScrolling=function(){return null==this.m_maxDivWidthForScrolling&&this._setMaxValuesForScrolling(),this.m_maxDivWidthForScrolling},M.prototype._setMaxValuesForScrolling=function(){this._calculateBrowserDefinedValues()},M.prototype._calculateBrowserDefinedValues=function(){var e=document.createElement("div");e.style.width="1000000000px",e.style.height="1000000000px",e.style.display="none";var t=document.createElement("div");t.style.width="100px",t.style.height="100px",t.style.overflow="scroll",t.style.position="absolute",t.style.top="-9999px",document.body.appendChild(t);let i=!1;this.browser===oj.AgentUtils.BROWSER.IE||this.browser===oj.AgentUtils.BROWSER.EDGE?(this.m_maxDivHeightForScrolling=1e6,this.m_maxDivWidthForScrolling=1e6):(i=!0,document.body.appendChild(e),this.m_maxDivHeightForScrolling=parseInt(parseFloat(window.getComputedStyle(e).height)/2,10),this.m_maxDivWidthForScrolling=parseInt(parseFloat(window.getComputedStyle(e).width)/2,10)),this.scrollbarSize=t.offsetWidth-t.clientWidth,i&&document.body.removeChild(e),document.body.removeChild(t)},M.prototype.getScrollbarSize=function(){return-1===this.scrollbarSize&&this._calculateBrowserDefinedValues(),this.scrollbarSize},M.prototype.getScrollbarSize=function(){return-1===this.scrollbarSize&&this.calculateScrollbarSize(),this.scrollbarSize},M.prototype.isTouchDevice=function(){return null==this.isTouch&&(this.isTouch=c.isMobileTouchDevice()),this.isTouch},M.prototype.addCSSClassName=function(e,t){null!=t&&""!==t&&null!=e&&null!=e.classList&&e.classList.add(t)},M.prototype.removeCSSClassName=function(e,t){null!=t&&""!==t&&null!=e&&null!=e.classList&&e.classList.remove(t)},M.prototype.containsCSSClassName=function(e,t){var i=!1;return null!=t&&null!=e&&null!=e.classList&&(i=e.classList.contains(t)),i},M._getCSSClassNameIndex=function(e,t){if(!e||!e.indexOf)return-1;if(t===e)return 0;var i=t.length,s=e.length,n=e.indexOf(t);if(n>=0){var o=0===n||" "===e.charAt(n-1),r=n+i,l=r===s||" "===e.charAt(r);if(o&&l)return n;var a=e.lastIndexOf(t);if(a!==n)return o=e.charAt(a-1),l=(r=a+i)===s||" "===e.charAt(r),o&&l?a:e.indexOf(" "+t+" ")}return-1},M.prototype.ctrlEquivalent=function(e){return this.os===oj.AgentUtils.OS.MAC?e.metaKey:e.ctrlKey},M.prototype.getElementScrollLeft=function(e){return Math.abs(e.scrollLeft)},M.prototype.setElementScrollLeft=function(e,t){m.setScrollLeft(e,t)},M.prototype.getMousewheelEvent=function(){return"wheel"},M.prototype.getMousewheelScrollDelta=function(e){var t=-1,i=e.deltaMode;return i===e.DOM_DELTA_PIXEL?t=-1:i!==e.DOM_DELTA_LINE&&i!==e.DOM_DELTA_PAGE||(t=-40),{deltaX:e.deltaX*t,deltaY:e.deltaY*t}},M.prototype.empty=function(e){for(;e.firstChild;)this.dataGrid._remove(e.firstChild)},M.prototype.supportsTransitions=function(){var e=(document.body||document.documentElement).style,t="transition";if(/MSIE \d/.test(navigator.userAgent)&&(null==document.documentMode||document.documentMode<11))return!1;if("string"==typeof e[t])return!0;var i=["Moz","webkit","Webkit","Khtml","O","ms"];t=t.charAt(0).toUpperCase()+t.substr(1);for(var s=0;s<i.length;s++)if("string"==typeof e[i[s]+t])return!0;return!1},M.prototype._isNodeEditableOrClickable=function(e,t){for(;null!=e&&e!==t;){var i=e.nodeName;if(3===e.nodeType)e=e.parentNode;else{var s=parseInt(e.getAttribute("tabIndex"),10),n=parseInt(e.getAttribute(this.dataGrid.getResources().getMappedAttribute("tabindex")),10);if(null!=s&&s>=0)return!(this.containsCSSClassName(e,this.dataGrid.getResources().getMappedStyle("cell"))||this.containsCSSClassName(e,this.dataGrid.getResources().getMappedStyle("headerlabel"))||this.containsCSSClassName(e,this.dataGrid.getResources().getMappedStyle("headercell"))||this.containsCSSClassName(e,this.dataGrid.getResources().getMappedStyle("endheadercell")));if(i.match(/^INPUT|SELECT|OPTION|BUTTON|^A\b|TEXTAREA/)&&(-1!==s||-1!==n))return!0;e=e.parentNode}}return!1},M.prototype.shouldOffsetOutline=function(){return this.os===oj.AgentUtils.OS.MAC&&this.engine===oj.AgentUtils.ENGINE.WEBKIT};const I=function(e){this.m_root=e,this.MAX_COLUMN_THRESHOLD=20,this.MAX_ROW_THRESHOLD=30,this.m_utils=new M(this),this.m_discontiguousSelection=!1,this.m_sizingManager=new R,this.m_keyboardHandler=new b(this),this.m_rowHeaderWidth=null,this.m_rowEndHeaderWidth=null,this.m_colHeaderHeight=null,this.m_colEndHeaderHeight=null,this.m_styleClassDimensionMap={width:{},height:{}},this.m_isEstimateRowCount=void 0,this.m_isEstimateColumnCount=void 0,this.m_stopRowFetch=!1,this.m_stopRowHeaderFetch=!1,this.m_stopRowEndHeaderFetch=!1,this.m_stopColumnFetch=!1,this.m_stopColumnHeaderFetch=!1,this.m_stopColumnEndHeaderFetch=!1,this.m_initialized=!1,this.m_shouldFocus=null,this.m_renderCount=0,this.callbacks={},this._setupActions(),this.m_readinessStack=[],this.m_modelEvents=[],this.m_databodyMap=new Map};I.prototype.keyCodes={TAB_KEY:9,ENTER_KEY:13,SHIFT_KEY:16,CTRL_KEY:17,ALT_KEY:18,ESC_KEY:27,SPACE_KEY:32,PAGEUP_KEY:33,PAGEDOWN_KEY:34,END_KEY:35,HOME_KEY:36,LEFT_KEY:37,UP_KEY:38,RIGHT_KEY:39,DOWN_KEY:40,NUM5_KEY:53,V_KEY:86,X_KEY:88,C_KEY:67,D_KEY:68,R_KEY:82,F1_KEY:112,F2_KEY:113,F8_KEY:119,F10_KEY:121,F15_KEY:126,A_KEY:65},I.UPDATE_ANIMATION_FADE_INOUT=1,I.UPDATE_ANIMATION_SLIDE_INOUT=2,I.UPDATE_ANIMATION_DURATION=250,I.EXPAND_ANIMATION_DURATION=500,I.COLLAPSE_ANIMATION_DURATION=400,I.MAX_OVERSCROLL_PIXEL=50,I.BOUNCE_ANIMATION_DURATION=500,I.DECELERATION_FACTOR=6e-4,I.TAP_AND_SCROLL_RESET=300,I.MIN_SWIPE_DURATION=200,I.MAX_SWIPE_DURATION=400,I.MIN_SWIPE_DISTANCE=10,I.MIN_SWIPE_TRANSITION_DURATION=100,I.MAX_SWIPE_TRANSITION_DURATION=500,I.CONTEXT_MENU_TAP_HOLD_DURATION=750,I.HEADER_TAP_SHORT_HOLD_DURATION=300,I.FETCH_PIXEL_THRESHOLD=5,I.VISIBILITY_STATE_HIDDEN="hidden",I.VISIBILITY_STATE_REFRESH="refresh",I.VISIBILITY_STATE_RENDER="render",I.VISIBILITY_STATE_VISIBLE="visible",I.SPACER_DEFAULT_WIDTH=2,I.prototype.SetOptions=function(e,t){this.m_options=new x(e,t)},I.prototype.SetSortOriginalEvent=function(e){this.m_sortInfo&&(this.m_sortInfo.originalEvent=e)},I.prototype.UpdateOptions=function(e,t){var i,s,n=Object.keys(e);for(s=0;s<n.length;s++)(i=n[s])in this.m_options.options&&this.m_options.options[i]!==e[i]&&(this.m_options.options[i]=e[i]);for(s=0;s<n.length;s++)if(i=n[s],!this._updateDataGrid(i,t)){this.empty(),this.refresh(this.m_root);break}},I.prototype._updateDataGrid=function(e,t){var i;switch(e){case"bandingInterval":this._removeBanding(),this.updateColumnBanding(),this.updateRowBanding();break;case"currentCell":i=this.m_options.getCurrentCell(),this._updateActive(i,!0,!1);break;case"editMode":this.m_editMode=this.m_options.getEditMode();break;case"gridlines":this._updateGridlines();break;case"header":i=this.m_options.options.header,this._updateHeaderOptions(i,t);break;case"scrollPosition":i=this.m_options.getScrollPosition(),this._updateScrollPosition(i);break;case"selection":i=this.m_options.getSelection(),this._updateSelection(i);break;case"selectionMode":this._clearSelection(null);break;default:return!1}return!0},I.prototype._updateSelection=function(e){null!=e&&this._isSelectionEnabled()&&this.SetSelection(e)},I.prototype._updateHeaderOptions=function(e,t){if(null!=t&&null!=t.subkey){var i,s=t.subkey.split("."),n=s[0],o=s[1];if("column"===n&&null!=this.m_colHeader&&null!=this.m_colHeader.firstChild?i=this.m_colHeader.firstChild.childNodes:"row"===n&&null!=this.m_rowHeader&&null!=this.m_rowHeader.firstChild?i=this.m_rowHeader.firstChild.childNodes:"columnEnd"===n&&null!=this.m_colEndHeader&&null!=this.m_colEndHeader.firstChild?i=this.m_colEndHeader.firstChild.childNodes:"rowEnd"===n&&null!=this.m_rowEndHeader&&null!=this.m_rowEndHeader.firstChild&&(i=this.m_rowEndHeader.firstChild.childNodes),null!=i)for(var r=0;r<i.length;r++){var l=i[r],a=l[this.getResources().getMappedAttribute("context")];if(a.index=this.getHeaderCellIndex(l),"resizable"===o)this._isHeaderResizeEnabled(n,a)?this._setAttribute(l,o,"true"):this._setAttribute(l,o,"false");else if("sortable"===o){var h=this.m_utils.containsCSSClassName(l.lastChild,this.getMappedStyle("sortIcon"));if(this._isSortEnabled(n,a)){if(!h){var d=this._buildSortIcon(a,l);l.appendChild(d)}this._setAttribute(l,o,"true")}else h&&this._remove(l.lastChild),this._setAttribute(l,o,"false")}}}},I.prototype._updateGridlines=function(){var e=this.m_options.getHorizontalGridlines(),t=this.m_options.getVerticalGridlines(),i=this.getResources().isRTLMode()?"right":"left";if(this.m_databody&&this.m_databody.firstChild){let s=this.m_databody.firstChild.querySelectorAll("."+this.getMappedStyle("cell")),n=this._getLastAxis("row"),o=this._getLastAxis("column");for(let r=0;r<s.length;r++){let l=s[r],a=this.getCellIndexes(l);"hidden"===t||a.column===o&&(this.getRowHeaderWidth()+this.getElementDir(l,i)+this.calculateColumnWidth(l)>=this.getWidth()||this.m_endRowEndHeader>-1)?this.m_utils.addCSSClassName(l,this.getMappedStyle("borderVerticalNone")):this.m_utils.removeCSSClassName(l,this.getMappedStyle("borderVerticalNone")),"hidden"===e||a.row===n&&(this.getRowBottom(l,null)>=this.getHeight()||this.m_endColEndHeader>-1)?this.m_utils.addCSSClassName(l,this.getMappedStyle("borderHorizontalNone")):this.m_utils.removeCSSClassName(l,this.getMappedStyle("borderHorizontalNone"))}}},I.prototype._updateEdgeCellBorders=function(e){if(null!=this.m_active&&"cell"===this.m_active.type){var t=this._getActiveElement();null!=t&&((this._isCellEditable()&&""===e||""!==e)&&this._applyBorderClassesAroundRange(t,{startIndex:this.m_active.indexes},""===e,"Edit"),this._isLastRow(this.m_active.indexes.row)&&("none"===e?this.m_utils.addCSSClassName(t,this.getMappedStyle("borderHorizontalNone")):this.m_utils.removeCSSClassName(t,this.getMappedStyle("borderHorizontalNone"))),this._isLastColumn(this.m_active.indexes.column)&&("none"===e?this.m_utils.addCSSClassName(t,this.getMappedStyle("borderVerticalNone")):this.m_utils.removeCSSClassName(t,this.getMappedStyle("borderVerticalNone"))))}},I.prototype.SetResources=function(e){this.m_resources=e},I.prototype.getResources=function(){return this.m_resources},I.prototype.getStartRowHeader=function(){return this.m_startRowHeader},I.prototype.getStartColumnHeader=function(){return this.m_startColHeader},I.prototype.getStartRowEndHeader=function(){return this.m_startRowEndHeader},I.prototype.getStartColumnEndHeader=function(){return this.m_startColEndHeader},I.prototype.getMappedStyle=function(e){return this.getResources().getMappedStyle(e)},I.prototype.SetDataSource=function(e){this.m_modelEvents=[],this.m_dataSource=e},I.prototype.getDataSource=function(){return this.m_dataSource},I.prototype.setVisibility=function(e){this.m_visibility=e},I.prototype.getVisibility=function(){return null==this.m_visibility&&(null!=this.m_root.offsetParent?this.setVisibility(I.VISIBILITY_STATE_VISIBLE):this.setVisibility(I.VISIBILITY_STATE_HIDDEN)),this.m_visibility},I.prototype.SetOptionCallback=function(e){this.m_setOptionCallback=e},I.prototype.SetContextCallback=function(e){this.m_contextCallback=e},I.prototype.SetCustomElementCallback=function(e){this.m_isCustomElementCallback=e},I.prototype.SetRemoveCallback=function(e){this.m_removeCallback=e},I.prototype.SetUniqueIdCallback=function(e){this._uniqueIdCallback=e},I.prototype.SetCompareValuesCallback=function(e){this._compareValuesCallback=e},I.prototype.SetSubtreeAttachedCallback=function(e){this.m_subtreeAttachedCallback=e},I.prototype.SetUpdateScrollPostionOnRefreshCallback=function(e){this.m_updateScrollPostionOnRefreshCallback=e},I.prototype._remove=function(e){this._uniqueIdCallback(e,!0),this.m_removeCallback.call(null,e)},I.prototype._removeFromArray=function(e){for(var t=0;t<e.length;t++)this._remove(e[t])},I.prototype.SetNotReadyCallback=function(e){this.m_notReady=e},I.prototype.SetMakeReadyCallback=function(e){this.m_makeReady=e},I.prototype._signalTaskStart=function(){this.m_readinessStack&&(0===this.m_readinessStack.length&&this.m_notReady(),this.m_readinessStack.push(1))},I.prototype._signalTaskEnd=function(){this.m_readinessStack&&this.m_readinessStack.length>0&&(this.m_readinessStack.pop(),0===this.m_readinessStack.length&&this.m_makeReady())},I.prototype._indexes=function(e,t){var i=this,s=this.getDataSource().indexes(e);"function"==typeof s.then?(i._signalTaskStart(),s.then(function(s){t.call(i,s,e),i._signalTaskEnd()},function(){t.call(i,{row:-1,column:-1},e),i._signalTaskEnd()})):t.call(i,s,e)},I.prototype._keys=function(e,t){var i=this,s=this._getLocalKeys(e);if(void 0===s){var n=this.getDataSource().keys(e);"function"==typeof n.then?(i._signalTaskStart(),n.then(function(s){t.call(i,s,e),i._signalTaskEnd()},function(){t.call(i,{row:null,column:null},e),i._signalTaskEnd()})):t.call(i,n,e)}else t.call(i,s,e)},I.prototype._getLocalKeys=function(e){var t=this._getCellByIndex(e);if(t)return this.getCellKeys(t);var i,s,n=e.row,o=e.column;if(void 0!==n){if(-1===n)i=null;else{var r=this._getCellOrHeaderByIndex(n,"row");r&&(i=this._getKey(r,"row"))}if(void 0===i)return}if(void 0!==o){if(-1===o)s=null;else{var l=this._getCellOrHeaderByIndex(o,"column");l&&(s=this._getKey(l,"column"))}if(void 0===s)return}return this.createIndex(i,s)},I.prototype.SetCreateContextCallback=function(e){this.m_createContextCallback=e},I.prototype.SetFocusableCallback=function(e,t){this.m_focusInHandler=e,this.m_focusOutHandler=t},I.prototype.SetFixContextCallback=function(e){this.m_fixContextCallback=e},I.prototype._isHighWatermarkScrolling=function(){return"scroll"!==this.m_options.getScrollPolicy()},I.prototype.destroy=function(){delete this.m_fetching,this._removeDataSourceEventListeners(),this._removeDomEventListeners(),delete this.m_styleClassDimensionMap,this.m_styleClassDimensionMap={width:{},height:{}}},I.prototype._addDataSourceEventListeners=function(){this._removeDataSourceEventListeners(),null!=this.m_dataSource&&(this.m_handleModelEventListener=this.handleModelEvent.bind(this),this.m_handleExpandEventListener=this.handleExpandEvent.bind(this),this.m_handleCollapseEventListener=this.handleCollapseEvent.bind(this),this.m_dataSource.on("change",this.m_handleModelEventListener,this),this.m_dataSource.on("expand",this.m_handleExpandEventListener,this),this.m_dataSource.on("collapse",this.m_handleCollapseEventListener,this))},I.prototype._removeDataSourceEventListeners=function(){null!=this.m_dataSource&&(this.m_dataSource.off("change",this.m_handleModelEventListener),this.m_dataSource.off("expand",this.m_handleExpandEventListener),this.m_dataSource.off("collapse",this.m_handleCollapseEventListener))},I.prototype._addDomEventListeners=function(){this.m_handleDatabodyKeyDown||(this.m_handleDatabodyKeyDown=this.handleDatabodyKeyDown.bind(this)),this.m_handleDatabodyKeyUp||(this.m_handleDatabodyKeyUp=this.handleDatabodyKeyUp.bind(this)),this.m_handleRootFocus||(this.m_handleRootFocus=this.handleRootFocus.bind(this)),this.m_handleRootBlur||(this.m_handleRootBlur=this.handleRootBlur.bind(this)),this.m_root.addEventListener("keydown",this.m_handleDatabodyKeyDown,!1),this.m_root.addEventListener("keyup",this.m_handleDatabodyKeyUp,!1),this.m_root.addEventListener("focus",this.m_handleRootFocus,!0),this.m_root.addEventListener("blur",this.m_handleRootBlur,!0)},I.prototype._removeDomEventListeners=function(){document.removeEventListener("mousemove",this.m_docMouseMoveListener,!1),document.removeEventListener("mouseup",this.m_docMouseUpListener,!1),null!=this.m_root&&(this.m_handleDatabodyKeyDown&&this.m_root.removeEventListener("keydown",this.m_handleDatabodyKeyDown,!1),this.m_handleDatabodyKeyUp&&this.m_root.removeEventListener("keyup",this.m_handleDatabodyKeyUp,!1),this.m_handleRootFocus&&this.m_root.removeEventListener("focus",this.m_handleRootFocus,!0),this.m_handleRootBlur&&this.m_root.removeEventListener("blur",this.m_handleRootBlur,!0))},I.prototype.getRootElement=function(){return this.m_root},I.prototype.getWidth=function(){return null==this.m_width&&(this.m_width=this.getRootElement().clientWidth),this.m_width},I.prototype.getHeight=function(){return null==this.m_height&&(this.m_height=this.getRootElement().clientHeight),this.m_height},I.prototype.getScrollableWidth=function(){var e=this.m_databody.firstChild;return this.getElementWidth(e)},I.prototype.getViewportWidth=function(){var e=this.getWidth();return Math.round(1.5*e)},I.prototype.getViewportHeight=function(){var e=this.getHeight();return Math.round(1.5*e)},I.prototype._getViewportTop=function(){return this.m_currentScrollTop},I.prototype._getViewportBottom=function(){var e=this._getViewportTop(),t=this.getElementHeight(this.m_databody),i=this.m_utils.getScrollbarSize();return this.m_hasHorizontalScroller?e+t-i:e+t},I.prototype._getViewportLeft=function(){return this.m_currentScrollLeft},I.prototype._getViewportRight=function(){var e=this._getViewportLeft(),t=this.getElementWidth(this.m_databody),i=this.m_utils.getScrollbarSize();return this.m_hasVerticalScroller?e+t-i:e+t},I.prototype.getFetchSize=function(e){return"row"===e?(null==this.m_rowFetchSize&&(this.m_rowFetchSize=Math.max(1,Math.round(this.getViewportHeight()/this.getDefaultRowHeight()))),this.m_rowFetchSize):"column"===e?(null==this.m_columnFetchSize&&(this.m_columnFetchSize=Math.max(1,Math.round(this.getViewportWidth()/this.getDefaultColumnWidth()))),this.m_columnFetchSize):0},I.prototype.getEmptyText=function(){var e=this.m_options.getEmptyText();null==e&&(e=this.getResources().getTranslatedText("msgNoData"));return e},I.prototype._buildEmptyText=function(){var e=this.getEmptyText(),t=document.createElement("div");t.id=this.createSubId("empty"),t.className=this.getMappedStyle("emptytext");var i=this.m_endColHeader>=0?this.getColumnHeaderHeight():0;this.setElementDir(t,i,"top");var s=this.getResources().isRTLMode()?"right":"left",n=this.m_endRowHeader>=0?this.getRowHeaderWidth():0;return this.setElementDir(t,n,s),t.textContent=e,this.m_empty=t,t},I.prototype.getRowThreshold=function(){return 0},I.prototype.getColumnThreshold=function(){return 0},I.prototype.setDefaultDimensions=function(){var e=document.createElement("div");e.style.visibilty="hidden";var t=this.getResources();e.className=t.getMappedStyle("rowheadercell")+" "+t.getMappedStyle("colheadercell")+" "+t.getMappedStyle("headercell"),this.m_root.appendChild(e);var i=e.getBoundingClientRect();this.m_defaultColumnWidth=Math.round(i.width),this.m_defaultRowHeight=Math.round(i.height),this.getViewportWidth(),this.getViewportHeight(),this.m_root.removeChild(e)},I.prototype.getDefaultRowHeight=function(){return null==this.m_defaultRowHeight&&this.setDefaultDimensions(),this.m_defaultRowHeight},I.prototype.getDefaultColumnWidth=function(){return null==this.m_defaultColumnWidth&&this.setDefaultDimensions(),this.m_defaultColumnWidth},I.prototype._getHeaderDimension=function(e,t,i,s){var n=this.m_sizingManager.getSize(i,t);if(null!=n)return n;if(""!==e.style[s])return n=this.getElementDir(e,s),this.m_sizingManager.setSize(i,t,n),n;var o=e.className;return null==(n=this.m_styleClassDimensionMap[s][o])&&(n=this.getElementDir(e,s)),this.m_sizingManager.setSize(i,t,n),this.m_styleClassDimensionMap[s][o]=n,n},I.prototype.createSubId=function(e){return[this.getRootElement().id,e].join(":")},I.prototype.isHeaderFetchComplete=function(){return!1===this.m_fetching.row&&!1===this.m_fetching.column},I.prototype.isFetchComplete=function(){return null!=this.m_fetching&&this.isHeaderFetchComplete()&&!1===this.m_fetching.cells},I.prototype._isLastRow=function(e){return this._isCountUnknown("row")?e===this.m_endRow&&this.m_stopRowFetch:e+1===this.getDataSource().getCount("row")},I.prototype._isLastColumn=function(e){return this._isCountUnknown("column")?e===this.m_endCol&&this.m_stopColumnFetch:e+1===this.getDataSource().getCount("column")},I.prototype._getLastAxis=function(e){return this._isCountUnknown(e)?("row"===e?this.m_stopRowFetch:this.m_stopColumnFetch)?"row"===e?this.m_endRow:this.m_endCol:"row"===e?this.m_endRow+1:this.m_endCol+1:this.getDataSource().getCount(e)-1},I.prototype.empty=function(){this.m_empty&&this.m_root.removeChild(this.m_empty),this.m_corner&&this._remove(this.m_corner),this.m_bottomCorner&&this._remove(this.m_bottomCorner),this.m_columnHeaderScrollbarSpacer&&this._remove(this.m_columnHeaderScrollbarSpacer),this.m_rowHeaderScrollbarSpacer&&this._remove(this.m_rowHeaderScrollbarSpacer),this.m_root.removeChild(this.m_placeHolder),this.m_root.removeChild(this.m_status),this.m_root.removeChild(this.m_accSummary),this.m_root.removeChild(this.m_accInfo),this.m_root.removeChild(this.m_stateInfo),this.m_root.removeChild(this.m_contextInfo),this._remove(this.m_colHeader),this._remove(this.m_rowHeader),this._remove(this.m_colEndHeader),this._remove(this.m_rowEndHeader),this._remove(this.m_databody),this._clearDatabodyMap()},I.prototype.refresh=function(e){this.resetInternal(),this.render(e)},I.prototype.resetInternal=function(){this.m_initialized=!1,this.m_readinessStack=[],this._signalTaskStart(),this._signalTaskEnd(),this._clearDatabodyMap(),this.m_cursor=null,this.m_corner=null,this.m_bottomCorner=null,this.m_columnHeaderScrollbarSpacer=null,this.m_rowHeaderScrollbarSpacer=null,this.m_colHeader=null,this.m_colEndHeader=null,this.m_rowHeader=null,this.m_rowEndHeader=null,this.m_databody=null,this.m_empty=null,this.m_accInfo=null,this.m_accSummary=null,this.m_contextInfo=null,this.m_placeHolder=null,this.m_stateInfo=null,this.m_status=null,this.m_headerLabels={row:[],column:[],rowEnd:[],columnEnd:[]},this.m_isEstimateRowCount=void 0,this.m_isEstimateColumnCount=void 0,this.m_stopRowFetch=!1,this.m_stopRowHeaderFetch=!1,this.m_stopRowEndHeaderFetch=!1,this.m_stopColumnFetch=!1,this.m_stopColumnHeaderFetch=!1,this.m_stopColumnEndHeaderFetch=!1,this.m_rowFetchSize=null,this.m_columnFetchSize=null,this.m_fetching=null,this.m_processingModelEvent=!1,this.m_processingEventQueue=!1,this.m_animating=!1,this.m_sizingManager.clear(),this.m_styleClassDimensionMap={width:{},height:{}},this.m_height=null,this.m_width=null,this.m_scrollHeight=null,this.m_scrollWidth=null,this.m_avgRowHeight=void 0,this.m_avgColWidth=void 0,this.m_defaultColumnWidth=null,this.m_defaultRowHeight=null,this.m_colHeaderHeight=null,this.m_colEndHeaderHeight=null,this.m_rowHeaderWidth=null,this.m_rowEndHeaderWidth=null,this.m_rowHeaderLevelWidths=[],this.m_rowEndHeaderLevelWidths=[],this.m_columnHeaderLevelHeights=[],this.m_columnEndHeaderLevelHeights=[],this.m_collisionResize=!1,this.m_active=null,this.m_prevActive=null,this.m_trueIndex={},this.m_headerDragState=!1,this.m_databodyDragState=!1,this.m_databodyMove=!1,this.m_moveRow=null,this.m_moveRowHeader=null,this.m_dropTarget=null,this.m_dropTargetHeader=null,this.m_floodFillDragState=!1,this.m_dataTransferAction=null,this.m_discontiguousSelection=!1,this.m_docMouseMoveListener=null,this.m_docMouseUpListener=null,this.m_modelEvents=[],this.m_hasHorizontalScroller=null,this.m_hasVerticalScroller=null,this.m_currentScrollLeft=null,this.m_currentScrollTop=null,this.m_prevScrollLeft=null,this.m_prevScrollTop=null,this.m_handleScrollOverflow=null,this._clearScrollPositionTimeout(),this.m_resizing=!1,this.m_resizingElement=null,this.m_resizingElementMin=null,this.m_startRow=null,this.m_startCol=null,this.m_endRow=null,this.m_endCol=null,this.m_startRowPixel=null,this.m_startColPixel=null,this.m_endRowPixel=null,this.m_endColPixel=null,this.m_startRowHeader=null,this.m_startColHeader=null,this.m_endRowHeader=null,this.m_endColHeader=null,this.m_startRowHeaderPixel=null,this.m_startColHeaderPixel=null,this.m_endRowHeaderPixel=null,this.m_endColHeaderPixel=null,this.m_rowHeaderLevelCount=null,this.m_columnHeaderLevelCount=null,this.m_startRowEndHeader=null,this.m_startColEndHeader=null,this.m_endRowEndHeader=null,this.m_endColEndHeader=null,this.m_startRowEndHeaderPixel=null,this.m_startColEndHeaderPixel=null,this.m_endRowEndHeaderPixel=null,this.m_endColEndHeaderPixel=null,this.m_rowEndHeaderLevelCount=null,this.m_columnEndHeaderLevelCount=null,this.m_sortInfo=null,this.m_expandCollapseInfo=null,this.m_resizeRequired=null,this.m_externalFocus=null,this.m_currentMode=null,this.m_editMode=null,this.m_hasCells=null,this.m_hasRowHeader=null,this.m_hasRowEndHeader=null,this.m_hasColHeader=null,this.m_hasColEndHeader=null,this.m_isLongScroll=null,this.m_addBorderBottom=null,this.m_addBorderRight=null,this.m_sortContainerWidth=null,this.m_sortContainerHeight=null,this._destroyEditableClone(),this._clearFocusoutTimeout(),this._clearFocusoutBusyState()},I.prototype._shouldInitialize=function(){return this.isFetchComplete()&&!this.m_initialized&&null!=this.m_databody.parentNode},I.prototype._handleInitialization=function(e){!0===e?(this.resizeGrid(),0===this.m_startRow&&0===this.m_startCol&&this.fillViewport(),this.isFetchComplete()&&(this._updateActive(this.m_options.getCurrentCell(),!!this.m_focusOnRefresh,!0),this.m_initialized=!0,this.fireEvent("ready",{}),this._runModelEventQueue())):(this.m_initialized=!0,this.fireEvent("ready",{}),this._runModelEventQueue())},I.prototype._runModelEventQueue=function(){var e;if(null!=this.m_modelEvents){if(this.m_processingEventQueue=!0,0===this.m_modelEvents.length)return void(this.m_processingEventQueue=!1);"expand"===(e=this.m_modelEvents.shift()).operation?this.handleExpandEvent(e,!0):"collapse"===e.operation?this.handleCollapseEvent(e,!0):this.handleModelEvent(e,!0)}else this.m_processingEventQueue=!1},I.prototype.render=function(e){this.m_renderCount+=1,this.m_timingStart=new Date,this.m_fetching={},this.m_startRow=0,this.m_startCol=0,this.m_endRow=-1,this.m_endCol=-1,this.m_startRowPixel=0,this.m_startColPixel=0,this.m_endRowPixel=0,this.m_endColPixel=0,this.m_startRowHeader=0,this.m_startColHeader=0,this.m_endRowHeader=-1,this.m_endColHeader=-1,this.m_startRowHeaderPixel=0,this.m_startColHeaderPixel=0,this.m_endRowHeaderPixel=0,this.m_endColHeaderPixel=0,this.m_startRowEndHeader=0,this.m_startColEndHeader=0,this.m_endRowEndHeader=-1,this.m_endColEndHeader=-1,this.m_startRowEndHeaderPixel=0,this.m_startColEndHeaderPixel=0,this.m_endRowEndHeaderPixel=0,this.m_endColEndHeaderPixel=0,this.m_currentScrollLeft=0,this.m_currentScrollTop=0,this.m_prevScrollLeft=0,this.m_prevScrollTop=0,this.m_handleScrollOverflow=!1,this.m_rowHeaderLevelWidths=[],this.m_rowEndHeaderLevelWidths=[],this.m_columnHeaderLevelHeights=[],this.m_columnEndHeaderLevelHeights=[];var t=this._loadTemplateEngine();t?(this._signalTaskStart("loading template engine"),t.then(()=>{this._signalTaskEnd(),this.m_renderCount-=1,0===this.m_renderCount&&this.buildGrid(e)})):(this.m_renderCount-=1,this.buildGrid(e))},I.prototype._loadTemplateEngine=function(){var e=this._getSlotMap();return this._isDataGridProvider()&&Object.keys(e).length>1?new Promise(e=>{u.__getTemplateEngine().then(t=>{this.m_engine=t,e(t)},function(e){throw new Error("Error loading template engine: "+e)})}):null},I.prototype._getTemplateEngine=function(){return this.m_engine},I.prototype._isDataGridProvider=function(){return this.m_options.options.data&&this.m_options.options.data.fetchByOffset&&!this.m_options.options.data.fetchFirst},I.prototype._getSlotMap=function(){return _.CustomElementUtils.getSlotMap(this.m_root)},I.prototype._getItemTemplateBySlotName=function(e){var t=this._getSlotMap()[e];return t&&t.length>0&&"template"===t[0].tagName.toLowerCase()?t[0]:null},I.prototype.buildGrid=function(e){this.m_root=e,this.m_root.setAttribute("role","application"),this._isCellEditable()?this.m_utils.addCSSClassName(this.m_root,this.getMappedStyle("editable")):this.m_utils.addCSSClassName(this.m_root,this.getMappedStyle("readOnly")),this.setDefaultDimensions(),e.tabIndex=0;var t=this.buildStatus();e.appendChild(t),this.m_status=t;var i=this.buildAccSummary();e.appendChild(i),this.m_accSummary=i;var s=this.buildAccInfo();e.appendChild(s),this.m_accInfo=s;var n=this.buildStateInfo();e.appendChild(n),this.m_stateInfo=n;var o=this.buildContextInfo();e.appendChild(o),this.m_contextInfo=o;var r=this.buildPlaceHolder();if(e.appendChild(r),this.m_placeHolder=r,this.m_headerLabels={row:[],column:[],rowEnd:[],columnEnd:[]},null!=this.getDataSource()){this.m_empty=null;var l=this.getResources().isRTLMode(),a=this.buildHeaders("column",this.getMappedStyle("colheader"),this.getMappedStyle("colendheader")),h=a.root,d=a.endRoot;e.insertBefore(h,t),e.insertBefore(d,t);var c=(a=this.buildHeaders("row",this.getMappedStyle("rowheader"),this.getMappedStyle("rowendheader"))).root,m=a.endRoot;e.insertBefore(c,t),e.insertBefore(m,t);var u=this.buildDatabody();if(e.insertBefore(u,t),l&&(h.style.direction="rtl",u.style.direction="rtl"),this.m_isResizing=!1,this.m_resizingElement=null,this.m_resizingElementMin=null,this.m_databodyDragState=!1,this.m_docMouseMoveListener=this.handleMouseMove.bind(this),this.m_docMouseUpListener=this.handleMouseUp.bind(this),this.m_utils.isTouchDevice())u.addEventListener("touchstart",this.handleTouchStart.bind(this),{passive:!0}),u.addEventListener("touchmove",this.handleTouchMove.bind(this),{passive:!1}),u.addEventListener("touchend",this.handleTouchEnd.bind(this),!1),u.addEventListener("touchcancel",this.handleTouchCancel.bind(this),!1),h.addEventListener("touchstart",this.handleHeaderTouchStart.bind(this),{passive:!0}),h.addEventListener("touchmove",this.handleHeaderTouchMove.bind(this),{passive:!1}),h.addEventListener("touchend",this.handleHeaderTouchEnd.bind(this),!1),h.addEventListener("touchcancel",this.handleHeaderTouchCancel.bind(this),!1),c.addEventListener("touchstart",this.handleHeaderTouchStart.bind(this),{passive:!0}),c.addEventListener("touchmove",this.handleHeaderTouchMove.bind(this),{passive:!1}),c.addEventListener("touchend",this.handleHeaderTouchEnd.bind(this),!1),c.addEventListener("touchcancel",this.handleHeaderTouchCancel.bind(this),!1),d.addEventListener("touchstart",this.handleHeaderTouchStart.bind(this),{passive:!0}),d.addEventListener("touchmove",this.handleHeaderTouchMove.bind(this),{passive:!1}),d.addEventListener("touchend",this.handleHeaderTouchEnd.bind(this),!1),d.addEventListener("touchcancel",this.handleHeaderTouchCancel.bind(this),!1),m.addEventListener("touchstart",this.handleHeaderTouchStart.bind(this),{passive:!0}),m.addEventListener("touchmove",this.handleHeaderTouchMove.bind(this),{passive:!1}),m.addEventListener("touchend",this.handleHeaderTouchEnd.bind(this),!1),m.addEventListener("touchcancel",this.handleHeaderTouchCancel.bind(this),!1);else{var _=this.m_utils.getMousewheelEvent();u.addEventListener(_,this.handleDatabodyMouseWheel.bind(this),{passive:!1}),u.addEventListener("mousedown",this.handleDatabodyMouseDown.bind(this),!1),u.addEventListener("mousemove",this.handleDatabodyMouseMove.bind(this),!1),u.addEventListener("mouseup",this.handleDatabodyMouseUp.bind(this),!1),u.addEventListener("mouseout",this.handleDatabodyMouseOut.bind(this),!1),u.addEventListener("mouseover",this.handleDatabodyMouseOver.bind(this),!1),u.addEventListener("dblclick",this.handleDatabodyDoubleClick.bind(this),!1),c.addEventListener(_,this.handleDatabodyMouseWheel.bind(this),{passive:!1}),h.addEventListener(_,this.handleDatabodyMouseWheel.bind(this),{passive:!1}),c.addEventListener("mousedown",this.handleHeaderMouseDown.bind(this),!1),h.addEventListener("mousedown",this.handleHeaderMouseDown.bind(this),!1),c.addEventListener("mouseover",this.handleHeaderMouseOver.bind(this),!1),h.addEventListener("mouseover",this.handleHeaderMouseOver.bind(this),!1),c.addEventListener("mousemove",this.handleRowHeaderMouseMove.bind(this),!1),h.addEventListener("mousemove",this.handleColumnHeaderMouseMove.bind(this),!1),c.addEventListener("mouseup",this.handleHeaderMouseUp.bind(this),!1),h.addEventListener("mouseup",this.handleHeaderMouseUp.bind(this),!1),c.addEventListener("mouseout",this.handleHeaderMouseOut.bind(this),!1),h.addEventListener("mouseout",this.handleHeaderMouseOut.bind(this),!1),c.addEventListener("click",this.handleHeaderClick.bind(this),!1),c.addEventListener("dblclick",this.handleHeaderDoubleClick.bind(this),!1),h.addEventListener("click",this.handleHeaderClick.bind(this),!1),h.addEventListener("dblclick",this.handleHeaderDoubleClick.bind(this),!1),m.addEventListener(_,this.handleDatabodyMouseWheel.bind(this),{passive:!1}),d.addEventListener(_,this.handleDatabodyMouseWheel.bind(this),{passive:!1}),m.addEventListener("mousedown",this.handleHeaderMouseDown.bind(this),!1),d.addEventListener("mousedown",this.handleHeaderMouseDown.bind(this),!1),m.addEventListener("mouseover",this.handleHeaderMouseOver.bind(this),!1),d.addEventListener("mouseover",this.handleHeaderMouseOver.bind(this),!1),m.addEventListener("mousemove",this.handleRowHeaderMouseMove.bind(this),!1),d.addEventListener("mousemove",this.handleColumnHeaderMouseMove.bind(this),!1),m.addEventListener("mouseup",this.handleHeaderMouseUp.bind(this),!1),d.addEventListener("mouseup",this.handleHeaderMouseUp.bind(this),!1),m.addEventListener("mouseout",this.handleHeaderMouseOut.bind(this),!1),d.addEventListener("mouseout",this.handleHeaderMouseOut.bind(this),!1),m.addEventListener("click",this.handleHeaderClick.bind(this),!1),m.addEventListener("dblclick",this.handleHeaderDoubleClick.bind(this),!1),d.addEventListener("click",this.handleHeaderClick.bind(this),!1),d.addEventListener("dblclick",this.handleHeaderDoubleClick.bind(this),!1)}this._shouldInitialize()&&this._handleInitialization(!0)}else{var p=this._buildEmptyText();this.m_root.appendChild(p),this._handleInitialization(!1)}},I.prototype.HandleResize=function(e,t){e=this.getRootElement().clientWidth,t=this.getRootElement().clientHeight,e===this.m_width&&t===this.m_height||(this.m_width=e,this.m_height=t,this.m_rowFetchSize=null,this.m_columnFetchSize=null,this.m_initialized&&(this.resizeGrid(),this.isFetchComplete()&&(this.m_resizeRequired=!0,this.fillViewport())))},I.prototype.resizeGrid=function(){var e,t,i,s=this.getWidth(),n=this.getHeight(),o=this.m_colHeader,r=this.m_colEndHeader,l=this.m_rowHeader,a=this.m_rowEndHeader,h=this.m_databody,d=h.firstChild,c=this.getColumnHeaderHeight(),m=this.getColumnEndHeaderHeight(),u=this.getRowHeaderWidth(),_=n-c-m,p=s-u-this.getRowEndHeaderWidth(),g=this.m_utils.getScrollbarSize();this._databodyEmpty()&&(null==this.m_empty?(e=this._buildEmptyText(),this.m_root.appendChild(e)):e=this.m_empty,t=this.getElementHeight(e),i=this.getElementWidth(e),t>this.getElementHeight(d)&&this.setElementHeight(d,t),i>this.getElementWidth(d)&&this.setElementWidth(d,i));var f,C,y,v,E,S=this.getElementWidth(h.firstChild),w=this.getElementHeight(h.firstChild),H=this.isDatabodyHorizontalScrollbarRequired(p);if(H)f=this.isDatabodyVerticalScrollbarRequired(_-g),h.style.overflow="auto";else if(f=this.isDatabodyVerticalScrollbarRequired(_))H=this.isDatabodyHorizontalScrollbarRequired(p-g),h.style.overflow="auto";else{this.m_handleScrollOverflow=!1;var b=this;setTimeout(function(){b.m_handleScrollOverflow||b.m_hasVerticalScroller||b.m_hasHorizontalScroller||(h.style.overflow="hidden",b.m_handleScrollOverflow=!0)},10)}this.m_hasHorizontalScroller=H,this.m_hasVerticalScroller=f,-1!==this.m_endColEndHeader?(C=Math.min(w+(H?g:0),_),y=H?C-g:C):(C=_,y=Math.min(w,H?C-g:C)),-1!==this.m_endRowEndHeader?(v=Math.min(S+(f?g:0),p),E=f?v-g:v):(v=p,E=Math.min(S,f?v-g:v));var x=u+E+(f?g:0),R=c+y+(H?g:0),M=this.getResources().isRTLMode()?"right":"left";this.setElementDir(l,0,M),this.setElementDir(l,c,"top"),this.setElementHeight(l,y),this.setElementDir(a,x,M),this.setElementDir(a,c,"top"),this.setElementHeight(a,y),this.setElementDir(o,u,M),this.setElementWidth(o,E),this.setElementDir(r,u,M),this.setElementDir(r,R,"top"),this.setElementWidth(r,E),this.setElementDir(h,c,"top"),this.setElementDir(h,u,M),this.setElementWidth(h,v),this.setElementHeight(h,C),this.m_scrollWidth=S-E,this.m_scrollHeight=w-y,this.buildCorners(),this._adjustHeaderBorders(),this._updateGridlines(),this.m_resizeRequired=!1},I.prototype._sizeDatabodyScroller=function(){var e,t,i=this.m_databody,s=i.firstChild,n=this._databodyEmpty(),o=this._isHighWatermarkScrolling(),r=this.m_utils._getMaxDivHeightForScrolling(),l=this.m_utils._getMaxDivWidthForScrolling(),a=this.getDataSource().getCount("row"),h=this.getDataSource().getCount("column"),d=0,c=0;n?(d=Math.max(Math.max(this.m_endRowHeaderPixel,this.m_endRowEndHeaderPixel),1),c=Math.max(Math.max(this.m_endColHeaderPixel,this.m_endColEndHeaderPixel),1)):(d=this.m_endRowPixel,c=this.m_endColPixel),e=-1===a||o?d:a*this.m_avgRowHeight,t=-1===h||o?c:h*this.m_avgColWidth,this.setElementHeight(s,Math.min(r,e)),this.setElementWidth(s,Math.min(l,t)),this.m_initialized&&(this.m_scrollWidth=this.getElementWidth(s)-Math.min(this.getElementWidth(s),this.getElementWidth(i)-(this.m_hasVerticalScroller?this.m_utils.getScrollbarSize():0)),this.m_scrollHeight=this.getElementHeight(s)-Math.min(this.getElementHeight(s),this.getElementHeight(i)-(this.m_hasHorizontalScroller?this.m_utils.getScrollbarSize():0)))},I.prototype._adjustLastHeadersAlongAxis=function(e,t,i,s,n,o){for(var r=0;r<t;){var l=this._getHeaderByIndex(e,r,i,t,s);o?this.m_utils.removeCSSClassName(l,n):this.m_utils.addCSSClassName(l,n),r+=this.getHeaderCellDepth(l)}},I.prototype._adjustHeaderBordersAlongAxis=function(e,t,i,s,n,o,r,l){null!=e&&i>=0&&(s?this.m_utils.addCSSClassName(n,o):this.m_utils.removeCSSClassName(n,o),t(i)&&this._adjustLastHeadersAlongAxis(i,r,e,l,o,s))},I.prototype._adjustHeaderBorders=function(){var e,t,i,s,n,o=this.m_utils.getScrollbarSize(),r=this.getWidth(),l=this.getHeight(),a=this.getColumnHeaderHeight(),h=this.getElementWidth(this.m_colHeader),d=this.getColumnEndHeaderHeight(),c=this.getRowHeaderWidth(),m=this.getElementHeight(this.m_rowHeader),u=c+h+this.getRowEndHeaderWidth()+(this.m_hasVerticalScroller?o:0)<r,_=a+m+d+(this.m_hasHorizontalScroller?o:0)<l;if(u&&this.m_endRowEndHeader>=0?(e=!0,this.m_addBorderRight=!0):!0===this.m_addBorderRight&&(e=!1),null!=e)for(t=this.getMappedStyle("borderVerticalSmall"),null!=this.m_columnHeaderScrollbarSpacer&&(e?this.m_utils.addCSSClassName(this.m_columnHeaderScrollbarSpacer,t):this.m_utils.removeCSSClassName(this.m_columnHeaderScrollbarSpacer,t)),null!=this.m_bottomCorner&&(e?this.m_utils.addCSSClassName(this.m_bottomCorner,t):this.m_utils.removeCSSClassName(this.m_bottomCorner,t)),s=this.m_rowEndHeader.firstChild.childNodes,i=0;i<s.length;i++)e?this.m_utils.addCSSClassName(s[i],t):this.m_utils.removeCSSClassName(s[i],t);else t=this.getMappedStyle("borderVerticalNone"),n=this._isLastColumn.bind(this),this._adjustHeaderBordersAlongAxis(this.m_colHeader,n,this.m_endColHeader,u,this.m_columnHeaderScrollbarSpacer,t,this.m_columnHeaderLevelCount,this.m_startColHeader),this._adjustHeaderBordersAlongAxis(this.m_colEndHeader,n,this.m_endColEndHeader,u,this.m_bottomCorner,t,this.m_columnEndHeaderLevelCount,this.m_startColEndHeader);if(e=null,_&&this.m_endColEndHeader>=0?(this.m_addBorderBottom=!0,e=!0):!0===this.m_addBorderBottom&&(e=!1),null!=e)for(t=this.getMappedStyle("borderHorizontalSmall"),null!=this.m_rowHeaderScrollbarSpacer&&(e?this.m_utils.addCSSClassName(this.m_rowHeaderScrollbarSpacer,t):this.m_utils.removeCSSClassName(this.m_rowHeaderScrollbarSpacer,t)),null!=this.m_bottomCorner&&(e?this.m_utils.addCSSClassName(this.m_bottomCorner,t):this.m_utils.removeCSSClassName(this.m_bottomCorner,t)),s=this.m_colEndHeader.firstChild.childNodes,i=0;i<s.length;i++)e?this.m_utils.addCSSClassName(s[i],t):this.m_utils.removeCSSClassName(s[i],t);else t=this.getMappedStyle("borderHorizontalNone"),n=this._isLastRow.bind(this),this._adjustHeaderBordersAlongAxis(this.m_rowHeader,n,this.m_endRowHeader,_,this.m_rowHeaderScrollbarSpacer,t,this.m_rowHeaderLevelCount,this.m_startRowHeader),this._adjustHeaderBordersAlongAxis(this.m_rowEndHeader,n,this.m_endRowEndHeader,_,this.m_bottomCorner,t,this.m_rowEndHeaderLevelCount,this.m_startRowEndHeader)},I.prototype._isHeaderLabelCollision=function(){return this.m_headerLabels.column[this.m_columnHeaderLevelCount-1]&&this.m_headerLabels.row[this.m_rowHeaderLevelCount-1]},I.prototype.buildCorners=function(){var e,t,i,s,n,o,r=this.m_utils.getScrollbarSize(),l=this.getWidth(),a=this.getHeight(),h=this.getColumnHeaderHeight(),d=this.getElementWidth(this.m_colHeader),c=this.getColumnEndHeaderHeight(),m=this.getRowHeaderWidth(),u=this.getRowEndHeaderWidth(),_=this.getElementHeight(this.m_rowHeader),p=this.getResources().isRTLMode()?"right":"left";if(-1!==this.m_endRowHeader&&-1!==this.m_endColHeader)if(null!=this.m_corner?e=this.m_corner:((e=document.createElement("div")).id=this.createSubId("corner"),e.className=this.getMappedStyle("topcorner")),this.setElementWidth(e,m),this.setElementHeight(e,h),null==this.m_corner){this.m_utils.isTouchDevice()?e.addEventListener("touchstart",this.handleCornerMouseDown.bind(this),{passive:!0}):(e.addEventListener("mousedown",this.handleCornerMouseDown.bind(this),!1),e.addEventListener("mouseover",this.handleCornerMouseOver.bind(this),!1),e.addEventListener("mouseout",this.handleCornerMouseOut.bind(this),!1)),e.addEventListener("click",this.handleCornerClick.bind(this),!1),this.m_root.appendChild(e),this.m_corner=e;var g=this.m_headerLabels.column.length?this.m_columnHeaderLevelHeights[this.m_columnHeaderLevelCount-1]:this.m_colHeaderHeight;for(o=0;o<this.m_headerLabels.row.length;o++)null!=(n=this.m_headerLabels.row[o])&&(this.setElementHeight(n,g),e.appendChild(n));for(g=this.m_headerLabels.row.length?this.m_rowHeaderLevelWidths[this.m_rowHeaderLevelCount-1]:this.m_rowHeaderWidth,o=0;o<this.m_headerLabels.column.length;o++)null!=(n=this.m_headerLabels.column[o])&&(this.setElementWidth(n,g),e.appendChild(n));if(this.m_subtreeAttachedCallback(e),this._isHeaderLabelCollision()){var f=this._getHeaderByIndex(this.m_startColHeader,this.m_columnHeaderLevelCount-1,this.m_colHeader,this.m_columnHeaderLevelCount,this.m_startColHeader),C=this.getElementHeight(f);return this.m_colHeaderHeight+=C,this.m_columnHeaderLevelHeights[this.m_columnHeaderLevelCount-1]+=C,this.resizeColumnHeightsAndShift(C,this.m_columnHeaderLevelCount-1,!1),this.setElementHeight(this.m_colHeader,this.m_colHeaderHeight),void this.manageResizeScrollbars()}}else{this.m_utils.isTouchDevice()?(e.addEventListener("touchstart",this.handleHeaderLabelMouseDown.bind(this),!1),e.addEventListener("touchmove",this.handleHeaderLabelMouseMove.bind(this),!1)):(e.addEventListener("mousedown",this.handleHeaderLabelMouseDown.bind(this),!1),e.addEventListener("mousemove",this.handleHeaderLabelMouseMove.bind(this),!1))}else this.m_headerLabels.row=[],this.m_headerLabels.column=[];if(null!=this.m_corner&&null==e&&(this.m_root.removeChild(this.m_corner),this.m_corner=null),-1!==this.m_endRowHeader)if(this.m_hasHorizontalScroller||-1!==this.m_endColEndHeader){if(null!=this.m_rowHeaderScrollbarSpacer?i=this.m_rowHeaderScrollbarSpacer:((i=document.createElement("div")).id=this.createSubId("rhSbSpacer"),i.className=this.getMappedStyle("rowheaderspacer")),this.setElementDir(i,_+h,"top"),this.setElementDir(i,0,p),this.setElementWidth(i,this.m_rowHeaderWidth),-1!==this.m_endColEndHeader?this.setElementHeight(i,c+(this.m_hasHorizontalScroller?r:0)):this.setElementHeight(i,a-_-h),null==this.m_rowHeaderScrollbarSpacer){for(this.m_utils.isTouchDevice()?i.addEventListener("touchstart",this.handleCornerMouseDown.bind(this),{passive:!0}):(i.addEventListener("mousedown",this.handleCornerMouseDown.bind(this),!1),i.addEventListener("mouseover",this.handleCornerMouseOver.bind(this),!1),i.addEventListener("mouseout",this.handleCornerMouseOut.bind(this),!1),"disable"!==this.isResizeEnabled()&&(i.addEventListener("mousedown",this.handleHeaderLabelMouseDown.bind(this),!1),i.addEventListener("mousemove",this.handleHeaderLabelMouseMove.bind(this),!1))),this.m_root.appendChild(i),this.m_rowHeaderScrollbarSpacer=i,o=0;o<this.m_headerLabels.columnEnd.length;o++)null!=(n=this.m_headerLabels.columnEnd[o])&&i.appendChild(n);this.m_subtreeAttachedCallback(i)}}else null!=this.m_rowHeaderScrollbarSpacer&&this.m_root.removeChild(this.m_rowHeaderScrollbarSpacer),this.m_rowHeaderScrollbarSpacer=null,this.m_headerLabels.columnEnd=[];if(-1!==this.m_endColHeader)if(this.m_hasVerticalScroller||-1!==this.m_endRowEndHeader){if(null!=this.m_columnHeaderScrollbarSpacer?s=this.m_columnHeaderScrollbarSpacer:((s=document.createElement("div")).id=this.createSubId("chSbSpacer"),s.className=this.getMappedStyle("colheaderspacer")),this.setElementDir(s,m+d,p),this.setElementDir(s,0,"top"),-1!==this.m_endRowEndHeader?this.setElementWidth(s,u+(this.m_hasVerticalScroller?r:0)):this.setElementWidth(s,l-d-m),this.setElementHeight(s,this.m_colHeaderHeight),null==this.m_columnHeaderScrollbarSpacer){for(this.m_utils.isTouchDevice()?s.addEventListener("touchstart",this.handleCornerMouseDown.bind(this),{passive:!0}):(s.addEventListener("mousedown",this.handleCornerMouseDown.bind(this),!1),s.addEventListener("mouseover",this.handleCornerMouseOver.bind(this),!1),s.addEventListener("mouseout",this.handleCornerMouseOut.bind(this),!1),"disable"!==this.isResizeEnabled()&&(s.addEventListener("mousedown",this.handleHeaderLabelMouseDown.bind(this),!1),s.addEventListener("mousemove",this.handleHeaderLabelMouseMove.bind(this),!1))),this.m_root.appendChild(s),this.m_columnHeaderScrollbarSpacer=s,o=0;o<this.m_headerLabels.rowEnd.length;o++)null!=(n=this.m_headerLabels.rowEnd[o])&&s.appendChild(n);this.m_subtreeAttachedCallback(s)}}else null!=this.m_columnHeaderScrollbarSpacer&&this.m_root.removeChild(this.m_columnHeaderScrollbarSpacer),this.m_columnHeaderScrollbarSpacer=null,this.m_headerLabels.rowEnd=[];(this.m_hasHorizontalScroller&&this.m_hasVerticalScroller||this.m_hasVerticalScroller&&-1!==this.m_endColEndHeader||this.m_hasHorizontalScroller&&-1!==this.m_endRowEndHeader||-1!==this.m_endRowEndHeader&&-1!==this.m_endColEndHeader)&&(null!=this.m_bottomCorner?t=this.m_bottomCorner:((t=document.createElement("div")).id=this.createSubId("bcorner"),t.className=this.getMappedStyle("bottomcorner")),this.setElementDir(t,_+h,"top"),this.setElementDir(t,m+d,p),-1!==this.m_endRowEndHeader?this.setElementWidth(t,u+(this.m_hasVerticalScroller?r:0)):this.setElementWidth(t,l-d-m),-1!==this.m_endColEndHeader?this.setElementHeight(t,c+(this.m_hasHorizontalScroller?r:0)):this.setElementHeight(t,a-_-h),null==this.m_bottomCorner&&(this.m_root.appendChild(t),this.m_bottomCorner=t)),null!=this.m_bottomCorner&&null==t&&(this.m_root.removeChild(this.m_bottomCorner),this.m_bottomCorner=null)},I.prototype._updateScrollPosition=function(e){this._scrollToScrollPositionObject(e)},I.prototype._setScrollPosition=function(){this.m_setOptionCallback("scrollPosition",this._createScrollPositionObject(this.m_currentScrollLeft,this.m_currentScrollTop),{_context:{writeback:!0,internalSet:!0}})},I.prototype._clearScrollPositionKeys=function(){var e=this.m_options.getScrollPosition();e.rowKey=void 0,e.columnKey=void 0,this.m_setOptionCallback("scrollPosition",e,{_context:{internalSet:!0}})},I.prototype._createScrollPositionObject=function(e,t){var i={x:e,y:t},s=this.getResources().isRTLMode()?"right":"left",n=this._getCellAtPixel(e,t);if(null!=n)i.rowIndex=this._getIndex(n,"row"),i.columnIndex=this._getIndex(n,"column"),i.rowKey=this._getKey(n,"row"),i.columnKey=this._getKey(n,"column"),i.offsetX=e-this.getElementDir(n,s),i.offsetY=t-this.getElementDir(n,"top");else{var o=this._getHeaderAtPixel(t,"row");null!=o&&(i.rowIndex=this._getIndex(o),i.rowKey=this._getKey(o),i.offsetY=t-this.getElementDir(o,"top"));var r=this._getHeaderAtPixel(e,"column");null!=r&&(i.columnIndex=this._getIndex(r),i.columnKey=this._getKey(r),i.offsetX=e-this.getElementDir(r,s))}return i},I.prototype._getCellAtPixel=function(e,t){for(var i=this.m_databody.firstChild.childNodes,s=this.getResources().isRTLMode()?"right":"left",n=0;n<i.length;n++){var o=i[n],r=this.getElementDir(o,s),l=r+this.getElementWidth(o);if(r<=e&&e<l){var a=this.getElementDir(o,"top"),h=a+this.getElementHeight(o);if(a<=t&&t<h)return o}}return null},I.prototype._getAxisInnerMostHeaders=function(e){var t,i,s=this.getMappedStyle("headercell");switch(e){case"row":t=this.m_rowHeader,i=this.m_rowHeaderLevelCount;break;case"column":t=this.m_colHeader,i=this.m_columnHeaderLevelCount;break;case"rowEnd":t=this.m_rowEndHeader,i=this.m_rowEndHeaderLevelCount;break;case"columnEnd":t=this.m_colEndHeader,i=this.m_columnEndHeaderLevelCount}var n=[];if(t)for(var o=t.getElementsByClassName(s),r=0;r<o.length;r++){var l=o[r],a=l[this.getResources().getMappedAttribute("context")];a.level+a.depth===i&&n.push(l)}return n},I.prototype._getHeaderAtPixel=function(e,t){var i,s,n,o,r=this;function l(t){for(var i=0;i<t.length;i++){var s=t[i],l=r.getElementDir(s,n),a=l+r.getElementDir(s,o);if(l<=e&&e<a)return s}}i=this._getAxisInnerMostHeaders(t),s=this._getAxisInnerMostHeaders(t+"End"),"row"===t?(n="top",o="height"):"column"===t&&(n=this.getResources().isRTLMode()?"right":"left",o="width");var a=l(i);return null==a&&(a=l(s)),a},I.prototype._checkScrollPosition=function(){null!=this.m_desiredScrollPositionObject?this._scrollToScrollPositionObject(this.m_desiredScrollPositionObject):this._setScrollPosition()},I.prototype._areKeysLocallyAvailable=function(e,t){var i=!0;return e&&null==this._getCellOrHeaderByKey(e,"row")&&(i=!1),t&&null==this._getCellOrHeaderByKey(t,"column")&&(i=!1),i},I.prototype._scrollToScrollPositionObject=function(e){var t=e.x,i=e.y,s=e.rowIndex,n=e.columnIndex,o=e.rowKey,r=e.columnKey,l=e.offsetX?e.offsetX:0,a=e.offsetY?e.offsetY:0,h=this.getResources().isRTLMode()?"right":"left",d=this.m_options.getScrollToKey();if("never"!==d||!o&&!r){if("always"!==d)if(this.getDataSource()instanceof E&&!this._areKeysLocallyAvailable(o,r)){var c=this.m_options.getProperty("data").getCapability("fetchFirst");if(null==c||"immediate"!==c.iterationSpeed)return}var m=this;this._getIndexFromKeyPromise(o,r).then(function(d){var c=Math.floor(m._getPositionEstimate("column",h,r,d.columnIndexFromKey,n,t,l,m.m_currentScrollLeft,m._getMaxRightPixel(),m.m_avgColWidth)),u=Math.floor(m._getPositionEstimate("row","top",o,d.rowIndexFromKey,s,i,a,m.m_currentScrollTop,m._getMaxBottomPixel(),m.m_avgRowHeight));c!==m.m_currentScrollLeft&&(m.m_currentScrollLeft!==m.m_scrollWidth||c<m.m_currentScrollLeft)||u!==m.m_currentScrollTop&&(m.m_currentScrollTop!==m.m_scrollHeight||u<m.m_currentScrollTop)?(null==m.m_desiredScrollPositionObject&&m._signalTaskStart("begin scrolling to new desired location"),m.m_desiredScrollPositionObject=e,m._setScrollPositionTimeout(),m._initiateScroll(c,u)):(null!=m.m_desiredScrollPositionObject&&m._signalTaskEnd("reached desired location"),m.m_desiredScrollPositionObject=null,m._setScrollPosition())})}},I.prototype._setScrollPositionTimeout=function(){this.m_utils.isTouchDevice()||(this.pendingScrollTimeout=setTimeout(function(){null!=this.m_desiredScrollPositionObject&&this._signalTaskEnd("reached desired location"),this.m_desiredScrollPositionObject=null,this._setScrollPosition()}.bind(this),300))},I.prototype._clearScrollPositionTimeout=function(){null!=this.pendingScrollTimeout&&(clearTimeout(this.pendingScrollTimeout),this.pendingScrollTimeout=null)},I.prototype._getPositionEstimate=function(e,t,i,s,n,o,r,l,a,h){var d,c,m=this._isHighWatermarkScrolling();return null!=i&&-1!==s&&(null!=(c=this._getCellOrHeaderByKey(i,e))?d=this.getElementDir(c,t)+r:m?d=a:null!=s&&(d=h*s+r),null!=d)?d:d=null!=n?null!=(c=this._getCellOrHeaderByIndex(n,e))?this.getElementDir(c,t)+r:m?a:h*n:null!=o?o:l},I.prototype.isDatabodyHorizontalScrollbarRequired=function(e){var t=this.m_databody.firstChild;return this.getElementWidth(t)>e},I.prototype.isDatabodyVerticalScrollbarRequired=function(e){var t=this.m_databody.firstChild;return this.getElementHeight(t)>e},I.prototype.buildStatus=function(){var e=document.createElement("div");e.className=this.getMappedStyle("loadingicon");var t=document.createElement("div");return t.id=this.createSubId("status"),t.className=this.getMappedStyle("status"),t.setAttribute("role","status"),t.appendChild(e),t},I.prototype.buildAccInfo=function(){var e=document.createElement("div");return e.id=this.createSubId("info"),e.className=this.getMappedStyle("info"),e.setAttribute("role","status"),e},I.prototype.buildAccSummary=function(){var e=document.createElement("div");return e.id=this.createSubId("summary"),e.className=this.getMappedStyle("info"),e},I.prototype.buildStateInfo=function(){var e=document.createElement("div");return e.id=this.createSubId("state"),e.className=this.getMappedStyle("info"),e},I.prototype.buildContextInfo=function(){var e=document.createElement("div");return e.id=this.createSubId("context"),e.className=this.getMappedStyle("info"),e},I.prototype.buildPlaceHolder=function(){var e=document.createElement("div");return e.id=this.createSubId("placeHolder"),e.className=this.getMappedStyle("info"),e},I.prototype.populateAccInfo=function(){var e=this.getResources().getTranslatedText("accessibleSummaryExact",{rownum:this.m_endRow+1,colnum:this.m_endCol+1});this.getDataSource().getExpandedKeys&&(e=e+". "+this.getResources().getTranslatedText("accessibleSummaryExpanded",{num:this.getDataSource().getExpandedKeys().length}));e+=". ",this.m_accSummary.textContent=e},I.prototype.SetAccessibleContext=function(e){if(null!=e&&(null!=e.context&&(this.m_accessibleContext=e.context),null!=e.state&&(this.m_stateInfo.textContent=e.state),null!=e.ancestors&&this._isDatabodyCellActive())){var t="",i=e.ancestors,s=this.m_active.indexes.column;if(null!=s&&s>=0)for(var n=0;n<i.length;n++){n>0&&(t=t.concat(", "));var o=i[n],r=this._getAxisCellsByKey(o.key,"row");if(null!=r){var l=r[0].textContent;l=null!=l?l.replace(/\n|<br\s*\/?>/gi,"").trim():"",t=t.concat(o.label).concat(" ").concat(l)}}this.m_accessibleContext=t.concat(", ").concat(this.m_accessibleContext)}},I.prototype._updateStateInfo=function(e){for(var t=". ",i=0;i<e.length;i++){var s=this.getResources().getTranslatedText(e[i].key,e[i].args);null!=s&&(t=2===t.length?t+s:t+", "+s)}t=2===t.length?t:t+". ",this.m_stateInfo.textContent=t},I.prototype._updateContextInfo=function(e,t){var i,s;e.indexes&&(i=e.indexes.row,s=e.indexes.column);var n=e.level,o=e.rowHeader,r=e.rowEndHeader,l=e.columnHeader,a=e.columnEndHeader,h=e.rowHeaderLabel,d=e.rowEndHeaderLabel,c=e.columnHeaderLabel,m=e.columnEndHeaderLabel,u="";null!=this.m_accessibleContext||isNaN(i)||"row"===t||(u=this._updateAccessibleInfoString(u,"accessibleRowContext",{index:i+1})),isNaN(s)||"column"===t||(u=this._updateAccessibleInfoString(u,"accessibleColumnContext",{index:s+1})),isNaN(o)||(u=this._updateAccessibleInfoString(u,"accessibleRowHeaderContext",{index:o+1})),isNaN(l)||(u=this._updateAccessibleInfoString(u,"accessibleColumnHeaderContext",{index:l+1})),isNaN(r)||(u=this._updateAccessibleInfoString(u,"accessibleRowEndHeaderContext",{index:r+1})),isNaN(a)||(u=this._updateAccessibleInfoString(u,"accessibleColumnEndHeaderContext",{index:a+1})),isNaN(h)||(u=this._updateAccessibleInfoString(u,"accessibleRowHeaderLabelContext",{level:h+1})),isNaN(c)||(u=this._updateAccessibleInfoString(u,"accessibleColumnHeaderLabelContext",{level:c+1})),isNaN(d)||(u=this._updateAccessibleInfoString(u,"accessibleRowEndHeaderLabelContext",{level:d+1})),isNaN(m)||(u=this._updateAccessibleInfoString(u,"accessibleColumnEndHeaderLabelContext",{level:m+1})),isNaN(n)||(u=this._updateAccessibleInfoString(u,"accessibleLevelContext",{level:n+1})),u=0===u.length?u:u+". ",null!=this.m_accessibleContext&&(u+=this.m_accessibleContext,this.m_accessibleContext=null),this.m_contextInfo.textContent=u},I.prototype._updateAccessibleInfoString=function(e,t,i){var s=this.getResources().getTranslatedText(t,i);return null!=s?0===e.length?s:e+", "+s:e},I.prototype._isCountUnknown=function(e){var t=this.getDataSource();if("row"===e||"rowEnd"===e){var i=t.getCountPrecision("row"),s=t.getCount("row");return this.m_isEstimateRowCount="estimate"===i||s<0,this.m_isEstimateRowCount}if("column"===e||"columnEnd"===e){var n=t.getCountPrecision("column"),o=t.getCount("column");return this.m_isEstimateColumnCount="estimate"===n||o<0,this.m_isEstimateColumnCount}return!1},I.prototype._isCountUnknownOrHighwatermark=function(e){return this._isCountUnknown(e)||this._isHighWatermarkScrolling()},I.prototype._hideHeader=function(e){e.style.display="none"},I.prototype._showHeader=function(e){e.style.display=""},I.prototype.buildHeaders=function(e,t,i){var s=this.getMappedStyle("scroller")+(this.m_utils.isTouchDevice()?" "+this.getMappedStyle("scroller-mobile"):""),n=document.createElement("div");n.id=this.createSubId(e+"Header"),n.className=t+" "+this.getMappedStyle("header");var o=document.createElement("div");o.className=s,n.appendChild(o);var r=document.createElement("div");r.id=this.createSubId(e+"EndHeader"),r.className=i+" "+this.getMappedStyle("endheader");var l=document.createElement("div");if(l.className=s,r.appendChild(l),"column"===e?(this.m_colHeader=n,this.m_colEndHeader=r):"row"===e&&(this.m_rowHeader=n,this.m_rowEndHeader=r),this._isHighWatermarkScrolling()){this.fetchHeaders(e,0,n,r,null,null)}else{var a=this,h=this.m_options.getScrollPosition();this._getIndexesFromScrollPosition(h).then(function(t){var i=t[e];"column"===e?(a.m_startColHeader=i,a.m_startColEndHeader=i):"row"===e&&(a.m_startRowHeader=i,a.m_startRowEndHeader=i),a.m_fetching[e]=!1,a.fetchHeaders(e,i,n,r,null,null)}),this.m_fetching[e]=!0}return{root:n,endRoot:r}},I.prototype.fetchHeaders=function(e,t,i,s,n,o){if(!this.m_fetching[e]){null==n&&(n=this.getFetchCount(e,t));var r,l={axis:e,start:t,count:n,header:i,endHeader:s};this.m_fetching[e]=l,r=null!=o&&null!=o.success?o.success:this.handleHeadersFetchSuccess,this.showStatusText(),this._signalTaskStart(),this.getDataSource().fetchHeaders(l,{success:r,error:this.handleHeadersFetchError},{success:this,error:this})}},I.prototype.isHeaderFetchResponseValid=function(e){var t=e.axis;return null!=this.m_fetching&&e===this.m_fetching[t]},I.prototype.isHeaderFetchResponseInViewport=function(e){if(!this.m_initialized)return!0;var t=e.axis,i=e.start;return("row"===t?this._getLongScrollStart(this.m_currentScrollTop,this.m_prevScrollTop,t):this._getLongScrollStart(this.m_currentScrollLeft,this.m_prevScrollLeft,t)).start===i},I.prototype.handleHeadersFetchSuccess=function(e,t,i,s){var n=this.m_options.getScrollPolicyOptions(),o=n?n.maxRowCount:null,r=n?n.maxColumnCount:null;if(this.isHeaderFetchResponseValid(t)){var l=t.axis;if(this.isLongScroll()&&!this.isHeaderFetchResponseInViewport(t))return this.m_fetching[l]=!1,this.m_headerInvalid=!0,void this._signalTaskEnd();this.m_fetching[l]=!1;var a=t.header,h=t.endHeader,d=t.start,c=this.getDataSource().getCount(l);"column"===l?(null!=e&&(this.buildColumnHeaders(a,e,d,c,!1,!1),(e.getCount()<t.count||r&&r>0&&r===d+e.getCount())&&(this.m_stopColumnHeaderFetch=!0)),this.m_endColHeader<0?(this._hideHeader(a),this.m_stopColumnHeaderFetch=!0,this.m_startColHeader=0):(this.m_hasColHeader=!0,this._buildHeaderLabels(l,e)),null!=i&&(this.buildColumnEndHeaders(h,i,d,c,!1,!1),(i.getCount()<t.count||r&&r>0&&r===d+i.getCount())&&(this.m_stopColumnEndHeaderFetch=!0)),this.m_endColEndHeader<0?(this._hideHeader(h),this.m_stopColumnEndHeaderFetch=!0,this.m_startColEndHeader=0):(this.m_hasColEndHeader=!0,this._buildHeaderLabels("columnEnd",i))):"row"===l&&(null!=e&&(this.buildRowHeaders(a,e,d,c,s,!1),(e.getCount()<t.count||o&&o>0&&o===d+e.getCount())&&(this.m_stopRowHeaderFetch=!0)),this.m_endRowHeader<0?(this._hideHeader(a),this.m_stopRowHeaderFetch=!0,this.m_startRowHeader=0):(this.m_hasRowHeader=!0,this._buildHeaderLabels(l,e)),null!=i&&(this.buildRowEndHeaders(h,i,d,c,s,!1),(i.getCount()<t.count||o&&o>0&&o===d+i.getCount())&&(this.m_stopRowEndHeaderFetch=!0)),this.m_endRowEndHeader<0?(this._hideHeader(h),this.m_stopRowEndHeaderFetch=!0,this.m_startRowEndHeader=0):(this.m_hasRowEndHeader=!0,this._buildHeaderLabels("rowEnd",i))),this.isFetchComplete()&&(this.hideStatusText(),this._shouldInitialize()&&!s&&this._handleInitialization(!0)),this.m_initialized&&this._sizeDatabodyScroller(),this._signalTaskEnd()}else this._signalTaskEnd()},I.prototype.handleHeadersFetchError=function(e,t){var i=t.axis;this.m_fetching[i]=!1,this._signalTaskEnd()},I.prototype.createHeaderContext=function(e,t,i,s,n,o,r,l){var a={axis:e,index:t,data:i};a.component=this,a.datasource=this.m_options.getProperty("data"),a.level=o,a.depth=l,a.extent=r,null!=n&&(a.parentElement=n);for(var h=Object.keys(s),d=0;d<h.length;d++){var c=h[d];a[c]=s[c]}return null!=this.m_createContextCallback&&this.m_createContextCallback.call(this,a),this.m_fixContextCallback.call(this,a)},I.prototype._createLabelContext=function(e,t,i,s){var n={axis:e,level:t,data:i};return n.component=this,n.datasource=this.m_options.getProperty("data"),null!=s&&(n.parentElement=s),null!=this.m_createContextCallback&&this.m_createContextCallback.call(this,n),this.m_fixContextCallback.call(this,n)},I.prototype._buildHeaderLabels=function(e,t){if(0===this.m_headerLabels[e].length&&t&&t.getLabel){var i,s=t.getLevelCount();"rowEnd"===e?i=this.getResources().isRTLMode()?"left":"right":"row"===e?i=this.getResources().isRTLMode()?"right":"left":"column"===e?i="top":"columnEnd"===e&&(i="bottom");var n=0;if(s>0)for(var o=0;o<s;o++){var r,l=document.createElement("div"),a=t.getLabel(o);if(r="row"===e||"rowEnd"===e?"row"===e?this.m_rowHeaderLevelWidths[o]:this.m_rowEndHeaderLevelWidths[o]:"column"===e?this.m_columnHeaderLevelHeights[o]:this.m_columnEndHeaderLevelHeights[o],null!=a){var h=this._createLabelContext(e,o,a,l);l.setAttribute(this.getResources().getMappedAttribute("container"),this.getResources().widgetName),l.setAttribute(this.getResources().getMappedAttribute("busyContext"),""),this._createUniqueId(l),l[this.getResources().getMappedAttribute("context")]=h;var d=this.m_options.getInlineStyle(e,h,!0);null!=d&&c.applyMergedInlineStyles(l,d,""),l.className=this.getMappedStyle("headerlabel")+" "+this.getMappedStyle(e.toLowerCase()+"headerlabel");var m=this.m_options.getStyleClass(e,h,!0);null!=m&&(l.className+=" "+m),"row"===e||"rowEnd"===e?("rowEnd"===e&&(l.style.height="100%"),this.setElementWidth(l,r),this.setElementDir(l,n,i),this.setElementDir(l,0,"bottom")):("columnEnd"===e&&(l.style.width="100%"),this.setElementHeight(l,r),this.setElementDir(l,n,i),this.setElementDir(l,0,this.getResources().isRTLMode()?"left":"right")),"enable"!==this.m_options.isResizable(e,"width")&&"enable"!==this.m_options.isResizable(e,"height")||this._setAttribute(l,"resizable","true");var u=this.getRendererOrTemplate(e,!0);this._renderContent(u,h,l,a,this.buildLabelTemplateContext(h,{})),this.m_headerLabels[e][o]=l}n+=r}}},I.prototype.buildLabelTemplateContext=function(e,t){return{item:{data:e.data,metadata:t.metadata},datasource:e.datasource}},I.prototype.buildHeaderTemplateContext=function(e,t){return{item:{data:e.data,depth:e.depth,extent:e.extent,index:e.index,level:e.level,metadata:t.metadata,axis:e.axis},datasource:e.datasource}},I.prototype.buildCellTemplateContext=function(e,t){return{item:{columnExtent:e.extents.column,columnIndex:e.indexes.column,data:e.data,metadata:t.metadata,rowExtent:e.extents.row,rowIndex:e.indexes.row},datasource:e.datasource,mode:e.mode}},I.prototype.getRendererOrTemplate=function(e,t){var i,s=this.m_options.getRenderer(e,t);return s||(i="cell"===e?"cellTemplate":t?e+"HeaderLabelTemplate":e+"HeaderTemplate",this._getItemTemplateBySlotName(i)||null)},I.prototype.buildColumnHeaders=function(e,t,i,s,n,o){if(null==this.m_columnHeaderLevelCount&&(this.m_columnHeaderLevelCount=t.getLevelCount()),0!==this.m_columnHeaderLevelCount){var r=t.getCount(),l=i>this.m_endColHeader;!1;var a=l?this.m_endColHeaderPixel:this.m_startColHeaderPixel,h=this.m_endColHeader,d=this.m_columnHeaderLevelCount,c=this.getMappedStyle("colheader")+" "+this.getMappedStyle("header"),m=this.getMappedStyle("headercell")+" "+this.getMappedStyle("colheadercell");!1;var u=this.buildAxisHeaders(e,t,"column",i,r,l,!1,null,a,h,d,c,m,!1),_=u.totalHeaderDimension,p=u.totalLevelDimension;if(0===_||0!==this.m_avgColWidth&&null!=this.m_avgColWidth||(this.m_avgColWidth=_/r),this.m_colHeaderHeight||(this.m_colHeaderHeight=p,this.setElementHeight(e,this.m_colHeaderHeight)),l?(this.m_endColHeader=i+r-1,this.m_endColHeaderPixel+=_):(this.m_startColHeader-=r,this.m_startColHeaderPixel-=_),-1===s&&(s=this.m_endColHeader),!this._isCountUnknown("column")&&this._isHighWatermarkScrolling()&&this.m_endColHeader+1>=s?this.m_stopColumnHeaderFetch=!0:this.m_stopColumnHeaderFetch=u.stopFetch,0===this.m_startColHeader&&0!==this.m_startColHeaderPixel&&(this._shiftHeadersAlongAxisInContainer(e.firstChild,0,-1*this.m_startColHeaderPixel,this.getResources().isRTLMode()?"right":"left",this.getMappedStyle("colheadercell")),this.m_endColHeaderPixel-=this.m_startColHeaderPixel,this.m_startColHeaderPixel=0),!this.m_initialized&&this.m_startColHeader>0){var g=Math.round(this.m_avgColWidth*this.m_startColHeader);this._shiftHeadersAlongAxisInContainer(e.firstChild,this.m_startColHeader,g-this.m_startColHeaderPixel,this.getResources().isRTLMode()?"right":"left",this.getMappedStyle("colheadercell")),this.m_endColHeaderPixel=g+_,this.m_startColHeaderPixel=g}}},I.prototype.buildColumnEndHeaders=function(e,t,i,s,n,o){if(null==this.m_columnEndHeaderLevelCount&&(this.m_columnEndHeaderLevelCount=t.getLevelCount()),0!==this.m_columnEndHeaderLevelCount){var r=t.getCount(),l=i>this.m_endColEndHeader;!1;var a=l?this.m_endColEndHeaderPixel:this.m_startColEndHeaderPixel,h=this.m_endColEndHeader,d=this.m_columnEndHeaderLevelCount,c=this.getMappedStyle("colendheader")+" "+this.getMappedStyle("endheader"),m=this.getMappedStyle("endheadercell")+" "+this.getMappedStyle("colendheadercell");!1;var u=this.buildAxisHeaders(e,t,"columnEnd",i,r,l,!1,null,a,h,d,c,m,!1),_=u.totalHeaderDimension,p=u.totalLevelDimension;if(0===_||0!==this.m_avgColWidth&&null!=this.m_avgColWidth||(this.m_avgColWidth=_/r),this.m_colEndHeaderHeight||(this.m_colEndHeaderHeight=p,this.setElementHeight(e,this.m_colEndHeaderHeight)),l?(this.m_endColEndHeader=i+(r-1),this.m_endColEndHeaderPixel+=_):(this.m_startColEndHeader-=r,this.m_startColEndHeaderPixel-=_),-1===s&&(s=this.m_endColEndHeader),!this._isCountUnknown("column")&&this._isHighWatermarkScrolling()&&this.m_endColEndHeader+1>=s?this.m_stopColumnEndHeaderFetch=!0:this.m_stopColumnEndHeaderFetch=u.stopFetch,0===this.m_startColEndHeader&&0!==this.m_startColEndHeaderPixel&&(this._shiftHeadersAlongAxisInContainer(e.firstChild,0,-1*this.m_startColEndHeaderPixel,this.getResources().isRTLMode()?"right":"left",this.getMappedStyle("colendheadercell")),this.m_endColEndHeaderPixel-=this.m_startColEndHeaderPixel,this.m_startColEndHeaderPixel=0),!this.m_initialized&&this.m_startColEndHeader>0){var g=Math.round(this.m_avgColWidth*this.m_startColEndHeader);this._shiftHeadersAlongAxisInContainer(e.firstChild,this.m_startColEndHeader,g-this.m_startColEndHeaderPixel,this.getResources().isRTLMode()?"right":"left",this.getMappedStyle("colendheadercell")),this.m_endColEndHeaderPixel=g+_,this.m_startColEndHeaderPixel=g}}},I.prototype.buildRowHeaders=function(e,t,i,s,n,o){if(null==this.m_rowHeaderLevelCount&&(this.m_rowHeaderLevelCount=t.getLevelCount()),0!==this.m_rowHeaderLevelCount){var r,l=t.getCount(),a=i>this.m_endRowHeader,h=a?this.m_endRowHeaderPixel:this.m_startRowHeaderPixel;n?(r=e.firstChild.childNodes[i-this.m_startRowHeader],h=this.getElementDir(r,"top")):r=null;var d=this.m_endRowHeader,c=this.m_rowHeaderLevelCount,m=this.getMappedStyle("rowheader")+" "+this.getMappedStyle("header"),u=this.getMappedStyle("headercell")+" "+this.getMappedStyle("rowheadercell"),_=this.buildAxisHeaders(e,t,"row",i,l,a,n,r,h,d,c,m,u,o),p=_.totalHeaderDimension,g=_.totalLevelDimension;if(o)return _;if(0===p||0!==this.m_avgRowHeight&&null!=this.m_avgRowHeight||(this.m_avgRowHeight=p/l),this.m_rowHeaderWidth||(this.m_rowHeaderWidth=g,this.setElementWidth(e,this.m_rowHeaderWidth)),a){if(-1!==this.m_endRowHeader&&0!==l){var f=e.firstChild.childNodes[this.m_endRowHeader-this.m_startRowHeader];null!=f&&this.m_utils.removeCSSClassName(f,this.getMappedStyle("borderHorizontalNone"))}this.m_endRowHeader=i+(l-1),this.m_endRowHeaderPixel+=p}else n?(i<this.m_startRowHeader&&(this.m_startRowHeader=i,this.m_startRowHeaderPixel=Math.max(0,this.m_startRowHeaderPixel-p)),this.m_endRowHeader+=l,this.m_endRowHeaderPixel=Math.max(0,this.m_endRowHeaderPixel+p),this.pushRowHeadersDown(r,p)):(this.m_startRowHeader=Math.max(0,this.m_startRowHeader-l),this.m_startRowHeaderPixel-=p);if(-1===s&&(s=this.m_endRowHeader),!this._isCountUnknown("row")&&this._isHighWatermarkScrolling()&&this.m_endRowHeader+1>=s?this.m_stopRowHeaderFetch=!0:this.m_stopRowHeaderFetch=_.stopFetch,0===this.m_startRowHeader&&0!==this.m_startRowHeaderPixel&&(this._shiftHeadersAlongAxisInContainer(e.firstChild,0,-1*this.m_startRowHeaderPixel,"top",this.getMappedStyle("rowheadercell")),this.m_endRowHeaderPixel-=this.m_startRowHeaderPixel,this.m_startRowHeaderPixel=0),!this.m_initialized&&this.m_startRowHeader>0){var C=Math.round(this.m_avgRowHeight*this.m_startRowHeader);this._shiftHeadersAlongAxisInContainer(e.firstChild,this.m_startRowHeader,C-this.m_startRowHeaderPixel,"top",this.getMappedStyle("rowheadercell")),this.m_endRowHeaderPixel=C+p,this.m_startRowHeaderPixel=C}}},I.prototype.buildRowEndHeaders=function(e,t,i,s,n,o){if(null==this.m_rowEndHeaderLevelCount&&(this.m_rowEndHeaderLevelCount=t.getLevelCount()),0!==this.m_rowEndHeaderLevelCount){var r,l=t.getCount(),a=i>this.m_endRowEndHeader,h=a?this.m_endRowEndHeaderPixel:this.m_startRowEndHeaderPixel;n?(r=e.firstChild.childNodes[i-this.m_startRowEndHeader],h=this.getElementDir(r,"top")):r=null;var d=this.m_endRowEndHeader,c=this.m_rowEndHeaderLevelCount,m=this.getMappedStyle("rowendheader")+" "+this.getMappedStyle("endheader"),u=this.getMappedStyle("endheadercell")+" "+this.getMappedStyle("rowendheadercell"),_=this.buildAxisHeaders(e,t,"rowEnd",i,l,a,n,r,h,d,c,m,u,o);if(o)return _;var p=_.totalHeaderDimension,g=_.totalLevelDimension;if(0===p||0!==this.m_avgRowHeight&&null!=this.m_avgRowHeight||(this.m_avgRowHeight=p/l),this.m_rowEndHeaderWidth||(this.m_rowEndHeaderWidth=g,this.setElementWidth(e,this.m_rowEndHeaderWidth)),a){if(-1!==this.m_endRowEndHeader&&0!==l){var f=e.firstChild.childNodes[this.m_endRowEndHeader-this.m_startRowEndHeader];null!=f&&this.m_utils.removeCSSClassName(f,this.getMappedStyle("borderHorizontalNone"))}this.m_endRowEndHeader=i+(l-1),this.m_endRowEndHeaderPixel+=p}else n?(i<this.m_startRowEndHeader&&(this.m_startRowEndHeader=i,this.m_startRowEndHeaderPixel=Math.max(0,this.m_startRowEndHeaderPixel-p)),this.m_endRowEndHeader+=l,this.m_endRowEndHeaderPixel=Math.max(0,this.m_endRowEndHeaderPixel+p),this.pushRowHeadersDown(r,p)):(this.m_startRowEndHeader=Math.max(0,this.m_startRowEndHeader-l),this.m_startRowEndHeaderPixel-=p);if(-1===s&&(s=this.m_endRowEndHeader),!this._isCountUnknown("row")&&this._isHighWatermarkScrolling()&&this.m_endRowEndHeader+1>=s?this.m_stopRowEndHeaderFetch=!0:this.m_stopRowEndHeaderFetch=_.stopFetch,0===this.m_startRowEndHeader&&0!==this.m_startRowEndHeaderPixel&&(this._shiftHeadersAlongAxisInContainer(e.firstChild,0,-1*this.m_startRowEndHeaderPixel,"top",this.getMappedStyle("rowendheadercell")),this.m_endRowEndHeaderPixel-=this.m_startRowEndHeaderPixel,this.m_startRowEndHeaderPixel=0),!this.m_initialized&&this.m_startRowEndHeader>0){var C=Math.round(this.m_avgRowHeight*this.m_startRowEndHeader);this._shiftHeadersAlongAxisInContainer(e.firstChild,this.m_startRowEndHeader,C-this.m_startRowEndHeaderPixel,"top",this.getMappedStyle("rowendheadercell")),this.m_endRowEndHeaderPixel=C+p,this.m_startRowEndHeaderPixel=C}}},I.prototype.buildAxisHeaders=function(e,t,i,s,n,o,r,l,a,h,d,c,m,u){var _,p,g=-1!==i.indexOf("column"),f=g?"height":"width",C=!1,y=0,v=0,E=0,S=0;if(!u){if(0===n&&this._isCountUnknown(i))return{totalHeaderDimension:y,totalLevelDimension:v,stopFetch:C=!0};_=e.firstChild,-1===h&&""===e.className&&(e.className=c,e.style[f]="",_.style[f]="")}for(var w=this.getRendererOrTemplate(i),H=document.createDocumentFragment(),b=0;n-b>0;){o||r?(p=s+b,E=g?a+y:0,S=g?0:a+y):(p=s+(n-1-b),E=g?a-y:0,S=g?0:a-y);var x=this.buildLevelHeaders(H,p,0,E,S,o,r,w,t,i,m,d);b+=x.count,y+=x.totalHeaderDimension,x.totalLevelDimension>v&&(v=x.totalLevelDimension)}return u?H:(o?_.appendChild(H):r?_.insertBefore(H,l):_.insertBefore(H,_.firstChild),e.hasChildNodes()||r||e.appendChild(_),this.m_subtreeAttachedCallback(_),{totalHeaderDimension:y,totalLevelDimension:v,stopFetch:C})},I.prototype._renderContent=function(e,t,i,s,n){if(null!=e&&"function"==typeof e){var o=e.call(this,t);null!=o&&(null===o.parentNode||o.parentNode instanceof DocumentFragment?(i.appendChild(o),this.m_isCustomElementCallback()||this.m_subtreeAttachedCallback(o)):null!=o.parentNode||o.toString&&i.appendChild(document.createTextNode(o.toString()))),this._removeFocusFromChildElements(t,i)}else if(null!=e&&"object"==typeof e&&this.m_engine){for(var r=this.m_engine.execute(this.m_root,e,n,null),l=0;l<r.length;l++)i.appendChild(r[l]);this._removeFocusFromChildElements(t,i)}else null!=s&&"object"==typeof s&&Object.prototype.hasOwnProperty.call(s,"data")&&(s=s.data),null==s&&(s=""),i.appendChild(document.createTextNode(s.toString()))},I.prototype._removeFocusFromChildElements=function(e,t){if("edit"!==e.mode){var i=this;this._signalTaskStart(),this.m_contextCallback(t).getBusyContext().whenReady().then(function(){c.disableAllFocusableElements(t),i._signalTaskEnd()})}},I.prototype.buildLevelHeaders=function(e,t,i,s,n,o,r,l,a,h,d,m){var u,_,p,g,f,C,y,v,E,S,w,H,b,x,R,M=0,I=0,A=0,L=0;"row"===h?(u="row",_=this.m_rowHeader,p="width",g=this.m_rowHeaderLevelWidths,f="height",C="top",y=n,v=this.getResources().isRTLMode()?"right":"left",E=s,S=this.m_startRowHeader,w=this.m_endRowHeader):"rowEnd"===h?(u="row",_=this.m_rowEndHeader,p="width",g=this.m_rowEndHeaderLevelWidths,f="height",C="top",y=n,v=this.getResources().isRTLMode()?"left":"right",E=s,S=this.m_startRowEndHeader,w=this.m_endRowEndHeader):"column"===h?(u="column",_=this.m_colHeader,p="height",g=this.m_columnHeaderLevelHeights,f="width",C=this.getResources().isRTLMode()?"right":"left",y=s,v="top",E=n,S=this.m_startColHeader,w=this.m_endColHeader):(u="column",_=this.m_colEndHeader,p="height",g=this.m_columnEndHeaderLevelHeights,f="width",C=this.getResources().isRTLMode()?"right":"left",y=s,v="bottom",E=n,S=this.m_startColEndHeader,w=this.m_endColEndHeader);var D=a.getExtent(t,i),T=D.extent,F=D.more.before,N=D.more.after,z=a.getDepth(t,i);let P;if(F&&t===w+1){for(H=this._getHeaderContainer(t-1,i,0,null,_,m),this._setAttribute(H,"extent",this._getAttribute(H,"extent",!0)+T),P=(b=H.firstChild)[this.getResources().getMappedAttribute("context")],P.extent+=T,M=this.getElementDir(b,p),x=0;x<T;)y+=(R="column"===h||"columnEnd"===h?this.buildLevelHeaders(H,t+x,i+z,y,E+M,o,r,l,a,h,d,m):this.buildLevelHeaders(H,t+x,i+z,E+M,y,o,r,l,a,h,d,m)).totalHeaderDimension,A+=R.totalHeaderDimension,L+=R.count,x+=R.count;this.setElementDir(b,this.getElementDir(b,f)+A,f)}else if(N&&t===S-1){for(H=this._getHeaderContainer(t+1,i,0,null,_,m),this._setAttribute(H,"extent",this._getAttribute(H,"extent",!0)+T),this._setAttribute(H,"start",this._getAttribute(H,"start",!0)-T),P=(b=H.firstChild)[this.getResources().getMappedAttribute("context")],P.extent+=T,P.index-=T,M=this.getElementDir(b,p),x=0;x<T;)y-=(R="column"===h||"columnEnd"===h?this.buildLevelHeaders(H,t-x,i+z,y,E+M,o,r,l,a,h,d,m):this.buildLevelHeaders(H,t-x,i+z,E+M,y,o,r,l,a,h,d,m)).totalHeaderDimension,A+=R.totalHeaderDimension,L+=R.count,x+=R.count;this.setElementDir(b,this.getElementDir(b,f)+A,f),this.setElementDir(b,y,C)}else{var O=a.getData(t,i),k=a.getMetadata(t,i);b=document.createElement("div"),P=this.createHeaderContext(h,t,O,k,b,i,T,z),b.setAttribute(this.getResources().getMappedAttribute("container"),this.getResources().widgetName),b.setAttribute(this.getResources().getMappedAttribute("busyContext"),""),this._createUniqueId(b),b[this.getResources().getMappedAttribute("context")]=P,b[this.getResources().getMappedAttribute("metadata")]=k,b.extentInfo=D;var B=this.m_options.getInlineStyle(h,P),j=this.m_options.getStyleClass(h,P);null!=B&&c.applyMergedInlineStyles(b,B,""),b.className=d,b.className+=" "+this.getMappedStyle("depth")+z,null!=j&&(b.className+=" "+j),this.setElementDir(b,E,v),this.setElementDir(b,y,C);var W=this._getHeaderDimensions(b,f,p,g,i,u,P.key,z);M=W[p],this.setElementDir(b,M,p);var K=W[f];if(this._setAttribute(b,"depth",z),i!==m-1&&((H=document.createElement("div")).className=this.getMappedStyle("groupingcontainer"),H.appendChild(b),this._setAttribute(H,"start",o||r?t:t-T+1),this._setAttribute(H,"extent",T),this._setAttribute(H,"level",i)),i+z===m)this.setElementDir(b,K,f),A+=K,L+=1,I=M,o||r||(y-=K,this.setElementDir(b,y,C));else{for(x=0;x<T;x++){var U=o||r?t+x:t-x;K=(R="column"===h||"columnEnd"===h?this.buildLevelHeaders(H,U,i+z,y,E+M,o,r,l,a,h,d,m):this.buildLevelHeaders(H,U,i+z,E+M,y,o,r,l,a,h,d,m)).totalHeaderDimension,y=o||r?y+K:y-K,A+=K,L+=R.count,x+=R.count-1}I=M,R&&!isNaN(R.totalLevelDimension)&&(I+=R.totalLevelDimension),o||r||this.setElementDir(b,y,C),this.setElementDir(b,A,f)}if("columnEnd"===h&&this.m_addBorderBottom&&this.m_utils.addCSSClassName(b,this.getMappedStyle("borderHorizontalSmall")),"rowEnd"===h&&this.m_addBorderRight&&this.m_utils.addCSSClassName(b,this.getMappedStyle("borderVerticalSmall")),this._isHeaderResizeEnabled(h,P)&&this._setAttribute(b,"resizable","true"),this.m_isCustomElementCallback()||(null!=H?this.m_root.appendChild(H):this.m_root.appendChild(b)),this._renderContent(l,P,b,O,this.buildHeaderTemplateContext(P,k)),("column"===h||this._isDataGridProvider())&&this._isSortEnabled(h,P)){null!=k.sortDirection&&null==this.m_sortInfo&&(this.m_sortInfo={},this.m_sortInfo.key=k.key,this.m_sortInfo.direction=k.sortDirection,this.m_sortInfo.axis=h);var V=this._buildSortIcon(P,b,h);b.appendChild(V),this._setAttribute(b,"sortable","true")}if(this._isParentNode(P)){const e=this._buildDisclosureIcon(P);this._isHierarchicalGroup(P)?this.m_utils.addCSSClassName(b,this.getMappedStyle("hierarchicalGroup")):this.m_utils.addCSSClassName(b,this.getMappedStyle("hierarchicalTree")),b.prepend(e);const t=this._buildSpacer(P);b.prepend(t)}else if(this._isLeafNode(P)){this.m_utils.addCSSClassName(b,this.getMappedStyle("hierarchical"));const e=this._buildSpacer(P);b.prepend(e)}o||r?null!=H?e.appendChild(H):e.appendChild(b):null!=H?e.firstChild?this.m_utils.containsCSSClassName(e.firstChild,this.getMappedStyle("groupingcontainer"))?e.insertBefore(H,e.firstChild):(this.m_utils.containsCSSClassName(e.firstChild,this.getMappedStyle("headercell"))||this.m_utils.containsCSSClassName(e.firstChild,this.getMappedStyle("endheadercell")))&&e.insertBefore(H,e.firstChild.nextSibling):e.appendChild(H):this.m_utils.containsCSSClassName(e,this.getMappedStyle("groupingcontainer"))?e.insertBefore(b,e.firstChild.nextSibling):e.insertBefore(b,e.firstChild)}return"column"===h||"columnEnd"===h?this._isLastColumn(t+(T-1))&&this.m_utils.addCSSClassName(b,this.getMappedStyle("borderVerticalNone")):this._isLastRow(t+(T-1))&&!r&&this.m_utils.addCSSClassName(b,this.getMappedStyle("borderHorizontalNone")),{totalLevelDimension:I,totalHeaderDimension:A,count:L}},I.prototype._getHeaderDimensions=function(e,t,i,s,n,o,r,l){for(var a={},h=0,d=0;d<l;d++){var c=s[n+d];if(null==c){h=null;break}h+=c}null==h?a=this._computeElementWidthAndHeight(e):a[i]=h,1===l&&(s[n]=a[i]);var m=this.m_sizingManager.getSize(o,r);if(null!=m)return a[t]=m,a;if(""!==e.style[t])return null==a[t]&&(a[t]=this.getElementDir(e,t)),this.m_sizingManager.setSize(o,r,a[t]),a;var u=e.className;return null==a[t]&&(a[t]=this.m_styleClassDimensionMap[t][u],null==a[t]&&(a[t]=this.getElementDir(e,t))),this.m_sizingManager.setSize(o,r,a[t]),this.m_styleClassDimensionMap[t][u]=a[t],a},I.prototype._getHeaderLevelDimension=function(e,t,i,s,n){for(var o=0,r=0;r<n;r++){var l=i[e+r];if(null==l){o=null;break}o+=l}return null!=o||(o=this.getElementDir(t,s),1===n&&(i[e]=o)),o},I.prototype._getHeaderContainer=function(e,t,i,s,n,o){var r;if(null==s?(s=n.firstChild.childNodes,r=0):r=1,i===o-1)return s[0].parentNode;for(;r<s.length;r++){var l=this._getAttribute(s[r],"start",!0),a=this._getAttribute(s[r],"extent",!0),h=this._getAttribute(s[r].firstChild,"depth",!0);if(e>=l&&e<l+a)return t<i+h?s[r]:this._getHeaderContainer(e,t,i+h,s[r].childNodes,n,o)}return null},I.prototype._getHeaderByIndex=function(e,t,i,s,n){var o;if(t<0)return null;if(1===s)return i.firstChild.childNodes[o=e-n];var r=this._getHeaderContainer(e,t,0,null,i,s);return null==r?null:t<=this._getAttribute(r,"level",!0)+this._getAttribute(r.firstChild,"depth",!0)-1?r.firstChild:(o=e-this._getAttribute(r,"start",!0)+1,r.childNodes[o])},I.prototype._getHeadersByIndex=function(e,t,i,s){let n=[],o=1;for(let r=i-1;r>=0;r-=o){let l=this._getHeaderByIndex(e,r,t,i,s);l&&(o=this.getHeaderCellDepth(l),n.push(l))}return n},I.prototype._getAttribute=function(e,t,i){var s=e.getAttribute(this.getResources().getMappedAttribute(t));return i?parseInt(s,10):s},I.prototype._setAttribute=function(e,t,i){e.setAttribute(this.getResources().getMappedAttribute(t),i)},I.prototype.buildDatabody=function(){var e=document.createElement("div");e.id=this.createSubId("databody"),e.className=this.getMappedStyle("databody")+" "+this.getMappedStyle("scrollbarForce"),e.tabIndex="-1",this.m_databody=e,e.addEventListener?e.addEventListener("scroll",this.handleScroll.bind(this),!1):e.attachEvent("onscroll",this.handleScroll.bind(this));var t=document.createElement("div");if(t.className=this.getMappedStyle("scroller")+(this.m_utils.isTouchDevice()?" "+this.getMappedStyle("scroller-mobile"):""),e.appendChild(t),this._isHighWatermarkScrolling()){this.fetchCells(e,0,0)}else{var i=this,s=this.m_options.getScrollPosition();this._getIndexesFromScrollPosition(s).then(function(t){var s=t.row,n=t.column;i.m_startRow=s,i.m_startCol=n,i.m_fetching.cells=!1,i.fetchCells(e,s,n)}),this.m_fetching.cells=!0}return e},I.prototype._getIndexFromKeyPromise=function(e,t){var i=this;return new Promise(function(s){null!=e||null!=t?i._indexes({row:e,column:t},function(e){s({rowIndexFromKey:e.row,columnIndexFromKey:e.column})}):s({rowIndexFromKey:null,columnIndexFromKey:null})})},I.prototype._getIndexesFromScrollPosition=function(e){var t=this,i=e.rowKey,s=e.columnKey;return this._getIndexFromKeyPromise(i,s).then(function(i){var s={};return null!=i.rowIndexFromKey&&i.rowIndexFromKey>0?s.row=i.rowIndexFromKey:null!=e.rowIndex?s.row=e.rowIndex:null!=e.y?s.row=Math.round(e.y/t.getDefaultRowHeight()):s.row=0,null!=i.columnIndexFromKey&&i.columnIndexFromKey>0?s.column=i.columnIndexFromKey:null!=e.columnIndex?s.column=e.columnIndex:null!=e.x?s.column=Math.round(e.x/t.getDefaultColumnWidth()):s.column=0,s})},I.prototype.getFetchCount=function(e,t){var i=this.getFetchSize(e);if(this._isHighWatermarkScrolling()){var s="row"===e?"maxRowCount":"maxColumnCount",n=this.m_options.getScrollPolicyOptions();n&&null!=n[s]&&n[s]>0&&(i=Math.max(Math.min(i,n[s]-t),0))}return i},I.prototype.fetchCells=function(e,t,i,s,n,o){var r;if(!this.m_fetching.cells){null==s&&(s=this.getFetchCount("row",t)),null==n&&(n=this.getFetchCount("column",i));var l={axis:"row",start:t,count:s},a={axis:"column",start:i,count:n,databody:e};this.m_fetching.cells={rowRange:l,columnRange:a},r=null!=o&&null!=o.success?o.success:this.handleCellsFetchSuccess,this.showStatusText(),this._signalTaskStart(),this.getDataSource().fetchCells([l,a],{success:r,error:this.handleCellsFetchError},{success:this,error:this})}},I.prototype.isCellFetchResponseValid=function(e){if(null==this.m_fetching)return!1;var t=e[0],i=e[1],s=this.m_fetching.cells;return t===s.rowRange&&i===s.columnRange},I.prototype.isLongScroll=function(){return this.m_isLongScroll},I.prototype.isCellFetchResponseInViewport=function(e,t){if(isNaN(this.m_avgRowHeight)||isNaN(this.m_avgColWidth)||null!=this.m_empty||!this.m_initialized)return!0;var i=t[0].start,s=t[1].start,n=this._getLongScrollStart(this.m_currentScrollTop,this.m_prevScrollTop,"row"),o=this._getLongScrollStart(this.m_currentScrollLeft,this.m_prevScrollLeft,"column");return n.start===i&&o.start===s},I.prototype.handleCellsFetchSuccess=function(e,t,i){var s=this.m_options.getScrollPolicyOptions(),n=s?s.maxRowCount:null,o=s?s.maxColumnCount:null,r=this.getDataSource().getCount("row"),l=this.getDataSource().getCount("column");if(void 0===i){if(i=!1,!this.isCellFetchResponseValid(t))return void this._signalTaskEnd();if(this.isLongScroll()&&(!this.isCellFetchResponseInViewport(e,t)||this.m_headerInvalid))return this.m_fetching.cells=!1,this.m_headerInvalid=!1,this.handleLongScroll(this.m_currentScrollLeft,this.m_currentScrollTop),void this._signalTaskEnd();this.m_isLongScroll=!1}var a=t[0],h=a.start,d=e.getCount("row"),c=d>0&&(h>this.m_endRow||h+d<=this.m_startRow);(0===d&&this._isCountUnknown("row")&&a.count>0||c&&this._isHighWatermarkScrolling()&&!this._isCountUnknown("row")&&this.m_endRow+d+1>=r||d<a.count||this._isHighWatermarkScrolling()&&n&&n>0&&h+d===n)&&(this.m_stopRowFetch=!0);var m=t[1],u=m.start,_=e.getCount("column"),p=_>0&&(u>this.m_endCol||u+_===this.m_startCol);(0===_&&this._isCountUnknown("column")&&m.count>0||p&&this._isHighWatermarkScrolling()&&!this._isCountUnknown("column")&&this.m_endCol+_+1>=l||_<m.count||this._isHighWatermarkScrolling()&&o&&o>0&&u+_===o)&&(this.m_stopColumnFetch=!0);var g=this.m_databody;null==g&&(g=m.databody);var f,C,y,v,E,S,w,H,b,x,R=g.firstChild;if(c||i){if(f=!(i||!(h>=this.m_startRow)))C=this.m_endRowPixel;else if(i){var M=this._getCellByIndex({row:h+d,column:this.m_startCol});C=this.getElementDir(M,"top")}else C=this.m_startRowPixel;y=u>=this.m_startCol?this.m_startColPixel:this.m_endColPixel,v=document.createDocumentFragment(),S=(E=this._addCellsToFragment(v,e,h,C,u,y)).totalColumnWidth,w=E.totalRowHeight,H=E.avgWidth,b=w/d,this._populateDatabody(R,v),f?(-1!==this.m_endRow&&0!==d&&this._highlightCellsAlongAxis(this.m_endRow,"row","index","remove",["borderHorizontalNone"]),this.m_endRow=h+(d-1),this.m_endRowPixel+=w):i?(h<this.m_startRow&&(this.m_startRow=h,this.m_startRowPixel=Math.max(0,this.m_startRowPixel-w)),this.m_endRow+=d,this.m_endRowPixel+=w,this.pushRowsDown(h+d,w)):(this.m_startRow-=d,this.m_startRowPixel-=w)}else p&&(y=(f=u>=this.m_startCol)?this.m_endColPixel:this.m_startColPixel,C=h>=this.m_startRow?this.m_startRowPixel:this.m_endRowPixel,v=document.createDocumentFragment(),E=this._addCellsToFragment(v,e,h,C,u,y),this._populateDatabody(R,v),S=E.totalColumnWidth);if(null==H||0!==this.m_avgColWidth&&null!=this.m_avgColWidth||(this.m_avgColWidth=H),null==b||0!==this.m_avgRowHeight&&null!=this.m_avgRowHeight||(this.m_avgRowHeight=b),p&&(u<this.m_startCol?(this.m_startCol-=_,this.m_startColPixel-=S):(this.m_endCol=u+(_-1),this.m_endColPixel+=S)),this._sizeDatabodyScroller(),this.m_endCol>=0&&this.m_endRow>=0?this.m_hasCells=!0:(this.m_startCol=0,this.m_startRow=0),0===this.m_startCol&&0!==this.m_startColPixel&&(this._shiftCellsAlongAxis("column",-this.m_startColPixel,0,!0),this.m_endColPixel-=this.m_startColPixel,this.m_startColPixel=0),0===this.m_startRow&&0!==this.m_startRowPixel&&(this._shiftCellsAlongAxis("row",-this.m_startRowPixel,0,!0),this.m_endRowPixel-=this.m_startRowPixel,this.m_startRowPixel=0),!this.m_initialized&&this.m_startCol>0&&(x=Math.round(this.m_avgColWidth*this.m_startCol),this._shiftCellsAlongAxis("column",x-this.m_startColPixel,this.m_startCol,!0),this.m_endColPixel=x+S,this.m_startColPixel=x),!this.m_initialized&&this.m_startRow>0&&(x=Math.round(this.m_avgRowHeight*this.m_startRow),this._shiftCellsAlongAxis("row",x-this.m_startRowPixel,this.m_startRow,!0),this.m_endRowPixel=x+w,this.m_startRowPixel=x),this.m_fetching.cells=!1,this.isFetchComplete()){if(this.hideStatusText(),this.m_initialized)this._checkScroll&&this._checkScrollPosition();else{const e="translate3d(0, 0, 0)";this.m_utils.isTouchDevice()&&Object.prototype.hasOwnProperty.call(window,"WebKitCSSMatrix")&&(R.style.transform=e,null!=this.m_rowHeader&&(this.m_rowHeader.firstChild.style.transform=e),null!=this.m_colHeader&&(this.m_colHeader.firstChild.style.transform=e),null!=this.m_rowEndHeader&&(this.m_rowEndHeader.firstChild.style.transform=e),null!=this.m_colEndHeader&&(this.m_colEndHeader.firstChild.style.transform=e)),this._updateScrollPosition(this.m_options.getScrollPosition())}if(null!=this.m_scrollIndexAfterFetch?this.scrollToIndex(this.m_scrollIndexAfterFetch):null!=this.m_scrollHeaderAfterFetch?this.scrollToHeader(this.m_scrollHeaderAfterFetch):this.isActionableMode()||null==this._getActiveElement()||this.m_utils.containsCSSClassName(this._getActiveElement(),this.getMappedStyle("focus"))||(!0!==this.m_shouldFocus&&(this.m_shouldFocus=!1),this._highlightActive(),this._manageMoveCursor()),this._isSelectionEnabled()&&this.applySelection(h,h+d,u,u+_),this.populateAccInfo(),this._shouldInitialize())this._handleInitialization(!0);else if(this.m_initialized){var I;(!0===this.m_resizeRequired||this.m_endRowPixel-w<this.getElementHeight(g))&&this.resizeGrid(),c?f?I="top":i||(I="bottom"):p&&(I=u===this.m_startCol?"right":"left"),this._cleanupViewport(I),this.fillViewport(),this.isFetchComplete()&&this.fireEvent("ready",{})}}this._isSelectionEnabled()&&this.isMultipleSelection()&&this._resetHeaderHighLight(),this._signalTaskEnd()},I.prototype._setZIndexBefore=function(e,t,i,s){if("row"===e)for(var n=this.m_startRow,o=this.m_currentScrollTop,r=this.m_rowHeader,l=this.m_rowHeaderLevelCount,a=this.m_startRowHeader,h=this.m_rowEndHeader,d=this.m_rowEndHeaderLevelCount,c=this.m_startRowEndHeader,m=t;m>=n;m--){var u,_=this._getAxisCellsByIndex(m,e);if(this.getElementDir(_[0],"top")<o)break;for(var p=0;p<_.length;p++)this.changeStyleProperty(_[p],this.getCssSupport("z-index"),10);i&&(u=this._getHeaderByIndex(m,0,r,l,a),this.changeStyleProperty(u,this.getCssSupport("z-index"),10)),s&&(u=this._getHeaderByIndex(m,0,h,d,c),this.changeStyleProperty(u,this.getCssSupport("z-index"),10))}},I.prototype._onTransitionEnd=function(e,t,i){var s;function n(){s&&(clearTimeout(s),s=void 0),e.removeEventListener("transitionend",n),t()}e.addEventListener("transitionend",n),s=setTimeout(n,i+100)},I.prototype._insertRowsWithAnimation=function(e,t,i,s,n,o,r,l){var a,h,d,c,m,u,_,p,g,f,C=this,y=0,v=0,E=0;C._signalTaskStart();var S=s>this.m_endRow,w=this.m_databody.firstChild,H=null!=t,b=null!=i;for(s>0&&(E=s-1,f=this._getAxisCellsByIndex(s-1,"row"),y=(v=this.getElementDir(f[0],"top"))+this.getElementHeight(f[0])),this._setZIndexBefore("row",E,H,b),H&&(d=(h=this.m_rowHeader.firstChild).childNodes[s-this.m_startRow-1]),b&&(m=(c=this.m_rowEndHeader.firstChild).childNodes[s-this.m_startRow-1]),a=0;a<e.childNodes.length;a++){var x=e.childNodes[a];p=v-(_=y+this.getElementDir(x,"top"))-this.getElementHeight(x),this.setElementDir(x,_,"top"),this.addTransformMoveStyle(x,0,0,"linear",0,p,0)}if(H)for(a=0;a<t.childNodes.length;a++)u=t.childNodes[a],p=v-(_=y+this.getElementDir(u,"top"))-this.getElementHeight(u),this.setElementDir(u,_,"top"),this.addTransformMoveStyle(u,0,0,"linear",0,p,0);if(b)for(a=0;a<i.childNodes.length;a++)g=i.childNodes[a],p=v-(_=y+this.getElementDir(g,"top"))-this.getElementHeight(g),this.setElementDir(g,_,"top"),this.addTransformMoveStyle(g,0,0,"linear",0,p,0);for(a=s;a<=this.m_endRow;a++){var R=this._getAxisCellsByIndex(a-this.m_startRow,"row");_=o+this.getElementDir(R[0],"top"),p=-o;for(var M=0;M<R.length;M++)this.setElementDir(R[M],_,"top"),this.addTransformMoveStyle(R[M],0,0,"linear",0,p,0);H&&(u=h.childNodes[a],this.setElementDir(u,_,"top"),this.addTransformMoveStyle(u,0,0,"linear",0,p,0)),b&&(g=c.childNodes[a],this.setElementDir(g,_,"top"),this.addTransformMoveStyle(g,0,0,"linear",0,p,0))}this._modifyAxisCellContextIndex("row",s,this.m_endRow-s+1,n),this.m_endRow+=n,this.m_endRowPixel+=o,H&&(this.m_endRowHeader+=t.childNodes.length,this.m_endRowHeaderPixel+=o),b&&(this.m_endRowEndHeader+=i.childNodes.length,this.m_endRowEndHeaderPixel+=o),w.appendChild(e),S?(H&&h.appendChild(t),b&&c.appendChild(i)):(H&&h.insertBefore(t,d.nextSibling),b&&c.insertBefore(i,m.nextSibling)),this.setElementHeight(w,this.getElementHeight(w)+o),this.resizeGrid(),this.updateRowBanding(),this._refreshDatabodyMap(),this._isSelectionEnabled()&&this.applySelection(s,s+n,r,r+l);var A=this._getCellByIndex(this.createIndex(s+(n-1),this.m_endCol));this.m_animating=!0;var L=C.m_processingEventQueue?1:I.EXPAND_ANIMATION_DURATION;this._onTransitionEnd(A,function(){C._handleAnimationEnd()},L),setTimeout(function(){for(var e=I.EXPAND_ANIMATION_DURATION,t=s;t<=C.m_endRow;t++){for(var i=C._getAxisCellsByIndex(t,"row"),n=0;n<i.length;n++)C.addTransformMoveStyle(i[n],e+"ms",0,"ease-out",0,0,0);H&&C.addTransformMoveStyle(h.childNodes[t],e+"ms",0,"ease-out",0,0,0),b&&C.addTransformMoveStyle(c.childNodes[t],e+"ms",0,"ease-out",0,0,0)}},0)},I.prototype._addCellsToFragment=function(e,t,i,s,n,o){for(var r=this.getResources().isRTLMode()?"right":"left",l=this.getRendererOrTemplate("cell"),a=this.m_options.getColumnBandingInterval(),h=this.m_options.getRowBandingInterval(),d=this.m_options.getHorizontalGridlines(),m=this.m_options.getVerticalGridlines(),u=t.getCount("row"),_=t.getCount("column"),p=i>=this.m_startRow,g=n>=this.m_startCol,f=0,C=s,y=[],v=[],E=0;E<u;E+=1){for(var S,w,H,b,x=o,R=p?i+E:i+(u-1-E),M=Math.floor(R/h)%2==1,I=0;I<_;I+=w.column){var A=0;S=0;var L,D=g?n+I:n+(_-1-I);w={row:(L=t.getExtent?t.getExtent(this.createIndex(R,D)):{row:{extent:1,more:{before:!1,after:!1}},column:{extent:1,more:{before:!1,after:!1}}}).row.extent,column:L.column.extent},g||(D=D-w.column+1);var T=p?R:R-w.row+1,F=this.createIndex(T,D);if(y[E]&&y[E][I])A=y[E][I].width,x=g?x+A:x-A;else{var N=this._patchExistingCells(L,D,T,y);if(N)A=N.width;else{var z=t.getData(this.createIndex(T,D)),P=t.getMetadata(this.createIndex(T,D));H=document.createElement("div"),b=this.createCellContext(F,z,P,H,w),H.setAttribute(this.getResources().getMappedAttribute("container"),this.getResources().widgetName),H.setAttribute(this.getResources().getMappedAttribute("busyContext"),""),this._createUniqueId(H),H[this.getResources().getMappedAttribute("context")]=b,H[this.getResources().getMappedAttribute("metadata")]=P;var O=this.m_options.getInlineStyle("cell",b);null!=O&&c.applyMergedInlineStyles(H,O,""),""!==H.style.height&&(H.style.height=""),""!==H.style.width&&(H.style.width=""),this.m_utils.addCSSClassName(H,this.getMappedStyle("cell")),this.m_utils.addCSSClassName(H,this.getMappedStyle("formcontrol")),(M||Math.floor(D/a)%2==1)&&this.m_utils.addCSSClassName(H,this.getMappedStyle("banded"));var k,B=this.m_options.getStyleClass("cell",b);for(null!=B&&(H.className+=" "+B),k=0;k<w.row;k++){var j=0===k?b.keys.row:this._getKey(this._getHeaderByIndex(T+k,0,this.m_rowHeader,this.m_rowHeaderLevelCount,this.m_startRowHeader),"row");v[E+k]=this._getCellDimension(H,T+k,j,"row","height"),S+=v[E+k]}for(this.setElementHeight(H,S),k=0;k<w.column;k++){var W=0===k?b.keys.column:this._getKey(this._getHeaderByIndex(D+k,0,this.m_colHeader,this.m_columnHeaderLevelCount,this.m_startColHeader),"column");A+=this._getCellDimension(H,D,W,"column","width")}this.setElementWidth(H,A),("hidden"===m||this._isLastColumn(D+(w.column-1))&&(this.getRowHeaderWidth()+x+A>=this.getWidth()||-1!==this.m_endRowEndHeader))&&this.m_utils.addCSSClassName(H,this.getMappedStyle("borderVerticalNone")),("hidden"===d||this._isLastRow(T+(w.row-1))&&(this.getRowBottom(H,C+S)>=this.getHeight()||-1!==this.m_endColEndHeader))&&this.m_utils.addCSSClassName(H,this.getMappedStyle("borderHorizontalNone")),p?this.setElementDir(H,C,"top"):this.setElementDir(H,C-S,"top"),g?this.setElementDir(H,x,r):this.setElementDir(H,x-A,r),this.m_isCustomElementCallback()&&this.m_root.appendChild(H),this._renderContent(l,b,H,z,this.buildCellTemplateContext(b,P)),e.appendChild(H)}this._updateTempArray(y,{width:A},E,I,w.row,w.column),x=g?x+A:x-A,0===E&&(f+=A)}}S=v[E],C=p?C+S:C-S,S}return{avgWidth:f/_,totalRowHeight:v.reduce(function(e,t){return e+t},0),totalColumnWidth:f}},I.prototype._updateCellDimension=function(e,t,i,s,n,o,r,l){var a,h,d,c,m,u=0,_="width"===r?"height":"width",p=this._getCellByIndex(this.createIndex(s,i)),g=this.getElementDir(p,r),f=p[this.getResources().getMappedAttribute("context")];f.extents[o]+=e,"row"===o?(a=s,h=this.m_rowHeader,d=this.m_rowHeaderLevelCount,c=this.m_startRowHeader):(a=i,h=this.m_colHeader,d=this.m_columnHeaderLevelCount,c=this.m_startColHeader);for(var C=1;C<=e;C++){var y=this._getKey(this._getHeaderByIndex(l?a-C:a+C,0,h,d,c),o);u+=this._getCellDimension(p,l?a-C:a+C,y,o,r);for(var v=0;v<t;v++){var E,S;"row"===o?(E=l?s-C:s+C,S=i+v):(E=s+v,S=l?i-C:i+C),this._addIndexToDatabodyMap(this.createIndex(E,S),p.id)}}l&&(m="width"===r?this.getResources().isRTLMode()?"right":"left":"top",this.setElementDir(p,this.getElementDir(p,m)-u,m),f.indexes[o]-=e);this.setElementDir(p,g+u,r);var w={};return w[r]=u,w[_]=this.getElementDir(p,_),w.cell=p,w},I.prototype._patchExistingCells=function(e,t,i,s){var n=e.column.extent,o=e.row.extent,r=e.row.more.before,l=e.row.more.after,a=e.column.more.before,h=e.column.more.after;return t-1===this.m_endCol&&a?this._updateCellDimension(n,o,this.m_endCol,i,s,"column","width",!1):i-1===this.m_endRow&&r?this._updateCellDimension(o,n,t,this.m_endRow,s,"row","height",!1):t+n===this.m_startCol&&h?this._updateCellDimension(n,o,this.m_startCol,i,s,"column","width",!0):!(i+o!==this.m_startRow||!l)&&this._updateCellDimension(o,n,t,this.m_startRow,s,"row","height",!0)},I.prototype._updateTempArray=function(e,t,i,s,n,o){for(var r=0;r<n;r++){null==e[i+r]&&(e[i+r]=[]);for(var l=0;l<o;l++)e[i+r][s+l]=t}},I.prototype._getCellDimension=function(e,t,i,s,n){var o,r,l;if("row"===s?(o=this.getMappedStyle("rowheadercell")+" "+this.getMappedStyle("headercell"),r=this.m_endRowHeader):"column"===s&&(o=this.getMappedStyle("colheadercell")+" "+this.getMappedStyle("headercell"),r=this.m_endColHeader),-1===r){var a=this.createHeaderContext(s,t,null,{key:i},null,0,0,1),h=this.m_options.getInlineStyle(s,a),d=this.m_options.getStyleClass(s,a);l=document.createElement("div"),null!=h&&c.applyMergedInlineStyles(l,h,""),l.className=o+" "+d}else l=e;return this._getHeaderDimension(l,i,s,n)},I.prototype._modifyAndPushCells=function(e,t,i,s,n,o){let r=this.getResources().isRTLMode()?"right":"left",l="row"===i?"top":r,a=this.getResources().getMappedAttribute("context"),h=o?1:-1,d=function(i,s,n){i.forEach(i=>{let r=s(i),l=0;if(o)r>=e[0]&&(l=e.length);else for(;l<e.length&&!(e[l]>=r);l++);if(l>0){let e=t.length?t.slice(0,l).reduce((e,t)=>e+t):0;e*=h,l*=h,n(i,e,l,r)}})};d(this.m_databody.firstChild.querySelectorAll("."+this.getMappedStyle("cell")),e=>e[a].indexes[i],(e,t,s)=>{if(0!==t){let i=this.getElementDir(e,l)+t;this.setElementDir(e,i,l)}e[a].indexes[i]+=s}),d(s.querySelectorAll("."+this.getMappedStyle("headercell")),e=>e[a].index,(e,t,i)=>{if(0!==t){let i=this.getElementDir(e,l)+t;this.setElementDir(e,i,l)}e[a].index+=i}),d(s.querySelectorAll("."+this.getMappedStyle("groupingcontainer")),e=>this._getAttribute(e,"start",!0),(e,t,i,s)=>{this._setAttribute(e,"start",s+i)}),d(n.querySelectorAll("."+this.getMappedStyle("endheadercell")),e=>e[a].index,(e,t,i)=>{if(0!==t){let i=this.getElementDir(e,l)+t;this.setElementDir(e,i,l)}e[a].index+=i}),d(n.querySelectorAll("."+this.getMappedStyle("groupingcontainer")),e=>this._getAttribute(e,"start",!0),(e,t,i,s)=>{this._setAttribute(e,"start",s+i)})},I.prototype.pushRowsDown=function(e,t){for(;e<=this.m_endRow;){var i=this._getAxisCellsByIndex(e,"row");if(i.length>0)for(var s=0;s<i.length;s++){var n=i[s],o=this.getElementDir(n,"top")+t;n.style.top=o+"px"}e+=1}},I.prototype.pushRowsUp=function(e,t){this.pushRowsDown(e,-t)},I.prototype.pushRowHeadersDown=function(e,t){for(;e;){var i=this.getElementDir(e,"top")+t;e.style.top=i+"px",e=e.nextSibling}},I.prototype.pushRowHeadersUp=function(e,t){this.pushRowHeadersDown(e,-t)},I.prototype.createCellContext=function(e,t,i,s,n){var o={parentElement:s,indexes:e,cell:t};this._isDataGridProvider()?o.data=t:o.data=null!=t&&"object"==typeof t&&Object.prototype.hasOwnProperty.call(t,"data")?t.data:t,o.component=this,o.datasource=this.m_options.getProperty("data"),o.mode="navigation",o.extents=n;for(var r=Object.keys(i),l=0;l<r.length;l++){var a=r[l];o[a]=i[a]}return null!=this.m_createContextCallback&&this.m_createContextCallback.call(this,o),this.m_fixContextCallback.call(this,o)},I.prototype._createUniqueId=function(e){return this._uniqueIdCallback(e,!1)},I.prototype.getRowHeaderWidth=function(){return-1===this.m_endRowHeader?0:this.m_rowHeaderWidth},I.prototype.getColumnHeaderHeight=function(){return-1===this.m_endColHeader?0:this.m_colHeaderHeight},I.prototype.getRowEndHeaderWidth=function(){return-1===this.m_endRowEndHeader?0:this.m_rowEndHeaderWidth},I.prototype.getColumnEndHeaderHeight=function(){return-1===this.m_endColEndHeader?0:this.m_colEndHeaderHeight},I.prototype.getRowBottom=function(e,t){var i=this.getColumnHeaderHeight();if(null!=t)return i+t;var s=this.getElementDir(e,"top"),n=this.calculateRowHeight(e);return isNaN(s)||isNaN(n)?i:i+s+n},I.prototype.handleCellsFetchError=function(e,t){if(this.m_fetching.cells=!1,this.hideStatusText(),null==this.m_databody.firstChild)this._shouldInitialize()&&this._handleInitialization(!0);else{var i=t[0],s=t[1];s.start+(s.count-1)>this.m_endCol&&(this.m_stopColumnFetch=!0,this.m_stopColumnHeaderFetch=!0,this.m_stopColumnEndHeaderFetch=!0),i.start+(i.count-1)>this.m_endRow&&(this.m_stopRowFetch=!0,this.m_stopRowHeaderFetch=!0,this.m_stopRowEndHeaderFetch=!0)}},I.prototype.showStatusText=function(){var e=this;"block"===this.m_status.style.display||this.m_showStatusTimeout||(this.m_showStatusTimeout=setTimeout(function(){var t=e.getResources().getTranslatedText("msgFetchingData");e.m_status.setAttribute("aria-label",t),e.m_status.style.display="block";var i=e.getWidth()/2-e.m_status.offsetWidth/2,s=e.getHeight()/2-e.m_status.offsetHeight/2;e.m_status.style.left=i+"px",e.m_status.style.top=s+"px",e.m_showStatusTimeout=null},this.getShowStatusDelay()))},I.prototype.getShowStatusDelay=function(){var e=m.getCSSTimeUnitAsMillis(this.getResources().getDefaultOption("showIndicatorDelay"));return isNaN(e)?0:e},I.prototype.hideStatusText=function(){this.m_showStatusTimeout&&(clearTimeout(this.m_showStatusTimeout),this.m_showStatusTimeout=null),this.m_status.style.display="none"},I.prototype._isFocusableElementBeforeCell=function(e){if(null==e||e===this.getRootElement()||this.m_utils.containsCSSClassName(e,this.getMappedStyle("cell")))return!1;var t=e.tagName;return!!("INPUT"===t||"TEXTAREA"===t||"SELECT"===t||"BUTTON"===t||"A"===t||this.m_utils.containsCSSClassName(e,this.getMappedStyle("active"))||null!=e.getAttribute("tabIndex")&&parseInt(e.getAttribute("tabIndex"),10)>=0&&this.findCell(e)!==e)||this._isFocusableElementBeforeCell(e.parentNode)},I.prototype._setFocusToFirstFocusableElement=function(e,t){c.enableAllFocusableElements(e);var i=c.getFocusableElementsInNode(e);if(i.length>0){var s=i[0];if(s.focus(),t&&t.preventDefault(),s.setSelectionRange&&s.value)try{s.setSelectionRange(s.value.length,s.value.length)}catch(e){}return!0===this._overwriteFlag&&"function"==typeof i[0].select&&s.select(),!0}return!1},I.prototype.handleScroll=function(e){if(this._clearScrollPositionTimeout(),this.m_handleScrollOverflow||(this.m_hasVerticalScroller||this.m_hasHorizontalScroller||(this.m_databody.style.overflow="hidden"),this.m_handleScrollOverflow=!0),this.m_animating)e.preventDefault();else if(!this.m_utils.isTouchDevice())if(!0!==this.m_silentScroll){var t;e||(e=window.event),t=e.target?e.target:e.srcElement;var i=this.m_utils.getElementScrollLeft(t),s=t.scrollTop;this.scrollTo(i,s)}else this.m_silentScroll=!1},I.prototype._getMaxScrollWidth=function(){return this._isCountUnknownOrHighwatermark("column")&&!this.m_stopColumnFetch?Number.MAX_VALUE:this.m_scrollWidth},I.prototype._getMaxScrollHeight=function(){return this._isCountUnknownOrHighwatermark("row")&&!this.m_stopRowFetch?Number.MAX_VALUE:this.m_scrollHeight},I.prototype.scroll=function(e){if(null!=e.position){var t={};t.x=Math.max(0,Math.min(this.m_scrollWidth,e.position.scrollX)),t.y=Math.max(0,Math.min(this.m_scrollHeight,e.position.scrollY)),this._scrollToScrollPositionObject(t)}},I.prototype.scrollDelta=function(e,t){this._adjustScrollerSize();var i=Math.max(0,Math.min(this._getMaxScrollWidth(),this.m_currentScrollLeft-e)),s=Math.max(0,Math.min(this._getMaxScrollHeight(),this.m_currentScrollTop-t));this._initiateScroll(i,s)},I.prototype.adjustTouchScroll=function(e,t){return this.m_utils.isTouchDevice()&&0!==e&&0!==t&&(Math.abs(e)>Math.abs(t)?(t=0,this.m_extraScrollOverY=null):(e=0,this.m_extraScrollOverX=null)),[e,t]},I.prototype._initiateScroll=function(e,t){this.m_utils.isTouchDevice()?this.scrollTo(e,t):(this.m_utils.setElementScrollLeft(this.m_databody,e),this.m_databody.scrollTop=t)},I.prototype._initiateScrollOnAttached=function(){this._initiateScroll(this.m_currentScrollLeft,this.m_currentScrollTop)},I.prototype._disableTouchScrollAnimation=function(){this.m_databody.firstChild.style.transitionDuration="0ms",this.m_rowHeader.firstChild.style.transitionDuration="0ms",this.m_colHeader.firstChild.style.transitionDuration="0ms",this.m_rowEndHeader.firstChild.style.transitionDuration="0ms",this.m_colEndHeader.firstChild.style.transitionDuration="0ms"},I.prototype._shouldLongScroll=function(e,t){return!this._isHighWatermarkScrolling()&&(e+this.getViewportWidth()<this._getMaxLeftPixel()||t+this.getViewportHeight()<this._getMaxTopPixel()||e>this._getMaxRightPixel()||t>this._getMaxBottomPixel())},I.prototype.scrollTo=function(e,t){if(this.m_prevScrollLeft=this.m_currentScrollLeft,this.m_currentScrollLeft=e,this.m_prevScrollTop=this.m_currentScrollTop,this.m_currentScrollTop=t,this._checkScroll=!1,this.m_utils.isTouchDevice()||(this._shouldLongScroll(e,t)?this.handleLongScroll(e,t):this.fillViewport(),this._checkScroll=!0),this._syncScroller(),this._adjustScrollerSize(),null!=this.m_cellToFocus){var i=this.m_cellToFocus;this.m_cellToFocus=null,this._setActive(i,this._createActiveObject(i),null,!1,!1,!0)}null!=this.m_scrollIndexAfterFetch&&this._isInViewport(this.m_scrollIndexAfterFetch)===I.INSIDE&&(this._isDatabodyCellActive()&&this.m_scrollIndexAfterFetch.row===this.m_active.indexes.row&&this.m_scrollIndexAfterFetch.column===this.m_active.indexes.column&&this._highlightActive(),this.m_scrollIndexAfterFetch=null),null!=this.m_scrollHeaderAfterFetch&&(this._isDatabodyCellActive()||this.m_scrollHeaderAfterFetch.axis!==this.m_active.axis||this.m_scrollHeaderAfterFetch.index!==this.m_active.index||this.m_scrollHeaderAfterFetch.level!==this.m_active.level||this._highlightActive(),this.m_scrollHeaderAfterFetch=null),this.m_utils.isTouchDevice()||this.m_prevScrollTop===t&&this.m_prevScrollLeft===e||this.fireEvent("scroll",{event:null,ui:{scrollX:e,scrollY:t}}),!this.m_utils.isTouchDevice()&&this.isFetchComplete()&&this._checkScrollPosition()},I.prototype._scrollTransitionEnd=function(){this._isSelectionEnabled()&&this._scrollTouchSelectionAffordance(),this.fireEvent("scroll",{event:null,ui:{scrollX:this.m_currentScrollLeft,scrollY:this.m_currentScrollTop}}),this._shouldLongScroll(this.m_currentScrollLeft,this.m_currentScrollTop)?this.handleLongScroll(this.m_currentScrollLeft,this.m_currentScrollTop):this.fillViewport(),this._checkScroll=!0,this.isFetchComplete()&&this._checkScrollPosition()},I.prototype._bounceBack=function(){var e=this.m_currentScrollLeft,t=this.m_currentScrollTop,i=this.m_databody.firstChild,s=this.m_colHeader.firstChild,n=this.m_rowHeader.firstChild,o=this.m_colEndHeader.firstChild,r=this.m_rowEndHeader.firstChild;i.style.transitionDuration=I.BOUNCE_ANIMATION_DURATION+"ms",n.style.transitionDuration=I.BOUNCE_ANIMATION_DURATION+"ms",r.style.transitionDuration=I.BOUNCE_ANIMATION_DURATION+"ms",s.style.transitionDuration=I.BOUNCE_ANIMATION_DURATION+"ms",o.style.transitionDuration=I.BOUNCE_ANIMATION_DURATION+"ms",null==this.m_scrollTransitionEnd&&(this.m_scrollTransitionEnd=this._scrollTransitionEnd.bind(this)),this._onTransitionEnd(i,this.m_scrollTransitionEnd,I.BOUNCE_ANIMATION_DURATION),this.getResources().isRTLMode()?(i.style.transform="translate3d("+e+"px, "+-t+"px, 0)",s.style.transform="translate3d("+e+"px, 0, 0)",o.style.transform="translate3d("+e+"px, 0, 0)"):(i.style.transform="translate3d("+-e+"px, "+-t+"px, 0)",s.style.transform="translate3d("+-e+"px, 0, 0)",o.style.transform="translate3d("+-e+"px, 0, 0)"),n.style.transform="translate3d(0, "+-t+"px, 0)",r.style.transform="translate3d(0, "+-t+"px, 0)",this.m_extraScrollOverX=null,this.m_extraScrollOverY=null},I.prototype._syncScroller=function(){var e=this.m_currentScrollLeft,t=this.m_currentScrollTop,i=this.m_databody.firstChild,s=this.m_colHeader.firstChild,n=this.m_rowHeader.firstChild,o=this.m_colEndHeader.firstChild,r=this.m_rowEndHeader.firstChild;if(this.m_utils.isTouchDevice()&&Object.prototype.hasOwnProperty.call(window,"WebKitCSSMatrix"))this._checkScroll=!1,null!=this.m_extraScrollOverX||null!=this.m_extraScrollOverY?(null!=this.m_extraScrollOverX?e+=this.m_extraScrollOverX:t+=this.m_extraScrollOverY,null==this.m_bounceBack&&(this.m_bounceBack=this._bounceBack.bind(this)),this._onTransitionEnd(i,this.m_bounceBack,500)):"0ms"===i.style.transitionDuration?this._scrollTransitionEnd():(null==this.m_scrollTransitionEnd&&(this.m_scrollTransitionEnd=this._scrollTransitionEnd.bind(this)),this._onTransitionEnd(i,this.m_scrollTransitionEnd,i.style.transitionDuration)),this.getResources().isRTLMode()?(i.style.transform="translate3d("+e+"px, "+-t+"px, 0)",s.style.transform="translate3d("+e+"px, 0, 0)",o.style.transform="translate3d("+e+"px, 0, 0)"):(i.style.transform="translate3d("+-e+"px, "+-t+"px, 0)",s.style.transform="translate3d("+-e+"px, 0, 0)",o.style.transform="translate3d("+-e+"px, 0, 0)"),n.style.transform="translate3d(0, "+-t+"px, 0)",r.style.transform="translate3d(0, "+-t+"px, 0)";else{var l=this.getResources().isRTLMode()?"right":"left";this.setElementDir(s,-e,l),this.setElementDir(o,-e,l),this.setElementDir(n,-t,"top"),this.setElementDir(r,-t,"top")}},I.prototype._adjustScrollerSize=function(){var e=this.m_databody.firstChild,t=this.getElementHeight(e),i=this.getElementWidth(e);(this._getMaxBottomPixel()>t||this.getDataSource().getCount("row")===this._getMaxBottom()+1&&!this._isCountUnknown("row")&&this._getMaxBottom()>-1)&&this.setElementHeight(e,this._getMaxBottomPixel()),(this._getMaxRightPixel()>i||this.getDataSource().getCount("column")===this._getMaxRight()+1&&!this._isCountUnknown("column")&&this._getMaxRight()>-1)&&this.setElementWidth(e,this._getMaxRightPixel())},I.prototype._getLongScrollStart=function(e,t,i){var s,n,o,r,l,a,h,d;if(t!==e){"row"===i?(s=this.getElementHeight(this.m_databody.firstChild),n=this.m_utils._getMaxDivHeightForScrolling(),o=this._getMaxScrollHeight(),r=this.m_avgRowHeight,l=this.m_hasHorizontalScroller?this.m_utils.getScrollbarSize():0,d=Math.max(Math.max(this.getDataSource().getCount(i),this.m_endRow),0)):"column"===i&&(s=this.getElementWidth(this.m_databody.firstChild),n=this.m_utils._getMaxDivWidthForScrolling(),o=this._getMaxScrollWidth(),r=this.m_avgColWidth,l=this.m_hasVerticalScroller?this.m_utils.getScrollbarSize():0,d=Math.max(Math.max(this.getDataSource().getCount(i),this.m_endCol),0));var c=Math.max(Math.min(e/s,1),0),m=this.getFetchSize(i);a=Math.floor(d*c),h=n<=s?Math.min(e,o):a*r,(1===c||e+m*r>s-l)&&(a=Math.max(d-m,0),h=Math.max(s-m*r,0))}else"row"===i?(a=this.m_startRow,h=this.m_startRowPixel):"column"===i&&(a=this.m_startCol,h=this.m_startColPixel);return{start:a,startPixel:h}},I.prototype.handleLongScroll=function(e,t){if(this.m_isLongScroll=!0,this.isFetchComplete()&&this._isScrollBackToEditable(!0)){var i=this._getLongScrollStart(t,this.m_prevScrollTop,"row"),s=i.start,n=i.startPixel,o=this._getLongScrollStart(e,this.m_prevScrollLeft,"column"),r=o.start,l=o.startPixel;this.m_hasCells&&(this.m_startRow=s,this.m_endRow=-1,this.m_startRowPixel=n,this.m_endRowPixel=n,this.m_startCol=r,this.m_endCol=-1,this.m_startColPixel=l,this.m_endColPixel=l),this.m_hasRowHeader&&(this.m_startRowHeader=s,this.m_endRowHeader=-1,this.m_startRowHeaderPixel=n,this.m_endRowHeaderPixel=n),this.m_hasRowEndHeader&&(this.m_startRowEndHeader=s,this.m_endRowEndHeader=-1,this.m_startRowEndHeaderPixel=n,this.m_endRowEndHeaderPixel=n),this.m_hasColHeader&&(this.m_startColHeader=r,this.m_endColHeader=-1,this.m_startColHeaderPixel=l,this.m_endColHeaderPixel=l),this.m_hasColEndHeader&&(this.m_startColEndHeader=r,this.m_endColEndHeader=-1,this.m_startColEndHeaderPixel=l,this.m_endColEndHeaderPixel=l),this.m_stopRowFetch=!1,this.m_stopRowHeaderFetch=!1,this.m_stopRowEndHeaderFetch=!1,this.m_stopColumnFetch=!1,this.m_stopColumnHeaderFetch=!1,this.m_stopColumnEndHeaderFetch=!1,this.fetchHeaders("row",s,this.m_rowHeader,this.m_rowEndHeader,void 0,{success:function(e,t,i){this.handleRowHeadersFetchSuccessForLongScroll(e,t,i)}}),this.fetchHeaders("column",r,this.m_colHeader,this.m_colEndHeader,void 0,{success:function(e,t,i){this.handleColumnHeadersFetchSuccessForLongScroll(e,t,i)}}),this.fetchCells(this.m_databody,s,r,null,null,{success:function(e,t){this.handleCellsFetchSuccessForLongScroll(e,t,s,r,n,l)}})}},I.prototype.handleRowHeadersFetchSuccessForLongScroll=function(e,t,i){var s=this.m_rowHeader.firstChild,n=this.m_rowEndHeader.firstChild;null!=s&&this.m_utils.empty(s),null!=n&&this.m_utils.empty(n),this.handleHeadersFetchSuccess(e,t,i,!1)},I.prototype.handleColumnHeadersFetchSuccessForLongScroll=function(e,t,i){var s=this.m_colHeader.firstChild,n=this.m_colEndHeader.firstChild;null!=s&&this.m_utils.empty(s),null!=n&&this.m_utils.empty(n),this.handleHeadersFetchSuccess(e,t,i,!1)},I.prototype.handleCellsFetchSuccessForLongScroll=function(e,t,i,s,n,o){var r=this.m_databody.firstChild;null!=r&&this._emptyDatabody(r),this.handleCellsFetchSuccess(e,t)},I.prototype._cleanupViewport=function(e){if(!this._isHighWatermarkScrolling()&&this._isScrollBackToEditable()){null==e&&(this.m_prevScrollLeft>this.m_currentScrollLeft?e="right":this.m_prevScrollLeft<this.m_currentScrollLeft?e="left":this.m_prevScrollTop>this.m_currentScrollTop?e="bottom":this.m_prevScrollTop<this.m_currentScrollTop&&(e="top"));var t=this._getViewportLeft(),i=this._getViewportRight(),s=this._getViewportTop(),n=this._getViewportBottom();"top"===e&&s>this._getMaxTopPixel()?(this.removeRowsFromTop(this.m_databody),this.removeRowHeadersFromTop()):"bottom"===e&&n<this._getMaxBottomPixel()?(this.removeRowsFromBottom(this.m_databody),this.removeRowHeadersFromBottom()):"left"===e&&t>this._getMaxLeftPixel()?(this.removeColumnsFromLeft(this.m_databody),this.removeColumnHeadersFromLeft()):"right"===e&&i<this._getMaxRightPixel()&&(this.removeColumnsFromRight(this.m_databody),this.removeColumnHeadersFromRight())}},I.prototype.fillViewport=function(){var e,t;if(this.isFetchComplete()){var i=this._getViewportLeft(),s=this._getViewportRight()+I.FETCH_PIXEL_THRESHOLD,n=this._getViewportTop(),o=this._getViewportBottom()+I.FETCH_PIXEL_THRESHOLD;if(this._getMaxBottomPixel()<=o&&(!this.m_stopRowHeaderFetch||!this.m_stopRowEndHeaderFetch||!this.m_stopRowFetch))return e=Math.max(0,this._getMaxBottom()+1),t=Math.max(0,this.getFetchCount("row",e)),this.fetchHeaders("row",e,this.m_rowHeader,this.m_rowEndHeader,t),void this.fetchCells(this.m_databody,e,this.m_startCol,t,this.m_endCol-this.m_startCol+1);if((this._getMaxTopPixel()>n||0===this.m_currentScrollTop)&&this._getMaxTop()>0)return e=Math.max(0,this._getMaxTop()-this.getFetchSize("row")),t=Math.max(0,this._getMaxTop()-e),this.fetchHeaders("row",e,this.m_rowHeader,this.m_rowEndHeader,t),void this.fetchCells(this.m_databody,e,this.m_startCol,t,this.m_endCol-this.m_startCol+1);if(this._getMaxRightPixel()<=s&&(!this.m_stopColumnHeaderFetch||!this.m_stopColumnEndHeaderFetch||!this.m_stopColumnFetch))return e=Math.max(0,this._getMaxRight()+1),t=Math.max(0,this.getFetchCount("column",e)),this.fetchHeaders("column",e,this.m_colHeader,this.m_colEndHeader,t),void this.fetchCells(this.m_databody,this.m_startRow,e,this.m_endRow-this.m_startRow+1,t);(this._getMaxLeftPixel()>i||0===this.m_currentScrollLeft)&&this._getMaxLeft()>0&&(e=Math.max(0,this._getMaxLeft()-this.getFetchSize("column")),t=Math.max(0,this._getMaxLeft()-e),this.fetchHeaders("column",e,this.m_colHeader,this.m_colEndHeader,t),this.fetchCells(this.m_databody,this.m_startRow,e,this.m_endRow-this.m_startRow+1,t))}},I.prototype._getMaxRight=function(){return Math.max(Math.max(this.m_endCol,this.m_endColHeader),this.m_endColEndHeader)},I.prototype._getMaxLeft=function(){return Math.max(Math.max(this.m_startCol,this.m_startColHeader),this.m_startColEndHeader)},I.prototype._getMaxRightPixel=function(){return Math.max(Math.max(this.m_endColPixel,this.m_endColHeaderPixel),this.m_endColEndHeaderPixel)},I.prototype._getMaxLeftPixel=function(){return Math.max(Math.max(this.m_startColPixel,this.m_startColHeaderPixel),this.m_startColEndHeaderPixel)},I.prototype._getMaxBottom=function(){return Math.max(Math.max(this.m_endRow,this.m_endRowHeader),this.m_endRowEndHeader)},I.prototype._getMaxTop=function(){return Math.max(Math.max(this.m_startRow,this.m_startRowHeader),this.m_startRowEndHeader)},I.prototype._getMaxBottomPixel=function(){return Math.max(Math.max(this.m_endRowPixel,this.m_endRowHeaderPixel),this.m_endRowEndHeaderPixel)},I.prototype._getMaxTopPixel=function(){return Math.max(Math.max(this.m_startRowPixel,this.m_startRowHeaderPixel),this.m_startRowEndHeaderPixel)},I.prototype._isScrollBackToEditable=function(e){var t=this._getCurrentMode(),i=this._getActiveElement();return"edit"!==t||!e&&!this._isCellGoingToBeRemoved(i)||this._handleExitEdit(null,i)},I.prototype._isCellGoingToBeRemoved=function(e){if(!this._isHighWatermarkScrolling()){if(this.m_endRow-this.m_startRow>this.MAX_ROW_THRESHOLD){var t=this.getElementDir(e.parentNode,"top");if(t+this.getElementHeight(e)<this.m_currentScrollTop||t<this.m_currentScrollTop+this.getViewportHeight())return!0}if(this.m_endCol-this.m_startCol>this.MAX_COLUMN_THRESHOLD){var i=this.getElementDir(e,"left");if(i+this.getElementWidth(e)<this.m_currentScrollLeft||i<this.m_currentScrollLeft+this.getViewportHeight())return!0}}},I.prototype._removeCellsAlongAxis=function(e,t,i){var s,n,o,r,l,a,h,d,c,m,u,_,p,g,f=0,C=0;for("row"===e?(n=this.m_startRow,o=this.m_endRow,r=this.m_rowHeader,l=this.m_rowHeaderLevelCount,a=this.m_startRowHeader,h="height",d=this.m_startRowPixel,c=this.m_endRowPixel,m=this.m_currentScrollTop,u="column",_=this.m_startCol,p=this.m_endCol,g="top",s=i?o:n):(n=this.m_startCol,o=this.m_endCol,r=this.m_colHeader,l=this.m_columnHeaderLevelCount,a=this.m_startColHeader,h="width",d=this.m_startColPixel,c=this.m_endColPixel,m=this.m_currentScrollLeft,u="row",_=this.m_startRow,p=this.m_endRow,g=this.getResources().isRTLMode()?"right":"left",s=i?o:n);s<=o&&s>=n;){var y=this._getKey(this._getHeaderByIndex(s,l-1,r,l,a),e);null==y&&(y=this._getKey(this._getCellByIndex("column"===e?this.createIndex(this.m_startRow,s):this.createIndex(s,this.m_startCol)),e));var v=this._getCellDimension(null,s,y,e,h);if(!(i?c-v-f>t:d+v+f<m-t))break;for(var E,S=_;S<=p;S+=E){var w=this._getCellByIndex("column"===e?this.createIndex(S,s):this.createIndex(s,S)),H=w[this.getResources().getMappedAttribute("context")],b=H.extents[e];E=H.extents[u],1===b?this._remove(w):(H.extents[e]-=1,this.setElementDir(w,this.getElementDir(w,h)-v,h),i||(H.indexes[e]+=1,this.setElementDir(w,this.getElementDir(w,g)+v,g)));for(var x=0;x<E;x++){var R="column"===e?this.createIndex(S+x,s):this.createIndex(s,S+x);this._removeIndexFromDatabodyMap(R)}}f+=v,C+=1,s=i?s-1:s+1}return{dimensionChange:f,extentChange:C}},I.prototype.removeHeadersFromStartOfContainer=function(e,t,i,s,n,o,r,l){var a=0,h=0,d=null==t?e.firstChild:t.nextSibling;if(null==d)return{extentChange:0,dimensionChange:0};for(var c=this.m_utils.containsCSSClassName(d,n),m=c?d:d.firstChild,u=this.getElementDir(m,o);i+u<l-s;){if(this._remove(d),h+=u,a+=c?1:this._getAttribute(d,"extent",!0),i+=u,null==(d=null==t?e.firstChild:t.nextSibling))return{extentChange:a,dimensionChange:h};m=(c=this.m_utils.containsCSSClassName(d,n))?d:d.firstChild,u=this.getElementDir(m,o)}if(!c){var _=this.removeHeadersFromStartOfContainer(d,d.firstChild,i,s,n,o,r,l);this._setAttribute(d,"start",this._getAttribute(d,"start",!0)+_.extentChange),this._setAttribute(d,"extent",this._getAttribute(d,"extent",!0)-_.extentChange),this.setElementDir(m,this.getElementDir(m,r)+_.dimensionChange,r),this.setElementDir(m,this.getElementDir(m,o)-_.dimensionChange,o),a+=_.extentChange,h+=_.dimensionChange}return{extentChange:a,dimensionChange:h}},I.prototype.removeHeadersFromEndOfContainer=function(e,t,i,s,n){for(var o=0,r=0,l=e.lastChild,a=this.m_utils.containsCSSClassName(l,s),h=a?l:l.firstChild,d=this.getElementDir(h,n);t-d>i;)this._remove(l),r+=d,o+=a?1:this._getAttribute(l,"extent",!0),t-=d,l=e.lastChild,h=(a=this.m_utils.containsCSSClassName(l,s))?l:l.firstChild,d=this.getElementDir(h,n);if(!a){var c=this.removeHeadersFromEndOfContainer(l,t,i,s,n);this._setAttribute(l,"extent",this._getAttribute(l,"extent",!0)-c.extentChange),this.setElementDir(h,this.getElementDir(h,n)-c.dimensionChange,n),o+=c.extentChange,r+=c.dimensionChange}return{extentChange:o,dimensionChange:r}},I.prototype.removeColumnHeadersFromLeft=function(){var e,t;if(this.m_endColHeader-this.m_startColHeader>this.MAX_COLUMN_THRESHOLD){var i=this.m_colHeader.firstChild;e=this.getColumnThreshold(),this.m_startColHeaderPixel<=this.m_currentScrollLeft-e&&(t=this.removeHeadersFromStartOfContainer(i,null,this.m_startColHeaderPixel,e,this.getMappedStyle("colheadercell"),"width",this.getResources().isRTLMode()?"right":"left",this.m_currentScrollLeft),this.m_startColHeaderPixel+=t.dimensionChange,this.m_startColHeader+=t.extentChange)}if(this.m_endColEndHeader-this.m_startColEndHeader>this.MAX_COLUMN_THRESHOLD){var s=this.m_colEndHeader.firstChild;e=this.getColumnThreshold(),this.m_startColEndHeaderPixel<this.m_currentScrollLeft-e&&(t=this.removeHeadersFromStartOfContainer(s,null,this.m_startColEndHeaderPixel,e,this.getMappedStyle("colendheadercell"),"width",this.getResources().isRTLMode()?"right":"left",this.m_currentScrollLeft),this.m_startColEndHeaderPixel+=t.dimensionChange,this.m_startColEndHeader+=t.extentChange)}},I.prototype.removeColumnsFromLeft=function(e){if(this.m_endCol-this.m_startCol>this.MAX_COLUMN_THRESHOLD){var t=e.firstChild.childNodes,i=this.getColumnThreshold();if(t.length<1)return;var s=this._removeCellsAlongAxis("column",i,!1);this.m_startColPixel+=s.dimensionChange,this.m_startCol+=s.extentChange}},I.prototype.removeColumnHeadersFromRight=function(){var e,t,i=this.m_currentScrollLeft+this.getViewportWidth()+this.getColumnThreshold();this.m_endColHeader-this.m_startColHeader>this.MAX_COLUMN_THRESHOLD&&(e=this.m_colHeader.firstChild,this.m_endColHeaderPixel>i&&(this.m_stopColumnHeaderFetch&&(this.m_stopColumnHeaderFetch=!1),t=this.removeHeadersFromEndOfContainer(e,this.m_endColHeaderPixel,i,this.getMappedStyle("colheadercell"),"width"),this.m_endColHeaderPixel-=t.dimensionChange,this.m_endColHeader-=t.extentChange)),this.m_endColEndHeader-this.m_startColEndHeader>this.MAX_COLUMN_THRESHOLD&&(e=this.m_colEndHeader.firstChild,this.m_endColEndHeaderPixel>i&&(this.m_stopColumnEndHeaderFetch&&(this.m_stopColumnEndHeaderFetch=!1),t=this.removeHeadersFromEndOfContainer(e,this.m_endColEndHeaderPixel,i,this.getMappedStyle("colendheadercell"),"width"),this.m_endColEndHeaderPixel-=t.dimensionChange,this.m_endColEndHeader-=t.extentChange))},I.prototype.removeColumnsFromRight=function(e){if(this.m_endCol-this.m_startCol>this.MAX_COLUMN_THRESHOLD){var t=e.firstChild.childNodes,i=this.m_currentScrollLeft+this.getViewportWidth()+this.getColumnThreshold();if(this.m_endColPixel<=i||t.length<1)return;this.m_stopColumnFetch&&(this.m_stopColumnFetch=!1);var s=this._removeCellsAlongAxis("column",i,!0);this.m_endColPixel-=s.dimensionChange,this.m_endCol-=s.extentChange}},I.prototype.removeRowHeadersFromTop=function(){var e,t;if(this.m_endRowHeader-this.m_startRowHeader>this.MAX_ROW_THRESHOLD){var i=this.m_rowHeader.firstChild;t=this.getRowThreshold(),this.m_startRowHeaderPixel>=this.m_currentScrollTop-t||(e=this.removeHeadersFromStartOfContainer(i,null,this.m_startRowHeaderPixel,t,this.getMappedStyle("rowheadercell"),"height","top",this.m_currentScrollTop),this.m_startRowHeaderPixel+=e.dimensionChange,this.m_startRowHeader+=e.extentChange)}if(this.m_endRowEndHeader-this.m_startRowEndHeader>this.MAX_ROW_THRESHOLD){var s=this.m_rowEndHeader.firstChild;t=this.getRowThreshold(),this.m_startRowEndHeaderPixel>=this.m_currentScrollTop-t||(e=this.removeHeadersFromStartOfContainer(s,null,this.m_startRowEndHeaderPixel,t,this.getMappedStyle("rowendheadercell"),"height","top",this.m_currentScrollTop),this.m_startRowEndHeaderPixel+=e.dimensionChange,this.m_startRowEndHeader+=e.extentChange)}},I.prototype.removeRowsFromTop=function(e){if(this.m_endRow-this.m_startRow>this.MAX_ROW_THRESHOLD){var t=this.getRowThreshold();if(this.m_startRowPixel>=this.m_currentScrollTop-t)return;var i=this._removeCellsAlongAxis("row",t,!1);this.m_startRowPixel+=i.dimensionChange,this.m_startRow+=i.extentChange}},I.prototype.removeRowHeadersFromBottom=function(){var e,t=this.m_currentScrollTop+this.getViewportHeight()+this.getRowThreshold();if(this.m_endRowHeader-this.m_startRowHeader>this.MAX_ROW_THRESHOLD){var i=this.m_rowHeader.firstChild;this.m_endRowHeaderPixel<=t||(this.m_stopRowHeaderFetch&&(this.m_stopRowHeaderFetch=!1),e=this.removeHeadersFromEndOfContainer(i,this.m_endRowHeaderPixel,t,this.getMappedStyle("rowheadercell"),"height"),this.m_endRowHeaderPixel-=e.dimensionChange,this.m_endRowHeader-=e.extentChange)}if(this.m_endRowEndHeader-this.m_startRowEndHeader>this.MAX_ROW_THRESHOLD){var s=this.m_rowEndHeader.firstChild;this.m_endRowEndHeaderPixel<=t||(this.m_stopRowEndHeaderFetch&&(this.m_stopRowEndHeaderFetch=!1),e=this.removeHeadersFromEndOfContainer(s,this.m_endRowEndHeaderPixel,t,this.getMappedStyle("rowendheadercell"),"height"),this.m_endRowEndHeaderPixel-=e.dimensionChange,this.m_endRowEndHeader-=e.extentChange)}},I.prototype.removeRowsFromBottom=function(e){if(this.m_endRow-this.m_startRow>this.MAX_ROW_THRESHOLD){var t=this.m_currentScrollTop+this.getViewportHeight()+this.getRowThreshold();if(this.m_endRowPixel<=t)return;this.m_stopRowFetch&&(this.m_stopRowFetch=!1);var i=this._removeCellsAlongAxis("row",t,!0);this.m_endRowPixel-=i.dimensionChange,this.m_endRow-=i.extentChange}},I.prototype.handleContextMenuGesture=function(e,t,i){var s,n,o,r,l=e.originalEvent.target,a=this.findCell(l),h=!1;if(null===a&&(a=this.findHeader(l))&&(h=!0,r=this.getHeaderCellAxis(a)),"touch"===t&&null!=a){s=h?this.getHeaderCellIndex(a):this.getCellIndexes(a);let t=h?this._isHeaderInsideSelection(s,r):this._isContainSelection(s);(!this.isMultipleSelection()||!t||this._isDatabodyCellActive()&&s.row!==this.m_active.indexes.row&&s.column!==this.m_active.indexes.column)&&(this._isSelectionEnabled()?this.handleDatabodyClickSelection(e.originalEvent):this.handleDatabodyClickActive(e.originalEvent))}if(!this.m_utils._isNodeEditableOrClickable(l,this.m_root)){if(null==a||h)if(null==(a=this.findHeader(l)||this.findLabel(l))){var d="disable";n={resize:d,resizeWidth:d,resizeHeight:d,sortRow:d,sortCol:d,cut:d,paste:d,sortColAsc:d,sortColDsc:d,sortRowAsc:d,sortRowDsc:d},o=a}else(n=this._getHeaderCapability(a)).resizeFitToContent=h?"enable":"disable","column"!==r&&"columnEnd"!==r||!this.m_selectionFrontier||"column"!==this.m_selectionFrontier.axis?"row"!==r&&"rowEnd"!==r||!this.m_selectionFrontier||"row"!==this.m_selectionFrontier.axis||(n.resizeWidth="disable"):n.resizeHeight="disable",o=a;else s=this.getCellIndexes(a),this.isMultipleSelection()&&this._isContainSelection(s)?(o=this._getActiveElement(),this._isDatabodyCellActive()?(null==o&&(o=a),(n="keyboard"===t?this._getCellCapability(o):this._getCellCapability(o,a)).resizeFitToContent="disable"):(n=this._getHeaderCapability(o,a)).resizeFitToContent="enable"):(o=a,(n=this._getCellCapability(o)).resizeFitToContent="disable"),this.m_selectionFrontier&&"row"===this.m_selectionFrontier.axis?n.resizeWidth="disable":this.m_selectionFrontier&&"column"===this.m_selectionFrontier.axis&&(n.resizeHeight="disable");i.call(null,{capabilities:n,launcher:o},e,t)}},I.prototype._getCellCapability=function(e,t){var i=!0,s=!0,n="disable",o="enable",r={resize:n,resizeWidth:n,resizeHeight:n,sortRow:n,sortCol:n,cut:n,cutCells:n,copyCells:n,paste:n,pasteCells:n,fill:n,sortColAsc:n,sortColDsc:n,sortRowAsc:n,sortRowDsc:n};if(null!=t&&(i=this._getIndex(e,"column")===this._getIndex(t,"column"),!1===(s=this._getKey(e,"row")===this._getKey(t,"row"))&&!1===i))return r;this.m_options.isCopyEnabled()&&(r.copyCells=o),this.m_options.isCutEnabled()&&(r.cutCells=o),this.m_options.isPasteEnabled()&&(r.pasteCells=o),this.m_options.isFloodFillEnabled()&&(r.fill=o);var l=this.getHeaderFromCell(e,"row"),a=this.getHeaderFromCell(e,"column"),h=this.getResources().getMappedAttribute("resizable"),d=this.getResources().getMappedAttribute("sortable");if(null!=a&&i&&("true"===a.getAttribute(h)&&(r.resize=o,r.resizeWidth=o),"true"===a.getAttribute(d))){r.sortCol=o,r.sortColAsc=o,r.sortColDsc=o;var c=a.getAttribute(this.getResources().getMappedAttribute("sortDir"));"ascending"===c?r.sortColAsc=n:"descending"===c&&(r.sortColDsc=n)}return null!=l&&s&&(this._isMoveEnabled("row")&&(r.cut=o,r.paste=o),"true"===l.getAttribute(d)&&(r.sortRow=o,r.sortRowAsc=o,r.sortRowDsc=o),null!=l&&("true"===l.getAttribute(h)&&(r.resize=o,r.resizeHeight=o),"true"===l.getAttribute(d)&&(r.sortRow=o))),r},I.prototype._getHeaderCapability=function(e,t){var i=!0,s=!0,n="disable",o="enable",r={resize:n,resizeWidth:n,resizeHeight:n,sortRow:n,sortCol:n,cut:n,paste:n,sortColAsc:n,sortColDsc:n,sortRowAsc:n,sortRowDsc:n};if(null!=t&&(i=this.getHeaderCellIndex(e)===this._getIndex(t,"column"),!1===(s=this._getKey(e,"row")===this._getKey(t,"row"))&&!1===i))return r;var l=this.getHeaderCellAxis(e),a=this.getResources().getMappedAttribute("resizable"),h=this.getResources().getMappedAttribute("sortable");if(null!==e)if("column"!==l&&"columnEnd"!==l||!i){if(s&&(this._isMoveEnabled("row")&&(r.cut=o,r.paste=o),"true"===e.getAttribute(a)&&(r.resize=o,r.resizeHeight=o),r.resizeWidth=this.m_options.isResizable(l,"width"),"true"===e.getAttribute(h))){r.sortRow=o,r.sortRowAsc=o,r.sortRowDsc=o;let t=e.getAttribute(this.getResources().getMappedAttribute("sortDir"));"ascending"===t?r.sortRowAsc=n:"descending"===t&&(r.sortRowDsc=n)}}else if("true"===e.getAttribute(a)&&(r.resizeWidth=o,r.resize=o),r.resizeHeight=this.m_options.isResizable(l,"height"),"true"===e.getAttribute(h)){r.sortCol=o,r.sortColAsc=o,r.sortColDsc=o;var d=e.getAttribute(this.getResources().getMappedAttribute("sortDir"));"ascending"===d?r.sortColAsc=n:"descending"===d&&(r.sortColDsc=n)}return r.resize=r.resizeHeight===o||r.resizeWidth===o?o:n,r},I.prototype.handleContextMenuReturn=function(e,t,i){var s,n;if(null!=this.m_active&&(s=this._getActiveElement()),t===this.m_resources.getMappedCommand("resizeHeight")||t===this.m_resources.getMappedCommand("resizeWidth"))this.isResizeEnabled()&&this.handleContextMenuResize(e,t,i,s);else if(t===this.m_resources.getMappedCommand("resizeFitToContent")){let t,i=this.findCell(e.target);i&&(t=this.getHeaderFromCell(i,this.m_selectionFrontier.axis)),t||(t=this.findHeader(e.target)),t||(t=this.findLabel(e.target)),t&&(this.m_resizingElement=t);const s=this.getHeaderCellAxis(this.m_resizingElement),n=this.getHeaderCellLevel(this.m_resizingElement);let o=!1;("row"!==s&&"rowEnd"!==s||n!==this.m_rowHeaderLevelCount-1)&&("column"!==s&&"columnEnd"!==s||n!==this.m_columnHeaderLevelCount-1)||(o=!0),o&&this.isResizeEnabled()&&this._getHeadersForResizeFitToContent(e)}else t===this.m_resources.getMappedCommand("sortColAsc")||t===this.m_resources.getMappedCommand("sortColDsc")?(n=t===this.m_resources.getMappedCommand("sortColAsc")?"ascending":"descending",this.m_utils.containsCSSClassName(s,this.getMappedStyle("cell"))&&(s=this.getHeaderFromCell(s,"column")),this._isDOMElementSortable(s)&&this._handleCellSort(e,n,s)):t===this.m_resources.getMappedCommand("sortRowAsc")||t===this.m_resources.getMappedCommand("sortRowDsc")?(n=t===this.m_resources.getMappedCommand("sortRowAsc")?"ascending":"descending",this.m_utils.containsCSSClassName(s,this.getMappedStyle("cell"))&&(s=this.getHeaderFromCell(s,"row")),this._isDOMElementSortable(s)&&this._handleCellSort(e,n,s)):t===this.m_resources.getMappedCommand("cut")?this._handleCut(e,s):t===this.m_resources.getMappedCommand("paste")?this._handlePaste(e,s):t===this.m_resources.getMappedCommand("cutCells")?this._handleCutCells(e,s):t===this.m_resources.getMappedCommand("copyCells")?this._handleCopyCells(e,s):t===this.m_resources.getMappedCommand("pasteCells")?this._handlePasteCells(e,s):t===this.m_resources.getMappedCommand("autoFill")?this._handleAutofill(e,s):t===this.m_resources.getMappedCommand("discontiguousSelection")&&this.setDiscontiguousSelectionMode(i)},I.prototype._isSortEnabled=function(e,t){var i=this.getDataSource().getCapability("sort"),s=this.m_options.isSortable(e,t);return!("enable"!==s&&"auto"!==s||"full"!==i&&i!==e)&&(!this._isDataGridProvider()||null!=t.metadata.sortDirection)},I.prototype._isParentNode=function(e){return!!this._isDataGridProvider()&&(e.metadata.expanded&&null!==e.metadata.expanded)},I.prototype._isHierarchicalGroup=function(e){return null==e.metadata.treeDepth},I.prototype._isLeafNode=function(e){if(!e.metadata)return!1;const t=e.metadata.treeDepth;return!!this._isDataGridProvider()&&(null!=t&&0!==t)},I.prototype._isDOMElementSortable=function(e){if(null==e)return!1;var t=this.findHeader(e);return null!=t&&"true"===t.getAttribute(this.getResources().getMappedAttribute("sortable"))},I.prototype._isSelectionEnabled=function(){return"none"!==this.m_options.getSelectionCardinality()},I.prototype.isMultipleSelection=function(){return"multiple"===this.m_options.getSelectionCardinality()},I.prototype.isResizeEnabled=function(){return this.m_options.isResizable("row","width")||this.m_options.isResizable("row","height")||this.m_options.isResizable("column","width")||this.m_options.isResizable("column","height")||this.m_options.isResizable("rowEnd","width")||this.m_options.isResizable("rowEnd","height")||this.m_options.isResizable("columnEnd","width")||this.m_options.isResizable("columnEnd","height")},I.prototype._isHeaderResizeEnabled=function(e,t){return"column"===e||"columnEnd"===e?"enable"===this.m_options.isResizable(e,"width",t):("row"===e||"rowEnd"===e)&&"enable"===this.m_options.isResizable(e,"height",t)},I.prototype.handleMouseMove=function(e){this.isResizeEnabled()&&!1===this.m_databodyDragState&&this.handleResize(e)},I.prototype.handleRowHeaderMouseMove=function(e){0===e.buttons&&this.handleMouseUp(e),this.m_databodyMove?this._handleMove(e):this.m_headerDragState&&(this.m_selectionFrontier&&this.m_selectionFrontier.axis&&-1!==this.m_selectionFrontier.axis.indexOf("row")||this.m_deselectInfo&&this.m_deselectInfo.axis&&-1!==this.m_deselectInfo.axis.indexOf("row"))?this.extendSelectionHeader(e.target,e,!0,this.m_deselectInProgress):this.m_isResizing||this.handleMouseMove(e)},I.prototype.handleColumnHeaderMouseMove=function(e){0===e.buttons&&this.handleMouseUp(e),this.m_headerDragState&&(this.m_selectionFrontier&&this.m_selectionFrontier.axis&&-1!==this.m_selectionFrontier.axis.indexOf("column")||this.m_deselectInfo&&this.m_deselectInfo.axis&&-1!==this.m_deselectInfo.axis.indexOf("column"))?this.extendSelectionHeader(e.target,e,!0,this.m_deselectInProgress):this.m_isResizing||this.handleMouseMove(e)},I.prototype.handleHeaderLabelMouseMove=function(e){this.m_isResizing||this.handleMouseMove(e)},I.prototype.handleHeaderMouseDown=function(e){var t;this._exitActionableMode();var i=e.target;if(this._isEditOrEnter()){var s=this._getActiveElement();if(!1===this._leaveEditing(e,s,!1))return}if(!this._isDisclosureIcon(i)){if(0===e.button){if((this.m_utils.containsCSSClassName(i,this.getMappedStyle("sortascending"))||this.m_utils.containsCSSClassName(i,this.getMappedStyle("sortdescending")))&&this._isDOMElementSortable(i))return e.preventDefault(),void this._handleSortIconMouseDown(i);if(this.m_utils.containsCSSClassName(i,this.getMappedStyle("sortIcon"))&&this._isDOMElementSortable(i.lastChild))return e.preventDefault(),void this._handleSortIconMouseDown(i.lastChild);this.isResizeEnabled()&&(t=this.handleResizeMouseDown(e),this._highlightResizeMouseDown());var n=this.m_utils.ctrlEquivalent(e);this.m_isResizing||n||!this._isMoveOnElementEnabled(this.findHeader(i))||(this.m_databodyMove=!0,this.m_currentX=e.pageX,this.m_currentY=e.pageY,t=!0)}if(!this.m_isResizing&&"default"===this.manageHeaderCursor(e,!1)){this.m_root.contains(document.activeElement)&&document.activeElement!==this.m_root||(this.m_externalFocus=!0);var o=this.m_options.getSelectionMode(),r=this.findHeader(i)[this.getResources().getMappedAttribute("context")];if(!this._isSelectionEnabled()||!this.isMultipleSelection()||"row"===o&&-1===r.axis.indexOf("row")||this.m_databodyMove)if("row"===o&&-1!==r.axis.indexOf("row")&&this._isSelectionEnabled())this.handleHeaderClickSelection(e);else if("row"===o&&-1!==r.axis.indexOf("column")&&this._isSelectionEnabled()){let t=!1;e.shiftKey||(t=!0),this.handleHeaderClickActive(e,t)}else this.handleHeaderClickActive(e);else 0===e.button&&(this.m_headerDragState=!0),this.handleHeaderClickSelection(e)}this.m_options.isFloodFillEnabled()&&this.m_bottomFloodFillIconContainer&&this.m_bottomFloodFillIconContainer.parentNode&&(this.m_bottomFloodFillIconContainer.parentNode.removeChild(this.m_bottomFloodFillIconContainer),this.m_bottomFloodFillIconContainer.removeEventListener("mouseover",this.handleDatabodyMouseMove)),!0===t&&e.preventDefault()}},I.prototype.handleHeaderLabelMouseDown=function(e){var t;this.isResizeEnabled()&&(t=this.handleResizeMouseDown(e),this._highlightResizeMouseDown()),!0===t&&e.preventDefault()},I.prototype.handleMouseUp=function(e){this.m_headerDragState=!1,this.m_databodyDragState=!1,this.m_deselectInProgress=!1,this.m_databodyMove?this._handleMoveMouseUp(e,!1):this.isResizeEnabled()&&this.handleResizeMouseUp(e),this.m_databodyMove=!1},I.prototype.shouldHoverHeader=function(e){const t=null==e?null:this.getHeaderCellAxis(e),i="row"===t||"rowEnd"===t,s=this.m_options.getSelectionMode();return this._isSelectionEnabled()&&(this.isMultipleSelection()&&"cell"===s||"row"===s&&i)},I.prototype.handleHeaderMouseOver=function(e){var t=e.target,i=this.findHeader(t);!this.m_isResizing&&"default"===this.manageHeaderCursor(e,!1)&&this.shouldHoverHeader(i)&&this.m_utils.addCSSClassName(i,this.getMappedStyle("hover"))},I.prototype.handleHeaderMouseOut=function(e){var t=e.target;this.m_utils.removeCSSClassName(this.findHeader(t),this.getMappedStyle("hover")),!this.m_isResizing&&this.m_resizingElement&&(this.m_resizingElement.style.cursor="",null!=this.m_resizingElementSibling&&(this.m_resizingElementSibling.style.cursor="")),this._isDOMElementSortable(t)&&this._handleSortMouseOut(e)},I.prototype.handleHeaderMouseUp=function(e){this.handleDragAnchorChange(e),this.m_headerDragState=!1,this.m_databodyDragState=!1,this.m_deselectInProgress=!1,this.m_floodFillDragState&&(this.unhighlightFloodFillRange(),this.m_selectionRange=null,this.m_floodFillRange=null,this.m_floodFillDirection=null,this.m_databody.style.cursor="default",this.m_cursor="default"),this.m_databodyMove&&this._handleMoveMouseUp(e,!0)},I.prototype.handleCornerMouseDown=function(e){let t,i=e.target,s=this.m_utils.containsCSSClassName(i,this.getMappedStyle("rowendheaderlabel"))||this.m_utils.containsCSSClassName(i,this.getMappedStyle("columnendheaderlabel")),n=this.findLabel(i);null!=n&&(t=s,this._setActive(n,this._createActiveObject(n),e,t))},I.prototype.handleCornerMouseOver=function(e){var t=e.target;this._isSelectionEnabled()&&this.isMultipleSelection()&&this.m_utils.addCSSClassName(this.findLabel(t),this.getMappedStyle("hover"))},I.prototype.handleCornerMouseOut=function(e){var t=e.target;this.m_utils.removeCSSClassName(this.findLabel(t),this.getMappedStyle("hover"))},I.prototype.handleCornerClick=function(e){this._handleSelectAll(e)},I.prototype.handleHeaderClick=function(e){var t=e.target;(this.m_utils.containsCSSClassName(t,this.getMappedStyle("sortascending"))||this.m_utils.containsCSSClassName(t,this.getMappedStyle("sortdescending"))||this.m_utils.containsCSSClassName(t,this.getMappedStyle("sortdefault")))&&this._isDOMElementSortable(t)||this.m_utils.containsCSSClassName(t,this.getMappedStyle("sortIcon"))&&this._isDOMElementSortable(t.lastChild)?(this._removeTouchSelectionAffordance(),this._handleHeaderSort(e),e.preventDefault()):this._isDisclosureIcon(e.target)&&(this._removeTouchSelectionAffordance(),this._handleExpandCollapseRequest(e),e.preventDefault())},I.prototype.handleHeaderDoubleClick=function(e){if(this.m_cursor=this.manageHeaderCursor(e,!1),"col-resize"===this.m_cursor||"row-resize"===this.m_cursor){this.m_resizingElement||(this.m_resizingElement=this.findHeader(e.target));const t=this.getHeaderCellAxis(this.m_resizingElement),i=this.getHeaderCellLevel(this.m_resizingElement);let s=!1;("row"!==t&&"rowEnd"!==t||i!==this.m_rowHeaderLevelCount-1||"row-resize"!==this.m_cursor)&&("column"!==t&&"columnEnd"!==t||i!==this.m_columnHeaderLevelCount-1||"col-resize"!==this.m_cursor)||(s=!0),s&&this.isResizeEnabled()&&this._getHeadersForResizeFitToContent(e)}},I.prototype._getHeadersForResizeFitToContent=function(e){const t=this.getHeaderCellAxis(this.m_resizingElement),i=this.getHeaderCellIndex(this.m_resizingElement);let s=[];if(this._isSelectionEnabled()&&this.isMultipleSelection()&&this.m_selection.length){let e=this.m_selection[0];s=this._getHeadersWithinSelection(e,i,t)}s.length||s.push(this.m_resizingElement),s.forEach(i=>{this.handleResizeFitToContent(e,i,t)})},I.prototype._getHeadersWithinSelection=function(e,t,i){let s,n,o,r,l,a,h,d=[];if("column"===i?(s=this.m_startColHeader,n=this.m_columnHeaderLevelCount-1,o=this.m_columnHeaderLevelCount,r=this.m_colHeader,l="column"):"columnEnd"===i?(s=this.m_startColEndHeader,n=this.m_columnEndHeaderLevelCount-1,o=this.m_columnEndHeaderLevelCount,r=this.m_colEndHeader,l="column"):"row"===i?(s=this.m_startRowHeader,n=this.m_rowHeaderLevelCount-1,o=this.m_rowHeaderLevelCount,r=this.m_rowHeader,l="row"):(s=this.m_startRowEndHeader,n=this.m_rowEndHeaderLevelCount-1,o=this.m_rowEndHeaderLevelCount,r=this.m_rowEndHeader,l="row"),0===e.startIndex.column&&-1===e.endIndex.column&&0===e.startIndex.row&&-1===e.endIndex.row){a=0,h="row"===l?this.m_endRowHeader-this.m_startRowHeader:this.m_endColHeader-this.m_startColHeader}else 0===e.startIndex.column&&-1===e.endIndex.column||void 0===e.startIndex.column?e.startIndex.row<=t&&t<=e.endIndex.row&&("row"===i||"rowEnd"===i)&&(a=e.startIndex.row,h=e.endIndex.row):(0===e.startIndex.row&&-1===e.endIndex.row||void 0===e.startIndex.row)&&e.startIndex.column<=t&&t<=e.endIndex.column&&("column"===i||"columnEnd"===i)&&(a=e.startIndex.column,h=e.endIndex.column);for(let e=a;e<=h;e++){let t=this._getHeaderByIndex(e,n,r,o,s);t&&d.push(t)}return d},I.prototype.handleDatabodyMouseDown=function(e){var t=e.target,i=this.findCell(t);if(null!=i){if(this._isEditOrEnter()){var s=this._getActiveElement();if(i===s)return;if(!1===this._leaveEditing(e,s,!1))return}else this._exitActionableMode();var n=this.m_utils.ctrlEquivalent(e);0!==e.button||n||this._isMoveOnElementEnabled(i)&&(this.m_databodyMove=!0,this.m_currentX=e.pageX,this.m_currentY=e.pageY),this.m_root.contains(document.activeElement)&&document.activeElement!==this.m_root||(this.m_externalFocus=!0),this._isGridEditable()&&(this.m_shouldFocus=!this._isFocusableElementBeforeCell(t)),this._isSelectionEnabled()?(this.isMultipleSelection()&&0===e.button&&(this.m_databodyDragState=!0),this.handleDatabodyClickSelection(e)):this.handleDatabodyClickActive(e)}else this.m_scrollbarFocus=!0},I.prototype.handleDatabodyMouseOut=function(e){if(!this.m_databodyMove){var t=e.target,i=this.findCell(t);this._setCellHover(i,"remove")}},I.prototype.handleDatabodyMouseOver=function(e){if(!this.m_databodyMove){var t=e.target,i=this.findCell(t);this._setCellHover(i,"add")}},I.prototype._setCellHover=function(e,t){if(null!=e&&this._isSelectionEnabled()){var i=this.m_options.getSelectionMode();if("cell"===i)"add"===t?this.m_utils.addCSSClassName(e,this.getMappedStyle("hover")):this.m_utils.removeCSSClassName(e,this.getMappedStyle("hover"));else if("row"===i)for(var s=this._getIndex(e,"row"),n=this._getSelectionStartAndEnd(this.createIndex(s,this.m_startCol),this.createIndex(s,this.m_endCol),0),o=n.min.row;o<=n.max.row;o++)this._highlightCellsAlongAxis(o,"row","index",t,["hover"])}},I.prototype.handleDatabodyDoubleClick=function(e){if(this._isGridEditable()){var t=e.target,i=this.findCell(t);if("edit"===this._getCurrentMode()){var s=this._getActiveElement();if(i===s)return;if(!this._handleExitEdit(e,s))return}this._handleEditable(e,i),this._handleEdit(e,i)}},I.prototype.handleDatabodyMouseMove=function(e){0===e.buttons&&this.handleMouseUp(e),this.m_databodyMove?this._handleMove(e):this.m_databodyDragState?this.m_floodFillDragState?this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this.m_selectionRange||(this.m_selectionRange=this.GetSelection()),this.handleDatabodyFloodFillDrag(e)):this.handleDatabodySelectionDrag(e):this.m_headerDragState&&(this.m_selectionFrontier&&this.m_selectionFrontier.axis&&(-1!==this.m_selectionFrontier.axis.indexOf("row")||-1!==this.m_selectionFrontier.axis.indexOf("column"))||this.m_deselectInfo&&this.m_deselectInfo.axis&&(-1!==this.m_deselectInfo.axis.indexOf("row")||-1!==this.m_deselectInfo.axis.indexOf("column")))&&this.extendSelectionHeader(e.target,e,!0,this.m_deselectInProgress)},I.prototype.handleDatabodyMouseUp=function(e){this.m_databodyDragState=!1,this.m_headerDragState=!1,this.m_deselectInProgress=!1,this.m_databodyMove&&this._handleMoveMouseUp(e,!0),this.m_options.isFloodFillEnabled()&&this.m_floodFillDragState&&(this._handleFloodFillMouseUp(e),this.m_floodFillDragState=!1)},I.prototype.handleDatabodyKeyUp=function(e){this.m_deselectInProgress&&(this.m_deselectInProgress=e.shiftKey)},I.prototype.handleDatabodyKeyDown=function(e){var t,i=this.m_utils.ctrlEquivalent(e);if(!(e.defaultPrevented&&i&&(this.keyCodes.LEFT_KEY||this.keyCodes.RIGHT_KEY)||this.m_animating)){t=null!=this.m_active&&"header"===this.m_active.type?this._getActionFromKeyDown(e,this.m_active.axis,!1):null!=this.m_active&&"label"===this.m_active.type?this._getActionFromKeyDown(e,this.m_active.axis,!0):this._getActionFromKeyDown(e,"cell",!1);var s=this._getActiveElement();null!=t&&t.call(this,e,s)&&e.preventDefault()}},I.prototype.findPos=function(e){if(e){var t=this.findPos(e.offsetParent),i=this.getElementTranslationXYZ(e.offsetParent);return[parseInt(t[0],10)+parseInt(e.offsetLeft,10)+i[0],parseInt(t[1],10)+parseInt(e.offsetTop,10)+i[1]]}return[0,0]},I.prototype._findHeaderOffset=function(e,t,i){return i||(i=[0,0]),e!==t?(i[0]+=parseInt(e.offsetLeft,10),i[1]+=parseInt(e.offsetTop,10),this._findHeaderOffset(e.offsetParent,t,i)):i},I.prototype.getElementTranslationXYZ=function(e){if(e){var t=document.defaultView.getComputedStyle(e,null),i=t.getPropertyValue("-webkit-transform")||t.getPropertyValue("-moz-transform")||t.getPropertyValue("-ms-transform")||t.getPropertyValue("-o-transform")||t.getPropertyValue("transform"),s=i.substr(7,i.length-8).split(", ");return[isNaN(parseInt(s[4],10))?0:parseInt(s[4],10),isNaN(parseInt(s[5],10))?0:parseInt(s[5],10),isNaN(parseInt(s[6],10))?0:parseInt(s[6],10)]}return[0,0,0]},I.prototype.handleDatabodyMouseWheel=function(e){var t,i=this.find(e.target,"header");if(null==i&&(i=this.find(e.target,"endheader")),i&&(t=i===this.m_rowHeader||i===this.m_rowEndHeader?"row":"column"),("row"!==t||this.m_stopRowHeaderFetch&&this.m_stopRowEndHeaderFetch&&this.m_stopRowFetch)&&("column"!==t||this.m_stopColumnHeaderFetch&&this.m_stopColumnEndHeaderFetch&&this.m_stopColumnFetch)||e.preventDefault(),!this.m_animating){var s=this.m_utils.getMousewheelScrollDelta(e),n=s.deltaX,o=s.deltaY;"row"===t?n=0:"column"===t&&(o=0);var r=Math.max(0,Math.min(this._getMaxScrollHeight(),this.m_currentScrollTop-o));this._getMaxScrollHeight()!==r&&0!==r&&this.find(e.target,"header")&&e.preventDefault(),this.scrollDelta(n,o)}},I.prototype.handleTouchStart=function(e){var t=e.touches.length,i=e.touches[0].target;if(1===t){if(this.m_startX=e.touches[0].pageX,this.m_startY=e.touches[0].pageY,this.m_currentX=this.m_startX,this.m_currentY=this.m_startY,this.m_prevX=this.m_startX,this.m_prevY=this.m_startY,this.m_startTime=(new Date).getTime(),this.m_touchActive=!0,this.isMultipleSelection()){i.classList.contains(this.getMappedStyle("selectaffordance"))&&(i=i.parentNode);var s=null;if(i===this.m_topSelectIconContainer?s="top":i===this.m_bottomSelectIconContainer&&(s="bottom"),s){this.m_touchMultipleSelect=!0;var n=this.GetSelection();this.m_touchSelectAnchor="top"===s?n[n.length-1].endIndex:n[n.length-1].startIndex}}!this.m_touchMultipleSelect&&this._isMoveOnElementEnabled(this.findCell(i))&&(this.m_databodyMove=!0)}else this.handleTouchCancel(e)},I.prototype.handleTouchMove=function(e){var t=e.target;if(this.m_touchActive){e.cancelable&&e.preventDefault(),this.m_currentX=e.touches[0].pageX,this.m_currentY=e.touches[0].pageY;var i=this.m_currentX-this.m_prevX,s=this.m_currentY-this.m_prevY;if(this.getResources().isRTLMode()&&(i*=-1),this.m_touchMultipleSelect)this.handleDatabodySelectionDrag(e);else if(this.m_databodyMove)this._removeTouchSelectionAffordance(),this._handleMove(e);else if(this._isEditOrEnter()){var n=this._getActiveElement();this.findCell(t)!==n&&this._handleNonSwipeScroll(i,s)}else this._handleNonSwipeScroll(i,s);this.m_prevX=this.m_currentX,this.m_prevY=this.m_currentY}else this.handleTouchCancel(e)},I.prototype.handleTouchEnd=function(e){var t,i=e.target;if(this._isEditOrEnter()){if(t=this._getActiveElement(),this.findCell(i)===t)return void this.handleTouchCancel(e);this._leaveEditing(e,t,!1)}else this._exitActionableMode();if(null!=this.m_lastTapTime&&this.m_startTime-this.m_lastTapTime<250&&this.m_lastTapTarget===i?(this.m_lastTapTime=null,this.m_lastTapTarget=null,null!=(t=this.findCell(i))&&(this._handleEditable(e,t),this._handleEdit(e,t),e.cancelable&&e.preventDefault())):(this.m_lastTapTarget=e.target,this.m_lastTapTime=(new Date).getTime()),this.m_touchActive&&!e.defaultPrevented)if(this.m_touchMultipleSelect)e.cancelable&&e.preventDefault(),this.m_touchMultipleSelect=!1;else{var s=this.m_lastTapTime-this.m_startTime;if(this.m_currentX===this.m_startX&&this.m_currentY===this.m_startY)return this.m_databodyMove=!1,this._isSelectionEnabled()&&s<I.CONTEXT_MENU_TAP_HOLD_DURATION?void this.handleDatabodyClickSelection(e):void this.handleDatabodyClickActive(e);if(this.m_databodyMove)return e.cancelable&&e.preventDefault(),this.m_databodyMove=!1,void this._handleMoveMouseUp(e,!0);this._handleSwipe(e)}this.handleTouchCancel(e)},I.prototype._calculateMomentum=function(e,t,i,s,n,o){var r,l=e-t,a=Math.abs(l)/i,h=a*a/(2*I.DECELERATION_FACTOR)*(l<0?-1:1),d=a/I.DECELERATION_FACTOR;return o&&(h*=-1),s-h>n?(r=Math.max(-1*I.MAX_OVERSCROLL_PIXEL,h),h=s-n,d=(l=n-s)/a):s-h<0&&(r=Math.min(I.MAX_OVERSCROLL_PIXEL,h),h=s,d=(l=s)/a),{destination:Math.round(h),duration:Math.min(Math.max(I.MIN_SWIPE_TRANSITION_DURATION,d),I.MAX_SWIPE_TRANSITION_DURATION),overScroll:r}},I.prototype.handleTouchCancel=function(e){this.m_databodyMove&&(this._handleMoveMouseUp(e,!1),this.m_databodyMove=!1),this.m_touchSelectAnchor=null,this.m_touchMultipleSelect=!1,this.m_touchActive=!1,this.m_startX=0,this.m_startY=0,this.m_prevX=0,this.m_prevY=0,this.m_currentX=0,this.m_currentY=0,this.m_startTime=0},I.prototype.handleHeaderTouchStart=function(e){this.m_touchStart=(new Date).getTime();var t=e.touches.length,i=e.target;if(1===t){this.m_startX=e.touches[0].pageX,this.m_startY=e.touches[0].pageY,this.m_currentX=this.m_startX,this.m_currentY=this.m_startY,this.m_prevX=this.m_startX,this.m_prevY=this.m_startY,this.m_touchActive=!0;var s=this.findHeader(i);this.isResizeEnabled()&&(this.handleResize(e),this.handleResizeMouseDown(e),this._highlightResizeMouseDown()),!this.m_isResizing&&this._isMoveOnElementEnabled(s)&&(this.m_databodyMove=!0)}else this.handleHeaderTouchCancel(e)},I.prototype.handleHeaderTouchMove=function(e){if(this.m_touchActive){e.cancelable&&e.preventDefault(),this.m_currentX=e.touches[0].pageX,this.m_currentY=e.touches[0].pageY;var t=this.m_currentX-this.m_prevX,i=this.m_currentY-this.m_prevY;if(this.m_isResizing&&this.isResizeEnabled())this.handleResize(e);else if(this.m_databodyMove)this._removeTouchSelectionAffordance(),this._handleMove(e);else{var s=e.target,n=this.findHeader(s),o=this.getHeaderCellAxis(n);"column"===o||"columnEnd"===o?this._handleNonSwipeScroll(t,0):this._handleNonSwipeScroll(0,i)}this.m_prevX=this.m_currentX,this.m_prevY=this.m_currentY}else this.handleTouchCancel(e)},I.prototype.handleHeaderTouchEnd=function(e){var t;if(this.m_touchActive&&!e.defaultPrevented){var i=e.target;if(this.m_isResizing&&this.isResizeEnabled())this.handleResizeMouseUp(e),this.m_currentX!==this.m_startX&&this.m_currentY!==this.m_startY&&e.cancelable&&e.preventDefault();else if(this.m_currentX===this.m_startX&&this.m_currentY===this.m_startY){var s=this.m_options.getSelectionMode(),n=(t=this.findHeader(i))[this.getResources().getMappedAttribute("context")],o=this.m_root.getAttribute("id"),r=document.querySelector("#"+o+"contextmenu");r&&"none"===r.style.display&&((this.m_utils.containsCSSClassName(i,this.getMappedStyle("sortascending"))||this.m_utils.containsCSSClassName(i,this.getMappedStyle("sortdescending"))||this.m_utils.containsCSSClassName(i,this.getMappedStyle("sortdefault")))&&this._isDOMElementSortable(i)?(e.cancelable&&e.preventDefault(),this._removeTouchSelectionAffordance(),this._handleSortIconMouseDown(i),this._handleHeaderSort(e)):this._isDisclosureIcon(i)?(this._removeTouchSelectionAffordance(),this._handleExpandCollapseRequest(e),e.preventDefault()):!this._isSelectionEnabled()||!this.isMultipleSelection()||"row"===s&&-1===n.axis.indexOf("row")||this.m_databodyMove?"row"===s&&-1!==n.axis.indexOf("row")&&this._isSelectionEnabled()?this.handleHeaderClickSelection(e):this.handleHeaderClickActive(e):(0===e.button&&(this.m_headerDragState=!0),this.handleHeaderClickSelection(e)))}else this.m_databodyMove?(e.cancelable&&e.preventDefault(),this.m_databodyMove=!1,this._handleMoveMouseUp(e,!0)):(t=this.findHeader(i),this._handleSwipe(e,this.getHeaderCellAxis(t)))}this.handleHeaderTouchCancel(e)},I.prototype.handleHeaderTouchCancel=function(e){this.m_databodyMove&&(this._handleMoveMouseUp(e,!1),this.m_databodyMove=!1),this.m_touchActive=!1,this.m_startX=0,this.m_startY=0,this.m_prevX=0,this.m_prevY=0,this.m_currentX=0,this.m_currentY=0},I.prototype._handleNonSwipeScroll=function(e,t){var i=(new Date).getTime();this._disableTouchScrollAnimation();var s=this.adjustTouchScroll(e,t);e=s[0],t=s[1],this.scrollDelta(e,t),i-this.m_startTime>I.TAP_AND_SCROLL_RESET&&(this.m_startX=this.m_currentX,this.m_startY=this.m_currentY,this.m_startTime=(new Date).getTime())},I.prototype._handleSwipe=function(e,t){var i=(new Date).getTime()-this.m_startTime,s=this.getResources().isRTLMode(),n=this.m_currentX-this.m_startX,o=this.m_currentY-this.m_startY;if(s&&(n*=-1),Math.abs(n)<I.MIN_SWIPE_DISTANCE&&Math.abs(o)<I.MIN_SWIPE_DISTANCE&&i<I.MIN_SWIPE_DURATION)e.cancelable&&e.preventDefault(),this._isSelectionEnabled()&&this._scrollTouchSelectionAffordance();else if(i<I.MAX_SWIPE_DURATION){var r,l;e.cancelable&&e.preventDefault(),"row"!==t&&"rowEnd"!==t?(r=this._calculateMomentum(this.m_currentX,this.m_startX,i,this.m_currentScrollLeft,this.m_scrollWidth,s),isNaN(r.overScroll)||(r.overScroll>0||this.m_stopColumnFetch)&&(this.m_extraScrollOverX=-1*r.overScroll)):(r={duration:0,destination:0},n=0),"column"!==t&&"columnEnd"!==t?(l=this._calculateMomentum(this.m_currentY,this.m_startY,i,this.m_currentScrollTop,this.m_scrollHeight),isNaN(l.overScroll)||(l.overScroll>0||this.m_stopRowFetch)&&(this.m_extraScrollOverY=-1*l.overScroll)):(l={duration:0,destination:0},o=0);var a=Math.max(r.duration,l.duration);this.m_databody.firstChild.style.transitionDuration=a+"ms",this.m_rowHeader.firstChild.style.transitionDuration=a+"ms",this.m_colHeader.firstChild.style.transitionDuration=a+"ms",this.m_rowEndHeader.firstChild.style.transitionDuration=a+"ms",this.m_colEndHeader.firstChild.style.transitionDuration=a+"ms",n+=r.destination,o+=l.destination;var h=this.adjustTouchScroll(n,o);n=h[0],o=h[1],this.scrollDelta(n,o)}},I.prototype.fireEvent=function(e,t){if(null!=e&&null!=t){var i=this.callbacks[e];return null==i||i(t)}},I.prototype.addListener=function(e,t){this.callbacks[e]=t},I.prototype.setElementHeight=function(e,t){e.style.height=t+"px"},I.prototype.getElementHeight=function(e){return this.getElementDir(e,"height")},I.prototype.setElementWidth=function(e,t){e.style.width=t+"px"},I.prototype.getElementWidth=function(e){return this.getElementDir(e,"width")},I.prototype.setElementDir=function(e,t,i){e.style[i]=t+"px"},I.prototype.getElementDir=function(e,t){var i;return e.style[t].indexOf("px")>-1&&-1===e.style[t].indexOf("e")?parseFloat(e.style[t]):(document.body.contains(e)?i=Math.round(e["offset"+t.charAt(0).toUpperCase()+t.slice(1)]):(e.style.visibility="hidden",this.m_root.appendChild(e),i=Math.round(e["offset"+t.charAt(0).toUpperCase()+t.slice(1)]),this.m_root.removeChild(e),e.style.visibility=""),i)},I.prototype._computeElementWidthAndHeight=function(e){var t={};return e.style.width.indexOf("px")>-1&&-1===e.style.width.indexOf("e")&&(t.width=parseFloat(e.style.width)),e.style.height.indexOf("px")>-1&&-1===e.style.height.indexOf("e")&&(t.height=parseFloat(e.style.height)),null!=t.width&&null!=t.height||(document.body.contains(e)?(t.width=Math.round(e.offsetWidth),t.height=Math.round(e.offsetHeight)):(e.style.visibility="hidden",this.m_root.appendChild(e),t.width=Math.round(e.offsetWidth),t.height=Math.round(e.offsetHeight),this.m_root.removeChild(e),e.style.visibility="")),t},I.BEFORE=1,I.AFTER=2,I.INSIDE=3,I.prototype._isInViewport=function(e){var t=e.row,i=e.column;return-1===t&&-1===i?-1:-1===t?this._isColumnIndexInViewport(i):-1===i?this._isRowIndexInViewport(t):i>=this.m_startCol&&i<=this.m_endCol&&t>=this.m_startRow&&t<=this.m_endRow?I.INSIDE:-1},I.prototype._isAxisIndexInViewport=function(e,t){return-1===e?-1:"column"===t?this._isColumnIndexInViewport(e):"row"===t?this._isRowIndexInViewport(e):-1},I.prototype._isColumnIndexInViewport=function(e){return e<this.m_startCol?I.BEFORE:e>this.m_endCol?I.AFTER:I.INSIDE},I.prototype._isRowIndexInViewport=function(e){return e<this.m_startRow?I.BEFORE:e>this.m_endRow?I.AFTER:I.INSIDE},I.prototype._isCellBoundaryInViewport=function(e,t,i,s){var n=this._getViewportTop(),o=this._getViewportBottom(),r=this._getViewportLeft(),l=this._getViewportRight();return(s<=o&&s>n||i>=n&&i<o)&&(t<=l&&t>r||e>=r&&e<l)},I.prototype.queueModelEvent=function(e){return!(this.m_initialized&&!this.m_processingEventQueue&&!this.m_animating&&!this.m_processingModelEvent)&&(null==this.m_modelEvents&&(this.m_modelEvents=[]),this.m_modelEvents.push(e),!0)},I.prototype.handleModelEvent=function(e,t){if(void 0!==t||!this.queueModelEvent(e)){var i=e.operation,s=e.keys,n=e.indexes,o=e.result,r=e.header,l=e.endheader,a=e.silent,h=!1;this.m_processingModelEvent=!0,e.detail?("delete"===i&&this._handleDeleteRangeEvent(e.detail),"insert"===i&&this._handleInsertRangeEvent(e.detail),"update"===i&&this._handleUpdateRangeEvent(e.detail),"refresh"===i&&this._handleModelRefreshEvent(e.detail)):"insert"===i?(this._adjustActive(i,n),this.m_shouldFocus=!0,this._adjustSelectionOnModelChange(i,s,n),null!=o?(this._handleModelInsertRangeEvent(o,r,l),h=!0):this._handleModelInsertEvent(n,s)):"update"===i?(this._handleModelUpdateEvent(n,s,o),h=!0):"delete"===i?(this._adjustActive(i,n),this._adjustSelectionOnModelChange(i,s,n),this.m_utils.supportsTransitions()?(Array.isArray(s)||(s=new Array(s)),this._handleModelDeleteEventWithAnimation(s),s.length>0&&(h=!0)):this._handleModelDeleteEvent(n,s,a)):"refresh"===i||"reset"===i?this._handleModelRefreshEvent():"sync"===i&&this._handleModelSyncEvent(e),this.m_processingModelEvent=!1,!h&&t&&this._runModelEventQueue()}},I.prototype._adjustActive=function(e,t){var i,s;if(null!=this.m_active){if("cell"===this.m_active.type)s=!1,i=this.m_active.indexes.row;else{if("header"!==this.m_active.type||"row"!==this.m_active.axis)return;s=!0,i=this.m_active.index}if(Array.isArray(t)||(t=new Array(t)),!0===this.m_moveActive){if("insert"===e)return void(s?this.m_active.index=t[0].row:this.m_active.indexes.row=t[0].row);if("delete"===e&&t[0].row===i)return}for(var n="insert"===e?1:-1,o=0;o<t.length;o++){var r=t[o].row;r<i?s?this.m_active.index+=n:this.m_active.indexes.row+=n:r===i&&"delete"===e&&this._setActive(null,null)}}},I.prototype._adjustSelectionOnModelChange=function(e,t,i){Array.isArray(t)||(t=new Array(t)),Array.isArray(i)||(i=new Array(i));var s=this.GetSelection();if(null!=t&&null!=i&&t.length===i.length&&0!==s.length)for(var n="insert"===e?1:-1,o=0;o<t.length;o++)for(var r,l=t[o].row,a=i[o].row,h=s.length-1;h>=0;h--){var d=s[h],c=d.startKey.row,m=d.endKey.row,u=d.startIndex.row,_=d.endIndex.row;if(c===l){if(m===l&&"delete"===e){s.splice(h,1);continue}r=this._getKey(this._getAxisCellsByIndex(d.startIndex.row+1,"row")[0],"row"),d.startKey.row=r,d.endIndex.row+=n}else m===l?(r=this._getKey(this._getAxisCellsByIndex(d.startIndex.row-1,"row")[0],"row"),d.endKey.row=r,d.endIndex.row+=n):a<=u?(d.startIndex.row+=n,d.endIndex.row+=n):a<_&&(d.endIndex.row+=n)}else if(this.m_moveActive&&"insert"===e){var p;if(this._isSelectionEnabled()&&this._isDatabodyCellActive())p="cell"===this.m_options.getSelectionMode()?this.createRange(this.m_active.indexes,this.m_active.indexes,t[0],t[0]):this.createRange(i[0],i[0],t[0],t[0]),this.m_selectionFrontier=this.m_active.indexes,s.push(p);this.m_moveActive=!1}},I.prototype._simpleAdjustSelectionOnChange=function(e,t,i){let s=this.GetSelection(),n="insert"===e?1:-1;for(let o=0;o<t.length;o++){let r=t[o];for(let t=s.length-1;t>=0;t--){let o=s[t],l=o.startIndex[i],a=o.endIndex[i];if(l===r){if(a===r&&"delete"===e){s.splice(t,1);continue}if("delete"===e){let e=this._getKey(this._getAxisCellsByIndex(o.startIndex[i]+1,i)[0],i);o.startKey[i]=e}else o.startIndex[i]+=n;o.endIndex[i]+=n}else if(a===r){if("delete"===e){let e=this._getKey(this._getAxisCellsByIndex(o.endIndex[i]-1,i)[0],i);o.endKey[i]=e}o.endIndex[i]+=n}else r<l?(o.startIndex[i]+=n,o.endIndex[i]+=n):r<a&&(o.endIndex[i]+=n)}}},I.prototype._handleInsertRangeEvent=function(e){let t=e.axis,i=e.ranges;if(0===i.length)return void this.fillViewport();i.sort(function(e,t){return e.offset-t.offset});let s=i.shift(),n=s.offset,o=s.count,r=this._isAxisIndexInViewport(n,t);if(r===I.INSIDE){let i=n,r=o,l=this.m_startCol,a=this.m_endCol-this.m_startCol+1;"column"===t&&(i=this.m_startRow,r=this.m_endRow-this.m_startRow+1,l=n,a=o);let h,d=document.createDocumentFragment(),c=document.createDocumentFragment(),m=new Promise(function(e){h=e}),u={axis:t,range:s,headerFragment:d,endHeaderFragment:c,totalDimension:0,promiseResolve:h};this.fetchHeaders(t,n,d,c,o,{success:this._handleInsertRangeHeaderFetchSuccess.bind(this,u),error:this.handleCellsFetchError}),this.fetchCells(this.m_databody,i,l,r,a,{success:this._handleInsertRangeCellFetchSuccess.bind(this,u),error:this.handleCellsFetchError}),m.then(this._handleInsertRangeEvent.bind(this,e))}else if(r===I.BEFORE){let i=this.m_avgRowHeight,s=i*o,r=this.m_rowHeader,l=this.m_rowEndHeader;"row"===t?(this.m_endRow>=0&&(this.m_startRow+=o,this.m_endRow+=o,this.m_startRowPixel+=s,this.m_endRowPixel+=s),this.m_endRowHeader>=0&&(this.m_startRowHeader+=o,this.m_endRowHeader+=o,this.m_startRowHeaderPixel+=s,this.m_endRowHeaderPixel+=s),this.m_endRowEndHeader>=0&&(this.m_startRowEndHeader+=o,this.m_endRowEndHeader+=o,this.m_startRowEndHeaderPixel+=s,this.m_endRowEndHeaderPixel+=s)):(i=this.m_avgColWidth,s=i*o,r=this.m_colHeader,l=this.m_colEndHeader,this.m_endCol>=0&&(this.m_startCol+=o,this.m_endCol+=o,this.m_startColPixel+=s,this.m_endColPixel+=s),this.m_endColHeader>=0&&(this.m_startColHeader+=o,this.m_endColHeader+=o,this.m_startColHeaderPixel+=s,this.m_endColHeaderPixel+=s),this.m_endColEndHeader>=0&&(this.m_startColEndHeader+=o,this.m_endColEndHeader+=o,this.m_startColEndHeaderPixel+=s,this.m_endColEndHeaderPixel+=s));let a=new Array(o).fill(n).map((e,t)=>e+t),h=new Array(o).fill(i);this._modifyAndPushCells(a,h,t,r,l,!0),this._refreshDatabodyMap(),this._handleInsertRangeEvent(e)}else r===I.AFTER&&("row"===t?(this.m_stopRowFetch=!1,this.m_stopRowHeaderFetch=!1,this.m_stopRowEndHeaderFetch=!1):(this.m_stopColumnFetch=!1,this.m_stopColumnHeaderFetch=!1,this.m_stopColumnEndHeaderFetch=!1),this._handleInsertRangeEvent(e))},I.prototype._handleUpdateRangeEvent=function(e){let t=e.ranges;if(0===t.length)return this._highlightActive(),this.applySelection(),void this.fillViewport();t.sort(function(e,t){return e.offset-t.offset});let i=t.shift(),s=i.rowOffset,n=i.columnOffset,o=-1===i.rowCount?this._getMaxBottom():i.rowCount,r=-1===i.columnCount?this._getMaxRight():i.columnCount,l=s+o-1,a=n+r-1,h=this._isAxisIndexInViewport(s,"row"),d=this._isAxisIndexInViewport(l,"row"),c=this._isAxisIndexInViewport(n,"column"),m=this._isAxisIndexInViewport(a,"column");if(h!==I.AFTER&&d!==I.BEFORE&&c!==I.AFTER&&m!==I.BEFORE){let t;h===I.BEFORE&&(s=this._getMaxTop()),d===I.AFTER&&(l=this._getMaxBottom()),c===I.BEFORE&&(n=this._getMaxLeft()),m===I.AFTER&&(a=this._getMaxRight()),o=l-s+1,r=a-n+1;let i=new Promise(function(e){t=e}),u={promiseResolve:t};this.fetchCells(this.m_databody,s,n,o,r,{success:this._handleUpdateRangeFetchSuccess.bind(this,u),error:this.handleCellsFetchError}),i.then(this._handleUpdateRangeEvent.bind(this,e))}else this._handleUpdateRangeEvent(e)},I.prototype._handleInsertRangeHeaderFetchSuccess=function(e,t,i,s){const n=i.axis;this._signalTaskEnd(),this.m_fetching[n]=!1;const o=this.getResources().isRTLMode()?"right":"left",r=i.start,l=e.headerFragment,a=e.endHeaderFragment,h="row"===n?"top":o;let d,c,m,u,_,p,g,f,C,y,v,E,S=0,w=0;if(null!=t){for(f=this.getMappedStyle("headercell"),"row"===n?(d=this.m_rowHeader,c=this.m_startRowHeader,y=this.m_rowHeaderLevelCount,f+=" "+this.getMappedStyle("rowheadercell")):(d=this.m_colHeader,c=this.m_startColHeader,y=this.m_columnHeaderLevelCount,f+=" "+this.getMappedStyle("colheadercell")),m=this._getHeaderByIndex(r,y-1,d,y,c),u=this.getElementDir(m,h),_=t.getCount(),C=this.getRendererOrTemplate(n);_-S>0;)"row"===n?(v=0,E=u+w):(v=u+w,E=0),p=r+S,g=this.buildLevelHeaders(l,p,0,v,E,!0,!1,C,t,n,f,y),S+=g.count,w+=g.totalHeaderDimension;w>e.totalDimension&&(e.totalDimension=w)}if(w=0,S=0,null!=s){for(f=this.getMappedStyle("endheadercell"),"row"===n?(d=this.m_rowEndHeader,c=this.m_startRowEndHeader,y=this.m_rowEndHeaderLevelCount,f+=" "+this.getMappedStyle("rowendheadercell")):(d=this.m_colEndHeader,c=this.m_startColEndHeader,y=this.m_columnEndHeaderLevelCount,f+=" "+this.getMappedStyle("colendheadercell")),m=this._getHeaderByIndex(r,y-1,d,y,c),u=this.getElementDir(m,h),_=s.getCount(),C=this.getRendererOrTemplate(n+"End");_-S>0;)"row"===n?(v=0,E=u+w):(v=u+w,E=0),p=r+S,g=this.buildLevelHeaders(a,p,0,v,E,!0,!1,C,s,n+"End",f,y),S+=g.count,w+=g.totalHeaderDimension;w>e.totalDimension&&(e.totalDimension=w)}},I.prototype._handleInsertRangeCellFetchSuccess=function(e,t,i){const s=e.range,n=e.axis,o=e.headerFragment,r=e.endHeaderFragment;let l=e.totalDimension;const a=this.getResources().isRTLMode()?"right":"left",h=document.createDocumentFragment();let d=this.m_rowHeader,c=this.m_rowEndHeader;if("column"===n&&(d=this.m_colHeader,c=this.m_colEndHeader),this._signalTaskEnd(),this.m_fetching.cells=!1,this.unhighlightSelection(),t){const e=i[0].start,s=i[1].start,o=this._getCellByIndex(this.createIndex(e,s)),r="row"===n?this.getElementDir(o,"top"):this.m_startRowPixel,d="row"===n?this.m_startColPixel:this.getElementDir(o,a),c=this._addCellsToFragment(h,t,e,r,s,d);l=Math.max(l,"row"===n?c.totalRowHeight:c.totalColumnWidth)}const m=s.offset,u=s.count;let _=new Array(u).fill(m).map((e,t)=>e+t),p=new Array(u).fill(l/u),g=h.childNodes.length,f=o.childNodes.length,C=r.childNodes.length;const y=this.m_databody.firstChild;if(this._modifyAndPushCells(_,p,n,d,c,!0),this._simpleAdjustSelectionOnChange("insert",_,n),h.childNodes.length&&(y.appendChild(h),this._refreshDatabodyMap()),this._insertHeaders(n,m,o,r),this.hideStatusText(),"row"===n){g&&(this.m_endRow+=u,this.m_endRowPixel+=l,this.m_stopRowFetch=!1),f&&(this.m_endRowHeader+=u,this.m_endRowHeaderPixel+=l,this.m_stopRowHeaderFetch=!1),C&&(this.m_endRowEndHeader+=u,this.m_endRowEndHeaderPixel+=l,this.m_stopRowEndHeaderFetch=!1);let e=this.getElementHeight(y)-l;this.setElementHeight(y,e),this.updateRowBanding()}else if("column"===n){g&&(this.m_endCol+=u,this.m_endColPixel+=l,this.m_stopColumnFetch=!1),f&&(this.m_endColHeader+=u,this.m_endColHeaderPixel+=l,this.m_stopColumnHeaderFetch=!1),C&&(this.m_endColEndHeader+=u,this.m_endColEndHeaderPixel+=l,this.m_stopColumnEndHeaderFetch=!1);var v=this.getElementWidth(y)-l;this.setElementWidth(y,v),this.updateColumnBanding()}this.applySelection(),this._resetHeaderHighLight(),this.resizeGrid(),e.promiseResolve()},I.prototype._insertHeaders=function(e,t,i,s){let n,o=this.m_rowHeader,r=this.m_rowEndHeader,l=this.m_rowHeaderLevelCount,a=this.m_rowEndHeaderLevelCount,h=this.m_startRowHeader,d=this.m_startRowEndHeader,c="height",m="top";"column"===e&&(o=this.m_colHeader,r=this.m_colEndHeader,l=this.m_columnHeaderLevelCount,a=this.m_columnEndHeaderLevelCount,h=this.m_startColHeader,d=this.m_startColEndHeader,c="width",m=this.getResources().isRTLMode()?"right":"left");let u=(e,t,i,s,n,o)=>{for(;e.childNodes.length;){let r,l=e.firstChild;r=this.m_utils.containsCSSClassName(l,this.getMappedStyle("groupingcontainer"))?l.firstChild:l;let a=r.extentInfo,h=a.more.before,d=a.more.after,c=r[this.getResources().getMappedAttribute("context")],m=c.index,_=c.extent,p=c.level;if(h){let e=this._getHeaderContainer(m-1,p,0,null,t,i),s=e.firstChild;r[this.getResources().getMappedAttribute("context")].extent+=_;let o=this._getAttribute(e,"extent",!0);this._setAttribute(e,"extent",o+_);let l=this.getElementDir(s,n),a=this.getElementDir(r,n);this.setElementDir(s,l+a,n)}else if(d){let e=this._getHeaderContainer(m+_,p,0,null,t,i),s=e.firstChild,l=s[this.getResources().getMappedAttribute("context")];l.extent+=_,l.index-=_;let a=this._getAttribute(e,"extent",!0);this._setAttribute(e,"extent",a+_);let h=this._getAttribute(e,"start",!0);this._setAttribute(e,"start",h-_);let d=this.getElementDir(s,n),c=this.getElementDir(r,n);this.setElementDir(s,d+c,n);let u=this.getElementDir(s,o);this.setElementDir(s,u-c,o)}else{let e=this._getHeaderContainer(m,p,0,null,t,i);if(e){let n=this._getHeaderByIndex(m-1,p,t,i,s);if(null===n||n.parentNode!==e){let t=p===i-1?e.childNodes[1]:e.childNodes[0];e.insertBefore(r,t)}else n.nextSibling&&n.nextSibling.parentNode===e?e.insertBefore(r,n.nextSibling):e.appendChild(r)}else{let e=this._getHeaderContainer(m-1,p,0,null,t,i);if(null===e){let e=t.firstChild;e.firstChild?e.insertBefore(l,e.firstChild):e.appendChild(l)}else e.nextSibling?e.parentNode.insertBefore(l,e.nextSibling):e.parentNode.appendChild(l)}}if(h||d){let r=l.querySelector("."+this.getMappedStyle("groupingcontainer"));r&&u(r,t,i,s,n,o),e.removeChild(l)}}};i.childNodes.length&&(1===l?(n=this._getHeaderByIndex(t,l-1,o,l,h),o.firstChild.insertBefore(i,n)):u(i,o,l,h,c,m)),s.childNodes.length&&(1===a?(n=this._getHeaderByIndex(t,a-1,r,a,d),r.firstChild.insertBefore(s,n)):u(s,r,a,d,c,m))},I.prototype._handleModelInsertEvent=function(e,t){var i=this._isInViewport(e);if(i===I.INSIDE||i===I.AFTER&&e.row===this.m_endRow+1)null!=t.row&&(this._databodyEmpty()?(this.empty(),this.refresh(this.m_root)):(this._modifyAxisCellContextIndex("row",e.row,this.m_endRow-e.row+1,1),this._refreshDatabodyMap(),this.fetchHeaders("row",e.row,this.m_rowHeader,this.m_rowEndHeader,1,{success:this._handleHeaderInsertsFetchSuccess}),this.fetchCells(this.m_databody,e.row,this.m_startCol,1,this.m_endCol-this.m_startCol+1,{success:this._handleCellInsertsFetchSuccess})));else{if(i===I.BEFORE){this._modifyAxisCellContextIndex("row",0,this.m_endRow+1,1),this._refreshDatabodyMap(),this.m_startRow+=1,this.m_startRowHeader+=1,this.m_endRow+=1,this.m_endRowHeader+=1,this.m_startRowPixel+=this.m_avgRowHeight,this.m_startRowHeaderPixel+=this.m_avgRowHeight,this.m_endRowPixel+=this.m_avgRowHeight,this.m_endRowHeaderPixel+=this.m_avgRowHeight;var s=this.m_databody.firstChild.firstChild;null!=s&&this.pushRowsDown(s,this.m_avgRowHeight);var n=this.m_rowHeader.firstChild.firstChild;null!=n&&this.pushRowsDown(n,this.m_avgRowHeight);var o=this.m_rowEndHeader.firstChild.firstChild;null!=o&&this.pushRowsDown(o,this.m_avgRowHeight)}this.scrollToIndex(e)}},I.prototype._handleCellInsertsFetchSuccess=function(e,t){this.m_resizeRequired=!0,this.handleCellsFetchSuccess(e,t,this.m_endRow>=t[0].start);var i=t[0].start;this._scrollRowIntoViewport(i),this._isHighWatermarkScrolling()||this._cleanupViewport("top"),this.updateRowBanding(),this.m_stopRowFetch=!1,-1!==this.m_endRowHeader&&(this.m_stopRowHeaderFetch=!1),-1!==this.m_endRowEndHeader&&(this.m_stopRowEndHeaderFetch=!1),this.fillViewport()},I.prototype._handleHeaderInsertsFetchSuccess=function(e,t,i){this.m_resizeRequired=!0,this.handleHeadersFetchSuccess(e,t,i,this.m_endRowHeader>=t.start)},I.prototype._scrollRowIntoViewport=function(e){var t=this._getAxisCellsByIndex(e,"row");if(null!=t){var i=this._getViewportTop(),s=this._getViewportBottom(),n=this.getElementDir(t[0],"top"),o=i-n;(o>0||(o=s-n)<0)&&this.scrollDelta(0,o)}},I.prototype._handleModelInsertRangeEvent=function(e,t,i){var s,n,o,r,l,a,h,d,c=this._databodyEmpty(),m=e.getStart("row"),u=e.getCount("row"),_=e.getStart("column"),p=e.getCount("column");if(!(m>this.m_endRow+1))if(c)this.empty(),this.refresh(this.m_root);else if(this.m_utils.supportsTransitions()){if(null!=t){s=document.createDocumentFragment();var g=t.getCount();for(r=0,n=0,a=this.getMappedStyle("headercell")+" "+this.getMappedStyle("rowheadercell"),h=this.getRendererOrTemplate("row");g-n>0;)o=m+n,n+=(l=this.buildLevelHeaders(s,o,0,0,r,!0,m!==this.m_endRowHeader+1,h,t,"row",a,this.m_rowHeaderLevelCount)).count,r+=l.totalHeaderDimension}if(null!=i){d=document.createDocumentFragment();var f=i.getCount();for(r=0,n=0,a=this.getMappedStyle("endheadercell")+" "+this.getMappedStyle("rowendheadercell"),h=this.getRendererOrTemplate("rowEnd");f-n>0;)o=m+n,n+=(l=this.buildLevelHeaders(d,o,0,0,r,!0,m!==this.m_endRowEndHeader+1,h,i,"rowEnd",a,this.m_rowEndHeaderLevelCount)).count,r+=l.totalHeaderDimension}var C=document.createDocumentFragment();if(l=this._addCellsToFragment(C,e,m,0,_,0),!(0!==C.childNodes.length||null!=s&&0!==s.childNodes.length||null!=d&&0!==d.childNodes.length))return;this._insertRowsWithAnimation(C,s,d,m,e.getCount("row"),l.totalRowHeight,_,p)}else{var y={axis:"row",start:m,count:u},v={axis:"column",start:_,count:p};if(null!=t){var E={axis:"row",header:this.m_rowHeader,endHeader:this.m_rowEndHeader,start:m,count:t.getCount()};this.m_fetching.row=E,this._handleHeaderInsertsFetchSuccess(t,E,i)}this._modifyAxisCellContextIndex("row",m,this.m_endRow-m+1,u),this._refreshDatabodyMap(),this._handleCellInsertsFetchSuccess(e,[y,v])}},I.prototype._handleModelUpdateEvent=function(e,t,i){if(this._isInViewport(e)===I.INSIDE)if(null!=i){var s=this.getRendererOrTemplate("cell"),n=this.m_options.getColumnBandingInterval();this._updateCellsInRow(i,i.getStart("row"),s,this.m_startCol,n)}else-1!==this.m_endRowHeader&&this.fetchHeaders("row",e.row,this.m_rowHeader,this.m_rowEndHeader,1,{success:this._handleHeaderUpdatesFetchSuccess,error:this.handleHeadersFetchError}),this.fetchCells(this.m_databody,e.row,this.m_startCol,1,this.m_endCol-this.m_startCol+1,{success:this._handleCellUpdatesFetchSuccess,error:this.handleCellsFetchError})},I.prototype._handleHeaderUpdatesFetchSuccess=function(e,t,i){var s=t.axis;this.m_fetching[s]=!1;var n=t.start;this._replaceHeaders(this.buildRowHeaders.bind(this),e,this.m_rowHeader,n,this.m_startRowHeader),this._replaceHeaders(this.buildRowEndHeaders.bind(this),i,this.m_rowEndHeader,n,this.m_startRowEndHeader);var o=this.m_rowHeader.firstChild.childNodes[n-this.m_startRowHeader];null==this.m_active||"header"!==this.m_active.type||"row"!==this.m_active.axis&&"rowEnd"!==this.m_active.axis||this._getKey(o,"row")!==this.m_active.key||this._highlightActive(),this._signalTaskEnd()},I.prototype._replaceHeaders=function(e,t,i,s,n){if(null!=t){var o=e(i,t,s,1,!0,!0),r=i.firstChild,l=r.childNodes[s-n];r.replaceChild(o,l)}},I.prototype._handleCellUpdatesFetchSuccess=function(e,t){this.m_fetching.cells=!1;var i=t[0].start,s=this.getRendererOrTemplate("cell"),n=this.m_options.getColumnBandingInterval();this._updateCellsInRow(e,i,s,this.m_startCol,n),this._signalTaskEnd()},I.prototype._getUpdateAnimationDuration=function(){return I.UPDATE_ANIMATION_DURATION},I.prototype._updateCellsInRow=function(e,t,i,s,n){var o,r=this._getUpdateAnimationDuration(),l=this._getAxisCellsByIndex(t,"row"),a=this.getElementDir(l[0],"top");if(0!==r&&this.m_utils.supportsTransitions()){var h=this;h._signalTaskStart(),this._removeFromArray(l),o=document.createDocumentFragment(),this._addCellsToFragment(o,e,t,a,s,this.m_startColPixel),l=o.childNodes;for(var d=this.getElementWidth(this.m_databody),c=0;c<l.length;c++)this.addTransformMoveStyle(l[c],0,0,"linear",d,0,0);this._populateDatabody(this.m_databody.firstChild,o),l=this._getAxisCellsByIndex(t,"row"),this.hideStatusText();this._onTransitionEnd(l[l.length-1],function(){for(var e=0;e<l.length;e++)h.removeTransformMoveStyle(l[e]);h._isSelectionEnabled()&&h.applySelection(),h._highlightActive(),h._signalTaskEnd(),h._runModelEventQueue()},r),setTimeout(function(){for(var e=0;e<l.length;e++)h.addTransformMoveStyle(l[e],r+"ms",0,"linear",0,0,0)},0)}else this._removeFromArray(l),o=document.createDocumentFragment(),this._addCellsToFragment(o,e,t,a,s,this.m_startColPixel),this._populateDatabody(this.m_databody.firstChild,o),this._isSelectionEnabled()&&this.applySelection(),this._highlightActive(),this.hideStatusText()},I.prototype._handleUpdateRangeFetchSuccess=function(e,t,i){this.m_fetching.cells=!1;const s=i[0].start,n=s+t.getCount("row")-1,o=i[1].start,r=o+t.getCount("column")-1;var l=this._getCellsInRange(s,o,n,r);const a=this.getElementDir(l[0],"top"),h=this.getResources().isRTLMode()?"right":"left",d=this.getElementDir(l[0],h);this._removeFromArray(l);let c=document.createDocumentFragment();this._addCellsToFragment(c,t,s,a,o,d),this._populateDatabody(this.m_databody.firstChild,c),this.hideStatusText(),this._signalTaskEnd(),e.promiseResolve()},I.prototype._removeAndModifyCells=function(e,t){e.forEach(e=>{let i=e[this.getResources().getMappedAttribute("context")];1===i.extents[t]?this._remove(e):i.extent[t]-=1})},I.prototype._removeAndModifyHeaders=function(e,t,i,s,n){e.forEach(e=>{let o=e[this.getResources().getMappedAttribute("context")],r=o.extent,l=e.parentNode;if(1===r)this._remove(e),0===l.childNodes.length&&this._remove(l);else{let r=this.getElementDir(e,i);this.setElementDir(e,r-t,i),o.extent-=1;let a=o.index;if(a===n){o.index+=1;let i=this.getElementDir(e,s);this.setElementDir(e,i+t,s)}if(l.classList.contains(this.getMappedStyle("groupingcontainer"))){let e=this._getAttribute(l,"extent",!0),t=this._getAttribute(l,"start",!0);this._setAttribute(l,"extent",e-1),a===n&&this._setAttribute(l,"start",t+1)}}})},I.prototype._handleDeleteRangeEvent=function(e){let t=e.ranges,i=new Set,s=e.axis,n=this.getResources().isRTLMode()?"right":"left",o=this.m_selection;for(let e=0;e<o.length;e++)this._applyBorderClassesAroundRange(this.getElementsInRange(o[e]),o[e],!1,"Selected");t.forEach(function(e){let t=e.offset,s=e.count;for(var n=0;n<s;n++)i.add(t+n)});let r=Array.from(i);r.sort(function(e,t){return t-e});let l=0,a=0,h=0,d=0,c=0,m=this.m_rowHeader,u=this.m_startRowHeader,_=this.m_startRowEndHeader,p=this.m_rowEndHeader,g=this.m_rowHeaderLevelCount,f=this.m_rowEndHeaderLevelCount,C=this.m_avgRowHeight,y=-1!==this.m_endRow,v=-1!==this.m_endRowHeader,E=-1!==this.m_endRowEndHeader,S="height",w="top";"column"===s&&(u=this.m_startColHeader,_=this.m_startColEndHeader,m=this.m_colHeader,p=this.m_colEndHeader,g=this.m_columnHeaderLevelCount,f=this.m_columnEndHeaderLevelCount,C=this.m_avgColWidth,y=-1!==this.m_endCol,v=-1!==this.m_endColHeader,E=-1!==this.m_endColEndHeader,S="width",w=n);let H=[];for(let e=0;e<r.length;e++){let t=r[e],i=0,n=this._isAxisIndexInViewport(t,s);if(n===I.BEFORE||n===I.INSIDE){if(n===I.BEFORE)d+=1,i=C,l+=i;else if(n===I.INSIDE){c+=1,i=this.getElementDir(this._getCellOrHeaderByIndex(t,s),S),a+=i;let e=this._getAxisCellsByIndex(t,s);null!=e&&this._removeAndModifyCells(e,s);let n=this._getHeadersByIndex(t,m,g,u);n.length&&this._removeAndModifyHeaders(n,i,S,w,t);let o=this._getHeadersByIndex(t,p,f,_);o.length&&this._removeAndModifyHeaders(o,i,S,w,t)}H.unshift(i)}else n===I.AFTER&&"scroll"===this.m_options.getScrollPolicy()&&(h+=i)}r.reverse(),this._modifyAndPushCells(r,H,s,m,p,!1),this._simpleAdjustSelectionOnChange("delete",r.reverse(),s),this._refreshDatabodyMap();var b=l+a+h,x=this.m_databody.firstChild;if("row"===s){y&&(this.m_startRow-=d,this.m_endRow=this.m_endRow-d-c,this.m_startRowPixel-=l,this.m_endRowPixel=this.m_endRowPixel-l-a,this.m_stopRowFetch=!1),v&&(this.m_startRowHeader-=d,this.m_endRowHeader=this.m_endRowHeader-d-c,this.m_startRowHeaderPixel-=l,this.m_endRowHeaderPixel=this.m_endRowHeaderPixel-l-a,this.m_stopRowHeaderFetch=!1),E&&(this.m_startRowEndHeader-=d,this.m_endRowEndHeader=this.m_endRowEndHeader-d-c,this.m_startRowEndHeaderPixel-=l,this.m_endRowEndHeaderPixel=this.m_endRowEndHeaderPixel-l-a,this.m_stopRowEndHeaderFetch=!1);var R=this.getElementHeight(x)-b;this.setElementHeight(x,R),this.updateRowBanding()}else if("column"===s){y&&(this.m_startCol-=d,this.m_endCol=this.m_endCol-d-c,this.m_startColPixel-=l,this.m_endColPixel=this.m_endColPixel-l-a,this.m_stopColumnFetch=!1),v&&(this.m_startColHeader-=d,this.m_endColHeader=this.m_endColHeader-d-c,this.m_startColHeaderPixel-=l,this.m_endColHeaderPixel=this.m_endColHeaderPixel-l-a,this.m_stopColumnHeaderFetch=!1),E&&(this.m_startColEndHeader-=d,this.m_endColEndHeader=this.m_endColEndHeader-d-c,this.m_startColEndHeaderPixel-=l,this.m_endColEndHeaderPixel=this.m_endColEndHeaderPixel-l-a,this.m_stopColumnEndHeaderFetch=!1);var M=this.getElementWidth(x)-b;this.setElementWidth(x,M),this.updateColumnBanding()}this.applySelection(),this.m_utils.isTouchDevice()&&(this.GetSelection().length?this._moveTouchSelectionAffordance():this._removeTouchSelectionAffordance(!0)),this.resizeGrid(),this.m_resizeRequired=!0,this.fillViewport()},I.prototype._handleModelDeleteEvent=function(e,t,i){var s,n,o,r;Array.isArray(t)||(t=new Array(t),e=new Array(e));for(var l=0,a=0,h=0,d=0,c=0,m=0;m<t.length;m++){var u=t[m],_=e[m];if(null!=u.row){var p=0,g=u.row,f=this._isInViewport(_);f===I.BEFORE?(this._modifyAxisCellContextIndex("row",this.m_startRow,this.m_endRow-this.m_startRow+1,-1),d+=1,l+=this.m_avgRowHeight,this.m_startRowPixel-=this.m_avgRowHeight,this.m_endRowPixel-=this.m_avgRowHeight,-1!==this.m_endRowHeader&&(this.m_startRowHeaderPixel-=this.m_avgRowHeight,this.m_endRowHeaderPixel-=this.m_avgRowHeight),null!=(r=this._getAxisCellsByKey(g,"row"))&&this.pushRowsUp(this.m_startRow,this.m_avgRowHeight),null!=(n=this.m_rowHeader.firstChild.firstChild)&&this.pushRowHeadersUp(n,this.m_avgRowHeight),null!=(o=this.m_rowEndHeader.firstChild.firstChild)&&this.pushRowHeadersUp(o,this.m_avgRowHeight)):f===I.INSIDE?(c+=1,null!=(r=this._getAxisCellsByKey(g,"row"))&&(p=this.calculateRowHeight(r[0]),_=r[0][this.getResources().getMappedAttribute("context")].indexes.row,this._modifyAxisCellContextIndex("row",_+1,this.m_endRow-_,-1),this._removeFromArray(r),this.pushRowsUp(_,p),this.m_endRowPixel-=p),null!=(n=this._findHeaderByKey(g,this.m_rowHeader,this.getMappedStyle("rowheadercell")))&&(p=this.calculateRowHeaderHeight(n),s=n.nextSibling,this._remove(n),this.pushRowHeadersUp(s,p),this.m_endRowHeaderPixel-=p),null!=(o=this._findHeaderByKey(g,this.m_rowEndHeader,this.getMappedStyle("rowendheadercell")))&&(p=this.calculateRowHeaderHeight(o),s=o.nextSibling,this._remove(o),this.pushRowHeadersUp(s,p),this.m_endRowEndHeaderPixel-=p),a+=p):"scroll"===this.m_options.getScrollPolicy()&&(h+=this.m_avgRowHeight)}}this._refreshDatabodyMap(),this.m_startRow-=d,this.m_endRow=this.m_endRow-d-c,-1!==this.m_endRowHeader&&(this.m_startRowHeader-=d,this.m_endRowHeader=this.m_endRowHeader-d-c),-1!==this.m_endRowEndHeader&&(this.m_startRowEndHeader-=d,this.m_endRowEndHeader=this.m_endRowEndHeader-d-c);var C=l+a+h,y=this.m_databody.firstChild,v=this.getElementHeight(y)-C;this.setElementHeight(y,v),this.resizeGrid(),i||!0===this.m_moveActive||(this.m_resizeRequired=!0,this.m_stopRowFetch=!1,-1!==this.m_endRowHeader&&(this.m_stopRowHeaderFetch=!1),-1!==this.m_endRowEndHeader&&(this.m_stopRowEndHeaderFetch=!1),this.fillViewport()),this.updateRowBanding()},I.prototype._handleModelDeleteEventWithAnimation=function(e){this._collapseRowsWithAnimation(e)},I.prototype._collapseRowsWithAnimation=function(e){var t,i,s,n,o,r,l,a;if(0!==e.length){var h=this;h._signalTaskStart();var d=this.m_processingEventQueue?1:I.COLLAPSE_ANIMATION_DURATION,c=[],m=0,u=-1!==this.m_endRowHeader,_=-1!==this.m_endRowEndHeader,p=this.m_databody.firstChild,g=this._getIndex(this._getAxisCellsByKey(e[0].row,"row")[0],"row")-1;for(i=g;i>=this.m_startRow&&(t=this._getAxisCellsByIndex(i,"row"),!(this.getElementDir(t[0],"top")+this.getElementHeight(t[0])<this.m_currentScrollTop));i--)for(s=0;s<t.length;s++)this.changeStyleProperty(t[s],this.getCssSupport("z-index"),10);if(u)for(o=[],n=this._findHeaderByKey(e[0].row,this.m_rowHeader,this.getMappedStyle("rowheadercell")).previousSibling;n&&!(this.getElementDir(n,"top")+this.getElementHeight(n)<this.m_currentScrollTop);)this.changeStyleProperty(n,this.getCssSupport("z-index"),10),n=n.previousSibling;if(_)for(r=[],n=this._findHeaderByKey(e[0].row,this.m_rowEndHeader,this.getMappedStyle("rowendheadercell")).previousSibling;n&&!(this.getElementDir(n,"top")+this.getElementHeight(n)<this.m_currentScrollTop);)this.changeStyleProperty(n,this.getCssSupport("z-index"),10),n=n.previousSibling;for(i=0;i<e.length;i++){var f=e[i].row;if((t=this._getAxisCellsByKey(f,"row")).length)for(c.push(t),m+=this.getElementHeight(t[0]),s=0;s<t.length;s++)this.setElementDir(t[s],this.getElementDir(t[s],"top")-m,"top"),this.addTransformMoveStyle(t[s],0,0,"linear",0,m,0);u&&null!=(l=this._findHeaderByKey(f,this.m_rowHeader,this.getMappedStyle("rowheadercell")))&&(o.push(l),this.setElementDir(l,this.getElementDir(l,"top")-m,"top"),this.addTransformMoveStyle(l,0,0,"linear",0,m,0)),_&&null!=(a=this._findHeaderByKey(f,this.m_rowEndHeader,this.getMappedStyle("rowendheadercell")))&&(r.push(a),this.setElementDir(a,this.getElementDir(a,"top")-m,"top"),this.addTransformMoveStyle(a,0,0,"linear",0,m,0))}for(i=g+e.length+1;i<=this.m_endRow;i++){for(t=this._getAxisCellsByIndex(i,"row"),s=0;s<t.length;s++)this.setElementDir(t[s],this.getElementDir(t[s],"top")-m,"top"),this.addTransformMoveStyle(t[s],0,0,"linear",0,m,0);u&&(l=l.nextSibling,this.setElementDir(l,this.getElementDir(l,"top")-m,"top"),this.addTransformMoveStyle(l,0,0,"linear",0,m,0)),_&&(a=a.nextSibling,this.setElementDir(a,this.getElementDir(a,"top")-m,"top"),this.addTransformMoveStyle(a,0,0,"linear",0,m,0))}var C=this._getCellByIndex(this.createIndex(this.m_endRow,this.m_endCol));h._onTransitionEnd(C,function(){c.length&&h._modifyAxisCellContextIndex("row",g+e.length+1,h.m_endRow-(g+e.length),-1*e.length),u&&o.length&&h._modifyAxisHeaderContextIndex("row",g+e.length+1,h.m_endRow-(g+e.length),-1*e.length),_&&r.length&&h._modifyAxisHeaderContextIndex("rowEnd",g+e.length+1,h.m_endRow-(g+e.length),-1*e.length);for(var t=0;t<c.length;t++){for(var i=0;i<c[t].length;i++)h._remove(c[t][i]);u&&h._remove(o[t]),_&&h._remove(r[t])}h._refreshDatabodyMap(),h.m_endRow-=c.length,h.m_endRowPixel-=m,h.m_stopRowFetch=!1,u&&(h.m_endRowHeader-=o.length,h.m_endRowHeaderPixel-=m,h.m_stopRowHeaderFetch=!1),_&&(h.m_endRowEndHeader-=o.length,h.m_endRowEndHeaderPixel-=m,h.m_stopRowEndHeaderFetch=!1),h.setElementHeight(p,h.m_endRowPixel-h.m_startRowPixel),h.resizeGrid(),h.updateRowBanding(),null==h.m_modelEvents||0!==h.m_modelEvents.length||h.m_moveActive||h.fillViewport(),h._handleAnimationEnd()},d),this.m_animating=!0,setTimeout(function(){for(i=g+1;i<=h.m_endRow;i++){for(t=h._getAxisCellsByIndex(i,"row"),s=0;s<t.length;s++)h.addTransformMoveStyle(t[s],d+"ms",0,"ease-out",0,0,0);u&&(l=h._getHeaderByIndex(i,0,h.m_rowHeader,h.m_rowHeaderLevelCount,h.m_startRowHeader),h.addTransformMoveStyle(l,d+"ms",0,"ease-out",0,0,0)),_&&(a=h._getHeaderByIndex(i,0,h.m_rowEndHeader,h.m_rowEndHeaderLevelCount,h.m_startRowEndHeader),h.addTransformMoveStyle(a,d+"ms",0,"ease-out",0,0,0))}},0)}},I.prototype._handleAnimationEnd=function(){var e,t=this.m_databody.firstChild,i=this.m_rowHeader.firstChild,s=this.m_rowEndHeader.firstChild;for(e=0;e<t.childNodes.length;e++)this.removeTransformMoveStyle(t.childNodes[e]),this.changeStyleProperty(t.childNodes[e],this.getCssSupport("z-index"),null,"remove");if(-1!==this.m_endRowHeader)for(e=0;e<i.childNodes.length;e++)this.removeTransformMoveStyle(i.childNodes[e]),this.changeStyleProperty(i.childNodes[e],this.getCssSupport("z-index"),null,"remove");if(-1!==this.m_endRowEndHeader)for(e=0;e<s.childNodes.length;e++)this.removeTransformMoveStyle(s.childNodes[e]),this.changeStyleProperty(s.childNodes[e],this.getCssSupport("z-index"),null,"remove");this.m_animating=!1,this._runModelEventQueue(),this._signalTaskEnd()},I.prototype._getCellOrHeaderByKey=function(e,t){var i=null,s=this._getAxisCellsByKey(e,t,!0);return null!=s&&s.length>0&&(i=s[0]),null==i&&("row"===t?null==(i=this._findHeaderByKey(e,this.m_rowHeader,this.getMappedStyle("rowheadercell")))&&(i=this._findHeaderByKey(e,this.m_rowEndHeader,this.getMappedStyle("rowendheadercell"))):"column"===t&&null==(i=this._findHeaderByKey(e,this.m_colHeader,this.getMappedStyle("colheadercell")))&&(i=this._findHeaderByKey(e,this.m_colEndHeader,this.getMappedStyle("colendheadercell")))),i},I.prototype._findHeaderByKey=function(e,t,i){if(null==t)return null;var s;s=t.getElementsByClassName?t.getElementsByClassName(i):t.childNodes;for(var n=0;n<s.length;n++){var o=s[n],r=this._getKey(o);if(this._shallowThenDeepCompare(r,e))return o}return null},I.prototype._handleModelRefreshEvent=function(){var e=this.getVisibility();this.m_focusOnRefresh=this.m_root.contains(document.activeElement),this.m_updateScrollPostionOnRefreshCallback(),e===I.VISIBILITY_STATE_VISIBLE?(this.empty(),null!=this.m_root.offsetParent?this.refresh(this.m_root):this.setVisibility(I.VISIBILITY_STATE_REFRESH)):e===I.VISIBILITY_STATE_HIDDEN&&(this.empty(),this.setVisibility(I.VISIBILITY_STATE_REFRESH))},I.prototype._handleModelSyncEvent=function(e){var t=e.pageSize;this.m_fetching={},this.m_startRow=0,this.m_endRow=-1,this.m_startRowHeader=0,this.m_endRowHeader=-1,this.m_startRowEndHeader=0,this.m_endRowEndHeader=-1,this.m_startRowPixel=0,this.m_endRowPixel=0,this.m_startRowHeaderPixel=0,this.m_endRowHeaderPixel=0,this.m_startRowEndHeaderPixel=0,this.m_endRowEndHeaderPixel=0,this.m_startCol=0,this.m_endCol=-1,this.m_startColHeader=0,this.m_endColHeader=-1,this.m_startColEndHeader=0,this.m_endColEndHeader=-1,this.m_startColPixel=0,this.m_endColPixel=0,this.m_startColHeaderPixel=0,this.m_endColHeaderPixel=0,this.m_startColEndHeaderPixel=0,this.m_endColEndHeaderPixel=0,this.m_rowHeaderLevelCount=void 0,this.m_columnHeaderLevelCount=void 0,this.m_rowEndHeaderLevelCount=void 0,this.m_columnEndHeaderLevelCount=void 0,this.m_avgRowHeight=void 0,this.m_avgColWidth=void 0,this.m_isEstimateRowCount=void 0,this.m_isEstimateColumnCount=void 0,this.m_stopRowFetch=!1,this.m_stopRowHeaderFetch=!1,this.m_stopRowEndHeaderFetch=!1,this.m_stopColumnFetch=!1,this.m_stopColumnHeaderFetch=!1,this.m_stopColumnEndHeaderFetch=!1,this._clearScrollPositionKeys(),this.m_selection=null,this.m_selectionRange=null,this.m_active=null,this.m_prevActive=null,this.m_trueIndex={},null!=this.m_empty&&(this.m_root.removeChild(this.m_empty),this.m_empty=null),this._showHeader(this.m_rowHeader),this._showHeader(this.m_colHeader),this._showHeader(this.m_rowEndHeader),this._showHeader(this.m_colEndHeader),this._emptyHeaders(),this._emptyHeaderLabels();var i=this.m_databody.firstChild;null!=i&&this._emptyDatabody(i),this.m_initialized=!1,this.fetchHeaders("row",0,this.m_rowHeader,this.m_rowEndHeader,t,{success:function(e,t,i){this.handleHeadersFetchSuccess(e,t,i,!1)}}),this.fetchHeaders("column",0,this.m_colHeader,this.m_colEndHeader,void 0,{success:function(e,t,i){this.handleHeadersFetchSuccess(e,t,i,!1)}}),this.fetchCells(this.m_databody,0,0,t,null,{success:function(e,t){this.handleCellsFetchSuccess(e,t)}})},I.prototype._emptyHeaders=function(){var e=this.m_rowHeader.firstChild,t=this.m_rowEndHeader.firstChild;null!=e&&this.m_utils.empty(e),null!=t&&this.m_utils.empty(t);var i=this.m_colHeader.firstChild,s=this.m_colEndHeader.firstChild;null!=i&&this.m_utils.empty(i),null!=s&&this.m_utils.empty(s)},I.prototype._emptyHeaderLabels=function(){var e=this.m_headerLabels.row,t=this.m_headerLabels.rowEnd,i=this.m_headerLabels.column,s=this.m_headerLabels.columnEnd;e&&e.length&&e.forEach(e=>{this.m_utils.empty(e)}),t&&t.length&&t.forEach(e=>{this.m_utils.empty(e)}),i&&i.length&&i.forEach(e=>{this.m_utils.empty(e)}),s&&s.length&&s.forEach(e=>{this.m_utils.empty(e)})},I.prototype._setActiveByIndex=function(e,t,i,s,n){return this._setActive(this._getCellByIndex(e),{type:"cell",indexes:e},t,i,s,n)},I.prototype._updateActive=function(e,t,i){var s;if(null==e)this._setActive(null,null,null,!0,!1,i);else if(null!=e.keys)s=this._getCellByKeys(e.keys);else if(null!=e.indexes)s=this._getCellByIndex(e.indexes);else if(null!=e.axis){var n=null==e.level?0:e.level;"column"===e.axis?null!=e.key?s=this._findHeaderByKey(e.key,this.m_colHeader,this.getMappedStyle("colheadercell")):null!=e.index&&(s=this._getHeaderByIndex(e.index,n,this.m_colHeader,this.m_columnHeaderLevelCount,this.m_startColHeader)):"row"===e.axis?null!=e.key?s=this._findHeaderByKey(e.key,this.m_rowHeader,this.getMappedStyle("rowheadercell")):null!=e.index&&(s=this._getHeaderByIndex(e.index,n,this.m_rowHeader,this.m_rowHeaderLevelCount,this.m_startRowHeader)):"columnEnd"===e.axis?null!=e.key?s=this._findHeaderByKey(e.key,this.m_colEndHeader,this.getMappedStyle("colendheadercell")):null!=e.index&&(s=this._getHeaderByIndex(e.index,n,this.m_colEndHeader,this.m_columnEndHeaderLevelCount,this.m_startColEndHeader)):"rowEnd"===e.axis&&(null!=e.key?s=this._findHeaderByKey(e.key,this.m_rowEndHeader,this.getMappedStyle("rowendheadercell")):null!=e.index&&(s=this._getHeaderByIndex(e.index,n,this.m_rowEndHeader,this.m_rowEndHeaderLevelCount,this.m_startRowEndHeader)))}null!=s&&(t||(this.m_shouldFocus=!1),this._setActive(s,e,null,!0,!1,i))},I.prototype._setActive=function(e,t,i,s,n,o){var r;if(null==t||o||this._scrollToActive(t),null!=e)if(r=this._createActiveObject(e),this._compareActive(r,this.m_active)){if(n||this._fireBeforeCurrentCellEvent(r,this.m_active,i))return this.m_prevActive=this.m_active,this.m_active=r,i&&"mousedown"===i.type&&(this.m_trueIndex=null),s&&this._isSelectionEnabled()&&this._clearSelection(i),this._unhighlightActiveObject(this.m_prevActive),this._highlightActiveObject(this.m_active,this.m_prevActive),this._manageMoveCursor(),this._isGridEditable()&&"cell"===r.type&&(this._setEditableClone(e),this._updateEdgeCellBorders("")),n||this._fireCurrentCellEvent(r,i),!0}else this._highlightActive();else if(!this.m_scrollIndexAfterFetch&&!this.m_scrollHeaderAfterFetch)return(n||this._fireBeforeCurrentCellEvent(r,this.m_active,i))&&(this.m_prevActive=this.m_active,this.m_active=null,this._unhighlightActiveObject(this.m_prevActive),n||this._fireCurrentCellEvent(r,i)),!0;return!1},I.prototype._createActiveObject=function(e){var t=e[this.getResources().getMappedAttribute("context")];return this.m_utils.containsCSSClassName(e,this.getMappedStyle("headercell"))||this.m_utils.containsCSSClassName(e,this.getMappedStyle("endheadercell"))?{type:"header",axis:t.axis,index:this.getHeaderCellIndex(e),key:t.key,level:t.level}:this.m_utils.containsCSSClassName(e,this.getMappedStyle("headerlabel"))?{type:"label",axis:t.axis,level:t.level}:{type:"cell",indexes:{row:t.indexes.row,column:t.indexes.column},keys:{row:t.keys.row,column:t.keys.column},extents:{row:t.extents.row,column:t.extents.column}}},I.prototype._getActiveElement=function(){return this._getElementFromActiveObject(this.m_active)},I.prototype._getElementFromActiveObject=function(e){if(null!=e){if("header"!==e.type)return"label"===e.type?this._getLabel(e.axis,e.level):this._getCellByIndex(e.indexes);if("row"===e.axis)return this._findHeaderByKey(e.key,this.m_rowHeader,this.getMappedStyle("rowheadercell"));if("column"===e.axis)return this._findHeaderByKey(e.key,this.m_colHeader,this.getMappedStyle("colheadercell"));if("rowEnd"===e.axis)return this._findHeaderByKey(e.key,this.m_rowEndHeader,this.getMappedStyle("rowendheadercell"));if("columnEnd"===e.axis)return this._findHeaderByKey(e.key,this.m_colEndHeader,this.getMappedStyle("colendheadercell"))}return null},I.prototype._compareActive=function(e,t){if(null==e&&null==t)return!1;if(null==e&&null!=t||null!=e&&null==t)return!0;if(e.type!==t.type)return!0;if("header"===e.type){if(e.index!==t.index||e.key!==t.key||e.axis!==t.axis||e.level!==t.level)return!0}else if("label"===e.type){if(e.axis!==t.axis||e.level!==t.level)return!0}else if(e.indexes.row!==t.indexes.row||e.indexes.column!==t.indexes.column||e.keys.row!==t.keys.row||e.keys.column!==t.keys.column)return!0;return!1},I.prototype._fireBeforeCurrentCellEvent=function(e,t,i){var s={event:i,ui:{currentCell:e,previousCurrentCell:t}};return this.fireEvent("beforeCurrentCell",s)},I.prototype._fireCurrentCellEvent=function(e,t){var i={event:t,ui:e};return this.fireEvent("currentCell",i)},I.prototype._isDatabodyCellActive=function(){return null!=this.m_active&&"cell"===this.m_active.type},I.prototype._updateActiveContext=function(e,t){var i,s,n,o={};if("header"===e.type){i=e.axis;var r=e.index;s=e.level,"row"===e.axis?(this.m_rowHeaderLevelCount>1&&(null!=t&&s===t.level&&i===t.axis||(o.level=s)),null!=t&&r===t.index&&i===t.axis||(o.rowHeader=r)):"column"===i?(this.m_columnHeaderLevelCount>1&&(null!=t&&s===t.level&&i===t.axis||(o.level=s)),null!=t&&r===t.index&&i===t.axis||(o.columnHeader=r)):"rowEnd"===e.axis?(this.m_rowEndHeaderLevelCount>1&&(null!=t&&s===t.level&&i===t.axis||(o.level=s)),null!=t&&r===t.index&&i===t.axis||(o.rowEndHeader=r)):"columnEnd"===i&&(this.m_columnEndHeaderLevelCount>1&&(null!=t&&s===t.level&&i===t.axis||(o.level=s)),null!=t&&r===t.index&&i===t.axis||(o.columnEndHeader=r)),this._updateContextInfo(o,n)}else"cell"===e.type?(null==t||"cell"!==t.type||null==e||this.m_externalFocus||(e.indexes.row===t.indexes.row?n="row":e.indexes.column===t.indexes.column&&(n="column")),this._updateContextInfo(e,n)):"label"===e.type&&(i=e.axis,s=e.level,(null==t||"label"!==t.type||"label"===t.type&&t.axis!==i||this.m_externalFocus)&&("column"===i?o.columnHeaderLabel=s:"row"===i?o.rowHeaderLabel=s:"rowEnd"===i?o.rowEndHeaderLabel=s:"columnEnd"===i&&(o.columnEndHeaderLabel=s)),this._updateContextInfo(o,n))},I.prototype.handleDatabodyClickActive=function(e){var t=e.target,i=this.findCell(t);null!=i&&this._setActive(i,this._createActiveObject(i),e)},I.prototype.handleHeaderClickActive=function(e,t){var i=e.target,s=this.findHeader(i);null!=s&&(t||this._clearSelection(e),this._setActive(s,this._createActiveObject(s),e))},I.prototype._scrollToActive=function(e){"header"===e.type?this.scrollToHeader(e):"cell"===e.type&&this.scrollToIndex(e.indexes)},I.prototype._getCellByKeys=function(e){if(null==e||null==e.row||null==e.column||null==this.m_databody||null==this.m_databody.firstChild)return null;for(var t=this.m_databody.firstChild.getElementsByClassName(this.getMappedStyle("cell")),i=0;i<t.length;i++){var s=t[i],n=this._getKey(s,"row");if(this._shallowThenDeepCompare(n,e.row)){var o=this._getKey(s,"column");if(this._shallowThenDeepCompare(o,e.column))return s}}return null},I.prototype._shallowThenDeepCompare=function(e,t){return e===t||this._compareValuesCallback(e,t)},I.prototype.getCellKeys=function(e){var t=e[this.getResources().getMappedAttribute("context")];return this.createIndex(t.keys.row,t.keys.column)},I.prototype.getCellIndexes=function(e){var t=e[this.getResources().getMappedAttribute("context")];return this.createIndex(t.indexes.row,t.indexes.column)},I.prototype.getCellExtents=function(e){var t=e[this.getResources().getMappedAttribute("context")];return this.createIndex(t.extents.row,t.extents.column)},I.prototype.getCellEndIndexes=function(e){var t=this.getCellIndexes(e),i=this.getCellExtents(e);return this.createIndex(t.row+(i.row-1),t.column+(i.column-1))},I.prototype._getIndex=function(e,t){if(null!=e){if(null==t||!this.m_utils.containsCSSClassName(e,this.getMappedStyle("cell")))return this.getHeaderCellIndex(e);var i=e[this.getResources().getMappedAttribute("context")];if("row"===t)return i.indexes.row;if("column"===t)return i.indexes.column}return null},I.prototype._getExtent=function(e,t){if(null!=e){if(null==t||!this.m_utils.containsCSSClassName(e,this.getMappedStyle("cell")))return parseInt(this._getAttribute(e,"extent",!0),10);var i=e[this.getResources().getMappedAttribute("context")];if("row"===t)return i.extents.row;if("column"===t)return i.extents.column}return null},I.prototype.getHeaderCellIndex=function(e){var t,i,s;switch(this.getHeaderCellAxis(e)){case"column":t=this.m_columnHeaderLevelCount,i=this.m_startColHeader;break;case"row":t=this.m_rowHeaderLevelCount,i=this.m_startRowHeader;break;case"columnEnd":t=this.m_columnEndHeaderLevelCount,i=this.m_startColEndHeader;break;case"rowEnd":t=this.m_rowEndHeaderLevelCount,i=this.m_startRowEndHeader;break;default:return-1}if(t>1){if(s=this._getAttribute(e.parentNode,"start",!0),e===e.parentNode.firstChild)return s;s-=1}else s=i;for(;e.previousSibling;)s+=1,e=e.previousSibling;return s},I.prototype.getHeaderCellAxis=function(e){return this.m_utils.containsCSSClassName(e,this.getMappedStyle("colheadercell"))?"column":this.m_utils.containsCSSClassName(e,this.getMappedStyle("rowheadercell"))?"row":this.m_utils.containsCSSClassName(e,this.getMappedStyle("rowendheadercell"))?"rowEnd":this.m_utils.containsCSSClassName(e,this.getMappedStyle("colendheadercell"))?"columnEnd":null},I.prototype.getHeaderCellLevel=function(e){if(this.m_utils.containsCSSClassName(e,this.getMappedStyle("colheadercell"))){if(1===this.m_columnHeaderLevelCount)return 0}else if(this.m_utils.containsCSSClassName(e,this.getMappedStyle("rowheadercell"))){if(1===this.m_rowHeaderLevelCount)return 0}else if(this.m_utils.containsCSSClassName(e,this.getMappedStyle("colendheadercell"))){if(1===this.m_columnEndHeaderLevelCount)return 0}else if(this.m_utils.containsCSSClassName(e,this.getMappedStyle("rowendheadercell"))&&1===this.m_rowEndHeaderLevelCount)return 0;var t=this._getAttribute(e.parentNode,"level",!0);return e===e.parentNode.firstChild?t:t+this.getHeaderCellDepth(e.parentNode.firstChild)},I.prototype.getHeaderCellDepth=function(e){return this._getAttribute(e,"depth",!0)},I.prototype.getHeaderLabelLevel=function(e){let t=e[this.getResources().getMappedAttribute("context")];return t?t.level:null},I.prototype.getHeaderLabelAxis=function(e){let t=e[this.getResources().getMappedAttribute("context")];return t?t.axis:null},I.prototype._getResizeHeaderMode=function(e){var t="row";return(this.m_utils.containsCSSClassName(e,this.getMappedStyle("colheadercell"))||this.m_utils.containsCSSClassName(e,this.getMappedStyle("colendheadercell"))||this.m_utils.containsCSSClassName(e,this.getMappedStyle("columnheaderlabel"))||this.m_utils.containsCSSClassName(e,this.getMappedStyle("columnendheaderlabel")))&&(t="column"),t},I.prototype.findCellOrHeader=function(e){var t=this.findCell(e);return null==t&&(t=this.findHeader(e)),t},I.prototype.findCell=function(e){return this.find(e,"cell")},I.prototype.findLabel=function(e){return this.find(e,"headerlabel")},I.prototype.find=function(e,t,i){return null==e||e===this.getRootElement()?null:(null==i&&(i=this.getMappedStyle(t)),null==i?null:this.m_utils.containsCSSClassName(e,i)?e:this.find(e.parentNode,t,i))},I.prototype._highlightActive=function(e){this._highlightActiveObject(this.m_active,this.m_prevActive,e)},I.prototype._unhighlightActive=function(e){this._unhighlightActiveObject(this.m_active,e)},I.prototype._highlightActiveObject=function(e,t,i){if(null==i&&this.m_utils.shouldOffsetOutline()&&(i=["offsetOutline"]),null!=e){var s=this._getElementFromActiveObject(e);null!=s&&(this.m_focusInHandler(s),null!=i&&this._highlightElement(s,i),this._isCellEditable()&&"cell"===e.type&&this._applyBorderClassesAroundRange(s,{startIndex:e.indexes},!0,"Edit"),this._setAriaProperties(e,t,s))}},I.prototype._unhighlightActiveObject=function(e,t){if(null==t&&this.m_utils.shouldOffsetOutline()&&(t=["offsetOutline"]),null!=e){var i=this._getElementFromActiveObject(e);null!=i&&(this.m_focusOutHandler(i),null!=t&&this._unhighlightElement(i,t),this._isGridEditable()&&"cell"===e.type&&this._applyBorderClassesAroundRange(i,{startIndex:e.indexes},!1,"Edit"),this._unsetAriaProperties(i))}},I.prototype._highlightCellsAlongAxis=function(e,t,i,s,n){for(var o="key"===i?this._getAxisCellsByKey(e,t):this._getAxisCellsByIndex(e,t),r=0;r<o.length;r++)"add"===s?this._highlightElement(o[r],n):this._unhighlightElement(o[r],n)},I.prototype._highlightElement=function(e,t){for(var i=0;i<t.length;i++){var s=this.getMappedStyle(t[i]);this.m_utils.addCSSClassName(e,s)}},I.prototype._unhighlightElement=function(e,t){for(var i=0;i<t.length;i++){var s=this.getMappedStyle(t[i]);this.m_utils.removeCSSClassName(e,s)}},I.prototype._unhighlightElementsByClassName=function(e,t){if(e.length&&t.length)for(var i=0;i<e.length;i++)this._unhighlightElement(e[i],t)},I.prototype._setAriaProperties=function(e,t,i){var s=this.getLabelledBy(e,t,i);this._updateActiveContext(e,t),i.setAttribute("tabIndex",0),i.setAttribute("aria-labelledby",s),null!=this.m_cellToFocus&&this.m_cellToFocus===i||!1===this.m_shouldFocus||i.focus(),this.m_shouldFocus=null},I.prototype._unsetAriaProperties=function(e){null!=e&&(e.setAttribute("tabIndex",-1),e.removeAttribute("aria-labelledby"))},I.prototype.getLabelledBy=function(e,t,i){var s,n,o,r,l="",a=[];const h=i[this.getResources().getMappedAttribute("metadata")];if("header"===e.type){null==t||"header"!==t.type||this.m_externalFocus||("row"===t.axis?s=this._getHeaderByIndex(t.index,t.level,this.m_rowHeader,this.m_rowHeaderLevelCount,this.m_startRowHeader):"column"===t.axis?s=this._getHeaderByIndex(t.index,t.level,this.m_colHeader,this.m_columnHeaderLevelCount,this.m_startColHeader):"rowEnd"===t.axis?s=this._getHeaderByIndex(t.index,t.level,this.m_rowEndHeader,this.m_rowEndHeaderLevelCount,this.m_startRowEndHeader):"columnEnd"===t.axis&&(s=this._getHeaderByIndex(t.index,t.level,this.m_colEndHeader,this.m_columnEndHeaderLevelCount,this.m_startColEndHeader))),l=[this.createSubId("context"),this._getHeaderAndParentIds(i,s)].join(" ");var d=i.getAttribute(this.getResources().getMappedAttribute("sortDir"));"ascending"===d?(n="accessibleSortAscending",l=l+" "+this.createSubId("state")):"descending"===d&&(n="accessibleSortDescending",l=l+" "+this.createSubId("state")),!0===this.m_externalFocus&&(l=[this.createSubId("summary"),l].join(" "),this.m_externalFocus=!1),null!=n&&a.push({key:n,args:{id:""}}),h&&h.metadata&&("expanded"===h.metadata.expanded?a.push({key:"accessibleExpanded",args:{}}):"collapsed"===h.metadata.expanded&&a.push({key:"accessibleCollapsed",args:{}})),i.setAttribute("tabIndex",0)}else if("label"===e.type)l=[this.createSubId("context"),this._getActiveElement().id].join(" ");else{null!=t&&("header"===t.type?(o="row"===t.axis?t.index:null,r="column"===t.axis?t.index:null):"cell"===t.type&&(o=t.indexes.row,r=t.indexes.column));var m=this._getHeaderLabelledBy("row",this.m_rowHeader,this.m_rowHeaderLevelCount,this.m_startRowHeader,this.m_endRowHeader,e.indexes.row,o,i),u=this._getHeaderLabelledBy("rowEnd",this.m_rowEndHeader,this.m_rowEndHeaderLevelCount,this.m_startRowEndHeader,this.m_endRowEndHeader,e.indexes.row,o,i),_=this._getHeaderLabelledBy("column",this.m_colHeader,this.m_columnHeaderLevelCount,this.m_startColHeader,this.m_endColHeader,e.indexes.column,r,i),p=this._getHeaderLabelledBy("columnEnd",this.m_colEndHeader,this.m_columnEndHeaderLevelCount,this.m_startColEndHeader,this.m_endColEndHeader,e.indexes.column,r,i),g=e.extents.row,f=e.extents.column;g>1&&a.push({key:"accessibleRowSpanContext",args:{extent:g}}),f>1&&a.push({key:"accessibleColumnSpanContext",args:{extent:f}}),l=(l=[this.createSubId("context"),m,u,_,p,i.id,this.createSubId("state")].join(" ")).replace(/ +(?= )/g,""),this.m_externalFocus&&(l=[this.createSubId("summary"),l].join(" "),this.m_externalFocus=!1)}let C=c.getFocusableElementsIncludingDisabled(i);return C&&C.length>0&&a.push({key:"accessibleContainsControls"}),this._updateStateInfo(a),l},I.prototype.getHeaderFromCell=function(e,t,i){var s,n,o,r,l,a;return"row"===t?null!=this.m_rowHeader&&(s=this._getIndex(e,"row"),n=this._getExtent(e,"row"),o=this.m_rowHeaderLevelCount-1,r=this.m_rowHeader,l=this.m_rowHeaderLevelCount,a=this.m_startRowHeader):"column"===t?null!=this.m_colHeader&&(s=this._getIndex(e,"column"),n=this._getExtent(e,"column"),o=this.m_columnHeaderLevelCount-1,r=this.m_colHeader,l=this.m_columnHeaderLevelCount,a=this.m_startColHeader):"rowEnd"===t?null!=this.m_rowEndHeader&&(s=this._getIndex(e,"row"),n=this._getExtent(e,"row"),o=this.m_rowEndHeaderLevelCount-1,r=this.m_rowEndHeader,l=this.m_rowEndHeaderLevelCount,a=this.m_startRowEndHeader):"columnEnd"===t&&null!=this.m_colEndHeader&&(s=this._getIndex(e,"column"),n=this._getExtent(e,"column"),o=this.m_columnEndHeaderLevelCount-1,r=this.m_colEndHeader,l=this.m_columnEndHeaderLevelCount,a=this.m_startColEndHeader),null!=s&&null!=o&&s>-1?(i&&(s+=n-1),this._getHeaderByIndex(s,o,r,l,a)):null},I.prototype._trimRangeForSelectionMode=function(e){return"row"===this.m_options.getSelectionMode()?this.createRange(this.createIndex(e.startIndex.row),this.createIndex(e.endIndex.row)):e},I.prototype.createRange=function(e,t,i,s){var n,o,r,l,a,h,d,c;return t&&(e.row<t.row||-1===t.row?(n=e.row,o=t.row,i&&(a=i.row,h=s.row)):(n=t.row,o=e.row,i&&(a=s.row,h=i.row)),isNaN(e.column)||isNaN(t.column)?(e={row:n},t={row:o},i&&(i={row:a,column:d},s={row:h,column:c})):(e.column<t.column||-1===t.column?(r=e.column,l=t.column,i&&(d=i.column,c=s.column)):(r=t.column,l=e.column,i&&(d=s.column,c=i.column)),e={row:n,column:r},t={row:o,column:l},i&&(i={row:a,column:d},s={row:h,column:c}))),i?{startIndex:e,endIndex:t,startKey:i,endKey:s}:{startIndex:e,endIndex:t}},I.prototype._createRangeWithKeys=function(e,t,i){this._keys(e,this._createRangeStartKeyCallback.bind(this,t,i))},I.prototype._createRangeStartKeyCallback=function(e,t,i,s){null!=e&&null!=s&&e.row===s.row&&e.column===s.column?this._createRangeEndKeyCallback(i,s,t,i,s):e?this._keys(e,this._createRangeEndKeyCallback.bind(this,i,s,t)):t.call(this,{startIndex:s,endIndex:s,startKey:i,endKey:i})},I.prototype._createRangeEndKeyCallback=function(e,t,i,s,n){i.call(this,this.createRange(t,n,e,s))},I.prototype.getEndIndex=function(e){return null==e.endIndex?e.startIndex:e.endIndex},I.prototype.getElementsInRange=function(e,t,i,s,n){var o,r,l,a,h;null==t&&(t=this.m_startRow),null==i&&(i=this.m_endRow+1);var d=e.startIndex,c=this.getEndIndex(e),m=d.row,u=c.row;if(-1===u&&(u=Number.MAX_VALUE),i<m||u<t)return null;if(!isNaN(d.column)&&!isNaN(c.column)&&(o=d.column,-1===(r=c.column)&&(r=Number.MAX_VALUE),this.m_endCol+1<o||r<this.m_startCol))return null;var _=[];if(null==this.m_databody.firstChild)return null;if(m=Math.max(this.m_startRow,m),u=Math.min(this.m_endRow,u),isNaN(o)||isNaN(r))for(o=Math.max(0,this.m_startCol),r=Math.max(o,this.m_endCol),l=m;l<=u;l+=1)for(a=o;a<=r;a+=1)null!=(h=this._getCellByIndex(this.createIndex(l,a)))&&-1===_.indexOf(h)&&_.push(h);else for(o=Math.max(this.m_startCol,o),r=Math.min(this.m_endCol,r),l=m;l<=u;l+=1)for(a=o;a<=r;a+=1)null!=(h=this._getCellByIndex(this.createIndex(l,a)))&&-1===_.indexOf(h)&&_.push(h);return _},I.prototype._getRangeInView=function(e){let t=e.startIndex,i=this.getEndIndex(e),s=t.row,n=i.row,o=t.column,r=i.column;return-1===n&&(n=Number.MAX_VALUE),-1===r&&(r=Number.MAX_VALUE),s=Math.max(this.m_startRow,s),n=Math.min(this.m_endRow,n),(isNaN(t.column)||isNaN(i.column))&&(o=Math.max(0,this.m_startCol),r=Math.max(o,this.m_endCol)),o=Math.max(this.m_startCol,o),r=Math.min(this.m_endCol,r),this.createRange(this.createIndex(s,o),this.createIndex(n,r))},I.prototype._applyBorderClassesAroundRange=function(e,t,i,s){if(null==this.m_databody.firstChild||null==e||0===e.length)return;let n=this._getRangeInView(t),o=n.startIndex.row,r=n.startIndex.column,l=n.endIndex.row,a=n.endIndex.column,h=0===o,d=0===r,c=h?0:o-1,m=l,u=d?0:r-1,_=a;for(let e=o;e<=l;e++){let t=this._getCellByIndex(this.createIndex(e,u)),n=this._getCellByIndex(this.createIndex(e,_)),o=(d?"start":"end")+s,r="end"+s;i?(this._highlightElement(t,[o]),this._highlightElement(n,[r])):(this._unhighlightElement(t,[o]),this._unhighlightElement(n,[r]))}for(let e=r;e<=a;e++){let t=this._getCellByIndex(this.createIndex(c,e)),n=this._getCellByIndex(this.createIndex(m,e)),o=(h?"top":"bottom")+s,r="bottom"+s;i?(this._highlightElement(t,[o]),this._highlightElement(n,[r])):(this._unhighlightElement(t,[o]),this._unhighlightElement(n,[r]))}},I.prototype.readCurrentContent=function(){var e,t;if(null==this.m_active)return!1;if("header"===this.m_active.type)e={},"row"===this.m_active.axis?(this.m_rowHeaderLevelCount>1&&(e.level=this.m_active.level),e.rowHeader=this.m_active.index):(this.m_columnHeaderLevelCount>1&&(e.level=this.m_active.level),e.columnHeader=this.m_active.index),t=this._getActiveElement();else if("cell"===this.m_active.type){if(e=this.m_active.indexes,this._isSelectionEnabled()&&this.isMultipleSelection()&&null!=this.m_selectionFrontier&&(e=this.m_selectionFrontier),null==e)return!1;var i=this.createRange(e),s=this.getElementsInRange(i);if(null==s||0===s.length)return!1;t=s[0]}else t=this._getActiveElement();this._updateActiveContext(this.m_active,this.m_prevActive),this.m_placeHolder.tabIndex=-1;var n=t.getAttribute("aria-labelledby");return this.m_placeHolder.setAttribute("aria-labelledby",n+" "+t.id),this.m_placeHolder===document.activeElement?t.focus():this.m_placeHolder.focus(),!0},I.prototype._enterActionableMode=function(e,t){return this._setFocusToFirstFocusableElement(e,t)&&(this.m_focusOutHandler(e),this.setActionableMode(!0)),!1},I.prototype._exitActionableMode=function(){if(this.isActionableMode()){var e=this._getActiveElement();this.setActionableMode(!1),c.disableAllFocusableElements(e),this.m_focusInHandler(e)}},I.prototype._reRenderCell=function(e,t,i,s){var n=this.getRendererOrTemplate("cell"),o=e[this.getResources().getMappedAttribute("context")],r=e[this.getResources().getMappedAttribute("metadata")];if(o.mode=t,this.m_utils.empty(e),this.m_utils.containsCSSClassName(e,i)?this.m_utils.removeCSSClassName(e,i):this.m_utils.addCSSClassName(e,i),s){for(;s.hasChildNodes();)e.appendChild(s.firstChild);this._destroyEditableClone()}else this._renderContent(n,o,e,o.data,this.buildCellTemplateContext(o,r))},I.prototype._setEditableClone=function(e){if(this._destroyEditableClone(),null!=e){var t=e.cloneNode(!1);t.removeAttribute("id"),this._createUniqueId(t),t[this.getResources().getMappedAttribute("context")]=e[this.getResources().getMappedAttribute("context")],t[this.getResources().getMappedAttribute("metadata")]=e[this.getResources().getMappedAttribute("metadata")],t[this.getResources().getMappedAttribute("context")].parentElement=t,this.m_root.appendChild(t),this._reRenderCell(t,"edit",this.getMappedStyle("cellEdit"),null),t.style.display="none",t[this.getResources().getMappedAttribute("context")].parentElement=e,this.m_editableClone=t}},I.prototype._destroyEditableClone=function(){this.m_editableClone&&(null!=this.m_editableClone.parentNode&&this.m_root.removeChild(this.m_editableClone),delete this.m_editableClone)},I.prototype.isArrowKey=function(e){return e===this.keyCodes.UP_KEY||e===this.keyCodes.DOWN_KEY||e===this.keyCodes.LEFT_KEY||e===this.keyCodes.RIGHT_KEY},I.prototype.createIndex=function(e,t){var i={};return void 0!==e&&(i.row=e),void 0!==t&&(i.column=t),i},I.prototype.checkCorners=function(e,t,i){return"column"===this.m_selectionFrontier.axis&&this.m_columnHeaderLevelCount!==this.m_selectionFrontier.level||"row"===this.m_selectionFrontier.axis&&this.m_rowHeaderLevelCount!==this.m_selectionFrontier.level||"rowEnd"===this.m_selectionFrontier.axis&&this.m_rowEndHeaderLevelCount!==this.m_selectionFrontier.level||"columnEnd"===this.m_selectionFrontier.axis&&this.m_columnEndHeaderLevelCount!==this.m_selectionFrontier.level||(-1!==e.indexOf("row")?t===i.startIndex.row&&this.m_selectionFrontier.end===i.endIndex.row||t===i.endIndex.row&&this.m_selectionFrontier.end===i.startIndex.row:-1!==e.indexOf("column")&&(t===i.startIndex.column&&this.m_selectionFrontier.end===i.endIndex.column||t===i.endIndex.column&&this.m_selectionFrontier.end===i.startIndex.column))},I.prototype.handleLabelFocusChange=function(e,t,i,s){var n,o,r,l,a;if(!this.isFetchComplete())return!0;this.getResources().isRTLMode()&&(e===this.keyCodes.LEFT_KEY?e=this.keyCodes.RIGHT_KEY:e===this.keyCodes.RIGHT_KEY&&(e=this.keyCodes.LEFT_KEY));var h=this.m_active.axis,d=this.m_active.level;switch("column"===h?(r=this.m_colHeader,l=this.m_startColHeader,a=this.m_columnHeaderLevelCount):"row"===h&&(r=this.m_rowHeader,l=this.m_startRowHeader,a=this.m_rowHeaderLevelCount),"columnEnd"===h&&(e===this.keyCodes.DOWN_KEY?e=this.keyCodes.UP_KEY:e===this.keyCodes.UP_KEY&&(e=this.keyCodes.DOWN_KEY),r=this.m_colEndHeader,l=this.m_startColEndHeader,a=this.m_columnEndHeaderLevelCount),"rowEnd"===h&&(e===this.keyCodes.LEFT_KEY?e=this.keyCodes.RIGHT_KEY:e===this.keyCodes.RIGHT_KEY&&(e=this.keyCodes.LEFT_KEY),r=this.m_rowEndHeader,l=this.m_startRowEndHeader,a=this.m_rowEndHeaderLevelCount),e){case this.keyCodes.DOWN_KEY:"row"!==h&&"rowEnd"!==h||(n=this._getHeaderByIndex(l,d,r,a,l),this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(n,{type:"header",index:l,level:d,axis:h},t)),"column"!==h&&"columnEnd"!==h||((n=this.m_headerLabels[h][d+1])?this._setActive(n,{type:"label",level:d+1,axis:h},t):"column"===h&&d===a-1&&this.m_headerLabels.row.length?(n=this.m_headerLabels.row[this.m_headerLabels.row.length-1],this._setActive(n,{type:"label",level:this.m_headerLabels.row.length-1,axis:"row"},t)):d===a-1&&(o="column"===h?this.m_startRowHeader:this.m_endRowHeader,n=this._getHeaderByIndex(o,this.m_rowHeaderLevelCount-1,this.m_rowHeader,this.m_rowHeaderLevelCount,this.m_startRowHeader),this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),n&&this._setActive(n,{type:"header",index:o,level:d,axis:"row"},t)));break;case this.keyCodes.UP_KEY:"row"===h&&d===a-1&&this.m_headerLabels.column.length&&(n=this.m_headerLabels.column[this.m_headerLabels.column.length-1],this._setActive(n,{type:"label",level:this.m_headerLabels.column.length-1,axis:"column"},t)),"column"!==h&&"columnEnd"!==h||(n=this.m_headerLabels[h][d-1])&&this._setActive(n,{type:"label",level:d-1,axis:h},t);break;case this.keyCodes.RIGHT_KEY:"row"!==h&&"rowEnd"!==h||((n=this.m_headerLabels[h][d+1])?this._setActive(n,{type:"label",level:d+1,axis:h},t):d===a-1&&(o="row"===h?this.m_startColHeader:this.m_endColHeader,(n=this._getHeaderByIndex(o,this.m_columnHeaderLevelCount,this.m_colHeader,this.m_columnHeaderLevelCount,this.m_startColHeader))&&(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(n,{type:"header",index:o,level:d,axis:"column"},t)))),"column"!==h&&"columnEnd"!==h||(n=this._getHeaderByIndex(l,d,r,a,l),this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(n,{type:"header",index:l,level:d,axis:h},t));break;case this.keyCodes.LEFT_KEY:"row"!==h&&"rowEnd"!==h||(n=this.m_headerLabels[h][d-1])&&this._setActive(n,{type:"label",level:d-1,axis:h},t)}return!0},I.prototype.handleHeaderFocusChange=function(e,t,i,s){var n,o,r,l,a,h,d,c,m;if(!this.isFetchComplete())return!0;this.getResources().isRTLMode()&&(e===this.keyCodes.LEFT_KEY?e=this.keyCodes.RIGHT_KEY:e===this.keyCodes.RIGHT_KEY&&(e=this.keyCodes.LEFT_KEY));var u=this.m_active.axis,_=this.m_active.index,p=this.m_active.level,g=this._getActiveElement(),f=null!=g?this._getAttribute(g,"depth",!0):1;if(u||_||!this.m_active||(u=this.m_selectionFrontier.axis,_=this.m_active.indexes[u]),t.shiftKey&&!i&&this.m_selectionFrontier&&this.isMultipleSelection()&&(i=this.checkHeaderToDatabody(u,e)),!(i&&this.isArrowKey(e)&&this.isHeaderSelectionType(this.m_selectionFrontier)&&this.checkCorners(u,_,this.m_selection[this.m_selection.length-1]))||(u=this.m_selectionFrontier.axis,_=this.m_selectionFrontier.index,p=this.m_selectionFrontier.level,-1===_&&(_=this.m_active.indexes[u]),"cell"!==this.m_active.type||(e!==this.keyCodes.LEFT_KEY&&e!==this.keyCodes.RIGHT_KEY||-1===u.indexOf("row"))&&(e!==this.keyCodes.UP_KEY&&e!==this.keyCodes.DOWN_KEY||-1===u.indexOf("column")))){switch("column"===u?(a=this.m_colHeader,h=this.m_startColHeader,d=this.m_endColHeader,c=this.m_columnHeaderLevelCount,m=this.m_stopColumnHeaderFetch):"row"===u&&(a=this.m_rowHeader,h=this.m_startRowHeader,d=this.m_endRowHeader,c=this.m_rowHeaderLevelCount,m=this.m_stopRowHeaderFetch),"columnEnd"===u&&(e===this.keyCodes.DOWN_KEY?e=this.keyCodes.UP_KEY:e===this.keyCodes.UP_KEY&&(e=this.keyCodes.DOWN_KEY),a=this.m_colEndHeader,h=this.m_startColEndHeader,d=this.m_endColEndHeader,c=this.m_columnEndHeaderLevelCount,m=this.m_stopColumnEndHeaderFetch),"rowEnd"===u&&(e===this.keyCodes.LEFT_KEY?e=this.keyCodes.RIGHT_KEY:e===this.keyCodes.RIGHT_KEY&&(e=this.keyCodes.LEFT_KEY),a=this.m_rowEndHeader,h=this.m_startRowEndHeader,d=this.m_endRowEndHeader,c=this.m_rowEndHeaderLevelCount,m=this.m_stopRowEndHeaderFetch),i&&this.isArrowKey(e)&&this.isHeaderSelectionType(this.m_selectionFrontier)&&(f=null!=(g=this._getHeaderByIndex(_,p,a,c,h))?this._getAttribute(g,"depth",!0):1),e){case this.keyCodes.LEFT_KEY:if("column"===u||"columnEnd"===u)if(_>0){if(s&&this.m_headerLabels[u][p]){this._setActive(this.m_headerLabels[u][p],{type:"label",level:p,axis:u},t);break}if("column"===u&&s&&this.m_headerLabels.row[this.m_rowHeaderLevelCount-1]){this._setActive(this.m_headerLabels.row[this.m_rowHeaderLevelCount-1],{type:"label",level:this.m_rowHeaderLevelCount-1,axis:"row"},t);break}if(1===c)r=_-1,o=null!=g?g.previousSibling:null,l=p;else if(r=null!=(o=this._getHeaderByIndex(_-1,p,a,c,h))?this._getAttribute(o.parentNode,"start",!0):_-1,l=null!=o?this.getHeaderCellLevel(o):p,r<0)break;i?this.extendSelectionHeader(o,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&"row"!==this.m_options.getSelectionMode()&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(o,{type:"header",index:r,level:l,axis:u},t),this._highlightActive())}else this.m_headerLabels[u][p]?this._setActive(this.m_headerLabels[u][p],{type:"label",level:p,axis:u},t):"column"===u&&this.m_headerLabels.row[this.m_rowHeaderLevelCount-1]&&this._setActive(this.m_headerLabels.row[this.m_rowHeaderLevelCount-1],{type:"label",level:this.m_rowHeaderLevelCount-1,axis:"row"},t);else("row"===u||"rowEnd"===u)&&p>0&&(o=this._getHeaderByIndex(_,p-1,a,c,h),r=this._getAttribute(o.parentNode,"start",!0),l=this.getHeaderCellLevel(o),i?this.extendSelectionHeader(o,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(o,{type:"header",index:r,level:l,axis:u},t),this._highlightActive()));break;case this.keyCodes.RIGHT_KEY:"rowEnd"===u&&s&&-1!==this.m_endRowHeader?(o=this._getHeaderByIndex(_,this.m_rowHeaderLevelCount,this.m_rowHeader,this.m_rowHeaderLevelCount,this.m_startRowHeader),i?this.extendSelectionHeader(o,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(o,{type:"header",index:_,level:this.m_rowHeaderLevelCount,axis:u},t),this._highlightActive())):"row"===u&&s&&-1!==this.m_endRowEndHeader?(o=this._getHeaderByIndex(_,this.m_rowEndHeaderLevelCount,this.m_rowEndHeader,this.m_rowEndHeaderLevelCount,this.m_startRowEndHeader),i?this.extendSelectionHeader(o,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(o,{type:"header",index:_,level:this.m_rowEndHeaderLevelCount,axis:u},t),this._highlightActive())):"row"===u||"rowEnd"===u?p+f>=c&&!i?(n="row"===u?this.createIndex(_,0):this._isHighWatermarkScrolling()?this.createIndex(_,this.m_endCol):this.createIndex(_,this.getDataSource().getCount("column")-1),this.m_trueIndex={row:_},this._isSelectionEnabled()?this.selectAndFocus(n,t):(this._setActiveByIndex(n,t),this._highlightActive())):(o=this._getHeaderByIndex(_,p+f,a,c,h),r=this._getAttribute(o.parentNode,"start",!0),l=this.getHeaderCellLevel(o),i?this.extendSelectionHeader(o,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(o,{type:"header",index:r,level:l,axis:u},t),this._highlightActive())):"column"===u&&s&&this.m_headerLabels.rowEnd[this.m_rowEndHeaderLevelCount-1]?this._setActive(this.m_headerLabels.rowEnd[this.m_rowEndHeaderLevelCount-1],{type:"label",level:this.m_rowEndHeaderLevelCount-1,axis:"rowEnd"},t):(1===c?(r=_+1,o=null!=g?g.nextSibling:null,l=p):(p===c-1?(r=_+1,o=this._getHeaderByIndex(r,p,a,c,h)):(r=null!=g?this._getAttribute(g.parentNode,"start",!0)+this._getAttribute(g.parentNode,"extent",!0):_+1,o=this._getHeaderByIndex(r,p,a,c,h)),l=null!=o?this.getHeaderCellLevel(o):p),r>d&&m||!(this._isCountUnknown("column")||r<this.getDataSource().getCount("column"))?"column"===u&&this.m_headerLabels.rowEnd[this.m_rowEndHeaderLevelCount-1]&&this._setActive(this.m_headerLabels.rowEnd[this.m_rowEndHeaderLevelCount-1],{type:"label",level:this.m_rowEndHeaderLevelCount-1,axis:"rowEnd"},t):i?this.extendSelectionHeader(o,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&"row"!==this.m_options.getSelectionMode()&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(o,{type:"header",index:r,level:l,axis:u},t),this._highlightActive()));break;case this.keyCodes.UP_KEY:if("row"===u||"rowEnd"===u){if(s&&this.m_headerLabels[u][p]){this._setActive(this.m_headerLabels[u][p],{type:"label",level:p,axis:u},t);break}if("row"===u&&s&&this.m_headerLabels.column[this.m_columnHeaderLevelCount-1]){this._setActive(this.m_headerLabels.column[this.m_columnHeaderLevelCount-1],{type:"label",level:this.m_columnHeaderLevelCount-1,axis:"column"},t);break}if(_>0){if(1===c)r=_-1,o=null!=g?g.previousSibling:null,l=p;else if(p===c-1?(r=_-1,o=this._getHeaderByIndex(r,p,a,c,h)):r=null!=(o=null!=g?this._getHeaderByIndex(this._getAttribute(g.parentNode,"start",!0)-1,p,a,c,h):null)?this._getAttribute(o.parentNode,"start",!0):_-1,l=null!=o?this.getHeaderCellLevel(o):p,r<0)break;i?this.extendSelectionHeader(o,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this.m_selectionFrontier={},this._clearSelection(t)),this._setActive(o,{type:"header",index:r,level:l,axis:u},t),this._highlightActive())}else this.m_headerLabels[u][p]?this._setActive(this.m_headerLabels[u][p],{type:"label",level:p,axis:u},t):"row"===u&&this.m_headerLabels.column[this.m_columnHeaderLevelCount-1]&&this._setActive(this.m_headerLabels.column[this.m_columnHeaderLevelCount-1],{type:"label",level:this.m_columnHeaderLevelCount-1,axis:"column"},t)}else("column"===u||"columnEnd"===u)&&p>0&&(o=this._getHeaderByIndex(_,p-1,a,c,h),r=this._getAttribute(o.parentNode,"start",!0),l=this.getHeaderCellLevel(o),i?this.extendSelectionHeader(o,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this.m_selectionFrontier={},this._clearSelection(t)),this._setActive(o,{type:"header",index:r,level:l,axis:u},t),this._highlightActive()));break;case this.keyCodes.DOWN_KEY:"columnEnd"===u&&s&&-1!==this.m_endColHeader?(o=this._getHeaderByIndex(_,this.m_columnHeaderLevelCount,this.m_colHeader,this.m_columnHeaderLevelCount,this.m_startColHeader),i?this.extendSelectionHeader(o,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this.m_selectionFrontier={},this._clearSelection(t)),this._setActive(o,{type:"header",index:_,level:this.m_columnHeaderLevelCount,axis:u},t),this._highlightActive())):"column"===u&&s&&-1!==this.m_endColEndHeader?(o=this._getHeaderByIndex(_,this.m_columnEndHeaderLevelCount,this.m_colEndHeader,this.m_columnEndHeaderLevelCount,this.m_startColEndHeader),i?this.extendSelectionHeader(o,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(o,{type:"header",index:_,level:this.m_columnEndHeaderLevelCount,axis:u},t),this._highlightActive())):"column"===u||"columnEnd"===u?p+f>=c&&!i?(n="column"===u?this.createIndex(0,_):this._isHighWatermarkScrolling()?this.createIndex(this.m_endRow,_):this.createIndex(this.getDataSource().getCount("row")-1,_),this.m_trueIndex={column:_},this._isSelectionEnabled()?this.selectAndFocus(n,t):(this._setActiveByIndex(n,t),this._highlightActive())):(o=this._getHeaderByIndex(_,p+f,a,c,h),r=this._getAttribute(o.parentNode,"start",!0),l=this.getHeaderCellLevel(o),i?this.extendSelectionHeader(o,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(o,{type:"header",index:r,level:l,axis:u},t),this._highlightActive())):"row"===u&&s&&this.m_headerLabels.columnEnd[this.m_columnEndHeaderLevelCount-1]?this._setActive(this.m_headerLabels.columnEnd[this.m_columnEndHeaderLevelCount-1],{type:"label",level:this.m_columnEndHeaderLevelCount-1,axis:"columnEnd"},t):(1===c?(r=_+1,o=null!=g?g.nextSibling:null,l=p):(p===c-1?(r=_+1,o=this._getHeaderByIndex(r,p,a,c,h)):(r=null!=g?this._getAttribute(g.parentNode,"start",!0)+this._getAttribute(g.parentNode,"extent",!0):_+1,o=this._getHeaderByIndex(r,p,a,c,h)),l=null!=o?this.getHeaderCellLevel(o):p),r>d&&m||!(this._isCountUnknown("row")||r<this.getDataSource().getCount("row"))?"row"===u&&this.m_headerLabels.columnEnd[this.m_columnEndHeaderLevelCount-1]&&this._setActive(this.m_headerLabels.columnEnd[this.m_rowEndHeaderLevelCount-1],{type:"label",level:this.m_columnEndHeaderLevelCount-1,axis:"columnEnd"},t):i?this.extendSelectionHeader(o,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(o,{type:"header",index:r,level:l,axis:u},t),this._highlightActive()));break;case this.keyCodes.PAGEUP_KEY:"row"!==u&&"rowEnd"!==u||(g=this._getHeaderByIndex(0,p,a,c,h),this._setActive(g,{type:"header",index:0,level:p,axis:u},t));break;case this.keyCodes.PAGEDOWN_KEY:"row"!==u&&"rowEnd"!==u||(_=this._isCountUnknown("row")||this._isHighWatermarkScrolling()?Math.max(0,d):Math.max(0,this.getDataSource().getCount("row")-1),g=this._getHeaderByIndex(_,p,a,c,h),this._setActive(g,{type:"header",index:_,level:p,axis:u},t));break;case this.keyCodes.HOME_KEY:"column"!==u&&"columnEnd"!==u||(g=this._getHeaderByIndex(0,p,a,c,h),this._setActive(g,{type:"header",index:0,level:p,axis:u},t));break;case this.keyCodes.END_KEY:"column"!==u&&"columnEnd"!==u||(_=this._isCountUnknown("column")||this._isHighWatermarkScrolling()?Math.max(0,d):Math.max(0,this.getDataSource().getCount("column")-1),g=this._getHeaderByIndex(_,p,a,c,h),this._setActive(g,{type:"header",index:_,level:p,axis:u},t))}return!0}},I.prototype.checkHeaderToDatabody=function(e,t){return!("row"===e&&this.m_rowHeaderLevelCount===this.m_selectionFrontier.level&&t===this.keyCodes.RIGHT_KEY||"rowEnd"===e&&this.m_rowEndHeaderLevelCount===this.m_selectionFrontier.level&&t===this.keyCodes.LEFT_KEY||"column"===e&&this.m_columnHeaderLevelCount===this.m_selectionFrontier.level&&t===this.keyCodes.DOWN_KEY||"columnEnd"===e&&this.m_columnEndHeaderLevelCount===this.m_selectionFrontier.level&&t===this.keyCodes.UP_KEY)},I.prototype._getHeaderLabelledBy=function(e,t,i,s,n,o,r,l){var a;if(-1!==n&&(o!==r||this.m_externalFocus)){var h=this.getHeaderFromCell(l,e);return null!=r&&(a=this._getHeaderByIndex(r,i-1,t,i,s)),this._getHeaderAndParentIds(h,a)}return""},I.prototype._getHeaderAndParentIds=function(e,t){var i="",s=[];if(null==e)return"";var n=this._getHeaderAndParents(e);null!=t&&(s=this._getHeaderAndParents(t));for(var o=0;o<n.length;o++)s[o]===n[o]&&o!==n.length-1||(i+=(""===i?"":" ")+n[o].id);return i},I.prototype._getHeaderAndParents=function(e){var t,i=[e],s=this.getHeaderCellAxis(e),n=this.getHeaderCellLevel(e),o=this._getLabel(s,n);if("row"===s?t=this.m_rowHeaderLevelCount:"column"===s?t=this.m_columnHeaderLevelCount:"rowEnd"===s?t=this.m_rowEndHeaderLevelCount:"columnEnd"===s&&(t=this.m_columnEndHeaderLevelCount),o&&i.unshift(o),1===t)return i;for(n===t-1&&(e=e.parentNode.firstChild,i.unshift(e),n-=1,(o=this._getLabel(s,n))&&i.unshift(o));n>0;)e=e.parentNode.parentNode.firstChild,i.unshift(e),n-=1,(o=this._getLabel(s,n))&&i.unshift(o);return i},I.prototype.isHeaderSelectionType=function(e){return!(!e||!e.axis)},I.prototype.handleFocusChange=function(e,t,i,s,n){var o,r,l,a=1,h=1;if(!this.isFetchComplete())return!0;if(t){if(o=this.m_selectionFrontier,this.isHeaderSelectionType(this.m_selectionFrontier))return void this.handleHeaderFocusChange(e,i,t,n)}else o=this.m_active.indexes;if(null!=o){null==this.m_trueIndex&&(this.m_trueIndex={}),this.getResources().isRTLMode()&&(e===this.keyCodes.LEFT_KEY?e=this.keyCodes.RIGHT_KEY:e===this.keyCodes.RIGHT_KEY&&(e=this.keyCodes.LEFT_KEY));var d=this._isSelectionEnabled()?this.selectAndFocus.bind(this):this._setActiveByIndex.bind(this),c=o.row,m=o.column,u=this._getCellByIndex(o);if(u){var _=u[this.getResources().getMappedAttribute("context")];a=_.extents.row,h=_.extents.column}switch(e){case this.keyCodes.LEFT_KEY:this.m_trueIndex.row||t||(this.m_trueIndex={row:c}),m>0&&(!n||-1===this.m_endRowHeader)?"row"===this.m_options.getSelectionMode()?(r=this.createIndex(this.m_trueIndex.row,m-1),this._setActiveByIndex(r,i)):(t?(r=this.createIndex(c,m-1),this.extendSelection(r,i,e)):d(r=this.createIndex(this.m_trueIndex.row,m-1),i),m-1==0&&this._setAccInfoText("accessibleFirstColumn")):!t&&s&&(l=this._getHeaderByIndex(this.m_trueIndex.row,this.m_rowHeaderLevelCount-1,this.m_rowHeader,this.m_rowHeaderLevelCount,this.m_startRowHeader),this.m_discontiguousSelection?this.discontiguousHeaderSetActiveFromDatabody(i,"row",l,this.m_rowHeaderLevelCount):this._setActive(l,{type:"header",index:this.m_trueIndex.row,level:this.m_rowHeaderLevelCount-1,axis:"row"},i,!0));break;case this.keyCodes.RIGHT_KEY:this.m_trueIndex.row||t||(this.m_trueIndex={row:c}),this._isLastColumn(m+(h-1))||n&&-1!==this.m_endRowEndHeader?-1!==this.m_endRowEndHeader&&s?(l=this._getHeaderByIndex(this.m_trueIndex.row,this.m_rowEndHeaderLevelCount-1,this.m_rowEndHeader,this.m_rowEndHeaderLevelCount,this.m_startRowEndHeader),this.m_discontiguousSelection?this.discontiguousHeaderSetActiveFromDatabody(i,"rowEnd",l,this.m_rowEndHeaderLevelCount):this._setActive(l,{type:"header",index:this.m_trueIndex.row,level:this.m_rowEndHeaderLevelCount-1,axis:"rowEnd"},i,!0)):t||d(o,i):"row"===this.m_options.getSelectionMode()?(r=this.createIndex(this.m_trueIndex.row,m+h),this._setActiveByIndex(r,i)):(t?(r=this.createIndex(c,m+1),this.extendSelection(r,i,e)):d(r=this.createIndex(this.m_trueIndex.row,m+h),i),this._isLastColumn(m+h)&&this._setAccInfoText("accessibleLastColumn"));break;case this.keyCodes.UP_KEY:this.m_trueIndex.column||t||(this.m_trueIndex={column:m}),c>0&&(!n||-1===this.m_endColHeader)?(t?(r=this.createIndex(c-1,m),this.extendSelection(r,i,e)):d(r=this.createIndex(c-1,this.m_trueIndex.column),i),c-1==0&&this._setAccInfoText("accessibleFirstRow")):!t&&s&&(l=this._getHeaderByIndex(this.m_trueIndex.column,this.m_columnHeaderLevelCount-1,this.m_colHeader,this.m_columnHeaderLevelCount,this.m_startColHeader),this.m_discontiguousSelection?this.discontiguousHeaderSetActiveFromDatabody(i,"column",l,this.m_columnHeaderLevelCount):this._setActive(l,{type:"header",index:this.m_trueIndex.column,level:this.m_columnHeaderLevelCount-1,axis:"column"},i,!0));break;case this.keyCodes.DOWN_KEY:this.m_trueIndex.column||t||(this.m_trueIndex={column:m}),this._isLastRow(c+(a-1))||n&&-1!==this.m_endColEndHeader?-1!==this.m_endColEndHeader&&s?(l=this._getHeaderByIndex(this.m_trueIndex.column,this.m_columnEndHeaderLevelCount-1,this.m_colEndHeader,this.m_columnEndHeaderLevelCount,this.m_startColEndHeader),this.m_discontiguousSelection?this.discontiguousHeaderSetActiveFromDatabody(i,"columnEnd",l,this.m_columnEndHeaderLevelCount):this._setActive(l,{type:"header",index:this.m_trueIndex.column,level:this.m_columnEndHeaderLevelCount-1,axis:"columnEnd"},i,!0)):t||d(o,i):(t?(r=this.createIndex(c+1,m),this.extendSelection(r,i,e)):d(r=this.createIndex(c+a,this.m_trueIndex.column),i),this._isLastRow(c+a)&&this._setAccInfoText("accessibleLastRow"));break;case this.keyCodes.HOME_KEY:this.m_trueIndex.row||(this.m_trueIndex={row:c}),d(r=this.createIndex(this.m_trueIndex.row,0),i);break;case this.keyCodes.END_KEY:this.m_trueIndex.row||(this.m_trueIndex={row:c}),d(r=this._isCountUnknown("column")||this._isHighWatermarkScrolling()?this.createIndex(this.m_trueIndex.row,Math.max(0,this.m_endCol)):this.createIndex(this.m_trueIndex.row,Math.max(0,this.getDataSource().getCount("column")-1)),i);break;case this.keyCodes.PAGEUP_KEY:this.m_trueIndex.column||(this.m_trueIndex={column:m}),d(r=this.createIndex(0,m),i);break;case this.keyCodes.PAGEDOWN_KEY:this.m_trueIndex.column||(this.m_trueIndex={column:m}),d(r=this._isCountUnknown("column")||this._isHighWatermarkScrolling()?this.createIndex(Math.max(0,this.m_endRow),this.m_trueIndex.column):this.createIndex(Math.max(0,this.getDataSource().getCount("row")-1),this.m_trueIndex.column),i)}return!0}},I.prototype.scrollToIndex=function(e,t,i){var s,n,o=e.row,r=e.column;t&&(this.m_shouldFocus=!1),i&&(e.scrollToOrigin=!0);var l=this.getResources().isRTLMode()?"right":"left",a=0,h=0,d=this._getViewportTop(),c=this._getViewportBottom(),m=this._getViewportLeft(),u=this._getViewportRight();if(o<this.m_startRow||o>this.m_endRow){var _;_=o<this.m_startRow?this.m_avgRowHeight*o:this.m_avgRowHeight*(o+1)-c+d,h=this.m_currentScrollTop-_,this.m_scrollIndexAfterFetch=e,s=!0}else{var p;null===(n=this._getCellByIndex(e))?(n=this._getFirstCellWithMatchingStartIndex(o,"row"),p=this.m_sizingManager.getSize("row",this._getKey(n,"row"))):p=this.getElementHeight(n);var g=this.getElementDir(n,"top");i||e.scrollToOrigin?h=d-g:g+p>c?h=c-(g+p):g<d&&(h=d-g)}if(!isNaN(r)&&!0!==s)if(r<this.m_startCol||r>this.m_endCol){var f;f=r<this.m_startCol?this.m_avgColWidth*r:this.m_avgColWidth*(r+1)-u+m,a=this.m_currentScrollLeft-f,this.m_scrollIndexAfterFetch=e}else{var C;null===(n=this._getCellByIndex(e))?(n=this._getFirstCellWithMatchingStartIndex(r,"column"),C=this.m_sizingManager.getSize("column",this._getKey(n,"column"))):C=this.getElementWidth(n);var y=this.getElementDir(n,l);i||e.scrollToOrigin||y<m?a=m-y:y+C>u&&(a=u-(y+C))}0!==a||0!==h?(null!=(n=this._getCellByIndex(e))&&!0!==t&&!1!==this.m_shouldFocus&&(this.m_cellToFocus=n),this.scrollDelta(a,h)):null!=this.m_scrollIndexAfterFetch&&(t||!1===this.m_shouldFocus||this._setActiveByIndex(this.m_scrollIndexAfterFetch,null,!1,!1,!0))&&(this.m_scrollIndexAfterFetch=null)},I.prototype.scrollToHeader=function(e){var t,i,s,n,o,r,l,a,h,d=e.axis,c=e.index,m=e.level,u=0;"row"===d?(t=this.m_startRowHeader,i=this.m_endRowHeader,s=this.m_avgRowHeight,n=this.m_currentScrollTop,a=this._getViewportTop(),h=this._getViewportBottom()):"column"===d?(t=this.m_startColHeader,i=this.m_endColHeader,s=this.m_avgColWidth,n=this.m_currentScrollLeft,a=this._getViewportLeft(),h=this._getViewportRight()):"rowEnd"===d?(t=this.m_startRowEndHeader,i=this.m_endRowEndHeader,s=this.m_avgRowHeight,n=this.m_currentScrollTop,a=this._getViewportTop(),h=this._getViewportBottom()):"columnEnd"===d&&(t=this.m_startColEndHeader,i=this.m_endColEndHeader,s=this.m_avgColWidth,n=this.m_currentScrollLeft,a=this._getViewportLeft(),h=this._getViewportRight());var _=h-a;c<t||c>i?(u=n-(c<t?s*c:s*(c+1)-_),this.m_scrollHeaderAfterFetch=e):("row"===d||"rowEnd"===d?(l="row"===d?this._getHeaderByIndex(c,m,this.m_rowHeader,this.m_rowHeaderLevelCount,this.m_startRowHeader):this._getHeaderByIndex(c,m,this.m_rowEndHeader,this.m_rowEndHeaderLevelCount,this.m_startRowEndHeader),o=this.getElementDir(l,"top"),r=this.getElementHeight(l)):"column"!==d&&"columnEnd"!==d||(l="column"===d?this._getHeaderByIndex(c,m,this.m_colHeader,this.m_columnHeaderLevelCount,this.m_startColHeader):this._getHeaderByIndex(c,m,this.m_colEndHeader,this.m_columnEndHeaderLevelCount,this.m_startColEndHeader),o=this.getElementDir(l,this.getResources().isRTLMode()?"right":"left"),r=this.getElementWidth(l)),_>r?o+r>h?u=h-(o+r):o<a&&(u=a-o):u=a-o),0!==u?(null!=l&&!1!==this.m_shouldFocus&&(this.m_cellToFocus=l),"row"===d||"rowEnd"===d?this.scrollDelta(0,u):this.scrollDelta(u,0)):null!=this.m_scrollHeaderAfterFetch&&(this._updateActive(e,!0,!0),this.m_scrollHeaderAfterFetch=null)},I.prototype.findHeader=function(e,t,i){if(null==t&&(t=this.getMappedStyle("headercell")),null==i&&(i=this.getMappedStyle("endheadercell")),null!=t){if(this.m_utils.containsCSSClassName(e,t)||this.m_utils.containsCSSClassName(e,i))return e;if(e.parentNode)return this.findHeader(e.parentNode,t,i);if(e===this.m_root)return null}return null},I.prototype.updateRowBanding=function(){var e=this.m_options.getRowBandingInterval();if(e>0)for(var t=this.m_databody.firstChild.childNodes,i=this.getMappedStyle("banded"),s=0;s<t.length;s++){var n=t[s],o=this._getIndex(n,"row");Math.floor(o/e)%2==1?this.m_utils.containsCSSClassName(n,i)||this.m_utils.addCSSClassName(n,i):this.m_utils.containsCSSClassName(n,i)&&this.m_utils.removeCSSClassName(n,i)}},I.prototype.updateColumnBanding=function(){var e=this.m_options.getColumnBandingInterval();if(e>0)for(var t=this.m_databody.firstChild.childNodes,i=this.getMappedStyle("banded"),s=0;s<t.length;s+=1){var n=t[s],o=this._getIndex(n,"column");Math.floor(o/e)%2==1?this.m_utils.containsCSSClassName(n,i)||this.m_utils.addCSSClassName(n,i):this.m_utils.containsCSSClassName(n,i)&&this.m_utils.removeCSSClassName(n,i)}},I.prototype._removeBanding=function(){for(var e=this.m_databody.firstChild.childNodes,t=this.getMappedStyle("banded"),i=0;i<e.length;i++)this.m_utils.containsCSSClassName(e[i],t)&&this.m_utils.removeCSSClassName(e[i],t)},I.prototype._setAccInfoText=function(e,t){var i=this.getResources().getTranslatedText(e,t);null!=i&&(this.m_accInfo.textContent=i)},I.prototype.handleExpandEvent=function(e,t){void 0===t&&this.queueModelEvent(e)?e.operation="expand":(this._setAccInfoText("accessibleRowExpanded"),this.populateAccInfo(),t&&this._runModelEventQueue())},I.prototype.handleCollapseEvent=function(e,t){void 0===t&&this.queueModelEvent(e)?e.operation="collapse":(this._setAccInfoText("accessibleRowCollapsed"),this.populateAccInfo(),t&&this._runModelEventQueue())},I.prototype._getKey=function(e,t){return null!=e&&e[this.getResources().getMappedAttribute("context")]?null!=t&&this.m_utils.containsCSSClassName(e,this.getMappedStyle("cell"))?e[this.getResources().getMappedAttribute("context")].keys[t]:e[this.getResources().getMappedAttribute("context")].key:null},I.prototype._getActiveKey=function(e,t){if(t&&null!=this.m_prevActive){if("header"===this.m_prevActive.type&&(this.m_prevActive.axis===e||this.m_prevActive.axis===e+"End"))return this.m_prevActive.key;if("cell"===this.m_prevActive.type)return this.m_prevActive.keys[e]}else if(null!=this.m_active){if("header"===this.m_active.type&&(this.m_active.axis===e||this.m_active.axis===e+"End"))return this.m_active.key;if("cell"===this.m_active.type)return this.m_active.keys[e]}return null},I.prototype._handleCut=function(e,t){null==t&&(t=e.target);var i=this.findCellOrHeader(t);if(this._isMoveOnElementEnabled(i)){if(null!=this.m_cutCells)for(var s=0;s<this.m_cutCells.length;s++)this.m_utils.removeCSSClassName(this.m_cutCells[s],this.getMappedStyle("cut"));var n=this._getKey(i,"row");return this.m_cutCells=this._getAxisCellsByKey(n,"row"),this.m_cutRowHeader=this._findHeaderByKey(n,this.m_rowHeader,this.getMappedStyle("rowheadercell")),this.m_cutRowEndHeader=this._findHeaderByKey(n,this.m_rowEndHeader,this.getMappedStyle("rowendheadercell")),this._highlightCellsAlongAxis(n,"row","key","add",["cut"]),null!==this.m_cutRowHeader&&this.m_utils.addCSSClassName(this.m_cutRowHeader,this.getMappedStyle("cut")),null!==this.m_cutRowEndHeader&&this.m_utils.addCSSClassName(this.m_cutRowEndHeader,this.getMappedStyle("cut")),!0}return!1},I.prototype._handleCutCells=function(e,t){if(null==t&&(t=e.target),this._isDataGridProvider()&&this._isSelectionEnabled()&&this.m_options.isCutEnabled()){this.m_selectionRange&&this.m_selectionRange.length&&this.unhighlightFloodFillRange(this.m_selectionRange[0]);let t=this.m_selection[this.m_selection.length-1];this.m_selectionRange=[t],this.m_dataTransferAction="cut";var i={event:e,ui:{action:this.m_dataTransferAction,sourceRange:this.m_selectionRange[0]}};if(!this.fireEvent("cutRequest",i))return!0;this.highlightFloodFillRange(t),this.m_options.isFloodFillEnabled()&&this._removeFloodFillAffordance()}return!0},I.prototype._handleCopyCells=function(e,t){if(null==t&&(t=e.target),this._isDataGridProvider()&&this._isSelectionEnabled()&&this.m_options.isCopyEnabled()){this.m_selectionRange&&this.m_selectionRange.length&&this.unhighlightFloodFillRange(this.m_selectionRange[0]);let t=this.m_selection[this.m_selection.length-1];this.m_selectionRange=[t],this.m_dataTransferAction="copy";let i={event:e,ui:{action:this.m_dataTransferAction,sourceRange:this.m_selectionRange[0]}};return!this.fireEvent("copyRequest",i)||(this.highlightFloodFillRange(t),this.m_options.isFloodFillEnabled()&&this._removeFloodFillAffordance(),!0)}return!1},I.prototype._handlePaste=function(e,t){if(null==t&&(t=e.target),null!=this.m_cutCells){for(var i=0;i<this.m_cutCells.length;i++)this.m_utils.removeCSSClassName(this.m_cutCells[i],this.getMappedStyle("cut"));null!==this.m_cutRowHeader&&(this.m_utils.removeCSSClassName(this.m_cutRowHeader,this.getMappedStyle("cut")),this.m_cutRowHeader=null),null!==this.m_cutRowEndHeader&&(this.m_utils.removeCSSClassName(this.m_cutRowEndHeader,this.getMappedStyle("cut")),this.m_cutRowEndHeader=null);var s=this._getKey(this.findCellOrHeader(t),"row"),n=this._getKey(this.m_cutCells[0],"row");n!==s&&(this._isSelectionEnabled()&&this._clearSelection(e),this._isDatabodyCellActive()&&this._unhighlightActive(),this.m_moveActive=!0,this.getDataSource().move(n,s)),this.m_cutCells=null}return!0},I.prototype._handlePasteCells=function(e,t){if(null==t&&(t=e.target),this._isDataGridProvider()&&this.m_options.isPasteEnabled())if(this.m_selectionRange&&this._isSelectionEnabled()&&!this.m_discontiguousSelection&&1===this.m_selection.length){let t={event:e,ui:{action:this.m_dataTransferAction,sourceRange:this.m_selectionRange[0],targetRange:this.m_selection[0]}};if(!this.fireEvent("pasteRequest",t))return!0;this.unhighlightFloodFillRange(this.m_selectionRange[0]),this.m_selectionRange=null,this.m_dataTransferAction=null}else if(!this.m_selectionRange){let t={event:e,ui:{action:"unknown",sourceRange:{},targetRange:this.m_selection[0]}};if(!this.fireEvent("pasteRequest",t))return!0;this.m_selectionRange=null,this.m_dataTransferAction=null}return!0},I.prototype._handleAutofill=function(e,t){if(null==t&&(t=e.target),this._isDataGridProvider()&&this._isSelectionEnabled()&&!this.m_discontiguousSelection&&this.m_options.isFloodFillEnabled()&&1===this.m_selection.length){let t="down";"keydown"===e.type&&(t="d"===e.key?"down":"end");let s=this.m_selection[0].startIndex,n=this.m_selection[0].endIndex,o=this.createRange(s,n),r=this.createRange(s,n),l=!1;if("down"===t?(o.endIndex.row=o.startIndex.row,r.startIndex.row=o.startIndex.row+1,r.startIndex.row>=o.startIndex.row&&r.startIndex.row<=r.endIndex.row&&(l=!0)):(o.endIndex.column=o.startIndex.column,r.startIndex.column=o.startIndex.column+1,r.startIndex.column>=o.startIndex.column&&r.startIndex.column<=r.endIndex.column&&(l=!0)),l){var i={event:e,ui:{action:t,sourceRange:o,targetRange:r}};if(!this.fireEvent("fillRequest",i))return!0}return this.unhighlightFloodFillRange(this.m_selection[0]),this._removeFloodFillAffordance(),this.m_selectionRange=null,this.m_dataTransferAction=null,this.m_floodFillDirection=null,!0}return!1},I.prototype._handleCancelReorder=function(e,t){if(null!=this.m_cutCells){for(var i=0;i<this.m_cutCells.length;i++)this.m_utils.removeCSSClassName(this.m_cutCells[i],this.getMappedStyle("cut"));return this.m_cutCells=null,null!==this.m_cutRowHeader&&(this.m_utils.removeCSSClassName(this.m_cutRowHeader,this.getMappedStyle("cut")),this.m_cutRowHeader=null),null!==this.m_cutRowEndHeader&&(this.m_utils.removeCSSClassName(this.m_cutRowEndHeader,this.getMappedStyle("cut")),this.m_cutRowEndHeader=null),!0}null!==this.m_dataTransferAction&&(this.unhighlightFloodFillRange(this.m_selectionRange[0]),this.m_selectionRange=null,this.m_dataTransferAction=null)},I.prototype._handleMove=function(e){if(null==this.m_moveCells){var t=e.target,i=this.findCellOrHeader(t),s=this._getKey(i,"row");this.m_originalMoveIndex=this._getIndex(i,"row"),this.m_moveIndex=this.m_originalMoveIndex,this.m_moveCells=this._getAxisCellsByIndex(this.m_moveIndex,"row"),this.m_moveRowHeader=this._findHeaderByKey(s,this.m_rowHeader,this.getMappedStyle("rowheadercell")),this.m_moveRowEndHeader=this._findHeaderByKey(s,this.m_rowEndHeader,this.getMappedStyle("rowendheadercell")),this._highlightCellsAlongAxis(this.m_moveIndex,"row","index","add",["drag"]),this.m_originalTop=this.getElementDir(this.m_moveCells[0],"top"),this.m_dropTarget=document.createElement("div"),this.m_utils.addCSSClassName(this.m_dropTarget,this.getMappedStyle("drop")),this.setElementHeight(this.m_dropTarget,this.calculateRowHeight(this.m_moveCells[0])),this.setElementDir(this.m_dropTarget,this.m_originalTop,"top"),this.m_databody.firstChild.appendChild(this.m_dropTarget),this._addHeaderDropTarget(this.m_moveRowHeader,this.m_rowHeader,!1),this._addHeaderDropTarget(this.m_moveRowEndHeader,this.m_rowEndHeader,!0)}this.m_utils.isTouchDevice()||(this.m_prevY=this.m_currentY,this.m_currentY=e.pageY);for(var n=this.m_currentY-this.m_prevY,o=this.calculateRowHeight(this.m_moveCells[0]),r=0;r<this.m_moveCells.length;r++)this.setElementDir(this.m_moveCells[r],this.getElementDir(this.m_moveCells[r],"top")+n,"top");null!==this.m_moveRowHeader&&this.setElementDir(this.m_moveRowHeader,this.getElementDir(this.m_moveRowHeader,"top")+n,"top"),null!==this.m_moveRowEndHeader&&this.setElementDir(this.m_moveRowEndHeader,this.getElementDir(this.m_moveRowEndHeader,"top")+n,"top");var l=this.m_moveIndex+1,a=this.m_moveIndex-1,h=this._getCellByIndex(this.createIndex(l,this.m_startCol)),d=this._getCellByIndex(this.createIndex(a,this.m_startCol));null!=h&&this.getElementDir(h,"top")<this.getElementDir(this.m_moveCells[0],"top")+o/2?this._moveDropRows("nextSibling",l):null!=d&&this.getElementDir(d,"top")>this.getElementDir(this.m_moveCells[0],"top")-o/2&&this._moveDropRows("previousSibling",a)},I.prototype._addHeaderDropTarget=function(e,t,i){var s;null!==e&&(null==e.style.height&&this.setElementHeight(e,this.calculateRowHeight(e)),this.m_utils.addCSSClassName(e,this.getMappedStyle("drag")),s=document.createElement("div"),this.m_utils.addCSSClassName(s,this.getMappedStyle("drop")),this.setElementHeight(s,this.calculateRowHeight(e)),this.setElementDir(s,this.m_originalTop,"top"),t.firstChild.appendChild(s),i?this.m_dropTargetEndHeader=s:this.m_dropTargetHeader=s)},I.prototype._moveDropRows=function(e,t){var i,s,n,o,r;"nextSibling"===e?(r=this._getAxisCellsByIndex(t,"row"),i=this.m_originalTop+this.calculateRowHeight(r[0]),s=this.m_originalTop):(r=this._getAxisCellsByIndex(t,"row"),s=(i=this.getElementDir(r[0],"top"))+this.calculateRowHeight(r[0])),this.setElementDir(this.m_dropTarget,i,"top");for(var l=0;l<r.length;l++)this.setElementDir(r[l],s,"top");null!==this.m_moveRowHeader&&(n=this.m_moveRowHeader.parentNode,this.setElementDir(this.m_dropTargetHeader,i,"top"),this.setElementDir(this.m_moveRowHeader[e],s,"top")),null!==this.m_moveRowEndHeader&&(o=this.m_moveRowEndHeader.parentNode,this.setElementDir(this.m_dropTargetEndHeader,i,"top"),this.setElementDir(this.m_moveRowEndHeader[e],s,"top")),this.m_originalTop=i,this._highlightCellsAlongAxis(this.m_moveIndex+1,"row","index","remove",["activedrop"]),"nextSibling"===e?(this._modifyAxisCellContextIndex("row",this.m_moveIndex,1,1),this._modifyAxisCellContextIndex("row",this.m_moveIndex+1,1,-1),this.m_moveIndex+=1,null!==this.m_moveRowHeader&&n&&n.insertBefore(this.m_moveRowHeader,this.m_moveRowHeader[e][e]),null!==this.m_moveRowEndHeader&&o&&o.insertBefore(this.m_moveRowEndHeader,this.m_moveRowEndHeader[e][e])):(this._modifyAxisCellContextIndex("row",this.m_moveIndex,1,-1),this._modifyAxisCellContextIndex("row",this.m_moveIndex-1,1,1),this.m_moveIndex-=1,null!==this.m_moveRowHeader&&n&&n.insertBefore(this.m_moveRowHeader,this.m_moveRowHeader[e]),null!==this.m_moveRowEndHeader&&o&&o.insertBefore(this.m_moveRowEndHeader,this.m_moveRowEndHeader[e])),this._refreshDatabodyMap(),this._highlightCellsAlongAxis(this.m_moveIndex+1,"row","index","add",["activedrop"])},I.prototype._isMoveEnabled=function(e){var t=this.getDataSource().getCapability("move");return"enable"===this.m_options.isMoveable("row")&&("full"===t||t===e)},I.prototype._handleMoveMouseUp=function(e,t){if(null!=this.m_moveCells){this._remove(this.m_dropTarget),null!==this.m_moveRowHeader&&this._remove(this.m_dropTargetHeader),null!==this.m_moveRowEndHeader&&this._remove(this.m_dropTargetEndHeader),null!=this.m_active&&"column"!==this.m_active.axis&&(this.m_moveActive=!0),this._isSelectionEnabled()&&this._clearSelection(e);var i=this.m_moveCells[0],s=this._getKey(i,"row");if(!0===t){var n=this.m_moveIndex+1,o=this._getKey(this._getCellByIndex(this.createIndex(n,this.m_startCol)),"row");this.getDataSource().move(s,o)}else this.getDataSource().move(s,s);this.m_moveCells=null,this.m_originalMoveIndex=null,this.m_moveIndex=null}this.m_databodyMove=!1},I.prototype._handleFloodFillMouseUp=function(e){if(this.m_floodFillRange&&this.m_floodFillRange.length){var t={event:e,ui:{action:this.m_floodFillDirection,sourceRange:this.m_selectionRange[0],targetRange:this.m_floodFillRange[0]}};if(!this.fireEvent("fillRequest",t))return!0;this.unhighlightFloodFillRange()}return this.m_selectionRange=null,this.m_floodFillRange=null,this.m_floodFillDirection=null,this.m_databody&&(this.m_databody.style.cursor="default"),this.m_cursor="default",!0},I.prototype._isMoveOnElementEnabled=function(e){return!(null==e||!this._isMoveEnabled("row")||this._getActiveKey("row")!==this._getKey(e,"row"))},I.prototype._manageMoveCursor=function(){var e=this._getActiveKey("row"),t=this._getActiveKey("row",!0),i=this.getMappedStyle("draggable"),s=this.getMappedStyle("rowheadercell"),n=this.getMappedStyle("rowendheadercell");if(null!=t){this._highlightCellsAlongAxis(t,"row","key","remove",["draggable"]);var o=this._findHeaderByKey(t,this.m_rowHeader,s);this.m_utils.containsCSSClassName(o,i)&&this.m_utils.removeCSSClassName(o,i),o=this._findHeaderByKey(t,this.m_rowEndHeader,n),this.m_utils.containsCSSClassName(o,i)&&this.m_utils.removeCSSClassName(o,i)}if(null!=e){var r=this._getAxisCellsByKey(e,"row");if(this._isMoveOnElementEnabled(r[0])){this._highlightCellsAlongAxis(e,"row","key","add",["draggable"]);var l=this._findHeaderByKey(e,this.m_rowHeader,s);this.m_utils.addCSSClassName(l,i);var a=this._findHeaderByKey(e,this.m_rowEndHeader,n);this.m_utils.addCSSClassName(a,i)}}},I.prototype.handleRootFocus=function(e,t){if(this.m_utils.addCSSClassName(this.m_root,this.getMappedStyle("focus")),this._clearFocusoutTimeout(),this._clearFocusoutBusyState(),!t){if(this._clearOpenPopupListeners(),!this.m_root.contains(document.activeElement)||document.activeElement===this.m_root&&0===this.m_root.tabIndex||document.activeElement===this.m_databody&&this.m_scrollbarFocus&&0===this.m_root.tabIndex){this.m_externalFocus=!0,this._isCellEditable()?this._setAccInfoText("accessibleEditableMode"):this._isGridEditable()&&this._setAccInfoText("accessibleNavigationMode");var i=!1;if(!0===this.m_scrollbarFocus&&(this.m_shouldFocus=!1,this.m_scrollbarFocus=!1,i=!0),null!=this.m_active||this._databodyEmpty())null!=this.m_active&&this._highlightActive();else{var s=this.createIndex(0,0);i||this.scrollToIndex(s),this._setActiveByIndex(s,e,null,null,i)}}this.m_root.tabIndex=-1}},I.prototype._handlePopupFocusout=function(e){this.handleRootBlur(e,!0)},I.prototype._handlePopupFocusin=function(e){this.handleRootFocus(e,!0)},I.prototype.handleRootBlur=function(e,t){if(this._clearFocusoutTimeout(),!t){this._clearOpenPopupListeners();var i=p.getLogicalChildPopup(this.m_root);if(null!=i)return this._openPopup=i,t=!1,this._handlePopupFocusinListener=this._handlePopupFocusin.bind(this),this._handlePopupFocusoutListener=this._handlePopupFocusout.bind(this),i.addEventListener("focusin",this._handlePopupFocusinListener),void i.addEventListener("focusout",this._handlePopupFocusoutListener)}this._setFocusoutBusyState(),this.m_focusoutTimeout=setTimeout(function(){if(!this.m_root.contains(document.activeElement)||!0===t){this.m_root.tabIndex=0;var i=this._getActiveElement();null!=i&&(this._unsetAriaProperties(i),this._isEditOrEnter()&&this._leaveEditing(e,i,!1,!1))}this._clearFocusoutBusyState()}.bind(this),100),null==this.m_moveRow&&this.m_utils.removeCSSClassName(this.m_root,this.getMappedStyle("focus"))},I.prototype._clearOpenPopupListeners=function(){null!=this._openPopup&&(this._openPopup.removeEventListener("focusin",this._handlePopupFocusinListener),this._openPopup.removeEventListener("focusout",this._handlePopupFocusoutListener),this._openPopup=null),this._handlePopupFocusinListener=null,this._handlePopupFocusoutListener=null},I.prototype._handlePopupFocusout=function(e){this.handleRootBlur(e,!0)},I.prototype._handlePopupFocusin=function(e){this.handleRootFocus(e,!0)},I.prototype._clearFocusoutTimeout=function(){this.m_focusoutTimeout&&(clearTimeout(this.m_focusoutTimeout),this.m_focusoutTimeout=null)},I.prototype._setFocusoutBusyState=function(){if(!this.m_focusoutResolveFunc){var e=d.getContext(this.m_root).getBusyContext(),t={description:"Datagrid component 'is handling focusout."};this.m_focusoutResolveFunc=e.addBusyState(t)}},I.prototype._clearFocusoutBusyState=function(){this.m_focusoutResolveFunc&&(this.m_focusoutResolveFunc(),this.m_focusoutResolveFunc=null)},I.prototype.calculateRowHeight=function(e){return""!==e.style.height?this.getElementHeight(e):null!=e.nextSibling?this.getElementDir(e.nextSibling,"top")-this.getElementDir(e,"top"):this.m_endRowPixel-this.getElementDir(e,"top")},I.prototype.calculateRowHeaderHeight=function(e){return""!==e.style.height?this.getElementHeight(e):null!=e.nextSibling?this.getElementDir(e.nextSibling,"top")-this.getElementDir(e,"top"):this.m_endRowHeaderPixel-this.getElementDir(e,"top")},I.prototype.calculateRowHeaderLabelHeight=function(e){return this.getElementHeight(e)},I.prototype.calculateColumnWidth=function(e){if(""!==e.style.width)return this.getElementWidth(e);var t=this.getResources().isRTLMode()?"right":"left";return null!=e.nextSibling?this.getElementDir(e.nextSibling,t)-this.getElementDir(e,t):this.m_endColPixel-this.getElementDir(e,t)},I.prototype.calculateColumnHeaderWidth=function(e){if(""!==e.style.width)return this.getElementWidth(e);var t=this.getResources().isRTLMode()?"right":"left";return null!=e.nextSibling?this.getElementDir(e.nextSibling,t)-this.getElementDir(e,t):this.m_endColHeaderPixel-this.getElementDir(e,t)},I.prototype._databodyEmpty=function(){return null==this.m_databody.firstChild||null==this.m_databody.firstChild.firstChild},I.prototype.changeStyleProperty=function(e,t,i,s){void 0!==t&&(e.style[t]="remove"===s?"":i)},I.prototype.addTransformMoveStyle=function(e,t,i,s,n,o,r){this.changeStyleProperty(e,this.getCssSupport("transition-delay"),i),this.changeStyleProperty(e,this.getCssSupport("transition-timing-function"),s),this.changeStyleProperty(e,this.getCssSupport("transition-duration"),t),this.changeStyleProperty(e,this.getCssSupport("transform"),"translate3d("+n+"px,"+o+"px,"+r+"px)")},I.prototype.removeTransformMoveStyle=function(e){this.changeStyleProperty(e,this.getCssSupport("transition-delay"),null,"remove"),this.changeStyleProperty(e,this.getCssSupport("transition-timing-function"),null,"remove"),this.changeStyleProperty(e,this.getCssSupport("transition-duration"),null,"remove"),this.changeStyleProperty(e,this.getCssSupport("transform"),null,"remove")},I.prototype.getCssSupport=function(e){var t=["","-moz-","-webkit-","-o-","-ms-","-khtml-"],i=document.documentElement;for(var s=0;s<t.length;s++){var n=(t[s]+e).replace(/-([a-z])/gi,function(e,t){return t.toUpperCase()});if("Ms"===n.substr(0,2)&&(n="m"+n.substr(1)),n in i.style)return n}},I.prototype._refreshDatabodyMap=function(){this._clearDatabodyMap(),this._addNodesToDatabodyMap(this.m_databody.firstChild.childNodes)},I.prototype._populateDatabody=function(e,t){this._addNodesToDatabodyMap(t.childNodes),e.appendChild(t),this.m_subtreeAttachedCallback(e)},I.prototype._emptyDatabody=function(e){this._clearDatabodyMap(),this.m_utils.empty(e)},I.prototype._addNodesToDatabodyMap=function(e){for(var t=0;t<e.length;t++){var i=e[t];if(this.m_utils.containsCSSClassName(i,this.getMappedStyle("cell"))){var s=this.getCellIndexes(i),n=this.getCellExtents(i),o=i.id;this._addToDatabodyMap(s,o,n)}}},I.prototype._addToDatabodyMap=function(e,t,i){for(var s=i.row,n=i.column,o=0;o<s;o++)for(var r=0;r<n;r++)this._addIndexToDatabodyMap(this.createIndex(e.row+o,e.column+r),t)},I.prototype._addIndexToDatabodyMap=function(e,t){var i="r"+e.row+"c"+e.column;this.m_databodyMap.set(i,t)},I.prototype._removeIndexFromDatabodyMap=function(e){var t="r"+e.row+"c"+e.column;return this.m_databodyMap.delete(t)},I.prototype._getFromDatabodyMap=function(e){var t="r"+e.row+"c"+e.column;return this.m_databodyMap.get(t)},I.prototype._clearDatabodyMap=function(){return this.m_databodyMap.clear()},I.prototype._modifyAxisCellContextIndex=function(e,t,i,s){for(var n=t;n<t+i;n++)for(var o=this._getAxisCellsByIndex(n,e),r=0;r<o.length;r++){o[r][this.getResources().getMappedAttribute("context")].indexes[e]+=s}},I.prototype._modifyAxisHeaderContextIndex=function(e,t,i,s){for(var n=t;n<t+i;n++){var o;o="row"===e?this._getHeadersByIndex(n,this.m_rowHeader,this.m_rowHeaderLevelCount,this.m_startRowHeader):this._getHeadersByIndex(n,this.m_rowEndHeader,this.m_rowEndHeaderLevelCount,this.m_startRowEndHeader);for(var r=0;r<o.length;r++){o[r][this.getResources().getMappedAttribute("context")].index+=s}}},I.prototype._getCellOrHeaderByIndex=function(e,t){var i=null,s=this._getAxisCellsByIndex(e,t,!0);return null!=s&&s.length>0&&(i=s[0]),null==i&&("row"===t&&null==(i=this._getHeaderByIndex(e,0,this.m_rowHeader,this.m_rowHeaderLevelCount,this.m_startRowHeader))&&(i=this._getHeaderByIndex(e,0,this.m_rowEndHeader,this.m_rowEndHeaderLevelCount,this.m_startRowEndHeader)),"column"===t&&null==(i=this._getHeaderByIndex(e,0,this.m_colHeader,this.m_columnHeaderLevelCount,this.m_startColHeader))&&(i=this._getHeaderByIndex(e,0,this.m_colEndHeader,this.m_columnEndHeaderLevelCount,this.m_startColEndHeader))),i},I.prototype._getLabel=function(e,t){return this.m_headerLabels[e][t]},I.prototype._getCellByIndex=function(e){var t=this._getFromDatabodyMap(e);return null!=t?this.m_databody.querySelector("#"+t):null},I.prototype._getCellsInRange=function(e,t,i,s){let n=[];for(let o=e;o<=i;o++)for(let e=t;e<=s;e++){let t=this._getCellByIndex(this.createIndex(o,e));t&&n.push(t)}return n},I.prototype._getFirstCellWithMatchingStartIndex=function(e,t){let i,s,n="row"===t?this.m_startCol:this.m_startRow,o="row"===t?this.m_endCol:this.m_endRow;for(let r=n;r<=o;r++)if(i=this.createIndex("row"===t?e:r,"row"===t?r:e),s=this._getCellByIndex(i),this._getIndex(s,t)===e)return s;return null},I.prototype._getAxisCellsByIndex=function(e,t,i){for(var s,n="row"===t?this.m_startCol:this.m_startRow,o="row"===t?this.m_endCol:this.m_endRow,r=[],l=n;l<=o;l+=s){var a=this._getCellByIndex(this.createIndex("row"===t?e:l,"row"===t?l:e));if(null!=a){if(s=this.getCellExtents(a)["row"===t?"column":"row"],r.push(a),i)break}else s=1}return r},I.prototype._getAxisCellsByKey=function(e,t,i){if(null==e||null==this.m_databody||null==this.m_databody.firstChild)return null;for(var s=[],n=this.m_databody.firstChild.childNodes,o=0;o<n.length;o++){var r=n[o];if(this.m_utils.containsCSSClassName(r,this.getMappedStyle("cell")))if(this._getKey(r,t)===e&&(s.push(r),i))break}return s},I.prototype._setupActions=function(){this.actions={ACTIONABLE:this._handleActionable,EXIT_ACTIONABLE:this._handleExitActionable,TAB_NEXT_IN_CELL:c.handleActionableTab,TAB_PREV_IN_CELL:c.handleActionablePrevTab,EDITABLE:this._handleEditable,EXIT_EDITABLE:this._handleExitEditable,DATA_ENTRY:this._handleDataEntry,EXIT_DATA_ENTRY:this._handleExitDataEntry,EDIT:this._handleEdit,EXIT_EDIT:this._handleExitEdit,CANCEL_EDIT:this._handleCancelEdit,NO_OP:this._handleNoOp,FOCUS_LEFT:this._handleFocusLeft,FOCUS_RIGHT:this._handleFocusRight,FOCUS_UP:this._handleFocusUp,FOCUS_DOWN:this._handleFocusDown,FOCUS_ROW_FIRST:this._handleFocusRowFirst,FOCUS_ROW_LAST:this._handleFocusRowLast,FOCUS_COLUMN_FIRST:this._handleFocusColumnFirst,FOCUS_COLUMN_LAST:this._handleFocusColumnLast,FOCUS_COLUMN_HEADER:this._handleFocusColumnHeader,FOCUS_COLUMN_END_HEADER:this._handleFocusColumnEndHeader,FOCUS_ROW_HEADER:this._handleFocusRowHeader,FOCUS_ROW_END_HEADER:this._handleFocusRowEndHeader,READ_CELL:this.readCurrentContent,SORT:this._handleSortKey,EXPAND:this._handleExpandKey,COLLAPSE:this._handleCollapseKey,SELECT_DISCONTIGUOUS:this._handleSelectDiscontiguous,SELECT_EXTEND_LEFT:this._handleExtendSelectionLeft,SELECT_EXTEND_RIGHT:this._handleExtendSelectionRight,SELECT_EXTEND_UP:this._handleExtendSelectionUp,SELECT_EXTEND_DOWN:this._handleExtendSelectionDown,SELECT_ROW:this._handleSelectRow,SELECT_COLUMN:this._handleSelectColumn,SELECT_ALL:this._handleSelectAll,CUT:this._handleCut,CUT_CELLS:this._handleCutCells,COPY_CELLS:this._handleCopyCells,CANCEL_REORDER:this._handleCancelReorder,PASTE:this._handlePaste,PASTE_CELLS:this._handlePasteCells,FILL:this._handleAutofill}},I.prototype._getActionFromKeyDown=function(e,t,i){var s={cellOrHeader:t,isLabel:i,readOnly:!this._isCellEditable(),currentMode:this._getCurrentMode(),activeMove:null!=this.m_cutCells||null!=this.m_dataTransferAction,rowMove:this._isMoveEnabled("row"),columnSort:"column"===t&&this._isDOMElementSortable(this._getActiveElement()),selection:this._isSelectionEnabled(),selectionMode:this.m_options.getSelectionMode(),multipleSelection:this.isMultipleSelection(),expandCollapse:this._isTargetExpandCollapseEnabled(e.target)};return this._isDataGridProvider()&&(s.cutCells=!0,s.copyCells=!0,s.pasteCells=!0),this.m_options.isFloodFillEnabled()&&(s.fill=!0),this.actions[this.m_keyboardHandler.getAction(e,s)]},I.prototype.isActionableMode=function(){return"actionable"===this.m_currentMode},I.prototype.setActionableMode=function(e){this.m_currentMode=e?"actionable":"navigation",this._setAccInfoText(this.isActionableMode()?"accessibleActionableMode":"accessibleNavigationMode")},I.prototype._handleActionable=function(e,t){return this._enterActionableMode(t,e),!1},I.prototype._handleExitActionable=function(e,t){return this._exitActionableMode(),this._highlightActive(),!1},I.prototype._getEditMode=function(){return null==this.m_editMode&&(this.m_editMode=this.m_options.getEditMode()),this.m_editMode},I.prototype._getCurrentMode=function(){return null==this.m_currentMode&&(this.m_currentMode="navigation"),this.m_currentMode},I.prototype._isEditOrEnter=function(){return"edit"===this._getCurrentMode()},I.prototype._isGridEditable=function(){var e=this._getEditMode();return"cellNavigation"===e||"cellEdit"===e},I.prototype._isCellEditable=function(){return"cellEdit"===this._getEditMode()},I.prototype._handleEditable=function(e,t){return this._isGridEditable()?(this.m_editMode=null,this.m_setOptionCallback("editMode","cellEdit",{_context:{writeback:!0,internalSet:!0}}),this.m_utils.removeCSSClassName(this.m_root,this.getMappedStyle("readOnly")),this.m_utils.addCSSClassName(this.m_root,this.getMappedStyle("editable")),this._updateEdgeCellBorders(""),this._setAccInfoText("accessibleEditableMode"),this._setEditableClone(t)):this._handleActionable(e,t),!1},I.prototype._handleExitEditable=function(e,t){this.m_editMode=null,this.m_setOptionCallback("editMode","cellNavigation",{_context:{writeback:!0,internalSet:!0}}),this.m_utils.addCSSClassName(this.m_root,this.getMappedStyle("readOnly")),this.m_utils.removeCSSClassName(this.m_root,this.getMappedStyle("editable")),this._updateEdgeCellBorders("none"),this._setAccInfoText("accessibleNavigationMode"),this._destroyEditableClone()},I.prototype._handleDataEntry=function(e,t){var i={event:e,ui:{cell:t,cellContext:t[this.getResources().getMappedAttribute("context")]}};return this.fireEvent("beforeEdit",i)&&(this._removeFloodFillAffordance(),this._reRenderCell(t,"edit",this.getMappedStyle("cellEdit"),this.m_editableClone),this._overwriteFlag=!0,this._setFocusToFirstFocusableElement(t)?this.m_currentMode="edit":this.m_utils.removeCSSClassName(t,this.getMappedStyle("cellEdit")),this._overwriteFlag=!1),!1},I.prototype._handleExitDataEntry=function(e,t){return this._leaveEditing(e,t,!1)},I.prototype._handleEdit=function(e,t){var i={event:e,ui:{cell:t,cellContext:t[this.getResources().getMappedAttribute("context")]}},s=this.fireEvent("beforeEdit",i);if(s){this._removeFloodFillAffordance(),this._reRenderCell(t,"edit",this.getMappedStyle("cellEdit"),this.m_editableClone),this.m_currentMode="edit";var n=this;d.getContext(t).getBusyContext().whenReady().then(function(){n._setFocusToFirstFocusableElement(t)||(n.m_utils.removeCSSClassName(t,n.getMappedStyle("cellEdit")),n.m_currentMode="navigation")})}else s=!1,this._enterActionableMode(t);return s},I.prototype._handleExitEdit=function(e,t){return this._leaveEditing(e,t,!1)},I.prototype._handleCancelEdit=function(e,t){return!!this._leaveEditing(e,t,!0)&&(this._setEditableClone(t),!0)},I.prototype._leaveEditing=function(e,t,i,s){var n={event:e,ui:{cell:t,cellContext:t[this.getResources().getMappedAttribute("context")],cancelEdit:i}};i||(c.disableAllFocusableElements(t),!1===s&&(this.m_shouldFocus=s),this._highlightActive());var o=this.fireEvent("beforeEditEnd",n);return o?(this.m_currentMode="navigation",c.disableAllFocusableElements(t),!1===s&&(this.m_shouldFocus=s),this._highlightActive(),this._reRenderCell(t,"navigation",this.getMappedStyle("cellEdit"),this.m_editableClone)):(o=!1,this._scrollToActive(this.m_active),this._setFocusToFirstFocusableElement(t)),o},I.prototype._handleFocusKey=function(e,t,i,s,n){var o,r=!0,l=!0;if(null!=this.m_active){if("cell"===this.m_active.type){if(this._isEditOrEnter()?(o=!0,r=this._leaveEditing(e,t,!1),l=!1):this.isActionableMode()&&this._exitActionableMode(),r){this.m_options.isFloodFillEnabled()&&this._removeFloodFillAffordance();var a=this.m_active,h=this.handleFocusChange(i,s,e,l,n);return this._isGridEditable()&&a!==this.m_active&&o&&this.m_utils.isTouchDevice()?this._handleDataEntry(e,this._getActiveElement()):h}return!0}if("header"===this.m_active.type)return this.handleHeaderFocusChange(i,e,s,n);if("label"===this.m_active.type)return this.handleLabelFocusChange(i,e,s,n)}return!1},I.prototype._handleFocusLeft=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.LEFT_KEY,!1,!1)},I.prototype._handleFocusRight=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.RIGHT_KEY,!1,!1)},I.prototype._handleFocusUp=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.UP_KEY,!1,!1)},I.prototype._handleFocusDown=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.DOWN_KEY,!1,!1)},I.prototype._handleFocusRowFirst=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.PAGEUP_KEY,!1,!1)},I.prototype._handleFocusRowLast=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.PAGEDOWN_KEY,!1,!1)},I.prototype._handleFocusColumnFirst=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.HOME_KEY,!1,!1)},I.prototype._handleFocusColumnLast=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.END_KEY,!1,!1)},I.prototype._handleFocusRowHeader=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.LEFT_KEY,!1,!0)},I.prototype._handleFocusRowEndHeader=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.RIGHT_KEY,!1,!0)},I.prototype._handleFocusColumnHeader=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.UP_KEY,!1,!0)},I.prototype._handleFocusColumnEndHeader=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.DOWN_KEY,!1,!0)},I.prototype._handleSelectRow=function(e,t){var i,s,n,o,r=1;if(!this._isSelectionEnabled()||!this.isMultipleSelection()&&"row"!==this.m_options.getSelectionMode())return!1;if(this.m_utils.containsCSSClassName(t,this.getMappedStyle("cell")))i=o=this.m_active.indexes.row,s=o,n=this.m_rowHeaderLevelCount-1;else{if(null==this.m_active||"header"!==this.m_active.type||-1===this.m_active.axis.indexOf("row"))return!1;if(o=this.m_active.index,n=this.m_active.level,this.m_rowHeaderLevelCount-1===n)i=o,s=o;else{var l=this._getActiveElement();s=(i=this._getAttribute(l.parentNode,"start",!0))+(r=this._getAttribute(l.parentNode,"extent",!0))-1}}if(this.m_selectionFrontier&&this.m_selectionFrontier.axis&&-1!==this.m_selectionFrontier.axis.indexOf("column"))return this._handleSelectAll(e),!0;if(this.setHeaderSelectionFrontier("row",s,o,n,t,!0),this._shouldDeselectHeader(o,r,"column")){var a=this.createIndex(o,0),h=this.createIndex(o+r-1,-1),d=this._getSelectionStartAndEnd(a,h,0),c=this.createRange(this.createIndex(d.min.row,0),this.createIndex(d.max.row,-1)),m=this._trimRangeForSelectionMode(c);return this.m_deselectInfo={selection:this.GetSelection()},this._deselectRange(m,e),!0}return this._selectEntireRow(i,s,e),this._setAccInfoText("accessibleRowSelected",{row:o+1}),!0},I.prototype._handleSelectColumn=function(e,t){var i,s,n,o,r=1;if(!this._isSelectionEnabled()||!this.isMultipleSelection()||"cell"!==this.m_options.getSelectionMode())return!1;if(this.m_utils.containsCSSClassName(t,this.getMappedStyle("cell")))i=o=this.m_active.indexes.column,s=o,n=this.m_columnHeaderLevelCount-1;else{if(null==this.m_active||"header"!==this.m_active.type||-1===this.m_active.axis.indexOf("column"))return!1;if(o=this.m_active.index,n=this.m_active.level,this.m_columnHeaderLevelCount-1===n)i=o,s=o;else{var l=this._getActiveElement();s=(i=this._getAttribute(l.parentNode,"start",!0))+(r=this._getAttribute(l.parentNode,"extent",!0))-1}}if(this.m_selectionFrontier&&this.m_selectionFrontier.axis&&-1!==this.m_selectionFrontier.axis.indexOf("row"))return this._handleSelectAll(e),!0;if(this.setHeaderSelectionFrontier("column",s,o,n,t,!0),this._shouldDeselectHeader(o,r,"row")){var a=this.createIndex(0,o),h=this.createIndex(-1,o+r-1),d=this._getSelectionStartAndEnd(a,h,0),c=this.createRange(this.createIndex(0,d.min.column),this.createIndex(-1,d.max.column)),m=this._trimRangeForSelectionMode(c);return this.m_deselectInfo={selection:this.GetSelection()},this._deselectRange(m,e),!0}return this._selectEntireColumn(i,s,e),this._setAccInfoText("accessibleColumnSelected",{column:o+1}),!0},I.prototype._handleSelectDiscontiguous=function(e,t){return this.setDiscontiguousSelectionMode(!this.m_discontiguousSelection),!0},I.prototype._handleExtendSelectionLeft=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.LEFT_KEY,!0,!1)},I.prototype._handleExtendSelectionRight=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.RIGHT_KEY,!0,!1)},I.prototype._handleExtendSelectionUp=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.UP_KEY,!0,!1)},I.prototype._handleExtendSelectionDown=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.DOWN_KEY,!0,!1)},I.prototype._handleSortKey=function(e,t){return"true"===t.getAttribute(this.getResources().getMappedAttribute("sortable"))?(this._handleKeyboardSort(t,e),!0):this._handleActionable(e,t)},I.prototype._handleExpandKey=function(e,t){return!!this._isHeaderCollapsed(t)&&(this._handleExpandCollapseRequest(e),!0)},I.prototype._handleCollapseKey=function(e,t){return!!this._isHeaderExpanded(t)&&(this._handleExpandCollapseRequest(e),!0)},I.prototype._handleNoOp=function(e,t){return!1},I.RESIZE_OFFSET=5,I.RESIZE_TOUCH_OFFSET=8,I.prototype.handleResize=function(e){if(!1===this.m_isResizing){var t=this.find(e.target,"header"),i=this.find(e.target,"headerlabel");if(null==t&&(t=this.find(e.target,"endheader")),null!=t&&(t===this.m_rowHeader||t===this.m_colHeader||t===this.m_rowEndHeader||t===this.m_colEndHeader)||null!=i){let t=!1;i&&(t=!0),this.m_cursor=this.manageHeaderCursor(e,t),null!=this.m_resizingElement&&("default"===this.m_cursor?(this.m_resizingElement.style.cursor="",this._isSelectionEnabled()&&this.m_utils.addCSSClassName(e.target,this.getMappedStyle("hover")),null!=this.m_resizingElementSibling&&(this.m_resizingElementSibling.style.cursor="")):(this.m_resizingElement.style.cursor=this.m_cursor,this.m_utils.removeCSSClassName(e.target,this.getMappedStyle("hover")),null!=this.m_resizingElementSibling&&(this.m_resizingElementSibling.style.cursor=this.m_cursor)))}}else this.handleResizeMouseMove(e)},I.prototype.handleResizeMouseDown=function(e){return("col-resize"===this.m_cursor||"row-resize"===this.m_cursor)&&(this.m_isResizing=!0,this.m_utils.isTouchDevice()?(this.m_lastMouseX=e.touches[0].pageX,this.m_lastMouseY=e.touches[0].pageY):(document.addEventListener("mousemove",this.m_docMouseMoveListener,!1),document.addEventListener("mouseup",this.m_docMouseUpListener,!1),this.m_lastMouseX=e.pageX,this.m_lastMouseY=e.pageY),this.m_overResizeLeft=0,this.m_overResizeMinLeft=0,this.m_overResizeTop=0,this.m_overResizeMinTop=0,this.m_overResizeRight=0,this.m_overResizeBottom=0,this.m_orginalResizeDimensions={width:this.getElementWidth(this.m_resizingElement),height:this.getElementHeight(this.m_resizingElement)},!0)},I.prototype._resizeSelectedHeaders=function(e,t,i,s,n,o){let r,l=this.m_resizingElement,a=this.getHeaderCellAxis(this.m_resizingElement),h=this.getHeaderCellIndex(this.m_resizingElement),d=this._getResizeHeaderMode(this.m_resizingElement),c=this.getHeaderCellLevel(this.m_resizingElement),m=!1;if(("column"===a&&c===this.m_columnHeaderLevelCount-1||"row"===a&&c===this.m_rowHeaderLevelCount-1||"columnEnd"===a&&c===this.m_columnEndHeaderLevelCount-1||"rowEnd"===a&&c===this.m_rowEndHeaderLevelCount-1)&&(m=!0),this.m_selection&&this.m_selection.length&&m&&(r=this._getHeadersWithinSelection(this.m_selection[0],h,a)),r&&r.length)for(let a=0;a<r.length;a++)l!==r[a]&&(this.m_resizingElement=r[a],"column"===d?this.resizeColWidth(this.getElementDir(r[a],"width"),s):this.resizeRowHeight(this.getElementDir(r[a],"height"),n),this._fireResizeEvent(e,t,i,s,n,o));else"column"===d?this.resizeColWidth(this.getElementDir(this.m_resizingElement,"width"),s):this.resizeRowHeight(this.getElementDir(this.m_resizingElement,"height"),n),this._fireResizeEvent(e,t,i,s,n,o)},I.prototype._fireResizeEvent=function(e,t,i,s,n,o){let r={event:e,ui:{header:this._getKey(this.m_resizingElement),oldDimensions:{width:t,height:i},newDimensions:{width:s,height:n},size:o}};this.fireEvent("resize",r)},I.prototype.handleResizeMouseUp=function(e){if(!0===this.m_isResizing){var t=this.getElementWidth(this.m_resizingElement),i=this.getElementHeight(this.m_resizingElement);let s=this.m_orginalResizeDimensions.width,n=this.m_orginalResizeDimensions.height,o=this.m_resizingElement,r="col-resize"===this.m_cursor?o.style.width:o.style.height;t===this.m_orginalResizeDimensions.width&&i===this.m_orginalResizeDimensions.height||"col-resize"!==this.m_cursor&&"row-resize"!==this.m_cursor||this._isSelectionEnabled()&&this.isMultipleSelection()&&this.m_selection.length&&!this.m_discontiguousSelection&&this._resizeSelectedHeaders(e,s,n,t,i,r),o.style.cursor="",this._unhighlightResizeBorderColor(),this.m_isResizing=!1,this.m_cursor="default",null!=this.m_resizingElementSibling&&(this.m_resizingElementSibling.style.cursor=""),this.m_resizingElement=null,this.m_resizingElementMin=null,this.m_resizingElementSibling=null,this.m_orginalResizeDimensions=null,document.removeEventListener("mousemove",this.m_docMouseMoveListener,!1),document.removeEventListener("mouseup",this.m_docMouseUpListener,!1)}},I.prototype._isDOMElementResizable=function(e){return null!=e&&"true"===e.getAttribute(this.getResources().getMappedAttribute("resizable"))},I.prototype.manageHeaderCursor=function(e,t){var i,s,n,o,r,l,a,h,d;if((d=t?this.find(e.target,"headerlabel"):this.find(e.target,"headercell"))||t||(d=this.find(e.target,"endheadercell")),!d)return"default";var c=t?this.getHeaderLabelAxis(d):this.getHeaderCellAxis(d),m=t?this.getHeaderLabelLevel(d):this.getHeaderCellIndex(d),u=t?m:this.getHeaderCellLevel(d);if("column"===c?(r="enable"===this.m_options.isResizable(c,"height"),o=this._isDOMElementResizable(d),t?(a=null,l=null,h=this.m_headerLabels.column[m-1]):((a=this._getHeaderByIndex(m-1,u,this.m_colHeader,this.m_columnHeaderLevelCount,this.m_startColHeader))||(this.m_headerLabels.column.length?(a=this._getLabel("column",u),u===this.m_columnHeaderLevelCount-1&&this._isHeaderLabelCollision()&&(a=this.m_headerLabels.row[this.m_rowHeaderLevelCount-1])):a=this._getLabel("row",u)),l=this._isDOMElementResizable(a),h=this._getHeaderByIndex(m,u-1,this.m_colHeader,this.m_columnHeaderLevelCount,this.m_startColHeader))):"row"===c?(o="enable"===this.m_options.isResizable(c,"width"),r=this._isDOMElementResizable(d),t?(h=this.m_headerLabels.row[m-1],this._isHeaderLabelCollision()&&d===this.m_headerLabels.row[this.m_rowHeaderLevelCount-1]&&(a=this.m_headerLabels.column[this.m_columnHeaderLevelCount-1])):(a=this._getHeaderByIndex(m-1,u,this.m_rowHeader,this.m_rowHeaderLevelCount,this.m_startRowHeader),l=this._isDOMElementResizable(a),h=this._getHeaderByIndex(m,u-1,this.m_rowHeader,this.m_rowHeaderLevelCount,this.m_startRowHeader))):"columnEnd"===c?(r="enable"===this.m_options.isResizable(c).height,o=this._isDOMElementResizable(d),t?(a=null,l=null,h=this.m_headerLabels.columnEnd[m-1]):((a=this._getHeaderByIndex(m-1,u,this.m_colEndHeader,this.m_columnEndHeaderLevelCount,this.m_startColEndHeader))||(a=this._getLabel("columnEnd",u)),l=this._isDOMElementResizable(a),h=this._getHeaderByIndex(m,u-1,this.m_colEndHeader,this.m_columnEndHeaderLevelCount,this.m_startColEndHeader))):"rowEnd"===c&&(o="enable"===this.m_options.isResizable(c).width,r=this._isDOMElementResizable(d),t?(a=this.m_headerLabels.rowEnd[m-1],l=this._isDOMElementResizable(a)):(a=this._getHeaderByIndex(m-1,u,this.m_rowEndHeader,this.m_rowEndHeaderLevelCount,this.m_startRowEndHeader),l=this._isDOMElementResizable(a),h=this._getHeaderByIndex(m,u-1,this.m_rowEndHeader,this.m_rowEndHeaderLevelCount,this.m_startRowEndHeader))),this.m_utils.isTouchDevice())i=e.touches[0].pageX,s=e.touches[0].pageY,n=I.RESIZE_TOUCH_OFFSET;else{i=e.offsetX,s=e.offsetY,n=I.RESIZE_OFFSET;var _=this._findHeaderOffset(e.target,d);i+=_[0],s+=_[1]}var p=this.getHeaderEdgePixels(d),g=this.getResources().isRTLMode(),f="columnEnd"===c||"rowEnd"===c,C=i<p[0]+n,y=s<p[1]+n,v=i>p[2]-n,E=s>p[3]-n;if("column"===c||"columnEnd"===c){if(o&&(g?C:v))return this.m_resizingElement=d,"col-resize";if(l&&(g?v:C)){if(this.m_resizingElement=a,this.m_resizingElementSibling=d,null!==this.m_resizingElement)return"col-resize"}else if(r){if(!f&&E||f&&y)return this.m_resizingElement=d,"row-resize";if(!f&&y||f&&E)return this.m_resizingElement=h,this.m_resizingElementSibling=d,"row-resize"}}else if("row"===c||"rowEnd"===c){if(r&&E)return this.m_resizingElement=d,"row-resize";if(l&&y&&!t){if(this.m_resizingElement=a,this.m_resizingElementSibling=d,null!==this.m_resizingElement)return"row-resize"}else if(h&&y&&t&&(this.m_resizingElement=h,this.m_resizingElementSibling=d,null!==this.m_resizingElement))return"row-resize";if(o){if(!f&&(g?C:v)||f&&(g?v:C))return this.m_resizingElement=d,"col-resize";if((!f&&(g?v:C)||f&&(g?C:v))&&(this.m_resizingElement=h,this.m_resizingElementSibling=d,null!==this.m_resizingElement))return"col-resize"}}return"default"},I.prototype.handleResizeMouseMove=function(e){var t,i,s,n,o;this.m_currentMouseX=e.pageX,this.m_currentMouseY=e.pageY,this.m_utils.isTouchDevice()?(this.m_currentMouseX=e.touches[0].pageX,this.m_currentMouseY=e.touches[0].pageY):(this.m_currentMouseX=e.pageX,this.m_currentMouseY=e.pageY),t=this._getResizeHeaderMode(this.m_resizingElement);var r=this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("endheadercell"))||this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("columnendheaderlabel"));let l=this.find(this.m_resizingElement,"headerlabel");"col-resize"===this.m_cursor?"column"===t?(r=!l&&r,i=this.calculateColumnHeaderWidth(this.m_resizingElement),s=this.getNewElementWidth("column",i,r,null,l),l?this.resizeRowWidth(s,s-i,r,l):this.resizeColWidth(i,s)):"row"===t&&(this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("rowendheaderlabel"))&&(r=!0),i=this.getElementWidth(this.m_resizingElement),s=this.getNewElementWidth("row",i,r,null,l),this.resizeRowWidth(s,s-i,r,l)):"row-resize"===this.m_cursor&&("row"===t?(n=this.calculateRowHeaderHeight(this.m_resizingElement),o=this.getNewElementHeight("row",n,r,null,l),l?this.resizeColHeight(o,o-n,r):this.resizeRowHeight(n,o)):"column"===t&&(n=this.getElementHeight(this.m_resizingElement),o=this.getNewElementHeight("column",n,r,null,l),this.resizeColHeight(o,o-n,r))),this.buildCorners(),this.m_utils.isTouchDevice()&&this._moveTouchSelectionAffordance(),this.m_lastMouseX=this.m_currentMouseX,this.m_lastMouseY=this.m_currentMouseY},I.prototype.resizeColWidth=function(e,t){var i,s=t-e;if(0!==s){if(null!=this.m_databody.firstChild)i=this.getElementWidth(this.m_databody.firstChild)+s,this.setElementWidth(this.m_databody.firstChild,i);this.resizeColumnWidthAndShift(s),this.m_endColPixel+=s,this.m_endColHeaderPixel+=s,this.m_endColEndHeaderPixel+=s,null!=i&&(this.m_avgColWidth=i/this.getDataSource().getCount("column")),this.manageResizeScrollbars()}},I.prototype.resizeRowHeight=function(e,t){var i,s=t-e;if(0!==s){if(null!=this.m_databody.firstChild)i=this.getElementHeight(this.m_databody.firstChild)+s,this.setElementHeight(this.m_databody.firstChild,i);this.resizeRowHeightAndShift(s),this.m_endRowPixel+=s,this.m_endRowHeaderPixel+=s,this.m_endRowEndHeaderPixel+=s,null!=i&&(this.m_avgRowHeight=i/this.getDataSource().getCount("row")),this.manageResizeScrollbars()}},I.prototype.resizeColHeight=function(e,t,i){if(0!==t){var s,n,o,r=!0,l=this.find(this.m_resizingElement,"headerlabel");if(l?"column"===(o=this.getHeaderLabelAxis(this.m_resizingElement))||"columnEnd"===o?n=this.getHeaderLabelLevel(this.m_resizingElement):"row"!==o&&"rowEnd"!==o||(n=this.m_columnHeaderLevelCount-1,r=!1):(n=this.getHeaderCellLevel(this.m_resizingElement)+(this.getHeaderCellDepth(this.m_resizingElement)-1),o=this.getHeaderCellAxis(this.m_resizingElement)),i?this.m_columnEndHeaderLevelHeights[n]+=t:(s=this.m_columnHeaderLevelHeights[n],this.m_columnHeaderLevelHeights[n]+=t),!i&&n===this.m_columnHeaderLevelCount-1&&this.m_headerLabels.row.length&&this._isHeaderLabelCollision()&&(r=!1),this.resizeColumnHeightsAndShift(t,n,i,r),i)this.m_colEndHeaderHeight+=t,this.setElementHeight(this.m_colEndHeader,this.m_colEndHeaderHeight);else if(this.m_colHeaderHeight+=t,this.setElementHeight(this.m_colHeader,this.m_colHeaderHeight),0===this.m_headerLabels.column.length)this._resizeHeaderLabelDirs(n,t,["row"],"height");else if(n===this.m_columnHeaderLevelCount-1&&this.m_headerLabels.row.length){var a,h;if(l){if("column"===o)h=e,this.m_collisionResize=!0;else if("row"===o)a=t,this.m_collisionResize=!0;else if("rowEnd"===o)if(this._isHeaderLabelCollision()){let e=this._calculateCollisionDimension(this.m_colHeaderHeight,s,l,o);a=e.rowHeightChange,h=e.colHeight}else a=t,h=this.m_colHeaderHeight}else if(this._isHeaderLabelCollision()){let t=this._calculateCollisionDimension(e,s,!0,o);a=t.rowHeightChange,h=t.colHeight}else a=t,h=e;var d=this._getLabel("column",this.m_columnHeaderLevelCount-1);d&&this.setElementHeight(d,h),this._resizeHeaderLabelDirs(this.m_rowHeaderLevelCount-1,a,["row"],"height")}this.manageResizeScrollbars()}},I.prototype._calculateCollisionDimension=function(e,t,i,s){let n,o,r={},l=this._getMinValue("height",s,i);if(this.m_collisionResize){let r=this.getElementDir(this.m_headerLabels.row[this.m_rowHeaderLevelCount-1],"height"),a=this.getElementDir(this.m_headerLabels.column[this.m_columnHeaderLevelCount-1],"height"),h=r+a,d=a/h,c=r/h;r===l&&a===l?(n=Math.floor(e/2)-Math.floor(t/2),o=Math.ceil(e/2),this.m_collisionResize=!1):d>c?(o=Math.floor(e*d),n=e-o-r,r+n<this._getMinValue("height",s,i)&&(n=0)):(n=Math.floor(e*c)-r,r+n<this._getMinValue("height",s,i)&&(n=0),o=e-(r+n),o=Math.max(o,this._getMinValue("height",s,i)))}else n=Math.floor(e/2)-Math.floor(t/2),o=Math.ceil(e/2);return r.colHeight=o,r.rowHeightChange=n,r},I.prototype.resizeRowWidth=function(e,t,i,s){if(0!==t){var n;if(s){let e=this.getHeaderLabelAxis(this.m_resizingElement);"column"===e||"columnEnd"===e?n=this.m_rowHeaderLevelCount-1:"row"!==e&&"rowEnd"!==e||(n=this.getHeaderLabelLevel(this.m_resizingElement))}else n=this.getHeaderCellLevel(this.m_resizingElement)+(this.getHeaderCellDepth(this.m_resizingElement)-1);i?this.m_rowEndHeaderLevelWidths[n]+=t:this.m_rowHeaderLevelWidths[n]+=t,this.resizeRowWidthsAndShift(t,n,i),i?(this.m_rowEndHeaderWidth+=t,this.setElementWidth(this.m_rowEndHeader,this.m_rowEndHeaderWidth)):(this.m_rowHeaderWidth+=t,this.setElementWidth(this.m_rowHeader,this.m_rowHeaderWidth),(n===this.m_rowHeaderLevelCount-1||0===this.m_headerLabels.row.length&&this.m_headerLabels.column.length)&&this._resizeHeaderLabelDirs(n,t,["column"],"width")),this.manageResizeScrollbars()}},I.prototype._resizeHeaderLabelDirs=function(e,t,i,s){for(var n=0;n<i.length;n++){for(var o=i[n],r=0;r<this.m_headerLabels[o].length;r++){var l=this.m_headerLabels[o][r];if(null!=l){var a=this.getElementDir(l,s)+t;this.setElementDir(l,a,s)}}this._highlightResizeLabelDirs(o,e)}},I.prototype._highlightResizeLabelDirs=function(e,t){let i=this.getResources().isRTLMode()?["startResized"]:["endResized"],s="column"===e?i:["bottomResized"];this.m_corner&&("column"===e&&t===this.m_columnHeaderLevelCount-1||"row"===e&&t===this.m_rowHeaderLevelCount-1)&&this._highlightElement(this.m_corner,s);let n=this._getLabel("rowEnd",this.m_columnHeaderLevelCount-1);n&&this._highlightElement(n.parentNode,s)},I.prototype._unhighlightResizeBorderColor=function(){let e=this.m_root.querySelectorAll(".oj-datagrid-resized-start,\n    .oj-datagrid-resized-end, .oj-datagrid-resized-top, .oj-datagrid-resized-bottom");this._unhighlightElementsByClassName(e,["startResized","endResized","topResized","bottomResized"])},I.prototype.getNewElementWidth=function(e,t,i,s,n){var o;o=this._getMinValue("width",e,n),null==s&&(s=this.getResources().isRTLMode()?this.m_lastMouseX-this.m_currentMouseX:this.m_currentMouseX-this.m_lastMouseX),i&&"row"===e&&(s*=-1);var r=t+s+this.m_overResizeLeft+this.m_overResizeMinLeft+this.m_overResizeRight;if(r<o?(this.m_overResizeMinLeft+=s-o+t,r=o):(this.m_overResizeMinLeft=0,this.m_overResizeLeft=0),"row"===e){var l=this.getRowHeaderWidth()+this.getRowEndHeaderWidth()-t,a=Math.round(this.getWidth()-this.m_utils.getScrollbarSize()-1)-l;r>a?(this.m_overResizeRight+=s-a+t,r=a):this.m_overResizeRight=0}return r},I.prototype.getNewElementHeight=function(e,t,i,s,n){var o;let r=this._getMinValue("height",e,!0);if(n){o=r;let e=this.getHeaderLabelLevel(this.m_resizingElement);"rowEnd"===this.getHeaderLabelAxis(this.m_resizingElement)&&e===this.m_columnHeaderLevelCount-1&&this._isHeaderLabelCollision()&&(o+=this.getElementHeight(this.m_headerLabels.row[this.m_headerLabels.row.length-1]))}else o=this._getMinValue("height",e,n);"column"===e&&!i&&this.getHeaderCellLevel(this.m_resizingElement)+this.getHeaderCellDepth(this.m_resizingElement)===this.m_columnHeaderLevelCount&&this._isHeaderLabelCollision()&&(o=2*r),null==s&&(s=this.m_currentMouseY-this.m_lastMouseY),i&&"column"===e&&(s*=-1);var l=t+s+this.m_overResizeTop+this.m_overResizeMinTop+this.m_overResizeBottom;if(l<o?(this.m_overResizeMinTop+=s-o+t,l=o):(this.m_overResizeMinTop=0,this.m_overResizeTop=0),"column"===e){var a=this.getColumnHeaderHeight()+this.getColumnEndHeaderHeight()-t,h=Math.round(this.getHeight()-this.m_utils.getScrollbarSize()-1)-a;l>h?(this.m_overResizeBottom+=s-h+t,l=h):this.m_overResizeBottom=0}return l},I.prototype._getMinValue=function(e,t,i){var s,n,o=this.m_resizingElement,r=this._getCellPaddingBorder(e,o),l=r;if(i)return Math.max(this.m_utils.isTouchDevice()?2*I.RESIZE_TOUCH_OFFSET:2*I.RESIZE_OFFSET,l);var a=this.getHeaderCellLevel(o),h=this.getHeaderCellDepth(o),d=this.getResources().getMappedAttribute("sortable");"true"===o.getAttribute(d)&&this._setSortContainerSize(this._getSortContainer(o),r),"column"===t&&"true"===o.getAttribute(d)&&(l="width"===e?this.m_sortContainerWidth:this.m_sortContainerHeight);var c=Math.max(this.m_utils.isTouchDevice()?2*I.RESIZE_TOUCH_OFFSET:2*I.RESIZE_OFFSET,l);if("column"===t&&(1===this.m_columnHeaderLevelCount||"width"===e&&this.m_columnHeaderLevelCount===a+1||"height"===e&&1===h)||"row"===t&&(1===this.m_rowHeaderLevelCount||"height"===e&&this.m_rowHeaderLevelCount===a+1||"width"===e&&1===h))return c;var m=this.getHeaderCellIndex(o),u=this._getAttribute(this.m_resizingElement.parentNode,"extent",!0),_=this.getElementDir(o,e);return"column"===t?"width"===e?(s=this._getHeaderByIndex(m+(u-1),this.m_columnHeaderLevelCount-1,this.m_colHeader,this.m_columnHeaderLevelCount,this.m_startColHeader),n=this.getElementDir(s,e)):n=this._getHeaderLevelDimension(a+(h-1),o,this.m_columnHeaderLevelHeights,"height",1):"row"===t&&("height"===e?(s=this._getHeaderByIndex(m+(u-1),this.m_rowHeaderLevelCount-1,this.m_rowHeader,this.m_rowHeaderLevelCount,this.m_startRowHeader),n=this.getElementDir(s,e)):n=this._getHeaderLevelDimension(a+(h-1),o,this.m_rowHeaderLevelWidths,"width",1)),_-(n-c)},I.prototype._getLabelMinValue=function(e){var t=this.m_resizingElement,i=this._getCellPaddingBorder(e,t);return Math.max(this.m_utils.isTouchDevice()?2*I.RESIZE_TOUCH_OFFSET:2*I.RESIZE_OFFSET,i)},I.prototype._setSortContainerSize=function(e,t){this.m_sortContainerWidth=this.getElementWidth(e)+t,this.m_sortContainerHeight=this.getElementHeight(e)},I.prototype._getCellPaddingBorder=function(e,t){if(null==this.m_resizingElementMin){for(var i=["top","right","bottom","left"],s="width"===e?1:0,n=0,o=window.getComputedStyle(t);s<4;s+=2)n+=parseFloat(o.getPropertyValue("padding-"+i[s])),n+=parseFloat(o.getPropertyValue("border-"+i[s]+"-width"));this.m_resizingElementMin=Math.round(n)}return this.m_resizingElementMin},I.prototype.manageResizeScrollbars=function(){var e=this.getWidth(),t=this.getHeight(),i=this.m_colHeader,s=this.m_colEndHeader,n=this.m_rowHeader,o=this.m_rowEndHeader,r=this.m_databody,l=r.firstChild,a=this.getColumnHeaderHeight(),h=this.getColumnEndHeaderHeight(),d=this.getRowHeaderWidth(),c=t-a-h,m=e-d-this.getRowEndHeaderWidth(),u=this.m_utils.getScrollbarSize(),_=this.getResources().isRTLMode()?"right":"left";if(this._databodyEmpty()){var p;null==this.m_empty?(p=this._buildEmptyText(),this.m_root.appendChild(p)):(p=this.m_empty,this.setElementDir(p,this.m_endColHeader>=0?a:0,"top"));var g=this.getElementHeight(p),f=this.getElementWidth(p);g>this.getElementHeight(l)&&this.setElementHeight(l,g),f>this.getElementWidth(l)&&this.setElementWidth(l,f)}var C,y,v,E,S,w=this.getElementWidth(r.firstChild),H=this.getElementHeight(r.firstChild),b=this.isDatabodyHorizontalScrollbarRequired(m);b?(C=this.isDatabodyVerticalScrollbarRequired(c-u),r.style.overflow="auto"):(C=this.isDatabodyVerticalScrollbarRequired(c))?(b=this.isDatabodyHorizontalScrollbarRequired(m-u),r.style.overflow="auto"):r.style.overflow="hidden",this.m_hasHorizontalScroller=b,this.m_hasVerticalScroller=C,-1!==this.m_endColEndHeader?(y=Math.min(H+(b?u:0),c),v=b?y-u:y):(y=c,v=Math.min(H,b?y-u:y)),-1!==this.m_endRowEndHeader?(E=Math.min(w+(C?u:0),m),S=C?E-u:E):(E=m,S=Math.min(w,C?E-u:E));var x=d+S+(C?u:0),R=a+v+(b?u:0);if(this.setElementDir(n,0,_),this.setElementDir(n,a,"top"),this.setElementHeight(n,v),this.setElementDir(o,x,_),this.setElementDir(o,a,"top"),this.setElementHeight(o,v),this.setElementDir(i,d,_),this.setElementWidth(i,S),this.setElementDir(s,d,_),this.setElementDir(s,R,"top"),this.setElementWidth(s,S),this.setElementDir(r,a,"top"),this.setElementDir(r,d,_),this.setElementWidth(r,E),this.setElementHeight(r,y),this.m_scrollWidth=w-S,this.m_scrollHeight=H-v,this.buildCorners(),this._adjustHeaderBorders(),this._updateGridlines(),this.m_utils.isTouchDevice()){var M=0,I=0;if(this.m_currentScrollLeft>this.m_scrollWidth&&(M=this.m_scrollWidth-this.m_currentScrollLeft),this.m_currentScrollTop>this.m_scrollHeight&&(I=this.m_scrollHeight-this.m_currentScrollTop),0!==M||0!==I){this._disableTouchScrollAnimation();var A=this.adjustTouchScroll(M,I);M=A[0],I=A[1],this.scrollDelta(M,I)}}},I.prototype.resizeColumnWidthAndShift=function(e){var t=this.getResources().isRTLMode()?"right":"left",i=this.m_colHeader.style.display,s=this.m_colEndHeader.style.display;this.m_databody.style.display="none",this.m_colHeader.style.display="none",this.m_colEndHeader.style.display="none";var n=this.getHeaderCellIndex(this.m_resizingElement);this.m_columnHeaderLevelCount>1&&this.m_resizingElement===this.m_resizingElement.parentNode.firstChild&&null!=this.m_resizingElement.nextSibling&&(n+=this._getAttribute(this.m_resizingElement.parentNode,"extent",!0)-1);var o,r=this.createIndex(-1,n),l=this.getElementsInRange(this.createRange(r,r));for(let e=0;e<l.length;e++)o=this.getResources().isRTLMode()?["startResized"]:["endResized"],this._highlightElement(l[e],o);this._shiftHeadersAlongAxisInContainer(this.m_colHeader.firstChild,n,e,t,this.getMappedStyle("colheadercell"),"column"),this._shiftHeadersAlongAxisInContainer(this.m_colEndHeader.firstChild,n,e,t,this.getMappedStyle("colendheadercell"),"column"),this._shiftCellsAlongAxis("column",e,n),this.m_databody.style.display="",this.m_colHeader.style.display=i,this.m_colEndHeader.style.display=s},I.prototype._shiftCellsAlongAxis=function(e,t,i,s){var n,o,r,l,a,h=[];if(null==s&&(s=!1),"row"===e?(n="height",o="top",r=this.m_endRow,l=this.m_startCol,a=this.m_endCol):(n="width",o=this.getResources().isRTLMode()?"right":"left",r=this.m_endCol,l=this.m_startRow,a=this.m_endRow),null!=this.m_databody.firstChild)for(var d=l;d<=a;d++){var c="row"===e?this.createIndex(i,d):this.createIndex(d,i),m=this._getCellByIndex(c),u=m[this.getResources().getMappedAttribute("context")],_=u.indexes[e],p=u.extents[e],g=i-_,f=p-g;h[d]&&h[d][i]||!0===s||(this.setElementDir(m,this.getElementDir(m,n)+t,n),"row"===e?this._updateTempArray(h,!0,d,i,u.extents.column,p-g):this._updateTempArray(h,!0,d,i,u.extents.row,p-g));var C=i;!0!==s&&(C=i+f);for(var y=C;y<=r;y++)if(!h[d]||!h[d][y]){c="row"===e?this.createIndex(y,d):this.createIndex(d,y),p=(u=(m=this._getCellByIndex(c))[this.getResources().getMappedAttribute("context")]).extents[e];var v=this.getElementDir(m,o)+t;this.setElementDir(m,v,o),"row"===e?this._updateTempArray(h,!0,d,y,u.extents.column,p):this._updateTempArray(h,!0,d,y,u.extents.row,p)}}},I.prototype.resizeRowHeightAndShift=function(e){var t=this.m_rowHeader.style.display,i=this.m_rowEndHeader.style.display;this.m_databody.style.display="none",this.m_rowHeader.style.display="none",this.m_rowEndHeader.style.display="none";var s=this.getHeaderCellIndex(this.m_resizingElement);this.m_rowHeaderLevelCount>1&&this.m_resizingElement===this.m_resizingElement.parentNode.firstChild&&null!=this.m_resizingElement.nextSibling&&(s+=this._getAttribute(this.m_resizingElement.parentNode,"extent",!0)-1);var n,o=this.createIndex(s,-1),r=this.getElementsInRange(this.createRange(o,o));for(let e=0;e<r.length;e++)n=["bottomResized"],this._highlightElement(r[e],n);this._shiftHeadersAlongAxisInContainer(this.m_rowHeader.firstChild,s,e,"top",this.getMappedStyle("rowheadercell"),"row"),this._shiftHeadersAlongAxisInContainer(this.m_rowEndHeader.firstChild,s,e,"top",this.getMappedStyle("rowendheadercell"),"row"),this._shiftCellsAlongAxis("row",e,s),this.m_databody.style.display="",this.m_rowHeader.style.display=t,this.m_rowEndHeader.style.display=i},I.prototype._shiftHeadersAlongAxisInContainer=function(e,t,i,s,n,o){var r,l,a,h,d=0,c=e.lastChild;if(null!=c){var m,u=this.m_utils.containsCSSClassName(c,n);for(u?(l=c.parentNode,r=c,a=this.getHeaderCellIndex(r)):(l=c,r=c.firstChild,a=this._getAttribute(l,"start",!0));t<a;)if(u)h=this.getElementDir(r,s)+i,this.setElementDir(r,h,s),c=c.previousSibling,u=this.m_utils.containsCSSClassName(c,n),l=c.parentNode,r=c,a=this.getHeaderCellIndex(r);else{for(var _=l.getElementsByClassName(n),p=0;p<_.length;p++)h=this.getElementDir(_[p],s)+i,this.setElementDir(_[p],h,s);c=c.previousSibling,u=this.m_utils.containsCSSClassName(c,n),l=c,r=c.firstChild,a=this._getAttribute(l,"start",!0)}if(this.m_resizingElement&&(m=this.getHeaderCellLevel(this.m_resizingElement)),"column"===o?(d=this.getElementWidth(r)+i,this.setElementWidth(r,d)):"row"===o?(d=this.getElementHeight(r)+i,this.setElementHeight(r,d)):null==o&&(h=this.getElementDir(r,s)+i,this.setElementDir(r,h,s)),"row"===o||"column"===o){let e=this.getResources().isRTLMode()?["startResized"]:["endResized"],t="row"===o?["bottomResized"]:e;void 0!==m&&this.getHeaderCellLevel(r)>=m&&this._highlightElement(r,t),r!==this.m_resizingElement||r!==l.lastChild&&r!==l.firstChild||this._highlightResizeBorder(t,o)}u||null==r.nextSibling?null!=o&&this.m_sizingManager.setSize(o,this._getKey(r),d):this._shiftHeadersAlongAxisInContainer(c,t,i,s,n,o)}},I.prototype._highlightResizeBorder=function(e,t){let i=this.getHeaderCellIndex(this.m_resizingElement),s="column"===t?this.m_columnHeaderLevelCount:this.m_rowHeaderLevelCount,n=this.m_resizingElement[this.getResources().getMappedAttribute("context")],o=n.index+n.extent-1;for(let n=0;n<s-1;n++){let r;r="row"===t?this._getHeaderByIndex(i,n,this.m_rowHeader,s,this.m_startRowHeader):this._getHeaderByIndex(i,n,this.m_colHeader,s,this.m_startColumnHeader);let l=r[this.getResources().getMappedAttribute("context")];l.index+l.extent-1===o&&this._highlightElement(r,e)}},I.prototype.resizeColumnHeightsAndShift=function(e,t,i,s){var n,o,r,l;i?(n=this.m_colEndHeader,o=this.getMappedStyle("colendheadercell"),r="columnEnd",l="bottom"):(n=this.m_colHeader,o=this.getMappedStyle("colheadercell"),r="column",l="top"),n.style.display="none",this.m_databody.style.display="none",s&&this._shiftLabelsDir(this.m_headerLabels[r],e,t,l,r),this._shiftHeadersDirInContainer(n.firstChild,e,t,l,o,r),n.style.display="",this.m_databody.style.display=""},I.prototype.resizeRowWidthsAndShift=function(e,t,i){var s,n,o,r;i?(s=this.m_rowEndHeader,n=this.getMappedStyle("rowendheadercell"),o="rowEnd",r=this.getResources().isRTLMode()?"left":"right"):(s=this.m_rowHeader,n=this.getMappedStyle("rowheadercell"),o="row",r=this.getResources().isRTLMode()?"right":"left"),s.style.display="none",this.m_databody.style.display="none",this._shiftLabelsDir(this.m_headerLabels[o],e,t,r,o),this._shiftHeadersDirInContainer(s.firstChild,e,t,r,n,o),s.style.display="",this.m_databody.style.display=""},I.prototype._shiftLabelsDir=function(e,t,i,s,n){for(var o=0;o<e.length;o++){var r,l=e[o];if(o===i)if("column"===n||"columnEnd"===n)if(r=this.getElementHeight(l)+t,this.setElementHeight(l,r),"column"===n&&this._isHeaderLabelCollision()&&i===this.m_columnHeaderLevelCount-1){let e=["bottomResized"];this._highlightElement(this.m_corner,e)}else if("columnEnd"===n){let e=["topResized"],t=this._getLabel("columnEnd",this.m_columnEndHeaderLevelCount-1);t&&this._highlightElement(t,e)}else{let e="column"===n?["bottomResized"]:["topResized"];this._highlightElement(l,e)}else{r=this.getElementWidth(l)+t,this.setElementWidth(l,r);let e=this.getResources().isRTLMode()?["startResized"]:["endResized"],i=this.getResources().isRTLMode()?["endResized"]:["startResized"],s="row"===n?e:i;this._highlightElement(l,s);let o=this._getLabel("columnEnd",this.m_columnEndHeaderLevelCount-1);o&&this._highlightElement(o.parentNode,s)}o>i&&(r=this.getElementDir(l,s)+t,this.setElementDir(l,r,s))}},I.prototype._shiftHeadersDirInContainer=function(e,t,i,s,n,o){for(var r=e.childNodes,l=0;l<r.length;l++){var a,h,d=r[l];if(this.m_utils.containsCSSClassName(d,n)){a=this.getHeaderCellLevel(d);var c=this.getHeaderCellDepth(d);if(a<=i&&i<a+c){if("column"===o||"columnEnd"===o){if(h=this.getElementHeight(d)+t,this.setElementHeight(d,h),this.m_resizingElement){var m=this.getMappedStyle("colendheadercell");if(this.m_utils.containsCSSClassName(d,m)){let e=["topResized"];this._highlightElement(d,e)}else{let e=["bottomResized"];this._highlightElement(d,e)}}}else if(h=this.getElementWidth(d)+t,this.setElementWidth(d,h),this.m_resizingElement){var u=this.getMappedStyle("rowendheadercell");if(this.m_utils.containsCSSClassName(d,u)){let e=this.getResources().isRTLMode()?["endResized"]:["startResized"];this._highlightElement(d,e)}else{let e=this.getResources().isRTLMode()?["startResized"]:["endResized"];this._highlightElement(d,e)}}}else a>i&&(h=this.getElementDir(d,s)+t,this.setElementDir(d,h,s))}else if((a=this._getAttribute(d,"level",!0))<=i)this._shiftHeadersDirInContainer(d,t,i,s,n,o);else for(var _=d.getElementsByClassName(n),p=0;p<_.length;p++)h=this.getElementDir(_[p],s)+t,this.setElementDir(_[p],h,s)}},I.prototype.handleContextMenuResize=function(e,t,i,s){this.m_overResizeLeft=0,this.m_overResizeMinLeft=0,this.m_overResizeTop=0,this.m_overResizeMinTop=0,this.m_overResizeRight=0,this.m_overResizeBottom=0;var n=parseFloat(i,10),o=n-this.getElementWidth(s),r=n-this.getElementHeight(s);this.m_utils.containsCSSClassName(s,this.getMappedStyle("cell"))&&(s=t===this.m_resources.getMappedCommand("resizeHeight")?this.getHeaderFromCell(s,"row",!0):this.getHeaderFromCell(s,"column",!0)),this.m_resizingElement=s;let l=this.find(this.m_resizingElement,"headerlabel");var a=this.getElementWidth(s),h=this.getElementHeight(s),d=this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("endheadercell"))||this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("columnendheaderlabel"))||this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("rowendheaderlabel"));if(t===this.m_resources.getMappedCommand("resizeWidth")){if(a!==n)if("column"===this._getResizeHeaderMode(this.m_resizingElement)){if(this._isDOMElementResizable(this.m_resizingElement))if(l)this.resizeRowWidth(n,n-a,d,l),this._fireResizeEvent(e,a,h,n,h,n);else{let t=this.getNewElementWidth("column",a,d,o,l);this.resizeColWidth(a,t),this._resizeSelectedHeaders(e,a,h,n,h,n)}}else this.resizeRowWidth(n,n-a,d,l),this._fireResizeEvent(e,a,h,n,h,n)}else if(t===this.m_resources.getMappedCommand("resizeHeight")&&h!==n)if("column"===this._getResizeHeaderMode(this.m_resizingElement))this.resizeColHeight(n,n-h,d),this._fireResizeEvent(e,a,h,a,n,n);else if(this._isDOMElementResizable(this.m_resizingElement)){let t=this.getNewElementHeight("row",h,d,r,l);l?(this.resizeColHeight(t,t-h,d),this._fireResizeEvent(e,a,h,a,n,n)):(this.resizeRowHeight(h,t),this._resizeSelectedHeaders(e,a,h,a,t,n))}var c=this.getElementWidth(s),m=this.getElementHeight(s);c===a&&m===h||(this.buildCorners(),this.m_utils.isTouchDevice()&&this._moveTouchSelectionAffordance()),this._unhighlightResizeBorderColor(),this.m_resizingElement=null,this.m_resizingElementMin=null},I.prototype._getResizeNestedHeaderIndex=function(e,t){let i=this.getHeaderCellIndex(this.m_resizingElement),s=t?this.m_columnEndHeaderLevelCount:this.m_columnHeaderLevelCount,n=t?this.m_rowEndHeaderLevelCount:this.m_rowHeaderLevelCount;return("column"===e||"columnEnd"===e?s:n)>1&&this.m_resizingElement===this.m_resizingElement.parentNode.firstChild&&null!=this.m_resizingElement.nextSibling&&(i+=this._getAttribute(this.m_resizingElement.parentNode,"extent",!0)-1),i},I.prototype._highlightResizeMouseDown=function(){let e,t,i=this.getHeaderCellIndex(this.m_resizingElement),s=this._getResizeHeaderMode(this.m_resizingElement),n=this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("endheadercell"))||this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("columnendheaderlabel")),o=this.getResources().isRTLMode()?"right":"left",r=this.find(this.m_resizingElement,"headerlabel");if("col-resize"===this.m_cursor)if("column"===s)if(n=!r&&n,r)t=this.getHeaderLabelAxis(this.m_resizingElement),"column"===t||"columnEnd"===t?e=this.m_rowHeaderLevelCount-1:"row"!==t&&"rowEnd"!==t||(e=this.getHeaderLabelLevel(this.m_resizingElement)),this.resizeRowWidthsAndShift(0,e,n),n||(e===this.m_rowHeaderLevelCount-1||0===this.m_headerLabels.row.length&&this.m_headerLabels.column.length)&&this._highlightResizeLabelDirs("column",e);else{this.m_columnHeaderLevelCount>1&&this.m_resizingElement===this.m_resizingElement.parentNode.firstChild&&null!=this.m_resizingElement.nextSibling&&(i+=this._getAttribute(this.m_resizingElement.parentNode,"extent",!0)-1);let e,t=this.createIndex(-1,i),s=this.getElementsInRange(this.createRange(t,t));for(let t=0;t<s.length;t++)e=this.getResources().isRTLMode()?["startResized"]:["endResized"],this._highlightElement(s[t],e);this._shiftHeadersAlongAxisInContainer(this.m_colHeader.firstChild,i,0,o,this.getMappedStyle("colheadercell"),"column"),this._shiftHeadersAlongAxisInContainer(this.m_colEndHeader.firstChild,i,0,o,this.getMappedStyle("colendheadercell"),"column")}else"row"===s&&(this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("rowendheaderlabel"))&&(n=!0),r?(t=this.getHeaderLabelAxis(this.m_resizingElement),"column"===t||"columnEnd"===t?e=this.m_rowHeaderLevelCount-1:"row"!==t&&"rowEnd"!==t||(e=this.getHeaderLabelLevel(this.m_resizingElement))):e=this.getHeaderCellLevel(this.m_resizingElement)+(this.getHeaderCellDepth(this.m_resizingElement)-1),this.resizeRowWidthsAndShift(0,e,n),n||(e===this.m_rowHeaderLevelCount-1||0===this.m_headerLabels.row.length&&this.m_headerLabels.column.length)&&this._highlightResizeLabelDirs("column",e));else if("row-resize"===this.m_cursor)if("row"===s)if(r){let i=!0;t=this.getHeaderLabelAxis(this.m_resizingElement),"column"===t||"columnEnd"===t?e=this.getHeaderLabelLevel(this.m_resizingElement):"row"!==t&&"rowEnd"!==t||(e=this.m_columnHeaderLevelCount-1,i=!1),!n&&e===this.m_columnHeaderLevelCount-1&&this.m_headerLabels.row.length&&this._isHeaderLabelCollision()&&(i=!1),this.resizeColumnHeightsAndShift(0,e,n,i),n||(0===this.m_headerLabels.column.length||e===this.m_columnHeaderLevelCount-1&&this.m_headerLabels.row.length)&&this._highlightResizeLabelDirs("row",e)}else{this.m_rowHeaderLevelCount>1&&this.m_resizingElement===this.m_resizingElement.parentNode.firstChild&&null!=this.m_resizingElement.nextSibling&&(i+=this._getAttribute(this.m_resizingElement.parentNode,"extent",!0)-1);let e,t=this.createIndex(i,-1),s=this.getElementsInRange(this.createRange(t,t));for(let t=0;t<s.length;t++)e=["bottomResized"],this._highlightElement(s[t],e);this._shiftHeadersAlongAxisInContainer(this.m_rowHeader.firstChild,i,0,"top",this.getMappedStyle("rowheadercell"),"row"),this._shiftHeadersAlongAxisInContainer(this.m_rowEndHeader.firstChild,i,0,"top",this.getMappedStyle("rowendheadercell"),"row")}else{let i=!0;r?(t=this.getHeaderLabelAxis(this.m_resizingElement),"column"===t||"columnEnd"===t?e=this.getHeaderLabelLevel(this.m_resizingElement):"row"!==t&&"rowEnd"!==t||(e=this.m_columnHeaderLevelCount-1,i=!1)):(e=this.getHeaderCellLevel(this.m_resizingElement)+(this.getHeaderCellDepth(this.m_resizingElement)-1),t=this.getHeaderCellAxis(this.m_resizingElement)),!n&&e===this.m_columnHeaderLevelCount-1&&this.m_headerLabels.row.length&&this._isHeaderLabelCollision()&&(i=!1),this.resizeColumnHeightsAndShift(0,e,n,i),n||(0===this.m_headerLabels.column.length||e===this.m_columnHeaderLevelCount-1&&this.m_headerLabels.row.length)&&this._highlightResizeLabelDirs("row",e)}},I.prototype.handleResizeFitToContent=function(e,t,i){let s=this.find(t,"header")||this.find(t,"endheadercell"),n=this.m_utils.containsCSSClassName(t,this.getMappedStyle("endheadercell"));if(!s){let e=this.findCell(t);if(!e)return;t=this.getHeaderFromCell(e,i)}this.m_resizingElement=t;let o,r=this.m_resizingElement,l=this.getHeaderCellAxis(r);if("column"===l||"columnEnd"===l){let e=s?this._getResizeNestedHeaderIndex(l,n):this.getHeaderCellIndex(r);this.m_resizingElement=n?this._getHeaderByIndex(e,this.m_columnEndHeaderLevelCount-1,this.m_colEndHeader,this.m_columnEndHeaderLevelCount,this.m_startColEndHeader):this._getHeaderByIndex(e,this.m_columnHeaderLevelCount-1,this.m_colHeader,this.m_columnHeaderLevelCount,this.m_startColHeader);let t=this.calculateColumnHeaderWidth(this.m_resizingElement),i=this.createIndex(-1,e);o=this.getElementsInRange(this.createRange(i,i)),o.push(r);let a=this._calculateResizeFitToContentValue(o,"column");this.resizeColWidth(t,a)}else if("row"===l||"rowEnd"===l){let e=s?this._getResizeNestedHeaderIndex(l,n):this.getHeaderCellIndex(r);this.m_resizingElement=n?this._getHeaderByIndex(e,this.m_rowEndHeaderLevelCount-1,this.m_rowEndHeader,this.m_rowEndHeaderLevelCount,this.m_startRowEndHeader):this._getHeaderByIndex(e,this.m_rowHeaderLevelCount-1,this.m_rowHeader,this.m_rowHeaderLevelCount,this.m_startRowHeader);let t=this.calculateRowHeaderHeight(this.m_resizingElement),i=this.createIndex(e,-1);o=this.getElementsInRange(this.createRange(i,i)),o.push(r);let a=this._calculateResizeFitToContentValue(o,"row");this.resizeRowHeight(t,a)}this._unhighlightResizeBorderColor()},I.prototype._calculateResizeFitToContentValue=function(e,t){let i,s="height";"column"===t&&(s="width");let n=this._getMinValue(s,t,!1),o=document.createElement("div");if("width"===s){o.style.display="inline-flex",o.style.flexFlow="column nowrap",o.style.justifyContent="flex-start",o.style.alignItems="stretch";for(let t=0;t<e.length;t++){let i=e[t].cloneNode(!0);i.classList.remove(...i.classList),i.style[s]="",i.style.whiteSpace="nowrap !important",i.style.overflow="hidden",o.appendChild(i)}}else if("height"===s){o.style.display="flex";for(let t=0;t<e.length;t++){let i=e[t].cloneNode(!0);i.style[s]="",i.style.whiteSpace="break-spaces",o.appendChild(i)}}o.style.visibility="hidden",o.style.top="0px",this.m_root.appendChild(o);let r="column"===t?this.m_databody.offsetWidth:this.m_databody.offsetHeight,l="column"===t?this._getCellPaddingBorder(s,this.m_resizingElement):0;return i=("column"===t?Math.ceil(o.firstElementChild.getBoundingClientRect().width):Math.ceil(o.firstElementChild.getBoundingClientRect().height))+l,i=i<n?n:i,i=i>r?r:i,this.m_root.removeChild(o),i},I.prototype.getHeaderEdgePixels=function(e){var t,i,s=0,n=0;if(this.m_utils.isTouchDevice()){var o=this.findPos(e);s=o[0],n=o[1]}return this.m_utils.containsCSSClassName(e,this.getMappedStyle("colheadercell"))?(t=this.calculateColumnHeaderWidth(e),i=this.getElementHeight(e)):(t=this.getElementWidth(e),i=this.calculateRowHeaderHeight(e)),[s,n,s+t,n+i]},I.prototype.getHeaderLabelEdgePixels=function(e){var t,i,s=this.findPos(e),n=s[0],o=s[1];return this.m_utils.containsCSSClassName(e,this.getMappedStyle("columnheaderlabel"))?(t=this.calculateColumnHeaderWidth(e),i=this.getElementHeight(e)):(t=this.getElementWidth(e),i=this.calculateRowHeaderLabelHeight(e)),[n,o,n+t,o+i]},I.prototype.unhighlightSelection=function(){for(var e=this.GetSelection(),t=0;t<e.length;t+=1)this.unhighlightRange(e[t]);this.getResources()&&this._clearHeaderHighLight()},I.prototype.unhighlightRange=function(e){var t=this.getElementsInRange(e);this.unhighlightElems(t),this._applyBorderClassesAroundRange(t,e,!1,"Selected")},I.prototype.highlightRange=function(e,t){const i=this.getHeadersByRange(e,"row"),s=this.getHeadersByRange(e,"column");this._highlightHeaders(e,i,s);var n,o=this.getElementsInRange(e);(this.highlightElems(o,e),this._applyBorderClassesAroundRange(o,e,!0,"Selected"),t)&&(n=1===this.GetSelection().length?o.length:this._getCurrentSelectionCellCount(),this._setAccInfoText("accessibleMultiCellSelected",{num:n}))},I.prototype.getHeadersByRange=function(e,t){const i=new Set;let s,n,o,r;if("row"===t&&this.m_rowHeaderLevelCount>0){for(e.endIndex&&e.endIndex.row&&(r=e.endIndex.row),r?-1===r&&(r=this.m_endRowHeader):r=e.startIndex.row,n=Math.max(this.m_startRowHeader,e.startIndex.row);n<=r;n++)for(s=this._getHeadersByIndex(n,this.m_rowHeader,this.m_rowHeaderLevelCount,this.m_startRowHeader),o=0;o<s.length;o++)i.add(s[o])}else if("column"===t&&this.m_columnHeaderLevelCount>0){for(e.endIndex&&e.endIndex.column&&(r=e.endIndex.column),r?-1===r&&(r=this.m_endColHeader):r=e.startIndex.column,n=Math.max(this.m_startColHeader,e.startIndex.column);n<=r;n++)for(s=this._getHeadersByIndex(n,this.m_colHeader,this.m_columnHeaderLevelCount,this.m_startColHeader),o=0;o<s.length;o++)i.add(s[o])}if("row"===t&&this.m_rowEndHeaderLevelCount>0){for(e.endIndex&&e.endIndex.row&&(r=e.endIndex.row),r?-1===r&&(r=this.m_endRowHeader):r=e.startIndex.row,n=Math.max(this.m_startRowEndHeader,e.startIndex.row);n<=r;n++)for(s=this._getHeadersByIndex(n,this.m_rowEndHeader,this.m_rowEndHeaderLevelCount,this.m_startRowEndHeader),o=0;o<s.length;o++)i.add(s[o])}else if("column"===t&&this.m_columnEndHeaderLevelCount>0){for(e.endIndex&&e.endIndex.column&&(r=e.endIndex.column),r?-1===r&&(r=this.m_endColHeader):r=e.startIndex.column,n=Math.max(this.m_startColEndHeader,e.startIndex.column);n<=r;n++)for(s=this._getHeadersByIndex(n,this.m_colEndHeader,this.m_columnEndHeaderLevelCount,this.m_startColEndHeader),o=0;o<s.length;o++)i.add(s[o])}return i},I.prototype._highlightHeaders=function(e,t,i){t.forEach(t=>{const i=t[this.getResources().getMappedAttribute("context")];!e.endIndex.column||-1===e.endIndex.row&&-1===e.endIndex.column||-1===e.endIndex.column&&0===e.startIndex.column&&this._isHeaderSelected(i,"row")?(t.classList.remove(this.getMappedStyle("headerPartialSelected")),t.classList.add(this.getMappedStyle("headerAllSelected"))):(t.classList.remove(this.getMappedStyle("headerAllSelected")),t.classList.add(this.getMappedStyle("headerPartialSelected")))}),i.forEach(t=>{const i=t[this.getResources().getMappedAttribute("context")];-1===e.endIndex.row&&-1===e.endIndex.column||-1===e.endIndex.row&&0===e.startIndex.row&&this._isHeaderSelected(i,"column")?(t.classList.remove(this.getMappedStyle("headerPartialSelected")),t.classList.add(this.getMappedStyle("headerAllSelected"))):(t.classList.remove(this.getMappedStyle("headerAllSelected")),t.classList.add(this.getMappedStyle("headerPartialSelected")))})},I.prototype._isHeaderSelected=function(e,t){let i=!1;return this.GetSelection().forEach(s=>{e.index>=s.startIndex[t]&&e.index+(e.extent-1)<=s.endIndex[t]&&(i=!0)}),i},I.prototype._clearHeaderHighLight=function(){const e=this.m_root.querySelectorAll("."+this.getMappedStyle("headerPartialSelected"));for(let t=0;t<e.length;t++)e[t].classList.remove(this.getMappedStyle("headerPartialSelected"));const t=this.m_root.querySelectorAll("."+this.getMappedStyle("headerAllSelected"));for(let e=0;e<t.length;e++)t[e].classList.remove(this.getMappedStyle("headerAllSelected"))},I.prototype._getCurrentSelectionCellCount=function(){for(var e=0,t=this.GetSelection(),i=0;i<t.length;i++){var s=this.getElementsInRange(t[i]);null!=s&&(e+=s.length)}return e},I.prototype.unhighlightElems=function(e){if(null!=e&&0!==e.length)for(let t=0;t<e.length;t+=1){let i=e[t],s=["selected","topSelected","bottomSelected","startSelected","endSelected"];this._unhighlightElement(i,s)}},I.prototype.highlightElems=function(e){if(null!=e&&0!==e.length)for(let t=0;t<e.length;t+=1)this._highlightElement(e[t],["selected"])},I.prototype.applySelection=function(e,t,i,s){for(var n=this.GetSelection(),o=0;o<n.length;o+=1){var r=this.getElementsInRange(n[o],e,t,i,s);this.highlightElems(r),this._applyBorderClassesAroundRange(r,n[o],!0,"Selected")}},I.prototype.handleDatabodySelectionDrag=function(e){var t,i;if(this.m_utils.isTouchDevice()?t=this.findCell(document.elementFromPoint(e.touches[0].clientX,e.touches[0].clientY)):(i=e.target,t=this.findCell(i)),null!=t){var s=this.getCellIndexes(t);this.m_deselectInProgress?this.extendDeselection(s,e):this.isHeaderSelectionType(this.m_selectionFrontier)?this.extendSelectionHeader(t,e):this.extendSelection(s,e)}},I.prototype.handleHeaderClickSelection=function(e){var t,i,s,n,o=e.target,r=this.findHeader(o),l=e.shiftKey,a=this.isMultipleSelection(),h=this.m_utils.ctrlEquivalent(e);if(l&&a||!r||this._setActive(r,this._createActiveObject(r),e),null==this.m_active||"header"!==this.m_active.type&&!e.shiftKey)return!1;var d=r[this.getResources().getMappedAttribute("context")];if(t=d.axis,i=d.index,n=d.extent,h&&this._shouldDeselectHeader(i,n,t)){var c,m,u,_;-1!==t.indexOf("row")?(c=this.createIndex(i,0),m=this.createIndex(i+n-1,-1),_=this._getSelectionStartAndEnd(c,m,0),u=this.createRange(this.createIndex(_.min.row,0),this.createIndex(_.max.row,-1))):(c=this.createIndex(0,i),m=this.createIndex(-1,i+n-1),_=this._getSelectionStartAndEnd(c,m,0),u=this.createRange(this.createIndex(0,_.min.column),this.createIndex(-1,_.max.column)));var p=this._trimRangeForSelectionMode(u);return this.m_deselectInfo={anchor:p.startIndex,selection:this.GetSelection(),axis:-1!==t.indexOf("row")?"row":"column",sourceParent:r},void(this.m_deselectInProgress=this._deselectRange(p,e))}"header"===this.m_active.type&&(t=this.m_active.axis,i=this.m_active.index,s=this.m_active.level),this.m_utils.isTouchDevice()?(this._removeTouchSelectionAffordance(),this._selectHeader(t,i,s,e)):l&&a?(null==t&&(t=d.axis),(-1!==t.indexOf("row")&&-1!==d.axis.indexOf("row")||-1!==t.indexOf("column")&&-1!==d.axis.indexOf("column"))&&this.extendSelectionHeader(r,e)):2!==e.button&&this._selectHeader(t,i,s,e)},I.prototype.discontiguousHeaderSetActiveFromDatabody=function(e,t,i,s){var n=t.replace("End",""),o=this.m_selection[this.m_selection.length-1];this.unhighlightSelection(),o.startIndex.row===this.m_active.indexes.row&&o.endIndex.row===this.m_active.indexes.row&&o.startIndex.column===this.m_active.indexes.column&&o.endIndex.column===this.m_active.indexes.column&&this.m_selection.pop(),this._setActive(i,{type:"header",index:this.m_trueIndex[n],level:s-1,axis:t},e,!1),this.rehighlightSelection()},I.prototype.handleDragAnchorChange=function(e){if(this.m_headerDragState){var t,i,s=e.target,n=this.findHeader(s),o=n[this.getResources().getMappedAttribute("context")],r=this._getActiveElement(),l=r[this.getResources().getMappedAttribute("context")],a=this._getAttribute(r.parentNode,"start",!0),h=a+(this._getAttribute(r.parentNode,"extent",!0)-1);if(!o.extent)return;1===o.extent?(t=o.index,i=o.index):i=(t=this._getAttribute(n.parentNode,"start",!0))+(this._getAttribute(n.parentNode,"extent",!0)-1),1!==l.extent?(t<=a&&i>=h||t>=a&&i<=h)&&this._setActive(n,this._createActiveObject(n),e):t!==i&&t<=a&&a<=i&&this._setActive(n,this._createActiveObject(n),e)}},I.prototype.handleDatabodyClickSelection=function(e){var t,i=e.target,s=this.findCell(i);if(null!=s&&(t=this.getCellIndexes(s)),null!=t){if(this.isMultipleSelection()&&2===e.button&&this._isContainSelection(t))return;var n=this.m_utils.ctrlEquivalent(e),o=e.shiftKey;if(this.m_utils.containsCSSClassName(s,this.getMappedStyle("selected"))&&n){this.m_deselectInfo={anchor:t,selection:this.GetSelection()};var r=this.getCellEndIndexes(s),l=this._trimRangeForSelectionMode(this.createRange(t,r));return void(this.m_deselectInProgress=this._deselectRange(l,e))}this.isMultipleSelection()?(this._removeTouchSelectionAffordance(),this.m_utils.isTouchDevice()?(null!=this.m_active&&this._unhighlightActive(),this.selectAndFocus(t,e,!1)):n?this.selectAndFocus(t,e,!0):o?this.extendSelection(t,e):this.selectAndFocus(t,e,!1)):this.selectAndFocus(t,e,!1)}},I.prototype._doRangesOverlap=function(e,t){var i=e.startIndex,s=i.column,n=i.row,o=e.endIndex,r=o.column,l=o.row,a=t.startIndex,h=a.column,d=a.row,c=t.endIndex,m=c.column,u=c.row;return(s<=m||-1===m||void 0===m)&&(r>=h||-1===r||void 0===r)&&(n<=u||-1===u)&&(l>=d||-1===l)},I.prototype._isRangeValid=function(e){return(e.startIndex.row<=e.endIndex.row||e.startIndex.row>=0&&-1===e.endIndex.row)&&(e.startIndex.column<=e.endIndex.column||e.startIndex.column>=0&&-1===e.endIndex.column||void 0===e.startIndex.column&&void 0===e.endIndex.column)},I.prototype._deselectRange=function(e,t){var i=this.m_deselectInfo.selection,s=e.startIndex,n=s.column,o=s.row,r=e.endIndex,l=r.column,a=r.row,h=!1,d=[],c=0,m=[],u=this;return i.forEach(function(t){var i=t.startIndex,s=i.column,r=i.row,_=t.endIndex,p=_.column,g=_.row;if(this._doRangesOverlap(t,e)){var f,C,y=function(e,t,i){return new Promise(function(s){u._createRangeWithKeys(e,t,function(e){d[i]=e,s()})})};h=!0,r<o&&(f=this.createIndex(r,s),C=this.createIndex(o-1,p),this._isRangeValid({startIndex:f,endIndex:C})&&(m.push(y(f,C,c)),c+=1)),-1!==a&&(f=this.createIndex(a+1,s),C=this.createIndex(g,p),this._isRangeValid({startIndex:f,endIndex:C})&&(m.push(y(f,C,c)),c+=1)),s<n&&void 0!==s&&(f=this.createIndex(Math.max(o,r),s),C=this.createIndex(Math.min(-1===a?g:a,-1===g?a:g),n-1),this._isRangeValid({startIndex:f,endIndex:C})&&(m.push(y(f,C,c)),c+=1)),-1!==l&&void 0!==s&&(f=this.createIndex(Math.max(o,r),l+1),C=this.createIndex(Math.min(-1===a?g:a,-1===g?a:g),p),this._isRangeValid({startIndex:f,endIndex:C})&&(m.push(y(f,C,c)),c+=1))}else d[c]=t,c+=1},this),!!h&&(Promise.all(m).then(function(){var e=u.m_selection;u.SetSelection(d),u._compareSelectionAndFire(t,e)}),!0)},I.prototype._shouldDeselectHeader=function(e,t,i){var s,n,o=this.GetSelection();"row"===i||"rowEnd"===i?(s="row",n="column"):(s="column",n="row");var r=!1,l=this.m_options.getSelectionMode();return o.forEach(function(i){var o=i.startIndex[n],a=i.endIndex[n];if(0===o&&-1===a||"row"===l&&"row"===s){var h=i.startIndex[s],d=i.endIndex[s];h<=e&&(d>=e+t-1||-1===d)&&(r=!0)}}),r},I.prototype._handleSelectAll=function(e){return!(!this._isSelectionEnabled()||!this.isMultipleSelection())&&("row"===this.m_options.getSelectionMode()?this._selectRange(this.createIndex(0),this.createIndex(-1),e):this._selectRange(this.createIndex(0,0),this.createIndex(-1,-1),e),this.m_utils.isTouchDevice()&&this.m_topSelectIconContainer&&this.m_bottomSelectIconContainer&&(this.m_topSelectIconContainer.parentNode.removeChild(this.m_topSelectIconContainer),this.m_bottomSelectIconContainer.parentNode.removeChild(this.m_bottomSelectIconContainer)),!0)},I.prototype._isContainSelection=function(e,t){null==t&&(t=this.GetSelection());for(var i=0;i<t.length;i+=1){var s=t[i],n=s.startIndex,o=this.getEndIndex(s),r=n.row,l=o.row;if(e.row>=r&&(-1===l||e.row<=l)){var a=n.column,h=o.column;if(isNaN(a)||isNaN(h))return!0;if(e.column>=a&&(-1===h||e.column<=h))return!0}}return!1},I.prototype._isHeaderInsideSelection=function(e,t){const i=this.GetSelection();for(let s=0;s<i.length;s+=1){let n=i[s],o=n.startIndex,r=this.getEndIndex(n),l=o.row,a=r.row,h=o.column,d=r.column;if("column"===t||"columnEnd"===t){if(e>=h&&(-1===d||e<=d)&&0===l&&-1===a)return!0}else if(("row"===t||"rowEnd"===t)&&e>=l&&(-1===a||e<=a)&&0===h&&-1===d)return!0}return!1},I.prototype._getContainedSelectionCssClass=function(e,t){var i=[],s={contains:!1,class:[]};null==t&&(t=this.GetSelection());for(var n=0;n<t.length;n+=1){var o=t[n],r=o.startIndex,l=this.getEndIndex(o),a=r.row,h=l.row;if(e.row>=a&&(-1===h||e.row<=h)){e.row===a&&i.push("topSelected"),e.row===h&&i.push("bottomSelected");var d=r.column,c=l.column;(isNaN(d)||isNaN(c))&&(s.contains=!0,s.class=i),e.column>=d&&(-1===c||e.column<=c)&&(s.contains=!0,s.class=i)}}return s},I.prototype._compareSelections=function(e,t){if(e.length!==t.length)return!1;for(var i=0;i<e.length;i+=1){for(var s=!1,n=0;n<t.length;n+=1)this._compareIndividualSelectionObjects(e[i],t[n])&&(s=!0);if(!1===s)return!1}return!0},I.prototype._compareIndividualSelectionObjects=function(e,t){return e.startIndex.row===t.startIndex.row&&e.startIndex.column===t.startIndex.column&&e.endIndex.row===t.endIndex.row&&e.endIndex.column===t.endIndex.column},I.prototype._clearSelection=function(e){this.unhighlightSelection(),this._removeTouchSelectionAffordance();var t=this.GetSelection();this.m_selection=[],this._compareSelectionAndFire(e,t)},I.prototype.setDiscontiguousSelectionMode=function(e){this.m_discontiguousSelection=e,this._setAccInfoText(e?"accessibleRangeSelectModeOn":"accessibleRangeSelectModeOff")},I.prototype._selectEntireRow=function(e,t,i){var s=this.createIndex(e,0),n=this.createIndex(t,-1),o=this._getSelectionStartAndEnd(s,n,0);"row"===this.m_options.getSelectionMode()?this._selectRange(this.createIndex(o.min.row),this.createIndex(o.max.row),i):this._selectRange(this.createIndex(o.min.row,0),this.createIndex(o.max.row,-1),i)},I.prototype._selectEntireColumn=function(e,t,i){var s=this.createIndex(0,e),n=this.createIndex(-1,t),o=this._getSelectionStartAndEnd(s,n,0);this._selectRange(this.createIndex(0,o.min.column),this.createIndex(-1,o.max.column),i)},I.prototype._selectRange=function(e,t,i){this.unhighlightSelection(),this._createRangeWithKeys(e,t,this._selectRangeCallback.bind(this,i))},I.prototype._selectRangeCallback=function(e,t){var i,s=this.GetSelection();(i=this.m_discontiguousSelection||!e||this.m_utils.ctrlEquivalent(e)&&this.isMultipleSelection()&&0===e.button?s.slice(0):[]).push(t),this.m_selection=i,this.rehighlightSelection(),this._isDatabodyCellActive()&&e.target[this.getResources().getMappedAttribute("context")]&&!e.target[this.getResources().getMappedAttribute("context")].axis&&!this.m_selectionFrontier.axis&&(this.m_selectionFrontier=this.m_active.indexes,this._highlightActive()),this._compareSelectionAndFire(e,s)},I.prototype.rehighlightSelection=function(){for(var e=0;e<this.m_selection.length;e++)this.highlightRange(this.m_selection[e])},I.prototype.GetSelection=function(){return null==this.m_selection&&(this.m_selection=[]),this.m_selection},I.prototype.SetSelection=function(e){void 0!==e&&(null===e&&(e=[]),this.unhighlightSelection(),this.m_selection=e,this._resetHeaderHighLight(),null!=this.m_databody&&this.applySelection(this.m_startRow,this.m_endRow,this.m_startCol,this.m_endCol),this.m_bottomFloodFillIconContainer&&(1===this.m_selection.length?this._moveFloodFillAffordance():this._removeFloodFillAffordance()))},I.prototype.fireSelectionEvent=function(e,t){var i={event:e,ui:{selection:this.GetSelection(),previousSelection:t}};this.fireEvent("select",i)},I.prototype.extendSelection=function(e,t,i){if("header"!==this.m_active.type){var s;if(this.m_utils.isTouchDevice())s=this.m_touchSelectAnchor;else s={row:this.m_active.indexes.row,column:this.m_active.indexes.column};if(null!=s){this._resetSelectionFrontierFocus();var n=this._updateSelectionFrontier(s,e,i),o=n.min,r=n.max;if("row"===this.m_options.getSelectionMode()&&(o=this.createIndex(o.row),r=this.createIndex(r.row)),this.m_discontiguousSelection&&(this.m_deselectInProgress||this._isContainSelection(s,this.GetSelection().slice(0,-1)))){this.m_deselectInProgress||(this.m_deselectInfo={anchor:s,selection:this.GetSelection()});var l=this._trimRangeForSelectionMode(this.createRange(o,r));this.m_deselectInProgress=this._deselectRange(l,t)}else this._createRangeWithKeys(o,r,this._extendSelectionCallback.bind(this,t,s))}}},I.prototype.extendDeselection=function(e,t){var i=this.m_deselectInfo.anchor,s=this._updateSelectionFrontier(i,e),n=s.min,o=s.max,r=this._trimRangeForSelectionMode(this.createRange(n,o));this._deselectRange(r,t)},I.prototype.extendSelectionHeader=function(e,t,i,s){if(null!==e){var n=this.findCellOrHeader(e);if(null!==n){var o,r,l,a,h,d=n[this.getResources().getMappedAttribute("context")];if(null==i&&(i=this.m_discontiguousSelection),d){if(d.cell)a=l=-1!==this.m_selectionFrontier.axis.indexOf("column")?d.indexes.column:d.indexes.row,h=l;else{if(this.m_selectionFrontier&&d.index===this.m_selectionFrontier.index&&d.level===this.m_selectionFrontier.level)return;1===d.extent?(l=d.index,a=d.index,h=d.index):a=(l=this._getAttribute(e.parentNode,"start",!0))+(this._getAttribute(e.parentNode,"extent",!0)-1)}var c=s?this.m_deselectInfo.sourceParent:this._getActiveElement();if(c){var m,u,_,p=c[this.getResources().getMappedAttribute("context")];if(s?(r=this.m_deselectInfo.axis,o=this.m_deselectInfo.anchor[r],u=(m=this._getAttribute(c.parentNode,"start",!0))+(this._getAttribute(c.parentNode,"extent",!0)-1)):this.m_utils.isTouchDevice()?(-1===(o=-1!==this.m_selectionFrontier.axis.indexOf("column")?this.m_touchSelectAnchor.column:this.m_touchSelectAnchor.row)&&(o=0),m=o,u=o,r=this.m_selectionFrontier.axis):(u=(m=this._getAttribute(c.parentNode,"start",!0))+(this._getAttribute(c.parentNode,"extent",!0)-1),"header"===this.m_active.type&&(r=this.m_active.axis,o=this.m_active.index)),"cell"===this.m_active.type?(_=1,o=-1!==(r=d.axis).indexOf("row")?this.m_active.indexes.row:this.m_active.indexes.column):_=p.extent,i&&!s){var g=this.m_selection[this.m_selection.length-1];this.unhighlightSelection(),g&&this.checkCorners(r,o,g)&&this.m_selection.pop()}if(1!==_?l<=m&&a>=u||l>=m&&a<=u?(this.m_headerDragState||this._setActive(n,this._createActiveObject(n),t),o=l,h=a):l>m&&a>u?(o=m,h=a):l<m&&a<u&&(o=l,h=u):1===_&&l!==a&&(l<=o&&o<=a?(this.m_headerDragState||"cell"===this.m_active.type||this._setActive(n,this._createActiveObject(n),t),o=l,h=a):l<=o&&a<=o?(h=o,o=l):l>=o&&a>=o&&(h=a)),d.cell?this.setHeaderSelectionFrontier(r,h,h,this.m_selectionFrontier.level,n,!0):this.setHeaderSelectionFrontier(r,h,d.index,d.level,n,!0),!s&&r)-1!==r.indexOf("column")?this._selectEntireColumn(o,h,t):-1!==r.indexOf("row")&&this._selectEntireRow(o,h,t);else{var f,C=Math.min(o,h),y=Math.max(o,h);f=null!=r&&-1!==r.indexOf("row")?this.createRange(this.createIndex(C,0),this.createIndex(y,-1)):this.createRange(this.createIndex(0,C),this.createIndex(-1,y));var v=this._trimRangeForSelectionMode(f);this._deselectRange(v,t)}}}}}},I.prototype._updateSelectionFrontier=function(e,t,i){var s,n,o;if("row"===this.m_options.getSelectionMode()?(s=this.createIndex(e.row,this.m_startCol),n=this.createIndex(t.row,this.m_endCol)):(s=e,n=t),null!=i){if(this.m_deselectInProgress)o=this.createRange(this.m_deselectInfo.anchor,this.m_selectionFrontier);else{var r=this.GetSelection();o=r[this._getLastAnchoredSelectionIndex(r,s)]}var l=o.startIndex,a=o.endIndex;l.row===this.m_selectionFrontier.row&&s.row!==l.row?s.row=a.row:a.row===this.m_selectionFrontier.row&&s.row!==a.row&&(s.row=l.row),l.column===this.m_selectionFrontier.column&&s.column!==l.column?s.column=a.column:a.column===this.m_selectionFrontier.column&&s.column!==a.column&&(s.column=l.column)}var h=this._getSelectionStartAndEnd(s,n,0),d=n;if(null!=i){var c=h.min,m=h.max;for("row"===this.m_options.getSelectionMode()&&(c=this.createIndex(c.row),m=this.createIndex(m.row));this._compareIndividualSelectionObjects(o,this.createRange(c,m));){if(i===this.keyCodes.LEFT_KEY){if(0===n.column)break;n.column-=1}else if(i===this.keyCodes.RIGHT_KEY){if(n.column===this.m_endCol)break;n.column+=1}else if(i===this.keyCodes.UP_KEY){if(0===n.row)break;n.row-=1}else{if(i!==this.keyCodes.DOWN_KEY)break;if(n.row===this.m_endRow)break;n.row+=1}c=(h=this._getSelectionStartAndEnd(s,n,0)).min,m=h.max,"row"===this.m_options.getSelectionMode()&&(c=this.createIndex(c.row),m=this.createIndex(m.row))}i===this.keyCodes.LEFT_KEY?(d.column=c.column<s.column?c.column:m.column,d.row=c.row<s.row?c.row:m.row):i===this.keyCodes.RIGHT_KEY?(d.column=m.column>s.column?m.column:c.column,d.row=c.row<s.row?c.row:m.row):i===this.keyCodes.UP_KEY?(d.row=c.row<s.row?c.row:m.row,d.column=c.column<s.column?c.column:m.column):i===this.keyCodes.DOWN_KEY&&(d.row=m.row>s.row?m.row:c.row,d.column=c.column<s.column?c.column:m.column)}else d=this.getCellIndexes(this._getCellByIndex(d));return"row"===this.m_options.getSelectionMode()&&(d=this.createIndex(d.row,this.m_active.indexes.column)),this.m_selectionFrontier=d,h},I.prototype._getMinOrMax=function(e,t,i){return isNaN(e)?isNaN(t)?null:t:isNaN(t)?e:i(e,t)},I.prototype._getSelectionStartAndEnd=function(e,t,i){var s=this.getElementsInRange(this.createRange(e,t));if(null==s||s.length===i)return{min:e,max:t};for(var n={row:this._getMinOrMax(e.row,t.row,Math.min),column:this._getMinOrMax(e.column,t.column,Math.min)},o={row:this._getMinOrMax(e.row,t.row,Math.max),column:this._getMinOrMax(e.column,t.column,Math.max)},r=0;r<s.length;r++){var l=this.getCellIndexes(s[r]),a=this.getCellEndIndexes(s[r]);(l.row<n.row||null==n.row)&&(n.row=l.row),(l.column<n.column||null==n.column)&&(n.column=l.column),(a.row>o.row||null==o.row)&&(o.row=a.row),(a.column>o.column||null==o.column)&&(o.column=a.column)}return this._getSelectionStartAndEnd(n,o,s.length)},I.prototype._getLastAnchoredSelectionIndex=function(e,t){var i;for(i=e.length-1;i>-1;i--)if(this._isContainSelection(t,[e[i]]))return i;return i-1},I.prototype._extendSelectionCallback=function(e,t,i){var s=this.GetSelection(),n=this._getLastAnchoredSelectionIndex(s,t),o=s[n];if(null!=o){var r=o.startIndex.row===i.startIndex.row;null!=o.startIndex.column&&null!=i.startIndex.column&&(r=r&&o.startIndex.column===i.startIndex.column);var l=o.endIndex.row===i.endIndex.row;if(null!=o.endIndex.column&&null!=i.endIndex.column&&(l=l&&o.endIndex.column===i.endIndex.column),!r||!l){var a;if(this.m_discontiguousSelection||e&&this.m_utils.ctrlEquivalent(e)&&0===e.button?(a=s.slice(0),this.unhighlightRange(o),a.splice(n,1)):(a=[],this.unhighlightSelection()),a.push(i),this.m_selection=a,this.m_discontiguousSelection||e&&this.m_utils.ctrlEquivalent(e)&&0===e.button)for(var h=0;h<this.m_selection.length;h++)this.highlightRange(this.m_selection[h]);else this.highlightRange(i,!0);this._makeSelectionFrontierFocus(),this._compareSelectionAndFire(e,s)}}},I.prototype._resetSelectionFrontierFocus=function(){if(!(null==this.m_selectionFrontier||this._isDatabodyCellActive()&&this.m_selectionFrontier.row===this.m_active.indexes.row&&this.m_selectionFrontier.column===this.m_active.indexes.column)){var e=this.createRange(this.m_selectionFrontier),t=this.getElementsInRange(e);null!=t&&t.length>0&&this._unsetAriaProperties(t[0])}},I.prototype._makeSelectionFrontierFocus=function(){if(!(null==this.m_selectionFrontier||this._isDatabodyCellActive()&&this.m_selectionFrontier.row===this.m_active.indexes.row&&this.m_selectionFrontier.column===this.m_active.indexes.column)){if(this._isDatabodyCellActive()){var e=this.createRange(this.m_active.indexes),t=this.getElementsInRange(e);null!=t&&t.length>0&&this._unsetAriaProperties(t[0])}var i=this.createRange(this.m_selectionFrontier),s=this.getElementsInRange(i);if(null!=s&&0!==s.length){this._updateContextInfo(this.m_selectionFrontier);var n=this.m_utils.containsCSSClassName(s[0],this.getMappedStyle("row"))?s[0].firstChild:s[0];this._setAriaProperties(this._createActiveObject(n),null,n)}}},I.prototype._selectHeader=function(e,t,i,s){var n,o;if(-1!==e.indexOf("row")&&this.m_rowHeaderLevelCount-1===i||-1!==e.indexOf("column")&&this.m_columnHeaderLevelCount-1===i)n=t,o=t;else{var r=this._getActiveElement();o=(n=this._getAttribute(r.parentNode,"start",!0))+(this._getAttribute(r.parentNode,"extent",!0)-1)}-1!==e.indexOf("row")?((n===o&&!this.isMultipleSelection()||this.isMultipleSelection())&&(this.setHeaderSelectionFrontier(e,o,t,i,s.target,!0),this._selectEntireRow(n,o,s)),this._setAccInfoText("accessibleRowSelected",{row:t+1})):-1!==e.indexOf("column")&&(this.setHeaderSelectionFrontier(e,o,t,i,s.target,!0),this._selectEntireColumn(n,o,s),this._setAccInfoText("accessibleColumnSelected",{column:t+1})),this.isMultipleSelection()&&(this.m_headerDragState=!0)},I.prototype.setHeaderSelectionFrontier=function(e,t,i,s,n,o){o&&(this.m_selectionFrontier={}),this.m_selectionFrontier.axis=e,this.m_selectionFrontier.end=t,this.m_selectionFrontier.index=i,this.m_selectionFrontier.level=s,this.m_selectionFrontier.target=n},I.prototype._resetHeaderHighLight=function(){this.GetSelection().forEach(e=>{var t=this.getHeadersByRange(e,"row"),i=this.getHeadersByRange(e,"column");this._highlightHeaders(e,t,i)})},I.prototype.updateSelectionHeader=function(){this.m_selectionFrontier&&this.m_selectionFrontier.target&&(this.m_utils.isTouchDevice()&&this.m_selection.length&&(this.m_touchSelectAnchor=this.m_selection[this.m_selection.length-1].startIndex),this.extendSelectionHeader(this.m_selectionFrontier.target,null)),this._resetHeaderHighLight()},I.prototype.selectAndFocus=function(e,t,i){null==i&&(i=!1),this._resetSelectionFrontierFocus(),this._setActiveByIndex(e,t),"row"===this.m_options.getSelectionMode()&&(e=this.createIndex(e.row));var s=this._getSelectionStartAndEnd(e,e,0),n=s.min,o=s.max;"row"===this.m_options.getSelectionMode()&&(n=this.createIndex(n.row),o=this.createIndex(o.row)),this._createRangeWithKeys(n,o,this._selectAndFocusRangeCallback.bind(this,n,t,i))},I.prototype._selectAndFocusRangeCallback=function(e,t,i,s){var n=this.GetSelection(),o=n.slice(0);if(!i)if(this.m_discontiguousSelection||!t||this.isMultipleSelection()&&this.m_utils.ctrlEquivalent(t)&&0===t.button){if(this._isDatabodyCellActive()&&null!=this.m_prevActive&&"cell"===this.m_prevActive.type&&this.m_selectionFrontier.row===this.m_prevActive.indexes.row&&this.m_selectionFrontier.column===this.m_prevActive.indexes.column&&!this.m_utils.isTouchDevice()&&(t.keyCode||!this.isMultipleSelection())){o.pop();var r=this._getContainedSelectionCssClass(this.m_prevActive.indexes,o);if(r.contains){var l=r.class;if(l.length){var a=[];-1===l.indexOf("topSelected")&&a.push("topSelected"),-1===l.indexOf("bottomSelected")&&a.push("bottomSelected"),this._unhighlightElement(this._getCellByIndex(this.m_prevActive.indexes),a)}else this._unhighlightElement(this._getCellByIndex(this.m_prevActive.indexes),["topSelected","bottomSelected"])}else this._unhighlightElement(this._getCellByIndex(this.m_prevActive.indexes),["selected","topSelected","bottomSelected"])}}else this.unhighlightSelection(),o=[];this.m_selectionFrontier=e,o.push(s),this.m_selection=o,this.highlightRange(s),this._compareSelectionAndFire(t,n)},I.prototype._compareSelectionAndFire=function(e,t){var i=this.GetSelection();this.isMultipleSelection()&&i.length>0&&(this.m_utils.isTouchDevice()?(this._addTouchSelectionAffordance(e),this._moveTouchSelectionAffordance()):this.m_options.isFloodFillEnabled()&&this._isSelectionEnabled()&&!this.m_discontiguousSelection&&"cell"===this.m_active.type&&(this._addFloodfillAffordance(e),this._moveFloodFillAffordance())),this._compareSelections(i,t)||(this._resetHeaderHighLight(),this.fireSelectionEvent(e,t))},I.prototype._addTouchSelectionAffordance=function(e){if(null==this.m_topSelectIconContainer&&null==this.m_bottomSelectIconContainer){var t=e.target,i=this.findCell(t);if(i||(i=this.findHeader(t)),!i)return;this.m_topSelectIconContainer=document.createElement("div"),this.m_topSelectIconContainer.className=this.getMappedStyle("toucharea");var s=document.createElement("div");s.className=this.getMappedStyle("selectaffordance"),s.setAttribute("role","button"),s.setAttribute("aria-label",this.getResources().getTranslatedText("accessibleSelectionAffordanceTop")),this.m_topSelectIconContainer.appendChild(s),this.m_bottomSelectIconContainer=document.createElement("div"),this.m_bottomSelectIconContainer.className=this.getMappedStyle("toucharea");var n=document.createElement("div");n.className=this.getMappedStyle("selectaffordance"),n.setAttribute("role","button"),n.setAttribute("aria-label",this.getResources().getTranslatedText("accessibleSelectionAffordanceBottom")),this.m_bottomSelectIconContainer.appendChild(n),this.m_databody.firstChild.appendChild(this.m_topSelectIconContainer),this.m_databody.firstChild.appendChild(this.m_bottomSelectIconContainer),this.m_touchSelectionAffordanceHeight=this.m_topSelectIconContainer.firstElementChild.offsetHeight,this.m_touchSelectionAffordanceWidth=this.m_topSelectIconContainer.firstElementChild.offsetWidth}},I.prototype._addRoundedAffordanceClasses=function(e,t,i,s){if(e&&t)i||"row"!==s?i||"column"!==s?(e.classList.add(this.getMappedStyle("selectaffordancetopcornerbounded")),t.classList.add(this.getMappedStyle("selectaffordancebottomcornerbounded"))):(e.classList.add(this.getMappedStyle("selectaffordancetopcolumn")),t.classList.add(this.getMappedStyle("selectaffordancebottomcolumn"))):(e.classList.add(this.getMappedStyle("selectaffordancetoprow")),t.classList.add(this.getMappedStyle("selectaffordancebottomrow")));else if(t){let e;e=i||"row"!==s?i||"column"!==s?"selectaffordancebottomcornerbounded":"selectaffordancebottomcolumn":"selectaffordancebottomrow",t.classList.add(this.getMappedStyle(e))}},I.prototype._clearRoundedAffordanceClasses=function(e,t){e&&(e.classList.remove(this.getMappedStyle("selectaffordancetopcornerbounded")),e.classList.remove(this.getMappedStyle("selectaffordancetopcolumn")),e.classList.remove(this.getMappedStyle("selectaffordancetoprow"))),t.classList.remove(this.getMappedStyle("selectaffordancebottomcornerbounded")),t.classList.remove(this.getMappedStyle("selectaffordancebottomcolumn")),t.classList.remove(this.getMappedStyle("selectaffordancebottomrow"))},I.prototype._removeTouchSelectionAffordance=function(e){(this._isDatabodyCellActive()||e)&&this.m_topSelectIconContainer&&this.m_topSelectIconContainer.parentNode&&(this.m_topSelectIconContainer.parentNode.removeChild(this.m_topSelectIconContainer),this.m_bottomSelectIconContainer.parentNode.removeChild(this.m_bottomSelectIconContainer))},I.prototype._moveTouchSelectionAffordance=function(){var e,t,i=this.getResources().isRTLMode()?"right":"left",s=this.GetSelection();if(s.length>0){var n=this.m_options.getSelectionMode(),o=this._getTouchSelectionAffordanceSize();if(null!=this.m_topSelectIconContainer&&null!=this.m_bottomSelectIconContainer){var r=this.m_topSelectIconContainer.firstElementChild,l=this.m_bottomSelectIconContainer.firstElementChild;if(this._clearRoundedAffordanceClasses(r,l),"row"===n||-1!==s[s.length-1].endIndex.row&&-1===s[s.length-1].endIndex.column){this._addRoundedAffordanceClasses(r,l,!1,"row");const n=this.getElementWidth(this.m_databody)/2+this.m_currentScrollLeft-o/2;let a;if(this.setElementDir(this.m_topSelectIconContainer,n,i),this.setElementDir(this.m_bottomSelectIconContainer,n,i),e=this._getAxisCellsByKey(s[s.length-1].startKey.row,"row"),(t=this._getAxisCellsByKey(s[s.length-1].endKey.row,"row"))&&t.length&&(a=t[0]),!a){let e=this.createIndex(-1,0),t=this.getElementsInRange(this.createRange(e,e));a=t[t.length-1]}this.setElementDir(this.m_topSelectIconContainer,this.getElementDir(e[0],"top")-this.m_touchSelectionAffordanceHeight-1,"top"),this.setElementDir(this.m_bottomSelectIconContainer,this.getElementDir(a,"top")+this.getElementHeight(a)-o+this.m_touchSelectionAffordanceHeight,"top")}else if(-1!==s[s.length-1].endIndex.column&&-1===s[s.length-1].endIndex.row){this._addRoundedAffordanceClasses(r,l,!1,"column"),e=this._getAxisCellsByKey(s[s.length-1].startKey.column,"column"),t=this._getAxisCellsByKey(s[s.length-1].endKey.column,"column");var a=this.getElementHeight(this.m_databody)/2+this.m_currentScrollTop-o/2;this.setElementDir(this.m_topSelectIconContainer,a,"top"),this.setElementDir(this.m_bottomSelectIconContainer,a,"top"),this.setElementDir(this.m_topSelectIconContainer,this.getElementDir(e[0],"left")-this.m_touchSelectionAffordanceWidth-2,"left"),this.setElementDir(this.m_bottomSelectIconContainer,this.getElementDir(t[0],"left")+this.getElementWidth(t[0])-(o-this.m_touchSelectionAffordanceWidth-1),"left")}else{this._addRoundedAffordanceClasses(r,l,!0);var h=this._getCellByIndex(s[s.length-1].startIndex),d=this._getCellByIndex(s[s.length-1].endIndex);if(!d){let e=this.createIndex(-1,-1),t=this.getElementsInRange(this.createRange(e,e));d=t[t.length-1]}this.setElementDir(this.m_topSelectIconContainer,this.getElementDir(h,"top")-this.m_touchSelectionAffordanceHeight-1,"top"),this.setElementDir(this.m_bottomSelectIconContainer,this.getElementDir(d,"top")+this.getElementHeight(d)-o+this.m_touchSelectionAffordanceWidth,"top"),this.setElementDir(this.m_topSelectIconContainer,this.getElementDir(h,i)-this.m_touchSelectionAffordanceWidth-2,i),this.setElementDir(this.m_bottomSelectIconContainer,this.getElementDir(d,i)+this.getElementWidth(d)-(o-this.m_touchSelectionAffordanceWidth),i)}null==this.m_topSelectIconContainer.parentNode&&(this.m_databody.firstChild.appendChild(this.m_topSelectIconContainer),this.m_databody.firstChild.appendChild(this.m_bottomSelectIconContainer))}}},I.prototype._scrollTouchSelectionAffordance=function(){var e,t,i=this.m_options.getSelectionMode();if("row"===i)null!=this.m_topSelectIconContainer&&(t=this.getResources().isRTLMode()?"right":"left",e=this.getElementWidth(this.m_databody)/2+this.m_currentScrollLeft,this.setElementDir(this.m_topSelectIconContainer,e,t),this.setElementDir(this.m_bottomSelectIconContainer,e,t));else if("cell"===i&&this.isHeaderSelectionType(this.m_selectionFrontier)&&null!=this.m_topSelectIconContainer)if(-1!==this.m_selectionFrontier.axis.indexOf("row"))t=this.getResources().isRTLMode()?"right":"left",e=this.getElementWidth(this.m_databody)/2+this.m_currentScrollLeft,this.setElementDir(this.m_topSelectIconContainer,e,t),this.setElementDir(this.m_bottomSelectIconContainer,e,t);else{var s=this.getElementHeight(this.m_databody)/2+this.m_currentScrollTop;this.setElementDir(this.m_topSelectIconContainer,s,"top"),this.setElementDir(this.m_bottomSelectIconContainer,s,"top")}},I.prototype._getTouchSelectionAffordanceSize=function(){if(null==this.m_touchSelectionAffordanceSize){var e=document.createElement("div");e.className=this.getMappedStyle("toucharea"),e.style.visibilty="hidden",e.style.top="0px",e.style.visibilty="0px",this.m_root.appendChild(e);var t=e.offsetWidth;this.m_root.removeChild(e),this.m_touchSelectionAffordanceSize=t}return this.m_touchSelectionAffordanceSize},I.SORT_ANIMATION_DURATION=800,I.prototype._handleSortContainerMouseOver=function(e){var t=e.target,i=this.findHeader(t),s=this._getSortIcon(i);this.m_utils.containsCSSClassName(e.currentTarget,this.getMappedStyle("sortIcon"))&&(this.m_utils.addCSSClassName(e.currentTarget,this.getMappedStyle("hover")),this.m_utils.addCSSClassName(s,this.getMappedStyle("hover")),this.m_utils.addCSSClassName(s,this.getMappedStyle("enabled")),this.m_utils.removeCSSClassName(s,this.getMappedStyle("disabled")))},I.prototype._handleSortMouseOut=function(e){if(!this._databodyEmpty()){var t,i=e.target,s=e.relatedTarget,n=this.findHeader(i);null!=n&&null!=s&&n===this.findHeader(s)||this._displaySortIcon(n),(t=this._getSortIcon(n))&&(this.m_utils.removeCSSClassName(t,this.getMappedStyle("hover")),this.m_utils.containsCSSClassName(t,this.getMappedStyle("selected"))||(this.m_utils.addCSSClassName(t,this.getMappedStyle("disabled")),this.m_utils.removeCSSClassName(t,this.getMappedStyle("enabled"))));var o=this._getSortContainer(n);o&&(this.m_utils.removeCSSClassName(o,this.getMappedStyle("hover")),this.m_utils.removeCSSClassName(o,this.getMappedStyle("selected")))}},I.prototype._handleSortIconMouseDown=function(e){this._databodyEmpty()||(this.m_utils.addCSSClassName(e,this.getMappedStyle("selected")),this.m_utils.removeCSSClassName(e,this.getMappedStyle("disabled")))},I.prototype._toggleSortIconDirection=function(e,t){if(null!=e){var i=this._getSortIcon(e);"descending"===t&&(this.m_utils.containsCSSClassName(i,this.getMappedStyle("sortascending"))||this.m_utils.containsCSSClassName(i,this.getMappedStyle("sortdefault")))?(this.m_utils.removeCSSClassName(i,this.getMappedStyle("sortascending")),this.m_utils.removeCSSClassName(i,this.getMappedStyle("sortdefault")),this.m_utils.addCSSClassName(i,this.getMappedStyle("sortdescending"))):"ascending"===t&&(this.m_utils.containsCSSClassName(i,this.getMappedStyle("sortdescending"))||this.m_utils.containsCSSClassName(i,this.getMappedStyle("sortdefault")))?(this.m_utils.removeCSSClassName(i,this.getMappedStyle("sortdescending")),this.m_utils.removeCSSClassName(i,this.getMappedStyle("sortdefault")),this.m_utils.addCSSClassName(i,this.getMappedStyle("sortascending"))):"default"===t&&(this.m_utils.removeCSSClassName(i,this.getMappedStyle("sortdescending")),this.m_utils.removeCSSClassName(i,this.getMappedStyle("sortascending")),this.m_utils.addCSSClassName(i,this.getMappedStyle("sortdefault")))}},I.prototype._displaySortIcon=function(e){var t=!1;if(null!=e){var i=this._getSortIcon(e);null!=this.m_sortInfo&&(t=this.m_sortInfo.key===this._getKey(e)),t&&this.m_utils.addCSSClassName(i,this.getMappedStyle("default"))}},I.prototype._buildSortIcon=function(e,t,i){var s=document.createElement("div");this.m_utils.addCSSClassName(s,this.getMappedStyle("iconContainer")),this.m_utils.addCSSClassName(s,this.getMappedStyle("sortIcon"));var n=document.createElement("div"),o=this.getMappedStyle("icon")+" "+this.getMappedStyle("clickableicon"),r=null!=this.m_sortInfo&&this.m_sortInfo.axis===i?this.m_sortInfo.key:null;if(e.key===r){var l=null!=this.m_sortInfo&&this.m_sortInfo.axis===i?this.m_sortInfo.direction:null;"ascending"===l?(n.className=this.getMappedStyle("sortascending")+" "+o,t.setAttribute(this.getResources().getMappedAttribute("sortDir"),l)):"descending"===l?(n.className=this.getMappedStyle("sortdescending")+" "+o,t.setAttribute(this.getResources().getMappedAttribute("sortDir"),l)):n.className=this.getMappedStyle("sortdefault")+" "+o}else o+=" "+this.getMappedStyle("disabled"),n.className=this.getMappedStyle("sortdefault")+" "+o;return s.appendChild(n),s.addEventListener("mouseover",this._handleSortContainerMouseOver.bind(this)),s},I.prototype._handleKeyboardSort=function(e,t){if(!this._databodyEmpty()){var i=e.getAttribute(this.getResources().getMappedAttribute("sortDir"));i=null==i||"descending"===i?"ascending":"descending",this._doHeaderSort(t,e,i)}},I.prototype._handleHeaderSort=function(e,t){if(!this._databodyEmpty()){var i=e.target,s=this.findHeader(i);null!=s&&(null==t&&(t=null!=this.m_sortInfo&&this.m_sortInfo.key===this._getKey(s)&&"ascending"===this.m_sortInfo.direction?"descending":"ascending"),this._doHeaderSort(e,s,t))}},I.prototype._handleCellSort=function(e,t,i){null==i||this._databodyEmpty()||(this._removeTouchSelectionAffordance(),this._doHeaderSort(e,i,t))},I.prototype._doHeaderSort=function(e,t,i){if(!0!==this.m_isSorting){this.m_delayedSort=null;var s=this._getKey(t),n=this._getAxis(t);if(this._removeSortSelection(),t.setAttribute(this.getResources().getMappedAttribute("sortDir"),i),this.m_sortInfo={event:e,key:s,axis:n,direction:i,header:t},this._toggleSortIconDirection(t,i),this._addSortSelection(),this._setAccInfoText("ascending"===i?"accessibleSortAscending":"accessibleSortDescending",{id:s}),null!=i&&null!=s&&null!=n)if(this._isDataGridProvider())this._fireSortRequestEvent(n);else{this.m_isSorting=!0,this.showStatusText();var o={axis:n,key:s,direction:i};this.getDataSource().sort(o,{success:this._handleSortSuccess.bind(this),error:this._handleSortError.bind(this)})}}else this.m_delayedSort={event:e,header:t,direction:i}},I.prototype._handleSortError=function(){this.hideStatusText()},I.prototype._removeSortSelection=function(){if(null!=this.m_sortInfo){var e;(e="column"===this.m_sortInfo.axis?this._findHeaderByKey(this.m_sortInfo.key,this.m_colHeader,this.getMappedStyle("colheadercell")):this._findHeaderByKey(this.m_sortInfo.key,this.m_rowHeader,this.getMappedStyle("rowheadercell"))).removeAttribute(this.getResources().getMappedAttribute("sortDir"));var t=this._getSortIcon(e);this._toggleSortIconDirection(e,"default"),"descending"===this.m_sortInfo.direction&&(this.m_utils.removeCSSClassName(t,this.getMappedStyle("sortdescending")),this.m_utils.addCSSClassName(t,this.getMappedStyle("sortascending"))),this.m_utils.addCSSClassName(t,this.getMappedStyle("disabled")),this.m_utils.removeCSSClassName(t,this.getMappedStyle("enabled")),this.m_utils.removeCSSClassName(t,this.getMappedStyle("default")),this.m_utils.removeCSSClassName(t,this.getMappedStyle("selected")),this.m_utils.removeCSSClassName(this._getSortContainer(e),this.getMappedStyle("enabled"))}},I.prototype._addSortSelection=function(){if(null!=this.m_sortInfo){var e;e="column"===this.m_sortInfo.axis?this._findHeaderByKey(this.m_sortInfo.key,this.m_colHeader,this.getMappedStyle("colheadercell")):this._findHeaderByKey(this.m_sortInfo.key,this.m_rowHeader,this.getMappedStyle("rowheadercell"));var t=this._getSortIcon(e);this.m_utils.addCSSClassName(t,this.getMappedStyle("default")),this.m_utils.removeCSSClassName(t,this.getMappedStyle("disabled")),this.m_utils.addCSSClassName(t,this.getMappedStyle("selected"))}},I.prototype._getAxis=function(e){var t=this.getMappedStyle("colheadercell"),i=this.getMappedStyle("rowheadercell");return this.m_utils.containsCSSClassName(e,t)?"column":this.m_utils.containsCSSClassName(e,i)?"row":null},I.prototype._handleSortSuccess=function(){this.hideStatusText(),this._isDatabodyCellActive()?this._indexes({row:this.m_active.keys.row,column:this.m_active.keys.column},this._handlePreSortScrolling):this._fetchForSort(this.m_startRow,this.m_endRow-this.m_startRow+1,!1)},I.prototype._handlePreSortScrolling=function(e){var t=(-1===e.row?0:e.row)*this.m_avgRowHeight,i=t+this.m_avgRowHeight,s=this._isHighWatermarkScrolling();if(this.m_currentScrollTop<=t&&i<=this.m_currentScrollTop+this.getElementHeight(this.m_databody)||s)this._fetchForSort(this.m_startRow,this.m_endRow-this.m_startRow+1,!1);else{this.m_currentScrollTop=Math.min(t,this._getMaxScrollHeight());var n=Math.floor(this.m_currentScrollTop/this.m_avgRowHeight),o=n*this.m_avgRowHeight;this.m_startRow=n,this.m_endRow=-1,this.m_startRowHeader=n,this.m_endRowHeader=-1,this.m_startRowPixel=o,this.m_endRowPixel=o,this.m_startRowHeaderPixel=o,this.m_endRowHeaderPixel=o,this._fetchForSort(n,null,!0)}},I.prototype._fetchForSort=function(e,t,i){var s=document.createDocumentFragment(),n=document.createDocumentFragment();this.fetchHeaders("row",e,s,n,t,{success:this.handleHeadersFetchSuccessForSort.bind(this),error:this.handleCellsFetchError}),this.fetchCells(this.m_databody,e,this.m_startCol,t,this.m_endCol-this.m_startCol+1,{success:this.handleCellsFetchSuccessForSort.bind(this,s,n,i),error:this.handleCellsFetchError})},I.prototype.handleHeadersFetchSuccessForSort=function(e,t,i,s){var n,o,r,l,a,h,d,c=t.axis,m=t.start,u=t.header,_=t.endHeader;if(this.m_fetching[c]=!1,null!=e){for(n=e.getCount(),l=0,o=0,h=this.getMappedStyle("headercell")+" "+this.getMappedStyle("rowheadercell"),d=this.getRendererOrTemplate("row");n-o>0;)r=m+o,o+=(a=this.buildLevelHeaders(u,r,0,0,this.m_startRowPixel+l,!0,s,d,e,"row",h,this.m_rowHeaderLevelCount)).count,l+=a.totalHeaderDimension;this.m_endRowHeader=this.m_startRowHeader+(n-1),this.m_endRowHeaderPixel=this.m_startRowHeaderPixel+l}if(null!=i){for(n=i.getCount(),l=0,o=0,h=this.getMappedStyle("endheadercell")+" "+this.getMappedStyle("rowendheadercell"),d=this.getRendererOrTemplate("rowEnd");n-o>0;)r=m+o,o+=(a=this.buildLevelHeaders(_,r,0,0,this.m_startRowPixel+l,!0,s,d,i,"rowEnd",h,this.m_rowEndHeaderLevelCount)).count,l+=a.totalHeaderDimension;this.m_endRowEndHeader=this.m_startRowEndHeader+(n-1),this.m_endRowEndHeaderPixel=this.m_startRowEndHeaderPixel+l}this._signalTaskEnd()},I.prototype.handleCellsFetchSuccessForSort=function(e,t,i,s,n){var o;this.m_fetching.cells=!1;var r=I.SORT_ANIMATION_DURATION;this.isFetchComplete()&&this.hideStatusText();var l=n[0].start,a=s.getCount("row"),h=n[1].start,c=document.createDocumentFragment(),m=this._addCellsToFragment(c,s,l,this.m_startRowPixel,h,this.m_startColPixel);this.m_endRow=this.m_startRow+(a-1),this.m_endRowPixel=this.m_startRowPixel+m.totalRowHeight;var u=this.m_databody.firstChild,_=this.m_rowHeader.firstChild,p=this.m_rowEndHeader.firstChild;if(!0===i&&(o=this._isHighWatermarkScrolling(),this.m_utils.isTouchDevice()?(this._disableTouchScrollAnimation(),this.scrollTo(this.m_currentScrollLeft,this.m_currentScrollTop)):(this.m_silentScroll=!0,this.m_databody.scrollTop=this.m_currentScrollTop,this._syncScroller())),!r||!this.m_utils.supportsTransitions()||1===a||this.m_rowHeaderLevelCount>1&&null!=this.m_rowHeaderLevelCount||!1===o)this._signalTaskStart(),this._handleSortEnd(c,e,t);else if(this.m_isCustomElementCallback()){this._signalTaskStart("processing sort render");let i=document.createElement("div"),s=document.createElement("div"),n=document.createElement("div");i.setAttribute(this.getResources().getMappedAttribute("busyContext"),""),s.setAttribute(this.getResources().getMappedAttribute("busyContext"),""),n.setAttribute(this.getResources().getMappedAttribute("busyContext"),""),i.className=this.getMappedStyle("info"),s.className=this.getMappedStyle("info"),n.className=this.getMappedStyle("info"),i.appendChild(c),s.appendChild(e),n.appendChild(t),this.m_root.appendChild(i),this.m_root.appendChild(s),this.m_root.appendChild(n);var g=d.getContext(i).getBusyContext().whenReady(),f=d.getContext(s).getBusyContext().whenReady(),C=d.getContext(n).getBusyContext().whenReady();Promise.all([g,f,C]).then(function(){for(;i.childNodes.length>0;)c.appendChild(i.childNodes[0]);for(;s.childNodes.length>0;)e.appendChild(s.childNodes[0]);for(;n.childNodes.length>0;)t.appendChild(n.childNodes[0]);this.m_root.removeChild(i),this.m_root.removeChild(s),this.m_root.removeChild(n),this._signalTaskEnd(),this.processSortAnimationToPosition(r,0,"ease-in",_,e,u,c,p,t)}.bind(this))}else this.processSortAnimationToPosition(r,0,"ease-in",_,e,u,c,p,t);this._signalTaskEnd()},I.prototype._handleSortEnd=function(e,t,i,s,n,o){var r;if(t.childNodes.length>1){if(r=this.m_rowHeader.firstChild,n)for(let e=0;e<n.length;e++){let i=n[e];t.insertBefore(i.element,t.childNodes[i.index])}this.m_utils.empty(r),r.appendChild(t),this.m_subtreeAttachedCallback(r)}if(i.childNodes.length>1){if(r=this.m_rowEndHeader.firstChild,o)for(let e=0;e<o.length;e++){let t=o[e];i.insertBefore(t.element,i.childNodes[t.index])}this.m_utils.empty(r),r.appendChild(i),this.m_subtreeAttachedCallback(r)}var l=this.m_databody.firstChild,a=this.m_rowHeader.firstChild,h=this.m_rowEndHeader.firstChild;if(s)for(let t=0;t<s.length;t++)e.appendChild(s[t]);this._emptyDatabody(l),this._populateDatabody(l,e),this._fireSortEvent(),this._restoreActive(),this.m_isSorting=!1,this._doDelayedSort(),this.m_animating=!1;for(let e=0;e<l.childNodes.length;e++)this.removeTransformMoveStyle(l.childNodes[e]);if(-1!==this.m_endRowHeader)for(let e=0;e<a.childNodes.length;e++)this.removeTransformMoveStyle(a.childNodes[e]);if(-1!==this.m_endRowEndHeader)for(let e=0;e<h.childNodes.length;e++)this.removeTransformMoveStyle(h.childNodes[e]);this._signalTaskEnd(),this._runModelEventQueue()},I.prototype.processSortAnimationToPosition=function(e,t,i,s,n,o,r,l,a){var h,d,c,m,u,_,p,g,f,C,y=this;this._signalTaskStart();var v=n.childNodes.length>1,E=a.childNodes.length>1,S=this.getResources().isRTLMode()?"right":"left",w=this._getViewportBottom(),H=this._getViewportLeft(),b=this._getViewportRight(),x={},R={},M=[];for(m=0;m<o.childNodes.length;m++)u=o.childNodes[m],h=this._getKey(u,"row"),C=(f=this.getElementDir(u,S))+this.getElementWidth(u),_=(d=this.getElementDir(u,"top"))+this.getElementHeight(u),this._isCellBoundaryInViewport(f,C,d,_)&&(x[h]?x[h].cell.push(u):(c=w,x[h]={cell:[u],oldTop:d,newTop:c}),c-d!=0&&(g=u));for(m=0;m<s.childNodes.length;m++)v&&(u=s.childNodes[m],h=this._getKey(u,"row"),_=(d=this.getElementDir(u,"top"))+this.getElementHeight(u),this._isCellBoundaryInViewport(H,b,d,_)&&(c=w,x[h]||(x[h]={oldTop:d,newTop:c}),x[h].rowHeader=u));for(m=0;m<l.childNodes.length;m++)v&&(u=l.childNodes[m],h=this._getKey(u,"row"),_=(d=this.getElementDir(u,"top"))+this.getElementHeight(u),this._isCellBoundaryInViewport(H,b,d,_)&&(c=w,x[h]||(x[h]={oldTop:d,newTop:c}),x[h].rowEndHeader=u));for(m=0;m<r.childNodes.length;m++)u=r.childNodes[m],h=this._getKey(u,"row"),c=this.getElementDir(u,"top"),x[h]?x[h].newTop=c:(d=w,p=c+this.getElementHeight(u),C=(f=this.getElementDir(u,S))+this.getElementWidth(u),this._isCellBoundaryInViewport(f,C,c,p)&&(this.changeStyleProperty(u,this.getCssSupport("transform"),"translate3d(0px,"+d+"px,0px)"),M.push(u),R[h]?R[h].cell.push(u):R[h]={cell:[u],oldTop:d,newTop:c,add:!0},c-d!=0&&(g=u)));for(let e=0;e<M.length;e++)o.appendChild(M[e]);var I=[];for(m=0;m<n.childNodes.length;m++)if(v){var A=n.childNodes[m];h=this._getKey(A,"row"),x[h]||(p=(c=this.getElementDir(A,"top"))+this.getElementHeight(A),d=w,this._isCellBoundaryInViewport(H,b,c,p)&&(this.changeStyleProperty(A,this.getCssSupport("transform"),"translate3d(0px,"+d+"px,0px)"),I.push({element:A,index:m}),R[h]||(R[h]={oldTop:d,newTop:c,add:!0}),R[h].rowHeader=A))}for(let e=0;e<I.length;e++)s.appendChild(I[e].element);var L=[];for(m=0;m<a.childNodes.length;m++)if(E){var D=a.childNodes[m];h=this._getKey(D,"row"),x[h]||(p=(c=this.getElementDir(D,"top"))+this.getElementHeight(D),d=w,this._isCellBoundaryInViewport(H,-1,c,p)&&(this.changeStyleProperty(D,this.getCssSupport("transform"),"translate3d(0px,"+d+"px,0px)"),L.push({element:D,index:m}),R[h].rowEndHeader=D,R[h]||(R[h]={oldTop:d,newTop:c,add:!0})))}for(let e=0;e<L.length;e++)l.appendChild(L[e].element);if(null!=g){var T=this._handleSortEnd.bind(this,r,n,a,M,I,L);y._onTransitionEnd(g,T,e),this.m_animating=!0,setTimeout(function(){var s,n,o,r,l=0,a=Object.keys(x);for(r=0;r<a.length;r++){if(h=a[r],o=x[a[r]],n=t+"ms",s=o.newTop-o.oldTop,o.cell)for(l=0;l<o.cell.length;l++)y.addTransformMoveStyle(o.cell[l],e/2+"ms",n,i,0,s,0);v&&o.rowHeader&&y.addTransformMoveStyle(o.rowHeader,e/2+"ms",n,i,0,s,0),E&&o.rowEndHeader&&y.addTransformMoveStyle(o.rowEndHeader,e/2+"ms",n,i,0,s,0)}for(a=Object.keys(R),r=0;r<a.length;r++){if(h=a[r],o=R[a[r]],n=t*l+"ms",s=0,o.cell)for(var d=0;d<o.cell.length;d++)y.addTransformMoveStyle(o.cell[d],e/2+"ms",n,i,0,s,0);v&&o.rowHeader&&y.addTransformMoveStyle(o.rowHeader,e/2+"ms",n,i,0,s,0),E&&o.rowEndHeader&&y.addTransformMoveStyle(o.rowEndHeader,e/2+"ms",n,i,0,s,0)}},0)}else this._handleSortEnd(r,n,a)},I.prototype._restoreActive=function(){if(null!=this.m_active){var e=this.m_active.axis,t=this.m_sortInfo.originalEvent;if("cell"===this.m_active.type){var i=this._getCellByKeys(this.m_active.keys);if(null!=i){var s=this.getCellIndexes(i);this._isSelectionEnabled()?this.selectAndFocus(s,t):this._setActiveByIndex(s,t)}else this._setActive(null,null,t,!0),this._isSelectionEnabled()&&this._clearSelection(t)}else if("row"===e||"rowEnd"===e){var n="row"===e?this.m_rowHeader:this.m_rowEndHeader,o="row"===e?this.getMappedStyle("rowheadercell"):this.getMappedStyle("rowendheadercell"),r=this._findHeaderByKey(this.m_active.key,n,o);if(null!=r){var l=r[this.getResources().getMappedAttribute("context")];this._setActive(r,{type:"header",axis:e,index:l.index,key:l.key,level:l.level},t)}else this._setActive(null,null,t)}}},I.prototype._getSortIcon=function(e){return e.lastChild.firstChild},I.prototype._getSortContainer=function(e){return e.lastChild},I.prototype._fireSortEvent=function(){var e={event:this.m_sortInfo.event,ui:{header:this.m_sortInfo.key,direction:this.m_sortInfo.direction}};this.fireEvent("sort",e)},I.prototype._fireSortRequestEvent=function(){let e=this.m_sortInfo.header[this.getResources().getMappedAttribute("context")],t=this.m_sortInfo.header[this.getResources().getMappedAttribute("metadata")],i=this.buildHeaderTemplateContext(e,t).item;var s={event:this.m_sortInfo.event,ui:{direction:this.m_sortInfo.direction,item:i,axis:this.m_sortInfo.axis}};this.fireEvent("sortRequest",s)},I.prototype._doDelayedSort=function(){null!=this.m_delayedSort?this._doHeaderSort(this.m_delayedSort.event,this.m_delayedSort.header,this.m_delayedSort.direction):this.fillViewport()},I.prototype._fireExpandRequestEvent=function(e){const t=this.findHeader(e.target),i=t[this.getResources().getMappedAttribute("context")],s=t[this.getResources().getMappedAttribute("metadata")],n={item:this.buildHeaderTemplateContext(i,s).item,axis:i.axis},o=this._getDisclosureIcon(t);this.m_utils.removeCSSClassName(o,this.getMappedStyle("collapsed")),this.m_utils.addCSSClassName(o,this.getMappedStyle("expanded")),this.fireEvent("expandRequest",n)},I.prototype._fireCollapseRequestEvent=function(e){const t=this.findHeader(e.target),i=t[this.getResources().getMappedAttribute("context")],s=t[this.getResources().getMappedAttribute("metadata")],n={item:this.buildHeaderTemplateContext(i,s).item,axis:i.axis},o=this._getDisclosureIcon(t);this.m_utils.removeCSSClassName(o,this.getMappedStyle("expanded")),this.m_utils.addCSSClassName(o,this.getMappedStyle("collapsed")),this.fireEvent("collapseRequest",n)},I.prototype._handleExpandCollapseRequest=function(e){this._isHeaderExpanded(e.target)?this._fireCollapseRequestEvent(e):this._isHeaderCollapsed(e.target)&&this._fireExpandRequestEvent(e)},I.prototype._isTargetExpandCollapseEnabled=function(e){return this._isHeaderCollapsed(e)||this._isHeaderExpanded(e)},I.prototype._isHeaderCollapsed=function(e){const t=this._getDisclosureIcon(e);return!!t&&this.m_utils.containsCSSClassName(t,this.getMappedStyle("collapsed"))},I.prototype._isHeaderExpanded=function(e){const t=this._getDisclosureIcon(e);return!!t&&this.m_utils.containsCSSClassName(t,this.getMappedStyle("expanded"))},I.prototype._buildDisclosureIcon=function(e){const t=document.createElement("div");t.classList.add(this.getMappedStyle("iconContainer")),t.classList.add(this.getMappedStyle("disclosureIcon"));const i=document.createElement("div");let s;return i.classList.add(this.getMappedStyle("icon")),i.classList.add(this.getMappedStyle("clickableicon")),"expanded"===e.metadata.expanded?(i.classList.add(this.getMappedStyle("expanded")),s=this.getResources().getTranslatedText("collapsedText")):"collapsed"===e.metadata.expanded&&(i.classList.add(this.getMappedStyle("collapsed")),s=this.getResources().getTranslatedText("expandedText")),t.setAttribute("title",s),t.appendChild(i),t.addEventListener("mouseover",this._handleExpandCollapseContainerMouseOver.bind(this)),t.addEventListener("mouseout",this._handleDisclosureMouseOut.bind(this)),t},I.prototype._handleExpandCollapseContainerMouseOver=function(e){const t=e.target,i=this.findHeader(t),s=this._getDisclosureIcon(i);this.m_utils.containsCSSClassName(e.currentTarget,this.getMappedStyle("disclosureIcon"))&&(this.m_utils.addCSSClassName(e.currentTarget,this.getMappedStyle("hover")),this.m_utils.addCSSClassName(s,this.getMappedStyle("hover")),this.m_utils.addCSSClassName(s,this.getMappedStyle("enabled")),this.m_utils.removeCSSClassName(s,this.getMappedStyle("disabled")))},I.prototype._buildSpacer=function(e){const t=document.createElement("span");return this._addDataGridSpacerClass(t),this._addIndentation(e,t),t},I.prototype._getTreeDepth=function(e){return e.metadata.treeDepth?e.metadata.treeDepth:null},I.prototype._addDataGridSpacerClass=function(e){this.m_utils.addCSSClassName(e,this.getMappedStyle("spacer"))},I.prototype._isLeaf=function(e){return!e.metadata.expanded||null===e.metadata.expanded},I.prototype._addIndentation=function(e,t){let i=this._getTreeDepth(e);null!==i&&this._appendSpacerClass(i,t,e)},I.prototype._appendSpacerClass=function(e,t,i){t.style.width=e*I.SPACER_DEFAULT_WIDTH+(this._isLeaf(i)?I.SPACER_DEFAULT_WIDTH:0)+"rem"},I.prototype._handleDisclosureMouseOut=function(e){const t=e.target,i=this.findHeader(t),s=this._getDisclosureIcon(i);this.m_utils.containsCSSClassName(e.currentTarget,this.getMappedStyle("disclosureIcon"))&&(this.m_utils.removeCSSClassName(e.currentTarget,this.getMappedStyle("hover")),this.m_utils.removeCSSClassName(s,this.getMappedStyle("hover")),this.m_utils.removeCSSClassName(s,this.getMappedStyle("enabled")))},I.prototype._isDisclosureIcon=function(e){return this.m_utils.containsCSSClassName(e,this.getMappedStyle("icon"))},I.prototype._getDisclosureIcon=function(e){return this.m_utils.containsCSSClassName(e,this.getMappedStyle("icon"))?e:e.getElementsByClassName(this.getMappedStyle("icon"))[0]},I.prototype._getDisclosureIconContainer=function(e){return e.firstChild};const A=function(e){this.datagridprovider=e,this.pendingHeaderCallback={},this._registerEventListeners(),this.totalRowCount=-1,this.totalColumnCount=-1,this.rowKeyMap=new T,this.columnKeyMap=new T,A.superclass.constructor.call(this)};function L(e,t,i){this.results=e,this.rowKeyMap=t,this.columnKeyMap=i,this.databodyResults=e.results.databody,this.rowStart=this.results.rowOffset,this.rowCount=this.results.rowCount,this.rowEnd=this.rowStart+this.rowCount-1,this.columnStart=this.results.columnOffset,this.columnCount=this.results.columnCount,this.columnEnd=this.columnStart+this.columnCount-1,this.lastItem=null}function D(e,t,i){this.results=e,this.axis=t,this.axisResults=e.results[this.axis+"Header"],this.axisLabels=e.results[this.axis+"HeaderLabel"],"row"===this.axis||"rowEnd"===this.axis?(this.start=this.results.rowOffset,this.count=this.results.rowCount):(this.start=this.results.columnOffset,this.count=this.results.columnCount),this.end=this.start+this.count-1,this.lastItem=null,this.keyMap=i,this.levelCount=null}function T(){this.keyMap=new Map,this.nextKey=0,this.set=(e,t,i,s)=>{const n=""+this.nextKey;null==s&&(s=1);for(let o=0;o<s;o++){let s=null==t?t:t+o,r=this.pairIndexLevel(e,s,i);this.keyMap.set(r,n)}return this.nextKey+=1,n},this.get=(e,t,i,s)=>{const n=this.pairIndexLevel(e,t,i);let o=this.keyMap.get(n);return null==o&&(o=this.set(e,t,i,s)),o},this.pairIndexLevel=(e,t,i)=>null==t||null!=i&&t===i-1?""+e:e+","+t,this.handleChange=(e,t)=>{let i=new Set;e.forEach(function(e){let t=e.offset,s=e.count;for(var n=0;n<s;n++)i.add(t+n)});let s=Array.from(i);s.sort(function(e,t){return e-t});let n=new Map;this.keyMap.forEach((e,i)=>{let o=i.split(","),r=parseInt(o[0],10),l=o[1];if(t&&s.some(e=>e===r))return;let a=0;if(r>=s[0]){let e=r;a=s.findIndex(i=>(!t&&e>=i&&(e+=1),i>e)),-1===a&&(a=s.length)}let h=t?r-a:r+a,d=this.pairIndexLevel(h,l);n.set(d,e)}),this.keyMap=n}}a.Object.createSubclass(A,a.DataGridDataSource,"DataGridProviderDataGridDataSource"),A.prototype.fetchHeaders=function(e,t,i){if(null!=t){var s=e.axis,n={headerRange:e,callbacks:t,callbackObjects:i};this.pendingHeaderCallback[s]=n}},A.prototype.fetchCells=function(e,t,i){let s,n,o,r;for(let t=0;t<e.length;t+=1){let i=e[t];"row"===i.axis?(s=i.start,n=i.count):"column"===i.axis&&(o=i.start,r=i.count)}let l,a=this.pendingHeaderCallback.row,h=this.pendingHeaderCallback.column;this.pendingHeaderCallback={},l=a&&h?["all"]:a?["databody","rowHeader","rowEndHeader","rowHeaderLabel","rowEndHeaderLabel"]:h?["databody","columnHeader","columnEndHeader","columnHeaderLabel","columnEndHeaderLabel"]:["databody"];let d={rowOffset:s,columnOffset:o,rowCount:n,columnCount:r,fetchRegions:new Set(l)},c=(s,n)=>{let o,r,l;null!=n?(s.results=Object.assign({},s.results,n.results),null!=n.next&&(o=n.next)):null!=s.next&&(o=s.next),this.totalRowCount=s.totalRowCount,this.totalColumnCount=s.totalColumnCount;let d=s.results;if(h&&(!o||null!=d.columnHeader&&null!=d.columnEndHeader&&null!=d.columnHeaderLabel&&null!=d.columnEndHeaderLabel)&&(r=h.callbacks,null!=r&&null!=r.success)){let e,t;l=h.callbackObjects,null!=d.columnHeader&&(e=new D(s,"column",this.columnKeyMap)),null!=d.columnEndHeader&&(t=new D(s,"columnEnd",this.columnKeyMap)),r.success.call(l.success,e,h.headerRange,t)}if(a&&(!o||null!=d.rowHeader&&null!=d.rowEndHeader&&null!=d.rowHeaderLabel&&null!=d.rowEndHeaderLabel)&&(r=a.callbacks,null!=r&&null!=r.success)){let e,t;l=a.callbackObjects,null!=d.rowHeader&&(e=new D(s,"row",this.rowKeyMap)),null!=d.rowEndHeader&&(t=new D(s,"rowEnd",this.rowKeyMap)),r.success.call(l.success,e,a.headerRange,t)}if(null!=t&&null!=t.success&&!o){let n=new L(s,this.rowKeyMap,this.columnKeyMap);t.success.call(i.success,n,e)}o&&o.then(c.bind(this,s))};this.datagridprovider.fetchByOffset(d).then(c)},A.prototype.getCapability=function(e){return"sort"===e?"full":"sort"===e||"move"===e?"none":null},A.prototype.getCount=function(e){return"row"===e?this.totalRowCount:"column"===e?this.totalColumnCount:-1},A.prototype.getCountPrecision=function(){return"exact"},A.prototype.indexes=function(){return{row:-1,column:-1}},A.prototype.keys=function(){return{row:null,column:null}},A.prototype.move=function(){},A.prototype.moveOK=function(){return"invalid"},A.prototype.sort=function(){},A.prototype._registerEventListeners=function(){this._addListener=this._handleDataGridProviderAddEvent.bind(this),this._removeListener=this._handleDataGridProviderRemoveEvent.bind(this),this._updateListener=this._handleDataGridProviderUpdateEvent.bind(this),this._refreshListener=this._handleDataGridProviderRefreshEvent.bind(this),this.datagridprovider.addEventListener("add",this._addListener),this.datagridprovider.addEventListener("remove",this._removeListener),this.datagridprovider.addEventListener("update",this._updateListener),this.datagridprovider.addEventListener("refresh",this._refreshListener)},A.prototype._handleDataGridProviderAddEvent=function(e){var t={source:this,operation:"insert",detail:e.detail};("row"===e.detail.axis?this.rowKeyMap:this.columnKeyMap).handleChange(e.detail.ranges,!1),this.handleEvent("change",t)},A.prototype._handleDataGridProviderRemoveEvent=function(e){var t={source:this,operation:"delete",detail:e.detail};("row"===e.detail.axis?this.rowKeyMap:this.columnKeyMap).handleChange(e.detail.ranges,!0),this.handleEvent("change",t)},A.prototype._handleDataGridProviderUpdateEvent=function(e){var t={source:this,operation:"update",detail:e.detail};this.handleEvent("change",t)},A.prototype._handleDataGridProviderRefreshEvent=function(){this.rowKeyMap=new T,this.columnKeyMap=new T;var e={source:this,operation:"refresh"};this.handleEvent("change",e)},L.prototype.getData=function(e){return this._findItemByIndex(e.row,e.column).data},L.prototype.getMetadata=function(e){let t=this._findItemByIndex(e.row,e.column);return{metadata:t.metadata,keys:{row:this.rowKeyMap.get(t.rowIndex),column:this.columnKeyMap.get(t.columnIndex)}}},L.prototype.getCount=function(e){if(null!=this.databodyResults){if("row"===e)return this.rowCount;if("column"===e)return this.columnCount}return 0},L.prototype.getExtent=function(e){let t=!1,i=!1,s=!1,n=!1,o=this._findItemByIndex(e.row,e.column),r=o.rowIndex,l=o.rowExtent,a=r+l-1,h=o.columnIndex,d=o.columnExtent,c=h+d-1;return r<this.rowStart&&(l-=this.rowStart-r,t=!0),a>this.rowEnd&&(l-=a-this.rowEnd,i=!0),h<this.columnStart&&(d-=this.columnStart-h,s=!0),c>this.columnEnd&&(d-=c-this.columnEnd,n=!0),{row:{extent:l,more:{before:t,after:i}},column:{extent:d,more:{before:s,after:n}}}},L.prototype._findItemByIndex=function(e,t){let i=i=>{let s=i.rowIndex,n=i.rowExtent,o=i.columnIndex,r=i.columnExtent;return e>=s&&e<s+n&&t>=o&&t<o+r};return null!=this.lastItem&&i(this.lastItem)||(this.lastItem=this.databodyResults.find(i)),this.lastItem},D.prototype.getData=function(e,t){return this._findItemByIndexLevel(e,t).data},D.prototype.getMetadata=function(e,t){let i=this._findItemByIndexLevel(e,t),s=i.metadata.sortDirection;return null!=s&&(s="unsorted"===i.metadata.sortDirection?null:s),{metadata:i.metadata,key:this.keyMap.get(i.index,i.level,this.getLevelCount(),i.depth),sortDirection:s}},D.prototype.getLevelCount=function(){if(null==this.levelCount){let e=0;null!=this.axisResults&&this.axisResults.forEach(t=>{let i=t.level+t.depth-1;i>e&&(e=i)}),this.levelCount=e+1}return this.levelCount},D.prototype.getExtent=function(e,t){let i=this._findItemByIndexLevel(e,t),s=i.extent,n=i.index,o=i.index+s-1,r=!1,l=!1;return n<this.start&&(s-=this.start-n,r=!0),o>this.end&&(s-=o-this.end,l=!0),{extent:s,more:{before:r,after:l}}},D.prototype.getLabel=function(e){return null!=this.axisLabels?this.axisLabels[e].data:null},D.prototype.getDepth=function(e,t){return this._findItemByIndexLevel(e,t).depth},D.prototype.getCount=function(){return null!=this.axisResults?this.count:0},D.prototype._findItemByIndexLevel=function(e,t){let i=i=>{let s=i.index,n=i.extent,o=i.level,r=i.depth;return e>=s&&e<s+n&&t>=o&&t<o+r};return null!=this.lastItem&&i(this.lastItem)||(this.lastItem=this.axisResults.find(i)),this.lastItem},a.__registerWidget("oj.ojDataGrid",g.oj.baseComponent,{widgetEventPrefix:"oj",options:{bandingInterval:{row:0,column:0},data:null,gridlines:{horizontal:"visible",vertical:"visible"},scrollToKey:"auto",scrollPosition:{x:0,y:0},selectionMode:{cell:"none",row:"none"},dnd:{reorder:{row:"disable"}},dataTransferOptions:{cut:"disable",copy:"disable",paste:"disable",fill:"disable"},scrollPolicy:"auto",scrollPolicyOptions:{maxRowCount:500,maxColumnCount:500},selection:[],currentCell:null,editMode:"none",header:{row:{className:null,label:{renderer:null,className:null,style:null},renderer:null,resizable:{width:"disable",height:"disable"},sortable:"auto",style:null},column:{className:null,label:{renderer:null,className:null,style:null},renderer:null,resizable:{width:"disable",height:"disable"},sortable:"auto",style:null},columnEnd:{className:null,label:{renderer:null,className:null,style:null},renderer:null,resizable:{width:"disable",height:"disable"},style:null},rowEnd:{className:null,label:{renderer:null,className:null,style:null},renderer:null,resizable:{width:"disable",height:"disable"},style:null}},cell:{className:null,renderer:null,style:null},resize:null,sort:null,sortRequest:null,collapseRequest:null,expandRequest:null,ready:null,scroll:null,beforeCurrentCell:null,beforeEdit:null,beforeEditEnd:null,cutRequest:null,copyRequest:null,pasteRequest:null,fillRequest:null},_ComponentCreate:function(){this._super(),this.root=this.element[0],this.rootId=this.root.getAttribute("id"),this.grid=new I(this.root),this.grid.setVisibility(I.VISIBILITY_STATE_RENDER),g(this.root).addClass("oj-datagrid oj-component"),g(this.root).attr(h._OJ_CONTAINER_ATTR,this.widgetName),c.disableDefaultBrowserStyling(this.root),this.redrawSet={data:"all",header:["className","renderer","style","template"]}},_AfterCreate:function(){var e=this;this._unregisterResizeListener(this.root),this._removeAllChildren(),this._super(),this.resources=new v(this._GetReadingDirection(),this._getTranslation.bind(e),{showIndicatorDelay:C.getCachedCSSVarValues(["--oj-private-core-global-loading-indicator-delay-duration"])[0]},this.widgetName),this._setDataSource(),this._setSelection(),null!=this.datasource&&(this.grid.SetDataSource(this.datasource),this._addContextMenu(),this._isCreate=!0,this.grid._addDataSourceEventListeners()),this._checkSelectionMode(this.options),this.grid.SetOptions(this.options,this._WrapCustomElementRenderer.bind(e)),this.grid.SetResources(this.resources),this.grid.SetCreateContextCallback(this._modifyContext.bind(e)),this.grid.SetFixContextCallback(this._FixRendererContext.bind(e)),this.grid.SetRemoveCallback(this._remove.bind(e)),this.grid.SetUniqueIdCallback(this._uniqueId.bind(e)),this.grid.SetCompareValuesCallback(this._compareValues.bind(e)),this.grid.SetNotReadyCallback(this._NotReady.bind(e)),this.grid.SetMakeReadyCallback(this._MakeReady.bind(e)),this.grid.SetOptionCallback(this.option.bind(e)),this.grid.SetSubtreeAttachedCallback(h.subtreeAttached),this.grid.SetContextCallback(d.getContext),this.grid.SetCustomElementCallback(this._IsCustomElement.bind(e)),this.grid.SetUpdateScrollPostionOnRefreshCallback(this._updateScrollPositionOnRefresh.bind(e)),this._focusable({applyHighlight:!0,setupHandlers:function(t,i){e.grid.SetFocusableCallback.call(e.grid,function(e){return t(g(e))},function(e){return i(g(e))})}}),this._registerEventListeners(),this._possiblyRenderOrRefresh()},_SetupResources:function(){this._super(),this.setupResources()},setupResources:function(){null!=this.datasource&&(this._isCreate||this.grid._addDataSourceEventListeners(),this.grid._addDomEventListeners(),this._registerResizeListener(this.root)),this._isCreate=!1},_ReleaseResources:function(){this._super(),this.releaseResources()},releaseResources:function(){this.grid._removeDataSourceEventListeners(),this.grid._removeDomEventListeners(),this._unregisterResizeListener(this.root)},_registerEventListeners:function(){var e=this;this.grid.addListener("resize",function(t){e._trigger("resize",t.event,t.ui)}),this.grid.addListener("select",function(t){e.option("selection",t.ui.selection,{_context:{originalEvent:t.event,internalSet:!0},changed:!0})}),this.grid.addListener("currentCell",function(t){e.option("currentCell",t.ui,{_context:{originalEvent:t.event,internalSet:!0},changed:!0})}),this.grid.addListener("beforeCurrentCell",function(t){return e._trigger("beforeCurrentCell",t.event,t.ui)}),this.grid.addListener("sort",function(t){var i=e._trigger2("sort",t.event,t.ui);e.grid.SetSortOriginalEvent(i.event)}),this.grid.addListener("sortRequest",function(t){return e._trigger("sortRequest",t.event,t.ui)}),this.grid.addListener("expandRequest",function(t){return e._trigger("expandRequest",t.event,t)}),this.grid.addListener("collapseRequest",function(t){return e._trigger("collapseRequest",t.event,t)}),this.grid.addListener("keydown",function(t){return e._trigger("keydown",t.event,t.ui)}),this.grid.addListener("ready",function(){e._trigger("ready",null,{})}),this.grid.addListener("scroll",function(t){e._trigger("scroll",t.event,t.ui)}),this.grid.addListener("beforeEdit",function(t){return e._trigger("beforeEdit",t.event,t.ui)}),this.grid.addListener("beforeEditEnd",function(t){return e._trigger("beforeEditEnd",t.event,t.ui)}),this.grid.addListener("cutRequest",function(t){return e._trigger("cutRequest",t.event,t.ui)}),this.grid.addListener("copyRequest",function(t){return e._trigger("copyRequest",t.event,t.ui)}),this.grid.addListener("pasteRequest",function(t){return e._trigger("pasteRequest",t.event,t.ui)}),this.grid.addListener("fillRequest",function(t){return e._trigger("fillRequest",t.event,t.ui)})},refresh:function(){this._super();let e=!this._IsCustomElement()||null!=this._defaultContextMenu;e?this._ReleaseResources():this.releaseResources(),this._removeAllChildren(),this._defaultContextMenu&&(this.options.contextMenu=null,this._defaultContextMenu=null),this._setDataSource(),null!=this.datasource&&(a.FlattenedTreeDataGridDataSource&&this.datasource instanceof a.FlattenedTreeDataGridDataSource&&(this.datasource.Destroy(),this.datasource.Init()),this.grid.SetDataSource(this.datasource),this._addContextMenu()),this.grid.SetOptions(this.options,this._WrapCustomElementRenderer.bind(this)),this.resources.setRTLMode(this._GetReadingDirection()),this.grid.SetResources(this.resources),e?this._SetupResources():this.setupResources(),this.grid.getVisibility()!==I.VISIBILITY_STATE_RENDER&&this.grid.setVisibility(I.VISIBILITY_STATE_REFRESH),this._possiblyRenderOrRefresh()},_updateScrollPositionOnRefresh:function(){var e,t=this.options.selection;if(null!=t&&0!==t.length){e={};var i=t[t.length-1];i&&(i.startKey?(e.rowKey=i.startKey.row,e.columnKey=i.startKey.column):i.startIndex&&(e.rowIndex=0,e.columnIndex=0))}else e={x:0,y:0};this.option("scrollPosition",e,{_context:{internalSet:!0},changed:!1})},_destroy:function(){g(this.root).removeAttr(h._OJ_CONTAINER_ATTR),null!=this.datasource&&this.datasource.Destroy&&this.datasource.Destroy(),this.grid.destroy(),this._unregisterResizeListener(this.root),g(this.root).empty(),this._MakeReady()},_setOptions:function(e,t){if(this.datasource){var i=this._handleOptionUpdate(e,t);this._super(e,t),"refresh"===i?this.refresh():"pass"===i&&this.grid.UpdateOptions(e,t)}else this._super(e,t),null!=e.data&&this.refresh()},_checkSelectionMode:function(e){var t=e.selectionMode;if(t&&t.row&&t.cell&&"none"!==t.row&&"none"!==t.cell)throw new Error("JET DataGrid does not support selectionMode on cell and row simultaneously.")},_NotifyShown:function(){this._super(),this._possiblyRenderOrRefresh()},_NotifyHidden:function(){this._super(),this.grid.getVisibility()===I.VISIBILITY_STATE_VISIBLE&&this.grid.setVisibility(I.VISIBILITY_STATE_HIDDEN)},_NotifyAttached:function(){this._super(),this._possiblyRenderOrRefresh()&&this.grid._initiateScrollOnAttached()},_NotifyDetached:function(){this._super(),this.grid.getVisibility()===I.VISIBILITY_STATE_VISIBLE&&this.grid.setVisibility(I.VISIBILITY_STATE_HIDDEN)},_handleOptionUpdate:function(e,t){for(var i="ignore",s=Object.keys(e),n=0;n<s.length;n++){switch(s[n]){case"bandingInterval":case"currentCell":case"editMode":case"gridlines":case"scrollPosition":case"selection":i="pass";break;case"beforeCurrentCell":case"beforeEdit":case"beforeEditEnd":case"cutRequest":case"copyRequest":case"pasteRequest":case"fillRequest":case"create":case"disabled":case"dnd":case"optionChange":case"ready":case"resize":case"rootAttributes":case"scroll":case"sort":break;case"selectionMode":this._checkSelectionMode(e),i="pass";break;case"cell":case"header":var o=t.subkey;if(null!=o){var r=o.split(".");if("resizable"===r[1]||"sortable"===r[1]){i="pass";break}}return"refresh";case"data":return this._updateScrollPositionOnRefresh(),"refresh";case"contextMenu":case"scrollPolicy":default:return"refresh"}}return i},_isResizeEnabled:function(e,t){return!(!this.options.header[e]||!this.options.header[e].resizable)&&"disable"!==this.options.header[e].resizable[t]},_isSortEnabled:function(e){return!!this.options.header[e]&&"disable"!==this.options.header[e].sortable},_removeAllChildren:function(){for(var e=this.root.children,t=e.length-1;t>=0;t--)"TEMPLATE"!==e[t].tagName&&"OJ-SURROGATE"!==e[t].tagName&&("OJ-MENU"!==e[t].tagName||"OJ-MENU"===e[t].tagName&&"contextMenu"!==e[t].slot)&&this.root.removeChild(e[t])},_GetDefaultContextMenu:function(){return this._defaultContextMenu},_addContextMenu:function(){var e=this,t=e._IsCustomElement(),i=this._GetContextMenu()?this._GetContextMenu():this._menuContainer;if(i){null==this._menuItemsSetByGrid&&(this._menuItemsSetByGrid=[]),this._menuContainer=i;var s=(i=g(i)).find("[data-oj-command]"),n=[];s.each(function(){var i=e._shouldUpdateListItem(this,t);if(i.shouldUpdate){var s=g(this).attr("data-oj-command").split("-");if(t){var o=e._getContextMenuText(s[s.length-1],t);i.itemToUpdate?(i.itemToUpdate.textContent=o,n.push(i.itemToUpdate)):(i.toFirstChild,this.textContent=o,n.push(this))}else{var r=g(e._buildContextMenuItem(s[s.length-1],t));g(this).replaceWith(r),n.push(r.children("a").get(0))}}}),this._menuItemsSetByGrid=n,i.data("oj-ojMenu")&&(t?i[0].refresh():i.ojMenu("refresh"))}else null!=this.datasource&&(i=this._createDefaultContextMenu())&&(this._defaultContextMenu=i[0]);i&&this._addMenuSelectListener(i)},_shouldUpdateListItem:function(e,t){var i,s=!1;if(t){if(null!=e.firstElementChild&&"opt"===e.firstElementChild.getAttribute("ojmenu")?(i=_.CustomElementUtils.getSlotMap(e.firstElementChild),s=!0):i=_.CustomElementUtils.getSlotMap(e),!i[""]||0===i[""].length)return{shouldUpdate:!0,toFirstChild:s};if(i[""]){var n=this._menuItemsSetByGrid.indexOf(e);if(-1!==n)return{shouldUpdate:!0,itemToUpdate:this._menuItemsSetByGrid[n]}}return{shouldUpdate:!1}}var o=g(e).children("a");return{shouldUpdate:0===o.length||-1!==this._menuItemsSetByGrid.indexOf(o.get(0))}},_addMenuSelectListener:function(e){var t=this._handleContextMenuSelect.bind(this);this._IsCustomElement()?e[0].addEventListener("ojAction",t):e.on("ojselect",t)},_createDefaultContextMenu:function(){let e,t,i,s,n,o,r=null,l=null,a=null;const h=this._IsCustomElement();o=h?this._createCustomElementContextMenu():this._createWidgetContextMenu(),(this._isResizeEnabled("column","height")||this._isResizeEnabled("row","height"))&&(r=this._buildContextMenuItem("resizeHeight",h)),(this._isResizeEnabled("column","width")||this._isResizeEnabled("row","width"))&&(l=this._buildContextMenuItem("resizeWidth",h)),(this._isResizeEnabled("column","width")||this._isResizeEnabled("column","height")||this._isResizeEnabled("row","width")||this._isResizeEnabled("row","height"))&&(a=this._buildContextMenuItem("resizeFitToContent",h));const d=this.datasource.getCapability("sort");if(this._isSortEnabled("column")&&("column"!==d&&"full"!==d||(e=this._buildContextMenuItem("sortCol",h))),this._isSortEnabled("row")&&("row"!==d&&"full"!==d||(t=this._buildContextMenuItem("sortRow",h))),"enable"===this.options.dnd.reorder.row)switch(this.datasource.getCapability("move")){case"none":break;default:h?(s=new DocumentFragment,s.appendChild(this._buildContextMenuOjOption("cut")),s.appendChild(this._buildContextMenuOjOption("paste")),s.appendChild(this._buildContextMenuDivider())):(s=new DocumentFragment,s.appendChild(this._buildContextMenuListItem("cut")),s.appendChild(this._buildContextMenuListItem("paste")))}let c=[];if(c=Object.keys(this.options.dataTransferOptions).filter(e=>"enable"===this.options.dataTransferOptions[e]),c.length){let e=this.options.dataTransferOptions;n=new DocumentFragment,h?("enable"===e.cut&&n.appendChild(this._buildContextMenuOjOption("cutCells")),"enable"===e.copy&&n.appendChild(this._buildContextMenuOjOption("copyCells")),"enable"===e.paste&&n.appendChild(this._buildContextMenuOjOption("pasteCells")),"enable"===e.fill&&n.appendChild(this._buildContextMenuOjOption("autoFill")),n.appendChild(this._buildContextMenuDivider())):("enable"===e.cut&&n.appendChild(this._buildContextMenuListItem("cutCells")),"enable"===e.copy&&n.appendChild(this._buildContextMenuListItem("copyCells")),"enable"===e.paste&&n.appendChild(this._buildContextMenuListItem("pasteCells")),"enable"===e.fill&&n.appendChild(this._buildContextMenuListItem("autoFill")))}return this._isMultipleSelection()&&m.isTouchSupported()&&(this._discontiguousSelection=!1,h?(i=document.createElement("oj-menu-select-many"),i.setAttribute("data-oj-binding-provider","none"),i.appendChild(this._buildContextMenuOjOption("discontiguousSelection"))):i=this._buildContextMenuListItem("discontiguousSelection")),r||l||a||e||t||s||i||n?(n&&o.appendChild(n),r&&o.appendChild(r),l&&o.appendChild(l),a&&o.appendChild(a),(e||t)&&((r||l||a)&&o.appendChild(this._buildContextMenuDivider()),e&&o.appendChild(e),t&&o.appendChild(t)),s&&((r||l||a||e||t)&&o.appendChild(this._buildContextMenuDivider()),o.appendChild(s)),i&&((r||l||a||e||t||s)&&o.appendChild(this._buildContextMenuDivider()),o.appendChild(i)),h||g(o).ojMenu(),this.option("contextMenu",o,{_context:{internalSet:!0}}),g(o)):null},_createCustomElementContextMenu:function(){const e=document.createElement("oj-menu");return e.setAttribute("data-oj-binding-provider","none"),e.setAttribute("id",this.rootId+"contextmenu"),e.style.display="none",this.root.appendChild(e),e},_createWidgetContextMenu:function(){const e=document.createElement("ul");return e.setAttribute("id",this.rootId+"contextmenu"),e.style.display="none",this.root.appendChild(e),e},_buildContextMenuItem:function(e,t){if(t){if("resize"===e){const e=new DocumentFragment;return e.appendChild(this._buildContextMenuOjOption("resizeRow")),e.appendChild(this._buildContextMenuOjOption("resizeColumn")),e}if("sortCol"===e){const e=new DocumentFragment;return e.appendChild(this._buildContextMenuOjOption("sortColAsc")),e.appendChild(this._buildContextMenuOjOption("sortColDsc")),e}if("sortRow"===e){const e=new DocumentFragment;return e.appendChild(this._buildContextMenuOjOption("sortRowAsc")),e.appendChild(this._buildContextMenuOjOption("sortRowDsc")),e}if(-1!==Object.keys(this.resources.commands).indexOf(e))return this._buildContextMenuOjOption(e)}else{if("resize"===e){const e=this._buildContextMenuListItem("resize"),t=document.createElement("ul");return t.appendChild(this._buildContextMenuListItem("resizeWidth")),t.appendChild(this._buildContextMenuListItem("resizeHeight")),e.appendChild(t),e}if("sortCol"===e){const e=this._buildContextMenuListItem("sortCol"),t=document.createElement("ul");return t.appendChild(this._buildContextMenuListItem("sortColAsc")),t.appendChild(this._buildContextMenuListItem("sortColDsc")),e.appendChild(t),e}if("sortRow"===e){const e=this._buildContextMenuListItem("sortRow"),t=document.createElement("ul");return t.appendChild(this._buildContextMenuListItem("sortRowAsc")),t.appendChild(this._buildContextMenuListItem("sortRowDsc")),e.appendChild(t),e}if(-1!==Object.keys(this.resources.commands).indexOf(e))return this._buildContextMenuListItem(e)}},_buildContextMenuOjOption:function(e){const t=document.createElement("oj-option");let i;if(t.setAttribute("data-oj-command",this._getMappedCommand(e)),-1!==["cutCells","copyCells","pasteCells"].indexOf(e)){i=document.createElement("span");let t=e.indexOf("Cells"),s=e.slice(0,t);i=document.createElement("span"),i.setAttribute("slot","startIcon"),i.setAttribute("class","oj-ux-ico-"+s)}return t.textContent=this._getContextMenuText(e),i&&t.appendChild(i),t},_buildContextMenuDivider:function(){const e=document.createElement("oj-option");return e.textContent="---",e},_buildContextMenuListItem:function(e){const t=document.createElement("li");return t.setAttribute("data-oj-command",this._getMappedCommand(e)),t.appendChild(this._buildContextMenuLabel(e)),t},_getContextMenuText:function(e){var t=this._IsCustomElement();t&&"discontiguousSelection"===e&&(e="SelectMultiple"),"resizeWidth"===e?e="resizeColumn":"resizeHeight"===e&&(e="resizeRow");let i="label"+e.charAt(0).toUpperCase()+e.slice(1);return t||"discontiguousSelection"!==e||(i="labelEnableNonContiguous"),this._getTranslation(i)},_buildContextMenuLabel:function(e){const t=this._getContextMenuText(e),i=document.createElement("a");return i.setAttribute("href","#"),i.textContent=t,i},_getDataGridContextMenu:function(){return this._GetContextMenu()||this._GetDefaultContextMenu()},_getTranslation:function(e,t){return this.getTranslatedString(e,t)},_handleResizeDialog:function(e){var t,i;this._IsCustomElement()?(t=document.getElementById(this.rootId+"inputNumber").value,i=document.getElementById(this.rootId+"modal").getAttribute("dimension"),document.getElementById(this.rootId+"modal").close()):(t=g("#"+this.rootId+"inputNumber").ojInputNumber("option","value"),g("#"+this.rootId+"modal").ojDialog("close")),this.grid.handleContextMenuReturn(this.contextMenuEvent,this._getMappedCommand(i),t),this.contextMenuEvent.target.focus()},_buildResizeDialog:function(e,t,i){var s,n,o,r,l,a,h,c,m,u=this._IsCustomElement(),_=this;if(u)if(s=document.getElementById(this.rootId+"inputNumber"),null===(o=document.getElementById(this.rootId+"modal"))||null===s){(o=document.createElement("oj-dialog")).id=this.rootId+"modal",o.setAttribute("data-oj-binding-provider","none"),o.setAttribute("initial-focus","firstFocusable"),o.className=this._getMappedStyle("resizeDialog"),(r=document.createElement("div")).setAttribute("slot","header"),(l=document.createElement("div")).setAttribute("slot","body"),(a=document.createElement("div")).setAttribute("slot","footer"),(m=document.createElement("h5")).textContent=e,r.appendChild(m),r.className=this._getMappedStyle("dialogTitle"),o.appendChild(r),o.appendChild(l),o.appendChild(a),(s=document.createElement("oj-input-number")).id=this.rootId+"inputNumber",s.setAttribute("label-edge","inside"),s.setAttribute("user-assistance-density","efficient"),"width"===i?(s.setAttribute("label-hint",this._getTranslation("columnWidth")),o.setAttribute("dimension","resizeWidth")):(s.setAttribute("label-hint",this._getTranslation("rowHeight")),o.setAttribute("dimension","resizeHeight")),o.setAttribute("title",e),(h=document.createElement("oj-button")).id=this.rootId+"modalcancel",h.style.margin="5px",(c=document.createElement("oj-button")).id=this.rootId+"modalsubmit",c.style.margin="5px",c.setAttribute("chroming","callToAction"),l.appendChild(s),a.appendChild(h),a.appendChild(c),this.root.appendChild(o),h.textContent=this._getTranslation("labelResizeDialogCancel"),c.textContent=this._getTranslation("labelResizeDialogApply"),n=function(){c.disabled=!1,s.value=0,o.close()},h.addEventListener("click",n),c.addEventListener("click",this._handleResizeDialog.bind(this)),s.setAttribute("max",2e3),s.setAttribute("min",20),s.setAttribute("step",1),s.setAttribute("value",t),s.setAttribute("display-options",'{"converterHint": "none", "validatorHint": "none"}'),s.addEventListener("validChanged",function(e){"valid"===e.detail.value?c.disabled=!1:c.disabled=!0});o.setAttribute("position",JSON.stringify({my:{horizontal:"center",vertical:"center"},at:{horizontal:"center",vertical:"center"},collision:"none"})),d.getContext(o).getBusyContext().whenReady().then(function(){o.open(_.root)})}else s.setAttribute("max",2e3),s.setAttribute("min",20),s.setAttribute("step",1),s.setAttribute("value",t),s.setAttribute("label-edge","inside"),s.setAttribute("user-assistance-density","efficient"),s.setAttribute("display-options",'{"converterHint": "none", "validatorHint": "none"}'),"width"===i?(s.setAttribute("label-hint",this._getTranslation("columnWidth")),o.setAttribute("dimension","resizeWidth")):(s.setAttribute("label-hint",this._getTranslation("rowHeight")),o.setAttribute("dimension","resizeHeight")),o.setAttribute("dialog-title",e),o.open(_.root);else o=g("#"+this.rootId+"modal"),s=g("#"+this.rootId+"inputNumber"),0===o.length||0===s.length?((o=document.createElement("div")).id=this.rootId+"modal",r=document.createElement("div"),l=document.createElement("div"),a=document.createElement("div"),r.className=this._getMappedStyle("dialogTitle"),o.appendChild(r),o.appendChild(l),o.appendChild(a),(m=document.createElement("h5")).textContent=e,r.appendChild(m),(s=document.createElement("input")).id=this.rootId+"inputNumber",s.setAttribute("label-edge","inside"),(h=document.createElement("oj-button")).id=this.rootId+"modalcancel",h.style.margin="5px",(c=document.createElement("oj-button")).id=this.rootId+"modalsubmit",c.style.margin="5px",l.appendChild(s),a.appendChild(h),a.appendChild(c),this.root.appendChild(o),g(h).ojButton({component:"ojButton",label:this._getTranslation("labelResizeDialogCancel")}),g(c).ojButton({component:"ojButton",label:this._getTranslation("labelResizeDialogApply")}),n=function(){g(c).ojButton({disabled:!1}),g(s).ojInputNumber({value:0}),g(o).ojDialog("close")},h.addEventListener("click",n),c.addEventListener("click",this._handleResizeDialog.bind(this)),g(s).ojInputNumber({component:"ojInputNumber",max:1e3,min:20,step:1,value:t}),"width"===i?(s.setAttribute("label-hint",this._getTranslation("columnWidth")),o.setAttribute("dialog-title","resizeWidth")):(s.setAttribute("label-hint",this._getTranslation("rowHeight")),o.setAttribute("dialog-title","resizeHeight")),g(s).on("change",function(){g(c).ojButton({disabled:!g(s).ojInputNumber("validate")})}),g(o).ojDialog({initialFocus:"firstFocusable",position:{my:"center center",at:"center center",collision:"none",of:g(this.root)}}),g(o).ojDialog("open")):(s.ojInputNumber("option","value",t),s.setAttribute("label-edge","inside"),o.find("."+this._getMappedStyle("dialogTitle"))[0].firstChild.textContent=e,o.ojDialog("open"))},_handleContextMenuSelect:function(e,t){var i;if(i=t?t.item:g(e.target),this.menuItemFunction=i.attr("data-oj-command"),this.menuItemFunction===this._getMappedCommand("sortColAsc")||this.menuItemFunction===this._getMappedCommand("sortColDsc")||this.menuItemFunction===this._getMappedCommand("sortRowAsc")||this.menuItemFunction===this._getMappedCommand("sortRowDsc")||this.menuItemFunction===this._getMappedCommand("cut")||this.menuItemFunction===this._getMappedCommand("paste")||this.menuItemFunction===this._getMappedCommand("cutCells")||this.menuItemFunction===this._getMappedCommand("pasteCells")||this.menuItemFunction===this._getMappedCommand("copyCells")||this.menuItemFunction===this._getMappedCommand("autoFill"))this.grid.handleContextMenuReturn(this.contextMenuEvent,this.menuItemFunction,null);else if(this.menuItemFunction===this._getMappedCommand("resizeWidth")||this.menuItemFunction===this._getMappedCommand("resizeHeight")){var s=g(this.contextMenuEvent.target).closest("."+this._getMappedStyle("cell"));if(0===s.length&&(s=g(this.contextMenuEvent.target).closest("."+this._getMappedStyle("headercell"))),0===s.length&&(s=g(this.contextMenuEvent.target).closest("."+this._getMappedStyle("endheadercell"))),0===s.length&&(s=g(this.contextMenuEvent.target).closest("."+this._getMappedStyle("headerlabel"))),s.length>0){var n=this.menuItemFunction===this._getMappedCommand("resizeWidth")?s.outerWidth():s.outerHeight(),o=this.menuItemFunction===this._getMappedCommand("resizeWidth")?"width":"height",r="width"===o?this._getTranslation("resizeColumnDialog"):this._getTranslation("resizeRowDialog");this._buildResizeDialog(r,n,o)}}else if(this.menuItemFunction===this._getMappedCommand("resizeFitToContent"))this.grid.handleContextMenuReturn(this.contextMenuEvent,this.menuItemFunction,null);else if(this.menuItemFunction===this._getMappedCommand("discontiguousSelection")){let e;this._discontiguousSelection=!this._discontiguousSelection,this.grid.handleContextMenuReturn(this.contextMenuEvent,this.menuItemFunction,this._discontiguousSelection);e=this._IsCustomElement()?"labelSelectMultiple":this._discontiguousSelection?"labelDisableNonContiguous":"labelEnableNonContiguous",i.children().first().text(this._getTranslation(e))}},_NotifyContextMenuGesture:function(e,t,i){this.grid.handleContextMenuGesture(t,i,this._contextMenuGestureCallback.bind(this))},_contextMenuGestureCallback:function(e,t,i){if(null!=e){this.contextMenuEvent=t.originalEvent;var s=e.launcher,n=e.capabilities;this._manageContextMenu(n);var o="keyboard"===i?{position:{of:s},launcher:g(s)}:{launcher:g(s)};this._OpenContextMenu(t,i,o)}},_addContextMenuCapability:function(e){var t=g(this._getDataGridContextMenu());this._IsCustomElement()?t.find("[data-oj-command="+e+"]").attr("disabled")||t.find("[data-oj-command="+e+"]").attr("disabled",!0):t.find("[data-oj-command="+e+"]").hasClass("oj-disabled")||t.find("[data-oj-command="+e+"]").addClass("oj-disabled")},_removeContextMenuCapability:function(e){g(this._getDataGridContextMenu()).find("[data-oj-command="+e+"]").removeClass("oj-disabled").attr("disabled",!1)},_manageContextMenu:function(e){for(var t=Object.keys(e),i=0;i<t.length;i++){var s=t[i],n=this.resources.getMappedCommand(s);"disable"===e[s]?this._addContextMenuCapability(n):this._removeContextMenuCapability(n)}},_findCellIndex:function(e){return e[this._getMappedAttribute("context")].indexes},_setDataSource:function(){null!=this.options.data?this.options.data.fetchByOffset&&!this.options.data.fetchFirst?this.datasource=new A(this.options.data):a.DataProviderFeatureChecker.isDataProvider(this.options.data)?(this.datasource=new E(this.options.data),"randomAccess"!==this.options.data.getCapability("fetchByOffset").implementation&&"scroll"===this.options.scrollPolicy&&(f.error("oj.DataProvider does not support fetchByOffset and scrollPolicy is set to scroll. scrollPolicy will fall back to auto."),this.options.scrollPolicy="auto")):this.datasource=this.options.data:this.datasource=null},_setSelection:function(){var e=this.options.selection;null!=e&&this.grid.SetSelection(e)},_modifyContext:function(e){e.component=h.__GetWidgetConstructor(this.element,"ojDataGrid")},_setAccessibleContext:function(e){this.grid.SetAccessibleContext(e)},_unregisterResizeListener:function(e){e&&this._resizeHandler&&(m.removeResizeListener(e,this._resizeHandler),this._resizeHandler=null)},_registerResizeListener:function(e){e&&(null==this._resizeHandler&&(this._resizeHandler=this._handleResize.bind(this)),m.addResizeListener(e,this._resizeHandler))},_handleResize:function(e,t){e>0&&t>0&&(this._possiblyRenderOrRefresh(),this.grid.HandleResize(e,t))},getNodeBySubId:function(e){var t;if(null==e)return this.element?this.element[0]:null;var i=e.subId;if("oj-datagrid-cell"===i){var s=e.rowIndex,n=e.columnIndex;t=g(this.grid._getCellByIndex({row:s,column:n}))}else if("oj-datagrid-sort-icon"===i||"oj-datagrid-sort-ascending"===i||"oj-datagrid-sort-default"===i||"oj-datagrid-sort-descending"===i||"oj-datagrid-header"===i){var o,r=e.axis,l=e.index,a=null==e.level?0:e.level;if("column"===r?o=this._getHeaderByIndex(l,a,g(document.getElementById(this.rootId+":columnHeader")),this.grid.getStartColumnHeader()):"row"===r?o=this._getHeaderByIndex(l,a,g(document.getElementById(this.rootId+":rowHeader")),this.grid.getStartRowHeader()):"columnEnd"===r?o=this._getHeaderByIndex(l,a,g(document.getElementById(this.rootId+":columnEndHeader")),this.grid.getStartColumnEndHeader()):"rowEnd"===r&&(o=this._getHeaderByIndex(l,a,g(document.getElementById(this.rootId+":rowEndHeader")),this.grid.getStartRowEndHeader())),null==o)return null;if("oj-datagrid-sort-icon"===i)return o.children("."+this._getMappedStyle("sortIcon")).children().get(0);t="oj-datagrid-sort-ascending"===i?o.find("."+this._getMappedStyle("sortascending")):"oj-datagrid-sort-default"===i?o.find("."+this._getMappedStyle("sortdefault")):"oj-datagrid-sort-descending"===i?o.find("."+this._getMappedStyle("sortdescending")):o}else"oj-datagrid-header-label"===i&&(t=g(this.grid._getLabel(e.axis,e.level)));return null!=t&&t.length>0?t[0]:null},getSubIdByNode:function(e){var t,i=g(e).closest("."+this._getMappedStyle("cell"));if(i.length>0){var s=this._findCellIndex(i[0]);return{subId:"oj-datagrid-cell",rowIndex:s.row,columnIndex:s.column}}var n=g(e).closest("."+this._getMappedStyle("headercell"));if(0===n.length&&(n=g(e).closest("."+this._getMappedStyle("endheadercell"))),n.length>0)return t=n[0][this._getMappedAttribute("context")],{subId:g(e).hasClass(this._getMappedStyle("sortascending"))?"oj-datagrid-sort-ascending":g(e).hasClass(this._getMappedStyle("sortdefault"))?"oj-datagrid-sort-default":g(e).hasClass(this._getMappedStyle("sortdescending"))?"oj-datagrid-sort-descending":"oj-datagrid-header",axis:t.axis,index:this._getHeaderIndex(n),level:t.level};var o=g(e).closest("."+this._getMappedStyle("headerlabel"));return o.length>0?{subId:"oj-datagrid-header-label",axis:(t=o[0][this._getMappedAttribute("context")]).axis,level:t.level}:null},getContextByNode:function(e){var t,i,s=g(e).closest("."+this._getMappedStyle("cell"));if(s.length>0)return t=s[0][this._getMappedAttribute("context")],(i=a.CollectionUtils.copyInto({},t,void 0,!0)).subId="oj-datagrid-cell",i;var n=g(e).closest("."+this._getMappedStyle("headercell"));if(0===n.length&&(n=g(e).closest("."+this._getMappedStyle("endheadercell"))),n.length>0)return t=n[0][this._getMappedAttribute("context")],(i=a.CollectionUtils.copyInto({},t,void 0,!0)).subId="oj-datagrid-header",i.index=this._getHeaderIndex(n),i;var o=g(e).closest("."+this._getMappedStyle("headerlabel"));return o.length>0?(t=o[0][this._getMappedAttribute("context")],(i=a.CollectionUtils.copyInto({},t,void 0,!0)).subId="oj-datagrid-header-label",i):null},_getMappedStyle:function(e){return this.resources.getMappedStyle(e)},_getMappedAttribute:function(e){return this.resources.getMappedAttribute(e)},_getMappedCommand:function(e){return this.resources.getMappedCommand(e)},_isDataGridSizingAvailable:function(){return null!=this.root.offsetParent},_possiblyRenderOrRefresh:function(){var e=this.grid.getVisibility(),t=!1;return this._isDataGridSizingAvailable()?(e===I.VISIBILITY_STATE_RENDER?(this.grid.render(this.root),t=!0):e===I.VISIBILITY_STATE_REFRESH&&(this.grid.refresh(this.root),t=!0),this.grid.setVisibility(I.VISIBILITY_STATE_VISIBLE)):e===I.VISIBILITY_STATE_VISIBLE&&this.grid.setVisibility(I.VISIBILITY_STATE_HIDDEN),t},_getHeaderByIndex:function(e,t,i,s){if(t<0)return null;var n=i.children().first().children().last();if(n.hasClass(this._getMappedStyle("headercell")))return i.children().first().children("."+this._getMappedStyle("headercell")).eq(e-s);if(n.hasClass(this._getMappedStyle("endheadercell")))return i.children().first().children("."+this._getMappedStyle("endheadercell")).eq(e-s);var o=this._getGroupingContainer(e,t,0,i.children().first().children());if(null==o)return null;if(t<=parseInt(o.attr(this._getMappedAttribute("level")),10)+parseInt(o.children().eq(0).attr(this._getMappedAttribute("depth")),10)-1)return o.children().eq(0);var r=e-(s=parseInt(o.attr(this._getMappedAttribute("start")),10))+1;return o.children().eq(r)},_getGroupingContainer:function(e,t,i,s){if(null==s.eq(1)||s.eq(1).hasClass(this._getMappedStyle("headercell"))||s.eq(1).hasClass(this._getMappedStyle("endheadercell")))return t===i?s.eq(0).parent():null;var n,o=s.parent().parent();for(n=o.hasClass(this._getMappedStyle("header"))||o.hasClass(this._getMappedStyle("endheader"))?0:1;n<s.length;n++){var r=parseInt(s.eq(n).attr(this._getMappedAttribute("start")),10),l=parseInt(s.eq(n).attr(this._getMappedAttribute("extent")),10),a=parseInt(s.eq(n).children().eq(0).attr(this._getMappedAttribute("depth")),10);if(e>=r&&e<r+l)return t<i+a?s.eq(n):this._getGroupingContainer(e,t,i+a,s.eq(n).children())}return null},_getHeaderIndex:function(e){var t;if(e.parent().hasClass(this._getMappedStyle("groupingcontainer"))){if(t=parseInt(e.parent().attr(this._getMappedAttribute("start")),10),e.get(0)===e.parent().children(":first").get(0))return t;t-=1}else t=e.hasClass(this._getMappedStyle("rowheadercell"))?this.grid.getStartRowHeader():e.hasClass(this._getMappedStyle("colheadercell"))?this.grid.getStartColumnHeader():e.hasClass(this._getMappedStyle("colendheadercell"))?this.grid.getStartColumnEndHeader():this.grid.getStartRowEndHeader();return t+=e.index()},_isMultipleSelection:function(){return null!=this.options.selectionMode&&("multiple"===this.options.selectionMode.row||"multiple"===this.options.selectionMode.cell)},_remove:function(e){g(e).remove()},_uniqueId:function(e,t){t?g(e).removeUniqueId():g(e).uniqueId()},_compareValues:function(e,t){return a.Object.compareValues(e,t)},scrollTo:function(e){this.grid.scroll(e)},whenReady:function(){if(this._ready)return Promise.resolve(!0);if(!this._readyPromise){var e=this;this._readyPromise=new Promise(function(t){e._readyPromiseResolve=t})}return this._readyPromise},_NotReady:function(){if(this._ready=!1,!this._readyResolveFunc){var e=d.getContext(this.element[0]).getBusyContext(),t={description:"The component identified by '"+this.element.attr("id")+"' is being loaded."};this._readyResolveFunc=e.addBusyState(t)}},_MakeReady:function(){this._readyPromiseResolve&&(this._readyPromiseResolve(!0),this._readyPromiseResolve=null),this._ready=!0,this._readyPromise=null,this._readyResolveFunc&&(this._readyResolveFunc(),this._readyResolveFunc=null)},_CompareOptionValues:function(e,t,i){switch(e){case"currentCell":case"selection":return a.Object.compareValues(t,i);default:return this._super(e,t,i)}}}),I.prototype.unhighlightFloodFillRange=function(e){null==e&&(e=this.GetFloodFillRange()[0]),null!=e&&this._applyBorderClassesAroundRange(this.getElementsInRange(e),e,!1,"Floodfill")},I.prototype.highlightFloodFillRange=function(e){this._applyBorderClassesAroundRange(this.getElementsInRange(e),e,!0,"Floodfill")},I.prototype.handleDatabodyFloodFillDrag=function(e){var t=e.target,i=this.findCell(t);if(null!=i){var s=this.getCellIndexes(i);this.extendFloodFillSelection(s,e)}},I.prototype.GetFloodFillRange=function(){return null==this.m_floodFillRange&&(this.m_floodFillRange=[]),this.m_floodFillRange},I.prototype.extendFloodFillSelection=function(e,t){if("header"===this.m_active.type)return;var i;if(null==(i={row:this.m_active.indexes.row,column:this.m_active.indexes.column}))return;let s,n=!1;s||(s=this.m_selection);let o,r=s[0].startIndex,l=s[0].endIndex;e.row>=r.row&&e.row<=l.row&&(n=!0,e.column>l.column?o="right":e.column<r.column&&(o="left"),e.row=l.row);let a=!1;e.column>=r.column&&e.column<=l.column&&(a=!0,e.row>l.row?o="bottom":e.row<r.row&&(o="top"));let h=r.row===l.row,d=r.column===l.column;if(h&&e.row===r.row&&a||d&&e.column===r.column&&n)return this.unhighlightFloodFillRange(),void(this.m_floodFillRange=[]);if((!n&&!a||e.column<=l.column&&!n)&&(e.column=l.column),n||a||(e.row>l.row?o="bottom":e.row<r.row&&(o="top")),o){let s=r,n=e;this._createRangeWithKeys(s,n,this._extendFloodFillSelectionCallback.bind(this,t,i,o))}else this.unhighlightFloodFillRange()},I.prototype._extendFloodFillSelectionCallback=function(e,t,i,s){let n=s;"top"===i?n.endIndex.row-=1:"bottom"===i?n.startIndex.row=this.m_selectionRange[0].endIndex.row+1:"left"===i?n.endIndex.column-=1:n.startIndex.column=this.m_selectionRange[0].endIndex.column+1;let o=[];this.unhighlightFloodFillRange(),o.push(n),this.m_floodFillRange=o,this.m_floodFillDirection="flood",this.highlightFloodFillRange(n)},I.prototype._addFloodfillAffordance=function(e){if(null==this.m_bottomFloodFillIconContainer){var t=e.target,i=this.findCell(t);if(i||(i=this.findHeader(t)),!i)return;this.m_bottomFloodFillIconContainer=document.createElement("div"),this.m_bottomFloodFillIconContainer.className=this.getMappedStyle("toucharea");var s=document.createElement("div");s.className=this.getMappedStyle("floodfillaffordance"),s.setAttribute("role","button"),this.m_bottomFloodFillIconContainer.appendChild(s),this.m_databody.firstChild.appendChild(this.m_bottomFloodFillIconContainer),this.m_floodFillAffordanceHeight=this.m_bottomFloodFillIconContainer.firstElementChild.offsetHeight,this.m_floodFillAffordanceWidth=this.m_bottomFloodFillIconContainer.firstElementChild.offsetWidth,this.m_options.isFloodFillEnabled()&&(this.m_bottomFloodFillIconContainer.addEventListener("mouseover",this.handleFloodFillAffordanceMouseOver.bind(this)),this.m_bottomFloodFillIconContainer.addEventListener("mousedown",this.handleFloodFillAffordanceMouseDown.bind(this)),this.m_bottomFloodFillIconContainer.addEventListener("mouseup",this.handleFloodFillAffordanceMouseUp.bind(this)),this.m_bottomFloodFillIconContainer.addEventListener("mouseleave",this.handleFloodFillAffordanceMouseLeave.bind(this)))}},I.prototype.handleFloodFillAffordanceMouseOver=function(e){0===e.buttons&&(this.m_databody.style.cursor="crosshair",this.m_cursor="crosshair")},I.prototype.handleFloodFillAffordanceMouseDown=function(){this.m_databodyDragState=!0,this.m_floodFillDragState=!0,this.m_selectionRange=null,this.m_floodFillRange=null,this.m_databody.style.cursor="crosshair",this.m_cursor="crosshair"},I.prototype.handleFloodFillAffordanceMouseUp=function(){this.m_databodyDragState=!1,this.m_floodFillDragState=!1,this.m_databody.style.cursor="default",this.m_cursor="default",this.m_selectionRange=null,this.m_floodFillRange=null},I.prototype.handleFloodFillAffordanceMouseLeave=function(e){0===e.buttons&&(this.m_databodyDragState=!1,this.m_floodFillDragState=!1,this.m_databody.style.cursor="default",this.m_cursor="default")},I.prototype._removeFloodFillAffordance=function(){this._isDatabodyCellActive()&&this.m_bottomFloodFillIconContainer&&this.m_bottomFloodFillIconContainer.parentNode&&(this.m_databody.style.cursor="default",this.m_cursor="default",this.m_bottomFloodFillIconContainer.parentNode.removeChild(this.m_bottomFloodFillIconContainer))},I.prototype._moveFloodFillAffordance=function(){var e=this.getResources().isRTLMode()?"right":"left",t=this.GetSelection();if(t.length>0){var i=this._getTouchSelectionAffordanceSize();if(null!=this.m_bottomFloodFillIconContainer){var s=this._getCellByIndex(t[t.length-1].endIndex);s?(this.setElementDir(this.m_bottomFloodFillIconContainer,this.getElementDir(s,"top")+this.getElementHeight(s)-i+this.m_floodFillAffordanceHeight+1,"top"),this.setElementDir(this.m_bottomFloodFillIconContainer,this.getElementDir(s,e)+this.getElementWidth(s)-(i-this.m_floodFillAffordanceWidth)+1,e),this.m_databody.firstChild.appendChild(this.m_bottomFloodFillIconContainer)):this._removeFloodFillAffordance()}}}});
//# sourceMappingURL=ojdatagrid.js.map