/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","ojs/ojdvt-toolkit","ojs/ojdvt-axis","ojs/ojlegend-toolkit","ojs/ojdvt-overview"],function(e,t,i,r,s){"use strict";const a=(e,t)=>e+"; "+t,n=(e,i,r)=>null!=e&&null!=i&&t.Obj.compareValues(r,e,i);class o{constructor(e,t,i,r){this.id=e,this.series=t,this.group=i,this.context=r}equals(e){return e instanceof o&&(null!=this.id||null!=e.id?n(this.id,e.id,this.context):n(this.series,e.series,this.context)&&n(this.group,e.group,this.context))}toString(){return null!=this.id&&"object"!=typeof this.id?this.id.toString():a(this.series,this.group)}valueOf(){return this.toString()}}const l={_SUPPORTED_TYPES:["bar","line","area","lineWithArea","combo","pie","bubble","scatter","funnel","pyramid","stock","boxPlot"],isValidType:e=>l._SUPPORTED_TYPES.indexOf(e.getType())>=0,isSpark:e=>e.getOptions().__spark,isOverview:e=>e.getOptions()._isOverview,isVertical:e=>!l.isHorizontal(e)&&!l.isPolar(e),isHorizontal:e=>"horizontal"==e.getOptions().orientation&&!l.isPolar(e)&&!l.isStock(e)&&(l.isBLAC(e)||l.isFunnel(e)),isPolar:e=>"polar"==e.getOptions().coordinateSystem&&!l.isStock(e)&&!l.isBoxPlot(e),isCombo:e=>"combo"==e.getType(),isBar:e=>"bar"==e.getType(),isLine:e=>"line"==e.getType(),isLineWithArea:e=>"lineWithArea"==e.getType(),isArea:e=>"area"==e.getType(),isStock:e=>"stock"==e.getType(),isBoxPlot:e=>"boxPlot"==e.getType(),isScatter:e=>"scatter"==e.getType(),isBubble:e=>"bubble"==e.getType(),isPie:e=>"pie"==e.getType(),isFunnel:e=>"funnel"==e.getType(),isPyramid:e=>"pyramid"==e.getType(),isDualY:e=>!(!l.hasAxes(e)||l.isScatterBubble(e)||l.isPolar(e)),isBLAC:e=>{var t=e.getType();return"bar"==t||"line"==t||"area"==t||"lineWithArea"==t||"combo"==t||"stock"==t||"boxPlot"==t},isScatterBubble:e=>{var t=e.getType();return"scatter"==t||"bubble"==t},isLineArea:e=>{var t=e.getType();return"line"==t||"area"==t||"lineWithArea"==t},isScrollSupported:e=>!(l.isPie(e)||l.isFunnel(e)||l.isPolar(e)||l.isPyramid(e)),isOverviewSupported:e=>l.isBLAC(e)&&l.isVertical(e),hasAxes:e=>!("pie"==e.getType()||"funnel"==e.getType()||"pyramid"==e.getType()),isLegendRendered:e=>{var t=e.getOptions(),i=e.getOptionsCache().getFromCache("hasLargeSeriesCount"),r=t.legend;if("off"===r.rendered)return!1;if("auto"===r.rendered&&i)return!1;var s=e.getOptionsCache().getFromCache("hasSeriesDisplayedInLegend"),a=r.sections&&0!==r.sections.length,n=l.isStock(e),o=l.isFunnel(e),h=l.isPyramid(e);return!((n||o||h)&&!s&&!a)},hasTimeAxis:e=>l.isBLAC(e)&&"disabled"!=l.getTimeAxisType(e),hasGroupAxis:e=>l.isBLAC(e)&&"disabled"==l.getTimeAxisType(e),getTimeAxisType:e=>{var t=e.getOptions().timeAxisType;return t&&"auto"!=t&&l.isBLAC(e)&&!l.isPolar(e)?t:l.isStock(e)?"skipGaps":"disabled"},isMixedFrequency:e=>"mixedFrequency"==l.getTimeAxisType(e)},h={polarToCartesian:(e,i,r)=>{var s=r.x+r.w/2+e*Math.sin(i),a=r.y+r.h/2-e*Math.cos(i);return new t.Point(s,a)},convertAxisCoord:(e,i,r)=>{if(l.isPolar(e)){var s=h.polarToCartesian(i.y,i.x,r);return new t.Point(s.x,s.y)}return l.isHorizontal(e)?new t.Point(i.y,i.x):new t.Point(i.x,i.y)}},g={getValueFormat:(e,t)=>{var i=e.getOptions().valueFormats;return i?i[t]?i[t]:"group"==t&&l.hasTimeAxis(e)?g.getValueFormat(e,"x"):"y"!=t&&"y2"!=t&&"min"!=t&&"max"!=t||!l.isBLAC(e)?{}:g.getValueFormat(e,"value"):{}},formatVal:(e,t,r,s,a,n)=>{var o,l="auto",h="on";t.scaling&&(l=t.scaling),t.autoPrecision&&(h=t.autoPrecision),t.converter&&(o=t.converter),s=null!=s?s:r,a=null!=a?a:r,n=null!=n?n:0;var g=new i.LinearScaleAxisValueFormatter(s,a,n,l,h,e.getOptions().translations);return o&&o.format?g.format(r,o):g.format(r)},formatDateVal:(e,t)=>{var i=e.converter;return i&&i.format?i.format(t):null}},d={_SERIES_TYPE_RAMP:["bar","line","area"],hasData:e=>{var t=e.getOptions();if(!t||!t.series||t.series.length<1)return!1;for(var i=d.getSeriesCount(e),r=0;r<i;r++){var s=d.getSeriesItem(e,r);if(s&&s.items&&s.items.length>=1)return!0}return!1},hasInvalidData:e=>!d.hasData(e)||d.hasInvalidTimeData(e),hasInvalidTimeData:e=>{if(l.isFunnel(e)||l.isPie(e)||l.isPyramid(e))return!1;var t,i,r=e.getOptions(),s=d.getGroupCount(e);if(!r||!r.series||r.series.length<1)return!0;if(s<1)return!0;var a=d.getSeriesCount(e);if(l.isMixedFrequency(e))for(t=0;t<a;t++)for(i=0;i<s;i++){var n=d.getDataItem(e,t,i);if(n&&(null==n.x||isNaN(n.x)))return!0}else if(l.hasTimeAxis(e))for(i=0;i<s;i++){var o=d.getGroup(e,i);if(null==o||isNaN(o))return!0}return!1},hasSeriesData:(e,t)=>{var i=d.getSeriesItem(e,t).items;if(i)for(var r=0;r<i.length;r++)if(null!=i[r])return!0;return!1},getSeriesCount:e=>{var t=e.getOptions().series;return t?t.length:0},getY2SeriesCount:(e,t,i)=>{for(var r=0,s=d.getSeriesCount(e),a=0;a<s;a++)t&&d.getSeriesType(e,a)!=t||(i||d.isSeriesRendered(e,a))&&d.isAssignedToY2(e,a)&&r++;return r},getSeries:(e,t)=>{var i=d.getSeriesItem(e,t);return i?i.id?i.id:i.name||""===i.name?i.name:String(t):null},getSeriesLabel:(e,t)=>{var i=d.getSeriesItem(e,t);return i&&(i.name||""===i.name)?i.name:null},getSeriesIdx:(e,t)=>{for(var i=d.getSeriesCount(e),r=0;r<i;r++){if(d.getSeries(e,r)==t)return r}return-1},getSeriesStyleIdx:(e,t)=>{if(e.getOptionsCache().getFromCache("hasLargeSeriesCount"))return t;var i=d.getSeries(e,t);return null==i?t:e.getSeriesStyleArray().indexOf(i)},getSeriesItem:(e,t)=>{if(isNaN(t)||null==t||t<0)return null;var i=e.getOptions();return i.series&&i.series.length>t?i.series[t]:null},getDataItem:(e,t,i)=>{if(isNaN(i)||null==i||i<0)return null;var r=d.getSeriesItem(e,t);return r&&r.items&&r.items.length>i?r.items[i]:null},getRawDataItem:(e,t,i)=>{if(isNaN(i)||null==i||i<0)return null;var r=e.getRawOptions().series[t].items[i];if("number"==typeof r)return r;if(!r)return null;var s=Object.assign({},r);return s.itemData=r._itemData,delete s._itemData,s},getDataItemId:(e,t,i)=>{var r=d.getDataItem(e,t,i);return r?null!=r.id?r.id:a(d.getSeries(e,t),d.getGroup(e,i)):null},getNestedDataItem:(e,t,i,r)=>{if(isNaN(r)||null==r||r<0)return null;var s=d.getDataItem(e,t,i);return s&&s.items&&s.items.length>r?s.items[r]:null},getNestedDataItemCount:(e,t,i)=>{var r=d.getDataItem(e,t,i);return r&&r.items?r.items.length:0},getNestedDataItemId:(e,t,i,r)=>{var s=d.getNestedDataItem(e,t,i,r);return s?null!=s.id?s.id:d.getDataItemId(e,t,i)+"; "+String(r):null},getNestedDataItemIdx:(e,t,i,r)=>{for(var s=d.getNestedDataItemCount(e,t,i),a=0;a<s;a++){var o=d.getNestedDataItemId(e,t,i,a);if(n(o,r,e.getCtx()))return a}return-1},getGroupCount:e=>d._getGroupsArray(e).length,getGroup:(e,t)=>{if(null!=t&&t>=0&&t<d.getGroupCount(e)){var i=d._getGroupsArray(e)[t];if(i)return null!=i.id?i.id:null!=i.name?i.name:String(t)}return null},getGroupIdx:(e,i)=>{for(var r=d.getGroups(e),s=0;s<r.length;s++)if(i instanceof Array&&r[s]instanceof Array?t.ArrayUtils.equals(i,r[s]):i===r[s])return s;return-1},getGroupLabel:(e,t)=>{if(t>=0&&t<d.getGroupCount(e)){var i=d._getGroupsArray(e)[t];if(i)return null!=i.name?i.name:null!=i.id||"string"!=typeof i?"":i}return null},getGroups:e=>{var t=e.getOptionsCache().getFromCache("groups");if(!t){var i=d.getGroupCount(e);t=[];for(var r=0;r<i;r++)t.push(d.getGroup(e,r));e.getOptionsCache().putToCache("groups",t)}return t},_getGroupsArray:e=>{var t=e.getOptions(),i=e.getOptionsCache().getFromCache("groupsArray");if(!i){i=[],t.groups&&(i=d._getNestedGroups(t.groups,i));for(var r=0;r<i.length;r++)1==i[r].id.length&&(i[r].id=i[r].id[0],i[r].name=i[r].name[0]);e.getOptionsCache().putToCache("groupsArray",i)}return i},_getNestedGroups:(e,t)=>{if(!e||0==e.length)return[];for(var i=0;i<e.length;i++){var r=e[i],s=null,a=null;if(null!=r&&(s=null!=(s=null!=r.id?r.id:r.name)?s:r,a=r.name?r.name:r),"object"==typeof s&&(s=null),"object"==typeof a&&(a=null),r&&r.groups){var n=d._getNestedGroups(r.groups,[]);0==n.length&&n.push({id:[],name:[]});for(var o=0;o<n.length;o++)n[o].id.unshift(s),n[o].name.unshift(a);t=t.concat(n)}else t.push({id:[s],name:[a]})}return t},getNumLevels:e=>{var t=e.getOptionsCache().getFromCache("groupsNumLevels");if(null!=t)return t;t=0;for(var i=d._getGroupsArray(e),r=0;r<i.length;r++){var s=i[r];if(s&&s.id){var a=Array.isArray(s.id)?s.id.length:1;t=Math.max(t,a)}}return e.getOptionsCache().putToCache("groupsNumLevels",t),t},getVal:(e,t,i,r)=>{var s,a="number"==typeof r&&r>=0;if(!a&&void 0!==(s=e.getOptionsCache().getFromCachedMap2D("value",t,i)))return s;var n=a?d.getNestedDataItem(e,t,i,r):d.getDataItem(e,t,i);return s=null,null!=n&&("object"!=typeof n?s=n:l.isStock(e)&&null!=n.close?s=n.close:null!=n.value?s=n.value:null!=n.y&&(s=n.y)),s=s||(0===s?0:null),a||e.getOptionsCache().putToCachedMap2D("value",t,i,s),s},getCumulativeVal:(e,t,i,r)=>{if(!d.isStacked(e))return d.getVal(e,t,i);var s=r?"cumValueH":"cumValue",a=e.getCache().getFromCachedMap2D(s,t,i);if(void 0!==a)return a;var n=d.getSeriesType(e,t),o=d.isAssignedToY2(e,t),l=d.getVal(e,t,i),h=d.getStackCategory(e,t),g="bar"==n?l<0:d.isSeriesNegative(e,t);a=0;for(var u=t;u>=0;u--)if((r||d.isDataItemRendered(e,u,i))&&n==d.getSeriesType(e,u)&&o==d.isAssignedToY2(e,u)&&d.getStackCategory(e,u)==h){var _=d.getVal(e,u,i),c="bar"==n?_<0:d.isSeriesNegative(e,u);if(g&&c||!g&&!c){var p=e.getCache().getFromCachedMap2D(s,u,i);if(void 0!==p){a=l+(p||0);break}a+=null==_||isNaN(_)?0:_}}return e.getCache().putToCachedMap2D(s,t,i,a),a},getLowVal:(e,t,i)=>{var r=d.getDataItem(e,t,i);return null==r?null:"candlestick"==d.getSeriesType(e,t)?null==r.low&&null!=r.close?null!=r.open?Math.min(r.close,r.open):r.close:r.low:null!=r.low&&null==r.close?r.low:null},getHighVal:(e,t,i)=>{var r=d.getDataItem(e,t,i);return null==r?null:"candlestick"==d.getSeriesType(e,t)?null==r.high?null!=r.open?Math.max(r.close,r.open):r.close:r.high:null!=r.high&&null==r.close?r.high:null},getXVal:(e,t,i)=>{var r=d.getDataItem(e,t,i);return d.getXValFromItem(e,r,i)},getXValFromItem:(e,t,i)=>null!=t&&null!=t.x?t.x:l.hasGroupAxis(e)?i:l.hasTimeAxis(e)&&!l.isMixedFrequency(e)?d.getGroupLabel(e,i):null,getTargetVal:(e,t)=>{var i=d.getDataItem(e,t,0);return null==i||"object"!=typeof i?null:i.targetValue},getZVal:(e,t,i,r)=>{var s=d.getDataItem(e,t,i);return null==s||"object"!=typeof s?r:null!=s.z?Math.max(0,s.z):r},isStockValRising:(e,t,i)=>{var r=d.getDataItem(e,t,i);return!r||r.open<=r.close},getCategories:(e,t,i,r)=>{var s=d.getNestedDataItem(e,t,i,r);if(s&&s.categories)return s.categories;var a=d.getDataItem(e,t,i);if(a&&a.categories)return a.categories;var n=d.getSeriesItem(e,t);if(n&&n.categories)return n.categories;var o=d.getSeries(e,t);return null!=o?[o]:[]},isAssignedToY2:(e,t)=>{if(!e.getOptionsCache().getFromCache("hasY2Assignment"))return!1;var i=d.getSeriesItem(e,t);return i&&"on"==i.assignedToY2&&l.isDualY(e)},getInitialSelection:e=>{var t=e.getOptions().selection,i=null!=e.getOptions().data;t||(t=[]);for(var r=e.getChartObjPeers(),s=0;s<t.length;s++){var a=null==t[s].id||i?t[s]:t[s].id;if(null!=t[s].id||t[s].series||t[s].group||(t[s]={id:a}),!(null==a||t[s].series&&t[s].group))for(var o=0;o<r.length;o++){var l=r[o];if(n(a,l.getDataItemId(),e.getCtx())){t[s].series=l.getSeries(),t[s].group=l.getGroup();break}}}return t},getCurrentSelection:e=>{var t=[],i=e.getSelectionHandler();if(i)for(var r=i.getSelectedIds(),s=0;s<r.length;s++){var a=r[s];t.push({series:a.series,group:a.group,id:a.id})}return t},hasVolumeSeries:e=>{var t=e.getOptionsCache().getFromCache("hasVolume");return t||!1},isDataSelected:(e,t,i,r)=>{var s=!isNaN(r)&&null!=r&&r>=0?d.getNestedDataItemId(e,t,i,r):d.getDataItemId(e,t,i),a=d.getSeries(e,t),o=d.getGroup(e,i),l=e.getOptions().selection;l||(l=[]);for(var h=0;h<l.length;h++){if(n(s,l[h],e.getCtx())||n(s,l[h].id,e.getCtx()))return!0;if(null==l[h].id&&n(a,l[h].series,e.getCtx())&&n(o,l[h].group,e.getCtx()))return!0}return!1},getDefaultDataLabel:(e,t,i,r,s,a)=>{var n;if(a)n=d.getCumulativeVal(e,t,i);else{var o=!isNaN(r)&&null!=r&&r>=0?d.getNestedDataItem(e,t,i,r):d.getDataItem(e,t,i);if(!o)return null;n=o.label,"low"==s?n=n instanceof Array?n[0]:n:"high"==s&&(n=n instanceof Array?n[1]:null)}if(null!=n){if("number"==typeof n){var l,h,u,_=d.isAssignedToY2(e,t)&&e.y2Axis?e.y2Axis:e.yAxis;if(_){var c=_.getInfo();l=c.getGlobalMin(),h=c.getGlobalMax(),u=c.getMajorIncrement()}var p=g.getValueFormat(e,"label");return g.formatVal(e,p,n,l,h,u)}return n}return null},getStackCategory:(e,t)=>{var i=e.getCache().getFromCachedMap("stackCategory",t);return void 0!==i||(i=d.isStacked(e)?d.getSeriesItem(e,t).stackCategory||null:d.getSeries(e,t)||null,e.getCache().putToCachedMap("stackCategory",t,i)),i},getStackCategories:(e,t,i)=>{var r=[],s=[],a={},n={},o=e.getCache().getFromCachedMap2D("stackCategories",t,i);if(o)return o;for(var l=d.getSeriesCount(e),h=0;h<l;h++)if(d.isSeriesRendered(e,h)||i){if(t){var g=d.getSeriesType(e,h);if("candlestick"!=g&&"boxPlot"!=g||(g="bar"),t!=g)continue}var u=d.getStackCategory(e,h);d.isAssignedToY2(e,h)?n[u]||(s.push(u),n[u]=!0):a[u]||(r.push(u),a[u]=!0)}return o={y:r,y2:s},e.getCache().putToCachedMap2D("stackCategories",t,i,o),o},getBarCategoryZ:(e,t,i,r)=>{for(var s=0,a=d.getSeriesCount(e),n=0;n<a;n++){var o=d.getSeriesType(e,n);if(("bar"==o||"candlestick"==o||"boxPlot"==o)&&d.getStackCategory(e,n)==t&&d.isSeriesRendered(e,n)){var l=d.isAssignedToY2(e,n);(r&&l||!r&&!l)&&(s=Math.max(s,d.getZVal(e,n,i,1)))}}return s},getMarkerPos:(e,i,r,s,a)=>{var n,o,g=e.xAxis,u=d.isAssignedToY2(e,i)?e.y2Axis:e.yAxis,_=l.isPolar(e),c=d.isRangeSeries(e,i),p=!isNaN(s)&&null!=s&&s>=0,v=d.getXVal(e,i,r),m=p?d.getVal(e,i,r,s):d.getCumulativeVal(e,i,r);if(l.isBubble(e)){if(_&&m<u.getInfo().getViewportMin())return null;n=_?g.getCoordAt(v):g.getUnboundedCoordAt(v),o=u.getUnboundedCoordAt(m)}else if(c){var f=u.getCoordAt(d.getLowVal(e,i,r)),x=u.getCoordAt(d.getHighVal(e,i,r));n=g.getCoordAt(d.getXVal(e,i,r)),o=(f+x)/2}else n=g.getCoordAt(v),o=u.getCoordAt(m);return null==n||null==o?null:h.convertAxisCoord(e,new t.Point(n,o),a)},getScatterBubbleMarkerPos:(e,i,r)=>{var s=e.xAxis,a=e.yAxis,n=d.getXVal(e,i,r),o=d.getVal(e,i,r),l=s.getCoordAt(n),h=a.getCoordAt(o);return null==l||null==h?null:new t.Point(l,h)},isSeriesNegative:(e,t)=>{if(!e.getOptionsCache().getFromCache("hasNegativeValues"))return!1;var i=e.getOptionsCache().getFromCachedMap("isSeriesNegative",t);if(null!=i)return i;var r=d.getGroupCount(e);i=!0;for(var s=0;s<r;s++){if(d.getVal(e,t,s)>0){i=!1;break}}return e.getOptionsCache().putToCachedMap("isSeriesNegative",t,i),i},getGroupsDataForContext:e=>{var t=e.getOptionsCache().getFromCache("groupsDataArray");if(!t){var i=e.getRawOptions();t=d._getNestedGroupsData(i.groups),e.getOptionsCache().putToCache("groupsDataArray",t)}return t},getSeriesDataForContext:(e,t)=>{var i=e.getRawOptions().series[t],r=Object.assign({},i);r.items=[];for(var s=0;s<i.items.length;s++){var a,n=i.items[s];(a="object"==typeof n?Object.assign({},i.items[s]):n)&&"object"==typeof a&&delete a._itemData,r.items.push(a)}return r},_getNestedGroupsData:e=>{if(!e)return[];for(var t=[],i=0;i<e.length;i++){var r=e[i];if(r.groups){for(var s=d._getNestedGroupsData(r.groups),a=0;a<s.length;a++)s[a].unshift(r);t=t.concat(s)}else t.push([r])}return t},_computeOutermostBarMap:e=>{if(!e.getOptionsCache().getFromCache("outermostBar")){for(var t={},i=d.getSeriesCount(e),r=e.getOptionsCache().getFromCache("hasNegativeValues"),s=i-1;s>=0;s--)if(d.isSeriesRendered(e,s)&&"bar"==d.getSeriesType(e,s)){var a=(d.getStackCategory(e,s)||"")+d.isAssignedToY2(e,s);t[a]?t[a].push(s):t[a]=[s]}var n=d.getGroupCount(e);for(var o in t)for(var l=t[o],h=0;h<n;h++)for(var g=!1,u=!1,_=0;_<l.length&&!(!r&&g||g&&u);_++)if(s=l[_],d.isDataItemRendered(e,s,h)){var c=d.getVal(e,s,h);null==c?e.getOptionsCache().putToCachedMap2D("outermostBar",s,h,!1):!g&&c>=0?(g=!0,e.getOptionsCache().putToCachedMap2D("outermostBar",s,h,!0)):!u&&c<0&&(u=!0,e.getOptionsCache().putToCachedMap2D("outermostBar",s,h,!0))}}},isOutermostBar:(e,t,i)=>(d._computeOutermostBarMap(e),e.getOptionsCache().getFromCachedMap2D("outermostBar",t,i)||!1),isDataItemFiltered:(e,t,i)=>{var r=d.getDataItem(e,t,i);return!(!r||!r._filtered)},isStacked:e=>!("on"!=e.getOptions().stack||l.isMixedFrequency(e)||d.getSeriesCount(e)<2)&&l.isBLAC(e),isSplitDualY:e=>!(!l.isStock(e)||!d.hasVolumeSeries(e)||l.isOverview(e))||"on"==e.getOptions().splitDualY&&d.hasY2Data(e)&&!d.hasY2DataOnly(e),hasY2DataOnly:e=>!!l.isDualY(e)&&d.getY2SeriesCount(e,null,!0)==d.getSeriesCount(e),hasY2Data:(e,t)=>!!l.isDualY(e)&&d.getY2SeriesCount(e,null,!0)>0,hasY2BarData:e=>d.hasY2Data(e,"bar"),hasBarSeries:e=>d._hasSeriesType(e,"bar"),hasLineSeries:e=>d._hasSeriesType(e,"line"),hasAreaSeries:e=>d._hasSeriesType(e,"area"),hasLineWithAreaSeries:e=>d._hasSeriesType(e,"lineWithArea"),hasCandlestickSeries:e=>d._hasSeriesType(e,"candlestick"),hasBoxPlotSeries:e=>d._hasSeriesType(e,"boxPlot"),_hasSeriesType:(e,t)=>{if(l.isBLAC(e))for(var i=d.getSeriesCount(e),r=0;r<i;r++)if(d.isSeriesRendered(e,r)&&d.getSeriesType(e,r)==t)return!0;return!1},getRefObjs:e=>{var t=d.getAxisRefObjs(e,"x"),i=d.getAxisRefObjs(e,"y"),r=d.getAxisRefObjs(e,"y2");return t.concat(i,r)},getAxisRefObjs:(e,t)=>{var i=e.getOptions();return i&&i[t+"Axis"]&&i[t+"Axis"].referenceObjects?i[t+"Axis"].referenceObjects:[]},getSeriesType:(e,t)=>{var i=e.getOptionsCache().getFromCachedMap("seriesType",t);if(i)return i;if(!l.isBLAC(e))return e.getOptionsCache().putToCachedMap("seriesType",t,"auto"),"auto";var r=d.getSeriesItem(e,t);if(i=r?r.type:null,l.isStock(e)||"candlestick"!=i||(i="auto"),!i||"auto"==i)if(l.isBar(e))i="bar";else if(l.isLine(e))i="line";else if(l.isArea(e))i="area";else if(l.isLineWithArea(e))i="lineWithArea";else if(l.isStock(e))i="candlestick";else if(l.isBoxPlot(e))i="boxPlot";else if(l.isCombo(e)){var s=d.getSeriesStyleIdx(e,t)%d._SERIES_TYPE_RAMP.length;i=d._SERIES_TYPE_RAMP[s]}return e.getOptionsCache().putToCachedMap("seriesType",t,i),i},getHiddenCategories:e=>{var t=e.getOptions();return t.hiddenCategories||(t.hiddenCategories=[]),t.hiddenCategories},getHighlightedCategories:e=>{var t=e.getOptions();return t.highlightedCategories||(t.highlightedCategories=[]),t.highlightedCategories},isSeriesRendered:(e,i)=>{var r=d.getHiddenCategories(e);return!(r.length>0&&t.ArrayUtils.hasAnyItem(r,d.getCategories(e,i)))},isDataItemRendered:(e,i,r,s)=>{var a,n=!isNaN(s)&&null!=s&&s>=0;if(!n&&void 0!==(a=e.getOptionsCache().getFromCachedMap2D("isDataItemRendered",i,r)))return a;if(a=!0,d.isSeriesRendered(e,i)){var o=d.getHiddenCategories(e);o.length>0&&((l.isPie(e)||l.isFunnel(e)||l.isPyramid(e))&&(r=0),t.ArrayUtils.hasAnyItem(o,d.getCategories(e,i,r))&&(a=!1),t.ArrayUtils.hasAnyItem(o,d.getCategories(e,i,r,s))&&(a=!1))}else a=!1;return n||e.getOptionsCache().putToCachedMap2D("isDataItemRendered",i,r,a),a},isRangeSeries:(e,t)=>{var i=e.getOptionsCache();if(!i.getFromCache("hasLowHighSeries"))return!1;var r=i.getFromCachedMap("isRange",t);if(null!=r)return r;r=!1;var s=d.getSeriesType(e,t);if("bar"==s||"area"==s)for(var a=0;a<d.getGroupCount(e);a++)if(null!=d.getLowVal(e,t,a)||null!=d.getHighVal(e,t,a)){r=!0;break}return e.getOptionsCache().putToCachedMap("isRange",t,r),r},isSeriesDrillable:(e,t)=>{var i=d.getSeriesItem(e,t),r=null!=i?i.drilling:"inherit";return"on"==r||"off"!=r&&("on"==(r=e.getOptions().drilling)||"seriesOnly"==r)},isDataItemDrillable:(e,t,i,r)=>{var s=d.getNestedDataItem(e,t,i,r);s||(s=d.getDataItem(e,t,i));var a=null!=s?s.drilling:"inherit";return"on"==a||"off"!=a&&"on"==(a=e.getOptions().drilling)},isMultiSeriesDrillEnabled:e=>"on"===e.getOptions().multiSeriesDrilling};class u extends t.BaseComponentDefaults{constructor(e){super({alta:{skin:t.CSSStyle.SKIN_ALTA,emptyText:null,type:"bar",stack:"off",stackLabel:"off",orientation:"vertical",polarGridShape:"circle",selectionMode:"none",hideAndShowBehavior:"none",hoverBehavior:"none",zoomAndScroll:"off",zoomDirection:"auto",initialZooming:"none",dragMode:"user",sorting:"off",otherThreshold:0,animationOnDataChange:"none",animationOnDisplay:"none",__sparkBarSpacing:"subpixel",__spark:!1,dataCursor:"auto",dataCursorBehavior:"auto",drilling:"off",highlightMatch:"all",series:[],groups:[],title:{style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_BOLD_13+"color: #252525;"),halign:"start"},subtitle:{style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color: #252525;")},footnote:{style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_11+"color: #333333;"),halign:"start"},titleSeparator:{upperColor:"#74779A",lowerColor:"#FFFFFF",rendered:"off"},touchResponse:"auto",_statusMessageStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_13+"color: #252525;"),_dropColor:"#D9F4FA",xAxis:{tickLabel:{rendered:"on"},majorTick:{rendered:"auto"},minorTick:{rendered:"auto"},axisLine:{rendered:"on"},scale:"linear"},yAxis:{tickLabel:{rendered:"on"},majorTick:{rendered:"auto"},minorTick:{rendered:"auto"},axisLine:{rendered:"auto"},scale:"linear"},y2Axis:{tickLabel:{rendered:"on"},majorTick:{rendered:"auto"},minorTick:{rendered:"auto"},axisLine:{rendered:"auto"},scale:"linear",alignTickMarks:"on"},pieCenter:{labelStyle:new t.CSSStyle("")},zAxis:{},plotArea:{backgroundColor:null},legend:{position:"auto",rendered:"auto",layout:{gapRatio:1},seriesSection:{},referenceObjectSection:{},sections:[]},overview:{rendered:"off"},dnd:{drag:{items:{},series:{},groups:{}},drop:{plotArea:{},xAxis:{},yAxis:{},y2Axis:{},legend:{}}},styleDefaults:{colors:t.CSSStyle.COLORS_ALTA,borderColor:"auto",borderWidth:"auto",patterns:["smallDiagonalRight","smallChecker","smallDiagonalLeft","smallTriangle","smallCrosshatch","smallDiamond","largeDiagonalRight","largeChecker","largeDiagonalLeft","largeTriangle","largeCrosshatch","largeDiamond"],shapes:["square","circle","diamond","plus","triangleDown","triangleUp"],seriesEffect:"color",threeDEffect:"off",selectionEffect:"highlight",animationDuration:1e3,animationIndicators:"all",animationUpColor:"",animationDownColor:"",lineStyle:"solid",lineType:"auto",markerDisplayed:"auto",markerColor:null,markerShape:"auto",markerSize:10,marqueeColor:"",marqueeBorderColor:"",pieFeelerColor:"#BAC5D6",pieInnerRadius:0,selectedInnerColor:"#ffffff",selectedOuterColor:"#5a5a5a",sliceLabelType:"percent",otherColor:"#4b4b4b",dataItemGaps:"auto",dataLabelStyle:new t.CSSStyle(""),_dataLabelStyle:new t.CSSStyle(""),dataLabelPosition:"auto",funnelBackgroundColor:"#EDEDED",x1Format:{},y1Format:{},y2Format:{},zFormat:{},_defaultSliceLabelColor:"#333333",_scrollbarHeight:3,_scrollbarTrackColor:"#F0F0F0",_scrollbarHandleColor:"#9E9E9E",hoverBehaviorDelay:200,dataCursor:{markerSize:8,markerDisplayed:"on",lineStyle:"solid"},groupSeparators:{rendered:"on",color:"rgba(138,141,172,0.4)"},tooltipLabelStyle:new t.CSSStyle(""),tooltipValueStyle:new t.CSSStyle(""),stackLabelStyle:new t.CSSStyle(""),boxPlot:{whiskerSvgStyle:{},whiskerEndSvgStyle:{strokeWidth:2},whiskerEndLength:"9px",medianSvgStyle:{strokeWidth:3}}},layout:{gapWidthRatio:null,gapHeightRatio:null,outerGapWidth:10,outerGapHeight:8,titleSubtitleGapWidth:14,titleSubtitleGapHeight:4,titleSeparatorGap:6,titlePlotAreaGap:16,footnoteGap:10,verticalAxisGap:6,legendGapWidth:15,legendGapHeight:10,tickLabelGapHeight:8,tickLabelGapWidth:9},_locale:"en-us",_resources:{}}},e)}static getGapWidth(e,t){return Math.ceil(t*e.getGapWidthRatio())}static getGapHeight(e,t){return Math.ceil(t*e.getGapHeightRatio())}getNoCloneObject(){return{series:{items:{_itemData:!0}},data:!0,valueFormats:{close:{converter:!0},high:{converter:!0},label:{converter:!0},low:{converter:!0},open:{converter:!0},q1:{converter:!0},q2:{converter:!0},q3:{converter:!0},targetValue:{converter:!0},value:{converter:!0},volume:{converter:!0},x:{converter:!0},y:{converter:!0},y2:{converter:!0},z:{converter:!0}},pieCenter:{converter:!0},xAxis:{tickLabel:{converter:!0}},yAxis:{tickLabel:{converter:!0}},y2Axis:{tickLabel:{converter:!0}}}}}const _={OTHER_ID:"_dvtOther",getSliceId:(e,t)=>{var i=d.getDataItem(e,t,0),r=i?i.id:null,s=d.getSeries(e,t),a=d.getGroup(e,0);return new o(r,s,a,e.getCtx())},getOtherSliceId:e=>{var t=d.getGroup(e,0);return new o(null,_.OTHER_ID,t,e.getCtx())},getRenderedSeriesIndices:e=>_._getSeriesIndicesArrays(e).rendered,hasOtherSeries:e=>_._getSeriesIndicesArrays(e).other.length>0,getOtherVal:e=>{for(var t=_._getSeriesIndicesArrays(e).other,i=0,r=0;r<t.length;r++){var s=t[r];if(d.isSeriesRendered(e,s)){var a=d.getVal(e,s,0);a>0&&(i+=a)}}return i},getOtherSliceIds:e=>{for(var t=_._getSeriesIndicesArrays(e).other,i=[],r=0;r<t.length;r++){var s=t[r];i.push(_.getSliceId(e,s))}return i},isOtherSliceSelected:(e,t)=>{for(var i=_.getOtherSliceIds(e),r=0;r<i.length;r++){for(var s=i[r],a=!1,n=0;n<t.length;n++)if(null!=t[n].id&&s.id===t[n].id||s.series===t[n].series&&s.group===t[n].group){a=!0;break}if(!a)return!1}return!0},_getSeriesIndicesArrays:e=>{for(var t=[],i=[],r=d.getSeriesCount(e),s=e.getOptions(),a=s.otherThreshold*_.getTotalVal(e),n=0;n<r;n++){var o=d.getVal(e,n,0);a>0&&o<a?i.push(n):t.push(n)}return"ascending"==s.sorting?t.sort((t,i)=>d.getVal(e,t,0)-d.getVal(e,i,0)):"on"!=s.sorting&&"descending"!=s.sorting||t.sort((t,i)=>d.getVal(e,i,0)-d.getVal(e,t,0)),{rendered:t,other:i}},getTotalVal:e=>{for(var t=d.getSeriesCount(e),i=0,r=0;r<t;r++){var s=d.getVal(e,r,0);s>0&&(i+=s)}return i},getSliceExplode:(e,t)=>{var i=d.getSeriesItem(e,t);return i&&i.pieSliceExplode?i.pieSliceExplode:0},getSliceBySeriesIdx:(e,t)=>{for(var i=e.pieChart.__getSlices(),r=0;r<i.length;r++)if(i[r].getSeriesIndex()==t)return i[r];return null}},c={MARKER_DATA_LABEL_GAP:4,getSeriesEffect:e=>e.getOptions().styleDefaults.seriesEffect,getColor:(e,t,i)=>{var r=d.getDataItem(e,t,i);if(r&&r.color)return r.color;var s=d.getSeriesItem(e,t);if(s&&s.color)return s.color;if("candlestick"==d.getSeriesType(e,t))return c.getStockItemColor(e,t,i);var a=e.getOptions().styleDefaults.colors;return a[d.getSeriesStyleIdx(e,t)%a.length]},getStockItemColor:(e,t,i)=>{var r=e.getOptions();return d.isStockValRising(e,t,i)?r.styleDefaults.stockRisingColor:r.styleDefaults.stockFallingColor},getStockVolumeColor:(e,t,i)=>{var r=d.getDataItem(e,t,i);if(r&&r.color)return r.color;var s=e.getOptions();return s.styleDefaults.stockVolumeColor?s.styleDefaults.stockVolumeColor:c.getStockItemColor(e,t,i)},getSplitterPos:e=>{var t=e.getOptions().splitterPosition;return null!=t?t:l.isStock(e)?.8:.5},getPattern:(e,i,r,s)=>{var a=d.getNestedDataItem(e,i,r,s);if(a&&a.pattern&&"auto"!=a.pattern)return a.pattern;var n=d.getDataItem(e,i,r);if(n&&n.pattern&&"auto"!=n.pattern)return n.pattern;var o=d.getSeriesType(e,i);if(("line"==o||"area"==o)&&null!=r)return null;var h=d.getSeriesItem(e,i);if(h&&h.pattern&&"auto"!=h.pattern)return h.pattern;if("pattern"==c.getSeriesEffect(e)){if(l.isStock&&"candlestick"==d.getSeriesType(e,i)){var g=d.isStockValRising(e,i,r),u=t.Agent.isRightToLeft(e.getCtx());return g?u?"smallDiagonalLeft":"smallDiagonalRight":u?"smallDiagonalRight":"smallDiagonalLeft"}var _=e.getOptions().styleDefaults.patterns;return _[d.getSeriesStyleIdx(e,i)%_.length]}return null},getMarkerBorderColor:(e,t,i,r)=>{var s=c.getBorderColor(e,t,i,r);return s||c.getDefaultMarkerBorderColor(e,t,i,r)},getDefaultMarkerBorderColor:(e,i,r,s)=>{if("redwood"===e.getCtx().getThemeBehavior()&&!d.isRangeSeries(e,i))return c.getMarkerColor(e,i,r,s);if(c.getDataItemGaps(e)>0&&"lineWithArea"!=d.getSeriesType(e,i))return c.getBackgroundColor(e,!0);if(l.isBubble(e)&&"gradient"!=c.getSeriesEffect(e)){var a=c.getMarkerColor(e,i,r);if(a)return t.ColorUtils.adjustHSL(a,0,.15,-.25)}return null},getBorderColor:(e,t,i,r)=>{var s=d.getNestedDataItem(e,t,i,r);if(s&&s.borderColor)return s.borderColor;var a=d.getDataItem(e,t,i);if(a&&a.borderColor)return a.borderColor;var n=d.getSeriesItem(e,t);if(n&&n.borderColor)return n.borderColor;var o=e.getOptions().styleDefaults;return"auto"!=o.borderColor?o.borderColor:null},getUserBorderWidth:(e,t,i,r)=>{var s=d.getNestedDataItem(e,t,i,r);if(s&&null!=s.borderWidth)return s.borderWidth;var a=d.getDataItem(e,t,i);if(a&&null!=a.borderWidth)return a.borderWidth;var n=d.getSeriesItem(e,t);if(n&&null!=n.borderWidth)return n.borderWidth;var o=e.getOptions().styleDefaults;return"auto"!=o.borderWidth?o.borderWidth:null},getDefaultBorderWidth:e=>l.isScatterBubble(e)||l.isLineArea(e)?1.25:1,getDefaultMarkerBorderWidth:e=>"redwood"===e.getCtx().getThemeBehavior()?0:c.getDefaultBorderWidth(e),getBorderWidth:(e,t,i,r)=>{var s=c.getUserBorderWidth(e,t,i,r);return null!=s?s:c.getDefaultBorderWidth(e)},getMarkerColor:(e,t,i,r)=>{if(!c.isMarkerDisplayed(e,t,i,r))return c.getColor(e,t,i);var s=d.getNestedDataItem(e,t,i,r);if(s&&s.color)return s.color;var a=d.getDataItem(e,t,i);if(a&&a.color)return a.color;var n=d.getSeriesItem(e,t);if(n&&n.markerColor)return n.markerColor;var o=e.getOptions().styleDefaults.markerColor;return o||c.getColor(e,t,i)},getMarkerShape:(e,t,i,r)=>{var s=e.getOptions(),a=s.styleDefaults.markerShape,n=d.getSeriesItem(e,t);n&&n.markerShape&&(a=n.markerShape);var o=d.getDataItem(e,t,i);o&&o.markerShape&&(a=o.markerShape);var h=d.getNestedDataItem(e,t,i,r);if(h&&h.markerShape&&(a=h.markerShape),"auto"==a)if(l.isBubble(e)||"boxPlot"==d.getSeriesType(e,t)||d.isRangeSeries(e,t))a="circle";else{var g=d.getSeriesStyleIdx(e,t),u=s.styleDefaults.shapes;a=u[g%u.length]}return a},getMarkerSize:(e,t,i,r)=>{var s;if(l.isBubble(e)&&(s=e.getOptionsCache().getFromCachedMap2D("bubbleSizeCache",t,i)))return s;var a=d.getNestedDataItem(e,t,i,r);if(a&&null!=a.markerSize)s=Number(a.markerSize);else{var n=d.getDataItem(e,t,i);if(n&&null!=n.markerSize)s=Number(n.markerSize);else{var o=d.getSeriesItem(e,t);s=o&&null!=o.markerSize?Number(o.markerSize):Number(e.getOptions().styleDefaults.markerSize)}}return l.isOverview(e)&&(s=Math.ceil(.6*s)),s},isMarkerDisplayed:(e,t,i,r)=>{var s,a=d.getNestedDataItem(e,t,i,r);if(a&&null!=a.markerDisplayed)s=a.markerDisplayed;else{var n=d.getDataItem(e,t,i);if(n&&null!=n.markerDisplayed)s=n.markerDisplayed;else{var o=d.getSeriesItem(e,t);s=o&&null!=o.markerDisplayed?o.markerDisplayed:e.getOptions().styleDefaults.markerDisplayed}}return"on"==s||"off"!=s&&(l.isScatterBubble(e)||"boxPlot"==d.getSeriesType(e,t)||"none"==c.getLineType(e,t))},getImageSource:(e,t,i,r,s)=>{var a=d.getNestedDataItem(e,t,i,r);if(a&&a[s])return a[s];var n=d.getDataItem(e,t,i);if(n&&n[s])return n[s];var o=d.getSeriesItem(e,t);return o&&o[s]?o[s]:void 0},getLineWidth:(e,t)=>{var i,r=d.getSeriesItem(e,t),s=e.getOptions();return i=r&&r.lineWidth?r.lineWidth:s.styleDefaults.lineWidth?s.styleDefaults.lineWidth:"lineWithArea"==d.getSeriesType(e,t)?2:3,l.isOverview(e)&&(i=Math.ceil(.6*i)),i},getLineStyle:(e,t)=>{var i=d.getSeriesItem(e,t);return i&&i.lineStyle?i.lineStyle:e.getOptions().styleDefaults.lineStyle},getLineType:(e,t)=>{var i,r=d.getSeriesItem(e,t);return"auto"==(i=r&&r.lineType?r.lineType:e.getOptions().styleDefaults.lineType)&&(i=l.isScatterBubble(e)?"none":"straight"),(l.isPolar(e)||l.isScatterBubble(e))&&("centeredSegmented"==i&&(i="segmented"),"centeredStepped"==i&&(i="stepped")),i},getBarSpacing:e=>e.getOptions().__sparkBarSpacing,getMaxBarWidth:e=>{var t=e.getOptions().styleDefaults.maxBarWidth;return null==t||l.isPolar(e)?1/0:t},getBarWidth:(e,t,i)=>{e.getOptionsCache().getFromCache("hasConstantZValue")&&(t=0,i=0);var r=e.getCache().getFromCachedMap2D("barWidth",t,i);if(null!=r)return r;var s=d.getZVal(e,t,i,1)/e.getOptions()._averageGroupZ;return r=Math.min(s*c.getGroupWidth(e),c.getMaxBarWidth(e)),e.getCache().putToCachedMap2D("barWidth",t,i,r),r},getBarStackWidth:(e,t,i,r)=>{e.getOptionsCache().getFromCache("hasConstantZValue")&&(i=0);var s=r?"y2BarStackWidth":"yBarStackWidth",a=e.getCache().getFromCachedMap2D(s,t,i);if(null!=a)return a;var n=d.getBarCategoryZ(e,t,i,r)/e.getOptions()._averageGroupZ;return a=Math.min(n*c.getGroupWidth(e),c.getMaxBarWidth(e)),e.getCache().putToCachedMap2D(s,t,i,a),a},getBarCategoryOffsetMap:(e,t)=>{e.getOptionsCache().getFromCache("hasConstantZValue")&&(t=0);var i=e.getCache().getFromCachedMap("barCategoryOffsetMap",t);if(i)return i;var r,s,a=d.isStacked(e),n=d.getStackCategories(e,"bar"),o=l.isMixedFrequency(e),h=d.isSplitDualY(e),g={},u={},_=0,p=0;if(a){for(s=0;s<n.y.length;s++)r=c.getBarStackWidth(e,n.y[s],t,!1),o?g[n.y[s]]=-.5*r:(g[n.y[s]]=_,_+=r);for(h||(p=_),s=0;s<n.y2.length;s++)r=c.getBarStackWidth(e,n.y2[s],t,!0),o?u[n.y2[s]]=-.5*r:(u[n.y2[s]]=p,p+=r);h||(_=p)}else for(var v=d.getSeriesCount(e),m=0;m<v;m++){var f=d.getSeriesType(e,m);if(("bar"==f||"candlestick"==f||"boxPlot"==f)&&d.isSeriesRendered(e,m)){var x=d.isAssignedToY2(e,m),C=d.getStackCategory(e,m);r=c.getBarWidth(e,m,t),x?o?u[C]=-.5*r:(u[C]=p,p+=r):o?g[C]=-.5*r:(g[C]=_,_+=r)}}for(var S in g)g[S]-=h||a?_/2:(_+p)/2;for(var A in u)u[A]-=h||a?p/2:(_+p)/2-_;return i={y:g,y2:u},e.getCache().putToCachedMap("barCategoryOffsetMap",t,i),i},getDataItemGaps:e=>{var t=e.getOptionsCache().getFromCache("dataItemGaps");if(null!=t)return t;var i=e.getOptions();if(null!=i.styleDefaults.sliceGaps)t=i.styleDefaults.sliceGaps;else{var r=i.styleDefaults.dataItemGaps;"auto"==r&&(r="on"==i.styleDefaults.threeDEffect?"0%":"50%");var s=r&&r.indexOf?r.indexOf("%"):-1;t=s>=0?(r=r.substring(0,s))/100:0}return e.getOptionsCache().putToCache("dataItemGaps",t),t},isSelectable:(e,t,i)=>{var r=d.getSeriesItem(e,t);return(!r||"off"!=r._selectable)&&(e.isSelectionSupported()&&null!=t&&t>=0&&null!=i&&i>=0)},getAnimOnDisplay:e=>e.getOptions().animationOnDisplay,getAnimOnDataChange:e=>e.getOptions().animationOnDataChange,getAnimDur:e=>t.CSSStyle.getTimeMilliseconds(e.getOptions().styleDefaults.animationDuration)/1e3,getAnimIndicators:e=>e.getOptions().styleDefaults.animationIndicators,getAnimUpColor:e=>e.getOptions().styleDefaults.animationUpColor,getAnimDownColor:e=>e.getOptions().styleDefaults.animationDownColor,getSelectedInnerColor:e=>e.getOptions().styleDefaults.selectedInnerColor,getSelectedOuterColor:e=>e.getOptions().styleDefaults.selectedOuterColor,isSelectionHighlighted:e=>{var t=e.getOptions().styleDefaults.selectionEffect;return"highlight"==t||"highlightAndExplode"==t},isSelectionExploded:e=>{var t=e.getOptions().styleDefaults.selectionEffect;return"explode"==t||"highlightAndExplode"==t},getDataLabelStyle:(e,i,r,s,a,n,o)=>{var h,g=e.getOptions().styleDefaults,u=[g._dataLabelStyle,g.dataLabelStyle];!a||"bar"!=d.getSeriesType(e,i)&&!l.isBubble(e)||"center"!=n&&"inBottom"!=n&&"inTop"!=n&&"inRight"!=n&&"inLeft"!=n||(h=null!=c.getPattern(e,i,r,s)?"#000000":t.ColorUtils.getContrastingTextColor(a),u.push(new t.CSSStyle("color: "+h+";"))),u.push(c._parseLowHighArray(e.getOptions().styleDefaults.dataLabelStyle,o));var _=d.getDataItem(e,i,r);_&&u.push(new t.CSSStyle(c._parseLowHighArray(_.labelStyle,o)));var p=d.getNestedDataItem(e,i,r,s);return p&&u.push(new t.CSSStyle(c._parseLowHighArray(p.labelStyle,o))),h&&t.Agent.isHighContrast()&&u.push(new t.CSSStyle("color: "+h+";")),t.CSSStyle.mergeStyles(u)},getDataLabelCollisions:(e,t,i,r,s)=>{var a=t&&t.x&&t.x-i.w/2||i.x,n=t&&t.y&&t.y-i.h/2||i.y,o=c.MARKER_DATA_LABEL_GAP/2,l=e.getOptions(),h=s?u.getGapHeight(e,l.layout.legendGapHeight):u.getGapWidth(e,l.layout.legendGapWidth);return{xAxis:n+i.h+o>r.y+r.h,yAxis:a+o<r.x,y2Axis:a+i.w+o>r.x+r.w,legend:a+i.w+o>r.x+r.w+h,top:n<e.getDimensions().y}},adjustDataLabelPos:(e,t,i)=>{var r=e;return"left"!=e&&"center"!=e||!t.yAxis?"right"!=e&&"center"!=e||!(i&&t.y2Axis||t.legend)?"top"!=e&&"center"!=e||!t.top?"bottom"!=e&&"center"!=e||!t.xAxis||(r="top"):r="bottom":r="left":r="right",r},_parseLowHighArray:(e,t)=>e instanceof Array?"high"==t?e[1]:e[0]:e,isOverviewRendered:e=>{var t=e.getOptions();return l.isOverviewSupported(e)&&"off"!=t.overview.rendered},getOverviewHeight:e=>{var t=e.getOptions().overview.height;return null==t&&(t=l.hasTimeAxis(e)?.25:.2),c.getSizeInPixels(t,e.getHeight())},getSizeInPixels:(e,t)=>{if("string"==typeof e){if("%"==e.slice(-1))return t*Number(e.slice(0,-1))/100;if("px"==e.slice(-2))return Number(e.slice(0,-2));e=Number(e)}return"number"==typeof e?e<=1?t*e:e:0},getBackgroundColor:(e,t)=>{var i=e.getOptions();return i.plotArea.backgroundColor?i.plotArea.backgroundColor:t?"#FFFFFF":null},getHoverBehaviorDelay:e=>{var i=e.getOptions().styleDefaults.hoverBehaviorDelay;return i?(i=t.CSSStyle.getTimeMilliseconds(i),l.isScatterBubble(e)||l.isLine(e)?.75*i:1.25*i):0},optimizeMarkerStroke:e=>l.isScatterBubble(e)||l.isBoxPlot(e),getGroupWidth:e=>{var t=e.getCache().getFromCache("groupWidth");return null==t&&(t=e.xAxis.getInfo().getGroupWidth(),e.getCache().putToCache("groupWidth",t)),t},isStackLabelRendered:e=>{var t=e.getOptions();return"on"==t.stack&&!l.isMixedFrequency(e)&&("on"===t.stackLabel&&l.isBLAC(e))},optimizeMarkerFill:e=>l.isLineArea(e),getClassName:(e,t,i)=>{var r=d.getDataItem(e,t,i);if(r&&(r.className||r.svgClassName))return r.className||r.svgClassName;var s=d.getSeriesItem(e,t);return s&&(s.className||s.svgClassName)?s.className||s.svgClassName:null},getAreaClassName:(e,t)=>{var i=d.getSeriesItem(e,t);return i&&(i.areaClassName||i.areaSvgClassName)?i.areaClassName||i.areaSvgClassName:i&&(i.className||i.svgClassName)?i.className||i.svgClassName:null},getMarkerClassName:(e,t,i,r)=>{var s=d.getNestedDataItem(e,t,i,r);if(s&&(s.className||s.svgClassName))return s.className||s.svgClassName;var a=d.getDataItem(e,t,i);if(a&&(a.className||a.svgClassName))return a.className||a.svgClassName;var n=d.getSeriesItem(e,t);return n&&(n.markerClassName||n.markerSvgClassName)?n.markerClassName||n.markerSvgClassName:l.isScatterBubble(e)&&n&&(n.className||n.svgClassName)?n.className||n.svgClassName:null},getStyle:(e,t,i)=>{var r=d.getDataItem(e,t,i);if(r&&(r.style||r.svgStyle))return r.style||r.svgStyle;var s=d.getSeriesItem(e,t);return s&&(s.style||s.svgStyle)?s.style||s.svgStyle:null},getAreaStyle:(e,t)=>{var i=d.getSeriesItem(e,t);return i&&(i.areaStyle||i.areaSvgStyle)?i.areaStyle||i.areaSvgStyle:i&&(i.style||i.svgStyle)?i.style||i.svgStyle:null},getMarkerStyle:(e,t,i,r)=>{var s=d.getNestedDataItem(e,t,i,r);if(s&&(s.style||s.svgStyle))return s.style||s.svgStyle;var a=d.getDataItem(e,t,i);if(a&&(a.style||a.svgStyle))return a.style||a.svgStyle;var n=d.getSeriesItem(e,t);return n&&(n.markerStyle||n.markerSvgStyle)?n.markerStyle||n.markerSvgStyle:l.isScatterBubble(e)&&n&&(n.style||n.svgStyle)?n.style||n.svgStyle:null},getBoxPlotStyleOptions:(e,i,r)=>{var s=d.getDataItem(e,i,r),a=s&&s.boxPlot?s.boxPlot:{},n=d.getSeriesItem(e,i),o=n&&n.boxPlot?n.boxPlot:{},l=e.getOptions().styleDefaults.boxPlot,h=t.JsonUtils.merge(a,t.JsonUtils.merge(o,l)),g=c.getColor(e,i,r);h._color=g;var u=t.ColorUtils.getBrighter(g,.8);if(h.q2Color||(h.q2Color=u),h.q3Color||(h.q3Color=u),"pattern"==c.getSeriesEffect(e)){var _=c.getPattern(e,i,r);h._q2Pattern=_,h._q3Pattern=_}var p=c.getBorderColor(e,i,r);h.borderColor=p||g,h.borderWidth=c.getBorderWidth(e,i,r);var v=t.ColorUtils.getDarker(g,.1);return c._setBoxPlotDefaultLineColor(h,"whisker",v),c._setBoxPlotDefaultLineColor(h,"whiskerEnd",v),c._setBoxPlotDefaultLineColor(h,"median",v),h},_setBoxPlotDefaultLineColor:(e,i,r)=>{var s=t.JsonUtils.merge(e[i+"Style"],e[i+"SvgStyle"]);e[i+"SvgStyle"]=s,e[i+"Style"]=null,!s||s.stroke||e[i+"ClassName"]||e[i+"SvgClassName"]||(e[i+"SvgStyle"].stroke=r)},getDataContext:(e,t,i,r)=>{var s,a=d.getSeriesItem(e,t),n=d.getDataItem(e,t,i),o=d.getNestedDataItem(e,t,i,r),h=e.getRawOptions(),g=l.isPie(e)&&(null==t||t<0),u=e.getOptions();if(g){var p=u.translations.labelOther;s={id:p,series:p,value:_.getOtherVal(e),color:u.styleDefaults.otherColor}}else if(o){var v=h.series[t].items[i];v._noTemplate?v=v._itemData:v&&"object"==typeof v&&delete(v=Object.assign({},v))._itemData,s={id:d.getNestedDataItemId(e,t,i,r),data:[v,v.items[r]],value:d.getVal(e,t,i,r),y:d.getVal(e,t,i,r),color:c.getMarkerColor(e,t,i,r),itemData:u.series[t].items[i]._itemData}}else if(n){var m=h.series[t].items[i];m._noTemplate?m=m._itemData:m&&"object"==typeof m&&delete(m=Object.assign({},m))._itemData,s={id:d.getDataItemId(e,t,i),data:m,value:d.getVal(e,t,i),targetValue:d.getTargetVal(e,t,i),x:d.getXVal(e,t,i),y:d.getVal(e,t,i),z:d.getZVal(e,t,i),low:d.getLowVal(e,t,i),high:d.getHighVal(e,t,i),open:n.open,q1:n.q1,q2:n.q2,q3:n.q3,close:n.close,volume:n.volume,color:c.getColor(e,t,i),itemData:u.series[t].items[i]._itemData}}else a&&(s={id:d.getSeries(e,t),color:c.getColor(e,t)});if(s){s.component=u._widgetConstructor,(g||o||n)&&(s.group=d.getGroup(e,i),s.groupData=d.getGroupsDataForContext(e)[i]),!g&&(o||n||a)&&(s.series=d.getSeries(e,t),s.seriesData=d.getSeriesDataForContext(e,t)),l.isPie(e)&&e.pieChart&&(s.totalValue=e.pieChart.getTotalValue());var f=e.getOptionsCache().getFromCachedMap2D("barDims",t,i);f&&(s.dimensions=f),s=e.getCtx().fixRendererContext(s)}return s||{}},getShortDescContext:(e,t,i,r)=>{if(t<0||i<0)return null;var s=d.getDataItem(e,t,i),a=e.getRawOptions(),n=e.getOptions(),o=a.series[t].items[i];return o._noTemplate?o=o._itemData:o&&"object"==typeof o&&delete(o=Object.assign({},o))._itemData,{id:d.getDataItemId(e,t,i),data:o,value:d.getVal(e,t,i),targetValue:d.getTargetVal(e,t,i),label:d.getDefaultDataLabel(e,t,i,r),totalValue:l.isPie(e)&&e.pieChart?e.pieChart.getTotalValue():null,x:d.getXVal(e,t,i),y:d.getVal(e,t,i),z:d.getZVal(e,t,i),low:d.getLowVal(e,t,i),high:d.getHighVal(e,t,i),q1:s.q1,q2:s.q2,q3:s.q3,volume:s.volume,open:s.open,close:s.close,itemData:n.series[t].items[i]._itemData,group:d.getGroup(e,i),groupData:d.getGroupsDataForContext(e)[i],series:d.getSeries(e,t),seriesData:d.getSeriesDataForContext(e,t)}},getDataLabel:(e,t,i,r,s,a)=>{var n,o=d.getDefaultDataLabel(e,t,i,r,s,a),l=e.getOptions().dataLabel;if(l&&!a){var h=c.getDataContext(e,t,i,r);if(h.label=o,"number"==typeof(n=l(h))){var g=DvtChartFormatUtils.getValueFormat(e,"label");n=DvtChartFormatUtils.formatVal(e,g,n)}}if(e.Options.stackLabelProvider&&a){var u=c.getStackLabelContext(e,i);n=e.Options.stackLabelProvider(u)}return n||o},getStackLabelContext:(e,t)=>{for(var i=d.getSeriesCount(e),r=e.getOptions(),s=[],a=[],n=0,o=d.getGroup(e,t),l=0;l<i;l++){var h=r.series[l].items[t];s.push(h),h&&a.push(h._itemData),n+=d.getVal(e,l,t)}return{groups:o,data:s,groupData:d.getGroupsDataForContext(e)[t]||[],value:n,itemData:a}},hasCenteredSeries:e=>{if(!l.isBLAC(e))return!1;for(var t=d.getSeriesCount(e),i=0;i<t;i++)if(d.isSeriesRendered(e,i)&&"bar"!=d.getSeriesType(e,i)){var r=c.getLineType(e,i);if("centeredSegmented"==r||"centeredStepped"==r)return!0}return!1},hasUncenteredSeries:e=>{if(!l.isBLAC(e))return!1;for(var t=d.getSeriesCount(e),i=0;i<t;i++)if(d.isSeriesRendered(e,i)&&"bar"!=d.getSeriesType(e,i)){var r=c.getLineType(e,i);if("segmented"==r||"stepped"==r)return!0}return!1}};class p extends t.Container{constructor(e,i,r){super(e),this._bHoriz=r,this._options=i,this.setMouseEnabled(!1),this.setVisible(!1);var s=i.lineWidth,a=i.lineColor,n=new t.Stroke(a,1,s,!1,t.Stroke.getDefaultDashProps(i.lineStyle,s));this._cursorLine=new t.Line(this.getCtx(),0,0,0,0,"dcLine"),this._cursorLine.setStroke(n),this.addChild(this._cursorLine),this._cursorOuterLine=new t.Line(this.getCtx(),0,0,0,0,"dcLine"),this._cursorOuterLine.setClassName("oj-chart-data-cursor-outer-line"),this.addChild(this._cursorOuterLine),this.addMarker(t.SimpleMarker.CIRCLE,i.markerSize)}addMarker(e,i){if("off"!==this._options.markerDisplayed){this._marker&&this.removeChild(this._marker),this._marker=new t.Container(this._context),this._marker.setMouseEnabled(!1),this.addChild(this._marker);var r=this._options.lineColor,s=this._options.lineWidth,a=new t.SimpleMarker(this._context,e,0,0,i+4*s,i+4*s);a.setSolidFill(r),this._marker.addChild(a);var n=new t.SimpleMarker(this._context,e,0,0,i+2*s,i+2*s);n.setSolidFill("white"),this._marker.addChild(n),this._markerInnerShape=new t.SimpleMarker(this._context,e,0,0,i,i),this._marker.addChild(this._markerInnerShape)}}render(e,i,r,s,a,n){var o,l=this.isHorizontal(),h=t.Agent.isRightToLeft(this.getCtx());if(null!=a&&""!=a){var g=this.getCtx().getStageAbsolutePosition(),d=this.getCtx().getTooltipManager(p.TOOLTIP_ID);d.showDatatip(i+g.x,r+g.y,a,n,!1),o=d.getTooltipBounds();var u,_,c=this._options.markerSize+4*this._options.lineWidth;l?(u=h?e.x-.75*o.w:e.x+e.w-o.w/4,_=s-o.h/2,!h&&u-i<c?u=i+c:h&&i-(u+o.w)<c&&(u=i-c-o.w)):(u=s-o.w/2,r-((_=e.y-.75*o.h)+o.h)<c&&(_=r-c-o.h)),d.positionTip(u+g.x,_+g.y),(o=d.getTooltipBounds()).x-=g.x,o.y-=g.y}var v=this._cursorLine.getStroke().getWidth(),m=s+Math.ceil(v/2);if(l){var f,x;this._cursorLine.setTranslateY(s),this._cursorOuterLine.setTranslateY(m),h?(f=o?o.x+o.w-1:e.x,x=e.x+e.w):(f=e.x,x=o?o.x+1:e.x+e.w),this._cursorLine.setX1(f),this._cursorLine.setX2(x),this._cursorOuterLine.setX1(f),this._cursorOuterLine.setX2(x)}else{this._cursorLine.setTranslateX(s),this._cursorOuterLine.setTranslateX(m);var C=o?o.y+o.h-1:e.y,S=e.y+e.h;this._cursorLine.setY1(C),this._cursorLine.setY2(S),this._cursorOuterLine.setY1(C),this._cursorOuterLine.setY2(S)}if(this._marker){this._marker.setTranslate(i,r);var A=this._options.markerColor;this._markerInnerShape.setSolidFill(A||n),t.Agent.workaroundFirefoxRepaint(this._marker)}}isHorizontal(){return this._bHoriz}getBehavior(){return this._behavior?this._behavior:"auto"}setBehavior(e){this._behavior=e}}p.TOOLTIP_ID="_dvtDataCursor";const v={getType:e=>"area"==e.type?"area":"line",getLocation:e=>"front"==e.location?"front":"back",getColor:(e,t)=>t.color?t.color:"line"===v.getType(t)?e.getOptions()._defaultReferenceObjectLineColor:e.getOptions()._defaultReferenceObjectAreaColor,getLineWidth:(e,t)=>t.lineWidth?t.lineWidth:parseFloat(e.getOptions()._defaultReferenceObjectLineWidth),getLineType:e=>e.lineType?e.lineType:"straight",isObjRendered:(e,i)=>{var r=d.getHiddenCategories(e);if(r.length>0){var s=v.getRefObjCategories(i);if(s&&t.ArrayUtils.hasAnyItem(r,s))return!1}return"hidden"!==i.visibility},getId:e=>null!=e.id?e.id:e.text,getRefObjCategories:e=>e.categories?e.categories:[v.getId(e)],getRefObj:(e,t)=>{for(var i=d.getRefObjs(e),r=0;r<i.length;r++)if(v.getId(i[r])==t)return i[r]},getLowVal:e=>null==e?null:e.low,getHighVal:e=>null==e?null:e.high,getXVal:(e,t,i)=>d.getXValFromItem(e,t[i],i)},m={getDatatipColor:(e,t,i,r)=>l.isStock(e)?c.getColor(e,0,i):null!=r&&r>=0?c.getMarkerColor(e,t,i,r):c.getColor(e,t,i),getDatatip:(e,i,r,s,a)=>{if(l.isSpark(e)||l.isOverview(e))return null;if(i<0||r<0)return null;var n=e.getOptions().tooltip,o=n?n.renderer:null;if(a&&o){var h=e.getCtx().getTooltipManager(m.isDataCursorEnabled(e)?p.TOOLTIP_ID:null),g=c.getDataContext(e,i,r,s);if(l.isPie(e)){var u=_.getSliceBySeriesIdx(e,i);g.label=u.getSliceLabelString()}else g.label=c.getDataLabel(e,i,r,s);return h.getCustomTooltip(o,g)}var v=d.getNestedDataItem(e,i,r,s);if(v&&null!=v.shortDesc)return v.shortDesc;var f,x=d.getDataItem(e,i,r);return x&&null!=x.shortDesc?t.Displayable.resolveShortDesc(x.shortDesc,()=>c.getShortDescContext(e,i,r,s)):(l.isStock(e)?f=m._getStockDatatip(e,0,r,a):(f=[],m._addSeriesDatatip(f,e,i,r,a),m._addGroupDatatip(f,e,i,r,a),m._addValDatatip(f,e,i,r,s,a)),m._processDatatip(f,e,a))},getOtherSliceDatatip:(e,t,i)=>{var r=e.getOptions().translations.labelOther,s=e.getOptions().tooltip,a=s?s.renderer:null;if(i&&a){var n=_.getSliceBySeriesIdx(e,null),o=c.getDataContext(e,null,0);return o.label=n.getSliceLabelString(),e.getCtx().getTooltipManager().getCustomTooltip(a,o)}var l=[];return m._addDatatipRow(l,e,"series","labelSeries",r,i),m._addGroupDatatip(l,e,0,0,i),m._addDatatipRow(l,e,"value","labelValue",t,i),m._processDatatip(l,e,i)},_processDatatip:(e,i,r)=>0===e.length?null:r?t.HtmlTooltipManager.createElement("table",null,e,["oj-dvt-datatip-table"]):e.join(""),getRefObjTooltip:(e,t,i,r)=>{var s=e.getOptions().tooltip,a=s?s.renderer:null;if(a&&null!=t.id){var n=e.getCtx().getTooltipManager(m.isDataCursorEnabled(e)?p.TOOLTIP_ID:null),o={id:v.getId(t),label:t.text,data:e.getRawOptions()[i].referenceObjects[r],value:t.value,low:v.getLowVal(t),high:v.getHighVal(t),color:v.getColor(e,t)};return n.getCustomTooltip(a,o)}return t.shortDesc},_getStockDatatip:(e,t,i,r)=>{var s=d.getDataItem(e,t,i),a=[];return m._addGroupDatatip(a,e,t,i,r),s&&(m._addDatatipRow(a,e,"open","labelOpen",s.open,r),m._addDatatipRow(a,e,"close","labelClose",s.close,r),m._addDatatipRow(a,e,"high","labelHigh",s.high,r),m._addDatatipRow(a,e,"low","labelLow",s.low,r),m._addDatatipRow(a,e,"volume","labelVolume",s.volume,r)),a},_addSeriesDatatip:(e,t,i,r,s)=>{var a=d.getSeriesLabel(t,i);m._addDatatipRow(e,t,"series","labelSeries",a,s)},_addGroupDatatip:(e,t,i,r,s)=>{var a;if(l.hasTimeAxis(t)){var n=g.getValueFormat(t,"group"),o=d.getXVal(t,i,r);null==(a=g.formatDateVal(n,o))&&(a=t.xAxis.getInfo().formatLabel(o))}else a=d.getGroupLabel(t,r);var h=d.getNumLevels(t),u="labelGroup";if(1!=h&&Array.isArray(a))for(var _=h-1;_>=0;_--)m._addDatatipRow(e,t,"group",u,a[_],s,_),a[_]&&(u=null);else m._addDatatipRow(e,t,"group",u,a,s)},_addValDatatip:(e,t,i,r,s,a)=>{var n=d.getVal(t,i,r,s),o=d.getXVal(t,i,r),h=d.getZVal(t,i,r),g=d.getLowVal(t,i,r),u=d.getHighVal(t,i,r),_=null!=s&&s>=0;if(l.isScatterBubble(t))m._addDatatipRow(e,t,"x","labelX",o,a),m._addDatatipRow(e,t,"y","labelY",n,a),l.isBubble(t)&&m._addDatatipRow(e,t,"z","labelZ",h,a);else if(l.isPie(t)||l.isPyramid(t))m._addDatatipRow(e,t,"value","labelValue",n,a);else if(l.isFunnel(t)){m._addDatatipRow(e,t,"value","labelValue",n,a);var c=d.getTargetVal(t,i);null!=c&&m._addDatatipRow(e,t,"targetValue","labelTargetValue",c,a)}else if("boxPlot"!=d.getSeriesType(t,i)||_){if(l.isBLAC(t)){var p=d.isAssignedToY2(t,i)?"y2":"y";null==g&&null==u||_?null==h||_?m._addDatatipRow(e,t,p,"labelValue",n,a):(m._addDatatipRow(e,t,p,"labelY",n,a),m._addDatatipRow(e,t,"z","labelZ",h,a)):(m._addDatatipRow(e,t,"high","labelHigh",u,a),m._addDatatipRow(e,t,"low","labelLow",g,a),null!=h&&m._addDatatipRow(e,t,"z","labelZ",h,a))}}else{var v=d.getDataItem(t,i,r);m._addDatatipRow(e,t,"high","labelHigh",u,a),m._addDatatipRow(e,t,"q3","labelQ3",v.q3,a),m._addDatatipRow(e,t,"q2","labelQ2",v.q2,a),m._addDatatipRow(e,t,"q1","labelQ1",v.q1,a),m._addDatatipRow(e,t,"low","labelLow",g,a),null!=h&&m._addDatatipRow(e,t,"z","labelZ",h,a)}},_addDatatipRow:(e,i,r,s,a,n,o)=>{if(null!=a&&""!==a){var h,d=i.getOptions().styleDefaults,u=g.getValueFormat(i,r),_=u.tooltipDisplay,c=i.getOptions().translations;if(_&&"auto"!=_||"group"==r&&(l.isPie(i)||l.isFunnel(i))&&(_="off"),"off"!=_)if("string"==typeof u.tooltipLabel?h=u.tooltipLabel:Array.isArray(u.tooltipLabel)&&(h=u.tooltipLabel[o||0]),null==h&&(h=null==s?"":"labelGroup"==s&&l.hasTimeAxis(i)?c.labelDate:c[s]),"series"!=r&&"group"!=r&&(a=g.formatVal(i,u,a)),n){var p=[t.HtmlTooltipManager.createElement("td",d.tooltipLabelStyle,h,["oj-dvt-datatip-label"]),t.HtmlTooltipManager.createElement("td",d.tooltipValueStyle,a,["oj-dvt-datatip-value"])];e.push(t.HtmlTooltipManager.createElement("tr",null,p))}else e.push((e.length>0?"<br>":"")+t.ResourceUtils.format(c.labelAndValue,[h,a]))}},isDataCursorEnabled:e=>{if(l.isPie(e)||l.isFunnel(e)||l.isPolar(e)||l.isPyramid(e))return!1;var i=e.getOptions();return"on"==i.dataCursor||"off"!=i.dataCursor&&(t.Agent.isTouchDevice()&&l.isLineArea(e))},getDataCursorBehavior:e=>{var t=e.getOptions().dataCursorBehavior;return"auto"!==t?t:l.isLineArea(e)?"smooth":"snap"}};class f{constructor(e,i,r,s,a,n){if(this._chart=e,this._displayables=i,this._seriesIndex=null!=r&&r>=0?r:-1,this._groupIndex=null!=s&&s>=0?s:-1,this._itemIndex=null!=a&&a>=0?a:-1,this._dataPos=n,this._isSelected=!1,this._isShowingKeyboardFocusEffect=!1,this._series=d.getSeries(e,r),this._group=d.getGroup(e,s),this._categories=d.getCategories(e,r,s,a),-1!=this._itemIndex)this._dataItemId=d.getNestedDataItemId(e,r,s,a),this._drillable=d.isDataItemDrillable(e,r,s,a);else if(-1!=this._groupIndex){d.getDataItem(e,r,s)&&(this._dataItemId=d.getDataItemId(e,r,s),this._drillable=d.isDataItemDrillable(e,r,s))}else{d.getSeriesItem(e,r)&&(this._drillable=d.isSeriesDrillable(e,r))}if(this._drillable)for(var o=0;o<this._displayables.length;o++)this._displayables[o].setCursor(t.SelectionEffectUtils.getSelectingCursor());for(var l=0;l<i.length;l++){var h=i[l];"lineArea"!==h.chartShapeType&&h.setAriaRole("img"),this._updateAriaLabel(h)}}static associate(e,t,i,r,s,a){if(e&&!t.getOptions()._duringZoomAndScroll){var n=new f(t,[e],i,r,s,a);t.registerObject(n),t.getEventManager().associate(e,n)}}getId(){return this._seriesIndex>=0&&this._groupIndex>=0?new o(this._dataItemId,this.getSeries(),this.getGroup(),this._chart.getCtx()):this._seriesIndex>=0?this.getSeries():null}getDataItemId(){return this._dataItemId}getNestedDataItemIndex(){return this._itemIndex}getSeries(){return this._series}getSeriesIndex(){return this._seriesIndex}getGroup(){return this._group}getGroupIndex(){return this._groupIndex}isDrillable(){return this._drillable}isDoubleClickable(){return this.isSelectable()&&this.isDrillable()}getChart(){return this._chart}getDatatip(){return m.getDatatip(this._chart,this._seriesIndex,this._groupIndex,this._itemIndex,!0)}getDatatipColor(){return m.getDatatipColor(this._chart,this._seriesIndex,this._groupIndex,this._itemIndex)}isSelectable(){return c.isSelectable(this.getChart(),this.getSeriesIndex(),this.getGroupIndex())}isSelected(){return this._isSelected}setSelected(e){this._isSelected=e;for(var t=0;t<this._displayables.length;t++)this._displayables[t].setSelected&&(this._displayables[t].setSelected(e),this._updateAriaLabel(this._displayables[t]))}showHoverEffect(){for(var e=0;e<this._displayables.length;e++)this._displayables[e].showHoverEffect&&this._displayables[e].showHoverEffect()}hideHoverEffect(){for(var e=0;e<this._displayables.length;e++)this._displayables[e].hideHoverEffect&&this._displayables[e].hideHoverEffect()}getDisplayables(){return this._displayables}getAriaLabel(){var e=[],i=this.getChart().getOptions().translations;this.isSelectable()&&e.push(i[this.isSelected()?"stateSelected":"stateUnselected"]),this.isDrillable()&&e.push(i.stateDrillable);var r=m.getDatatip(this._chart,this._seriesIndex,this._groupIndex,this._itemIndex,!1);return null==r&&this._groupIndex<0&&e.length>0&&(r=d.getSeriesLabel(this._chart,this._seriesIndex)),t.Displayable.generateAriaLabel(r,e,()=>c.getShortDescContext(this._chart,this._seriesIndex,this._groupIndex,this._itemIndex,!1))}_updateAriaLabel(e){t.Agent.deferAriaCreation()||e.setAriaProperty("label",this.getAriaLabel())}getCategories(e){return this._categories}getDataPosition(){return this._dataPos}getNextNavigable(e){var i,r;if(i=e.keyCode,e.type==t.MouseEvent.CLICK)return this;if(i==t.KeyboardEvent.SPACE&&e.ctrlKey)return this;for(var s=this._chart,a=s.getChartObjPeers(),n=[],o=0;o<a.length;o++)a[o].isNavigable()&&n.push(a[o]);var h=e.keyCode==t.KeyboardEvent.UP_ARROW||e.keyCode==t.KeyboardEvent.DOWN_ARROW,g=l.isHorizontal(s),u=t.Agent.isRightToLeft(s.getCtx());return l.isScatterBubble(s)||l.isBoxPlot(s)&&(h&&!g||!h&&g)?r=t.KeyboardHandler.getNextAdjacentNavigable(this,e,n):l.isLineArea(s)||d.isStacked(s)||l.isPolar(s)?r=this._findNextNavigable(e):l.isFunnel(s)&&h?(e.keyCode=u?e.keyCode==t.KeyboardEvent.UP_ARROW?t.KeyboardEvent.RIGHT_ARROW:t.KeyboardEvent.LEFT_ARROW:e.keyCode-1,r=t.KeyboardHandler.getNextNavigable(this,e,n)):l.isPyramid(s)&&!h?(e.keyCode=u?e.keyCode==t.KeyboardEvent.RIGHT_ARROW?t.KeyboardEvent.DOWN_ARROW:t.KeyboardEvent.UP_ARROW:e.keyCode==t.KeyboardEvent.RIGHT_ARROW?t.KeyboardEvent.UP_ARROW:t.KeyboardEvent.DOWN_ARROW,r=t.KeyboardHandler.getNextNavigable(this,e,n)):r=t.KeyboardHandler.getNextNavigable(this,e,n,!0),r}getKeyboardBoundingBox(e){return this._displayables[0]?this._displayables[0].getDimensions(e):new t.Rectangle(0,0,0,0)}getTargetElem(){return this._displayables[0]?this._displayables[0].getElem():null}showKeyboardFocusEffect(){this.isNavigable()&&(this._isShowingKeyboardFocusEffect=!0,this.showHoverEffect())}hideKeyboardFocusEffect(){this.isNavigable()&&(this._isShowingKeyboardFocusEffect=!1,this.hideHoverEffect())}isShowingKeyboardFocusEffect(){return this._isShowingKeyboardFocusEffect}isNavigable(){return-1!=this.getGroupIndex()&&-1!=this.getSeriesIndex()}_findNextNavigable(e){var i,r,s=e.keyCode,a=this._chart,n=a.getCtx(),o=this.getSeriesIndex(),h=this.getGroupIndex(),g=d.getGroupCount(a),u=l.isHorizontal(a),_=l.isPolar(a),c=t.Agent.isRightToLeft(n),p=u?c?s==t.KeyboardEvent.LEFT_ARROW:s==t.KeyboardEvent.RIGHT_ARROW:s==t.KeyboardEvent.UP_ARROW,v=u?c?s==t.KeyboardEvent.RIGHT_ARROW:s==t.KeyboardEvent.LEFT_ARROW:s==t.KeyboardEvent.DOWN_ARROW,m=u?s==t.KeyboardEvent.UP_ARROW:c?s==t.KeyboardEvent.RIGHT_ARROW:s==t.KeyboardEvent.LEFT_ARROW,f=u?s==t.KeyboardEvent.DOWN_ARROW:c?s==t.KeyboardEvent.LEFT_ARROW:s==t.KeyboardEvent.RIGHT_ARROW;if(p)r=h,i=this._findNextUpSeries(a,o,h);else if(v)r=h,i=this._findNextDownSeries(a,o,h);else if(f){i=o,r=h;do{r++,_&&r>=g&&(r=0)}while(null==a.getObject(i,r)&&r<g)}else if(m){i=o,r=h;do{r--,_&&r<0&&(r=g-1)}while(null==a.getObject(i,r)&&r>-1)}var x=a.getObject(i,r);return x&&x.isNavigable()?x:this}_findNextUpSeries(e,t,i){for(var r=d.isStacked(e),s=d.getSeriesCount(e),a=d.getCumulativeVal(e,t,i),n=null,o=null,l=0;l<s;l++)if(d.isSeriesRendered(e,l)&&null!=d.getVal(e,l,i)&&(!r||null!=e.getObject(l,i))){var h=d.getCumulativeVal(e,l,i);(h>a||h==a&&l>t)&&(null!==n&&h<n||null==n)&&(n=h,o=l)}return o}_findNextDownSeries(e,t,i){for(var r=d.isStacked(e),s=d.getSeriesCount(e),a=d.getCumulativeVal(e,t,i),n=null,o=null,l=s-1;l>=0;l--)if(d.isSeriesRendered(e,l)&&null!=d.getVal(e,l,i)&&(!r||null!=e.getObject(l,i))){var h=d.getCumulativeVal(e,l,i);(h<a||h==a&&l<t)&&(null!==n&&h>n||null==n)&&(n=h,o=l)}return o}isDragAvailable(e){return!0}getDragTransferable(){return[this.getId()]}getDragFeedback(){if(this._chart.isSelectionSupported()&&this._chart.getSelectionHandler().getSelectedCount()>1){for(var e=this._chart.getSelectionHandler().getSelection(),t=[],i=0;i<e.length;i++)t=t.concat(e[i].getDisplayables());return t}return this._displayables}}class x{constructor(e,t,i,r,s){this._chart=e,this._displayables=t,this._refObj=i,this._categories=v.getRefObjCategories(this._refObj),this._index=r,this._axisType=s;for(var a=0;a<t.length;a++){var n=t[a];n.setAriaRole("img"),n.setAriaProperty("label",i.shortDesc)}}getCategories(){return this._categories}getDisplayables(){return this._displayables}getIndex(){return this._index}getAxisType(){return this._axisType}getDatatip(){return m.getRefObjTooltip(this._chart,this._refObj,this._axisType,this._index)}getDatatipColor(){return v.getColor(this._chart,this._refObj)}}class C extends t.BaseComponentDefaults{constructor(e){super({alta:{position:null,baselineScaling:"zero",axisLine:{lineColor:"#9E9E9E",lineWidth:1,rendered:"on"},majorTick:{lineColor:"rgba(196,206,215,0.4)",baselineColor:"auto",lineWidth:1,rendered:"auto",lineStyle:"solid"},minorTick:{lineColor:"rgba(196,206,215,0.2)",lineWidth:1,rendered:"off",lineStyle:"solid"},tickLabel:{scaling:"auto",style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_11+"color: #333333;"),rotation:"auto",rendered:"on"},titleStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color: #737373;"),startGroupOffset:0,endGroupOffset:0,layout:{titleGap:6,radialLabelGap:5,insideLabelGapWidth:4,insideLabelGapHeight:2,hierarchicalLabelGapHeight:8,hierarchicalLabelGapWidth:15},_locale:"en-us"}},e)}getNoCloneObject(){return{tickLabel:{converter:!0}}}static getGapSize(e,i,r){var s=Math.min(t.TextUtils.getTextStringHeight(e,i.tickLabel.style)/14,1);return Math.ceil(r*s)}}class S extends i.BaseAxisInfo{constructor(e,t,i){super(e,t,i),this._title=null}getLabels(e,t){return null}getTitle(){return this._title}setTitle(e){this._title=e}getMajorTickCoords(){return[]}getMinorTickCoords(){return[]}getBaselineCoord(){return null}getDatatip(e,t){return null}getLabelBackground(e,t){return null}isDrillable(e){return null}isLabelRotated(){return!1}CreateLabel(e,i,r,s,a){var n;if("tangential"==this.Position){var o=16/180*Math.PI,l=1/180*Math.PI,h=.5*this.getTickLabelHeight(),g=this._radius+h;(r<l||r>2*Math.PI-l)&&(g+=h);var d=Math.round(g*Math.sin(r)),u=Math.round(-g*Math.cos(r));n=s?new t.BackgroundOutputText(e,i,d,u,s):new t.OutputText(e,i,d,u),r<l||Math.abs(r-Math.PI)<l||r>2*Math.PI-l?n.alignCenter():r<Math.PI?n.alignLeft():n.alignRight(),Math.abs(r-Math.PI/2)<o||Math.abs(r-3*Math.PI/2)<o?n.alignMiddle():r<Math.PI/2||r>3*Math.PI/2?n.alignBottom():n.alignTop()}else a?n=s?new t.BackgroundMultilineText(e,i,r,r,s):new t.MultilineText(e,i,r,r):(n=s?new t.BackgroundOutputText(e,i,r,r,s):new t.OutputText(e,i,r,r)).alignMiddle(),n.alignCenter();return(n instanceof t.OutputText||n instanceof t.MultilineText)&&n.setCSSStyle(this.Options.tickLabel.style),n}IsOverlapping(e,i,r){if(!e||e.length<=0)return!1;for(var s,a,n,o,l="left"==this.Position||"right"==this.Position||"radial"==this.Position,h=t.Agent.isRightToLeft(this.getCtx()),g=this.GetTickLabelGapSize(),d=0;d<e.length;d+=i+1)if(null!=e[d]){if(null!=r&&e[d].w>r[d])return!0;if(null!=s&&null!=a){if(l){if(n=e[d].y,o=e[d].y+e[d].h,n>=s&&n-g<a)return!0;if(n<s&&o+g>s)return!0}else{if(n=e[d].x,o=e[d].x+e[d].w,!h&&n-g<a)return!0;if(h&&o+g>s)return!0}s=n,a=o}else l?(s=e[d].y,a=e[d].y+e[d].h):(s=e[d].x,a=e[d].x+e[d].w)}return!1}IsOverlappingDims(e,t){if(!e||!t)return!1;var i=e.y,r=e.y+e.h,s=e.x,a=e.x+e.w,n=t.y,o=t.y+t.h,l=t.x,h=t.x+t.w;return(s<=l&&l<=a||s<=h&&h<=a||l<=s&&s<=h||l<=a&&a<=h)&&(n>=i&&n<r||n<=i&&o>=i)}GetTickLabelGapSize(){var e=this.getTickLabelHeight(),t=this instanceof S._constructors.group?.24*e:.79*e,i=this instanceof S._constructors.group?.08*e:.28*e;return"left"==this.Position||"right"==this.Position||"radial"==this.Position||this.isLabelRotated()?i:t}getTickLabelHeight(){return t.TextUtils.getTextStringHeight(this.getCtx(),this.Options.tickLabel.style)}SkipLabels(e,t){for(var i=0,r=this.IsOverlapping(t,i);r;)i++,r=this.IsOverlapping(t,i);if(i>0){for(var s=[],a=0;a<e.length;a+=i+1)s.push(e[a]);return s}return e}SkipTangentialLabels(e,t){var i=[],r=e.length,s=null;if(r>1){for(var a,n=0;n<r;n++)t[n]&&(!a||a&&!this.IsOverlappingDims(a,t[n]))&&(s||(s=t[n]),i.push(e[n]),a=t[n]);return this.IsOverlappingDims(a,s)&&i.pop(),i}return e}GetLabelDims(e,t,i){for(var r=[],s=this.isLabelRotated(i),a=0;a<e.length;a++){var n=e[a];if(null!=n){var o=n.getDimensions(t);null!=i&&(o.x=(s?n.getTranslateX():n.getX())-o.w/2,o.y=(s?n.getTranslateY():n.getY())-o.h/2),o.w&&o.h?r.push(o):r.push(null)}else r.push(null)}return r}getMajorTickCount(){return null}getMinorTickCount(){return null}getMajorIncrement(){return null}getMinorIncrement(){return null}getGlobalMin(){return this.GlobalMin}getGlobalMax(){return this.GlobalMax}getViewportMin(){return this.MinValue}getViewportMax(){return this.MaxValue}getDataMin(){return this.DataMin}getDataMax(){return this.DataMax}getMinExtent(){return 0}getStartCoord(){return this.StartCoord}getEndCoord(){return this.EndCoord}getStartOverflow(){return this.StartOverflow}getEndOverflow(){return this.EndOverflow}getGroupWidth(){return 0}getGroup(e,t){return null}linearToActual(e){return e}actualToLinear(e){return e}alignLogScaleToTickCount(e,t){return e}getLogScaleUnit(){return null}static registerConstructor(e,t){S._constructors[e]=t}static getConstructor(e){return S._constructors[e]}static newInstance(e,t,i){return t.timeAxisType&&"disabled"!=t.timeAxisType?new S._constructors.time(e,t,i):t._isGroupAxis?new S._constructors.group(e,t,i):new S._constructors.data(e,t,i)}}S._constructors=[];class A extends t.SimpleObjPeer{constructor(e,i,r,s,a,n,o){super(a,n,null,o),this._axis=e,this._label=i,this._group=r,this._drillable=s,this._drillable&&i.setCursor(t.SelectionEffectUtils.getSelectingCursor()),e.__registerObject(this)}getLabel(){return this._label}getId(){return this._group}isDrillable(){return this._drillable}getGroup(){return this._group}getNextNavigable(e){if(e.type==t.MouseEvent.CLICK)return this;var i=this._axis.__getKeyboardObjects();return t.KeyboardHandler.getNextNavigable(this,e,i,!1,this._axis.getCtx().getStage())}getKeyboardBoundingBox(e){return this._label?this._label.getDimensions(e):new t.Rectangle(0,0,0,0)}getDisplayable(){return this._label}getTargetElem(){return this._label?this._label.getElem():null}showKeyboardFocusEffect(){if(this._isShowingKeyboardFocusEffect=!0,this._label){var e=this.getKeyboardBoundingBox();this._overlayRect=new t.Rect(this._axis.getCtx(),e.x,e.y,e.w,e.h),this._overlayRect.setSolidStroke(t.Agent.getFocusColor()),this._overlayRect.setInvisibleFill(),this._overlayRect.setMatrix(this._label.getMatrix()),this._axis.addChild(this._overlayRect)}}hideKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!1,this._label&&(this._axis.removeChild(this._overlayRect),this._overlayRect=null)}isShowingKeyboardFocusEffect(){return this._isShowingKeyboardFocusEffect}getAriaLabel(){var e;return this.isDrillable()&&(e=[this._axis.getOptions().translations.stateDrillable]),null!=this.getDatatip()?t.Displayable.generateAriaLabel(this.getDatatip(),e):null!=e?t.Displayable.generateAriaLabel(this.getLabel().getTextString(),e):void 0}isDragAvailable(e){return!0}getDragTransferable(e,t){return[this.getId()]}getDragFeedback(e,t){return[this.getDisplayable()]}}class b extends t.EventManager{constructor(e){super(e.getCtx(),e.processEvent,e,e),this._axis=e}OnClick(e){super.OnClick(e);var t=this.GetLogicalObject(e.target);t&&(this.processDrillEvent(t)&&e.stopPropagation())}HandleTouchClickInternal(e){var t=this.GetLogicalObject(e.target);if(t){var i=e.touchEvent;this.processDrillEvent(t)&&i&&i.preventDefault()}}processDrillEvent(e){return!!(e instanceof A&&e.isDrillable())&&(this.FireEvent(t.EventFactory.newChartDrillEvent(e.getId(),null,e.getGroup(),"group"),this._axis),!0)}isDndSupported(){return!0}GetDragSourceType(){var e=this.DragSource.getDragObject();return e instanceof A&&null!=e.getGroup()?"groups":null}GetDragDataContexts(e){var i=this.DragSource.getDragObject();if(i instanceof A){var r={id:i.getId(),group:i.getGroup(),label:i.getLabel().getTextString()};return e&&t.ToolkitUtils.cleanDragDataContext(r),[r]}return[]}static getUIParams(e,t,i,r){return{type:e,id:t,index:i,level:r}}}const y={_MAX_TITLE_LINE_WRAP:3,getPreferredSize:(e,i,r,s)=>{var a=y._createAxisInfo(e,new t.Rectangle(0,0,i,r)),n=e.getCtx(),o=e.getOptions(),l="top"==o.position||"bottom"==o.position;if(("off"==o.rendered||i<=0||r<=0)&&!s)return l?new t.Dimension(i,0):new t.Dimension(0,r);var h=y.getTitleHeight(n,o,.8*(l?i:r),.8*(l?r:i)),g=0!=h?h+y._getTitleGap(e):0;if("on"==o.tickLabel.rendered&&"inside"!=o.tickLabel.position)if(l){var d=t.TextUtils.getTextStringHeight(n,o.tickLabel.style);a instanceof S.getConstructor("data")?g+=d:a instanceof S.getConstructor("time")?g+=null!=a.getLabels(n,1)?2*d:d:a instanceof S.getConstructor("group")&&(g=y._getGroupAxisPreferredSize(e,a,g,r,l))}else if(a instanceof S.getConstructor("data"))g+=t.TextUtils.getMaxTextStringWidth(n,a.getAllLabels(n,!0),a.Options.tickLabel.style);else if(a instanceof S.getConstructor("time")){var u=a.getLabels(n),_=t.TextUtils.getMaxTextDimensions(u).w,c=a.getLabels(n,1),p=null!=c?t.TextUtils.getMaxTextDimensions(c).w:0;g+=Math.max(_,p)}else a instanceof S.getConstructor("group")&&(g=y._getGroupAxisPreferredSize(e,a,g,i,l));return l?new t.Dimension(i,Math.min(g,r)):new t.Dimension(Math.min(g,i),r)},render:(e,t)=>{var i=y._createAxisInfo(e,t);"off"!=e.getOptions().rendered&&(e.__setBounds(t.clone()),y._renderBackground(e,t),y._renderTitle(e,i,t),y._renderLabels(e,i,t))},_createAxisInfo:(e,t)=>{var i=S.newInstance(e.getCtx(),e.getOptions(),t);return e.__setInfo(i),i},_getTitleGap:e=>{var t=e.getOptions();return C.getGapSize(e.getCtx(),t,t.layout.titleGap)},_renderBackground:(e,i)=>{var r=e.getOptions();if(r.dnd){var s=r.dnd.drop,a=Object.keys(s.xAxis).length>0||Object.keys(s.yAxis).length>0||Object.keys(s.y2Axis).length>0,n=r.dnd.drag,o=Object.keys(n.groups).length>0&&e.getInfo()instanceof S.getConstructor("group");if(a||o){var l=r.position,h="top"==l||"bottom"==l,g=h?4:10,d=h?10:4,u=new t.Rect(e.getCtx(),i.x-d,i.y-g,i.w+2*d,i.h+2*g);o&&u.setClassName("oj-draggable"),u.setInvisibleFill(),e.getCache().putToCache("background",u),e.addChild(u)}}},_renderTitle:(e,i,r)=>{var s=e.getOptions();if(s.title){var a=s.position;if("radial"!==a&&"tangential"!==a){var n="top"===s.position||"bottom"===s.position,o=n?r.w:r.h,l=n?r.h:r.w,h=s.titleStyle,g=y.isWrapEnabled(h),d=y._createText(e.getEventManager(),e,s.title,h,0,0,o,l,b.getUIParams("title"),g);if(d){var u=y._getTitleGap(e),_=(i.getStartOverflow()-i.getEndOverflow())/2,c=t.Agent.isRightToLeft(e.getCtx()),p=d.getDimensions().h;d.alignCenter(),"top"===a?(d.setX(r.x+_+r.w/2),d.setY(r.y),r.y+=p+u,r.h-=p+u):"bottom"===a?(d.setX(r.x+_+r.w/2),d.setY(r.y+r.h-p),r.h-=p+u):"left"===a?(d.alignMiddle(),d.setRotation(c?Math.PI/2:3*Math.PI/2),d.setTranslate(r.x+p/2,r.y+r.h/2),r.x+=p+u,r.w-=p+u):"right"===a&&(d.alignMiddle(),d.setRotation(c?Math.PI/2:3*Math.PI/2),d.setTranslate(r.x+r.w-p/2,r.y+r.h/2),r.w-=p+u),i.setTitle(d)}}}},_renderLabels:(e,t,i)=>{var r=e.getOptions();if("on"==r.tickLabel.rendered){var s=r.position;"top"===s||"bottom"===s?y._renderLabelsHoriz(e,t,i):"tangential"===s?y._renderLabelsTangent(e,t,i):y._renderLabelsVert(e,t,i),y._renderGroupSeparators(e,t,i)}},_renderLabelsHoriz:(e,i,r)=>{var s=e.getCtx(),a=e.getOptions(),n=a.position,o="inside"==a.tickLabel.position,l=t.Agent.isRightToLeft(s),h=i instanceof S.getConstructor("group"),g=h&&i.getNumLevels()>1,d=g?0:null,u=i.getLabels(s,d);for(f=g?C.getGapSize(s,a,a.layout.hierarchicalLabelGapHeight):0;u;){for(var _=0,c=0,p=0;p<u.length;p++){var v=u[p];if(null!=v){var m=v instanceof t.MultilineText||v instanceof t.BackgroundMultilineText;if(i.isLabelRotated(d)){if((!m||m&&!v.isWrapEnabled())&&!t.TextUtils.fitText(v,r.h,r.w,e))continue;l?v.alignLeft():v.alignRight(),g?(_=v.getDimensions().w,v.setTranslateY(r.h-_),c=Math.max(c,_)):v.setTranslateY(r.y)}else{if(!o&&v.getDimensions().h-1>r.h)continue;if(g&&"bottom"===n?v.setY(r.h):"bottom"===n?v.setY(r.y):v.setY(r.y+r.h),!g&&("bottom"===n&&!o||"top"===n&&o)||g&&"top"===n?v.alignTop():v.alignBottom(),g)c=Math.max(c,v.getDimensions().h);else if(o){var f=C.getGapSize(s,a,a.layout.insideLabelGapWidth);l?v.alignRight():v.alignLeft(),v.setX(v.getX()+f*(l?-1:1))}}var x=h?i.getLabelIdx(v):p,y=i.getDatatip(x,d),M=v.getUntruncatedTextString(),D=i.isDrillable(x,d),T=i.getGroup(x,d),I=b.getUIParams("tickLabel",v.getTextString(),x,d);e.getEventManager().associate(v,new A(e,v,T,D,M,y,I)),g?i.setLastRenderedLevel(d):c=Math.max(c,v.getDimensions().h),e.addChild(v)}}if(g){for(p=0;p<u.length;p++)if(null!=(v=u[p])){var O=i.isLabelRotated(d),E=d<i.getNumLevels()-1;!O&&E?(v.setY(r.h-c/2),v.alignMiddle()):v.setTranslateY(r.h-c)}r.y+=c+f,r.h-=c+f,d++,u=i.getLabels(e.getCtx(),d)}else r.y+=c,r.h-=c,u=null}if(i instanceof S.getConstructor("time")){u=i.getLabels(e.getCtx());var P=i.getLabels(e.getCtx(),1),L=0;if(null!=P)for(p=0;p<P.length;p++)if(null!=(v=P[p])&&!(v.getDimensions().h-1>r.h)){e.getEventManager().associate(v,new t.SimpleObjPeer(null,null,null,b.getUIParams("tickLabel",v.getTextString())));var w=0,R=0,k=i.getOptions()._maxOverflowCoord,B=i.getOptions()._minOverflowCoord;if(null!=u[p]&&(L=u[p].getDimensions().w/2,w=i._level1Overflow[p],R=i._level2Overflow[p]),0==w&&0==R){var F,N=v.getX();l?(F=N+L<=k?N+L:k,v.setX(F)):(F=N-L>=B?N-L:B,v.setX(F))}else w<0?v.setX(B):w>0&&v.setX(k);v.alignTop(),v.setY(r.y),e.addChild(v)}}},_renderLabelsVert:(e,i,r)=>{var s,a,n,o=e.getOptions(),l=o.position,h=e.getCtx(),g=t.Agent.isRightToLeft(h),d=i instanceof S.getConstructor("data"),u="inside"==o.tickLabel.position,_=i instanceof S.getConstructor("group"),c=_&&i.getNumLevels()>1,p=c?0:null;s=i.getLabels(e.getCtx(),p);var v=0;c?(a=C.getGapSize(h,o,o.layout.hierarchicalLabelGapWidth),n=t.TextUtils.getMaxTextDimensions(s).w):"radial"===l?(a=C.getGapSize(h,o,o.layout.radialLabelGap),v=r.x+r.w/2,g?v+=a+t.TextUtils.getMaxTextDimensions(s).w:v-=a):"left"===l?(v=r.x+r.w,d&&u&&(v+=t.TextUtils.getMaxTextDimensions(s).w)):(v=r.x,d&&!u&&(v+=t.TextUtils.getMaxTextDimensions(s).w));for(var m=(a,m)=>{var f=a instanceof t.MultilineText||a instanceof t.BackgroundMultilineText,x=!f||f&&!a.isWrapEnabled();if(!(c&&t.TextUtils.getMaxTextDimensions(s).w-1>r.w)&&(c||u||!x||t.TextUtils.fitText(a,r.w,r.h,e))){m=_?i.getLabelIdx(a):m;var S=i.getDatatip(m,p),y=a.getUntruncatedTextString(),M=i.isDrillable(m,p),D=i.getGroup(m,p),T=b.getUIParams("tickLabel",a.getTextString(),m,p);if(e.getEventManager().associate(a,new A(e,a,D,M,y,S,T)),c)a.alignRight(),a.setX(g?r.w:r.x+n),i.setLastRenderedLevel(p);else if(a.setX(v),d||"right"!=l?a.alignRight():a.alignLeft(),u&&(a.alignBottom(),a.setY(a.getY()-C.getGapSize(h,o,o.layout.insideLabelGapHeight))),"radial"===l){var I=a.getY();a.setY(r.y+r.h/2-I);var O=a.getDimensions(),E=.15*O.h,P=t.PathUtils.roundedRectangle(O.x-E,O.y,O.w+2*E,O.h,2,2,2,2),L=new t.Path(e.getCtx(),P),w=a.getCSSStyle().getStyle(t.CSSStyle.BACKGROUND_COLOR),R=I+O.h/2>i.getEndCoord()&&"circle"==e.getOptions().polarGridShape?"outside":"inside";w?L.setSolidFill(w):L.setClassName("oj-chart-polar-axis-tick-label-"+R),e.addChild(L)}e.addChild(a)}};s;){for(var f=0;f<s.length;f++){var x=s[f];null!=x&&m(x,f)}if(!c)break;r.x+=n+a,r.w-=n+a,p++,s=i.getLabels(e.getCtx(),p),n=s?t.TextUtils.getMaxTextDimensions(s).w:null}if(i instanceof S.getConstructor("time")){var y=i.getLabels(e.getCtx(),1);if(null!=y)for(f=0;f<y.length;f++)null!=(x=y[f])&&m(x,f)}},_renderLabelsTangent:(e,i,r)=>{for(var s=i.getLabels(e.getCtx()),a=0;a<s.length;a++){var n=s[a];if(null!=n){var o=r.w/2-Math.abs(n.getX()),l=r.h/2-Math.abs(n.getY());if(t.TextUtils.fitText(n,o,l,e)){var h=i instanceof S.getConstructor("group")?i.getLabelIdx(n):a,g=i.getDatatip(h),d=n.getUntruncatedTextString(),u=i.isDrillable(h),_=i.getGroup(h),c=b.getUIParams("tickLabel",n.getTextString(),h);e.getEventManager().associate(n,new A(e,n,_,u,d,g,c)),n.setTranslateX(r.x+r.w/2),n.setTranslateY(r.y+r.h/2),e.addChild(n)}}}},_createText:(e,i,r,s,a,n,o,l,h,g)=>{var d;return g?((d=new t.MultilineText(i.getCtx(),r,a,n)).setMaxLines(y._MAX_TITLE_LINE_WRAP),d.setCSSStyle(s),d.wrapText(o,l,1)):(d=new t.OutputText(i.getCtx(),r,a,n)).setCSSStyle(s),t.TextUtils.fitText(d,o,l,i)?(e.associate(d,new t.SimpleObjPeer(d.getUntruncatedTextString(),null,null,h)),d):null},_renderGroupSeparators:(e,i,r)=>{if(i instanceof S.getConstructor("group")&&i.areSeparatorsRendered()){var s=i.getNumLevels(),a=i.getSeparatorStartLevel();if(s<=1||a<=0)return;for(var n,o,l,h,g,d,u=e.getOptions(),_=u.position,c="top"==_||"bottom"==_,p=e.getCtx(),v=t.Agent.isRightToLeft(p),m=i.getSeparatorColor(),f=new t.Stroke(m,1,1),x=0,A=c?C.getGapSize(p,u,u.layout.hierarchicalLabelGapHeight):C.getGapSize(p,u,u.layout.hierarchicalLabelGapWidth),b=u.startGroupOffset,M=u.endGroupOffset,D=a;D>=0;D--){var T=i.getLabels(e.getCtx(),D),I=t.TextUtils.getMaxTextDimensions(T),O=i.isLabelRotated(D),E=O||!c?I.w:I.h;if(0!=E){var P=!1,L=null;if(D<a)for(var w=0;w<T.length;w++){var R=T[w];if(null!=R){var k=i.getLabelIdx(R),B=0==i.getLabelAt(k,D).length;if(!B){var F=B&&0==D&&(0==k||k==T.length-1),N=R&&null==T[k-1],H=R&&null==T[k+1],G=i.getStartIdx(k,D),U=i.getEndIdx(k,D);if(c){var V;if(R)V=R instanceof t.MultilineText||R instanceof t.BackgroundMultilineText?R.getYAlignCoord():R.getY(),n=i.getCoordAt(G-b),o=O?V+.5*x:V-E/2-.5*x-A,l=i.getCoordAt(U+M),h=O?V+E+x+2*A:V,B&&F||0!=P||null==n||y._addSeparatorLine(e,f,n,h,n,o),null==l||F||y._addSeparatorLine(e,f,l,h,l,o);if(!B){if(R)var Y=O?R.getDimensions().h:R.getDimensions().w;n=N&&0==L?i.getStartCoord():i.getBoundedCoordAt(G-b),N&&(N=!1);var W=i.getLabelAt(k+1,D);if(l=H&&W&&W.length>0?i.getEndCoord():i.getBoundedCoordAt(U+M),g=R?v?R.getX()+.5*Y:R.getX()-.5*Y:i.getBoundedCoordAt(U+M),d=R?v?R.getX()-.5*Y:R.getX()+.5*Y:i.getBoundedCoordAt(G-b),R)if(O)y._addSeparatorLine(e,f,n,h,l,h);else{var j=v?.5*-R.getDimensions().h:.5*R.getDimensions().h,z=v?d+j>l:d+j<l;(v?n>g-j:n<g-j)&&y._addSeparatorLine(e,f,n,h,g-j,h),z&&y._addSeparatorLine(e,f,d+j,h,l,h)}}}else R&&(n=v?R.getX()-E-.5*A:R.getX()+.5*A,o=i.getCoordAt(G-b),l=v?R.getX()+.5*A:R.getX()-E-.5*A,h=i.getCoordAt(U+M),(!B&&0==P||0==k&&B&&0!=D)&&null!=o&&y._addSeparatorLine(e,f,n,o,l,o),null==h||F||y._addSeparatorLine(e,f,l,h,n,h)),B||(o=N&&0==L?0:i.getBoundedCoordAt(G-b),N&&(N=!1),W=i.getLabelAt(k+1,D),h=H&&W&&W.length>0?i.getEndCoord():i.getBoundedCoordAt(U+M),R&&y._addSeparatorLine(e,f,l,o,l,h));P=!B&&null!=R,L=null!=R||null==R&&B}}}x=E}else x=E}}},_addSeparatorLine:(e,i,r,s,a,n)=>{var o=new t.Line(e.getCtx(),r,s,a,n);o.setStroke(i),o.setPixelHinting(!0),e.addChild(o)},_getGroupAxisPreferredSize:(e,i,r,s,a)=>{for(var n=e.getCtx(),o=e.getOptions(),l=i.getNumLevels(),h=a?"hierarchicalLabelGapHeight":"hierarchicalLabelGapWidth",g=l>1?C.getGapSize(n,o,o.layout[h]):0,d=0;d<l;d++){var u;if(i.isAutoRotate()){for(var _=[],c=[],p=i.getSkipIncrement(),v=0;v<i.getGroupCount();v+=p){_.push(i.getLabelAt(v,0));var m=i.getLabelStyleAt(v,0);m||(m=i.Options.tickLabel.style),c.push(m)}u=t.TextUtils.getMaxTextStringWidth(n,_,c)}else{var f=i.getLabels(n,d);if(a){var x=t.TextUtils.getMaxTextDimensions(f);u=i.isLabelRotated(d)?x.w:x.h}else u=t.TextUtils.getMaxTextDimensions(f).w}if(!(r+u<=s)){0==d&&(r=s);break}r+=u+g}return 0!=d&&(r-=g),r},getTitleHeight:(e,i,r,s)=>{var a=0;if(i.title)if(y.isWrapEnabled(i.titleStyle)){var n=new t.MultilineText(e,i.title,0,0);n.setMaxLines(y._MAX_TITLE_LINE_WRAP),n.setCSSStyle(i.titleStyle),n.wrapText(r,s,1),a=t.TextUtils.getTextStringHeight(e,i.titleStyle)*n.getLineCount()}else a=t.TextUtils.getTextStringHeight(e,i.titleStyle);return a},isWrapEnabled:e=>{var i=e.getStyle(t.CSSStyle.WHITE_SPACE);return"nowrap"!=i&&"noWrap"!=i}};class M extends S{constructor(e,i,r){super(e,i,r),this._MAX_LINE_WRAP=3,this._ROTATE_THRESHOLD=12;var s=t.Agent.isRightToLeft(e),a="top"==this.Position||"bottom"==this.Position;if(a&&s){var n=this.StartCoord;this.StartCoord=this.EndCoord,this.EndCoord=n}this._levelsArray=[],this._groupCount=this._generateLevelsArray(i.groups,0,this._levelsArray,0),this._numLevels=this._levelsArray.length,this._areSeparatorsRendered="off"!=i.groupSeparators.rendered,this._separatorColor=i.groupSeparators.color,this._lastRenderedLevel=null,this._drilling=i.drilling;var o=i.endGroupOffset>0?Number(i.endGroupOffset):0,l=i.startGroupOffset>0?Number(i.startGroupOffset):0;this.DataMin=0,this.DataMax=this._groupCount-1,this.GlobalMin=null==i.min?this.DataMin-l:i.min,this.GlobalMax=null==i.max?this.DataMax+o:i.max;var h=this.getGroupIndex(i.viewportStartGroup),g=this.getGroupIndex(i.viewportEndGroup);-1!=h&&(this.MinValue=h-l),-1!=g&&(this.MaxValue=g+o),null!=i.viewportMin&&(this.MinValue=i.viewportMin),null!=i.viewportMax&&(this.MaxValue=i.viewportMax),null==this.MinValue&&(this.MinValue=this.GlobalMin),null==this.MaxValue&&(this.MaxValue=this.GlobalMax),this.GlobalMin>this.MinValue&&(this.GlobalMin=this.MinValue),this.GlobalMax<this.MaxValue&&(this.GlobalMax=this.MaxValue),this._groupWidthRatios=i._groupWidthRatios,this._processGroupWidthRatios(),this._startBuffer=s?i.rightBuffer:i.leftBuffer,this._endBuffer=s?i.leftBuffer:i.rightBuffer,this._isLabelRotated=[];for(var d=0;d<this._numLevels;d++)this._isLabelRotated.push(!1);if(this._renderGridAtLabels=i._renderGridAtLabels,this._labels=null,this._maxSpace=a?r.h:r.w,"off"!=i.rendered){var u=y.getTitleHeight(e,i,a?r.w:r.h,a?r.h:r.w);this._maxSpace-=0!=u?u+C.getGapSize(e,i,i.layout.titleGap):0}this._maxLineWrap=this._MAX_LINE_WRAP}_processGroupWidthRatios(){if(!this._groupWidthRatios||this._groupWidthRatios.length<2)this._groupWidthRatios=null;else{for(var e,t,i=0,r=0;r<this._groupCount;r++)e=0==r?this.MinValue:Math.max(r-.5,this.MinValue),(t=r==this._groupCount-1?this.MaxValue:Math.min(r+.5,this.MaxValue))>e&&(i+=(t-e)*this._groupWidthRatios[r]);var s=this.EndCoord-this.StartCoord;this._groupWidths=this._groupWidthRatios.map(e=>e*s/i),this._borderValues=[];for(r=0;r<this._groupWidthRatios.length-1;r++)this._borderValues.push(r+.5);this._borderCoords=[];var a=Math.min(Math.max(Math.round(this.MinValue),0),this._borderValues.length-1);this._borderCoords[a]=this.StartCoord+(this._borderValues[a]-this.MinValue)*this._groupWidths[a];for(r=a+1;r<this._borderValues.length;r++)this._borderCoords[r]=this._borderCoords[r-1]+this._groupWidths[r];for(r=a-1;r>=0;r--)this._borderCoords[r]=this._borderCoords[r+1]-this._groupWidths[r+1]}}_rotateLabels(e,i,r,s){var a,n,o=this.getCtx(),l=t.Agent.isRightToLeft(o),h=this._numLevels>1;null==s&&(s=this._numLevels-1),this._isLabelRotated[s]=!0,h||this._setOverflow(r,r,e);for(var g=0;g<e.length;g++)if(null!=(a=e[g])){if(n=a.getX(),a instanceof t.MultilineText||a instanceof t.BackgroundMultilineText){var d=this.getGroupWidth()*(this.getEndIdx(g,s)-this.getStartIdx(g,s)+1);2*a.getLineHeight()<d&&this._maxSpace>0?a.wrapText(this._maxSpace,a.getLineHeight()*this._MAX_LINE_WRAP,1):a.setWrapEnabled(!1)}a.setX(0),a.setY(0),l?a.setRotation(Math.PI/2):a.setRotation(3*Math.PI/2),a.setTranslateX(n)}var u=this.GetLabelDims(e,i,s);y.isWrapEnabled(this.Options.tickLabel.style)&&this._maxSpace>0&&(this._sanitizeWrappedText(o,u,e,!0,h)&&(u=this.GetLabelDims(e,i,s)));return this.SkipLabels(e,u)}_sanitizeWrappedText(e,i,r,s,a){for(var n=this._calculateMaxWrap(i,r,s),o=0,l=0;l<r.length;l++){var h=r[l];if(h){var g=h instanceof t.MultilineText||h instanceof t.BackgroundMultilineText;n&&g&&h.isWrapEnabled()&&h.wrapText(this._maxSpace,h.getLineHeight()*this._maxLineWrap,1),a&&(o=Math.max(o,h.getDimensions().w)),h.alignMiddle()}}if(a){var d=s?this.Options.layout.hierarchicalLabelGapHeight:this.Options.layout.hierarchicalLabelGapWidth;this._maxSpace-=o+C.getGapSize(e,this.Options,d)}return n}_calculateMaxWrap(e,i,r){for(var s=!1;this.IsOverlapping(e,0)&&this._maxLineWrap>1;){s=!0;for(var a=0;a<i.length;a++){var n=i[a];if((n instanceof t.MultilineText||n instanceof t.BackgroundMultilineText)&&n.getLineCount()==this._maxLineWrap){var o=n.getLineHeight();r?e[a].w-=o:(e[a].y+=.5*o,e[a].h-=o)}}this._maxLineWrap--}return s}isLabelRotated(e){return null==e&&(e=this._numLevels-1),this._isLabelRotated[e]}_setOverflow(e,i,r){e=Math.max(e-this._startBuffer,0),i=Math.max(i-this._endBuffer,0);var s=t.Agent.isRightToLeft(this.getCtx());this.StartCoord+=(e-this.StartOverflow)*(s?-1:1),this.EndCoord-=(i-this.EndOverflow)*(s?-1:1),this._processGroupWidthRatios();for(var a=0;a<this._numLevels;a++){r=this._labels[a];for(var n=0;n<r.length;n++){var o=r[n];if(o){var l=this._getLabelCoord(a,this.getLabelIdx(o));this._numLevels>1?o.setTranslateX(l):o.setX(l)}}}this.StartOverflow=e,this.EndOverflow=i}getLabels(e,t){return null==t&&(t=this._numLevels-1),this._labels||this._generateLabels(e),this._labels[t]}_getLabelCoord(e,t){var i=this.getStartIdx(t,e),r=this.getEndIdx(t,e);if(null==i||null==r)return null;i<this.MinValue&&r>this.MinValue&&(i=this.MinValue),r>this.MaxValue&&i<this.MaxValue&&(r=this.MaxValue);var s=r?i+(r-i)/2:i;return this.getCoordAt(s)}_generateLabels(e){var i=[];this._labels=[];for(var r,s,a,n,o,l=e.getStage(),h="top"==this.Position||"bottom"==this.Position,g=t.Agent.isRightToLeft(e),d=this._numLevels>1,u=this.getGroupWidth(),_=this._maxSpace,c=h?"hierarchicalLabelGapHeight":"hierarchicalLabelGapWidth",p=d?C.getGapSize(e,this.Options,this.Options.layout[c]):0,v="auto"==this.Options.tickLabel.rotation&&h,m={},f=this.isAutoRotate(),x=this.Options.tickLabel.style,S=y.isWrapEnabled(this.Options.tickLabel.style)&&"tangential"!=this.Position&&u>t.TextUtils.getTextStringHeight(e,x),A=0;A<this._numLevels;A++){var b=this._levelsArray[A],M=f?this.getSkipIncrement():1;m[A]=[];for(var D=0;D<b.length;D+=M)if(b[D]){if(""===(r=this.getLabelAt(D,A))||!r&&0!=r){i.push(null);continue}var T=this._getLabelCoord(A,D);if(null!=T){n=this.getLabelStyleAt(D,A);var I=!f&&S&&"number"!=typeof r&&r.indexOf(" ")>=0;o=this.CreateLabel(e,r,T,n,I);var O=u*(this.getEndIdx(D,A)-this.getStartIdx(D,A)+1);m[A].push(O),I&&this._isTextWrapNeeded(e,r,n,v,h?O:_)&&_>0?h?o.wrapText(O,_,1,!0):o.wrapText(_,o.getLineHeight()*this._maxLineWrap,1,!1):I&&(!h||_<0)&&o.setWrapEnabled(!1),o._index=D,i.push(o),s||0!=A||(s=o),0==A&&(a=o)}else i.push(null)}else i.push(null);if(S&&d){for(var E=0,P=0;P<i.length;P++)if(i[P]){var L=i[P].getDimensions();E=Math.max(E,h?L.h:L.w)}_-=E+p}this._labels.push(i),i=[]}i=this._labels[this._numLevels-1];var w=[];if(s){if("tangential"==this.Position)return w=this.GetLabelDims(i,l),void(this._labels[0]=this.SkipTangentialLabels(i,w));var R=s.getDimensions(),k=!1;if(h){var B,F;if(null!=this.Options._startOverflow&&null!=this.Options._endOverflow)B=this.Options._startOverflow,F=this.Options._endOverflow;else{var N=a.getDimensions();B=g?R.w+R.x-this.StartCoord:this.StartCoord-R.x,F=g?this.EndCoord-N.x:N.w+N.x-this.EndCoord}k=B>this._startBuffer||F>this._endBuffer}for(A=0;A<this._numLevels;A++)if(i=this._labels[A],f)this._labels[A]=this._rotateLabels(i,l,R.h/2,A);else{w=this.GetLabelDims(i,l,A);var H=this.IsOverlapping(w,0,m[A]);if(H||(this._labels[A]=i),h)if(v){if(H)this._labels[A]=this._rotateLabels(i,l,R.h/2,A);else if(k&&this._setOverflow(B,F,i),this._labels[A]=i,d){var G=0;for(P=0;P<w.length;P++)w[P]&&(G=Math.max(G,w[P].h));this._maxSpace-=G+p}}else k&&this._setOverflow(B,F,i),w=this.GetLabelDims(i,l),this._labels[A]=this.SkipLabels(i,w);else{if(S)this._sanitizeWrappedText(e,w,i,!1,d)&&(w=this.GetLabelDims(i,l,A));this._labels[A]=this.SkipLabels(i,w)}}}}getMajorTickCoords(){for(var e,t=[],i="tangential"==this.Position?this.getGroupCount():this.getGroupCount()-1,r=0;r<this._levelsArray[0].length;r++)if(this._levelsArray[0][r]){var s=this.getStartIdx(r,0),a=this.getEndIdx(r,0);null!=(e=this._renderGridAtLabels?this.getCoordAt(s+.5*(a-s)):a+.5<i?this.getCoordAt(a+.5):null)&&t.push(e)}return t}getMinorTickCoords(){var e,t=[];if(!this._levelsArray[1])return t;for(var i=0;i<this._levelsArray[1].length;i++)if(this._levelsArray[1][i]){var r=this.getStartIdx(i,1),s=this.getEndIdx(i,1);null!=(e=this._renderGridAtLabels?this.getCoordAt(r+.5*(s-r)):s+.5<this.getGroupCount()-1?this.getCoordAt(s+.5):null)&&t.push(e)}return t}getUnboundedValAt(e){if(null==e)return null;if(this._groupWidthRatios){for(var t=this._borderCoords.length,i=0;i<this._borderCoords.length;i++)if(e<=this._borderCoords[i]){t=i;break}return 0==t?this._borderValues[0]-(this._borderCoords[0]-e)/this._groupWidths[0]:this._borderValues[t-1]+(e-this._borderCoords[t-1])/this._groupWidths[t]}var r=(this.EndCoord-this.StartCoord)/(this.MaxValue-this.MinValue);return this.MinValue+(e-this.StartCoord)/r}getUnboundedCoordAt(e){if(null==e)return null;if(this._groupWidthRatios){for(var t=this._borderValues.length,i=0;i<this._borderValues.length;i++)if(e<=this._borderValues[i]){t=i;break}return 0==t?this._borderCoords[0]-this._groupWidths[0]*(this._borderValues[0]-e):this._borderCoords[t-1]+this._groupWidths[t]*(e-this._borderValues[t-1])}var r=(this.EndCoord-this.StartCoord)/(this.MaxValue-this.MinValue);return this.StartCoord+(e-this.MinValue)*r}getLabelAt(e,t){if(null==t&&(t=this._numLevels-1),(e=Math.round(e))<0)return null;var i=this._levelsArray[t]&&this._levelsArray[t][e]?this._levelsArray[t][e].item:null;return i&&(i.name?i=i.name:null!=i.id&&(i="")),i}getGroupAt(e,t){if(null==t&&(t=this._numLevels-1),(e=Math.round(e))<0)return null;var i=this._levelsArray[t]&&this._levelsArray[t][e]?this._levelsArray[t][e].item:null;if(i){if(i.id)return i.id;if(i.name||""===i.name)return i.name}return i}getLabelStyleAt(e,i){var r=this._getGroupAttribute(e,i,"labelStyle");if(r){var s=new t.CSSStyle(r);return s.getStyle("font-size")||s.setStyle("font-size",this.Options.tickLabel.style.getStyle("font-size")),s}return null}getDatatip(e,t){return this._getGroupAttribute(e,t,"shortDesc")}isDrillable(e,t){var i=this._getGroupAttribute(e,t,"drilling");return"on"==i||"off"!=i&&("on"==this._drilling||"groupsOnly"==this._drilling)}getGroup(e,t){if(e<0||e>this.getGroupCount()-1)return null;if(1==this._numLevels)return this.getGroupAt(e);var i=[];null==t&&(t=this._numLevels-1);for(var r=this.getStartIdx(e,t),s=0;s<=t;s++)for(var a=this._levelsArray[s],n=0;n<a.length;n++)this.getStartIdx(n,s)<=r&&this.getEndIdx(n,s)>=r&&i.push(this.getGroupAt(n,s));return i.length>0?1===i.length&&1===this._numLevels?i[0]:i:null}getLabelBackground(e,i,r){null==r&&(r=this._numLevels-1);var s=e.getCSSStyle();if(s){var a=s.getStyle(t.CSSStyle.BACKGROUND_COLOR),n=s.getStyle(t.CSSStyle.BORDER_COLOR),o=s.getStyle(t.CSSStyle.BORDER_WIDTH),l=s.getStyle(t.CSSStyle.BORDER_RADIUS);if(null!=a||null!=n||null!=o||null!=l){var h=e.getDimensions(),g=.15*h.h;"blink"!==t.Agent.engine&&"ie"!==t.Agent.browser&&"edge"!==t.Agent.browser||e.getVertAlignment()!==t.OutputText.V_ALIGN_BOTTOM||(h.y+=h.h/2);var d=new t.Rect(i,h.x-g,h.y,h.w+2*g,h.h),u=new t.CSSStyle;return null!=a?u.setStyle(t.CSSStyle.BACKGROUND_COLOR,a):d.setInvisibleFill(),u.setStyle(t.CSSStyle.BORDER_COLOR,n),u.setStyle(t.CSSStyle.BORDER_WIDTH,o),u.setStyle(t.CSSStyle.BORDER_RADIUS,l),d.setCSSStyle(u),this._isLabelRotated[r]&&d.setMatrix(e.getMatrix()),d.setMouseEnabled(!1),d}return null}return null}getGroupIndex(e){if(null==e)return-1;for(var i=-1,r=0;r<this._groupCount;r++){var s=this.getGroup(r);if(e instanceof Array&&s instanceof Array?t.ArrayUtils.equals(e,s):e==s){i=r;break}}return i}getMinExtent(){return 1}getGroupWidth(){return Math.abs(this.EndCoord-this.StartCoord)/Math.abs(this.MaxValue-this.MinValue)}getGroupCount(){return this._groupCount}getNumLevels(){return this._numLevels}_generateLevelsArray(e,t,i,r){for(var s=0;s<e.length;s++)if(i[t]||(i[t]=[]),i[t].push({item:e[s],start:r,end:r,position:s}),e[s]&&e[s].groups){var a=i[t].length-1,n=this._generateLevelsArray(e[s].groups,t+1,i,i[t][a].start);r!=n?(i[t][a].end=n-1,r=n):r++}else r++;return r}_getGroupAttribute(e,t,i){null==t&&(t=this._numLevels-1);var r=this._levelsArray[t]&&this._levelsArray[t][e]?this._levelsArray[t][e].item:null;return r?r[i]:null}areSeparatorsRendered(){return this._areSeparatorsRendered}getSeparatorColor(){return this._separatorColor}getStartIdx(e,t){return null==t&&(t=this._numLevels-1),this._levelsArray[t]&&this._levelsArray[t][e]?this._levelsArray[t][e].start:null}getEndIdx(e,t){return null==t&&(t=this._numLevels-1),this._levelsArray[t]&&this._levelsArray[t][e]?this._levelsArray[t][e].end:null}getPosition(e,t){return null==t&&(t=this._numLevels-1),this._levelsArray[t]&&this._levelsArray[t][e]?this._levelsArray[t][e].position:null}getItemsRange(e){e instanceof Array||(e=[e]);for(var t=0,i=this._groupCount,r=[],s=0;s<e.length;s++)for(var a=this._levelsArray[s],n=e[s],o=0;o<a.length;o++){if((a[o].item.id?a[o].item.id:a[o].item.name)===n){var l=a[o].start,h=a[o].end;t<=l&&i>=h&&(t=l,i=h,r.push(a[o].item))}}return{startIndex:t,endIndex:i,groupData:r}}isRenderGridAtLabels(){return this._renderGridAtLabels}setLastRenderedLevel(e){this._lastRenderedLevel=e}getLastRenderedLevel(){return this._lastRenderedLevel}getSeparatorStartLevel(){for(var e=this._lastRenderedLevel,t=this._lastRenderedLevel-1;t>=0;t--)this._labels[t].length!=this._levelsArray[t].length&&(e=t);return e}getLabelIdx(e){return e._index>=0?e._index:null}getMaxLineWrap(){return this._maxLineWrap}_isTextWrapNeeded(e,i,r,s,a){var n=t.TextUtils.getTextStringWidth(e,i,r);return n>=a&&(n/this._maxLineWrap<a||!s)}isAutoRotate(){var e="top"==this.Position||"bottom"==this.Position,t=this._numLevels>1,i=this.getGroupWidth(),r="auto"==this.Options.tickLabel.rotation&&e;return!t&&r&&i<this._ROTATE_THRESHOLD}getSkipIncrement(){var e=1;return e=this._ROTATE_THRESHOLD/(2*this.getGroupWidth()),this.Options._duringZoomAndScroll&&(e*=4),Math.max(1,Math.floor(e))}}S.registerConstructor("group",M);class D extends t.Automation{constructor(e){super(e),this._options=this._comp.getOptions(),this._axisInfo=this._comp.getInfo()}GetSubIdForDomElement(e){var i=this._comp.getEventManager().GetLogicalObject(e);if(i&&i instanceof t.SimpleObjPeer){if("title"===i.getParams().type)return"title";if(this._options.groups){for(var r=i.getParams().level,s=this._axisInfo.getStartIdx(i.getParams().index,r),a="",n=0;n<=r;n++)for(var o=this._axisInfo.getLabels(this._comp.getCtx(),n),l=0;l<o.length;l++){var h=this._axisInfo.getLabelIdx(o[l]);this._axisInfo.getStartIdx(h,n)<=s&&this._axisInfo.getEndIdx(h,n)>=s&&(a+="["+this._axisInfo.getPosition(h,n)+"]")}if(a.length>0)return"item"+a}}return null}getDomElementForSubId(e){if("title"===e){var t=this._axisInfo.getTitle();if(t)return t.getElem()}else if(this._axisInfo instanceof M)for(var i=e.split("[").length-1-1,r=0,s=0,a=0;a<=i;a++){var n=e.indexOf("["),o=e.indexOf("]"),l=Number(e.substring(n+1,o));e=e.substring(o+1);for(var h,g=this._axisInfo.getLabels(this._comp.getCtx(),a),d=0;d<g.length;d++)if(h=this._axisInfo.getLabelIdx(g[d]),this._axisInfo.getStartIdx(h,a)===s){r=h;break}for(var u=r;u<g.length;u++)if(h=this._axisInfo.getLabelIdx(g[u]),this._axisInfo.getPosition(h,a)===l){if(0===e.length)return g[u].getElem();s=this._axisInfo.getStartIdx(h,a);break}}return null}}class T extends t.KeyboardHandler{constructor(e,t){super(e),this._axis=t}processKeyDown(e){var i=e.keyCode,r=this._eventManager.getFocus(),s=null;if(i===t.KeyboardEvent.TAB){r&&(t.EventManager.consumeEvent(e),s=r);var a=this._axis.__getKeyboardObjects();a.length>0&&(t.EventManager.consumeEvent(e),s=this.getDefaultNavigable(a))}else i===t.KeyboardEvent.ENTER?r&&(this._eventManager.processDrillEvent(r),t.EventManager.consumeEvent(e)):s=super.processKeyDown(e);return s}}class I extends t.BaseComponent{constructor(e,i,r){super(e,i,r),this.Defaults=new C(e),this.EventManager=new b(this),this.EventManager.addListeners(this),t.Agent.isTouchDevice()||this.EventManager.setKeyboardHandler(new T(this.EventManager,this)),this._bounds=null}SetOptions(e){e?"off"!==e.rendered?this.Options=this.Defaults.calcOptions(e):(e.tickLabel.style=new t.CSSStyle(e.tickLabel.style),e.titleStyle=new t.CSSStyle(e.titleStyle),this.Options=e):this.Options||(this.Options=this.GetDefaults());this.Options.isRTL=t.Agent.isRightToLeft(this.getCtx())}getPreferredSize(e,t,i,r){return this.SetOptions(e),y.getPreferredSize(this,t,i,r)}render(e,i,r,s,a){this.getCache().clearCache(),this.SetOptions(e),this._navigablePeers=[],this.Width=i,this.Height=r,this.removeChildren(),s||(s=0),a||(a=0);var n=new t.Rectangle(s,a,i,r);y.render(this,n)}__registerObject(e){(null!=e.getDatatip()||e.isDrillable())&&this._navigablePeers.push(e)}__getKeyboardObjects(){return this._navigablePeers}isNavigable(){return this._navigablePeers.length>0}getKeyboardFocus(){return null!=this.EventManager?this.EventManager.getFocus():null}setKeyboardFocus(e,i){if(null!=this.EventManager){for(var r=this.__getKeyboardObjects(),s=e.getId(),a=!1,n=0;n<r.length;n++){var o=r[n].getId();if(s instanceof Array&&o instanceof Array&&t.ArrayUtils.equals(s,o)||s===o){this.EventManager.setFocusObj(r[n]),a=!0,i&&r[n].showKeyboardFocusEffect();break}}a||this.EventManager.setFocusObj(this.EventManager.getKeyboardHandler().getDefaultNavigable(r));var l=this.getKeyboardFocus();if(l){var h=l.getDisplayable();h.setAriaProperty("label",l.getAriaLabel()),this.getCtx().setActiveElement(h)}}}processEvent(e,t){this===t&&this.dispatchEvent(e)}getInfo(){return this.Info}__setInfo(e){this.Info=e}getWidth(){return this.Width}getHeight(){return this.Height}__setBounds(e){this._bounds=e}__getBounds(){return this._bounds}getAutomation(){return new D(this)}static getDefaults(e){return(new C).getDefaults(e)}}const O={getHideAndShowBehavior:e=>e.getOptions().hideAndShowBehavior,getHoverBehavior:e=>e.getOptions().hoverBehavior,isScrollable:e=>!!l.isScrollSupported(e)&&"off"!=e.getOptions().zoomAndScroll,isZoomable:e=>{if(!l.isScrollSupported(e))return!1;var t=e.getOptions().zoomAndScroll;return"live"==t||"delayed"==t},getZoomDir:e=>l.isScatterBubble(e)?e.getOptions().zoomDirection:"auto",isLiveScroll:e=>{if(!l.isScrollSupported(e))return!1;var t=e.getOptions().zoomAndScroll;return"live"==t||"liveScrollOnly"==t},isDelayedScroll:e=>{if(!l.isScrollSupported(e))return!1;var t=e.getOptions().zoomAndScroll;return"delayed"==t||"delayedScrollOnly"==t},isPlotAreaDraggable:e=>{var t=e.getOptions(),i=t.dnd?t.dnd.drag.items:{};return Object.keys(i).length>0},isPlotAreaDropTarget:e=>{var t=e.getOptions(),i=t.dnd?t.dnd.drop.plotArea:{};return Object.keys(i).length>0},isHorizScrollbarSupported:e=>{var t=O.getZoomDir(e);return!l.isPolar(e)&&(l.isBLAC(e)&&l.isVertical(e)||l.isScatterBubble(e)&&"y"!=t)},isVertScrollbarSupported:e=>{var t=O.getZoomDir(e);return!l.isPolar(e)&&(l.isBLAC(e)&&l.isHorizontal(e)||l.isScatterBubble(e)&&"x"!=t)}},E=(e,i,r,s,a,n,o,l)=>{var h=new t.OutputText(i.getCtx(),r,a,n);return h.setCSSStyle(s),t.TextUtils.fitText(h,o,l,i)?(e.associate(h,new t.SimpleObjPeer(h.getUntruncatedTextString())),h):null},P=e=>{var t=e.getOptions();return t.title.text||t.subtitle.text||t.footnote.text},L=(e,i,r)=>{var s=e.getOptions();if(d.hasInvalidTimeData(e)&&d.hasData(e))var a=s.translations.labelInvalidData;else(a=s.emptyText)||(a=s.translations.labelNoData);e.renderEmptyText(i,a,new t.Rectangle(r.x,r.y,r.w,r.h),e.getEventManager(),s._statusMessageStyle)},w={getXAxisPos:e=>l.isPolar(e)?"tangential":l.isHorizontal(e)?t.Agent.isRightToLeft(e.getCtx())?"right":"left":"bottom",getBaselineScaling:(e,t)=>{var i=t+"Axis",r=e.getOptions()[i].baselineScaling;return!r||"zero"!=r&&"min"!=r?l.isStock(e)?"min":"zero":r},getYAxisPos:e=>{var i=e.getOptions().yAxis.position;return l.isPolar(e)?"radial":l.isHorizontal(e)?!i||"top"!=i&&"bottom"!=i?"bottom":i:(l.isStock(e)&&(i=i||"end"),t.Agent.isRightToLeft(e.getCtx())?i&&"end"==i?"left":"right":i&&"end"==i?"right":"left")},getY2AxisPos:e=>{var i=e.getOptions().y2Axis.position;return l.isHorizontal(e)?!i||"top"!=i&&"bottom"!=i?"top":i:t.Agent.isRightToLeft(e.getCtx())?i&&"start"==i?"right":"left":i&&"start"==i?"left":"right"},getAxisOffset:e=>{var t=e.getCache().getFromCache("axisOffset");if(null!=t)return t;var i=e.getOptions().styleDefaults.groupSeparators;if(l.hasGroupAxis(e)&&d.getNumLevels(e)>1&&"on"==i.rendered)t=.5;else if(d.hasBarSeries(e)||c.hasCenteredSeries(e)||d.hasCandlestickSeries(e)||d.hasBoxPlotSeries(e)||l.isBLAC(e)&&1==d.getGroupCount(e))t=.5;else if(l.isSpark(e)||O.isScrollable(e)||l.isOverview(e))t=0;else{var r=l.isHorizontal(e)?.2:.5;t=r-r/Math.sqrt(d.getGroupCount(e))}return e.getCache().putToCache("axisOffset",t),t},isGridShifted:e=>{if(!l.isBLAC(e))return!1;if(d.getNumLevels(e)>1)return!0;for(var t=d.getSeriesCount(e),i=0;i<t;i++)if(d.isSeriesRendered(e,i)){var r=d.getSeriesType(e,i),s=c.getLineType(e,i);if("bar"!=r&&"centeredSegmented"!=s&&"centeredStepped"!=s)return!1}return!0},isGridPolygonal:e=>!(!l.isBLAC(e)||d.hasBarSeries(e))&&"polygon"==e.getOptions().polarGridShape,isAxisRendered:(e,t)=>{if(!l.hasAxes(e))return!1;var i=e.getOptions(),r=i.overview.content&&i.overview.content[t+"Axis"],s=r&&"on"==r.rendered;if("y"==t&&d.hasY2DataOnly(e)&&!s)return!1;if("y2"==t&&!d.hasY2Data(e)&&!s)return!1;var a=i[t+"Axis"];return!("off"==a.rendered&&!s)&&!("off"==a.tickLabel.rendered&&!a.title&&!s)},isAxisLineRendered:(e,t)=>{var i=e.getOptions()[t+"Axis"];return"off"!=i.rendered&&"off"!=i.axisLine.rendered&&!("auto"==i.axisLine.rendered&&"x"!=t&&l.isBLAC(e)&&!l.isPolar(e))},isMajorTickRendered:(e,t)=>{var i=e.getOptions()[t+"Axis"];return"off"!=i.rendered&&"off"!=i.majorTick.rendered&&!("auto"==i.majorTick.rendered&&"x"==t&&l.isBLAC(e)&&!l.isPolar(e))},isMinorTickRendered:(e,t)=>{var i=e.getOptions()[t+"Axis"];return"off"!=i.rendered&&"off"!=i.minorTick.rendered&&("on"==i.minorTick.rendered||w.isLog(e,t))},isLog:(e,t)=>"log"==e.getOptions()[t+"Axis"].scale,getTickLabelHeight:(e,i)=>{var r=e.getOptions(),s=r[i+"Axis"].tickLabel.style;return s instanceof t.CSSStyle||(s=new t.CSSStyle(s)),s.mergeUnder(I.getDefaults(r.skin).tickLabel.style),t.TextUtils.getTextStringHeight(e.getCtx(),s)},getTickLabelGapSize:(e,t)=>{if(w.isTickLabelInside(e,t))return 0;var i=e.getOptions(),r=l.isHorizontal(e),s=w.getGapScalingFactor(e,t),a=Math.ceil(i.layout.tickLabelGapWidth*s),n=Math.ceil(i.layout.tickLabelGapHeight*s);return"x"==t?r?a:n:r?n:a},getGapScalingFactor:(e,t)=>w.isAxisRendered(e,t)?w.getTickLabelHeight(e,t)/14:0,isTickLabelInside:(e,t)=>!(l.isPolar(e)||l.isScatterBubble(e)||l.isBLAC(e)&&"x"==t)&&"inside"==e.getOptions()[t+"Axis"].tickLabel.position,getXAxisViewportMinMax:(e,t)=>{var i=t?"xAxisViewportMinMaxUG":"xAxisViewportMinMax",r=e.getCache().getFromCache(i);if(r)return r;var s=e.getOptions().xAxis,a=l.hasGroupAxis(e),n=w.getAxisOffset(e);if(t)var o=w.getXAxisGlobalMinMax(e);var h=null;null!=s.viewportMin?h=s.viewportMin:null!=s.viewportStartGroup?h=a?d.getGroupIdx(e,s.viewportStartGroup)-n:s.viewportStartGroup:t&&(h=o.min);var g=null;return null!=s.viewportMax?g=s.viewportMax:null!=s.viewportEndGroup?g=a?d.getGroupIdx(e,s.viewportEndGroup)+n:s.viewportEndGroup:t&&(g=o.max),r={min:h,max:g},e.getCache().putToCache(i,r),r},getXAxisGlobalMinMax:e=>{var t=e.getOptions().xAxis,i=l.hasGroupAxis(e),r=w.getAxisOffset(e);if(!i)var s=w.getMinMaxVal(e,"x");return{min:null!=t.min?t.min:i?0-r:s.min,max:null!=t.max?t.max:i?d.getGroupCount(e)-1+r:s.max}},applyInitialZooming:(e,t)=>{var i=e.getOptions(),r=i.xAxis,s=i.initialZooming;if(l.isBLAC(e)&&"off"!=i.zoomAndScroll&&"none"!=s){i._initialZoomed&&("last"==s?r.viewportMin=null:r.viewportMax=null);var a=w.getXAxisViewportMinMax(e,!1),n=a.min,o=a.max;if(!("last"==s&&null!=n||"first"==s&&null!=o)){var h=l.isHorizontal(e)?t.h:t.w,g=Math.floor(h/(2*w.getTickLabelHeight(e,"x")))+w.getAxisOffset(e),u=d.getGroupCount(e)-1;if(!(u<=g)){var _,c;if(l.hasGroupAxis(e))_=0,c=u;else{var p=w.getMinMaxVal(e,"x");_=p.min,c=p.max}var v=g/u*(c-_);"last"==i.initialZooming?(null==o&&(o=c),r.viewportMin=Math.max(o-v,_)):(null==n&&(n=_),r.viewportMax=Math.min(n+v,c)),i._initialZoomed=!0}}}},isYAdjustmentNeeded:e=>{var t=e.getOptions().styleDefaults.dataLabelPosition,i=e.getOptionsCache().getFromCache("hasDataOutsideBarEdge"),r="outsideBarEdge"==t||i,s=c.isStackLabelRendered(e);return!(!d.hasBarSeries(e)||!r&&!s)},axisContainsPoint:(e,t)=>{if(!e)return!1;var i=e.getOptions().position,r="top"==i||"bottom"==i,s=r?4:10,a=r?10:4,n=e.__getBounds().clone();n.x-=a,n.y-=s,n.w+=2*a,n.h+=2*s;var o=e.stageToLocal(t);return n.containsPoint(o.x,o.y)},isStandalonePlotArea:e=>!P(e)&&(!l.isLegendRendered(e)&&(!w.isAxisRendered(e,"x")&&(!w.isAxisRendered(e,"y")&&!w.isAxisRendered(e,"y2")))),isStandaloneXAxis:e=>{var t=e.getOptions();return!P(e)&&("off"==t.legend.rendered&&("off"==t.plotArea.rendered&&(!w.isAxisRendered(e,"y")&&!w.isAxisRendered(e,"y2"))))},isStandaloneYAxis:e=>{var t=e.getOptions();return!P(e)&&("off"==t.legend.rendered&&(!w.isAxisRendered(e,"x")&&("off"==t.plotArea.rendered&&!w.isAxisRendered(e,"y2"))))},isStandaloneY2Axis:e=>{var t=e.getOptions();return!P(e)&&("off"==t.legend.rendered&&(!w.isAxisRendered(e,"x")&&(!w.isAxisRendered(e,"y")&&"off"==t.plotArea.rendered)))},getViewportMinMaxGroupIdx:(e,t)=>{var i=w.getXAxisViewportMinMax(e,!0),r=l.hasGroupAxis(e),s=d.getGroupCount(e),a=i.min,n=0;if(null!=a)if(r)n=Math.ceil(a);else for(var o=0;o<s;o++){if(d.getXVal(e,t,o)>=a){n=o;break}}var h=i.max,g=s-1;if(r)g=Math.floor(h);else for(var u=s-1;u>=n;u--){if(d.getXVal(e,t,u)<=h){g=u;break}}return{min:n,max:g}},getViewportGroupCount:e=>{var t=w.getXAxisViewportMinMax(e,!0),i=w.getXAxisGlobalMinMax(e),r=(t.max-t.min)/(i.max-i.min);return isNaN(r)?1:r*d.getGroupCount(e)},_computeYAlongLine:(e,i,r,s,a,n)=>{e&&(r=t.Math.log10(r),a=t.Math.log10(a));var o=r+(a-r)*(n-i)/(s-i);return e?Math.pow(10,o):o},getMinMaxVal:(e,t,i)=>{var r=t+(i?"MinMaxDO":"MinMax"),s=e.getCache().getFromCache(r);if(s)return s;var a=e.getOptions()[t+"Axis"];if(null!=a.dataMax&&null!=a.dataMin&&i)return s={min:a.dataMin,max:a.dataMax},e.getCache().putToCache(r,s),s;var n=l.hasTimeAxis(e);if(null!=a.max&&null!=a.min&&!i&&!n)return s={min:a.min,max:a.max},e.getCache().putToCache(r,s),s;var o="z"!=t&&w.isLog(e,t),h="y2"==t;h&&(t="y");for(var g="y"==t,u=!i&&g&&l.isBLAC(e),_="withoutRescale"==O.getHideAndShowBehavior(e)||"x"==t&&l.hasTimeAxis(e),p=-1/0,m=1/0,f=d.getSeriesCount(e),x=0;x<f;x++){var C=d.getSeriesItem(e,x),S=d.getSeriesType(e,x),A=g&&(d.isRangeSeries(e,x)||"candlestick"==S||"boxPlot"==S);if(_||d.isSeriesRendered(e,x)){var b=d.isAssignedToY2(e,x);if(!g||h==b){var y=C.items;if(y){var M=0,D=y.length-1;if(u){var T=w.getViewportMinMaxGroupIdx(e,x);M=T.min,D=T.max}for(var I=M;I<=D;I++)if(_||d.isDataItemRendered(e,x,I)){var E=y[I],P=null;if(g?A||(P=d.getCumulativeVal(e,x,I,_)):"x"==t&&n&&!l.isMixedFrequency(e)?(P=d.getGroupLabel(e,I),null!=E&&(E.x=P)):null!=E&&(P=E[t]),!("z"==t&&P<=0)){if(!(A||null==P||"number"!=typeof P||o&&P<=0)){var L=0;if(l.isBubble(e)&&!i&&"z"!=t){var R=c.getMarkerSize(e,x,I);L=w.getBubbleAxisRadius(e,t,R)}p=Math.max(p,o?P*Math.pow(10,L):P+L),m=Math.min(m,o?P/Math.pow(10,L):P-L)}if(A){var k=d.getHighVal(e,x,I),B=d.getLowVal(e,x,I);o&&(k<=0||B<=0)||(p=Math.max(p,k,B),m=Math.min(m,k,B))}if(u&&!A){var F=null,N=null;if(M>0&&I==M?(F=I-1,N=w.getXAxisViewportMinMax(e,!0).min):D<y.length-1&&I==D&&(F=I+1,N=w.getXAxisViewportMinMax(e,!0).max),null!=F){var H=d.getXVal(e,x,I),G=d.getXVal(e,x,F),U=d.getCumulativeVal(e,x,F),V=w._computeYAlongLine(o,H,P||0,G,U||0,N);p=Math.max(p,V),m=Math.min(m,V)}}var Y=d.getNestedDataItemCount(e,x,I);if(Y>0)for(var W=0;W<Y;W++){var j=d.getNestedDataItem(e,x,I,W),z="number"==typeof j;p=z?Math.max(p,j):Math.max(p,j.value),m=z?Math.min(m,j):Math.min(m,j.value)}}}}}}}var X=null;if("x"==t?X=d.getAxisRefObjs(e,"x"):h?X=d.getAxisRefObjs(e,"y2"):g&&(X=d.getAxisRefObjs(e,"y")),null!=X)for(var Z=0;Z<X.length;Z++){var K=X[Z],q=K.items,Q="withRescale"==O.getHideAndShowBehavior(e)&&!v.isObjRendered(e,K);if(!Q)if(q&&!Q){var J=0,$=q.length-1;if(u){var ee=w.getViewportMinMaxIdx(e,q);J=ee.min,$=ee.max}for(var te=J;te<=$;te++)if(null!=q[te]){var ie=v.getLowVal(q[te]),re=v.getHighVal(q[te]),se=isNaN(q[te])?q[te].value:q[te];null!=ie&&isFinite(ie)&&(m=Math.min(m,ie),p=Math.max(p,ie)),null!=re&&isFinite(re)&&(m=Math.min(m,re),p=Math.max(p,re)),null!=se&&isFinite(se)&&(m=Math.min(m,se),p=Math.max(p,se))}}else{var ae=v.getLowVal(K),ne=v.getHighVal(K),oe=K.value;null!=ae&&isFinite(ae)&&(m=Math.min(m,ae),p=Math.max(p,ae)),null!=ne&&isFinite(ne)&&(m=Math.min(m,ne),p=Math.max(p,ne)),null!=oe&&isFinite(oe)&&(m=Math.min(m,oe),p=Math.max(p,oe))}}return s={min:m,max:p},e.getCache().putToCache(r,s),s},getBubbleAxisRadius:(e,t,i)=>{if(!i)return 0;var r="x"==t?"_xAxisBubbleRatio":"_yAxisBubbleRatio";return i/2*e.getCache().getFromCache(r)},getViewportMinMaxIdx:(e,t)=>{var i=w.getXAxisViewportMinMax(e,!0),r=l.hasGroupAxis(e),s=i.min,a=0;if(null!=s)if(r)a=Math.ceil(s);else for(var n=0;n<t.length;n++){if(v.getXVal(e,t,n)>=s){a=n;break}}var o=i.max,h=t.length-1;if(r)h=Math.floor(o);else for(var g=t.length-1;g>=a;g--){if(d.getXVal(e,t,g)<=o){h=g;break}}return{min:a,max:h}}},R={getGroupWidthRatios:e=>{if(!d.hasBarSeries(e)&&!d.hasCandlestickSeries(e)&&!d.hasBoxPlotSeries(e))return null;var t=e.getOptions(),i=R.getBarGapRatio(e);if(i>=1)return t._averageGroupZ=1/0,null;t._averageGroupZ=0;var r,s,a,n,o,l,h=d.getGroupCount(e),g=d.isSplitDualY(e),u=d.getStackCategories(e,"bar"),_=u.y.length,c=u.y2.length;if(e.getOptionsCache().getFromCache("hasConstantZValue")){var p=e.getOptionsCache().getFromCache("constantZValue")*(g?Math.max(_,c):_+c);l=(o=p*h)*i/(1-i),r=null}else{for(var v=[],m=0;m<h;m++){for(s=0,n=0;n<_;n++)s+=d.getBarCategoryZ(e,u.y[n],m,!1);for(a=0,n=0;n<c;n++)a+=d.getBarCategoryZ(e,u.y2[n],m,!0);v.push(g?Math.max(s,a):s+a)}o=v.reduce((e,t)=>e+t),l=o*i/(1-i),r=v.map(e=>e+l/h)}return t._averageGroupZ=(o+l)/h,r},getBarGapRatio:e=>{var t=e.getCache().getFromCache("barGapRatio");if(t)return t;if("string"==typeof(t=e.getOptions().styleDefaults.barGapRatio)&&"%"==t.slice(-1)&&(t=Number(t.slice(0,-1))/100),null!=t&&!isNaN(t))return Number(t);var i=d.getStackCategories(e,"bar"),r=i.y.length,s=i.y2.length,a=d.isSplitDualY(e)?Math.max(r,s):r+s;return t=l.isPolar(e)?1==a?0:.25:1==a?.37+.26/w.getViewportGroupCount(e):.25,e.getCache().putToCache("barGapRatio",t),t},getBarInfo:(e,i,r,s)=>{var a,n,o=l.isHorizontal(e),g=d.isStacked(e),u=t.Agent.isRightToLeft(e.getCtx()),_=e.xAxis,p=d.isRangeSeries(e,i),v=c.getBarCategoryOffsetMap(e,r),m=d.getXVal(e,i,r),f=_.getUnboundedCoordAt(m),x=d.isAssignedToY2(e,i),C=x?e.y2Axis:e.yAxis,S=C.getBaselineCoord();if(p){var A=d.getLowVal(e,i,r),b=d.getHighVal(e,i,r);if(null==A||isNaN(A)||null==b||isNaN(b))return null;if((a=C.getBoundedCoordAt(A))==(n=C.getBoundedCoordAt(b))&&null==C.getCoordAt(A))return null}else{var y=d.getVal(e,i,r),M=d.getCumulativeVal(e,i,r);if(null==y||isNaN(y))return null;if((a=C.getBoundedCoordAt(M))==(n=g?C.getBoundedCoordAt(M-y):S)&&null==C.getCoordAt(M))return null}var D=d.getStackCategory(e,i),T=c.getBarWidth(e,i,r),I=g?c.getBarStackWidth(e,D,r,x):T;if("pixel"==c.getBarSpacing(e)&&"firefox"===t.Agent.browser){var O=T/(1-R.getBarGapRatio(e));T>1&&O-T<2&&(I=--T)}var E=v[x?"y2":"y"][D]+.5*(I-T),P=u&&!o?f-E-T:f+E,L=P+T,w=(P+L)/2,k=p?(a+n)/2:a;return{x1:P,x2:L,axisCoord:S,baseCoord:n,yCoord:a,dataPos:h.convertAxisCoord(e,new t.Point(w,k),s),barWidth:T}},getDataLabelPos:(e,i,r,s,a,n)=>{var o,h=d.getNestedDataItem(e,i,r,s),g=d.getDataItem(e,i,r);if(n)o="outsideBarEdge";else if((o=h&&h.labelPosition?h.labelPosition:g.labelPosition)||(o=e.getOptions().styleDefaults.dataLabelPosition),"none"==(o=c._parseLowHighArray(o,a)))return"none";var u=t.Agent.isRightToLeft(e.getCtx()),_=l.isHorizontal(e),p=l.isPolar(e);if(l.isFunnel(e)||l.isPyramid(e))return"center";if("bar"==d.getSeriesType(e,i)){if("center"==o||p)return"center";var v,m=d.isStacked(e);if("insideBarEdge"!=o){if(m&&!n)return"center";"outsideBarEdge"!=o&&(o="insideBarEdge")}if("insideBarEdge"==o&&!m){var f,x=e.getOptions().styleDefaults.dataLabelStyle,C=g.labelStyle?t.CSSStyle.mergeStyles([x,new t.CSSStyle(g.labelStyle)]):x;if(_){var S=c.getDataLabel(e,i,r,s,a);f=t.TextUtils.getTextStringWidth(e.getCtx(),S,C)}else f=t.TextUtils.getTextStringHeight(e.getCtx(),C);var A=R.getBarInfo(e,i,r);(A?Math.abs(A.baseCoord-A.yCoord):0)<=f&&(o="outsideBarEdge")}return v="low"==a?g.low<=g.high:"high"==a?g.high<g.low:d.getVal(e,i,r,s)<0,"outsideBarEdge"==o?_?!v&&!u||v&&u?"right":"left":v?"bottom":"top":_?!v&&!u||v&&u?"inRight":"inLeft":v?"inBottom":"inTop"}if("center"==o)return"center";if("belowMarker"==o)return"bottom";if("aboveMarker"==o)return"top";if("afterMarker"!=o&&"beforeMarker"!=o){if(l.isBubble(e))return"center";if("low"!=a||p)if("high"!=a||p)o="afterMarker";else{if(!_)return"top";o="afterMarker"}else{if(!_)return"bottom";o="beforeMarker"}}return!u&&"afterMarker"==o||u&&"beforeMarker"==o?"right":"left"}},k={getBarFill:(e,t,i,r)=>{var s=c.getColor(e,t,i),a=c.getPattern(e,t,i);return k.getRectangleFill(e,s,a,r)},getRectangleFill:(e,i,r,s)=>{var a=c.getSeriesEffect(e);if(r)return new t.PatternFill(r,i);if("gradient"==a&&s>3){var n,o,h=l.isHorizontal(e)?270:0;return n=[t.ColorUtils.adjustHSL(i,0,-.09,.04),t.ColorUtils.adjustHSL(i,0,-.04,-.05)],o=[0,1],new t.LinearGradientFill(h,n,null,o)}return new t.SolidFill(i)},getAreaFill:(e,i)=>{var r,s="lineWithArea"==d.getSeriesType(e,i),a=d.getSeriesItem(e,i);a&&a.areaColor?r=a.areaColor:(r=c.getColor(e,i),s&&(r=t.ColorUtils.setAlpha(r,.2)));var n=c.getPattern(e,i),o=c.getSeriesEffect(e);if(n)return new t.PatternFill(n,r);if("gradient"==o){var h,g,u=l.isHorizontal(e)?180:270;if(s){var _=t.ColorUtils.getAlpha(r);h=[t.ColorUtils.setAlpha(r,Math.min(_+.2,1)),t.ColorUtils.setAlpha(r,Math.max(_-.15,0))],g=[0,1]}else h=[t.ColorUtils.adjustHSL(r,0,-.09,.04),t.ColorUtils.adjustHSL(r,0,-.04,-.05)],g=[0,1];return new t.LinearGradientFill(u,h,null,g)}return new t.SolidFill(r)},getMarkerFill:(e,i,r,s)=>{var a=c.getMarkerColor(e,i,r,s),n=c.getPattern(e,i,r,s);if(n)return new t.PatternFill(n,a);if(l.isBubble(e)&&"gradient"==c.getSeriesEffect(e)){var o=[t.ColorUtils.adjustHSL(a,0,-.09,.04),t.ColorUtils.adjustHSL(a,0,-.04,-.05)];return new t.LinearGradientFill(270,o,null,[0,1])}return new t.SolidFill(a)},getFunnelPyramidSliceFill:(e,i,r,s,a)=>{var n,o=c.getPattern(e,i,0),h=c.getSeriesEffect(e);if(o&&!a)return("vertical"==e.getOptions().orientation||l.isPyramid(e))&&(n=t.Agent.isRightToLeft(e.getCtx())?new t.Matrix(0,-1,1,0):new t.Matrix(0,1,-1,0)),new t.PatternFill(o,r,null,n);if("gradient"==h){var g,d,u=l.isPyramid(e)?180:90;return"on"==e.getOptions().styleDefaults.threeDEffect?(g=[t.ColorUtils.adjustHSL(r,0,0,-.1),t.ColorUtils.adjustHSL(r,0,0,.12),r],d=[0,.65,1]):(g=[t.ColorUtils.adjustHSL(r,0,-.09,.04),t.ColorUtils.adjustHSL(r,0,-.04,-.05)],d=[0,1]),new t.LinearGradientFill(u,g,null,d,[s.x,s.y,s.w,s.h])}return new t.SolidFill(r)}};class B extends t.Path{constructor(e,i,r,s,a,n,o,l,h){super(e.getCtx()),this._FUNNEL_3D_WIDTH_RATIO=.08,this._FUNNEL_ANGLE_2D=36,this._FUNNEL_RATIO=1/3,this._BORDER_COLOR="#FFFFFF",this._MIN_CHARS_DATA_LABEL=3,this._LINE_FRACTION=2/3,this._AREA_FRACTION=.41,this._HEIGHT_FRACTION=.28,this._LINE_FRACTION_2=.4,this._AREA_FRACTION_2=.8,this._HEIGHT_FRACTION_2=.7,this._chart=e;var g=e.getOptions().styleDefaults;this._seriesIndex=i,this._numDrawnSeries=r,this._funnelWidth=s,this._funnelHeight=a,this._startPercent=n,this._valuePercent=o,this._fillPercent=l,this._3dRatio="on"==g.threeDEffect?1:0,this._gap=h;var d=this._getPath();this._dataColor=c.getColor(this._chart,this._seriesIndex,0),this._backgroundColor=g.backgroundColor?g.backgroundColor:g.funnelBackgroundColor,this.setCmds(d.slice),d.bar&&(this._bar=new t.Path(this.getCtx(),d.bar),this.addChild(this._bar),this._bar.setMouseEnabled(!1)),this._setColorProps(d.sliceBounds),this._label=this._getSliceLabel(d.sliceBounds,d.barBounds),null!=this._label&&(this._label.setMouseEnabled(!1),this.addChild(this._label))}_getPath(){var e=t.Agent.isRightToLeft(this.getCtx()),i=d.getSeriesCount(this._chart),r=(this._numDrawnSeries+1)*this._gap,s=t.Math.degreesToRads(this._FUNNEL_ANGLE_2D-2*this._3dRatio),a=this._funnelWidth-i*this._gap,n=a/Math.sin(t.Math.degreesToRads(this._FUNNEL_ANGLE_2D)),o=this._funnelHeight/Math.sin(s),l=this._3dRatio*this._funnelWidth/this._funnelHeight*this._FUNNEL_3D_WIDTH_RATIO;l<1e-5&&(l=0);var h,g,u,_,c,p,v,m,f,x,C,S,A=this._funnelHeight,b=this._funnelHeight*this._FUNNEL_RATIO;this._startPercent<this._AREA_FRACTION?(h=this._startPercent,u=A,c=this._funnelHeight*this._LINE_FRACTION,v=this._AREA_FRACTION,f=a*this._HEIGHT_FRACTION,C=a*(1-this._HEIGHT_FRACTION)):this._startPercent<this._AREA_FRACTION_2?(h=this._startPercent-this._AREA_FRACTION,u=this._funnelHeight*this._LINE_FRACTION,c=this._funnelHeight*this._LINE_FRACTION_2,v=this._AREA_FRACTION_2-this._AREA_FRACTION,f=a*(this._HEIGHT_FRACTION_2-this._HEIGHT_FRACTION),C=a*(1-this._HEIGHT_FRACTION_2)):(h=this._startPercent-this._AREA_FRACTION_2,u=this._funnelHeight*this._LINE_FRACTION_2,c=b,v=1-this._AREA_FRACTION_2,f=a*(1-this._HEIGHT_FRACTION_2),C=0),this._startPercent+this._valuePercent<this._AREA_FRACTION?(_=A,p=this._funnelHeight*this._LINE_FRACTION,g=this._startPercent+this._valuePercent,m=this._AREA_FRACTION,x=a*this._HEIGHT_FRACTION,S=a*(1-this._HEIGHT_FRACTION)):this._startPercent+this._valuePercent<this._AREA_FRACTION_2?(_=this._funnelHeight*this._LINE_FRACTION,p=this._funnelHeight*this._LINE_FRACTION_2,g=this._startPercent+this._valuePercent-this._AREA_FRACTION,m=this._AREA_FRACTION_2-this._AREA_FRACTION,x=a*(this._HEIGHT_FRACTION_2-this._HEIGHT_FRACTION),S=a*(1-this._HEIGHT_FRACTION_2)):(_=this._funnelHeight*this._LINE_FRACTION_2,p=b,g=this._startPercent+this._valuePercent-this._AREA_FRACTION_2,m=1-this._AREA_FRACTION_2,x=a*(1-this._HEIGHT_FRACTION_2),S=0);var y,M,D,T=Math.sqrt((v-h)/v*u*u+h/v*c*c),I=Math.sqrt((m-g)/m*_*_+g/m*p*p),O=.98*Math.asin(((T-c)*f/(u-c)+C)/n),E=.98*Math.asin(((I-p)*x/(_-p)+S)/n),P=(1+this._FUNNEL_RATIO)/2*this._funnelHeight+o,L=(1-this._FUNNEL_RATIO)/2*this._funnelHeight-o;e?(y=[n*Math.sin(O)+r,P-o*Math.cos(O),n*Math.sin(E)+r,P-o*Math.cos(E),n*Math.sin(E)+r,L+o*Math.cos(E),n*Math.sin(O)+r,L+o*Math.cos(O)],M=0,D=1):(y=[this._funnelWidth-r-n*Math.sin(O),P-o*Math.cos(O),this._funnelWidth-r-n*Math.sin(E),P-o*Math.cos(E),this._funnelWidth-r-n*Math.sin(E),L+o*Math.cos(E),this._funnelWidth-r-n*Math.sin(O),L+o*Math.cos(O)],M=1,D=0);var w=t.PathUtils.moveTo(y[0],y[1]),R=null;w+=t.PathUtils.arcTo(l*(y[1]-y[7])/2,(y[1]-y[7])/2,Math.PI,D,y[6],y[7]),w+=t.PathUtils.arcTo(l*(y[1]-y[7])/2,(y[1]-y[7])/2,Math.PI,D,y[0],y[1]),w+=t.PathUtils.arcTo(n,o,s,M,y[2],y[3]),w+=t.PathUtils.arcTo(l*(y[3]-y[5])/2,(y[3]-y[5])/2,Math.PI,D,y[4],y[5]),w+=t.PathUtils.arcTo(n,o,s,M,y[6],y[7]);var k=new t.Rectangle(Math.min(y[0],y[2]),y[5],Math.abs(y[0]-y[2]),Math.abs(y[3]-y[5]));if(null!=this._fillPercent){var B=Math.max(Math.min(this._fillPercent,1),0),F=e?-B*Math.PI:B*Math.PI;R=t.PathUtils.moveTo(y[0],y[1]),R+=t.PathUtils.arcTo(n,o,s,M,y[2],y[3]),R+=t.PathUtils.arcTo(l*(y[3]-y[5])/2,(y[3]-y[5])/2,F,D,y[2]+l*(y[3]-y[5])/2*Math.sin(F),(y[5]+y[3])/2+(y[3]-y[5])/2*Math.cos(F)),this._fillPercent>.95?R+=t.PathUtils.arcTo(n,o,s,M,y[6],y[1]+B*(y[7]-y[1])):this._fillPercent<.05?R+=t.PathUtils.arcTo(n,o,s,D,y[6],y[1]+B*(y[7]-y[1])):R+=t.PathUtils.lineTo(y[6]+l*(y[1]-y[7])/2*Math.sin(F),(y[7]+y[1])/2+(y[1]-y[7])/2*Math.cos(F)),R+=t.PathUtils.arcTo(l*(y[1]-y[7])/2,(y[1]-y[7])/2,F,M,y[0],y[1]),R+=t.PathUtils.closePath();var N=new t.Rectangle(Math.min(y[0],y[2]),y[5]+Math.abs(y[3]-y[5])*(1-B),Math.abs(y[0]-y[2]),Math.abs(y[3]-y[5])*B)}return{slice:w,bar:R,sliceBounds:k,barBounds:R?N:k}}_getSliceLabel(e,i){var r=c.getDataLabel(this._chart,this._seriesIndex,0);if(r||(r=d.getSeriesLabel(this._chart,this._seriesIndex)),r&&"none"!=R.getDataLabelPos(this._chart,this._seriesIndex,0)){var s=new t.MultilineText(this.getCtx(),r,0,0),a=null!=c.getPattern(this._chart,this._seriesIndex,0),n=this._chart.getOptions().styleDefaults,o=[n._dataLabelStyle,n.dataLabelStyle,new t.CSSStyle(d.getDataItem(this._chart,this._seriesIndex,0).labelStyle)],l=t.CSSStyle.mergeStyles(o);if(s.setCSSStyle(l),t.TextUtils.fitText(s,e.h-this._3dRatio*(.8-this._valuePercent)*50,e.w,this,this._MIN_CHARS_DATA_LABEL)){var h=s.getDimensions(),g=this._getLabelPos(e);if(a){var u=.15*h.h,_=t.Agent.isRightToLeft(this.getCtx())?.5:-.5,p=t.PathUtils.roundedRectangle(h.x-u,h.y,h.w+2*u,h.h,2,2,2,2),v=new t.Path(this.getCtx(),p);v.setSolidFill("#FFFFFF",.9),g=g.translate(_*h.h,-_*h.w),v.setMatrix(g),this.addChild(v)}var m=a?"#000000":i.containsPoint(e.x,e.y+(e.h-h.w)/2)?t.ColorUtils.getContrastingTextColor(this._dataColor):t.ColorUtils.getContrastingTextColor(this._backgroundColor),f=new t.CSSStyle({color:m});return o.splice(1,0,f),t.Agent.isHighContrast()&&o.push(f),l=t.CSSStyle.mergeStyles(o),s.setCSSStyle(l),s.setMatrix(this._getLabelPos(e)),s.alignCenter(),s.alignMiddle(),s}}}_getLabelPos(e){var i=this._3dRatio*(e.h*this._funnelWidth/this._funnelHeight*this._FUNNEL_3D_WIDTH_RATIO/2),r=new t.Matrix;return r=t.Agent.isRightToLeft(this.getCtx())?(r=r.rotate(Math.PI/2)).translate(e.x+e.w/2-i,e.y+e.h/2):(r=r.rotate(3*Math.PI/2)).translate(e.x+e.w/2+i,e.y+e.h/2)}_setColorProps(e){var i=k.getFunnelPyramidSliceFill(this._chart,this._seriesIndex,this._dataColor,e),r=c.getBorderColor(this._chart,this._seriesIndex,0),s=c.getUserBorderWidth(this._chart,this._seriesIndex,0),a=c.getDefaultBorderWidth(this._chart,this._seriesIndex,0),n=!1,o="redwood"===this.getCtx().getThemeBehavior();null==r&&this._3dRatio>0&&(n=!0,r=this._BORDER_COLOR);var l=null!==s?s:a;!r||o&&this._chart.isSelectionSupported()&&!this._bar&&n||this.setSolidStroke(r,null,l);var h=t.SelectionEffectUtils.getHoverBorderColor(this._dataColor),g=k.getFunnelPyramidSliceFill(this._chart,this._seriesIndex,this._backgroundColor,e,!0);this._bar?(this.setFill(g),this._bar.setFill(i),this._bar.setStyle(c.getStyle(this._chart,this._seriesIndex,0)),this._bar.setClassName(c.getClassName(this._chart,this._seriesIndex,0))):(this.setFill(i),this.setStyle(c.getStyle(this._chart,this._seriesIndex,0)),this.setClassName(c.getClassName(this._chart,this._seriesIndex,0))),this.OriginalStroke=this.getStroke();var d=null!=this._bar?this._bar:this;if(this._chart.isSelectionSupported())if(this.setCursor(t.SelectionEffectUtils.getSelectingCursor()),o)if(null!=this._bar)d.setSolidStroke(this._dataColor,null,0),d.setFeedbackClassName("oj-dvt-selectable");else{var u=null==r||n?this._dataColor:r,_=null!==s?s:0;d.setSolidStroke(u,null,_),d.setFeedbackClassName("oj-dvt-selectable"),r&&(n&&d.addClassName("oj-dvt-default-border-color"),null==s&&d.addClassName("oj-dvt-default-border-width"))}else{var p=c.getSelectedInnerColor(this._chart),v=c.getSelectedOuterColor(this._chart)?c.getSelectedOuterColor(this._chart):this._dataColor;d.setHoverStroke(new t.Stroke(h,1,2)),d.setSelectedStroke(new t.Stroke(p,1,1.5),new t.Stroke(v,1,4.5)),d.setSelectedHoverStroke(new t.Stroke(p,1,1.5),new t.Stroke(h,1,4.5))}}getAnimParams(){return[this._startPercent,this._valuePercent,this._fillPercent,this.getAlpha(),this._3dRatio]}setAnimParams(e){this._startPercent=e[0],this._valuePercent=e[1],this._fillPercent=null!=this._fillPercent?e[2]:null,this.setAlpha(e[3]),this._3dRatio=e[4];var t=this._getPath();this.setCmds(t.slice),t.bar&&this._bar&&this._bar.setCmds(t.bar),this._label&&this._label.setMatrix(this._getLabelPos(t.sliceBounds))}setSelected(e){if(null!=this._bar){if(this.IsSelected==e)return;this.IsSelected=e,this._bar.setSelected(e)}else super.setSelected(e);var t=this.getDimensions(),i=null!=this._bar?this._bar:this,r=t.w;e?(i.setScaleX((r-3)/r),i.setTranslateX(Math.ceil(1.5)+3/r*t.x)):(i.setScaleX(1),i.setTranslateX(0))}showHoverEffect(){null!=this._bar?this._bar.showHoverEffect():super.showHoverEffect()}hideHoverEffect(){null!=this._bar?this._bar.hideHoverEffect():super.hideHoverEffect()}copyShape(){return new B(this._chart,this._seriesIndex,this._numDrawnSeries,this._funnelWidth,this._funnelHeight,this._startPercent,this._valuePercent,this._fillPercent,this._gap)}}const F={setVisibility:(e,t,i)=>{var r=v.getRefObj(e,t);null!=r&&(r.visibility=i);var s=d.getHiddenCategories(e),a=s.indexOf(t);"hidden"==i&&a<0?s.push(t):"visible"==i&&a>=0&&s.splice(a,1);var n=e.getOptions();if(n&&n.legend&&n.legend.sections){for(var o=0;o<n.legend.sections.length;o++){var l=n.legend.sections[o];if(l&&l.items)for(var h=0;h<l.items.length;h++)l.items[h].id==t&&(l.items[h].categoryVisibility=i)}return!0}return!1},processIds:(e,t)=>{for(var i=[],r=0;r<t.length;r++){var s=t[r];if(s.series==_.OTHER_ID){var a=_.getOtherSliceIds(e);i=i.concat(a)}else i.push(s)}return i},adjustBounds:e=>{null!=e.x&&(e.x-=1),null!=e.w&&(e.w+=2),null!=e.y&&(e.y-=1),null!=e.h&&(e.h+=2)},getBoundedObjs:(e,t)=>{for(var i=e.getChartObjPeers().concat(F.getFilteredChartObjPeers(e)),r=[],s=0;s<i.length;s++){var a=i[s],n=a.getDataPosition();if(n){n=e.getPlotArea().localToStage(n);var o=null==t.x||n.x>=t.x&&n.x<=t.x+t.w,l=null==t.y||n.y>=t.y&&n.y<=t.y+t.h;o&&l&&r.push(a)}}return r},getFilteredChartObjPeers:e=>{if(!e.getCache().getFromCache("dataFiltered"))return[];var t=e.getCache().getFromCache("filteredChartObjPeers");if(!t){t=[];for(var i=0;i<d.getSeriesCount(e);i++)for(var r=0;r<d.getGroupCount(e);r++){var s;if(d.isDataItemFiltered(e,i,r))s="bar"==d.getSeriesType(e,i)?R.getBarInfo(e,i,r).dataPos:d.getMarkerPos(e,i,r),t.push(new f(e,[],i,r,null,s))}e.getCache().putToCache("filteredChartObjPeers",t)}return t},getAxisBounds:(e,i,r)=>{var s=e.getPlotArea(),a=s.stageToLocal(new t.Point(i.x,i.y)),n=s.stageToLocal(new t.Point(i.x+i.w,i.y+i.h));null==i.x&&(a.x=null,n.x=null),null==i.y&&(a.y=null,n.y=null);var o=F._convertToAxisCoord(e,a.x,n.x,a.y,n.y),l={},h={},g={},d={};return e.xAxis&&(l=F._getAxisMinMax(e.xAxis,o.xMin,o.xMax,r),d=F.getAxisStartEndGroup(e.xAxis,l.min,l.max)),e.yAxis&&(h=F._getAxisMinMax(e.yAxis,o.yMin,o.yMax,r)),e.y2Axis&&(g=F._getAxisMinMax(e.y2Axis,o.yMin,o.yMax,r)),{xMin:l.min,xMax:l.max,unchanged:l.unchanged,yMin:h.min,yMax:h.max,y2Min:g.min,y2Max:g.max,startGroup:d.startGroup,endGroup:d.endGroup}},_getAxisMinMax:(e,t,i,r)=>{if(null==t||null==i)return{min:null,max:null};var s=e.getUnboundedLinearValAt(t),a=e.getUnboundedLinearValAt(i);if(r){var n=e.getInfo().getMinExtent();if(a-s<n){var o=(a+s)/2;a=o+n/2,s=o-n/2}return F._limitToGlobal(e,s,a)}return F.getActualMinMax(e,s,a)},getAxisBoundsByDelta:(e,t,i,r,s)=>{var a=F._convertToAxisCoord(e,t,i,r,s),n=O.getZoomDir(e),o={},l={},h={},g={};return e.xAxis&&"y"!=n&&(o=F._getAxisMinMaxByDelta(e.xAxis,a.xMin,a.xMax),g=F.getAxisStartEndGroup(e.xAxis,o.min,o.max)),e.yAxis&&"x"!=n&&(l=F._getAxisMinMaxByDelta(e.yAxis,a.yMin,a.yMax)),e.y2Axis&&(h=F._getAxisMinMaxByDelta(e.y2Axis,a.yMin,a.yMax)),{xMin:o.min,xMax:o.max,unchanged:o.unchanged,yMin:l.min,yMax:l.max,y2Min:h.min,y2Max:h.max,startGroup:g.startGroup,endGroup:g.endGroup}},_getAxisMinMaxByDelta:(e,t,i)=>{var r=e.getLinearViewportMin(),s=e.getLinearViewportMax();if(i==t&&e.isFullViewport())return F.getActualMinMax(e,r,s);var a=e.getUnboundedLinearValAt(t)-e.getUnboundedLinearValAt(0),n=e.getUnboundedLinearValAt(i)-e.getUnboundedLinearValAt(0),o=1,l=s+n-(r+a),h=e.getInfo().getMinExtent();return t!=i&&l<h&&(o=(s-r-h)/(a-n)),r+=a*o,s+=n*o,F._limitToGlobal(e,r,s)},_convertToAxisCoord:(e,i,r,s,a)=>{var n={},o=t.Agent.isRightToLeft(e.getCtx());return l.isHorizontal(e)?(n.xMin=s,n.xMax=a,n.yMin=o?r:i,n.yMax=o?i:r):(n.xMin=o?r:i,n.xMax=o?i:r,n.yMin=a,n.yMax=s),n},_limitToGlobal:(e,t,i)=>{var r=e.getLinearGlobalMin(),s=e.getLinearGlobalMax();return i-t>=s-r?(t=r,i=s):t<r?(i+=r-t,t=r):i>s&&(t-=i-s,i=s),F.getActualMinMax(e,t,i)},getActualMinMax:(e,t,i)=>{var r={min:e.linearToActual(t),max:e.linearToActual(i)};if(e.isGroupAxis()){var s=e.getLinearViewportMin(),a=e.getLinearViewportMax();Math.abs(t-s)<1e-4&&Math.abs(i-a)<1e-4&&(r.unchanged=!0)}return r},getAxisStartEndGroup:(e,t,i)=>{if(e.isGroupAxis()&&null!=t&&null!=i){var r=Math.ceil(t),s=Math.floor(i);if(s>=r)return{startGroup:e.getInfo().getGroup(r),endGroup:e.getInfo().getGroup(s)}}return{startGroup:null,endGroup:null}},setInitialSelection:(e,t)=>{var i=e.getSelectionHandler();if(i)if(t&&0!=t.length){for(var r=[],s=0;s<t.length;s++)null!=t[s].id?r.push(t[s].id):null!=t[s].series&&null!=t[s].group&&r.push(a(t[s].series,t[s].group));for(var n=new(e.getCtx().KeySetImpl)(r),o=e.getChartObjPeers(),l=[],h=0;h<o.length;h++){var g=o[h];if(g.isSelectable()){var d=g.getDataItemId(),u=a(g.getSeries(),g.getGroup());(n.has(d)||n.has(u))&&l.push(g.getId())}}i.processInitialSelections(l,o)}else i.clearSelection()},getKeyboardNavigables:e=>{var t=[];if(l.isPie(e)&&e.pieChart)for(var i=e.pieChart.__getSlices(),r=0;r<i.length;r++)d.isSeriesRendered(e,i[r].getSeriesIndex())&&t.push(i[r]);else for(var s=e.getChartObjPeers(),a=0;a<s.length;a++)s[a].isNavigable()&&t.push(s[a]);return t},addEventData:(e,t)=>{var i=d.getSeriesIdx(e,t.series),r=d.getGroupIdx(e,t.group),s=d.getNestedDataItemIdx(e,i,r,t.id),a=c.getDataContext(e,i,r,s);a&&(t.data=a.data,t.itemData=a.itemData,t.seriesData=a.seriesData,a.groupData?t.groupData=a.groupData:null!=r&&(t.groupData=d.getGroupsDataForContext(e)[r]))},addGroupDrillEventData:(e,t)=>{var i={};Object.assign(i,t);var r=e.xAxis.getInfo().getItemsRange(t.group);delete i.series;for(var s=r.startIndex,a=r.endIndex,n=[],o=s;o<a+1;o++)for(var l=d.getSeriesCount(e),h=0;h<l;h++)n.push(d.getRawDataItem(e,h,o));return i.items=n,i.groupData=r.groupData,i},addMultiSeriesDrillEventData:(e,t)=>{var i={};Object.assign(i,t);var r=_._getSeriesIndicesArrays(e).other;delete i.group;for(var s=[],a=[],n=[],o=0;o<r.length;o++){var l=d.getSeriesDataForContext(e,r[o]),h=d.getRawDataItem(e,r[o],0);s.push(l),a.push(h),n.push(d.getSeries(e,r[o]))}return i.seriesData=s,i.items=a,i.series=n,i},addSeriesDrillEventData:(e,t)=>{var i={};Object.assign(i,t);var r=d.getSeriesIdx(e,t.id),s=d.getGroupCount(e);i.series=t.id,delete i.group,i.seriesData=d.getSeriesDataForContext(e,r);for(var a=[],n=0;n<s;n++){var o=d.getRawDataItem(e,r,n);a.push(o)}return i.items=a,i},addItemDrillEventData:(e,t)=>{var i={};Object.assign(i,t);var r=d.getSeriesIdx(e,t.series),s=d.getGroupIdx(e,t.group),a=d.getNestedDataItemIdx(e,r,s,t.id);return i.seriesData=d.getSeriesDataForContext(e,r),i.groupData=d.getGroupsDataForContext(e)[s],i.data=d.getRawDataItem(e,r,s,a),i.itemData=d.getDataItem(e,r,s,a)._itemData,i},addPlotAreaDnDBackground:(e,i,r,s)=>{var a=O.isPlotAreaDraggable(e);if(O.isPlotAreaDropTarget(e)||a){var n=new t.Rect(e.getCtx(),0,0,s?r.w:r.h,s?r.h:r.w);n.setInvisibleFill(),i.addChild(n),e.getCache().putToCache("plotAreaBackground",n),a&&n.setClassName("oj-draggable")}}},N={_DEFAULT_3D_GAP_RATIO:1/36,_DEFAULT_2D_GAP_RATIO:1/70,_MAX_WIDTH_FOR_GAPS:.25,_GROUP_IDX:0,_SLICE_VALUE_THRESHOLD:1e-4,render:(e,i,r)=>{var s=new t.Container(e.getCtx());s.setTranslate(r.x,r.y),i.addChild(s),e.setPlotArea(s);var a,n=l.isHorizontal(e);if(n)a=new t.Rectangle(0,0,r.w,r.h);else{var o=new t.Matrix,h=t.Agent.isRightToLeft(e.getCtx())?-1:1;o=(o=(o=o.translate(-r.h/2,-r.w/2)).rotate(h*Math.PI/2)).translate(r.x+r.w/2,r.y+r.h/2),a=new t.Rectangle(0,0,r.h,r.w),s.setMatrix(o)}F.addPlotAreaDnDBackground(e,s,r,n),N._renderFunnelSlices(e,s,a)||L(e,i,r);var g=d.getInitialSelection(e);F.setInitialSelection(e,g),e.highlight(d.getHighlightedCategories(e))},_renderFunnelSlices:(e,t,i)=>{for(var r=e.getOptions(),s=d.getSeriesCount(e),a=c.getDataItemGaps(e),n=("on"==r.styleDefaults.threeDEffect?N._DEFAULT_3D_GAP_RATIO:N._DEFAULT_2D_GAP_RATIO)*i.w,o=a*Math.min(N._MAX_WIDTH_FOR_GAPS*i.w/(s-1),n),l=0,h=0,g=0,u=0;u<s;u++)if(d.isDataItemRendered(e,u)){var _=d.getTargetVal(e,u);null==_&&(_=d.getVal(e,u,N._GROUP_IDX)),_<=0||(l+=_)}if(0==l)return!1;for(var p=s-1;p>=0;p--)if(d.isDataItemRendered(e,p)){var v,m=d.getVal(e,p,N._GROUP_IDX),x=d.getTargetVal(e,p);if(!(m<=0&&null==x||null!=x&&x<=0))if(!((null!=x?x:m)<N._SLICE_VALUE_THRESHOLD*l))null!=x?(g+=x/l,v=new B(e,p,h,i.w,i.h,1-g,x/l,m/x,o)):(g+=m/l,v=new B(e,p,h,i.w,i.h,1-g,m/l,null,o)),h++,t.addChild(v),f.associate(v,e,p,N._GROUP_IDX)}return!0}};class H extends t.Path{constructor(e,i,r,s,a,n,o,l){super(e.getCtx()),this._MIN_CHARS_DATA_LABEL=3,this._SLICE_LABEL_HORIZONTAL_PADDING=4,this._3D_WIDTH_FACTOR=.2,this._chart=e;var h=e.getOptions().styleDefaults;this._seriesIndex=i,this._numDrawnSeries=r,this._pyramidWidth=s,this._pyramidHeight=a,this._startPercent=n,this._valuePercent=o,this._3dRatio="on"==h.threeDEffect?1:0,this._gap=l;var g=this._getPath();this._dataColor=c.getColor(this._chart,this._seriesIndex,0),this._3dRatio>0?(this.setCmds(g.threeDPathTop),this._threeDPathSide=new t.Path(this.getCtx(),g.threeDPathSide),this._mainFace=new t.Path(this.getCtx(),g.slice),this.addChild(this._threeDPathSide),this.addChild(this._mainFace)):this.setCmds(g.slice),this._setColorProps(g.sliceBounds),this._label=this._getSliceLabel(g.sliceBounds),null!=this._label&&(this._label.setMouseEnabled(!1),this.addChild(this._label))}_getPath(){var e,i,r,s,a,n,o=t.Agent.isRightToLeft(this.getCtx()),l=d.getSeriesCount(this._chart),h=(l-this._numDrawnSeries-1)*this._gap,g=this._3dRatio*this._3D_WIDTH_FACTOR*.98*this._pyramidWidth,u=this._chart.getOptions(),_=Math.sqrt(Math.pow(this._pyramidHeight-(l-1)*this._gap,2)*(1-this._startPercent)),c=this._startPercent+this._valuePercent>=1?0:Math.sqrt(Math.pow(this._pyramidHeight-(l-1)*this._gap,2)*(1-this._startPercent-this._valuePercent)),p=.98*(1-this._3dRatio*this._3D_WIDTH_FACTOR)*this._pyramidWidth*(c/this._pyramidHeight),v=0==this._numDrawnSeries?_:_-this._gap,m=.98*(1-this._3dRatio*this._3D_WIDTH_FACTOR)*this._pyramidWidth*(v/this._pyramidHeight);if(o?(i=[this._pyramidWidth-.5*this._pyramidWidth+g/2-p/2,h+c],s=[this._pyramidWidth-.5*this._pyramidWidth+g/2-m/2,h+_],r=[this._pyramidWidth-.5*this._pyramidWidth+g/2+m/2,h+_],e=[this._pyramidWidth-.5*this._pyramidWidth+g/2+p/2,h+c]):(e=[.5*this._pyramidWidth-g/2-p/2,h+c],r=[.5*this._pyramidWidth-g/2-m/2,h+_],s=[.5*this._pyramidWidth-g/2+m/2,h+_],i=[.5*this._pyramidWidth-g/2+p/2,h+c]),"on"==u.styleDefaults.threeDEffect){var f=Math.atan(2*_/m),x=Math.min(.9*f,Math.PI/4),C=this._3dRatio*this._3D_WIDTH_FACTOR*m*Math.sqrt(2)/2,S=this._3dRatio*this._3D_WIDTH_FACTOR*p*Math.sqrt(2)/2,A=S/Math.tan(x);a=t.PathUtils.moveTo(i[0],i[1]),a+=t.PathUtils.lineTo(i[0]+(o?-1:1)*Math.max(S,1),i[1]-Math.max(S,.5)),a+=t.PathUtils.lineTo(e[0]+(o?-1:1)*Math.max(A,1),e[1]-Math.max(S,.5)),a+=t.PathUtils.lineTo(e[0],e[1]),a+=t.PathUtils.closePath(),n=t.PathUtils.moveTo(i[0],i[1]),n+=t.PathUtils.lineTo(i[0]+(o?-1:1)*Math.max(S,1),i[1]-Math.max(S,.5)),n+=t.PathUtils.lineTo(s[0]+(o?-1:1)*C,s[1]-C),n+=t.PathUtils.lineTo(s[0],s[1]),n+=t.PathUtils.closePath()}var b=t.PathUtils.moveTo(i[0],i[1]);b+=t.PathUtils.lineTo(s[0],s[1]),b+=t.PathUtils.lineTo(r[0],r[1]),b+=t.PathUtils.lineTo(e[0],e[1]),b+=t.PathUtils.closePath();var y=p/m,M=.5*Math.abs(e[1]-r[1])*(1+y),D=.5*Math.abs(s[0]-r[0])*(1+y)-this._SLICE_LABEL_HORIZONTAL_PADDING,T=r[1]-M,I=r[0]+(m-D)/2*(o?-1:1);return{slice:b,sliceBounds:new t.Rectangle(I,T,D,M),threeDPathTop:a,threeDPathSide:n}}_getSliceLabel(e){var i=c.getDataLabel(this._chart,this._seriesIndex,0);if(i||(i=d.getSeriesLabel(this._chart,this._seriesIndex)),i&&"none"!=R.getDataLabelPos(this._chart,this._seriesIndex,0)){var r=new t.MultilineText(this.getCtx(),i,0,0),s=null!=c.getPattern(this._chart,this._seriesIndex,0),a=this._chart.getOptions().styleDefaults,n=[a._dataLabelStyle,a.dataLabelStyle,new t.CSSStyle(d.getDataItem(this._chart,this._seriesIndex,0).labelStyle)],o=t.CSSStyle.mergeStyles(n);if(r.setCSSStyle(o),t.TextUtils.fitText(r,e.w,e.h,this,this._MIN_CHARS_DATA_LABEL)){var l=r.getDimensions(),h=this._getLabelPos(e);if(s){var g=.15*l.h,u=t.PathUtils.roundedRectangle(l.x-g,l.y,l.w+2*g,l.h,2,2,2,2),_=new t.Path(this.getCtx(),u);_.setSolidFill("#FFFFFF",.9),h=h.translate(-.5*l.w,-.5*l.h),_.setMatrix(h),this.addChild(_)}var p=s?"#000000":e.containsPoint(e.x+(e.w-l.w)/2,e.y)?t.ColorUtils.getContrastingTextColor(this._dataColor):t.ColorUtils.getContrastingTextColor(null),v=new t.CSSStyle({color:p});return n.splice(1,0,v),t.Agent.isHighContrast()&&n.push(v),o=t.CSSStyle.mergeStyles(n),r.setCSSStyle(o),r.setMatrix(this._getLabelPos(e)),r.alignCenter(),r.alignMiddle(),r}}}_getLabelPos(e){var i=new t.Matrix;return i=t.Agent.isRightToLeft(this.getCtx())?i.translate(e.x-e.w/2,e.y+e.h/2):i.translate(e.x+e.w/2,e.y+e.h/2)}_setColorProps(e){var i=k.getFunnelPyramidSliceFill(this._chart,this._seriesIndex,this._dataColor,e),r=c.getBorderColor(this._chart,this._seriesIndex,0),s=c.getUserBorderWidth(this._chart,this._seriesIndex,0),a=c.getDefaultBorderWidth(this._chart,this._seriesIndex,0),n=null!==s?s:a,o=!1,l="redwood"===this.getCtx().getThemeBehavior();null==r&&this._3dRatio>0&&(o=!0,r="#FFFFFF"),!r||l&&this._chart.isSelectionSupported()&&o||(this.setSolidStroke(r,null,n),this._3dRatio>0&&(this._threeDPathSide.setSolidStroke(r,null,n),this._mainFace.setSolidStroke(r,null,n)));var h=t.SelectionEffectUtils.getHoverBorderColor(this._dataColor);if(this._3dRatio>0){var g=!i.getPattern&&!i.getAlphas;this._mainFace.setFill(i),this._mainFace.setStyle(c.getStyle(this._chart,this._seriesIndex,0)),this._mainFace.setClassName(c.getClassName(this._chart,this._seriesIndex,0)),this._threeDPathSide.setFill(g?new t.SolidFill(t.ColorUtils.getDarker(i.getColor(),.3)):i),this._threeDPathSide.setStyle(c.getStyle(this._chart,this._seriesIndex,0)),this._threeDPathSide.setClassName(c.getClassName(this._chart,this._seriesIndex,0)),this.setFill(g?new t.SolidFill(t.ColorUtils.getDarker(i.getColor(),.3)):i),this.setStyle(c.getStyle(this._chart,this._seriesIndex,0)),this.setClassName(c.getClassName(this._chart,this._seriesIndex,0))}else this.setFill(i),this.setStyle(c.getStyle(this._chart,this._seriesIndex,0)),this.setClassName(c.getClassName(this._chart,this._seriesIndex,0));if(this.OriginalStroke=this.getStroke(),this._chart.isSelectionSupported())if(this.setCursor(t.SelectionEffectUtils.getSelectingCursor()),this._3dRatio>0)if(this._mainFace.setCursor(t.SelectionEffectUtils.getSelectingCursor()),this._threeDPathSide.setCursor(t.SelectionEffectUtils.getSelectingCursor()),l){this._mainFace.setFeedbackClassName("oj-dvt-selectable"),this._threeDPathSide.setFeedbackClassName("oj-dvt-selectable");var d=null==r||o?this._dataColor:r,u=null!==s?s:0;this._mainFace.setSolidStroke(d,null,u),this._threeDPathSide.setSolidStroke(d,null,u),r&&(o&&(this._mainFace.addClassName("oj-dvt-default-border-color"),this._threeDPathSide.addClassName("oj-dvt-default-border-color")),null==s&&(this._mainFace.addClassName("oj-dvt-default-border-width"),this._threeDPathSide.addClassName("oj-dvt-default-border-width")))}else{var _=c.getSelectedInnerColor(this._chart),p=c.getSelectedOuterColor(this._chart)?c.getSelectedOuterColor(this._chart):this._dataColor;this._mainFace.setHoverStroke(new t.Stroke(h,1,2)),this._threeDPathSide.setHoverStroke(new t.Stroke(h,1,2)),this._mainFace.setSelectedStroke(new t.Stroke(_,1,1.5),new t.Stroke(p,1,4.5)),this._mainFace.setSelectedHoverStroke(new t.Stroke(_,1,1.5),new t.Stroke(h,1,4.5))}else if(this.setCursor(t.SelectionEffectUtils.getSelectingCursor()),l){this.setFeedbackClassName("oj-dvt-selectable");d=null==r||o?this._dataColor:r,u=null!==s?s:0;this.setSolidStroke(d,null,u),r&&(o&&this.addClassName("oj-dvt-default-border-color"),null==s&&this.addClassName("oj-dvt-default-border-width"))}else{_=c.getSelectedInnerColor(this._chart),p=c.getSelectedOuterColor(this._chart)?c.getSelectedOuterColor(this._chart):this._dataColor;this.setHoverStroke(new t.Stroke(h,1,2)),this.setSelectedStroke(new t.Stroke(_,1,1.5),new t.Stroke(p,1,4.5)),this.setSelectedHoverStroke(new t.Stroke(_,1,1.5),new t.Stroke(h,1,4.5))}}getAnimParams(){return[this._startPercent,this._valuePercent,this.getAlpha(),this._3dRatio]}setAnimParams(e){this._startPercent=e[0],this._valuePercent=e[1],this.setAlpha(e[2]),this._3dRatio=e[3];var t=this._getPath();this._threeDPathSide&&this._mainFace?(this.setCmds(t.threeDPathTop),this._threeDPathSide.setCmds(t.threeDPathSide),this._mainFace.setCmds(t.slice)):this.setCmds(t.slice),this._label&&this._label.setMatrix(this._getLabelPos(t.sliceBounds))}setSelected(e){if(this._3dRatio>0)if(this._mainFace.setSelected(e),"redwood"===this.getCtx().getThemeBehavior()&&this._threeDPathSide.setSelected(e),e){var t=this.getDimensions(),i=t.w,r=t.h,s=(i-3)/i,a=(r-5)/r;this._mainFace.setScaleX(s),this._mainFace.setScaleY(a),this._mainFace.setTranslateX(Math.ceil(1.5)+3/i*t.x),this._mainFace.setTranslateY(Math.ceil(2.5)+5/r*t.y)}else this._mainFace.setScaleX(1),this._mainFace.setScaleY(1),this._mainFace.setTranslateX(0),this._mainFace.setTranslateY(0);else super.setSelected(e)}showHoverEffect(){"redwood"===this.getCtx().getThemeBehavior()&&0!==this._3dRatio||super.showHoverEffect(),this._3dRatio>0&&(this._threeDPathSide.showHoverEffect(),this._mainFace.showHoverEffect())}hideHoverEffect(){"redwood"===this.getCtx().getThemeBehavior()&&0!==this._3dRatio||super.hideHoverEffect(),this._3dRatio>0&&(this._threeDPathSide.hideHoverEffect(),this._mainFace.hideHoverEffect())}copyShape(){return new H(this._chart,this._seriesIndex,this._numDrawnSeries,this._pyramidWidth,this._pyramidHeight,this._startPercent,this._valuePercent,this._gap)}getPrimaryFill(){return this._mainFace?this._mainFace.getFill():this.getFill()}}const G={_DEFAULT_GAP_RATIO:1/70,_MAX_HEIGHT_FOR_GAPS:.25,_GROUP_IDX:0,render:(e,i,r)=>{var s=new t.Container(e.getCtx());s.setTranslate(r.x,r.y),i.addChild(s),e.setPlotArea(s);var a=new t.Rectangle(0,0,r.w,r.h);F.addPlotAreaDnDBackground(e,s,r,!0),G._renderPyramidSlices(e,s,a)||L(e,i,r);var n=d.getInitialSelection(e);F.setInitialSelection(e,n),e.highlight(d.getHighlightedCategories(e))},_renderPyramidSlices:(e,t,i)=>{for(var r=d.getSeriesCount(e),s=c.getDataItemGaps(e),a=G._DEFAULT_GAP_RATIO*i.h,n=s*Math.min(G._MAX_HEIGHT_FOR_GAPS*i.h/(r-1),a),o=0,l=0,h=0,g=0;g<r;g++)if(d.isDataItemRendered(e,g)){var u=d.getVal(e,g,G._GROUP_IDX);u<=0||(o+=u)}if(0==o)return!1;for(var _=0;_<r;_++)if(d.isDataItemRendered(e,_)){var p=d.getVal(e,_,G._GROUP_IDX);if(!(p<=0)){var v=new H(e,_,l,i.w,i.h,h,p/o,n);h+=p/o,l++,t.addChild(v),f.associate(v,e,_,G._GROUP_IDX)}}return!0}};class U extends t.Path{setWedgeParams(e,t,i,r,s,a,n,o){this._cx=e,this._cy=t,this._rx=i,this._ry=r,this._sa=s,this._ae=a,this._gap=n,this._ir=o;var l=this._makeWedgePath(0);this.setCmds(l)}_makeWedgePath(e){var i,r=Math.max(this._rx-e,0),s=Math.max(this._ry-e,0),a=360==this._ae||r<e?0:this._gap+2*e,n=this._ir?this._ir+e:0,o=360==this._ae?t.Math.degreesToRads(359.99):t.Math.degreesToRads(this._ae),l=t.Math.degreesToRads(this._sa),h=a/2,g=h<r?Math.asin(h/r):0,d=-o/2-l,u=Math.min(5*h,o>0?Math.abs(h/Math.sin(o/2)):0),_=0==r?u:u*s/r,c=this._cx+Math.cos(d)*u,p=this._cy+Math.sin(d)*_,v=this._cx+Math.cos(-g-l)*r,m=this._cy+Math.sin(-g-l)*s,f=this._cx+Math.cos(-l-o+g)*r,x=this._cy+Math.sin(-l-o+g)*s,C=t.Math.calculateAngleBetweenTwoVectors(f-this._cx,x-this._cy,v-this._cx,m-this._cy);if(C=Math.min(C,o),n>0){var S=h<n?Math.asin(h/n):0,A=this._cx+Math.cos(-S-l)*n,b=this._cy+Math.sin(-S-l)*n,y=this._cx+Math.cos(-l-o+S)*n,M=this._cy+Math.sin(-l-o+S)*n,D=t.Math.calculateAngleBetweenTwoVectors(y-this._cx,M-this._cy,A-this._cx,b-this._cy);D=Math.min(D,C,o),360==this._ae?(i=t.PathUtils.moveTo(f,x),i+=t.PathUtils.arcTo(r,s,o,1,v,m),i+=t.PathUtils.lineTo(f,x),i+=t.PathUtils.moveTo(A,b),i+=t.PathUtils.arcTo(n,n,o,0,y,M)):(i=t.PathUtils.moveTo(y,M),i+=t.PathUtils.lineTo(f,x),i+=t.PathUtils.arcTo(r,s,C,1,v,m),i+=t.PathUtils.lineTo(A,b),i+=t.PathUtils.arcTo(n,n,D,0,y,M))}else 360==this._ae?(i=t.PathUtils.moveTo(f,x),i+=t.PathUtils.arcTo(r,s,o,1,v,m)):(i=t.PathUtils.moveTo(c,p),i+=t.PathUtils.lineTo(f,x),i+=t.PathUtils.arcTo(r,s,C,1,v,m));return i+=t.PathUtils.closePath()}_initializeSelectionEffects(){var e="redwood"===this.getCtx().getThemeBehavior(),i=this.isSelected()||e?U._OUTER_BORDER_WIDTH:U._OUTER_BORDER_WIDTH_HOVER,r=this._makeWedgePath(i),s=this._makeWedgePath(i+U._INNER_BORDER_WIDTH);if(this.OuterChild)return this.OuterChild.setCmds(r),void this.InnerChild.setCmds(s);this.OuterChild=new t.Path(this.getCtx(),r),this.OuterChild.setInvisibleFill(),this.OuterChild.setMouseEnabled(!0),this.addChild(this.OuterChild),this.InnerChild=new t.Path(this.getCtx(),s),this.InnerChild.setInvisibleFill(),this.InnerChild.setMouseEnabled(!0),this.addChild(this.InnerChild)}_showNestedBorders(e,t){this._initializeSelectionEffects(),t?(this.setSolidFill(e),this.setStroke(null),this.setClassName().setStyle(),this.OuterChild.setSolidFill(t),this.OuterChild.setClassName().setStyle(),this.InnerChild.setFill(this._fill),this.InnerChild.setClassName(this._shapeClassName).setStyle(this._shapeStyle)):e?(this.setSolidFill(e),this.setStroke(null),this.setClassName().setStyle(),this.OuterChild.setFill(this._fill),this.OuterChild.setClassName(this._shapeClassName).setStyle(this._shapeStyle),this.InnerChild.setInvisibleFill(),this.InnerChild.setClassName().setStyle()):(this.setFill(this._fill),this.setStroke(this._shapeStroke),this.setClassName(this._shapeClassName).setStyle(this._shapeStyle),this.OuterChild.setInvisibleFill(),this.OuterChild.setClassName().setStyle(),this.InnerChild.setInvisibleFill(),this.InnerChild.setClassName().setStyle())}setStyleProperties(e,i,r,s,a,n,o){this._fill=e,this._shapeStroke=i;var l="redwood"===this.getCtx().getThemeBehavior();this._hoverColor=l?r:t.SelectionEffectUtils.getHoverBorderColor(r),this._innerColor=s,this._outerColor=a,this._shapeClassName=n,this._shapeStyle=o,this.setStyle(o).setClassName(n),this.setFill(e),i&&this.setStroke(i)}showHoverEffect(){this.IsShowingHoverEffect=!0;var e="redwood"===this.getCtx().getThemeBehavior()&&this.isSelected()?this._outerColor:this._hoverColor;this._showNestedBorders(e,this._innerColor)}hideHoverEffect(){this.IsShowingHoverEffect=!1,this.isSelected()?this._showNestedBorders(this._outerColor,this._innerColor):this._showNestedBorders()}setSelected(e){if(this.IsSelected!=e){this.IsSelected=e;var t="redwood"===this.getCtx().getThemeBehavior();if(this.isHoverEffectShown()){var i=t&&this.isSelected()?this._outerColor:this._hoverColor;this._showNestedBorders(i,this._innerColor)}else this.isSelected()?this._showNestedBorders(this._outerColor,this._innerColor):this._showNestedBorders()}}UpdateSelectionEffect(){}}U._OUTER_BORDER_WIDTH=2,U._OUTER_BORDER_WIDTH_HOVER=1.25,U._INNER_BORDER_WIDTH=1;class V{constructor(){this._sliceLabel=null,this._slice=null,this._angle=-1,this._position=-1,this._width=-1,this._height=-1,this._x=-1,this._y=-1,this._initialNumLines=-1,this._hasFeeler=!1,this._maxY=-1,this._minY=-1}getAngle(){return this._angle}setAngle(e){this._angle=e}getHeight(){return this._height}setHeight(e){this._height=e}getInitialNumLines(){return this._initialNumLines}setInitialNumLines(e){this._initialNumLines=e}getMaxY(){return this._maxY}setMaxY(e){this._maxY=e}getMinY(){return this._minY}setMinY(e){this._minY=e}boundY(e){return this._minY<=this._maxY&&(e=Math.max(e,this._minY),e=Math.min(e,this._maxY)),e}hasFeeler(){return this._hasFeeler}setHasFeeler(e){this._hasFeeler=e}getPosition(){return this._position}setPosition(e){this._position=e}getSlice(){return this._slice}setSlice(e){this._slice=e}getSliceLabel(){return this._sliceLabel}setSliceLabel(e){this._sliceLabel=e}getWidth(){return this._width}setWidth(e){this._width=e}getX(){return this._x}setX(e){this._x=e}getY(){return this._y}setY(e){this._y=e}}const Y={SURFACE_CRUST:0,SURFACE_LEFT:1,SURFACE_RIGHT:2,reflectAngleOverYAxis:(e,i,r,s,a)=>{var n=t.Math.degreesToRads(360-e);return{x:i+Math.cos(n)*s,y:r+Math.sin(n)*a}},getGradientColors:(e,i)=>"2D"==i||"3D"==i?[t.ColorUtils.adjustHSL(e,0,-.04,-.05),t.ColorUtils.adjustHSL(e,0,-.09,.04)]:"CRUST"==i?[t.ColorUtils.adjustHSL(e,0,-.04,-.05),t.ColorUtils.adjustHSL(e,0,0,-.14)]:"SIDE"==i?[t.ColorUtils.adjustHSL(e,0,-.1,.06),t.ColorUtils.adjustHSL(e,0,-.04,-.05)]:void 0,getGradientAlphas:(e,t)=>{var i=null==e||isNaN(e)||0==e?1:e;return"2D"==t?[i,i,i]:"BORDER"==t?[i/1.59375,i/5.3125,i/(255/96)]:"3D"==t?[i,i,i,i,i]:"CRUST"==t?[i,i,i,i]:"SIDE"==t?[i,i]:void 0},createTopSurface:(e,i)=>{var r=e.getPieChart(),s=r.getCtx(),a=e.getCenter(),n=e.getInnerRadius(),o=r.is3D()||e.getSliceGaps()>Math.sin(t.Math.degreesToRads(e.getAngleExtent()))*e._radiusX+1?null:e.getSliceGaps(),l=new U(s);l.setWedgeParams(a.x,a.y,e._radiusX,e._radiusY,e.getAngleStart(),e.getAngleExtent(),o,n);var h=c.getSelectedInnerColor(r.chart),g=c.getSelectedOuterColor(r.chart),d=new t.Stroke(e.getStrokeColor(),1,e.getBorderWidth()),u=e.getSeriesIndex(),_=c.getClassName(r.chart,u,0),p=c.getStyle(r.chart,u,0);l.setStyleProperties(i,d,e.getFillColor(),h,g,_,p);var v=[l];return Y.associate(e,v),v},associate:(e,t)=>{if(t)for(var i=0;i<t.length;i++)e.getPieChart().chart.getEventManager().associate(t[i],e)},createLateralSurface:(e,i,r)=>{if(0==e.getAngleExtent())return[];var s=[];if(t.ColorUtils.getAlpha(e.getFillColor())>0)if(i==Y.SURFACE_LEFT||i==Y.SURFACE_RIGHT)s.push(Y._generateLateralShape(e,i,null,r));else if(i==Y.SURFACE_CRUST)for(var a=Y._createCrustPathCommands(e),n=a.length,o=0;o<n;o++)s.push(Y._generateLateralShape(e,i,a[o],r));return Y.associate(e,s),s},generateLateralGradientFill:(e,i)=>{var r=Y.getGradientColors(t.ColorUtils.getRGB(e.getFillColor()),i),s=Y.getGradientAlphas(t.ColorUtils.getAlpha(e.getFillColor()),i);return new t.LinearGradientFill(270,r,s,[0,1],null)},_generateLateralShape:(e,i,r,s)=>{var a=e.getPieChart().getCtx();if(i==Y.SURFACE_LEFT||i==Y.SURFACE_RIGHT){for(var n=e.getAngleStart(),o=e.getAngleExtent(),l=e.getCenter().x,h=e.getCenter().y,g=e._radiusX,d=e._radiusY,u=e.getDepth(),_=i==Y.SURFACE_LEFT?Y.reflectAngleOverYAxis(n+o,l,h,g,d):Y.reflectAngleOverYAxis(n,l,h,g,d),c=Y._generateInnerPoints(l,h,_.x,_.y,u),p=[],v=0;v<c.length;v++)p.push(c[v].x,c[v].y);var m=new t.Polygon(a,p);return m.setFill(s),e.getStrokeColor()&&m.setSolidStroke(e.getStrokeColor()),m}if(r){var f=new t.Path(a,null);return f.setCmds(r),f.setTranslate(e.__getExplodeOffsetX(),e.__getExplodeOffsetY()),f.setFill(s),e.getStrokeColor()&&f.setSolidStroke(e.getStrokeColor()),f}return null},_createCrustPathCommands:e=>{var t=e.getAngleStart(),i=e.getAngleExtent(),r=t+i,s=e.getCenter().x,a=e.getCenter().y,n=e._radiusX,o=e._radiusY,l=e.getDepth(),h=[];return t<180&&r>360?(h.push(Y._makeOuterPath(s,a,n,o,l,t,180-t)),h.push(Y._makeOuterPath(s,a,n,o,l,360,r-360)),h.push(Y._makeOuterPath(s,a,n,o,l,180,180))):r>360?(h.push(Y._makeOuterPath(s,a,n,o,l,t,360-t)),h.push(Y._makeOuterPath(s,a,n,o,l,360,r-360))):t<180&&r>180?(h.push(Y._makeOuterPath(s,a,n,o,l,t,180-t)),h.push(Y._makeOuterPath(s,a,n,o,l,180,r-180))):h.push(Y._makeOuterPath(s,a,n,o,l,t,i)),h},_makeOuterPath:(e,i,r,s,a,n,o)=>{var l=t.Math.degreesToRads(o),h=-(t.Math.degreesToRads(n)+l),g=Y.reflectAngleOverYAxis(n,e,i,r,s),d=e+Math.cos(h)*r,u=i+Math.sin(h)*s,_=t.PathUtils.moveTo(g.x,g.y);return _+=t.PathUtils.arcTo(r,s,l,0,d,u),_+=t.PathUtils.lineTo(d,u+a),_+=t.PathUtils.arcTo(r,s,l,1,g.x,g.y+a),_+=t.PathUtils.lineTo(g.x,g.y)},_generateInnerPoints:(e,t,i,r,s)=>{var a=[];return a.push({x:e,y:t}),a.push({x:i,y:r}),a.push({x:i,y:r+s}),a.push({x:e,y:t+s}),a}},W={_MAX_LINES_PER_LABEL:3,_COLLISION_MARGIN:1,_LEFT_SIDE_LABELS:1,_RIGHT_SIDE_LABELS:2,_OUTSIDE_LABEL_DISTANCE:1.04,_FEELER_RAD_MINSIZE:.1,_FEELER_HORIZ_MINSIZE:.1,_LABEL_TO_FEELER_OFFSET:.5,_LABEL_TO_FEELER_DISTANCE:3,_NO_COLLISION:0,_HALF_COLLISION:1,_ALL_COLLISION:2,layoutLabelsAndFeelers:e=>{var t=e.getLabelPos();W._layoutInsideLabels(e,"auto"==t),W._layoutOutsideLabelsAndFeelers(e)},_layoutInsideLabels:(e,i)=>{for(var r=e.__getSlices(),s=0;s<r.length;s++){var a=r[s],n=e.getSeriesLabelPos(a.getSeriesIndex());if("none"!=n&&"outsideSlice"!=n&&!W._skipSliceLabel(e,a)){var o=a.getAngleStart()+a.getAngleExtent()/2,l=a.getInnerRadius(),h=a.getCenter(),g=0,d=0,u=W._createLabel(a,!0);if(1==r.length)g=h.x,d=h.y;else{var _=Math.max(.45,.65-.45*l/Math.max(a.getRadiusY(),.001)),c=Y.reflectAngleOverYAxis(o,h.x,h.y,l+(a.getRadiusX()-l)*_,l+(a.getRadiusY()-l)*_);g=c.x,d=c.y}u.setX(g),u.setY(d),u.alignMiddle(),u.alignCenter();for(var p=u.getDimensions(),v=g,m=g,f=d-p.h/2,x=d+p.h/2;a.contains(v,f)&&a.contains(v,x);)v--;for(;a.contains(m,f)&&a.contains(m,x);)m++;v=Math.ceil(v+3),m=Math.floor(m-3);var C=2*Math.min(g-v,m-g);if(C<p.w&&(u.setX((v+m)/2),C=m-v),i&&"center"!=n){u.getDimensions().w<C?a.setSliceLabel(u):a.setSliceLabel(null)}else{var S=e.getCtx().getStage(),A=W._isTextLabel(e,a)?null:u.getTextString().length;t.TextUtils.fitText(u,C,p.h,S,A)&&(S.removeChild(u),a.setSliceLabel(u))}null!=a.getSliceLabel()&&a.setNoOutsideFeeler()}}},_layoutOutsideLabelsAndFeelers:e=>{var t,i,r=W._generateInitialLayout(e);t=r[0],i=r[1];var s=W._refineInitialLayout(e,t,W._LEFT_SIDE_LABELS),a=W._refineInitialLayout(e,i,W._RIGHT_SIDE_LABELS);s==W._HALF_COLLISION&&a!=W._NO_COLLISION&&W._columnLabels(e,t,!0,!0,!0),s!=W._NO_COLLISION&&a==W._HALF_COLLISION&&W._columnLabels(e,i,!1,!0,!0),W._setLabelsAndFeelers(e,t,W._LEFT_SIDE_LABELS),W._setLabelsAndFeelers(e,i,W._RIGHT_SIDE_LABELS)},_createLabel:(e,i)=>{var r=e.getPieChart(),s=r.getCtx(),a=i?new t.OutputText(s):new t.MultilineText(s),n=t.ColorUtils.getContrastingTextColor(e.getFillColor()),o=new t.CSSStyle({color:n}),l=r.getOptions().styleDefaults,h=[l._dataLabelStyle];i&&h.push(o),h.push(l.dataLabelStyle);var g=d.getDataItem(r.chart,e.getSeriesIndex(),0);g&&h.push(new t.CSSStyle(g.labelStyle)),t.Agent.isHighContrast()&&h.push(o);var u=t.CSSStyle.mergeStyles(h);a.setCSSStyle(u);var _=W.generateSliceLabelString(e,l.sliceLabelType);return a.setTextString(_),e.setSliceLabelString(_),a},createPieCenter:e=>{var i=e.getOptions(),r=e.getCtx(),s=W.getPieCenterOptions(e,i),a=s.label,n=s.renderer,o=e.getLabelPos(),l=i.tooltip,h=l?l.renderer:null,d=e.getCenter(),u=e.getInnerRadius();if(a||n){var _=e.getRadiusX(),c=(u=u>0?u:"outsideSlice"==o?.9*_:.5*_)*Math.sqrt(2);if(a){var p=new t.MultilineText(r),v=s.labelStyle;if(p.setCSSStyle(v),"number"==typeof a&&(a=g.formatVal(e,s,a,a,a,0)),p.setTextString(a),t.TextUtils.fitText(p,c,c,e)){var m=p.getDimensions();p.setY(d.y-m.h/2),p.setX(d.x),p.alignCenter(),h||e.chart.getEventManager().associate(p,new t.SimpleObjPeer(p.getTextString(),null,null,{type:"pieCenterLabel"})),e.addChild(p),e.setCenterLabel(p)}}if(h){var f=new t.Circle(r,d.x,d.y,u);f.setInvisibleFill(),e.addChild(f);var x=e.getCtx().getTooltipManager();e.chart.getEventManager().associate(f,new t.CustomDatatipPeer(x,h,"#4b4b4b",{component:i._widgetConstructor,label:a}))}if(n){var C={outerBounds:{x:d.x-u,y:d.y-u,width:2*u,height:2*u},innerBounds:{x:d.x-c/2,y:d.y-c/2,width:c,height:c},label:a,totalValue:e.getTotalValue(),component:i._widgetConstructor};C=r.fixRendererContext(C);var S=r.getContainer(),A=e.chart.pieCenterDiv;A&&S.removeChild(A);var b=n(C);if(!b)return;var y=r.createOverlayDiv();Array.isArray(b)?b.forEach(e=>{y.appendChild(e)}):"string"==typeof b?(y.textContent=b,y.style.position="absolute",y.style.left=d.x+"px",y.style.top=d.y+"px",y.style.transform="translate(-50%, -50%)",y.style.width=2*u+"px",y.style.height=2*u+"px",y.style.display="flex",y.style.textAlign="center",y.style.alignItems="center"):y.appendChild(b),e.chart.pieCenterDiv=y,S.appendChild(y);var M=r.getOverlayAttachedCallback();M&&M(y)}}},generateSliceLabelString:(e,t)=>{var i,r=W.getDefaultSliceLabelString(e,t),s=e.getPieChart().getOptions().dataLabel;if(s){var a=c.getDataContext(e._chart,e.getSeriesIndex(),0);if(a.label=r,"number"==typeof(i=s(a))){var n=g.getValueFormat(e.getPieChart().chart,"label");i=g.formatVal(e.getPieChart(),n,i)}}return i||r},getDefaultSliceLabelString:(e,t)=>{var i=e.getPieChart(),r=e.getCustomLabel(),s=g.getValueFormat(i.chart,"label");return null!=r?"number"==typeof r?g.formatVal(i,s,r):r:"percent"==t?W.generateSlicePercentageString(e):"number"==t?g.formatVal(i,s,e.getVal()):"text"==t?e.getSeriesLabel():"textAndPercent"==t?e.getSeriesLabel()+", "+W.generateSlicePercentageString(e):null},generateSlicePercentageString:e=>{var t=e.getPieChart(),i=t.getTotalValue(),r=0==i?0:e.getVal()/i,s=r<.01?3:r<.1?2:r<1?1:0;2*t.getRadiusX()<150&&(s=Math.max(s-1,0));var a=t.getCtx().getNumberConverter({style:"percent",maximumFractionDigits:s,minimumFractionDigits:s}),n="";return a&&a.format?n=a.format(r):(r*=100,n=g.formatVal(t,{},r,null,null,100==r?1:Math.pow(10,-1*s))+"%"),n},_refineInitialLayout:(e,t,i)=>{if(t&&t.length>0){for(var r,s,a=e.__getFrame().y,n=!1,o=!1,l=!1,h=0,g=!1,d=i==W._LEFT_SIDE_LABELS,u=0;u<t.length;u++)s=g,(r=t[u]).getPosition()>90&&(g=!0),h=r.getY()+r.getHeight(),a-r.getY()>W._COLLISION_MARGIN&&(g?s?l=!0:o=!0:n=!0),h>a&&(a=h);return n&&l||o?(W._columnLabels(e,t,d,!0,!0),W._ALL_COLLISION):n?(W._columnLabels(e,t,d,!0,!1),W._HALF_COLLISION):l?(W._columnLabels(e,t,d,!1,!0),W._HALF_COLLISION):W._NO_COLLISION}},_setLabelsAndFeelers:(e,i,r)=>{if(!(null==i||i.length<=0)){var s,a,n,o,l,h=r==W._LEFT_SIDE_LABELS,g=e.__getFrame(),d=1/0;for(s=0;s<i.length;s++)if(a=(o=i[s]).getSlice(),o.hasFeeler()){l=W._calculateFeeler(o,a,h);var u=t.TextUtils.getTextStringHeight(e.getCtx(),o.getSliceLabel().getCSSStyle()),_=o.getWidth(),c=W._isTextLabel(e,a)?Math.min(2*u,_):_;if(W.getMaxLabelWidth(e,o.getX(),h)+l<c||0==o.getWidth()){o.setSliceLabel(null),a.setNoOutsideFeeler();continue}d=Math.min(d,l)}else a.setNoOutsideFeeler();for(s=0;s<i.length;s++)a=(o=i[s]).getSlice(),(n=o.getSliceLabel())&&(o.hasFeeler()&&(h?o.setX(o.getX()+d):o.setX(o.getX()-d),W._calculateFeeler(o,a,h)),n.setY(o.getY()),n.setX(o.getX()),o.getY()<g.y||o.getY()+o.getHeight()>g.y+g.h?(a.setSliceLabel(null),a.setNoOutsideFeeler()):(W._truncateSliceLabel(e,a,o,h),0==o.getWidth()||0==o.getHeight()?(a.setSliceLabel(null),a.setNoOutsideFeeler()):a.setSliceLabel(n)))}},_calculateFeeler:(e,i,r)=>{var s=e.getX(),a=e.getY()+e.getHeight()*W._LABEL_TO_FEELER_OFFSET,n=W._FEELER_HORIZ_MINSIZE*i.getRadiusX(),o={x:r?(s+=W._LABEL_TO_FEELER_DISTANCE)+n:(s-=W._LABEL_TO_FEELER_DISTANCE)-n,y:a},l={x:s,y:a},h=e.getAngle(),g=W._adjustForDepth(h,i.getDepth()),d=Y.reflectAngleOverYAxis(h,i.getCenter().x,i.getCenter().y+g,i.getRadiusX(),i.getRadiusY()),u=t.Math.degreesToRads(e.getPosition()),_=Math.abs(Math.atan2(o.x-d.x,d.y-o.y)),c=(d.y-o.y)*Math.tan(u);return(u>Math.PI/2&&_>Math.PI/2&&_<u||u<Math.PI/2&&_<Math.PI/2&&_>u)&&(o.x=r?d.x-c:d.x+c),i.setOutsideFeelerPoints(d,o,l),Math.abs(l.x-o.x)-n},_adjustForDepth:(e,t)=>{var i=0;return e>189&&e<351&&(i=t),i},_getMiddleLabel:e=>{for(var t=91,i=-1,r=0;r<e.length;r++){var s=e[r].getPosition();Math.abs(s-90)<t&&(t=Math.abs(s-90),i=r)}return i},_setOptimalLabelPos:(e,i,r,s)=>{i.setX(r);var a=e.getRadiusY()*(1+W._FEELER_RAD_MINSIZE),n=t.Math.degreesToRads(i.getPosition()),o=a*Math.cos(n),l=W._adjustForDepth(i.getAngle(),e.getDepth()),h=e.getCenter().y-o-i.getHeight()*W._LABEL_TO_FEELER_OFFSET+l;i.setY(i.boundY(h))},_getRadFeelerAngle:(e,t,i)=>{var r=e.getSlice(),s=r.getCenter(),a=e.getAngle(),n=W._adjustForDepth(a,r.getDepth()),o=Y.reflectAngleOverYAxis(a,s.x,s.y+n,r.getRadiusX(),r.getRadiusY());return Math.atan2(Math.abs(t-o.x),o.y-i)},_columnLabels:(e,i,r,s,a)=>{var n,o,l,h=e.__getFrame(),g=h.y,d=h.y+h.h,u=0,_=e.getCenter().x,c=e.getRadiusX()*(1+W._FEELER_RAD_MINSIZE+W._FEELER_HORIZ_MINSIZE);for(l=r?(_-=c)+e.getRadiusX()*W._FEELER_HORIZ_MINSIZE:(_+=c)-e.getRadiusX()*W._FEELER_HORIZ_MINSIZE,n=0;n<i.length;n++)o=i[n],u=t.Math.degreesToRads(o.getPosition()),W._getRadFeelerAngle(o,l,g)-u>.45*Math.PI||W._skipSliceLabel(e,o.getSlice())?(i.splice(n,1),n--):(i[n].setMinY(g),g+=i[n].getHeight());for(n=i.length-1;n>=0;n--)o=i[n],(u=t.Math.degreesToRads(o.getPosition()))-W._getRadFeelerAngle(o,l,d)>.45*Math.PI||W._skipSliceLabel(e,o.getSlice())?i.splice(n,1):(d-=i[n].getHeight(),i[n].setMaxY(d));if(0!=i.length){var p=W._getMiddleLabel(i),v=i[p];s&&!a&&v.getMinY()+v.getHeight()>e.getCenter().y&&(a=!0),a&&!s&&v.getMaxY()<e.getCenter().y&&(s=!0);var m=v.getPosition();(a&&s||m>90&&a||m<=90&&s)&&(W._setOptimalLabelPos(e,v,_,r),v.setHasFeeler(!0));var f,x,C=v.getY(),S=v.getY()+v.getHeight();if(s)for(n=p-1;n>=0;n--)x=(o=i[n]).getHeight(),W._setOptimalLabelPos(e,o,_,r),o.setHasFeeler(!0),(f=o.getY())+x<C?C=f:C-=x,o.setY(C);if(a)for(n=p+1;n<i.length;n++)x=(o=i[n]).getHeight(),W._setOptimalLabelPos(e,o,_,r),o.setHasFeeler(!0),(f=o.getY())>S?S=f+x:S+=x,o.setY(S-x)}},_truncateSliceLabel:(e,t,i,r)=>{var s,a,n=i.getSliceLabel(),o=n.getCSSStyle(),l=e.getNumChildren(),h=!1;e.contains(n)||(e.addChild(n),h=!0),n.setCSSStyle(o);var g=t.getSliceLabelString();return n.setTextString(g),h&&e.removeChildAt(l),s=W.getMaxLabelWidth(e,i.getX(),r),a=W._getTextDim(e,t,n,s,i.getInitialNumLines()),i.setWidth(a.x),i.getHeight()!=a.y&&(i.setHeight(a.y),!0)},_generateInitialLayout:e=>{for(var t=[],i=[],r=[],s=e.__getSlices(),a=e.__getFrame(),n=0;n<s.length;n++){var o=s[n],l=e.getSeriesLabelPos(o.getSeriesIndex());if(null==o.getSliceLabel()&&"none"!=l&&"center"!=l&&!W._skipSliceLabel(e,o)){var h=W._createLabel(o,!1),g=o.getAngleStart()+o.getAngleExtent()/2;g>360&&(g-=360),g<0&&(g+=360);var d=Y.reflectAngleOverYAxis(g,e.getCenter().x,e.getCenter().y,e.getRadiusX()*W._OUTSIDE_LABEL_DISTANCE,e.getRadiusY()*W._OUTSIDE_LABEL_DISTANCE),u=g>=90&&g<270,_=W.getMaxLabelWidth(e,d.x,u),c=W._getTextDim(e,o,h,_,W._MAX_LINES_PER_LABEL);g<165&&g>15?d.y-=1*c.y:g<15||g>345?(d.y-=.5*c.y,d.x+=.2*c.y):g>165&&g<195&&(d.y-=.5*c.y,d.x-=.2*c.y);var p,v=W._adjustForDepth(g,e.getDepth());if(d.y+=v,1==s.length&&(d.x-=c.x/2),!(d.y<a.y||d.y+c.y>a.y+a.h))g>=90&&g<270?(h.alignRight(),p=g-90,W._createLabelInfo(o,h,g,p,c,d,i)):(p=g<=90?Math.abs(90-g):180-(g-270),W._createLabelInfo(o,h,g,p,c,d,r))}}return t[0]=i,t[1]=r,t},_createLabelInfo:(e,t,i,r,s,a,n)=>{for(var o,l=-1,h=t,g=0;g<n.length;g++)if((o=n[g]).getPosition()>r){l=g;break}-1==l&&(l=n.length),(o=new V).setPosition(r),o.setAngle(i),o.setSliceLabel(h),o.setSlice(e),o.setWidth(s.x),o.setHeight(s.y),o.setX(a.x),o.setY(a.y),o.setInitialNumLines(h.getLineCount()),n.splice(l,0,o)},_getTextDim:(e,i,r,s,a)=>{r.setMaxLines(a);var n=W._isTextLabel(e,i)?null:r.getTextString().length;if(t.TextUtils.fitText(r,s,1/0,e,n)){e.addChild(r);var o=r.getDimensions();return e.removeChild(r),{x:o.w,y:o.h}}return{x:0,y:0}},_isTextLabel:(e,t)=>{var i=t.getCustomLabel(),r=null!=e.getOptions().dataLabel;return-1!=e.getOptions().styleDefaults.sliceLabelType.indexOf("text")||null!=i&&"number"!=typeof i||r},getMaxLabelWidth:(e,t,i)=>{var r=e.__getFrame();return i?t-r.x:r.x+r.w-t},getPieCenterOptions:(e,i)=>{var r=t.JsonUtils.clone(i.pieCenter,null,e.chart.Defaults.getNoCloneObject().pieCenter),s=i.pieCenterLabel;if(s){var a=s.style,n=s.text;n&&(r.label=n),a&&(r.labelStyle=new t.CSSStyle(a))}return r},_skipSliceLabel:(e,t)=>t.getAngleExtent()<3&&d.getSeriesCount(e.chart)>120};class j{constructor(e,t){this._pieChart=e,this._chart=e.chart,this._angleStart=0,this._angleExtent=0,this._topSurface=null,this._leftSurface=null,this._rightSurface=null,this._crustSurface=null,this._explodeOffsetX=0,this._explodeOffsetY=0,this._sliceLabel=null,this._sliceLabelString=null,this._hasFeeler=!1,this._feelerRad=null,this._feelerHoriz=null,this._outsideFeelerStart=null,this._outsideFeelerMid=null,this._outsideFeelerEnd=null,this._selected=!1,this._selecting=!1,this._centerX=this._pieChart.getCenter().x,this._centerY=this._pieChart.getCenter().y,this._radiusX=this._pieChart.getRadiusX(),this._radiusY=this._pieChart.getRadiusY(),this._depth=this._pieChart.getDepth();var i=this._chart.getOptions();if(null!=t){var r=d.getDataItem(this._chart,t,0);this._value=d.getVal(this._chart,t,0),this._explode=_.getSliceExplode(this._chart,t),this._fillColor=c.getColor(this._chart,t,0),this._fillPattern=c.getPattern(this._chart,t,0),this._strokeColor=c.getBorderColor(this._chart,t),this._borderWidth=c.getBorderWidth(this._chart,t),this._customLabel=r?r.label:null,this._seriesLabel=d.getSeries(this._chart,t),this._drillable=d.isDataItemDrillable(this._chart,t,0),this._id=_.getSliceId(this._chart,t),this._seriesIndex=t,this._categories=d.getCategories(this._chart,t,0)}else this._value=_.getOtherVal(this._chart),this._explode=0,this._fillColor=i.styleDefaults.otherColor,this._fillPattern=null,this._strokeColor=i.styleDefaults.borderColor,this._borderWidth=i.styleDefaults.borderWidth,this._customLabel=null,this._seriesLabel=i.translations.labelOther,this._drillable=d.isMultiSeriesDrillEnabled(this._chart),this._id=_.getOtherSliceId(this._chart)}getPieChart(){return this._pieChart}render(e){for(var i=j._sortPieSurfaces(this._topSurface,this._leftSurface,this._rightSurface,this._crustSurface,this._angleStart,this._angleExtent),r=i.length,s=0;s<r;s++)for(var a=i[s],n=a.length,o=0;o<n;o++){this._pieChart.__getShapesContainer().addChild(a[o]),a[o].render&&a[o].render()}if(this._sliceLabel&&(this._pieChart.addChild(this._sliceLabel),Y.associate(this,[this._sliceLabel]),e?(this._pieChart.addChild(this._feelerRad),this._pieChart.addChild(this._feelerHoriz)):this._renderOutsideFeeler()),this._explodeSlice(),this._drillable||this._pieChart.chart.isSelectionSupported()){var l=this.getDisplayables();for(s=0;s<l.length;s++)l[s].setCursor(t.SelectionEffectUtils.getSelectingCursor())}var h=this.getTopDisplayable();h&&(h.setAriaRole("img"),this._updateAriaLabel())}_feelerFromPts(e,i){var r=new t.Line(this._pieChart.getCtx(),e.x,e.y,i.x,i.y),s=this._pieChart.getOptions().styleDefaults.pieFeelerColor,a=new t.Stroke(s);return r.setStroke(a),this._pieChart.addChild(r),r}_renderOutsideFeeler(){if(this._hasFeeler){var e=this._feelerFromPts(this._outsideFeelerStart,this._outsideFeelerMid),t=this._feelerFromPts(this._outsideFeelerMid,this._outsideFeelerEnd);this._feelerRad=e,this._feelerHoriz=t}}preRender(){var e,i=this._bFillerSlice?"color":c.getSeriesEffect(this._chart),r=this.getFillColor(),s=this.getFillPattern();if("pattern"==i||null!=s)e=new t.PatternFill(s,r),i="pattern";else if("gradient"==i){var a=this._pieChart.is3D()?"3D":"2D",n=Y.getGradientColors(t.ColorUtils.getRGB(r),a),o=Y.getGradientAlphas(t.ColorUtils.getAlpha(r),a),l=[Math.floor(this._centerX-this._radiusX),Math.floor(this._centerY-this._radiusY),Math.ceil(2*this._radiusX),Math.ceil(2*this._radiusY)];e=new t.LinearGradientFill(270,n,o,[0,1],l)}else e=new t.SolidFill(r);if(this._topSurface=Y.createTopSurface(this,e),this._depth>0||this._radiusX!=this._radiusY){var h="gradient"==i,g=new t.SolidFill(t.ColorUtils.getDarker(r,.4)),d=h?Y.generateLateralGradientFill(this,"SIDE"):g,u=h?Y.generateLateralGradientFill(this,"CRUST"):g;this._leftSurface=Y.createLateralSurface(this,Y.SURFACE_LEFT,d),this._rightSurface=Y.createLateralSurface(this,Y.SURFACE_RIGHT,d),this._crustSurface=Y.createLateralSurface(this,Y.SURFACE_CRUST,u)}this.setSliceLabel(null),this.setNoOutsideFeeler()}static _sortPieSurfaces(e,t,i,r,s,a){var n=[];return t&&i&&r&&(s<=270&&s+a>270?(n.push(t),n.push(i),n.push(r)):s>270||s+a<=90?(n.push(t),n.push(r),n.push(i)):(n.push(i),n.push(r),n.push(t))),n.push(e),n}static oppositeDir(e,t,i){return e-t>0!=e-i>0}_explodeSlice(){if(0!=this._explode){var e=this._angleExtent,i=(360-(this._angleStart+e/2))*t.Math.RADS_PER_DEGREE,r=this._pieChart.is3D()?j.THREED_TILT:1,s=this._explode*this._pieChart.__calcMaxExplodeDistance();this._explodeOffsetX=Math.cos(i)*s,this._explodeOffsetY=Math.sin(i)*r*s,"safari"!==t.Agent.browser&&"blink"!==t.Agent.engine||(this._explodeOffsetX=Math.round(this._explodeOffsetX),this._explodeOffsetY=Math.round(this._explodeOffsetY))}else this._explodeOffsetX=0,this._explodeOffsetY=0;if(this._topSurface){var a=this._pieChart.is3D()&&this._topSurface[0].getSelectionOffset?this._topSurface[0].getSelectionOffset():[];j._translateShapes(this._topSurface,a[0]?a[0]+this._explodeOffsetX:this._explodeOffsetX,a[1]?a[1]+this._explodeOffsetY:this._explodeOffsetY)}if(this._rightSurface&&j._translateShapes(this._rightSurface,this._explodeOffsetX,this._explodeOffsetY),this._leftSurface&&j._translateShapes(this._leftSurface,this._explodeOffsetX,this._explodeOffsetY),this._crustSurface&&j._translateShapes(this._crustSurface,this._explodeOffsetX,this._explodeOffsetY),this._hasFeeler){var n=this._outsideFeelerStart.x,o=this._outsideFeelerStart.y,l=n+this._explodeOffsetX,h=o+this._explodeOffsetY;this._feelerRad.setX1(l),this._feelerRad.setY1(h);var g=this._outsideFeelerMid.x,d=this._outsideFeelerMid.y;j.oppositeDir(g,n,l)?(this._feelerRad.setX2(l),this._feelerHoriz.setX1(l)):(this._feelerRad.setX2(g),this._feelerHoriz.setX1(g)),j.oppositeDir(d,o,h)?(this._feelerRad.setY2(h),this._feelerHoriz.setY1(h)):(this._feelerRad.setY2(d),this._feelerHoriz.setY1(d))}this._sliceLabel&&!this._hasFeeler&&this._sliceLabel.setTranslate(this._explodeOffsetX,this._explodeOffsetY)}static _translateShapes(e,t,i){if(e)for(var r=e.length,s=0;s<r;s++){e[s].setTranslate(t,i)}}getRadiusX(){return this._radiusX}getRadiusY(){return this._radiusY}getCenter(){return new t.Point(this._centerX,this._centerY)}getDepth(){return this._depth}getAngleExtent(){return this._angleExtent}setAngleExtent(e){this._angleExtent=e}getAngleStart(){return this._angleStart}setAngleStart(e){this._angleStart=e}__getExplodeOffsetX(){return this._explodeOffsetX}__getExplodeOffsetY(){return this._explodeOffsetY}setOutsideFeelerPoints(e,t,i){this._outsideFeelerStart=e,this._outsideFeelerMid=t,this._outsideFeelerEnd=i,this._hasFeeler=!0}setNoOutsideFeeler(){this._outsideFeelerStart=null,this._outsideFeelerMid=null,this._outsideFeelerEnd=null,this._hasFeeler=!1}getLabelAndFeeler(){var e=[];return this._sliceLabel&&e.push(this._sliceLabel),this._feelerRad&&e.push(this._feelerRad),this._feelerHoriz&&e.push(this._feelerHoriz),e}getSliceLabel(){return this._sliceLabel}setSliceLabel(e){this._sliceLabel=e}getSliceLabelString(){return this._sliceLabelString}setSliceLabelString(e){this._sliceLabelString=e}getTopSurface(){return this._topSurface}getVal(){return this._value}getId(){return this._id}getSeriesIndex(){return this._seriesIndex}static _shapeIsSelectable(e){return e instanceof U}contains(e,t){for(var i=this._pieChart.getInnerRadius(),r=this._pieChart.getCenter(),s=(e-r.x)/this._radiusX,a=(t-r.y)/this._radiusY,n=-Math.atan2(a,s)*(180/Math.PI);n<this._angleStart;)n+=360;for(;n-this._angleStart>=360;)n-=360;var o=Math.pow(s,2)+Math.pow(a,2),l=Math.sqrt(o)>i/this._radiusX&&o<=1,h=n<=this._angleStart+this._angleExtent;return l&&h}GetAnimParams(){var e=t.ColorUtils.getRed(this._fillColor),i=t.ColorUtils.getGreen(this._fillColor),r=t.ColorUtils.getBlue(this._fillColor),s=t.ColorUtils.getAlpha(this._fillColor);return[this._value,this._radiusX,this._radiusY,this._explode,this._centerX,this._centerY,this._depth,e,i,r,s]}SetAnimParams(e){this._value=e[0],this._radiusX=e[1],this._radiusY=e[2],this._explode=e[3],this._centerX=e[4],this._centerY=e[5],this._depth=e[6];var i=Math.round(e[7]),r=Math.round(e[8]),s=Math.round(e[9]),a=Math.round(e[10]);this._fillColor=t.ColorUtils.makeRGBA(i,r,s,a)}getDeletedAnimParams(){var e=this.GetAnimParams();return e[0]=0,e[1]=this.getInnerRadius(),e[2]=this.getInnerRadius(),e[3]=0,e}animateUpdate(e,i){var r=i.GetAnimParams(),s=this.GetAnimParams();if(!t.ArrayUtils.equals(r,s)){var a=new t.CustomAnimation(this._pieChart.getCtx(),this,this.getPieChart().getAnimDuration());a.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.GetAnimParams,this.SetAnimParams,s),e.add(a,0),this.SetAnimParams(r)}}animateInsert(e){var i=new t.CustomAnimation(this._pieChart.getCtx(),this,this.getPieChart().getAnimDuration());i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.GetAnimParams,this.SetAnimParams,this.GetAnimParams()),e.add(i,0),this.SetAnimParams(this.getDeletedAnimParams())}animateDelete(e,i){var r=i.__getSlices(),s=this.getPieChart().__getSlices(),a=s.indexOf(this)-1;if(a>=0){for(var n=s[a].getId(),o=0;o<r.length;o++)if(r[o].getId().equals(n)){r.splice(o+1,0,this);break}}else r.splice(0,0,this);this._pieChart=i;var l=new t.CustomAnimation(i.getCtx(),this,this.getPieChart().getAnimDuration());l.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.GetAnimParams,this.SetAnimParams,this.getDeletedAnimParams()),l.setOnEnd(this._removeDeletedSlice,this),e.add(l,0)}_removeDeletedSlice(){var e=this.getPieChart().__getSlices(),t=e.indexOf(this);t>=0&&e.splice(t,1)}getDisplayables(){var e=new Array;return this._topSurface&&(e=e.concat(this._topSurface)),this._leftSurface&&(e=e.concat(this._leftSurface)),this._rightSurface&&(e=e.concat(this._rightSurface)),this._crustSurface&&(e=e.concat(this._crustSurface)),this._sliceLabel&&e.push(this._sliceLabel),this._feelerRad&&e.push(this._feelerRad),this._feelerHoriz&&e.push(this._feelerHoriz),e}getAriaLabel(){var e,i=this._pieChart.getOptions().translations;e=null==this._seriesIndex?m.getOtherSliceDatatip(this._chart,this._value,!1):m.getDatatip(this._chart,this._seriesIndex,0,null,!1);var r=i.labelPercentage,s=W.generateSlicePercentageString(this);e+="; "+t.ResourceUtils.format(i.labelAndValue,[r,s]);var a=[];return this.isSelectable()&&a.push(i[this.isSelected()?"stateSelected":"stateUnselected"]),d.isDataItemDrillable(this._chart,this._seriesIndex,this._groupIndex)&&a.push(i.stateDrillable),t.Displayable.generateAriaLabel(e,a)}_updateAriaLabel(){var e=this.getTopDisplayable();e&&!t.Agent.deferAriaCreation()&&e.setAriaProperty("label",this.getAriaLabel())}getTopDisplayable(){return this._topSurface&&this._topSurface.length>0?this._topSurface[0]:null}isSelectable(){return this._chart.isSelectionSupported()}isSelected(){return this._selected}setSelected(e,i){if(this._selected=e,this.getTopSurface()){if(this._selected?this._pieChart.bringToFrontOfSelection(this):this._selecting||this._pieChart.pushToBackOfSelection(this),c.isSelectionHighlighted(this._chart))for(var r=this.getDisplayables(),s=0;s<r.length;s++)j._shapeIsSelectable(r[s])&&r[s].setSelected(e);if(c.isSelectionExploded(this._chart)){var a=e?1:0;if(i||"none"==c.getAnimOnDataChange(this._chart))this.setExplode(a);else{var n=new t.CustomAnimation(this._pieChart.getCtx(),this,this._pieChart.getAnimDuration()/2);n.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getExplode,this.setExplode,a),n.play()}}this._updateAriaLabel()}}showHoverEffect(){this._selecting=!0,this._pieChart.bringToFrontOfSelection(this);for(var e=this.getDisplayables(),t=0;t<e.length;t++)j._shapeIsSelectable(e[t])&&e[t].showHoverEffect()}hideHoverEffect(){this._selecting=!1,this._selected||this._pieChart.pushToBackOfSelection(this);for(var e=this.getDisplayables(),t=0;t<e.length;t++)j._shapeIsSelectable(e[t])&&e[t].hideHoverEffect()}getDatatip(e,t,i){return e==this._sliceLabel&&this._sliceLabel&&this._sliceLabel.isTruncated()?this.getSliceLabelString():this.getTooltip()}getDatatipColor(){return this.getFillColor()}getCategories(){return this._categories&&this._categories.length>0?this._categories:[this.getId().series]}getNextNavigable(e){var i=e.keyCode;if(e.type==t.MouseEvent.CLICK)return this;if(i==t.KeyboardEvent.SPACE&&e.ctrlKey)return this;var r=t.Agent.isRightToLeft(this._chart.getCtx()),s=this._pieChart.__getSlices(),a=s.indexOf(this),n=null;return i==t.KeyboardEvent.RIGHT_ARROW||i==t.KeyboardEvent.DOWN_ARROW&&!r||i==t.KeyboardEvent.UP_ARROW&&r?n=a<s.length-1?s[a+1]:s[0]:(i==t.KeyboardEvent.LEFT_ARROW||i==t.KeyboardEvent.DOWN_ARROW&&r||i==t.KeyboardEvent.UP_ARROW&&!r)&&(n=0==a?s[s.length-1]:s[a-1]),n}getKeyboardBoundingBox(e){var i=this.getDisplayables();return i[0]?i[0].getDimensions(e):new t.Rectangle(0,0,0,0)}getTargetElem(){var e=this.getDisplayables();return e[0]?e[0].getElem():null}showKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!0,this.showHoverEffect()}hideKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!1,this.hideHoverEffect()}isShowingKeyboardFocusEffect(){return this._isShowingKeyboardFocusEffect}isDragAvailable(){return!0}getDragTransferable(){return[this.getId()]}getDragFeedback(){if(this._chart.isSelectionSupported()&&this._chart.getSelectionHandler().getSelectedCount()>1){for(var e=this._chart.getSelectionHandler().getSelection(),t=[],i=0;i<e.length;i++)t=t.concat(e[i].getDisplayables());return t}return this.getDisplayables()}getExplode(){return this._explode}setExplode(e){this._explode=e,this._explodeSlice()}getCustomLabel(){return this._customLabel}getSeriesLabel(){return this._seriesLabel}getFillColor(){return this._fillColor}getFillPattern(){return this._fillPattern}getStrokeColor(){return this._strokeColor}getBorderWidth(){return this._borderWidth}getSliceGaps(){return 0==this._depth?3*c.getDataItemGaps(this._chart):0}getInnerRadius(){return this._pieChart.getInnerRadius()}getTooltip(){return null==this._seriesIndex?m.getOtherSliceDatatip(this._chart,this._value,!0):m.getDatatip(this._chart,this._seriesIndex,0,null,!0)}isDrillable(){return this._drillable}static createFillerSlice(e,t){var i=new j(e);return i._value=t,i._bFillerSlice=!0,i._centerX=e.getCenter().x,i._centerY=e.getCenter().y,i._fillColor="rgba(255,255,255,0)",i._strokeColor="rgba(255,255,255,0)",i._id=new o(null,null,null,null),i}getSeriesIndex(){return this._seriesIndex}}j.THREED_TILT=.59;class z extends t.Automation{constructor(e){super(e),this._options=this._comp.getOptions(),this._legend=this._comp.legend,this._xAxis=this._comp.xAxis,this._yAxis=this._comp.yAxis,this._y2Axis=this._comp.y2Axis,this._legendAutomation=this._legend?this._legend.getAutomation():null,this._xAxisAutomation=this._xAxis?this._xAxis.getAutomation():null,this._yAxisAutomation=this._yAxis?this._yAxis.getAutomation():null,this._y2AxisAutomation=this._y2Axis?this._y2Axis.getAutomation():null}GetSubIdForDomElement(e){var i=null;if(e.isDescendantOf(this._xAxis))return(i=this._xAxisAutomation.GetSubIdForDomElement(e))?this._convertAxisSubIdToChartSubId(i,"xAxis"):null;if(e.isDescendantOf(this._yAxis))return(i=this._yAxisAutomation.GetSubIdForDomElement(e))?this._convertAxisSubIdToChartSubId(i,"yAxis"):null;if(e.isDescendantOf(this._y2Axis))return(i=this._y2AxisAutomation.GetSubIdForDomElement(e))?this._convertAxisSubIdToChartSubId(i,"y2Axis"):null;if(e.isDescendantOf(this._legend)){var r=this._legendAutomation.GetSubIdForDomElement(e);return r?this._convertLegendSubIdToChartSubId(r):null}var s=this._comp.getEventManager().GetLogicalObject(e);if(!s)return null;if(s instanceof t.SimpleObjPeer){var a=s.getParams().type;if("pieCenterLabel"==a)return"pieCenterLabel";if("plotArea"==a)return"plotArea"}if(s instanceof j)return"dataItem["+s.getSeriesIndex()+"]";if(s instanceof f){var n=s.getSeriesIndex(),o=s.getGroupIndex();if(null!=n&&o>=0&&("funnel"!=this._options.type||"pyramid"!=this._options.type))return"dataItem["+n+"]["+o+"]";if(null!=n&&o==N._GROUP_IDX&&("funnel"==this._options.type||"pyramid"==this._options.type))return"dataItem["+n+"]";if(null!=n&&(null==o||o<0))return"series["+n+"]"}else if(s instanceof x){var l=s.getAxisType(),h=s.getIndex();return l&&h>=0?l+":referenceObject["+h+"]":null}return null}_convertLegendSubIdToChartSubId(e){var t=this._legend.getOptions(),i=this._legendAutomation.getLegendItem(t,e);if(i){for(var r=0;r<this._options.series.length;r++){if(this._options.series[r].name==i.text)return"series["+r+"]"}return"legend:"+e}return null}_convertAxisSubIdToChartSubId(e,t){if("title"==e&&t)return t+":"+e;var i=e.substring(e.indexOf("["));return i?"group"+i:null}getDomElementForSubId(e){if(e==t.Automation.TOOLTIP_SUBID)return this.GetTooltipElement(this._comp,m.isDataCursorEnabled(this._comp)?p.TOOLTIP_ID:null);if("pieCenterLabel"==e)return this._comp.pieChart.getCenterLabel().getElem();if("plotArea"==e)return this._comp.getPlotArea().getElem();var i,r,s,a=e.indexOf("["),n=e.indexOf("]"),o=e.indexOf(":");if(a>0&&n>0||o>0){var l=o<0?e.substring(0,a):e.substring(0,o);if("group"==l)return this._xAxisAutomation.getDomElementForSubId(e);if("series"==l)return e=this._convertToLegendSubId(e),this._legendAutomation.getDomElementForSubId(e);if("legend"==e.substring(0,o))return e=e.substring(o+1),this._legendAutomation.getDomElementForSubId(e);var h,g=e.substring(a+1,n);if("xAxis"==l||"yAxis"==l||"y2Axis"==l){var d=e.substring(o+1);if("title"==d){if("xAxis"==l)return this._xAxisAutomation.getDomElementForSubId(d);if("yAxis"==l)return this._yAxisAutomation.getDomElementForSubId(d);if("y2Axis"==l)return this._y2AxisAutomation.getDomElementForSubId(d)}else if(i=d.indexOf("["),r=d.indexOf("]"),"referenceObject"==d.substring(0,i)){var u=d.substring(i+1,r);if(s=this._getRefObjPeer(u))return s.getDisplayables()[0].getElem()}}if("pie"==this._options.type){var _=this._comp.pieChart.getSliceDisplayable(g);if(_)return _.getElem()}if("funnel"==this._options.type?h=N._GROUP_IDX:"pyramid"==this._options.type?h=G._GROUP_IDX:(i=(e=e.substring(n+1)).indexOf("["),r=e.indexOf("]"),i>=0&&r>=0&&(h=e.substring(i+1,r))),s=this._getChartObjPeer(g,h))return s.getDisplayables()[0].getElem()}return null}_getChartObjPeer(e,t){for(var i=this._comp.getChartObjPeers(),r=0;r<i.length;r++){var s=i[r].getSeriesIndex(),a=i[r].getGroupIndex();if(s==e&&a==t)return i[r]}return null}_getRefObjPeer(e){for(var t=this._comp.getRefObjPeers(),i=0;i<t.length;i++)if(e==t[i].getIndex())return t[i];return null}_convertToLegendSubId(e){var t=e.indexOf("["),i=e.indexOf("]"),r=e.substring(t+1,i),s=this._legend.getOptions(),a=this._options.series[r];return"section"+this._legendAutomation.getIndicesFromSeries(a,s)}getDataItem(e,t){"pie"!=this._options.type&&"funnel"!=this._options.type&&"pyramid"!=this._options.type||(t=0);var i=d.getDataItem(this._comp,e,t);return i?{borderColor:c.getBorderColor(this._comp,e,t),color:c.getColor(this._comp,e,t),label:c.getDataLabel(this._comp,e,t),targetValue:d.getTargetVal(this._comp,e,t),tooltip:m.getDatatip(this._comp,e,t,null,!1),value:d.getVal(this._comp,e,t),open:i.open,close:i.close,high:d.getHighVal(this._comp,e,t),low:d.getLowVal(this._comp,e,t),volume:i.volume,x:d.getXVal(this._comp,e,t),y:i.y,z:i.z,min:i.min,max:i.max,group:d.getGroup(this._comp,t),series:d.getSeries(this._comp,e),selected:d.isDataSelected(this._comp,e,t)}:null}getGroup(e){return d.getGroup(this._comp,e)}getSeries(e){return this._options.series[e].name}getGroupCount(){return d.getGroupCount(this._comp)}getSeriesCount(){return this._options.series.length}getTitle(){return this._options.title.text}getLegend(){var e=this._legend.__getBounds(),i=this._legend.localToStage(new t.Point(e.x,e.y));return{bounds:{x:i.x,y:i.y,width:e.w,height:e.h},title:this._legend.getOptions().title}}getPlotArea(){var e=this._comp.__getPlotAreaSpace();return{bounds:{x:e.x,y:e.y,width:e.w,height:e.h}}}getXAxis(){return this._getAxis("x")}getYAxis(){return this._getAxis("y")}getY2Axis(){return this._getAxis("y2")}_getAxis(e){var i="x"==e?this._xAxis:"y"==e?this._yAxis:this._y2Axis;if(i){var r=i.__getBounds(),s=i.localToStage(new t.Point(r.x,r.y)),a={x:s.x,y:s.y,width:r.w,height:r.h},n=this._comp;return{bounds:a,title:this._options[e+"Axis"].title,getPreferredSize:(t,r)=>{var s,a=i.getOptions(),o=a.position,l=w.getTickLabelGapSize(n,e),h=w.isStandaloneXAxis(n)||w.isStandaloneYAxis(n)||w.isStandaloneY2Axis(n)?2:0;return"top"==o||"bottom"==o?(s=i.getPreferredSize(a,t,r-l-h)).h=Math.ceil(s.h+l+h):(s=i.getPreferredSize(a,t-l-h,r)).w=Math.ceil(s.w+l+h),{width:s.w,height:s.h}}}}return null}IsTooltipElement(e){var i=e.getAttribute("id");return!(!i||0!=i.indexOf(p.TOOLTIP_ID)&&0!=i.indexOf(t.HtmlTooltipManager._TOOLTIP_DIV_ID))}}class X extends t.EventManager{constructor(e){super(e.getCtx(),e.processEvent,e,e),this._chart=e,this._dragMode=null,this._dragButtonsVisible=t.Agent.isTouchDevice(),this.panButton=null,this.zoomButton=null,this.selectButton=null,this._dataCursorHandler=null,this._panZoomHandler=null,this._marqueeZoomHandler=null,this._marqueeSelectHandler=null}addListeners(e){t.SvgDocumentUtils.addDragListeners(this._chart,this._onDragStart,this._onDragMove,this._onDragEnd,this),super.addListeners(e),t.Agent.isTouchDevice()||e.addEvtListener(t.MouseEvent.MOUSEWHEEL,this.OnMouseWheel,!1,this)}RemoveListeners(e){super.RemoveListeners(e),t.Agent.isTouchDevice()||e.removeEvtListener(t.MouseEvent.MOUSEWHEEL,this.OnMouseWheel,!1,this)}getLogicalObject(e){return this.GetLogicalObject(e,!0)}_getDragHandler(e){return e&&"user"==this._chart.getOptions().dragMode&&l.isBLAC(this._chart)&&(this._dragMode==X.DRAG_MODE_PAN||this._dragMode==X.DRAG_MODE_ZOOM)&&(this._panZoomHandler&&this._panZoomHandler.isWithinBounds(e)?this._dragMode=X.DRAG_MODE_PAN:this._dragMode=X.DRAG_MODE_ZOOM),this._dragMode==X.DRAG_MODE_PAN?this._panZoomHandler:this._dragMode==X.DRAG_MODE_ZOOM?this._marqueeZoomHandler:this._dragMode==X.DRAG_MODE_SELECT?this._marqueeSelectHandler:null}_onDragStart(e){return t.Agent.isTouchDevice()?this._onTouchDragStart(e):this._onMouseDragStart(e)}_onDragMove(e){return t.Agent.isTouchDevice()?this._onTouchDragMove(e):this._onMouseDragMove(e)}_onDragEnd(e){return t.Agent.isTouchDevice()?this._onTouchDragEnd(e):this._onMouseDragEnd(e)}_onMouseDragStart(e){var t,i=this._context.pageToStageCoords(e.pageX,e.pageY),r=this._getDragHandler(i),s=this.GetLogicalObject(e.target);return!(s&&s.isSelectable&&s.isSelectable())&&0==e.button&&r&&((t=r.processDragStart(i,e.ctrlKey))&&this._callback.call(this._callbackObj,t),this._chart.setCursor(r.getCursor(i)),this.setDragButtonsVisible(!1),this._chart!=this.getCtx().getCurrentKeyboardFocus()&&this.getCtx().setCurrentKeyboardFocus(this._chart)),!!t&&(this._dataCursorHandler&&this._dataCursorHandler.processEnd(),!0)}_onMouseDragMove(e){var t,i=this._context.pageToStageCoords(e.pageX,e.pageY),r=this._getDragHandler();r&&(t=r.processDragMove(i,e.ctrlKey))&&(this._callback.call(this._callbackObj,t),this.setDragButtonsVisible(!1)),t&&e.stopPropagation()}_onMouseDragEnd(e){var t,i=this._context.pageToStageCoords(e.pageX,e.pageY),r=this._getDragHandler();if(r){(t=r.processDragEnd(i,e.ctrlKey))&&(this._callback.call(this._callbackObj,t),this.autoToggleZoomButton()),this._chart.setCursor(r.getCursor(i));var s=this._chart.__getAxisSpace();s&&this.setDragButtonsVisible(s.containsPoint(i.x,i.y))}}OnMouseMove(e){super.OnMouseMove(e);var i=this._context.pageToStageCoords(e.pageX,e.pageY);this._dataCursorHandler&&(this.GetLogicalObjectAndDisplayable(e.target).displayable instanceof t.IconButton?this._dataCursorHandler.processEnd():this._dataCursorHandler.processMove(i));var r=this._getDragHandler(i);r?this._chart.setCursor(r.getCursor(i)):this._chart.setCursor("default")}OnMouseOut(e){super.OnMouseOut(e);var t=this._context.pageToStageCoords(e.pageX,e.pageY),i=this._chart.__getAxisSpace();i&&this.setDragButtonsVisible(i.containsPoint(t.x,t.y)),this._dataCursorHandler&&this._dataCursorHandler.processOut(t);this.GetLogicalObject(e.target)}OnMouseWheel(e){if(O.isZoomable(this._chart)){var t=null!=e.wheelDelta?e.wheelDelta:0,i=this._context.pageToStageCoords(e.pageX,e.pageY);if(this._panZoomHandler){var r=this._panZoomHandler.processMouseWheel(i,t);r&&(e.preventDefault(),e.stopPropagation(),this._callback.call(this._callbackObj,r),this._dataCursorHandler&&this._dataCursorHandler.processMove(i))}}}ShowFocusEffect(e,i){if(this._dataCursorHandler){var r=i.getDataPosition();if(r){var s=this._chart.__getPlotAreaSpace();this._dataCursorHandler.processMove(new t.Point(r.x+s.x,r.y+s.y))}}super.ShowFocusEffect(e,i)}OnBlur(e){this._dataCursorHandler&&this._dataCursorHandler.processEnd(),super.OnBlur(e)}OnClickInternal(e){var t=this.GetLogicalObject(e.target),i=this._context.pageToStageCoords(e.pageX,e.pageY);this.SeriesFocusHandler&&this.SeriesFocusHandler.processSeriesFocus(i,t),t&&(t.isSelectable&&t.isSelectable()||this.processDrillEvent(t))}OnDblClickInternal(e){var t=this.GetLogicalObject(e.target);t&&t.isSelectable&&t.isSelectable()&&this.processDrillEvent(t)}HandleTouchHoverStartInternal(e){if(this._dataCursorHandler&&!this.isTouchResponseTouchStart()){var t=this._context.pageToStageCoords(e.touch.pageX,e.touch.pageY);return this._dataCursorHandler.processMove(t),!1}var i=this.GetLogicalObject(e.target);return this.TouchManager.setTooltipEnabled(e.touch.identifier,this.getTooltipsEnabled(i)),!1}HandleTouchHoverMoveInternal(e){if(this._dataCursorHandler&&!this.isTouchResponseTouchStart()){var t=this._context.pageToStageCoords(e.touch.pageX,e.touch.pageY);return this._dataCursorHandler.processMove(t),!1}var i=this.GetLogicalObject(e.target);return this.TouchManager.setTooltipEnabled(e.touch.identifier,this.getTooltipsEnabled(i)),!1}HandleTouchHoverEndInternal(e){this.endDrag();var t=this.GetLogicalObject(e.target);t&&(t.isSelectable&&t.isSelectable()||this.processDrillEvent(t))}HandleTouchClickInternal(e){var t=this.GetLogicalObject(e.target);t&&(t.isSelectable&&t.isSelectable()||this.processDrillEvent(t))}HandleTouchDblClickInternal(e){var t=this.GetLogicalObject(e.target);t&&t.isSelectable&&t.isSelectable()&&(e.preventDefault(),e.stopPropagation(),this.processDrillEvent(t))}processDrillEvent(e){if(e&&e.isDrillable&&e.isDrillable()){var i=e.getId();if(e instanceof f)-1===e.getGroupIndex()?this.FireEvent(t.EventFactory.newChartDrillEvent(i,e.getSeries(),null,"series")):this.FireEvent(t.EventFactory.newChartDrillEvent(null!=i.id?i.id:i,e.getSeries(),e.getGroup(),"item"));else if(e instanceof j){var r="_dvtOther"===i.series?"multiSeries":"item";this.FireEvent(t.EventFactory.newChartDrillEvent(i.id,i.series,i.group,r))}}}ProcessRolloverEvent(e,i,r){var s=this._chart.getOptions();if("dim"==O.getHoverBehavior(this._chart)){var a=i.getCategories?i.getCategories():[];s.highlightedCategories=r?a.slice():null;var n=t.EventFactory.newCategoryHighlightEvent(s.highlightedCategories,r),o=c.getHoverBehaviorDelay(this._chart),l=this._chart.getObjects();this._chart.pieChart&&(l=l.concat(this._chart.pieChart.__getSlices())),this.RolloverHandler.processEvent(n,l,o,"any"==s.highlightMatch)}}_onTouchDragStart(e){var t,i,r=e.touches;if(1==r.length){var s=this._context.pageToStageCoords(r[0].pageX,r[0].pageY),a=this._getDragHandler();a?t=a.processDragStart(s,!0):this._dataCursorHandler&&this.isTouchResponseTouchStart()&&(this._dataCursorHandler.processMove(s),i=!0)}else if(2==r.length&&this._panZoomHandler&&O.isZoomable(this._chart)){this.endDrag();var n=this._context.pageToStageCoords(r[0].pageX,r[0].pageY),o=this._context.pageToStageCoords(r[1].pageX,r[1].pageY);t=this._panZoomHandler.processPinchStart(n,o)}return t&&(this._callback.call(this._callbackObj,t),this.getCtx().getTooltipManager().hideTooltip()),!(!t&&!i)&&(e.preventDefault(),e.stopPropagation(),this.setDragButtonsVisible(!1),!0)}_onTouchDragMove(e){var t,i,r=e.touches;if(1==r.length){var s=this._context.pageToStageCoords(r[0].pageX,r[0].pageY),a=this._getDragHandler();a?t=a.processDragMove(s,!0):this._dataCursorHandler&&this.isTouchResponseTouchStart()&&(this._dataCursorHandler.processMove(s),i=!0)}else if(2==r.length&&this._panZoomHandler&&O.isZoomable(this._chart)){var n=this._context.pageToStageCoords(r[0].pageX,r[0].pageY),o=this._context.pageToStageCoords(r[1].pageX,r[1].pageY);t=this._panZoomHandler.processPinchMove(n,o)}(t||i)&&e.preventDefault(),t&&(this._callback.call(this._callbackObj,t),this.getCtx().getTooltipManager().hideTooltip())}_onTouchDragEnd(e){var t,i=this.endDrag();if(this._panZoomHandler&&O.isZoomable(this._chart)&&(t=this._panZoomHandler.processPinchEnd())&&this._callback.call(this._callbackObj,t),i||t){e.preventDefault(),this.getCtx().getTooltipManager().hideTooltip();var r=this.getTouchManager(),s=1==e.changedTouches.length?e.changedTouches[0].identifier:null,a=null!=s?r.getTouchInfo(s):null;a&&!a.touchMoved||r.reset()}this.setDragButtonsVisible(!0)}endDrag(){var e,t=this._getDragHandler();return t&&(e=t.processDragEnd(null,!0)),this._dataCursorHandler&&this._dataCursorHandler.processEnd(),e&&this._callback.call(this._callbackObj,e),e}zoomBy(e){if(this._panZoomHandler&&O.isZoomable(this._chart)){var t=this._panZoomHandler.zoomBy(e);t&&this._callback.call(this._callbackObj,t)}}panBy(e,t){if(this._panZoomHandler&&O.isScrollable(this._chart)){var i=this._panZoomHandler.panBy(e,t);i&&this._callback.call(this._callbackObj,i)}}hideHoverFeedback(){this.hideTooltip(),this._dataCursorHandler&&this._dataCursorHandler.processEnd()}hideTooltip(){this._dataCursorHandler&&this._dataCursorHandler.isDataCursorShown()||super.hideTooltip()}getTooltipsEnabled(e){return(!this._dataCursorHandler||!(e instanceof f||e instanceof x||this._dataCursorHandler.isDataCursorShown()))&&super.getTooltipsEnabled()}getDataCursorHandler(){return this._dataCursorHandler}setDataCursorHandler(e){this._dataCursorHandler=e}setPanZoomHandler(e){this._panZoomHandler=e}setMarqueeZoomHandler(e){this._marqueeZoomHandler=e}setMarqueeSelectHandler(e){this._marqueeSelectHandler=e}getMarqueeGlassPane(){return this._dragMode==X.DRAG_MODE_ZOOM?this._marqueeZoomHandler.getGlassPane():this._dragMode==X.DRAG_MODE_SELECT?this._marqueeSelectHandler.getGlassPane():null}cancelMarquee(e){this._dragMode==X.DRAG_MODE_ZOOM?this._marqueeZoomHandler.cancelMarquee()&&e.preventDefault():this._dragMode==X.DRAG_MODE_SELECT&&this._marqueeSelectHandler&&this._marqueeSelectHandler.cancelMarquee()&&this._chart.render()}getDragMode(){return this._dragMode}setDragMode(e){this._dragMode=null==e?this._getDefaultDragMode():e,!this._chart.xAxis.isFullViewport()||this._chart.yAxis&&!this._chart.yAxis.isFullViewport()||this.autoToggleZoomButton()}_getDefaultDragMode(){return t.Agent.isTouchDevice()?X.DRAG_MODE_OFF:O.isScrollable(this._chart)?X.DRAG_MODE_PAN:"multiple"==this._chart.getOptions().selectionMode?X.DRAG_MODE_SELECT:null}onZoomButtonClick(e){this.zoomButton.isToggled()?(this.selectButton&&this.selectButton.setToggled(!1),this.setDragMode(X.DRAG_MODE_ZOOM)):this.setDragMode(null)}onPanButtonClick(e){this.panButton.isToggled()?(this.selectButton&&this.selectButton.setToggled(!1),this.setDragMode(X.DRAG_MODE_PAN)):this.setDragMode(null)}onSelectButtonClick(e){this.selectButton.isToggled()?(this.zoomButton&&this.zoomButton.setToggled(!1),this.panButton&&this.panButton.setToggled(!1),this.setDragMode(X.DRAG_MODE_SELECT)):this.setDragMode(null)}setDragButtonsVisible(e){e&&!this._dragButtonsVisible?(this._chart.showDragButtons(),this._dragButtonsVisible=!0):!e&&this._dragButtonsVisible&&(this._chart.hideDragButtons(),this._dragButtonsVisible=!1)}areDragButtonsVisible(){return this._dragButtonsVisible}autoToggleZoomButton(){!t.Agent.isTouchDevice()&&this.zoomButton&&(this._chart.xAxis.isFullViewport()&&this._chart.yAxis.isFullViewport()?this._dragMode==X.DRAG_MODE_PAN&&(this.zoomButton.setToggled(!0),this.onZoomButtonClick(null)):this._dragMode==X.DRAG_MODE_ZOOM&&(this.zoomButton.setToggled(!1),this.onZoomButtonClick(null)))}GetTouchResponse(){return this._dragMode&&this._dragMode!=X.DRAG_MODE_OFF?t.EventManager.TOUCH_RESPONSE_TOUCH_HOLD:this._chart.getOptions().touchResponse}isDndSupported(){return!0}GetDragSourceType(){var e=this.DragSource.getDragObject();return e instanceof f&&e.getSeriesIndex()>=0&&e.getGroupIndex()>=0||e instanceof j?"items":null}GetDragDataContexts(e){if(this._chart.isSelectionSupported()&&this._chart.getSelectionHandler().getSelectedCount()>1){for(var i=this._chart.getSelectionHandler().getSelection(),r=[],s=0;s<i.length;s++){var a=c.getDataContext(this._chart,i[s].getSeriesIndex(),i[s].getGroupIndex(),i[s].getNestedDataItemIndex());e&&t.ToolkitUtils.cleanDragDataContext(a),r.push(a)}return r}var n=this.DragSource.getDragObject(),o=null;return n instanceof f&&(o=c.getDataContext(this._chart,n.getSeriesIndex(),n.getGroupIndex(),n.getNestedDataItemIndex())),n instanceof j&&(o=c.getDataContext(this._chart,n.getSeriesIndex(),0)),o&&e&&t.ToolkitUtils.cleanDragDataContext(o),o?[o]:null}GetDropOffset(e){var i=this.DragSource.getDragObject();if(i instanceof f){var r=i.getDataPosition();if(r){r=this._chart.getPlotArea().localToStage(r);var s=this._context.pageToStageCoords(e.pageX,e.pageY);return new t.Point(r.x-s.x,r.y-s.y)}}return null}GetDropTargetType(e){var t=this._context.pageToStageCoords(e.pageX,e.pageY),i=this._chart.getOptions().dnd.drop,r=this._chart.__getPlotAreaSpace();return Object.keys(i.plotArea).length>0&&r.containsPoint(t.x,t.y)?"plotArea":Object.keys(i.xAxis).length>0&&w.isAxisRendered(this._chart,"x")&&w.axisContainsPoint(this._chart.xAxis,t)?"xAxis":Object.keys(i.yAxis).length>0&&w.isAxisRendered(this._chart,"y")&&w.axisContainsPoint(this._chart.yAxis,t)?"yAxis":Object.keys(i.y2Axis).length>0&&w.isAxisRendered(this._chart,"y2")&&w.axisContainsPoint(this._chart.y2Axis,t)?"y2Axis":null}GetDropEventPayload(e){var i=e.getNativeEvent().dataTransfer,r=Number(i.getData(t.EventManager.DROP_OFFSET_X_DATA_TYPE))||0,s=Number(i.getData(t.EventManager.DROP_OFFSET_Y_DATA_TYPE))||0,a=this._context.pageToStageCoords(e.pageX,e.pageY);return this._chart.getValsAt(a.x+r,a.y+s)}ShowDropEffect(e){var t=this._getDropObject(e);t&&(t.setClassName("oj-active-drop"),t.setSolidFill(this._chart.getOptions()._dropColor))}ClearDropEffect(){var e=this._chart.getCache().getFromCache("plotAreaBackground");if(e){var i=c.getBackgroundColor(this._chart);i?e.setSolidFill(i):e.setInvisibleFill(),t.ToolkitUtils.removeClassName(e.getElem(),"oj-invalid-drop"),t.ToolkitUtils.removeClassName(e.getElem(),"oj-active-drop")}var r=e=>{if(e){var i=e.getCache().getFromCache("background");i&&(i.setInvisibleFill(),t.ToolkitUtils.removeClassName(i.getElem(),"oj-invalid-drop"),t.ToolkitUtils.removeClassName(i.getElem(),"oj-active-drop"))}};r(this._chart.xAxis),r(this._chart.yAxis),r(this._chart.y2Axis)}ShowRejectedDropEffect(e){var t=this._getDropObject(e);t&&t.setClassName("oj-invalid-drop")}_getDropObject(e){var t,i=this.GetDropTargetType(e);return"plotArea"==i?t=this._chart.getCache().getFromCache("plotAreaBackground"):"xAxis"==i?t=this._chart.xAxis.getCache().getFromCache("background"):"yAxis"==i?t=this._chart.yAxis.getCache().getFromCache("background"):"y2Axis"==i&&(t=this._chart.y2Axis.getCache().getFromCache("background")),t}}X.DRAG_MODE_PAN="pan",X.DRAG_MODE_ZOOM="zoom",X.DRAG_MODE_SELECT="select",X.DRAG_MODE_OFF="off";class Z extends t.KeyboardHandler{constructor(e,t){super(e),this._chart=t}isSelectionEvent(e){return this.isNavigationEvent(e)&&!e.ctrlKey}isMultiSelectEvent(e){return e.keyCode==t.KeyboardEvent.SPACE&&e.ctrlKey}processKeyDown(e){var i=e.keyCode;if(i==t.KeyboardEvent.TAB){if(s=this._eventManager.getFocus())return t.EventManager.consumeEvent(e),s;var r=F.getKeyboardNavigables(this._chart);if(r.length>0)return t.EventManager.consumeEvent(e),this.getDefaultNavigable(r)}else if(i==t.KeyboardEvent.ENTER){var s;if(s=this._eventManager.getFocus())return this._eventManager.processDrillEvent(s),t.EventManager.consumeEvent(e),s}else i==t.KeyboardEvent.ESCAPE?this._eventManager.cancelMarquee(e):i==t.KeyboardEvent.PAGE_UP?((e.ctrlKey||e.shiftKey||l.isBLAC(this._chart))&&l.isVertical(this._chart)?this._eventManager.panBy(-.25,0):this._eventManager.panBy(0,-.25),t.EventManager.consumeEvent(e)):i==t.KeyboardEvent.PAGE_DOWN?((e.ctrlKey||e.shiftKey||l.isBLAC(this._chart))&&l.isVertical(this._chart)?this._eventManager.panBy(.25,0):this._eventManager.panBy(0,.25),t.EventManager.consumeEvent(e)):t.KeyboardEvent.isEquals(e)||t.KeyboardEvent.isPlus(e)?this._eventManager.zoomBy(1.5):(t.KeyboardEvent.isMinus(e)||t.KeyboardEvent.isUnderscore(e))&&this._eventManager.zoomBy(1/1.5);return super.processKeyDown(e)}getDefaultNavigable(e){if(!e||e.length<=0)return null;for(var t,i,r,s,a=l.isPie(this._chart),n=0;n<e.length;n++)s=e[n],!t||s.getSeriesIndex()<i?(t=s,i=s.getSeriesIndex(),a||(r=s.getGroupIndex())):!a&&s.getGroupIndex()<r&&(t=s,i=s.getSeriesIndex(),r=s.getGroupIndex());return t}}class K{constructor(e,t,i){this._peer=e,this._updateDuration=.75*t,this._insertDuration=.5*t,this._deleteDuration=.5*t,this._shape=e.getDisplayables()[0],this._animId=e.getDataItemId()||e.getSeries()+"/"+e.getGroup()+i}animateUpdate(e,t){var i=t._shape;this._shape&&this._shape.getUpdateAnim&&e.add(this._shape.getUpdateAnim(this._updateDuration,i),1)}animateInsert(e){if(this._shape&&this._shape.getInsertAnim)e.add(this._shape.getInsertAnim(this._insertDuration),2);else{var i=new t.AnimFadeIn(this._shape.getCtx(),this._shape,this._insertDuration);e.add(i,0)}}animateDelete(e,i){if(i.addChild(this._shape),this._shape&&this._shape.getDeleteAnim)e.add(this._shape.getDeleteAnim(this._deleteDuration),0);else{var r=new t.AnimFadeOut(this._shape.getCtx(),this._shape,this._deleteDuration);e.add(r,0)}}getId(){return this._animId}setId(e){this._animId=e}setOldChart(e){this._oldChart=e}}const q={DIR_UP:0,DIR_DOWN:1,DIR_NOCHANGE:2,makeIndicator:(e,t,i,r,s,a)=>{if(l.isPolar(r))return null;var n=q.getDirection(e,t,i,r,s,a);if(n==q.DIR_NOCHANGE)return null;var o=n===q.DIR_DOWN,h=o?c.getAnimDownColor(r):c.getAnimUpColor(r),g=q._drawIndicator(r.getCtx(),o,l.isHorizontal(r),h);return r.getPlotArea().addChild(g),g},getDirection:(e,t,i,r,s,a)=>{var n=d.getVal(e,t,i),o=d.getVal(r,s,a);return null==o||null==n||o==n?q.DIR_NOCHANGE:o>n?q.DIR_UP:q.DIR_DOWN},_drawIndicator:(e,i,r,s)=>{var a;r?a=(t.Agent.isRightToLeft(e)?!i:i)?"M3.5,-5L3.5,5L-3.5,0L3.5,-5":"M-3.5,-5L-3.5,5L3.5,0L-3.5,-5":a=i?"M-5,-3.5L5,-3.5L0,3.5L-5,-3.5Z":"M-5,3.5L5,3.5L0,-3.5L-5,3.5Z";var n=i?"oj-chart-animation-down":"oj-chart-animation-up",o=new t.Path(e,a);return o.setClassName(n),o.setStyle({fill:s}),o}};class Q extends K{constructor(e,t,i){super(e,t,i),this._indicator=null}animateInsert(e){var t=this._shape.getInsertAnim(this._insertDuration);e.add(t,2)}animateDelete(e,t){t.addChild(this._shape);var i=this._shape.getDeleteAnim(this._deleteDuration);e.add(i,0)}animateUpdate(e,i){var r=this._oldChart,s=this._peer.getChart(),a=l.isHorizontal(r)!=l.isHorizontal(s),n=i._getAnimParams(a),o=this._getAnimParams(),h=i._shape.getPrimaryFill(),g=this._shape.getPrimaryFill(),d=i._shape.isSelected()||this._shape.isSelected()||h.equals(g);if(!t.ArrayUtils.equals(n,o)||!h.equals(g)){var u=this._peer.getSeriesIndex(),_=i._peer.getSeriesIndex(),p=this._peer.getGroupIndex(),v=i._peer.getGroupIndex();"none"!==c.getAnimIndicators(s)&&(this._indicator=q.makeIndicator(r,_,v,s,u,p)),this._setAnimParams(n),d||this._shape.setFill(h);var m=new t.CustomAnimation(this._shape.getCtx(),this,this._updateDuration);m.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimParams,this._setAnimParams,o),d||m.getAnimator().addProp(t.Animator.TYPE_FILL,this._shape,this._shape.getFill,this._shape.setFill,g),this._indicator&&(m.setOnEnd(this._onEndAnim,this),this._indicator.setAlpha(0)),e.add(m,1)}}_getAnimParams(e){return this._shape.getAnimParams(e)}_setAnimParams(e){this._shape.setAnimParams(e,this._indicator)}_onEndAnim(){this._indicator&&(this._indicator.getParent().removeChild(this._indicator),this._indicator=null)}}class J extends K{animateUpdate(e,i){var r=this._shape,s=i._shape.getAnimParams(),a=r.getAnimParams(),n=i._shape.getFill(),o=this._shape.getFill();if(!t.ArrayUtils.equals(s,a)||!n.equals(o)){r.setAnimParams(s);var l=new t.CustomAnimation(r.getCtx(),this,this._updateDuration);l.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,r,r.getAnimParams,r.setAnimParams,a),n.equals(o)||(this._shape.setFill(n),l.getAnimator().addProp(t.Animator.TYPE_FILL,r,r.getFill,r.setFill,o)),this._indicator&&l.setOnEnd(this._onEndAnim,this),e.add(l,1)}}animateInsert(e){var i=this._shape,r=i.getAnimParams(),s=r.slice(0);s[0]+=s[1]/2,s[1]=0,s[3]=0,i.setAnimParams(s);var a=new t.CustomAnimation(i.getCtx(),this,this._insertDuration);a.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimParams,i.setAnimParams,r),e.add(a,2)}animateDelete(e,i){var r=this._shape;i.setClipPath(null),i.addChild(r);var s=r.getAnimParams(),a=s.slice(0);a[0]+=s[1]/2,a[1]=0,a[3]=0;var n=new t.CustomAnimation(r.getCtx(),this,this._deleteDuration);n.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,r,r.getAnimParams,r.setAnimParams,a),e.add(n,0)}}class $ extends K{constructor(e,t){super(e,t,""),this._context=this._shape.getCtx(),this._chart=this._peer.getChart(),this._animId+="/"+(this._shape.isArea()?"area":"line")}animateUpdate(e,i){this._baseCoords=this._shape.getBaseCoords(),this._coords=this._shape.getCoords();var r,s,a=this._shape.isArea(),n=this._oldChart,o=this._chart,l=this._peer.getSeriesIndex(),h=i._peer.getSeriesIndex(),g=this._shape.getCommonGroupIndices(i._shape),u=i._shape.getCommonGroupIndices(this._shape);if(a){var _=i._getBaseAnimParams(this._shape),p=this._getBaseAnimParams(i._shape);$._matchGroupIndices(_,p),t.ArrayUtils.equals(_,p)||(this._setBaseAnimParams(_),(r=new t.CustomAnimation(this._context,this,this._updateDuration)).getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getBaseAnimParams,this._setBaseAnimParams,p))}var v=i._getAnimParams(this._shape),m=this._getAnimParams(i._shape);$._matchGroupIndices(v,m),t.ArrayUtils.equals(v,m)||(this._setAnimParams(v),(s=new t.CustomAnimation(this._context,this,this._updateDuration)).getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimParams,this._setAnimParams,m));var f=d.getSeriesType(this._peer.getChart(),l);if("none"!==c.getAnimIndicators(o)&&(!a||"lineWithArea"!=f))for(var x,C,S=0;S<g.length;S++)x=q.getDirection(n,h,u[S],o,l,g[S]),(C=q.makeIndicator(n,h,u[S],o,l,g[S]))&&this._shape.addIndicator(g[S],x,C);if(r||s){var A=new t.ParallelPlayable(this._context,r,s);A.setOnEnd(this._onAnimEnd,this),e.add(A,1)}}animateInsert(e){this._shape.setAlpha(0);var i=new t.AnimFadeIn(this._context,this._shape,this._insertDuration);e.add(i,2)}animateDelete(e,i){var r;if("area"==d.getSeriesType(this._oldChart,this._peer.getSeriesIndex())){var s=this._chart.__getAreaContainer();if(this._deletedAreas=this._shape.getParent().getParent(),!s)return;s.addChild(this._deletedAreas),(r=new t.AnimFadeOut(this._context,this._deletedAreas,this._deleteDuration)).setOnEnd(this._removeDeletedAreas,this),e.add(r,0)}else i.addChild(this._shape),r=new t.AnimFadeOut(this._context,this._shape,this._deleteDuration),e.add(r,0)}_removeDeletedAreas(){var e=this._chart.__getAreaContainer();e&&e.removeChild(this._deletedAreas)}_getAnimParams(e){return this._shape.getAnimParams(e)}_setAnimParams(e){this._shape.setAnimParams(e)}_getBaseAnimParams(e){return this._shape.getBaseAnimParams(e)}_setBaseAnimParams(e){this._shape.setBaseAnimParams(e)}_onAnimEnd(){this._shape.removeIndicators(),this._shape.setCoords(this._coords,this._baseCoords)}static _matchGroupIndices(e,t){for(var i=3;i<e.length;i+=4)e[i]=t[i]}}class ee extends K{animateUpdate(e,i){var r=i._shape.getCenterDimensions(),s=this._shape.getCenterDimensions();if(!s.equals(r)){this._shape.setCenterDimensions(r);var a=new t.CustomAnimation(this._shape.getCtx(),this,this._updateDuration);a.getAnimator().addProp(t.Animator.TYPE_RECTANGLE,this._shape,this._shape.getCenterDimensions,this._shape.setCenterDimensions,s);var n=this._peer.getChart();if(this.isValueChange(i)&&"none"!=c.getAnimIndicators(n)&&l.isScatterBubble(n)){var o=i._shape;o.setAlpha(.9),o.setClassName("oj-chart-animation-marker"),o.setCenterDimensions(r),this._peer.getChart().getPlotArea().addChild(o),a.getAnimator().addProp(t.Animator.TYPE_RECTANGLE,o,o.getCenterDimensions,o.setCenterDimensions,s),a.getAnimator().addProp(t.Animator.TYPE_NUMBER,o,o.getAlpha,o.setAlpha,0),this._overlay=o,a.setOnEnd(this._onEndAnim,this)}e.add(a,1)}}animateInsert(e){this._shape.setAlpha(0);var i=new t.AnimFadeIn(this._shape.getCtx(),this._shape,this._insertDuration);e.add(i,2)}animateDelete(e,i){i.addChild(this._shape);var r=new t.AnimFadeOut(this._shape.getCtx(),this._shape,this._deleteDuration);e.add(r,0)}isValueChange(e){var t=!1;if(e){var i=e._peer.getSeriesIndex(),r=e._peer.getGroupIndex(),s=this._peer.getSeriesIndex(),a=this._peer.getGroupIndex(),n=e._oldChart.getOptions(),o=this._peer.getChart().getOptions(),l=n.series[i].items[r].x,h=n.series[i].items[r].y,g=n.series[i].items[r].z,d=o.series[s].items[a].x,u=o.series[s].items[a].y,_=o.series[s].items[a].z;t=d!==l||u!==h||_!==g}return t}_onEndAnim(){this._overlay&&(this._peer.getChart().getPlotArea().removeChild(this._overlay),this._overlay=null)}}class te extends K{animateUpdate(e,i){var r=this._shape,s=i._shape.getAnimParams(),a=r.getAnimParams(),n=i._shape.getPrimaryFill(),o=this._shape.getPrimaryFill();if(!t.ArrayUtils.equals(s,a)||!n.equals(o)){r.setAnimParams(s);var l=new t.CustomAnimation(r.getCtx(),this,this._updateDuration);l.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,r,r.getAnimParams,r.setAnimParams,a),n.equals(o)||(this._shape.setFill(n),l.getAnimator().addProp(t.Animator.TYPE_FILL,r,r.getFill,r.setFill,o)),e.add(l,1)}}animateInsert(e){var i=this._shape,r=i.getAnimParams(),s=r.slice(0);s[1]=0,s[2]=0,i.setAnimParams(s);var a=new t.CustomAnimation(i.getCtx(),this,this._insertDuration);a.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimParams,i.setAnimParams,r),e.add(a,2)}animateDelete(e,i){var r=this._shape;i.setClipPath(null),i.addChild(r);var s=r.getAnimParams().slice(0);s[1]=0,s[2]=0;var a=new t.CustomAnimation(r.getCtx(),this,this._deleteDuration);a.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,r,r.getAnimParams,r.setAnimParams,s),e.add(a,0)}}class ie extends K{animateInsert(e){this._shape.setAlpha(0);var i=new t.AnimFadeIn(this._shape.getCtx(),this._shape,this._insertDuration);e.add(i,2)}animateDelete(e,i){i.addChild(this._shape);var r=new t.AnimFadeOut(this._shape.getCtx(),this._shape,this._deleteDuration);e.add(r,0)}animateUpdate(e,i){var r=i._shape.getAnimParams(),s=this._shape.getAnimParams();this._shape.setAnimParams(r);var a=new t.CustomAnimation(this._shape.getCtx(),this,this._updateDuration);a.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._shape,this._shape.getAnimParams,this._shape.setAnimParams,s),e.add(a,1)}}class re extends t.Polygon{constructor(e,t,i,r){let s,a,n,o,l;t&&(a=Math.min(t[0],t[4]),n=Math.max(t[0],t[4]),o=Math.min(t[1],t[5]),l=Math.max(t[1],t[5]),s=[a,o,n,o,n,l,a,l]),super(e,s,i,r),this._x1=a,this._x2=n,this._y1=o,this._y2=l}setStyleProperties(e,i,r,s,a,n,o){this._fill=e,this._borderStroke=i,this._hoverColor=t.SelectionEffectUtils.getHoverBorderColor(r),this._innerColor=s,this._outerColor=a,this._shapeClassName=n,this._shapeStyle=o,this.setStyle(o).setClassName(n),this.setFill(e),i&&this.setStroke(i)}setAnimParams(e){this._x1=Math.min(e[0],e[4]),this._x2=Math.max(e[0],e[4]),this._y1=Math.min(e[1],e[5]),this._y2=Math.max(e[1],e[5]),this.setPoints(e),this._initializeSelectionEffects()}showHoverEffect(){if(!this.IsShowingHoverEffect)if(this.IsShowingHoverEffect=!0,"redwood"===this.getCtx().getThemeBehavior()){if(!this.isSelected()){var e=this.getFill().getColor();this._showNestedBorders(e,this._innerColor)}}else this._showNestedBorders(this._hoverColor,this._innerColor)}hideHoverEffect(){this.IsShowingHoverEffect&&(this.IsShowingHoverEffect=!1,"redwood"===this.getCtx().getThemeBehavior()?this.isSelected()||this._showNestedBorders():this.isSelected()?this._showNestedBorders(this._outerColor,this._innerColor):this._showNestedBorders())}setSelected(e){if(this.IsSelected!=e)if(this.IsSelected=e,"redwood"===this.getCtx().getThemeBehavior()){var t=this.getPrimaryFill().getColor();this.isSelected()?this._showNestedBorders(this._outerColor,this._innerColor):this.isHoverEffectShown()?this._showNestedBorders(t,this._innerColor):this._showNestedBorders()}else this.isHoverEffectShown()?this._showNestedBorders(this._hoverColor,this._innerColor):this.isSelected()?this._showNestedBorders(this._outerColor,this._innerColor):this._showNestedBorders()}UpdateSelectionEffect(){}getPrimaryFill(){return this._fill}_initializeSelectionEffects(){var e=this.isSelected()?re.OUTER_BORDER_WIDTH:re.OUTER_BORDER_WIDTH_HOVER,i=this._createPointsArray(e),r=this._createPointsArray(e+re.INNER_BORDER_WIDTH);if(this.OuterChild)return this.OuterChild.setPoints(i),void this.InnerChild.setPoints(r);this.OuterChild=new t.Polygon(this.getCtx(),i),this.OuterChild.setInvisibleFill(),this.OuterChild.setMouseEnabled(!0),this.addChild(this.OuterChild),this.InnerChild=new t.Polygon(this.getCtx(),r),this.InnerChild.setInvisibleFill(),this.InnerChild.setMouseEnabled(!0),this.addChild(this.InnerChild)}_showNestedBorders(e,t){this._initializeSelectionEffects(),t?(this.setSolidFill(e),this.setStroke(null),this.setClassName().setStyle(),this.OuterChild.setSolidFill(t),this.OuterChild.setClassName().setStyle(),this.InnerChild.setFill(this._fill),this.InnerChild.setClassName(this._shapeClassName).setStyle(this._shapeStyle)):e?(this.setSolidFill(e),this.setStroke(null),this.setClassName().setStyle(),this.OuterChild.setFill(this._fill),this.OuterChild.setClassName(this._shapeClassName).setStyle(this._shapeStyle),this.InnerChild.setInvisibleFill(),this.InnerChild.setClassName().setStyle()):(this.setFill(this._fill),this.setStroke(this._borderStroke),this.setClassName(this._shapeClassName).setStyle(this._shapeStyle),this.OuterChild.setInvisibleFill(),this.OuterChild.setClassName().setStyle(),this.InnerChild.setInvisibleFill(),this.InnerChild.setClassName().setStyle())}_createPointsArray(e){var t=this._x1+e,i=this._x2-e,r=this._y1+e,s=this._y2-e;return[t,r,i,r,i,s,t,s]}}re.OUTER_BORDER_WIDTH=2,re.OUTER_BORDER_WIDTH_HOVER=1.25,re.INNER_BORDER_WIDTH=1;class se extends re{constructor(e,t,i,r,s,a,n){super(e.getCtx(),null,null,n),this._MAX_GAP_SIZE=2,this._MIN_BAR_LENGTH_FOR_GAPS=5,this._INDICATOR_OFFSET=8,this._MIN_BAR_WIDTH_FOR_GAPS_PIXEL_HINTING=15,this._bHoriz=l.isHorizontal(e),this._bStacked=d.isStacked(e),this._barGapRatio=R.getBarGapRatio(e),this._dataItemGaps=c.getDataItemGaps(e),this._axisCoord=t,this._doNotRender=!!n,this._setBarCoords(i,r,s,a,!0)}setSelected(e){if(this.IsSelected!=e){if(this.IsSelected=e,"redwood"===this.getCtx().getThemeBehavior())var t=this.getPrimaryFill().getColor();else t=this._hoverColor;this.isSelected()?(this._tempX1=this._x1,this._tempX2=this._x2,this._tempBaselineCoord=this._baselineCoord,this._x1=this._origX1,this._x2=this._origX2,this._baselineCoord=this._origBaselineCoord,this.setPoints(this._createPointsArray()),"redwood"===this.getCtx().getThemeBehavior()?this._showNestedBorders(this._outerColor,this._innerColor):this._showNestedBorders(this.isHoverEffectShown()?t:this._outerColor,this._innerColor)):(this._x1=this._tempX1,this._x2=this._tempX2,this._baselineCoord=this._tempBaselineCoord,this.setPoints(this._createPointsArray()),"redwood"===this.getCtx().getThemeBehavior()?this.isHoverEffectShown()?this._showNestedBorders(t,this._innerColor):this._showNestedBorders(null):this._showNestedBorders(this.isHoverEffectShown()?t:null))}}getAnimParams(e){return e?this._bHoriz?[this._x2,this._x1,this._baselineCoord,this._endCoord]:[this._x1,this._x2,this._endCoord,this._baselineCoord]:[this._baselineCoord,this._endCoord,this._x1,this._x2]}setAnimParams(e,t){if(this._setBarCoords(e[0],e[1],e[2],e[3],!1),t){var i=this.getIndicatorPos();t.setTranslate(i.x,i.y),t.setAlpha(1),t.getParent().addChild(t)}}getDisplayAnim(e){var i=this.getAnimParams();this.setAnimParams([this._axisCoord,this._axisCoord,this._x1,this._x2]);var r=new t.CustomAnimation(this.getCtx(),this,e);return r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.getAnimParams,this.setAnimParams,i),r}getDeleteAnim(e){var i=[this._baselineCoord,this._baselineCoord,this._x1,this._x2],r=new t.CustomAnimation(this.getCtx(),this,e);return r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.getAnimParams,this.setAnimParams,i),r.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,0),r}getInsertAnim(e){this.setAlpha(0);var i=this.getDisplayAnim(e);return i.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,1),i}getIndicatorPos(){var e,i,r=(this._x1+this._x2)/2;if(this._bStacked){var s=(this._endCoord+this._baselineCoord)/2;e=this._bHoriz?s:r,i=this._bHoriz?r:s}else{var a=this._endCoord>=this._baselineCoord?this._endCoord+this._INDICATOR_OFFSET:this._endCoord-this._INDICATOR_OFFSET;e=this._bHoriz?a:r,i=this._bHoriz?r:a}return new t.Point(e,i)}_setBarCoords(e,i,r,s,a){this._baselineCoord=e,this._endCoord=i,this._x1=r,this._x2=s;var n=this._x2-this._x1;if(n<1&&(this._x1=Math.floor(this._x1),this._x2=this._x1+1,n=1),this._origX1=this._x1,this._origX2=this._x2,this._origBaselineCoord=this._baselineCoord,this._origSize=this._x2-this._x1,this._dataItemGaps>0&&a&&!this.isSelected()){var o=Math.ceil(this._MAX_GAP_SIZE*this._dataItemGaps),l=Math.abs(this._baselineCoord-this._endCoord),h=this._axisCoord==this._baselineCoord;l>=this._MIN_BAR_LENGTH_FOR_GAPS&&this._bStacked&&!h&&(this._baselineCoord+=this._endCoord>this._baselineCoord?o:-o),n>=se._MIN_BAR_WIDTH_FOR_GAPS&&(1==t.Agent.getDevicePixelRatio()&&this._barGapRatio>0&&n>this._MIN_BAR_WIDTH_FOR_GAPS_PIXEL_HINTING?("firefox"===t.Agent.browser||this._doNotRender||this.setPixelHinting(!0),this._x1=Math.round(this._x1),this._x2=Math.round(this._x2),this._origX1=this._x1,this._origX2=this._x2,this._x2-=o):(this._x1+=o/2,this._x2-=o/2),this._origSize-=o)}if(!this._doNotRender){var g=this._createPointsArray();this.setPoints(g),this.OuterChild&&this.OuterChild.setPoints(this._createPointsArray(re.OUTER_BORDER_WIDTH)),this.InnerChild&&this.InnerChild.setPoints(this._createPointsArray(re.OUTER_BORDER_WIDTH+re.INNER_BORDER_WIDTH))}}_createPointsArray(e){var t=this._baselineCoord,i=this._endCoord,r=this._x1,s=this._x2;if(e>0){if(Math.abs(r-s)<2*e||Math.abs(t-i)<2*e)return[];r+=e,s-=e,i<t?(t-=e,i+=e):(t+=e,i-=e)}return this._bHoriz?[i,r,i,s,t,s,t,r]:[r,i,s,i,s,t,r,t]}getBoundingBox(){var e=Math.min(this._x2,this._x1),i=Math.min(this._endCoord,this._baselineCoord),r=Math.abs(this._x2-this._x1),s=Math.abs(this._endCoord-this._baselineCoord);return this._bHoriz?new t.Rectangle(i,e,s,r):new t.Rectangle(e,i,r,s)}getOriginalBarSize(){return this._origSize}getDimensionsSelf(e){return this.ConvertCoordSpaceRect(this.getBoundingBox(),e)}}se._MIN_BAR_WIDTH_FOR_GAPS=5;class ae extends t.Shape{constructor(e,i,r,s,a,n,o,h,g){super(e.getCtx()),this._chart=e,this._bHoriz=l.isHorizontal(e),this._styleOptions=g,this._innerColor=c.getSelectedInnerColor(this._chart),this._outerColor=c.getSelectedOuterColor(this._chart),this._hoverColor=t.SelectionEffectUtils.getHoverBorderColor(this._styleOptions._color);var d=i-r/2,u=i+r/2;c.getDataItemGaps(e)>0&&r>se._MIN_BAR_WIDTH_FOR_GAPS&&u--,this._render(d,u,s,a,n,o,h)}_render(e,i,r,s,a,n,o){this._cleanUp();var l=this.getCtx();this._x1=Math.round(e),this._x2=Math.round(i),this._low=Math.round(r),this._q1=Math.round(s),this._q2=Math.round(a),this._q3=Math.round(n),this._high=Math.round(o);var h=i-e,g=c.getSizeInPixels(this._styleOptions.whiskerEndLength,h);g=Math.min(h,g),g=2*Math.floor((g-1)/2)+1;var d=Math.floor((e+i)/2)+.5,u=d-Math.floor(g/2)-.5,_=d+Math.floor(g/2)+.5;this._drawLine(d,this._low,d,this._high,"whisker"),this._drawLine(u,this._low,_,this._low,"whiskerEnd"),this._drawLine(u,this._high,_,this._high,"whiskerEnd"),this._q2Box=new t.Polygon(l,this._createQ2PointsArray(0));var p=k.getRectangleFill(this._chart,this._styleOptions.q2Color,this._styleOptions._q2Pattern,h);this._q2Box.setFill(p),this._applyCustomStyle(this._q2Box,"q2"),this.addChild(this._q2Box),this._q3Box=new t.Polygon(l,this._createQ3PointsArray(0));var v=k.getRectangleFill(this._chart,this._styleOptions.q3Color,this._styleOptions._q3Pattern,h);this._q3Box.setFill(v),this._applyCustomStyle(this._q3Box,"q3"),this.addChild(this._q3Box),this._drawMedianLine(0),this._borderColor=this._styleOptions.borderColor,this._borderColor&&(this._borderWidth=this._styleOptions.borderWidth,this._drawBorders(this._borderColor,this._borderWidth)),this.IsSelected&&(this.IsSelected=!1,this.setSelected(!0))}showHoverEffect(){this.IsShowingHoverEffect||(this.IsShowingHoverEffect=!0,this.isSelected()?"redwood"!==this.getCtx().getThemeBehavior()&&this._drawBorders(this._hoverColor,re.OUTER_BORDER_WIDTH,this._innerColor,re.INNER_BORDER_WIDTH):this._drawBorders(this._hoverColor,re.OUTER_BORDER_WIDTH_HOVER,this._innerColor,re.INNER_BORDER_WIDTH))}hideHoverEffect(){this.IsShowingHoverEffect&&(this.IsShowingHoverEffect=!1,this.isSelected()?this._drawBorders(this._outerColor,re.OUTER_BORDER_WIDTH,this._innerColor,re.INNER_BORDER_WIDTH):this._drawBorders(this._borderColor,this._borderWidth))}setSelected(e){this.IsSelected!=e&&(this.IsSelected=e,this.isHoverEffectShown()?e?"redwood"===this.getCtx().getThemeBehavior()?this._drawBorders(this._outerColor,re.OUTER_BORDER_WIDTH,this._innerColor,re.INNER_BORDER_WIDTH):this._drawBorders(this._hoverColor,re.OUTER_BORDER_WIDTH,this._innerColor,re.INNER_BORDER_WIDTH):this._drawBorders(this._hoverColor,re.OUTER_BORDER_WIDTH_HOVER,this._innerColor,re.INNER_BORDER_WIDTH):e?this._drawBorders(this._outerColor,re.OUTER_BORDER_WIDTH,this._innerColor,re.INNER_BORDER_WIDTH):this._drawBorders(this._hoverColor,this._borderWidth))}UpdateSelectionEffect(){}getDisplayAnim(e){return this.getInsertAnim(e)}getDeleteAnim(e){var i=new t.CustomAnimation(this.getCtx(),this,e),r=[this._x1,this._x2,this._q2,this._q2,this._q2,this._q2,this._q2];return i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimParams,this._setAnimParams,r),i.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,0),i}getInsertAnim(e){var i=new t.CustomAnimation(this.getCtx(),this,e),r=this._getAnimParams();return this._setAnimParams([this._x1,this._x2,this._q2,this._q2,this._q2,this._q2,this._q2]),i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimParams,this._setAnimParams,r),this.setAlpha(0),i.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,1),i}getUpdateAnim(e,i){var r=new t.CustomAnimation(this.getCtx(),this,e),s=i._getQ2Fill(),a=this._getQ2Fill();s.equals(a)||(this._setQ2Fill(s),r.getAnimator().addProp(t.Animator.TYPE_FILL,this,this._getQ2Fill,this._setQ2Fill,a));var n=i._getQ3Fill(),o=this._getQ3Fill();n.equals(o)||(this._setQ3Fill(n),r.getAnimator().addProp(t.Animator.TYPE_FILL,this,this._getQ3Fill,this._setQ3Fill,o));var l=this._getAnimParams();return this._setAnimParams(i._getAnimParams()),r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimParams,this._setAnimParams,l),r}_getAnimParams(){return[this._x1,this._x2,this._low,this._q1,this._q2,this._q3,this._high]}_setAnimParams(e){this._render(e[0],e[1],e[2],e[3],e[4],e[5],e[6])}_getQ2Fill(){return new t.SolidFill(this._styleOptions.q2Color)}_setQ2Fill(e){this._styleOptions.q2Color=e.getColor()}_getQ3Fill(){return new t.SolidFill(this._styleOptions.q3Color)}_setQ3Fill(e){this._styleOptions.q3Color=e.getColor()}_drawLine(e,i,r,s,a){var n=this._bHoriz?new t.Line(this.getCtx(),i,e,s,r):new t.Line(this.getCtx(),e,i,r,s);return this._applyCustomStyle(n,a),n.setPixelHinting(!0),this.addChild(n),n}_drawMedianLine(e){if(!this._medianLine){var i=new t.Line(this.getCtx(),0,0,0,0);this._applyCustomStyle(i,"median"),i.setPixelHinting(!0),this.addChild(i),this._medianLine=i}var r=this._x1+e,s=this._x2-e,a=this._q2;this._bHoriz?(this._medianLine.setX1(a),this._medianLine.setX2(a),this._medianLine.setY1(r),this._medianLine.setY2(s)):(this._medianLine.setY1(a),this._medianLine.setY2(a),this._medianLine.setX1(r),this._medianLine.setX2(s))}_drawBorders(e,i,r,s){if(!this._outerBorderShape){var a=this.getChildIndex(this._q2Box);this._innerBorderShape=new t.Polygon(this.getCtx()),this._innerBorderShape.setInvisibleFill(),this.addChildAt(this._innerBorderShape,a),this._outerBorderShape=new t.Polygon(this.getCtx()),this._outerBorderShape.setInvisibleFill(),this.addChildAt(this._outerBorderShape,a)}var n=0;i?(this._outerBorderShape.setPoints(this._createBoxPointsArray(0)),this._outerBorderShape.setSolidFill(e),n+=i,s?(this._innerBorderShape.setPoints(this._createBoxPointsArray(i)),this._innerBorderShape.setSolidFill(r),n+=s):this._innerBorderShape.setInvisibleFill()):(this._outerBorderShape.setInvisibleFill(),this._innerBorderShape.setInvisibleFill()),this._q2Box.setPoints(this._createQ2PointsArray(n)),this._q3Box.setPoints(this._createQ3PointsArray(n)),this._drawMedianLine(n)}_createBoxPointsArray(e){var t,i,r=this._x1+e,s=this._x2-e;return this._q1<this._q3?(t=this._q1+e,i=this._q3-e):(t=this._q1-e,i=this._q3+e),this._createPointsArray(r,s,t,i)}_createQ3PointsArray(e){var t,i=this._x1+e,r=this._x2-e,s=this._q2;return t=this._q2<this._q3?this._q3-e:this._q3+e,this._createPointsArray(i,r,s,t)}_createQ2PointsArray(e){var t,i=this._x1+e,r=this._x2-e,s=this._q2;return t=this._q2<this._q1?this._q1-e:this._q1+e,this._createPointsArray(i,r,t,s)}_createPointsArray(e,t,i,r){return this._bHoriz?[i,e,i,t,r,t,r,e]:[e,i,t,i,t,r,e,r]}_applyCustomStyle(e,t){e.setStyle(this._styleOptions[t+"Style"]||this._styleOptions[t+"SvgStyle"],!0),e.setClassName(this._styleOptions[t+"ClassName"]||this._styleOptions[t+"SvgClassName"],!0)}_cleanUp(){this.removeChildren(),this._q2Box=null,this._q3Box=null,this._medianLine=null,this._outerBorderShape=null,this._innerBorderShape=null}}class ne extends t.Container{constructor(e,t,i,r,s,a,n){super(e),this._BAR_WIDTH=.3,i=Math.max(2*Math.round(i/2),1);var o=Math.min(2*Math.ceil(this._BAR_WIDTH*i/2),i),l=Math.round(t)-i/2,h=l+i;if(null!=a&&null!=n){var g=Math.round(t)-o/2,d=g+o;this._rangeShape=new re(e,[g,a,d,a,d,n,g,n]),this.addChild(this._rangeShape)}this._changeShape=new re(e,[l,r,h,r,h,s,l,s]),this.addChild(this._changeShape),this.setPixelHinting(!0)}setChangeStyle(e,t,i,r,s){this._changeShape.setStyleProperties(e,t,i,r,s)}setRangeStyle(e,t,i,r){this._rangeShape&&this._rangeShape.setStyleProperties(e,t,i,null,r)}setSelected(e){this._changeShape.setSelected(e),this._rangeShape&&this._rangeShape.setSelected(e)}showHoverEffect(){this._changeShape.showHoverEffect(),this._rangeShape&&this._rangeShape.showHoverEffect()}hideHoverEffect(){this._changeShape.hideHoverEffect(),this._rangeShape&&this._rangeShape.hideHoverEffect()}getDisplayAnim(e){var i=new t.CustomAnimation(this.getCtx(),this,e),r=this._changeShape.getPoints();if(this._changeShape.setPoints(ne._getInitialPoints(r)),i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._changeShape,this._changeShape.getPoints,this._changeShape.setAnimParams,r),this._rangeShape){var s=this._rangeShape.getPoints();this._rangeShape.setPoints(ne._getInitialPoints(s)),i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._rangeShape,this._rangeShape.getPoints,this._rangeShape.setAnimParams,s)}return i}getDeleteAnim(e){var i=new t.CustomAnimation(this.getCtx(),this,e),r=ne._getInitialPoints(this._changeShape.getPoints());if(i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._changeShape,this._changeShape.getPoints,this._changeShape.setAnimParams,r),this._rangeShape){var s=ne._getInitialPoints(this._rangeShape.getPoints());i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._rangeShape,this._rangeShape.getPoints,this._rangeShape.setAnimParams,s)}return i.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,0),i}getInsertAnim(e){this.setAlpha(0);var i=this.getDisplayAnim(e);return i.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,1),i}getUpdateAnim(e,i){var r=new t.CustomAnimation(this.getCtx(),this,e),s=this._changeShape.getPoints();this._changeShape.setPoints(i._changeShape.getPoints()),r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._changeShape,this._changeShape.getPoints,this._changeShape.setAnimParams,s);var a=i._changeShape.getPrimaryFill(),n=this._changeShape.getPrimaryFill();if(i._changeShape.isSelected()||this._changeShape.isSelected()||a.equals(n)||(this._changeShape.setFill(a),r.getAnimator().addProp(t.Animator.TYPE_FILL,this._changeShape,this._changeShape.getFill,this._changeShape.setFill,n)),this._rangeShape&&i._rangeShape){var o=this._rangeShape.getPoints();this._rangeShape.setPoints(i._rangeShape.getPoints()),r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._rangeShape,this._rangeShape.getPoints,this._rangeShape.setAnimParams,o)}return r}UpdateSelectionEffect(){}static _getInitialPoints(e){var t=e[0],i=e[2],r=(e[1]+e[5])/2;return[t,r,i,r,i,r,t,r]}}class oe{constructor(e,t,i,r,s,a){this.x=e,this.y1=t,this.y2=i,this.groupIndex=r,this.group=s,this.filtered=a}isUpstep(e){return Math.abs(this.y2-e)>Math.abs(this.y1-e)}clone(){return new oe(this.x,this.y1,this.y2,this.groupIndex,this.group,this.filtered)}}class le extends t.Container{constructor(e,t,i,r,s,a,n,o,l,h,g,d){super(e.getCtx()),this._INDICATOR_OFFSET=8,this._chart=e,this._bArea=t,this._availSpace=i,this._baseline=r,this._style=s,this._className=a,this._fill=n,this._stroke=o,this._type=l,this._baseType=g||l,this._indicatorMap={},this.setCoords(h,d),this.chartShapeType="lineArea"}setCoords(e,t){this._arCoord=e,t&&(this._arBaseCoord=t),this.removeChildren(),this._bArea?this._renderAreas():this._renderLines(),this._positionIndicators()}getCoords(){return this._arCoord}getBaseCoords(){return this._arBaseCoord}getBaseline(){return this._baseline}isArea(){return this._bArea}_getPointArrays(e,i){var r=[],s=[];r.push(s),e=le._convertToPointCoords(e);var a,n,o,h,g,d=l.isPolar(this._chart),u="centeredStepped"==i||"centeredSegmented"==i,_=u||"stepped"==i||"segmented"==i,p=c.getGroupWidth(this._chart),v=t.Agent.isRightToLeft(this.getCtx())&&l.isVertical(this._chart)?-1:1;d&&(a=e[e.length-1]);for(var m=!1,f=0;f<e.length;f++)null!=e[f]?(n=e[f],h=e[f]._isY2,o=u?n.x-p/2*v:n.x,h&&(m&&_&&(o+=p*v),m=!m),"curved"==i&&h&&s.push(null,null),a&&_&&this._pushCoord(s,o,a.y),this._bArea||"segmented"!=i&&"centeredSegmented"!=i||(s=[],r.push(s)),this._pushCoord(s,o,n.y),a=n):l.isMixedFrequency(this._chart)||(_&&!d&&a&&!h&&(g=u?a.x+.5*p*v:a.x+p*v,this._pushCoord(s,g,a.y)),s=[],r.push(s),a=null);if(_&&!d&&a&&!h&&(g=u?a.x+.5*p*v:a.x+p*v,this._pushCoord(s,g,a.y)),d&&r.length>1){var x=r.pop();r[0]=x.concat(r[0])}return r}_pushCoord(e,i,r){var s=h.convertAxisCoord(this._chart,new t.Point(i,r),this._availSpace);e.push(Math.round(10*s.x)/10,Math.round(10*s.y)/10)}_isRing(){if(!l.isPolar(this._chart)||!l.hasGroupAxis(this._chart)||this._arCoord.length<d.getGroupCount(this._chart))return!1;for(var e=0;e<this._arCoord.length;e++)if(null==this._arCoord[e].x)return!1;return!0}_getSplineType(){return l.isScatterBubble(this._chart)?t.PathUtils.SPLINE_TYPE_CARDINAL:l.isPolar(this._chart)?this._isRing()?t.PathUtils.SPLINE_TYPE_CARDINAL_CLOSED:t.PathUtils.SPLINE_TYPE_CARDINAL:l.isHorizontal(this._chart)?t.PathUtils.SPLINE_TYPE_MONOTONE_HORIZONTAL:t.PathUtils.SPLINE_TYPE_MONOTONE_VERTICAL}_renderLines(){for(var e,i=this._getPointArrays(this._arCoord,this._type),r=0;r<i.length;r++){var s=i[r];if(s&&s.length>1){if("curved"==this._type){var a=le._getCurvedPathCommands(s,!1,this._getSplineType());(e=new t.Path(this.getCtx(),a)).setFill(null)}else this._isRing()?(e=new t.Polygon(this.getCtx(),s)).setFill(null):e=new t.Polyline(this.getCtx(),s);e.setStroke(this._stroke),e.setClassName(this._className).setStyle(this._style),this.addChild(e)}}}_renderAreas(){var e=this._arCoord,i=this._arBaseCoord;!l.isPolar(this._chart)&&e.length>0&&i.length>0&&(e=e.slice(0),i=i.slice(0),null!=e[0].x&&null!=i[0].x&&(le._removeAreaEdge(e,0,this._baseline),le._removeAreaEdge(i,0,this._baseline),i[0].x=e[0].x),null!=e[e.length-1].x&&null!=i[i.length-1].x&&(le._removeAreaEdge(e,e.length-1,this._baseline),le._removeAreaEdge(i,i.length-1,this._baseline),i[i.length-1].x=e[e.length-1].x));var r=this._getPointArrays(e,this._type),s=this._getPointArrays(i,this._baseType);if(r.length==s.length)for(var a,n=0;n<r.length;n++){var o=r[n],h=s[n];if(!(o.length<2)){var g="curved"==this._type,d="curved"==this._baseType;this._isRing()&&(g||o.push(o[0],o[1]),h.length>=2&&!d&&h.push(h[0],h[1]));for(var u=[],_=0;_<h.length;_+=2)u.unshift(h[_],h[_+1]);if(g||d){var c=this._getSplineType(),p=g?le._getCurvedPathCommands(o,!1,c):t.PathUtils.polyline(o,!1);p+=d?le._getCurvedPathCommands(u,!0,c):t.PathUtils.polyline(u,!0),p+=t.PathUtils.closePath(),a=new t.Path(this.getCtx(),p)}else{var v=u.concat(o);a=new t.Polygon(this.getCtx(),v)}a.setFill(this._fill),a.setClassName(this._className).setStyle(this._style),this._stroke&&a.setStroke(this._stroke),this.addChild(a)}}}_positionIndicators(){for(var e,i,r,s,a,n=0;n<this._arCoord.length;n++)a=this._arCoord[n],(e=this._indicatorMap[a.groupIndex])&&e.indicator&&(s=(a.isUpstep(this._baseline)?a.y2:a.y1)+this._INDICATOR_OFFSET*(e.direction==q.DIR_UP?-1:1),r=h.convertAxisCoord(this._chart,new t.Point(a.x,s),this._availSpace),(i=e.indicator).setTranslate(r.x,r.y),i.setAlpha(1),i.getParent().addChild(i))}getAnimParams(e){return le._coordsToAnimParams(this._arCoord,e?e._arCoord:null,this._baseline)}setAnimParams(e){var t=le._animParamsToCoords(e);this.setCoords(t)}getBaseAnimParams(e){return le._coordsToAnimParams(this._arBaseCoord,e?e._arBaseCoord:null,this._baseline)}setBaseAnimParams(e){this._arBaseCoord=le._animParamsToCoords(e)}getCommonGroupIndices(e){for(var t=[],i=0;i<this._arCoord.length;i++)if(!this._arCoord[i].filtered&&null!=this._arCoord[i].x)for(var r=0;r<e._arCoord.length;r++)if(!e._arCoord[r].filtered&&null!=e._arCoord[r].x&&this._arCoord[i].group==e._arCoord[r].group){t.push(this._arCoord[i].groupIndex);break}return t}addIndicator(e,t,i){i.setAlpha(0),this._indicatorMap[e]={direction:t,indicator:i}}removeIndicators(){for(var e in this._indicatorMap){var t=this._indicatorMap[e].indicator;t&&t.getParent().removeChild(t)}this._indicatorMap={}}static _convertToPointCoords(e){for(var i=[],r=0;r<e.length;r++)if(!e[r].filtered)if(null==e[r].x)i.push(null);else if(i.push(new t.Point(e[r].x,e[r].y1)),e[r].y1!=e[r].y2){var s=new t.Point(e[r].x,e[r].y2);s._isY2=!0,i.push(s)}return i}static _coordsToAnimParams(e,t,i){if(t&&t.length>0)if(e&&e.length>0){e=e.slice(0);for(var r,s,a,n=le._coordsToGroups(t),o=le._coordsToGroups(e),l=e.length,h=n.length-1;h>=0;h--)r=n[h],-1==(s=o.indexOf(r))?(0==l?(a=e[0].clone(),e[0]=e[0].clone(),le._removeCoordJump(a,e[0],i)):(a=e[l-1].clone(),e[l-1]=e[l-1].clone(),le._removeCoordJump(e[l-1],a,i)),a.groupIndex=-1,e.splice(l,0,a)):l=s}else{e=[];for(h=0;h<t.length;h++)e.push(new oe(t[h].x,i,i))}for(var g=[],d=0;d<e.length;d++)e[d].filtered||(null==e[d].x?(g.push(1/0),g.push(1/0),g.push(1/0)):(g.push(e[d].x),g.push(e[d].y1),g.push(e[d].y2)),g.push(e[d].groupIndex));return g}static _animParamsToCoords(e){for(var t=[],i=0;i<e.length;i+=4)e[i]==1/0||isNaN(e[i])?t.push(new oe(null,null,null,e[i+3])):t.push(new oe(e[i],e[i+1],e[i+2],e[i+3]));return t}static _coordsToGroups(e){for(var t=[],i=0;i<e.length;i++)e[i].filtered||t.push(e[i].group);return t}static _removeCoordJump(e,t,i){e.isUpstep(i)?t.y1=t.y2:e.y2=e.y1}static _getCurvedPathCommands(e,i,r){var s=[],a=[];s.push(a);for(var n=0;n<e.length;n+=2)null==e[n]?(a=[],s.push(a)):a.push(e[n],e[n+1]);if(r==t.PathUtils.SPLINE_TYPE_CARDINAL_CLOSED&&s.length>1){var o=s.pop();s[0]=o.concat(s[0]),r=t.PathUtils.SPLINE_TYPE_CARDINAL}var l="";for(n=0;n<s.length;n++)a=s[n],l+=t.PathUtils.curveThroughPoints(a,i,r),i=!0;return l}static _removeAreaEdge(e,t,i){var r=e[t].clone();r.isUpstep(i)?r.y1=r.y2:r.y2=r.y1,e[t]=r}}class he extends t.SimpleMarker{constructor(e,t,i,r,s,a){super(e,t,i,r,s,s,null,null,!0),a&&this.setStroke(he.DEFAULT_STROKE)}setDataColor(e){this._dataColor=e,this._hoverStroke=new t.Stroke(e,1,1.5)}getDataColor(){return this._dataColor}showHoverEffect(){this.IsShowingHoverEffect=!0,this.setStroke(this._hoverStroke)}hideHoverEffect(){this.IsShowingHoverEffect=!1,this.setStroke(this.isSelected()?he.SELECTED_STROKE:he.DEFAULT_STROKE)}setSelected(e){this.IsSelected!=e&&(this.IsSelected=e,this.isSelected()?(this.setFill(he.SELECTED_FILL),this.setStroke(this.isHoverEffectShown()?this._hoverStroke:he.SELECTED_STROKE)):(this.setInvisibleFill(),this.setStroke(this.isHoverEffectShown()?this._hoverStroke:he.DEFAULT_STROKE)))}UpdateSelectionEffect(){}}he.DEFAULT_STROKE=new t.Stroke("none"),he.SELECTED_FILL=new t.SolidFill("#FFFFFF"),he.SELECTED_STROKE=new t.Stroke("#5A5A5A",1,1.5);class ge extends U{constructor(e,t,i,r,s,a,n){super(e.getCtx()),this._MIN_BAR_LENGTH_FOR_GAPS=4,this._MAX_DATA_ITEM_GAP=3,this._axisCoord=t,this._availSpace=n.clone(),this._bbox=null,this._dataItemGaps=c.getDataItemGaps(e)*this._MAX_DATA_ITEM_GAP,this._setBarCoords(i,r,s,a)}getAnimParams(){return[this._baselineCoord,this._endCoord,this._x1,this._x2]}setAnimParams(e){this._setBarCoords(e[0],e[1],e[2],e[3])}getPrimaryFill(){return this.getFill()}getDisplayAnim(e){var i=this.getAnimParams();this.setAnimParams([this._axisCoord,this._axisCoord,0,0]);var r=new t.CustomAnimation(this.getCtx(),this,e);return r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.getAnimParams,this.setAnimParams,i),r}getDeleteAnim(e){var i=[this._baselineCoord,this._baselineCoord,this._x1,this._x2],r=new t.CustomAnimation(this.getCtx(),this,e);return r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.getAnimParams,this.setAnimParams,i),r.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,0),r}getInsertAnim(e){this.setAlpha(0);var i=this.getAnimParams();this.setAnimParams([this._baselineCoord,this._baselineCoord,this._x1,this._x2]);var r=new t.CustomAnimation(this.getCtx(),this,e);return r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.getAnimParams,this.setAnimParams,i),r.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,1),r}_setBarCoords(e,i,r,s){var a=this._availSpace.x+this._availSpace.w/2,n=this._availSpace.y+this._availSpace.h/2,o=Math.max(i,e),l=Math.abs(i-e)>=this._MIN_BAR_LENGTH_FOR_GAPS&&this._axisCoord!=e?Math.min(i,e)+this._dataItemGaps:Math.min(i,e),g=360-t.Math.radsToDegrees(Math.max(r,s))+90,d=t.Math.radsToDegrees(Math.abs(s-r));this.setWedgeParams(a,n,o,o,g,d,this._dataItemGaps,l);var u=h.polarToCartesian(e,r,this._availSpace),_=h.polarToCartesian(e,s,this._availSpace),c=h.polarToCartesian(i,r,this._availSpace),p=h.polarToCartesian(i,s,this._availSpace),v=Math.min(u.x,_.x,c.x,p.x),m=Math.max(u.x,_.x,c.x,p.x),f=Math.min(u.y,_.y,c.y,p.y),x=Math.max(u.y,_.y,c.y,p.y);this._bbox=new t.Rectangle(v,f,m-v,x-f),this._baselineCoord=e,this._endCoord=i,this._x1=r,this._x2=s}getBoundingBox(){return this._bbox}getOriginalBarSize(){return this._bbox.w}}class de extends t.Path{constructor(e,t,i,r,s,a,n){super(e),this._markerSize=a,this._isInvisible=n,this._drawPath(t,i,r,s)}_drawPath(e,i,r,s){var a=Math.atan2(s-i,r-e),n=this._markerSize/2,o=Math.PI/8,l=t.PathUtils.moveTo(e+n*Math.cos(a+o),i+n*Math.sin(a+o))+t.PathUtils.arcTo(n,n,2*(Math.PI-o),1,e+n*Math.cos(a-o),i+n*Math.sin(a-o))+t.PathUtils.lineTo(r-n*Math.cos(a+o),s-n*Math.sin(a+o))+t.PathUtils.arcTo(n,n,2*(Math.PI-o),1,r-n*Math.cos(a-o),s-n*Math.sin(a-o))+t.PathUtils.closePath();this.setCmds(l),this._x1=e,this._y1=i,this._x2=r,this._y2=s}setStyleProperties(e,i,r,s,a){this._dataColor=r;var n=t.SelectionEffectUtils.getHoverBorderColor(r);this._isInvisible?(this.setInvisibleFill(),this._hoverStroke=new t.Stroke(n,1,1.5)):(this.setFill(e),this.setStroke(i),this.setHoverStroke(new t.Stroke(s,1,1),new t.Stroke(n,1,3.5)),this.setSelectedStroke(new t.Stroke(s,1,1.5),new t.Stroke(a,1,4.5)),this.setSelectedHoverStroke(new t.Stroke(s,1,1.5),new t.Stroke(n,1,4.5)))}getDataColor(){return this._dataColor}showHoverEffect(){this._isInvisible?(this.IsShowingHoverEffect=!0,this.setStroke(this._hoverStroke)):super.showHoverEffect()}hideHoverEffect(){this._isInvisible?(this.IsShowingHoverEffect=!1,this.setStroke(this.isSelected()?he.SELECTED_STROKE:he.DEFAULT_STROKE)):super.hideHoverEffect()}setSelected(e){if(this._isInvisible){if(this.IsSelected==e)return;this.IsSelected=e,this.isSelected()?(this.setFill(he.SELECTED_FILL),this.setStroke(this.isHoverEffectShown()?this._hoverStroke:he.SELECTED_STROKE)):(this.setInvisibleFill(),this.setStroke(this.isHoverEffectShown()?this._hoverStroke:he.DEFAULT_STROKE))}else super.setSelected(e)}UpdateSelectionEffect(){this._isInvisible||super.UpdateSelectionEffect()}getAnimParams(){return[this._x1,this._y1,this._x2,this._y2]}setAnimParams(e){this._drawPath(e[0],e[1],e[2],e[3])}isInvisible(){return this._isInvisible}getBoundingBox(){return this.getBoundingBox1().getUnion(this.getBoundingBox2())}getBoundingBox1(){return new t.Rectangle(this._x1-this._markerSize/2,this._y1-this._markerSize/2,this._markerSize,this._markerSize)}getBoundingBox2(){return new t.Rectangle(this._x2-this._markerSize/2,this._y2-this._markerSize/2,this._markerSize,this._markerSize)}}const ue={createAnim:(e,i,r,s,a)=>{if(!ue._canAnimate(e,i))return null;var n,o=i.getCtx(),h=[],g=[];l.isPie(i)?(h.push(e.pieChart),g.push(i.pieChart)):ue._buildAnimLists(o,h,e,g,i,s);var d=new t.DataAnimationHandler(o,a);d.constructAnimation(h,g),d.getNumPlayables()>0&&(n=d.getAnimation(!0));var u=i.getDataLabels();if(n&&u.length>0){for(var _=0;_<u.length;_++)u[_].setAlpha(0);n=new t.SequentialPlayable(o,n,new t.AnimFadeIn(o,u,s/4))}return n},_buildAnimLists:(e,i,r,s,a,n)=>{var o,l,h,g,d,u=r.getChartObjPeers(),_=i,c=a.getCache().getFromCache("dataFiltered");for(o=0;o<2;o++){var p={},v={};for(l=0;l<u.length;l++){if(d=null,(g=(h=u[l]).getDisplayables()[0])instanceof B)d=new J(h,n,"/funnel");else if(g instanceof H)d=new te(h,n,"/pyramid");else if(g instanceof se||g instanceof ge){if(d=new Q(h,n,"/bar"),c){var m=h.getSeries();p[m]=p[m]?p[m]+1:1,d.setId(m+"/"+p[m]+"/bar")}}else if(g instanceof le){var f=(d=new $(h,n)).getId();v[f]=v[f]?v[f]+1:1,d.setId(f+"/"+v[f])}else if(g instanceof t.SimpleMarker){if(g instanceof he&&!g.isSelected())continue;d=new ee(h,n,"/marker")}else if(g instanceof de){if(g.isInvisible()&&!g.isSelected())continue;d=new ie(h,n,"/rangeMarker")}else g instanceof ne?d=new K(h,n):g instanceof ae&&(d=new K(h,n,"/boxAndWhisker"));d&&(_.push(d),d.setOldChart(r))}_=s,u=a.getChartObjPeers()}},_canAnimate:(e,t)=>l.isPie(e)&&l.isPie(t)?e&&t:l.isPolar(e)==l.isPolar(t)&&(!(!l.isBLAC(e)||!l.isBLAC(t))||(!(!l.isScatterBubble(e)||!l.isScatterBubble(t))||e.getType()==t.getType()))},_e={createAnim:(e,i,r)=>{var s=[];if(l.isBLAC(e))_e._animBarLineArea(e,r,s);else if(l.isScatterBubble(e)||l.isFunnel(e)||l.isPyramid(e))_e._animBubbleScatterFunnelPyramid(e,r,s);else if(l.isPie(e)&&e.pieChart)return e.pieChart.getDisplayAnim();return s.length>0?new t.ParallelPlayable(e.getCtx(),s):null},_animBarLineArea:(e,i,r)=>{var s=e.getChartObjPeers(),a=s?s.length:0;if(a)for(var n,o,l,h=0;h<a;h++){n=(o=s[h]).getDisplayables()[0];var g=d.getSeriesType(o.getChart(),o.getSeriesIndex());if(l=null,n instanceof se||n instanceof ge||n instanceof ne||n instanceof ae)l=n.getDisplayAnim(i);else if(n instanceof le)l="line"==g?_e._getLinePlayable(e,n,i):_e._getAreaPlayable(e,n,i);else if(n instanceof t.SimpleMarker||n instanceof de){if(n instanceof he&&!n.isSelected())continue;l=new t.AnimFadeIn(e.getCtx(),n,i-.8,.8)}l&&r.push(l)}},_animBubbleScatterFunnelPyramid:(e,i,r)=>{var s=e.getObjects(),a=s?s.length:0;if(a)for(var n,o,l=0;l<a;l++)(n=s[l].getDisplayables()[0])instanceof t.SimpleMarker?o=new t.AnimPopIn(e.getCtx(),n,!0,i):(n instanceof B||n instanceof H)&&(o=_e._getFunnelPyramidPlayable(e,n,i)),o&&r.push(o)},_getAreaPlayable:(e,i,r)=>{var s,a=e.getCtx(),n=i.getBaseline();if(i.isArea()){for(var o=i.getBaseCoords(),l=i.getBaseAnimParams(),h=l.slice(0),g=0;g<l.length;g++)g%4!=1&&g%4!=2||(l[g]=n);i.setBaseAnimParams(l),(s=new t.CustomAnimation(a,i,r)).getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getBaseAnimParams,i.setBaseAnimParams,h)}var d=i.getCoords(),u=i.getAnimParams(),_=u.slice(0);for(g=0;g<u.length;g++)g%4!=1&&g%4!=2||(u[g]=n);i.setAnimParams(u);var c=new t.CustomAnimation(a,i,r);c.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimParams,i.setAnimParams,_);var p=new t.ParallelPlayable(e.getCtx(),s,c);return p.setOnEnd(()=>{i.setCoords(d,o)}),p},_getFunnelPyramidPlayable:(e,i,r)=>{var s=e.getCtx(),a=i.getAnimParams(),n=a.slice(0),o=a.slice(0);a[0]=0,l.isFunnel(e)&&(a[2]=0,n[2]=0),i.setAnimParams(a);var h=new t.CustomAnimation(s,i,r/2);h.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimParams,i.setAnimParams,n);var g=new t.CustomAnimation(s,i,r/2);return g.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimParams,i.setAnimParams,o),new t.SequentialPlayable(s,[h,g])},_getLinePlayable:(e,i,r)=>{var s=i.getCoords(),a=i.getAnimParams(),n=a.slice(0);_e._getMeanPoints(a),i.setAnimParams(a);var o=new t.CustomAnimation(e.getCtx(),i,r);return o.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimParams,i.setAnimParams,n),o.setOnEnd(()=>{i.setCoords(s)}),o},_getMeanPoints:e=>{var t,i=0,r=Number.MAX_VALUE,s=-1*Number.MAX_VALUE,a=e.length;for(t=0;t<a;t++){var n=e[t];t%4!=0&&t%4!=3&&n!=1/0&&(n<r&&(r=n),n>s&&(s=n),i+=n)}for(a>8?(i-=2*r,i-=2*s,i/=a/2-4):i/=a/2,t=0;t<a;t++)t%4!=1&&t%4!=2||(e[t]=i)}};class ce extends(i.DataAxisInfoMixin(S)){getMinLabel(){return this.ZeroBaseline||"on"==this.Options._continuousExtent&&null==this.Options.min?Math.ceil(this.LinearMinValue/this.MajorIncrement)*this.MajorIncrement:Math.ceil((this.LinearMinValue-this.LinearGlobalMin)/this.MajorIncrement)*this.MajorIncrement+this.LinearGlobalMin}getLabels(e,t){if(t&&t>0)return null;var i=this.getAllLabels(e),r=[],s=e.getStage();return"tangential"!=this.Position&&(r=this.GetLabelDims(i,s),i=this.SkipLabels(i,r)),i}getAllLabels(e,t){var r=[];if(this.Options.tickLabel&&this.Options.tickLabel.scaling){var s=this.Options.tickLabel.autoPrecision?this.Options.tickLabel.autoPrecision:"on";this._axisValueFormatter=new i.LinearScaleAxisValueFormatter(this.LinearMinValue,this.LinearMaxValue,this.MajorIncrement,this.Options.tickLabel.scaling,s,this.Options.translations)}for(var a=0;a<=this.MajorTickCount;a++){var n=a*this.MajorIncrement+this.getMinLabel();if(n-this.LinearMaxValue>this.MAJOR_TICK_INCREMENT_BUFFER)break;var o,l=this.GetUnboundedCoordAt(n);if(this.Options._skipHighestTick){if(n==this.LinearMaxValue)continue;if("tangential"!=this.Position&&Math.abs(l-this.MaxCoord)<this.getTickLabelHeight())continue}this.IsLog?(n=this.linearToActual(n),this._axisValueFormatter=new i.LinearScaleAxisValueFormatter(n,n,n,this.Options.tickLabel.scaling,s,this.Options.translations),o=this._formatValue(n)):o=this._formatValue(n),t?r.push(o):r.push(this.CreateLabel(e,o,l))}return r}getMajorTickCoords(){for(var e=[],t=0;t<=this.MajorTickCount;t++){var i=t*this.MajorIncrement+this.getMinLabel();if(i-this.LinearMaxValue>this.MAJOR_TICK_INCREMENT_BUFFER)break;if(!this.Options._skipHighestTick||i!=this.LinearMaxValue){var r=this.GetUnboundedCoordAt(i);e.push(r)}}return e}getMinorTickCoords(){for(var e=[],i=-1;i<=this.MajorTickCount;i++){var r=i*this.MajorIncrement+this.getMinLabel();if(this.IsLog&&1==this.MajorIncrement&&1==this.MinorIncrement)for(var s=2;s<=9;s++){var a=r+t.Math.log10(s);if(a>this.LinearMaxValue)break;a<this.LinearMinValue||(o=this.GetUnboundedCoordAt(a),e.push(o))}else for(s=1;s<this.MinorTickCount;s++){var n=r+s*this.MinorIncrement;if(n>this.LinearMaxValue)break;if(!(n<this.LinearMinValue)){var o=this.GetUnboundedCoordAt(n);e.push(o)}}}return e}_formatValue(e){if(this.Converter&&this.Converter.format)return this._axisValueFormatter?this._axisValueFormatter.format(e,this.Converter):this.Converter.format(e);if(this._axisValueFormatter)return this._axisValueFormatter.format(e);var i=t.Math.log10(this.MajorIncrement),r=Math.max(Math.ceil(-i),0);return e.toFixed(r)}getMajorTickCount(){return this.MajorTickCount}getMinorTickCount(){return this.MinorTickCount}getMajorIncrement(){return this.linearToActual(this.MajorIncrement)}getMinorIncrement(){return this.linearToActual(this.MinorIncrement)}getMinExtent(){return(this.LinearGlobalMax-this.LinearGlobalMin)/ce.MAX_ZOOM}getStartOverflow(){return"top"!=this.Position&&"bottom"!=this.Position||!t.Agent.isRightToLeft(this.getCtx())?this.StartOverflow:this.EndOverflow}getEndOverflow(){return"top"!=this.Position&&"bottom"!=this.Position||!t.Agent.isRightToLeft(this.getCtx())?this.EndOverflow:this.StartOverflow}alignLogScaleToTickCount(e,t){if(this.IsLog)for(var i=this.getMajorTickCount();t<i;)this.MajorIncrement=null,this.MajorTickCount=null,this.MinorIncrement=null,this.MinorTickCount=null,e++,this.CalcMajorMinorIncr(e),i=this.getMajorTickCount();return e}getLogScaleUnit(){return this.LogScaleUnit}}S.registerConstructor("data",ce),ce.MAX_ZOOM=64;class pe extends S{constructor(e,r,s){super(e,r,s),"top"==this.Position||"bottom"==this.Position?(r._isOverview||"on"!=r.tickLabel.rendered||(this.StartOverflow=Math.max(i.BaseAxisInfo.MIN_AXIS_BUFFER-r.leftBuffer,0),this.EndOverflow=Math.max(i.BaseAxisInfo.MIN_AXIS_BUFFER-r.rightBuffer,0)),t.Agent.isRightToLeft(e)?(this._startCoord=this.EndCoord-this.EndOverflow,this._endCoord=this.StartCoord+this.StartOverflow):(this._startCoord=this.StartCoord+this.StartOverflow,this._endCoord=this.EndCoord-this.EndOverflow)):(this._startCoord=this.StartCoord,this._endCoord=this.EndCoord);var a=null!=r.tickLabel?r.tickLabel.converter:null;this._label1Converter=a&&a[0]?a[0]:a,this._label2Converter=a&&a[1]?a[1]:null,this._dateToIsoWithTimeZoneConverter=e.getLocaleHelpers().dateToIsoWithTimeZoneConverter,this._groups=r.groups;var n=r.timeAxisType;this._skipGaps="skipGaps"==n,this._mixedFrequency="mixedFrequency"==n,this.DataMin=r.dataMin,this.DataMax=r.dataMax,this._groups.length>1?this._averageInterval=(this.DataMax-this.DataMin)/(this._groups.length-1):this.DataMax-this.DataMin>0?this._averageInterval=this.DataMax-this.DataMin:this._averageInterval=6*pe.TIME_MINUTE,this._step=r.step;var o=r.endGroupOffset>0?r.endGroupOffset*this._averageInterval:0,l=r.startGroupOffset>0?r.startGroupOffset*this._averageInterval:0;this.GlobalMin=null!=r.min?r.min:this.DataMin-l,this.GlobalMax=null!=r.max?r.max:this.DataMax+o,null!=r.viewportStartGroup&&(this.MinValue=r.viewportStartGroup-l),null!=r.viewportEndGroup&&(this.MaxValue=r.viewportEndGroup+o),null!=r.viewportMin&&(this.MinValue=r.viewportMin),null!=r.viewportMax&&(this.MaxValue=r.viewportMax),null==this.MinValue&&(this.MinValue=this.GlobalMin),null==this.MaxValue&&(this.MaxValue=this.GlobalMax),this.GlobalMin>this.MinValue&&(this.GlobalMin=this.MinValue),this.GlobalMax<this.MaxValue&&(this.GlobalMax=this.MaxValue),this._timeRange=this.MaxValue-this.MinValue,this._level1Labels=null,this._level2Labels=null,this._level1Coords=null,this._level2Coords=null,this._isOneLevel=!0,this._level1Overflow=[],this._level2Overflow=[],this._locale=r._locale.toLowerCase(),this._monthResources=e.LocaleData.getMonthNames("abbreviated")}formatLabel(e){var t=new Date(e),i=this._formatAxisLabel(t,null,!0);return null!=i[1]?"YMD"==pe._getDMYOrder(this._locale)||this._timeRange<pe.TIME_MONTH_MIN&&this._step<pe.TIME_DAY?i[1]+" "+i[0]:i[0]+" "+i[1]:i[0]}_calculateGranularity(){return this._step>=pe.TIME_YEAR_MIN||this._timeRange>=6*pe.TIME_YEAR_MIN?pe.TIME_YEAR_MIN:this._step>=pe.TIME_MONTH_MIN||this._timeRange>=6*pe.TIME_MONTH_MIN?pe.TIME_MONTH_MIN:this._step>=pe.TIME_DAY||this._timeRange>=6*pe.TIME_DAY?pe.TIME_DAY:this._step>=pe.TIME_HOUR||this._timeRange>=6*pe.TIME_HOUR?pe.TIME_HOUR:this._step>=pe.TIME_MINUTE||this._timeRange>=6*pe.TIME_MINUTE?pe.TIME_MINUTE:pe.TIME_SECOND}_formatAxisLabelWithConverter(e,t,i){if(i){var r=null,s=null;if(i.format&&(r=i.format(this._dateToIsoWithTimeZoneConverter&&e?this._dateToIsoWithTimeZoneConverter(e):e),s=i.format(this._dateToIsoWithTimeZoneConverter&&t?this._dateToIsoWithTimeZoneConverter(t):t)),s!==r||null==r)return r;if(!i.resolvedOptions)return null;var a=this._calculateGranularity();return a===pe.TIME_MONTH_MIN&&t.getMonth()!==e.getMonth()&&null!=i.resolvedOptions().month||a===pe.TIME_DAY&&t.getDate()!==e.getDate()&&null!=i.resolvedOptions().day?r:null}}_formatAxisLabel(e,t,i){var r=null,s=null,a="left"==this.Position||"right"==this.Position,n=this._calculateGranularity();return this._label1Converter||this._label2Converter?(this._label1Converter&&(r=this._formatAxisLabelWithConverter(e,t,this._label1Converter)),this._label2Converter&&(s=this._formatAxisLabelWithConverter(e,t,this._label2Converter)),[r,s]):(n===pe.TIME_YEAR_MIN?r=this._formatDate(e,!1,!1,!0):n===pe.TIME_MONTH_MIN?(null!=t&&t.getMonth()==e.getMonth()||(r=this._formatDate(e,!1,!0,!1)),null!=t&&t.getYear()==e.getYear()||(s=this._formatDate(e,!1,!1,!0))):n===pe.TIME_DAY?i?r=this._formatDate(e,!0,!0,!0):(null!=t&&t.getDate()==e.getDate()||(r=this._formatDate(e,!0,!1,!1)),null==t||t.getYear()!=e.getYear()?s=this._formatDate(e,!1,!0,!0):t.getMonth()!=e.getMonth()&&(s=this._formatDate(e,!1,!0,!1))):(n===pe.TIME_HOUR?null!=t&&t.getHours()==e.getHours()||(r=this._formatTime(e,!1,!1)):n===pe.TIME_MINUTE?null!=t&&t.getMinutes()==e.getMinutes()||(r=this._formatTime(e,!0,!1)):null!=t&&t.getSeconds()==e.getSeconds()||(r=this._formatTime(e,!0,!0)),a?null!=t&&t.getDate()==e.getDate()||(s=this._formatDate(e,!0,!0,!1)):null==t||t.getYear()!=e.getYear()?s=this._formatDate(e,!0,!0,!0):t.getMonth()!=e.getMonth()?s=this._formatDate(e,!0,!0,!1):t.getDate()!=e.getDate()&&(s=this._formatDate(e,!0,!1,!1))),[r,s])}_formatDate(e,t,i,r){var s,a=e.getFullYear();s=this._monthResources&&this._monthResources.length>=12?this._monthResources[e.getMonth()]:e.toString().split(" ")[1];var n=e.getDate();a+=pe._getYearTrailingCharacters(this._locale),n+=pe._getDayTrailingCharacters(this._locale);for(var o=pe._getDMYOrder(this._locale),l="",h=0;h<o.length;h++)t&&"D"==o[h]?l+=n+" ":i&&"M"==o[h]?l+=s+" ":r&&"Y"==o[h]&&(l+=a+" ");return l.length>0?l.slice(0,l.length-1):l}_formatTime(e,i,r){var s,a=e.getHours(),n=e.getMinutes(),o=e.getSeconds(),l=pe._getAMString(this._locale),h=pe._getPMString(this._locale),g=pe._getAMPMBefore(this._locale),d=""!=l&&""!=h,u="";return t.Agent.isRightToLeft(this.getCtx())&&(u="‏"),d?(a<12?(s=l,0==a&&(a=12)):(s=h,a>12&&(a-=12)),u+=a,(i||0!=n)&&(u+=":"+this._doubleDigit(n))):u+=this._doubleDigit(a)+":"+this._doubleDigit(n),r&&(u+=":"+this._doubleDigit(o)),d?g?s+" "+u:u+" "+s:u}_doubleDigit(e){return e<10?"0"+e:""+e}_getMixedFrequencyStep(){return this._timeRange>=6*pe.TIME_YEAR_MIN?pe.TIME_YEAR_MIN:this._timeRange>=6*pe.TIME_MONTH_MIN?pe.TIME_MONTH_MIN:this._timeRange>=6*pe.TIME_DAY?pe.TIME_DAY:this._timeRange>=pe.TIME_DAY?3*pe.TIME_HOUR:this._timeRange>=6*pe.TIME_HOUR?pe.TIME_HOUR:this._timeRange>=pe.TIME_HOUR?15*pe.TIME_MINUTE:this._timeRange>=30*pe.TIME_MINUTE?5*pe.TIME_MINUTE:this._timeRange>=6*pe.TIME_MINUTE?pe.TIME_MINUTE:this._timeRange>=pe.TIME_MINUTE?15*pe.TIME_SECOND:this._timeRange>=30*pe.TIME_SECOND?5*pe.TIME_SECOND:pe.TIME_SECOND}_generateLabels(e){var i=[],r=[],s=[],a=[],n=[],o=null,l=0,h=0,g=e.getStage(e),d=t.Agent.isRightToLeft(e),u="left"==this.Position||"right"==this.Position,_="off"!=this.Options.zoomAndScroll,c=!0,p=0;u&&"blink"===t.Agent.engine&&(p=.16*this.getTickLabelHeight());var v=[];if(null!=this._step)v=pe._getLabelPos(this.MinValue,this.MaxValue,this._step);else if(this._mixedFrequency)this._step=this._getMixedFrequencyStep(),v=pe._getLabelPos(this.MinValue,this.MaxValue,this._step);else{for(var m=0;m<this._groups.length;m++)this._groups[m]>=this.MinValue&&this._groups[m]<=this.MaxValue&&v.push(this._groups[m]);if(this._step=this._averageInterval,!this._skipGaps){var f;if((v=pe._treatMissingValues(v,this._calculateGranularity())).length>1&&(this._step=(v[v.length-1]-v[0])/(v.length-1)),u)f=t.TextUtils.getTextStringHeight(e,this.Options.tickLabel.style);else{var x=this._formatAxisLabel(new Date(v[0]))[0];f=t.TextUtils.getTextStringWidth(e,x,this.Options.tickLabel.style)}(f+this.GetTickLabelGapSize())*(v.length-1)>Math.abs(this._endCoord-this._startCoord)&&(this._step=this._getMixedFrequencyStep(),v=pe._getLabelPos(this.MinValue,this.MaxValue,this._step))}}0==v.length&&(v=[this.MinValue]);for(m=0;m<v.length;m++){var C=v[m],S=this.getCoordAt(C);if(null!=S){var A=new Date(C),b=this._formatAxisLabel(A,o),y=b[0],M=b[1];if(null!=y?(s.push({text:y,coord:null!=M?S+p:S}),a.push(S),l++):(s.push(null),a.push(null)),i.push(null),_&&c&&(S=this.MinValue?this.getCoordAt(this.MinValue):S),c=!1,null!=M){var D=this.CreateLabel(e,M,S-p);n.push(S),u||(d?D.alignRight():D.alignLeft()),r.push(D),this._isOneLevel=!1,h++}else r.push(null),n.push(null);o=A}}if(l=this._skipLabelsUniform(s,i,g,!1,d),!_&&h>1&&l<1.5*h){i=r,r=null;for(var T=0;T<i.length;T++)null!=i[T]&&i[T].alignCenter();l=this._skipLabelsGreedy(i,this.GetLabelDims(i,g),!1,d)}else 0==(h=this._skipLabelsGreedy(r,this.GetLabelDims(r,g),!0,d))&&(r=null);u&&null!=r&&this._skipVertLabels(i,r,g),this._level1Labels=i,this._level2Labels=r,this._level1Coords=a,this._level2Coords=n}_getLabelOverflow(e,t,i,r){var s=e-(i?r?t:0:.5*t);if(s<this.Options._minOverflowCoord)return Math.floor(s-this.Options._minOverflowCoord);var a=e+(i?r?0:t:.5*t);return a>this.Options._maxOverflowCoord?Math.ceil(a-this.Options._maxOverflowCoord):0}_skipLabelsGreedy(e,t,i,r){if(!t||t.length<=0)return!1;for(var s,a,n,o,l,h="left"==this.Position||"right"==this.Position,g=this.getTickLabelHeight(),d=h?.08*g:.24*g,u=0,_=Math.abs(this._endCoord-this._startCoord),c=0;c<t.length;c++)if(this._level2Overflow.push(0),null!=e[c]){var p=(l=e[c]).getDimensions().w;if(t[c].w>_)e[c]=null;else{var v=this._getLabelOverflow(l.getX(),p,i,r);this._level2Overflow[c]=v,0!=v&&(l.setX(l.getX()-v),t[c].x-=v)}}for(c=0;c<t.length;c++)null!=t[c]&&(h?(n=t[c].y,o=t[c].y+t[c].h):(n=t[c].x,o=t[c].x+t[c].w),null!=s&&null!=a&&pe._isOverlapping(s,a,n,o,d)&&(e[c]=null),null!=e[c]&&(s=n,a=o,u++));return u}_skipLabelsUniform(e,t,i,r){for(var s=[],a=[],n=Math.abs(this._endCoord-this._startCoord),o=0;o<e.length;o++)null!=e[o]&&(s.push(e[o]),a.push(null),this._level1Overflow.push(0));for(var l="left"==this.Position||"right"==this.Position,h=this,g=e=>{if(null==a[e])if(s[e].label=h.CreateLabel(i.getCtx(),s[e].text,s[e].coord),a[e]=s[e].label.getDimensions(i),a[e].w>n)s[e].label=null,a[e].w=0,a[e].h=0;else{var t=h._getLabelOverflow(s[e].coord,a[e].w,!1,r);0!=t&&(s[e].coord-=t,a[e].x-=t,s[e].label.setX(s[e].label.getX()-t),h._level1Overflow[e]=t)}return l?a[e].h:a[e].w},d=(g(0)+this.GetTickLabelGapSize())*(s.length-1),u=n>0?Math.ceil(d/n)-1:0,_=!0;_;){for(o=0;o<s.length;o++)o%(u+1)==0?(g(o),s[o].skipped=!1):s[o].skipped=!0;_=this.IsOverlapping(a,u),u++}var c=0;for(o=0;o<e.length;o++)null==e[o]||e[o].skipped||(t[o]=e[o].label,c++);return c}_skipVertLabels(e,t,i){for(var r=.08*this.getTickLabelHeight(),s=(e,t)=>pe._isOverlapping(e.y,e.y+e.h,t.y,t.y+t.h,r),a=null,n=!1,o=0;o<e.length;o++)if(e[o]&&t[o]){if(e[o].alignTop(),t[o].alignBottom(),a&&s(a,t[o].getDimensions())){n=!0;break}a=e[o].getDimensions()}else if(e[o]||t[o]){var l=e[o]?e[o]:t[o];if(a&&s(a,l.getDimensions())){n=!0;break}a=l.getDimensions()}if(n){var h,g=null,d=null,u=null;for(o=0;o<e.length;o++)t[o]?(e[o]=null,t[o].alignMiddle(),h=t[o].getDimensions(),d&&s(d,h)&&(e[g]=null),u=h):e[o]&&(h=e[o].getDimensions(),u&&s(u,h)?e[o]=null:(d=h,g=o))}}getLabels(e,t){return t&&t>1?null:(this._level1Labels||this._generateLabels(e),1==t?this._level2Labels:this._level1Labels)}getMajorTickCoords(){var e=[];if(this._isOneLevel)for(var t=0;t<this._level1Coords.length;t++)null!=this._level1Coords[t]&&null!=this._level1Labels[t]&&e.push(this._level1Coords[t]);else for(t=1;t<this._level2Coords.length;t++)null!=this._level2Coords[t]&&e.push(this._level2Coords[t]);return e}getMinorTickCoords(){if(this._isOneLevel)return[];for(var e=[],t=0;t<this._level1Coords.length;t++)null!=this._level1Coords[t]&&null!=this._level1Labels[t]&&e.push(this._level1Coords[t]);return e}getUnboundedValAt(e){if(null==e)return null;var t=(e-this._startCoord)/(this._endCoord-this._startCoord);if(this._skipGaps){var i=this._timeToIndex(this.MinValue),r=this._timeToIndex(this.MaxValue);return this._indexToTime(i+t*(r-i))}return this.MinValue+t*(this.MaxValue-this.MinValue)}getUnboundedCoordAt(e){if(null==e)return null;var t;if(this._skipGaps){var i=this._timeToIndex(this.MinValue),r=this._timeToIndex(this.MaxValue);t=(this._timeToIndex(e)-i)/(r-i)}else t=(e-this.MinValue)/(this.MaxValue-this.MinValue);return this._startCoord+t*(this._endCoord-this._startCoord)}linearToActual(e){return null==e?null:this._skipGaps?this._indexToTime(e):e}actualToLinear(e){return null==e?null:this._skipGaps?this._timeToIndex(e):e}_timeToIndex(e){for(var t=this._groups.length,i=0;i<this._groups.length;i++)if(e<=this._groups[i]){t=i;break}var r=t-1,s=void 0!==this._groups[r]?this._groups[r]:this._groups[0]-this._averageInterval;return r+(e-s)/((void 0!==this._groups[t]?this._groups[t]:this._groups[this._groups.length-1]+this._averageInterval)-s)}_indexToTime(e){var t=Math.min(Math.max(Math.ceil(e),0),this._groups.length),i=t-1,r=void 0!==this._groups[i]?this._groups[i]:this._groups[0]-this._averageInterval;return r+(e-i)*((void 0!==this._groups[t]?this._groups[t]:this._groups[this._groups.length-1]+this._averageInterval)-r)}getGroupWidth(){return this._skipGaps?Math.abs(this.getUnboundedCoordAt(this._indexToTime(1))-this.getUnboundedCoordAt(this._indexToTime(0))):Math.abs(this.getUnboundedCoordAt(this.MinValue+this._averageInterval)-this.getUnboundedCoordAt(this.MinValue))}getMinExtent(){return this._skipGaps?1:this._mixedFrequency?Math.min((this.getGlobalMax()-this.getGlobalMin())/8,this._averageInterval):this._averageInterval}getStartOverflow(){return"top"!=this.Position&&"bottom"!=this.Position||!t.Agent.isRightToLeft(this.getCtx())?this.StartOverflow:this.EndOverflow}getEndOverflow(){return"top"!=this.Position&&"bottom"!=this.Position||!t.Agent.isRightToLeft(this.getCtx())?this.EndOverflow:this.StartOverflow}static _getAMString(e){var t=e.substring(0,2);if("en-au"==e||"en-ie"==e||"en-ph"==e)return"am";if("en-gb"==e)return"";switch(t){case"en":return"AM";case"ar":return"ص";case"el":return"πμ";case"ko":return"오전";case"zh":return"上午";default:return""}}static _getPMString(e){var t=e.substring(0,2);if("en-au"==e||"en-ie"==e||"en-ph"==e)return"pm";if("en-gb"==e)return"";switch(t){case"en":return"PM";case"ar":return"م";case"el":return"μμ";case"ko":return"오후";case"zh":return"下午";default:return""}}static _getAMPMBefore(e){var t=e.substring(0,2);return"ko"==t||"zh"==t}static _getDMYOrder(e){var t=e.substring(0,2);return"en-us"==e||"en-ph"==e?"MDY":"fa"==t||"hu"==t||"ja"==t||"ko"==t||"lt"==t||"mn"==t||"zh"==t?"YMD":"DMY"}static _getYearTrailingCharacters(e){return 0==e.indexOf("ja")||0==e.indexOf("zh")?"年":0==e.indexOf("ko")?"년":""}static _getDayTrailingCharacters(e){return 0==e.indexOf("ja")||0==e.indexOf("zh")?"日":0==e.indexOf("ko")?"일":""}static _getLabelPos(e,t,i){var r=new Date(e),s=r.getTimezoneOffset();r.setMonth(0,1),r.setHours(0,0,0,0);var a=60*(s-r.getTimezoneOffset())*1e3,n=r.getTime()+a,o=[];if(i>=pe.TIME_YEAR_MIN&&i<=pe.TIME_YEAR_MAX){for(;n<e;)n=pe._addOneYear(n);for(;n<=t;)o.push(n),n=pe._addOneYear(n)}else if(i>=pe.TIME_MONTH_MIN&&i<=pe.TIME_MONTH_MAX){for(;n<e;)n=pe._addOneMonth(n);for(;n<=t;)o.push(n),n=pe._addOneMonth(n)}else for(n+=Math.ceil((e-n)/i)*i;n<=t;)o.push(n),n+=i;return o}static _addOneYear(e){var t=new Date(e);return t.setFullYear(t.getFullYear()+1),t.getTime()}static _addOneMonth(e){var t=new Date(e);return t.setMonth(t.getMonth()+1),t.getTime()}static _getGCDInterval(e){for(var t=(e,i)=>0===e?i:t(i%e,e),i=e[0],r=1;r<e.length;r++)if(1===(i=t(i,e[r])))return 1;return i}static _calculateGranularInterval(e,t,i){var r,s=e.getTimezoneOffset(),a=t.getTimezoneOffset(),n=t.getTime(),o=1e3*(s-a)*60;return o>0&&t.setTime(n+o),r=i===pe.TIME_YEAR_MIN?t.getFullYear()-e.getFullYear():i===pe.TIME_MONTH_MIN?12*(t.getFullYear()-e.getFullYear())+(t.getMonth()-e.getMonth()):Math.round((t.getTime()-e.getTime())/i),o>0&&t.setTime(n),r}static _treatMissingValues(e,t){var i,r,s=new Set,a=!1,n=e,o=[],l=e.length,h=new Date(e[0]);for(r=1;r<l;r++){var g=new Date(e[r]),d=pe._calculateGranularInterval(h,g,t);h=g,o.push(d),d<=0||(s.add(d),i?d!==i&&(a=!0):i=d)}if(a){var u=pe._getGCDInterval([...s]);for((n=[]).push(e[0]),r=1;r<l;r++){var _=e[r],c=e[r-1];if((d=o[r-1])<=u)n.push(_);else{var p,v=d/u,m=v-1,f=Math.round((_-c)/v);for(p=1;p<=m;p++)c+=f,n.push(c);n.push(_),c=_}}}return n}static _isOverlapping(e,t,i,r,s){return i>=e&&i-s<t||i<e&&r+s>e}}pe.TIME_SECOND=1e3,pe.TIME_MINUTE=60*pe.TIME_SECOND,pe.TIME_HOUR=60*pe.TIME_MINUTE,pe.TIME_DAY=24*pe.TIME_HOUR,pe.TIME_MONTH_MIN=28*pe.TIME_DAY,pe.TIME_MONTH_MAX=31*pe.TIME_DAY,pe.TIME_YEAR_MIN=365*pe.TIME_DAY,pe.TIME_YEAR_MAX=366*pe.TIME_DAY,S.registerConstructor("time",pe);const ve={renderBackgroundObjects:(e,t,i)=>{ve._renderObjects(e,t,i,"back")},renderForegroundObjects:(e,t,i)=>{ve._renderObjects(e,t,i,"front")},_renderObjects:(e,t,i,r)=>{ve._renderObjectsForAxis(e,t,i,r,e.xAxis,d.getAxisRefObjs(e,"x")),ve._renderObjectsForAxis(e,t,i,r,e.yAxis,d.getAxisRefObjs(e,"y")),ve._renderObjectsForAxis(e,t,i,r,e.y2Axis,d.getAxisRefObjs(e,"y2"))},_renderObjectsForAxis:(e,t,i,r,s,a)=>{if(a&&s)for(var n=0;n<a.length;n++){var o=a[n];if(v.isObjRendered(e,o)&&(o&&v.getLocation(o)==r)){var l,h,g=v.getType(o);if("area"==g?l=ve._createReferenceArea(o,e,i,s):"line"==g&&(l=ve._createReferenceLine(o,e,i,s),h=ve._createReferenceLine(o,e,i,s,!0)),null!=l){var d=s==e.yAxis?"yAxis":"y2Axis",u=s==e.xAxis?"xAxis":d,_=new x(e,h?[l,h]:[l],o,n,u);e.registerObject(_),e.getEventManager().associate(l,_),t.addChild(l),h&&t.addChild(h)}}}},_createReferenceArea:(e,i,r,s)=>{var a,n=i.getCtx(),o=s.getPosition(),g="top"==o||"bottom"==o,u="radial"==o,_=v.getColor(i,e),c=v.getLineType(e),p=e.style||e.svgStyle,m=e.className||e.svgClassName;if(null==e.items||s!=i.yAxis&&s!=i.y2Axis){var f=v.getLowVal(e),x=v.getHighVal(e);null!=f&&f!=-1/0||(f=s.getInfo().getGlobalMin()),null!=x&&x!=1/0||(x=s.getInfo().getGlobalMax());var C=ve._getAxisCoord(i,s,f),S=ve._getAxisCoord(i,s,x);if(l.isPolar(i)){var A,b=r.x+r.w/2,y=r.y+r.h/2;if(u)if(w.isGridPolygonal(i)){var M=d.getGroupCount(i),D=t.PolygonUtils.getRegularPolygonPoints(b,y,M,S,0,1),T=t.PolygonUtils.getRegularPolygonPoints(b,y,M,C,0,0);A=t.PathUtils.polyline(D)+t.PathUtils.polyline(T)+t.PathUtils.closePath()}else A=t.PathUtils.moveTo(b,y-S)+t.PathUtils.arcTo(S,S,Math.PI,1,b,y+S)+t.PathUtils.arcTo(S,S,Math.PI,1,b,y-S)+t.PathUtils.moveTo(b,y-C)+t.PathUtils.arcTo(C,C,Math.PI,0,b,y+C)+t.PathUtils.arcTo(C,C,Math.PI,0,b,y-C)+t.PathUtils.closePath();else{var I=i.getRadius(),O=h.polarToCartesian(I,C,r),E=h.polarToCartesian(I,S,r);A=t.PathUtils.moveTo(b,y)+t.PathUtils.lineTo(O.x,O.y)+t.PathUtils.arcTo(I,I,S-C,t.Agent.isRightToLeft(n)?0:1,E.x,E.y)+t.PathUtils.lineTo(E.x,E.y)+t.PathUtils.closePath()}a=new t.Path(n,A)}else{var P;P=g?[C,0,S,0,S,r.h,C,r.h]:[0,C,0,S,r.w,S,r.w,C],a=new t.Polygon(n,P)}a.setSolidFill(_),a.setStyle(p).setClassName(m)}else{var L=e.items,R=[],k=[];if(i.xAxis.isGroupAxis())for(;L.length<d.getGroupCount(i);)L.push(null);for(var B=0;B<L.length;B++){var F=L[B],N=v.getLowVal(F),H=v.getHighVal(F);if(null!=N&&null!=H){var G=s.getUnboundedCoordAt(N),U=s.getUnboundedCoordAt(H),V=i.xAxis.getUnboundedCoordAt(v.getXVal(i,L,B));R.push(new oe(V,U,U)),k.push(new oe(V,G,G))}else R.push(new oe),k.push(new oe)}a=new le(i,!0,r,null,p,m,new t.SolidFill(_),null,c,R,c,k)}return a},_createReferenceLine:(e,i,r,s,a)=>{var n,o=s.getPosition(),l="top"==o||"bottom"==o,g="radial"==o,u="tangential"==o,_=v.getLineWidth(i,e),c=v.getLineType(e),p=v.getColor(i,e),m=e.style||e.svgStyle,f=a?"oj-chart-reference-object-inner-line":e.className||e.svgClassName,x=new t.Stroke(p,1,_,!1,t.Stroke.getDefaultDashProps(e.lineStyle,_)),C=i.getCtx();if(null==e.items||s!=i.yAxis&&s!=i.y2Axis){if(null==e.value)return null;var S=ve._getAxisCoord(i,s,e.value);if(null==S||S==1/0||S==-1/0)return null;a&&(S-=Math.ceil(_/2));var A=r.x+r.w/2,b=r.y+r.h/2;if(g){if(w.isGridPolygonal(i)){var y=t.PolygonUtils.getRegularPolygonPoints(A,b,d.getGroupCount(i),S,0);n=new t.Polygon(C,y)}else n=new t.Circle(C,A,b,S);n.setFill(null)}else if(u){var M=h.polarToCartesian(i.getRadius(),S,r);n=new t.Line(C,A,b,M.x,M.y)}else(n=l?new t.Line(C,S,0,S,r.h):new t.Line(C,0,S,r.w,S)).setPixelHinting(!0);n.setStroke(x),n.setStyle(m).setClassName(f)}else{var D=e.items;if(i.xAxis.isGroupAxis())for(;D.length<d.getGroupCount(i);)D.push(null);for(var T=[],I=0;I<D.length;I++){var O=D[I],E=null;if(null!=O&&("object"!=typeof O?E=O:null!=O.value&&(E=O.value)),null!=E){var P=s.getUnboundedCoordAt(E)-(a?_/2:0),L=i.xAxis.getUnboundedCoordAt(v.getXVal(i,D,I));T.push(new oe(L,P,P))}else T.push(new oe)}n=new le(i,!1,r,null,m,f,null,x,c,T)}return n},_getAxisCoord:(e,t,i)=>{if(t.isGroupAxis()){var r=d.getGroupIdx(e,i);if(r>=0)return t.getUnboundedCoordAt(r)}return isNaN(i)?null:t.getUnboundedCoordAt(i)}},me={_MIN_BUBBLE_SIZE:6,_MAX_BUBBLE_SIZE_RATIO:.5,calcBubbleSizes:(e,i)=>{for(var r,s,a=w.getMinMaxVal(e,"z"),n=a.min,o=a.max,h=me._MIN_BUBBLE_SIZE,g=me._MAX_BUBBLE_SIZE_RATIO*Math.min(i.w,i.h),u=d.getSeriesCount(e),_="withoutRescale"==O.getHideAndShowBehavior(e),c=e.getOptionsCache(),p=0;p<u;p++)if(_||d.isSeriesRendered(e,p))for(var v=d.getSeriesItem(e,p),m=v.items?v.items.length:0,f=0;f<m;f++){var x=v.items[f];if(x){var C=t.LayoutUtils.getBubbleSize(x.z,n,o,h,g);c.putToCachedMap2D("bubbleSizeCache",p,f,C)}}l.isPolar(e)?(r=1/0,s=e.getRadius()):(r=i.w-2.4*w.getTickLabelHeight(e,"y"),s=i.h-1.6*w.getTickLabelHeight(e,"x")),r-=.5*g,s-=.5*g;var S=e.getCache(),A=me._getAxisValueRange(e,"x");S.putToCache("_xAxisBubbleRatio",A/r);var b=me._getAxisValueRange(e,"y");S.putToCache("_yAxisBubbleRatio",b/s)},_getAxisValueRange:(e,i)=>{var r=e.getOptions()[i+"Axis"],s=w.isLog(e,i),a=!s&&"zero"==w.getBaselineScaling(e,i),n=w.getMinMaxVal(e,i,!0),o=r.min;null==o&&(o=a?Math.min(0,n.min):n.min);var l=r.max;return null==l&&(l=a?Math.max(0,n.max):n.max),s&&l>0&&o>0?l==o?6:t.Math.log10(l/o):l==o?60:l-o},sortMarkers:e=>{e.sort(me._compareSize)},sortMarkerInfos:e=>{e.sort(me._compareInfoSize)},_compareSize:(e,t)=>t.getSize()-e.getSize(),_compareInfoSize:(e,t)=>t.size-e.size,checkPixelMap:(e,t,i,r)=>{var s=r/2,a=Math.max(Math.floor(t-s),0),n=Math.max(Math.floor(i-s),0),o=Math.max(Math.ceil(t+s),0),l=Math.max(Math.ceil(i+s),0);return e.isObscured(a,n,o,l)},updatePixelMap:(e,t,i,r,s)=>{var a=.4*r,n=Math.max(Math.round(t-a),0),o=Math.max(Math.round(t+a),0),l=Math.max(Math.round(i-a),0),h=Math.max(Math.round(i+a),0);e.obscure(n,l,o,h,s)}},fe={_MIN_TOUCH_MARKER_SIZE:16,_MIN_CHARS_DATA_LABEL:3,FILTER_THRESHOLD_SCATTER_BUBBLE:1e4,render:(e,t,i)=>{"off"==e.getOptions().plotArea.rendered?fe._renderAxisLines(e,t,i):i.w>0&&i.h>0&&(e._currentMarkers=[],e._currentAreas=[],fe._renderBackgroundObjs(e,t,i),fe._renderTicks(e,t,i),fe._renderForegroundObjs(e,t,i))},_renderBackgroundObjs:(e,i,r)=>{var s=e.getOptions(),a=fe._getBackgroundShape(e,r),n=c.getBackgroundColor(e);if(n?a.setSolidFill(n):a.setInvisibleFill(),i.addChild(a),e.getCache().putToCache("plotAreaBackground",a),O.isPlotAreaDraggable(e)&&a.setClassName("oj-draggable"),s.xAxis.referenceObjects||s.yAxis.referenceObjects||s.y2Axis.referenceObjects){var o=fe.createClippedGroup(e,i,r);ve.renderBackgroundObjects(e,o,r)}if(l.isBLAC(e)){var h=new t.Container(e.getCtx());i.addChild(h),e.__setAreaContainer(h),d.hasAreaSeries(e)&&fe._renderAreas(e,h,r,!1)}},_getBackgroundShape:(e,i)=>{var r,s=e.getCtx();if(l.isPolar(e)){var a=i.x+i.w/2,n=i.y+i.h/2;if(w.isGridPolygonal(e)){var o=t.PolygonUtils.getRegularPolygonPoints(a,n,d.getGroupCount(e),e.getRadius(),0);r=new t.Polygon(s,o)}else r=new t.Circle(s,a,n,e.getRadius())}else r=new t.Rect(s,i.x,i.y,i.w,i.h);return r},_renderTicks:(e,t,i)=>{e.xAxis&&w.isMinorTickRendered(e,"x")&&fe._renderMinorTicks(e,t,e.xAxis,i),e.yAxis&&w.isMinorTickRendered(e,"y")&&fe._renderMinorTicks(e,t,e.yAxis,i),e.y2Axis&&w.isMinorTickRendered(e,"y2")&&fe._renderMinorTicks(e,t,e.y2Axis,i),e.xAxis&&w.isMajorTickRendered(e,"x")&&fe._renderMajorTicks(e,t,e.xAxis,i),e.yAxis&&w.isMajorTickRendered(e,"y")&&fe._renderMajorTicks(e,t,e.yAxis,i),e.y2Axis&&w.isMajorTickRendered(e,"y2")&&fe._renderMajorTicks(e,t,e.y2Axis,i)},_renderAxisLines:(e,t,i)=>{e.xAxis&&e.yAxis&&w.isAxisLineRendered(e,"x")&&fe._renderAxisLine(e,t,e.xAxis,e.yAxis,i),e.xAxis&&e.y2Axis&&w.isAxisLineRendered(e,"x")&&(e.yAxis&&!d.isSplitDualY(e)||fe._renderAxisLine(e,t,e.xAxis,e.y2Axis,i)),e.yAxis&&e.xAxis&&w.isAxisLineRendered(e,"y")&&fe._renderAxisLine(e,t,e.yAxis,e.xAxis,i),e.y2Axis&&e.xAxis&&w.isAxisLineRendered(e,"y2")&&fe._renderAxisLine(e,t,e.y2Axis,e.xAxis,i)},_renderMajorTicks:(e,t,i,r)=>{fe._renderGridlines(e,t,i.getOptions().majorTick,i.getPosition(),i.getMajorTickCoords(),i.getBaselineCoord(),r)},_renderMinorTicks:(e,t,i,r)=>{fe._renderGridlines(e,t,i.getOptions().minorTick,i.getPosition(),i.getMinorTickCoords(),null,r)},_renderAxisLine:(e,t,i,r,s)=>{var a=i.getOptions(),n=a.position,o="bottom"==n||"right"==n||"tangential"==n?r.getMaxCoord():r.getMinCoord();fe._renderGridlines(e,t,a.axisLine,r.getPosition(),[o],null,s)},_renderGridlines:(e,i,r,s,a,n,o)=>{var l=r.lineColor,h=r.lineStyle,g=new t.Stroke(l,1,r.lineWidth,!1,t.Stroke.getDefaultDashProps(h,r.lineWidth)),d=g.getColor();"inherit"!=r.baselineColor&&(d="auto"==r.baselineColor?t.ColorUtils.getDarker(l,.6):r.baselineColor);for(var u=null!=r.baselineWidth?r.baselineWidth:r.lineWidth,_=r.baselineStyle?r.baselineStyle:r.lineStyle,c=new t.Stroke(d,1,u,!1,t.Stroke.getDefaultDashProps(_,u)),p="",v=0;v<a.length;v++){var m=null!=n&&a[v]==n;"radial"==s||"tangential"==s||m?fe._renderGridline(e,i,s,a[v],m?c:g,o):p+="top"==s||"bottom"==s?t.PathUtils.moveTo(a[v],o.y)+t.PathUtils.verticalLineTo(o.y+o.h):t.PathUtils.moveTo(o.x,a[v])+t.PathUtils.horizontalLineTo(o.x+o.w)}if(""!=p){var f=new t.Path(e.getCtx(),p);(!t.Agent.isTouchDevice()||t.Agent.getDevicePixelRatio()>1)&&f.setPixelHinting(!0),f.setStroke(g),f.setMouseEnabled(!1),i.addChild(f)}},_renderGridline:(e,i,r,s,a,n)=>{var o,l=i.getCtx(),h=!t.Agent.isTouchDevice()||t.Agent.getDevicePixelRatio()>1;if("radial"==r){if(w.isGridPolygonal(e)){var g=t.PolygonUtils.getRegularPolygonPoints(0,0,d.getGroupCount(e),s,0);o=new t.Polygon(l,g)}else o=new t.Circle(l,0,0,s);o.setInvisibleFill(),o.setTranslate(n.x+n.w/2,n.y+n.h/2)}else if("tangential"==r){o=new t.Line(l,0,0,e.getRadius()*Math.sin(s),-e.getRadius()*Math.cos(s));var u=s%(Math.PI/2);(u<.001||u>Math.PI/2-.001)&&h&&o.setPixelHinting(!0),o.setTranslate(n.x+n.w/2,n.y+n.h/2)}else o="top"==r||"bottom"==r?new t.Line(l,s,n.y,s,n.y+n.h):new t.Line(l,n.x,s,n.x+n.w,s),h&&o.setPixelHinting(!0);o.setStroke(a),o.setMouseEnabled(!1),i.addChild(o)},_renderForegroundObjs:(e,t,i)=>{var r=e.getOptions(),s=fe.createClippedGroup(e,t,i);fe._renderAxisLines(e,t,i);var a=r.plotArea.borderColor,n=r.plotArea.borderWidth;if(a&&0!=n){var o=fe._getBackgroundShape(e,i);o.setInvisibleFill(),o.setSolidStroke(a,null,n),o.setMouseEnabled(!1),t.addChild(o)}l.isBLAC(e)?(d.hasLineWithAreaSeries(e)&&fe._renderAreas(e,t,i,!0),d.hasBarSeries(e)&&fe._renderBars(e,s,i),d.hasCandlestickSeries(e)&&fe._renderStock(e,s),d.hasBoxPlotSeries(e)&&fe._renderBoxPlot(e,s,i),d.hasLineSeries(e)&&fe._renderLines(e,t,s,i)):l.isScatterBubble(e)&&fe._renderScatterBubble(e,t,s,!0,i),(r.xAxis.referenceObjects||r.yAxis.referenceObjects||r.y2Axis.referenceObjects)&&(s=fe.createClippedGroup(e,t,i),ve.renderForegroundObjects(e,s,i));var h=d.getInitialSelection(e);F.setInitialSelection(e,h),e.highlight(d.getHighlightedCategories(e))},_renderDataLabel:(e,i,r,s,a,n,o,h,g,u)=>{if(!l.isOverview(e)){var _="bar"==d.getSeriesType(e,s),p=l.isHorizontal(e),v={width:p?r.w:u,height:p?u:r.h},m=e.getOptions(),f=m.styleDefaults,x=null!=e.y2Axis,C="on"===m.legend.rendered;_&&e.getOptionsCache().putToCachedMap2D("barDims",s,a,v);var S=c.getDataLabel(e,s,a,n,h,g);if(null!=S){var A=R.getDataLabelPos(e,s,a,n,h,g);if("none"!=A){var b=new t.OutputText(e.getCtx(),S,0,0);b.setMouseEnabled(!1);var y=g?f.stackLabelStyle:c.getDataLabelStyle(e,s,a,n,o,A,h);b.setCSSStyle(y),b.setY(r.y+r.h/2),b.setX(r.x+r.w/2),b.alignCenter(),b.alignMiddle();var M=b.getDimensions(),D=e.getCache().getFromCache("plotAreaDims");D||(D=e.getPlotArea().getDimensions(),e.getCache().putToCache("plotAreaDims",D));var T=(e,t,i,r)=>{var s={x:null,y:null},a=r&&r.xAxis&&("left"==e||"right"==e),n=r&&r.top&&("left"==e||"right"==e),o=r&&((x||!C)&&r.y2Axis||r.legend)&&("top"==e||"bottom"==e),l=r&&r.yAxis&&("top"==e||"bottom"==e);"left"==e?s.x=t.x-i.w/2-c.MARKER_DATA_LABEL_GAP:"right"==e?s.x=t.x+t.w+i.w/2+c.MARKER_DATA_LABEL_GAP:"top"==e?s.y=t.y-i.h/2:"bottom"==e&&(s.y=t.y+t.h+i.h/2+c.MARKER_DATA_LABEL_GAP/2);var h=2*c.MARKER_DATA_LABEL_GAP;return o?s.x=D.x+D.w-i.w/2-h:l?s.x=i.w/2+h:a?s.y=D.y+D.h-i.h/2-h:n&&(s.y=i.h/2+h),s},I=f.dataLabelCollision,O=T(A,r,M);if("fitInBounds"===I){var E=c.getDataLabelCollisions(e,O,M,D,p),P=c.adjustDataLabelPos(A,E,x);P!=A&&l.isBubble(e)&&(y=g?f.stackLabelStyle:c.getDataLabelStyle(e,s,a,n,o,P,h),b.setCSSStyle(y)),O=T(A=P,r,M,E)}if(null!=O.x||null!=O.y)null!=O.x&&b.setX(O.x),null!=O.y&&b.setY(O.y);else{if(_){if(M.w>v.width||M.h>v.height)return;"inLeft"==A?b.setX(r.x+M.w/2+c.MARKER_DATA_LABEL_GAP):"inRight"==A?b.setX(r.x+r.w-M.w/2-c.MARKER_DATA_LABEL_GAP):"inTop"==A?b.setY(r.y+M.h/2+c.MARKER_DATA_LABEL_GAP):"inBottom"==A&&b.setY(r.y+r.h-M.h/2-c.MARKER_DATA_LABEL_GAP/2)}else if(l.isBubble(e)){r.x+=c.MARKER_DATA_LABEL_GAP,r.y+=c.MARKER_DATA_LABEL_GAP,r.h-=2*c.MARKER_DATA_LABEL_GAP,r.w-=2*c.MARKER_DATA_LABEL_GAP;var L=t.TextUtils.getOptimalFontSize(b.getCtx(),b.getTextString(),b.getCSSStyle(),r);if(b.setFontSize(L),!t.TextUtils.fitText(b,r.w,r.h,i,fe._MIN_CHARS_DATA_LABEL))return}if(null!=c.getPattern(e,s,a)){var w=.15*(M=b.getDimensions()).h,k=t.PathUtils.roundedRectangle(M.x-w,M.y,M.w+2*w,M.h,2,2,2,2),B=new t.Path(e.getCtx(),k);B.setSolidFill("#FFFFFF",.9),i.addChild(B)}}if(l.isBar(e)){var F,N=b.getDimensions(),H=!1;if("left"==A&&N.x<0)H=!0,F=r.x-c.MARKER_DATA_LABEL_GAP;else if("right"==A&&N.x+N.w>D.w+c.MARKER_DATA_LABEL_GAP)H=!0,F=D.w-r.w-c.MARKER_DATA_LABEL_GAP;else{if("top"==A&&N.y<0)return;if("bottom"==A&&N.y+N.h>D.y+D.h+c.MARKER_DATA_LABEL_GAP)return}if(H){if(!isNaN(S))return;if(!t.TextUtils.fitText(b,F,r.h,i,1))return;M=b.getDimensions(),"left"==A?b.setX(r.x-M.w/2-c.MARKER_DATA_LABEL_GAP):"right"==A&&b.setX(r.x+r.w+M.w/2+c.MARKER_DATA_LABEL_GAP)}}c.optimizeMarkerStroke(e)&&b.setSolidStroke("none"),i.addChild(b),e.addDataLabel(b)}}}},_renderDataLabelForMarker:(e,i,r)=>{var s=e.getEventManager().getLogicalObject(r);if(s){var a=s.getSeriesIndex(),n=s.getGroupIndex(),o=s.getNestedDataItemIndex();if(r instanceof t.SimpleMarker){var l=new t.Rectangle(r.getCx()-r.getWidth()/2,r.getCy()-r.getHeight()/2,r.getWidth(),r.getHeight());fe._renderDataLabel(e,i,l,a,n,o,r.getDataColor())}else r instanceof de&&(fe._renderDataLabel(e,i,r.getBoundingBox1(),a,n,o,r.getDataColor(),"low"),fe._renderDataLabel(e,i,r.getBoundingBox2(),a,n,o,r.getDataColor(),"high"))}},_renderScatterBubble:(e,i,r,s,a)=>{var n,o=fe._filterScatterBubble(e,s),h=d.getSeriesCount(e);for(n=0;n<h;n++)"none"!=c.getLineType(e,n)&&fe._renderLinesForSeries(e,r,n,a);var g=c.getMarkerBorderColor(e),u=c.getBorderWidth(e),_=new t.Stroke(g,1,u),p=[];if(o)for(var v=c.optimizeMarkerStroke(e),m=v?_.getColor():null,f=v?_.getWidth():null,x=0;x<o.length;x++){var C=o[x],S=fe._createMarker(e,C,m,f);p.push(S)}else{for(n=0;n<h;n++){var A=fe._getMarkersForSeries(e,n,a,_);p=p.concat(A)}s&&me.sortMarkers(p)}l.isBubble(e)?fe._addMarkersToContainer(e,r,p,_):fe._addMarkersToContainer(e,i,p,_)},_renderMarkersForSeries:(e,i,r,s)=>{var a,n=c.getMarkerBorderColor(e,r),o=c.getBorderWidth(e,r),l=new t.Stroke(n,1,o);a=d.isRangeSeries(e,r)?fe._getRangeMarkersForSeries(e,r,s):fe._getMarkersForSeries(e,r,s,l),fe._addMarkersToContainer(e,i,a,l)},_addMarkersToContainer:(e,i,r,s)=>{var a=i,n=c.optimizeMarkerStroke(e),o=c.optimizeMarkerFill(e);(n||o)&&(a=new t.Container(e.getCtx()),n?a.setStroke(s):a.setInvisibleFill(),i.addChild(a));for(var l=0;l<r.length;l++)a.addChild(r[l]),fe._renderDataLabelForMarker(e,a,r[l]);e._currentMarkers.push(r)},_getMarkerInfo:(e,i,r,s,a)=>{var n=e.getOptions(),o=d.getVal(e,i,r,s);if(null==o||isNaN(o))return null;if(d.isDataItemFiltered(e,i,r))return null;var h=d.getGroupCount(e),g=c.isMarkerDisplayed(e,i,r,s);if(!g&&(null==s||s<0)){var u=h-1,_=l.isPolar(e),p=_&&u>0&&0==r?u:r-1,v=_&&u>0&&r==u?0:r+1,m=d.getVal(e,i,p),f=d.getVal(e,i,v);null!=m&&!isNaN(m)||null!=f&&!isNaN(f)||(g=!0)}if(!g&&(l.isSpark(e)||(n._duringZoomAndScroll||l.isOverview(e))&&!d.isDataSelected(e,i,r,s)))return null;if(!d.isDataItemRendered(e,i,r,s))return!1;var x=!0,C=d.getMarkerPos(e,i,r,s,a),S=c.getMarkerSize(e,i,r,s);return a&&C&&S&&(x=a.intersects(new t.Rectangle(C.x-S/2,C.y-S/2,S,S))),C&&x?{seriesIndex:i,groupIndex:r,itemIndex:s,x:C.x,y:C.y,size:S,markerDisplayed:g}:null},_getScatterBubbleMarkerInfo:(e,t,i)=>{if(!d.isDataItemRendered(e,t,i))return!1;var r=d.getScatterBubbleMarkerPos(e,t,i);if(!r)return null;var s=c.getMarkerSize(e,t,i);return s?{seriesIndex:t,groupIndex:i,x:r.x,y:r.y,size:s}:null},_getMarkersForSeries:(e,t,i,r)=>{if(!d.isSeriesRendered(e,t))return[];for(var s=c.optimizeMarkerStroke(e),a=s?r.getColor():null,n=s?r.getWidth():null,o=[],l=d.getGroupCount(e),h=0;h<l;h++){var g=fe._getMarkerInfo(e,t,h,null,i);if(g){var u=fe._createMarker(e,g,a,n);null!=u&&o.push(u)}}return o},_createMarker:(e,i,r,s)=>{var a,n=t.Agent.isTouchDevice(),o=e.getCtx(),h=c.optimizeMarkerStroke(e),g=c.optimizeMarkerFill(e),d=i.seriesIndex,u=i.groupIndex,_=i.itemIndex,p=c.getMarkerColor(e,d,u,_),v=c.getMarkerShape(e,d,u,_),m=i.markerDisplayed;if(null==m&&(m=c.isMarkerDisplayed(e,d,u,_)),m){var x=c.getImageSource(e,d,u,_,"source");if(x){var C=c.getImageSource(e,d,u,_,"sourceSelected"),S=c.getImageSource(e,d,u,_,"sourceHover"),A=c.getImageSource(e,d,u,_,"sourceHoverSelected");a=new t.ImageMarker(o,i.x,i.y,i.size,i.size,null,x,C,S,A),c.isSelectable(e,d,u)&&a.setCursor(t.SelectionEffectUtils.getSelectingCursor())}else{(a=new t.SimpleMarker(o,v,i.x,i.y,i.size,i.size,null,null,!0)).setFill(k.getMarkerFill(e,d,u,_));var b=c.getBorderColor(e,d,u,_),y=c.getDefaultMarkerBorderColor(e,d,u,_),M=c.getUserBorderWidth(e,d,u,_),D=c.getDefaultMarkerBorderWidth(e,d,u,_),T=b||y,I=null!==M?M:D;if(T===r&&I===s||a.setSolidStroke(T,null,I),a.setDataColor(p,!0),"redwood"===e.getCtx().getThemeBehavior())l.isBubble(e)&&a.addClassName("oj-dvt-bubble-marker"),b||l.isBubble(e)||a.addClassName("oj-dvt-default-border-color"),null==M&&a.addClassName("oj-dvt-default-border-width"),c.isSelectable(e,d,u)&&(a.setCursor(t.SelectionEffectUtils.getSelectingCursor()),l.isBubble(e)?a.setFeedbackClassName("oj-dvt-selectable"):a.setFeedbackClassName("oj-dvt-selectable-marker"));else{c.isSelectable(e,d,u)&&a.setCursor(t.SelectionEffectUtils.getSelectingCursor());var O=t.SelectionEffectUtils.getHoverBorderColor(p),E=c.getSelectedInnerColor(e),P=c.getSelectedOuterColor(e);a.setHoverStroke(new t.Stroke(E,1,1),new t.Stroke(O,1,3.5)),a.setSelectedStroke(new t.Stroke(E,1,1.5),new t.Stroke(P,1,4.5)),a.setSelectedHoverStroke(new t.Stroke(E,1,1.5),new t.Stroke(O,1,4.5))}a.addClassName(c.getMarkerClassName(e,d,u,_)),a.setStyle(c.getMarkerStyle(e,d,u,_))}n&&i.size<fe._MIN_TOUCH_MARKER_SIZE&&fe._addMarkerHitArea(a,i.x,i.y,h)}else c.isSelectable(e,d,u)?((a=new he(o,v,i.x,i.y,i.size,h)).setCursor(t.SelectionEffectUtils.getSelectingCursor()),n&&fe._addMarkerHitArea(a,i.x,i.y,h)):(n&&(i.size=fe._MIN_TOUCH_MARKER_SIZE),a=new he(o,t.SimpleMarker.SQUARE,i.x,i.y,i.size,h)),g||a.setInvisibleFill(),a.setDataColor(p);return f.associate(a,e,d,u,_,i),a},_addMarkerHitArea:(e,i,r,s)=>{var a=new t.Rect(e.getCtx(),i-fe._MIN_TOUCH_MARKER_SIZE/2,r-fe._MIN_TOUCH_MARKER_SIZE/2,fe._MIN_TOUCH_MARKER_SIZE,fe._MIN_TOUCH_MARKER_SIZE);s&&a.setSolidStroke("none"),a.setInvisibleFill(),e.addChild(a)},_getRangeMarkersForSeries:(e,i,r)=>{if(!d.isSeriesRendered(e,i))return[];for(var s=t.Agent.isTouchDevice(),a=e.getCtx(),n=e.xAxis,o=d.isAssignedToY2(e,i)?e.y2Axis:e.yAxis,g=e.getOptions(),u=d.getGroupCount(e),_=[],p=0;p<u;p++)if(!d.isDataItemFiltered(e,i,p)&&d.isDataItemRendered(e,i,p)){var v=n.getCoordAt(d.getXVal(e,i,p)),m=o.getUnboundedCoordAt(d.getLowVal(e,i,p)),x=o.getUnboundedCoordAt(d.getHighVal(e,i,p));if(null!=v&&null!=m&&null!=x){var C=c.isMarkerDisplayed(e,i,p);if(!C){var S=u-1,A=l.isPolar(e),b=A&&S>0&&0==p?S:p-1,y=A&&S>0&&p==S?0:p+1,M=d.getLowVal(e,i,b),D=d.getHighVal(e,i,b),T=d.getLowVal(e,i,y),I=d.getHighVal(e,i,b);null==M&&null==D&&null==T&&null==I&&(C=!0)}if(!(g._duringZoomAndScroll||l.isOverview(e)||l.isSpark(e))||C||d.isDataSelected(e,i,p)){var O=h.convertAxisCoord(e,new t.Point(v,m),r),E=h.convertAxisCoord(e,new t.Point(v,x),r),P=new t.Point((O.x+E.x)/2,(O.y+E.y)/2),L=c.getMarkerSize(e,i,p),w=new de(a,O.x,O.y,E.x,E.y,L,!C),R=k.getMarkerFill(e,i,p),B=c.getMarkerBorderColor(e,i,p),F=c.getBorderWidth(e,i,p),N=new t.Stroke(B,1,F),H=c.getMarkerColor(e,i,p),G=c.getSelectedInnerColor(e),U=c.getSelectedOuterColor(e);w.setStyleProperties(R,N,H,G,U),c.isSelectable(e,i,p)&&w.setCursor(t.SelectionEffectUtils.getSelectingCursor());var V=new t.Line(a,O.x,O.y,E.x,E.y);V.setSolidStroke("rgba(0,0,0,0)",null,s?Math.max(L,fe._MIN_TOUCH_MARKER_SIZE):L),w.addChild(V),_.push(w),f.associate(w,e,i,p,null,P)}}}return _},_renderBars:(e,i,r)=>{var s=l.isHorizontal(e),a=l.isPolar(e),n=l.isStock(e),o="pixel"==c.getBarSpacing(e),h=t.Agent.isRightToLeft(e.getCtx()),g=c.isStackLabelRendered(e),u=d.isStacked(e);d.getSeriesCount(e)<2&&g&&(u=!0);for(var _=c.getSelectedInnerColor(e),p=c.getSelectedOuterColor(e),v=e.getOptions()._duringZoomAndScroll,m=c.getGroupWidth(e),x={},C=0;C<d.getSeriesCount(e);C++)if("bar"==d.getSeriesType(e,C)){fe._filterPointsForSeries(e,C);for(var S="",A=e.getOptionsCache().getFromCachedMap("itemStyleSet",C),b=d.getStackCategory(e,C)||"",y=d.isAssignedToY2(e,C),M=w.getViewportMinMaxGroupIdx(e,C),D=M.min-1;D<=M.max+1;D++)if(!d.isDataItemFiltered(e,C,D)&&d.isDataItemRendered(e,C,D)&&0!=d.getZVal(e,C,D)){var T=R.getBarInfo(e,C,D,r);if(null!=T){var I=T.yCoord,O=T.baseCoord,E=T.axisCoord,P=T.x1,L=T.x2,B=T.barWidth;if(u){var F=""+D+b+y+(d.getVal(e,C,D)<0);if(Math.abs(O-I)<.5&&Math.abs(I-x[F])<.5&&!d.isOutermostBar(e,C,D))continue;x[F]&&(O=x[F]),x[F]=I}var N,H=!1;if(Math.abs(I-O)<1&&(d.isRangeSeries(e,C)?I--:u&&!d.isOutermostBar(e,C,D)||(H=!0,I=I>O||s&&!h&&I==O?O+3:O-3)),a)N=new ge(e,E,O,I,P,L,r);else{var G=v&&m<5&&!A;if(N=new se(e,E,O,I,P,L,G),G){var U=N.getBoundingBox();S+=t.PathUtils.moveTo(U.x,U.y)+t.PathUtils.horizontalLineTo(U.x+U.w)+t.PathUtils.verticalLineTo(U.y+U.h)+t.PathUtils.horizontalLineTo(U.x)+t.PathUtils.closePath();continue}}i.addChild(N),c.isSelectable(e,C,D)&&N.setCursor(t.SelectionEffectUtils.getSelectingCursor());var V,Y=null;if(H)V=t.SolidFill.invisibleFill();else{V=k.getBarFill(e,C,D,B);var W=c.getBorderColor(e,C,D),j=c.getBorderWidth(e,C,D);W&&(Y=new t.Stroke(W,1,j))}var z=c.getColor(e,C,D),X=c.getClassName(e,C,D),Z=c.getStyle(e,C,D);N.setStyleProperties(V,Y,z,_,p,X,Z),o&&N.setPixelHinting(!0),f.associate(N,e,C,D,null,T.dataPos),d.isRangeSeries(e,C)?(fe._renderDataLabel(e,i,N.getBoundingBox(),C,D,null,z,"low",!1,N.getOriginalBarSize()),fe._renderDataLabel(e,i,N.getBoundingBox(),C,D,null,z,"high",!1,N.getOriginalBarSize())):fe._renderDataLabel(e,i,N.getBoundingBox(),C,D,null,z,null,!1,N.getOriginalBarSize());var K=[];K.push(N),n&&0!=C||e._currentMarkers.push(K),g&&d.isOutermostBar(e,C,D)&&fe._renderDataLabel(e,i,N.getBoundingBox(),C,D,null,null,null,!0,N.getOriginalBarSize())}}if(S){var q=new t.Path(e.getCtx(),S),Q=c.getColor(e,C);q.setSolidFill(Q);var J=c.getBorderColor(e,C);if(J){var $=c.getBorderWidth(e,C);q.setSolidStroke(J,null,$)}var ee=c.getClassName(e,C),te=c.getStyle(e,C);q.setClassName(ee).setStyle(te),o&&q.setPixelHinting(!0),i.addChild(q)}}},_renderStock:(e,i)=>{var r=e.getOptions(),s=e.xAxis,a=e.yAxis;if("candlestick"==d.getSeriesType(e,0))for(var n=w.getViewportMinMaxGroupIdx(e,0),o=n.min-1;o<=n.max+1;o++)if(d.isDataItemRendered(e,0,o)){var l=d.getDataItem(e,0,o);if(l){var h=l.open,g=l.close,u=l.low,_=l.high,p=null!=u&&null!=_;if(null!=h&&null!=g){var v,m=d.getXVal(e,0,o),x=s.getUnboundedCoordAt(m),C=c.getBarWidth(e,0,o),S=a.getBoundedCoordAt(h),A=a.getBoundedCoordAt(g),b=null;p&&(v=a.getBoundedCoordAt(u),b=a.getBoundedCoordAt(_));var y=new ne(e.getCtx(),x,C,S,A,v,b);i.addChild(y),c.isSelectable(e,0,o)&&y.setCursor(t.SelectionEffectUtils.getSelectingCursor());var M=k.getBarFill(e,0,o,C),D=null,T=c.getBorderColor(e,0,o),I=c.getBorderWidth(e,0,o);T?D=new t.Stroke(T,1,I):M instanceof t.PatternFill&&(D=new t.Stroke(M.getColor(),1,I));var O=c.getColor(e,0,o),E=c.getSelectedInnerColor(e),P=c.getSelectedOuterColor(e),L=r.styleDefaults.stockRangeColor;y.setChangeStyle(M,D,O,E,P),y.setRangeStyle(new t.SolidFill(L),D,L,P);var R=new t.Point(x,(S+A)/2);f.associate(y,e,0,o,null,R);var B=[];B.push(y._changeShape),e._currentMarkers.push(B)}}}},_renderBoxPlot:(e,i,r)=>{for(var s=e.xAxis,a=0;a<d.getSeriesCount(e);a++)for(var n=w.getViewportMinMaxGroupIdx(e,a),o=n.min-1;o<=n.max+1;o++)if(d.isDataItemRendered(e,a,o)&&"boxPlot"==d.getSeriesType(e,a)){var g=d.getDataItem(e,a,o);if(g){var u=g.low,_=g.q1,p=g.q2,v=g.q3,m=g.high;if(null!=u&&null!=_&&null!=p&&null!=v&&null!=m){var x=c.getBarWidth(e,a,o),C=c.getBarCategoryOffsetMap(e,o),S=d.isAssignedToY2(e,a),A=d.getStackCategory(e,a),b=C[S?"y2":"y"][A]+x/2;t.Agent.isRightToLeft(e.getCtx())&&l.isVertical(e)&&(b*=-1);var y=d.getXVal(e,a,o),M=s.getUnboundedCoordAt(y)+b,D=S?e.y2Axis:e.yAxis,T=D.getBoundedCoordAt(u),I=D.getBoundedCoordAt(_),O=D.getBoundedCoordAt(p),E=D.getBoundedCoordAt(v),P=D.getBoundedCoordAt(m),L=c.getBoxPlotStyleOptions(e,a,o),R=new ae(e,M,x,T,I,O,E,P,L);i.addChild(R),c.isSelectable(e,a,o)&&R.setCursor(t.SelectionEffectUtils.getSelectingCursor());var k=h.convertAxisCoord(e,new t.Point(M,O),r);f.associate(R,e,a,o,null,k),fe._renderBoxPlotMarkers(e,i,a,o,r,M),e._currentMarkers.push([R._medianLine])}}}},_renderBoxPlotMarkers:(e,i,r,s,a,n)=>{for(var o=c.getMarkerBorderColor(e,r,s),h=c.getBorderWidth(e,r,s),g=new t.Stroke(o,1,h),u=[],_=d.getNestedDataItemCount(e,r,s),p=0;p<_;p++){var v=fe._getMarkerInfo(e,r,s,p,a);if(v){l.isHorizontal(e)?v.y=n:v.x=n;var m=fe._createMarker(e,v,o,h);null!=m&&u.push(m)}}fe._addMarkersToContainer(e,i,u,g)},_renderLines:(e,t,i,r)=>{var s,a=[],n=d.getSeriesCount(e);for(s=0;s<n;s++)d.isSeriesRendered(e,s)&&"line"==d.getSeriesType(e,s)&&a.push(s);for(var o=0;o<a.length;o++)s=a[o],"none"!=c.getLineType(e,s)&&(fe._filterPointsForSeries(e,s),fe._renderLinesForSeries(e,i,s,r));for(o=0;o<a.length;o++)fe._renderMarkersForSeries(e,t,a[o],r)},_renderAreas:(e,t,i,r)=>{for(var s=d.getSeriesCount(e),a=r?"lineWithArea":"area",n=[],o=[],l=0;l<s;l++)d.isSeriesRendered(e,l)&&d.getSeriesType(e,l)==a&&(d.isAssignedToY2(e,l)?o.push(l):n.push(l));n.length>0&&fe._renderAreasForAxis(e,t,n,e.yAxis.getBaselineCoord(),i,r),o.length>0&&fe._renderAreasForAxis(e,t,o,e.y2Axis.getBaselineCoord(),i,r)},_renderAreasForAxis:(e,i,r,s,a,n)=>{for(var o=d.isStacked(e),l=fe.createClippedGroup(e,i,a),h={},g={},u={},_={},p=[],v=d.getGroupCount(e),m=0;m<v;m++)p.push(new oe(null,s,s,m,d.getGroup(e,m),!0));for(var x=0;x<r.length;x++){var C=r[x],S=d.getStackCategory(e,C),A=d.isSeriesNegative(e,C),b=h[S],y=g[S],M=u[S],D=_[S];if("none"!=c.getLineType(e,C)){var T,I,O,E=k.getAreaFill(e,C),P=c.getBorderColor(e,C),L=c.getBorderWidth(e,C),w=c.getAreaClassName(e,C),R=c.getAreaStyle(e,C),B=P?new t.Stroke(P,1,L):null,F=c.getLineType(e,C);fe._filterPointsForSeries(e,C),d.isRangeSeries(e,C)?(T=fe._getCoordsForSeries(e,C,a,"high"),I=fe._getCoordsForSeries(e,C,a,"low"),O=F):A?(T=fe._getAreaCoordsForSeries(e,C,a,M||p),I=M||[],O=D):(T=fe._getAreaCoordsForSeries(e,C,a,b||p),I=b||[],O=y);var N=new le(e,!0,a,s,R,w,E,B,F,T,O,I);l.addChild(N),e._currentAreas.push(N),f.associate(N,e,C),A?(u[S]=T,_[S]=F):(h[S]=T,g[S]=F),o||((n||c.getDataItemGaps(e)>0&&!P)&&fe._renderLinesForSeries(e,l,C,a,!n),n||fe._renderMarkersForSeries(e,i,C,a),x+1<r.length&&(l=fe.createClippedGroup(e,i,a)))}else fe._renderMarkersForSeries(e,i,C,a)}for(x=0;x<r.length;x++)if(C=r[x],"none"!=c.getLineType(e,C)){var H=c.getBorderColor(e,C)||c.getBorderColor(e,C+1);o&&(n||c.getDataItemGaps(e)>0&&!H)&&fe._renderLinesForSeries(e,l,C,a,!n),(o||n)&&fe._renderMarkersForSeries(e,i,C,a)}},_getAreaCoordsForSeries:(e,t,i,r)=>{for(var s=fe._getCoordsForSeries(e,t,i),a=[],n=0;n<r.length;n++)a.push(r[n].clone());for(var o=s.length-1,h=l.isPolar(e),g=0;g<s.length;g++)if(null!=s[g].x){var d=a[s[g].groupIndex],u=h&&0==g?o:g-1,_=h&&g==o?0:g+1;u>=0&&null!=s[u].x&&(d.y1=s[g].y1),_<=o&&null!=s[_].x&&(d.y2=s[g].y2),d.x=s[g].x,d.filtered=d.y1==d.y2&&s[g].filtered}return a},_renderLinesForSeries:(e,i,r,s,a)=>{var n;if(a){var o=2.5*c.getDataItemGaps(e);n=new t.Stroke(c.getBackgroundColor(e,!0),1,o)}else{var l=c.getColor(e,r),h=c.getLineWidth(e,r),g=c.getLineStyle(e,r);n=new t.Stroke(l,1,h,!1,t.Stroke.getDefaultDashProps(g,h))}var u=d.isAssignedToY2(e,r)?e.y2Axis.getBaselineCoord():e.yAxis.getBaselineCoord(),_=c.getLineType(e,r),p=c.getClassName(e,r),v=c.getStyle(e,r),m=t=>{var a=fe._getCoordsForSeries(e,r,s,t),o=new le(e,!1,s,u,v,p,null,n,_,a);i.addChild(o),f.associate(o,e,r)};d.isRangeSeries(e,r)?(m("high"),m("low")):m("value")},_filterScatterBubble:(e,i)=>{var r,s=d.getSeriesCount(e),a=d.getGroupCount(e);if(s*a<fe.FILTER_THRESHOLD_SCATTER_BUBBLE)return null;for(var n=[],o=0;o<s;o++)if(d.isSeriesRendered(e,o))for(var l=0;l<a;l++)null!=(r=fe._getScatterBubbleMarkerInfo(e,o,l))&&n.push(r);if(n.length<fe.FILTER_THRESHOLD_SCATTER_BUBBLE)return null;i&&me.sortMarkerInfos(n);for(var h=new t.PixelMap(25,new t.PixelMap(5,new t.PixelMap)),g=[],u=n.length-1;u>=0;u--){if(r=n[u],!me.checkPixelMap(h,r.x,r.y,r.size)){var _=c.getColor(e,r.seriesIndex,r.groupIndex),p=c.isMarkerDisplayed(e,o,l)?t.ColorUtils.getAlpha(_):0;p>0&&(me.updatePixelMap(h,r.x,r.y,r.size,p),g.push(r))}}return e.getCache().putToCache("dataFiltered",!0),g.reverse(),g},_filterPointsForSeries:(e,t)=>{if(!l.isPolar(e)&&!d.isRangeSeries(e,t)){var i,r=e.__getPlotAreaSpace(),s=l.isHorizontal(e)?r.h:r.w,a=d.getSeriesItem(e,t).items,n="bar"==d.getSeriesType(e,t),o=e.xAxis.getInfo(),h=(o.getDataMax()-o.getDataMin())/(o.getViewportMax()-o.getViewportMin()),g=n?.5:2,u=h?Math.round(g*(a.length/h)/s):1;if(u<(n?2:3))for(var _=0;_<a.length;_++)(i=a[_])&&(i._filtered=!1);else{for(var c,p,v,m,f,x=!1,C=0;C<a.length;C+=u){c=-1,p=-1/0,v=-1,m=1/0;for(var S=C;S<Math.min(C+u,a.length);S++)f=d.getCumulativeVal(e,t,S),i=a[S],null!=f&&null!=i&&((!n||f>0)&&f>p&&(c=S,p=f),(!n||f<0)&&f<m&&(v=S,m=f),i._filtered=!0,x=!0);for(var A=C;A<Math.min(C+u,a.length);A++)null!=(i=a[A])&&(A!=c&&A!=v||(i._filtered=!1))}e.getCache().putToCache("dataFiltered",x)}}},_getCoordsForSeries:(e,t,i,r)=>{var s=e.xAxis,a=e.yAxis;d.isAssignedToY2(e,t)&&(a=e.y2Axis);for(var n=[],o=w.getViewportMinMaxGroupIdx(e,t),h=o.min-1;h<=o.max+1;h++){var g=d.getGroup(e,h);if(null!=g){var u=d.getXVal(e,t,h),_=null;if("low"==r?_=d.getLowVal(e,t,h):"high"==r?_=d.getHighVal(e,t,h):null!=d.getVal(e,t,h)&&(_=d.getCumulativeVal(e,t,h)),null!=_&&!isNaN(_)&&d.isDataItemRendered(e,t,h)){l.isPolar(e)&&(_=Math.max(_,a.getInfo().getViewportMin()));var c=s.getUnboundedCoordAt(u),p=a.getUnboundedCoordAt(_);if(null!=c&&null!=p){var v=new oe(c,p,p,h,g,d.isDataItemFiltered(e,t,h));n.push(v)}else n.push(new oe(null,null,null,h,g,!1))}else n.push(new oe(null,null,null,h,g,!1))}}return n},createClippedGroup:(e,i,r)=>{var s=new t.Container(i.getCtx());i.addChild(s);var a=new t.ClipPath(e.getId()),n=fe._extendClipGroup(e);if(l.isPolar(e)){var o=r.x+r.w/2,h=r.y+r.h/2;if(w.isGridPolygonal(e)){var g=t.PolygonUtils.getRegularPolygonPoints(o,h,d.getGroupCount(e),e.getRadius(),0);a.addPolygon(g)}else a.addCircle(o,h,e.getRadius())}else l.isHorizontal(e)?a.addRect(r.x-n,r.y,r.w+2*n,r.h):a.addRect(r.x,r.y-n,r.w,r.h+2*n);return s.setClipPath(a),s},_extendClipGroup:e=>{if((d.hasLineSeries(e)||d.hasLineWithAreaSeries(e))&&!l.isSpark(e)){var t=c.getLineWidth(e),i=e=>{var i=e.getInfo(),r=i.getCoordAt(i.getGlobalMax()),s=i.getCoordAt(i.getDataMax()),a=i.getCoordAt(i.getGlobalMin()),n=i.getCoordAt(i.getDataMin());return null!=r&&null!=s&&s-r<=t/2||null!=a&&null!=n&&a-n<=t/2};if(e.yAxis&&i(e.yAxis)||e.y2Axis&&i(e.y2Axis))return Math.ceil(t/2)}return 0}};class xe{constructor(e,t){this._context=e.getCtx(),this._dataCursorShown=!1,this._dataCursor=t,this._chart=e}processMove(e,t){var i=this._chart.__getPlotAreaSpace();return i&&i.containsPoint(e.x,e.y)&&!this._chart.getOptions()._duringZoomAndScroll?(this._showDataCursor(i,e.x,e.y,t),!0):(this._removeDataCursor(t),!1)}processEnd(e){this._removeDataCursor(e)}processOut(e,t){var i=this._chart.__getPlotAreaSpace();i&&!i.containsPoint(e.x,e.y)&&this._removeDataCursor(t)}_showDataCursor(e,i,r,s){if(this._context.isOffscreen(!0))this._removeDataCursor(s);else{var a=this._dataCursor,n=this._getClosestMatch(i,r);if(null!=n){var o=n.matchRegion.getCenter(),l=i,h=r;"snap"===a.getBehavior()&&(a.isHorizontal()?h=Math.min(Math.max(o.y,e.y),e.y+e.h):l=Math.min(Math.max(o.x,e.x),e.x+e.w));var g=n.logicalObject,d=m.getDatatip(this._chart,g.getSeriesIndex(),g.getGroupIndex(),g.getNestedDataItemIndex(),!0);if(null!=d){a.setVisible(!0);var u=m.getDatatipColor(this._chart,g.getSeriesIndex(),g.getGroupIndex(),g.getNestedDataItemIndex()),_=a.isHorizontal()?h:l,c=g.getDisplayables()[0];if(c instanceof t.SimpleMarker&&a.addMarker(c.getType(),c.getSize()),a.render(e,o.x,o.y,_,d,u),this._dataCursorShown=!0,!s){var p=this._chart.getValsAt(i,r);this._chart.changeOption("dataCursorPosition",p)}}else a.setVisible(!1)}else this._removeDataCursor(s)}}_removeDataCursor(e){this._dataCursor.getVisible()&&this._dataCursor.setVisible(!1),this._context.getTooltipManager(p.TOOLTIP_ID).hideTooltip(),this._dataCursorShown=!1,e||this._chart.changeOption("dataCursorPosition",null)}isDataCursorShown(){return this._dataCursorShown}static _getClosestMatchSecondDirection(e,t,i,r){for(var s=null,a=1/0,n=e.length-1;0<=n;n--){var o=e[n],l=t?i:r,h=((t?o.matchRegion.x:o.matchRegion.y)+(t?o.matchRegion.x+o.matchRegion.w:o.matchRegion.y+o.matchRegion.h))/2,g=Math.round(Math.abs(h-l));g<a&&(a=g,s=o)}return s}static _getClosestMatchesFirstDirection(e,t,i,r,s){for(var a=1/0,n=new Array,o=0;o<e.length;o++){var l=e[o];if(s(l.logicalObject)){var h=l.matchRegion,g=t?r:i,d=((t?h.y:h.x)+(t?h.y+h.h:h.x+h.w))/2,u=Math.round(Math.abs(d-g));u<=a&&(u<a&&(n=new Array),n.push(l),a=u)}}return n}_findMatches(){var e=this._context.getStage(),t=this._chart.getEventManager(),i=[];if(!this._chart._currentMarkers)return null;for(var r=0;r<this._chart._currentMarkers.length;r++)for(var s=this._chart._currentMarkers[r],a=s.length,n=0;n<a;n++){var o=s[n],l=t.GetLogicalObject(o),h={matchRegion:o.getDimensionsSelf?o.getDimensionsSelf(e):o.getDimensions(e),logicalObject:l};i.push(h)}return i}_getClosestMatch(e,i){var r=l.isHorizontal(this._chart),s=l.isLineArea(this._chart)&&!l.isMixedFrequency(this._chart),a=this._findMatches(),n=d.getHighlightedCategories(this._chart),o="all"==this._chart.getOptions().highlightMatch,h=n.length>0?o?t.ArrayUtils.hasAllItems:t.ArrayUtils.hasAnyItem:null,g=e=>!h||h(e.getCategories(),n),u=xe._getClosestMatchesFirstDirection(a,r,e,i,g);if(!l.isScatterBubble(this._chart)){for(var _=1/0,c=-1/0,p=null,v=0;v<u.length;v++){var m=u[v];_=Math.min(_,r?m.matchRegion.y:m.matchRegion.x),c=Math.max(c,r?m.matchRegion.y+m.matchRegion.h:m.matchRegion.x+m.matchRegion.w),p=m.logicalObject.getGroupIndex()}for(v=0;v<a.length;v++){var f=a[v];if(g(f.logicalObject))if(s)f.logicalObject.getGroupIndex()==p&&u.push(f);else{var x=((r?f.matchRegion.y:f.matchRegion.x)+(r?f.matchRegion.y+f.matchRegion.h:f.matchRegion.x+f.matchRegion.w))/2;c>=x&&_<=x&&u.push(f)}}}return xe._getClosestMatchSecondDirection(u,r,e,i)}}class Ce extends I{axisToPlotArea(e){if("tangential"==this.getOptions().position)return e;if(null==e)return null;var t=e-this.getLeftOverflow();return Math.round(10*t)/10}plotAreaToAxis(e,t){if("tangential"==this.getOptions().position)return e;if(null==e)return null;var i=e+this.getLeftOverflow();return!1===t?i:Math.round(i)}linearToActual(e){return this.Info.linearToActual(e)}actualToLinear(e){return this.Info.actualToLinear(e)}getValAt(e){return this.Info.getValAt(this.plotAreaToAxis(e))}getCoordAt(e){return this.axisToPlotArea(this.Info.getCoordAt(e))}getBoundedCoordAt(e){return this.axisToPlotArea(this.Info.getBoundedCoordAt(e))}getUnboundedValAt(e){return this.Info.getUnboundedValAt(this.plotAreaToAxis(e))}getUnboundedCoordAt(e){return this.axisToPlotArea(this.Info.getUnboundedCoordAt(e))}getBaselineCoord(){return this.axisToPlotArea(this.Info.getBaselineCoord())}getPosition(){return this.getOptions().position}isGroupAxis(){return this.Info instanceof M}getMajorTickCoords(){for(var e=this.Info?this.Info.getMajorTickCoords():[],t=0;t<e.length;t++)e[t]=this.axisToPlotArea(e[t]);return e}getMinorTickCoords(){for(var e=this.Info?this.Info.getMinorTickCoords():[],t=0;t<e.length;t++)e[t]=this.axisToPlotArea(e[t]);return e}getBaselineCoord(){return this.axisToPlotArea(this.Info.getBaselineCoord())}getLinearGlobalMin(){return this.actualToLinear(this.Info.getGlobalMin())}getLinearGlobalMax(){return this.actualToLinear(this.Info.getGlobalMax())}getLinearViewportMin(){return this.actualToLinear(this.Info.getViewportMin())}getLinearViewportMax(){return this.actualToLinear(this.Info.getViewportMax())}getUnboundedLinearValAt(e){return this.Info.actualToLinear(this.getUnboundedValAt(e))}isFullViewport(){return this.Info.getViewportMin()==this.Info.getGlobalMin()&&this.Info.getViewportMax()==this.Info.getGlobalMax()}getLeftOverflow(){return t.Agent.isRightToLeft(this.getCtx())?this.Info.getEndOverflow():this.Info.getStartOverflow()}getRightOverflow(){return t.Agent.isRightToLeft(this.getCtx())?this.Info.getStartOverflow():this.Info.getEndOverflow()}getLength(){return Math.abs(this.Info.getStartCoord()-this.Info.getEndCoord())}getMinCoord(){return this.axisToPlotArea(Math.min(this.Info.getStartCoord(),this.Info.getEndCoord()))}getMaxCoord(){return this.axisToPlotArea(Math.max(this.Info.getStartCoord(),this.Info.getEndCoord()))}}const Se={_DEFAULT_AXIS_MAX_SIZE:.33,render:(e,t,i)=>{l.hasAxes(e)&&(w.applyInitialZooming(e,i),l.isBubble(e)&&me.calcBubbleSizes(e,i),l.isPolar(e)?Se._renderPolar(e,t,i):Se._renderCartesian(e,t,i))},_renderCartesian:(e,i,r)=>{var s=e.getOptions(),a=l.isHorizontal(e),n=d.isSplitDualY(e),o=l.isOverview(e),h=r.clone(),g=w.getYAxisPos(e),u=w.getY2AxisPos(e),_=!o&&s.overview.content&&s.overview.content.yAxis&&"on"==s.overview.content.yAxis.rendered,p=!o&&s.overview.content&&s.overview.content.y2Axis&&"on"==s.overview.content.y2Axis.rendered;Se._addAxisGaps(e,r),n&&g==u&&(s.yAxis._skipHighestTick=a,s.y2Axis._skipHighestTick=!a);var v=Se._createYAxis(e,i,r,h,_),m=Se._createY2Axis(e,i,r,h,p),f=!n&&"on"==s.y2Axis.alignTickMarks&&null==s.y2Axis.step;f&&v&&m&&(Se._alignYAxes(e,v,m),a||(m.dim=Se._getPreferredSize(e,m.axis,e.y2Axis,m.options,"y2",r,h,p)));var x,C=w.getTickLabelGapSize(e,"y"),S=w.getTickLabelGapSize(e,"y2");n&&g==u?(a?(x=Math.max(v.dim.h+C,m.dim.h+S),v.dim.h=x-C,m.dim.h=x-S):(x=Math.max(v.dim.w+C,m.dim.w+S),v.dim.w=x-C,m.dim.w=x-S),Se._positionAxis(r.clone(),v,C,_),Se._positionAxis(r,m,S,p)):(Se._positionAxis(r,v,C,_),Se._positionAxis(r,m,S,p));var A=d.getGroupCount(e);if("pixel"==c.getBarSpacing(e)&&l.isBar(e)&&r.w>A){var b=Math.floor(r.w/A)*A;r.x+=(r.w-b)/2,r.w=b}var y=Se._createXAxis(e,i,r,h);y.axis.render(y.options,y.dim.w,y.dim.h),Se._positionAxis(r,y,w.getTickLabelGapSize(e,"x"));var M=c.getSplitterPos(e),D=t.Agent.isRightToLeft(e.getCtx()),T=Se._getSplitAvailSpace(r,M,a,a&&D),I=Se._getSplitAvailSpace(r,1-M,a,!a||!D);a?(v&&(v.axis.setTranslateX(r.x),n?v.axis.render(v.options,T.w,v.dim.h,T.x,0):v.axis.render(v.options,r.w,v.dim.h)),f&&v&&m&&Se._alignYAxes(e,v,m),m&&(m.axis.setTranslateX(r.x),n?m.axis.render(m.options,I.w,m.dim.h,I.x,0):m.axis.render(m.options,r.w,m.dim.h)),Se._setOverflow(r,v,y)):(v&&(n?v.axis.render(v.options,v.dim.w,T.h,0,T.y):v.axis.render(v.options,v.dim.w,r.h)),f&&v&&m&&Se._alignYAxes(e,v,m),m&&(n?m.axis.render(m.options,m.dim.w,I.h,0,I.y):m.axis.render(m.options,m.dim.w,r.h)),Se._setOverflow(r,y,v,m)),Se._storeAxes(e,y,v,m)},_renderPolar:(e,t,i)=>{var r=Se._createXAxis(e,t,i,i);r.axis.setTranslateX(i.x),r.axis.setTranslateY(i.y),r.axis.render(r.options,i.w,i.h);var s=Se._createYAxis(e,t,i,i);s.axis.setTranslateX(i.x),s.axis.setTranslateY(i.y),s.axis.render(s.options,i.w,i.h),Se._storeAxes(e,r,s)},_createXAxis:(e,i,r,s)=>{var a=e.getOptions(),n=w.getXAxisPos(e),o=t.JsonUtils.clone(a.xAxis,null,e.Defaults.getNoCloneObject().xAxis);o.position=n,o.isStandalone=w.isStandaloneXAxis(e),o.groupSeparators=a.styleDefaults.groupSeparators,Se._addCommonAxisAttr(o,"x",e),o.groups=a.groups,o._groupWidthRatios=R.getGroupWidthRatios(e),o.timeAxisType=l.getTimeAxisType(e),o._locale=a._locale,o.drilling=a.drilling,o._isGroupAxis=l.hasGroupAxis(e);var h="top"==n||"bottom"==n,g=w.isGridShifted(e);if("tangential"==n&&l.hasGroupAxis(e))g?(o.startGroupOffset=.5,o.endGroupOffset=.5):o.endGroupOffset=1;else{var u=w.getAxisOffset(e);if(o.startGroupOffset=u,o.endGroupOffset=u,c.hasUncenteredSeries(e)&&(o.endGroupOffset+=1),!O.isScrollable(e)&&!l.isOverview(e)){var _=d.getGroupCount(e);w.isAxisRendered(e,"y")&&w.isTickLabelInside(e,"y")&&(o[(h?"start":"end")+"GroupOffset"]+=.04*_),w.isAxisRendered(e,"y2")&&w.isTickLabelInside(e,"y2")&&(o[(h?"end":"start")+"GroupOffset"]+=.04*_)}}o.leftBuffer=h?r.x-s.x:0,o.rightBuffer=h?s.w+s.x-(r.w+r.x):0,o._renderGridAtLabels=!g||l.hasTimeAxis(e),o.translations=a.translations;var p=new Ce(e.getCtx(),e.processEvent,e);i.addChild(p);var v=Se._getPreferredSize(e,p,e.xAxis,o,"x",r,s);return o._minOverflowCoord=a._minOverflowCoord-r.x,o._maxOverflowCoord=a._maxOverflowCoord-r.x,{axis:p,options:o,dim:v}},_createYAxis:(e,i,r,s,a)=>{var n=e.getOptions();if(d.hasY2DataOnly(e))return null;var o=t.JsonUtils.clone(n.yAxis,null,e.Defaults.getNoCloneObject().yAxis);o.position=w.getYAxisPos(e),o.isStandalone=w.isStandaloneYAxis(e),Se._addCommonAxisAttr(o,"y",e),Se._addCommonYAxisAttr(o,e),o.translations=n.translations;var l=new Ce(e.getCtx(),e.processEvent,e);i.addChild(l);var h=Se._getPreferredSize(e,l,e.yAxis,o,"y",r,s,a);return Se._adjustYAxisForLabels(l,o,e,"y"),n.yAxis.min=o.min,n.yAxis.max=o.max,{axis:l,options:o,dim:h}},_createY2Axis:(e,i,r,s,a)=>{var n=e.getOptions();if(d.hasY2Data(e)){var o=t.JsonUtils.clone(n.y2Axis,null,e.Defaults.getNoCloneObject().y2Axis);o.position=w.getY2AxisPos(e),o.isStandalone=w.isStandaloneY2Axis(e),Se._addCommonAxisAttr(o,"y2",e),Se._addCommonYAxisAttr(o,e),o.translations=n.translations;var l=new Ce(e.getCtx(),e.processEvent,e);i.addChild(l);var h=Se._getPreferredSize(e,l,e.y2Axis,o,"y2",r,s,a);return Se._adjustYAxisForLabels(l,o,e,"y2"),n.y2Axis.min=o.min,n.y2Axis.max=o.max,{axis:l,options:o,dim:h}}},_addCommonAxisAttr:(e,t,i)=>{var r=i.getOptions();if(e.skin=r.skin,e.tickLabel.position=w.isTickLabelInside(i,t)?"inside":"outside",e.baselineScaling=w.getBaselineScaling(i,t),(w.isTickLabelInside(i,t)||"tangential"==e.position)&&(e._skipHighestTick=!0),e.zoomAndScroll=l.isPolar(i)?"off":r.zoomAndScroll,e._isOverview=l.isOverview(i),e._duringZoomAndScroll=r._duringZoomAndScroll,"x"!=t||!l.hasGroupAxis(i)){var s=w.getMinMaxVal(i,t);e.dataMin=null!=e.dataMin?e.dataMin:s.min,e.dataMax=null!=e.dataMax?e.dataMax:s.max}l.isPolar(i)&&(e.polarGridShape=w.isGridPolygonal(i)?"polygon":"circle",e._radius=i.getRadius()),e.dnd=r.dnd},_addCommonYAxisAttr:(e,r)=>{if(e.timeAxisType="disabled",O.isLiveScroll(r)&&l.isBLAC(r)&&!l.isPolar(r)&&(e._continuousExtent="on"),e.isStandalone)e.leftBuffer=0,e.rightBuffer=0;else if(d.isSplitDualY(r))e.leftBuffer=1/0,e.rightBuffer=1/0;else{var s=t.Agent.isRightToLeft(r.getCtx());e.leftBuffer=s?0:i.BaseAxisInfo.MIN_AXIS_BUFFER,e.rightBuffer=s?i.BaseAxisInfo.MIN_AXIS_BUFFER:0}},_adjustYAxisForLabels:(e,i,r,s)=>{var a=r.getOptions();if(w.isYAdjustmentNeeded(r)){var n=t.CSSStyle.mergeStyles([a.styleDefaults._dataLabelStyle,a.styleDefaults.dataLabelStyle]),o=a.styleDefaults.stackLabelStyle,h=e.getInfo(),g=c.isStackLabelRendered(r),u=t.TextUtils.getTextStringHeight(r.getCtx(),g?o:n),_=0;if("log"==i.scale){_=e.getUnboundedValAt(e.getUnboundedCoordAt(h.getDataMax())-u)-h.getDataMax()}else{var p=1;d.isSplitDualY(r)&&(p="y"==s?c.getSplitterPos(r):1-c.getSplitterPos(r));var v=Math.abs(h.getEndCoord()-h.getStartCoord())*p;_=Math.abs(h.getViewportMax()-h.getViewportMin())/v*u}l.isHorizontal(r)?_*=4:_*=2,h.getDataMin()-h.getGlobalMin()<=_&&h.getDataMin()<0&&(i.dataMin-=_),h.getGlobalMax()-h.getDataMax()<=_&&h.getDataMax()>0&&(i.dataMax+=_)}},_getPreferredSize:(e,i,r,s,a,n,o,l)=>{var h=s.isStandalone,g=s.position,d="top"==g||"bottom"==g,u=w.getTickLabelGapSize(e,a),_=s.maxSize,p=s.size,v=n.w,m=n.h;if("radial"==g||"tangential"==g)v=0,m=0;else if("off"!=s.rendered||l)if(h)d?m=n.h-u:v=n.w-u;else if(null!=p)d?(m=c.getSizeInPixels(p,o.h)-u,null!=_&&(m=Math.min(m,c.getSizeInPixels(_,o.h)-u))):(v=c.getSizeInPixels(p,o.w)-u,null!=_&&(v=Math.min(v,c.getSizeInPixels(_,o.w)-u)));else{if(!e.getOptions()._duringZoomAndScroll||!r)return _=null==_?Se._DEFAULT_AXIS_MAX_SIZE:_,d?i.getPreferredSize(s,n.w,c.getSizeInPixels(_,o.h)-u,l):i.getPreferredSize(s,c.getSizeInPixels(_,o.w)-u,n.h,l);if(d){var f=t.Agent.isRightToLeft(e.getCtx());s._startOverflow=f?r.getRightOverflow():r.getLeftOverflow(),s._endOverflow=f?r.getLeftOverflow():r.getRightOverflow(),m=r.getHeight()}else v=r.getWidth()}else d?m=0:v=0;return w.isYAdjustmentNeeded(e)&&i.getPreferredSize(s,v,m),new t.Dimension(v,m)},_addAxisGaps:(e,t)=>{var i=l.isHorizontal(e),r=w.getYAxisPos(e),s=w.getY2AxisPos(e),a=w.isAxisRendered(e,"x"),n=w.isAxisRendered(e,"y"),o=w.isAxisRendered(e,"y2"),h=e.getOptions().layout.verticalAxisGap;h*=i?w.getGapScalingFactor(e,"x"):Math.max(w.getGapScalingFactor(e,"y"),w.getGapScalingFactor(e,"y2")),h=Math.ceil(h),(!i||"top"==r&&n||"top"==s&&o)&&i||(t.y+=h,t.h-=h),(!i||"bottom"==r&&n||"bottom"==s&&o)&&(i||a)||(t.h-=h)},_positionAxis:(e,i,r,s)=>{if(i){var a=s?Math.max(i.dim.h,1):i.dim.h,n=s?Math.max(i.dim.w,1):i.dim.w;t.LayoutUtils.position(e,i.options.position,i.axis,n,a,r)}},_alignYAxes:(e,t,i)=>{var r=t.axis.getInfo();if(r){var s=r.getMajorTickCount(),a=r.getMinorTickCount(),n=i.options,o=i.axis.getInfo();o&&w.isLog(e,"y")&&w.isLog(e,"y2")&&s<o.getMajorTickCount()&&(n._logScaleUnit=o.alignLogScaleToTickCount(o.getLogScaleUnit(),s)),n._majorTickCount=s,n._minorTickCount=a}},_getSplitAvailSpace:(e,t,i,r)=>{var s=e.clone();return i?(s.w=e.w*t,s.x=r?e.w*(1-t):0):(s.h=e.h*t,s.y=r?e.h*(1-t):0),s},_setOverflow:(e,t,i,r)=>{if(t){var s=t.axis.getLeftOverflow(),a=t.axis.getRightOverflow();e.x+=s,e.w-=s+a,i&&i.axis.setTranslateX(i.axis.getTranslateX()+("left"==i.options.position?s:-a)),r&&r.axis.setTranslateX(r.axis.getTranslateX()+("left"==r.options.position?s:-a))}},_storeAxes:(e,t,i,r)=>{e.xAxis&&(e.xAxis.destroy(),e.removeChild(e.xAxis)),e.yAxis&&(e.yAxis.destroy(),e.removeChild(e.yAxis)),e.y2Axis&&(e.y2Axis.destroy(),e.removeChild(e.y2Axis)),e.xAxis=t.axis,e.yAxis=i?i.axis:null,e.y2Axis=r?r.axis:null}},Ae={_DEFAULT_LINE_WIDTH_WITH_MARKER:2,_DEFAULT_MAX_SIZE:.3,_PIE_SIZE_RATIO:1.2,render:(e,i,s)=>{var a=e.getOptions(),n=a.legend.position;if(!("off"==a.legend.rendered||"auto"==a.legend.rendered&&e.getOptionsCache().getFromCache("hasLargeSeriesCount"))){var o=t.JsonUtils.clone(a.legend);delete o.position,o.skin=a.skin,o.hideAndShowBehavior=O.getHideAndShowBehavior(e),o.hoverBehavior=O.getHoverBehavior(e),o.hoverBehaviorDelay=c.getHoverBehaviorDelay(e),o.hiddenCategories=d.getHiddenCategories(e),o.highlightedCategories=d.getHighlightedCategories(e),o.dnd=a.dnd,o._dropColor=a._dropColor,o.translations=a.translations,"auto"==n&&(n=s.w>=s.h?"end":"bottom");var h="top"==n||"bottom"==n;if(o.orientation=h?"horizontal":"vertical","start"==n&&(o.halign="end"),"start"!=n&&"end"!=n||(o.valign="middle"),"top"==n&&(o.valign="bottom"),"top"!=n&&"bottom"!=n||(o.halign="center"),Ae._addLegendData(e,o),0!=o.sections.length){var g,_=new r.Legend(e.getCtx(),e.processEvent,e);if(null!=e.getId()&&_.setId(e.getId()+"legend"),i.addChild(_),null!=o.size)g=h?new t.Dimension(s.w,c.getSizeInPixels(o.size,s.h)):new t.Dimension(c.getSizeInPixels(o.size,s.w),s.h);else{var p=o.maxSize;if(null==p&&(p=Ae._DEFAULT_MAX_SIZE,l.isPie(e))){var v=1-Ae._PIE_SIZE_RATIO*(h?s.w/s.h:s.h/s.w);p=Math.max(p,v)}var m=h?s.w:c.getSizeInPixels(p,s.w),f=h?c.getSizeInPixels(p,s.h):s.h;g=_.getPreferredSize(o,m,f)}_.render(o,g.w,g.h);var x=h?u.getGapHeight(e,a.layout.legendGapHeight):u.getGapWidth(e,a.layout.legendGapWidth);t.LayoutUtils.position(s,n,_,g.w,g.h,x);var C=Object.keys(o.dnd.drag.series).length>0,S=_.getCache().getFromCache("background");C&&S&&S.setClassName("oj-draggable");var A=_.__getBounds(),b=_.localToStage(new t.Point(A.x,A.y));if(!l.isOverview(e)){var y=t.Agent.isRightToLeft(e.getCtx());"end"==n?y?a._minOverflowCoord=b.x+A.w+x/2:a._maxOverflowCoord=b.x-x/2:"start"==n&&(y?a._maxOverflowCoord=b.x-x/2:a._minOverflowCoord=b.x+A.w+x/2)}e.legend&&(e.legend.destroy(),i.removeChild(e.legend)),e.legend=_,Ae.isLegendInteractive(e)||e.legend.setAriaProperty("hidden","true",!0)}}},_addLegendData:(e,t)=>{var i=Ae._getSeriesItems(e,"vertical"==t.orientation);if(i.length>0){var r=t.seriesSection;r.items=i,t.sections.unshift(r),delete t.seriesSection}var s=Ae._getRefObjItems(e);if(s.length>0){var a=t.referenceObjectSection;a.items=s,t.sections.push(a),delete t.referenceObjectSection}},_getSeriesItems:(e,t)=>{var i,r,s=[];if("pie"==e.getType()||"pyramid"==e.getType()||"funnel"==e.getType()){var a=_.getRenderedSeriesIndices(e);"pyramid"==e.getType()&&t&&a.reverse();for(var n=0;n<a.length;n++){r=a[n];var o=d.getVal(e,r,0);o>=0&&null!=o&&(i=Ae._createLegendItem(e,r))&&s.push(i)}_.hasOtherSeries(e)&&(i={id:_.OTHER_ID,drilling:e.getOptions().multiSeriesDrilling,text:e.getOptions().translations.labelOther,categoryVisibility:d.getHiddenCategories(e).indexOf(_.OTHER_ID)>=0?"hidden":"visible",symbolType:"marker",color:e.getOptions().styleDefaults.otherColor,borderColor:e.getOptions().styleDefaults.borderColor},s.push(i))}else{var h={},g={},u=d.getSeriesCount(e);for(r=0;r<u;r++)if(i=Ae._createLegendItem(e,r)){var c=d.getStackCategory(e,r);d.isAssignedToY2(e,r)?g[c]?g[c].push(i):g[c]=[i]:h[c]?h[c].push(i):h[c]=[i]}var p=d.getStackCategories(e,null,!0),v=d.isStacked(e)&&l.isVertical(e)&&t;s=Ae._getSeriesItemsForAxis(h,p.y,v,s),s=Ae._getSeriesItemsForAxis(g,p.y2,v,s)}return s},_getSeriesItemsForAxis:(e,t,i,r)=>{for(var s,a=0;a<t.length;a++)(s=e[t[a]])&&(r=i?r.concat(s.reverse()):r.concat(s));return r},_createLegendItem:(e,t)=>{var i=d.getSeriesItem(e,t),r=e.getType(),s=d.getSeriesType(e,t),a=c.getLineType(e,t),n=i.displayInLegend;if(!i||"off"==n)return null;if("on"!=n&&(l.isFunnel(e)||l.isPyramid(e)||l.isStock(e)))return null;if("on"!=n&&!d.hasSeriesData(e,t))return null;var o=d.getSeriesLabel(e,t);if("on"!=n&&(null==o||"string"==typeof o&&0===o.trim().length))return null;var h={id:d.getSeries(e,t),text:o,categories:d.getCategories(e,t),categoryVisibility:d.isSeriesRendered(e,t)?"visible":"hidden",_getDataContext:c.getDataContext.bind(null,e,t,-1)};if("line"==s||"lineWithArea"==s||"scatter"==r||"bubble"==r)if(h.lineStyle=c.getLineStyle(e,t),h.lineWidth=c.getLineWidth(e,t),c.isMarkerDisplayed(e,t)){var g=c.getImageSource(e,t,null,null,"source");g?(h.symbolType="image",h.source=g):(h.symbolType="none"==a?"marker":"lineWithMarker","lineWithMarker"==h.symbolType&&(h.lineWidth=Math.min(Ae._DEFAULT_LINE_WIDTH_WITH_MARKER,h.lineWidth)),h.markerShape=c.getMarkerShape(e,t),h.markerColor=c.getMarkerColor(e,t))}else h.symbolType="line";else if("boxPlot"==s){var u=c.getBoxPlotStyleOptions(e,t);u.q2Color!=u.q3Color?(h.symbolType=l.isHorizontal(e)?"_horizontalBoxPlot":"_verticalBoxPlot",h._boxPlot=u):h.symbolType="marker"}else h.symbolType="marker","none"==c.getLineType(e,t)&&(h.markerShape=c.getMarkerShape(e,t));return h.color=c.getColor(e,t),h.borderColor=c.getBorderColor(e,t),h.pattern=c.getPattern(e,t),h.svgStyle="area"==s?c.getAreaStyle(e,t):c.getStyle(e,t),h.svgClassName="area"==s?c.getAreaClassName(e,t):c.getClassName(e,t),h.markerSvgStyle=c.getMarkerStyle(e,t),h.markerSvgClassName=c.getMarkerClassName(e,t),h.drilling=d.isSeriesDrillable(e,t)?"on":"off",h.shortDesc=i.shortDesc,h},_getRefObjItems:e=>{var t=d.getRefObjs(e);if(t.length<=0)return[];for(var i=[],r=0;r<t.length;r++){var s=t[r];if(s&&"on"==s.displayInLegend&&s.text){var a=v.getType(s);i.push({symbolType:"area"==a?"square":"line",text:s.text,color:v.getColor(e,s),lineStyle:s.lineStyle,lineWidth:v.getLineWidth(e,s),categories:v.getRefObjCategories(s),categoryVisibility:v.isObjRendered(e,s)?"visible":"hidden",shortDesc:s.shortDesc,svgStyle:s.style||s.svgStyle,svgClassName:s.className||s.svgClassName})}}return i},isLegendDrillable:function(e){var t=e.getOptions();return!!("on"===t.drilling||"seriesOnly"===t.drilling||l.isPie(e)&&"on"===t.multiSeriesDrilling)||e.getOptionsCache().getFromCache("hasDrillableSeries")},isLegendInteractive:function(e){return"none"!==O.getHideAndShowBehavior(e)||Ae.isLegendDrillable(e)}};class be extends s.Overview{constructor(e){super(e.getCtx(),e.processEvent,e),this._parentChart=e,this._chart=e.overview?e.overview.getBackgroundChart():null,this._id=e.getId()+"_overview"}_renderChart(e,i,r){var s=this._parentChart.Defaults.getNoCloneObject();this._chartContainer=new t.Container(this.getCtx()),this.addChild(this._chartContainer);e=t.JsonUtils.merge({legend:{rendered:"off",size:null},xAxis:{viewportMin:null,viewportMax:null,viewportStartGroup:null,viewportEndGroup:null,axisLine:{rendered:"off"},size:null,maxSize:.5,title:null},yAxis:{rendered:"off",size:null},y2Axis:{rendered:"off",size:null},splitDualY:"off",title:{text:null},subtitle:{text:null},footnote:{text:null},titleSeparator:{rendered:"off"},styleDefaults:{animationIndicators:"none"},layout:{outerGapWidth:0,outerGapHeight:0},_isOverview:!0},e,s),l.hasGroupAxis(this._parentChart)&&(e.xAxis.tickLabel.rendered="off"),l.isStock(this._parentChart)&&e.series&&e.series[0]&&(e.series=[e.series[0]],e.series[0].type="lineWithArea");var a=this._parentChart.getOptions().overview.content,n=(e=t.JsonUtils.merge(a,e,s)).yAxis.rendered,o=e.y2Axis.rendered;e.zoomAndScroll="off",this._chart||(this._chart=this._parentChart.createOverviewChart(),this._chart.setId(this._id));var h=i,g=this._parentChart.getWidth(),u=this._parentChart.__getPlotAreaSpace(),_=d.hasY2Data(this._parentChart),c=d.hasY2DataOnly(this._parentChart),p=(n="on"===e.yAxis.rendered&&!c,o="on"===e.y2Axis.rendered&&_,u.x),v=g-(p+i);n&&(h=p+i,e.yAxis.size=p),o&&(h=(n?p:0)+v+i,e.y2Axis.size=v),this._chartContainer.addChild(this._chart),this._chart.render(e,h,r);var m=new t.Rect(this.getCtx(),0,0,h,r);m.setInvisibleFill(),this._chartContainer.addChild(m),this._chart.getEventManager().setKeyboardHandler(null);var f=this._chart.__getPlotAreaSpace();if(n){var x=this._chartContainer.getTranslateX()-f.x;this._chartContainer.setTranslateX(x)}return new t.Dimension(i,f.h+f.y)}render(e,t,i){e.overview.style={overviewBackgroundColor:"rgba(0,0,0,0)",windowBackgroundColor:"rgba(0,0,0,0)",windowBorderTopColor:"#333333",windowBorderRightColor:"#333333",windowBorderBottomColor:"#333333",windowBorderLeftColor:"#333333",leftFilterPanelColor:"rgba(5,65,135,0.1)",rightFilterPanelColor:"rgba(5,65,135,0.1)",handleBackgroundClass:e.chart._resources.overviewGrippy,handleSize:16,handleFillColor:"rgba(0,0,0,0)"},e.overview.animationOnClick="off";var r=this._renderChart(e.chart,t,i);super.render(e.overview,r.w,r.h)}destroy(){super.destroy(),this._parentChart=null,this._chart=null}getBackgroundChart(){return this._chart}isBackgroundRendered(){return!1}isLeftAndRightFilterRendered(){return!0}HandleKeyDown(e){}HandleKeyUp(e){}}class ye extends t.Container{constructor(e,i,r,s){super(e.getCtx()),this._THREED_TILT=j.THREED_TILT,this._THREED_DEPTH=.1,this._RADIUS=.45,this._RADIUS_LABELS=.38,this._MIN_ARC_LENGTH=1.5,this.chart=e,this._options=e.getOptions(),this._frame=i.clone(),e.pieChart=this;for(var a=this.getLabelPos(),n=d.getSeriesCount(e),o=0;o<n;o++){var l=d.getDataItem(e,o,0);!l||"center"!=a&&"none"!=a||"outsideSlice"!=l.labelPosition||(a="outsideSlice")}this._center=new t.Point(i.x+Math.floor(i.w/2),i.y+Math.floor(i.h/2));var h="center"==a||"none"==a?this._RADIUS:this._RADIUS_LABELS;this._radiusX=Math.floor(Math.min(i.w,i.h)*h),this._radiusY=this._radiusX,this._depth=0,this._anchorOffset=90,this.is3D()&&(this._depth=i.h*this._THREED_DEPTH,this._center.y-=Math.floor(this._depth/2),this._radiusY*=this._THREED_TILT),this._slices=this._createSlices(),this._centerLabel=null,this._shapesContainer=new t.Container(this.getCtx()),this._numFrontObjs=0,this._numSelectedObjsInFront=0}getOptions(){return this._options}highlight(e){t.CategoryRolloverHandler.highlight(e,this._slices,"any"==this.getOptions().highlightMatch)}_createSlices(){for(var e,i,r=[],s=_.getRenderedSeriesIndices(this.chart),a=_.getOtherVal(this.chart),n=0;n<s.length;n++)if(i=s[n],d.isDataItemRendered(this.chart,i)){var o=(e=new j(this,i)).getVal();null==o||o<=0||r.push(e)}var l=d.getHiddenCategories(this.chart).indexOf(_.OTHER_SLICE_SERIES_ID)>=0;if(a>0&&!l){var h=new j(this);"ascending"==this.chart.getOptions().sorting?r.unshift(h):r.push(h)}return t.Agent.isRightToLeft(this.getCtx())&&r.reverse(),r}setInitialSelection(){var e=this.chart.getSelectionHandler();if(e){for(var t=d.getInitialSelection(this.chart),i=[],r=0;r<t.length;r++)for(var s=0;s<this._slices.length;s++){var a=this._slices[s].getId();null!=a&&(null!=t[r].id&&a.id==t[r].id||a.series==t[r].series&&a.group==t[r].group)&&i.push(a)}if(_.isOtherSliceSelected(this.chart,t)){var n=_.getOtherSliceId(this.chart);i.push(n)}e.processInitialSelections(i,this._slices)}}render(){F.addPlotAreaDnDBackground(this.chart,this,this._frame,!0),this.contains(this._shapesContainer)||(this._shapesContainer||(this._shapesContainer=new t.Container(this.getCtx())),this.addChild(this._shapesContainer)),ye._layoutSlices(this._slices,this._anchorOffset);for(var e=2*Math.PI*this.getRadiusX(),i=0,r={},s=this.chart.getOptionsCache().getFromCache("hasLargeSeriesCount"),a=0;a<this._slices.length;a++){if(s){var n=this._slices[a].getAngleExtent(),o=n/360*e,l=(this._slices[a].getAngleStart()+n)/360*e;if(o<this._MIN_ARC_LENGTH&&Math.abs(i-l)<this._MIN_ARC_LENGTH){r[this._slices[a].getSeriesIndex()]=!0;continue}i=l}this._slices[a].preRender()}var h=ye._orderSlicesForRendering(this._slices);this._duringDisplayAnim||(W.createPieCenter(this),W.layoutLabelsAndFeelers(this));for(a=0;a<h.length;a++)r[h[a].getSeriesIndex()]||h[a].render(this._duringDisplayAnim);this.setInitialSelection(),this.highlight(d.getHighlightedCategories(this.chart))}getTotalValue(){for(var e=0,t=0;t<this._slices.length;t++){var i=this._slices[t].getVal();i>=0&&(e+=i)}return e}static _layoutSlices(e,t){var i,r,s=0,a=e?e.length:0;t>360&&(t-=360),t<0&&(t+=360);var n=0;a>0&&(n=e[0].getPieChart().getTotalValue());for(var o=0;o<a;o++){var l=(i=e[o]).getVal();(r=t-(s=3.6*(l==n?100:0==n?0:Math.min(l/n*100,99.99))))<0&&(r+=360),i.setAngleStart(r),i.setAngleExtent(s),t=i.getAngleStart()}}static _orderSlicesForRendering(e){for(var t,i,r,s,a=[],n=e?e.length:0,o=-1,l=0;l<n;l++)if((r=(i=(t=e[l]).getAngleStart())+t.getAngleExtent())>360&&(r-=360),r<0&&(r+=360),90==r||i<90&&r>90){o=l,s=r-90;break}var h=[];for(l=o;l<n;l++)h.push(e[l]);for(l=0;l<o;l++)h.push(e[l]);var g=0,d=0,u=180+s;for(l=0;l<n;l++)if(t=h[l]){if(g+t.getAngleExtent()>u){d=l;break}a.push(t),g+=t.getAngleExtent()}for(l=n-1;l>=d;l--)(t=h[l])&&a.push(t);return a}is3D(){return"on"==this._options.styleDefaults.threeDEffect}__calcMaxExplodeDistance(){var e=.5/this._RADIUS-1;return this._radiusX*e}getAnimDuration(){return c.getAnimDur(this.chart)}getDisplayAnim(){this._duringDisplayAnim=!0;var e=new t.DataAnimationHandler(this.getCtx(),this),i=this.getAnimDuration(),r=j.createFillerSlice(this,this.getTotalValue());this._slices.push(r);var s=new t.CustomAnimation(this.getCtx(),r,i);s.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,r,r.GetAnimParams,r.SetAnimParams,r.getDeletedAnimParams()),s.setOnEnd(r._removeDeletedSlice,r),e.add(s,0);for(var a=0;a<this._slices.length-1;a++)this._slices[a].animateInsert(e);var n=new t.CustomAnimation(this.getCtx(),this,i);n.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimParams,this._setAnimParams,this._getAnimParams()),e.add(n,0);var o=[];for(a=0;a<this._slices.length;a++)o=o.concat(this._slices[a].getLabelAndFeeler());var l=new t.AnimFadeIn(this._context,o,i);e.add(l,0),this._setAnimParams();var h=e.getAnimation(!0);return h.setOnEnd(this._onEnd,this),h}_onEnd(){this._duringDisplayAnim=!1,this._setAnimParams()}getCenter(){return this._center}getId(){return"chart/pie"}getInnerRadius(){return this.is3D()?0:this._options.styleDefaults.pieInnerRadius*Math.min(this._radiusX,this._radiusY)*.95}__getFrame(){return this._frame}getRadiusX(){return this._radiusX}getRadiusY(){return this._radiusY}getDepth(){return this._depth}getSliceDisplayable(e){var t=_.getSliceBySeriesIdx(this.chart,e);return t?t.getTopDisplayable():null}__getShapesContainer(){return this._shapesContainer}__getSlices(){return this._slices}animateUpdate(e,i){var r=new t.DataAnimationHandler(this.getCtx(),this);r.constructAnimation(i.__getSlices(),this.__getSlices());var s=r.getAnimation(!0),a=new t.CustomAnimation(this.getCtx(),this,this.getAnimDuration());a.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimParams,this._setAnimParams,this._getAnimParams());var n=new t.ParallelPlayable(this.getCtx(),s,a);n.setOnEnd(this._setAnimParams,this),e.add(n,0),this._setAnimParams([i.getDepth(),i.getRadiusY(),i.getCenter().y])}animateInsert(e){}animateDelete(e,t){}_getAnimParams(){return[this._depth,this._radiusY,this._center.y]}_setAnimParams(e){this.removeChildren(),this._shapesContainer&&this._shapesContainer.destroy(),this._shapesContainer=null,e&&(this._depth=e[0],this._radiusY=e[1],this._center.y=e[2]),this.render()}bringToFrontOfSelection(e){var t=e.getPieChart()._shapesContainer;if(t){var i=t.getNumChildren();if(i-this._numFrontObjs>1){t.removeChild(e._topSurface[0]);var r=i-this._numFrontObjs-1;t.addChildAt(e._topSurface[0],r)}}}pushToBackOfSelection(e){for(var t=this._slices.length,i=0,r=0;r<t;r++)this._slices[r].isSelected()&&i++;this._numSelectedObjsInFront=i;var s=e.getPieChart()._shapesContainer;if(s){var a=s.getNumChildren()-this._numFrontObjs-1-this._numSelectedObjsInFront;a>=0&&(s.removeChild(e._topSurface[0]),s.addChildAt(e._topSurface[0],a))}}getLabelPos(){return ye.parseLabelPos(this._options.styleDefaults.dataLabelPosition)}getSeriesLabelPos(e){var t=this.getLabelPos(),i=d.getDataItem(this.chart,e,0);return i&&i.labelPosition&&(t=i.labelPosition),ye.parseLabelPos(t)}static parseLabelPos(e){return"center"==e||"inside"==e?"center":"outsideSlice"==e||"outside"==e?"outsideSlice":"none"==e?"none":"auto"}getSkin(){return this._options.skin}setCenterLabel(e){this._centerLabel=e}getCenterLabel(){return this._centerLabel}}const Me={_BUTTON_SIZE:16,_BUTTON_PADDING:5,_BUTTON_CORNER_DIST:4,_MOUSE_WHEEL_ZOOM_RATE_SLOW:.05,_MOUSE_WHEEL_ZOOM_RATE_FAST:.2,render:(e,t,i)=>{if(Me._renderBackground(e,t,i),d.hasInvalidData(e))L(e,t,i);else{l.isOverview(e)||(e.getOptions()._maxOverflowCoord=i.x+i.w,e.getOptions()._minOverflowCoord=i.x),Me._addOuterGaps(e,i);var r=i.clone();Me._renderTitles(e,t,i),Me._adjustAvailSpace(i),Ae.render(e,t,i),Me._adjustAvailSpace(i);var s=Me._prerenderHorizScrollbar(e,t,i),a=Me._prerenderVertScrollbar(e,t,i);Me._adjustAvailSpace(i),e.__setAxisSpace(i.clone()),Se.render(e,t,i),Me._adjustAvailSpace(i),Me._positionLegend(e.legend,i),e.__setPlotAreaSpace(i.clone()),Me._setEventHandlers(e),Me._renderScrollbars(e,s,a),Me._updateTitles(e,t,r,i),Me._renderPlotArea(e,t,i),Me._renderDragButtons(e)}},_setEventHandlers:e=>{var i=e.getOptions(),r=e.getEventManager();if(l.hasAxes(e)&&!l.isOverview(e)){var s,a,n=new t.Rectangle(0,0,e.getWidth(),e.getHeight()),o=e.__getPlotAreaSpace(),h=e.__getAxisSpace(),g=new t.Rectangle(o.x,h.y,o.w,h.h),d=new t.Rectangle(h.x,o.y,h.w,o.h),u=new t.SolidFill(i.styleDefaults.marqueeColor),_=new t.Stroke(i.styleDefaults.marqueeBorderColor);if(O.isScrollable(e)){var c=O.isDelayedScroll(e)?Me._MOUSE_WHEEL_ZOOM_RATE_FAST:Me._MOUSE_WHEEL_ZOOM_RATE_SLOW;if(a=new t.PanZoomHandler(e,o,n,c),r.setPanZoomHandler(a),O.isZoomable(e)){var p=O.getZoomDir(e);s=l.isHorizontal(e)||"y"==p?new t.MarqueeHandler(e,o,n,u,_,!1,!0,null,d):l.isBLAC(e)||"x"==p?new t.MarqueeHandler(e,o,n,u,_,!0,!1,g,null):new t.MarqueeHandler(e,o,n,u,_,!0,!0,g,d),r.setMarqueeZoomHandler(s)}}"multiple"==i.selectionMode&&(s=new t.MarqueeHandler(e,o,n,u,_,!0,!0,g,d),r.setMarqueeSelectHandler(s))}},rerenderAxisAndPlotArea:(e,t)=>{if(!d.hasInvalidData(e)){var i=e.__getAxisSpace().clone(),r=e.getSelectionHandler();if(r)var s=r.getSelectedIds();var a=e.__cacheChartFocus();e.__cleanUpAxisAndPlotArea(),Se.render(e,t,i),Me._adjustAvailSpace(i),e.__setPlotAreaSpace(i.clone()),Me._renderPlotArea(e,t,i),r&&r.processInitialSelections(s,e.getChartObjPeers()),e.getEventManager().autoToggleZoomButton(),Me.positionDragButtons(e),e.highlight(d.getHighlightedCategories(e)),e.__restoreChartFocus(a)}},_renderBackground:(e,i,r)=>{var s=new t.Rect(e.getCtx(),r.x,r.y,r.w,r.h);s.setInvisibleFill(),i.addChild(s)},_addOuterGaps:(e,t)=>{var i=e.getOptions(),r=u.getGapWidth(e,i.layout.outerGapWidth),s=u.getGapHeight(e,i.layout.outerGapHeight);Me._needsOuterGaps(e)||(r=Math.min(r,1),s=Math.min(s,1)),t.x+=r,t.w-=2*r,t.y+=s,t.h-=2*s},_needsOuterGaps:e=>{var t=e.getOptions();return!(!l.isFunnel(e)||"on"!==t.styleDefaults.threeDEffect)||!(w.isStandalonePlotArea(e)||w.isStandaloneXAxis(e)||w.isStandaloneYAxis(e)||w.isStandaloneY2Axis(e))},_renderTitles:(e,i,r)=>{var s=e.getOptions();if(s.title.text){var a,n,o=E(e.getEventManager(),i,s.title.text,s.title.style,r.x,r.y,r.w,r.h),l=null!=s.title.hAlign?s.title.hAlign:s.title.halign,h="plotArea"==l.substring(0,8);if(o?(a=(n=o.getDimensions()).h,o.setAriaProperty("hidden",null)):(a=0,n=new t.Rectangle(0,0,0,0)),s.subtitle.text){var g=new t.OutputText(e.getCtx(),s.subtitle.text,r.x,r.y);g.setCSSStyle(s.subtitle.style),i.addChild(g);var d=g.getDimensions(),_=u.getGapWidth(e,s.layout.titleSubtitleGapWidth),c=n.w+_+d.w;if(c>r.w||h)_=u.getGapHeight(e,s.layout.titleSubtitleGapHeight),g.setY(r.y+a+_),t.TextUtils.fitText(g,r.w,r.h,i)&&(a+=(d=g.getDimensions()).h+_,t.Agent.isRightToLeft(e.getCtx())&&(g&&g.setX(r.w-d.w),o&&o.setX(r.w-n.w)));else{var p=n.h-d.h;g.setY(p+r.y),o&&(t.LayoutUtils.align(r,l,o,c),t.Agent.isRightToLeft(e.getCtx())?(g.setX(o.getX()),o.setX(o.getX()+d.w+_)):g.setX(o.getX()+c-d.w)),g.setAriaProperty("hidden",null),e.getEventManager().associate(g,new t.SimpleObjPeer(g.getUntruncatedTextString()))}}else t.LayoutUtils.align(r,l,o,n.w);h&&(e.getCache().putToCache("title",o),e.getCache().putToCache("subtitle",g));var v="on"==s.titleSeparator.rendered?s.layout.titleSeparatorGap:s.layout.titlePlotAreaGap;if(r.y+=a+u.getGapHeight(e,v),r.h-=a+u.getGapHeight(e,v),"on"==s.titleSeparator.rendered){var m=new t.Line(e.getCtx(),r.x,r.y,r.x+r.w,r.y),f=new t.Line(e.getCtx(),r.x,r.y+1,r.x+r.w,r.y+1);m.setSolidStroke(s.titleSeparator.upperColor),f.setSolidStroke(s.titleSeparator.lowerColor),i.addChild(m),i.addChild(f);var x=2+u.getGapHeight(e,s.layout.titlePlotAreaGap);r.y+=x,r.h-=x}}if(s.footnote.text){var C=E(e.getEventManager(),i,s.footnote.text,s.footnote.style,r.x,0,r.w,r.h),S=null!=s.footnote.hAlign?s.footnote.hAlign:s.footnote.halign,A="plotArea"==S.substring(0,8);if(C){var b=C.getDimensions();C.setY(r.y+r.h-b.h),r.h-=b.h+u.getGapHeight(e,s.layout.footnoteGap),t.LayoutUtils.align(r,S,C,b.w),C.setAriaProperty("hidden",null)}A&&e.getCache().putToCache("footnote",C)}},_updateTitles:(e,t,i,r)=>{var s=e.getOptions(),a=null!=s.title.hAlign?s.title.hAlign:s.title.halign,n=null!=s.footnote.hAlign?s.footnote.hAlign:s.footnote.halign,o=s.title.text&&"plotArea"==a.substring(0,8),l=s.footnote.text&&"plotArea"==n.substring(0,8);if(i.x=r.x,i.w=r.w,o){var h,g=e.getCache().getFromCache("title"),d=e.getCache().getFromCache("subtitle"),u=g.getDimensions();Me._alignTextToPlotArea(t,i,a,g,u.w),d&&(h=d.getDimensions(),Me._alignTextToPlotArea(t,i,a,d,h.w))}if(l){var _=e.getCache().getFromCache("footnote"),c=_.getDimensions();Me._alignTextToPlotArea(t,i,n,_,c.w)}},_alignTextToPlotArea:(e,i,r,s,a)=>{t.TextUtils.fitText(s,i.w,i.h,e)&&("plotAreaStart"==r?t.LayoutUtils.align(i,"start",s,a):"plotAreaCenter"==r?t.LayoutUtils.align(i,"center",s,a):"plotAreaEnd"==r&&t.LayoutUtils.align(i,"end",s,a))},_renderPlotArea:(e,i,r)=>{if(l.hasAxes(e)){var s=new t.Container(e.getCtx());s.setTranslate(r.x,r.y),i.addChildAt(s,1),e.setPlotArea(s),e.getEventManager().associate(s,new t.SimpleObjPeer(null,null,null,{type:"plotArea"}));var a=new t.Rectangle(0,0,r.w,r.h);fe.render(e,s,a)}else if(l.isPie(e)){var n=new ye(e,r);n.__getSlices().length>0?(i.addChild(n),e.setPlotArea(n),n.render()):L(e,i,r)}else l.isFunnel(e)?N.render(e,i,r):l.isPyramid(e)&&G.render(e,i,r);r.w=0,r.h=0},_prerenderHorizScrollbar:(e,i,r)=>{var s=r.w,a=0;return O.isScrollable(e)&&O.isHorizScrollbarSupported(e)?c.isOverviewRendered(e)?(a=Math.min(c.getOverviewHeight(e),r.h))>0&&(e.overview=new be(e),i.addChild(e.overview),t.LayoutUtils.position(r,"bottom",e.overview,s,a,10)):(a=e.getOptions().styleDefaults._scrollbarHeight,e.xScrollbar=new t.SimpleScrollbar(e.getCtx(),e.processEvent,e),i.addChild(e.xScrollbar),t.LayoutUtils.position(r,"bottom",e.xScrollbar,s,a,8),e.overview=null):e.overview=null,new t.Dimension(s,a)},_prerenderVertScrollbar:(e,i,r)=>{var s=0,a=r.h;if(O.isScrollable(e)&&O.isVertScrollbarSupported(e)){s=e.getOptions().styleDefaults._scrollbarHeight;var n=new t.SimpleScrollbar(e.getCtx(),e.processEvent,e);i.addChild(n),t.LayoutUtils.position(r,t.Agent.isRightToLeft(e.getCtx())?"right":"left",n,s,a,8),l.isHorizontal(e)?e.xScrollbar=n:e.yScrollbar=n}return new t.Dimension(s,a)},_renderScrollbars:(e,i,r)=>{var s=e.getOptions(),a={color:s.styleDefaults._scrollbarHandleColor,backgroundColor:s.styleDefaults._scrollbarTrackColor},n=e.__getPlotAreaSpace();if(e.xScrollbar&&(a.min=e.xAxis.getLinearGlobalMin(),a.max=e.xAxis.getLinearGlobalMax(),l.isHorizontal(e)?(a.isHorizontal=!1,a.isReversed=!1,e.xScrollbar.setTranslateY(n.y),e.xScrollbar.render(a,r.w,n.h)):(a.isHorizontal=!0,a.isReversed=t.Agent.isRightToLeft(e.getCtx()),e.xScrollbar.setTranslateX(n.x),e.xScrollbar.render(a,n.w,i.h)),e.xScrollbar.setViewportRange(e.xAxis.getLinearViewportMin(),e.xAxis.getLinearViewportMax())),e.yScrollbar&&(a.min=e.yAxis.getLinearGlobalMin(),a.max=e.yAxis.getLinearGlobalMax(),a.isHorizontal=!1,a.isReversed=!0,e.yScrollbar.setTranslateY(n.y),e.yScrollbar.render(a,r.w,n.h),e.yScrollbar.setViewportRange(e.yAxis.getLinearViewportMin(),e.yAxis.getLinearViewportMax())),e.overview){var o=e.Defaults.getNoCloneObject(),h={overview:{xMin:e.xAxis.getLinearGlobalMin(),xMax:e.xAxis.getLinearGlobalMax(),x1:e.xAxis.getLinearViewportMin(),x2:e.xAxis.getLinearViewportMax(),minimumWindowSize:e.xAxis.getInfo().getMinExtent()},chart:t.JsonUtils.clone(s,null,o)};O.isZoomable(e)||(h.featuresOff="zoom"),h.chart._minOverflowCoord=s._minOverflowCoord-n.x,h.chart._maxOverflowCoord=s._maxOverflowCoord-n.x,e.overview.setTranslateX(n.x),e.overview.render(h,n.w,i.h),e.overview.setViewportRange(e.xAxis.getLinearViewportMin(),e.xAxis.getLinearViewportMax())}},_positionLegend:(e,t)=>{if(e){var i=e.getDimensions(),r=e.getOptions().orientation;"vertical"==r&&i.h<=t.h?e.setTranslateY(Math.round(t.y+t.h/2-i.h/2)):"horizontal"==r&&i.w<=t.w&&e.setTranslateX(Math.round(t.x+t.w/2-i.w/2))}},_renderDragButtons:e=>{var i=Me._BUTTON_SIZE+2*(Me._BUTTON_PADDING+Me._BUTTON_CORNER_DIST),r=e.__getPlotAreaSpace();if(!(!l.hasAxes(e)||l.isOverview(e)||r.w<i||r.h<i)){var s=e.getOptions(),a=s._resources,n=s.translations,o=e.getEventManager(),h=s.dragMode;if("user"==h){var g,d,u,_=t.Agent.isTouchDevice(),c=O.isScrollable(e);e.dragButtons=new t.Container(e.getCtx());var p=[],v="multiple"==s.selectionMode&&(_||c),m=c&&_,f=c&&!_&&O.isZoomable(e)&&l.isScatterBubble(e);v&&a.select&&p.push(a.select),m&&a.pan&&p.push(a.pan),f&&a.zoom&&p.push(a.zoom),u=t.ToolkitUtils.getIconStyles(e.getCtx(),p),v&&(d=m||f?"end":"solo",o.selectButton=Me._createDragButton(e,e.dragButtons,u[a.select],o.onSelectButtonClick,o,d),g=n.tooltipSelect,o.selectButton.setTooltip(g),o.associate(o.selectButton,o.selectButton)),m&&(d=v?"start":"solo",o.panButton=Me._createDragButton(e,e.dragButtons,u[a.pan],o.onPanButtonClick,o,d),g=n.tooltipPan,o.panButton.setTooltip(g),o.associate(o.panButton,o.panButton)),f&&(d=v?"start":"solo",o.zoomButton=Me._createDragButton(e,e.dragButtons,u[a.zoom],o.onZoomButtonClick,o,d),g=n.tooltipZoom,o.zoomButton.setTooltip(g),o.associate(o.zoomButton,o.zoomButton)),Me.positionDragButtons(e),o.setDragMode(null),e.dragButtons.getNumChildren()>0&&(e.addChild(e.dragButtons),_?c&&(o.panButton.setToggled(!0),o.onPanButtonClick(null)):e.hideDragButtons(),e.dragButtons.setCursor("default"))}else"pan"==h?o.setDragMode(X.DRAG_MODE_PAN):"zoom"==h?o.setDragMode(X.DRAG_MODE_ZOOM):"select"==h?o.setDragMode(X.DRAG_MODE_SELECT):o.setDragMode(X.DRAG_MODE_OFF)}},_positionDragButton:(e,i,r)=>{var s;t.Agent.isRightToLeft(e.getCtx())?(s=r.x+Me._BUTTON_PADDING,r.x+=Me._BUTTON_SIZE+2*Me._BUTTON_PADDING):s=r.x+r.w-Me._BUTTON_SIZE-Me._BUTTON_PADDING,r.w-=Me._BUTTON_SIZE+2*Me._BUTTON_PADDING,i.setTranslate(s,r.y+Me._BUTTON_PADDING)},positionDragButtons:e=>{var t=e.__getPlotAreaSpace().clone();t.x+=Me._BUTTON_CORNER_DIST,t.w-=2*Me._BUTTON_CORNER_DIST,t.y+=Me._BUTTON_CORNER_DIST;var i=e.getEventManager();i.selectButton&&Me._positionDragButton(e,i.selectButton,t),i.panButton&&Me._positionDragButton(e,i.panButton,t),i.zoomButton&&Me._positionDragButton(e,i.zoomButton,t)},_createDragButtonBackground:(e,i)=>{var r=t.Agent.isRightToLeft(e),s="start"==i&&r||"end"==i&&!r?0:2,a="start"==i&&!r||"end"==i&&r?0:2,n=s,o=a,l=-Me._BUTTON_PADDING,h=Me._BUTTON_SIZE+2*Me._BUTTON_PADDING,g=t.PathUtils.roundedRectangle(l,l,h,h,n,a,o,s),d=new t.Path(e,g);return d.setPixelHinting(t.Agent.getDevicePixelRatio()>1),d},_getImageUrl:(e,t,i,r)=>{var s,a=e.getOptions()._resources[i];return null==a?r:null!=(s=t[a])?s:a},_createDragButton:(e,i,r,s,a,n)=>{var o=e.getCtx(),l=Me._createDragButtonBackground(o,n),h=new t.IconButton(o,"outlined",{style:r,size:Me._BUTTON_SIZE},l,null,s,a);if(t.Agent.isTouchDevice()){var g,d=t.Agent.isRightToLeft(o),u=2*Me._BUTTON_PADDING;(g="solo"==n?new t.Rect(o,-u,-u,Me._BUTTON_SIZE+2*u,Me._BUTTON_SIZE+2*u):"start"==n&&!d||"end"==n&&d?new t.Rect(o,-u,-u,Me._BUTTON_SIZE+1.5*u,Me._BUTTON_SIZE+2*u):new t.Rect(o,-.5*u,-u,Me._BUTTON_SIZE+1.5*u,Me._BUTTON_SIZE+2*u)).setInvisibleFill(),g.setSolidStroke("none"),h.addChild(g)}return h.setToggleEnabled(!0),i.addChild(h),h.addEvtListener(t.MouseEvent.MOUSEDOWN,e=>{e.stopPropagation()}),h},_adjustAvailSpace:e=>{e.x=Math.round(e.x),e.y=Math.round(e.y),e.w=Math.round(e.w),e.h=Math.round(e.h)},renderDataCursor:e=>{var t=null,i=e.getOptions(),r=e.getEventManager();if(m.isDataCursorEnabled(e)){(t=new p(e.getCtx(),i.styleDefaults.dataCursor,l.isHorizontal(e))).setBehavior(m.getDataCursorBehavior(e)),e.addChild(t);var s=new xe(e,t);r.setDataCursorHandler(s),e.positionDataCursor(i.dataCursorPosition)}else r.setDataCursorHandler(null);return t}},De={processDataObj:e=>{if(d.hasData(e)){var i=e.getOptions(),r=e.getOptionsCache(),s=d.getSeriesCount(e);l.isValidType(e)||(i.type="bar");var a=!1,n=!1,o=!0,h=null,g=!1,u=!1,_=!1,p=!1,v=!1,m=l.isStock(e);m&&s>1&&(i.series=i.series.slice(0,1),s=1);var f=l.isMixedFrequency(e),x=s>100;r.putToCache("hasLargeSeriesCount",x);for(var C=0,S=e.getSeriesStyleArray(),A=0;A<s;A++){var b=d.getSeries(e,A);!x&&null!=b&&S.indexOf(b)<0&&S.push(b);var y=d.getSeriesItem(e,A);if(y.items&&y.items.length>C&&(C=y.items.length),"hidden"===y.visibility){var M=d.getHiddenCategories(e);M.indexOf(b)<0&&M.push(b)}if(y.visibility=null,"on"===y.assignedToY2&&(a=!0),"on"===y.displayInLegend&&(p=!0),"on"===y.drilling&&(v=!0),y&&y.items)for(var D,T=y.items,I=0;I<T.length;I++)null!=T[I]&&("object"!=typeof(D=T[I])&&(D={y:D},T[I]=D),f||null==D.x||(D.x=Number(D.x)),null!=D.y&&(D.y=Number(D.y),D.y<0&&(u=!0)),null!=D.z?(D.z=Number(D.z),null==h?h=D.z:h!=D.z&&(o=!1)):h=1,null!=D.value&&(D.value=Number(D.value),D.value<0&&(u=!0)),null!=D.targetValue&&(D.targetValue=Number(D.targetValue)),null!=D.open&&(D.open=Number(D.open),g=!0),null!=D.close&&(D.close=Number(D.close),g=!0,D.close<0&&(u=!0)),null!=D.low&&(D.low=Number(D.low),g=!0),null!=D.high&&(D.high=Number(D.high),g=!0),null!=D.volume&&(D.volume=Number(D.volume),n=!0),(D.color||D.borderColor||D.borderWidth||D.style||D.svgStyle||D.className||D.svgClassName)&&r.putToCachedMap("itemStyleSet",A,!0),"outsideBarEdge"==D.labelPosition&&(_=!0))}if(r.putToCache("hasVolume",n),r.putToCache("hasConstantZValue",o),r.putToCache("constantZValue",o?h:null),r.putToCache("hasLowHighSeries",g),r.putToCache("hasNegativeValues",u),r.putToCache("hasDataOutsideBarEdge",_),r.putToCache("hasSeriesDisplayedInLegend",p),r.putToCache("hasDrillableSeries",v),m&&d.hasVolumeSeries(e)&&!l.isOverview(e)){var O=t.JsonUtils.clone(d.getSeriesItem(e,0));O.assignedToY2="on",a=!0,O.type="bar",O.categories=d.getCategories(e,0),O.id="_volume",O._selectable="off",O.items=[];for(var E=y?y.items.length:0,P=0;P<E;P++){var L={};L.color=c.getStockVolumeColor(e,0,P),L.x=y&&y.items[P].x,L.value=y&&y.items[P].volume,L.drilling="off",O.items.push(L)}i.series.push(O),r.putToCachedMap("itemStyleSet",i.series.length-1,!0)}r.putToCache("hasY2Assignment",a);for(var w=d.getRefObjs(e),R=0;R<w.length;R++){var k=w[R].items;if(k)for(var B=0;B<k.length;B++){var F=k[B];F&&("object"!=typeof F?k[B]=Number(F):(!l.isMixedFrequency(e)&&F.x&&(F.x=Number(F.x)),F.max&&(F.max=Number(F.max)),F.min&&(F.min=Number(F.min)),F.value&&(F.value=Number(F.value))))}}i.groups||(i.groups=[]);for(var N=d.getGroupCount(e),H=0;H<C-N;H++){var G=i.translations.labelDefaultGroupName||"Group {0}",U=t.ResourceUtils.format(G,[i.groups.length+1]);i.groups.push(U)}r.putToCache("groupsArray",null),De._processTimeAxis(e);var V=i.sorting;if(V="on"===V?"descending":"ascending"!==V&&"descending"!==V?"off":V,l.isBLAC(e)&&l.hasGroupAxis(e)&&"off"!=V&&1==d.getNumLevels(e)){for(var Y=d.getGroups(e),W={},j=0;j<Y.length;j++){for(var z=0,X=0;X<=s;X++)if(d.isSeriesRendered(e,X)&&!d.isAssignedToY2(e,X)){var Z=d.getVal(e,X,j);z+=null==Z||isNaN(Z)?0:Z}W[Y[j]]={index:j,total:z,group:i.groups[j]}}"ascending"===V?Y.sort((e,t)=>W[e].total-W[t].total):Y.sort((e,t)=>W[t].total-W[e].total);for(var K=0;K<s;K++){for(var q=[],Q=0;Q<Y.length;Q++)q.push(d.getDataItem(e,K,W[Y[Q]].index));i.series[K].items=q}for(var J=[],$=0;$<Y.length;$++)J.push(W[Y[$]].group);i.groups=J,r.putToCache("groupsArray",null),r.putToCache("value",null)}i.styleDefaults.dataCursor.lineWidth=parseFloat(i.styleDefaults.dataCursor.lineWidth),De._sanitizeAxis(i.xAxis),De._sanitizeAxis(i.yAxis),De._sanitizeAxis(i.y2Axis)}},_processTimeAxis:e=>{var t,i,r=e.getCtx(),s=e.getOptions(),a=d.getSeriesCount(e),n=d.getGroupCount(e);if(l.isMixedFrequency(e))for(t=0;t<a;t++)for(i=0;i<n;i++){var o=d.getDataItem(e,t,i);null!=o&&"string"==typeof o.x&&null!=o.x&&(o.x=De._sanitizeDateTime(r,o.x))}else if(l.hasTimeAxis(e)){for(i=0;i<n;i++){var h=d.getGroup(e,i);null!=h&&(s.groups[i]=De._sanitizeDateTime(r,h))}e.getOptionsCache().putToCache("groupsArray",null)}if(l.hasTimeAxis(e)){var g=s.xAxis;null!=g.dataMin&&(g.dataMin=De._sanitizeDateTime(r,g.dataMin)),null!=g.dataMax&&(g.dataMax=De._sanitizeDateTime(r,g.dataMax)),null!=g.min&&(g.min=De._sanitizeDateTime(r,g.min)),null!=g.max&&(g.max=De._sanitizeDateTime(r,g.max)),null!=g.viewportMin&&(g.viewportMin=De._sanitizeDateTime(r,g.viewportMin)),null!=g.viewportMax&&(g.viewportMax=De._sanitizeDateTime(r,g.viewportMax)),null!=g.viewportStartGroup&&(g.viewportStartGroup=De._sanitizeDateTime(r,g.viewportStartGroup)),null!=g.viewportEndGroup&&(g.viewportEndGroup=De._sanitizeDateTime(r,g.viewportEndGroup));for(var u=d.getRefObjs(e),_=0;_<u.length;_++){var c=u[_].items;if(c)for(var p=0;p<c.length;p++)c[p]&&null!=c[p].x&&(c[p].x=De._sanitizeDateTime(r,c[p].x))}}},_sanitizeAxis:e=>{e.min==e.max&&(e.min=null,e.max=null)},_sanitizeDateTime:(e,t)=>{var i=null,r=e.getLocaleHelpers().isoToDateConverter;if(r){try{i=r(t)}catch(e){i=null}i=null!=i&&i.getTime?i.getTime():null}return null==i?isNaN(t)?Date.parse(t):t:i}};class Te extends t.BaseComponent{constructor(e,i,r,s){super(e,i,r,s),s||(this.Defaults=new u(e),this.EventManager=new X(this),this.EventManager.addListeners(this),t.Agent.isTouchDevice()||this.EventManager.setKeyboardHandler(this.CreateKeyboardHandler(this.EventManager)),this.setId("chart1000"+Math.floor(1e9*Math.random())),this.legend=null,this.xAxis=null,this.yAxis=null,this.y2Axis=null,this.overview=null,this.xScrollbar=null,this.yScrollbar=null,this.dragButtons=null,this.pieChart=null,this.pieCenterDiv=null,this.Peers=[],this.SeriesStyleArray=[],this._numFrontObjs=0,this._numSelectedObjsInFront=0,this._dataLabels=null,this._rawOptions=null)}static getDefaults(e){return(new u).getDefaults(e)}createOverviewChart(){return new Te(this.getCtx())}GetComponentDescription(){var e=this.getOptions(),i=e.translations.componentName,r="",s=t.AriaUtils.ARIA_LABEL_DESC_DELIMITER;return e.title.text&&(r+=this.Options.title.text,e.subtitle.text&&(r+=s+this.Options.subtitle.text)),e.footnote.text&&(r=0==r.length?this.Options.footnote.text:r.concat(s,this.Options.footnote.text)),r.length>0?t.ResourceUtils.format(this.Options.translations.labelAndValue,[i,r]):i}SetOptions(e){e?(this._rawOptions=e,this.Options=this.Defaults.calcOptions(e),this.getOptionsCache().clearCache(),De.processDataObj(this),(t.Agent.isEnvironmentTest()||l.isScatterBubble(this)&&d.getSeriesCount(this)*d.getGroupCount(this)>fe.FILTER_THRESHOLD_SCATTER_BUBBLE)&&(this.Options.animationOnDisplay="none",this.Options.animationOnDataChange="none")):this.Options||(this.Options=this.GetDefaults());var i=this.Options.selectionMode;this._selectionHandler="single"==i?new t.SelectionHandler(this.getCtx(),t.SelectionHandler.TYPE_SINGLE):"multiple"==i?new t.SelectionHandler(this.getCtx(),t.SelectionHandler.TYPE_MULTIPLE):null,this.EventManager.setSelectionHandler(this._selectionHandler)}render(e,i,r){this.getCache().clearCache();var s=this.getCtx(),a=this.Options?this.Options.animationOnDataChange:"none",n="none"!=a?new Ie(this):null,o=this.__cacheChartFocus();this._container&&this.__cleanUp(),this.SetOptions(e),isNaN(i)||isNaN(r)||(this.Width=i,this.Height=r);var h=new t.Container(s);this.addChild(h),Me.render(this,h,new t.Rectangle(0,0,this.Width,this.Height)),l.isSpark(this)&&this.EventManager.removeListeners(this),this.StopAnimation();var g=c.getAnimOnDisplay(this),d=c.getAnimDur(this),u=new t.Rectangle(0,0,this.Width,this.Height),_=!1;if(this._container){if("none"!=a&&e)if(this.Animation=t.BlackBoxAnimationHandler.getCombinedAnimation(s,a,this._container,h,u,d),this.Animation)_=!0;else if("auto"==a&&this.getPlotArea()){var p=this.__getPlotAreaSpace();this._delContainer=fe.createClippedGroup(this,this._container,new t.Rectangle(0,0,p.w,p.h)),this.Animation=ue.createAnim(n,this,a,d,this._delContainer),this._delContainer.getNumChildren()>0&&this.getPlotArea().addChild(this._delContainer)}}else"none"!=g&&(this.Animation=t.BlackBoxAnimationHandler.getInAnimation(s,g,h,u,d),this.Animation||"auto"!=g||(this.Animation=_e.createAnim(this,g,d)));this.Animation?(this.EventManager.removeListeners(this),t.Playable.appendOnEnd(this.Animation,this._onAnimationEnd,this),this.Animation.play(),this._oldContainer=this._container,!_&&this._oldContainer&&this._oldContainer.removeFromParent()):this._container&&(this._container.removeFromParent(),this._container.destroy(),this._container=null),this._container=h,this._dataCursor=Me.renderDataCursor(this),this.UpdateAriaAttributes(),this.__restoreChartFocus(o),this.Animation||this.RenderComplete()}__cleanUp(){this._dataCursor&&(this.removeChild(this._dataCursor),this._dataCursor=null),this.EventManager&&(this.EventManager.hideHoverFeedback(),this.EventManager.setPanZoomHandler(null),this.EventManager.setMarqueeZoomHandler(null),this.EventManager.setMarqueeSelectHandler(null),this.EventManager.panButton=null,this.EventManager.zoomButton=null,this.EventManager.selectButton=null),this.pieCenterDiv&&(this.getCtx().getContainer().removeChild(this.pieCenterDiv),this.pieCenterDiv=null),this.Peers=[],this.xScrollbar=null,this.yScrollbar=null,this.dragButtons&&(this.removeChild(this.dragButtons),this.dragButtons.destroy(),this.dragButtons=null),this._plotArea=null,this._areaContainer=null,this._dataLabels=null,this.getCache().clearCache()}__cleanUpAxisAndPlotArea(){this.EventManager.hideHoverFeedback(),this.Peers=[],this.xAxis&&(this._container.removeChild(this.xAxis),this.xAxis.destroy()),this.yAxis&&(this._container.removeChild(this.yAxis),this.yAxis.destroy()),this.y2Axis&&(this._container.removeChild(this.y2Axis),this.y2Axis.destroy()),this._plotArea&&this._plotArea==this._panZoomTarget?this._plotArea.setVisible(!1):this._plotArea&&(this._container.removeChild(this._plotArea),this._plotArea.destroy()),this._plotArea=null,this.getCache().clearCache()}_onAnimationEnd(){this._oldContainer&&(this._oldContainer.removeFromParent(),this._oldContainer.destroy(),this._oldContainer=null),this._delContainer&&(this._delContainer.removeFromParent(),this._delContainer.destroy(),this._delContainer=null),this.AnimationStopped||this.RenderComplete(),this.EventManager.addListeners(this),this.Animation=null,this.AnimationStopped=!1}CreateKeyboardHandler(e){return new Z(e,this)}getAutomation(){return new z(this)}getValsAt(e,t){var i=this.__getPlotAreaSpace(),r=e-i.x,s=t-i.y,a=l.isPolar(this),n=l.isHorizontal(this);if(a){r-=i.w/2,s-=i.h/2;var o=Math.sqrt(r*r+s*s),h=Math.atan2(r,-s);return h<0&&(h+=2*Math.PI),{x:this.xAxis?this.xAxis.getValAt(h):null,y:this.yAxis?this.yAxis.getValAt(o):null}}return{x:this.xAxis?this.xAxis.getValAt(n?s:r):null,y:this.yAxis?this.yAxis.getValAt(n?r:s):null,y2:this.y2Axis?this.y2Axis.getValAt(n?r:s):null}}filter(e,t){var i="out"==t?"hidden":"visible";F.setVisibility(this,e,i),this.render(this.Options)}highlight(e){this.getOptions().highlightedCategories=t.JsonUtils.clone(e),t.CategoryRolloverHandler.highlight(e,this.getObjects(),"any"==this.getOptions().highlightMatch),this.legend&&this.legend.highlight(e),this.pieChart&&this.pieChart.highlight(e),this.overview&&this.overview.getBackgroundChart().highlight(e)}select(e){this.getOptions().selection=t.JsonUtils.clone(e);var i=d.getInitialSelection(this);F.setInitialSelection(this,i),this.pieChart&&this.pieChart.setInitialSelection()}positionDataCursor(e){var i=this.getEventManager().getDataCursorHandler();if(i){if(e){var r=this.xAxis&&null!=e.x?this.xAxis.getCoordAt(e.x):null,s=null;if(l.isBLAC(this)?this.yAxis&&null!=e.y?s=this.yAxis.getBoundedCoordAt(e.y):this.y2Axis&&null!=e.y2&&(s=this.yAxis.getBoundedCoordAt(e.y2)):s=this.yAxis&&null!=e.y?this.yAxis.getCoordAt(e.y):null,null!=r&&null!=s){var a=this.__getPlotAreaSpace(),n=h.convertAxisCoord(this,new t.Point(r,s),a);return void i.processMove(new t.Point(a.x+n.x,a.y+n.y),!0)}}i.processEnd(!0)}}processEvent(e,t){var i=e.type;if("categoryHide"==i||"categoryShow"==i)this.filter(e.category,"categoryHide"==i?"out":"in");else if("categoryHighlight"==i)this!=t&&this.highlight(e.categories),this.legend&&this.legend!=t&&this.legend.processEvent(e,t);else if("selection"==i)e=this._processSelectionEvent(e);else if("dvtPanZoom"==i)e=this._processPanZoomEvent(e);else if("dvtMarquee"==i)e=this._processMarqueeEvent(e);else if("overview"==i){var r=e.subtype;if("dropCallback"==r)return;var s="scrollTime"==r||"scrollEnd"==r||"rangeChange"==r;e=this._processScrollbarEvent(e.newX1,e.newX2,s,t)}else if("dvtSimpleScrollbar"==i)e=this._processScrollbarEvent(e.newMin,e.newMax,"end"==e.subtype,t);else if("ready"==i&&this!=t)return;if(e){if("selection"==(i=e.type)){var a,n,o=this.getOptions(),l=o.selection,h=d.getCurrentSelection(this);e.complete&&(o.selection=h),l=l||[],h=h||[];var g={};for(a=0;a<l.length;a++)g[l[a].id]=!0;var u={};for(n=0;n<h.length;n++)u[h[n].id]=!0;var _={};for(n=0;n<h.length;n++){var c=h[n].id;g[c]||(_[c]=!0)}var p={};for(a=0;a<l.length;a++){var v=l[a].id;u[v]||(p[v]=!0)}e.addedSet=_,e.removedSet=p;for(var m=0;m<e.selection.length;m++)F.addEventData(this,e.selection[m]);e.component=this.getOptions()._widgetConstructor}else if("drill"===i){if(e.subType||(e.subType="_dvtOther"===e.id?"multiSeries":"series",e.series=e.id),this._processDrillSubType(e),"multiSeries"===e.subType)return;F.addEventData(this,e),delete e.subType,e.component=this.getOptions()._widgetConstructor}this.dispatchEvent(e)}}_processDrillSubType(e){var t,i=e.subType;"item"===i?t=F.addItemDrillEventData(this,e):"group"===i?t=F.addGroupDrillEventData(this,e):"series"===i?t=F.addSeriesDrillEventData(this,e):"multiSeries"===i&&(t=F.addMultiSeriesDrillEventData(this,e)),this.dispatchEvent(t)}_processSelectionEvent(e){var i=F.processIds(this,e.selection);return this._updateOverviewSelection(),t.EventFactory.newChartSelectionEvent(i,!0)}_processPanZoomEvent(e){var i=e.subtype;return"panStart"==i||"pinchStart"==i?(t.Agent.isTouchDevice()&&this._panZoomTarget!=this._plotArea&&(this._container.removeChild(this._panZoomTarget),this._panZoomTarget=this._plotArea),null):(this._lastPanZoomEvent?(e.dxMin+=this._lastPanZoomEvent.dxMin,e.dxMax+=this._lastPanZoomEvent.dxMax,e.dyMin+=this._lastPanZoomEvent.dyMin,e.dyMax+=this._lastPanZoomEvent.dyMax):t.Context.requestAnimationFrame(t.Obj.createCallback(this,this._animatePanZoomEvent)),this._lastPanZoomEvent=e,null)}_animatePanZoomEvent(){var e=this._lastPanZoomEvent;this._lastPanZoomEvent=null;var i,r,s=e.subtype,a="panEnd"==s||"zoom"==s||"pinchEnd"==s;(O.isLiveScroll(this)?(i=F.getAxisBoundsByDelta(this,e.dxMin,e.dxMax,e.dyMin,e.dyMax),this._setScrollbarViewport(i),this._setViewport(i,a)):(i=F.getAxisBoundsByDelta(this,e.dxMinTotal,e.dxMaxTotal,e.dyMinTotal,e.dyMaxTotal),this._setScrollbarViewport(i),a&&this._setViewport(i,a)),a&&(Me._setEventHandlers(this),this._panZoomTarget!=this._plotArea&&(this._container.removeChild(this._panZoomTarget),this._panZoomTarget=null)),a||!i.unchanged)&&(r=l.isBLAC(this)?t.EventFactory.newChartViewportChangeEvent(a,i.xMin,i.xMax,i.startGroup,i.endGroup,null,null):t.EventFactory.newChartViewportChangeEvent(a,i.xMin,i.xMax,null,null,i.yMin,i.yMax),this.dispatchEvent(r))}_processMarqueeEvent(e){var i,r=e.subtype,s=this.EventManager;if(F.adjustBounds(e),s.getDragMode()==X.DRAG_MODE_SELECT){var a=s.getSelectionHandler();if("start"==r)this._initSelection=e.ctrlKey?a.getSelectedIds():[];else{var n=F.getBoundedObjs(this,e);a.processInitialSelections(this._initSelection,this.getChartObjPeers()),a.processGroupSelection(n,!0)}var o=a.getSelectedIds();i=F.getAxisBounds(this,e,!1);var h="end"==r,g=t.EventFactory.newChartSelectionEvent(o,h,i.xMin,i.xMax,i.startGroup,i.endGroup,i.yMin,i.yMax,i.y2Min,i.y2Max);return"end"==r&&this._updateOverviewSelection(),g}return s.getDragMode()==X.DRAG_MODE_ZOOM?"end"!=r?null:(i=F.getAxisBounds(this,e,!0),this._setViewport(i,!0),this._setScrollbarViewport(i),Me._setEventHandlers(this),l.isBLAC(this)?t.EventFactory.newChartViewportChangeEvent(!0,i.xMin,i.xMax,i.startGroup,i.endGroup,null,null):t.EventFactory.newChartViewportChangeEvent(!0,i.xMin,i.xMax,null,null,i.yMin,i.yMax)):null}_processScrollbarEvent(e,i,r,s){return this._lastScrollbarEvent||t.Context.requestAnimationFrame(t.Obj.createCallback(this,this._animateScrollbarEvent)),this._lastScrollbarEvent={start:e,end:i,actionDone:r,source:s},null}_animateScrollbarEvent(){var e=this._lastScrollbarEvent.start,i=this._lastScrollbarEvent.end,r=this._lastScrollbarEvent.actionDone,s=this._lastScrollbarEvent.source;this._lastScrollbarEvent=null;var a=s==this.yScrollbar?this.yAxis:this.xAxis,n=F.getActualMinMax(a,e,i);if(e=n.min,i=n.max,(O.isLiveScroll(this)||r)&&(s==this.yScrollbar?this._setViewport({yMin:e,yMax:i},r):this._setViewport({xMin:e,xMax:i,unchanged:n.unchanged},r)),r||!n.unchanged){var o;if(s==this.yScrollbar)o=t.EventFactory.newChartViewportChangeEvent(r,null,null,null,null,e,i,null,null);else{var l=F.getAxisStartEndGroup(this.xAxis,e,i);o=t.EventFactory.newChartViewportChangeEvent(r,e,i,l.startGroup,l.endGroup,null,null,null,null)}this.dispatchEvent(o)}}_updateOverviewSelection(){if(this.overview){var e=this.overview.getBackgroundChart();e.getOptions().selection=d.getCurrentSelection(this),e.render()}}changeOption(e,i,r){this.getOptions()[e]=i,this.dispatchEvent(t.EventFactory.newOptionChangeEvent(e,i,r))}registerObject(e){this.Peers.push(e)}getObjects(){return this.Peers}getChartObjPeers(){for(var e=[],t=0;t<this.Peers.length;t++)this.Peers[t]instanceof f&&e.push(this.Peers[t]);return e}getRefObjPeers(){for(var e=[],t=0;t<this.Peers.length;t++)this.Peers[t]instanceof x&&e.push(this.Peers[t]);return e}getObject(e,t){for(var i=0;i<this.Peers.length;i++)if(this.Peers[i]instanceof f&&this.Peers[i].getSeriesIndex()==e&&this.Peers[i].getGroupIndex()==t)return this.Peers[i];return null}getWidth(){return this.Width}getHeight(){return this.Height}getSeriesStyleArray(){return this.SeriesStyleArray}getPlotArea(){return this._plotArea}setPlotArea(e){this._plotArea=e}getType(){return this.getOptions().type}getSkin(){return this.getOptions().skin}getGapWidthRatio(){var e=this.getOptions();return null!==e.layout.gapWidthRatio?e.layout.gapWidthRatio:Math.min(this.Width/400,1)}getGapHeightRatio(){var e=this.getOptions();return null!==e.layout.gapHeightRatio?e.layout.gapHeightRatio:Math.min(this.Height/300,1)}getSelectionHandler(){return this._selectionHandler}isSelectionSupported(){return!!this._selectionHandler}_setViewport(e,t){!t&&e.unchanged||(null!=e.xMax&&(this.Options.xAxis.viewportMax=e.xMax),null!=e.xMin&&(this.Options.xAxis.viewportMin=e.xMin),l.isBLAC(this)?(this.Options.xAxis.viewportStartGroup=null,this.Options.xAxis.viewportEndGroup=null,this.Options._initialZoomed=!1):(null!=e.yMax&&(this.Options.yAxis.viewportMax=e.yMax),null!=e.yMin&&(this.Options.yAxis.viewportMin=e.yMin)),this.Options._duringZoomAndScroll=!t,Me.rerenderAxisAndPlotArea(this,this._container))}_setScrollbarViewport(e){if(this.xAxis&&null!=e.xMin&&null!=e.xMax){var t=this.xAxis.actualToLinear(e.xMin),i=this.xAxis.actualToLinear(e.xMax);this.overview&&this.overview.setViewportRange(t,i),this.xScrollbar&&this.xScrollbar.setViewportRange(t,i)}if(this.yAxis&&null!=e.yMin&&null!=e.yMax){var r=this.yAxis.actualToLinear(e.yMin),s=this.yAxis.actualToLinear(e.yMax);this.yScrollbar&&this.yScrollbar.setViewportRange(r,s)}}__setAxisSpace(e){var t,i;this._axisSpace=e,w.isAxisRendered(this,"x")?(t=.8*e.w,i=e.h-4*w.getTickLabelHeight(this,"x")):w.isAxisRendered(this,"y")?(t=e.w,i=e.h-w.getTickLabelHeight(this,"y")):(t=e.w,i=e.h),this._radius=Math.min(t,i)/2}__getAxisSpace(){return this._axisSpace}__setPlotAreaSpace(e){this._plotAreaSpace=e}__getPlotAreaSpace(){return this._plotAreaSpace}__setAreaContainer(e){this._areaContainer=e}__getAreaContainer(){return this._areaContainer}getRadius(){return this._radius}showDragButtons(){this.dragButtons&&this.dragButtons.setVisible(!0)}hideDragButtons(){this.dragButtons&&this.dragButtons.setVisible(!1)}addDataLabel(e){this.getDataLabels().push(e)}getDataLabels(){return this._dataLabels||(this._dataLabels=[]),this._dataLabels}__cacheChartFocus(){var e=this.EventManager.getFocus();if(e)var t=e.isShowingKeyboardFocusEffect();if(this.xAxis){var i=this.xAxis.getKeyboardFocus();if(i)var r=i.isShowingKeyboardFocusEffect()}if(this.legend){var s=this.legend.getKeyboardFocus();if(s)var a=s.isShowingKeyboardFocusEffect()}return{chartFocus:e,chartShowingFocusEffect:t,axisFocus:i,axisShowingFocusEffect:r,legendFocus:s,legendShowingFocusEffect:a,sorting:this.getOptions().sorting}}__restoreChartFocus(e){if(!l.isOverview(this)&&!l.isSpark(this)){var t=[this];if(this.xAxis&&this.xAxis.isNavigable()&&t.push(this.xAxis),this.legend&&this.legend.isNavigable()&&t.push(this.legend),this.getCtx().setKeyboardFocusArray(t),e.legendFocus&&(this.legend.setKeyboardFocus(e.legendFocus,e.legendShowingFocusEffect),e.legendShowingFocusEffect&&this.getCtx().setCurrentKeyboardFocus(this.legend)),this.Options.sorting!=e.sorting){if(e.chartFocus){var i=F.getKeyboardNavigables(this);this.EventManager.setFocusObj(this.EventManager.getKeyboardHandler().getDefaultNavigable(i))}return e.axisFocus&&this.xAxis.setKeyboardFocus(this.xAxis.EventManager.getKeyboardHandler().getDefaultNavigable(this.xAxis.__getKeyboardObjects()),e.axisShowingFocusEffect),void(e.axisShowingFocusEffect&&this.getCtx().setCurrentKeyboardFocus(this.xAxis))}if(e.chartFocus){for(var r=F.getKeyboardNavigables(this),s=!1,a=0;a<r.length;a++){var n=r[a].getId();if(n instanceof o&&n.equals(e.chartFocus.getId())){this.EventManager.setFocusObj(r[a]),e.chartShowingFocusEffect&&r[a].showKeyboardFocusEffect(),s=!0;break}}s||this.EventManager.setFocusObj(this.EventManager.getKeyboardHandler().getDefaultNavigable(r))}e.axisFocus&&(this.xAxis.setKeyboardFocus(e.axisFocus,e.axisShowingFocusEffect),e.axisShowingFocusEffect&&this.getCtx().setCurrentKeyboardFocus(this.xAxis))}}getRawOptions(){return this._rawOptions}}class Ie extends Te{constructor(e){super(null,null,null,!0),this.Options=e.Options,this.Peers=e.Peers,this.SeriesStyleArray=e.SeriesStyleArray,this.Cache=e.Cache,this.pieChart=e.pieChart,this._optionsCache=new t.BaseComponentCache,this._cache=new t.BaseComponentCache}getCache(){return this._cache}getOptionsCache(){return this._optionsCache}}class Oe extends t.Automation{getDataItem(e){var t=this._comp.__getChart().getAutomation().getDataItem(0,e);return t?{borderColor:t.borderColor,color:t.color,date:t.x,low:t.low,high:t.high,value:null==t.low||null==t.high?t.value:t.high-t.low}:null}}class Ee extends t.BaseComponentDefaults{constructor(e){super({alta:{skin:t.CSSStyle.SKIN_ALTA,type:"line",animationOnDisplay:"none",animationOnDataChange:"none",areaSvgClassName:"",emptyText:null,color:"#267db3",firstColor:"",lastColor:"",highColor:"",lowColor:"",visualEffects:"auto",baselineScaling:"min",barSpacing:"auto",lineWidth:1,lineStyle:"solid",lineType:"straight",markerSize:5,markerShape:"auto",barGapRatio:.25,referenceObjects:[],svgClassName:"",_statusMessageStyle:new t.CSSStyle("font-size: 12px; color: #404259;")}},e)}}class Pe extends t.EventManager{constructor(e){super(e.getCtx(),e.dispatchEvent,e,e),this._sparkChart=e}ProcessKeyboardEvent(e){if(!this.KeyboardHandler)return!1;if(e.keyCode==t.KeyboardEvent.TAB){var i=this._sparkChart.getCtx().getStageAbsolutePosition();this.ProcessObjectTooltip(e,i.x,i.y,this._sparkChart.__getLogicalObj(),this._sparkChart)}return!1}OnBlur(e){super.OnBlur(e),this.hideTooltip()}}const Le={render:(e,t,i)=>{var r=e.__getChart(),s=Le._convertOptionsObj(e),a=e.getOptions();if("area"==a.type||"line"==a.type||"lineWithArea"==a.type){var n=Le._getDataItems(e),o=!1;if(a.firstColor||a.lastColor||a.highColor||a.lowColor)o=!0;else for(var l=0;l<n.length;l++)if(n[l]&&"on"==n[l].markerDisplayed){o=!0;break}if(o&&n.length>0||"none"==a.lineType){var h=a.markerSize/2;t-=2*h,i-=2*h,r.setTranslate(h,h)}}r.render(s,t,i)},_getDataItems:e=>{var t=e.getOptions();return t&&t.items?t.items:[]},_convertOptionsObj:e=>{for(var i=e.getOptions(),r={styleDefaults:{},xAxis:{},yAxis:{},groups:[],translations:i.translations},s=[],a=-1,n=-1,o=-1/0,l=1/0,h=Le._getDataItems(e),g=0;g<h.length;g++){var d=h[g],u={};d instanceof Object?(u.value=d.value,u.low=d.low,u.high=d.high,d.date&&(r.timeAxisType="enabled",r.groups.push(d.date)),"on"==d.markerDisplayed&&(u.markerDisplayed="on"),d.color&&(u.color=d.color),d.borderColor&&(u.borderColor=d.borderColor),d.markerShape&&(u.markerShape=d.markerShape),d.markerSize&&(u.markerSize=d.markerSize),(d.className||d.svgClassName)&&(u.svgClassName=d.className||d.svgClassName),(d.style||d.svgStyle)&&(u.svgStyle=d.style||d.svgStyle)):u.value=d,s.push(u);var _=null!=u.value?u.value:Math.max(u.low,u.high);o<_&&(o=_,a=g);var c=null!=u.value?u.value:Math.min(u.low,u.high);l>c&&(l=c,n=g)}if(i.highColor&&a>=0&&(s[a].markerDisplayed="on",s[a].color||(s[a].color=i.highColor)),i.lowColor&&n>=0&&(s[n].markerDisplayed="on",s[n].color||(s[n].color=i.lowColor)),i.firstColor&&s.length>0&&(s[0].markerDisplayed="on",s[0].color||(s[0].color=i.firstColor)),i.lastColor&&s.length>0&&(s[s.length-1].markerDisplayed="on",s[s.length-1].color||(s[s.length-1].color=i.lastColor)),r.series=[{items:s,areaColor:i.areaColor,svgClassName:i.className||i.svgClassName,svgStyle:i.style||i.svgStyle,areaSvgClassName:i.areaClassName||i.areaSvgClassName,areaStyle:i.areaStyle||i.areaSvgStyle}],i.referenceObjects&&i.referenceObjects.length>0){var p;r.yAxis.referenceObjects=i.referenceObjects,r._defaultReferenceObjectLineWidth=1;for(var v=0;v<i.referenceObjects.length;v++)"area"===(p=i.referenceObjects[v]).type?(null!=p.high&&(o=Math.max(o,p.high),l=Math.min(l,p.high)),null!=p.low&&(o=Math.max(o,p.low),l=Math.min(l,p.low))):null!=p.value&&(o=Math.max(o,p.value),l=Math.min(l,p.value))}r.__spark=!0;var m=i.barSpacing;"auto"==m&&(m=t.Agent.getDevicePixelRatio()>1?"subpixel":"pixel"),r.__sparkBarSpacing=m,r.type=i.type,r.animationOnDataChange=i.animationOnDataChange,r.animationOnDisplay=i.animationOnDisplay,r.emptyText=i.emptyText,i.color&&(r.styleDefaults.colors=[i.color]),r.styleDefaults.animationDuration=i.animationDuration,r.styleDefaults.animationIndicators="none",r.styleDefaults.lineWidth=i.lineWidth,r.styleDefaults.lineStyle=i.lineStyle,r.styleDefaults.lineType=i.lineType,r.styleDefaults.markerSize=i.markerSize,r.styleDefaults.markerShape=i.markerShape,r.styleDefaults.barGapRatio=i.barGapRatio,r.styleDefaults.dataItemGaps="0%",r.xAxis.rendered="off",r.yAxis.rendered="off";var f="zero"==i.baselineScaling,x=o!=l?.1*(o-l):.1*Math.abs(o);return r.yAxis.min=f&&l>=0?0:l-x,r.yAxis.max=f&&o<=0?0:o+x,"none"==i.visualEffects||"area"!=i.type&&"lineWithArea"!=i.type?r.styleDefaults.seriesEffect="color":r.styleDefaults.seriesEffect="gradient",r.layout={gapWidthRatio:0,gapHeightRatio:0},r.legend={rendered:"off"},r._statusMessageStyle=i._statusMessageStyle,r}};class we extends t.BaseComponent{constructor(e,i,r){super(e,i,r),e.getStage().setCursor(""),this.Defaults=new Ee(e),this.EventManager=new Pe(this),this.EventManager.addListeners(this),this._chart=new Te(e,this._onRenderEnd,this),this.addChild(this._chart),t.Agent.isTouchDevice()||this.EventManager.setKeyboardHandler(new t.KeyboardHandler(this.EventManager,this)),this._tooltipMask=new t.Rect(e),this.addChild(this._tooltipMask),this.setId("sparkChart1000"+Math.floor(1e9*Math.random()))}SetOptions(e){e?(this.Options=this.Defaults.calcOptions(e),t.Agent.isEnvironmentTest()&&(this.Options.animationOnDisplay="none",this.Options.animationOnDataChange="none")):this.Options||(this.Options=this.GetDefaults())}setId(e){super.setId(e),this._chart&&this._chart.setId(e+"chart")}render(e,i,r){this.SetOptions(e),isNaN(i)||isNaN(r)||(this.Width=i,this.Height=r),this._eventReceived=!1,this._isDoneRendering=!1,Le.render(this,this.Width,this.Height);var s=this.Options.shortDesc;this._tooltipMask.setWidth(this.Width),this._tooltipMask.setHeight(this.Height),this._tooltipMask.setInvisibleFill();var a=this.Options.tooltip,n=a?a.renderer:null,o=this.Options.color;if(n){var l={component:this.Options._widgetConstructor,color:o};this._peer=new t.CustomDatatipPeer(this.getCtx().getTooltipManager(),n,o,l),this.EventManager.associate(this._tooltipMask,this._peer)}else s?(this._peer=new t.SimpleObjPeer(null,s,o),this.EventManager.associate(this._tooltipMask,this._peer)):this._peer=null;this.Options._selectingCursor&&this.setCursor(t.SelectionEffectUtils.getSelectingCursor()),this.UpdateAriaAttributes(),this._eventReceived&&this.RenderComplete(),this._isDoneRendering=!0}_onRenderEnd(e){this._eventReceived=!0,"ready"==e.type&&this._isDoneRendering&&this.RenderComplete()}__getChart(){return this._chart}getAutomation(){return new Oe(this)}UpdateAriaAttributes(){var e=t.Displayable.generateAriaLabel(t.AriaUtils.processAriaLabel(this.GetComponentDescription()),this.Options.shortDesc?[this.Options.shortDesc]:null),i=this.Options.translations;this.IsParentRoot()?(this.getCtx().setAriaRole("img"),this.getCtx().setAriaLabel(t.ResourceUtils.format(i.labelAndValue,[i.labelDataVisualization,e]))):(this.setAriaRole("img"),this.setAriaProperty("label",e))}__getLogicalObj(){return this._peer}}e.Chart=Te,e.SparkChart=we,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=ojchart-toolkit.js.map