/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","ojs/ojcore-base","ojs/ojdatasource-common"],function(t,e,r){"use strict";const o=function(t,e,r,o,n){this.m_startRow=t,this.m_endRow=e,this.m_startColumn=r,this.m_endColumn=o,this.m_callback=n};(e=e&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e)._registerLegacyNamespaceProp("ArrayCellSet",o),o.prototype.getData=function(t){var e=this,r=t.row,o=t.column,n={};return Object.defineProperty(n,"data",{enumerable:!0,get:function(){return e.m_callback._getCellData(r,o)},set:function(t){e.m_callback._setCellData(r,o,t)}}),n},o.prototype.getMetadata=function(t){return this.m_callback._getCellMetadata(t.row,t.column)},o.prototype.getStart=function(t){return"row"===t?this.m_startRow:"column"===t?this.m_startColumn:-1},o.prototype.getCount=function(t){return"row"===t?Math.max(0,this.m_endRow-this.m_startRow):"column"===t?Math.max(0,this.m_endColumn-this.m_startColumn):0},o.prototype.getExtent=function(t){return{row:{extent:1,more:{before:!1,after:!1}},column:{extent:1,more:{before:!1,after:!1}}}},o.prototype.getStartRow=function(){return this.m_startRow},o.prototype.getStartColumn=function(){return this.m_startColumn};const n=function(t,e){if(!(t instanceof Array)&&"function"!=typeof t&&"function"!=typeof t.subscribe){throw new Error("_ERR_DATA_INVALID_TYPE_SUMMARY\n_ERR_DATA_INVALID_TYPE_DETAIL")}this.rowHeaderKey=this._getRowHeaderFromOptions(e),null!=e&&(this.columns=e.columns,this.sortCriteria=e.initialSort),n.superclass.constructor.call(this,t)};e._registerLegacyNamespaceProp("ArrayDataGridDataSource",n),e.Object.createSubclass(n,e.DataGridDataSource,"oj.ArrayDataGridDataSource"),n.prototype.Init=function(){null==this.columns&&(this.columns=this._getColumnsForScaffolding(this.getDataArray())),this._initializeRowKeys(),"function"==typeof this.data&&this.data.subscribe(this._subscribe.bind(this),null,"arrayChange"),n.superclass.Init.call(this)},n.prototype.comparator=null,n.prototype.sortCriteria=null,n.prototype._getRowHeaderFromOptions=function(t){if(null!=t&&null!=t.rowHeader){var e=t.rowHeader;if("object"==typeof e){if(null!=e.default){if("none"===e.default)return;if("index"===e.default)return"m_defaultIndex"}}else if(null!=e)return e}return"m_defaultIndex"},n.prototype._initializeRowKeys=function(){var t;for(t=this.getDataArray(),this.lastKey=0;this.lastKey<t.length;this.lastKey+=1)t[this.lastKey].ojKey=this.lastKey.toString()},n.prototype._getColumnsForScaffolding=function(t){if("number"!=typeof t.length||0===t.length)return[];for(var e=[],r=Object.keys(t[0]),o=0;o<r.length;o++){var n=r[o];void 0!==this.rowHeaderKey&&n===this.rowHeaderKey||e.push(n)}return e},n.prototype.getCount=function(t){return"row"===t?this._size():"column"===t?this.columns.length:0},n.prototype.getCountPrecision=function(t){return"exact"},n.prototype._getHeaderData=function(t,e){return"row"===t?void 0===this.rowHeaderKey?null:"m_defaultIndex"===this.rowHeaderKey?this._getRowKeyByIndex(e):this.getDataArray()[e][this.rowHeaderKey]:"column"===t?this.columns[e]:void 0},n.prototype._getHeaderMetadata=function(t,e){var r;return"row"===t?{key:this._getRowKeyByIndex(e)}:"column"===t?(r=this._getHeaderData(t,e),null!=this.sortCriteria&&this.sortCriteria.key===r?{key:this._getHeaderData(t,e),sortDirection:this.sortCriteria.direction}:{key:r}):void 0},n.prototype.fetchHeaders=function(t,r,o){var n,s=t.axis,a=t.start,i=t.count;if(a=Math.max(0,a),"column"===s)this.columns.length||this._populateColumns(),n=Math.min(this.columns.length,a+i);else{var l=this.getDataArray();n=void 0===this.rowHeaderKey?a:Math.min(l.length,a+i)}var u=new e.ArrayHeaderSet(a,n,s,this);null!=r&&null!=r.success&&(null==o&&(o={}),r.success.call(o.success,u,t,null))},n.prototype._getCellData=function(t,e){var r=this.columns[e];return this.getDataArray()[t][r]},n.prototype._setCellData=function(t,e,r){this.getDataArray()[t][this.columns[e]]=r},n.prototype._getCellMetadata=function(t,e){return{keys:{row:this._getRowKeyByIndex(t),column:this.columns[e]}}},n.prototype.fetchCells=function(t,r,o){for(var n,s,a,i,l=0;l<t.length;l+=1){var u=t[l];"row"===u.axis?(n=u.start,s=Math.min(this._size(),n+u.count)):"column"===u.axis&&(this.columns.length||this._populateColumns(),a=u.start,i=Math.min(this.columns.length,a+u.count))}if(void 0!==s&&void 0!==i){var c=new e.ArrayCellSet(n,s,a,i,this);null!=r&&null!=r.success&&(null==o&&(o={}),r.success.call(o.success,c,t))}else null!=r&&null!=r.error&&(null==o&&(o={}),r.error.call(o.error))},n.prototype.keys=function(t){var e=t.row,r=t.column;return new Promise(function(t){t({row:this._getRowKeyByIndex(e),column:this.columns[r]})}.bind(this))},n.prototype.indexes=function(t){var e=t.row,r=t.column;return new Promise(function(t){t({row:this._getRowIndexByKey(e),column:this.columns.indexOf(r)})}.bind(this))},n.prototype.sort=function(t,e,r){var o=[],n=[];if(null!=e&&null==r&&(r={}),void 0===this.origData&&(this._origSortCriteria=this.sortCriteria,this.origData=this.data.slice()),null==t?t=this.sortCriteria:this.sortCriteria=t,null!=t){var s=t.axis,a=t.key;if("column"===s)this.getDataArray().sort(this._getComparator()),null!=e&&null!=e.success&&e.success.call(r.success);else if("row"===s){var i,l=this._getRowIndexByKey(a);for(i=0;i<this.columns.length;i+=1)o[i]=this.getDataArray()[l][this.columns[i]];for(o.sort(this._getComparator()),i=0;i<this.columns.length;i+=1)n[i]=this.columns[o.indexOf(this.getDataArray()[l][this.columns[i]])];this.origColumns=this.columns,this.columns=n,null!=e&&null!=e.success&&e.success.call(r.success)}else null!=e&&null!=e.error&&e.error.call(r.error,"Invalid axis value")}else this._resetSortOrder(e,r)},n.prototype._resetSortOrder=function(t,e){void 0!==this.origData&&(this.data=this.origData,this.sortCriteria=this._origSortCriteria),null!=this.origColumns&&(this.columns=this.origColumns),null!=t&&null!=t.success&&t.success.call(e.success)},n.prototype.getCapability=function(t){return"sort"===t?"column":"move"===t?"row":null},n.prototype._getComparator=function(){var t=this.comparator;if(null==t){var e=this.sortCriteria.key,r=this.sortCriteria.direction,o=this.sortCriteria.axis;return this._naturalSort(r,e,o)}return t},n.prototype._naturalSort=function(t,e,r){return"ascending"===t?function(t,o){var n,s,a=t,i=o;return null!=e&&"column"===r&&(a instanceof Array?(a=a[parseInt(e,10)],i=i[parseInt(e,10)]):(a=a[e],i=i[e])),n=isNaN(a),s=isNaN(i),a instanceof Date&&(a=a.toISOString(),n=!0),i instanceof Date&&(i=i.toISOString(),s=!0),n&&s?a<i?-1:a===i?0:1:n?1:s?-1:a-i}:"descending"===t?function(t,o){var n,s,a=t,i=o;return null!=e&&"column"===r&&(a instanceof Array?(a=a[parseInt(e,10)],i=i[parseInt(e,10)]):(a=a[e],i=i[e])),n=isNaN(a),s=isNaN(i),a instanceof Date&&(a=a.toISOString(),n=!0),i instanceof Date&&(i=i.toISOString(),s=!0),n&&s?a>i?-1:a===i?0:1:n?-1:s?1:i-a}:void 0},n.prototype.move=function(t,e,r,o,n){var s,a,i=this._getRowIndexByKey(t),l=this.data.splice(i,1)[0];this.data instanceof Array&&(a=this._getModelEvent("delete",t,null,i,-1,!0),this.handleEvent("change",a)),null===e?(this.data.push(l),s=this.data.length-1):(s=this._getRowIndexByKey(e),this.data.splice(s,0,l)),this.data instanceof Array&&(a=this._getModelEvent("insert",t,null,s,-1),this.handleEvent("change",a)),void 0!==this.origData&&(this.origData=this.data.slice())},n.prototype.moveOK=function(t,e,r){return"valid"},n.prototype.getDataArray=function(){return"function"==typeof this.data?this.data():this.data},n.prototype._getRowIndexByKey=function(t){for(var e=this.getDataArray(),r=0;r<e.length;r++)if(e[r].ojKey===t)return r;return-1},n.prototype._getRowKeyByIndex=function(t){var e=this.getDataArray();return e[t]?(e[t].ojKey||this._initializeRowKeys(),e[t].ojKey):null},n.prototype._getModelEvent=function(t,e,r,o,n,s){var a={};return a.source=this,a.operation=t,a.keys={row:e,column:r},a.indexes={row:o,column:n},a.silent=s,a},n.prototype._subscribe=function(t){var e,r,o,n=!1,s=!1;for(e=0;e<t.length;e++){if(void 0!==(r=t[e]).moved){s=!0,o=this._getModelEvent("refresh",null,null),this.handleEvent("change",o);break}"added"===r.status&&(n=!0)}if(!s){var a,i,l,u=[],c=[];for(e=0;e<t.length;e++)"deleted"===(r=t[e]).status&&(a=r.value,l=r.index,i=a.ojKey,u.push({row:i,column:-1}),c.push({row:l,column:-1}));for(u.length>0&&(o={source:this,operation:"delete",keys:u,indexes:c,silent:n},this.handleEvent("change",o)),e=0;e<t.length;e++)"added"===(r=t[e]).status&&(a=r.value,l=r.index,null==a.ojKey&&(a.ojKey=this.lastKey.toString(),this.lastKey+=1),i=a.ojKey,o=this._getModelEvent("insert",i,null,l,-1),this.handleEvent("change",o))}void 0!==this.origData&&(this.origData=this.data.slice())},n.prototype._size=function(){return this.getDataArray().length},n.prototype.getRowHeaderKey=function(){return this.rowHeaderKey},n.prototype.getColumns=function(){return this.columns},n.prototype.getData=function(){return this.data},n.prototype._populateColumns=function(){if(this.getDataArray().length)for(var t=this.getDataArray()[0].length,e=0;e<t;e++)this.columns.push(e.toString())};const s=function(t,e,r,o){this.m_start=t,this.m_end=e,this.m_axis=r,this.m_callback=o};e._registerLegacyNamespaceProp("ArrayHeaderSet",s),s.prototype.getData=function(t,r){return null==this.m_callback?null:(e.Assert.assert(t<=this.m_end&&t>=this.m_start,"index out of bounds"),e.Assert.assert(null==r||0===r,"level out of bounds"),this.m_callback._getHeaderData(this.m_axis,t))},s.prototype.getMetadata=function(t,r){return null==this.m_callback?null:(e.Assert.assert(t<=this.m_end&&t>=this.m_start,"index out of bounds"),e.Assert.assert(null==r||0===r,"level out of bounds"),this.m_callback._getHeaderMetadata(this.m_axis,t))},s.prototype.getLevelCount=function(){return this.getCount()>0?1:0},s.prototype.getExtent=function(t,r){return e.Assert.assert(t<=this.m_end&&t>=this.m_start,"index out of bounds"),e.Assert.assert(null==r||0===r,"level out of bounds"),{extent:1,more:{before:!1,after:!1}}},s.prototype.getDepth=function(t,r){return e.Assert.assert(t<=this.m_end&&t>=this.m_start,"index out of bounds"),e.Assert.assert(null==r||0===r,"level out of bounds"),1},s.prototype.getLabel=function(){return null},s.prototype.getCount=function(){return null==this.m_callback?0:Math.max(0,this.m_end-this.m_start)},s.prototype.getStart=function(){return this.m_start},t.ArrayCellSet=o,t.ArrayDataGridDataSource=n,t.ArrayHeaderSet=s,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ojarraydatagriddatasource.js.map