( function ( $ ) {
    /**
     * Legacy Functions
     */
    function getCalendar( pCalendar ) {
        if ( pCalendar ) {
            return pCalendar;
        }
    }
    function getView( pCalendar ) {
        if ( pCalendar ) {
            return pCalendar.view;
        }
    }
    function getSetOption( pCalendar, pOptionName, pOptionValue ) {
        var result;
        if ( pCalendar ) {
            if ( pOptionName && pOptionValue === undefined ) {
                result = pCalendar.getOption( pOptionName );
            } else if ( pOptionName && pOptionValue !== undefined ) {
                pCalendar.setOption( pOptionName, pOptionValue );
                result = undefined;
            }
            return result;
        }
    }
    function rerenderEvents( pCalendar ) {
        if ( pCalendar ) {
            pCalendar.render();
            return;
        }
    }
    function clientEvents( pCalendar, pEventId ) {
        var result;
        if ( pCalendar ) {
            if ( pEventId ) {
                result = pCalendar.getEventById( pEventId );
            } else {
                result = pCalendar.getEvents();
            }
            return result;
        }
    }
    function removeEvents( pCalendar, pEventId ) {
        if ( pCalendar && pEventId ) {
            var event = pCalendar.getEventById( pEventId );
            if ( event ) {
                event.remove();
            }
            return;
        }
    }
    function destroy( pCalendar, pElement ) {
        if ( pCalendar ) {
            pCalendar.destroy();
            pElement.removeData( "fullCalendar" );
        }
    }
    /**
     * jQuery FullCalendar Plugin / Function
     */
    $.fullCalendar         = FullCalendar;
    $.fullCalendar.locales = $.fullCalendar.globalLocales || [];

    $.fn.fullCalendar = function ( options ) {
        var args = Array.prototype.slice.call( arguments, 1 ); // for a possible method call
        var res = this; // what this function will return (this jQuery object by default)
        console.log( "args", args );

        this.each( function ( i, _element ) {
            var element = $( _element );
            var calendar = element.data( "fullCalendar" ); // get the existing calendar object (if any)
            var singleRes; // the returned value of this single method call
            // a method call
            if ( typeof options === "string" ) {
                if ( options === "getCalendar" ) {
                    res = getCalendar( calendar );
                } else if ( options === "getView" ) {
                    res = getView( calendar );
                } else if ( options === "option" ) {
                    res = getSetOption( calendar, args[0], args[1] );
                } else if ( options === "rerenderEvents" ) {
                    res = rerenderEvents( calendar );
                } else if ( options === "clientEvents" ) {
                    res = clientEvents( calendar, args[0] );
                } else if ( options === "removeEvents" ) {
                    res = removeEvents( calendar, args[0] );
                } else if ( options === "destroy" ) {
                    destroy( calendar, element );
                } else if ( !calendar ) {
                    console.warn( "Attempting to call a FullCalendar method on an element with no calendar." );
                } else if ( $.isFunction( calendar[ options ] ) ) {
                    singleRes = calendar[ options ].apply( calendar, args );
                    if ( !i ) {
                        res = singleRes; // record the first method call result
                    }
                    if ( options === "destroy" ) {
                        // for the destroy method, must remove Calendar object data
                        element.removeData( "fullCalendar" );
                    }
                } else {
                    console.warn( "'" + options + "' is an unknown FullCalendar method." );
                }
            } else if ( !calendar ) {
                // don't initialize twice
                calendar = new FullCalendar.Calendar( element[ 0 ], options );
                element.data( "fullCalendar", calendar );
                calendar.render();
            }
        } );
        return res;
    };
} )( jQuery );
