/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojconverterutils-i18n',["exports","ojs/ojcore-base","ojs/ojtranslation","jquery","ojs/ojconverterutils","ojs/ojvalidation-error","ojs/ojlogger"],function(e,t,r,n,o,a,i){"use strict";t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t,n=n&&Object.prototype.hasOwnProperty.call(n,"default")?n.default:n,o=o&&Object.prototype.hasOwnProperty.call(o,"default")?o.default:o;const s={numeringSystems:{latn:"0123456789",arab:"٠١٢٣٤٥٦٧٨٩",thai:"๐๑๒๓๔๕๖๗๘๙"},regexTrim:/^\s+|\s+$|\u200f|\u200e/g,regexTrimNumber:/\s+|\u200f|\u200e/g,regexTrimRightZeros:/0+$/g,zeros:["0","00","000"],_ISO_DATE_REGEXP:/^[+-]?\d{4}(?:-\d{2}(?:-\d{2})?)?(?:T\d{2}:\d{2}(?::\d{2}(?:\.\d{1,3})?)?(Z|[+-]\d{2}(?::?\d{2})?)?)?$|^T\d{2}:\d{2}(?::\d{2}(?:\.\d{1,3})?)?(Z|[+-]\d{2}(?::?\d{2})?)?$/,getLocalTimeZoneOffset:function(e){var t=(e||new Date).getTimezoneOffset();return s.getTimeStringFromOffset("Etc/GMT",t,!1,!1)},dateToLocalIso:function(e){var t=e;"number"==typeof t&&(t=new Date(t));var r=s.padZeros(t.getFullYear(),4)+"-"+s.padZeros(t.getMonth()+1,2)+"-"+s.padZeros(t.getDate(),2)+"T"+s.padZeros(t.getHours(),2)+":"+s.padZeros(t.getMinutes(),2)+":"+s.padZeros(t.getSeconds(),2);return t.getMilliseconds()>0&&(r+="."+s.trimRightZeros(s.padZeros(t.getMilliseconds(),3))),r},dateToLocalIsoDateString:function(e){return s.dateToLocalIso(e).split("T")[0]},partsToIsoString:function(e){var t=s.padZeros(e[0],4)+"-"+s.padZeros(e[1],2)+"-"+s.padZeros(e[2],2)+"T"+s.padZeros(e[3],2)+":"+s.padZeros(e[4],2)+":"+s.padZeros(e[5],2);return e[6]>0&&(t+="."+s.trimRightZeros(s.padZeros(e[6],3))),t},isoToLocalDate:function(e){return e&&"string"==typeof e?this._isoToLocalDateIgnoreTimezone(e):null},_isoToLocalDateIgnoreTimezone:function(e){var t=s._IsoStrParts(e),r=new Date(t[0],t[1]-1,t[2],t[3],t[4],t[5],t[6]);return r.setFullYear(t[0]),r},_IsoStrParts:function(e){!1===s._ISO_DATE_REGEXP.test(e)&&s._throwInvalidISOStringSyntax(e);var t,r=e.split("T"),n=e.indexOf("T"),o=new Date,a=!1,i=[o.getFullYear(),o.getMonth()+1,o.getDate(),0,0,0,0];if(""!==r[0]){s.startsWith(r[0],"-")&&(r[0]=r[0].substr(1),a=!0);var u=r[0].split("-");for(t=0;t<u.length;t++){var l=parseInt(u[t],10);if(1===t&&(l<1||l>12)&&s._throwInvalidISOStringRange(e,"month",l,1,12),2===t){var g=s._getDaysInMonth(i[0],i[1]-1);(l<1||l>g)&&s._throwInvalidISOStringRange(e,"day",l,1,g)}i[t]=l}a&&(i[0]=-i[0])}if(-1!==n){var f=r[1].split("."),d=f[0].split(":");for(t=0;t<d.length;t++){var c=parseInt(d[t],10);0===t&&(c<0||c>24)&&s._throwInvalidISOStringRange(e,"hour",c,0,24),1===t&&(c<0||c>59)&&s._throwInvalidISOStringRange(e,"minute",c,0,59),2===t&&(c<0||c>59)&&s._throwInvalidISOStringRange(e,"second",c,0,59),i[3+t]=c}2===f.length&&f[1]&&(i[6]=parseInt(s.zeroPad(f[1],3,!1),10))}return i},getISOStrFormatInfo:function(e){var t={format:null,dateTime:null,timeZone:"",isoStrParts:null},r=s._ISO_DATE_REGEXP.exec(e);if(null===r&&s._throwInvalidISOStringSyntax(e),r&&void 0===r[1]&&void 0===r[2])return t.format="local",t.dateTime=e,t.isoStrParts=s._IsoStrParts(t.dateTime),t;t.timeZone=void 0!==r[1]?r[1]:r[2],"Z"===t.timeZone?t.format="zulu":t.format="offset";var n=e.length,o=t.timeZone.length;return t.dateTime=e.substring(0,n-o),t.isoStrParts=s._IsoStrParts(t.dateTime),t},getISOStrFormatType:function(e){let t;const r=s._ISO_DATE_REGEXP.exec(e);if(null===r&&s._throwInvalidISOStringSyntax(e),r&&void 0===r[1]&&void 0===r[2])return t="local",t;return t="Z"===(void 0!==r[1]?r[1]:r[2])?"zulu":"offset",t},_isLeapYear:function(e){return e%400==0||e%100!=0&&e%4==0},_getDaysInMonth:function(e,t){switch(t){case 0:case 2:case 4:case 6:case 7:case 9:case 11:return 31;case 1:return s._isLeapYear(e)?29:28;default:return 30}},_throwInvalidISOStringRange:function(e,t,r,n,o){var a=new RangeError("The string "+e+" is not a valid ISO 8601 string: "+r+" is out of range.  Enter a value between "+n+" and "+o+" for "+t),i={errorCode:"isoStringOutOfRange",parameterMap:{isoString:e,value:r,minValue:n,maxValue:o,propertyName:t}};throw a.errorInfo=i,a},_throwInvalidISOStringSyntax:function(e){var t=new Error("The string "+e+" is not a valid ISO 8601 string syntax."),r={errorCode:"invalidISOString",parameterMap:{isoStr:e}};throw t.errorInfo=r,t},trim:function(e){return(e+"").replace(s.regexTrim,"")},trimRightZeros:function(e){return(e+"").replace(s.regexTrimRightZeros,"")},trimNumber:function(e){return(e+"").replace(s.regexTrimNumber,"")},startsWith:function(e,t){return 0===e.indexOf(t)},toUpper:function(e){return e.split(" ").join(" ").toUpperCase()},padZeros:function(e,t){var r=e+"",n=!1;return e<0&&(r=r.substr(1),n=!0),t>1&&r.length<t&&(r=(r=s.zeros[t-2]+r).substr(r.length-t,t)),n&&(r="-"+r),r},zeroPad:function(e,t,r){for(var n=""+e,o=n.length;o<t;o+=1)n=r?"0"+n:n+"0";return n},getTimeStringFromOffset:function(e,t,r,n){var o=r?t>=0:t<0,a=Math.abs(t),i=Math.floor(a/60),u=a%60,l=o?"-":"+";n&&(i=s.zeroPad(i,2,!0));var g=e+l+i;return(u>0||n)&&(g+=":"+s.zeroPad(u,2,!0)),g},getNumberingSystemKey:function(e,t){if(void 0===t)return"latn";var r=s.getNumberingExtension(t),n="symbols-numberSystem-"+r;return void 0===e.numbers[n]&&(r="latn"),r},getBCP47Lang:function(e){return e.split("-")[0]},getBCP47Region:function(e){var t=e.split("-");return 3===t.length?t[2]:2===t.length&&2===t[1].length?t[1]:"001"},getNumberingExtension:function(e){var t=e||"en-US",r=t.indexOf("-u-nu-"),n="latn";return-1!==r&&(n=t.substr(r+6,4)),n},haveSamePropertiesLength:function(e){return Object.keys(e).length},getLocaleElementsMainNode:function(e){var t=e.main;return t[Object.keys(t)[0]]},getLocaleElementsMainNodeKey:function(e){var t=e.main;return Object.keys(t)[0]},_toBoolean:function(e){if("string"==typeof e)switch(e.toLowerCase().trim()){case"true":case"1":return!0;case"false":case"0":return!1;default:return e}return e},getGetOption:function(e,t){if(void 0===e)throw new Error("Internal "+t+" error. Default options missing.");return function(r,n,o,a){if(void 0!==e[r]){var i=e[r];switch(n){case"boolean":i=s._toBoolean(i);break;case"string":i=String(i);break;case"number":i=Number(i);break;default:throw new Error("Internal error. Wrong value type.")}if(void 0!==o&&-1===o.indexOf(i)){for(var u=[],l=0;l<o.length;l++)u.push(o[l]);var g="The value '"+e[r]+"' is out of range for '"+t+"' options property '"+r+"'. Valid values: "+u,f=new RangeError(g),d={errorCode:"optionOutOfRange",parameterMap:{propertyName:r,propertyValue:e[r],propertyValueValid:u,caller:t}};throw f.errorInfo=d,f}return i}return a}},matchString:function(e,t,r,n){void 0===n&&(n={sensitivity:"base",usage:"sort"});var o=s.getGetOption(n,"OraI18nUtils.matchString");n.usage=o("usage","string",["sort","search"],"sort"),n.sensitivity=o("sensitivity","string",["base","accent","case","variant"],"base");for(var a=e.length,i=t.length-1,u=0;u<a;u++)for(var l=0;l<3;l++){var g=a-u;if(g=Math.min(g,i+l),0===e.substr(u,g).localeCompare(t,r,n))return[u,u+(g-1)]}return null}};var u={fullYear:{pos:0,pad:4},month:{pos:1,pad:2},date:{pos:2,pad:2},hours:{pos:3,pad:2},minutes:{pos:4,pad:2},seconds:{pos:5,pad:2},milliseconds:{pos:6,pad:3},timeZone:{pos:7}};s.isoToDate=function(e){return new Date(this._normalizeIsoString(e))},s._copyTimeOver=function(e,t){if(!e||!t)throw new Error("Provided invalid arguments");var r=this._normalizeIsoString(t),n=e.indexOf("T"),o=r.indexOf("T");return r.substring(0,o)+(-1!==n?e.substring(n):"T00:00:00.000")},s._clearTime=function(e){return this._dateTime(e,{hours:0,minutes:0,seconds:0,milliseconds:0})},s._dateTime=function(e,t,r){if(!e||!t)throw new Error("Invalid argument invocation");var o,a,i=null,s=u,l=this.padZeros,g=this._normalizeIsoString(e),f=/(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):?(\d{2})?\.?(\d{3})?(.*)?/.exec(g);if(!f)throw new Error("Unable to capture anything");if(f=f.slice(1),Array.isArray(t)){i={};for(var d=0,c=t.length;d<c;d++){var p=t[d];if(p in s){if(a=f[o=s[p].pos],r&&"timeZone"===p)throw new Error("Dude you tried to ask timezone to be parsed");if(r){var m=parseInt(a,10);i[p]=1===o?m-1:m}else i[p]=a}}}else if(n.isPlainObject(t)){for(var v=Object.keys(t),h=0;h<v.length;h++){var T=v[h],S=s[T];o=S.pos,a=t[T],1===o&&"number"==typeof a&&(a+=1),f[o]=S.pad?l(a,S.pad):a}i=f[0]+"-"+f[1]+"-"+f[2]+"T"+f[3]+":"+f[4]+":"+f[5]+(f.length>6&&f[6]?"."+f[6]+(8===f.length&&f[7]?f[7]:""):"")}return i},s._normalizeIsoString=function(e){if(!e)throw new Error("Provided invalid arguments");var t,r=(new Date).toISOString(),n=r.substring(0,r.indexOf("T")),o=e.indexOf("T"),a=-1===o?e:e.substring(0,o);return(a=a||n)+(-1!==o?(t=e.substring(o)).split(":").length>1?t:t+":00":"T00:00:00.000")},s.formatString=function(e,t){for(var r=t.length,n=e,o=0;o<r;o++){var a="{"+o+"}";n=n.replace(a,t[o])}return n},s.convertISOString=function(e,t){if(e.startsWith("T"))return e;var r=e;if("offset"===t){var n=new Date(e).getTimezoneOffset();r=e+(n=s.getTimeStringFromOffset("",n,!0,!0))}else if("zulu"===t){var o=s._IsoStrParts(e),a=new Date(o[0],o[1]-1,o[2],o[3],o[4],o[5],o[6]);r=s.padZeros(a.getUTCFullYear(),4)+"-"+s.padZeros(a.getUTCMonth()+1,2)+"-"+s.padZeros(a.getUTCDate(),2)+"T"+s.padZeros(a.getUTCHours(),2)+":"+s.padZeros(a.getUTCMinutes(),2)+":"+s.padZeros(a.getUTCSeconds(),2),a.getMilliseconds()>0&&(r+="."+s.trimRightZeros(s.padZeros(a.getUTCMilliseconds(),3))),r+="Z"}return r},s.getInitials=function(e,t){var r,n=0,o=0;if(void 0!==e&&e.length>0&&(n=e.charCodeAt(0)),n>=1536&&n<=1791)return"";if(n>=2304&&n<=2431)return e.charAt(0);if(n>=3584&&n<=3711)return e.charAt(0);if(n>=4352&&n<=4607||n>=12592&&n<=12687||n>=43360&&n<=43391||n>=44032&&n<=55295)return e;if(void 0!==t&&t.length>0&&(n=t.charCodeAt(0)),n>=11904&&n<=12255||n>=12288&&n<=12591||n>=12688&&n<=12799||n>=13056&&n<=19903||n>=19968&&n<=40959||n>=63744&&n<=64255)return t;if(n>=55296&&n<=56319){if(t&&t.length<2)return"";if((o=t.charCodeAt(1))<56320||o>57343)return"";if((r=1024*(n-55296)+(o-56320)+65536)>=110592&&r<=110847||r>=127488&&r<=127743||r>=131072&&r<=173791||r>=173824&&r<=177983||r>=177984&&r<=178207||r>=178208&&r<=183983||r>=194560&&r<=195103)return t}return n="",o="",void 0!==e&&e.length>0&&(n=e.charAt(0).toUpperCase()),void 0!==t&&t.length>0&&(o=t.charAt(0).toUpperCase()),n+o};const l={isoToDate:function(e){return s.isoToDate(e)},isoToLocalDate:function(e){return s.isoToLocalDate(e)},dateToLocalIso:function(e){return s.dateToLocalIso(e)},dateToLocalIsoDateString:function(e){return s.dateToLocalIsoDateString(e)},getLocalTimeZoneOffset:function(e){return s.getLocalTimeZoneOffset(e)},getConverterInstance:function(e){return o.getConverterInstance(e)},_minMaxIsoString:function(e,t){if(e){var r=(t=t||this.dateToLocalIso(new Date)).indexOf("T");0===e.indexOf("T")&&r>0&&(e=t.substring(0,r)+e)}return e},_getISOStrFormatType:function(e){return s.getISOStrFormatType(e)},_warnIfISOFormatHasTime:function(e,t,r=i.warn){t&&-1!==t.indexOf("T")&&r(e+" iso string value should not include a time value for oj-input-date component.")},_verifyValueMinMaxNoTime:function(e,t,r){Object.entries({value:e,min:t,max:r}).forEach(([e,t])=>l._warnIfISOFormatHasTime(e,t)),l._verifyValueMinMax(e,t,r)},_verifyValueMinMax:function(e,t,r){let n,o,a;if(e)try{n=l._getISOStrFormatType(e)}catch(e){throw new Error("value must be an iso string: "+e)}if(t)try{o=l._getISOStrFormatType(t)}catch(e){throw new Error("min must be an iso string: "+e)}if(r)try{a=l._getISOStrFormatType(r)}catch(e){throw new Error("max must be an iso string: "+e)}if(e&&t&&r&&(n!==o||n!==a))throw new Error(`min and max must be in the same iso string format as value.\n    value is in ${n} format.`);if(e&&t&&n!==o)throw new Error(`min must be in the same iso string format as value.\n    value is in ${n} format.`);if(e&&r&&n!==a)throw new Error(`max must be in the same iso string format as value.\n      value is in ${n} format.`);if(t&&r&&o!==a)throw new Error(`min and max must be in the same iso string format.\n      min is in ${o} format and max is in ${a} format.`)},_getTodaysDateIsoStr:function(){const e=new Date;return s.padZeros(e.getFullYear(),4)+"-"+s.padZeros(e.getMonth()+1,2)+"-"+s.padZeros(e.getDate(),2)},_makeIsoDateStringsDateComparable:function(e,t){const r=e.startsWith("T"),n=t.startsWith("T"),o=!e.includes("T"),a=!t.includes("T");let i=e,s=t;if(r||n){const o=l._getTodaysDateIsoStr();r&&(i=o+e),n&&(s=o+t)}return o&&a||(o&&(i=e+"T00:00:00"),a&&(s=t+"T00:00:00")),[i,s]},_compareISODates:function(e,t){const r=l._makeIsoDateStringsDateComparable(e,t);return new Date(r[0])-new Date(r[1])},__getConverterOptionError:function(e,n){t.Assert.assertObject(n);var o,i="",s="",u=n.propertyName;if("optionTypesMismatch"===e){var g=n.requiredPropertyName;o=n.requiredPropertyValueValid,i=r.getTranslatedString("oj-converter.optionTypesMismatch.summary",{propertyName:u,propertyValue:n.propertyValue,requiredPropertyName:g}),s=l._getOptionValueDetailMessage(g,o)}else"optionTypeInvalid"===e?(u=n.propertyName,o=n.propertyValueValid,i=r.getTranslatedString("oj-converter.optionTypeInvalid.summary",{propertyName:u}),s=l._getOptionValueDetailMessage(u,o)):"optionOutOfRange"===e?(i=r.getTranslatedString("oj-converter.optionOutOfRange.summary",{propertyName:u,propertyValue:n.propertyValue}),o=n.propertyValueValid,s=l._getOptionValueDetailMessage(u,o)):"optionValueInvalid"===e&&(i=r.getTranslatedString("oj-converter.optionValueInvalid.summary",{propertyName:u,propertyValue:n.propertyValue}),o=n.propertyValueHint,s=l._getOptionValueDetailMessage(u,o));return new a.ConverterError(i,s)},__getConverterError:function(e,t){return new a.ConverterError(e,t)},_getOptionValueDetailMessage:function(e,t){var n;return t?("string"==typeof t?n="oj-converter.optionHint.detail":(n="oj-converter.optionHint.detail-plural",t=t.join(r.getTranslatedString("oj-converter.plural-separator"))),r.getTranslatedString(n,{propertyName:e,propertyValueValid:t})):""},_copyTimeOver:function(e,t){return s._copyTimeOver(e,t)},_clearTime:function(e){return s._clearTime(e)},_dateTime:function(e,t,r){return s._dateTime(e,t,r)},_normalizeIsoString:function(e){return s._normalizeIsoString(e)},getInitials:function(e,t){return s.getInitials(e,t)}};e.IntlConverterUtils=l,e.OraI18nUtils=s,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=ojconverterutils-i18n.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojconverter',["ojs/ojcore-base","jquery"],function(t,e){"use strict";t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t,e=e&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e;const o=function(t){this.Init(t)};return t.Object.createSubclass(o,t.Object,"oj.Converter"),o.prototype.Init=function(t){o.superclass.Init.call(this),this._options=t},o.prototype.getOptions=function(){return this._options||{}},o.prototype.resolvedOptions=function(){var t={};return e.extend(t,this._options),t},o});
//# sourceMappingURL=ojconverter.js.map;
define('ojtranslations/nls/localeElements',{root:{supplemental:{defaultRegion:{ar:"001",as:"IN",be:"BY",bg:"BG",bn:"BD",bo:"CN",brx:"IN",bs:"BA",ca:"ES",cs:"CZ",da:"DK",de:"DE",el:"GR",en:"US",es:"ES",et:"EE",fi:"FI",fr:"FR",ga:"IE",gu:"IN",he:"IL",hi:"IN",hr:"HR",hu:"HU",id:"ID",is:"IS",it:"IT",ja:"JP",kn:"IN",ko:"KR",kok:"IN",ks:"IN","ks-Arab":"IN",lt:"LT",lv:"LV",mk:"MK",ml:"IN",mr:"IN",ms:"MY",mt:"MT",nb:"NO",ne:"NP",nl:"NL",nn:"NO",no:"NO",or:"IN",pa:"IN","pa-Guru":"IN","pa-Arab":"PK",pl:"PL",pt:"BR",ro:"RO",ru:"RU",sk:"SK",sl:"SI",sq:"AL",sr:"RS","sr-Cyrl":"RS","sr-Latn":"RS",sv:"SE",ta:"IN",te:"IN",th:"TH",tr:"TR",uk:"UA",ur:"PK",vi:"VN",zh:"CN","zh-Hans":"CN","zh-Hant":"TW"},weekData:{firstDay:{"001":1,AE:6,BH:6,BR:0,DZ:6,EG:6,IQ:6,JO:6,KW:6,LB:1,LY:6,MA:6,OM:6,QA:6,SA:0,SD:6,SY:6,TN:0,YE:0,BY:1,BG:1,ES:1,CZ:1,DK:1,AT:1,CH:1,DE:1,LU:1,CY:1,GR:1,AU:0,CA:0,GB:1,IE:0,IN:0,MT:0,NZ:0,PH:0,SG:0,US:0,ZA:0,AR:0,CL:1,CO:0,CR:1,DO:0,EC:1,GT:0,HN:0,MX:0,NI:0,PA:0,PE:0,PR:0,PY:0,SV:0,UY:1,VE:0,EE:1,FI:1,BE:1,FR:1,IL:0,HR:1,HU:1,ID:0,IS:1,IT:1,JP:0,KR:0,LT:1,LV:1,MK:1,MY:1,NO:1,NL:1,PL:1,PT:1,RO:1,RU:1,SK:1,SI:1,AL:1,BA:1,ME:1,RS:1,SE:1,TH:0,TR:1,UA:1,VN:1,CN:0,HK:0,MO:0,TW:0},weekendStart:{"001":6,AE:5,BH:5,DZ:5,EG:5,IQ:5,JO:5,KW:5,LY:5,MA:5,OM:5,QA:5,SA:5,SD:5,SY:5,TN:5,YE:5,IN:0,IL:5},weekendEnd:{"001":0,AE:6,BH:6,DZ:6,EG:6,IQ:6,JO:6,KW:6,LY:6,MA:6,OM:6,QA:6,SA:6,SD:6,SY:6,TN:6,YE:6,IL:6}},prefferedHours:{"001":"H",AE:"h",BH:"h",DZ:"h",EG:"h",IQ:"h",JO:"h",KW:"h",LB:"h",LY:"h",MA:"H",OM:"h",QA:"h",SA:"h",SD:"h",SY:"h",TN:"h",YE:"h",BG:"H",ES:"H",CZ:"H",DK:"H",AT:"H",CH:"H",DE:"H",LU:"H",CY:"h",GR:"h",AU:"h",CA:"h",GB:"H",IE:"H",IN:"h",NZ:"h",PH:"h",SG:"h",US:"h",ZA:"h",AR:"H",BO:"H",CL:"H",CO:"h",CR:"H",CU:"H",DO:"h",EC:"H",GT:"H",HN:"H",MX:"H",NI:"H",PA:"h",PE:"H",PR:"h",SV:"H",UY:"H",VE:"h",EE:"H",FI:"H",BE:"H",FR:"H",IL:"H",HR:"H",ID:"H",IS:"H",IT:"H",JP:"H",KR:"h",LT:"H",LV:"H",MK:"H",MY:"h",NL:"H",PT:"H",RO:"H",RU:"H",SK:"H",SI:"H",AL:"h",BA:"H",ME:"H",RS:"H",SE:"H",TR:"H",UA:"H",CN:"h",HK:"h",MO:"h",TW:"h"},currencyData:{fractions:{IDR:{_digits:"0"},JPY:{_digits:"0"},KRW:{_digits:"0"},AFN:{_digits:"0"},ADP:{_digits:"0"},BHD:{_digits:"3"},BYR:{_digits:"0"},BIF:{_digits:"0"},XOF:{_digits:"0"},XAF:{_digits:"0"},XPF:{_digits:"0"},CLP:{_digits:"0"},KMF:{_digits:"0"},DJF:{_digits:"0"},STD:{_digits:"0"},PYG:{_digits:"0"},GNF:{_digits:"0"},ISK:{_digits:"0"},IQD:{_digits:"0"},ITL:{_digits:"0"},LAK:{_digits:"0"},KWD:{_digits:"3"},MMK:{_digits:"0"},LBP:{_digits:"0"},ALL:{_digits:"0"},SLL:{_digits:"0"},LUF:{_digits:"0"},LYD:{_digits:"3"},MGF:{_digits:"0"},TMM:{_digits:"0"},KPW:{_digits:"0"},MRO:{_digits:"0"},IDR:{_digits:"2"},RWF:{_digits:"0"},RSD:{_digits:"0"},SOS:{_digits:"0"},ESP:{_digits:"0"},SYP:{_digits:"0"},TND:{_digits:"3"},TRL:{_digits:"0"},UYW:{_digits:"4"},CLF:{_digits:"4"},UYI:{_digits:"0"},VUV:{_digits:"0"},YER:{_digits:"0"},ZMK:{_digits:"0"},ZWD:{_digits:"0"},VND:{_digits:"0"}}}}},ar:1,"ar-AE":1,"ar-BH":1,"ar-DZ":1,"ar-EG":1,"ar-IQ":1,"ar-JO":1,"ar-KW":1,"ar-LB":1,"ar-LY":1,"ar-MA":1,"ar-OM":1,"ar-QA":1,"ar-SA":1,"ar-SD":1,"ar-SY":1,"ar-TN":1,"ar-YE":1,as:1,be:1,"be-BY":1,bg:1,"bg-BG":1,bn:1,bo:1,"bo-IN":1,brx:1,bs:1,"bs-Cyrl":1,"bs-Cyrl-BA":1,"bs-Latn":1,"bs-Latn-BA":1,ca:1,"ca-ES":1,cs:1,"cs-CZ":1,da:1,"da-DK":1,de:1,"de-AT":1,"de-CH":1,"de-DE":1,"de-LU":1,el:1,"el-CY":1,"el-GR":1,en:1,"en-AU":1,"en-CA":1,"en-GB":1,"en-IE":1,"en-IN":1,"en-MT":1,"en-NZ":1,"en-PH":1,"en-SG":1,"en-US":1,"en-ZA":1,es:1,"es-AR":1,"es-BO":1,"es-CL":1,"es-CO":1,"es-CR":1,"es-CU":1,"es-DO":1,"es-EC":1,"es-ES":1,"es-GT":1,"es-HN":1,"es-MX":1,"es-NI":1,"es-PA":1,"es-PE":1,"es-PR":1,"es-PY":1,"es-SV":1,"es-US":1,"es-UY":1,"es-VE":1,et:1,"et-EE":1,fi:1,"fi-FI":1,fr:1,"fr-BE":1,"fr-CA":1,"fr-CH":1,"fr-FR":1,"fr-LU":1,ga:1,"ga-IE":1,gu:1,he:1,"he-IL":1,hi:1,"hi-IN":1,hr:1,"hr-HR":1,hu:1,"hu-HU":1,id:1,"id-ID":1,is:1,"is-IS":1,it:1,"it-CH":1,"it-IT":1,ja:1,"ja-JP":1,kn:1,ko:1,"ko-KR":1,kok:1,ks:1,lt:1,"lt-LT":1,lv:1,"lv-LV":1,mk:1,"mk-MK":1,ml:1,mr:1,ms:1,"ms-MY":1,mt:1,"mt-MT":1,nb:1,"nb-NO":1,ne:1,"ne-IN":1,nl:1,"nl-BE":1,"nl-NL":1,nn:1,"nn-NO":1,no:1,"no-NO":1,or:1,pa:1,pl:1,"pl-PL":1,pt:1,"pt-BR":1,"pt-PT":1,ro:1,"ro-RO":1,ru:1,"ru-RU":1,sk:1,"sk-SK":1,sl:1,"sl-SI":1,sq:1,"sq-AL":1,sr:1,"sr-Cyrl":1,"sr-Cyrl-BA":1,"sr-Cyrl-ME":1,"sr-Cyrl-RS":1,"sr-Latn":1,"sr-Latn-BA":1,"sr-Latn-ME":1,"sr-Latn-RS":1,sv:1,"sv-SE":1,ta:1,te:1,th:1,"th-TH":1,tr:1,"tr-TR":1,uk:1,"uk-UA":1,ur:1,"ur-IN":1,vi:1,"vi-VN":1,zh:1,"zh-Hans":1,"zh-Hans-CN":1,"zh-Hans-SG":1,"zh-Hant":1,"zh-Hant-HK":1,"zh-Hant-MO":1,"zh-Hant-TW":1,__noOverlay:!0,__defaultNoOverlayLocale:"en-US"});

/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojcalendarutils',["exports"],function(t){"use strict";class a{static _getDayPeriods(t,e){var n=new Date(2019,0,1,0,0,0);function o(t){const a=t.formatToParts(n).find(t=>"dayPeriod"===t.type);if(a)return a.value}var r=a.getFormatterLocale(t,e),s=new Intl.DateTimeFormat(r,{hour:"numeric",hour12:!0});const l=o(s);n.setHours(20);return{format:{wide:{am:l,pm:o(s)}}}}static getFormatterLocale(t,a){return t+"-u-ca-"+a}static _getEras(t,e){const n=[{era:"0",start:"2000-02-11T00:00:00"}];var o={eraNarrow:{0:"",1:""},eraAbbr:{0:"",1:""},eraName:{0:"",1:""}};function r(t,a){const e=t.formatToParts(a).find(t=>"era"===t.type);if(e)return e.value}const s=["narrow","short","long"],l=a.getFormatterLocale(t,e),d={narrow:"eraNarrow",short:"eraAbbr",long:"eraName"};for(let t=0;t<n.length;t++){let a=new Date(n[t].start);for(let t=0;t<s.length;t++){const e=s[t],n={year:"numeric",month:"numeric",day:"numeric",era:e};const m=r(new Intl.DateTimeFormat(l,n),a),c={0:m,1:m};o[d[e]]=c}}return o}static _fillMonthAndDays(t,e,n,o,r){const s=[[2020,0,5],[2020,1,3],[2020,2,3],[2020,3,1],[2020,4,7],[2020,5,5],[2020,6,4],[2020,7,1],[2020,8,1],[2020,9,1],[2020,10,1],[2020,11,1]];function l(t){const a=t.find(t=>"month"===t.type);return a?a.value:null}function d(t){const a=t.find(t=>"weekday"===t.type);return a?a.value:null}const m=a.getFormatterLocale(t,e),c=new Intl.DateTimeFormat(m,o),i={},h={};for(let t=0;t<s.length;t++){const e=t+1,o=a._weekdaysFormatMap[e],m=new Date(s[t][0],s[t][1],s[t][2]),f=c.formatToParts(m);let u,y;r?(u=c.format(m),y=c.format(m)):(u=l(f),y=d(f)),void 0===i[n]&&(i[n]={}),i[n][e]=u,e<=7&&(void 0===h[n]&&(h[n]={}),h[n][o]=y)}return{monthFormat:i,dayFormat:h}}static _getFormatMonthAndDays(t,e){const n=[],o=[],r=["short","narrow","long"];for(let s=0;s<r.length;s++){const l={month:r[s],weekday:r[s],year:"numeric",day:"numeric"},d=a._monthNamesFormatMap[r[s]];let m=a._fillMonthAndDays(t,e,d,l,!1);n[s]=m.monthFormat,o[s]=m.dayFormat}const s=Object.assign({},...n),l=Object.assign({},...o);let d={format:{}};d.format=s;let m={format:{}};return m.format=l,d["stand-alone"]=d.format,m["stand-alone"]=m.format,{monthsNode:d,daysNode:m}}static _getStandAloneDays(t,e){const n=[],o=["short","narrow","long"];for(let s=0;s<o.length;s++){var r={weekday:o[s]};const l=a._monthNamesFormatMap[o[s]];let d=a._fillMonthAndDays(t,e,l,r,!0);n[s]=d.dayFormat}let s=Object.assign({},...n),l={"stand-alone":{}};return l["stand-alone"]=s,{daysNode:l}}static _getStandAloneMonths(t,e){const n=[],o=["short","narrow","long"];for(let s=0;s<o.length;s++){var r={month:o[s]};const l=a._monthNamesFormatMap[o[s]];let d=a._fillMonthAndDays(t,e,l,r,!0);n[s]=d.monthFormat}let s=Object.assign({},...n),l={"stand-alone":{}};return l["stand-alone"]=s,{monthsNode:l}}static getCalendar(t,e){var n,o;if(a.calendars=null!==(n=a.calendars)&&void 0!==n?n:{},a.calendars[t]=null!==(o=a.calendars[t])&&void 0!==o?o:{},void 0===a.calendars[t][e]){const n=a._getDayPeriods(t,e),o=a._getEras(t,e);let r,s;const l=a._getStandAloneMonths(t,e),d=a._getStandAloneDays(t,e);if(a.exceptionLocales.includes(t))r=l.monthsNode["stand-alone"],s=d.daysNode["stand-alone"];else{const n=a._getFormatMonthAndDays(t,e);r=n.monthsNode.format,s=n.daysNode.format}const m={format:r,"stand-alone":l.monthsNode["stand-alone"]},c={format:s,"stand-alone":d.daysNode["stand-alone"]};a.calendars[t][e]={dayPeriods:n,months:m,days:c,eras:o,locale:t}}return a.calendars[t][e]}}a._monthNamesFormatMap={short:"abbreviated",narrow:"narrow",long:"wide"},a._weekdaysFormatMap={1:"sun",2:"mon",3:"tue",4:"wed",5:"thu",6:"fri",7:"sat"},a.exceptionLocales=["ja","ja-JP","zh","zh-Hans","zh-Hans-CN","zh-Hans-HK","zh-Hans-MO","zh-Hans-SG","zh-Hant","zh-Hant-HK","zh-Hant-MO","zh-Hant-TW"],t.CalendarUtils=a,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ojcalendarutils.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojlocaledata',["exports","ojs/ojcore-base","ojL10n!ojtranslations/nls/localeElements","ojs/ojcalendarutils"],function(e,t,n,a){"use strict";t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t;var r=n=n&&Object.prototype.hasOwnProperty.call(n,"default")?n.default:n;const o={};t._registerLegacyNamespaceProp("LocaleData",o),o.setBundle=function(e){o._bundle=e},o.getFirstDayOfWeek=function(){return o._getWeekData("firstDay")},o.getWeekendStart=function(){return o._getWeekData("weekendStart")},o.getWeekendEnd=function(){return o._getWeekData("weekendEnd")},o.getDayNames=function(e){(null==e||"abbreviated"!==e&&"narrow"!==e)&&(e="wide");var t=o._getCalendarData().days["stand-alone"][e];return[t.sun,t.mon,t.tue,t.wed,t.thu,t.fri,t.sat]},o.getMonthNames=function(e){(null==e||"abbreviated"!==e&&"narrow"!==e)&&(e="wide");var t=o._getCalendarData().months["stand-alone"][e];return[t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12]]},o.isMonthPriorToYear=function(){var e=t.Config.getLocale(),n=new Date,a=new Intl.DateTimeFormat(e,{dateStyle:"long"}).formatToParts(n);return a.findIndex(e=>"month"===e.type)<a.findIndex(e=>"year"===e.type)},o._getWeekData=function(e){var t=o.__getBundle(),n=o._getRegion()||"001",a=t.supplemental.weekData[e],r=a[n];return void 0===r&&(r=a["001"]),r},o._getCalendarData=function(){var e=t.Config.getLocale();return a.CalendarUtils.getCalendar(e,"gregory")},o._getRegion=function(){var e=t.Config.getLocale();if(e){var n=e.toUpperCase().split(/-|_/);if(n.length>=2){var a=n[1];if(4!==a.length)return a;if(n.length>=3)return n[2]}}return o.__getBundle().supplemental.defaultRegion[e]},o.__getBundle=function(){var e=o._bundle;return e||r},o.__updateBundle=function(e){r=e};const l=o.getDayNames,d=o.getFirstDayOfWeek,u=o.getMonthNames,i=o.getWeekendEnd,g=o.getWeekendStart,s=o.isMonthPriorToYear,f=o.setBundle,c=o.__getBundle,_=o._getCalendarData;e.__getBundle=c,e._getCalendarData=_,e.getDayNames=l,e.getFirstDayOfWeek=d,e.getMonthNames=u,e.getWeekendEnd=i,e.getWeekendStart=g,e.isMonthPriorToYear=s,e.setBundle=f,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=ojlocaledata.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojoratimezone',["exports"],function(t){"use strict";
/**
   * @license
   * This is a forked version of moment-timezone.js
   * The MIT License (MIT)
   * Copyright (c) 2014 Tim Wood
   * https://github.com/moment/moment-timezone/blob/develop/LICENSE
   * @ignore
   */const e=function(){var t,e={},r=/^Etc\/GMT/i,n="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWX";function o(t,e){for(var r="",o=Math.abs(t),i=Math.floor(o),a=function(t,e){for(var r=".",o="";e>0;){e-=1,t*=60;var i=Math.floor(t+1e-6);r+=n[i],t-=i,i&&(o+=r,r="")}return o}(o-i,Math.min(e,10));i>0;)r=n[i%60]+r,i=Math.floor(i/60);return t<0&&(r="-"+r),r&&a?r+a:(a||"-"!==r)&&(r||a)||"0"}function i(t){return t>96?t-87:t>64?t-29:t-48}function a(t){var e=0,r=t.split("."),n=r[0],o=r[1]||"",a=1,s=0,f=1;for(45===t.charCodeAt(0)&&(e=1,f=-1);e<n.length;e++)s=60*s+i(n.charCodeAt(e));for(e=0;e<o.length;e++)a/=60,s+=i(o.charCodeAt(e))*a;return s*f}function s(t){for(var e=0;e<t.length;e++)t[e]=a(t[e])}function f(t,e){for(var r=[],n=0;n<e.length;n++)r[n]=t[e[n]];return r}function u(t,e){var r=e.split("|"),n=r[1].split(" "),o=r[2].split(""),i=r[3].split(" ");return s(n),s(o),s(i),function(t,e){for(var r=0;r<e;r++)t[r]=Math.round((t[r-1]||0)+6e4*t[r]);t[e-1]=1/0}(i,o.length),{name:t,abbrs:f(r[0].split(" "),o),offsets:f(n,o),untils:i}}function l(){var t=new Error("The input time does not exist because it falls during the transition to daylight saving time.");throw t.errorInfo={errorCode:"nonExistingTime"},t}function c(t,e){var n=e.zones[t];if(r.test(t)){var i=t.replace(r,"").split(":"),a=60*parseInt(i[0],10),s=0;if(isNaN(a))return;if(2===i.length&&(s=parseInt(i[1],10),isNaN(s)))return;if((a+=a>=0?s:-s)<-840||a>720)return;a=o(a,1),n=t.replace("/etc//i","").toUpperCase()+"|"+a+"|0|"}void 0!==n&&this._set(u(t,n))}function h(t){return(t||"").toLowerCase().replace(/\//g,"_")}function v(t,r){var n=h(t);return void 0===e[n]&&function(t,r){var n=new c(t,r),o=h(n.name);e[o]=n}(t,r),e[h(t)]||null}function p(){return{getZone:function(t,e){var r=e.supplemental.timeZoneData;void 0===r&&function(){var t=new Error("TimeZone data is missing. Please call require 'ojs/ojtimezonedata' in order to load the TimeZone data.");throw t.errorInfo={errorCode:"missingTimeZoneData"},t}();var n=v(t,r);if(!n){var o=r.links[t];o&&(n=v(o,r))}return n||function(t){var e=new Error("invalid timeZone ID: "+t),r={errorCode:"invalidTimeZoneID",parameterMap:{timeZoneID:t}};throw e.errorInfo=r,e}(t),n}}}return c.prototype={_set:function(t){this.name=t.name,this.abbrs=t.abbrs,this.untils=t.untils,this.offsets=t.offsets},parse:function(t,e,r,n){for(var o=this.offsets,i=this.untils,a=i.length-1,s=0;s<a;s++){var f=o[s],u=o[s+1],c=i[s],h=c-6e4*f,v=h-36e5;if(t>=h&&t<h+36e5&&f>u){if(!0!==n)return s+1;l()}if(t>=v&&t<h&&f<u)return e?s:s+1;if(t<c-6e4*f)return!1===r?e?f<u?s:s+1:f<u?s+1:s:s}return a},abbr:function(t){return this.abbrs[t]},ofset:function(t){var e=this.offsets.length;return 0===e?0:t>=0&&t<e?parseInt(this.offsets[t],10):parseInt(this.offsets[e-1],10)},len:function(){return this.offsets.length}},{getInstance:function(){return t||(t=p()),t}}}();t.OraTimeZone=e,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ojoratimezone.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojconverter-preferences',["exports"],function(e){"use strict";let t={};e.getDateTimePreferences=()=>t,e.setDateTimePreferences=e=>{t=Object.freeze(e)},Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=ojconverter-preferences.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojconverter-nativedatetime',["exports","ojs/ojlogger","ojs/ojconfig","ojs/ojlocaledata","ojs/ojconverterutils-i18n","ojs/ojtranslation","ojs/ojcore-base","ojs/ojcalendarutils","ojs/ojoratimezone","ojs/ojconverter-preferences"],function(e,t,a,r,n,s,o,i,l,d){"use strict";o=o&&Object.prototype.hasOwnProperty.call(o,"default")?o.default:o;class h{}h._YEAR_AND_DATE_REGEXP=/(\d{1,4})\D+?(\d{1,4})/g,h._YMD_REGEXP=/(\d{1,4})\D+?(\d{1,4})\D+?(\d{1,4})/g,h._TIME_REGEXP=/(\d{1,2})(?:\D(\d{1,2}))?(?:\D(\d{1,2}))?(?:\D(\d{1,3}))?/g,h._TIME_FORMAT_REGEXP=/h|H|K|k/g,h._YEAR_REGEXP=/y{1,4}/,h._MONTH_REGEXP=/M{1,5}/,h._DAY_REGEXP=/d{1,2}/,h._WEEK_DAY_REGEXP=/E{1,5}/,h._HOUR_REGEXP=/h{1,2}|k{1,2}/i,h._MINUTE_REGEXP=/m{1,2}/,h._SECOND_REGEXP=/s{1,2}/,h._FRACTIONAL_SECOND_REGEXP=/S{1,3}/,h._AMPM_REGEXP=/a{1,2}/,h._WORD_REGEXP="(\\D+?\\s*)",h._ESCAPE_REGEXP=/([\^$.*+?|\[\](){}])/g,h._TOKEN_REGEXP=/ccccc|cccc|ccc|cc|c|EEEEE|EEEE|EEE|EE|E|dd|d|MMMMM|MMMM|MMM|MM|M|LLLLL|LLLL|LLL|LL|L|yyyy|yy|y|hh|h|HH|H|KK|K|kk|k|mm|m|ss|s|aa|a|SSS|SS|S|zzzz|zzz|zz|z|v|ZZZ|ZZ|Z|XXX|XX|X|VV|GGGGG|GGGG|GGG|GG|G/g,h._ZULU="zulu",h._LOCAL="local",h._AUTO="auto",h._INVARIANT="invariant",h._OFFSET="offset",h._ALNUM_REGEXP="(\\D+|\\d\\d?\\D|\\d\\d?|\\D+\\d\\d?)",h._NON_DIGIT_REGEXP="(\\D+|\\D+\\d\\d?)",h._NON_DIGIT_OPT_REGEXP="(\\D*)",h._STR_REGEXP="(.+?)",h._TWO_DIGITS_REGEXP="(\\d\\d?)",h._THREE_DIGITS_REGEXP="(\\d{1,3})",h._FOUR_DIGITS_REGEXP="(\\d{1,4})",h._SLASH_REGEXP="(\\/)",h._PROPERTIES_MAP={MMM:{token:"months",style:"format",mLen:"abbreviated",matchIndex:0,key:"month",value:"short",regExp:h._ALNUM_REGEXP},MMMM:{token:"months",style:"format",mLen:"wide",matchIndex:0,key:"month",value:"long",regExp:h._ALNUM_REGEXP},MMMMM:{token:"months",style:"format",mLen:"narrow",matchIndex:0,key:"month",value:"narrow",regExp:h._ALNUM_REGEXP},LLL:{token:"months",style:"stand-alone",mLen:"abbreviated",matchIndex:1,key:"month",value:"short",regExp:h._ALNUM_REGEXP},LLLL:{token:"months",style:"stand-alone",mLen:"wide",matchIndex:1,key:"month",value:"long",regExp:h._ALNUM_REGEXP},LLLLL:{token:"months",style:"stand-alone",mLen:"narrow",matchIndex:1,key:"month",value:"narrow",regExp:h._ALNUM_REGEXP},E:{token:"days",style:"format",dLen:"abbreviated",matchIndex:0,key:"weekday",value:"short",regExp:h._NON_DIGIT_REGEXP},EE:{token:"days",style:"format",dLen:"abbreviated",matchIndex:0,key:"weekday",value:"short",regExp:h._NON_DIGIT_REGEXP},EEE:{token:"days",style:"format",dLen:"abbreviated",matchIndex:0,key:"weekday",value:"short",regExp:h._NON_DIGIT_REGEXP},EEEE:{token:"days",style:"format",dLen:"wide",matchIndex:0,key:"weekday",value:"long",regExp:h._NON_DIGIT_REGEXP},EEEEE:{token:"days",style:"format",dLen:"narrow",matchIndex:0,key:"weekday",value:"narrow",regExp:h._NON_DIGIT_REGEXP},c:{token:"days",style:"stand-alone",dLen:"abbreviated",matchIndex:1,key:"weekday",value:"short",regExp:h._NON_DIGIT_REGEXP},cc:{token:"days",style:"stand-alone",dLen:"abbreviated",matchIndex:1,key:"weekday",value:"short",regExp:h._NON_DIGIT_REGEXP},ccc:{token:"days",style:"stand-alone",dLen:"abbreviated",matchIndex:1,key:"weekday",value:"short",regExp:h._NON_DIGIT_REGEXP},cccc:{token:"days",style:"stand-alone",dLen:"wide",matchIndex:1,key:"weekday",value:"long",regExp:h._NON_DIGIT_REGEXP},ccccc:{token:"days",style:"stand-alone",dLen:"narrow",matchIndex:1,key:"weekday",value:"narrow",regExp:h._NON_DIGIT_REGEXP},h:{token:"time",timePart:"hour",start1:0,end1:11,start2:1,end2:12,key:"hour",value:"numeric",regExp:h._TWO_DIGITS_REGEXP},hh:{token:"time",timePart:"hour",start1:0,end1:11,start2:1,end2:12,key:"hour",value:"2-digit",regExp:h._TWO_DIGITS_REGEXP},K:{token:"time",timePart:"hour",start1:0,end1:12,start2:0,end2:12,key:"hour",value:"numeric",regExp:h._TWO_DIGITS_REGEXP},KK:{token:"time",timePart:"hour",start1:0,end1:12,start2:0,end2:12,key:"hour",value:"2-digit",regExp:h._TWO_DIGITS_REGEXP},H:{token:"time",timePart:"hour",start1:0,end1:23,start2:0,end2:23,key:"hour",value:"numeric",regExp:h._TWO_DIGITS_REGEXP},HH:{token:"time",timePart:"hour",start1:0,end1:23,start2:0,end2:23,key:"hour",value:"2-digit",regExp:h._TWO_DIGITS_REGEXP},k:{token:"time",timePart:"hour",start1:0,end1:24,start2:0,end2:24,key:"hour",value:"numeric",regExp:h._TWO_DIGITS_REGEXP},kk:{token:"time",timePart:"hour",start1:0,end1:24,start2:0,end2:24,key:"hour",value:"2-digit",regExp:h._TWO_DIGITS_REGEXP},m:{token:"time",timePart:"minute",start1:0,end1:59,start2:0,end2:59,key:"minute",value:"numeric",regExp:h._TWO_DIGITS_REGEXP},mm:{token:"time",timePart:"minute",start1:0,end1:59,start2:0,end2:59,key:"minute",value:"2-digit",regExp:h._TWO_DIGITS_REGEXP},s:{token:"time",timePart:"second",start1:0,end1:59,start2:0,end2:59,key:"second",value:"numeric",regExp:h._TWO_DIGITS_REGEXP},ss:{token:"time",timePart:"second",start1:0,end1:59,start2:0,end2:59,key:"second",value:"2-digit",regExp:h._TWO_DIGITS_REGEXP},S:{token:"time",timePart:"millisec",start1:0,end1:999,start2:0,end2:999,key:"millisecond",value:"numeric",regExp:h._THREE_DIGITS_REGEXP},SS:{token:"time",timePart:"millisec",start1:0,end1:999,start2:0,end2:999,key:"millisecond",value:"numeric",regExp:h._THREE_DIGITS_REGEXP},SSS:{token:"time",timePart:"millisec",start1:0,end1:999,start2:0,end2:999,key:"millisecond",value:"numeric",regExp:h._THREE_DIGITS_REGEXP},d:{token:"dayOfMonth",key:"day",value:"numeric",getPartIdx:2,regExp:h._TWO_DIGITS_REGEXP},dd:{token:"dayOfMonth",key:"day",value:"2-digit",getPartIdx:2,regExp:h._TWO_DIGITS_REGEXP},M:{token:"monthIndex",key:"month",value:"numeric",getPartIdx:1,regExp:h._TWO_DIGITS_REGEXP},MM:{token:"monthIndex",key:"month",value:"2-digit",getPartIdx:1,regExp:h._TWO_DIGITS_REGEXP},L:{token:"monthIndex",key:"month",value:"numeric",getPartIdx:1,regExp:h._TWO_DIGITS_REGEXP},LL:{token:"monthIndex",key:"month",value:"2-digit",getPartIdx:1,regExp:h._TWO_DIGITS_REGEXP},y:{token:"year",key:"year",value:"numeric",regExp:h._FOUR_DIGITS_REGEXP},yy:{token:"year",key:"year",value:"2-digit",regExp:h._TWO_DIGITS_REGEXP},yyyy:{token:"year",key:"year",value:"numeric",regExp:h._FOUR_DIGITS_REGEXP},a:{token:"ampm",key:"dayPeriod",value:void 0,regExp:h._WORD_REGEXP},z:{token:"tzAbbrev",key:"timeZoneName",value:"short",regExp:h._STR_REGEXP},v:{token:"tzAbbrev",key:"timeZoneName",value:"short",regExp:h._STR_REGEXP},zz:{token:"tzAbbrev",key:"timeZoneName",value:"short",regExp:h._STR_REGEXP},zzz:{token:"tzAbbrev",key:"timeZoneName",value:"short",regExp:h._STR_REGEXP},zzzz:{token:"tzFull",key:"timeZoneName",value:"long",regExp:h._STR_REGEXP},Z:{token:"tzhm",key:"tzhm",value:"short",regExp:h._STR_REGEXP,type:"tzOffset"},ZZ:{token:"tzhm",key:"tzhm",value:"short",regExp:h._STR_REGEXP,type:"tzOffset"},ZZZ:{token:"tzhm",key:"tzhm",value:"short",regExp:h._STR_REGEXP,type:"tzOffset"},X:{token:"tzh",key:"tzh",value:"short",regExp:h._STR_REGEXP,type:"tzOffset"},XX:{token:"tzhm",key:"tzhm",value:"short",regExp:h._STR_REGEXP,type:"tzOffset"},XXX:{token:"tzhsepm",key:"tzhsepm",value:"short",regExp:h._STR_REGEXP,type:"tzOffset"},VV:{token:"tzid",key:"tzid",value:"short",regExp:h._STR_REGEXP,type:"tzOffset"},G:{token:"era",key:"era",value:"eraAbbr",regExp:h._NON_DIGIT_REGEXP},GG:{token:"era",key:"era",value:"eraAbbr",regExp:h._NON_DIGIT_REGEXP},GGG:{token:"era",key:"era",value:"eraAbbr",regExp:h._NON_DIGIT_REGEXP},GGGG:{token:"era",key:"era",value:"eraName",regExp:h._NON_DIGIT_REGEXP},GGGGG:{token:"era",key:"era",value:"eraNarrow",regExp:h._NON_DIGIT_REGEXP},"/":{token:"slash",regExp:h._SLASH_REGEXP}},h.FRACTIONAL_SECOND_MAP={a:{key:"dayPeriod",token:"dayPeriod",value:"narrow"},SSS:{key:"fractionalSecondDigits",token:"fractionalSecond",value:3},SS:{key:"fractionalSecondDigits",token:"fractionalSecond",value:2},S:{key:"fractionalSecondDigits",token:"fractionalSecond",value:1}},h._tokenMap={era:{short:"GGG",long:"GGGG",narrow:"GGGGG"},month:{short:"MMM",long:"MMMM",narrow:"MMMMM",numeric:"M","2-digit":"MM"},weekday:{short:"EEE",long:"EEEE",narrow:"EEEEE"},year:{numeric:"y","2-digit":"yy"},day:{numeric:"d","2-digit":"dd"},hour:{numeric:"h","2-digit":"hh"},minute:{numeric:"m","2-digit":"mm"},second:{numeric:"s","2-digit":"ss"},fractionalSecond:{1:"S",2:"SS",3:"SSS"},timeZoneName:{short:"z",long:"zzzz"}},h._dateTimeFormats={dateStyle:{full:{year:"y",month_s:"MM",month_m:"MMMM",weekday:"EEEE",day:"d"},long:{year:"y",month_s:"MM",month_m:"MMMM",day:"d"},medium:{year:"y",month_s:"MM",month_m:"MMM",day:"d"},short:{year:"y",month_s:"M",month_m:"MMM",day:"d"}},timeStyle:{full:{hour:"h",minute:"m",second:"s",timeZoneName:"zzzz"},long:{hour:"h",minute:"m",second:"s",timeZoneName:"z"},medium:{hour:"h",minute:"m",second:"s"},short:{hour:"h",minute:"m"}}},h._ALPHA_REGEXP=/([a-zA-Z]+)/,h._HOUR12_REGEXP=/h/g,h._hourCycleMap={h12:"h",h23:"H",h11:"K",h24:"k"},h._zh_tw_locales=["zh-TW","zh-Hant","zh-Hant-TW"],h._zh_tw_pm_symbols=["中午","下午","晚上"];const m=n.IntlConverterUtils;class _{static processError(e,t,a){let r,n=e.errorInfo,i="",l="",d="";if(n){var h=n.errorCode,_=n.parameterMap||{};o.Assert.assertObject(_);var c=_.propertyName;c=s.getTranslatedString("oj-converter.datetime.datetimeOutOfRange."+c),_.propertyName=c,e instanceof RangeError?"datetimeOutOfRange"===h?(i=s.getTranslatedString("oj-converter.datetime.datetimeOutOfRange.summary",{propertyName:c,value:_.value}),l=s.getTranslatedString("oj-converter.datetime.datetimeOutOfRange.detail",{minValue:_.minValue,maxValue:_.maxValue}),r=m.__getConverterError(i,l)):"isoStringOutOfRange"===h&&(i=s.getTranslatedString("oj-converter.datetime.invalidISOString.invalidRangeSummary",{isoStr:_.isoString,propertyName:c,value:_.value}),l=s.getTranslatedString("oj-converter.datetime.datetimeOutOfRange.detail",{minValue:_.minValue,maxValue:_.maxValue}),r=m.__getConverterError(i,l)):e instanceof SyntaxError?"optionValueInvalid"===h&&(r=m.__getConverterOptionError(h,_)):e instanceof Error&&("dateFormatMismatch"===h?d="oj-converter.datetime.dateFormatMismatch.summary":"timeFormatMismatch"===h?d="oj-converter.datetime.timeFormatMismatch.summary":"datetimeFormatMismatch"===h?d="oj-converter.datetime.datetimeFormatMismatch.summary":"nonExistingTime"===h?d="oj-converter.datetime.nonExistingTime.summary":"dateToWeekdayMismatch"===h?(i=s.getTranslatedString("oj-converter.datetime.dateToWeekdayMismatch.summary",{date:_.date,weekday:_.weekday}),l=s.getTranslatedString("oj-converter.datetime.dateToWeekdayMismatch.detail"),r=m.__getConverterError(i,l)):"invalidISOString"===h&&(i=s.getTranslatedString("oj-converter.datetime.invalidISOString.summary",{isoStr:_.isoStr}),l=s.getTranslatedString("oj-converter.datetime.invalidISOString.detail"),r=m.__getConverterError(i,l)),d&&(i=s.getTranslatedString(d,{value:t||_.value,format:_.format}),l=s.getTranslatedString("oj-converter.hint.detail",{exampleValue:a}),r=m.__getConverterError(i,l)))}return r||(i=e.message,l=e.message,r=m.__getConverterError(i,l)),r}}const c=n.OraI18nUtils;const u=n.OraI18nUtils;class E{constructor(e){this.intlFormatter=null,this.pattern=null,this.inputTimeZone=!1,this.intlFormatter=new Intl.DateTimeFormat(a.getLocale(),e);let t=e||{};this.resOptions=this.intlFormatter.resolvedOptions(),this.resOptions.isoStrFormat=t.isoStrFormat||"auto",this.resOptions.twoDigitYearStart=t.twoDigitYearStart||1950,this.resOptions.lenientParse=t.lenientParse||"full",t.timeZone&&(this.inputTimeZone=!0)}format(e){const t=this.normalizeIsoString(e);return this.intlFormatter.format(new Date(t))}parse(e){if(null==e||""===e){throw new Error("input value of the parse method cannot be empty")}const n=i.CalendarUtils.getCalendar(a.getLocale(),this.resOptions.calendar),s=r.__getBundle();try{const a=class{static parseImpl(e,t,a,r,n){const s=a.numberingSystem;void 0!==s&&"latn"!==s&&(e=c.getLatnDigits(e,s));let o,i=0,l="",d=null;return!0===c._ISO_DATE_REGEXP.test(e)?(l=e,i=this._isoStrDateTimeStyle(e)):(i=this._dateTimeStyle(a),o=this._parseExact(e,t,a,r,n),l=o.value),d=c.getISOStrFormatInfo(l),void 0!==a.timeZone&&d.format!==h._LOCAL&&this._adjustHours(d,a,r),l=this._createParseISOStringFromDate(i,d,a,r),void 0===o?o={value:l,warning:null}:(o.value=l,o.warning=null),o}static _appendPreOrPostMatch(e,t){let a=0,r=!1;for(let n=0,s=e.length;n<s;n++){const s=e.charAt(n);switch(s){case"'":r?t.push("'"):a+=1,r=!1;break;case"\\":r&&t.push("\\"),r=!r;break;default:t.push(s),r=!1}}return a}static _validateRange(e){if(e.value<e.low||e.value>e.high){const t=e.displayValue+" is out of range.  Enter a value between "+e.displayLow+" and "+e.displayHigh+" for "+e.name;let a=new RangeError(t);const r={errorCode:"datetimeOutOfRange",parameterMap:{value:e.displayValue,minValue:e.displayLow,maxValue:e.displayHigh,propertyName:e.name}};throw a.errorInfo=r,a}}static _throwInvalidDateFormat(e,t,a){const r=void 0!==t.year||void 0!==t.month||void 0!==t.weekday||void 0!==t.day,n=void 0!==t.hour||void 0!==t.minute||void 0!==t.second;let s="";s=r&&n?"MM/dd/yy hh:mm:ss a":r?"MM/dd/yy":"hh:mm:ss a";let o=new SyntaxError("Unexpected character(s) "+a+' encountered in the pattern "'+e+' An example of a valid pattern is "'+s+'".');const i={errorCode:"optionValueInvalid",parameterMap:{propertyName:"pattern",propertyValue:e,"propertyValueHint ":s}};throw o.errorInfo=i,o}static _throwWeekdayMismatch(e,t){let a=new Error("The weekday "+e+" does not match the date "+t);const r={errorCode:"dateToWeekdayMismatch",parameterMap:{weekday:e,date:t}};throw a.errorInfo=r,a}static _throwDateFormatMismatch(e,t,a){let r="",n="";2===a?(r='The value "'+e+'" does not match the expected date-time format "'+t+'"',n="datetimeFormatMismatch"):0===a?(r='The value "'+e+'" does not match the expected date format "'+t+'"',n="dateFormatMismatch"):(r='The value "'+e+'" does not match the expected time format "'+t+'"',n="timeFormatMismatch");let s=new Error(r);const o={errorCode:n,parameterMap:{value:e,format:t}};throw s.errorInfo=o,s}static _getTimeZone(e,t){return l.OraTimeZone.getInstance().getZone(e,t)}static _parseZone(e,t,a,r,n){const s=Date.UTC(t[0],t[1]-1,t[2],t[3],t[4],t[5]);return e.parse(s,a,r,n)}static _parseTimezoneOffset(e){let t=e.split(":"),a=new Array(2);return 2===t.length?(a[0]=parseInt(t[0],10),a[1]=parseInt(t[1],10)):2===e.length||3===e.length?(a[0]=parseInt(e,10),a[1]=0):(a[0]=parseInt(e.substr(0,3),10),a[1]=parseInt(e.substr(3),10)),a}static _expandYear(e,t){if((t=Number(t))<100){const a=e%100;t+=100*Math.floor(e/100)+(t<a?100:0)}return t}static _arrayIndexOfMonthOrDay(e,t){let a=c.toUpper(t);a=c.trim(a),a=a.replace(/\.$/,"");const r=Object.keys(e);for(let t=0;t<r.length;t++){let n=r[t];if(n=c.toUpper(e[n]),n=c.trim(n),n=n.replace(/\.$/,""),a==n)return t}return-1}static _getDayIndex(e,t,a){let r=0,n=[];const s=e.days.format,o=e.days["stand-alone"];n=[s.abbreviated,s.wide,o.abbreviated,o.wide];for(let e=0;e<n.length;e++)if(r=this._arrayIndexOfMonthOrDay(n[e],t),-1!==r)return r;return r}static _getMonthIndex(e,t,a){let r=-1;const n=e.months.format,s=e.months["stand-alone"],o=[n.wide,n.abbreviated,s.wide,s.abbreviated];for(let e=0;e<o.length;e++)if(r=this._arrayIndexOfMonthOrDay(o[e],t),-1!==r)return r;return r}static _getParseRegExp(e,t){const a=e.replace(h._ESCAPE_REGEXP,"\\\\$1");let r=["^"],n=[],s=0,o=0,i=h._TOKEN_REGEXP.exec(a);for(;null!==i;){const l=a.slice(s,i.index);if(s=h._TOKEN_REGEXP.lastIndex,o+=this._appendPreOrPostMatch(l,r),o%2)r.push(i[0]);else{const a=i[0];let s="";void 0!==h._PROPERTIES_MAP[a]?s=h._PROPERTIES_MAP[a].regExp:this._throwInvalidDateFormat(e,t,a),s&&r.push(s),n.push(i[0])}i=h._TOKEN_REGEXP.exec(a)}this._appendPreOrPostMatch(a.slice(s),r),r.push("$");return{regExp:r.join("").replace(/\s+/g,"\\s+"),groups:n}}static _getTokenIndex(e,t){for(let a=0;a<e.length;a++)if(void 0!==e[a][t])return a;return 0}static _parseLenienthms(e,t,a,r,n){h._TIME_REGEXP.lastIndex=0;let s,o,i=0,l=0,d=0,m=0,_=h._TIME_REGEXP.exec(t);switch(null===_&&this._throwDateFormatMismatch(t,a,r),void 0!==_[1]&&(i=parseInt(_[1],10)),void 0!==_[2]&&(l=parseInt(_[2],10)),void 0!==_[3]&&(d=parseInt(_[3],10)),void 0!==_[4]&&(m=parseInt(_[4],10)),h._TIME_FORMAT_REGEXP.lastIndex=0,_=h._TIME_FORMAT_REGEXP.exec(a),_[0]){case"h":12===i&&(i=0),o={name:"hour",value:i,low:0,high:11,displayValue:i,displayLow:1,displayHigh:12},this._validateRange(o),s=this._matchPMSymbol(n,t),s&&i<12&&(i+=12);break;case"K":o={name:"hour",value:i,low:0,high:11,displayValue:i,displayLow:0,displayHigh:11},this._validateRange(o),s=this._matchPMSymbol(n,t),s&&i<12&&(i+=12);break;case"H":o={name:"hour",value:i,low:0,high:23,displayValue:i,displayLow:0,displayHigh:23},this._validateRange(o);break;case"k":24===i&&(i=0),o={name:"hour",value:i,low:0,high:23,displayValue:i,displayLow:1,displayHigh:24}}o={name:"minute",value:l,low:0,high:59,displayValue:l,displayLow:0,displayHigh:59},this._validateRange(o),o={name:"second",value:d,low:0,high:59,displayValue:d,displayLow:0,displayHigh:59},this._validateRange(o),o={name:"farctionalSecond",value:m,low:0,high:999,displayValue:m,displayLow:0,displayHigh:999},this._validateRange(o),e.setHours(i,l,d,m)}static _getWeekdayName(e,t){const a=t.days.format,r=t.days["stand-alone"],n=[a.wide,a.abbreviated,r.wide,r.abbreviated];for(let t=0;t<n.length;t++){const a=Object.keys(n[t]);for(let r=0;r<a.length;r++){const s=n[t][a[r]];if(new RegExp(s+"\\b","i").test(e))return s}}return null}static _parseLenientyMEd(e,t,a,r,n){h._YMD_REGEXP.lastIndex=0;let s=h._YMD_REGEXP.exec(e),o=0;null===s&&(o=n?2:0,this._throwDateFormatMismatch(e,t,o));let i=[{y:t.indexOf("y")},{M:t.indexOf("M")},{d:t.indexOf("d")}];i.sort(function(e,t){let a=Object.keys(e)[0],r=Object.keys(t)[0];return e[a]-t[r]});let l=0,d=0,m=0,_=0,u=0,E=0,p=this._getTokenIndex(i,"d"),g=!1,y=!1;for(E=1;E<=3;E++){let e=s[E],t=parseInt(e);(e.length>2||t>31)&&(l=t,g=!0,_=E-1)}for(g||(_=this._getTokenIndex(i,"y"),l=s[this._getTokenIndex(i,"y")+1]),E=0;E<3;E++)if(E!==_&&s[E+1]>12){m=s[E+1],y=!0,u=E;break}if(y){for(E=0;E<3;E++)if(E!==u&&E!==_){d=s[E+1];break}void 0===d&&(d=s[this._getTokenIndex(i,"M")+1])}else _===this._getTokenIndex(i,"d")?(m=s[this._getTokenIndex(i,"y")+1],d=s[this._getTokenIndex(i,"M")+1]):_===this._getTokenIndex(i,"M")?(m=s[this._getTokenIndex(i,"d")+1],d=s[this._getTokenIndex(i,"y")+1]):(m=s[this._getTokenIndex(i,"d")+1],d=s[this._getTokenIndex(i,"M")+1]);d-=1;let v,T=c._getDaysInMonth(l,d);y&&p!==u&&d>12&&(v={name:"month",value:m,low:0,high:11,displayValue:m,displayLow:1,displayHigh:12},this._validateRange(v)),v={name:"month",value:d,low:0,high:11,displayValue:d+1,displayLow:1,displayHigh:12},this._validateRange(v),v={name:"day",value:m,low:1,high:T,displayValue:m,displayLow:1,displayHigh:T},this._validateRange(v);const k=a.twoDigitYearStart||1950;l=this._expandYear(k,l),v={name:"year",value:l,low:0,high:9999,displayValue:l,displayLow:0,displayHigh:9999},this._validateRange(v);let f=new Date(l,d,m),I=this._getWeekdayName(e,r);if(null!==I){const e=this._getDayIndex(r,I,0);f.getDay()!==e&&this._throwWeekdayMismatch(I,f.getDate())}if(n){const a=e.substr(h._YMD_REGEXP.lastIndex);0===a.length?f.setHours(0,0,0,0):this._parseLenienthms(f,a,t,2,r)}return{value:c.dateToLocalIso(f),warning:"lenient parsing was used"}}static _parseLenientyMMMEd(e,t,a,r,n){let s=e;e=c.toUpper(e);const o=r.months.format,i=r.months["stand-alone"];let l=[o.wide,o.abbreviated,i.wide,i.abbreviated],d=!1,m=[],_=0,u="";for(_=0;_<l.length;_++){m=[];const t=Object.keys(l[_]);let a=0;for(a=0;a<t.length;a++)u=c.toUpper(l[_][t[a]]),m.unshift({idx:a,name:u});for(m.sort(function(e,t){return t.idx-e.idx}),a=0;a<m.length;a++)if(u=m[a].name,-1!==e.indexOf(u)){d=!0,e=e.replace(u,"");break}if(d)break}if(!d)return this._parseLenientyMEd(s,t,a,r,n);const E=this._getMonthIndex(r,u,2);let p={name:"month",value:E,low:0,high:11,displayValue:E,displayLow:1,displayHigh:12};this._validateRange(p);const g=this._getWeekdayName(s,r),y=new RegExp(g+"\\W","i");null!==g&&(e=e.replace(y,"")),h._YEAR_AND_DATE_REGEXP.lastIndex=0;const v=h._YEAR_AND_DATE_REGEXP.exec(e);if(null===v){const e=n?2:0;this._throwDateFormatMismatch(s,t,e)}let T=[{y:t.indexOf("y")},{d:t.indexOf("d")}];T.sort(function(e,t){const a=Object.keys(e)[0],r=Object.keys(t)[0];return e[a]-t[r]});let k=0,f=0,I=0,O=!1;for(_=1;_<=2;_++){const e=v[_],t=parseInt(e);(e.length>2||t>31)&&(k=t,O=!0,I=_-1)}O||(I=this._getTokenIndex(T,"y"),k=parseInt(v[this._getTokenIndex(T,"y")+1],10)),f=I===this._getTokenIndex(T,"d")?parseInt(v[this._getTokenIndex(T,"y")+1],10):parseInt(v[this._getTokenIndex(T,"d")+1],10);const P=a.twoDigitYearStart||1950;k=this._expandYear(P,k),p={name:"year",value:k,low:0,high:9999,displayValue:k,displayLow:0,displayHigh:9999},this._validateRange(p);const S=new Date(k,E,f);if(null!==g){const e=this._getDayIndex(r,g,0);S.getDay()!==e&&this._throwWeekdayMismatch(g,S.getDate())}const R=c._getDaysInMonth(k,E);if(p={name:"day",value:f,low:1,high:R,displayValue:f,displayLow:1,displayHigh:R},this._validateRange(p),n){const a=e.substr(h._YEAR_AND_DATE_REGEXP.lastIndex);0===a.length?S.setHours(0,0,0,0):this._parseLenienthms(S,a,t,2,r)}return{value:c.dateToLocalIso(S),warning:"lenient parsing was used"}}static _parseLenient(e,t,a,r){let n;switch(this._dateTimeStyle(a)){case 0:n=this._parseLenientyMMMEd(e,t,a,r,!1);break;case 1:const s=new Date;this._parseLenienthms(s,e,t,1,r);n={value:c.dateToLocalIso(s),warning:"lenient parsing was used"};break;case 2:n=this._parseLenientyMMMEd(e,t,a,r,!0);break;default:n={value:"",warning:"lenient parsing was used"}}const s=c._IsoStrParts(n.value),o=[s[0],s[1],s[2]],i=n.value.split("T");return n.value=c.padZeros(o[0],4)+"-"+c.padZeros(o[1],2)+"-"+c.padZeros(o[2],2)+"T"+i[1],n}static _getNameIndex(e,t,a,r,n,s,o,i,l,d,h){let m=0;const _=e[t][n];let c;m="months"===t?this._getMonthIndex(e,a,s):this._getDayIndex(e,a,s);const u=_[r][l],E=_[r][d];return c={name:h,value:m,low:o,high:i,displayValue:parseInt(a),displayLow:u,displayHigh:E},this._validateRange(c),m}static _validateTimePart(e,t,a,r){let n=t;n[a.timePart]=e,"h"===r||"hh"===r?12===e&&(n[a.timePart]=0):"k"===r||"kk"===r?(n.htoken=r,24===e&&(n[a.timePart]=0)):"K"!==r&&"KK"!==r||12===e&&(n[a.timePart]=0);const s={name:a.timePart,value:n[a.timePart],low:a.start1,high:a.end1,displayValue:e,displayLow:a.start2,displayHigh:a.end2};this._validateRange(s)}static _dateTimeStyle(e){const t=void 0!==e.hour||void 0!==e.minute||void 0!==e.second||void 0!==e.fractionalSecondDigits,a=void 0!==e.year||void 0!==e.month||void 0!==e.day||void 0!==e.weekday;return a&&t?2:t?1:a?0:void 0!==e.dateStyle&&void 0!==e.timeStyle?2:void 0!==e.timeStyle?1:0}static _getStdOffset(e,t){const a=this._parseZone(e,t,!1,!0,!1),r=e.ofset(a),n=e.ofset(a+1);return Math.max(r,n)}static _matchPMSymbol(e,t){const a=e.locale;let r=!1,n=0;if(h._zh_tw_locales.includes(a)){const e=h._zh_tw_pm_symbols;for(n=0;n<e.length;n++){const a=e[n];if(-1!==t.indexOf(a))return!0}}else{const a=e.dayPeriods.format.wide.pm;r=-1!==c.toUpper(t).indexOf(c.toUpper(a))}return r}static _parseExact(e,t,a,r,n){const s=n.eras.eraAbbr[1],o=c.trimNumber(s);e=e.replace(s,o);const i=c.getGetOption(a,"NativeDateTimeConverter.parse")("lenientParse","string",["none","full"],"full"),l=this._dateTimeStyle(a),d=this._getParseRegExp(t,a),m=new RegExp(d.regExp).exec(e);if(null===m){if("full"===i)return this._parseLenient(e,t,a,n);this._throwDateFormatMismatch(e,t,l)}const _=d.groups;let u,E=null,p=null,g=null,y=null,v="",T=null,k=void 0,f="",I={hour:0,minute:0,second:0,millisec:0,htoken:""};const O=a.twoDigitYearStart||1950;for(let r=0,s=_.length;r<s;r++){const s=m[r+1];if(s){const o=_[r],l=parseInt(s,10),d=h._PROPERTIES_MAP[o];switch(d.token){case"months":p=this._getNameIndex(n,d.token,s,d.mLen,d.style,d.matchIndex,0,11,"1","12","month name");break;case"days":f=s,y=this._getNameIndex(n,d.token,s,d.dLen,d.style,d.matchIndex,0,6,"sun","sat","weekday");break;case"time":this._validateTimePart(l,I,d,o);break;case"dayOfMonth":g=l;break;case"monthIndex":if(p=l-1,p>11&&"full"===i)try{return this._parseLenient(e,t,a,n)}catch(e){u={name:"month",value:p,low:0,high:11,displayValue:p+1,displayLow:1,displayHigh:12},this._validateRange(u)}break;case"year":E=this._expandYear(O,l);break;case"ampm":k=this._matchPMSymbol(n,s);break;case"tzhm":v=s.substr(-2),v=s.substr(0,3)+":"+v;break;case"tzhsepm":v=s;break;case"tzh":v=s+":00";break;case"tzid":T=s}}}const P=new Date;null===E&&(E=P.getFullYear()),null===p&&null===g?(p=P.getMonth(),g=P.getDate()):null===g&&(g=1),P.setFullYear(E,p,g);const S=c._getDaysInMonth(E,p);u={name:"day",value:g,low:1,high:S,displayValue:g,displayLow:1,displayHigh:S},this._validateRange(u),1==k&&I.hour<12&&(I.hour+=12),0!=k||12!=I.hour||"k"!=I.htoken&&"kk"!=I.htoken||(I.hour=0);let R=[E,p+1,g];R[3]=I.hour,R[4]=I.minute,R[5]=I.second,R[6]=I.millisec;let M=c.partsToIsoString(R);if(null!==T){const e=this._getTimeZone(T,r),t=this._parseZone(e,R,!1,!0,!0),a=-e.ofset(t);v=c.getTimeStringFromOffset("",a,!1,!0)}""!==v&&(M+=v),u={name:"year",value:E,low:0,high:9999,displayValue:E,displayLow:0,displayHigh:9999},this._validateRange(u),u={name:"month",value:p,low:0,high:11,displayValue:p+1,displayLow:1,displayHigh:12},this._validateRange(u);const G=c._getDaysInMonth(R[0],R[1]-1);if(u={name:"day",value:R[2],low:1,high:G,displayValue:R[2],displayLow:1,displayHigh:G},this._validateRange(u),null!==y){const e=c.isoToLocalDate(M);e.getDay()!==y&&this._throwWeekdayMismatch(f,e.getDate())}return{value:M}}static _isoStrDateTimeStyle(e){const t=e.indexOf("T");return-1===t?0:t>0?2:1}static _adjustHours(e,t,a){let r=e.isoStrParts;const n=e.format,s=t.timeZone,o=this._getTimeZone(s,a);let i=null,l=0,d=0,m=0;switch(i=Date.UTC(r[0],r[1]-1,r[2],r[3],r[4],r[5]),n){case h._OFFSET:let t=this._parseTimezoneOffset(e.timeZone);const a=t[0],r=t[1];l=60*a+(a<0?-r:r);break;case h._ZULU:l=0}d=this._getStdOffset(o,r),i-=6e4*(d+l);const _=c.getGetOption(t,"NativeDateTimeConverter")("dst","boolean",[!0,!1],!1),u=0===e.dateTime.indexOf("T");m=o.parse(i,_,!u,!1),d=-o.ofset(m),d-=l;let E=new Date(Date.UTC(r[0],r[1]-1,r[2],r[3],r[4],r[5]));const p=E.getUTCMinutes()+d;E.setUTCHours(E.getUTCHours()+(p/60<<0),p%60),r[0]=E.getUTCFullYear(),r[1]=E.getUTCMonth()+1,r[2]=E.getUTCDate(),r[3]=E.getUTCHours(),r[4]=E.getUTCMinutes(),r[5]=E.getUTCSeconds()}static _createISOStrParts(e,t){let a=0,r="";switch(e){case 0:r=c.padZeros(t[0],4)+"-"+c.padZeros(t[1],2)+"-"+c.padZeros(t[2],2);break;case 1:r="T"+c.padZeros(t[3],2)+":"+c.padZeros(t[4],2)+":"+c.padZeros(t[5],2),a=t[6],a>0&&(r+="."+c.trimRightZeros(a));break;default:r=c.padZeros(t[0],4)+"-"+c.padZeros(t[1],2)+"-"+c.padZeros(t[2],2)+"T"+c.padZeros(t[3],2)+":"+c.padZeros(t[4],2)+":"+c.padZeros(t[5],2),a=t[6],a>0&&(r+="."+c.trimRightZeros(a))}return r}static _getParseISOStringOffset(e,t,a,r,n,s){const o=this._getTimeZone(e,n),i=this._parseZone(o,t,a,r,s),l=o.ofset(i);return c.getTimeStringFromOffset("",l,!0,!0)}static _createParseISOStringFromDate(e,t,a,r){let n=null,s=0,o="",i=[];const l=c.getGetOption(a,"NativeDateTimeConverter.parse"),d=l("isoStrFormat","string",[h._ZULU,h._OFFSET,h._INVARIANT,h._LOCAL,h._AUTO],h._AUTO),m=l("dst","boolean",[!0,!1],!1);let _=!0;const u=t.isoStrParts,E=t.timeZone,p=a.timeZone,g=t.format,y=a.isoStrFormat;let v=this._createISOStrParts(e,u);if(0===e||y===h._LOCAL)return v;if(1===e&&y===h._AUTO)return v;switch(1===e&&(_=!1),d){case h._OFFSET:void 0===p&&g===h._OFFSET?v+=E:void 0===p&&g===h._LOCAL?v+="":void 0===p&&g===h._ZULU?v+="+00:00":void 0!==p&&(o=this._getParseISOStringOffset(p,u,m,_,r,!0),v+=o);break;case h._ZULU:let t=0;if(void 0===p)if(g===h._OFFSET){i=this._parseTimezoneOffset(E);const e=parseInt(i[0],10),a=parseInt(i[1],10);t=60*e+(e<0?-a:a),t=-t}else t=new Date(u[0],u[1]-1,u[2],u[3],u[4],u[5]).getTimezoneOffset();else n=this._getTimeZone(p,r),s=this._parseZone(n,u,m,_,!0),t=n.ofset(s);if(0!==t){const a=new Date(Date.UTC(u[0],u[1]-1,u[2],u[3],u[4],u[5],u[6]));t=a.getUTCMinutes()+t,a.setUTCHours(a.getUTCHours()+(t/60<<0),t%60),u[0]=a.getUTCFullYear(),u[1]=a.getUTCMonth()+1,u[2]=a.getUTCDate(),u[3]=a.getUTCHours(),u[4]=a.getUTCMinutes(),u[5]=a.getUTCSeconds(),v=this._createISOStrParts(e,u)}v+="Z";break;case h._AUTO:void 0!==p?(o=this._getParseISOStringOffset(p,u,m,_,r,!0),v+=o):(o=E,o&&(v+=o))}return v}}.parseImpl(e,this._getPatternFromOptions(this.resOptions),this.resOptions,s,n),r=a.value;return r&&a.warning&&t.warn("The value "+e+" was leniently parsed to represent a date "+r),r}catch(t){throw _.processError(t,e,this.getHintValue())}}resolvedOptions(){return this.resOptions.patternFromOptions||(this.resOptions.patternFromOptions=this._getPatternFromOptions(this.resOptions)),this.resOptions}getTimeZoneOffset(e,t,a){let n=0;const s=u._IsoStrParts(e);if(this.inputTimeZone){const e=r.__getBundle(),a=l.OraTimeZone.getInstance().getZone(t,e),o=Date.UTC(s[0],s[1]-1,s[2],s[3],s[4],s[5]),i=a.parse(o,!1,!0,!0);n=a.ofset(i)}else n=new Date(s[0],s[1]-1,s[2],s[3],s[4],s[5]).getTimezoneOffset();const o=-n;return a?u.getTimeStringFromOffset("",o,!1,!0):o}normalizeIsoString(e){if(null==e||""===e){throw new Error("input value of the format method cannot be empty")}e.startsWith("T")?e="2021-01-10"+e:-1===e.indexOf("T")&&(e+="T00:00:00");if(!u._ISO_DATE_REGEXP.exec(e)){const t=new Error(""),a={errorCode:"invalidISOString",parameterMap:{isoStr:e}};t.errorInfo=a;throw _.processError(t,"","")}let t=e.substring(e.indexOf("T"));if(-1===t.indexOf("Z")&&-1===t.indexOf("+")&&-1===t.indexOf("-")&&this.inputTimeZone){e+=this.getTimeZoneOffset(e,this.resOptions.timeZone,!0)}return e=e.replace(/(T.*?[+-]..$)/,"$1:00")}getHintValue(){let e="";try{e=this.format("1998-11-29T15:45:31")}catch(t){e=""}return e}static getPatternFromOptionsImpl(e,t){const a=new Date("2000-01-02T00:00:00");let r="",n="",s=null,o=null,i=null,l=!1,d=!1;void 0!==t.dateStyle&&(o=h._dateTimeFormats.dateStyle,o=o[t.dateStyle],l=!0),void 0!==t.timeStyle&&(i=h._dateTimeFormats.timeStyle,i=i[t.timeStyle],d=!0);let m=h._tokenMap;return e.formatToParts(a).map(({type:e,value:a})=>{switch(e){case"literal":s=a.replace(h._ALPHA_REGEXP,"'$1'");break;case"dayPeriod":s="a";break;case"hour":d?s=i[e]:(n=t[e],s=m[e][n]);let r=t.hour12;void 0===r&&(r=!1),t.hourCycle&&(s=s.replace(h._HOUR12_REGEXP,h._hourCycleMap[t.hourCycle])),!0===r&&(s=s.replace(h._HOUR12_REGEXP,"h"));break;case"month":l?s=isNaN(+a)?o.month_m:o.month_s:(n=t[e],s=m[e][n]);break;case"year":case"day":case"weekday":l?s=o[e]:(n=t[e],s=m[e][n]);break;case"minute":case"second":case"timeZoneName":d?s=i[e]:(n=t[e],s=m[e][n]);break;case"era":n=t[e]||"short",s=m[e][n];break;case"fractionalSecond":s=t.fractionalSecondDigits,s=m[e][s]}r+=s}),r}_getPatternFromOptions(e){return this.pattern||(this.pattern=E.getPatternFromOptionsImpl(this.intlFormatter,e)),this.pattern}}const p=n.OraI18nUtils;class g extends E{constructor(e){const t=g._processOptions(e);super(t.opts),this.formatTokens=t.formatTokens,this.pattern=e.pattern,this.timeZone=this.resOptions.timeZone}format(e){const t=this.normalizeIsoString(e);var a=new Date(t);return this.intlFormatter.formatToParts(a).map(({type:e,value:t})=>{if("literal"!==e){const a=this.formatTokens.tokensIndexes[e];void 0!==a&&(this.formatTokens.tokensArray[a]=t)}}),this._formatTimeZoneTokens(t,this.timeZone),this.formatTokens.tokensArray.join("")}resolvedOptions(){return this.resOptions.patternFromOptions||(this.resOptions.patternFromOptions=this.pattern),this.resOptions}static _processOptions(e){const t=g._getOptionsFromPattern(e.pattern);return e.timeZone&&(t.opts.timeZone=e.timeZone),e.hour12&&(t.opts.hour12=e.hour12),t.opts.numberingSystem="latn",t.opts.calendar="gregory",t.opts.isoStrFormat=e.isoStrFormat||"auto",t.opts.twoDigitYearStart=e.twoDigitYearStart||1950,t.opts.lenientParse=e.lenientParse||"full",t}_formatTimeZoneTokens(e,t){const a=this.formatTokens;for(var r=0;r<a.tzOffsetsArray.length;r++){const s=a.tzOffsetsArray[r],o=a.tokensIndexes[s];if("tzid"===s){a.tokensArray[o]=t;continue}const i=this.getTimeZoneOffset(e,t,!1);var n="";if(0!==i){switch(s){case"tzhm":n=(i<=0?"-":"+")+p.padZeros(Math.floor(Math.abs(i/60)),2)+p.padZeros(Math.floor(Math.abs(i%60)),2);break;case"tzhsepm":n=(i<=0?"-":"+")+p.padZeros(Math.floor(Math.abs(i/60)),2)+":"+p.padZeros(Math.floor(Math.abs(i%60)),2);break;case"tzh":n=(i<=0?"-":"+")+p.padZeros(Math.floor(Math.abs(i/60)),2)}a.tokensArray[o]=n}else a.tokensArray[o]="UTC"}}static _appendPreOrPostMatch(e,t,a){let r=0,n=!1;for(var s=0,o=e.length;s<o;s++){var i=e.charAt(s);switch(i){case"'":n?(a.push("'"),t.count++):r+=1,n=!1;break;case"\\":n&&(a.push("\\"),t.count++),n=!n;break;default:a.push(i),n=!1,t.count++}}return r}static _getOptionsFromPattern(e){let t=0,a={count:0},r=0,n={},s=[],o={},i=[];for(h._TOKEN_REGEXP.lastIndex=0;;){let l=h._TOKEN_REGEXP.lastIndex;const d=h._TOKEN_REGEXP.exec(e),m=e.slice(l,d?d.index:e.length);if(t+=g._appendPreOrPostMatch(m,a,s),!d)break;if(t%2)s.push(d[0]),a.count++;else{s.push(null);let e=d[0];if(void 0===h._PROPERTIES_MAP[e])break;{const t=h._PROPERTIES_MAP[e].key,s=h._PROPERTIES_MAP[e].type;void 0!==t&&("millisecond"===t?(o[h.FRACTIONAL_SECOND_MAP[e].key]=h.FRACTIONAL_SECOND_MAP[e].value,n[h.FRACTIONAL_SECOND_MAP[e].token]=a.count++):"tzOffset"===s?(i[r]=t,n[t]=a.count++,r++):(o[t]=h._PROPERTIES_MAP[e].value,n[t]=a.count++)),"KK"===e||"K"===e?o.hourCycle="h11":"kk"===e||"k"===e?o.hourCycle="h24":"HH"===e||"H"===e?o.hourCycle="h23":"hh"!==e&&"h"!==e||(o.hourCycle="h12")}}}return{opts:o,formatTokens:{tokensArray:s,tzOffsetsArray:i,tokensIndexes:n}}}}class y{static getPreferencesMergedWithConverterOptions(e){let t=y._getPreferencesPatternAndTimezone(e),a={};return Object.assign(a,t,e),a}static _getPreferencesPatternAndTimezone(e){const t=d.getDateTimePreferences();if(!t||0===Object.keys(t).length)return{};let a={};if(!e||0===Object.keys(e).length){const e=y._getUserPrefPattern("short",null,t);e&&(a.pattern=e)}else if(e.dateStyle||e.timeStyle){const r=y._getUserPrefPattern(e.dateStyle,e.timeStyle,t);r&&(a.pattern=r)}return t.timeZone&&(a.timeZone=t.timeZone),a}static _getUserPrefPattern(e,t,a){var r,n,s,o,i,l,d,h;if(!e&&!t||!a)return null;let m=null,_=null;return"short"===e?m=null!==(n=null===(r=a.dateStyle)||void 0===r?void 0:r.short)&&void 0!==n?n:null:"medium"===e&&(m=null!==(o=null===(s=a.dateStyle)||void 0===s?void 0:s.medium)&&void 0!==o?o:null),"short"===t?_=null!==(l=null===(i=a.timeStyle)||void 0===i?void 0:i.short)&&void 0!==l?l:null:"medium"===t&&(_=null!==(h=null===(d=a.timeStyle)||void 0===d?void 0:d.medium)&&void 0!==h?h:null),y._combinePatternsWithSpace(m,_)}static _combinePatternsWithSpace(e,t){let a;return a=e&&t?`${e} ${t}`:t||(e||null),a}}e.DateTimePreferencesUtils=y,e.NativeDateTimeConverter=E,e.NativeDateTimePatternConverter=g,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=ojconverter-nativedatetime.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojavailabletimezones',["exports","ojs/ojlocaledata","ojs/ojoratimezone","ojs/ojconverterutils-i18n"],function(e,t,n,o){"use strict";const i=o.OraI18nUtils;class a{static getAvailableTimeZonesImpl(){return a._availableTimeZonesImpl(t.__getBundle())}static _getBCP47Lang(e){return e.split("-")[0]}static _availableTimeZonesImpl(e){const t=n.OraTimeZone.getInstance(),o={sensitivity:"variant"},l=i.getLocaleElementsMainNodeKey(e),s=i.getLocaleElementsMainNode(e),c=i.getLocaleElementsMainNodeKey(e),r=a._getBCP47Lang(c),m=s.dates.timeZoneNames.metazone,d=s.dates.timeZoneNames.zone,u=[],f={},v=e.supplemental.timeZoneData,g=new Date,p=[g.getFullYear(),g.getMonth()+1,g.getDate(),g.getHours(),g.getMinutes(),g.getSeconds()];function _(e,t){const n=function(e,t,n,o,i){const a=Date.UTC(t[0],t[1]-1,t[2],t[3],t[4],t[5]);return e.parse(a,n,o,i)}(e,t,!1,!0,!1),o=e.ofset(n),i=e.ofset(n+1);return Math.max(o,i)}function h(e){const t=e.split(" ");let n=t[0].split("-");const o=new Date(n[0],n[1]-1,n[2]);return t.length>1&&(n=t[1].split(":"),o.setHours(n[0]),o.setMinutes(n[1])),o.getTime()}function N(t,n,o,a){const l=t.split("/"),s=l[0],c=l[1];let m,d;const u={offsetLocName:null,locName:null},f=a[s];"en"===r?void 0!==l[1]&&(m=" "+l[1],m=m.replace(/_/g," "),m=m.replace("Saigon","Ho Chi Minh City")):void 0!==f&&(m=f[c],void 0!==m&&(m=m.exemplarCity,void 0!==m&&(m=" "+m)));const v=s+"/"+c,g=e.supplemental.metazones;let _=function(e,t,n){const o=new Date(e[0],e[1]-1,e[2],e[3],e[4],e[5]).getTime(),i=t.split("/"),a=i[0],l=i[1];let s=n[a];if(void 0===s)return null;if(s=s[l],void 0===s)return null;const c=s.length;let r,m;for(var d=0;d<c;d++){const e=s[d].usesMetazone._from,t=s[d].usesMetazone._to,n=s[d].usesMetazone._mzone;if(void 0===e&&void 0===t)return n;if(void 0===e&&void 0!==t&&(m=h(t),o<=m))return n;if(void 0!==e&&void 0===t&&(r=h(e),o>=r))return n;if(void 0!==e&&void 0!==t&&(r=h(e),m=h(t),o>=r&&o<m))return n}}(p,v,g);if(void 0!==o&&(_=o[_]),null!=_&&void 0!==_.long&&(d=_.long.generic,void 0===d&&(d=_.long.standard)),void 0===m)return null;let N="(UTC)";return 0!==n&&(N=i.getTimeStringFromOffset("UTC",n,!0,!0),N=`(${N})`),void 0===d&&(d=""),""!==d&&(d=" - "+d),u.offsetLocName=N+m+d,u.locName=m+d,u}function Z(e,t){return e.find(({displayName:e})=>e.offsetLocName===t.offsetLocName)}function C(n,o){let i,a;const l=Object.keys(n);for(let n=0;n<l.length;n++){let s=l[n];if(-1===s.indexOf("Etc/")&&-1===s.indexOf("Ho_Chi_Minh")){i=t.getZone(s,e),a=_(i,p);const n=N(s,a,m,d);if(null!==n)Z(o,n)||("Asia/Saigon"===s&&(s="Asia/Ho_Chi_Minh"),o.push({id:s,displayName:n}));f[s]=a}}}const M=i.getLocaleElementsMainNodeKey(e);if(void 0!==a._timeZoneDataCache&&void 0!==a._timeZoneDataCache[M]){const e=a._timeZoneDataCache[M].availableTimeZones;if(void 0!==e)return e}C(v.zones,u),C(v.links,u),u.sort(function(e,t){return f[t.id]-f[e.id]+e.displayName.locName.localeCompare(t.displayName.locName,l,o)});const y=u.length;for(let e=0;e<y;e++)u[e].displayName=u[e].displayName.offsetLocName;return void 0!==a._timeZoneDataCache&&void 0===a._timeZoneDataCache[M]&&(a._timeZoneDataCache[M]={availableTimeZones:null},a._timeZoneDataCache[M].availableTimeZones=u),u}}a._timeZoneDataCache={},e.AvailableTimeZones=a,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=ojavailabletimezones.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojconverter-datetime',["exports","ojs/ojconverterutils-i18n","ojs/ojconverter","ojs/ojlocaledata","ojs/ojconverter-nativedatetime","ojs/ojconfig","ojs/ojcore-base","ojs/ojavailabletimezones"],function(t,e,n,o,r,i,a,s){"use strict";n=n&&Object.prototype.hasOwnProperty.call(n,"default")?n.default:n,a=a&&Object.prototype.hasOwnProperty.call(a,"default")?a.default:a;const u=function(t){this.Init(t)};oj.Object.createSubclass(u,n,"oj.DateTimeConverter"),u.prototype.Init=function(t){u.superclass.Init.call(this,t)},u.prototype.format=function(t){return u.superclass.format.call(this,t)},u.prototype.isHourInDaySet=function(){oj.Assert.failedInAbstractFunction()},u.prototype.isHourInAMPMSet=function(){oj.Assert.failedInAbstractFunction()},u.prototype.isMinuteSet=function(){oj.Assert.failedInAbstractFunction()},u.prototype.isSecondSet=function(){oj.Assert.failedInAbstractFunction()},u.prototype.isMilliSecondSet=function(){oj.Assert.failedInAbstractFunction()},u.prototype.isYearSet=function(){oj.Assert.failedInAbstractFunction()},u.prototype.isMonthSet=function(){oj.Assert.failedInAbstractFunction()},u.prototype.isDaySet=function(){oj.Assert.failedInAbstractFunction()},u.prototype.isDayNameSet=function(){oj.Assert.failedInAbstractFunction()},u.prototype.calculateWeek=function(t){oj.Assert.failedInAbstractFunction()},u.prototype.parse=function(t){return u.superclass.parse.call(this,t)},u.prototype.compareISODates=function(t,e){return u.superclass.compareISODates.call(this,t,e)},u.prototype.getAvailableTimeZones=function(){return u.superclass.getAvailableTimeZones.call(this)};const l=function(){var t,n=46,a=46,s=23,u=7,l=4,c=12;function p(t,e){return t.getFullYear()===e.getFullYear()}function m(t,e){return e.getFullYear()-t.getFullYear()==1}function d(t,e){return p(t,e)&&t.getMonth()===e.getMonth()}function f(t,e){return p(t,e)?e.getMonth()-t.getMonth()==1:!!m(t,e)&&(11===t.getMonth()&&0===e.getMonth())}function y(t,n){var o=t.getDate(),r=n.getDate();return f(t,n)&&(r+=e.OraI18nUtils._getDaysInMonth(t.getFullYear,t.getMonth())),r-o}function h(t,n){var o=t._ojLocale_,r=e.OraI18nUtils.getBCP47Region(o),i=t.supplemental.weekData.firstDay,a=i[r];void 0===a&&(a=i["001"]);var s=n-a;return s<0&&(s+=7),s}function O(t,e,n){if(!d(e,n)&&!f(e,n))return!1;var o=y(e,n)+h(t,e.getDay());return o>=7&&o<=13}function v(t,e){return p(t,e)&&d(t,e)&&t.getDate()===e.getDate()}function g(t,e){return!(!d(t,e)&&!f(t,e))&&1===y(t,e)}function I(t,e){return g(e,t)}function D(t){var e=function(t){return 4800*t/146097}(t/864e5),n=e/12;return{year:Math.round(n),month:Math.round(e),week:Math.round(t/6048e5),day:Math.round(t/864e5),hour:Math.round(t/36e5),minute:Math.round(t/6e4),second:Math.round(t/1e3),millisecond:t}}function S(t,n,o){var r=e.OraI18nUtils._IsoStrParts(t),i=e.OraI18nUtils._IsoStrParts(n);return o?(r=Date.UTC(r[0],r[1]-1,r[2],0,0,0,0),i=Date.UTC(i[0],i[1]-1,i[2],0,0,0,0)):(r=Date.UTC(r[0],r[1]-1,r[2],r[3],r[4],r[5],r[6]),i=Date.UTC(i[0],i[1]-1,i[2],i[3],i[4],i[5],i[6])),r-i}function T(t,e){return new Intl.DateTimeFormat(i.getLocale(),e).format(t)}function w(t,n,o){var i=n.timeZone,a=e.OraI18nUtils.getISOStrFormatInfo(t).format;if("offset"===a||"zulu"===a){var s=new Date(t);return e.OraI18nUtils.dateToLocalIso(s)}return"local"===a&&!i?t:function(t,n,o){var i={isoStrFormat:"zulu",timeZone:n.timeZone},a=r.NativeParserImpl.parseImpl(t,null,i,o),s=new Date(a.value);return e.OraI18nUtils.dateToLocalIso(s)}(t,n,o)}function _(t,n,o){var r,a,s,u,l=[],c=e.OraI18nUtils.isoToLocalDate(n),p=e.OraI18nUtils.isoToLocalDate(t),m=i.getLocale();if(v(p,c))l=[0,"day","auto"],r=new Intl.RelativeTimeFormat(m,{numeric:l[2]}).format(l[0],l[1]);else if(g(p,c))l=[1,"day","auto"],r=new Intl.RelativeTimeFormat(m,{numeric:l[2]}).format(l[0],l[1]);else if(I(p,c))l=[-1,"day","auto"],r=new Intl.RelativeTimeFormat(m,{numeric:l[2]}).format(l[0],l[1]);else{var d=S(n,t,!0);if(!((d/=864e5)>1&&d<7))return T(c,{year:"numeric",month:"numeric",day:"numeric"});r=T(c,{weekday:"long"})}return o?r:(a=T(c,{hour:"numeric",minute:"numeric"}),r+(s=new Intl.DateTimeFormat(i.getLocale(),{dateStyle:"long",timeStyle:"short"}).formatToParts(new Date),u=s.findIndex(t=>"hour"===t.type)-1,s[u]?s[u].value:" ")+a)}function F(t,n,o,r){var a=e.OraI18nUtils.getGetOption(o,"OraDateTimeConverter.formatRelative")("dateField","string",["day","week","month","year","hour","minute","second"]),s=e.OraI18nUtils.isoToLocalDate(t),u=e.OraI18nUtils.isoToLocalDate(n),l=S(n,t,!1),c=D(Math.abs(l)),T=[];switch(a){case"day":T=v(s,u)?[0,"day","auto"]:g(s,u)?[1,"day","auto"]:I(s,u)?[-1,"day","auto"]:[l>0?c.day:-c.day,"day","always"];break;case"week":T=function(t,e,n){if(e>n){var o=e;e=n,n=o}if(!d(e,n)&&!f(e,n))return!1;var r=y(e,n)+h(t,e.getDay());return r>=0&&r<=6}(r,s,u)?[0,"week","auto"]:O(r,s,u)?[1,"week","auto"]:function(t,e,n){return O(t,n,e)}(r,s,u)?[-1,"week","auto"]:[l>0?c.week:-c.week,"week","always"];break;case"month":d(s,u)?T=[0,"month","auto"]:f(s,u)?T=[1,"month","auto"]:T=f(u,s)?[-1,"month","auto"]:[l>0?c.month:-c.month,"month","always"];break;case"year":T=p(s,u)?[0,"year","auto"]:m(s,u)?[1,"year","auto"]:function(t,e){return m(e,t)}(s,u)?[-1,"year","auto"]:[l>0?c.year:-c.year,"year","always"];break;case"hour":T=[l>0?c.hour:-c.hour,"hour","auto"];break;case"minute":T=[l>0?c.minute:-c.minute,"minute","auto"];break;case"second":T=[l>0?c.second:-c.second,"second","auto"]}return new Intl.RelativeTimeFormat(i.getLocale(),{numeric:T[2]}).format(T[0],T[1])}function b(t,o,r){var p=e.OraI18nUtils.dateToLocalIso(new Date);if("number"==typeof t)t=e.OraI18nUtils.dateToLocalIso(new Date(t));else{if("string"!=typeof t)return null;if(""===e.OraI18nUtils.trim(t))return null}void 0===r&&(r={formatUsing:"displayName"});var m=e.OraI18nUtils.getGetOption(r,"OraDateTimeConverter.formatRelative"),d=m("relativeTime","string",["fromNow","toNow"],"fromNow"),f=m("dateField","string",["day","week","month","year","hour","minute","second"]);if(t=w(t,r,o),"toNow"===d){var y=p;p=t,t=y}return"calendar"===m("formatUsing","string",["displayName","calendar"],"displayName")?_(p,t,m("dateOnly","boolean",[!0,!1],!1)):void 0!==f?F(p,t,r,o):function(t,e,o,r){var p=S(e,t,!1),m=D(Math.abs(p));return null===o&&(o=(m.second<n?"second":m.minute<a&&"minute")||m.hour<s&&"hour"||m.day<u&&"day"||m.week<l&&"week"||m.month<c&&"month"||"year"),new Intl.RelativeTimeFormat(i.getLocale(),{numeric:r}).format(m[o],o)}(p,t,null,"auto")}return{getInstance:function(){return t||(t={formatRelative:function(t,e){return b(t,o.__getBundle(),e)}}),t}}}(),c=function(t){let e=t?c.mapOptions(t):null;const n=r.DateTimePreferencesUtils.getPreferencesMergedWithConverterOptions(e),o=0===Object.keys(n).length?{year:"numeric",month:"numeric",day:"numeric"}:n;this.Init(o)};a.Object.createSubclass(c,u,"oj.IntlDateTimeConverter"),c._DEFAULT_DATE=new Date(1998,10,29,15,45,31),c.prototype.Init=function(t){c.superclass.Init.call(this,t),this._initConverter()},c.prototype._getWrapped=function(){return this._wrapped},c.prototype._initConverter=function(){var t=this.getOptions();t.numberingSystem="latn",t.calendar="gregory",t.pattern?this._wrapped=new r.NativeDateTimePatternConverter(t):this._wrapped=new r.NativeDateTimeConverter(t),t.timeZone||delete this._wrapped.resOptions.timeZone},c.prototype.format=function(t){if(null==t||"string"==typeof t&&0===a.StringUtils.trim(""+t).length)return"";let n=t;if("number"==typeof t)n=e.OraI18nUtils.dateToLocalIso(new Date(t));else{if("string"!=typeof t)return null;n=e.OraI18nUtils.trim(t)}return this._getWrapped().format(n)},c.prototype.formatRelative=function(t,e){return l.getInstance().formatRelative(t,e)},c.prototype.getHint=function(){return null},c.prototype.getOptions=function(){return c.superclass.getOptions.call(this)},c.prototype.resolvedOptions=function(){if(!this._resolvedOptions){const t=this._getWrapped().resolvedOptions();this._resolvedOptions={};const e=Object.keys(t);let n=0;for(n=0;n<e.length;n++){const o=e[n];"timeStyle"===o?this._resolvedOptions.timeFormat=t[o]:"dateStyle"===o?this._resolvedOptions.dateFormat=t[o]:"fractionalSecondDigits"===o?this._resolvedOptions.millisecond="numeric":"twoDigitYearStart"===o?this._resolvedOptions["two-digit-year-start"]=t[o]:this._resolvedOptions[o]=t[o]}this._resolvedOptions.dateFormat&&this._resolvedOptions.timeFormat?this._resolvedOptions.formatType="datetime":this._resolvedOptions.dateFormat?this._resolvedOptions.formatType="date":this._resolvedOptions.timeFormat&&(this._resolvedOptions.formatType="time");const o=["hour","minute","second","millisecond","day","month","year","weekday","timeZoneName","dayPeriod"];if(this._resolvedOptions.dateFormat||this._resolvedOptions.timeFormat){const t=Object.keys(this._resolvedOptions);o.forEach(e=>{t.includes(e)&&delete this._resolvedOptions[e]})}}return this._resolvedOptions},c.prototype.isHourInDaySet=function(){var t=this.resolvedOptions(),e=t.hour,n=t.hour12;return!(!e||n)},c.prototype.isHourInAMPMSet=function(){var t=this.resolvedOptions(),e=t.hour,n=t.hour12;return!(!e||!n)},c.prototype.isMinuteSet=function(){return this._isOptionSet("minute")},c.prototype.isSecondSet=function(){return this._isOptionSet("second")},c.prototype.isMilliSecondSet=function(){return this._isOptionSet("millisecond")},c.prototype.isYearSet=function(){return this._isOptionSet("year")},c.prototype.isMonthSet=function(){return this._isOptionSet("month")},c.prototype.isDaySet=function(){return this._isOptionSet("day")},c.prototype.isDayNameSet=function(){return this._isOptionSet("weekday")},c.prototype.calculateWeek=function(t){var n,o=e.OraI18nUtils._IsoStrParts(t),r=new Date(Date.UTC(o[0],o[1]-1,o[2]));return r.setUTCDate(r.getUTCDate()+4-(r.getUTCDay()||7)),n=r.getTime(),r.setUTCMonth(0),r.setUTCDate(1),Math.floor(Math.round((n-r)/864e5)/7)+1},c.prototype.parse=function(t){if(null===t||""===t||void 0===t)return null;var n=this._wrapped.resOptions.isoStrFormat,o=this._wrapped.resOptions.timeZone,r="";if(e.OraI18nUtils._ISO_DATE_REGEXP.test(t)&&(-1!==(r=t.substring(t.indexOf("T"))).indexOf("Z")&&!o))return t;var i=this._getWrapped().parse(t),a=-1===(r=i.substring(i.indexOf("T"))).indexOf("Z")&&-1===r.indexOf("+")&&-1===r.indexOf("-");return!o&&n&&a&&(i=e.OraI18nUtils.convertISOString(i,n)),i},c.prototype.compareISODates=function(t,n){const o=new Date,r=o.getMonth()+1;let i=e.OraI18nUtils.zeroPad(r.toString(),2,!0);const a=o.getDate();let s=e.OraI18nUtils.zeroPad(a.toString(),2,!0);const u=o.getFullYear()+"-"+i+"-"+s;let l=t,c=n;const p=0===l.indexOf("T"),m=0===c.indexOf("T"),d=-1===l.indexOf("T"),f=-1===c.indexOf("T");p?l=u+l:d&&(l+="T00:00:00"),m?c=u+c:f&&(c+="T00:00:00");const y=new Date(l),h=new Date(c);return y.getTime()-h.getTime()},c.prototype._isOptionSet=function(t){return!!this.resolvedOptions()[t]},c.prototype.getAvailableTimeZones=function(){return s.AvailableTimeZones.getAvailableTimeZonesImpl()},c.isECMAOptionSet=function(t){return t.year||t.month||t.day||t.weekday||t.hour||t.minute||t.second||t.millisecond||t.dayPeriod||t.timeZoneName},c.mapOptions=function(t){let e={};const n=Object.keys(t);let o=0;var r=c.isECMAOptionSet(t);for(n.includes("formatType")||!t.dateFormat&&!t.timeFormat||r||(e.dateStyle=t.dateFormat||"short"),o=0;o<n.length;o++){const i=n[o];"formatType"!==i||r?"millisecond"===i?e.fractionalSecondDigits=3:"two-digit-year-start"===i?e.twoDigitYearStart=t[i]:e[i]=t[i]:("datetime"!==t[i]&&"date"!==t[i]||(e.dateStyle=t.dateFormat||"short"),"datetime"!==t[i]&&"time"!==t[i]||(e.timeStyle=t.timeFormat||"short"))}return e},t.DateTimeConverter=u,t.IntlDateTimeConverter=c,t.RelativeDateTimeFormatter=l,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ojconverter-datetime.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojfilter-length',[],function(){"use strict";return class{constructor(t){if(this.options=t,!t.max)throw new Error("length filter's max option cannot be less than 1. max option is "+t.max);if(isNaN(t.max))throw new Error("length filter's max option is not a number. max option is "+t.max);if(null!==t.max&&t.max<1)throw new Error("length filter's max option cannot be less than 1. max option is "+t.max);t.countBy=void 0===t.countBy?"codePoint":t.countBy}filter(t,n){return this.calcLength(n)<=this.options.max?n:t.slice(0,this.options.max)}calcLength(t){const n=this.options.countBy;if(""==t||null==t||null==t)return 0;const o=t.length;let i,e=0;switch(n){case"codePoint":for(let n=0;n<o;n++)55296==(63488&t.charCodeAt(n))&&(e+=1);i=o-e/2;break;case"codeUnit":default:i=o}return i}}});
//# sourceMappingURL=ojfilter-length.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojvalidator-regexp',["ojs/ojcore","ojs/ojtranslation","ojs/ojvalidator","ojs/ojvalidation-error"],function(t,o,e,a){"use strict";t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t,e=e&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e;const i=function(t){this.Init(t)};return t.Object.createSubclass(i,e,"oj.RegExpValidator"),i._BUNDLE_KEY_DETAIL="oj-validator.regExp.detail",i._BUNDLE_KEY_SUMMARY="oj-validator.regExp.summary",i.prototype.Init=function(t){i.superclass.Init.call(this),this._options=t},i.prototype.validate=function(t){var e,i,r,n=this._options&&this._options.pattern||"";if(null!=t&&""!==t){var s=t.toString(),l="^("+n+")$",p=s.match(l);if(null===p||p[0]!==s){this._options&&(r=this._options.messageSummary||null,e=this._options.messageDetail||null,i=this._options&&this._options.label||"");var u={label:i,pattern:n,value:s},_=r?o.applyParameters(r,u):o.getTranslatedString(this._getSummaryKey(),u),h=e?o.applyParameters(e,u):o.getTranslatedString(this._getDetailKey(),u);throw new a.ValidatorError(_,h)}}},i.prototype.getHint=function(){var t=null,e={};return this._options&&this._options.hint&&(e={pattern:this._options.pattern},t=o.applyParameters(this._options.hint,e)),t},i.prototype._getSummaryKey=function(){return i._BUNDLE_KEY_SUMMARY},i.prototype._getDetailKey=function(){return i._BUNDLE_KEY_DETAIL},i});
//# sourceMappingURL=ojvalidator-regexp.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojinputtext',["ojs/ojcore","jquery","ojs/ojthemeutils","ojs/ojeditablevalue","ojs/ojcore-base","ojs/ojdomutils","ojs/ojfilter-length","ojs/ojvalidator-regexp","ojs/ojcustomelement-utils"],function(e,t,i,n,s,r,a,o,l){"use strict";t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t,s=s&&Object.prototype.hasOwnProperty.call(s,"default")?s.default:s,a=a&&Object.prototype.hasOwnProperty.call(a,"default")?a.default:a,o=o&&Object.prototype.hasOwnProperty.call(o,"default")?o.default:o,function(){var e={properties:{readonly:{binding:{consume:{name:"readonly"}}},userAssistanceDensity:{binding:{consume:{name:"userAssistanceDensity"}}},labelEdge:{binding:{consume:{name:"labelEdge"}}}}},t={properties:{asyncValidators:{type:"Array<Object>",value:[]},autocomplete:{type:"string",value:"on",extension:{_COPY_TO_INNER_ELEM:!0}},autofocus:{type:"boolean",value:!1,extension:{_COPY_TO_INNER_ELEM:!0}},describedBy:{type:"string"},disabled:{type:"boolean",value:!1},displayOptions:{type:"object",properties:{converterHint:{type:"Array<string>|string"},helpInstruction:{type:"Array<string>|string",value:["notewindow"]},messages:{type:"Array<string>|string"},validatorHint:{type:"Array<string>|string"}}},help:{type:"object",properties:{instruction:{type:"string",value:""}}},helpHints:{type:"object",properties:{definition:{type:"string",value:""},source:{type:"string",value:""}}},labelEdge:{type:"string",enumValues:["inside","none","provided"]},labelHint:{type:"string",value:""},labelledBy:{type:"string"},maskIcon:{type:"string",enumValues:["hidden","visible"],value:"hidden"},messagesCustom:{type:"Array<Object>",writeback:!0,value:[]},name:{type:"string",value:"",extension:{_COPY_TO_INNER_ELEM:!0}},placeholder:{type:"string"},rawValue:{type:"string",writeback:!0,readOnly:!0},readonly:{type:"boolean",value:!1},required:{type:"boolean",value:!1},translations:{type:"object",value:{},properties:{accessibleHidePassword:{type:"string"},accessibleMaxLengthExceeded:{type:"string"},accessibleMaxLengthRemaining:{type:"string"},accessibleShowPassword:{type:"string"},regexp:{type:"object",properties:{messageDetail:{type:"string"},messageSummary:{type:"string"}}},required:{type:"object",properties:{hint:{type:"string"},messageDetail:{type:"string"},messageSummary:{type:"string"}}}}},userAssistanceDensity:{type:"string",enumValues:["compact","efficient","reflow"],value:"reflow"},valid:{type:"string",writeback:!0,enumValues:["invalidHidden","invalidShown","pending","valid"],readOnly:!0},validators:{type:"Array<Object>",value:[]},value:{type:"string",writeback:!0}},methods:{getProperty:{},refresh:{},reset:{},setProperties:{},setProperty:{},showMessages:{},validate:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojAnimateEnd:{},ojAnimateStart:{}},extension:{}};t.extension._WIDGET_NAME="ojInputPassword",t.extension._INNER_ELEM="input",t.extension._GLOBAL_TRANSFER_ATTRS=["accesskey","aria-label","tabindex"],t.extension._ALIASED_PROPS={readonly:"readOnly"},s.CustomElementBridge.register("oj-input-password",{metadata:s.CollectionUtils.mergeDeep(t,e)});var i={properties:{asyncValidators:{type:"Array<Object>",value:[]},autocomplete:{type:"string",value:"on",extension:{_COPY_TO_INNER_ELEM:!0}},autofocus:{type:"boolean",value:!1,extension:{_COPY_TO_INNER_ELEM:!0}},clearIcon:{type:"string",enumValues:["always","conditional","never"],value:"never"},converter:{type:"object"},describedBy:{type:"string"},disabled:{type:"boolean",value:!1},displayOptions:{type:"object",properties:{converterHint:{type:"Array<string>|string"},helpInstruction:{type:"Array<string>|string",value:["notewindow"]},messages:{type:"Array<string>|string"},validatorHint:{type:"Array<string>|string"}}},help:{type:"object",properties:{instruction:{type:"string",value:""}}},helpHints:{type:"object",properties:{definition:{type:"string",value:""},source:{type:"string",value:""}}},labelEdge:{type:"string",enumValues:["inside","none","provided"]},labelHint:{type:"string",value:""},labelledBy:{type:"string"},length:{type:"object",properties:{countBy:{type:"string",enumValues:["codePoint","codeUnit"],value:"codePoint"},max:{type:"number"}}},list:{type:"string",extension:{_COPY_TO_INNER_ELEM:!0}},messagesCustom:{type:"Array<Object>",writeback:!0,value:[]},name:{type:"string",value:"",extension:{_COPY_TO_INNER_ELEM:!0}},placeholder:{type:"string"},rawValue:{type:"string",writeback:!0,readOnly:!0},readonly:{type:"boolean",value:!1},required:{type:"boolean",value:!1},translations:{type:"object",value:{},properties:{accessibleMaxLengthExceeded:{type:"string"},accessibleMaxLengthRemaining:{type:"string"},regexp:{type:"object",properties:{messageDetail:{type:"string"},messageSummary:{type:"string"}}},required:{type:"object",properties:{hint:{type:"string"},messageDetail:{type:"string"},messageSummary:{type:"string"}}}}},userAssistanceDensity:{type:"string",enumValues:["compact","efficient","reflow"],value:"reflow"},valid:{type:"string",writeback:!0,enumValues:["invalidHidden","invalidShown","pending","valid"],readOnly:!0},validators:{type:"Array<Object>",value:[]},value:{type:"any",writeback:!0},virtualKeyboard:{type:"string",enumValues:["auto","email","number","search","tel","text","url"],value:"auto"}},methods:{getProperty:{},refresh:{},reset:{},setProperties:{},setProperty:{},showMessages:{},validate:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojAnimateEnd:{},ojAnimateStart:{}},extension:{}};i.extension._WIDGET_NAME="ojInputText",i.extension._INNER_ELEM="input",i.extension._GLOBAL_TRANSFER_ATTRS=["accesskey","aria-label","tabindex","autocapitalize"],i.extension._ALIASED_PROPS={readonly:"readOnly"},s.CustomElementBridge.register("oj-input-text",{metadata:s.CollectionUtils.mergeDeep(i,e)});var n={properties:{asyncValidators:{type:"Array<Object>",value:[]},autocomplete:{type:"string",value:"on",extension:{_COPY_TO_INNER_ELEM:!0}},autofocus:{type:"boolean",value:!1,extension:{_COPY_TO_INNER_ELEM:!0}},converter:{type:"object"},describedBy:{type:"string"},disabled:{type:"boolean",value:!1},displayOptions:{type:"object",properties:{converterHint:{type:"Array<string>|string"},helpInstruction:{type:"Array<string>|string",value:["notewindow"]},messages:{type:"Array<string>|string"},validatorHint:{type:"Array<string>|string"}}},help:{type:"object",properties:{instruction:{type:"string",value:""}}},helpHints:{type:"object",properties:{definition:{type:"string",value:""},source:{type:"string",value:""}}},labelEdge:{type:"string",enumValues:["inside","none","provided"]},labelHint:{type:"string",value:""},labelledBy:{type:"string"},length:{type:"object",properties:{countBy:{type:"string",enumValues:["codePoint","codeUnit"],value:"codePoint"},counter:{type:"string",enumValues:["none","remaining"],value:"none"},max:{type:"number"}}},maxRows:{type:"number",value:0},messagesCustom:{type:"Array<Object>",writeback:!0,value:[]},name:{type:"string",value:"",extension:{_COPY_TO_INNER_ELEM:!0}},placeholder:{type:"string"},rawValue:{type:"string",writeback:!0,readOnly:!0},readonly:{type:"boolean",value:!1},required:{type:"boolean",value:!1},resizeBehavior:{type:"string",enumValues:["both","horizontal","none","vertical"],value:"none"},rows:{type:"number",extension:{_COPY_TO_INNER_ELEM:!0}},translations:{type:"object",value:{},properties:{accessibleMaxLengthExceeded:{type:"string"},accessibleMaxLengthRemaining:{type:"string"},regexp:{type:"object",properties:{messageDetail:{type:"string"},messageSummary:{type:"string"}}},required:{type:"object",properties:{hint:{type:"string"},messageDetail:{type:"string"},messageSummary:{type:"string"}}}}},userAssistanceDensity:{type:"string",enumValues:["compact","efficient","reflow"],value:"reflow"},valid:{type:"string",writeback:!0,enumValues:["invalidHidden","invalidShown","pending","valid"],readOnly:!0},validators:{type:"Array<Object>",value:[]},value:{type:"any",writeback:!0}},methods:{getProperty:{},refresh:{},reset:{},setProperties:{},setProperty:{},showMessages:{},validate:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojAnimateEnd:{},ojAnimateStart:{}},extension:{}};n.extension._WIDGET_NAME="ojTextArea",n.extension._INNER_ELEM="textarea",n.extension._GLOBAL_TRANSFER_ATTRS=["accesskey","aria-label","tabindex","autocapitalize"],n.extension._ALIASED_PROPS={readonly:"readOnly"},s.CustomElementBridge.register("oj-text-area",{metadata:s.CollectionUtils.mergeDeep(n,e)})}(),s.__registerWidget("oj.inputBase",t.oj.editableValue,{version:"1.0.0",widgetEventPrefix:"oj",_ATTR_CHECK:[],_CLASS_NAMES:"",_WIDGET_CLASS_NAMES:"",_ELEMENT_TRIGGER_WRAPPER_CLASS_NAMES:"",_GET_INIT_OPTIONS_PROPS_FOR_WIDGET:[{attribute:"disabled",validateOption:!0},{attribute:"pattern"},{attribute:"placeholder"},{attribute:"value"},{attribute:"readonly",option:"readOnly",validateOption:!0},{attribute:"required",coerceDomValue:!0,validateOption:!0},{attribute:"title"},{attribute:"spellcheck"}],_INPUT_HELPER_KEY:"",_BLUR_HANDLER_KEY:"blur",_KEYDOWN_HANDLER_KEY:"keydown",_KEYUP_HANDLER_KEY:"keyup",_COMPOSITIONSTART_HANDLER_KEY:"compositionstart",_COMPOSITIONEND_HANDLER_KEY:"compositionend",_INPUT_HANDLER_KEY:"input",_DROP_HANDLER_KEY:"drop",_CLICK_HANDLER_KEY:"click",_TEXT_FIELD_COUNTER_CLASS:"oj-text-field-counter",_TEXT_FIELD_HIDDEN_ARIA_LIVE_CLASS:"oj-text-field-hidden-aria-live",_TEXT_FIELD_MAX_LENGTH_REMAINING_KEY:"accessibleMaxLengthRemaining",_TEXT_FIELD_MAX_LENGTH_EXCEEDED_KEY:"accessibleMaxLengthExceeded",_counterSpanEl:null,_ariaLiveTimer:null,options:{asyncValidators:[],autocomplete:void 0,autofocus:!1,labelledBy:null,name:"",placeholder:"",rawValue:void 0,readOnly:!1,required:!1,validators:[]},_SaveAttributes:function(e){var t=this._superApply(arguments);return this._processAttrCheck(),t},_InitOptions:function(e,t){this._super(e,t),this._IsCustomElement()||n.EditableValueUtils.initializeOptionsFromDom(this._GET_INIT_OPTIONS_PROPS_FOR_WIDGET,t,this)},_ComponentCreate:function(){var e=this._superApply(arguments),i=this.options.readOnly;if(this._rtl="rtl"===this._GetReadingDirection(),this._isAndroidDevice=s.AgentUtils.getAgentInfo().os===s.AgentUtils.OS.ANDROID,"boolean"==typeof i&&this.element.prop("readonly",i),this._DoWrapElement()){var n,r;if(this.OuterWrapper?(n=this.OuterWrapper).className?n.className=n.className+" "+this._WIDGET_CLASS_NAMES:n.className=this._WIDGET_CLASS_NAMES:((n=document.createElement("div")).className=this._WIDGET_CLASS_NAMES,this.element[0].parentNode&&this.element[0].parentNode.insertBefore(n,this.element[0])),r=n,this._wrapper=t(n),this._DoWrapElementAndTriggers()){var o=this._CreateContainerWrapper();n.appendChild(o),r=o;var l=this._CreateMiddleWrapper();l&&(o.appendChild(l),r=l)}r.appendChild(this.element[0]),this._focusable({element:this._wrapper,applyHighlight:!0})}else this._focusable({element:this.element,applyHighlight:!0});return this._CLASS_NAMES&&(this.element.addClass(this._CLASS_NAMES),this.element.addClass("oj-text-field-input")),this._defaultRegExpValidator={},this._eventHandlers=null,this._hasMaxLength()&&(this.lengthFilter=new a(this.options.length)),e},_AfterCreate:function(){var e=this._superApply(arguments),i=["disabled","readOnly"],n=this;if(this._refreshRequired(this.options.required),this._attachDetachEventHandlers(),this._AppendInputHelper(),this._AppendAriaLiveHelper(),t.each(i,function(e,t){n.options[t]&&n._processOptions(t,n.options[t])}),this._IsCustomElement()){let e=this.options.labelledBy;this._initLabelledByForInputBase(e)}return this._hasMaxLength()&&this._processLengthCounterAttr(this.options.length.counter),e},_IsRequired:function(){return this.options.required},_AfterSetOptionRequired:n.EditableValueUtils._AfterSetOptionRequired,_AfterSetOptionValidators:n.EditableValueUtils._AfterSetOptionValidators,_AfterSetOptionAsyncValidators:n.EditableValueUtils._AfterSetOptionAsyncValidators,_AfterSetOptionConverter:n.EditableValueUtils._AfterSetOptionConverter,_ResetConverter:n.EditableValueUtils._ResetConverter,_GetConverter:n.EditableValueUtils._GetConverter,_GetNormalizedValidatorsFromOption:n.EditableValueUtils._GetNormalizedValidatorsFromOption,_GetNormalizedAsyncValidatorsFromOption:n.EditableValueUtils._GetNormalizedAsyncValidatorsFromOption,_SetDisplayValue:function(e){if(this._superApply(arguments),this.options.readOnly){let t=this._getReadonlyDiv();t&&(t.textContent=e)}},_createOrUpdateReadonlyDiv:n.EditableValueUtils._createOrUpdateReadonlyDiv,_processOptions:function(e,t){"disabled"===e&&this.element.prop("disabled",t),"readOnly"===e&&(this.element.prop("readonly",t),t&&this._createOrUpdateReadonlyDiv(this.element[0],this._DoWrapElement()&&this.OuterWrapper),this._refreshStateTheming("readOnly",t)),"disabled"!==e&&"readOnly"!==e||this._attachDetachEventHandlers()},_setOption:function(e,t,i){const n=this.options[e];var s=this._superApply(arguments);switch(e){case"disabled":case"readOnly":this._processOptions(e,t);break;case"pattern":this._defaultRegExpValidator.regexp=this._getImplicitRegExpValidator(),this._AfterSetOptionValidators();break;case"labelledBy":this._setLabelledByForInputBase(n,t)}return s},_AfterSetOption:function(e,t,i){switch(this._superApply(arguments),e){case"readOnly":this._AfterSetOptionDisabledReadOnly(e,n.EditableValueUtils.readOnlyOptionOptions);break;case"required":this._AfterSetOptionRequired(e);break;case"validators":this._AfterSetOptionValidators(e);break;case"asyncValidators":this._AfterSetOptionAsyncValidators(e);break;case"converter":this._AfterSetOptionConverter(e);break;case"length":this._AfterSetOptionLength(this.options.length)}},_hasMaxLength:function(){return this.options.length&&this.options.length.max&&!isNaN(this.options.length.max)},_setLabelledByForInputBase:function(e,t){if(t){const e=this._GetContentElement()[0].id;this._labelledByUpdatedForInputComp(t,e)}},_initLabelledByForInputBase:function(e){this._initInputIdLabelForConnection(this._GetContentElement()[0],this.widget()[0].id,e)},_filterTextOnValueChange:function(){if(this.options.length.max){var e=this.options.rawValue,t=this.options.value;this._filterTextAndSetValues(e,t,!0,!1)}},_destroy:function(){var e=this._superApply(arguments);return this.element.off("blur drop keydown keyup compositionstart compositionend input"),this._inputHelper&&this._inputHelper.remove(),this._DoWrapElement()&&!this._IsCustomElement()&&(this._DoWrapElementAndTriggers()?r.unwrap(this.element,this._wrapper):r.unwrap(this.element)),e},_SetLoading:function(){this._super(),this.element.prop("readonly",!0)},_ClearLoading:function(){this._super(),this.element.prop("readonly",this.options.readOnly)},_attachDetachEventHandlers:function(){if(this.options.readOnly||this.options.disabled){if(this._eventHandlers)for(var e=[this._BLUR_HANDLER_KEY,this._KEYDOWN_HANDLER_KEY,this._KEYUP_HANDLER_KEY,this._COMPOSITIONSTART_HANDLER_KEY,this._COMPOSITIONEND_HANDLER_KEY,this._INPUT_HANDLER_KEY,this._DROP_HANDLER_KEY],i=0,n=e.length;i<n;i++)this._eventHandlers[e[i]]&&(this.element.off(e[i],this._eventHandlers[e[i]]),delete this._eventHandlers[e[i]])}else{this._eventHandlers={};var s=t.proxy(this._onBlurHandler,this),r=t.proxy(this._onKeyDownHandler,this),a=t.proxy(this._onKeyUpHandler,this),o=t.proxy(this._onCompositionStartHandler,this),l=t.proxy(this._onCompositionEndHandler,this),p=t.proxy(this._onInputHandler,this),_=function(){this.focus()};this.element.on(this._BLUR_HANDLER_KEY,s),this.element.on(this._KEYDOWN_HANDLER_KEY,r),this.element.on(this._KEYUP_HANDLER_KEY,a),this.element.on(this._COMPOSITIONSTART_HANDLER_KEY,o),this.element.on(this._COMPOSITIONEND_HANDLER_KEY,l),this.element.on(this._INPUT_HANDLER_KEY,p),this.element.on(this._DROP_HANDLER_KEY,_),this._eventHandlers[this._BLUR_HANDLER_KEY]=s,this._eventHandlers[this._KEYDOWN_HANDLER_KEY]=r,this._eventHandlers[this._KEYUP_HANDLER_KEY]=a,this._eventHandlers[this._COMPOSITIONSTART_HANDLER_KEY]=o,this._eventHandlers[this._COMPOSITIONEND_HANDLER_KEY]=l,this._eventHandlers[this._INPUT_HANDLER_KEY]=p,this._eventHandlers[this._DROP_HANDLER_KEY]=_}},_OPTION_TO_CSS_MAPPING:{readOnly:"oj-read-only"},_processAttrCheck:function(){for(var e=this._ATTR_CHECK,t=0,i=e.length;t<i;t++){var n=e[t].attr;"setMandatory"in e[t]&&this.element.attr(n,e[t].setMandatory)}},_onBlurHandler:function(e){this._SetValue(this._GetDisplayValue(),e)},_onKeyDownHandler:function(e){},_onKeyUpHandler:function(e){e.keyCode===t.ui.keyCode.ENTER&&this._SetValue(this._GetDisplayValue(),e)},_onCompositionStartHandler:function(){this._isComposing=!0},_onCompositionEndHandler:function(e){this._isComposing=!1,this._SetRawValue(this._GetContentElement().val(),e),this._hasMaxLength()&&this._onInputHandler(e)},_onInputHandler:function(e){if(!this._isComposing||this._isAndroidDevice)if(this._hasMaxLength()){var t=this._GetContentElement().val();this._filterTextAndSetValues(t,t,!1,!0)}else this._SetRawValue(this._GetContentElement().val(),e)},_DoWrapElement:function(){return this._WIDGET_CLASS_NAMES},_DoWrapElementAndTriggers:function(){return this._ELEMENT_TRIGGER_WRAPPER_CLASS_NAMES},_CreateContainerWrapper:function(){var e=document.createElement("div");return e.setAttribute("role","presentation"),e.className=this._ELEMENT_TRIGGER_WRAPPER_CLASS_NAMES,e},_AppendInputHelper:function(){if(this._INPUT_HELPER_KEY&&this._DoWrapElement()){var e=this.element.attr("aria-describedby")||"",i=this._GetSubId(this._INPUT_HELPER_KEY);e+=" "+i,this.element.attr("aria-describedby",e),this._inputHelper=t("<div class='oj-helper-hidden-accessible' aria-hidden='true' id='"+i+"'>"+this._EscapeXSS(this.getTranslatedString(this._INPUT_HELPER_KEY))+"</div>"),this._AppendInputHelperParent().append(this._inputHelper)}},_AppendAriaLiveHelper:function(){var e=this._AppendInputHelperParent();if(this.options.length&&this.options.length.max){var t=document.createElement("div");t.classList.add("oj-helper-hidden-accessible"),t.classList.add(this._TEXT_FIELD_HIDDEN_ARIA_LIVE_CLASS);var i=document.createElement("div");i.setAttribute("aria-live","polite");var n=document.createElement("div");n.setAttribute("aria-live","assertive"),t.appendChild(i),t.appendChild(n),e[0].appendChild(t)}},_EscapeXSS:function(e){return t("<span>"+e+"</span>").text()},_AppendInputHelperParent:function(){return this.widget()},_GetImplicitValidators:function(){var e=this._superApply(arguments);if(this.options.pattern){var t=this._getImplicitRegExpValidator();this._defaultRegExpValidator.regexp=t}return Object.assign(this._defaultRegExpValidator,e)},_CanSetValue:function(){return!!this._super()&&!(this.options.readOnly||!1)},_refreshStateTheming:function(e,t){-1!==Object.keys(this._OPTION_TO_CSS_MAPPING).indexOf(e)&&this.widget().toggleClass(this._OPTION_TO_CSS_MAPPING[e],!!t)},_getImplicitRegExpValidator:function(){if(!this.options.pattern)return null;var e={pattern:this.options.pattern,label:this._getLabelText()};return t.extend(e,this.options.translations.regexp||{}),new o(e)},_GetAriaLabelElement:function(){return this.element[0]},_GetSubId:function(e){return this.uuid+"_"+e},_IsRTL:function(){return this._rtl},_IsTextFieldComponent:function(){return!0},_GetContentWrapper:function(){var e=this._GetContentElement()[0];if(!e.parentElement.classList.contains("oj-text-field-middle")){var t=document.createElement("DIV");t.classList.add("oj-text-field-middle"),e.parentElement.insertBefore(t,e),t.appendChild(e)}return e.parentElement},_resetLengthFilter:function(e){this.lengthFilter=new a(e)},_AfterSetOptionLength:function(e){var t;e.max&&(this._resetLengthFilter(e),t=this._GetContentWrapper().parentElement.parentNode.classList.contains("oj-complete")?this.element[0].value:this.options.value,this._filterTextAndSetValues(t,t,!0,!1));this._processLengthCounterAttr(e.counter)},_setFocusOnTextAreaBind:function(){this._setFocusOnTextArea=function(){this.element[0].focus()}.bind(this)},_processLengthCounterAttr:function(e){var t=this._GetContentWrapper().parentElement,i=t.querySelector("."+this._TEXT_FIELD_COUNTER_CLASS),n=t.parentNode.querySelector("."+this._TEXT_FIELD_HIDDEN_ARIA_LIVE_CLASS),s=this.lengthFilter?this.lengthFilter.calcLength(this.options.rawValue):-1,r="",a="";if("none"===e||null==e||0===this.options.length.max||this.options.disabled||this.options.readOnly)i&&(i.removeEventListener(this._CLICK_HANDLER_KEY,this._setFocusOnTextArea),t.removeChild(i)),this._counterSpanEl=null,-1===s||0===this.options.length.max||this.options.disabled||this.options.readOnly?a="":(r=this.options.length.max-s,a=this.getTranslatedString(this._TEXT_FIELD_MAX_LENGTH_REMAINING_KEY,{chars:r}));else{if(null===i){var o=document.createElement("div");o.className=this._TEXT_FIELD_COUNTER_CLASS,this._TEXTAREA_COUNTER_CONTAINER&&(o.className+=" "+this._TEXTAREA_COUNTER_CONTAINER),i=document.createElement("span"),this._INPUTTEXT_COUNTER_EL&&(i.className+=" "+this._INPUTTEXT_COUNTER_EL),this._TEXTAREA_COUNTER_EL&&(i.className+=" "+this._TEXTAREA_COUNTER_EL,this._setFocusOnTextAreaBind(),o.addEventListener(this._CLICK_HANDLER_KEY,this._setFocusOnTextArea)),o.appendChild(i),t.appendChild(o),this._counterSpanEl=i,this._counterSpanEl.textContent=""}-1!==s&&(r=this.options.length.max-s,a=this.getTranslatedString(this._TEXT_FIELD_MAX_LENGTH_REMAINING_KEY,{chars:r}))}this._counterSpanEl&&(this._counterSpanEl.textContent=r),n&&(this._ariaLiveTimer&&clearTimeout(this._ariaLiveTimer),this._ariaLiveTimer=setTimeout(()=>{n.children[0].textContent=a,this._ariaLiveTimer=null},500))},_filterTextAndSetValues(e,t,i,n){var s=this.lengthFilter.filter(e,t);this._SetRawValue(s,null),this._SetDisplayValue(s,null);var r=this._GetContentWrapper().parentElement.parentNode.querySelector("."+this._TEXT_FIELD_HIDDEN_ARIA_LIVE_CLASS);if(r){var a=r.children[1];(s?s.length:0)<(t?t.length:0)?(a.textContent="",a.textContent=this.getTranslatedString(this._TEXT_FIELD_MAX_LENGTH_EXCEEDED_KEY,{len:this.options.length.max})):this.lastFilteredText!==t&&(a.textContent="")}this.lastFilteredText=s,i&&this._SetValue(this.lastFilteredText),n&&this._processLengthCounterAttr(this.options.length.counter)},refresh:function(){var e=this._superApply(arguments);return this._rtl="rtl"===this._GetReadingDirection(),this._refreshRequired(this.options.required),e},_refreshRequired:n.EditableValueUtils._refreshRequired,_labelledByUpdatedForInputComp:n.EditableValueUtils._labelledByUpdatedForInputComp,_initInputIdLabelForConnection:n.EditableValueUtils._initInputIdLabelForConnection,_linkLabelForInputComp:n.EditableValueUtils._linkLabelForInputComp,_ValidateReturnBoolean:n.EditableValueUtils._ValidateReturnBoolean,_ValidateReturnPromise:n.EditableValueUtils._ValidateReturnPromise,getNodeBySubId:function(e){return this._super(e)},validate:n.EditableValueUtils.validate,_AriaRequiredUnsupported:function(){return!1},widget:function(){return this._DoWrapElement()?this._wrapper:this.element}},!0),s.__registerWidget("oj.ojInputPassword",t.oj.inputBase,{version:"1.0.0",defaultElement:"<input>",widgetEventPrefix:"oj",_ATTR_CHECK:[{attr:"type",setMandatory:"password"}],_CLASS_NAMES:"oj-inputpassword-input",_WIDGET_CLASS_NAMES:"oj-inputpassword oj-form-control oj-component",_INPUT_CONTAINER_CLASS:"oj-text-field-container",_MASK_ICON_SHOW_PASSWORD_LABEL_KEY:"accessibleShowPassword",_MASK_ICON_HIDE_PASSWORD_LABEL_KEY:"accessibleHidePassword",options:{converter:null,maskIcon:"hidden",pattern:"",value:void 0},_ComponentCreate:function(){var e=this._super();return this._processMaskVisibilityIcon(),e},_processMaskVisibilityIcon:function(){var e=this._GetContentWrapper().parentElement,i=this.element[0],n=e.querySelector("span.oj-text-field-end");if(this.options.disabled||this.options.readOnly)n&&(e.removeChild(n),i.type="password");else if(null===n){if("visible"===this.options.maskIcon){var s,r;(n=document.createElement("span")).className="oj-text-field-end",(r=document.createElement("a")).className="oj-component-icon oj-clickable-icon-nocontext",r.setAttribute("aria-label",this.getTranslatedString(this._MASK_ICON_SHOW_PASSWORD_LABEL_KEY)),r.role="button",r.setAttribute("target","_blank"),r.setAttribute("tabindex","0"),(s=document.createElement("span")).className="oj-inputpassword-show-password-icon",r.appendChild(s),n.appendChild(r),e.appendChild(n);var a=t(r);this._AddHoverable(a),this._AddActiveable(a),r.addEventListener(this._CLICK_HANDLER_KEY,this._onMaskVisibilityIconClickHandler.bind(this)),r.addEventListener(this._KEYDOWN_HANDLER_KEY,this._onMaskVisibilityIconKeyDownHandler.bind(this))}}else"visible"!==this.options.maskIcon&&(e.removeChild(n),i.type="password")},_onMaskVisibilityIconClickHandler:function(){var e=this.element[0],t=this._GetContentWrapper().parentElement.querySelector("a.oj-component-icon"),i=t.children[0];"password"===e.type?(e.type="text",i.classList.remove("oj-inputpassword-show-password-icon"),i.classList.add("oj-inputpassword-hide-password-icon"),t.setAttribute("aria-label",this.getTranslatedString(this._MASK_ICON_HIDE_PASSWORD_LABEL_KEY))):(e.type="password",i.classList.remove("oj-inputpassword-hide-password-icon"),i.classList.add("oj-inputpassword-show-password-icon"),t.setAttribute("aria-label",this.getTranslatedString(this._MASK_ICON_SHOW_PASSWORD_LABEL_KEY)))},_onMaskVisibilityIconKeyDownHandler:function(e){if(!e.altKey&&!e.ctrlKey){var i=t.ui.keyCode;switch(e.keyCode){case i.SPACE:case i.ENTER:this._onMaskVisibilityIconClickHandler()}}},_AfterSetOption:function(e,t){switch(this._super(e,t),e){case"disabled":case"readOnly":case"maskIcon":this._processMaskVisibilityIcon()}},_DoWrapElementAndTriggers:function(){return this._ELEMENT_TRIGGER_WRAPPER_CLASS_NAMES=this._INPUT_CONTAINER_CLASS,!0},_UseReadonlyDiv:function(){return!1},getNodeBySubId:function(e){var t=this._superApply(arguments);return t||"oj-inputpassword-input"===e.subId&&(t=this.element?this.element[0]:null),t||null},_GetDefaultStyleClass:function(){return"oj-inputpassword"}}),s.__registerWidget("oj.ojInputText",t.oj.inputBase,{version:"1.0.0",defaultElement:"<input>",widgetEventPrefix:"oj",_ATTR_CHECK:[{attr:"type",setMandatory:"text"}],_CLASS_NAMES:"oj-inputtext-input",_WIDGET_CLASS_NAMES:"oj-inputtext oj-form-control oj-component",_ALLOWED_TYPES:["email","number","search","tel","text","url"],_CLICK_HANDLER_KEY:"click",_INPUT_CONTAINER_CLASS:"oj-text-field-container",_INPUTTEXT_COUNTER_EL:"oj-inputtext-counter-el",options:{clearIcon:"never",converter:null,list:"",pattern:"",virtualKeyboard:"auto",length:{max:null,countBy:"codePoint"}},_ComponentCreate:function(){var e=this._super(),t=this.options.clearIcon;return this._processClearIconAttr(t),this._processSlottedChildren(),this._AddHoverable(this._wrapper),this._SetInputType(this._ALLOWED_TYPES),e},_DoWrapElementAndTriggers:function(){return this._ELEMENT_TRIGGER_WRAPPER_CLASS_NAMES=this._INPUT_CONTAINER_CLASS,!0},_processClearIconAttr:function(e){var t=this._GetContentWrapper().parentElement,i=t.querySelector("a.oj-inputtext-clear-icon-btn");if("never"===e||this.options.disabled||this.options.readOnly)i&&t.removeChild(i),t.classList.remove("oj-inputtext-clearicon-visible"),t.classList.remove("oj-inputtext-clearicon-conditional");else{if(null===i){var n,r=s.AgentUtils.getAgentInfo();(i=document.createElement("a")).className="oj-inputtext-clear-icon-btn oj-component-icon oj-clickable-icon-nocontext",i.setAttribute("tabindex","-1"),r.os===s.AgentUtils.OS.ANDROID||r.os===s.AgentUtils.OS.IOS||r.os===s.AgentUtils.OS.WINDOWSPHONE?i.setAttribute("aria-label","Clear input"):i.setAttribute("aria-hidden","true"),i.setAttribute("target","_blank"),(n=document.createElement("span")).className="oj-inputtext-clear-icon",i.appendChild(n),t.appendChild(i),i.addEventListener(this._CLICK_HANDLER_KEY,this._onClearIconClickHandler.bind(this))}var a;if("always"===e)t.classList.add("oj-inputtext-clearicon-visible");else t.classList.remove("oj-inputtext-clearicon-visible"),t.classList.add("oj-inputtext-clearicon-conditional"),(a=t.classList.contains("oj-complete")?this.element[0].value:this.options.value)&&""!==a?t.classList.remove("oj-form-control-empty-clearicon"):t.classList.add("oj-form-control-empty-clearicon")}},_processSlottedChildren:function(){var e=l.CustomElementUtils.getSlotMap(this._getRootElement());!function(e){for(var t={contextMenu:!0,start:!0,end:!0,"":!0},i=Object.keys(e),n=i.length-1;n>-1;n--){var s=i[n];if(!t[s])for(var r=e[s],a=0;a<r.length;a++){var o=r[a];o.parentElement.removeChild(o)}}}(e);var t=this._GetContentWrapper(),i="start";e[i]&&function(e,t){var i=document.createElement("span"),n=e.parentElement;i.classList.add("oj-text-field-start"),n.insertBefore(i,e),n.classList.add("oj-text-field-has-start-slot");for(var s=0;s<t.length;s++){var r=t[s];i.appendChild(r)}}(t,e[i]),e[i="end"]&&function(e,t){var i=document.createElement("span"),n=e.parentElement;i.classList.add("oj-text-field-end"),n.appendChild(i),n.classList.add("oj-text-field-has-end-slot");for(var s=0;s<t.length;s++){var r=t[s];i.appendChild(r)}}(t,e[i])},_AfterSetOption:function(e,t){switch(this._super(e,t),e){case"clearIcon":case"disabled":case"readOnly":this._processClearIconAttr(this.options.clearIcon);break;case"virtualKeyboard":this._SetInputType(this._ALLOWED_TYPES);break;case"value":this._processClearIconAttr(this.options.clearIcon),this._filterTextOnValueChange(),this._AfterSetOptionLength(this.options.length)}},_onInputHandler:function(e){this._super(e);var t=e.target,i=this._GetContentWrapper().parentElement;"conditional"===this.options.clearIcon&&(""!==t.value?i.classList.remove("oj-form-control-empty-clearicon"):i.classList.add("oj-form-control-empty-clearicon"))},_onClearIconClickHandler:function(e){var t=this.element[0];t.value="",this._SetRawValue(t.value,e),t.focus(),this._GetContentWrapper().parentElement.classList.add("oj-form-control-empty-clearicon"),this._processLengthCounterAttr(this.options.length.counter)},_onBlurHandler:function(e){var t=this._wrapper[0],i=e.relatedTarget;i&&i.classList.contains("oj-inputtext-clear-icon-btn")&&i.parentElement&&r.isAncestorOrSelf(t,i.parentElement)?t.classList.add("oj-focus"):this._super(e)},getNodeBySubId:function(e){var t=this._superApply(arguments);return t||"oj-inputtext-input"===e.subId&&(t=this.element?this.element[0]:null),t||null},_GetDefaultStyleClass:function(){return"oj-inputtext"},_GetTranslationsSectionName:function(){return"oj-inputBase"},_SetInputType:n.EditableValueUtils._SetInputType}),s.__registerWidget("oj.ojTextArea",t.oj.inputBase,{version:"1.0.0",defaultElement:"<textarea>",widgetEventPrefix:"oj",_ATTR_CHECK:[],_CLASS_NAMES:"oj-textarea-input",_WIDGET_CLASS_NAMES:"oj-textarea oj-form-control oj-component",_INPUT_CONTAINER_CLASS:"oj-text-field-container",_TEXTAREA_COUNTER_CONTAINER:"oj-textarea-counter-container",_TEXTAREA_COUNTER_EL:"oj-textarea-counter-el",_INPUT_HANDLER_KEY:"input",options:{converter:null,maxRows:0,pattern:"",resizeBehavior:"none",rows:void 0,length:{max:null,countBy:"codePoint",counter:"none"}},_AfterSetOption:function(e,t){switch(this._super(e,t),e){case"value":this._filterTextOnValueChange(),this._AfterSetOptionLength(this.options.length)}},_AfterCreate:function(){var e=this._superApply(arguments);void 0===this.options.value&&this._SetDisplayValue(""),this.widget()[0].querySelector("."+this._INPUT_CONTAINER_CLASS).style.resize=this.options.resizeBehavior,this._setupResizeTextareaBind();var t=this.options.maxRows;return-1===t&&this.widget()[0].classList.add("oj-maxrows-neg1"),e},_AfterCreateConverterCached:function(){var e=this._super(),t=this._GetContentElement()[0],i=this.options.maxRows;return!this._textAreaElementNotDisplayed()&&(-1===i||i>t.rows)&&(this._calculateLineHeight(t),this._resizeTextArea()),e},_setOption:function(e,t,i){var n=this._superApply(arguments);if("resizeBehavior"===e)this.widget()[0].querySelector("."+this._INPUT_CONTAINER_CLASS).style.resize=t;else if("value"===e){let e=this._textAreaElementNotDisplayed(),t=this.options.maxRows;!e&&(-1===t||t>this._GetContentElement()[0].rows)&&this._resizeTextArea()}return n},_NotifyAttached:function(){this._super();var e=this.options.maxRows;(-1===e||e>this._GetContentElement()[0].rows)&&this._resizeTextArea()},_onInputHandler:function(e){this._super(e);var t=this._GetContentElement()[0],i=this.options.maxRows;(-1===i||i>t.rows)&&this._resizeTextArea()},_resizeTextArea:function(){if(this._textAreaElementNotDisplayed()||void 0===this._lineHeight)return;const e=this.options.maxRows,t=this._GetContentElement()[0],i=t.rows;t.style.height=0;const n=this._getStylingHeight(t,"padding"),s=this._lineHeight*i+n,r=t.scrollHeight;var a=0;if(-1===e)a=r<s?s:r;else if(e>i){var o=this._lineHeight*e+n;a=r>o?o:r<s?s:r}else a=s;t.style.height=a+"px"},_setupResizeTextareaBind:function(){this._textAreaElementNotDisplayed()||(this._resizeTextareaBind=function(){var e=this._GetContentElement()[0],t=this.options.maxRows;(-1===t||t>e.rows)&&this._resizeTextArea()}.bind(this),window.addEventListener("resize",this._resizeTextareaBind,!1))},_getStylingHeight:function(e,t){var i=window.getComputedStyle(e),n=0;"padding"!==t&&"paddingAndBorder"!==t||(n+=parseFloat(i.paddingTop)+parseFloat(i.paddingBottom));"border"!==t&&"paddingAndBorder"!==t||(n+=parseFloat(i.borderTopWidth)+parseFloat(i.borderBottomWidth));return n},_calculateLineHeight:function(e){if(!this._textAreaElementNotDisplayed()){var t=window.getComputedStyle(e);if("none"!==t.display){var i=t.lineHeight;switch(i){case"normal":var n=parseFloat(t.fontSize);this._lineHeight=1.2*n;break;default:this._lineHeight=parseFloat(i)}}}},_cleanUpListeners:function(){this._resizeTextareaBind&&window.removeEventListener("resize",this._resizeTextareaBind)},_ReleaseResources:function(){this._super(),this._cleanUpListeners()},getNodeBySubId:function(e){var t=this._superApply(arguments);return t||"oj-textarea-input"===e.subId&&(t=this.element?this.element[0]:null),t||null},_DoWrapElementAndTriggers:function(){return this._ELEMENT_TRIGGER_WRAPPER_CLASS_NAMES=this._INPUT_CONTAINER_CLASS,!0},_UseReadonlyDiv:function(){var e=this._super();return e?-1===this.options.maxRows:e},_GetDefaultStyleClass:function(){return"oj-textarea"},_GetTranslationsSectionName:function(){return"oj-inputBase"},_isConverAsync:function(){return this._GetConverter()instanceof Promise},_onKeyUpHandler:function(e){},_onKeyDownHandler:function(e){if((13===e.keyCode||"Enter"===e.key)&&e.altKey){var t=this._GetContentElement()[0],i=t.value,n=i.substring(0,t.selectionStart),s=i.substring(t.selectionEnd);t.value=n+"\r\n"+s;var r=t.value.length-s.length;t.setSelectionRange(r,r),t.blur(),t.focus();var a=this.options.maxRows;(-1===a||a>t.rows)&&this._resizeTextArea(),e.stopPropagation()}},_textAreaElementNotDisplayed:function(){return this._UseReadonlyDiv()&&this.options.readOnly&&-1===this.options.maxRows}})});
//# sourceMappingURL=ojinputtext.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojchildmutationobserver',["ojs/ojcustomelement","ojs/ojcustomelement-utils"],function(e,t){"use strict";return function(e,n){var r=e,o=n,s=t.CustomElementUtils.isElementRegistered(e.tagName)?t.CustomElementUtils.getElementState(e).getTrackChildrenOption():"none",i=function(e){var n=function(e){for(var n=[],o=0;o<e.length;o++)for(var i=e[o],l="childList"===i.type?i.target:i.target.parentNode;l;)l===r?(n.push(i),l=null):l="nearestCustomElement"!==s||t.ElementUtils.isValidCustomElementName(l.localName)?null:l.parentNode;return n}(e);n.length>0&&o(n)},l=new MutationObserver(i);return{observe:function(){"none"!==s&&l.observe(r,{attributes:!0,childList:!0,subtree:!0,characterData:!0})},disconnect:function(){var e=l.takeRecords();e&&e.length>0&&i(e),l.disconnect()}}}});
//# sourceMappingURL=ojchildmutationobserver.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojmenu',["jquery","ojs/ojjquery-hammer","ojs/ojpopupcore","ojs/ojoption","ojs/ojcore-base","hammerjs","ojs/ojcontext","ojs/ojthemeutils","ojs/ojcomponentcore","ojs/ojanimation","ojs/ojlogger","ojs/ojconfig","ojs/ojcustomelement-utils"],function(e,t,i,n,s,o,r,a,l,u,c,h,m){"use strict";var d;e=e&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e,s=s&&Object.prototype.hasOwnProperty.call(s,"default")?s.default:s,r=r&&Object.prototype.hasOwnProperty.call(r,"default")?r.default:r,function(){var t=[],n=!1,d="oj-menu-position";const p={dropdown:{open:"--oj-private-menu-global-drop-down-open-animation",close:"--oj-private-menu-global-drop-down-close-animation"},sheet:{open:"--oj-private-menu-global-sheet-open-animation",close:"--oj-private-menu-global-sheet-close-animation"},submenu:{open:"--oj-private-menu-global-submenu-open-animation",close:"--oj-private-menu-global-submenu-close-animation"}};var f=s.AgentUtils.getAgentInfo().os===s.AgentUtils.OS.MAC&&s.AgentUtils.getAgentInfo().browser===s.AgentUtils.BROWSER.SAFARI,_="menuItem"===a.getCachedCSSVarValues(["--oj-private-menu-global-sheet-cancel-affordance"])[0],v="dismiss"===a.getCachedCSSVarValues(["--oj-private-menu-global-sheet-swipe-down-behavior"])[0],g=a.getCachedCSSVarValues(["--oj-private-menu-global-drop-down-modality"])[0]||"modeless",b=a.getCachedCSSVarValues(["--oj-private-menu-global-sheet-modality"])[0]||"modal",O="bottom-"+(a.getCachedCSSVarValues(["oj-private-menu-global-sheet-margin-bottom"])[0]||0),j=v&&{recognizers:[[o.Swipe,{direction:o.DIRECTION_HORIZONTAL}]]};const y=-(.5*parseInt(window.getComputedStyle(document.documentElement).fontSize,10)+1);function S(t){var i,n=[],s=t.children("oj-defer").first();i=s.length>0?s.children(".oj-menu-item, oj-menu-select-many"):t.children(".oj-menu-item, oj-menu-select-many");for(var o=0;o<i.length;o++){var r=e(i[o]);r.is(".oj-menu-item")?n.push(r[0]):"OJ-MENU-SELECT-MANY"===r[0].nodeName&&(n=e.merge(n,r.children(".oj-menu-item")))}return n}s.__registerWidget("oj.ojMenu",e.oj.baseComponent,{defaultElement:"<ul>",delay:300,role:"menu",widgetEventPrefix:"oj",options:{menuSelector:"ul",openOptions:{display:"auto",initialFocus:"menu",launcher:null,position:{my:{horizontal:"start",vertical:"top"},offset:{x:0,y:0},at:{horizontal:"start",vertical:"bottom"},of:void 0,collision:"flipfit"}},submenuOpenOptions:{position:{my:"start top",at:"end top",collision:"flipfit"}},animateStart:null,animateEnd:null,beforeOpen:null,close:null,open:null,action:null,menuAction:null},_ComponentCreate:function(){if(this._super(),this._focusForTesting=this._focus,this._nextForTesting=this._next,this._selectForTesting=this._select,this._IsCustomElement()){this.element.hide();var e=this.options;e.openOptions.position=s.PositionUtils.coerceToJet(e.openOptions.position);var t=this.element[0].querySelector("oj-defer");t&&t.setAttribute("data-oj-context",!0)}else this._createAsTopLevelMenu()},_preventDefault:function(e){this.options.disabled&&e.preventDefault()},_createAsTopLevelMenu:function(){var t=this;this.activeMenu=this.element,this.mouseHandled=!1,this._setupSwipeBehavior(),this.element.uniqueId().addClass("oj-menu oj-component").hide().attr({role:this.role,tabIndex:"0","aria-hidden":"true"}),this._on(!0,{"mousedown .oj-menu-item":this._preventDefault,click:this._preventDefault,keydown:function(t){this.options.disabled&&(t.keyCode!==e.ui.keyCode.ESCAPE&&t.keyCode!==e.ui.keyCode.TAB||(t.keyCode===e.ui.keyCode.TAB&&t.preventDefault(),this._focusLauncherAndDismiss(t)))}}),this.options.disabled&&this.element.addClass("oj-disabled").attr("aria-disabled","true");var i=function(t){if(!this.focusHandled){this.focusHandled=!0;var i=e(t.currentTarget);try{this._focusIsFromPointer=!0,this._focus(t,i)}finally{this._focusIsFromPointer=!1}}}.bind(this),n=function(t){e(t.target).is(":visible")&&this._collapse(t,"eventSubtree")}.bind(this);this._touchStartHandler=function(t){this.focusHandled=!1;var i=e(t.currentTarget);this._focus(t,i)}.bind(this),this.element[0].addEventListener("touchstart",this._touchStartHandler,{passive:!0}),this._delegatedHandleMouseEnterMenuItem=function(t){const n=t.currentTarget,s=t.target.closest(".oj-menu-item");s&&n.contains(s)&&i(e.Event(t,{currentTarget:s}))},this.element[0].addEventListener("touchstart",this._delegatedHandleMouseEnterMenuItem,{passive:!0}),this._on({"click .oj-disabled > a":function(e){e.preventDefault()},click:function(){this.mouseHandled=!1},mouseover:function(){this.focusHandled=!1},"click .oj-menu-item:has(a)":function(t){var i=e(t.target).closest(".oj-menu-item");if(!this.mouseHandled&&i.not(".oj-disabled").length){if(this.mouseHandled=!0,t.preventDefault(),this.active&&this.active.closest(i).length&&this.active.get(0)!==i.get(0))return;i.has(".oj-menu").length?this._expand(t):(this._select(t),this.element.is(":focus")||(this.element.trigger("focus",[!0]),this.active&&1===this.active.parents(".oj-menu").length&&this._clearTimer&&this._clearTimer()))}},"mouseenter .oj-menu-item":i,mouseleave:n,"mouseleave .oj-menu":n,focus:function(t,i){if(!(i||t.target===this.element[0]||this._focusSkipLink&&t.target===this._focusSkipLink.getLink()[0])){var n=this.active||e(S(this.element)).first(0);this._focus(t,n)}},keydown:this._keydown,keyup:function(t){t.keyCode!==e.ui.keyCode.ENTER&&t.keyCode!==e.ui.keyCode.SPACE||(this.__spaceEnterDownInMenu=!1)}}),this._focusable({applyHighlight:!f,recentPointer:function(){return t._focusIsFromPointer},setupHandlers:function(e,i){t._focusInHandler=e,t._focusOutHandler=i}}),this._usingCallback=e.proxy(this._usingHandler,this),this._setup()},_createAsSubmenu:function(){this.element.attr(l._OJ_CONTAINER_ATTR,this.widgetName),this.element.uniqueId().addClass("oj-menu oj-component oj-menu-submenu oj-menu-dropdown").hide().attr({role:this.role,tabIndex:"0","aria-hidden":"true"}),this._setup()},__contextMenuPressHoldJustEnded:function(e){if(!arguments.length)return n;n=e},_processOjOptions:function(){this._maxEndIconCount=0,this._maxStartIconCount=0,this._startIconWidth=0,this._endIconWidth=0;var t=function(t){var i,n=[],s=t.children("oj-defer").first();i=s.length>0?s.children("oj-option, oj-menu-select-many"):t.children("oj-option, oj-menu-select-many");for(var o=0;o<i.length;o++){var r=e(i[o]);"OJ-OPTION"===r[0].nodeName?n.push(r[0]):"OJ-MENU-SELECT-MANY"===r[0].nodeName&&(n=e.merge(n,r.children("oj-option")))}return e(n)}(this.element);this._clearOption(t);for(var i=0;i<t.length;i++){t[i].customOptionRenderer=this._customOptionRenderer.bind(this)}},_customOptionRenderer:function(t){function i(e){if(e.previousElementSibling&&"OJ-OPTION"===e.previousElementSibling.nodeName)return e.previousElementSibling;if(e.previousElementSibling&&"OJ-MENU-SELECT-MANY"===e.previousElementSibling.nodeName){var t=e.previousElementSibling.lastElementChild;return"OJ-OPTION"===t.nodeName?t:t.previousElementSibling?t.previousElementSibling:i(t)}return e.previousElementSibling||"OJ-MENU-SELECT-MANY"!==e.parentElement.nodeName?void 0:i(e.parentElement)}function n(e){return e.nextElementSibling&&"OJ-OPTION"===e.nextElementSibling.nodeName?e.nextElementSibling:e.nextElementSibling&&"OJ-MENU-SELECT-MANY"===e.nextElementSibling.nodeName?e.nextElementSibling.firstElementChild:e.nextElementSibling&&"OJ-OPTION"===e.nextElementSibling.nodeName||"OJ-MENU-SELECT-MANY"!==e.parentElement.nodeName?void 0:n(e.parentElement)}var s=e(t),o="OJ-MENU-SELECT-MANY"===s.parent().prop("nodeName"),r=this;this._hasSubmenus=!1;for(var a,l,u,c,h=s.children('a[ojmenu="opt"]'),d=0;d<h.length;d++)(a=e(h[d])).children().removeClass("oj-menu-item-icon").removeClass("oj-menu-item-end-icon"),a.replaceWith(a.contents());if(s.children('span[ojmenu="opt"]').remove(),/[^\-\u2014\u2013\s]/.test(s.text())||0!==s.children().length){this._initMenuItems(s);var p=document.createElement("a");p.setAttribute("href","#"),p.setAttribute("ojmenu","opt"),(a=e(p)).uniqueId().attr({tabIndex:"-1",role:this._itemRole(s)}),o&&(a.attr("aria-checked","false"),(l=t).previousElementSibling||i(l)||e(l).addClass("oj-top"),l.nextElementSibling&&"OJ-OPTION"===l.nextElementSibling.nodeName||n(l)||e(l).addClass("oj-bottom")),s.prepend(p);var f=m.CustomElementUtils.getSlotMap(t),_=f.startIcon;if(_||o){if(o){var v=document.createElement("span");v.setAttribute("slot","startIcon"),v.setAttribute("ojmenu","opt"),v.setAttribute("class","oj-menucheckbox-icon"),_?_.splice(0,0,v):_=[v]}var g=_.length;r._maxStartIconCount=Math.max(r._maxStartIconCount,g),e.each(_,function(t,i){e(i).addClass("oj-menu-item-icon"),a.append(i),g>1&&r._positionStartIcon(i,t,g)})}var b=0,O=f.endIcon;O&&(b=O.length,r._maxEndIconCount=Math.max(r._maxEndIconCount,b));var j=f[""];e.each(j,function(t,i){e(i).is("oj-menu")?(r._setupSubmenu(a,e(i),0===b),r._hasSubmenus=!0):a.append(i)}),O&&e.each(O,function(t,i){e(i).addClass("oj-menu-item-end-icon"),a.append(i),b>1&&r._positionEndIcon(i,t,b)}),t.disabled?(s.addClass("oj-disabled"),a.attr("aria-disabled","true")):(s.removeClass("oj-disabled"),a.removeAttr("aria-disabled"))}else this._initDividers(s),(c=i(u=t))&&e(c).addClass("oj-menu-item-before-divider"),(c=n(u))&&e(c).addClass("oj-menu-item-after-divider");this._updateMenuPadding(this.element)},_positionStartIcon:function(t,i,n){var s;s=this.isRtl?"margin-right":"margin-left";var o=Number(e(t).attr("data-oj-default-margin"));isNaN(o)&&(o=parseInt(e(t).css(s),10),e(t).attr("data-oj-default-margin",o)),this._startIconWidth=-1*o,e(t).css(s,o*(n-i)+"px")},_positionEndIcon:function(t,i,n){var s,o;this.isRtl?(s="margin-left",o="margin-right"):(s="margin-right",o="margin-left");var r=Number(e(t).attr("data-oj-default-margin"));isNaN(r)&&(r=parseInt(e(t).css(s),10),e(t).attr("data-oj-default-margin",r)),this._endIconWidth=-1*parseInt(e(t).css(o),10),e(t).css(s,r+this._endIconWidth*(n-i-1)+"px")},_updateMenuPadding:function(t){var i=e(S(t)).children();i.each(function(){let t=e(this).children(".oj-menu-item-icon:not(.oj-menu-cancel-icon)").length,i=e(this).children(".oj-menu-item-end-icon").length||e(this).children(".oj-menu-submenu-icon").length;0===t&&0===i?e(this).addClass("oj-menu-option-text-only"):(t>0&&e(this).addClass("oj-menu-option-start-icon"),i>0&&e(this).addClass("oj-menu-option-end-icon"))}),this._maxStartIconCount&&this._maxStartIconCount>1&&this._applyAnchorIconPadding(i,this._startIconWidth,this._maxStartIconCount,!0),this._maxEndIconCount&&this._maxEndIconCount>1&&this._applyAnchorIconPadding(i,this._endIconWidth,this._maxEndIconCount,!1)},_applyAnchorIconPadding:function(t,i,n,s){var o;o=this.isRtl&&s||!this.isRtl&&!s?"padding-right":"padding-left",t.each(function(){var t=Number(e(this).attr("data-oj-default-padding"));isNaN(t)&&(t=parseInt(e(this).css(o),10),e(this).attr("data-oj-default-padding",t)),e(this).css(o,t+i*(n-1)+"px")})},_clickAwayHandler:function(i){if("focus"===i.type||"mousedown"===i.type||"touchstart"===i.type||121===i.keyCode&&i.shiftKey||93===i.keyCode){if("mousedown"===i.type&&n)return;var s=this,o=t.slice(0,t.length);e.each(o,function(t,n){if(!e(i.target).closest(n.element).length&&("keydown"===i.type||"mousedown"===i.type&&3===i.which||!e(i.target).closest(n._launcher).length||n._isContextMenu&&("mousedown"===i.type&&3!==i.which||"touchstart"===i.type))&&!n._dismissEvent){n._dismissEvent=i;var o=n._collapse(i,"eventSubtree");s._runOnPromise(o,function(){n.__dismiss(i),n._dismissEvent=null})}})}},_setOption:function(e,t){this._superApply(arguments),"translations"===e&&this._cancelAnchor&&this._cancelAnchor.text(this.options.translations.labelCancel)},_destroy:function(){this.element.is(":visible")&&this.__dismiss(),this._setWhenReady("none"),this._clearTimer&&this._clearTimer(),delete this._clearTimer,this.element[0].removeEventListener("touchstart",this._touchStartHandler,{passive:!0}),delete this._touchStartHandler,this.element[0].removeEventListener("touchstart",this._delegatedHandleMouseEnterMenuItem,{passive:!0}),delete this._delegatedHandleMouseEnterMenuItem,this.element.removeAttr("aria-activedescendant").removeClass("oj-component").find(".oj-menu").addBack().removeClass("oj-menu oj-menu-submenu oj-menu-icons oj-menu-end-icons oj-menu-text-only").removeAttr("role").removeAttr("tabIndex").removeAttr("aria-labelledby").removeAttr("aria-hidden").removeAttr("aria-disabled").removeUniqueId().show(),this.element.find(".oj-menu-item").removeClass("oj-menu-item").removeAttr("role").children("a").removeAttr("aria-disabled").removeUniqueId().removeClass("oj-hover").removeAttr("tabIndex").removeAttr("role").removeAttr("aria-haspopup").children().each(function(){var t=e(this);t.data("oj-ojMenu-submenu-icon")&&t.remove()}),this.element.find("a").removeAttr("aria-expanded"),this.element.find(".oj-menu-divider").removeClass("oj-menu-divider").removeAttr("role"),delete this._popupServiceEvents,delete this._usingCallback;var t=this._clearCloseDelayTimer;delete this._clearCloseDelayTimer,t&&t(),this.element.ojHammer("destroy"),this._super()},_keydown:function(t){var i=!0;function n(e){return e.replace(/[-\[\]{}()*+?.,\\^$|#\s]/g,"\\$&")}switch(t.keyCode){case e.ui.keyCode.HOME:this._move("first","first",t);break;case e.ui.keyCode.END:this._move("last","last",t);break;case e.ui.keyCode.UP:this._previous(t);break;case e.ui.keyCode.DOWN:this._next(t);break;case e.ui.keyCode.LEFT:case e.ui.keyCode.RIGHT:t.keyCode===e.ui.keyCode.RIGHT!==this.isRtl?this.active&&!this.active.is(".oj-disabled")&&this._expand(t):this._collapse(t,"active");break;case e.ui.keyCode.ENTER:case e.ui.keyCode.SPACE:this._handleEnterSpace(t),this.__spaceEnterDownInMenu=!0;var s=this;setTimeout(function(){s.__spaceEnterDownInMenu=!1},100);break;case e.ui.keyCode.TAB:t.preventDefault(),this._focusLauncherAndDismiss(t);break;case e.ui.keyCode.ESCAPE:if(this._launcher){var o=this.element.attr("aria-activedescendant"),r=e(document.getElementById(o)).parents(".oj-menu").first();r.length>0&&r[0]!==this.element[0]?this._collapse(t,"active"):this._focusLauncherAndDismiss(t)}else this._collapse(t,"active");break;default:i=!1;var a=this.previousFilter||"",l=String.fromCharCode(t.keyCode),u=!1;clearTimeout(this.filterTimer),l===a?u=!0:l=a+l;var c=new RegExp("^"+n(l),"i"),h=e(S(this.activeMenu)).filter(function(){return c.test(e(this).children("a").text())});(h=u&&-1!==h.index(this.active.next())?this.active.nextAll(".oj-menu-item"):h).length||(l=String.fromCharCode(t.keyCode),c=new RegExp("^"+n(l),"i"),h=e(S(this.activeMenu)).filter(function(){return c.test(e(this).children("a").text())})),h.length?(this._focus(t,h),h.length>1?(this.previousFilter=l,this.filterTimer=setTimeout(function(){delete this.previousFilter}.bind(this),1e3)):delete this.previousFilter):delete this.previousFilter}i&&t.preventDefault()},_handleEnterSpace:function(e){this.active&&!this.active.is(".oj-disabled")&&(this.active.children("a[aria-haspopup='true']").length?this._expand(e):this._select(e))},refresh:function(){function t(t){for(var i=t.element.find("oj-menu:not(.oj-menu-submenu)"),n=0;n<i.length;n++){e(i[n]).attr("aria-hidden","true").hide(),r.getContext(i[n]).getBusyContext().whenReady().then(function(e){e.refresh()}.bind(t,i[n]))}}(this._super(),this._IsCustomElement()&&!this._wasCreated)?(this.element.parent().is("oj-option")&&(this._isSubmenu=!0,this._createAsSubmenu()),this._isSubmenu||(l.subtreeShown(this.element[0]),this._createAsTopLevelMenu(),t(this)),this._wasCreated=!0):(t(this),this._setup());this._reposition()},_reposition:function(){var t=this.element;if(t.is(":visible")&&!(t[0].getBoundingClientRect().width>document.documentElement.clientWidth)){var i=t.data(d);t[0].style.maxHeight="",t[0].style.overflowY="",this._updateMenuMaxHeight(),t.position(i),t.find(".oj-menu").each(function(){var t=e(this);t.is(":visible")&&(i=t.data(d),t.position(i))})}},_setup:function(){this.isRtl="rtl"===this._GetReadingDirection(),this._IsCustomElement()?(this._processOjOptions(),this._isSubmenu&&(this.options.openOptions.launcher=this.element.parent()),this._updateMenuPadding(this.element)):this._setupWidgetMenus(),this.active&&!e.contains(this.element[0],this.active[0])&&this._blur()},_setupWidgetMenus:function(){var t=this,i=this.element.find(this.options.menuSelector),n=i.add(this.element),s=n.children();this._hasSubmenus=!!i.length,s.filter(".oj-menu-divider").has("a").removeClass("oj-menu-divider oj-menu-item").removeAttr("role");var o=s.filter(":not(.oj-menu-item):has(a)"),r=o.children("a");this._initMenuItems(o),this._initAnchors(r);var a=s.filter(function(t,i){var n=e(i);return n.is(":not(.oj-menu-item)")&&!/[^\-\u2014\u2013\s]/.test(n.text())});this._initDividers(a),this._initDividerNeighbors(s,a),s.filter(".oj-disabled").children("a").attr("aria-disabled","true"),s.filter(":not(.oj-disabled)").children("a").removeAttr("aria-disabled"),i.filter(":not(.oj-menu)").addClass("oj-menu oj-menu-submenu oj-menu-dropdown").hide().attr({role:this.role,"aria-hidden":"true"}).each(function(){var i=e(this);t._setupSubmenu(t._getSubmenuAnchor(i),i,!0)}),n.each(function(){t._updateMenuPadding(e(this))})},_setupSubmenu:function(t,i,n){var s=0!==t[0].querySelectorAll(".oj-menu-submenu-icon.oj-component-icon").length;if(t.attr("aria-haspopup","true").attr("role","menuitem").attr("aria-expanded","false"),n&&!s){var o=e("<span>");o.addClass("oj-menu-submenu-icon oj-component-icon").data("oj-ojMenu-submenu-icon",!0),t.append(o)}t[0].parentElement.disabled&&i.find("oj-option").attr("disabled",!0),i.attr("aria-labelledby",t.attr("id"))},_initMenuItems:function(e){e.addClass("oj-menu-item").attr("role","presentation")},_initAnchors:function(t){for(var i=0;i<t.length;i++){var n=e(t[i]);n.uniqueId().attr({tabIndex:"-1",role:this._itemRole(n.parent())})}},_initDividers:function(e){e.addClass("oj-menu-divider").attr("role","separator")},_initDividerNeighbors:function(e,t){e.removeClass("oj-menu-item-before-divider oj-menu-item-after-divider"),t.prev().addClass("oj-menu-item-before-divider"),t.next().addClass("oj-menu-item-after-divider")},_clearOption:function(e){e.removeClass("oj-menu-item-before-divider oj-menu-item-after-divider oj-menu-divider oj-menu-item").removeAttr("role")},_getSubmenuAnchor:function(e){return e.prev("a")},_getSubmenuWidget:function(e){return l.__GetWidgetConstructor(e,"ojMenu")("instance")},_itemRole:function(e){return"OJ-MENU-SELECT-MANY"===e.parent().prop("nodeName")?"menuitemcheckbox":"menuitem"},_getAdjacentDividers:function(e,t){var i=e.prev(".oj-menu-divider").add(e.next(".oj-menu-divider"));return t&&(i=i.add(e)),i},_focus:function(t,i){var n=this.active?this.active:e();if(!i.is(n)){t&&"focus"===t.type||this._clearTimer&&this._clearTimer(),i=i.first(),this._makeActive(i,t);var s=i.parents(".oj-menu").first(),o=s.closest(".oj-menu-item");s.find(".oj-focus-ancestor").removeClass("oj-focus-ancestor"),this._getAdjacentDividers(o,!0).addClass("oj-focus-ancestor"),t&&"keydown"===t.type?this._close():this._clearTimer=this._setTimer(function(){return delete this._clearTimer,this._close()},this._getSubmenuBusyStateDescription("closing"),this.delay);var r=this._IsCustomElement()?i.children("oj-menu"):i.children(".oj-menu"),a=r.length>0&&n.length>0&&e.contains(r[0],n[0]);r.length&&t&&/^mouse|click/.test(t.type)&&!a&&this._startOpening(t,r),this.activeMenu=i.parents(".oj-menu").first()}},_makeActive:function(t,i){if(!t.is(this.active)){var n,s,o=this.active?this.active:e(),r=t.children("a");this.active=t,this.element.attr("aria-activedescendant",r.attr("id")),this._focusOutHandler(o),this._focusInHandler(t),this._getAdjacentDividers(o).removeClass("oj-focus"),this._getAdjacentDividers(t).addClass("oj-focus"),this._trigger("_activeItem",i,{previousItem:o,item:t,privateNotice:"The _activeItem event is private.  Do not use."}),i&&/^key/.test(i.type)&&(n=r[0],(s=n.getBoundingClientRect()).top<0||s.bottom>document.documentElement.clientHeight||s.left<0||s.right>document.documentElement.clientWidth)&&r[0].scrollIntoView()}},_removeActive:function(t){if(this.active){var i=this.active;this.active=null,this.element.removeAttr("aria-activedescendant"),this._focusOutHandler(i),this._getAdjacentDividers(i).removeClass("oj-focus"),this._trigger("_activeItem",t,{previousItem:i,item:e(),privateNotice:"The _activeItem event is private.  Do not use."})}},_blur:function(e){this._clearTimer&&this._clearTimer(),this._removeActive(e)},_focusLauncherAndDismiss:function(e,t){this._launcher&&this._launcher.focus(),this.__dismiss(e,t)},close:function(){this.__dismiss()},__dismiss:function(e,t){if(!this._isOperationPending("close","__dismiss",[e,t])&&s.ZOrderUtils.getStatus(this.element)===s.ZOrderUtils.STATUS.OPEN){var i=this.element.is(":visible");this._setWhenReady("close");var n={};n[s.PopupService.OPTION.POPUP]=this.element,n[s.PopupService.OPTION.CONTEXT]={event:e,selectUi:t,isOpen:i},s.PopupService.getInstance().close(n)}},_getDefaultAnimation:function(e,t){var i=p,n=a.getCachedCSSVarValues([i[e][t]])[0];return JSON.parse(n)},_isAnimationDisabled:function(){return!this._IsCustomElement()||this._disableAnimation},_replaceAnimationOptions:function(e,t){var i=e;if(t&&e&&"string"!=typeof e){for(var n=JSON.stringify(e),s=Object.keys(t),o=0;o<s.length;o++){var r=s[o];n=n.replace(new RegExp(r,"g"),t[r])}i=JSON.parse(n)}return i},_runOnPromise:function(e,t){return e?e.then(t):t()},_beforeCloseHandler:function(e){var t=e[s.PopupService.OPTION.POPUP];if(this._IsCustomElement()){var i=e[s.PopupService.OPTION.CONTEXT],n=i.selectUi;if(n&&n.item.length){var o={},r=n.item[0],a=i.event;o.originalEvent=a.originalEvent;var l={detail:o,cancelable:!0,bubbles:!0},c=new CustomEvent("ojAction",l);r.dispatchEvent(c),l.detail.selectedValue=r.value;var h=new CustomEvent("ojMenuAction",l);this.element[0].dispatchEvent(h),i.event=h}}if(!this._isAnimationDisabled()){var m=this._getDefaultAnimation(this._sheetMenuIsOpen?"sheet":"dropdown","close"),d=u.startAnimation(t[0],"close",s.PositionUtils.addTransformOriginAnimationEffectsOption(t,m),this);return d.then(function(){t.attr("aria-hidden","true").hide()}),d}t.attr("aria-hidden","true").hide()},_afterCloseHandler:function(e){var i=e[s.PopupService.OPTION.CONTEXT],n=i.event,o=i.selectUi,r=i.isOpen;(this.element.removeData(d),this._launcher=null,this._sheetMenuIsOpen=!1,!this._IsCustomElement()&&o)&&(n=this._trigger2("select",n,o).event);r&&this._trigger("close",n,{}),this._currentOpenOptions=null;var a=t.indexOf(this);t.splice(a,1),this._destroyVoiceOverAssist()},getCurrentOpenOptions:function(){return e.extend(!0,{},this._currentOpenOptions||this.options.openOptions)},_closeMenuIfOpen:function(e,t,i){s.ZOrderUtils.getStatus(this.element)===s.ZOrderUtils.STATUS.OPEN&&(this._disableAnimation=!0,this._currentOpenOptions=e,this.__dismiss(t.event),this._dismissEvent=null,this._currentOpenOptions=i)},open:function(i,n){var o=arguments[2];if(!this._isOperationPending("open","open",[i,n,o])){var l=function(i,n){this._IsCustomElement()&&this.refresh(),this.element.removeAttr("aria-activedescendant"),this.element.find(".oj-focus").removeClass("oj-focus"),this.focusHandled=!1,this._focusIsFromPointer=!1,this.mouseHandled=!1,this.activeMenu=this.element,this.active=null,(n=e.extend({},this.options.openOptions,n)).position=e.extend({},n.position),i&&"keydown"===i.type&&121===i.which&&(n.initialFocus="firstItem"),this._IsCustomElement()&&this._setPosition(n.position),o=e.extend({},this.options.submenuOpenOptions,o);var r=this._currentOpenOptions;this._currentOpenOptions=n,s.PositionUtils._normalizeEventForPosition(i),this._isContextMenu=this.element[0].slot&&"contextMenu"===this.element[0].slot;var l=this._trigger2("beforeOpen",i,{openOptions:n});if(!l.proceed)return this._currentOpenOptions=r,void(this._disableAnimation=!1);this._closeMenuIfOpen(r,l,n);var u=n.launcher;if(!(u=this._IsCustomElement()?"string"===e.type(u)?e(document.getElementById(u)):e(u):"string"===e.type(u)?e(u):u)||!u.length)return c.warn("When calling Menu.open(), must specify openOptions.launcher via the component option, method param, or beforeOpen listener.  Ignoring the call."),this._currentOpenOptions=null,void(this._disableAnimation=!1);var h,m,p=this._isDropDown(n.display);if(this._toggleCancelDom(p),p){this.element.addClass("oj-menu-dropdown").removeClass("oj-menu-sheet"),m=g;var f=s.PositionUtils.normalizeHorizontalAlignment(n.position,this.isRtl);if(!f.of&&f.offset&&0===f.offset.x&&0===f.offset.y){const e=a.getCachedCSSVarValues(["--oj-private-core-global-dropdown-offset"])[0]||0;f.offset={x:0,y:e}}this._IsCustomElement()?(f=s.PositionUtils.coerceToJet(f,this.options.openOptions.position),this._referenceOpenPosition=f,h=s.PositionUtils.coerceToJqUi(f)):(this._referenceOpenPosition=f,h=f),h.of=s.PositionUtils.normalizePositionOf(h.of,u,i)}else this.element.addClass("oj-menu-sheet").removeClass("oj-menu-dropdown"),m=b,h={my:"bottom",at:O,of:window,collision:"flipfit"};var _=this.element[0],v=t.slice(0,t.length);e.each(v,function(e,t){t.element[0]!==_&&(t._collapse(i,"eventSubtree"),t.__dismiss(i))}),this._submenuPosition=s.PositionUtils.normalizeHorizontalAlignment(o.position,this.isRtl);var j=this._usingCallback;e.isFunction(h.using)&&(h.origUsing=h.using),h.using=j,this.element.data(d,h),this._setWhenReady("open");var y={};y[s.PopupService.OPTION.POPUP]=this.element,y[s.PopupService.OPTION.LAUNCHER]=u,y[s.PopupService.OPTION.POSITION]=h,y[s.PopupService.OPTION.EVENTS]=this._getPopupServiceEvents(),y[s.PopupService.OPTION.LAYER_SELECTORS]="oj-menu-layer",y[s.PopupService.OPTION.MODALITY]=m,y[s.PopupService.OPTION.CONTEXT]={event:i,initialFocus:n.initialFocus,launcher:u,isDropDown:p},y[s.PopupService.OPTION.CUSTOM_ELEMENT]=this._IsCustomElement();var S=s.PopupService.getInstance(),E=S.open.bind(S,y),C=this.element[0].querySelector("oj-defer");C?s.Context.getContext(C).getBusyContext().whenReady().then(E):E();this._disableAnimation=!1}.bind(this,i,n);if(this._dismissEvent){var u=r.getContext(this.element[0]).getBusyContext();u.whenReady().then(l)}else l()}},_setPosition:function(e){var t=this.options;t.openOptions.position=s.PositionUtils.coerceToJet(e,t.openOptions.position)},_beforeOpenHandler:function(e){var t,i=e[s.PopupService.OPTION.POPUP],n=e[s.PopupService.OPTION.POSITION],o=e[s.PopupService.OPTION.CONTEXT],r=o.event,a=o.isDropDown,l=o.initialFocus;if(i[0].style.maxHeight="",i[0].style.overflowY="",i.show(),a&&(n=this._checkBrowserVerticalScollBar(o,n)),this.rootHeight=i[0].offsetHeight,"click"===n.of.type?this.launcherHeight=n.of.clientY:this.launcherHeight=o.launcher[0].getBoundingClientRect().bottom,this._updateMenuMaxHeight(),i.position(n),this._initVoiceOverAssist(l),"firstItem"===l){var c=this._getFirstItem();this._focus(r,c)}if(!this._isAnimationDisabled()){var h=this._getDefaultAnimation(a?"dropdown":"sheet","open");t=u.startAnimation(i[0],"open",s.PositionUtils.addTransformOriginAnimationEffectsOption(i,h),this)}return t},_checkBrowserVerticalScollBar:function(t,i){var n=t.launcher,o=e.position.scrollbarWidth(),r=window.innerWidth>document.documentElement.clientWidth,a=window.innerWidth-n[0].offsetLeft-this.element[0].offsetWidth<o;if(!r||!a)return i;if(this._referenceOpenPosition.offset.x=-1*o,this._IsCustomElement()){var l=s.PositionUtils.coerceToJqUi(this._referenceOpenPosition);return Object.assign(i,{my:l.my})}return Object.assign(i,{offset:{my:-1*o}})},_updateMenuMaxHeight:function(e){var t=e?e[0]:this.element[0],i=this._isDropDown(this.options.openOptions.display);if(!(t.querySelectorAll("oj-menu").length||!i||this.rootHeight<window.innerHeight)){var n=window.innerHeight-this.launcherHeight-25;n<25&&(n=25),t.style.maxHeight=n+"px",t.style.overflowY="auto"}},_afterOpenHandler:function(e){var i,n=e[s.PopupService.OPTION.CONTEXT],o=n.event,r=n.launcher,a=n.isDropDown,l=n.initialFocus;(this._launcher=r,this._sheetMenuIsOpen=!a,t.push(this),"firstItem"===l||"menu"===l)&&(i=this._focusSkipLink&&"menu"===l?this._focusSkipLink.getLink():this.element,this._IsCustomElement()?window.setImmediate(function(){i.focus()}):i.focus());this._trigger("open",o,{})},_initVoiceOverAssist:function(e){if("menu"===e&&(s.AgentUtils.getAgentInfo().os===s.AgentUtils.OS.IOS||s.AgentUtils.getAgentInfo().os===s.AgentUtils.OS.ANDROID)){var t=this._getFirstItem();if(!(t.length<1)){var n=this.element.attr("id");s.StringUtils.isEmptyOrUndefined(n)&&(n=this.uuid);var o=[n,"focusSkipLink"].join("_"),r=function(){window.setImmediate(function(e,t){t.find("a").first().focus(),e._focus(null,t)}.bind(this,this,t))}.bind(this),a=this.options.translations.ariaFocusSkipLink;this._focusSkipLink=new i.PopupSkipLink(t,a,r,o,{insertBefore:!0,preventKeyEvents:!1})}}},_destroyVoiceOverAssist:function(){this._focusSkipLink&&(this._focusSkipLink.destroy(),delete this._focusSkipLink)},_getFirstItem:function(){return this.element.find(".oj-menu-item").first()},_startOpening:function(e,t){this._clearTimer&&this._clearTimer(),this._IsCustomElement()&&t[0].refresh(),this._clearTimer=this._setTimer(function(){return delete this._clearTimer,this._close().then(function(){this._open(e,t)}.bind(this))},this._getSubmenuBusyStateDescription("closing and opening"),this.delay)},_open:function(t,i){if("true"===i.attr("aria-hidden")&&this.active){var n;if(this._IsCustomElement()){var o=this._getSubmenuWidget(i);if(!o._trigger2("beforeOpen",t).proceed)return;let e=Object.assign(o.options.openOptions.position,{offset:{x:0,y:y}});n=s.PositionUtils.coerceToJqUi(e),n=s.PositionUtils.normalizeHorizontalAlignment(n,this.isRtl)}else n=this._submenuPosition;if(n=e.extend({of:this.active},n),this._clearTimer&&this._clearTimer(),this.element.find(".oj-menu").not(i.parents(".oj-menu")).hide().attr("aria-hidden","true").removeData(d),i.show().removeAttr("aria-hidden").position(n).data(d,n),this._getSubmenuAnchor(i).attr("aria-expanded","true"),!this._isAnimationDisabled()){var a=r.getContext(this.element[0]).getBusyContext().addBusyState({description:this._getSubmenuBusyStateDescription("opening")}),l=this._getDefaultAnimation("submenu","open");!this.isRtl&&parseFloat(i[0].style.left)<0?n.my="right top":this.isRtl&&parseFloat(i[0].style.left)>0&&(n.my="left top"),l=this._replaceAnimationOptions(l,{"#myPosition":n.my}),u.startAnimation(i[0],"open",l,this).then(a)}this._updateMenuMaxHeight(i)}},__collapseAll:function(t,i,n){var s;this._clearTimer&&this._clearTimer();var o=this,a=function(){delete o._clearTimer;var n=i?o.element:e(t&&t.target).closest(o.element.find(".oj-menu"));n.length||(n=o.element);var s=o._close(n);return s=o._runOnPromise(s,function(){o._blur(t),o.activeMenu=n})};if(n?this._isAnimationDisabled()?o._clearTimer=o._setTimer(a,o._getSubmenuBusyStateDescription("closing"),n):s=new Promise(function(e){o._clearTimer=o._setTimer(a,o._getSubmenuBusyStateDescription("closing"),n,function(){e(!0)})}):s=a(),s){var l=r.getContext(this.element[0]).getBusyContext().addBusyState({description:"closing submenus"});s.then(l)}return s},_close:function(t){var i;t||(t=this.active?this.active.parents(".oj-menu").first():this.element);var n=this,s=n._getDefaultAnimation("submenu","close"),o=t.find(".oj-menu"),r=function(e){e.hide().attr("aria-hidden","true").removeData(d),n._getSubmenuAnchor(e).attr("aria-expanded","false")};if(this._isAnimationDisabled())r(o),t.find(".oj-focus-ancestor").removeClass("oj-focus-ancestor"),i=Promise.resolve(!0);else{var a=function(t){var i=null;return e(S(t)).children(".oj-menu").each(function(t,o){var l=e(o);if(l.is(":visible")){var c=a(l);i=n._runOnPromise(c,function(){var e=l.data(d),t=n._replaceAnimationOptions(s,{"#myPosition":e.my});return u.startAnimation(o,"close",t,n).then(function(){r(l)})})}else r(l),i=Promise.resolve(!0)}),i};i=a(t),i=this._runOnPromise(i,function(){t.find(".oj-focus-ancestor").removeClass("oj-focus-ancestor")})}return i},_collapse:function(e,t){var i;if(null==t||"active"===t){var n=this.activeMenu&&this.activeMenu.closest(".oj-menu-item",this.element);if(n&&n.length){var s=this;i=this._close(),i=this._runOnPromise(i,function(){s._focus(e,n)})}}else"all"===t||"eventSubtree"===t?i=this.__collapseAll(e,"all"===t,this.delay):c.warn("Invalid param "+t+" passed to Menu._collapse().  Ignoring the call.");return i},_expand:function(t){var i,n;if(this.active){var s=S(n=this.active.children(".oj-menu ").first());s.length>0&&(i=e(s[0]))}i&&i.length&&(this._open(t,n),this._clearTimer&&this._clearTimer(),this._clearTimer=this._setTimer(function(){delete this._clearTimer,this._focus(t,i)},this._getBusyStateDescription("focusing an item")))},_next:function(e){this._move("next","first",e)},_previous:function(e){this._move("prev","last",e)},_move:function(t,i,n){var s,o=S(this.activeMenu),r=o.indexOf(this.active?this.active[0]:null);r>-1?"first"===t?s=o[0]:"last"===t?s=o[o.length-1]:"next"===t?s=r+1<o.length?o[r+1]:o[0]:"prev"===t&&(s=r-1>-1?o[r-1]:o[o.length-1]):s="first"===i?o[0]:o[o.length-1],this._focus(n,e(s))},_select:function(t){if(!this.active&&t&&t.target){var i=e(t.target).closest(".oj-menu-item");i.closest(this.element).length&&this._makeActive(i,t)}var n=this.active.is(this._cancelItem)?void 0:{item:this.active},s=this.__collapseAll(t,!0);this._runOnPromise(s,function(){this._focusLauncherAndDismiss(t,n)}.bind(this))},_surrogateRemoveHandler:function(){var e=this.element;s.ZOrderUtils.getStatus(e)===s.ZOrderUtils.STATUS.OPEN&&e.remove()},_getPopupServiceEvents:function(){if(!this._popupServiceEvents){var e={};this._popupServiceEvents=e,e[s.PopupService.EVENT.POPUP_CLOSE]=this._closeAll.bind(this),e[s.PopupService.EVENT.POPUP_REMOVE]=this._surrogateRemoveHandler.bind(this),e[s.PopupService.EVENT.POPUP_REFRESH]=this._reposition.bind(this),e[s.PopupService.EVENT.POPUP_AUTODISMISS]=this._clickAwayHandler.bind(this),e[s.PopupService.EVENT.POPUP_BEFORE_OPEN]=this._beforeOpenHandler.bind(this),e[s.PopupService.EVENT.POPUP_AFTER_OPEN]=this._afterOpenHandler.bind(this),e[s.PopupService.EVENT.POPUP_BEFORE_CLOSE]=this._beforeCloseHandler.bind(this),e[s.PopupService.EVENT.POPUP_AFTER_CLOSE]=this._afterCloseHandler.bind(this)}return this._popupServiceEvents},_closeAll:function(){this._disableAnimation=!0,this._close(this.element),this.__dismiss(null),this._setWhenReady("none")},_usingHandler:function(e,t){var i=t.element.element;i.css(e),s.PositionUtils.captureTransformOriginAnimationEffectsOption(i,t);var n=i.data(d).origUsing;n&&n(e,t),s.PositionUtils.isAligningPositionClipped(t)&&(this._clearCloseDelayTimer=this._setTimer(this._closeAll,this._getSubmenuBusyStateDescription("closing"),1))},getNodeBySubId:function(e){return e&&"oj-menu-cancel-command"===e.subId?this._cancelDomAttached?this._cancelItem[0]:null:this._super(e)},getSubIdByNode:function(t){return this._cancelItem&&this._cancelItem.is(e(t).parents().addBack(t))?{subId:"oj-menu-cancel-command"}:this._super(t)},_isDropDown:function(e){if(this._hasSubmenus)return!0;switch(e){case"dropDown":return!0;case"sheet":return!1;default:return"phone"!==h.getDeviceRenderMode()}},_toggleCancelDom:function(t){function i(t,i){var n=S(t),s=n.indexOf(i[1]);return e(n[s-1])}if(_)if(t)this._cancelDomAttached&&(i(this.element,this._getCancelDom()).removeClass("oj-menu-item-before-divider"),this._getCancelDom().detach(),this._cancelDomAttached=!1);else{var n=this._getCancelDom();n.appendTo(this.element),i(this.element,n).addClass("oj-menu-item-before-divider"),this._cancelDomAttached=!0}},_getCancelDom:function(){if(!this._cancelDom){var t=e("<li></li>",this.document[0]),i=e("<a href='#'></a>",this.document[0]).text(this.options.translations.labelCancel);e("<span class='oj-menu-item-icon oj-component-icon oj-menu-cancel-icon'></span>",this.document[0]).prependTo(i);var n=e("<li></li>",this.document[0]).addClass("oj-menu-item-cancel oj-menu-item-after-divider").append(i);this._initDividers(t),this._initAnchors(i),this._initMenuItems(n),this._cancelAnchor=i,this._cancelItem=n,this._cancelDom=e([t[0],n[0]])}return this._cancelDom},_setupSwipeBehavior:function(){v&&(this.element.ojHammer(j),this._on({swipedown:function(e){this._sheetMenuIsOpen&&"touch"===e.gesture.pointerType&&(this.__collapseAll(e,!0),this._focusLauncherAndDismiss(e))}}))},_setWhenReady:function(e){var t=this._whenReadyMediator;t&&(t.destroy(),delete this._whenReadyMediator),["open","close"].indexOf(e)<0||(this._whenReadyMediator=new i.PopupWhenReadyMediator(this.element,e,"ojMenu",this._IsCustomElement()))},_isOperationPending:function(e,t,i){var n=this._whenReadyMediator;return!!n&&n.isOperationPending(this,e,t,i)},_setTimer:function(e,t,i,n){var s=r.getContext(this.element[0]).getBusyContext().addBusyState({description:t}),o=function(){s&&(s(),s=null,n&&n())},a=this,l=setTimeout(function(){var t=e.bind(a)();t&&t instanceof Promise?t.then(o):o()},i||0);return function(){clearTimeout(l),o()}},_getBusyStateDescription:function(e){return"Menu with id '"+this.element.attr("id")+"' is busy "+e+"."},_getSubmenuBusyStateDescription:function(e){return this._getBusyStateDescription(e+" a submenu")},_NotifyDetached:function(){s.ZOrderUtils.getStatus(this.element)===s.ZOrderUtils.STATUS.OPEN&&this._closeAll(),this._super()}}),l.setDefaultOptions({ojMenu:{openOptions:l.createDynamicPropertyGetter(function(e){return{position:m.CustomElementUtils.isElementRegistered(e.element.tagName)?e.containers.indexOf("ojMenu")>=0?{my:{horizontal:"start",vertical:"top"},at:{horizontal:"end",vertical:"top"},offset:{x:0,y:0},collision:"flipfit"}:{my:{horizontal:"start",vertical:"top"},at:{horizontal:"start",vertical:"bottom"},offset:{x:0,y:0},collision:"flipfit"}:{my:"start top",at:"start bottom",collision:"flipfit"}}})}})}(),(d={properties:{disabled:{type:"boolean",value:!1},openOptions:{type:"object",properties:{display:{type:"string",enumValues:["auto","dropDown","sheet"],value:"auto"},initialFocus:{type:"string",enumValues:["firstItem","menu","none"],value:"menu"},launcher:{type:"string|Element"},position:{type:"object",properties:{at:{type:"object",properties:{horizontal:{type:"string",enumValues:["center","end","left","right","start"]},vertical:{type:"string",enumValues:["bottom","center","top"]}}},collision:{type:"string",enumValues:["fit","flip","flipcenter","flipfit","none"],value:"flipfit"},my:{type:"object",properties:{horizontal:{type:"string",enumValues:["center","end","left","right","start"],value:"start"},vertical:{type:"string",enumValues:["bottom","center","top"],value:"top"}}},of:{type:"string|object"},offset:{type:"object",properties:{x:{type:"number",value:0},y:{type:"number",value:0}}}}}}},translations:{type:"object",value:{},properties:{ariaFocusSkipLink:{type:"string"},labelCancel:{type:"string"}}}},methods:{close:{},getProperty:{},open:{},refresh:{},setProperties:{},setProperty:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojAction:{},ojAnimateEnd:{},ojAnimateStart:{},ojBeforeOpen:{},ojClose:{},ojMenuAction:{},ojOpen:{}},extension:{}}).extension._WIDGET_NAME="ojMenu",s.CustomElementBridge.register("oj-menu",{metadata:d})});
//# sourceMappingURL=ojmenu.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojvmenu',["exports","ojs/ojmenu","preact"],function(e,t,n){"use strict";class o extends n.Component{constructor(e){super(e),this._rootRef=null}render(e){return n.h("div",{style:{display:"none"},ref:e=>this._rootRef=e},e.children)}componentDidMount(){this._menuElement||(this._menuElement=this._getMenu(),null!==this._menuElement&&this._openMenu())}_getMenu(){return this._rootRef.childNodes[0]}_openMenu(){const e=this._getOpenOptions();this._menuElement.__openingContextMenu=!0;try{this._menuElement.open(this.props.eventObj.event,e),this._addCloseListener()}catch(e){throw e}finally{this._menuElement.__openingContextMenu=!1}}_addCloseListener(){this.props.onCloseCallback&&this._menuElement.addEventListener("ojClose",this.props.onCloseCallback)}_getOpenOptions(){const e=this.props.eventObj.eventType||"keyboard";return{launcher:this.props.launcherElement,position:Object.assign(Object.assign({},o._MENU_POSITION[e]),{of:"keyboard"===e?this.props.launcherElement:this.props.eventObj.event}),initialFocus:"menu"}}componentWillUnmount(){this._removeCloseListener()}_removeCloseListener(){this._menuElement&&this.props.onCloseCallback&&this._menuElement.removeEventListener("ojClose",this.props.onCloseCallback)}}o._MENU_POSITION={mouse:{my:"start top",at:"start bottom",collision:"flipfit"},touch:{my:"start>40 center",at:"start bottom",collision:"flipfit"},keyboard:{my:"start top",at:"start bottom",collision:"flipfit"}},e.VMenu=o,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=ojvmenu.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojvcomponent-binding',["exports"],function(n){"use strict";n.consumedBindings=function(n){return function(n){}},n.providedBindings=function(n){return function(n){}},Object.defineProperty(n,"__esModule",{value:!0})});
//# sourceMappingURL=ojvcomponent-binding.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojbutton2',["exports","ojs/ojdomutils","ojs/ojgestureutils","ojs/ojvcomponent","preact","ojs/ojvmenu","ojs/ojvcomponent-binding","ojs/ojthemeutils"],function(t,e,n,o,s,i,r,a){"use strict";var l,u=function(t,e,n,o){var s,i=arguments.length,r=i<3?e:null===o?o=Object.getOwnPropertyDescriptor(e,n):o;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)r=Reflect.decorate(t,e,n,o);else for(var a=t.length-1;a>=0;a--)(s=t[a])&&(r=(i<3?s(r):i>3?s(e,n,r):s(e,n))||r);return i>3&&r&&Object.defineProperty(e,n,r),r};t.Button2=l=class extends s.Component{constructor(t){super(t),this._rootRef=s.createRef(),this._handleContextMenuGesture=(t,e)=>{const n={event:t,eventType:e};t.preventDefault(),this.setState({contextMenuTriggerEvent:n})},this._handleTouchstart=t=>{this.setState({active:!0})},this._handleTouchend=t=>{this.setState({active:!1})},this._handleFocusIn=t=>{t.target===t.currentTarget&&this._handleFocus(t),this.setState({focus:!0}),this._rootRef.current&&this.focusInHandler(this._rootRef.current)},this._handleFocusOut=t=>{t.target===t.currentTarget&&this._handleBlur(t),this.setState({focus:!1}),this._rootRef.current&&this.focusOutHandler(this._rootRef.current)},this._handleMouseenter=t=>{e.recentTouchEnd()||(this===l._lastActive&&this.setState({active:!0}),this.setState({hover:!0}))},this._handleMouseleave=t=>{this.setState({hover:!1,active:!1})},this._handleMousedown=t=>{if(1===t.which&&!e.recentTouchEnd()){this.setState({active:!0}),l._lastActive=this;const t=()=>{l._lastActive=null,document.removeEventListener("mouseup",t,!0)};document.addEventListener("mouseup",t,!0)}},this._handleMouseup=t=>{this.setState({active:!1})},this._handleClick=t=>{var e,n;t.detail<=1&&(null===(n=(e=this.props).onOjAction)||void 0===n||n.call(e,{originalEvent:t}))},this._handleKeydown=t=>{32!==t.keyCode&&13!==t.keyCode||this.setState({active:!0})},this._handleKeyup=t=>{this.setState({active:!1})},this._handleFocus=t=>{var e,n;null===(n=null===(e=this._rootRef)||void 0===e?void 0:e.current)||void 0===n||n.dispatchEvent(new FocusEvent("focus",{relatedTarget:t.relatedTarget}))},this._handleBlur=t=>{var e;this.setState({active:!1}),null===(e=this._rootRef)||void 0===e||e.current.dispatchEvent(new FocusEvent("blur",{relatedTarget:t.relatedTarget}))},this._onCloseCallback=t=>{this.state.contextMenuTriggerEvent&&this.setState({contextMenuTriggerEvent:null})},this.state={},this.uniquePrefix=t.id?t.id+o.getUniqueId():o.getUniqueId()}render(t,e){const n=t.children;let i=this._processIcon(t.startIcon,"oj-button-icon oj-start"),r=this._processIcon(t.endIcon,"oj-button-icon oj-end"),a=t["aria-label"],l=t["aria-labelledby"],u=t["aria-describedby"];const h=a||l;let c=null,d=null,b=null,p=t.title;const _=t.label||n;_?(p=this.state.derivedTitle||p||t.label,"icons"===t.display&&(i||r)?t.label?(h||(a=t.label),c=s.h("span",{ref:t=>this._defaultSlotRef=t},c)):(h||(b=this.uniquePrefix+"|text",l=b),c=s.h("span",{ref:t=>this._defaultSlotRef=t,class:"oj-button-text oj-helper-hidden-accessible",id:b},_)):"label"===t.display?(t.startIcon&&(i=this._processIcon(t.startIcon,"oj-button-icon oj-helper-hidden oj-start")),t.endIcon&&(r=this._processIcon(t.endIcon,"oj-button-icon oj-helper-hidden oj-end")),h||(b=this.uniquePrefix+"|text",l=b),c=s.h("span",{ref:t=>this._defaultSlotRef=t,class:"oj-button-text",id:b},_)):(h||(b=this.uniquePrefix+"|text",l=b),c=s.h("span",{ref:t=>this._defaultSlotRef=t,class:"oj-button-text",id:b},_))):c=s.h("span",{ref:t=>this._defaultSlotRef=t},c);const f=s.h("div",{class:"oj-button-label"},i,c,r);let v;t.disabled?v=s.h("button",{class:"oj-button-button","aria-labelledby":l,"aria-describedby":u,"aria-label":a,disabled:!0},f):(d=this._handleClick,v=s.h("button",{class:"oj-button-button",ref:t=>this._buttonRef=t,"aria-labelledby":l,"aria-describedby":u,"aria-label":a,onTouchStart:this._handleTouchstart,onTouchEnd:this._handleTouchend,onTouchCancel:this._handleTouchend,onMouseEnter:this._handleMouseenter,onMouseLeave:this._handleMouseleave,onMouseDown:this._handleMousedown,onMouseUp:this._handleMouseup,onfocusin:this._handleFocusIn,onfocusout:this._handleFocusOut,onKeyDown:this._handleKeydown,onKeyUp:this._handleKeyup},f));const j=this._getRootClasses(i,r);return s.h(o.Root,{class:j,id:t.id,title:p,onClick:d,ref:this._rootRef},v,this._renderContextMenu())}_renderContextMenu(){return this.state.contextMenuTriggerEvent&&this.props.contextMenu?s.h(i.VMenu,{eventObj:this.state.contextMenuTriggerEvent,launcherElement:this._buttonRef,onCloseCallback:this._onCloseCallback},[this.props.contextMenu]):null}_processIcon(t,e){let n;return Array.isArray(t)?n=t.map(t=>this._processIcon(t,e)):t&&(n=s.h("span",{class:e},t)),n}_getRootClasses(t,e){let n=!0,o="oj-button "+l._chromingMap[this.props.chroming];return o+=" "+this._getDisplayOptionClass(t,e),this.props.disabled?(n=!1,o+=" oj-disabled"):(o+=" oj-enabled",this.state.hover&&(n=!1,o+=" oj-hover"),this.state.active&&(n=!1,o+=" oj-active")),n&&(o+=" oj-default"),o}_getDisplayOptionClass(t,e){const n=t&&e,o=t||e,s="icons"===this.props.display;let i;return i="label"===this.props.display?"oj-button-text-only":o?s?n?"oj-button-icons-only":"oj-button-icon-only":n?"oj-button-text-icons":t?"oj-button-text-icon-start":"oj-button-text-icon-end":"oj-button-text-only",i}_addMutationObserver(){if(this._mutationObserver)return;this._mutationObserver=new MutationObserver(()=>{const t=this._getTextContent();t!=this.state.derivedTitle&&this.setState({derivedTitle:t})}),this._mutationObserver.observe(this._defaultSlotRef,{subtree:!0,characterData:!0})}_needsContextMenuDetection(t){return t.contextMenu&&!t.disabled}componentDidMount(){this._updateDerivedTitle(),this._needsContextMenuDetection(this.props)&&n.startDetectContextMenuGesture(this._rootRef.current,this._handleContextMenuGesture),this._rootRef.current.addEventListener("touchstart",this._handleTouchstart,{passive:!0}),this._rootRef.current.addEventListener("touchend",this._handleTouchend,{passive:!1}),this._rootRef.current.addEventListener("touchcancel",this._handleTouchend,{passive:!0}),e.makeFocusable({applyHighlight:!0,setupHandlers:(t,n)=>{let o=e.getNoJQFocusHandlers(t,n);this.focusInHandler=o.focusIn,this.focusOutHandler=o.focusOut}})}componentDidUpdate(t){t.display!=this.props.display&&this._updateDerivedTitle(),this._updateContextMenuDetection(t)}_updateDerivedTitle(){const t=this.props;let e;"icons"!==t.display||!t.startIcon&&!t.endIcon||t.label||t.title||(e=this._getTextContent(),this._addMutationObserver()),e!=this.state.derivedTitle&&this.setState({derivedTitle:e})}_updateContextMenuDetection(t){const e=this._needsContextMenuDetection(t),o=this._needsContextMenuDetection(this.props);e!=o&&(o?n.startDetectContextMenuGesture(this._rootRef.current,this._handleContextMenuGesture):n.stopDetectContextMenuGesture(this._rootRef.current))}static getDerivedStateFromProps(t){return t.disabled?{contextMenuTriggerEvent:null}:null}_getTextContent(){let t=this._defaultSlotRef.textContent;return t=t.trim(),""!==t?t:null}componentWillUnmount(){this._mutationObserver&&(this._mutationObserver.disconnect(),this._mutationObserver=null),n.stopDetectContextMenuGesture(this._rootRef.current)}refresh(){this.setState({active:!1})}focus(){var t;null===(t=this._buttonRef)||void 0===t||t.focus()}blur(){var t;null===(t=this._buttonRef)||void 0===t||t.blur()}},t.Button2._chromingMap={solid:"oj-button-full-chrome",outlined:"oj-button-outlined-chrome",borderless:"oj-button-half-chrome",full:"oj-button-full-chrome",half:"oj-button-half-chrome",callToAction:"oj-button-cta-chrome",danger:"oj-button-danger-chrome oj-button-full-chrome"},t.Button2.defaultProps={disabled:!1,display:"all",chroming:a.getCachedCSSVarValues(["--oj-private-button-global-chroming-default"])[0]},t.Button2.metadata={slots:{"":{},startIcon:{},endIcon:{},contextMenu:{}},properties:{disabled:{type:"boolean"},display:{type:"string",enumValues:["all","icons","label"]},label:{type:"string"},translations:{type:"object|null"},chroming:{type:"string",enumValues:["borderless","callToAction","danger","full","half","outlined","solid"],binding:{consume:{name:"containerChroming"}}}},events:{ojAction:{bubbles:!0}},extension:{_OBSERVED_GLOBAL_PROPS:["id","title","aria-label","aria-labelledby","aria-describedby"]},methods:{refresh:{},focus:{},blur:{}}},t.Button2=l=u([o.customElement("oj-button")],t.Button2),Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ojbutton2.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojbutton',["ojs/ojoption","ojs/ojcore-base","jquery","ojs/ojdomutils","ojs/ojthemeutils","ojs/ojcomponentcore","ojs/ojchildmutationobserver","ojs/ojlabelledbyutils","ojs/ojcustomelement-utils","ojs/ojbutton2"],function(t,e,n,o,s,i,l,a,r,u){"use strict";e=e&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e,n=n&&Object.prototype.hasOwnProperty.call(n,"default")?n.default:n,l=l&&Object.prototype.hasOwnProperty.call(l,"default")?l.default:l,a=a&&Object.prototype.hasOwnProperty.call(a,"default")?a.default:a;var c={properties:{chroming:{type:"string",enumValues:["borderless","full","half","outlined","solid"]},disabled:{type:"boolean",value:!1},display:{type:"string",enumValues:["all","icons","label"],value:"all"},label:{type:"string"},translations:{type:"object",value:{}}},methods:{getProperty:{},refresh:{},setProperties:{},setProperty:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojAction:{}},extension:{}};c.extension._WIDGET_NAME="ojButton",c.extension._TRACK_CHILDREN="nearestCustomElement",c.extension._GLOBAL_TRANSFER_ATTRS=["href","aria-label","aria-labelledby","aria-describedby"],e.CustomElementBridge.register("oj-menu-button",{metadata:c,innerDomFunction:function(t){return t.getAttribute("href")?"a":"button"}});var h={properties:{chroming:{type:"string",enumValues:["borderless","full","half","outlined","solid"]},describedBy:{type:"string"},disabled:{type:"boolean",value:!1},display:{type:"string",enumValues:["all","icons","label"],value:"all"},focusManagement:{type:"string",enumValues:["none","oneTabstop"],value:"oneTabstop"},labelledBy:{type:"string"},translations:{type:"object",value:{}},value:{type:"any",writeback:!0}},methods:{getProperty:{},refresh:{},setProperties:{},setProperty:{},getNodeBySubId:{},getSubIdByNode:{}},extension:{}};h.extension._WIDGET_NAME="ojButtonset",h.extension._ALIASED_PROPS={value:"checked"},e.CustomElementBridge.register("oj-buttonset-one",{metadata:h});var d={properties:{chroming:{type:"string",enumValues:["borderless","full","half","outlined","solid"]},describedBy:{type:"string"},disabled:{type:"boolean",value:!1},display:{type:"string",enumValues:["all","icons","label"],value:"all"},focusManagement:{type:"string",enumValues:["none","oneTabstop"],value:"oneTabstop"},labelledBy:{type:"string"},translations:{type:"object",value:{}},value:{type:"Array<any>",writeback:!0}},methods:{getProperty:{},refresh:{},setProperties:{},setProperty:{},getNodeBySubId:{},getSubIdByNode:{}},extension:{}};if(d.extension._WIDGET_NAME="ojButtonset",d.extension._ALIASED_PROPS={value:"checked"},e.CustomElementBridge.register("oj-buttonset-many",{metadata:d}),e.ButtonLegacy){var m={properties:{chroming:{type:"string",enumValues:["borderless","callToAction","danger","full","half","outlined","solid"]},disabled:{type:"boolean",value:!1},display:{type:"string",enumValues:["all","icons","label"],value:"all"},translations:{type:"object",value:{}}},methods:{refresh:{},setProperty:{},getProperty:{},setProperties:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojAction:{}},extension:{}};m.extension._WIDGET_NAME="ojButton",m.extension._TRACK_CHILDREN="nearestCustomElement",m.extension._GLOBAL_TRANSFER_ATTRS=["href","aria-label","aria-labelledby","aria-describedby"],e.CustomElementBridge.register("oj-button",{metadata:m,innerDomFunction:function(t){return t.getAttribute("href")?"a":"button"}})}!function(){var t,u,c="oj-button oj-component oj-enabled oj-default",h="oj-button-icons-only oj-button-icon-only oj-button-text-icons oj-button-text-icon-start oj-button-text-icon-end oj-button-text-only",d="oj-button-full-chrome oj-button-half-chrome oj-button-outlined-chrome oj-button-cta-chrome oj-button-danger-chrome",m={solid:"oj-button-full-chrome",outlined:"oj-button-outlined-chrome",borderless:"oj-button-half-chrome",full:"oj-button-full-chrome",half:"oj-button-half-chrome",callToAction:"oj-button-cta-chrome",danger:"oj-button-danger-chrome oj-button-full-chrome"},b={button:["ojButtonset","ojToolbar"],buttonset:["ojToolbar"]};function p(t,e){y(t,d),t.classList.add(m[e])}function f(t,e){var o,s=t.name,i=t.form;if(s){var l=":radio[name='"+(s=s.replace(/'/g,"\\'"))+"']:oj-button";o=e?e.filter(l):i?n(i).find(l):n(l,t.ownerDocument).filter(function(){return!this.form})}else o=(e?e.filter(t):n(t)).filter(":oj-button");return o}function _(t,e,n){var o=function(t,e,n){for(var o=0;o<n.length;++o){var s=n[o];if(e.indexOf(s)>=0)for(;;t=t.parentNode){var l=i.__GetWidgetConstructor(t,s);if(l)return l}}return null}(e,n,b[t]);return o?o("option","chroming"):s.getCachedCSSVarValues(["--oj-private-"+t+"-global-chroming-default"])[0]}function v(t,e){var n=t.className;if(n){for(var o=n.split(" "),s=e.split(" "),i=s.length;i>=0;i--)o.indexOf(s[i])>=0&&s.splice(i,1);s.length>0&&(t.className=n+" "+s.join(" "))}else t.className=e}function y(t,e){var n=t.className;if(n){for(var o=n.split(" "),s=e.split(" "),i=!1,l=0;l<s.length;l++){var a=o.indexOf(s[l]);a>=0&&(o.splice(a,1),i=!0)}i&&(t.className=o.join(" "))}}e.__registerWidget("oj.ojButton",n.oj.baseComponent,{defaultElement:"<button>",widgetEventPrefix:"oj",options:{chroming:"solid",disabled:!1,display:"all",label:null,icons:{start:null,end:null},menu:null,action:null},_InitOptions:function(t,e){this._super(t,e),this._IsCustomElement()&&this._processSlots(),this._initButtonTypes(),this._IsCustomElement()||"disabled"in e||this.option("disabled",!!this.element[0].disabled,{_context:{internalSet:!0}}),"label"in e||(this.keepDomLabel=!0,this.option("label","inputPush"===this.type?this.buttonElement.val():this.buttonElement[0].innerHTML,{_context:{internalSet:!0}})),this._IsCustomElement()||!this.options.menu||e.icons&&void 0!==e.icons.end||this.option("icons.end","oj-component-icon oj-button-menu-dropdown-icon",{_context:{writeback:!0,internalSet:!0}})},_ComponentCreate:function(){this._super(),this.menuEventNamespace=this.eventNamespace+"menu",this._initButtonTypes2(),this.hasTitle=!!this.rootElement.getAttribute("title");var e=this,s=this._isToggle;v(this.rootElement,c),p(this.rootElement,this.options.chroming);var i=function(){e.rootElement.classList.remove("oj-active"),e.rootElement.classList.remove("oj-hover"),e._toggleDefaultClasses()};if(this._touchStartHandler=function(){e._IsEffectivelyDisabled()||(e.rootElement.classList.add("oj-active"),e._toggleDefaultClasses(),e.document.one("touchend",i))},o.isTouchSupported()&&(this.buttonElement[0].addEventListener("touchstart",this._touchStartHandler,{passive:!0}),this.buttonElement.bind("touchend"+this.eventNamespace+" touchcancel"+this.eventNamespace,i)),this.buttonElement.bind("mouseenter"+this.eventNamespace,function(){e._IsEffectivelyDisabled()||e._isSelectedInButtonsetOne()||(e.rootElement.classList.add("oj-hover"),o.recentTouchEnd()||this===t&&e.rootElement.classList.add("oj-active"),e.rootElement.classList.remove("oj-default"),e.rootElement.classList.remove("oj-focus-only"))}).bind("mouseleave"+this.eventNamespace,function(){e.rootElement.classList.remove("oj-hover"),e._IsEffectivelyDisabled()||(e.rootElement.classList.remove("oj-active"),e._toggleDefaultClasses())}),this._disabledClickHandler=function(t){e._IsEffectivelyDisabled()&&(t.preventDefault(),t.stopImmediatePropagation())},this._ojActionClickHandler=function(t){e._trigger("action",t,{})},this._IsCustomElement()?(this.rootElement.addEventListener("click",this._disabledClickHandler,!0),this.rootElement.addEventListener("click",this._ojActionClickHandler,!1)):this.buttonElement[0].addEventListener("click",this._disabledClickHandler,!0),this._focusable({element:n(this.rootElement),applyHighlight:!0,afterToggle:function(){e._toggleDefaultClasses()}}),s&&(this.element.bind("change"+this.eventNamespace,function(t){e._applyCheckedStateFromDom(!0);var n=e._getEnclosingContainerComponent("buttonset"),o=n&&n._getCheckedFromDom(n.$buttons);n&&void 0!==o&&n.option("checked",o,{_context:{writeback:!0,originalEvent:t,internalSet:!0}})}),this.buttonElement.bind("mousedown"+this.eventNamespace,function(){e._IsEffectivelyDisabled()||(u=this,e._isSelectedInButtonsetOne()||e.rootElement.classList.add("oj-active"),e.document.one("mouseup",function(){u=null,e.rootElement.classList.remove("oj-active")}))}).bind("mouseup"+this.eventNamespace,function(){e._IsEffectivelyDisabled()||(e.rootElement.classList.remove("oj-active"),this===u&&e.element.focus())})),"checkbox"===this.type)this.buttonElement.bind("click"+this.eventNamespace,function(){if(e._IsEffectivelyDisabled())return!1}),this.element.bind("keyup"+this.eventNamespace,function(t){t.keyCode===n.ui.keyCode.ENTER&&(e._IsEffectivelyDisabled()||e.element.click())});else if("radio"===this.type)this.buttonElement.bind("click"+this.eventNamespace,function(){if(e._IsEffectivelyDisabled())return!1}),this.element.bind("keyup"+this.eventNamespace,function(t){t.keyCode===n.ui.keyCode.ENTER&&(e.element[0].checked||e._IsEffectivelyDisabled()||(e.element[0].checked=!0,e.element.change(),e.element.click()))});else if(this.buttonElement.bind("mousedown"+this.eventNamespace,function(n){if(e._IsEffectivelyDisabled())return!1;1!==n.which||o.recentTouchEnd()||(e._isSelectedInButtonsetOne()||e.rootElement.classList.add("oj-active"),e.rootElement.classList.remove("oj-default"),e.rootElement.classList.remove("oj-focus-only"),t=this,e.document.one("mouseup",function(){t=null}))}).bind("mouseup"+this.eventNamespace,function(){if(e._IsEffectivelyDisabled())return!1;e.rootElement.classList.remove("oj-active"),e._toggleDefaultClasses()}).bind("keydown"+this.eventNamespace,function(t){if(e._IsEffectivelyDisabled())return t.keyCode===n.ui.keyCode.TAB||t.keyCode===n.ui.keyCode.LEFT||t.keyCode===n.ui.keyCode.RIGHT;var o=t.keyCode===n.ui.keyCode.SPACE,s="anchor"===e.type;s&&o&&t.preventDefault(),(o&&!s||t.keyCode===n.ui.keyCode.ENTER)&&(e._isSelectedInButtonsetOne()||e.rootElement.classList.add("oj-active"),e.rootElement.classList.remove("oj-default"),e.rootElement.classList.remove("oj-focus-only"))}).bind("keyup"+this.eventNamespace+" blur"+this.eventNamespace,function(){e.rootElement.classList.remove("oj-active"),e._toggleDefaultClasses()}),"anchor"===this.type){var l=this.buttonElement[0].getAttribute("tabindex");(null===l||isNaN(l))&&this.buttonElement[0].setAttribute("tabindex","0")}this.options.disabled&&this._manageAnchorTabIndex(!1,!0),this._updateEffectivelyDisabled();var a=e._getEnclosingContainerComponent("buttonset");this._IsCustomElement()||a&&a._IsCustomElement()?this._setDisplayOptionOnDom():this._handleLabelAndIconsAtCreateTime(),this._setupMenuButton(null),this._toggleDefaultClasses(),this._childMutationObserver&&this._childMutationObserver.observe()},_NotifyContextMenuGesture:function(t,e,o){this._OpenContextMenu(e,o,{position:{of:"keyboard"===o?n(this.rootElement):e}})},_addMutationObserver:function(){if(!this._childMutationObserver&&this._IsCustomElement()){var t=this;this._childMutationObserver=new l(this.rootElement,function(e){e.forEach(function(e){var n;if("childList"===e.type){var o=e.addedNodes&&e.addedNodes[0],s=e.target;if(o&&3===o.nodeType&&s&&1===s.nodeType&&s.classList.contains("oj-button-label")){t._childMutationObserver.disconnect(),n=!0;var i=t.buttonElement[0].querySelector(".oj-button-text");i&&(i.textContent=o.textContent),o.parentNode.removeChild(o)}}else"characterData"===e.type&&(t._childMutationObserver.disconnect(),n=!0);n&&(t._setDisplayOptionOnDom(),t._childMutationObserver.observe())})})}},_removeMutationObserver:function(){this._childMutationObserver&&(this._childMutationObserver.disconnect(),this._childMutationObserver=null)},_processSlots:function(){var t,e=this,o=this.element[0],s=o.parentNode,i="OJ-MENU-BUTTON"===s.tagName,l=r.CustomElementUtils.getSlotMap(s);t=i?["startIcon","","endIcon","menu"]:["startIcon","","endIcon"],n.each(t,function(t,e){l[e]&&""!==e&&n.each(l[e],function(t,e){o.appendChild(e)})});for(var a=s.children,u=a.length-1;u>=0;u--){var c=a[u];c!==o&&"contextMenu"!==c.getAttribute("slot")&&s.removeChild(c)}var h=r.CustomElementUtils.getSlotMap(o);n.each(t,function(t,s){h[s]&&n.each(h[s],function(t,i){if(o.appendChild(i),""===s){var l=i,a=l;3===l.nodeType&&(a=document.createElement("span"),l.parentNode.insertBefore(a,l),a.appendChild(l)),a.classList.add("oj-button-text"),e._setTextSpanIdAndLabelledBy(a)}else if("startIcon"===s)i.classList.add("oj-button-icon"),i.classList.add("oj-start");else if("endIcon"===s)i.classList.add("oj-button-icon"),i.classList.add("oj-end");else if("menu"===s&&(n(i).uniqueId(),e.menuSlot="#"+i.id,void 0===h.endIcon)){var r=document.createElement("span"),u="oj-button-menu-dropdown-icon";void 0===h.startIcon&&"icons"===e.options.display&&(u="oj-button-menu-icon-only-dropdown-icon"),r.className="oj-button-icon oj-end oj-component-icon "+u,r.setAttribute("slot","endIcon"),o.insertBefore(r,i)}})});var d=document.createElement("div");for(d.className="oj-button-label";o.hasChildNodes();)d.appendChild(o.firstChild);o.appendChild(d)},_getMenuNode:function(){return this._IsCustomElement()?this.menuSlot:this.options.menu},_initButtonTypes:function(){var t=this.element[0];if("INPUT"===t.tagName&&"checkbox"===t.type)this.type="checkbox",this._isToggle=!0;else if("INPUT"===t.tagName&&"radio"===t.type)this.type="radio",this._isToggle=!0;else if("INPUT"!==t.tagName||"button"!==t.type&&"submit"!==t.type&&"reset"!==t.type)if("BUTTON"===t.tagName)this.type="button";else{if("A"!==t.tagName)throw new Error("JET Button not supported on this element type");this.type="anchor"}else this.type="inputPush";if(this._isToggle){var e="label[for='"+this.element[0].getAttribute("id")+"']";this.buttonElement=this.element.siblings().filter(e)}else this.buttonElement=this.element},_initButtonTypes2:function(){var t=this.element[0];if(this._isToggle){this.buttonElement[0].classList.add("oj-button-label"),t.classList.add("oj-button-input"),t.classList.add("oj-helper-hidden-accessible"),t.setAttribute("data-oj-internal","");var e=document.createElement("span");this.element[0].parentNode.insertBefore(e,this.buttonElement[0]),e.appendChild(this.buttonElement[0]),e.appendChild(this.element[0]),this.rootElement=this.element[0].parentNode,this.rootElement.classList.add("oj-button-toggle"),t.checked&&(this.rootElement.classList.add("oj-selected"),this.rootElement.classList.remove("oj-default"),this.rootElement.classList.remove("oj-focus-only"))}else this._IsCustomElement()?(this.rootElement=this.element[0].parentNode,t.classList.add("oj-button-button")):(this.rootElement=this.element[0],this._IsCustomElement()||t.classList.add("oj-button-toggle"))},widget:function(){return n(this.rootElement)},_destroy:function(){this._removeMenuBehavior(this._getMenuNode()),this.buttonElement[0].removeEventListener("click",this._disabledClickHandler,!0),this.buttonElement[0].removeEventListener("click",this._ojActionClickHandler,!1),this.buttonElement[0].removeEventListener("touchstart",this._touchStartHandler,{passive:!0}),delete this._touchStartHandler;var t=this.element[0];t.classList.remove("oj-helper-hidden-accessible"),t.removeAttribute("aria-labelledby"),t.removeAttribute("aria-describedby"),this.element.removeUniqueId(),this.options.disabled&&this._manageAnchorTabIndex(!0,!1);var e=this._isToggle;e||y(this.rootElement,c+" oj-button-toggle oj-hover oj-active oj-selected "+h+" "+d);var n=this.buttonElement[0].querySelector(".oj-button-text");n&&(this.buttonElement[0].innerHTML=n.innerHTML),e?(this.buttonElement[0].classList.remove("oj-button-label"),o.unwrap(this.element)):this.hasTitle||this.rootElement.removeAttribute("title"),u===this.buttonElement[0]&&(u=null),this.buttonElement.off("blur"),this._removeMutationObserver()},_NotifyDetached:function(){this._super(),this._toggleDefaultClasses()},__setAncestorComponentDisabled:function(t){this._super(t),this._updateEffectivelyDisabled()},_updateEffectivelyDisabled:function(){var e=this.element[0],n=this._IsEffectivelyDisabled();if(n?(this.rootElement.classList.add("oj-disabled"),this.rootElement.classList.remove("oj-enabled")):(this.rootElement.classList.remove("oj-disabled"),this.rootElement.classList.add("oj-enabled")),"anchor"!==this.type?(e.disabled=n,this.rootElement.removeAttribute("aria-disabled")):(e.setAttribute("aria-disabled",n),this._IsCustomElement()&&this.rootElement.removeAttribute("aria-disabled")),n){var o=this.widget()[0].classList;o.remove("oj-active"),o.remove("oj-default"),o.remove("oj-focus-only"),o.remove("oj-hover"),o.remove("oj-focus"),o.remove("oj-focus-highlight"),t=null,this._dismissMenu(this._getMenuNode())}else this._toggleDefaultClasses()},_setOption:function(t,e,n){var o=this.options[t];switch(this._super(t,e,n),t){case"chroming":p(this.rootElement,e);break;case"disabled":if(this._manageAnchorTabIndex(o,e),this._updateEffectivelyDisabled(),!this._IsCustomElement()){var s=this._getEnclosingContainerElement("toolbar");s.length&&s.ojToolbar("refresh")}break;case"label":this._setLabelOption();break;case"display":"inputPush"!==this.type&&this._setDisplayOptionOnDom();break;case"icons":this._setIconsOption(!0);break;case"menu":this._setupMenuButton(o)}},refresh:function(){this._super(),this._ancestorDisabled&&!this._getEnclosingContainerElement("buttonset").length&&this.__setAncestorComponentDisabled(!1),p(this.rootElement,this.options.chroming)},_applyCheckedStateFromDom:function(t){"radio"===this.type?(t?f(this.element[0]):this.element).each(function(){var t=n(this).data("oj-ojButton");this.checked?(t.rootElement.classList.add("oj-selected"),t.rootElement.classList.remove("oj-default"),t.rootElement.classList.remove("oj-focus-only")):(t.rootElement.classList.remove("oj-selected"),t._toggleDefaultClasses())}):"checkbox"===this.type&&(this.element[0].checked?(this.rootElement.classList.add("oj-selected"),this.rootElement.classList.remove("oj-default"),this.rootElement.classList.remove("oj-focus-only")):(this.rootElement.classList.remove("oj-selected"),this._toggleDefaultClasses()))},_handleLabelAndIconsAtCreateTime:function(){if("inputPush"===this.type)this._setLabelOnDomOfSpanlessButton();else{var t=this._setLabelOnDomAtCreateTime(),e=this._setIconOnDom(!0),n=this._setIconOnDom(!1);this._setDisplayOptionOnDom(t,e,n)}},_setLabelOnDomAtCreateTime:function(){var t=this.buttonElement[0],e=document.createElement("span");if(e.className="oj-button-text",this.keepDomLabel)for(;t.hasChildNodes();)e.appendChild(t.firstChild);else t.innerHTML="",e.textContent=this.options.label;if("button"===this.type){var o=document.createElement("div");o.className="oj-button-label",o.appendChild(e),this.element[0].appendChild(o)}else t.appendChild(e);return"button"!==this.type&&"anchor"!==this.type||this.element[0].hasAttribute("aria-label")||this.element[0].hasAttribute("aria-labelledby")||this._setTextSpanIdAndLabelledBy(e),n(e)},_setTextSpanIdAndLabelledBy:function(t){n(t).uniqueId(),this.element[0].hasAttribute("aria-label")||this.element[0].hasAttribute("aria-labelledby")||this.element[0].setAttribute("aria-labelledby",t.getAttribute("id"))},_setLabelOption:function(){if("inputPush"===this.type)this._setLabelOnDomOfSpanlessButton();else{var t=this.buttonElement[0].querySelector(".oj-button-text");t.textContent=this.options.label,this._setDisplayOptionOnDom(n(t))}},_setLabelOnDomOfSpanlessButton:function(){this.options.label&&this.element.val(this.options.label)},_setIconsOption:function(){if("inputPush"!==this.type){var t=this._setIconOnDom(!0),e=this._setIconOnDom(!1);this._setDisplayOptionOnDom(void 0,t,e)}},_setIconOnDom:function(t){var e,n,o,s,i=this.buttonElement[0];"button"===this.type&&(i=this.element.children("div.oj-button-label")[0]),t?(e=".oj-button-icon.oj-start",n="oj-button-icon oj-start",o=this.options.icons.start,s="_lastStartIcon"):(e=".oj-button-icon.oj-end",n="oj-button-icon oj-end",o=this.options.icons.end,s="_lastEndIcon");var l,a,r=i.querySelectorAll(e);if(o)if(r.length){var u=this[s];for(l=0;l<r.length;l++)y(a=r[l],u),v(a,o)}else{var c=document.createElement("span");c.className=n+" "+o,t?i.insertBefore(c,i.firstChild):i.appendChild(c)}else for(l=0;l<r.length;l++)(a=r[l]).parentNode.removeChild(a);return this[s]=o,!!o},_setDisplayOptionOnDom:function(t,e,o){var s=this.buttonElement.children(".oj-button-label");if(!s.length){var i=this._getEnclosingContainerComponent("buttonset");s=this._IsCustomElement()||i&&i._IsCustomElement()?this.buttonElement.children("oj-option"):this.buttonElement}void 0===t&&(t=s.children(".oj-button-text")),void 0===e&&(e=!!this.options.icons.start||s.children("[slot='startIcon']").length),void 0===o&&(o=!!this.options.icons.end||s.children("[slot='endIcon']").length);var l,a=e&&o,r=e||o,u="icons"===this.options.display,c="label"===this.options.display;if(c)s.children("[slot='startIcon']")&&s.children("[slot='startIcon']")[0].classList.add("oj-helper-hidden"),s.children("[slot='endIcon']")&&s.children("[slot='endIcon']")[0].classList.add("oj-helper-hidden");else if(r&&u){if(t[0]&&t[0].classList.add("oj-helper-hidden-accessible"),!this.hasTitle){var d=t[0]?t[0].textContent:"";this.rootElement.setAttribute("title",n.trim(d))}this._addMutationObserver()}else t[0]&&t[0].classList.remove("oj-helper-hidden-accessible"),this.hasTitle||this.rootElement.removeAttribute("title"),this._removeMutationObserver();c&&(l="oj-button-text-only"),l=r?u?a?"oj-button-icons-only":"oj-button-icon-only":a?"oj-button-text-icons":e?"oj-button-text-icon-start":"oj-button-text-icon-end":"oj-button-text-only",y(this.rootElement,h),this.rootElement.classList.add(l)},_manageAnchorTabIndex:function(t,e){if(!t!=!e&&"anchor"===this.type&&!this._getEnclosingContainerElement("buttonset").length&&!this._getEnclosingContainerElement("toolbar").length){var n=this.element[0];if(e){var o=n.getAttribute("tabindex");this._oldAnchorTabIndex=this._isInteger(Number(o))?o:null,n.setAttribute("tabindex",-1)}else null==this._oldAnchorTabIndex?n.removeAttribute("tabindex"):n.setAttribute("tabindex",this._oldAnchorTabIndex)}},_isInteger:function(t){return"number"==typeof t&&isFinite(t)&&Math.floor(t)===t},_selectorMap:{buttonset:".oj-buttonset",toolbar:".oj-toolbar",buttonsetone:"oj-buttonset-one"},_constructorMap:{buttonset:"ojButtonset",toolbar:"ojToolbar"},_isSelectedInButtonsetOne:function(){return 1===this._getEnclosingContainerElement("buttonsetone").length&&this.rootElement.classList.contains("oj-selected")},_getEnclosingContainerElement:function(t){return n(this.rootElement).closest(this._selectorMap[t])},_getEnclosingContainerComponent:function(t){var e=this._getEnclosingContainerElement(t)[0],n=i.__GetWidgetConstructor(e,this._constructorMap[t]);return n&&n("instance")},_setupMenuButton:function(t){if(this._getMenuNode()&&"INPUT"===this.element[0].tagName)throw new Error("Menu Button functionality is not supported on input elements.");if(this._removeMenuBehavior(t),this._getMenuNode()){var e=this;this.element.attr("aria-haspopup",!0).attr("role","button").on("keydown"+this.menuEventNamespace,function(t){if(t.which===n.ui.keyCode.DOWN||t.which===n.ui.keyCode.ENTER||t.which===n.ui.keyCode.SPACE)return e._toggleMenu(t,"firstItem"),t.preventDefault(),!0;if(t.which===n.ui.keyCode.ESCAPE){var o=!e.rootElement.classList.contains("oj-selected");return e._dismissMenu(e._getMenuNode(),t),o}return!0}).on("click"+this.menuEventNamespace,function(t){var n=e._getMenu();return n.__spaceEnterDownInMenu||e._toggleMenu(t,"menu"),n.__spaceEnterDownInMenu=!1,t.preventDefault(),!0})}},_removeMenuBehavior:function(t){this.element.removeAttr("aria-haspopup").removeAttr("role").off(this.menuEventNamespace),this._dismissMenu(t),n(t).off(this.menuEventNamespace),this._menuListenerSet=!1},_getMenu:function(){var t=this._getMenuOnly(this._getMenuNode());if(!t)throw new Error('JET Button: "menu" option specified, but does not reference a valid JET Menu.');if(!this._menuListenerSet){var e,n=this;e=t._IsCustomElement()?"ojClose":"ojclose",t.widget().on(e+this.menuEventNamespace,function(t){n._menuDismissHandler(t)}),this._menuListenerSet=!0}return t},_getMenuOnly:function(t){var e=i.__GetWidgetConstructor(n(t)[0],"ojMenu");return e&&e("instance")},_toggleMenu:function(t,e){if(!this._IsEffectivelyDisabled()){var n=this._getMenu(),o=n.widget();this._menuVisible?this._dismissMenu(this._getMenuNode(),t):(n.open(t,{launcher:this.element,initialFocus:e}),o.is(":visible")&&(this._menuVisible=!0,o[0].getAttribute("aria-label")||o[0].getAttribute("aria-labelledby")||(this.element.uniqueId(),this._setAriaLabelledBy=!0,o[0].setAttribute("aria-labelledby",this.element[0].getAttribute("id"))),this.rootElement.classList.add("oj-selected"),this.rootElement.classList.remove("oj-default"),this.rootElement.classList.remove("oj-focus-only")))}},_dismissMenu:function(t,e){if(this._menuVisible){var n=this._getMenuOnly(t);n&&(n.__collapseAll(e,!0),n.__dismiss(e))}},_menuDismissHandler:function(){this._setAriaLabelledBy&&(n(this._getMenuNode()).removeAttr("aria-labelledby"),this._setAriaLabelledBy=!1),this.rootElement.classList.remove("oj-selected"),this._toggleDefaultClasses(),this._menuVisible=!1},_toggleDefaultClasses:function(){var t,e;if(n(this.rootElement).is(".oj-hover, .oj-active, .oj-selected, .oj-disabled"))t=!1,e=!1;else{var o=n(this.rootElement).is(".oj-focus");t=!o,e=o}t?this.rootElement.classList.add("oj-default"):this.rootElement.classList.remove("oj-default"),e?this.rootElement.classList.add("oj-focus-only"):this.rootElement.classList.remove("oj-focus-only")}}),e.__registerWidget("oj.ojButtonset",n.oj.baseComponent,{_items:"button, input[type=button], input[type=submit], input[type=reset], input[type=checkbox], input[type=radio], a",widgetEventPrefix:"oj",options:{checked:null,chroming:"solid",display:"all",focusManagement:"oneTabstop",labelledBy:null,describedBy:null},_setCheckedOnDom:function(t,e){var o,s=n.type(t),i=this.element[0];if((o="OJ-BUTTONSET-MANY"===i.tagName||e.length>0&&e.filter("input[type=checkbox]").length===e.length)&&"array"!==s)throw new Error("Invalid 'checked' value set on JET Buttonset: "+t);if(!(this._setCheckedOnButtons(t,e,s,o)||null==t||this._IsCustomElement()&&e.length!==i.children.length))throw new Error("Invalid 'checked' value set on JET Buttonset: "+t)},_setCheckedOnButtons:function(t,e,n,o){var s=this._shallowCompare(t,e,o);return this._shouldDeepCompare(t,o,s)&&(s=this._deepCompare(t,e,o,s)),o?s===t.length:1===s},_shallowCompare:function(t,e,n){var o=this,s=0;return e.each(function(){var e=o._getInputValue(this);(n?t.indexOf(e)>-1:e===t)?(this.checked=!0,s+=1):this.checked=!1}),s},_shouldDeepCompare:function(t,e,n){return e?n!==t.length:!n},_deepCompare:function(t,e,n,o){var s=o,i=this;return e.each(function(){var e=i._getInputValue(this);if(n)for(var o=0;o<t.length;o++)i._deepCompareValues(e,t[o])&&(this.checked=!0,s+=1);else i._deepCompareValues(e,t)&&(this.checked=!0,s+=1)}),s},_deepCompareValues:function(t,o){return"object"===n.type(t)&&t.ojCompareValues?0===t.ojCompareValues(t,o):e.Object.compareValues(t,o)},_getInputValue:function(t){return this._IsCustomElement()?this._getOjOptionFromInput(t).value:t.value},_getOjOptionFromInput:function(t){return t.previousElementSibling.children[0]},_getCheckedFromDom:function(t){var e,n=null,o=null,s=this;return t.each(function(){if("input"!==this.tagName.toLowerCase())return e=void 0,!1;var t,i,l=this.type.toLowerCase();if("radio"===l)t=!0,i=this.name.toLowerCase();else{if("checkbox"!==l)return e=void 0,!1;t=!1,i=null}if(void 0!==e&&(t!==n||i!==o||n&&!o))return e=void 0,!1;var a=s._getInputValue(this);void 0===e?(e=t?this.checked?a:null:this.checked?[a]:[],n=t,o=i):this.checked&&(n?e=a:e.push(a))}),e},_CompareOptionValues:function(t,e,o){return"checked"===t?e===o||"array"===n.type(e)&&"array"===n.type(o)&&this._compareArraysAsSets(e,o):this._superApply(arguments)},_compareArraysAsSets:function(t,e){return!t.some(function(t){return e.indexOf(t)<0})&&!e.some(function(e){return t.indexOf(e)<0})},_removeNonOjOptions:function(){this.element.children(":not(oj-option)").remove()},_processOjOptions:function(){var t=this,e=this.element[0].querySelectorAll("oj-option");n.each(e,function(e,n){n.customOptionRenderer=t._customOptionRenderer.bind(t)})},_customOptionRenderer:function(t){this._removeOptionDecoration(t),this._addOptionDecoration(t)},_addOptionDecoration:function(t){this._addOptionClasses(t);var e="OJ-BUTTONSET-ONE"===this.element[0].tagName,o=e?"radio":"checkbox",s=t.value,i=t.disabled,l=document.createElement("input"),a=document.createElement("label");n(l).uniqueId(),l.value=s,l.type=o,l.disabled=i;var r=l.id;a.htmlFor=r,e&&(this._name||(this._name="_n_"+r),l.name=this._name),t.parentNode.insertBefore(a,t),a.appendChild(t),a.parentNode.insertBefore(l,a.nextElementSibling),this._setup(!1),this._setCheckedOnDom(this.options.checked,this.$buttons),this.$buttons.each(function(){n(this).data("oj-ojButton")._applyCheckedStateFromDom(!1)})},_removeOptionDecoration:function(t){var e=t.parentNode;if("LABEL"===e.tagName){this._removeOptionClasses(t);var o=n(e).siblings(".oj-button-input");o.ojButton("destroy"),o.removeUniqueId(),o.remove(),e.parentNode.insertBefore(t,e),e.parentNode.removeChild(e)}},_addOptionClasses:function(t){var e=r.CustomElementUtils.getSlotMap(t),n=e[""]?e[""]:null,o=e.startIcon?e.startIcon[0]:null,s=e.endIcon?e.endIcon[0]:null;if(o&&(o.classList.add("oj-button-icon"),o.classList.add("oj-start")),n)for(var i=0;i<n.length;i++){var l=n[i],a=l;3===l.nodeType&&(a=document.createElement("span"),l.parentNode.insertBefore(a,l),a.appendChild(l)),a.classList.add("oj-button-text")}s&&(s.classList.add("oj-button-icon"),s.classList.add("oj-end"))},_removeOptionClasses:function(t){var e=r.CustomElementUtils.getSlotMap(t),n=e[""]?e[""]:null,o=e.startIcon?e.startIcon[0]:null,s=e.endIcon?e.endIcon[0]:null;if(o&&(o.classList.remove("oj-button-icon"),o.classList.remove("oj-start")),n)for(var i=0;i<n.length;i++)n[i].classList.remove("oj-button-text");s&&(s.classList.remove("oj-button-icon"),s.classList.remove("oj-end"))},_InitOptions:function(t,e){if(this._super(t,e),this.$buttons=this.element.find(this._items),!("checked"in e)){this.initCheckedFromDom=!0;var o=this._getCheckedFromDom(this.$buttons);"array"!==n.type(o)&&"OJ-BUTTONSET-MANY"!==this.element[0].tagName||(this.options.checked=[]),void 0!==o&&this.option("checked",o,{_context:{internalSet:!0}})}},_ComponentCreate:function(){this._super();var t=this.element[0];t.setAttribute(i._OJ_CONTAINER_ATTR,this.widgetName),t.classList.add("oj-buttonset"),t.classList.add("oj-component"),this._setRole(this.options.focusManagement),this._IsCustomElement()&&(this._removeNonOjOptions(),this._processOjOptions()),this._setup(!0)},_NotifyContextMenuGesture:function(t,e,n){var o=this.element.find(":oj-button[tabindex=0]");this._OpenContextMenu(e,n,{launcher:o,position:{of:"keyboard"===n?o.ojButton("widget"):e}})},_propagateDisabled:function(t){var e=!!t;this.$buttons.each(function(){n(this).data("oj-ojButton").__setAncestorComponentDisabled(e)})},_setRole:function(t){var e=this.element[0];"oneTabstop"===t?e.setAttribute("role","toolbar"):e.removeAttribute("role")},_setOption:function(t,e,o){var s=this.options[t];if(this._superApply(arguments),"disabled"===t){if(this._propagateDisabled(e),this._refreshTabStop(),!this._IsCustomElement()){var i=n(this.element).closest(".oj-toolbar");i.length&&i.ojToolbar("refresh")}}else if("checked"===t)this._setCheckedOnDom(e,this.$buttons),this.$buttons.each(function(){n(this).data("oj-ojButton")._applyCheckedStateFromDom(!1)});else if("focusManagement"===t)this._setRole(e);else if("chroming"===t)p(this.element[0],e),this.$buttons.ojButton("refresh");else if("display"===t)this.$buttons.ojButton("option",t,e);else if("labelledBy"===t){var l=this.element;this._labelledByUpdatedForSet(l[0].id,s,e,l)}else"describedBy"===t&&this._describedByUpdated(s,e)},refresh:function(){this._super(),this._IsCustomElement()&&this._processOjOptions(),this._setup(!1)},_setup:function(t){var e=this,o=this.element[0];this.isRtl="rtl"===this._GetReadingDirection(),p(o,this.options.chroming),!t||this.initCheckedFromDom||this._IsCustomElement()||this._setCheckedOnDom(this.options.checked,this.$buttons),t||(this.$buttons=this.element.find(this._items)),this.$buttons.length>1?o.classList.add("oj-buttonset-multi"):o.classList.remove("oj-buttonset-multi"),this.$buttons.filter(":oj-button").ojButton("refresh").each(function(){n(this).data("oj-ojButton")._applyCheckedStateFromDom(!1)}).end().not(":oj-button").ojButton({display:this.options.display}).end();for(var s=0,i=this.$buttons.length;s<i;s++){var l=this.$buttons.eq(s).ojButton("widget")[0];l.classList.remove("oj-buttonset-first"),l.classList.remove("oj-buttonset-last"),0===s?l.classList.add("oj-buttonset-first"):s===i-1&&l.classList.add("oj-buttonset-last")}this._propagateDisabled(this.options.disabled),"oneTabstop"===this.options.focusManagement&&(this.$buttons.unbind("keydown"+this.eventNamespace).bind("keydown"+this.eventNamespace,function(t){e._handleKeyDown(t,n(this))}).unbind("click"+this.eventNamespace).bind("click"+this.eventNamespace,function(){n(this).data("oj-ojButton")._IsEffectivelyDisabled()||e._setTabStop(n(this))}).unbind("focus"+this.eventNamespace).bind("focus"+this.eventNamespace,function(){e._setTabStop(n(this))}),this.$enabledButtons=this.$buttons.filter(function(){return!n(this).data("oj-ojButton")._IsEffectivelyDisabled()}),this._initTabindexes(t)),this.element.uniqueId(),this._labelledByUpdatedForSet(o.id,null,this.options.labelledBy,this.element);var a=this.options.describedBy;a&&this._describedByUpdated(a)},_labelledByUpdatedForSet:a._labelledByUpdatedForSet,_describedByUpdated:a._describedByUpdated,_GetContentElement:function(){return null!=this.$buttons||(this.$buttons=this.element.find(this._items)),this.$buttons},_refreshTabStop:function(){"oneTabstop"===this.options.focusManagement&&(this.$enabledButtons=this.$buttons.filter(function(){return!n(this).data("oj-ojButton")._IsEffectivelyDisabled()}),this._initTabindexes(!1))},_initTabindexes:function(t){var e,o=n(this._lastTabStop);this._lastTabStop=void 0,this.$buttons.attr("tabindex","-1"),e=t||!o.is(this.$enabledButtons)?this.$enabledButtons.first():o,this._setTabStop(e)},_mapToTabbable:function(t){var e=this.$enabledButtons;return t.map(function(t,n){if("radio"!==n.type||n.checked||""===n.name)return n;var o=f(n,e).filter(":checked");return o.length?o[0]:n})},_setTabStop:function(t){var e=(t=this._mapToTabbable(t))[0],n=this._lastTabStop;e!==n&&(n&&n.setAttribute("tabindex","-1"),t[0]&&t[0].setAttribute("tabindex","0"),this._lastTabStop=e)},_handleKeyDown:function(t,e){switch(t.which){case n.ui.keyCode.UP:case n.ui.keyCode.DOWN:if("radio"!==e[0].getAttribute("type"))break;case n.ui.keyCode.LEFT:case n.ui.keyCode.RIGHT:t.preventDefault();var o=this.$enabledButtons,s=o.length;if(s<2)break;var i=(o.index(e)+(t.which===n.ui.keyCode.DOWN||t.which===n.ui.keyCode.RIGHT!==this.isRtl?1:-1)+s)%s;o.eq(i).focus()}},_destroy:function(){var t=this.element[0];y(t,"oj-buttonset oj-component "+d),t.removeAttribute(i._OJ_CONTAINER_ATTR),t.removeAttribute("role"),"oneTabstop"===this.options.focusManagement&&this.$buttons.attr("tabindex","0"),this.$buttons.map(function(){return n(this).ojButton("widget")[0]}).removeClass("oj-buttonset-first oj-buttonset-last").end().ojButton("destroy")}}),i.setDefaultOptions({ojButton:{chroming:i.createDynamicPropertyGetter(function(t){return _("button",t.element,t.containers)})},ojButtonset:{chroming:i.createDynamicPropertyGetter(function(t){return _("buttonset",t.element,t.containers)})}})}()});
//# sourceMappingURL=ojbutton.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojvalidator-datetimerange',["ojs/ojcore","ojs/ojtranslation","ojs/ojvalidator","ojs/ojvalidation-error","ojs/ojconverter-datetime","ojs/ojconverterutils-i18n","ojs/ojconverterutils"],function(t,e,a,r,n,i,o){"use strict";t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t,a=a&&Object.prototype.hasOwnProperty.call(a,"default")?a.default:a,o=o&&Object.prototype.hasOwnProperty.call(o,"default")?o.default:o;const s=function(t){this.Init(t)};return t.Object.createSubclass(s,a,"oj.DateTimeRangeValidator"),s.prototype.Init=function(t){if(s.superclass.Init.call(this),this._converter=o.getConverterInstance(t.converter),this._converter||(this._converter=new n.IntlDateTimeConverter),!this._converter)throw new Error("oj.DateTimeRangeValidator missing a converter option");this._min=t.min||null,this._max=t.max||null,this._translationKey=t.translationKey||"datetime",t&&(this._hint=t.hint||{},this._customMessageSummary=t.messageSummary||{},this._customMessageDetail=t.messageDetail||{}),e.getTranslatedString("oj-validator.range."+this._translationKey+".messageSummary.rangeOverflow")||(this._translationKey="datetime")},s.prototype.validate=function(t){var a,n,o=this,s=this._customMessageSummary,l=this._customMessageDetail,m=l.rangeOverflow,g=l.rangeUnderflow,u=s.rangeOverflow,c=s.rangeUnderflow,h=i.IntlConverterUtils,v=this._min,_=this._max,d="",f="",p=e,y=null;if(null!==t){try{!function(e){if(h._verifyValueMinMax(t,v,_),v&&(v=h._minMaxIsoString(v,t),a=e?e.format(v):v),_&&(_=h._minMaxIsoString(_,t),n=e?e.format(_):_),null!==v&&null!==_){if(h._compareISODates(t,v)>=0&&h._compareISODates(t,_)<=0||h._compareISODates(v,_)>0)return t}else if(null!==v){if(h._compareISODates(t,v)>=0)return t}else if(null===_||h._compareISODates(t,_)<=0)return t;throw new Error}(this._converter)}catch(e){var j=function(e){return null!==_&&i.IntlConverterUtils._compareISODates(t,_)>0?(y={value:e,max:n},d=u||p.getTranslatedString("oj-validator.range."+o._translationKey+".messageSummary.rangeOverflow"),f=m?p.applyParameters(m,y):p.getTranslatedString("oj-validator.range."+o._translationKey+".messageDetail.rangeOverflow",y)):null!==v&&i.IntlConverterUtils._compareISODates(t,v)<0&&(y={value:e,min:a},d=c||p.getTranslatedString("oj-validator.range."+o._translationKey+".messageSummary.rangeUnderflow"),f=g?p.applyParameters(g,y):p.getTranslatedString("oj-validator.range."+o._translationKey+".messageDetail.rangeUnderflow",y)),[d,f]}(t?this._converter.format(t):t);throw new r.ValidatorError(j[0],j[1])}}},s.prototype.getHint=function(){var t=null,a=this._hint,r=a.inRange,n=a.min,i=a.max,o=this._min,s=this._max,l=o&&this._converter?this._converter.format(o):o,m=s&&this._converter?this._converter.format(s):s,g=null,u=e;return null!==o&&null!==s?(g={min:l,max:m},t=r?u.applyParameters(r,g):u.getTranslatedString("oj-validator.range."+this._translationKey+".hint.inRange",g)):null!==o?(g={min:l},t=n?u.applyParameters(n,g):u.getTranslatedString("oj-validator.range."+this._translationKey+".hint.min",g)):null!==s&&(g={max:m},t=i?u.applyParameters(i,g):u.getTranslatedString("oj-validator.range."+this._translationKey+".hint.max",g)),t},s});
//# sourceMappingURL=ojvalidator-datetimerange.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojvalidator-daterestriction',["ojs/ojcore","ojs/ojtranslation","ojs/ojvalidator","ojs/ojvalidation-error","ojs/ojconverter-datetime","ojs/ojconverterutils-i18n","ojs/ojconverterutils"],function(t,e,r,a,o,n,i){"use strict";t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t,r=r&&Object.prototype.hasOwnProperty.call(r,"default")?r.default:r,i=i&&Object.prototype.hasOwnProperty.call(i,"default")?i.default:i;const s=function(t){this.Init(t)};return t.Object.createSubclass(s,r,"oj.DateRestrictionValidator"),s.prototype.Init=function(t){s.superclass.Init.call(this),this._dayFormatter=t.dayFormatter,this._converter=i.getConverterInstance(t.converter),this._converter||(this._converter=new o.IntlDateTimeConverter),t&&(this._messageSummary=t.messageSummary||null,this._messageDetail=t.messageDetail||null)},s.prototype._inDisabled=function(t){var e=this._dayFormatter;if(e){var r=e({fullYear:t.fullYear,month:t.month+1,date:t.date});return r&&r.disabled}return!1},s.prototype.validate=function(t){var r="",o="",i=e,s=this._messageSummary,l=this._messageDetail,u=t?n.IntlConverterUtils._dateTime(t,["fullYear","month","date"],!0):null;if(null===t)return t;if(this._inDisabled(u)){var c=function(t){return r=s?i.applyParameters(s,{value:t}):i.getTranslatedString("oj-validator.restriction.date.messageSummary",{value:t}),o=l?i.applyParameters(l,{value:t}):i.getTranslatedString("oj-validator.restriction.date.messageDetail",{value:t}),[r,o]}(t?this._converter.format(t):t);throw new a.ValidatorError(c[0],c[1])}return t},s.prototype.getHint=function(){return null},s});
//# sourceMappingURL=ojvalidator-daterestriction.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojdatetimepicker',["ojs/ojcore","jquery","ojs/ojeditablevalue","ojs/ojinputtext","ojs/ojconverterutils","ojs/ojanimation","ojs/ojpopup","ojs/ojbutton","ojs/ojcore-base","hammerjs","ojs/ojcomponentcore","ojs/ojconverterutils-i18n","ojs/ojvalidator-datetimerange","ojs/ojvalidator-daterestriction","ojs/ojconverter-datetime","ojs/ojlocaledata","ojs/ojlogger","ojs/ojthemeutils","ojs/ojcontext","ojs/ojfocusutils","ojs/ojdomutils","ojs/ojconfig","ojs/ojlabelledbyutils","ojs/ojconverter-preferences"],function(e,t,i,n,r,a,s,o,l,c,u,h,d,p,_,m,f,v,g,y,D,k,b,S){"use strict";t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t,l=l&&Object.prototype.hasOwnProperty.call(l,"default")?l.default:l,d=d&&Object.prototype.hasOwnProperty.call(d,"default")?d.default:d,p=p&&Object.prototype.hasOwnProperty.call(p,"default")?p.default:p,g=g&&Object.prototype.hasOwnProperty.call(g,"default")?g.default:g,y=y&&Object.prototype.hasOwnProperty.call(y,"default")?y.default:y,b=b&&Object.prototype.hasOwnProperty.call(b,"default")?b.default:b,function(){var e={properties:{readonly:{binding:{consume:{name:"readonly"}}},userAssistanceDensity:{binding:{consume:{name:"userAssistanceDensity"}}},labelEdge:{binding:{consume:{name:"labelEdge"}}}}},t={properties:{asyncValidators:{type:"Array<Object>",value:[]},autocomplete:{type:"string",value:"on",extension:{_COPY_TO_INNER_ELEM:!0}},autofocus:{type:"boolean",value:!1,extension:{_COPY_TO_INNER_ELEM:!0}},converter:{type:"object"},describedBy:{type:"string"},disabled:{type:"boolean",value:!1},displayOptions:{type:"object",properties:{converterHint:{type:"Array<string>|string"},helpInstruction:{type:"Array<string>|string",value:["notewindow"]},messages:{type:"Array<string>|string"},validatorHint:{type:"Array<string>|string"}}},help:{type:"object",properties:{instruction:{type:"string",value:""}}},helpHints:{type:"object",properties:{definition:{type:"string",value:""},source:{type:"string",value:""}}},keyboardEdit:{type:"string",enumValues:["disabled","enabled"]},labelEdge:{type:"string",enumValues:["inside","none","provided"]},labelHint:{type:"string",value:""},labelledBy:{type:"string"},max:{type:"string"},messagesCustom:{type:"Array<Object>",writeback:!0,value:[]},min:{type:"string"},name:{type:"string",value:"",extension:{_COPY_TO_INNER_ELEM:!0}},pickerAttributes:{type:"object",properties:{class:{type:"string"},style:{type:"string"}}},placeholder:{type:"string"},rawValue:{type:"string",writeback:!0,readOnly:!0},readonly:{type:"boolean",value:!1},renderMode:{type:"string",enumValues:["jet","native"]},required:{type:"boolean",value:!1},timePicker:{type:"object",properties:{footerLayout:{type:"string",enumValues:["","now"],value:""},showOn:{type:"string",enumValues:["focus","image","userFocus"],value:"focus"},timeIncrement:{type:"string",value:"00:05:00:00"}}},translations:{type:"object",value:{},properties:{accessibleMaxLengthExceeded:{type:"string"},accessibleMaxLengthRemaining:{type:"string"},ampmWheelLabel:{type:"string"},cancelText:{type:"string"},currentTimeText:{type:"string"},dateTimeRange:{type:"object",properties:{hint:{type:"object",properties:{inRange:{type:"string"},max:{type:"string"},min:{type:"string"}}},messageDetail:{type:"object",properties:{rangeOverflow:{type:"string"},rangeUnderflow:{type:"string"}}},messageSummary:{type:"object",properties:{rangeOverflow:{type:"string"},rangeUnderflow:{type:"string"}}}}},hourWheelLabel:{type:"string"},minuteWheelLabel:{type:"string"},okText:{type:"string"},regexp:{type:"object",properties:{messageDetail:{type:"string"},messageSummary:{type:"string"}}},required:{type:"object",properties:{hint:{type:"string"},messageDetail:{type:"string"},messageSummary:{type:"string"}}},tooltipTime:{type:"string"},tooltipTimeDisabled:{type:"string"}}},userAssistanceDensity:{type:"string",enumValues:["compact","efficient","reflow"],value:"reflow"},valid:{type:"string",writeback:!0,enumValues:["invalidHidden","invalidShown","pending","valid"],readOnly:!0},validators:{type:"Array<Object>",value:[]},value:{type:"string",writeback:!0}},methods:{getProperty:{},hide:{},refresh:{},reset:{},setProperties:{},setProperty:{},show:{},showMessages:{},validate:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojAnimateEnd:{},ojAnimateStart:{}},extension:{}};t.extension._WIDGET_NAME="ojInputTime",t.extension._INNER_ELEM="input",t.extension._GLOBAL_TRANSFER_ATTRS=["accesskey","aria-label","tabindex"],t.extension._ALIASED_PROPS={readonly:"readOnly"},l.CustomElementBridge.register("oj-input-time",{metadata:l.CollectionUtils.mergeDeep(t,e)});var i={properties:{asyncValidators:{type:"Array<Object>",value:[]},autocomplete:{type:"string",value:"on",extension:{_COPY_TO_INNER_ELEM:!0}},autofocus:{type:"boolean",value:!1,extension:{_COPY_TO_INNER_ELEM:!0}},converter:{type:"object"},datePicker:{type:"object",properties:{changeMonth:{type:"string",enumValues:["none","select"],value:"select"},changeYear:{type:"string",enumValues:["none","select"],value:"select"},currentMonthPos:{type:"number",value:0},daysOutsideMonth:{type:"string",enumValues:["hidden","selectable","visible"],value:"hidden"},footerLayout:{type:"string",enumValues:["","today"],value:"today"},numberOfMonths:{type:"number",value:1},showOn:{type:"string",enumValues:["focus","image","userFocus"],value:"focus"},stepBigMonths:{type:"number",value:12},stepMonths:{type:"string|number",value:"numberOfMonths"},weekDisplay:{type:"string",enumValues:["none","number"],value:"none"},yearRange:{type:"string",value:"c-10:c+10"}}},dayFormatter:{type:"function"},dayMetaData:{type:"object"},describedBy:{type:"string"},disabled:{type:"boolean",value:!1},displayOptions:{type:"object",properties:{converterHint:{type:"Array<string>|string"},helpInstruction:{type:"Array<string>|string",value:["notewindow"]},messages:{type:"Array<string>|string"},validatorHint:{type:"Array<string>|string"}}},help:{type:"object",properties:{instruction:{type:"string",value:""}}},helpHints:{type:"object",properties:{definition:{type:"string",value:""},source:{type:"string",value:""}}},keyboardEdit:{type:"string",enumValues:["disabled","enabled"]},labelEdge:{type:"string",enumValues:["inside","none","provided"]},labelHint:{type:"string",value:""},labelledBy:{type:"string"},max:{type:"string"},messagesCustom:{type:"Array<Object>",writeback:!0,value:[]},min:{type:"string"},name:{type:"string",value:"",extension:{_COPY_TO_INNER_ELEM:!0}},pickerAttributes:{type:"object",properties:{class:{type:"string"},style:{type:"string"}}},placeholder:{type:"string"},rawValue:{type:"string",writeback:!0,readOnly:!0},readonly:{type:"boolean",value:!1},renderMode:{type:"string",enumValues:["jet","native"]},required:{type:"boolean",value:!1},translations:{type:"object",value:{},properties:{accessibleMaxLengthExceeded:{type:"string"},accessibleMaxLengthRemaining:{type:"string"},currentText:{type:"string"},dateRestriction:{type:"object",properties:{hint:{type:"string"},messageDetail:{type:"string"},messageSummary:{type:"string"}}},dateTimeRange:{type:"object",properties:{hint:{type:"object",properties:{inRange:{type:"string"},max:{type:"string"},min:{type:"string"}}},messageDetail:{type:"object",properties:{rangeOverflow:{type:"string"},rangeUnderflow:{type:"string"}}},messageSummary:{type:"object",properties:{rangeOverflow:{type:"string"},rangeUnderflow:{type:"string"}}}}},nextText:{type:"string"},prevText:{type:"string"},regexp:{type:"object",properties:{messageDetail:{type:"string"},messageSummary:{type:"string"}}},required:{type:"object",properties:{hint:{type:"string"},messageDetail:{type:"string"},messageSummary:{type:"string"}}},tooltipCalendar:{type:"string"},tooltipCalendarDisabled:{type:"string"},tooltipCalendarTime:{type:"string"},tooltipCalendarTimeDisabled:{type:"string"},weekHeader:{type:"string"}}},userAssistanceDensity:{type:"string",enumValues:["compact","efficient","reflow"],value:"reflow"},valid:{type:"string",writeback:!0,enumValues:["invalidHidden","invalidShown","pending","valid"],readOnly:!0},validators:{type:"Array<Object>",value:[]},value:{type:"string",writeback:!0}},methods:{getProperty:{},hide:{},refresh:{},reset:{},setProperties:{},setProperty:{},show:{},showMessages:{},validate:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojAnimateEnd:{},ojAnimateStart:{}},extension:{}};i.extension._WIDGET_NAME="ojInputDate",i.extension._INNER_ELEM="input",i.extension._GLOBAL_TRANSFER_ATTRS=["accesskey","aria-label","tabindex"],i.extension._ALIASED_PROPS={readonly:"readOnly"},l.CollectionUtils.mergeDeep(i,e),l.CustomElementBridge.register("oj-input-date",{metadata:i});var n=Object.assign({},i);n.extension._INNER_ELEM="div",l.CustomElementBridge.register("oj-date-picker",{metadata:n});var r={properties:{asyncValidators:{type:"Array<Object>",value:[]},autocomplete:{type:"string",value:"on",extension:{_COPY_TO_INNER_ELEM:!0}},autofocus:{type:"boolean",value:!1,extension:{_COPY_TO_INNER_ELEM:!0}},converter:{type:"object"},datePicker:{type:"object",properties:{changeMonth:{type:"string",enumValues:["none","select"],value:"select"},changeYear:{type:"string",enumValues:["none","select"],value:"select"},currentMonthPos:{type:"number",value:0},daysOutsideMonth:{type:"string",enumValues:["hidden","selectable","visible"],value:"hidden"},footerLayout:{type:"string",enumValues:["","today"],value:"today"},numberOfMonths:{type:"number",value:1},showOn:{type:"string",enumValues:["focus","image","userFocus"],value:"focus"},stepBigMonths:{type:"number",value:12},stepMonths:{type:"string|number",value:"numberOfMonths"},weekDisplay:{type:"string",enumValues:["none","number"],value:"none"},yearRange:{type:"string",value:"c-10:c+10"}}},dayFormatter:{type:"function"},dayMetaData:{type:"object"},describedBy:{type:"string"},disabled:{type:"boolean",value:!1},displayOptions:{type:"object",properties:{converterHint:{type:"Array<string>|string"},helpInstruction:{type:"Array<string>|string",value:["notewindow"]},messages:{type:"Array<string>|string"},validatorHint:{type:"Array<string>|string"}}},help:{type:"object",properties:{instruction:{type:"string",value:""}}},helpHints:{type:"object",properties:{definition:{type:"string",value:""},source:{type:"string",value:""}}},keyboardEdit:{type:"string",enumValues:["disabled","enabled"]},labelEdge:{type:"string",enumValues:["inside","none","provided"]},labelHint:{type:"string",value:""},labelledBy:{type:"string"},max:{type:"string"},messagesCustom:{type:"Array<Object>",writeback:!0,value:[]},min:{type:"string"},name:{type:"string",value:"",extension:{_COPY_TO_INNER_ELEM:!0}},pickerAttributes:{type:"object",properties:{class:{type:"string"},style:{type:"string"}}},placeholder:{type:"string"},rawValue:{type:"string",writeback:!0,readOnly:!0},readonly:{type:"boolean",value:!1},renderMode:{type:"string",enumValues:["jet","native"]},required:{type:"boolean",value:!1},timePicker:{type:"object",properties:{footerLayout:{type:"string",enumValues:["","now"],value:""},showOn:{type:"string",enumValues:["focus","image","userFocus"],value:"focus"},timeIncrement:{type:"string",value:"00:05:00:00"}}},translations:{type:"object",value:{},properties:{accessibleMaxLengthExceeded:{type:"string"},accessibleMaxLengthRemaining:{type:"string"},cancel:{type:"string"},currentText:{type:"string"},dateRestriction:{type:"object",properties:{hint:{type:"string"},messageDetail:{type:"string"},messageSummary:{type:"string"}}},dateTimeRange:{type:"object",properties:{hint:{type:"object",properties:{inRange:{type:"string"},max:{type:"string"},min:{type:"string"}}},messageDetail:{type:"object",properties:{rangeOverflow:{type:"string"},rangeUnderflow:{type:"string"}}},messageSummary:{type:"object",properties:{rangeOverflow:{type:"string"},rangeUnderflow:{type:"string"}}}}},done:{type:"string"},nextText:{type:"string"},prevText:{type:"string"},regexp:{type:"object",properties:{messageDetail:{type:"string"},messageSummary:{type:"string"}}},required:{type:"object",properties:{hint:{type:"string"},messageDetail:{type:"string"},messageSummary:{type:"string"}}},time:{type:"string"},tooltipCalendar:{type:"string"},tooltipCalendarDisabled:{type:"string"},tooltipCalendarTime:{type:"string"},tooltipCalendarTimeDisabled:{type:"string"},weekHeader:{type:"string"}}},userAssistanceDensity:{type:"string",enumValues:["compact","efficient","reflow"],value:"reflow"},valid:{type:"string",writeback:!0,enumValues:["invalidHidden","invalidShown","pending","valid"],readOnly:!0},validators:{type:"Array<Object>",value:[]},value:{type:"string",writeback:!0}},methods:{getProperty:{},hide:{},hideTimePicker:{},refresh:{},reset:{},setProperties:{},setProperty:{},show:{},showMessages:{},showTimePicker:{},validate:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojAnimateEnd:{},ojAnimateStart:{}},extension:{}};r.extension._WIDGET_NAME="ojInputDateTime",r.extension._INNER_ELEM="input",r.extension._GLOBAL_TRANSFER_ATTRS=["accesskey","aria-label","tabindex"],r.extension._ALIASED_PROPS={readonly:"readOnly"},l.CollectionUtils.mergeDeep(r,e),l.CustomElementBridge.register("oj-input-date-time",{metadata:r});var a=Object.assign({},r);a.extension._INNER_ELEM="div",l.CustomElementBridge.register("oj-date-time-picker",{metadata:a})}();var C,w,I=(v.parseJSONFromFontFamily("oj-inputdatetime-option-defaults")||{}).converterYear||"numeric";function j(){return"phone"!==k.getDeviceRenderMode()}function E(e,t){t=e.parse(t);var i,n=new Date;try{i=h.IntlConverterUtils._dateTime(t,["date","fullYear","month","hours","minutes","seconds"],!0)}catch(e){return f.info("The value of the InputDateTime element should be an ISOString, please use a valid ISOString"),n.setHours(0),n.setMinutes(0),n.setSeconds(0),n.setMilliseconds(0),n}return n.setFullYear(i.fullYear),n.setDate(i.date),n.setMonth(i.month),n.setHours(i.hours),n.setMinutes(i.minutes),n.setSeconds(i.seconds),n.setMilliseconds(0),n}function P(e){return this.options.converter&&this.options.converter.parse?this.options.converter.parse(e):e}function O(e,i,n){var r=e.translations.dateTimeRange||{},a=[{category:"hint",entries:["min","max","inRange"]},{category:"messageDetail",entries:["rangeUnderflow","rangeOverflow"]},{category:"messageSummary",entries:["rangeUnderflow","rangeOverflow"]}],s={min:e.min,max:e.max,converter:i,translationKey:{"oj-inputdatetime":"datetime","oj-inputtime":"time","oj-inputdate":"date"}[n]};if(!t.isEmptyObject(r))for(var o=0,l=a.length;o<l;o++){var c=r[a[o].category];if(c){for(var u={},h=a[o].entries,p=0,_=h.length;p<_;p++)u[h[p]]=c[h[p]];s[a[o].category]=u}}return new d(s)}function T(e,i){var n={dayFormatter:e.dayFormatter,converter:i};return t.extend(n,e.translations.dateRestriction||{}),new p(n)}function A(e,t){for(var i=0;i<e.length;i++){var n=e[i];"SPAN"===n.tagName&&(t?(n.classList.add("oj-disabled"),n.classList.remove("oj-enabled"),n.classList.remove("oj-default")):(n.classList.remove("oj-disabled"),n.classList.add("oj-enabled"),n.classList.add("oj-default")))}}function L(e,t,i){if(!e||t===i.length)return e;var n=t+1;return L(e[i[t]],n,i)||L(e["*"],n,i)}function M(){const e=S.getDateTimePreferences();return e&&e.dateStyle&&e.dateStyle.short?new _.IntlDateTimeConverter({formatType:"date",dateFormat:"short"}):new _.IntlDateTimeConverter({day:"2-digit",month:"2-digit",year:I})}function N(e){var i;i=e._isInLine?e.element[0].parentNode:e.element[0].parentNode.parentNode,e._AddActiveable(t(i))}function R(e){return"native"===e.options.renderMode&&window.cordova&&window.datePicker}function x(e,t){return w||(w=new _.IntlDateTimeConverter({year:"numeric"})),w.format(h.IntlConverterUtils.dateToLocalIso(new Date(e,t,1)))}function V(e,t){var i,n,r,a,s,o,l,c=[150,100,50,25,16],u=0,h=e,d=0,p=0,_=1,m=1,f=1,v="",g=1,y=!1,D=this;function k(){if(t)for(var e=Object.keys(t),i=0;i<e.length;i++){var n=e[i];D[n]=t[n]}}function b(){var e=!1,t=h.value;D.value=j(t);var l,c=h.max;l=E(t)===E(c)?j(c)+1:m,r!==l&&(e=!0,r=l);var u,d=h.min;u=E(t)===E(d)?j(d):0,n!==u&&(e=!0,n=u);var p=h.increment,_=function e(t,i){if(0===i)return t;return e(i,t%i)}(p,o);_===o?(n=0,r=1,e=!0):D.linked&&p>s?_=p:0===w(_,s)?_/=s:_=1,f!==_&&(f=_,e=!0),i=Math.floor(m/f),a=i>4,D.wheel&&e&&D.wheel.ojRefresh()}function S(){o=s*m,l=g*_}function C(){if(D.wheel){c.forEach(function(e){D.wheel.classList.remove("oj-timepicker-wheel-spin-"+e)});var e,t=Math.abs(d-p);if(0!==t)t-=1,t=Math.min(t,c.length-1),e=c[t],D.wheel.classList.add("oj-timepicker-wheel-spin-"+c[t]),d>p&&(p+=1,D.wheel.ojSpinUp()),d<p&&(p-=1,D.wheel.ojSpinDown()),e&&(h.disableSpin?C.call(D):setTimeout(C.bind(D),e));else y=!1}}function w(e,t){return(e%t+t)%t}function I(e,t){return Math.floor(e/o)*o+w(t,m)*s+w(e,s)}function j(e){return w(Math.floor(e/s),m)}function E(e){return Math.floor(e/o)}Object.defineProperty(D,"position",{enumerable:!0,get:function(){return d},set:function(e){var t=w(e,i)*f;t>=n&&t<r&&e!==d&&(D.value+=(e-d)*f)}}),Object.defineProperty(D,"value",{enumerable:!0,get:function(){return u},set:function(e){var t,s,o,l=Math.round(e/f)*f;(function(e){return!!a||n<=e&&e<r})(l)&&u!==l&&(u=w(l,m),t=w(function(e){return Math.floor(e/f)}(u),i),s=w(D.position,i),o=t-s,a&&(t>s?s+i-t<Math.abs(o)&&(o=t-s-i):t+i-s<Math.abs(o)&&(o=t+i-s)),0!==o&&(d+=o,D.wheel?y||(y=!0,C.call(D)):p=d),D.linked&&(2===m&&(h.disableSpin=!0),h.value=I(h.value,u),h.disableSpin=!1))}}),Object.defineProperty(D,"increment",{enumerable:!0,get:function(){return f},set:function(e){f!==e&&(f=e,S())}}),Object.defineProperty(D,"valueMultiplier",{enumerable:!0,get:function(){return s},set:function(e){s!==e&&(s=e,S())}}),Object.defineProperty(D,"valueRange",{enumerable:!0,get:function(){return m},set:function(e){m!==e&&(m=e,S())}}),Object.defineProperty(D,"displayMultiplier",{enumerable:!0,get:function(){return g},set:function(e){g!==e&&(g=e,S())}}),Object.defineProperty(D,"displayRange",{enumerable:!0,get:function(){return _},set:function(e){_!==e&&(_=e,S())}}),Object.defineProperty(D,"keyboardValue",{enumerable:!0,get:function(){return v},set:function(e){if(v=e,D.parser&&v){var t=D.parser(v);t>=0&&(i=u,a=t,t=Math.floor(i/l)*l+w(a,_)*g+w(i,g),n<=t&&t<r&&(D.value=t)),v.length>=2?v="":setTimeout(function(){v=""},1e3)}var i,a}}),D.getText=function(e){var t,n=w(p,i)+e,r=a||n>=0&&n<i;if(D.formatter&&r){var s=function(e){return t=function(e){return w(w(e,i)*f,m)}(e),w(Math.floor(t/g),_);var t}(p+e);t=D.formatter(s)}return t},D.isDisabled=function(e){var t=w(p+e,i)*f;return 0!==n&&t<n||r!==m&&t>=r},D.update=function(){h.value=I(h.value,u)},D.refresh=b,D.setProperties=k,k()}function Y(e){var t,i,n,r=/^.*T(\d{2})(?::?(\d{2}).*$)/,a={h:function(e){if(0===e)return"12";return""+e},hh:function(e){if(0===e)return"12";return(e="0"+e).slice(-2)},H:function(e){return""+e},HH:I,k:function(e){if(0===e)return"24";return""+e},kk:function(e){if(0===e)return"24";return(e="0"+e).slice(-2)},K:function(e){return""+e},KK:function(e){return(e="0"+e).slice(-2)},mm:j},s={h:P,hh:P,H:E,HH:E,k:O,kk:O,K:E,KK:E,mm:E},o=0,l=0,c=0,u=1440,h=1440,d="auto",p="",_=["AM","PM"],m=new V(this,{valueRange:60,displayRange:60,valueMultiplier:1,displayMultiplier:1}),v=new V(this,{valueMultiplier:60,displayMultiplier:1}),g=new V(this,{valueRange:2,displayRange:2,formatter:function(e){return _[e]},parser:function(e){if("a"===(e=e.toLowerCase().charAt()))return 0;if("p"===e)return 1;return-1},valueMultiplier:720,displayMultiplier:1}),y=[m,v,g],D=!1,k=this;function b(){try{if(D=!0,e)for(var t=Object.key(e),i=0;i<t.length;i++){var n=t[i];k[n]=e[n]}}finally{D=!1,S()}}function S(){if(!D){if(c=Math.ceil(l/t)*t,(h=Math.ceil((u-1)/t)*t)<c)throw new Error("Invalid min and max settings with current increment: "+l+" "+u+ +t);var e,i;if(o<c&&(o=c),o>h&&(o=h),o=Math.round(o/t)*t,n)switch(v.displayRange=12,"auto"===(e=d)&&((i=T(t,60))===t||60===i?e="hoursMeridiem":(i=T(t,720),e="all")),e){case"all":m.displayMultiplier=1,m.valueMultiplier=1,m.valueRange=1440,m.linked=!0,v.displayMultiplier=60,v.valueMultiplier=1,v.valueRange=1440,v.linked=!0,g.displayMultiplier=1,g.valueMultiplier=720,g.valueRange=2,g.linked=!0;break;case"hoursMeridiem":m.displayMultiplier=1,m.valueMultiplier=1,m.valueRange=60,m.linked=!1,v.displayMultiplier=1,v.valueMultiplier=60,v.valueRange=24,v.linked=!0,g.displayMultiplier=1,g.valueMultiplier=720,g.valueRange=2,g.linked=!0}else switch(v.displayRange=24,"auto"===(e=d)&&(e=(i=T(t,60))===t||60===i?"none":"all"),e){case"none":case"hoursMeridiem":m.displayMultiplier=1,m.valueMultiplier=1,m.valueRange=60,m.linked=!1,v.displayMultiplier=1,v.valueMultiplier=60,v.valueRange=24,v.linked=!1;break;case"all":case"hoursMinutes":m.displayMultiplier=1,m.valueMultiplier=1,m.valueRange=1440,m.linked=!0,v.displayMultiplier=60,v.valueMultiplier=1,v.valueRange=1440,v.linked=!0}for(var r=0;r<y.length;r++)y[r].refresh()}}function C(e){var t=0,i=0,n=r.exec(e);return n&&(t=parseInt(n[1],10),i=parseInt(n[2],10)),60*t+i}function w(e){e=Math.floor(e);var t=Math.floor(e/60);return e%=60,"T"+I(t)+":"+j(e)}function I(e){return(e="0"+e).slice(-2)}function j(e){return(e="0"+e).slice(-2)}function E(e){return e.match(/^\d+$/)?parseInt(e,10):-1}function P(e){if(e.match(/^\d+$/)){var t=parseInt(e,10);return 0===t&&(t=-1),24===t&&(t=0),t}return-1}function O(e){if(e.match(/^\d+$/)){var t=parseInt(e,10);return 0===t&&(t=-1),24===t&&(t=0),t}return-1}function T(e,t){return 0===t?e:T(t,e%t)}D=!0,Object.defineProperty(k,"increment",{enumerable:!0,get:function(){return t},set:function(e){t=Math.floor(e),S()}}),k.increment=1,Object.defineProperty(k,"grouped",{enumerable:!0,get:function(){return d},set:function(e){switch(e){case"auto":case"all":case"none":case"hoursMinutes":case"hoursMeridiem":d=e;break;default:throw new Error("invalid grouped value: "+e)}S()}}),Object.defineProperty(k,"min",{enumerable:!0,get:function(){return l},set:function(e){l=Math.floor(e),S()}}),Object.defineProperty(k,"isoMin",{enumerable:!0,get:function(){return w(l)},set:function(e){var t=C(e);isNaN(t)?f.error("Invalid ISO min time: %s",e):k.min=t}}),Object.defineProperty(k,"max",{enumerable:!0,get:function(){return u-1},set:function(e){u=Math.floor(e)+1,S()}}),Object.defineProperty(k,"isoMax",{enumerable:!0,get:function(){return w(u)},set:function(e){var t=C(e);isNaN(t)?f.error("Invalid ISO max time: %s",e):k.max=t}}),Object.defineProperty(k,"value",{enumerable:!0,get:function(){return o},set:function(e){o=Math.floor(e),S()}}),Object.defineProperty(k,"isoValue",{enumerable:!0,get:function(){return w(o)},set:function(e){var t=C(e);isNaN(t)?f.error("Invalid ISO value time: %s",e):k.value=t}}),Object.defineProperty(k,"format",{enumerable:!0,get:function(){return i},set:function(e){i=e;var t=e.replace(/'[^']*'/g,"").replace(/[^hHkKma]*/g,""),r=t.match(/([hHkK]+)/),o=r[1];v.formatter=a[o],v.parser=s[o];var l=(r=t.match(/(m+)/))[1];m.formatter=a[l],m.parser=s[l],n=p.indexOf("a")>=0,S()}}),Object.defineProperty(k,"wheelOrder",{enumerable:!0,get:function(){return p},set:function(e){p=e}}),Object.defineProperty(k,"ampmStrings",{enumerable:!0,get:function(){return _},set:function(e){_=e}}),D=!1,k.setProperties=b,b(),k.getWheelModel=function(e){switch(e){case"hour":return v;case"minute":return m;case"ampm":return n?g:null;default:return}}}function F(e,i,n){var r,a,s=!1;function o(){r.parentNode.focus()}var l=e.getText(i);if(l){(r=document.createElement("div")).classList.add("oj-timepicker-wheel-item"),r.classList.add("oj-timepicker-wheel-item-position"+i),a=i,e.isDisabled(i)&&(s=!0,r.classList.add("oj-disabled")),r.ojUpdatePosition=function(e){return r.classList.remove("oj-timepicker-wheel-item-position"+a),r.classList.add("oj-timepicker-wheel-item-position"+e),a=e,Promise.resolve()};var c=document.createElement("div");c.textContent=l,c.classList.add("oj-timepicker-wheel-item-content"),n&&c.setAttribute("title",l),r.appendChild(c),Object.defineProperty(r,"ojDisabled",{enumerable:!0,get:function(){return s},set:function(e){e!==s&&(t(r).toggleClass("oj-disabled"),s=e)}}),r.addEventListener("focus",o,!1),c.addEventListener("focus",o,!1)}return r}function G(e,i,n){var r,a,s,o,l,u=[.152,.362,.638,.848],h=e,d=[],p=!i&&"oj-timepicker-meridian"===n;!function(){(r=document.createElement("div")).classList.add("oj-timepicker-wheel"),n&&r.classList.add(n);r.setAttribute("id","_ojWheel"+G.counter),G.counter+=1,r.setAttribute("tabIndex","0"),r.setAttribute("role","spinbutton"),h.wheel=r}();var _,m=t(r);return r.ojSpinUp=v,r.ojSpinDown=g,r.ojRefresh=D,r.ojDestroy=f,r.ojLinked=function(){return h.linked},_={recognizers:[[c.Pan,{direction:c.DIRECTION_VERTICAL}],[c.Tap],[c.Swipe,{direction:c.DIRECTION_VERTICAL}]]},m.ojHammer(_).on("tap",S).on("swipeup",C).on("swipedown",w).on("panstart",I).on("panend pancancel",j).on("panup pandown",E),r.addEventListener("wheel",P,{passive:!1}),r.addEventListener("keydown",b,!1),r.addEventListener("focus",O,!1),r.addEventListener("blur",T,!1),D(),r;function f(){m.ojHammer().off("tap",S).off("swipeup",C).off("swipedown",w).off("panstart",I).off("panend pancancel",j).off("panup pandown",E),m.ojHammer("destroy")}function v(){if(d[8]){y(1);var e=d.shift();e&&r.removeChild(e);var t=F(h,7,p);t&&r.appendChild(t),d.push(t)}}function g(){if(d[6]){y(-1);var e=d.pop();e&&r.removeChild(e);var t=F(h,-7,p);t&&r.insertBefore(t,d[0]),d.unshift(t)}}function y(e){for(var t=0;t<d.length;t++){var i=d[t];i&&i.ojUpdatePosition(t-7-e)}k(h.getText(0))}function D(){d.forEach(function(e){e&&r.removeChild(e)}),d=[];for(var e=-7;e<=7;e++){var t=F(h,e,p);t&&r.appendChild(t),d.push(t)}k(h.getText(0))}function k(e){isNaN(e)?(r.removeAttribute("aria-valuenow"),r.setAttribute("aria-valuetext",e)):(r.removeAttribute("aria-valuetext"),r.setAttribute("aria-valuenow",e))}function b(e){var t=e.keyCode;switch(t){case 38:h.position+=1,e.preventDefault();break;case 40:h.position-=1,e.preventDefault();break;case 8:h.keyboardValue=h.keyboardValue.slice(0,-1),e.preventDefault();break;default:(t>47&&t<58||t>95&&t<112||!i&&t>64&&t<91)&&(h.keyboardValue+=e.key)}}function S(e){r.focus();for(var t=(e.gesture.center.y-r.getBoundingClientRect().top)/m.height(),i=0;i<4&&t>u[i];)i+=1;2!==i&&(h.position+=i-2)}function C(e){r.focus();var t=e.gesture.velocityY,i=t*t/.007;l=Math.floor(i/m.height()*5),e.preventDefault()}function w(e){r.focus();var t=e.gesture.velocityY,i=t*t/.007;l=-Math.floor(i/m.height()*5),e.preventDefault()}function I(e){r.focus(),s=e.gesture.center.y,a=s,o=0,l=0}function j(){r.focus(),l&&(h.position+=l),a=null,s=null,o=null}function E(e){r.focus();var t=e.gesture.center.y,i=Math.round((a-t)/m.height()*5);i!==o&&Math.abs(s-t)>2&&(s=t,h.position+=i-o,o=i),e.preventDefault()}function P(e){e.deltaY&&(e.currentTarget.focus(),e.preventDefault()),e.deltaY<0&&(h.position+=1),e.deltaY>0&&(h.position-=1)}function O(){h.keyboardValue="",r.classList.add("oj-focus")}function T(){r.classList.remove("oj-focus"),h.update()}}function U(e){var i,n=[];return(i=document.createElement("div")).classList.add("oj-timepicker-wheel-group"),i.ojRefresh=o,i.addEventListener("keydown",r,!1),o(),i;function r(e){var i=e.target;switch(e.keyCode){case 37:t(i).prev().focus();break;case 39:t(i).next().focus()}}function a(e){var t=e.target;if(t.ojLinked())for(var i=0;i<n.length;i++)n[i].ojLinked()&&n[i].classList.add("oj-active");else t.classList.add("oj-active")}function s(){for(var e=0;e<n.length;e++)n[e].classList.remove("oj-active")}function o(){for(var t=i.firstChild;t;)t.ojDestroy(),i.removeChild(t),t=i.firstChild;n=[],function(){var t,r,o=e.wheelOrder,l=G(e.getWheelModel("hour"),!0,"oj-timepicker-hour"),c=G(e.getWheelModel("minute"),!0,"oj-timepicker-minute");o.indexOf("a")>=0&&(t=e.getWheelModel("ampm"),r=G(t,!1,"oj-timepicker-meridian"));var u,h=o.split("");for(u=0;u<h.length;u++)switch(h[u]){case"h":n.push(l);break;case"m":n.push(c);break;case"a":n.push(r);break;default:f.error("Unknown wheelOrder code: %s",h[u])}for(u=0;u<n.length;u++){var d=n[u];d.addEventListener("focus",a,!1),d.addEventListener("blur",s,!1),i.appendChild(d)}}()}}l.__registerWidget("oj.ojInputDate",t.oj.inputBase,{widgetEventPrefix:"oj",_CLASS_NAMES:"oj-inputdatetime-input",_WIDGET_CLASS_NAMES:"oj-inputdatetime-date-only oj-component oj-inputdatetime",_ELEMENT_TRIGGER_WRAPPER_CLASS_NAMES:"",_INPUT_HELPER_KEY:"inputHelp",_ATTR_CHECK:[{attr:"type",setMandatory:"text"}],_GET_INIT_OPTIONS_PROPS_FOR_WIDGET:[{attribute:"disabled",validateOption:!0},{attribute:"pattern"},{attribute:"title"},{attribute:"placeholder"},{attribute:"value",coerceDomValue:P},{attribute:"required",coerceDomValue:!0,validateOption:!0},{attribute:"readonly",option:"readOnly",validateOption:!0},{attribute:"min",coerceDomValue:P},{attribute:"max",coerceDomValue:P}],_TRIGGER_CLASS:"oj-inputdatetime-input-trigger",_TRIGGER_CALENDAR_CLASS:"oj-inputdatetime-calendar-icon",_CURRENT_CLASS:"oj-datepicker-current-day",_DAYOVER_CLASS:"oj-datepicker-days-cell-over",_UNSELECTABLE_CLASS:"oj-datepicker-unselectable",_DATEPICKER_DIALOG_DESCRIPTION_ID:"oj-datepicker-dialog-desc",_DATEPICKER_DESCRIPTION_ID:"oj-datepicker-desc",_CALENDAR_DESCRIPTION_ID:"oj-datepicker-calendar",_MAIN_DIV_ID:"oj-datepicker-div",_INLINE_CLASS:"oj-datepicker-inline",_INPUT_CONTAINER_CLASS:" oj-inputdatetime-input-container oj-text-field-container",_INLINE_WIDGET_CLASS:" oj-inputdatetime-inline",_ON_CLOSE_REASON_SELECTION:"selection",_ON_CLOSE_REASON_CANCELLED:"cancelled",_ON_CLOSE_REASON_TAB:"tab",_ON_CLOSE_REASON_CLOSE:"close",_KEYBOARD_EDIT_OPTION_ENABLED:"enabled",_KEYBOARD_EDIT_OPTION_DISABLED:"disabled",options:{datePicker:{footerLayout:"",changeMonth:"select",changeYear:"select",currentMonthPos:0,daysOutsideMonth:"hidden",numberOfMonths:1,showOn:"focus",stepMonths:"numberOfMonths",stepBigMonths:12,weekDisplay:"none",yearRange:"c-10:c+10"},converter:void 0,keyboardEdit:"enabled",max:void 0,min:void 0,pickerAttributes:null,rawValue:void 0,renderMode:"jet",dayFormatter:null},_InitBase:function(){this._triggerNode=null,this._inputContainer=null,this._redirectFocusToInputContainer=!1,this._isMobile=!1,this._ignoreDatePickerShow=!1,this._nativePickerShowing=!1,this._maxRows=4,this._currentDay=0,this._drawMonth=0,this._currentMonth=0,this._drawYear=0,this._currentYear=0,this._datePickerDefaultValidators={},this._nativePickerConverter=null,this._labelValueWrapper=null;var e=this.element[0].nodeName.toLowerCase();if(this._isInLine="div"===e||"span"===e,this._isInLine)this._createDpDiv(),this._WIDGET_CLASS_NAMES+=this._INLINE_WIDGET_CLASS,this._CLASS_NAMES="";else{this._ELEMENT_TRIGGER_WRAPPER_CLASS_NAMES+=this._INPUT_CONTAINER_CLASS,!0!==this.options.readOnly&&(this._createDpDiv(),this._createPopupDpDiv());var t=v.getCachedCSSVarValues(["--oj-private-core-global-dropdown-offset"])[0]||"0";this._dropdownVerticalOffset=parseInt(t,10)}},_UseReadonlyDiv:function(){return!this._isInLine&&this._superApply(arguments)},_GetDisplayValue:function(){return this._isInLine?this.options.value:this._superApply(arguments)},_createDpDiv:function(){var e=document.createElement("div");e.className="oj-datepicker-popup",e.style.display="none";var i=document.createElement("div");i.id=this._GetSubId(this._MAIN_DIV_ID),i.setAttribute("role","region"),i.setAttribute("aria-describedby",this._GetSubId(this._DATEPICKER_DESCRIPTION_ID)),i.className="oj-datepicker-content",e.appendChild(i),this._dpDiv=function(e){var t=".oj-datepicker-prev-icon, .oj-datepicker-prev-icon .oj-clickable-icon-nocontext.oj-component-icon, .oj-datepicker-next-icon, .oj-datepicker-next-icon .oj-clickable-icon-nocontext.oj-component-icon, .oj-datepicker-calendar td a";return e.delegate(t,"mouseout",function(){this.classList.remove("oj-hover")}).delegate(t,"mouseover",function(){this.classList.add("oj-hover")}).delegate(t,"focus",function(){this.classList.add("oj-focus")}).delegate(t,"blur",function(){this.classList.remove("oj-focus")})}(t(e)),document.body.appendChild(e)},_createPopupDpDiv:function(){var e=this;this._popUpDpDiv=this._dpDiv.ojPopup({initialFocus:"none",role:"dialog",modality:j()?"modeless":"modal",open:function(){e._popUpDpDiv.attr("aria-describedby",e._GetSubId(e._DATEPICKER_DIALOG_DESCRIPTION_ID)),"image"===e.options.datePicker.showOn&&e._dpDiv.find(".oj-datepicker-calendar").focus()},animation:{open:null,close:null}}).attr("data-oj-internal",""),this.element.attr("data-oj-popup-"+this._popUpDpDiv.attr("id")+"-parent","");var t=this.options.pickerAttributes;t&&i.EditableValueUtils.setPickerAttributes(this._popUpDpDiv.ojPopup("widget"),t)},_GetDefaultConverter:function(){return null==this._dateDefaultConverter&&(this._dateDefaultConverter=M()),this._dateDefaultConverter},_CreateConverters:function(){var e=this._GetConverter();if(e instanceof Promise){var t=this;this._resolveDateConverterBusyState=this._SetConverterBusyState("date"),this._dateConverterPromise=e.then(function(e){t._createNativeDatePickerConverter(e)})}else this._createNativeDatePickerConverter(e)},_ComponentCreate:function(){h.IntlConverterUtils._verifyValueMinMaxNoTime(this.options.value,this.options.min,this.options.max),this._CreateConverters(),this._InitBase();var e,t=this._super();if(this.options.dayMetaData&&(this.options.dayFormatter=(e=this.options.dayMetaData,function(t){return L(e,0,[t.fullYear,t.month,t.date])})),this._setCurrentDate(this._getDateIso(),!0),this._isInLine){this.element.append(this._dpDiv),this.element.addClass(this._INLINE_CLASS),this.element.addClass("oj-form-control-container"),this._dpDiv.css("display","block"),this._registerSwipeHandler();const e=this.widget();e[0].setAttribute("role","group"),this._labelledByUpdatedForSet(e[0].id,null,this.options.labelledBy,e)}else this._processReadOnlyKeyboardEdit(),!0!==this.options.readOnly&&(this._attachTrigger(),this._registerSwipeHandler());if(this._IsCustomElement()){let e=this._getRootElement(),t=this.GetFocusElement();e.focus=function(){t.focus(!0)};let i=Object.getPrototypeOf(t);t.focus=function(e){const n=this.options.datePicker.showOn;"focus"===n?this._ignoreDatePickerShow=!e:"userFocus"===n&&(this._ignoreDatePickerShow=!0),i.focus.call(t)}.bind(this)}return N(this),t},_SetConverterBusyState:function(e){var t=this.element[0],i=g.getContext(t).getBusyContext(),n="The page is waiting for async "+e+" converter loading ";return t&&t.id&&(n+='for "'+t.id+'" '),n+="to finish.",i.addBusyState({description:n})},_IsDisabled:function(){return this.options.disabled||!this._converterCached},_AfterCreate:function(){var e,t=this._superApply(arguments);if(this._disableEnable(this._IsDisabled()),!this._IsCustomElement()){var i=this.$label;this._inputContainer&&i&&1===i.length&&(e=i.attr("id"),this._inputContainer.attr("aria-labelledby",e))}return t},_AfterCreateConverterCached:function(){var e=this._super();this._converterCached=!0;var t=function(){this._disableEnable(this._IsDisabled()),this._resolveDateConverterBusyState&&(this._resolveDateConverterBusyState(),delete this._resolveDateConverterBusyState)}.bind(this);if(this._dateConverterPromise){var i=this;this._dateConverterPromise.then(function(){t(),delete i._dateConverterPromise})}else t();return e},_setValidatorOption:function(e,t){var i=this,n=function(t){i._datePickerDefaultValidators[e]=t,i._AfterSetOptionValidators()};t instanceof Promise?t.then(function(e){n(e)}):n(t)},_setOption:function(e,t,n){var r=null;if("value"===e){if(t||(t=null),h.IntlConverterUtils._verifyValueMinMaxNoTime(this.options.value,this.options.min,this.options.max),r=this._super(e,t,n),this._setCurrentDate(t),this._datepickerShowing()){var a=!(this._isInLine&&!this._dpDiv[0].contains(document.activeElement));this._updateDatepicker(a)}return r}if("dayMetaData"!==e){r=this._super(e,t,n),"disabled"===e?this._disableEnable(t):"max"===e||"min"===e?(h.IntlConverterUtils._verifyValueMinMaxNoTime(this.options.value,this.options.min,this.options.max),this._setValidatorOption("dateTimeRange",this._createDateTimeRangeValidator(this._GetConverter()))):"readOnly"===e?(this._isInLine||t||null!=this._dpDiv||(this._createDpDiv(),this._createPopupDpDiv(),this._attachTrigger(),this._registerSwipeHandler(),this._AppendInputHelper(),this._setupResizePopupBind()),this._disableEnable(this._IsDisabled()),this._processReadOnlyKeyboardEdit(),t&&this._hide(this._ON_CLOSE_REASON_CLOSE),this._AfterSetOptionDisabledReadOnly("readOnly",i.EditableValueUtils.readOnlyOptionOptions)):"keyboardEdit"===e?this._processReadOnlyKeyboardEdit():"dayFormatter"===e?this._setValidatorOption("dateRestriction",this._createDateRestrictionValidator(this._GetConverter())):"converter"===e&&(this._nativePickerConverter=null,this._localTZConverter=null),"datePicker"===e&&"currentMonthPos"===n.subkey&&this._setCurrentDate(this._getDateIso());return this._datepickerShowing()&&e in{max:!0,min:!0,dayFormatter:!0,datePicker:!0,translations:!0}&&this._updateDatepicker(),r}this.option("dayFormatter",function(e){return L(t,0,[e.fullYear,e.month,e.date])},n)},_processReadOnlyKeyboardEdit:function(){var e=this.options.readOnly||this._isKeyboardEditDisabled();this.element.prop("readOnly",!!e)},_isKeyboardEditDisabled:function(){return this.options.keyboardEdit===this._KEYBOARD_EDIT_OPTION_DISABLED},_AppendInputHelperParent:function(){return this._triggerNode},_setLabelledByForInputBase:function(e,t){if(this._isInLine){const i=this.widget();this._labelledByUpdatedForSet(i[0].id,e,t,i)}else this._super(e,t)},_initLabelledByForInputBase:function(e){if(this._isInLine){const t=this.widget();this._labelledByUpdatedForSet(t[0].id,null,e,t)}else this._super(e)},_destroy:function(){return this._cleanUpDateResources(),this._super()},_datepickerShowing:function(){return this._isInLine||this._popUpDpDiv&&u.isComponentInitialized(this._popUpDpDiv,"ojPopup")&&this._popUpDpDiv.ojPopup("isOpen")||this._nativePickerShowing},_SetupResources:function(){return this._isInLine||!0!==this.options.readOnly&&this._setupResizePopupBind(),this._super()},_SetLoading:function(){this._super(),this.element.prop("readOnly",!0),this._hide(this._ON_CLOSE_REASON_CLOSE)},_ClearLoading:function(){this._super(),this._processReadOnlyKeyboardEdit()},_setupResizePopupBind:function(){this._resizePopupBind=function(){u.isComponentInitialized(this._popUpDpDiv,"ojPopup")&&this._popUpDpDiv.ojPopup("option","modality",j()?"modeless":"modal")}.bind(this),window.addEventListener("resize",this._resizePopupBind,!1)},_ReleaseResources:function(){return this._IsCustomElement()&&this._cleanUpListeners(),this._super()},_cleanUpDateResources:function(){var e;e=this._isInLine?this.element[0].parentNode:this.element[0].parentNode.parentNode.parentNode,this._RemoveActiveable(t(e)),this.element.off("focus"),this.element[0].removeEventListener("touchstart",this._datepickerTouchStartListener,{passive:!1}),delete this._datepickerTouchStartListener,this._wrapper[0].removeEventListener("touchstart",this._datepickerWrapperTouchStartListener,{passive:!0}),delete this._datepickerWrapperTouchStartListener,this._triggerNode&&this._triggerNode.remove(),this._isInLine&&(this.element.removeProp("disabled"),this.element.removeProp("readonly")),this._cleanUpListeners(),this._animationResolve&&(this._animationResolve(),this._animationResolve=null),this._popUpDpDiv&&u.isComponentInitialized(this._popUpDpDiv,"ojPopup")&&this._popUpDpDiv.ojPopup("destroy"),this._dpDiv&&this._dpDiv.remove()},_cleanUpListeners:function(){this._resizePopupBind&&window.removeEventListener("resize",this._resizePopupBind)},_CreateContainerWrapper:function(){return this._inputContainer=t(this._superApply(arguments)),this._inputContainer.attr({role:"presentation",tabindex:"-1"}),this.element.attr({role:"combobox","aria-haspopup":"true"}),this._inputContainer[0]},_CreateMiddleWrapper:function(e){var t;return this._isInLine?this._labelValueWrapper=this.element[0]:(t=this._superApply(arguments),this._labelValueWrapper=t),t},_IsTextFieldComponent:function(){return!this._isInLine},_GetContentWrapper:function(){if(this._IsCustomElement()&&!this._isInLine)return this._getRootElement().querySelector(".oj-text-field-middle")},_onElementFocus:function(){this._redirectFocusToInputContainer?(this._redirectFocusToInputContainer=!1,this._inputContainer.focus()):this._showOnIsFocusOrUserFocus()?this.show():this._datepickerShowing()&&this._hide(this._ON_CLOSE_REASON_CLOSE)},_showOnIsFocusOrUserFocus:function(){var e=this.options.datePicker.showOn;return"focus"===e||"userFocus"===e},_OnElementTouchStart:function(e){e.preventDefault(),this._showOnIsFocusOrUserFocus()&&(this._datepickerShowing()?(this._ignoreDatePickerShow=!0,this._hide(this._ON_CLOSE_REASON_CLOSE)):(this._redirectFocusToInputContainer=!0,this._inputContainer.find("input")[0].focus(!0)))},_attachTrigger:function(){var e=this.options.datePicker.showOn,i=document.createElement("span");i.className=this._TRIGGER_CLASS;var n=document.createElement("span");n.setAttribute("title",this._GetCalendarTitle()),n.className=this._TRIGGER_CALENDAR_CLASS+" oj-clickable-icon-nocontext oj-component-icon",i.appendChild(n),this.element.on("focus",t.proxy(this._onElementFocus,this)),this._datepickerTouchStartListener=t.proxy(this._OnElementTouchStart,this),this.element[0].addEventListener("touchstart",this._datepickerTouchStartListener,{passive:!1});var r=this;this._datepickerWrapperTouchStartListener=function(){r._isMobile=!0},this._wrapper[0].addEventListener("touchstart",this._datepickerWrapperTouchStartListener,{passive:!0}),"image"===e&&(n.style.display="block",this._IsRTL()?(this.element.css("border-top-left-radius",0),this.element.css("border-bottom-left-radius",0)):(this.element.css("border-top-right-radius",0),this.element.css("border-bottom-right-radius",0))),n.addEventListener("click",function(e){r._datepickerShowing()?r._hide(r._ON_CLOSE_REASON_CLOSE):(r.show(),r._dpDiv.find(".oj-datepicker-calendar").focus()),e.preventDefault(),e.stopPropagation()});var a=t(n);this._AddHoverable(a),this._AddActiveable(a),this._triggerIcon=a,this._triggerNode=t(i),this._labelValueWrapper.parentNode.insertBefore(i,this._labelValueWrapper.nextElementSibling)},_doCalendarKeyDown:function(e){var i=!1,n=t.ui.keyCode,r=this._IsRTL();if(this._datepickerShowing())switch(e.keyCode){case 84:e.altKey&&e.ctrlKey&&(this._dpDiv.find(".oj-datepicker-current").focus(),i=!0);break;case n.TAB:break;case n.SPACE:case n.ENTER:var a=t("td."+this._DAYOVER_CLASS,this._dpDiv);return a[0]&&this._selectDay(this._currentMonth,this._currentYear,a[0],e),e.preventDefault(),e.stopPropagation(),!1;case n.ESCAPE:this._hide(this._ON_CLOSE_REASON_CANCELLED),this._isInLine||(i=!0);break;case n.PAGE_UP:e.ctrlKey&&e.altKey?this._adjustDate(-this.options.datePicker.stepBigMonths,"M",!0):e.altKey?this._adjustDate(-1,"Y",!0):this._adjustDate(-this._getStepMonths(),"M",!0),i=!0;break;case n.PAGE_DOWN:e.ctrlKey&&e.altKey?this._adjustDate(+this.options.datePicker.stepBigMonths,"M",!0):e.altKey?this._adjustDate(1,"Y",!0):this._adjustDate(+this._getStepMonths(),"M",!0),i=!0;break;case n.END:this._currentDay=this._getDaysInMonth(this._currentYear,this._currentMonth),this._changeCurrentDay(),i=!0;break;case n.HOME:this._currentDay=1,this._changeCurrentDay(),i=!0;break;case n.LEFT:e.originalEvent&&e.originalEvent.altKey||e.altKey?this._adjustDate(e.ctrlKey?-this.options.datePicker.stepBigMonths:-this._getStepMonths(),"M",!0):this._adjustDate(r?1:-1,"D",!0),i=!0;break;case n.UP:this._adjustDate(-7,"D",!0),i=!0;break;case n.RIGHT:e.originalEvent&&e.originalEvent.altKey||e.altKey?this._adjustDate(e.ctrlKey?+this.options.datePicker.stepBigMonths:+this._getStepMonths(),"M",!0):this._adjustDate(r?-1:1,"D",!0),i=!0;break;case n.DOWN:this._adjustDate(7,"D",!0),i=!0}i&&(e.preventDefault(),e.stopPropagation())},_changeCurrentDay:function(){var e,i=t("."+this._DAYOVER_CLASS,this._dpDiv),n=this._currentDay+"";if(1===i.length&&i.removeClass(this._DAYOVER_CLASS),e=this._isMultiMonth()?t("table.oj-datepicker-calendar.oj-focus",this._dpDiv):t("table.oj-datepicker-calendar",this._dpDiv),0===(i=t("a.oj-enabled:contains("+this._currentDay+")",e).filter(function(){return t(this).text()===n})).length&&(i=t("span.oj-disabled:contains("+this._currentDay+")",e).filter(function(){return t(this).text()===n})),1===i.length){var r=i.parent();e.addClass("oj-focus-highlight"),e.attr("aria-activedescendant",r.attr("id")+""),r.addClass(this._DAYOVER_CLASS),window.devicePixelRatio>=4&&r[0].scrollIntoView()}},_doMonthViewKeyDown:function(e){var i=!1,n=t.ui.keyCode,r=this._IsRTL();if(this._datepickerShowing())switch(e.keyCode){case 84:e.altKey&&e.ctrlKey&&(this._dpDiv.find(".oj-datepicker-current").focus(),i=!0);break;case n.SPACE:case n.ENTER:var a=t("td."+this._DAYOVER_CLASS,this._dpDiv);return a[0]&&this._selectMonthYear(a[0],"M"),e.preventDefault(),e.stopPropagation(),!1;case n.ESCAPE:this.hide(),this._isInLine||(i=!0);break;case n.PAGE_UP:e.ctrlKey&&e.altKey?this._adjustDate(-this.options.datePicker.stepBigMonths,"M",!0,"month"):e.altKey?this._adjustDate(-1,"Y",!0,"month"):this._adjustDate(-this._getStepMonths(),"M",!0,"month"),i=!0;break;case n.PAGE_DOWN:e.ctrlKey&&e.altKey?this._adjustDate(+this.options.datePicker.stepBigMonths,"M",!0,"month"):e.altKey?this._adjustDate(1,"Y",!0,"month"):this._adjustDate(+this._getStepMonths(),"M",!0,"month"),i=!0;break;case n.END:this._currentMonth=11,this._updateDatepicker(!0,"month"),i=!0;break;case n.HOME:this._currentMonth=0,this._updateDatepicker(!0,"month"),i=!0;break;case n.LEFT:this._adjustDate(r?1:-1,"M",!0,"month"),i=!0;break;case n.UP:this._adjustDate(-3,"M",!0,"month"),i=!0;break;case n.RIGHT:this._adjustDate(r?-1:1,"M",!0,"month"),i=!0;break;case n.DOWN:this._adjustDate(3,"M",!0,"month"),i=!0}i&&(e.preventDefault(),e.stopPropagation())},_doYearViewKeyDown:function(e){var i=!1,n=t.ui.keyCode,r=this._IsRTL();if(this._datepickerShowing())switch(e.keyCode){case 84:e.altKey&&e.ctrlKey&&(this._dpDiv.find(".oj-datepicker-current").focus(),i=!0);break;case n.SPACE:case n.ENTER:var a=t("td."+this._DAYOVER_CLASS,this._dpDiv);return a[0]&&this._selectMonthYear(a[0],"Y"),e.preventDefault(),e.stopPropagation(),!1;case n.ESCAPE:this.hide(),this._isInLine||(i=!0);break;case n.PAGE_UP:e.altKey&&this._adjustDate(-1,"Y",!0,"year"),i=!0;break;case n.PAGE_DOWN:e.altKey&&this._adjustDate(1,"Y",!0,"year"),i=!0;break;case n.END:this._currentYear=10*Math.floor(this._currentYear/10)+9,this._updateDatepicker(!0,"year"),i=!0;break;case n.HOME:this._currentYear=10*Math.floor(this._currentYear/10),this._updateDatepicker(!0,"year"),i=!0;break;case n.LEFT:this._adjustDate(r?1:-1,"Y",!0,"year"),i=!0;break;case n.UP:this._adjustDate(-3,"Y",!0,"year"),i=!0;break;case n.RIGHT:this._adjustDate(r?-1:1,"Y",!0,"year"),i=!0;break;case n.DOWN:this._adjustDate(3,"Y",!0,"year"),i=!0}i&&(e.preventDefault(),e.stopPropagation())},_getDatepickerContent:function(){return this._dpDiv?t(this._dpDiv.find(".oj-datepicker-content")[0]):t()},_isDateTimeSwitcher:function(){return this._dateTimeSwitcherActive},_updateDatepicker:function(e,t,i){var n;this._maxRows=4,(n="year"===t?this._generateViewHTML("Y"):"month"===t?this._generateViewHTML("M"):this._generateViewHTML("D")).html="<div"+(this._isDateTimeSwitcher()?"":" class='oj-datepicker-wrapper'")+">"+n.html+"</div>",this._currentView=t;var r=this._getDatepickerContent();if(i){var a=r.children().first();a.css({position:"absolute",left:0,top:0}),r.prepend(n.html);var s=r.children().first(),o="previous"===i?"end":"start";if(!this._animationResolve){var c=g.getContext(this.element[0]).getBusyContext();this._animationResolve=c.addBusyState({description:"The datepicker id='"+this.element.attr("id")+"' is animating."})}l.AnimationUtils.startAnimation(s[0],"open",{effect:"slideIn",direction:o});var u=l.AnimationUtils.startAnimation(a[0],"close",{effect:"slideOut",direction:o,persist:"all"}),h=this;u.then(function(){a&&a.remove(),h._setupNewView(e,t,n.dayOverId),h._animationResolve(),h._animationResolve=null})}else r.empty().append(n.html),this._setupNewView(e,t,n.dayOverId);window.devicePixelRatio>=4&&this._dpDiv[0].scrollIntoView();this._dpDiv.find(".oj-datepicker-prev-icon.oj-enabled, .oj-datepicker-next-icon.oj-enabled,.oj-datepicker-current, .oj-datepicker-month, .oj-datepicker-year, .oj-datepicker-calendar td a").click(e=>{e.preventDefault()})},_setupNewView:function(e,t,i){this._attachHandlers(),i&&this._dpDiv.find(".oj-datepicker-calendar").attr("aria-activedescendant",i);var n=this._getNumberOfMonths(),r=n[1],a=275;if(this._dpDiv.removeClass("oj-datepicker-multi-2 oj-datepicker-multi-3 oj-datepicker-multi-4").width(""),"year"===t||"month"===t)this._dpDiv.removeClass("oj-datepicker-multi");else{if((r=(n=this._getNumberOfMonths())[1])>1){var s=this._dpDiv.find(".oj-datepicker-calendar"),o=s.find("tbody a"),l=parseFloat(o.css("width")),c=parseFloat(s.css("margin-left"));isNaN(l)||isNaN(c)||(a=l*("number"===this.options.datePicker.weekDisplay?8:7)+2*c),this._dpDiv.addClass("oj-datepicker-multi-"+r).css("width",a*r+(this._isInLine?2:0)+"px")}this._dpDiv[(1!==n[0]||1!==n[1]?"add":"remove")+"Class"]("oj-datepicker-multi")}this._datepickerShowing()&&this.element.is(":visible")&&!this.element.is(":disabled")&&(e?this._placeFocusOnCalendar():this._isInLine||this.element[0]===document.activeElement||this.element.focus())},_placeFocusOnCalendar:function(){var e=this._dpDiv.find(".oj-datepicker-calendar");e[0]&&e[0]!==document.activeElement&&e[0].focus()},_adjustDate:function(e,t,i,n,r){this._IsDisabled()||(this._adjustInstDate(e+("M"===t?this.options.datePicker.currentMonthPos:0),t),this._updateDatepicker(i,n,r))},_getCurrentDate:function(e=this._GetConverter()){let t=new Date;const i=e&&e.resolvedOptions?e.resolvedOptions():null;if(i&&i.timeZone){const e=t.toISOString(),n=this._convertIsoStrFormatLocalWithTimezone(e,i.timeZone);t=h.IntlConverterUtils.isoToLocalDate(n)}return t},_convertIsoStrFormatLocalWithTimezone(e,t){return null==this._localTZConverter&&(this._localTZConverter=new _.IntlDateTimeConverter({timeZone:t,isoStrFormat:"local"})),this._localTZConverter.parse(e)},_calculateValueDateIso:function(e){let t;const i=this._getDateIso(),n=e&&e.resolvedOptions?e.resolvedOptions():null;return t=n&&n.timeZone?this._convertIsoStrFormatLocalWithTimezone(i,n.timeZone):i,t},_gotoToday:function(){let e=this._getCurrentDate();this._currentDay=e.getDate(),this._currentMonth=e.getMonth(),this._drawMonth=this._currentMonth,this._currentYear=e.getFullYear(),this._drawYear=this._currentYear,this._adjustDate(null,null,!0,"day")},_selectMonthYear:function(e,i){var n,r=this._getDateIso(),a=e.getAttribute("data-year"),s="";a&&(n=parseInt(a,10),this._currentYear=n,this._drawYear=n,s=n+"_"),"M"===i?(n=parseInt(e.getAttribute("data-month"),10),this._currentMonth=n,this._drawMonth=n,s=n+"_",r=this._validateDatetime(r,{fullYear:this._currentYear,month:this._currentMonth})):r=this._validateDatetime(r,{fullYear:this._currentYear}),t("#"+this._GetSubId(s+this._CALENDAR_DESCRIPTION_ID)).html(this._EscapeXSS(this.options.monthWide[this._drawMonth])+" "+x(this._drawYear,this._drawMonth)),this._adjustDate(0,0,!0,"M"===i?"day":this._toYearFromView)},_selectDay:function(e,i,n,r){if(!t(n).hasClass(this._UNSELECTABLE_CLASS)&&!this._IsDisabled()){this._isDateTimeSwitcher()||this._hide(this._ON_CLOSE_REASON_SELECTION),this._currentDay=t("a",n).html(),this._currentMonth=e,this._currentYear=i;var a=h.IntlConverterUtils,s=this.options.value,o=new Date(this._currentYear,this._currentMonth,this._currentDay);if(s)try{s=a._dateTime(s,{fullYear:o.getFullYear(),month:o.getMonth(),date:o.getDate()})}catch(e){f.info("The value of the InputDateTime element should be an ISOString, please use a valid ISOString"),s=a.dateToLocalIso(o)}else s=a.dateToLocalIso(o);this._setDisplayAndValue(s,{}),this._isDateTimeSwitcher()&&this._placeFocusOnCalendar()}},_setDisplayAndValue:function(e,t){if(this._isDateTimeSwitcher()){if(this._switcherDateValue=e,this._setCurrentDate(e),this._datepickerShowing()){var i=!(this._isInLine&&!this._dpDiv[0].contains(document.activeElement));this._updateDatepicker(i)}}else{var n=this._GetConverter().format(e);this._SetDisplayValue(n),this._SetValue(n,t)}},_getDefaultIsoDate:function(){return h.IntlConverterUtils.dateToLocalIso(this._getTodayDate())},_setCurrentDate:function(e,t){var i;i=this._validateDatetime(e||this._getDefaultIsoDate(),["fullYear","month","date"],!0),this._currentDay=i.date,this._currentMonth=i.month,this._isMultiMonth()&&!t||(this._drawMonth=i.month),this._currentYear=i.fullYear,this._currentMonth<this._drawMonth?this._drawYear=this._currentYear-1:this._drawYear=this._currentYear,this._adjustInstDate()},_getStepMonths:function(){var e=this.options.datePicker.stepMonths;return t.isNumeric(e)?e:this.options.datePicker.numberOfMonths},_isButtonActivated:function(e){return!this._IsDisabled()&&("click"===e.type||"keydown"===e.type&&(32===e.keyCode||13===e.keyCode))},_gotoPrev:function(e){null==this._animationResolve&&("year"===this._currentView?this._adjustDate(-10,"Y",!0,"year","previous"):"month"===this._currentView?this._adjustDate(-1,"Y",!0,"month","previous"):this._adjustDate(-e,"M",!0,"day","previous"))},_gotoNext:function(e){null==this._animationResolve&&("year"===this._currentView?this._adjustDate(10,"Y",!0,"year","next"):"month"===this._currentView?this._adjustDate(1,"Y",!0,"month","next"):this._adjustDate(+e,"M",!0,"day","next"))},_attachHandlers:function(){var e=this._getStepMonths(),i=this,n=function(e){if("keydown"===e.type){const n=t.ui.keyCode;switch(e.keyCode){case n.TAB:return!0;case n.ESCAPE:return i._hide(i._ON_CLOSE_REASON_CLOSE),!0}}return!1};this._dpDiv.find("[data-handler]").map(function(){var r={prev:function(t){return i._isButtonActivated(t)&&i._gotoPrev(e),n(t)},next:function(t){return i._isButtonActivated(t)&&i._gotoNext(e),n(t)},today:function(e){return i._isButtonActivated(e)&&i._gotoToday(),n(e)},selectDay:function(e){return i._isButtonActivated(e)&&i._selectDay(+this.getAttribute("data-month"),+this.getAttribute("data-year"),this,e),n(e)},selectMonth:function(e){return i._isButtonActivated(e)&&i._selectMonthYear(this,"M"),n(e)},selectYear:function(e){return i._isButtonActivated(e)&&i._selectMonthYear(this,"Y"),n(e)},calendarKey:function(e){"year"===i._currentView?i._doYearViewKeyDown(e):"month"===i._currentView?i._doMonthViewKeyDown(e):i._doCalendarKeyDown(e)},selectMonthHeader:function(e){return i._isButtonActivated(e)&&("month"===i._currentView?i._updateDatepicker(!0,"day"):i._updateDatepicker(!0,"month")),n(e)},selectYearHeader:function(e){return i._isButtonActivated(e)&&("year"===i._currentView?i._updateDatepicker(!0,"day"):(i._toYearFromView=i._currentView,i._updateDatepicker(!0,"year"))),n(e)}};t(this).bind(this.getAttribute("data-event"),r[this.getAttribute("data-handler")])}),this._dpDiv.find(".oj-datepicker-calendar").map(function(){D.makeFocusable({element:t(this),applyHighlight:!0})});var r=this._dpDiv.find(".oj-datepicker-header a, .oj-datepicker-buttonpane a");this._AddHoverable(r),this._AddActiveable(r)},_registerSwipeHandler:function(){if(D.isTouchSupported()){var e=this,t=this._getStepMonths(),i=this._IsRTL(),n={recognizers:[[c.Swipe,{direction:c.DIRECTION_HORIZONTAL}]]};this._dpDiv.ojHammer(n).on(i?"swiperight":"swipeleft",function(){return e._gotoNext(t),!1}).on(i?"swipeleft":"swiperight",function(){return e._gotoPrev(t),!1})}},_getMinMaxDateIso:function(e){var t=this.options[e];if(t){var i=this._getDateIso();t=h.IntlConverterUtils._minMaxIsoString(t,i)}return t},_generateHeader:function(e,t,i,n,r){var a=this._IsRTL(),s=this._EscapeXSS(this.getTranslatedString("prevText")),o=n?"<a role='button' href='#' class='oj-datepicker-prev-icon oj-enabled oj-default oj-component-icon oj-clickable-icon-nocontext' data-handler='prev' data-event='click keydown' aria-label='"+s+"'></a>":"<a class='oj-datepicker-prev-icon oj-disabled oj-component-icon oj-clickable-icon-nocontext' title='"+s+"'></a>",l=this._EscapeXSS(this.getTranslatedString("nextText")),c=r?"<a role='button' href='#' class='oj-datepicker-next-icon oj-enabled oj-default oj-component-icon oj-clickable-icon-nocontext' data-handler='next' data-event='click keydown' aria-label='"+l+"'></a>":"<a class='oj-datepicker-next-icon oj-disabled oj-component-icon oj-clickable-icon-nocontext' title='"+l+"'></a>",u="<div class='oj-datepicker-header"+(this._IsDisabled()?" oj-disabled ":" oj-enabled oj-default ")+"'>";return/all|left/.test(i)&&(u+=a?c:o),/all|right/.test(i)&&(u+=a?o:c),u+=this._generateMonthYearHeader(e,t),u+="</div>"},_generateFooter:function(e,t){var i="",n=this._EscapeXSS(this.getTranslatedString("currentText")),r="<a role='button' href='#' class='oj-datepicker-current oj-priority-secondary "+(this._IsDisabled()?"oj-disabled' disabled":"oj-enabled'")+" data-handler='today' data-event='click keydown'>"+n+"</a>";if(e.length>1){var a=0,s=[{index:e.indexOf("today"),content:this._isInRange(t)?r:""}];for(s.sort(function(e,t){return e.index-t.index});a<s.length&&s[a].index<0;)a+=1;for(;a<s.length;)i+=s[a].content,a+=1;i.length>0&&(i="<div class='oj-datepicker-buttonpane'>"+i+"</div>")}return i},_isMultiMonth:function(){var e=this._getNumberOfMonths();return 1!==e[0]||1!==e[1]},_generateViewHTML:function(e){var t,i,n=h.IntlConverterUtils,r=["date","month","fullYear"],a=this._GetConverter(),s=this._getCurrentDate(a),o=new Date(s.getFullYear(),s.getMonth(),s.getDate()),l=this._IsRTL(),c=this.options.datePicker.footerLayout,u=this._getNumberOfMonths(),d=this.options.datePicker.currentMonthPos,p=this._isMultiMonth(),_=this._getMinMaxDateIso("min"),m=this._getMinMaxDateIso("max"),v=this._drawMonth-d,g=this._drawYear,y=new Date(this._currentYear,this._currentMonth,this._currentDay),D=this._calculateValueDateIso(a),k=this._validateDatetime(D,r,!0),b=k.fullYear,S=k.date,C=k.month,w=new Date(b,C,S),I=this._IsDisabled(),j=this._EscapeXSS(this.getTranslatedString("weekText"));_&&(a instanceof Promise||(_=a.parse(_),t=this._validateDatetime(_,r,!0))),m&&(a instanceof Promise||(m=a.parse(m),i=this._validateDatetime(m,r,!0)));try{D=n._clearTime(D)}catch(e){f.info("The value of the InputDateTime element should be an ISOString, please use a valid ISOString"),D=n._clearTime(this._getDefaultIsoDate())}if(v<0&&(v+=12,g-=1),t){var E=new Date(t.fullYear,t.month,t.date);for(i&&h.IntlConverterUtils._compareISODates(m,_)<0&&(f.warn("min property is greater than max property, and should be fixed.\n         For now min is set to equal max."),E=new Date(i.fullYear,i.month,i.date));new Date(g,v,this._getDaysInMonth(g,v))<E;)(v+=1)>11&&(v=0,g+=1)}if(i){var P=new Date(i.fullYear,i.month-u[0]*u[1]+1,i.date);for(t&&h.IntlConverterUtils._compareISODates(m,_)<0&&(f.warn("max property is less than min property, and should be fixed.\n        For now max is set to equal min."),P=new Date(t.fullYear,t.month,t.date));new Date(g,v,1)>P;)(v-=1)<0&&(v=11,g-=1)}this._drawMonth=v,this._drawYear=g;var O=this._generateFooter(c,o),T=this.options.datePicker.weekDisplay;return"D"===e?this._generateDayHTMLContent(n,O,T,o,l,u,p,t,i,v,g,y,k,b,S,C,w,I,j):"M"===e?this._generateMonthHTMLContent(O,t,i,v,g,w,I):this._generateYearHTMLContent(n,O,t,i,v,g,w,I)},_generateDayHTMLContent:function(e,t,i,n,r,a,s,o,l,c,u,h,d,p,_,m,v,g,y){for(var D,k=this.options.dayWide,b=this.options.dayNarrow,S=this.options.firstDayOfWeek,C="",w=this.options.dayFormatter,I=null,j=this._canAdjustMonth(-1,u,c)&&!g,E=this._canAdjustMonth(1,u,c)&&!g,P=this.options.datePicker.daysOutsideMonth,O="",T="all",A=0;A<a[0];A++){var L="";this._maxRows=3;for(var M=0;M<a[1];M++){T=0===A?"all":"";var N="";if(s){if(N+="<div class='oj-datepicker-group",a[1]>1)switch(M){case 0:N+=" oj-datepicker-group-first",T=0===A?r?"right":"left":"";break;case a[1]-1:N+=" oj-datepicker-group-last",T=0===A?r?"left":"right":"";break;default:N+=" oj-datepicker-group-middle",T=""}N+="'>"}N+=this._generateHeader(c,u,T,j,E),N+="<table class='oj-datepicker-calendar"+("number"===i?" oj-datepicker-weekdisplay":"")+(g?" oj-disabled ":" oj-enabled oj-default ")+"' tabindex=-1 data-handler='calendarKey' data-event='keydown' aria-readonly='true' role='grid' aria-labelledby='"+this._GetSubId(u+"_"+c+"_"+this._CALENDAR_DESCRIPTION_ID)+"'><thead role='presentation'><tr role='row'>";var R="number"===i?"<th class='oj-datepicker-week-col'>"+this._EscapeXSS(this.getTranslatedString("weekHeader"))+"</th>":"";for(D=0;D<7;D++){var x=(D+parseInt(S,10))%7;R+="<th role='columnheader' aria-label='"+k[x]+"'"+((D+S+6)%7>=5?" class='oj-datepicker-week-end'":"")+"><span title='"+k[x]+"' aria-hidden = 'true'>"+b[x]+"</span></th>"}N+=R+"</tr></thead><tbody role='presentation'>";var V=this._getDaysInMonth(u,c);u===p&&c===m&&(_=Math.min(_,V));var Y=(this._getFirstDayOfMonth(u,c)-S+7)%7,F=Math.ceil((Y+V)/7),G=s&&this._maxRows>F?this._maxRows:F;this._maxRows=G;var U=new Date(u,c,1-Y);let t;for(var B=0;B<G;B++){N+="<tr role='row'>";var H=" ";if("none"!==i)try{t||(t=new Date(u,c,2-Y));const i=e.dateToLocalIso(t);H=this._calculateWeek(i)}catch(e){f.info("The value of the InputDateTime element should be an ISOString,\n               please use a valid ISOString")}var W="none"===i?"":"<td class='oj-datepicker-week-col' role='rowheader' aria-label='"+y+" "+H+"'>"+H+"</td>";for(D=0;D<7;D++){var K,z=U.getMonth()!==c,q=U.getTime()===v.getTime(),X="oj-dp-"+this.uuid+"-"+B+"-"+D+"-"+A+"-"+M,Z=U.getTime()===h.getTime()&&c===this._currentMonth;Z?(C=X,K=" "+this._DAYOVER_CLASS):K="";var J=[!0,""],$=U.getFullYear(),Q=U.getMonth(),ee=U.getDate();w&&(I=w({fullYear:$,month:Q+1,date:ee}))&&(J=[!I.disabled,I.className||""],I.tooltip&&J.push(I.tooltip));var te=U.getTime()===v.getTime(),ie=z&&"selectable"!==P||!J[0]||this._outSideMinMaxRange(U,o,l);W+="<td role='gridcell' aria-disabled='"+!!ie+"' aria-selected='"+q+"' id='"+X+"' class='"+((D+S+6)%7>=5?" oj-datepicker-week-end":"")+(z?" oj-datepicker-other-month":"")+K+(ie||g?" "+this._UNSELECTABLE_CLASS+" oj-disabled":" oj-enabled ")+(z&&"hidden"===P?"":" "+J[1]+(q?" "+this._CURRENT_CLASS:"")+(U.getTime()===n.getTime()?" oj-datepicker-today":""))+"'"+(z&&"hidden"===P||!J[2]?"":" title='"+J[2].replace(/'/g,"&#39;")+"'")+(ie?"":" data-handler='selectDay' data-event='click' data-month='"+U.getMonth()+"' data-year='"+U.getFullYear()+"'")+">"+(z&&"hidden"===P?"&#xa0;":ie||g?"<span class='oj-disabled'>"+U.getDate()+"</span>":"<a role='button' class='oj-enabled"+(te?" oj-selected":"")+(z?" oj-priority-secondary":"")+"' "+(Z?"":"tabindex='-1' ")+" href='#'>"+U.getDate()+"</a>")+"</td>",U.setDate(U.getDate()+1),"none"!==i&&t.setDate(t.getDate()+1)}N+=W+"</tr>"}(c+=1)>11&&(c=0,u+=1),N+="</tbody></table>",s&&(N+="</div>",a[0]>0&&M===a[1]-1&&(N+="<div class='oj-datepicker-row-break'></div>")),L+=N}O+=L}return{html:O+=t,dayOverId:C}},_generateMonthYearHeader:function(e,t){var i=this.options.datePicker.changeMonth,n=this.options.datePicker.changeYear,r=this._isMonthPriorToYear()?"before":"after",a="<div class='oj-datepicker-title'>",s="",o=this.options.monthWide,l=this._IsDisabled(),c=t+"_"+e+"_";o&&("none"===i?s+="<span class='oj-datepicker-month'>"+o[e]+"</span>":(s+="<a role='button' href='#' data-handler='selectMonthHeader' data-event='click keydown' class='oj-datepicker-month "+(l?"oj-disabled' disabled":"oj-enabled'")+">",s+=o[e]+"</a>"),"before"===r&&(a+=s+("select"!==i||"select"!==n?"&#xa0;":""))),this.yearshtml||(this.yearshtml="","none"===n?a+="<span class='oj-datepicker-year'>"+x(t,e)+"</span>":(a+="<a role='button' href='#' data-handler='selectYearHeader' data-event='click keydown' class='oj-datepicker-year "+(l?"oj-disabled' disabled":"oj-enabled'")+">",a+=x(t,e)+"</a>",this.yearshtml=null)),o&&"after"===r&&(a+=("select"!==i||"select"!==n?"&#xa0;":"")+s);var u=this._drawYear===t&&this._drawMonth===e;return u&&(a+="<span aria-hidden='true' class='oj-helper-hidden-accessible' id='"+this._GetSubId(this._DATEPICKER_DIALOG_DESCRIPTION_ID)+"'>",a+=this._EscapeXSS(this.getTranslatedString("picker"))+"</span>"),a+="<span aria-hidden='true' class='oj-helper-hidden-accessible' id='"+this._GetSubId(c+this._CALENDAR_DESCRIPTION_ID)+"'>",a+=(o?o[e]+" ":"")+x(t,e)+"</span>",u&&(a+="<span aria-hidden='true' class='oj-helper-hidden-accessible' id='"+this._GetSubId(this._DATEPICKER_DESCRIPTION_ID)+"'>"+this._EscapeXSS(this.getTranslatedString("datePicker"))+"</span>"),a+="</div>"},_adjustInstDate:function(e,t){var i=this._drawYear+("Y"===t?e:0),n=this._drawMonth+("M"===t?e:0),r=Math.min(this._currentDay,this._getDaysInMonth(i,n))+("D"===t?e:0),a=new Date(i,n,r);this._currentDay=a.getDate(),this._currentMonth=a.getMonth(),this._drawMonth=this._currentMonth,this._currentYear=a.getFullYear(),this._drawYear=this._currentYear},_generateMonthHTMLContent:function(e,t,i,n,r,a,s){var o=this.options.monthAbbreviated,l="",c=this._canAdjustYear(-1,r)&&!s,u=this._canAdjustYear(1,r)&&!s,h="";this._maxRows=3;var d="";d+=this._generateHeader(n,r,"all",c,u),d+="<table class='oj-datepicker-calendar oj-datepicker-monthview"+(s?" oj-disabled ":" oj-enabled oj-default ")+"' tabindex=-1 data-handler='calendarKey' data-event='keydown' aria-readonly='true' role='grid' aria-labelledby='"+this._GetSubId(r+"_"+n+"_"+this._CALENDAR_DESCRIPTION_ID)+"'>",d+="<tbody role='presentation'>";for(var p=new Date(r,0,1),_=0;_<3;_++){d+="<tr role='row'>";for(var m="",f=0;f<4;f++){var v,g=4*_+f,y=p.getMonth()===a.getMonth(),D="oj-dp-"+this.uuid+"-"+_+"-"+f+"-0-0",k=g===this._currentMonth;k?(l=D,v=" "+this._DAYOVER_CLASS):v="";var b=p.getMonth()===a.getMonth(),S=t&&t.fullYear===r,C=i&&i.fullYear===r,w=!((!S||g>=t.month)&&(!C||g<=i.month));m+="<td role='gridcell' aria-disabled='"+!!w+"' aria-selected='"+y+"' id='"+D+"' class='"+v+(w||s?" "+this._UNSELECTABLE_CLASS+" oj-disabled":" oj-enabled ")+(y?" "+this._CURRENT_CLASS:"")+"'"+(w?"":" data-handler='selectMonth' data-event='click' data-month='"+p.getMonth()+"' data-year='"+p.getFullYear()+"'")+">"+(w||s?"<span class='oj-disabled'>"+o[g]+"</span>":"<a role='button' class='oj-enabled"+(b?" oj-selected":"")+"' "+(k?"":"tabindex='-1' ")+" href='#'>"+o[g]+"</a>")+"</td>",p.setMonth(p.getMonth()+1)}d+=m+"</tr>"}return h+=d+="</tbody></table>",{html:h+=e,dayOverId:l}},_generateYearHTMLContent:function(e,t,i,n,r,a,s,o){var l="",c=this._canAdjustDecade(-1,a)&&!o,u=this._canAdjustDecade(1,a)&&!o,h="";this._maxRows=3;var d="";d+=this._generateHeader(r,a,"all",c,u),d+="<table class='oj-datepicker-calendar oj-datepicker-yearview"+(o?" oj-disabled ":" oj-enabled oj-default ")+"' tabindex=-1 data-handler='calendarKey' data-event='keydown' aria-readonly='true' role='grid' aria-labelledby='"+this._GetSubId(a+"_"+r+"_"+this._CALENDAR_DESCRIPTION_ID)+"'>",d+="<tbody role='presentation'>";for(var p=this._getYearRange(a,i,n),_=10*Math.floor(a/10),m=new Date(_,r,1),f=0;f<3;f++){d+="<tr role='row'>";for(var v="",g=0;g<4&&(4!==f||1!==g);g++){var y,D=_+4*f+g,k=m.getFullYear()===s.getFullYear(),b="oj-dp-"+this.uuid+"-"+f+"-"+g+"-0-0",S=D===this._currentYear;S?(l=b,y=" "+this._DAYOVER_CLASS):y="";var C=m.getFullYear()===s.getFullYear(),w=x(D,r),I=D<p.startYear||D>p.endYear;v+="<td role='gridcell' aria-disabled='"+!!I+"' aria-selected='"+k+"' id='"+b+"' class='"+y+(I||o?" "+this._UNSELECTABLE_CLASS+" oj-disabled":" oj-enabled ")+(k?" "+this._CURRENT_CLASS:"")+"'"+(I?"":" data-handler='selectYear' data-event='click' data-month='"+m.getMonth()+"' data-year='"+m.getFullYear()+"'")+">"+(I||o?"<span class='oj-disabled'>"+w+"</span>":"<a role='button' class='oj-enabled"+(C?" oj-selected":"")+"' "+(S?"":"tabindex='-1' ")+" href='#'>"+w+"</a>")+"</td>",m.setFullYear(m.getFullYear()+1)}d+=v+"</tr>"}return h+=d+="</tbody></table>",{html:h+=t,dayOverId:l}},_isMonthPriorToYear:function(){var e=l.Config.getLocale(),t=new Date,i=new Intl.DateTimeFormat(e,{dateStyle:"long"}).formatToParts(t);return i.findIndex(e=>"month"===e.type)<i.findIndex(e=>"year"===e.type)},_calculateWeek:function(e){var t,i=h.OraI18nUtils._IsoStrParts(e),n=new Date(Date.UTC(i[0],i[1]-1,i[2]));return n.setUTCDate(n.getUTCDate()+4-(n.getUTCDay()||7)),t=n.getTime(),n.setUTCMonth(0),n.setUTCDate(1),Math.floor(Math.round((t-n)/864e5)/7)+1},_getYearRange:function(e,t,i){var n=this.options.datePicker.yearRange.split(":"),r=(new Date).getFullYear();function a(t){var i;return i=t.match(/c[+-].*/)?e+parseInt(t.substring(1),10):t.match(/[+-].*/)?r+parseInt(t,10):parseInt(t,10),isNaN(i)?r:i}var s=a(n[0]),o=Math.max(s,a(n[1]||""));return{startYear:s=t?Math.max(s,t.fullYear):s,endYear:o=i?Math.min(o,i.fullYear):o}},_getNumberOfMonths:function(){var e=this.options.datePicker.numberOfMonths;return null==(e="string"==typeof e?parseInt(e,10):e)?[1,1]:"number"==typeof e?[1,e]:e},_getDaysInMonth:function(e,t){return 32-new Date(e,t,32).getDate()},_getFirstDayOfMonth:function(e,t){return new Date(e,t,1).getDay()},_canAdjustMonth:function(e,t,i){var n=this._getNumberOfMonths(),r=new Date(t,i+(e<0?e:n[0]*n[1]),1);return e<0&&r.setDate(this._getDaysInMonth(r.getFullYear(),r.getMonth())),this._isInRange(r)},_canAdjustYear:function(e,t){var i;return e<0?(i=new Date(t+e,12,1)).setDate(this._getDaysInMonth(i.getFullYear(),i.getMonth())):i=new Date(t+e,1,1),this._isInRange(i)},_canAdjustDecade:function(e,t){var i,n=10*Math.floor(t/10);return e<0?(i=new Date(n+9+10*e,12,1)).setDate(this._getDaysInMonth(i.getFullYear(),i.getMonth())):i=new Date(n+10*e,1,1),this._isInRange(i)},_outSideMinMaxRange:function(e,t,i){var n=t?new Date(t.fullYear,t.month,t.date):null,r=i?new Date(i.fullYear,i.month,i.date):null;return null!==n&&e<n||null!==r&&e>r},_isInRange:function(e){var t,i,n=this._GetConverter(),r=this._getMinMaxDateIso("min"),a=null,s=this._getMinMaxDateIso("max"),o=null,l=this.options.datePicker.yearRange;if(l){var c=l.split(":"),u=(new Date).getFullYear();a=parseInt(c[0],10),o=parseInt(c[1],10),c[0].match(/[+-].*/)&&(a+=u),c[1].match(/[+-].*/)&&(o+=u)}if(r){r=n.parse(r);var h=this._validateDatetime(r,["fullYear","month","date"],!0);t=new Date(h.fullYear,h.month,h.date)}if(s){s=n.parse(s);var d=this._validateDatetime(s,["fullYear","month","date"],!0);i=new Date(d.fullYear,d.month,d.date)}return(!t||e.getTime()>=t.getTime())&&(!i||e.getTime()<=i.getTime())&&(!a||e.getFullYear()>=a)&&(!o||e.getFullYear()<=o)},_GetCalendarTitle:function(){return this._EscapeXSS(this.getTranslatedString("tooltipCalendar"+(this._IsDisabled()?"Disabled":"")))},_disableEnable:function(e){this._triggerNode&&(A(this._triggerNode[0].children,e),this._triggerNode.find("."+this._TRIGGER_CALENDAR_CLASS).attr("title",this._GetCalendarTitle())),e&&this._hide(this._ON_CLOSE_REASON_CLOSE),this._isInLine&&this._updateDatepicker()},_AppendInputHelper:function(){this._isInLine||!0===this.options.readOnly||this._superApply(arguments)},_onBlurHandler:function(e){this._isInLine||this._superApply(arguments)},_onKeyDownHandler:function(e){if(!this._isInLine){this._superApply(arguments);var i=t.ui.keyCode,n=!1;if(this._datepickerShowing())switch(e.keyCode){case i.TAB:this._hide(this._ON_CLOSE_REASON_TAB);break;case i.ESCAPE:this._hide(this._ON_CLOSE_REASON_CANCELLED),n=!0;break;case i.UP:case i.DOWN:var r=this._dpDiv.find(".oj-datepicker-calendar")[0],a=y.focusFirstTabStop(r);a||r.focus(),n=!0}else switch(e.keyCode){case i.UP:case i.DOWN:this._SetValue(this._GetDisplayValue(),e),this.show(),n=!0}return n?(e.preventDefault(),e.stopPropagation(),!1):void 0}},_SetDisplayValue:function(e){if(this._isInLine||this._superApply(arguments),this._setCurrentDate(this._getDateIso()),this._datepickerShowing()){var t=!(this._isInLine&&!this._dpDiv[0].contains(document.activeElement));this._updateDatepicker(t)}},_ResetAllValidators:function(){this._datePickerDefaultValidators={},this._superApply(arguments)},_GetConverter:function(){if(this.options.converter)return this._superApply(arguments);var e=this._GetDefaultConverter();return this.option("converter",e,{_context:{writeback:!0,internalSet:!0}}),e},_GetElementValue:function(){return this.options.value||""},_GetDefaultStyleClass:function(){return"oj-inputdate"},_GetImplicitValidators:function(){var e=this._superApply(arguments);if(null!=this.options.min||null!=this.options.max){var t=O(this.options,this._GetConverter(),this._GetDefaultStyleClass());this._datePickerDefaultValidators.dateTimeRange=t}if(null!=this.options.dayFormatter){var i=T(this.options,this._GetConverter());this._datePickerDefaultValidators.dateRestriction=i}return Object.assign(this._datePickerDefaultValidators,e)},_NotifyDetached:function(){this._hide(this._ON_CLOSE_REASON_CLOSE),this._superApply(arguments)},_NotifyHidden:function(){this._hide(this._ON_CLOSE_REASON_CLOSE),this._superApply(arguments)},_createDateTimeRangeValidator:function(e){var t=this.options,i=this._GetDefaultStyleClass(),n=function(e){return this._dateTimeRangeValidator=O(t,e,i),this._dateTimeRangeValidator}.bind(this);return e instanceof Promise?e.then(function(e){return n(e)}):n(e)},_getDateTimeRangeValidator:function(){return this._dateTimeRangeValidator},_createDateRestrictionValidator:function(e){var t=function(e){return this._dateRestrictionValidator=T(this.options,e),this._dateRestrictionValidator}.bind(this);return e instanceof Promise?e.then(function(e){return t(e)}):t(e)},_getDateRestrictionValidator:function(){return this._dateRestrictionValidator},_getValidator:function(e){var t=null;return"min"===e||"max"===e?t=this._getDateTimeRangeValidator():"dayFormatter"===e&&(t=this._getDateRestrictionValidator()),t},_getTodayDate:function(){var e=this._getCurrentDate();return e.setHours(0),e.setMinutes(0),e.setSeconds(0),e.setMilliseconds(0),e},_getDateIso:function(){return this._isDateTimeSwitcher()&&this._switcherDateValue?this._switcherDateValue:this.options.value||this._getDefaultIsoDate()},getNodeBySubId:function(e){var i=null,n=e&&e.subId,r=this._dpDiv,a=this._getDatepickerContent();if(n)switch(n){case"oj-datepicker-content":i=a[0];break;case"oj-inputdatetime-calendar-icon":i=t(".oj-inputdatetime-calendar-icon",this._triggerNode)[0];break;case"oj-datepicker-prev-icon":i=t(".oj-datepicker-prev-icon",r)[0];break;case"oj-datepicker-next-icon":i=t(".oj-datepicker-next-icon",r)[0];break;case"oj-datepicker-month":i=t(".oj-datepicker-month",r)[0];break;case"oj-datepicker-year":i=t(".oj-datepicker-year",r)[0];break;case"oj-datepicker-current":i=t(".oj-datepicker-current",r)[0];break;case"oj-inputdatetime-date-input":i=this._isInLine?null:this.element[0];break;default:i=null}return i||this._superApply(arguments)},getSubIdByNode:function(e){var i=this._dpDiv,n=null,r=[{selector:".oj-inputdatetime-calendar-icon",ele:this._triggerNode},{selector:".oj-datepicker-prev-icon",ele:i},{selector:".oj-datepicker-next-icon",ele:i},{selector:".oj-datepicker-month",ele:i},{selector:".oj-datepicker-year",ele:i},{selector:".oj-datepicker-current",ele:i}];if(e===i[0])return"oj-datepicker-content";if(!this._isInLine&&e===this.element[0])return"oj-inputdatetime-date-input";for(var a=0,s=r.length;a<s;a++){var o=r[a],l=t(o.selector,o.ele);if(1===l.length&&l[0]===e){n=o.selector.substr(1);break}}return n||this._superApply(arguments)},hide:function(){return this._hide(this._ON_CLOSE_REASON_CLOSE)},_hide:function(e){return R(this)||!this._datepickerShowing()||this._isInLine||(this._popUpDpDiv.ojPopup("close"),this._onClose(e)),this},_onClose:function(e){const t=this._showOnIsFocusOrUserFocus();this._isMobile&&t?this._inputContainer.focus():(t&&(this._ignoreDatePickerShow=!0),this.element.focus())},refresh:function(){return this._triggerNode&&this._triggerNode.find("."+this._TRIGGER_CALENDAR_CLASS).attr("title",this._GetCalendarTitle()),this._superApply(arguments)||this},show:function(){if(!(this._datepickerShowing()||this._IsDisabled()||this.options.readOnly))if(this._ignoreDatePickerShow)this._ignoreDatePickerShow=!1;else if(R(this)){this.element.blur();var e={};e.date=E(this._getNativeDatePickerConverter(),this._getDateIso()),e.mode="date",this._ShowNativeDatePicker(e)}else this._ShowHTMLDatePicker()},_createNativeDatePickerConverter:function(e){if(null===this._nativePickerConverter){var i=e.resolvedOptions(),n={};t.extend(n,i,{isoStrFormat:"offset"}),this._nativePickerConverter=new _.IntlDateTimeConverter(n)}},_getNativeDatePickerConverter:function(){if(null===this._nativePickerConverter){var e=this._GetConverter().resolvedOptions(),i={};t.extend(i,e,{isoStrFormat:"offset"}),this._nativePickerConverter=new _.IntlDateTimeConverter(i)}return this._nativePickerConverter},_ShowNativeDatePicker:function(e){var i=this._getMinMaxDateIso("min"),n=this._getMinMaxDateIso("max"),r=this._getNativeDatePickerConverter();i&&(e.minDate=E(r,i).valueOf()),n&&(e.maxDate=E(r,n).valueOf());var a=this;a._nativePickerShowing=!0,window.datePicker.show(e,t.proxy(this._OnDatePicked,this),function(e){a._nativePickerShowing=!1,e.startsWith("cancel")?a._onClose(a._ON_CLOSE_REASON_CANCELLED):f.error("Error: native date or time picker failed: "+e)})},_OnDatePicked:function(e){if(this._nativePickerShowing=!1,e){var t=this._validateDatetime(this._getDateIso(),{month:e.getMonth(),date:e.getDate(),fullYear:e.getFullYear()}),i=this._GetConverter().format(t);this._SetValue(i,{})}this._onClose(this._ON_CLOSE_REASON_SELECTION)},_validateDatetime:function(e,t,i){var n;try{n=h.IntlConverterUtils._dateTime(e,t,i)}catch(e){f.info("The value of the InputDate element should be an ISOString, please use a valid ISOString"),n=h.IntlConverterUtils._dateTime(this._getDefaultIsoDate(),t,i)}return n},_labelledByUpdatedForSet:b._labelledByUpdatedForSet,_ShowHTMLDatePicker:function(){var e=this._IsRTL(),t=this._GetConverter();if(this._switcherPrevValue=t instanceof Promise?this._getDateIso():t.parse(this._getDateIso()),this._switcherPrevDay=this._currentDay,this._switcherPrevMonth=this._currentMonth,this._switcherPrevYear=this._currentYear,this._getDatepickerContent().empty(),this._updateDatepicker(),j()){const t={my:"start top",at:"start bottom",of:this._labelValueWrapper.parentNode,collision:"flipfit",offset:{x:0,y:this._dropdownVerticalOffset}},i=this._getDropdownPosition(t,e);this._popUpDpDiv.ojPopup("open",this._labelValueWrapper.parentNode,i)}else{const e={my:{horizontal:"center",vertical:"bottom"},at:{horizontal:"center",vertical:"bottom"},of:window,collision:"flipfit"};this._popUpDpDiv.ojPopup("open",this._labelValueWrapper.parentNode,e),this._dpDiv.find(".oj-datepicker-calendar").focus()}return this},_getDropdownPosition:function(e,t){let i=l.PositionUtils.normalizeHorizontalAlignment(e,t);return i=l.PositionUtils.coerceToJet(i),i=l.PositionUtils.coerceToJqUi(i),i.of=e.of,i}}),u.setDefaultOptions({ojInputDate:{converter:u.createDynamicPropertyGetter(function(){return null==C&&(C=M()),C}),firstDayOfWeek:u.createDynamicPropertyGetter(function(){return m.getFirstDayOfWeek()}),dayWide:u.createDynamicPropertyGetter(function(){return m.getDayNames("wide")}),dayNarrow:u.createDynamicPropertyGetter(function(){return m.getDayNames("narrow")}),monthWide:u.createDynamicPropertyGetter(function(){return m.getMonthNames("wide")}),monthAbbreviated:u.createDynamicPropertyGetter(function(){return m.getMonthNames("abbreviated")}),datePicker:u.createDynamicPropertyGetter(function(){return(v.parseJSONFromFontFamily("oj-inputdatetime-option-defaults")||{}).datePicker}),renderMode:u.createDynamicPropertyGetter(function(){return(v.parseJSONFromFontFamily("oj-inputdatetime-option-defaults")||{}).renderMode}),keyboardEdit:u.createDynamicPropertyGetter(function(){return(v.parseJSONFromFontFamily("oj-inputdatetime-option-defaults")||{}).keyboardEdit})}}),G.counter=0;var B,H,W,K=(v.parseJSONFromFontFamily("oj-inputdatetime-option-defaults")||{}).showPickerOnDesktop||"disabled";function z(e){var t=e.split(":");if(4!==t.length)throw new Error("timeIncrement value should be in the format of hh:mm:ss:SSS");for(var i={hourIncr:parseInt(t[0].substring(0),10),minuteIncr:parseInt(t[1],10),secondIncr:parseInt(t[2],10),millisecondIncr:parseInt(t[3],10)},n=0,r=Object.keys(i),a=0;a<r.length;a++){n+=i[r[a]]}if(0===n)throw new Error("timeIncrement must have a non 00:00:00:000 value");return i}function q(e,i){for(var n=e.resolvedOptions(),r={},a=["hour","hour12","minute","second","millisecond","timeFormat","timeZone","timeZoneName","isoStrFormat","dst"],s=0,o=a.length;s<o;s++)a[s]in n&&("timeFormat"===a[s]&&(r.formatType="time"),r[a[s]]=n[a[s]]);var l={};if(t.extend(l,r),delete l.isoStrFormat,delete l.dst,t.isEmptyObject(l))throw new Error("Empty object for creating a time picker converter");return t.extend(r,i||{}),new _.IntlDateTimeConverter(r)}function X(){const e=S.getDateTimePreferences();return e&&e.timeStyle&&e.timeStyle.short?new _.IntlDateTimeConverter({formatType:"time",timeFormat:"short"}):new _.IntlDateTimeConverter({hour:"2-digit",minute:"2-digit"})}l.__registerWidget("oj.ojInputTime",t.oj.inputBase,{widgetEventPrefix:"oj",_CLASS_NAMES:"oj-inputdatetime-input",_WIDGET_CLASS_NAMES:"oj-inputdatetime-time-only oj-component oj-inputdatetime oj-text-field",_INPUT_CONTAINER_CLASS:"oj-inputdatetime-input-container oj-text-field-container",_ELEMENT_TRIGGER_WRAPPER_CLASS_NAMES:"",_INPUT_HELPER_KEY:"inputHelp",_ATTR_CHECK:[{attr:"type",setMandatory:"text"}],_GET_INIT_OPTIONS_PROPS_FOR_WIDGET:[{attribute:"disabled",validateOption:!0},{attribute:"pattern"},{attribute:"title"},{attribute:"placeholder"},{attribute:"value",coerceDomValue:P},{attribute:"required",coerceDomValue:!0,validateOption:!0},{attribute:"readonly",option:"readOnly",validateOption:!0},{attribute:"min",coerceDomValue:P},{attribute:"max",coerceDomValue:P}],_TIME_PICKER_ID:"ojInputTime",_TRIGGER_CLASS:"oj-inputdatetime-input-trigger",_TRIGGER_TIME_CLASS:"oj-inputdatetime-time-icon",_ON_CLOSE_REASON_SELECTION:"selection",_ON_CLOSE_REASON_CANCELLED:"cancelled",_ON_CLOSE_REASON_TAB:"tab",_ON_CLOSE_REASON_CLOSE:"close",_KEYBOARD_EDIT_OPTION_ENABLED:"enabled",_KEYBOARD_EDIT_OPTION_DISABLED:"disabled",options:{converter:void 0,keyboardEdit:"enabled",max:void 0,min:void 0,datePickerComp:null,pickerAttributes:null,renderMode:"jet",timePicker:{footerLayout:"",timeIncrement:"00:05:00:00",showOn:"focus"}},_InitOptions:function(e,t){this._super(e,t),null!==this.options.datePickerComp||this._IsCustomElement()||i.EditableValueUtils.initializeOptionsFromDom(this._GET_INIT_OPTIONS_PROPS_FOR_WIDGET,t,this)},_getPrependNode:function(){return this._isIndependentInput()?t("body"):t(".oj-popup-content",this._datePickerComp.widget._popUpDpDiv.ojPopup("widget"))},_InitBase:function(){this._timePickerDefaultValidators={},this._datePickerComp=this.options.datePickerComp,this._inputContainer=null,this._redirectFocusToInputContainer=!1,this._isMobile=!1,this._ignoreTimePickerShow=!1,this._nativePickerShowing=!1,!0!==this.options.readOnly&&this._createWheelPicker(),this._isIndependentInput()&&(this._ELEMENT_TRIGGER_WRAPPER_CLASS_NAMES+=this._INPUT_CONTAINER_CLASS)},_UseReadonlyDiv:function(){return(!this._isContainedInDateTimePicker()||!this._isDatePickerInline())&&this._superApply(arguments)},_createWheelPicker:function(){var e=this.options.pickerAttributes,n=document.createElement("div");n.className="oj-timepicker-popup",n.style.display="none";var r=document.createElement("div");r.id=this._GetSubId(this._TIME_PICKER_ID);var a="oj-timepicker-content";"phone"===k.getDeviceRenderMode()&&(a+=" oj-timepicker-mobile-content"),r.className=a,n.appendChild(r),this._wheelPicker=t(n);var s=this._getPrependNode()[0];if(s.insertBefore(n,s.firstElementChild),this._isIndependentInput()){this._popUpWheelPicker=this._wheelPicker.ojPopup({initialFocus:"none",role:"dialog",chrome:"default",modality:j?"modeless":"modal",open:function(){},beforeClose:function(){},animateStart:function(e,t){"open"===t.action&&(e.preventDefault(),AnimationUtils.slideIn(t.element,{offsetY:t.element.offsetHeight+"px"}).then(t.endCallback))},animation:{open:null,close:null}}).attr("data-oj-internal",""),this.element.attr("data-oj-popup-"+this._popUpWheelPicker.attr("id")+"-parent",""),e&&i.EditableValueUtils.setPickerAttributes(this._popUpWheelPicker.ojPopup("widget"),e)}},_timepickerShowing:function(){var e;if(this._isIndependentInput())return(e=this._popUpWheelPicker)&&u.isComponentInitialized(e,"ojPopup")&&e.ojPopup("isOpen")||this._nativePickerShowing;var t=this._datePickerComp.widget;return e=t._popUpDpDiv,t._isShowingDatePickerSwitcher()&&e&&u.isComponentInitialized(e,"ojPopup")&&e.ojPopup("isOpen")||this._nativePickerShowing},_GetDefaultConverter:function(){return null==this._timeDefaultConverter&&(this._timeDefaultConverter=X()),this._timeDefaultConverter},_CreateConverters:function(){var e=function(e){this._createOffsetConverter(e)}.bind(this),t=this._GetConverter();t instanceof Promise?(this._resolveConverterBusyState=this._SetConverterBusyState("time"),this._converterPromise=t.then(function(t){e(t)})):e(t)},_ComponentCreate:function(){h.IntlConverterUtils._verifyValueMinMax(this.options.value,this.options.min,this.options.max),this._CreateConverters(),this._InitBase();var e=this._superApply(arguments);if(this._isContainedInDateTimePicker()&&!this._isDatePickerInline()?this._CLASS_NAMES="":N(this),this._IsCustomElement()){let e=this._getRootElement(),t=this.GetFocusElement();e.focus=function(){t.focus(!0)};let i=Object.getPrototypeOf(t);t.focus=function(e){const n=this.options.timePicker.showOn;"focus"===n?this._ignoreTimePickerShow=!e:"userFocus"===n&&(this._ignoreTimePickerShow=!0),i.focus.call(t)}.bind(this)}return this._processReadOnlyKeyboardEdit(),e},_SetConverterBusyState:function(e){var t=this.element[0],i=g.getContext(t).getBusyContext(),n="The page is waiting for async "+e+" converter loading ";return t&&t.id&&(n+='for "'+t.id+'" '),n+="to finish.",i.addBusyState({description:n})},_AfterCreate:function(){var e=this._superApply(arguments);return e},_AfterCreateConverterCached:function(){var e=this._super(),t=function(){var e;if((!0!==this.options.readOnly&&this._isIndependentInput()&&this._attachTrigger(),this._isIndependentInput())&&(!0!==this.options.readOnly&&A(this._triggerNode[0].children,this.options.disabled),!this._IsCustomElement())){var t=this.$label;this._inputContainer&&t&&1===t.length&&(e=t.attr("id"),this._inputContainer.attr("aria-labelledby",e))}this._resolveConverterBusyState&&(this._resolveConverterBusyState(),delete this._resolveConverterBusyState)}.bind(this);if(this._converterPromise){var i=this;this._converterPromise.then(function(){t(),delete i._converterPromise})}else t();return e},_createDateTimeRangeValidator:function(e){var t=this.options,i=this._GetDefaultStyleClass(),n=function(e){var n=O(t,e,i);if(n instanceof Promise){var r=this;return n.then(function(e){return r._dateTimeRangeValidator=e,e})}return this._dateTimeRangeValidator=n,n}.bind(this);return e instanceof Promise?e.then(function(e){return n(e)}):n(e)},_getDateTimeRangeValidator:function(){return this._dateTimeRangeValidator},_setValidatorOption:function(e,t){var i=this,n=function(t){i._timePickerDefaultValidators[e]=t,i._AfterSetOptionValidators()};t instanceof Promise?t.then(function(e){n(e)}):n(t)},_setOption:function(e,t,n){var r,a=null;if("value"===e)return t||(t=null),a=this._super(e,t,n),this._createWheelPickerDom(!0),a;"timePicker"===e&&void 0===t.footerLayout&&(r=this.options.timePicker.footerLayout),a=this._superApply(arguments),r&&(this.options.timePicker.footerLayout=r),"disabled"===e&&this._isIndependentInput()?(t&&this._hide(this._ON_CLOSE_REASON_CLOSE),this._triggerNode&&(this._triggerNode.find("."+this._TRIGGER_TIME_CLASS).attr("title",this._getTimeTitle()),A(this._triggerNode[0].children,t))):"max"!==e&&"min"!==e||this._isContainedInDateTimePicker()?"readOnly"===e?(this._processReadOnlyKeyboardEdit(),t?this._hide(this._ON_CLOSE_REASON_CLOSE):null==this._wheelPicker&&(this._createWheelPicker(),this._isIndependentInput()&&(this._attachTrigger(),A(this._triggerNode[0].children,this.options.disabled)),this._setupResizePopupBind()),this._AfterSetOptionDisabledReadOnly("readOnly",i.EditableValueUtils.readOnlyOptionOptions)):"keyboardEdit"===e&&this._processReadOnlyKeyboardEdit():this._setValidatorOption("dateTimeRange",this._createDateTimeRangeValidator(this._GetConverter()));var s={max:!0,min:!0,converter:!0,timePicker:!0};return e in s&&this._createWheelPickerDom(),a},_destroy:function(){return this._cleanUpTimeResources(),this._super()},_clearWheelModels:function(){var e=this._timePickerModel;if(e){var t=e.getWheelModel("hour");t&&(t.wheel=void 0),(t=e.getWheelModel("minute"))&&(t.wheel=void 0),(t=e.getWheelModel("ampm"))&&(t.wheel=void 0)}},_destroyHammer:function(){if(this._wheelGroup&&this._wheelGroup.length)for(var e=this._wheelGroup[0].children,t=0;t<e.length;t++)e[t].ojDestroy()},_SetupResources:function(){return!0!==this.options.readOnly&&this._setupResizePopupBind(),this._super()},_setupResizePopupBind:function(){this._resizePopupBind=function(){t(".oj-timepicker-content",this._wheelPicker)[j?"removeClass":"addClass"]("oj-timepicker-fixedheight"),this._isIndependentInput()&&u.isComponentInitialized(this._popUpWheelPicker,"ojPopup")&&this._popUpWheelPicker.ojPopup("option","modality",j?"modeless":"modal")}.bind(this),window.addEventListener("resize",this._resizePopupBind,!1)},_ReleaseResources:function(){return this._IsCustomElement()&&this._cleanUpListeners(),this._super()},_cleanUpTimeResources:function(){this._isIndependentInput()&&(this.element.off("focus"),this.element[0].removeEventListener("touchstart",this._timepickerTouchStartListener,{passive:!1}),delete this._timepickerTouchStartListener,this._wrapper[0].removeEventListener("touchstart",this._timepickerWrapperTouchStartListener,{passive:!0}),delete this._timepickerWrapperTouchStartListener),this._triggerNode&&this._triggerNode.remove(),this._cleanUpListeners(),this._destroyHammer(),this._wheelPicker&&(this._wheelPicker.remove(),this._clearWheelModels()),this._isIndependentInput()&&this._popUpWheelPicker&&u.isComponentInitialized(this._popUpWheelPicker,"ojPopup")&&this._popUpWheelPicker.ojPopup("destroy")},_cleanUpListeners:function(){this._resizePopupBind&&window.removeEventListener("resize",this._resizePopupBind)},_processReadOnlyKeyboardEdit:function(){if(this._isIndependentInput()){var e=this.options.readOnly||this._isKeyboardEditDisabled();this.element.prop("readOnly",!!e)}},_isKeyboardEditDisabled:function(){return this.options.keyboardEdit===this._KEYBOARD_EDIT_OPTION_DISABLED},_AppendInputHelper:function(){this._isIndependentInput()&&this._isTimePickerSupported()&&this._superApply(arguments)},_onKeyDownHandler:function(e){if(this._isIndependentInput()){this._superApply(arguments);var i=t.ui.keyCode,n=!1;if(this._timepickerShowing())switch(e.keyCode){case i.TAB:this._hide(this._ON_CLOSE_REASON_TAB);break;case i.ESCAPE:this._hide(this._ON_CLOSE_REASON_CANCELLED),n=!0;break;case i.UP:case i.DOWN:this._wheelGroup.children().first().focus(),n=!0}else switch(e.keyCode){case i.UP:case i.DOWN:var r=this._GetConverter().parse(this._GetDisplayValue());this._SetValue(r,e),this._isTimePickerSupported()&&this.show(),n=!0}if(n||e.keyCode===i.ENTER)return e.preventDefault(),e.stopPropagation(),!1}},_getTimeTitle:function(){return this._EscapeXSS(this.getTranslatedString("tooltipTime"+(this.options.disabled?"Disabled":"")))},_CreateContainerWrapper:function(){return this._inputContainer=t(this._superApply(arguments)),this._inputContainer.attr({role:"presentation",tabindex:"-1"}),this._isTimePickerSupported()&&this.element.attr({role:"combobox","aria-haspopup":"true"}),this._inputContainer[0]},_IsTextFieldComponent:function(){return!this._isInLine},_GetContentWrapper:function(){if(this._IsCustomElement())return this._getRootElement().querySelector(".oj-text-field-middle")},_onElementFocus:function(){this._redirectFocusToInputContainer?(this._redirectFocusToInputContainer=!1,R(this)?this._inputContainer.focus():this._wheelGroup.children().first().focus()):this._showOnIsFocusOrUserFocus()?this._isTimePickerSupported()&&this.show():this._timepickerShowing()&&this._hide(this._ON_CLOSE_REASON_CLOSE)},_showOnIsFocusOrUserFocus:function(){var e=this.options.timePicker.showOn;return"focus"===e||"userFocus"===e},_OnElementTouchStart:function(e){if(e.preventDefault(),this._showOnIsFocusOrUserFocus())if(this._timepickerShowing())this._ignoreTimePickerShow=!0,this._hide(this._ON_CLOSE_REASON_CLOSE);else{var t=this.element[0]===document.activeElement;this._isTimePickerSupported()&&(this.show(),this._redirectFocusToInputContainer=!0),R(this)&&t&&this._inputContainer.focus()}},_attachTrigger:function(){var e=this.options.timePicker.showOn,i=document.createElement("span");i.className=this._TRIGGER_CLASS;var n=document.createElement("span");n.setAttribute("title",this._getTimeTitle()),n.className=this._TRIGGER_TIME_CLASS+" oj-clickable-icon-nocontext oj-component-icon";var r=this;this.element.on("focus",t.proxy(this._onElementFocus,this)),this._timepickerTouchStartListener=t.proxy(this._OnElementTouchStart,this),this.element[0].addEventListener("touchstart",this._timepickerTouchStartListener,{passive:!1});var a=this._wrapper;if(this._timepickerWrapperTouchStartListener=function(){r._isMobile=!0},a[0].addEventListener("touchstart",this._timepickerWrapperTouchStartListener,{passive:!0}),"image"===e&&(n.style.display="block",this._IsRTL()?(this.element.css("border-top-left-radius",0),this.element.css("border-bottom-left-radius",0)):(this.element.css("border-top-right-radius",0),this.element.css("border-bottom-right-radius",0))),!R(this)){i.appendChild(n),n.addEventListener("click",function(){r._timepickerShowing()?r._hide(r._ON_CLOSE_REASON_CLOSE):r._isTimePickerSupported()&&(r.show(),r._wheelGroup.children().first().focus())});var s=t(n);this._AddHoverable(s),this._AddActiveable(s),this._triggerIcon=s}this._triggerNode=t(i);var o=this.element[0].parentNode;this._isTimePickerSupported()&&o.parentNode.insertBefore(i,o.nextElementSibling)},_getValue:function(){return this._isContainedInDateTimePicker()?this._datePickerComp.widget.getValueForInputTime():this.options.value},_onBlurHandler:function(e){this._isIndependentInput()&&this._superApply(arguments)},show:function(){this._timepickerShowing()||this.options.disabled||this.options.readOnly||(this._ignoreTimePickerShow?this._ignoreTimePickerShow=!1:R(this)?(this.element.blur(),this._showNativeTimePicker()):this._showWheelPicker())},_createOffsetConverter:function(e){this._offsetConverter=q(e,{isoStrFormat:"offset"})},_getOffsetConverter:function(){return this._offsetConverter},_showNativeTimePicker:function(){var e={},t=this._getOffsetConverter(),i=E(t,this._getIsoDateValue(t));e.date=i,e.mode="time";var n=z(this.options.timePicker.timeIncrement);e.minuteInterval=0===n.hourIncr?n.minuteIncr:1;var r=this._isContainedInDateTimePicker()?this._datePickerComp.widget.options.min:this.options.min,a=this._isContainedInDateTimePicker()?this._datePickerComp.widget.options.max:this.options.max;if(r){var s=E(t,h.IntlConverterUtils._minMaxIsoString(r,this._getIsoDateValue(t)));e.minDate=s.valueOf()}if(a){var o=E(t,h.IntlConverterUtils._minMaxIsoString(a,this._getIsoDateValue(t)));e.maxDate=o.valueOf()}var l=this;this._nativePickerShowing=!0,window.datePicker.show(e,function(e){if(l._nativePickerShowing=!1,e){var t=l._getOffsetConverter(),i=h.IntlConverterUtils._dateTime(l._getIsoDateValue(t),{hours:e.getHours(),minutes:e.getMinutes(),seconds:e.getSeconds()}),n=l._GetConverter().format(i);l._SetValue(n,{})}l._onClose(l._ON_CLOSE_REASON_SELECTION)},function(e){l._nativePickerShowing=!1,e.startsWith("cancel")?l._onClose(l._ON_CLOSE_REASON_CANCELLED):f.error("Error: native time picker failed: "+e)})},hide:function(){return this._hide(this._ON_CLOSE_REASON_CLOSE)},_hide:function(e){return!R(this)&&this._timepickerShowing()&&(this._popUpWheelPicker.ojPopup("close"),this._onClose(e)),this},_onClose:function(e){const t=this._showOnIsFocusOrUserFocus();this._isMobile&&t?(this._isIndependentInput()?this._inputContainer:this._datePickerComp.widget._inputContainer).focus():(t&&(this._isIndependentInput()?this._ignoreTimePickerShow=!0:this._datePickerComp.widget._ignoreDatePickerShow=!0),this.element.focus())},refresh:function(){return this._triggerNode&&this._triggerNode.find("."+this._TRIGGER_TIME_CLASS).attr("title",this._getTimeTitle()),this._superApply(arguments)||this},_SetDisplayValue:function(e){this._isIndependentInput()&&this._superApply(arguments),this._timepickerShowing()&&this._createWheelPickerDom(!0)},_SetValue:function(e,t,i){var n=!1;if(this._isContainedInDateTimePicker())try{var r,a=this._datePickerComp.widget;r=t&&t.target&&t.target===this.element[0]&&!this._isDatePickerInline()?a._GetConverter():this._GetConverter();var s=new Date,o=h.IntlConverterUtils,l=a.getValueForInputTime()||o.dateToLocalIso(s),c=e;try{o._dateTime(e,{month:s.getMonth(),date:s.getDate(),fullYear:s.getFullYear(),hours:s.getHours(),minutes:s.getMinutes(),seconds:s.getSeconds()})}catch(t){c=r.parse(e)}var u=o._copyTimeOver(c,l),d=r.parse(u);if(d&&0===h.IntlConverterUtils._compareISODates(l,d))return!1;a.timeSelected(d,t),this._isDatePickerInline()&&(n=this._super(e,null,i))}catch(t){n=this._super(e,null,i)}else n=this._superApply(arguments);return n},_DoWrapElement:function(){return this._isIndependentInput()},_isIndependentInput:function(){return!this._isContainedInDateTimePicker()||this._isDatePickerInline()},_GetDefaultStyleClass:function(){return"oj-inputtime"},_GetElementValue:function(){return this.options.value||""},_GetImplicitValidators:function(){var e=this._superApply(arguments);if((null!=this.options.min||null!=this.options.max)&&!this._isContainedInDateTimePicker()){var t=O(this.options,this._GetConverter(),this._GetDefaultStyleClass());this._timePickerDefaultValidators.dateTimeRange=t}return Object.assign(this._timePickerDefaultValidators,e)},_ResetAllValidators:function(){this._timePickerDefaultValidators={},this._superApply(arguments)},_GetConverter:function(){if(this.options.converter)return this._superApply(arguments);var e=this._GetDefaultConverter();return this.option("converter",e,{_context:{writeback:!0,internalSet:!0}}),e},_isContainedInDateTimePicker:function(){return null!==this._datePickerComp},_isDatePickerInline:function(){return this._datePickerComp.inline},_NotifyDetached:function(){this._hide(this._ON_CLOSE_REASON_CLOSE),this._superApply(arguments)},_NotifyHidden:function(){this._hide(this._ON_CLOSE_REASON_CLOSE),this._superApply(arguments)},_generateHeader:function(){var e=this._EscapeXSS(this.getTranslatedString("cancelText")),t="<a role='button' href='#' class='oj-enabled oj-default oj-timepicker-cancel-button' aria-label='"+e+"'>"+e+"</a>",i=this._EscapeXSS(this.getTranslatedString("okText")),n="<a role='button' href='#' class='oj-enabled oj-default oj-timepicker-ok-button' aria-label='"+i+"'>"+i+"</a>",r="<div class='oj-timepicker-header"+(this.options.disabled?" oj-disabled ":" oj-enabled oj-default ")+"'>";return r+=t,r+=n,r+="</div>"},_generateFooter:function(e,t){var i="",n="<a role='button' href='#' class='oj-timepicker-now oj-priority-secondary oj-enabled'>"+this._EscapeXSS(this.getTranslatedString("currentTimeText"))+"</a>";if(e&&e.length>1){var r=0,a=[{index:e.indexOf("now"),content:t?n:""}];for(a.sort(function(e,t){return e.index-t.index});r<a.length&&a[r].index<0;)r+=1;for(;r<a.length;)i+=a[r].content,r+=1;i.length>0&&(i="<div class='oj-timepicker-footer'>"+i+"</div>")}return i},_getTimePositioning:function(e){let t=e.replace(/'[^']*'/g,"").replace(/[^hHkKma]*/g,"");t=t.replace(/(h|H|k|K)+/,"h").replace(/m+/,"m");const i=m.__getBundle(),n=h.OraI18nUtils.getLocaleElementsMainNodeKey(i).split("-")[0],r="ar"===n||"he"===n;let a,s={},o=0,l=t.length;for(o=0;o<l;o++)a=t.charAt(o),s[a]=o;return r&&(o=s.h,s.h=s.m,s.m=o),s},_getIsoDateLimit:function(e,t,i){var n=this._isContainedInDateTimePicker()?this._datePickerComp.widget.options[t]:this.options[t],r=(n=(n=n?h.IntlConverterUtils._minMaxIsoString(n,this._getValue()):n)?e.parse(n):n)?h.IntlConverterUtils._clearTime(n):null;return i&&r&&i.substring(0,i.indexOf("T"))!==r.substring(0,r.indexOf("T"))&&(n=null),n},_getIsoDateValue:function(e){var t=this._getValue();return t||((t=new Date).setHours(0),t.setMinutes(0),t.setSeconds(0),t.setMilliseconds(0),t=h.IntlConverterUtils.dateToLocalIso(t)),t=e.parse(t)},_getAmPmStrings:function(){var e=new _.IntlDateTimeConverter({pattern:"hh:a"}),t=e.format("2016-01-01T01:00:00").split(":"),i=e.format("2016-01-01T15:00:00").split(":");return[t[1],i[1]]},_getWheelPickerContent:function(e){return e?t(e.find(".oj-timepicker-content")[0]):null},_createWheelPickerDom:function(e){if(null!=this._wheelPicker){e||this._detachWheelHandler();var i=this._wheelPicker,n=this._getWheelPickerContent(i);this._destroyHammer(),e?t(".oj-timepicker-wheel-group",n).remove():n.empty();var r=this._GetConverter(),a=r.resolvedOptions(),s=t.extend({},a);"zulu"===s.isoStrFormat&&(s.isoStrFormat="offset",s=(r=new _.IntlDateTimeConverter(s)).resolvedOptions());var o,l=h.IntlConverterUtils,c=this._getValue(),u=new Date;c||(c=h.IntlConverterUtils.dateToLocalIso(u));try{c=r.parse(c),o=l._clearTime(c)}catch(e){f.info("The value of the InputTime element must be an ISOString, please use a valid ISOString"),c=h.IntlConverterUtils.dateToLocalIso(u),o=l._clearTime(c)}var d=this._getIsoDateLimit(r,"min",o),p=this._getIsoDateLimit(r,"max",o),m=this.options.timePicker.footerLayout,v=new Y(null);this._timePickerModel=v;var g=["","","",""],y=a.pattern||a.patternFromOptions;if(void 0===y){let e=new _.IntlDateTimeConverter(a).resolvedOptions();y=e.pattern||e.patternFromOptions,f.warning("time component's converter.resolvedOptions has no pattern or patternFromOptions\n        property. The most likely cause is the component's converter does not\n        override the resolvedOptions method like it should.")}for(var D=this._getTimePositioning(y),k=Object.keys(D),b=0;b<k.length;b++){var S=k[b];g[D[S]]=S}v.wheelOrder=g.filter(function(e){return!!e}).join(""),v.format=y,v.ampmStrings=this._getAmPmStrings();var C=this.options.timePicker.timeIncrement;if(C){var w=z(C);v.increment=60*w.hourIncr+w.minuteIncr}try{v.isoValue=this._getIsoDateValue(r)}catch(e){var I=t.oj.ojInputTime.prototype.options.converter;v.isoValue=I.parse(c),f.info("The value of the InputTime element must be an ISOString, please use a valid ISOString")}d&&(v.isoMin=d),p&&(v.isoMax=p),!this._isIndependentInput()||e&&0!==t(".oj-timepicker-header",n).length||n.append(t(this._generateHeader(i))),this._wheelGroup=t(U(v)),this._isIndependentInput()?this._wheelGroup.insertAfter(t(".oj-timepicker-header",n)):n.append(this._wheelGroup),e&&0!==t(".oj-timepicker-footer",n).length||n.append(t(this._generateFooter(m,u))),n.find(".oj-timepicker-hour").attr("aria-label",this.getTranslatedString("hourWheelLabel")),n.find(".oj-timepicker-minute").attr("aria-label",this.getTranslatedString("minuteWheelLabel")),n.find(".oj-timepicker-meridian").attr("aria-label",this.getTranslatedString("ampmWheelLabel")),e||this._attachWheelHandler()}},_detachWheelHandler:function(){this._wheelPicker.find(".oj-timepicker-now").off("click"),this._isIndependentInput()?(this._wheelPicker.find(".oj-timepicker-cancel-button").off("click"),this._wheelPicker.find(".oj-timepicker-ok-button").off("click"),this._wheelPicker.off("keydown")):this._wheelPicker.find(".oj-timepicker-wheel").off("blur")},_attachWheelHandler:function(){var e=this;if(this._wheelPicker.find(".oj-timepicker-now").on("click",function(t){var i,n=new Date,r=e._GetConverter(),a=r.resolvedOptions();i=void 0!==a.timeZone&&"local"!==a.isoStrFormat?n.toISOString():h.IntlConverterUtils.dateToLocalIso(n),i=r.parse(i),e._timePickerModel.isoValue=i,e._isIndependentInput()||e._SetValue(e._timePickerModel.isoValue,t),t.preventDefault()}),!this._isIndependentInput())return this._wheelPicker.find(".oj-timepicker-wheel").on("blur",function(t){e._SetValue(e._timePickerModel.isoValue,t)}),this._datePickerComp.widget._togglePicker(),void this._wheelGroup.children().first().focus();this._wheelPicker.find(".oj-timepicker-cancel-button").on("click",function(t){t.preventDefault(),e._hide(e._ON_CLOSE_REASON_CANCELLED)}),this._wheelPicker.find(".oj-timepicker-ok-button").on("click",function(t){e._hide(e._ON_CLOSE_REASON_SELECTION),e._SetValue(e._timePickerModel.isoValue,t),t.preventDefault()}),this._wheelPicker.on("keydown",function(i){i.keyCode===t.ui.keyCode.ESCAPE&&(i.preventDefault(),e._hide(e._ON_CLOSE_REASON_CANCELLED))})},_isTimePickerSupported:function(){return"enabled"===K||"disabled"===K&&"others"!==l.Config.getDeviceRenderMode()},_showWheelPicker:function(){this._createWheelPickerDom();var e=this._popUpWheelPicker;if(e)if(j){var t=l.PositionUtils.normalizeHorizontalAlignment({my:"start top",at:"start bottom",of:this.element,collision:"flipfit"},this._IsRTL());e.ojPopup("open",this.element[0].parentNode.parentNode,t)}else e.ojPopup("open",this.element[0].parentNode.parentNode,{my:{horizontal:"center",vertical:"bottom"},at:{horizontal:"center",vertical:"bottom"},of:window,collision:"flipfit"}),this._wheelGroup.children().first().focus()},getNodeBySubId:function(e){var i=null,n=e&&e.subId,r=this._wheelPicker,a=this._getWheelPickerContent(r);if(n)switch(n){case"oj-inputdatetime-time-icon":i=t(".oj-inputdatetime-time-icon",this._triggerNode)[0];break;case"oj-inputdatetime-time-input":i=this.element[0];break;case"oj-timepicker-content":i=a?a[0]:null;break;case"oj-timepicker-cancel-button":i=t(".oj-timepicker-cancel-button",r)[0];break;case"oj-timepicker-ok-button":i=t(".oj-timepicker-ok-button",r)[0];break;case"oj-timepicker-hour":i=t(".oj-timepicker-hour",r)[0];break;case"oj-timepicker-minute":i=t(".oj-timepicker-minute",r)[0];break;case"oj-timepicker-meridian":i=t(".oj-timepicker-meridian",r)[0];break;case"oj-timepicker-now":i=t(".oj-timepicker-now",r)[0];break;default:i=null}return i||this._superApply(arguments)},getSubIdByNode:function(e){var i=t(".oj-inputdatetime-time-icon",this._triggerNode),n=null,r=this._wheelPicker,a=this._getWheelPickerContent(r),s=[{selector:".oj-timepicker-cancel-button",ele:r},{selector:".oj-timepicker-ok-button",ele:r},{selector:".oj-timepicker-hour",ele:r},{selector:".oj-timepicker-minute",ele:r},{selector:".oj-timepicker-meridian",ele:r},{selector:".oj-timepicker-now",ele:r}];if(e===i[0])n="oj-inputdatetime-time-icon";else if(e===this.element[0])n="oj-inputdatetime-time-input";else if(a&&e===a[0])n="oj-timepicker-content";else for(var o=0;o<s.length;o++){var l=s[o],c=t(l.selector,l.ele);if(1===c.length&&c[0]===e){n=l.selector.substr(1);break}}return n||this._superApply(arguments)},widget:function(){return this._isIndependentInput()?this._super():this._datePickerComp.widget.widget()}}),u.setDefaultOptions({ojInputTime:{converter:u.createDynamicPropertyGetter(function(){return null==B&&(B=X()),B}),renderMode:u.createDynamicPropertyGetter(function(){return(v.parseJSONFromFontFamily("oj-inputdatetime-option-defaults")||{}).renderMode}),keyboardEdit:u.createDynamicPropertyGetter(function(){return(v.parseJSONFromFontFamily("oj-inputdatetime-option-defaults")||{}).keyboardEdit}),timePicker:u.createDynamicPropertyGetter(function(){return(v.parseJSONFromFontFamily("oj-inputdatetime-option-defaults")||{}).timePicker})}});var Z,J=(v.parseJSONFromFontFamily("oj-inputdatetime-option-defaults")||{}).converterYear||"numeric";function $(){const e=S.getDateTimePreferences();return e&&e.dateStyle&&e.dateStyle.short&&e.timeStyle&&e.timeStyle.short?new _.IntlDateTimeConverter({formatType:"datetime",dateFormat:"short",timeFormat:"short"}):new _.IntlDateTimeConverter({day:"2-digit",month:"2-digit",year:J,hour:"2-digit",minute:"2-digit"})}l.__registerWidget("oj.ojInputDateTime",t.oj.ojInputDate,{widgetEventPrefix:"oj",_WIDGET_CLASS_NAMES:"oj-inputdatetime-date-time oj-component oj-inputdatetime",_INPUT_HELPER_KEY:"inputHelpBoth",_TRIGGER_CALENDAR_CLASS:"oj-inputdatetime-calendar-clock-icon",options:{converter:void 0,rawValue:void 0,renderMode:"jet",timePicker:{footerLayout:"",timeIncrement:"00:05:00:00",showOn:"focus"}},_GetDefaultConverter:function(){return null==this._dateTimeDefaultConverter&&(this._dateTimeDefaultConverter=$()),this._dateTimeDefaultConverter},_CreateConverters:function(){this._super();var e=function(e){var t,i=[];return(t=this._createTimePickerConverter(e))instanceof Promise&&(this._timeConverterPromise=t,i.push(t)),i.length?Promise.all(i):null}.bind(this),t=this._GetConverter();t instanceof Promise?(this._resolveDateTimeConverterBusyState=this._SetConverterBusyState("datetime"),this._dateTimeConverterPromise=e(t)):e(t)},_InitBase:function(){this._super(),this._timePickerElement=this.element,this._timePicker=null,this._previousValue=null,this._switcherDiv=null,this._switcherPrevValue=null,this._switcherPrevDay=null,this._switcherPrevMonth=null,this._switcherPrevYear=null,this._switcherDateValue=null,this._switcherTimeValue=null,this._dateTimeSwitcherActive=null,this._isInLine||!0!==this.options.readOnly&&this._createSwitcherDiv()},_UseReadonlyDiv:function(){return!this._isInLine&&this._superApply(arguments)},_createSwitcherDiv:function(){this._switcherDiv=t(this._generateSwitcher()),this._popUpDpDiv.ojPopup("widget")[0].querySelector(".oj-popup-content").appendChild(this._switcherDiv[0]);var e=this;this._popUpDpDiv.on("ojclose",function(){null===e._switcherDateValue&&null===e._switcherTimeValue||(e._currentDay=e._switcherPrevDay,e._currentMonth=e._switcherPrevMonth,e._drawMonth=e._currentMonth,e._currentYear=e._switcherPrevYear,e._drawYear=e._currentYear,e._SetValue(e._switcherPrevValue),e._switcherTimeValue=null,e._switcherDateValue=null,e._switcherPrevDay=null,e._switcherPrevMonth=null,e._switcherPrevYear=null,e._switcherPrevValue=null)}),this._switcherDiv.find("[data-handler]").map(function(){var i={switchMe:function(i){var n=i.keyCode;if("keydown"===i.type&&(t.ui.keyCode.ENTER===n||t.ui.keyCode.SPACE===n)||"click"===i.type)return e._isShowingDatePickerSwitcher()?(e.show(),e._placeFocusOnCalendar()):e._timePicker.ojInputTime("show"),!1},switchDone:function(i){var n=i.keyCode;if("keydown"===i.type&&(t.ui.keyCode.ENTER===n||t.ui.keyCode.SPACE===n)||"click"===i.type){var r=e._GetConverter().format(e._getDateIso()),a=e._GetConverter().parse(r);e._switcherDateValue&&(a=e._switcherDateValue),e._switcherTimeValue&&(a=h.IntlConverterUtils._copyTimeOver(e._switcherTimeValue,a)),e._switcherPrevValue&&a&&!e._switcherTimeValue&&(a=h.IntlConverterUtils._copyTimeOver(e._switcherPrevValue,a));var s=e._GetConverter().format(a);return e._SetDisplayValue(s),e._SetValue(s,{}),e._switcherTimeValue=null,e._switcherDateValue=null,e._switcherPrevDay=null,e._switcherPrevMonth=null,e._switcherPrevYear=null,e._switcherPrevValue=null,e._hide(e._ON_CLOSE_REASON_SELECTION),!1}},switchCancel:function(i){var n=i.keyCode;if("keydown"===i.type&&(t.ui.keyCode.ENTER===n||t.ui.keyCode.SPACE===n)||"click"===i.type)return e._hide(e._ON_CLOSE_REASON_CANCELLED),!1}};t(this).bind(this.getAttribute("data-event"),i[this.getAttribute("data-handler")])})},_setupSwitcherButtons:function(){var e=this._switcherDiv.find("a");this._AddHoverable(e),this._AddActiveable(e)},_ComponentCreate:function(){var e=this._super();if(this._isInLine){var i=this.getTranslatedString("time");var n=t(`<input type='text' aria-label=${i}>`);n.insertAfter(this.element),this._timePickerElement=n}else!0!==this.options.readOnly&&this._setupSwitcherButtons();return e},_createTimePicker:function(){for(var e=["title","placeholder","disabled","required","readOnly","keyboardEdit","pickerAttributes","renderMode"],i={},n=0,r=e.length;n<r;n++)i[e[n]]=this.options[e[n]];var a=this._isInLine?this.options.displayOptions.messages:"none",s=this.options.timePicker;if(this._GetConverter()instanceof Promise)this._timePicker=this._timePickerElement.ojInputTime(t.extend(i,{converter:this._timeConverter||this._timeConverterPromise,userAssistanceDensity:"compact",displayOptions:{converterHint:"none",title:"none",messages:a},value:this.options.value,timePicker:s,datePickerComp:{widget:this,inline:this._isInLine}}));else{var o=this._formatValueWithTimeConverter(this.options.value);this._timePicker=this._timePickerElement.ojInputTime(t.extend(i,{converter:this._timeConverter,userAssistanceDensity:"compact",displayOptions:{converterHint:"none",title:"none",messages:a},value:o,timePicker:s,datePickerComp:{widget:this,inline:this._isInLine}}))}},_AfterCreate:function(){var e=this._superApply(arguments);return this._createTimePicker(),this._dateTimeSwitcherActive=!R(this)&&this._timePicker&&!this._isInLine,e},_AfterCreateConverterCached:function(){var e=this._super(),t=function(){if(this._resolveDateTimeConverterBusyState&&(this._resolveDateTimeConverterBusyState(),delete this._resolveDateTimeConverterBusyState),null===this._timeConverter)throw new Error("Please use ojInputDate if your converter doesn't specify a time format.")}.bind(this);if(this._dateTimeConverterPromise){var i=this;this._dateTimeConverterPromise.then(function(){t(),delete i._dateTimeConverterPromise})}else t();return e},_setOption:function(e,t,i){var n=this._superApply(arguments);switch(e){case"value":var r=this._formatValueWithTimeConverter(this.options.value);this._previousValue=r;break;case"readOnly":this._isInLine||t||null!=this._switcherDiv||(this._createSwitcherDiv(),this._setupSwitcherButtons(),this._createTimePicker())}if(this._timePicker){var a={disabled:!0,readOnly:!0,keyboardEdit:!0,value:!0};if(e in a)this._timePicker.ojInputTime("option",e,t);else if("timePicker"===e)this._timePicker.ojInputTime("option","timePicker.timeIncrement",t.timeIncrement);else if("converter"===e){var s=function(t){this._createTimePickerConverter(t),this._timePicker.ojInputTime("option",e,this._timeConverter)}.bind(this),o=t||this._GetDefaultConverter();o instanceof Promise?o.then(function(e){s(e)}):o&&s(o)}}return n},_destroy:function(){return this._cleanUpDateTimeResources(),this._super()},_cleanUpDateTimeResources:function(){if(this._timePicker&&this._timePicker.ojInputTime("destroy"),this._isInLine)this._timePickerElement.remove();else if(this._switcherDiv){var e=this._switcherDiv.find("a");this._RemoveActiveable(e),this._RemoveHoverable(e),this._switcherDiv.remove()}},_formatValueWithTimeConverter:function(e){var t=e;try{this._getTimePickerConverter().format(e)}catch(e){f.info("The value of the InputDateTime element should be an ISOString, please use a valid ISOString"),t=this._getDefaultIsoDate()}return t},_GetCalendarTitle:function(){return this._EscapeXSS(this.getTranslatedString("tooltipCalendarTime"+(this.options.disabled?"Disabled":"")))},_generateSwitcher:function(){var e=document.createElement("div");e.className="oj-datetimepicker-switcher";var t=document.createElement("div");t.setAttribute("data-handler","switchMe"),t.setAttribute("data-event","click keydown");var i=document.createElement("div");return i.className="oj-inputdatetime-time-icon oj-clickable-icon-nocontext oj-component-icon oj-enabled oj-default",t.appendChild(i),(i=document.createElement("a")).addEventListener("click",e=>{e.preventDefault()}),i.setAttribute("href","#"),i.className="oj-enabled oj-datetimepicker-switcher-text",i.setAttribute("role","button"),t.appendChild(i),e.appendChild(t),(t=document.createElement("div")).className="oj-datetimepicker-switcher-buttons",(i=document.createElement("a")).addEventListener("click",e=>{e.preventDefault()}),i.setAttribute("href","#"),i.className="oj-enabled",i.setAttribute("data-handler","switchDone"),i.setAttribute("data-event","click keydown"),i.setAttribute("role","button"),i.textContent=this._EscapeXSS(this.getTranslatedString("done")),t.appendChild(i),(i=document.createElement("a")).addEventListener("click",e=>{e.preventDefault()}),i.setAttribute("href","#"),i.className="oj-enabled",i.setAttribute("data-handler","switchCancel"),i.setAttribute("data-event","click keydown"),i.setAttribute("role","button"),i.textContent=this._EscapeXSS(this.getTranslatedString("cancel")),t.appendChild(i),e.appendChild(t),e},_updateSwitcherText:function(){if(this._switcherDiv){H||(H=new _.IntlDateTimeConverter({day:"2-digit",month:"2-digit",year:J}));var e="";if(this._isShowingDatePickerSwitcher())try{e=H.format(this._switcherDateValue||this._getDateIso())}catch(t){e=H.format(this._getDefaultIsoDate())}else{W||(W=new _.IntlDateTimeConverter({hour:"2-digit",minute:"2-digit"}));try{e=this._getTimePickerConverter().format(this._switcherTimeValue||this._getDateIso())}catch(t){e=W.format(this._getDefaultIsoDate())}}t(".oj-datetimepicker-switcher-text",this._switcherDiv).text(e)}},_isShowingDatePickerSwitcher:function(){return!this._switcherDiv||0===t(".oj-inputdatetime-time-icon",this._switcherDiv).length},_togglePicker:function(){var e,i,n,r,a,s=this._switcherDiv,o=!this._isShowingDatePickerSwitcher();o?(r="oj-inputdatetime-calendar-icon",n="oj-inputdatetime-time-icon",a="Set Date"):(r="oj-inputdatetime-time-icon",n="oj-inputdatetime-calendar-icon",a="Set Time");var l=t(s.children()[0]).children();t(l[0]).removeClass(n).addClass(r),t(l[1]).text(a),(l=t(".oj-popup-content",this._popUpDpDiv.ojPopup("widget")).children())[0].classList.contains("oj-datepicker-popup")?(e=t(l[0]),i=t(l[1])):(e=t(l[1]),i=t(l[0])),o?(e.css("display","none"),i.css("display","block")):(i.css("display","none"),e.css("display","block")),this._updateSwitcherText()},_createTimePickerConverter:function(e){var t=this,i=function(e){return t._timeConverter=q(e),t._timeConverter};return e instanceof Promise?e.then(function(e){return i(e)}):i(e)},_getTimePickerConverter:function(){return this._timeConverter},timeSelected:function(e,t){if(this._dateTimeSwitcherActive)this._switcherTimeValue=e;else{var i=this._GetConverter().format(e);this._SetDisplayValue(i),this._SetValue(i,t)}},getValueForInputTime:function(){var e=null;if(this.isValid())e=this.options.value;else if(this._previousValue)try{e=this._GetConverter().parse(this._previousValue)}catch(t){e=this.options.value}else e=null;return this._isDateTimeSwitcher()&&(e=this._switcherDateValue||e,this._switcherTimeValue&&e&&(e=h.IntlConverterUtils._copyTimeOver(this._switcherTimeValue,e))),e},_SetValue:function(e,t,i){var n=this._superApply(arguments);return this._previousValue=e,n},_SetDisplayValue:function(e){if(this._isInLine){var t=!(this._isInLine&&!this._dpDiv[0].contains(document.activeElement));this._updateDatepicker(t)}else this._superApply(arguments),this._updateSwitcherText();this._switcherTimeValue=null},_onKeyDownHandler:function(e){var i=t.ui.keyCode,n=!1;switch(e.keyCode){case i.UP:case i.DOWN:e.shiftKey&&(this._SetValue(this._GetDisplayValue(),e),this._timePicker.ojInputTime("show"),n=!0)}return n?(e.preventDefault(),e.stopPropagation(),!1):this._superApply(arguments)},show:function(){return this._isShowingDatePickerSwitcher()&&this._togglePicker(),this._super()},_ShowNativeDatePicker:function(e){e.mode="datetime";var t=z(this.options.timePicker.timeIncrement);return e.minuteInterval=0===t.hourIncr?t.minuteIncr:1,this._super(e)},_OnDatePicked:function(e){if(this._nativePickerShowing=!1,e){var t;t=this._validateDatetime(this._getDateIso(),{month:e.getMonth(),date:e.getDate(),fullYear:e.getFullYear(),hours:e.getHours(),minutes:e.getMinutes(),seconds:e.getSeconds()});var i=this._GetConverter().format(t);this._SetValue(i,{})}this._onClose(this._ON_CLOSE_REASON_SELECTION)},_ShowHTMLDatePicker:function(){var e=this._superApply(arguments),t=this._GetConverter();return this._switcherPrevValue=t instanceof Promise?this.options.value?this._getDateIso():"":t.parse(this.options.value?this._getDateIso():""),this._switcherPrevDay=this._currentDay,this._switcherPrevMonth=this._currentMonth,this._switcherPrevYear=this._currentYear,this._updateSwitcherText(),e},showTimePicker:function(){this._datepickerShowing()||this.show(),this._isShowingDatePickerSwitcher()||this._timePicker.ojInputTime("show")},hideTimePicker:function(){return this.hide()},refresh:function(){var e=this._superApply(arguments)||this;return this._timePicker&&this._timePicker.ojInputTime("refresh"),this._switcherDiv&&(t("a[data-handler='switchDone']",this._switcherDiv).text(this.getTranslatedString("done")),t("a[data-handler='switchCancel']",this._switcherDiv).text(this.getTranslatedString("cancel"))),e},getNodeBySubId:function(e){var i=e&&e.subId,n=null;return i&&(n="oj-inputdatetime-date-input"===i?this._isInLine?this._timePickerElement[0]:this.element[0]:"oj-inputdatetime-calendar-clock-icon"===i?t(".oj-inputdatetime-calendar-clock-icon",this._triggerNode)[0]:this._timePicker?this._timePicker.ojInputTime("getNodeBySubId",e):null),n||this._superApply(arguments)},getSubIdByNode:function(e){var i=null;return this._isInLine?e===this._timePickerElement[0]&&(i="oj-inputdatetime-date-input"):e===this.element[0]?i="oj-inputdatetime-date-input":e===t(".oj-inputdatetime-calendar-clock-icon",this._triggerNode)[0]&&(i="oj-inputdatetime-calendar-clock-icon"),i||(this._timePicker?this._timePicker.ojInputTime("getSubIdByNode",e):null)||this._superApply(arguments)},_GetConverter:function(){if(this.options.converter)return this._superApply(arguments);var e=this._GetDefaultConverter();return this.option("converter",e,{_context:{writeback:!0,internalSet:!0}}),e},_NotifyDetached:function(){this._timePicker&&this.hideTimePicker(),this._superApply(arguments)},_NotifyHidden:function(){this._timePicker&&this.hideTimePicker(),this._superApply(arguments)},_GetMessagingLauncherElement:function(){return this._isInLine?this._timePickerElement:this._super()},_GetDefaultStyleClass:function(){return"oj-inputdatetime"},_SetLoading:function(){this._super(),this._timePicker&&this._timePicker.ojInputTime("option","readOnly",!0)},_ClearLoading:function(){this._super(),this._timePicker&&this._timePicker.ojInputTime("option","readOnly",this.options.readOnly)},_GetTranslationsSectionName:function(){return"oj-ojInputDate"}}),u.setDefaultOptions({ojInputDateTime:{converter:u.createDynamicPropertyGetter(function(){return null==Z&&(Z=$()),Z})}})});
//# sourceMappingURL=ojdatetimepicker.js.map;

define("jetDatePickerBundle.min", function(){});
