/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojdvt-toolkit',["exports","ojs/ojthemeutils"],function(t,e){"use strict";const i=function(){};i._GET_FUNCTION_NAME_REGEXP=/function\s+([\S^]+)\s*\(/,i.createSubclass=function(t,e){var n=i._tempSubclassConstructor;n.prototype=e.prototype,t.prototype=new n,t.prototype.constructor=t,t.superclass=e.prototype},i._tempSubclassConstructor=function(){},i.prototype.clone=function(){return null},i.createCallback=function(t,e){return function(){return e.apply(t,arguments)}},i.compareValues=function(t,e,i){return t.oj.KeyUtils.equals(e,i)};const n=function(t,e){this.x=null===t||isNaN(t)?0:t,this.y=null===e||isNaN(e)?0:e};n.prototype.equals=function(t){return t instanceof n&&this.x===t.x&&this.y===t.y};const r=function(){};var o;r.setAgentInfo=function(t){o=t},r.getAgentInfo=function(){return o},Object.defineProperty(r,"browser",{enumerable:!0,get:function(){return r.getAgentInfo().browser}}),Object.defineProperty(r,"engine",{enumerable:!0,get:function(){return r.getAgentInfo().engine}}),Object.defineProperty(r,"version",{enumerable:!0,get:function(){return r.getAgentInfo().browserVersion}}),Object.defineProperty(r,"os",{enumerable:!0,get:function(){return r.getAgentInfo().os.toLowerCase()}}),i.createSubclass(r,i),r.FOCUS_COLOR_DEFAULT="#0645AD",r.FOCUS_COLOR_IE="#090909",r.deferAriaCreation=function(){return!r.isTouchDevice()&&!r.isEnvironmentTest()},r.getDevicePixelRatio=function(){return r._initialize(),r._devicePixelRatio},r.getElementPosition=function(t){return"ie"===r.browser||"edge"===r.browser?r._getElementPositionIE(t):r._getElementPositionDefault(t)},r.isRightToLeft=function(t){return r._initialize(),t&&null!=t.getReadingDirection()?"rtl"==t.getReadingDirection():r._bRtl},r.isTouchDevice=function(){return r._initialize(),r._bTouchDevice},r.setEnvironment=function(t){r._environment=t},r.isEnvironmentTest=function(){return"test"==r._environment},r.setHighContrast=function(t){r._highContrast=t},r.isHighContrast=function(){return!0===r._highContrast},r.workaroundFirefoxRepaint=function(t){if("firefox"===r.browser){var e=t.getParent();if(e){var i=e.getChildIndex(t);e.removeChildAt(i),e.addChildAt(t,i)}}},r._initialize=function(){r._bInitialized||(r._bRtl=!(!document||!document.documentElement)&&"rtl"==document.documentElement.dir,r._bTouchDevice="ios"===r.os||"android"===r.os,r._devicePixelRatio=window&&null!=window.devicePixelRatio?window.devicePixelRatio:1,r._bInitialized=!0)},r._getElementPositionDefault=function(t){var e=t.getBoundingClientRect(),i=Math.round(e.top),r=e.left,o=t.ownerDocument.documentElement,s=t.ownerDocument.body;return r+=o.scrollLeft||s.scrollLeft,i+=o.scrollTop||s.scrollTop,new n(r,i)},r._getElementPositionIE=function(t){var e=t.getBoundingClientRect(),i=e.top,r=e.left,o=t.ownerDocument.documentElement,s=o.scrollLeft;return r-=o.clientLeft-s,i-=o.clientTop-o.scrollTop,new n(r,i)},r.getFocusColor=function(){if(r._initialize(),!r._focusColor){var t;if("blink"===r.engine||"safari"===r.browser){var e=document.getElementsByTagName("body")[0],i=document.createElement("div");e.appendChild(i),i.style.outline="-webkit-focus-ring-color",t=window.getComputedStyle(i).getPropertyValue("outline-color"),e.removeChild(i)}else"ie"!==r.browser&&"edge"!==r.browser||(t=r.FOCUS_COLOR_IE);r._focusColor=t||r.FOCUS_COLOR_DEFAULT}return r._focusColor};const s={};i.createSubclass(s,i),s.getDragFeedbackBounds=function(t,e){if(!t)return null;var i=null;if(t instanceof Array){if(t.length>0){i=t[0].getDimensions(e||t[0].getParent());for(var n=1;n<t.length;n++){var r=t[n],o=r.getDimensions(e||r.getParent());o.x<i.x&&(i.w+=i.x-o.x,i.x=o.x),o.y<i.y&&(i.h+=i.y-o.y,i.y=o.y),o.x+o.w>i.x+i.w&&(i.w=o.x+o.w-i.x),o.y+o.h>i.y+i.h&&(i.h=o.y+o.h-i.y)}}}else i=t.getDimensions(e||t.getParent());return i};const a=function(t){this.Init(t)};i.createSubclass(a,i),a.DRAG_FEEDBACK_MARGIN=2,a.prototype.Init=function(t){this._context=t,this._dragCandidate=null,this._dragObj=null,this._dragCoords=null},a.prototype.getDragCandidate=function(){return this._dragCandidate},a.prototype.setDragCandidate=function(t){t&&t.isDragAvailable&&t.getDragTransferable?this._dragCandidate=t:this._dragCandidate=null},a.prototype.isDragAvailable=function(t){return null!=this._dragCandidate?this._dragCandidate.isDragAvailable(t):null},a.prototype.getDragTransferable=function(t,e){return this._dragCandidate?(this._dragObj=this._dragCandidate,this._dragCoords={x:t,y:e},this._dragCandidate.getDragTransferable(t,e)):null},a.prototype.getDragOverFeedback=function(t,e){this._context.getTooltipManager().hideTooltip();var i=this.getDragObject();return i&&i.getDragFeedback?i.getDragFeedback(t,e):null},a.prototype.getDragContext=function(t,e){return this._dragObj&&this._dragObj.getDragContext?this._dragObj.getDragContext(t,e):null},a.prototype.getDragObject=function(){return this._dragObj},a.prototype.getDragCoords=function(){return this._dragCoords},a.prototype.getDragOffset=function(t,e){var i={},n=this.getDragOverFeedback(t,e);if(n){var r=s.getDragFeedbackBounds(n,this._context.getStage()),o=this.getDragObject();o&&o.afterDragOverFeedback&&o.afterDragOverFeedback(n),r&&(i.x=t-r.x,i.y=e-r.y,i.x+=a.DRAG_FEEDBACK_MARGIN,i.y+=a.DRAG_FEEDBACK_MARGIN)}else i.x=0,i.y=0;return i},a.prototype.getPointerOffset=function(t,e){return{x:0,y:0}},a.prototype.initiateDrag=function(){var t=this.getTouchManager();r.isTouchDevice()&&t&&t.cancelTouchHold()},a.prototype.dragDropEnd=function(){this._dragCandidate=null,this._dragObj=null,this._dragCoords=null},a.prototype.setTouchManager=function(t){this._touchManager=t},a.prototype.getTouchManager=function(){return this._touchManager};const h=function(t,e){this.w=null===t||isNaN(t)?0:t,this.h=null===e||isNaN(e)?0:e},l=function(t,e,i,n,r,o){this._a=null==t?1:t,this._b=null==e?0:e,this._c=null==i?0:i,this._d=null==n?1:n,this._tx=null==r?0:r,this._ty=null==o?0:o,this._u=0,this._v=0,this._w=1};i.createSubclass(l,i),l._DECOMP_TX=0,l._DECOMP_TY=1,l._DECOMP_R=2,l._DECOMP_SKEWX=3,l._DECOMP_SX=4,l._DECOMP_SY=5,l.prototype.getA=function(){return this._a},l.prototype.getB=function(){return this._b},l.prototype.getC=function(){return this._c},l.prototype.getD=function(){return this._d},l.prototype.getTx=function(){return this._tx},l.prototype.getTy=function(){return this._ty},l.prototype.concat=function(t){var e=this._a*t.getA()+this._c*t.getB()+this._u*t.getTx(),i=this._b*t.getA()+this._d*t.getB()+this._v*t.getTx(),n=this._tx*t.getA()+this._ty*t.getB()+this._w*t.getTx(),r=this._a*t.getC()+this._c*t.getD()+this._u*t.getTy(),o=this._b*t.getC()+this._d*t.getD()+this._v*t.getTy(),s=this._tx*t.getC()+this._ty*t.getD()+this._w*t.getTy();return new l(e,i,r,o,n,s)},l.prototype.translate=function(t,e){return this.concat(new l(1,0,0,1,t,e))},l.prototype.scale=function(t,e,i,n){var r=this;(i||n)&&(r=this.translate(-i,-n));var o=new l(t,0,0,e);return r=r.concat(o),(i||n)&&(r=r.translate(i,n)),r},l.prototype.rotate=function(t){var e=Math.cos(t),i=Math.sin(t),n=new l(e,-i,i,e);return this.concat(n)},l.prototype.skew=function(t,e){var i=new l(1,Math.tan(t),Math.tan(e),1);return this.concat(i)},l.prototype._determinant=function(){return this._a*(this._d*this._w-this._ty*this._v)-this._b*(this._c*this._w-this._ty*this._u)+this._tx*(this._c*this._v-this._d*this._u)},l.prototype.invert=function(){var t=this._determinant(),e=this._d*this._w-this._ty*this._v,i=this._tx*this._v-this._b*this._w,n=this._b*this._ty-this._tx*this._d,r=this._ty*this._u-this._c*this._w,o=this._a*this._w-this._tx*this._u,s=this._tx*this._c-this._a*this._ty;return new l(e/t,i/t,r/t,o/t,n/t,s/t)},l.prototype._decompose=function(){var t=this._a,e=this._b,i=this._c,n=this._d,r=this._tx,o=this._ty;if(t*n-e*i==0)return null;var s=Math.sqrt(t*t+i*i),a=(t/=s)*e+(i/=s)*n;e-=t*a,n-=i*a;var h=Math.sqrt(e*e+n*n);return a/=h,-1===t*(n/=h)-(e/=h)*i&&(a=-a,h=-h),[r,o,Math.atan2(i,t),Math.atan(a),s,h]},l.prototype._recompose=function(t){var e=new l,i=t[0],n=t[1],r=t[2],o=t[3],s=t[4],a=t[5];return(e=(e=(e=e.scale(s,a)).skew(o,0)).rotate(r)).translate(i,n)},l.prototype.equals=function(t){return!(!this&&t)&&(!(this&&!t)&&(!this&&!t||this._a===t.getA()&&this._b===t.getB()&&this._c===t.getC()&&this._d===t.getD()&&this._tx===t.getTx()&&this._ty===t.getTy()))},l.prototype.transformPoint=function(t){var e=this._a*t.x+this._b*t.y+1*this._tx,i=this._c*t.x+this._d*t.y+1*this._ty;return new n(e,i)},l.prototype.isIdentity=function(){return 1===this._a&&0===this._b&&0===this._c&&1===this._d&&0===this._tx&&0===this._ty};const u={};i.createSubclass(u,i),u.SVG_NS="http://www.w3.org/2000/svg",u.XLINK_NS="http://www.w3.org/1999/xlink",u._IMAGE_URL_CACHE={},u._ICON_CACHE={},u.createSvgDocument=function(t){var e=document.createElementNS(u.SVG_NS,"svg");return null!=t&&u.setAttrNullNS(e,"id",t),u.setAttrNullNS(e,"width","100%"),u.setAttrNullNS(e,"height","100%"),"ie"!==r.browser&&"edge"!==r.browser||u.setAttrNullNS(e,"focusable","false"),e},u.getDragFeedback=function(t,e){var i=new Object;if(!t)return i.width=1,i.height=1,i.svg=u.createSvgDocument("dnd"),i;t instanceof Array||(t=[t]);var n=s.getDragFeedbackBounds(t,e),r=u._getDragFeedbackSVG(t,n);return i.width=n.w+2*a.DRAG_FEEDBACK_MARGIN,i.height=n.h+2*a.DRAG_FEEDBACK_MARGIN,r&&(i.svg=r),i},u._getDragFeedbackSVG=function(t,e){var i=u.createSvgDocument("dnd");u.setAttrNullNS(i,"class","oj-drag");var n="translate("+(a.DRAG_FEEDBACK_MARGIN-e.x)+","+(a.DRAG_FEEDBACK_MARGIN-e.y)+")",r=document.createElementNS(u.SVG_NS,"g");u.setAttrNullNS(r,"transform",n),u.appendChildElem(i,r);for(var o=0;o<t.length;o++){var s=t[o],h=s.getElem().cloneNode(!0);u.getAttrNullNS(h,"filter")&&u.setAttrNullNS(h,"filter",null);var l=document.createElementNS(u.SVG_NS,"g");u.appendChildElem(r,l);for(var c=s.getPathToStage(),_=null,p=1;p<c.length;p++)_=_?_.concat(c[p].getMatrix()):c[p].getMatrix();if(_){var d="matrix("+_.getA()+","+_.getC()+","+_.getB()+","+_.getD()+","+_.getTx()+","+_.getTy()+")";u.setAttrNullNS(l,"transform",d)}u.appendChildElem(l,h)}return i},u.addDomEventListener=function(t,e,i,n){t&&t.addEventListener&&t.addEventListener(e,i,n)},u.removeDomEventListener=function(t,e,i,n){t&&t.removeEventListener&&t.removeEventListener(e,i,n)},u.appendChildElem=function(t,e){return t.appendChild(e)},u.removeChildElem=function(t,e){return e.parentNode!=t?null:t.removeChild(e)},u.getAttrNullNS=function(t,e){return t.getAttribute(e)},u.hasAttrNullNS=function(t,e){return t.hasAttribute(e)},u.setAttrNullNS=function(t,e,i,n){null==n||i!=n?t.setAttribute(e,i):u.hasAttrNullNS(t,e)&&u.removeAttrNullNS(t,e)},u.removeAttrNullNS=function(t,e){u.hasAttrNullNS(t,e)&&t.removeAttribute(e)},u.setHref=function(t,e){"safari"===r.browser||"firefox"===r.browser&&r.version<51?t.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",e):u.setAttrNullNS(t,"href",e)},u.getLinkCallback=function(t,e){if(t||e){var i=this;return function(){if(null==t)i.location=e;else{var n=window.open(e,t);n&&n.focus()}}}return null},u.getUrlPathById=function(t){return(("ie"===r.browser||"edge"===r.browser?null!=document.querySelector("base"):document.URL!=document.baseURI)?document.URL.split("#")[0]+"#":"#")+t},u.getUrlById=function(t){return"url("+u.getUrlPathById(t)+")"},u.setSvgSize=function(t,e,i){var n=t.getSvgDocument();u.setAttrNullNS(n,"width",e+"px"),u.setAttrNullNS(n,"height",i+"px")},u.getOuterDivSize=function(t){var e=t.getSvgDocument().parentNode,i=window.getComputedStyle(e);return new h(parseFloat(i.width),parseFloat(i.height))},u.getEventForSyntax=function(t,e){var i=e.getNativeEvent();if(!t.isCustomElement()&&"undefined"!=typeof $){var n=$.event.fix(i);return n.dataTransfer=i.dataTransfer,n}return i},u.getImageUrl=function(t,e){return null==e||-1!==e.indexOf(".")?e:u.getImageUrls(t,[e])[e]},u.getImageUrls=function(t,e){if(0==e.length)return{};var i={},n=document.createElement("div");n.style.display="none";for(var r=0;r<e.length;r++){var o,s,a=e[r];null!=a&&(-1===a.indexOf(".")?null==(o=u._IMAGE_URL_CACHE[a])?((s=document.createElement("div")).className=a,u.appendChildElem(n,s)):i[a]=o:i[a]=a)}return n.hasChildNodes()?(u.appendChildElem(t.getContainer(),n),Array.prototype.forEach.call(n.childNodes,function(t){var e=t.className,n=window.getComputedStyle(t).getPropertyValue("background-image");n=n&&-1!==n.indexOf("url(")?n.slice(n.indexOf("url(")+4,n.length-1).replace(/["']/g,""):e,i[e]=n,u._IMAGE_URL_CACHE[e]=n}),u.removeChildElem(t.getContainer(),n),i):i},u.getIconStyle=function(t,e){return u.getIconStyles(t,[e])[e]},u.getIconStyles=function(t,e){if(0==e.length)return{};var i={},n=document.createElement("div"),r=n.style;r.width="0px",r.height="0px",r.visibility="hidden";for(var o=0;o<e.length;o++){var s,a,h=e[o];null!=h&&(null==(s=u._ICON_CACHE[h])?((a=document.createElement("div")).className=h,u.appendChildElem(n,a)):i[h]=s)}return n.hasChildNodes()?(u.appendChildElem(t.getContainer(),n),Array.prototype.forEach.call(n.childNodes,function(t){var e,n=t.className,r=window.getComputedStyle(t,":before"),o=r.getPropertyValue("content"),s=o.charAt('"'===o.charAt(0)?1:0),a=r.getPropertyValue("transform");if("none"===a)e=new l;else{var h=a.match(/matrix\((.*)\)/)[1].split(", ").map(t=>Number(t));e=new l(...h)}var c={character:s,transform:e};i[n]=c,u._ICON_CACHE[n]=c}),u.removeChildElem(t.getContainer(),n),i):i},u.addClassName=function(t,e){if(t&&e)if(u.hasAttrNullNS(t,"class")){var i=u.getAttrNullNS(t,"class").split(" ");-1==i.indexOf(e)&&(i.push(e),u.setAttrNullNS(t,"class",i.join(" ")))}else u.setAttrNullNS(t,"class",e)},u.removeClassName=function(t,e){if(t&&e&&u.hasAttrNullNS(t,"class")){var i=u.getAttrNullNS(t,"class").split(" "),n=i.indexOf(e);n>=0&&(i.splice(n,1),u.setAttrNullNS(t,"class",i.join(" ")))}},u.getGrabCursor=function(){return"ie"===r.browser?"move":"grab"},u.getGrabbingCursor=function(){return"ie"===r.browser?"move":"grabbing"},u.cleanDragDataContext=function(t){return delete t.componentElement,delete t.component,t},u.getUseCaptureFromOptions=function(t){return null!=t&&("boolean"==typeof t?t:t.capture||!1)};const c=function(t){return r.isTouchDevice()&&"chrome"===r.browser?window.setTimeout(t,1e3/60):window.requestAnimationFrame(t)},_=function(t){r.isTouchDevice()&&"chrome"===r.browser?clearTimeout(t):window.cancelAnimationFrame(t)},p=function(t){this._id=(t?t+"$":"")+"cp"+p._uniqueSeed++,this._regions=[]};i.createSubclass(p,i),p._uniqueSeed=0,p.NONE=0,p.RECT=1,p.PATH=2,p.POLYGON=3,p.CIRCLE=5,p.prototype.getId=function(){return this._id},p.prototype.getRegions=function(t){return this._regions},p.prototype.addRect=function(t,e,i,n,r,o){var s={type:p.RECT,x:t,y:e,w:i,h:n,rx:r,ry:o};this._regions.push(s)},p.prototype.addCircle=function(t,e,i){var n={type:p.CIRCLE,cx:t,cy:e,r:i};this._regions.push(n)},p.prototype.addPolygon=function(t){var e={type:p.POLYGON,points:t};this._regions.push(e)},p.prototype.addPath=function(t){var e={type:p.PATH,d:t};this._regions.push(e)};const d=new Object;i.createSubclass(d,i),d.removeItem=function(t,e){var i=t.indexOf(e);i>-1&&t.splice(i,1)},d.insert=function(t,e,i){if(!Array.isArray(t))return null;if(!Array.isArray(e))return t;var n;if(0===i)n=e.concat(t);else if(i>0&&i<t.length){var r=t.splice(0,i);n=(r=r.concat(e)).concat(t)}else n=t.concat(e);return n},d.equals=function(t,e){if(!t&&e)return!1;if(t&&!e)return!1;if(t||e){if(t.length!=e.length)return!1;for(var i=0;i<=t.length;i++)if(t[i]!==e[i])return!1;return!0}return!0},d.hasAnyMapItem=function(t,e){if(!t||!e)return!1;for(var i=0;i<e.length;i++)if(t[e[i]])return!0;return!1},d.hasAllMapItems=function(t,e){if(!t||!e)return!1;for(var i=0;i<e.length;i++)if(!t[e[i]])return!1;return!0},d.hasAnyItem=function(t,e){return d.hasAnyMapItem(d.createBooleanMap(t),e)},d.hasAllItems=function(t,e){return d.hasAllMapItems(d.createBooleanMap(t),e)},d.createBooleanMap=function(t){if(!t)return null;for(var e={},i=0;i<t.length;i++)e[t[i]]=!0;return e};const g=function(t,e,i,n){this.Init(t,e,i,n)};i.createSubclass(g,i),g.prototype.getAlphas=function(){return this._arAlphas},g.prototype.getBounds=function(){return this._arBounds},g.prototype.getColors=function(){return this._arColors},g.prototype.getStops=function(){return this._arStops},g.prototype.Init=function(t,e,i,n){if(!e&&(e=[],t))for(var r=0;r<t.length;r++)e.push(1);var o=t?t.length-1:0;if(!i){i=[];var s=o>0?1/o:0,a=0;do{i.push(a),a+=s}while(--o>0);i.push(1)}this._arColors=t,this._arAlphas=e,this._arStops=i,this._arBounds=n},g.prototype.equals=function(t){return t instanceof g&&d.equals(this.getColors(),t.getColors())&&d.equals(this.getStops(),t.getStops())&&d.equals(this.getAlphas(),t.getAlphas())&&d.equals(this.getBounds(),t.getBounds())};const f=function(){};i.createSubclass(f,i),f.createElem=function(t,e){var i,n=document.createElementNS(u.SVG_NS,"linearGradient");u.setAttrNullNS(n,"id",e);var r=t.getColors(),o=t.getAlphas(),s=t.getStops(),a=t.getBounds(),h=r.length;for(i=0;i<h;i++){var l=document.createElementNS(u.SVG_NS,"stop");u.setAttrNullNS(l,"offset",100*s[i]+"%");var c=r[i];if(c){var _=o[i];u.setAttrNullNS(l,"stop-color",c),null!=_&&u.setAttrNullNS(l,"stop-opacity",_,1)}u.appendChildElem(n,l)}var p=!a||0==a[0]&&0==a[1]&&0==a[2]&&0==a[3],d=t.getAngle(),g="0%",f="0%",y="100%",v="0%",S=!0;if(p)45===d?(f="100%",y="100%"):90===d?(f="100%",y="0%"):135===d?(g="100%",y="0%",v="100%"):270===d?(y="0%",v="100%"):0!==d&&(d=-d,u.setAttrNullNS(n,"gradientTransform","rotate("+d+" .5 .5)"),S=!1);else{u.setAttrNullNS(n,"gradientUnits","userSpaceOnUse"),g="0",f="0.5",y="1",v="0.5";var T=a[2],E=a[3],m=a[0],b=a[1],C="scale("+T+" "+E+")"+" "+("rotate("+(d=-d)+" .5 .5)");0==m&&0==b||(C="translate("+m+" "+b+")"+" "+C),u.setAttrNullNS(n,"gradientTransform",C)}return S&&(u.setAttrNullNS(n,"x1",g),u.setAttrNullNS(n,"y1",f),u.setAttrNullNS(n,"x2",y),u.setAttrNullNS(n,"y2",v)),n};const y=function(t,e,i,n){this._pattern=t?y._convertPatternValue(t):y.SM_DIAG_UP_LT,this._fillColor=e||"#000000",this._backgroundColor=i||"#ffffff",this._matrix=n};i.createSubclass(y,i),y.SM_DIAG_UP_LT="sDUL",y.LG_DIAG_UP_LT="lDUL",y.SM_DIAG_UP_RT="sDUR",y.LG_DIAG_UP_RT="lDUR",y.SM_CROSSHATCH="sC",y.LG_CROSSHATCH="lC",y.SM_CHECK="sCh",y.LG_CHECK="lCh",y.SM_TRIANGLE_CHECK="sTCh",y.LG_TRIANGLE_CHECK="lTCh",y.SM_DIAMOND_CHECK="sDCh",y.LG_DIAMOND_CHECK="lDCh",y.prototype.getPattern=function(){return this._pattern},y.prototype.getColor=function(){return this._fillColor},y.prototype.getBackgroundColor=function(){return this._backgroundColor},y.prototype.equals=function(t){return t instanceof y&&t.getPattern()==this.getPattern()&&t.getColor()==this.getColor()&&t.getBackgroundColor()==this.getBackgroundColor()},y.prototype.getMatrix=function(){return this._matrix||new l},y._convertPatternValue=function(t){return"smallDiagonalLeft"==t?y.SM_DIAG_UP_LT:"largeDiagonalLeft"==t?y.LG_DIAG_UP_LT:"smallDiagonalRight"==t?y.SM_DIAG_UP_RT:"largeDiagonalRight"==t?y.LG_DIAG_UP_RT:"smallCrosshatch"==t?y.SM_CROSSHATCH:"largeCrosshatch"==t?y.LG_CROSSHATCH:"smallChecker"==t?y.SM_CHECK:"largeChecker"==t?y.LG_CHECK:"smallTriangle"==t?y.SM_TRIANGLE_CHECK:"largeTriangle"==t?y.LG_TRIANGLE_CHECK:"smallDiamond"==t?y.SM_DIAMOND_CHECK:"largeDiamond"==t?y.LG_DIAMOND_CHECK:t};const v=function(t){this.Init(t)};i.createSubclass(v,i),v._TARGET_SIZE=1e3,v._BUFFER_SIZE=.5,v.prototype.Init=function(t){this._targetSize=null!=t?t:v._TARGET_SIZE,this._maxSize=Math.ceil(this._targetSize*(1+v._BUFFER_SIZE)),this._cache={},this._lruArray=[],this._hits=0,this._misses=0},v.prototype.get=function(t){var e=this._cache[t];return null!=e?(this._hits++,e):(this._misses++,null)},v.prototype.put=function(t,e){var i=null!=this._cache[t];if(this._cache[t]=e,i){var n=this._lruArray.indexOf(t);this._lruArray.splice(n,1),this._lruArray.push(t)}else if(this._lruArray.push(t),this._lruArray.length>this._maxSize)for(var r=this._lruArray.splice(0,this._maxSize-this._targetSize),o=0;o<r.length;o++)delete this._cache[r[o]]},v.prototype.toString=function(){var t="Cache Size: "+this._lruArray.length;return t+="\nHits: "+this._hits,t+="\nMisses: "+this._misses,t+="\nHit %: "+Math.round(1e4*this._hits/(this._hits+this._misses))/100};const S=new Object;i.createSubclass(S,i),S.RADS_PER_DEGREE=Math.PI/180,S.DEGREES_PER_RAD=180/Math.PI,S.TWO_PI=2*Math.PI,S.HALF_PI=Math.PI/2,S.QUARTER_PI=Math.PI/4,S.TOLERANCE=.1,S.degreesToRads=function(t){return t*S.RADS_PER_DEGREE},S.radsToDegrees=function(t){return t*S.DEGREES_PER_RAD},S.interpolateNumber=function(t,e,i){return t+i*(e-t)},S.log10=function(t){return Math.log(t)/Math.LN10},S.calculateAngleBetweenTwoVectors=function(t,e,i,n){var r=Math.atan2(n,i)-Math.atan2(e,t);return r<0?r+S.TWO_PI:r};const T={};i.createSubclass(T,i),T._RED=0,T._GREEN=1,T._BLUE=2,T._ALPHA=3,T._RGBA="rgba(",T._RGB="rgb(",T._POUND="#",T._FACTOR=.15,T._names,T._CONTRASTING_TEXT_COLOR_CACHE={},T.getColorFromName=function(t){if(!T._names){var e={aliceblue:"#f0f8ff",antiquewhite:"#faEbd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffE4c4",black:"#000000",blanchedalmond:"#ffEbcd",blue:"#0000ff",blueviolet:"#8a2bE2",brown:"#a52a2a",burlywood:"#dEb887",cadetblue:"#5f9Ea0",chartreuse:"#7fff00",chocolate:"#d2691E",coral:"#ff7f50",cornflowerblue:"#6495Ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#E9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00cEd1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1E90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4","indianred ":"#cd5c5c","indigo ":"#4b0082",ivory:"#fffff0",khaki:"#f0E68c",lavender:"#E6E6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8E6",lightcoral:"#f08080",lightcyan:"#E0ffff",lightgoldenrodyellow:"#fafad2",lightgray:"#d3d3d3",lightgreen:"#90EE90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cEfa",lightslategray:"#778899",lightsteelblue:"#b0c4dE",lightyellow:"#ffffE0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0E6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370db",mediumseagreen:"#3cb371",mediumslateblue:"#7b68EE",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffE4E1",moccasin:"#ffE4b5",navajowhite:"#ffdEad",navy:"#000080",oldlace:"#fdf5E6",olive:"#808000",olivedrab:"#6b8E23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#EEE8aa",palegreen:"#98fb98",paleturquoise:"#afEEEE",palevioletred:"#db7093",papayawhip:"#ffEfd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0E0E6",purple:"#800080",rebeccapurple:"#663399",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169E1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2E8b57",seashell:"#fff5EE",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87cEEb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40E0d0",violet:"#EE82EE",wheat:"#f5dEb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32",transparent:"rgba(255,255,255,0)"};T._names=e}return T._names[t.toLowerCase()]},T._getChannel=function(t,e){var i=e,n=null,r=T.getColorFromName(i);if(r&&(i=r),t===T._ALPHA){if("#"===i.charAt(0))return i.length>7?parseInt(i.substring(1,3),16)/255:1;if("none"===i)return 0}var o,s=i.indexOf("(");return s<0?(o=[],i.length>7?(o[0]=parseInt(i.substr(3,2),16),o[1]=parseInt(i.substr(5,2),16),o[2]=parseInt(i.substr(7,2),16),o[3]=parseInt(i.substr(1,2),16)/255):(o[0]=parseInt(i.substr(1,2),16),o[1]=parseInt(i.substr(3,2),16),o[2]=parseInt(i.substr(5,2),16),o[3]=1),n=o[t]):n=3===(o=i.substring(s+1).match(/[^,|)]+/gm)).length&&t===T._ALPHA?1:parseFloat(o[t]),n},T.getDarker=function(t,e){var i=T.getRed(t),n=T.getGreen(t),r=T.getBlue(t),o=T.getAlpha(t);return e||(e=T._FACTOR),i=Math.max(parseInt(i*(1-e)),0),n=Math.max(parseInt(n*(1-e)),0),r=Math.max(parseInt(r*(1-e)),0),T.makeRGBA(i,n,r,o)},T.getBrighter=function(t,e){var i=T.getAlpha(t),n=T.getRed(t),r=T.getGreen(t),o=T.getBlue(t);e||(e=T._FACTOR);var s=Math.min(n+parseInt((255-n)*e),255),a=Math.min(r+parseInt((255-r)*e),255),h=Math.min(o+parseInt((255-o)*e),255);return T.makeRGBA(s,a,h,i)},T.makeRGB=function(t,e,i){return i=null===i||isNaN(i)?0:i,e=null===e||isNaN(e)?0:e,t=null===t||isNaN(t)?0:t,T._RGB+t+","+e+","+i+")"},T.makeRGBA=function(t,e,i,n){return i=null===i||isNaN(i)?0:Math.round(i),e=null===e||isNaN(e)?0:Math.round(e),t=null===t||isNaN(t)?0:Math.round(t),n=null===n||isNaN(n)?1:n,T._RGBA+t+","+e+","+i+","+n+")"},T.makePound=function(t,e,i){var n=Math.round(t),r=Math.round(e),o=Math.round(i),s=n.toString(16),a=r.toString(16),h=o.toString(16);return"#"+(1===s.length?"0":"")+s+(1===a.length?"0":"")+a+(1===h.length?"0":"")+h},T.getPound=function(t){var e;if("#"===t.charAt(0)){if(t.length<=7)return t;e=T._POUND,e+=t.substring(3,5)+t.substring(5,7)+t.substring(7,9)}else{var i=T.getRed(t),n=T.getGreen(t),r=T.getBlue(t);e=T.makePound(i,n,r)}return e},T.getRGB=function(t){var e,i=T.getColorFromName(t);if(i&&(t=i),"#"===t.charAt(0)){e=T._RGB;var n=t.length;if(n>7)e+=parseInt(t.substring(3,5),16)+","+parseInt(t.substring(5,7),16)+","+parseInt(t.substring(7,9),16);else if(7===n)e+=parseInt(t.substring(1,3),16)+","+parseInt(t.substring(3,5),16)+","+parseInt(t.substr(5),16);else if(4===n){var r=t.substring(1,2);r+=r;var o=t.substring(2,3);o+=o;var s=t.substring(3);s+=s,e+=parseInt(r,16)+","+parseInt(o,16)+","+parseInt(s,16)}else 5===n?e+=parseInt(t.substring(1,3),16)+","+parseInt(t.substring(3,5),16)+",0,1":3===n&&(e+=parseInt(t.substring(1,3),16)+",0,0,1");e+=")"}else if(t.substr(0,5)===T._RGBA){var a=t.lastIndexOf(",");e=T._RGB,e+=t.substring(5,a),e+=")"}else e=t;return e},T.getRGBA=function(t){var e,i=T.getColorFromName(t);if(i&&(t=i),"#"===t.charAt(0)){e=T._RGBA;var n=t.length;if(n>7)e+=parseInt(t.substring(3,5),16)+","+parseInt(t.substring(5,7),16)+","+parseInt(t.substring(7,9),16)+","+parseInt(t.substring(1,3),16)/255;else if(7===n)e+=parseInt(t.substring(1,3),16)+","+parseInt(t.substring(3,5),16)+","+parseInt(t.substr(5),16)+",1";else if(5===n)e+=parseInt(t.substring(1,3),16)+","+parseInt(t.substring(3,5),16)+",0,1";else if(4===n){var r=t.substring(1,2);r+=r;var o=t.substring(2,3);o+=o;var s=t.substring(3);s+=s,e+=parseInt(r,16)+","+parseInt(o,16)+","+parseInt(s,16)+",1"}else 3===n&&(e+=parseInt(t.substring(1,3),16)+",0,0,1");e+=")"}else t.substr(0,4)===T._RGB?(e=T._RGBA,e+=t.substring(4,t.length-1)+",1)"):e=t;return e},T._setChannel=function(t,e,i){if(void 0===t||void 0===i||t<T._RED||t>T._ALPHA)return e;var n,r=T.getColorFromName(e);r&&(e=r);var o,s="#"===e.charAt(0);if(s)(n=[]).push(parseInt(e.substr(1,2),16)),n.push(parseInt(e.substr(3,2),16)),n.push(parseInt(e.substr(5,2),16)),t===T._ALPHA&&(n.push(i),s=!1,o=!0);else{o=e.substr(0,5)===T._RGBA;var a=e.indexOf("("),h=e.indexOf(")");n=e.substring(a+1,h).split(","),o||t!==T._ALPHA||(n.push(i),o=!0)}return n[t]=i,s?T.makePound(n[0],n[1],n[2]):o?T.makeRGBA(n[0],n[1],n[2],n[3]):T.makeRGB(n[0],n[1],n[2])};["Red","Green","Blue","Alpha"].forEach(function(t){T["get"+t]=T._getChannel.bind(null,T["_"+t.toUpperCase()]),T["set"+t]=T._setChannel.bind(null,T["_"+t.toUpperCase()])}),T.rgb2hsl=function(t,e,i){t/=255,e/=255,i/=255;var n,r,o=Math.max(t,e,i),s=Math.min(t,e,i),a=o+s,h=a/2;if(o==s)n=0,r=0;else{var l=o-s;r=h>.5?l/(2-a):l/a,n=o==t?(e-i)/l+(e<i?6:0):o==e?(i-t)/l+2:o==i?(t-e)/l+4:0,n/=6}return{h:360*n,s:r,l:h}},T.hsl2rgb=function(t,e,i){var n,r,o;if(t/=360,0==e)n=r=o=i;else{var s=i<.5?i*(1+e):i+e-i*e,a=2*i-s;n=T._hue2rgb(a,s,t+1/3),r=T._hue2rgb(a,s,t),o=T._hue2rgb(a,s,t-1/3)}return{r:255*n,g:255*r,b:255*o}},T._hue2rgb=function(t,e,i){return i<0?i+=1:i>1&&(i-=1),i<1/6?t+6*(e-t)*i:i<.5?e:i<2/3?t+(e-t)*(2/3-i)*6:t},T.adjustHSL=function(t,e,i,n){T._hslCache||(T._hslCache=new v(100));var r=t+":"+e+":"+i+":"+n,o=T._hslCache.get(r);if(null!=o)return o;var s=T.getRed(t),a=T.getGreen(t),h=T.getBlue(t),l=T.getAlpha(t),u=T.rgb2hsl(s,a,h),c=Math.min(Math.max(0,u.h+e),360),_=Math.min(Math.max(0,u.s+i),1),p=Math.min(Math.max(0,u.l+n),1),d=T.hsl2rgb(c,_,p);return o=1==l?T.makePound(d.r,d.g,d.b):T.makeRGBA(d.r,d.g,d.b,l),T._hslCache.put(r,o),o},T.interpolateColor=function(t,e,i){var n=T.getRed(t),r=T.getGreen(t),o=T.getBlue(t),s=T.getAlpha(t),a=T.getRed(e),h=T.getGreen(e),l=T.getBlue(e),u=T.getAlpha(e),c=Math.round(S.interpolateNumber(n,a,i)),_=Math.round(S.interpolateNumber(r,h,i)),p=Math.round(S.interpolateNumber(o,l,i)),d=S.interpolateNumber(s,u,i);return T.makeRGBA(c,_,p,d)},T.getLuminance=function(t){var e=function(t){var e=t/255;return e<.03928?e/12.92:Math.pow((e+.055)/1.055,2.4)},i=T.getRed(t),n=T.getGreen(t),r=T.getBlue(t);return.2126*e(i)+.7152*e(n)+.0722*e(r)},T.getContrastRatio=function(t,e){return T.getContrastRatioByLuminance(T.getLuminance(t),T.getLuminance(e))},T.getContrastRatioByLuminance=function(t,e){var i=t+.05,n=e+.05;return i>n?i/n:n/i},T.getContrastingTextColor=function(t){if(!T._CONTRASTING_TEXT_COLOR_CACHE[t]){var e=T.getLuminance(t),i=T.getContrastRatioByLuminance(e,1)>T.getContrastRatioByLuminance(e,0)?"#FFFFFF":"#000000";T._CONTRASTING_TEXT_COLOR_CACHE[t]=i}return T._CONTRASTING_TEXT_COLOR_CACHE[t]},T.fixColorForPlatform=function(t,e){if(!t)return null;"#"==t.charAt(0)&&t.length>8&&(t=T.getRGBA(t));var i={};return i.color=t,null!=e&&(i.alpha=e),i};const E={};i.createSubclass(E,i),E.lineLinear=function(t){return t.join("L")},E.lineCardinalClosed=function(t,e){return t.length<3?E.lineLinear(t):t[0]+E.lineHermite((t.push(t[0]),t),E.lineCardinalTangents([t[t.length-2]].concat(t,[t[1]]),e))},E.lineCardinal=function(t,e){return t.length<3?E.lineLinear(t):t[0]+E.lineHermite(t,E.lineCardinalTangents(t,e))},E.lineHermite=function(t,e){if(e.length<1||t.length!=e.length&&t.length!=e.length+2)return E.lineLinear(t);var i=t.length!=e.length,n="",r=t[0],o=t[1],s=e[0],a=s,h=1;if(i&&(n+="Q"+Math.round(o[0]-2*s[0]/3)+","+Math.round(o[1]-2*s[1]/3)+","+Math.round(o[0])+","+Math.round(o[1]),r=t[1],h=2),e.length>1){a=e[1],o=t[h],h++,n+="C"+Math.round(r[0]+s[0])+","+Math.round(r[1]+s[1])+","+Math.round(o[0]-a[0])+","+Math.round(o[1]-a[1])+","+Math.round(o[0])+","+Math.round(o[1]);for(var l=2;l<e.length;l++,h++)o=t[h],a=e[l],n+="S"+Math.round(o[0]-a[0])+","+Math.round(o[1]-a[1])+","+Math.round(o[0])+","+Math.round(o[1])}if(i){var u=t[h];n+="Q"+Math.round(o[0]+2*a[0]/3)+","+Math.round(o[1]+2*a[1]/3)+","+Math.round(u[0])+","+Math.round(u[1])}return n},E.lineCardinalTangents=function(t,e){for(var i,n=[],r=(1-e)/2,o=t[0],s=t[1],a=1,h=t.length;++a<h;)i=o,o=s,s=t[a],n.push([r*(s[0]-i[0]),r*(s[1]-i[1])]);return n},E.lineSlope=function(t,e){return(e[1]-t[1])/(e[0]-t[0])},E.lineFiniteDifferences=function(t){for(var e=0,i=t.length-1,n=[],r=t[0],o=t[1],s=n[0]=E.lineSlope(r,o);++e<i;)n[e]=(s+(s=E.lineSlope(r=o,o=t[e+1])))/2;return n[e]=s,n},E.lineMonotoneTangents=function(t,e){e&&(t=E._rotatePoints(t));for(var i,n,r,o,s=[],a=E.lineFiniteDifferences(t),h=-1,l=t.length-1;++h<l;)i=E.lineSlope(t[h],t[h+1]),Math.abs(i)<1e-6?a[h]=a[h+1]=0:(o=(n=a[h]/i)*n+(r=a[h+1]/i)*r)>9&&(o=3*i/Math.sqrt(o),a[h]=o*n,a[h+1]=o*r);for(h=-1;++h<=l;)o=(t[Math.min(l,h+1)][0]-t[Math.max(0,h-1)][0])/(6*(1+a[h]*a[h])),s.push([o||0,a[h]*o||0]);return e&&(s=E._rotatePoints(s)),s},E.lineMonotone=function(t,e){return t.length<3?E.lineLinear(t):t[0]+E.lineHermite(t,E.lineMonotoneTangents(t,e))},E._rotatePoints=function(t){for(var e=[],i=0;i<t.length;i++)e.push([t[i][1],t[i][0]]);return e};const m=function(t,e,i,n){this.x=null===t||isNaN(t)?0:t,this.y=null===e||isNaN(e)?0:e,this.w=null===i||isNaN(i)?0:i,this.h=null===n||isNaN(n)?0:n};i.createSubclass(m,i),m.create=function(t){return new m(t[0],t[1],t[2],t[3])},m.prototype.containsPoint=function(t,e){return t>=this.x&&t<=this.x+this.w&&e>=this.y&&e<=this.y+this.h},m.prototype.getCenter=function(){return new n(this.x+this.w/2,this.y+this.h/2)},m.prototype.getUnion=function(t){var e=new m;if(t&&0!==t.w&&0!==t.h)if(0!==this.w&&0!==this.h){var i=this.x+this.w,n=this.y+this.h,r=t.x+t.w,o=t.y+t.h,s=Math.min(this.x,t.x),a=Math.min(this.y,t.y);e.w=i<r?r-s:i-s,e.h=n>o?n-a:o-a,e.x=s,e.y=a}else e.x=t.x,e.y=t.y,e.w=t.w,e.h=t.h;else e.x=this.x,e.y=this.y,e.w=this.w,e.h=this.h;return e},m.prototype.getIntersection=function(t){var e=new m;if(!t||0===t.w||0===t.h)return null;if(0===this.w||0===this.h)return null;var i=this.x+this.w,n=this.y+this.h,r=t.x+t.w,o=t.y+t.h,s=Math.max(this.x,t.x),a=Math.max(this.y,t.y);return s>=i||s>=r||a>=n||a>=o?null:(e.w=i<r?i-s:r-s,e.h=n>o?o-a:n-a,e.x=s,e.y=a,e)},m.prototype.intersects=function(t){if(t&&0!==t.w&&0!==t.h&&0!==this.w&&0!==this.h){var e=this.x+this.w,i=this.y+this.h,n=t.x+t.w,r=t.y+t.h;return!(t.x>e||n<this.x||t.y>i||r<this.y)}return!1},m.prototype.clone=function(){return new m(this.x,this.y,this.w,this.h)},m.prototype.equals=function(t){return t instanceof m&&this.x==t.x&&this.y==t.y&&this.w==t.w&&this.h==t.h},m.prototype.toString=function(){return this.x+", "+this.y+", "+this.w+", "+this.h};const b={};i.createSubclass(b,i),b.SPLINE_TYPE_MONOTONE_VERTICAL="mv",b.SPLINE_TYPE_MONOTONE_HORIZONTAL="mh",b.SPLINE_TYPE_CARDINAL_CLOSED="cc",b.SPLINE_TYPE_CARDINAL="c",b.moveTo=function(t,e){return"M"+t+","+e},b.lineTo=function(t,e){return"L"+t+","+e},b.quadTo=function(t,e,i,n){return"Q"+t+","+e+","+i+","+n},b.horizontalLineTo=function(t){return"H"+t},b.verticalLineTo=function(t){return"V"+t},b.cubicTo=function(t,e,i,n,r,o){return"C"+t+","+e+","+i+","+n+","+r+","+o},b.arcTo=function(t,e,i,n,r,o){var s="A"+t+","+e+",0,";return i>Math.PI?s+="1,":s+="0,",s+=n+","+r+","+o},b.closePath=function(){return"Z"},b.roundedRectangle=function(t,e,i,n,r,o,s,a){return b._roundedRectangle(t,e,i,n,r,r,o,o,s,s,a,a)},b.rectangleWithBorderRadius=function(t,e,i,n,r,o,s){var a=s,h=s,l=s,u=s,c=s,_=s,p=s,d=s;if(r)if(-1!=r.indexOf("/")){var g=r.split("/"),f=g[0].trim().split(/\s+/),y=g[1].trim().split(/\s+/);1==f.length?a=l=c=p=f[0]:2==f.length?(a=c=f[0],l=p=f[1]):3==f.length?(a=f[0],l=p=f[1],c=f[2]):4==f.length&&(a=f[0],l=f[1],c=f[2],p=f[3]),1==y.length?h=u=_=d=y[0]:2==y.length?(h=_=y[0],u=d=y[1]):3==y.length?(h=y[0],u=d=y[1],_=y[2]):4==y.length&&(h=y[0],u=y[1],_=y[2],d=y[3])}else if("auto"!=r){var v=r.trim().split(/\s+/);1==v.length?a=l=c=p=h=u=_=d=v[0]:2==v.length?(a=c=h=_=v[0],l=p=u=d=v[1]):3==v.length?(a=h=v[0],l=p=u=d=v[1],c=_=v[2]):4==v.length&&(a=h=v[0],l=u=v[1],c=_=v[2],p=d=v[3])}return r&&"0"!=r?b._roundedRectangle(t,e,i,n,b._parseBorderRadiusItem(a,o),b._parseBorderRadiusItem(h,o),b._parseBorderRadiusItem(l,o),b._parseBorderRadiusItem(u,o),b._parseBorderRadiusItem(c,o),b._parseBorderRadiusItem(_,o),b._parseBorderRadiusItem(p,o),b._parseBorderRadiusItem(d,o)):b._rectangle(t,e,i,n)},b._parseBorderRadiusItem=function(t,e){var i=Math.min(parseFloat(t),e/2);return-1!=t.indexOf("%")&&(i=.01*Math.min(50,parseFloat(t))*e),i},b._roundedRectangle=function(t,e,i,n,r,o,s,a,h,l,u,c){return o=Math.min(o,.5*n),a=Math.min(a,.5*n),l=Math.min(l,.5*n),c=Math.min(c,.5*n),r=Math.min(r,.5*i),s=Math.min(s,.5*i),h=Math.min(h,.5*i),u=Math.min(u,.5*i),b.moveTo(t+r,e)+b.lineTo(t+i-s,e)+b.arcTo(s,a,Math.PI/2,1,t+i,e+a)+b.lineTo(t+i,e+n-l)+b.arcTo(h,l,Math.PI/2,1,t+i-h,e+n)+b.lineTo(t+u,e+n)+b.arcTo(u,c,Math.PI/2,1,t,e+n-c)+b.lineTo(t,e+o)+b.arcTo(r,o,Math.PI/2,1,t+r,e)+b.closePath()},b.polyline=function(t,e){if(t.length<2)return"";for(var i=e?b.lineTo(t[0],t[1]):b.moveTo(t[0],t[1]),n=2;n<t.length;n+=2)i+=b.lineTo(t[n],t[n+1]);return i},b.curveThroughPoints=function(t,e,i){if(0==t.length)return"";for(var n=[],r=0;r<t.length;r+=2)n.push([t[r],t[r+1]]);var o=e?"L":"M";return i==b.SPLINE_TYPE_MONOTONE_VERTICAL?o+E.lineMonotone(n,!1):i==b.SPLINE_TYPE_MONOTONE_HORIZONTAL?o+E.lineMonotone(n,!0):i==b.SPLINE_TYPE_CARDINAL_CLOSED?o+E.lineCardinalClosed(n,.7):o+E.lineCardinal(n,.7)},b.createPathArray=function(t){if(!t)return null;var e,i=(t=t.replace(/([0-9])([\-])/g,"$1 $2")).replace(/([mlqhvzcast])/gi,",$1,").split(/[ ,]/g),n=i.length;for(e=0;e<n;e++){var r=i[e];r?isNaN(r)||(i[e]=parseFloat(r)):(i.splice(e,1),e--,n--)}return i},b.getDimensions=function(t){if(!t||!t.length)return new m;var e,i,n,r,o,s,a,h,l,u,c,_,p=t.length,d=!0,g=Number.MAX_VALUE,f=-1*Number.MAX_VALUE,y=Number.MAX_VALUE,v=-1*Number.MAX_VALUE,S=[];for(u=0;u<p;u++){n=!1;var T=0;switch(c=0,t[u]){case"m":n=!0;case"M":do{r=t[u+1],o=t[u+2],d?d=!1:n&&(r+=e,o+=i),e=r,i=o,S[c++]=r,S[c++]=o,T++,u+=2}while(!isNaN(t[u+1]));break;case"c":n=!0;case"C":do{r=t[u+1],o=t[u+2],s=t[u+3],a=t[u+4],h=t[u+5],l=t[u+6],n&&(r+=e,o+=i,s+=e,a+=i,h+=e,l+=i),e=h,i=l,S[c++]=h,S[c++]=l,T++,u+=6}while(!isNaN(t[u+1]));break;case"q":n=!0;case"Q":do{r=t[u+1],o=t[u+2],s=t[u+3],a=t[u+4],n&&(r+=e,o+=i,s+=e,a+=i),e=s,i=a,S[c++]=s,S[c++]=a,T++,u+=4}while(!isNaN(t[u+1]));break;case"l":n=!0;case"L":do{r=t[u+1],o=t[u+2],n&&(r+=e,o+=i),e=r,i=o,S[c++]=r,S[c++]=o,T++,u+=2}while(!isNaN(t[u+1]));break;case"h":n=!0;case"H":do{r=t[u+1],n&&(r+=e),e=r,S[c++]=r,S[c++]=i,T++,u+=1}while(!isNaN(t[u+1]));break;case"v":n=!0;case"V":do{o=t[u+1],n&&(o+=i),i=o,S[c++]=e,S[c++]=o,T++,u+=1}while(!isNaN(t[u+1]));break;case"a":n=!0;case"A":do{var E=t[u+1],C=t[u+2],A=t[u+3],O=t[u+4],I=t[u+5],N=t[u+6],R=t[u+7];n&&(N+=e,R+=i);var D=b._getArcDims(e,i,E,C,A,O,I,N,R);S[c++]=D[0],S[c++]=D[1],S[c++]=D[2],S[c++]=D[3],T+=2,e=N,i=R,u+=7}while(!isNaN(t[u+1]))}for(c=0,_=0;_<T;_++)r=S[c++],o=S[c++],g=Math.min(g,r),f=Math.max(f,r),y=Math.min(y,o),v=Math.max(v,o)}return new m(g,y,Math.abs(f-g),Math.abs(v-y))},b.getPathString=function(t){for(var e="",i=t.length,n=0;n<i;n++)null!=t[n]&&(e+=(n>0?" ":"")+t[n]);return e},b.transformPath=function(t,e,i,n,r){if(t){for(var o,s="",a="",h=0;h<t.length;h++){"string"==typeof t[h]&&(o=(a=t[h])===a.toUpperCase(),s+=a+" ");for(var l=[];h<t.length-1&&"number"==typeof t[h+1];)h++,l.push(t[h]);if("A"===a.toUpperCase())for(var u=0;u<l.length;u+=7)s+=parseFloat(l[u])*n+" ",s+=parseFloat(l[u+1])*r+" ",s+=l[u+2]+" ",s+=l[u+3]+" ",s+=l[u+4]+" ",s+=parseFloat(l[u+5])*n+(o?e:0)+" ",s+=parseFloat(l[u+6])*r+(o?i:0)+" ";else{var c=[],_=[];"H"===a.toUpperCase()?(c.push(n),_.push(o?e:0)):"V"===a.toUpperCase()?(c.push(r),_.push(o?i:0)):(c.push(n),c.push(r),_.push(o?e:0),_.push(o?i:0));for(u=0;u<l.length;u++){var p=c[u%c.length],d=_[u%_.length];s+=parseFloat(l[u])*p+d+" "}}}return s}},b._fitsInScale=function(t,e,i){return Math.abs(t)>i||Math.abs(e)>i},b.simplifyPath=function(t,e){for(var i,n,r="",o="",s=0,a=0,h=0,l=0,u=0,c=0;c<t.length;c++)if(isNaN(t[c]))"Z"!=(i=t[c])&&"z"!=i||(n=i,o+=i,u>0&&(r+=o,h=0,l=0),o="",u=0,s=0,a=0);else switch(i){case"M":h=0,l=0;case"m":o=o+i+(h+=t[c])+" "+(l+=t[c+1]),n=i,c++;break;case"l":s+=t[c],a+=t[c+1],b._fitsInScale(s,a,e)&&(n!=i?(n=i,o+=i):o+=" ",o=o+s+" "+a,s=0,a=0,u++),c++;break;case"h":case"v":"h"==i?s+=t[c]:a+=t[c],b._fitsInScale(s,a,e)&&(0!=s&&0!=a?("l"!=n?(n="l",o+="l"):o+=" ",o=o+s+" "+a):(n=i,o=o+i+("h"==i?s:a)),s=0,a=0,u++)}return r},b._rectangle=function(t,e,i,n){return b.moveTo(t,e)+b.horizontalLineTo(t+i)+b.verticalLineTo(e+n)+b.horizontalLineTo(t)+b.closePath()},b._getArcDims=function(t,e,i,r,o,s,a,h,l){let u=b._convertArc(t,e,i,r,o,s,a,h,l);i=u[2],r=u[3];const c=new n(t,e),_=new n(h,l),p=new n(u[0],u[1]),d=[new n(p.x+i,p.y),new n(p.x,p.y+r),new n(p.x-i,p.y),new n(p.x,p.y-r)];let g=[c,_];const f=b._getClockwiseAngle(c,_),y=0===a?[f,f+Math.PI]:[f+Math.PI,f+2*Math.PI];d.forEach(t=>{var e=b._getClockwiseAngle(c,t);(e>=y[0]&&e<=y[1]||e+2*Math.PI>=y[0]&&e+2*Math.PI<=y[1])&&g.push(t)});const v=g.map(t=>t.x),S=g.map(t=>t.y);return[Math.min(...v),Math.min(...S),Math.max(...v),Math.max(...S)]},b._getClockwiseAngle=function(t,e){var i=Math.atan2(e.y-t.y,e.x-t.x);return i=i<0?i+2*Math.PI:i},b._convertArc=function(t,e,i,n,r,o,s,a,h){var l=(t-a)/2,u=(e-h)/2,c=(r=Math.PI*(r%360)/180,Math.cos(r)),_=Math.sin(r),p=c*l+_*u,d=-_*l+c*u,g=(i=Math.abs(i))*i,f=(n=Math.abs(n))*n,y=p*p,v=d*d,S=y/g+v/f;S>1&&(g=(i=Math.sqrt(S)*i)*i,f=(n=Math.sqrt(S)*n)*n);var T=o==s?-1:1,E=(g*f-g*v-f*y)/(g*v+f*y);E=E<0?0:E;var m,b,C=T*Math.sqrt(E),A=C*(i*d/n),O=C*(-n*p/i),I=(t+a)/2+(c*A-_*O),N=(e+h)/2+(_*A+c*O),R=(p-A)/i,D=(d-O)/n,x=(-p-A)/i,M=(-d-O)/n;b=Math.sqrt(R*R+D*D),m=R;var w=(T=D<0?-1:1)*Math.acos(m/b)*180/Math.PI;b=Math.sqrt((R*R+D*D)*(x*x+M*M)),m=R*x+D*M;var L=(T=R*M-D*x<0?-1:1)*Math.acos(m/b)*180/Math.PI;return!s&&L>0?L-=360:s&&L<0&&(L+=360),[I,N,i,n,w%=360,L%=360,r]};const C=function(){};i.createSubclass(C,i),C._SM_WIDTH=8,C._SM_HEIGHT=8,C._LG_WIDTH=16,C._LG_HEIGHT=16,C.createElem=function(t,e){var i=document.createElementNS(u.SVG_NS,"pattern");u.setAttrNullNS(i,"id",e);var n,r,o=t.getPattern();C.IsSmallPattern(o)?(n=C._SM_WIDTH,r=C._SM_HEIGHT):(n=C._LG_WIDTH,r=C._LG_HEIGHT),u.setAttrNullNS(i,"x",0),u.setAttrNullNS(i,"y",0),u.setAttrNullNS(i,"width",n),u.setAttrNullNS(i,"height",r),u.setAttrNullNS(i,"patternUnits","userSpaceOnUse");var s=t.getMatrix();if(s){var a="matrix("+s.getA()+","+s.getC()+","+s.getB()+","+s.getD()+","+s.getTx()+","+s.getTy()+")";u.setAttrNullNS(i,"patternTransform",a)}return C.CreatePatternElems(t,i),i},C.IsSmallPattern=function(t){return"s"===t.charAt(0)},C.CreatePatternElems=function(t,e){var i,n,r,o,s,a,h;var l=t.getPattern(),c=t.getColor(),_=T.getRGB(c),p=T.getAlpha(c),d=t.getBackgroundColor(),g=T.getRGB(d),f=T.getAlpha(d);C.IsSmallPattern(l)?(i=C._SM_WIDTH,n=C._SM_HEIGHT,r=C._SM_WIDTH,o=C._SM_HEIGHT):(i=C._LG_WIDTH,n=C._LG_HEIGHT,r=C._LG_WIDTH,o=C._LG_HEIGHT),g&&f>0&&(h=document.createElementNS(u.SVG_NS,"rect"),u.setAttrNullNS(h,"stroke",g),u.setAttrNullNS(h,"stroke-opacity",f),u.setAttrNullNS(h,"stroke-width",1),u.setAttrNullNS(h,"fill",g),u.setAttrNullNS(h,"fill-opacity",f),u.setAttrNullNS(h,"x",0),u.setAttrNullNS(h,"y",0),u.setAttrNullNS(h,"width",i),u.setAttrNullNS(h,"height",n),u.appendChildElem(e,h)),l===y.SM_DIAG_UP_LT||l===y.LG_DIAG_UP_LT?(h=document.createElementNS(u.SVG_NS,"path"),u.setAttrNullNS(h,"stroke",_),u.setAttrNullNS(h,"stroke-opacity",p),u.setAttrNullNS(h,"stroke-width",1),u.setAttrNullNS(h,"stroke-linecap","square"),u.setAttrNullNS(h,"d",b.moveTo(0,-o/2)+b.lineTo(3*r/2,o)+b.moveTo(-r/2,0)+b.lineTo(r/2,o)),u.appendChildElem(e,h)):l===y.SM_DIAG_UP_RT||l===y.LG_DIAG_UP_RT?(h=document.createElementNS(u.SVG_NS,"path"),u.setAttrNullNS(h,"stroke",_),u.setAttrNullNS(h,"stroke-opacity",p),u.setAttrNullNS(h,"stroke-width",1),u.setAttrNullNS(h,"stroke-linecap","square"),u.setAttrNullNS(h,"d",b.moveTo(-r/2,o)+b.lineTo(r,-o/2)+b.moveTo(0,3*o/2)+b.lineTo(3*r/2,0)),u.appendChildElem(e,h)):l===y.SM_CROSSHATCH||l===y.LG_CROSSHATCH?(h=document.createElementNS(u.SVG_NS,"path"),u.setAttrNullNS(h,"stroke",_),u.setAttrNullNS(h,"stroke-opacity",p),u.setAttrNullNS(h,"stroke-width",1),u.setAttrNullNS(h,"d","M0,0L"+i+","+n+"M"+i+",0L0,"+n),u.appendChildElem(e,h)):l===y.SM_CHECK||l===y.LG_CHECK?(s=r/2,a=o/2,h=document.createElementNS(u.SVG_NS,"path"),u.setAttrNullNS(h,"stroke",_),u.setAttrNullNS(h,"stroke-opacity",p),u.setAttrNullNS(h,"stroke-width",1),u.setAttrNullNS(h,"fill",_),u.setAttrNullNS(h,"fill-opacity",p),u.setAttrNullNS(h,"d","M"+s+",0L"+r+",0L"+r+","+a+"L"+s+","+a+"ZM0,"+a+"L"+s+","+a+"L"+s+","+o+"L0,"+o+"Z"),u.appendChildElem(e,h)):l===y.SM_TRIANGLE_CHECK||l===y.LG_TRIANGLE_CHECK?(h=document.createElementNS(u.SVG_NS,"polygon"),u.setAttrNullNS(h,"stroke",_),u.setAttrNullNS(h,"stroke-opacity",p),u.setAttrNullNS(h,"stroke-width",1),u.setAttrNullNS(h,"fill",_),u.setAttrNullNS(h,"fill-opacity",p),u.setAttrNullNS(h,"points","0,"+n+" "+i+",0 "+i+","+n),u.appendChildElem(e,h)):l!==y.SM_DIAMOND_CHECK&&l!==y.LG_DIAMOND_CHECK||(s=r/2,a=o/2,h=document.createElementNS(u.SVG_NS,"polygon"),u.setAttrNullNS(h,"stroke",_),u.setAttrNullNS(h,"stroke-opacity",p),u.setAttrNullNS(h,"stroke-width",1),u.setAttrNullNS(h,"fill",_),u.setAttrNullNS(h,"fill-opacity",p),u.setAttrNullNS(h,"points","0,"+a+" "+s+",0 "+i+","+s+" "+s+","+n),u.appendChildElem(e,h))};const A=function(){};i.createSubclass(A,i),A._uniqueSeed=0,A.addClipPath=function(t,e){var i=t.getId();if(!i)return!1;var n=e.getDefs();if(!n)return!1;for(var r=n.childNodes,o=r.length,s=0;s<o;s++){if(r[s].id===i)return!0}var a=A.createElement("clipPath",i);e.appendDefs(a);var h=t.getRegions();for(s=0;s<h.length;s++){var l=h[s];if(l){var c=null;l.type===p.RECT?(c=A.createElement("rect"),u.setAttrNullNS(c,"x",l.x),u.setAttrNullNS(c,"y",l.y),u.setAttrNullNS(c,"width",l.w),u.setAttrNullNS(c,"height",l.h),l.rx&&u.setAttrNullNS(c,"rx",l.rx),l.ry&&u.setAttrNullNS(c,"ry",l.ry)):l.type===p.PATH?(c=A.createElement("path"),u.setAttrNullNS(c,"d",l.d)):l.type===p.POLYGON?(c=A.createElement("polygon"),u.setAttrNullNS(c,"points",l.points)):l.type===p.ELLIPSE?(c=A.createElement("ellipse"),u.setAttrNullNS(c,"cx",l.cx),u.setAttrNullNS(c,"cy",l.cy),u.setAttrNullNS(c,"rx",l.rx),u.setAttrNullNS(c,"ry",l.ry)):l.type===p.CIRCLE&&(c=A.createElement("circle"),u.setAttrNullNS(c,"cx",l.cx),u.setAttrNullNS(c,"cy",l.cy),u.setAttrNullNS(c,"r",l.r)),c&&u.appendChildElem(a,c)}}return!0},A.addMask=function(t,e){var i=t.getId();if(!i)return!1;var n=e.getDefs();if(!n)return!1;for(var r=n.childNodes,o=r.length,s=0;s<o;s++){if(r[s].id===i)return!0}var a=A.createElement("mask",i);e.appendDefs(a);var h=t.getGradient(),l=A.addSpecialFill(h,e),c=t.getBounds(),_=A.createElement("rect");return u.setAttrNullNS(_,"x",c.x),u.setAttrNullNS(_,"y",c.y),u.setAttrNullNS(_,"width",c.w),u.setAttrNullNS(_,"height",c.h),u.setAttrNullNS(_,"fill",u.getUrlById(l)),u.appendChildElem(a,_),!0},A.addSpecialFill=function(t,e){if(!t._defPresent){var i=t._defElem;i||(t instanceof g?(t._id=A.getUniqueId("Gr"),i=f.createElem(t,t._id)):t instanceof y&&(t._id=A.getUniqueId("pat"),i=C.createElem(t,t._id))),t._defElem=i,e.appendDefs(i),t._defPresent=!0}return t._id},A.createElement=function(t,e){var i=document.createElementNS(u.SVG_NS,t);return e&&u.setAttrNullNS(i,"id",e),i},A.getUniqueId=function(t){return(t||"$")+A._uniqueSeed++},A.convertPointsArray=function(t){for(var e=t.length,i="",n=0;n<e;n++)n>0&&(i+=" "),i+=t[n];return i};const O={ARIA_LABEL_STATE_DELIMITER:", ",ARIA_LABEL_DESC_DELIMITER:". ",processAriaLabel:function(t){var e=t;return e&&(e=(e=(e=(e=(e=(e=(e=(e=(e=(e=e.replace(/(<|&#60;)/g,"&lt;")).replace(/(>|&#62;)/g,"&gt;")).replace(/&lt;b&gt;/g,"")).replace(/&lt;\/b&gt;/g,"")).replace(/&lt;i&gt;/g,"")).replace(/&lt;\/i&gt;/g,"")).replace(/\n/g,"; ")).replace(/&#92;n/g,"; ")).replace(/&lt;br&gt;/g,"; ")).replace(/&lt;br\/&gt;/g,"; ")),e}},I=function(){this.Init()};i.createSubclass(I,i),I.prototype.Init=function(){this._regionPctRect=new m(-10,-10,120,120),this._counter=0},I.prototype.getRegionPctRect=function(){return this._regionPctRect},I.prototype.createResultId=function(t){return t||(t="filtRes"),t+this._counter++};const N=function(t,e,i,n){this.__type="shadow",this._dx=t,this._dy=e,this._stdDeviation=i,this._floodColor=n,this._Id="ds"+N._uniqueId++};i.createSubclass(N,i),N._uniqueId=1;const R=function(){};i.createSubclass(R,i),R.RADS_PER_DEGREE=Math.PI/180,R.createFilterPrimitives=function(t,e,i,n){var o=e._dx,s=e._dy,a=e._stdDeviation,h=e._floodColor;var l=i.getDimensions(i.getParent());if(l){var c=2*a,_=c,p=c,d=c,g=c;(_-=o)<0&&(_=0),(d-=s)<0&&(d=0),(p+=o)<0&&(p=0),(g+=s)<0&&(g=0);var f=_/l.w*100,y=p/l.w*100,v=d/l.h*100,S=g/l.h*100;n.getRegionPctRect().x>-f&&(n.getRegionPctRect().x=-f),n.getRegionPctRect().y>-v&&(n.getRegionPctRect().y=-v),n.getRegionPctRect().w<100+f+y&&(n.getRegionPctRect().w=100+f+y),n.getRegionPctRect().h<100+v+S&&(n.getRegionPctRect().h=100+v+S)}if(i.requiresStrokeAdjustmentForShadow()){var T=i.getStroke().getWidth();T>1&&(n.getRegionPctRect().h=n.getRegionPctRect().h+T,n.getRegionPctRect().y=n.getRegionPctRect().y-T)}if("ie"!==r.browser&&"edge"!==r.browser){var E=A.createElement("feDropShadow");u.setAttrNullNS(E,"dx",o),u.setAttrNullNS(E,"dy",s),u.setAttrNullNS(E,"stdDeviation",a),u.setAttrNullNS(E,"flood-color",h),u.appendChildElem(t,E)}else{var m=A.createElement("feGaussianBlur");u.setAttrNullNS(m,"stdDeviation",a);var b=A.createElement("feOffset"),C=n.createResultId("offset");u.setAttrNullNS(b,"dx",o),u.setAttrNullNS(b,"dy",s),u.setAttrNullNS(b,"result",C);var O=A.createElement("feFlood"),I=h.split(/[\(,\)]/);6===I.length?(u.setAttrNullNS(O,"flood-color",`${I[0].substr(0,3)}(${I[1]},${I[2]},${I[3]})`),u.setAttrNullNS(O,"flood-opacity",I[4])):u.setAttrNullNS(O,"flood-color",h);var N=A.createElement("feComposite");u.setAttrNullNS(N,"in2",C),u.setAttrNullNS(N,"operator","in");var R=A.createElement("feMerge"),D=A.createElement("feMergeNode"),x=A.createElement("feMergeNode");u.setAttrNullNS(x,"in","SourceGraphic"),u.appendChildElem(R,D),u.appendChildElem(R,x),u.appendChildElem(t,m),u.appendChildElem(t,b),u.appendChildElem(t,O),u.appendChildElem(t,N),u.appendChildElem(t,R)}};const D=function(){};i.createSubclass(D,i),D._counter=0,D.createFilter=function(t,e){for(var i=A.createElement("filter",D.CreateFilterId()),n=new I,r=0;r<t.length;r++){var o=t[r];o&&D.CreateFilterPrimitives(i,o,e,n)}var s=!1;if(e){var a=e.getElem().getBBox();if(a){var h=a.width,l=a.height;if(0==l||0==h){var c;e.getStroke&&(c=e.getStroke());var _=10;c&&(_=c.getWidth());var p=a.x,d=a.y;0==l&&(l=2*_,d-=_),0==h&&(h=2*_,p-=_),u.setAttrNullNS(i,"x",p),u.setAttrNullNS(i,"y",d),u.setAttrNullNS(i,"width",h),u.setAttrNullNS(i,"height",l),u.setAttrNullNS(i,"filterUnits","userSpaceOnUse"),s=!0}}}return s||(-10!=n.getRegionPctRect().x&&"Infinity"!=n.getRegionPctRect().x&&"-Infinity"!=n.getRegionPctRect().x&&u.setAttrNullNS(i,"x",n.getRegionPctRect().x+"%"),-10!=n.getRegionPctRect().y&&"Infinity"!=n.getRegionPctRect().y&&"-Infinity"!=n.getRegionPctRect().y&&u.setAttrNullNS(i,"y",n.getRegionPctRect().y+"%"),120!=n.getRegionPctRect().w&&"Infinity"!=n.getRegionPctRect().w&&"-Infinity"!=n.getRegionPctRect().w&&u.setAttrNullNS(i,"width",n.getRegionPctRect().w+"%"),120!=n.getRegionPctRect().h&&"Infinity"!=n.getRegionPctRect().h&&"-Infinity"!=n.getRegionPctRect().h&&u.setAttrNullNS(i,"height",n.getRegionPctRect().h+"%")),i},D.CreateFilterPrimitives=function(t,e,i,n){return e instanceof N&&R.createFilterPrimitives(t,e,i,n),null},D.CreateFilterId=function(){return"filt"+D._counter++};const x={addDrawEffect:function(t){this._drawEffects||(this._drawEffects=[]),this._drawEffects.push(t),this._applyDrawEffects()},removeAllDrawEffects:function(){this._drawEffects&&(this._drawEffects=null,this._applyDrawEffects(this._drawEffects))},_applyDrawEffects:function(){var t=this._drawEffects;if(this._filter&&(u.removeAttrNullNS(this.getOuterElem(),"filter"),this.getCtx().removeDefs(this._filter),this._filter=null),!this._outerElem&&this._matrix&&this._createOuterGroupElem(),t&&t.length>0&&(this._filter=D.createFilter(t,this),this._filter)){this.getCtx().appendDefs(this._filter);var e=u.getAttrNullNS(this._filter,"id");u.setAttrNullNS(this.getOuterElem(),"filter",u.getUrlById(e))}},requiresStrokeAdjustmentForShadow:function(){return!1}},M=function(){};i.createSubclass(M,i),M.prototype.Init=function(t){this.type=t.type,this.target=M.FindDisplayable(t.target),this._isPropagationStopped=!1,this._event=t},M.prototype.getNativeEvent=function(){return this._event},M.prototype.preventDefault=function(){this._event.cancelable&&this._event.preventDefault()},M.prototype.stopPropagation=function(){this._event.stopPropagation&&this._event.stopPropagation(),this._event.cancelBubble=!0,this._event.cancel=!0,this._event.returnValue=!1,this._isPropagationStopped=!0},M.prototype.isPropagationStopped=function(){return this._isPropagationStopped},M.FindDisplayable=function(t){for(;t;){if(t._obj)return t._obj;t=t.parentNode}return null};const w=function(t){this.Init(t)};i.createSubclass(w,i),w.prototype.Init=function(t){this.clientX=t.clientX,this.clientY=t.clientY,this.screenX=t.screenX,this.screenY=t.screenY,this.pageX=t.pageX,this.pageY=t.pageY,this.target=t.target,this.identifier=null==t.identifier||isNaN(t.identifier)?1:t.identifier};const L=function(t){this.Init(t)};i.createSubclass(L,M),L.TOUCHSTART="touchstart",L.TOUCHMOVE="touchmove",L.TOUCHEND="touchend",L.TOUCHCANCEL="touchcancel",L.prototype.Init=function(t){L.superclass.Init.call(this,t),t.type==L.TOUCHCANCEL&&(this.type=L.TOUCHEND),this.touches=L.createTouchArray(t.touches),this.targetTouches=L.createTouchArray(t.targetTouches),this.changedTouches=L.createTouchArray(t.changedTouches),this._touchManager=null},L.prototype.blockTouchHold=function(){this.getNativeEvent()._touchHoldBlocked=!0},L.prototype.isInitialTouch=function(){return this.touches.length-this.changedTouches.length==0},L.prototype.isTouchHoldBlocked=function(){return!!this.getNativeEvent()._touchHoldBlocked},L.createTouchArray=function(t){for(var e=new Array,i=0;i<t.length;i++){var n=t[i],r=new w(n);e.push(r)}return e},L.prototype.stopPropagation=function(){L.superclass.stopPropagation.call(this),this._touchManager&&this._touchManager.postEventBubble(this)},L.prototype.setTouchManager=function(t){this._touchManager=t};const P=function(t){this.Init(t)};i.createSubclass(P,M),P.KEYDOWN="keydown",P.KEYUP="keyup",P.KEYPRESS="keypress",P.TAB=9,P.ENTER=13,P.SHIFT=16,P.CONTROL=17,P.ESCAPE=27,P.SPACE=32,P.PAGE_UP=33,P.PAGE_DOWN=34,P.UP_ARROW=38,P.DOWN_ARROW=40,P.LEFT_ARROW=37,P.RIGHT_ARROW=39,P.F2=113,P.OPEN_BRACKET=219,P.CLOSE_BRACKET=221,P.ZERO=48,P.NUMPAD_ZERO=96,P.NUMPAD_PLUS=107,P.NUMPAD_MINUS=109,P.WEBKIT_PLUS=187,P.WEBKIT_MINUS=189,P.GECKO_PLUS=61,P.GECKO_MINUS=173,P.M=77,P.OPEN_ANGLED_BRACKET=188,P.CLOSE_ANGLED_BRACKET=190,P.prototype.Init=function(t){P.superclass.Init.call(this,t),this.bubbles=t.bubbles,this.cancelable=t.cancelable,this.view=t.view,this.charCode=t.charCode,this.keyCode=t.keyCode,this.location=t.location,this.ctrlKey=t.ctrlKey||t.metaKey,this.altKey=t.altKey,this.shiftKey=t.shiftKey,this.repeat=t.repeat,this.locale=t.locale},P.isPlus=function(t){var e=t.keyCode;return e==P.NUMPAD_PLUS||("firefox"===r.browser?!(e!=P.GECKO_PLUS||!t.shiftKey):!(e!=P.WEBKIT_PLUS||!t.shiftKey))},P.isEquals=function(t){var e=t.keyCode;return"firefox"===r.browser?e==P.GECKO_PLUS&&!t.shiftKey:e==P.WEBKIT_PLUS&&!t.shiftKey},P.isMinus=function(t){var e=t.keyCode;return e==P.NUMPAD_MINUS||("firefox"===r.browser?e==P.GECKO_MINUS&&!t.shiftKey:e==P.WEBKIT_MINUS&&!t.shiftKey)},P.isUnderscore=function(t){var e=t.keyCode;return"firefox"===r.browser?!(e!=P.GECKO_MINUS||!t.shiftKey):!(e!=P.WEBKIT_MINUS||!t.shiftKey)};const H=function(t){this.Init(t)};i.createSubclass(H,M),H.FOCUS="focus",H.FOCUSIN="focusin",H.FOCUSOUT="focusout",H.BLUR="blur",H.prototype.Init=function(t){H.superclass.Init.call(this,t),this.bubbles=t.bubbles,this.cancelable=t.cancelable,this.view=t.view,null!=t.relatedTarget&&(this.relatedTarget=M.FindDisplayable(t.relatedTarget))};const F=function(t){this.Init(t)};i.createSubclass(F,M),F.CLICK="click",F.DBLCLICK="dblclick",F.MOUSEOVER="mouseover",F.MOUSEOUT="mouseout",F.MOUSEDOWN="mousedown",F.MOUSEUP="mouseup",F.MOUSEMOVE="mousemove",F.MOUSEWHEEL="wheel",F.RIGHT_CLICK_BUTTON=2,F.prototype.Init=function(t){F.superclass.Init.call(this,t),null!=t.relatedTarget&&(this.relatedTarget=M.FindDisplayable(t.relatedTarget)),this.button=t.button,this.ctrlKey=t.ctrlKey||t.metaKey,this.shiftKey=t.shiftKey,this.pageX=t.pageX,this.pageY=t.pageY,this._isEventModifiedForIE=!1,null!=t.wheelDeltaY?this.wheelDelta=t.wheelDeltaY/40:null!=t.deltaY?(this.deltaMode=t.deltaMode,this.deltaY=t.deltaY,t.deltaMode==t.DOM_DELTA_LINE?this.wheelDelta=-t.deltaY:t.deltaMode==t.DOM_DELTA_PIXEL&&(this.wheelDelta=-t.deltaY/15)):null!=t.wheelDelta?this.wheelDelta=t.wheelDelta/40:this.wheelDelta=t.detail},F.prototype.modifyEventForIE=function(t,e){this._isEventModifiedForIE||(this.type=t,this.relatedTarget=this.target,this.target=M.FindDisplayable(e),this._isEventModifiedForIE=!0)};const k=new Object;i.createSubclass(k,i),k.newEvent=function(t,e){var i=t.type;return i==L.TOUCHSTART||i==L.TOUCHMOVE||i==L.TOUCHEND||i==L.TOUCHCANCEL?new L(t):i==P.KEYDOWN||i==P.KEYUP||i==P.KEYPRESS?new P(t):(e._nativeEvent!=t&&(e._nativeEvent=t,e._logicalEvent=i==H.FOCUS||i==H.FOCUSIN||i==H.FOCUSOUT||i==H.BLUR?new H(t):new F(t)),e._logicalEvent)};const G=function(){};i.createSubclass(G,i),G.getListener=function(t){return t?G._captureListener:G._bubbleListener},G._bubbleListener=function(t){G._commonListener.call(this,t,!1)},G._captureListener=function(t){G._commonListener.call(this,t,!0)},G._commonListener=function(t,e){var i;if(this._currentObj){if("focus"==t.type)return void(this._focusEvent=t);var n=this._currentObj.getCtx();this._focusEvent&&(n.resetCurrentKeyboardFocus(t),i=k.newEvent(this._focusEvent,n),this._currentObj.FireListener(i,e),this._focusEvent=null),i=k.newEvent(t,n),this._currentObj.FireListener(i,e)}else if(Array.isArray(this._keyboardListeners))for(var r,o=this._keyboardListeners.length,s=0;s<o;s++)r=this._keyboardListeners[s],i=k.newEvent(t,r.getCtx()),r.FireListener(i,e)};const B={addEvtListener:function(t,e,i,n){var r=u.getUseCaptureFromOptions(i),o=this._getListeners(t,r,!0);o.push(e),o.push(n),this._addListener(t,i)},removeEvtListener:function(t,e,i,n){var r=u.getUseCaptureFromOptions(i),o=this._getListeners(t,r,!1);if(o)for(var s=0;s<o.length;s+=2)if(o[s]===e&&o[s+1]===n){o.splice(s,2);break}o&&o.length<=0&&this._removeListener(t,i)},AddElemListener:function(t,e,i){u.addDomEventListener(this.getElem(),t,e,i),t==L.TOUCHEND&&u.addDomEventListener(this.getElem(),L.TOUCHCANCEL,e,i)},FireListener:function(t,e){var i=this._getListeners(t.type,e,!1);if(i)for(var n=0;n<i.length;n+=2){var r=i[n+1];i[n]&&i[n].call(r,t)}},fireKeyboardListener:function(t,e){this.FireListener(t,e)},_getListeners:function(t,e,i){if(!this._listenerObj){if(!i)return null;this._listenerObj={}}var n=t+"_"+!!e,r=this._listenerObj[n];return!r&&i&&(r=[],this._listenerObj[n]=r),r},_addListener:function(t,e){var i=u.getUseCaptureFromOptions(e),n=this._getListener(i);if(t==P.KEYUP||t==P.KEYDOWN||t==P.KEYPRESS||t==H.FOCUS||t==H.FOCUSIN||t==H.FOCUSOUT||t==H.BLUR){var r=this.getCtx().getStage().getSVGRoot().parentNode;if(!r)return;r._keyboardListeners||(r._keyboardListeners=[]),-1==r._keyboardListeners.indexOf(this)&&r._keyboardListeners.push(this),n=G.getListener(i),u.addDomEventListener(r,t,n,e)}else this.AddElemListener(t,n,e)},_removeListener:function(t,e){var i=u.getUseCaptureFromOptions(e),n=this._getListener(i);if(t==P.KEYUP||t==P.KEYDOWN||t==P.KEYPRESS||t==H.FOCUS||t==H.FOCUSIN||t==H.FOCUSOUT||t==H.BLUR){var r=this.getCtx().getStage().getSVGRoot().parentNode;u.removeDomEventListener(r,t,n,e);var o=r._keyboardListeners.indexOf(this);-1!==o&&r._keyboardListeners.splice(o,1)}else u.removeDomEventListener(this.getElem(),t,n,e)},_getListener:function(t){var e=this;return t?(this._captureClosure||(this._captureClosure=function(t){e._captureListener(t)}),this._captureClosure):(this._bubbleClosure||(this._bubbleClosure=function(t){e._bubbleListener(t)}),this._bubbleClosure)},_shouldIgnoreEvent:function(t,e){var i=e?this._captureHoverItem:this._bubbleHoverItem;if(i){if(t.type===F.MOUSEOVER)return i===t.target;if(t.type===F.MOUSEOUT)return i===t.relatedTarget}return!1},_fireMissedEvent:function(t,e){if(t.type===F.MOUSEOVER||F.MOUSEOUT){var i=e?this._captureHoverItem:this._bubbleHoverItem;if(i&&i!==t.target){var n=k.newEvent(t,this.getCtx());n.modifyEventForIE(F.MOUSEOUT,i),this.FireListener(n,e)}}},_bubbleListener:function(t){if("ie"===r.browser||"edge"===r.browser){if(this._shouldIgnoreEvent(t,!1))return;this._fireMissedEvent(t,!1),t.type==F.MOUSEOVER?this._bubbleHoverItem=t.target:t.type==F.MOUSEOUT&&(this._bubbleHoverItem=null)}var e=k.newEvent(t,this.getCtx());this.FireListener(e,!1)},_captureListener:function(t){if("ie"===r.browser||"edge"===r.browser){if(this._shouldIgnoreEvent(t,!0))return;this._fireMissedEvent(t,!0),t.type==F.MOUSEOVER?this._captureHoverItem=t.target:t.type==F.MOUSEOUT&&(this._captureHoverItem=null)}var e=k.newEvent(t,this.getCtx());this.FireListener(e,!0)}},U=function(t){this.Init(t)};i.createSubclass(U,i),U.LINEAR=0,U.RADIAL=1,U.prototype.Init=function(t){this._type=t},U.prototype.getAlphas=function(){return this._arAlphas},U.prototype.setAlphas=function(t){this._arAlphas=t},U.prototype.getColors=function(){return this._arColors},U.prototype.setColors=function(t){this._arColors=t},U.prototype.getRatios=function(){return this._arRatios},U.prototype.setRatios=function(t){this._arRatios=t};const Y=function(){this.Init()};i.createSubclass(Y,U),Y.LEFT=0,Y.BOTTOM_LEFT=45,Y.BOTTOM=90,Y.BOTTOM_RIGHT=135,Y.RIGHT=180,Y.TOP_RIGHT=225,Y.TOP=270,Y.TOP_LEFT=315,Y.prototype.Init=function(){Y.superclass.Init.call(this,U.LINEAR)},Y.prototype.getAngle=function(){return this._angle},Y.prototype.setAngle=function(t){this._angle=t};const W={parseLeadingColor:function(t,e){var i,n=t.trim(),r=n.length,o=-1;if(!n)return n;if(0==n.indexOf("rgb"))o=n.indexOf(")")+1,i=n.slice(0,o);else{-1==(o=n.indexOf(" "))&&(o=r);var s=n.slice(0,o);(i=T.getColorFromName(s))||(i=W.parseHexColor(s))}return i&&(e.push(i),n=n.slice(o)),n},parseHexColor:function(t){return t?"#"!==t.charAt(0)||isNaN("0x"+t.substring(1))?"#000000":t:null}},V=function(){};i.createSubclass(V,i),V.GD_LINEAR="linear-gradient",V.GD_TOP="top",V.GD_BOTTOM="bottom",V.GD_LEFT="left",V.GD_RIGHT="right",V.GD_TO="to",V.parseCSSGradient=function(t){return null!=t&&(t=t.trim(),V._startsWith(t,V.GD_LINEAR))?(t=V._removeParenthesis(t,V.GD_LINEAR),V._parseLinearGradient(t)):null},V._parseLinearGradient=function(t){var e=new RegExp("(-?(?:\\d*\\.)?\\d+)"),i=new RegExp("(deg|rad|grad|turn)"),n=new RegExp("(left|right)"),r=new RegExp("(top|bottom)"),o=new RegExp("(?:(to)\\s+)"),s=new RegExp("(?:"+e.source+i.source+")"),a=new RegExp("(?:"+n.source+"(?:\\s+"+r.source+")?)"),h=new RegExp("(?:"+r.source+"(?:\\s+"+n.source+")?)"),l=new RegExp("(?:"+a.source+"|"+h.source+")"),u=new RegExp("(?:"+s.source+"|(?:"+o.source+"?"+l.source+"))"),c=new RegExp("(?:\\s*"+u.source+"\\s*,\\s*)","i"),_=t.match(c);if(null==_||0==_.length)return null;_.length;var p=new Y,d=_[5]==V.GD_TOP||_[6]==V.GD_TOP,g=_[5]==V.GD_BOTTOM||_[6]==V.GD_BOTTOM,f=_[4]==V.GD_LEFT||_[7]==V.GD_LEFT,y=_[4]==V.GD_RIGHT||_[7]==V.GD_RIGHT;if(_[3]==V.GD_TO&&((d||g)&&(d=!d,g=!g),(f||y)&&(f=!f,y=!y)),d)f?p.setAngle(Y.TOP_LEFT):y?p.setAngle(Y.TOP_RIGHT):p.setAngle(Y.TOP);else if(g)f?p.setAngle(Y.BOTTOM_LEFT):y?p.setAngle(Y.BOTTOM_RIGHT):p.setAngle(Y.BOTTOM);else if(f)p.setAngle(Y.LEFT);else if(y)p.setAngle(Y.RIGHT);else if(_[2]){s=parseFloat(_[1]);isNaN(s)||("grad"==_[2]?s=s/200*180:"rad"==_[2]?s=s/Math.PI*180:"turn"==_[2]&&(s=s/.5*180),p.setAngle(s))}return t=t.substring(_[0].length),V._parseCSSColorStops(t,p),p},V._parseCSSColorStops=function(t,e){var i=t.match(/(#[0-9a-f]+|rgb\(\s*(\d+),\s*(\d+),\s*(\d+)\s*\)|rgba\(\s*(\d+),\s*(\d+),\s*(\d+),\s*(\d?)(\.\d+)?\s*\)|[a-z]+)(\s+\d+\.?\d*%)?/gi);null!=i&&i.length>0&&V._parseColorStops(i,e)},V._parseColorStops=function(t,e){for(var i,n,r,o=t.length,s=[],a=[],h=[],l=!0,u=[],c=0;c<t.length;c++)r=W.parseLeadingColor(t[c],u),i=u.pop(),a[c]=i,s[c]=T.getAlpha(i),(r=r.trim()).length>0&&(n=parseFloat(r),isNaN(n)||r.endsWith("%")&&(h[c]=n/100,l=!1));if(o>1&&l)for(var _=0;_<o;_++)h[_]=_/(o-1);else l&&(h[0]=0);e.setColors(a),e.setAlphas(s),e.setRatios(h)},V._removeParenthesis=function(t,e){return")"!=t.charAt(t.length-1)?null:(t=t.substring(e.length),V.removeQuotes(t,"(",")"))},V.removeQuotes=function(t,e,i){if((t=t.trim()).charAt(0)!=e)return t;null==i&&(i=e);var n=t.lastIndexOf(i);return n<0?t.substring(1):t.substring(1,n)},V._startsWith=function(t,e){return 0==t.indexOf(e)};const j=function(t){this.Init(t)};i.createSubclass(j,i),j.DEFAULT_FONT_SIZE="12px",j.SKIN_ALTA="alta",j.BACKGROUND="background",j.BACKGROUND_COLOR="background-color",j.BACKGROUND_IMAGE="background-image",j.BACKGROUND_REPEAT="background-repeat",j.BACKGROUND_POSITION="background-position",j.BORDER="border",j.BORDER_TOP="border-top",j.BORDER_BOTTOM="border-bottom",j.BORDER_LEFT="border-left",j.BORDER_RIGHT="border-right",j.BORDER_WIDTH="border-width",j.BORDER_TOP_WIDTH="border-top-width",j.BORDER_BOTTOM_WIDTH="border-bottom-width",j.BORDER_LEFT_WIDTH="border-left-width",j.BORDER_RIGHT_WIDTH="border-right-width",j.BORDER_COLOR="border-color",j.BORDER_TOP_COLOR="border-top-color",j.BORDER_BOTTOM_COLOR="border-bottom-color",j.BORDER_LEFT_COLOR="border-left-color",j.BORDER_RIGHT_COLOR="border-right-color",j.BORDER_STYLE="border-style",j.BORDER_RADIUS="border-radius",j.BORDER_TOP_LEFT_RADIUS="border-top-left-radius",j.BORDER_TOP_RIGHT_RADIUS="border-top-right-radius",j.BORDER_BOTTOM_RIGHT_RADIUS="border-bottom-right-radius",j.BORDER_BOTTOM_LEFT_RADIUS="border-bottom-left-radius",j.MARGIN="margin",j.MARGIN_TOP="margin-top",j.MARGIN_BOTTOM="margin-bottom",j.MARGIN_LEFT="margin-left",j.MARGIN_RIGHT="margin-right",j.PADDING="padding",j.PADDING_TOP="padding-top",j.PADDING_BOTTOM="padding-bottom",j.PADDING_LEFT="padding-left",j.PADDING_RIGHT="padding-right",j.COLOR="color",j.FONT_FAMILY="font-family",j.FONT_SIZE="font-size",j.FONT_STYLE="font-style",j.FONT_WEIGHT="font-weight",j.TEXT_DECORATION="text-decoration",j.TEXT_ALIGN="text-align",j.HEIGHT="height",j.WIDTH="width",j.MAX_WIDTH="max-width",j.NO_REPEAT="no-repeat",j.REPEAT="repeat",j.REPEAT_X="repeat-x",j.REPEAT_Y="repeat-y",j.AUTO="auto",j.AUTO_MARGIN="8",j.WHITE_SPACE="white-space",j._NAMED_FONT_SIZE_MAP={"xx-small":"9","x-small":"10",small:"13",medium:"16",large:"18","x-large":"24","xx-large":"32"},j._NAMED_WIDTH_MAP={thin:"2",medium:"4",thick:"6"},j._numericAttrsList=[j.MAX_WIDTH,j.WIDTH,j.HEIGHT,j.BORDER_WIDTH,j.BORDER_TOP_WIDTH,j.BORDER_BOTTOM_WIDTH,j.BORDER_LEFT_WIDTH,j.BORDER_RIGHT_WIDTH,j.MARGIN,j.MARGIN_TOP,j.MARGIN_BOTTOM,j.MARGIN_LEFT,j.MARGIN_RIGHT,j.PADDING,j.PADDING_TOP,j.PADDING_BOTTOM,j.PADDING_LEFT,j.PADDING_RIGHT],j._DOUBLE_QUOTE='"',j._SINGLE_QUOTE="'",j.COLORS_ALTA=["#237bb1","#68c182","#fad55c","#ed6647","#8561c8","#6ddbdb","#ffb54d","#e371b2","#47bdef","#a2bf39","#a75dba","#f7f37b"],j.prototype.Init=function(t){this._styleMap={},this.parseInlineStyle(t)},j.prototype.parseInlineStyle=function(t){if(t){var e=this;if(t instanceof Object)for(var i in t){var n=t[i];i=i.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase(),e.setStyle(i,n)}else j._parseStyleString(t,function(t,i){e.setStyle(t,i)})}},j.prototype.setStyle=function(t,e){if(null==e)this._setStyleAttr(t,e);else switch(t){case"background-repeat":this._setBackgroundRepeat(t,e);break;case"color":case"background-color":case"border-top-color":case"border-bottom-color":case"border-left-color":case"border-right-color":this._setColorAttr(t,e);break;case"border-top":case"border-bottom":case"border-left":case"border-right":this._setBorderSide(t,e);break;case"border":this._setBorderShorthand(t,e);break;case"border-color":this._setBorderColorShorthand(t,e);break;case"border-width":this._setBorderWidthShorthand(t,e);break;case"border-radius":this._setBorderRadius(t,e);break;case"padding":this._setPaddingShorthand(t,e);break;case"margin":this._setMarginShorthand(t,e);break;case"font-size":this.setFontSize(t,e);break;case"background-image":var i=V.parseCSSGradient(e);i&&(e=i),this._setStyleAttr(t,e);break;default:this._setStyleAttr(t,e)}return this},j.prototype.getStyle=function(t){return this._styleMap[t]},j.prototype._setStyleAttr=function(t,e){return null!=e?this._styleMap[t]=e:delete this._styleMap[t],this},j.prototype.setFontSize=function(t,e,i){var n=e.trim(),r=j._NAMED_FONT_SIZE_MAP[n];if(r)this._setStyleAttr(t,String(r)+"px");else{var o=i?i.getDefaultFontSize():j.DEFAULT_FONT_SIZE;this._setStyleAttr(t,isNaN(parseFloat(n))?o:n)}},j.prototype._setBorderWidthShorthand=function(t,e){var i=e.split(" "),n=null;switch(i.length){case 1:this._setStyleAttr(t,j._getBorderWidth(i[0])),this._setStyleAttr(j.BORDER_TOP_WIDTH,null),this._setStyleAttr(j.BORDER_BOTTOM_WIDTH,null),this._setStyleAttr(j.BORDER_RIGHT_WIDTH,null),this._setStyleAttr(j.BORDER_LEFT_WIDTH,null);break;case 2:n=j._getBorderWidth(i[0]),this._setStyleAttr(j.BORDER_TOP_WIDTH,n),this._setStyleAttr(j.BORDER_BOTTOM_WIDTH,n),n=j._getBorderWidth(i[1]),this._setStyleAttr(j.BORDER_LEFT_WIDTH,n),this._setStyleAttr(j.BORDER_RIGHT_WIDTH,n);break;case 3:this._setStyleAttr(j.BORDER_TOP_WIDTH,j._getBorderWidth(i[0])),n=j._getBorderWidth(i[1]),this._setStyleAttr(j.BORDER_LEFT_WIDTH,n),this._setStyleAttr(j.BORDER_RIGHT_WIDTH,n),this._setStyleAttr(j.BORDER_BOTTOM_WIDTH,j._getBorderWidth(i[2]));break;case 4:this._setStyleAttr(j.BORDER_TOP_WIDTH,j._getBorderWidth(i[0])),this._setStyleAttr(j.BORDER_RIGHT_WIDTH,j._getBorderWidth(i[1])),this._setStyleAttr(j.BORDER_BOTTOM_WIDTH,j._getBorderWidth(i[2])),this._setStyleAttr(j.BORDER_LEFT_WIDTH,j._getBorderWidth(i[3]))}},j._getBorderWidth=function(t){var e=t.trim(),i=j._NAMED_WIDTH_MAP[e];return i||(i=isNaN(parseFloat(e))?"0px":e),i},j.prototype._setBorderSide=function(t,e){for(var i,n=e.split(" "),r=null,o=!1,s=0;s<n.length;s++)if(i=t,0==(r=n[s]).indexOf("rgb")){for(var a=s+1;a<n.length&&(r+=n[a],s++,-1==n[a].indexOf(")"));a++);t.endsWith("-"+j.COLOR)||(i=t+"-"+j.COLOR),this._setStyleAttr(i,r)}else j._isColorValue(r)?(t.endsWith("-"+j.COLOR)||(i=t+"-"+j.COLOR),this._setStyleAttr(i,W.parseHexColor(r))):j._isBorderWidthValue(r)?(t.endsWith("-"+j.WIDTH)||(i=t+"-"+j.WIDTH),this._setStyleAttr(i,r)):"none"==e&&(o=!0);o&&this._setStyleAttr(t+"-"+j.WIDTH,"0")},j.prototype.getMargin=function(t){return this._getSideWidth(t,j.MARGIN)},j.prototype.getPadding=function(t){return this._getSideWidth(t,j.PADDING)},j.prototype.getBorderWidth=function(){var t=this.getStyle(j.BORDER_WIDTH);return t||(t=this.getStyle(j.BORDER_TOP_WIDTH))||(t=this.getStyle(j.BORDER_RIGHT_WIDTH))||(t=this.getStyle(j.BORDER_BOTTOM_WIDTH))||(t=this.getStyle(j.BORDER_LEFT_WIDTH))?j.toNumber(t):0},j.prototype.getMaxWidth=function(){return this.getStyle(j.MAX_WIDTH)},j.prototype.getWidth=function(){return this.getStyle(j.WIDTH)},j.prototype.getHeight=function(){return this.getStyle(j.HEIGHT)},j.toNumber=function(t){return t?(t=parseFloat(t),isNaN(t)?0:t):0},j.prototype._setBorderColorShorthand=function(t,e){var i,n=j._parseBorderColorString(t,e);switch(n.length){case 1:this._setStyleAttr(t,n[0]),this._setStyleAttr(j.BORDER_TOP_COLOR,null),this._setStyleAttr(j.BORDER_BOTTOM_COLOR,null),this._setStyleAttr(j.BORDER_RIGHT_COLOR,null),this._setStyleAttr(j.BORDER_LEFT_COLOR,null);break;case 2:i=n[0],this._setStyleAttr(j.BORDER_TOP_COLOR,i),this._setStyleAttr(j.BORDER_BOTTOM_COLOR,i),i=n[1],this._setStyleAttr(j.BORDER_LEFT_COLOR,i),this._setStyleAttr(j.BORDER_RIGHT_COLOR,i);break;case 3:this._setStyleAttr(j.BORDER_TOP_COLOR,n[0]),i=n[1],this._setStyleAttr(j.BORDER_LEFT_COLOR,i),this._setStyleAttr(j.BORDER_RIGHT_COLOR,i),this._setStyleAttr(j.BORDER_BOTTOM_COLOR,n[2]);break;case 4:this._setStyleAttr(j.BORDER_TOP_COLOR,n[0]),this._setStyleAttr(j.BORDER_RIGHT_COLOR,n[1]),this._setStyleAttr(j.BORDER_BOTTOM_COLOR,n[2]),this._setStyleAttr(j.BORDER_LEFT_COLOR,n[3])}},j.prototype._setPaddingShorthand=function(t,e){var i=e.split(" "),n=null;switch(i.length){case 1:this._setStyleAttr(t,this._getPercent(i[0])),this._setStyleAttr(j.PADDING_TOP,null),this._setStyleAttr(j.PADDING_BOTTOM,null),this._setStyleAttr(j.PADDING_RIGHT,null),this._setStyleAttr(j.PADDING_LEFT,null);break;case 2:n=this._getPercent(i[0]),this._setStyleAttr(j.PADDING_TOP,n),this._setStyleAttr(j.PADDING_BOTTOM,n),n=this._getPercent(i[1]),this._setStyleAttr(j.PADDING_LEFT,n),this._setStyleAttr(j.PADDING_RIGHT,n);break;case 3:this._setStyleAttr(j.PADDING_TOP,this._getPercent(i[0])),n=this._getPercent(i[1]),this._setStyleAttr(j.PADDING_LEFT,n),this._setStyleAttr(j.PADDING_RIGHT,n),this._setStyleAttr(j.PADDING_BOTTOM,this._getPercent(i[2]));break;case 4:this._setStyleAttr(j.PADDING_TOP,this._getPercent(i[0])),this._setStyleAttr(j.PADDING_RIGHT,this._getPercent(i[1])),this._setStyleAttr(j.PADDING_BOTTOM,this._getPercent(i[2])),this._setStyleAttr(j.PADDING_LEFT,this._getPercent(i[3]))}},j.prototype._setMarginShorthand=function(t,e){var i=e.split(" "),n=null;switch(i.length){case 1:this._setStyleAttr(t,this._getMargin(i[0])),this._setStyleAttr(j.MARGIN_TOP,null),this._setStyleAttr(j.MARGIN_BOTTOM,null),this._setStyleAttr(j.MARGIN_RIGHT,null),this._setStyleAttr(j.MARGIN_LEFT,null);break;case 2:n=this._getMargin(i[0]),this._setStyleAttr(j.MARGIN_TOP,n),this._setStyleAttr(j.MARGIN_BOTTOM,n),n=this._getMargin(i[1]),this._setStyleAttr(j.MARGIN_LEFT,n),this._setStyleAttr(j.MARGIN_RIGHT,n);break;case 3:this._setStyleAttr(j.MARGIN_TOP,this._getMargin(i[0])),n=this._getMargin(i[1]),this._setStyleAttr(j.MARGIN_LEFT,n),this._setStyleAttr(j.MARGIN_RIGHT,n),this._setStyleAttr(j.MARGIN_BOTTOM,this._getMargin(i[2]));break;case 4:this._setStyleAttr(j.MARGIN_TOP,this._getMargin(i[0])),this._setStyleAttr(j.MARGIN_RIGHT,this._getMargin(i[1])),this._setStyleAttr(j.MARGIN_BOTTOM,this._getMargin(i[2])),this._setStyleAttr(j.MARGIN_LEFT,this._getMargin(i[3]))}},j.prototype._getMargin=function(t){var e=t.trim();return j.AUTO==e?j.AUTO_MARGIN:this._getPercent(e)},j.prototype._getPercent=function(t){return t.trim()},j.prototype._setBorderShorthand=function(t,e){for(var i=e.split(" "),n=null,r=!1,o=0;o<i.length;o++)if(0==(n=i[o]).indexOf("rgb")){for(var s=o+1;s<i.length&&(n+=i[s],o++,-1==i[s].indexOf(")"));s++);this._setBorderColorShorthand(j.BORDER_COLOR,n)}else j._isColorValue(n)?this._setBorderColorShorthand(j.BORDER_COLOR,n):j._isBorderWidthValue(n)?this._setBorderWidthShorthand(j.BORDER_WIDTH,n):"none"==e&&(r=!0);r&&this._setBorderWidthShorthand(j.BORDER_WIDTH,"0")},j._getBorderRadius=function(t){var e=t.trim();return isNaN(parseFloat(e))?"0px":e},j.prototype._setBorderRadius=function(t,e){var i=e.split("/");if(null!=i[0]){var n=i[0].trim().split(" ");switch(n.length){case 1:default:this._setStyleAttr(t,j._getBorderRadius(n[0])),this._setStyleAttr(j.BORDER_TOP_LEFT_RADIUS,null),this._setStyleAttr(j.BORDER_TOP_RIGHT_RADIUS,null),this._setStyleAttr(j.BORDER_BOTTOM_RIGHT_RADIUS,null),this._setStyleAttr(j.BORDER_BOTTOM_LEFT_RADIUS,null)}if(2==i.length&&null!=i[1]){var r=i[1].trim().split(" ");switch(r.length){case 1:this.getStyle(t)?this._setStyleAttr(t,this.getStyle(t)+" "+j._getBorderRadius(r[0])):this._setStyleAttr(t,j._getBorderRadius(r[0]))}}}else this._setStyleAttr(t,"0px")},j.prototype.getBorderRadius=function(){return"undefined"!==this.getStyle(j.BORDER_RADIUS)&&null!==this.getStyle(j.BORDER_RADIUS)?j.toNumber(this.getStyle(j.BORDER_RADIUS)):0},j.prototype._setBackgroundRepeat=function(t,e){var i=e.split(" ");2==i.length&&(i[0]==i[1]?e=i[0]:i[0]==j.REPEAT&&i[1]==j.NO_REPEAT&&(e=j.REPEAT_X),i[0]==j.NO_REPEAT&&i[1]==j.REPEAT&&(e=j.REPEAT_Y)),this._setStyleAttr(t,e)},j.prototype._setColorAttr=function(t,e){var i=T.getColorFromName(e);i?this._setStyleAttr(t,i):j._isColorValue(e)&&this._setStyleAttr(t,e)},j.prototype.clone=function(){var t=new j;for(var e in this._styleMap)t._setStyleAttr(e,this.getStyle(e));return t},j.prototype.merge=function(t){if(t)for(var e in t._styleMap)this._setStyleAttr(e,t.getStyle(e));return this},j.prototype.mergeUnder=function(t){if(t)for(var e in t._styleMap)this.getStyle(e)||this._setStyleAttr(e,t.getStyle(e));return this},j.prototype.toString=function(){var t="";for(var e in this._styleMap)t+=e+":"+this.getStyle(e)+"; ";return t},j.prototype.hasBackgroundStyles=function(){return!!(this.getStyle(j.BORDER_COLOR)||this.getStyle(j.BORDER_WIDTH)||this.getStyle(j.BORDER_RADIUS)||this.getStyle(j.BACKGROUND_COLOR))},j._isColorValue=function(t){return 0==(t=t.trim()).indexOf("rgb")||0==t.indexOf("#")||!!T.getColorFromName(t)},j._isBorderWidthValue=function(t){var e=t.trim();return!!j._NAMED_WIDTH_MAP[e]||!isNaN(parseFloat(e))},j._parseBorderColorString=function(t,e){e=e.trim();for(var i=[];null!=e&&e.length>0;)e=W.parseLeadingColor(e,i);return i},j.prototype._getSideWidth=function(t,e){var i=this.getStyle(t);return i||(i=this.getStyle(e)),j.toNumber(i)},j.prototype.getFontSize=function(){return this.getStyle(j.FONT_SIZE)},j.mergeStyles=function(t){var e=new j;if(t)for(var i=0;i<t.length;i++)e.merge(t[i]);return e},j.prototype.isEmpty=function(){for(var t in this._styleMap)return!1;return!0},j.prototype.hashCodeForTextMeasurement=function(){for(var t="",e=j.getTextMeasurementProperties(),i=0;i<e.length;i++){var n=this.getStyle(e[i]);n&&(t+=n)}return t},j.getTextMeasurementProperties=function(){return[j.FONT_FAMILY,j.FONT_SIZE,j.FONT_STYLE,j.FONT_WEIGHT]},j.cssObjectToString=function(t){var e="";return t&&JSON.parse(JSON.stringify(t),function(t,i){t&&(t=t.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase(),e+=t+":"+i+";")}),e},j.cssStringToObject=function(t){var e={};return j._parseStyleString(t,function(t,i){t=j.cssStringToObjectProperty(t),e[t]=i}),e},j.cssStringToObjectProperty=function(t){return t&&(t=t.replace(/-([a-z])/g,function(t){return t[1].toUpperCase()})),t},j._parseStyleString=function(t,e){if(t&&t.length>0)for(var i=t.split(";"),n=0;n<i.length;n++){var r=i[n];if(r&&r.length>0){var o=r.indexOf(":");if(o>-1){var s=r.substring(0,o).trim(),a=r.substring(o+1).trim();s&&s.length>0&&a&&a.length>0&&(s==j.BACKGROUND_IMAGE&&a.indexOf("data:image/")>=0&&(a=a+";"+i[n+1],n++),e(s,a))}}}},j.getTimeMilliseconds=function(t){return"string"==typeof t&&(t="ms"==t.slice(-2)?parseInt(t.slice(0,-2)):"s"==t.slice(-1)?1e3*parseFloat(t.slice(0,-1)):parseInt(t)),t},j.prototype.applyStylesToElement=function(t){j.applyCssObjectToElement(this._styleMap,t)},j.applyCssObjectToElement=function(t,e){for(var i=Object.keys(t),n=0;n<i.length;n++){var r=i[n];e.style[j.cssStringToObjectProperty(r)]=t[r]}};const K=function(t,e){this._fc=t,this._fa=null!=e?e:1};i.createSubclass(K,i),K.prototype.getColor=function(){return this._fc},K.prototype.getAlpha=function(){return this._fa},K.invisibleFill=function(){return K._INVISIBLE_FILL||(K._INVISIBLE_FILL=new K("rgba(0,0,0,0)")),K._INVISIBLE_FILL},K.prototype.equals=function(t){return t instanceof K&&t.getColor()==this.getColor()&&t.getAlpha()==this.getAlpha()};const z=function(t,e,i,n,r,o){this._color=t,this._alpha=null!=e?e:1,this._width=null===i||isNaN(i)?1:i,this._fixedWidth=n||!1,this._dashProps=r,this._lineProps=o};i.createSubclass(z,i),z.prototype.getLineProps=function(){return this._lineProps},z.prototype.getDashProps=function(){return this._dashProps},z.prototype.getAlpha=function(){return this._alpha},z.prototype.getColor=function(){return this._color},z.prototype.getWidth=function(){return this._width},z.prototype.isFixedWidth=function(){return this._fixedWidth},z.getDefaultDashProps=function(t,e){return"solid"===t?null:(e=Math.ceil(e),"dashed"==t?{dashArray:""+Math.max(6,2*e)}:"dotted"==t?{dashArray:""+Math.max(2,e)}:null)};const X={getFill:function(){return this.GetProperty("fill")},setFill:function(t){if(this._manageDefinitions(this.GetProperty("fill"),t),!t)return u.setAttrNullNS(this._elem,"fill","none"),u.removeAttrNullNS(this._elem,"fill-opacity"),void this.SetProperty("fill",null);if(this.GetProperty("fill")!==t){if(this.SetProperty("fill",t),t instanceof g||t instanceof y){var e=A.addSpecialFill(t,this.getCtx());u.setAttrNullNS(this._elem,"fill",u.getUrlById(e))}else{var i=T.fixColorForPlatform(t.getColor(),t.getAlpha());i&&i.color&&(u.setAttrNullNS(this._elem,"fill",i.color),null!=i.alpha&&u.setAttrNullNS(this._elem,"fill-opacity",i.alpha,1))}this.UpdateSelectionEffect()}},getClassName:function(){return this._className},setClassName:function(t){return this._className&&!t?u.removeAttrNullNS(this._elem,"class"):t&&u.setAttrNullNS(this._elem,"class",t),this._className=t,this},addClassName:function(t){u.addClassName(this._elem,t),this._className=u.getAttrNullNS(this._elem,"class")},removeClassName:function(t){u.removeClassName(this._elem,t),this._className=u.getAttrNullNS(this._elem,"class")},getStyle:function(){return this._style},setStyle:function(t){return this._style&&u.removeAttrNullNS(this._elem,"style"),t&&j.applyCssObjectToElement(t,this._elem),this._style=t,this},setSolidFill:function(t,e){this.setFill(new K(t,e))},setInvisibleFill:function(){this.setFill(K.invisibleFill())},getStroke:function(){return this._stroke},setStroke:function(t){this._manageDefinitions(this._stroke,t),this._stroke=t;if(!t)return u.removeAttrNullNS(this._elem,"stroke"),u.removeAttrNullNS(this._elem,"stroke-opacity"),u.removeAttrNullNS(this._elem,"stroke-width"),u.removeAttrNullNS(this._elem,"stroke-dasharray"),u.removeAttrNullNS(this._elem,"stroke-dashoffset"),u.removeAttrNullNS(this._elem,"stroke-linejoin"),u.removeAttrNullNS(this._elem,"stroke-linecap"),void u.removeAttrNullNS(this._elem,"stroke-miterlimit");var e=T.fixColorForPlatform(t.getColor(),t.getAlpha());e&&e.color?(u.setAttrNullNS(this._elem,"stroke",e.color),null!=e.alpha&&u.setAttrNullNS(this._elem,"stroke-opacity",e.alpha,1)):(u.removeAttrNullNS(this._elem,"stroke"),u.removeAttrNullNS(this._elem,"stroke-opacity")),u.setAttrNullNS(this._elem,"stroke-width",t.getWidth(),1),t.isFixedWidth()&&u.setAttrNullNS(this._elem,"vector-effect","non-scaling-stroke");var i=t.getDashProps();i&&i.dashArray?u.setAttrNullNS(this._elem,"stroke-dasharray",i.dashArray):u.removeAttrNullNS(this._elem,"stroke-dasharray"),i&&i.dashOffset?u.setAttrNullNS(this._elem,"stroke-dashoffset",i.dashOffset):u.removeAttrNullNS(this._elem,"stroke-dashoffset");var n=t.getLineProps();n&&n.lineJoin?u.setAttrNullNS(this._elem,"stroke-linejoin",n.lineJoin):u.removeAttrNullNS(this._elem,"stroke-linejoin"),n&&n.lineCap?u.setAttrNullNS(this._elem,"stroke-linecap",n.lineCap):u.removeAttrNullNS(this._elem,"stroke-linecap"),n&&n.miterLimit?u.setAttrNullNS(this._elem,"stroke-miterlimit",n.miterLimit):u.removeAttrNullNS(this._elem,"stroke-miterlimit")},setSolidStroke:function(t,e,i){this.setStroke(new z(t,e,i))},_manageDefinitions:function(t,e){t!=e&&(t&&(t._referenceCount--,0==t._referenceCount&&t._defElem&&(this.getCtx().removeDefs(t._defElem),t._defPresent=!1)),e&&(e._referenceCount||(e._referenceCount=0),e._referenceCount++))}},q=function(){};i.createSubclass(q,i),q.ATTRS_TRANSFERABLE_TO_OUTER=["clip-path"],q.getDimensionsForced=function(t,e){var i,n=e.getParent();n&&(i=n.getChildIndex(e));var r=t.getStage();r.addChild(e);var o=e.getDimensions();return r.removeChild(e),n&&n.addChildAt(e,i),o},q.getSvgDimensions=function(t){try{var e=t.getBBox()}catch(t){return null}return new m(e.x,e.y,e.width,e.height)},q.getDimForced=function(t,e){if(e._dim||!t)return e._dim;var i=q.getDimensionsForced(t,e);return q._setDimForced(e,i),i},q._setDimForced=function(t,e){t._dim=e},q.hasAttributes=function(t,e){if(e)for(var i=e.length,n=0;n<i;n++)if(u.getAttrNullNS(t,e[n]))return!0;return!1};const Z={setTranslate:function(t,e){this._modifyMatrix(null,null,t,e)},getTranslateX:function(){var t=this.getMatrix();return t?t._decompose()[l._DECOMP_TX]:0},setTranslateX:function(t){this._modifyMatrix(null,null,t)},getTranslateY:function(){var t=this.getMatrix();return t?t._decompose()[l._DECOMP_TY]:0},setTranslateY:function(t){this._modifyMatrix(null,null,null,t)},setScale:function(t,e){this._modifyMatrix(t,e)},getScaleX:function(){var t=this.getMatrix();return t?t._decompose()[l._DECOMP_SX]:1},setScaleX:function(t){this._modifyMatrix(t)},getScaleY:function(){var t=this.getMatrix();return t?t._decompose()[l._DECOMP_SY]:1},setScaleY:function(t){this._modifyMatrix(null,t)},getRotation:function(){var t=this.getMatrix();return t?t._decompose()[l._DECOMP_R]:0},setRotation:function(t){this._modifyMatrix(null,null,null,null,t)},getMatrix:function(){return this._matrix?this._matrix:new l},setMatrix:function(t){if(t&&t.isIdentity()&&(t=null),this._matrix!=t)if(this._matrix=t,!this._outerElem&&q.hasAttributes(this.getElem(),q.ATTRS_TRANSFERABLE_TO_OUTER)&&this._createOuterGroupElem(),this._matrix=t,t){var e="matrix("+t.getA()+","+t.getC()+","+t.getB()+","+t.getD()+","+t.getTx()+","+t.getTy()+")";u.setAttrNullNS(this.getElem(),"transform",e,"matrix(1,0,0,1,0,0)")}else{u.getAttrNullNS(this.getElem(),"transform")&&(u.removeAttrNullNS(this.getElem(),"transform"),"ie"!==r.browser&&"edge"!==r.browser||u.setAttrNullNS(this.getElem(),"transform",null))}},_modifyMatrix:function(t,e,i,n,r){var o=this.getMatrix()._decompose(),s=o[l._DECOMP_SX],a=o[l._DECOMP_SY],h=o[l._DECOMP_TX],u=o[l._DECOMP_TY],c=o[l._DECOMP_R],_=!1;if(null!=t&&s!=t&&(o[l._DECOMP_SX]=t,_=!0),null!=e&&a!=e&&(o[l._DECOMP_SY]=e,_=!0),null!=i&&h!=i&&(o[l._DECOMP_TX]=i,_=!0),null!=n&&u!=n&&(o[l._DECOMP_TY]=n,_=!0),null!=r&&c!=r&&(o[l._DECOMP_R]=r,_=!0),_){var p=this.getMatrix();this.setMatrix(p._recompose(o))}}},Q=function(){};i.createSubclass(Q,i),Q.SET_ID_ON_DOM=!1,Q.prototype.Init=function(t,e,i){this._context=t,this._elem=A.createElement(e),this._elem._obj=this,this.setId(i),this._bVisible=!0,this._cursor=null,this._alpha=1,this._matrix=null,this._ariaProperties={},this._properties={}},Q.prototype.getCtx=function(){return this._context},Q.prototype.getElem=function(){return this._elem},Q.prototype.getOuterElem=function(){return this._outerElem?this._outerElem:this.getElem()},Q.prototype.getId=function(){return this._id},Q.prototype.setId=function(t,e){this._id!==t&&(t&&0===t.length&&(t=null),this._id=t,(Q.SET_ID_ON_DOM||e)&&(t?u.setAttrNullNS(this.getOuterElem(),"id",t):u.removeAttrNullNS(this.getOuterElem(),"id")))},Q.prototype.getParent=function(){return this._parent},Q.prototype.setParent=function(t){this._parent=t},Q.prototype.isDescendantOf=function(t){return!(!t||!this.getParent())&&(this.getParent()==t||this.getParent().isDescendantOf(t))},Q.prototype.setPixelHinting=function(t){t?u.setAttrNullNS(this._elem,"shape-rendering","crispEdges"):u.removeAttrNullNS(this._elem,"shape-rendering")},Q.prototype.getVisible=function(){return this._bVisible},Q.prototype.setVisible=function(t){if(this._bVisible!==t){this._bVisible=t;var e=this.getElem();t?u.removeAttrNullNS(e,"visibility"):u.setAttrNullNS(e,"visibility","hidden")}},Q.prototype.setClipPath=function(t){if(t){if(this.ClipPathId==t.getId())return;this.ClipPathId&&this._context.decreaseGlobalDefReference(this.ClipPathId),this.ClipPathId=t.getId(),this._context.increaseGlobalDefReference(this.ClipPathId),!this._outerElem&&this._matrix&&this._createOuterGroupElem();var e=t.getId();if(e){var i=this.getCtx();A.addClipPath(t,i)&&u.setAttrNullNS(this.getOuterElem(),"clip-path",u.getUrlById(e))}}else if(this.ClipPathId)return this._context.decreaseGlobalDefReference(this.ClipPathId),this.ClipPathId=null,void u.removeAttrNullNS(this.getOuterElem(),"clip-path")},Q.prototype.setMask=function(t){if(t){if(this.MaskId==t.getId())return;this.MaskId&&this._context.decreaseGlobalDefReference(this.MaskId),this.MaskId=t.getId(),this._context.increaseGlobalDefReference(this.MaskId),!this._outerElem&&this._matrix&&this._createOuterGroupElem();var e=t.getId();if(e){var i=this.getCtx();A.addMask(t,i)&&u.setAttrNullNS(this.getOuterElem(),"mask",u.getUrlById(e))}}else if(this.MaskId)return this._context.decreaseGlobalDefReference(this.MaskId),this.MaskId=null,void u.removeAttrNullNS(this.getOuterElem(),"mask")},Q.prototype.ConvertCoordSpaceRect=function(t,e){if(!e||e===this)return t;var i=this.localToStage(new n(t.x,t.y)),r=this.localToStage(new n(t.x+t.w,t.y+t.h)),o=e.stageToLocal(i),s=e.stageToLocal(r);return new m(Math.min(o.x,s.x),Math.min(o.y,s.y),Math.abs(s.x-o.x),Math.abs(s.y-o.y))},Q.prototype.GetSvgDimensions=function(){return q.getSvgDimensions(this.getElem())},Q.prototype.getDimensions=function(t){var e=this.GetSvgDimensions();return this.ConvertCoordSpaceRect(e,t)},Q.prototype.getDimensionsWithStroke=function(t){var e=this.GetDimensionsWithStroke();return this.ConvertCoordSpaceRect(e,t)},Q.prototype.GetDimensionsWithStroke=function(t){var e=this.GetElemDimensionsWithStroke();return t&&t!==this?this.ConvertCoordSpaceRect(e,t):e},Q.prototype.GetElemDimensionsWithStroke=function(){return this.GetSvgDimensions()},Q.TransferAttributes=function(t,e,i){if(i)for(var n,o,s=i.length,a=0;a<s;a++)n=i[a],(o=u.getAttrNullNS(t,n))&&(u.removeAttrNullNS(t,n),u.setAttrNullNS(e,n,o),"ie"!==r.browser&&"edge"!==r.browser||u.setAttrNullNS(t,n,null))},Q.prototype._createOuterGroupElem=function(){if(!this._outerElem){var t=this._id?this._id+"_outer":null;this._outerElem=A.createElement("g",t);var e=this.getParent();if(e)e.getElem().replaceChild(this._outerElem,this.getElem());u.appendChildElem(this._outerElem,this.getElem()),Q.TransferAttributes(this.getElem(),this._outerElem,q.ATTRS_TRANSFERABLE_TO_OUTER)}},Q.prototype.getCSSStyle=function(){return this._cssStyle},Q.prototype.setCSSStyle=function(t){this._cssStyle=t},Q.prototype.setCursor=function(t){this._cursor=t,t?u.setAttrNullNS(this.getElem(),"cursor",t):u.removeAttrNullNS(this.getElem(),"cursor")},Q.prototype.getCursor=function(){return this._cursor},Q.prototype.setMouseEnabled=function(t){var e=t?"visiblePainted":"none";u.setAttrNullNS(this.getElem(),"pointer-events",e)},Q.prototype.getAlpha=function(){return this._alpha},Q.prototype.setAlpha=function(t){t<1e-5&&(t=0),t!==this._alpha&&(this._alpha=t,u.setAttrNullNS(this.getElem(),"opacity",this._alpha,1))},Q.prototype.applyAriaProperties=function(){if(r.deferAriaCreation())for(var t in this._ariaRole&&this._setAriaRole(this._ariaRole),this._ariaProperties)this._setAriaProperty(t,this._ariaProperties[t])},Q.prototype.setAriaRole=function(t,e){r.deferAriaCreation()&&!e||this._setAriaRole(t),this._ariaRole=t},Q.prototype._setAriaRole=function(t){var e=this.GetAriaElem();t?u.setAttrNullNS(e,"role",t):u.removeAttrNullNS(e,"role")},Q.prototype.getAriaRole=function(){return this._ariaRole},Q.prototype.GetAriaElem=function(){return this.getElem()},Q.prototype.setAriaProperty=function(t,e,i){t&&(r.deferAriaCreation()&&!i||this._setAriaProperty(t,e),this._ariaProperties[t]=e)},Q.prototype._setAriaProperty=function(t,e){var i=this.GetAriaElem();null!=e&&""!==e?("label"===t&&(e=O.processAriaLabel(e)),u.setAttrNullNS(i,"aria-"+t,e)):u.removeAttrNullNS(i,"aria-"+t)},Q.prototype.getAriaProperty=function(t){return t?this._ariaProperties[t]:null},Q.prototype.stageToLocal=function(t){for(var e=this.getPathToStage(),i=t,n=e.length-1;n>=0;n--)i=e[n].getMatrix().invert().transformPoint(i);return i},Q.prototype.localToStage=function(t){for(var e=this.getPathToStage(),i=t,n=0;n<e.length;n++)i=e[n].getMatrix().transformPoint(i);return i},Q.prototype.getPathToStage=function(){for(var t=this,e=[];t;)e.push(t),t=t.getParent();return e},Q.prototype.removeFromParent=function(){this._parent&&this._parent.removeChild(this)},Q.prototype.destroy=function(){this.removeAllDrawEffects(),this.ClipPathId&&this.setClipPath(null)},Q.prototype.GetProperty=function(t){return this._properties[t]},Q.prototype.SetProperty=function(t,e){return e!==this._properties[t]&&(this._properties[t]=e),this},Q.prototype.SetSvgProperty=function(t,e,i){return e!==this._properties[t]&&(this._properties[t]=e,u.setAttrNullNS(this._elem,t,e,i),this.SvgPropertyChanged(t)),this},Q.defineProps=function(t,e){Object.keys(e).forEach(function(i){var n=e[i],r=n.name||i;r=r.charAt(0).toUpperCase()+r.slice(1),t.prototype["get"+r]=function(){return this.GetProperty(i)},t.prototype["set"+r]=function(t){return this.SetSvgProperty(i,t,n.value)}})},Q.prototype.SvgPropertyChanged=function(t){},Q.generateAriaLabel=function(t,e,i){var n=[],r=e&&e.length>0;return t&&n.push(Q.resolveShortDesc(t,i)),r&&n.push(e.join(O.ARIA_LABEL_STATE_DELIMITER)),n.join(O.ARIA_LABEL_DESC_DELIMITER)},Q.resolveShortDesc=function(t,e){return"function"==typeof t?t(e()):t},Object.assign(Q.prototype,x),Object.assign(Q.prototype,B),Object.assign(Q.prototype,X),Object.assign(Q.prototype,Z);const J=function(t,e,i,n){this.Init(t,e,i,n)};i.createSubclass(J,Q),J.prototype.Init=function(t,e,i,n){this._bShapeContainer=!!n,J.superclass.Init.call(this,t,null!=e?e:"g",i),this._childGroupElem=null},J.AttributesTransferableToGroup=["transform","opacity","visibility","pointer-events","clip-path","cursor"],J.prototype.addChild=function(t){if(t){var e=t.getParent();e&&e.removeChild(t),this._arList||(this._arList=[]),t.setParent(this),this._bShapeContainer&&this.CreateChildGroupElem(!1);var i=this.getContainerElem();u.appendChildElem(i,t.getOuterElem()),this._arList.push(t)}},J.prototype.addChildAt=function(t,e){this.AddChildAt(t,e)},J.prototype.AddChildAt=function(t,e){if(e>=0&&e<=this.getNumChildren()&&t){var i=this._findChild(t);if(i>=0&&i==e)return;var n=t.getParent();n&&n.removeChild(t),t.setParent(this),i>=0&&e==this.getNumChildren()+1&&e--;var r=e;this._bShapeContainer&&(this.CreateChildGroupElem(!1),r++);var o=this.getContainerElem(),s=o.childNodes[r];s||(s=null),o.insertBefore(t.getOuterElem(),s),this._arList||(this._arList=[]),this._arList.splice(e,0,t)}},J.prototype.contains=function(t){return this._findChild(t)>=0},J.prototype._findChild=function(t){var e=-1;if(this._arList)for(var i=this._arList.length,n=0;n<i;n++)if(this._arList[n]===t){e=n;break}return e},J.prototype.getChildAfter=function(t){var e=null,i=this._findChild(t);return i>=0&&++i<this._arList.length&&(e=this._arList[i]),e},J.prototype.getChildBefore=function(t){var e=null,i=this._findChild(t);return i>0&&(e=this._arList[i-1]),e},J.prototype.getChildAt=function(t){var e=null;return this._arList&&this._arList.length>t&&t>=0&&(e=this._arList[t]),e},J.prototype.getChildIndex=function(t){return this._findChild(t)},J.prototype.getNumChildren=function(){return this._arList?this._arList.length:0},J.prototype.removeChild=function(t){var e=this._findChild(t);-1!==e&&this._removeObj(t,e)},J.prototype.removeChildImpl=function(t){var e=t.getOuterElem(),i=t.getParent();e&&i&&this.getContainerElem().removeChild(e);if(!this._anchorElem&&this._bShapeContainer&&1===this.getNumChildren()){var n=this._childGroupElem,r=n?n.parentNode:null;r&&(Q.TransferAttributes(n,this._elem,this.GetAttributesTransferableToGroup()),r.replaceChild(this._elem,n),this._childGroupElem=null)}},J.prototype.removeChildAt=function(t){var e=this.getChildAt(t);return e&&this._removeObj(e,t),e},J.prototype.removeChildren=function(){if(this._arList)for(var t=this._arList;this.getNumChildren()>0;)this._removeObj(t[0],0)},J.prototype._removeObj=function(t,e){this.removeChildImpl(t),t.setParent(null),this._arList.splice(e,1),0===this._arList.length&&(this._arList=null)},J.prototype.destroy=function(){J.superclass.destroy.call(this);for(var t=this.getNumChildren(),e=0;e<t;e++){this.getChildAt(e).destroy()}},J.prototype.GetAttributesTransferableToGroup=function(){return J.AttributesTransferableToGroup},J.prototype.getElem=function(){return this._childGroupElem?this._childGroupElem:this._elem},J.prototype.CreateChildGroupElem=function(t,e){if(this._childGroupElem||!e&&0!==this.getNumChildren())t&&this.removeChildren();else{var i=Q.SET_ID_ON_DOM&&this._id?this._id+"_g":null;this._childGroupElem=A.createElement("g",i);var n=this.getParent();n&&n.getElem().replaceChild(this._childGroupElem,this._elem),t||u.appendChildElem(this._childGroupElem,this._elem),Q.TransferAttributes(this._elem,this._childGroupElem,this.GetAttributesTransferableToGroup()),this._elem._obj&&(this._childGroupElem._obj=this._elem._obj)}},J.prototype.getDimensions=function(t){if(!r.isEnvironmentTest()||0===this.getNumChildren()||!this.CanOptimizeDimensions())return J.superclass.getDimensions.call(this,t);let e=this._getDimensionsHelper(t=>t.getDimensions(this));if(this._bShapeContainer){const t=q.getSvgDimensions(this._elem);e=e.getUnion(t)}return this.ConvertCoordSpaceRect(e,t)},J.prototype.CanOptimizeDimensions=function(){return!0},J.prototype.getDimensionsWithStroke=function(){return this._getDimensionsHelper(t=>t.GetDimensionsWithStroke(this))},J.prototype._getDimensionsHelper=function(t){for(var e=[],i=this.getNumChildren(),n=0;n<i;n++)e.push(this.getChildAt(n));for(var r=null;e.length>0;){var o=e.shift(),s=t(o);if(s&&(r=r?r.getUnion(s):s),!o.includeChildSubtree||o.includeChildSubtree()){i=o.getNumChildren();for(var a=0;a<i;a++)e.push(o.getChildAt(a))}}return r},J.prototype.GetDimensionsWithStroke=function(t){return null},J.prototype.getContainerElem=function(){return this._anchorElem?this._anchorElem:this.getElem()},J.prototype.UpdateSelectionEffect=function(){},J.prototype.setHollow=function(t,e){for(var i=0;i<this.getNumChildren();i++){var n=this.getChildAt(i),r=n.getFill()?n.getFill().getColor():t;n.setHollow(r,e)}},J.prototype.includeChildSubtree=function(){return!0};const tt=function(t,e,i){this.Init(t,"g",i),this._SVGRoot=e,this.disableSelection(this._elem),this.setCursor("default")};i.createSubclass(tt,J),tt.prototype.addChild=function(t){tt.superclass.addChild.call(this,t)},tt.prototype.getSVGRoot=function(){return this._SVGRoot},tt.prototype.disableSelection=function(t){t.onselectstart=function(){return!1}};const et=function(t){this.Init(t)};i.createSubclass(et,i),et.prototype.Init=function(t){this._scheduledItems=new Array,this._bRunning=!1},et.prototype.HandleTimer=function(){for(var t=(new Date).getTime(),e=0;e<this._scheduledItems.length;e++){var n=this._scheduledItems[e];n.processTime(t)&&this.removeScheduled(n)}this._scheduledItems.length<1?(this._bRunning&&(this._bRunning=!1,this._animationRequestId&&_(this._animationRequestId)),this._animationRequestId=null):this._animationRequestId=c(i.createCallback(this,this.HandleTimer)),et._frameCount++},et.prototype.addScheduled=function(t){this._scheduledItems.indexOf(t)<0&&this._scheduledItems.push(t),this.play()},et.prototype.removeScheduled=function(t){var e=this._scheduledItems.indexOf(t);e>=0&&this._scheduledItems.splice(e,1)},et.prototype.play=function(){if(!this._bRunning){for(var t=0;t<this._scheduledItems.length;t++){var e=this._scheduledItems[t];e.isRunning()||e.play()}this._bRunning=!0,this._animationRequestId=c(i.createCallback(this,this.HandleTimer))}};const it=function(t,e){this.Init(t,e)};let nt;i.createSubclass(it,i),it._TOOLTIP_DIV_ID="_dvtTooltip",it._SHOW_DELAY=500,it._BORDER_COLOR="#9ba2b0",it._FONT_COLOR="#383a47",it._VIEWPORT_BUFFER=15,it.prototype.Init=function(t,e){this._context=t,this._domElementId=e||it._TOOLTIP_DIV_ID,this._isTooltip=!0},it.prototype.showDatatip=function(t,e,i,n,r){null==r&&(r=!0),this._isTooltip=!1,this._showTextAtPosition(t,e,i,n,r,"oj-dvt-datatip")},it.prototype._showTextAtPosition=function(t,e,i,n,r,o){var s,a=this.getTooltipElem(),h=!0!==i;if(h)for(;a.hasChildNodes();)a.removeChild(a.firstChild);"string"==typeof i?(i=(i=i.replace(/(<|&#60;)/g,"&lt;")).replace(/(>|&#62;)/g,"&gt;"),i=it._restoreTag(i,"b"),i=it._restoreTag(i,"i"),i=it._restoreTag(i,"table"),i=it._restoreTag(i,"tr"),i=(i=(i=(i=it._restoreTag(i,"td")).replace(/\n/g,"<br>")).replace(/\\n/g,"<br>")).replace(/&#92;n/g,"<br>"),i=it._restoreTag(i,"br"),(s=document.createElement("span")).style.visibility="inherit",s.style.width=null,s.style.height=null,s.innerHTML=i):h&&(s=i),this._isCustomClassName||(a.className=o),this._isCustomClassName=!1,n||(n=it._BORDER_COLOR),this._isCustomBorderColor||(a.style.borderColor=n),this._isCustomBorderColor=!1,a.style.position="absolute",a.style.zIndex=2147483647,null!=s&&(Array.isArray(s)?s.forEach(function(t){a.appendChild(t)}):a.appendChild(s)),this.PostElement(a,t,e,!0,r)},it.prototype.PostElement=function(t,e,i,n,r){if(t.style["pointer-events"]=n?"none":"auto",t.style.width=null,t.style.height=null,t.style.left="0px",t.style.top="0px",r){var o=this._getOffsets(t);this.positionTip(e+o.x,i+o.y,e,i)}else this.positionTip(e,i,e,i);t.style.visibility="visible";var s=this._context.getTooltipAttachedCallback();s&&s(t)},it.prototype.hideTooltip=function(){this.clearTooltip(),this._tooltipDisplayed=!1,this._timerIsRunning=!1;var t=document.getElementById(this._domElementId);t&&(t.style.visibility="hidden",t.style.overflow=null,t.style.width="0px",t.style.height="0px",r.isRightToLeft(this._context)?t.style.left=t.style.right:t.style.left="0px",t.style.top="0px","undefined"!=typeof $&&this._bCleanupChildren&&$(t).children().remove())},it.prototype.releaseTooltipResources=function(){var t=document.getElementById(this._domElementId);t&&this._getTooltipContainer().removeChild(t)},it.prototype.getTooltipElem=function(){var t=document.getElementById(this._domElementId);return t||(t=this.InitializeTooltipElem()),t},it.prototype._getTooltipContainer=function(){if(nt)return nt;if(nt=document.getElementById("_dvtTooltip_shared_container"),!nt){var t=document.createElement("div");t.id="_dvtTooltip_shared_container",document.body.appendChild(t),nt=t}return nt},it.prototype.InitializeTooltipElem=function(){var t=document.createElement("div");return t.id=this._domElementId,t.style.visibility="hidden",this._getTooltipContainer().appendChild(t),this.InitContent(t),t},it.prototype.InitContent=function(t){},it.prototype.showTooltip=function(t,e,i,n,o,s){i&&0!=i.length&&(this._x=t,this._y=e,this._text=i,this._trackMouse=o,this._timerIsRunning||(s||(s=it._BORDER_COLOR),this.getTooltipElem().style.borderColor=s,r.isTouchDevice()||this._tooltipDisplayed&&this._trackMouse?this._displayTooltip(this._x,this._y,this._text,this._borderColor):(this._timerIsRunning=!0,this._showTimerId=window.setTimeout(this._handleShowTimer.bind(this),it._SHOW_DELAY))))},it.prototype.clearTooltip=function(){this._showTimerId&&(window.clearTimeout(this._showTimerId),this._showTimerId=void 0,this._x=void 0,this._y=void 0,this._text=void 0,this._trackMouse=void 0),this._hideTimerId&&(window.clearTimeout(this._hideTimerId),this._hideTimerId=void 0)},it.prototype._handleShowTimer=function(t){this._timerIsRunning=!1,this._displayTooltip(this._x,this._y,this._text,this._borderColor),this._tooltipDisplayed=!0},it.prototype._displayTooltip=function(t,e,i,n){this._isTooltip=!0,this._showTextAtPosition(t,e,i,n,!0,"oj-dvt-tooltip")},it.prototype._getOffsets=function(t){var e=this.getTooltipBounds(t);if(r.isTouchDevice())return new n(0-e.w/2,-30-e.h);var i=-8-e.h,o=8;return this._isTooltip&&(i=22,o=0),r.isRightToLeft(this._context)&&(o=-o-e.w),new n(o,i)},it.prototype.getTooltipBounds=function(){var t=this.getTooltipElem();return t.style.height="auto",new m(parseInt(t.style.left),parseInt(t.style.top),t.offsetWidth,t.offsetHeight)},it.prototype.positionTip=function(t,e){var i=this.getTooltipElem(),n=this.getTooltipBounds(),r=n.w,o=n.h,s=new m(window.pageXOffset+it._VIEWPORT_BUFFER,window.pageYOffset+it._VIEWPORT_BUFFER,window.innerWidth-2*it._VIEWPORT_BUFFER,window.innerHeight-2*it._VIEWPORT_BUFFER);r>s.w-2*it._VIEWPORT_BUFFER&&(r=s.w-2*it._VIEWPORT_BUFFER,i.style.width=r+"px");var a=t;a=Math.max(a,s.x),a=Math.min(a,s.x+s.w-r),Math.abs(s.x)>it._VIEWPORT_BUFFER&&(i.style.width=Math.min(i.clientWidth,s.x+s.w-a)+"px",e+=o-i.offsetHeight,o=i.offsetHeight,i.style.overflow="hidden");var h=e;h=Math.min(h,s.y+s.h-o),h=Math.max(h,s.y),i.style.left=a+"px",i.style.top=h+"px"},it.prototype.getCustomTooltip=function(t,e){for(var i=this.getTooltipElem();i.hasChildNodes();)i.removeChild(i.firstChild);e.parentElement=i,i.className="",i.style.borderColor="";var n=t(e=this._context.fixRendererContext(e));return i.className&&(this._isCustomClassName=!0),i.style.borderColor&&(this._isCustomBorderColor=!0),this._bCleanupChildren=null!=e._templateCleanup,!(n||!i.hasChildNodes())||n},it._restoreTag=function(t,e){var i=new RegExp("&lt;(/?)("+e+")(?=[\\s&/])([^&]*)(/?)&gt;","g");return t.replace(i,"<$1"+e+"$3$4>")},it.createElement=function(t,e,i,n){var r=document.createElement(t);if(e&&e.applyStylesToElement(r),n&&r.classList.add.apply(r.classList,n),null!=i)if(Array.isArray(i))for(var o=0;o<i.length;o++)r.appendChild(i[o]);else r.appendChild(document.createTextNode(i));return r};const rt={};i.createSubclass(rt,i),rt.getHoverBorderColor=function(t){return T.adjustHSL(t,0,0,.15)},rt.createSelectingStroke=function(t){return new z(rt.getHoverBorderColor(t),1,2,!1,null,{miterLimit:1})},rt.getSelectingCursor=function(){return"pointer"};const ot=function(t,e,i){this.Init(t,e,i)};i.createSubclass(ot,J),ot.prototype.Init=function(t,e,i){ot.superclass.Init.call(this,t,e,i,!0),this._bSelectable=!1,this.IsSelected=!1,this.InnerShape=null,this.HoverInnerStroke=null,this.HoverOuterStroke=null,this.SelectedInnerStroke=null,this.SelectedOuterStroke=null,this.SelectedHoverInnerStroke=null,this.SelectedHoverOuterStroke=null,this.OriginalStroke=null,this._isOriginalStrokeSet=!1,this.IsShowingHoverEffect=!1,this._feedbackClassName=null},ot.prototype.setHollow=function(t,e){if(this._bHollow)this.setFill(this._origFill),this.setStroke(this._origStroke),this._bHollow=!1;else{this._origFill=this.GetProperty("fill"),this._origStroke=this.getStroke();var i,n=K.invisibleFill();i=t?new z(T.getRGB(t),T.getAlpha(t),e):new z(this.GetProperty("fill").getColor(),this.GetProperty("fill").getAlpha(),e),this.setFill(n),this.setStroke(i),this._bHollow=!0}},ot.prototype.isHollow=function(){return this._bHollow},ot.prototype.destroy=function(){ot.superclass.destroy.call(this),this.setFill(null),this.setStroke(null)},ot.prototype.getDimensionsWithStroke=function(){var t=this.GetElemDimensionsWithStroke(),e=ot.superclass.getDimensionsWithStroke.call(this);return t&&e?t=t.getUnion(e):e&&(t=e),t},ot.prototype.GetDimensionsWithStroke=function(t){var e=this.GetElemDimensionsWithStroke();return t&&t!==this?this.ConvertCoordSpaceRect(e,t):e},ot.prototype.GetElemDimensionsWithStroke=function(){var t=this.getDimensionsSelf&&this.getNumChildren()-this._getInnerShapeCount()==0?this.getDimensionsSelf():ot.superclass.getDimensions.call(this),e=this.getStroke();if(t&&e){var i=e.getWidth();if(i){var n=.5*i;t.x-=n,t.y-=n,t.w+=i,t.h+=i}}return t},ot.prototype.UpdateSelectionEffect=function(){var t;(this.isSelected()||this.isHoverEffectShown())&&(this.InnerShape&&(t=this.InnerShape.getStroke(),this.removeChild(this.InnerShape)),this.InnerShape=this.copyShape(),this.InnerShape._setOuterShape(this),this.InnerShape.setMouseEnabled(!1),this.InnerShape.setFill(this.getFill()),this.InnerShape.setStroke(t||this.getStroke()),this.InnerShape.setStyle(this.getStyle()).setClassName(this.getClassName()),this._feedbackClassName&&(this.InnerShape.removeClassName("oj-dvt-default-border-width"),this.InnerShape.removeClassName("oj-dvt-default-border-color"),this.InnerShape.removeClassName(this._feedbackClassName),this.InnerShape.addClassName(this._feedbackClassName+"-inner-shape")),this.InnerShape.setMouseEnabled(!1),this.InnerShape.setCursor(rt.getSelectingCursor()),this.AddChildAt(this.InnerShape,0))},ot.prototype._setOuterShape=function(t){this._outerShape=t},ot.prototype.GetHoverSelectionInnerStroke=function(){var t;return this.InnerShape&&(this.isSelected()?t=this.isHoverEffectShown()?this.SelectedHoverInnerStroke:this.SelectedInnerStroke:this.isHoverEffectShown()&&(t=this.HoverInnerStroke)),t},ot.prototype.GetHoverSelectionOuterStroke=function(){var t;return this._outerShape&&(this._outerShape.isSelected()?t=this._outerShape.isHoverEffectShown()?this._outerShape.SelectedHoverOuterStroke:this._outerShape.SelectedOuterStroke:this._outerShape.isHoverEffectShown()&&(t=this._outerShape.HoverOuterStroke)),t},ot.prototype.setHoverStroke=function(t,e){return this.HoverInnerStroke=t,this.HoverOuterStroke=e,this},ot.prototype.setSelectedStroke=function(t,e){return this.SelectedInnerStroke=t,this.SelectedOuterStroke=e,this},ot.prototype.setSelectedHoverStroke=function(t,e){return this.SelectedHoverInnerStroke=t,this.SelectedHoverOuterStroke=e,this},ot.prototype.setSelectable=function(t){this._bSelectable=t,this._bSelectable?this.setCursor(rt.getSelectingCursor()):this.setCursor(null)},ot.prototype.isSelectable=function(){return this._bSelectable},ot.prototype.isSelected=function(){return this.IsSelected},ot.prototype.setSelected=function(t){this.IsSelected!=t&&(this._isOriginalStrokeSet||(this._isOriginalStrokeSet=!0,this.OriginalStroke=this.getStroke()),this.IsSelected=t,this.isSelected()?(this.UpdateSelectionEffect(),this._feedbackClassName?(this.addClassName("oj-selected"),this.InnerShape.addClassName("oj-selected")):this.isHoverEffectShown()?(this.CreateSelectedHoverStrokes(),this.InnerShape.setStroke(this.SelectedHoverInnerStroke),this.setStroke(this.SelectedHoverOuterStroke)):(this.InnerShape.setStroke(this.SelectedInnerStroke),this.setStroke(this.SelectedOuterStroke))):(this._feedbackClassName&&(this.removeClassName("oj-selected"),this.InnerShape.removeClassName("oj-selected")),this.IsShowingHoverEffect?this._feedbackClassName||(this.InnerShape.setStroke(this.HoverInnerStroke),this.setStroke(this.HoverOuterStroke)):(this.removeChild(this.InnerShape),this.setStroke(this.OriginalStroke))))},ot.prototype.setFeedbackClassName=function(t){this.addClassName(t),this._feedbackClassName=t},ot.prototype.showHoverEffect=function(){this.IsShowingHoverEffect||(this.IsShowingHoverEffect=!0,this._isOriginalStrokeSet||(this._isOriginalStrokeSet=!0,this.OriginalStroke=this.getStroke()),this.UpdateSelectionEffect(),this._feedbackClassName?(this.addClassName("oj-hover"),this.InnerShape.addClassName("oj-hover")):this.isSelected()?(this.CreateSelectedHoverStrokes(),this.InnerShape.setStroke(this.SelectedHoverInnerStroke),this.setStroke(this.SelectedHoverOuterStroke)):(this.InnerShape.setStroke(this.HoverInnerStroke),this.setStroke(this.HoverOuterStroke)))},ot.prototype.CreateSelectedHoverStrokes=function(){this.SelectedHoverInnerStroke||(this.SelectedHoverInnerStroke=this.HoverInnerStroke),this.SelectedHoverOuterStroke||(this.SelectedHoverOuterStroke=new z(this.SelectedOuterStroke.getColor(),this.SelectedOuterStroke.getAlpha(),this.SelectedOuterStroke.getWidth()+(this.HoverInnerStroke.getWidth()-this.SelectedInnerStroke.getWidth())))},ot.prototype.hideHoverEffect=function(){this.IsShowingHoverEffect&&(this.IsShowingHoverEffect=!1,this._feedbackClassName&&(this.removeClassName("oj-hover"),this.InnerShape.removeClassName("oj-hover")),this.isSelected()?this._feedbackClassName||(this.InnerShape.setStroke(this.SelectedInnerStroke),this.setStroke(this.SelectedOuterStroke)):(this.removeChild(this.InnerShape),this.setStroke(this.OriginalStroke)))},ot.prototype.isHoverEffectShown=function(){return this.IsShowingHoverEffect},ot.prototype.addChildAt=function(t,e){ot.superclass.addChildAt.call(this,t,e+this._getInnerShapeCount())},ot.prototype.getChildAt=function(t,e){return ot.superclass.getChildAt.call(this,t,e+this._getInnerShapeCount())},ot.prototype.getChildIndex=function(t){return ot.superclass.getChildIndex.call(this,t)-this._getInnerShapeCount()},ot.prototype.removeChildAt=function(t){ot.superclass.removeChildAt.call(this,t+this._getInnerShapeCount())},ot.prototype.getDimensions=function(t){return this.getDimensionsSelf&&this.getNumChildren()-this._getInnerShapeCount()==0?this.getDimensionsSelf(t):ot.superclass.getDimensions.call(this,t)},ot.prototype._getInnerShapeCount=function(){return this.isSelected()||this.isHoverEffectShown()?1:0},ot.prototype.SvgPropertyChanged=function(t){this.UpdateSelectionEffect()},ot.prototype.copyShape=function(){return null};const st={};i.createSubclass(st,i),st._cachedTextWidth={},st._cachedRepTextDimensions={},st._canvasCtx=null,st._wordSpacing,st._letterSpacing,st._fontVariantNumeric,st.EMPTY_TEXT_BUFFER=2,st.ELLIPSIS="…",st.REPRESENTATIVE_TEXT="MW",st.V_ALIGN_TOP="top",st.V_ALIGN_MIDDLE="middle",st.V_ALIGN_CENTRAL="central",st.V_ALIGN_BOTTOM="bottom",st.V_ALIGN_AUTO="auto",st._rep_text_constructor=null,st.getMaxTextDimensions=function(t){for(var e=0,i=0,n=0;n<t.length;n++)if(null!=t[n]){var r=t[n].getDimensions();e=Math.max(e,r.w),i=Math.max(i,r.h)}return new h(e,i)},st.getMaxTextStringWidth=function(t,e,i){for(var n=0,r=Array.isArray(i),o=0;o<e.length;o++)if(null!=e[o]&&0!=e[o].length){var s=i?r?i[o]:i:null,a=st.getTextStringWidth(t,e[o],s);a>n&&(n=a)}return n},st.getTextStringDimensions=function(t,e,i){var n=st._getRepresentativeDimensions(t,i);return new m(0,n.y,st.getTextStringWidth(t,e,i),n.h)},st.getTextStringWidth=function(t,e,i){if(null==e||0==e.length)return 0;var n=t.letterSpacing||"normal",o=t.wordSpacing||"normal",s=t.fontVariantNumeric||"normal",a=st._createCacheKey(t,i,e),h=st._cachedTextWidth[a];if(null!=h)return h;var l,u=st._isNormalSpacing(n),c=st._isNormalSpacing(o);if(u&&c&&"normal"===s){var _=st._wordSpacing||st._letterSpacing||st._fontVariantNumeric;st._storeCanvasContext(_),st._setSpacing(null,null,null),l=st._getCanvasTextWidth(t,e,i)}else if("chrome"===r.browser)st._letterSpacing==n&&st._wordSpacing==o&&st._fontVariantNumeric==s||(st._clearCanvasContext(),st._setSpacing(o,n,s)),st._storeCanvasContext(),st._attachCanvas(t),l=st._getCanvasTextWidth(t,e,i);else if("safari"===r.browser&&u&&c)st._fontVariantNumeric!=s&&(st._clearCanvasContext(),st._setSpacing(o,n,s)),st._storeCanvasContext(),st._attachCanvas(t),l=st._getCanvasTextWidth(t,e,i);else{var p=new st._rep_text_constructor(t,e);p.setCSSStyle(i);var d=p.getCtx().getStage();d.addChild(p),l=p.GetSvgDimensions().w,d.removeChild(p)}return st._cachedTextWidth[a]=l,l},st._isNormalSpacing=function(t){return"normal"===t||"0px"===t},st._setSpacing=function(t,e,i){st._wordSpacing=t,st._letterSpacing=e,st._fontVariantNumeric=i},st._storeCanvasContext=function(t){var e=st._canvasCtx?st._canvasCtx.canvas:null;e?t&&(st._canvasCtx=st._canvasCtx.canvas.getContext("2d")):(e=document.createElement("CANVAS"),st._canvasCtx=e.getContext("2d"))},st._clearCanvasContext=function(){if(st._canvasCtx){var t=st._canvasCtx.canvas;t.parentNode&&t.parentNode.removeChild(t),st._canvasCtx=null}},st._attachCanvas=function(t){var e=st._canvasCtx.canvas;e.parentNode||(e.style.display="none",t.getContainer().appendChild(e),st._canvasCtx=e.getContext("2d"))},st._createCacheKey=function(t,e,i){return(i||"")+(null!=e?e.hashCodeForTextMeasurement():"")+t.letterSpacing+t.wordSpacing+t.fontVariantNumeric},st.getTextStringHeight=function(t,e){return st._getRepresentativeDimensions(t,e).h},st.fitText=function(t,e,i,n,r,o){var s=t.getTextString();if(!t.hasBackground()&&!t.isMultiline()){var a=st.getTextStringDimensions(t.getCtx(),s,t.getCSSStyle());if(a.h>i)return o||t.removeFromParent(),!1;if(a.w<=e)return n.addChild(t),!0}if(n.addChild(t),r="number"!=typeof r||null==r?1:r,t.isMultiline())return t.__fitText(e,i,r);if(t.isMultiline())throw t.setMaxWidth(e,r),new Error("TextUtils.fitText called with a non-text class");return st._truncateOutputText(t,e,r),""==t.getTextString()?(o||n.removeChild(t),t.setTextString(s),!1):(t.getTextString()!=s&&t.setUntruncatedTextString(s),!0)},st.centerTextVertically=function(t,e){"ie"===r.browser||"edge"===r.browser?(t.setY(e),t.alignMiddle()):t.setY(e-t.getDimensions().h/2)},st._truncateOutputText=function(t,e,i){if(e<=0)t.setTextString("");else{var n=t.getDimensions();if(!(n.w<=e)){var r=t.getTextString(),o=r.length,s=n.w/st._getTextLength(r),a=Math.max(Math.floor(e/s)-2,i),h=r.substring(0,a)+st.ELLIPSIS;t.setTextString(h);for(var l=h,u=n=t.getDimensions();n.w<e&&!(a>=r.length);){var c=e-n.w,_=Math.min(o-a,Math.max(Math.floor(c/s),1));if(a+=_,h=r.substring(0,a)+st.ELLIPSIS,t.setTextString(h),n=t.getDimensions(),1==_&&n.w>e){t.setTextString(l),n=u;break}l=h,u=n}for(;n.w>e;){if(a<=i){t.setTextString("");break}a-=1,h=r.substring(0,a)+st.ELLIPSIS,t.setTextString(h),n=t.getDimensions()}}}},st._getTextLength=function(t){return(t=t.replace(/[\u200A\u200B\u200C\u200D\u200E\u200F\uFEFF]/g,"")).length},st._getRepresentativeDimensions=function(t,e){var i=st._createCacheKey(t,e),n=st._cachedRepTextDimensions[i];if(null==n){var r=new st._rep_text_constructor(t,st.REPRESENTATIVE_TEXT);r.alignAuto(),r.setCSSStyle(e);var o=r.getCtx().getStage();o.addChild(r);var s=r.GetSvgDimensions();o.removeChild(r),n={x:s.x,y:s.y,w:.5*s.w,h:s.h},st._cachedRepTextDimensions[i]=n}return n},st.setRepresentativeTextConstructor=function(t){st._rep_text_constructor=t},st.getBaselineTranslation=function(t){var e=t.getVertAlignment();if(e!=st.V_ALIGN_AUTO){var i=st._getRepresentativeDimensions(t.getCtx(),t.getCSSStyle());if(e==st.V_ALIGN_TOP)return-i.y;if(e==st.V_ALIGN_MIDDLE)return-i.y-i.h/2;if(e==st.V_ALIGN_CENTRAL)return-i.y/2;if(e==st.V_ALIGN_BOTTOM)return-i.y-i.h}return 0},st._getCanvasTextWidth=function(t,e,i){var n=(i?i.getStyle("font-style"):null)||"normal",r=(i?i.getStyle("font-variant"):null)||"normal",o=(i?i.getStyle("font-weight"):null)||"normal",s=(i?i.getStyle("font-family"):null)||t.getDefaultFontFamily()||"",a=(i?i.getFontSize():null)||t.getDefaultFontSize()||"12px";isNaN(a)||(a+="px");var h=n+" "+r+" "+o+" "+a+" "+s;return st._configureCanvas(t,h),st._canvasCtx.measureText(e).width},st._configureCanvas=function(t,e){"ie"!==r.browser&&"edge"!==r.browser||(e=e.replace(/-apple-system(-\w+)*,?/g,""),st._attachCanvas(t)),st._canvasCtx.font=e},st.clearCaches=function(){st._cachedTextWidth={},st._cachedRepTextDimensions={}},st.getOptimalFontSize=function(t,e,i,n){i=i?i.clone():new j;for(var r=Math.max(Math.round(Math.min(n.w/e.length,n.h/2)),9);r<51;r+=1){i.setFontSize("font-size",r+"px",t);var o=st.getTextStringDimensions(t,e,i);if(o.w>n.w||o.h>n.h)return Math.min(r-1,50)+"px"}return"50px"};const at=function(t,e,i,n,r){this.Init(t,e,i,n,r)};var ht;st.setRepresentativeTextConstructor(at),i.createSubclass(at,ot),at.ELLIPSIS=st.ELLIPSIS,at.REPRESENTATIVE_TEXT=st.REPRESENTATIVE_TEXT,at.BIDI_ZERO_WIDTH="​",at.H_ALIGN_LEFT="left",at.H_ALIGN_CENTER="center",at.H_ALIGN_RIGHT="right",at.TEXT_ANCHOR="text-anchor",at.V_ALIGN_TOP=st.V_ALIGN_TOP,at.V_ALIGN_MIDDLE=st.V_ALIGN_MIDDLE,at.V_ALIGN_CENTRAL=st.V_ALIGN_CENTRAL,at.V_ALIGN_BOTTOM=st.V_ALIGN_BOTTOM,at.V_ALIGN_AUTO=st.V_ALIGN_AUTO,at.prototype.Init=function(t,e,i,n,o){at.superclass.Init.call(this,t,"text",o),this._x=null!=i?i:0,this._baseline=!1,!r.isRightToLeft(t)||"ie"!==r.browser&&"edge"!==r.browser||u.setAttrNullNS(this.getElem(),"unicode-bidi","embed"),this.alignLeft(),this.alignTop(),this.setTextString(e),this.setX(i),this.setY(n),u.removeAttrNullNS(this.getElem(),"fill"),this.setAriaProperty("hidden","true")},at.prototype.getTextString=function(){return this._textString},at.prototype.setTextString=function(t){t=null!=t?String(t).trim():"",!this._needsTextAnchorAdjustment()||"ie"!==r.browser&&"edge"!==r.browser||t.charAt(0)==at.BIDI_ZERO_WIDTH||(t=at.BIDI_ZERO_WIDTH+t),this._textString=t;var e=this.getElem().firstChild;return null!==e?e.nodeValue=t:(e=document.createTextNode(t),u.appendChildElem(this.getElem(),e)),"ie"!==r.browser&&"edge"!==r.browser||this.setX(this._x),this},at.prototype.isTruncated=function(){return null!=this.getUntruncatedTextString()},at.prototype.getUntruncatedTextString=function(){return this._untruncatedTextString},at.prototype.setUntruncatedTextString=function(t){t!=this.getTextString()&&(this._untruncatedTextString=t)},at.prototype.getX=function(){return("ie"===r.browser||"edge"===r.browser?this._x:this.GetProperty("x"))||0},at.prototype.setX=function(t){return this._x=null!=t?t:0,"ie"===r.browser||"edge"===r.browser?this.SetSvgProperty("x",this._x+this._getIEAlignmentOffset(),0):this.SetSvgProperty("x",t,0)},at.prototype._getIEAlignmentOffset=function(){var t=this.getHorizAlignment(),e=r.isRightToLeft(this.getCtx());return t==at.H_ALIGN_LEFT?e?st.getTextStringWidth(this.getCtx(),this.getTextString(),this.getCSSStyle()):0:t==at.H_ALIGN_CENTER?e?st.getTextStringWidth(this.getCtx(),this.getTextString(),this.getCSSStyle())/2:st.getTextStringWidth(this.getCtx(),this.getTextString(),this.getCSSStyle())/2*-1:t==at.H_ALIGN_RIGHT?e?0:-1*st.getTextStringWidth(this.getCtx(),this.getTextString(),this.getCSSStyle()):0},at.prototype.getY=function(){var t=this.GetProperty("y");return t||0},at.prototype.setY=function(t){return this.SetSvgProperty("y",t,0)},at.prototype.setFontSize=function(t){var e=this.getCSSStyle();(e=e?e.clone():new j).setFontSize(j.FONT_SIZE,String(t),this.getCtx()),this.setCSSStyle(e)},at.prototype.getHorizAlignment=function(){return this._horizAlign},at.prototype.setHorizAlignment=function(t){t==at.H_ALIGN_LEFT?this.alignLeft():t==at.H_ALIGN_CENTER?this.alignCenter():t==at.H_ALIGN_RIGHT&&this.alignRight()},at.prototype.getVertAlignment=function(){return this._vertAlign},at.prototype.setVertAlignment=function(t){t==at.V_ALIGN_TOP?this.alignTop():t==at.V_ALIGN_MIDDLE?this.alignMiddle():t==at.V_ALIGN_CENTRAL?this.alignCentral():t==at.V_ALIGN_BOTTOM?this.alignBottom():t==at.V_ALIGN_AUTO&&this.alignAuto()},at.prototype.alignLeft=function(){if(this._horizAlign!=at.H_ALIGN_LEFT)if(this._horizAlign=at.H_ALIGN_LEFT,"ie"===r.browser||"edge"===r.browser)this.setX(this._x);else{var t=this._needsTextAnchorAdjustment();u.setAttrNullNS(this.getElem(),at.TEXT_ANCHOR,t?"end":"start","start")}},at.prototype.alignCenter=function(){this._horizAlign!=at.H_ALIGN_CENTER&&(this._horizAlign=at.H_ALIGN_CENTER,"ie"===r.browser||"edge"===r.browser?this.setX(this._x):u.setAttrNullNS(this.getElem(),at.TEXT_ANCHOR,"middle","start"))},at.prototype.alignRight=function(){if(this._horizAlign!=at.H_ALIGN_RIGHT)if(this._horizAlign=at.H_ALIGN_RIGHT,"ie"===r.browser||"edge"===r.browser)this.setX(this._x);else{var t=this._needsTextAnchorAdjustment();u.setAttrNullNS(this.getElem(),at.TEXT_ANCHOR,t?"start":"end","start")}},at.prototype.alignTop=function(){this._vertAlign!=at.V_ALIGN_TOP&&(this._vertAlign==at.V_ALIGN_BOTTOM&&"safari"===r.browser&&this._setBaseline(!1),this._vertAlign=at.V_ALIGN_TOP,"ie"===r.browser||"edge"===r.browser?this._setBaseline(!0):this.SetDominantBaselineAttr("text-before-edge"))},at.prototype.alignMiddle=function(){this._vertAlign!=at.V_ALIGN_MIDDLE&&(this._vertAlign==at.V_ALIGN_BOTTOM&&"safari"===r.browser&&this._setBaseline(!1),this._vertAlign=at.V_ALIGN_MIDDLE,"ie"===r.browser||"edge"===r.browser?this._setBaseline(!0):this.SetDominantBaselineAttr("middle"))},at.prototype.alignCentral=function(){this._vertAlign!=at.V_ALIGN_CENTRAL&&(this._vertAlign==at.V_ALIGN_BOTTOM&&"safari"===r.browser&&this._setBaseline(!1),this._vertAlign=at.V_ALIGN_CENTRAL,"ie"===r.browser||"edge"===r.browser?this._setBaseline(!0):this.SetDominantBaselineAttr("central"))},at.prototype.alignBottom=function(){this._vertAlign!=at.V_ALIGN_BOTTOM&&(this._vertAlign=at.V_ALIGN_BOTTOM,"ie"===r.browser||"edge"===r.browser?this._setBaseline(!0):"safari"===r.browser?(this._setBaseline(!0),this.SetDominantBaselineAttr(null)):this.SetDominantBaselineAttr("text-after-edge"))},at.prototype.alignAuto=function(){this._vertAlign!=at.V_ALIGN_AUTO&&(this._vertAlign==at.V_ALIGN_BOTTOM&&"safari"===r.browser&&this._setBaseline(!1),this._vertAlign=at.V_ALIGN_AUTO,"ie"===r.browser||"edge"===r.browser?this._setBaseline(!1):this.SetDominantBaselineAttr(null))},at.prototype._setBaseline=function(t){this._baseline=t,this.setMatrix(this.getMatrix())},at.prototype.SetDominantBaselineAttr=function(t){t?u.setAttrNullNS(this.getElem(),"dominant-baseline",t):u.removeAttrNullNS(this.getElem(),"dominant-baseline")},at.prototype.setCSSStyle=function(t){at.superclass.setCSSStyle.call(this,t);var e=this.getOuterElem();if(t){var i=t.getStyle("color"),n=T.fixColorForPlatform(i);n&&n.color&&(u.setAttrNullNS(e,"fill",n.color),null!=n.alpha&&u.setAttrNullNS(e,"fill-opacity",n.alpha,1));const o="font-family";(i=t.getStyle(o))&&!this.getCtx().isDefaultFontFamily(i)?u.setAttrNullNS(e,o,i):u.removeAttrNullNS(e,o),(i=t.getStyle("font-size"))&&i!=this.getCtx().getDefaultFontSize()?(u.setAttrNullNS(e,"font-size",i),"ie"!==r.browser&&"edge"!==r.browser&&"safari"!==r.browser||this.setMatrix(this.getMatrix())):u.removeAttrNullNS(e,"font-size"),(i=t.getStyle("font-style"))&&u.setAttrNullNS(e,"font-style",i);const s="font-weight";(i=t.getStyle(s))&&i!=this.getCtx().getDefaultFontWeight()?u.setAttrNullNS(e,s,i):u.removeAttrNullNS(e,s),(i=t.getStyle("text-decoration"))&&u.setAttrNullNS(e,"text-decoration",i),(i=t.getStyle("cursor"))&&u.setAttrNullNS(e,"cursor",i),"ie"!==r.browser&&"edge"!==r.browser||this.setX(this._x)}},at.prototype._getBaselineTranslation=function(){if(this._baseline){if(this._textString&&!this._isRepresentativeText())return st.getBaselineTranslation(this);var t=this.getVertAlignment();if(t!=at.V_ALIGN_AUTO){var e=u.getAttrNullNS(this.getElem(),"font-size");if(e||(e=u.getAttrNullNS(this.getOuterElem(),"font-size")),(!e||isNaN(e)&&-1==e.indexOf("px"))&&(e=this.getCtx().getDefaultFontSize()),e=parseFloat(e),t==at.V_ALIGN_TOP)return.8*e;if(t==at.V_ALIGN_MIDDLE)return.3*e;if(t==at.V_ALIGN_CENTRAL)return.4*e;if(t==at.V_ALIGN_BOTTOM)return-.2*e}}return 0},at.prototype._getBaselineAdjustedMatrix=function(t){this._baseline&&(t||(t=new l),t=new l(null,null,null,null,null,this._getBaselineTranslation()).concat(t));return t},at.prototype.setMatrix=function(t){"ie"!==r.browser&&"edge"!==r.browser&&"safari"!==r.browser||(this._matrixForIE=t,t=this._getBaselineAdjustedMatrix(t)),at.superclass.setMatrix.call(this,t)},at.prototype.getMatrix=function(){var t=null;return"ie"!==r.browser&&"edge"!==r.browser&&"safari"!==r.browser||(t=this._matrixForIE),t||(t=at.superclass.getMatrix.call(this)),t},at.prototype._isRepresentativeText=function(){return this._textString==at.REPRESENTATIVE_TEXT||this._textString==at.BIDI_ZERO_WIDTH||this._textString==at.BIDI_ZERO_WIDTH+at.REPRESENTATIVE_TEXT},at.prototype.GetSvgDimensions=function(){var t=at.superclass.GetSvgDimensions.call(this);return t&&(t.y+=this._getBaselineTranslation(),this._isRepresentativeText()||(t.h=st.getTextStringHeight(this.getCtx(),this.getCSSStyle()))),t},at.prototype.UpdateSelectionEffect=function(){},at.prototype.getDimensions=function(t){var e=this.getHorizAlignment(),i=this.getVertAlignment(),n=st.getTextStringDimensions(this.getCtx(),this.getTextString(),this.getCSSStyle());return n.x=this.getX(),e===at.H_ALIGN_RIGHT?n.x-=n.w:e===at.H_ALIGN_CENTER&&(n.x-=n.w/2),i===at.V_ALIGN_TOP?n.y=this.getY():i===at.V_ALIGN_BOTTOM?n.y=this.getY()-n.h:i===at.V_ALIGN_MIDDLE?n.y=this.getY()-n.h/2:i===at.V_ALIGN_CENTRAL?n.y=this.getY()-.4*n.h:i===at.V_ALIGN_AUTO&&(n.y+=this.getY()),t&&t!==this?this.ConvertCoordSpaceRect(n,t):n},at.prototype.copyShape=function(){var t=new at(this.getCtx(),this.getTextString(),this.getX(),this.getY());return t.setCSSStyle(this.getCSSStyle()),t.setHorizAlignment(this.getHorizAlignment()),t.setVertAlignment(this.getVertAlignment()),t},at.prototype._needsTextAnchorAdjustment=function(){return r.isRightToLeft(this.getCtx())},at.createIcon=(ht={},function(t,e){var i=e.style,n=e.size,o=e.pos||{x:n/2,y:n/2},s=new at(t,i.character);if(s.setClassName("oj-fwk-icon oj-dvt-icon"),s.getElem().style.fontSize=n+"px","ie"===r.browser||"edge"===r.browser){s.SetSvgProperty("x",0,0);var a="ie"===r.browser?.8*n:function(t,e,i){if(!ht[e]){var n=new at(t,i);n.setClassName("oj-fwk-icon oj-dvt-icon"),n.getElem().style.fontSize=e+"px",n.alignAuto();var r=t.getStage();r.addChild(n);var o=n.GetSvgDimensions();r.removeChild(n),ht[e]=-o.y}return ht[e]}(t,n,i.character),h=r.isRightToLeft(t),u=new l(1,0,0,1,h?n/2:-n/2,a-n/2);at.superclass.setMatrix.call(s,u.concat(i.transform).translate(o.x,o.y))}else s.alignCenter(),s.alignCentral(),s.setMatrix(i.transform.translate(o.x,o.y));return s}),at.prototype.isMultiline=function(){return!1},at.prototype.hasBackground=function(){return!1};const lt=function(t,e,i,n,r,o){this.Init(t,e,i,n,r,o)};i.createSubclass(lt,ot),lt._cssAttrs=["background-color","border-color","border-width"],lt.prototype.Init=function(t,e,i,n,r,o){lt.superclass.Init.call(this,t,"rect",o),this._strokeAlignment="center",this.setX(e).setY(i).setWidth(n).setHeight(r)},Q.defineProps(lt,{x:{value:0},y:{value:0},width:{value:0},height:{value:0},rx:{},ry:{}}),lt.prototype.setCSSStyle=function(t){lt.superclass.setCSSStyle.call(this,t);var e=this._elem;if(t){var i=t.getStyle("background-color");if(i&&u.setAttrNullNS(e,"fill",i),(i=t.getStyle("border-color"))&&u.setAttrNullNS(e,"stroke",i),(i=t.getStyle("border-width"))&&u.setAttrNullNS(e,"stroke-width",i),i=t.getStyle("border-radius")){var n=i.trim().split(" ");n.length>0&&n[0]&&this.setRx(n[0]),n.length>1&&n[1]&&this.setRy(n[1])}}else u.removeAttrNullNS(this._elem,"style")},lt.prototype.SetSvgProperty=function(t,e,i){return e!==this.GetProperty(t)&&(this.SetProperty(t,e),this._setAttributeWithStroke(t,e,i),this.SvgPropertyChanged(t)),this},lt.prototype._setAttributeWithStroke=function(t,e,i){if(null!=e&&"center"!=this._strokeAlignment){var n=this._getStrokeOffset();switch(t){case"x":case"y":e-=n;break;case"width":case"height":e+=2*n}}u.setAttrNullNS(this._elem,t,e,i)},lt.prototype.setStrokeAlignment=function(t){this._strokeAlignment!=t&&(this._strokeAlignment=t,this._updateElemStrokeDimensions())},lt.prototype.getStrokeAlignment=function(){return this._strokeAlignment},lt.prototype._updateElemStrokeDimensions=function(){this._setAttributeWithStroke("x",this.getX(),0),this._setAttributeWithStroke("y",this.getY(),0),this._setAttributeWithStroke("width",this.getWidth()),this._setAttributeWithStroke("height",this.getHeight())},lt.prototype._getStrokeOffset=function(){var t=0,e=this.getStroke();if(e)if("outer"==this._strokeAlignment){t=e.getWidth()/2;var i=this.GetHoverSelectionInnerStroke();null!=i&&(t+=i.getWidth())}else if("inner"==this._strokeAlignment){t=-e.getWidth()/2;var n=this.GetHoverSelectionOuterStroke();null!=n&&(t-=n.getWidth())}return t},lt.prototype.setStroke=function(t){lt.superclass.setStroke.call(this,t),"center"!=this._strokeAlignment&&this._updateElemStrokeDimensions()},lt.prototype.GetElemDimensionsWithStroke=function(){var t=lt.superclass.GetElemDimensionsWithStroke.call(this);if(t&&"center"!=this._strokeAlignment){var e=this._getStrokeOffset();t.x-=e,t.y-=e,t.w+=2*e,t.h+=2*e}return t},lt.prototype.setCornerRadius=function(t,e){this.setRx(t).setRy(e)},lt.prototype.setRect=function(t,e,i,n){t instanceof m?this.setX(t.x).setY(t.y).setWidth(t.w).setHeight(t.h):this.setX(t).setY(e).setWidth(i).setHeight(n)},lt.prototype.copyShape=function(){var t=new lt(this.getCtx(),this.getX(),this.getY(),this.getWidth(),this.getHeight());return t.setRx(this.getRx()).setRy(this.getRy()),t.setStrokeAlignment(this.getStrokeAlignment()),t},lt.prototype.getDimensionsSelf=function(t){var e=new m(this.getX(),this.getY(),this.getWidth(),this.getHeight());return this.ConvertCoordSpaceRect(e,t)};const ut=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass(ut,i),ut.prototype.Init=function(t,e,i,n,r){this._interval=e,this._callback=i,this._callbackObj=n,this._repeatCount=r,this._bRunning=!1,this._numIterations=0},ut.prototype.start=function(){this._bRunning||(this._bRunning=!0,this.StartTimer())},ut.prototype.stop=function(){this._bRunning&&(this._bRunning=!1,this.StopTimer())},ut.prototype.reset=function(){this._bRunning&&this.stop(),this._numIterations=0},ut.prototype.isRunning=function(){return this._bRunning},ut.prototype.HandleTimer=function(){this._callback&&(this._callback.call(this._callbackObj),this._repeatCount&&(this._numIterations++,this._numIterations>=this._repeatCount&&this.stop()))},ut.prototype.setInterval=function(t){var e=t;e<0&&(e=0);var i=this._bRunning;i&&this.stop(),this._interval=e,i&&this.start()},ut.prototype.getInterval=function(){return this._interval},ut.prototype.StartTimer=function(){var t=this,e=this.HandleTimer;this._timerId=window.setInterval(function(){e.call(t)},this.getInterval())},ut.prototype.StopTimer=function(){this._timerId&&(window.clearInterval(this._timerId),this._timerId=null)};const ct=function(t,e){this._Init(t,e)};i.createSubclass(ct,J),ct.DEFAULT_BORDER_COLOR="gray",ct.DEFAULT_BACKGROUND_COLOR="#ffffff",ct.prototype._Init=function(t,e){this._context=t,ct.superclass.Init.call(this,t),this._tooltipText=null,this._tooltipBorderColor=null,this._menuFontSize=11,this._tooltipFill=new K(ct.DEFAULT_BACKGROUND_COLOR),this._fontSize=11},ct.prototype.getRootDisplayable=function(){return this},ct.prototype.UpdateTooltipSize=function(t,e){this._displayWidth=t,this._displayHeight=e},ct.prototype.getDisplayWidth=function(){return this._displayWidth},ct.prototype.getDisplayHeight=function(){return this._displayHeight},ct.prototype.clearContent=function(){this.clearMenuItems(),this.setTooltipBorderColor(null),this.setTooltipText(null)},ct.prototype.setTooltipBorderColor=function(t){this._tooltipBorderColor=t},ct.prototype.getTooltipBorderColor=function(){return this._tooltipBorderColor},ct.prototype.setTooltipText=function(t){this._tooltipText=t},ct.prototype.addMenuItem=function(t){this.getMenuItems().push(t)},ct.prototype.hasMenuItems=function(){var t=this.getMenuItems();return t&&t.length>0},ct.prototype.clearMenuItems=function(){this._menuItems&&(this._menuItems=[])},ct.prototype.getMenuItems=function(){return this._menuItems||(this._menuItems=new Array),this._menuItems},ct.prototype.containsMenuId=function(t){for(var e=this.getMenuItems(),i=0;i<e.length;i++){if(e[i].getId()==t)return!0}return!1},ct.prototype.Render=function(){var t=this.getRootDisplayable();if(t.removeChildren(),this.hasMenuItems()){var e=0,i=0;t.setAlpha(1);var n=new Array,r=new Array;e+=2.5;for(var o=this.getMenuItems(),s=0;s<o.length;s++){var a=o[s],h=new at(this._context,a.getText(),0,0,null);h.alignBottom(),h.setFontSize(this._menuFontSize),h._menu=a;var l=h.getDimensions();l.y=5+e;var u=l.w;r.push(l),i=Math.max(u+21+10,i),h.setY(l.y),e+=l.h,s<o.length-1&&(e+=5),n.push(h),h.alignLeft(),h.alignTop()}var c=i+8+2,_=5+(e+=2.5)+4+1;this.UpdateTooltipSize(c+2,_+2),t.setTranslate(1,1);var p=new lt(this._context,0,0,c,_);p.setSolidStroke("rgb(229,232,238)"),p.setFill(this._tooltipFill),t.addChildAt(p,0);for(s=0;s<n.length;s++){var d=n[s];t.addChild(d);u=r[s].w;if(d._menu){var g=new m(0,r[s].y-2.5,c,r[s].h+5),f=new lt(this._context,g.x,g.y,g.w,g.h);f.setInvisibleFill(),f._menu=d._menu,t.addChild(f)}d.setTranslateX(21)}}};var _t=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass(_t,i),_t.prototype.Init=function(t,e,i,n,r){this._context=t,this._id=e,this._text=i,this._listener=n,this._listenerObj=r},_t.prototype.getId=function(){return this._id},_t.prototype.getText=function(){return this._text},_t.prototype.FireActionTooltipItem=function(t){if(this._listenerObj&&this._listener){var e=new Object;e.target=t,e.menuItem=this._menuItem,this._menuItemTimer=new ut(this._context,1,this._handleMenuTimer,this),this._menuItemTimer.evt=e,this._menuItemTimer.start()}},_t.prototype._handleMenuTimer=function(){this._menuItemTimer&&this._menuItemTimer.stop(),this._listener.call(this._listenerObj,this._menuItemTimer.evt)};const pt=function(t,e){this.Init(t,e)};i.createSubclass(pt,it),pt.prototype.Init=function(t,e){this._storedContexts=new Object,pt.superclass.Init.call(this,t,e)},pt.prototype.InitContent=function(t){t.innerHTML="";var e=this._context.createContext(t,"DvtCustomTooltip");e.removeSizingSvg(),this._storedContexts[this._domElementId]=e},pt.prototype.GetStoredContext=function(){return this._storedContexts[this._domElementId]},pt.prototype.showRichElement=function(t,e,i,n){this.showRichElementAtPosition(t,e,i,n,!1)},pt.prototype.showRichElementAtPosition=function(t,e,i,n,r){var o=this.getTooltipElem();o.style.position="absolute",o.style.zIndex=2147483647;var s=this.GetStoredContext();if(s){var a=s.getStage();a.removeChildren();var h=i.getRootDisplayable();a.addChild(h),i&&i.Render&&i.Render();var l=a.getSVGRoot();u.setAttrNullNS(l,"width",i.getDisplayWidth()),u.setAttrNullNS(l,"height",i.getDisplayHeight()),this.PostElement(o,t,e,r,n)}},pt.prototype.hideTooltip=function(){pt.superclass.hideTooltip.call(this);var t=this.GetStoredContext();t&&t.getStage().removeChildren()};const dt=function(t,e,i,n,r){this.type=t,this.touch=e,this.target=i,this.relatedTarget=n,this._nativeEvent=r,this._isPropagationStopped=!1};dt.TOUCH_HOLD_START_TYPE="touchholdstart",dt.TOUCH_HOLD_MOVE_TYPE="touchholdmove",dt.TOUCH_HOLD_END_TYPE="touchholdend",dt.TOUCH_HOVER_START_TYPE="touchhoverstart",dt.TOUCH_HOVER_MOVE_TYPE="touchhovermove",dt.TOUCH_HOVER_END_TYPE="touchhoverend",dt.TOUCH_HOVER_OVER_TYPE="touchhoverover",dt.TOUCH_HOVER_OUT_TYPE="touchhoverout",dt.TOUCH_CLICK_TYPE="touchclick",dt.TOUCH_DOUBLE_CLICK_TYPE="touchdblclick",dt.prototype.preventDefault=function(){},dt.prototype.stopPropagation=function(){this._isPropagationStopped=!0},dt.prototype.isPropagationStopped=function(){return this._isPropagationStopped},dt.prototype.getNativeEvent=function(){return this._nativeEvent};const gt=function(){};i.createSubclass(gt,i),gt.elementFromPoint=function(t,e){for(var i=document.elementFromPoint(t,e);i;){if(i._obj)return i._obj;i=i.parentNode}return null},gt.elementFromTouch=function(t){return this.elementFromPoint(t.clientX,t.clientY)},gt.addDragListeners=function(t,e,i,n,o,s){var a,h=r.isTouchDevice(),l=t.getCtx(),u=document.body.style,c=function(t){t.stopPropagation()},_=function(t){e.call(o,t)&&(h?(document.addEventListener("touchmove",p,{capture:!0,passive:!1}),document.addEventListener("touchend",d,!0)):(document.addEventListener("mousemove",p,!0),document.addEventListener("mouseup",d,!0),a=!1,s&&document.addEventListener("click",c,!0)),gt._webkitUserSelect=u.webkitUserSelect,gt._mozUserSelect=u.MozUserSelect,u.webkitUserSelect="none",u.MozUserSelect="none")},p=function(t){a=!0;var e=k.newEvent(t,l);i.call(o,e)},d=function(t){h?(document.removeEventListener("touchmove",p,!0),document.removeEventListener("touchend",d,!0)):(document.removeEventListener("mousemove",p,!0),document.removeEventListener("mouseup",d,!0),"firefox"===r.browser&&a&&!s&&(document.addEventListener("click",c,{capture:!0,once:!0}),setTimeout(function(){document.removeEventListener("click",c,{capture:!0,once:!0})},0)),a=!1,s&&setTimeout(function(){document.removeEventListener("click",c,!0)},50)),u.webkitUserSelect=gt._webkitUserSelect,u.MozUserSelect=gt._mozUserSelect;var e=k.newEvent(t,l);n.call(o,e)};h?t.addEvtListener(L.TOUCHSTART,_):t.addEvtListener(F.MOUSEDOWN,_)},gt.createStaticCallback=function(t,e,i){return function(n){var r=k.newEvent(n,t);e.call(i,r)}},gt.disableMouseEvents=function(t){if(t.style&&(t.style.pointerEvents="none"),t.childNodes)for(var e=0;e<t.childNodes.length;e++)gt.disableMouseEvents(t.childNodes[e])};const ft=function(t,e,i){this.Init(t,e,i)};i.createSubclass(ft,i),ft.TOUCH_MODE="mode",ft.TOUCH_MODE_DEFAULT="defaultMode",ft.TOUCH_MODE_LONG_PRESS="longPressMode",ft.PREV_HOVER_OBJ="prevHoverObj",ft.HOVER_TOUCH_KEY="hoverTouch",ft.prototype.Init=function(t,e,i){this._context=e,this._id=t,this._eventManager=i,this._touchCount=0,this._touchHoldTimer=new ut(this._context,200,this._handleTouchHoldStartTimer,this),this._blockTouchHold=!1,this._touchMap=new Object,this._savedTouchInfo=new Array,this._addTouchHoldMoveEventListener(this._onTouchHoldHover,this),this._doubleTapTimer=new ut(this._context,600,this._handleDoubleTapTimer,this,1),this._dvtTouchEvent=null},ft.prototype.blockTouchHold=function(){this._stopTouchHoldTimer(),this._blockTouchHold=!0},ft.prototype.unblockTouchHold=function(){this._blockTouchHold=!1},ft.prototype._addTouchHoldMoveEventListener=function(t,e){this.addTouchEventListener(dt.TOUCH_HOLD_START_TYPE,t,e),this.addTouchEventListener(dt.TOUCH_HOLD_MOVE_TYPE,t,e),this.addTouchEventListener(dt.TOUCH_HOLD_END_TYPE,t,e)},ft.prototype._onTouchHoldHover=function(t){var e=t.type,i=t.touch,n=t.getNativeEvent(),r=this._touchMap[i.identifier],o=t.target;if(e==dt.TOUCH_HOLD_END_TYPE){var s=new dt(dt.TOUCH_HOVER_END_TYPE,i,o,null,n);s._isCancelEvent=this._isCancelEvent,null!=o&&this.FireListener(new dt(dt.TOUCH_HOVER_OUT_TYPE,i,o,null,n)),r[ft.PREV_HOVER_OBJ]=null,this.FireListener(s)}else e==dt.TOUCH_HOLD_START_TYPE?(r[ft.PREV_HOVER_OBJ]=null,null!=o&&this.FireListener(new dt(dt.TOUCH_HOVER_OVER_TYPE,i,o,null,n)),r[ft.PREV_HOVER_OBJ]=o,this.FireListener(new dt(dt.TOUCH_HOVER_START_TYPE,i,o,null,n))):e==dt.TOUCH_HOLD_MOVE_TYPE&&(this._fireHoverOverOutEvents(o,r[ft.PREV_HOVER_OBJ],i,n),r[ft.PREV_HOVER_OBJ]=o,this.FireListener(new dt(dt.TOUCH_HOVER_MOVE_TYPE,i,o,null,n)))},ft.prototype._getObjFromTouch=function(t){return t?gt.elementFromTouch(t):null},ft.prototype._fireHoverOverOutEvents=function(t,e,i,n){e!=t&&(null!=e&&this.FireListener(new dt(dt.TOUCH_HOVER_OUT_TYPE,i,e,t,n)),null!=t&&this.FireListener(new dt(dt.TOUCH_HOVER_OVER_TYPE,i,t,e,n)))},ft.prototype.addTouchEventListener=function(t,e,i){var n=this._getListeners(t,!0);n.push(e),n.push(i)},ft.prototype.removeTouchEventListener=function(t,e,i){var n=this._getListeners(t,!1);if(n)for(var r=0;r<n.length;r+=2)if(n[r]===e&&n[r+1]===i){n.splice(r,2);break}},ft.prototype._getListeners=function(t,e){if(!this._listenerObj){if(!e)return null;this._listenerObj={}}var i=t,n=this._listenerObj[i];return!n&&e&&(n=[],this._listenerObj[i]=n),n},ft.prototype.FireListener=function(t){var e=this._getListeners(t.type,!1);if(e)for(var i=0;i<e.length;i+=2){var n=e[i+1];e[i].call(n,t)}},ft.prototype.startTouchHold=function(t){var e=this._startSingleFingerTouchId;if(null!=e&&!isNaN(e)){var i=this._touchMap[e];if(i){for(var n=i.startTarget,r=i.startTouch,o=t.getNativeEvent(),s=this._findMatches("touchId",e),a=0;a<s.length;a++){var h=s[a],l=h.touchObj,u=h.touchId;if(l!=ft.HOVER_TOUCH_KEY){var c=this.getTouchInfo(u).startTouch;this.performAssociatedTouchEnd(c,l,null)}}i[ft.TOUCH_MODE]=ft.TOUCH_MODE_LONG_PRESS,this.saveProcessedTouch(e,ft.HOVER_TOUCH_KEY,null,ft.HOVER_TOUCH_KEY,ft.HOVER_TOUCH_KEY,this.HoverMoveInternal,this.HoverEndInternal,this);var _=new dt(dt.TOUCH_HOLD_START_TYPE,r,n,null,o);this.FireListener(_)}}},ft.prototype.fireLogicalEvents=function(t){var e=t.type,i=t.getNativeEvent();if(e==L.TOUCHSTART?(t.isTouchHoldBlocked()||this.processAssociatedTouchAttempt(t,ft.HOVER_TOUCH_KEY,this.HoverStartInternal,this),this._doubleTapAttemptStarted&&t.preventDefault()):e==L.TOUCHMOVE?this.processAssociatedTouchMove(t,ft.HOVER_TOUCH_KEY):e==L.TOUCHEND&&this.processAssociatedTouchEnd(t,ft.HOVER_TOUCH_KEY),e==L.TOUCHEND){this._context.oj.Logger.log("received touch end:"+performance.now());for(var n=this._getStoredTouches(t.changedTouches),r=0;r<n.length;r++){var o=n[r],s=o.identifier,a=this.getTouchInfo(s),h=a.currentObj;if(a[ft.TOUCH_MODE]!=ft.TOUCH_MODE_LONG_PRESS&&a.fireClick){var l=new dt(dt.TOUCH_CLICK_TYPE,o,h,null,i);if(l.touchEvent=t,this._context.oj.Logger.log("doubleTapAttemptStarted:"+this._doubleTapAttemptStarted),this._doubleTapAttemptStarted){var u=this._doubleTapAttemptObj;if(this.resetDoubleTap(),h==u||u.contains(h)){var c=new dt(dt.TOUCH_DOUBLE_CLICK_TYPE,o,h,null,i);c.touchEvent=t,this._context.oj.Logger.log("firing double tap"),this.FireListener(c)}else this.FireListener(l)}else this._context.oj.Logger.log("firing tap"),this.FireListener(l),this.resetDoubleTap(),this._context.oj.Logger.log("starting double tap timer"),this._doubleTapTimer.start(),this._doubleTapAttemptStarted=!0,this._doubleTapAttemptObj=h}}}},ft.prototype.getTouchInfo=function(t){return this._touchMap[t]},ft.prototype.HoverStartInternal=function(t,e){if(!this._blockTouchHold){var i=e.identifier;this._startSingleFingerTouchId=i,this._stopTouchHoldTimer(),this._startTouchHoldTimer(t)}},ft.prototype.HoverMoveInternal=function(t,e){var i=e.identifier,n=this.getTouchInfo(i).currentObj,r=new dt(dt.TOUCH_HOLD_MOVE_TYPE,e,n,null,t.getNativeEvent());this.FireListener(r),t.preventDefault()},ft.prototype.HoverEndInternal=function(t,e){var i=e.identifier,n=this.getTouchInfo(i).currentObj,r=new dt(dt.TOUCH_HOLD_END_TYPE,e,n,null,t.getNativeEvent());this.FireListener(r),t&&t.preventDefault()},ft.prototype.resetTouchHold=function(){this._startSingleFingerTouchId=null,this._stopTouchHoldTimer()},ft.prototype.preEventBubble=function(t){t.setTouchManager&&t.setTouchManager(this);var e=t.type;e==L.TOUCHSTART?this.processTouchStart(t):e==L.TOUCHMOVE?this.processTouchMove(t):e==L.TOUCHEND&&this.processTouchEnd(t)},ft.prototype.postEventBubble=function(t){var e=t.type;if(e==L.TOUCHSTART);else if(e==L.TOUCHMOVE);else if(e==L.TOUCHEND)for(var i=this._getStoredTouches(t.changedTouches),n=0;n<i.length;n++){var r=i[n].identifier;delete this._touchMap[r],this._startSingleFingerTouchId==r&&(this._startSingleFingerTouchId=null);for(var o=this._findMatches("touchId",r),s=0;s<o.length;s++){var a=o[s];this.removeTooltipInfo(a.touchId,a.touchObj)}}},ft.prototype.saveProcessedTouch=function(t,e,i,n,r,o,s,a){if(null!=t&&!isNaN(t)){var h=ft.createSavedTouchInfo(t,e,i,n,r,o,s,a);return this._savedTouchInfo.push(h),!0}return!1},ft.prototype.cancelTouchHold=function(){for(var t=ft.HOVER_TOUCH_KEY,e=this.getTouchIdsForObj(t),i=0;i<e.length;i++){var n=e[i],r=this.getTouchInfo(n).startTouch;r&&(this._isCancelEvent=!0,this.performAssociatedTouchEnd(r,t,null),this._isCancelEvent=!1,delete this._touchMap[n])}},ft.prototype.performAssociatedTouchEnd=function(t,e,i){for(var n=t.identifier,r=this._getSavedTouchInfo(n,e),o=0;o<r.length;o++){var s=r[o],a=s.listenerObj,h=s.endListener;this.removeTooltipInfo(n,e),h&&h.call(a,i,t,s)}},ft.prototype.processAssociatedTouchAttempt=function(t,e,i,n){for(var r=t.changedTouches,o=0;o<r.length;o++){var s=r[o];s&&i&&i.call(n,t,s)}},ft.prototype.processAssociatedTouchMove=function(t,e){for(var i=this.getTouchIdsForObj(e),n=0;n<i.length;n++){var r=i[n];if(null!=r&&!isNaN(r)){var o=ft.getTouchById(r,this._getStoredTouches(t.changedTouches));if(o){var s=this._getSavedTouchInfo(o.identifier,e);for(n=0;n<s.length;n++){var a=s[n],h=a.listenerObj,l=a.moveListener;l&&l.call(h,t,o)}}}}},ft.prototype.processAssociatedTouchEnd=function(t,e){for(var i=this.getTouchIdsForObj(e),n=0;n<i.length;n++){var r=i[n],o=ft.getTouchById(r,this._getStoredTouches(t.changedTouches));o&&this.performAssociatedTouchEnd(o,e,t)}},ft.prototype._findMatches=function(t,e){for(var i=new Array,n=0;n<this._savedTouchInfo.length;n++){var r=this._savedTouchInfo[n];r[t]==e&&i.push(r)}return i},ft.prototype._getSavedTouchInfo=function(t,e){for(var i=this._findMatches("touchId",t),n=[],r=0;r<i.length;r++){var o=i[r];o.touchObj==e&&n.push(o)}return n},ft.prototype.getTouchIdsForObj=function(t){for(var e=new Array,i=this._findMatches("touchObj",t),n=0;n<i.length;n++){var r=i[n].touchId;e.push(r)}return e},ft.prototype.removeTooltipInfo=function(t,e){for(var i=this._findMatches("touchId",t),n=new Array,r=0;r<i.length;r++){(h=i[r]).touchObj==e&&n.push(h)}for(r=0;r<n.length;r++){for(var o=n[r],s=-1,a=0;a<this._savedTouchInfo.length;a++){var h;(h=this._savedTouchInfo[a])==o&&(s=a)}-1!=s&&(this._savedTouchInfo.splice(s,1),0==this._savedTouchInfo.length&&this._context.getTooltipManager().hideTooltip())}},ft.prototype.setTooltipEnabled=function(t,e){for(var i=this._savedTouchInfo,n=0;n<i.length;n++){var r=i[n];r.touchId==t&&(r.allowTooltips=e)}},ft.prototype.getTooltipInfo=function(){for(var t=new Object,e=new Array,i=null,n=null,r=!1,o=this._findMatches("allowTooltips",!0),s=0;s<o.length;s++){var a,h=o[s],l=h.touchId;n?h.grouping!=n&&(r=!0):n=h.grouping;var u=this._touchMap[l];u&&(a=u.currentObj),h.tooltipObjOverride&&(a=h.tooltipObjOverride),e.push(l),i=a}return r&&(e=new Array),t.touchIds=e,t.tooltipTarget=i,t},ft.prototype.processTouchStart=function(t){var e=t.changedTouches,i=t.touches;this._touchCount=i.length;for(var n=0;n<e.length;n++){var r=e[n],o=r.screenX,s=r.screenY,a=r.identifier,h=this._getObjFromTouch(r),l={x:o,y:s,prevX:o,prevY:s,pageX:r.pageX,pageY:r.pageY,prevPageX:r.pageX,prevPageY:r.pageY,dx:0,dy:0,fireClick:!0,startTarget:h,currentObj:h,touchMoved:!1,touchtype:null,startTouch:r};l[ft.TOUCH_MODE]=ft.TOUCH_MODE_DEFAULT,l.origx=o,l.origy=s,this._touchMap[a]=l}return!this._isHovering()&&this._isTouchHoldAllowed()||t.blockTouchHold(),!0},ft.prototype._isTouchHoldAllowed=function(){var t=!1,e=0;for(var i in this._touchMap){this.getTouchInfo(i).touchMoved&&(t=!0),e++}return!(e>1&&!t)||(this.resetTouchHold(),!1)},ft.prototype._isHovering=function(){for(var t in this._touchMap){if(this.getTouchInfo(t)[ft.TOUCH_MODE]==ft.TOUCH_MODE_LONG_PRESS)return!0}return!1},ft.prototype._getStoredTouches=function(t){for(var e=new Array,i=0;i<t.length;i++){var n=t[i],r=n.identifier;this.getTouchInfo(r)&&e.push(n)}return e},ft.prototype.processTouchMove=function(t){for(var e=this._getStoredTouches(t.changedTouches),i=this._getStoredTouches(t.touches),n=0;n<e.length;n++){var r=e[n],o=this._getObjFromTouch(r),s=r.identifier;if((u=this.getTouchInfo(s)).currentObj=o,u.touchMoved=!0,u[ft.TOUCH_MODE]!=ft.TOUCH_MODE_LONG_PRESS){var a=Math.abs(u.pageX-r.pageX),h=Math.abs(u.pageY-r.pageY);this._startSingleFingerTouchId==s&&(a>0||h>0)&&this.resetTouchHold(),u.touchMoved=a>3||h>3}(u.touchMoved||u.fireClick&&u[ft.TOUCH_MODE]!=ft.TOUCH_MODE_LONG_PRESS&&u.currentObj!=u.startTarget&&u.currentObj!=this._eventManager.getMarqueeGlassPane())&&(u.fireClick=!1)}for(n=0;n<i.length;n++){var l=(r=i[n]).identifier,u=this.getTouchInfo(l),c=r.screenX,_=r.screenY,p=c-u.x,d=_-u.y;u.prevX=u.x,u.prevY=u.y,u.dx=p,u.dy=d,u.x=c,u.y=_,u.prevPageX=u.pageX,u.prevPageY=u.pageY,u.pageX=r.pageX,u.pageY=r.pageY}return!0},ft.prototype.processTouchEnd=function(t){var e=t.changedTouches;this._touchCount=t.touches.length;for(var i=0;i<e.length;i++){var n=e[i],r=this._getObjFromTouch(n),o=n.identifier,s=this.getTouchInfo(o);if(s&&s.fireClick)if(s[ft.TOUCH_MODE]==ft.TOUCH_MODE_LONG_PRESS)this._startSingleFingerTouchId=null;else{var a=r==s.startTarget,h=s.touchMoved,l=a&&!h;s.fireClick=l}}return!0},ft.getTouchById=function(t,e){if(null!=t&&!isNaN(t))for(var i=0;i<e.length;i++){var n=e[i];if(n.identifier==t)return n}return null},ft.createSavedTouchInfo=function(t,e,i,n,r,o,s,a){var h={touchId:t,tooltipObjOverride:i,grouping:n,type:r,touchObj:e,allowTooltips:!0};return h.moveListener=o,h.endListener=s,h.listenerObj=a,h},ft.prototype._handleTouchHoldStartTimer=function(){var t=this._dvtTouchEvent;this._stopTouchHoldTimer(),this.startTouchHold(t)},ft.prototype._startTouchHoldTimer=function(t){this._dvtTouchEvent=t,this._touchHoldTimer&&this._touchHoldTimer.start()},ft.prototype._stopTouchHoldTimer=function(){this._dvtTouchEvent=null,this._touchHoldTimer&&this._touchHoldTimer.stop()},ft.prototype._handleDoubleTapTimer=function(){this._context.oj.Logger.log("double tap timer expired"),this.resetDoubleTap()},ft.prototype.resetDoubleTap=function(){this._doubleTapAttemptStarted=!1,this._doubleTapAttemptObj=null,this._doubleTapTimer.stop()},ft.prototype.getMultiTouchData=function(t){if(2==t.length){var e=this._touchMap[t[0]],i=this._touchMap[t[1]];if(null==e||null==i)return null;if(0==e.dx&&0==i.dy)return null;var n=e.pageX-i.pageX,r=e.pageY-i.pageY,o=Math.sqrt(n*n+r*r),s=e.prevPageX-i.prevPageX,a=e.prevPageY-i.prevPageY,h=o-Math.sqrt(s*s+a*a),l=(e.pageX+i.pageX)/2,u=(e.pageY+i.pageY)/2;return{dz:h,cx:l,cy:u,dcx:l-(e.prevPageX+i.prevPageX)/2,dcy:u-(e.prevPageY+i.prevPageY)/2,dist:o}}return null},ft.prototype.calcAveragePosition=function(t){for(var e=0,i=0,r=t.length,o=0;o<r;o++){var s=t[o],a=this.getTouchInfo(s);e+=a.pageX,i+=a.pageY}return new n(e/=r,i/=r)},ft.prototype.getStartTargetsByIds=function(t){for(var e=new Array,i=0;i<t.length;i++){var n=this.getTouchInfo(t[i]);e.push(n.startTarget)}return e},ft.prototype.reset=function(){this._touchMap=new Object,this._savedTouchInfo=new Array,this.resetTouchHold(),this.resetDoubleTap()};const yt=new Object;i.createSubclass(yt,i),yt.newEvent=function(t,e){var i={type:t};return e&&(i.id=e),i},yt.newOptionChangeEvent=function(t,e,i){var n=yt.newEvent("optionChange");return n.key=t,n.value=e,n.optionMetadata=i,n},yt.newRenderEvent=function(){return yt.newEvent("dvtRender")},yt.newCategoryHideEvent=function(t,e){var i=yt.newEvent("categoryHide");return i.category=t,i.hiddenCategories=e,i},yt.newCategoryShowEvent=function(t,e){var i=yt.newEvent("categoryShow");return i.category=t,i.hiddenCategories=e,i},yt.newCategoryHighlightEvent=function(t,e){var i=yt.newEvent("categoryHighlight");return i._highlightType=e?"over":"out",t=t||[],i.categories=t instanceof Array?t:[t],i},yt.newDrillEvent=function(t,e){var i=yt.newEvent("drill",t);return e&&(i.subType=e),i},yt.newReadyEvent=function(){return yt.newEvent("ready")},yt.newSelectionEvent=function(t){var e=yt.newEvent("selection");return e.selection=t,e},yt.newTouchHoldReleaseEvent=function(t){var e=yt.newEvent("touchHoldRelease");return e.nativeEvent=t,e},yt.newValueChangeEvent=function(t,e,i){var n=yt.newEvent("valueChange");return n.oldValue=t,n.newValue=e,n.complete=i,n},yt.newActionTooltipEvent=function(t,e){var i=yt.newEvent(t);return i.target=e,i},yt.newPanZoomEvent=function(t,e,i,n,r,o,s,a,h){var l=yt.newEvent("dvtPanZoom");return l.subtype=t,l.dxMin=e,l.dxMax=i,l.dyMin=n,l.dyMax=r,l.dxMinTotal=o,l.dxMaxTotal=s,l.dyMinTotal=a,l.dyMaxTotal=h,l},yt.newSimpleScrollbarEvent=function(t,e,i){var n=yt.newEvent("dvtSimpleScrollbar");return n.subtype=t,n.newMin=e,n.newMax=i,n},yt.newOverviewEvent=function(t,e,i,n,r,o,s,a,h){var l=yt.newEvent("overview");return l.subtype=t,l.newX1=e,l.newX2=i,l.newY1=n,l.newY2=r,l.oldX1=o,l.oldX2=s,l.oldY1=a,l.oldY2=h,l},yt.newChartDrillEvent=function(t,e,i,n){var r=yt.newDrillEvent(t,n);return r.series=e,r.group=i,r},yt.newChartSelectionEvent=function(t,e,i,n,r,o,s,a,h,l){var u=yt.newSelectionEvent(t);return u.complete=e,u.xMin=i,u.xMax=n,u.startGroup=r,u.endGroup=o,u.yMin=s,u.yMax=a,u.y2Min=h,u.y2Max=l,u},yt.newChartViewportChangeEvent=function(t,e,i,n,r,o,s){var a=yt.newEvent("viewportChange");return a.complete=t,a.xMin=e,a.xMax=i,a.startGroup=n,a.endGroup=r,a.yMin=o,a.yMax=s,a},yt.newMarqueeEvent=function(t,e,i,n,r,o){var s=yt.newEvent("dvtMarquee");return s.subtype=t,s.x=e,s.y=i,s.w=n,s.h=r,s.ctrlKey=o,s},yt.newExpandCollapseEvent=function(t,e,i,n,r){var o=yt.newEvent(t,e);return o.expanded=r,o.data=i,o.component=n,o},yt.newTreeDrillEvent=function(t,e,i){var n=yt.newDrillEvent(t);return n.data=e,n.component=i,n},yt.newBreadcrumbsDrillEvent=function(t){return yt.newEvent("breadcrumbsDrill",t)},yt.newSunburstRotationEvent=function(t,e){var i=yt.newEvent("rotation");return i.complete=e,i.startAngle=t%360,i},yt.newThematicMapViewportChangeEvent=function(t,e,i){var n=yt.newEvent("viewportChange");return n.panX=t,n.panY=e,n.zoom=i,n},yt.newTimelineMoveEvent=function(t,e,i,n){var r=yt.newEvent("move");return r.itemContexts=t,r.value=e,r.start=i,r.end=n,r},yt.newTimelineResizeEvent=function(t,e,i,n,r){var o=yt.newEvent("resize");return o.itemContexts=t,o.value=e,o.start=i,o.end=n,o.typeDetail=r,o},yt.newTimelineViewportChangeEvent=function(t,e,i){var n=yt.newEvent("viewportChange");return n.viewportStart=t,n.viewportEnd=e,n.minorAxisScale=i,n},yt.newGanttViewportChangeEvent=function(t,e,i,n){var r=yt.newTimelineViewportChangeEvent(t,e,n);return r.majorAxisScale=i,r},yt.newGanttMoveEvent=function(t,e,i,n,r,o,s){var a=yt.newEvent("move");return a.taskContexts=t,a.value=e,a.start=i,a.end=n,a.baselineStart=r,a.baselineEnd=o,a.rowContext=s,a},yt.newGanttResizeEvent=function(t,e,i,n,r){var o=yt.newEvent("resize");return o.taskContexts=t,o.value=e,o.start=i,o.end=n,o.typeDetail=r,o},yt.newGanttScrollPositionChangeEvent=function(t,e,i){var n=yt.newEvent("scrollPositionChange");return n.y=t,n.rowIndex=e,n.offsetY=i,n},yt.newGanttExpandCollapseEvent=function(t,e,i,n,r){var o=yt.newEvent(t,e);return o.rowData=i,o.itemData=n,o.expanded=r,o},yt.newTreemapIsolateEvent=function(t){return yt.newEvent("isolate",t)},yt.newPanEvent=function(t,e,i,n,r,o){var s=yt.newEvent("dvtPan");return s.subtype=t,s.newX=e,s.newY=i,s.oldX=n,s.oldY=r,s.animator=o,s},yt.newZoomEvent=function(t,e,i,n,r,o,s){var a=yt.newEvent("dvtZoom");return a.subtype=t,a.newZoom=e,a.oldZoom=i,a.animator=n,a.centerPoint=r,a.tx=o,a.ty=s,a},yt.newTimelineOverviewEvent=function(t,e,i){var n=yt.newEvent("timeline");return n.subtype=t,n.itemId=e,n.isMultiSelect=i,n};const vt=function(){this.Init()};i.createSubclass(vt,i),vt.prototype.Init=function(){this._map={}},vt.prototype.get=function(t,e){return this._getInnerMap(t)[e]},vt.prototype.put=function(t,e,i){var n=this._getInnerMap(t),r=n[e];return n[e]=i,r},vt.prototype._getInnerMap=function(t){var e=this._map[t];return e||(e={},this._map[t]=e),e};const St=function(){this.Init()};St.prototype.Init=function(){this.Cache={}},St.prototype.clearCache=function(){this.Cache={}},St.prototype.getFromCache=function(t){return this.Cache[t]},St.prototype.putToCache=function(t,e){this.Cache[t]=e},St.prototype.getFromCachedMap=function(t,e){return this._getCachedMap(t)[e]},St.prototype._getCachedMap=function(t){var e=this.getFromCache(t);return e||(e={},this.putToCache(t,e)),e},St.prototype.putToCachedMap=function(t,e,i){this._getCachedMap(t)[e]=i},St.prototype.getFromCachedMap2D=function(t,e,i){return this._getCachedMap2D(t).get(e,i)},St.prototype._getCachedMap2D=function(t){var e=this.getFromCache(t);return e||(e=new vt,this.putToCache(t,e)),e},St.prototype.putToCachedMap2D=function(t,e,i,n){this._getCachedMap2D(t).put(e,i,n)};const Tt={format:function(t,e){return t?t.replace(/\{(\d+)\}/g,function(){return e[arguments[1]]}):t}},Et=new Object;i.createSubclass(Et,i),Et.clone=function(t,e,i){if(null==t)return null;var n=null;if(t instanceof Array){n=[];for(var r=0;r<t.length;r++)Et._isDeepClonable(t[r])?n[r]=Et.clone(t[r],e,i):n[r]=t[r]}else if(t instanceof j)n=t.clone();else if(t instanceof Date)n=t.getTime();else if(Et._isClonableObject(t))for(var o in n={},t)if(!e||e(o)){var s=t[o];if(i&&1==i[o]||!Et._isDeepClonable(s)||"_widgetConstructor"==o)n[o]=s;else{var a=i?i[o]:null;n[o]=Et.clone(s,e,a)}}return n},Et.merge=function(t,e,i){var n=t&&t._dvtNoClone?t:Et.clone(t,null,i);if(e&&e._dvtNoClone)throw new Error("Do not merge because content will be modified.");var r=Et.clone(e,null,i);if(null==n)return r;if(null==r&&n._dvtNoClone)throw new Error("Do not return an uncloned object.");return null==r?n:(Et._copy(n,r),r)},Et._copy=function(t,e){for(var i in t){var n=t[i];void 0!==n&&(n&&n instanceof Array||"_widgetConstructor"==i?e[i]=n:e[i]&&e[i]instanceof j?n instanceof j?e[i].merge(n):e[i].merge(new j(n)):Et._isDeepClonable(n)&&e[i]?Et._copy(n,e[i]):e[i]=n)}},Et._isDeepClonable=function(t){return t instanceof Object&&(!t.has&&(!t._dvtNoClone&&!(t instanceof Boolean||t instanceof String||t instanceof Number||t instanceof Function||t.then)))},Et._isClonableObject=function(t){return t instanceof Object&&(!t.then&&(!t.jquery&&(!t.has&&(!("undefined"!=typeof NodeList&&t instanceof NodeList)&&(!("undefined"!=typeof Node&&t instanceof Node)&&!t._dvtNoClone)))))};const mt=function(t,e,i,n,r,o){this.Init(t,e,i,n,r,o)};i.createSubclass(mt,J),mt._LINE_SPACE=0,mt.H_ALIGN_LEFT="left",mt.H_ALIGN_CENTER="center",mt.H_ALIGN_RIGHT="right",mt.V_ALIGN_TOP="top",mt.V_ALIGN_MIDDLE="middle",mt.V_ALIGN_CENTRAL="central",mt.V_ALIGN_BOTTOM="bottom",mt.prototype.Init=function(t,e,i,n,r,o){mt.superclass.Init.call(this,t,null,r),this._textInstance=null,this._additionalLines=[],this._lineHeight=null,this._yCoord=null,this._noWrap=!1,this._preserveNewLine=o||!1,this._preservedLines=[],this.setTextString(e),this.setX(i||0),this.setY(n||0),this.setMaxLines(1/0)},mt.prototype.getTextString=function(){return this._textString},mt.prototype.setTextString=function(t){this._textString=null!=t?String(t):null,this._textInstance?(this._textInstance.setTextString(t),this._removeAdditionalLines()):(this._textInstance=new at(this.getCtx(),this._textString),this.addChild(this._textInstance)),this._preserveNewLine&&(this._generatePreservedLines(),this.wrapText(1/0,1/0,1,!1)),this._bTruncated=!1},mt.prototype._getTextLines=function(){var t=this._additionalLines.slice();return this._textInstance.getParent()==this&&t.unshift(this._textInstance),t},mt.prototype.getX=function(){return this._textInstance.getX()},mt.prototype.setX=function(t){return this._getTextLines().forEach(function(e){e.setX(t)}),this},mt.prototype.getY=function(){return this._textInstance.getY()},mt.prototype.getYAlignCoord=function(){return this._yCoord},mt.prototype.setY=function(t){if(this._yCoord=t,this._vertAlign)this._alignVerticalText();else{var e=t-this._textInstance.getY();e||(e=t),this._getTextLines().forEach(function(t){var i=t.getY();t.setY(i?i+e:e)})}return this},mt.prototype.getMaxLines=function(){return this.GetProperty("maxLines")},mt.prototype.setMaxLines=function(t){return t>0?this.SetProperty("maxLines",t):null},mt.prototype.isTruncated=function(){return this._bTruncated},mt.prototype.getHorizAlignment=function(){return this._textInstance.getHorizAlignment()},mt.prototype.setHorizAlignment=function(t){return this._getTextLines().forEach(function(e){e.setHorizAlignment(t)}),this},mt.prototype.alignLeft=function(){this._horizAlign!=mt.H_ALIGN_LEFT&&(this._horizAlign=mt.H_ALIGN_LEFT,this._getTextLines().forEach(function(t){t.alignLeft()}))},mt.prototype.alignCenter=function(){this._horizAlign!=mt.H_ALIGN_CENTER&&(this._horizAlign=mt.H_ALIGN_CENTER,this._getTextLines().forEach(function(t){t.alignCenter()}))},mt.prototype.alignRight=function(){this._horizAlign!=mt.H_ALIGN_RIGHT&&(this._horizAlign=mt.H_ALIGN_RIGHT,this._getTextLines().forEach(function(t){t.alignRight()}))},mt.prototype.alignTop=function(){this._vertAlign!=mt.V_ALIGN_TOP&&(this._vertAlign=mt.V_ALIGN_TOP,this._alignVerticalText(),this._getTextLines().forEach(function(t){t.alignTop()}))},mt.prototype.alignMiddle=function(){this._vertAlign!=mt.V_ALIGN_MIDDLE&&(this._vertAlign=mt.V_ALIGN_MIDDLE,this._alignVerticalText(),this._getTextLines().forEach(function(t){t.alignMiddle()}))},mt.prototype.alignCentral=function(){this._vertAlign!=mt.V_ALIGN_CENTRAL&&(this._vertAlign=mt.V_ALIGN_CENTRAL,this._alignVerticalText(),this._getTextLines().forEach(function(t){t.alignCentral()}))},mt.prototype.alignBottom=function(){this._vertAlign!=mt.V_ALIGN_BOTTOM&&(this._vertAlign=mt.V_ALIGN_BOTTOM,this._alignVerticalText(),this._getTextLines().forEach(function(t){t.alignBottom()}))},mt.prototype._alignVerticalText=function(){if(this._vertAlign)for(var t=this.getYAlignCoord(),e=this.getLineCount(),i=this.getLineHeight(),n=this._getTextLines(),r=0,o=0;o<n.length;o++){var s=n[o];if(this._vertAlign==mt.V_ALIGN_TOP)r=i*o;else if(this._vertAlign==mt.V_ALIGN_MIDDLE||this.vertAlign==mt.V_ALIGN_CENTRAL){r=i*o-i*(e-1)/2}else this._vertAlign==mt.V_ALIGN_BOTTOM&&(r=-i*(e-o-1));s.setY(t+r)}},mt.prototype.getCSSStyle=function(){return this._textInstance.getCSSStyle()},mt.prototype.setCSSStyle=function(t){return this._lineHeight=null,this._getTextLines().forEach(function(e){e.setCSSStyle(t)}),this},mt.prototype.copyShape=function(){var t=new mt(this.getCtx(),this.getTextString(),this.getX(),this.getY());return t.setCSSStyle(this.getCSSStyle()).setHorizAlignment(this.getHorizAlignment()).setMaxLines(this.getMaxLines()),t},mt.prototype._removeAdditionalLines=function(){for(var t=0;t<this._additionalLines.length;t++)this.removeChild(this._additionalLines[t]);this._additionalLines=[]},mt.prototype._generatePreservedLines=function(){if(this._preserveNewLine){this._preservedLines=[];var t=this.getTextString().split(/\n+/),e=this._textInstance,i=null;this._preservedLines.push(e);for(var n=0;n<t.length;n++)if(i=t[n].replace(/\s+/g," "),e.setTextString(i),n<t.length-1){var r=e.copyShape();this._preservedLines.push(r),e=r}}},mt.prototype.__fitText=function(t,e,i){if(!this._preserveNewLine){if(this._textInstance.setTextString(this.getTextString()),this._removeAdditionalLines(),!st.fitText(this._textInstance,t,e,this,i))return this.getParent().removeChild(this),!1;if(!this._textInstance.isTruncated())return!0;if(!this.isWrapEnabled())return this._bTruncated=!0,!0}return this.wrapText(t,e,i,!1)},mt.prototype.wrapText=function(t,e,i,n){this.getLineCount()>1&&this._removeAdditionalLines();var r,o=this.getLineHeight(),s=o*mt._LINE_SPACE,a=this.getMaxLines(),h=Math.min(e,a*(o+s)-s)-o-s;if(this._preserveNewLine){for(var l=!1,u=null,c=0;c<this._preservedLines.length;c++){if(r=this._preservedLines[c],h<s+o)return this._bTruncated=!0,l;if(st.fitText(r,t,1/0,this,i)){if(l=!0,h-=s+o,r.isTruncated()&&!this.isTruncated()&&(this._bTruncated=!0),c>0){this._additionalLines.push(r);var _=u?u.getY()+s+o:this.getY();r.setY(_),this.addChild(r)}u=r}}return l}r=this._textInstance;var p=null,d=null,g=null,f=this.getTextString().split(/\s+/);f.reverse();for(var y=function(){var t=r.copyShape();t.setY(r.getY()+s+o),this.addChild(t),this._additionalLines.push(t),r=t,p=null,h-=s+o}.bind(this),v=!0;f.length>0;){var S=f.pop(),T=p?p+" "+S:S;if(r.setTextString(T),r.setUntruncatedTextString(null),st.fitText(r,t,1/0,this,i,!0))if(r.isTruncated()){if(h<s+o)return this._bTruncated=!0,!0;if(g=r.getTextString(),d=r,p)r.setTextString(p),f.push(S);else{if(n)return this._textInstance.setTextString(this.getTextString()),this._removeAdditionalLines(),!1;this._bTruncated=!0}f.length>0&&y()}else p=T;else{if(null==p){if(v||!d)return this._textInstance.setTextString(null),this._removeAdditionalLines(),!1;d.setTextString(g);for(var E=this._additionalLines.pop();E&&E!==d;)this.removeChild(E),E=this._additionalLines.pop();return E&&this._additionalLines.push(E),!0}f.push(S),y()}v=!1}return!0},mt.prototype.GetSvgDimensions=function(t){var e=this._getTextLines();if(0==e.length)return new m(0,0,0,0);var i=new m(1/0,1/0,0,0);return e.forEach(function(t){var e=t.getDimensions();i.x=Math.min(i.x,e.x),i.y=Math.min(i.y,e.y),i.w=Math.max(i.w,e.w),i.h+=e.h}),this.ConvertCoordSpaceRect(i,t)},mt.prototype.getLineCount=function(){return this._additionalLines.length+1},mt.prototype.getLineHeight=function(){return this._lineHeight||(this._lineHeight=st.getTextStringHeight(this.getCtx(),this.getCSSStyle())),this._lineHeight},mt.prototype.setWrapEnabled=function(t){t||(this._textInstance.getParent()!=this&&this.addChild(this._textInstance),this._textInstance.getTextString()||this._textInstance.setTextString(this.getTextString()),this._removeAdditionalLines()),this._noWrap=!t},mt.prototype.isWrapEnabled=function(){return!this._noWrap},mt.prototype.getUntruncatedTextString=function(){return this.isTruncated()?this.getTextString():null},mt.prototype.setUntruncatedTextString=function(t){},mt.prototype.getDimensions=function(t){return this.GetSvgDimensions(t)},mt.prototype.UpdateSelectionEffect=function(){},mt.prototype.getHorizAlignment=function(){return this._horizAlign},mt.prototype.setHorizAlignment=function(t){t==mt.H_ALIGN_LEFT?this.alignLeft():t==mt.H_ALIGN_CENTER?this.alignCenter():t==mt.H_ALIGN_RIGHT&&this.alignRight()},mt.prototype.getVertAlignment=function(){return this._vertAlign},mt.prototype.setVertAlignment=function(t){t==mt.V_ALIGN_TOP?this.alignTop():t==mt.V_ALIGN_MIDDLE?this.alignMiddle():t==mt.V_ALIGN_CENTRAL?this.alignCentral():t==mt.V_ALIGN_BOTTOM&&this.alignBottom()},mt.prototype.isMultiline=function(){return!0},mt.prototype.hasBackground=function(){return!1};const bt=function(t,e,i,n){this.Init(t,e,i,n)};i.createSubclass(bt,i),bt.prototype.Init=function(t,e,i,n){this._tooltip=t,this._datatip=e,this._datatipColor=i,this._params=n},bt.prototype.getParams=function(){return this._params},bt.prototype.getTooltip=function(t){return this._tooltip},bt.prototype.getDatatip=function(t){return"function"==typeof this._datatip?this._datatip():this._datatip},bt.prototype.getDatatipColor=function(t){return"function"==typeof this._datatipColor?this._datatipColor():this._datatipColor};const Ct=function(t,e,i,n){n||this.Init(t,e,i)};i.createSubclass(Ct,J),Ct.prototype.Init=function(t,e,i){Ct.superclass.Init.call(this,t),this._callback=e,this._callbackObj=i,this.Defaults=null,this.Options=null,this.Width=0,this.Height=0,this.EventManager=null,this.Animation=null,this.AnimationStopped=!1,this._optionsCache=new St,this._cache=new St,this._SHARED_DEFS_DIV_ID="_dvtSharedDefs"},Ct.prototype.GetDefaults=function(t){return this.Defaults?this.Defaults.getDefaults(t):{}},Ct.prototype.GetComponentDescription=function(){return this.getOptions().translations.componentName},Ct.prototype.IsParentRoot=function(){return this.getParent()==this.getCtx().getStage()},Ct.prototype.UpdateAriaAttributes=function(){if(this.IsParentRoot()){var t=this.getOptions().translations;this.getCtx().setAriaRole("application"),this.getCtx().setAriaLabel(Tt.format(t.labelAndValue,[t.labelDataVisualization,O.processAriaLabel(this.GetComponentDescription())]))}},Ct.prototype.SetOptions=function(t){},Ct.prototype.getOptions=function(){return this.Options||(this.Options=this.GetDefaults()),this.Options},Ct.prototype.applyOptions=function(t,e){this.Options&&t&&this.SetOptions(Et.merge(t,this.Options,e))},Ct.prototype.render=function(t,e,i){},Ct.prototype.RenderComplete=function(){this.Animation=null,this.AnimationStopped=!1,this.getCtx().resetIsOffscreen(),this.dispatchEvent(yt.newReadyEvent())},Ct.prototype.getWidth=function(){return this.Width},Ct.prototype.getHeight=function(){return this.Height},Ct.prototype.highlight=function(t){},Ct.prototype.select=function(t){},Ct.prototype.dispatchEvent=function(t){this._callback&&this._callback.call&&this._callback.call(this._callbackObj,t,this)},Ct.prototype.getDimensionsWithStroke=function(t){return this.getDimensions(t)},Ct.prototype.getEventManager=function(){return this.EventManager},Ct.prototype.getKeyboardFocus=function(){var t=this.getEventManager();return t&&t.getFocus()?t.getFocus().getTargetElem():null},Ct.prototype.getCache=function(){return this._cache},Ct.prototype.getOptionsCache=function(){return this._optionsCache},Ct.prototype.StopAnimation=function(t){this.Animation&&(this.AnimationStopped=!0,this.Animation.stop(t||!1),this.Animation=null)},Ct.prototype.appendSharedDefs=function(t){var e=document.getElementById(this._SHARED_DEFS_DIV_ID);if(!e){(e=document.createElement("div")).id=this._SHARED_DEFS_DIV_ID,e.style.width="0px",e.style.height="0px",e.style.left="0px",e.style.top="0px",e.style.position="absolute";var i=u.createSvgDocument();u.setAttrNullNS(i,"width","0px"),u.setAttrNullNS(i,"height","0px");var n=A.createElement("defs");i.appendChild(n),e.appendChild(i),document.body.appendChild(e)}return(n=e.childNodes[0].childNodes[0]).appendChild(t),t},Ct.prototype.destroy=function(){this.StopAnimation(),this.EventManager&&(this.EventManager.removeListeners(this),this.EventManager.destroy(),this.EventManager=null);var t=1===document.getElementsByClassName("oj-dvtbase").length,e=document.getElementById(this._SHARED_DEFS_DIV_ID);t&&e&&document.body.removeChild(e),Ct.superclass.destroy.call(this)},Ct.prototype.renderEmptyText=function(t,e,i,n,r){var o=new mt(t.getCtx(),e,i.x+i.w/2,i.y+i.h/2);r&&o.setCSSStyle(r),o.alignCenter(),o.alignMiddle();var s=i.w-2*st.EMPTY_TEXT_BUFFER;return st.fitText(o,s,1/0,t,0)&&(o.isTruncated()&&n.associate(o,new bt(o.getUntruncatedTextString())),o.setAriaProperty("hidden",null)),o},Ct.prototype.setContextMenu=function(t){this._hasContextMenu=t},Ct.prototype.hasContextMenu=function(){return this._hasContextMenu};const At=function(t,e){this.Init(t,e)};i.createSubclass(At,i),At.TYPE_SINGLE="s",At.TYPE_MULTIPLE="m",At.prototype.Init=function(t,e){this._context=t,this._selection=[],this._type=e||At.TYPE_SINGLE,this._hiddenSelectedIds=[]},At.prototype.getType=function(){return this._type},At.prototype.getSelectedCount=function(){return this._selection.length},At.prototype.getSelection=function(){return this._selection.slice(0)},At.prototype.getSelectedIds=function(){for(var t=[],e=0;e<this._selection.length;e++)t.push(this._selection[e].getId());return t.concat(this._hiddenSelectedIds)},At.prototype.processInitialSelections=function(t,e){if(this.clearSelection(!0),t&&e){for(var i=new this._context.KeySetImpl(t),n=new Map,r=0,o=0;r!==t.length&&o<e.length;o++){if((a=e[o]).isSelectable&&a.isSelectable()){var s=i.get(a.getId());s!==i.NOT_A_KEY&&(r++,n.set(s,a))}}for(o=0;o<t.length;o++){var a;(a=n.get(t[o]))?this._addToSelection(a,!0,!0):this._hiddenSelectedIds.push(t[o])}}},At.prototype.processClick=function(t,e){if(t&&t.isUnrelatedToSelection&&t.isUnrelatedToSelection())return!1;var i=!1;return e&&this._type==At.TYPE_MULTIPLE?t&&t.isSelectable&&t.isSelectable()&&(i=t.isSelected()?this._removeFromSelection(t):this._addToSelection(t,!0)):i=t&&t.isSelectable&&t.isSelectable()?this._addToSelection(t,!1):this.clearSelection(),i},At.prototype.processGroupSelection=function(t,e){var i;e||this.clearSelection();for(var n=0;n<t.length;n++)(i=t[n])&&i.isUnrelatedToSelection&&i.isUnrelatedToSelection()||this._addToSelection(i,!0)},At.prototype.processMouseOver=function(t){t&&t.isSelectable&&t.isSelectable()&&t.showHoverEffect&&t.showHoverEffect()},At.prototype.processMouseOut=function(t){t&&t.isSelectable&&t.isSelectable()&&t.hideHoverEffect&&t.hideHoverEffect()},At.prototype._addToSelection=function(t,e,i){return!(t.isSelected()||t.isSelectable&&!t.isSelectable())&&(e||this.clearSelection(i),t.setSelected(!0,i),this._selection.push(t),!0)},At.prototype._removeFromSelection=function(t){if(!t.isSelected())return!1;t.setSelected(!1);for(var e=0;e<this._selection.length;e++)if(this._selection[e]==t){this._selection.splice(e,1);break}return!0},At.prototype.clearSelection=function(t){if(this._selection.length<=0&&this._hiddenSelectedIds.length<=0)return!1;for(;this._selection.length>0;){this._selection.pop().setSelected(!1,t)}return this._hiddenSelectedIds.length=0,!0};const Ot=function(t,e){this._callback=t,this._callbackObj=e,this._source=e,this._bHighlightMode=!1,this._hoverDelayCallback=null,this._highlightModeTimeout=null,this._hoverDelay=Ot._HOVER_DELAY};i.createSubclass(Ot,i),Ot._HOVER_DELAY=50,Ot._HOVER_TIMEOUT=1e3,Ot._ROLLOUT_TIMEOUT=250,Ot._FADE_OUT_OPACITY=.35,Ot.prototype.processEvent=function(t,e,i,n,r){if(t&&e&&0!=e.length){this._hoverDelayCallback&&(clearTimeout(this._hoverDelayCallback),this._hoverDelayCallback=null);var o=t._highlightType;if("over"==o){var s=this._bHighlightMode?this._hoverDelay:i;this._hoverDelayCallback=setTimeout(this.GetRolloverCallback(t,e,n,r),s),this._highlightModeTimeout&&(clearInterval(this._highlightModeTimeout),this._highlightModeTimeout=null)}else if("out"==o){var a=this._bHighlightMode?this._hoverDelay:Ot._ROLLOUT_TIMEOUT;this._hoverDelayCallback=setTimeout(this.GetRolloutCallback(t,e,n,r),a)}}},Ot.prototype.GetRolloverCallback=function(t,e,n,r){return i.createCallback(this,function(){this._bHighlightMode=!0,Ot.highlight(t.categories,e,n,r),this.FireCallback(t)})},Ot.prototype.GetRolloutCallback=function(t,e,n,r){return i.createCallback(this,function(){Ot.highlight(t.categories,e,n,r),this.SetHighlightModeTimeout(),this.FireCallback(t)})},Ot.prototype.FireCallback=function(t){this._callback&&this._callback.call(this._callbackObj,t,this._source)},Ot.highlight=function(t,e,i,n){if(e)for(var r=n||Ot._FADE_OUT_OPACITY,o=0;o<e.length;o++){var s=e[o];if(s&&s.getCategories){var a=i?Ot._hasAnyCategory(s,t):Ot._hasAllCategories(s,t),h=t&&t.length>0&&!a;Ot._highlightObj(s,h,r)}}},Ot._highlightObj=function(t,e,i){var n=e?i:1;if(t.highlight)t.highlight(e,n);else{var r=t.getDisplayables();Ot._updateAlpha(r,n)}},Ot._updateAlpha=function(t,e){if(t)for(var i=0;i<t.length;i++)t[i].setAlpha(e)},Ot._hasAnyCategory=function(t,e){return!(!t||!t.getCategories)&&d.hasAnyItem(t.getCategories(),e)},Ot._hasAllCategories=function(t,e){return!(!t||!t.getCategories)&&d.hasAllItems(t.getCategories(),e)},Ot.prototype.SetHighlightMode=function(t){this._bHighlightMode=t},Ot.prototype.SetHighlightModeTimeout=function(){var t=i.createCallback(this,function(){this.SetHighlightMode(!1)});this._highlightModeTimeout=setTimeout(t,Ot._HOVER_TIMEOUT)},Ot.prototype.setHoverDelay=function(t){this._hoverDelay=t};const It=function(t,e,i,n){this.Init(t,e,i,n)};i.createSubclass(It,i),It.CLEAR_SELECTION_ACTION_TYPE="clearSelectionActionType",It.TOUCH_RESPONSE_TOUCH_START="touchStart",It.TOUCH_RESPONSE_TOUCH_HOLD="touchHold",It.TOUCH_RESPONSE_AUTO="auto",It._TOUCH_RESPONSE_PADDING_CHECK=10,It._EVENT_INFO_TOOLTIP_DISPLAYED_KEY="tooltipDisplayed",It.prototype.Init=function(t,e,i,n){this._context=t,this._callback=e,this._callbackObj=i,this._component=n,this._touchMap={},this._selectionHandler=null,this.KeyboardHandler=null,this.RolloverHandler=this.CreateCategoryRolloverHandler(e,i),this.setTooltipsEnabled(!0);var o=t.getStage().getId();o||(o="undefinedId"),this.CustomTooltipManager=this._context.getCustomTooltipManager(),this.CustomTooltipManager.addTooltipEventListener("actionTooltipClosed",this.OnActionTooltipClosed,this),this.CustomTooltipManager.addTooltipEventListener("actionTooltipStarted",this.OnActionTooltipStarted,this),this.TouchManager=null,r.isTouchDevice()&&(this.TouchManager=new ft("touchmanager",this._context,this)),this._focusedObj=null,this._shouldDisplayKeyboardFocus=!1,this._keyboardHandlers=[this],this._currentKeyboardHandlerIdx=-1,this._dndListeners={}},It.prototype.getCtx=function(){return this._context},It.prototype.associate=function(t,e,i){t&&(t._logicalObjects&&!i||(t._logicalObjects=[]),t._logicalObjects.push({logicalObject:e,eventManager:this}))},It.prototype.addListeners=function(t){if(t&&(r.isTouchDevice()?(this.hideTooltip(),t.addEvtListener(L.TOUCHSTART,this.OnTouchStartBubble,!1,this),t.addEvtListener(L.TOUCHMOVE,this.OnTouchMoveBubble,!1,this),t.addEvtListener(L.TOUCHEND,this.OnTouchEndBubble,!1,this),this.TouchManager.addTouchEventListener(dt.TOUCH_HOVER_START_TYPE,this.OnComponentTouchHoverStart,this),this.TouchManager.addTouchEventListener(dt.TOUCH_HOVER_MOVE_TYPE,this.OnComponentTouchHoverMove,this),this.TouchManager.addTouchEventListener(dt.TOUCH_HOVER_END_TYPE,this.OnComponentTouchHoverEnd,this),this.TouchManager.addTouchEventListener(dt.TOUCH_HOVER_OUT_TYPE,this.OnComponentTouchHoverOut,this),this.TouchManager.addTouchEventListener(dt.TOUCH_HOVER_OVER_TYPE,this.OnComponentTouchHoverOver,this),this.TouchManager.addTouchEventListener(dt.TOUCH_CLICK_TYPE,this.OnComponentTouchClick,this),this.TouchManager.addTouchEventListener(dt.TOUCH_DOUBLE_CLICK_TYPE,this.OnComponentTouchDblClick,this)):(t.addEvtListener(F.CLICK,this._onClick,!1,this),t.addEvtListener(F.DBLCLICK,this._onDblClick,!1,this),t.addEvtListener("contextmenu",this.OnContextMenu,!1,this),t.addEvtListener(F.MOUSEMOVE,this.OnMouseMove,!1,this),t.addEvtListener(F.MOUSEOVER,this.PreOnMouseOver,!1,this),t.addEvtListener(F.MOUSEOUT,this.PreOnMouseOut,!1,this),t.addEvtListener(F.MOUSEDOWN,this.PreOnMouseDown,!1,this),t.addEvtListener(F.MOUSEUP,this.OnMouseUp,!1,this),t.addEvtListener(P.KEYDOWN,this.OnKeyDown,!1,this),t.addEvtListener(P.KEYUP,this.OnKeyUp,!1,this),t.addEvtListener(H.FOCUS,this.OnFocus,!1,this),t.addEvtListener(H.BLUR,this.OnBlur,!1,this),"safari"===r.browser&&this.getCtx()._parentDiv.addEventListener("wheel",()=>{})),this.isDndSupported())){var e=this.getCtx();this.setDragSource(new a(e)),this._addDndListener("dragstart",this.OnDndDragStart),this._addDndListener("drag",this.OnDndDrag),this._addDndListener("dragend",this.OnDndDragEnd),this._addDndListener("dragenter",this.OnDndDragEnter),this._addDndListener("dragover",this.OnDndDragOver),this._addDndListener("dragleave",this.OnDndDragLeave),this._addDndListener("drop",this.OnDndDrop);var i=e.getContainer();for(var n in this._dndListeners)u.addDomEventListener(i,n,this._dndListeners[n],!1);this._context.addDndEventManager(this)}},It.prototype._addDndListener=function(t,e){var i=gt.createStaticCallback(this.getCtx(),e,this);this._dndListeners[t]=i},It.prototype.removeListeners=function(t,e){t&&(e||this.hideTooltip(),this.RemoveListeners(t))},It.prototype.RemoveListeners=function(t){if(r.isTouchDevice()?(t.removeEvtListener(L.TOUCHSTART,this.OnTouchStartBubble,!1,this),t.removeEvtListener(L.TOUCHMOVE,this.OnTouchMoveBubble,!1,this),t.removeEvtListener(L.TOUCHEND,this.OnTouchEndBubble,!1,this),this.TouchManager.removeTouchEventListener(dt.TOUCH_HOVER_START_TYPE,this.OnComponentTouchHoverStart,this),this.TouchManager.removeTouchEventListener(dt.TOUCH_HOVER_MOVE_TYPE,this.OnComponentTouchHoverMove,this),this.TouchManager.removeTouchEventListener(dt.TOUCH_HOVER_END_TYPE,this.OnComponentTouchHoverEnd,this),this.TouchManager.removeTouchEventListener(dt.TOUCH_HOVER_OUT_TYPE,this.OnComponentTouchHoverOut,this),this.TouchManager.removeTouchEventListener(dt.TOUCH_HOVER_OVER_TYPE,this.OnComponentTouchHoverOver,this),this.TouchManager.removeTouchEventListener(dt.TOUCH_CLICK_TYPE,this.OnComponentTouchClick,this),this.TouchManager.removeTouchEventListener(dt.TOUCH_DOUBLE_CLICK_TYPE,this.OnComponentTouchDblClick,this)):(t.removeEvtListener(F.CLICK,this._onClick,!1,this),t.removeEvtListener(F.DBLCLICK,this._onDblClick,!1,this),t.removeEvtListener("contextmenu",this.OnContextMenu,!1,this),t.removeEvtListener(F.MOUSEMOVE,this.OnMouseMove,!1,this),t.removeEvtListener(F.MOUSEOVER,this.PreOnMouseOver,!1,this),t.removeEvtListener(F.MOUSEOUT,this.PreOnMouseOut,!1,this),t.removeEvtListener(F.MOUSEDOWN,this.PreOnMouseDown,!1,this),t.removeEvtListener(F.MOUSEUP,this.OnMouseUp,!1,this),t.removeEvtListener(P.KEYDOWN,this.OnKeyDown,!1,this),t.removeEvtListener(P.KEYUP,this.OnKeyUp,!1,this),t.removeEvtListener(H.FOCUS,this.OnFocus,!1,this),t.removeEvtListener(H.BLUR,this.OnBlur,!1,this)),this.isDndSupported()){var e=this.getCtx().getContainer();for(var i in this._dndListeners)u.removeDomEventListener(e,i,this._dndListeners[i],!1);this._dndListeners={},this._context.removeDndEventManager(this)}},It.prototype.destroy=function(){this.CustomTooltipManager&&(this.CustomTooltipManager.removeTooltipEventListener("actionTooltipClosed",this.OnActionTooltipClosed,this),this.CustomTooltipManager.removeTooltipEventListener("actionTooltipStarted",this.OnActionTooltipStarted,this))},It.prototype.PreEventBubble=function(t){this.TouchManager.preEventBubble(t)},It.prototype.setSelectionHandler=function(t){this._selectionHandler=t},It.prototype.getSelectionHandler=function(t){return this._selectionHandler},It.prototype.getMarqueeGlassPane=function(){return null},It.prototype.setDragSource=function(t){this.DragSource=t,r.isTouchDevice()&&this.DragSource.setTouchManager(this.TouchManager)},It.prototype.setKeyboardHandler=function(t){r.isTouchDevice()||(this.KeyboardHandler=t)},It.prototype.getKeyboardHandler=function(){return this.KeyboardHandler},It.prototype.setFocusObj=function(t){var e=this.getFocus();if(t!=e&&(this.setFocus(t),e&&e.hideKeyboardFocusEffect(),this._currentKeyboardHandlerIdx>-1&&this._currentKeyboardHandlerIdx<this._keyboardHandlers.length)){var i=this._keyboardHandlers[this._currentKeyboardHandlerIdx];i!=this&&i.hideKeyboardFocusEffect()}this.setCurrentKeyboardHandler(this)},It.prototype.setFocus=function(t){this.KeyboardHandler&&(this._focusedObj=t)},It.prototype.getFocus=function(){return this.KeyboardHandler?this._focusedObj:null},It.prototype.setFocused=function(t){var e=this.getFocus();e&&this.KeyboardHandler&&(t?this._shouldDisplayKeyboardFocus&&this._currentKeyboardHandlerIdx>=0&&this._currentKeyboardHandlerIdx<this._keyboardHandlers.length&&this._keyboardHandlers[this._currentKeyboardHandlerIdx]===this&&e.showKeyboardFocusEffect():e.hideKeyboardFocusEffect()),t||(this._shouldDisplayKeyboardFocus=!1)},It.prototype.setTooltipsEnabled=function(t){this._tooltipsEnabled=t},It.prototype.getTooltipsEnabled=function(t){return this._tooltipsEnabled},It.prototype.GetLogicalObject=function(t,e){return this.GetLogicalObjectAndDisplayable(t,e).logicalObject},It.prototype.GetLogicalObjectAndDisplayable=function(t,e){for(var i=t;i;){if(i._logicalObjects)for(var n=0;n<i._logicalObjects.length;n++){var r=i._logicalObjects[n];if(r.eventManager==this){var o={};return o.logicalObject=r.logicalObject,o.displayable=i,o}}i=e?null:i.getParent()}return{}},It.prototype._getTooltipColor=function(t,e,i){if(t&&t.getDatatipColor)return t.getDatatipColor()},It.prototype.FireEvent=function(t,e){this._callback&&this._callback.call(this._callbackObj,t,e)},It.prototype.fireSelectionEvent=function(t){var e=this.getSelectionHandler(t);if(e){var i=e.getSelectedIds(),n=yt.newSelectionEvent(i);this._callback.call(this._callbackObj,n)}},It.prototype._onClick=function(t){if(this.IsDoubleClickable(t)){if(this._clickTimer&&this._clickTimer.isRunning()){var e=this._savedClickEvent;if(t.pageX==e.pageX&&t.pageY==e.pageY)return void this._savedClickCount++;this._clickTimer.stop(),this._onClickTimerEnd()}this._savedClickEvent=t,this._savedClickCount=1,this._clickTimer||(this._clickTimer=new ut(this._context,250,this._onClickTimerEnd,this,1)),this._clickTimer.reset(),this._clickTimer.start()}else this.OnClick(t)},It.prototype._onClickTimerEnd=function(){var t=this._savedClickEvent;this._savedClickEvent=null,this._savedClickCount=0,t&&this.OnClick(t)},It.prototype.OnClick=function(t){var e=this.GetLogicalObject(t.target);if(this.OnClickInternal(t),this.ProcessSelectionEventHelper(e,t.ctrlKey),this._shouldDisplayKeyboardFocus=!1,e&&this.KeyboardHandler&&e.getNextNavigable){var i=e.getNextNavigable(t);this.setFocusObj(i)}},It.prototype.IsDoubleClickable=function(t){var e=this.GetLogicalObject(t.target);return!!(e&&e.isDoubleClickable&&e.isDoubleClickable())},It.prototype.ProcessSelectionEventHelper=function(t,e){var i=this.getSelectionHandler(t);i&&(i.processClick(t,e)&&this.fireSelectionEvent(t))},It.prototype._onDblClick=function(t){var e=this.IsDoubleClickable(t);(e&&2===this._savedClickCount||!e)&&this.OnDblClick(t),this._savedClickCount=0},It.prototype.OnDblClick=function(t){this._clickTimer&&this._clickTimer.isRunning()&&(this._clickTimer.stop(),this._savedClickEvent=null),this.OnDblClickInternal(t)},It.prototype.OnContextMenu=function(t){var e=this.GetLogicalObject(t.target);e&&e.getNextNavigable&&this.setFocus(e),this._onContextMenuHelper(t,e)},It.prototype._onContextMenuHelper=function(t,e){(this._processActionPopup(t.target,new n(t.pageX,t.pageY))&&t.preventDefault(),e&&e.isSelectable&&e.isSelectable())&&("mac"===r.os&&e.isSelected()||this.ProcessSelectionEventHelper(e,t.ctrlKey))},It.prototype.OnKeyDown=function(t){this._bKeyDown=!0;var e,i,n=t.keyCode,r=!1;for(e=this._currentKeyboardHandlerIdx<0||this._currentKeyboardHandlerIdx>this._keyboardHandlers.length?n==P.TAB&&t.shiftKey?this._keyboardHandlers.length-1:0:this._currentKeyboardHandlerIdx,i=n==P.TAB&&t.shiftKey?-1:1;e>=0&&e<this._keyboardHandlers.length&&!r;e+=i){var o=this._keyboardHandlers[e];(r=o===this?this.ProcessKeyboardEvent(t):o.handleKeyboardEvent(t))&&(this._currentKeyboardHandlerIdx=e)}return r||t.keyCode!=P.UP_ARROW&&t.keyCode!=P.DOWN_ARROW&&t.keyCode!=P.LEFT_ARROW&&t.keyCode!=P.RIGHT_ARROW||It.consumeEvent(t),r||n!=P.TAB||(this._currentKeyboardHandlerIdx=-1),r},It.prototype.handleKeyboardEvent=function(t){return this.OnKeyDown(t)},It.prototype.hideKeyboardFocusEffect=function(){var t=this.getFocus();t&&t.isShowingKeyboardFocusEffect()&&t.hideKeyboardFocusEffect()},It.prototype.ProcessKeyboardEvent=function(t){if(!this.KeyboardHandler)return!1;this.hideTooltip();var e,i,n=this.getFocus();return t.keyCode==P.TAB&&n?n.isShowingKeyboardFocusEffect()?(this._bKeyDown=!1,n.hideKeyboardFocusEffect(),this.ProcessRolloverEvent(t,n,!1),!!(i=t.shiftKey?this._context.previousKeyboardFocus():this._context.nextKeyboardFocus())&&(i.FireListener(t,!1),It.consumeEvent(t),!0)):(this.ShowFocusEffect(t,n),this.ProcessRolloverEvent(t,n,!0),It.consumeEvent(t),!0):!!(e=this.KeyboardHandler.processKeyDown(t))&&(this.setFocus(e),this._shouldDisplayKeyboardFocus=!0,n&&(n.hideKeyboardFocusEffect(),this.ProcessRolloverEvent(t,n,!1)),this.KeyboardHandler.isSelectionEvent(t)?this.ProcessSelectionEventHelper(e,t.shiftKey):this.KeyboardHandler.isMultiSelectEvent(t)&&this.ProcessSelectionEventHelper(e,t.ctrlKey),this.ShowFocusEffect(t,e),this.ProcessRolloverEvent(t,e,!0),!0)},It.prototype.ShowFocusEffect=function(t,e){e.showKeyboardFocusEffect();var i=e.getKeyboardTooltipLocation?e.getKeyboardTooltipLocation():e.getKeyboardBoundingBox(this.getCtx().getStage()).getCenter(),n=this.getCtx().stageToPageCoords(i.x,i.y);this.ProcessObjectTooltip(t,n.x,n.y,e,e.getTargetElem()),this.UpdateActiveElement(e)},It.prototype.OnKeyUp=function(t){if(this._bKeyDown=!1,!0===this._handleExternalKeyboardFocus&&t.keyCode==P.TAB&&(this._handleExternalKeyboardFocus=!1,document.createEvent)){var e=document.createEvent("KeyboardEvent"),i=t.keyCode,n=t.ctrlKey,r=t.shiftKey;void 0!==e.initKeyboardEvent?e.initKeyboardEvent(P.KEYDOWN,!0,!0,window,n,!1,r,!1,i,i):e.initKeyEvent(P.KEYDOWN,!0,!0,window,n,!1,!1,r,i,i);var o=k.newEvent(e);o.keyCode=i,o.ctrlKey=n,o.shiftKey=r;var s=this.getCtx().getStage().getSVGRoot().parentNode;G._bubbleListener.call(s,o)}},It.prototype.OnMouseMove=function(t){var e=t.pageX,i=t.pageY,n=this.GetLogicalObjectAndDisplayable(t.target),r=n.logicalObject,o=n.displayable;r&&this.ProcessObjectTooltip(t,e,i,r,o)},It.prototype.PreOnMouseOver=function(t){this.OnMouseOver(t)},It.prototype.OnMouseOver=function(t){var e=this.GetLogicalObjectAndDisplayable(t.target),i=e.logicalObject,n=e.displayable;if(i){var r=this.getSelectionHandler(i);r&&r.processMouseOver(i),this.ProcessRolloverEvent(t,i,!0),this.UpdateActiveElement(i,n)}},It.prototype.PreOnMouseOut=function(t){var e=this.GetLogicalObject(t.relatedTarget),i=this.GetLogicalObject(t.target);i&&i===e||this.OnMouseOut(t)},It.prototype.OnMouseOut=function(t){var e=this.GetLogicalObject(t.target);if(e&&e!=this.GetLogicalObject(t.relatedTarget)){var i=this.getSelectionHandler(e);i&&i.processMouseOut(e),this.ProcessRolloverEvent(t,e,!1),this.hideTooltip()}},It.prototype.PreOnMouseDown=function(t){this.OnMouseDown(t)},It.prototype.OnMouseDown=function(t){this.isInActionPopup()&&this.CustomTooltipManager.closeActionTooltip();var e=this.GetLogicalObject(t.target);this.DragSource&&!t.dragSourceSet&&this.IsDragCandidate(e)&&(this.DragSource.setDragCandidate(e),t.dragSourceSet=!0)},It.prototype.OnMouseUp=function(t){},It.prototype._processTouchTooltip=function(t){var e=this.TouchManager.getTooltipInfo(),i=e.touchIds,n=e.tooltipTarget;if(this.GetEventInfo(t,It._EVENT_INFO_TOOLTIP_DISPLAYED_KEY)||0!=i.length&&n){var r=this.TouchManager.calcAveragePosition(i),o=this.GetLogicalObject(n);this.ProcessObjectTooltip(t,r.x,r.y,o,null)}else this.hideTooltip()},It.prototype.OnTouchStartBubble=function(t){if(this.PreEventBubble(t),t.isInitialTouch()&&(this._popupJustClosed=!1),this.DragSource){var e=this.GetLogicalObject(t.target);!t.dragSourceSet&&this.IsDragCandidate(e)&&(this.DragSource.setDragCandidate(e),t.dragSourceSet=!0)}this.isInActionPopup()&&(this.CustomTooltipManager.closeActionTooltip(),this.TouchManager.resetTouchHold()),this.HandleImmediateTouchStartInternal(t),this.TouchManager.fireLogicalEvents(t),this.TouchManager.postEventBubble(t),this.isTouchResponseTouchStart()?(this._touchResponseHandled=!0,this.TouchManager.processAssociatedTouchAttempt(t,It.TOUCH_RESPONSE_TOUCH_START,this._saveTouchStart,this)):(this._touchResponseHandled=!1,this._processTouchTooltip(t))},It.prototype.OnTouchMoveBubble=function(t){this.PreEventBubble(t),this.TouchManager&&(this._prevActionClear=!1,this.HandleImmediateTouchMoveInternal(t),this.TouchManager.fireLogicalEvents(t),this.TouchManager.postEventBubble(t),this._processTouchTooltip(t))},It.prototype._handleTouchEndTimer=function(){for(var t=0;t<this._touchEndTimer.length;t++){var e=this._touchEndTimer[t];e.timer.stop();var i=e.event;this.TouchManager&&(this.HandleImmediateTouchEndInternal(i),this.TouchManager.fireLogicalEvents(i),this.TouchManager.postEventBubble(i))}this._touchEndTimer=new Array},It.prototype.OnTouchEndBubble=function(t){this.PreEventBubble(t);var e=new ut(this._context,0,this._handleTouchEndTimer,this,1);this._touchEndTimer||(this._touchEndTimer=new Array),this._touchEndTimer.push({event:t,timer:e}),e.start()},It.prototype.HandleImmediateTouchStartInternal=function(t){},It.prototype.HandleImmediateTouchMoveInternal=function(t){},It.prototype.HandleImmediateTouchEndInternal=function(t){},It.prototype.OnComponentTouchHoverStart=function(t){this.HandleTouchHoverStartInternal(t),this._touchResponseHandled||this.HandleTouchActionsStart(t)},It.prototype.OnComponentTouchHoverMove=function(t){this.HandleTouchHoverMoveInternal(t),this._touchResponseHandled||this.HandleTouchActionsMove(t)},It.prototype.OnComponentTouchHoverEnd=function(t){if(this.HandleTouchHoverEndInternal(t),this._callbackObj instanceof Ct){var e=this.getCtx().getStageAbsolutePosition(),i=t.touch.pageX,n=t.touch.pageY;i<=e.x+this._callbackObj.getWidth()&&i>=e.x&&n<=e.y+this._callbackObj.getHeight()&&n>=e.y&&this._callback.call(this._callbackObj,yt.newTouchHoldReleaseEvent(t.getNativeEvent()))}this._touchResponseHandled||this.HandleTouchActionsEnd(t)},It.prototype.OnComponentTouchHoverOut=function(t){var e=this.GetLogicalObject(t.relatedTarget),i=this.GetLogicalObject(t.target);i&&i===e||(this.HandleTouchHoverOutInternal(t),this._touchResponseHandled||this.HandleTouchActionsOut(t))},It.prototype.OnComponentTouchHoverOver=function(t){this.HandleTouchHoverOverInternal(t),this._touchResponseHandled||this.HandleTouchActionsOver(t)},It.prototype.OnComponentTouchDblClick=function(t){this.HandleTouchDblClickInternal(t)},It.prototype.OnComponentTouchClick=function(t){var e=this.GetLogicalObjectAndDisplayable(t.target),i=e.logicalObject,r=e.displayable,o=t.touch;this.HandleTouchClickInternal(t)||(this.isTouchResponseTouchStart()||this._processTouchSelection(i),this._popupJustClosed||this._processTouchSelectionClear(i),this.CustomTooltipManager.displayActionPopup()&&(this.UpdateActionTooltipLaunchedFeedback(r,new n(o.pageX,o.pageY)),this.CustomTooltipManager.startActionPopupAtPosition(o.pageX,o.pageY,r)))},It.prototype._processTouchSelection=function(t,e){var i=this.getSelectionHandler(t);!(i&&t&&t.isSelectable&&t.isSelectable())||e&&t.isSelected()||i.processClick(t,!0)&&this.fireSelectionEvent(t),this._prevActionClear=!1},It.prototype._processTouchSelectionClear=function(t){var e=this.getSelectionHandler(t);if(e&&(!t||!t.isSelectable||!t.isSelectable())&&!this._prevActionClear){var i=!1;e.getType()==At.TYPE_MULTIPLE&&e.getSelectedCount()>1&&(i=!0),i?this.addClearAllActionItem():e.processClick(null,!1)&&this.fireSelectionEvent(t)}},It.prototype.OnActionTooltipClosed=function(t){this._popupJustClosed=!0,this._isInActionPopup=!1,this.CustomTooltipManager.getActionTooltip().containsMenuId(It.CLEAR_SELECTION_ACTION_TYPE)&&(this._prevActionClear=!0),this.CustomTooltipManager.clearActionTooltip(),this.UpdateActionTooltipClosedFeedback(t.target)},It.prototype.OnActionTooltipStarted=function(t){this._isInActionPopup=!0},It.prototype._getTooltipInfo=function(t,e,i,n){var r=null,o=!1;return e&&e.getDatatip&&(r=e.getDatatip(t,i,n))&&(o=!0),!r&&e&&e.getTooltip&&(r=e.getTooltip(t,i,n)),{text:r,isDatatip:o}},It.prototype._processShowTooltip=function(t,e,i,n){if(this.getTooltipsEnabled(e)){var r=this._context.pageToStageCoords(i,n),o=r.x,s=r.y,a=this._getTooltipInfo(t,e,o,s),h=a.isDatatip,l=a.text;if(l){this.CustomTooltipManager.clearActionTooltip();var u=this._getTooltipColor(e,o,s),c=this._context.getTooltipManager();return h?c.showDatatip(i,n,l,u):c.showTooltip(i,n,l,null,!0,u),this._hideTooltipListener||(this._hideTooltipListener=this._keyboardHideTooltip.bind(this),document.documentElement.addEventListener(P.KEYDOWN,this._hideTooltipListener,{capture:!0})),this.TooltipLaunched(l,u),this.DispatchElementEvent("tooltiplaunched"),!0}this.hideTooltip()}else this.hideTooltip();return!1},It.prototype._keyboardHideTooltip=function(t){t.keyCode===P.ESCAPE&&(this.hideTooltip(),t.preventDefault())},It.prototype.hideTooltip=function(){var t=this._context.getTooltipManager();t&&t.hideTooltip(),this.TooltipHidden(),this._hideTooltipListener&&(document.documentElement.removeEventListener(P.KEYDOWN,this._hideTooltipListener,{capture:!0}),this._hideTooltipListener=null)},It.prototype._processActionPopup=function(t,e){return this.CustomTooltipManager.displayActionPopup()?(this.SetupTouchTooltip(t),this.UpdateActionPopupShownFeedback(t),this.CustomTooltipManager.startActionPopupAtPosition(e.x,e.y,t),!0):(this.UpdateActionPopupHiddenFeedback(t),!1)},It.prototype.TooltipLaunched=function(t,e){},It.prototype.TooltipHidden=function(){},It.prototype.SetupTouchTooltip=function(t){var e=this.GetLogicalObject(t),i=this.CustomTooltipManager.getActionTooltip();if(null==i.getTooltipBorderColor()){var n=this._getTooltipColor(e);i.setTooltipBorderColor(n)}},It.prototype.OnClickInternal=function(t){},It.prototype.OnDblClickInternal=function(t){},It.prototype.HandleTouchHoverStartInternal=function(t){},It.prototype.HandleTouchHoverMoveInternal=function(t){},It.prototype.HandleTouchHoverEndInternal=function(t){},It.prototype.HandleTouchHoverOverInternal=function(t){},It.prototype.HandleTouchHoverOutInternal=function(t){},It.prototype.HandleTouchClickInternal=function(t){return!1},It.prototype.HandleTouchDblClickInternal=function(t){},It.prototype.UpdateActionPopupShownFeedback=function(t){},It.prototype.UpdateActionPopupHiddenFeedback=function(t){},It.prototype.UpdateActionTooltipClosedFeedback=function(t){},It.prototype.UpdateActionTooltipLaunchedFeedback=function(t,e){},It.prototype.isInActionPopup=function(){return this._isInActionPopup},It.prototype.GetClearSelectionText=function(){var t=this.getComponent();return t&&t.getOptions().translations.labelClearSelection},It.prototype.addClearAllActionItem=function(){var t=this.CustomTooltipManager.getActionTooltip(),e=t.getMenuItems();t&&e.length>0&&e[e.length-1].getId()===It.CLEAR_SELECTION_ACTION_TYPE||(this.addActionTooltipMenuItem(It.CLEAR_SELECTION_ACTION_TYPE,this.GetClearSelectionText(),this._actionTooltipClearListener,this),t&&t.setTooltipBorderColor(ct.DEFAULT_BORDER_COLOR))},It.prototype.addActionTooltipMenuItem=function(t,e,i,n){this.CustomTooltipManager.getActionTooltip().addMenuItem(new _t(this._context,t,e,i,n))},It.prototype._actionTooltipClearListener=function(t){var e=this.GetLogicalObject(t.target);this.getSelectionHandler(e).processClick(null,!1)&&this.fireSelectionEvent(e)},It.consumeEvent=function(t){t&&(t.preventDefault(),t.stopPropagation())},It.prototype.addComponentKeyboardHandlerAt=function(t,e){e>this._keyboardHandlers.length||t&&(this._keyboardHandlers.splice(e,0,t),e<=this._currentKeyboardHandlerIdx&&this._currentKeyboardHandlerIdx++)},It.prototype.removeComponentKeyboardHandler=function(t){if(t){var e=this._findHandler(t);e>-1&&(this._currentKeyboardHandlerIdx==e&&0==e?this._currentKeyboardHandlerIdx=0:e<=this._currentKeyboardHandlerIdx&&this._currentKeyboardHandlerIdx--,this._keyboardHandlers.splice(e,1))}},It.prototype._findHandler=function(t){for(var e=-1,i=this._keyboardHandlers.length,n=0;n<i;n++)this._keyboardHandlers[n]===t&&(e=n);return e},It.prototype.setCurrentKeyboardHandler=function(t){var e=this._findHandler(t);e>=0&&(this._currentKeyboardHandlerIdx=e)},It.prototype.IsDragCandidate=function(t){return!0},It.prototype.UpdateActiveElement=function(t,e){if(e||(e=t.getDisplayable?t.getDisplayable():t.getDisplayables?t.getDisplayables()[0]:t),e instanceof Q){if(t.getAriaLabel){var i=t.getAriaLabel();i&&e.setAriaProperty("label",i)}else for(;!e.getAriaRole()&&e.getParent();)e=e.getParent();e!=this.getCtx().getStage()&&this.getCtx().setActiveElement(e)}},It.prototype.getTouchManager=function(){return this.TouchManager},It.prototype.endDrag=function(){return null},It.prototype._hasEventInfo=function(t){return null!=t&&!!t.getNativeEvent()._eventInfo},It.prototype.GetEventInfo=function(t,e){return this._hasEventInfo(t)&&null!=e&&(i=this.StoreInfoByEventType(e)?t.getNativeEvent()._eventInfo[t.type]:t.getNativeEvent()._eventInfo)?i[e]:null;var i},It.prototype.SetEventInfo=function(t,e,i){if(null!=t&&null!=e){var n=t.getNativeEvent();if(n._eventInfo||(n._eventInfo={}),this.StoreInfoByEventType(e)){var r=t.type;n._eventInfo[r]||(n._eventInfo[r]={}),n._eventInfo[r][e]=i}else n._eventInfo[e]=i}},It.prototype.StoreInfoByEventType=function(t){return t!=It._EVENT_INFO_TOOLTIP_DISPLAYED_KEY},It.prototype.ProcessObjectTooltip=function(t,e,i,n,r){this.GetEventInfo(t,It._EVENT_INFO_TOOLTIP_DISPLAYED_KEY)||this._processShowTooltip(r,n,e,i)&&this.SetEventInfo(t,It._EVENT_INFO_TOOLTIP_DISPLAYED_KEY,!0)},It.prototype._resetExternalKeyboardFocus=function(){this._handleExternalKeyboardFocus=!1},It.prototype.OnFocus=function(t){this._handleExternalKeyboardFocus=!1,this._bKeyDown||t.isPropagationStopped()||(this._handleExternalKeyboardFocus=!0,this._keyboardFocusTimer||(this._keyboardFocusTimer=new ut(this._context,200,this._resetExternalKeyboardFocus,this,1)),this._keyboardFocusTimer.reset(),this._keyboardFocusTimer.start(),t.stopPropagation())},It.prototype.OnBlur=function(t){this._bKeyDown=!1;var e=this.getFocus();e&&e.isShowingKeyboardFocusEffect()&&e.hideKeyboardFocusEffect()},It.prototype.ProcessRolloverEvent=function(t,e,i){},It.prototype.CreateCategoryRolloverHandler=function(t,e){return new Ot(t,e)},It.prototype.GetTouchResponse=function(){return It.TOUCH_RESPONSE_TOUCH_START},It.prototype.isTouchResponseTouchStart=function(){var t=this.GetTouchResponse();if(t===It.TOUCH_RESPONSE_TOUCH_START)return!0;if(t===It.TOUCH_RESPONSE_TOUCH_HOLD)return!1;for(var e=this.getCtx().getSvgDocument().parentElement.parentElement;e;){var i=window.getComputedStyle(e);if("hidden"!==i.overflow&&(e.scrollWidth>e.clientWidth+It._TOUCH_RESPONSE_PADDING_CHECK&&"hidden"!==i["overflow-x"]||e.scrollHeight>e.clientHeight+It._TOUCH_RESPONSE_PADDING_CHECK&&"hidden"!==i["overflow-y"])||window.frameElement&&"IFRAME"==window.frameElement.nodeName)return!1;if("HTML"===e.nodeName)break;e=e.parentElement}return!0},It.prototype._saveTouchStart=function(t,e){this.TouchManager.getTouchIdsForObj(It.TOUCH_RESPONSE_TOUCH_START).length<=1&&(this.TouchManager.saveProcessedTouch(e.identifier,ft.HOVER_TOUCH_KEY,null,ft.HOVER_TOUCH_KEY,ft.HOVER_TOUCH_KEY,this.HandleTouchActionsMove,this.HandleTouchActionsEnd,this),this.HandleTouchActionsStart(t))},It.prototype.HandleTouchActionsStart=function(t){var e=this.GetLogicalObject(t.target),i=t instanceof dt?t.touch:t.touches[0];t instanceof dt||(this._touchMap[i.identifier]||(this._touchMap[i.identifier]={}),this._touchMap[i.identifier][ft.PREV_HOVER_OBJ]=null,e&&this.HandleTouchActionsOver(t),this._touchMap[i.identifier][ft.PREV_HOVER_OBJ]=e),e&&this.ProcessRolloverEvent(t,e,!0),this._processTouchTooltip(t),this._prevActionClear=!1},It.prototype.HandleTouchActionsMove=function(t){var e,i=t instanceof dt?t.touch:t.touches[0];if(t instanceof dt)e=this.GetLogicalObject(t.target);else{t.preventDefault();var n=gt.elementFromTouch(i);e=this.GetLogicalObject(n);var r=this._touchMap[i.identifier][ft.PREV_HOVER_OBJ];if(r!=e){var o;if(r)r.getDisplayable?o=r.getDisplayable():r.getDisplayables&&(o=r.getDisplayables()[0]),o&&(t.target=o,this.HandleTouchActionsOut(t,i));t.target=n,e&&this.HandleTouchActionsOver(t)}this._touchMap[i.identifier][ft.PREV_HOVER_OBJ]=e}e&&this.ProcessRolloverEvent(t,e,!0)},It.prototype.HandleTouchActionsEnd=function(t,e){var i,r;if(t instanceof dt){var o=this.GetLogicalObjectAndDisplayable(t.target);i=o.displayable,r=o.logicalObject,e=t.touch}else{var s;t.preventDefault(),i=gt.elementFromTouch(e),(r=this.GetLogicalObject(i))&&(r.getDisplayable?s=r.getDisplayable():r.getDisplayables&&(s=r.getDisplayables()[0])),s&&(t.target=s,this.HandleTouchActionsOut(t,e)),this._touchMap[e.identifier][ft.PREV_HOVER_OBJ]=null}var a=e.pageX,h=e.pageY;this._processTouchSelection(r,this._component?this._component.hasContextMenu():null),this._processActionPopup(i,new n(a,h))},It.prototype.HandleTouchActionsOver=function(t){var e=this.GetLogicalObject(t.target);e&&this.ProcessRolloverEvent(t,e,!0);var i=this.getSelectionHandler(e);i&&i.processMouseOver(e)},It.prototype.HandleTouchActionsOut=function(t,e){var i=this.GetLogicalObject(t.target);t instanceof dt&&t.touch,i&&this.ProcessRolloverEvent(t,i,!1);var n=this.getSelectionHandler(i);n&&n.processMouseOut(i)},It.prototype.getComponent=function(){return this._component},It.DROP_OFFSET_X_DATA_TYPE="text/_dvtDropOffsetX",It.DROP_OFFSET_Y_DATA_TYPE="text/_dvtDropOffsetY",It.prototype.isDndSupported=function(){return!1},It.prototype.OnDndDragStart=function(t){var e=u.getEventForSyntax(this._context,t),i=e.dataTransfer;if(!(e.dataTransfer.types&&e.dataTransfer.types.length>0)){var n=this._context.pageToStageCoords(t.pageX,t.pageY),r=this.DragSource.getDragTransferable(n.x,n.y),o=this.GetDragSourceType(t);if(null!=r&&null!=o){this._context.getTooltipManager().hideTooltip();var s=this._getDragOptions(t),a=s.dataTypes,h=s.dragStart;if(null!=a||h){var l=this.DragSource.getDragObject();if(this.ProcessSelectionEventHelper(l,!1),l.hideHoverEffect&&l.hideHoverEffect(),null!=a){Array.isArray(a)||(a=[a]);for(var _=this._getDragData(t),p=0;p<a.length;p++)i.setData(a[p],_)}var d=u.getDragFeedback(this.DragSource.getDragOverFeedback(n.x,n.y),this._context.getStage()),g=d.svg,f=this.DragSource.getDragOffset(n.x,n.y);g.style.width=d.width+"px",g.style.height=d.height+"px",g.style.left=t.pageX-f.x+"px",g.style.top=t.pageY-f.y+"px",g.style.position="absolute",g.style.fontFamily=this._context.getDefaultFontFamily(),g.style.fontSize=this._context.getDefaultFontSize(),gt.disableMouseEvents(g),document.body.appendChild(g),c(function(){document.body.removeChild(g)}),i.setDragImage(g,f.x,f.y);var y=this.GetDropOffset(t);if(y&&(i.setData(It.DROP_OFFSET_X_DATA_TYPE,y.x),i.setData(It.DROP_OFFSET_Y_DATA_TYPE,y.y)),h)h(e,this._getDragEventPayload(t))}else this._context.isLastDndEventManager(this)&&t.preventDefault()}else this._context.isLastDndEventManager(this)&&t.preventDefault()}},It.prototype.OnDndDrag=function(t){this._handleDragSourceEvent(t,"drag")},It.prototype.OnDndDragEnd=function(t){this.DragSource.setDragCandidate(null),this._handleDragSourceEvent(t,"dragEnd")},It.prototype.GetDragSourceType=function(t){return null},It.prototype.GetDragDataContexts=function(t){return[]},It.prototype.GetDropOffset=function(t){return null},It.prototype._getDragOptions=function(t){var e=this.GetDragSourceType(t);return this.getComponent().getOptions().dnd.drag[e]},It.prototype._getDragEventPayload=function(t){var e={};return e[this.GetDragSourceType(t)]=this.GetDragDataContexts(),e},It.prototype._getDragData=function(t){return JSON.stringify(this.GetDragDataContexts(!0))},It.prototype._handleDragSourceEvent=function(t,e){if(null!=this.GetDragSourceType(t)){var i=this._getDragOptions(t)[e];if(i)i(u.getEventForSyntax(this._context,t))}},It.prototype.OnDndDragEnter=function(t){this._handleDropTargetEvent(t,"dragEnter",!0)},It.prototype.OnDndDragOver=function(t){this._handleDropTargetEvent(t,"dragOver",!0)},It.prototype.OnDndDragLeave=function(t){this._handleDropTargetEvent(t,"dragLeave",!1)},It.prototype.OnDndDrop=function(t){this._handleDropTargetEvent(t,"drop",!1)},It.prototype.GetDropTargetType=function(t){return null},It.prototype.GetDropEventPayload=function(t){return null},It.prototype.ShowDropEffect=function(t){},It.prototype.ShowRejectedDropEffect=function(t){this.ClearDropEffect()},It.prototype.ClearDropEffect=function(){},It.prototype._getDropOptions=function(t){var e=this.GetDropTargetType(t);return this.getComponent().getOptions().dnd.drop[e]},It.prototype._handleDropTargetEvent=function(t,e,i){var n=this._handleDropTargetEventHelper(t,e);n||t.preventDefault(),!n&&i?this.ShowDropEffect(t):n&&i?this.ShowRejectedDropEffect(t):this.ClearDropEffect()},It.prototype._handleDropTargetEventHelper=function(t,e){if(null==this.GetDropTargetType(t))return!0;var i=u.getEventForSyntax(this._context,t),n=this._getDropOptions(t),r=n[e];if(r){var o=r(i,this.GetDropEventPayload(t));if(t.getNativeEvent().defaultPrevented)return!1;if(null!=o&&!this._context.isCustomElement())return o}var s=n.dataTypes;if(null!=s){Array.isArray(s)||(s=[s]);for(var a=0;a<s.length;a++)if(i.dataTransfer.types&&i.dataTransfer.types.indexOf(s[a])>=0)return!1}return!0},It.prototype.DispatchElementEvent=function(t,e){this.getCtx().getSvgDocument().dispatchEvent(new CustomEvent(t,{detail:e}))};const Nt=function(t,e,i,n){this._customTooltipManager=e,this.Init(t,i,n)};i.createSubclass(Nt,It),Nt.prototype.OnClickInternal=function(t){var e=t.target;this._handleMenuClick(e)},Nt.prototype.HandleImmediateTouchStartInternal=function(t,e){t.blockTouchHold(),this._handleMenuClick(t.target)},Nt.prototype.HandleTouchClickInternal=function(t){var e=t.target;this._handleMenuClick(e)},Nt.prototype._handleMenuClick=function(t){var e=this._customTooltipManager._actionPopupObj,i=t._menu;i&&(this._customTooltipManager.closeActionTooltip(),i.FireActionTooltipItem(e))};const Rt=function(t,e){this.Init(t,e)};i.createSubclass(Rt,i),Rt.prototype.Init=function(t,e){this._context=t,this._id=e,this._actionTooltip=new ct(this._context,this._id+"ActionPopup")},Rt.prototype.GetRichTooltipManager=function(){if(!this._RichTooltipManager){var t=this._id+"Tooltip";this._RichTooltipManager=new pt(this._context,t),this._RichTooltipManager.InitializeTooltipElem();var e=this._RichTooltipManager.GetStoredContext();if(e)new Nt(e,this,null,null).addListeners(this._actionTooltip)}return this._RichTooltipManager},Rt.prototype.clearActionTooltip=function(){this._actionTooltip&&this._actionTooltip.clearContent()},Rt.prototype.getActionTooltip=function(){return this._actionTooltip},Rt.prototype.hideTooltip=function(){this.clearActionTooltip(),this._RichTooltipManager&&this._RichTooltipManager.hideTooltip()},Rt.prototype.closeActionTooltip=function(){var t=yt.newActionTooltipEvent("actionTooltipClosed",this._actionPopupObj);this.FireListener(t),this._actionPopupObj=null,this.hideTooltip()},Rt.prototype.displayActionPopup=function(){var t=this.getActionTooltip();return!(!t||!t.hasMenuItems())},Rt.prototype.startActionPopupAtPosition=function(t,e,i,n){var r=this.getActionTooltip();if(r){this.GetRichTooltipManager().showRichElementAtPosition(t,e,r,!0,!1);var o=yt.newActionTooltipEvent("actionTooltipStarted",i);this.FireListener(o),this._actionPopupObj=i}},Rt.prototype.addTooltipEventListener=function(t,e,i){var n=this._getListeners(t,!0);n.push(e),n.push(i)},Rt.prototype.removeTooltipEventListener=function(t,e,i){var n=this._getListeners(t,!1);if(null!==n)for(var r=0;r<n.length;r+=2)if(n[r]===e&&n[r+1]===i){n.splice(r,2);break}},Rt.prototype._getListeners=function(t,e){if(!this._listenerObj){if(!e)return null;this._listenerObj={}}var i=t,n=this._listenerObj[i];return!n&&e&&(n=[],this._listenerObj[i]=n),n},Rt.prototype.FireListener=function(t){var e=this._getListeners(t.type,!1);if(e)for(var i=0;i<e.length;i+=2){var n=e[i+1];e[i].call(n,t)}},Rt._formatTextString=function(t){var e="";if(!t)return e;var i=(t=t.replace(/\n/g,"<br>")).split("<br>");if(i){for(var n=new Array,r=0;r<i.length;r++){var o=i[r];null!=o&&""!=o&&n.push(o)}for(r=0;r<n.length;r++)e+=n[r],r<n.length-1&&(e+="\n")}return e};const Dt=function(t,e){this._id="mask"+Dt._uniqueSeed++,this._gradient=t,this._bounds=e};i.createSubclass(Dt,i),Dt._uniqueSeed=0,Dt.prototype.getId=function(){return this._id},Dt.prototype.getGradient=function(){return this._gradient},Dt.prototype.getBounds=function(){return this._bounds};const xt=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass(xt,Q),xt._uniqueSeed=0,xt.prototype.Init=function(t,e,i,n,r){xt.superclass.Init.call(this,t,"use",r);var o=n.getId();if(o||(o="use"+xt._uniqueSeed++,n.setId(o)),t.existsGlobalDefReference(o))t.increaseGlobalDefReference(o);else{var s=n.getElem();u.setAttrNullNS(s,"id",o),t.appendDefs(s),t.increaseGlobalDefReference(o)}this._targetId=o,u.setHref(this._elem,u.getUrlPathById(o)),this.setX(e).setY(i)},Q.defineProps(xt,{x:{value:0},y:{value:0}}),xt.prototype.destroy=function(){this.getCtx().decreaseGlobalDefReference(this._targetId),xt.superclass.destroy.call(this)};const Mt=function(t,e,i){var n=e?e+"_svg":null;this._root=u.createSvgDocument(n),t.appendChild(this._root),this._parentDiv=t,this.addSizingSvg(),this._appAriaRole=this._parentDiv.getAttribute("role"),this._role=this._appAriaRole,this._referenceDiv=i,this._defs=A.createElement("defs"),u.appendChildElem(this._root,this._defs),this._keyboardFocusArray=[],this._keyboardFocusIndex=0,this._dndEventManagers=[],this.Init(this._root,e),u.appendChildElem(this._root,this._stage.getElem()),this.oj=null};i.createSubclass(Mt,i),Mt._DEFAULT_FONT_FAMILY="-apple-system, BlinkMacSystemFont, 'Segoe UI', 'Helvetica Neue', Arial, sans-serif",Mt._DEFAULT_FONT_WEIGHT="400",Mt._id=0,Mt.DEFAULT_FONT_SIZE=j.DEFAULT_FONT_SIZE;const wt=Symbol("componentAriaLabel");Mt.prototype.Init=function(t,e){var i=(e||"_dvt"+Mt._id)+"_stage";this._stage=new tt(this,t,i),Mt._id++,this._normalizedFontFamilyCache={},this.setDefaultFontSize(Mt.DEFAULT_FONT_SIZE),this.setDefaultFontFamily(Mt._DEFAULT_FONT_FAMILY),this.setDefaultFontWeight(Mt._DEFAULT_FONT_WEIGHT),this._tooltipManagers=new Object,this._customTooltipManagers=new Object,this._scheduler=null,this._globalDefsMap={}},Mt.prototype.getDefaultFontFamily=function(){return this._defaultFontFamily},Mt.prototype.setDefaultFontFamily=function(t){t&&(this._defaultFontFamily=this._normalizeFontFamily(t),u.setAttrNullNS(this._stage.getElem(),"font-family",this.getDefaultFontFamily()))},Mt.prototype.isDefaultFontFamily=function(t){return!!t&&this._defaultFontFamily===this._normalizeFontFamily(t)},Mt.prototype.getDefaultFontSize=function(){return this._defaultFontSize},Mt.prototype.getThemeBehavior=function(){return e.parseJSONFromFontFamily("oj-theme-json").behavior},Mt.prototype.setDefaultFontSize=function(t){t&&(this._defaultFontSize=t,u.setAttrNullNS(this._stage.getElem(),"font-size",this.getDefaultFontSize()))},Mt.prototype.getDefaultFontWeight=function(){return this._defaultFontWeight},Mt.prototype.setDefaultFontWeight=function(t){t&&(this._defaultFontWeight=t,u.setAttrNullNS(this._stage.getElem(),"font-weight",this.getDefaultFontWeight()))},Mt.prototype._normalizeFontFamily=function(t){var e=this._normalizedFontFamilyCache[t];return e||(e=t.replace(/, /g,",").replace(/"/g,"'"),this._normalizedFontFamilyCache[t]=e),e},Mt.prototype.getStage=function(){return this._stage},Mt.prototype.isReadyToRender=function(){if(this._destroyed)return!1;if(null!=this._parentDiv.offsetParent)return!0;var t=window.getComputedStyle(this._parentDiv);return!(!t||"fixed"!=t.position)&&"none"!=t.display},Mt.prototype.getSvgDocument=function(){return this._root},Mt.prototype.getSizingSvg=function(){return this._sizingSvg},Mt.prototype.addSizingSvg=function(){this._sizingSvg||"blink"!==r.engine&&"safari"!==r.browser||(this._root.style.position="absolute",this._root.style.left="0px",this._root.style.top="0px",this._root.style.padding="inherit",this._sizingSvg=document.createElementNS(u.SVG_NS,"svg"),this._sizingSvg.style.width="100%",this._sizingSvg.style.height="100%",this.getContainer().appendChild(this._sizingSvg))},Mt.prototype.removeSizingSvg=function(){this._sizingSvg&&(this._root.style.removeProperty("position"),this._root.style.removeProperty("left"),this._root.style.removeProperty("top"),this._root.style.removeProperty("padding"),this.getContainer().removeChild(this._sizingSvg),this._sizingSvg=null)},Mt.prototype.setReadingDirection=function(t){this._readingDirection=t},Mt.prototype.getReadingDirection=function(){return this._readingDirection},Mt.prototype.existsGlobalDefReference=function(t){return this._globalDefsMap[t]>0},Mt.prototype.increaseGlobalDefReference=function(t){null!=t&&(this._globalDefsMap[t]?this._globalDefsMap[t]++:this._globalDefsMap[t]=1)},Mt.prototype.decreaseGlobalDefReference=function(t){if(null!=t){var e=this._globalDefsMap[t];e&&(1==e?delete this._globalDefsMap[t]:this._globalDefsMap[t]=e-1),this._globalDefsMap[t]||this.removeDefsById(t)}},Mt.prototype.getTooltipManager=function(t){return t||(t="_dvtTooltip"),t+=this.getStage().getId(),this._tooltipManagers[t]||(this._tooltipManagers[t]=new it(this,t)),this._tooltipManagers[t]},Mt.prototype.hideTooltips=function(){for(var t in this._tooltipManagers)this._tooltipManagers[t].hideTooltip()},Mt.prototype.releaseTooltipResources=function(){for(var t in this._tooltipManagers)this._tooltipManagers[t].releaseTooltipResources()},Mt.prototype.getScheduler=function(){return this._scheduler||(this._scheduler=new et(this)),this._scheduler},Mt.prototype.pageToStageCoords=function(t,e){var i=this.getStageAbsolutePosition(),r=t-i.x,o=e-i.y;return new n(r,o)},Mt.prototype.stageToPageCoords=function(t,e){var i=this.getStageAbsolutePosition(),r=t+i.x,o=e+i.y;return new n(r,o)},Mt.prototype.getStageAbsolutePosition=function(){var t=this._referenceDiv;if(!t){var e=this.getStage().getSVGRoot();t=e.parentNode?e.parentNode:e}var i=r.getElementPosition(t);return new n(parseInt(i.x),parseInt(i.y))},Mt.prototype.isOffscreen=function(t){if(null!=this._bOffscreen&&!t)return this._bOffscreen;var e,i=this.getStage().getSVGRoot();try{var n=i.getBoundingClientRect();e=n.bottom<0||n.right<0||n.top>(window.innerHeight||document.documentElement.clientHeight)||n.left>(window.innerWidth||document.documentElement.clientWidth)}catch(t){e=!0}return t||(this._bOffscreen=e),e},Mt.prototype.resetIsOffscreen=function(){this._bOffscreen=null},Mt.prototype.getCustomTooltipManager=function(t){return t||(t="_dvtCustomTooltip"),t+=this.getStage().getId(),this._customTooltipManagers[t]||(this._customTooltipManagers[t]=new Rt(this,t)),this._customTooltipManagers[t]},Mt.prototype.appendDefs=function(t){u.appendChildElem(this._defs,t)},Mt.prototype.getDefs=function(){return this._defs},Mt.prototype.removeDefs=function(t){t._obj&&t._obj.destroy(),this._defs.removeChild(t)},Mt.prototype.removeDefsById=function(t){for(var e=this._defs.childNodes,i=e.length,n=0;n<i;n++){var r=e[n];if(r.id===t)return void this.removeDefs(r)}},Mt.prototype.getRootAttribute=function(t){return u.getAttrNullNS(this._root,t)},Mt.resetUniqueSeeds=function(){D._counter=0,p._uniqueSeed=0,A._uniqueSeed=0,Dt._uniqueSeed=0,xt._uniqueSeed=0,r._bInitialized=!1},Mt.resetCaches=function(){st.clearCaches()},Mt.prototype.setActiveElement=function(t){this._activeElement&&(u.removeAttrNullNS(this._activeElement.getElem(),"id"),this._activeElement=null);var e=t.getElem(),i=u.getAttrNullNS(e,"id");i||(i=Mt._generateActiveElementId(t),u.setAttrNullNS(e,"id",i),this._activeElement=t),t.applyAriaProperties(),"application"==this._role&&this._parentDiv.setAttribute("aria-activedescendant",i)},Mt._generateActiveElementId=function(t){var e="_dvtActiveElement"+(r.isEnvironmentTest()?"":Math.floor(1e9*Math.random())),i=t.getId();return"string"==typeof i||i instanceof String||"number"==typeof i||i instanceof Number?e+"_"+i:e},Mt.prototype.setAriaLabel=function(t){this._parentDiv.getAttribute("aria-label")&&!this._parentDiv[wt]||(this._parentDiv[wt]=!0,t?this._parentDiv.setAttribute("aria-label",O.processAriaLabel(t)):this._parentDiv.removeAttribute("aria-label"))},Mt.prototype.setAriaRole=function(t){this._appAriaRole||(t?this._parentDiv.setAttribute("role",t):this._parentDiv.removeAttribute("role"),this._role=t)},Mt.prototype.setTooltipAttachedCallback=function(t){this._tooltipAttachedCallback=t},Mt.prototype.getTooltipAttachedCallback=function(){return this._tooltipAttachedCallback},Mt.prototype.resetCurrentKeyboardFocus=function(t){this._keyboardFocusArray&&0!==this._keyboardFocusArray.length&&(t.keyCode==P.TAB&&t.shiftKey?this.setCurrentKeyboardFocus(this._keyboardFocusArray[this._keyboardFocusArray.length-1]):t.keyCode==P.TAB&&this.setCurrentKeyboardFocus(this._keyboardFocusArray[0]))},Mt.prototype.setKeyboardFocusArray=function(t){(this._keyboardFocusArray=t,this._keyboardFocusIndex=0,t.length>0)&&(this._root.parentNode._currentObj=this._keyboardFocusArray[this._keyboardFocusIndex])},Mt.prototype.getCurrentKeyboardFocus=function(){return this._keyboardFocusArray.length<=this._keyboardFocusIndex?null:this._keyboardFocusArray[this._keyboardFocusIndex]},Mt.prototype.setCurrentKeyboardFocus=function(t){var e=this._keyboardFocusArray.indexOf(t);if(-1==e)return!1;var i=this._keyboardFocusArray[e];return this._keyboardFocusIndex=e,this._root.parentNode._currentObj=i,!0},Mt.prototype.nextKeyboardFocus=function(){var t=this._keyboardFocusArray[this._keyboardFocusIndex+1];return t?(this._keyboardFocusIndex++,this._root.parentNode._currentObj=t,t):null},Mt.prototype.previousKeyboardFocus=function(){var t=this._keyboardFocusArray[this._keyboardFocusIndex-1];return t?(this._keyboardFocusIndex--,this._root.parentNode._currentObj=t,t):null},Mt.prototype.getNumberConverter=function(t){var e=this.getLocaleHelpers();return e.createNumberConverter?e.createNumberConverter(t):null},Mt.prototype.getLocaleHelpers=function(){return this._localeHelpers?this._localeHelpers:{}},Mt.prototype.setLocaleHelpers=function(t){this._localeHelpers=t},Mt.requestAnimationFrame=c,Mt.cancelAnimationFrame=_,Mt.prototype.getContainer=function(){return this._parentDiv},Mt.prototype.createOverlayDiv=function(){var t=document.createElement("div");return t.style.top="-100%",t.style.position="relative",t},Mt.prototype.setOverlayAttachedCallback=function(t){this._overlayAttachedCallback=t},Mt.prototype.getOverlayAttachedCallback=function(){return this._overlayAttachedCallback},Mt.prototype.addDndEventManager=function(t){this._dndEventManagers.push(t)},Mt.prototype.removeDndEventManager=function(t){var e=this._dndEventManagers.indexOf(t);this._dndEventManagers.splice(e,1)},Mt.prototype.isLastDndEventManager=function(t){return this._dndEventManagers[this._dndEventManagers.length-1]===t},Mt.prototype.setFixContextCallback=function(t){this._fixContextCallback=t},Mt.prototype.fixRendererContext=function(t){return this._fixContextCallback?this._fixContextCallback(t):t},Mt.prototype.setCustomElement=function(t){this._customElement=t},Mt.prototype.isCustomElement=function(){return this._customElement},Mt.prototype.destroy=function(){this._destroyed=!0},Mt.prototype.setJetProperties=function(t){this._jetProps=t,Object.assign(this,t)},Mt.prototype.getJetProperties=function(){return this._jetProps},Mt.prototype.createContext=function(t,e,i){var n=new Mt(t,e,i);return n.setJetProperties(this.getJetProperties()),n};const Lt=function(){this.Init()};i.createSubclass(Lt,i),Lt.linear=function(t){return t},Lt.quadraticIn=function(t){return Lt.PolyIn(t,2)},Lt.quadraticOut=function(t){return Lt.PolyOut(t,2)},Lt.quadraticInOut=function(t){return Lt.PolyInOut(t,2)},Lt.cubicIn=function(t){return Lt.PolyIn(t,3)},Lt.cubicOut=function(t){return Lt.PolyOut(t,3)},Lt.cubicInOut=function(t){return Lt.PolyInOut(t,3)},Lt.backOut=function(t,e){return e||(e=1.70158),1-(t=1-t)*t*((e+1)*t-e)},Lt.backIn=function(t,e){return e||(e=1.70158),t*t*((e+1)*t-e)},Lt.elasticIn=function(t,e,i){return t<=0||t>=1?t:(i||(i=.45),!e||e<1?(e=1,n=i/4):n=i/(2*Math.PI)*Math.asin(1/e),-e*Math.pow(2,10*(t-=1))*Math.sin((t-n)*(2*Math.PI)/i));var n},Lt.elasticOut=function(t,e,i){return 1-Lt.elasticIn(1-t,e,i)},Lt.PolyIn=function(t,e){return t<0?0:t>1?1:Math.pow(t,e)},Lt.PolyOut=function(t,e){return t<0?0:t>1?1:1-Math.pow(1-t,e)},Lt.PolyInOut=function(t,e){return t<0?0:t>1?1:t<.5?.5*Math.pow(2*t,e):.5*(2-Math.pow(2*(1-t),e))},Lt.prototype.Init=function(){};const Pt=function(){this.Init()};i.createSubclass(Pt,i),Pt.TYPE_NUMBER="typeNumber",Pt.TYPE_MATRIX="typeMatrix",Pt.TYPE_NUMBER_ARRAY="typeNumberArray",Pt.TYPE_COLOR="typeColor",Pt.TYPE_COLOR_ARRAY="typeColorArray",Pt.TYPE_GROW_POLYLINE="typeGrowPolyline",Pt.TYPE_RECTANGLE="typeRectangle",Pt.TYPE_POINT="typePoint",Pt.TYPE_PATH="typePath",Pt.TYPE_GROW_PATH="typeGrowPath",Pt.TYPE_FILL="typeFill",Pt.TYPE_STROKE="typeStroke",Pt.TYPE_POLYLINE="typePolyline",Pt.interpolate=function(t,e,i,n,r){var o=Pt._getInterpolator(e);return o?o(t,i,n,r):n},Pt._getInterpolator=function(t){return Pt._map[t]},Pt.InterpolateNumber=function(t,e,i,n){return S.interpolateNumber(e,i,n)},Pt.InterpolateNumberArray=function(t,e,i,n){for(var r=e.length,o=i.length,s=[],a=0;a<Math.max(r,o);a++){var h,l;h=a<r?e[a]:e[r-1],l=a<o?i[a]:i[o-1],s.push(Pt.InterpolateNumber(t,h,l,n))}return s},Pt.InterpolateMatrix=function(t,e,i,n){var r=Pt.InterpolateNumber(t,e.getA(),i.getA(),n),o=Pt.InterpolateNumber(t,e.getB(),i.getB(),n),s=Pt.InterpolateNumber(t,e.getC(),i.getC(),n),a=Pt.InterpolateNumber(t,e.getD(),i.getD(),n),h=Pt.InterpolateNumber(t,e.getTx(),i.getTx(),n),u=Pt.InterpolateNumber(t,e.getTy(),i.getTy(),n);return new l(r,o,s,a,h,u)},Pt.InterpolateColor=function(t,e,i,n){return T.interpolateColor(e,i,n)},Pt.InterpolateColorArray=function(t,e,i,n){for(var r=e.length,o=i.length,s=[],a=0;a<Math.max(r,o);a++){var h,l;h=a<r?e[a]:e[r-1],l=a<o?i[a]:i[o-1],s.push(Pt.InterpolateColor(t,h,l,n))}return s},Pt.InterpolateGrowPolyline=function(t,e,i,n){if(0===n)return[i[0],i[1]];if(1===n)return i;for(var r,o=i.length,s=[i[0],i[1]],a=n*Pt.CalcPolylineLength(i),h=0,l=2;l<o-1;l+=2){var u=i[l-2],c=i[l-1],_=i[l],p=i[l+1];if(h+(r=Pt.CalcPolylineLength([u,c,_,p]))>a){var d=(a-h)/r,g=_-u,f=p-c;s.push(u+d*g),s.push(c+d*f);break}h+=r,s.push(_),s.push(p)}return s},Pt.InterpolateGrowPath=function(t,e,i,n){if(0===n)return[i[0],i[1]];if(1===n)return i;for(var r,o,s,a,h,l,u,c,_,p=i.length,d=[],g=n*Pt.CalcPathLength(i),f=0,y=0;y<p;y++){var v,S=i[y];switch(S){case"M":v=[c=o=i[++y],_=s=i[++y],c,_];break;case"L":v=[c,_,o=i[++y],s=i[++y]];break;case"Q":a=i[++y],h=i[++y],v=[c,_,o=i[++y],s=i[++y]];break;case"C":a=i[++y],h=i[++y],l=i[++y],u=i[++y],v=[c,_,o=i[++y],s=i[++y]]}if(f+(r=Pt.CalcPolylineLength(v))>g){var T=(g-f)/r;switch(d.push(S),S){case"Q":d.push(c+T*(a-c),_+T*(h-_));break;case"C":d.push(c+T*(a-c),_+T*(h-_),c+T*(l-c),_+T*(u-_))}d.push(c+T*(o-c),_+T*(s-_));break}switch(f+=r,d.push(S),S){case"Q":d.push(a,h);break;case"C":d.push(a,h,l,u)}d.push(o),d.push(s),c=o,_=s}return d},Pt.CalcPolylineLength=function(t){for(var e,i,n,r,o=0,s=0;s<t.length;s+=2){if(n=t[s],r=t[s+1],s>0)if(n===e)o+=Math.abs(r-i);else if(r===i)o+=Math.abs(n-e);else{var a=Math.abs(n-e),h=Math.abs(r-i);o+=Math.sqrt(a*a+h*h)}e=n,i=r}return o},Pt.CalcPathLength=function(t){for(var e,i,n,r,o=0,s=0;s<t.length;){switch(t[s]){case"M":e=n=t[s+1],i=r=t[s+2],s+=3;continue;case"L":n=t[s+1],r=t[s+2],s+=3;break;case"Q":n=t[s+3],r=t[s+4],s+=5;break;case"C":n=t[s+5],r=t[s+6],s+=7}if(s>0)if(n===e)o+=Math.abs(r-i);else if(r===i)o+=Math.abs(n-e);else{var a=Math.abs(n-e),h=Math.abs(r-i);o+=Math.sqrt(a*a+h*h)}e=n,i=r}return o},Pt.InterpolateRectangle=function(t,e,i,n){var r=Pt.InterpolateNumber(t,e.x,i.x,n),o=Pt.InterpolateNumber(t,e.y,i.y,n),s=Pt.InterpolateNumber(t,e.w,i.w,n),a=Pt.InterpolateNumber(t,e.h,i.h,n);return new m(r,o,s,a)},Pt.InterpolatePoint=function(t,e,i,r){var o=Pt.InterpolateNumber(t,e.x,i.x,r),s=Pt.InterpolateNumber(t,e.y,i.y,r);return new n(o,s)},Pt.InterpolatePath=function(t,e,i,n){var r=e.length,o=i.length;if(r!=o)return i;for(var s=[],a=0,h=0;a<r&&h<o;){var l=e[a],u=i[h],c=!isNaN(l),_=!isNaN(u);c||_?c&&_&&s.push(Pt.InterpolateNumber(t,l,u,n)):l===u&&s.push(l),a++,h++}return s},Pt.InterpolateFill=function(t,e,i,n){if(e instanceof K&&i instanceof K){var r=Pt.InterpolateColor(t,e.getColor(),i.getColor(),n),o=Pt.InterpolateNumber(t,e.getAlpha(),i.getAlpha(),n);return new K(r,o)}return i},Pt.InterpolateStroke=function(t,e,i,n){if(e instanceof z&&i instanceof z){var r=Pt.InterpolateColor(t,e.getColor(),i.getColor(),n),o=Pt.InterpolateNumber(t,e.getAlpha(),i.getAlpha(),n),s=Pt.InterpolateNumber(t,e.getWidth(),i.getWidth(),n);return new z(r,o,s,i.isFixedWidth(),i.getDashProps(),i.getLineProps())}return i},Pt.InterpolatePolyline=function(t,e,i,n){for(var r=e.length,o=i.length,s=[],a=0;a<Math.max(r,o);a++){var h,l,u=2;a%2==1&&(u=1),h=a<r?e[a]:e[r-u],l=a<o?i[a]:i[o-u],s.push(Pt.InterpolateNumber(t,h,l,n))}if(o<r){var c=s.length,_=s[c-2],p=s[c-1];for(a=c-4;a>=0;a-=2){var d=s[a],g=s[a+1];if(d!=_||g!=p)break;s.splice(a,2)}}return s},Pt.prototype.Init=function(){},(Pt._map={})[Pt.TYPE_NUMBER]=Pt.InterpolateNumber,Pt._map[Pt.TYPE_MATRIX]=Pt.InterpolateMatrix,Pt._map[Pt.TYPE_NUMBER_ARRAY]=Pt.InterpolateNumberArray,Pt._map[Pt.TYPE_COLOR]=Pt.InterpolateColor,Pt._map[Pt.TYPE_COLOR_ARRAY]=Pt.InterpolateColorArray,Pt._map[Pt.TYPE_GROW_POLYLINE]=Pt.InterpolateGrowPolyline,Pt._map[Pt.TYPE_RECTANGLE]=Pt.InterpolateRectangle,Pt._map[Pt.TYPE_POINT]=Pt.InterpolatePoint,Pt._map[Pt.TYPE_PATH]=Pt.InterpolatePath,Pt._map[Pt.TYPE_GROW_PATH]=Pt.InterpolateGrowPath,Pt._map[Pt.TYPE_FILL]=Pt.InterpolateFill,Pt._map[Pt.TYPE_STROKE]=Pt.InterpolateStroke,Pt._map[Pt.TYPE_POLYLINE]=Pt.InterpolatePolyline;var Ht=function(t,e,i){this.type=t,this.setter=e,this.destVal=i,this.startVal=null};const Ft=function(t,e,i,n){this._context=t,this._scheduler=t.getScheduler(),this._duration=e||.5,this._delay=i||0,this.setEasing(n),this._bRunning=!1,this._startTime=null,this._progress=0,this._state=0,this._onInit=null,this._onInitObj=null,this._onEnd=null,this._onEndObj=null,this._context=t,this._props=new Map};Ft.TYPE_NUMBER=Pt.TYPE_NUMBER,Ft.TYPE_MATRIX=Pt.TYPE_MATRIX,Ft.TYPE_NUMBER_ARRAY=Pt.TYPE_NUMBER_ARRAY,Ft.TYPE_COLOR=Pt.TYPE_COLOR,Ft.TYPE_COLOR_ARRAY=Pt.TYPE_COLOR_ARRAY,Ft.TYPE_GROW_POLYLINE=Pt.TYPE_GROW_POLYLINE,Ft.TYPE_RECTANGLE=Pt.TYPE_RECTANGLE,Ft.TYPE_POINT=Pt.TYPE_POINT,Ft.TYPE_PATH=Pt.TYPE_PATH,Ft.TYPE_GROW_PATH=Pt.TYPE_GROW_PATH,Ft.TYPE_FILL=Pt.TYPE_FILL,Ft.TYPE_STROKE=Pt.TYPE_STROKE,Ft.TYPE_POLYLINE=Pt.TYPE_POLYLINE,Ft.prototype.addProp=function(t,e,i,n,r){var o=this._getPropItem(e,i);o?o.destVal=r:(o=new Ht(t,n,r),this._setPropItem(e,i,o))},Ft.prototype.getDestVal=function(t,e,i){var n=this._getPropItem(t,e);return n?n.destVal:i?e.call(t):null},Ft.prototype.setEasing=function(t){this._easing=t||Lt.cubicInOut},Ft.prototype.getOnEnd=function(){return[this._onEnd,this._onEndObj]},Ft.prototype.setOnEnd=function(t,e){this._onEnd=t,this._onEndObj=e||null},Ft.prototype.getOnInit=function(){return[this._onInit,this._onInitObj]},Ft.prototype.setOnInit=function(t,e){this._onInit=t,this._onInitObj=e||null},Ft.prototype.isRunning=function(){return this._bRunning},Ft.prototype.play=function(t){t?this._play():this._animationRequestId=Mt.requestAnimationFrame(i.createCallback(this,this._play))},Ft.prototype.processTime=function(t){if(this._bRunning){var e=t-this._startTime;if(e<0)return!1;var i=1e3*this._getTotalDuration(),n=1;0!=i&&(n=e/i),n>1&&(n=1),this._processStep(n);var r=n>=1;return r&&this._processEnd(),r}},Ft.prototype.stop=function(t){this._animationRequestId&&(Mt.cancelAnimationFrame(this._animationRequestId),this._animationRequestId=null),this._scheduler.removeScheduled(this),t&&this._processStep(1),this._processEnd()},Ft.prototype._getPropItem=function(t,e){var i=this._props.get(t);return i?i.get(e):null},Ft.prototype._setPropItem=function(t,e,i){var n=this._props.get(t);n||(n=new Map,this._props.set(t,n)),n.set(e,i)},Ft.prototype._getTotalDuration=function(){return this._delay+this._duration},Ft.prototype._play=function(){this._bRunning||(this._bRunning=!0,this._processPlay(),this._scheduler.addScheduled(this)),this._context.isOffscreen()&&this.stop(!0),this._animationRequestId=null},Ft.prototype._processEnd=function(){this._bRunning&&(this._bRunning=!1,this._progress=1,this._state=1),this._onEnd&&!this._ended&&(this._onEnd.call(this._onEndObj),this._ended=!0)},Ft.prototype._processInitialize=function(){this._onInit&&this._onInit.call(this._onInitObj),this._props.forEach(function(t,e){t.forEach(function(t,i){t.startVal=i.call(e)})}),this._state=1},Ft.prototype._processPlay=function(){if(0==this._state&&this._processInitialize(),1==this._state)this._startTime=(new Date).getTime(),this._bRunning=!0,this._progress=0;else{var t=1e3*this._progress*this._getTotalDuration();this._startTime=(new Date).getTime()-t}this._state=2},Ft.prototype._processStep=function(t){this._progress=t;var e=t;if(this._delay>0){var i=this._delay/this._getTotalDuration(),n=1-i;e=0===n?.5:Math.min(1,(t-i)/n)}if(e>=0){this._easing&&(e=this._easing(e));var r=this._context;this._props.forEach(function(t,i){t.forEach(function(t,n){var o=Pt.interpolate(r,t.type,t.startVal,t.destVal,e);t.setter.call(i,o)})})}};const kt=function(t){this.Init(t)};i.createSubclass(kt,i),kt.appendOnEnd=function(t,e,i){if(t&&e){var n=t.getOnEnd();if(n&&n[0]){t.setOnEnd(function(){n[0].call(n[1]),e.call(i)})}else t.setOnEnd(e,i)}},kt.prependOnInit=function(t,e,i){if(t&&e&&t.getOnInit&&t.setOnInit){var n=t.getOnInit();if(n&&n[0]){t.setOnInit(function(){e.call(i),n[0].call(n[1])})}else t.setOnInit(e,i)}},kt.prototype.Init=function(t){this.Context=t,this._onEnd=null,this._onEndObj=null},kt.prototype.setOnEnd=function(t,e){this._onEnd=t,this._onEndObj=e||null,this.OnEndUpdated()},kt.prototype.CallOnEnd=function(){this._onEnd&&!this._ended&&(this._onEnd.call(this._onEndObj),this._ended=!0)},kt.prototype.getOnEnd=function(){return[this._onEnd,this._onEndObj]},kt.prototype.OnEndUpdated=function(){},kt.prototype.getDuration=function(){return 0},kt.prototype.initialize=function(){},kt.prototype.play=function(t){},kt.prototype.stop=function(t){};const Gt=function(t){var e;arguments&&arguments.length>1&&arguments[1]instanceof Array?e=arguments[1]:(e=[].slice.call(arguments)).splice(0,1),this.Init(t,e)};i.createSubclass(Gt,kt),Gt.prototype.Init=function(t,e){Gt.superclass.Init.call(this,t),this._runningCounter=0,this._arPlayables=e||[],this._bStarted=!1},Gt.prototype.getDuration=function(){for(var t=0,e=0;e<this._arPlayables.length;e++){var i=this._arPlayables[e];i instanceof kt&&(t=Math.max(t,i.getDuration()))}return t},Gt.prototype.initialize=function(){for(var t=0;t<this._arPlayables.length;t++)this._arPlayables[t]instanceof kt&&this._arPlayables[t].initialize()},Gt.prototype.play=function(t){this._arPlayables.length>0?t?this._play():(this.initialize(),this._animationRequestId=Mt.requestAnimationFrame(i.createCallback(this,this._play))):this._animationRequestId=Mt.requestAnimationFrame(i.createCallback(this,this.DoEnd))},Gt.prototype._play=function(){var t;if(!this._bStarted)for(var e=0;e<this._arPlayables.length;e++)(t=this._arPlayables[e])instanceof kt&&(this._runningCounter++,kt.appendOnEnd(t,this.OnPlayableEnd,this));for(e=0;e<this._arPlayables.length;e++)(t=this._arPlayables[e])instanceof kt&&t.play(!0);this._bStarted=!0,this._animationRequestId=null},Gt.prototype.stop=function(t){if(this._animationRequestId)return Mt.cancelAnimationFrame(this._animationRequestId),void this.DoEnd();for(var e,i=0;i<this._arPlayables.length;i++)(e=this._arPlayables[i])instanceof kt&&e.stop(t)},Gt.prototype.OnPlayableEnd=function(){this._runningCounter--,this._runningCounter<1&&this.DoEnd()},Gt.prototype.DoEnd=function(){this.CallOnEnd(),this._animationRequestId=null};const Bt=function(t){var e;arguments&&arguments.length>1&&arguments[1]instanceof Array?e=arguments[1]:(e=[].slice.call(arguments)).splice(0,1),this.Init(t,e)};i.createSubclass(Bt,kt),Bt.prototype.Init=function(t,e){Bt.superclass.Init.call(this,t),this._arPlayables=e||[],this._currIndex=-1,this._bStarted=!1},Bt.prototype.getDuration=function(){for(var t=0,e=0;e<this._arPlayables.length;e++){var i=this._arPlayables[e];i instanceof kt&&(t+=i.getDuration())}return t},Bt.prototype.initialize=function(){this._arPlayables.length>0&&this._arPlayables[0]instanceof kt&&this._arPlayables[0].initialize()},Bt.prototype.play=function(t){this._arPlayables&&this._arPlayables.length>0?t?this._play():(this.initialize(),this._animationRequestId=Mt.requestAnimationFrame(i.createCallback(this,this._play))):this._animationRequestId=Mt.requestAnimationFrame(i.createCallback(this,this.DoEnd))},Bt.prototype._play=function(){if(this._bStarted){var t=this._arPlayables[this._currIndex];t instanceof kt&&t.play(!0)}else{var e,i,n;this._arPlayables[0]instanceof kt&&(e=this._arPlayables[0]),this._arPlayables[this._arPlayables.length-1]instanceof kt&&(i=this._arPlayables[this._arPlayables.length-1]);for(var r=0;r<this._arPlayables.length-1;r++)(n=this._arPlayables[r])instanceof kt&&kt.appendOnEnd(n,this.DoSequenceStep,this);i&&kt.appendOnEnd(i,this.DoEnd,this),this._bStarted=!0,this._currIndex=0,e&&e.play(!0),this._animationRequestId=null}},Bt.prototype.DoSequenceStep=function(){var t=this._arPlayables[++this._currIndex];t instanceof kt?t.play(!0):this.DoSequenceStep()},Bt.prototype.stop=function(t){if(this._animationRequestId)return Mt.cancelAnimationFrame(this._animationRequestId),void this.DoEnd();if(this._arPlayables)for(var e,i=this._currIndex;i<this._arPlayables.length;i++)(e=this._arPlayables[i])&&e instanceof kt&&e.stop(t)},Bt.prototype.DoEnd=function(){this.CallOnEnd(),this._animationRequestId=null};const Ut=function(t,e,i,n){this.Init(t,e,i,n)};i.createSubclass(Ut,kt),Ut.EASING_LINEAR=1,Ut.EASING_CUBIC_IN_OUT=2,Ut.EASING_CUBIC_IN=3,Ut.EASING_CUBIC_OUT=4,Ut.EASING_QUADRATIC_IN_OUT=5,Ut.EASING_QUADRATIC_IN=6,Ut.EASING_QUADRATIC_OUT=7,Ut.EASING_BOUNCE_IN=8,Ut.EASING_BOUNCE_OUT=9,Ut.EASING_ELASTIC_IN=10,Ut.EASING_ELASTIC_OUT=11,Ut.DIR_C=1,Ut.DIR_N=2,Ut.DIR_NE=3,Ut.DIR_E=4,Ut.DIR_SE=5,Ut.DIR_S=6,Ut.DIR_SW=7,Ut.DIR_W=8,Ut.DIR_NW=9,Ut.AXIS_X=1,Ut.AXIS_Y=2,Ut.ROT_DIR_CLOCKWISE=1,Ut.ROT_DIR_COUNTERCLOCKWISE=2,Ut.GetEasingFunction=function(t){switch(t){case Ut.EASING_LINEAR:return Lt.linear;case Ut.EASING_CUBIC_IN:return Lt.cubicIn;case Ut.EASING_CUBIC_OUT:return Lt.cubicOut;case Ut.EASING_QUADRATIC_IN_OUT:return Lt.quadraticInOut;case Ut.EASING_QUADRATIC_IN:return Lt.quadraticIn;case Ut.EASING_QUADRATIC_OUT:return Lt.quadraticOut;case Ut.EASING_BOUNCE_IN:return Lt.backIn;case Ut.EASING_BOUNCE_OUT:return Lt.backOut;case Ut.EASING_ELASTIC_IN:return Lt.elasticIn;case Ut.EASING_ELASTIC_OUT:return Lt.elasticOut;case Ut.EASING_CUBIC_IN_OUT:default:return Lt.cubicInOut}},Ut.GetCompassPoint=function(t,e){switch(e){case Ut.DIR_N:return new n(t.x+.5*t.w,t.y);case Ut.DIR_NE:return new n(t.x+t.w,t.y);case Ut.DIR_E:return new n(t.x+t.w,t.y+.5*t.h);case Ut.DIR_SE:return new n(t.x+t.w,t.y+t.h);case Ut.DIR_S:return new n(t.x+.5*t.w,t.y+t.h);case Ut.DIR_SW:return new n(t.x,t.y+t.h);case Ut.DIR_W:return new n(t.x,t.y+.5*t.h);case Ut.DIR_NW:return new n(t.x,t.y);case Ut.DIR_C:default:return new n(t.x+.5*t.w,t.y+.5*t.h)}},Ut.GetAlignCompassPoint=function(t,e,i){var r=Ut.GetCompassPoint(e,i);switch(i){case Ut.DIR_N:return new n(r.x-.5*t.w,r.y);case Ut.DIR_NE:return new n(r.x-t.w,r.y);case Ut.DIR_E:return new n(r.x-t.w,r.y-.5*t.h);case Ut.DIR_SE:return new n(r.x-t.w,r.y-t.h);case Ut.DIR_S:return new n(r.x-.5*t.w,r.y-t.h);case Ut.DIR_SW:return new n(r.x,r.y-t.h);case Ut.DIR_W:return new n(r.x,r.y-.5*t.h);case Ut.DIR_NW:return new n(r.x,r.y);case Ut.DIR_C:default:return new n(r.x-.5*t.w,r.y-.5*t.h)}},Ut.prototype.Init=function(t,e,i,n){Ut.superclass.Init.call(this,t),this._context=t,this._arObjects=e instanceof Array?e:[e],this._duration=i||.5,this._delay=n||0,this._easing=Ut.EASING_CUBIC_IN_OUT,this._bInitialized=!1,this._bSaveAndRestoreOriginalMatrices=!1,this._origMatrixArray=null,this._bHideObjectsOnEnd=!1,this.CreateAnimator(t)},Ut.prototype.GetContext=function(){return this._context},Ut.prototype.isRunning=function(){return!!this._animator&&this._animator.isRunning()},Ut.prototype.initialize=function(){this._bInitialized||(this._initializeEndStates(this._arObjects),this._initializeStartStates(this._arObjects),this.InitializePlay(),this._bInitialized=!0)},Ut.prototype.play=function(t){this.initialize(),this._animator&&this._animator.play(t)},Ut.prototype.stop=function(t){this._animator&&this._animator.stop(t)},Ut.prototype.getDuration=function(){return this._duration},Ut.prototype.setEasing=function(t){this._easing=t,this._animator&&this._animator.setEasing(Ut.GetEasingFunction(this._easing))},Ut.prototype.CreateAnimator=function(t){this._animator=new Ft(t,this._duration,this._delay,Ut.GetEasingFunction(this._easing)),this._animator.setOnEnd(this.OnAnimEnd,this)},Ut.prototype.OnAnimEnd=function(){this._bHideObjectsOnEnd&&this.SetObjectsVisible(!1),this._bSaveAndRestoreOriginalMatrices&&this.RestoreOriginalMatrices(),this.CallOnEnd()},Ut.prototype.InitializePlay=function(){},Ut.prototype._initializeStartStates=function(t){if(t)for(var e,i=0;i<t.length;i++)(e=t[i])&&(this._bSaveAndRestoreOriginalMatrices&&(this._origMatrixArray||(this._origMatrixArray=[]),this._origMatrixArray.push(e.getMatrix())),this.InitStartState(e))},Ut.prototype._initializeEndStates=function(t){if(t)for(var e,i=0;i<t.length;i++)(e=t[i])&&this.InitEndState(e)},Ut.prototype.InitStartState=function(t){},Ut.prototype.InitEndState=function(t){},Ut.prototype.SetObjectsVisible=function(t){if(this._arObjects)for(var e,i=this._arObjects.length-1;i>=0;i--)(e=this._arObjects[i])&&e.setVisible(t)},Ut.prototype.RestoreOriginalMatrices=function(){if(this._arObjects)for(var t,e=this._arObjects.length-1;e>=0;e--)(t=this._arObjects[e])&&this._origMatrixArray&&t.setMatrix(this._origMatrixArray.pop())};const Yt=function(t,e,i,n){this.Init(t,e,i,n)};i.createSubclass(Yt,Ut),Yt.prototype.Init=function(t,e,i,n){Yt.superclass.Init.call(this,t,e,i,n)},Yt.prototype.InitStartState=function(t){t.setAlpha(0)},Yt.prototype.InitEndState=function(t){this._animator.addProp(Ft.TYPE_NUMBER,t,t.getAlpha,t.setAlpha,1)};const Wt=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass(Wt,Ut),Wt.prototype.Init=function(t,e,i,r,o){this._arOffsets=i instanceof Array?i:i instanceof n?[i]:[new n(0,0)],this._currIndex=0,Wt.superclass.Init.call(this,t,e,r,o)},Wt.prototype.InitEndState=function(t){var e;e=this._currIndex<this._arOffsets.length?this._arOffsets[this._currIndex]:this._arOffsets[this._arOffsets.length-1],this._animator.addProp(Ft.TYPE_NUMBER,t,t.getTranslateX,t.setTranslateX,t.getTranslateX()+e.x),this._animator.addProp(Ft.TYPE_NUMBER,t,t.getTranslateY,t.setTranslateY,t.getTranslateY()+e.y),this._currIndex++};const Vt=function(t,e,i,n,r,o,s){this.Init(t,e,i,n,r,o,s)};i.createSubclass(Vt,Yt),Vt.prototype.Init=function(t,e,i,n,r,o,s){this._boundsRect=i,this._direction=n||Ut.DIR_NW,this._minScale=r||.5,Vt.superclass.Init.call(this,t,e,o,s),this._bSaveAndRestoreOriginalMatrices=!0},Vt.prototype.InitStartState=function(t){Vt.superclass.InitStartState.call(this,t);var e=this._minScale*t.getScaleX(),i=this._minScale*t.getScaleY(),n=t.getDimensions(),r=new m(0,0,e*n.w,i*n.h),o=Ut.GetAlignCompassPoint(r,this._boundsRect,this._direction);t.setTranslate(o.x,o.y),t.setScale(e,i)},Vt.prototype.InitEndState=function(t){Vt.superclass.InitEndState.call(this,t);var e=t.getMatrix();this._animator.addProp(Ft.TYPE_MATRIX,t,t.getMatrix,t.setMatrix,e)};const jt=function(t,e,i,n){this.Init(t,e,i,n)};i.createSubclass(jt,Ut),jt.prototype.Init=function(t,e,i,n){jt.superclass.Init.call(this,t,e,i,n)},jt.prototype.InitEndState=function(t){this._animator.addProp(Ft.TYPE_NUMBER,t,t.getAlpha,t.setAlpha,0)};const Kt=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass(Kt,Gt),Kt.prototype.Init=function(t,e,i,n,r){n||(n=.5),r||(r=0);var o=new jt(t,e,n,r),s=new Yt(t,i,n,.5*o.getDuration()+r);Kt.superclass.Init.call(this,t,[o,s])};const zt=function(t,e,i,n,r,o,s){this.Init(t,e,i,n,r,o,s)};i.createSubclass(zt,Gt),zt.prototype.Init=function(t,e,i,n,r,o,s){o||(o=.5),s||(s=0);var a=new Wt(t,e,n,o,s),h=new Wt(t,i,r,o,s);zt.superclass.Init.call(this,t,[a,h])};const Xt=function(t,e,i,n,r,o,s,a,h){this.Init(t,e,i,n,r,o,s,a,h)};i.createSubclass(Xt,Gt),Xt.prototype.Init=function(t,e,i,n,r,o,s,a,h){r||(r=Ut.DIR_NE),o||(o=Ut.DIR_NW),s||(s=.5),a||(a=.5),h||(h=0);var l=new Vt(t,i,n,o,s,a,.3+h);Xt.superclass.Init.call(this,t,[null,l])};const qt=function(){};i.createSubclass(qt,i),qt.ALPHA_FADE="alphaFade",qt.SLIDE_TO_RIGHT="slideToRight",qt.SLIDE_TO_LEFT="slideToLeft",qt.ZOOM="zoom",qt.isSupported=function(t){return t==qt.ALPHA_FADE||t==qt.SLIDE_TO_RIGHT||t==qt.SLIDE_TO_LEFT||t==qt.ZOOM},qt.getInAnimation=function(t,e,i,r,o){return e==qt.ALPHA_FADE?new Yt(t,i,o):e==qt.SLIDE_TO_RIGHT?(qt._offsetObjects(i,-r.w,0),new Wt(t,i,new n(r.w,0),o)):e==qt.SLIDE_TO_LEFT?(qt._offsetObjects(i,r.w,0),new Wt(t,i,new n(-r.w,0),o)):e==qt.ZOOM?new Vt(t,i,r,Ut.DIR_C,.5,o):null},qt.getCombinedAnimation=function(t,e,i,r,o,s){return e==qt.ALPHA_FADE?new Kt(t,i,r,s):e==qt.SLIDE_TO_RIGHT?(qt._offsetObjects(r,-o.w,0),new zt(t,i,r,new n(o.w,0),new n(o.w,0),s)):e==qt.SLIDE_TO_LEFT?(qt._offsetObjects(r,o.w,0),new zt(t,i,r,new n(-o.w,0),new n(-o.w,0),s)):e==qt.ZOOM?new Xt(t,i,r,o,Ut.DIR_C,Ut.DIR_C,.5,s):null},qt._offsetObjects=function(t,e,i){if(t.length)for(var n=0;n<t.length;n++)qt._offsetObjects(t[n],e,i);else t&&t.setTranslate(t.getTranslateX()+e,t.getTranslateY()+i)};const Zt=function(t,e,i,n){this.Init(t,e,i,n)};i.createSubclass(Zt,Ut),Zt.prototype.getAnimator=function(){return this._animator};const Qt=function(t,e){this.Init(t,e)};i.createSubclass(Qt,i),Qt._OVERLAP_RATIO=.4,Qt.prototype.Init=function(t,e){this._context=t,this._deleteContainer=e,this._playables=[]},Qt.prototype.getCtx=function(){return this._context},Qt.prototype.constructAnimation=function(t,e){if(e&&!this._context.isOffscreen()){e=e.slice(0);var i=[];if(t){for(var n=new this._context.ojMap,r=0;r<e.length;r++){(s=e[r])&&s.getId()&&n.set(s.getId(),s)}for(var o=0;o<t.length;o++){var s,a=t[o],h=a?a.getId():void 0;(s=h?n.get(h):void 0)?(i.push(s.getId()),s.animateUpdate(this,a)):a&&a.animateDelete(this,this._deleteContainer)}}for(var l=new this._context.KeySetImpl(i),u=0;u<e.length;u++)!e[u]||e[u].getId()&&l.has(e[u].getId())||e[u].animateInsert(this)}},Qt.prototype.getDeleteContainer=function(){return this._deleteContainer},Qt.prototype.add=function(t,e){if(t){for(e||(e=0);this._playables.length<=e;)this._playables.push(new Array);this._playables[e].push(t)}},Qt.prototype.getAnimation=function(t){for(var e=[],i=0;i<this._playables.length;i++)if(this._playables[i].length>0){var n=new Gt(this._context,this._playables[i]);e.push(n)}if(t){for(var r=[],o=0,s=0;s<e.length;s++){if(o>0){var a=new Zt(this._context,null,o);r.push(new Bt(this._context,[a,e[s]]))}else r.push(e[s]);o+=(1-Qt._OVERLAP_RATIO)*e[s].getDuration()}return new Gt(this._context,r)}return new Bt(this._context,e)},Qt.prototype.getNumPlayables=function(){return this._playables.length};const $t=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass($t,Ut),$t.prototype.Init=function(t,e,i,r,o){this._arPoints=i instanceof Array?i:i instanceof n?[i]:[new n(0,0)],this._currIndex=0,$t.superclass.Init.call(this,t,e,r,o)},$t.prototype.InitEndState=function(t){var e;e=this._currIndex<this._arPoints.length?this._arPoints[this._currIndex]:this._arPoints[this._arPoints.length-1],this._animator.addProp(Ft.TYPE_NUMBER,t,t.getTranslateX,t.setTranslateX,e.x),this._animator.addProp(Ft.TYPE_NUMBER,t,t.getTranslateY,t.setTranslateY,e.y),this._currIndex++};const Jt=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass(Jt,Ut),Jt.prototype.Init=function(t,e,i,r,o){this._arScales=i instanceof Array?i:i instanceof n?[i]:[new n(1,1)],this._currIndex=0,Jt.superclass.Init.call(this,t,e,r,o)},Jt.prototype.InitEndState=function(t){var e;e=this._currIndex<this._arScales.length?this._arScales[this._currIndex]:this._arScales[this._arScales.length-1],this._animator.addProp(Ft.TYPE_NUMBER,t,t.getScaleX,t.setScaleX,e.x),this._animator.addProp(Ft.TYPE_NUMBER,t,t.getScaleY,t.setScaleY,e.y),this._currIndex++};const te=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass(te,Ut),te.BackOut=function(t){return Lt.backOut(t,2.5)},te.prototype.Init=function(t,e,i,n,r){this._bCenter=i,this._bCenter&&(this._tempContainers=[],this._currIndex=0),te.superclass.Init.call(this,t,e,n,r)},te.prototype.setEasing=function(t){},te.prototype.CreateAnimator=function(t){te.superclass.CreateAnimator.call(this,t),this._animator.setEasing(te.BackOut),this._bCenter&&kt.appendOnEnd(this._animator,this.RemoveTempContainers,this)},te.prototype.InitStartState=function(t){if(this._bCenter){var e=this._tempContainers[this._currIndex],i=t.getDimensions();e._dvtAnimPopInOrigTx=t.getTranslateX(),e._dvtAnimPopInOrigTy=t.getTranslateY();var n=i.x+.5*i.w,r=i.y+.5*i.h;e.setTranslate(e._dvtAnimPopInOrigTx+n,e._dvtAnimPopInOrigTy+r),t.setTranslate(-n,-r);var o=t.getParent().getChildIndex(t);e._dvtAnimPopInChildIndex=o,t.getParent().addChildAt(e,o),e.addChild(t),e.setScale(.01,.01),this._currIndex++}else t.setScale(.01,.01);t.setVisible(!0)},te.prototype.InitEndState=function(t){if(this._bCenter){var e=new J(this._context);this._tempContainers.push(e),this._animator.addProp(Ft.TYPE_NUMBER,e,e.getScaleX,e.setScaleX,1),this._animator.addProp(Ft.TYPE_NUMBER,e,e.getScaleY,e.setScaleY,1)}else this._animator.addProp(Ft.TYPE_NUMBER,t,t.getScaleX,t.setScaleX,1),this._animator.addProp(Ft.TYPE_NUMBER,t,t.getScaleY,t.setScaleY,1)},te.prototype.RemoveTempContainers=function(){if(this._tempContainers){for(var t=0;t<this._tempContainers.length;t++){var e=this._tempContainers[t];if(this._tempContainers[t]=null,e.getNumChildren()>0){var i=e.getChildAt(0);i&&(i.setTranslate(e._dvtAnimPopInOrigTx,e._dvtAnimPopInOrigTy),e.getParent().addChildAt(i,e._dvtAnimPopInChildIndex))}e.getParent().removeChild(e)}this._tempContainers=null}};const ee=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass(ee,g),ee.prototype.Init=function(t,e,i,n,r){ee.superclass.Init.call(this,e,i,n,r),null===t||isNaN(t)?t=0:Math.abs(t)>360&&(t%=360),this._angle=t},ee.prototype.getAngle=function(){return this._angle},ee.prototype.equals=function(t){return t instanceof ee&&t.getAngle()==this.getAngle()&&ee.superclass.equals.call(this,t)};const ie=function(t,e,i,n,r,o){this.Init(t,e,i,n,r,o)};i.createSubclass(ie,i),ie.FOCUS_BORDER_RADIUS=1,ie.FOCUS_STROKE_WIDTH=1,ie.FOCUS_STROKE_ALPHA=1,ie.prototype.Init=function(t,e,i,n,r,o){this._container=e,this._focusEffect=new lt(t,i.x,i.y,i.w,i.h,r);var s=this.CreateStroke();this._focusEffect.setStroke(s),this._focusEffect.setRx(ie.FOCUS_BORDER_RADIUS),this._focusEffect.setRy(ie.FOCUS_BORDER_RADIUS),n&&this._focusEffect.setMatrix(n),this._focusEffect.setFill(null),this._appendLast=o},ie.prototype.CreateStroke=function(){var t,e=r.getFocusColor(),i=ie.FOCUS_STROKE_WIDTH;return"safari"===r.browser||"blink"===r.engine?i=2:t={dashArray:i,dashOffset:i},new z(e,ie.FOCUS_STROKE_ALPHA,i,!1,t)},ie.prototype.getEffect=function(){return this._focusEffect},ie.prototype.setEffect=function(t){this._focusEffect=t},ie.prototype.show=function(){this._focusEffect instanceof ot&&(this._appendLast?this._container.addChild(this._focusEffect):this._container.addChildAt(this._focusEffect,0))},ie.prototype.hide=function(){this._focusEffect instanceof ot&&this._container.removeChild(this._focusEffect)};const ne=function(){this.Init()};i.createSubclass(ne,i),ne.prototype.Init=function(){this._data=[]},ne.prototype.get=function(t,e){return this._getInner(t)[e]},ne.prototype.put=function(t,e,i){var n=this._getInner(t),r=n[e];return n[e]=i,r},ne.prototype._getInner=function(t){var e=this._data[t];return e||(e=[],this._data[t]=e),e};const re={};i.createSubclass(re,i),re.position=function(t,e,i,n,o,s){i&&(s=n*o>0?s:0,"start"==e?e=r.isRightToLeft(i.getCtx())?"right":"left":"end"==e&&(e=r.isRightToLeft(i.getCtx())?"left":"right"),"top"==e?(i.setTranslate(t.x+t.w/2-n/2,t.y),t.y+=o+s,t.h-=o+s):"bottom"==e?(i.setTranslate(t.x+t.w/2-n/2,t.y+t.h-o),t.h-=o+s):"left"==e?(i.setTranslate(t.x,t.y+t.h/2-o/2),t.x+=n+s,t.w-=n+s):"right"==e&&(i.setTranslate(t.x+t.w-n,t.y+t.h/2-o/2),t.w-=n+s))},re.align=function(t,e,i,n){if(i){var o=e;"start"==o?o=r.isRightToLeft(i.getCtx())?"right":"left":"end"==o&&(o=r.isRightToLeft(i.getCtx())?"left":"right"),"left"==o?i.setX(t.x):"center"==o?i.setX(t.x+t.w/2-n/2):"right"==o&&i.setX(t.x+t.w-n)}},re.getBubbleSize=function(t,e,i,n,r){if(t<=0)return 0;var o=n*n,s=r*r;if(i/e<s/o){var a=Math.sqrt(o*s),h=Math.sqrt(e*i);if(t==h)return Math.sqrt(a);s=i/h*a,o=e/h*a}var l=o+(t-e)/(i-e)*(s-o);return Math.sqrt(l)};const oe=function(t,e){this.Init(t,e)};i.createSubclass(oe,ne),oe._INITIAL_SIZE=1500,oe.prototype.Init=function(t,e){oe.superclass.Init.call(this),this._innerMap=e,this._innerMap&&(this._innerMap._outerMap=this,this._innerMap._bOuterMap=!0),this._scale=t||1,this._capacity=this._scale*this._scale,this._bInnerMap=null!=this._innerMap,this._bOuterMap=!1;for(var i=oe._INITIAL_SIZE/this._scale,n=0;n<i;n++)for(var r=0;r<i;r++)this.put(n,r,0)},oe.prototype.isObscured=function(t,e,i,n){for(var r=this._adjustForScale(t),o=this._adjustForScale(e),s=this._adjustForScale(i),a=this._adjustForScale(n),h=r;h<=s;h++)for(var l=o;l<=a;l++){if(!0!==this.get(h,l)){if(!this._bInnerMap)return!1;var u=Math.max(t,h*this._scale),c=Math.max(e,l*this._scale),_=Math.min(i,(h+1)*this._scale-1),p=Math.min(n,(l+1)*this._scale-1);if(!this._innerMap.isObscured(u,c,_,p))return!1}}return!0},oe.prototype.obscure=function(t,e,i,n,r){for(var o=this._adjustForScale(t),s=this._adjustForScale(e),a=this._adjustForScale(i),h=this._adjustForScale(n),l=o;l<=a;l++)for(var u=s;u<=h;u++){if(!0!==this.get(l,u))if(this._bInnerMap){var c=Math.max(t,l*this._scale),_=Math.max(e,u*this._scale),p=Math.min(i,(l+1)*this._scale-1),d=Math.min(n,(u+1)*this._scale-1);this._innerMap.obscure(c,_,p,d,r)}else this._increment(l,u,r)}},oe.prototype._increment=function(t,e,i){var n=this._adjustForScale(t),r=this._adjustForScale(e),o=this.get(n,r);(o=null!=o?o+i:i)>=this._capacity&&(o=!0),this.put(n,r,o),!0===o&&this._bOuterMap&&this._outerMap._increment(t,e,this._capacity)},oe.prototype._adjustForScale=function(t){return Math.floor(t/this._scale)};const se={_cache:{}};i.createSubclass(se,i),se.addBubbleEventListener=function(t,e,i){return window.addEventListener?(u.addDomEventListener(t,e,i,!1),!0):!!window.attachEvent&&(t.attachEvent("on"+e,i),!0)},se.loadImage=function(t,e){var i=this._cache[t];if(i){if(!i._image)return e&&e(i),i;se._addListenerToQueue(i._listeners,e)}else this.loadNewImage(t,e);return null},se.loadNewImage=function(t,e){var i=document.createElement("img"),n={_listeners:[],url:t,_image:i};e&&se._addListenerToQueue(n._listeners,e),this._cache[t]=n,se.addBubbleEventListener(i,"load",function(t){var e;n.width=i.width,n.height=i.height,delete n._image;var r=n._listeners.length;for(e=0;e<r;e++)n._listeners[e]&&n._listeners[e](n);delete n._listeners}),i.src=t},se._addListenerToQueue=function(t,e){if(e){for(var i=0;i<t.length;i++)if(t[i]===e)return;t.push(e)}};const ae={};i.createSubclass(ae,i),ae.getDimensions=function(t){if(!t||0===t.length)return new m;for(var e,i,n=Number.MAX_VALUE,r=-1*Number.MAX_VALUE,o=Number.MAX_VALUE,s=-1*Number.MAX_VALUE,a=t.length,h=0;h<a;h++)e=t[h++],i=t[h],n=Math.min(n,e),r=Math.max(r,e),o=Math.min(o,i),s=Math.max(s,i);return new m(n,o,Math.abs(r-n),Math.abs(s-o))},ae.getRegularPolygonPoints=function(t,e,i,n,r,o){for(var s,a=[],h=0;h<i;h++)s=r+h/i*2*Math.PI*(0==o?-1:1),a.push(t+n*Math.sin(s),e-n*Math.cos(s));return a},ae.scale=function(t,e,i){for(var n=[],r=0;r<t.length-1;r+=2)n.push(t[r]*e),n.push(t[r+1]*i);return n},ae.translate=function(t,e,i){for(var n=[],r=0;r<t.length-1;r+=2)n.push(t[r]+e),n.push(t[r+1]+i);return n};const he=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass(he,ot),he.prototype.Init=function(t,e,i,n,r){he.superclass.Init.call(this,t,"circle",r),this.setCx(e).setCy(i),this.setRadius(n)},Q.defineProps(he,{r:{name:"radius"},cx:{value:0},cy:{value:0}}),he.prototype.copyShape=function(){return new he(this.getCtx(),this.getCx(),this.getCy(),this.getRadius())},he.prototype.getDimensionsSelf=function(t){var e=new m(this.getCx()-this.getRadius(),this.getCy()-this.getRadius(),2*this.getRadius(),2*this.getRadius());return this.ConvertCoordSpaceRect(e,t)};const le=function(t,e,i,n,r,o,s){this.Init(t,e,i,n,r,o,s)};i.createSubclass(le,ot),le.prototype.Init=function(t,e,i,n,o,s,a){le.superclass.Init.call(this,t,"image",a),e=u.getImageUrl(t,e),"ie"!==r.browser&&"edge"!==r.browser||(u.setAttrNullNS(this._elem,"fill","#FFFFFF"),u.setAttrNullNS(this._elem,"fill-opacity","0")),this.setSrc(e),this.setX(i).setY(n),this.setWidth(o),this.setHeight(s),u.setAttrNullNS(this._elem,"preserveAspectRatio","none"),this.setAriaProperty("hidden","true")},Q.defineProps(le,{x:{},y:{},width:{},height:{}}),le.prototype.getSrc=function(){return this._src},le.prototype.setSrc=function(t){if(t!==this._src){var e=t;this._src=t,u.setHref(this._elem,e)}return this},le.prototype.getDimensions=function(t){if(this.getDimensionsSelf&&this.getNumChildren()-this._getInnerShapeCount()==0)return this.getDimensionsSelf(t);var e=this.getElem().getBBox();return e=e.width&&e.height?new m(e.x,e.y,e.width,e.height):new m(e.x,e.y,this.getWidth(),this.getHeight()),this.ConvertCoordSpaceRect(e,t)},le.prototype.__setDimensions=function(t){this.setWidth(t.width),this.setHeight(t.height)},le.prototype.UpdateSelectionEffect=function(){},le.prototype.copyShape=function(){return new le(this.getCtx(),this.getSrc(),this.getX(),this.getY(),this.getWidth(),this.getHeight())},le.prototype.getDimensionsSelf=function(t){var e=new m(this.getX(),this.getY(),this.getWidth(),this.getHeight());return this.ConvertCoordSpaceRect(e,t)},le.prototype.setAriaProperty=function(t,e){le.superclass.setAriaProperty.call(this,t,e),"hidden"!=t&&le.superclass.setAriaProperty.call(this,"hidden",null)};const ue=function(t,e,i,n,r,o){this.Init(t,e,i,n,r,o)};i.createSubclass(ue,ot),ue.prototype.Init=function(t,e,i,n,r,o){ue.superclass.Init.call(this,t,"line",o),this.setX1(e).setY1(i).setX2(n).setY2(r),this._bHollow=!1},Q.defineProps(ue,{x1:{value:0},x2:{value:0},y1:{value:0},y2:{value:0}}),ue.prototype.setHollow=function(){var t=this._elem.parentNode;if(this._bHollow)this._origElem&&(t.replaceChild(this._origElem,this._elem),u.setAttrNullNS(this._origElem,"opacity",this._alpha),this._elem=this._origElem,this._origElem=null,this._bHollow=!1);else{var e;this._origElem=this._elem;var i=this.getX2()-this.getX1(),n=i,o=this.getY1()-i/2,s=this.getStroke();e=A.createElement("rect"),u.setAttrNullNS(e,"x",this.getX1()),u.setAttrNullNS(e,"y",o),u.setAttrNullNS(e,"width",this.getX2()-this.getX1()),u.setAttrNullNS(e,"height",n);var a=s.getColor();const l="stroke-opacity";if(a){var h=s.getAlpha();"safari"===r.browser&&-1!==a.indexOf("rgba")?(u.setAttrNullNS(e,"stroke",T.getRGB(a)),null!=h?u.setAttrNullNS(e,l,T.getAlpha(a)*h):u.setAttrNullNS(e,l,T.getAlpha(a))):(u.setAttrNullNS(e,"stroke",a),null!=h&&u.setAttrNullNS(e,l,h))}u.setAttrNullNS(e,"fill","#ffffff"),u.setAttrNullNS(e,"fill-opacity","0.001"),u.setAttrNullNS(e,"shape-rendering","crispEdges"),e._obj=this,t.replaceChild(e,this._elem),this._elem=e,u.setAttrNullNS(this._elem,"opacity",this._alpha),this._bHollow=!0}},ue.prototype.getDimensions=function(t){var e=ue.superclass.getDimensions.call(this,t);if(this._childGroupElem&&this._elem){var i=this._childGroupElem.getBBox();if(0==i.x&&0==i.y&&0==i.width&&0==i.height){var n=this._elem.getBBox();e=new m(n.x,n.y,n.width,n.height)}}return e},ue.prototype.copyShape=function(){return new ue(this.getCtx(),this.getX1(),this.getY1(),this.getX2(),this.getY2())},ue.prototype.getDimensionsSelf=function(t){var e=Math.min(this.getX1(),this.getX2()),i=Math.min(this.getY1(),this.getY2()),n=Math.abs(this.getX1()-this.getX2()),r=Math.abs(this.getY1()-this.getY2()),o=new m(e,i,n,r);return this.ConvertCoordSpaceRect(o,t)},ue.prototype._adjustDimensionsForStyle=function(){this.getX1()==this.getX2()?this.setX2(this.getX2()+.001):this.getY1()==this.getY2()&&this.setY2(this.getY2()+.001)},ue.prototype.setStyle=function(t,e){return t&&!e&&this._adjustDimensionsForStyle(),ue.superclass.setStyle.call(this,t)},ue.prototype.setClassName=function(t,e){return t&&!e&&this._adjustDimensionsForStyle(),ue.superclass.setClassName.call(this,t)};const ce=function(t,e,i){this.Init(t,e,i)};i.createSubclass(ce,ot),ce.prototype.Init=function(t,e,i){ce.superclass.Init.call(this,t,"path",i),Array.isArray(e)?this.setCmds(b.getPathString(e)):this.setCmds(e)},ce.prototype.getCmds=function(){return this.GetProperty("d")},ce.prototype.setCmds=function(t){return t&&this.SetSvgProperty("d",t),this.SetProperty("arCmds",null),this},ce.prototype.getCommandsArray=function(){var t=this.GetProperty("arCmds");return t||(t=b.createPathArray(this.getCmds()),this.SetProperty("arCmds",t)),t},ce.prototype.setCommandsArray=function(t){var e=t?b.getPathString(t):null;return this.setCmds(e),this.SetProperty("arCmds",t),this},ce.prototype.copyShape=function(){return new ce(this.getCtx(),this.getCmds())},ce.prototype.GetAriaElem=function(){return r.isTouchDevice()&&this.CreateChildGroupElem(!1,!0),ce.superclass.GetAriaElem.call(this)};const _e=function(t,e,i,n,r,o,s,a,h,l){this.Init(t,e,i,n,r,o,s,a,h,l)};i.createSubclass(_e,ot),_e.CIRCLE="circle",_e.ELLIPSE="ellipse",_e.SQUARE="square",_e.RECTANGLE="rectangle",_e.DIAMOND="diamond",_e.TRIANGLE_UP="triangleUp",_e.TRIANGLE_DOWN="triangleDown",_e.PLUS="plus",_e.HUMAN="human",_e.STAR="star",_e._CIRCLE_ELEM="circle",_e._ELLIPSE_ELEM="ellipse",_e._RECT_ELEM="rect",_e._PATH_ELEM="path",_e._POLYGON_ELEM="polygon",(_e._SHAPE_ELEM_MAP={})[_e.CIRCLE]=_e._CIRCLE_ELEM,_e._SHAPE_ELEM_MAP[_e.ELLIPSE]=_e._ELLIPSE_ELEM,_e._SHAPE_ELEM_MAP[_e.SQUARE]=_e._PATH_ELEM,_e._SHAPE_ELEM_MAP[_e.RECTANGLE]=_e._PATH_ELEM,_e._SHAPE_ELEM_MAP[_e.DIAMOND]=_e._POLYGON_ELEM,_e._SHAPE_ELEM_MAP[_e.TRIANGLE_UP]=_e._POLYGON_ELEM,_e._SHAPE_ELEM_MAP[_e.TRIANGLE_DOWN]=_e._POLYGON_ELEM,_e._SHAPE_ELEM_MAP[_e.PLUS]=_e._POLYGON_ELEM,_e._SHAPE_ELEM_MAP[_e.HUMAN]=_e._PATH_ELEM,_e._SHAPE_ELEM_MAP[_e.STAR]=_e._POLYGON_ELEM,_e.DEFAULT_BORDER_RADIUS="6",_e._HUMAN_CMDS="M 306.40625 386.78125 C 304.19988 386.78125 302.40625 389.07579 302.40625 391.90625 C 302.40625 394.73671 304.19988 397.03125 306.40625 397.03125 C 308.61263 397.03125 310.40625 394.73671 310.40625 391.90625 C 310.40625 389.07579 308.61263 386.78125 306.40625 386.78125 z M 301.78125 396.0625 C 300.43025 397.2945 298.28125 400.28125 298.90625 403.15625 C 302.41725 405.79925 309.20225 406.154 314.03125 403 C 314.21825 399.828 312.68325 397.5635 310.90625 396.0625 C 308.65625 400.7185 304.28125 399.7815 301.78125 396.0625 z ",_e._SHAPE_STAR_CMDS=[-50,-11.22,-16.69,-17.94,0,-47.55,16.69,-17.94,50,-11.22,26.69,13.8,30.9,47.56,0,33.42,-30.9,47.56,-26.69,13.8],_e.prototype.Init=function(t,e,i,n,r,o,s,a,h,l){h&&(i=Math.round(i),n=Math.round(n),r=Math.round(r),o=(o=Math.round(o))%2==1?o+1:o,r=r%2==1?r+1:r),this._bMaintainAspectRatio=!0,!1===a&&(this._bMaintainAspectRatio=!1,e==_e.CIRCLE&&(e=_e.ELLIPSE)),s&&"0"!=s&&(this._borderRadius=s),this._shape=e||_e.RECTANGLE,this._dataColor="#000000";var u=e?_e._SHAPE_ELEM_MAP[e]:_e._PATH_ELEM;null==u&&(this._isCustomShape=!0,this._path=new ce(t,e),u=_e._PATH_ELEM),_e.superclass.Init.call(this,t,u,l),this._shape!=_e.SQUARE&&this._shape!=_e.RECTANGLE||(this._path=this._getBorderRadiusPath(t,i,n,r,o,s)),this._shape==_e.HUMAN&&(this._path=new ce(t,_e._HUMAN_CMDS)),this._propertyChange={},this.setCenter(i,n,!0).setSize(r,o)},_e.prototype.setCenterDimensions=function(t){return this.setCenter(t.x,t.y,!0).setSize(t.w,t.h)},_e.prototype.getCenterDimensions=function(){return new m(this._cx,this._cy,this._width,this._height)},_e.prototype.setSize=function(t,e,i){return this.setWidth(t,!0).setHeight(e,i)},_e.prototype.setCenter=function(t,e,i){return this.setCx(t,!0).setCy(e,i)},_e.prototype._updateSvgProperties=function(){if(this._propertyChange.width||this._propertyChange.height){var t=Math.min(this._width,this._height);this._propertyChange.s=this._s!=t,this._s=t}if(this._shape!=_e.RECTANGLE&&this._shape!=_e.SQUARE||this._borderRadius)this._shape==_e.CIRCLE||this._shape==_e.ELLIPSE?(this._propertyChange.cx&&u.setAttrNullNS(this._elem,"cx",this._cx,0),this._propertyChange.cy&&u.setAttrNullNS(this._elem,"cy",this._cy,0),this._shape==_e.CIRCLE?this._propertyChange.s&&u.setAttrNullNS(this._elem,"r",this._s/2,0):(this._propertyChange.width&&u.setAttrNullNS(this._elem,"rx",this._width/2,0),this._propertyChange.height&&u.setAttrNullNS(this._elem,"ry",this._height/2,0))):this._isPolygon()?(this._propertyChange.s||this._propertyChange.cx||this._propertyChange.cy)&&this._setPolygon(this._getPolygonArray()):this._isPath()&&(this._propertyChange.width||this._propertyChange.height||this._propertyChange.cx||this._propertyChange.cy)&&this._setCmds(this._getCmds());else if(this._propertyChange.width||this._propertyChange.height||this._propertyChange.cx||this._propertyChange.cy){var e=b.rectangleWithBorderRadius(this._cx-this._width/2,this._cy-this._height/2,this._width,this._height);this._setCmds(e)}return this.UpdateSelectionEffect(),this._propertyChange={},this},_e.prototype.getCx=function(){return this._cx},_e.prototype.setCx=function(t,e){return this._propertyChange.cx=this._cx!=t,this._cx=t,e?this:this._updateSvgProperties()},_e.prototype.getCy=function(){return this._cy},_e.prototype.setCy=function(t,e){return this._propertyChange.cy=this._cy!=t,this._cy=t,e?this:this._updateSvgProperties()},_e.prototype.getSize=function(){return this._s},_e.prototype.getWidth=function(){return this._width},_e.prototype.setWidth=function(t,e){return this._propertyChange.width=this._width!=t,this._width=t,e?this:this._updateSvgProperties()},_e.prototype.getHeight=function(){return this._height},_e.prototype.setHeight=function(t,e){return this._propertyChange.height=this._height!=t,this._height=t,e?this:this._updateSvgProperties()},_e.prototype._getPolygonArray=function(){var t=[],e=this._cx,i=this._cy,n=this.getMaintainAspectRatio()?this._s/2:this._width/2,r=this.getMaintainAspectRatio()?this._s/2:this._height/2,o=this.getMaintainAspectRatio()?this._s/6:this._width/6,s=this.getMaintainAspectRatio()?this._s/6:this._height/6;return this._shape==_e.TRIANGLE_UP?t=[e-n,i+r,e,i-r,e+n,i+r]:this._shape==_e.TRIANGLE_DOWN?t=[e-n,i-r,e,i+r,e+n,i-r]:this._shape==_e.DIAMOND?t=[e-n,i,e,i-r,e+n,i,e,i+r]:this._shape==_e.PLUS?t=[e-n,i-s,e-o,i-s,e-o,i-r,e+o,i-r,e+o,i-s,e+n,i-s,e+n,i+s,e+o,i+s,e+o,i+r,e-o,i+r,e-o,i+s,e-n,i+s]:this._shape==_e.STAR&&(t=_e._SHAPE_STAR_CMDS,t=ae.scale(t,this.getMaintainAspectRatio()?this._s/100:this._width/100,this.getMaintainAspectRatio()?this._s/100:this._height/100),t=ae.translate(t,e,i)),t},_e.prototype._setPolygon=function(t){u.setAttrNullNS(this._elem,"points",A.convertPointsArray(t))},_e.prototype._getCmds=function(){var t=q.getDimForced(this.getCtx(),this._path),e=Math.max(t.w,t.h),i=this.getMaintainAspectRatio();this._shape==_e.RECTANGLE&&(i=!1);var n=i?this._s/e:this._width/t.w,r=i?this._s/e:this._height/t.h,o=this._cx-t.x*n-t.w*n/2,s=this._cy-t.y*r-t.h*r/2;return b.transformPath(this._path.getCommandsArray(),o,s,n,r)},_e.prototype._setCmds=function(t){u.setAttrNullNS(this._elem,"d",t)},_e.prototype.getType=function(){return this._shape},_e.prototype._isPolygon=function(){return _e._SHAPE_ELEM_MAP[this._shape]==_e._POLYGON_ELEM},_e.prototype._isPath=function(){return _e._SHAPE_ELEM_MAP[this._shape]==_e._PATH_ELEM||this._isCustomShape},_e.prototype.GetStrokeWidth=function(){var t=this.getStroke();return t?t.getWidth():0},_e.prototype._getBorderRadiusPath=function(t,e,i,n,r,o){if(this._shape==_e.SQUARE||this._shape==_e.RECTANGLE){var s=Math.min(n,r),a=this._shape==_e.SQUARE?s:n,h=this._shape==_e.SQUARE?s:r,l=e-a/2,u=i-h/2,c=b.rectangleWithBorderRadius(l,u,a,h,o,s,"0");return new ce(t,c)}return null},_e.prototype._getBorderRadius=function(){return this._borderRadius},_e.prototype.setDataColor=function(t,e){if(this._dataColor=t,!e){var i=rt.getHoverBorderColor(t);this.setHoverStroke(new z("#FFFFFF",1,1,!0),new z(i,1,3.5,!0)),this.setSelectedStroke(new z("#FFFFFF",1,1.5,!0),new z("#5A5A5A",1,4.5,!0)),this.setSelectedHoverStroke(new z("#FFFFFF",1,1.5,!0),new z(i,1,4.5,!0))}},_e.prototype.getDataColor=function(){return this._dataColor},_e.prototype.setHollow=function(t){var e=this.GetStrokeWidth();e=e||1,_e.superclass.setHollow.call(this,t,e)},_e.prototype.setText=function(t){this._markerText=t},_e.prototype.setAlpha=function(t){_e.superclass.setAlpha.call(this,t),t!==this.getAlpha()&&(this._markerText&&this._markerText.setAlpha(t),this.UpdateSelectionEffect())},_e.prototype.copyShape=function(){return new _e(this.getCtx(),this._shape,this.getCx(),this.getCy(),this.getWidth(),this.getHeight(),this._getBorderRadius(),this.getMaintainAspectRatio())},_e.prototype.getDimensions=function(t){return this.getDimensionsSelf(t)},_e.prototype.getDimensionsSelf=function(t){var e=this.getCx()-this.getWidth()/2,i=this.getCy()-this.getHeight()/2,n=new m(e,i,this.getWidth(),this.getHeight());return this.ConvertCoordSpaceRect(n,t)},_e.prototype.setMaintainAspectRatio=function(t){this._bMaintainAspectRatio=t},_e.prototype.getMaintainAspectRatio=function(){return this._bMaintainAspectRatio};const pe=function(t,e,i,n,r,o,s,a,h,l,u){this.Init(t,e,i,n,r,o,s,a,h,l,u)};i.createSubclass(pe,ot),pe.prototype.Init=function(t,e,i,n,o,s,a,h,l,c,_){pe.superclass.Init.call(this,t,"image",_),this._setMarkerImageStates(a,h,l,c);var p=this._getImage();this._setSource(p),this._propertyChange={},this.setCenter(e,i,!0).setSize(n,o),this._updateBorder(s),"ie"!==r.browser&&"edge"!==r.browser||(u.setAttrNullNS(this._elem,"fill","#FFFFFF"),u.setAttrNullNS(this._elem,"fill-opacity","0"))},pe.prototype.setPreserveAspectRatio=function(t){u.setAttrNullNS(this._elem,"preserveAspectRatio",t,"xMidYMid")},pe.prototype.setCenterDimensions=function(t){return this.setCenter(t.x,t.y,!0).setSize(t.w,t.h)},pe.prototype.getCenterDimensions=function(){return new m(this._cx,this._cy,this._width,this._height)},pe.prototype.setSize=function(t,e,i){return this.setWidth(t,!0).setHeight(e,i)},pe.prototype.getSize=function(){return Math.max(this.getWidth(),this.getHeight())},pe.prototype.setCenter=function(t,e,i){return this.setCx(t,!0).setCy(e,i)},pe.prototype._updateSvgProperties=function(){return(this._propertyChange.cx||this._propertyChange.width)&&u.setAttrNullNS(this._elem,"x",this._cx-this._width/2,0),(this._propertyChange.cy||this._propertyChange.height)&&u.setAttrNullNS(this._elem,"y",this._cy-this._height/2,0),this._propertyChange.width&&u.setAttrNullNS(this._elem,"width",this._width,0),this._propertyChange.height&&u.setAttrNullNS(this._elem,"height",this._height,0),this._updateBorder(this._borderRadius),this.UpdateSelectionEffect(),this._propertyChange={},this},pe.prototype.getCx=function(){return this._cx},pe.prototype.setCx=function(t,e){return this._propertyChange.cx=this._cx!=t,this._cx=t,e?this:this._updateSvgProperties()},pe.prototype.getCy=function(){return this._cy},pe.prototype.setCy=function(t,e){return this._propertyChange.cy=this._cy!=t,this._cy=t,e?this:this._updateSvgProperties()},pe.prototype.getWidth=function(){return this._width},pe.prototype.setWidth=function(t,e){return this._propertyChange.width=this._width!=t,this._width=t,e?this:this._updateSvgProperties()},pe.prototype.getHeight=function(){return this._height},pe.prototype.setHeight=function(t,e){return this._propertyChange.height=this._height!=t,this._height=t,e?this:this._updateSvgProperties()},pe.prototype._setSource=function(t){u.setHref(this._elem,u.getImageUrl(this.getCtx(),t))},pe.prototype._setMarkerImageStates=function(t,e,i,n){var r=t;this._imageStates=[r],this._imageStates.push(e||r),this._imageStates.push(i||r),this._imageStates.push(n||this._imageStates[1])},pe.prototype._getImage=function(){return this._imageStates[0]},pe.prototype._getImageSelected=function(){return this._imageStates[1]},pe.prototype._getImageHover=function(){return this._imageStates[2]},pe.prototype._getImageHoverSelected=function(){return this._imageStates[3]},pe.prototype.showHoverEffect=function(){this.IsShowingHoverEffect=!0,this.isSelected()?this._setSource(this._getImageHoverSelected()):this._setSource(this._getImageHover())},pe.prototype.hideHoverEffect=function(){this.IsShowingHoverEffect=!1,this.isSelected()?this._setSource(this._getImageSelected()):this._setSource(this._getImage())},pe.prototype.setSelected=function(t){this.IsSelected!=t&&(this.IsSelected=t,t?this.isHoverEffectShown()?this._setSource(this._getImageHoverSelected()):this._setSource(this._getImageSelected()):this._setSource(this._getImage()))},pe.prototype._updateBorder=function(t){if(t||this._borderPath){if(t&&"0"!=t){var e=b.rectangleWithBorderRadius(this._cx-this._width/2,this._cy-this._height/2,this._width,this._height,t,Math.min(this._width,this._height),"0"),i=new p;i.addPath(e),this.setClipPath(i)}if(this._borderPath){var n=b.rectangleWithBorderRadius(this._cx-this._width/2+this._borderWidth/2,this._cy-this._height/2+this._borderWidth/2,this._width-this._borderWidth,this._height-this._borderWidth,t,Math.min(this._width,this._height),"0");this._borderPath.setCmds(n)}}this._borderRadius=t},pe.prototype._getBorderRadius=function(){return this._borderRadius},pe.prototype.setStroke=function(t){if(!t||t.getWidth()<=0)return this._borderWidth=0,void(this._borderPath&&(this.removeChild(this._borderPath),this._borderPath=null));var e=t.getWidth();if(!this._borderPath||e!=this._borderWidth){var i=b.rectangleWithBorderRadius(this._cx-this._width/2+e/2,this._cy-this._height/2+e/2,this._width-e,this._height-e,this._borderRadius,Math.min(this._width,this._height),"0");this._borderPath?this._borderPath.setCmds(i):(this._borderPath=new ce(this.getCtx(),i),this._borderPath.setInvisibleFill(),this.addChild(this._borderPath))}this._borderWidth=e,this._borderPath.setStroke(t)},pe.prototype.setHollow=function(t,e){pe.superclass.setHollow.call(this,t,e),this.isHollow()?(this._imageContainer=this._elem.parentNode,this._imageContainer.removeChild(this._elem)):this._imageContainer&&this._imageContainer.appendChild(this._elem)},pe.prototype.copyShape=function(){return new pe(this.getCtx(),this.getCx(),this.getCy(),this.getWidth(),this.getHeight(),this._getBorderRadius(),this._getImage(),this._getImageSelected(),this._getImageHover(),this._getImageHoverSelected(),null)},pe.prototype.getDimensionsSelf=function(t){var e=this.getCx()-this.getWidth()/2,i=this.getCy()-this.getHeight()/2,n=new m(e,i,this.getWidth(),this.getHeight());return this.ConvertCoordSpaceRect(n,t)};const de=function(){};i.createSubclass(de,ot),de.prototype.Init=function(t,e,i,n){de.superclass.Init.call(this,t,e,n),i&&this.setPoints(i)},de.prototype.getPoints=function(){return this.GetProperty("arPoints")},de.prototype.setPoints=function(t){return this.SetProperty("arPoints",t),this.SetSvgProperty("points",A.convertPointsArray(t))},de.prototype.getDimensionsSelf=function(t){var e=ae.getDimensions(this.getPoints());return this.ConvertCoordSpaceRect(e,t)};const ge=function(t,e,i,n){n||this.Init(t,e,i)};i.createSubclass(ge,de),ge.prototype.Init=function(t,e,i){ge.superclass.Init.call(this,t,"polygon",e,i)},ge.prototype.copyShape=function(){return new ge(this.getCtx(),this.getPoints())},ge.prototype.GetAriaElem=function(){return r.isTouchDevice()&&this.CreateChildGroupElem(!1,!0),ge.superclass.GetAriaElem.call(this)};const fe=function(t,e,i){this.Init(t,e,i)};i.createSubclass(fe,de),fe.prototype.Init=function(t,e,i){fe.superclass.Init.call(this,t,"polyline",e,i),u.setAttrNullNS(this._elem,"fill","none")},fe.prototype.copyShape=function(){return new fe(this.getCtx(),this.getPoints())},fe.prototype.requiresStrokeAdjustmentForShadow=function(){return!0};const ye=function(t,e,i,n,r,o){this.Init(t,e,i,n,r,o)};i.createSubclass(ye,J),ye._PADDING=.15,ye.prototype.Init=function(t,e,i,n,r,o){ye.superclass.Init.call(this,t,"g",o),this.TextInstance=this.CreateTextInstance(t,e,i,n,o),this._backgroundRect=null,r&&this.setCSSStyle(r),this.addChild(this.TextInstance)},ye.prototype.getTextString=function(){return this.TextInstance.getTextString()},ye.prototype.setTextString=function(t){return this.TextInstance.setTextString(t),this},ye.prototype.isTruncated=function(){return this.TextInstance.isTruncated()},ye.prototype.getUntruncatedTextString=function(){return this.TextInstance.getUntruncatedTextString()},ye.prototype.setUntruncatedTextString=function(t){this.TextInstance.setUntruncatedTextString(t)},ye.prototype.getX=function(){return this.TextInstance.getX()},ye.prototype.setX=function(t){return this.TextInstance=this.TextInstance.setX(t),this._realignBackground(),this},ye.prototype.getY=function(){return this.TextInstance.getY()},ye.prototype.setY=function(t){return this.TextInstance=this.TextInstance.setY(t),this._realignBackground(),this},ye.prototype.setFontSize=function(t){this.TextInstance.setFontSize(t),this._style.setFontSize(j.FONT_SIZE,String(t),this.getCtx()),this._realignBackground()},ye.prototype.getHorizAlignment=function(){return this.TextInstance.getHorizAlignment()},ye.prototype.setHorizAlignment=function(t){this.TextInstance.setHorizAlignment(t),this._realignBackground()},ye.prototype.getVertAlignment=function(){return this.TextInstance.getVertAlignment()},ye.prototype.setVertAlignment=function(t){this.TextInstance.setVertAlignment(t),this._realignBackground()},ye.prototype.alignLeft=function(){this.TextInstance.alignLeft(),this._realignBackground()},ye.prototype.alignCenter=function(){this.TextInstance.alignCenter(),this._realignBackground()},ye.prototype.alignRight=function(){this.TextInstance.alignRight(),this._realignBackground()},ye.prototype.alignTop=function(){this.TextInstance.alignTop(),this._realignBackground()},ye.prototype.alignMiddle=function(){this.TextInstance.alignMiddle(),this._realignBackground()},ye.prototype.alignBottom=function(){this.TextInstance.alignBottom(),this._realignBackground()},ye.prototype.alignAuto=function(){this.TextInstance.alignAuto(),this._realignBackground()},ye.prototype.setCSSStyle=function(t){t.getStyle(j.BACKGROUND_COLOR)&&!t.getStyle(j.COLOR)&&t.setStyle(j.COLOR,T.getContrastingTextColor(t.getStyle(j.BACKGROUND_COLOR))),this.TextInstance&&this.TextInstance.setCSSStyle(t),(this._backgroundRect||ye._hasBackgroundStyles(t))&&(this._backgroundRect||(this._backgroundRect=this.CreateBackground(this.getCtx(),this.TextInstance),this.addChildAt(this._backgroundRect,0)),this._setBackgroundCSSStyle(this._backgroundRect,t)),this._style=t},ye.prototype.getCSSStyle=function(){return this._style},ye.prototype.setMatrix=function(t){this.TextInstance.setMatrix(t),this._backgroundRect&&this._backgroundRect.setMatrix(t)},ye.prototype.getMatrix=function(){return this.TextInstance.getMatrix()},ye.prototype.getTextDimensions=function(t){return this.TextInstance.getDimensions(t)},ye.prototype.getDimensions=function(t){var e=this.TextInstance.getDimensions(),i=e.h*ye._PADDING;return e.x-=i,e.w+=2*i,this.ConvertCoordSpaceRect(e,t)},ye.prototype.getDimensionsWithStroke=function(){return this.GetElemDimensionsWithStroke()},ye.prototype.GetDimensionsWithStroke=function(t){var e=this.GetElemDimensionsWithStroke();return t&&t!==this?this.ConvertCoordSpaceRect(e,t):e},ye.prototype.GetElemDimensionsWithStroke=function(){var t=this.getDimensions(),e=(this._backgroundRect?this._backgroundRect:this.TextInstance).getStroke();if(t&&e){var i=e.getWidth();if(i){var n=.5*i;t.x-=n,t.y-=n,t.w+=i,t.h+=i}}return t},ye.prototype.copyShape=function(){return this.TextInstance.copyShape()},ye.prototype.CreateTextInstance=function(t,e,i,n,r){return new at(t,e,i,n,r)},ye.prototype.CreateBackground=function(t,e){var i=e.getDimensions(),n=i.h*ye._PADDING;return new lt(t,i.x-n,i.y,i.w+2*n,i.h)},ye.prototype._realignBackground=function(){if(this._backgroundRect){var t=this.TextInstance.getDimensions(),e=.15*t.h,i=this.getHorizAlignment(),n=this.getVertAlignment();i==at.H_ALIGN_LEFT?this._backgroundRect.setX(this.getX()-e):i==at.H_ALIGN_CENTER?this._backgroundRect.setX(this.getX()-.5*t.w-e):i==at.H_ALIGN_RIGHT&&this._backgroundRect.setX(this.getX()-t.w-e);var o=parseFloat(this._style.getFontSize());isNaN(o)&&(o=0);var s=0;"blink"===r.engine&&n==at.V_ALIGN_MIDDLE?s=.12*o:"ie"!==r.browser&&"edge"!==r.browser||n!=at.V_ALIGN_BOTTOM||(s=.4*-o);var a=this.GetTextDimensionsForRealign(t);n==at.V_ALIGN_TOP?this._backgroundRect.setY(this.getY()):n==at.V_ALIGN_MIDDLE?this._backgroundRect.setY(this.getY()-.5*a-s):n==at.V_ALIGN_CENTRAL?this._backgroundRect.setY(this.getY()-.5*a):n==at.V_ALIGN_BOTTOM?this._backgroundRect.setY(this.getY()-a-s):n==at.V_ALIGN_AUTO&&this._backgroundRect.setY(t.y),this._backgroundRect.setWidth(t.w+2*e),this._backgroundRect.setHeight(t.h)}},ye.prototype._setBackgroundCSSStyle=function(t,e){if(e){var i=e.getStyle(j.BACKGROUND_COLOR);null!=i?t.setSolidFill(i):t.setInvisibleFill();var n=e.getStyle(j.BORDER_COLOR),r=e.getStyle(j.BORDER_WIDTH),o=e.getStyle(j.BORDER_RADIUS);if(n||r||o){var s=new j;s.setStyle(j.BORDER_COLOR,n),s.setStyle(j.BORDER_WIDTH,r),s.setStyle(j.BORDER_RADIUS,o),t.setCSSStyle(s)}}else t.setInvisibleFill();t.setMouseEnabled(!1)},ye.prototype.GetTextDimensionsForRealign=function(t){return t.h},ye._hasBackgroundStyles=function(t){return!!t&&t.hasBackgroundStyles()},ye.prototype.includeChildSubtree=function(){return!1},ye.prototype.isMultiline=function(){return!1},ye.prototype.hasBackground=function(){return!0};const ve=function(t,e,i,n,r,o,s){this.Init(t,e,i,n,r,o,s)};i.createSubclass(ve,ye),ve.prototype.Init=function(t,e,i,n,r,o,s){this._preserveNewLine=s||!1,ve.superclass.Init.call(this,t,e,i,n,r,o)},ve.prototype.wrapText=function(t,e,i,n){return this.TextInstance.wrapText(t,e,i,n)},ve.prototype.CreateTextInstance=function(t,e,i,n,r){return new mt(t,e,i,n,r,this._preserveNewLine)},ve.prototype.GetTextDimensionsForRealign=function(){return this.getLineHeight()},ve.prototype.getDimensions=function(t){var e=this.TextInstance.getDimensions(),i=e.h*ye._PADDING/this.getLineCount();return e.x-=i,e.w+=2*i,this.ConvertCoordSpaceRect(e,t)},ve.prototype.__fitText=function(t,e,i){return this.TextInstance.__fitText(t,e,i)},ve.prototype._getTextLines=function(){return this.TextInstance._getTextLines()},ve.prototype.getLineHeight=function(){return this.TextInstance.getLineHeight()},ve.prototype.getLineCount=function(){return this.TextInstance.getLineCount()},ve.prototype.getYAlignCoord=function(){return this.TextInstance.getYAlignCoord()},ve.prototype.setWrapEnabled=function(t){this.TextInstance.setWrapEnabled(t)},ve.prototype.isWrapEnabled=function(){return this.TextInstance.isWrapEnabled()},ve.prototype.UpdateSelectionEffect=function(){},ve.prototype.isMultiline=function(){return!0};const Se=function(t,e){this.Init(t,e)};i.createSubclass(Se,i),Se.FONT_SIZE_11=(Se.FONT_SIZE="font-size: ")+"11px;",Se.FONT_SIZE_12=Se.FONT_SIZE+"12px;",Se.FONT_SIZE_13=Se.FONT_SIZE+"13px;",Se.FONT_SIZE_14=Se.FONT_SIZE+"14px;",Se.FONT_WEIGHT_BOLD="font-weight: bold;",Se.FONT_FAMILY_ALTA_11=(Se.FONT_FAMILY_ALTA="font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;")+Se.FONT_SIZE_11,Se.FONT_FAMILY_ALTA_12=Se.FONT_FAMILY_ALTA+Se.FONT_SIZE_12,Se.FONT_FAMILY_ALTA_13=Se.FONT_FAMILY_ALTA+Se.FONT_SIZE_13,Se.FONT_FAMILY_ALTA_14=Se.FONT_FAMILY_ALTA+Se.FONT_SIZE_14,Se.FONT_FAMILY_ALTA_BOLD_11=(Se.FONT_FAMILY_ALTA_BOLD=Se.FONT_FAMILY_ALTA+Se.FONT_WEIGHT_BOLD)+Se.FONT_SIZE_11,Se.FONT_FAMILY_ALTA_BOLD_12=Se.FONT_FAMILY_ALTA_BOLD+Se.FONT_SIZE_12,Se.FONT_FAMILY_ALTA_BOLD_13=Se.FONT_FAMILY_ALTA_BOLD+Se.FONT_SIZE_13,Se.FONT_FAMILY_ALTA_BOLD_14=Se.FONT_FAMILY_ALTA_BOLD+Se.FONT_SIZE_14,Se._SKINS=[j.SKIN_ALTA],Se.prototype.Init=function(t,e){this._defaults=t||{},this._context=e,this.constructor.defaultsCache||(this.constructor.defaultsCache={})},Se.prototype.getBaseSkinName=function(){return j.SKIN_ALTA},Se.prototype.calcOptions=function(t){var e=t?t.skin:null,i=this.getDefaults(e);if(!t)return i;var n=this.getNoCloneObject();if(this._context&&this._context.dataProviderProps)for(var r=this._context.dataProviderProps,o=0;o<r.length;o++)n[r[o]]=!0;var s=Et.merge(t,i,n);return 0==this.getAnimationDuration(s)&&(s.animationOnDataChange="none",s.animationOnDisplay="none"),s},Se.prototype.getDefaults=function(t){if(t||(t=this.getBaseSkinName()),this.constructor.defaultsCache[t])return Et.clone(this.constructor.defaultsCache[t]);for(var e=Math.max(Se._SKINS.indexOf(t),0),i=Et.clone(this._defaults[Se._SKINS[0]]),n=1;n<=e;n++)i=Et.merge(this._defaults[Se._SKINS[n]],i);return this.constructor.defaultsCache[t]=Et.clone(i),i},Se.prototype.getNoCloneObject=function(){return{}},Se.prototype.getAnimationDuration=function(t){return t.styleDefaults&&t.styleDefaults.animationDuration?t.styleDefaults.animationDuration:t.animationDuration?t.animationDuration:null};const Te=function(t,e,i,n){Te.superclass.Init.call(this,t),this._callback=e,this._callbackObj=i,this._dragTarget=n};i.createSubclass(Te,J),Te._THUMB_MIN_SIZE=12,Te.prototype.render=function(t,e,i){this._width=e,this._height=i,this._globalMin=t.min,this._globalMax=t.max,this._isHoriz=t.isHorizontal,this._isReversed=t.isReversed;var n=new lt(this.getCtx(),0,0,e,i);n.setSolidFill(t.backgroundColor),n.setPixelHinting(!0),this.addChild(n),this._thumb=new lt(this.getCtx(),0,0,e,i),this._thumb.setSolidFill(t.color),this._thumb.setPixelHinting(!0),this.addChild(this._thumb),this._thumbMin=this._globalMin,this._thumbMax=this._globalMax,this._renderedThumbMin=this._thumbMin,this._renderedThumbMax=this._thumbMax;var o=r.isTouchDevice()?8:4,s=new lt(this.getCtx(),-o,-o,this._width+2*o,this._height+2*o);s.setInvisibleFill(),this.addChild(s);var a=null!=this._dragTarget;gt.addDragListeners(a?this._dragTarget:this,this._onDragStart,this._onDragMove,this._onDragEnd,this,!a),r.isTouchDevice()||a||this.addEvtListener(F.CLICK,this._onClick,!1,this),this._dragged=!1},Te.prototype.setViewportRange=function(t,e,i,n){null!=i&&(this._globalMin=i),null!=n&&(this._globalMax=n),this._thumbMin=t,this._thumbMax=e;var r=e-t,o=this._globalMax-this._globalMin,s=Math.min(Te._THUMB_MIN_SIZE/(this._isHoriz?this._width:this._height)*o,o);r<s&&(e+=(s-r)/2,(t-=(s-r)/2)<this._globalMin&&(t=this._globalMin,e=this._globalMin+s),e>this._globalMax&&(e=this._globalMax,t=this._globalMax-s)),this._renderedThumbMin=t,this._renderedThumbMax=e;var a=this._getCoord(t),h=this._getCoord(e);this._isHoriz?(this._thumb.setX(Math.min(a,h)),this._thumb.setWidth(Math.abs(h-a))):(this._thumb.setY(Math.min(a,h)),this._thumb.setHeight(Math.abs(h-a)))},Te.prototype._getCoord=function(t){var e=(t-this._globalMin)/(this._globalMax-this._globalMin);return this._isReversed&&(e=1-e),this._isHoriz?e*this._width:e*this._height},Te.prototype._getValue=function(t,e){var i=this.stageToLocal(this.getCtx().pageToStageCoords(t,e)),n=this._isHoriz?i.x/this._width:i.y/this._height;return this._isReversed&&(n=1-n),n=Math.min(Math.max(n,0),1),this._globalMin+n*(this._globalMax-this._globalMin)},Te.prototype._onClick=function(t){var e=this._getValue(t.pageX,t.pageY);if(!(e>=this._renderedThumbMin&&e<=this._renderedThumbMax)){var i=this._thumbMax-this._thumbMin;this._setViewportRange(e-i/2,e+i/2,"end")}},Te.prototype._onDragStart=function(t){var e;if(t.touches){if(1!=t.touches.length)return!1;e=this._getValue(t.touches[0].pageX,t.touches[0].pageY)}else e=this._getValue(t.pageX,t.pageY);return!!(this._dragTarget||e>=this._renderedThumbMin&&e<=this._renderedThumbMax)&&(this._prevVal=Math.min(Math.max(e,this._thumbMin),this._thumbMax),this._dragged=!0,!0)},Te.prototype._onDragMove=function(t){if(this._dragged){var e;if(t.touches){if(1!=t.touches.length)return;e=this._getValue(t.touches[0].pageX,t.touches[0].pageY)}else e=this._getValue(t.pageX,t.pageY);var i=e-this._prevVal;this._dragTarget&&(i*=-1),this._setViewportRange(this._thumbMin+i,this._thumbMax+i,"move"),this._prevVal=e,t.preventDefault()}},Te.prototype._onDragEnd=function(t){if(this._dragged){if(t.touches)this._setViewportRange(this._thumbMin,this._thumbMax,"end");else{var e=this._getValue(t.pageX,t.pageY)-this._prevVal;this._setViewportRange(this._thumbMin+e,this._thumbMax+e,"end")}this._dragged=!1}},Te.prototype._setViewportRange=function(t,e,i){var n=e-t;if(t<this._globalMin&&(t=this._globalMin,e=this._globalMin+n),e>this._globalMax&&(e=this._globalMax,t=this._globalMax-n),this.setViewportRange(t,e),this._callback){var r=yt.newSimpleScrollbarEvent(i,t,e);this._callback.call(this._callbackObj,r,this)}};const Ee=function(t,e,i,n,o){Ee.superclass.Init.call(this,t),this._contentSize=o?e:i,this._width=e,this._height=i,this._background=new lt(t,0,0,e,i),this._background.setInvisibleFill(),this.addChild(this._background),this._container=new J(t),this.addChild(this._container),this._isHorizontalScrolling=o,this._isScrollbarVisible=!1,this.scrolling=n,r.isTouchDevice()||this.addEvtListener(F.MOUSEWHEEL,this._onMouseWheel,!1,this)};i.createSubclass(Ee,J),Ee._SCROLLBAR_WIDTH=3,Ee._SCROLLBAR_GAP=2,Ee.prototype.getScrollingPane=function(){return this._container},Ee.prototype.prepareContentPane=function(){var t=this._container.getDimensions();if(this._isHorizontalScrolling?this._contentSize=t.w+t.x:this._contentSize=t.h+t.y,this.hasScrollingContent()){if(this._isHorizontalScrolling?this._contentSize+=t.x:this._contentSize+=t.y,!this._maskContainer){var e=new m(0,0,this._width,this._height);this._fadeTop=new Dt(new ee(this._isHorizontalScrolling?0:270,["#FFFFFF","#FFFFFF"],[0,1],[0,.1]),e),this._fadeBottom=new Dt(new ee(this._isHorizontalScrolling?180:90,["#FFFFFF","#FFFFFF"],[0,1],[0,.1]),e),this._fadeTopBottom=new Dt(new ee(this._isHorizontalScrolling?180:90,["#FFFFFF","#FFFFFF","#FFFFFF","#FFFFFF"],[0,1,1,0],[0,.1,.9,1]),e),this._maskContainer=new J(this.getCtx()),this.addChild(this._maskContainer);var i=new p;i.addRect(0,0,this._width,this._height),this._container.setClipPath(i),this._maskContainer.addChild(this._container),this._scrollbar=new Te(this.getCtx(),this._handleScrollbar,this,this),this._scrollbarTimer=new ut(this.getCtx(),100,this._hideScrollbar,this)}this._maskContainer.setMask(this._fadeBottom);var n={color:"#9E9E9E",backgroundColor:"#F0F0F0",isHorizontal:this._isHorizontalScrolling,isReversed:!1,min:0,max:this._contentSize};this._isHorizontalScrolling?(this._scrollbar.render(n,this._getScrollbarWidth(),Ee._SCROLLBAR_WIDTH),this._scrollbar.setTranslate(Ee._SCROLLBAR_GAP,this._height-(Ee._SCROLLBAR_WIDTH+Ee._SCROLLBAR_GAP))):(this._scrollbar.render(n,Ee._SCROLLBAR_WIDTH,this._getScrollbarWidth()),this._scrollbar.setTranslate(r.isRightToLeft(this.getCtx())?Ee._SCROLLBAR_GAP:this._width-(Ee._SCROLLBAR_WIDTH+Ee._SCROLLBAR_GAP),Ee._SCROLLBAR_GAP)),this._scrollbar.setViewportRange(0,this._getAvailSize()),r.isEnvironmentTest()||this._scrollbar.setAlpha(0),this.addChild(this._scrollbar),"always"===this.scrolling&&this._showScrollbar()}else this.addChild(this._container),this.removeChild(this._maskContainer),this.removeChild(this._scrollbar)},Ee.prototype._getScrollbarWidth=function(){return(this._isHorizontalScrolling?this._width:this._height)-2*Ee._SCROLLBAR_GAP},Ee.prototype._getAvailSize=function(){return this._isHorizontalScrolling?this._width:this._height},Ee.prototype._hideScrollbar=function(t){this._isScrollbarVisible&&"always"!==this.scrolling&&(this._isScrollbarVisible=!1,this._scrollbarTimer.reset(),this._fadeOutAnim=new jt(this.getCtx(),this._scrollbar,.2),this._fadeOutAnim.play())},Ee.prototype._showScrollbar=function(t){this._isScrollbarVisible?(this._scrollbarTimer.reset(),this._scrollbarTimer.start()):(this._fadeOutAnim&&(this._fadeOutAnim.stop(!0),this._fadeOutAnim=null),this._scrollbar.setAlpha(1),this._isScrollbarVisible=!0,this._scrollbarTimer.start())},Ee.prototype._updateFade=function(t){0==t?this._maskContainer.setMask(this._fadeBottom):t+this._getAvailSize()>=this._contentSize?this._maskContainer.setMask(this._fadeTop):this._maskContainer.setMask(this._fadeTopBottom)},Ee.prototype._onMouseWheel=function(t){if(this.hasScrollingContent()){this._showScrollbar();var e=null!=t.wheelDelta?t.wheelDelta:0,i=-1*(this._isHorizontalScrolling?this._container.getTranslateX():this._container.getTranslateY())-4*e,n=Math.max(this._contentSize-this._getAvailSize(),0),r=Math.max(Math.min(i,n),0);this._isHorizontalScrolling?(this._container.setTranslateX(-1*r),this._scrollbar.setViewportRange(r+this._width,r)):(this._container.setTranslateY(-1*r),this._scrollbar.setViewportRange(r,r+this._height)),this._updateFade(r),t.preventDefault()}},Ee.prototype._handleScrollbar=function(t){this._showScrollbar(),this._isHorizontalScrolling?this._container.setTranslateX(-1*t.newMin):this._container.setTranslateY(-1*t.newMin),this._updateFade(t.newMin)},Ee.prototype.getWidth=function(){return this._width},Ee.prototype.getHeight=function(){return this._height},Ee.prototype.scrollIntoView=function(t){if(this.hasScrollingContent()){var e,i=t.getDimensions(t.getParent()),n=this._container.getDimensions();if(this._isHorizontalScrolling){var r=-1*this._container.getTranslateX(),o=i.x-n.x,s=i.x+i.w-this._width+n.x;r<s?(this._container.setTranslateX(-1*s),this._scrollbar.setViewportRange(s+this._width,s),e=s):r>o&&(this._container.setTranslateX(-1*o),this._scrollbar.setViewportRange(o+this._width,o),e=o)}else{var a=-1*this._container.getTranslateY(),h=i.y-n.y,l=i.y+i.h-this._height+n.y;a<l?(this._container.setTranslateY(-1*l),this._scrollbar.setViewportRange(l,l+this._height),e=l):a>h&&(this._container.setTranslateY(-1*h),this._scrollbar.setViewportRange(h,h+this._height),e=h)}null!=e&&this._updateFade(e)}},Ee.prototype.hasScrollingContent=function(){return this._contentSize>this._getAvailSize()};const me=function(t,e,i,n,r,o,s,a){this.Init(t,e,i,n,r,o,s,a)};i.createSubclass(me,J),me.STATE_ENABLED=0,me.STATE_OVER=1,me.STATE_DOWN=2,me.STATE_DISABLED=3,me.NO_EVENT_LISTENERS=!0,me.prototype.Init=function(t,e,i,n,r,o,s,a){me.superclass.Init.call(this,t,null,o),this.setCallback(s,a),this._bDuringInit=!0,this.setUpState(e),this.setOverState(i),this.setDownState(n),r&&this.setDisabledState(r),this.setEnabled(!0),this.drawUpState(),this._tooltip=null,this._bToggleEnabled=!1,this._bToggled=!1,this._bDuringInit=!1},me.prototype.isEnabled=function(){return this._enabled},me.prototype.setEnabled=function(t){if(this._enabled!=t){this._enabled=t;var e=r.isTouchDevice(),i=e?L.TOUCHSTART:F.CLICK,n=e?{capture:!1,passive:!1}:{capture:!1};t?(this.addEvtListener(F.MOUSEOVER,this.OnMouseOver,!1,this),this.addEvtListener(F.MOUSEOUT,this.OnMouseOut,!1,this),this.addEvtListener(F.MOUSEDOWN,this.OnMouseDown,!1,this),this.addEvtListener(F.MOUSEUP,this.OnMouseUp,!1,this),this.addEvtListener(i,this.OnClick,n,this),this.setCursor(rt.getSelectingCursor())):(this.removeEvtListener(F.MOUSEOVER,this.OnMouseOver,!1,this),this.removeEvtListener(F.MOUSEOUT,this.OnMouseOut,!1,this),this.removeEvtListener(F.MOUSEDOWN,this.OnMouseDown,!1,this),this.removeEvtListener(F.MOUSEUP,this.OnMouseUp,!1,this),this.removeEvtListener(i,this.OnClick,n,this),this.setCursor(null)),this.initState()}},me.prototype.OnMouseOver=function(t){this._bToggled?this.drawOverDownState():this.drawOverState()},me.prototype.OnMouseOut=function(t){this._bToggled?this.drawDownState():this.drawUpState()},me.prototype.OnMouseDown=function(t){this.drawDownState()},me.prototype.OnMouseUp=function(t){this._bToggled?r.isTouchDevice()?this.drawDownState():this.drawOverDownState():r.isTouchDevice()?this.drawUpState():this.drawOverState()},me.prototype.OnClick=function(t){this._bToggleEnabled&&(this._bToggled=!this._bToggled,this._bToggled?r.isTouchDevice()?this.drawDownState():this.drawOverDownState():r.isTouchDevice()?this.drawUpState():this.drawOverState()),this._callback&&(this._callback.call(this._callbackObj,t,this),t.stopPropagation(),t.preventDefault())},me.prototype.drawUpState=function(){this._enableButton(this.upState,!0),this._enableButton(this.downState,!1),this._enableButton(this.overState,!1),this._enableButton(this.disabledState,!1),this._enableButton(this.overDownState,!1)},me.prototype.drawOverState=function(){this._enableButton(this.upState,!1),this._enableButton(this.downState,!1),this._enableButton(this.overState,!0),this._enableButton(this.disabledState,!1),this._enableButton(this.overDownState,!1)},me.prototype.drawDownState=function(){this._enableButton(this.upState,!1),this._enableButton(this.downState,!0),this._enableButton(this.overState,!1),this._enableButton(this.disabledState,!1),this._enableButton(this.overDownState,!1)},me.prototype.drawDisabledState=function(){this._enableButton(this.upState,!1),this._enableButton(this.overState,!1),this._enableButton(this.downState,!1),this._enableButton(this.disabledState,!0),this._enableButton(this.overDownState,!1)},me.prototype.drawOverDownState=function(){this.overDownState?(this._enableButton(this.upState,!1),this._enableButton(this.overState,!1),this._enableButton(this.downState,!1),this._enableButton(this.disabledState,!1),this._enableButton(this.overDownState,!0)):this.drawDownState()},me.prototype._enableButton=function(t,e){t&&t.setAlpha(e?1:0)},me.prototype._enableMouseEvents=function(t,e){t.setMouseEnabled&&t.setMouseEnabled(e);for(var i=t.firstChild;null!=i;)this._enableMouseEvents(i,e),i=i.nextSibling},me.prototype.setUpState=function(t){if(!this.upState||this.upState!=t){var e=!1;if(this.upState)e=this._isButtonEnabled(this.upState),this.removeChild(this.upState);else if(!this._bDuringInit){var i=!1,n=!1,r=!1;this.downState&&(i=this._isButtonEnabled(this.downState)),this.overState&&(n=this._isButtonEnabled(this.overState)),this.disabledState&&(r=this._isButtonEnabled(this.disabledState)),i||n||r||(e=!0)}t&&this.addChild(t),this.upState=t,this._enableButton(this.upState,e)}},me.prototype.setDownState=function(t){if(!this.downState||this.downState!=t){var e=!1;this.downState&&(e=this._isButtonEnabled(this.downState),this.removeChild(this.downState)),t&&this.addChild(t),this.downState=t,this._enableButton(this.downState,e)}},me.prototype.setOverState=function(t){if(!this.overState||this.overState!=t){var e=!1;this.overState&&(e=this._isButtonEnabled(this.overState),this.removeChild(this.overState)),t&&this.addChild(t),this.overState=t,this._enableButton(this.overState,e)}},me.prototype.setDisabledState=function(t){if(!this.disabledState||this.disabledState==t){var e=!1;this.disabledState&&(e=this._isButtonEnabled(this.disabledState),this.removeChild(this.disabledState)),t&&this.addChild(t),this.disabledState=t,this._enableButton(this.disabledState,e)}},me.prototype.setOverDownState=function(t){if(!this.overDownState||this.overDownState==t){var e=!1;this.overDownState&&(e=this._isButtonEnabled(this.overDownState),this.removeChild(this.overDownState)),t&&this.addChild(t),this.overDownState=t,this._enableButton(this.overDownState,e)}},me.prototype.setCallback=function(t,e){this._callback=t,this._callbackObj=e},me.prototype.setTooltip=function(t){this._tooltip=t,t&&(this.setAriaRole("button"),this.setAriaProperty("label",t))},me.prototype.getTooltip=function(){return this._tooltip},me.prototype.initState=function(){this.isEnabled()?this.drawUpState():this.drawDisabledState()},me.prototype.setToggleEnabled=function(t){this._bToggleEnabled=t},me.prototype.setToggled=function(t){this._bToggleEnabled&&(this._bToggled=t,this._bToggled?this.drawDownState():this.drawUpState())},me.prototype.isToggled=function(){return this._bToggled},me.prototype._isButtonEnabled=function(t){var e=!1;return t&&(e=t.getAlpha()>0),e},me.prototype.showKeyboardFocusEffect=function(){this._keyboardFocusEffect||(this._keyboardFocusEffect=this.CreateKeyboardFocusEffect()),this._keyboardFocusEffect.show(),this._isShowingKeyboardFocusEffect=!0,this.getCtx().setActiveElement(this)},me.prototype.hideKeyboardFocusEffect=function(){this._keyboardFocusEffect&&this._keyboardFocusEffect.hide(),this._isShowingKeyboardFocusEffect=!1},me.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},me.prototype.CreateKeyboardFocusEffect=function(){return new ie(this.getCtx(),this,this.getDimensions(),null,null,!0)},me.prototype.handleKeyboardEvent=function(t){var e=t.keyCode;e!=P.ENTER&&e!=P.SPACE||this._callback&&(this._callback.call(this._callbackObj,t,this),t.stopPropagation(),t.preventDefault())};const be=function(t,e,i,n,r,o,s){this.Init(t,e,i,n,r,o,s)};i.createSubclass(be,J),be.prototype.Init=function(t,e,i,n,r,o,s){be.superclass.Init.call(this,t,null,r),this.setCallback(o,s),this._chroming=e,n||(n=this._createDefaultBackground(i.size));var a=n.copyShape();a.setClassName("oj-dvt-button-background"),this.addChild(a),this.addChild(n);var h=at.createIcon(this.getCtx(),i);this.addChild(h),this._tooltip=null,this._bToggleEnabled=!1,this._bToggled=!1,this._bMouseOver=!1,this._bMouseDown=!1,this.setEnabled(!0)},be.prototype._createDefaultBackground=function(t){var e=b.roundedRectangle(-4,-4,t+8,t+8,4,4,4,4),i=new ce(this.getCtx(),e);return i.setPixelHinting(r.getDevicePixelRatio()>1),i},be.prototype.isEnabled=function(){return this._enabled},be.prototype.setEnabled=function(t){if(this._enabled!=t){this._enabled=t;var e=r.isTouchDevice(),i=e?L.TOUCHSTART:F.CLICK,n=e?{capture:!1,passive:!1}:{capture:!1};t?(this.addEvtListener(F.MOUSEOVER,this.OnMouseOver,!1,this),this.addEvtListener(F.MOUSEOUT,this.OnMouseOut,!1,this),this.addEvtListener(F.MOUSEDOWN,this.OnMouseDown,!1,this),this.addEvtListener(F.MOUSEUP,this.OnMouseUp,!1,this),this.addEvtListener(i,this.OnClick,n,this),this.setCursor(rt.getSelectingCursor())):(this.removeEvtListener(F.MOUSEOVER,this.OnMouseOver,!1,this),this.removeEvtListener(F.MOUSEOUT,this.OnMouseOut,!1,this),this.removeEvtListener(F.MOUSEDOWN,this.OnMouseDown,!1,this),this.removeEvtListener(F.MOUSEUP,this.OnMouseUp,!1,this),this.removeEvtListener(i,this.OnClick,n,this),this.setCursor(null),this._bMouseOver=!1,this._bMouseDown=!1),this._updateClasses()}},be.prototype.OnMouseOver=function(t){this._bMouseOver=!0,this._updateClasses()},be.prototype.OnMouseOut=function(t){this._bMouseOver=!1,this._updateClasses()},be.prototype.OnMouseDown=function(t){this._bMouseDown=!0,this._updateClasses()},be.prototype.OnMouseUp=function(t){this._bMouseDown=!1,this._updateClasses()},be.prototype.OnClick=function(t){this._bToggleEnabled&&this.setToggled(!this._bToggled),this._callback&&(this._callback.call(this._callbackObj,t,this),t.stopPropagation(),t.preventDefault())},be.prototype.setCallback=function(t,e){this._callback=t,this._callbackObj=e},be.prototype.setTooltip=function(t){this._tooltip=t,t&&(this.setAriaRole("button"),this.setAriaProperty("label",t))},be.prototype.getTooltip=function(){return this._tooltip},be.prototype.setToggleEnabled=function(t){this._bToggleEnabled=t,this._updateClasses()},be.prototype.setToggled=function(t){this._bToggleEnabled&&(this._bToggled=t,this._updateClasses())},be.prototype.isToggled=function(){return this._bToggled},be.prototype.showKeyboardFocusEffect=function(){this._keyboardFocusEffect||(this._keyboardFocusEffect=this.CreateKeyboardFocusEffect()),this._keyboardFocusEffect.show(),this._isShowingKeyboardFocusEffect=!0,this.getCtx().setActiveElement(this)},be.prototype.hideKeyboardFocusEffect=function(){this._keyboardFocusEffect&&this._keyboardFocusEffect.hide(),this._isShowingKeyboardFocusEffect=!1},be.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},be.prototype.CreateKeyboardFocusEffect=function(){return new ie(this.getCtx(),this,this.getDimensions(),null,null,!0)},be.prototype.handleKeyboardEvent=function(t){var e=t.keyCode;e!=P.ENTER&&e!=P.SPACE||this._callback&&(this._callback.call(this._callbackObj,t,this),t.stopPropagation(),t.preventDefault())},be.prototype._updateClasses=function(){this.getElem();var t=!1,e=!1,i=!1,n=this._bToggleEnabled&&this._bToggled,r=this._bToggleEnabled&&!this._bToggled;this._enabled?(e=this._bMouseOver,i=this._bMouseDown):t=!0,this.setClassName(`oj-dvt-button-${this._chroming}${n?" oj-selected":""}${r?" oj-unselected":""}${t?" oj-disabled":""}${e?" oj-hover":""}${i?" oj-active":""}`)};const Ce=function(t,e,i,n,r){this.Init(t,e,i,n,r)};i.createSubclass(Ce,be),Ce._DEFAULT_RADIUS=15.5,Ce.prototype.Init=function(t,e,i,n,o){var s=Ce._DEFAULT_RADIUS,a=new he(t,s,s,s);Ce.superclass.Init.call(this,t,"outlined",{style:e,size:i,pos:{x:s,y:s}},a,null,o,n);var h=t.getStage();h.addEvtListener(H.FOCUS,this._onFocus,!0,this),h.addEvtListener(H.BLUR,this._onBlur,!0,this),r.isTouchDevice()||("ie"===r.browser||"edge"===r.browser?(h.addEvtListener("mouseenter",this._onMouseOver,!1,this),h.addEvtListener("mouseleave",this._onMouseOut,!1,this)):(h.addEvtListener(F.MOUSEOVER,this._onMouseOver,!1,this),h.addEvtListener(F.MOUSEOUT,this._onMouseOut,!1,this)))},Ce.prototype.show=function(){this.setAlpha(1)},Ce.prototype.hide=function(){this.setAlpha(0)},Ce.prototype._onFocus=function(t){this._isFocused=!0,this.show()},Ce.prototype._onBlur=function(t){this._isFocused=!1,this._isMouseOver||this.hide()},Ce.prototype._onMouseOver=function(t){this._mouseOutTimer&&this._mouseOutTimer.isRunning()&&this._mouseOutTimer.stop(),this._isMouseOver=!0,this.show()},Ce.prototype._onMouseOut=function(t){this._mouseOutTimer||(this._mouseOutTimer=new ut(this.getCtx(),10,this._onMouseOutTimerEnd,this,1)),this._mouseOutTimer.reset(),this._mouseOutTimer.start()},Ce.prototype._onMouseOutTimerEnd=function(){this._isMouseOver=!1,this._isFocused||this.hide()},Ce.prototype.OnMouseDown=function(t){Ce.superclass.OnMouseDown.call(this,t),t.stopPropagation()},Ce.prototype.OnMouseUp=function(t){Ce.superclass.OnMouseUp.call(this,t),t.stopPropagation()};const Ae=function(t,e,i,n){this.Init(t,e,i,n)};i.createSubclass(Ae,i),Ae.prototype.Init=function(t,e,i,n){this._tooltipManager=t,this._tooltipFunc=e,this._datatipColor=i,this._dataContext=n},Ae.prototype.getDatatip=function(t){return this._tooltipManager.getCustomTooltip(this._tooltipFunc,this._dataContext)},Ae.prototype.getDatatipColor=function(t){return this._datatipColor};const Oe=function(t){this.Init(t)};i.createSubclass(Oe,i),Oe.prototype.Init=function(t){this._comp=t},Oe.TOOLTIP_SUBID="tooltip",Oe.prototype.getSubIdForDomElement=function(t){var e=Oe._findDisplayable(t);return!e||e instanceof Array?t&&this.IsTooltipElement(t)?Oe.TOOLTIP_SUBID:null:this.GetSubIdForDomElement(e)},Oe.prototype.GetSubIdForDomElement=function(t){return null},Oe.prototype.getDomElementForSubId=function(t){return null},Oe._findDisplayable=function(t){for(;t;){if(t._obj)return t._obj;t=t.parentNode}return null},Oe.prototype.GetTooltipElement=function(t,e){if(t){var i=t.getCtx().getTooltipManager(e).getTooltipElem();return"hidden"==i.style.visibility?null:i}return null},Oe.prototype.IsTooltipElement=function(t){var e=t.getAttribute("id");return!(!e||0!=e.indexOf(it._TOOLTIP_DIV_ID))};const Ie=function(t){this.Init(t)};i.createSubclass(Ie,i),Ie.prototype.Init=function(t){this._eventManager=t},Ie.prototype.processKeyDown=function(t){var e=this._eventManager.getFocus();return e&&(this.isNavigationEvent(t)||this.isMultiSelectEvent(t))?(It.consumeEvent(t),e.getNextNavigable(t)):null},Ie.getNextNavigable=function(t,e,i,n,r){var o=null,s=0,a=0,h=e.keyCode;if(!t)return!i||i.length<1?null:i[0];for(var l,u=t.getKeyboardBoundingBox(r),c=0;c<i.length;c++){var _=i[c];t!==_&&(l=_.getKeyboardBoundingBox(r),(n||Ie._isInBounds(u,l,h))&&(a=Ie._computeDelta(u,l,h),((h==P.UP_ARROW||h==P.LEFT_ARROW)&&a<0&&(!o||a>s)||(h==P.DOWN_ARROW||h==P.RIGHT_ARROW)&&a>0&&(!o||a<s))&&(o=_,s=a)))}return o||t},Ie.prototype.getDefaultNavigable=function(t){if(!t||t.length<=0)return null;for(var e,i,n=t[0],o=n.getKeyboardBoundingBox(),s=1;s<t.length;s++)(((i=(e=t[s]).getKeyboardBoundingBox()).x==o.x&&i.y<o.y||i.x<o.x)&&!r.isRightToLeft(this._eventManager.getCtx())||(i.x+i.w==o.x+o.w&&i.y<o.y||i.x+i.w>o.x+o.w)&&r.isRightToLeft(this._eventManager.getCtx()))&&(o=(n=e).getKeyboardBoundingBox());return n},Ie.prototype.isNavigationEvent=function(t){switch(t.keyCode){case P.UP_ARROW:case P.DOWN_ARROW:case P.LEFT_ARROW:case P.RIGHT_ARROW:return!0}return!1},Ie.prototype.isSelectionEvent=function(t){return!1},Ie.prototype.isMultiSelectEvent=function(t){return!1},Ie._isInBounds=function(t,e,i){if(i==P.UP_ARROW||i==P.DOWN_ARROW){var n=t.x,r=n+t.w,o=e.x;return!(n>=o+e.w||r<=o)}if(i==P.LEFT_ARROW||i==P.RIGHT_ARROW){var s=t.y,a=s+t.h,h=e.y;return!(s>=h+e.h||a<=h)}},Ie._computeDelta=function(t,e,i){var n=0,r=t.getCenter().x,o=t.getCenter().y,s=e.getCenter().x,a=e.getCenter().y;return i==P.UP_ARROW||i==P.DOWN_ARROW?n=a-o:i!=P.LEFT_ARROW&&i!=P.RIGHT_ARROW||(n=s-r),n},Ie.getNextAdjacentNavigable=function(t,e,i){var n=e.keyCode;if(!i)return null;if(!t)return i[0];for(var r=t,o=Number.MAX_VALUE,s=!1,a=!1,h=0;h<i.length;h++){var l=i[h];if(l!==t){if(Ie._isValidDestination(l,t,n)){var u=Ie._calcInContact(l,t,n);if(!s||u){var c=Ie._calcDistanceAngleWeighted(l,t,n);(0!=c||a)&&(!s&&u||c<o&&(s&&u||!s))&&(o=c,r=l,s=u)}}}else a=!0}return r},Ie._calcInContact=function(t,e,i){var n=t.getKeyboardBoundingBox(),r=e.getKeyboardBoundingBox();switch(i){case P.UP_ARROW:return Ie._isVerticallyAligned(n,r)&&(r.y<=n.y+n.h||Ie._areEqualWithinTolerance(r.y,n.y+n.h));case P.DOWN_ARROW:return Ie._isVerticallyAligned(n,r)&&(n.y<=r.y+r.h||Ie._areEqualWithinTolerance(n.y,r.y+r.h));case P.RIGHT_ARROW:return Ie._isHorizontallyAligned(n,r)&&(n.x<=r.x+r.w||Ie._areEqualWithinTolerance(n.x,r.x+r.w));case P.LEFT_ARROW:return Ie._isHorizontallyAligned(n,r)&&(r.x<=n.x+n.w||Ie._areEqualWithinTolerance(r.x,n.x+n.w))}return!1},Ie._isVerticallyAligned=function(t,e){return t.x>=e.x&&t.x<=e.x+e.w||e.x>=t.x&&e.x<=t.x+t.w},Ie._isHorizontallyAligned=function(t,e){return t.y>=e.y&&t.y<=e.y+e.h||e.y>=t.y&&e.y<=t.y+t.h},Ie._calcDistanceAngleWeighted=function(t,e,i){var n=15/180*Math.PI,r=40/180*Math.PI,o=t.getKeyboardBoundingBox(),s=o.x+o.w/2,a=o.y+o.h/2,h=e.getKeyboardBoundingBox(),l=h.x+h.w/2,u=h.y+h.h/2,c=Math.abs(s-l),_=Math.abs(a-u),p=Math.atan2(_,c),d=Math.sqrt(c*c+_*_);return(p>n&&(i==P.RIGHT_ARROW||i==P.LEFT_ARROW)||p<S.HALF_PI-n&&(i==P.UP_ARROW||i==P.DOWN_ARROW))&&(p>r&&(i==P.RIGHT_ARROW||i==P.LEFT_ARROW)||p<S.HALF_PI-r&&(i==P.UP_ARROW||i==P.DOWN_ARROW)?d*=6:d*=2),d},Ie._isValidDestination=function(t,e,i){var n=t.getKeyboardBoundingBox(),r=e.getKeyboardBoundingBox();switch(i){case P.UP_ARROW:return n.y<r.y||Ie._areEqualWithinTolerance(n.y,r.y);case P.DOWN_ARROW:return n.y>r.y||Ie._areEqualWithinTolerance(n.y,r.y);case P.RIGHT_ARROW:return n.x>r.x||Ie._areEqualWithinTolerance(n.x,r.x);case P.LEFT_ARROW:return n.x<r.x||Ie._areEqualWithinTolerance(n.x,r.x)}return!0},Ie._areEqualWithinTolerance=function(t,e){return Math.abs(t-e)<=1e-7};const Ne=function(t,e,i,n,r,o,s,a,h){this.Init(t,e,i,n,r,o,s,a,h)};i.createSubclass(Ne,i),Ne.prototype.Init=function(t,e,i,n,r,o,s,a,h){this._context=t.getCtx(),this._container=t,this._bounds=e,this._fill=n,this._stroke=r,this._strokeWidth=1,this._allowHoriz=null==o||o,this._allowVert=null==s||s,this._horizBounds=a,this._vertBounds=h,this._glassPane=new lt(this._context,i.x,i.y,i.w,i.h),this._glassPane.setInvisibleFill(),this._marqueeOn=!1,this._marqueeDrawn=!1,this._resizeHoriz=!1,this._resizeVert=!1},Ne.prototype.processDragStart=function(t,e){if(!this._marqueeOn){if(this._origPt=this._container.stageToLocal(t),this._resizeHoriz=this._allowHoriz,this._resizeVert=this._allowVert,!this._bounds.containsPoint(this._origPt.x,this._origPt.y))if(this._vertBounds&&this._vertBounds.containsPoint(this._origPt.x,this._origPt.y))this._resizeHoriz=!1;else{if(!this._horizBounds||!this._horizBounds.containsPoint(this._origPt.x,this._origPt.y))return null;this._resizeVert=!1}return this._marqueeOn=!0,this._marquee=null,this._marqueeInnerArea=null,this._createMarqueeEvent("start",e)}return null},Ne.prototype.processDragMove=function(t,e){if(!this._marqueeOn)return null;this._marqueeDrawn||(this._container.addChild(this._glassPane),this._marquee=new lt(this._context,this._bounds.x,this._bounds.y,this._bounds.w,this._bounds.h),this._marqueeInnerArea=new lt(this._context,this._bounds.x,this._bounds.y,this._bounds.w,this._bounds.h),this._marquee.getElem().setAttribute("pointer-events","none"),this._marqueeInnerArea.getElem().setAttribute("pointer-events","none"),this._resizeHoriz&&(this._marquee.setX(this._origPt.x),this._marquee.setWidth(0),this._marqueeInnerArea.setX(this._origPt.x),this._marqueeInnerArea.setWidth(0)),this._resizeVert&&(this._marquee.setY(this._origPt.y),this._marquee.setHeight(0),this._marqueeInnerArea.setY(this._origPt.y),this._marqueeInnerArea.setHeight(0)),this._marquee.setClassName("oj-dvt-marquee"),this._marquee.setStyle({stroke:this._stroke.getColor(),fill:this._fill.getColor()}),this._marquee.setPixelHinting(!0),this._glassPane.addChild(this._marquee),this._marqueeInnerArea.setClassName("oj-dvt-marquee-inner-area"),this._marqueeInnerArea.setPixelHinting(!0),this._glassPane.addChild(this._marqueeInnerArea),this._marqueeDrawn=!0);var i=this._container.stageToLocal(t);if(i.x=Math.max(i.x,this._bounds.x),i.x=Math.min(i.x,this._bounds.x+this._bounds.w),i.y=Math.max(i.y,this._bounds.y),i.y=Math.min(i.y,this._bounds.y+this._bounds.h),this._resizeHoriz){var n=Math.abs(i.x-this._origPt.x),r=i.x<this._origPt.x?i.x:this._origPt.x;this._marquee.setWidth(n),this._marquee.setX(r);var o=n-2*this._strokeWidth;this._marqueeInnerArea.setWidth(Math.max(0,o)),this._marqueeInnerArea.setX(r+this._strokeWidth)}if(this._resizeVert){var s=Math.abs(i.y-this._origPt.y),a=i.y<this._origPt.y?i.y:this._origPt.y;this._marquee.setHeight(s),this._marquee.setY(a);var h=s-2*this._strokeWidth;this._marqueeInnerArea.setHeight(Math.max(0,h)),this._marqueeInnerArea.setY(a+this._strokeWidth)}return this._createMarqueeEvent("move",e)},Ne.prototype.processDragEnd=function(t,e){return this._marqueeOn&&(this._marqueeOn=!1,this._marqueeDrawn)?(this._glassPane.removeChild(this._marquee),this._glassPane.removeChild(this._marqueeInnerArea),this._container.removeChild(this._glassPane),this._marqueeDrawn=!1,this._createMarqueeEvent("end",e)):null},Ne.prototype.cancelMarquee=function(){return!(!this._marqueeOn||(this._marqueeOn=!1,!this._marqueeDrawn))&&(this._glassPane.removeChild(this._marquee),this._glassPane.removeChild(this._marqueeInnerArea),this._container.removeChild(this._glassPane),this._marqueeDrawn=!1,!0)},Ne.prototype._createMarqueeEvent=function(t,e){var i=null,n=null,r=null,o=null;return this._resizeHoriz&&(i=this._marquee?this._marquee.getX():this._origPt.x,r=this._marquee?this._marquee.getWidth():0),this._resizeVert&&(n=this._marquee?this._marquee.getY():this._origPt.y,o=this._marquee?this._marquee.getHeight():0),new yt.newMarqueeEvent(t,i,n,r,o,e)},Ne.prototype.getCursor=function(t){var e=this._container.stageToLocal(t),i=this._bounds.containsPoint(e.x,e.y),n=this._vertBounds&&this._vertBounds.containsPoint(e.x,e.y),r=this._horizBounds&&this._horizBounds.containsPoint(e.x,e.y);return i||n||r?"crosshair":"inherit"},Ne.prototype.getGlassPane=function(){return this._glassPane};const Re=function(t,e,i,n){this.Init(t,e,i,n)};i.createSubclass(Re,i),Re.prototype.Init=function(t,e,i,n){this._context=t.getCtx(),this._container=t,this._bounds=e,this._zoomRate=n,this._glassPane=new lt(this._context,i.x,i.y,i.w,i.h),this._glassPane.setInvisibleFill(),this._panOn=!1,this._glassPaneDrawn=!1,this._pinchOn=!1},Re.prototype.processDragStart=function(t){return this._panOn?null:(this._origPt=this._container.stageToLocal(t),this._lastPt=this._origPt,this._bounds.containsPoint(this._origPt.x,this._origPt.y)?(this._panOn=!0,yt.newPanZoomEvent("panStart",0,0,0,0,0,0,0,0)):null)},Re.prototype.processDragMove=function(t){if(!this._panOn)return null;this._glassPaneDrawn||(this._container.addChild(this._glassPane),this._glassPaneDrawn=!0);var e=this._container.stageToLocal(t),i=e.x-this._lastPt.x,n=e.y-this._lastPt.y,r=e.x-this._origPt.x,o=e.y-this._origPt.y;return this._lastPt=e,yt.newPanZoomEvent("panMove",-i,-i,-n,-n,-r,-r,-o,-o)},Re.prototype.processDragEnd=function(t){if(this._panOn&&(this._panOn=!1,this._glassPaneDrawn)){this._container.removeChild(this._glassPane),this._glassPaneDrawn=!1;var e=t?this._container.stageToLocal(t):this._lastPt,i=e.x-this._lastPt.x,n=e.y-this._lastPt.y,r=e.x-this._origPt.x,o=e.y-this._origPt.y;return this._lastPt=null,yt.newPanZoomEvent("panEnd",-i,-i,-n,-n,-r,-r,-o,-o)}return null},Re.prototype.processMouseWheel=function(t,e){var i=this._container.stageToLocal(t);if(!this._bounds.containsPoint(i.x,i.y))return null;var n=(e*=this._zoomRate)*(i.x-this._bounds.x),r=-e*(this._bounds.x+this._bounds.w-i.x),o=e*(i.y-this._bounds.y),s=-e*(this._bounds.y+this._bounds.h-i.y);return yt.newPanZoomEvent("zoom",n,r,o,s,n,r,o,s)},Re.prototype.processPinchStart=function(t,e){return this._pinchOn?null:(this._origPt1=this._container.stageToLocal(t),this._origPt2=this._container.stageToLocal(e),this._lastPt1=this._origPt1,this._lastPt2=this._origPt2,this._bounds.containsPoint(this._origPt1.x,this._origPt1.y)&&this._bounds.containsPoint(this._origPt2.x,this._origPt2.y)?(this._pinchOn=!0,yt.newPanZoomEvent("pinchStart",0,0,0,0,0,0,0,0)):null)},Re.prototype.processPinchMove=function(t,e){if(!this._pinchOn)return null;var i=this._container.stageToLocal(t),n=this._container.stageToLocal(e),r=this._computePinchDeltas(i,n,this._lastPt1,this._lastPt2),o=this._computePinchDeltas(i,n,this._origPt1,this._origPt2);return this._lastPt1=i,this._lastPt2=n,yt.newPanZoomEvent("pinchMove",r.dxMin,r.dxMax,r.dyMin,r.dyMax,o.dxMin,o.dxMax,o.dyMin,o.dyMax)},Re.prototype.processPinchEnd=function(){if(this._pinchOn){this._pinchOn=!1;var t=this._computePinchDeltas(this._lastPt1,this._lastPt2,this._origPt1,this._origPt2);return this._lastPt1=null,this._lastPt2=null,yt.newPanZoomEvent("pinchEnd",0,0,0,0,t.dxMin,t.dxMax,t.dyMin,t.dyMax)}return null},Re.prototype._computePinchDeltas=function(t,e,i,n){var r=Math.abs(t.x-e.x),o=Math.abs(t.y-e.y),s=Math.abs(i.x-n.x),a=Math.abs(i.y-n.y),h=r>o/2?s/r:1,l=o>r/2?a/o:1,u=(t.x+e.x)/2,c=(t.y+e.y)/2,_=u-(i.x+n.x)/2,p=c-(i.y+n.y)/2,d=(1-h)*(u-this._bounds.x),g=(h-1)*(this._bounds.x+this._bounds.w-u),f=(1-l)*(c-this._bounds.y),y=(l-1)*(this._bounds.y+this._bounds.h-c);return{dxMin:d-=_,dxMax:g-=_,dyMin:f-=p,dyMax:y-=p}},Re.prototype.zoomBy=function(t){var e=(1/t-1)/2,i=-e*this._bounds.w,n=e*this._bounds.w,r=-e*this._bounds.h,o=e*this._bounds.h;return yt.newPanZoomEvent("zoom",i,n,r,o,i,n,r,o)},Re.prototype.panBy=function(t,e){var i=t*this._bounds.w*(r.isRightToLeft(this._context)?-1:1),n=e*this._bounds.h;return yt.newPanZoomEvent("panEnd",i,i,n,n,i,i,n,n)},Re.prototype.getCursor=function(t){return null==t||this.isWithinBounds(t)?this._panOn?u.getGrabbingCursor():u.getGrabCursor():"inherit"},Re.prototype.isWithinBounds=function(t){var e=this._container.stageToLocal(t);return this._bounds.containsPoint(e.x,e.y)},t.Agent=r,t.AnimFadeIn=Yt,t.AnimFadeOut=jt,t.AnimMoveBy=Wt,t.AnimMoveTo=$t,t.AnimPopIn=te,t.AnimScaleFadeIn=Vt,t.AnimScaleTo=Jt,t.Animator=Ft,t.AriaUtils=O,t.Array2D=ne,t.ArrayUtils=d,t.Automation=Oe,t.BackgroundMultilineText=ve,t.BackgroundOutputText=ye,t.BaseAnimation=Ut,t.BaseComponent=Ct,t.BaseComponentCache=St,t.BaseComponentDefaults=Se,t.BaseEvent=M,t.BlackBoxAnimationHandler=qt,t.Button=me,t.CSSGradient=U,t.CSSStyle=j,t.Cache=v,t.CategoryRolloverHandler=Ot,t.Circle=he,t.ClipPath=p,t.ColorUtils=T,t.CombinedAnimMoveBy=zt,t.ComponentTouchEvent=dt,t.Container=J,t.Context=Mt,t.CustomAnimation=Zt,t.CustomDatatipPeer=Ae,t.DataAnimationHandler=Qt,t.Dimension=h,t.Displayable=Q,t.DisplayableUtils=q,t.DomEventFactory=k,t.DragAndDropUtils=s,t.DragSource=a,t.Easing=Lt,t.EventFactory=yt,t.EventManager=It,t.GradientFill=g,t.GradientParser=V,t.HtmlKeyboardListenerUtils=G,t.HtmlTooltipManager=it,t.IconButton=be,t.Image=le,t.ImageLoader=se,t.ImageMarker=pe,t.JsonUtils=Et,t.KeyboardEvent=P,t.KeyboardFocusEffect=ie,t.KeyboardHandler=Ie,t.LayoutUtils=re,t.Line=ue,t.LinearGradientFill=ee,t.Map2D=vt,t.MarqueeHandler=Ne,t.Mask=Dt,t.Math=S,t.Matrix=l,t.MouseEvent=F,t.MultilineText=mt,t.Obj=i,t.OutputText=at,t.PanZoomHandler=Re,t.ParallelPlayable=Gt,t.Path=ce,t.PathUtils=b,t.PatternFill=y,t.PixelMap=oe,t.Playable=kt,t.Point=n,t.Polygon=ge,t.PolygonUtils=ae,t.Polyline=fe,t.Rect=lt,t.Rectangle=m,t.ResourceUtils=Tt,t.SelectionEffectUtils=rt,t.SelectionHandler=At,t.SequentialPlayable=Bt,t.Shadow=N,t.Shape=ot,t.SimpleMarker=_e,t.SimpleObjPeer=bt,t.SimpleScrollableContainer=Ee,t.SimpleScrollbar=Te,t.SolidFill=K,t.Stroke=z,t.SvgDocumentUtils=gt,t.SvgShapeUtils=A,t.TextUtils=st,t.Timer=ut,t.ToolkitUtils=u,t.Touch=w,t.TouchEvent=L,t.TouchManager=ft,t.TransientButton=Ce,t.Use=xt,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ojdvt-toolkit.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojmap',["ojs/ojkeysetimpl"],function(e){"use strict";e=e&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e;var t=function(t){t?(this._map=t,this._keyset=new e(Array.from(this._map.keys()))):(this._map=new Map,this._keyset=new e)},s=t.prototype;return Object.defineProperty(s,"size",{get:function(){return this._map.size}}),s.clear=function(){this._map.clear(),this._keyset._keys.clear()},s.delete=function(e){var t=this._keyset.get(e);return t!==this._keyset.NOT_A_KEY&&(this._keyset._keys.delete(t),this._map.delete(t))},s.forEach=function(e){this._map.forEach(e)},s.entries=function(){return this._map.entries()},s.keys=function(){return this._map.keys()},s.values=function(){return this._map.values()},s.get=function(e){var t=this._keyset.get(e);return this._map.get(t)},s.has=function(e){return this._keyset.has(e)},s.set=function(e,t){var s=this._keyset.get(e);return s===this._keyset.NOT_A_KEY?(this._keyset._keys.add(e),this._map.set(e,t)):this._map.set(s,t),this},t});
//# sourceMappingURL=ojmap.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojattributegrouphandler',["exports","ojs/ojcore-base","jquery"],function(t,e,a){"use strict";e=e&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e,a=a&&Object.prototype.hasOwnProperty.call(a,"default")?a.default:a;const r=function(t){this.Init(t)};e.Object.createSubclass(r,e.Object,"AttributeGroupHandler"),r.prototype.Init=function(t){if(this._assignments={},this._valueIndex=0,this._matchRules={},null!=t)for(var e=Object.keys(t),a=0;a<e.length;a++){var r=e[a];this.addMatchRule(r,t[r])}},r.prototype.getValueRamp=function(){return[]},r.prototype.getValue=function(t){return this._matchRules[t]?this._matchRules[t]:(this._assignments[t]||(this._values||(this._values=this.getValueRamp().slice()),this._assignments[t]=this._values[this._valueIndex],this._valueIndex+=1,this._valueIndex===this._values.length&&(this._valueIndex=0)),this._assignments[t])},r.prototype.getCategoryAssignments=function(){for(var t=[],e=Object.keys(this._assignments),a=0;a<e.length;a++){var r=e[a];t.push({category:r,value:this._assignments[r]})}return t},r.prototype.addMatchRule=function(t,e){this._matchRules[t]=e};const s=function(t){if(this._attributeValues=[],a(document.body).hasClass("oj-hicontrast"))this._attributeValues=s._DEFAULT_COLORS.slice();else{if(!s._colors){var e=s.__createAttrDiv();a(document.body).append(e),s._colors=s.__processAttrDiv(e),e.remove()}s._colors.length>0?this._attributeValues=s._colors.slice():this._attributeValues=s._DEFAULT_COLORS.slice()}this.Init(t)};e.Object.createSubclass(s,r,"ColorAttributeGroupHandler"),s._DEFAULT_COLORS=["#237bb1","#68c182","#fad55c","#ed6647","#8561c8","#6ddbdb","#ffb54d","#e371b2","#47bdef","#a2bf39","#a75dba","#f7f37b"],s._STYLE_CLASSES=["oj-dvt-category1","oj-dvt-category2","oj-dvt-category3","oj-dvt-category4","oj-dvt-category5","oj-dvt-category6","oj-dvt-category7","oj-dvt-category8","oj-dvt-category9","oj-dvt-category10","oj-dvt-category11","oj-dvt-category12"],s._colors=null,s.prototype.getValueRamp=function(){return this._attributeValues},s.__createAttrDiv=function(){var t=a(document.createElement("div"));t.css("display","none;"),t.attr("id","attrGps");for(var e=0;e<s._STYLE_CLASSES.length;e++){var r=a(document.createElement("div"));r.addClass(s._STYLE_CLASSES[e]),t.append(r)}return t},s.__processAttrDiv=function(t){for(var e=[],r=t.children(),s=0;s<r.length;s++){var o=a(r[s]).css("color");o&&e.push(o)}return e};
/**
   * @license
   * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
   * Licensed under The Universal Permissive License (UPL), Version 1.0
   * as shown at https://oss.oracle.com/licenses/upl/
   * @ignoreg
   */
var o=function(t){this.Init(t)};e.Object.createSubclass(o,r,"ShapeAttributeGroupHandler"),o._attributeValues=["square","circle","diamond","plus","triangleDown","triangleUp","human"],o.prototype.getValueRamp=function(){return o._attributeValues},t.AttributeGroupHandler=r,t.ColorAttributeGroupHandler=s,t.ShapeAttributeGroupHandler=o,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ojattributegrouphandler.js.map;
/**
 * Copyright (c) 2015, 2017, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */
!function(){function a(){"use strict";function a(a,b,e){f[a]={deps:b.map(c),module:e,resolve:d}}function b(a,b){var c=e(a);b.apply(null,c)}function c(a){return 0===a.indexOf("./")?a.substr(2):a}function d(){if(!this._resolvedModule){var a=e(this.deps),b=this.module;this._resolvedModule="function"==typeof b?b.apply(null,a):b}return this._resolvedModule}function e(a){return a.map(function(a){return f[a].resolve()})}var f={};return{define:a,require:b}}var b=a(),c=b.define,d=b.require;c("dataTransfer",[],function(){"use strict";function a(a,b){function c(a){if("protected"!==p()){var b=f(a);return b&&m.hasOwnProperty(b)?m[b]:null}return""}function d(a,b){if("readwrite"===p()){var c=f(a);c&&(m[c]=b.toString())}}function e(a){if("readwrite"===p()){var b=f(a);b?m.hasOwnProperty(b)&&delete m[b]:m={}}}function f(a){return a?a.toString().toLowerCase():null}function g(b,c,d){a&&a(b,c,d)}function h(){var a=Object.keys(m);return a.item=function(b){return b>=0&&b<a.length?a[b]:null},a.contains=function(b){return a.indexOf(b)>=0},a}function i(){return n}function j(a){a=a.toLowerCase(),q.indexOf(a)>=0&&(n=a)}function k(){return o}function l(a){a=a.toLowerCase(),r.indexOf(a)>=0&&(o=a)}var m={},n="none",o="uninitialized",p=b||function(){return"readwrite"},q=["none","copy","link","move"],r=["uninitialized","none","copy","copylink","copymove","link","linkmove","move","all"];this.files={},this.items={},this.getData=c,this.setData=d,this.clearData=e,this.setDragImage=g,Object.defineProperty(this,"types",{get:h}),Object.defineProperty(this,"dropEffect",{get:i,set:j}),Object.defineProperty(this,"effectAllowed",{get:k,set:l})}return a}),c("dragImage",[],function(){"use strict";function a(a,b,c){function d(a){var b=0;if(a.children)for(var c=0;c<a.children.length;c++){var e=a.children[c],f=window.getComputedStyle(e);b="static"===f.position||"auto"===f.zIndex||isNaN(f.zIndex)?Math.max(b,d(e)):Math.max(b,f.zIndex)}return b}function e(a){var b=null!=a.parentNode,c=a.style.position,e=a.style.top;b||(a.style.position="fixed",a.style.top="10000px",document.body.appendChild(a));var f=a.cloneNode(!0);return f.id=a.id+"_dragimage",f.style.opacity=.7,f.style.position="fixed",f.style.width=a.offsetWidth+"px",f.style.height=a.offsetHeight+"px",f.style.zIndex=d(document.body)+1,f.style.visibility="hidden",b||(document.body.removeChild(a),a.style.position=c,a.style.top=e),f}function f(){document.body.appendChild(j),j.scrollLeft=m,j.scrollTop=n}function g(){document.body.removeChild(j),j=null}function h(a,b){j.style.left=a-k+m+"px",j.style.top=b-l+n+"px"}function i(a){j.style.visibility=a?"visible":"hidden"}var j=e(a),k=b,l=c,m=a.scrollLeft,n=a.scrollTop;this.start=f,this.end=g,this.move=h,this.show=i}return a}),c("eventDispatcher",[],function(){"use strict";function a(a,c,d){var e=b(a,c,d);return!c.target.dispatchEvent(e)}function b(a,b,d){var e;if(window.Event&&"function"==typeof window.Event){var g={bubbles:h[a].bubbles,cancelable:h[a].cancelable};e=new window.Event(a,g)}else e=document.createEvent("Event"),e.initEvent(a,h[a].bubbles,h[a].cancelable);return e.view=document.defaultView,e.detail=0,f(e,b),e.getModifierState=function(a){return c(a,b)},e.dataTransfer=d,e.__isPseudo=!0,e}function c(a,b){return"Alt"===a?b.altKey:"Control"===a?b.ctrlKey:"Meta"===a?b.metaKey:"Shift"===a&&b.shiftKey}function d(a){return a||0}function e(a){return a||!1}function f(a,b){var c=b.target.getBoundingClientRect();a.screenX=d(b.screenX),a.screenY=d(b.screenY),a.clientX=d(b.clientX),a.clientY=d(b.clientY),a.offsetX=b.clientX-c.left,a.offsetY=b.clientY-c.top,a.pageX=d(b.pageX),a.pageY=d(b.pageY),a.altKey=e(b.altKey),a.ctrlKey=e(b.ctrlKey),a.metaKey=e(b.metaKey),a.shiftKey=e(b.shiftKey),a.button=d(b.button),a.buttons=d(b.buttons),a.relatedTarget=b.relatedTarget?b.relatedTarget:null}function g(a){return{screenX:a.screenX,screenY:a.screenY,clientX:a.clientX,clientY:a.clientY,pageX:a.pageX,pageY:a.pageY,altKey:a.altKey,ctrlKey:a.ctrlKey,metaKey:a.metaKey,shiftKey:a.shiftKey,button:a.button,buttons:a.buttons}}var h={dragstart:{bubbles:!0,cancelable:!0},drag:{bubbles:!0,cancelable:!0},dragend:{bubbles:!0,cancelable:!1},dragenter:{bubbles:!0,cancelable:!0},dragover:{bubbles:!0,cancelable:!0},dragleave:{bubbles:!0,cancelable:!1},drop:{bubbles:!0,cancelable:!0}};return{dispatch:a,getMouseEventProps:g}}),c("autoScroller",[],function(){"use strict";function a(a,c,d){for(var e=a;null!=e&&!b(e,c,d);)e=e.parentNode;return e}function b(a,b,f){if(!c(a))return!1;var g,h,i=a.scrollLeft,j=a.scrollTop;if(a===document.documentElement)i=i||document.body.scrollLeft,j=j||document.body.scrollTop;else{var k=a.getBoundingClientRect();b-=Math.round(k.left),f-=Math.round(k.top)}return g=d(a.clientWidth,a.scrollWidth,b,i),h=d(a.clientHeight,a.scrollHeight,f,j),!(!g&&!h)&&(e(a,i+g,j+h),!0)}function c(a){if(a===document.body)return!1;if(a===document.documentElement)return!0;if(1===a.nodeType){var b=window.getComputedStyle(a,null);return("auto"===b.overflow||"scroll"===b.overflow)&&(a.scrollWidth>a.clientWidth||a.scrollHeight>a.clientHeight)}return!1}function d(a,b,c,d){var e=12,f=15;if(c>a-e&&c<a){if(d+a<b)return f}else if(c>=0&&c<e&&d>0)return-Math.min(d,f);return 0}function e(a,b,c){a.scrollLeft=b,a.scrollTop=c,a===document.documentElement&&(document.body.scrollLeft=b,document.body.scrollTop=c)}return{checkAutoScroll:a}}),c("dragController",["./dataTransfer","./dragImage","./eventDispatcher","./autoScroller"],function(a,b,c,d){"use strict";function e(){function e(b,c,d){var e=new a(m,f);return g("dragstart",b,d,e)?{dragState:"canceled"}:j(e,c)?k(e,b,d):{dataTransfer:e}}function f(){return Q}function g(a,b,d,e,f){return Q=h(a),"dragstart"!==a&&(e.dropEffect=i(a,e.effectAllowed)),d||(d={}),d.target=b,d.relatedTarget=f,c.dispatch(a,d,e)}function h(a){return"dragstart"===a?"readwrite":"drop"===a?"readonly":"protected"}function i(a,b){return"drag"===a||"dragleave"===a?"none":"dragenter"===a||"dragover"===a?"none"===b?"none":"move"===b?"move":0===b.indexOf("link")?"link":"copy":U}function j(a,b){return 0!==a.types.length&&(!b||b(a,M))}function k(a,b,c){return L=a,N=b,P=document.body.style.cursor,l(b,c),{dragState:"started",dataTransfer:a}}function l(a,b){if(null==M){var c=a.getBoundingClientRect(),d=b?b.clientX:c.left,e=b?b.clientY:c.top;m(a,d-c.left,e-c.top)}}function m(a,c,d){M&&(M.end(),M=null),a&&a.cloneNode&&(R={x:c,y:d},M=new b(a,c,d),M.start())}function n(a){if(a&&o()){if(M.show(!1),p(a))return D(a),!0;try{var b=q(a);r(b,a),s(b,a),v(b,a),B(b,a)}finally{M.show(!0)}}return!1}function o(){return null!=L}function p(a){return g("drag",N,a,L)}function q(a){var b=a.clientX,c=a.clientY;return b===S&&c===T?O:document.elementFromPoint(b,c)}function r(a,b){a!==O&&(a&&g("dragenter",a,b,L,O),O&&(z(O),g("dragleave",O,b,L,a)))}function s(a,b){if(a){t(g("dragover",a,b,L))}}function t(a){if(a){var b=L.effectAllowed;U="uninitialized"===b||"all"===b||b.indexOf(L.dropEffect)>=0?L.dropEffect:"none"}else U=u(O)?"copy":"none"}function u(a){return a&&("TEXTAREA"===a.nodeName||"INPUT"===a.nodeName&&"text"===a.type)}function v(a,b){w(b),x(a),A(a,b)}function w(a){M.move(a.clientX,a.clientY)}function x(a){var b;b="none"===U?"not-allowed":"copy"===U?"copy":"link"===U?"alias":"default",b!==document.body.style.cursor&&(document.body.style.cursor=b),y(a,b)}function y(a,b){a.style.cursor!==b&&(void 0===a._dndSavedCursor&&(a._dndSavedCursor=a.style.cursor),a.style.cursor=b)}function z(a){void 0!==a._dndSavedCursor&&(a.style.cursor=a._dndSavedCursor,delete a._dndSavedCursor)}function A(a,b){d.checkAutoScroll(a,b.clientX,b.clientY)&&(S=-1,T=-1)}function B(a,b){O=a,S=b.clientX,T=b.clientY}function C(a){E(a,!1)}function D(a){E(a,!0)}function E(a,b){if(o()){M.show(!1);var c=q(a);c&&(z(c),F(c,a,b),G(c,a,b)),g("dragend",N,a,L),J()}}function F(a,b,c){H(c)||g("dragleave",a,b,L)}function G(a,b,c){if(H(c)){var d=g("drop",a,b,L);return d?U=L.dropEffect:u(a)?I(a):U="none",d}return!0}function H(a){return!a&&"none"!==U}function I(a){var b=L.getData("text");if(b&&""!==b){var c=a.value,d=a.selectionEnd;a.value=c.substring(0,d)+b+c.substring(d)}}function J(){m(null,0,0),L=null,N=null,O=null,U="none",document.body.style.cursor=P,P=null}function K(a){var b=a.target,d=a.relatedTarget,e=c.getMouseEventProps(a);switch(a.type){case"drag":M&&M.show(!0),g("drag",b,e,L);break;case"dragenter":g("dragenter",b,e,L,d);break;case"dragleave":g("dragleave",b,e,L,d);break;case"dragover":var f=R.x>0?e.clientX-V:e.clientX+W,h=e.clientY;M.move(f,h);var i=g("dragover",b,e,L);t(i),i&&a.preventDefault();break;case"dragend":M&&M.show(!1),g("dragend",b,e,L,d),J(),a.dataTransfer.clearData();break;case"drop":M&&M.show(!1),i=G(b,e,!1),i&&a.preventDefault()}}var L,M,N,O,P,Q,R,S=-1,T=-1,U="none",V=50,W=10;this.start=e,this.drag=n,this.end=C,this.cancel=D,this.handleDndEvent=K}return e}),c("args",[],function(){"use strict";function a(a,c){if(b(a,c),"string"!=typeof c)throw new Error("argument '"+a+"' must be a string")}function b(a,b){if(!b)throw new Error("required argument '"+a+"' not specified")}return{requiredString:a,required:b}}),c("glassPane",["./eventDispatcher"],function(a){"use strict";function b(b,c){function d(a){l=a,document.body.addEventListener("mouseenter",h,!0),document.body.addEventListener("mousemove",i,!0),document.body.addEventListener("mouseup",j,!0),k=window.setInterval(g,200)}function e(){k&&(window.clearInterval(k),k=null),document.body.removeEventListener("mouseenter",h,!0),document.body.removeEventListener("mousemove",i,!0),document.body.removeEventListener("mouseup",j,!0)}function f(){return l}function g(){try{b(l)}finally{}}function h(b){b.target===document.body&&b.buttons!==m&&(l=a.getMouseEventProps(b),c(l,!0))}function i(b){void 0===m&&(m=b.buttons),b.stopPropagation(),b.preventDefault(),l=a.getMouseEventProps(b),g()}function j(b){b.stopPropagation(),b.preventDefault(),l=a.getMouseEventProps(b),c(l,!1)}var k,l,m;this.start=d,this.end=e,this.getLastInputProps=f}return b}),c("desktopDragDriver",["./args","./glassPane","./eventDispatcher"],function(a,b,c){"use strict";function d(d,e){function f(){var a=navigator.userAgent.toLowerCase();(a.indexOf("trident")>0||a.indexOf("edge")>0||a.indexOf("phantomjs")>0)&&(e.addEventListener("dragstart",i,!0),e.addEventListener("drag",v,!0),e.addEventListener("dragover",v,!0),e.addEventListener("dragend",v,!0),e.addEventListener("dragenter",v,!0),e.addEventListener("dragleave",v,!0),e.addEventListener("drop",v,!0),e.addEventListener("pointerdown",h,!0))}function g(){e.removeEventListener("dragstart",i,!0),e.removeEventListener("drag",v,!0),e.removeEventListener("dragover",v,!0),e.removeEventListener("dragend",v,!0),e.removeEventListener("dragenter",v,!0),e.removeEventListener("dragleave",v,!0),e.removeEventListener("drop",v,!0),e.removeEventListener("pointerdown",h,!0)}function h(a){x=a.pointerType}function i(a){if("touch"===x){var b=a.target;b.style.visibility="hidden",u(a),setTimeout(function(){b.style.visibility="visible"},0)}else j(a)}function j(a){var b,e=c.getMouseEventProps(a);a.stopPropagation(),g();try{b=d.start(a.target,k,e)}finally{f()}"canceled"===b.dragState?a.preventDefault():"started"===b.dragState?o(a,b,e):m(b.dataTransfer,a)}function k(a,b){return null!=b||l(a)}function l(a){var b=a.types;if(0===b.length)return!1;for(var c=0;c<b.length;c++){var d=b[c].toLowerCase();if("text"!==d&&"url"!==d)return!0}return!1}function m(a,b){n(a,b,"text"),n(a,b,"url")}function n(a,b,c){var d=a.getData(c);d&&b.dataTransfer.setData(c,d)}function o(a,b,c){a.preventDefault(),p(c)}function p(a){w=new b(r,s),w.start(a),document.body.addEventListener("keydown",t,!0)}function q(){w&&(w.end(),w=null),document.body.removeEventListener("keydown",t,!0)}function r(a){var b=d.drag(a);return b&&q(),b}function s(a,b){q(),b?d.cancel(a):d.end(a)}function t(a){if(a.stopPropagation(),a.preventDefault(),"Esc"===a.key||27===a.keyCode){var b=w.getLastInputProps();q(),d.cancel(b)}}function u(a){if(!a.__isPseudo){a.stopPropagation();for(var b=a.target;b&&!b.draggable;)b=b.parentNode;if(b){y=b;var e=c.getMouseEventProps(a);"started"!==d.start(y,null,e).dragState&&(a.preventDefault(),y=null)}}}function v(a){a.__isPseudo||y&&(a.stopPropagation(),d.handleDndEvent(a),"dragend"===a.type&&(y=null))}a.required("controller",d);var w,x,y;this.install=f,this.remove=g}return d}),c("touchDragDriver",["./args"],function(a){"use strict";function b(b,c){function d(){c.addEventListener("touchstart",g,{passive:!0,capture:!0}),c.addEventListener("touchmove",h,{passive:!1,capture:!0})}function e(){c.removeEventListener("touchstart",g,{passive:!0,capture:!0}),c.removeEventListener("touchmove",h,{passive:!1,capture:!0})}function f(a){return a.hasAttribute&&a.hasAttribute("draggable")&&a.draggable}function g(a){for(var b=a.target;b&&!f(b);)b=b.parentNode;b&&i(b)}function h(){}function i(a){a.addEventListener("touchstart",k,{passive:!0}),a.addEventListener("touchmove",l,{passive:!1}),a.addEventListener("touchend",m,{passive:!0}),a.addEventListener("touchcancel",n,{passive:!0})}function j(a){a.removeEventListener("touchstart",k,{passive:!0}),a.removeEventListener("touchmove",l,{passive:!1}),a.removeEventListener("touchend",m,{passive:!0}),a.removeEventListener("touchcancel",n,{passive:!0})}function k(a){q=a.currentTarget,r=!1}function l(a){if(a.preventDefault(),a.stopPropagation(),!r){if("started"!==b.start(q,null,p(a)).dragState)return void j(a.currentTarget);r=!0}b.drag(p(a))&&j(a.currentTarget)}function m(a){o(a,!1)}function n(a){o(a,!0)}function o(a,c){var d=a.currentTarget;c?b.cancel(p(a)):b.end(p(a)),q=null,r=!1,j(d)}function p(a){return{screenX:Math.round(a.changedTouches[0].screenX),screenY:Math.round(a.changedTouches[0].screenY),clientX:Math.round(a.changedTouches[0].clientX),clientY:Math.round(a.changedTouches[0].clientY),pageX:Math.round(a.changedTouches[0].pageX),pageY:Math.round(a.changedTouches[0].pageY),altKey:a.altKey,ctrlKey:a.ctrlKey,metaKey:a.metaKey,shiftKey:a.shiftKey}}a.required("controller",b);var q=null,r=!1;this.install=d,this.remove=e}return b}),c("bootstrap",["./dragController","./desktopDragDriver","./touchDragDriver"],function(a,b,c){"use strict";function d(){if(!g()){e(new a,-1!==navigator.userAgent.toLowerCase().indexOf("edge")?[b]:[b,c])}}function e(a,b){for(var c=document.documentElement,d=0;d<b.length;d++){var e=b[d],f=new e(a,c);f.install(),h.push(f)}}function f(){h.forEach(function(a){a.remove()}),h=[]}function g(){return h.length>0}var h=[];return{init:d,destroy:f}}),d(["bootstrap"],function(a){a.init()})}();
define("ojdnd", function(){});

/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojdvt-base',["ojs/ojcore-base","ojs/ojdvt-toolkit","ojs/ojcontext","ojs/ojconfig","ojs/ojmap","ojs/ojlocaledata","ojs/ojcomponentcore","jquery","ojs/ojkeysetimpl","ojs/ojdomutils","ojs/ojattributegrouphandler","ojs/ojlogger","ojs/ojcustomelement","ojs/ojcustomelement-utils","ojs/ojmetadatautils","ojdnd"],function(e,t,n,r,i,s,o,a,l,h,c,d,u,p,_,f){"use strict";e=e&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e,n=n&&Object.prototype.hasOwnProperty.call(n,"default")?n.default:n,i=i&&Object.prototype.hasOwnProperty.call(i,"default")?i.default:i,a=a&&Object.prototype.hasOwnProperty.call(a,"default")?a.default:a,l=l&&Object.prototype.hasOwnProperty.call(l,"default")?l.default:l;const m=function(e,t){this._path=t,this._root=e,this._delimiter="/"};m.prototype._resolveLeafObjectAndProperty=function(e,t,n,r){for(var i={};e&&t.indexOf(n)>-1;){var s=t.substring(0,t.indexOf(n));r&&void 0===e[s]&&(e[s]={}),e=e[s],t=t.substring(t.indexOf(n)+1,t.length)}return e&&(i.object=e,i.parameter=t),i},m.prototype._resolvePath=function(e){if(void 0===this._leaf){var t=this._resolveLeafObjectAndProperty(this._root,this._path,this._delimiter,e);this._leaf=t.object,this._param=t.parameter}},m.prototype.getValue=function(){return this._resolvePath(!1),void 0===this._leaf?void 0:this._leaf[this._param]},m.prototype.setValue=function(e,t){this._resolvePath(!0),!t&&this._leaf[this._param]||(this._leaf[this._param]=e)};const v=function(e){this._styleCache={},this._context=e,this._letterSpacing=null,this._wordSpacing=null,this._fontVariantNumeric=null};v._FONT_WEIGHT="font-weight",v.styleTypes={TEXT:function(e){var t={};return e&&(e.hasClass("oj-gauge-metric-label")?(t["font-size"]=!0,t.color=!0):e.hasClass("oj-treemap-node-header")&&(t[v._FONT_WEIGHT]=!0)),v._buildTextCssPropertiesObject(e,t)},BACKGROUND:function(e,t,n,r){return v._buildCssBackgroundPropertiesObject(e)},ANIM_DUR:function(e){var t=e.css("animation-duration");if(t)return"ms"===t.slice(-2)?t=parseInt(t.slice(0,-2),10):"s"===t.slice(-1)&&(t=1e3*parseFloat(t.slice(0,-1))),t}},v._INHERITED_FONT_COLOR="rgb(254, 0, 254)",v._INHERITED_FONT_FAMILY="Times",v._INHERITED_FONT_SIZE="1px",v._INHERITED_FONT_WEIGHT="1",v._INHERITED_FONT_STYLE="normal",v._FONT_SIZE_BUFFER=4,v.defaultStyleProcessor=function(e,t){return e.css(t)},v._buildCssBackgroundPropertiesObject=function(e){var t={};return e.css("border-top-color")&&(t.borderColor=e.css("border-top-color")),e.css("border-width")&&e.css("border-style")&&"none"!==e.css("border-style")&&(t.borderWidth=e.css("border-width")),e.css("background-color")&&(t.backgroundColor=e.css("background-color")),t},v._buildTextCssPropertiesObject=function(e,t){var n={},r=e.css("font-family");return r&&r!==v._INHERITED_FONT_FAMILY&&(n.fontFamily=r.replace(/"/g,"'")),!(r=e.css("font-size"))||r.indexOf("px")>-1&&parseFloat(r)<v._FONT_SIZE_BUFFER||t["font-size"]||(n.fontSize=r),(r=e.css(v._FONT_WEIGHT))&&r!==v._INHERITED_FONT_WEIGHT&&!t[v._FONT_WEIGHT]&&(n.fontWeight=r),(r=e.css("color"))&&r!==v._INHERITED_FONT_COLOR&&!t.color&&(n.color=r),(r=e.css("font-style"))&&r!==v._INHERITED_FONT_STYLE&&(n.fontStyle=r),n},v.prototype.processStyles=function(e,t,n,r){var i,s=null,o=null,l=e.data("no-style-cache"),h="";for(i=0;i<n.length;i++)h=h+n[i]+" ";var c,d={},u={},p=Object.keys(r);for(i=0;i<p.length;i++){var _=r[c=p[i]];_ instanceof Array||(_=[_]);var f=this._hasUncachedProperty(c,_)||l;o||s||!f||((s=a(document.createElement("div"))).css("display","none"),e.append(s),s.attr("class",h),(o=a(document.createElement("div"))).css("font-size",v._INHERITED_FONT_SIZE),o.css("color",v._INHERITED_FONT_COLOR),o.css(v._FONT_WEIGHT,v._INHERITED_FONT_WEIGHT),o.css("font-style",v._INHERITED_FONT_STYLE),s.append(o)),d[c]=_,f&&(u[c]=this._createStyleDivs(o,c,_))}if(!this._letterSpacing||!this._wordSpacing||!this._fontVariantNumeric){var m=window.getComputedStyle(e[0]);this._context.letterSpacing=m.letterSpacing,this._context.wordSpacing=m.wordSpacing,this._context.fontVariantNumeric=m.fontVariantNumeric,this._letterSpacing=m.letterSpacing,this._wordSpacing=m.wordSpacing,this._fontVariantNumeric=m.fontVariantNumeric}for(i=0;i<p.length;i++)c=p[i],this._processStyle(u[c],t,c,d[c],l);s&&s.remove()},v.prototype._createStyleDivs=function(e,t,n){this._styleCache[t]||(this._styleCache[t]={});for(var r=null,i=0;i<n.length;i++){var s=n[i].property;if(s)void 0===this._styleCache[t][s]&&(r||("oj-dvt-color-ramp"===t?r=c.ColorAttributeGroupHandler.__createAttrDiv():(r=a(document.createElement("div"))).addClass(t),e.append(r)))}return r},v.prototype._processStyle=function(e,t,n,r,i){for(var s=0;s<r.length;s++){var o=r[s],a=o.property;if(a){var l=this._styleCache[n][a];if(void 0===l&&e&&(l="oj-dvt-color-ramp"===n?c.ColorAttributeGroupHandler.__processAttrDiv(e):v._resolveStyle(e,a),i||(this._styleCache[n][a]=l)),null!=l){var h=o.path,d=new m(t,h),u=d.getValue(),p="object"==typeof u&&!Array.isArray(u);if(p&&u)for(var _=Object.keys(l),f=0;f<_.length;f++){var y=_[f];void 0===u[y]&&(u[y]=l[y])}else d.setValue(l,p)}}}},v._resolveStyle=function(e,t){var n=v.styleTypes[t],r=n?n(e):v.defaultStyleProcessor(e,t);return null==r||"string"==typeof r&&""===r.replace(/^\s+/g,"")?null:r},v.prototype._hasUncachedProperty=function(e,t){var n=this._styleCache[e];if(!n)return!0;for(var r=0;r<t.length;r++){var i=t[r].property;if(i)if(void 0===n[i])return!0}return!1},v.populateOptions=function(e,t){for(var n,r=Object.keys(t),i=0;i<r.length;i++){var s=t[r[i]];s instanceof Array||(s=[s]);for(var o=0;o<s.length;o++){var a=(n=s[o]).path,l="TEXT"===n.property||"BACKGROUND"===n.property;if(l||a.indexOf("/")>-1)l||(a=a.substring(0,a.lastIndexOf("/"))),new m(e,a).setValue({})}}};const y=function(e,t){this._component=e,this._configMap=t,this._init()};e.Object.createSubclass(y,e.Object,"DataProviderHandler"),y.prototype._init=function(){this._dataProviderEventListeners={},this._keyDataMap={},this._fetchedData={},this._eventListeners=[]},y.prototype._fetchCollection=function(e,t,n,r,i,s){var o=this,a={data:[],keys:[]};if(s<=-1)return Promise.resolve(a);this._clientId=this._clientId||Symbol();var l={clientId:this._clientId,size:-1},h=e.fetchFirst(l)[Symbol.asyncIterator](),c=this.isTreeDataProvider(e),d=function(e){for(var s=[],l=0;l<e.value.data.length;l++){var u=t({data:e.value.data[l],key:e.value.metadata[l].key},i);s.push(u)}return Promise.all(s).then(function(e){for(var t=0;t<e.length;t++){var s=e[t].data,l=e[t].key;a.data.push(s),a.keys.push(l),o._keyDataMap[n].set(c?l.value:l,{data:s,key:l,parentKey:r,depth:i})}}).then(function(){return e.done?Promise.resolve(a):h.next().then(d)})};return h.next().then(d)},y.prototype._getDPPostProcessor=function(e,t,n,r){var i=this,s=this.isTreeDataProvider(e);r=null==r?Number.MAX_VALUE:r;var o=function(s,a){var l={value:s.data},h={value:s.key};if(a<r&&n&&n.has(h.value)){var c=e.getChildDataProvider(h.value);if(c)return i._fetchCollection(c,o,t,h.value,a+1).then(function(e){return l.children=e.data,h.children=e.keys,{data:l,key:h}})}return Promise.resolve({data:l,key:h})};return s?o:function(e){return Promise.resolve(e)}},y.prototype.fetchAllData=function(e,t,n){if(n&&this._fetchedData[t])return Promise.resolve(this._fetchedData[t]);var r=this._configMap[t];return this.clear(t,!0),this._fetchCollection(e,this._getDPPostProcessor(e,t,r.expandedKeySet,r.maxFetchDepth),t,null,0,r.maxFetchDepth).then(function(r){return n&&(this._fetchedData[t]=r,this._addDPEventListeners(e,t)),r}.bind(this))},y.prototype._getDataProviderEventHandler=function(e){var t=this,n=function(e,t,n){if(!t)return[];var r=new l(t),i=new Map,s=function(e){for(var t=0;t<e.length;t++){var o=n?e[t].value:e[t],a=r.get(o);a!==r.NOT_A_KEY&&i.set(a,t),n&&e[t].children&&s(e[t].children)}};s(e.keys);var o=[];return t.forEach(function(e){o.push(i.get(e))}),o},r=function(n){var r=t._component._GetThrottlePromise();Promise.all([n,r]).then(function(n){t._fireEvent("clearState",{dataProperty:e}),t._fetchedData[e]=n[0],t._fireEvent("dataUpdated",{data:n[0]})})};return function(i){t._fireEvent("notReady",{event:i});var s=this,o=t.isTreeDataProvider(s),a=t._keyDataMap[e];if("refresh"===i.type)r(t.fetchAllData(s,e));else if("mutate"===i.type){var h=i.detail.update,c=i.detail.remove,d=i.detail.add,u=t._fetchedData[e];if(c){var p=c.keys;if(d){var _=new l(d.keys);p=new Set([...p].filter(e=>!_.has(e)))}t._fireEvent("removeKeys",{keys:p})}var f,m=function(n,r,i,l){var h=0,c=[],d=1===i&&!l;return r.keys.forEach(function(n){var i,u=l?null:r.data[h];if(o)if(d){var p=a.get(n);p&&(p.data.value=u,i=Promise.resolve({data:p.data,key:a.get(n).key}))}else{var _={value:u},f={value:n},m=s.getChildDataProvider(n);if(m&&!l)i=t.fetchAllData(m,e).then(function(e){return _.children=e.data,f.children=e.keys,{data:_,key:f}});else i=Promise.resolve({data:_,key:f});if(!l){var v=r.parentKeys?r.parentKeys[h]:null;a.set(f.value,{data:_,key:f,parentKey:v})}}else i=Promise.resolve({data:u,key:n}),a.set(n,{data:u,key:n});c.push(i),h+=1}),Promise.all(c).then(function(e){for(var t=0;t<e.length;t++){var r,s,h,c=o?e[t].key.value:e[t].key,p=a.get(c).parentKey;if(p){var _=a.get(p);_.data.children||d||(_.data.children=[],_.key.children=[]),r=_.data.children,s=_.key.children}else r=u.data,s=u.keys;if(l)h=n[t]-t,r.splice(h,i),s.splice(h,i);else{if(d)h=n[t];else h=0===n.length||null==n[t]?r.length:n[t];r.splice(h,i,e[t].data),s.splice(h,i,e[t].key)}}return u})},v=function(e){return s.fetchByKeys({keys:e}).then(function(t){var n=[];return t.results.size>0&&e.forEach(function(e){n.push(t.results.get(e).data)}),n})},y=Promise.resolve();h&&(f=h.indexes||n(u,h.keys,o),y=Array.isArray(h.data)?m(f,h,1):v(h.keys).then(function(e){var t=Object.create(h,{data:{value:e}});return m(f,t,1)})),y.then(function(){return c?(f=c.indexes||n(u,c.keys,o),m(f,c,1,!0)):Promise.resolve()}).then(function(){return d?(f=d.indexes||n(u,d.addBeforeKeys?d.addBeforeKeys:d.afterKeys,o),Array.isArray(d.data)?m(f,d,0):v(d.keys).then(function(e){var t=Object.create(d,{data:{value:e}});return m(f,t,0)})):Promise.resolve()}).then(function(){r(Promise.resolve(u))})}}},y.prototype._addDPEventListeners=function(e,t){if(!this._dataProviderEventListeners[t]){var n=this._getDataProviderEventHandler(t);e.addEventListener("mutate",n),e.addEventListener("refresh",n),this._dataProviderEventListeners[t]={dataProvider:e,listener:n}}},y.prototype.release=function(e){var t=function(e){var t=this._dataProviderEventListeners[e];if(t){var n=t.dataProvider,r=t.listener;n.removeEventListener("mutate",r),n.removeEventListener("refresh",r),this._dataProviderEventListeners[e]=null}}.bind(this);if(e)t(e),this.clear(e);else{for(var n=Object.keys(this._dataProviderEventListeners),r=0;r<n.length;r++)t(n[r]);this.clear()}},y.prototype.fetchChildrenData=function(e,t,n,r){var i=function(t,n,r){this._keyDataMap[e].get(t).data.children=n,this._keyDataMap[e].get(t).key.children=r}.bind(this),s=t.getChildDataProvider(n);if(s){var o=this._configMap[e].maxFetchDepth,a=this._keyDataMap[e].get(n).depth,l=this._getDPPostProcessor(t,e,r,o);return this._fetchCollection(s,l,e,n,a,o).then(function(e){return i(n,e.data,e.keys),e})}return Promise.resolve({data:[],keys:[]})},y.prototype.clear=function(e,t){e&&t?(this._keyDataMap[e]=this._keyDataMap[e]||new i,this._fireEvent("reset",{dataProperty:e})):e?this._fetchedData[e]=null:(this._fetchedData={},this._keyDataMap={})},y.prototype.isDataProvider=function(t){return e.DataProviderFeatureChecker.isDataProvider(t)},y.prototype.isTreeDataProvider=function(t){return e.DataProviderFeatureChecker.isTreeDataProvider(t)},y.prototype.addEventListener=function(e){this._eventListeners.push(e)},y.prototype._fireEvent=function(e,t){for(var n=0;n<this._eventListeners.length;n++)this._eventListeners[n]({type:e,detail:t})};const g=function(e,t,n){this._component=e,this._configMap=t,this._useObjectAssign=n,this._init()};e.Object.createSubclass(g,e.Object,"TemplateHandler"),g.prototype._init=function(){this._templateEnginePromise=null,this._templates=this.getTemplates(),this._templateResults={},this._templateNodeData={},this._componentResults={},this._eventListeners=[],this._queueNextEvent=!0,this._eventUpdates=[],this._templatePropertyMap={},this._propertyValidatorMap={}},g.prototype.getTemplateEngine=function(){return this._templateEnginePromise||(this._templateEnginePromise=new Promise(function(e){r.__getTemplateEngine().then(function(t){e(t)},function(e){throw new Error("Error loading template engine: "+e)})})),this._templateEnginePromise},g.prototype.getDataSet=function(e){var t=this.getTemplate(e);return t&&t.dataset},g.prototype.getTemplate=function(e){return this._templates[e]&&this._templates[e][0]},g.prototype.getDataSetBoolean=function(e,t){var n=this.getDataSet(e),r=p.AttributeUtils.attributeToPropertyName(t),i=n&&n[r];return null!=i&&p.AttributeUtils.coerceBooleanValue(this.getTemplate(e),t,i,"Boolean")},g.prototype.getTemplates=function(){return p.CustomElementUtils.getSlotMap(this._component.element[0])},g.prototype._getPropertyValidator=function(t,n){if(!t)return null;var r=this._propertyValidatorMap[n];if(r)return r;var i=e.CustomElementBridge.getMetadata(n),s=t.content?t.content.children[0]:t.childNodes[1],o={};return r=function(n,r){var a=n.join("."),l=o[a];if(!l){l=i;for(var h=0;h<n.length;h++)l=l.properties[n[h]];o[a]=l}try{_.checkEnumValues(s,a,r,l)}catch(e){throw new p.JetElementError(t,e.message)}null!=r&&e.BaseCustomElementBridge.checkType(s,a,r,l)},this._propertyValidatorMap[n]=r,r},g.prototype._processAliasedPropertyNames=function(e,t,n){var r=this._configMap[e].getAliasedPropertyNames;if(r)for(var i=r(t),s=Object.keys(i),o=0;o<s.length;o++){var a=s[o];n[i[a]]=n[a],n[a]=void 0}return n},g.prototype._getTemplateElementProperties=function(e){var t=this._templatePropertyMap[e];return t||(t=this._component.getElementPropertyNames(e),this._templatePropertyMap[e]=t),t},g.prototype.processNodeTemplate=function(t,n,r,s,o,a,l){var h=r.getAttribute("slot"),c=this._component.options.as,d=this._component.element[0],u=this._getTemplateElementProperties(s),p=this._getPropertyValidator(r,s),_=l?t:h,f=function(n){return function(r){var i=this._processAliasedPropertyNames(t,s,r),o=this._templateNodeData[_];e.CollectionUtils.copyInto(o.get(n).data,i),this._eventUpdates.push({key:a,data:i}),this._queueNextEvent&&(this._fireEvent("notReady"),this._component._GetThrottlePromise().then(function(){this._fireEvent("dataUpdated",{dataProperty:t,templateName:h,data:this._eventUpdates.slice(0)}),this._queueNextEvent=!0,this._eventUpdates=[]}.bind(this))),this._queueNextEvent=!1}.bind(this)}.bind(this),m=n.resolveProperties(d,r,s,u,o,c,p);m.subscribe(f(a));var v={data:this._processAliasedPropertyNames(t,s,m.peek()),node:m,context:o};return this._templateNodeData[_]||(this._templateNodeData[_]=new i),this._templateNodeData[_].set(a,v),v.data},g.prototype.processTemplates=function(e,t,n,r,i,s,o){if(s&&this._templateResults[e])return this._templateResults[e];var a,l,h=this._configMap[e],c=this;if(h){a=[],l=[];var u="string"==typeof h.templateName?function(){return h.templateName}:h.templateName,p="string"==typeof h.templateElementName?function(){return h.templateElementName}:h.templateElementName,_=h.resultPath,f=this._component.element[0],m=h.processChildrenData,v=h.processOptionData||function(e){return e},y=c._templateNodeData[e];if(u&&p&&_){var g,C=function(t,r,i,s,o){var a;try{s?a=c.processNodeTemplate(e,n,s,o,i,r,!0):(c._useObjectAssign?(a=Object.assign({},t),Object.defineProperties(a,{_noTemplate:{value:!0,enumerable:!1},_dvtNoClone:{value:!0,enumerable:!1}})):((a=Object.create(t))._noTemplate=!0,a._dvtNoClone=!0),y.set(r,{data:a,context:i})),a.id=r,a._itemData=t}catch(e){d.error(e)}return a},D=function(e,t,n){for(var i=e.data,s=e.keys,o=[],a=0;a<i.length;a++){var l=r?i[a].value:i[a],h=r?s[a].value:s[a],d={data:l,key:h,index:a,componentElement:f};r&&(d.parentData=t,d.parentKey=n);var v=u(i[a]),y=p(i[a]),g=c.getTemplate(v),P=C(l,h,d,g,y);if(r&&i[a].children){var b=t.slice(0);b.push(l);var E={data:i[a].children,keys:s[a].children},T=D(E,b,h);m?m(P,i[a],T):P[_]=T}o.push(P)}return o};a.push(_),i&&y.has(i)&&(g=y.get(i).context.parentData.concat(y.get(i).context.data));var P=D(t,g||[],i);l.push(v(P))}o&&(y.get(i).data[_]=l[0])}var b={paths:a,values:l};return s&&(this._templateResults[e]=b),b},g.prototype.release=function(e){var t;if(e){var n=this._configMap[e].derivedTemplates;t=n?[e].concat(n):[e]}else t=Object.keys(this._templateNodeData);for(var r=0;r<t.length;r++){var s=this._templateNodeData[t[r]];s&&(s.forEach(function(e){e.node&&e.node.dispose()}),this._templateNodeData[t[r]]=new i)}this.clear(e)},g.prototype.clear=function(e,t){if(e)for(var n,r=this._configMap[e].derivedTemplates,s=r?[e].concat(r):[e],o=0;o<s.length;o++)n=s[o],t?this._templateNodeData[n]=this._templateNodeData[n]||new i:(this._templateResults[n]=null,this._componentResults[n]=null);else this._templateResults={},this._componentResults={},this._templateNodeData={}},g.prototype.getComponentResults=function(e){return this._componentResults[e]},g.prototype.setComponentResults=function(e,t){this._componentResults[e]=t},g.prototype.addEventListener=function(e){this._eventListeners.push(e)},g.prototype._fireEvent=function(e,t){for(var n=0;n<this._eventListeners.length;n++)this._eventListeners[n]({type:e,detail:t})},e.__registerWidget("oj.dvtBaseComponent",a.oj.baseComponent,{options:{trackResize:"on"},_ComponentCreate:function(){this._super(),this._renderCount=0,this._numDeferredObjs=0,this._optionsCopy=null,this._dataValuePromise={},this._templateMap={},this._TemplateHandler=new g(this,this._GetSimpleDataProviderConfigs(),this._UseObjectAssignForShapedData()),this._DataProviderHandler=new y(this,this._GetSimpleDataProviderConfigs()),this._DataProviderHandler.addEventListener(this._GetDPEventHandler()),this._TemplateHandler.addEventListener(this._GetDPEventHandler());for(var n=this._GetComponentStyleClasses(),r=0;r<n.length;r++)this.element.addClass(n[r]);this._referenceDiv=a(document.createElement("div")),this._referenceDiv.css("visibility","hidden"),this.element.append(this._referenceDiv),t.Agent.setAgentInfo(e.AgentUtils.getAgentInfo());var h=this.element[0].parentElement;h&&h._dvtcontext?this._context=h._dvtcontext:this._context=new t.Context(this.element[0],null,this._referenceDiv[0]);var c=Object.keys(this._GetSimpleDataProviderConfigs()),d={oj:e,KeySetImpl:l,ojMap:i,LocaleData:s,dataProviderProps:c};if(this._context.setJetProperties(d),this._context.setReadingDirection(this._GetReadingDirection()),this._context.setTooltipAttachedCallback(o.subtreeAttached),this._context.setOverlayAttachedCallback(o.subtreeAttached),this._context.setFixContextCallback(this._FixRendererContext.bind(this)),this._context.setCustomElement(this._IsCustomElement()),a(document.body).hasClass("oj-hicontrast")&&t.Agent.setHighContrast(!0),this._component=this._CreateDvtComponent(this._context,this._HandleEvent,this),this._component.setContextMenu(!!this._GetContextMenu()),t.Agent.isEnvironmentTest()){var u=this.element[0].getAttribute("data-oj-dvt-test-id");u&&u.length>0&&this._component.setId(u)}this._context.getStage().addChild(this._component),this._LoadResources(),this.options._widgetConstructor=o.__GetWidgetConstructor(this.element)},_AfterCreate:function(){this._super(),"off"!==this.options.trackResize&&this._addResizeListener(),this._ProcessOptions(),this._Render()},_SetLocaleHelpers:function(e,n){if(!1!==t.requireJS){var r={createNumberConverter:function(t){return new e.IntlNumberConverter(t)},isoToDateConverter:function(e){if("string"==typeof e){var t=n.IntlConverterUtils.isoToDate(e),r=t.toJSON()?n.IntlConverterUtils.dateToLocalIso(t):e;return n.IntlConverterUtils.isoToLocalDate(r)}return e},dateToIsoWithTimeZoneConverter:function(e){if(e instanceof Date){var t=-1*e.getTimezoneOffset(),r=t>=0?"+":"-",i=Math.floor(Math.abs(t)/60),s=Math.abs(t)%60,o=r+(2!==i.toString().length?"0"+i:i)+":"+(2!==s.toString().length?s+"0":s);return n.IntlConverterUtils.dateToLocalIso(e)+o}return e}};this._context.setLocaleHelpers(r)}},refresh:function(){this._super(),this._styleProcessor=null,this._context.setReadingDirection(this._GetReadingDirection()),this._Render()},getNodeBySubId:function(e){var t=this._component&&this._component.getAutomation?this._component.getAutomation():null;if(t){var n=this._ConvertLocatorToSubId(e);return t.getDomElementForSubId(n)}return null},getSubIdByNode:function(e){var t=this._component&&this._component.getAutomation?this._component.getAutomation():null;if(t){var n=t.getSubIdForDomElement(e);return n?this._ConvertSubIdToLocator(n):null}return null},_ConvertLocatorToSubId:function(e){return null},_ConvertSubIdToLocator:function(e){return null},_ProcessStyles:function(e){this._styleProcessor=this._styleProcessor?this._styleProcessor:new v(this._component.getCtx()),this._styleProcessor.processStyles(this.element,e,this._GetComponentStyleClasses(),this._GetChildStyleClasses())},_GetComponentStyleClasses:function(){return["oj-dvtbase"]},_GetChildStyleClasses:function(){var e={"oj-dvt-no-data-message":{path:"_statusMessageStyle",property:"TEXT"}};return e},_GetEventTypes:function(){return[]},_VerifyConnectedForSetup:function(){return!0},_ReleaseResources:function(){this._super(),this._renderNeeded=!0,this._context.hideTooltips(),this._context.releaseTooltipResources(),this._removeResizeListener(),this._CleanAllTemplates(),this._MakeReady(),this._DataProviderHandler.release(),this._TemplateHandler.release(),this._dataValuePromise={}},_destroy:function(){var e=this.element[0].parentElement;e&&e._dvtcontext&&(e._dvtcontext=null),this._component.destroy&&this._component.destroy(),this._component=null,this.element.children().remove(),this.element.removeAttr("role").removeAttr("tabIndex").removeAttr("aria-activedescendant");for(var t=this._GetComponentStyleClasses(),n=0;n<t.length;n++)this.element.removeClass(t[n]);this._super(),this._context.destroy(),this._context=null},_setOptions:function(e,t){this._superApply(arguments),this._OptionChangeHandler(e);var n=this.options.trackResize;if("off"===n&&this._resizeListener?this._removeResizeListener():"off"===n||this._resizeListener||this._addResizeListener(),this._ProcessOptions(),!this._bUserDrivenChange){var r=!1,i=this._GetEventTypes(),s=["highlightedCategories","selection","dataCursorPosition","scrollPosition"];a.each(e,function(e){if(i.indexOf(e)<0&&s.indexOf(e)<0)return r=!0,!1}),r?this._Render():(void 0!==e.highlightedCategories&&this._component.highlight(e.highlightedCategories),void 0!==e.selection&&this._component.select(e.selection),void 0!==e.dataCursorPosition&&this._component.positionDataCursor&&this._component.positionDataCursor(e.dataCursorPosition),void 0!==e.scrollPosition&&this._component.scroll(e.scrollPosition))}},_CreateDvtComponent:function(e,t,n){return null},_HandleEvent:function(e){var t=e.type;"selection"===t?this._UserOptionChange("selection",e.selection):"categoryHide"===t||"categoryShow"===t?this._UserOptionChange("hiddenCategories",e.hiddenCategories):"categoryHighlight"===t?this._UserOptionChange("highlightedCategories",e.categories):"optionChange"===t?this._UserOptionChange(e.key,e.value,e.optionMetadata):"touchHoldRelease"===t&&this._GetContextMenu()?this._OpenContextMenu(a.Event(e.nativeEvent),"touch"):"dvtRender"===t?this._Render():"ready"===t&&0===this._numDeferredObjs&&this._MakeReady()},_addResizeListener:function(){this._resizeListener||(this._resizeListener=this._handleResize.bind(this),h.addResizeListener(this.element[0],this._resizeListener,250))},_removeResizeListener:function(){this._resizeListener&&(h.removeResizeListener(this.element[0],this._resizeListener),this._resizeListener=null)},_handleResize:function(e,t){var n=this.element.width(),r=this.element.height();(null==this._width||null==this._height||Math.abs(n-this._width)+Math.abs(r-this._height)>=5)&&this._Render(!0)},_LoadResources:function(){},_Render:function(e){this._context.hideTooltips(),this._NotReady(),!this._context.isReadyToRender()||this._renderNeeded&&e?(this._renderNeeded=!0,this._MakeReady()):(this._width=this._IsFlowingLayoutSupported()?null:this.element.width(),this._height=this._IsFlowingLayoutSupported()?null:this.element.height(),this._context.setDefaultFontFamily(this._referenceDiv.css("font-family")),this._context.setDefaultFontSize(this._referenceDiv.css("font-size")),this.options._width=this._width,this.options._height=this._height,this.options._locale=t.Agent.isEnvironmentTest()&&this.options._locale?this.options._locale:r.getLocale(),this._IsDraggable()&&this.element.attr("draggable",!0),v.populateOptions(this.options,this._GetChildStyleClasses()),e?0===this._numDeferredObjs&&(this._renderCount+=1,this._RenderComponent(this._optionsCopy,e)):(this._renderCount+=1,this._resolveDeferredDataItems()&&this._RenderComponent(this._optionsCopy)),this._renderNeeded=!1)},_IsDraggable:function(){return!!this.options.dnd},_NotifyShown:function(){this._super(),this._notifyShownAttached()},_NotifyAttached:function(){this._super(),this._notifyShownAttached()},_NotifyDetached:function(){this._super(),this._notifyHiddenDetached()},_NotifyHidden:function(){this._super(),this._notifyHiddenDetached()},_notifyShownAttached:function(){this._renderNeeded&&this._Render()},_notifyHiddenDetached:function(){this._context.hideTooltips(),this._MakeReady()},_UserOptionChange:function(e,t,n){this._bUserDrivenChange=!0,this.option(e,t,{_context:{writeback:!0,optionMetadata:n,internalSet:!0,skipEvent:"_"===e.charAt(0)}}),this._bUserDrivenChange=!1},_NotifyContextMenuGesture:function(e,t,n){if("touch"!==n)if("keyboard"===n){var r=this.element[0].getBoundingClientRect(),i=this._component.getKeyboardFocus()?this._component.getKeyboardFocus().getBoundingClientRect():null,s=i?"left+"+(i.left+.5*i.width-r.left)+" top+"+(i.top+.5*i.height-r.top):"center";this._OpenContextMenu(t,n,{position:{at:s}})}else this._super(e,t,n)},_GetDvtComponent:function(e){var t=o.__GetWidgetConstructor(e)("instance");return t?t._component:null},_GetStringFromIndexPath:function(e){for(var t="",n=0;n<e.length;n++)t+="["+e[n]+"]";return t},_GetIndexPath:function(e){for(var t=[],n=0;e.indexOf("[",n)>0;){var r=e.indexOf("[",n)+1,i=e.indexOf("]",n);t.push(Number(e.substring(r,i))),n=i+1}return t},_GetFirstIndex:function(e){return Number(this._GetFirstBracketedString(e))},_GetFirstBracketedString:function(e){var t=e.indexOf("[")+1,n=e.indexOf("]");return e.substring(t,n)},_GetComponentDeferredDataPaths:function(){return{}},_GetComponentNoClonePaths:function(){if(!this._noClonePaths){this._noClonePaths={};var e=this,t=this._GetComponentDeferredDataPaths().root;t&&t.forEach(function(t){e._noClonePaths[t]=!0})}return this._noClonePaths},_resolveDocumentFonts:function(){var e=document.fonts;if(e&&"loading"===e.status){this._numDeferredObjs+=1;var t=this._renderCount;e.ready.then(function(){this._renderDeferredData(t,null,[])}.bind(this))}},_resolveDeferredDataItems:function(){this._optionsCopy=t.JsonUtils.clone(this.options,null,this._GetComponentNoClonePaths()),this._ProcessStyles(this._optionsCopy),this._numDeferredObjs=0,this._FixCustomRenderers(this._optionsCopy),this._resolveDocumentFonts();for(var e=this,n=this._GetComponentDeferredDataPaths(),r=Object.keys(n),i=0;i<r.length;i++){var s=r[i];n[s].forEach(function(t){if("root"===s)e._resolveDeferredDataItem.bind(e)(e.options,e._optionsCopy,t);else{var n=e.options[s];if(n&&n instanceof Array)for(var r=0;r<n.length;r++)e._resolveDeferredDataItem.bind(e)(n[r],e._optionsCopy[s][r],t)}})}return 0===this._numDeferredObjs},_resolveDeferredDataItem:function(e,t,n){var r=new m(e,n),i=r.getValue(),s=this;if(i instanceof Function?i=Promise.resolve(i(this._GetDataContext(e))):this._IsCustomElement()&&Array.isArray(i)&&(i=Promise.resolve(i),r.setValue(i,!0)),i&&this._DataProviderHandler.isDataProvider(i)){var o=this._DataProviderHandler.isTreeDataProvider(i);i=s._dataValuePromise[n]||new Promise(function(e){var t=s._TemplateHandler.getTemplateEngine(),r=s._DataProviderHandler.fetchAllData(i,n,!0);Promise.all([t,r]).then(function(t){if(i===s._dataValuePromise[n]){var r=t[0],a=t[1],l=s._ProcessTemplates(n,a,r,o,null,!0);s._dataValuePromise[n]=null,e(l)}},function(){s._dataValuePromise[n]=null})}),s._dataValuePromise[n]=i}if(i instanceof Promise){var a=this._renderCount;i.then(function(e){var r=[n],i=[e];e.paths&&(r=e.paths,i=e.values),s._renderDeferredData(a,t,r,i)},function(){s._renderDeferredData(a,t,[n],[[]])}),this._numDeferredObjs+=1}},_renderDeferredData:function(e,t,n,r){if(this._context&&e===this._renderCount){this._numDeferredObjs-=1;for(var i=0;i<n.length;i++)new m(t,n[i]).setValue(r[i],!0);0===this._numDeferredObjs&&(this._RenderComponent(this._optionsCopy),this._optionsCopy=null)}},_ClearDataProviderState:function(e){this._DataProviderHandler.clear(e),this._TemplateHandler.release(e),this._dataValuePromise[e]=null},_OptionChangeHandler:function(e){for(var t=Object.keys(this._GetSimpleDataProviderConfigs()),n=0;n<t.length;n++){var r=t[n];Object.prototype.hasOwnProperty.call(e,r)&&this._ClearDataProviderState(r)}},getElementPropertyNames:function(t){var n=e.CustomElementBridge.getMetadata(t).properties,r=Object.keys(n).filter(function(e){return!n[e]._eventListener}),i=new Set;return r.forEach(function(e){i.add(e)}),i},_ProcessTemplates:function(e,t,n,r,i,s,o){return this._TemplateHandler.processTemplates(e,t,n,r,i,s,o)},_GetSimpleDataProviderConfigs:function(){return{}},_UseObjectAssignForShapedData:function(){return!1},_GetDPEventHandler:function(){return function(e){"notReady"===e.type?this._NotReady():"dataUpdated"===e.type?this._Render():"clearState"===e.type?this._ClearDataProviderState(e.detail.dataProperty):"reset"===e.type?this._TemplateHandler.clear(e.detail.dataProperty,!0):"removeKeys"===e.type&&this._RemoveKeys(e.detail.keys)}.bind(this)},_RemoveKeys:function(e){var t,n,r=this.options.selection,i=new l(e);if(r&&r.length>0){for(var s=(n=r.slice(0)).length-1;s>=0;s--)i.has(n[s])&&(t=!0,n.splice(s,1));t&&this._UserOptionChange("selection",n)}},_getFetchDataHandler:function(e){var t=this._GetSimpleDataProviderConfigs()[e].resultPath;return function(n,r,i,s){var o=this._DataProviderHandler.fetchChildrenData(e,n,s,r),a=this._TemplateHandler.getTemplateEngine();return Promise.all([o,a]).then(function(n){var r=this._ProcessTemplates(e,{data:n[0].data,keys:n[0].keys},n[1],!0,s,!1,!0).values[0];return i&&(i[t]=r),r}.bind(this))}.bind(this)},_RenderComponent:function(e,t){if(this._context.isReadyToRender()){this._CleanAllTemplates(t);var n=this._IsFlowingLayoutSupported()&&this._resizeListener;n&&this._removeResizeListener(),this._component.render(t?null:e,this._width,this._height),n&&this._addResizeListener(),this.element.attr("role")?this.element[0].hasAttribute("tabindex")||this.element.attr("tabindex",0):this.element.attr("tabindex",null)}else this._renderNeeded=!0,this._MakeReady()},_GetDataContext:function(e){return{}},_IsFlowingLayoutSupported:function(){return!1},whenReady:function(){if(this._ready)return Promise.resolve(!0);if(!this._promise){var e=this;this._promise=new Promise(function(t){e._promiseResolve=t})}return this._promise},_NotReady:function(){if(this._ready=!1,0===this._numDeferredObjs&&!this._readyResolveFunc){var e=n.getContext(this.element[0]).getBusyContext(),t={description:"The component identified by '"+this.element.attr("id")+"' is being loaded."};this._readyResolveFunc=e.addBusyState(t)}},_MakeReady:function(){this._promiseResolve&&(this._promiseResolve(!0),this._promiseResolve=null),this._ready=!0,this._promise=null,this._readyResolveFunc&&(this._readyResolveFunc(),this._readyResolveFunc=null)},_ProcessOptions:function(){t.Agent.isEnvironmentTest()&&(this.options=Object.assign(this.options,this.element[0].__dvtToolkit));var e=this.options.tooltip;e&&e._renderer&&(this.options.tooltip={renderer:this._GetTemplateRenderer(e._renderer,"tooltip")})},_WrapCustomElementRenderer:function(e){var t=this;return e?function(n){n._dvtcontext=t._context;var r=e(n);if(n._templateName&&n._templateCleanup&&t._AddTemplate(n),r&&!0!==r.preventDefault&&r.insert){var i=r.insert;return i.classList&&i.classList.contains("oj-dvtbase")?t._GetDvtComponent(i):i}return null}:null},_FixCustomRenderers:function(e){if(this._IsCustomElement())for(var t=this._GetComponentRendererOptions(),n=0;n<t.length;n++){var r=t[n].path,i=t[n].slot,s=this._TemplateHandler.getTemplates();if(i&&s[i]&&s[i][0])this._ProcessInlineTemplateRenderer(e,r,s[i][0],i);else{var o=new m(e,r),a=o.getValue();a&&o.setValue(this._WrapCustomElementRenderer(a),!0)}}},_GetComponentRendererOptions:function(){return[{path:"tooltip/renderer",slot:"tooltipTemplate"}]},_GetTemplateRenderer:function(e,t){var n=this;return function(r){var i=document.createElement("div");i.style.display="none",e({parentElement:i,context:r});var s=i.children[0];return s?(n._AddTemplate({_templateName:t,_templateCleanup:function(){a(i).remove()}}),i.removeChild(s),a(i).remove(),s):null}},_GetTemplateDataRenderer:function(e,t){var n=this;return function(r){var i=document.createElement("div");i.style.display="none",i._dvtcontext=n._context,n.element.append(i),e({parentElement:i,data:r.data});var s=i.children[0];return s?(n._AddTemplate({_templateName:t,_templateCleanup:function(){a(i).remove()}}),"http://www.w3.org/2000/svg"===s.namespaceURI?(i.removeChild(s),a(i).remove(),s):n._GetDvtComponent(s)):null}},_WrapInlineTemplateRenderer:function(e,t,n){return e},_ProcessInlineTemplateRenderer:function(e,t,n,r){var i=this._renderCount;this._numDeferredObjs+=1,this._TemplateHandler.getTemplateEngine().then(function(s){var o=function(e){return this._TemplateRenderer(e,s,n,r)}.bind(this);o=this._WrapInlineTemplateRenderer(o,r,t),this._renderDeferredData(i,e,[t],[this._WrapCustomElementRenderer(o)])}.bind(this))},_TemplateRenderer:function(e,t,n,r){var i=t.execute(this.element[0],n,e);return i&&i.length>0?(Object.defineProperty(e,"_templateCleanup",{value:function(){i.forEach(function(e){t.clean(e)})},enumerable:!1}),Object.defineProperty(e,"_templateName",{value:r,enumerable:!1}),{insert:i}):{preventDefault:!0}},_CleanAllTemplates:function(e){for(var t=Object.keys(this._templateMap),n=0;n<t.length;n++){var r=t[n];this._CleanTemplate(r)}},_CleanTemplate:function(e){if(this._templateMap[e]){for(var t=this._templateMap[e].length,n=0;n<t;n++)this._templateMap[e][n]();this._templateMap[e]=[]}},_AddTemplate:function(e){var t=e._templateName;this._templateMap[t]||(this._templateMap[t]=[]),this._templateMap[t].push(e._templateCleanup)},_CompareOptionValues:function(t,n,r){switch(t){case"hiddenCategories":case"highlightedCategories":case"selection":return e.Object.compareValues(n,r);default:return this._super(t,n,r)}}},!0),e._registerLegacyNamespaceProp("AttributeGroupHandler",c.AttributeGroupHandler),e._registerLegacyNamespaceProp("ColorAttributeGroupHandler",c.ColorAttributeGroupHandler),e._registerLegacyNamespaceProp("ShapeAttributeGroupHandler",c.ShapeAttributeGroupHandler);const C={_SHAPE_REGEXP:/\d/,_SHAPE_ENUMS:{circle:!0,ellipse:!0,square:!0,rectangle:!0,diamond:!0,triangleUp:!0,triangleDown:!0,plus:!0,human:!0,star:!0},shapeParseFunction:function(e,t){var n=t||C._SHAPE_ENUMS;return function(t,r,i,s){if(e[r]){if(C._SHAPE_REGEXP.test(t))return t;if(n[t])return t;throw new Error("Found: '"+t+"'. Expected one of the following: "+Object.keys(n).toString())}return s(t)}}};return C});
//# sourceMappingURL=ojdvt-base.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojconverter-number',["exports","ojs/ojlogger","ojs/ojconverterutils-i18n","ojs/ojlocaledata","ojs/ojconverter","ojs/ojtranslation","ojs/ojconfig","ojs/ojcore-base","ojs/ojvalidation-error"],function(e,r,t,n,i,a,o,s,u){"use strict";i=i&&Object.prototype.hasOwnProperty.call(i,"default")?i.default:i,s=s&&Object.prototype.hasOwnProperty.call(s,"default")?s.default:s;const l=function(){var e,n=/^[+-]?infinity$/i,i=/^[+-]?\d*\.?\d*(e[+-]?\d+)?$/,a=/([^+-.0-9]*)([+-]?\d*\.?\d*(E[+-]?\d+)?).*$/,o=/([\^$.*+?|\[\](){}])/g,s=/(^0\.0*)([^0].*$)/,u=/^0+$/,l={trillion:[1e14,1e13,1e12],billion:[1e11,1e10,1e9],million:[1e8,1e7,1e6],thousand:[1e5,1e4,1e3]},c={trillion:1e12,billion:1e9,million:1e6,thousand:1e3},m={HALF_UP:"ceil",CEILING:"ceil",UP:"ceil",HALF_DOWN:"floor",FLOOR:"floor",DOWN:"floor",DEFAULT:"round"};function p(e,r,t){var n;for(n=e.length;n<r;n+=1)e=t?"0"+e:e+"0";return e}function g(e,r,t,n,i){var a=e[r];return void 0!==a?(a=Number(a),(isNaN(a)||a<t||a>n)&&function(e,r,t,n){var i=new RangeError(e+" is out of range.  Enter a value between "+r+" and "+t+" for "+n),a={errorCode:"numberOptionOutOfRange",parameterMap:{value:e,minValue:r,maxValue:t,propertyName:n}};throw i.errorInfo=a,i}(a,t,n,r),Math.floor(a)):i}function v(e){var r=e||"en-US",t=r.indexOf("-u-nu-"),n="latn";return-1!==t&&(n=r.substr(t+6,4)),n}function d(e,n,i,a){var o,s=n,u=t.OraI18nUtils.getLocaleElementsMainNode(e),l=function(e,r){if(void 0===r)return"latn";var t=v(r),n="symbols-numberSystem-"+t;return void 0===e.numbers[n]&&(t="latn"),t}(u,a);s.numberingSystemKey=l,s.numberingSystem="symbols-numberSystem-"+l;var c=i.lenientParse;if(s.lenientParse=c||"full",s.style=i.style,void 0!==i.pattern&&i.pattern.length>0)o=i.pattern;else{var m;switch(s.style){case"decimal":m="decimalFormats-numberSystem-";break;case"currency":m="currencyFormats-numberSystem-";break;case"percent":m="percentFormats-numberSystem-";break;default:m="decimalFormats-numberSystem-"}m+=s.numberingSystemKey,o=u.numbers[m].standard}var p=i.decimalFormat;void 0===p&&(p=i.currencyFormat),void 0===p||"decimal"!==s.style&&"currency"!==s.style||(s.shortDecimalFormat=u.numbers["decimalFormats-numberSystem-latn"][p].decimalFormat);var d=u.numbers[s.numberingSystem].decimal,y=u.numbers[s.numberingSystem].group,h=i.separators;if(void 0!==h){s.separators=h;var b=h.decimal,F=h.group;void 0!==b&&""!==b&&(d=h.decimal),void 0!==F&&(y=h.group)}var S=t.OraI18nUtils.getLocaleElementsMainNodeKey(e),x=S.split("-")[0];if(s.lang=x,s.pat=o,s.minusSign=u.numbers[s.numberingSystem].minusSign,s.decimalSeparator=d,s.exponential=u.numbers[s.numberingSystem].exponential,s.groupingSeparator=y,s.currencyDisplay=i.currencyDisplay,void 0!==i.currency&&(s.currencyCode=i.currency.toUpperCase()),void 0!==i.unit&&(s.unit=i.unit.toLowerCase()),function(e,r,t,n){for(var i,a=n,o=!1,s=!1,u=0,l=0,c=!0,m=1;m>=0&&l<r.length;--m){var p=!1,g="",v="",d=-1,y=1,h=0,b=0,F=0,S=-1,x=-1,D=0;c=!0;for(var O=l;O<r.length;++O){var P=r.charAt(O);switch(D){case 0:case 2:if(p){if("'"===P){O+1<r.length&&"'"===r.charAt(O+1)?(O+=1,c?g=g.concat("''"):v=v.concat("''")):p=!1;continue}}else{if("#"===P||"0"===P||","===P||"."===P){D=1,O-=1;continue}if("¤"===P){void 0===e.currency&&f("style"),a.style="currency";var j=O+1<r.length&&"¤"===r.charAt(O+1);j&&(O+=1),c?g=g.concat(j?"'¤¤":"'¤"):v=v.concat(j?"'¤¤":"'¤");continue}if("'"===P){if("'"===P){O+1<r.length&&"'"===r.charAt(O+1)?(O+=1,c?g=g.concat("''"):v=v.concat("''")):p=!0;continue}}else{if(";"===P){0!==D&&0!==m||M(r),l=O+1,O=r.length;continue}if("%"===P){a.style="percent",1!==y&&M(r),a.isPercent=!0,y=100,c?g=g.concat("'%"):v=v.concat("'%");continue}if("‰"===P){1!==y&&M(r),a.style="perMill",a.isPerMill=!0,y=1e3,c?g=g.concat("'‰"):v=v.concat("'‰");continue}if("-"===P){c?g=g.concat("'-"):v=v.concat("'-");continue}}}c?g=g.concat(P):v=v.concat(P);break;case 1:if(1!==m){0===(u-=1)&&(D=2,c=!1);continue}if(u+=1,"#"===P)b>0?F+=1:h+=1,S>=0&&d<0&&(S+=1);else if("0"===P)F>0&&M(r),b+=1,S>=0&&d<0&&(S+=1);else if(","===P)x=S,S=0;else{if("."!==P){if(A=O,T="E",$=void 0,void 0,$=r.substr(A,T.length),null!==new RegExp(T,"i").exec($)){for(s&&M(r),s=!0,i=0,O+="E".length;O<r.length&&"0"===r.charAt(O);)i+=1,u+=1,O+=1;(h+b<1||i<1)&&M(r),D=2,c=!1,O-=1;continue}D=2,c=!1,O-=1,u-=1;continue}d>=0&&M(r),d=h+b+F}}}if(0===b&&h>0&&d>=0){var _=d;0===_&&(_+=1),F=h-_,h=_-1,b=1}if((d<0&&F>0||d>=0&&(d<h||d>h+b)||0===S||p)&&M(r),1===m){U=I=g,E=N=v;var C=h+b+F,L=d>=0?d:C;a.minimumIntegerDigits=L-h,a.maximumIntegerDigits=s?h+a.minimumIntegerDigits:2147483647,a.maximumFractionDigits=d>=0?C-d:0,a.minimumFractionDigits=d>=0?h+b-d:0,a.groupingSize=S>0?S:0,a.groupingSize0=x}else U=g,E=v,o=!0}var A,T,$;0===r.length&&(I="",N="",a.minimumIntegerDigits=0,a.maximumIntegerDigits=2147483647,a.minimumFractionDigits=0,a.maximumFractionDigits=2147483647);a.useExponentialNotation=s,a.minExponentDigits=i,(!o||0===U.localeCompare(I)&&0===E.localeCompare(N))&&("currency"===a.style&&"ar"===a.lang?(E=N+"'‏-",U=I):(E=N,U="'-"+I));!function(e,r){var t=r,n={};null!==I&&(t.positivePrefix=w(I,e,t,n));null!==N&&(t.positiveSuffix=w(N,e,t,n));null!==U&&(t.negativePrefix=w(U,e,t,n));null!==E&&(t.negativeSuffix=w(E,e,t,n));void 0!==n.name&&(t.positiveSuffix=" "+n.name,t.positivePrefix="","ar"===t.lang?(t.negativeSuffix=e.numbers[t.numberingSystem].minusSign+" "+n.name,t.negativePrefix=""):(t.negativeSuffix=" "+n.name,t.negativePrefix=e.numbers[t.numberingSystem].minusSign))}(t,a)}(i,o,u,s),void 0===i.pattern&&(s.minimumIntegerDigits=g(i,"minimumIntegerDigits",1,21,s.minimumIntegerDigits),void 0!==i.maximumFractionDigits&&(s.maximumFractionDigits=g(i,"maximumFractionDigits",0,20,s.maximumFractionDigits),s.maximumFractionDigits<s.minimumFractionDigits&&(s.minimumFractionDigits=s.maximumFractionDigits)),void 0!==i.minimumFractionDigits&&(s.minimumFractionDigits=g(i,"minimumFractionDigits",0,20,s.minimumFractionDigits)),s.maximumFractionDigits<s.minimumFractionDigits&&(s.maximumFractionDigits=s.minimumFractionDigits,r.info("maximumFractionDigits is less than minimumFractionDigits, so maximumFractionDigits will be set to minimumFractionDigits")),"currency"===s.style&&void 0===i.minimumFractionDigits&&(void 0===p||"standard"===p))){var D=e.supplemental.currencyData.fractions[i.currency];if(void 0!==D){var O=parseInt(D._digits,10);s.minimumFractionDigits=O,s.maximumFractionDigits=O}}}function f(e){var r=new TypeError('The property "currency" is required when the property "'+e+'" is "currency". An accepted value is a three-letter ISO 4217 currency code.'),t={errorCode:"optionTypesMismatch",parameterMap:{propertyName:e,propertyValue:"currency",requiredPropertyName:"currency",requiredPropertyValueValid:"a three-letter ISO 4217 currency code"}};throw r.errorInfo=t,r}function y(e,r){var n=t.OraI18nUtils.getGetOption(e,r),i=n("style","string",["currency","decimal","percent","unit","perMill"],"decimal");if("decimal"===i||"currency"===i){var a="decimal"===i?"decimalFormat":"currencyFormat";i=n(a,"string",["standard","short","long"]),"OraNumberConverter.parse"===r&&void 0!==i&&"standard"!==i&&function(e){var r=new Error("long and short "+e+" are not supported for parsing"),t={errorCode:"unsupportedParseFormat",parameterMap:{shortFormats:e}};throw r.errorInfo=t,r}(a)}var o=n("currency","string");"currency"===i&&void 0===o&&f("style"),o=n("unit","string"),"unit"===i&&void 0===o&&function(e){var r=new TypeError('The property "unit" is required when the property "'+e+'" is "unit". An accepted value is "byte" or "bit".'),t={errorCode:"optionTypesMismatch",parameterMap:{propertyName:e,propertyValue:"unit",requiredPropertyName:"unit",requiredPropertyValueValid:"byte or bit"}};throw r.errorInfo=t,r}("style"),i=n("roundingMode","string",["UP","DOWN","FLOOR","CEILING","HALF_UP","HALF_DOWN","HALF_EVEN"])}function h(e,r,n){var i=n.groupingSize,a=n.groupingSize0,o=n.decimalSeparator,s=e+"",l=s.split(/e/i),c=l.length>1?parseInt(l[1],10):0,m=(l=(s=l[0]).split(".")).length>1?l[1]:"",g=Math.min(n.maximumFractionDigits,m.length-c);l.length>1&&m.length>c&&(e=b(e,g,r.roundingMode||"DEFAULT"));c=(l=(s=Math.abs(e)+"").split(/e/i)).length>1?parseInt(l[1],10):0,l=(s=l[0]).split("."),s=l[0],m=l.length>1?l[1]:"",c>0?(s+=(m=p(m,c,!1)).slice(0,c),m=m.substr(c)):c<0&&(m=(s=p(s,(c=-c)+1,!0)).slice(-c,s.length)+m,s=s.slice(0,-c)),g>0&&m.length>0?(m=m.length>g?m.slice(0,g):p(m,g,!1),!0===u.test(m)&&(m=m.slice(0,n.minimumFractionDigits)),m=o+m):m=n.minimumFractionDigits>0?o:"",m=p(m=t.OraI18nUtils.trimRightZeros(m),o.length+n.minimumFractionDigits,!1);var v=n.groupingSeparator,d="";!1===r.useGrouping&&void 0===r.pattern&&(v="");var f=(s=p(s,n.minimumIntegerDigits,!0)).length-1;for(m=m.length>1?m:"";f>=0;){if(0===i||i>f)return s.slice(0,f+1)+(d.length?v+d+m:m);d=s.slice(f-i+1,f+1)+(d.length?v+d:""),f-=i,a>0&&(i=a)}return s.slice(0,f+1)+v+d+m}function b(e,r,t){var n,i=t,a=function(e){var r=e.toString(),t=!1;"-"===(r=r.replace("E","e")).charAt(0)&&(t=!0,r=r.substring(1));var n=r.split("e"),i=n[0],a=Number(n[1]);if(a>0)if((r=i.substr(0,1)+i.substr(2)).length-1<a)for(var o=a+1-r.length;o>0;)r+="0",o-=1;else r.length-1>a&&(r=r.substr(0,a+1)+"."+r.substr(a+1));else if(a<0){var s=i.substr(0,1)+i.substr(2);r="0.";for(var u=a;u<-1;u++)r+="0";r+=s}return t&&(r="-"+r),r}(e);if(void 0===(a=a.split("."))[1])return Math.abs(e);if("DEFAULT"!==t){if("HALF_UP"===t||"HALF_EVEN"===t||"HALF_DOWN"===t){if("5"===a[1][r]){var o=a[1].substr(r);(o=parseInt(o,10))>5&&(i="HALF_UP")}else i="DEFAULT";e=Math.abs(e)}n=function(e,r,t){if(0===r)return Math[t](e);var n=e.toString().split("e"),i=n[0],a=n[1],o=i+"e"+(a?parseInt(a,10)-r:-r),s=parseFloat(o),u=Math[t](s);return n=u.toString().split("e"),i=n[0],a=n[1],o=i+"e"+(a?parseInt(a,10)+r:r),s=parseFloat(o)}(e,-r,i=function(e,r,t,n){var i=m[r];if("HALF_EVEN"===r){var a;if(0===t){var o=e[0].length;a=parseInt(e[0][o-1],10)}else a=parseInt(e[1][t-1],10);i=a%2==0?m.HALF_DOWN:m.HALF_UP}else"UP"===r&&n<0?i=m.DOWN:"DOWN"===r&&n<0&&(i=m.UP);return i}(a,i,r,e))}else{var s=Math.pow(10,r);if(n=Math.round(e*s)/s,!isFinite(n))return e}return Math.abs(n)}function F(e,r,n,i,a){var o=t.OraI18nUtils.getLocaleElementsMainNode(n);if(!isFinite(e))return e===1/0||e===-1/0?o.numbers[i.numberingSystem].infinity:"NaN";var u=e;!0===i.isPercent||"percent"===i.style?u*=100:!0===i.isPerMill&&(u*=1e3);var m=r.decimalFormat;void 0===m&&(m=r.currencyFormat);var g=i.style;u="decimal"!==g&&"currency"!==g||void 0===m||"standard"===m?!0===i.useExponentialNotation?function(e,r){var t=e+"",n=0,i=t.split(/e/i),a=i[0];s.lastIndex=0;var o=s.exec(a);null!==o?(n=o[1].length-1,a=o[2]):a=a.replace(".","");var u=i.length>1?parseInt(i[1],10):0,l=parseInt(a,10),c=r.minimumIntegerDigits+r.maximumFractionDigits;if(a.length>c){c-=a.length;var m=Math.pow(10,c);l=Math.round(l*m)}var g=r.minimumIntegerDigits+r.minimumFractionDigits;l=p(l+="",g,!1),-1!==t.indexOf(".")?u-=r.minimumIntegerDigits-t.indexOf(".")+n:u-=g-a.length-r.minimumFractionDigits;var v=Math.abs(u);v=p(v+"",r.minExponentDigits,!0),u<0&&(v=r.minusSign+v);var d=l.slice(0,r.minimumIntegerDigits);return l.slice(r.minimumIntegerDigits).length>0?d+=r.decimalSeparator+l.slice(r.minimumIntegerDigits)+r.exponential+v:d+=r.exponential+v,d}(u,i):"unit"===g?function(e,r,n,i){var a,o,s=Math.abs(e);s>=1099511627776?(a="digital-tera",o=s/1099511627776):s>=1073741824?(a="digital-giga",o=s/1073741824):s>=1048576?(a="digital-mega",o=s/1048576):s>=1024?(a="digital-kilo",o=s/1024):(a="digital-",o=s),a+=n.unit;var u=n.lang,l=new Intl.PluralRules(u).select(o);l="unitPattern-count-"+l,e<0&&(o=-o);var c=h(o,r,n),m=i.units.narrow[a][l];return c=t.OraI18nUtils.formatString(m,[c])}(u,r,i,o):h(u,r,i):function(e,r,t){var n,i,a,o=Math.abs(e),s=function(e){for(var r=Object.keys(l),t=0;t<r.length;t++)for(var n=r[t],i=l[n].length,a=0;a<i;a++)if(l[n][a]<=e)return[n,l[n][a]];return[e,null]}(o),u="";if(null!==s[1]){var m=t.lang,p=new Intl.PluralRules(m).select(Math.floor(o/c[s[0]]));if(n=s[1]+"-count-"+p,void 0===(n=t.shortDecimalFormat[n])&&(p="other",n=s[1]+"-count-"+p,n=t.shortDecimalFormat[n]),a=(i=function(e){var r=0,t=0,n=0,i="";if("0"!==e[0]){for(;"0"!==e[r]&&r<e.length;)r+=1;i=e.substr(0,r),n=r}for(r=n;r<e.length&&"0"===e[r];r++)t+=1;return[i,t]}(n))[1],u=i[0],a<n.length){var g=1*Math.pow(10,a);o/=g=s[1]/g*10}}var v="";return void 0!==n&&(v=n.substr(a+i[0].length)),e<0&&(o=-o),v=u+h(o,r,t)+(v=v.replace(/'\.'/g,"."))}(u,r,i);var d="";d+=e<0&&u-0!=0?i.negativePrefix+u+i.negativeSuffix:i.positivePrefix+u+i.positiveSuffix;var f=v(a);if(void 0===t.OraI18nUtils.numeringSystems[f]&&(f="latn"),"latn"!==f){var y,b=[];for(y=0;y<d.length;y++)d[y]>="0"&&d[y]<="9"?b.push(t.OraI18nUtils.numeringSystems[f][d[y]]):b.push(d[y]);return b.join("")}return d}function S(e,r){var n=r.groupingSeparator,i=r.decimalSeparator,o=r.minusSign,s="",u="",l=t.OraI18nUtils.toUpper(r.exponential),c=t.OraI18nUtils.toUpper(e),m=n;c=(c=c.split(l).join("E")).split(m).join("");var p=m.replace(/\u00A0/g," ");m!==p&&(c=c.split(p).join("")),"."===(c=c.split(i).join(".")).charAt(0)&&(c=c.substr(1),u="."),c=c.replace(o,"-");var g=u+a.exec(c)[2];return t.OraI18nUtils.startsWith(g,"-")?(g=g.substr("-".length),s="-"):t.OraI18nUtils.startsWith(c,"+")&&(g=g.substr("+".length),s="+"),[s,g]}function x(e,r,n,i){return isNaN(e)&&D(n.style,n,i),!0===n.isPercent||"percent"===n.style?e/=100:!0===n.isPerMill&&(e/=1e3),t.OraI18nUtils.getGetOption(r,"OraNumberConverter.parse")("roundDuringParse","boolean",[!0,!1],!1)&&(e=function(e,r,t){var n=r.maximumFractionDigits,i=e<0,a=t.roundingMode||"DEFAULT",o=b(e,n,a);return i?-o:o}(e,n,r)),e}function D(e,r,t){var n,i="Enter a number in this format:"+r.pat;switch(e){case"decimal":n="decimalFormatMismatch";break;case"currency":n="currencyFormatMismatch";break;case"percent":n="percentFormatMismatch"}var a=new Error(i),o={errorCode:n,parameterMap:{value:t,format:r.pat}};throw a.errorInfo=o,a}function O(e,r,a,s){var u=t.OraI18nUtils.getLocaleElementsMainNode(r),l={},c=function(e,r){var n,i=v(r);if(void 0===t.OraI18nUtils.numeringSystems[i])return e;var a=[];for(n=0;n<e.length;n++){var o=t.OraI18nUtils.numeringSystems[i].indexOf(e[n]);-1!==o?a.push(o):a.push(e[n])}return a.join("")}(e,s);d(r,l,a,s);var m=NaN,p=c.replace(/ /g,"");if(n.test(p))return m=parseFloat(c);var g=function(e,r,n,i){var a,s=t.OraI18nUtils.trimNumber(e),u="",l=!1,c=i.numbers[n.numberingSystem].plusSign,m=new RegExp("^"+c.replace(o,"\\$1"));s=s.replace(m,"");var p=t.OraI18nUtils.trimNumber(n.positivePrefix),g=t.OraI18nUtils.trimNumber(n.positiveSuffix),v=t.OraI18nUtils.trimNumber(n.negativePrefix),d=t.OraI18nUtils.trimNumber(n.negativeSuffix),f=new RegExp("^"+(p||"").replace(o,"\\$1")),y=new RegExp((g||"").replace(o,"\\$1")+"$"),h=new RegExp("^"+(v||"").replace(o,"\\$1")),b=new RegExp((d||"").replace(o,"\\$1")+"$");if(!0===h.test(s)&&!0===b.test(s))s=(s=s.replace(h,"")).replace(b,""),u="-",l=!0;else if(!0===f.test(s)&&!0===y.test(s))s=(s=s.replace(f,"")).replace(y,""),u="+",l=!0;else if("currency"===n.style){var F,x=n.currencyCode,O=x;if(void 0!==i.numbers.currencies[x]&&(O=i.numbers.currencies[x].symbol),void 0===n.currencyDisplay||"symbol"===n.currencyDisplay?F=O:"code"===n.currencyDisplay&&(F=x),void 0!==F){var I=(p||"").replace(F,""),N=(g||"").replace(F,""),U=(v||"").replace(F,""),E=(d||"").replace(F,"");f=new RegExp(("^"+I).replace(o,"\\$1")),y=new RegExp(N.replace(o,"\\$1")+"$"),h=new RegExp(("^"+U).replace(o,"\\$1")),b=new RegExp(E.replace(o,"\\$1")+"$"),!0===h.test(s)&&!0===b.test(s)?(s=(s=s.replace(h,"")).replace(b,""),u="-",l=!0):!0===f.test(s)&&!0===y.test(s)&&(s=(s=s.replace(f,"")).replace(y,""),u="+",l=!0)}}return l?a=[u,s]:"full"===n.lenientParse?(a=S(s,n))[2]=!0:D(n.style,n,e),a}(c,0,l,u),f=g[0],y=g[1];if(f=f||"+",g[2])return x(m=parseFloat(f+y),a,l,e);var h=function(e,r){var n,i,a={},o=r.decimalSeparator,s=r.groupingSeparator,u=e.replace(/ /g,""),l=r.exponential,c=u.indexOf(l.toLowerCase());c<0&&(c=u.indexOf(t.OraI18nUtils.toUpper(l))),c<0?(i=u,a.exponent=null):(i=u.substr(0,c),a.exponent=u.substr(c+l.length));var m=o,p=i.indexOf(m);p<0?(n=i,a.fraction=null):(n=i.substr(0,p),a.fraction=i.substr(p+m.length)),n=n.split(s).join("");var g=s.replace(/\u00A0/g," ");return s!==g&&(n=n.split(g).join("")),a.integer=n,a}(y,l),b=h.integer,F=h.fraction,O=h.exponent,I=f+b;if(null!==F&&(I+="."+F),null!==O){var N=function(e,r){var n,i=r.minusSign,a=r.plusSign,o=t.OraI18nUtils.trimNumber(e);return i=t.OraI18nUtils.trimNumber(i),a=t.OraI18nUtils.trimNumber(a),t.OraI18nUtils.startsWith(o,i)?n=["-",o.substr(i.length)]:t.OraI18nUtils.startsWith(o,t.OraI18nUtils.trimNumber(a))&&(n=["+",o.substr(a.length)]),n||["",o]}(O,l);I+="e"+(N[0]||"+")+N[1]}return i.test(I)?m=parseFloat(I):"full"===l.lenientParse?(I=S(c,l),m=parseFloat(I[0]+I[1])):D(l.style,l,e),x(m,a,l,e)}var I,N,U,E;function M(e){var r=new SyntaxError('Unexpected character(s) encountered in the pattern "'+e+' An example of a valid pattern is "#,##0.###".'),t={errorCode:"optionValueInvalid",parameterMap:{propertyName:"pattern",propertyValue:e,propertyValueHint:"#,##0.###"}};throw r.errorInfo=t,r}function w(e,r,t,n){for(var i="",a=0;a<e.length;){var o=e.charAt(a);if(a+=1,"'"!==o){switch(o){case"¤":var s=t.currencyCode,u=s,l=s;void 0!==r.numbers.currencies[s]&&(u=r.numbers.currencies[s].displayName,l=r.numbers.currencies[s].symbol),void 0===t.currencyDisplay||"symbol"===t.currencyDisplay?o=l:"code"===t.currencyDisplay?o=s+" ":(o=u,n.name=o);break;case"%":o=r.numbers[t.numberingSystem].percentSign;break;case"‰":o=r.numbers[t.numberingSystem].perMille;break;case"-":o=r.numbers[t.numberingSystem].minusSign}i=i.concat(o)}}return i}function P(e,r,n){var i={};return y(r,"OraNumberConverter.resolvedOptions"),d(e,i,r,n),i.numberingSystemKey=v(n),void 0===t.OraI18nUtils.numeringSystems[i.numberingSystemKey]&&(i.numberingSystemKey="latn"),i}function j(e,r,t){var n={locale:t,style:void 0===e.style?"decimal":e.style,useGrouping:void 0===r.useGrouping||r.useGrouping,numberingSystem:e.numberingSystemKey};n.minimumIntegerDigits=e.minimumIntegerDigits,n.minimumFractionDigits=e.minimumFractionDigits,n.maximumFractionDigits=e.maximumFractionDigits,"decimal"===e.style&&void 0!==r.decimalFormat&&(n.decimalFormat=r.decimalFormat),"currency"===e.style&&void 0!==r.currencyFormat&&(n.currencyFormat=r.currencyFormat),"currency"===e.style&&(n.currency=r.currency,n.currencyDisplay=void 0===r.currencyDisplay?"symbol":r.currencyDisplay),void 0!==r.unit&&(n.unit=r.unit),void 0!==r.pattern&&(n.pattern=r.pattern);var i=r.roundingMode,a=r.roundDuringParse;void 0!==i&&(n.roundingMode=i),void 0!==a&&(n.roundDuringParse=a);var o=e.lenientParse;void 0!==o&&(n.lenientParse=o);var s=e.separators;return void 0!==s&&(n.separators=s),n.virtualKeyboardHint=function(e,r){var t="text";switch(r.style){case"unit":t="text";break;case"currency":case"percent":t=void 0===r.pattern?"text":_(e,r);break;default:t=void 0===r.pattern?"short"===r.decimalFormat||"long"===r.decimalFormat?"text":function(e,r){if(void 0===r.useGrouping||r.useGrouping){if("."===e.decimalSeparator&&""===e.groupingSeparator)return"number"}else if("."===e.decimalSeparator)return"number";return"text"}(e,r):_(e,r)}return t}(e,r),n}function _(e,r){var t;if(t=r.pattern,/[^0-9.#]/i.test(t))return"text";var n=function(e){if(-1!==e.indexOf(","))return!0;return!1}(r.pattern),i=function(e){if(-1!==e.indexOf("."))return!0;return!1}(r.pattern);if(n&&i){if(""!==e.groupingSeparator||"."!==e.decimalSeparator)return"text";if(e.groupingSeparator===e.decimalSeparator)return"text"}return i&&!n&&"."!==e.decimalSeparator||!i&&n&&""!==e.groupingSeparator?"text":"number"}return{getInstance:function(){return e||(e={format:function(e,r,t,n){(arguments.length<=2||void 0===t)&&(t={useGrouping:!0,style:"decimal"}),y(t,"OraNumberConverter.format");var i={};return d(r,i,t,n),F(e,t,r,i,n)},parse:function(e,r,t,n){return"number"==typeof e?e:"[object Number]"===Object.prototype.toString.call(e)?Number(e):((arguments.length<=2||void 0===t)&&(t={useGrouping:!0,style:"decimal"}),y(t,"OraNumberConverter.parse"),O(e,r,t,n))},resolvedOptions:function(e,r,n){(arguments.length<3||void 0===n)&&(n=t.OraI18nUtils.getLocaleElementsMainNodeKey(e)),(arguments.length<2||void 0===r)&&(r={useGrouping:!0,style:"decimal"});var i=P(e,r,n);return j(i,r,n)}}),e}}}(),c=function(){this.Init()};oj.Object.createSubclass(c,i,"oj.NumberConverter"),c.prototype.Init=function(e){c.superclass.Init.call(this,e)},c.prototype.format=function(e){return c.superclass.format.call(this,e)},c.prototype.parse=function(e){return c.superclass.parse.call(this,e)};const m=function(e){this.Init(e)};s.Object.createSubclass(m,c,"oj.IntlNumberConverter"),m.prototype.Init=function(e){m.superclass.Init.call(this,e)},m.prototype._getWrapped=function(){return this._wrapped||(this._wrapped=l.getInstance()),this._wrapped},m.prototype.format=function(e){if(null==e||"string"==typeof e&&0===s.StringUtils.trim(""+e).length||"number"==typeof e&&isNaN(e))return"";var t,i=o.getLocale(),u=n.__getBundle(),l=this.resolvedOptions();try{t=this._getWrapped().format(e,u,l,i)}catch(r){throw this._processConverterError(r,e)}if("NaN"===t){var c=a.getTranslatedString("oj-converter.number.invalidNumberFormat.summary",{value:e}),m=a.getTranslatedString("oj-converter.number.invalidNumberFormat.detail");r.error(c+" "+m)}return t},m.prototype.getHint=function(){return null},m.prototype.getOptions=function(){return m.superclass.getOptions.call(this)},m.prototype.parse=function(e){var r,t,i;if(null==e||""===e)return null;r=o.getLocale(),t=n.__getBundle(),i=this.resolvedOptions();try{return this._getWrapped().parse(s.StringUtils.trim(e),t,i,r)}catch(r){throw this._processConverterError(r,e)}},m.prototype.resolvedOptions=function(){var e,t=o.getLocale();if(t!==this._locale||!this._resolvedOptions){e=n.__getBundle();try{if(!e)return r.error("locale bundle for the current locale %s is unavailable",t),{};this._resolvedOptions=this._getWrapped().resolvedOptions(e,this.getOptions(),t),this._locale=t}catch(e){throw this._processConverterError(e)}}return this._resolvedOptions},m.prototype._processConverterError=function(e,r){var n,i,o,l,c=e.errorInfo;if(c){var m=c.errorCode,p=c.parameterMap;switch(s.Assert.assertObject(p),m){case"optionTypesMismatch":case"optionTypeInvalid":case"optionOutOfRange":case"optionValueInvalid":n=t.IntlConverterUtils.__getConverterOptionError(m,p);break;case"decimalFormatMismatch":o="oj-converter.number.decimalFormatMismatch.summary";break;case"currencyFormatMismatch":o="oj-converter.number.currencyFormatMismatch.summary";break;case"percentFormatMismatch":o="oj-converter.number.percentFormatMismatch.summary";break;case"unsupportedParseFormat":l=a.getTranslatedString("oj-converter.number.shortLongUnsupportedParse.summary"),i=a.getTranslatedString("oj-converter.number.shortLongUnsupportedParse.detail"),n=new u.ConverterError(l,i)}o&&(l=a.getTranslatedString(o,{value:r||p.value,format:p.format}),i=a.getTranslatedString("oj-converter.hint.detail",{exampleValue:this._getHintValue()}),n=new u.ConverterError(l,i))}return n||(l=e.message,i=e.message,n=new u.ConverterError(l,i)),n},m.prototype._getHintValue=function(){var e="";try{e=this.format(12345.98765)}catch(t){t instanceof u.ConverterError&&(e="",r.error("error retrieving hint value in format"))}return e},e.IntlNumberConverter=m,e.NumberConverter=c,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=ojconverter-number.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojdvt-axis',["exports","ojs/ojconverter-number"],function(t,i){"use strict";class a{constructor(t,i,a){this._context=t,this.Position=i.position,this._radius=i._radius,"top"===this.Position||"bottom"===this.Position?(this.StartCoord=a.x,this.EndCoord=a.x+a.w):"left"===this.Position||"right"===this.Position?(this.StartCoord=a.y,this.EndCoord=a.y+a.h):"radial"===this.Position?(this.StartCoord=0,this.EndCoord=this._radius):"tangential"===this.Position&&(i.isRTL?(this.StartCoord=2*Math.PI,this.EndCoord=0):(this.StartCoord=0,this.EndCoord=2*Math.PI)),this.MinValue=null,this.MaxValue=null,this.GlobalMin=null,this.GlobalMax=null,this.DataMin=null,this.DataMax=null,this.StartOverflow=0,this.EndOverflow=0,null==i.leftBuffer&&(i.leftBuffer=1/0),null==i.rightBuffer&&(i.rightBuffer=1/0),this.Options=i}getCtx(){return this._context}getOptions(){return this.Options}getValAt(t){if(null==t)return null;var i=Math.min(this.StartCoord,this.EndCoord),a=Math.max(this.StartCoord,this.EndCoord);return t<i||t>a?null:this.getUnboundedValAt(t)}getCoordAt(t){return null==t||t<this.MinValue||t>this.MaxValue?null:this.getUnboundedCoordAt(t)}getBoundedValAt(t){if(null==t)return null;var i=t,a=Math.min(this.StartCoord,this.EndCoord),n=Math.max(this.StartCoord,this.EndCoord);return t<a?i=a:t>n&&(i=n),this.getUnboundedValAt(i)}getBoundedCoordAt(t){if(null==t)return null;var i=t;return t<this.MinValue?i=this.MinValue:t>=this.MaxValue&&(i=this.MaxValue),this.getUnboundedCoordAt(i)}getUnboundedValAt(t){return null}getUnboundedCoordAt(t){return null}}a.MIN_AXIS_BUFFER=10;t.BaseAxisInfo=a,t.DataAxisInfoMixin=t=>class extends t{constructor(t,i,n){super(t,i,n),this.MAX_NUMBER_OF_GRIDS_AUTO=10,this.MINOR_TICK_COUNT=2,this.MAJOR_TICK_INCREMENT_BUFFER=1e-10,this.MIN_BAR_SIZE_IN_LOG=10,"top"===this.Position||"bottom"===this.Position?("off"!==i.tickLabel.rendered&&"off"!==i.rendered&&(this.StartOverflow=Math.max(a.MIN_AXIS_BUFFER-i.leftBuffer,0),this.EndOverflow=Math.max(a.MIN_AXIS_BUFFER-i.rightBuffer,0)),i.isRTL?(this.MinCoord=this.EndCoord-this.EndOverflow,this.MaxCoord=this.StartCoord+this.StartOverflow):(this.MinCoord=this.StartCoord+this.StartOverflow,this.MaxCoord=this.EndCoord-this.EndOverflow)):"tangential"===this.Position||"radial"===this.Position?(this.MinCoord=this.StartCoord,this.MaxCoord=this.EndCoord):(this.MinCoord=this.EndCoord,this.MaxCoord=this.StartCoord),this.DataMin=i.dataMin,this.DataMax=i.dataMax,this.utilsLogOptions=i._utils&&"log"===i.scale,this.IsLog=this.utilsLogOptions||"log"===i.scale&&this.DataMin>0&&this.DataMax>0,this.LinearGlobalMin=this.actualToLinear(i.min),this.LinearGlobalMax=this.actualToLinear(i.max),this.LinearMinValue=null==i.viewportMin?this.LinearGlobalMin:this.actualToLinear(i.viewportMin),this.LinearMaxValue=null==i.viewportMax?this.LinearGlobalMax:this.actualToLinear(i.viewportMax),this._dataMin=this.actualToLinear(this.DataMin),this._dataMax=this.actualToLinear(this.DataMax),this.MajorIncrement=this.actualToLinear(i.step),this.MinorIncrement=this.actualToLinear(i.minorStep),this._minMajorIncrement=this.actualToLinear(i.minStep),this.MajorTickCount=i._majorTickCount,this.MinorTickCount=i._minorTickCount,this.LogScaleUnit=i._logScaleUnit,this.ZeroBaseline=!this.IsLog&&"zero"===i.baselineScaling,this._continuousExtent=this.Options?"on"===this.Options._continuousExtent:null,this.Converter=null,null!=i.tickLabel&&(this.Converter=i.tickLabel.converter),this._calcAxisExtents(),this.GlobalMin=this.linearToActual(this.LinearGlobalMin),this.GlobalMax=this.linearToActual(this.LinearGlobalMax),this.MinValue=this.linearToActual(this.LinearMinValue),this.MaxValue=this.linearToActual(this.LinearMaxValue)}getBaselineCoord(){return this.IsLog?this.MinCoord:this.getBoundedCoordAt(0)}getUnboundedValAt(t){if(null==t)return null;var i=(t-this.MinCoord)/(this.MaxCoord-this.MinCoord),a=this.LinearMinValue+i*(this.LinearMaxValue-this.LinearMinValue);return this.linearToActual(a)}getUnboundedCoordAt(t){return this.GetUnboundedCoordAt(this.actualToLinear(t))}GetUnboundedCoordAt(t){if(null==t)return null;var i=this.LinearMaxValue===this.LinearMinValue?0:(t-this.LinearMinValue)/(this.LinearMaxValue-this.LinearMinValue);return i=Math.max(Math.min(1e3,i),-1e3),this.MinCoord+i*(this.MaxCoord-this.MinCoord)}CalcMajorMinorIncr(t){this.MajorIncrement||(this.MajorTickCount?this.MajorIncrement=(this.LinearMaxValue-this.LinearMinValue)/this.MajorTickCount:this.MajorIncrement=Math.max(t,this._minMajorIncrement)),this.MajorTickCount||(this.MajorTickCount=(this.LinearMaxValue-this.LinearMinValue)/this.MajorIncrement,Math.ceil(this.MajorTickCount)-this.MajorTickCount<this.MAJOR_TICK_INCREMENT_BUFFER&&(this.MajorTickCount=Math.ceil(this.MajorTickCount))),this.MinorTickCount||(this.MinorIncrement?this.MinorTickCount=this.MajorIncrement/this.MinorIncrement:this.IsLog?this.MinorTickCount=this.MajorIncrement:this.MinorTickCount=this.MINOR_TICK_COUNT),this.MinorIncrement||(this.MinorIncrement=this.MajorIncrement/this.MinorTickCount)}_calcAxisExtents(){this.ZeroBaseline&&(this._dataMin=Math.min(0,this._dataMin),this._dataMax=Math.max(0,this._dataMax));var t=null!=this.LinearGlobalMax?this.LinearGlobalMax:this._dataMax,i=null!=this.LinearGlobalMin?this.LinearGlobalMin:this._dataMin,a=Math.max(this._calcAxisScale(i,t),this._minMajorIncrement);this._dataMin===this._dataMax&&(0===this._dataMin?this._dataMax+=5*a:(this._dataMin-=2*a,this._dataMax+=2*a)),null==this.LinearGlobalMin&&(this.ZeroBaseline&&this._dataMin>=0?this.LinearGlobalMin=0:this._continuousExtent?this.LinearGlobalMin=this._dataMin-.1*(this._dataMax-this._dataMin):this.ZeroBaseline||null==this.LinearGlobalMax?this.LinearGlobalMin=(Math.ceil(this._dataMin/a)-1)*a:(this.LinearGlobalMin=this.LinearGlobalMax,this.LinearGlobalMin-=a*(Math.floor((this.LinearGlobalMin-this._dataMin)/a)+1)),this._dataMin>=0&&!this.IsLog&&(this.LinearGlobalMin=Math.max(this.LinearGlobalMin,0))),null==this.LinearGlobalMax&&(this.MajorTickCount?(this.LinearGlobalMax=this.LinearGlobalMin+this.MajorTickCount*a,this.LinearGlobalMax<this._dataMax&&(a=Math.max(this._calcAxisScale(i,t+a),this._minMajorIncrement),this.LinearGlobalMax=this.LinearGlobalMin+this.MajorTickCount*a)):this.ZeroBaseline&&this._dataMax<=0?this.LinearGlobalMax=0:this._continuousExtent?this.LinearGlobalMax=this._dataMax+.1*(this._dataMax-this._dataMin):this.ZeroBaseline?this.LinearGlobalMax=(Math.floor(this._dataMax/a)+1)*a:(this.LinearGlobalMax=this.LinearGlobalMin,this.LinearGlobalMax+=a*(Math.floor((this._dataMax-this.LinearGlobalMax)/a)+1)),this._dataMax<=0&&(this.LinearGlobalMax=Math.min(this.LinearGlobalMax,0))),this.LinearGlobalMax===this.LinearGlobalMin&&(this.LinearGlobalMax=100,this.LinearGlobalMin=0,a=(this.LinearGlobalMax-this.LinearGlobalMin)/this.MAX_NUMBER_OF_GRIDS_AUTO),null==this.LinearMinValue&&(this.LinearMinValue=this.LinearGlobalMin),null==this.LinearMaxValue&&(this.LinearMaxValue=this.LinearGlobalMax);var n=Math.abs(this.GetUnboundedCoordAt(this.LinearGlobalMin)-this.GetUnboundedCoordAt(this._dataMin));(this.IsLog&&n<this.MIN_BAR_SIZE_IN_LOG||this.utilsLogOptions)&&(this.LinearGlobalMin-=a,this.LinearMinValue=this.LinearGlobalMin),this.LinearMinValue===this.LinearGlobalMin&&this.LinearMaxValue===this.LinearGlobalMax||(a=this._calcAxisScale(this.LinearMinValue,this.LinearMaxValue)),this.LinearGlobalMin>this.LinearMinValue&&(this.LinearGlobalMin=this.LinearMinValue),this.LinearGlobalMax<this.LinearMaxValue&&(this.LinearGlobalMax=this.LinearMaxValue),this.CalcMajorMinorIncr(a)}_calcAxisScale(t,i){if(this.MajorIncrement)return this.MajorIncrement;var a,n=i-t;if(this.IsLog){var s=Math.floor(n/8)+1;return(!this.LogScaleUnit||this.LogScaleUnit<s)&&(this.LogScaleUnit=s),this.LogScaleUnit}if(0===n)return 0===t?10:Math.pow(10,Math.floor(Math.log10(t))-1);if(this.MajorTickCount){var e=n/this.MajorTickCount,r=e/(a=Math.pow(10,Math.ceil(Math.log10(e)-1)));return(r=r>1&&r<=1.5?1.5:r>5?10:Math.ceil(r))*a}var o=Math.log10(n);a=Math.pow(10,Math.ceil(o)-2);var l=Math.round(n/a);return(l>=10&&l<=14?2:l>=15&&l<=19?3:l>=20&&l<=24?4:l>=25&&l<=45?5:l>=46&&l<=80?10:20)*a}linearToActual(t){return null==t?null:this.IsLog?Math.pow(10,t):t}actualToLinear(t){return null==t?null:this.IsLog?t>0?Math.log10(t):null:t}getAxisData(){return{isLog:this.IsLog,max:this.LinearGlobalMax,min:this.LinearGlobalMin,step:this.MajorIncrement,numSteps:this.MajorTickCount}}},t.LinearScaleAxisValueFormatter=class{constructor(t,i,a,n,s,e){this.SCALE_NONE="none",this.SCALE_AUTO="auto",this.SCALE_THOUSAND="thousand",this.SCALE_MILLION="million",this.SCALE_BILLION="billion",this.SCALE_TRILLION="trillion",this.SCALE_QUADRILLION="quadrillion",this.SCALING_FACTOR_DIFFERENCE=3,this._translations=e,this._scales={},this._scalesOrder=[],this._factorToScaleMapping={},this.InitScales(),this.InitFormatter(t,i,a,n,s)}InitScales(){const t=(t,i,a)=>{var n;a&&(n=this._translations?this._translations[a]:null);var s={scaleFactor:i,localizedSuffix:n};this._scales[t]=s,this._scalesOrder.push(s),this._factorToScaleMapping[i]=s};var i=this.SCALING_FACTOR_DIFFERENCE;t(this.SCALE_NONE,0*i),t(this.SCALE_THOUSAND,1*i,"labelScalingSuffixThousand"),t(this.SCALE_MILLION,2*i,"labelScalingSuffixMillion"),t(this.SCALE_BILLION,3*i,"labelScalingSuffixBillion"),t(this.SCALE_TRILLION,4*i,"labelScalingSuffixTrillion"),t(this.SCALE_QUADRILLION,5*i,"labelScalingSuffixQuadrillion"),this._scalesOrder.sort((t,i)=>t.scaleFactor<i.scaleFactor?-1:t.scaleFactor>i.scaleFactor?1:0)}InitFormatter(t,i,a,n,s){var e,r,o=!1,l=!1;if("off"!==s&&(l=!0),"number"!=typeof(r=this._getScaleFactor(n))&&(o=!0),o){var h=Math.max(Math.abs(t),Math.abs(i)),M=this._getPowerOfTen(h);r=this._findNearestLEScaleFactor(M)}if(!0===l)if(0===a&&t===i){var u=r-this._getPowerOfTen(i);e=u<=0?Math.max(u+3,0):Math.max(u,4)}else{var c=this._getPowerOfTen(a);e=Math.max(r-c,0)}this._useAutoPrecision=l,this._scaleFactor=r,this._decimalPlaces=e}_findNearestLEScaleFactor(t){var i=0;if(t<=this._scalesOrder[0].scaleFactor)i=this._scalesOrder[0].scaleFactor;else if(t>=this._scalesOrder[this._scalesOrder.length-1].scaleFactor)i=this._scalesOrder[this._scalesOrder.length-1].scaleFactor;else for(var a=this._scalesOrder.length-1;a>=0;a--)if(this._scalesOrder[a].scaleFactor<=t){i=this._scalesOrder[a].scaleFactor;break}return i}_getScaleFactor(t){var i,a=t||this.SCALE_AUTO,n=this._scales[a];return n&&(i=n.scaleFactor),i}format(t,a){var n=null!=t?parseFloat(t):t;if("number"==typeof n){var s=Math.pow(10,this._scaleFactor),e={style:"decimal",decimalFormat:"unit"===(a&&a.getOptions&&a.getOptions()&&a.getOptions().style)?"standard":"short",nu:"latn",useGrouping:!1},r=new i.IntlNumberConverter(e).format(s,e),o=/(\d+)(.*$)/.exec(r),l=o[2],h=Number(o[1])/s*n;if(a&&a.format)h=a.format(h);else{var M={style:"decimal",minimumFractionDigits:this._decimalPlaces,maximumFractionDigits:this._decimalPlaces};h=new i.IntlNumberConverter(M).format(h,M)}return"string"==typeof l&&0!==t&&(h+=l),h}return t}_formatFraction(t){var i=t.toString();if(-1!==i.indexOf("e"))return i;if(this._decimalPlaces>0){-1===i.indexOf(".")&&(i+=".");for(var a=i.substring(i.indexOf(".")+1).length;a<this._decimalPlaces;)i+="0",a+=1}return i}_getPowerOfTen(t){var i=t>=0?t:-t,a=0;if(i<1e-15)return 0;if(i===1/0)return Number.MAX_VALUE;if(i>=10)for(;i>=10;)a+=1,i/=10;else if(i<1)for(;i<1;)a-=1,i*=10;return a}getDecimalPlaces(){return this._decimalPlaces}},Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ojdvt-axis.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojlegend-toolkit',["exports","ojs/ojdvt-toolkit"],function(e,t){"use strict";const i=(e,t)=>{var i=null,s=null!=t.getOptions().data;return e.categories&&e.categories.length>0?i=e.categories[0]:s||(i=e.id?e.id:e.text),i},s=(e,t)=>{var i=t.getOptions().hiddenCategories;return!(!i||i.length<=0)&&-1!==i.indexOf(e)},n=(e,t)=>{var i=t.getOptions();return"off"==e.expanded||0==e.expanded||i.expanded&&0==i.expanded.has(e.id)};class a{constructor(e,s,n,a,r,l){if(this._legend=e,this._displayables=s,this._item=n,this._category=i(this._item,this._legend),this._id=this._category?this._category:n.title,this._drillable=l,this._tooltip=a,this._datatip=r,this._isShowingKeyboardFocusEffect=!1,this._hoverBorderRadius=parseInt(e.getOptions()._hoverBorderRadius),this._drillable)for(var o=0;o<this._displayables.length;o++)this._displayables[o].setCursor(t.SelectionEffectUtils.getSelectingCursor())}static associate(e,t,i,s,n,r){if(!e||!i)return null;var l=new a(t,e,i,s,n,r);t.__registerObject(l);for(var o=0;o<e.length;o++)t.getEventManager().associate(e[o],l);return l}getData(){return this._item}getColor(){return this._item.color}getId(){return this._id}getDisplayables(){return this._displayables}getCategories(){return null!=this._category?[this._category]:null}isDrillable(){return this._drillable}getAriaLabel(){var e=[],i=this._legend.getOptions().translations,a=this._legend.getOptions().hideAndShowBehavior,r=s(this._category,this._legend),l=this.getData();return this._displayables[0]instanceof t.IconButton?(e.push(i[n(l,this._legend)?"stateCollapsed":"stateExpanded"]),t.Displayable.generateAriaLabel(l.title,e)):("off"!=a&&"none"!=a&&e.push(i[r?"stateHidden":"stateVisible"]),this.isDrillable()&&e.push(i.stateDrillable),null!=l.shortDesc?t.Displayable.generateAriaLabel(l.shortDesc,e):e.length>0?t.Displayable.generateAriaLabel(l.text,e):null)}updateAriaLabel(){!t.Agent.deferAriaCreation()&&this._displayables[0]&&this._displayables[0].setAriaProperty("label",this.getAriaLabel())}getNextNavigable(e){if(e.type==t.MouseEvent.CLICK)return this;var i=this._legend.__getKeyboardObjects();return t.KeyboardHandler.getNextNavigable(this,e,i,!0,this._legend)}getKeyboardBoundingBox(e){return this._displayables[0]?this._displayables[0].getDimensions(e):new t.Rectangle(0,0,0,0)}getTargetElem(){return this._displayables[0]?this._displayables[0].getElem():null}showKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!0,this._displayables[0]&&(this._displayables[0]instanceof t.IconButton?this._displayables[0].showKeyboardFocusEffect():this._displayables[0].setSolidStroke(t.Agent.getFocusColor()))}hideKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!1,this._displayables[0]&&(this._displayables[0]instanceof t.IconButton?this._displayables[0].hideKeyboardFocusEffect():this._displayables[0].setStroke(null))}isShowingKeyboardFocusEffect(){return this._isShowingKeyboardFocusEffect}getTooltip(){return this._tooltip}getDatatip(){return this._datatip}getDatatipColor(){return this._item.color}isDragAvailable(){return!0}getDragTransferable(){return[this.getId()]}getDragFeedback(){return this.getDisplayables()}showHoverEffect(){this._displayables[0]&&this._displayables[0]instanceof t.Rect&&(this._displayables[0].setClassName("oj-legend-hover"),this._displayables[0].setRx(this._hoverBorderRadius))}hideHoverEffect(){this._displayables[0]&&this._displayables[0]instanceof t.Rect&&(this._displayables[0].setClassName(),this._displayables[0].setRx(0))}}class r extends t.Automation{GetSubIdForDomElement(e){var t=this._comp.getEventManager().GetLogicalObject(e);if(t&&t instanceof a){var i=t.getData(),s=this._getIndicesFromItem(i,this._comp.getOptions());if(s)return"section"+s}return null}_getIndicesFromItem(e,t){if(t.sections&&t.sections.length>0){for(var i=0;i<t.sections.length;i++){if(t.sections[i]==e)return"["+i+"]";var s=this._getIndicesFromItem(e,t.sections[i]);if(s)return"["+i+"]"+s}return null}if(t.items&&t.items.length>0){for(var n=0;n<t.items.length;n++)if(t.items[n]==e)return":item["+n+"]";return null}return null}getIndicesFromSeries(e,t){if(t.sections&&t.sections.length>0){for(var i=0;i<t.sections.length;i++){var s=this.getIndicesFromSeries(e,t.sections[i]);if(s)return"["+i+"]"+s}return null}if(t.items&&t.items.length>0){for(var n=0;n<t.items.length;n++)if(t.items[n].text==e.name)return":item["+n+"]";return null}return null}getLegendItem(e,t){var i=t.indexOf("["),s=t.indexOf("]");if(i>=0&&s>=0){var n=t.substring(i+1,s),a=t.indexOf(":"),r=(t=t.substring(s+1)).indexOf("["),l=t.indexOf("]");return r>=0&&l>=0?this.getLegendItem(e.sections[n],t):0==a?e.items[n]:e.sections[n]}}getDomElementForSubId(e){if(e==t.Automation.TOOLTIP_SUBID)return this.GetTooltipElement(this._comp);for(var i=this.getLegendItem(this._comp.getOptions(),e),s=this._comp.__getObjects(),n=0;n<s.length;n++){if(i==s[n].getData())return s[n].getDisplayables()[0].getElem()}return null}getTitle(){return this._comp.getOptions().title}getItem(e){var t,i=e.shift(),s=this._comp.getOptions();if(!s.sections||0===s.sections.length)return null;for(;null!=i;)e.length>0?s=s.sections[i]:t=s.items[i],i=e.shift();return t?{text:t.text?t.text:null}:null}getSection(e){var t,i=e.shift(),s=this._comp.getOptions();if(!s.sections||0===s.sections.length)return null;for(;null!=i;)e.length>0?s=s.sections[i]:t=s.sections[i],i=e.shift();return{title:t&&t.title?t.title:null,items:t&&t.items?this._generateItemObjects(t.items):null,sections:t&&t.sections?this._generateSectionObjects(t.sections):null}}_generateItemObjects(e){for(var t=[],i=0;i<e.length;i++)t.push({text:e[i].text});return t}_generateSectionObjects(e){for(var t=[],i=0;i<e.length;i++)t.push({title:e[i].title?e[i].title:null,items:e[i].items?this._generateItemObjects(e[i].items):null,sections:e[i].sections?this._generateSectionObjects(e[i].sections):null});return t}}class l extends t.BaseComponentDefaults{constructor(e){super({alta:{skin:t.CSSStyle.SKIN_ALTA,orientation:"vertical",position:null,backgroundColor:null,borderColor:null,textStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_11+"color: #333333;"),titleStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_11+"color: #737373;"),_sectionTitleStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_11+"color: #737373;"),titleHalign:"start",hiddenCategories:[],hideAndShowBehavior:"off",hoverBehavior:"none",hoverBehaviorDelay:200,scrolling:"asNeeded",halign:"start",valign:"top",drilling:"off",dnd:{drag:{series:{}},drop:{legend:{}}},_color:"#a6acb1",_markerShape:"square",_lineWidth:3,layout:{outerGapWidth:3,outerGapHeight:3,titleGapWidth:17,titleGapHeight:9,symbolGapWidth:7,symbolGapHeight:4,rowGap:4,columnGap:10,sectionGapHeight:16,sectionGapWidth:24},isLayout:!1}},e)}static getGapSize(e,i){var s=Math.min(t.TextUtils.getTextStringHeight(e.getCtx(),e.getOptions().textStyle)/14,1);return Math.ceil(i*s)}getNoCloneObject(){return{sections:{items:{_getDataContext:!0}}}}}class o extends t.EventManager{constructor(e){super(e.getCtx(),e.processEvent,e,e),this._legend=e}OnClick(e){super.OnClick(e);var t=this.GetLogicalObject(e.target);if(t){var i=this.processHideShowEvent(t),s=this.handleClick(t,e);(i||s)&&e.stopPropagation()}}OnMouseOver(e){super.OnMouseOver(e);var t=this.GetLogicalObject(e.target);t&&this.UpdateActiveElement(t)}HandleTouchClickInternal(e){var t=this.GetLogicalObject(e.target);if(t){var i=e.touchEvent,s=this.processHideShowEvent(t),n=this.handleClick(t,e);(s||n)&&i&&i.preventDefault()}}processHideShowEvent(e){var i=this._legend.getOptions().hideAndShowBehavior;if("none"==i||"off"==i)return!1;var n=e.getCategories?e.getCategories():null;if(!n||n.length<=0)return!1;var a=e.getCategories()[0],r=this._legend.getOptions().hiddenCategories||[];r=r.slice();for(var l=e.getDisplayables(),o=0;o<l.length;o++){var h=l[o];h instanceof t.SimpleMarker?h.setHollow(e.getColor()):h instanceof t.Rect&&e.updateAriaLabel()}var g,d=n[0];return s(a,this._legend)?(r.splice(r.indexOf(a),1),g=t.EventFactory.newCategoryShowEvent(d,r)):(r.push(a),g=t.EventFactory.newCategoryHideEvent(d,r)),this._legend.getOptions().hiddenCategories=r,this.FireEvent(g,this._legend),!0}handleClick(e,i){if(e instanceof a&&e.isDrillable()){var s=e.getId();return this.FireEvent(t.EventFactory.newDrillEvent(s),this._legend),!0}var n=e instanceof t.SimpleObjPeer?e.getParams():null;return!(!n||!n.isCollapsible)&&(this.toggleSectionCollapse(i,n.id),!0)}ProcessRolloverEvent(e,i,s){var n=this._legend.getOptions();if(("none"!==n.hoverBehavior||"none"!==n.hideAndShowBehavior&&"off"!==n.hideAndShowBehavior)&&!(i.getDisplayables&&i.getDisplayables()[0]instanceof t.IconButton)){if("none"!==n.hoverBehavior){var a=i.getCategories?i.getCategories():[];n.highlightedCategories=s&&a?a.slice():null;var r=t.EventFactory.newCategoryHighlightEvent(n.highlightedCategories,s),l=t.CSSStyle.getTimeMilliseconds(n.hoverBehaviorDelay);this.RolloverHandler.processEvent(r,this._legend.__getObjects(),l,!0)}"none"!==n.hideAndShowBehavior&&"off"!==n.hideAndShowBehavior&&(s?i.showHoverEffect&&i.showHoverEffect():i.hideHoverEffect&&i.hideHoverEffect())}}onCollapseButtonClick(e,t){var i=t.getId();this.toggleSectionCollapse(e,i)}toggleSectionCollapse(e,i){for(var s=this._legend.getOptions(),n=s.expanded,a=this._legend.getOptions(),r=null,l=0;l<i.length;l++)a=a.sections[i[l]];if(n?n.has(a.id)?(s.expanded=n.delete([a.id]),r=!1):(s.expanded=n.add([a.id]),r=!0):a.expanded="off"==a.expanded?"on":"off",e.type==t.MouseEvent.CLICK){var o=this.GetLogicalObject(e.target);o.getNextNavigable&&this.setFocusObj(o.getNextNavigable(e))}var h=this._legend.getKeyboardFocus(),g=!!h&&h.isShowingKeyboardFocusEffect();this._legend.render(),h&&this._legend.setKeyboardFocus(h,g),this.hideTooltip(),null!=r&&(e=new t.EventFactory.newExpandCollapseEvent(r?"expand":"collapse",a.id,a,this._legend.getOptions()._widgetConstructor,s.expanded),this.FireEvent(e,this._legend))}GetTouchResponse(){return this._legend.getOptions()._isScrollingLegend?t.EventManager.TOUCH_RESPONSE_TOUCH_HOLD:t.EventManager.TOUCH_RESPONSE_TOUCH_START}isDndSupported(){return!0}GetDragSourceType(e){var t=this.DragSource.getDragObject();return t instanceof a&&null!=t.getData()._getDataContext?"series":null}GetDragDataContexts(e){var i=this.DragSource.getDragObject();if(i instanceof a){var s=i.getData()._getDataContext();return e&&(s=t.JsonUtils.clone(s,null,{component:!0,componentElement:!0}),t.ToolkitUtils.cleanDragDataContext(s)),[s]}return[]}GetDropTargetType(e){var t=this._legend.stageToLocal(this.getCtx().pageToStageCoords(e.pageX,e.pageY)),i=this._legend.getOptions().dnd.drop,s=this._legend.__getBounds();return Object.keys(i.legend).length>0&&s.containsPoint(t.x,t.y)?"legend":null}GetDropEventPayload(e){return{}}ShowDropEffect(e){if("legend"==this.GetDropTargetType(e)){var t=this._legend.getOptions()._dropColor,i=this._legend.getCache().getFromCache("background");i&&(i.setSolidFill(t),i.setClassName("oj-active-drop"))}}ClearDropEffect(){var e=this._legend.getCache().getFromCache("background");if(e){var i=this._legend.getOptions().backgroundColor;i?e.setSolidFill(i):e.setInvisibleFill(),t.ToolkitUtils.removeClassName(e.getElem(),"oj-invalid-drop"),t.ToolkitUtils.removeClassName(e.getElem(),"oj-active-drop")}}ShowRejectedDropEffect(e){if("legend"==this.GetDropTargetType(e)){var t=this._legend.getCache().getFromCache("background");t&&t.setClassName("oj-invalid-drop")}}}class h extends t.KeyboardHandler{constructor(e,t){super(e),this._legend=t}processKeyDown(e){var i=e.keyCode,s=this._eventManager.getFocus(),n=s&&s.getDisplayables()[0]instanceof t.IconButton,a=null;if(null==s&&i==t.KeyboardEvent.TAB){var r=this._legend.__getKeyboardObjects();r.length>0&&(t.EventManager.consumeEvent(e),a=this.getDefaultNavigable(r))}else s&&(i==t.KeyboardEvent.TAB?(t.EventManager.consumeEvent(e),a=s):i==t.KeyboardEvent.ENTER||i==t.KeyboardEvent.SPACE?(i==t.KeyboardEvent.ENTER&&this._eventManager.handleClick(s,e),n?this._eventManager.onCollapseButtonClick(e,s.getDisplayables()[0]):this._eventManager.processHideShowEvent(s),t.EventManager.consumeEvent(e)):!n||i!=t.KeyboardEvent.LEFT_ARROW&&i!=t.KeyboardEvent.RIGHT_ARROW?a=super.processKeyDown(e):(this._eventManager.onCollapseButtonClick(e,s.getDisplayables()[0]),t.EventManager.consumeEvent(e)));return a&&this._legend.container.scrollIntoView(a.getDisplayables()[0]),a}}const g={_DEFAULT_LINE_WIDTH_WITH_MARKER:2,_LINE_MARKER_SIZE_FACTOR:.6,_DEFAULT_SYMBOL_SIZE:10,_BUTTON_SIZE:12,_FOCUS_GAP:2,render:(e,i)=>{var s=e.getOptions(),n=e.getCtx(),a=t.Agent.isRightToLeft(n);e.__setBounds(i),s.isLayout||g._renderBackground(e,i);var r="redwood"===n.getThemeBehavior()?"always":"asNeeded",o=new t.SimpleScrollableContainer(n,i.w,i.h,r),h=new t.Container(n);o.getScrollingPane().addChild(h),e.addChild(o),e.container=o;var d=l.getGapSize(e,s.layout.outerGapWidth),c=l.getGapSize(e,s.layout.outerGapHeight);if(i.x+=d,i.y+=c,i.w-=2*d,i.h-=2*c,i.w<=0||i.h<=0)return new t.Dimension(0,0);var u=g._renderContents(e,h,new t.Rectangle(i.x,i.y,i.w,i.h));if(0==u.w||0==u.h)return new t.Dimension(0,0);o.prepareContentPane(),u.h>i.h?(u.h=i.h,s._isScrollingLegend=!0):s._isScrollingLegend=!1;var p=0,_=0,v=null!=s.hAlign?s.hAlign:s.halign;"center"==v?p=i.x-u.x+(i.w-u.w)/2:"end"==v&&(p=a?i.x-u.x:i.x-u.x+i.w-u.w);var y=null!=s.vAlign?s.vAlign:s.valign;"middle"==y?_=i.y-u.y+(i.h-u.h)/2:"bottom"==y&&(_=i.y-u.y+i.h-u.h);var b=new t.Rectangle(u.x+p-d,u.y+_-c,u.w+2*d,u.h+2*c);if(s.isLayout)return b;(p||_)&&h.setTranslate(p,_);for(var m=e.__getTitles(),f=0;f<m.length;f++)t.LayoutUtils.align(u,m[f].halign,m[f].text,m[f].text.getDimensions().w);return b},_renderContents:(e,t,i)=>{var s=e.getOptions();i=i.clone();var n=g._renderTitle(e,t,s.title,i,null,!0);if(n){var a=n.getDimensions(),r=l.getGapSize(e,s.layout.titleGapHeight);i.y+=a.h+r,i.h-=Math.floor(a.h+r)}var o=g._renderSections(e,t,s.sections,i,[]);return n?a.getUnion(o):o},_renderBackground:(e,i)=>{var s=e.getOptions(),n=s.backgroundColor,a=s.borderColor,r=s.dnd?s.dnd.drop.legend:{},l=s.dnd?s.dnd.drag.series:{};if(n||a||Object.keys(r).length>0||Object.keys(l).length>0){var o=new t.Rect(e.getCtx(),i.x,i.y,i.w,i.h);n?o.setSolidFill(n):o.setInvisibleFill(),a&&(o.setSolidStroke(a),o.setPixelHinting(!0)),e.addChild(o),e.getCache().putToCache("background",o)}},_renderTitle:(e,i,s,n,a,r,l,o)=>{var h=e.getOptions(),g=i.getCtx(),d=t.Agent.isRightToLeft(g);if(!s)return null;var c=new t.OutputText(g,s,n.x,n.y),u=h.titleStyle;if(a){var p=h._sectionTitleStyle.clone();u=a.titleStyle?p.merge(new t.CSSStyle(a.titleStyle)):p}if(c.setCSSStyle(u),t.TextUtils.fitText(c,n.w,1/0,i)){if(d&&c.setX(n.x+n.w-c.getDimensions().w),h.isLayout)i.removeChild(c);else{var _={id:l,button:o};if(_.isCollapsible=a&&("on"===a.collapsible||"boolean"==typeof a.collapsible&&a.collapsible),e.getEventManager().associate(c,new t.SimpleObjPeer(c.getUntruncatedTextString(),null,null,_)),r){var v=a&&a.titleHalign?a.titleHalign:h.titleHalign;e.__registerTitle({text:c,halign:v})}}return c}return null},_renderSections:(e,i,s,a,r)=>{if(!s||0==s.length)return new t.Rectangle(0,0,0,0);var o=e.getOptions();o.symbolWidth||o.symbolHeight?(o.symbolWidth?o.symbolHeight||(o.symbolHeight=o.symbolWidth):o.symbolWidth=o.symbolHeight,o.symbolWidth=parseInt(o.symbolWidth),o.symbolHeight=parseInt(o.symbolHeight)):(o.symbolWidth=g._DEFAULT_SYMBOL_SIZE,o.symbolHeight=g._DEFAULT_SYMBOL_SIZE);for(var h,d=l.getGapSize(e,o.layout.sectionGapHeight),c=l.getGapSize(e,o.layout.titleGapHeight),u=l.getGapSize(e,o.layout.sectionGapWidth),p=g._getRowHeight(e),_="vertical"!=o.orientation,v=null,y=a.clone(),b=0;b<s.length;b++){var m=r.concat([b]),f=n(s[b],e)?c:d;_?(h=g._renderHorizontalSection(e,i,s[b],y,p)).w>y.w?(y.w<a.w&&(a.y+=h.h+f,a.h-=h.h+f),h=h.w<=a.w?g._renderHorizontalSection(e,i,s[b],a,p):g._renderVerticalSection(e,i,s[b],a,p,m,!0),a.y+=h.h+f,a.h-=h.h+f,y=a.clone()):(y.w-=h.w+u,t.Agent.isRightToLeft(e.getCtx())||(y.x+=h.w+u)):(h=g._renderVerticalSection(e,i,s[b],a,p,m,!1),a.y+=h.h+f,a.h-=h.h+f),v=v?v.getUnion(h):h}return v},_createButton:(e,i,s,n,r,l,o,h,d,c,u)=>{var p=t.ToolkitUtils.getIconStyle(e,n[r]),_=new t.IconButton(e,"borderless",{style:p,size:g._BUTTON_SIZE},null,d,c,u);_.setTranslate(l,o);var v=a.associate([_],i,s,h,null,!1);return _.setAriaRole("button"),v.updateAriaLabel(),_},_renderVerticalSection:(e,i,s,a,r,o,h)=>{if(s){var d,c=e.getOptions(),u=l.getGapSize(e,c.layout.symbolGapWidth),p=l.getGapSize(e,c.layout.rowGap),_=l.getGapSize(e,c.layout.columnGap),v=e.getCtx(),y=t.Agent.isRightToLeft(v),b=null!=s.sections&&s.sections.length>0,m=null!=s.items&&s.items.length>0,f=a.clone();"off"!=c.scrolling&&(f.h=1/0);var C,S="on"===s.collapsible||"boolean"==typeof s.collapsible&&s.collapsible;if(S){var x=y?f.x+f.w-g._BUTTON_SIZE:f.x;if(!c.isLayout){var w=n(s,e),O=w?"closed":"open",E=c.translations[w?"tooltipExpand":"tooltipCollapse"],T=e.getEventManager();C=g._createButton(v,e,s,c._resources,O,x,f.y,E,o,T.onCollapseButtonClick,T),i.addChild(C)}d=new t.Rectangle(x,f.y,g._BUTTON_SIZE,g._BUTTON_SIZE);var D=l.getGapSize(e,c.layout.symbolGapWidth);y||(f.x+=g._BUTTON_SIZE+D),f.w-=g._BUTTON_SIZE+D}var A=g._renderTitle(e,i,s.title,f,s,!S&&o.length<=1,o,C),M=y?f.x+f.w:f.x,I=A?A.getDimensions():new t.Rectangle(M,f.y,0,0),L=d?I.getUnion(d):I;if(!m&&!b||n(s,e))return L;if(L.h>0){var F=l.getGapSize(e,c.layout.titleGapHeight);f.y+=L.h+F,f.h-=L.h+F}if(b){var R=g._renderSections(e,i,s.sections,f,o);L=L.getUnion(R)}if(!m)return L;var G=g._calcColumns(e,f,r,s.items,h),k=G.numCols,H=G.numRows,B=G.width,N=f.y;if(0==H||0==k)return L;var P=H*(r+p)-p,U=Math.min(k*(B+_)-_,f.w),W=new t.Rectangle(y?f.x+f.w-U:f.x,f.y,U,P);if(L=L.getUnion(W),c.isLayout)return L;for(var j=B-c.symbolWidth-u,K=0,z=1,V=s.items.length,Z=0;Z<V;Z++){var Y=s.items[Z];if(g._createLegendItem(e,i,Y,f,j,r,Z),f.y+=r+p,++K===H&&z!==k&&(f.y=N,f.w-=B+_,y||(f.x+=B+_),K=0,z++),K===H)break}return L}},_renderHorizontalSection:(e,i,s,n,a)=>{if(s){var r=e.getOptions(),o=r.symbolWidth,h=l.getGapSize(e,r.layout.symbolGapWidth),d=l.getGapSize(e,r.layout.columnGap),c=l.getGapSize(e,r.layout.titleGapWidth),u=null!=s.items&&s.items.length>0,p=t.Agent.isRightToLeft(e.getCtx()),_=n.clone(),v=g._renderTitle(e,i,s.title,n,s,!1),y=p?n.x+n.w:n.x,b=v?v.getDimensions():new t.Rectangle(y,n.y,0,0);if(!u)return b;b.w>0&&(_.w-=b.w+c,p||(_.x+=b.w+c));var m,f,C,S=[],x=n.w-_.w,w=s.items.length;for(C=0;C<w;C++)m=s.items[C],x+=(f=Math.ceil(t.TextUtils.getTextStringWidth(e.getCtx(),m.text,r.textStyle)))+o+h+d,S.push(f);w>0&&(x-=d);var O,E=new t.Rectangle(p?n.x+n.w-x:n.x,n.y,x,Math.max(a,b.h));if(r.isLayout||x>n.w)return i.removeChild(v),E;if(v){e.getCache().putToCache("horizRowAlign",!0),e.getCache().putToCache("sectionRect",E);var T=v.getDimensions(),D=E.y+E.h/2-T.h/2-T.y;v.setTranslate(0,D)}for(C=0;C<w;C++)m=s.items[C],g._createLegendItem(e,i,m,_,S[C],a,C),O=S[C]+o+h,_.w-=O+d,p||(_.x+=O+d);return e.getCache().putToCache("horizRowAlign",!1),e.getCache().putToCache("sectionRect",null),E}},_calcColumns:(e,i,s,n,a)=>{for(var r=e.getOptions(),o=[],h=0;h<n.length;h++)o.push(n[h].text);var g,d,c,u=t.TextUtils.getMaxTextStringWidth(e.getCtx(),o,r.textStyle),p=r.symbolWidth,_=l.getGapSize(e,r.layout.symbolGapWidth),v=l.getGapSize(e,r.layout.rowGap),y=l.getGapSize(e,r.layout.columnGap),b=Math.ceil(p+_+u);a?(c=Math.min(Math.max(Math.floor((i.w+y)/(b+y)),1),n.length),g=Math.min(Math.floor((i.h+v)/(s+v)),Math.ceil(n.length/c)),c=Math.ceil(n.length/g),g=Math.ceil(n.length/c)):i.h==1/0?(c=1,g=n.length):(g=Math.min(Math.floor((i.h+v)/(s+v)),n.length),c=Math.ceil(n.length/g),g=Math.ceil(n.length/c));var m=(i.w-y*(c-1))/c;return(d=Math.min(b,m))<p?{width:0,numCols:0,numRows:0}:{width:d,numCols:c,numRows:g}},_getRowHeight:e=>{var i=e.getOptions(),s=t.TextUtils.getTextStringHeight(e.getCtx(),i.textStyle),n=i.symbolHeight+l.getGapSize(e,i.layout.symbolGapHeight);return Math.ceil(Math.max(s,n))},_createLegendItem:(e,n,r,o,h,d,c)=>{var u,p=e.getOptions(),_=e.getCtx(),v=t.Agent.isRightToLeft(_),y=p.symbolWidth,b=l.getGapSize(e,p.layout.symbolGapWidth),m=v?o.x+o.w-y:o.x,f=v?o.x+o.w-y-b:o.x+y+b,C=g._createLegendSymbol(e,m,o.y,d,r,c),S=r.text;if(null!=S){var x=p.textStyle;(u=g._createLegendText(n,h,S,x))&&(u.setX(f),t.TextUtils.centerTextVertically(u,o.y+d/2),v&&u.alignRight());var w=e.getCache().getFromCache("sectionRect");if(e.getCache().getFromCache("horizRowAlign")&&w&&"vertical"!=p.orientation){var O=u.getDimensions().h,E=w.y+w.h/2-Math.max(p.symbolHeight,O)/2-o.y;C.setTranslate(0,E),u.setTranslate(0,E)}}n.addChild(C);var T=new t.Rect(_,v?f-h-g._FOCUS_GAP:m-g._FOCUS_GAP,o.y-g._FOCUS_GAP,y+b+h+2*g._FOCUS_GAP,d+2*g._FOCUS_GAP);T.setInvisibleFill();var D=p.hideAndShowBehavior;"none"!=D&&"off"!=D&&T.setCursor("pointer"),n.addChild(T);var A=[T,C];null!=u&&A.push(u);var M=a.associate(A,e,r,null!=u?u.getUntruncatedTextString():null,r.shortDesc,g._isItemDrillable(e,r));s(i(r,e),e)&&(C.setHollow(M.getColor()),C.setStyle().setClassName()),("none"!=D&&"off"!=D||null!=r.shortDesc)&&(T.setAriaRole("img"),M.updateAriaLabel())},_isItemDrillable:(e,t)=>"on"==t.drilling||"off"!=t.drilling&&"on"==e.getOptions().drilling,_createLegendText:(e,i,s,n)=>{var a=new t.OutputText(e.getCtx(),s);return a.setCSSStyle(n),a=t.TextUtils.fitText(a,i,1/0,e)?a:null},_createLegendSymbol:(e,n,a,r,l,o)=>{var h=e.getOptions(),d=e.getCtx(),c=null!=l.type?l.type:l.symbolType;l.markerShape||(l.markerShape=h._markerShape),l.color||(l.color=h._color),l.lineWidth||(l.lineWidth="lineWithMarker"==c?g._DEFAULT_LINE_WIDTH_WITH_MARKER:h._lineWidth);var u,p=h.symbolWidth,_=h.symbolHeight,v=a+r/2,y=n+p/2;if("line"==c)u=g._createLine(d,n,a,p,r,l);else if("lineWithMarker"==c)u=g._createLine(d,n,a,p,r,l),s(i(l,e),e)||u.addChild(g._createMarker(e,y,v,p*g._LINE_MARKER_SIZE_FACTOR,_*g._LINE_MARKER_SIZE_FACTOR,l));else if("image"==c)u=g._createImage(e,n,a,p,_,r,l);else if("_verticalBoxPlot"==c)_=Math.max(4*Math.round(_/4),4),(u=new t.Container(d)).addChild(g._createMarker(e,y,v+_/4,p,_/2,g._getBoxPlotOptions(l,"q2"))),u.addChild(g._createMarker(e,y,v-_/4,p,_/2,g._getBoxPlotOptions(l,"q3")));else if("_horizontalBoxPlot"==c){var b=t.Agent.isRightToLeft(d),m=(p=Math.max(4*Math.round(p/4),4))/4*(b?1:-1);(u=new t.Container(d)).addChild(g._createMarker(e,y+m,v,p/2,_,g._getBoxPlotOptions(l,"q2"))),u.addChild(g._createMarker(e,y-m,v,p/2,_,g._getBoxPlotOptions(l,"q3")))}else u=g._createMarker(e,y,v,p,_,l);return u},_createImage:(e,i,s,n,a,r,l)=>{var o=e.getCtx(),h=s+r/2,g=i+n/2;return new t.ImageMarker(o,g,h,n,a,null,l.source)},_createMarker:(e,i,s,n,a,r)=>{var l,o=e.getCtx(),h=r.markerShape,g=r.symbolType&&"lineWithMarker"==r.symbolType&&r.markerColor?r.markerColor:r.color,d=r.markerStyle||r.markerSvgStyle?r.markerStyle||r.markerSvgStyle:r.style||r.svgStyle,c=r.markerClassName||r.markerSvgClassName?r.markerClassName||r.markerSvgClassName:r.className||r.svgClassName,u=r.pattern;if(u&&"none"!=u?((l=new t.SimpleMarker(o,h,0,0,n,a,null,null,!0)).setFill(new t.PatternFill(u,g,"#FFFFFF")),l.setTranslate(i,s)):(l=new t.SimpleMarker(o,h,i,s,n,a,null,null,!0)).setSolidFill(g),r.borderColor){var p=r._borderWidth?r._borderWidth:1;l.setSolidStroke(r.borderColor,null,p)}return"square"!=h&&"rectangle"!=h||l.setPixelHinting(!0),l.setClassName(c).setStyle(d),l},_createLine:(e,i,s,n,a,r)=>{var l=s+a/2;n=n%2==1?n+1:n;var o,h=new t.Line(e,i,Math.round(l),i+n,Math.round(l)),g=r.lineStyle;"dashed"==g?o={dashArray:"4,2,4"}:"dotted"==g&&(o={dashArray:"2"});var d=new t.Stroke(r.color,1,r.lineWidth,!1,o);return h.setClassName(r.className||r.svgClassName).setStyle(r.style||r.svgStyle),h.setStroke(d),h.setPixelHinting(!0),h},_getBoxPlotOptions:(e,t)=>({markerShape:"rectangle",color:e._boxPlot[t+"Color"],pattern:e._boxPlot["_"+t+"Pattern"],className:e._boxPlot[t+"ClassName"]||e._boxPlot[t+"svgClassName"],style:e._boxPlot[t+"Style"]||e._boxPlot[t+"svgStyle"]})};class d extends t.BaseComponent{constructor(e,t,i){super(e,t,i),this.setId("legend1000"+Math.floor(1e9*Math.random())),this.Defaults=new l(e),this.EventManager=new o(this),this.EventManager.addListeners(this),this._peers=[],this._navigablePeers=[],this._bounds=null,this._titles=[]}static getDefaults(e){return(new l).getDefaults(e)}SetOptions(e){this.getOptionsCache().clearCache(),e?(this.Options=this.Defaults.calcOptions(e),this._transferVisibilityProps(this.Options.sections)):this.Options||(this.Options=this.GetDefaults())}getPreferredSize(e,i,s){this.SetOptions(e),this.getOptions().isLayout=!0;var n=new t.Rectangle(0,0,i,s),a=g.render(this,n);return this.getOptions().isLayout=!1,new t.Dimension(a.w,a.h)}render(e,i,s){this.getCache().clearCache(),this.SetOptions(e),isNaN(i)||isNaN(s)||(this.Width=i,this.Height=s),this.getOptions().isLayout=!1;for(var n=this.getNumChildren(),a=0;a<n;a++){this.getChildAt(a).destroy()}this.removeChildren(),this._peers=[],this._navigablePeers=[],this._bounds=null,this._titles=[],t.Agent.isTouchDevice()||this.EventManager.setKeyboardHandler(new h(this.EventManager,this)),this.UpdateAriaAttributes();var r=new t.Rectangle(0,0,this.Width,this.Height);this._contentDimensions=g.render(this,r);var l=this.getOptions().highlightedCategories;return l&&l.length>0&&this.highlight(l),this.RenderComplete(),this._contentDimensions}highlight(e){this.getOptions().highlightedCategories=e&&e.length>0?e.slice():null,t.CategoryRolloverHandler.highlight(e,this.__getObjects(),!0)}processEvent(e,i){if("categoryHighlight"==e.type&&"dim"==this.getOptions().hoverBehavior){var s=this.__getObjects();this!=i&&this.highlight(e.categories);for(var n=0;n<s.length;n++)if(t.Obj.compareValues(this.getCtx(),s[n].getId(),e.categories)){this.container.scrollIntoView(s[n].getDisplayables()[0]);break}}this==i&&this.dispatchEvent(e)}__registerObject(e){if(e.getDisplayables()[0]instanceof t.IconButton)this._navigablePeers.push(e);else{var i=this.getOptions().hideAndShowBehavior;(null!=e.getDatatip()||e.isDrillable()||"none"!=i&&"off"!=i)&&this._navigablePeers.push(e),this._peers.push(e)}}__getObjects(){return this._peers}__getKeyboardObjects(){return this._navigablePeers}__setBounds(e){this._bounds=e.clone()}__getBounds(){return this._bounds}__registerTitle(e){this._titles.push(e)}__getTitles(){return this._titles}getAutomation(){return new r(this)}getKeyboardFocus(){return null!=this.EventManager?this.EventManager.getFocus():null}setKeyboardFocus(e,i){if(null!=this.EventManager){for(var s=this.__getKeyboardObjects(),n=0;n<s.length;n++)if(t.Obj.compareValues(this.getCtx(),s[n].getId(),e.getId())){this.EventManager.setFocusObj(s[n]),i&&s[n].showKeyboardFocusEffect();break}var a=this.getKeyboardFocus();if(a){var r=a.getDisplayables()[0];r.setAriaProperty("label",a.getAriaLabel()),this.getCtx().setActiveElement(r)}}}getDimensions(e){var i=new t.Rectangle(0,0,this.Width,this.Height);return e&&e!==this?this.ConvertCoordSpaceRect(i,e):i}_transferVisibilityProps(e){if(e&&!(e.length<=0))for(var t=this.getOptions().hiddenCategories,s=0;s<e.length;s++){var n=e[s];n.sections&&this._transferVisibilityProps(n.sections);var a=n.items;if(a&&!(a.length<=0))for(var r=0;r<a.length;r++){var l=a[r],o=i(l,this);"hidden"==l.categoryVisibility&&t.indexOf(o)<0&&t.push(o),l.categoryVisibility=null}}}UpdateAriaAttributes(){if(this.IsParentRoot()){var e=this.getOptions(),i=e.translations,s=e.hideAndShowBehavior;("off"!=s&&"none"!=s||"dim"==e.hoverBehavior)&&(this.getCtx().setAriaRole("application"),this.getCtx().setAriaLabel(t.ResourceUtils.format(i.labelAndValue,[i.labelDataVisualization,t.AriaUtils.processAriaLabel(this.GetComponentDescription())])))}}isNavigable(){return this._navigablePeers.length>0}static getSectionItemsCount(e){var t=0;if(e.items&&(t+=e.items.length),e.sections)for(var i=e.sections,s=0;s<i.length;s++)t+=d.getSectionItemsCount(i[s]);return t}}e.Legend=d,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=ojlegend-toolkit.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojdvt-overview',["exports","ojs/ojdvt-toolkit"],function(t,i){"use strict";class e extends i.BaseComponentDefaults{constructor(){super({alta:{overviewPosition:"below",style:{currentTimeIndicatorColor:"#c000d1",handleFillColor:"#ffffff",handleTextureColor:"#b3c6db",leftFilterPanelAlpha:.7,leftFilterPanelColor:"#ffffff",overviewBackgroundColor:"#e6ecf3",rightFilterPanelAlpha:.7,rightFilterPanelColor:"#ffffff",timeAxisBarColor:"#e5e5e5",timeAxisBarAlpha:1,timeIndicatorColor:"#bcc7d2",windowBackgroundAlpha:1,windowBackgroundColor:"#ffffff",windowBorderBottomColor:"#4f4f4f",windowBorderBottomStyle:"solid",windowBorderLeftColor:"#4f4f4f",windowBorderLeftStyle:"solid",windowBorderRightColor:"#4f4f4f",windowBorderRightStyle:"solid",windowBorderTopColor:"#4f4f4f",windowBorderTopStyle:"solid"}}})}}class s extends i.EventManager{constructor(t){super(t.getCtx(),t.processEvent,t),this._overview=t}addListeners(t){i.SvgDocumentUtils.addDragListeners(this._overview,this._onDragStart,this._onDragMove,this._onDragEnd,this)}_onDragStart(t){return i.Agent.isTouchDevice()?this._onTouchDragStart(t):this._onMouseDragStart(t)}_onDragMove(t){return i.Agent.isTouchDevice()?this._onTouchDragMove(t):this._onMouseDragMove(t)}_onDragEnd(t){return i.Agent.isTouchDevice()?this._onTouchDragEnd(t):this._onMouseDragEnd(t)}_getRelativePosition(t,e){return this._stageAbsolutePosition||(this._stageAbsolutePosition=this._context.getStageAbsolutePosition()),new i.Point(t-this._stageAbsolutePosition.x,e-this._stageAbsolutePosition.y)}_onMouseDragStart(t){if(t.button!==i.MouseEvent.RIGHT_CLICK_BUTTON){var e=this._getRelativePosition(t.pageX,t.pageY);return this._overview.beginDragPan(t,e.x,e.y)}return!1}_onMouseDragMove(t){var i=this._getRelativePosition(t.pageX,t.pageY);return this._overview.contDragPan(t,i.x,i.y),!0}_onMouseDragEnd(t){this._overview.endDragPan(),this._stageAbsolutePosition=null}_onTouchDragStart(t){var i=t.touches;if(t.stopPropagation(),1===i.length){var e=this._getRelativePosition(i[0].pageX,i[0].pageY);return t.preventDefault(),this._overview.beginDragPan(t,e.x,e.y)}return!1}_onTouchDragMove(t){var i=t.touches;if(1===i.length){var e=this._getRelativePosition(i[0].pageX,i[0].pageY);this._overview.contDragPan(t,e.x,e.y),t.preventDefault()}t.stopPropagation()}_onTouchDragEnd(t){this._overview.endDragPan(),i.EventManager.consumeEvent(t),this._stageAbsolutePosition=null}}class n{constructor(t){this._view=t}parse(t){return this.ParseRootAttributes(t)}ParseRootAttributes(t){var e={};return e.animationOnClick=t.animationOnClick,null!=t.xMin&&(e.xMin=t.xMin),null!=t.xMax&&(e.xMax=t.xMax),null!=t.x1&&(e.x1=t.x1),null!=t.x2&&(e.x2=t.x2),null!=t.yMin&&(e.yMin=t.yMin),null!=t.yMax&&(e.yMax=t.yMax),null!=t.y1&&(e.y1=t.y1),null!=t.y2&&(e.y2=t.y2),null!=t.currentTime&&(e.currentTime=t.currentTime),e.orientation="horizontal",null!=t.orientation&&(e.orientation=t.orientation),e.featuresOff=t.featuresOff,e.minimumWindowSize=t.minimumWindowSize,e.leftMargin=t.leftMargin,e.rightMargin=t.rightMargin,e.overviewPosition="below",e.selectionMode="none",e.isRtl=i.Agent.isRightToLeft(this._view.getCtx()).toString(),null!=t.rtl&&(e.isRtl=t.rtl.toString()),e}calculateWidth(t,i,e,s,n){var o=n*(i-t),r=s-e;return 0===o||0===r?0:o/r}}const o=5,r=1,a=t=>null!=t._hfc?t._hfc:t.style.handleFillColor,l=t=>null!=t._htc?t._htc:t.style.handleTextureColor,h=(t,i)=>i?null!=t._vhbc?t._vhbc:t.style.vertHandleBackgroundClass:null!=t._hbc?t._hbc:t.style.handleBackgroundClass,d=(t,i)=>i?null!=t._vhs?t._vhs:t.style.vertHandleSize:null!=t._hs?t._hs:t.style.handleSize,g=t=>null!=t._btc?t._btc:t.style.borderTopColor,u=t=>null!=t._bts?t._bts:t.style.borderTopStyle,_=t=>null!=t._wbc?t._wbc:t.style.windowBackgroundColor,w=t=>t.style.windowBackgroundAlpha,c=t=>null!=t._wbts?t._wbts:t.style.windowBorderTopStyle,m=t=>null!=t._wbrs?t._wbrs:t.style.windowBorderRightStyle,v=t=>null!=t._wbbs?t._wbbs:t.style.windowBorderBottomStyle,P=t=>null!=t._wbls?t._wbls:t.style.windowBorderLeftStyle,S=t=>null!=t._wbtc?t._wbtc:t.style.windowBorderTopColor,p=t=>null!=t._wbrc?t._wbrc:t.style.windowBorderRightColor,f=t=>null!=t._wbbc?t._wbbc:t.style.windowBorderBottomColor,C=t=>null!=t._wblc?t._wblc:t.style.windowBorderLeftColor,x=t=>null!=t._obc?t._obc:t.style.overviewBackgroundColor,M=t=>null!=t._ctic?t._ctic:t.style.currentTimeIndicatorColor,T=t=>null!=t._tabc?t._tabc:t.style.timeAxisBarColor,H=t=>null!=t._tabo?t._tabo:t.style.timeAxisBarAlpha,W=t=>null!=t._tic?t._tic:t.style.timeIndicatorColor,b=t=>t.style.leftFilterPanelColor,y=t=>t.style.leftFilterPanelAlpha,X=t=>t.style.rightFilterPanelColor,D=t=>t.style.rightFilterPanelAlpha,L={supportsTouch:()=>i.Agent.isTouchDevice(),getDatePosition:(t,i,e,s)=>{var n=(e-t)*s,o=i-t;return 0==n||0==o?0:n/o},getPositionDate:(t,i,e,s)=>{var n=e*(i-t);return 0===n||0===s?t:n/s+t}},B={renderOverview:t=>{t.isBackgroundRendered()&&B._renderBackground(t);var i=null!=t._callback||null!=t._callbackObj;i&&B._renderSlidingWindow(t),B._renderTimeAxis(t),B._parseFilledTimeRanges(t),B._updateCurrentTime(t),t.renderData(t.Width,t.Height),i&&(B._createBorderAroundSlidingWindow(t),B._updateSlidingWindow(t))},_renderBackground:t=>{var e=new i.Rect(t.getCtx(),0,0,t.Width,t.Height,"bg");e.setSolidFill(t._overviewBackgroundColor),e.setPixelHinting(!0),t.addChild(e)},_renderSlidingWindow:t=>{var e=t.Width,s=t.Height,n=new i.Rect(t.getCtx(),0,0,e,s,"window");if(n.setSolidFill(t._windowBackgroundColor,t._windowBackgroundAlpha),n.setPixelHinting(!0),!t.isFeatureOff("zoom")){var o,r=t.getHandleSize(),a=t.getHandleStart(),l=t.getGrippySize();if(t.isVerticalScrollingEnabled()){var h=t.getSlidingWindowWidth(),d=i.PathUtils.moveTo(0,0)+i.PathUtils.quadTo(3,6,8,8)+i.PathUtils.lineTo(28,8)+i.PathUtils.quadTo(33,6,36,0);i.PathUtils.closePath();var g=i.PathUtils.moveTo(0,0)+i.PathUtils.quadTo(3,-6,8,-8)+i.PathUtils.lineTo(28,-8)+i.PathUtils.quadTo(33,-6,36,0);i.PathUtils.closePath();var u=new i.Rect(t.getCtx(),0,0,h,r,"thb"),_=new i.Rect(t.getCtx(),0,0,h,r,"bhb");if(o="row-resize",t._vertHandleBackgroundClass)var w=B._createGrippyImage(t,h,l,!0),c=B._createGrippyImage(t,h,l,!0);else w=B._createGrippy(t,!0),c=B._createGrippy(t,!0);u.setSolidFill(t._windowBackgroundColor,0),_.setSolidFill(t._windowBackgroundColor,0),u.setPixelHinting(!0),_.setPixelHinting(!0);var m=new i.Path(t.getCtx(),d,"th"),v=new i.Path(t.getCtx(),g,"bh");m.setSolidFill(t._handleFillColor),m.setSolidStroke(t._handleFillColor),v.setSolidFill(t._handleFillColor),v.setSolidStroke(t._handleFillColor),t._windowBackgroundColor===t._handleFillColor&&(m.setPixelHinting(!0),v.setPixelHinting(!0)),u.setCursor(o),_.setCursor(o),m.setCursor(o),v.setCursor(o),w.setCursor(o),c.setCursor(o),n.addChild(u),t._windowTopHandleBackground=u,n.addChild(m),t._windowTopHandle=m,n.addChild(w),t._windowTopGrippy=w,n.addChild(_),t._windowBottomHandleBackground=_,n.addChild(v),t._windowBottomHandle=v,n.addChild(c),t._windowBottomGrippy=c}if(t.isHorizontalScrollingEnabled()){var P=t.getSlidingWindowHeight(),S=i.PathUtils.moveTo(0,0)+i.PathUtils.quadTo(6,3,8,8)+i.PathUtils.lineTo(8,28)+i.PathUtils.quadTo(6,33,0,36);i.PathUtils.closePath();var p=i.PathUtils.moveTo(0,0)+i.PathUtils.quadTo(-6,3,-8,8)+i.PathUtils.lineTo(-8,28)+i.PathUtils.quadTo(-6,33,0,36);i.PathUtils.closePath();var f=new i.Rect(t.getCtx(),0-a,0,r,P,"lhb"),C=new i.Rect(t.getCtx(),a,0,r,P,"rhb");if(o="col-resize",t._horHandleBackgroundClass)var x=B._createGrippyImage(t,l,P,!1),M=B._createGrippyImage(t,l,P,!1);else x=B._createGrippy(t,!1),M=B._createGrippy(t,!1);f.setSolidFill(t._windowBackgroundColor,0),C.setSolidFill(t._windowBackgroundColor,0),f.setPixelHinting(!0),C.setPixelHinting(!0);var T=new i.Path(t.getCtx(),S,"lh"),H=new i.Path(t.getCtx(),p,"rh");T.setSolidFill(t._handleFillColor),T.setSolidStroke(t._handleFillColor),H.setSolidFill(t._handleFillColor),H.setSolidStroke(t._handleFillColor),t._windowBackgroundColor===t._handleFillColor&&(T.setPixelHinting(!0),H.setPixelHinting(!0)),f.setCursor(o),C.setCursor(o),T.setCursor(o),H.setCursor(o),x.setCursor(o),M.setCursor(o),n.addChild(f),t._windowLeftHandleBackground=f,n.addChild(T),t._windowLeftHandle=T,n.addChild(x),t._windowLeftGrippy=x,n.addChild(C),t._windowRightHandleBackground=C,n.addChild(H),t._windowRightHandle=H,n.addChild(M),t._windowRightGrippy=M}}n.setCursor("move"),t.addChild(n),B._renderTimeAxisTopBar(t),B._renderLeftAndRightFilters(t,a)},_createGrippyImage:(t,e,s,n)=>{var o,r=t.getCtx();if(n){var a=s/2,l=i.ToolkitUtils.getIconStyle(r,t._vertHandleBackgroundClass);(o=i.OutputText.createIcon(r,{style:l,size:t._vertHandleSize,pos:{x:0,y:a}})).setId("vgrpy")}else{var h=e/2,d=i.ToolkitUtils.getIconStyle(r,t._horHandleBackgroundClass);(o=i.OutputText.createIcon(r,{style:d,size:t._horHandleSize,pos:{x:h,y:0}})).setId("hgrpy")}o.setMouseEnabled(!1);var g=new i.Container(r);return g.addChild(o),g},_createGrippy:(t,e)=>{var s=t._handleTextureColor;if(e){for(var n=new i.Container(t.getCtx(),"g","vgrpy"),o=8,r=3,a=0;a<9;a++){var l=new i.Line(t.getCtx(),o+2*a,r,o+2*a+1,r,"dot1"+a);l.setSolidStroke(s),n.addChild(l),r+=2,(l=new i.Line(t.getCtx(),o+1+2*a,r,o+1+2*a+1,r,"dot2"+a)).setSolidStroke(s),n.addChild(l),r+=2,(l=new i.Line(t.getCtx(),o+2*a,r,o+2*a+1,r,"dot3"+a)).setSolidStroke(s),n.addChild(l),r=3}(l=new i.Line(t.getCtx(),o+18,r,o+18+1,r,"dot4")).setSolidStroke(s),n.addChild(l),r+=4,(l=new i.Line(t.getCtx(),o+18,r,o+18+1,r,"dot5")).setSolidStroke(s),n.addChild(l)}else{for(n=new i.Container(t.getCtx(),"g","hgrpy"),o=3,r=8,a=0;a<9;a++)(l=new i.Line(t.getCtx(),o,r+2*a,o,r+2*a+1,"dot1"+a)).setSolidStroke(s),n.addChild(l),o+=2,(l=new i.Line(t.getCtx(),o,r+1+2*a,o,r+1+2*a+1,"dot2"+a)).setSolidStroke(s),n.addChild(l),o+=2,(l=new i.Line(t.getCtx(),o,r+2*a,o,r+2*a+1,"dot3"+a)).setSolidStroke(s),n.addChild(l),o=3;(l=new i.Line(t.getCtx(),o,r+18,o,r+18+1,"dot4")).setSolidStroke(s),n.addChild(l),o+=4,(l=new i.Line(t.getCtx(),o,r+18,o,r+18+1,"dot5")).setSolidStroke(s),n.addChild(l)}return n.setPixelHinting(!0),n},_createBorderAroundSlidingWindow:t=>{var e=t.Width,s=t.Height,n=t.getSlidingWindow(),o=r/2;if(t.isVertical())var a=n.getY(),l=a+o,h=a+n.getHeight(),d=h-o,g=0,u=o,_=e,w=_-o,c=new i.Line(t.getCtx(),g,l,e,l,"lh"),m=new i.Line(t.getCtx(),g,d,e,d,"rh"),v=new i.Line(t.getCtx(),u,0,u,a,"ltb"),P=new i.Line(t.getCtx(),u,h,u,s,"rtb"),S=new i.Line(t.getCtx(),w,a,w,h,"bb"),p=new i.Line(t.getCtx(),u,a,u,h,"tb");else l=(a=0)+o,d=(h=s)-o,u=(g=n.getX())+o,w=(_=g+n.getWidth())-o,c=new i.Line(t.getCtx(),u,a,u,h,"lh"),m=new i.Line(t.getCtx(),w,a,w,h,"rh"),v=new i.Line(t.getCtx(),0,l,g+1,l,"ltb"),P=new i.Line(t.getCtx(),_-1,l,e,l,"rtb"),S=new i.Line(t.getCtx(),g,d,_,d,"bb"),p=new i.Line(t.getCtx(),g,l,_,l,"tb");c.setPixelHinting(!0),m.setPixelHinting(!0),v.setPixelHinting(!0),P.setPixelHinting(!0),S.setPixelHinting(!0),p.setPixelHinting(!0),"none"!==t._windowBorderLeftStyle&&c.setSolidStroke(t._windowBorderLeftColor),t.addChild(c),t._leftHandle=c,"none"!==t._windowBorderRightStyle&&m.setSolidStroke(t._windowBorderRightColor),t.addChild(m),t._rightHandle=m,"none"!==t._borderTopStyle&&t._borderTopColor&&(v.setSolidStroke(t._borderTopColor),P.setSolidStroke(t._borderTopColor)),t.addChild(v),t.addChild(P),"none"!==t._windowBorderBottomStyle&&S.setSolidStroke(t._windowBorderBottomColor),t.addChild(S),"none"!==t._windowBorderTopStyle&&p.setSolidStroke(t._windowBorderTopColor),t.addChild(p)},_updateBorderAroundSlidingWindow:t=>{var i=t.getSlidingWindow(),e=r/2,s=t.getLeftHandle(),n=t.getRightHandle(),o=t.getLeftTopBar(),a=t.getRightTopBar(),l=t.getBottomBar(),h=t.getTopBar();if(t.isVertical()){if(t.isHorizontalScrollingEnabled()){var d=i.getWidth(),g=t.getSlidingWindowPosX(i),u=g+e,_=g+d-e;t.setLinePosX(s,u,_),t.setLinePosX(n,u,_),t.setLinePosX(h,u,u),t.setLinePosX(l,_,_)}if(t.isVerticalScrollingEnabled()){var w=i.getHeight(),c=t.getSlidingWindowPosY(i),m=c+e,v=c+w-e;t.setLinePosY(s,m,m),t.setLinePosY(n,v,v),t.setLinePosY(h,m,v),t.setLinePosY(l,m,v)}}else t.isHorizontalScrollingEnabled()&&(d=i.getWidth(),u=(g=t.getSlidingWindowPosX(i))+e,_=g+d-e,t.setLinePosX(s,u,u),t.setLinePosX(n,_,_),t.setLinePosX(h,u,_),t.setLinePosX(l,u,_)),t.isVerticalScrollingEnabled()&&(w=i.getHeight(),m=(c=t.getSlidingWindowPosY(i))+e,v=c+w-e,t.setLinePosY(s,m,v),t.setLinePosY(n,m,v),t.setLinePosY(h,m,m),t.setLinePosY(l,v,v));t.setLinePos(o,-1,t.getSlidingWindowPos(i)),t.setLinePos(a,t.getLinePos1(n),-1)},_updateSlidingWindow:t=>{var i=t.getSlidingWindow(),e=t.Width,s=t.Height;if(t.isHorizontalScrollingEnabled()){var n=Math.max(t.getMinimumPositionX(),L.getDatePosition(t._xMin,t._xMax,t._x1,e)),o=Math.max(t.getMinimumPositionX(),L.getDatePosition(t._xMin,t._xMax,t._x2,e)),r=Math.min(t.getMaximumPositionX(),o);t.isRTL()?t.setSlidingWindowPosX(i,e-r):t.setSlidingWindowPosX(i,n),B._setSlidingWindowWidth(t,i,r-n)}else B._setSlidingWindowWidth(t,i,e);if(t.isVerticalScrollingEnabled()){var a=Math.max(t.getMinimumPositionY(),L.getDatePosition(t._yMin,t._yMax,t._y1,s)),l=Math.max(t.getMinimumPositionY(),L.getDatePosition(t._yMin,t._yMax,t._y2,s)),h=Math.min(t.getMaximumPositionY(),l);t.setSlidingWindowPosY(i,a),B._setSlidingWindowHeight(t,i,h-a)}else B._setSlidingWindowHeight(t,i,s);B._updateBorderAroundSlidingWindow(t)},_setSlidingWindowWidth:(t,i,e)=>{if(e=Math.min(t.getMaximumWindowWidth(),Math.max(t.getMinimumWindowWidth(),e)),i.setWidth(e),t.isLeftAndRightFilterRendered()){var s=t.getSlidingWindowPosX(i)+e,n=t.getRightBackground();if(n.setX(s),n.setWidth(Math.max(0,t.Width-s)),L.supportsTouch()&&!t.isFeatureOff("zoom"))t.getRightBackgroundHandle().setX(s)}if(!t.isFeatureOff("zoom")){if(t.isHorizontalScrollingEnabled()){var o=t._windowRightHandleBackground,r=t._windowRightHandle,a=t._windowRightGrippy;r.setTranslateX(e),o.setTranslateX(e-t.getHandleSize()),a.setTranslateX(e-t.getGrippySize())}if(t.isVerticalScrollingEnabled()){var l=(i.getWidth()-36)/2;if(t._vertHandleBackgroundClass)var h=e/2;else h=l;var d=t._windowTopHandleBackground,g=t._windowTopHandle,u=t._windowTopGrippy;g.setTranslateX(l),d.setWidth(e),u.setTranslateX(h);var _=t._windowBottomHandleBackground,w=t._windowBottomHandle,c=t._windowBottomGrippy;w.setTranslateX(l),_.setWidth(e),c.setTranslateX(h)}}},_setSlidingWindowHeight:(t,i,e)=>{if(e=Math.min(t.getMaximumWindowHeight(),Math.max(t.getMinimumWindowHeight(),e)),i.setHeight(e),!t.isFeatureOff("zoom")){if(t.isHorizontalScrollingEnabled()){var s=(e-36)/2;if(t._horHandleBackgroundClass)var n=e/2;else n=s;var o=t._windowLeftHandleBackground,r=t._windowLeftHandle,a=t._windowLeftGrippy;r.setTranslateY(s),o.setHeight(e),a.setTranslateY(n);var l=t._windowRightHandleBackground,h=t._windowRightHandle,d=t._windowRightGrippy;h.setTranslateY(s),l.setHeight(e),d.setTranslateY(n)}if(t.isVerticalScrollingEnabled()){var g=t._windowBottomHandleBackground,u=t._windowBottomHandle,_=t._windowBottomGrippy;u.setTranslateY(e),g.setTranslateY(e-t.getHandleSize()),_.setTranslateY(e-t.getGrippySize())}}},_renderTimeAxisTopBar:t=>{var e=t.Width,s=t.Height;if(t.isVertical())if(t.isRTL())var n=new i.Line(t.getCtx(),t.getTimeAxisWidth(),0,t.getTimeAxisWidth(),s,"tab");else n=new i.Line(t.getCtx(),e-t.getTimeAxisWidth(),0,e-t.getTimeAxisWidth(),s,"tab");else n=t.isOverviewAbove()?new i.Line(t.getCtx(),0,t.getTimeAxisHeight(),e,t.getTimeAxisHeight(),"tab"):new i.Line(t.getCtx(),0,s-t.getTimeAxisHeight(),e,s-t.getTimeAxisHeight(),"tab");n.setSolidStroke(t._timeAxisBarColor,t._timeAxisBarOpacity),n.setPixelHinting(!0),t._timeAxisTopBar=n,t.addChild(n)},_renderLeftAndRightFilters:(t,e)=>{var s=t.Width,n=t.Height;if(t.isLeftAndRightFilterRendered()){if(t.isVertical())var o=new i.Rect(t.getCtx(),0,0,s,0,"lbg"),r=new i.Rect(t.getCtx(),0,0,s,0,"rbg");else o=new i.Rect(t.getCtx(),0,0,0,n,"lbg"),r=new i.Rect(t.getCtx(),0,0,0,n,"rbg");if(o.setSolidFill(t._leftFilterPanelColor,t._leftFilterPanelAlpha),t.addChild(o),r.setSolidFill(t._rightFilterPanelColor,t._rightFilterPanelAlpha),t.addChild(r),L.supportsTouch()&&null!=e){if(t.isVertical())var a=new i.Rect(t.getCtx(),0,0,s,e,"lbgrh"),l=new i.Rect(t.getCtx(),0,0,s,e,"rbgrh");else a=new i.Rect(t.getCtx(),0,0,e,n,"lbgrh"),l=new i.Rect(t.getCtx(),0,0,e,n,"rbgrh");a.setSolidFill(t._leftFilterPanelColor,0),t.addChild(a),l.setSolidFill(t._rightFilterPanelColor,0),t.addChild(l)}}},_renderTimeAxis:t=>{if(null!=t._ticks)for(var i=t.Width,e=t.Height,s=t.isVertical(),n=t.getOverviewSize(),r=0;r<t._ticks.length;r++){var a=t._ticks[r],l=parseInt(a.time,10);if(s)var h=t.getDateYPosition(l);else h=t.getDateXPosition(l);var d=a.label,g=0;if(r+1<t._ticks.length){var u=parseInt(t._ticks[r+1].time,10);if(s)var _=t.getDateYPosition(u);else _=t.getDateXPosition(u);g=_-h}else g=n-h;t.isHorizontalRTL()&&(h=n-h),s&&(g=i),g-=2*o,B._addTick(t,h,i,e,"tick"+r),B._addLabel(t,h,d,e,g,"label"+r,t._labelStyle)}},_addTick:(t,e,s,n,o)=>{if(t.isVertical())var r=new i.Line(t.getCtx(),0,e,s,e,o);else r=new i.Line(t.getCtx(),e,0,e,n,o);var a=new i.Stroke(t._timeIndicatorColor,1,1,!1,{dashArray:"3"});r.setStroke(a),r.setPixelHinting(!0),t.addChild(r)},_addLabel:(t,e,s,n,r,a,l)=>{if(t.isVertical()){var h=new i.OutputText(t.getCtx(),s,4,e,a);if(h.setCSSStyle(l),t.isRTL()){var d=h.getDimensions();h.setX(Math.max(4,t.Width-d.w-4))}}else{if(t.isOverviewAbove())var g=2;else g=n-t.getTimeAxisHeight()+2;var u=o;(h=new i.OutputText(t.getCtx(),s,e+u,g,a)).setCSSStyle(l),t.isHorizontalRTL()&&(d=h.getDimensions(),h.setX(e-Math.min(d.w,r)-u))}i.TextUtils.fitText(h,r,1/0,t),h._rawText=h.getUntruncatedTextString()},_parseFilledTimeRanges:t=>{if(null!=t._formattedTimeRanges)for(var i=0;i<t._formattedTimeRanges.length;i++){var e=t._formattedTimeRanges[i];B._addFilledTimeRange(t,e,t.Width,t.Height)}},_addFilledTimeRange:(t,e,s,n)=>{var o=parseInt(e.rs,10),r=parseInt(e.re,10);if(null!=o&&null!=r){var a=e.c,l=t.getOverviewSize();if(t.isVertical())h=t.getDateYPosition(o),d=t.getDateYPosition(r);else var h=t.getDateXPosition(o),d=t.getDateXPosition(r);var g,u=d-h;if(t.isHorizontalRTL()&&(h=l-h-u),t.isVertical())g=new i.Rect(t.getCtx(),0,h,s-t.getTimeAxisWidth(),u,"ftr");else{var _=t.isOverviewAbove()?t.getTimeAxisHeight():0;g=new i.Rect(t.getCtx(),h,_,u,n-t.getTimeAxisHeight(),"ftr")}null!=a&&g.setSolidFill(a,.4),g.setCursor("move"),g.setPixelHinting(!0),t.addChild(g)}},_updateCurrentTime:t=>{var e=t.Width,s=t.Height;if(!(null==t._currentTime||isNaN(t._currentTime)||t._currentTime<t._xMin||t._currentTime>t._xMax)){if(t.isVertical())var n=t.getDateYPosition(t._currentTime),o=new i.Line(t.getCtx(),0,n,e,n,"ocd");else n=t.getDateXPosition(t._currentTime),t.isRTL()&&(n=e-n),o=new i.Line(t.getCtx(),n,0,n,s,"ocd");o.setSolidStroke(t._currentTimeIndicatorColor),o.setPixelHinting(!0),t.addChild(o)}}};class Y extends i.Container{constructor(t,e,n){super(t),this.MIN_WINDOW_SIZE=10,this.DEFAULT_VERTICAL_TIMEAXIS_SIZE=40,this.DEFAULT_HORIZONTAL_TIMEAXIS_SIZE=20,this.HANDLE_PADDING_SIZE=20,this.initDefaults(),this._callback=e,this._callbackObj=n,this._lastChildIndex=6,(null!=this._callback||null!=this._callbackObj)&&(this.EventManager=new s(this,t,e,n),this.EventManager.addListeners(this),L.supportsTouch()?(this.addEvtListener(i.TouchEvent.TOUCHSTART,this.HandleTouchStart,!1,this),this.addEvtListener(i.TouchEvent.TOUCHMOVE,this.HandleTouchMove,!1,this),this.addEvtListener(i.TouchEvent.TOUCHEND,this.HandleTouchEnd,!1,this),this.addEvtListener(i.MouseEvent.CLICK,this.HandleShapeClick,!1,this)):(this.addEvtListener(i.MouseEvent.MOUSEOVER,this.HandleShapeMouseOver,!1,this),this.addEvtListener(i.MouseEvent.MOUSEOUT,this.HandleShapeMouseOut,!1,this),this.addEvtListener(i.MouseEvent.CLICK,this.HandleShapeClick,!1,this)))}initDefaults(){this.Defaults=new e}setViewportRange(t,i,e,s){if(null!=t&&null!=i){var n=this.getDateXPosition(t),o=this.getDateXPosition(i);if(o>n){n<this.getMinimumPositionX()&&(n=this.getMinimumPositionX()),o>this.getMaximumPositionX()&&(o=this.getMaximumPositionX());var r=Math.max(o-n,this.getMinimumWindowWidth()),a=this.getSlidingWindow();this.isRTL()?this.setSlidingWindowPosX(a,this.Width-(n+r)):this.setSlidingWindowPosX(a,n),B._setSlidingWindowWidth(this,a,r)}}if(null!=e&&null!=s){var l=this.getDateYPosition(e),h=this.getDateYPosition(s);if(h>l){l<this.getMinimumPositionY()&&(l=this.getMinimumPositionY()),h>this.getMaximumPositionY()&&(h=this.getMaximumPositionY());var d=Math.max(h-l,this.getMinimumWindowHeight());a=this.getSlidingWindow(),this.setSlidingWindowPosY(a,l),B._setSlidingWindowHeight(this,a,d)}}B._updateBorderAroundSlidingWindow(this)}isFeatureOff(t){return null!=this._featuresOff&&-1!==this._featuresOff.indexOf(t)}isAnimationOnClick(){return"off"!==this._animationOnClick}render(t,i,e){if(null!=i&&null!=e&&(this.Width=i,this.Height=e),null==t){var s=this.getSlidingWindow();if(this._xMin&&this._xMax){var n=this.getSlidingWindowPosX(s);null!=s&&0!==n&&(this._x1=L.getPositionDate(this._xMin,this._xMax,n,this.Width))}this._yMin&&this._yMax&&(n=this.getSlidingWindowPosY(s),null!=s&&0!==n&&(this._y1=L.getPositionDate(this._yMin,this._yMax,n,this.Height))),this.removeChildren()}else{this.SetOptions(t);var o=this.Parse(this.Options);this._applyParsedProperties(o)}B.renderOverview(this)}SetOptions(t){this.Options=this.Defaults.calcOptions(t)}getParser(){return new n(this)}Parse(t){return this.getParser(t).parse(t)}_applyParsedProperties(t){this._xMin=t.xMin,this._xMax=t.xMax,this._x1=t.x1,this._x2=t.x2,this._yMin=t.yMin,this._yMax=t.yMax,this._y1=t.y1,this._y2=t.y2,this._currentTime=t.currentTime,this._animationOnClick=t.animationOnClick,this._leftMargin=Math.max(0,t.leftMargin),this._rightMargin=Math.max(0,t.rightMargin),isNaN(this._leftMargin)&&(this._leftMargin=0),isNaN(this._rightMargin)&&(this._rightMargin=0),this._orientation=t.orientation,this._isRtl=t.isRtl,null!=t.featuresOff&&(this._featuresOff=t.featuresOff.split(" ")),null!=t.minimumWindowSize&&t.minimumWindowSize>0&&(this._minimumWindowSize=t.minimumWindowSize),this._timeAxisInfo=t.timeAxisInfo,null!=t.timeAxisInfo&&(this._ticks=this._timeAxisInfo.ticks),this._formattedTimeRanges=t.formattedTimeRanges,this._borderTopStyle=u(this.Options),this._borderTopColor=g(this.Options),this._windowBackgroundColor=_(this.Options),this._windowBackgroundAlpha=w(this.Options),this._windowBorderTopStyle=c(this.Options),this._windowBorderRightStyle=m(this.Options),this._windowBorderBottomStyle=v(this.Options),this._windowBorderLeftStyle=P(this.Options),this._windowBorderTopColor=S(this.Options),this._windowBorderRightColor=p(this.Options),this._windowBorderBottomColor=f(this.Options),this._windowBorderLeftColor=C(this.Options),this._handleTextureColor=l(this.Options),this._handleFillColor=a(this.Options),this._horHandleBackgroundClass=h(this.Options,!1),this._horHandleSize=d(this.Options,!1),this._vertHandleBackgroundClass=h(this.Options,!0),this._vertHandleSize=d(this.Options,!0),this._overviewBackgroundColor=x(this.Options),this._currentTimeIndicatorColor=M(this.Options),this._timeIndicatorColor=W(this.Options),this._timeAxisBarColor=T(this.Options),this._timeAxisBarOpacity=H(this.Options),this._leftFilterPanelColor=b(this.Options),this._leftFilterPanelAlpha=y(this.Options),this._rightFilterPanelColor=X(this.Options),this._rightFilterPanelAlpha=D(this.Options),this._labelStyle=new i.CSSStyle("font-weight:bold")}getDateXPosition(t){return Math.max(this.getMinimumPositionX(),L.getDatePosition(this._xMin,this._xMax,t,this.getOverviewWidth())+this._leftMargin)}getDateYPosition(t){return Math.max(this.getMinimumPositionY(),L.getDatePosition(this._yMin,this._yMax,t,this.getOverviewHeight()))}getXPositionDate(t){return L.getPositionDate(this._xMin,this._xMax,Math.max(this.getMinimumPositionX()-this._leftMargin,t-this._leftMargin),this.getOverviewWidth())}getYPositionDate(t){return L.getPositionDate(this._yMin,this._yMax,Math.max(this.getMinimumPositionY(),t),this.getOverviewHeight())}isRTL(){return"true"===this._isRtl}isHorizontalRTL(){return this.isRTL()&&!this.isVertical()}isVertical(){return"vertical"===this._orientation}isOverviewAbove(){return"above"===this.Options.overviewPosition}setMargins(t,i){!isNaN(t)&&null!=t&&t>0&&(this._leftMargin=t),!isNaN(i)&&null!=i&&i>0&&(this._rightMargin=i)}getOverviewSize(){return this.isVertical()?this.Height-this._leftMargin-this._rightMargin:this.Width-this._leftMargin-this._rightMargin}getOverviewWidth(){return this.Width-this._leftMargin-this._rightMargin}getOverviewHeight(){return this.Height}getMinimumPositionX(){return this._leftMargin}getMinimumPositionY(){return 0}getMaximumPositionX(){return this.Width-this._rightMargin}getMaximumPositionY(){return this.Height}getMinimumWindowWidth(){return null!=this._minWinSize?this._minWinSize:null!=this._minimumWindowSize?(this._minWinSize=L.getDatePosition(this._xMin,this._xMax,this._xMin+this._minimumWindowSize,this.getOverviewWidth()),this._minWinSize):this.MIN_WINDOW_SIZE}getMinimumWindowHeight(){return null!=this._minWinSize?this._minWinSize:null!=this._minimumWindowSize?(this._minWinSize=L.getDatePosition(this._yMin,this._yMax,this._yMin+this._minimumWindowSize,this.getOverviewHeight()),this._minWinSize):this.MIN_WINDOW_SIZE}getMaximumWindowWidth(){return this.Width}getMaximumWindowHeight(){return this.Height}getGrippySize(){return 10}getHandleStart(){return L.supportsTouch()?this.getHandleSize()/2:0}getHandleSize(){return L.supportsTouch()?30:10}isHandle(t){var i=t.getId();return"lh"===i||"rh"===i||"lhb"===i||"rhb"===i||"th"===i||"bh"===i||"thb"===i||"bhb"===i||"hgrpy"===i||"vgrpy"===i||"lbgrh"===i||"rbgrh"===i||null!=t.getParent()&&("hgrpy"===t.getParent().getId()||"vgrpy"===t.getParent().getId())}isLeftOrRightHandle(t){var i=t.getId();return"lh"===i||"rh"===i||"lhb"===i||"rhb"===i||"hgrpy"===i||"lbgrh"===i||"rbgrh"===i||null!=t.getParent()&&"hgrpy"===t.getParent().getId()}isTopOrBottomHandle(t){var i=t.getId();return"th"===i||"bh"===i||"thb"===i||"bhb"===i||"vgrpy"===i||null!=t.getParent()&&"vgrpy"===t.getParent().getId()}getTimeAxisWidth(){if(null==this._timeAxisInfo)return 0;if(null==this._timeAxisWidth){var t=parseInt(this._timeAxisInfo.width,10);!isNaN(t)&&t<this.Width?this._timeAxisWidth=t:this._timeAxisWidth=this.DEFAULT_VERTICAL_TIMEAXIS_SIZE}return this._timeAxisWidth}getTimeAxisHeight(){if(null==this._timeAxisInfo)return 0;if(null==this._timeAxisHeight){var t=parseInt(this._timeAxisInfo.height,10);!isNaN(t)&&t<this.Height?this._timeAxisHeight=t:this._timeAxisHeight=this.DEFAULT_HORIZONTAL_TIMEAXIS_SIZE}return this._timeAxisHeight}getPageX(t){return L.supportsTouch()&&null!=t.targetTouches?t.targetTouches.length>0?t.targetTouches[0].pageX:null:t.pageX}getPageY(t){return L.supportsTouch()&&null!=t.targetTouches?t.targetTouches.length>0?t.targetTouches[0].pageY:null:t.pageY}isBackgroundRendered(){return!0}isLeftAndRightFilterRendered(){return!1}getSlidingWindow(){return this.getChildAt(1)}getSlidingWindowWidth(){if(this.isHorizontalScrollingEnabled()){var t=Math.max(this.getMinimumPositionX(),L.getDatePosition(this._xMin,this._xMax,this._x1,this.Width));return Math.min(this.getMaximumPositionX(),Math.max(this.getMinimumPositionX(),L.getDatePosition(this._xMin,this._xMax,this._x2,this.Width)))-t}return this.Width}getSlidingWindowHeight(){if(this.isVerticalScrollingEnabled()){var t=Math.max(this.getMinimumPositionY(),L.getDatePosition(this._yMin,this._yMax,this._y1,this.Height));return Math.min(this.getMaximumPositionY(),Math.max(this.getMinimumPositionY(),L.getDatePosition(this._yMin,this._yMax,this._y2,this.Height)))-t}return this.Height}getLeftBackground(){return this.isLeftAndRightFilterRendered()?this.getChildAt(3):null}getRightBackground(){return this.isLeftAndRightFilterRendered()?this.getChildAt(4):null}getLeftBackgroundHandle(){return this.isLeftAndRightFilterRendered()&&!this.isFeatureOff("zoom")?this.getChildAt(5):null}getRightBackgroundHandle(){return this.isLeftAndRightFilterRendered()&&!this.isFeatureOff("zoom")?this.getChildAt(6):null}getLeftHandle(){return this._leftHandle}getRightHandle(){return this._rightHandle}getLeftTopBar(){var t=this._lastChildIndex-2;return this.getChildAt(this.getNumChildren()-t)}getRightTopBar(){var t=this._lastChildIndex-3;return this.getChildAt(this.getNumChildren()-t)}getBottomBar(){var t=this._lastChildIndex-4;return this.getChildAt(this.getNumChildren()-t)}getTopBar(){var t=this._lastChildIndex-5;return this.getChildAt(this.getNumChildren()-t)}setLinePos(t,i,e){this.isVertical()?(-1!==i&&t.setY1(i),-1!==e&&t.setY2(e)):(-1!==i&&t.setX1(i),-1!==e&&t.setX2(e))}setLinePosX(t,i,e){-1!==i&&t.setX1(i),-1!==e&&t.setX2(e)}setLinePosY(t,i,e){-1!==i&&t.setY1(i),-1!==e&&t.setY2(e)}getLinePos1(t){return this.isVertical()?t.getY1():t.getX1()}_findDrawable(t){var i=t.target;if(null!=i){var e=i.getId();if(null==e)return null;if("_border"===e.substr(e.length-7))return this.getChildAfter(i);if("tick"!==e.substr(0,4)&&"ltb"!==e&&"rtb"!==e&&"bb"!==e&&"tab"!==e)return i}return null}isMovable(t){return!("window"!==t.getId()&&"ftr"!==t.getId()&&"sta"!==t.getId()&&!this.isHandle(t))}setRectPos(t,i){this.isVertical()?t.setY(i):t.setX(i)}getRectPos(t){return this.isVertical()?t.getY():t.getX()}getRectSize(t){return this.isVertical()?t.getHeight():t.getWidth()}setRectSize(t,i){this.isVertical()?t.setHeight(i):t.setWidth(i)}getSlidingWindowPos(t){return this.isVertical()?t.getTranslateY():t.getTranslateX()}getSlidingWindowPosX(t){return t.getTranslateX()}getSlidingWindowPosY(t){return t.getTranslateY()}setSlidingWindowPosX(t,i){if(i=Math.max(this.getMinimumPositionX(),i),t.setTranslateX(i),this.isLeftAndRightFilterRendered()){this.getLeftBackground().setWidth(i);var e=i+this.getSlidingWindowSize(t),s=this.getRightBackground();if(s.setX(e),s.setWidth(Math.max(0,this.Width-e)),L.supportsTouch()&&!this.isFeatureOff("zoom")){var n=this.getHandleStart();this.getLeftBackgroundHandle().setX(i-n),this.getRightBackgroundHandle().setX(e)}}}setSlidingWindowPosY(t,i){i=Math.max(this.getMinimumPositionY(),i),t.setTranslateY(i)}getSlidingWindowSize(t){return this.getRectSize(t)}renderData(t,i){}animateSlidingWindow(t,e){var s=0,n=this.getSlidingWindow();if(null!=t&&t!==this.getSlidingWindowPosX(n)||null!=e&&e!==this.getSlidingWindowPosY(n)){var o=this.getLeftHandle(),r=this.getRightHandle(),a=this.getLeftTopBar(),l=this.getRightTopBar(),h=this.getBottomBar(),d=this.getTopBar(),g=!1,u=this.isAnimationOnClick()?new i.Animator(this.getCtx(),.5,0,i.Easing.linear):null;if(this.isVerticalScrollingEnabled()&&null!=e){var _=n.getTranslateY,w=n.setTranslateY,c=o.getY1,m=o.setY1,v=o.getY2,P=o.setY2,S=r.getY1,p=r.setY1,f=r.getY2,C=r.setY2,x=h.getY1,M=h.setY1,T=h.getY2,H=h.setY2,W=d.getY1,b=d.setY1,y=d.getY2,X=d.setY2,D=this.getMinimumPositionY(),B=this.getMaximumPositionY(),Y=n.getHeight();e=Math.max(D,Math.min(B-Y,e)),this.animateProperty(u,n,_,w,e),this.isVertical()?(this.animateProperty(u,o,c,m,e),this.animateProperty(u,o,v,P,e),this.animateProperty(u,r,S,p,e+Y),this.animateProperty(u,r,f,C,e+Y),this.animateProperty(u,h,x,M,e),this.animateProperty(u,d,W,b,e),this.animateProperty(u,h,T,H,e+Y),this.animateProperty(u,d,y,X,e+Y),this.animateProperty(u,a,a.getY2,a.setY2,e+1),this.animateProperty(u,l,l.getY1,l.setY1,e+Y-1)):(this.animateProperty(u,o,c,m,e),this.animateProperty(u,o,v,P,e+Y),this.animateProperty(u,r,S,p,e),this.animateProperty(u,r,f,C,e+Y),this.animateProperty(u,h,x,M,e+Y),this.animateProperty(u,d,W,b,e),this.animateProperty(u,h,T,H,e+Y),this.animateProperty(u,d,y,X,e)),g=!0}if(this.isHorizontalScrollingEnabled()&&null!=t){var E=n.getTranslateX,R=n.setTranslateX,O=o.getX1,A=o.setX1,k=o.getX2,I=o.setX2,F=r.getX1,z=r.setX1,U=r.getX2,N=r.setX2,V=h.getX1,G=h.setX1,Z=h.getX2,K=h.setX2,q=d.getX1,j=d.setX1,J=d.getX2,Q=d.setX2,$=this.getMinimumPositionX(),tt=this.getMaximumPositionX();s=n.getWidth(),t=Math.max($,Math.min(tt-s,t)),this.animateProperty(u,n,E,R,t),this.animateProperty(u,o,O,A,t),this.animateProperty(u,o,k,I,t),this.animateProperty(u,r,F,z,t+s),this.animateProperty(u,r,U,N,t+s),this.isVertical()||(this.animateProperty(u,a,a.getX2,a.setX2,t+1),this.animateProperty(u,l,l.getX1,l.setX1,t+s-1)),this.animateProperty(u,h,V,G,t),this.animateProperty(u,d,q,j,t),this.animateProperty(u,h,Z,K,t+s),this.animateProperty(u,d,J,Q,t+s),g=!0}if(this.isLeftAndRightFilterRendered()){var it=this.getLeftBackground(),et=it.getWidth,st=it.setWidth;this.animateProperty(u,it,et,st,t);var nt=Number(t)+s,ot=this.getRightBackground(),rt=ot.getWidth,at=ot.setWidth,lt=ot.getX,ht=ot.setX;if(this.animateProperty(u,ot,rt,at,this.Width-nt),this.animateProperty(u,ot,lt,ht,nt),L.supportsTouch()&&!this.isFeatureOff("zoom")){var dt=this.getHandleStart(),gt=this.getLeftBackgroundHandle(),ut=gt.getX,_t=gt.setX,wt=this.getRightBackgroundHandle(),ct=wt.getX,mt=wt.setX;this.animateProperty(u,gt,ut,_t,t-dt),this.animateProperty(u,wt,ct,mt,nt)}g=!0}null!=u&&g&&u.play()}}animateProperty(t,e,s,n,o){null!=t?t.addProp(i.Animator.TYPE_NUMBER,e,s,n,o):n.call(e,o)}HandleShapeMouseOver(t){var e=this._findDrawable(t);if(e&&"bg"!==e.getId()&&"ocd"!==e.getId())if("label"===e.getId().substr(0,5)&&(e instanceof i.OutputText||e instanceof i.BackgroundOutputText))e.isTruncated()&&this.getCtx().getTooltipManager().showDatatip(t.pageX,t.pageY,e._rawText,"#000000");else if("window"!==e.getId()&&"ftr"!==e.getId()&&"arr"!==e.getId()&&!this.isHandle(e))return e}HandleShapeMouseOut(t){null==this._moveDrawable&&this.setCursor("default");var i=this._findDrawable(t);return null==i?null:i}HandleShapeClick(t,e,s){t.stopPropagation();var n=this._findDrawable(t);if(!n||"window"===n.getId()||this.isHandle(n))return null;if("bg"===n.getId()||"label"===n.getId().substr(0,5)||"ocd"===n.getId()||"lbg"===n.getId()||"rbg"===n.getId()){null==e&&(e=t.pageX),null==s&&(s=t.pageY);var o=this.getCtx().pageToStageCoords(e,s);o=this.stageToLocal(o);var r,a,l,h,d=this.getSlidingWindow();if(this.isVerticalScrollingEnabled())var g=o.y,u=this.Height,_=g-d.getHeight()/2;if(this.isHorizontalScrollingEnabled())var w=o.x,c=this.Width,m=w-d.getWidth()/2;if(this.animateSlidingWindow(m,_),null!=m){var v=d.getWidth();m=Math.max(this.getMinimumPositionX(),Math.min(m,c-v)),this.isRTL()?(r=this.getXPositionDate(c-(m+v)),a=this.getXPositionDate(c-m)):(r=this.getXPositionDate(m),a=this.getXPositionDate(m+v))}if(null!=_){var P=d.getHeight();_=Math.max(this.getMinimumPositionY(),Math.min(_,u-P)),l=this.getYPositionDate(_),h=this.getYPositionDate(_+P)}var S=i.EventFactory.newOverviewEvent("scrollTime",r,a,l,h);return this.dispatchEvent(S),null}return n}beginDragPan(t,e,s){var n=this._findDrawable(t);if(null!=n&&this.isMovable(n)){if("ftr"!==n.getId()&&"sta"!==n.getId()||(n=this.getSlidingWindow()),this._initX=e,this._initY=s,this.isHandle(n)){var o=this.getSlidingWindow();"hgrpy"!==n.getParent().getId()&&"vgrpy"!==n.getParent().getId()||(n=n.getParent());var r=n.getId();"hgrpy"!==r&&"vgrpy"!==r||(r=(n=o.getChildBefore(n)).getId()),"lh"!==r&&"rh"!==r&&"th"!==r&&"bh"!==r||(r=(n=o.getChildBefore(n)).getId()),"lbgrh"===r&&(n=o.getChildAt(0)),"rbgrh"===r&&(n=o.getChildAt(o.getNumChildren()-3)),this.isLeftOrRightHandle(n)?(this._isHorizontalResize=!0,this.isRTL()?(this._oldEndPosX=this.Width-o.getX(),this._oldStartPosX=this._oldEndPosX-o.getWidth()):(this._oldStartPosX=o.getX(),this._oldEndPosX=this._oldStartPosX+o.getWidth()),L.supportsTouch()||(n.setX(0-this.HANDLE_PADDING_SIZE),n.setWidth(2*(n.getWidth()+this.HANDLE_PADDING_SIZE)))):(this._isHorizontalResize=!1,this._oldStartPosY=o.getY(),this._oldEndPosY=this._oldStartPosY+o.getHeight(),L.supportsTouch()||(n.setY(0-this.HANDLE_PADDING_SIZE),n.setHeight(2*(n.getHeight()+this.HANDLE_PADDING_SIZE)))),this.overrideCursors(n.getCursor())}this._moveDrawable=n;var a=i.EventFactory.newOverviewEvent("dropCallback");return this.dispatchEvent(a),!0}return!1}overrideCursors(t){var i=this.getSlidingWindow();if(null!=i&&i.setCursor(t),this.isLeftAndRightFilterRendered()){var e=this.getLeftBackground(),s=this.getRightBackground();null!=e&&null!=s&&(e.setCursor(t),s.setCursor(t))}}resetCursors(){var t=this.getSlidingWindow();if(null!=t&&t.setCursor("move"),this.isLeftAndRightFilterRendered()){var i=this.getLeftBackground(),e=this.getRightBackground();null!=i&&null!=e&&(i.setCursor("default"),e.setCursor("default"))}}endDragPan(){null!=this._moveDrawable&&this._isDragPanning&&("window"===this._moveDrawable.getId()?this.handleWindowDrag("scrollEnd"):this.isHandle(this._moveDrawable)&&(this.finishHandleDrag(0,0),L.supportsTouch()||(this.isTopOrBottomHandle(this._moveDrawable)?(this._moveDrawable.setY(0),this._moveDrawable.setHeight(this.getHandleSize())):this.isLeftOrRightHandle(this._moveDrawable)&&(this._moveDrawable.setX(0),this._moveDrawable.setWidth(this.getHandleSize()))),this.resetCursors()),this._isDragPanning=!1,this._moveDrawable=null,this._initX=-1)}contDragPan(t,i,e){if(null!=this._moveDrawable&&-1!==this._initX){this._isDragPanning=!0;var s=i-this._initX,n=e-this._initY;this._initX=i,this._initY=e,"window"===this._moveDrawable.getId()?this.handleWindowDrag("scrollPos",s,n):"lh"===this._moveDrawable.getId()||"lhb"===this._moveDrawable.getId()?this.handleLeftOrRightHandleDragPositioning(t,s,!0):"rh"===this._moveDrawable.getId()||"rhb"===this._moveDrawable.getId()?this.handleLeftOrRightHandleDragPositioning(t,s,!1):"th"===this._moveDrawable.getId()||"thb"===this._moveDrawable.getId()?this.handleTopOrBottomHandleDragPositioning(t,n,!0):"bh"!==this._moveDrawable.getId()&&"bhb"!==this._moveDrawable.getId()||this.handleTopOrBottomHandleDragPositioning(t,n,!1)}}HandleTouchStart(t){var i=t.touches;this._touchStartX=i[0].pageX,this._touchStartY=i[0].pageY,2===i.length&&(t.preventDefault(),this._touchStartX2=i[1].pageX,this._touchStartY2=i[1].pageY,Math.abs(this._touchStartY-this._touchStartY2)<20?this._counter=0:(this._touchStartX=null,this._touchStartY=null,this._touchStartX2=null,this._touchStartY2=null))}HandleTouchMove(t){t.preventDefault();var i=t.touches;if(null!=this._touchStartX2&&null!=this._touchStartY2){if(this._counter<50)return void this._counter++;var e=i[1].pageX-this._touchStartX2;this.handleRightHandleDragPositioning(null,e,0),this._touchStartX2=i[1].pageX,this._counter=0}else{var s=Math.abs(this._touchStartX-i[0].pageX),n=Math.abs(this._touchStartY-i[0].pageY);(s>3||n>3)&&(this._touchStartX=null,this._touchStartY=null)}}HandleTouchEnd(t){null!=this._touchStartX2&&null!=this._touchStartY2?this.finishHandleDrag(0,0):null!=this._touchStartX&&null!=this._touchStartY&&this.HandleShapeClick(t,this._touchStartX,this._touchStartY),this._touchStartX=null,this._touchStartY=null,this._touchStartX2=null,this._touchStartY2=null}stopDragAction(){this.endDragPan()}handleWindowDrag(t,i,e){var s,n,o,r,a=this.getSlidingWindow(),l=!1,h=this.getSlidingWindowPosX(a),d=this.getSlidingWindowPosY(a),g=a.getWidth(),u=a.getHeight();if("scrollPos"===t){if(this.isHorizontalScrollingEnabled()&&0!==i){var _=this.getMinimumPositionX(),w=this.getMaximumPositionX();h+i<=_?this.setSlidingWindowPosX(a,_):h+g+i>=w?this.setSlidingWindowPosX(a,w-g):this.setSlidingWindowPosX(a,h+i);var c=this.getSlidingWindowPosX(a);c!==h&&(h=c,l=!0)}if(this.isVerticalScrollingEnabled()&&0!==e){var m=this.getMinimumPositionY(),v=this.getMaximumPositionY();d+e<=m?this.setSlidingWindowPosY(a,m):d+u+e>=v?this.setSlidingWindowPosY(a,v-u):this.setSlidingWindowPosY(a,d+e);var P=this.getSlidingWindowPosY(a);P!==d&&(d=P,l=!0)}l&&B._updateBorderAroundSlidingWindow(this)}(l||"scrollEnd"===t)&&(this.isHorizontalScrollingEnabled()&&(this.isRTL()?(s=this.getXPositionDate(this.Width-(h+g)),n=this.getXPositionDate(this.Width-h)):(s=this.getXPositionDate(h),n=this.getXPositionDate(h+g))),this.isVerticalScrollingEnabled()&&(o=this.getYPositionDate(d),r=this.getYPositionDate(d+u)),this.fireScrollEvent(t,s,n,o,r))}fireScrollEvent(t,e,s,n,o){var r,a,l,h;this.isHorizontalScrollingEnabled()&&(r=e,a=s),this.isVerticalScrollingEnabled()&&(l=n,h=o);var d=i.EventFactory.newOverviewEvent(t,r,a,l,h);this.dispatchEvent(d)}handleLeftOrRightHandleDragPositioning(t,e,s){if(0!==e){var n=this.getSlidingWindow(),o=this.getSlidingWindowPosX(n),r=n.getWidth();if(s){if(r-e<=this.getMinimumWindowWidth())return;if(o+e<=this.getMinimumPositionX())return;var a=this.getCtx().pageToStageCoords(this.getPageX(t),this.getPageY(t)).x;if(a=this.stageToLocal(a),e>0&&a<=o||e<0&&a>=o)return;this.setSlidingWindowPosX(n,o+e),B._setSlidingWindowWidth(this,n,r-e)}else{if(r+e<=this.getMinimumWindowWidth())return;if(o+r+e>=this.getMaximumPositionX())return;if(a=this.getCtx().pageToStageCoords(this.getPageX(t),this.getPageY(t)).x,a=this.stageToLocal(a),e>0&&a<=o+r||e<0&&a>=o+r)return;B._setSlidingWindowWidth(this,n,r+e)}if(B._updateBorderAroundSlidingWindow(this),this.isRangeChangingSupported()){var l,h;this.isRTL()?(l=this.getXPositionDate(this.Width-(this.getSlidingWindowPosX(n)+n.getWidth())),h=this.getXPositionDate(this.Width-this.getSlidingWindowPosX(n))):(l=this.getXPositionDate(this.getSlidingWindowPosX(n)),h=this.getXPositionDate(this.getSlidingWindowPosX(n)+n.getWidth()));var d=i.EventFactory.newOverviewEvent("rangeChanging",l,h);this.dispatchEvent(d)}}}handleTopOrBottomHandleDragPositioning(t,e,s){if(0!==e){var n=this.getSlidingWindow(),o=this.getSlidingWindowPosY(n),r=n.getHeight();if(s){if(r-e<=this.getMinimumWindowHeight())return;if(o+e<=this.getMinimumPositionY())return;var a=this.getCtx().pageToStageCoords(this.getPageX(t),this.getPageY(t)).y;if(a=this.stageToLocal(a),e>0&&a<=o||e<0&&a>=o)return;this.setSlidingWindowPosY(n,o+e),B._setSlidingWindowHeight(this,n,r-e)}else{if(r+e<=this.getMinimumWindowHeight())return;if(o+r+e>=this.getMaximumPositionY())return;if(a=this.getCtx().pageToStageCoords(this.getPageX(t),this.getPageY(t)).y,a=this.stageToLocal(a),e>0&&a<=o+r||e<0&&a>=o+r)return;B._setSlidingWindowHeight(this,n,r+e)}if(B._updateBorderAroundSlidingWindow(this),this.isRangeChangingSupported()){var l=this.getYPositionDate(this.getSlidingWindowPosY(n)),h=this.getYPositionDate(this.getSlidingWindowPosY(n)+n.getHeight()),d=i.EventFactory.newOverviewEvent("rangeChanging",void 0,void 0,l,h);this.dispatchEvent(d)}}}isHorizontalScrollingEnabled(){return null!=this._xMin&&null!=this._xMax}isVerticalScrollingEnabled(){return null!=this._yMin&&null!=this._yMax}isRangeChangingSupported(){return!0}finishHandleDrag(t,e){var s,n=this.getSlidingWindow();if(this._isHorizontalResize){var o=this.getXPositionDate(this._oldStartPosX),r=this.getXPositionDate(this._oldEndPosX);if(this.isRTL())var a=this.getXPositionDate(this.Width-(this.getSlidingWindowPosX(n)+n.getWidth())),l=this.getXPositionDate(this.Width-this.getSlidingWindowPosX(n));else a=this.getXPositionDate(this.getSlidingWindowPosX(n)),l=this.getXPositionDate(this.getSlidingWindowPosX(n)+n.getWidth());s=i.EventFactory.newOverviewEvent("rangeChange",a,l,void 0,void 0,o,r)}else{var h=this.getYPositionDate(this._oldStartPosY),d=this.getYPositionDate(this._oldEndPosY),g=this.getYPositionDate(this.getSlidingWindowPosY(n)),u=this.getYPositionDate(this.getSlidingWindowPosY(n)+n.getHeight());s=i.EventFactory.newOverviewEvent("rangeChange",void 0,void 0,g,u,void 0,void 0,h,d)}this.dispatchEvent(s)}dispatchEvent(t){this._callback.call(this._callbackObj,t,this)}destroy(){this.EventManager&&(this.EventManager.removeListeners(this),this.EventManager.destroy(),this.EventManager=null),L.supportsTouch()?(this.removeEvtListener(i.TouchEvent.TOUCHSTART,this.HandleTouchStart,!1,this),this.removeEvtListener(i.TouchEvent.TOUCHMOVE,this.HandleTouchMove,!1,this),this.removeEvtListener(i.TouchEvent.TOUCHEND,this.HandleTouchEnd,!1,this),this.removeEvtListener(i.MouseEvent.CLICK,this.HandleShapeClick,!1,this)):(this.removeEvtListener(i.MouseEvent.MOUSEOVER,this.HandleShapeMouseOver,!1,this),this.removeEvtListener(i.MouseEvent.MOUSEOUT,this.HandleShapeMouseOut,!1,this),this.removeEvtListener(i.MouseEvent.CLICK,this.HandleShapeClick,!1,this),this.removeEvtListener(i.KeyboardEvent.KEYDOWN,this.HandleKeyDown,!1,this),this.removeEvtListener(i.KeyboardEvent.KEYUP,this.HandleKeyUp,!1,this)),super.destroy()}}t.Overview=Y,t.OverviewParser=n,t.OverviewUtils=L,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ojdvt-overview.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojchart-toolkit',["exports","ojs/ojdvt-toolkit","ojs/ojdvt-axis","ojs/ojlegend-toolkit","ojs/ojdvt-overview"],function(e,t,i,r,s){"use strict";const a=(e,t)=>e+"; "+t,n=(e,i,r)=>null!=e&&null!=i&&t.Obj.compareValues(r,e,i);class o{constructor(e,t,i,r){this.id=e,this.series=t,this.group=i,this.context=r}equals(e){return e instanceof o&&(null!=this.id||null!=e.id?n(this.id,e.id,this.context):n(this.series,e.series,this.context)&&n(this.group,e.group,this.context))}toString(){return null!=this.id&&"object"!=typeof this.id?this.id.toString():a(this.series,this.group)}valueOf(){return this.toString()}}const l={_SUPPORTED_TYPES:["bar","line","area","lineWithArea","combo","pie","bubble","scatter","funnel","pyramid","stock","boxPlot"],isValidType:e=>l._SUPPORTED_TYPES.indexOf(e.getType())>=0,isSpark:e=>e.getOptions().__spark,isOverview:e=>e.getOptions()._isOverview,isVertical:e=>!l.isHorizontal(e)&&!l.isPolar(e),isHorizontal:e=>"horizontal"==e.getOptions().orientation&&!l.isPolar(e)&&!l.isStock(e)&&(l.isBLAC(e)||l.isFunnel(e)),isPolar:e=>"polar"==e.getOptions().coordinateSystem&&!l.isStock(e)&&!l.isBoxPlot(e),isCombo:e=>"combo"==e.getType(),isBar:e=>"bar"==e.getType(),isLine:e=>"line"==e.getType(),isLineWithArea:e=>"lineWithArea"==e.getType(),isArea:e=>"area"==e.getType(),isStock:e=>"stock"==e.getType(),isBoxPlot:e=>"boxPlot"==e.getType(),isScatter:e=>"scatter"==e.getType(),isBubble:e=>"bubble"==e.getType(),isPie:e=>"pie"==e.getType(),isFunnel:e=>"funnel"==e.getType(),isPyramid:e=>"pyramid"==e.getType(),isDualY:e=>!(!l.hasAxes(e)||l.isScatterBubble(e)||l.isPolar(e)),isBLAC:e=>{var t=e.getType();return"bar"==t||"line"==t||"area"==t||"lineWithArea"==t||"combo"==t||"stock"==t||"boxPlot"==t},isScatterBubble:e=>{var t=e.getType();return"scatter"==t||"bubble"==t},isLineArea:e=>{var t=e.getType();return"line"==t||"area"==t||"lineWithArea"==t},isScrollSupported:e=>!(l.isPie(e)||l.isFunnel(e)||l.isPolar(e)||l.isPyramid(e)),isOverviewSupported:e=>l.isBLAC(e)&&l.isVertical(e),hasAxes:e=>!("pie"==e.getType()||"funnel"==e.getType()||"pyramid"==e.getType()),isLegendRendered:e=>{var t=e.getOptions(),i=e.getOptionsCache().getFromCache("hasLargeSeriesCount"),r=t.legend;if("off"===r.rendered)return!1;if("auto"===r.rendered&&i)return!1;var s=e.getOptionsCache().getFromCache("hasSeriesDisplayedInLegend"),a=r.sections&&0!==r.sections.length,n=l.isStock(e),o=l.isFunnel(e),h=l.isPyramid(e);return!((n||o||h)&&!s&&!a)},hasTimeAxis:e=>l.isBLAC(e)&&"disabled"!=l.getTimeAxisType(e),hasGroupAxis:e=>l.isBLAC(e)&&"disabled"==l.getTimeAxisType(e),getTimeAxisType:e=>{var t=e.getOptions().timeAxisType;return t&&"auto"!=t&&l.isBLAC(e)&&!l.isPolar(e)?t:l.isStock(e)?"skipGaps":"disabled"},isMixedFrequency:e=>"mixedFrequency"==l.getTimeAxisType(e)},h={polarToCartesian:(e,i,r)=>{var s=r.x+r.w/2+e*Math.sin(i),a=r.y+r.h/2-e*Math.cos(i);return new t.Point(s,a)},convertAxisCoord:(e,i,r)=>{if(l.isPolar(e)){var s=h.polarToCartesian(i.y,i.x,r);return new t.Point(s.x,s.y)}return l.isHorizontal(e)?new t.Point(i.y,i.x):new t.Point(i.x,i.y)}},g={getValueFormat:(e,t)=>{var i=e.getOptions().valueFormats;return i?i[t]?i[t]:"group"==t&&l.hasTimeAxis(e)?g.getValueFormat(e,"x"):"y"!=t&&"y2"!=t&&"min"!=t&&"max"!=t||!l.isBLAC(e)?{}:g.getValueFormat(e,"value"):{}},formatVal:(e,t,r,s,a,n)=>{var o,l="auto",h="on";t.scaling&&(l=t.scaling),t.autoPrecision&&(h=t.autoPrecision),t.converter&&(o=t.converter),s=null!=s?s:r,a=null!=a?a:r,n=null!=n?n:0;var g=new i.LinearScaleAxisValueFormatter(s,a,n,l,h,e.getOptions().translations);return o&&o.format?g.format(r,o):g.format(r)},formatDateVal:(e,t)=>{var i=e.converter;return i&&i.format?i.format(t):null}},d={_SERIES_TYPE_RAMP:["bar","line","area"],hasData:e=>{var t=e.getOptions();if(!t||!t.series||t.series.length<1)return!1;for(var i=d.getSeriesCount(e),r=0;r<i;r++){var s=d.getSeriesItem(e,r);if(s&&s.items&&s.items.length>=1)return!0}return!1},hasInvalidData:e=>!d.hasData(e)||d.hasInvalidTimeData(e),hasInvalidTimeData:e=>{if(l.isFunnel(e)||l.isPie(e)||l.isPyramid(e))return!1;var t,i,r=e.getOptions(),s=d.getGroupCount(e);if(!r||!r.series||r.series.length<1)return!0;if(s<1)return!0;var a=d.getSeriesCount(e);if(l.isMixedFrequency(e))for(t=0;t<a;t++)for(i=0;i<s;i++){var n=d.getDataItem(e,t,i);if(n&&(null==n.x||isNaN(n.x)))return!0}else if(l.hasTimeAxis(e))for(i=0;i<s;i++){var o=d.getGroup(e,i);if(null==o||isNaN(o))return!0}return!1},hasSeriesData:(e,t)=>{var i=d.getSeriesItem(e,t).items;if(i)for(var r=0;r<i.length;r++)if(null!=i[r])return!0;return!1},getSeriesCount:e=>{var t=e.getOptions().series;return t?t.length:0},getY2SeriesCount:(e,t,i)=>{for(var r=0,s=d.getSeriesCount(e),a=0;a<s;a++)t&&d.getSeriesType(e,a)!=t||(i||d.isSeriesRendered(e,a))&&d.isAssignedToY2(e,a)&&r++;return r},getSeries:(e,t)=>{var i=d.getSeriesItem(e,t);return i?i.id?i.id:i.name||""===i.name?i.name:String(t):null},getSeriesLabel:(e,t)=>{var i=d.getSeriesItem(e,t);return i&&(i.name||""===i.name)?i.name:null},getSeriesIdx:(e,t)=>{for(var i=d.getSeriesCount(e),r=0;r<i;r++){if(d.getSeries(e,r)==t)return r}return-1},getSeriesStyleIdx:(e,t)=>{if(e.getOptionsCache().getFromCache("hasLargeSeriesCount"))return t;var i=d.getSeries(e,t);return null==i?t:e.getSeriesStyleArray().indexOf(i)},getSeriesItem:(e,t)=>{if(isNaN(t)||null==t||t<0)return null;var i=e.getOptions();return i.series&&i.series.length>t?i.series[t]:null},getDataItem:(e,t,i)=>{if(isNaN(i)||null==i||i<0)return null;var r=d.getSeriesItem(e,t);return r&&r.items&&r.items.length>i?r.items[i]:null},getRawDataItem:(e,t,i)=>{if(isNaN(i)||null==i||i<0)return null;var r=e.getRawOptions().series[t].items[i];if("number"==typeof r)return r;if(!r)return null;var s=Object.assign({},r);return s.itemData=r._itemData,delete s._itemData,s},getDataItemId:(e,t,i)=>{var r=d.getDataItem(e,t,i);return r?null!=r.id?r.id:a(d.getSeries(e,t),d.getGroup(e,i)):null},getNestedDataItem:(e,t,i,r)=>{if(isNaN(r)||null==r||r<0)return null;var s=d.getDataItem(e,t,i);return s&&s.items&&s.items.length>r?s.items[r]:null},getNestedDataItemCount:(e,t,i)=>{var r=d.getDataItem(e,t,i);return r&&r.items?r.items.length:0},getNestedDataItemId:(e,t,i,r)=>{var s=d.getNestedDataItem(e,t,i,r);return s?null!=s.id?s.id:d.getDataItemId(e,t,i)+"; "+String(r):null},getNestedDataItemIdx:(e,t,i,r)=>{for(var s=d.getNestedDataItemCount(e,t,i),a=0;a<s;a++){var o=d.getNestedDataItemId(e,t,i,a);if(n(o,r,e.getCtx()))return a}return-1},getGroupCount:e=>d._getGroupsArray(e).length,getGroup:(e,t)=>{if(null!=t&&t>=0&&t<d.getGroupCount(e)){var i=d._getGroupsArray(e)[t];if(i)return null!=i.id?i.id:null!=i.name?i.name:String(t)}return null},getGroupIdx:(e,i)=>{for(var r=d.getGroups(e),s=0;s<r.length;s++)if(i instanceof Array&&r[s]instanceof Array?t.ArrayUtils.equals(i,r[s]):i===r[s])return s;return-1},getGroupLabel:(e,t)=>{if(t>=0&&t<d.getGroupCount(e)){var i=d._getGroupsArray(e)[t];if(i)return null!=i.name?i.name:null!=i.id||"string"!=typeof i?"":i}return null},getGroups:e=>{var t=e.getOptionsCache().getFromCache("groups");if(!t){var i=d.getGroupCount(e);t=[];for(var r=0;r<i;r++)t.push(d.getGroup(e,r));e.getOptionsCache().putToCache("groups",t)}return t},_getGroupsArray:e=>{var t=e.getOptions(),i=e.getOptionsCache().getFromCache("groupsArray");if(!i){i=[],t.groups&&(i=d._getNestedGroups(t.groups,i));for(var r=0;r<i.length;r++)1==i[r].id.length&&(i[r].id=i[r].id[0],i[r].name=i[r].name[0]);e.getOptionsCache().putToCache("groupsArray",i)}return i},_getNestedGroups:(e,t)=>{if(!e||0==e.length)return[];for(var i=0;i<e.length;i++){var r=e[i],s=null,a=null;if(null!=r&&(s=null!=(s=null!=r.id?r.id:r.name)?s:r,a=r.name?r.name:r),"object"==typeof s&&(s=null),"object"==typeof a&&(a=null),r&&r.groups){var n=d._getNestedGroups(r.groups,[]);0==n.length&&n.push({id:[],name:[]});for(var o=0;o<n.length;o++)n[o].id.unshift(s),n[o].name.unshift(a);t=t.concat(n)}else t.push({id:[s],name:[a]})}return t},getNumLevels:e=>{var t=e.getOptionsCache().getFromCache("groupsNumLevels");if(null!=t)return t;t=0;for(var i=d._getGroupsArray(e),r=0;r<i.length;r++){var s=i[r];if(s&&s.id){var a=Array.isArray(s.id)?s.id.length:1;t=Math.max(t,a)}}return e.getOptionsCache().putToCache("groupsNumLevels",t),t},getVal:(e,t,i,r)=>{var s,a="number"==typeof r&&r>=0;if(!a&&void 0!==(s=e.getOptionsCache().getFromCachedMap2D("value",t,i)))return s;var n=a?d.getNestedDataItem(e,t,i,r):d.getDataItem(e,t,i);return s=null,null!=n&&("object"!=typeof n?s=n:l.isStock(e)&&null!=n.close?s=n.close:null!=n.value?s=n.value:null!=n.y&&(s=n.y)),s=s||(0===s?0:null),a||e.getOptionsCache().putToCachedMap2D("value",t,i,s),s},getCumulativeVal:(e,t,i,r)=>{if(!d.isStacked(e))return d.getVal(e,t,i);var s=r?"cumValueH":"cumValue",a=e.getCache().getFromCachedMap2D(s,t,i);if(void 0!==a)return a;var n=d.getSeriesType(e,t),o=d.isAssignedToY2(e,t),l=d.getVal(e,t,i),h=d.getStackCategory(e,t),g="bar"==n?l<0:d.isSeriesNegative(e,t);a=0;for(var u=t;u>=0;u--)if((r||d.isDataItemRendered(e,u,i))&&n==d.getSeriesType(e,u)&&o==d.isAssignedToY2(e,u)&&d.getStackCategory(e,u)==h){var _=d.getVal(e,u,i),c="bar"==n?_<0:d.isSeriesNegative(e,u);if(g&&c||!g&&!c){var p=e.getCache().getFromCachedMap2D(s,u,i);if(void 0!==p){a=l+(p||0);break}a+=null==_||isNaN(_)?0:_}}return e.getCache().putToCachedMap2D(s,t,i,a),a},getLowVal:(e,t,i)=>{var r=d.getDataItem(e,t,i);return null==r?null:"candlestick"==d.getSeriesType(e,t)?null==r.low&&null!=r.close?null!=r.open?Math.min(r.close,r.open):r.close:r.low:null!=r.low&&null==r.close?r.low:null},getHighVal:(e,t,i)=>{var r=d.getDataItem(e,t,i);return null==r?null:"candlestick"==d.getSeriesType(e,t)?null==r.high?null!=r.open?Math.max(r.close,r.open):r.close:r.high:null!=r.high&&null==r.close?r.high:null},getXVal:(e,t,i)=>{var r=d.getDataItem(e,t,i);return d.getXValFromItem(e,r,i)},getXValFromItem:(e,t,i)=>null!=t&&null!=t.x?t.x:l.hasGroupAxis(e)?i:l.hasTimeAxis(e)&&!l.isMixedFrequency(e)?d.getGroupLabel(e,i):null,getTargetVal:(e,t)=>{var i=d.getDataItem(e,t,0);return null==i||"object"!=typeof i?null:i.targetValue},getZVal:(e,t,i,r)=>{var s=d.getDataItem(e,t,i);return null==s||"object"!=typeof s?r:null!=s.z?Math.max(0,s.z):r},isStockValRising:(e,t,i)=>{var r=d.getDataItem(e,t,i);return!r||r.open<=r.close},getCategories:(e,t,i,r)=>{var s=d.getNestedDataItem(e,t,i,r);if(s&&s.categories)return s.categories;var a=d.getDataItem(e,t,i);if(a&&a.categories)return a.categories;var n=d.getSeriesItem(e,t);if(n&&n.categories)return n.categories;var o=d.getSeries(e,t);return null!=o?[o]:[]},isAssignedToY2:(e,t)=>{if(!e.getOptionsCache().getFromCache("hasY2Assignment"))return!1;var i=d.getSeriesItem(e,t);return i&&"on"==i.assignedToY2&&l.isDualY(e)},getInitialSelection:e=>{var t=e.getOptions().selection,i=null!=e.getOptions().data;t||(t=[]);for(var r=e.getChartObjPeers(),s=0;s<t.length;s++){var a=null==t[s].id||i?t[s]:t[s].id;if(null!=t[s].id||t[s].series||t[s].group||(t[s]={id:a}),!(null==a||t[s].series&&t[s].group))for(var o=0;o<r.length;o++){var l=r[o];if(n(a,l.getDataItemId(),e.getCtx())){t[s].series=l.getSeries(),t[s].group=l.getGroup();break}}}return t},getCurrentSelection:e=>{var t=[],i=e.getSelectionHandler();if(i)for(var r=i.getSelectedIds(),s=0;s<r.length;s++){var a=r[s];t.push({series:a.series,group:a.group,id:a.id})}return t},hasVolumeSeries:e=>{var t=e.getOptionsCache().getFromCache("hasVolume");return t||!1},isDataSelected:(e,t,i,r)=>{var s=!isNaN(r)&&null!=r&&r>=0?d.getNestedDataItemId(e,t,i,r):d.getDataItemId(e,t,i),a=d.getSeries(e,t),o=d.getGroup(e,i),l=e.getOptions().selection;l||(l=[]);for(var h=0;h<l.length;h++){if(n(s,l[h],e.getCtx())||n(s,l[h].id,e.getCtx()))return!0;if(null==l[h].id&&n(a,l[h].series,e.getCtx())&&n(o,l[h].group,e.getCtx()))return!0}return!1},getDefaultDataLabel:(e,t,i,r,s,a)=>{var n;if(a)n=d.getCumulativeVal(e,t,i);else{var o=!isNaN(r)&&null!=r&&r>=0?d.getNestedDataItem(e,t,i,r):d.getDataItem(e,t,i);if(!o)return null;n=o.label,"low"==s?n=n instanceof Array?n[0]:n:"high"==s&&(n=n instanceof Array?n[1]:null)}if(null!=n){if("number"==typeof n){var l,h,u,_=d.isAssignedToY2(e,t)&&e.y2Axis?e.y2Axis:e.yAxis;if(_){var c=_.getInfo();l=c.getGlobalMin(),h=c.getGlobalMax(),u=c.getMajorIncrement()}var p=g.getValueFormat(e,"label");return g.formatVal(e,p,n,l,h,u)}return n}return null},getStackCategory:(e,t)=>{var i=e.getCache().getFromCachedMap("stackCategory",t);return void 0!==i||(i=d.isStacked(e)?d.getSeriesItem(e,t).stackCategory||null:d.getSeries(e,t)||null,e.getCache().putToCachedMap("stackCategory",t,i)),i},getStackCategories:(e,t,i)=>{var r=[],s=[],a={},n={},o=e.getCache().getFromCachedMap2D("stackCategories",t,i);if(o)return o;for(var l=d.getSeriesCount(e),h=0;h<l;h++)if(d.isSeriesRendered(e,h)||i){if(t){var g=d.getSeriesType(e,h);if("candlestick"!=g&&"boxPlot"!=g||(g="bar"),t!=g)continue}var u=d.getStackCategory(e,h);d.isAssignedToY2(e,h)?n[u]||(s.push(u),n[u]=!0):a[u]||(r.push(u),a[u]=!0)}return o={y:r,y2:s},e.getCache().putToCachedMap2D("stackCategories",t,i,o),o},getBarCategoryZ:(e,t,i,r)=>{for(var s=0,a=d.getSeriesCount(e),n=0;n<a;n++){var o=d.getSeriesType(e,n);if(("bar"==o||"candlestick"==o||"boxPlot"==o)&&d.getStackCategory(e,n)==t&&d.isSeriesRendered(e,n)){var l=d.isAssignedToY2(e,n);(r&&l||!r&&!l)&&(s=Math.max(s,d.getZVal(e,n,i,1)))}}return s},getMarkerPos:(e,i,r,s,a)=>{var n,o,g=e.xAxis,u=d.isAssignedToY2(e,i)?e.y2Axis:e.yAxis,_=l.isPolar(e),c=d.isRangeSeries(e,i),p=!isNaN(s)&&null!=s&&s>=0,v=d.getXVal(e,i,r),m=p?d.getVal(e,i,r,s):d.getCumulativeVal(e,i,r);if(l.isBubble(e)){if(_&&m<u.getInfo().getViewportMin())return null;n=_?g.getCoordAt(v):g.getUnboundedCoordAt(v),o=u.getUnboundedCoordAt(m)}else if(c){var f=u.getCoordAt(d.getLowVal(e,i,r)),x=u.getCoordAt(d.getHighVal(e,i,r));n=g.getCoordAt(d.getXVal(e,i,r)),o=(f+x)/2}else n=g.getCoordAt(v),o=u.getCoordAt(m);return null==n||null==o?null:h.convertAxisCoord(e,new t.Point(n,o),a)},getScatterBubbleMarkerPos:(e,i,r)=>{var s=e.xAxis,a=e.yAxis,n=d.getXVal(e,i,r),o=d.getVal(e,i,r),l=s.getCoordAt(n),h=a.getCoordAt(o);return null==l||null==h?null:new t.Point(l,h)},isSeriesNegative:(e,t)=>{if(!e.getOptionsCache().getFromCache("hasNegativeValues"))return!1;var i=e.getOptionsCache().getFromCachedMap("isSeriesNegative",t);if(null!=i)return i;var r=d.getGroupCount(e);i=!0;for(var s=0;s<r;s++){if(d.getVal(e,t,s)>0){i=!1;break}}return e.getOptionsCache().putToCachedMap("isSeriesNegative",t,i),i},getGroupsDataForContext:e=>{var t=e.getOptionsCache().getFromCache("groupsDataArray");if(!t){var i=e.getRawOptions();t=d._getNestedGroupsData(i.groups),e.getOptionsCache().putToCache("groupsDataArray",t)}return t},getSeriesDataForContext:(e,t)=>{var i=e.getRawOptions().series[t],r=Object.assign({},i);r.items=[];for(var s=0;s<i.items.length;s++){var a,n=i.items[s];(a="object"==typeof n?Object.assign({},i.items[s]):n)&&"object"==typeof a&&delete a._itemData,r.items.push(a)}return r},_getNestedGroupsData:e=>{if(!e)return[];for(var t=[],i=0;i<e.length;i++){var r=e[i];if(r.groups){for(var s=d._getNestedGroupsData(r.groups),a=0;a<s.length;a++)s[a].unshift(r);t=t.concat(s)}else t.push([r])}return t},_computeOutermostBarMap:e=>{if(!e.getOptionsCache().getFromCache("outermostBar")){for(var t={},i=d.getSeriesCount(e),r=e.getOptionsCache().getFromCache("hasNegativeValues"),s=i-1;s>=0;s--)if(d.isSeriesRendered(e,s)&&"bar"==d.getSeriesType(e,s)){var a=(d.getStackCategory(e,s)||"")+d.isAssignedToY2(e,s);t[a]?t[a].push(s):t[a]=[s]}var n=d.getGroupCount(e);for(var o in t)for(var l=t[o],h=0;h<n;h++)for(var g=!1,u=!1,_=0;_<l.length&&!(!r&&g||g&&u);_++)if(s=l[_],d.isDataItemRendered(e,s,h)){var c=d.getVal(e,s,h);null==c?e.getOptionsCache().putToCachedMap2D("outermostBar",s,h,!1):!g&&c>=0?(g=!0,e.getOptionsCache().putToCachedMap2D("outermostBar",s,h,!0)):!u&&c<0&&(u=!0,e.getOptionsCache().putToCachedMap2D("outermostBar",s,h,!0))}}},isOutermostBar:(e,t,i)=>(d._computeOutermostBarMap(e),e.getOptionsCache().getFromCachedMap2D("outermostBar",t,i)||!1),isDataItemFiltered:(e,t,i)=>{var r=d.getDataItem(e,t,i);return!(!r||!r._filtered)},isStacked:e=>!("on"!=e.getOptions().stack||l.isMixedFrequency(e)||d.getSeriesCount(e)<2)&&l.isBLAC(e),isSplitDualY:e=>!(!l.isStock(e)||!d.hasVolumeSeries(e)||l.isOverview(e))||"on"==e.getOptions().splitDualY&&d.hasY2Data(e)&&!d.hasY2DataOnly(e),hasY2DataOnly:e=>!!l.isDualY(e)&&d.getY2SeriesCount(e,null,!0)==d.getSeriesCount(e),hasY2Data:(e,t)=>!!l.isDualY(e)&&d.getY2SeriesCount(e,null,!0)>0,hasY2BarData:e=>d.hasY2Data(e,"bar"),hasBarSeries:e=>d._hasSeriesType(e,"bar"),hasLineSeries:e=>d._hasSeriesType(e,"line"),hasAreaSeries:e=>d._hasSeriesType(e,"area"),hasLineWithAreaSeries:e=>d._hasSeriesType(e,"lineWithArea"),hasCandlestickSeries:e=>d._hasSeriesType(e,"candlestick"),hasBoxPlotSeries:e=>d._hasSeriesType(e,"boxPlot"),_hasSeriesType:(e,t)=>{if(l.isBLAC(e))for(var i=d.getSeriesCount(e),r=0;r<i;r++)if(d.isSeriesRendered(e,r)&&d.getSeriesType(e,r)==t)return!0;return!1},getRefObjs:e=>{var t=d.getAxisRefObjs(e,"x"),i=d.getAxisRefObjs(e,"y"),r=d.getAxisRefObjs(e,"y2");return t.concat(i,r)},getAxisRefObjs:(e,t)=>{var i=e.getOptions();return i&&i[t+"Axis"]&&i[t+"Axis"].referenceObjects?i[t+"Axis"].referenceObjects:[]},getSeriesType:(e,t)=>{var i=e.getOptionsCache().getFromCachedMap("seriesType",t);if(i)return i;if(!l.isBLAC(e))return e.getOptionsCache().putToCachedMap("seriesType",t,"auto"),"auto";var r=d.getSeriesItem(e,t);if(i=r?r.type:null,l.isStock(e)||"candlestick"!=i||(i="auto"),!i||"auto"==i)if(l.isBar(e))i="bar";else if(l.isLine(e))i="line";else if(l.isArea(e))i="area";else if(l.isLineWithArea(e))i="lineWithArea";else if(l.isStock(e))i="candlestick";else if(l.isBoxPlot(e))i="boxPlot";else if(l.isCombo(e)){var s=d.getSeriesStyleIdx(e,t)%d._SERIES_TYPE_RAMP.length;i=d._SERIES_TYPE_RAMP[s]}return e.getOptionsCache().putToCachedMap("seriesType",t,i),i},getHiddenCategories:e=>{var t=e.getOptions();return t.hiddenCategories||(t.hiddenCategories=[]),t.hiddenCategories},getHighlightedCategories:e=>{var t=e.getOptions();return t.highlightedCategories||(t.highlightedCategories=[]),t.highlightedCategories},isSeriesRendered:(e,i)=>{var r=d.getHiddenCategories(e);return!(r.length>0&&t.ArrayUtils.hasAnyItem(r,d.getCategories(e,i)))},isDataItemRendered:(e,i,r,s)=>{var a,n=!isNaN(s)&&null!=s&&s>=0;if(!n&&void 0!==(a=e.getOptionsCache().getFromCachedMap2D("isDataItemRendered",i,r)))return a;if(a=!0,d.isSeriesRendered(e,i)){var o=d.getHiddenCategories(e);o.length>0&&((l.isPie(e)||l.isFunnel(e)||l.isPyramid(e))&&(r=0),t.ArrayUtils.hasAnyItem(o,d.getCategories(e,i,r))&&(a=!1),t.ArrayUtils.hasAnyItem(o,d.getCategories(e,i,r,s))&&(a=!1))}else a=!1;return n||e.getOptionsCache().putToCachedMap2D("isDataItemRendered",i,r,a),a},isRangeSeries:(e,t)=>{var i=e.getOptionsCache();if(!i.getFromCache("hasLowHighSeries"))return!1;var r=i.getFromCachedMap("isRange",t);if(null!=r)return r;r=!1;var s=d.getSeriesType(e,t);if("bar"==s||"area"==s)for(var a=0;a<d.getGroupCount(e);a++)if(null!=d.getLowVal(e,t,a)||null!=d.getHighVal(e,t,a)){r=!0;break}return e.getOptionsCache().putToCachedMap("isRange",t,r),r},isSeriesDrillable:(e,t)=>{var i=d.getSeriesItem(e,t),r=null!=i?i.drilling:"inherit";return"on"==r||"off"!=r&&("on"==(r=e.getOptions().drilling)||"seriesOnly"==r)},isDataItemDrillable:(e,t,i,r)=>{var s=d.getNestedDataItem(e,t,i,r);s||(s=d.getDataItem(e,t,i));var a=null!=s?s.drilling:"inherit";return"on"==a||"off"!=a&&"on"==(a=e.getOptions().drilling)},isMultiSeriesDrillEnabled:e=>"on"===e.getOptions().multiSeriesDrilling};class u extends t.BaseComponentDefaults{constructor(e){super({alta:{skin:t.CSSStyle.SKIN_ALTA,emptyText:null,type:"bar",stack:"off",stackLabel:"off",orientation:"vertical",polarGridShape:"circle",selectionMode:"none",hideAndShowBehavior:"none",hoverBehavior:"none",zoomAndScroll:"off",zoomDirection:"auto",initialZooming:"none",dragMode:"user",sorting:"off",otherThreshold:0,animationOnDataChange:"none",animationOnDisplay:"none",__sparkBarSpacing:"subpixel",__spark:!1,dataCursor:"auto",dataCursorBehavior:"auto",drilling:"off",highlightMatch:"all",series:[],groups:[],title:{style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_BOLD_13+"color: #252525;"),halign:"start"},subtitle:{style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color: #252525;")},footnote:{style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_11+"color: #333333;"),halign:"start"},titleSeparator:{upperColor:"#74779A",lowerColor:"#FFFFFF",rendered:"off"},touchResponse:"auto",_statusMessageStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_13+"color: #252525;"),_dropColor:"#D9F4FA",xAxis:{tickLabel:{rendered:"on"},majorTick:{rendered:"auto"},minorTick:{rendered:"auto"},axisLine:{rendered:"on"},scale:"linear"},yAxis:{tickLabel:{rendered:"on"},majorTick:{rendered:"auto"},minorTick:{rendered:"auto"},axisLine:{rendered:"auto"},scale:"linear"},y2Axis:{tickLabel:{rendered:"on"},majorTick:{rendered:"auto"},minorTick:{rendered:"auto"},axisLine:{rendered:"auto"},scale:"linear",alignTickMarks:"on"},pieCenter:{labelStyle:new t.CSSStyle("")},zAxis:{},plotArea:{backgroundColor:null},legend:{position:"auto",rendered:"auto",layout:{gapRatio:1},seriesSection:{},referenceObjectSection:{},sections:[]},overview:{rendered:"off"},dnd:{drag:{items:{},series:{},groups:{}},drop:{plotArea:{},xAxis:{},yAxis:{},y2Axis:{},legend:{}}},styleDefaults:{colors:t.CSSStyle.COLORS_ALTA,borderColor:"auto",borderWidth:"auto",patterns:["smallDiagonalRight","smallChecker","smallDiagonalLeft","smallTriangle","smallCrosshatch","smallDiamond","largeDiagonalRight","largeChecker","largeDiagonalLeft","largeTriangle","largeCrosshatch","largeDiamond"],shapes:["square","circle","diamond","plus","triangleDown","triangleUp"],seriesEffect:"color",threeDEffect:"off",selectionEffect:"highlight",animationDuration:1e3,animationIndicators:"all",animationUpColor:"",animationDownColor:"",lineStyle:"solid",lineType:"auto",markerDisplayed:"auto",markerColor:null,markerShape:"auto",markerSize:10,marqueeColor:"",marqueeBorderColor:"",pieFeelerColor:"#BAC5D6",pieInnerRadius:0,selectedInnerColor:"#ffffff",selectedOuterColor:"#5a5a5a",sliceLabelType:"percent",otherColor:"#4b4b4b",dataItemGaps:"auto",dataLabelStyle:new t.CSSStyle(""),_dataLabelStyle:new t.CSSStyle(""),dataLabelPosition:"auto",funnelBackgroundColor:"#EDEDED",x1Format:{},y1Format:{},y2Format:{},zFormat:{},_defaultSliceLabelColor:"#333333",_scrollbarHeight:3,_scrollbarTrackColor:"#F0F0F0",_scrollbarHandleColor:"#9E9E9E",hoverBehaviorDelay:200,dataCursor:{markerSize:8,markerDisplayed:"on",lineStyle:"solid"},groupSeparators:{rendered:"on",color:"rgba(138,141,172,0.4)"},tooltipLabelStyle:new t.CSSStyle(""),tooltipValueStyle:new t.CSSStyle(""),stackLabelStyle:new t.CSSStyle(""),boxPlot:{whiskerSvgStyle:{},whiskerEndSvgStyle:{strokeWidth:2},whiskerEndLength:"9px",medianSvgStyle:{strokeWidth:3}}},layout:{gapWidthRatio:null,gapHeightRatio:null,outerGapWidth:10,outerGapHeight:8,titleSubtitleGapWidth:14,titleSubtitleGapHeight:4,titleSeparatorGap:6,titlePlotAreaGap:16,footnoteGap:10,verticalAxisGap:6,legendGapWidth:15,legendGapHeight:10,tickLabelGapHeight:8,tickLabelGapWidth:9},_locale:"en-us",_resources:{}}},e)}static getGapWidth(e,t){return Math.ceil(t*e.getGapWidthRatio())}static getGapHeight(e,t){return Math.ceil(t*e.getGapHeightRatio())}getNoCloneObject(){return{series:{items:{_itemData:!0}},data:!0,valueFormats:{close:{converter:!0},high:{converter:!0},label:{converter:!0},low:{converter:!0},open:{converter:!0},q1:{converter:!0},q2:{converter:!0},q3:{converter:!0},targetValue:{converter:!0},value:{converter:!0},volume:{converter:!0},x:{converter:!0},y:{converter:!0},y2:{converter:!0},z:{converter:!0}},pieCenter:{converter:!0},xAxis:{tickLabel:{converter:!0}},yAxis:{tickLabel:{converter:!0}},y2Axis:{tickLabel:{converter:!0}}}}}const _={OTHER_ID:"_dvtOther",getSliceId:(e,t)=>{var i=d.getDataItem(e,t,0),r=i?i.id:null,s=d.getSeries(e,t),a=d.getGroup(e,0);return new o(r,s,a,e.getCtx())},getOtherSliceId:e=>{var t=d.getGroup(e,0);return new o(null,_.OTHER_ID,t,e.getCtx())},getRenderedSeriesIndices:e=>_._getSeriesIndicesArrays(e).rendered,hasOtherSeries:e=>_._getSeriesIndicesArrays(e).other.length>0,getOtherVal:e=>{for(var t=_._getSeriesIndicesArrays(e).other,i=0,r=0;r<t.length;r++){var s=t[r];if(d.isSeriesRendered(e,s)){var a=d.getVal(e,s,0);a>0&&(i+=a)}}return i},getOtherSliceIds:e=>{for(var t=_._getSeriesIndicesArrays(e).other,i=[],r=0;r<t.length;r++){var s=t[r];i.push(_.getSliceId(e,s))}return i},isOtherSliceSelected:(e,t)=>{for(var i=_.getOtherSliceIds(e),r=0;r<i.length;r++){for(var s=i[r],a=!1,n=0;n<t.length;n++)if(null!=t[n].id&&s.id===t[n].id||s.series===t[n].series&&s.group===t[n].group){a=!0;break}if(!a)return!1}return!0},_getSeriesIndicesArrays:e=>{for(var t=[],i=[],r=d.getSeriesCount(e),s=e.getOptions(),a=s.otherThreshold*_.getTotalVal(e),n=0;n<r;n++){var o=d.getVal(e,n,0);a>0&&o<a?i.push(n):t.push(n)}return"ascending"==s.sorting?t.sort((t,i)=>d.getVal(e,t,0)-d.getVal(e,i,0)):"on"!=s.sorting&&"descending"!=s.sorting||t.sort((t,i)=>d.getVal(e,i,0)-d.getVal(e,t,0)),{rendered:t,other:i}},getTotalVal:e=>{for(var t=d.getSeriesCount(e),i=0,r=0;r<t;r++){var s=d.getVal(e,r,0);s>0&&(i+=s)}return i},getSliceExplode:(e,t)=>{var i=d.getSeriesItem(e,t);return i&&i.pieSliceExplode?i.pieSliceExplode:0},getSliceBySeriesIdx:(e,t)=>{for(var i=e.pieChart.__getSlices(),r=0;r<i.length;r++)if(i[r].getSeriesIndex()==t)return i[r];return null}},c={MARKER_DATA_LABEL_GAP:4,getSeriesEffect:e=>e.getOptions().styleDefaults.seriesEffect,getColor:(e,t,i)=>{var r=d.getDataItem(e,t,i);if(r&&r.color)return r.color;var s=d.getSeriesItem(e,t);if(s&&s.color)return s.color;if("candlestick"==d.getSeriesType(e,t))return c.getStockItemColor(e,t,i);var a=e.getOptions().styleDefaults.colors;return a[d.getSeriesStyleIdx(e,t)%a.length]},getStockItemColor:(e,t,i)=>{var r=e.getOptions();return d.isStockValRising(e,t,i)?r.styleDefaults.stockRisingColor:r.styleDefaults.stockFallingColor},getStockVolumeColor:(e,t,i)=>{var r=d.getDataItem(e,t,i);if(r&&r.color)return r.color;var s=e.getOptions();return s.styleDefaults.stockVolumeColor?s.styleDefaults.stockVolumeColor:c.getStockItemColor(e,t,i)},getSplitterPos:e=>{var t=e.getOptions().splitterPosition;return null!=t?t:l.isStock(e)?.8:.5},getPattern:(e,i,r,s)=>{var a=d.getNestedDataItem(e,i,r,s);if(a&&a.pattern&&"auto"!=a.pattern)return a.pattern;var n=d.getDataItem(e,i,r);if(n&&n.pattern&&"auto"!=n.pattern)return n.pattern;var o=d.getSeriesType(e,i);if(("line"==o||"area"==o)&&null!=r)return null;var h=d.getSeriesItem(e,i);if(h&&h.pattern&&"auto"!=h.pattern)return h.pattern;if("pattern"==c.getSeriesEffect(e)){if(l.isStock&&"candlestick"==d.getSeriesType(e,i)){var g=d.isStockValRising(e,i,r),u=t.Agent.isRightToLeft(e.getCtx());return g?u?"smallDiagonalLeft":"smallDiagonalRight":u?"smallDiagonalRight":"smallDiagonalLeft"}var _=e.getOptions().styleDefaults.patterns;return _[d.getSeriesStyleIdx(e,i)%_.length]}return null},getMarkerBorderColor:(e,t,i,r)=>{var s=c.getBorderColor(e,t,i,r);return s||c.getDefaultMarkerBorderColor(e,t,i,r)},getDefaultMarkerBorderColor:(e,i,r,s)=>{if("redwood"===e.getCtx().getThemeBehavior()&&!d.isRangeSeries(e,i))return c.getMarkerColor(e,i,r,s);if(c.getDataItemGaps(e)>0&&"lineWithArea"!=d.getSeriesType(e,i))return c.getBackgroundColor(e,!0);if(l.isBubble(e)&&"gradient"!=c.getSeriesEffect(e)){var a=c.getMarkerColor(e,i,r);if(a)return t.ColorUtils.adjustHSL(a,0,.15,-.25)}return null},getBorderColor:(e,t,i,r)=>{var s=d.getNestedDataItem(e,t,i,r);if(s&&s.borderColor)return s.borderColor;var a=d.getDataItem(e,t,i);if(a&&a.borderColor)return a.borderColor;var n=d.getSeriesItem(e,t);if(n&&n.borderColor)return n.borderColor;var o=e.getOptions().styleDefaults;return"auto"!=o.borderColor?o.borderColor:null},getUserBorderWidth:(e,t,i,r)=>{var s=d.getNestedDataItem(e,t,i,r);if(s&&null!=s.borderWidth)return s.borderWidth;var a=d.getDataItem(e,t,i);if(a&&null!=a.borderWidth)return a.borderWidth;var n=d.getSeriesItem(e,t);if(n&&null!=n.borderWidth)return n.borderWidth;var o=e.getOptions().styleDefaults;return"auto"!=o.borderWidth?o.borderWidth:null},getDefaultBorderWidth:e=>l.isScatterBubble(e)||l.isLineArea(e)?1.25:1,getDefaultMarkerBorderWidth:e=>"redwood"===e.getCtx().getThemeBehavior()?0:c.getDefaultBorderWidth(e),getBorderWidth:(e,t,i,r)=>{var s=c.getUserBorderWidth(e,t,i,r);return null!=s?s:c.getDefaultBorderWidth(e)},getMarkerColor:(e,t,i,r)=>{if(!c.isMarkerDisplayed(e,t,i,r))return c.getColor(e,t,i);var s=d.getNestedDataItem(e,t,i,r);if(s&&s.color)return s.color;var a=d.getDataItem(e,t,i);if(a&&a.color)return a.color;var n=d.getSeriesItem(e,t);if(n&&n.markerColor)return n.markerColor;var o=e.getOptions().styleDefaults.markerColor;return o||c.getColor(e,t,i)},getMarkerShape:(e,t,i,r)=>{var s=e.getOptions(),a=s.styleDefaults.markerShape,n=d.getSeriesItem(e,t);n&&n.markerShape&&(a=n.markerShape);var o=d.getDataItem(e,t,i);o&&o.markerShape&&(a=o.markerShape);var h=d.getNestedDataItem(e,t,i,r);if(h&&h.markerShape&&(a=h.markerShape),"auto"==a)if(l.isBubble(e)||"boxPlot"==d.getSeriesType(e,t)||d.isRangeSeries(e,t))a="circle";else{var g=d.getSeriesStyleIdx(e,t),u=s.styleDefaults.shapes;a=u[g%u.length]}return a},getMarkerSize:(e,t,i,r)=>{var s;if(l.isBubble(e)&&(s=e.getOptionsCache().getFromCachedMap2D("bubbleSizeCache",t,i)))return s;var a=d.getNestedDataItem(e,t,i,r);if(a&&null!=a.markerSize)s=Number(a.markerSize);else{var n=d.getDataItem(e,t,i);if(n&&null!=n.markerSize)s=Number(n.markerSize);else{var o=d.getSeriesItem(e,t);s=o&&null!=o.markerSize?Number(o.markerSize):Number(e.getOptions().styleDefaults.markerSize)}}return l.isOverview(e)&&(s=Math.ceil(.6*s)),s},isMarkerDisplayed:(e,t,i,r)=>{var s,a=d.getNestedDataItem(e,t,i,r);if(a&&null!=a.markerDisplayed)s=a.markerDisplayed;else{var n=d.getDataItem(e,t,i);if(n&&null!=n.markerDisplayed)s=n.markerDisplayed;else{var o=d.getSeriesItem(e,t);s=o&&null!=o.markerDisplayed?o.markerDisplayed:e.getOptions().styleDefaults.markerDisplayed}}return"on"==s||"off"!=s&&(l.isScatterBubble(e)||"boxPlot"==d.getSeriesType(e,t)||"none"==c.getLineType(e,t))},getImageSource:(e,t,i,r,s)=>{var a=d.getNestedDataItem(e,t,i,r);if(a&&a[s])return a[s];var n=d.getDataItem(e,t,i);if(n&&n[s])return n[s];var o=d.getSeriesItem(e,t);return o&&o[s]?o[s]:void 0},getLineWidth:(e,t)=>{var i,r=d.getSeriesItem(e,t),s=e.getOptions();return i=r&&r.lineWidth?r.lineWidth:s.styleDefaults.lineWidth?s.styleDefaults.lineWidth:"lineWithArea"==d.getSeriesType(e,t)?2:3,l.isOverview(e)&&(i=Math.ceil(.6*i)),i},getLineStyle:(e,t)=>{var i=d.getSeriesItem(e,t);return i&&i.lineStyle?i.lineStyle:e.getOptions().styleDefaults.lineStyle},getLineType:(e,t)=>{var i,r=d.getSeriesItem(e,t);return"auto"==(i=r&&r.lineType?r.lineType:e.getOptions().styleDefaults.lineType)&&(i=l.isScatterBubble(e)?"none":"straight"),(l.isPolar(e)||l.isScatterBubble(e))&&("centeredSegmented"==i&&(i="segmented"),"centeredStepped"==i&&(i="stepped")),i},getBarSpacing:e=>e.getOptions().__sparkBarSpacing,getMaxBarWidth:e=>{var t=e.getOptions().styleDefaults.maxBarWidth;return null==t||l.isPolar(e)?1/0:t},getBarWidth:(e,t,i)=>{e.getOptionsCache().getFromCache("hasConstantZValue")&&(t=0,i=0);var r=e.getCache().getFromCachedMap2D("barWidth",t,i);if(null!=r)return r;var s=d.getZVal(e,t,i,1)/e.getOptions()._averageGroupZ;return r=Math.min(s*c.getGroupWidth(e),c.getMaxBarWidth(e)),e.getCache().putToCachedMap2D("barWidth",t,i,r),r},getBarStackWidth:(e,t,i,r)=>{e.getOptionsCache().getFromCache("hasConstantZValue")&&(i=0);var s=r?"y2BarStackWidth":"yBarStackWidth",a=e.getCache().getFromCachedMap2D(s,t,i);if(null!=a)return a;var n=d.getBarCategoryZ(e,t,i,r)/e.getOptions()._averageGroupZ;return a=Math.min(n*c.getGroupWidth(e),c.getMaxBarWidth(e)),e.getCache().putToCachedMap2D(s,t,i,a),a},getBarCategoryOffsetMap:(e,t)=>{e.getOptionsCache().getFromCache("hasConstantZValue")&&(t=0);var i=e.getCache().getFromCachedMap("barCategoryOffsetMap",t);if(i)return i;var r,s,a=d.isStacked(e),n=d.getStackCategories(e,"bar"),o=l.isMixedFrequency(e),h=d.isSplitDualY(e),g={},u={},_=0,p=0;if(a){for(s=0;s<n.y.length;s++)r=c.getBarStackWidth(e,n.y[s],t,!1),o?g[n.y[s]]=-.5*r:(g[n.y[s]]=_,_+=r);for(h||(p=_),s=0;s<n.y2.length;s++)r=c.getBarStackWidth(e,n.y2[s],t,!0),o?u[n.y2[s]]=-.5*r:(u[n.y2[s]]=p,p+=r);h||(_=p)}else for(var v=d.getSeriesCount(e),m=0;m<v;m++){var f=d.getSeriesType(e,m);if(("bar"==f||"candlestick"==f||"boxPlot"==f)&&d.isSeriesRendered(e,m)){var x=d.isAssignedToY2(e,m),C=d.getStackCategory(e,m);r=c.getBarWidth(e,m,t),x?o?u[C]=-.5*r:(u[C]=p,p+=r):o?g[C]=-.5*r:(g[C]=_,_+=r)}}for(var S in g)g[S]-=h||a?_/2:(_+p)/2;for(var A in u)u[A]-=h||a?p/2:(_+p)/2-_;return i={y:g,y2:u},e.getCache().putToCachedMap("barCategoryOffsetMap",t,i),i},getDataItemGaps:e=>{var t=e.getOptionsCache().getFromCache("dataItemGaps");if(null!=t)return t;var i=e.getOptions();if(null!=i.styleDefaults.sliceGaps)t=i.styleDefaults.sliceGaps;else{var r=i.styleDefaults.dataItemGaps;"auto"==r&&(r="on"==i.styleDefaults.threeDEffect?"0%":"50%");var s=r&&r.indexOf?r.indexOf("%"):-1;t=s>=0?(r=r.substring(0,s))/100:0}return e.getOptionsCache().putToCache("dataItemGaps",t),t},isSelectable:(e,t,i)=>{var r=d.getSeriesItem(e,t);return(!r||"off"!=r._selectable)&&(e.isSelectionSupported()&&null!=t&&t>=0&&null!=i&&i>=0)},getAnimOnDisplay:e=>e.getOptions().animationOnDisplay,getAnimOnDataChange:e=>e.getOptions().animationOnDataChange,getAnimDur:e=>t.CSSStyle.getTimeMilliseconds(e.getOptions().styleDefaults.animationDuration)/1e3,getAnimIndicators:e=>e.getOptions().styleDefaults.animationIndicators,getAnimUpColor:e=>e.getOptions().styleDefaults.animationUpColor,getAnimDownColor:e=>e.getOptions().styleDefaults.animationDownColor,getSelectedInnerColor:e=>e.getOptions().styleDefaults.selectedInnerColor,getSelectedOuterColor:e=>e.getOptions().styleDefaults.selectedOuterColor,isSelectionHighlighted:e=>{var t=e.getOptions().styleDefaults.selectionEffect;return"highlight"==t||"highlightAndExplode"==t},isSelectionExploded:e=>{var t=e.getOptions().styleDefaults.selectionEffect;return"explode"==t||"highlightAndExplode"==t},getDataLabelStyle:(e,i,r,s,a,n,o)=>{var h,g=e.getOptions().styleDefaults,u=[g._dataLabelStyle,g.dataLabelStyle];!a||"bar"!=d.getSeriesType(e,i)&&!l.isBubble(e)||"center"!=n&&"inBottom"!=n&&"inTop"!=n&&"inRight"!=n&&"inLeft"!=n||(h=null!=c.getPattern(e,i,r,s)?"#000000":t.ColorUtils.getContrastingTextColor(a),u.push(new t.CSSStyle("color: "+h+";"))),u.push(c._parseLowHighArray(e.getOptions().styleDefaults.dataLabelStyle,o));var _=d.getDataItem(e,i,r);_&&u.push(new t.CSSStyle(c._parseLowHighArray(_.labelStyle,o)));var p=d.getNestedDataItem(e,i,r,s);return p&&u.push(new t.CSSStyle(c._parseLowHighArray(p.labelStyle,o))),h&&t.Agent.isHighContrast()&&u.push(new t.CSSStyle("color: "+h+";")),t.CSSStyle.mergeStyles(u)},getDataLabelCollisions:(e,t,i,r,s)=>{var a=t&&t.x&&t.x-i.w/2||i.x,n=t&&t.y&&t.y-i.h/2||i.y,o=c.MARKER_DATA_LABEL_GAP/2,l=e.getOptions(),h=s?u.getGapHeight(e,l.layout.legendGapHeight):u.getGapWidth(e,l.layout.legendGapWidth);return{xAxis:n+i.h+o>r.y+r.h,yAxis:a+o<r.x,y2Axis:a+i.w+o>r.x+r.w,legend:a+i.w+o>r.x+r.w+h,top:n<e.getDimensions().y}},adjustDataLabelPos:(e,t,i)=>{var r=e;return"left"!=e&&"center"!=e||!t.yAxis?"right"!=e&&"center"!=e||!(i&&t.y2Axis||t.legend)?"top"!=e&&"center"!=e||!t.top?"bottom"!=e&&"center"!=e||!t.xAxis||(r="top"):r="bottom":r="left":r="right",r},_parseLowHighArray:(e,t)=>e instanceof Array?"high"==t?e[1]:e[0]:e,isOverviewRendered:e=>{var t=e.getOptions();return l.isOverviewSupported(e)&&"off"!=t.overview.rendered},getOverviewHeight:e=>{var t=e.getOptions().overview.height;return null==t&&(t=l.hasTimeAxis(e)?.25:.2),c.getSizeInPixels(t,e.getHeight())},getSizeInPixels:(e,t)=>{if("string"==typeof e){if("%"==e.slice(-1))return t*Number(e.slice(0,-1))/100;if("px"==e.slice(-2))return Number(e.slice(0,-2));e=Number(e)}return"number"==typeof e?e<=1?t*e:e:0},getBackgroundColor:(e,t)=>{var i=e.getOptions();return i.plotArea.backgroundColor?i.plotArea.backgroundColor:t?"#FFFFFF":null},getHoverBehaviorDelay:e=>{var i=e.getOptions().styleDefaults.hoverBehaviorDelay;return i?(i=t.CSSStyle.getTimeMilliseconds(i),l.isScatterBubble(e)||l.isLine(e)?.75*i:1.25*i):0},optimizeMarkerStroke:e=>l.isScatterBubble(e)||l.isBoxPlot(e),getGroupWidth:e=>{var t=e.getCache().getFromCache("groupWidth");return null==t&&(t=e.xAxis.getInfo().getGroupWidth(),e.getCache().putToCache("groupWidth",t)),t},isStackLabelRendered:e=>{var t=e.getOptions();return"on"==t.stack&&!l.isMixedFrequency(e)&&("on"===t.stackLabel&&l.isBLAC(e))},optimizeMarkerFill:e=>l.isLineArea(e),getClassName:(e,t,i)=>{var r=d.getDataItem(e,t,i);if(r&&(r.className||r.svgClassName))return r.className||r.svgClassName;var s=d.getSeriesItem(e,t);return s&&(s.className||s.svgClassName)?s.className||s.svgClassName:null},getAreaClassName:(e,t)=>{var i=d.getSeriesItem(e,t);return i&&(i.areaClassName||i.areaSvgClassName)?i.areaClassName||i.areaSvgClassName:i&&(i.className||i.svgClassName)?i.className||i.svgClassName:null},getMarkerClassName:(e,t,i,r)=>{var s=d.getNestedDataItem(e,t,i,r);if(s&&(s.className||s.svgClassName))return s.className||s.svgClassName;var a=d.getDataItem(e,t,i);if(a&&(a.className||a.svgClassName))return a.className||a.svgClassName;var n=d.getSeriesItem(e,t);return n&&(n.markerClassName||n.markerSvgClassName)?n.markerClassName||n.markerSvgClassName:l.isScatterBubble(e)&&n&&(n.className||n.svgClassName)?n.className||n.svgClassName:null},getStyle:(e,t,i)=>{var r=d.getDataItem(e,t,i);if(r&&(r.style||r.svgStyle))return r.style||r.svgStyle;var s=d.getSeriesItem(e,t);return s&&(s.style||s.svgStyle)?s.style||s.svgStyle:null},getAreaStyle:(e,t)=>{var i=d.getSeriesItem(e,t);return i&&(i.areaStyle||i.areaSvgStyle)?i.areaStyle||i.areaSvgStyle:i&&(i.style||i.svgStyle)?i.style||i.svgStyle:null},getMarkerStyle:(e,t,i,r)=>{var s=d.getNestedDataItem(e,t,i,r);if(s&&(s.style||s.svgStyle))return s.style||s.svgStyle;var a=d.getDataItem(e,t,i);if(a&&(a.style||a.svgStyle))return a.style||a.svgStyle;var n=d.getSeriesItem(e,t);return n&&(n.markerStyle||n.markerSvgStyle)?n.markerStyle||n.markerSvgStyle:l.isScatterBubble(e)&&n&&(n.style||n.svgStyle)?n.style||n.svgStyle:null},getBoxPlotStyleOptions:(e,i,r)=>{var s=d.getDataItem(e,i,r),a=s&&s.boxPlot?s.boxPlot:{},n=d.getSeriesItem(e,i),o=n&&n.boxPlot?n.boxPlot:{},l=e.getOptions().styleDefaults.boxPlot,h=t.JsonUtils.merge(a,t.JsonUtils.merge(o,l)),g=c.getColor(e,i,r);h._color=g;var u=t.ColorUtils.getBrighter(g,.8);if(h.q2Color||(h.q2Color=u),h.q3Color||(h.q3Color=u),"pattern"==c.getSeriesEffect(e)){var _=c.getPattern(e,i,r);h._q2Pattern=_,h._q3Pattern=_}var p=c.getBorderColor(e,i,r);h.borderColor=p||g,h.borderWidth=c.getBorderWidth(e,i,r);var v=t.ColorUtils.getDarker(g,.1);return c._setBoxPlotDefaultLineColor(h,"whisker",v),c._setBoxPlotDefaultLineColor(h,"whiskerEnd",v),c._setBoxPlotDefaultLineColor(h,"median",v),h},_setBoxPlotDefaultLineColor:(e,i,r)=>{var s=t.JsonUtils.merge(e[i+"Style"],e[i+"SvgStyle"]);e[i+"SvgStyle"]=s,e[i+"Style"]=null,!s||s.stroke||e[i+"ClassName"]||e[i+"SvgClassName"]||(e[i+"SvgStyle"].stroke=r)},getDataContext:(e,t,i,r)=>{var s,a=d.getSeriesItem(e,t),n=d.getDataItem(e,t,i),o=d.getNestedDataItem(e,t,i,r),h=e.getRawOptions(),g=l.isPie(e)&&(null==t||t<0),u=e.getOptions();if(g){var p=u.translations.labelOther;s={id:p,series:p,value:_.getOtherVal(e),color:u.styleDefaults.otherColor}}else if(o){var v=h.series[t].items[i];v._noTemplate?v=v._itemData:v&&"object"==typeof v&&delete(v=Object.assign({},v))._itemData,s={id:d.getNestedDataItemId(e,t,i,r),data:[v,v.items[r]],value:d.getVal(e,t,i,r),y:d.getVal(e,t,i,r),color:c.getMarkerColor(e,t,i,r),itemData:u.series[t].items[i]._itemData}}else if(n){var m=h.series[t].items[i];m._noTemplate?m=m._itemData:m&&"object"==typeof m&&delete(m=Object.assign({},m))._itemData,s={id:d.getDataItemId(e,t,i),data:m,value:d.getVal(e,t,i),targetValue:d.getTargetVal(e,t,i),x:d.getXVal(e,t,i),y:d.getVal(e,t,i),z:d.getZVal(e,t,i),low:d.getLowVal(e,t,i),high:d.getHighVal(e,t,i),open:n.open,q1:n.q1,q2:n.q2,q3:n.q3,close:n.close,volume:n.volume,color:c.getColor(e,t,i),itemData:u.series[t].items[i]._itemData}}else a&&(s={id:d.getSeries(e,t),color:c.getColor(e,t)});if(s){s.component=u._widgetConstructor,(g||o||n)&&(s.group=d.getGroup(e,i),s.groupData=d.getGroupsDataForContext(e)[i]),!g&&(o||n||a)&&(s.series=d.getSeries(e,t),s.seriesData=d.getSeriesDataForContext(e,t)),l.isPie(e)&&e.pieChart&&(s.totalValue=e.pieChart.getTotalValue());var f=e.getOptionsCache().getFromCachedMap2D("barDims",t,i);f&&(s.dimensions=f),s=e.getCtx().fixRendererContext(s)}return s||{}},getShortDescContext:(e,t,i,r)=>{if(t<0||i<0)return null;var s=d.getDataItem(e,t,i),a=e.getRawOptions(),n=e.getOptions(),o=a.series[t].items[i];return o._noTemplate?o=o._itemData:o&&"object"==typeof o&&delete(o=Object.assign({},o))._itemData,{id:d.getDataItemId(e,t,i),data:o,value:d.getVal(e,t,i),targetValue:d.getTargetVal(e,t,i),label:d.getDefaultDataLabel(e,t,i,r),totalValue:l.isPie(e)&&e.pieChart?e.pieChart.getTotalValue():null,x:d.getXVal(e,t,i),y:d.getVal(e,t,i),z:d.getZVal(e,t,i),low:d.getLowVal(e,t,i),high:d.getHighVal(e,t,i),q1:s.q1,q2:s.q2,q3:s.q3,volume:s.volume,open:s.open,close:s.close,itemData:n.series[t].items[i]._itemData,group:d.getGroup(e,i),groupData:d.getGroupsDataForContext(e)[i],series:d.getSeries(e,t),seriesData:d.getSeriesDataForContext(e,t)}},getDataLabel:(e,t,i,r,s,a)=>{var n,o=d.getDefaultDataLabel(e,t,i,r,s,a),l=e.getOptions().dataLabel;if(l&&!a){var h=c.getDataContext(e,t,i,r);if(h.label=o,"number"==typeof(n=l(h))){var g=DvtChartFormatUtils.getValueFormat(e,"label");n=DvtChartFormatUtils.formatVal(e,g,n)}}if(e.Options.stackLabelProvider&&a){var u=c.getStackLabelContext(e,i);n=e.Options.stackLabelProvider(u)}return n||o},getStackLabelContext:(e,t)=>{for(var i=d.getSeriesCount(e),r=e.getOptions(),s=[],a=[],n=0,o=d.getGroup(e,t),l=0;l<i;l++){var h=r.series[l].items[t];s.push(h),h&&a.push(h._itemData),n+=d.getVal(e,l,t)}return{groups:o,data:s,groupData:d.getGroupsDataForContext(e)[t]||[],value:n,itemData:a}},hasCenteredSeries:e=>{if(!l.isBLAC(e))return!1;for(var t=d.getSeriesCount(e),i=0;i<t;i++)if(d.isSeriesRendered(e,i)&&"bar"!=d.getSeriesType(e,i)){var r=c.getLineType(e,i);if("centeredSegmented"==r||"centeredStepped"==r)return!0}return!1},hasUncenteredSeries:e=>{if(!l.isBLAC(e))return!1;for(var t=d.getSeriesCount(e),i=0;i<t;i++)if(d.isSeriesRendered(e,i)&&"bar"!=d.getSeriesType(e,i)){var r=c.getLineType(e,i);if("segmented"==r||"stepped"==r)return!0}return!1}};class p extends t.Container{constructor(e,i,r){super(e),this._bHoriz=r,this._options=i,this.setMouseEnabled(!1),this.setVisible(!1);var s=i.lineWidth,a=i.lineColor,n=new t.Stroke(a,1,s,!1,t.Stroke.getDefaultDashProps(i.lineStyle,s));this._cursorLine=new t.Line(this.getCtx(),0,0,0,0,"dcLine"),this._cursorLine.setStroke(n),this.addChild(this._cursorLine),this._cursorOuterLine=new t.Line(this.getCtx(),0,0,0,0,"dcLine"),this._cursorOuterLine.setClassName("oj-chart-data-cursor-outer-line"),this.addChild(this._cursorOuterLine),this.addMarker(t.SimpleMarker.CIRCLE,i.markerSize)}addMarker(e,i){if("off"!==this._options.markerDisplayed){this._marker&&this.removeChild(this._marker),this._marker=new t.Container(this._context),this._marker.setMouseEnabled(!1),this.addChild(this._marker);var r=this._options.lineColor,s=this._options.lineWidth,a=new t.SimpleMarker(this._context,e,0,0,i+4*s,i+4*s);a.setSolidFill(r),this._marker.addChild(a);var n=new t.SimpleMarker(this._context,e,0,0,i+2*s,i+2*s);n.setSolidFill("white"),this._marker.addChild(n),this._markerInnerShape=new t.SimpleMarker(this._context,e,0,0,i,i),this._marker.addChild(this._markerInnerShape)}}render(e,i,r,s,a,n){var o,l=this.isHorizontal(),h=t.Agent.isRightToLeft(this.getCtx());if(null!=a&&""!=a){var g=this.getCtx().getStageAbsolutePosition(),d=this.getCtx().getTooltipManager(p.TOOLTIP_ID);d.showDatatip(i+g.x,r+g.y,a,n,!1),o=d.getTooltipBounds();var u,_,c=this._options.markerSize+4*this._options.lineWidth;l?(u=h?e.x-.75*o.w:e.x+e.w-o.w/4,_=s-o.h/2,!h&&u-i<c?u=i+c:h&&i-(u+o.w)<c&&(u=i-c-o.w)):(u=s-o.w/2,r-((_=e.y-.75*o.h)+o.h)<c&&(_=r-c-o.h)),d.positionTip(u+g.x,_+g.y),(o=d.getTooltipBounds()).x-=g.x,o.y-=g.y}var v=this._cursorLine.getStroke().getWidth(),m=s+Math.ceil(v/2);if(l){var f,x;this._cursorLine.setTranslateY(s),this._cursorOuterLine.setTranslateY(m),h?(f=o?o.x+o.w-1:e.x,x=e.x+e.w):(f=e.x,x=o?o.x+1:e.x+e.w),this._cursorLine.setX1(f),this._cursorLine.setX2(x),this._cursorOuterLine.setX1(f),this._cursorOuterLine.setX2(x)}else{this._cursorLine.setTranslateX(s),this._cursorOuterLine.setTranslateX(m);var C=o?o.y+o.h-1:e.y,S=e.y+e.h;this._cursorLine.setY1(C),this._cursorLine.setY2(S),this._cursorOuterLine.setY1(C),this._cursorOuterLine.setY2(S)}if(this._marker){this._marker.setTranslate(i,r);var A=this._options.markerColor;this._markerInnerShape.setSolidFill(A||n),t.Agent.workaroundFirefoxRepaint(this._marker)}}isHorizontal(){return this._bHoriz}getBehavior(){return this._behavior?this._behavior:"auto"}setBehavior(e){this._behavior=e}}p.TOOLTIP_ID="_dvtDataCursor";const v={getType:e=>"area"==e.type?"area":"line",getLocation:e=>"front"==e.location?"front":"back",getColor:(e,t)=>t.color?t.color:"line"===v.getType(t)?e.getOptions()._defaultReferenceObjectLineColor:e.getOptions()._defaultReferenceObjectAreaColor,getLineWidth:(e,t)=>t.lineWidth?t.lineWidth:parseFloat(e.getOptions()._defaultReferenceObjectLineWidth),getLineType:e=>e.lineType?e.lineType:"straight",isObjRendered:(e,i)=>{var r=d.getHiddenCategories(e);if(r.length>0){var s=v.getRefObjCategories(i);if(s&&t.ArrayUtils.hasAnyItem(r,s))return!1}return"hidden"!==i.visibility},getId:e=>null!=e.id?e.id:e.text,getRefObjCategories:e=>e.categories?e.categories:[v.getId(e)],getRefObj:(e,t)=>{for(var i=d.getRefObjs(e),r=0;r<i.length;r++)if(v.getId(i[r])==t)return i[r]},getLowVal:e=>null==e?null:e.low,getHighVal:e=>null==e?null:e.high,getXVal:(e,t,i)=>d.getXValFromItem(e,t[i],i)},m={getDatatipColor:(e,t,i,r)=>l.isStock(e)?c.getColor(e,0,i):null!=r&&r>=0?c.getMarkerColor(e,t,i,r):c.getColor(e,t,i),getDatatip:(e,i,r,s,a)=>{if(l.isSpark(e)||l.isOverview(e))return null;if(i<0||r<0)return null;var n=e.getOptions().tooltip,o=n?n.renderer:null;if(a&&o){var h=e.getCtx().getTooltipManager(m.isDataCursorEnabled(e)?p.TOOLTIP_ID:null),g=c.getDataContext(e,i,r,s);if(l.isPie(e)){var u=_.getSliceBySeriesIdx(e,i);g.label=u.getSliceLabelString()}else g.label=c.getDataLabel(e,i,r,s);return h.getCustomTooltip(o,g)}var v=d.getNestedDataItem(e,i,r,s);if(v&&null!=v.shortDesc)return v.shortDesc;var f,x=d.getDataItem(e,i,r);return x&&null!=x.shortDesc?t.Displayable.resolveShortDesc(x.shortDesc,()=>c.getShortDescContext(e,i,r,s)):(l.isStock(e)?f=m._getStockDatatip(e,0,r,a):(f=[],m._addSeriesDatatip(f,e,i,r,a),m._addGroupDatatip(f,e,i,r,a),m._addValDatatip(f,e,i,r,s,a)),m._processDatatip(f,e,a))},getOtherSliceDatatip:(e,t,i)=>{var r=e.getOptions().translations.labelOther,s=e.getOptions().tooltip,a=s?s.renderer:null;if(i&&a){var n=_.getSliceBySeriesIdx(e,null),o=c.getDataContext(e,null,0);return o.label=n.getSliceLabelString(),e.getCtx().getTooltipManager().getCustomTooltip(a,o)}var l=[];return m._addDatatipRow(l,e,"series","labelSeries",r,i),m._addGroupDatatip(l,e,0,0,i),m._addDatatipRow(l,e,"value","labelValue",t,i),m._processDatatip(l,e,i)},_processDatatip:(e,i,r)=>0===e.length?null:r?t.HtmlTooltipManager.createElement("table",null,e,["oj-dvt-datatip-table"]):e.join(""),getRefObjTooltip:(e,t,i,r)=>{var s=e.getOptions().tooltip,a=s?s.renderer:null;if(a&&null!=t.id){var n=e.getCtx().getTooltipManager(m.isDataCursorEnabled(e)?p.TOOLTIP_ID:null),o={id:v.getId(t),label:t.text,data:e.getRawOptions()[i].referenceObjects[r],value:t.value,low:v.getLowVal(t),high:v.getHighVal(t),color:v.getColor(e,t)};return n.getCustomTooltip(a,o)}return t.shortDesc},_getStockDatatip:(e,t,i,r)=>{var s=d.getDataItem(e,t,i),a=[];return m._addGroupDatatip(a,e,t,i,r),s&&(m._addDatatipRow(a,e,"open","labelOpen",s.open,r),m._addDatatipRow(a,e,"close","labelClose",s.close,r),m._addDatatipRow(a,e,"high","labelHigh",s.high,r),m._addDatatipRow(a,e,"low","labelLow",s.low,r),m._addDatatipRow(a,e,"volume","labelVolume",s.volume,r)),a},_addSeriesDatatip:(e,t,i,r,s)=>{var a=d.getSeriesLabel(t,i);m._addDatatipRow(e,t,"series","labelSeries",a,s)},_addGroupDatatip:(e,t,i,r,s)=>{var a;if(l.hasTimeAxis(t)){var n=g.getValueFormat(t,"group"),o=d.getXVal(t,i,r);null==(a=g.formatDateVal(n,o))&&(a=t.xAxis.getInfo().formatLabel(o))}else a=d.getGroupLabel(t,r);var h=d.getNumLevels(t),u="labelGroup";if(1!=h&&Array.isArray(a))for(var _=h-1;_>=0;_--)m._addDatatipRow(e,t,"group",u,a[_],s,_),a[_]&&(u=null);else m._addDatatipRow(e,t,"group",u,a,s)},_addValDatatip:(e,t,i,r,s,a)=>{var n=d.getVal(t,i,r,s),o=d.getXVal(t,i,r),h=d.getZVal(t,i,r),g=d.getLowVal(t,i,r),u=d.getHighVal(t,i,r),_=null!=s&&s>=0;if(l.isScatterBubble(t))m._addDatatipRow(e,t,"x","labelX",o,a),m._addDatatipRow(e,t,"y","labelY",n,a),l.isBubble(t)&&m._addDatatipRow(e,t,"z","labelZ",h,a);else if(l.isPie(t)||l.isPyramid(t))m._addDatatipRow(e,t,"value","labelValue",n,a);else if(l.isFunnel(t)){m._addDatatipRow(e,t,"value","labelValue",n,a);var c=d.getTargetVal(t,i);null!=c&&m._addDatatipRow(e,t,"targetValue","labelTargetValue",c,a)}else if("boxPlot"!=d.getSeriesType(t,i)||_){if(l.isBLAC(t)){var p=d.isAssignedToY2(t,i)?"y2":"y";null==g&&null==u||_?null==h||_?m._addDatatipRow(e,t,p,"labelValue",n,a):(m._addDatatipRow(e,t,p,"labelY",n,a),m._addDatatipRow(e,t,"z","labelZ",h,a)):(m._addDatatipRow(e,t,"high","labelHigh",u,a),m._addDatatipRow(e,t,"low","labelLow",g,a),null!=h&&m._addDatatipRow(e,t,"z","labelZ",h,a))}}else{var v=d.getDataItem(t,i,r);m._addDatatipRow(e,t,"high","labelHigh",u,a),m._addDatatipRow(e,t,"q3","labelQ3",v.q3,a),m._addDatatipRow(e,t,"q2","labelQ2",v.q2,a),m._addDatatipRow(e,t,"q1","labelQ1",v.q1,a),m._addDatatipRow(e,t,"low","labelLow",g,a),null!=h&&m._addDatatipRow(e,t,"z","labelZ",h,a)}},_addDatatipRow:(e,i,r,s,a,n,o)=>{if(null!=a&&""!==a){var h,d=i.getOptions().styleDefaults,u=g.getValueFormat(i,r),_=u.tooltipDisplay,c=i.getOptions().translations;if(_&&"auto"!=_||"group"==r&&(l.isPie(i)||l.isFunnel(i))&&(_="off"),"off"!=_)if("string"==typeof u.tooltipLabel?h=u.tooltipLabel:Array.isArray(u.tooltipLabel)&&(h=u.tooltipLabel[o||0]),null==h&&(h=null==s?"":"labelGroup"==s&&l.hasTimeAxis(i)?c.labelDate:c[s]),"series"!=r&&"group"!=r&&(a=g.formatVal(i,u,a)),n){var p=[t.HtmlTooltipManager.createElement("td",d.tooltipLabelStyle,h,["oj-dvt-datatip-label"]),t.HtmlTooltipManager.createElement("td",d.tooltipValueStyle,a,["oj-dvt-datatip-value"])];e.push(t.HtmlTooltipManager.createElement("tr",null,p))}else e.push((e.length>0?"<br>":"")+t.ResourceUtils.format(c.labelAndValue,[h,a]))}},isDataCursorEnabled:e=>{if(l.isPie(e)||l.isFunnel(e)||l.isPolar(e)||l.isPyramid(e))return!1;var i=e.getOptions();return"on"==i.dataCursor||"off"!=i.dataCursor&&(t.Agent.isTouchDevice()&&l.isLineArea(e))},getDataCursorBehavior:e=>{var t=e.getOptions().dataCursorBehavior;return"auto"!==t?t:l.isLineArea(e)?"smooth":"snap"}};class f{constructor(e,i,r,s,a,n){if(this._chart=e,this._displayables=i,this._seriesIndex=null!=r&&r>=0?r:-1,this._groupIndex=null!=s&&s>=0?s:-1,this._itemIndex=null!=a&&a>=0?a:-1,this._dataPos=n,this._isSelected=!1,this._isShowingKeyboardFocusEffect=!1,this._series=d.getSeries(e,r),this._group=d.getGroup(e,s),this._categories=d.getCategories(e,r,s,a),-1!=this._itemIndex)this._dataItemId=d.getNestedDataItemId(e,r,s,a),this._drillable=d.isDataItemDrillable(e,r,s,a);else if(-1!=this._groupIndex){d.getDataItem(e,r,s)&&(this._dataItemId=d.getDataItemId(e,r,s),this._drillable=d.isDataItemDrillable(e,r,s))}else{d.getSeriesItem(e,r)&&(this._drillable=d.isSeriesDrillable(e,r))}if(this._drillable)for(var o=0;o<this._displayables.length;o++)this._displayables[o].setCursor(t.SelectionEffectUtils.getSelectingCursor());for(var l=0;l<i.length;l++){var h=i[l];"lineArea"!==h.chartShapeType&&h.setAriaRole("img"),this._updateAriaLabel(h)}}static associate(e,t,i,r,s,a){if(e&&!t.getOptions()._duringZoomAndScroll){var n=new f(t,[e],i,r,s,a);t.registerObject(n),t.getEventManager().associate(e,n)}}getId(){return this._seriesIndex>=0&&this._groupIndex>=0?new o(this._dataItemId,this.getSeries(),this.getGroup(),this._chart.getCtx()):this._seriesIndex>=0?this.getSeries():null}getDataItemId(){return this._dataItemId}getNestedDataItemIndex(){return this._itemIndex}getSeries(){return this._series}getSeriesIndex(){return this._seriesIndex}getGroup(){return this._group}getGroupIndex(){return this._groupIndex}isDrillable(){return this._drillable}isDoubleClickable(){return this.isSelectable()&&this.isDrillable()}getChart(){return this._chart}getDatatip(){return m.getDatatip(this._chart,this._seriesIndex,this._groupIndex,this._itemIndex,!0)}getDatatipColor(){return m.getDatatipColor(this._chart,this._seriesIndex,this._groupIndex,this._itemIndex)}isSelectable(){return c.isSelectable(this.getChart(),this.getSeriesIndex(),this.getGroupIndex())}isSelected(){return this._isSelected}setSelected(e){this._isSelected=e;for(var t=0;t<this._displayables.length;t++)this._displayables[t].setSelected&&(this._displayables[t].setSelected(e),this._updateAriaLabel(this._displayables[t]))}showHoverEffect(){for(var e=0;e<this._displayables.length;e++)this._displayables[e].showHoverEffect&&this._displayables[e].showHoverEffect()}hideHoverEffect(){for(var e=0;e<this._displayables.length;e++)this._displayables[e].hideHoverEffect&&this._displayables[e].hideHoverEffect()}getDisplayables(){return this._displayables}getAriaLabel(){var e=[],i=this.getChart().getOptions().translations;this.isSelectable()&&e.push(i[this.isSelected()?"stateSelected":"stateUnselected"]),this.isDrillable()&&e.push(i.stateDrillable);var r=m.getDatatip(this._chart,this._seriesIndex,this._groupIndex,this._itemIndex,!1);return null==r&&this._groupIndex<0&&e.length>0&&(r=d.getSeriesLabel(this._chart,this._seriesIndex)),t.Displayable.generateAriaLabel(r,e,()=>c.getShortDescContext(this._chart,this._seriesIndex,this._groupIndex,this._itemIndex,!1))}_updateAriaLabel(e){t.Agent.deferAriaCreation()||e.setAriaProperty("label",this.getAriaLabel())}getCategories(e){return this._categories}getDataPosition(){return this._dataPos}getNextNavigable(e){var i,r;if(i=e.keyCode,e.type==t.MouseEvent.CLICK)return this;if(i==t.KeyboardEvent.SPACE&&e.ctrlKey)return this;for(var s=this._chart,a=s.getChartObjPeers(),n=[],o=0;o<a.length;o++)a[o].isNavigable()&&n.push(a[o]);var h=e.keyCode==t.KeyboardEvent.UP_ARROW||e.keyCode==t.KeyboardEvent.DOWN_ARROW,g=l.isHorizontal(s),u=t.Agent.isRightToLeft(s.getCtx());return l.isScatterBubble(s)||l.isBoxPlot(s)&&(h&&!g||!h&&g)?r=t.KeyboardHandler.getNextAdjacentNavigable(this,e,n):l.isLineArea(s)||d.isStacked(s)||l.isPolar(s)?r=this._findNextNavigable(e):l.isFunnel(s)&&h?(e.keyCode=u?e.keyCode==t.KeyboardEvent.UP_ARROW?t.KeyboardEvent.RIGHT_ARROW:t.KeyboardEvent.LEFT_ARROW:e.keyCode-1,r=t.KeyboardHandler.getNextNavigable(this,e,n)):l.isPyramid(s)&&!h?(e.keyCode=u?e.keyCode==t.KeyboardEvent.RIGHT_ARROW?t.KeyboardEvent.DOWN_ARROW:t.KeyboardEvent.UP_ARROW:e.keyCode==t.KeyboardEvent.RIGHT_ARROW?t.KeyboardEvent.UP_ARROW:t.KeyboardEvent.DOWN_ARROW,r=t.KeyboardHandler.getNextNavigable(this,e,n)):r=t.KeyboardHandler.getNextNavigable(this,e,n,!0),r}getKeyboardBoundingBox(e){return this._displayables[0]?this._displayables[0].getDimensions(e):new t.Rectangle(0,0,0,0)}getTargetElem(){return this._displayables[0]?this._displayables[0].getElem():null}showKeyboardFocusEffect(){this.isNavigable()&&(this._isShowingKeyboardFocusEffect=!0,this.showHoverEffect())}hideKeyboardFocusEffect(){this.isNavigable()&&(this._isShowingKeyboardFocusEffect=!1,this.hideHoverEffect())}isShowingKeyboardFocusEffect(){return this._isShowingKeyboardFocusEffect}isNavigable(){return-1!=this.getGroupIndex()&&-1!=this.getSeriesIndex()}_findNextNavigable(e){var i,r,s=e.keyCode,a=this._chart,n=a.getCtx(),o=this.getSeriesIndex(),h=this.getGroupIndex(),g=d.getGroupCount(a),u=l.isHorizontal(a),_=l.isPolar(a),c=t.Agent.isRightToLeft(n),p=u?c?s==t.KeyboardEvent.LEFT_ARROW:s==t.KeyboardEvent.RIGHT_ARROW:s==t.KeyboardEvent.UP_ARROW,v=u?c?s==t.KeyboardEvent.RIGHT_ARROW:s==t.KeyboardEvent.LEFT_ARROW:s==t.KeyboardEvent.DOWN_ARROW,m=u?s==t.KeyboardEvent.UP_ARROW:c?s==t.KeyboardEvent.RIGHT_ARROW:s==t.KeyboardEvent.LEFT_ARROW,f=u?s==t.KeyboardEvent.DOWN_ARROW:c?s==t.KeyboardEvent.LEFT_ARROW:s==t.KeyboardEvent.RIGHT_ARROW;if(p)r=h,i=this._findNextUpSeries(a,o,h);else if(v)r=h,i=this._findNextDownSeries(a,o,h);else if(f){i=o,r=h;do{r++,_&&r>=g&&(r=0)}while(null==a.getObject(i,r)&&r<g)}else if(m){i=o,r=h;do{r--,_&&r<0&&(r=g-1)}while(null==a.getObject(i,r)&&r>-1)}var x=a.getObject(i,r);return x&&x.isNavigable()?x:this}_findNextUpSeries(e,t,i){for(var r=d.isStacked(e),s=d.getSeriesCount(e),a=d.getCumulativeVal(e,t,i),n=null,o=null,l=0;l<s;l++)if(d.isSeriesRendered(e,l)&&null!=d.getVal(e,l,i)&&(!r||null!=e.getObject(l,i))){var h=d.getCumulativeVal(e,l,i);(h>a||h==a&&l>t)&&(null!==n&&h<n||null==n)&&(n=h,o=l)}return o}_findNextDownSeries(e,t,i){for(var r=d.isStacked(e),s=d.getSeriesCount(e),a=d.getCumulativeVal(e,t,i),n=null,o=null,l=s-1;l>=0;l--)if(d.isSeriesRendered(e,l)&&null!=d.getVal(e,l,i)&&(!r||null!=e.getObject(l,i))){var h=d.getCumulativeVal(e,l,i);(h<a||h==a&&l<t)&&(null!==n&&h>n||null==n)&&(n=h,o=l)}return o}isDragAvailable(e){return!0}getDragTransferable(){return[this.getId()]}getDragFeedback(){if(this._chart.isSelectionSupported()&&this._chart.getSelectionHandler().getSelectedCount()>1){for(var e=this._chart.getSelectionHandler().getSelection(),t=[],i=0;i<e.length;i++)t=t.concat(e[i].getDisplayables());return t}return this._displayables}}class x{constructor(e,t,i,r,s){this._chart=e,this._displayables=t,this._refObj=i,this._categories=v.getRefObjCategories(this._refObj),this._index=r,this._axisType=s;for(var a=0;a<t.length;a++){var n=t[a];n.setAriaRole("img"),n.setAriaProperty("label",i.shortDesc)}}getCategories(){return this._categories}getDisplayables(){return this._displayables}getIndex(){return this._index}getAxisType(){return this._axisType}getDatatip(){return m.getRefObjTooltip(this._chart,this._refObj,this._axisType,this._index)}getDatatipColor(){return v.getColor(this._chart,this._refObj)}}class C extends t.BaseComponentDefaults{constructor(e){super({alta:{position:null,baselineScaling:"zero",axisLine:{lineColor:"#9E9E9E",lineWidth:1,rendered:"on"},majorTick:{lineColor:"rgba(196,206,215,0.4)",baselineColor:"auto",lineWidth:1,rendered:"auto",lineStyle:"solid"},minorTick:{lineColor:"rgba(196,206,215,0.2)",lineWidth:1,rendered:"off",lineStyle:"solid"},tickLabel:{scaling:"auto",style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_11+"color: #333333;"),rotation:"auto",rendered:"on"},titleStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color: #737373;"),startGroupOffset:0,endGroupOffset:0,layout:{titleGap:6,radialLabelGap:5,insideLabelGapWidth:4,insideLabelGapHeight:2,hierarchicalLabelGapHeight:8,hierarchicalLabelGapWidth:15},_locale:"en-us"}},e)}getNoCloneObject(){return{tickLabel:{converter:!0}}}static getGapSize(e,i,r){var s=Math.min(t.TextUtils.getTextStringHeight(e,i.tickLabel.style)/14,1);return Math.ceil(r*s)}}class S extends i.BaseAxisInfo{constructor(e,t,i){super(e,t,i),this._title=null}getLabels(e,t){return null}getTitle(){return this._title}setTitle(e){this._title=e}getMajorTickCoords(){return[]}getMinorTickCoords(){return[]}getBaselineCoord(){return null}getDatatip(e,t){return null}getLabelBackground(e,t){return null}isDrillable(e){return null}isLabelRotated(){return!1}CreateLabel(e,i,r,s,a){var n;if("tangential"==this.Position){var o=16/180*Math.PI,l=1/180*Math.PI,h=.5*this.getTickLabelHeight(),g=this._radius+h;(r<l||r>2*Math.PI-l)&&(g+=h);var d=Math.round(g*Math.sin(r)),u=Math.round(-g*Math.cos(r));n=s?new t.BackgroundOutputText(e,i,d,u,s):new t.OutputText(e,i,d,u),r<l||Math.abs(r-Math.PI)<l||r>2*Math.PI-l?n.alignCenter():r<Math.PI?n.alignLeft():n.alignRight(),Math.abs(r-Math.PI/2)<o||Math.abs(r-3*Math.PI/2)<o?n.alignMiddle():r<Math.PI/2||r>3*Math.PI/2?n.alignBottom():n.alignTop()}else a?n=s?new t.BackgroundMultilineText(e,i,r,r,s):new t.MultilineText(e,i,r,r):(n=s?new t.BackgroundOutputText(e,i,r,r,s):new t.OutputText(e,i,r,r)).alignMiddle(),n.alignCenter();return(n instanceof t.OutputText||n instanceof t.MultilineText)&&n.setCSSStyle(this.Options.tickLabel.style),n}IsOverlapping(e,i,r){if(!e||e.length<=0)return!1;for(var s,a,n,o,l="left"==this.Position||"right"==this.Position||"radial"==this.Position,h=t.Agent.isRightToLeft(this.getCtx()),g=this.GetTickLabelGapSize(),d=0;d<e.length;d+=i+1)if(null!=e[d]){if(null!=r&&e[d].w>r[d])return!0;if(null!=s&&null!=a){if(l){if(n=e[d].y,o=e[d].y+e[d].h,n>=s&&n-g<a)return!0;if(n<s&&o+g>s)return!0}else{if(n=e[d].x,o=e[d].x+e[d].w,!h&&n-g<a)return!0;if(h&&o+g>s)return!0}s=n,a=o}else l?(s=e[d].y,a=e[d].y+e[d].h):(s=e[d].x,a=e[d].x+e[d].w)}return!1}IsOverlappingDims(e,t){if(!e||!t)return!1;var i=e.y,r=e.y+e.h,s=e.x,a=e.x+e.w,n=t.y,o=t.y+t.h,l=t.x,h=t.x+t.w;return(s<=l&&l<=a||s<=h&&h<=a||l<=s&&s<=h||l<=a&&a<=h)&&(n>=i&&n<r||n<=i&&o>=i)}GetTickLabelGapSize(){var e=this.getTickLabelHeight(),t=this instanceof S._constructors.group?.24*e:.79*e,i=this instanceof S._constructors.group?.08*e:.28*e;return"left"==this.Position||"right"==this.Position||"radial"==this.Position||this.isLabelRotated()?i:t}getTickLabelHeight(){return t.TextUtils.getTextStringHeight(this.getCtx(),this.Options.tickLabel.style)}SkipLabels(e,t){for(var i=0,r=this.IsOverlapping(t,i);r;)i++,r=this.IsOverlapping(t,i);if(i>0){for(var s=[],a=0;a<e.length;a+=i+1)s.push(e[a]);return s}return e}SkipTangentialLabels(e,t){var i=[],r=e.length,s=null;if(r>1){for(var a,n=0;n<r;n++)t[n]&&(!a||a&&!this.IsOverlappingDims(a,t[n]))&&(s||(s=t[n]),i.push(e[n]),a=t[n]);return this.IsOverlappingDims(a,s)&&i.pop(),i}return e}GetLabelDims(e,t,i){for(var r=[],s=this.isLabelRotated(i),a=0;a<e.length;a++){var n=e[a];if(null!=n){var o=n.getDimensions(t);null!=i&&(o.x=(s?n.getTranslateX():n.getX())-o.w/2,o.y=(s?n.getTranslateY():n.getY())-o.h/2),o.w&&o.h?r.push(o):r.push(null)}else r.push(null)}return r}getMajorTickCount(){return null}getMinorTickCount(){return null}getMajorIncrement(){return null}getMinorIncrement(){return null}getGlobalMin(){return this.GlobalMin}getGlobalMax(){return this.GlobalMax}getViewportMin(){return this.MinValue}getViewportMax(){return this.MaxValue}getDataMin(){return this.DataMin}getDataMax(){return this.DataMax}getMinExtent(){return 0}getStartCoord(){return this.StartCoord}getEndCoord(){return this.EndCoord}getStartOverflow(){return this.StartOverflow}getEndOverflow(){return this.EndOverflow}getGroupWidth(){return 0}getGroup(e,t){return null}linearToActual(e){return e}actualToLinear(e){return e}alignLogScaleToTickCount(e,t){return e}getLogScaleUnit(){return null}static registerConstructor(e,t){S._constructors[e]=t}static getConstructor(e){return S._constructors[e]}static newInstance(e,t,i){return t.timeAxisType&&"disabled"!=t.timeAxisType?new S._constructors.time(e,t,i):t._isGroupAxis?new S._constructors.group(e,t,i):new S._constructors.data(e,t,i)}}S._constructors=[];class A extends t.SimpleObjPeer{constructor(e,i,r,s,a,n,o){super(a,n,null,o),this._axis=e,this._label=i,this._group=r,this._drillable=s,this._drillable&&i.setCursor(t.SelectionEffectUtils.getSelectingCursor()),e.__registerObject(this)}getLabel(){return this._label}getId(){return this._group}isDrillable(){return this._drillable}getGroup(){return this._group}getNextNavigable(e){if(e.type==t.MouseEvent.CLICK)return this;var i=this._axis.__getKeyboardObjects();return t.KeyboardHandler.getNextNavigable(this,e,i,!1,this._axis.getCtx().getStage())}getKeyboardBoundingBox(e){return this._label?this._label.getDimensions(e):new t.Rectangle(0,0,0,0)}getDisplayable(){return this._label}getTargetElem(){return this._label?this._label.getElem():null}showKeyboardFocusEffect(){if(this._isShowingKeyboardFocusEffect=!0,this._label){var e=this.getKeyboardBoundingBox();this._overlayRect=new t.Rect(this._axis.getCtx(),e.x,e.y,e.w,e.h),this._overlayRect.setSolidStroke(t.Agent.getFocusColor()),this._overlayRect.setInvisibleFill(),this._overlayRect.setMatrix(this._label.getMatrix()),this._axis.addChild(this._overlayRect)}}hideKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!1,this._label&&(this._axis.removeChild(this._overlayRect),this._overlayRect=null)}isShowingKeyboardFocusEffect(){return this._isShowingKeyboardFocusEffect}getAriaLabel(){var e;return this.isDrillable()&&(e=[this._axis.getOptions().translations.stateDrillable]),null!=this.getDatatip()?t.Displayable.generateAriaLabel(this.getDatatip(),e):null!=e?t.Displayable.generateAriaLabel(this.getLabel().getTextString(),e):void 0}isDragAvailable(e){return!0}getDragTransferable(e,t){return[this.getId()]}getDragFeedback(e,t){return[this.getDisplayable()]}}class b extends t.EventManager{constructor(e){super(e.getCtx(),e.processEvent,e,e),this._axis=e}OnClick(e){super.OnClick(e);var t=this.GetLogicalObject(e.target);t&&(this.processDrillEvent(t)&&e.stopPropagation())}HandleTouchClickInternal(e){var t=this.GetLogicalObject(e.target);if(t){var i=e.touchEvent;this.processDrillEvent(t)&&i&&i.preventDefault()}}processDrillEvent(e){return!!(e instanceof A&&e.isDrillable())&&(this.FireEvent(t.EventFactory.newChartDrillEvent(e.getId(),null,e.getGroup(),"group"),this._axis),!0)}isDndSupported(){return!0}GetDragSourceType(){var e=this.DragSource.getDragObject();return e instanceof A&&null!=e.getGroup()?"groups":null}GetDragDataContexts(e){var i=this.DragSource.getDragObject();if(i instanceof A){var r={id:i.getId(),group:i.getGroup(),label:i.getLabel().getTextString()};return e&&t.ToolkitUtils.cleanDragDataContext(r),[r]}return[]}static getUIParams(e,t,i,r){return{type:e,id:t,index:i,level:r}}}const y={_MAX_TITLE_LINE_WRAP:3,getPreferredSize:(e,i,r,s)=>{var a=y._createAxisInfo(e,new t.Rectangle(0,0,i,r)),n=e.getCtx(),o=e.getOptions(),l="top"==o.position||"bottom"==o.position;if(("off"==o.rendered||i<=0||r<=0)&&!s)return l?new t.Dimension(i,0):new t.Dimension(0,r);var h=y.getTitleHeight(n,o,.8*(l?i:r),.8*(l?r:i)),g=0!=h?h+y._getTitleGap(e):0;if("on"==o.tickLabel.rendered&&"inside"!=o.tickLabel.position)if(l){var d=t.TextUtils.getTextStringHeight(n,o.tickLabel.style);a instanceof S.getConstructor("data")?g+=d:a instanceof S.getConstructor("time")?g+=null!=a.getLabels(n,1)?2*d:d:a instanceof S.getConstructor("group")&&(g=y._getGroupAxisPreferredSize(e,a,g,r,l))}else if(a instanceof S.getConstructor("data"))g+=t.TextUtils.getMaxTextStringWidth(n,a.getAllLabels(n,!0),a.Options.tickLabel.style);else if(a instanceof S.getConstructor("time")){var u=a.getLabels(n),_=t.TextUtils.getMaxTextDimensions(u).w,c=a.getLabels(n,1),p=null!=c?t.TextUtils.getMaxTextDimensions(c).w:0;g+=Math.max(_,p)}else a instanceof S.getConstructor("group")&&(g=y._getGroupAxisPreferredSize(e,a,g,i,l));return l?new t.Dimension(i,Math.min(g,r)):new t.Dimension(Math.min(g,i),r)},render:(e,t)=>{var i=y._createAxisInfo(e,t);"off"!=e.getOptions().rendered&&(e.__setBounds(t.clone()),y._renderBackground(e,t),y._renderTitle(e,i,t),y._renderLabels(e,i,t))},_createAxisInfo:(e,t)=>{var i=S.newInstance(e.getCtx(),e.getOptions(),t);return e.__setInfo(i),i},_getTitleGap:e=>{var t=e.getOptions();return C.getGapSize(e.getCtx(),t,t.layout.titleGap)},_renderBackground:(e,i)=>{var r=e.getOptions();if(r.dnd){var s=r.dnd.drop,a=Object.keys(s.xAxis).length>0||Object.keys(s.yAxis).length>0||Object.keys(s.y2Axis).length>0,n=r.dnd.drag,o=Object.keys(n.groups).length>0&&e.getInfo()instanceof S.getConstructor("group");if(a||o){var l=r.position,h="top"==l||"bottom"==l,g=h?4:10,d=h?10:4,u=new t.Rect(e.getCtx(),i.x-d,i.y-g,i.w+2*d,i.h+2*g);o&&u.setClassName("oj-draggable"),u.setInvisibleFill(),e.getCache().putToCache("background",u),e.addChild(u)}}},_renderTitle:(e,i,r)=>{var s=e.getOptions();if(s.title){var a=s.position;if("radial"!==a&&"tangential"!==a){var n="top"===s.position||"bottom"===s.position,o=n?r.w:r.h,l=n?r.h:r.w,h=s.titleStyle,g=y.isWrapEnabled(h),d=y._createText(e.getEventManager(),e,s.title,h,0,0,o,l,b.getUIParams("title"),g);if(d){var u=y._getTitleGap(e),_=(i.getStartOverflow()-i.getEndOverflow())/2,c=t.Agent.isRightToLeft(e.getCtx()),p=d.getDimensions().h;d.alignCenter(),"top"===a?(d.setX(r.x+_+r.w/2),d.setY(r.y),r.y+=p+u,r.h-=p+u):"bottom"===a?(d.setX(r.x+_+r.w/2),d.setY(r.y+r.h-p),r.h-=p+u):"left"===a?(d.alignMiddle(),d.setRotation(c?Math.PI/2:3*Math.PI/2),d.setTranslate(r.x+p/2,r.y+r.h/2),r.x+=p+u,r.w-=p+u):"right"===a&&(d.alignMiddle(),d.setRotation(c?Math.PI/2:3*Math.PI/2),d.setTranslate(r.x+r.w-p/2,r.y+r.h/2),r.w-=p+u),i.setTitle(d)}}}},_renderLabels:(e,t,i)=>{var r=e.getOptions();if("on"==r.tickLabel.rendered){var s=r.position;"top"===s||"bottom"===s?y._renderLabelsHoriz(e,t,i):"tangential"===s?y._renderLabelsTangent(e,t,i):y._renderLabelsVert(e,t,i),y._renderGroupSeparators(e,t,i)}},_renderLabelsHoriz:(e,i,r)=>{var s=e.getCtx(),a=e.getOptions(),n=a.position,o="inside"==a.tickLabel.position,l=t.Agent.isRightToLeft(s),h=i instanceof S.getConstructor("group"),g=h&&i.getNumLevels()>1,d=g?0:null,u=i.getLabels(s,d);for(f=g?C.getGapSize(s,a,a.layout.hierarchicalLabelGapHeight):0;u;){for(var _=0,c=0,p=0;p<u.length;p++){var v=u[p];if(null!=v){var m=v instanceof t.MultilineText||v instanceof t.BackgroundMultilineText;if(i.isLabelRotated(d)){if((!m||m&&!v.isWrapEnabled())&&!t.TextUtils.fitText(v,r.h,r.w,e))continue;l?v.alignLeft():v.alignRight(),g?(_=v.getDimensions().w,v.setTranslateY(r.h-_),c=Math.max(c,_)):v.setTranslateY(r.y)}else{if(!o&&v.getDimensions().h-1>r.h)continue;if(g&&"bottom"===n?v.setY(r.h):"bottom"===n?v.setY(r.y):v.setY(r.y+r.h),!g&&("bottom"===n&&!o||"top"===n&&o)||g&&"top"===n?v.alignTop():v.alignBottom(),g)c=Math.max(c,v.getDimensions().h);else if(o){var f=C.getGapSize(s,a,a.layout.insideLabelGapWidth);l?v.alignRight():v.alignLeft(),v.setX(v.getX()+f*(l?-1:1))}}var x=h?i.getLabelIdx(v):p,y=i.getDatatip(x,d),M=v.getUntruncatedTextString(),D=i.isDrillable(x,d),T=i.getGroup(x,d),I=b.getUIParams("tickLabel",v.getTextString(),x,d);e.getEventManager().associate(v,new A(e,v,T,D,M,y,I)),g?i.setLastRenderedLevel(d):c=Math.max(c,v.getDimensions().h),e.addChild(v)}}if(g){for(p=0;p<u.length;p++)if(null!=(v=u[p])){var O=i.isLabelRotated(d),E=d<i.getNumLevels()-1;!O&&E?(v.setY(r.h-c/2),v.alignMiddle()):v.setTranslateY(r.h-c)}r.y+=c+f,r.h-=c+f,d++,u=i.getLabels(e.getCtx(),d)}else r.y+=c,r.h-=c,u=null}if(i instanceof S.getConstructor("time")){u=i.getLabels(e.getCtx());var P=i.getLabels(e.getCtx(),1),L=0;if(null!=P)for(p=0;p<P.length;p++)if(null!=(v=P[p])&&!(v.getDimensions().h-1>r.h)){e.getEventManager().associate(v,new t.SimpleObjPeer(null,null,null,b.getUIParams("tickLabel",v.getTextString())));var w=0,R=0,k=i.getOptions()._maxOverflowCoord,B=i.getOptions()._minOverflowCoord;if(null!=u[p]&&(L=u[p].getDimensions().w/2,w=i._level1Overflow[p],R=i._level2Overflow[p]),0==w&&0==R){var F,N=v.getX();l?(F=N+L<=k?N+L:k,v.setX(F)):(F=N-L>=B?N-L:B,v.setX(F))}else w<0?v.setX(B):w>0&&v.setX(k);v.alignTop(),v.setY(r.y),e.addChild(v)}}},_renderLabelsVert:(e,i,r)=>{var s,a,n,o=e.getOptions(),l=o.position,h=e.getCtx(),g=t.Agent.isRightToLeft(h),d=i instanceof S.getConstructor("data"),u="inside"==o.tickLabel.position,_=i instanceof S.getConstructor("group"),c=_&&i.getNumLevels()>1,p=c?0:null;s=i.getLabels(e.getCtx(),p);var v=0;c?(a=C.getGapSize(h,o,o.layout.hierarchicalLabelGapWidth),n=t.TextUtils.getMaxTextDimensions(s).w):"radial"===l?(a=C.getGapSize(h,o,o.layout.radialLabelGap),v=r.x+r.w/2,g?v+=a+t.TextUtils.getMaxTextDimensions(s).w:v-=a):"left"===l?(v=r.x+r.w,d&&u&&(v+=t.TextUtils.getMaxTextDimensions(s).w)):(v=r.x,d&&!u&&(v+=t.TextUtils.getMaxTextDimensions(s).w));for(var m=(a,m)=>{var f=a instanceof t.MultilineText||a instanceof t.BackgroundMultilineText,x=!f||f&&!a.isWrapEnabled();if(!(c&&t.TextUtils.getMaxTextDimensions(s).w-1>r.w)&&(c||u||!x||t.TextUtils.fitText(a,r.w,r.h,e))){m=_?i.getLabelIdx(a):m;var S=i.getDatatip(m,p),y=a.getUntruncatedTextString(),M=i.isDrillable(m,p),D=i.getGroup(m,p),T=b.getUIParams("tickLabel",a.getTextString(),m,p);if(e.getEventManager().associate(a,new A(e,a,D,M,y,S,T)),c)a.alignRight(),a.setX(g?r.w:r.x+n),i.setLastRenderedLevel(p);else if(a.setX(v),d||"right"!=l?a.alignRight():a.alignLeft(),u&&(a.alignBottom(),a.setY(a.getY()-C.getGapSize(h,o,o.layout.insideLabelGapHeight))),"radial"===l){var I=a.getY();a.setY(r.y+r.h/2-I);var O=a.getDimensions(),E=.15*O.h,P=t.PathUtils.roundedRectangle(O.x-E,O.y,O.w+2*E,O.h,2,2,2,2),L=new t.Path(e.getCtx(),P),w=a.getCSSStyle().getStyle(t.CSSStyle.BACKGROUND_COLOR),R=I+O.h/2>i.getEndCoord()&&"circle"==e.getOptions().polarGridShape?"outside":"inside";w?L.setSolidFill(w):L.setClassName("oj-chart-polar-axis-tick-label-"+R),e.addChild(L)}e.addChild(a)}};s;){for(var f=0;f<s.length;f++){var x=s[f];null!=x&&m(x,f)}if(!c)break;r.x+=n+a,r.w-=n+a,p++,s=i.getLabels(e.getCtx(),p),n=s?t.TextUtils.getMaxTextDimensions(s).w:null}if(i instanceof S.getConstructor("time")){var y=i.getLabels(e.getCtx(),1);if(null!=y)for(f=0;f<y.length;f++)null!=(x=y[f])&&m(x,f)}},_renderLabelsTangent:(e,i,r)=>{for(var s=i.getLabels(e.getCtx()),a=0;a<s.length;a++){var n=s[a];if(null!=n){var o=r.w/2-Math.abs(n.getX()),l=r.h/2-Math.abs(n.getY());if(t.TextUtils.fitText(n,o,l,e)){var h=i instanceof S.getConstructor("group")?i.getLabelIdx(n):a,g=i.getDatatip(h),d=n.getUntruncatedTextString(),u=i.isDrillable(h),_=i.getGroup(h),c=b.getUIParams("tickLabel",n.getTextString(),h);e.getEventManager().associate(n,new A(e,n,_,u,d,g,c)),n.setTranslateX(r.x+r.w/2),n.setTranslateY(r.y+r.h/2),e.addChild(n)}}}},_createText:(e,i,r,s,a,n,o,l,h,g)=>{var d;return g?((d=new t.MultilineText(i.getCtx(),r,a,n)).setMaxLines(y._MAX_TITLE_LINE_WRAP),d.setCSSStyle(s),d.wrapText(o,l,1)):(d=new t.OutputText(i.getCtx(),r,a,n)).setCSSStyle(s),t.TextUtils.fitText(d,o,l,i)?(e.associate(d,new t.SimpleObjPeer(d.getUntruncatedTextString(),null,null,h)),d):null},_renderGroupSeparators:(e,i,r)=>{if(i instanceof S.getConstructor("group")&&i.areSeparatorsRendered()){var s=i.getNumLevels(),a=i.getSeparatorStartLevel();if(s<=1||a<=0)return;for(var n,o,l,h,g,d,u=e.getOptions(),_=u.position,c="top"==_||"bottom"==_,p=e.getCtx(),v=t.Agent.isRightToLeft(p),m=i.getSeparatorColor(),f=new t.Stroke(m,1,1),x=0,A=c?C.getGapSize(p,u,u.layout.hierarchicalLabelGapHeight):C.getGapSize(p,u,u.layout.hierarchicalLabelGapWidth),b=u.startGroupOffset,M=u.endGroupOffset,D=a;D>=0;D--){var T=i.getLabels(e.getCtx(),D),I=t.TextUtils.getMaxTextDimensions(T),O=i.isLabelRotated(D),E=O||!c?I.w:I.h;if(0!=E){var P=!1,L=null;if(D<a)for(var w=0;w<T.length;w++){var R=T[w];if(null!=R){var k=i.getLabelIdx(R),B=0==i.getLabelAt(k,D).length;if(!B){var F=B&&0==D&&(0==k||k==T.length-1),N=R&&null==T[k-1],H=R&&null==T[k+1],G=i.getStartIdx(k,D),U=i.getEndIdx(k,D);if(c){var V;if(R)V=R instanceof t.MultilineText||R instanceof t.BackgroundMultilineText?R.getYAlignCoord():R.getY(),n=i.getCoordAt(G-b),o=O?V+.5*x:V-E/2-.5*x-A,l=i.getCoordAt(U+M),h=O?V+E+x+2*A:V,B&&F||0!=P||null==n||y._addSeparatorLine(e,f,n,h,n,o),null==l||F||y._addSeparatorLine(e,f,l,h,l,o);if(!B){if(R)var Y=O?R.getDimensions().h:R.getDimensions().w;n=N&&0==L?i.getStartCoord():i.getBoundedCoordAt(G-b),N&&(N=!1);var W=i.getLabelAt(k+1,D);if(l=H&&W&&W.length>0?i.getEndCoord():i.getBoundedCoordAt(U+M),g=R?v?R.getX()+.5*Y:R.getX()-.5*Y:i.getBoundedCoordAt(U+M),d=R?v?R.getX()-.5*Y:R.getX()+.5*Y:i.getBoundedCoordAt(G-b),R)if(O)y._addSeparatorLine(e,f,n,h,l,h);else{var j=v?.5*-R.getDimensions().h:.5*R.getDimensions().h,z=v?d+j>l:d+j<l;(v?n>g-j:n<g-j)&&y._addSeparatorLine(e,f,n,h,g-j,h),z&&y._addSeparatorLine(e,f,d+j,h,l,h)}}}else R&&(n=v?R.getX()-E-.5*A:R.getX()+.5*A,o=i.getCoordAt(G-b),l=v?R.getX()+.5*A:R.getX()-E-.5*A,h=i.getCoordAt(U+M),(!B&&0==P||0==k&&B&&0!=D)&&null!=o&&y._addSeparatorLine(e,f,n,o,l,o),null==h||F||y._addSeparatorLine(e,f,l,h,n,h)),B||(o=N&&0==L?0:i.getBoundedCoordAt(G-b),N&&(N=!1),W=i.getLabelAt(k+1,D),h=H&&W&&W.length>0?i.getEndCoord():i.getBoundedCoordAt(U+M),R&&y._addSeparatorLine(e,f,l,o,l,h));P=!B&&null!=R,L=null!=R||null==R&&B}}}x=E}else x=E}}},_addSeparatorLine:(e,i,r,s,a,n)=>{var o=new t.Line(e.getCtx(),r,s,a,n);o.setStroke(i),o.setPixelHinting(!0),e.addChild(o)},_getGroupAxisPreferredSize:(e,i,r,s,a)=>{for(var n=e.getCtx(),o=e.getOptions(),l=i.getNumLevels(),h=a?"hierarchicalLabelGapHeight":"hierarchicalLabelGapWidth",g=l>1?C.getGapSize(n,o,o.layout[h]):0,d=0;d<l;d++){var u;if(i.isAutoRotate()){for(var _=[],c=[],p=i.getSkipIncrement(),v=0;v<i.getGroupCount();v+=p){_.push(i.getLabelAt(v,0));var m=i.getLabelStyleAt(v,0);m||(m=i.Options.tickLabel.style),c.push(m)}u=t.TextUtils.getMaxTextStringWidth(n,_,c)}else{var f=i.getLabels(n,d);if(a){var x=t.TextUtils.getMaxTextDimensions(f);u=i.isLabelRotated(d)?x.w:x.h}else u=t.TextUtils.getMaxTextDimensions(f).w}if(!(r+u<=s)){0==d&&(r=s);break}r+=u+g}return 0!=d&&(r-=g),r},getTitleHeight:(e,i,r,s)=>{var a=0;if(i.title)if(y.isWrapEnabled(i.titleStyle)){var n=new t.MultilineText(e,i.title,0,0);n.setMaxLines(y._MAX_TITLE_LINE_WRAP),n.setCSSStyle(i.titleStyle),n.wrapText(r,s,1),a=t.TextUtils.getTextStringHeight(e,i.titleStyle)*n.getLineCount()}else a=t.TextUtils.getTextStringHeight(e,i.titleStyle);return a},isWrapEnabled:e=>{var i=e.getStyle(t.CSSStyle.WHITE_SPACE);return"nowrap"!=i&&"noWrap"!=i}};class M extends S{constructor(e,i,r){super(e,i,r),this._MAX_LINE_WRAP=3,this._ROTATE_THRESHOLD=12;var s=t.Agent.isRightToLeft(e),a="top"==this.Position||"bottom"==this.Position;if(a&&s){var n=this.StartCoord;this.StartCoord=this.EndCoord,this.EndCoord=n}this._levelsArray=[],this._groupCount=this._generateLevelsArray(i.groups,0,this._levelsArray,0),this._numLevels=this._levelsArray.length,this._areSeparatorsRendered="off"!=i.groupSeparators.rendered,this._separatorColor=i.groupSeparators.color,this._lastRenderedLevel=null,this._drilling=i.drilling;var o=i.endGroupOffset>0?Number(i.endGroupOffset):0,l=i.startGroupOffset>0?Number(i.startGroupOffset):0;this.DataMin=0,this.DataMax=this._groupCount-1,this.GlobalMin=null==i.min?this.DataMin-l:i.min,this.GlobalMax=null==i.max?this.DataMax+o:i.max;var h=this.getGroupIndex(i.viewportStartGroup),g=this.getGroupIndex(i.viewportEndGroup);-1!=h&&(this.MinValue=h-l),-1!=g&&(this.MaxValue=g+o),null!=i.viewportMin&&(this.MinValue=i.viewportMin),null!=i.viewportMax&&(this.MaxValue=i.viewportMax),null==this.MinValue&&(this.MinValue=this.GlobalMin),null==this.MaxValue&&(this.MaxValue=this.GlobalMax),this.GlobalMin>this.MinValue&&(this.GlobalMin=this.MinValue),this.GlobalMax<this.MaxValue&&(this.GlobalMax=this.MaxValue),this._groupWidthRatios=i._groupWidthRatios,this._processGroupWidthRatios(),this._startBuffer=s?i.rightBuffer:i.leftBuffer,this._endBuffer=s?i.leftBuffer:i.rightBuffer,this._isLabelRotated=[];for(var d=0;d<this._numLevels;d++)this._isLabelRotated.push(!1);if(this._renderGridAtLabels=i._renderGridAtLabels,this._labels=null,this._maxSpace=a?r.h:r.w,"off"!=i.rendered){var u=y.getTitleHeight(e,i,a?r.w:r.h,a?r.h:r.w);this._maxSpace-=0!=u?u+C.getGapSize(e,i,i.layout.titleGap):0}this._maxLineWrap=this._MAX_LINE_WRAP}_processGroupWidthRatios(){if(!this._groupWidthRatios||this._groupWidthRatios.length<2)this._groupWidthRatios=null;else{for(var e,t,i=0,r=0;r<this._groupCount;r++)e=0==r?this.MinValue:Math.max(r-.5,this.MinValue),(t=r==this._groupCount-1?this.MaxValue:Math.min(r+.5,this.MaxValue))>e&&(i+=(t-e)*this._groupWidthRatios[r]);var s=this.EndCoord-this.StartCoord;this._groupWidths=this._groupWidthRatios.map(e=>e*s/i),this._borderValues=[];for(r=0;r<this._groupWidthRatios.length-1;r++)this._borderValues.push(r+.5);this._borderCoords=[];var a=Math.min(Math.max(Math.round(this.MinValue),0),this._borderValues.length-1);this._borderCoords[a]=this.StartCoord+(this._borderValues[a]-this.MinValue)*this._groupWidths[a];for(r=a+1;r<this._borderValues.length;r++)this._borderCoords[r]=this._borderCoords[r-1]+this._groupWidths[r];for(r=a-1;r>=0;r--)this._borderCoords[r]=this._borderCoords[r+1]-this._groupWidths[r+1]}}_rotateLabels(e,i,r,s){var a,n,o=this.getCtx(),l=t.Agent.isRightToLeft(o),h=this._numLevels>1;null==s&&(s=this._numLevels-1),this._isLabelRotated[s]=!0,h||this._setOverflow(r,r,e);for(var g=0;g<e.length;g++)if(null!=(a=e[g])){if(n=a.getX(),a instanceof t.MultilineText||a instanceof t.BackgroundMultilineText){var d=this.getGroupWidth()*(this.getEndIdx(g,s)-this.getStartIdx(g,s)+1);2*a.getLineHeight()<d&&this._maxSpace>0?a.wrapText(this._maxSpace,a.getLineHeight()*this._MAX_LINE_WRAP,1):a.setWrapEnabled(!1)}a.setX(0),a.setY(0),l?a.setRotation(Math.PI/2):a.setRotation(3*Math.PI/2),a.setTranslateX(n)}var u=this.GetLabelDims(e,i,s);y.isWrapEnabled(this.Options.tickLabel.style)&&this._maxSpace>0&&(this._sanitizeWrappedText(o,u,e,!0,h)&&(u=this.GetLabelDims(e,i,s)));return this.SkipLabels(e,u)}_sanitizeWrappedText(e,i,r,s,a){for(var n=this._calculateMaxWrap(i,r,s),o=0,l=0;l<r.length;l++){var h=r[l];if(h){var g=h instanceof t.MultilineText||h instanceof t.BackgroundMultilineText;n&&g&&h.isWrapEnabled()&&h.wrapText(this._maxSpace,h.getLineHeight()*this._maxLineWrap,1),a&&(o=Math.max(o,h.getDimensions().w)),h.alignMiddle()}}if(a){var d=s?this.Options.layout.hierarchicalLabelGapHeight:this.Options.layout.hierarchicalLabelGapWidth;this._maxSpace-=o+C.getGapSize(e,this.Options,d)}return n}_calculateMaxWrap(e,i,r){for(var s=!1;this.IsOverlapping(e,0)&&this._maxLineWrap>1;){s=!0;for(var a=0;a<i.length;a++){var n=i[a];if((n instanceof t.MultilineText||n instanceof t.BackgroundMultilineText)&&n.getLineCount()==this._maxLineWrap){var o=n.getLineHeight();r?e[a].w-=o:(e[a].y+=.5*o,e[a].h-=o)}}this._maxLineWrap--}return s}isLabelRotated(e){return null==e&&(e=this._numLevels-1),this._isLabelRotated[e]}_setOverflow(e,i,r){e=Math.max(e-this._startBuffer,0),i=Math.max(i-this._endBuffer,0);var s=t.Agent.isRightToLeft(this.getCtx());this.StartCoord+=(e-this.StartOverflow)*(s?-1:1),this.EndCoord-=(i-this.EndOverflow)*(s?-1:1),this._processGroupWidthRatios();for(var a=0;a<this._numLevels;a++){r=this._labels[a];for(var n=0;n<r.length;n++){var o=r[n];if(o){var l=this._getLabelCoord(a,this.getLabelIdx(o));this._numLevels>1?o.setTranslateX(l):o.setX(l)}}}this.StartOverflow=e,this.EndOverflow=i}getLabels(e,t){return null==t&&(t=this._numLevels-1),this._labels||this._generateLabels(e),this._labels[t]}_getLabelCoord(e,t){var i=this.getStartIdx(t,e),r=this.getEndIdx(t,e);if(null==i||null==r)return null;i<this.MinValue&&r>this.MinValue&&(i=this.MinValue),r>this.MaxValue&&i<this.MaxValue&&(r=this.MaxValue);var s=r?i+(r-i)/2:i;return this.getCoordAt(s)}_generateLabels(e){var i=[];this._labels=[];for(var r,s,a,n,o,l=e.getStage(),h="top"==this.Position||"bottom"==this.Position,g=t.Agent.isRightToLeft(e),d=this._numLevels>1,u=this.getGroupWidth(),_=this._maxSpace,c=h?"hierarchicalLabelGapHeight":"hierarchicalLabelGapWidth",p=d?C.getGapSize(e,this.Options,this.Options.layout[c]):0,v="auto"==this.Options.tickLabel.rotation&&h,m={},f=this.isAutoRotate(),x=this.Options.tickLabel.style,S=y.isWrapEnabled(this.Options.tickLabel.style)&&"tangential"!=this.Position&&u>t.TextUtils.getTextStringHeight(e,x),A=0;A<this._numLevels;A++){var b=this._levelsArray[A],M=f?this.getSkipIncrement():1;m[A]=[];for(var D=0;D<b.length;D+=M)if(b[D]){if(""===(r=this.getLabelAt(D,A))||!r&&0!=r){i.push(null);continue}var T=this._getLabelCoord(A,D);if(null!=T){n=this.getLabelStyleAt(D,A);var I=!f&&S&&"number"!=typeof r&&r.indexOf(" ")>=0;o=this.CreateLabel(e,r,T,n,I);var O=u*(this.getEndIdx(D,A)-this.getStartIdx(D,A)+1);m[A].push(O),I&&this._isTextWrapNeeded(e,r,n,v,h?O:_)&&_>0?h?o.wrapText(O,_,1,!0):o.wrapText(_,o.getLineHeight()*this._maxLineWrap,1,!1):I&&(!h||_<0)&&o.setWrapEnabled(!1),o._index=D,i.push(o),s||0!=A||(s=o),0==A&&(a=o)}else i.push(null)}else i.push(null);if(S&&d){for(var E=0,P=0;P<i.length;P++)if(i[P]){var L=i[P].getDimensions();E=Math.max(E,h?L.h:L.w)}_-=E+p}this._labels.push(i),i=[]}i=this._labels[this._numLevels-1];var w=[];if(s){if("tangential"==this.Position)return w=this.GetLabelDims(i,l),void(this._labels[0]=this.SkipTangentialLabels(i,w));var R=s.getDimensions(),k=!1;if(h){var B,F;if(null!=this.Options._startOverflow&&null!=this.Options._endOverflow)B=this.Options._startOverflow,F=this.Options._endOverflow;else{var N=a.getDimensions();B=g?R.w+R.x-this.StartCoord:this.StartCoord-R.x,F=g?this.EndCoord-N.x:N.w+N.x-this.EndCoord}k=B>this._startBuffer||F>this._endBuffer}for(A=0;A<this._numLevels;A++)if(i=this._labels[A],f)this._labels[A]=this._rotateLabels(i,l,R.h/2,A);else{w=this.GetLabelDims(i,l,A);var H=this.IsOverlapping(w,0,m[A]);if(H||(this._labels[A]=i),h)if(v){if(H)this._labels[A]=this._rotateLabels(i,l,R.h/2,A);else if(k&&this._setOverflow(B,F,i),this._labels[A]=i,d){var G=0;for(P=0;P<w.length;P++)w[P]&&(G=Math.max(G,w[P].h));this._maxSpace-=G+p}}else k&&this._setOverflow(B,F,i),w=this.GetLabelDims(i,l),this._labels[A]=this.SkipLabels(i,w);else{if(S)this._sanitizeWrappedText(e,w,i,!1,d)&&(w=this.GetLabelDims(i,l,A));this._labels[A]=this.SkipLabels(i,w)}}}}getMajorTickCoords(){for(var e,t=[],i="tangential"==this.Position?this.getGroupCount():this.getGroupCount()-1,r=0;r<this._levelsArray[0].length;r++)if(this._levelsArray[0][r]){var s=this.getStartIdx(r,0),a=this.getEndIdx(r,0);null!=(e=this._renderGridAtLabels?this.getCoordAt(s+.5*(a-s)):a+.5<i?this.getCoordAt(a+.5):null)&&t.push(e)}return t}getMinorTickCoords(){var e,t=[];if(!this._levelsArray[1])return t;for(var i=0;i<this._levelsArray[1].length;i++)if(this._levelsArray[1][i]){var r=this.getStartIdx(i,1),s=this.getEndIdx(i,1);null!=(e=this._renderGridAtLabels?this.getCoordAt(r+.5*(s-r)):s+.5<this.getGroupCount()-1?this.getCoordAt(s+.5):null)&&t.push(e)}return t}getUnboundedValAt(e){if(null==e)return null;if(this._groupWidthRatios){for(var t=this._borderCoords.length,i=0;i<this._borderCoords.length;i++)if(e<=this._borderCoords[i]){t=i;break}return 0==t?this._borderValues[0]-(this._borderCoords[0]-e)/this._groupWidths[0]:this._borderValues[t-1]+(e-this._borderCoords[t-1])/this._groupWidths[t]}var r=(this.EndCoord-this.StartCoord)/(this.MaxValue-this.MinValue);return this.MinValue+(e-this.StartCoord)/r}getUnboundedCoordAt(e){if(null==e)return null;if(this._groupWidthRatios){for(var t=this._borderValues.length,i=0;i<this._borderValues.length;i++)if(e<=this._borderValues[i]){t=i;break}return 0==t?this._borderCoords[0]-this._groupWidths[0]*(this._borderValues[0]-e):this._borderCoords[t-1]+this._groupWidths[t]*(e-this._borderValues[t-1])}var r=(this.EndCoord-this.StartCoord)/(this.MaxValue-this.MinValue);return this.StartCoord+(e-this.MinValue)*r}getLabelAt(e,t){if(null==t&&(t=this._numLevels-1),(e=Math.round(e))<0)return null;var i=this._levelsArray[t]&&this._levelsArray[t][e]?this._levelsArray[t][e].item:null;return i&&(i.name?i=i.name:null!=i.id&&(i="")),i}getGroupAt(e,t){if(null==t&&(t=this._numLevels-1),(e=Math.round(e))<0)return null;var i=this._levelsArray[t]&&this._levelsArray[t][e]?this._levelsArray[t][e].item:null;if(i){if(i.id)return i.id;if(i.name||""===i.name)return i.name}return i}getLabelStyleAt(e,i){var r=this._getGroupAttribute(e,i,"labelStyle");if(r){var s=new t.CSSStyle(r);return s.getStyle("font-size")||s.setStyle("font-size",this.Options.tickLabel.style.getStyle("font-size")),s}return null}getDatatip(e,t){return this._getGroupAttribute(e,t,"shortDesc")}isDrillable(e,t){var i=this._getGroupAttribute(e,t,"drilling");return"on"==i||"off"!=i&&("on"==this._drilling||"groupsOnly"==this._drilling)}getGroup(e,t){if(e<0||e>this.getGroupCount()-1)return null;if(1==this._numLevels)return this.getGroupAt(e);var i=[];null==t&&(t=this._numLevels-1);for(var r=this.getStartIdx(e,t),s=0;s<=t;s++)for(var a=this._levelsArray[s],n=0;n<a.length;n++)this.getStartIdx(n,s)<=r&&this.getEndIdx(n,s)>=r&&i.push(this.getGroupAt(n,s));return i.length>0?1===i.length&&1===this._numLevels?i[0]:i:null}getLabelBackground(e,i,r){null==r&&(r=this._numLevels-1);var s=e.getCSSStyle();if(s){var a=s.getStyle(t.CSSStyle.BACKGROUND_COLOR),n=s.getStyle(t.CSSStyle.BORDER_COLOR),o=s.getStyle(t.CSSStyle.BORDER_WIDTH),l=s.getStyle(t.CSSStyle.BORDER_RADIUS);if(null!=a||null!=n||null!=o||null!=l){var h=e.getDimensions(),g=.15*h.h;"blink"!==t.Agent.engine&&"ie"!==t.Agent.browser&&"edge"!==t.Agent.browser||e.getVertAlignment()!==t.OutputText.V_ALIGN_BOTTOM||(h.y+=h.h/2);var d=new t.Rect(i,h.x-g,h.y,h.w+2*g,h.h),u=new t.CSSStyle;return null!=a?u.setStyle(t.CSSStyle.BACKGROUND_COLOR,a):d.setInvisibleFill(),u.setStyle(t.CSSStyle.BORDER_COLOR,n),u.setStyle(t.CSSStyle.BORDER_WIDTH,o),u.setStyle(t.CSSStyle.BORDER_RADIUS,l),d.setCSSStyle(u),this._isLabelRotated[r]&&d.setMatrix(e.getMatrix()),d.setMouseEnabled(!1),d}return null}return null}getGroupIndex(e){if(null==e)return-1;for(var i=-1,r=0;r<this._groupCount;r++){var s=this.getGroup(r);if(e instanceof Array&&s instanceof Array?t.ArrayUtils.equals(e,s):e==s){i=r;break}}return i}getMinExtent(){return 1}getGroupWidth(){return Math.abs(this.EndCoord-this.StartCoord)/Math.abs(this.MaxValue-this.MinValue)}getGroupCount(){return this._groupCount}getNumLevels(){return this._numLevels}_generateLevelsArray(e,t,i,r){for(var s=0;s<e.length;s++)if(i[t]||(i[t]=[]),i[t].push({item:e[s],start:r,end:r,position:s}),e[s]&&e[s].groups){var a=i[t].length-1,n=this._generateLevelsArray(e[s].groups,t+1,i,i[t][a].start);r!=n?(i[t][a].end=n-1,r=n):r++}else r++;return r}_getGroupAttribute(e,t,i){null==t&&(t=this._numLevels-1);var r=this._levelsArray[t]&&this._levelsArray[t][e]?this._levelsArray[t][e].item:null;return r?r[i]:null}areSeparatorsRendered(){return this._areSeparatorsRendered}getSeparatorColor(){return this._separatorColor}getStartIdx(e,t){return null==t&&(t=this._numLevels-1),this._levelsArray[t]&&this._levelsArray[t][e]?this._levelsArray[t][e].start:null}getEndIdx(e,t){return null==t&&(t=this._numLevels-1),this._levelsArray[t]&&this._levelsArray[t][e]?this._levelsArray[t][e].end:null}getPosition(e,t){return null==t&&(t=this._numLevels-1),this._levelsArray[t]&&this._levelsArray[t][e]?this._levelsArray[t][e].position:null}getItemsRange(e){e instanceof Array||(e=[e]);for(var t=0,i=this._groupCount,r=[],s=0;s<e.length;s++)for(var a=this._levelsArray[s],n=e[s],o=0;o<a.length;o++){if((a[o].item.id?a[o].item.id:a[o].item.name)===n){var l=a[o].start,h=a[o].end;t<=l&&i>=h&&(t=l,i=h,r.push(a[o].item))}}return{startIndex:t,endIndex:i,groupData:r}}isRenderGridAtLabels(){return this._renderGridAtLabels}setLastRenderedLevel(e){this._lastRenderedLevel=e}getLastRenderedLevel(){return this._lastRenderedLevel}getSeparatorStartLevel(){for(var e=this._lastRenderedLevel,t=this._lastRenderedLevel-1;t>=0;t--)this._labels[t].length!=this._levelsArray[t].length&&(e=t);return e}getLabelIdx(e){return e._index>=0?e._index:null}getMaxLineWrap(){return this._maxLineWrap}_isTextWrapNeeded(e,i,r,s,a){var n=t.TextUtils.getTextStringWidth(e,i,r);return n>=a&&(n/this._maxLineWrap<a||!s)}isAutoRotate(){var e="top"==this.Position||"bottom"==this.Position,t=this._numLevels>1,i=this.getGroupWidth(),r="auto"==this.Options.tickLabel.rotation&&e;return!t&&r&&i<this._ROTATE_THRESHOLD}getSkipIncrement(){var e=1;return e=this._ROTATE_THRESHOLD/(2*this.getGroupWidth()),this.Options._duringZoomAndScroll&&(e*=4),Math.max(1,Math.floor(e))}}S.registerConstructor("group",M);class D extends t.Automation{constructor(e){super(e),this._options=this._comp.getOptions(),this._axisInfo=this._comp.getInfo()}GetSubIdForDomElement(e){var i=this._comp.getEventManager().GetLogicalObject(e);if(i&&i instanceof t.SimpleObjPeer){if("title"===i.getParams().type)return"title";if(this._options.groups){for(var r=i.getParams().level,s=this._axisInfo.getStartIdx(i.getParams().index,r),a="",n=0;n<=r;n++)for(var o=this._axisInfo.getLabels(this._comp.getCtx(),n),l=0;l<o.length;l++){var h=this._axisInfo.getLabelIdx(o[l]);this._axisInfo.getStartIdx(h,n)<=s&&this._axisInfo.getEndIdx(h,n)>=s&&(a+="["+this._axisInfo.getPosition(h,n)+"]")}if(a.length>0)return"item"+a}}return null}getDomElementForSubId(e){if("title"===e){var t=this._axisInfo.getTitle();if(t)return t.getElem()}else if(this._axisInfo instanceof M)for(var i=e.split("[").length-1-1,r=0,s=0,a=0;a<=i;a++){var n=e.indexOf("["),o=e.indexOf("]"),l=Number(e.substring(n+1,o));e=e.substring(o+1);for(var h,g=this._axisInfo.getLabels(this._comp.getCtx(),a),d=0;d<g.length;d++)if(h=this._axisInfo.getLabelIdx(g[d]),this._axisInfo.getStartIdx(h,a)===s){r=h;break}for(var u=r;u<g.length;u++)if(h=this._axisInfo.getLabelIdx(g[u]),this._axisInfo.getPosition(h,a)===l){if(0===e.length)return g[u].getElem();s=this._axisInfo.getStartIdx(h,a);break}}return null}}class T extends t.KeyboardHandler{constructor(e,t){super(e),this._axis=t}processKeyDown(e){var i=e.keyCode,r=this._eventManager.getFocus(),s=null;if(i===t.KeyboardEvent.TAB){r&&(t.EventManager.consumeEvent(e),s=r);var a=this._axis.__getKeyboardObjects();a.length>0&&(t.EventManager.consumeEvent(e),s=this.getDefaultNavigable(a))}else i===t.KeyboardEvent.ENTER?r&&(this._eventManager.processDrillEvent(r),t.EventManager.consumeEvent(e)):s=super.processKeyDown(e);return s}}class I extends t.BaseComponent{constructor(e,i,r){super(e,i,r),this.Defaults=new C(e),this.EventManager=new b(this),this.EventManager.addListeners(this),t.Agent.isTouchDevice()||this.EventManager.setKeyboardHandler(new T(this.EventManager,this)),this._bounds=null}SetOptions(e){e?"off"!==e.rendered?this.Options=this.Defaults.calcOptions(e):(e.tickLabel.style=new t.CSSStyle(e.tickLabel.style),e.titleStyle=new t.CSSStyle(e.titleStyle),this.Options=e):this.Options||(this.Options=this.GetDefaults());this.Options.isRTL=t.Agent.isRightToLeft(this.getCtx())}getPreferredSize(e,t,i,r){return this.SetOptions(e),y.getPreferredSize(this,t,i,r)}render(e,i,r,s,a){this.getCache().clearCache(),this.SetOptions(e),this._navigablePeers=[],this.Width=i,this.Height=r,this.removeChildren(),s||(s=0),a||(a=0);var n=new t.Rectangle(s,a,i,r);y.render(this,n)}__registerObject(e){(null!=e.getDatatip()||e.isDrillable())&&this._navigablePeers.push(e)}__getKeyboardObjects(){return this._navigablePeers}isNavigable(){return this._navigablePeers.length>0}getKeyboardFocus(){return null!=this.EventManager?this.EventManager.getFocus():null}setKeyboardFocus(e,i){if(null!=this.EventManager){for(var r=this.__getKeyboardObjects(),s=e.getId(),a=!1,n=0;n<r.length;n++){var o=r[n].getId();if(s instanceof Array&&o instanceof Array&&t.ArrayUtils.equals(s,o)||s===o){this.EventManager.setFocusObj(r[n]),a=!0,i&&r[n].showKeyboardFocusEffect();break}}a||this.EventManager.setFocusObj(this.EventManager.getKeyboardHandler().getDefaultNavigable(r));var l=this.getKeyboardFocus();if(l){var h=l.getDisplayable();h.setAriaProperty("label",l.getAriaLabel()),this.getCtx().setActiveElement(h)}}}processEvent(e,t){this===t&&this.dispatchEvent(e)}getInfo(){return this.Info}__setInfo(e){this.Info=e}getWidth(){return this.Width}getHeight(){return this.Height}__setBounds(e){this._bounds=e}__getBounds(){return this._bounds}getAutomation(){return new D(this)}static getDefaults(e){return(new C).getDefaults(e)}}const O={getHideAndShowBehavior:e=>e.getOptions().hideAndShowBehavior,getHoverBehavior:e=>e.getOptions().hoverBehavior,isScrollable:e=>!!l.isScrollSupported(e)&&"off"!=e.getOptions().zoomAndScroll,isZoomable:e=>{if(!l.isScrollSupported(e))return!1;var t=e.getOptions().zoomAndScroll;return"live"==t||"delayed"==t},getZoomDir:e=>l.isScatterBubble(e)?e.getOptions().zoomDirection:"auto",isLiveScroll:e=>{if(!l.isScrollSupported(e))return!1;var t=e.getOptions().zoomAndScroll;return"live"==t||"liveScrollOnly"==t},isDelayedScroll:e=>{if(!l.isScrollSupported(e))return!1;var t=e.getOptions().zoomAndScroll;return"delayed"==t||"delayedScrollOnly"==t},isPlotAreaDraggable:e=>{var t=e.getOptions(),i=t.dnd?t.dnd.drag.items:{};return Object.keys(i).length>0},isPlotAreaDropTarget:e=>{var t=e.getOptions(),i=t.dnd?t.dnd.drop.plotArea:{};return Object.keys(i).length>0},isHorizScrollbarSupported:e=>{var t=O.getZoomDir(e);return!l.isPolar(e)&&(l.isBLAC(e)&&l.isVertical(e)||l.isScatterBubble(e)&&"y"!=t)},isVertScrollbarSupported:e=>{var t=O.getZoomDir(e);return!l.isPolar(e)&&(l.isBLAC(e)&&l.isHorizontal(e)||l.isScatterBubble(e)&&"x"!=t)}},E=(e,i,r,s,a,n,o,l)=>{var h=new t.OutputText(i.getCtx(),r,a,n);return h.setCSSStyle(s),t.TextUtils.fitText(h,o,l,i)?(e.associate(h,new t.SimpleObjPeer(h.getUntruncatedTextString())),h):null},P=e=>{var t=e.getOptions();return t.title.text||t.subtitle.text||t.footnote.text},L=(e,i,r)=>{var s=e.getOptions();if(d.hasInvalidTimeData(e)&&d.hasData(e))var a=s.translations.labelInvalidData;else(a=s.emptyText)||(a=s.translations.labelNoData);e.renderEmptyText(i,a,new t.Rectangle(r.x,r.y,r.w,r.h),e.getEventManager(),s._statusMessageStyle)},w={getXAxisPos:e=>l.isPolar(e)?"tangential":l.isHorizontal(e)?t.Agent.isRightToLeft(e.getCtx())?"right":"left":"bottom",getBaselineScaling:(e,t)=>{var i=t+"Axis",r=e.getOptions()[i].baselineScaling;return!r||"zero"!=r&&"min"!=r?l.isStock(e)?"min":"zero":r},getYAxisPos:e=>{var i=e.getOptions().yAxis.position;return l.isPolar(e)?"radial":l.isHorizontal(e)?!i||"top"!=i&&"bottom"!=i?"bottom":i:(l.isStock(e)&&(i=i||"end"),t.Agent.isRightToLeft(e.getCtx())?i&&"end"==i?"left":"right":i&&"end"==i?"right":"left")},getY2AxisPos:e=>{var i=e.getOptions().y2Axis.position;return l.isHorizontal(e)?!i||"top"!=i&&"bottom"!=i?"top":i:t.Agent.isRightToLeft(e.getCtx())?i&&"start"==i?"right":"left":i&&"start"==i?"left":"right"},getAxisOffset:e=>{var t=e.getCache().getFromCache("axisOffset");if(null!=t)return t;var i=e.getOptions().styleDefaults.groupSeparators;if(l.hasGroupAxis(e)&&d.getNumLevels(e)>1&&"on"==i.rendered)t=.5;else if(d.hasBarSeries(e)||c.hasCenteredSeries(e)||d.hasCandlestickSeries(e)||d.hasBoxPlotSeries(e)||l.isBLAC(e)&&1==d.getGroupCount(e))t=.5;else if(l.isSpark(e)||O.isScrollable(e)||l.isOverview(e))t=0;else{var r=l.isHorizontal(e)?.2:.5;t=r-r/Math.sqrt(d.getGroupCount(e))}return e.getCache().putToCache("axisOffset",t),t},isGridShifted:e=>{if(!l.isBLAC(e))return!1;if(d.getNumLevels(e)>1)return!0;for(var t=d.getSeriesCount(e),i=0;i<t;i++)if(d.isSeriesRendered(e,i)){var r=d.getSeriesType(e,i),s=c.getLineType(e,i);if("bar"!=r&&"centeredSegmented"!=s&&"centeredStepped"!=s)return!1}return!0},isGridPolygonal:e=>!(!l.isBLAC(e)||d.hasBarSeries(e))&&"polygon"==e.getOptions().polarGridShape,isAxisRendered:(e,t)=>{if(!l.hasAxes(e))return!1;var i=e.getOptions(),r=i.overview.content&&i.overview.content[t+"Axis"],s=r&&"on"==r.rendered;if("y"==t&&d.hasY2DataOnly(e)&&!s)return!1;if("y2"==t&&!d.hasY2Data(e)&&!s)return!1;var a=i[t+"Axis"];return!("off"==a.rendered&&!s)&&!("off"==a.tickLabel.rendered&&!a.title&&!s)},isAxisLineRendered:(e,t)=>{var i=e.getOptions()[t+"Axis"];return"off"!=i.rendered&&"off"!=i.axisLine.rendered&&!("auto"==i.axisLine.rendered&&"x"!=t&&l.isBLAC(e)&&!l.isPolar(e))},isMajorTickRendered:(e,t)=>{var i=e.getOptions()[t+"Axis"];return"off"!=i.rendered&&"off"!=i.majorTick.rendered&&!("auto"==i.majorTick.rendered&&"x"==t&&l.isBLAC(e)&&!l.isPolar(e))},isMinorTickRendered:(e,t)=>{var i=e.getOptions()[t+"Axis"];return"off"!=i.rendered&&"off"!=i.minorTick.rendered&&("on"==i.minorTick.rendered||w.isLog(e,t))},isLog:(e,t)=>"log"==e.getOptions()[t+"Axis"].scale,getTickLabelHeight:(e,i)=>{var r=e.getOptions(),s=r[i+"Axis"].tickLabel.style;return s instanceof t.CSSStyle||(s=new t.CSSStyle(s)),s.mergeUnder(I.getDefaults(r.skin).tickLabel.style),t.TextUtils.getTextStringHeight(e.getCtx(),s)},getTickLabelGapSize:(e,t)=>{if(w.isTickLabelInside(e,t))return 0;var i=e.getOptions(),r=l.isHorizontal(e),s=w.getGapScalingFactor(e,t),a=Math.ceil(i.layout.tickLabelGapWidth*s),n=Math.ceil(i.layout.tickLabelGapHeight*s);return"x"==t?r?a:n:r?n:a},getGapScalingFactor:(e,t)=>w.isAxisRendered(e,t)?w.getTickLabelHeight(e,t)/14:0,isTickLabelInside:(e,t)=>!(l.isPolar(e)||l.isScatterBubble(e)||l.isBLAC(e)&&"x"==t)&&"inside"==e.getOptions()[t+"Axis"].tickLabel.position,getXAxisViewportMinMax:(e,t)=>{var i=t?"xAxisViewportMinMaxUG":"xAxisViewportMinMax",r=e.getCache().getFromCache(i);if(r)return r;var s=e.getOptions().xAxis,a=l.hasGroupAxis(e),n=w.getAxisOffset(e);if(t)var o=w.getXAxisGlobalMinMax(e);var h=null;null!=s.viewportMin?h=s.viewportMin:null!=s.viewportStartGroup?h=a?d.getGroupIdx(e,s.viewportStartGroup)-n:s.viewportStartGroup:t&&(h=o.min);var g=null;return null!=s.viewportMax?g=s.viewportMax:null!=s.viewportEndGroup?g=a?d.getGroupIdx(e,s.viewportEndGroup)+n:s.viewportEndGroup:t&&(g=o.max),r={min:h,max:g},e.getCache().putToCache(i,r),r},getXAxisGlobalMinMax:e=>{var t=e.getOptions().xAxis,i=l.hasGroupAxis(e),r=w.getAxisOffset(e);if(!i)var s=w.getMinMaxVal(e,"x");return{min:null!=t.min?t.min:i?0-r:s.min,max:null!=t.max?t.max:i?d.getGroupCount(e)-1+r:s.max}},applyInitialZooming:(e,t)=>{var i=e.getOptions(),r=i.xAxis,s=i.initialZooming;if(l.isBLAC(e)&&"off"!=i.zoomAndScroll&&"none"!=s){i._initialZoomed&&("last"==s?r.viewportMin=null:r.viewportMax=null);var a=w.getXAxisViewportMinMax(e,!1),n=a.min,o=a.max;if(!("last"==s&&null!=n||"first"==s&&null!=o)){var h=l.isHorizontal(e)?t.h:t.w,g=Math.floor(h/(2*w.getTickLabelHeight(e,"x")))+w.getAxisOffset(e),u=d.getGroupCount(e)-1;if(!(u<=g)){var _,c;if(l.hasGroupAxis(e))_=0,c=u;else{var p=w.getMinMaxVal(e,"x");_=p.min,c=p.max}var v=g/u*(c-_);"last"==i.initialZooming?(null==o&&(o=c),r.viewportMin=Math.max(o-v,_)):(null==n&&(n=_),r.viewportMax=Math.min(n+v,c)),i._initialZoomed=!0}}}},isYAdjustmentNeeded:e=>{var t=e.getOptions().styleDefaults.dataLabelPosition,i=e.getOptionsCache().getFromCache("hasDataOutsideBarEdge"),r="outsideBarEdge"==t||i,s=c.isStackLabelRendered(e);return!(!d.hasBarSeries(e)||!r&&!s)},axisContainsPoint:(e,t)=>{if(!e)return!1;var i=e.getOptions().position,r="top"==i||"bottom"==i,s=r?4:10,a=r?10:4,n=e.__getBounds().clone();n.x-=a,n.y-=s,n.w+=2*a,n.h+=2*s;var o=e.stageToLocal(t);return n.containsPoint(o.x,o.y)},isStandalonePlotArea:e=>!P(e)&&(!l.isLegendRendered(e)&&(!w.isAxisRendered(e,"x")&&(!w.isAxisRendered(e,"y")&&!w.isAxisRendered(e,"y2")))),isStandaloneXAxis:e=>{var t=e.getOptions();return!P(e)&&("off"==t.legend.rendered&&("off"==t.plotArea.rendered&&(!w.isAxisRendered(e,"y")&&!w.isAxisRendered(e,"y2"))))},isStandaloneYAxis:e=>{var t=e.getOptions();return!P(e)&&("off"==t.legend.rendered&&(!w.isAxisRendered(e,"x")&&("off"==t.plotArea.rendered&&!w.isAxisRendered(e,"y2"))))},isStandaloneY2Axis:e=>{var t=e.getOptions();return!P(e)&&("off"==t.legend.rendered&&(!w.isAxisRendered(e,"x")&&(!w.isAxisRendered(e,"y")&&"off"==t.plotArea.rendered)))},getViewportMinMaxGroupIdx:(e,t)=>{var i=w.getXAxisViewportMinMax(e,!0),r=l.hasGroupAxis(e),s=d.getGroupCount(e),a=i.min,n=0;if(null!=a)if(r)n=Math.ceil(a);else for(var o=0;o<s;o++){if(d.getXVal(e,t,o)>=a){n=o;break}}var h=i.max,g=s-1;if(r)g=Math.floor(h);else for(var u=s-1;u>=n;u--){if(d.getXVal(e,t,u)<=h){g=u;break}}return{min:n,max:g}},getViewportGroupCount:e=>{var t=w.getXAxisViewportMinMax(e,!0),i=w.getXAxisGlobalMinMax(e),r=(t.max-t.min)/(i.max-i.min);return isNaN(r)?1:r*d.getGroupCount(e)},_computeYAlongLine:(e,i,r,s,a,n)=>{e&&(r=t.Math.log10(r),a=t.Math.log10(a));var o=r+(a-r)*(n-i)/(s-i);return e?Math.pow(10,o):o},getMinMaxVal:(e,t,i)=>{var r=t+(i?"MinMaxDO":"MinMax"),s=e.getCache().getFromCache(r);if(s)return s;var a=e.getOptions()[t+"Axis"];if(null!=a.dataMax&&null!=a.dataMin&&i)return s={min:a.dataMin,max:a.dataMax},e.getCache().putToCache(r,s),s;var n=l.hasTimeAxis(e);if(null!=a.max&&null!=a.min&&!i&&!n)return s={min:a.min,max:a.max},e.getCache().putToCache(r,s),s;var o="z"!=t&&w.isLog(e,t),h="y2"==t;h&&(t="y");for(var g="y"==t,u=!i&&g&&l.isBLAC(e),_="withoutRescale"==O.getHideAndShowBehavior(e)||"x"==t&&l.hasTimeAxis(e),p=-1/0,m=1/0,f=d.getSeriesCount(e),x=0;x<f;x++){var C=d.getSeriesItem(e,x),S=d.getSeriesType(e,x),A=g&&(d.isRangeSeries(e,x)||"candlestick"==S||"boxPlot"==S);if(_||d.isSeriesRendered(e,x)){var b=d.isAssignedToY2(e,x);if(!g||h==b){var y=C.items;if(y){var M=0,D=y.length-1;if(u){var T=w.getViewportMinMaxGroupIdx(e,x);M=T.min,D=T.max}for(var I=M;I<=D;I++)if(_||d.isDataItemRendered(e,x,I)){var E=y[I],P=null;if(g?A||(P=d.getCumulativeVal(e,x,I,_)):"x"==t&&n&&!l.isMixedFrequency(e)?(P=d.getGroupLabel(e,I),null!=E&&(E.x=P)):null!=E&&(P=E[t]),!("z"==t&&P<=0)){if(!(A||null==P||"number"!=typeof P||o&&P<=0)){var L=0;if(l.isBubble(e)&&!i&&"z"!=t){var R=c.getMarkerSize(e,x,I);L=w.getBubbleAxisRadius(e,t,R)}p=Math.max(p,o?P*Math.pow(10,L):P+L),m=Math.min(m,o?P/Math.pow(10,L):P-L)}if(A){var k=d.getHighVal(e,x,I),B=d.getLowVal(e,x,I);o&&(k<=0||B<=0)||(p=Math.max(p,k,B),m=Math.min(m,k,B))}if(u&&!A){var F=null,N=null;if(M>0&&I==M?(F=I-1,N=w.getXAxisViewportMinMax(e,!0).min):D<y.length-1&&I==D&&(F=I+1,N=w.getXAxisViewportMinMax(e,!0).max),null!=F){var H=d.getXVal(e,x,I),G=d.getXVal(e,x,F),U=d.getCumulativeVal(e,x,F),V=w._computeYAlongLine(o,H,P||0,G,U||0,N);p=Math.max(p,V),m=Math.min(m,V)}}var Y=d.getNestedDataItemCount(e,x,I);if(Y>0)for(var W=0;W<Y;W++){var j=d.getNestedDataItem(e,x,I,W),z="number"==typeof j;p=z?Math.max(p,j):Math.max(p,j.value),m=z?Math.min(m,j):Math.min(m,j.value)}}}}}}}var X=null;if("x"==t?X=d.getAxisRefObjs(e,"x"):h?X=d.getAxisRefObjs(e,"y2"):g&&(X=d.getAxisRefObjs(e,"y")),null!=X)for(var Z=0;Z<X.length;Z++){var K=X[Z],q=K.items,Q="withRescale"==O.getHideAndShowBehavior(e)&&!v.isObjRendered(e,K);if(!Q)if(q&&!Q){var J=0,$=q.length-1;if(u){var ee=w.getViewportMinMaxIdx(e,q);J=ee.min,$=ee.max}for(var te=J;te<=$;te++)if(null!=q[te]){var ie=v.getLowVal(q[te]),re=v.getHighVal(q[te]),se=isNaN(q[te])?q[te].value:q[te];null!=ie&&isFinite(ie)&&(m=Math.min(m,ie),p=Math.max(p,ie)),null!=re&&isFinite(re)&&(m=Math.min(m,re),p=Math.max(p,re)),null!=se&&isFinite(se)&&(m=Math.min(m,se),p=Math.max(p,se))}}else{var ae=v.getLowVal(K),ne=v.getHighVal(K),oe=K.value;null!=ae&&isFinite(ae)&&(m=Math.min(m,ae),p=Math.max(p,ae)),null!=ne&&isFinite(ne)&&(m=Math.min(m,ne),p=Math.max(p,ne)),null!=oe&&isFinite(oe)&&(m=Math.min(m,oe),p=Math.max(p,oe))}}return s={min:m,max:p},e.getCache().putToCache(r,s),s},getBubbleAxisRadius:(e,t,i)=>{if(!i)return 0;var r="x"==t?"_xAxisBubbleRatio":"_yAxisBubbleRatio";return i/2*e.getCache().getFromCache(r)},getViewportMinMaxIdx:(e,t)=>{var i=w.getXAxisViewportMinMax(e,!0),r=l.hasGroupAxis(e),s=i.min,a=0;if(null!=s)if(r)a=Math.ceil(s);else for(var n=0;n<t.length;n++){if(v.getXVal(e,t,n)>=s){a=n;break}}var o=i.max,h=t.length-1;if(r)h=Math.floor(o);else for(var g=t.length-1;g>=a;g--){if(d.getXVal(e,t,g)<=o){h=g;break}}return{min:a,max:h}}},R={getGroupWidthRatios:e=>{if(!d.hasBarSeries(e)&&!d.hasCandlestickSeries(e)&&!d.hasBoxPlotSeries(e))return null;var t=e.getOptions(),i=R.getBarGapRatio(e);if(i>=1)return t._averageGroupZ=1/0,null;t._averageGroupZ=0;var r,s,a,n,o,l,h=d.getGroupCount(e),g=d.isSplitDualY(e),u=d.getStackCategories(e,"bar"),_=u.y.length,c=u.y2.length;if(e.getOptionsCache().getFromCache("hasConstantZValue")){var p=e.getOptionsCache().getFromCache("constantZValue")*(g?Math.max(_,c):_+c);l=(o=p*h)*i/(1-i),r=null}else{for(var v=[],m=0;m<h;m++){for(s=0,n=0;n<_;n++)s+=d.getBarCategoryZ(e,u.y[n],m,!1);for(a=0,n=0;n<c;n++)a+=d.getBarCategoryZ(e,u.y2[n],m,!0);v.push(g?Math.max(s,a):s+a)}o=v.reduce((e,t)=>e+t),l=o*i/(1-i),r=v.map(e=>e+l/h)}return t._averageGroupZ=(o+l)/h,r},getBarGapRatio:e=>{var t=e.getCache().getFromCache("barGapRatio");if(t)return t;if("string"==typeof(t=e.getOptions().styleDefaults.barGapRatio)&&"%"==t.slice(-1)&&(t=Number(t.slice(0,-1))/100),null!=t&&!isNaN(t))return Number(t);var i=d.getStackCategories(e,"bar"),r=i.y.length,s=i.y2.length,a=d.isSplitDualY(e)?Math.max(r,s):r+s;return t=l.isPolar(e)?1==a?0:.25:1==a?.37+.26/w.getViewportGroupCount(e):.25,e.getCache().putToCache("barGapRatio",t),t},getBarInfo:(e,i,r,s)=>{var a,n,o=l.isHorizontal(e),g=d.isStacked(e),u=t.Agent.isRightToLeft(e.getCtx()),_=e.xAxis,p=d.isRangeSeries(e,i),v=c.getBarCategoryOffsetMap(e,r),m=d.getXVal(e,i,r),f=_.getUnboundedCoordAt(m),x=d.isAssignedToY2(e,i),C=x?e.y2Axis:e.yAxis,S=C.getBaselineCoord();if(p){var A=d.getLowVal(e,i,r),b=d.getHighVal(e,i,r);if(null==A||isNaN(A)||null==b||isNaN(b))return null;if((a=C.getBoundedCoordAt(A))==(n=C.getBoundedCoordAt(b))&&null==C.getCoordAt(A))return null}else{var y=d.getVal(e,i,r),M=d.getCumulativeVal(e,i,r);if(null==y||isNaN(y))return null;if((a=C.getBoundedCoordAt(M))==(n=g?C.getBoundedCoordAt(M-y):S)&&null==C.getCoordAt(M))return null}var D=d.getStackCategory(e,i),T=c.getBarWidth(e,i,r),I=g?c.getBarStackWidth(e,D,r,x):T;if("pixel"==c.getBarSpacing(e)&&"firefox"===t.Agent.browser){var O=T/(1-R.getBarGapRatio(e));T>1&&O-T<2&&(I=--T)}var E=v[x?"y2":"y"][D]+.5*(I-T),P=u&&!o?f-E-T:f+E,L=P+T,w=(P+L)/2,k=p?(a+n)/2:a;return{x1:P,x2:L,axisCoord:S,baseCoord:n,yCoord:a,dataPos:h.convertAxisCoord(e,new t.Point(w,k),s),barWidth:T}},getDataLabelPos:(e,i,r,s,a,n)=>{var o,h=d.getNestedDataItem(e,i,r,s),g=d.getDataItem(e,i,r);if(n)o="outsideBarEdge";else if((o=h&&h.labelPosition?h.labelPosition:g.labelPosition)||(o=e.getOptions().styleDefaults.dataLabelPosition),"none"==(o=c._parseLowHighArray(o,a)))return"none";var u=t.Agent.isRightToLeft(e.getCtx()),_=l.isHorizontal(e),p=l.isPolar(e);if(l.isFunnel(e)||l.isPyramid(e))return"center";if("bar"==d.getSeriesType(e,i)){if("center"==o||p)return"center";var v,m=d.isStacked(e);if("insideBarEdge"!=o){if(m&&!n)return"center";"outsideBarEdge"!=o&&(o="insideBarEdge")}if("insideBarEdge"==o&&!m){var f,x=e.getOptions().styleDefaults.dataLabelStyle,C=g.labelStyle?t.CSSStyle.mergeStyles([x,new t.CSSStyle(g.labelStyle)]):x;if(_){var S=c.getDataLabel(e,i,r,s,a);f=t.TextUtils.getTextStringWidth(e.getCtx(),S,C)}else f=t.TextUtils.getTextStringHeight(e.getCtx(),C);var A=R.getBarInfo(e,i,r);(A?Math.abs(A.baseCoord-A.yCoord):0)<=f&&(o="outsideBarEdge")}return v="low"==a?g.low<=g.high:"high"==a?g.high<g.low:d.getVal(e,i,r,s)<0,"outsideBarEdge"==o?_?!v&&!u||v&&u?"right":"left":v?"bottom":"top":_?!v&&!u||v&&u?"inRight":"inLeft":v?"inBottom":"inTop"}if("center"==o)return"center";if("belowMarker"==o)return"bottom";if("aboveMarker"==o)return"top";if("afterMarker"!=o&&"beforeMarker"!=o){if(l.isBubble(e))return"center";if("low"!=a||p)if("high"!=a||p)o="afterMarker";else{if(!_)return"top";o="afterMarker"}else{if(!_)return"bottom";o="beforeMarker"}}return!u&&"afterMarker"==o||u&&"beforeMarker"==o?"right":"left"}},k={getBarFill:(e,t,i,r)=>{var s=c.getColor(e,t,i),a=c.getPattern(e,t,i);return k.getRectangleFill(e,s,a,r)},getRectangleFill:(e,i,r,s)=>{var a=c.getSeriesEffect(e);if(r)return new t.PatternFill(r,i);if("gradient"==a&&s>3){var n,o,h=l.isHorizontal(e)?270:0;return n=[t.ColorUtils.adjustHSL(i,0,-.09,.04),t.ColorUtils.adjustHSL(i,0,-.04,-.05)],o=[0,1],new t.LinearGradientFill(h,n,null,o)}return new t.SolidFill(i)},getAreaFill:(e,i)=>{var r,s="lineWithArea"==d.getSeriesType(e,i),a=d.getSeriesItem(e,i);a&&a.areaColor?r=a.areaColor:(r=c.getColor(e,i),s&&(r=t.ColorUtils.setAlpha(r,.2)));var n=c.getPattern(e,i),o=c.getSeriesEffect(e);if(n)return new t.PatternFill(n,r);if("gradient"==o){var h,g,u=l.isHorizontal(e)?180:270;if(s){var _=t.ColorUtils.getAlpha(r);h=[t.ColorUtils.setAlpha(r,Math.min(_+.2,1)),t.ColorUtils.setAlpha(r,Math.max(_-.15,0))],g=[0,1]}else h=[t.ColorUtils.adjustHSL(r,0,-.09,.04),t.ColorUtils.adjustHSL(r,0,-.04,-.05)],g=[0,1];return new t.LinearGradientFill(u,h,null,g)}return new t.SolidFill(r)},getMarkerFill:(e,i,r,s)=>{var a=c.getMarkerColor(e,i,r,s),n=c.getPattern(e,i,r,s);if(n)return new t.PatternFill(n,a);if(l.isBubble(e)&&"gradient"==c.getSeriesEffect(e)){var o=[t.ColorUtils.adjustHSL(a,0,-.09,.04),t.ColorUtils.adjustHSL(a,0,-.04,-.05)];return new t.LinearGradientFill(270,o,null,[0,1])}return new t.SolidFill(a)},getFunnelPyramidSliceFill:(e,i,r,s,a)=>{var n,o=c.getPattern(e,i,0),h=c.getSeriesEffect(e);if(o&&!a)return("vertical"==e.getOptions().orientation||l.isPyramid(e))&&(n=t.Agent.isRightToLeft(e.getCtx())?new t.Matrix(0,-1,1,0):new t.Matrix(0,1,-1,0)),new t.PatternFill(o,r,null,n);if("gradient"==h){var g,d,u=l.isPyramid(e)?180:90;return"on"==e.getOptions().styleDefaults.threeDEffect?(g=[t.ColorUtils.adjustHSL(r,0,0,-.1),t.ColorUtils.adjustHSL(r,0,0,.12),r],d=[0,.65,1]):(g=[t.ColorUtils.adjustHSL(r,0,-.09,.04),t.ColorUtils.adjustHSL(r,0,-.04,-.05)],d=[0,1]),new t.LinearGradientFill(u,g,null,d,[s.x,s.y,s.w,s.h])}return new t.SolidFill(r)}};class B extends t.Path{constructor(e,i,r,s,a,n,o,l,h){super(e.getCtx()),this._FUNNEL_3D_WIDTH_RATIO=.08,this._FUNNEL_ANGLE_2D=36,this._FUNNEL_RATIO=1/3,this._BORDER_COLOR="#FFFFFF",this._MIN_CHARS_DATA_LABEL=3,this._LINE_FRACTION=2/3,this._AREA_FRACTION=.41,this._HEIGHT_FRACTION=.28,this._LINE_FRACTION_2=.4,this._AREA_FRACTION_2=.8,this._HEIGHT_FRACTION_2=.7,this._chart=e;var g=e.getOptions().styleDefaults;this._seriesIndex=i,this._numDrawnSeries=r,this._funnelWidth=s,this._funnelHeight=a,this._startPercent=n,this._valuePercent=o,this._fillPercent=l,this._3dRatio="on"==g.threeDEffect?1:0,this._gap=h;var d=this._getPath();this._dataColor=c.getColor(this._chart,this._seriesIndex,0),this._backgroundColor=g.backgroundColor?g.backgroundColor:g.funnelBackgroundColor,this.setCmds(d.slice),d.bar&&(this._bar=new t.Path(this.getCtx(),d.bar),this.addChild(this._bar),this._bar.setMouseEnabled(!1)),this._setColorProps(d.sliceBounds),this._label=this._getSliceLabel(d.sliceBounds,d.barBounds),null!=this._label&&(this._label.setMouseEnabled(!1),this.addChild(this._label))}_getPath(){var e=t.Agent.isRightToLeft(this.getCtx()),i=d.getSeriesCount(this._chart),r=(this._numDrawnSeries+1)*this._gap,s=t.Math.degreesToRads(this._FUNNEL_ANGLE_2D-2*this._3dRatio),a=this._funnelWidth-i*this._gap,n=a/Math.sin(t.Math.degreesToRads(this._FUNNEL_ANGLE_2D)),o=this._funnelHeight/Math.sin(s),l=this._3dRatio*this._funnelWidth/this._funnelHeight*this._FUNNEL_3D_WIDTH_RATIO;l<1e-5&&(l=0);var h,g,u,_,c,p,v,m,f,x,C,S,A=this._funnelHeight,b=this._funnelHeight*this._FUNNEL_RATIO;this._startPercent<this._AREA_FRACTION?(h=this._startPercent,u=A,c=this._funnelHeight*this._LINE_FRACTION,v=this._AREA_FRACTION,f=a*this._HEIGHT_FRACTION,C=a*(1-this._HEIGHT_FRACTION)):this._startPercent<this._AREA_FRACTION_2?(h=this._startPercent-this._AREA_FRACTION,u=this._funnelHeight*this._LINE_FRACTION,c=this._funnelHeight*this._LINE_FRACTION_2,v=this._AREA_FRACTION_2-this._AREA_FRACTION,f=a*(this._HEIGHT_FRACTION_2-this._HEIGHT_FRACTION),C=a*(1-this._HEIGHT_FRACTION_2)):(h=this._startPercent-this._AREA_FRACTION_2,u=this._funnelHeight*this._LINE_FRACTION_2,c=b,v=1-this._AREA_FRACTION_2,f=a*(1-this._HEIGHT_FRACTION_2),C=0),this._startPercent+this._valuePercent<this._AREA_FRACTION?(_=A,p=this._funnelHeight*this._LINE_FRACTION,g=this._startPercent+this._valuePercent,m=this._AREA_FRACTION,x=a*this._HEIGHT_FRACTION,S=a*(1-this._HEIGHT_FRACTION)):this._startPercent+this._valuePercent<this._AREA_FRACTION_2?(_=this._funnelHeight*this._LINE_FRACTION,p=this._funnelHeight*this._LINE_FRACTION_2,g=this._startPercent+this._valuePercent-this._AREA_FRACTION,m=this._AREA_FRACTION_2-this._AREA_FRACTION,x=a*(this._HEIGHT_FRACTION_2-this._HEIGHT_FRACTION),S=a*(1-this._HEIGHT_FRACTION_2)):(_=this._funnelHeight*this._LINE_FRACTION_2,p=b,g=this._startPercent+this._valuePercent-this._AREA_FRACTION_2,m=1-this._AREA_FRACTION_2,x=a*(1-this._HEIGHT_FRACTION_2),S=0);var y,M,D,T=Math.sqrt((v-h)/v*u*u+h/v*c*c),I=Math.sqrt((m-g)/m*_*_+g/m*p*p),O=.98*Math.asin(((T-c)*f/(u-c)+C)/n),E=.98*Math.asin(((I-p)*x/(_-p)+S)/n),P=(1+this._FUNNEL_RATIO)/2*this._funnelHeight+o,L=(1-this._FUNNEL_RATIO)/2*this._funnelHeight-o;e?(y=[n*Math.sin(O)+r,P-o*Math.cos(O),n*Math.sin(E)+r,P-o*Math.cos(E),n*Math.sin(E)+r,L+o*Math.cos(E),n*Math.sin(O)+r,L+o*Math.cos(O)],M=0,D=1):(y=[this._funnelWidth-r-n*Math.sin(O),P-o*Math.cos(O),this._funnelWidth-r-n*Math.sin(E),P-o*Math.cos(E),this._funnelWidth-r-n*Math.sin(E),L+o*Math.cos(E),this._funnelWidth-r-n*Math.sin(O),L+o*Math.cos(O)],M=1,D=0);var w=t.PathUtils.moveTo(y[0],y[1]),R=null;w+=t.PathUtils.arcTo(l*(y[1]-y[7])/2,(y[1]-y[7])/2,Math.PI,D,y[6],y[7]),w+=t.PathUtils.arcTo(l*(y[1]-y[7])/2,(y[1]-y[7])/2,Math.PI,D,y[0],y[1]),w+=t.PathUtils.arcTo(n,o,s,M,y[2],y[3]),w+=t.PathUtils.arcTo(l*(y[3]-y[5])/2,(y[3]-y[5])/2,Math.PI,D,y[4],y[5]),w+=t.PathUtils.arcTo(n,o,s,M,y[6],y[7]);var k=new t.Rectangle(Math.min(y[0],y[2]),y[5],Math.abs(y[0]-y[2]),Math.abs(y[3]-y[5]));if(null!=this._fillPercent){var B=Math.max(Math.min(this._fillPercent,1),0),F=e?-B*Math.PI:B*Math.PI;R=t.PathUtils.moveTo(y[0],y[1]),R+=t.PathUtils.arcTo(n,o,s,M,y[2],y[3]),R+=t.PathUtils.arcTo(l*(y[3]-y[5])/2,(y[3]-y[5])/2,F,D,y[2]+l*(y[3]-y[5])/2*Math.sin(F),(y[5]+y[3])/2+(y[3]-y[5])/2*Math.cos(F)),this._fillPercent>.95?R+=t.PathUtils.arcTo(n,o,s,M,y[6],y[1]+B*(y[7]-y[1])):this._fillPercent<.05?R+=t.PathUtils.arcTo(n,o,s,D,y[6],y[1]+B*(y[7]-y[1])):R+=t.PathUtils.lineTo(y[6]+l*(y[1]-y[7])/2*Math.sin(F),(y[7]+y[1])/2+(y[1]-y[7])/2*Math.cos(F)),R+=t.PathUtils.arcTo(l*(y[1]-y[7])/2,(y[1]-y[7])/2,F,M,y[0],y[1]),R+=t.PathUtils.closePath();var N=new t.Rectangle(Math.min(y[0],y[2]),y[5]+Math.abs(y[3]-y[5])*(1-B),Math.abs(y[0]-y[2]),Math.abs(y[3]-y[5])*B)}return{slice:w,bar:R,sliceBounds:k,barBounds:R?N:k}}_getSliceLabel(e,i){var r=c.getDataLabel(this._chart,this._seriesIndex,0);if(r||(r=d.getSeriesLabel(this._chart,this._seriesIndex)),r&&"none"!=R.getDataLabelPos(this._chart,this._seriesIndex,0)){var s=new t.MultilineText(this.getCtx(),r,0,0),a=null!=c.getPattern(this._chart,this._seriesIndex,0),n=this._chart.getOptions().styleDefaults,o=[n._dataLabelStyle,n.dataLabelStyle,new t.CSSStyle(d.getDataItem(this._chart,this._seriesIndex,0).labelStyle)],l=t.CSSStyle.mergeStyles(o);if(s.setCSSStyle(l),t.TextUtils.fitText(s,e.h-this._3dRatio*(.8-this._valuePercent)*50,e.w,this,this._MIN_CHARS_DATA_LABEL)){var h=s.getDimensions(),g=this._getLabelPos(e);if(a){var u=.15*h.h,_=t.Agent.isRightToLeft(this.getCtx())?.5:-.5,p=t.PathUtils.roundedRectangle(h.x-u,h.y,h.w+2*u,h.h,2,2,2,2),v=new t.Path(this.getCtx(),p);v.setSolidFill("#FFFFFF",.9),g=g.translate(_*h.h,-_*h.w),v.setMatrix(g),this.addChild(v)}var m=a?"#000000":i.containsPoint(e.x,e.y+(e.h-h.w)/2)?t.ColorUtils.getContrastingTextColor(this._dataColor):t.ColorUtils.getContrastingTextColor(this._backgroundColor),f=new t.CSSStyle({color:m});return o.splice(1,0,f),t.Agent.isHighContrast()&&o.push(f),l=t.CSSStyle.mergeStyles(o),s.setCSSStyle(l),s.setMatrix(this._getLabelPos(e)),s.alignCenter(),s.alignMiddle(),s}}}_getLabelPos(e){var i=this._3dRatio*(e.h*this._funnelWidth/this._funnelHeight*this._FUNNEL_3D_WIDTH_RATIO/2),r=new t.Matrix;return r=t.Agent.isRightToLeft(this.getCtx())?(r=r.rotate(Math.PI/2)).translate(e.x+e.w/2-i,e.y+e.h/2):(r=r.rotate(3*Math.PI/2)).translate(e.x+e.w/2+i,e.y+e.h/2)}_setColorProps(e){var i=k.getFunnelPyramidSliceFill(this._chart,this._seriesIndex,this._dataColor,e),r=c.getBorderColor(this._chart,this._seriesIndex,0),s=c.getUserBorderWidth(this._chart,this._seriesIndex,0),a=c.getDefaultBorderWidth(this._chart,this._seriesIndex,0),n=!1,o="redwood"===this.getCtx().getThemeBehavior();null==r&&this._3dRatio>0&&(n=!0,r=this._BORDER_COLOR);var l=null!==s?s:a;!r||o&&this._chart.isSelectionSupported()&&!this._bar&&n||this.setSolidStroke(r,null,l);var h=t.SelectionEffectUtils.getHoverBorderColor(this._dataColor),g=k.getFunnelPyramidSliceFill(this._chart,this._seriesIndex,this._backgroundColor,e,!0);this._bar?(this.setFill(g),this._bar.setFill(i),this._bar.setStyle(c.getStyle(this._chart,this._seriesIndex,0)),this._bar.setClassName(c.getClassName(this._chart,this._seriesIndex,0))):(this.setFill(i),this.setStyle(c.getStyle(this._chart,this._seriesIndex,0)),this.setClassName(c.getClassName(this._chart,this._seriesIndex,0))),this.OriginalStroke=this.getStroke();var d=null!=this._bar?this._bar:this;if(this._chart.isSelectionSupported())if(this.setCursor(t.SelectionEffectUtils.getSelectingCursor()),o)if(null!=this._bar)d.setSolidStroke(this._dataColor,null,0),d.setFeedbackClassName("oj-dvt-selectable");else{var u=null==r||n?this._dataColor:r,_=null!==s?s:0;d.setSolidStroke(u,null,_),d.setFeedbackClassName("oj-dvt-selectable"),r&&(n&&d.addClassName("oj-dvt-default-border-color"),null==s&&d.addClassName("oj-dvt-default-border-width"))}else{var p=c.getSelectedInnerColor(this._chart),v=c.getSelectedOuterColor(this._chart)?c.getSelectedOuterColor(this._chart):this._dataColor;d.setHoverStroke(new t.Stroke(h,1,2)),d.setSelectedStroke(new t.Stroke(p,1,1.5),new t.Stroke(v,1,4.5)),d.setSelectedHoverStroke(new t.Stroke(p,1,1.5),new t.Stroke(h,1,4.5))}}getAnimParams(){return[this._startPercent,this._valuePercent,this._fillPercent,this.getAlpha(),this._3dRatio]}setAnimParams(e){this._startPercent=e[0],this._valuePercent=e[1],this._fillPercent=null!=this._fillPercent?e[2]:null,this.setAlpha(e[3]),this._3dRatio=e[4];var t=this._getPath();this.setCmds(t.slice),t.bar&&this._bar&&this._bar.setCmds(t.bar),this._label&&this._label.setMatrix(this._getLabelPos(t.sliceBounds))}setSelected(e){if(null!=this._bar){if(this.IsSelected==e)return;this.IsSelected=e,this._bar.setSelected(e)}else super.setSelected(e);var t=this.getDimensions(),i=null!=this._bar?this._bar:this,r=t.w;e?(i.setScaleX((r-3)/r),i.setTranslateX(Math.ceil(1.5)+3/r*t.x)):(i.setScaleX(1),i.setTranslateX(0))}showHoverEffect(){null!=this._bar?this._bar.showHoverEffect():super.showHoverEffect()}hideHoverEffect(){null!=this._bar?this._bar.hideHoverEffect():super.hideHoverEffect()}copyShape(){return new B(this._chart,this._seriesIndex,this._numDrawnSeries,this._funnelWidth,this._funnelHeight,this._startPercent,this._valuePercent,this._fillPercent,this._gap)}}const F={setVisibility:(e,t,i)=>{var r=v.getRefObj(e,t);null!=r&&(r.visibility=i);var s=d.getHiddenCategories(e),a=s.indexOf(t);"hidden"==i&&a<0?s.push(t):"visible"==i&&a>=0&&s.splice(a,1);var n=e.getOptions();if(n&&n.legend&&n.legend.sections){for(var o=0;o<n.legend.sections.length;o++){var l=n.legend.sections[o];if(l&&l.items)for(var h=0;h<l.items.length;h++)l.items[h].id==t&&(l.items[h].categoryVisibility=i)}return!0}return!1},processIds:(e,t)=>{for(var i=[],r=0;r<t.length;r++){var s=t[r];if(s.series==_.OTHER_ID){var a=_.getOtherSliceIds(e);i=i.concat(a)}else i.push(s)}return i},adjustBounds:e=>{null!=e.x&&(e.x-=1),null!=e.w&&(e.w+=2),null!=e.y&&(e.y-=1),null!=e.h&&(e.h+=2)},getBoundedObjs:(e,t)=>{for(var i=e.getChartObjPeers().concat(F.getFilteredChartObjPeers(e)),r=[],s=0;s<i.length;s++){var a=i[s],n=a.getDataPosition();if(n){n=e.getPlotArea().localToStage(n);var o=null==t.x||n.x>=t.x&&n.x<=t.x+t.w,l=null==t.y||n.y>=t.y&&n.y<=t.y+t.h;o&&l&&r.push(a)}}return r},getFilteredChartObjPeers:e=>{if(!e.getCache().getFromCache("dataFiltered"))return[];var t=e.getCache().getFromCache("filteredChartObjPeers");if(!t){t=[];for(var i=0;i<d.getSeriesCount(e);i++)for(var r=0;r<d.getGroupCount(e);r++){var s;if(d.isDataItemFiltered(e,i,r))s="bar"==d.getSeriesType(e,i)?R.getBarInfo(e,i,r).dataPos:d.getMarkerPos(e,i,r),t.push(new f(e,[],i,r,null,s))}e.getCache().putToCache("filteredChartObjPeers",t)}return t},getAxisBounds:(e,i,r)=>{var s=e.getPlotArea(),a=s.stageToLocal(new t.Point(i.x,i.y)),n=s.stageToLocal(new t.Point(i.x+i.w,i.y+i.h));null==i.x&&(a.x=null,n.x=null),null==i.y&&(a.y=null,n.y=null);var o=F._convertToAxisCoord(e,a.x,n.x,a.y,n.y),l={},h={},g={},d={};return e.xAxis&&(l=F._getAxisMinMax(e.xAxis,o.xMin,o.xMax,r),d=F.getAxisStartEndGroup(e.xAxis,l.min,l.max)),e.yAxis&&(h=F._getAxisMinMax(e.yAxis,o.yMin,o.yMax,r)),e.y2Axis&&(g=F._getAxisMinMax(e.y2Axis,o.yMin,o.yMax,r)),{xMin:l.min,xMax:l.max,unchanged:l.unchanged,yMin:h.min,yMax:h.max,y2Min:g.min,y2Max:g.max,startGroup:d.startGroup,endGroup:d.endGroup}},_getAxisMinMax:(e,t,i,r)=>{if(null==t||null==i)return{min:null,max:null};var s=e.getUnboundedLinearValAt(t),a=e.getUnboundedLinearValAt(i);if(r){var n=e.getInfo().getMinExtent();if(a-s<n){var o=(a+s)/2;a=o+n/2,s=o-n/2}return F._limitToGlobal(e,s,a)}return F.getActualMinMax(e,s,a)},getAxisBoundsByDelta:(e,t,i,r,s)=>{var a=F._convertToAxisCoord(e,t,i,r,s),n=O.getZoomDir(e),o={},l={},h={},g={};return e.xAxis&&"y"!=n&&(o=F._getAxisMinMaxByDelta(e.xAxis,a.xMin,a.xMax),g=F.getAxisStartEndGroup(e.xAxis,o.min,o.max)),e.yAxis&&"x"!=n&&(l=F._getAxisMinMaxByDelta(e.yAxis,a.yMin,a.yMax)),e.y2Axis&&(h=F._getAxisMinMaxByDelta(e.y2Axis,a.yMin,a.yMax)),{xMin:o.min,xMax:o.max,unchanged:o.unchanged,yMin:l.min,yMax:l.max,y2Min:h.min,y2Max:h.max,startGroup:g.startGroup,endGroup:g.endGroup}},_getAxisMinMaxByDelta:(e,t,i)=>{var r=e.getLinearViewportMin(),s=e.getLinearViewportMax();if(i==t&&e.isFullViewport())return F.getActualMinMax(e,r,s);var a=e.getUnboundedLinearValAt(t)-e.getUnboundedLinearValAt(0),n=e.getUnboundedLinearValAt(i)-e.getUnboundedLinearValAt(0),o=1,l=s+n-(r+a),h=e.getInfo().getMinExtent();return t!=i&&l<h&&(o=(s-r-h)/(a-n)),r+=a*o,s+=n*o,F._limitToGlobal(e,r,s)},_convertToAxisCoord:(e,i,r,s,a)=>{var n={},o=t.Agent.isRightToLeft(e.getCtx());return l.isHorizontal(e)?(n.xMin=s,n.xMax=a,n.yMin=o?r:i,n.yMax=o?i:r):(n.xMin=o?r:i,n.xMax=o?i:r,n.yMin=a,n.yMax=s),n},_limitToGlobal:(e,t,i)=>{var r=e.getLinearGlobalMin(),s=e.getLinearGlobalMax();return i-t>=s-r?(t=r,i=s):t<r?(i+=r-t,t=r):i>s&&(t-=i-s,i=s),F.getActualMinMax(e,t,i)},getActualMinMax:(e,t,i)=>{var r={min:e.linearToActual(t),max:e.linearToActual(i)};if(e.isGroupAxis()){var s=e.getLinearViewportMin(),a=e.getLinearViewportMax();Math.abs(t-s)<1e-4&&Math.abs(i-a)<1e-4&&(r.unchanged=!0)}return r},getAxisStartEndGroup:(e,t,i)=>{if(e.isGroupAxis()&&null!=t&&null!=i){var r=Math.ceil(t),s=Math.floor(i);if(s>=r)return{startGroup:e.getInfo().getGroup(r),endGroup:e.getInfo().getGroup(s)}}return{startGroup:null,endGroup:null}},setInitialSelection:(e,t)=>{var i=e.getSelectionHandler();if(i)if(t&&0!=t.length){for(var r=[],s=0;s<t.length;s++)null!=t[s].id?r.push(t[s].id):null!=t[s].series&&null!=t[s].group&&r.push(a(t[s].series,t[s].group));for(var n=new(e.getCtx().KeySetImpl)(r),o=e.getChartObjPeers(),l=[],h=0;h<o.length;h++){var g=o[h];if(g.isSelectable()){var d=g.getDataItemId(),u=a(g.getSeries(),g.getGroup());(n.has(d)||n.has(u))&&l.push(g.getId())}}i.processInitialSelections(l,o)}else i.clearSelection()},getKeyboardNavigables:e=>{var t=[];if(l.isPie(e)&&e.pieChart)for(var i=e.pieChart.__getSlices(),r=0;r<i.length;r++)d.isSeriesRendered(e,i[r].getSeriesIndex())&&t.push(i[r]);else for(var s=e.getChartObjPeers(),a=0;a<s.length;a++)s[a].isNavigable()&&t.push(s[a]);return t},addEventData:(e,t)=>{var i=d.getSeriesIdx(e,t.series),r=d.getGroupIdx(e,t.group),s=d.getNestedDataItemIdx(e,i,r,t.id),a=c.getDataContext(e,i,r,s);a&&(t.data=a.data,t.itemData=a.itemData,t.seriesData=a.seriesData,a.groupData?t.groupData=a.groupData:null!=r&&(t.groupData=d.getGroupsDataForContext(e)[r]))},addGroupDrillEventData:(e,t)=>{var i={};Object.assign(i,t);var r=e.xAxis.getInfo().getItemsRange(t.group);delete i.series;for(var s=r.startIndex,a=r.endIndex,n=[],o=s;o<a+1;o++)for(var l=d.getSeriesCount(e),h=0;h<l;h++)n.push(d.getRawDataItem(e,h,o));return i.items=n,i.groupData=r.groupData,i},addMultiSeriesDrillEventData:(e,t)=>{var i={};Object.assign(i,t);var r=_._getSeriesIndicesArrays(e).other;delete i.group;for(var s=[],a=[],n=[],o=0;o<r.length;o++){var l=d.getSeriesDataForContext(e,r[o]),h=d.getRawDataItem(e,r[o],0);s.push(l),a.push(h),n.push(d.getSeries(e,r[o]))}return i.seriesData=s,i.items=a,i.series=n,i},addSeriesDrillEventData:(e,t)=>{var i={};Object.assign(i,t);var r=d.getSeriesIdx(e,t.id),s=d.getGroupCount(e);i.series=t.id,delete i.group,i.seriesData=d.getSeriesDataForContext(e,r);for(var a=[],n=0;n<s;n++){var o=d.getRawDataItem(e,r,n);a.push(o)}return i.items=a,i},addItemDrillEventData:(e,t)=>{var i={};Object.assign(i,t);var r=d.getSeriesIdx(e,t.series),s=d.getGroupIdx(e,t.group),a=d.getNestedDataItemIdx(e,r,s,t.id);return i.seriesData=d.getSeriesDataForContext(e,r),i.groupData=d.getGroupsDataForContext(e)[s],i.data=d.getRawDataItem(e,r,s,a),i.itemData=d.getDataItem(e,r,s,a)._itemData,i},addPlotAreaDnDBackground:(e,i,r,s)=>{var a=O.isPlotAreaDraggable(e);if(O.isPlotAreaDropTarget(e)||a){var n=new t.Rect(e.getCtx(),0,0,s?r.w:r.h,s?r.h:r.w);n.setInvisibleFill(),i.addChild(n),e.getCache().putToCache("plotAreaBackground",n),a&&n.setClassName("oj-draggable")}}},N={_DEFAULT_3D_GAP_RATIO:1/36,_DEFAULT_2D_GAP_RATIO:1/70,_MAX_WIDTH_FOR_GAPS:.25,_GROUP_IDX:0,_SLICE_VALUE_THRESHOLD:1e-4,render:(e,i,r)=>{var s=new t.Container(e.getCtx());s.setTranslate(r.x,r.y),i.addChild(s),e.setPlotArea(s);var a,n=l.isHorizontal(e);if(n)a=new t.Rectangle(0,0,r.w,r.h);else{var o=new t.Matrix,h=t.Agent.isRightToLeft(e.getCtx())?-1:1;o=(o=(o=o.translate(-r.h/2,-r.w/2)).rotate(h*Math.PI/2)).translate(r.x+r.w/2,r.y+r.h/2),a=new t.Rectangle(0,0,r.h,r.w),s.setMatrix(o)}F.addPlotAreaDnDBackground(e,s,r,n),N._renderFunnelSlices(e,s,a)||L(e,i,r);var g=d.getInitialSelection(e);F.setInitialSelection(e,g),e.highlight(d.getHighlightedCategories(e))},_renderFunnelSlices:(e,t,i)=>{for(var r=e.getOptions(),s=d.getSeriesCount(e),a=c.getDataItemGaps(e),n=("on"==r.styleDefaults.threeDEffect?N._DEFAULT_3D_GAP_RATIO:N._DEFAULT_2D_GAP_RATIO)*i.w,o=a*Math.min(N._MAX_WIDTH_FOR_GAPS*i.w/(s-1),n),l=0,h=0,g=0,u=0;u<s;u++)if(d.isDataItemRendered(e,u)){var _=d.getTargetVal(e,u);null==_&&(_=d.getVal(e,u,N._GROUP_IDX)),_<=0||(l+=_)}if(0==l)return!1;for(var p=s-1;p>=0;p--)if(d.isDataItemRendered(e,p)){var v,m=d.getVal(e,p,N._GROUP_IDX),x=d.getTargetVal(e,p);if(!(m<=0&&null==x||null!=x&&x<=0))if(!((null!=x?x:m)<N._SLICE_VALUE_THRESHOLD*l))null!=x?(g+=x/l,v=new B(e,p,h,i.w,i.h,1-g,x/l,m/x,o)):(g+=m/l,v=new B(e,p,h,i.w,i.h,1-g,m/l,null,o)),h++,t.addChild(v),f.associate(v,e,p,N._GROUP_IDX)}return!0}};class H extends t.Path{constructor(e,i,r,s,a,n,o,l){super(e.getCtx()),this._MIN_CHARS_DATA_LABEL=3,this._SLICE_LABEL_HORIZONTAL_PADDING=4,this._3D_WIDTH_FACTOR=.2,this._chart=e;var h=e.getOptions().styleDefaults;this._seriesIndex=i,this._numDrawnSeries=r,this._pyramidWidth=s,this._pyramidHeight=a,this._startPercent=n,this._valuePercent=o,this._3dRatio="on"==h.threeDEffect?1:0,this._gap=l;var g=this._getPath();this._dataColor=c.getColor(this._chart,this._seriesIndex,0),this._3dRatio>0?(this.setCmds(g.threeDPathTop),this._threeDPathSide=new t.Path(this.getCtx(),g.threeDPathSide),this._mainFace=new t.Path(this.getCtx(),g.slice),this.addChild(this._threeDPathSide),this.addChild(this._mainFace)):this.setCmds(g.slice),this._setColorProps(g.sliceBounds),this._label=this._getSliceLabel(g.sliceBounds),null!=this._label&&(this._label.setMouseEnabled(!1),this.addChild(this._label))}_getPath(){var e,i,r,s,a,n,o=t.Agent.isRightToLeft(this.getCtx()),l=d.getSeriesCount(this._chart),h=(l-this._numDrawnSeries-1)*this._gap,g=this._3dRatio*this._3D_WIDTH_FACTOR*.98*this._pyramidWidth,u=this._chart.getOptions(),_=Math.sqrt(Math.pow(this._pyramidHeight-(l-1)*this._gap,2)*(1-this._startPercent)),c=this._startPercent+this._valuePercent>=1?0:Math.sqrt(Math.pow(this._pyramidHeight-(l-1)*this._gap,2)*(1-this._startPercent-this._valuePercent)),p=.98*(1-this._3dRatio*this._3D_WIDTH_FACTOR)*this._pyramidWidth*(c/this._pyramidHeight),v=0==this._numDrawnSeries?_:_-this._gap,m=.98*(1-this._3dRatio*this._3D_WIDTH_FACTOR)*this._pyramidWidth*(v/this._pyramidHeight);if(o?(i=[this._pyramidWidth-.5*this._pyramidWidth+g/2-p/2,h+c],s=[this._pyramidWidth-.5*this._pyramidWidth+g/2-m/2,h+_],r=[this._pyramidWidth-.5*this._pyramidWidth+g/2+m/2,h+_],e=[this._pyramidWidth-.5*this._pyramidWidth+g/2+p/2,h+c]):(e=[.5*this._pyramidWidth-g/2-p/2,h+c],r=[.5*this._pyramidWidth-g/2-m/2,h+_],s=[.5*this._pyramidWidth-g/2+m/2,h+_],i=[.5*this._pyramidWidth-g/2+p/2,h+c]),"on"==u.styleDefaults.threeDEffect){var f=Math.atan(2*_/m),x=Math.min(.9*f,Math.PI/4),C=this._3dRatio*this._3D_WIDTH_FACTOR*m*Math.sqrt(2)/2,S=this._3dRatio*this._3D_WIDTH_FACTOR*p*Math.sqrt(2)/2,A=S/Math.tan(x);a=t.PathUtils.moveTo(i[0],i[1]),a+=t.PathUtils.lineTo(i[0]+(o?-1:1)*Math.max(S,1),i[1]-Math.max(S,.5)),a+=t.PathUtils.lineTo(e[0]+(o?-1:1)*Math.max(A,1),e[1]-Math.max(S,.5)),a+=t.PathUtils.lineTo(e[0],e[1]),a+=t.PathUtils.closePath(),n=t.PathUtils.moveTo(i[0],i[1]),n+=t.PathUtils.lineTo(i[0]+(o?-1:1)*Math.max(S,1),i[1]-Math.max(S,.5)),n+=t.PathUtils.lineTo(s[0]+(o?-1:1)*C,s[1]-C),n+=t.PathUtils.lineTo(s[0],s[1]),n+=t.PathUtils.closePath()}var b=t.PathUtils.moveTo(i[0],i[1]);b+=t.PathUtils.lineTo(s[0],s[1]),b+=t.PathUtils.lineTo(r[0],r[1]),b+=t.PathUtils.lineTo(e[0],e[1]),b+=t.PathUtils.closePath();var y=p/m,M=.5*Math.abs(e[1]-r[1])*(1+y),D=.5*Math.abs(s[0]-r[0])*(1+y)-this._SLICE_LABEL_HORIZONTAL_PADDING,T=r[1]-M,I=r[0]+(m-D)/2*(o?-1:1);return{slice:b,sliceBounds:new t.Rectangle(I,T,D,M),threeDPathTop:a,threeDPathSide:n}}_getSliceLabel(e){var i=c.getDataLabel(this._chart,this._seriesIndex,0);if(i||(i=d.getSeriesLabel(this._chart,this._seriesIndex)),i&&"none"!=R.getDataLabelPos(this._chart,this._seriesIndex,0)){var r=new t.MultilineText(this.getCtx(),i,0,0),s=null!=c.getPattern(this._chart,this._seriesIndex,0),a=this._chart.getOptions().styleDefaults,n=[a._dataLabelStyle,a.dataLabelStyle,new t.CSSStyle(d.getDataItem(this._chart,this._seriesIndex,0).labelStyle)],o=t.CSSStyle.mergeStyles(n);if(r.setCSSStyle(o),t.TextUtils.fitText(r,e.w,e.h,this,this._MIN_CHARS_DATA_LABEL)){var l=r.getDimensions(),h=this._getLabelPos(e);if(s){var g=.15*l.h,u=t.PathUtils.roundedRectangle(l.x-g,l.y,l.w+2*g,l.h,2,2,2,2),_=new t.Path(this.getCtx(),u);_.setSolidFill("#FFFFFF",.9),h=h.translate(-.5*l.w,-.5*l.h),_.setMatrix(h),this.addChild(_)}var p=s?"#000000":e.containsPoint(e.x+(e.w-l.w)/2,e.y)?t.ColorUtils.getContrastingTextColor(this._dataColor):t.ColorUtils.getContrastingTextColor(null),v=new t.CSSStyle({color:p});return n.splice(1,0,v),t.Agent.isHighContrast()&&n.push(v),o=t.CSSStyle.mergeStyles(n),r.setCSSStyle(o),r.setMatrix(this._getLabelPos(e)),r.alignCenter(),r.alignMiddle(),r}}}_getLabelPos(e){var i=new t.Matrix;return i=t.Agent.isRightToLeft(this.getCtx())?i.translate(e.x-e.w/2,e.y+e.h/2):i.translate(e.x+e.w/2,e.y+e.h/2)}_setColorProps(e){var i=k.getFunnelPyramidSliceFill(this._chart,this._seriesIndex,this._dataColor,e),r=c.getBorderColor(this._chart,this._seriesIndex,0),s=c.getUserBorderWidth(this._chart,this._seriesIndex,0),a=c.getDefaultBorderWidth(this._chart,this._seriesIndex,0),n=null!==s?s:a,o=!1,l="redwood"===this.getCtx().getThemeBehavior();null==r&&this._3dRatio>0&&(o=!0,r="#FFFFFF"),!r||l&&this._chart.isSelectionSupported()&&o||(this.setSolidStroke(r,null,n),this._3dRatio>0&&(this._threeDPathSide.setSolidStroke(r,null,n),this._mainFace.setSolidStroke(r,null,n)));var h=t.SelectionEffectUtils.getHoverBorderColor(this._dataColor);if(this._3dRatio>0){var g=!i.getPattern&&!i.getAlphas;this._mainFace.setFill(i),this._mainFace.setStyle(c.getStyle(this._chart,this._seriesIndex,0)),this._mainFace.setClassName(c.getClassName(this._chart,this._seriesIndex,0)),this._threeDPathSide.setFill(g?new t.SolidFill(t.ColorUtils.getDarker(i.getColor(),.3)):i),this._threeDPathSide.setStyle(c.getStyle(this._chart,this._seriesIndex,0)),this._threeDPathSide.setClassName(c.getClassName(this._chart,this._seriesIndex,0)),this.setFill(g?new t.SolidFill(t.ColorUtils.getDarker(i.getColor(),.3)):i),this.setStyle(c.getStyle(this._chart,this._seriesIndex,0)),this.setClassName(c.getClassName(this._chart,this._seriesIndex,0))}else this.setFill(i),this.setStyle(c.getStyle(this._chart,this._seriesIndex,0)),this.setClassName(c.getClassName(this._chart,this._seriesIndex,0));if(this.OriginalStroke=this.getStroke(),this._chart.isSelectionSupported())if(this.setCursor(t.SelectionEffectUtils.getSelectingCursor()),this._3dRatio>0)if(this._mainFace.setCursor(t.SelectionEffectUtils.getSelectingCursor()),this._threeDPathSide.setCursor(t.SelectionEffectUtils.getSelectingCursor()),l){this._mainFace.setFeedbackClassName("oj-dvt-selectable"),this._threeDPathSide.setFeedbackClassName("oj-dvt-selectable");var d=null==r||o?this._dataColor:r,u=null!==s?s:0;this._mainFace.setSolidStroke(d,null,u),this._threeDPathSide.setSolidStroke(d,null,u),r&&(o&&(this._mainFace.addClassName("oj-dvt-default-border-color"),this._threeDPathSide.addClassName("oj-dvt-default-border-color")),null==s&&(this._mainFace.addClassName("oj-dvt-default-border-width"),this._threeDPathSide.addClassName("oj-dvt-default-border-width")))}else{var _=c.getSelectedInnerColor(this._chart),p=c.getSelectedOuterColor(this._chart)?c.getSelectedOuterColor(this._chart):this._dataColor;this._mainFace.setHoverStroke(new t.Stroke(h,1,2)),this._threeDPathSide.setHoverStroke(new t.Stroke(h,1,2)),this._mainFace.setSelectedStroke(new t.Stroke(_,1,1.5),new t.Stroke(p,1,4.5)),this._mainFace.setSelectedHoverStroke(new t.Stroke(_,1,1.5),new t.Stroke(h,1,4.5))}else if(this.setCursor(t.SelectionEffectUtils.getSelectingCursor()),l){this.setFeedbackClassName("oj-dvt-selectable");d=null==r||o?this._dataColor:r,u=null!==s?s:0;this.setSolidStroke(d,null,u),r&&(o&&this.addClassName("oj-dvt-default-border-color"),null==s&&this.addClassName("oj-dvt-default-border-width"))}else{_=c.getSelectedInnerColor(this._chart),p=c.getSelectedOuterColor(this._chart)?c.getSelectedOuterColor(this._chart):this._dataColor;this.setHoverStroke(new t.Stroke(h,1,2)),this.setSelectedStroke(new t.Stroke(_,1,1.5),new t.Stroke(p,1,4.5)),this.setSelectedHoverStroke(new t.Stroke(_,1,1.5),new t.Stroke(h,1,4.5))}}getAnimParams(){return[this._startPercent,this._valuePercent,this.getAlpha(),this._3dRatio]}setAnimParams(e){this._startPercent=e[0],this._valuePercent=e[1],this.setAlpha(e[2]),this._3dRatio=e[3];var t=this._getPath();this._threeDPathSide&&this._mainFace?(this.setCmds(t.threeDPathTop),this._threeDPathSide.setCmds(t.threeDPathSide),this._mainFace.setCmds(t.slice)):this.setCmds(t.slice),this._label&&this._label.setMatrix(this._getLabelPos(t.sliceBounds))}setSelected(e){if(this._3dRatio>0)if(this._mainFace.setSelected(e),"redwood"===this.getCtx().getThemeBehavior()&&this._threeDPathSide.setSelected(e),e){var t=this.getDimensions(),i=t.w,r=t.h,s=(i-3)/i,a=(r-5)/r;this._mainFace.setScaleX(s),this._mainFace.setScaleY(a),this._mainFace.setTranslateX(Math.ceil(1.5)+3/i*t.x),this._mainFace.setTranslateY(Math.ceil(2.5)+5/r*t.y)}else this._mainFace.setScaleX(1),this._mainFace.setScaleY(1),this._mainFace.setTranslateX(0),this._mainFace.setTranslateY(0);else super.setSelected(e)}showHoverEffect(){"redwood"===this.getCtx().getThemeBehavior()&&0!==this._3dRatio||super.showHoverEffect(),this._3dRatio>0&&(this._threeDPathSide.showHoverEffect(),this._mainFace.showHoverEffect())}hideHoverEffect(){"redwood"===this.getCtx().getThemeBehavior()&&0!==this._3dRatio||super.hideHoverEffect(),this._3dRatio>0&&(this._threeDPathSide.hideHoverEffect(),this._mainFace.hideHoverEffect())}copyShape(){return new H(this._chart,this._seriesIndex,this._numDrawnSeries,this._pyramidWidth,this._pyramidHeight,this._startPercent,this._valuePercent,this._gap)}getPrimaryFill(){return this._mainFace?this._mainFace.getFill():this.getFill()}}const G={_DEFAULT_GAP_RATIO:1/70,_MAX_HEIGHT_FOR_GAPS:.25,_GROUP_IDX:0,render:(e,i,r)=>{var s=new t.Container(e.getCtx());s.setTranslate(r.x,r.y),i.addChild(s),e.setPlotArea(s);var a=new t.Rectangle(0,0,r.w,r.h);F.addPlotAreaDnDBackground(e,s,r,!0),G._renderPyramidSlices(e,s,a)||L(e,i,r);var n=d.getInitialSelection(e);F.setInitialSelection(e,n),e.highlight(d.getHighlightedCategories(e))},_renderPyramidSlices:(e,t,i)=>{for(var r=d.getSeriesCount(e),s=c.getDataItemGaps(e),a=G._DEFAULT_GAP_RATIO*i.h,n=s*Math.min(G._MAX_HEIGHT_FOR_GAPS*i.h/(r-1),a),o=0,l=0,h=0,g=0;g<r;g++)if(d.isDataItemRendered(e,g)){var u=d.getVal(e,g,G._GROUP_IDX);u<=0||(o+=u)}if(0==o)return!1;for(var _=0;_<r;_++)if(d.isDataItemRendered(e,_)){var p=d.getVal(e,_,G._GROUP_IDX);if(!(p<=0)){var v=new H(e,_,l,i.w,i.h,h,p/o,n);h+=p/o,l++,t.addChild(v),f.associate(v,e,_,G._GROUP_IDX)}}return!0}};class U extends t.Path{setWedgeParams(e,t,i,r,s,a,n,o){this._cx=e,this._cy=t,this._rx=i,this._ry=r,this._sa=s,this._ae=a,this._gap=n,this._ir=o;var l=this._makeWedgePath(0);this.setCmds(l)}_makeWedgePath(e){var i,r=Math.max(this._rx-e,0),s=Math.max(this._ry-e,0),a=360==this._ae||r<e?0:this._gap+2*e,n=this._ir?this._ir+e:0,o=360==this._ae?t.Math.degreesToRads(359.99):t.Math.degreesToRads(this._ae),l=t.Math.degreesToRads(this._sa),h=a/2,g=h<r?Math.asin(h/r):0,d=-o/2-l,u=Math.min(5*h,o>0?Math.abs(h/Math.sin(o/2)):0),_=0==r?u:u*s/r,c=this._cx+Math.cos(d)*u,p=this._cy+Math.sin(d)*_,v=this._cx+Math.cos(-g-l)*r,m=this._cy+Math.sin(-g-l)*s,f=this._cx+Math.cos(-l-o+g)*r,x=this._cy+Math.sin(-l-o+g)*s,C=t.Math.calculateAngleBetweenTwoVectors(f-this._cx,x-this._cy,v-this._cx,m-this._cy);if(C=Math.min(C,o),n>0){var S=h<n?Math.asin(h/n):0,A=this._cx+Math.cos(-S-l)*n,b=this._cy+Math.sin(-S-l)*n,y=this._cx+Math.cos(-l-o+S)*n,M=this._cy+Math.sin(-l-o+S)*n,D=t.Math.calculateAngleBetweenTwoVectors(y-this._cx,M-this._cy,A-this._cx,b-this._cy);D=Math.min(D,C,o),360==this._ae?(i=t.PathUtils.moveTo(f,x),i+=t.PathUtils.arcTo(r,s,o,1,v,m),i+=t.PathUtils.lineTo(f,x),i+=t.PathUtils.moveTo(A,b),i+=t.PathUtils.arcTo(n,n,o,0,y,M)):(i=t.PathUtils.moveTo(y,M),i+=t.PathUtils.lineTo(f,x),i+=t.PathUtils.arcTo(r,s,C,1,v,m),i+=t.PathUtils.lineTo(A,b),i+=t.PathUtils.arcTo(n,n,D,0,y,M))}else 360==this._ae?(i=t.PathUtils.moveTo(f,x),i+=t.PathUtils.arcTo(r,s,o,1,v,m)):(i=t.PathUtils.moveTo(c,p),i+=t.PathUtils.lineTo(f,x),i+=t.PathUtils.arcTo(r,s,C,1,v,m));return i+=t.PathUtils.closePath()}_initializeSelectionEffects(){var e="redwood"===this.getCtx().getThemeBehavior(),i=this.isSelected()||e?U._OUTER_BORDER_WIDTH:U._OUTER_BORDER_WIDTH_HOVER,r=this._makeWedgePath(i),s=this._makeWedgePath(i+U._INNER_BORDER_WIDTH);if(this.OuterChild)return this.OuterChild.setCmds(r),void this.InnerChild.setCmds(s);this.OuterChild=new t.Path(this.getCtx(),r),this.OuterChild.setInvisibleFill(),this.OuterChild.setMouseEnabled(!0),this.addChild(this.OuterChild),this.InnerChild=new t.Path(this.getCtx(),s),this.InnerChild.setInvisibleFill(),this.InnerChild.setMouseEnabled(!0),this.addChild(this.InnerChild)}_showNestedBorders(e,t){this._initializeSelectionEffects(),t?(this.setSolidFill(e),this.setStroke(null),this.setClassName().setStyle(),this.OuterChild.setSolidFill(t),this.OuterChild.setClassName().setStyle(),this.InnerChild.setFill(this._fill),this.InnerChild.setClassName(this._shapeClassName).setStyle(this._shapeStyle)):e?(this.setSolidFill(e),this.setStroke(null),this.setClassName().setStyle(),this.OuterChild.setFill(this._fill),this.OuterChild.setClassName(this._shapeClassName).setStyle(this._shapeStyle),this.InnerChild.setInvisibleFill(),this.InnerChild.setClassName().setStyle()):(this.setFill(this._fill),this.setStroke(this._shapeStroke),this.setClassName(this._shapeClassName).setStyle(this._shapeStyle),this.OuterChild.setInvisibleFill(),this.OuterChild.setClassName().setStyle(),this.InnerChild.setInvisibleFill(),this.InnerChild.setClassName().setStyle())}setStyleProperties(e,i,r,s,a,n,o){this._fill=e,this._shapeStroke=i;var l="redwood"===this.getCtx().getThemeBehavior();this._hoverColor=l?r:t.SelectionEffectUtils.getHoverBorderColor(r),this._innerColor=s,this._outerColor=a,this._shapeClassName=n,this._shapeStyle=o,this.setStyle(o).setClassName(n),this.setFill(e),i&&this.setStroke(i)}showHoverEffect(){this.IsShowingHoverEffect=!0;var e="redwood"===this.getCtx().getThemeBehavior()&&this.isSelected()?this._outerColor:this._hoverColor;this._showNestedBorders(e,this._innerColor)}hideHoverEffect(){this.IsShowingHoverEffect=!1,this.isSelected()?this._showNestedBorders(this._outerColor,this._innerColor):this._showNestedBorders()}setSelected(e){if(this.IsSelected!=e){this.IsSelected=e;var t="redwood"===this.getCtx().getThemeBehavior();if(this.isHoverEffectShown()){var i=t&&this.isSelected()?this._outerColor:this._hoverColor;this._showNestedBorders(i,this._innerColor)}else this.isSelected()?this._showNestedBorders(this._outerColor,this._innerColor):this._showNestedBorders()}}UpdateSelectionEffect(){}}U._OUTER_BORDER_WIDTH=2,U._OUTER_BORDER_WIDTH_HOVER=1.25,U._INNER_BORDER_WIDTH=1;class V{constructor(){this._sliceLabel=null,this._slice=null,this._angle=-1,this._position=-1,this._width=-1,this._height=-1,this._x=-1,this._y=-1,this._initialNumLines=-1,this._hasFeeler=!1,this._maxY=-1,this._minY=-1}getAngle(){return this._angle}setAngle(e){this._angle=e}getHeight(){return this._height}setHeight(e){this._height=e}getInitialNumLines(){return this._initialNumLines}setInitialNumLines(e){this._initialNumLines=e}getMaxY(){return this._maxY}setMaxY(e){this._maxY=e}getMinY(){return this._minY}setMinY(e){this._minY=e}boundY(e){return this._minY<=this._maxY&&(e=Math.max(e,this._minY),e=Math.min(e,this._maxY)),e}hasFeeler(){return this._hasFeeler}setHasFeeler(e){this._hasFeeler=e}getPosition(){return this._position}setPosition(e){this._position=e}getSlice(){return this._slice}setSlice(e){this._slice=e}getSliceLabel(){return this._sliceLabel}setSliceLabel(e){this._sliceLabel=e}getWidth(){return this._width}setWidth(e){this._width=e}getX(){return this._x}setX(e){this._x=e}getY(){return this._y}setY(e){this._y=e}}const Y={SURFACE_CRUST:0,SURFACE_LEFT:1,SURFACE_RIGHT:2,reflectAngleOverYAxis:(e,i,r,s,a)=>{var n=t.Math.degreesToRads(360-e);return{x:i+Math.cos(n)*s,y:r+Math.sin(n)*a}},getGradientColors:(e,i)=>"2D"==i||"3D"==i?[t.ColorUtils.adjustHSL(e,0,-.04,-.05),t.ColorUtils.adjustHSL(e,0,-.09,.04)]:"CRUST"==i?[t.ColorUtils.adjustHSL(e,0,-.04,-.05),t.ColorUtils.adjustHSL(e,0,0,-.14)]:"SIDE"==i?[t.ColorUtils.adjustHSL(e,0,-.1,.06),t.ColorUtils.adjustHSL(e,0,-.04,-.05)]:void 0,getGradientAlphas:(e,t)=>{var i=null==e||isNaN(e)||0==e?1:e;return"2D"==t?[i,i,i]:"BORDER"==t?[i/1.59375,i/5.3125,i/(255/96)]:"3D"==t?[i,i,i,i,i]:"CRUST"==t?[i,i,i,i]:"SIDE"==t?[i,i]:void 0},createTopSurface:(e,i)=>{var r=e.getPieChart(),s=r.getCtx(),a=e.getCenter(),n=e.getInnerRadius(),o=r.is3D()||e.getSliceGaps()>Math.sin(t.Math.degreesToRads(e.getAngleExtent()))*e._radiusX+1?null:e.getSliceGaps(),l=new U(s);l.setWedgeParams(a.x,a.y,e._radiusX,e._radiusY,e.getAngleStart(),e.getAngleExtent(),o,n);var h=c.getSelectedInnerColor(r.chart),g=c.getSelectedOuterColor(r.chart),d=new t.Stroke(e.getStrokeColor(),1,e.getBorderWidth()),u=e.getSeriesIndex(),_=c.getClassName(r.chart,u,0),p=c.getStyle(r.chart,u,0);l.setStyleProperties(i,d,e.getFillColor(),h,g,_,p);var v=[l];return Y.associate(e,v),v},associate:(e,t)=>{if(t)for(var i=0;i<t.length;i++)e.getPieChart().chart.getEventManager().associate(t[i],e)},createLateralSurface:(e,i,r)=>{if(0==e.getAngleExtent())return[];var s=[];if(t.ColorUtils.getAlpha(e.getFillColor())>0)if(i==Y.SURFACE_LEFT||i==Y.SURFACE_RIGHT)s.push(Y._generateLateralShape(e,i,null,r));else if(i==Y.SURFACE_CRUST)for(var a=Y._createCrustPathCommands(e),n=a.length,o=0;o<n;o++)s.push(Y._generateLateralShape(e,i,a[o],r));return Y.associate(e,s),s},generateLateralGradientFill:(e,i)=>{var r=Y.getGradientColors(t.ColorUtils.getRGB(e.getFillColor()),i),s=Y.getGradientAlphas(t.ColorUtils.getAlpha(e.getFillColor()),i);return new t.LinearGradientFill(270,r,s,[0,1],null)},_generateLateralShape:(e,i,r,s)=>{var a=e.getPieChart().getCtx();if(i==Y.SURFACE_LEFT||i==Y.SURFACE_RIGHT){for(var n=e.getAngleStart(),o=e.getAngleExtent(),l=e.getCenter().x,h=e.getCenter().y,g=e._radiusX,d=e._radiusY,u=e.getDepth(),_=i==Y.SURFACE_LEFT?Y.reflectAngleOverYAxis(n+o,l,h,g,d):Y.reflectAngleOverYAxis(n,l,h,g,d),c=Y._generateInnerPoints(l,h,_.x,_.y,u),p=[],v=0;v<c.length;v++)p.push(c[v].x,c[v].y);var m=new t.Polygon(a,p);return m.setFill(s),e.getStrokeColor()&&m.setSolidStroke(e.getStrokeColor()),m}if(r){var f=new t.Path(a,null);return f.setCmds(r),f.setTranslate(e.__getExplodeOffsetX(),e.__getExplodeOffsetY()),f.setFill(s),e.getStrokeColor()&&f.setSolidStroke(e.getStrokeColor()),f}return null},_createCrustPathCommands:e=>{var t=e.getAngleStart(),i=e.getAngleExtent(),r=t+i,s=e.getCenter().x,a=e.getCenter().y,n=e._radiusX,o=e._radiusY,l=e.getDepth(),h=[];return t<180&&r>360?(h.push(Y._makeOuterPath(s,a,n,o,l,t,180-t)),h.push(Y._makeOuterPath(s,a,n,o,l,360,r-360)),h.push(Y._makeOuterPath(s,a,n,o,l,180,180))):r>360?(h.push(Y._makeOuterPath(s,a,n,o,l,t,360-t)),h.push(Y._makeOuterPath(s,a,n,o,l,360,r-360))):t<180&&r>180?(h.push(Y._makeOuterPath(s,a,n,o,l,t,180-t)),h.push(Y._makeOuterPath(s,a,n,o,l,180,r-180))):h.push(Y._makeOuterPath(s,a,n,o,l,t,i)),h},_makeOuterPath:(e,i,r,s,a,n,o)=>{var l=t.Math.degreesToRads(o),h=-(t.Math.degreesToRads(n)+l),g=Y.reflectAngleOverYAxis(n,e,i,r,s),d=e+Math.cos(h)*r,u=i+Math.sin(h)*s,_=t.PathUtils.moveTo(g.x,g.y);return _+=t.PathUtils.arcTo(r,s,l,0,d,u),_+=t.PathUtils.lineTo(d,u+a),_+=t.PathUtils.arcTo(r,s,l,1,g.x,g.y+a),_+=t.PathUtils.lineTo(g.x,g.y)},_generateInnerPoints:(e,t,i,r,s)=>{var a=[];return a.push({x:e,y:t}),a.push({x:i,y:r}),a.push({x:i,y:r+s}),a.push({x:e,y:t+s}),a}},W={_MAX_LINES_PER_LABEL:3,_COLLISION_MARGIN:1,_LEFT_SIDE_LABELS:1,_RIGHT_SIDE_LABELS:2,_OUTSIDE_LABEL_DISTANCE:1.04,_FEELER_RAD_MINSIZE:.1,_FEELER_HORIZ_MINSIZE:.1,_LABEL_TO_FEELER_OFFSET:.5,_LABEL_TO_FEELER_DISTANCE:3,_NO_COLLISION:0,_HALF_COLLISION:1,_ALL_COLLISION:2,layoutLabelsAndFeelers:e=>{var t=e.getLabelPos();W._layoutInsideLabels(e,"auto"==t),W._layoutOutsideLabelsAndFeelers(e)},_layoutInsideLabels:(e,i)=>{for(var r=e.__getSlices(),s=0;s<r.length;s++){var a=r[s],n=e.getSeriesLabelPos(a.getSeriesIndex());if("none"!=n&&"outsideSlice"!=n&&!W._skipSliceLabel(e,a)){var o=a.getAngleStart()+a.getAngleExtent()/2,l=a.getInnerRadius(),h=a.getCenter(),g=0,d=0,u=W._createLabel(a,!0);if(1==r.length)g=h.x,d=h.y;else{var _=Math.max(.45,.65-.45*l/Math.max(a.getRadiusY(),.001)),c=Y.reflectAngleOverYAxis(o,h.x,h.y,l+(a.getRadiusX()-l)*_,l+(a.getRadiusY()-l)*_);g=c.x,d=c.y}u.setX(g),u.setY(d),u.alignMiddle(),u.alignCenter();for(var p=u.getDimensions(),v=g,m=g,f=d-p.h/2,x=d+p.h/2;a.contains(v,f)&&a.contains(v,x);)v--;for(;a.contains(m,f)&&a.contains(m,x);)m++;v=Math.ceil(v+3),m=Math.floor(m-3);var C=2*Math.min(g-v,m-g);if(C<p.w&&(u.setX((v+m)/2),C=m-v),i&&"center"!=n){u.getDimensions().w<C?a.setSliceLabel(u):a.setSliceLabel(null)}else{var S=e.getCtx().getStage(),A=W._isTextLabel(e,a)?null:u.getTextString().length;t.TextUtils.fitText(u,C,p.h,S,A)&&(S.removeChild(u),a.setSliceLabel(u))}null!=a.getSliceLabel()&&a.setNoOutsideFeeler()}}},_layoutOutsideLabelsAndFeelers:e=>{var t,i,r=W._generateInitialLayout(e);t=r[0],i=r[1];var s=W._refineInitialLayout(e,t,W._LEFT_SIDE_LABELS),a=W._refineInitialLayout(e,i,W._RIGHT_SIDE_LABELS);s==W._HALF_COLLISION&&a!=W._NO_COLLISION&&W._columnLabels(e,t,!0,!0,!0),s!=W._NO_COLLISION&&a==W._HALF_COLLISION&&W._columnLabels(e,i,!1,!0,!0),W._setLabelsAndFeelers(e,t,W._LEFT_SIDE_LABELS),W._setLabelsAndFeelers(e,i,W._RIGHT_SIDE_LABELS)},_createLabel:(e,i)=>{var r=e.getPieChart(),s=r.getCtx(),a=i?new t.OutputText(s):new t.MultilineText(s),n=t.ColorUtils.getContrastingTextColor(e.getFillColor()),o=new t.CSSStyle({color:n}),l=r.getOptions().styleDefaults,h=[l._dataLabelStyle];i&&h.push(o),h.push(l.dataLabelStyle);var g=d.getDataItem(r.chart,e.getSeriesIndex(),0);g&&h.push(new t.CSSStyle(g.labelStyle)),t.Agent.isHighContrast()&&h.push(o);var u=t.CSSStyle.mergeStyles(h);a.setCSSStyle(u);var _=W.generateSliceLabelString(e,l.sliceLabelType);return a.setTextString(_),e.setSliceLabelString(_),a},createPieCenter:e=>{var i=e.getOptions(),r=e.getCtx(),s=W.getPieCenterOptions(e,i),a=s.label,n=s.renderer,o=e.getLabelPos(),l=i.tooltip,h=l?l.renderer:null,d=e.getCenter(),u=e.getInnerRadius();if(a||n){var _=e.getRadiusX(),c=(u=u>0?u:"outsideSlice"==o?.9*_:.5*_)*Math.sqrt(2);if(a){var p=new t.MultilineText(r),v=s.labelStyle;if(p.setCSSStyle(v),"number"==typeof a&&(a=g.formatVal(e,s,a,a,a,0)),p.setTextString(a),t.TextUtils.fitText(p,c,c,e)){var m=p.getDimensions();p.setY(d.y-m.h/2),p.setX(d.x),p.alignCenter(),h||e.chart.getEventManager().associate(p,new t.SimpleObjPeer(p.getTextString(),null,null,{type:"pieCenterLabel"})),e.addChild(p),e.setCenterLabel(p)}}if(h){var f=new t.Circle(r,d.x,d.y,u);f.setInvisibleFill(),e.addChild(f);var x=e.getCtx().getTooltipManager();e.chart.getEventManager().associate(f,new t.CustomDatatipPeer(x,h,"#4b4b4b",{component:i._widgetConstructor,label:a}))}if(n){var C={outerBounds:{x:d.x-u,y:d.y-u,width:2*u,height:2*u},innerBounds:{x:d.x-c/2,y:d.y-c/2,width:c,height:c},label:a,totalValue:e.getTotalValue(),component:i._widgetConstructor};C=r.fixRendererContext(C);var S=r.getContainer(),A=e.chart.pieCenterDiv;A&&S.removeChild(A);var b=n(C);if(!b)return;var y=r.createOverlayDiv();Array.isArray(b)?b.forEach(e=>{y.appendChild(e)}):"string"==typeof b?(y.textContent=b,y.style.position="absolute",y.style.left=d.x+"px",y.style.top=d.y+"px",y.style.transform="translate(-50%, -50%)",y.style.width=2*u+"px",y.style.height=2*u+"px",y.style.display="flex",y.style.textAlign="center",y.style.alignItems="center"):y.appendChild(b),e.chart.pieCenterDiv=y,S.appendChild(y);var M=r.getOverlayAttachedCallback();M&&M(y)}}},generateSliceLabelString:(e,t)=>{var i,r=W.getDefaultSliceLabelString(e,t),s=e.getPieChart().getOptions().dataLabel;if(s){var a=c.getDataContext(e._chart,e.getSeriesIndex(),0);if(a.label=r,"number"==typeof(i=s(a))){var n=g.getValueFormat(e.getPieChart().chart,"label");i=g.formatVal(e.getPieChart(),n,i)}}return i||r},getDefaultSliceLabelString:(e,t)=>{var i=e.getPieChart(),r=e.getCustomLabel(),s=g.getValueFormat(i.chart,"label");return null!=r?"number"==typeof r?g.formatVal(i,s,r):r:"percent"==t?W.generateSlicePercentageString(e):"number"==t?g.formatVal(i,s,e.getVal()):"text"==t?e.getSeriesLabel():"textAndPercent"==t?e.getSeriesLabel()+", "+W.generateSlicePercentageString(e):null},generateSlicePercentageString:e=>{var t=e.getPieChart(),i=t.getTotalValue(),r=0==i?0:e.getVal()/i,s=r<.01?3:r<.1?2:r<1?1:0;2*t.getRadiusX()<150&&(s=Math.max(s-1,0));var a=t.getCtx().getNumberConverter({style:"percent",maximumFractionDigits:s,minimumFractionDigits:s}),n="";return a&&a.format?n=a.format(r):(r*=100,n=g.formatVal(t,{},r,null,null,100==r?1:Math.pow(10,-1*s))+"%"),n},_refineInitialLayout:(e,t,i)=>{if(t&&t.length>0){for(var r,s,a=e.__getFrame().y,n=!1,o=!1,l=!1,h=0,g=!1,d=i==W._LEFT_SIDE_LABELS,u=0;u<t.length;u++)s=g,(r=t[u]).getPosition()>90&&(g=!0),h=r.getY()+r.getHeight(),a-r.getY()>W._COLLISION_MARGIN&&(g?s?l=!0:o=!0:n=!0),h>a&&(a=h);return n&&l||o?(W._columnLabels(e,t,d,!0,!0),W._ALL_COLLISION):n?(W._columnLabels(e,t,d,!0,!1),W._HALF_COLLISION):l?(W._columnLabels(e,t,d,!1,!0),W._HALF_COLLISION):W._NO_COLLISION}},_setLabelsAndFeelers:(e,i,r)=>{if(!(null==i||i.length<=0)){var s,a,n,o,l,h=r==W._LEFT_SIDE_LABELS,g=e.__getFrame(),d=1/0;for(s=0;s<i.length;s++)if(a=(o=i[s]).getSlice(),o.hasFeeler()){l=W._calculateFeeler(o,a,h);var u=t.TextUtils.getTextStringHeight(e.getCtx(),o.getSliceLabel().getCSSStyle()),_=o.getWidth(),c=W._isTextLabel(e,a)?Math.min(2*u,_):_;if(W.getMaxLabelWidth(e,o.getX(),h)+l<c||0==o.getWidth()){o.setSliceLabel(null),a.setNoOutsideFeeler();continue}d=Math.min(d,l)}else a.setNoOutsideFeeler();for(s=0;s<i.length;s++)a=(o=i[s]).getSlice(),(n=o.getSliceLabel())&&(o.hasFeeler()&&(h?o.setX(o.getX()+d):o.setX(o.getX()-d),W._calculateFeeler(o,a,h)),n.setY(o.getY()),n.setX(o.getX()),o.getY()<g.y||o.getY()+o.getHeight()>g.y+g.h?(a.setSliceLabel(null),a.setNoOutsideFeeler()):(W._truncateSliceLabel(e,a,o,h),0==o.getWidth()||0==o.getHeight()?(a.setSliceLabel(null),a.setNoOutsideFeeler()):a.setSliceLabel(n)))}},_calculateFeeler:(e,i,r)=>{var s=e.getX(),a=e.getY()+e.getHeight()*W._LABEL_TO_FEELER_OFFSET,n=W._FEELER_HORIZ_MINSIZE*i.getRadiusX(),o={x:r?(s+=W._LABEL_TO_FEELER_DISTANCE)+n:(s-=W._LABEL_TO_FEELER_DISTANCE)-n,y:a},l={x:s,y:a},h=e.getAngle(),g=W._adjustForDepth(h,i.getDepth()),d=Y.reflectAngleOverYAxis(h,i.getCenter().x,i.getCenter().y+g,i.getRadiusX(),i.getRadiusY()),u=t.Math.degreesToRads(e.getPosition()),_=Math.abs(Math.atan2(o.x-d.x,d.y-o.y)),c=(d.y-o.y)*Math.tan(u);return(u>Math.PI/2&&_>Math.PI/2&&_<u||u<Math.PI/2&&_<Math.PI/2&&_>u)&&(o.x=r?d.x-c:d.x+c),i.setOutsideFeelerPoints(d,o,l),Math.abs(l.x-o.x)-n},_adjustForDepth:(e,t)=>{var i=0;return e>189&&e<351&&(i=t),i},_getMiddleLabel:e=>{for(var t=91,i=-1,r=0;r<e.length;r++){var s=e[r].getPosition();Math.abs(s-90)<t&&(t=Math.abs(s-90),i=r)}return i},_setOptimalLabelPos:(e,i,r,s)=>{i.setX(r);var a=e.getRadiusY()*(1+W._FEELER_RAD_MINSIZE),n=t.Math.degreesToRads(i.getPosition()),o=a*Math.cos(n),l=W._adjustForDepth(i.getAngle(),e.getDepth()),h=e.getCenter().y-o-i.getHeight()*W._LABEL_TO_FEELER_OFFSET+l;i.setY(i.boundY(h))},_getRadFeelerAngle:(e,t,i)=>{var r=e.getSlice(),s=r.getCenter(),a=e.getAngle(),n=W._adjustForDepth(a,r.getDepth()),o=Y.reflectAngleOverYAxis(a,s.x,s.y+n,r.getRadiusX(),r.getRadiusY());return Math.atan2(Math.abs(t-o.x),o.y-i)},_columnLabels:(e,i,r,s,a)=>{var n,o,l,h=e.__getFrame(),g=h.y,d=h.y+h.h,u=0,_=e.getCenter().x,c=e.getRadiusX()*(1+W._FEELER_RAD_MINSIZE+W._FEELER_HORIZ_MINSIZE);for(l=r?(_-=c)+e.getRadiusX()*W._FEELER_HORIZ_MINSIZE:(_+=c)-e.getRadiusX()*W._FEELER_HORIZ_MINSIZE,n=0;n<i.length;n++)o=i[n],u=t.Math.degreesToRads(o.getPosition()),W._getRadFeelerAngle(o,l,g)-u>.45*Math.PI||W._skipSliceLabel(e,o.getSlice())?(i.splice(n,1),n--):(i[n].setMinY(g),g+=i[n].getHeight());for(n=i.length-1;n>=0;n--)o=i[n],(u=t.Math.degreesToRads(o.getPosition()))-W._getRadFeelerAngle(o,l,d)>.45*Math.PI||W._skipSliceLabel(e,o.getSlice())?i.splice(n,1):(d-=i[n].getHeight(),i[n].setMaxY(d));if(0!=i.length){var p=W._getMiddleLabel(i),v=i[p];s&&!a&&v.getMinY()+v.getHeight()>e.getCenter().y&&(a=!0),a&&!s&&v.getMaxY()<e.getCenter().y&&(s=!0);var m=v.getPosition();(a&&s||m>90&&a||m<=90&&s)&&(W._setOptimalLabelPos(e,v,_,r),v.setHasFeeler(!0));var f,x,C=v.getY(),S=v.getY()+v.getHeight();if(s)for(n=p-1;n>=0;n--)x=(o=i[n]).getHeight(),W._setOptimalLabelPos(e,o,_,r),o.setHasFeeler(!0),(f=o.getY())+x<C?C=f:C-=x,o.setY(C);if(a)for(n=p+1;n<i.length;n++)x=(o=i[n]).getHeight(),W._setOptimalLabelPos(e,o,_,r),o.setHasFeeler(!0),(f=o.getY())>S?S=f+x:S+=x,o.setY(S-x)}},_truncateSliceLabel:(e,t,i,r)=>{var s,a,n=i.getSliceLabel(),o=n.getCSSStyle(),l=e.getNumChildren(),h=!1;e.contains(n)||(e.addChild(n),h=!0),n.setCSSStyle(o);var g=t.getSliceLabelString();return n.setTextString(g),h&&e.removeChildAt(l),s=W.getMaxLabelWidth(e,i.getX(),r),a=W._getTextDim(e,t,n,s,i.getInitialNumLines()),i.setWidth(a.x),i.getHeight()!=a.y&&(i.setHeight(a.y),!0)},_generateInitialLayout:e=>{for(var t=[],i=[],r=[],s=e.__getSlices(),a=e.__getFrame(),n=0;n<s.length;n++){var o=s[n],l=e.getSeriesLabelPos(o.getSeriesIndex());if(null==o.getSliceLabel()&&"none"!=l&&"center"!=l&&!W._skipSliceLabel(e,o)){var h=W._createLabel(o,!1),g=o.getAngleStart()+o.getAngleExtent()/2;g>360&&(g-=360),g<0&&(g+=360);var d=Y.reflectAngleOverYAxis(g,e.getCenter().x,e.getCenter().y,e.getRadiusX()*W._OUTSIDE_LABEL_DISTANCE,e.getRadiusY()*W._OUTSIDE_LABEL_DISTANCE),u=g>=90&&g<270,_=W.getMaxLabelWidth(e,d.x,u),c=W._getTextDim(e,o,h,_,W._MAX_LINES_PER_LABEL);g<165&&g>15?d.y-=1*c.y:g<15||g>345?(d.y-=.5*c.y,d.x+=.2*c.y):g>165&&g<195&&(d.y-=.5*c.y,d.x-=.2*c.y);var p,v=W._adjustForDepth(g,e.getDepth());if(d.y+=v,1==s.length&&(d.x-=c.x/2),!(d.y<a.y||d.y+c.y>a.y+a.h))g>=90&&g<270?(h.alignRight(),p=g-90,W._createLabelInfo(o,h,g,p,c,d,i)):(p=g<=90?Math.abs(90-g):180-(g-270),W._createLabelInfo(o,h,g,p,c,d,r))}}return t[0]=i,t[1]=r,t},_createLabelInfo:(e,t,i,r,s,a,n)=>{for(var o,l=-1,h=t,g=0;g<n.length;g++)if((o=n[g]).getPosition()>r){l=g;break}-1==l&&(l=n.length),(o=new V).setPosition(r),o.setAngle(i),o.setSliceLabel(h),o.setSlice(e),o.setWidth(s.x),o.setHeight(s.y),o.setX(a.x),o.setY(a.y),o.setInitialNumLines(h.getLineCount()),n.splice(l,0,o)},_getTextDim:(e,i,r,s,a)=>{r.setMaxLines(a);var n=W._isTextLabel(e,i)?null:r.getTextString().length;if(t.TextUtils.fitText(r,s,1/0,e,n)){e.addChild(r);var o=r.getDimensions();return e.removeChild(r),{x:o.w,y:o.h}}return{x:0,y:0}},_isTextLabel:(e,t)=>{var i=t.getCustomLabel(),r=null!=e.getOptions().dataLabel;return-1!=e.getOptions().styleDefaults.sliceLabelType.indexOf("text")||null!=i&&"number"!=typeof i||r},getMaxLabelWidth:(e,t,i)=>{var r=e.__getFrame();return i?t-r.x:r.x+r.w-t},getPieCenterOptions:(e,i)=>{var r=t.JsonUtils.clone(i.pieCenter,null,e.chart.Defaults.getNoCloneObject().pieCenter),s=i.pieCenterLabel;if(s){var a=s.style,n=s.text;n&&(r.label=n),a&&(r.labelStyle=new t.CSSStyle(a))}return r},_skipSliceLabel:(e,t)=>t.getAngleExtent()<3&&d.getSeriesCount(e.chart)>120};class j{constructor(e,t){this._pieChart=e,this._chart=e.chart,this._angleStart=0,this._angleExtent=0,this._topSurface=null,this._leftSurface=null,this._rightSurface=null,this._crustSurface=null,this._explodeOffsetX=0,this._explodeOffsetY=0,this._sliceLabel=null,this._sliceLabelString=null,this._hasFeeler=!1,this._feelerRad=null,this._feelerHoriz=null,this._outsideFeelerStart=null,this._outsideFeelerMid=null,this._outsideFeelerEnd=null,this._selected=!1,this._selecting=!1,this._centerX=this._pieChart.getCenter().x,this._centerY=this._pieChart.getCenter().y,this._radiusX=this._pieChart.getRadiusX(),this._radiusY=this._pieChart.getRadiusY(),this._depth=this._pieChart.getDepth();var i=this._chart.getOptions();if(null!=t){var r=d.getDataItem(this._chart,t,0);this._value=d.getVal(this._chart,t,0),this._explode=_.getSliceExplode(this._chart,t),this._fillColor=c.getColor(this._chart,t,0),this._fillPattern=c.getPattern(this._chart,t,0),this._strokeColor=c.getBorderColor(this._chart,t),this._borderWidth=c.getBorderWidth(this._chart,t),this._customLabel=r?r.label:null,this._seriesLabel=d.getSeries(this._chart,t),this._drillable=d.isDataItemDrillable(this._chart,t,0),this._id=_.getSliceId(this._chart,t),this._seriesIndex=t,this._categories=d.getCategories(this._chart,t,0)}else this._value=_.getOtherVal(this._chart),this._explode=0,this._fillColor=i.styleDefaults.otherColor,this._fillPattern=null,this._strokeColor=i.styleDefaults.borderColor,this._borderWidth=i.styleDefaults.borderWidth,this._customLabel=null,this._seriesLabel=i.translations.labelOther,this._drillable=d.isMultiSeriesDrillEnabled(this._chart),this._id=_.getOtherSliceId(this._chart)}getPieChart(){return this._pieChart}render(e){for(var i=j._sortPieSurfaces(this._topSurface,this._leftSurface,this._rightSurface,this._crustSurface,this._angleStart,this._angleExtent),r=i.length,s=0;s<r;s++)for(var a=i[s],n=a.length,o=0;o<n;o++){this._pieChart.__getShapesContainer().addChild(a[o]),a[o].render&&a[o].render()}if(this._sliceLabel&&(this._pieChart.addChild(this._sliceLabel),Y.associate(this,[this._sliceLabel]),e?(this._pieChart.addChild(this._feelerRad),this._pieChart.addChild(this._feelerHoriz)):this._renderOutsideFeeler()),this._explodeSlice(),this._drillable||this._pieChart.chart.isSelectionSupported()){var l=this.getDisplayables();for(s=0;s<l.length;s++)l[s].setCursor(t.SelectionEffectUtils.getSelectingCursor())}var h=this.getTopDisplayable();h&&(h.setAriaRole("img"),this._updateAriaLabel())}_feelerFromPts(e,i){var r=new t.Line(this._pieChart.getCtx(),e.x,e.y,i.x,i.y),s=this._pieChart.getOptions().styleDefaults.pieFeelerColor,a=new t.Stroke(s);return r.setStroke(a),this._pieChart.addChild(r),r}_renderOutsideFeeler(){if(this._hasFeeler){var e=this._feelerFromPts(this._outsideFeelerStart,this._outsideFeelerMid),t=this._feelerFromPts(this._outsideFeelerMid,this._outsideFeelerEnd);this._feelerRad=e,this._feelerHoriz=t}}preRender(){var e,i=this._bFillerSlice?"color":c.getSeriesEffect(this._chart),r=this.getFillColor(),s=this.getFillPattern();if("pattern"==i||null!=s)e=new t.PatternFill(s,r),i="pattern";else if("gradient"==i){var a=this._pieChart.is3D()?"3D":"2D",n=Y.getGradientColors(t.ColorUtils.getRGB(r),a),o=Y.getGradientAlphas(t.ColorUtils.getAlpha(r),a),l=[Math.floor(this._centerX-this._radiusX),Math.floor(this._centerY-this._radiusY),Math.ceil(2*this._radiusX),Math.ceil(2*this._radiusY)];e=new t.LinearGradientFill(270,n,o,[0,1],l)}else e=new t.SolidFill(r);if(this._topSurface=Y.createTopSurface(this,e),this._depth>0||this._radiusX!=this._radiusY){var h="gradient"==i,g=new t.SolidFill(t.ColorUtils.getDarker(r,.4)),d=h?Y.generateLateralGradientFill(this,"SIDE"):g,u=h?Y.generateLateralGradientFill(this,"CRUST"):g;this._leftSurface=Y.createLateralSurface(this,Y.SURFACE_LEFT,d),this._rightSurface=Y.createLateralSurface(this,Y.SURFACE_RIGHT,d),this._crustSurface=Y.createLateralSurface(this,Y.SURFACE_CRUST,u)}this.setSliceLabel(null),this.setNoOutsideFeeler()}static _sortPieSurfaces(e,t,i,r,s,a){var n=[];return t&&i&&r&&(s<=270&&s+a>270?(n.push(t),n.push(i),n.push(r)):s>270||s+a<=90?(n.push(t),n.push(r),n.push(i)):(n.push(i),n.push(r),n.push(t))),n.push(e),n}static oppositeDir(e,t,i){return e-t>0!=e-i>0}_explodeSlice(){if(0!=this._explode){var e=this._angleExtent,i=(360-(this._angleStart+e/2))*t.Math.RADS_PER_DEGREE,r=this._pieChart.is3D()?j.THREED_TILT:1,s=this._explode*this._pieChart.__calcMaxExplodeDistance();this._explodeOffsetX=Math.cos(i)*s,this._explodeOffsetY=Math.sin(i)*r*s,"safari"!==t.Agent.browser&&"blink"!==t.Agent.engine||(this._explodeOffsetX=Math.round(this._explodeOffsetX),this._explodeOffsetY=Math.round(this._explodeOffsetY))}else this._explodeOffsetX=0,this._explodeOffsetY=0;if(this._topSurface){var a=this._pieChart.is3D()&&this._topSurface[0].getSelectionOffset?this._topSurface[0].getSelectionOffset():[];j._translateShapes(this._topSurface,a[0]?a[0]+this._explodeOffsetX:this._explodeOffsetX,a[1]?a[1]+this._explodeOffsetY:this._explodeOffsetY)}if(this._rightSurface&&j._translateShapes(this._rightSurface,this._explodeOffsetX,this._explodeOffsetY),this._leftSurface&&j._translateShapes(this._leftSurface,this._explodeOffsetX,this._explodeOffsetY),this._crustSurface&&j._translateShapes(this._crustSurface,this._explodeOffsetX,this._explodeOffsetY),this._hasFeeler){var n=this._outsideFeelerStart.x,o=this._outsideFeelerStart.y,l=n+this._explodeOffsetX,h=o+this._explodeOffsetY;this._feelerRad.setX1(l),this._feelerRad.setY1(h);var g=this._outsideFeelerMid.x,d=this._outsideFeelerMid.y;j.oppositeDir(g,n,l)?(this._feelerRad.setX2(l),this._feelerHoriz.setX1(l)):(this._feelerRad.setX2(g),this._feelerHoriz.setX1(g)),j.oppositeDir(d,o,h)?(this._feelerRad.setY2(h),this._feelerHoriz.setY1(h)):(this._feelerRad.setY2(d),this._feelerHoriz.setY1(d))}this._sliceLabel&&!this._hasFeeler&&this._sliceLabel.setTranslate(this._explodeOffsetX,this._explodeOffsetY)}static _translateShapes(e,t,i){if(e)for(var r=e.length,s=0;s<r;s++){e[s].setTranslate(t,i)}}getRadiusX(){return this._radiusX}getRadiusY(){return this._radiusY}getCenter(){return new t.Point(this._centerX,this._centerY)}getDepth(){return this._depth}getAngleExtent(){return this._angleExtent}setAngleExtent(e){this._angleExtent=e}getAngleStart(){return this._angleStart}setAngleStart(e){this._angleStart=e}__getExplodeOffsetX(){return this._explodeOffsetX}__getExplodeOffsetY(){return this._explodeOffsetY}setOutsideFeelerPoints(e,t,i){this._outsideFeelerStart=e,this._outsideFeelerMid=t,this._outsideFeelerEnd=i,this._hasFeeler=!0}setNoOutsideFeeler(){this._outsideFeelerStart=null,this._outsideFeelerMid=null,this._outsideFeelerEnd=null,this._hasFeeler=!1}getLabelAndFeeler(){var e=[];return this._sliceLabel&&e.push(this._sliceLabel),this._feelerRad&&e.push(this._feelerRad),this._feelerHoriz&&e.push(this._feelerHoriz),e}getSliceLabel(){return this._sliceLabel}setSliceLabel(e){this._sliceLabel=e}getSliceLabelString(){return this._sliceLabelString}setSliceLabelString(e){this._sliceLabelString=e}getTopSurface(){return this._topSurface}getVal(){return this._value}getId(){return this._id}getSeriesIndex(){return this._seriesIndex}static _shapeIsSelectable(e){return e instanceof U}contains(e,t){for(var i=this._pieChart.getInnerRadius(),r=this._pieChart.getCenter(),s=(e-r.x)/this._radiusX,a=(t-r.y)/this._radiusY,n=-Math.atan2(a,s)*(180/Math.PI);n<this._angleStart;)n+=360;for(;n-this._angleStart>=360;)n-=360;var o=Math.pow(s,2)+Math.pow(a,2),l=Math.sqrt(o)>i/this._radiusX&&o<=1,h=n<=this._angleStart+this._angleExtent;return l&&h}GetAnimParams(){var e=t.ColorUtils.getRed(this._fillColor),i=t.ColorUtils.getGreen(this._fillColor),r=t.ColorUtils.getBlue(this._fillColor),s=t.ColorUtils.getAlpha(this._fillColor);return[this._value,this._radiusX,this._radiusY,this._explode,this._centerX,this._centerY,this._depth,e,i,r,s]}SetAnimParams(e){this._value=e[0],this._radiusX=e[1],this._radiusY=e[2],this._explode=e[3],this._centerX=e[4],this._centerY=e[5],this._depth=e[6];var i=Math.round(e[7]),r=Math.round(e[8]),s=Math.round(e[9]),a=Math.round(e[10]);this._fillColor=t.ColorUtils.makeRGBA(i,r,s,a)}getDeletedAnimParams(){var e=this.GetAnimParams();return e[0]=0,e[1]=this.getInnerRadius(),e[2]=this.getInnerRadius(),e[3]=0,e}animateUpdate(e,i){var r=i.GetAnimParams(),s=this.GetAnimParams();if(!t.ArrayUtils.equals(r,s)){var a=new t.CustomAnimation(this._pieChart.getCtx(),this,this.getPieChart().getAnimDuration());a.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.GetAnimParams,this.SetAnimParams,s),e.add(a,0),this.SetAnimParams(r)}}animateInsert(e){var i=new t.CustomAnimation(this._pieChart.getCtx(),this,this.getPieChart().getAnimDuration());i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.GetAnimParams,this.SetAnimParams,this.GetAnimParams()),e.add(i,0),this.SetAnimParams(this.getDeletedAnimParams())}animateDelete(e,i){var r=i.__getSlices(),s=this.getPieChart().__getSlices(),a=s.indexOf(this)-1;if(a>=0){for(var n=s[a].getId(),o=0;o<r.length;o++)if(r[o].getId().equals(n)){r.splice(o+1,0,this);break}}else r.splice(0,0,this);this._pieChart=i;var l=new t.CustomAnimation(i.getCtx(),this,this.getPieChart().getAnimDuration());l.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.GetAnimParams,this.SetAnimParams,this.getDeletedAnimParams()),l.setOnEnd(this._removeDeletedSlice,this),e.add(l,0)}_removeDeletedSlice(){var e=this.getPieChart().__getSlices(),t=e.indexOf(this);t>=0&&e.splice(t,1)}getDisplayables(){var e=new Array;return this._topSurface&&(e=e.concat(this._topSurface)),this._leftSurface&&(e=e.concat(this._leftSurface)),this._rightSurface&&(e=e.concat(this._rightSurface)),this._crustSurface&&(e=e.concat(this._crustSurface)),this._sliceLabel&&e.push(this._sliceLabel),this._feelerRad&&e.push(this._feelerRad),this._feelerHoriz&&e.push(this._feelerHoriz),e}getAriaLabel(){var e,i=this._pieChart.getOptions().translations;e=null==this._seriesIndex?m.getOtherSliceDatatip(this._chart,this._value,!1):m.getDatatip(this._chart,this._seriesIndex,0,null,!1);var r=i.labelPercentage,s=W.generateSlicePercentageString(this);e+="; "+t.ResourceUtils.format(i.labelAndValue,[r,s]);var a=[];return this.isSelectable()&&a.push(i[this.isSelected()?"stateSelected":"stateUnselected"]),d.isDataItemDrillable(this._chart,this._seriesIndex,this._groupIndex)&&a.push(i.stateDrillable),t.Displayable.generateAriaLabel(e,a)}_updateAriaLabel(){var e=this.getTopDisplayable();e&&!t.Agent.deferAriaCreation()&&e.setAriaProperty("label",this.getAriaLabel())}getTopDisplayable(){return this._topSurface&&this._topSurface.length>0?this._topSurface[0]:null}isSelectable(){return this._chart.isSelectionSupported()}isSelected(){return this._selected}setSelected(e,i){if(this._selected=e,this.getTopSurface()){if(this._selected?this._pieChart.bringToFrontOfSelection(this):this._selecting||this._pieChart.pushToBackOfSelection(this),c.isSelectionHighlighted(this._chart))for(var r=this.getDisplayables(),s=0;s<r.length;s++)j._shapeIsSelectable(r[s])&&r[s].setSelected(e);if(c.isSelectionExploded(this._chart)){var a=e?1:0;if(i||"none"==c.getAnimOnDataChange(this._chart))this.setExplode(a);else{var n=new t.CustomAnimation(this._pieChart.getCtx(),this,this._pieChart.getAnimDuration()/2);n.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getExplode,this.setExplode,a),n.play()}}this._updateAriaLabel()}}showHoverEffect(){this._selecting=!0,this._pieChart.bringToFrontOfSelection(this);for(var e=this.getDisplayables(),t=0;t<e.length;t++)j._shapeIsSelectable(e[t])&&e[t].showHoverEffect()}hideHoverEffect(){this._selecting=!1,this._selected||this._pieChart.pushToBackOfSelection(this);for(var e=this.getDisplayables(),t=0;t<e.length;t++)j._shapeIsSelectable(e[t])&&e[t].hideHoverEffect()}getDatatip(e,t,i){return e==this._sliceLabel&&this._sliceLabel&&this._sliceLabel.isTruncated()?this.getSliceLabelString():this.getTooltip()}getDatatipColor(){return this.getFillColor()}getCategories(){return this._categories&&this._categories.length>0?this._categories:[this.getId().series]}getNextNavigable(e){var i=e.keyCode;if(e.type==t.MouseEvent.CLICK)return this;if(i==t.KeyboardEvent.SPACE&&e.ctrlKey)return this;var r=t.Agent.isRightToLeft(this._chart.getCtx()),s=this._pieChart.__getSlices(),a=s.indexOf(this),n=null;return i==t.KeyboardEvent.RIGHT_ARROW||i==t.KeyboardEvent.DOWN_ARROW&&!r||i==t.KeyboardEvent.UP_ARROW&&r?n=a<s.length-1?s[a+1]:s[0]:(i==t.KeyboardEvent.LEFT_ARROW||i==t.KeyboardEvent.DOWN_ARROW&&r||i==t.KeyboardEvent.UP_ARROW&&!r)&&(n=0==a?s[s.length-1]:s[a-1]),n}getKeyboardBoundingBox(e){var i=this.getDisplayables();return i[0]?i[0].getDimensions(e):new t.Rectangle(0,0,0,0)}getTargetElem(){var e=this.getDisplayables();return e[0]?e[0].getElem():null}showKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!0,this.showHoverEffect()}hideKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!1,this.hideHoverEffect()}isShowingKeyboardFocusEffect(){return this._isShowingKeyboardFocusEffect}isDragAvailable(){return!0}getDragTransferable(){return[this.getId()]}getDragFeedback(){if(this._chart.isSelectionSupported()&&this._chart.getSelectionHandler().getSelectedCount()>1){for(var e=this._chart.getSelectionHandler().getSelection(),t=[],i=0;i<e.length;i++)t=t.concat(e[i].getDisplayables());return t}return this.getDisplayables()}getExplode(){return this._explode}setExplode(e){this._explode=e,this._explodeSlice()}getCustomLabel(){return this._customLabel}getSeriesLabel(){return this._seriesLabel}getFillColor(){return this._fillColor}getFillPattern(){return this._fillPattern}getStrokeColor(){return this._strokeColor}getBorderWidth(){return this._borderWidth}getSliceGaps(){return 0==this._depth?3*c.getDataItemGaps(this._chart):0}getInnerRadius(){return this._pieChart.getInnerRadius()}getTooltip(){return null==this._seriesIndex?m.getOtherSliceDatatip(this._chart,this._value,!0):m.getDatatip(this._chart,this._seriesIndex,0,null,!0)}isDrillable(){return this._drillable}static createFillerSlice(e,t){var i=new j(e);return i._value=t,i._bFillerSlice=!0,i._centerX=e.getCenter().x,i._centerY=e.getCenter().y,i._fillColor="rgba(255,255,255,0)",i._strokeColor="rgba(255,255,255,0)",i._id=new o(null,null,null,null),i}getSeriesIndex(){return this._seriesIndex}}j.THREED_TILT=.59;class z extends t.Automation{constructor(e){super(e),this._options=this._comp.getOptions(),this._legend=this._comp.legend,this._xAxis=this._comp.xAxis,this._yAxis=this._comp.yAxis,this._y2Axis=this._comp.y2Axis,this._legendAutomation=this._legend?this._legend.getAutomation():null,this._xAxisAutomation=this._xAxis?this._xAxis.getAutomation():null,this._yAxisAutomation=this._yAxis?this._yAxis.getAutomation():null,this._y2AxisAutomation=this._y2Axis?this._y2Axis.getAutomation():null}GetSubIdForDomElement(e){var i=null;if(e.isDescendantOf(this._xAxis))return(i=this._xAxisAutomation.GetSubIdForDomElement(e))?this._convertAxisSubIdToChartSubId(i,"xAxis"):null;if(e.isDescendantOf(this._yAxis))return(i=this._yAxisAutomation.GetSubIdForDomElement(e))?this._convertAxisSubIdToChartSubId(i,"yAxis"):null;if(e.isDescendantOf(this._y2Axis))return(i=this._y2AxisAutomation.GetSubIdForDomElement(e))?this._convertAxisSubIdToChartSubId(i,"y2Axis"):null;if(e.isDescendantOf(this._legend)){var r=this._legendAutomation.GetSubIdForDomElement(e);return r?this._convertLegendSubIdToChartSubId(r):null}var s=this._comp.getEventManager().GetLogicalObject(e);if(!s)return null;if(s instanceof t.SimpleObjPeer){var a=s.getParams().type;if("pieCenterLabel"==a)return"pieCenterLabel";if("plotArea"==a)return"plotArea"}if(s instanceof j)return"dataItem["+s.getSeriesIndex()+"]";if(s instanceof f){var n=s.getSeriesIndex(),o=s.getGroupIndex();if(null!=n&&o>=0&&("funnel"!=this._options.type||"pyramid"!=this._options.type))return"dataItem["+n+"]["+o+"]";if(null!=n&&o==N._GROUP_IDX&&("funnel"==this._options.type||"pyramid"==this._options.type))return"dataItem["+n+"]";if(null!=n&&(null==o||o<0))return"series["+n+"]"}else if(s instanceof x){var l=s.getAxisType(),h=s.getIndex();return l&&h>=0?l+":referenceObject["+h+"]":null}return null}_convertLegendSubIdToChartSubId(e){var t=this._legend.getOptions(),i=this._legendAutomation.getLegendItem(t,e);if(i){for(var r=0;r<this._options.series.length;r++){if(this._options.series[r].name==i.text)return"series["+r+"]"}return"legend:"+e}return null}_convertAxisSubIdToChartSubId(e,t){if("title"==e&&t)return t+":"+e;var i=e.substring(e.indexOf("["));return i?"group"+i:null}getDomElementForSubId(e){if(e==t.Automation.TOOLTIP_SUBID)return this.GetTooltipElement(this._comp,m.isDataCursorEnabled(this._comp)?p.TOOLTIP_ID:null);if("pieCenterLabel"==e)return this._comp.pieChart.getCenterLabel().getElem();if("plotArea"==e)return this._comp.getPlotArea().getElem();var i,r,s,a=e.indexOf("["),n=e.indexOf("]"),o=e.indexOf(":");if(a>0&&n>0||o>0){var l=o<0?e.substring(0,a):e.substring(0,o);if("group"==l)return this._xAxisAutomation.getDomElementForSubId(e);if("series"==l)return e=this._convertToLegendSubId(e),this._legendAutomation.getDomElementForSubId(e);if("legend"==e.substring(0,o))return e=e.substring(o+1),this._legendAutomation.getDomElementForSubId(e);var h,g=e.substring(a+1,n);if("xAxis"==l||"yAxis"==l||"y2Axis"==l){var d=e.substring(o+1);if("title"==d){if("xAxis"==l)return this._xAxisAutomation.getDomElementForSubId(d);if("yAxis"==l)return this._yAxisAutomation.getDomElementForSubId(d);if("y2Axis"==l)return this._y2AxisAutomation.getDomElementForSubId(d)}else if(i=d.indexOf("["),r=d.indexOf("]"),"referenceObject"==d.substring(0,i)){var u=d.substring(i+1,r);if(s=this._getRefObjPeer(u))return s.getDisplayables()[0].getElem()}}if("pie"==this._options.type){var _=this._comp.pieChart.getSliceDisplayable(g);if(_)return _.getElem()}if("funnel"==this._options.type?h=N._GROUP_IDX:"pyramid"==this._options.type?h=G._GROUP_IDX:(i=(e=e.substring(n+1)).indexOf("["),r=e.indexOf("]"),i>=0&&r>=0&&(h=e.substring(i+1,r))),s=this._getChartObjPeer(g,h))return s.getDisplayables()[0].getElem()}return null}_getChartObjPeer(e,t){for(var i=this._comp.getChartObjPeers(),r=0;r<i.length;r++){var s=i[r].getSeriesIndex(),a=i[r].getGroupIndex();if(s==e&&a==t)return i[r]}return null}_getRefObjPeer(e){for(var t=this._comp.getRefObjPeers(),i=0;i<t.length;i++)if(e==t[i].getIndex())return t[i];return null}_convertToLegendSubId(e){var t=e.indexOf("["),i=e.indexOf("]"),r=e.substring(t+1,i),s=this._legend.getOptions(),a=this._options.series[r];return"section"+this._legendAutomation.getIndicesFromSeries(a,s)}getDataItem(e,t){"pie"!=this._options.type&&"funnel"!=this._options.type&&"pyramid"!=this._options.type||(t=0);var i=d.getDataItem(this._comp,e,t);return i?{borderColor:c.getBorderColor(this._comp,e,t),color:c.getColor(this._comp,e,t),label:c.getDataLabel(this._comp,e,t),targetValue:d.getTargetVal(this._comp,e,t),tooltip:m.getDatatip(this._comp,e,t,null,!1),value:d.getVal(this._comp,e,t),open:i.open,close:i.close,high:d.getHighVal(this._comp,e,t),low:d.getLowVal(this._comp,e,t),volume:i.volume,x:d.getXVal(this._comp,e,t),y:i.y,z:i.z,min:i.min,max:i.max,group:d.getGroup(this._comp,t),series:d.getSeries(this._comp,e),selected:d.isDataSelected(this._comp,e,t)}:null}getGroup(e){return d.getGroup(this._comp,e)}getSeries(e){return this._options.series[e].name}getGroupCount(){return d.getGroupCount(this._comp)}getSeriesCount(){return this._options.series.length}getTitle(){return this._options.title.text}getLegend(){var e=this._legend.__getBounds(),i=this._legend.localToStage(new t.Point(e.x,e.y));return{bounds:{x:i.x,y:i.y,width:e.w,height:e.h},title:this._legend.getOptions().title}}getPlotArea(){var e=this._comp.__getPlotAreaSpace();return{bounds:{x:e.x,y:e.y,width:e.w,height:e.h}}}getXAxis(){return this._getAxis("x")}getYAxis(){return this._getAxis("y")}getY2Axis(){return this._getAxis("y2")}_getAxis(e){var i="x"==e?this._xAxis:"y"==e?this._yAxis:this._y2Axis;if(i){var r=i.__getBounds(),s=i.localToStage(new t.Point(r.x,r.y)),a={x:s.x,y:s.y,width:r.w,height:r.h},n=this._comp;return{bounds:a,title:this._options[e+"Axis"].title,getPreferredSize:(t,r)=>{var s,a=i.getOptions(),o=a.position,l=w.getTickLabelGapSize(n,e),h=w.isStandaloneXAxis(n)||w.isStandaloneYAxis(n)||w.isStandaloneY2Axis(n)?2:0;return"top"==o||"bottom"==o?(s=i.getPreferredSize(a,t,r-l-h)).h=Math.ceil(s.h+l+h):(s=i.getPreferredSize(a,t-l-h,r)).w=Math.ceil(s.w+l+h),{width:s.w,height:s.h}}}}return null}IsTooltipElement(e){var i=e.getAttribute("id");return!(!i||0!=i.indexOf(p.TOOLTIP_ID)&&0!=i.indexOf(t.HtmlTooltipManager._TOOLTIP_DIV_ID))}}class X extends t.EventManager{constructor(e){super(e.getCtx(),e.processEvent,e,e),this._chart=e,this._dragMode=null,this._dragButtonsVisible=t.Agent.isTouchDevice(),this.panButton=null,this.zoomButton=null,this.selectButton=null,this._dataCursorHandler=null,this._panZoomHandler=null,this._marqueeZoomHandler=null,this._marqueeSelectHandler=null}addListeners(e){t.SvgDocumentUtils.addDragListeners(this._chart,this._onDragStart,this._onDragMove,this._onDragEnd,this),super.addListeners(e),t.Agent.isTouchDevice()||e.addEvtListener(t.MouseEvent.MOUSEWHEEL,this.OnMouseWheel,!1,this)}RemoveListeners(e){super.RemoveListeners(e),t.Agent.isTouchDevice()||e.removeEvtListener(t.MouseEvent.MOUSEWHEEL,this.OnMouseWheel,!1,this)}getLogicalObject(e){return this.GetLogicalObject(e,!0)}_getDragHandler(e){return e&&"user"==this._chart.getOptions().dragMode&&l.isBLAC(this._chart)&&(this._dragMode==X.DRAG_MODE_PAN||this._dragMode==X.DRAG_MODE_ZOOM)&&(this._panZoomHandler&&this._panZoomHandler.isWithinBounds(e)?this._dragMode=X.DRAG_MODE_PAN:this._dragMode=X.DRAG_MODE_ZOOM),this._dragMode==X.DRAG_MODE_PAN?this._panZoomHandler:this._dragMode==X.DRAG_MODE_ZOOM?this._marqueeZoomHandler:this._dragMode==X.DRAG_MODE_SELECT?this._marqueeSelectHandler:null}_onDragStart(e){return t.Agent.isTouchDevice()?this._onTouchDragStart(e):this._onMouseDragStart(e)}_onDragMove(e){return t.Agent.isTouchDevice()?this._onTouchDragMove(e):this._onMouseDragMove(e)}_onDragEnd(e){return t.Agent.isTouchDevice()?this._onTouchDragEnd(e):this._onMouseDragEnd(e)}_onMouseDragStart(e){var t,i=this._context.pageToStageCoords(e.pageX,e.pageY),r=this._getDragHandler(i),s=this.GetLogicalObject(e.target);return!(s&&s.isSelectable&&s.isSelectable())&&0==e.button&&r&&((t=r.processDragStart(i,e.ctrlKey))&&this._callback.call(this._callbackObj,t),this._chart.setCursor(r.getCursor(i)),this.setDragButtonsVisible(!1),this._chart!=this.getCtx().getCurrentKeyboardFocus()&&this.getCtx().setCurrentKeyboardFocus(this._chart)),!!t&&(this._dataCursorHandler&&this._dataCursorHandler.processEnd(),!0)}_onMouseDragMove(e){var t,i=this._context.pageToStageCoords(e.pageX,e.pageY),r=this._getDragHandler();r&&(t=r.processDragMove(i,e.ctrlKey))&&(this._callback.call(this._callbackObj,t),this.setDragButtonsVisible(!1)),t&&e.stopPropagation()}_onMouseDragEnd(e){var t,i=this._context.pageToStageCoords(e.pageX,e.pageY),r=this._getDragHandler();if(r){(t=r.processDragEnd(i,e.ctrlKey))&&(this._callback.call(this._callbackObj,t),this.autoToggleZoomButton()),this._chart.setCursor(r.getCursor(i));var s=this._chart.__getAxisSpace();s&&this.setDragButtonsVisible(s.containsPoint(i.x,i.y))}}OnMouseMove(e){super.OnMouseMove(e);var i=this._context.pageToStageCoords(e.pageX,e.pageY);this._dataCursorHandler&&(this.GetLogicalObjectAndDisplayable(e.target).displayable instanceof t.IconButton?this._dataCursorHandler.processEnd():this._dataCursorHandler.processMove(i));var r=this._getDragHandler(i);r?this._chart.setCursor(r.getCursor(i)):this._chart.setCursor("default")}OnMouseOut(e){super.OnMouseOut(e);var t=this._context.pageToStageCoords(e.pageX,e.pageY),i=this._chart.__getAxisSpace();i&&this.setDragButtonsVisible(i.containsPoint(t.x,t.y)),this._dataCursorHandler&&this._dataCursorHandler.processOut(t);this.GetLogicalObject(e.target)}OnMouseWheel(e){if(O.isZoomable(this._chart)){var t=null!=e.wheelDelta?e.wheelDelta:0,i=this._context.pageToStageCoords(e.pageX,e.pageY);if(this._panZoomHandler){var r=this._panZoomHandler.processMouseWheel(i,t);r&&(e.preventDefault(),e.stopPropagation(),this._callback.call(this._callbackObj,r),this._dataCursorHandler&&this._dataCursorHandler.processMove(i))}}}ShowFocusEffect(e,i){if(this._dataCursorHandler){var r=i.getDataPosition();if(r){var s=this._chart.__getPlotAreaSpace();this._dataCursorHandler.processMove(new t.Point(r.x+s.x,r.y+s.y))}}super.ShowFocusEffect(e,i)}OnBlur(e){this._dataCursorHandler&&this._dataCursorHandler.processEnd(),super.OnBlur(e)}OnClickInternal(e){var t=this.GetLogicalObject(e.target),i=this._context.pageToStageCoords(e.pageX,e.pageY);this.SeriesFocusHandler&&this.SeriesFocusHandler.processSeriesFocus(i,t),t&&(t.isSelectable&&t.isSelectable()||this.processDrillEvent(t))}OnDblClickInternal(e){var t=this.GetLogicalObject(e.target);t&&t.isSelectable&&t.isSelectable()&&this.processDrillEvent(t)}HandleTouchHoverStartInternal(e){if(this._dataCursorHandler&&!this.isTouchResponseTouchStart()){var t=this._context.pageToStageCoords(e.touch.pageX,e.touch.pageY);return this._dataCursorHandler.processMove(t),!1}var i=this.GetLogicalObject(e.target);return this.TouchManager.setTooltipEnabled(e.touch.identifier,this.getTooltipsEnabled(i)),!1}HandleTouchHoverMoveInternal(e){if(this._dataCursorHandler&&!this.isTouchResponseTouchStart()){var t=this._context.pageToStageCoords(e.touch.pageX,e.touch.pageY);return this._dataCursorHandler.processMove(t),!1}var i=this.GetLogicalObject(e.target);return this.TouchManager.setTooltipEnabled(e.touch.identifier,this.getTooltipsEnabled(i)),!1}HandleTouchHoverEndInternal(e){this.endDrag();var t=this.GetLogicalObject(e.target);t&&(t.isSelectable&&t.isSelectable()||this.processDrillEvent(t))}HandleTouchClickInternal(e){var t=this.GetLogicalObject(e.target);t&&(t.isSelectable&&t.isSelectable()||this.processDrillEvent(t))}HandleTouchDblClickInternal(e){var t=this.GetLogicalObject(e.target);t&&t.isSelectable&&t.isSelectable()&&(e.preventDefault(),e.stopPropagation(),this.processDrillEvent(t))}processDrillEvent(e){if(e&&e.isDrillable&&e.isDrillable()){var i=e.getId();if(e instanceof f)-1===e.getGroupIndex()?this.FireEvent(t.EventFactory.newChartDrillEvent(i,e.getSeries(),null,"series")):this.FireEvent(t.EventFactory.newChartDrillEvent(null!=i.id?i.id:i,e.getSeries(),e.getGroup(),"item"));else if(e instanceof j){var r="_dvtOther"===i.series?"multiSeries":"item";this.FireEvent(t.EventFactory.newChartDrillEvent(i.id,i.series,i.group,r))}}}ProcessRolloverEvent(e,i,r){var s=this._chart.getOptions();if("dim"==O.getHoverBehavior(this._chart)){var a=i.getCategories?i.getCategories():[];s.highlightedCategories=r?a.slice():null;var n=t.EventFactory.newCategoryHighlightEvent(s.highlightedCategories,r),o=c.getHoverBehaviorDelay(this._chart),l=this._chart.getObjects();this._chart.pieChart&&(l=l.concat(this._chart.pieChart.__getSlices())),this.RolloverHandler.processEvent(n,l,o,"any"==s.highlightMatch)}}_onTouchDragStart(e){var t,i,r=e.touches;if(1==r.length){var s=this._context.pageToStageCoords(r[0].pageX,r[0].pageY),a=this._getDragHandler();a?t=a.processDragStart(s,!0):this._dataCursorHandler&&this.isTouchResponseTouchStart()&&(this._dataCursorHandler.processMove(s),i=!0)}else if(2==r.length&&this._panZoomHandler&&O.isZoomable(this._chart)){this.endDrag();var n=this._context.pageToStageCoords(r[0].pageX,r[0].pageY),o=this._context.pageToStageCoords(r[1].pageX,r[1].pageY);t=this._panZoomHandler.processPinchStart(n,o)}return t&&(this._callback.call(this._callbackObj,t),this.getCtx().getTooltipManager().hideTooltip()),!(!t&&!i)&&(e.preventDefault(),e.stopPropagation(),this.setDragButtonsVisible(!1),!0)}_onTouchDragMove(e){var t,i,r=e.touches;if(1==r.length){var s=this._context.pageToStageCoords(r[0].pageX,r[0].pageY),a=this._getDragHandler();a?t=a.processDragMove(s,!0):this._dataCursorHandler&&this.isTouchResponseTouchStart()&&(this._dataCursorHandler.processMove(s),i=!0)}else if(2==r.length&&this._panZoomHandler&&O.isZoomable(this._chart)){var n=this._context.pageToStageCoords(r[0].pageX,r[0].pageY),o=this._context.pageToStageCoords(r[1].pageX,r[1].pageY);t=this._panZoomHandler.processPinchMove(n,o)}(t||i)&&e.preventDefault(),t&&(this._callback.call(this._callbackObj,t),this.getCtx().getTooltipManager().hideTooltip())}_onTouchDragEnd(e){var t,i=this.endDrag();if(this._panZoomHandler&&O.isZoomable(this._chart)&&(t=this._panZoomHandler.processPinchEnd())&&this._callback.call(this._callbackObj,t),i||t){e.preventDefault(),this.getCtx().getTooltipManager().hideTooltip();var r=this.getTouchManager(),s=1==e.changedTouches.length?e.changedTouches[0].identifier:null,a=null!=s?r.getTouchInfo(s):null;a&&!a.touchMoved||r.reset()}this.setDragButtonsVisible(!0)}endDrag(){var e,t=this._getDragHandler();return t&&(e=t.processDragEnd(null,!0)),this._dataCursorHandler&&this._dataCursorHandler.processEnd(),e&&this._callback.call(this._callbackObj,e),e}zoomBy(e){if(this._panZoomHandler&&O.isZoomable(this._chart)){var t=this._panZoomHandler.zoomBy(e);t&&this._callback.call(this._callbackObj,t)}}panBy(e,t){if(this._panZoomHandler&&O.isScrollable(this._chart)){var i=this._panZoomHandler.panBy(e,t);i&&this._callback.call(this._callbackObj,i)}}hideHoverFeedback(){this.hideTooltip(),this._dataCursorHandler&&this._dataCursorHandler.processEnd()}hideTooltip(){this._dataCursorHandler&&this._dataCursorHandler.isDataCursorShown()||super.hideTooltip()}getTooltipsEnabled(e){return(!this._dataCursorHandler||!(e instanceof f||e instanceof x||this._dataCursorHandler.isDataCursorShown()))&&super.getTooltipsEnabled()}getDataCursorHandler(){return this._dataCursorHandler}setDataCursorHandler(e){this._dataCursorHandler=e}setPanZoomHandler(e){this._panZoomHandler=e}setMarqueeZoomHandler(e){this._marqueeZoomHandler=e}setMarqueeSelectHandler(e){this._marqueeSelectHandler=e}getMarqueeGlassPane(){return this._dragMode==X.DRAG_MODE_ZOOM?this._marqueeZoomHandler.getGlassPane():this._dragMode==X.DRAG_MODE_SELECT?this._marqueeSelectHandler.getGlassPane():null}cancelMarquee(e){this._dragMode==X.DRAG_MODE_ZOOM?this._marqueeZoomHandler.cancelMarquee()&&e.preventDefault():this._dragMode==X.DRAG_MODE_SELECT&&this._marqueeSelectHandler&&this._marqueeSelectHandler.cancelMarquee()&&this._chart.render()}getDragMode(){return this._dragMode}setDragMode(e){this._dragMode=null==e?this._getDefaultDragMode():e,!this._chart.xAxis.isFullViewport()||this._chart.yAxis&&!this._chart.yAxis.isFullViewport()||this.autoToggleZoomButton()}_getDefaultDragMode(){return t.Agent.isTouchDevice()?X.DRAG_MODE_OFF:O.isScrollable(this._chart)?X.DRAG_MODE_PAN:"multiple"==this._chart.getOptions().selectionMode?X.DRAG_MODE_SELECT:null}onZoomButtonClick(e){this.zoomButton.isToggled()?(this.selectButton&&this.selectButton.setToggled(!1),this.setDragMode(X.DRAG_MODE_ZOOM)):this.setDragMode(null)}onPanButtonClick(e){this.panButton.isToggled()?(this.selectButton&&this.selectButton.setToggled(!1),this.setDragMode(X.DRAG_MODE_PAN)):this.setDragMode(null)}onSelectButtonClick(e){this.selectButton.isToggled()?(this.zoomButton&&this.zoomButton.setToggled(!1),this.panButton&&this.panButton.setToggled(!1),this.setDragMode(X.DRAG_MODE_SELECT)):this.setDragMode(null)}setDragButtonsVisible(e){e&&!this._dragButtonsVisible?(this._chart.showDragButtons(),this._dragButtonsVisible=!0):!e&&this._dragButtonsVisible&&(this._chart.hideDragButtons(),this._dragButtonsVisible=!1)}areDragButtonsVisible(){return this._dragButtonsVisible}autoToggleZoomButton(){!t.Agent.isTouchDevice()&&this.zoomButton&&(this._chart.xAxis.isFullViewport()&&this._chart.yAxis.isFullViewport()?this._dragMode==X.DRAG_MODE_PAN&&(this.zoomButton.setToggled(!0),this.onZoomButtonClick(null)):this._dragMode==X.DRAG_MODE_ZOOM&&(this.zoomButton.setToggled(!1),this.onZoomButtonClick(null)))}GetTouchResponse(){return this._dragMode&&this._dragMode!=X.DRAG_MODE_OFF?t.EventManager.TOUCH_RESPONSE_TOUCH_HOLD:this._chart.getOptions().touchResponse}isDndSupported(){return!0}GetDragSourceType(){var e=this.DragSource.getDragObject();return e instanceof f&&e.getSeriesIndex()>=0&&e.getGroupIndex()>=0||e instanceof j?"items":null}GetDragDataContexts(e){if(this._chart.isSelectionSupported()&&this._chart.getSelectionHandler().getSelectedCount()>1){for(var i=this._chart.getSelectionHandler().getSelection(),r=[],s=0;s<i.length;s++){var a=c.getDataContext(this._chart,i[s].getSeriesIndex(),i[s].getGroupIndex(),i[s].getNestedDataItemIndex());e&&t.ToolkitUtils.cleanDragDataContext(a),r.push(a)}return r}var n=this.DragSource.getDragObject(),o=null;return n instanceof f&&(o=c.getDataContext(this._chart,n.getSeriesIndex(),n.getGroupIndex(),n.getNestedDataItemIndex())),n instanceof j&&(o=c.getDataContext(this._chart,n.getSeriesIndex(),0)),o&&e&&t.ToolkitUtils.cleanDragDataContext(o),o?[o]:null}GetDropOffset(e){var i=this.DragSource.getDragObject();if(i instanceof f){var r=i.getDataPosition();if(r){r=this._chart.getPlotArea().localToStage(r);var s=this._context.pageToStageCoords(e.pageX,e.pageY);return new t.Point(r.x-s.x,r.y-s.y)}}return null}GetDropTargetType(e){var t=this._context.pageToStageCoords(e.pageX,e.pageY),i=this._chart.getOptions().dnd.drop,r=this._chart.__getPlotAreaSpace();return Object.keys(i.plotArea).length>0&&r.containsPoint(t.x,t.y)?"plotArea":Object.keys(i.xAxis).length>0&&w.isAxisRendered(this._chart,"x")&&w.axisContainsPoint(this._chart.xAxis,t)?"xAxis":Object.keys(i.yAxis).length>0&&w.isAxisRendered(this._chart,"y")&&w.axisContainsPoint(this._chart.yAxis,t)?"yAxis":Object.keys(i.y2Axis).length>0&&w.isAxisRendered(this._chart,"y2")&&w.axisContainsPoint(this._chart.y2Axis,t)?"y2Axis":null}GetDropEventPayload(e){var i=e.getNativeEvent().dataTransfer,r=Number(i.getData(t.EventManager.DROP_OFFSET_X_DATA_TYPE))||0,s=Number(i.getData(t.EventManager.DROP_OFFSET_Y_DATA_TYPE))||0,a=this._context.pageToStageCoords(e.pageX,e.pageY);return this._chart.getValsAt(a.x+r,a.y+s)}ShowDropEffect(e){var t=this._getDropObject(e);t&&(t.setClassName("oj-active-drop"),t.setSolidFill(this._chart.getOptions()._dropColor))}ClearDropEffect(){var e=this._chart.getCache().getFromCache("plotAreaBackground");if(e){var i=c.getBackgroundColor(this._chart);i?e.setSolidFill(i):e.setInvisibleFill(),t.ToolkitUtils.removeClassName(e.getElem(),"oj-invalid-drop"),t.ToolkitUtils.removeClassName(e.getElem(),"oj-active-drop")}var r=e=>{if(e){var i=e.getCache().getFromCache("background");i&&(i.setInvisibleFill(),t.ToolkitUtils.removeClassName(i.getElem(),"oj-invalid-drop"),t.ToolkitUtils.removeClassName(i.getElem(),"oj-active-drop"))}};r(this._chart.xAxis),r(this._chart.yAxis),r(this._chart.y2Axis)}ShowRejectedDropEffect(e){var t=this._getDropObject(e);t&&t.setClassName("oj-invalid-drop")}_getDropObject(e){var t,i=this.GetDropTargetType(e);return"plotArea"==i?t=this._chart.getCache().getFromCache("plotAreaBackground"):"xAxis"==i?t=this._chart.xAxis.getCache().getFromCache("background"):"yAxis"==i?t=this._chart.yAxis.getCache().getFromCache("background"):"y2Axis"==i&&(t=this._chart.y2Axis.getCache().getFromCache("background")),t}}X.DRAG_MODE_PAN="pan",X.DRAG_MODE_ZOOM="zoom",X.DRAG_MODE_SELECT="select",X.DRAG_MODE_OFF="off";class Z extends t.KeyboardHandler{constructor(e,t){super(e),this._chart=t}isSelectionEvent(e){return this.isNavigationEvent(e)&&!e.ctrlKey}isMultiSelectEvent(e){return e.keyCode==t.KeyboardEvent.SPACE&&e.ctrlKey}processKeyDown(e){var i=e.keyCode;if(i==t.KeyboardEvent.TAB){if(s=this._eventManager.getFocus())return t.EventManager.consumeEvent(e),s;var r=F.getKeyboardNavigables(this._chart);if(r.length>0)return t.EventManager.consumeEvent(e),this.getDefaultNavigable(r)}else if(i==t.KeyboardEvent.ENTER){var s;if(s=this._eventManager.getFocus())return this._eventManager.processDrillEvent(s),t.EventManager.consumeEvent(e),s}else i==t.KeyboardEvent.ESCAPE?this._eventManager.cancelMarquee(e):i==t.KeyboardEvent.PAGE_UP?((e.ctrlKey||e.shiftKey||l.isBLAC(this._chart))&&l.isVertical(this._chart)?this._eventManager.panBy(-.25,0):this._eventManager.panBy(0,-.25),t.EventManager.consumeEvent(e)):i==t.KeyboardEvent.PAGE_DOWN?((e.ctrlKey||e.shiftKey||l.isBLAC(this._chart))&&l.isVertical(this._chart)?this._eventManager.panBy(.25,0):this._eventManager.panBy(0,.25),t.EventManager.consumeEvent(e)):t.KeyboardEvent.isEquals(e)||t.KeyboardEvent.isPlus(e)?this._eventManager.zoomBy(1.5):(t.KeyboardEvent.isMinus(e)||t.KeyboardEvent.isUnderscore(e))&&this._eventManager.zoomBy(1/1.5);return super.processKeyDown(e)}getDefaultNavigable(e){if(!e||e.length<=0)return null;for(var t,i,r,s,a=l.isPie(this._chart),n=0;n<e.length;n++)s=e[n],!t||s.getSeriesIndex()<i?(t=s,i=s.getSeriesIndex(),a||(r=s.getGroupIndex())):!a&&s.getGroupIndex()<r&&(t=s,i=s.getSeriesIndex(),r=s.getGroupIndex());return t}}class K{constructor(e,t,i){this._peer=e,this._updateDuration=.75*t,this._insertDuration=.5*t,this._deleteDuration=.5*t,this._shape=e.getDisplayables()[0],this._animId=e.getDataItemId()||e.getSeries()+"/"+e.getGroup()+i}animateUpdate(e,t){var i=t._shape;this._shape&&this._shape.getUpdateAnim&&e.add(this._shape.getUpdateAnim(this._updateDuration,i),1)}animateInsert(e){if(this._shape&&this._shape.getInsertAnim)e.add(this._shape.getInsertAnim(this._insertDuration),2);else{var i=new t.AnimFadeIn(this._shape.getCtx(),this._shape,this._insertDuration);e.add(i,0)}}animateDelete(e,i){if(i.addChild(this._shape),this._shape&&this._shape.getDeleteAnim)e.add(this._shape.getDeleteAnim(this._deleteDuration),0);else{var r=new t.AnimFadeOut(this._shape.getCtx(),this._shape,this._deleteDuration);e.add(r,0)}}getId(){return this._animId}setId(e){this._animId=e}setOldChart(e){this._oldChart=e}}const q={DIR_UP:0,DIR_DOWN:1,DIR_NOCHANGE:2,makeIndicator:(e,t,i,r,s,a)=>{if(l.isPolar(r))return null;var n=q.getDirection(e,t,i,r,s,a);if(n==q.DIR_NOCHANGE)return null;var o=n===q.DIR_DOWN,h=o?c.getAnimDownColor(r):c.getAnimUpColor(r),g=q._drawIndicator(r.getCtx(),o,l.isHorizontal(r),h);return r.getPlotArea().addChild(g),g},getDirection:(e,t,i,r,s,a)=>{var n=d.getVal(e,t,i),o=d.getVal(r,s,a);return null==o||null==n||o==n?q.DIR_NOCHANGE:o>n?q.DIR_UP:q.DIR_DOWN},_drawIndicator:(e,i,r,s)=>{var a;r?a=(t.Agent.isRightToLeft(e)?!i:i)?"M3.5,-5L3.5,5L-3.5,0L3.5,-5":"M-3.5,-5L-3.5,5L3.5,0L-3.5,-5":a=i?"M-5,-3.5L5,-3.5L0,3.5L-5,-3.5Z":"M-5,3.5L5,3.5L0,-3.5L-5,3.5Z";var n=i?"oj-chart-animation-down":"oj-chart-animation-up",o=new t.Path(e,a);return o.setClassName(n),o.setStyle({fill:s}),o}};class Q extends K{constructor(e,t,i){super(e,t,i),this._indicator=null}animateInsert(e){var t=this._shape.getInsertAnim(this._insertDuration);e.add(t,2)}animateDelete(e,t){t.addChild(this._shape);var i=this._shape.getDeleteAnim(this._deleteDuration);e.add(i,0)}animateUpdate(e,i){var r=this._oldChart,s=this._peer.getChart(),a=l.isHorizontal(r)!=l.isHorizontal(s),n=i._getAnimParams(a),o=this._getAnimParams(),h=i._shape.getPrimaryFill(),g=this._shape.getPrimaryFill(),d=i._shape.isSelected()||this._shape.isSelected()||h.equals(g);if(!t.ArrayUtils.equals(n,o)||!h.equals(g)){var u=this._peer.getSeriesIndex(),_=i._peer.getSeriesIndex(),p=this._peer.getGroupIndex(),v=i._peer.getGroupIndex();"none"!==c.getAnimIndicators(s)&&(this._indicator=q.makeIndicator(r,_,v,s,u,p)),this._setAnimParams(n),d||this._shape.setFill(h);var m=new t.CustomAnimation(this._shape.getCtx(),this,this._updateDuration);m.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimParams,this._setAnimParams,o),d||m.getAnimator().addProp(t.Animator.TYPE_FILL,this._shape,this._shape.getFill,this._shape.setFill,g),this._indicator&&(m.setOnEnd(this._onEndAnim,this),this._indicator.setAlpha(0)),e.add(m,1)}}_getAnimParams(e){return this._shape.getAnimParams(e)}_setAnimParams(e){this._shape.setAnimParams(e,this._indicator)}_onEndAnim(){this._indicator&&(this._indicator.getParent().removeChild(this._indicator),this._indicator=null)}}class J extends K{animateUpdate(e,i){var r=this._shape,s=i._shape.getAnimParams(),a=r.getAnimParams(),n=i._shape.getFill(),o=this._shape.getFill();if(!t.ArrayUtils.equals(s,a)||!n.equals(o)){r.setAnimParams(s);var l=new t.CustomAnimation(r.getCtx(),this,this._updateDuration);l.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,r,r.getAnimParams,r.setAnimParams,a),n.equals(o)||(this._shape.setFill(n),l.getAnimator().addProp(t.Animator.TYPE_FILL,r,r.getFill,r.setFill,o)),this._indicator&&l.setOnEnd(this._onEndAnim,this),e.add(l,1)}}animateInsert(e){var i=this._shape,r=i.getAnimParams(),s=r.slice(0);s[0]+=s[1]/2,s[1]=0,s[3]=0,i.setAnimParams(s);var a=new t.CustomAnimation(i.getCtx(),this,this._insertDuration);a.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimParams,i.setAnimParams,r),e.add(a,2)}animateDelete(e,i){var r=this._shape;i.setClipPath(null),i.addChild(r);var s=r.getAnimParams(),a=s.slice(0);a[0]+=s[1]/2,a[1]=0,a[3]=0;var n=new t.CustomAnimation(r.getCtx(),this,this._deleteDuration);n.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,r,r.getAnimParams,r.setAnimParams,a),e.add(n,0)}}class $ extends K{constructor(e,t){super(e,t,""),this._context=this._shape.getCtx(),this._chart=this._peer.getChart(),this._animId+="/"+(this._shape.isArea()?"area":"line")}animateUpdate(e,i){this._baseCoords=this._shape.getBaseCoords(),this._coords=this._shape.getCoords();var r,s,a=this._shape.isArea(),n=this._oldChart,o=this._chart,l=this._peer.getSeriesIndex(),h=i._peer.getSeriesIndex(),g=this._shape.getCommonGroupIndices(i._shape),u=i._shape.getCommonGroupIndices(this._shape);if(a){var _=i._getBaseAnimParams(this._shape),p=this._getBaseAnimParams(i._shape);$._matchGroupIndices(_,p),t.ArrayUtils.equals(_,p)||(this._setBaseAnimParams(_),(r=new t.CustomAnimation(this._context,this,this._updateDuration)).getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getBaseAnimParams,this._setBaseAnimParams,p))}var v=i._getAnimParams(this._shape),m=this._getAnimParams(i._shape);$._matchGroupIndices(v,m),t.ArrayUtils.equals(v,m)||(this._setAnimParams(v),(s=new t.CustomAnimation(this._context,this,this._updateDuration)).getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimParams,this._setAnimParams,m));var f=d.getSeriesType(this._peer.getChart(),l);if("none"!==c.getAnimIndicators(o)&&(!a||"lineWithArea"!=f))for(var x,C,S=0;S<g.length;S++)x=q.getDirection(n,h,u[S],o,l,g[S]),(C=q.makeIndicator(n,h,u[S],o,l,g[S]))&&this._shape.addIndicator(g[S],x,C);if(r||s){var A=new t.ParallelPlayable(this._context,r,s);A.setOnEnd(this._onAnimEnd,this),e.add(A,1)}}animateInsert(e){this._shape.setAlpha(0);var i=new t.AnimFadeIn(this._context,this._shape,this._insertDuration);e.add(i,2)}animateDelete(e,i){var r;if("area"==d.getSeriesType(this._oldChart,this._peer.getSeriesIndex())){var s=this._chart.__getAreaContainer();if(this._deletedAreas=this._shape.getParent().getParent(),!s)return;s.addChild(this._deletedAreas),(r=new t.AnimFadeOut(this._context,this._deletedAreas,this._deleteDuration)).setOnEnd(this._removeDeletedAreas,this),e.add(r,0)}else i.addChild(this._shape),r=new t.AnimFadeOut(this._context,this._shape,this._deleteDuration),e.add(r,0)}_removeDeletedAreas(){var e=this._chart.__getAreaContainer();e&&e.removeChild(this._deletedAreas)}_getAnimParams(e){return this._shape.getAnimParams(e)}_setAnimParams(e){this._shape.setAnimParams(e)}_getBaseAnimParams(e){return this._shape.getBaseAnimParams(e)}_setBaseAnimParams(e){this._shape.setBaseAnimParams(e)}_onAnimEnd(){this._shape.removeIndicators(),this._shape.setCoords(this._coords,this._baseCoords)}static _matchGroupIndices(e,t){for(var i=3;i<e.length;i+=4)e[i]=t[i]}}class ee extends K{animateUpdate(e,i){var r=i._shape.getCenterDimensions(),s=this._shape.getCenterDimensions();if(!s.equals(r)){this._shape.setCenterDimensions(r);var a=new t.CustomAnimation(this._shape.getCtx(),this,this._updateDuration);a.getAnimator().addProp(t.Animator.TYPE_RECTANGLE,this._shape,this._shape.getCenterDimensions,this._shape.setCenterDimensions,s);var n=this._peer.getChart();if(this.isValueChange(i)&&"none"!=c.getAnimIndicators(n)&&l.isScatterBubble(n)){var o=i._shape;o.setAlpha(.9),o.setClassName("oj-chart-animation-marker"),o.setCenterDimensions(r),this._peer.getChart().getPlotArea().addChild(o),a.getAnimator().addProp(t.Animator.TYPE_RECTANGLE,o,o.getCenterDimensions,o.setCenterDimensions,s),a.getAnimator().addProp(t.Animator.TYPE_NUMBER,o,o.getAlpha,o.setAlpha,0),this._overlay=o,a.setOnEnd(this._onEndAnim,this)}e.add(a,1)}}animateInsert(e){this._shape.setAlpha(0);var i=new t.AnimFadeIn(this._shape.getCtx(),this._shape,this._insertDuration);e.add(i,2)}animateDelete(e,i){i.addChild(this._shape);var r=new t.AnimFadeOut(this._shape.getCtx(),this._shape,this._deleteDuration);e.add(r,0)}isValueChange(e){var t=!1;if(e){var i=e._peer.getSeriesIndex(),r=e._peer.getGroupIndex(),s=this._peer.getSeriesIndex(),a=this._peer.getGroupIndex(),n=e._oldChart.getOptions(),o=this._peer.getChart().getOptions(),l=n.series[i].items[r].x,h=n.series[i].items[r].y,g=n.series[i].items[r].z,d=o.series[s].items[a].x,u=o.series[s].items[a].y,_=o.series[s].items[a].z;t=d!==l||u!==h||_!==g}return t}_onEndAnim(){this._overlay&&(this._peer.getChart().getPlotArea().removeChild(this._overlay),this._overlay=null)}}class te extends K{animateUpdate(e,i){var r=this._shape,s=i._shape.getAnimParams(),a=r.getAnimParams(),n=i._shape.getPrimaryFill(),o=this._shape.getPrimaryFill();if(!t.ArrayUtils.equals(s,a)||!n.equals(o)){r.setAnimParams(s);var l=new t.CustomAnimation(r.getCtx(),this,this._updateDuration);l.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,r,r.getAnimParams,r.setAnimParams,a),n.equals(o)||(this._shape.setFill(n),l.getAnimator().addProp(t.Animator.TYPE_FILL,r,r.getFill,r.setFill,o)),e.add(l,1)}}animateInsert(e){var i=this._shape,r=i.getAnimParams(),s=r.slice(0);s[1]=0,s[2]=0,i.setAnimParams(s);var a=new t.CustomAnimation(i.getCtx(),this,this._insertDuration);a.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimParams,i.setAnimParams,r),e.add(a,2)}animateDelete(e,i){var r=this._shape;i.setClipPath(null),i.addChild(r);var s=r.getAnimParams().slice(0);s[1]=0,s[2]=0;var a=new t.CustomAnimation(r.getCtx(),this,this._deleteDuration);a.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,r,r.getAnimParams,r.setAnimParams,s),e.add(a,0)}}class ie extends K{animateInsert(e){this._shape.setAlpha(0);var i=new t.AnimFadeIn(this._shape.getCtx(),this._shape,this._insertDuration);e.add(i,2)}animateDelete(e,i){i.addChild(this._shape);var r=new t.AnimFadeOut(this._shape.getCtx(),this._shape,this._deleteDuration);e.add(r,0)}animateUpdate(e,i){var r=i._shape.getAnimParams(),s=this._shape.getAnimParams();this._shape.setAnimParams(r);var a=new t.CustomAnimation(this._shape.getCtx(),this,this._updateDuration);a.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._shape,this._shape.getAnimParams,this._shape.setAnimParams,s),e.add(a,1)}}class re extends t.Polygon{constructor(e,t,i,r){let s,a,n,o,l;t&&(a=Math.min(t[0],t[4]),n=Math.max(t[0],t[4]),o=Math.min(t[1],t[5]),l=Math.max(t[1],t[5]),s=[a,o,n,o,n,l,a,l]),super(e,s,i,r),this._x1=a,this._x2=n,this._y1=o,this._y2=l}setStyleProperties(e,i,r,s,a,n,o){this._fill=e,this._borderStroke=i,this._hoverColor=t.SelectionEffectUtils.getHoverBorderColor(r),this._innerColor=s,this._outerColor=a,this._shapeClassName=n,this._shapeStyle=o,this.setStyle(o).setClassName(n),this.setFill(e),i&&this.setStroke(i)}setAnimParams(e){this._x1=Math.min(e[0],e[4]),this._x2=Math.max(e[0],e[4]),this._y1=Math.min(e[1],e[5]),this._y2=Math.max(e[1],e[5]),this.setPoints(e),this._initializeSelectionEffects()}showHoverEffect(){if(!this.IsShowingHoverEffect)if(this.IsShowingHoverEffect=!0,"redwood"===this.getCtx().getThemeBehavior()){if(!this.isSelected()){var e=this.getFill().getColor();this._showNestedBorders(e,this._innerColor)}}else this._showNestedBorders(this._hoverColor,this._innerColor)}hideHoverEffect(){this.IsShowingHoverEffect&&(this.IsShowingHoverEffect=!1,"redwood"===this.getCtx().getThemeBehavior()?this.isSelected()||this._showNestedBorders():this.isSelected()?this._showNestedBorders(this._outerColor,this._innerColor):this._showNestedBorders())}setSelected(e){if(this.IsSelected!=e)if(this.IsSelected=e,"redwood"===this.getCtx().getThemeBehavior()){var t=this.getPrimaryFill().getColor();this.isSelected()?this._showNestedBorders(this._outerColor,this._innerColor):this.isHoverEffectShown()?this._showNestedBorders(t,this._innerColor):this._showNestedBorders()}else this.isHoverEffectShown()?this._showNestedBorders(this._hoverColor,this._innerColor):this.isSelected()?this._showNestedBorders(this._outerColor,this._innerColor):this._showNestedBorders()}UpdateSelectionEffect(){}getPrimaryFill(){return this._fill}_initializeSelectionEffects(){var e=this.isSelected()?re.OUTER_BORDER_WIDTH:re.OUTER_BORDER_WIDTH_HOVER,i=this._createPointsArray(e),r=this._createPointsArray(e+re.INNER_BORDER_WIDTH);if(this.OuterChild)return this.OuterChild.setPoints(i),void this.InnerChild.setPoints(r);this.OuterChild=new t.Polygon(this.getCtx(),i),this.OuterChild.setInvisibleFill(),this.OuterChild.setMouseEnabled(!0),this.addChild(this.OuterChild),this.InnerChild=new t.Polygon(this.getCtx(),r),this.InnerChild.setInvisibleFill(),this.InnerChild.setMouseEnabled(!0),this.addChild(this.InnerChild)}_showNestedBorders(e,t){this._initializeSelectionEffects(),t?(this.setSolidFill(e),this.setStroke(null),this.setClassName().setStyle(),this.OuterChild.setSolidFill(t),this.OuterChild.setClassName().setStyle(),this.InnerChild.setFill(this._fill),this.InnerChild.setClassName(this._shapeClassName).setStyle(this._shapeStyle)):e?(this.setSolidFill(e),this.setStroke(null),this.setClassName().setStyle(),this.OuterChild.setFill(this._fill),this.OuterChild.setClassName(this._shapeClassName).setStyle(this._shapeStyle),this.InnerChild.setInvisibleFill(),this.InnerChild.setClassName().setStyle()):(this.setFill(this._fill),this.setStroke(this._borderStroke),this.setClassName(this._shapeClassName).setStyle(this._shapeStyle),this.OuterChild.setInvisibleFill(),this.OuterChild.setClassName().setStyle(),this.InnerChild.setInvisibleFill(),this.InnerChild.setClassName().setStyle())}_createPointsArray(e){var t=this._x1+e,i=this._x2-e,r=this._y1+e,s=this._y2-e;return[t,r,i,r,i,s,t,s]}}re.OUTER_BORDER_WIDTH=2,re.OUTER_BORDER_WIDTH_HOVER=1.25,re.INNER_BORDER_WIDTH=1;class se extends re{constructor(e,t,i,r,s,a,n){super(e.getCtx(),null,null,n),this._MAX_GAP_SIZE=2,this._MIN_BAR_LENGTH_FOR_GAPS=5,this._INDICATOR_OFFSET=8,this._MIN_BAR_WIDTH_FOR_GAPS_PIXEL_HINTING=15,this._bHoriz=l.isHorizontal(e),this._bStacked=d.isStacked(e),this._barGapRatio=R.getBarGapRatio(e),this._dataItemGaps=c.getDataItemGaps(e),this._axisCoord=t,this._doNotRender=!!n,this._setBarCoords(i,r,s,a,!0)}setSelected(e){if(this.IsSelected!=e){if(this.IsSelected=e,"redwood"===this.getCtx().getThemeBehavior())var t=this.getPrimaryFill().getColor();else t=this._hoverColor;this.isSelected()?(this._tempX1=this._x1,this._tempX2=this._x2,this._tempBaselineCoord=this._baselineCoord,this._x1=this._origX1,this._x2=this._origX2,this._baselineCoord=this._origBaselineCoord,this.setPoints(this._createPointsArray()),"redwood"===this.getCtx().getThemeBehavior()?this._showNestedBorders(this._outerColor,this._innerColor):this._showNestedBorders(this.isHoverEffectShown()?t:this._outerColor,this._innerColor)):(this._x1=this._tempX1,this._x2=this._tempX2,this._baselineCoord=this._tempBaselineCoord,this.setPoints(this._createPointsArray()),"redwood"===this.getCtx().getThemeBehavior()?this.isHoverEffectShown()?this._showNestedBorders(t,this._innerColor):this._showNestedBorders(null):this._showNestedBorders(this.isHoverEffectShown()?t:null))}}getAnimParams(e){return e?this._bHoriz?[this._x2,this._x1,this._baselineCoord,this._endCoord]:[this._x1,this._x2,this._endCoord,this._baselineCoord]:[this._baselineCoord,this._endCoord,this._x1,this._x2]}setAnimParams(e,t){if(this._setBarCoords(e[0],e[1],e[2],e[3],!1),t){var i=this.getIndicatorPos();t.setTranslate(i.x,i.y),t.setAlpha(1),t.getParent().addChild(t)}}getDisplayAnim(e){var i=this.getAnimParams();this.setAnimParams([this._axisCoord,this._axisCoord,this._x1,this._x2]);var r=new t.CustomAnimation(this.getCtx(),this,e);return r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.getAnimParams,this.setAnimParams,i),r}getDeleteAnim(e){var i=[this._baselineCoord,this._baselineCoord,this._x1,this._x2],r=new t.CustomAnimation(this.getCtx(),this,e);return r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.getAnimParams,this.setAnimParams,i),r.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,0),r}getInsertAnim(e){this.setAlpha(0);var i=this.getDisplayAnim(e);return i.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,1),i}getIndicatorPos(){var e,i,r=(this._x1+this._x2)/2;if(this._bStacked){var s=(this._endCoord+this._baselineCoord)/2;e=this._bHoriz?s:r,i=this._bHoriz?r:s}else{var a=this._endCoord>=this._baselineCoord?this._endCoord+this._INDICATOR_OFFSET:this._endCoord-this._INDICATOR_OFFSET;e=this._bHoriz?a:r,i=this._bHoriz?r:a}return new t.Point(e,i)}_setBarCoords(e,i,r,s,a){this._baselineCoord=e,this._endCoord=i,this._x1=r,this._x2=s;var n=this._x2-this._x1;if(n<1&&(this._x1=Math.floor(this._x1),this._x2=this._x1+1,n=1),this._origX1=this._x1,this._origX2=this._x2,this._origBaselineCoord=this._baselineCoord,this._origSize=this._x2-this._x1,this._dataItemGaps>0&&a&&!this.isSelected()){var o=Math.ceil(this._MAX_GAP_SIZE*this._dataItemGaps),l=Math.abs(this._baselineCoord-this._endCoord),h=this._axisCoord==this._baselineCoord;l>=this._MIN_BAR_LENGTH_FOR_GAPS&&this._bStacked&&!h&&(this._baselineCoord+=this._endCoord>this._baselineCoord?o:-o),n>=se._MIN_BAR_WIDTH_FOR_GAPS&&(1==t.Agent.getDevicePixelRatio()&&this._barGapRatio>0&&n>this._MIN_BAR_WIDTH_FOR_GAPS_PIXEL_HINTING?("firefox"===t.Agent.browser||this._doNotRender||this.setPixelHinting(!0),this._x1=Math.round(this._x1),this._x2=Math.round(this._x2),this._origX1=this._x1,this._origX2=this._x2,this._x2-=o):(this._x1+=o/2,this._x2-=o/2),this._origSize-=o)}if(!this._doNotRender){var g=this._createPointsArray();this.setPoints(g),this.OuterChild&&this.OuterChild.setPoints(this._createPointsArray(re.OUTER_BORDER_WIDTH)),this.InnerChild&&this.InnerChild.setPoints(this._createPointsArray(re.OUTER_BORDER_WIDTH+re.INNER_BORDER_WIDTH))}}_createPointsArray(e){var t=this._baselineCoord,i=this._endCoord,r=this._x1,s=this._x2;if(e>0){if(Math.abs(r-s)<2*e||Math.abs(t-i)<2*e)return[];r+=e,s-=e,i<t?(t-=e,i+=e):(t+=e,i-=e)}return this._bHoriz?[i,r,i,s,t,s,t,r]:[r,i,s,i,s,t,r,t]}getBoundingBox(){var e=Math.min(this._x2,this._x1),i=Math.min(this._endCoord,this._baselineCoord),r=Math.abs(this._x2-this._x1),s=Math.abs(this._endCoord-this._baselineCoord);return this._bHoriz?new t.Rectangle(i,e,s,r):new t.Rectangle(e,i,r,s)}getOriginalBarSize(){return this._origSize}getDimensionsSelf(e){return this.ConvertCoordSpaceRect(this.getBoundingBox(),e)}}se._MIN_BAR_WIDTH_FOR_GAPS=5;class ae extends t.Shape{constructor(e,i,r,s,a,n,o,h,g){super(e.getCtx()),this._chart=e,this._bHoriz=l.isHorizontal(e),this._styleOptions=g,this._innerColor=c.getSelectedInnerColor(this._chart),this._outerColor=c.getSelectedOuterColor(this._chart),this._hoverColor=t.SelectionEffectUtils.getHoverBorderColor(this._styleOptions._color);var d=i-r/2,u=i+r/2;c.getDataItemGaps(e)>0&&r>se._MIN_BAR_WIDTH_FOR_GAPS&&u--,this._render(d,u,s,a,n,o,h)}_render(e,i,r,s,a,n,o){this._cleanUp();var l=this.getCtx();this._x1=Math.round(e),this._x2=Math.round(i),this._low=Math.round(r),this._q1=Math.round(s),this._q2=Math.round(a),this._q3=Math.round(n),this._high=Math.round(o);var h=i-e,g=c.getSizeInPixels(this._styleOptions.whiskerEndLength,h);g=Math.min(h,g),g=2*Math.floor((g-1)/2)+1;var d=Math.floor((e+i)/2)+.5,u=d-Math.floor(g/2)-.5,_=d+Math.floor(g/2)+.5;this._drawLine(d,this._low,d,this._high,"whisker"),this._drawLine(u,this._low,_,this._low,"whiskerEnd"),this._drawLine(u,this._high,_,this._high,"whiskerEnd"),this._q2Box=new t.Polygon(l,this._createQ2PointsArray(0));var p=k.getRectangleFill(this._chart,this._styleOptions.q2Color,this._styleOptions._q2Pattern,h);this._q2Box.setFill(p),this._applyCustomStyle(this._q2Box,"q2"),this.addChild(this._q2Box),this._q3Box=new t.Polygon(l,this._createQ3PointsArray(0));var v=k.getRectangleFill(this._chart,this._styleOptions.q3Color,this._styleOptions._q3Pattern,h);this._q3Box.setFill(v),this._applyCustomStyle(this._q3Box,"q3"),this.addChild(this._q3Box),this._drawMedianLine(0),this._borderColor=this._styleOptions.borderColor,this._borderColor&&(this._borderWidth=this._styleOptions.borderWidth,this._drawBorders(this._borderColor,this._borderWidth)),this.IsSelected&&(this.IsSelected=!1,this.setSelected(!0))}showHoverEffect(){this.IsShowingHoverEffect||(this.IsShowingHoverEffect=!0,this.isSelected()?"redwood"!==this.getCtx().getThemeBehavior()&&this._drawBorders(this._hoverColor,re.OUTER_BORDER_WIDTH,this._innerColor,re.INNER_BORDER_WIDTH):this._drawBorders(this._hoverColor,re.OUTER_BORDER_WIDTH_HOVER,this._innerColor,re.INNER_BORDER_WIDTH))}hideHoverEffect(){this.IsShowingHoverEffect&&(this.IsShowingHoverEffect=!1,this.isSelected()?this._drawBorders(this._outerColor,re.OUTER_BORDER_WIDTH,this._innerColor,re.INNER_BORDER_WIDTH):this._drawBorders(this._borderColor,this._borderWidth))}setSelected(e){this.IsSelected!=e&&(this.IsSelected=e,this.isHoverEffectShown()?e?"redwood"===this.getCtx().getThemeBehavior()?this._drawBorders(this._outerColor,re.OUTER_BORDER_WIDTH,this._innerColor,re.INNER_BORDER_WIDTH):this._drawBorders(this._hoverColor,re.OUTER_BORDER_WIDTH,this._innerColor,re.INNER_BORDER_WIDTH):this._drawBorders(this._hoverColor,re.OUTER_BORDER_WIDTH_HOVER,this._innerColor,re.INNER_BORDER_WIDTH):e?this._drawBorders(this._outerColor,re.OUTER_BORDER_WIDTH,this._innerColor,re.INNER_BORDER_WIDTH):this._drawBorders(this._hoverColor,this._borderWidth))}UpdateSelectionEffect(){}getDisplayAnim(e){return this.getInsertAnim(e)}getDeleteAnim(e){var i=new t.CustomAnimation(this.getCtx(),this,e),r=[this._x1,this._x2,this._q2,this._q2,this._q2,this._q2,this._q2];return i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimParams,this._setAnimParams,r),i.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,0),i}getInsertAnim(e){var i=new t.CustomAnimation(this.getCtx(),this,e),r=this._getAnimParams();return this._setAnimParams([this._x1,this._x2,this._q2,this._q2,this._q2,this._q2,this._q2]),i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimParams,this._setAnimParams,r),this.setAlpha(0),i.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,1),i}getUpdateAnim(e,i){var r=new t.CustomAnimation(this.getCtx(),this,e),s=i._getQ2Fill(),a=this._getQ2Fill();s.equals(a)||(this._setQ2Fill(s),r.getAnimator().addProp(t.Animator.TYPE_FILL,this,this._getQ2Fill,this._setQ2Fill,a));var n=i._getQ3Fill(),o=this._getQ3Fill();n.equals(o)||(this._setQ3Fill(n),r.getAnimator().addProp(t.Animator.TYPE_FILL,this,this._getQ3Fill,this._setQ3Fill,o));var l=this._getAnimParams();return this._setAnimParams(i._getAnimParams()),r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimParams,this._setAnimParams,l),r}_getAnimParams(){return[this._x1,this._x2,this._low,this._q1,this._q2,this._q3,this._high]}_setAnimParams(e){this._render(e[0],e[1],e[2],e[3],e[4],e[5],e[6])}_getQ2Fill(){return new t.SolidFill(this._styleOptions.q2Color)}_setQ2Fill(e){this._styleOptions.q2Color=e.getColor()}_getQ3Fill(){return new t.SolidFill(this._styleOptions.q3Color)}_setQ3Fill(e){this._styleOptions.q3Color=e.getColor()}_drawLine(e,i,r,s,a){var n=this._bHoriz?new t.Line(this.getCtx(),i,e,s,r):new t.Line(this.getCtx(),e,i,r,s);return this._applyCustomStyle(n,a),n.setPixelHinting(!0),this.addChild(n),n}_drawMedianLine(e){if(!this._medianLine){var i=new t.Line(this.getCtx(),0,0,0,0);this._applyCustomStyle(i,"median"),i.setPixelHinting(!0),this.addChild(i),this._medianLine=i}var r=this._x1+e,s=this._x2-e,a=this._q2;this._bHoriz?(this._medianLine.setX1(a),this._medianLine.setX2(a),this._medianLine.setY1(r),this._medianLine.setY2(s)):(this._medianLine.setY1(a),this._medianLine.setY2(a),this._medianLine.setX1(r),this._medianLine.setX2(s))}_drawBorders(e,i,r,s){if(!this._outerBorderShape){var a=this.getChildIndex(this._q2Box);this._innerBorderShape=new t.Polygon(this.getCtx()),this._innerBorderShape.setInvisibleFill(),this.addChildAt(this._innerBorderShape,a),this._outerBorderShape=new t.Polygon(this.getCtx()),this._outerBorderShape.setInvisibleFill(),this.addChildAt(this._outerBorderShape,a)}var n=0;i?(this._outerBorderShape.setPoints(this._createBoxPointsArray(0)),this._outerBorderShape.setSolidFill(e),n+=i,s?(this._innerBorderShape.setPoints(this._createBoxPointsArray(i)),this._innerBorderShape.setSolidFill(r),n+=s):this._innerBorderShape.setInvisibleFill()):(this._outerBorderShape.setInvisibleFill(),this._innerBorderShape.setInvisibleFill()),this._q2Box.setPoints(this._createQ2PointsArray(n)),this._q3Box.setPoints(this._createQ3PointsArray(n)),this._drawMedianLine(n)}_createBoxPointsArray(e){var t,i,r=this._x1+e,s=this._x2-e;return this._q1<this._q3?(t=this._q1+e,i=this._q3-e):(t=this._q1-e,i=this._q3+e),this._createPointsArray(r,s,t,i)}_createQ3PointsArray(e){var t,i=this._x1+e,r=this._x2-e,s=this._q2;return t=this._q2<this._q3?this._q3-e:this._q3+e,this._createPointsArray(i,r,s,t)}_createQ2PointsArray(e){var t,i=this._x1+e,r=this._x2-e,s=this._q2;return t=this._q2<this._q1?this._q1-e:this._q1+e,this._createPointsArray(i,r,t,s)}_createPointsArray(e,t,i,r){return this._bHoriz?[i,e,i,t,r,t,r,e]:[e,i,t,i,t,r,e,r]}_applyCustomStyle(e,t){e.setStyle(this._styleOptions[t+"Style"]||this._styleOptions[t+"SvgStyle"],!0),e.setClassName(this._styleOptions[t+"ClassName"]||this._styleOptions[t+"SvgClassName"],!0)}_cleanUp(){this.removeChildren(),this._q2Box=null,this._q3Box=null,this._medianLine=null,this._outerBorderShape=null,this._innerBorderShape=null}}class ne extends t.Container{constructor(e,t,i,r,s,a,n){super(e),this._BAR_WIDTH=.3,i=Math.max(2*Math.round(i/2),1);var o=Math.min(2*Math.ceil(this._BAR_WIDTH*i/2),i),l=Math.round(t)-i/2,h=l+i;if(null!=a&&null!=n){var g=Math.round(t)-o/2,d=g+o;this._rangeShape=new re(e,[g,a,d,a,d,n,g,n]),this.addChild(this._rangeShape)}this._changeShape=new re(e,[l,r,h,r,h,s,l,s]),this.addChild(this._changeShape),this.setPixelHinting(!0)}setChangeStyle(e,t,i,r,s){this._changeShape.setStyleProperties(e,t,i,r,s)}setRangeStyle(e,t,i,r){this._rangeShape&&this._rangeShape.setStyleProperties(e,t,i,null,r)}setSelected(e){this._changeShape.setSelected(e),this._rangeShape&&this._rangeShape.setSelected(e)}showHoverEffect(){this._changeShape.showHoverEffect(),this._rangeShape&&this._rangeShape.showHoverEffect()}hideHoverEffect(){this._changeShape.hideHoverEffect(),this._rangeShape&&this._rangeShape.hideHoverEffect()}getDisplayAnim(e){var i=new t.CustomAnimation(this.getCtx(),this,e),r=this._changeShape.getPoints();if(this._changeShape.setPoints(ne._getInitialPoints(r)),i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._changeShape,this._changeShape.getPoints,this._changeShape.setAnimParams,r),this._rangeShape){var s=this._rangeShape.getPoints();this._rangeShape.setPoints(ne._getInitialPoints(s)),i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._rangeShape,this._rangeShape.getPoints,this._rangeShape.setAnimParams,s)}return i}getDeleteAnim(e){var i=new t.CustomAnimation(this.getCtx(),this,e),r=ne._getInitialPoints(this._changeShape.getPoints());if(i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._changeShape,this._changeShape.getPoints,this._changeShape.setAnimParams,r),this._rangeShape){var s=ne._getInitialPoints(this._rangeShape.getPoints());i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._rangeShape,this._rangeShape.getPoints,this._rangeShape.setAnimParams,s)}return i.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,0),i}getInsertAnim(e){this.setAlpha(0);var i=this.getDisplayAnim(e);return i.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,1),i}getUpdateAnim(e,i){var r=new t.CustomAnimation(this.getCtx(),this,e),s=this._changeShape.getPoints();this._changeShape.setPoints(i._changeShape.getPoints()),r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._changeShape,this._changeShape.getPoints,this._changeShape.setAnimParams,s);var a=i._changeShape.getPrimaryFill(),n=this._changeShape.getPrimaryFill();if(i._changeShape.isSelected()||this._changeShape.isSelected()||a.equals(n)||(this._changeShape.setFill(a),r.getAnimator().addProp(t.Animator.TYPE_FILL,this._changeShape,this._changeShape.getFill,this._changeShape.setFill,n)),this._rangeShape&&i._rangeShape){var o=this._rangeShape.getPoints();this._rangeShape.setPoints(i._rangeShape.getPoints()),r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._rangeShape,this._rangeShape.getPoints,this._rangeShape.setAnimParams,o)}return r}UpdateSelectionEffect(){}static _getInitialPoints(e){var t=e[0],i=e[2],r=(e[1]+e[5])/2;return[t,r,i,r,i,r,t,r]}}class oe{constructor(e,t,i,r,s,a){this.x=e,this.y1=t,this.y2=i,this.groupIndex=r,this.group=s,this.filtered=a}isUpstep(e){return Math.abs(this.y2-e)>Math.abs(this.y1-e)}clone(){return new oe(this.x,this.y1,this.y2,this.groupIndex,this.group,this.filtered)}}class le extends t.Container{constructor(e,t,i,r,s,a,n,o,l,h,g,d){super(e.getCtx()),this._INDICATOR_OFFSET=8,this._chart=e,this._bArea=t,this._availSpace=i,this._baseline=r,this._style=s,this._className=a,this._fill=n,this._stroke=o,this._type=l,this._baseType=g||l,this._indicatorMap={},this.setCoords(h,d),this.chartShapeType="lineArea"}setCoords(e,t){this._arCoord=e,t&&(this._arBaseCoord=t),this.removeChildren(),this._bArea?this._renderAreas():this._renderLines(),this._positionIndicators()}getCoords(){return this._arCoord}getBaseCoords(){return this._arBaseCoord}getBaseline(){return this._baseline}isArea(){return this._bArea}_getPointArrays(e,i){var r=[],s=[];r.push(s),e=le._convertToPointCoords(e);var a,n,o,h,g,d=l.isPolar(this._chart),u="centeredStepped"==i||"centeredSegmented"==i,_=u||"stepped"==i||"segmented"==i,p=c.getGroupWidth(this._chart),v=t.Agent.isRightToLeft(this.getCtx())&&l.isVertical(this._chart)?-1:1;d&&(a=e[e.length-1]);for(var m=!1,f=0;f<e.length;f++)null!=e[f]?(n=e[f],h=e[f]._isY2,o=u?n.x-p/2*v:n.x,h&&(m&&_&&(o+=p*v),m=!m),"curved"==i&&h&&s.push(null,null),a&&_&&this._pushCoord(s,o,a.y),this._bArea||"segmented"!=i&&"centeredSegmented"!=i||(s=[],r.push(s)),this._pushCoord(s,o,n.y),a=n):l.isMixedFrequency(this._chart)||(_&&!d&&a&&!h&&(g=u?a.x+.5*p*v:a.x+p*v,this._pushCoord(s,g,a.y)),s=[],r.push(s),a=null);if(_&&!d&&a&&!h&&(g=u?a.x+.5*p*v:a.x+p*v,this._pushCoord(s,g,a.y)),d&&r.length>1){var x=r.pop();r[0]=x.concat(r[0])}return r}_pushCoord(e,i,r){var s=h.convertAxisCoord(this._chart,new t.Point(i,r),this._availSpace);e.push(Math.round(10*s.x)/10,Math.round(10*s.y)/10)}_isRing(){if(!l.isPolar(this._chart)||!l.hasGroupAxis(this._chart)||this._arCoord.length<d.getGroupCount(this._chart))return!1;for(var e=0;e<this._arCoord.length;e++)if(null==this._arCoord[e].x)return!1;return!0}_getSplineType(){return l.isScatterBubble(this._chart)?t.PathUtils.SPLINE_TYPE_CARDINAL:l.isPolar(this._chart)?this._isRing()?t.PathUtils.SPLINE_TYPE_CARDINAL_CLOSED:t.PathUtils.SPLINE_TYPE_CARDINAL:l.isHorizontal(this._chart)?t.PathUtils.SPLINE_TYPE_MONOTONE_HORIZONTAL:t.PathUtils.SPLINE_TYPE_MONOTONE_VERTICAL}_renderLines(){for(var e,i=this._getPointArrays(this._arCoord,this._type),r=0;r<i.length;r++){var s=i[r];if(s&&s.length>1){if("curved"==this._type){var a=le._getCurvedPathCommands(s,!1,this._getSplineType());(e=new t.Path(this.getCtx(),a)).setFill(null)}else this._isRing()?(e=new t.Polygon(this.getCtx(),s)).setFill(null):e=new t.Polyline(this.getCtx(),s);e.setStroke(this._stroke),e.setClassName(this._className).setStyle(this._style),this.addChild(e)}}}_renderAreas(){var e=this._arCoord,i=this._arBaseCoord;!l.isPolar(this._chart)&&e.length>0&&i.length>0&&(e=e.slice(0),i=i.slice(0),null!=e[0].x&&null!=i[0].x&&(le._removeAreaEdge(e,0,this._baseline),le._removeAreaEdge(i,0,this._baseline),i[0].x=e[0].x),null!=e[e.length-1].x&&null!=i[i.length-1].x&&(le._removeAreaEdge(e,e.length-1,this._baseline),le._removeAreaEdge(i,i.length-1,this._baseline),i[i.length-1].x=e[e.length-1].x));var r=this._getPointArrays(e,this._type),s=this._getPointArrays(i,this._baseType);if(r.length==s.length)for(var a,n=0;n<r.length;n++){var o=r[n],h=s[n];if(!(o.length<2)){var g="curved"==this._type,d="curved"==this._baseType;this._isRing()&&(g||o.push(o[0],o[1]),h.length>=2&&!d&&h.push(h[0],h[1]));for(var u=[],_=0;_<h.length;_+=2)u.unshift(h[_],h[_+1]);if(g||d){var c=this._getSplineType(),p=g?le._getCurvedPathCommands(o,!1,c):t.PathUtils.polyline(o,!1);p+=d?le._getCurvedPathCommands(u,!0,c):t.PathUtils.polyline(u,!0),p+=t.PathUtils.closePath(),a=new t.Path(this.getCtx(),p)}else{var v=u.concat(o);a=new t.Polygon(this.getCtx(),v)}a.setFill(this._fill),a.setClassName(this._className).setStyle(this._style),this._stroke&&a.setStroke(this._stroke),this.addChild(a)}}}_positionIndicators(){for(var e,i,r,s,a,n=0;n<this._arCoord.length;n++)a=this._arCoord[n],(e=this._indicatorMap[a.groupIndex])&&e.indicator&&(s=(a.isUpstep(this._baseline)?a.y2:a.y1)+this._INDICATOR_OFFSET*(e.direction==q.DIR_UP?-1:1),r=h.convertAxisCoord(this._chart,new t.Point(a.x,s),this._availSpace),(i=e.indicator).setTranslate(r.x,r.y),i.setAlpha(1),i.getParent().addChild(i))}getAnimParams(e){return le._coordsToAnimParams(this._arCoord,e?e._arCoord:null,this._baseline)}setAnimParams(e){var t=le._animParamsToCoords(e);this.setCoords(t)}getBaseAnimParams(e){return le._coordsToAnimParams(this._arBaseCoord,e?e._arBaseCoord:null,this._baseline)}setBaseAnimParams(e){this._arBaseCoord=le._animParamsToCoords(e)}getCommonGroupIndices(e){for(var t=[],i=0;i<this._arCoord.length;i++)if(!this._arCoord[i].filtered&&null!=this._arCoord[i].x)for(var r=0;r<e._arCoord.length;r++)if(!e._arCoord[r].filtered&&null!=e._arCoord[r].x&&this._arCoord[i].group==e._arCoord[r].group){t.push(this._arCoord[i].groupIndex);break}return t}addIndicator(e,t,i){i.setAlpha(0),this._indicatorMap[e]={direction:t,indicator:i}}removeIndicators(){for(var e in this._indicatorMap){var t=this._indicatorMap[e].indicator;t&&t.getParent().removeChild(t)}this._indicatorMap={}}static _convertToPointCoords(e){for(var i=[],r=0;r<e.length;r++)if(!e[r].filtered)if(null==e[r].x)i.push(null);else if(i.push(new t.Point(e[r].x,e[r].y1)),e[r].y1!=e[r].y2){var s=new t.Point(e[r].x,e[r].y2);s._isY2=!0,i.push(s)}return i}static _coordsToAnimParams(e,t,i){if(t&&t.length>0)if(e&&e.length>0){e=e.slice(0);for(var r,s,a,n=le._coordsToGroups(t),o=le._coordsToGroups(e),l=e.length,h=n.length-1;h>=0;h--)r=n[h],-1==(s=o.indexOf(r))?(0==l?(a=e[0].clone(),e[0]=e[0].clone(),le._removeCoordJump(a,e[0],i)):(a=e[l-1].clone(),e[l-1]=e[l-1].clone(),le._removeCoordJump(e[l-1],a,i)),a.groupIndex=-1,e.splice(l,0,a)):l=s}else{e=[];for(h=0;h<t.length;h++)e.push(new oe(t[h].x,i,i))}for(var g=[],d=0;d<e.length;d++)e[d].filtered||(null==e[d].x?(g.push(1/0),g.push(1/0),g.push(1/0)):(g.push(e[d].x),g.push(e[d].y1),g.push(e[d].y2)),g.push(e[d].groupIndex));return g}static _animParamsToCoords(e){for(var t=[],i=0;i<e.length;i+=4)e[i]==1/0||isNaN(e[i])?t.push(new oe(null,null,null,e[i+3])):t.push(new oe(e[i],e[i+1],e[i+2],e[i+3]));return t}static _coordsToGroups(e){for(var t=[],i=0;i<e.length;i++)e[i].filtered||t.push(e[i].group);return t}static _removeCoordJump(e,t,i){e.isUpstep(i)?t.y1=t.y2:e.y2=e.y1}static _getCurvedPathCommands(e,i,r){var s=[],a=[];s.push(a);for(var n=0;n<e.length;n+=2)null==e[n]?(a=[],s.push(a)):a.push(e[n],e[n+1]);if(r==t.PathUtils.SPLINE_TYPE_CARDINAL_CLOSED&&s.length>1){var o=s.pop();s[0]=o.concat(s[0]),r=t.PathUtils.SPLINE_TYPE_CARDINAL}var l="";for(n=0;n<s.length;n++)a=s[n],l+=t.PathUtils.curveThroughPoints(a,i,r),i=!0;return l}static _removeAreaEdge(e,t,i){var r=e[t].clone();r.isUpstep(i)?r.y1=r.y2:r.y2=r.y1,e[t]=r}}class he extends t.SimpleMarker{constructor(e,t,i,r,s,a){super(e,t,i,r,s,s,null,null,!0),a&&this.setStroke(he.DEFAULT_STROKE)}setDataColor(e){this._dataColor=e,this._hoverStroke=new t.Stroke(e,1,1.5)}getDataColor(){return this._dataColor}showHoverEffect(){this.IsShowingHoverEffect=!0,this.setStroke(this._hoverStroke)}hideHoverEffect(){this.IsShowingHoverEffect=!1,this.setStroke(this.isSelected()?he.SELECTED_STROKE:he.DEFAULT_STROKE)}setSelected(e){this.IsSelected!=e&&(this.IsSelected=e,this.isSelected()?(this.setFill(he.SELECTED_FILL),this.setStroke(this.isHoverEffectShown()?this._hoverStroke:he.SELECTED_STROKE)):(this.setInvisibleFill(),this.setStroke(this.isHoverEffectShown()?this._hoverStroke:he.DEFAULT_STROKE)))}UpdateSelectionEffect(){}}he.DEFAULT_STROKE=new t.Stroke("none"),he.SELECTED_FILL=new t.SolidFill("#FFFFFF"),he.SELECTED_STROKE=new t.Stroke("#5A5A5A",1,1.5);class ge extends U{constructor(e,t,i,r,s,a,n){super(e.getCtx()),this._MIN_BAR_LENGTH_FOR_GAPS=4,this._MAX_DATA_ITEM_GAP=3,this._axisCoord=t,this._availSpace=n.clone(),this._bbox=null,this._dataItemGaps=c.getDataItemGaps(e)*this._MAX_DATA_ITEM_GAP,this._setBarCoords(i,r,s,a)}getAnimParams(){return[this._baselineCoord,this._endCoord,this._x1,this._x2]}setAnimParams(e){this._setBarCoords(e[0],e[1],e[2],e[3])}getPrimaryFill(){return this.getFill()}getDisplayAnim(e){var i=this.getAnimParams();this.setAnimParams([this._axisCoord,this._axisCoord,0,0]);var r=new t.CustomAnimation(this.getCtx(),this,e);return r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.getAnimParams,this.setAnimParams,i),r}getDeleteAnim(e){var i=[this._baselineCoord,this._baselineCoord,this._x1,this._x2],r=new t.CustomAnimation(this.getCtx(),this,e);return r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.getAnimParams,this.setAnimParams,i),r.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,0),r}getInsertAnim(e){this.setAlpha(0);var i=this.getAnimParams();this.setAnimParams([this._baselineCoord,this._baselineCoord,this._x1,this._x2]);var r=new t.CustomAnimation(this.getCtx(),this,e);return r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.getAnimParams,this.setAnimParams,i),r.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,1),r}_setBarCoords(e,i,r,s){var a=this._availSpace.x+this._availSpace.w/2,n=this._availSpace.y+this._availSpace.h/2,o=Math.max(i,e),l=Math.abs(i-e)>=this._MIN_BAR_LENGTH_FOR_GAPS&&this._axisCoord!=e?Math.min(i,e)+this._dataItemGaps:Math.min(i,e),g=360-t.Math.radsToDegrees(Math.max(r,s))+90,d=t.Math.radsToDegrees(Math.abs(s-r));this.setWedgeParams(a,n,o,o,g,d,this._dataItemGaps,l);var u=h.polarToCartesian(e,r,this._availSpace),_=h.polarToCartesian(e,s,this._availSpace),c=h.polarToCartesian(i,r,this._availSpace),p=h.polarToCartesian(i,s,this._availSpace),v=Math.min(u.x,_.x,c.x,p.x),m=Math.max(u.x,_.x,c.x,p.x),f=Math.min(u.y,_.y,c.y,p.y),x=Math.max(u.y,_.y,c.y,p.y);this._bbox=new t.Rectangle(v,f,m-v,x-f),this._baselineCoord=e,this._endCoord=i,this._x1=r,this._x2=s}getBoundingBox(){return this._bbox}getOriginalBarSize(){return this._bbox.w}}class de extends t.Path{constructor(e,t,i,r,s,a,n){super(e),this._markerSize=a,this._isInvisible=n,this._drawPath(t,i,r,s)}_drawPath(e,i,r,s){var a=Math.atan2(s-i,r-e),n=this._markerSize/2,o=Math.PI/8,l=t.PathUtils.moveTo(e+n*Math.cos(a+o),i+n*Math.sin(a+o))+t.PathUtils.arcTo(n,n,2*(Math.PI-o),1,e+n*Math.cos(a-o),i+n*Math.sin(a-o))+t.PathUtils.lineTo(r-n*Math.cos(a+o),s-n*Math.sin(a+o))+t.PathUtils.arcTo(n,n,2*(Math.PI-o),1,r-n*Math.cos(a-o),s-n*Math.sin(a-o))+t.PathUtils.closePath();this.setCmds(l),this._x1=e,this._y1=i,this._x2=r,this._y2=s}setStyleProperties(e,i,r,s,a){this._dataColor=r;var n=t.SelectionEffectUtils.getHoverBorderColor(r);this._isInvisible?(this.setInvisibleFill(),this._hoverStroke=new t.Stroke(n,1,1.5)):(this.setFill(e),this.setStroke(i),this.setHoverStroke(new t.Stroke(s,1,1),new t.Stroke(n,1,3.5)),this.setSelectedStroke(new t.Stroke(s,1,1.5),new t.Stroke(a,1,4.5)),this.setSelectedHoverStroke(new t.Stroke(s,1,1.5),new t.Stroke(n,1,4.5)))}getDataColor(){return this._dataColor}showHoverEffect(){this._isInvisible?(this.IsShowingHoverEffect=!0,this.setStroke(this._hoverStroke)):super.showHoverEffect()}hideHoverEffect(){this._isInvisible?(this.IsShowingHoverEffect=!1,this.setStroke(this.isSelected()?he.SELECTED_STROKE:he.DEFAULT_STROKE)):super.hideHoverEffect()}setSelected(e){if(this._isInvisible){if(this.IsSelected==e)return;this.IsSelected=e,this.isSelected()?(this.setFill(he.SELECTED_FILL),this.setStroke(this.isHoverEffectShown()?this._hoverStroke:he.SELECTED_STROKE)):(this.setInvisibleFill(),this.setStroke(this.isHoverEffectShown()?this._hoverStroke:he.DEFAULT_STROKE))}else super.setSelected(e)}UpdateSelectionEffect(){this._isInvisible||super.UpdateSelectionEffect()}getAnimParams(){return[this._x1,this._y1,this._x2,this._y2]}setAnimParams(e){this._drawPath(e[0],e[1],e[2],e[3])}isInvisible(){return this._isInvisible}getBoundingBox(){return this.getBoundingBox1().getUnion(this.getBoundingBox2())}getBoundingBox1(){return new t.Rectangle(this._x1-this._markerSize/2,this._y1-this._markerSize/2,this._markerSize,this._markerSize)}getBoundingBox2(){return new t.Rectangle(this._x2-this._markerSize/2,this._y2-this._markerSize/2,this._markerSize,this._markerSize)}}const ue={createAnim:(e,i,r,s,a)=>{if(!ue._canAnimate(e,i))return null;var n,o=i.getCtx(),h=[],g=[];l.isPie(i)?(h.push(e.pieChart),g.push(i.pieChart)):ue._buildAnimLists(o,h,e,g,i,s);var d=new t.DataAnimationHandler(o,a);d.constructAnimation(h,g),d.getNumPlayables()>0&&(n=d.getAnimation(!0));var u=i.getDataLabels();if(n&&u.length>0){for(var _=0;_<u.length;_++)u[_].setAlpha(0);n=new t.SequentialPlayable(o,n,new t.AnimFadeIn(o,u,s/4))}return n},_buildAnimLists:(e,i,r,s,a,n)=>{var o,l,h,g,d,u=r.getChartObjPeers(),_=i,c=a.getCache().getFromCache("dataFiltered");for(o=0;o<2;o++){var p={},v={};for(l=0;l<u.length;l++){if(d=null,(g=(h=u[l]).getDisplayables()[0])instanceof B)d=new J(h,n,"/funnel");else if(g instanceof H)d=new te(h,n,"/pyramid");else if(g instanceof se||g instanceof ge){if(d=new Q(h,n,"/bar"),c){var m=h.getSeries();p[m]=p[m]?p[m]+1:1,d.setId(m+"/"+p[m]+"/bar")}}else if(g instanceof le){var f=(d=new $(h,n)).getId();v[f]=v[f]?v[f]+1:1,d.setId(f+"/"+v[f])}else if(g instanceof t.SimpleMarker){if(g instanceof he&&!g.isSelected())continue;d=new ee(h,n,"/marker")}else if(g instanceof de){if(g.isInvisible()&&!g.isSelected())continue;d=new ie(h,n,"/rangeMarker")}else g instanceof ne?d=new K(h,n):g instanceof ae&&(d=new K(h,n,"/boxAndWhisker"));d&&(_.push(d),d.setOldChart(r))}_=s,u=a.getChartObjPeers()}},_canAnimate:(e,t)=>l.isPie(e)&&l.isPie(t)?e&&t:l.isPolar(e)==l.isPolar(t)&&(!(!l.isBLAC(e)||!l.isBLAC(t))||(!(!l.isScatterBubble(e)||!l.isScatterBubble(t))||e.getType()==t.getType()))},_e={createAnim:(e,i,r)=>{var s=[];if(l.isBLAC(e))_e._animBarLineArea(e,r,s);else if(l.isScatterBubble(e)||l.isFunnel(e)||l.isPyramid(e))_e._animBubbleScatterFunnelPyramid(e,r,s);else if(l.isPie(e)&&e.pieChart)return e.pieChart.getDisplayAnim();return s.length>0?new t.ParallelPlayable(e.getCtx(),s):null},_animBarLineArea:(e,i,r)=>{var s=e.getChartObjPeers(),a=s?s.length:0;if(a)for(var n,o,l,h=0;h<a;h++){n=(o=s[h]).getDisplayables()[0];var g=d.getSeriesType(o.getChart(),o.getSeriesIndex());if(l=null,n instanceof se||n instanceof ge||n instanceof ne||n instanceof ae)l=n.getDisplayAnim(i);else if(n instanceof le)l="line"==g?_e._getLinePlayable(e,n,i):_e._getAreaPlayable(e,n,i);else if(n instanceof t.SimpleMarker||n instanceof de){if(n instanceof he&&!n.isSelected())continue;l=new t.AnimFadeIn(e.getCtx(),n,i-.8,.8)}l&&r.push(l)}},_animBubbleScatterFunnelPyramid:(e,i,r)=>{var s=e.getObjects(),a=s?s.length:0;if(a)for(var n,o,l=0;l<a;l++)(n=s[l].getDisplayables()[0])instanceof t.SimpleMarker?o=new t.AnimPopIn(e.getCtx(),n,!0,i):(n instanceof B||n instanceof H)&&(o=_e._getFunnelPyramidPlayable(e,n,i)),o&&r.push(o)},_getAreaPlayable:(e,i,r)=>{var s,a=e.getCtx(),n=i.getBaseline();if(i.isArea()){for(var o=i.getBaseCoords(),l=i.getBaseAnimParams(),h=l.slice(0),g=0;g<l.length;g++)g%4!=1&&g%4!=2||(l[g]=n);i.setBaseAnimParams(l),(s=new t.CustomAnimation(a,i,r)).getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getBaseAnimParams,i.setBaseAnimParams,h)}var d=i.getCoords(),u=i.getAnimParams(),_=u.slice(0);for(g=0;g<u.length;g++)g%4!=1&&g%4!=2||(u[g]=n);i.setAnimParams(u);var c=new t.CustomAnimation(a,i,r);c.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimParams,i.setAnimParams,_);var p=new t.ParallelPlayable(e.getCtx(),s,c);return p.setOnEnd(()=>{i.setCoords(d,o)}),p},_getFunnelPyramidPlayable:(e,i,r)=>{var s=e.getCtx(),a=i.getAnimParams(),n=a.slice(0),o=a.slice(0);a[0]=0,l.isFunnel(e)&&(a[2]=0,n[2]=0),i.setAnimParams(a);var h=new t.CustomAnimation(s,i,r/2);h.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimParams,i.setAnimParams,n);var g=new t.CustomAnimation(s,i,r/2);return g.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimParams,i.setAnimParams,o),new t.SequentialPlayable(s,[h,g])},_getLinePlayable:(e,i,r)=>{var s=i.getCoords(),a=i.getAnimParams(),n=a.slice(0);_e._getMeanPoints(a),i.setAnimParams(a);var o=new t.CustomAnimation(e.getCtx(),i,r);return o.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimParams,i.setAnimParams,n),o.setOnEnd(()=>{i.setCoords(s)}),o},_getMeanPoints:e=>{var t,i=0,r=Number.MAX_VALUE,s=-1*Number.MAX_VALUE,a=e.length;for(t=0;t<a;t++){var n=e[t];t%4!=0&&t%4!=3&&n!=1/0&&(n<r&&(r=n),n>s&&(s=n),i+=n)}for(a>8?(i-=2*r,i-=2*s,i/=a/2-4):i/=a/2,t=0;t<a;t++)t%4!=1&&t%4!=2||(e[t]=i)}};class ce extends(i.DataAxisInfoMixin(S)){getMinLabel(){return this.ZeroBaseline||"on"==this.Options._continuousExtent&&null==this.Options.min?Math.ceil(this.LinearMinValue/this.MajorIncrement)*this.MajorIncrement:Math.ceil((this.LinearMinValue-this.LinearGlobalMin)/this.MajorIncrement)*this.MajorIncrement+this.LinearGlobalMin}getLabels(e,t){if(t&&t>0)return null;var i=this.getAllLabels(e),r=[],s=e.getStage();return"tangential"!=this.Position&&(r=this.GetLabelDims(i,s),i=this.SkipLabels(i,r)),i}getAllLabels(e,t){var r=[];if(this.Options.tickLabel&&this.Options.tickLabel.scaling){var s=this.Options.tickLabel.autoPrecision?this.Options.tickLabel.autoPrecision:"on";this._axisValueFormatter=new i.LinearScaleAxisValueFormatter(this.LinearMinValue,this.LinearMaxValue,this.MajorIncrement,this.Options.tickLabel.scaling,s,this.Options.translations)}for(var a=0;a<=this.MajorTickCount;a++){var n=a*this.MajorIncrement+this.getMinLabel();if(n-this.LinearMaxValue>this.MAJOR_TICK_INCREMENT_BUFFER)break;var o,l=this.GetUnboundedCoordAt(n);if(this.Options._skipHighestTick){if(n==this.LinearMaxValue)continue;if("tangential"!=this.Position&&Math.abs(l-this.MaxCoord)<this.getTickLabelHeight())continue}this.IsLog?(n=this.linearToActual(n),this._axisValueFormatter=new i.LinearScaleAxisValueFormatter(n,n,n,this.Options.tickLabel.scaling,s,this.Options.translations),o=this._formatValue(n)):o=this._formatValue(n),t?r.push(o):r.push(this.CreateLabel(e,o,l))}return r}getMajorTickCoords(){for(var e=[],t=0;t<=this.MajorTickCount;t++){var i=t*this.MajorIncrement+this.getMinLabel();if(i-this.LinearMaxValue>this.MAJOR_TICK_INCREMENT_BUFFER)break;if(!this.Options._skipHighestTick||i!=this.LinearMaxValue){var r=this.GetUnboundedCoordAt(i);e.push(r)}}return e}getMinorTickCoords(){for(var e=[],i=-1;i<=this.MajorTickCount;i++){var r=i*this.MajorIncrement+this.getMinLabel();if(this.IsLog&&1==this.MajorIncrement&&1==this.MinorIncrement)for(var s=2;s<=9;s++){var a=r+t.Math.log10(s);if(a>this.LinearMaxValue)break;a<this.LinearMinValue||(o=this.GetUnboundedCoordAt(a),e.push(o))}else for(s=1;s<this.MinorTickCount;s++){var n=r+s*this.MinorIncrement;if(n>this.LinearMaxValue)break;if(!(n<this.LinearMinValue)){var o=this.GetUnboundedCoordAt(n);e.push(o)}}}return e}_formatValue(e){if(this.Converter&&this.Converter.format)return this._axisValueFormatter?this._axisValueFormatter.format(e,this.Converter):this.Converter.format(e);if(this._axisValueFormatter)return this._axisValueFormatter.format(e);var i=t.Math.log10(this.MajorIncrement),r=Math.max(Math.ceil(-i),0);return e.toFixed(r)}getMajorTickCount(){return this.MajorTickCount}getMinorTickCount(){return this.MinorTickCount}getMajorIncrement(){return this.linearToActual(this.MajorIncrement)}getMinorIncrement(){return this.linearToActual(this.MinorIncrement)}getMinExtent(){return(this.LinearGlobalMax-this.LinearGlobalMin)/ce.MAX_ZOOM}getStartOverflow(){return"top"!=this.Position&&"bottom"!=this.Position||!t.Agent.isRightToLeft(this.getCtx())?this.StartOverflow:this.EndOverflow}getEndOverflow(){return"top"!=this.Position&&"bottom"!=this.Position||!t.Agent.isRightToLeft(this.getCtx())?this.EndOverflow:this.StartOverflow}alignLogScaleToTickCount(e,t){if(this.IsLog)for(var i=this.getMajorTickCount();t<i;)this.MajorIncrement=null,this.MajorTickCount=null,this.MinorIncrement=null,this.MinorTickCount=null,e++,this.CalcMajorMinorIncr(e),i=this.getMajorTickCount();return e}getLogScaleUnit(){return this.LogScaleUnit}}S.registerConstructor("data",ce),ce.MAX_ZOOM=64;class pe extends S{constructor(e,r,s){super(e,r,s),"top"==this.Position||"bottom"==this.Position?(r._isOverview||"on"!=r.tickLabel.rendered||(this.StartOverflow=Math.max(i.BaseAxisInfo.MIN_AXIS_BUFFER-r.leftBuffer,0),this.EndOverflow=Math.max(i.BaseAxisInfo.MIN_AXIS_BUFFER-r.rightBuffer,0)),t.Agent.isRightToLeft(e)?(this._startCoord=this.EndCoord-this.EndOverflow,this._endCoord=this.StartCoord+this.StartOverflow):(this._startCoord=this.StartCoord+this.StartOverflow,this._endCoord=this.EndCoord-this.EndOverflow)):(this._startCoord=this.StartCoord,this._endCoord=this.EndCoord);var a=null!=r.tickLabel?r.tickLabel.converter:null;this._label1Converter=a&&a[0]?a[0]:a,this._label2Converter=a&&a[1]?a[1]:null,this._dateToIsoWithTimeZoneConverter=e.getLocaleHelpers().dateToIsoWithTimeZoneConverter,this._groups=r.groups;var n=r.timeAxisType;this._skipGaps="skipGaps"==n,this._mixedFrequency="mixedFrequency"==n,this.DataMin=r.dataMin,this.DataMax=r.dataMax,this._groups.length>1?this._averageInterval=(this.DataMax-this.DataMin)/(this._groups.length-1):this.DataMax-this.DataMin>0?this._averageInterval=this.DataMax-this.DataMin:this._averageInterval=6*pe.TIME_MINUTE,this._step=r.step;var o=r.endGroupOffset>0?r.endGroupOffset*this._averageInterval:0,l=r.startGroupOffset>0?r.startGroupOffset*this._averageInterval:0;this.GlobalMin=null!=r.min?r.min:this.DataMin-l,this.GlobalMax=null!=r.max?r.max:this.DataMax+o,null!=r.viewportStartGroup&&(this.MinValue=r.viewportStartGroup-l),null!=r.viewportEndGroup&&(this.MaxValue=r.viewportEndGroup+o),null!=r.viewportMin&&(this.MinValue=r.viewportMin),null!=r.viewportMax&&(this.MaxValue=r.viewportMax),null==this.MinValue&&(this.MinValue=this.GlobalMin),null==this.MaxValue&&(this.MaxValue=this.GlobalMax),this.GlobalMin>this.MinValue&&(this.GlobalMin=this.MinValue),this.GlobalMax<this.MaxValue&&(this.GlobalMax=this.MaxValue),this._timeRange=this.MaxValue-this.MinValue,this._level1Labels=null,this._level2Labels=null,this._level1Coords=null,this._level2Coords=null,this._isOneLevel=!0,this._level1Overflow=[],this._level2Overflow=[],this._locale=r._locale.toLowerCase(),this._monthResources=e.LocaleData.getMonthNames("abbreviated")}formatLabel(e){var t=new Date(e),i=this._formatAxisLabel(t,null,!0);return null!=i[1]?"YMD"==pe._getDMYOrder(this._locale)||this._timeRange<pe.TIME_MONTH_MIN&&this._step<pe.TIME_DAY?i[1]+" "+i[0]:i[0]+" "+i[1]:i[0]}_calculateGranularity(){return this._step>=pe.TIME_YEAR_MIN||this._timeRange>=6*pe.TIME_YEAR_MIN?pe.TIME_YEAR_MIN:this._step>=pe.TIME_MONTH_MIN||this._timeRange>=6*pe.TIME_MONTH_MIN?pe.TIME_MONTH_MIN:this._step>=pe.TIME_DAY||this._timeRange>=6*pe.TIME_DAY?pe.TIME_DAY:this._step>=pe.TIME_HOUR||this._timeRange>=6*pe.TIME_HOUR?pe.TIME_HOUR:this._step>=pe.TIME_MINUTE||this._timeRange>=6*pe.TIME_MINUTE?pe.TIME_MINUTE:pe.TIME_SECOND}_formatAxisLabelWithConverter(e,t,i){if(i){var r=null,s=null;if(i.format&&(r=i.format(this._dateToIsoWithTimeZoneConverter&&e?this._dateToIsoWithTimeZoneConverter(e):e),s=i.format(this._dateToIsoWithTimeZoneConverter&&t?this._dateToIsoWithTimeZoneConverter(t):t)),s!==r||null==r)return r;if(!i.resolvedOptions)return null;var a=this._calculateGranularity();return a===pe.TIME_MONTH_MIN&&t.getMonth()!==e.getMonth()&&null!=i.resolvedOptions().month||a===pe.TIME_DAY&&t.getDate()!==e.getDate()&&null!=i.resolvedOptions().day?r:null}}_formatAxisLabel(e,t,i){var r=null,s=null,a="left"==this.Position||"right"==this.Position,n=this._calculateGranularity();return this._label1Converter||this._label2Converter?(this._label1Converter&&(r=this._formatAxisLabelWithConverter(e,t,this._label1Converter)),this._label2Converter&&(s=this._formatAxisLabelWithConverter(e,t,this._label2Converter)),[r,s]):(n===pe.TIME_YEAR_MIN?r=this._formatDate(e,!1,!1,!0):n===pe.TIME_MONTH_MIN?(null!=t&&t.getMonth()==e.getMonth()||(r=this._formatDate(e,!1,!0,!1)),null!=t&&t.getYear()==e.getYear()||(s=this._formatDate(e,!1,!1,!0))):n===pe.TIME_DAY?i?r=this._formatDate(e,!0,!0,!0):(null!=t&&t.getDate()==e.getDate()||(r=this._formatDate(e,!0,!1,!1)),null==t||t.getYear()!=e.getYear()?s=this._formatDate(e,!1,!0,!0):t.getMonth()!=e.getMonth()&&(s=this._formatDate(e,!1,!0,!1))):(n===pe.TIME_HOUR?null!=t&&t.getHours()==e.getHours()||(r=this._formatTime(e,!1,!1)):n===pe.TIME_MINUTE?null!=t&&t.getMinutes()==e.getMinutes()||(r=this._formatTime(e,!0,!1)):null!=t&&t.getSeconds()==e.getSeconds()||(r=this._formatTime(e,!0,!0)),a?null!=t&&t.getDate()==e.getDate()||(s=this._formatDate(e,!0,!0,!1)):null==t||t.getYear()!=e.getYear()?s=this._formatDate(e,!0,!0,!0):t.getMonth()!=e.getMonth()?s=this._formatDate(e,!0,!0,!1):t.getDate()!=e.getDate()&&(s=this._formatDate(e,!0,!1,!1))),[r,s])}_formatDate(e,t,i,r){var s,a=e.getFullYear();s=this._monthResources&&this._monthResources.length>=12?this._monthResources[e.getMonth()]:e.toString().split(" ")[1];var n=e.getDate();a+=pe._getYearTrailingCharacters(this._locale),n+=pe._getDayTrailingCharacters(this._locale);for(var o=pe._getDMYOrder(this._locale),l="",h=0;h<o.length;h++)t&&"D"==o[h]?l+=n+" ":i&&"M"==o[h]?l+=s+" ":r&&"Y"==o[h]&&(l+=a+" ");return l.length>0?l.slice(0,l.length-1):l}_formatTime(e,i,r){var s,a=e.getHours(),n=e.getMinutes(),o=e.getSeconds(),l=pe._getAMString(this._locale),h=pe._getPMString(this._locale),g=pe._getAMPMBefore(this._locale),d=""!=l&&""!=h,u="";return t.Agent.isRightToLeft(this.getCtx())&&(u="‏"),d?(a<12?(s=l,0==a&&(a=12)):(s=h,a>12&&(a-=12)),u+=a,(i||0!=n)&&(u+=":"+this._doubleDigit(n))):u+=this._doubleDigit(a)+":"+this._doubleDigit(n),r&&(u+=":"+this._doubleDigit(o)),d?g?s+" "+u:u+" "+s:u}_doubleDigit(e){return e<10?"0"+e:""+e}_getMixedFrequencyStep(){return this._timeRange>=6*pe.TIME_YEAR_MIN?pe.TIME_YEAR_MIN:this._timeRange>=6*pe.TIME_MONTH_MIN?pe.TIME_MONTH_MIN:this._timeRange>=6*pe.TIME_DAY?pe.TIME_DAY:this._timeRange>=pe.TIME_DAY?3*pe.TIME_HOUR:this._timeRange>=6*pe.TIME_HOUR?pe.TIME_HOUR:this._timeRange>=pe.TIME_HOUR?15*pe.TIME_MINUTE:this._timeRange>=30*pe.TIME_MINUTE?5*pe.TIME_MINUTE:this._timeRange>=6*pe.TIME_MINUTE?pe.TIME_MINUTE:this._timeRange>=pe.TIME_MINUTE?15*pe.TIME_SECOND:this._timeRange>=30*pe.TIME_SECOND?5*pe.TIME_SECOND:pe.TIME_SECOND}_generateLabels(e){var i=[],r=[],s=[],a=[],n=[],o=null,l=0,h=0,g=e.getStage(e),d=t.Agent.isRightToLeft(e),u="left"==this.Position||"right"==this.Position,_="off"!=this.Options.zoomAndScroll,c=!0,p=0;u&&"blink"===t.Agent.engine&&(p=.16*this.getTickLabelHeight());var v=[];if(null!=this._step)v=pe._getLabelPos(this.MinValue,this.MaxValue,this._step);else if(this._mixedFrequency)this._step=this._getMixedFrequencyStep(),v=pe._getLabelPos(this.MinValue,this.MaxValue,this._step);else{for(var m=0;m<this._groups.length;m++)this._groups[m]>=this.MinValue&&this._groups[m]<=this.MaxValue&&v.push(this._groups[m]);if(this._step=this._averageInterval,!this._skipGaps){var f;if((v=pe._treatMissingValues(v,this._calculateGranularity())).length>1&&(this._step=(v[v.length-1]-v[0])/(v.length-1)),u)f=t.TextUtils.getTextStringHeight(e,this.Options.tickLabel.style);else{var x=this._formatAxisLabel(new Date(v[0]))[0];f=t.TextUtils.getTextStringWidth(e,x,this.Options.tickLabel.style)}(f+this.GetTickLabelGapSize())*(v.length-1)>Math.abs(this._endCoord-this._startCoord)&&(this._step=this._getMixedFrequencyStep(),v=pe._getLabelPos(this.MinValue,this.MaxValue,this._step))}}0==v.length&&(v=[this.MinValue]);for(m=0;m<v.length;m++){var C=v[m],S=this.getCoordAt(C);if(null!=S){var A=new Date(C),b=this._formatAxisLabel(A,o),y=b[0],M=b[1];if(null!=y?(s.push({text:y,coord:null!=M?S+p:S}),a.push(S),l++):(s.push(null),a.push(null)),i.push(null),_&&c&&(S=this.MinValue?this.getCoordAt(this.MinValue):S),c=!1,null!=M){var D=this.CreateLabel(e,M,S-p);n.push(S),u||(d?D.alignRight():D.alignLeft()),r.push(D),this._isOneLevel=!1,h++}else r.push(null),n.push(null);o=A}}if(l=this._skipLabelsUniform(s,i,g,!1,d),!_&&h>1&&l<1.5*h){i=r,r=null;for(var T=0;T<i.length;T++)null!=i[T]&&i[T].alignCenter();l=this._skipLabelsGreedy(i,this.GetLabelDims(i,g),!1,d)}else 0==(h=this._skipLabelsGreedy(r,this.GetLabelDims(r,g),!0,d))&&(r=null);u&&null!=r&&this._skipVertLabels(i,r,g),this._level1Labels=i,this._level2Labels=r,this._level1Coords=a,this._level2Coords=n}_getLabelOverflow(e,t,i,r){var s=e-(i?r?t:0:.5*t);if(s<this.Options._minOverflowCoord)return Math.floor(s-this.Options._minOverflowCoord);var a=e+(i?r?0:t:.5*t);return a>this.Options._maxOverflowCoord?Math.ceil(a-this.Options._maxOverflowCoord):0}_skipLabelsGreedy(e,t,i,r){if(!t||t.length<=0)return!1;for(var s,a,n,o,l,h="left"==this.Position||"right"==this.Position,g=this.getTickLabelHeight(),d=h?.08*g:.24*g,u=0,_=Math.abs(this._endCoord-this._startCoord),c=0;c<t.length;c++)if(this._level2Overflow.push(0),null!=e[c]){var p=(l=e[c]).getDimensions().w;if(t[c].w>_)e[c]=null;else{var v=this._getLabelOverflow(l.getX(),p,i,r);this._level2Overflow[c]=v,0!=v&&(l.setX(l.getX()-v),t[c].x-=v)}}for(c=0;c<t.length;c++)null!=t[c]&&(h?(n=t[c].y,o=t[c].y+t[c].h):(n=t[c].x,o=t[c].x+t[c].w),null!=s&&null!=a&&pe._isOverlapping(s,a,n,o,d)&&(e[c]=null),null!=e[c]&&(s=n,a=o,u++));return u}_skipLabelsUniform(e,t,i,r){for(var s=[],a=[],n=Math.abs(this._endCoord-this._startCoord),o=0;o<e.length;o++)null!=e[o]&&(s.push(e[o]),a.push(null),this._level1Overflow.push(0));for(var l="left"==this.Position||"right"==this.Position,h=this,g=e=>{if(null==a[e])if(s[e].label=h.CreateLabel(i.getCtx(),s[e].text,s[e].coord),a[e]=s[e].label.getDimensions(i),a[e].w>n)s[e].label=null,a[e].w=0,a[e].h=0;else{var t=h._getLabelOverflow(s[e].coord,a[e].w,!1,r);0!=t&&(s[e].coord-=t,a[e].x-=t,s[e].label.setX(s[e].label.getX()-t),h._level1Overflow[e]=t)}return l?a[e].h:a[e].w},d=(g(0)+this.GetTickLabelGapSize())*(s.length-1),u=n>0?Math.ceil(d/n)-1:0,_=!0;_;){for(o=0;o<s.length;o++)o%(u+1)==0?(g(o),s[o].skipped=!1):s[o].skipped=!0;_=this.IsOverlapping(a,u),u++}var c=0;for(o=0;o<e.length;o++)null==e[o]||e[o].skipped||(t[o]=e[o].label,c++);return c}_skipVertLabels(e,t,i){for(var r=.08*this.getTickLabelHeight(),s=(e,t)=>pe._isOverlapping(e.y,e.y+e.h,t.y,t.y+t.h,r),a=null,n=!1,o=0;o<e.length;o++)if(e[o]&&t[o]){if(e[o].alignTop(),t[o].alignBottom(),a&&s(a,t[o].getDimensions())){n=!0;break}a=e[o].getDimensions()}else if(e[o]||t[o]){var l=e[o]?e[o]:t[o];if(a&&s(a,l.getDimensions())){n=!0;break}a=l.getDimensions()}if(n){var h,g=null,d=null,u=null;for(o=0;o<e.length;o++)t[o]?(e[o]=null,t[o].alignMiddle(),h=t[o].getDimensions(),d&&s(d,h)&&(e[g]=null),u=h):e[o]&&(h=e[o].getDimensions(),u&&s(u,h)?e[o]=null:(d=h,g=o))}}getLabels(e,t){return t&&t>1?null:(this._level1Labels||this._generateLabels(e),1==t?this._level2Labels:this._level1Labels)}getMajorTickCoords(){var e=[];if(this._isOneLevel)for(var t=0;t<this._level1Coords.length;t++)null!=this._level1Coords[t]&&null!=this._level1Labels[t]&&e.push(this._level1Coords[t]);else for(t=1;t<this._level2Coords.length;t++)null!=this._level2Coords[t]&&e.push(this._level2Coords[t]);return e}getMinorTickCoords(){if(this._isOneLevel)return[];for(var e=[],t=0;t<this._level1Coords.length;t++)null!=this._level1Coords[t]&&null!=this._level1Labels[t]&&e.push(this._level1Coords[t]);return e}getUnboundedValAt(e){if(null==e)return null;var t=(e-this._startCoord)/(this._endCoord-this._startCoord);if(this._skipGaps){var i=this._timeToIndex(this.MinValue),r=this._timeToIndex(this.MaxValue);return this._indexToTime(i+t*(r-i))}return this.MinValue+t*(this.MaxValue-this.MinValue)}getUnboundedCoordAt(e){if(null==e)return null;var t;if(this._skipGaps){var i=this._timeToIndex(this.MinValue),r=this._timeToIndex(this.MaxValue);t=(this._timeToIndex(e)-i)/(r-i)}else t=(e-this.MinValue)/(this.MaxValue-this.MinValue);return this._startCoord+t*(this._endCoord-this._startCoord)}linearToActual(e){return null==e?null:this._skipGaps?this._indexToTime(e):e}actualToLinear(e){return null==e?null:this._skipGaps?this._timeToIndex(e):e}_timeToIndex(e){for(var t=this._groups.length,i=0;i<this._groups.length;i++)if(e<=this._groups[i]){t=i;break}var r=t-1,s=void 0!==this._groups[r]?this._groups[r]:this._groups[0]-this._averageInterval;return r+(e-s)/((void 0!==this._groups[t]?this._groups[t]:this._groups[this._groups.length-1]+this._averageInterval)-s)}_indexToTime(e){var t=Math.min(Math.max(Math.ceil(e),0),this._groups.length),i=t-1,r=void 0!==this._groups[i]?this._groups[i]:this._groups[0]-this._averageInterval;return r+(e-i)*((void 0!==this._groups[t]?this._groups[t]:this._groups[this._groups.length-1]+this._averageInterval)-r)}getGroupWidth(){return this._skipGaps?Math.abs(this.getUnboundedCoordAt(this._indexToTime(1))-this.getUnboundedCoordAt(this._indexToTime(0))):Math.abs(this.getUnboundedCoordAt(this.MinValue+this._averageInterval)-this.getUnboundedCoordAt(this.MinValue))}getMinExtent(){return this._skipGaps?1:this._mixedFrequency?Math.min((this.getGlobalMax()-this.getGlobalMin())/8,this._averageInterval):this._averageInterval}getStartOverflow(){return"top"!=this.Position&&"bottom"!=this.Position||!t.Agent.isRightToLeft(this.getCtx())?this.StartOverflow:this.EndOverflow}getEndOverflow(){return"top"!=this.Position&&"bottom"!=this.Position||!t.Agent.isRightToLeft(this.getCtx())?this.EndOverflow:this.StartOverflow}static _getAMString(e){var t=e.substring(0,2);if("en-au"==e||"en-ie"==e||"en-ph"==e)return"am";if("en-gb"==e)return"";switch(t){case"en":return"AM";case"ar":return"ص";case"el":return"πμ";case"ko":return"오전";case"zh":return"上午";default:return""}}static _getPMString(e){var t=e.substring(0,2);if("en-au"==e||"en-ie"==e||"en-ph"==e)return"pm";if("en-gb"==e)return"";switch(t){case"en":return"PM";case"ar":return"م";case"el":return"μμ";case"ko":return"오후";case"zh":return"下午";default:return""}}static _getAMPMBefore(e){var t=e.substring(0,2);return"ko"==t||"zh"==t}static _getDMYOrder(e){var t=e.substring(0,2);return"en-us"==e||"en-ph"==e?"MDY":"fa"==t||"hu"==t||"ja"==t||"ko"==t||"lt"==t||"mn"==t||"zh"==t?"YMD":"DMY"}static _getYearTrailingCharacters(e){return 0==e.indexOf("ja")||0==e.indexOf("zh")?"年":0==e.indexOf("ko")?"년":""}static _getDayTrailingCharacters(e){return 0==e.indexOf("ja")||0==e.indexOf("zh")?"日":0==e.indexOf("ko")?"일":""}static _getLabelPos(e,t,i){var r=new Date(e),s=r.getTimezoneOffset();r.setMonth(0,1),r.setHours(0,0,0,0);var a=60*(s-r.getTimezoneOffset())*1e3,n=r.getTime()+a,o=[];if(i>=pe.TIME_YEAR_MIN&&i<=pe.TIME_YEAR_MAX){for(;n<e;)n=pe._addOneYear(n);for(;n<=t;)o.push(n),n=pe._addOneYear(n)}else if(i>=pe.TIME_MONTH_MIN&&i<=pe.TIME_MONTH_MAX){for(;n<e;)n=pe._addOneMonth(n);for(;n<=t;)o.push(n),n=pe._addOneMonth(n)}else for(n+=Math.ceil((e-n)/i)*i;n<=t;)o.push(n),n+=i;return o}static _addOneYear(e){var t=new Date(e);return t.setFullYear(t.getFullYear()+1),t.getTime()}static _addOneMonth(e){var t=new Date(e);return t.setMonth(t.getMonth()+1),t.getTime()}static _getGCDInterval(e){for(var t=(e,i)=>0===e?i:t(i%e,e),i=e[0],r=1;r<e.length;r++)if(1===(i=t(i,e[r])))return 1;return i}static _calculateGranularInterval(e,t,i){var r,s=e.getTimezoneOffset(),a=t.getTimezoneOffset(),n=t.getTime(),o=1e3*(s-a)*60;return o>0&&t.setTime(n+o),r=i===pe.TIME_YEAR_MIN?t.getFullYear()-e.getFullYear():i===pe.TIME_MONTH_MIN?12*(t.getFullYear()-e.getFullYear())+(t.getMonth()-e.getMonth()):Math.round((t.getTime()-e.getTime())/i),o>0&&t.setTime(n),r}static _treatMissingValues(e,t){var i,r,s=new Set,a=!1,n=e,o=[],l=e.length,h=new Date(e[0]);for(r=1;r<l;r++){var g=new Date(e[r]),d=pe._calculateGranularInterval(h,g,t);h=g,o.push(d),d<=0||(s.add(d),i?d!==i&&(a=!0):i=d)}if(a){var u=pe._getGCDInterval([...s]);for((n=[]).push(e[0]),r=1;r<l;r++){var _=e[r],c=e[r-1];if((d=o[r-1])<=u)n.push(_);else{var p,v=d/u,m=v-1,f=Math.round((_-c)/v);for(p=1;p<=m;p++)c+=f,n.push(c);n.push(_),c=_}}}return n}static _isOverlapping(e,t,i,r,s){return i>=e&&i-s<t||i<e&&r+s>e}}pe.TIME_SECOND=1e3,pe.TIME_MINUTE=60*pe.TIME_SECOND,pe.TIME_HOUR=60*pe.TIME_MINUTE,pe.TIME_DAY=24*pe.TIME_HOUR,pe.TIME_MONTH_MIN=28*pe.TIME_DAY,pe.TIME_MONTH_MAX=31*pe.TIME_DAY,pe.TIME_YEAR_MIN=365*pe.TIME_DAY,pe.TIME_YEAR_MAX=366*pe.TIME_DAY,S.registerConstructor("time",pe);const ve={renderBackgroundObjects:(e,t,i)=>{ve._renderObjects(e,t,i,"back")},renderForegroundObjects:(e,t,i)=>{ve._renderObjects(e,t,i,"front")},_renderObjects:(e,t,i,r)=>{ve._renderObjectsForAxis(e,t,i,r,e.xAxis,d.getAxisRefObjs(e,"x")),ve._renderObjectsForAxis(e,t,i,r,e.yAxis,d.getAxisRefObjs(e,"y")),ve._renderObjectsForAxis(e,t,i,r,e.y2Axis,d.getAxisRefObjs(e,"y2"))},_renderObjectsForAxis:(e,t,i,r,s,a)=>{if(a&&s)for(var n=0;n<a.length;n++){var o=a[n];if(v.isObjRendered(e,o)&&(o&&v.getLocation(o)==r)){var l,h,g=v.getType(o);if("area"==g?l=ve._createReferenceArea(o,e,i,s):"line"==g&&(l=ve._createReferenceLine(o,e,i,s),h=ve._createReferenceLine(o,e,i,s,!0)),null!=l){var d=s==e.yAxis?"yAxis":"y2Axis",u=s==e.xAxis?"xAxis":d,_=new x(e,h?[l,h]:[l],o,n,u);e.registerObject(_),e.getEventManager().associate(l,_),t.addChild(l),h&&t.addChild(h)}}}},_createReferenceArea:(e,i,r,s)=>{var a,n=i.getCtx(),o=s.getPosition(),g="top"==o||"bottom"==o,u="radial"==o,_=v.getColor(i,e),c=v.getLineType(e),p=e.style||e.svgStyle,m=e.className||e.svgClassName;if(null==e.items||s!=i.yAxis&&s!=i.y2Axis){var f=v.getLowVal(e),x=v.getHighVal(e);null!=f&&f!=-1/0||(f=s.getInfo().getGlobalMin()),null!=x&&x!=1/0||(x=s.getInfo().getGlobalMax());var C=ve._getAxisCoord(i,s,f),S=ve._getAxisCoord(i,s,x);if(l.isPolar(i)){var A,b=r.x+r.w/2,y=r.y+r.h/2;if(u)if(w.isGridPolygonal(i)){var M=d.getGroupCount(i),D=t.PolygonUtils.getRegularPolygonPoints(b,y,M,S,0,1),T=t.PolygonUtils.getRegularPolygonPoints(b,y,M,C,0,0);A=t.PathUtils.polyline(D)+t.PathUtils.polyline(T)+t.PathUtils.closePath()}else A=t.PathUtils.moveTo(b,y-S)+t.PathUtils.arcTo(S,S,Math.PI,1,b,y+S)+t.PathUtils.arcTo(S,S,Math.PI,1,b,y-S)+t.PathUtils.moveTo(b,y-C)+t.PathUtils.arcTo(C,C,Math.PI,0,b,y+C)+t.PathUtils.arcTo(C,C,Math.PI,0,b,y-C)+t.PathUtils.closePath();else{var I=i.getRadius(),O=h.polarToCartesian(I,C,r),E=h.polarToCartesian(I,S,r);A=t.PathUtils.moveTo(b,y)+t.PathUtils.lineTo(O.x,O.y)+t.PathUtils.arcTo(I,I,S-C,t.Agent.isRightToLeft(n)?0:1,E.x,E.y)+t.PathUtils.lineTo(E.x,E.y)+t.PathUtils.closePath()}a=new t.Path(n,A)}else{var P;P=g?[C,0,S,0,S,r.h,C,r.h]:[0,C,0,S,r.w,S,r.w,C],a=new t.Polygon(n,P)}a.setSolidFill(_),a.setStyle(p).setClassName(m)}else{var L=e.items,R=[],k=[];if(i.xAxis.isGroupAxis())for(;L.length<d.getGroupCount(i);)L.push(null);for(var B=0;B<L.length;B++){var F=L[B],N=v.getLowVal(F),H=v.getHighVal(F);if(null!=N&&null!=H){var G=s.getUnboundedCoordAt(N),U=s.getUnboundedCoordAt(H),V=i.xAxis.getUnboundedCoordAt(v.getXVal(i,L,B));R.push(new oe(V,U,U)),k.push(new oe(V,G,G))}else R.push(new oe),k.push(new oe)}a=new le(i,!0,r,null,p,m,new t.SolidFill(_),null,c,R,c,k)}return a},_createReferenceLine:(e,i,r,s,a)=>{var n,o=s.getPosition(),l="top"==o||"bottom"==o,g="radial"==o,u="tangential"==o,_=v.getLineWidth(i,e),c=v.getLineType(e),p=v.getColor(i,e),m=e.style||e.svgStyle,f=a?"oj-chart-reference-object-inner-line":e.className||e.svgClassName,x=new t.Stroke(p,1,_,!1,t.Stroke.getDefaultDashProps(e.lineStyle,_)),C=i.getCtx();if(null==e.items||s!=i.yAxis&&s!=i.y2Axis){if(null==e.value)return null;var S=ve._getAxisCoord(i,s,e.value);if(null==S||S==1/0||S==-1/0)return null;a&&(S-=Math.ceil(_/2));var A=r.x+r.w/2,b=r.y+r.h/2;if(g){if(w.isGridPolygonal(i)){var y=t.PolygonUtils.getRegularPolygonPoints(A,b,d.getGroupCount(i),S,0);n=new t.Polygon(C,y)}else n=new t.Circle(C,A,b,S);n.setFill(null)}else if(u){var M=h.polarToCartesian(i.getRadius(),S,r);n=new t.Line(C,A,b,M.x,M.y)}else(n=l?new t.Line(C,S,0,S,r.h):new t.Line(C,0,S,r.w,S)).setPixelHinting(!0);n.setStroke(x),n.setStyle(m).setClassName(f)}else{var D=e.items;if(i.xAxis.isGroupAxis())for(;D.length<d.getGroupCount(i);)D.push(null);for(var T=[],I=0;I<D.length;I++){var O=D[I],E=null;if(null!=O&&("object"!=typeof O?E=O:null!=O.value&&(E=O.value)),null!=E){var P=s.getUnboundedCoordAt(E)-(a?_/2:0),L=i.xAxis.getUnboundedCoordAt(v.getXVal(i,D,I));T.push(new oe(L,P,P))}else T.push(new oe)}n=new le(i,!1,r,null,m,f,null,x,c,T)}return n},_getAxisCoord:(e,t,i)=>{if(t.isGroupAxis()){var r=d.getGroupIdx(e,i);if(r>=0)return t.getUnboundedCoordAt(r)}return isNaN(i)?null:t.getUnboundedCoordAt(i)}},me={_MIN_BUBBLE_SIZE:6,_MAX_BUBBLE_SIZE_RATIO:.5,calcBubbleSizes:(e,i)=>{for(var r,s,a=w.getMinMaxVal(e,"z"),n=a.min,o=a.max,h=me._MIN_BUBBLE_SIZE,g=me._MAX_BUBBLE_SIZE_RATIO*Math.min(i.w,i.h),u=d.getSeriesCount(e),_="withoutRescale"==O.getHideAndShowBehavior(e),c=e.getOptionsCache(),p=0;p<u;p++)if(_||d.isSeriesRendered(e,p))for(var v=d.getSeriesItem(e,p),m=v.items?v.items.length:0,f=0;f<m;f++){var x=v.items[f];if(x){var C=t.LayoutUtils.getBubbleSize(x.z,n,o,h,g);c.putToCachedMap2D("bubbleSizeCache",p,f,C)}}l.isPolar(e)?(r=1/0,s=e.getRadius()):(r=i.w-2.4*w.getTickLabelHeight(e,"y"),s=i.h-1.6*w.getTickLabelHeight(e,"x")),r-=.5*g,s-=.5*g;var S=e.getCache(),A=me._getAxisValueRange(e,"x");S.putToCache("_xAxisBubbleRatio",A/r);var b=me._getAxisValueRange(e,"y");S.putToCache("_yAxisBubbleRatio",b/s)},_getAxisValueRange:(e,i)=>{var r=e.getOptions()[i+"Axis"],s=w.isLog(e,i),a=!s&&"zero"==w.getBaselineScaling(e,i),n=w.getMinMaxVal(e,i,!0),o=r.min;null==o&&(o=a?Math.min(0,n.min):n.min);var l=r.max;return null==l&&(l=a?Math.max(0,n.max):n.max),s&&l>0&&o>0?l==o?6:t.Math.log10(l/o):l==o?60:l-o},sortMarkers:e=>{e.sort(me._compareSize)},sortMarkerInfos:e=>{e.sort(me._compareInfoSize)},_compareSize:(e,t)=>t.getSize()-e.getSize(),_compareInfoSize:(e,t)=>t.size-e.size,checkPixelMap:(e,t,i,r)=>{var s=r/2,a=Math.max(Math.floor(t-s),0),n=Math.max(Math.floor(i-s),0),o=Math.max(Math.ceil(t+s),0),l=Math.max(Math.ceil(i+s),0);return e.isObscured(a,n,o,l)},updatePixelMap:(e,t,i,r,s)=>{var a=.4*r,n=Math.max(Math.round(t-a),0),o=Math.max(Math.round(t+a),0),l=Math.max(Math.round(i-a),0),h=Math.max(Math.round(i+a),0);e.obscure(n,l,o,h,s)}},fe={_MIN_TOUCH_MARKER_SIZE:16,_MIN_CHARS_DATA_LABEL:3,FILTER_THRESHOLD_SCATTER_BUBBLE:1e4,render:(e,t,i)=>{"off"==e.getOptions().plotArea.rendered?fe._renderAxisLines(e,t,i):i.w>0&&i.h>0&&(e._currentMarkers=[],e._currentAreas=[],fe._renderBackgroundObjs(e,t,i),fe._renderTicks(e,t,i),fe._renderForegroundObjs(e,t,i))},_renderBackgroundObjs:(e,i,r)=>{var s=e.getOptions(),a=fe._getBackgroundShape(e,r),n=c.getBackgroundColor(e);if(n?a.setSolidFill(n):a.setInvisibleFill(),i.addChild(a),e.getCache().putToCache("plotAreaBackground",a),O.isPlotAreaDraggable(e)&&a.setClassName("oj-draggable"),s.xAxis.referenceObjects||s.yAxis.referenceObjects||s.y2Axis.referenceObjects){var o=fe.createClippedGroup(e,i,r);ve.renderBackgroundObjects(e,o,r)}if(l.isBLAC(e)){var h=new t.Container(e.getCtx());i.addChild(h),e.__setAreaContainer(h),d.hasAreaSeries(e)&&fe._renderAreas(e,h,r,!1)}},_getBackgroundShape:(e,i)=>{var r,s=e.getCtx();if(l.isPolar(e)){var a=i.x+i.w/2,n=i.y+i.h/2;if(w.isGridPolygonal(e)){var o=t.PolygonUtils.getRegularPolygonPoints(a,n,d.getGroupCount(e),e.getRadius(),0);r=new t.Polygon(s,o)}else r=new t.Circle(s,a,n,e.getRadius())}else r=new t.Rect(s,i.x,i.y,i.w,i.h);return r},_renderTicks:(e,t,i)=>{e.xAxis&&w.isMinorTickRendered(e,"x")&&fe._renderMinorTicks(e,t,e.xAxis,i),e.yAxis&&w.isMinorTickRendered(e,"y")&&fe._renderMinorTicks(e,t,e.yAxis,i),e.y2Axis&&w.isMinorTickRendered(e,"y2")&&fe._renderMinorTicks(e,t,e.y2Axis,i),e.xAxis&&w.isMajorTickRendered(e,"x")&&fe._renderMajorTicks(e,t,e.xAxis,i),e.yAxis&&w.isMajorTickRendered(e,"y")&&fe._renderMajorTicks(e,t,e.yAxis,i),e.y2Axis&&w.isMajorTickRendered(e,"y2")&&fe._renderMajorTicks(e,t,e.y2Axis,i)},_renderAxisLines:(e,t,i)=>{e.xAxis&&e.yAxis&&w.isAxisLineRendered(e,"x")&&fe._renderAxisLine(e,t,e.xAxis,e.yAxis,i),e.xAxis&&e.y2Axis&&w.isAxisLineRendered(e,"x")&&(e.yAxis&&!d.isSplitDualY(e)||fe._renderAxisLine(e,t,e.xAxis,e.y2Axis,i)),e.yAxis&&e.xAxis&&w.isAxisLineRendered(e,"y")&&fe._renderAxisLine(e,t,e.yAxis,e.xAxis,i),e.y2Axis&&e.xAxis&&w.isAxisLineRendered(e,"y2")&&fe._renderAxisLine(e,t,e.y2Axis,e.xAxis,i)},_renderMajorTicks:(e,t,i,r)=>{fe._renderGridlines(e,t,i.getOptions().majorTick,i.getPosition(),i.getMajorTickCoords(),i.getBaselineCoord(),r)},_renderMinorTicks:(e,t,i,r)=>{fe._renderGridlines(e,t,i.getOptions().minorTick,i.getPosition(),i.getMinorTickCoords(),null,r)},_renderAxisLine:(e,t,i,r,s)=>{var a=i.getOptions(),n=a.position,o="bottom"==n||"right"==n||"tangential"==n?r.getMaxCoord():r.getMinCoord();fe._renderGridlines(e,t,a.axisLine,r.getPosition(),[o],null,s)},_renderGridlines:(e,i,r,s,a,n,o)=>{var l=r.lineColor,h=r.lineStyle,g=new t.Stroke(l,1,r.lineWidth,!1,t.Stroke.getDefaultDashProps(h,r.lineWidth)),d=g.getColor();"inherit"!=r.baselineColor&&(d="auto"==r.baselineColor?t.ColorUtils.getDarker(l,.6):r.baselineColor);for(var u=null!=r.baselineWidth?r.baselineWidth:r.lineWidth,_=r.baselineStyle?r.baselineStyle:r.lineStyle,c=new t.Stroke(d,1,u,!1,t.Stroke.getDefaultDashProps(_,u)),p="",v=0;v<a.length;v++){var m=null!=n&&a[v]==n;"radial"==s||"tangential"==s||m?fe._renderGridline(e,i,s,a[v],m?c:g,o):p+="top"==s||"bottom"==s?t.PathUtils.moveTo(a[v],o.y)+t.PathUtils.verticalLineTo(o.y+o.h):t.PathUtils.moveTo(o.x,a[v])+t.PathUtils.horizontalLineTo(o.x+o.w)}if(""!=p){var f=new t.Path(e.getCtx(),p);(!t.Agent.isTouchDevice()||t.Agent.getDevicePixelRatio()>1)&&f.setPixelHinting(!0),f.setStroke(g),f.setMouseEnabled(!1),i.addChild(f)}},_renderGridline:(e,i,r,s,a,n)=>{var o,l=i.getCtx(),h=!t.Agent.isTouchDevice()||t.Agent.getDevicePixelRatio()>1;if("radial"==r){if(w.isGridPolygonal(e)){var g=t.PolygonUtils.getRegularPolygonPoints(0,0,d.getGroupCount(e),s,0);o=new t.Polygon(l,g)}else o=new t.Circle(l,0,0,s);o.setInvisibleFill(),o.setTranslate(n.x+n.w/2,n.y+n.h/2)}else if("tangential"==r){o=new t.Line(l,0,0,e.getRadius()*Math.sin(s),-e.getRadius()*Math.cos(s));var u=s%(Math.PI/2);(u<.001||u>Math.PI/2-.001)&&h&&o.setPixelHinting(!0),o.setTranslate(n.x+n.w/2,n.y+n.h/2)}else o="top"==r||"bottom"==r?new t.Line(l,s,n.y,s,n.y+n.h):new t.Line(l,n.x,s,n.x+n.w,s),h&&o.setPixelHinting(!0);o.setStroke(a),o.setMouseEnabled(!1),i.addChild(o)},_renderForegroundObjs:(e,t,i)=>{var r=e.getOptions(),s=fe.createClippedGroup(e,t,i);fe._renderAxisLines(e,t,i);var a=r.plotArea.borderColor,n=r.plotArea.borderWidth;if(a&&0!=n){var o=fe._getBackgroundShape(e,i);o.setInvisibleFill(),o.setSolidStroke(a,null,n),o.setMouseEnabled(!1),t.addChild(o)}l.isBLAC(e)?(d.hasLineWithAreaSeries(e)&&fe._renderAreas(e,t,i,!0),d.hasBarSeries(e)&&fe._renderBars(e,s,i),d.hasCandlestickSeries(e)&&fe._renderStock(e,s),d.hasBoxPlotSeries(e)&&fe._renderBoxPlot(e,s,i),d.hasLineSeries(e)&&fe._renderLines(e,t,s,i)):l.isScatterBubble(e)&&fe._renderScatterBubble(e,t,s,!0,i),(r.xAxis.referenceObjects||r.yAxis.referenceObjects||r.y2Axis.referenceObjects)&&(s=fe.createClippedGroup(e,t,i),ve.renderForegroundObjects(e,s,i));var h=d.getInitialSelection(e);F.setInitialSelection(e,h),e.highlight(d.getHighlightedCategories(e))},_renderDataLabel:(e,i,r,s,a,n,o,h,g,u)=>{if(!l.isOverview(e)){var _="bar"==d.getSeriesType(e,s),p=l.isHorizontal(e),v={width:p?r.w:u,height:p?u:r.h},m=e.getOptions(),f=m.styleDefaults,x=null!=e.y2Axis,C="on"===m.legend.rendered;_&&e.getOptionsCache().putToCachedMap2D("barDims",s,a,v);var S=c.getDataLabel(e,s,a,n,h,g);if(null!=S){var A=R.getDataLabelPos(e,s,a,n,h,g);if("none"!=A){var b=new t.OutputText(e.getCtx(),S,0,0);b.setMouseEnabled(!1);var y=g?f.stackLabelStyle:c.getDataLabelStyle(e,s,a,n,o,A,h);b.setCSSStyle(y),b.setY(r.y+r.h/2),b.setX(r.x+r.w/2),b.alignCenter(),b.alignMiddle();var M=b.getDimensions(),D=e.getCache().getFromCache("plotAreaDims");D||(D=e.getPlotArea().getDimensions(),e.getCache().putToCache("plotAreaDims",D));var T=(e,t,i,r)=>{var s={x:null,y:null},a=r&&r.xAxis&&("left"==e||"right"==e),n=r&&r.top&&("left"==e||"right"==e),o=r&&((x||!C)&&r.y2Axis||r.legend)&&("top"==e||"bottom"==e),l=r&&r.yAxis&&("top"==e||"bottom"==e);"left"==e?s.x=t.x-i.w/2-c.MARKER_DATA_LABEL_GAP:"right"==e?s.x=t.x+t.w+i.w/2+c.MARKER_DATA_LABEL_GAP:"top"==e?s.y=t.y-i.h/2:"bottom"==e&&(s.y=t.y+t.h+i.h/2+c.MARKER_DATA_LABEL_GAP/2);var h=2*c.MARKER_DATA_LABEL_GAP;return o?s.x=D.x+D.w-i.w/2-h:l?s.x=i.w/2+h:a?s.y=D.y+D.h-i.h/2-h:n&&(s.y=i.h/2+h),s},I=f.dataLabelCollision,O=T(A,r,M);if("fitInBounds"===I){var E=c.getDataLabelCollisions(e,O,M,D,p),P=c.adjustDataLabelPos(A,E,x);P!=A&&l.isBubble(e)&&(y=g?f.stackLabelStyle:c.getDataLabelStyle(e,s,a,n,o,P,h),b.setCSSStyle(y)),O=T(A=P,r,M,E)}if(null!=O.x||null!=O.y)null!=O.x&&b.setX(O.x),null!=O.y&&b.setY(O.y);else{if(_){if(M.w>v.width||M.h>v.height)return;"inLeft"==A?b.setX(r.x+M.w/2+c.MARKER_DATA_LABEL_GAP):"inRight"==A?b.setX(r.x+r.w-M.w/2-c.MARKER_DATA_LABEL_GAP):"inTop"==A?b.setY(r.y+M.h/2+c.MARKER_DATA_LABEL_GAP):"inBottom"==A&&b.setY(r.y+r.h-M.h/2-c.MARKER_DATA_LABEL_GAP/2)}else if(l.isBubble(e)){r.x+=c.MARKER_DATA_LABEL_GAP,r.y+=c.MARKER_DATA_LABEL_GAP,r.h-=2*c.MARKER_DATA_LABEL_GAP,r.w-=2*c.MARKER_DATA_LABEL_GAP;var L=t.TextUtils.getOptimalFontSize(b.getCtx(),b.getTextString(),b.getCSSStyle(),r);if(b.setFontSize(L),!t.TextUtils.fitText(b,r.w,r.h,i,fe._MIN_CHARS_DATA_LABEL))return}if(null!=c.getPattern(e,s,a)){var w=.15*(M=b.getDimensions()).h,k=t.PathUtils.roundedRectangle(M.x-w,M.y,M.w+2*w,M.h,2,2,2,2),B=new t.Path(e.getCtx(),k);B.setSolidFill("#FFFFFF",.9),i.addChild(B)}}if(l.isBar(e)){var F,N=b.getDimensions(),H=!1;if("left"==A&&N.x<0)H=!0,F=r.x-c.MARKER_DATA_LABEL_GAP;else if("right"==A&&N.x+N.w>D.w+c.MARKER_DATA_LABEL_GAP)H=!0,F=D.w-r.w-c.MARKER_DATA_LABEL_GAP;else{if("top"==A&&N.y<0)return;if("bottom"==A&&N.y+N.h>D.y+D.h+c.MARKER_DATA_LABEL_GAP)return}if(H){if(!isNaN(S))return;if(!t.TextUtils.fitText(b,F,r.h,i,1))return;M=b.getDimensions(),"left"==A?b.setX(r.x-M.w/2-c.MARKER_DATA_LABEL_GAP):"right"==A&&b.setX(r.x+r.w+M.w/2+c.MARKER_DATA_LABEL_GAP)}}c.optimizeMarkerStroke(e)&&b.setSolidStroke("none"),i.addChild(b),e.addDataLabel(b)}}}},_renderDataLabelForMarker:(e,i,r)=>{var s=e.getEventManager().getLogicalObject(r);if(s){var a=s.getSeriesIndex(),n=s.getGroupIndex(),o=s.getNestedDataItemIndex();if(r instanceof t.SimpleMarker){var l=new t.Rectangle(r.getCx()-r.getWidth()/2,r.getCy()-r.getHeight()/2,r.getWidth(),r.getHeight());fe._renderDataLabel(e,i,l,a,n,o,r.getDataColor())}else r instanceof de&&(fe._renderDataLabel(e,i,r.getBoundingBox1(),a,n,o,r.getDataColor(),"low"),fe._renderDataLabel(e,i,r.getBoundingBox2(),a,n,o,r.getDataColor(),"high"))}},_renderScatterBubble:(e,i,r,s,a)=>{var n,o=fe._filterScatterBubble(e,s),h=d.getSeriesCount(e);for(n=0;n<h;n++)"none"!=c.getLineType(e,n)&&fe._renderLinesForSeries(e,r,n,a);var g=c.getMarkerBorderColor(e),u=c.getBorderWidth(e),_=new t.Stroke(g,1,u),p=[];if(o)for(var v=c.optimizeMarkerStroke(e),m=v?_.getColor():null,f=v?_.getWidth():null,x=0;x<o.length;x++){var C=o[x],S=fe._createMarker(e,C,m,f);p.push(S)}else{for(n=0;n<h;n++){var A=fe._getMarkersForSeries(e,n,a,_);p=p.concat(A)}s&&me.sortMarkers(p)}l.isBubble(e)?fe._addMarkersToContainer(e,r,p,_):fe._addMarkersToContainer(e,i,p,_)},_renderMarkersForSeries:(e,i,r,s)=>{var a,n=c.getMarkerBorderColor(e,r),o=c.getBorderWidth(e,r),l=new t.Stroke(n,1,o);a=d.isRangeSeries(e,r)?fe._getRangeMarkersForSeries(e,r,s):fe._getMarkersForSeries(e,r,s,l),fe._addMarkersToContainer(e,i,a,l)},_addMarkersToContainer:(e,i,r,s)=>{var a=i,n=c.optimizeMarkerStroke(e),o=c.optimizeMarkerFill(e);(n||o)&&(a=new t.Container(e.getCtx()),n?a.setStroke(s):a.setInvisibleFill(),i.addChild(a));for(var l=0;l<r.length;l++)a.addChild(r[l]),fe._renderDataLabelForMarker(e,a,r[l]);e._currentMarkers.push(r)},_getMarkerInfo:(e,i,r,s,a)=>{var n=e.getOptions(),o=d.getVal(e,i,r,s);if(null==o||isNaN(o))return null;if(d.isDataItemFiltered(e,i,r))return null;var h=d.getGroupCount(e),g=c.isMarkerDisplayed(e,i,r,s);if(!g&&(null==s||s<0)){var u=h-1,_=l.isPolar(e),p=_&&u>0&&0==r?u:r-1,v=_&&u>0&&r==u?0:r+1,m=d.getVal(e,i,p),f=d.getVal(e,i,v);null!=m&&!isNaN(m)||null!=f&&!isNaN(f)||(g=!0)}if(!g&&(l.isSpark(e)||(n._duringZoomAndScroll||l.isOverview(e))&&!d.isDataSelected(e,i,r,s)))return null;if(!d.isDataItemRendered(e,i,r,s))return!1;var x=!0,C=d.getMarkerPos(e,i,r,s,a),S=c.getMarkerSize(e,i,r,s);return a&&C&&S&&(x=a.intersects(new t.Rectangle(C.x-S/2,C.y-S/2,S,S))),C&&x?{seriesIndex:i,groupIndex:r,itemIndex:s,x:C.x,y:C.y,size:S,markerDisplayed:g}:null},_getScatterBubbleMarkerInfo:(e,t,i)=>{if(!d.isDataItemRendered(e,t,i))return!1;var r=d.getScatterBubbleMarkerPos(e,t,i);if(!r)return null;var s=c.getMarkerSize(e,t,i);return s?{seriesIndex:t,groupIndex:i,x:r.x,y:r.y,size:s}:null},_getMarkersForSeries:(e,t,i,r)=>{if(!d.isSeriesRendered(e,t))return[];for(var s=c.optimizeMarkerStroke(e),a=s?r.getColor():null,n=s?r.getWidth():null,o=[],l=d.getGroupCount(e),h=0;h<l;h++){var g=fe._getMarkerInfo(e,t,h,null,i);if(g){var u=fe._createMarker(e,g,a,n);null!=u&&o.push(u)}}return o},_createMarker:(e,i,r,s)=>{var a,n=t.Agent.isTouchDevice(),o=e.getCtx(),h=c.optimizeMarkerStroke(e),g=c.optimizeMarkerFill(e),d=i.seriesIndex,u=i.groupIndex,_=i.itemIndex,p=c.getMarkerColor(e,d,u,_),v=c.getMarkerShape(e,d,u,_),m=i.markerDisplayed;if(null==m&&(m=c.isMarkerDisplayed(e,d,u,_)),m){var x=c.getImageSource(e,d,u,_,"source");if(x){var C=c.getImageSource(e,d,u,_,"sourceSelected"),S=c.getImageSource(e,d,u,_,"sourceHover"),A=c.getImageSource(e,d,u,_,"sourceHoverSelected");a=new t.ImageMarker(o,i.x,i.y,i.size,i.size,null,x,C,S,A),c.isSelectable(e,d,u)&&a.setCursor(t.SelectionEffectUtils.getSelectingCursor())}else{(a=new t.SimpleMarker(o,v,i.x,i.y,i.size,i.size,null,null,!0)).setFill(k.getMarkerFill(e,d,u,_));var b=c.getBorderColor(e,d,u,_),y=c.getDefaultMarkerBorderColor(e,d,u,_),M=c.getUserBorderWidth(e,d,u,_),D=c.getDefaultMarkerBorderWidth(e,d,u,_),T=b||y,I=null!==M?M:D;if(T===r&&I===s||a.setSolidStroke(T,null,I),a.setDataColor(p,!0),"redwood"===e.getCtx().getThemeBehavior())l.isBubble(e)&&a.addClassName("oj-dvt-bubble-marker"),b||l.isBubble(e)||a.addClassName("oj-dvt-default-border-color"),null==M&&a.addClassName("oj-dvt-default-border-width"),c.isSelectable(e,d,u)&&(a.setCursor(t.SelectionEffectUtils.getSelectingCursor()),l.isBubble(e)?a.setFeedbackClassName("oj-dvt-selectable"):a.setFeedbackClassName("oj-dvt-selectable-marker"));else{c.isSelectable(e,d,u)&&a.setCursor(t.SelectionEffectUtils.getSelectingCursor());var O=t.SelectionEffectUtils.getHoverBorderColor(p),E=c.getSelectedInnerColor(e),P=c.getSelectedOuterColor(e);a.setHoverStroke(new t.Stroke(E,1,1),new t.Stroke(O,1,3.5)),a.setSelectedStroke(new t.Stroke(E,1,1.5),new t.Stroke(P,1,4.5)),a.setSelectedHoverStroke(new t.Stroke(E,1,1.5),new t.Stroke(O,1,4.5))}a.addClassName(c.getMarkerClassName(e,d,u,_)),a.setStyle(c.getMarkerStyle(e,d,u,_))}n&&i.size<fe._MIN_TOUCH_MARKER_SIZE&&fe._addMarkerHitArea(a,i.x,i.y,h)}else c.isSelectable(e,d,u)?((a=new he(o,v,i.x,i.y,i.size,h)).setCursor(t.SelectionEffectUtils.getSelectingCursor()),n&&fe._addMarkerHitArea(a,i.x,i.y,h)):(n&&(i.size=fe._MIN_TOUCH_MARKER_SIZE),a=new he(o,t.SimpleMarker.SQUARE,i.x,i.y,i.size,h)),g||a.setInvisibleFill(),a.setDataColor(p);return f.associate(a,e,d,u,_,i),a},_addMarkerHitArea:(e,i,r,s)=>{var a=new t.Rect(e.getCtx(),i-fe._MIN_TOUCH_MARKER_SIZE/2,r-fe._MIN_TOUCH_MARKER_SIZE/2,fe._MIN_TOUCH_MARKER_SIZE,fe._MIN_TOUCH_MARKER_SIZE);s&&a.setSolidStroke("none"),a.setInvisibleFill(),e.addChild(a)},_getRangeMarkersForSeries:(e,i,r)=>{if(!d.isSeriesRendered(e,i))return[];for(var s=t.Agent.isTouchDevice(),a=e.getCtx(),n=e.xAxis,o=d.isAssignedToY2(e,i)?e.y2Axis:e.yAxis,g=e.getOptions(),u=d.getGroupCount(e),_=[],p=0;p<u;p++)if(!d.isDataItemFiltered(e,i,p)&&d.isDataItemRendered(e,i,p)){var v=n.getCoordAt(d.getXVal(e,i,p)),m=o.getUnboundedCoordAt(d.getLowVal(e,i,p)),x=o.getUnboundedCoordAt(d.getHighVal(e,i,p));if(null!=v&&null!=m&&null!=x){var C=c.isMarkerDisplayed(e,i,p);if(!C){var S=u-1,A=l.isPolar(e),b=A&&S>0&&0==p?S:p-1,y=A&&S>0&&p==S?0:p+1,M=d.getLowVal(e,i,b),D=d.getHighVal(e,i,b),T=d.getLowVal(e,i,y),I=d.getHighVal(e,i,b);null==M&&null==D&&null==T&&null==I&&(C=!0)}if(!(g._duringZoomAndScroll||l.isOverview(e)||l.isSpark(e))||C||d.isDataSelected(e,i,p)){var O=h.convertAxisCoord(e,new t.Point(v,m),r),E=h.convertAxisCoord(e,new t.Point(v,x),r),P=new t.Point((O.x+E.x)/2,(O.y+E.y)/2),L=c.getMarkerSize(e,i,p),w=new de(a,O.x,O.y,E.x,E.y,L,!C),R=k.getMarkerFill(e,i,p),B=c.getMarkerBorderColor(e,i,p),F=c.getBorderWidth(e,i,p),N=new t.Stroke(B,1,F),H=c.getMarkerColor(e,i,p),G=c.getSelectedInnerColor(e),U=c.getSelectedOuterColor(e);w.setStyleProperties(R,N,H,G,U),c.isSelectable(e,i,p)&&w.setCursor(t.SelectionEffectUtils.getSelectingCursor());var V=new t.Line(a,O.x,O.y,E.x,E.y);V.setSolidStroke("rgba(0,0,0,0)",null,s?Math.max(L,fe._MIN_TOUCH_MARKER_SIZE):L),w.addChild(V),_.push(w),f.associate(w,e,i,p,null,P)}}}return _},_renderBars:(e,i,r)=>{var s=l.isHorizontal(e),a=l.isPolar(e),n=l.isStock(e),o="pixel"==c.getBarSpacing(e),h=t.Agent.isRightToLeft(e.getCtx()),g=c.isStackLabelRendered(e),u=d.isStacked(e);d.getSeriesCount(e)<2&&g&&(u=!0);for(var _=c.getSelectedInnerColor(e),p=c.getSelectedOuterColor(e),v=e.getOptions()._duringZoomAndScroll,m=c.getGroupWidth(e),x={},C=0;C<d.getSeriesCount(e);C++)if("bar"==d.getSeriesType(e,C)){fe._filterPointsForSeries(e,C);for(var S="",A=e.getOptionsCache().getFromCachedMap("itemStyleSet",C),b=d.getStackCategory(e,C)||"",y=d.isAssignedToY2(e,C),M=w.getViewportMinMaxGroupIdx(e,C),D=M.min-1;D<=M.max+1;D++)if(!d.isDataItemFiltered(e,C,D)&&d.isDataItemRendered(e,C,D)&&0!=d.getZVal(e,C,D)){var T=R.getBarInfo(e,C,D,r);if(null!=T){var I=T.yCoord,O=T.baseCoord,E=T.axisCoord,P=T.x1,L=T.x2,B=T.barWidth;if(u){var F=""+D+b+y+(d.getVal(e,C,D)<0);if(Math.abs(O-I)<.5&&Math.abs(I-x[F])<.5&&!d.isOutermostBar(e,C,D))continue;x[F]&&(O=x[F]),x[F]=I}var N,H=!1;if(Math.abs(I-O)<1&&(d.isRangeSeries(e,C)?I--:u&&!d.isOutermostBar(e,C,D)||(H=!0,I=I>O||s&&!h&&I==O?O+3:O-3)),a)N=new ge(e,E,O,I,P,L,r);else{var G=v&&m<5&&!A;if(N=new se(e,E,O,I,P,L,G),G){var U=N.getBoundingBox();S+=t.PathUtils.moveTo(U.x,U.y)+t.PathUtils.horizontalLineTo(U.x+U.w)+t.PathUtils.verticalLineTo(U.y+U.h)+t.PathUtils.horizontalLineTo(U.x)+t.PathUtils.closePath();continue}}i.addChild(N),c.isSelectable(e,C,D)&&N.setCursor(t.SelectionEffectUtils.getSelectingCursor());var V,Y=null;if(H)V=t.SolidFill.invisibleFill();else{V=k.getBarFill(e,C,D,B);var W=c.getBorderColor(e,C,D),j=c.getBorderWidth(e,C,D);W&&(Y=new t.Stroke(W,1,j))}var z=c.getColor(e,C,D),X=c.getClassName(e,C,D),Z=c.getStyle(e,C,D);N.setStyleProperties(V,Y,z,_,p,X,Z),o&&N.setPixelHinting(!0),f.associate(N,e,C,D,null,T.dataPos),d.isRangeSeries(e,C)?(fe._renderDataLabel(e,i,N.getBoundingBox(),C,D,null,z,"low",!1,N.getOriginalBarSize()),fe._renderDataLabel(e,i,N.getBoundingBox(),C,D,null,z,"high",!1,N.getOriginalBarSize())):fe._renderDataLabel(e,i,N.getBoundingBox(),C,D,null,z,null,!1,N.getOriginalBarSize());var K=[];K.push(N),n&&0!=C||e._currentMarkers.push(K),g&&d.isOutermostBar(e,C,D)&&fe._renderDataLabel(e,i,N.getBoundingBox(),C,D,null,null,null,!0,N.getOriginalBarSize())}}if(S){var q=new t.Path(e.getCtx(),S),Q=c.getColor(e,C);q.setSolidFill(Q);var J=c.getBorderColor(e,C);if(J){var $=c.getBorderWidth(e,C);q.setSolidStroke(J,null,$)}var ee=c.getClassName(e,C),te=c.getStyle(e,C);q.setClassName(ee).setStyle(te),o&&q.setPixelHinting(!0),i.addChild(q)}}},_renderStock:(e,i)=>{var r=e.getOptions(),s=e.xAxis,a=e.yAxis;if("candlestick"==d.getSeriesType(e,0))for(var n=w.getViewportMinMaxGroupIdx(e,0),o=n.min-1;o<=n.max+1;o++)if(d.isDataItemRendered(e,0,o)){var l=d.getDataItem(e,0,o);if(l){var h=l.open,g=l.close,u=l.low,_=l.high,p=null!=u&&null!=_;if(null!=h&&null!=g){var v,m=d.getXVal(e,0,o),x=s.getUnboundedCoordAt(m),C=c.getBarWidth(e,0,o),S=a.getBoundedCoordAt(h),A=a.getBoundedCoordAt(g),b=null;p&&(v=a.getBoundedCoordAt(u),b=a.getBoundedCoordAt(_));var y=new ne(e.getCtx(),x,C,S,A,v,b);i.addChild(y),c.isSelectable(e,0,o)&&y.setCursor(t.SelectionEffectUtils.getSelectingCursor());var M=k.getBarFill(e,0,o,C),D=null,T=c.getBorderColor(e,0,o),I=c.getBorderWidth(e,0,o);T?D=new t.Stroke(T,1,I):M instanceof t.PatternFill&&(D=new t.Stroke(M.getColor(),1,I));var O=c.getColor(e,0,o),E=c.getSelectedInnerColor(e),P=c.getSelectedOuterColor(e),L=r.styleDefaults.stockRangeColor;y.setChangeStyle(M,D,O,E,P),y.setRangeStyle(new t.SolidFill(L),D,L,P);var R=new t.Point(x,(S+A)/2);f.associate(y,e,0,o,null,R);var B=[];B.push(y._changeShape),e._currentMarkers.push(B)}}}},_renderBoxPlot:(e,i,r)=>{for(var s=e.xAxis,a=0;a<d.getSeriesCount(e);a++)for(var n=w.getViewportMinMaxGroupIdx(e,a),o=n.min-1;o<=n.max+1;o++)if(d.isDataItemRendered(e,a,o)&&"boxPlot"==d.getSeriesType(e,a)){var g=d.getDataItem(e,a,o);if(g){var u=g.low,_=g.q1,p=g.q2,v=g.q3,m=g.high;if(null!=u&&null!=_&&null!=p&&null!=v&&null!=m){var x=c.getBarWidth(e,a,o),C=c.getBarCategoryOffsetMap(e,o),S=d.isAssignedToY2(e,a),A=d.getStackCategory(e,a),b=C[S?"y2":"y"][A]+x/2;t.Agent.isRightToLeft(e.getCtx())&&l.isVertical(e)&&(b*=-1);var y=d.getXVal(e,a,o),M=s.getUnboundedCoordAt(y)+b,D=S?e.y2Axis:e.yAxis,T=D.getBoundedCoordAt(u),I=D.getBoundedCoordAt(_),O=D.getBoundedCoordAt(p),E=D.getBoundedCoordAt(v),P=D.getBoundedCoordAt(m),L=c.getBoxPlotStyleOptions(e,a,o),R=new ae(e,M,x,T,I,O,E,P,L);i.addChild(R),c.isSelectable(e,a,o)&&R.setCursor(t.SelectionEffectUtils.getSelectingCursor());var k=h.convertAxisCoord(e,new t.Point(M,O),r);f.associate(R,e,a,o,null,k),fe._renderBoxPlotMarkers(e,i,a,o,r,M),e._currentMarkers.push([R._medianLine])}}}},_renderBoxPlotMarkers:(e,i,r,s,a,n)=>{for(var o=c.getMarkerBorderColor(e,r,s),h=c.getBorderWidth(e,r,s),g=new t.Stroke(o,1,h),u=[],_=d.getNestedDataItemCount(e,r,s),p=0;p<_;p++){var v=fe._getMarkerInfo(e,r,s,p,a);if(v){l.isHorizontal(e)?v.y=n:v.x=n;var m=fe._createMarker(e,v,o,h);null!=m&&u.push(m)}}fe._addMarkersToContainer(e,i,u,g)},_renderLines:(e,t,i,r)=>{var s,a=[],n=d.getSeriesCount(e);for(s=0;s<n;s++)d.isSeriesRendered(e,s)&&"line"==d.getSeriesType(e,s)&&a.push(s);for(var o=0;o<a.length;o++)s=a[o],"none"!=c.getLineType(e,s)&&(fe._filterPointsForSeries(e,s),fe._renderLinesForSeries(e,i,s,r));for(o=0;o<a.length;o++)fe._renderMarkersForSeries(e,t,a[o],r)},_renderAreas:(e,t,i,r)=>{for(var s=d.getSeriesCount(e),a=r?"lineWithArea":"area",n=[],o=[],l=0;l<s;l++)d.isSeriesRendered(e,l)&&d.getSeriesType(e,l)==a&&(d.isAssignedToY2(e,l)?o.push(l):n.push(l));n.length>0&&fe._renderAreasForAxis(e,t,n,e.yAxis.getBaselineCoord(),i,r),o.length>0&&fe._renderAreasForAxis(e,t,o,e.y2Axis.getBaselineCoord(),i,r)},_renderAreasForAxis:(e,i,r,s,a,n)=>{for(var o=d.isStacked(e),l=fe.createClippedGroup(e,i,a),h={},g={},u={},_={},p=[],v=d.getGroupCount(e),m=0;m<v;m++)p.push(new oe(null,s,s,m,d.getGroup(e,m),!0));for(var x=0;x<r.length;x++){var C=r[x],S=d.getStackCategory(e,C),A=d.isSeriesNegative(e,C),b=h[S],y=g[S],M=u[S],D=_[S];if("none"!=c.getLineType(e,C)){var T,I,O,E=k.getAreaFill(e,C),P=c.getBorderColor(e,C),L=c.getBorderWidth(e,C),w=c.getAreaClassName(e,C),R=c.getAreaStyle(e,C),B=P?new t.Stroke(P,1,L):null,F=c.getLineType(e,C);fe._filterPointsForSeries(e,C),d.isRangeSeries(e,C)?(T=fe._getCoordsForSeries(e,C,a,"high"),I=fe._getCoordsForSeries(e,C,a,"low"),O=F):A?(T=fe._getAreaCoordsForSeries(e,C,a,M||p),I=M||[],O=D):(T=fe._getAreaCoordsForSeries(e,C,a,b||p),I=b||[],O=y);var N=new le(e,!0,a,s,R,w,E,B,F,T,O,I);l.addChild(N),e._currentAreas.push(N),f.associate(N,e,C),A?(u[S]=T,_[S]=F):(h[S]=T,g[S]=F),o||((n||c.getDataItemGaps(e)>0&&!P)&&fe._renderLinesForSeries(e,l,C,a,!n),n||fe._renderMarkersForSeries(e,i,C,a),x+1<r.length&&(l=fe.createClippedGroup(e,i,a)))}else fe._renderMarkersForSeries(e,i,C,a)}for(x=0;x<r.length;x++)if(C=r[x],"none"!=c.getLineType(e,C)){var H=c.getBorderColor(e,C)||c.getBorderColor(e,C+1);o&&(n||c.getDataItemGaps(e)>0&&!H)&&fe._renderLinesForSeries(e,l,C,a,!n),(o||n)&&fe._renderMarkersForSeries(e,i,C,a)}},_getAreaCoordsForSeries:(e,t,i,r)=>{for(var s=fe._getCoordsForSeries(e,t,i),a=[],n=0;n<r.length;n++)a.push(r[n].clone());for(var o=s.length-1,h=l.isPolar(e),g=0;g<s.length;g++)if(null!=s[g].x){var d=a[s[g].groupIndex],u=h&&0==g?o:g-1,_=h&&g==o?0:g+1;u>=0&&null!=s[u].x&&(d.y1=s[g].y1),_<=o&&null!=s[_].x&&(d.y2=s[g].y2),d.x=s[g].x,d.filtered=d.y1==d.y2&&s[g].filtered}return a},_renderLinesForSeries:(e,i,r,s,a)=>{var n;if(a){var o=2.5*c.getDataItemGaps(e);n=new t.Stroke(c.getBackgroundColor(e,!0),1,o)}else{var l=c.getColor(e,r),h=c.getLineWidth(e,r),g=c.getLineStyle(e,r);n=new t.Stroke(l,1,h,!1,t.Stroke.getDefaultDashProps(g,h))}var u=d.isAssignedToY2(e,r)?e.y2Axis.getBaselineCoord():e.yAxis.getBaselineCoord(),_=c.getLineType(e,r),p=c.getClassName(e,r),v=c.getStyle(e,r),m=t=>{var a=fe._getCoordsForSeries(e,r,s,t),o=new le(e,!1,s,u,v,p,null,n,_,a);i.addChild(o),f.associate(o,e,r)};d.isRangeSeries(e,r)?(m("high"),m("low")):m("value")},_filterScatterBubble:(e,i)=>{var r,s=d.getSeriesCount(e),a=d.getGroupCount(e);if(s*a<fe.FILTER_THRESHOLD_SCATTER_BUBBLE)return null;for(var n=[],o=0;o<s;o++)if(d.isSeriesRendered(e,o))for(var l=0;l<a;l++)null!=(r=fe._getScatterBubbleMarkerInfo(e,o,l))&&n.push(r);if(n.length<fe.FILTER_THRESHOLD_SCATTER_BUBBLE)return null;i&&me.sortMarkerInfos(n);for(var h=new t.PixelMap(25,new t.PixelMap(5,new t.PixelMap)),g=[],u=n.length-1;u>=0;u--){if(r=n[u],!me.checkPixelMap(h,r.x,r.y,r.size)){var _=c.getColor(e,r.seriesIndex,r.groupIndex),p=c.isMarkerDisplayed(e,o,l)?t.ColorUtils.getAlpha(_):0;p>0&&(me.updatePixelMap(h,r.x,r.y,r.size,p),g.push(r))}}return e.getCache().putToCache("dataFiltered",!0),g.reverse(),g},_filterPointsForSeries:(e,t)=>{if(!l.isPolar(e)&&!d.isRangeSeries(e,t)){var i,r=e.__getPlotAreaSpace(),s=l.isHorizontal(e)?r.h:r.w,a=d.getSeriesItem(e,t).items,n="bar"==d.getSeriesType(e,t),o=e.xAxis.getInfo(),h=(o.getDataMax()-o.getDataMin())/(o.getViewportMax()-o.getViewportMin()),g=n?.5:2,u=h?Math.round(g*(a.length/h)/s):1;if(u<(n?2:3))for(var _=0;_<a.length;_++)(i=a[_])&&(i._filtered=!1);else{for(var c,p,v,m,f,x=!1,C=0;C<a.length;C+=u){c=-1,p=-1/0,v=-1,m=1/0;for(var S=C;S<Math.min(C+u,a.length);S++)f=d.getCumulativeVal(e,t,S),i=a[S],null!=f&&null!=i&&((!n||f>0)&&f>p&&(c=S,p=f),(!n||f<0)&&f<m&&(v=S,m=f),i._filtered=!0,x=!0);for(var A=C;A<Math.min(C+u,a.length);A++)null!=(i=a[A])&&(A!=c&&A!=v||(i._filtered=!1))}e.getCache().putToCache("dataFiltered",x)}}},_getCoordsForSeries:(e,t,i,r)=>{var s=e.xAxis,a=e.yAxis;d.isAssignedToY2(e,t)&&(a=e.y2Axis);for(var n=[],o=w.getViewportMinMaxGroupIdx(e,t),h=o.min-1;h<=o.max+1;h++){var g=d.getGroup(e,h);if(null!=g){var u=d.getXVal(e,t,h),_=null;if("low"==r?_=d.getLowVal(e,t,h):"high"==r?_=d.getHighVal(e,t,h):null!=d.getVal(e,t,h)&&(_=d.getCumulativeVal(e,t,h)),null!=_&&!isNaN(_)&&d.isDataItemRendered(e,t,h)){l.isPolar(e)&&(_=Math.max(_,a.getInfo().getViewportMin()));var c=s.getUnboundedCoordAt(u),p=a.getUnboundedCoordAt(_);if(null!=c&&null!=p){var v=new oe(c,p,p,h,g,d.isDataItemFiltered(e,t,h));n.push(v)}else n.push(new oe(null,null,null,h,g,!1))}else n.push(new oe(null,null,null,h,g,!1))}}return n},createClippedGroup:(e,i,r)=>{var s=new t.Container(i.getCtx());i.addChild(s);var a=new t.ClipPath(e.getId()),n=fe._extendClipGroup(e);if(l.isPolar(e)){var o=r.x+r.w/2,h=r.y+r.h/2;if(w.isGridPolygonal(e)){var g=t.PolygonUtils.getRegularPolygonPoints(o,h,d.getGroupCount(e),e.getRadius(),0);a.addPolygon(g)}else a.addCircle(o,h,e.getRadius())}else l.isHorizontal(e)?a.addRect(r.x-n,r.y,r.w+2*n,r.h):a.addRect(r.x,r.y-n,r.w,r.h+2*n);return s.setClipPath(a),s},_extendClipGroup:e=>{if((d.hasLineSeries(e)||d.hasLineWithAreaSeries(e))&&!l.isSpark(e)){var t=c.getLineWidth(e),i=e=>{var i=e.getInfo(),r=i.getCoordAt(i.getGlobalMax()),s=i.getCoordAt(i.getDataMax()),a=i.getCoordAt(i.getGlobalMin()),n=i.getCoordAt(i.getDataMin());return null!=r&&null!=s&&s-r<=t/2||null!=a&&null!=n&&a-n<=t/2};if(e.yAxis&&i(e.yAxis)||e.y2Axis&&i(e.y2Axis))return Math.ceil(t/2)}return 0}};class xe{constructor(e,t){this._context=e.getCtx(),this._dataCursorShown=!1,this._dataCursor=t,this._chart=e}processMove(e,t){var i=this._chart.__getPlotAreaSpace();return i&&i.containsPoint(e.x,e.y)&&!this._chart.getOptions()._duringZoomAndScroll?(this._showDataCursor(i,e.x,e.y,t),!0):(this._removeDataCursor(t),!1)}processEnd(e){this._removeDataCursor(e)}processOut(e,t){var i=this._chart.__getPlotAreaSpace();i&&!i.containsPoint(e.x,e.y)&&this._removeDataCursor(t)}_showDataCursor(e,i,r,s){if(this._context.isOffscreen(!0))this._removeDataCursor(s);else{var a=this._dataCursor,n=this._getClosestMatch(i,r);if(null!=n){var o=n.matchRegion.getCenter(),l=i,h=r;"snap"===a.getBehavior()&&(a.isHorizontal()?h=Math.min(Math.max(o.y,e.y),e.y+e.h):l=Math.min(Math.max(o.x,e.x),e.x+e.w));var g=n.logicalObject,d=m.getDatatip(this._chart,g.getSeriesIndex(),g.getGroupIndex(),g.getNestedDataItemIndex(),!0);if(null!=d){a.setVisible(!0);var u=m.getDatatipColor(this._chart,g.getSeriesIndex(),g.getGroupIndex(),g.getNestedDataItemIndex()),_=a.isHorizontal()?h:l,c=g.getDisplayables()[0];if(c instanceof t.SimpleMarker&&a.addMarker(c.getType(),c.getSize()),a.render(e,o.x,o.y,_,d,u),this._dataCursorShown=!0,!s){var p=this._chart.getValsAt(i,r);this._chart.changeOption("dataCursorPosition",p)}}else a.setVisible(!1)}else this._removeDataCursor(s)}}_removeDataCursor(e){this._dataCursor.getVisible()&&this._dataCursor.setVisible(!1),this._context.getTooltipManager(p.TOOLTIP_ID).hideTooltip(),this._dataCursorShown=!1,e||this._chart.changeOption("dataCursorPosition",null)}isDataCursorShown(){return this._dataCursorShown}static _getClosestMatchSecondDirection(e,t,i,r){for(var s=null,a=1/0,n=e.length-1;0<=n;n--){var o=e[n],l=t?i:r,h=((t?o.matchRegion.x:o.matchRegion.y)+(t?o.matchRegion.x+o.matchRegion.w:o.matchRegion.y+o.matchRegion.h))/2,g=Math.round(Math.abs(h-l));g<a&&(a=g,s=o)}return s}static _getClosestMatchesFirstDirection(e,t,i,r,s){for(var a=1/0,n=new Array,o=0;o<e.length;o++){var l=e[o];if(s(l.logicalObject)){var h=l.matchRegion,g=t?r:i,d=((t?h.y:h.x)+(t?h.y+h.h:h.x+h.w))/2,u=Math.round(Math.abs(d-g));u<=a&&(u<a&&(n=new Array),n.push(l),a=u)}}return n}_findMatches(){var e=this._context.getStage(),t=this._chart.getEventManager(),i=[];if(!this._chart._currentMarkers)return null;for(var r=0;r<this._chart._currentMarkers.length;r++)for(var s=this._chart._currentMarkers[r],a=s.length,n=0;n<a;n++){var o=s[n],l=t.GetLogicalObject(o),h={matchRegion:o.getDimensionsSelf?o.getDimensionsSelf(e):o.getDimensions(e),logicalObject:l};i.push(h)}return i}_getClosestMatch(e,i){var r=l.isHorizontal(this._chart),s=l.isLineArea(this._chart)&&!l.isMixedFrequency(this._chart),a=this._findMatches(),n=d.getHighlightedCategories(this._chart),o="all"==this._chart.getOptions().highlightMatch,h=n.length>0?o?t.ArrayUtils.hasAllItems:t.ArrayUtils.hasAnyItem:null,g=e=>!h||h(e.getCategories(),n),u=xe._getClosestMatchesFirstDirection(a,r,e,i,g);if(!l.isScatterBubble(this._chart)){for(var _=1/0,c=-1/0,p=null,v=0;v<u.length;v++){var m=u[v];_=Math.min(_,r?m.matchRegion.y:m.matchRegion.x),c=Math.max(c,r?m.matchRegion.y+m.matchRegion.h:m.matchRegion.x+m.matchRegion.w),p=m.logicalObject.getGroupIndex()}for(v=0;v<a.length;v++){var f=a[v];if(g(f.logicalObject))if(s)f.logicalObject.getGroupIndex()==p&&u.push(f);else{var x=((r?f.matchRegion.y:f.matchRegion.x)+(r?f.matchRegion.y+f.matchRegion.h:f.matchRegion.x+f.matchRegion.w))/2;c>=x&&_<=x&&u.push(f)}}}return xe._getClosestMatchSecondDirection(u,r,e,i)}}class Ce extends I{axisToPlotArea(e){if("tangential"==this.getOptions().position)return e;if(null==e)return null;var t=e-this.getLeftOverflow();return Math.round(10*t)/10}plotAreaToAxis(e,t){if("tangential"==this.getOptions().position)return e;if(null==e)return null;var i=e+this.getLeftOverflow();return!1===t?i:Math.round(i)}linearToActual(e){return this.Info.linearToActual(e)}actualToLinear(e){return this.Info.actualToLinear(e)}getValAt(e){return this.Info.getValAt(this.plotAreaToAxis(e))}getCoordAt(e){return this.axisToPlotArea(this.Info.getCoordAt(e))}getBoundedCoordAt(e){return this.axisToPlotArea(this.Info.getBoundedCoordAt(e))}getUnboundedValAt(e){return this.Info.getUnboundedValAt(this.plotAreaToAxis(e))}getUnboundedCoordAt(e){return this.axisToPlotArea(this.Info.getUnboundedCoordAt(e))}getBaselineCoord(){return this.axisToPlotArea(this.Info.getBaselineCoord())}getPosition(){return this.getOptions().position}isGroupAxis(){return this.Info instanceof M}getMajorTickCoords(){for(var e=this.Info?this.Info.getMajorTickCoords():[],t=0;t<e.length;t++)e[t]=this.axisToPlotArea(e[t]);return e}getMinorTickCoords(){for(var e=this.Info?this.Info.getMinorTickCoords():[],t=0;t<e.length;t++)e[t]=this.axisToPlotArea(e[t]);return e}getBaselineCoord(){return this.axisToPlotArea(this.Info.getBaselineCoord())}getLinearGlobalMin(){return this.actualToLinear(this.Info.getGlobalMin())}getLinearGlobalMax(){return this.actualToLinear(this.Info.getGlobalMax())}getLinearViewportMin(){return this.actualToLinear(this.Info.getViewportMin())}getLinearViewportMax(){return this.actualToLinear(this.Info.getViewportMax())}getUnboundedLinearValAt(e){return this.Info.actualToLinear(this.getUnboundedValAt(e))}isFullViewport(){return this.Info.getViewportMin()==this.Info.getGlobalMin()&&this.Info.getViewportMax()==this.Info.getGlobalMax()}getLeftOverflow(){return t.Agent.isRightToLeft(this.getCtx())?this.Info.getEndOverflow():this.Info.getStartOverflow()}getRightOverflow(){return t.Agent.isRightToLeft(this.getCtx())?this.Info.getStartOverflow():this.Info.getEndOverflow()}getLength(){return Math.abs(this.Info.getStartCoord()-this.Info.getEndCoord())}getMinCoord(){return this.axisToPlotArea(Math.min(this.Info.getStartCoord(),this.Info.getEndCoord()))}getMaxCoord(){return this.axisToPlotArea(Math.max(this.Info.getStartCoord(),this.Info.getEndCoord()))}}const Se={_DEFAULT_AXIS_MAX_SIZE:.33,render:(e,t,i)=>{l.hasAxes(e)&&(w.applyInitialZooming(e,i),l.isBubble(e)&&me.calcBubbleSizes(e,i),l.isPolar(e)?Se._renderPolar(e,t,i):Se._renderCartesian(e,t,i))},_renderCartesian:(e,i,r)=>{var s=e.getOptions(),a=l.isHorizontal(e),n=d.isSplitDualY(e),o=l.isOverview(e),h=r.clone(),g=w.getYAxisPos(e),u=w.getY2AxisPos(e),_=!o&&s.overview.content&&s.overview.content.yAxis&&"on"==s.overview.content.yAxis.rendered,p=!o&&s.overview.content&&s.overview.content.y2Axis&&"on"==s.overview.content.y2Axis.rendered;Se._addAxisGaps(e,r),n&&g==u&&(s.yAxis._skipHighestTick=a,s.y2Axis._skipHighestTick=!a);var v=Se._createYAxis(e,i,r,h,_),m=Se._createY2Axis(e,i,r,h,p),f=!n&&"on"==s.y2Axis.alignTickMarks&&null==s.y2Axis.step;f&&v&&m&&(Se._alignYAxes(e,v,m),a||(m.dim=Se._getPreferredSize(e,m.axis,e.y2Axis,m.options,"y2",r,h,p)));var x,C=w.getTickLabelGapSize(e,"y"),S=w.getTickLabelGapSize(e,"y2");n&&g==u?(a?(x=Math.max(v.dim.h+C,m.dim.h+S),v.dim.h=x-C,m.dim.h=x-S):(x=Math.max(v.dim.w+C,m.dim.w+S),v.dim.w=x-C,m.dim.w=x-S),Se._positionAxis(r.clone(),v,C,_),Se._positionAxis(r,m,S,p)):(Se._positionAxis(r,v,C,_),Se._positionAxis(r,m,S,p));var A=d.getGroupCount(e);if("pixel"==c.getBarSpacing(e)&&l.isBar(e)&&r.w>A){var b=Math.floor(r.w/A)*A;r.x+=(r.w-b)/2,r.w=b}var y=Se._createXAxis(e,i,r,h);y.axis.render(y.options,y.dim.w,y.dim.h),Se._positionAxis(r,y,w.getTickLabelGapSize(e,"x"));var M=c.getSplitterPos(e),D=t.Agent.isRightToLeft(e.getCtx()),T=Se._getSplitAvailSpace(r,M,a,a&&D),I=Se._getSplitAvailSpace(r,1-M,a,!a||!D);a?(v&&(v.axis.setTranslateX(r.x),n?v.axis.render(v.options,T.w,v.dim.h,T.x,0):v.axis.render(v.options,r.w,v.dim.h)),f&&v&&m&&Se._alignYAxes(e,v,m),m&&(m.axis.setTranslateX(r.x),n?m.axis.render(m.options,I.w,m.dim.h,I.x,0):m.axis.render(m.options,r.w,m.dim.h)),Se._setOverflow(r,v,y)):(v&&(n?v.axis.render(v.options,v.dim.w,T.h,0,T.y):v.axis.render(v.options,v.dim.w,r.h)),f&&v&&m&&Se._alignYAxes(e,v,m),m&&(n?m.axis.render(m.options,m.dim.w,I.h,0,I.y):m.axis.render(m.options,m.dim.w,r.h)),Se._setOverflow(r,y,v,m)),Se._storeAxes(e,y,v,m)},_renderPolar:(e,t,i)=>{var r=Se._createXAxis(e,t,i,i);r.axis.setTranslateX(i.x),r.axis.setTranslateY(i.y),r.axis.render(r.options,i.w,i.h);var s=Se._createYAxis(e,t,i,i);s.axis.setTranslateX(i.x),s.axis.setTranslateY(i.y),s.axis.render(s.options,i.w,i.h),Se._storeAxes(e,r,s)},_createXAxis:(e,i,r,s)=>{var a=e.getOptions(),n=w.getXAxisPos(e),o=t.JsonUtils.clone(a.xAxis,null,e.Defaults.getNoCloneObject().xAxis);o.position=n,o.isStandalone=w.isStandaloneXAxis(e),o.groupSeparators=a.styleDefaults.groupSeparators,Se._addCommonAxisAttr(o,"x",e),o.groups=a.groups,o._groupWidthRatios=R.getGroupWidthRatios(e),o.timeAxisType=l.getTimeAxisType(e),o._locale=a._locale,o.drilling=a.drilling,o._isGroupAxis=l.hasGroupAxis(e);var h="top"==n||"bottom"==n,g=w.isGridShifted(e);if("tangential"==n&&l.hasGroupAxis(e))g?(o.startGroupOffset=.5,o.endGroupOffset=.5):o.endGroupOffset=1;else{var u=w.getAxisOffset(e);if(o.startGroupOffset=u,o.endGroupOffset=u,c.hasUncenteredSeries(e)&&(o.endGroupOffset+=1),!O.isScrollable(e)&&!l.isOverview(e)){var _=d.getGroupCount(e);w.isAxisRendered(e,"y")&&w.isTickLabelInside(e,"y")&&(o[(h?"start":"end")+"GroupOffset"]+=.04*_),w.isAxisRendered(e,"y2")&&w.isTickLabelInside(e,"y2")&&(o[(h?"end":"start")+"GroupOffset"]+=.04*_)}}o.leftBuffer=h?r.x-s.x:0,o.rightBuffer=h?s.w+s.x-(r.w+r.x):0,o._renderGridAtLabels=!g||l.hasTimeAxis(e),o.translations=a.translations;var p=new Ce(e.getCtx(),e.processEvent,e);i.addChild(p);var v=Se._getPreferredSize(e,p,e.xAxis,o,"x",r,s);return o._minOverflowCoord=a._minOverflowCoord-r.x,o._maxOverflowCoord=a._maxOverflowCoord-r.x,{axis:p,options:o,dim:v}},_createYAxis:(e,i,r,s,a)=>{var n=e.getOptions();if(d.hasY2DataOnly(e))return null;var o=t.JsonUtils.clone(n.yAxis,null,e.Defaults.getNoCloneObject().yAxis);o.position=w.getYAxisPos(e),o.isStandalone=w.isStandaloneYAxis(e),Se._addCommonAxisAttr(o,"y",e),Se._addCommonYAxisAttr(o,e),o.translations=n.translations;var l=new Ce(e.getCtx(),e.processEvent,e);i.addChild(l);var h=Se._getPreferredSize(e,l,e.yAxis,o,"y",r,s,a);return Se._adjustYAxisForLabels(l,o,e,"y"),n.yAxis.min=o.min,n.yAxis.max=o.max,{axis:l,options:o,dim:h}},_createY2Axis:(e,i,r,s,a)=>{var n=e.getOptions();if(d.hasY2Data(e)){var o=t.JsonUtils.clone(n.y2Axis,null,e.Defaults.getNoCloneObject().y2Axis);o.position=w.getY2AxisPos(e),o.isStandalone=w.isStandaloneY2Axis(e),Se._addCommonAxisAttr(o,"y2",e),Se._addCommonYAxisAttr(o,e),o.translations=n.translations;var l=new Ce(e.getCtx(),e.processEvent,e);i.addChild(l);var h=Se._getPreferredSize(e,l,e.y2Axis,o,"y2",r,s,a);return Se._adjustYAxisForLabels(l,o,e,"y2"),n.y2Axis.min=o.min,n.y2Axis.max=o.max,{axis:l,options:o,dim:h}}},_addCommonAxisAttr:(e,t,i)=>{var r=i.getOptions();if(e.skin=r.skin,e.tickLabel.position=w.isTickLabelInside(i,t)?"inside":"outside",e.baselineScaling=w.getBaselineScaling(i,t),(w.isTickLabelInside(i,t)||"tangential"==e.position)&&(e._skipHighestTick=!0),e.zoomAndScroll=l.isPolar(i)?"off":r.zoomAndScroll,e._isOverview=l.isOverview(i),e._duringZoomAndScroll=r._duringZoomAndScroll,"x"!=t||!l.hasGroupAxis(i)){var s=w.getMinMaxVal(i,t);e.dataMin=null!=e.dataMin?e.dataMin:s.min,e.dataMax=null!=e.dataMax?e.dataMax:s.max}l.isPolar(i)&&(e.polarGridShape=w.isGridPolygonal(i)?"polygon":"circle",e._radius=i.getRadius()),e.dnd=r.dnd},_addCommonYAxisAttr:(e,r)=>{if(e.timeAxisType="disabled",O.isLiveScroll(r)&&l.isBLAC(r)&&!l.isPolar(r)&&(e._continuousExtent="on"),e.isStandalone)e.leftBuffer=0,e.rightBuffer=0;else if(d.isSplitDualY(r))e.leftBuffer=1/0,e.rightBuffer=1/0;else{var s=t.Agent.isRightToLeft(r.getCtx());e.leftBuffer=s?0:i.BaseAxisInfo.MIN_AXIS_BUFFER,e.rightBuffer=s?i.BaseAxisInfo.MIN_AXIS_BUFFER:0}},_adjustYAxisForLabels:(e,i,r,s)=>{var a=r.getOptions();if(w.isYAdjustmentNeeded(r)){var n=t.CSSStyle.mergeStyles([a.styleDefaults._dataLabelStyle,a.styleDefaults.dataLabelStyle]),o=a.styleDefaults.stackLabelStyle,h=e.getInfo(),g=c.isStackLabelRendered(r),u=t.TextUtils.getTextStringHeight(r.getCtx(),g?o:n),_=0;if("log"==i.scale){_=e.getUnboundedValAt(e.getUnboundedCoordAt(h.getDataMax())-u)-h.getDataMax()}else{var p=1;d.isSplitDualY(r)&&(p="y"==s?c.getSplitterPos(r):1-c.getSplitterPos(r));var v=Math.abs(h.getEndCoord()-h.getStartCoord())*p;_=Math.abs(h.getViewportMax()-h.getViewportMin())/v*u}l.isHorizontal(r)?_*=4:_*=2,h.getDataMin()-h.getGlobalMin()<=_&&h.getDataMin()<0&&(i.dataMin-=_),h.getGlobalMax()-h.getDataMax()<=_&&h.getDataMax()>0&&(i.dataMax+=_)}},_getPreferredSize:(e,i,r,s,a,n,o,l)=>{var h=s.isStandalone,g=s.position,d="top"==g||"bottom"==g,u=w.getTickLabelGapSize(e,a),_=s.maxSize,p=s.size,v=n.w,m=n.h;if("radial"==g||"tangential"==g)v=0,m=0;else if("off"!=s.rendered||l)if(h)d?m=n.h-u:v=n.w-u;else if(null!=p)d?(m=c.getSizeInPixels(p,o.h)-u,null!=_&&(m=Math.min(m,c.getSizeInPixels(_,o.h)-u))):(v=c.getSizeInPixels(p,o.w)-u,null!=_&&(v=Math.min(v,c.getSizeInPixels(_,o.w)-u)));else{if(!e.getOptions()._duringZoomAndScroll||!r)return _=null==_?Se._DEFAULT_AXIS_MAX_SIZE:_,d?i.getPreferredSize(s,n.w,c.getSizeInPixels(_,o.h)-u,l):i.getPreferredSize(s,c.getSizeInPixels(_,o.w)-u,n.h,l);if(d){var f=t.Agent.isRightToLeft(e.getCtx());s._startOverflow=f?r.getRightOverflow():r.getLeftOverflow(),s._endOverflow=f?r.getLeftOverflow():r.getRightOverflow(),m=r.getHeight()}else v=r.getWidth()}else d?m=0:v=0;return w.isYAdjustmentNeeded(e)&&i.getPreferredSize(s,v,m),new t.Dimension(v,m)},_addAxisGaps:(e,t)=>{var i=l.isHorizontal(e),r=w.getYAxisPos(e),s=w.getY2AxisPos(e),a=w.isAxisRendered(e,"x"),n=w.isAxisRendered(e,"y"),o=w.isAxisRendered(e,"y2"),h=e.getOptions().layout.verticalAxisGap;h*=i?w.getGapScalingFactor(e,"x"):Math.max(w.getGapScalingFactor(e,"y"),w.getGapScalingFactor(e,"y2")),h=Math.ceil(h),(!i||"top"==r&&n||"top"==s&&o)&&i||(t.y+=h,t.h-=h),(!i||"bottom"==r&&n||"bottom"==s&&o)&&(i||a)||(t.h-=h)},_positionAxis:(e,i,r,s)=>{if(i){var a=s?Math.max(i.dim.h,1):i.dim.h,n=s?Math.max(i.dim.w,1):i.dim.w;t.LayoutUtils.position(e,i.options.position,i.axis,n,a,r)}},_alignYAxes:(e,t,i)=>{var r=t.axis.getInfo();if(r){var s=r.getMajorTickCount(),a=r.getMinorTickCount(),n=i.options,o=i.axis.getInfo();o&&w.isLog(e,"y")&&w.isLog(e,"y2")&&s<o.getMajorTickCount()&&(n._logScaleUnit=o.alignLogScaleToTickCount(o.getLogScaleUnit(),s)),n._majorTickCount=s,n._minorTickCount=a}},_getSplitAvailSpace:(e,t,i,r)=>{var s=e.clone();return i?(s.w=e.w*t,s.x=r?e.w*(1-t):0):(s.h=e.h*t,s.y=r?e.h*(1-t):0),s},_setOverflow:(e,t,i,r)=>{if(t){var s=t.axis.getLeftOverflow(),a=t.axis.getRightOverflow();e.x+=s,e.w-=s+a,i&&i.axis.setTranslateX(i.axis.getTranslateX()+("left"==i.options.position?s:-a)),r&&r.axis.setTranslateX(r.axis.getTranslateX()+("left"==r.options.position?s:-a))}},_storeAxes:(e,t,i,r)=>{e.xAxis&&(e.xAxis.destroy(),e.removeChild(e.xAxis)),e.yAxis&&(e.yAxis.destroy(),e.removeChild(e.yAxis)),e.y2Axis&&(e.y2Axis.destroy(),e.removeChild(e.y2Axis)),e.xAxis=t.axis,e.yAxis=i?i.axis:null,e.y2Axis=r?r.axis:null}},Ae={_DEFAULT_LINE_WIDTH_WITH_MARKER:2,_DEFAULT_MAX_SIZE:.3,_PIE_SIZE_RATIO:1.2,render:(e,i,s)=>{var a=e.getOptions(),n=a.legend.position;if(!("off"==a.legend.rendered||"auto"==a.legend.rendered&&e.getOptionsCache().getFromCache("hasLargeSeriesCount"))){var o=t.JsonUtils.clone(a.legend);delete o.position,o.skin=a.skin,o.hideAndShowBehavior=O.getHideAndShowBehavior(e),o.hoverBehavior=O.getHoverBehavior(e),o.hoverBehaviorDelay=c.getHoverBehaviorDelay(e),o.hiddenCategories=d.getHiddenCategories(e),o.highlightedCategories=d.getHighlightedCategories(e),o.dnd=a.dnd,o._dropColor=a._dropColor,o.translations=a.translations,"auto"==n&&(n=s.w>=s.h?"end":"bottom");var h="top"==n||"bottom"==n;if(o.orientation=h?"horizontal":"vertical","start"==n&&(o.halign="end"),"start"!=n&&"end"!=n||(o.valign="middle"),"top"==n&&(o.valign="bottom"),"top"!=n&&"bottom"!=n||(o.halign="center"),Ae._addLegendData(e,o),0!=o.sections.length){var g,_=new r.Legend(e.getCtx(),e.processEvent,e);if(null!=e.getId()&&_.setId(e.getId()+"legend"),i.addChild(_),null!=o.size)g=h?new t.Dimension(s.w,c.getSizeInPixels(o.size,s.h)):new t.Dimension(c.getSizeInPixels(o.size,s.w),s.h);else{var p=o.maxSize;if(null==p&&(p=Ae._DEFAULT_MAX_SIZE,l.isPie(e))){var v=1-Ae._PIE_SIZE_RATIO*(h?s.w/s.h:s.h/s.w);p=Math.max(p,v)}var m=h?s.w:c.getSizeInPixels(p,s.w),f=h?c.getSizeInPixels(p,s.h):s.h;g=_.getPreferredSize(o,m,f)}_.render(o,g.w,g.h);var x=h?u.getGapHeight(e,a.layout.legendGapHeight):u.getGapWidth(e,a.layout.legendGapWidth);t.LayoutUtils.position(s,n,_,g.w,g.h,x);var C=Object.keys(o.dnd.drag.series).length>0,S=_.getCache().getFromCache("background");C&&S&&S.setClassName("oj-draggable");var A=_.__getBounds(),b=_.localToStage(new t.Point(A.x,A.y));if(!l.isOverview(e)){var y=t.Agent.isRightToLeft(e.getCtx());"end"==n?y?a._minOverflowCoord=b.x+A.w+x/2:a._maxOverflowCoord=b.x-x/2:"start"==n&&(y?a._maxOverflowCoord=b.x-x/2:a._minOverflowCoord=b.x+A.w+x/2)}e.legend&&(e.legend.destroy(),i.removeChild(e.legend)),e.legend=_,Ae.isLegendInteractive(e)||e.legend.setAriaProperty("hidden","true",!0)}}},_addLegendData:(e,t)=>{var i=Ae._getSeriesItems(e,"vertical"==t.orientation);if(i.length>0){var r=t.seriesSection;r.items=i,t.sections.unshift(r),delete t.seriesSection}var s=Ae._getRefObjItems(e);if(s.length>0){var a=t.referenceObjectSection;a.items=s,t.sections.push(a),delete t.referenceObjectSection}},_getSeriesItems:(e,t)=>{var i,r,s=[];if("pie"==e.getType()||"pyramid"==e.getType()||"funnel"==e.getType()){var a=_.getRenderedSeriesIndices(e);"pyramid"==e.getType()&&t&&a.reverse();for(var n=0;n<a.length;n++){r=a[n];var o=d.getVal(e,r,0);o>=0&&null!=o&&(i=Ae._createLegendItem(e,r))&&s.push(i)}_.hasOtherSeries(e)&&(i={id:_.OTHER_ID,drilling:e.getOptions().multiSeriesDrilling,text:e.getOptions().translations.labelOther,categoryVisibility:d.getHiddenCategories(e).indexOf(_.OTHER_ID)>=0?"hidden":"visible",symbolType:"marker",color:e.getOptions().styleDefaults.otherColor,borderColor:e.getOptions().styleDefaults.borderColor},s.push(i))}else{var h={},g={},u=d.getSeriesCount(e);for(r=0;r<u;r++)if(i=Ae._createLegendItem(e,r)){var c=d.getStackCategory(e,r);d.isAssignedToY2(e,r)?g[c]?g[c].push(i):g[c]=[i]:h[c]?h[c].push(i):h[c]=[i]}var p=d.getStackCategories(e,null,!0),v=d.isStacked(e)&&l.isVertical(e)&&t;s=Ae._getSeriesItemsForAxis(h,p.y,v,s),s=Ae._getSeriesItemsForAxis(g,p.y2,v,s)}return s},_getSeriesItemsForAxis:(e,t,i,r)=>{for(var s,a=0;a<t.length;a++)(s=e[t[a]])&&(r=i?r.concat(s.reverse()):r.concat(s));return r},_createLegendItem:(e,t)=>{var i=d.getSeriesItem(e,t),r=e.getType(),s=d.getSeriesType(e,t),a=c.getLineType(e,t),n=i.displayInLegend;if(!i||"off"==n)return null;if("on"!=n&&(l.isFunnel(e)||l.isPyramid(e)||l.isStock(e)))return null;if("on"!=n&&!d.hasSeriesData(e,t))return null;var o=d.getSeriesLabel(e,t);if("on"!=n&&(null==o||"string"==typeof o&&0===o.trim().length))return null;var h={id:d.getSeries(e,t),text:o,categories:d.getCategories(e,t),categoryVisibility:d.isSeriesRendered(e,t)?"visible":"hidden",_getDataContext:c.getDataContext.bind(null,e,t,-1)};if("line"==s||"lineWithArea"==s||"scatter"==r||"bubble"==r)if(h.lineStyle=c.getLineStyle(e,t),h.lineWidth=c.getLineWidth(e,t),c.isMarkerDisplayed(e,t)){var g=c.getImageSource(e,t,null,null,"source");g?(h.symbolType="image",h.source=g):(h.symbolType="none"==a?"marker":"lineWithMarker","lineWithMarker"==h.symbolType&&(h.lineWidth=Math.min(Ae._DEFAULT_LINE_WIDTH_WITH_MARKER,h.lineWidth)),h.markerShape=c.getMarkerShape(e,t),h.markerColor=c.getMarkerColor(e,t))}else h.symbolType="line";else if("boxPlot"==s){var u=c.getBoxPlotStyleOptions(e,t);u.q2Color!=u.q3Color?(h.symbolType=l.isHorizontal(e)?"_horizontalBoxPlot":"_verticalBoxPlot",h._boxPlot=u):h.symbolType="marker"}else h.symbolType="marker","none"==c.getLineType(e,t)&&(h.markerShape=c.getMarkerShape(e,t));return h.color=c.getColor(e,t),h.borderColor=c.getBorderColor(e,t),h.pattern=c.getPattern(e,t),h.svgStyle="area"==s?c.getAreaStyle(e,t):c.getStyle(e,t),h.svgClassName="area"==s?c.getAreaClassName(e,t):c.getClassName(e,t),h.markerSvgStyle=c.getMarkerStyle(e,t),h.markerSvgClassName=c.getMarkerClassName(e,t),h.drilling=d.isSeriesDrillable(e,t)?"on":"off",h.shortDesc=i.shortDesc,h},_getRefObjItems:e=>{var t=d.getRefObjs(e);if(t.length<=0)return[];for(var i=[],r=0;r<t.length;r++){var s=t[r];if(s&&"on"==s.displayInLegend&&s.text){var a=v.getType(s);i.push({symbolType:"area"==a?"square":"line",text:s.text,color:v.getColor(e,s),lineStyle:s.lineStyle,lineWidth:v.getLineWidth(e,s),categories:v.getRefObjCategories(s),categoryVisibility:v.isObjRendered(e,s)?"visible":"hidden",shortDesc:s.shortDesc,svgStyle:s.style||s.svgStyle,svgClassName:s.className||s.svgClassName})}}return i},isLegendDrillable:function(e){var t=e.getOptions();return!!("on"===t.drilling||"seriesOnly"===t.drilling||l.isPie(e)&&"on"===t.multiSeriesDrilling)||e.getOptionsCache().getFromCache("hasDrillableSeries")},isLegendInteractive:function(e){return"none"!==O.getHideAndShowBehavior(e)||Ae.isLegendDrillable(e)}};class be extends s.Overview{constructor(e){super(e.getCtx(),e.processEvent,e),this._parentChart=e,this._chart=e.overview?e.overview.getBackgroundChart():null,this._id=e.getId()+"_overview"}_renderChart(e,i,r){var s=this._parentChart.Defaults.getNoCloneObject();this._chartContainer=new t.Container(this.getCtx()),this.addChild(this._chartContainer);e=t.JsonUtils.merge({legend:{rendered:"off",size:null},xAxis:{viewportMin:null,viewportMax:null,viewportStartGroup:null,viewportEndGroup:null,axisLine:{rendered:"off"},size:null,maxSize:.5,title:null},yAxis:{rendered:"off",size:null},y2Axis:{rendered:"off",size:null},splitDualY:"off",title:{text:null},subtitle:{text:null},footnote:{text:null},titleSeparator:{rendered:"off"},styleDefaults:{animationIndicators:"none"},layout:{outerGapWidth:0,outerGapHeight:0},_isOverview:!0},e,s),l.hasGroupAxis(this._parentChart)&&(e.xAxis.tickLabel.rendered="off"),l.isStock(this._parentChart)&&e.series&&e.series[0]&&(e.series=[e.series[0]],e.series[0].type="lineWithArea");var a=this._parentChart.getOptions().overview.content,n=(e=t.JsonUtils.merge(a,e,s)).yAxis.rendered,o=e.y2Axis.rendered;e.zoomAndScroll="off",this._chart||(this._chart=this._parentChart.createOverviewChart(),this._chart.setId(this._id));var h=i,g=this._parentChart.getWidth(),u=this._parentChart.__getPlotAreaSpace(),_=d.hasY2Data(this._parentChart),c=d.hasY2DataOnly(this._parentChart),p=(n="on"===e.yAxis.rendered&&!c,o="on"===e.y2Axis.rendered&&_,u.x),v=g-(p+i);n&&(h=p+i,e.yAxis.size=p),o&&(h=(n?p:0)+v+i,e.y2Axis.size=v),this._chartContainer.addChild(this._chart),this._chart.render(e,h,r);var m=new t.Rect(this.getCtx(),0,0,h,r);m.setInvisibleFill(),this._chartContainer.addChild(m),this._chart.getEventManager().setKeyboardHandler(null);var f=this._chart.__getPlotAreaSpace();if(n){var x=this._chartContainer.getTranslateX()-f.x;this._chartContainer.setTranslateX(x)}return new t.Dimension(i,f.h+f.y)}render(e,t,i){e.overview.style={overviewBackgroundColor:"rgba(0,0,0,0)",windowBackgroundColor:"rgba(0,0,0,0)",windowBorderTopColor:"#333333",windowBorderRightColor:"#333333",windowBorderBottomColor:"#333333",windowBorderLeftColor:"#333333",leftFilterPanelColor:"rgba(5,65,135,0.1)",rightFilterPanelColor:"rgba(5,65,135,0.1)",handleBackgroundClass:e.chart._resources.overviewGrippy,handleSize:16,handleFillColor:"rgba(0,0,0,0)"},e.overview.animationOnClick="off";var r=this._renderChart(e.chart,t,i);super.render(e.overview,r.w,r.h)}destroy(){super.destroy(),this._parentChart=null,this._chart=null}getBackgroundChart(){return this._chart}isBackgroundRendered(){return!1}isLeftAndRightFilterRendered(){return!0}HandleKeyDown(e){}HandleKeyUp(e){}}class ye extends t.Container{constructor(e,i,r,s){super(e.getCtx()),this._THREED_TILT=j.THREED_TILT,this._THREED_DEPTH=.1,this._RADIUS=.45,this._RADIUS_LABELS=.38,this._MIN_ARC_LENGTH=1.5,this.chart=e,this._options=e.getOptions(),this._frame=i.clone(),e.pieChart=this;for(var a=this.getLabelPos(),n=d.getSeriesCount(e),o=0;o<n;o++){var l=d.getDataItem(e,o,0);!l||"center"!=a&&"none"!=a||"outsideSlice"!=l.labelPosition||(a="outsideSlice")}this._center=new t.Point(i.x+Math.floor(i.w/2),i.y+Math.floor(i.h/2));var h="center"==a||"none"==a?this._RADIUS:this._RADIUS_LABELS;this._radiusX=Math.floor(Math.min(i.w,i.h)*h),this._radiusY=this._radiusX,this._depth=0,this._anchorOffset=90,this.is3D()&&(this._depth=i.h*this._THREED_DEPTH,this._center.y-=Math.floor(this._depth/2),this._radiusY*=this._THREED_TILT),this._slices=this._createSlices(),this._centerLabel=null,this._shapesContainer=new t.Container(this.getCtx()),this._numFrontObjs=0,this._numSelectedObjsInFront=0}getOptions(){return this._options}highlight(e){t.CategoryRolloverHandler.highlight(e,this._slices,"any"==this.getOptions().highlightMatch)}_createSlices(){for(var e,i,r=[],s=_.getRenderedSeriesIndices(this.chart),a=_.getOtherVal(this.chart),n=0;n<s.length;n++)if(i=s[n],d.isDataItemRendered(this.chart,i)){var o=(e=new j(this,i)).getVal();null==o||o<=0||r.push(e)}var l=d.getHiddenCategories(this.chart).indexOf(_.OTHER_SLICE_SERIES_ID)>=0;if(a>0&&!l){var h=new j(this);"ascending"==this.chart.getOptions().sorting?r.unshift(h):r.push(h)}return t.Agent.isRightToLeft(this.getCtx())&&r.reverse(),r}setInitialSelection(){var e=this.chart.getSelectionHandler();if(e){for(var t=d.getInitialSelection(this.chart),i=[],r=0;r<t.length;r++)for(var s=0;s<this._slices.length;s++){var a=this._slices[s].getId();null!=a&&(null!=t[r].id&&a.id==t[r].id||a.series==t[r].series&&a.group==t[r].group)&&i.push(a)}if(_.isOtherSliceSelected(this.chart,t)){var n=_.getOtherSliceId(this.chart);i.push(n)}e.processInitialSelections(i,this._slices)}}render(){F.addPlotAreaDnDBackground(this.chart,this,this._frame,!0),this.contains(this._shapesContainer)||(this._shapesContainer||(this._shapesContainer=new t.Container(this.getCtx())),this.addChild(this._shapesContainer)),ye._layoutSlices(this._slices,this._anchorOffset);for(var e=2*Math.PI*this.getRadiusX(),i=0,r={},s=this.chart.getOptionsCache().getFromCache("hasLargeSeriesCount"),a=0;a<this._slices.length;a++){if(s){var n=this._slices[a].getAngleExtent(),o=n/360*e,l=(this._slices[a].getAngleStart()+n)/360*e;if(o<this._MIN_ARC_LENGTH&&Math.abs(i-l)<this._MIN_ARC_LENGTH){r[this._slices[a].getSeriesIndex()]=!0;continue}i=l}this._slices[a].preRender()}var h=ye._orderSlicesForRendering(this._slices);this._duringDisplayAnim||(W.createPieCenter(this),W.layoutLabelsAndFeelers(this));for(a=0;a<h.length;a++)r[h[a].getSeriesIndex()]||h[a].render(this._duringDisplayAnim);this.setInitialSelection(),this.highlight(d.getHighlightedCategories(this.chart))}getTotalValue(){for(var e=0,t=0;t<this._slices.length;t++){var i=this._slices[t].getVal();i>=0&&(e+=i)}return e}static _layoutSlices(e,t){var i,r,s=0,a=e?e.length:0;t>360&&(t-=360),t<0&&(t+=360);var n=0;a>0&&(n=e[0].getPieChart().getTotalValue());for(var o=0;o<a;o++){var l=(i=e[o]).getVal();(r=t-(s=3.6*(l==n?100:0==n?0:Math.min(l/n*100,99.99))))<0&&(r+=360),i.setAngleStart(r),i.setAngleExtent(s),t=i.getAngleStart()}}static _orderSlicesForRendering(e){for(var t,i,r,s,a=[],n=e?e.length:0,o=-1,l=0;l<n;l++)if((r=(i=(t=e[l]).getAngleStart())+t.getAngleExtent())>360&&(r-=360),r<0&&(r+=360),90==r||i<90&&r>90){o=l,s=r-90;break}var h=[];for(l=o;l<n;l++)h.push(e[l]);for(l=0;l<o;l++)h.push(e[l]);var g=0,d=0,u=180+s;for(l=0;l<n;l++)if(t=h[l]){if(g+t.getAngleExtent()>u){d=l;break}a.push(t),g+=t.getAngleExtent()}for(l=n-1;l>=d;l--)(t=h[l])&&a.push(t);return a}is3D(){return"on"==this._options.styleDefaults.threeDEffect}__calcMaxExplodeDistance(){var e=.5/this._RADIUS-1;return this._radiusX*e}getAnimDuration(){return c.getAnimDur(this.chart)}getDisplayAnim(){this._duringDisplayAnim=!0;var e=new t.DataAnimationHandler(this.getCtx(),this),i=this.getAnimDuration(),r=j.createFillerSlice(this,this.getTotalValue());this._slices.push(r);var s=new t.CustomAnimation(this.getCtx(),r,i);s.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,r,r.GetAnimParams,r.SetAnimParams,r.getDeletedAnimParams()),s.setOnEnd(r._removeDeletedSlice,r),e.add(s,0);for(var a=0;a<this._slices.length-1;a++)this._slices[a].animateInsert(e);var n=new t.CustomAnimation(this.getCtx(),this,i);n.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimParams,this._setAnimParams,this._getAnimParams()),e.add(n,0);var o=[];for(a=0;a<this._slices.length;a++)o=o.concat(this._slices[a].getLabelAndFeeler());var l=new t.AnimFadeIn(this._context,o,i);e.add(l,0),this._setAnimParams();var h=e.getAnimation(!0);return h.setOnEnd(this._onEnd,this),h}_onEnd(){this._duringDisplayAnim=!1,this._setAnimParams()}getCenter(){return this._center}getId(){return"chart/pie"}getInnerRadius(){return this.is3D()?0:this._options.styleDefaults.pieInnerRadius*Math.min(this._radiusX,this._radiusY)*.95}__getFrame(){return this._frame}getRadiusX(){return this._radiusX}getRadiusY(){return this._radiusY}getDepth(){return this._depth}getSliceDisplayable(e){var t=_.getSliceBySeriesIdx(this.chart,e);return t?t.getTopDisplayable():null}__getShapesContainer(){return this._shapesContainer}__getSlices(){return this._slices}animateUpdate(e,i){var r=new t.DataAnimationHandler(this.getCtx(),this);r.constructAnimation(i.__getSlices(),this.__getSlices());var s=r.getAnimation(!0),a=new t.CustomAnimation(this.getCtx(),this,this.getAnimDuration());a.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimParams,this._setAnimParams,this._getAnimParams());var n=new t.ParallelPlayable(this.getCtx(),s,a);n.setOnEnd(this._setAnimParams,this),e.add(n,0),this._setAnimParams([i.getDepth(),i.getRadiusY(),i.getCenter().y])}animateInsert(e){}animateDelete(e,t){}_getAnimParams(){return[this._depth,this._radiusY,this._center.y]}_setAnimParams(e){this.removeChildren(),this._shapesContainer&&this._shapesContainer.destroy(),this._shapesContainer=null,e&&(this._depth=e[0],this._radiusY=e[1],this._center.y=e[2]),this.render()}bringToFrontOfSelection(e){var t=e.getPieChart()._shapesContainer;if(t){var i=t.getNumChildren();if(i-this._numFrontObjs>1){t.removeChild(e._topSurface[0]);var r=i-this._numFrontObjs-1;t.addChildAt(e._topSurface[0],r)}}}pushToBackOfSelection(e){for(var t=this._slices.length,i=0,r=0;r<t;r++)this._slices[r].isSelected()&&i++;this._numSelectedObjsInFront=i;var s=e.getPieChart()._shapesContainer;if(s){var a=s.getNumChildren()-this._numFrontObjs-1-this._numSelectedObjsInFront;a>=0&&(s.removeChild(e._topSurface[0]),s.addChildAt(e._topSurface[0],a))}}getLabelPos(){return ye.parseLabelPos(this._options.styleDefaults.dataLabelPosition)}getSeriesLabelPos(e){var t=this.getLabelPos(),i=d.getDataItem(this.chart,e,0);return i&&i.labelPosition&&(t=i.labelPosition),ye.parseLabelPos(t)}static parseLabelPos(e){return"center"==e||"inside"==e?"center":"outsideSlice"==e||"outside"==e?"outsideSlice":"none"==e?"none":"auto"}getSkin(){return this._options.skin}setCenterLabel(e){this._centerLabel=e}getCenterLabel(){return this._centerLabel}}const Me={_BUTTON_SIZE:16,_BUTTON_PADDING:5,_BUTTON_CORNER_DIST:4,_MOUSE_WHEEL_ZOOM_RATE_SLOW:.05,_MOUSE_WHEEL_ZOOM_RATE_FAST:.2,render:(e,t,i)=>{if(Me._renderBackground(e,t,i),d.hasInvalidData(e))L(e,t,i);else{l.isOverview(e)||(e.getOptions()._maxOverflowCoord=i.x+i.w,e.getOptions()._minOverflowCoord=i.x),Me._addOuterGaps(e,i);var r=i.clone();Me._renderTitles(e,t,i),Me._adjustAvailSpace(i),Ae.render(e,t,i),Me._adjustAvailSpace(i);var s=Me._prerenderHorizScrollbar(e,t,i),a=Me._prerenderVertScrollbar(e,t,i);Me._adjustAvailSpace(i),e.__setAxisSpace(i.clone()),Se.render(e,t,i),Me._adjustAvailSpace(i),Me._positionLegend(e.legend,i),e.__setPlotAreaSpace(i.clone()),Me._setEventHandlers(e),Me._renderScrollbars(e,s,a),Me._updateTitles(e,t,r,i),Me._renderPlotArea(e,t,i),Me._renderDragButtons(e)}},_setEventHandlers:e=>{var i=e.getOptions(),r=e.getEventManager();if(l.hasAxes(e)&&!l.isOverview(e)){var s,a,n=new t.Rectangle(0,0,e.getWidth(),e.getHeight()),o=e.__getPlotAreaSpace(),h=e.__getAxisSpace(),g=new t.Rectangle(o.x,h.y,o.w,h.h),d=new t.Rectangle(h.x,o.y,h.w,o.h),u=new t.SolidFill(i.styleDefaults.marqueeColor),_=new t.Stroke(i.styleDefaults.marqueeBorderColor);if(O.isScrollable(e)){var c=O.isDelayedScroll(e)?Me._MOUSE_WHEEL_ZOOM_RATE_FAST:Me._MOUSE_WHEEL_ZOOM_RATE_SLOW;if(a=new t.PanZoomHandler(e,o,n,c),r.setPanZoomHandler(a),O.isZoomable(e)){var p=O.getZoomDir(e);s=l.isHorizontal(e)||"y"==p?new t.MarqueeHandler(e,o,n,u,_,!1,!0,null,d):l.isBLAC(e)||"x"==p?new t.MarqueeHandler(e,o,n,u,_,!0,!1,g,null):new t.MarqueeHandler(e,o,n,u,_,!0,!0,g,d),r.setMarqueeZoomHandler(s)}}"multiple"==i.selectionMode&&(s=new t.MarqueeHandler(e,o,n,u,_,!0,!0,g,d),r.setMarqueeSelectHandler(s))}},rerenderAxisAndPlotArea:(e,t)=>{if(!d.hasInvalidData(e)){var i=e.__getAxisSpace().clone(),r=e.getSelectionHandler();if(r)var s=r.getSelectedIds();var a=e.__cacheChartFocus();e.__cleanUpAxisAndPlotArea(),Se.render(e,t,i),Me._adjustAvailSpace(i),e.__setPlotAreaSpace(i.clone()),Me._renderPlotArea(e,t,i),r&&r.processInitialSelections(s,e.getChartObjPeers()),e.getEventManager().autoToggleZoomButton(),Me.positionDragButtons(e),e.highlight(d.getHighlightedCategories(e)),e.__restoreChartFocus(a)}},_renderBackground:(e,i,r)=>{var s=new t.Rect(e.getCtx(),r.x,r.y,r.w,r.h);s.setInvisibleFill(),i.addChild(s)},_addOuterGaps:(e,t)=>{var i=e.getOptions(),r=u.getGapWidth(e,i.layout.outerGapWidth),s=u.getGapHeight(e,i.layout.outerGapHeight);Me._needsOuterGaps(e)||(r=Math.min(r,1),s=Math.min(s,1)),t.x+=r,t.w-=2*r,t.y+=s,t.h-=2*s},_needsOuterGaps:e=>{var t=e.getOptions();return!(!l.isFunnel(e)||"on"!==t.styleDefaults.threeDEffect)||!(w.isStandalonePlotArea(e)||w.isStandaloneXAxis(e)||w.isStandaloneYAxis(e)||w.isStandaloneY2Axis(e))},_renderTitles:(e,i,r)=>{var s=e.getOptions();if(s.title.text){var a,n,o=E(e.getEventManager(),i,s.title.text,s.title.style,r.x,r.y,r.w,r.h),l=null!=s.title.hAlign?s.title.hAlign:s.title.halign,h="plotArea"==l.substring(0,8);if(o?(a=(n=o.getDimensions()).h,o.setAriaProperty("hidden",null)):(a=0,n=new t.Rectangle(0,0,0,0)),s.subtitle.text){var g=new t.OutputText(e.getCtx(),s.subtitle.text,r.x,r.y);g.setCSSStyle(s.subtitle.style),i.addChild(g);var d=g.getDimensions(),_=u.getGapWidth(e,s.layout.titleSubtitleGapWidth),c=n.w+_+d.w;if(c>r.w||h)_=u.getGapHeight(e,s.layout.titleSubtitleGapHeight),g.setY(r.y+a+_),t.TextUtils.fitText(g,r.w,r.h,i)&&(a+=(d=g.getDimensions()).h+_,t.Agent.isRightToLeft(e.getCtx())&&(g&&g.setX(r.w-d.w),o&&o.setX(r.w-n.w)));else{var p=n.h-d.h;g.setY(p+r.y),o&&(t.LayoutUtils.align(r,l,o,c),t.Agent.isRightToLeft(e.getCtx())?(g.setX(o.getX()),o.setX(o.getX()+d.w+_)):g.setX(o.getX()+c-d.w)),g.setAriaProperty("hidden",null),e.getEventManager().associate(g,new t.SimpleObjPeer(g.getUntruncatedTextString()))}}else t.LayoutUtils.align(r,l,o,n.w);h&&(e.getCache().putToCache("title",o),e.getCache().putToCache("subtitle",g));var v="on"==s.titleSeparator.rendered?s.layout.titleSeparatorGap:s.layout.titlePlotAreaGap;if(r.y+=a+u.getGapHeight(e,v),r.h-=a+u.getGapHeight(e,v),"on"==s.titleSeparator.rendered){var m=new t.Line(e.getCtx(),r.x,r.y,r.x+r.w,r.y),f=new t.Line(e.getCtx(),r.x,r.y+1,r.x+r.w,r.y+1);m.setSolidStroke(s.titleSeparator.upperColor),f.setSolidStroke(s.titleSeparator.lowerColor),i.addChild(m),i.addChild(f);var x=2+u.getGapHeight(e,s.layout.titlePlotAreaGap);r.y+=x,r.h-=x}}if(s.footnote.text){var C=E(e.getEventManager(),i,s.footnote.text,s.footnote.style,r.x,0,r.w,r.h),S=null!=s.footnote.hAlign?s.footnote.hAlign:s.footnote.halign,A="plotArea"==S.substring(0,8);if(C){var b=C.getDimensions();C.setY(r.y+r.h-b.h),r.h-=b.h+u.getGapHeight(e,s.layout.footnoteGap),t.LayoutUtils.align(r,S,C,b.w),C.setAriaProperty("hidden",null)}A&&e.getCache().putToCache("footnote",C)}},_updateTitles:(e,t,i,r)=>{var s=e.getOptions(),a=null!=s.title.hAlign?s.title.hAlign:s.title.halign,n=null!=s.footnote.hAlign?s.footnote.hAlign:s.footnote.halign,o=s.title.text&&"plotArea"==a.substring(0,8),l=s.footnote.text&&"plotArea"==n.substring(0,8);if(i.x=r.x,i.w=r.w,o){var h,g=e.getCache().getFromCache("title"),d=e.getCache().getFromCache("subtitle"),u=g.getDimensions();Me._alignTextToPlotArea(t,i,a,g,u.w),d&&(h=d.getDimensions(),Me._alignTextToPlotArea(t,i,a,d,h.w))}if(l){var _=e.getCache().getFromCache("footnote"),c=_.getDimensions();Me._alignTextToPlotArea(t,i,n,_,c.w)}},_alignTextToPlotArea:(e,i,r,s,a)=>{t.TextUtils.fitText(s,i.w,i.h,e)&&("plotAreaStart"==r?t.LayoutUtils.align(i,"start",s,a):"plotAreaCenter"==r?t.LayoutUtils.align(i,"center",s,a):"plotAreaEnd"==r&&t.LayoutUtils.align(i,"end",s,a))},_renderPlotArea:(e,i,r)=>{if(l.hasAxes(e)){var s=new t.Container(e.getCtx());s.setTranslate(r.x,r.y),i.addChildAt(s,1),e.setPlotArea(s),e.getEventManager().associate(s,new t.SimpleObjPeer(null,null,null,{type:"plotArea"}));var a=new t.Rectangle(0,0,r.w,r.h);fe.render(e,s,a)}else if(l.isPie(e)){var n=new ye(e,r);n.__getSlices().length>0?(i.addChild(n),e.setPlotArea(n),n.render()):L(e,i,r)}else l.isFunnel(e)?N.render(e,i,r):l.isPyramid(e)&&G.render(e,i,r);r.w=0,r.h=0},_prerenderHorizScrollbar:(e,i,r)=>{var s=r.w,a=0;return O.isScrollable(e)&&O.isHorizScrollbarSupported(e)?c.isOverviewRendered(e)?(a=Math.min(c.getOverviewHeight(e),r.h))>0&&(e.overview=new be(e),i.addChild(e.overview),t.LayoutUtils.position(r,"bottom",e.overview,s,a,10)):(a=e.getOptions().styleDefaults._scrollbarHeight,e.xScrollbar=new t.SimpleScrollbar(e.getCtx(),e.processEvent,e),i.addChild(e.xScrollbar),t.LayoutUtils.position(r,"bottom",e.xScrollbar,s,a,8),e.overview=null):e.overview=null,new t.Dimension(s,a)},_prerenderVertScrollbar:(e,i,r)=>{var s=0,a=r.h;if(O.isScrollable(e)&&O.isVertScrollbarSupported(e)){s=e.getOptions().styleDefaults._scrollbarHeight;var n=new t.SimpleScrollbar(e.getCtx(),e.processEvent,e);i.addChild(n),t.LayoutUtils.position(r,t.Agent.isRightToLeft(e.getCtx())?"right":"left",n,s,a,8),l.isHorizontal(e)?e.xScrollbar=n:e.yScrollbar=n}return new t.Dimension(s,a)},_renderScrollbars:(e,i,r)=>{var s=e.getOptions(),a={color:s.styleDefaults._scrollbarHandleColor,backgroundColor:s.styleDefaults._scrollbarTrackColor},n=e.__getPlotAreaSpace();if(e.xScrollbar&&(a.min=e.xAxis.getLinearGlobalMin(),a.max=e.xAxis.getLinearGlobalMax(),l.isHorizontal(e)?(a.isHorizontal=!1,a.isReversed=!1,e.xScrollbar.setTranslateY(n.y),e.xScrollbar.render(a,r.w,n.h)):(a.isHorizontal=!0,a.isReversed=t.Agent.isRightToLeft(e.getCtx()),e.xScrollbar.setTranslateX(n.x),e.xScrollbar.render(a,n.w,i.h)),e.xScrollbar.setViewportRange(e.xAxis.getLinearViewportMin(),e.xAxis.getLinearViewportMax())),e.yScrollbar&&(a.min=e.yAxis.getLinearGlobalMin(),a.max=e.yAxis.getLinearGlobalMax(),a.isHorizontal=!1,a.isReversed=!0,e.yScrollbar.setTranslateY(n.y),e.yScrollbar.render(a,r.w,n.h),e.yScrollbar.setViewportRange(e.yAxis.getLinearViewportMin(),e.yAxis.getLinearViewportMax())),e.overview){var o=e.Defaults.getNoCloneObject(),h={overview:{xMin:e.xAxis.getLinearGlobalMin(),xMax:e.xAxis.getLinearGlobalMax(),x1:e.xAxis.getLinearViewportMin(),x2:e.xAxis.getLinearViewportMax(),minimumWindowSize:e.xAxis.getInfo().getMinExtent()},chart:t.JsonUtils.clone(s,null,o)};O.isZoomable(e)||(h.featuresOff="zoom"),h.chart._minOverflowCoord=s._minOverflowCoord-n.x,h.chart._maxOverflowCoord=s._maxOverflowCoord-n.x,e.overview.setTranslateX(n.x),e.overview.render(h,n.w,i.h),e.overview.setViewportRange(e.xAxis.getLinearViewportMin(),e.xAxis.getLinearViewportMax())}},_positionLegend:(e,t)=>{if(e){var i=e.getDimensions(),r=e.getOptions().orientation;"vertical"==r&&i.h<=t.h?e.setTranslateY(Math.round(t.y+t.h/2-i.h/2)):"horizontal"==r&&i.w<=t.w&&e.setTranslateX(Math.round(t.x+t.w/2-i.w/2))}},_renderDragButtons:e=>{var i=Me._BUTTON_SIZE+2*(Me._BUTTON_PADDING+Me._BUTTON_CORNER_DIST),r=e.__getPlotAreaSpace();if(!(!l.hasAxes(e)||l.isOverview(e)||r.w<i||r.h<i)){var s=e.getOptions(),a=s._resources,n=s.translations,o=e.getEventManager(),h=s.dragMode;if("user"==h){var g,d,u,_=t.Agent.isTouchDevice(),c=O.isScrollable(e);e.dragButtons=new t.Container(e.getCtx());var p=[],v="multiple"==s.selectionMode&&(_||c),m=c&&_,f=c&&!_&&O.isZoomable(e)&&l.isScatterBubble(e);v&&a.select&&p.push(a.select),m&&a.pan&&p.push(a.pan),f&&a.zoom&&p.push(a.zoom),u=t.ToolkitUtils.getIconStyles(e.getCtx(),p),v&&(d=m||f?"end":"solo",o.selectButton=Me._createDragButton(e,e.dragButtons,u[a.select],o.onSelectButtonClick,o,d),g=n.tooltipSelect,o.selectButton.setTooltip(g),o.associate(o.selectButton,o.selectButton)),m&&(d=v?"start":"solo",o.panButton=Me._createDragButton(e,e.dragButtons,u[a.pan],o.onPanButtonClick,o,d),g=n.tooltipPan,o.panButton.setTooltip(g),o.associate(o.panButton,o.panButton)),f&&(d=v?"start":"solo",o.zoomButton=Me._createDragButton(e,e.dragButtons,u[a.zoom],o.onZoomButtonClick,o,d),g=n.tooltipZoom,o.zoomButton.setTooltip(g),o.associate(o.zoomButton,o.zoomButton)),Me.positionDragButtons(e),o.setDragMode(null),e.dragButtons.getNumChildren()>0&&(e.addChild(e.dragButtons),_?c&&(o.panButton.setToggled(!0),o.onPanButtonClick(null)):e.hideDragButtons(),e.dragButtons.setCursor("default"))}else"pan"==h?o.setDragMode(X.DRAG_MODE_PAN):"zoom"==h?o.setDragMode(X.DRAG_MODE_ZOOM):"select"==h?o.setDragMode(X.DRAG_MODE_SELECT):o.setDragMode(X.DRAG_MODE_OFF)}},_positionDragButton:(e,i,r)=>{var s;t.Agent.isRightToLeft(e.getCtx())?(s=r.x+Me._BUTTON_PADDING,r.x+=Me._BUTTON_SIZE+2*Me._BUTTON_PADDING):s=r.x+r.w-Me._BUTTON_SIZE-Me._BUTTON_PADDING,r.w-=Me._BUTTON_SIZE+2*Me._BUTTON_PADDING,i.setTranslate(s,r.y+Me._BUTTON_PADDING)},positionDragButtons:e=>{var t=e.__getPlotAreaSpace().clone();t.x+=Me._BUTTON_CORNER_DIST,t.w-=2*Me._BUTTON_CORNER_DIST,t.y+=Me._BUTTON_CORNER_DIST;var i=e.getEventManager();i.selectButton&&Me._positionDragButton(e,i.selectButton,t),i.panButton&&Me._positionDragButton(e,i.panButton,t),i.zoomButton&&Me._positionDragButton(e,i.zoomButton,t)},_createDragButtonBackground:(e,i)=>{var r=t.Agent.isRightToLeft(e),s="start"==i&&r||"end"==i&&!r?0:2,a="start"==i&&!r||"end"==i&&r?0:2,n=s,o=a,l=-Me._BUTTON_PADDING,h=Me._BUTTON_SIZE+2*Me._BUTTON_PADDING,g=t.PathUtils.roundedRectangle(l,l,h,h,n,a,o,s),d=new t.Path(e,g);return d.setPixelHinting(t.Agent.getDevicePixelRatio()>1),d},_getImageUrl:(e,t,i,r)=>{var s,a=e.getOptions()._resources[i];return null==a?r:null!=(s=t[a])?s:a},_createDragButton:(e,i,r,s,a,n)=>{var o=e.getCtx(),l=Me._createDragButtonBackground(o,n),h=new t.IconButton(o,"outlined",{style:r,size:Me._BUTTON_SIZE},l,null,s,a);if(t.Agent.isTouchDevice()){var g,d=t.Agent.isRightToLeft(o),u=2*Me._BUTTON_PADDING;(g="solo"==n?new t.Rect(o,-u,-u,Me._BUTTON_SIZE+2*u,Me._BUTTON_SIZE+2*u):"start"==n&&!d||"end"==n&&d?new t.Rect(o,-u,-u,Me._BUTTON_SIZE+1.5*u,Me._BUTTON_SIZE+2*u):new t.Rect(o,-.5*u,-u,Me._BUTTON_SIZE+1.5*u,Me._BUTTON_SIZE+2*u)).setInvisibleFill(),g.setSolidStroke("none"),h.addChild(g)}return h.setToggleEnabled(!0),i.addChild(h),h.addEvtListener(t.MouseEvent.MOUSEDOWN,e=>{e.stopPropagation()}),h},_adjustAvailSpace:e=>{e.x=Math.round(e.x),e.y=Math.round(e.y),e.w=Math.round(e.w),e.h=Math.round(e.h)},renderDataCursor:e=>{var t=null,i=e.getOptions(),r=e.getEventManager();if(m.isDataCursorEnabled(e)){(t=new p(e.getCtx(),i.styleDefaults.dataCursor,l.isHorizontal(e))).setBehavior(m.getDataCursorBehavior(e)),e.addChild(t);var s=new xe(e,t);r.setDataCursorHandler(s),e.positionDataCursor(i.dataCursorPosition)}else r.setDataCursorHandler(null);return t}},De={processDataObj:e=>{if(d.hasData(e)){var i=e.getOptions(),r=e.getOptionsCache(),s=d.getSeriesCount(e);l.isValidType(e)||(i.type="bar");var a=!1,n=!1,o=!0,h=null,g=!1,u=!1,_=!1,p=!1,v=!1,m=l.isStock(e);m&&s>1&&(i.series=i.series.slice(0,1),s=1);var f=l.isMixedFrequency(e),x=s>100;r.putToCache("hasLargeSeriesCount",x);for(var C=0,S=e.getSeriesStyleArray(),A=0;A<s;A++){var b=d.getSeries(e,A);!x&&null!=b&&S.indexOf(b)<0&&S.push(b);var y=d.getSeriesItem(e,A);if(y.items&&y.items.length>C&&(C=y.items.length),"hidden"===y.visibility){var M=d.getHiddenCategories(e);M.indexOf(b)<0&&M.push(b)}if(y.visibility=null,"on"===y.assignedToY2&&(a=!0),"on"===y.displayInLegend&&(p=!0),"on"===y.drilling&&(v=!0),y&&y.items)for(var D,T=y.items,I=0;I<T.length;I++)null!=T[I]&&("object"!=typeof(D=T[I])&&(D={y:D},T[I]=D),f||null==D.x||(D.x=Number(D.x)),null!=D.y&&(D.y=Number(D.y),D.y<0&&(u=!0)),null!=D.z?(D.z=Number(D.z),null==h?h=D.z:h!=D.z&&(o=!1)):h=1,null!=D.value&&(D.value=Number(D.value),D.value<0&&(u=!0)),null!=D.targetValue&&(D.targetValue=Number(D.targetValue)),null!=D.open&&(D.open=Number(D.open),g=!0),null!=D.close&&(D.close=Number(D.close),g=!0,D.close<0&&(u=!0)),null!=D.low&&(D.low=Number(D.low),g=!0),null!=D.high&&(D.high=Number(D.high),g=!0),null!=D.volume&&(D.volume=Number(D.volume),n=!0),(D.color||D.borderColor||D.borderWidth||D.style||D.svgStyle||D.className||D.svgClassName)&&r.putToCachedMap("itemStyleSet",A,!0),"outsideBarEdge"==D.labelPosition&&(_=!0))}if(r.putToCache("hasVolume",n),r.putToCache("hasConstantZValue",o),r.putToCache("constantZValue",o?h:null),r.putToCache("hasLowHighSeries",g),r.putToCache("hasNegativeValues",u),r.putToCache("hasDataOutsideBarEdge",_),r.putToCache("hasSeriesDisplayedInLegend",p),r.putToCache("hasDrillableSeries",v),m&&d.hasVolumeSeries(e)&&!l.isOverview(e)){var O=t.JsonUtils.clone(d.getSeriesItem(e,0));O.assignedToY2="on",a=!0,O.type="bar",O.categories=d.getCategories(e,0),O.id="_volume",O._selectable="off",O.items=[];for(var E=y?y.items.length:0,P=0;P<E;P++){var L={};L.color=c.getStockVolumeColor(e,0,P),L.x=y&&y.items[P].x,L.value=y&&y.items[P].volume,L.drilling="off",O.items.push(L)}i.series.push(O),r.putToCachedMap("itemStyleSet",i.series.length-1,!0)}r.putToCache("hasY2Assignment",a);for(var w=d.getRefObjs(e),R=0;R<w.length;R++){var k=w[R].items;if(k)for(var B=0;B<k.length;B++){var F=k[B];F&&("object"!=typeof F?k[B]=Number(F):(!l.isMixedFrequency(e)&&F.x&&(F.x=Number(F.x)),F.max&&(F.max=Number(F.max)),F.min&&(F.min=Number(F.min)),F.value&&(F.value=Number(F.value))))}}i.groups||(i.groups=[]);for(var N=d.getGroupCount(e),H=0;H<C-N;H++){var G=i.translations.labelDefaultGroupName||"Group {0}",U=t.ResourceUtils.format(G,[i.groups.length+1]);i.groups.push(U)}r.putToCache("groupsArray",null),De._processTimeAxis(e);var V=i.sorting;if(V="on"===V?"descending":"ascending"!==V&&"descending"!==V?"off":V,l.isBLAC(e)&&l.hasGroupAxis(e)&&"off"!=V&&1==d.getNumLevels(e)){for(var Y=d.getGroups(e),W={},j=0;j<Y.length;j++){for(var z=0,X=0;X<=s;X++)if(d.isSeriesRendered(e,X)&&!d.isAssignedToY2(e,X)){var Z=d.getVal(e,X,j);z+=null==Z||isNaN(Z)?0:Z}W[Y[j]]={index:j,total:z,group:i.groups[j]}}"ascending"===V?Y.sort((e,t)=>W[e].total-W[t].total):Y.sort((e,t)=>W[t].total-W[e].total);for(var K=0;K<s;K++){for(var q=[],Q=0;Q<Y.length;Q++)q.push(d.getDataItem(e,K,W[Y[Q]].index));i.series[K].items=q}for(var J=[],$=0;$<Y.length;$++)J.push(W[Y[$]].group);i.groups=J,r.putToCache("groupsArray",null),r.putToCache("value",null)}i.styleDefaults.dataCursor.lineWidth=parseFloat(i.styleDefaults.dataCursor.lineWidth),De._sanitizeAxis(i.xAxis),De._sanitizeAxis(i.yAxis),De._sanitizeAxis(i.y2Axis)}},_processTimeAxis:e=>{var t,i,r=e.getCtx(),s=e.getOptions(),a=d.getSeriesCount(e),n=d.getGroupCount(e);if(l.isMixedFrequency(e))for(t=0;t<a;t++)for(i=0;i<n;i++){var o=d.getDataItem(e,t,i);null!=o&&"string"==typeof o.x&&null!=o.x&&(o.x=De._sanitizeDateTime(r,o.x))}else if(l.hasTimeAxis(e)){for(i=0;i<n;i++){var h=d.getGroup(e,i);null!=h&&(s.groups[i]=De._sanitizeDateTime(r,h))}e.getOptionsCache().putToCache("groupsArray",null)}if(l.hasTimeAxis(e)){var g=s.xAxis;null!=g.dataMin&&(g.dataMin=De._sanitizeDateTime(r,g.dataMin)),null!=g.dataMax&&(g.dataMax=De._sanitizeDateTime(r,g.dataMax)),null!=g.min&&(g.min=De._sanitizeDateTime(r,g.min)),null!=g.max&&(g.max=De._sanitizeDateTime(r,g.max)),null!=g.viewportMin&&(g.viewportMin=De._sanitizeDateTime(r,g.viewportMin)),null!=g.viewportMax&&(g.viewportMax=De._sanitizeDateTime(r,g.viewportMax)),null!=g.viewportStartGroup&&(g.viewportStartGroup=De._sanitizeDateTime(r,g.viewportStartGroup)),null!=g.viewportEndGroup&&(g.viewportEndGroup=De._sanitizeDateTime(r,g.viewportEndGroup));for(var u=d.getRefObjs(e),_=0;_<u.length;_++){var c=u[_].items;if(c)for(var p=0;p<c.length;p++)c[p]&&null!=c[p].x&&(c[p].x=De._sanitizeDateTime(r,c[p].x))}}},_sanitizeAxis:e=>{e.min==e.max&&(e.min=null,e.max=null)},_sanitizeDateTime:(e,t)=>{var i=null,r=e.getLocaleHelpers().isoToDateConverter;if(r){try{i=r(t)}catch(e){i=null}i=null!=i&&i.getTime?i.getTime():null}return null==i?isNaN(t)?Date.parse(t):t:i}};class Te extends t.BaseComponent{constructor(e,i,r,s){super(e,i,r,s),s||(this.Defaults=new u(e),this.EventManager=new X(this),this.EventManager.addListeners(this),t.Agent.isTouchDevice()||this.EventManager.setKeyboardHandler(this.CreateKeyboardHandler(this.EventManager)),this.setId("chart1000"+Math.floor(1e9*Math.random())),this.legend=null,this.xAxis=null,this.yAxis=null,this.y2Axis=null,this.overview=null,this.xScrollbar=null,this.yScrollbar=null,this.dragButtons=null,this.pieChart=null,this.pieCenterDiv=null,this.Peers=[],this.SeriesStyleArray=[],this._numFrontObjs=0,this._numSelectedObjsInFront=0,this._dataLabels=null,this._rawOptions=null)}static getDefaults(e){return(new u).getDefaults(e)}createOverviewChart(){return new Te(this.getCtx())}GetComponentDescription(){var e=this.getOptions(),i=e.translations.componentName,r="",s=t.AriaUtils.ARIA_LABEL_DESC_DELIMITER;return e.title.text&&(r+=this.Options.title.text,e.subtitle.text&&(r+=s+this.Options.subtitle.text)),e.footnote.text&&(r=0==r.length?this.Options.footnote.text:r.concat(s,this.Options.footnote.text)),r.length>0?t.ResourceUtils.format(this.Options.translations.labelAndValue,[i,r]):i}SetOptions(e){e?(this._rawOptions=e,this.Options=this.Defaults.calcOptions(e),this.getOptionsCache().clearCache(),De.processDataObj(this),(t.Agent.isEnvironmentTest()||l.isScatterBubble(this)&&d.getSeriesCount(this)*d.getGroupCount(this)>fe.FILTER_THRESHOLD_SCATTER_BUBBLE)&&(this.Options.animationOnDisplay="none",this.Options.animationOnDataChange="none")):this.Options||(this.Options=this.GetDefaults());var i=this.Options.selectionMode;this._selectionHandler="single"==i?new t.SelectionHandler(this.getCtx(),t.SelectionHandler.TYPE_SINGLE):"multiple"==i?new t.SelectionHandler(this.getCtx(),t.SelectionHandler.TYPE_MULTIPLE):null,this.EventManager.setSelectionHandler(this._selectionHandler)}render(e,i,r){this.getCache().clearCache();var s=this.getCtx(),a=this.Options?this.Options.animationOnDataChange:"none",n="none"!=a?new Ie(this):null,o=this.__cacheChartFocus();this._container&&this.__cleanUp(),this.SetOptions(e),isNaN(i)||isNaN(r)||(this.Width=i,this.Height=r);var h=new t.Container(s);this.addChild(h),Me.render(this,h,new t.Rectangle(0,0,this.Width,this.Height)),l.isSpark(this)&&this.EventManager.removeListeners(this),this.StopAnimation();var g=c.getAnimOnDisplay(this),d=c.getAnimDur(this),u=new t.Rectangle(0,0,this.Width,this.Height),_=!1;if(this._container){if("none"!=a&&e)if(this.Animation=t.BlackBoxAnimationHandler.getCombinedAnimation(s,a,this._container,h,u,d),this.Animation)_=!0;else if("auto"==a&&this.getPlotArea()){var p=this.__getPlotAreaSpace();this._delContainer=fe.createClippedGroup(this,this._container,new t.Rectangle(0,0,p.w,p.h)),this.Animation=ue.createAnim(n,this,a,d,this._delContainer),this._delContainer.getNumChildren()>0&&this.getPlotArea().addChild(this._delContainer)}}else"none"!=g&&(this.Animation=t.BlackBoxAnimationHandler.getInAnimation(s,g,h,u,d),this.Animation||"auto"!=g||(this.Animation=_e.createAnim(this,g,d)));this.Animation?(this.EventManager.removeListeners(this),t.Playable.appendOnEnd(this.Animation,this._onAnimationEnd,this),this.Animation.play(),this._oldContainer=this._container,!_&&this._oldContainer&&this._oldContainer.removeFromParent()):this._container&&(this._container.removeFromParent(),this._container.destroy(),this._container=null),this._container=h,this._dataCursor=Me.renderDataCursor(this),this.UpdateAriaAttributes(),this.__restoreChartFocus(o),this.Animation||this.RenderComplete()}__cleanUp(){this._dataCursor&&(this.removeChild(this._dataCursor),this._dataCursor=null),this.EventManager&&(this.EventManager.hideHoverFeedback(),this.EventManager.setPanZoomHandler(null),this.EventManager.setMarqueeZoomHandler(null),this.EventManager.setMarqueeSelectHandler(null),this.EventManager.panButton=null,this.EventManager.zoomButton=null,this.EventManager.selectButton=null),this.pieCenterDiv&&(this.getCtx().getContainer().removeChild(this.pieCenterDiv),this.pieCenterDiv=null),this.Peers=[],this.xScrollbar=null,this.yScrollbar=null,this.dragButtons&&(this.removeChild(this.dragButtons),this.dragButtons.destroy(),this.dragButtons=null),this._plotArea=null,this._areaContainer=null,this._dataLabels=null,this.getCache().clearCache()}__cleanUpAxisAndPlotArea(){this.EventManager.hideHoverFeedback(),this.Peers=[],this.xAxis&&(this._container.removeChild(this.xAxis),this.xAxis.destroy()),this.yAxis&&(this._container.removeChild(this.yAxis),this.yAxis.destroy()),this.y2Axis&&(this._container.removeChild(this.y2Axis),this.y2Axis.destroy()),this._plotArea&&this._plotArea==this._panZoomTarget?this._plotArea.setVisible(!1):this._plotArea&&(this._container.removeChild(this._plotArea),this._plotArea.destroy()),this._plotArea=null,this.getCache().clearCache()}_onAnimationEnd(){this._oldContainer&&(this._oldContainer.removeFromParent(),this._oldContainer.destroy(),this._oldContainer=null),this._delContainer&&(this._delContainer.removeFromParent(),this._delContainer.destroy(),this._delContainer=null),this.AnimationStopped||this.RenderComplete(),this.EventManager.addListeners(this),this.Animation=null,this.AnimationStopped=!1}CreateKeyboardHandler(e){return new Z(e,this)}getAutomation(){return new z(this)}getValsAt(e,t){var i=this.__getPlotAreaSpace(),r=e-i.x,s=t-i.y,a=l.isPolar(this),n=l.isHorizontal(this);if(a){r-=i.w/2,s-=i.h/2;var o=Math.sqrt(r*r+s*s),h=Math.atan2(r,-s);return h<0&&(h+=2*Math.PI),{x:this.xAxis?this.xAxis.getValAt(h):null,y:this.yAxis?this.yAxis.getValAt(o):null}}return{x:this.xAxis?this.xAxis.getValAt(n?s:r):null,y:this.yAxis?this.yAxis.getValAt(n?r:s):null,y2:this.y2Axis?this.y2Axis.getValAt(n?r:s):null}}filter(e,t){var i="out"==t?"hidden":"visible";F.setVisibility(this,e,i),this.render(this.Options)}highlight(e){this.getOptions().highlightedCategories=t.JsonUtils.clone(e),t.CategoryRolloverHandler.highlight(e,this.getObjects(),"any"==this.getOptions().highlightMatch),this.legend&&this.legend.highlight(e),this.pieChart&&this.pieChart.highlight(e),this.overview&&this.overview.getBackgroundChart().highlight(e)}select(e){this.getOptions().selection=t.JsonUtils.clone(e);var i=d.getInitialSelection(this);F.setInitialSelection(this,i),this.pieChart&&this.pieChart.setInitialSelection()}positionDataCursor(e){var i=this.getEventManager().getDataCursorHandler();if(i){if(e){var r=this.xAxis&&null!=e.x?this.xAxis.getCoordAt(e.x):null,s=null;if(l.isBLAC(this)?this.yAxis&&null!=e.y?s=this.yAxis.getBoundedCoordAt(e.y):this.y2Axis&&null!=e.y2&&(s=this.yAxis.getBoundedCoordAt(e.y2)):s=this.yAxis&&null!=e.y?this.yAxis.getCoordAt(e.y):null,null!=r&&null!=s){var a=this.__getPlotAreaSpace(),n=h.convertAxisCoord(this,new t.Point(r,s),a);return void i.processMove(new t.Point(a.x+n.x,a.y+n.y),!0)}}i.processEnd(!0)}}processEvent(e,t){var i=e.type;if("categoryHide"==i||"categoryShow"==i)this.filter(e.category,"categoryHide"==i?"out":"in");else if("categoryHighlight"==i)this!=t&&this.highlight(e.categories),this.legend&&this.legend!=t&&this.legend.processEvent(e,t);else if("selection"==i)e=this._processSelectionEvent(e);else if("dvtPanZoom"==i)e=this._processPanZoomEvent(e);else if("dvtMarquee"==i)e=this._processMarqueeEvent(e);else if("overview"==i){var r=e.subtype;if("dropCallback"==r)return;var s="scrollTime"==r||"scrollEnd"==r||"rangeChange"==r;e=this._processScrollbarEvent(e.newX1,e.newX2,s,t)}else if("dvtSimpleScrollbar"==i)e=this._processScrollbarEvent(e.newMin,e.newMax,"end"==e.subtype,t);else if("ready"==i&&this!=t)return;if(e){if("selection"==(i=e.type)){var a,n,o=this.getOptions(),l=o.selection,h=d.getCurrentSelection(this);e.complete&&(o.selection=h),l=l||[],h=h||[];var g={};for(a=0;a<l.length;a++)g[l[a].id]=!0;var u={};for(n=0;n<h.length;n++)u[h[n].id]=!0;var _={};for(n=0;n<h.length;n++){var c=h[n].id;g[c]||(_[c]=!0)}var p={};for(a=0;a<l.length;a++){var v=l[a].id;u[v]||(p[v]=!0)}e.addedSet=_,e.removedSet=p;for(var m=0;m<e.selection.length;m++)F.addEventData(this,e.selection[m]);e.component=this.getOptions()._widgetConstructor}else if("drill"===i){if(e.subType||(e.subType="_dvtOther"===e.id?"multiSeries":"series",e.series=e.id),this._processDrillSubType(e),"multiSeries"===e.subType)return;F.addEventData(this,e),delete e.subType,e.component=this.getOptions()._widgetConstructor}this.dispatchEvent(e)}}_processDrillSubType(e){var t,i=e.subType;"item"===i?t=F.addItemDrillEventData(this,e):"group"===i?t=F.addGroupDrillEventData(this,e):"series"===i?t=F.addSeriesDrillEventData(this,e):"multiSeries"===i&&(t=F.addMultiSeriesDrillEventData(this,e)),this.dispatchEvent(t)}_processSelectionEvent(e){var i=F.processIds(this,e.selection);return this._updateOverviewSelection(),t.EventFactory.newChartSelectionEvent(i,!0)}_processPanZoomEvent(e){var i=e.subtype;return"panStart"==i||"pinchStart"==i?(t.Agent.isTouchDevice()&&this._panZoomTarget!=this._plotArea&&(this._container.removeChild(this._panZoomTarget),this._panZoomTarget=this._plotArea),null):(this._lastPanZoomEvent?(e.dxMin+=this._lastPanZoomEvent.dxMin,e.dxMax+=this._lastPanZoomEvent.dxMax,e.dyMin+=this._lastPanZoomEvent.dyMin,e.dyMax+=this._lastPanZoomEvent.dyMax):t.Context.requestAnimationFrame(t.Obj.createCallback(this,this._animatePanZoomEvent)),this._lastPanZoomEvent=e,null)}_animatePanZoomEvent(){var e=this._lastPanZoomEvent;this._lastPanZoomEvent=null;var i,r,s=e.subtype,a="panEnd"==s||"zoom"==s||"pinchEnd"==s;(O.isLiveScroll(this)?(i=F.getAxisBoundsByDelta(this,e.dxMin,e.dxMax,e.dyMin,e.dyMax),this._setScrollbarViewport(i),this._setViewport(i,a)):(i=F.getAxisBoundsByDelta(this,e.dxMinTotal,e.dxMaxTotal,e.dyMinTotal,e.dyMaxTotal),this._setScrollbarViewport(i),a&&this._setViewport(i,a)),a&&(Me._setEventHandlers(this),this._panZoomTarget!=this._plotArea&&(this._container.removeChild(this._panZoomTarget),this._panZoomTarget=null)),a||!i.unchanged)&&(r=l.isBLAC(this)?t.EventFactory.newChartViewportChangeEvent(a,i.xMin,i.xMax,i.startGroup,i.endGroup,null,null):t.EventFactory.newChartViewportChangeEvent(a,i.xMin,i.xMax,null,null,i.yMin,i.yMax),this.dispatchEvent(r))}_processMarqueeEvent(e){var i,r=e.subtype,s=this.EventManager;if(F.adjustBounds(e),s.getDragMode()==X.DRAG_MODE_SELECT){var a=s.getSelectionHandler();if("start"==r)this._initSelection=e.ctrlKey?a.getSelectedIds():[];else{var n=F.getBoundedObjs(this,e);a.processInitialSelections(this._initSelection,this.getChartObjPeers()),a.processGroupSelection(n,!0)}var o=a.getSelectedIds();i=F.getAxisBounds(this,e,!1);var h="end"==r,g=t.EventFactory.newChartSelectionEvent(o,h,i.xMin,i.xMax,i.startGroup,i.endGroup,i.yMin,i.yMax,i.y2Min,i.y2Max);return"end"==r&&this._updateOverviewSelection(),g}return s.getDragMode()==X.DRAG_MODE_ZOOM?"end"!=r?null:(i=F.getAxisBounds(this,e,!0),this._setViewport(i,!0),this._setScrollbarViewport(i),Me._setEventHandlers(this),l.isBLAC(this)?t.EventFactory.newChartViewportChangeEvent(!0,i.xMin,i.xMax,i.startGroup,i.endGroup,null,null):t.EventFactory.newChartViewportChangeEvent(!0,i.xMin,i.xMax,null,null,i.yMin,i.yMax)):null}_processScrollbarEvent(e,i,r,s){return this._lastScrollbarEvent||t.Context.requestAnimationFrame(t.Obj.createCallback(this,this._animateScrollbarEvent)),this._lastScrollbarEvent={start:e,end:i,actionDone:r,source:s},null}_animateScrollbarEvent(){var e=this._lastScrollbarEvent.start,i=this._lastScrollbarEvent.end,r=this._lastScrollbarEvent.actionDone,s=this._lastScrollbarEvent.source;this._lastScrollbarEvent=null;var a=s==this.yScrollbar?this.yAxis:this.xAxis,n=F.getActualMinMax(a,e,i);if(e=n.min,i=n.max,(O.isLiveScroll(this)||r)&&(s==this.yScrollbar?this._setViewport({yMin:e,yMax:i},r):this._setViewport({xMin:e,xMax:i,unchanged:n.unchanged},r)),r||!n.unchanged){var o;if(s==this.yScrollbar)o=t.EventFactory.newChartViewportChangeEvent(r,null,null,null,null,e,i,null,null);else{var l=F.getAxisStartEndGroup(this.xAxis,e,i);o=t.EventFactory.newChartViewportChangeEvent(r,e,i,l.startGroup,l.endGroup,null,null,null,null)}this.dispatchEvent(o)}}_updateOverviewSelection(){if(this.overview){var e=this.overview.getBackgroundChart();e.getOptions().selection=d.getCurrentSelection(this),e.render()}}changeOption(e,i,r){this.getOptions()[e]=i,this.dispatchEvent(t.EventFactory.newOptionChangeEvent(e,i,r))}registerObject(e){this.Peers.push(e)}getObjects(){return this.Peers}getChartObjPeers(){for(var e=[],t=0;t<this.Peers.length;t++)this.Peers[t]instanceof f&&e.push(this.Peers[t]);return e}getRefObjPeers(){for(var e=[],t=0;t<this.Peers.length;t++)this.Peers[t]instanceof x&&e.push(this.Peers[t]);return e}getObject(e,t){for(var i=0;i<this.Peers.length;i++)if(this.Peers[i]instanceof f&&this.Peers[i].getSeriesIndex()==e&&this.Peers[i].getGroupIndex()==t)return this.Peers[i];return null}getWidth(){return this.Width}getHeight(){return this.Height}getSeriesStyleArray(){return this.SeriesStyleArray}getPlotArea(){return this._plotArea}setPlotArea(e){this._plotArea=e}getType(){return this.getOptions().type}getSkin(){return this.getOptions().skin}getGapWidthRatio(){var e=this.getOptions();return null!==e.layout.gapWidthRatio?e.layout.gapWidthRatio:Math.min(this.Width/400,1)}getGapHeightRatio(){var e=this.getOptions();return null!==e.layout.gapHeightRatio?e.layout.gapHeightRatio:Math.min(this.Height/300,1)}getSelectionHandler(){return this._selectionHandler}isSelectionSupported(){return!!this._selectionHandler}_setViewport(e,t){!t&&e.unchanged||(null!=e.xMax&&(this.Options.xAxis.viewportMax=e.xMax),null!=e.xMin&&(this.Options.xAxis.viewportMin=e.xMin),l.isBLAC(this)?(this.Options.xAxis.viewportStartGroup=null,this.Options.xAxis.viewportEndGroup=null,this.Options._initialZoomed=!1):(null!=e.yMax&&(this.Options.yAxis.viewportMax=e.yMax),null!=e.yMin&&(this.Options.yAxis.viewportMin=e.yMin)),this.Options._duringZoomAndScroll=!t,Me.rerenderAxisAndPlotArea(this,this._container))}_setScrollbarViewport(e){if(this.xAxis&&null!=e.xMin&&null!=e.xMax){var t=this.xAxis.actualToLinear(e.xMin),i=this.xAxis.actualToLinear(e.xMax);this.overview&&this.overview.setViewportRange(t,i),this.xScrollbar&&this.xScrollbar.setViewportRange(t,i)}if(this.yAxis&&null!=e.yMin&&null!=e.yMax){var r=this.yAxis.actualToLinear(e.yMin),s=this.yAxis.actualToLinear(e.yMax);this.yScrollbar&&this.yScrollbar.setViewportRange(r,s)}}__setAxisSpace(e){var t,i;this._axisSpace=e,w.isAxisRendered(this,"x")?(t=.8*e.w,i=e.h-4*w.getTickLabelHeight(this,"x")):w.isAxisRendered(this,"y")?(t=e.w,i=e.h-w.getTickLabelHeight(this,"y")):(t=e.w,i=e.h),this._radius=Math.min(t,i)/2}__getAxisSpace(){return this._axisSpace}__setPlotAreaSpace(e){this._plotAreaSpace=e}__getPlotAreaSpace(){return this._plotAreaSpace}__setAreaContainer(e){this._areaContainer=e}__getAreaContainer(){return this._areaContainer}getRadius(){return this._radius}showDragButtons(){this.dragButtons&&this.dragButtons.setVisible(!0)}hideDragButtons(){this.dragButtons&&this.dragButtons.setVisible(!1)}addDataLabel(e){this.getDataLabels().push(e)}getDataLabels(){return this._dataLabels||(this._dataLabels=[]),this._dataLabels}__cacheChartFocus(){var e=this.EventManager.getFocus();if(e)var t=e.isShowingKeyboardFocusEffect();if(this.xAxis){var i=this.xAxis.getKeyboardFocus();if(i)var r=i.isShowingKeyboardFocusEffect()}if(this.legend){var s=this.legend.getKeyboardFocus();if(s)var a=s.isShowingKeyboardFocusEffect()}return{chartFocus:e,chartShowingFocusEffect:t,axisFocus:i,axisShowingFocusEffect:r,legendFocus:s,legendShowingFocusEffect:a,sorting:this.getOptions().sorting}}__restoreChartFocus(e){if(!l.isOverview(this)&&!l.isSpark(this)){var t=[this];if(this.xAxis&&this.xAxis.isNavigable()&&t.push(this.xAxis),this.legend&&this.legend.isNavigable()&&t.push(this.legend),this.getCtx().setKeyboardFocusArray(t),e.legendFocus&&(this.legend.setKeyboardFocus(e.legendFocus,e.legendShowingFocusEffect),e.legendShowingFocusEffect&&this.getCtx().setCurrentKeyboardFocus(this.legend)),this.Options.sorting!=e.sorting){if(e.chartFocus){var i=F.getKeyboardNavigables(this);this.EventManager.setFocusObj(this.EventManager.getKeyboardHandler().getDefaultNavigable(i))}return e.axisFocus&&this.xAxis.setKeyboardFocus(this.xAxis.EventManager.getKeyboardHandler().getDefaultNavigable(this.xAxis.__getKeyboardObjects()),e.axisShowingFocusEffect),void(e.axisShowingFocusEffect&&this.getCtx().setCurrentKeyboardFocus(this.xAxis))}if(e.chartFocus){for(var r=F.getKeyboardNavigables(this),s=!1,a=0;a<r.length;a++){var n=r[a].getId();if(n instanceof o&&n.equals(e.chartFocus.getId())){this.EventManager.setFocusObj(r[a]),e.chartShowingFocusEffect&&r[a].showKeyboardFocusEffect(),s=!0;break}}s||this.EventManager.setFocusObj(this.EventManager.getKeyboardHandler().getDefaultNavigable(r))}e.axisFocus&&(this.xAxis.setKeyboardFocus(e.axisFocus,e.axisShowingFocusEffect),e.axisShowingFocusEffect&&this.getCtx().setCurrentKeyboardFocus(this.xAxis))}}getRawOptions(){return this._rawOptions}}class Ie extends Te{constructor(e){super(null,null,null,!0),this.Options=e.Options,this.Peers=e.Peers,this.SeriesStyleArray=e.SeriesStyleArray,this.Cache=e.Cache,this.pieChart=e.pieChart,this._optionsCache=new t.BaseComponentCache,this._cache=new t.BaseComponentCache}getCache(){return this._cache}getOptionsCache(){return this._optionsCache}}class Oe extends t.Automation{getDataItem(e){var t=this._comp.__getChart().getAutomation().getDataItem(0,e);return t?{borderColor:t.borderColor,color:t.color,date:t.x,low:t.low,high:t.high,value:null==t.low||null==t.high?t.value:t.high-t.low}:null}}class Ee extends t.BaseComponentDefaults{constructor(e){super({alta:{skin:t.CSSStyle.SKIN_ALTA,type:"line",animationOnDisplay:"none",animationOnDataChange:"none",areaSvgClassName:"",emptyText:null,color:"#267db3",firstColor:"",lastColor:"",highColor:"",lowColor:"",visualEffects:"auto",baselineScaling:"min",barSpacing:"auto",lineWidth:1,lineStyle:"solid",lineType:"straight",markerSize:5,markerShape:"auto",barGapRatio:.25,referenceObjects:[],svgClassName:"",_statusMessageStyle:new t.CSSStyle("font-size: 12px; color: #404259;")}},e)}}class Pe extends t.EventManager{constructor(e){super(e.getCtx(),e.dispatchEvent,e,e),this._sparkChart=e}ProcessKeyboardEvent(e){if(!this.KeyboardHandler)return!1;if(e.keyCode==t.KeyboardEvent.TAB){var i=this._sparkChart.getCtx().getStageAbsolutePosition();this.ProcessObjectTooltip(e,i.x,i.y,this._sparkChart.__getLogicalObj(),this._sparkChart)}return!1}OnBlur(e){super.OnBlur(e),this.hideTooltip()}}const Le={render:(e,t,i)=>{var r=e.__getChart(),s=Le._convertOptionsObj(e),a=e.getOptions();if("area"==a.type||"line"==a.type||"lineWithArea"==a.type){var n=Le._getDataItems(e),o=!1;if(a.firstColor||a.lastColor||a.highColor||a.lowColor)o=!0;else for(var l=0;l<n.length;l++)if(n[l]&&"on"==n[l].markerDisplayed){o=!0;break}if(o&&n.length>0||"none"==a.lineType){var h=a.markerSize/2;t-=2*h,i-=2*h,r.setTranslate(h,h)}}r.render(s,t,i)},_getDataItems:e=>{var t=e.getOptions();return t&&t.items?t.items:[]},_convertOptionsObj:e=>{for(var i=e.getOptions(),r={styleDefaults:{},xAxis:{},yAxis:{},groups:[],translations:i.translations},s=[],a=-1,n=-1,o=-1/0,l=1/0,h=Le._getDataItems(e),g=0;g<h.length;g++){var d=h[g],u={};d instanceof Object?(u.value=d.value,u.low=d.low,u.high=d.high,d.date&&(r.timeAxisType="enabled",r.groups.push(d.date)),"on"==d.markerDisplayed&&(u.markerDisplayed="on"),d.color&&(u.color=d.color),d.borderColor&&(u.borderColor=d.borderColor),d.markerShape&&(u.markerShape=d.markerShape),d.markerSize&&(u.markerSize=d.markerSize),(d.className||d.svgClassName)&&(u.svgClassName=d.className||d.svgClassName),(d.style||d.svgStyle)&&(u.svgStyle=d.style||d.svgStyle)):u.value=d,s.push(u);var _=null!=u.value?u.value:Math.max(u.low,u.high);o<_&&(o=_,a=g);var c=null!=u.value?u.value:Math.min(u.low,u.high);l>c&&(l=c,n=g)}if(i.highColor&&a>=0&&(s[a].markerDisplayed="on",s[a].color||(s[a].color=i.highColor)),i.lowColor&&n>=0&&(s[n].markerDisplayed="on",s[n].color||(s[n].color=i.lowColor)),i.firstColor&&s.length>0&&(s[0].markerDisplayed="on",s[0].color||(s[0].color=i.firstColor)),i.lastColor&&s.length>0&&(s[s.length-1].markerDisplayed="on",s[s.length-1].color||(s[s.length-1].color=i.lastColor)),r.series=[{items:s,areaColor:i.areaColor,svgClassName:i.className||i.svgClassName,svgStyle:i.style||i.svgStyle,areaSvgClassName:i.areaClassName||i.areaSvgClassName,areaStyle:i.areaStyle||i.areaSvgStyle}],i.referenceObjects&&i.referenceObjects.length>0){var p;r.yAxis.referenceObjects=i.referenceObjects,r._defaultReferenceObjectLineWidth=1;for(var v=0;v<i.referenceObjects.length;v++)"area"===(p=i.referenceObjects[v]).type?(null!=p.high&&(o=Math.max(o,p.high),l=Math.min(l,p.high)),null!=p.low&&(o=Math.max(o,p.low),l=Math.min(l,p.low))):null!=p.value&&(o=Math.max(o,p.value),l=Math.min(l,p.value))}r.__spark=!0;var m=i.barSpacing;"auto"==m&&(m=t.Agent.getDevicePixelRatio()>1?"subpixel":"pixel"),r.__sparkBarSpacing=m,r.type=i.type,r.animationOnDataChange=i.animationOnDataChange,r.animationOnDisplay=i.animationOnDisplay,r.emptyText=i.emptyText,i.color&&(r.styleDefaults.colors=[i.color]),r.styleDefaults.animationDuration=i.animationDuration,r.styleDefaults.animationIndicators="none",r.styleDefaults.lineWidth=i.lineWidth,r.styleDefaults.lineStyle=i.lineStyle,r.styleDefaults.lineType=i.lineType,r.styleDefaults.markerSize=i.markerSize,r.styleDefaults.markerShape=i.markerShape,r.styleDefaults.barGapRatio=i.barGapRatio,r.styleDefaults.dataItemGaps="0%",r.xAxis.rendered="off",r.yAxis.rendered="off";var f="zero"==i.baselineScaling,x=o!=l?.1*(o-l):.1*Math.abs(o);return r.yAxis.min=f&&l>=0?0:l-x,r.yAxis.max=f&&o<=0?0:o+x,"none"==i.visualEffects||"area"!=i.type&&"lineWithArea"!=i.type?r.styleDefaults.seriesEffect="color":r.styleDefaults.seriesEffect="gradient",r.layout={gapWidthRatio:0,gapHeightRatio:0},r.legend={rendered:"off"},r._statusMessageStyle=i._statusMessageStyle,r}};class we extends t.BaseComponent{constructor(e,i,r){super(e,i,r),e.getStage().setCursor(""),this.Defaults=new Ee(e),this.EventManager=new Pe(this),this.EventManager.addListeners(this),this._chart=new Te(e,this._onRenderEnd,this),this.addChild(this._chart),t.Agent.isTouchDevice()||this.EventManager.setKeyboardHandler(new t.KeyboardHandler(this.EventManager,this)),this._tooltipMask=new t.Rect(e),this.addChild(this._tooltipMask),this.setId("sparkChart1000"+Math.floor(1e9*Math.random()))}SetOptions(e){e?(this.Options=this.Defaults.calcOptions(e),t.Agent.isEnvironmentTest()&&(this.Options.animationOnDisplay="none",this.Options.animationOnDataChange="none")):this.Options||(this.Options=this.GetDefaults())}setId(e){super.setId(e),this._chart&&this._chart.setId(e+"chart")}render(e,i,r){this.SetOptions(e),isNaN(i)||isNaN(r)||(this.Width=i,this.Height=r),this._eventReceived=!1,this._isDoneRendering=!1,Le.render(this,this.Width,this.Height);var s=this.Options.shortDesc;this._tooltipMask.setWidth(this.Width),this._tooltipMask.setHeight(this.Height),this._tooltipMask.setInvisibleFill();var a=this.Options.tooltip,n=a?a.renderer:null,o=this.Options.color;if(n){var l={component:this.Options._widgetConstructor,color:o};this._peer=new t.CustomDatatipPeer(this.getCtx().getTooltipManager(),n,o,l),this.EventManager.associate(this._tooltipMask,this._peer)}else s?(this._peer=new t.SimpleObjPeer(null,s,o),this.EventManager.associate(this._tooltipMask,this._peer)):this._peer=null;this.Options._selectingCursor&&this.setCursor(t.SelectionEffectUtils.getSelectingCursor()),this.UpdateAriaAttributes(),this._eventReceived&&this.RenderComplete(),this._isDoneRendering=!0}_onRenderEnd(e){this._eventReceived=!0,"ready"==e.type&&this._isDoneRendering&&this.RenderComplete()}__getChart(){return this._chart}getAutomation(){return new Oe(this)}UpdateAriaAttributes(){var e=t.Displayable.generateAriaLabel(t.AriaUtils.processAriaLabel(this.GetComponentDescription()),this.Options.shortDesc?[this.Options.shortDesc]:null),i=this.Options.translations;this.IsParentRoot()?(this.getCtx().setAriaRole("img"),this.getCtx().setAriaLabel(t.ResourceUtils.format(i.labelAndValue,[i.labelDataVisualization,e]))):(this.setAriaRole("img"),this.setAriaProperty("label",e))}__getLogicalObj(){return this._peer}}e.Chart=Te,e.SparkChart=we,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=ojchart-toolkit.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojchart',["ojs/ojcore-base","ojs/ojdvt-base","ojs/ojcomponentcore","jquery","ojs/ojconverterutils-i18n","ojs/ojconverter-number","ojs/ojlogger","ojs/ojchart-toolkit"],function(e,t,r,n,o,i,a,s){"use strict";e=e&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e,t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t,n=n&&Object.prototype.hasOwnProperty.call(n,"default")?n.default:n;var l={properties:{animationOnDataChange:{type:"string",enumValues:["auto","none","slideToLeft","slideToRight"],value:"none"},animationOnDisplay:{type:"string",enumValues:["alphaFade","auto","none","zoom"],value:"none"},as:{type:"string",value:""},coordinateSystem:{type:"string",enumValues:["cartesian","polar"],value:"cartesian"},data:{type:"object",extension:{webelement:{exceptionStatus:[{type:"deprecated",since:"11.0.0",description:"Data sets from a DataProvider cannot be sent to WebDriverJS; use ViewModels or page variables instead."}]}}},dataCursor:{type:"string",enumValues:["auto","off","on"],value:"auto"},dataCursorBehavior:{type:"string",enumValues:["auto","smooth","snap"],value:"auto"},dataCursorPosition:{type:"object",writeback:!0,properties:{x:{type:"number|string"},y:{type:"number"},y2:{type:"number"}}},dataLabel:{type:"function"},dnd:{type:"object",properties:{drag:{type:"object",properties:{groups:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},drag:{type:"function"},dragEnd:{type:"function"},dragStart:{type:"function"}}},items:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},drag:{type:"function"},dragEnd:{type:"function"},dragStart:{type:"function"}}},series:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},drag:{type:"function"},dragEnd:{type:"function"},dragStart:{type:"function"}}}}},drop:{type:"object",properties:{legend:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},dragEnter:{type:"function"},dragLeave:{type:"function"},dragOver:{type:"function"},drop:{type:"function"}}},plotArea:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},dragEnter:{type:"function"},dragLeave:{type:"function"},dragOver:{type:"function"},drop:{type:"function"}}},xAxis:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},dragEnter:{type:"function"},dragLeave:{type:"function"},dragOver:{type:"function"},drop:{type:"function"}}},y2Axis:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},dragEnter:{type:"function"},dragLeave:{type:"function"},dragOver:{type:"function"},drop:{type:"function"}}},yAxis:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},dragEnter:{type:"function"},dragLeave:{type:"function"},dragOver:{type:"function"},drop:{type:"function"}}}}}}},dragMode:{type:"string",enumValues:["off","pan","select","user","zoom"],value:"user"},drilling:{type:"string",enumValues:["groupsOnly","off","on","seriesOnly"],value:"off"},groupComparator:{type:"function"},groups:{type:"Array<string>|Array<Object>|Promise"},hiddenCategories:{type:"Array<string>",writeback:!0,value:[]},hideAndShowBehavior:{type:"string",enumValues:["none","withRescale","withoutRescale"],value:"none"},highlightMatch:{type:"string",enumValues:["all","any"],value:"all"},highlightedCategories:{type:"Array<string>",writeback:!0,value:[]},hoverBehavior:{type:"string",enumValues:["dim","none"],value:"none"},initialZooming:{type:"string",enumValues:["first","last","none"],value:"none"},legend:{type:"object",properties:{backgroundColor:{type:"string"},borderColor:{type:"string"},maxSize:{type:"string"},position:{type:"string",enumValues:["auto","bottom","end","start","top"],value:"auto"},referenceObjectSection:{type:"object",properties:{title:{type:"string"},titleHalign:{type:"string",enumValues:["center","end","start"],value:"start"},titleStyle:{type:"object",value:{}}}},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"},scrolling:{type:"string",enumValues:["asNeeded","off"],value:"asNeeded"},sections:{type:"Array<Object>",value:[]},seriesSection:{type:"object",properties:{title:{type:"string"},titleHalign:{type:"string",enumValues:["center","end","start"],value:"start"},titleStyle:{type:"object",value:{}}}},size:{type:"string"},symbolHeight:{type:"number"},symbolWidth:{type:"number"},textStyle:{type:"object",value:{}},title:{type:"string"},titleHalign:{type:"string",enumValues:["center","end","start"],value:"start"},titleStyle:{type:"object",value:{}}}},multiSeriesDrilling:{type:"string",enumValues:["off","on"],value:"off"},orientation:{type:"string",enumValues:["horizontal","vertical"],value:"vertical"},otherThreshold:{type:"number",value:0},overview:{type:"object",properties:{content:{type:"object",value:{}},height:{type:"string"},rendered:{type:"string",enumValues:["off","on"],value:"off"}}},pieCenter:{type:"object",properties:{converter:{type:"object"},label:{type:"number|string"},labelStyle:{type:"object",value:{}},renderer:{type:"function"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"}}},plotArea:{type:"object",properties:{backgroundColor:{type:"string"},borderColor:{type:"string"},borderWidth:{type:"number"},rendered:{type:"string",enumValues:["off","on"],value:"on"}}},polarGridShape:{type:"string",enumValues:["circle","polygon"],value:"circle"},selection:{type:"Array<any>",writeback:!0,value:[]},selectionMode:{type:"string",enumValues:["multiple","none","single"],value:"none"},series:{type:"Array<Object>|Promise"},seriesComparator:{type:"function"},sorting:{type:"string",enumValues:["ascending","descending","off"],value:"off"},splitDualY:{type:"string",enumValues:["auto","off","on"],value:"auto"},splitterPosition:{type:"number",value:.5},stack:{type:"string",enumValues:["off","on"],value:"off"},stackLabel:{type:"string",enumValues:["off","on"],value:"off"},stackLabelProvider:{type:"function"},styleDefaults:{type:"object",properties:{animationDownColor:{type:"string"},animationDuration:{type:"number"},animationIndicators:{type:"string",enumValues:["all","none"],value:"all"},animationUpColor:{type:"string"},barGapRatio:{type:"number"},borderColor:{type:"string"},borderWidth:{type:"number"},boxPlot:{type:"object",properties:{medianSvgClassName:{type:"string",value:""},medianSvgStyle:{type:"object",value:{}},whiskerEndLength:{type:"string"},whiskerEndSvgClassName:{type:"string",value:""},whiskerEndSvgStyle:{type:"object",value:{}},whiskerSvgClassName:{type:"string",value:""},whiskerSvgStyle:{type:"object",value:{}}}},colors:{type:"Array<string>"},dataCursor:{type:"object",properties:{lineColor:{type:"string"},lineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},lineWidth:{type:"number"},markerColor:{type:"string"},markerDisplayed:{type:"string",enumValues:["off","on"],value:"on"},markerSize:{type:"number"}}},dataItemGaps:{type:"string"},dataLabelCollision:{type:"string",enumValues:["fitInBounds","none"],value:"none"},dataLabelPosition:{type:"string|Array<string>",enumValues:["aboveMarker","afterMarker","auto","beforeMarker","belowMarker","center","insideBarEdge","none","outsideBarEdge","outsideSlice"],value:"auto"},dataLabelStyle:{type:"object|Array<Object>"},funnelBackgroundColor:{type:"string"},groupSeparators:{type:"object",properties:{color:{type:"string"},rendered:{type:"string",enumValues:["auto","off"],value:"auto"}}},hoverBehaviorDelay:{type:"number"},lineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},lineType:{type:"string",enumValues:["auto","centeredSegmented","centeredStepped","curved","none","segmented","stepped","straight"],value:"auto"},lineWidth:{type:"number"},markerColor:{type:"string"},markerDisplayed:{type:"string",enumValues:["auto","off","on"],value:"auto"},markerShape:{type:"string",value:"auto"},markerSize:{type:"number"},marqueeBorderColor:{type:"string"},marqueeColor:{type:"string"},maxBarWidth:{type:"number"},otherColor:{type:"string"},patterns:{type:"Array<string>"},pieFeelerColor:{type:"string"},pieInnerRadius:{type:"number",value:0},selectionEffect:{type:"string",enumValues:["explode","highlight","highlightAndExplode"],value:"highlight"},seriesEffect:{type:"string",enumValues:["color","gradient","pattern"],value:"color"},shapes:{type:"Array<string>"},stackLabelStyle:{type:"object",value:{}},stockFallingColor:{type:"string"},stockRangeColor:{type:"string"},stockRisingColor:{type:"string"},stockVolumeColor:{type:"string"},threeDEffect:{type:"string",enumValues:["off","on"],value:"off"},tooltipLabelStyle:{type:"object",value:{}},tooltipValueStyle:{type:"object",value:{}}}},timeAxisType:{type:"string",enumValues:["auto","disabled","enabled","mixedFrequency","skipGaps"],value:"auto"},tooltip:{type:"object",properties:{renderer:{type:"function"}}},touchResponse:{type:"string",enumValues:["auto","touchStart"],value:"auto"},trackResize:{type:"string",enumValues:["off","on"],value:"on"},translations:{type:"object",value:{},properties:{componentName:{type:"string"},labelAndValue:{type:"string"},labelClearSelection:{type:"string"},labelClose:{type:"string"},labelCountWithTotal:{type:"string"},labelDataVisualization:{type:"string"},labelDate:{type:"string"},labelDefaultGroupName:{type:"string"},labelGroup:{type:"string"},labelHigh:{type:"string"},labelInvalidData:{type:"string"},labelLow:{type:"string"},labelNoData:{type:"string"},labelOpen:{type:"string"},labelOther:{type:"string"},labelPercentage:{type:"string"},labelQ1:{type:"string"},labelQ2:{type:"string"},labelQ3:{type:"string"},labelSeries:{type:"string"},labelTargetValue:{type:"string"},labelValue:{type:"string"},labelVolume:{type:"string"},labelX:{type:"string"},labelY:{type:"string"},labelZ:{type:"string"},stateCollapsed:{type:"string"},stateDrillable:{type:"string"},stateExpanded:{type:"string"},stateHidden:{type:"string"},stateIsolated:{type:"string"},stateMaximized:{type:"string"},stateMinimized:{type:"string"},stateSelected:{type:"string"},stateUnselected:{type:"string"},stateVisible:{type:"string"},tooltipPan:{type:"string"},tooltipSelect:{type:"string"},tooltipZoom:{type:"string"}}},type:{type:"string",enumValues:["area","bar","boxPlot","bubble","combo","funnel","line","lineWithArea","pie","pyramid","scatter","stock"],value:"bar"},valueFormats:{type:"object",properties:{close:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},group:{type:"object",properties:{tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string|Array<string>"}}},high:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},label:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"}}},low:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},open:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},q1:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},q2:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},q3:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},series:{type:"object",properties:{tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},targetValue:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},value:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},volume:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},x:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},y:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},y2:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},z:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}}}},xAxis:{type:"object",properties:{axisLine:{type:"object",properties:{lineColor:{type:"string"},lineWidth:{type:"number"},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"}}},baselineScaling:{type:"string",enumValues:["min","zero"],value:"zero"},dataMax:{type:"number"},dataMin:{type:"number"},majorTick:{type:"object",properties:{baselineColor:{type:"string",value:"auto"},baselineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},baselineWidth:{type:"number"},lineColor:{type:"string"},lineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},lineWidth:{type:"number"},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"}}},max:{type:"number|string"},maxSize:{type:"string"},min:{type:"number|string"},minStep:{type:"number"},minorStep:{type:"number"},minorTick:{type:"object",properties:{lineColor:{type:"string"},lineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},lineWidth:{type:"number"},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"}}},referenceObjects:{type:"Array<Object>",value:[]},rendered:{type:"string",enumValues:["off","on"],value:"on"},scale:{type:"string",enumValues:["linear","log"],value:"linear"},size:{type:"string"},step:{type:"number"},tickLabel:{type:"object",properties:{converter:{type:"object"},rendered:{type:"string",enumValues:["off","on"],value:"on"},rotation:{type:"string",enumValues:["auto","none"],value:"auto"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},style:{type:"object",value:{}}}},title:{type:"string"},titleStyle:{type:"object",value:{}},viewportEndGroup:{type:"number|string"},viewportMax:{type:"number|string"},viewportMin:{type:"number|string"},viewportStartGroup:{type:"number|string"}}},y2Axis:{type:"object",properties:{alignTickMarks:{type:"string",enumValues:["off","on"],value:"on"},axisLine:{type:"object",properties:{lineColor:{type:"string"},lineWidth:{type:"number"},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"}}},baselineScaling:{type:"string",enumValues:["min","zero"],value:"zero"},dataMax:{type:"number"},dataMin:{type:"number"},majorTick:{type:"object",properties:{baselineColor:{type:"string",value:"auto"},baselineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},baselineWidth:{type:"number"},lineColor:{type:"string"},lineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},lineWidth:{type:"number"},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"}}},max:{type:"number"},maxSize:{type:"string"},min:{type:"number"},minStep:{type:"number"},minorStep:{type:"number"},minorTick:{type:"object",properties:{lineColor:{type:"string"},lineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},lineWidth:{type:"number"},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"}}},position:{type:"string",enumValues:["auto","bottom","end","start","top"],value:"auto"},referenceObjects:{type:"Array<Object>",value:[]},rendered:{type:"string",enumValues:["off","on"],value:"on"},scale:{type:"string",enumValues:["linear","log"],value:"linear"},size:{type:"string"},step:{type:"number"},tickLabel:{type:"object",properties:{converter:{type:"object"},position:{type:"string",enumValues:["inside","outside"],value:"outside"},rendered:{type:"string",enumValues:["off","on"],value:"on"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},style:{type:"object",value:{}}}},title:{type:"string"},titleStyle:{type:"object",value:{}}}},yAxis:{type:"object",properties:{axisLine:{type:"object",properties:{lineColor:{type:"string"},lineWidth:{type:"number"},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"}}},baselineScaling:{type:"string",enumValues:["min","zero"],value:"zero"},dataMax:{type:"number"},dataMin:{type:"number"},majorTick:{type:"object",properties:{baselineColor:{type:"string",value:"auto"},baselineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},baselineWidth:{type:"number"},lineColor:{type:"string"},lineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},lineWidth:{type:"number"},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"}}},max:{type:"number"},maxSize:{type:"string"},min:{type:"number"},minStep:{type:"number"},minorStep:{type:"number"},minorTick:{type:"object",properties:{lineColor:{type:"string"},lineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},lineWidth:{type:"number"},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"}}},position:{type:"string",enumValues:["auto","bottom","end","start","top"],value:"auto"},referenceObjects:{type:"Array<Object>",value:[]},rendered:{type:"string",enumValues:["off","on"],value:"on"},scale:{type:"string",enumValues:["linear","log"],value:"linear"},size:{type:"string"},step:{type:"number"},tickLabel:{type:"object",properties:{converter:{type:"object"},position:{type:"string",enumValues:["inside","outside"],value:"outside"},rendered:{type:"string",enumValues:["off","on"],value:"on"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},style:{type:"object",value:{}}}},title:{type:"string"},titleStyle:{type:"object",value:{}},viewportMax:{type:"number"},viewportMin:{type:"number"}}},zoomAndScroll:{type:"string",enumValues:["delayed","delayedScrollOnly","live","liveScrollOnly","off"],value:"off"},zoomDirection:{type:"string",enumValues:["auto","x","y"],value:"auto"}},methods:{getContextByNode:{},getDataItem:{},getGroup:{},getGroupCount:{},getLegend:{},getPlotArea:{},getProperty:{},getSeries:{},getSeriesCount:{},getValuesAt:{},getXAxis:{},getY2Axis:{},getYAxis:{},refresh:{},setProperties:{},setProperty:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojDrill:{},ojGroupDrill:{},ojItemDrill:{},ojMultiSeriesDrill:{},ojSelectInput:{},ojSeriesDrill:{},ojViewportChange:{},ojViewportChangeInput:{}},extension:{}};!function(){l.extension._WIDGET_NAME="ojChart";var r=t.shapeParseFunction({"style-defaults.marker-shape":!0},{square:!0,circle:!0,diamond:!0,plus:!0,triangleDown:!0,triangleUp:!0,human:!0,star:!0,auto:!0});e.CustomElementBridge.register("oj-chart",{metadata:l,parseFunction:function(e,t,n,o){return"number|string"===n.type?isNaN(e)?e:Number(e):"style-defaults.data-label-style"===t?JSON.parse(e):r(e,t,n,o)}})}();var p={properties:{borderColor:{type:"string"},borderWidth:{type:"number"},boxPlot:{type:"object",properties:{medianSvgClassName:{type:"string"},medianSvgStyle:{type:"object"},q2Color:{type:"string"},q2SvgClassName:{type:"string"},q2SvgStyle:{type:"object"},q3Color:{type:"string"},q3SvgClassName:{type:"string"},q3SvgStyle:{type:"object"},whiskerEndLength:{type:"string"},whiskerEndSvgClassName:{type:"string"},whiskerEndSvgStyle:{type:"object"},whiskerSvgClassName:{type:"string"},whiskerSvgStyle:{type:"object"}}},categories:{type:"Array<string>"},close:{type:"number"},color:{type:"string"},drilling:{type:"string",enumValues:["inherit","off","on"],value:"inherit"},groupId:{type:"Array<(string|number)>"},high:{type:"number"},items:{type:"Array<Object>|Array<number>"},label:{type:"string|Array<string>"},labelPosition:{type:"string|Array<string>",enumValues:["aboveMarker","afterMarker","auto","beforeMarker","belowMarker","center","insideBarEdge","none","outsideBarEdge","outsideSlice"]},labelStyle:{type:"object|Array<Object>"},low:{type:"number"},markerDisplayed:{type:"string",enumValues:["auto","off","on"]},markerShape:{type:"string"},markerSize:{type:"number"},open:{type:"number"},pattern:{type:"string",enumValues:["auto","largeChecker","largeCrosshatch","largeDiagonalLeft","largeDiagonalRight","largeDiamond","largeTriangle","smallChecker","smallCrosshatch","smallDiagonalLeft","smallDiagonalRight","smallDiamond","smallTriangle"],value:"auto"},q1:{type:"number"},q2:{type:"number"},q3:{type:"number"},seriesId:{type:"string|number"},shortDesc:{type:"string|function"},source:{type:"string"},sourceHover:{type:"string"},sourceHoverSelected:{type:"string"},sourceSelected:{type:"string"},svgClassName:{type:"string"},svgStyle:{type:"object"},targetValue:{type:"number"},value:{type:"number"},volume:{type:"number"},x:{type:"number|string"},y:{type:"number"},z:{type:"number"}},extension:{}};!function(){p.extension._CONSTRUCTOR=function(){};e.CustomElementBridge.register("oj-chart-item",{metadata:p,parseFunction:t.shapeParseFunction({"marker-shape":!0},{square:!0,circle:!0,diamond:!0,plus:!0,triangleDown:!0,triangleUp:!0,human:!0,star:!0,auto:!0})})}();var u={properties:{areaColor:{type:"string"},areaSvgClassName:{type:"string"},areaSvgStyle:{type:"object"},assignedToY2:{type:"string",enumValues:["off","on"],value:"off"},borderColor:{type:"string"},borderWidth:{type:"number"},boxPlot:{type:"object",properties:{medianSvgClassName:{type:"string"},medianSvgStyle:{type:"object"},q2Color:{type:"string"},q2SvgClassName:{type:"string"},q2SvgStyle:{type:"object"},q3Color:{type:"string"},q3SvgClassName:{type:"string"},q3SvgStyle:{type:"object"},whiskerEndLength:{type:"string"},whiskerEndSvgClassName:{type:"string"},whiskerEndSvgStyle:{type:"object"},whiskerSvgClassName:{type:"string"},whiskerSvgStyle:{type:"object"}}},categories:{type:"Array<string>"},color:{type:"string"},displayInLegend:{type:"string",enumValues:["auto","off","on"],value:"auto"},drilling:{type:"string",enumValues:["inherit","off","on"],value:"inherit"},lineStyle:{type:"string",enumValues:["dashed","dotted","solid"]},lineType:{type:"string",enumValues:["auto","centeredSegmented","centeredStepped","curved","none","segmented","stepped","straight"]},lineWidth:{type:"number"},markerColor:{type:"string"},markerDisplayed:{type:"string",enumValues:["auto","off","on"]},markerShape:{type:"string"},markerSize:{type:"number"},markerSvgClassName:{type:"string"},markerSvgStyle:{type:"object"},name:{type:"string"},pattern:{type:"string",enumValues:["auto","largeChecker","largeCrosshatch","largeDiagonalLeft","largeDiagonalRight","largeDiamond","largeTriangle","smallChecker","smallCrosshatch","smallDiagonalLeft","smallDiagonalRight","smallDiamond","smallTriangle"],value:"auto"},pieSliceExplode:{type:"number",value:0},shortDesc:{type:"string"},source:{type:"string"},sourceHover:{type:"string"},sourceHoverSelected:{type:"string"},sourceSelected:{type:"string"},stackCategory:{type:"string"},svgClassName:{type:"string"},svgStyle:{type:"object"},type:{type:"string",enumValues:["area","auto","bar","boxPlot","candlestick","line","lineWithArea"],value:"auto"}},extension:{}};!function(){u.extension._CONSTRUCTOR=function(){};e.CustomElementBridge.register("oj-chart-series",{metadata:u,parseFunction:t.shapeParseFunction({"marker-shape":!0},{square:!0,circle:!0,diamond:!0,plus:!0,triangleDown:!0,triangleUp:!0,human:!0,star:!0,auto:!0})})}();var y={properties:{drilling:{type:"string",enumValues:["inherit","off","on"],value:"inherit"},labelStyle:{type:"object"},name:{type:"string"},shortDesc:{type:"string"}},extension:{}};y.extension._CONSTRUCTOR=function(){},e.CustomElementBridge.register("oj-chart-group",{metadata:y});var g={properties:{animationDuration:{type:"number"},animationOnDataChange:{type:"string",enumValues:["auto","none"],value:"none"},animationOnDisplay:{type:"string",enumValues:["auto","none"],value:"none"},areaColor:{type:"string",value:""},areaSvgClassName:{type:"string",value:""},areaSvgStyle:{type:"object",value:{}},as:{type:"string",value:""},barGapRatio:{type:"number",value:.25},baselineScaling:{type:"string",enumValues:["min","zero"],value:"min"},color:{type:"string"},data:{type:"object",extension:{webelement:{exceptionStatus:[{type:"deprecated",since:"11.0.0",description:"Data sets from a DataProvider cannot be sent to WebDriverJS; use ViewModels or page variables instead."}]}}},firstColor:{type:"string",value:""},highColor:{type:"string",value:""},items:{type:"Array<Object>|Array<number>|Promise"},lastColor:{type:"string",value:""},lineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},lineType:{type:"string",enumValues:["centeredSegmented","centeredStepped","curved","none","segmented","stepped","straight"],value:"straight"},lineWidth:{type:"number",value:1},lowColor:{type:"string",value:""},markerShape:{type:"string",value:"auto"},markerSize:{type:"number",value:5},referenceObjects:{type:"Array<Object>",value:[]},svgClassName:{type:"string",value:""},svgStyle:{type:"object",value:{}},tooltip:{type:"object",properties:{renderer:{type:"function"}}},trackResize:{type:"string",enumValues:["off","on"],value:"on"},translations:{type:"object",value:{},properties:{componentName:{type:"string"},labelAndValue:{type:"string"},labelClearSelection:{type:"string"},labelCountWithTotal:{type:"string"},labelDataVisualization:{type:"string"},labelInvalidData:{type:"string"},labelNoData:{type:"string"},stateCollapsed:{type:"string"},stateDrillable:{type:"string"},stateExpanded:{type:"string"},stateHidden:{type:"string"},stateIsolated:{type:"string"},stateMaximized:{type:"string"},stateMinimized:{type:"string"},stateSelected:{type:"string"},stateUnselected:{type:"string"},stateVisible:{type:"string"}}},type:{type:"string",enumValues:["area","bar","line","lineWithArea"],value:"line"},visualEffects:{type:"string",enumValues:["auto","none"],value:"auto"}},methods:{getDataItem:{},getProperty:{},refresh:{},setProperties:{},setProperty:{},getNodeBySubId:{},getSubIdByNode:{}},extension:{}};!function(){g.extension._WIDGET_NAME="ojSparkChart";e.CustomElementBridge.register("oj-spark-chart",{metadata:g,parseFunction:t.shapeParseFunction({"marker-shape":!0},{square:!0,circle:!0,diamond:!0,plus:!0,triangleDown:!0,triangleUp:!0,human:!0,star:!0,auto:!0})})}();var c={properties:{borderColor:{type:"string",value:""},color:{type:"string",value:""},date:{type:"string",value:""},high:{type:"number"},low:{type:"number"},markerDisplayed:{type:"string",enumValues:["off","on"],value:"off"},markerShape:{type:"string"},markerSize:{type:"number"},svgClassName:{type:"string",value:""},svgStyle:{type:"object",value:{}},value:{type:"number"}},extension:{}};c.extension._CONSTRUCTOR=function(){},e.CustomElementBridge.register("oj-spark-chart-item",{metadata:c});const d=(e,t,r,n)=>{const o=e.element[0],i=e._TemplateHandler,s=i.getTemplates(),l=s.seriesTemplate?s.seriesTemplate[0]:null,p=s.groupTemplate?s.groupTemplate[0]:null,u=e.options.seriesComparator,y=e.options.groupComparator,g=new Map,c=p||y?new Map:null,d=new Map,m=(e,a)=>{const s=[...e.keys()],l=new Map,u=s.map((s,u)=>{let g;const d=e.get(s),b=d.value,h=d.groups;let v;return(p||y)&&(v=((e,t,n,i)=>{const a={ids:t,componentElement:o,depth:t.length,leaf:i,index:n};return Object.defineProperty(a,"items",{get:()=>c.get(e).map(e=>{const t=r[e];return{data:t._itemData,key:t.id,index:e}})}),a})(b,[...a,s],u,!h),l.set(s,v)),g=p?i.processNodeTemplate(n,t,p,"oj-chart-group",v,b):{},g.id=s,g.name=null==g.name?s:g.name,h?g.groups=m(h,[...a,s]):Object.defineProperty(g,"symbol",{value:b,enumerable:!1}),g});return y&&u.sort((e,t)=>y(l.get(e.id),l.get(t.id))),u},b=e=>{const t=[];return e.forEach(e=>{e.groups?t.push(...b(e.groups)):t.push(e.symbol)}),t};r.forEach((e,t)=>{const r=(e=>{let t=g;const r=[];for(let n=0;n<e.length;n++){const o=e[n];let i=t.get(o);i||(i={value:Symbol(o)},n!==e.length-1&&(i.groups=new Map),t.set(o,i)),r.push(i.value),t=i.groups}return r})(e.groupId);((e,t,r)=>{let n=d.get(e);n||(n=new Map,d.set(e,n));const o=t[t.length-1];void 0===n.get(o)&&(n.set(o,r),c&&t.forEach(e=>{let t=c.get(e);t||(t=[],c.set(e,t)),t.push(r)}))})(e.seriesId,r,t)});const h=(()=>{try{return m(g,[])}catch(e){return a.error(e),[]}})();return{groups:h,series:(e=>{let s;try{const a=new Map,p=b(e);s=[...d.keys()].map((e,s)=>{const y=d.get(e);let g,c;return(l||u)&&(g=((e,t,n,i)=>{const a={componentElement:o,id:e,index:t};return Object.defineProperty(a,"items",{get:()=>{const e=[];return n.forEach(t=>{const n=i.get(t);if(null!=n){const t=r[n];e.push({data:t._itemData,key:t.id,index:n})}}),e}}),a})(e,s,p,y),a.set(e,g)),c=l?i.processNodeTemplate(n,t,l,"oj-chart-series",g,e):{},c.id=e,c.name=null==c.name?String(e):c.name,c.items=p.map(e=>{let t=null;const n=y.get(e);return null!=n&&(t=r[n]),t}),c}),u&&s.sort((e,t)=>u(a.get(e.id),a.get(t.id)))}catch(e){a.error(e),s=[]}return s})(h)}};e.__registerWidget("oj.ojChart",n.oj.dvtBaseComponent,{widgetEventPrefix:"oj",options:{data:null,series:null,groups:null,selectInput:null,tooltip:{renderer:null},viewportChange:null,viewportChangeInput:null,drill:null,itemDrill:null,groupDrill:null,seriesDrill:null,multiSeriesDrill:null},_ComponentCreate:function(){this._super(),this._SetLocaleHelpers(i,o)},_CreateDvtComponent:function(e,t,r){return new s.Chart(e,t,r)},_ConvertLocatorToSubId:function(e){var t=e.subId;return"oj-chart-item"===t?t="dataItem["+e.seriesIndex+"]["+e.itemIndex+"]":"oj-chart-group"===t?t="group"+this._GetStringFromIndexPath(e.indexPath):"oj-chart-series"===t?t="series["+e.index+"]":"oj-chart-axis-title"===t?t=e.axis+":title":"oj-chart-reference-object"===t?t=e.axis+":referenceObject["+e.index+"]":"oj-legend-item"===t?(t="legend:section"+this._GetStringFromIndexPath(e.sectionIndexPath),t+=":item["+e.itemIndex+"]"):"oj-chart-tooltip"===t?t="tooltip":"oj-chart-pie-center-label"===t&&(t="pieCenterLabel"),t},_ProcessTemplates:function(e,t,r,n,o,i,a){var s=i?this._TemplateHandler.getComponentResults(e):null;if(!s){var l=this._super(e,t,r,n,o,i,a),p=d(this,r,l.values[0],e);s={paths:["series","groups"],values:[p.series,p.groups]},i&&this._TemplateHandler.setComponentResults(e,s)}return s},_GetSimpleDataProviderConfigs:function(){return{data:{templateName:"itemTemplate",templateElementName:"oj-chart-item",resultPath:"_item",derivedTemplates:["seriesTemplate","groupTemplate"]}}},_UseObjectAssignForShapedData:function(){return!0},_ProcessOptions:function(){this._super();var e=this.options.pieCenter;e&&e._renderer&&(e.renderer=this._GetTemplateRenderer(e._renderer,"center"));var t=this.options.selection;this._IsCustomElement()&&t&&"object"==typeof t[0]&&!this.options.data&&(this.options.selection=null)},_ConvertSubIdToLocator:function(e){var t={};if(0===e.indexOf("dataItem")){var r=this._GetIndexPath(e);t.subId="oj-chart-item",t.seriesIndex=r[0],t.itemIndex=r[1]}else if(0===e.indexOf("group"))t.subId="oj-chart-group",t.indexPath=this._GetIndexPath(e);else if(0===e.indexOf("series"))t.subId="oj-chart-series",t.index=this._GetFirstIndex(e);else if(e.indexOf("Axis:title")>0)t.subId="oj-chart-axis-title",t.axis=e.substring(0,e.indexOf(":"));else if(e.indexOf("Axis:referenceObject")>0)t.subId="oj-chart-reference-object",t.axis=e.substring(0,e.indexOf(":")),t.index=this._GetFirstIndex(e);else if(0===e.indexOf("legend")){if(e.indexOf(":item")>0){var n=e.indexOf(":item"),o=e.substring(0,n),i=e.substring(n);t.subId="oj-legend-item",t.sectionIndexPath=this._GetIndexPath(o),t.itemIndex=this._GetFirstIndex(i)}}else"tooltip"===e?t.subId="oj-chart-tooltip":"pieCenterLabel"===e&&(t.subId="oj-chart-pie-center-label");return t},_GetComponentRendererOptions:function(){return[{path:"tooltip/renderer",slot:"tooltipTemplate"},{path:"pieCenter/renderer",slot:"pieCenterTemplate"}]},_GetComponentStyleClasses:function(){var e=this._super();return e.push("oj-chart"),e},_GetChildStyleClasses:function(){var e=this._super();return e["oj-chart-data-label"]={path:"styleDefaults/_dataLabelStyle",property:"TEXT"},e["oj-chart-data-cursor-line"]=[{path:"styleDefaults/dataCursor/lineColor",property:"color"},{path:"styleDefaults/dataCursor/lineWidth",property:"width"}],e["oj-chart-stack-label"]={path:"styleDefaults/stackLabelStyle",property:"TEXT"},e["oj-chart-pie-center-label"]={path:"pieCenter/labelStyle",property:"TEXT"},e["oj-chart-slice-label"]={path:"styleDefaults/sliceLabelStyle",property:"TEXT"},e["oj-chart-stock-falling"]={path:"styleDefaults/stockFallingColor",property:"background-color"},e["oj-chart-stock-range"]={path:"styleDefaults/stockRangeColor",property:"background-color"},e["oj-chart-stock-rising"]={path:"styleDefaults/stockRisingColor",property:"background-color"},e["oj-chart-xaxis-tick-label"]={path:"xAxis/tickLabel/style",property:"TEXT"},e["oj-chart-xaxis-title"]={path:"xAxis/titleStyle",property:"TEXT"},e["oj-chart-yaxis-tick-label"]={path:"yAxis/tickLabel/style",property:"TEXT"},e["oj-chart-yaxis-title"]={path:"yAxis/titleStyle",property:"TEXT"},e["oj-chart-y2axis-tick-label"]={path:"y2Axis/tickLabel/style",property:"TEXT"},e["oj-chart-y2axis-title"]={path:"y2Axis/titleStyle",property:"TEXT"},e["oj-chart-reference-object-line"]=[{path:"_defaultReferenceObjectLineColor",property:"color"},{path:"_defaultReferenceObjectLineWidth",property:"width"}],e["oj-chart-reference-object-area"]={path:"_defaultReferenceObjectAreaColor",property:"color"},e["oj-legend"]={path:"legend/textStyle",property:"TEXT"},e["oj-legend-title"]={path:"legend/titleStyle",property:"TEXT"},e["oj-legend-section-title"]={path:"legend/_sectionTitleStyle",property:"TEXT"},e["oj-legend-hover"]={path:"legend/_hoverBorderRadius",property:"border-radius"},e["oj-dvt-color-ramp"]={path:"styleDefaults/colors",property:"COLOR"},e},_GetEventTypes:function(){return["drill","groupDrill","itemDrill","seriesDrill","multiSeriesDrill","optionChange","selectInput","viewportChange","viewportChangeInput"]},_HandleEvent:function(e){var t=e.type;if("selection"===t){var r=e.selection;if(r){for(var n=[],o=[],i=0;i<r.length;i++){var a;a=this._IsCustomElement()?r[i].id:{id:r[i].id,series:r[i].series,group:r[i].group};var s={data:r[i].data,seriesData:r[i].seriesData,groupData:r[i].groupData,itemData:r[i].itemData};n.push(a),o.push(s)}var l={endGroup:e.endGroup,startGroup:e.startGroup,xMax:e.xMax,xMin:e.xMin,yMax:e.yMax,yMin:e.yMin,y2Max:e.y2Max,y2Min:e.y2Min,selectionData:o};this._IsCustomElement()||(l.component=e.component),e.complete?this._UserOptionChange("selection",n,l):(l.items=n,this._trigger("selectInput",null,l))}}else if("viewportChange"===t){var p={endGroup:e.endGroup,startGroup:e.startGroup,xMax:e.xMax,xMin:e.xMin,yMax:e.yMax,yMin:e.yMin};e.complete&&(this.options.xAxis||(this.options.xAxis={}),this.options.yAxis||(this.options.yAxis={}),this.options.xAxis.viewportStartGroup=null,this.options.xAxis.viewportEndGroup=null,null!=e.xMin&&null!=e.xMax&&(this.options.xAxis.viewportMin=e.xMin,this.options.xAxis.viewportMax=e.xMax),null!=e.yMin&&null!=e.yMax&&(this.options.yAxis.viewportMin=e.yMin,this.options.yAxis.viewportMax=e.yMax)),this._trigger(e.complete?"viewportChange":"viewportChangeInput",null,p)}else if("drill"===t)if(e.subType){if(this._IsCustomElement()){var u=e.subType;"item"===u?this._trigger("itemDrill",null,{id:e.id,series:e.series,group:e.group,data:e.data,itemData:e.itemData,seriesData:e.seriesData,groupData:e.groupData}):"group"===u?this._trigger("groupDrill",null,{group:e.group,groupData:e.groupData,id:e.id,items:e.items}):"series"===u?this._trigger("seriesDrill",null,{id:e.id,items:e.items,series:e.series,seriesData:e.seriesData}):"multiSeries"===u&&this._trigger("multiSeriesDrill",null,{items:e.items,series:e.series,seriesData:e.seriesData})}}else this._trigger("drill",null,{id:e.id,series:e.series,group:e.group,data:e.data,seriesData:e.seriesData,groupData:e.groupData,itemData:e.itemData,component:e.component});else this._super(e)},_LoadResources:function(){null==this.options._resources&&(this.options._resources={});var e=this.options._resources;e.overviewGrippy="oj-fwk-icon oj-fwk-icon-drag-horizontal",e.pan="oj-fwk-icon oj-fwk-icon-pan",e.select="oj-fwk-icon oj-fwk-icon-marquee",e.zoom="oj-fwk-icon oj-fwk-icon-magnifier"},getTitle:function(){return this._component.getAutomation().getTitle()},getGroup:function(e){return this._component.getAutomation().getGroup(e)},getSeries:function(e){return this._component.getAutomation().getSeries(e)},getGroupCount:function(){return this._component.getAutomation().getGroupCount()},getSeriesCount:function(){return this._component.getAutomation().getSeriesCount()},getDataItem:function(e,t){return this._component.getAutomation().getDataItem(e,t)},getLegend:function(){return this._component.getAutomation().getLegend()},getPlotArea:function(){return this._component.getAutomation().getPlotArea()},getXAxis:function(){return this._component.getAutomation().getXAxis()},getYAxis:function(){return this._component.getAutomation().getYAxis()},getY2Axis:function(){return this._component.getAutomation().getY2Axis()},getValuesAt:function(e,t){return this._component.getValsAt(e,t)},getContextByNode:function(e){var t=this.getSubIdByNode(e);return t&&"oj-chart-tooltip"!==t.subId?t:null},_GetComponentNoClonePaths:function(){var e=this._super();return e.pieCenter={converter:!0},e.xAxis={tickLabel:{converter:!0}},e.yAxis={tickLabel:{converter:!0}},e.y2Axis={tickLabel:{converter:!0}},e.valueFormats={close:{converter:!0},high:{converter:!0},label:{converter:!0},low:{converter:!0},open:{converter:!0},q1:{converter:!0},q2:{converter:!0},q3:{converter:!0},targetValue:{converter:!0},value:{converter:!0},volume:{converter:!0},x:{converter:!0},y:{converter:!0},y2:{converter:!0},z:{converter:!0}},e},_GetComponentDeferredDataPaths:function(){return{root:["groups","series","data"]}},_CompareOptionValues:function(t,r,n){return"dataCursorPosition"===t?e.Object.compareValues(r,n):this._super(t,r,n)}}),e.__registerWidget("oj.ojSparkChart",n.oj.dvtBaseComponent,{widgetEventPrefix:"oj",options:{as:"",data:null,items:null,referenceObjects:[],tooltip:{renderer:null},type:"line",color:"#267DB3",areaColor:"",areaSvgClassName:"",areaSvgStyle:{},svgClassName:"",svgStyle:{},firstColor:"",lastColor:"",highColor:"",lowColor:"",animationDuration:void 0,animationOnDataChange:"none",animationOnDisplay:"none",visualEffects:"auto",baselineScaling:"min",lineWidth:1,lineStyle:"solid",lineType:"straight",markerShape:"auto",markerSize:5,barGapRatio:.25},_CreateDvtComponent:function(e,t,r){return this._focusable({element:this.element,applyHighlight:!0}),new s.SparkChart(e,t,r)},_GetComponentStyleClasses:function(){var e=this._super();return e.push("oj-sparkchart"),e},_GetChildStyleClasses:function(){var e=this._super();return e["oj-dvtbase oj-sparkchart"]={path:"animationDuration",property:"ANIM_DUR"},e},_Render:function(){this.element.attr("title")?(this.options.shortDesc=this.element.attr("title"),this.element.data(this.element,"title",this.element.attr("title")),this.element.removeAttr("title")):this.element.data("title")&&(this.options.shortDesc=this.element.data("title")),this._super()},getDataItem:function(e){var t=this._component.getAutomation().getDataItem(e);return this._AddAutomationGetters(t),t&&(t.getFloatValue=t.getLow),t},_GetComponentDeferredDataPaths:function(){return{root:["items","data"]}},_GetSimpleDataProviderConfigs:function(){return{data:{templateName:"itemTemplate",templateElementName:"oj-spark-chart-item",resultPath:"items"}}},_AddAutomationGetters:function(e){if(e){for(var t={},r=Object.keys(e),n=0;n<r.length;n++)this._addGetter(e,r[n],t);Object.defineProperties(e,t)}},_addGetter:function(e,t,r){r[("selected"===t?"is":"get")+t.charAt(0).toUpperCase()+t.slice(1)]={value:function(){return e[t]}}}})});
//# sourceMappingURL=ojchart.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojgauge-toolkit',["exports","ojs/ojdvt-toolkit","ojs/ojdvt-axis"],function(e,t,a){"use strict";const i={hasData:e=>{var t=e.getOptions();return t&&null!=t.value&&i.hasValidData(e)},hasValidData:e=>{var t=e.getOptions();return Number(t.min)<Number(t.max)},getValThresholdIdx:(e,t)=>{var a=e.getOptions(),i=null!=t?t:a.value,s=a.thresholds;if(!s)return-1;for(var n=0;n<s.length;n++)if(i<=s[n].max)return n;return s.length-1},getThreshold:(e,t)=>{var a=e.getOptions().thresholds;return a&&t>=0&&t<a.length?a[t]:null},getReferenceObject:(e,t)=>{var a=e.getOptions().referenceLines;return a&&t>=0&&t<a.length?a[t]:null}},s={renderEmptyText:(e,a,s)=>{var n=e.getOptions(),r=n.translations,o=n.emptyText;o||(o=r.labelNoData),i.hasValidData(e)||(o=r.labelInvalidData);var l=n._statusMessageStyle;if(l.getStyle("font-size")||l.setStyle("font-size","13px"),"statusMeter"===e.type){var h=l.getStyle("color");h=h||"#333333",l.setStyle("color",h)}e.renderEmptyText(a,o,new t.Rectangle(s.x,s.y,s.w,s.h),e.getEventManager(),l)},getFormattedMetricLabel:(e,t)=>{var a=t.getOptions();if(a.metricLabel.text)return a.metricLabel.text;var i=a.metricLabel.converter,n=a.metricLabel.scaling,r=a.metricLabel.autoPrecision?a.metricLabel.autoPrecision:"on",o="percent"===a.metricLabel.textType;return s._formatMetricLabelValue(e,t,i,n,r,o)},_formatMetricLabelValue:(e,t,i,n,r,o)=>{var l,h=t.getOptions(),d=h.min,g=h.max,u=g-d,c=u<1e3?100:1e3,p=null;isNaN(u)||(p=u/c),o&&(e=s.getFillPercentage(h,h.min,h.max,e,!0));var _=new a.LinearScaleAxisValueFormatter(d,g,p,n,r,h.translations);if(i&&i.format)l=_.format(e,i);else if(o){var v=t.getCtx().getNumberConverter({style:"percent",maximumFractionDigits:0,minimumFractionDigits:0});l=v&&v.format?v.format(e):String(Math.round(100*e))+"%"}else l=_.format(e);return l},getFillPercentage:(e,t,a,i,s)=>{var n=(i-t)/(e.max-e.min);return n=s?n:Math.min(Math.max(0,n),1)},getTooltipString:e=>{var a=e.getOptions(),n=i.getValThresholdIdx(e),r=i.getThreshold(e,n),o=s.getFormattedMetricLabel(a.value,e);return r&&null!=r.shortDesc?r.shortDesc:null!=a.shortDesc?a.shortDesc:a.label.text?t.ResourceUtils.format(a.translations.labelAndValue,[a.label.text,o]):o},renderMetricLabel:(e,a,i,n,r,o,l)=>{var h=e.getOptions(),d=!1;if("on"===h.metricLabel.rendered||l&&"off"!==h.metricLabel.rendered){var g=s.getFormattedMetricLabel(h.value,e),u=s.getFormattedMetricLabel(h.min,e),c=s.getFormattedMetricLabel(h.max,e),p=new t.OutputText(e.getCtx(),g,i.x+i.w/2,i.y+i.h/2);p.setCSSStyle(h.metricLabel.style);var _=h.metricLabel.style.getStyle("font-size");_||(_=s.calcLabelFontSize([g,u,c],p,i),p.setTextString(g),p.setFontSize(_)),"top"===o?(p.setY(i.y),p.alignTop()):"middle"===o?t.TextUtils.centerTextVertically(p,i.y+i.h/2):"bottom"===o&&(p.setY(i.y+i.h),p.alignBottom()),"center"===r?p.alignCenter():"left"==r?(p.setX(i.x),p.alignLeft()):"right"===r&&(p.setX(i.x+i.w),p.alignRight()),null!=n&&p.setSolidFill(n),d=t.TextUtils.fitText(p,i.w,i.h,a)}return d},renderLabel:(e,a,i,s,n)=>{var r=e.getOptions(),o=!1;if(r.label.text){var l=r.label.text,h=r.label.style,d=new t.MultilineText(e.getCtx(),l),g=h.clone();d.setCSSStyle(h);var u=h.getStyle("font-size")||t.TextUtils.getOptimalFontSize(d.getCtx(),d.getTextString(),d.getCSSStyle(),i);g.setFontSize("font-size",u,e.getCtx()),null!=s&&g.setStyle("color",s),d.setCSSStyle(g),o=t.TextUtils.fitText(d,i.w,i.h,e);var c=d.getDimensions().h;"top"===n?d.setY(i.y):"bottom"===n?d.setY(i.y+i.h-c):d.setY(i.y+i.h/2-c/2),d.setX(i.x+i.w/2),d.alignCenter(),a.addChild(d)}return o},calcLabelFontSize:(e,a,i)=>{for(var s=0,n=null,r=0,o=0;o<e.length;o++)a.setTextString(e[o]),(r=a.getDimensions().w)>s&&(n=e[o],s=r);return a.setTextString(n),t.TextUtils.getOptimalFontSize(a.getCtx(),a.getTextString(),a.getCSSStyle(),i)},adjustForStep:(e,t)=>{var a=Number(e.step);if(a&&a>0){var i=t/a;if(i<.5)return e.min;var s=Math.ceil(i)*a;return Math.max(Math.min(e.max,s),e.min)}return t}};class n extends t.Automation{getDomElementForSubId(e){if(e===t.Automation.TOOLTIP_SUBID)return this.GetTooltipElement(this._comp);if(0===e.indexOf("item")){var a=e.indexOf("["),i=e.indexOf("]");if(a>0&&i>0){var s=e.substring(a+1,i),n=this._comp.__getRatingGaugeItem(s);if(n)return n.getElem()}}return null}GetSubIdForDomElement(e){for(var t=this._comp,a=t.getOptions(),i=0;i<a.max;i++){if(t.__getRatingGaugeItem(i)===e)return"item["+i+"]"}return null}getValue(){return this._comp.getOptions().value}getMetricLabel(){return s.getFormattedMetricLabel(this.getValue(),this._comp)}}class r extends t.EventManager{constructor(e){super(e.getCtx(),e.dispatchEvent,e,e),this._gauge=e,this.IsMouseEditing=!1}OnMouseDown(e){if(this._gauge.IsInteractive()){this.IsMouseEditing=!0,this.hideTooltip();var t=this.GetRelativePosition(e.pageX,e.pageY);this._gauge.__processValueChangeStart(t.x,t.y),e.preventDefault()}else super.OnMouseDown(e)}OnMouseUp(e){this.IsMouseEditing?this.StopMouseEditing(e):super.OnMouseUp(e)}OnMouseMove(e){if(this.IsMouseEditing){var t=this.GetRelativePosition(e.pageX,e.pageY);this._gauge.__processValueChangeMove(t.x,t.y)}!this.IsShowingTooltipWhileEditing()&&this.IsMouseEditing||super.OnMouseMove(e)}IsShowingTooltipWhileEditing(){return!1}PreEventBubble(e){var a;t.TouchEvent.TOUCHSTART===e.type&&this._gauge.IsInteractive()?(this.IsMouseEditing=!0,a=this.GetRelativePosition(e.touches[0].pageX,e.touches[0].pageY),this._gauge.__processValueChangeStart(a.x,a.y),e.preventDefault()):t.TouchEvent.TOUCHMOVE===e.type&&this.IsMouseEditing?(a=this.GetRelativePosition(e.touches[0].pageX,e.touches[0].pageY),this._gauge.__processValueChangeMove(a.x,a.y),e.preventDefault()):t.TouchEvent.TOUCHEND===e.type&&this.IsMouseEditing&&(this.IsMouseEditing=!1,a=this.GetRelativePosition(e.changedTouches[0].pageX,e.changedTouches[0].pageY),this._gauge.__processValueChangeEnd(a.x,a.y),e.preventDefault()),this.IsMouseEditing&&!this.IsShowingTooltipWhileEditing()||super.PreEventBubble(e)}ProcessKeyboardEvent(e){if(!this.KeyboardHandler)return!1;this.KeyboardHandler.processKeyDown(e);var a=e.keyCode;if(a===t.KeyboardEvent.UP_ARROW||a===t.KeyboardEvent.LEFT_ARROW||a===t.KeyboardEvent.DOWN_ARROW||a===t.KeyboardEvent.RIGHT_ARROW||a===t.KeyboardEvent.TAB){var i=this._gauge.getCtx().getStageAbsolutePosition();this.ProcessObjectTooltip(e,i.x,i.y,this._gauge.__getLogicalObject(),this._gauge)}return!1}OnBlur(e){super.OnBlur(e),this.hideTooltip()}GetRelativePosition(e,t){var a=this.getCtx().pageToStageCoords(e,t);return this._gauge.stageToLocal(a)}UpdateActiveElement(e,t){}__isMouseEditing(){return this.IsMouseEditing}StopMouseEditing(e){this.IsMouseEditing=!1;var t=this.GetRelativePosition(e.pageX,e.pageY);this._gauge.__processValueChangeEnd(t.x,t.y)}}class o extends t.KeyboardHandler{constructor(e,t){super(e),this._gauge=t}processKeyDown(e){var a=e.keyCode,i=t.Agent.isRightToLeft(this._gauge.getCtx()),s=this._gauge.getOptions().value;this._gauge.getOptions().readOnly||(a!==t.KeyboardEvent.ENTER&&a!==t.KeyboardEvent.TAB||this._oldValue===s?a===t.KeyboardEvent.UP_ARROW||a===(i?t.KeyboardEvent.LEFT_ARROW:t.KeyboardEvent.RIGHT_ARROW)?(this._gauge.__increaseValue(),t.EventManager.consumeEvent(e)):a!==t.KeyboardEvent.DOWN_ARROW&&a!==(i?t.KeyboardEvent.RIGHT_ARROW:t.KeyboardEvent.LEFT_ARROW)||(this._gauge.__decreaseValue(),t.EventManager.consumeEvent(e)):(this._gauge.dispatchEvent(t.EventFactory.newValueChangeEvent(this._oldValue,s,!0)),this._oldValue=null),null===this._oldValue&&(this._oldValue=s))}}const l={getColor:e=>{var t=e.getOptions(),a=i.getValThresholdIdx(e),s=i.getThreshold(e,a);return s&&("statusMeter"!==e.type||"statusMeter"===e.type&&"onIndicator"===t.thresholdDisplay)?l.getThresholdColor(e,s,a):t.color},getBorderColor:e=>{var t=e.getOptions(),a=i.getValThresholdIdx(e),s=i.getThreshold(e,a);return s&&s.borderColor&&("statusMeter"!==e.type||"statusMeter"===e.type&&"onIndicator"===t.thresholdDisplay)?s.borderColor:t.borderColor},getPlotAreaColor:e=>{var t=e.getOptions(),a=i.getValThresholdIdx(e),s=i.getThreshold(e,a);return s&&("statusMeter"!==e.type||"statusMeter"===e.type&&"onIndicator"!==t.thresholdDisplay)?l.getThresholdColor(e,s,a):t.plotArea.color},getPlotAreaBorderColor:e=>{var t=e.getOptions(),a=t.plotArea.borderColor;return"statusMeter"===e.type&&"circular"==t.orientation?null:a},getThresholdColor:(e,t,a)=>{if(t.color)return t.color;var i=e.getOptions(),s=a%i._thresholdColors.length;return i._thresholdColors[s]}};class h extends t.BaseComponent{constructor(e,a,i,s){super(e,a,i),e.getStage().setCursor(""),this._bStaticRendering=s,this._bStaticRendering||(this.EventManager=this.CreateEventManager(),this.EventManager.addListeners(this),t.Agent.isTouchDevice()||this.EventManager.setKeyboardHandler(this.CreateKeyboardHandler(this.EventManager)),this.setId("gauge1000"+Math.floor(1e9*Math.random())),this._editingOverlay=new t.Rect(e,0,0),this._editingOverlay.setInvisibleFill(),this.addChild(this._editingOverlay)),this._bEditing=!1,this._bResizeRender=!1,this._oldValue=null}SetOptions(e){this.Options=e,t.Agent.isEnvironmentTest()&&(this.Options.animationOnDisplay="none",this.Options.animationOnDataChange="none"),"ie"!==t.Agent.browser&&"edge"!==t.Agent.browser||"auto"!==this.Options.visualEffects||(this.Options.visualEffects="none"),e.className&&(this.Options.svgClassName=e.className),e.style&&(this.Options.svgStyle=e.style)}render(e,a,i){if(e?this.SetOptions(e):this.Options||this.SetOptions(null),this.Options.thresholds){var s=this.Options.thresholds;this.Options.thresholds=s.sort(h._thresholdComparator)}"number"==typeof a&&"number"==typeof i&&(0!==this.Width&&this.Width!==a||0!==this.Height&&this.Height!==i?this._bResizeRender=!0:this._bResizeRender=!1,this.Width=a,this.Height=i),this.__oldShapes=this.__shapes,this.__shapes=[];var n=new t.Container(this.getCtx());this.addChildAt(n,0),!1!==this.Render(n,this.Width,this.Height)&&this.PostRender(e,n)}PostRender(e,a){if(this._setAnimation(a,null!=e,this.__oldShapes,this.Width,this.Height),this._editingOverlay&&(this._editingOverlay.setWidth(this.Width),this._editingOverlay.setHeight(this.Height),this.getEventManager().associate(this._editingOverlay,this.__getLogicalObject(),!0)),this.UpdateAriaAttributes(),!this._bStaticRendering&&!this.Options.readOnly){a.setAriaRole("slider"),a.setAriaProperty("valuemin",this.Options.min),a.setAriaProperty("valuemax",this.Options.max);var i=s.getFormattedMetricLabel(this.Options.value,this);a.setAriaProperty("valuenow",i);var n=s.getTooltipString(this);t.Agent.isTouchDevice()&&(this._container.setAriaProperty("live","assertive"),i!==n&&(n=i+t.AriaUtils.ARIA_LABEL_DESC_DELIMITER+n)),i!==n&&a.setAriaProperty("label",n),this._renderCount=null!=this._renderCount?this._renderCount+1:0;var r=this.getId()+"_"+this._renderCount;a.setId(r),this.getCtx().setActiveElement(a)}this.Options._selectingCursor&&this.setCursor(t.SelectionEffectUtils.getSelectingCursor()),this.Animation||this.RenderComplete()}__getLogicalObject(){var e=this.Options.tooltip,a=e?e.renderer:null,i=l.getColor(this);if(a){var n={component:this.Options._widgetConstructor,label:s.getFormattedMetricLabel(this.Options.value,this),color:i};return new t.CustomDatatipPeer(this.getCtx().getTooltipManager(),a,i,n)}var r=s.getTooltipString(this);return new t.SimpleObjPeer(null,r,i)}Render(e,t,a){}_setAnimation(e,a,i,s,n){this.StopAnimation();var r=!1,o=this._bEditing||this._bResizeRender?"none":this.getOptions().animationOnDataChange,l=this._bEditing||this._bResizeRender?"none":this.getOptions().animationOnDisplay,h=t.CSSStyle.getTimeMilliseconds(this.getOptions().animationDuration)/1e3;if(l||o){var d=new t.Rectangle(0,0,s,n),g=this.getCtx();this._container||"none"===l||null==this.__shapes[0]?this._container&&"none"!==o&&a&&null!=this.__shapes[0]&&(this.Animation=t.BlackBoxAnimationHandler.getCombinedAnimation(g,o,this._container,e,d,h),this.Animation?r=!0:this.Animation=this.CreateAnimOnDataChange(i,this.__shapes,l,h)):(this.Animation=t.BlackBoxAnimationHandler.getInAnimation(g,l,e,d,h),this.Animation||(this.Animation=this.CreateAnimOnDisplay(this.__shapes,l,h))),!r&&this._container&&(this.removeChild(this._container),this._container.destroy()),this.Animation&&(this.Animation.play(),this.Animation.setOnEnd(this._onAnimEnd,this)),r&&(this._oldContainer=this._container),this._container=e}}CreateAnimOnDisplay(e,t,a){return null}CreateAnimOnDataChange(e,a,i,s){for(var n=[],r=0;r<e.length;r++){var o=e[r],l=a[r],h=o.getAnimParams(),d=l.getAnimParams();l.setAnimParams(h);var g=new t.CustomAnimation(this.getCtx(),l,s);g.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,l,l.getAnimParams,l.setAnimParams,d),n.push(g)}return new t.ParallelPlayable(this.getCtx(),n)}GetValueAt(e,t){return null}renderUpdate(){this.render(),this.UpdateAriaLiveValue(this._container)}UpdateAriaLiveValue(e,a){a=s.getFormattedMetricLabel(a||this.Options.value,this),e.setAriaProperty("valuenow",a),t.Agent.isTouchDevice()&&e.setAriaProperty("label",a)}_onAnimEnd(){this._oldContainer&&(this.removeChild(this._oldContainer),this._oldContainer.destroy(),this._oldContainer=null),this.AnimationStopped||this.RenderComplete(),this.Animation=null,this.AnimationStopped=!1}__processValueChangeStart(e,t){this._bEditing=!0,this._oldValue=this.Options.value,this.__processValueChangeMove(e,t)}__processValueChangeMove(e,a){if(null!=this._oldValue){var i=s.adjustForStep(this.Options,this.GetValueAt(e,a));i!==this.Options.value&&(this.Options.value=i,this.renderUpdate(),this.dispatchEvent(t.EventFactory.newValueChangeEvent(this._oldValue,this.Options.value,!1)))}}__processValueChangeEnd(e,a){if(this.__processValueChangeMove(e,a),t.Agent.isTouchDevice()){var i=s.getFormattedMetricLabel(this.Options.value,this),n=s.getTooltipString(this);i!==n&&(n=i+t.AriaUtils.ARIA_LABEL_DESC_DELIMITER+n,this._container.setAriaProperty("label",n))}this.dispatchEvent(t.EventFactory.newValueChangeEvent(this._oldValue,this.Options.value,!0)),this._bEditing=!1,this._oldValue=null}__increaseValue(){if(!this.Options.readOnly){var e=this.Options.value;if(null!=this.Options.step){var a=this.Options.value+this.Options.step;this.Options.value=s.adjustForStep(this.Options,a)}else{var i=(this.Options.max-this.Options.min)/100;this.Options.value=Math.min(Math.max(this.Options.value+i,this.Options.min),this.Options.max)}this.renderUpdate(),this.dispatchEvent(t.EventFactory.newValueChangeEvent(e,this.Options.value,!1))}}__decreaseValue(){if(!this.Options.readOnly){var e=this.Options.value;if(null!=this.Options.step){var a=this.Options.value-this.Options.step;this.Options.value=s.adjustForStep(this.Options,a)}else{var i=(this.Options.max-this.Options.min)/100;this.Options.value=Math.min(Math.max(this.Options.value-i,this.Options.min),this.Options.max)}this.renderUpdate(),this.dispatchEvent(t.EventFactory.newValueChangeEvent(e,this.Options.value,!1))}}CreateEventManager(){return new r(this)}static _thresholdComparator(e,t){return null!=e.max&&null!=t.max?e.max-t.max:e.max?-1/0:1/0}getAutomation(){return new n(this)}CreateKeyboardHandler(e){return new o(e,this)}UpdateAriaAttributes(){if(!this._bStaticRendering){var e=s.getTooltipString(this);if(this.IsParentRoot()){var a=this.Options.translations;this.IsInteractive()?(this.getCtx().setAriaRole("application"),this.getCtx().setAriaLabel(t.ResourceUtils.format(a.labelAndValue,[a.labelDataVisualization,t.AriaUtils.processAriaLabel(this.GetComponentDescription())]))):(this.getCtx().setAriaRole("img"),this.getCtx().setAriaLabel(t.ResourceUtils.format(a.labelAndValue,[a.labelDataVisualization,t.Displayable.generateAriaLabel(t.AriaUtils.processAriaLabel(this.GetComponentDescription()),e?[e]:null)])))}else this.IsInteractive()||(this.setAriaRole("img"),this.setAriaProperty("label",t.Displayable.generateAriaLabel(t.AriaUtils.processAriaLabel(this.GetComponentDescription()),e?[e]:null)))}}IsInteractive(){return!this.Options.readOnly}}class d extends t.BaseComponentDefaults{constructor(e){const a={skin:t.CSSStyle.SKIN_ALTA,min:0,max:100,center:{},color:"#393737",borderColor:null,visualEffects:"auto",emptyText:null,animationOnDataChange:"none",animationOnDisplay:"none",animationDuration:500,readOnly:"true",metricLabel:{rendered:"auto",scaling:"auto",style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA),textType:"number"},_statusMessageStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA),label:{style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA),position:"auto"},_thresholdColors:["#ed6647","#fad55c","#68c182"],__layout:{outerGap:1,labelGap:5}};super({alta:t.JsonUtils.merge(e.alta,a)})}}class g extends d{constructor(e){super({alta:{type:"circle"}},e)}}const u={_SHAPE_TRIANGLE_CMDS:[-50,36.6,0,-50,50,36.6],_SHAPE_STAR_CMDS:"M 13.686617627555295 -14.844072859624454 L 0 -49.99999973529656 L -13.686617627555295 -14.844072859624454 L -49.21031057098533 -11.804119976838445 L -22.1446397569434 12.966333294730747 L -30.4142789122285 49.99999973529656 L 0 30.151376755728354 L 30.4142789122285 49.99999973529656 L 22.1446397569434 12.966333294730747 L 49.21031057098533 -11.804119976838445 Z ",_SHAPE_ARROW_CMDS:[25,48,25,8,47.5,8,0,-39,-47.5,8,-25,8,-25,48],_SHAPE_HUMAN_CMDS:"M -0.06059525142297417 -50.86842065108466 C -11.4496388584463 -50.86842065108466 -20.708163169810554 -39.024253028220556 -20.708163169810554 -24.413724255650386 C -20.708163169810554 -9.803195483080515 -11.4496388584463 2.040972139783591 -0.06059525142297417 2.040972139783591 C 11.328499974520241 2.040972139783591 20.586972666964613 -9.803195483080515 20.586972666964613 -24.413724255650386 C 20.586972666964613 -39.024253028220556 11.328499974520241 -50.86842065108466 -0.06059525142297417 -50.86842065108466 z M -23.93434565705865 -2.959610715450779 C -30.908061721494278 3.3998402034127153 -42.00096758564793 18.817121073473572 -38.77478509839983 33.65756051481475 C -20.651382358034887 47.30044101688934 14.372054723529814 49.13162219665128 39.298831093003386 32.85101489300273 C 40.26410489318826 16.477493533721187 32.34060070450674 4.7883891459240715 23.167918656763206 -2.959610715450779 C 11.553661702670112 21.074158341552575 -11.029615708066558 16.237465556670102 -23.93434565705865 -2.959610715450779 z ",render:(e,a,n,r)=>{if(i.hasData(e)){var o=e.getOptions(),h=o.__layout.outerGap,d=o&&(o.size>=0||o.size<1)?Math.sqrt(o.size):1,g=new t.Rectangle(h+(n-2*h)*(1-d)/2,h+(r-2*h)*(1-d)/2,(n-2*h)*d,(r-2*h)*d);u._renderShape(e,a,g);var c=!1,p=t.ColorUtils.getContrastingTextColor(l.getColor(e));if(o.label.text){var _="middle",v=u._getMetricLabelBounds(e,a,g);"on"===o.metricLabel.rendered&&(v.y=v.y+.6*v.h,v.h=.4*v.h,_="top"),c=t.Agent.isHighContrast()||null==o.label.style.getStyle("color")?s.renderLabel(e,a,v,p,_):s.renderLabel(e,a,v,null,_)}if("on"===o.metricLabel.rendered){var m=u._getMetricLabelBounds(e,a,g),x="middle";c&&(m.h=.55*m.h,x="bottom"),t.Agent.isHighContrast()||null==o.metricLabel.style.getStyle("color")?s.renderMetricLabel(e,a,m,p,"center",x):s.renderMetricLabel(e,a,m,null,"center",x)}}else s.renderEmptyText(e,a,new t.Rectangle(0,0,n,r))},_renderShape:(e,a,i)=>{var s,n,r=e.getCtx(),o=e.getOptions(),h=o.type,d=l.getColor(e),g=l.getBorderColor(e),c=i.x+i.w/2,p=i.y+i.h/2,_=Math.min(i.w,i.h)/2;u._cache||(u._cache=new t.Cache(50));var v=Math.min(i.w/100,i.h/100);if("square"===h)s=new t.Rect(r,c-_,p-_,2*_,2*_);else if("rectangle"==h)s=new t.Rect(r,i.x,i.y,i.w,i.h);else if("diamond"===h)s=new t.Polygon(r,[c-_,p,c,p-_,c+_,p,c,p+_]);else if("circle"===h)s=new t.Circle(r,c,p,_);else{if("star"===h)n=u._SHAPE_STAR_CMDS;else if("triangle"===h)n=u._SHAPE_TRIANGLE_CMDS;else if("arrow"===h)n=u._SHAPE_ARROW_CMDS;else if("human"===h)n=u._SHAPE_HUMAN_CMDS;else if(!(n=u._cache.get(h))){s=new t.Path(r,h);var m=t.DisplayableUtils.getDimForced(r,s),x=100/Math.max(m.w,m.h);n=t.PathUtils.transformPath(s.getCommandsArray(),-x*(m.x+m.w/2),-x*(m.y+m.h/2),x,x),u._cache.put(h,n)}"triangle"===h||"arrow"===h?(n=t.PolygonUtils.scale(n,v,v),n=t.PolygonUtils.translate(n,i.x+i.w/2,i.y+i.h/2),s=new t.Polygon(r,n)):(n=t.PathUtils.transformPath(t.PathUtils.createPathArray(n),i.x+i.w/2,i.y+i.h/2,v,v),s=new t.Path(r,n))}var C=e.getCtx().getThemeBehavior();if("none"===o.visualEffects||"redwood"===C)s.setSolidFill(d);else{var y=[t.ColorUtils.adjustHSL(d,0,-.09,.04),t.ColorUtils.adjustHSL(d,0,-.04,-.05)],b=o&&o.rotation%90==0?o.rotation:0,S="arrow"===h||"star"===h||"triangle"===h?b-90:270;s.setFill(new t.LinearGradientFill(S,y,[1,1],[0,1]))}g&&s.setSolidStroke(g),s.setClassName(o.svgClassName),s.setStyle(o.svgStyle),(b=o.rotation)&&("arrow"===h||"triangle"===h||s instanceof t.Path&&"human"!==h&&"star"!==h)&&(s=u._rotate(e,a,s,i)),a.addChild(s)},_rotate:(e,a,i,s)=>{var n=e.getOptions(),r=new t.Container(e.getCtx());a.addChild(r),r.addChild(i);var o=n&&n.rotation%90==0?n.rotation:0,l=new t.Matrix;i.setMatrix(l.rotate(Math.PI*o/180));var h=r.getDimensions(),d=s.x+s.w/2-(h.x+h.w/2),g=s.y+s.h/2-(h.y+h.h/2),u=new t.Matrix;return r.setMatrix(u.translate(d,g)),r},_getMetricLabelBounds:(e,a,i)=>{var s=e.getOptions(),n=s.type,r=s.rotation%90==0?s.rotation:0,o=Math.min(i.w,i.h),l=i.x+i.w/2-o/2,h=i.y+i.h/2-o/2,d=o,g=o;return"triangle"===n?0===r?(l+=.2*o,h+=.25*o,d-=.4*o,g-=.3*o):90===r?(l+=.05*o,h+=.2*o,d-=.3*o,g-=.4*o):180===r?(l+=.2*o,h+=.05*o,d-=.4*o,g-=.3*o):270===r&&(l+=.25*o,h+=.2*o,d-=.3*o,g-=.4*o):"arrow"===n?0===r?(l+=.2*o,h+=.2*o,d-=.4*o,g-=.4*o):90===r?(l+=.05*o,h+=.2*o,d-=.28*o,g-=.4*o):180===r?(l+=.2*o,h+=.2*o,d-=.4*o,g-=.4*o):270===r&&(l+=.23*o,h+=.2*o,d-=.28*o,g-=.4*o):"star"===n?(l+=.25*o,h+=.25*o,d-=.5*o,g-=.4*o):"diamond"===n?(l+=.15*o,h+=.15*o,d-=.3*o,g-=.3*o):"rectangle"===n?(l+=.1*o,h+=.1*o,d-=.2*o,g-=.2*o):(l+=.15*o,h+=.15*o,d-=.3*o,g-=.3*o),new t.Rectangle(l,h,d,g)}};class c extends h{constructor(e,t,a,i){super(e,t,a,i),this.type="led",this.Defaults=new g(e)}SetOptions(e){(e=t.JsonUtils.clone(e)).title&&(e.label=e.title),super.SetOptions(this.Defaults.calcOptions(e)),"auto"===this.Options.animationOnDisplay&&(this.Options.animationOnDisplay="zoom"),"auto"===this.Options.animationOnDataChange&&(this.Options.animationOnDataChange="alphaFade"),this.Options.readOnly=!0}Render(e,t,a){u.render(this,e,t,a)}}class p extends d{constructor(e){super({alta:{min:0,max:5,orientation:"horizontal",unselectedState:{shape:"star",color:"#C4CED7"},selectedState:{shape:"star",color:"#F8C15A"},hoverState:{shape:"star",color:"#007CC8"},changedState:{shape:"star",color:"#ED2C02"},preserveAspectRatio:"meet",step:1}},e)}}class _ extends r{constructor(e){super(e),this._gauge=e}OnMouseOver(e){if(this._gauge.IsInteractive()){var t=this.GetRelativePosition(e.pageX,e.pageY);this._gauge.__processValueChangeStart(t.x,t.y),this.IsMouseEditing=!0}super.OnMouseOver(e)}OnMouseOut(e){if(this._gauge.IsInteractive()){var t=this.GetRelativePosition(e.pageX,e.pageY);this._gauge.__processHoverEnd(t.x,t.y),this.IsMouseEditing=!1}super.OnMouseOut(e)}OnMouseMove(e){var t=this.GetRelativePosition(e.pageX,e.pageY),a=!0===this._gauge.getOptions().disabled;this._gauge.IsInteractive()&&!this.IsMouseEditing&&this._gauge.getOptions().value!==this._gauge.GetValueAt(t.x,t.y)&&(this.IsMouseEditing=!0),a||super.OnMouseMove(e)}OnMouseDown(e){r.prototype.OnMouseDown.call(this,e)}OnContextMenu(e){var a=t.Agent.engine;"webkit"!==a&&"blink"!==a||"mac"!==t.Agent.os||this.IsMouseEditing&&this.StopMouseEditing(e),super.OnContextMenu(e)}ProcessKeyboardEvent(e){return this.IsMouseEditing=!1,super.ProcessKeyboardEvent(e)}IsShowingTooltipWhileEditing(){return!0}}class v extends t.SimpleObjPeer{constructor(e){super(),this._gauge=e}getDatatip(e,t,a){var s,n=this._gauge.getOptions();s=this._gauge.getEventManager().__isMouseEditing()?i.getValThresholdIdx(this._gauge,this._gauge.GetValueAt(t,a)):i.getValThresholdIdx(this._gauge);var r=i.getThreshold(this._gauge,s);return r&&r.shortDesc?r.shortDesc:n.shortDesc}}const m={render:(e,a,n,r)=>{if(i.hasData(e)){var o=e.getOptions(),l=i.getValThresholdIdx(e),h=i.getThreshold(e,l),d=o.selectedState.color,g=o.changedState.color,u=o.selectedState.borderColor,c=o.changedState.borderColor;h&&h.color&&(d=h.color,g=h.color),h&&h.borderColor&&(u=h.borderColor,c=h.borderColor);var p={value:0,state:"unselected",type:o.unselectedState.shape,color:o.unselectedState.color,borderColor:o.unselectedState.borderColor,visualEffects:o.visualEffects,source:o.unselectedState.source,svgClassName:o.unselectedState.svgClassName,svgStyle:o.unselectedState.svgStyle},_={value:0,state:"selected",type:o.selectedState.shape,color:d,borderColor:u,visualEffects:o.visualEffects,source:o.selectedState.source,svgClassName:o.selectedState.svgClassName,svgStyle:o.selectedState.svgStyle},v={value:0,state:"changed",type:o.changedState.shape,color:g,borderColor:c,visualEffects:o.visualEffects,source:o.changedState.source,svgClassName:o.changedState.svgClassName,svgStyle:o.changedState.svgStyle},x={value:0,state:"hover",type:o.hoverState.shape,color:o.hoverState.color,borderColor:o.hoverState.borderColor,visualEffects:o.visualEffects,source:o.hoverState.source,svgClassName:o.hoverState.svgClassName,svgStyle:o.hoverState.svgStyle};"dot"==o.unselectedState.shape&&(p.type="circle",p.visualEffects="none",p.size=.05),m._createShapes(e,a,p),m._createShapes(e,a,o.changed?v:_),o.readOnly||o.disabled||m._createShapes(e,a,x),e.__updateClipRects(o.value,"render",a)}else s.renderEmptyText(e,a,new t.Rectangle(0,0,n,r))},_createShapes:(e,a,i)=>{var s=e.getCtx(),n=new t.Container(s);a.addChild(n);for(var r=e.getOptions(),o=e.__bounds,l=e.__shapeWidth,h=e.__shapeHeight,d="ie"===t.Agent.browser||"edge"===t.Agent.browser?null:m._createShape(s,0,0,l,h,i,r),g=0;g<r.max;g++){var u,c;if("vertical"==r.orientation?(u=o.x+o.w/2-l/2,c=o.y+o.h-(g+1)*h):t.Agent.isRightToLeft(s)?(u=o.x+o.w-(g+1)*l,c=o.y+o.h/2-h/2):(u=o.x+g*l,c=o.y+o.h/2-h/2),"ie"===t.Agent.browser||"edge"===t.Agent.browser){var p=m._createShape(s,u,c,l,h,i,r);p&&n.addChild(p)}else if(d){var _=new t.Use(s,u,c,d);n.addChild(_)}}},_createShape:(e,a,i,s,n,r,o)=>{var l;if(r.source)l=new t.ImageMarker(e,a+s/2,i+n/2,s,n,null,r.source),"none"===o.preserveAspectRatio&&l.setPreserveAspectRatio("none");else if("none"!=r.type){if(l=new c(e,null,null,!0),0!=a&&0!=i&&l.setTranslate(a,i),o.disabled||t.Agent.isHighContrast()){var h=`oj-rating-gauge-${"unselected"===r.state?"unselected":"selected"}${o.disabled?"-disabled":""}`;o.disabled?(r.svgClassName=h,r.svgStyle=null):r.svgClassName=`${r.svgClassName||""} ${h}`.trim(),t.Agent.isHighContrast()&&l.addClassName("oj-hicontrast")}l.render(r,s,n)}return l}};class x extends d{constructor(e){super({alta:{angleExtent:360,borderRadius:"auto",color:"#393737",indicatorSize:1,innerRadius:.7,metricLabel:{style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA),position:"auto"},orientation:"horizontal",plotArea:{color:"#E4E8EA",rendered:"auto",borderRadius:"auto"},startAngle:90,thresholdDisplay:"onIndicator"}},e)}}class C extends(a.DataAxisInfoMixin(a.BaseAxisInfo)){}const y={calcPointOnArc:(e,t,a)=>({x:Math.cos(a)*t+e.w/2+e.x,y:Math.sin(a)*t+e.h/2+e.y}),createCircularPathCmd:(e,a,i,s,n)=>{var r,o,l,h,d;return i<t.Math.TWO_PI?(o=y.calcPointOnArc(e,n,a),l=y.calcPointOnArc(e,n,a+i),h=y.calcPointOnArc(e,s,a+i),d=y.calcPointOnArc(e,s,a),r=t.PathUtils.moveTo(o.x,o.y)+t.PathUtils.arcTo(n,n,i,1,l.x,l.y)+t.PathUtils.lineTo(h.x,h.y)+t.PathUtils.arcTo(s,s,i,0,d.x,d.y)+t.PathUtils.closePath()):(o=y.calcPointOnArc(e,n,a),l=y.calcPointOnArc(e,n,a+i/2),h=y.calcPointOnArc(e,s,a),d=y.calcPointOnArc(e,s,a+i/2),r=t.PathUtils.moveTo(o.x,o.y)+t.PathUtils.arcTo(n,n,i/2,1,l.x,l.y)+t.PathUtils.arcTo(n,n,i/2,1,o.x,o.y),s>0&&(r+=t.PathUtils.moveTo(d.x,d.y)+t.PathUtils.arcTo(s,s,i/2,0,h.x,h.y)+t.PathUtils.arcTo(s,s,i/2,0,d.x,d.y)),r+=t.PathUtils.closePath()),r}};class b extends t.Path{constructor(e,t,a,i,s,n){super(e),this.setPath(t,a,i,s,n)}setPath(e,a,i,s,n){e&&e instanceof t.Rectangle?this._bounds=e:e=this._bounds,this._startAngle=a,this._angleExtent=i,this._innerRadius=s,this._outerRadius=n,this.setCmds(y.createCircularPathCmd(e,a,i,s,n))}getAnimParams(){return[this._bounds,this._startAngle,this._angleExtent,this._innerRadius,this._outerRadius]}setAnimParams(e){e&&5==e.length&&this.setPath(e[0],e[1],e[2],e[3],e[4])}}class S extends t.Path{constructor(e,t,a,i,s,n){super(t),this._gauge=e,this.setCoords(a,i,s,n)}setCoords(e,a,i,s){this._x1=e,this._x2=a,this._y1=i,this._y2=s;var n=Math.min(e,a),r=Math.min(i,s),o=Math.abs(e-a),l=Math.abs(s-i),h=this._gauge.getOptions(),d="vertical"==h.orientation?o:l,g=t.PathUtils.rectangleWithBorderRadius(n,r,o,l,h.borderRadius,d,"15%");this.setCmds(g)}getAnimParams(){return[this._x1,this._x2,this._y1,this._y2]}setAnimParams(e){e&&4===e.length&&this.setCoords(e[0],e[1],e[2],e[3])}}const A={render:(e,a,n,r)=>{if(i.hasData(e)){var o=e.getOptions(),l=o.__layout.outerGap,h=new t.Rectangle(l,l,n-2*l,r-2*l);"horizontal"==o.orientation||"vertical"==o.orientation?(A._hasMetricLabelOutsidePlotArea(o)&&A._renderMetricLabelOutsidePlotArea(e,a,h),A._renderShape(e,a,h)):"circular"==o.orientation&&A._renderCircularGauge(e,a,h)}else s.renderEmptyText(e,a,new t.Rectangle(0,0,n,r))},_renderCircularGauge:(e,a,i)=>{var n,r=e.getOptions(),o=i.clone(),h=t.Agent.isRightToLeft(e.getCtx()),d=0,g=null,u=r.value,c=r.innerRadius,p=r.thresholds,_=null,v=t.Math.TWO_PI-t.Math.degreesToRads(r.startAngle),m=t.Math.degreesToRads(r.angleExtent),x=(v+m)%(2*Math.PI);e.cx=i.w/2,e.cy=i.h/2,m!=2*Math.PI&&(g=A._adjustCenterAndBounds(e,c,v,m,x,i,h),_=e.maxInnerDiameter);var C=.5*(n=Math.min(i.w,i.h))*c,y=.5*n,b=r.indicatorSize;if(b&&b>1){var S=(1-1/b)/2*(y-C);C+=S,y-=S}var w="middle";g||(_=Math.min(i.w,i.h)*c,g=new t.Rectangle(i.x+i.w/2-_*(3/7),i.y+i.h/2-_*(2.5/7),_*(6/7),_*(5/7)));if(r.label.text){var O="middle",M=new t.Rectangle(g.x,g.y,g.w,g.h);"off"!=r.metricLabel.rendered&&(M.y=M.y+.6*M.h,M.h=.4*M.h,O="top"),s.renderLabel(e,a,M,null,O)&&"off"!=r.metricLabel.rendered&&(g.h=.55*g.h,w="bottom")}s.renderMetricLabel(e,a,g,null,"center",w,!0);var f=v,P=d*m,E=l.getPlotAreaBorderColor(e);if(p&&"off"!=r.plotArea.rendered&&"all"==r.thresholdDisplay)for(var R=0;R<p.length;R++){var T=l.getThresholdColor(e,p[R],R),L=p[R].max<r.max&&R!=p.length-1?p[R].max:r.max,I=0==R?r.min:p[R-1].max;f=v+m*s.getFillPercentage(r,r.min,L,I),P=(d=s.getFillPercentage(r,I,L,L))*m;var D=p[R].borderColor;A._drawCircularArc(e,a,i,f,P,C,y,T,!0,D||E)}else if("off"!=r.plotArea.rendered&&"all"!=r.thresholdDisplay){var F=l.getPlotAreaColor(e);A._drawCircularArc(e,a,i,v,m,C,y,F,!0,E)}if(C=n*c*.5,y=.5*n,b&&b<1){var U=(1-b)/2*(y-C);C+=U,y-=U}P=(d=s.getFillPercentage(r,r.min,r.max,u))*m,A._drawCircularArc(e,a,i,v,P,C,y,l.getColor(e),!1);var V=r.referenceLines;if(V)for(var N=0;N<V.length;N++){var H=V[N].color?V[N].color:"black",z=V[N].lineWidth?V[N].lineWidth:2,W=V[N].lineStyle;u=V[N].value;var G=v+s.getFillPercentage(r,r.min,r.max,u)*m;A._drawCircularReferenceLine(e,a,i,G,H,z,W)}r.center.renderer&&A._renderCenterContent(e,r,i,o,_)},_renderShape:(e,a,i)=>{var s=e.getOptions(),n=t.Agent.isRightToLeft(e.getCtx()),r="vertical"==s.orientation,o={isRTL:n,layout:{gapRatio:0},timeAxisType:"disabled",position:r?"left":"bottom",min:s.min,max:s.max,dataMin:s.min,dataMax:s.max,tickLabel:{rendered:"off"},translations:s.translations},h=new C(e.getCtx(),o,i);e.__axisInfo=h;var d=0;s.max<=0?d=s.max:s.min>=0&&(d=s.min);var g=h.getCoordAt(d);"off"==s.plotArea.rendered||"auto"==s.plotArea.rendered&&"onIndicator"==s.thresholdDisplay||(g=h.getUnboundedCoordAt(s.min));var u=h.getUnboundedCoordAt(s.value);u=r?Math.max(i.y,Math.min(i.y+i.h,u)):Math.max(i.x,Math.min(i.x+i.w,u));var c,p,_,v,m,x,y,b,w=s.indicatorSize,O=0,M=w<1?1:w,f=w>1?1:w,P=Math.min(.5,(Math.abs(u-g)-.5)/2);r?(b=u>g?-1:1,c=i.x+(1-f)/2*i.w+.5,p=i.x+i.w*(1+f)/2-.5,v=g-b*P,_=u+b*P,m=i.x+(1-1/M)/2*i.w,x=i.x+i.w*(1+1/M)/2,y=i.y,O=i.y+i.h):(b=(n?u>g:u<g)?-1:1,c=n?g-b*P:g+b*P,p=n?u+b*P:u-b*P,_=i.y+(1-f)/2*i.h+.5,v=i.y+i.h*(1+f)/2-.5,m=i.x,x=i.x+i.w,y=i.y+(1-1/M)/2*i.h,O=i.y+i.h*(1+1/M)/2);var E=!0;s.value==s.min&&(r?_=v:c=p,E=!1);var R,T,L=l.getBorderColor(e),I=l.getPlotAreaBorderColor(e),D=s.thresholds,F=r?0:270;if(D&&"off"!=s.plotArea.rendered&&"all"==s.thresholdDisplay)for(T=D.length-1;T>=0;T--){var U=T;R=A._createShape(e,e.getCtx(),m,x,y,O);var V=new t.ClipPath("pacp"+e.getId());if(T==D.length-1)!r&&n?V.addRect(h.getUnboundedCoordAt(s.max)+1,0,i.w+2,i.h+2,0,0):V.addRect(0,0,i.w+2,i.h+2,0,0);else if(r){var N=s.max-D[D.length-2-U].max;V.addRect(0,h.getUnboundedCoordAt(s.max),i.w+2,1*Math.max(0,N)/Math.abs(s.min-s.max)*i.h,0,0)}else if(n){var H=null==D[D.length-2-U].max?100:D[D.length-2-U].max;V.addRect(h.getUnboundedCoordAt(s.max),0,1*Math.max(0,s.max-H)/Math.abs(s.min-s.max)*i.w,i.h+2,0,0)}else{var z=D[U].max-s.min;V.addRect(0,0,1*Math.max(0,z)/Math.abs(s.min-s.max)*i.w,i.h+2,0,0)}R.setClipPath(V),(n||r)&&(U=D.length-1-T),R.setSolidFill(l.getThresholdColor(e,D[U],U));var W=D[U].borderColor;R.setSolidStroke(W||I),A._renderPlotAreaVisualEffects(e,a,R,l.getThresholdColor(e,D[U],U),F)}else if("off"!==s.plotArea.rendered&&("auto"!=s.plotArea.rendered||"onIndicator"!=s.thresholdDisplay)&&"all"!=s.thresholdDisplay){R=r?A._createShape(e,e.getCtx(),m,x,h.getUnboundedCoordAt(s.max),h.getUnboundedCoordAt(s.min)):A._createShape(e,e.getCtx(),h.getUnboundedCoordAt(s.min),h.getUnboundedCoordAt(s.max),y,O);var G=l.getPlotAreaColor(e);R.setSolidFill(G),R.setSolidStroke(I),A._renderPlotAreaVisualEffects(e,a,R,G,F)}var B=new S(e,e.getCtx(),c,p,_,v);e.__shapes.push(B);var j,k,K,Y,X=l.getColor(e);if("redwood"===e.getCtx().getThemeBehavior()||"none"===s.visualEffects)B.setSolidFill(X);else{var q=[t.ColorUtils.adjustHSL(X,0,-.09,.04),t.ColorUtils.adjustHSL(X,0,-.04,-.05)],J=new t.LinearGradientFill(F,q,[1,1],[0,1]);B.setFill(J)}L&&B.setSolidStroke(L),B.setClassName(s.svgClassName),B.setStyle(s.svgStyle),E&&a.addChild(B),A._createShape(e,e.getCtx(),c,p,_,v);var $=s.referenceLines;if($)for(T=0;T<$.length;T++){var Q=$[T].color?$[T].color:"white",Z=$[T].value;w=s.indicatorSize,r?(Y=((1-w)/2+w)*i.w,j=i.x+(1-w)/4*i.w,k=h.getUnboundedCoordAt(Z),K=new t.Line(e.getCtx(),j,k,j+Y,k)):(Y=((1-w)/2+w)*i.h,j=h.getUnboundedCoordAt(Z),k=i.y+(1-w)/4*i.h,K=new t.Line(e.getCtx(),j,k,j,k+Y));var ee=$[T].lineWidth?$[T].lineWidth:2,te=$[T].lineStyle,ae=new t.Stroke(Q,1,ee,!1,t.Stroke.getDefaultDashProps(te,ee));if(K.setStroke(ae),a.addChild(K),"ie"!==t.Agent.browser&&"edge"!==t.Agent.browser&&"none"!=s.visualEffects){var ie=new t.Shadow(.5,.5,1,"rgba(0, 0, 0, 0.8)");K.addDrawEffect(ie)}}var se=s.metricLabel.position;if("on"!=s.metricLabel.rendered||A._hasMetricLabelOutsidePlotArea(s)||s.label.text)s.label.text&&A._renderLabel(e,a,i,se);else{var ne={x1:c,x2:p,y1:_,y2:v},re={x1:m,x2:x,y1:y,y2:O};A._renderMetricLabelInsidePlotArea(e,a,i,X,se,ne,re)}},_createShape:(e,a,i,s,n,r)=>{var o=Math.min(i,s),l=Math.min(n,r),h=Math.abs(i-s),d=Math.abs(r-n),g=e.getOptions(),u="vertical"==g.orientation?h:d,c="auto"!=g.plotArea.borderRadius?g.plotArea.borderRadius:g.borderRadius,p=t.PathUtils.rectangleWithBorderRadius(o,l,h,d,c,u,"15%");return new t.Path(a,p)},_renderPlotAreaVisualEffects:(e,a,i,s,n)=>{var r=e.getOptions();if(i.setMouseEnabled(!1),a.addChild(i),"redwood"!==e.getCtx().getThemeBehavior()&&"none"!==r.visualEffects){var o=[t.ColorUtils.adjustHSL(s,0,-.04,-.05),t.ColorUtils.adjustHSL(s,0,-.09,.04)],l=new t.LinearGradientFill(n,o,[1,1],[0,1]);i.setFill(l)}i.setClassName(r.plotArea.svgClassName),i.setStyle(r.plotArea.svgStyle)},_renderMetricLabelOutsidePlotArea:(e,a,i)=>{var n=e.getOptions(),r=t.Agent.isRightToLeft(e.getCtx()),o="vertical"==n.orientation,l=new t.OutputText(e.getCtx(),""),h=s.getFormattedMetricLabel(n.value,e),d=n.__layout.labelGap,g=n.metricLabel.style,u=g.getStyle("color");u=u||"#333333";var c,p,_,v,m,x=null;if(l.setCSSStyle(g),l.setSolidFill(u),o&&"on"==n.metricLabel.rendered){v=n.max>0?n.max:n.min,m=s.getFormattedMetricLabel(v,e),(_=new t.OutputText(e.getCtx(),m)).setCSSStyle(g);var C=new t.Rectangle(i.x,i.y+.8*i.h,i.w,.2*i.h);c=g.getStyle("font-size")||t.TextUtils.getOptimalFontSize(_.getCtx(),_.getTextString(),_.getCSSStyle(),C),_.setFontSize(c),x=_.getDimensions(),i.h-=x.h,l.setFontSize(c),l.setTextString(h),l.setX(i.x+i.w/2),l.setY(i.y+i.h),i.h-=d,l.alignCenter(),t.TextUtils.fitText(l,i.w,i.h,a)}else if(!o&&"on"==n.metricLabel.rendered){var y;if(c=g.getStyle("font-size"),p=s.getFormattedMetricLabel(n.min,e),_=s.getFormattedMetricLabel(n.max,e),void 0===c&&i.h<18&&(c=s.calcLabelFontSize([h,p,_],l,i)),c=c?parseInt(c):13,l.setFontSize(c),n.max>0||"off"!=n.plotArea.rendered||"auto"!=n.plotArea.rendered||"onIndicator"!=n.thresholdDisplay){v=n.max>0?n.max:n.min,m=s.getFormattedMetricLabel(v,e),(_=new t.OutputText(e.getCtx(),m)).setCSSStyle(g),_.setFontSize(c),(x=_.getDimensions()).w=Math.min(x.w,i.w),y=r?i.x+x.w:i.x+i.w;var b=x.w;r?(i.x+=x.w+d,i.w-=x.w+d):i.w-=x.w+d}if(n.min<0&&"on"!=n.plotArea.rendered&&("auto"!=n.plotArea.rendered||"onIndicator"!=n.thresholdDisplay)){var S=s.getFormattedMetricLabel(n.min,e);(p=new t.OutputText(e.getCtx(),S)).setCSSStyle(g),p.setFontSize(c);var A=p.getDimensions();(n.value<0||n.max<=0)&&(y=r?i.x+i.w:i.x+A.w,b=A.w),r||(i.x+=A.w+d),i.w-=A.w+d}l.setTextString(h),l.setX(y),t.TextUtils.centerTextVertically(l,i.y+i.h/2),l.alignRight();var w="firefox"===t.Agent.browser?i.h+2:i.h;t.TextUtils.fitText(l,b,w,a)}},_renderMetricLabelInsidePlotArea:(e,a,i,n,r,o,l,h)=>{var d=e.getOptions(),g=t.Agent.isRightToLeft(e.getCtx()),u="vertical"==d.orientation,c="on"==d.plotArea.rendered,p="center",_="middle",v=new t.Rectangle(Math.min(o.x1,o.x2),Math.min(o.y1,o.y2),Math.abs(o.x2-o.x1),Math.abs(o.y2-o.y1)),m=d.metricLabel.style.getStyle("color");"center"==r?(m=m||t.ColorUtils.getContrastingTextColor(n),u?(v.h-=v.w,v.y+=v.w/2):(v.w-=v.h,v.x+=v.h/2)):"insideIndicatorEdge"==r?(m=m||t.ColorUtils.getContrastingTextColor(n),u?(v.h-=v.w,v.y+=v.w/2,_=!c&&o.y1>o.y2?"bottom":"top"):(v.w-=v.h,v.x+=v.h/2,p=g?!c&&o.x1<o.x2?"right":"left":!c&&o.x1>o.x2?"left":"right")):"outsideIndicatorEdge"==r&&(u?(v.h=Math.abs(l.y1-o.y1)-v.w,v.y=l.y1+v.w/2,_="bottom",!c&&o.y1>o.y2&&(v.h=Math.abs(l.y2-o.y1)-v.w,v.y=o.y1+v.w/2,_="top")):g?!c&&o.x1<o.x2?(v.w=Math.abs(l.x2-o.x2)-v.h,v.x=o.x2+v.h/2,p="left"):(v.w=Math.abs(l.x1-o.x2)-v.h,v.x=l.x1+v.h/2,p="right"):!c&&o.x1>o.x2?(v.w=Math.abs(l.x1-o.x2)-v.h,v.x=l.x1+v.h/2,p="right"):(v.w=Math.abs(l.x2-o.x2)-v.h,v.x=o.x2+v.h/2,p="left")),s.renderMetricLabel(e,a,v,m,p,_)||h||("outsideIndicatorEdge"==r?A._renderMetricLabelInsidePlotArea(e,a,i,n,"insideIndicatorEdge",o,l,!0):"insideIndicatorEdge"!=r&&"center"!=r||A._renderMetricLabelInsidePlotArea(e,a,i,n,"outsideIndicatorEdge",o,l,!0))},_renderLabel:(e,a,i,n)=>{var r=t.Agent.isRightToLeft(e.getCtx()),o=e.getOptions(),l="vertical"==o.orientation,h=new t.Rectangle(i.x,i.y,l?i.w:i.w-i.h,l?i.h-i.w:i.h),d=o.label.text;if(!A._hasMetricLabelOutsidePlotArea(o)&&"on"==o.metricLabel.rendered){var g=s.getFormattedMetricLabel(o.value,e);d=t.ResourceUtils.format(o.translations.labelAndValue,[d,g])}var u=o.label.style,c=u.clone(),p=u.getStyle("font-size");if(!p){var _=new t.OutputText(e.getCtx(),d,0,0);_.setCSSStyle(u),_.setTextString(d),p=l?t.TextUtils.getOptimalFontSize(_.getCtx(),_.getTextString(),_.getCSSStyle(),new t.Rectangle(h.x,h.y,h.w,Number.MAX_VALUE)):t.TextUtils.getOptimalFontSize(_.getCtx(),_.getTextString(),_.getCSSStyle(),new t.Rectangle(h.x,h.y,Number.MAX_VALUE,h.h))}var v=new t.MultilineText(e.getCtx(),d);c.setFontSize("font-size",p,e.getCtx()),v.setCSSStyle(c),t.TextUtils.fitText(v,h.w,h.h,e),"center"==o.label.position||"auto"==o.label.position&&l?(t.TextUtils.centerTextVertically(v,i.y+i.h/2),v.setX(i.x+i.w/2),v.alignCenter()):(t.TextUtils.centerTextVertically(v,i.y+i.h/2),!l&&r?(v.setX(i.x+i.w-h.h/2),v.alignRight()):l||r?l&&(v.setY(i.y+i.h-v.getDimensions().h-h.w/2),v.setX(i.x+i.w/2),v.alignCenter()):(v.setX(i.x+h.h/2),v.alignLeft())),a.addChild(v)},_drawCircularArc:(e,a,i,s,n,r,o,h,d,g)=>{var u,c=e.getCtx();t.Agent.isRightToLeft(e.getCtx())&&(s=(s=Math.PI-s-n)>0?s:s+2*Math.PI),d?u=new t.Path(c,y.createCircularPathCmd(i,s,n,r,o)):(u=new b(c,i,s,n,r,o),e.__shapes.push(u)),u.setSolidFill(h);var p=l.getBorderColor(e);p&&!d?u.setSolidStroke(p):d&&g&&u.setSolidStroke(g);var _=e.getOptions();u.setClassName(d?_.plotArea.svgClassName:_.svgClassName),u.setStyle(d?_.plotArea.svgStyle:_.svgStyle),a.addChild(u)},_drawCircularReferenceLine:(e,a,i,s,n,r,o)=>{var l=e.getCtx(),h=Math.min(i.w,i.h),d=.275*h,g=.5*h;t.Agent.isRightToLeft(e.getCtx())&&(s=(s=Math.PI-s)>0?s:s+2*Math.PI);var u=y.calcPointOnArc(i,d,s),c=y.calcPointOnArc(i,g,s),p=new t.Line(l,u.x,u.y,c.x,c.y),_=new t.Stroke(n,1,r,!1,t.Stroke.getDefaultDashProps(o,r));p.setStroke(_),a.addChild(p)},getAngleQuadrant:(e,a)=>{var i=1;return a?e>=t.Math.HALF_PI&&e<Math.PI?i=2:e>=Math.PI&&e<1.5*Math.PI?i=3:e>=1.5*Math.PI&&e<t.Math.TWO_PI&&(i=4):e>t.Math.HALF_PI&&e<=Math.PI?i=2:e>Math.PI&&e<=1.5*Math.PI?i=3:(e>1.5*Math.PI&&e<t.Math.TWO_PI||0==e)&&(i=4),i},_hasMetricLabelOutsidePlotArea:e=>{var t=e.metricLabel.position;return"auto"==t||"outsidePlotArea"==t||("withLabel"==t||"withTitle"==t)&&!e.label.text},_adjustCenterAndBounds:(e,a,i,s,n,r,o)=>{var l,h,d=null,g=A.getAngleQuadrant(i,!0),u=A.getAngleQuadrant(n,!1),c=r.w,p=r.h,_=c/2,v=p/2;if(g==u&&s<=t.Math.HALF_PI)l=2*Math.min(r.w,r.h),r.w=r.w+l/2,r.h=r.h+l/2,h=l*a,!o&&1==g||o&&2==g?(r.x-=l/2,r.y-=l/2,_=c/2-l/4+1,v=p/2-l/4+1,d=new t.Rectangle(r.x+r.w/2-1,r.y+r.h/2-1,h*(3/7)-2,h*(2.5/7)-2)):!o&&2==g||o&&1==g?(r.y-=l/2,_=c/2+l/4-1,v=p/2-l/4+1,d=new t.Rectangle(r.x+r.w/2-h*(3/7)+1,r.y+r.h/2-1,h*(3/7)-2,h*(2.5/7)-2)):!o&&3==g||o&&4==g?(_=c/2+l/4-1,v=p/2+l/4-1,d=new t.Rectangle(r.x+r.w/2-h*(3/7)+1,r.y+r.h/2-h*(2.5/7)+1,h*(3/7)-2,h*(2.5/7)-2)):(!o&&4==g||o&&3==g)&&(r.x-=l/2,_=c/2-l/4+1,v=p/2+l/4-1,d=new t.Rectangle(r.x+r.w/2-1,r.y+r.h/2-h*(2.5/7)+1,h*(3/7)-2,h*(2.5/7)-2));else if(g%4+1==u&&s<=Math.PI)1==g||3==g?(h=(l=Math.min(r.w,2*r.h))*a,r.w>r.h&&(d=new t.Rectangle(r.x+r.w/2-h*(3/7),r.y+r.h-(r.h-l/2)/2-h*(2.75/7),h*(6/7),h*(2.5/7)),1==g?(d.y=r.y+(r.h-l/2)/2+h*(.5/7),r.y-=l/2-(r.h-l/2)/2,v=p/2-l/4+1):(r.y+=(r.h-l/2)/2,v=p/2+l/4-1),r.h=l)):(h=(l=Math.min(2*r.w,r.h))*a,r.w<r.h&&(d=new t.Rectangle(r.x+r.w-(r.w-l/2)/2-h*(3.25/7),r.y+r.h/2-h*(2.5/7),h*(3/7),h*(5/7)),!o&&4==g||o&&2==g?(d.x=r.x+(r.w-l/2)/2+h*(.25/7),r.x-=l/2-(r.w-l/2)/2,_=c/2-l/4+1):(r.x+=(r.w-l/2)/2,_=c/2+l/4-1),r.w=l));else if(u%4+1==g&&s>Math.PI){var m;1==g&&r.h>r.w?(m=(h=(l=Math.min(r.w/(Math.cos(i)+1)*2,r.w/(Math.sin(n-1.5*Math.PI)+1)*2,r.h))*a)*(3/7)*(2*r.w/l-1),o?(d=new t.Rectangle(r.x+r.w-l/2-m,r.y+r.h/2-h*(2.5/7),h*(3/7)+m,h*(5/7)),r.x-=l-r.w,_=-l/2+c):(d=new t.Rectangle(r.x+l/2-h*(3/7),r.y+r.h/2-h*(2.5/7),h*(3/7)*(2*r.w/l-1+1),h*(5/7)),_=l/2),r.w=l):2==g&&r.h<r.w?(h=(l=Math.min(r.h/(Math.cos(i-t.Math.HALF_PI)+1)*2,r.h/(Math.sin(n)+1)*2,r.w))*a,d=new t.Rectangle(r.x+r.w/2-h*(3/7),r.y+l/2-h*(2.5/7),h*(6/7),h*(2.5/7)*(2*r.h/l-1+1)),r.h=l,v=l/2):3==g&&r.h>r.w?(m=(h=(l=Math.min(r.w/(Math.cos(i-Math.PI)+1)*2,r.w/(Math.sin(n-t.Math.HALF_PI)+1)*2,r.h))*a)*(3/7)*(2*r.w/l-1),o?(d=new t.Rectangle(r.x+l/2-h*(3/7),r.y+r.h/2-h*(2.5/7),h*(3/7)*(2*r.w/l-1+1),h*(5/7)),_=l/2):(d=new t.Rectangle(r.x+r.w-l/2-m,r.y+r.h/2-h*(2.5/7),h*(3/7)+m,h*(5/7)),r.x-=l-r.w,_=-l/2+c),r.w=l):4==g&&r.h<r.w&&(m=(h=(l=Math.min(r.h/(Math.cos(i-1.5*Math.PI)+1)*2,r.h/(Math.sin(t.Math.TWO_PI-n)+1)*2,r.w))*a)*(2.5/7)*(2*r.h/l-1),d=new t.Rectangle(r.x+r.w/2-h*(3/7),r.y+r.h-l/2-m,h*(6/7),h*(2.5/7)+m),r.y-=l-r.h,r.h=l,v=-l/2+p)}return e.cx=_,e.cy=v,e.maxInnerDiameter=h,d},_renderCenterContent:(e,a,i,n,r)=>{var o=new t.Rectangle(i.x+.5*(i.w-r),i.y+.5*(i.h-r),r,r);o=o.getIntersection(n);var l=new t.Rectangle(i.x+.5*(i.w-r/Math.sqrt(2)),i.y+.5*(i.h-r/Math.sqrt(2)),r/Math.sqrt(2),r/Math.sqrt(2));l=l.getIntersection(n);var h=a.center.renderer;if(h){var d={outerBounds:{x:o.x,y:o.y,width:o.w,height:o.h},innerBounds:{x:l.x,y:l.y,width:l.w,height:l.h},metricLabel:s.getFormattedMetricLabel(a.value,e),component:a._widgetConstructor},g=e.getCtx();d=g.fixRendererContext(d);var u=g.getContainer(),c=e.centerDiv;c&&u.removeChild(c);var p=h(d);if(!p)return;var _=g.createOverlayDiv();Array.isArray(p)?p.forEach(e=>{_.appendChild(e)}):_.appendChild(p),e.centerDiv=_,u.appendChild(_);var v=g.getOverlayAttachedCallback();v&&v(_)}}};e.LedGauge=c,e.RatingGauge=class extends h{constructor(e,t,a){super(e,t,a),this.type="rating",this.Defaults=new p(e)}SetOptions(e){(e=t.JsonUtils.clone(e)).changedState&&(e.changedState.className&&(e.changedState.svgClassName=e.changedState.className),e.changedState.style&&(e.changedState.svgStyle=e.changedState.style)),e.hoverState&&(e.hoverState.className&&(e.hoverState.svgClassName=e.hoverState.className),e.hoverState.style&&(e.hoverState.svgStyle=e.hoverState.style)),e.selectedState&&(e.selectedState.className&&(e.selectedState.svgClassName=e.selectedState.className),e.selectedState.style&&(e.selectedState.svgStyle=e.selectedState.style)),e.unselectedState&&(e.unselectedState.className&&(e.unselectedState.svgClassName=e.unselectedState.className),e.unselectedState.style&&(e.unselectedState.svgStyle=e.unselectedState.style)),this.getCtx().isCustomElement()&&(e.readOnly=e.readonly);var a=this.getCtx().getSvgDocument();"fit"!==e.size?(this.getCtx().removeSizingSvg(),a.style.height=e._height+"px",a.style.width=e._width+"px"):(this.getCtx().addSizingSvg(),a.style.height="",a.style.width=""),super.SetOptions(this.Defaults.calcOptions(e))}Render(e,a,i){var s=this.Options.__layout.outerGap,n=this.Options.max,r=this.Options.size,o="vertical"==this.Options.orientation,l=this.Options.selectedState.source,h="none"!=this.Options.preserveAspectRatio;if(l&&h&&"fit"===r){return t.ImageLoader.loadImage(this.Options.selectedState.source,r=>{if("ie"!==t.Agent.browser&&"edge"!==t.Agent.browser||11!=t.Agent.version||!r||0!=r.width||0!=r.height||(r.width=1,r.height=1),r&&r.width&&r.height){var l=r.width/r.height;this.__shapeWidth=o?Math.min(a-2*s,(i-2*s)*l/n):Math.min((i-2*s)*l,(a-2*s)/n),this.__shapeHeight=this.__shapeWidth/l,this.__bounds=o?new t.Rectangle(s,(i-this.__shapeHeight*n)/2,a-2*s,this.__shapeHeight*n):new t.Rectangle((a-this.__shapeWidth*n)/2,s,this.__shapeWidth*n,i-2*s),m.render(this,e,a,i)}this.PostRender(this.Options,e)}),!1}return s="fit"===r?s:0,h?(this.__shapeWidth=o?Math.min(a-2*s,(i-2*s)/n):Math.min(i-2*s,(a-2*s)/n),this.__shapeHeight=this.__shapeWidth):(this.__shapeWidth=o?a-2*s:(a-2*s)/n,this.__shapeHeight=o?(i-2*s)/n:i-2*s),this.__bounds=o?new t.Rectangle(s,(i-this.__shapeHeight*n)/2,a-2*s,this.__shapeHeight*n):new t.Rectangle((a-this.__shapeWidth*n)/2,s,this.__shapeWidth*n,i-2*s),m.render(this,e,a,i),!0}__getLogicalObject(){var e=this.Options.tooltip,a=e?e.renderer:null,i=l.getColor(this);if(a){var n={component:this.Options._widgetConstructor,label:s.getFormattedMetricLabel(this.Options.value,this),color:i};return new t.CustomDatatipPeer(this.getCtx().getTooltipManager(),a,i,n)}return new v(this)}GetValueAt(e,a){var n,r="vertical"==this.Options.orientation?this.__shapeHeight:this.__shapeWidth;return i.hasData(this)?("vertical"==this.Options.orientation?(a=Math.max(Math.min(a,this.__bounds.y+this.__bounds.h),this.__bounds.y),n=Math.max((this.__bounds.y+this.__bounds.h-a)/r,this.Options.min)):(e=Math.max(Math.min(e,this.__bounds.x+this.__bounds.w),this.__bounds.x),n=0,n=t.Agent.isRightToLeft(this.getCtx())?Math.max((this.__bounds.x+this.__bounds.w-e)/r,this.Options.min):Math.max((e-this.__bounds.x)/r,this.Options.min)),s.adjustForStep(this.Options,n)):null}__processHoverEnd(e,a){this.__updateClipRects(this.Options.value,"render"),this.dispatchEvent(t.EventFactory.newValueChangeEvent(this.Options.value,this.Options.value,!1))}__processValueChangeStart(e,t){this.__processValueChangeMove(e,t)}__processValueChangeMove(e,a){var i=this.GetValueAt(e,a);this.__updateClipRects(i,"hover"),this.dispatchEvent(t.EventFactory.newValueChangeEvent(this.Options.value,i,!1))}__processValueChangeEnd(e,a){var i=this.Options.value;this.Options.value=this.GetValueAt(e,a),this.Options.changed=!0,this.render(),this.dispatchEvent(t.EventFactory.newValueChangeEvent(i,this.Options.value,!1)),this.dispatchEvent(t.EventFactory.newValueChangeEvent(i,this.Options.value,!0))}__updateClipRects(e,a,s){if(i.hasData(this)){s||(s=this._container);var n,r,o,l,h,d,g=t.Agent.isRightToLeft(this.getCtx()),u="vertical"==this.Options.orientation,c=u?this.__shapeHeight:this.__shapeWidth,p=0,_=(e=Math.max(Math.min(e,this.Options.max),0))*c,v=e*c;"render"===a&&(p=e*c,_=0),u?(n=s.getChildAt(0),(r=new t.ClipPath).addRect(this.__bounds.x,this.__bounds.y,this.__bounds.w,this.__bounds.h-v),n.setClipPath(r),o=s.getChildAt(1),(l=new t.ClipPath).addRect(this.__bounds.x,this.__bounds.y+this.__bounds.h-p,this.__bounds.w,p),o.setClipPath(l),(h=s.getChildAt(2))&&((d=new t.ClipPath).addRect(this.__bounds.x,this.__bounds.y+this.__bounds.h-_,this.__bounds.w,_),h.setClipPath(d))):g?(n=s.getChildAt(0),(r=new t.ClipPath).addRect(this.__bounds.x,this.__bounds.y,this.__bounds.w-v,this.__bounds.h),n.setClipPath(r),o=s.getChildAt(1),(l=new t.ClipPath).addRect(this.__bounds.x+this.__bounds.w-v,this.__bounds.y,p,this.__bounds.h),o.setClipPath(l),(h=s.getChildAt(2))&&((d=new t.ClipPath).addRect(this.__bounds.x+this.__bounds.w-v,this.__bounds.y,_,this.__bounds.h),h.setClipPath(d))):(n=s.getChildAt(0),(r=new t.ClipPath).addRect(this.__bounds.x+v,this.__bounds.y,this.__bounds.w-v,this.__bounds.h),n.setClipPath(r),o=s.getChildAt(1),(l=new t.ClipPath).addRect(this.__bounds.x,this.__bounds.y,p,this.__bounds.h),o.setClipPath(l),(h=s.getChildAt(2))&&((d=new t.ClipPath).addRect(this.__bounds.x,this.__bounds.y,_,this.__bounds.h),h.setClipPath(d))),this.UpdateAriaLiveValue(s,e)}}__getRatingGaugeItem(e){return this._container.getChildAt(0).getChildAt(e)}CreateEventManager(){return new _(this)}IsInteractive(){return!this.Options.disabled&&super.IsInteractive(this)}},e.StatusMeterGauge=class extends h{constructor(e,t,a){super(e,t,a),this.type="statusMeter",this.Defaults=new x(e),this.__axisInfo=null}SetOptions(e){(e=t.JsonUtils.clone(e)).title&&(e.label=e.title),e.plotArea&&(e.plotArea.className&&(e.plotArea.svgClassName=e.plotArea.className),e.plotArea.style&&(e.plotArea.svgStyle=e.plotArea.style)),this.getCtx().isCustomElement()&&(e.readOnly=e.readonly),super.SetOptions(this.Defaults.calcOptions(e))}Render(e,t,a){A.render(this,e,t,a)}CreateAnimOnDisplay(e,a,i){for(var s=[],n=0;n<e.length;n++){var r=e[n],o=r.getAnimParams();"horizontal"==this.Options.orientation?r.setAnimParams([o[0],o[0],o[2],o[3]]):"vertical"==this.Options.orientation?r.setAnimParams([o[0],o[1],o[3],o[3]]):"circular"==this.Options.orientation&&r.setAnimParams([o[0],o[1],0,o[3],o[4]]);var l=new t.CustomAnimation(this.getCtx(),r,i);l.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,r,r.getAnimParams,r.setAnimParams,o),l.getAnimator().setEasing(function(e){return t.Easing.backOut(e,.7)}),s.push(l)}return new t.ParallelPlayable(this.getCtx(),s)}GetValueAt(e,a){var i=this.Options,s=t.Agent.isRightToLeft(this.getCtx());if("horizontal"==i.orientation)return this.__axisInfo.getBoundedValAt(e);if("vertical"==i.orientation)return this.__axisInfo.getBoundedValAt(a);if("circular"==i.orientation){var n=i.angleExtent,r=Math.atan2(a-this.cy,e-this.cx),o=s?180-(t.Math.radsToDegrees(r)-i.startAngle):t.Math.radsToDegrees(r)-(360-i.startAngle),l=(o=(o+720)%360)/n,h=i.min,d=i.max,g=l*(d-h)+h;return o>n&&(g=(o-n)/(360-n)>.5?0:d),g}return null}},Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=ojgauge-toolkit.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojgauge',["ojs/ojcomponentcore","ojs/ojcore-base","ojs/ojdvt-base","jquery","ojs/ojlogger","ojs/ojconverterutils-i18n","ojs/ojconverter-number","ojs/ojlabelledbyutils","ojs/ojgauge-toolkit"],function(e,t,r,a,s,n,o,i,l){"use strict";t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t,r=r&&Object.prototype.hasOwnProperty.call(r,"default")?r.default:r,a=a&&Object.prototype.hasOwnProperty.call(a,"default")?a.default:a,i=i&&Object.prototype.hasOwnProperty.call(i,"default")?i.default:i;var u={properties:{borderColor:{type:"string"},color:{type:"string"},label:{type:"object",properties:{style:{type:"object",value:{}},text:{type:"string",value:""}}},markerSize:{type:"string",enumValues:["fit","lg","md","sm"],value:"fit"},max:{type:"number",value:100},metricLabel:{type:"object",properties:{converter:{type:"object"},rendered:{type:"string",enumValues:["off","on"],value:"off"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},style:{type:"object",value:{}},text:{type:"string",value:""},textType:{type:"string",enumValues:["number","percent"],value:"number"}}},min:{type:"number",value:0},rotation:{type:"number",enumValues:["0","180","270","90"],value:0},size:{type:"number",value:1},svgClassName:{type:"string",value:""},svgStyle:{type:"object",value:{}},thresholds:{type:"Array<Object>",value:[]},tooltip:{type:"object",properties:{renderer:{type:"function"}}},trackResize:{type:"string",enumValues:["off","on"],value:"on"},translations:{type:"object",value:{},properties:{componentName:{type:"string"},labelAndValue:{type:"string"},labelClearSelection:{type:"string"},labelCountWithTotal:{type:"string"},labelDataVisualization:{type:"string"},labelInvalidData:{type:"string"},labelNoData:{type:"string"},stateCollapsed:{type:"string"},stateDrillable:{type:"string"},stateExpanded:{type:"string"},stateHidden:{type:"string"},stateIsolated:{type:"string"},stateMaximized:{type:"string"},stateMinimized:{type:"string"},stateSelected:{type:"string"},stateUnselected:{type:"string"},stateVisible:{type:"string"}}},type:{type:"string",value:"circle"},value:{type:"number",writeback:!0},visualEffects:{type:"string",enumValues:["auto","none"],value:"auto"}},methods:{getMetricLabel:{},getProperty:{},refresh:{},setProperties:{},setProperty:{},getNodeBySubId:{},getSubIdByNode:{}},extension:{}};!function(){u.extension._WIDGET_NAME="ojLedGauge";t.CustomElementBridge.register("oj-led-gauge",{metadata:u,parseFunction:r.shapeParseFunction({type:!0},{arrow:!0,square:!0,rectangle:!0,circle:!0,diamond:!0,triangle:!0,human:!0,star:!0})})}();var p={properties:{changed:{type:"boolean",writeback:!0,value:!1},changedState:{type:"object",properties:{borderColor:{type:"string",value:""},color:{type:"string"},shape:{type:"string",value:"star"},source:{type:"string",value:""},svgClassName:{type:"string",value:""},svgStyle:{type:"object",value:{}}}},describedBy:{type:"string"},disabled:{type:"boolean",value:!1},hoverState:{type:"object",properties:{borderColor:{type:"string",value:""},color:{type:"string"},shape:{type:"string",value:"star"},source:{type:"string",value:""},svgClassName:{type:"string",value:""},svgStyle:{type:"object",value:{}}}},labelledBy:{type:"string"},max:{type:"number",value:5},min:{type:"number",value:0},orientation:{type:"string",enumValues:["horizontal","vertical"],value:"horizontal"},preserveAspectRatio:{type:"string",enumValues:["meet","none"],value:"meet"},readonly:{type:"boolean",value:!1},selectedState:{type:"object",properties:{borderColor:{type:"string",value:""},color:{type:"string"},shape:{type:"string",value:"star"},source:{type:"string",value:""},svgClassName:{type:"string",value:""},svgStyle:{type:"object",value:{}}}},size:{type:"string",enumValues:["fit","large","lg","md","medium","sm","small"],value:"fit"},step:{type:"number",value:1},thresholds:{type:"Array<Object>",value:[]},tooltip:{type:"object",properties:{renderer:{type:"function"}}},trackResize:{type:"string",enumValues:["off","on"],value:"on"},transientValue:{type:"number",writeback:!0,readOnly:!0},translations:{type:"object",value:{},properties:{componentName:{type:"string"},labelAndValue:{type:"string"},labelClearSelection:{type:"string"},labelCountWithTotal:{type:"string"},labelDataVisualization:{type:"string"},labelInvalidData:{type:"string"},labelNoData:{type:"string"},stateCollapsed:{type:"string"},stateDrillable:{type:"string"},stateExpanded:{type:"string"},stateHidden:{type:"string"},stateIsolated:{type:"string"},stateMaximized:{type:"string"},stateMinimized:{type:"string"},stateSelected:{type:"string"},stateUnselected:{type:"string"},stateVisible:{type:"string"}}},unselectedState:{type:"object",properties:{borderColor:{type:"string",value:""},color:{type:"string"},shape:{type:"string",value:"star"},source:{type:"string",value:""},svgClassName:{type:"string",value:""},svgStyle:{type:"object",value:{}}}},value:{type:"number",writeback:!0},visualEffects:{type:"string",enumValues:["auto","none"],value:"auto"}},methods:{getProperty:{},refresh:{},setProperties:{},setProperty:{},getNodeBySubId:{},getSubIdByNode:{}},extension:{}};!function(){p.extension._WIDGET_NAME="ojRatingGauge",p.extension._ALIASED_PROPS={transientValue:"rawValue"};var e=/\d/,r={circle:!0,square:!0,diamond:!0,triangle:!0,human:!0,star:!0},a={circle:!0,square:!0,diamond:!0,triangle:!0,human:!0,star:!0,dot:!0,none:!0},s={"changed-state.shape":!0,"hover-state.shape":!0,"selected-state.shape":!0,"unselected-state.shape":!0};t.CustomElementBridge.register("oj-rating-gauge",{metadata:p,parseFunction:function(t,n,o,i){if(s[n]||"unselected-state.shape"===n){if(e.test(t))return t;if(s[n]&&!r[n])throw new Error("Found: "+t+". Expected: "+r.toString());if("unselected-state.shape"!==n||a[n])return t;throw new Error("Found: "+t+". Expected: "+a.toString())}return i(t)}})}();var g={properties:{angleExtent:{type:"number",value:360},animationDuration:{type:"number"},animationOnDataChange:{type:"string",enumValues:["auto","none"],value:"none"},animationOnDisplay:{type:"string",enumValues:["auto","none"],value:"none"},borderColor:{type:"string"},borderRadius:{type:"string",value:"auto"},center:{type:"object",properties:{renderer:{type:"function"}}},color:{type:"string"},describedBy:{type:"string"},indicatorSize:{type:"number",value:1},innerRadius:{type:"number",value:.7},label:{type:"object",properties:{position:{type:"string",enumValues:["auto","center","start"],value:"auto"},style:{type:"object",value:{}},text:{type:"string",value:""}}},labelledBy:{type:"string"},max:{type:"number",value:100},metricLabel:{type:"object",properties:{converter:{type:"object"},position:{type:"string",enumValues:["auto","center","insideIndicatorEdge","outsideIndicatorEdge","outsidePlotArea","withLabel"],value:"auto"},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},style:{type:"object",value:{}},text:{type:"string",value:""},textType:{type:"string",enumValues:["number","percent"],value:"number"}}},min:{type:"number",value:0},orientation:{type:"string",enumValues:["circular","horizontal","vertical"],value:"horizontal"},plotArea:{type:"object",properties:{borderColor:{type:"string"},borderRadius:{type:"string",value:"auto"},color:{type:"string"},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"},svgClassName:{type:"string",value:""},svgStyle:{type:"object",value:{}}}},readonly:{type:"boolean",value:!1},referenceLines:{type:"Array<Object>",value:[]},size:{type:"string",enumValues:["fit","lg","md","sm"],value:"fit"},startAngle:{type:"number",value:90},step:{type:"number"},svgClassName:{type:"string",value:""},svgStyle:{type:"object",value:{}},thresholdDisplay:{type:"string",enumValues:["all","currentOnly","onIndicator"],value:"onIndicator"},thresholds:{type:"Array<Object>",value:[]},tooltip:{type:"object",properties:{renderer:{type:"function"}}},trackResize:{type:"string",enumValues:["off","on"],value:"on"},transientValue:{type:"number",writeback:!0,readOnly:!0},translations:{type:"object",value:{},properties:{componentName:{type:"string"},labelAndValue:{type:"string"},labelClearSelection:{type:"string"},labelCountWithTotal:{type:"string"},labelDataVisualization:{type:"string"},labelInvalidData:{type:"string"},labelNoData:{type:"string"},stateCollapsed:{type:"string"},stateDrillable:{type:"string"},stateExpanded:{type:"string"},stateHidden:{type:"string"},stateIsolated:{type:"string"},stateMaximized:{type:"string"},stateMinimized:{type:"string"},stateSelected:{type:"string"},stateUnselected:{type:"string"},stateVisible:{type:"string"}}},value:{type:"number",writeback:!0},visualEffects:{type:"string",enumValues:["auto","none"],value:"auto"}},methods:{getMetricLabel:{},getProperty:{},refresh:{},setProperties:{},setProperty:{},getNodeBySubId:{},getSubIdByNode:{}},extension:{}};g.extension._WIDGET_NAME="ojStatusMeterGauge",g.extension._ALIASED_PROPS={transientValue:"rawValue"},t.CustomElementBridge.register("oj-status-meter-gauge",{metadata:g}),t.__registerWidget("oj.dvtBaseGauge",a.oj.dvtBaseComponent,{_labelledByUpdatedForSet:i._labelledByUpdatedForSet,_describedByUpdated:i._describedByUpdated,_ComponentCreate:function(){this._SetSizeClass(),this._super(),this._SetLocaleHelpers(o,n)},_OptionChangeHandler:function(e){this._SetSizeClass(),this._super(e)},_GetSizeClass:function(){},_SetSizeClass:function(){var e=this._GetSizeClass();e!==this._sizeClass&&(this.element.removeClass(this._sizeClass),this._sizeClass=e,this.element.addClass(e))},_ProcessStyles:function(e){var t=e;this._super(t),t._thresholdColors=[t._threshold1,t._threshold2,t._threshold3],t._threshold1=null,t._threshold2=null,t._threshold3=null},_AfterCreate:function(){this._super();if(this.option("rawValue",this.options.value,{_context:{writeback:!0,internalSet:!0,readOnly:!0}}),this._SupportsOjLabel()){var e=this.options.labelledBy;this._labelledByUpdatedForSet(this.element[0].id,null,e,this.element)}},_GetContentElement:function(){return this.element},_GetChildStyleClasses:function(){var e=this._super();return e["oj-gauge-metric-label"]={path:"metricLabel/style",property:"TEXT"},e["oj-gauge-label"]={path:"label/style",property:"TEXT"},e["oj-gauge-threshold1"]={path:"_threshold1",property:"color"},e["oj-gauge-threshold2"]={path:"_threshold2",property:"color"},e["oj-gauge-threshold3"]={path:"_threshold3",property:"color"},e},_GetEventTypes:function(){return["input","optionChange"]},_HandleEvent:function(e){if("valueChange"===e.type){var t=e.newValue;e.complete?this._UserOptionChange("value",t):(this._trigger("input",null,{value:t}),this._UserOptionChange("rawValue",t))}else this._super(e)},_SupportsOjLabel:function(){return!1},_setOption:function(e,t,r){var a=this.options[e];if("rawValue"!==e){if("value"===e){this.option("rawValue",t,{_context:{writeback:!0,internalSet:!0,readOnly:!0}})}var n;if(this._SupportsOjLabel())"labelledBy"===e&&(n=this.element,this._labelledByUpdatedForSet(n[0].id,a,t,n)),"describedBy"===e&&this._describedByUpdated(a,t);this._super(e,t,r)}else s.error("'rawValue' is a read-only option and cannot be set")},_ConvertLocatorToSubId:function(e){var t=e.subId;return"oj-ledgauge-tooltip"!==t&&"oj-ratinggauge-tooltip"!==t&&"oj-statusmetergauge-tooltip"!==t||(t="tooltip"),"oj-ratinggauge-item"===t&&null!=e.index&&(t="item["+e.index+"]"),t}},!0),t.__registerWidget("oj.ojLedGauge",a.oj.dvtBaseGauge,{widgetEventPrefix:"oj",options:{borderColor:"",color:"#393737",label:{style:{},text:""},metricLabel:{converter:null,rendered:"off",scaling:"auto",style:{},text:"",textType:"number"},markerSize:"fit",max:100,min:0,rotation:0,size:1,svgClassName:"",svgStyle:{},thresholds:[],tooltip:{renderer:null},type:"circle",value:null,visualEffects:"auto"},_CreateDvtComponent:function(e,t,r){return this._focusable({element:this.element,applyHighlight:!0}),new l.LedGauge(e,t,r)},_ConvertSubIdToLocator:function(e){var t={};return"tooltip"===e&&(t.subId="oj-ledgauge-tooltip"),t},_GetComponentStyleClasses:function(){var e=this._super();return e.push("oj-ledgauge"),e.push(this._sizeClass),e},_GetSizeClass:function(){return"oj-ledgauge-"+this.options.markerSize},_Render:function(){this.element.attr("title")?(this.options.shortDesc=this.element.attr("title"),this.element.data(this.element,"title",this.element.attr("title")),this.element.removeAttr("title")):this.element.data("title")&&(this.options.shortDesc=this.element.data("title")),this._super()},getMetricLabel:function(){return this._component.getAutomation().getMetricLabel()}});t.__registerWidget("oj.ojRatingGauge",a.oj.dvtBaseGauge,{widgetEventPrefix:"oj",options:{changed:!1,changedState:{borderColor:"",color:"",shape:"star",source:"",svgClassName:"",svgStyle:{}},hoverState:{borderColor:"",color:"",shape:"star",source:"",svgClassName:"",svgStyle:{}},labelledBy:null,describedBy:null,max:5,min:0,orientation:"horizontal",preserveAspectRatio:"meet",rawValue:null,readonly:!1,disabled:!1,size:"fit",selectedState:{borderColor:"",color:"",shape:"star",source:"",svgClassName:"",svgStyle:{}},step:1,thresholds:[],tooltip:{renderer:null},unselectedState:{borderColor:"",color:"",shape:"star",source:"",svgClassName:"",svgStyle:{}},value:null,visualEffects:"auto"},_CreateDvtComponent:function(e,t,r){return this._focusable({element:this.element,applyHighlight:!0}),new l.RatingGauge(e,t,r)},_ConvertSubIdToLocator:function(e){var t={};return"tooltip"===e?t.subId="oj-ratinggauge-tooltip":0===e.indexOf("item")&&(t.subId="oj-ratinggauge-item",t.index=this._GetFirstIndex(e)),t},_GetComponentStyleClasses:function(){var e=this._super();return e.push("oj-ratinggauge"),"fit"===this.options.size&&e.push("oj-rating-gauge-fit"),e},_GetChildStyleClasses:function(){var e=this._super();return e["oj-rating-gauge-hover"]=[{path:"hoverState/color",property:"fill"},{path:"hoverState/borderColor",property:"stroke"}],e["oj-rating-gauge-selected "+(this.options.readonly?"oj-rating-gauge-readonly":"")]=[{path:"selectedState/color",property:"fill"},{path:"selectedState/borderColor",property:"stroke"}],e["oj-rating-gauge-unselected "+(this.options.readonly?"oj-rating-gauge-readonly":"")]=[{path:"unselectedState/color",property:"fill"},{path:"unselectedState/borderColor",property:"stroke"}],e["oj-rating-gauge-changed"]=[{path:"changedState/color",property:"fill"},{path:"changedState/borderColor",property:"stroke"}],e["oj-rating-gauge-shape-sm"]={path:"_shapeSize/sm",property:"width"},e["oj-rating-gauge-shape-md"]={path:"_shapeSize/md",property:"width"},e["oj-rating-gauge-shape-lg"]={path:"_shapeSize/lg",property:"width"},e},_Render:function(){this.element.attr("title")?(this.options.shortDesc=this.element.attr("title"),this.element.data(this.element,"title",this.element.attr("title")),this.element.removeAttr("title")):this.element.data("title")&&(this.options.shortDesc=this.element.data("title")),this._super()},_SupportsOjLabel:function(){return this._IsCustomElement()},_ProcessStyles:function(e){var t=e;this._super(t);var r={small:"sm",medium:"md",large:"lg"}[t.size]||t.size;if("fit"!==r){var a=parseInt(t._shapeSize[r],10),s="horizontal"===t.orientation;t._width=s?a*t.max:a,t._height=s?a:a*t.max,this._width=t._width,this._height=t._height}},_ProcessOptions:function(){this._super(),"fit"===this.options.size?this.element.addClass("oj-rating-gauge-fit"):this.element.removeClass("oj-rating-gauge-fit")},_UserOptionChange:function(e,t){this._superApply(arguments),"value"===e&&this._UserOptionChange("changed",!0)}}),t.__registerWidget("oj.ojStatusMeterGauge",a.oj.dvtBaseGauge,{widgetEventPrefix:"oj",options:{angleExtent:360,animationOnDataChange:"none",animationOnDisplay:"none",animationDuration:void 0,borderColor:"",borderRadius:"auto",center:{renderer:null},color:"#393737",indicatorSize:1,innerRadius:.7,label:{position:"auto",style:{},text:""},labelledBy:null,describedBy:null,max:100,metricLabel:{converter:null,position:"auto",rendered:"auto",scaling:"auto",style:{},text:"",textType:"number"},min:0,orientation:"horizontal",size:"fit",plotArea:{borderColor:void 0,borderRadius:"auto",color:void 0,rendered:"auto",svgClassName:"",svgStyle:{}},rawValue:null,readonly:!1,referenceLines:[],startAngle:90,step:null,svgClassName:"",svgStyle:{},tooltip:{renderer:null},thresholdDisplay:"onIndicator",thresholds:[],value:null,visualEffects:"auto"},_CreateDvtComponent:function(e,t,r){return this._focusable({element:this.element,applyHighlight:!0}),new l.StatusMeterGauge(e,t,r)},_ConvertSubIdToLocator:function(e){var t={};return"tooltip"===e&&(t.subId="oj-statusmetergauge-tooltip"),t},_GetComponentStyleClasses:function(){var e=this._super();return e.push("oj-statusmetergauge"),e.push(this._sizeClass),e},_GetSizeClass:function(){return`oj-statusmetergauge-${this.options.orientation}-${this.options.size}`},_GetComponentRendererOptions:function(){return[{path:"tooltip/renderer",slot:"tooltipTemplate"},{path:"center/renderer",slot:"centerTemplate"}]},_SupportsOjLabel:function(){return this._IsCustomElement()},_ProcessOptions:function(){this._super();var e=this.options.center;e&&e._renderer&&(e.renderer=this._GetTemplateRenderer(e._renderer,"center"))},_GetChildStyleClasses:function(){var e=this._super();return e["oj-dvtbase oj-statusmetergauge"]={path:"animationDuration",property:"ANIM_DUR"},e["oj-statusmeter-gauge-plotarea"]=[{path:"plotArea/borderColor",property:"border-color"},{path:"plotArea/color",property:"color"}],e},_Render:function(){this.element.attr("title")?(this.options.shortDesc=this.element.attr("title"),this.element.data(this.element,"title",this.element.attr("title")),this.element.removeAttr("title")):this.element.data("title")&&(this.options.shortDesc=this.element.data("title")),this._super()},getMetricLabel:function(){return this._component.getAutomation().getMetricLabel()}})});
//# sourceMappingURL=ojgauge.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojtime-base',["ojs/ojcore-base","jquery","ojs/ojdvt-base","ojs/ojcomponentcore","ojs/ojlocaledata","ojs/ojlogger","ojs/ojconverter-datetime","ojs/ojconverterutils-i18n","ojs/ojconverter-number"],function(e,t,r,n,o,i,a,s,l){"use strict";e=e&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e,t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t,e.__registerWidget("oj.dvtTimeComponent",t.oj.dvtBaseComponent,{_ComponentCreate:function(){this._super(),this._SetLocaleHelpers(l,s)},_GetEventTypes:function(){return["optionChange","viewportChange"]},_HandleEvent:function(e){if("viewportChange"===e.type){var t=new Date(e.viewportStart).toISOString(),r=new Date(e.viewportEnd).toISOString(),n=e.minorAxisScale,o={viewportStart:t,viewportEnd:r,minorAxisScale:n};this._UserOptionChange("viewportStart",t),this._UserOptionChange("viewportEnd",r),this._UserOptionChange("minorAxis.scale",n),this._trigger("viewportChange",null,o)}else this._super(e)},_LoadResources:function(){null==this.options._resources&&(this.options._resources={});var e=new a.IntlDateTimeConverter({hour:"numeric",minute:"2-digit",second:"2-digit"}),t=new a.IntlDateTimeConverter({hour:"numeric",minute:"2-digit"}),r=new a.IntlDateTimeConverter({hour:"numeric"}),n=new a.IntlDateTimeConverter({month:"numeric",day:"2-digit"}),i=new a.IntlDateTimeConverter({month:"long"}),s={seconds:e,minutes:t,hours:r,days:n,weeks:n,months:i,quarters:i,years:new a.IntlDateTimeConverter({year:"numeric"})},l=this.options._resources;l.converter=s,l.defaultDateTimeConverter=new a.IntlDateTimeConverter({formatType:"datetime",dateFormat:"medium",timeFormat:"medium"}),l.defaultDateConverter=new a.IntlDateTimeConverter({formatType:"date",dateFormat:"medium"}),l.firstDayOfWeek=o.getFirstDayOfWeek()},_ProcessTemplates:function(e,t,r,n,o,a,s){var l=a?this._TemplateHandler.getComponentResults(e):null;if(!l){var m=this._GetDataProviderSeriesConfig(),u=this.element[0],d=this._super(e,t,r,n,o,a,s);if("rowData"===e)l=d;else if(m&&e===m.dataProperty&&!n){var p,v,c,h=[],f={},C=d.values[0],g=0,_=m.defaultSingleSeries,w=m.idAttribute,j=m.itemsKey;for(c=0;c<C.length;c++){var T,D=C[c],y={data:D._itemData,key:D.id,index:c};f[T=null!=D[w]?D[w]:_?"":D.id]?(f[T][j].push(y),h[f[T].index][j].push(D)):((v={componentElement:u,id:T,index:g})[j]=[y],f[T]=v,g+=1,(p={id:T})[j]=[D],h.push(p))}var S=m.templateName,O=m.templateElementName,I=this._TemplateHandler.getTemplates()[S];if(I)for(I=I[0],c=0;c<h.length;c++){v=f[(p=h[c]).id];try{var E=this._TemplateHandler.processNodeTemplate(e,r,I,O,v,p.id);E.id=p.id,E[j]=p[j],h[c]=E}catch(e){i.error(e)}}l={paths:d.paths,values:[h]}}else l=d;a&&this._TemplateHandler.setComponentResults(e,l)}return l},_GetDataProviderSeriesConfig:function(){return{}},_GetComponentNoClonePaths:function(){var e=this._super();return e._resources={converter:!0,defaultDateConverter:!0,defaultDateTimeConverter:!0},e}})});
//# sourceMappingURL=ojtime-base.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojtimeaxis-toolkit',["exports","ojs/ojdvt-toolkit"],function(e,t){"use strict";class s{constructor(){this._dayInMillis=864e5,this._firstDayOfWeek=0}setFirstDayOfWeek(e){this._firstDayOfWeek=e}getFirstDayOfWeek(){return this._firstDayOfWeek}adjustDate(e,t){var s=new Date(e.getTime());if("weeks"===t){s.setHours(0,0,0,0);var i=(e.getDay()-this.getFirstDayOfWeek()+7)%7;i>0&&s.setDate(s.getDate()-i)}else if("months"===t)s.setDate(1),s.setHours(0,0,0,0);else if("days"===t)s.setHours(0,0,0,0);else if("hours"===t)s.setMinutes(0,0,0);else if("minutes"===t)s.setSeconds(0,0);else if("seconds"===t)s.setMilliseconds(0);else if("quarters"===t){var r=Math.floor(s.getMonth()/3);s.setDate(1),s.setHours(0,0,0,0),s.setMonth(3*r)}else"years"===t&&(s.setMonth(0),s.setDate(1),s.setHours(0,0,0,0));return s}getAdjacentDate(e,t,s){var i="next"===s?1:-1;if("seconds"===t)return new Date(e+1e3*i);if("minutes"===t)return new Date(e+6e4*i);if("hours"===t)return new Date(e+36e5*i);var r=new Date(e);return"days"===t?r.setDate(r.getDate()+1*i):"weeks"===t?r.setDate(r.getDate()+7*i):"months"===t?r.setMonth(r.getMonth()+1*i):"quarters"===t?r.setMonth(r.getMonth()+3*i):"years"===t?r.setFullYear(r.getFullYear()+1*i):r.setYear(r.getYear()+1*i),r}}class i extends t.BaseComponentDefaults{constructor(e){super({alta:{backgroundColor:"rgba(255,255,255,0)",borderColor:"#d9dfe3",separatorColor:"#bcc7d2",labelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color: #333333;")}},e)}getNoCloneObject(){return{_secondaryAxis:!0,scale:!0,zoomOrder:!0,converter:!0,_resources:{converter:!0,converterVert:!0,defaultDateConverter:!0,defaultDateTimeConverter:!0}}}}class r{parse(e){this._startTime=new Date(e.start),this._endTime=new Date(e.end);var t=this.ParseRootAttributes();return t.inlineStyle=e.style,t.id=e.id,t.shortDesc=e.shortDesc,t.itemPosition=e._ip,t.customTimeScales=e._cts,t.customFormatScales=e._cfs,t.scale=e.scale,t.converter=e.converter,t.zoomOrder=e.zoomOrder?e.zoomOrder:null,t.orientation=e.orientation?e.orientation:"horizontal",t}ParseRootAttributes(){return{start:this._startTime.getTime(),end:this._endTime.getTime()}}}const a={DEFAULT_BORDER_WIDTH:1,DEFAULT_SEPARATOR_WIDTH:1,DEFAULT_INTERVAL_WIDTH:50,DEFAULT_INTERVAL_HEIGHT:21,DEFAULT_INTERVAL_PADDING:4,getAxisStyle:e=>{var t="",s=a.getBackgroudColor(e);return s&&(t=t+"background-color:"+s+";"),(s=a.getBorderColor(e))&&(t=t+"border-color:"+s+";"),(s=a.getBorderWidth())&&(t=t+"border-width:"+s+";"),t},getBackgroudColor:e=>e.backgroundColor,getBorderColor:e=>e.borderColor,getBorderWidth:()=>a.DEFAULT_BORDER_WIDTH,getAxisLabelStyle:e=>e.labelStyle,getSeparatorColor:e=>e.separatorColor,getAxisSeparatorStyle:e=>{var t="",s=a.getSeparatorColor(e);return s&&(t=t+"color:"+s+";"),t},getAxisClass:e=>e._resources?e._resources.axisClass:void 0,getAxisLabelClass:e=>e._resources?e._resources.axisLabelClass:void 0,getAxisSeparatorClass:e=>e._resources?e._resources.axisSeparatorClass:void 0},n={supportsTouch:()=>t.Agent.isTouchDevice(),getDatePosition:(e,t,s,i)=>{var r=(s-e)*i,a=t-e;return 0===r||0===a?0:r/a},getPositionDate:(e,t,s,i)=>{var r=s*(t-e);return 0===r||0===i?e:r/i+e}},o={renderTimeAxis:(e,s,i,r,a)=>{if(!e.hasValidOptions())return;const h=()=>{e.removeChildren(),o._renderBackground(e);const a=new t.Container(e.getCtx()),h=e.getViewportDates(e.getScale(),s,i),l=h.map(t=>({date:t,pos:n.getDatePosition(e._start,e._end,t.getTime(),e._contentLength)})),c=e.getDateLabelTexts(h,e.getScale()).slice(0,h.length-1),g=o._renderLabels(a,e,l,c);e._axis.addChild(a);const _=o._renderReferenceObjects(a,e,r,l,g);let d=h,m=!1;const u=e.Options._secondaryAxis;let T=u?u.getViewportDates(u.getScale(),s,i):[];if(u&&"alta"!==e.getCtx().getThemeBehavior()){const e=h,t=new Set(T.map(e=>e.getTime())),r=new Set(e.map(e=>e.getTime()));m=0===T.filter(e=>e.getTime()>s&&e.getTime()<i&&!r.has(e.getTime())).length,d=m?e.filter(e=>!t.has(e.getTime())):e}const S=d.filter(e=>!_.has(e.getTime())).map(t=>({date:t,pos:n.getDatePosition(e._start,e._end,t.getTime(),e._contentLength)}));if(o._renderTicks(a,e,S),m){const t=T.filter(e=>!_.has(e.getTime())).map(t=>({date:t,pos:n.getDatePosition(e._start,e._end,t.getTime(),e._contentLength)}));o._renderTicks(a,u,t)}};a?e.__isRendering||(requestAnimationFrame(()=>{h(),e.__isRendering=!1}),e.__isRendering=!0):h()},_renderBackground:e=>{const s=e.getSize(),i=e.getCtx();e._axis&&e._axis.setClipPath(null);const r=new t.ClipPath;e.isVertical()?(e._axis=new t.Path(i,t.PathUtils.roundedRectangle(0,-e.getBorderWidth("top"),s,e.getAxisLength(),0,0,0,0),"axis"),r.addRect(0,0,s,e._contentLength)):(e._axis=new t.Path(i,t.PathUtils.roundedRectangle(-e.getBorderWidth("left"),0,e.getAxisLength(),s,0,0,0,0),"axis"),r.addRect(0,0,e._contentLength,s)),e._axis.setCSSStyle(e._axisStyle);const n=e._axis.getElem();let o=e._axisStyle.getStyle("background-color");o&&t.ToolkitUtils.setAttrNullNS(n,"fill",o),o=e._axisStyle.getStyle("border-color"),o&&t.ToolkitUtils.setAttrNullNS(n,"stroke",o),o=e._axisStyle.getStyle("border-width"),o&&t.ToolkitUtils.setAttrNullNS(n,"stroke-width",o),e._axis.setPixelHinting(!0),e._axis.setClipPath(r),e.addChild(e._axis);const h=a.getAxisClass(e.Options)||"";e._axis.getElem().setAttribute("class",h),e._axis.getElem().setAttribute("stroke-dasharray",e.calcStrokeDashArray())},_renderTicks:(e,s,i)=>{const r=s.getCtx(),n=t.Agent.isRightToLeft(r),o=s.isVertical()?s.getBorderWidth("left"):s.getBorderWidth("top"),h=o+s.getContentSize();let l="";for(let e=0;e<i.length;e++){let r=i[e].pos;s.isVertical()?l+=t.PathUtils.moveTo(o,r)+t.PathUtils.horizontalLineTo(h):n?(r=s._contentLength-r,e===i.length-1&&(r=Math.round(r)+.5),l+=t.PathUtils.moveTo(r,o)+t.PathUtils.verticalLineTo(h)):(0===e&&(r=Math.round(r)+.5),l+=t.PathUtils.moveTo(r,o)+t.PathUtils.verticalLineTo(h))}const c=new t.Path(s.getCtx(),l),g=new t.CSSStyle(a.getAxisSeparatorStyle(s.Options));c.setStroke(new t.Stroke(g.getStyle(t.CSSStyle.COLOR))),c.setPixelHinting(!0);const _=a.getAxisSeparatorClass(s.Options)||"";c.getElem().setAttribute("class",_),e.addChild(c)},_renderLabels:(e,s,i,r)=>{const n=s.getCtx(),o=s.isVertical()?s.getBorderWidth("left"):s.getBorderWidth("top"),h=o+s.getContentSize(),l=t.Agent.isRightToLeft(n),c=a.getAxisLabelStyle(s.Options),g=a.getAxisLabelClass(s.Options)||"",_=s.getScale(),d=s.Options._scaleLabelPosition[s.isTimeComponentScale(_)?_.name:_],m=s.Options._labelAlignment[s.isVertical()?"vertical":"horizontal"],u=[];for(let _=0;_<i.length-1;_++){const T=i[_].pos,S=i[_+1].pos,D=new t.OutputText(n,r[_],0,0);u.push(D),D.setCSSStyle(c),D.getElem().setAttribute("class",g);const p=!l||s.isVertical()?T+(S-T)/2:s._contentLength-(T+(S-T)/2),L=o+(h-o)/2;let x,f=s.isVertical()?p:L;switch(d){case"start":s.isVertical()?(x=L,D.alignCenter()):l?(x=s._contentLength-(T+a.DEFAULT_INTERVAL_PADDING),D.alignRight()):(x=T+a.DEFAULT_INTERVAL_PADDING,D.alignLeft());break;case"center":default:x=s.isVertical()?L:p,D.alignCenter()}switch(D.setX(x),m){case"top":D.setY(o);break;case"middle":default:t.TextUtils.centerTextVertically(D,f)}const v=s.getContentSize(),C=S-T,A=s.isVertical()?v:C,O=s.isVertical()?C:v;if(t.TextUtils.fitText(D,A,O,e),!s.isVertical())if(0===_&&i[_].date.getTime()<s._start){D.isTruncated()&&D.setTextString(D.getUntruncatedTextString());const i=D.getDimensions().w;let r;switch(d){case"start":r=S-Math.max(0,S-T-i-2*a.DEFAULT_INTERVAL_PADDING);break;case"center":default:r=S-Math.max(0,(S-T-i)/2)}const n=Math.max(0,r);l?(D.alignLeft(),D.setX(s._contentLength-n)):(D.alignRight(),D.setX(n));const o=t.TextUtils.fitText(D,r,O,e);if(D.isTruncated()&&o){const e=D.getTextString(),s=D.getUntruncatedTextString();if(e!==s){const e=D.getTextString().length-1,i=s.length,r=Math.max(0,i-e),a=t.OutputText.ELLIPSIS+s.substring(r,i);D.setTextString(a)}}}else if(_===i.length-2&&i[_+1].date.getTime()>s._end){let i,r;switch(D.isTruncated()&&D.setTextString(D.getUntruncatedTextString()),d){case"start":i=s._contentLength-T-2*a.DEFAULT_INTERVAL_PADDING,r=T+a.DEFAULT_INTERVAL_PADDING;break;case"center":default:{const e=D.getDimensions().w;i=s._contentLength-T-Math.max(0,(S-T-e)/2),r=Math.max(T,T+(S-T)/2-e/2)}}l?(D.alignRight(),D.setX(s._contentLength-r)):(D.alignLeft(),D.setX(r)),t.TextUtils.fitText(D,i,O,e)}}return u},_renderReferenceObjects:(e,s,i,r,o)=>{if(s.isVertical())return new Set;const h=s.getCtx(),l=t.Agent.isRightToLeft(h),c=0+s.getContentSize(),g=i.defaultStyleClass||"",_=a.getAxisLabelStyle(s.Options),d=a.getAxisLabelClass(s.Options)||"",m=s.Options._labelAlignment.horizontal,u=i.referenceObjects.filter(e=>{const t="area"!==e.type,s=null!=e.value&&!isNaN(new Date(e.value).getTime()),i=e.label&&""!==e.label.length;return t&&s&&i}),T=[];u.forEach(r=>{let o=n.getDatePosition(s._start,s._end,new Date(r.value).getTime(),s._contentLength);l&&(o=s._contentLength-o);const u=new t.Line(h,o,0,o,c),S=r.svgStyle,D=r.svgClassName||"";null!=S&&u.setStyle(S),u.setClassName(g+" "+D,!0),i.defaultStroke&&u.setStroke(i.defaultStroke),u.setPixelHinting(!0),e.addChild(u);const p=l?o-a.DEFAULT_INTERVAL_PADDING:o+a.DEFAULT_INTERVAL_PADDING,L=new t.OutputText(h,r.label,p,0);L.setCSSStyle(_),L.getElem().setAttribute("class",d);const x=window.getComputedStyle(u.getElem()).getPropertyValue("stroke");L.setStyle({fill:x}),l?L.alignRight():L.alignLeft();const f=0+(c-0)/2;switch(m){case"top":L.setY(0);break;case"middle":default:t.TextUtils.centerTextVertically(L,f)}e.addChild(L),T.push(L)});const S=[];return T.forEach(e=>{const t=e.getDimensions();o.forEach(e=>{const s=e.getDimensions();t.intersects(s)&&e.removeFromParent()}),r.forEach(e=>{const i=l?s._contentLength-e.pos:e.pos;i>=t.x&&i<=t.x+t.w&&S.push(e.date.getTime())})}),new Set(S)}};class h extends t.BaseComponent{constructor(e,t,r){super(e,t,r),this._calendar=new s,this._borderWidth=a.DEFAULT_BORDER_WIDTH,this.setBorderVisibility(!1,!1,!1,!1),this._dateToIsoWithTimeZoneConverter=e.getLocaleHelpers().dateToIsoWithTimeZoneConverter,this.Defaults=new i(e)}SetOptions(e){this.Options=this.Defaults.calcOptions(e)}Parse(e){return this._parser=new r,this._parser.parse(e)}_applyParsedProperties(e){var t=e.orientation;this._isVertical=!(!t||"vertical"!==t),this.setIsVertical(this._isVertical),this._shortDesc=e.shortDesc,this._zoomOrder=e.zoomOrder?e.zoomOrder.slice().reverse():[e.scale],this._customTimeScales=e.customTimeScales,this._customFormatScales=e.customFormatScales,this._start=e.start,this._end=e.end,this._inlineStyle=e.inlineStyle,this._scale=e.scale,this._converter=e.converter,this.applyStyleValues()}setContentLength(e,t){null==t&&(t=this._canvasLength),this._contentLength=t<e?e:t}getAxisLength(){return this._axisLength}isRTL(){return t.Agent.isRightToLeft(this.getCtx())}isVertical(){return this._isVertical}render(e,t,s){var i=e&&null==e._viewStartTime,r=null==e;this.Width=t,this.Height=s,this._prepareCanvasViewport(),i&&this.getPreferredLength(e,this._canvasLength),this.setContentLength(this._canvasLength),this._setAxisDimensions();var a=e&&e._viewStartTime?e._viewStartTime:this._start,n=e&&e._viewEndTime?e._viewEndTime:this._end,h=e&&e._referenceObjects?e._referenceObjects:{referenceObjects:[]},l=e&&e._throttle||!1;o.renderTimeAxis(this,a,n,h,l),(i||r)&&this.RenderComplete()}hasValidOptions(){var e=this._scale&&(-1!==h.VALID_SCALES.indexOf(this._scale)||this.isTimeComponentScale(this._scale)),t=this._scale&&this._customTimeScales&&this._customTimeScales[this._scale],s=this._start&&this._end&&this._end>this._start;return(e||t)&&s}isTimeComponentScale(e){return null!=e.getNextDate&&null!=e.getPreviousDate&&null!=e.formatter&&null!=e.name}isEqualScale(e,t){return e===t||null!=e.name&&null!=t&&e.name===t.name}applyStyleValues(){this._axisStyle=new t.CSSStyle(a.getAxisStyle(this.Options)),this._axisStyle.parseInlineStyle(this._inlineStyle);var e=this._axisStyle.getBorderWidth(),s="border:"+2*e+"px;";this._axisStyle.parseInlineStyle(s),this.setBorderWidth(e)}_prepareCanvasViewport(){this._isVertical?(this._canvasLength=this.Height,this._canvasSize=this.Width):(this._canvasLength=this.Width,this._canvasSize=this.Height)}_setAxisDimensions(){null!==this._canvasSize&&this.setContentSize(this._canvasSize-this.getSizeBorderWidth()),this._axisLength=this._contentLength+this.getSizeBorderWidth()-a.DEFAULT_SEPARATOR_WIDTH}getPreferredLength(e,t){this.SetOptions(e),this._resources=this.Options._resources?this.Options._resources:[],this._locale=this.Options._locale?this.Options._locale:"en-US";var s=this._resources.firstDayOfWeek?this._resources.firstDayOfWeek:0;this._calendar.setFirstDayOfWeek(s),this._dateToIsoWithTimeZoneConverter||(this._dateToIsoWithTimeZoneConverter=this.getCtx().getLocaleHelpers().dateToIsoWithTimeZoneConverter);var i=this.Parse(this.Options);if(this._applyParsedProperties(i),this.hasValidOptions()){this.setConverter(this._converter),this._isVertical?this.setDefaultConverter(this._resources.converterVert):this.setDefaultConverter(this._resources.converter),this._zoomLevelLengths=this._zoomOrder.map(()=>0);var r=this._zoomOrder.map((e,t)=>t),a=this._isVertical?{type:"range",params:{startTime:this._start,endTime:this._end}}:{type:"sparse",params:{numSections:4,numIntervalsPerSection:10}};this._maxContentLength=t,this.updateDimensions(r,a,t),null!==this._canvasSize&&(this._zoomLevelLengths[this._zoomLevelOrder]=t)}return this._contentLength}updateDimensions(e,t,s){for(var i=0;i<e.length;i++){var r=e[i];if(r>=0&&r<this._zoomOrder.length){var a,n=this._zoomOrder[r];if(this.isEqualScale(n,this._scale)&&(this._zoomLevelOrder=r),"sparse"===t.type){a=this._sampleIntervals(n,t.params.numSections,t.params.numIntervalsPerSection);var o=Object.keys(a),h=o.reduce((e,t)=>e+(a[t]-t),0)/o.length,l=(this._end-this._start)/h;this._maxContentLength=Math.max(this._maxContentLength,l*s)}else{a={};for(var c=this.getViewportDates(n,t.params.startTime,t.params.endTime),g=0;g<c.length-1;g++)a[c[g].getTime()]=c[g+1].getTime();this._maxContentLength=Math.max(this._maxContentLength,Object.keys(a).length*s)}this._updateZoomLevelLength(r,a)}}this.setContentLength(this._zoomLevelLengths[this._zoomLevelOrder],s)}_updateZoomLevelLength(e,s){var i=this.getCtx(),r=a.getAxisLabelStyle(this.Options),n=2*a.DEFAULT_INTERVAL_PADDING,o=t.TextUtils.getTextStringHeight(this.getCtx(),r)+n,h=this._zoomOrder[e],l=a.DEFAULT_INTERVAL_WIDTH,c=1/0,g=1/0;Object.keys(s).forEach(e=>{var a=s[e],_=this.formatDate(new Date(a),null,"axis",h),d=t.TextUtils.getTextStringWidth(i,_,r)+n;l=Math.max(l,d),c=Math.min(c,(a-e)/l),g=Math.min(g,(a-e)/o)});var _=this._isVertical?g:c,d=(this._end-this._start)/_;this._zoomLevelLengths[e]=d,this.setContentSize(this._isVertical?l:o)}_sampleIntervals(e,t,s){for(var i={},r=Math.floor((this._end-this._start)/t),a=0;a<t;a++){for(var n=this._start+r*a,o=Math.min(this._start+r*(a+1),this._end),h=this.adjustDate(n,e).getTime(),l=0;l<s&&!(h>=o);l++){var c=this.getNextDate(h,e).getTime();i[h]=c,h=c}i[h=this.adjustDate(o-1,e).getTime()]=this.getNextDate(h,e).getTime()}return i}getViewportDates(e,t,s){const i=[this.adjustDate(t,e)];for(;i[i.length-1].getTime()<s;)i.push(this.getNextDate(i[i.length-1].getTime(),e));return i}getDateLabelTexts(e,t){return e.map(e=>this.formatDate(e,null,"axis",t))}setScale(e){this._scale=e}getScale(){return this._scale}increaseScale(){for(var e=0;e<this._zoomOrder.length-1;e++)if(this.isEqualScale(this._zoomOrder[e],this._scale))return this._scale=this._zoomOrder[e+1],!0;return!1}decreaseScale(){for(var e=1;e<this._zoomOrder.length;e++)if(this._zoomOrder[e]===this._scale)return this._scale=this._zoomOrder[e-1],!0;return!1}setConverter(e){this._converter=e}setDefaultConverter(e){this._defaultConverter=e}getContentSize(){return this._contentSize}setContentSize(e){e>this._contentSize&&(this._contentSize=e)}setBorderWidth(e){this._borderWidth=e}setBorderVisibility(e,t,s,i){this._borderTopWidth=(0|e)*this._borderWidth,this._borderRightWidth=(0|t)*this._borderWidth,this._borderBottomWidth=(0|s)*this._borderWidth,this._borderLeftWidth=(0|i)*this._borderWidth}calcStrokeDashArray(){if(this._isVertical)var e={top:this.getSize(),right:this.getAxisLength(),bottom:this.getSize(),left:this.getAxisLength()};else e={top:this.getAxisLength(),right:this.getSize(),bottom:this.getAxisLength(),left:this.getSize()};for(var t=[],s=0,i=!0,r=["top","right","bottom","left"],a=0;a<r.length;a++){this.getBorderWidth(r[a])>0===i?s+=e[r[a]]:(t.push(s),s=e[r[a]],i=!i)}return t.push(s),t.toString()}getSizeBorderWidth(){return this._borderTopWidth+this._borderBottomWidth}getBorderWidth(e){switch(e){case"top":return this._borderTopWidth;case"right":return this._borderRightWidth;case"bottom":return this._borderBottomWidth;case"left":return this._borderLeftWidth;default:return this._borderWidth}}getSize(){return this._contentSize+this.getSizeBorderWidth()}adjustDate(e,t){var s=t||this._scale;return this.isTimeComponentScale(s)?new Date(s.getPreviousDate(new Date(e))):this._calendar.adjustDate(new Date(e),s)}getNextDate(e,t){var s=t||this._scale;return this.isTimeComponentScale(s)?new Date(s.getNextDate(new Date(e))):this.getAdjacentDate(e,s,"next")}getAdjacentDate(e,t,s){var i=t||this._scale;if(this.isTimeComponentScale(i)){let t=new Date(i.getNextDate(new Date(e)));return"next"===s?t:new Date(2*e-t)}return this._calendar.getAdjacentDate(e,t,s)}formatDate(e,t,s,i){var r=i||this.getScale();if(this.isTimeComponentScale(r))return r.formatter(this._dateToIsoWithTimeZoneConverter?this._dateToIsoWithTimeZoneConverter(e):e);if("axis"===(s=s||"axis"))(t=t||this._converter)&&(t[r]?t=t[r]:t.default&&(t=t.default)),t&&t.format||!this._defaultConverter||!this._defaultConverter[r]||(t=this._defaultConverter[r]);else if(!t){var a=this._resources.defaultDateTimeConverter,n=this._resources.defaultDateConverter;t="hours"===r||"minutes"===r||"seconds"===r?a:n}return t.format(this._dateToIsoWithTimeZoneConverter?this._dateToIsoWithTimeZoneConverter(e):e)}getZoomOrder(){return this._zoomOrder}setIsVertical(e){this._contentSize=e?a.DEFAULT_INTERVAL_WIDTH:a.DEFAULT_INTERVAL_HEIGHT}setCanvasSize(e){this._canvasSize=e}getZoomLevelLengths(){return this._zoomLevelLengths}getMaxContentLength(){return this._maxContentLength}getZoomLevelOrder(){return this._zoomLevelOrder}setZoomLevelOrder(e){this._zoomLevelOrder=e}}h.VALID_SCALES=["seconds","minutes","hours","days","weeks","months","quarters","years"],e.TimeAxis=h,e.TimeAxisUtils=n,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=ojtimeaxis-toolkit.js.map;
/**
 * @license
 * Copyright (c) 2014, 2022, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define('ojs/ojdvt-timecomponent',["exports","ojs/ojdvt-toolkit","ojs/ojtimeaxis-toolkit"],function(t,e,i){"use strict";const s={_DEFAULT_TIME_DIR_SCROLLBAR_STYLE:"height: 3px; width: 3px; color: #9E9E9E; background-color: #F0F0F0",_DEFAULT_CONTENT_DIR_SCROLLBAR_STYLE:"height: 3px; width: 3px; color: #9E9E9E; background-color: #F0F0F0",_SCROLLBAR_PADDING:4,getTimeDirScrollbarStyle:()=>new e.CSSStyle(s._DEFAULT_TIME_DIR_SCROLLBAR_STYLE),getContentDirScrollbarStyle:()=>new e.CSSStyle(s._DEFAULT_CONTENT_DIR_SCROLLBAR_STYLE),getScrollbarPadding:()=>s._SCROLLBAR_PADDING};class n extends e.BaseComponent{constructor(t,e,i){super(t,e,i),this._virtualize=!1,this.ZOOM_BY_VALUE=1.5,this.WHEEL_UNITS_PER_LINE=40}Init(t,e,i){super.Init(t,e,i),this._virtualize=!1,this.ZOOM_BY_VALUE=1.5,this.WHEEL_UNITS_PER_LINE=40}render(t,e,i){if(t){this._resources=t._resources,null==this._resources&&(this._resources=[]),this.SetOptions(t);var s=this.Options.dragMode;this.SetPanningEnabled("pan"===s||null==s,!0),this.SetMarqueeEnabled("select"===s&&"multiple"===this.Options.selectionMode,!0)}if(this.Width=e,this.Height=i,this.Options){var n=this.Parse(this.Options);this._applyParsedProperties(n)}}SetOptions(t){this.Options=this.Defaults.calcOptions(t);var i=new Date(t.start).getTime(),s=new Date(t.end).getTime(),n=new Date(t.viewportStart).getTime(),a=new Date(t.viewportEnd).getTime();n>=i&&n<s||(this._viewStartTime=null,this.Options.viewportStart=""),a>i&&a<=s||(this._viewEndTime=null,this.Options.viewportEnd=""),e.Agent.isEnvironmentTest()&&(this.Options.animationOnDisplay="none",this.Options.animationOnDataChange="none")}clearComponent(){this._canvas&&this._canvas.removeChildren()}_applyParsedProperties(t){this._start=t.start,this._end=t.end,this._inlineStyle=t.inlineStyle,this._timeDirScrollbar=t.timeDirScrollbar,this._contentDirScrollbar=t.contentDirScrollbar,this.applyStyleValues()}static sanitizeData(t,i){var s,n;if("series"===i||"row"===i){var a="series"===i?"items":"tasks";if(t[a].length>0)return t[a][0]._noTemplate?((s=e.JsonUtils.clone(t,null,{itemProp:!0}))[a]=s[a].map(t=>t._itemData),s):t[a][0]._itemData?((s=e.JsonUtils.clone(t,null,{itemProp:!0}))[a]=s[a].map(t=>(delete(n=e.JsonUtils.clone(t))._itemData,n)),s):t}else{if(t._noTemplate)return t._itemData;if(t._itemData)return delete(n=e.JsonUtils.clone(t))._itemData,n}return t}applyStyleValues(){this._style&&this._style.parseInlineStyle(this._inlineStyle)}isDndEnabled(){return!1}isAnimationEnabled(){return!1}getAdjustedStartTime(){return this._start}getAdjustedEndTime(){return this._end}getContentLength(){return this._contentLength}setContentLength(t){this._canvasLength<t?this._contentLength=t:this._contentLength=this._canvasLength,this._virtualize||(this._fetchStartPos=0,this._fetchEndPos=this._contentLength)}getCanvasSize(){return this._canvasSize}getCanvasLength(){return this._canvasLength}isRTL(){return e.Agent.isRightToLeft(this.getCtx())}isVertical(){return this._isVertical}getTimeAxis(){return null}prepareViewportLength(){var t,e;if(this.setRelativeStartPos(0),this._viewStartTime&&this._viewEndTime)(t=this._viewEndTime-this._viewStartTime)>0&&(e=this._canvasLength/t,this.setContentLength(e*(this._end-this._start)),this.setRelativeStartPos(e*(this._start-this._viewStartTime)));else{var i=this.getTimeAxis(),s=i.getZoomLevelLengths()[i._zoomLevelOrder],n=this._start,a=this._end;null==this._viewStartTime?null!=this._viewEndTime?(this._viewStartTime=this._viewEndTime-this._canvasLength/s*(a-n),this._viewStartTime<this._start&&(this._viewStartTime=this._start),t=this._viewEndTime-this._viewStartTime,e=this._canvasLength/t,this.setContentLength(e*(this._end-this._start)),this.setRelativeStartPos(e*(this._start-this._viewStartTime))):(this._viewStartTime=this._start,this.setRelativeStartPos(0),this._viewEndTime=this._canvasLength/s*(a-n)+this._viewStartTime,this._viewEndTime>this._end&&(this._viewEndTime=this._end)):(this._viewEndTime=this._canvasLength/s*(a-n)+this._viewStartTime,this._viewEndTime>this._end&&(this._viewEndTime=this._end),t=this._viewEndTime-this._viewStartTime,e=this._canvasLength/t,this.setContentLength(e*(this._end-this._start)),this.setRelativeStartPos(e*(this._start-this._viewStartTime)))}}renderTimeZoomCanvas(t){this._timeZoomCanvas?this._timeZoomCanvas.setClipPath(null):this._timeZoomCanvas=new e.Container(this.getCtx(),"g","iCanvas");var i=new e.ClipPath;this.isVertical()?(i.addRect(this._startX,this._startY,this._canvasSize,this._canvasLength),this._timeZoomCanvas.setTranslateX(this._startX),this._timeZoomCanvas.setTranslateY(this._startY+this.getAbsoluteStartPos())):(i.addRect(this._startX,this._startY,this._canvasLength,this._canvasSize),this._timeZoomCanvas.setTranslateX(this._startX+this.getAbsoluteStartPos()),this._timeZoomCanvas.setTranslateY(this._startY)),t.setClipPath(i),this._timeZoomCanvas.getParent()!=t&&t.addChild(this._timeZoomCanvas)}getTimeZoomCanvas(){return this._timeZoomCanvas}renderZoomControls(t){if(!this.isZoomingEnabled())return this._canvas.removeChild(this.zoomin),this._canvas.removeChild(this.zoomout),this.zoomin=null,void(this.zoomout=null);var s,n=this.getCtx(),a=this.getTimeAxis(),o=this.Options.translations,r=t.zoomInProps,h=r.imageSize,l=r.class,_=r.posX,g=r.posY;null==this.zoomin&&(s=e.ToolkitUtils.getIconStyle(n,l),this.zoomin=new e.TransientButton(n,s,h,this.EventManager,this.EventManager.HandleZoomInClick),this.EventManager.associate(this.zoomin,this.zoomin));var m=t.zoomOutProps;h=m.imageSize,l=m.class;var c=m.posX,v=m.posY;null==this.zoomout&&(s=e.ToolkitUtils.getIconStyle(n,l),this.zoomout=new e.TransientButton(n,s,h,this.EventManager,this.EventManager.HandleZoomOutClick),this.EventManager.associate(this.zoomout,this.zoomout)),this.zoomin.setTooltip(o.tooltipZoomIn),this.zoomout.setTooltip(o.tooltipZoomOut),this.zoomin.hide(),this.zoomout.hide(),i.TimeAxisUtils.supportsTouch()&&(e.ToolkitUtils.setAttrNullNS(this.zoomin.getElem(),"role","button"),e.ToolkitUtils.setAttrNullNS(this.zoomin.getElem(),"aria-label",o.tooltipZoomIn),e.ToolkitUtils.setAttrNullNS(this.zoomout.getElem(),"role","button"),e.ToolkitUtils.setAttrNullNS(this.zoomout.getElem(),"aria-label",o.tooltipZoomOut)),this.zoomin.setTranslateX(_),this.zoomout.setTranslateX(c),this.zoomin.setTranslateY(g),this.zoomout.setTranslateY(v),this.zoomin.getParent()!=this._canvas&&this._canvas.addChild(this.zoomin),this.zoomout.getParent()!=this._canvas&&this._canvas.addChild(this.zoomout);var u=this.getContentLength();u>=a.getMaxContentLength()&&this.disableZoomButton(!0),this._canvasLength>=u&&this.disableZoomButton(!1)}HandleMouseWheel(t){e.EventManager.consumeEvent(t);var i=t.wheelDelta,s=t.getNativeEvent();if(this.hasValidOptions()&&(null!=s.wheelDeltaX?t.wheelDeltaX=s.wheelDeltaX/this.WHEEL_UNITS_PER_LINE:null!=s.deltaX&&(s.deltaMode==s.DOM_DELTA_LINE?t.wheelDeltaX=-s.deltaX:s.deltaMode==s.DOM_DELTA_PIXEL&&(t.wheelDeltaX=-s.deltaX/n.SCROLL_LINE_HEIGHT)),i)){var a=this.getCtx().getStageAbsolutePosition();if(this._isVertical)var o=t.pageY-a.y-this.getStartYOffset();else o=t.pageX-a.x-this.getStartXOffset();var r=(this._end-this._start)/this.getContentLength();if(this.isRTL()&&!this._isVertical)var h=this._viewEndTime-r*o;else h=r*o+this._viewStartTime;t.zoomTime=h,t.zoomCompLoc=o,t.zoomWheelDelta=.02*i+1}}handleZoomWheel(t,e,i,s){var n=(this._viewEndTime-this._viewStartTime)/(this._end-this._start)*this.getContentLength();this.setContentLength(t);var a=n/this.getContentLength()*(this._end-this._start);if(e){var o=(this._end-this._start)/this.getContentLength();this.isRTL()&&!this._isVertical?(this._viewEndTime=e+i*o,this._viewEndTime>this._end&&(this._viewEndTime=this._end),this._viewStartTime=this._viewEndTime-a,this._viewStartTime<this._start&&(this._viewStartTime=this._start,this._viewEndTime=this._viewStartTime+a,this._viewEndTime>this._end&&(this._viewEndTime=this._end))):(this._viewStartTime=e-i*o,this._viewStartTime<this._start&&(this._viewStartTime=this._start),this._viewEndTime=this._viewStartTime+a,this._viewEndTime>this._end&&(this._viewEndTime=this._end,this._viewStartTime=this._viewEndTime-a,this._viewStartTime<this._start&&(this._viewStartTime=this._start))),this.setRelativeStartPos(1/o*(this._start-this._viewStartTime))}else this._viewStartTime=this._start,this._viewEndTime=this._viewStartTime+a,this._viewEndTime>this._end&&(this._viewEndTime=this._end),this.setRelativeStartPos(0);this.applyTimeZoomCanvasPosition()}zoomBy(t){var e=(1/t-1)/2+1;if(this._isVertical)var i=this.Height/2;else i=this.Width/2;var s=(this._end-this._start)/this.getContentLength()*i+this._viewStartTime;this.handleZoomWheel(this.getContentLength()*e,s,i,!0)}beginPinchZoom(t,e,i,s){this._isVertical?this._initialPinchZoomLoc=Math.sqrt((e-s)*(e-s))+(e<s?e:s):this._initialPinchZoomLoc=Math.sqrt((t-i)*(t-i))+(t<i?t:i);var n=(this._end-this._start)/this.getContentLength();this.isRTL()&&!this._isVertical?this._initialPinchZoomTime=this._viewEndTime-n*this._initialPinchZoomLoc:this._initialPinchZoomTime=n*this._initialPinchZoomLoc+this._viewStartTime,this._initialPinchZoomDist=Math.sqrt((t-i)*(t-i)+(e-s)*(e-s)),this._initialPinchZoomLength=this.getContentLength()}contPinchZoom(t,e,i,s){var n=Math.sqrt((t-i)*(t-i)+(e-s)*(e-s));n!=this._initialPinchZoomDist&&(this._triggerViewportChange=!0);var a=n/this._initialPinchZoomDist*this._initialPinchZoomLength;this.handleZoomWheel(a,this._initialPinchZoomTime,this._initialPinchZoomLoc,!1)}endPinchZoom(){this._initialPinchZoomDist=null,this._initialPinchZoomLoc=null,this._initialPinchZoomLength=null,this._initialPinchZoomTime=null,this._triggerViewportChange&&(this._triggerViewportChange=!1,this.dispatchEvent(this.createViewportChangeEvent()))}SetPanningEnabled(t,e){var i=this.getOptions().dragMode;this._panningEnabled=!(!e&&"pan"!==i&&null!=i)&&t}IsPanningEnabled(){return this._panningEnabled}SetMarqueeEnabled(t,e){e||this.isMarqueeSelectEnabled()?this._marqueeEnabled=t:this._marqueeEnabled=!1}IsMarqueeEnabled(){return this._marqueeEnabled}isMarqueeSelectEnabled(){return"select"===this.getOptions().dragMode&&"multiple"===this.getOptions().selectionMode}isZoomingEnabled(){return"off"!==this.getOptions().zooming}IsTimeCursorEnabled(){return"on"===this.getOptions().timeCursor}panZoomCanvasBy(t){if(this._isVertical){var e=this._timeZoomCanvas.getTranslateY()-t,i=-(this.getContentLength()-this._canvasLength-this._startY),s=this._startY;e<i?e=i:e>s&&(e=s),this._timeZoomCanvas.setTranslateY(e);var n=e-this._startY;this.setAbsoluteStartPos(n);var a=this.getContentLength()/(this._end-this._start),o=this._viewEndTime-this._viewStartTime;this._viewStartTime=this._start-n/a,this._viewEndTime=this._viewStartTime+o,this._viewEndTime>this._end&&(this._viewEndTime=this._end)}else{var r=this._timeZoomCanvas.getTranslateX()-t,h=-(this.getContentLength()-this._canvasLength-this._startX),l=this._startX;r<h?r=h:r>l&&(r=l),this._timeZoomCanvas.setTranslateX(r),this.setAbsoluteStartPos(r-this._startX),n=this.getRelativeStartPos(),a=this.getContentLength()/(this._end-this._start),o=this._viewEndTime-this._viewStartTime,this._viewStartTime=this._start-n/a,this._viewEndTime=this._viewStartTime+o,this._viewEndTime>this._end&&(this._viewEndTime=this._end)}}handleZoom(t){t?this.zoomBy(1/this.ZOOM_BY_VALUE):this.zoomBy(this.ZOOM_BY_VALUE)}enableZoomButton(t){t?this.zoomin.setEnabled(!0):this.zoomout.setEnabled(!0)}disableZoomButton(t){t?(this.zoomin.setEnabled(!1),this.zoomin.setCursor(null)):(this.zoomout.setEnabled(!1),this.zoomout.setCursor(null))}applyTimeZoomCanvasPosition(){this._isVertical?this._timeZoomCanvas.setTranslateY(this._startY+this.getAbsoluteStartPos()):this._timeZoomCanvas.setTranslateX(this._startX+this.getAbsoluteStartPos())}getAbsoluteStartPos(){return this._startPos}setAbsoluteStartPos(t){this._startPos=t}getRelativeStartPos(){return this.isRTL()&&!this._isVertical?this._canvasLength-this.getContentLength()-this._startPos:this._startPos}setRelativeStartPos(t){this.isRTL()&&!this._isVertical?this._startPos=this._canvasLength-this.getContentLength()-t:this._startPos=t}getStartXOffset(){return this._startX}setStartXOffset(t){this._startX=t}getStartYOffset(){return this._startY}setStartYOffset(t){this._startY=t}getGraphicalAreaBounds(){return this.isVertical()?new e.Rectangle(this._startX,this._startY,this._canvasSize,this._canvasLength):new e.Rectangle(this._startX,this._startY,this._canvasLength,this._canvasSize)}isTimeDirScrollbarOn(){return!0}isContentDirScrollbarOn(){return!0}getTimeDirScrollbar(){return this.timeDirScrollbar}getContentDirScrollbar(t){return t?this.contentDirScrollbar[t]:this.contentDirScrollbar}setTimeDirScrollbar(t){this.timeDirScrollbar=t}setContentDirScrollbar(t,e){null!=e?(null==this.contentDirScrollbar&&(this.contentDirScrollbar=[]),this.contentDirScrollbar[e]=t):this.contentDirScrollbar=t}getScrollbarPadding(){return s._SCROLLBAR_PADDING}getTimeDirScrollbarStyle(){return s.getTimeDirScrollbarStyle()}getContentDirScrollbarStyle(){return s.getContentDirScrollbarStyle()}HandleEvent(t,e){"dvtSimpleScrollbar"==t.type&&(t=this.processScrollbarEvent(t,e)),t&&this.dispatchEvent(t)}processScrollbarEvent(t,e){if(e==this.timeDirScrollbar){var i=t.newMin,s=t.newMax;this._viewStartTime=i,this._viewEndTime=s;var n=this.getContentLength()/(this._end-this._start);this.setRelativeStartPos(n*(this._start-this._viewStartTime)),this.applyTimeZoomCanvasPosition();var a=this.createViewportChangeEvent();this.dispatchEvent(a)}}processEvent(t){t&&this.dispatchEvent(t)}createViewportChangeEvent(){return null}getViewportStartTime(){return this._viewStartTime}setViewportStartTime(t){this._viewStartTime=t}getViewportEndTime(){return this._viewEndTime}setViewportEndTime(t){this._viewEndTime=t}HandleKeyDown(t){}HandleMouseDown(t){}HandleFocus(t){null!=this.zoomin&&this.zoomin._onFocus(t),null!=this.zoomout&&this.zoomout._onFocus(t)}HandleBlur(t){null!=this.zoomin&&this.zoomin._onBlur(t),null!=this.zoomout&&this.zoomout._onBlur(t)}beginDragPan(t,e){this._currentX=t,this._currentY=e}endDragPan(){this.endPan()}setPanCursorDown(){this.setCursor(e.ToolkitUtils.getGrabbingCursor())}setPanCursorUp(){this.setCursor(e.ToolkitUtils.getGrabCursor())}registerAndConstructGlassPane(){if(this._glassPaneUsageStack||(this._glassPaneUsageStack=[]),!this._glassPane){var t=this.getGraphicalAreaBounds();this._glassPane=new e.Rect(this.getCtx(),t.x,t.y,t.w,t.h),this._glassPane.setInvisibleFill()}this._glassPaneUsageStack.push(1)}installGlassPane(){return!this._glassPaneDrawn&&(this.addChild(this._glassPane),this._glassPaneDrawn=!0,!0)}unregisterAndDestroyGlassPane(){this._glassPaneUsageStack.pop(),this._glassPaneDrawn&&0===this._glassPaneUsageStack.length&&(this.removeChild(this._glassPane),this._glassPaneDrawn=!1)}renderAriaLiveRegion(t){if(!this._ariaLiveRegion){var e=this.getCtx();this._ariaLiveRegion=document.createElement("div"),this._ariaLiveRegion.id=t,this._ariaLiveRegion.setAttribute("aria-live","assertive"),this._ariaLiveRegion.style.clip="rect(1px, 1px, 1px, 1px)",this._ariaLiveRegion.style.height="1px",this._ariaLiveRegion.style.overflow="hidden",this._ariaLiveRegion.style.position="absolute",this._ariaLiveRegion.style.whiteSpace="nowrap",this._ariaLiveRegion.style.width="1px",e.getContainer().appendChild(this._ariaLiveRegion)}}getAriaLiveRegion(){return this._ariaLiveRegion}updateLiveRegionText(t){this._ariaLiveRegion&&(this._ariaLiveRegion.textContent=t)}removeAriaLiveRegion(){this._ariaLiveRegion&&(this.getCtx().getContainer().removeChild(this._ariaLiveRegion),this._ariaLiveRegion=null)}HandleTouchEnd(t){"none"!=this._selectionMode&&this.handleShapeClick(t,"multiple"==this._selectionMode)}handleShapeClick(t){}HandleMouseClick(t){this.handleShapeClick(t,t.ctrlKey&&"multiple"==this._selectionMode)}endPan(){this._triggerViewportChange&&(this._triggerViewportChange=!1,this.dispatchEvent(this.createViewportChangeEvent()))}contDragPan(t,e){if(this._currentX&&this._currentY){var i=this._currentX-t,s=this._currentY-e;return(0!=i||0!=s)&&(this._triggerViewportChange=!0,this._currentX=t,this._currentY=e,this.panBy(i,s),!0)}return!1}panBy(t,e){this.panZoomCanvasBy(t)}}n.SCROLL_LINE_HEIGHT=15;class a extends e.EventManager{constructor(t){super(t.getCtx(),t.processEvent,t,t),this._comp=t,this._isDragPanning=!1,this._isPinchZoom=!1}Init(t,e,i,s){void 0!==e?(super.Init(t,e,i,s),this._comp=s):(super.Init(t.getCtx(),t.processEvent,t,t),this._comp=t),this._isDragPanning=!1,this._isPinchZoom=!1}addListeners(t){super.addListeners(t),e.SvgDocumentUtils.addDragListeners(this._comp,this._onDragStart,this._onDragMove,this._onDragEnd,this),e.Agent.isTouchDevice()||("firefox"===e.Agent.browser?t.addEvtListener("wheel",this.OnMouseWheel,!1,this):t.addEvtListener(e.MouseEvent.MOUSEWHEEL,this.OnMouseWheel,!1,this))}RemoveListeners(t){super.RemoveListeners(t),e.Agent.isTouchDevice()||("firefox"===e.Agent.browser?t.removeEvtListener("wheel",this.OnMouseWheel,!1,this):t.removeEvtListener(e.MouseEvent.MOUSEWHEEL,this.OnMouseWheel,!1,this))}OnFocus(t){super.OnFocus(t),this._comp.HandleFocus(t)}OnBlur(t){super.OnBlur(t),this._comp.HandleBlur(t)}OnKeyDown(t){super.OnKeyDown(t),this._comp.HandleKeyDown(t)}OnClick(t){super.OnClick(t),this._comp.HandleMouseClick(t)}PreOnMouseDown(t){super.PreOnMouseDown(t),this._comp.HandleMouseDown(t)}OnMouseWheel(t){this._comp.HandleMouseWheel(t)}OnTouchStartBubble(t){super.OnTouchStartBubble(t),this._comp.HandleTouchStart(t),this._comp.getCtx().getStage().getSVGRoot().parentNode.focus()}OnTouchEndBubble(t){super.OnTouchEndBubble(t),this._comp.HandleTouchEnd(t)}_onDragStart(t){return!!this._comp.hasValidOptions()&&(e.Agent.isTouchDevice()?this._onTouchDragStart(t):this._onMouseDragStart(t))}_onDragMove(t){return e.Agent.isTouchDevice()?this._onTouchDragMove(t):this._onMouseDragMove(t)}_onDragEnd(t){return e.Agent.isTouchDevice()?this._onTouchDragEnd(t):this._onMouseDragEnd(t)}_getRelativePosition(t,i){return this._stageAbsolutePosition||(this._stageAbsolutePosition=this._context.getStageAbsolutePosition()),new e.Point(t-this._stageAbsolutePosition.x,i-this._stageAbsolutePosition.y)}_onMouseDragStart(t){if(t.button!=e.MouseEvent.RIGHT_CLICK_BUTTON){var i=this._getRelativePosition(t.pageX,t.pageY),s=this._getDragHandler(i);if(this._comp.IsPanningEnabled()){if(this._comp.getGraphicalAreaBounds().containsPoint(i.x,i.y)&&!this._isDragPanning)return this.hideTooltip(),this._comp.registerAndConstructGlassPane(),this._comp.setPanCursorDown(),this._comp.beginDragPan(i.x,i.y),this._isDragPanning=!0,!0}else if(s&&this._comp.IsMarqueeEnabled()){var n=s.processDragStart(i,t.ctrlKey);return n&&(n._relPos=i,this.ProcessMarqueeEvent(n)),this._comp.setCursor(s.getCursor(i)),!0}}return!1}_onMouseDragMove(t){var e=this._getRelativePosition(t.pageX,t.pageY),i=this._getDragHandler();if(this._comp.IsPanningEnabled()&&this._comp.contDragPan(e.x,e.y)&&this._isDragPanning)this._comp.installGlassPane();else if(i&&this._comp.IsMarqueeEnabled()){var s=i.processDragMove(e,t.ctrlKey);s&&(s._relPos=e,this.ProcessMarqueeEvent(s))}}_onMouseDragEnd(t){var e=this._getRelativePosition(t.pageX,t.pageY),i=this._getDragHandler();if(this._comp.IsPanningEnabled()&&this._isDragPanning)this._isDragPanning=!1,this._comp.endDragPan(),this._stageAbsolutePosition=null,this._comp.unregisterAndDestroyGlassPane(),this._comp.getGraphicalAreaBounds().containsPoint(e.x,e.y)?this._comp.setPanCursorUp():this._comp.setCursor("inherit");else if(i&&this._comp.IsMarqueeEnabled()){var s=i.processDragEnd(e,t.ctrlKey);s&&(s._relPos=e,this.ProcessMarqueeEvent(s)),this._comp.setCursor(i.getCursor(e))}}OnMouseMove(t){super.OnMouseMove(t);var e=this._getRelativePosition(t.pageX,t.pageY),i=this._getDragHandler();if(this._comp.getGraphicalAreaBounds().containsPoint(e.x,e.y)){if(this._comp.IsPanningEnabled())return void(this._isDragPanning?this._comp.setPanCursorDown():this._comp.setPanCursorUp());if(i)return void(this._comp.IsMarqueeEnabled()&&this._comp.setCursor(i.getCursor(e)))}th