Rem  Copyright (c) 1999, 2022, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      dbcsconf.sql
Rem
Rem    DESCRIPTION
Rem
Rem    NOTES
Rem      Assumes the SYS user is connected.
Rem
Rem    REQUIREMENTS
Rem      - Oracle Database 11.2.0.4 or later
Rem
Rem    Arguments:
Rem     Position 1: DBCS password
Rem     Position 2: Virtual directory for APEX images
Rem
Rem    Example:
Rem
Rem    1)Local
Rem      sqlplus "sys/syspass as sysdba" @dbcsconf Passw0rd! /i/
Rem
Rem    2)With connect string
Rem      sqlplus "sys/syspass@10g as sysdba" @dbcsconf Passw0rd! /i/
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem      jstraub   04/02/2018 - Created
Rem      cneumuel  07/11/2018 - Added prefix parameter to apex_rest_config_core.sql (bug #28315666)

set define '^'
set concat on
set concat .
set verify off


define OPC_PASSWORD      = '^1'
define IMGPRE            = '^2'

define PREFIX            = '@'


@^PREFIX.core/scripts/set_appun.sql
@^PREFIX.core/scripts/apxpreins.sql

set define '^'

Rem from dbtools_apex_schema_passwords_reset.sql

alter session set current_schema = ^APPUN;

declare
    c_password constant varchar2(4000) := trim('^OPC_PASSWORD.');
    c_pass_enq constant varchar2(4000) := wwv_flow_assert.enquote_name(c_password);
begin
    if c_password is not null then
        execute immediate 'alter user APEX_PUBLIC_USER IDENTIFIED BY ' || c_pass_enq || ' ACCOUNT UNLOCK';
        execute immediate 'alter user APEX_REST_PUBLIC_USER IDENTIFIED BY ' || c_pass_enq || ' ACCOUNT UNLOCK';
        execute immediate 'alter user APEX_LISTENER IDENTIFIED BY ' || c_pass_enq || ' ACCOUNT UNLOCK';
    end if;
end;
/

Rem from dbtools_apex_password_policy_config.sql

PROMPT Starting APEX Password Policy Configuration

declare
    c_password constant varchar2(4000) := trim('^OPC_PASSWORD.');
begin
    if c_password is null then
        -- APEX upgrade, don't reset password policies
        return;
    end if;

    APEX_INSTANCE_ADMIN.SET_PARAMETER( 'PASSWORD_MIN_LENGTH', 8 );
    APEX_INSTANCE_ADMIN.SET_PARAMETER( 'STRONG_SITE_ADMIN_PASSWORD', 'Y' );
    APEX_INSTANCE_ADMIN.SET_PARAMETER( 'SERVICE_ADMIN_PASSWORD_NOT_LIKE_WS_NAME', 'N' );
    APEX_INSTANCE_ADMIN.SET_PARAMETER( 'SERVICE_ADMIN_PASSWORD_ONE_PUNCTUATION', 'N' );
    COMMIT;
end;
/

PROMPT APEX password policy configuration complete

Rem from dbtools_apxchpwd.sql

col user_id       noprint new_value M_USER_ID
col email_address noprint new_value M_EMAIL_ADDRESS
set termout off
select rtrim(min(user_id))       user_id,
       nvl (
           rtrim(min(email_address)),
           'ADMIN' )        email_address
  from wwv_flow_fnd_user
 where security_group_id = 10
   and user_name         = upper('ADMIN')
/

declare
    c_user_id  constant number         := to_number( '^M_USER_ID.' );
    c_username constant varchar2(4000) := 'ADMIN';
    c_email    constant varchar2(4000) := 'admin@example.com';
    c_password constant varchar2(4000) := trim('^OPC_PASSWORD.');
    c_old_sgid constant number := wwv_flow_security.g_security_group_id;
    c_old_user constant varchar2(255) := wwv_flow_security.g_user;

    procedure cleanup
    is
    begin
        wwv_flow_security.g_security_group_id := c_old_sgid;
        wwv_flow_security.g_user              := c_old_user;
    end cleanup;
begin
    if c_password is null then
        -- APEX upgrade, don't reset password policies
        return;
    end if;

    wwv_flow_security.g_security_group_id := 10;
    wwv_flow_security.g_user              := c_username;

    wwv_flow_fnd_user_int.create_or_update_user( p_user_id  => c_user_id,
                                                 p_username => c_username,
                                                 p_email    => c_email,
                                                 p_password => c_password );
    commit;
    cleanup();
exception
    when others then
        cleanup();
        raise;
end;
/

Rem from dbtools_apex_access_list_config.sql

DECLARE
    ACL_PATH  VARCHAR2(4000);
    APEX_USER VARCHAR2(200);
BEGIN
    BEGIN
        SELECT
            SCHEMA
        INTO
            APEX_USER
        FROM
            DBA_REGISTRY
        WHERE
            COMP_ID = 'APEX';
    EXCEPTION
        WHEN NO_DATA_FOUND THEN
            APEX_USER := NULL;
    END;

    IF APEX_USER IS NOT NULL THEN
        -- Look for the ACL currently assigned to '*' and give the APEX user "connect" privilege if it does not have the privilege yet
        SELECT
            ACL
        INTO
            ACL_PATH
        FROM
            DBA_NETWORK_ACLS
        WHERE
            HOST = '*' AND
            LOWER_PORT IS NULL AND
            UPPER_PORT IS NULL;

        IF DBMS_NETWORK_ACL_ADMIN.CHECK_PRIVILEGE(
            ACL_PATH,
            APEX_USER,
            'connect'
        ) IS NULL THEN
            DBMS_NETWORK_ACL_ADMIN.ADD_PRIVILEGE(
                ACL_PATH,
                APEX_USER,
                TRUE,
                'connect'
            );
        END IF;
    END IF;
EXCEPTION
    -- When no ACL has been assigned to '*'.
    WHEN NO_DATA_FOUND THEN
        DBMS_NETWORK_ACL_ADMIN.CREATE_ACL(
            'power_users.xml',
            'ACL that lets power users to connect to everywhere',
            APEX_USER,
            TRUE,
            'connect'
        );
        DBMS_NETWORK_ACL_ADMIN.ASSIGN_ACL('power_users.xml', '*');
END;
/
COMMIT;

Rem from dbtools_apex_rest_config_cdb.sql
@^PREFIX.apex_rest_config_core.sql "^PREFIX." "^OPC_PASSWORD." "^OPC_PASSWORD."

set define '^'

prompt
prompt ...Recompiling the Oracle APEX schemas
prompt
begin
    sys.dbms_utility.compile_schema( schema => wwv_flow.g_flow_schema_owner, compile_all => false );
    sys.dbms_utility.compile_schema( schema => 'FLOWS_FILES', compile_all => false );
end;
/

Rem from dbtools_reset_image_prefix_con.sql
@^PREFIX.utilities/reset_image_prefix_core.sql ^IMGPRE x

Rem Apply Languages
prompt
prompt ...Applying languages
prompt
set define '^'

@^PREFIX.builder/ar/load_ar.sql
@^PREFIX.builder/cs/load_cs.sql
@^PREFIX.builder/da/load_da.sql
@^PREFIX.builder/de/load_de.sql
@^PREFIX.builder/el/load_el.sql
@^PREFIX.builder/es/load_es.sql
@^PREFIX.builder/fi/load_fi.sql
@^PREFIX.builder/fr/load_fr.sql
@^PREFIX.builder/fr-ca/load_fr-ca.sql
@^PREFIX.builder/he/load_he.sql
@^PREFIX.builder/hr/load_hr.sql
@^PREFIX.builder/hu/load_hu.sql
@^PREFIX.builder/it/load_it.sql
@^PREFIX.builder/ja/load_ja.sql
@^PREFIX.builder/ko/load_ko.sql
@^PREFIX.builder/nl/load_nl.sql
@^PREFIX.builder/no/load_no.sql
@^PREFIX.builder/pl/load_pl.sql
@^PREFIX.builder/pt/load_pt.sql
@^PREFIX.builder/pt-br/load_pt-br.sql
@^PREFIX.builder/ro/load_ro.sql
@^PREFIX.builder/ru/load_ru.sql
@^PREFIX.builder/sk/load_sk.sql
@^PREFIX.builder/sl/load_sl.sql
@^PREFIX.builder/sr/load_sr.sql
@^PREFIX.builder/sr-latn/load_sr-latn.sql
@^PREFIX.builder/sv/load_sv.sql
@^PREFIX.builder/th/load_th.sql
@^PREFIX.builder/tr/load_tr.sql
@^PREFIX.builder/zh-cn/load_zh-cn.sql
@^PREFIX.builder/zh-tw/load_zh-tw.sql

prompt
prompt ...Applying languages Completed
prompt
