set define '^' verify off
prompt ...wwv_util_APEX_220100
create or replace package sys.wwv_util_APEX_220100 as
--------------------------------------------------------------------------------
--
--  Copyright (c) Oracle Corporation 1999 - 2020. All Rights Reserved.
--
--    NAME
--      wwv_util_apex.sql
--
--    DESCRIPTION
--      This package is run during installation and creates a package in the
--      SYS schema named wwv_util_APEX_200200. It is used to create another package in SYS 
--      WWV_FLOW_VAL. It also contains a procedure to adjust the start_date of the APEX 
--      upgrade job on ADB.
--
--
--    MODIFIED   (MM/DD/YYYY)
--     jstraub    02/20/2020 - Created
--
--------------------------------------------------------------------------------
procedure create_key_package (
--    PARAMETERS
--      * p_overwrite_key: If true, always overwrite an existing key. If null,
--                         keep an old key unless it's version is too old.
    p_overwrite_key in boolean default null );
--
--
procedure adb_upgrade_now( 
	p_start_date in timestamp with time zone default systimestamp );

end wwv_util_APEX_220100;
/
show errors
