set define '^' verify off
prompt ...wwv_flow_wf_management.sql
create or replace package wwv_flow_wf_management is
--------------------------------------------------------------------------------
--
--  Copyright (c) 2022, Oracle and/or its affiliates.
--
--    NAME
--      wwv_flow_wf_management.sql
--
--    DESCRIPTION
--      Oracle APEX Workflow Component.
--
--    MODIFIED   (MM/DD/YYYY)
--      anachatt   01/25/2022 - Created
--
--------------------------------------------------------------------------------

--==============================================================================
-- Purges tasks.
-- 
-- A task is purged when
-- a) the state is "Cancelled" or "Errored"
-- b) the state is "closed" and the configured retention time has passed.
--
-- the retention time is specified as the TASK_RETENTION_PERIOD_DAYS instance parameter.
--
-- The procedure is called once per day and executes the following steps.
--
-- 1. identify all workspaces with tasks
-- 2. for each of these workspaces:
--    a) determine the tasks to purge
--    b) generate a JSON backup document containing task details
--    c) store the JSON document as a workspace static file
--    d) purge tasks
--    c) send out an information email to the APEX instance administrator
--
--==============================================================================
procedure purge_tasks;    

end wwv_flow_wf_management;
/
show err
