set define '^'
set verify off
prompt ...wwv_flow_theme_manager spec
create or replace package wwv_flow_theme_manager is

--------------------------------------------------------------------------------
--
--  Copyright (c) Oracle Corporation 2012 - 2021. All Rights Reserved.
--
--    NAME
--      wwv_flow_theme_manager.sql
--
--    DESCRIPTION
--      This package is responsible for managing theme switching
--
--    MODIFIED   (MM/DD/YYYY)
--      skutz     06/10/2004 - created
--
--------------------------------------------------------------------------------

    empty_vc_arr wwv_flow_global.vc_arr2;

    function get_preset_template_options (
        p_template_id    number,
        p_template_type  varchar2 )
        return varchar2;
    
    procedure create_new_public_theme (
       p_workspace_id    in number,
       p_app_id          in number,
       p_app_theme_id    in number,
       p_theme_name      in varchar2,
       p_theme_number    in number,
       p_theme_desc      in varchar2 default null,
       p_subscribe_theme in varchar2 default 'N');
    
    function get_theme_image_icon (
       p_theme_id               in number,
       p_application_id         in number)
       return varchar2;
    
    procedure add_theme_to_application (
        p_application_id         in number,
        p_theme_id               in number);
    
    procedure delete_workspace_theme (
        p_id              in number);
        
    procedure delete_public_theme (
        p_id              in number);
    
    procedure change_workspace_theme (
        p_id              in number,
        p_theme_name      in varchar2,
        p_theme_number    in number,
        p_theme_desc      in varchar2 default null);
        
    procedure change_public_theme (
        p_id              in number,
        p_theme_name      in varchar2,
        p_theme_number    in number,
        p_theme_desc      in varchar2 default null);
    
    procedure create_new_workspace_theme (
        p_app_id          in number,
        p_app_theme_id    in number,
        p_theme_name      in varchar2,
        p_theme_number    in number,
        p_theme_desc      in varchar2 default null,
        p_subscribe_theme in varchar2 default 'N');
    
    function count_consolidation (
        p_application_id       in number,
        p_consolidate_from     in number default 0,
        p_consolidate_to       in number default 0,
        p_template_type        in varchar2 default null)
        return number;

    procedure consolidate_templates (
        p_application_id       in number,
        p_consolidate_from     in number default 0,
        p_consolidate_to       in number default 0,
        p_template_type        in varchar2 default null);

    function is_navigation_upgrade (
        p_flow_id    in number,
        p_from_theme in number,
        p_to_theme   in number 
    ) return boolean;
    
    function is_theme_switch_allowed (
        p_flow_id    in number,
        p_from_theme in number,
        p_to_theme   in number     
    ) return varchar2;
    
    procedure switch_theme (
        p_flow_id    in number,
        p_from_theme in number,
        p_to_theme   in number );

    procedure delete_theme(p_flow_id in number, p_theme_id in number, p_import in varchar2 default 'N');

    procedure renumber_theme(p_flow_id in number, p_to_theme in number, p_from_theme in number);

    procedure copy_theme(
        p_from_flow_id    in number, 
        p_to_flow_id      in number, 
        p_from_theme      in number, 
        p_to_theme        in number, 
        p_theme_style_id  in number default null,
        p_subscribe_theme in boolean default false
    );

    procedure set_globals (
        p_flow_id           in number,
        p_to_theme          in number default null,
        p_user_interface_id in number default null );

    function get_new_theme_id(p_flow_id in number) return number;
    function get_button_postion(p_template_id in number, p_position in varchar2) return varchar2;
    function get_page_util(p_flow_id in number, p_id in number) return varchar2;
    function get_region_util(p_flow_id in number, p_id in number) return varchar2;
    function get_report_util(p_flow_id in number, p_id in number) return varchar2;
    function get_list_util(p_flow_id in number, p_id in number) return varchar2;
    function get_field_util(p_flow_id in number, p_id in number) return varchar2;
    function get_button_util(p_flow_id in number, p_id in number) return varchar2;
    function get_menu_util(p_flow_id in number, p_id in number) return varchar2;
    function get_cal_util(p_flow_id in number, p_id in number) return varchar2;

    procedure f4000_process_theme_image (
        p_id           in number   default null,
        p_THEME_IMAGE  in varchar2 default null,
        P_CUSTOM_IMAGE in varchar2 default null)
        ;

procedure find_template_files (
    p_flow_id              in number,
    p_theme                in number   default null,
    p_show_templates       in varchar2 default 'N',
    p_show_page_components in varchar2 default 'N',
    p_show_components      in varchar2 default 'N',
    p_show_gif             in varchar2 default 'N',
    p_show_jpg             in varchar2 default 'N',
    p_show_png             in varchar2 default 'N',
    p_show_css             in varchar2 default 'N',
    p_show_js              in varchar2 default 'N',
    p_show_swf             in varchar2 default 'N',
    p_show_ico             in varchar2 default 'N'
    )	
    ;

procedure find_css_classes (
    p_flow_id              in number,
    p_theme                in number   default null,
    p_show_templates       in varchar2 default 'N',
    p_show_page_components in varchar2 default 'N',
    p_show_components      in varchar2 default 'N')
    ;

procedure find_substitution_strings (
    p_flow_id              in number,
    p_theme                in number   default null)
    ;
    
procedure find_object_dependencies (
   p_flow_id      in number,
   p_page_id      in number default null)
   ;
   
function get_theme_image_name (
   p_id           in number)
   return         varchar2
   ;

end;
/
show errors;
