set define '^' verify off
prompt ...wwv_flow_pwa.sql
create or replace package wwv_flow_pwa as
--------------------------------------------------------------------------------
--
--  Copyright (c) 2021, 2022, Oracle and/or its affiliates.
--
--    NAME
--      wwv_flow_pwa.sql
--
--    DESCRIPTION
--      This package is used to emit content to the page 
--      for applications that have enabled Progressive Web App
--      such as:
--      * Web App Manifest in the head section of a page
--      * Meta tags in the head section of a page
--      * Service worker registration
--      * Web App Manifest file rendering (JSON)
--      * Service Worker file rendering (JavaScript)
--
--    Since: 21.2
--
--    MODIFIED   (MM/DD/YYYY)
--    vmorneau   04/28/2121 - Created
--
--------------------------------------------------------------------------------

--==============================================================================
-- Globals
--==============================================================================
g_is_pwa                   boolean := false;
g_is_installable           boolean := false;
g_manifest_description     wwv_flows.pwa_manifest_description%type;
g_manifest_display         wwv_flows.pwa_manifest_display%type;
g_manifest_orientation     wwv_flows.pwa_manifest_orientation%type;
g_manifest_theme_color     wwv_flows.pwa_manifest_theme_color%type;
g_manifest_bg_color        wwv_flows.pwa_manifest_background_color%type;
g_manifest_icon_url        wwv_flows.pwa_manifest_icon_url%type;
g_manifest_custom          wwv_flows.pwa_manifest_custom%type;
g_service_worker_hooks     wwv_flows.pwa_service_worker_hooks%type;
g_apple_status_bar_style   wwv_flows.pwa_apple_status_bar_style%type;

--==============================================================================
-- Constants
--==============================================================================
c_file_reference               constant varchar2(14) := 'FILE_REFERENCE';
c_funct_variable_declaration   constant varchar2(29) := 'FUNCTION_VARIABLE_DECLARATION';
c_event_install                constant varchar2(13) := 'EVENT_INSTALL';
c_event_install_before         constant varchar2(20) := 'EVENT_INSTALL_BEFORE';
c_event_install_after          constant varchar2(19) := 'EVENT_INSTALL_AFTER';
c_event_activate               constant varchar2(14) := 'EVENT_ACTIVATE';
c_event_activate_before        constant varchar2(21) := 'EVENT_ACTIVATE_BEFORE';
c_event_activate_after         constant varchar2(20) := 'EVENT_ACTIVATE_AFTER';
c_event_fetch                  constant varchar2(11) := 'EVENT_FETCH';
c_event_fetch_before           constant varchar2(18) := 'EVENT_FETCH_BEFORE';
c_event_fetch_cache_definition constant varchar2(28) := 'EVENT_FETCH_CACHE_DEFINITION';
c_event_fetch_cache_response   constant varchar2(26) := 'EVENT_FETCH_CACHE_RESPONSE';
c_event_fetch_network_resp_suc constant varchar2(28) := 'EVENT_FETCH_NETWORK_RESP_SUC';
c_event_fetch_network_resp_err constant varchar2(28) := 'EVENT_FETCH_NETWORK_RESP_ERR';
c_event_fetch_offline_page     constant varchar2(24) := 'EVENT_FETCH_OFFLINE_PAGE';
c_event_fetch_network_fallback constant varchar2(28) := 'EVENT_FETCH_NETWORK_FALLBACK';
c_event_sync                   constant varchar2(10) := 'EVENT_SYNC';
c_event_push                   constant varchar2(10) := 'EVENT_PUSH';
c_event_notificationclick      constant varchar2(23) := 'EVENT_NOTIFICATIONCLICK';
c_event_notificationclose      constant varchar2(23) := 'EVENT_NOTIFICATIONCLOSE';
c_event_canmakepayment         constant varchar2(20) := 'EVENT_CANMAKEPAYMENT';
c_event_paymentrequest         constant varchar2(20) := 'EVENT_PAYMENTREQUEST';

--==============================================================================
-- Internal:
--
-- This procedure is used to emit the Web App Manifest for an APEX app
--
-- The Web App Manifest is responsible for holding the definition on the
-- application that will be installed on devices (mobile and desktop).
--
-- The APEX engine will generate a Web App Manifest file will be based on 
-- declarative options in the application properties.
-- 
-- At runtime, the Web App Manifest will be included in the <head> section of the page.
-- 
-- In addition to those APEX declarative options, developers will be able to 
-- enter a custom manifest textarea, with additional JSON data. If a property
-- in custom manifest exists in the declarative options, that property 
-- takes precedence (overrides) over the declarative option
-- 
-- In the end the final Web App Manifest file will consist of
-- * Some default values defined in APEX (home URL, app name, etc.)
-- * Declarative options
-- * Custom options from pwa_manifest_custom
--==============================================================================
procedure emit_manifest;

--==============================================================================
-- Internal:
--
-- This procedure is used to emit the Service Worker for an APEX app
-- 
-- Service workers are JavaScript files that can execute code even when the app is not in use.
-- It can listen to events like fetching resources or handling notifications.

-- By default, the APEX engine generates the service worker with the following strategy:
-- * Install and activate the service worker
-- * Serve ressources from cache if cache exists
-- * Otherwise serve from network, then put ressource in cache
-- * Serve an offline page if network fails

-- The default service worker can be modified through hooks or by replacing events completely.
--==============================================================================
procedure emit_service_worker;

--==============================================================================
-- Internal:
--
-- This procedure is used to emit the Service Worker Hooks for an APEX app
-- 
-- Service Worker Hooks are used to customize the functionality of service worker events.
-- There are two ways of defining hooks:
-- 1. Hooking into existing events (keeping APEX functionnality)
-- 2. Overwriting existing events
--==============================================================================
procedure emit_service_worker_hooks;

--==============================================================================
-- Internal:
--
-- This procedure is used to emit the Service Worker 
-- registration JavaScript on an APEX page rendering
--==============================================================================
procedure emit_register_service_worker;

--==============================================================================
-- Internal:
--
-- This procedure is used to emit <head> HTML tags that are useful
-- for a Progressive Web App on an APEX page rendering
--==============================================================================
procedure emit_header;

end wwv_flow_pwa;
/
show errors
