set define '^'
set verify off
prompt ...wwv_flow_print_util.sql

create or replace package wwv_flow_print_util
as
--------------------------------------------------------------------------------
--
--  Copyright (c) Oracle Corporation 2006 - 2022. All Rights Reserved.
--
--    NAME
--      wwv_flow_print_util.sql
--
--    DESCRIPTION
--      Engine for Oracle APEX integration with high fidelity printing
--
--    NOTES
--
--    SCRIPT ARGUMENTS
--      None
--
--    MODIFIED    (MM/DD/YYYY)
--      jstraub    11/27/2006 - Created
--

subtype t_alignment is varchar2(6);

type t_column is record (
    name              varchar2(255),
    label             varchar2(255),
    heading_alignment t_alignment,
    value_alignment   t_alignment,
    width             number );

type t_columns is table of t_column index by pls_integer;

type t_print_attributes is record (
    format                      wwv_flow_page_plugs.prn_format%type,
    format_item                 wwv_flow_page_plugs.prn_format_item%type,
    template_id                 wwv_flow_page_plugs.prn_template_id%type,
    output_link_text            wwv_flow_page_plugs.prn_output_link_text%type,
    file_name                   wwv_flow_page_plugs.prn_output_file_name%type,
    content_disposition         wwv_flow_page_plugs.prn_content_disposition%type,
    config                      wwv_flow_data_export_api.t_print_config );

type t_template is record (
    main            clob,
    table_cell      varchar2(32767),
    header_col      varchar2(32767),
    body_col        varchar2(32767) );

type t_report_layout is record (
    is_generic      boolean,
    layout_type     varchar2(10),
    template        t_template,
    escape_url      boolean );

type t_print_server is record (
    server_type             varchar2(30),
    remote_server_id        wwv_remote_servers.id%type,
    credential_id           wwv_credentials.id%type );

function convert (
    p_flow_id        in number default wwv_flow_security.g_flow_id,
    p_report_data    in blob,
    p_template       in clob,
    p_template_type  in varchar2,
    p_output         in varchar2,
    p_print_server   in varchar2    default null  )
    return blob;

--==============================================================================
-- Gets the substituted generic template
--==============================================================================
function fill_generic_template(
    p_report_layout     in t_report_layout,
    p_print_attributes  in t_print_attributes,
    p_columns           in t_columns,
    p_supplemental_text in varchar2             default null )
    return clob;

--==============================================================================
-- The function gets the region attributes that are used for report printing
--==============================================================================
function get_print_attributes (
    p_region_id in number )
    return t_print_attributes;

--==============================================================================
-- Return the report layout metadata
-- if p_id is null, return the default report layout with generic columns
--==============================================================================
function get_report_layout (
    p_print_server  in t_print_server,
    p_id            in wwv_flow_report_layouts.id%type  default null )
    return t_report_layout;

--==============================================================================
-- Converts the specified size from the print attribute units to pt (points)
--==============================================================================
function units_size_to_pt (
    p_units     wwv_flow_page_plugs.prn_units%type,
    p_size      number )
    return number;

--==============================================================================
-- The function gets the print server config based on Application / Instance settings
--==============================================================================
function get_print_server (
    p_flow_id   in number default wwv_flow_security.g_flow_id ) return t_print_server;

--==============================================================================
-- Returns the internal format based on a document format specified by a developer
--==============================================================================
function to_print_format (
    p_document_format in varchar2 )
    return varchar2;

end wwv_flow_print_util;
/

show errors