set define '^' verify off
prompt ...wwv_flow_map_region.sql
create or replace package wwv_flow_map_region as
--------------------------------------------------------------------------------
--
--  Copyright (c) 2020, 2022, Oracle and/or its affiliates.
--
--  Implementation package for the map region.
--
--  Since: 21.1
--
--------------------------------------------------------------------------------
--
--    MODIFIED   (MM/DD/YYYY)
--    cczarski    09/21/2020 - Created
-- 
--------------------------------------------------------------------------------

--==============================================================================
-- Global types 
--==============================================================================

--==============================================================================
-- Constants
--==============================================================================

subtype t_map_layer_type    is pls_integer range 1..5;

c_map_layer_points             constant t_map_layer_type          := 1;
c_map_layer_lines              constant t_map_layer_type          := 2;
c_map_layer_polygons           constant t_map_layer_type          := 3;
c_map_layer_3d_polygons        constant t_map_layer_type          := 4;
c_map_layer_heat_map           constant t_map_layer_type          := 5;

subtype t_feature_data_type is pls_integer range 1..3;

c_feature_sdo_geometry         constant t_feature_data_type       := 1;
c_feature_geojson              constant t_feature_data_type       := 2;
c_feature_number_columns       constant t_feature_data_type       := 3;

--==============================================================================
-- Globals
--==============================================================================

--
--==============================================================================
-- Renders a Map Region.
--==============================================================================
function render (
    p_plugin              in wwv_flow_plugin_api.t_plugin,
    p_region              in wwv_flow_plugin_api.t_region,
    p_plug                in wwv_flow_meta_data.t_plug,
    p_is_printer_friendly in boolean )
    return wwv_flow_plugin_api.t_region_render_result;
--
--==============================================================================
-- Ajax callback for a Map Region.
--==============================================================================
function ajax (
    p_plugin               in wwv_flow_plugin_api.t_plugin,
    p_region               in wwv_flow_plugin_api.t_region,
    p_json_path            in varchar2 )
    return wwv_flow_plugin_api.t_region_ajax_result;

end wwv_flow_map_region;
/
show err

set define '^'
