set define '^' verify off
prompt wwv_flow_mail_dev
create or replace package wwv_flow_mail_dev as
--------------------------------------------------------------------------------
--
-- Copyright (c) Oracle Corporation 2021. All Rights Reserved.
--
-- The wwv_flow_mail_dev package provides functions for email templates
--
--------------------------------------------------------------------------------

--==============================================================================
-- The COPY_EMAIL_TEMPLATE function copies an existing email template to a new email template.
--
-- Parameters:
-- * p_id:                ID of existing email template which should get copied
-- * p_to_name:           Name of the new copied email template
-- * p_to_static_id:      Static id of the new copied email template
-- * p_to_application_id: Application ID to copy the email template to. By default
--                        the email template is copied within the same application
--
-- Returns:
-- Returns ID of the created email template.
--==============================================================================
function copy_email_template (
    p_id                  in number,
    p_to_name             in varchar2,
    p_to_static_id        in varchar2,
    p_to_application_id   in number default null )
    return number;
end wwv_flow_mail_dev;
/
show errors

set define '^'