set define '^' verify off
prompt ...wwv_flow_lov_dev
create or replace package wwv_flow_lov_dev as
--------------------------------------------------------------------------------
--
--  Copyright (c) Oracle Corporation 2009 - 2019. All Rights Reserved.
--
--    NAME
--      wwv_flow_lov_dev.sql
--
--    DESCRIPTION
--      This package is responsible for handling functionality related to List of Values in the builder.
--
--    MODIFIED   (MM/DD/YYYY)
--    arayner     04/03/2019 - Created
--
--------------------------------------------------------------------------------

--==============================================================================
-- Global types
--==============================================================================


--==============================================================================
-- Global constants
--==============================================================================


--==============================================================================
-- Global variables
--==============================================================================


--==============================================================================
-- Updates LOV column collection information based on columns selected in shuttle
-- (used on main LOV edit page 4111)
--==============================================================================
procedure update_column_collection(
    p_collection_name        in varchar2,
    p_new_columns            in varchar2,
    p_location               in varchar2,
    p_source_type            in varchar2     default null,
    p_owner                  in varchar2     default null,
    p_table_name             in varchar2     default null,
    p_sql_query              in varchar2     default null,
    p_function_body          in varchar2     default null,
    p_function_body_language in varchar2     default null,
    p_remote_server_id       in number       default null,
    p_web_src_module_id      in number       default null,
    p_where_clause           in varchar2     default null,
    p_post_processing_type   in varchar2     default null,
    p_return_column          in varchar2 );
--
--
--==============================================================================
-- Converts legacy LOVs into the metadata-based
--==============================================================================
procedure convert_legacy_lov(
    p_lov_id                in number,
    p_application_id        in number       default nv('FB_FLOW_ID') );
--
--
--==============================================================================
-- Save column data from collection (used on main LOV edit page 4111)
--==============================================================================
procedure save_column_info_from_coll(
    p_collection_name       in varchar2,
    p_lov_id                in number, 
    p_application_id        in number       default nv('FB_FLOW_ID'));
--
--
--==============================================================================
-- Create a collection containing LOV column information (Used on main LOV edit 
-- page 4111)
--==============================================================================
procedure create_coll_from_lov_columns(
    p_collection_name       in varchar2,
    p_lov_id                in number, 
    p_application_id        in number       default nv('FB_FLOW_ID'));
--
--
--==============================================================================
-- Gets correct table owner for LOVs based on Local data sources, nulling
-- it in the case where it matches the applications primary schema
--==============================================================================
function get_table_owner(
    p_owner                 in varchar2,
    p_application_id        in number       default nv('FB_FLOW_ID') )
    return varchar2;
--
--
--==============================================================================
-- synchronize the Web Source Parameters for the given Shared LOV
--==============================================================================
procedure synchronize_web_src_parameters(
    p_application_id        in number       default nv('FB_FLOW_ID'),
    p_web_src_module_id     in number,
    p_shared_lov_id         in number,
    p_use_local_table       in boolean );
--
--
--==============================================================================
-- Create an LOV based on a data source (used in create wizard)
--==============================================================================
procedure create_dynamic_lov(
    p_lov_name               in varchar2,
    p_location               in varchar2,
    p_source_type            in varchar2     default null, 
    p_owner                  in varchar2     default null,
    p_table_name             in varchar2     default null,
    p_sql_query              in varchar2     default null,
    p_function_body_language in wwv_flow_code_exec.t_language default null,
    p_web_src_module_id      in number       default null,
    p_remote_server_id       in number       default null,
    p_application_id         in number       default nv('FB_FLOW_ID'),
    p_return_column          in varchar2,
    p_display_column         in varchar2 );
--
--
--==============================================================================
-- Create an LOV from a 2 column query
--==============================================================================
procedure create_lov_from_query(
    p_id                    in number   default null,
    p_flow_id               in number,
    p_name                  in varchar2,
    p_query                 in varchar2,
    p_parse_as_schema       in varchar2 default null );
--
--
--==============================================================================
-- Used in the builder for LOV conversion
--==============================================================================
procedure create_named_lov (
    p_id                    in out number,
    p_flow_id               in     number,
    p_name                  in     varchar2,
    p_query                 in     varchar2 );
--
--
--==============================================================================
-- For LOVs based on web sources, this function gets a formatted SQL query
-- used to pre-populate the Post Processing attributes
--==============================================================================
function get_post_processing_sql_query( 
    p_location               in varchar2,
    p_query_type             in varchar2,
    p_owner                  in varchar2     default null,
    p_table_name             in varchar2     default null,
    p_sql_query              in varchar2     default null,
    p_function_body          in varchar2     default null,
    p_function_body_language in wwv_flow_code_exec.t_language default null,
    p_remote_server_id       in number       default null,
    p_web_src_module_id      in number       default null ) 
    return varchar2;
--
--
--==============================================================================
-- Copy an LOV
--==============================================================================
procedure copy_named_lov (
    p_lov_id_from           in number,
    p_lov_name_to           in varchar2,
    p_copy_from_flow_id     in number       default null,
    p_flow_id               in number       default null,
    p_lov_id_to             in number       default null );
--
--
--==============================================================================
-- Return a string containing a comma seperated list of pages where an LOV is 
-- used.
--==============================================================================
function lov_used_on_pages ( 
    p_lov_id                in number,
    p_flow_id               in number       default nv('FB_FLOW_ID') ) 
    return varchar2;
--
--
end wwv_flow_lov_dev;
/
show errors
