set define '^' verify off
prompt ...wwv_flow_imp_page.sql
create or replace package wwv_flow_imp_page as
--------------------------------------------------------------------------------
--
--  Copyright (c) 1999, 2022, Oracle and/or its affiliates.
--
--    NAME
--      wwv_flow_imp_page.sql
--
--    DESCRIPTION
--     Interface to create APEX page components.
--
--    MODIFIED (MM/DD/YYYY)
--     cczarski 09/07/2021 - Created
--
-----------------------------------------------------------------------------------------------------------------------

--==============================================================================
-- Constants
--==============================================================================
c_y                           constant varchar2(1 CHAR) := 'Y';
c_n                           constant varchar2(1 CHAR) := 'N';

--==============================================================================
--
-- I N T E R N A L   U T I L I T I E S
--
--==============================================================================
procedure set_calling_version(
    p_version in number );

--==============================================================================
function current_page_id      return number;
function current_region_id    return number;
function current_worksheet_id return number;

--==============================================================================
procedure parse_file_source (
    p_source                          in varchar2,
    p_db_column                      out varchar2,
    p_mimetype_column                out varchar2,
    p_filename_column                out varchar2,
    p_last_updated_col               out varchar2,
    p_charset_column                 out varchar2,
    p_content_disposition            out varchar2,
    p_download_link_text             out varchar2 );

--==============================================================================
--
-- P R E S E R V E   I G   A N D   I R    R E P O R T
--
--==============================================================================
procedure clear_ig_globals;

--==============================================================================
procedure load_igs(
    p_application_id in number,
    p_page_id        in number default null );

--==============================================================================
procedure recreate_ig_rpt(
    p_application_id in number );

--==============================================================================
procedure load_irs (
    p_application_id in number);

--==============================================================================
procedure relink_ir (
    p_app_id     in number);

--==============================================================================
--
-- P A G E
--
--==============================================================================
procedure create_page (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_user_interface_id               in number   default null,
    p_tab_set                         in varchar2 default null,
    p_name                            in varchar2 default null,
    p_alias                           in varchar2 default null,
    p_page_mode                       in varchar2 default 'NORMAL',
    p_step_title                      in varchar2 default null,
    p_step_sub_title                  in varchar2 default null,
    p_step_sub_title_type             in varchar2 default null,
    p_media_type                      in varchar2 default null,
    p_first_item                      in varchar2 default 'NO_FIRST_ITEM',
    p_include_apex_css_js_yn          in varchar2 default c_y,
    p_render_form_as_table            in varchar2 default null,
    p_welcome_text                    in varchar2 default null,
    p_box_welcome_text                in varchar2 default null,
    p_box_footer_text                 in varchar2 default null,
    p_footer_text                     in varchar2 default null,
    p_help_text                       in varchar2 default null,
    p_step_template                   in number   default null,
    p_page_css_classes                in varchar2 default null,
    p_page_template_options           in varchar2 default null,
    p_box_image                       in varchar2 default null,
    p_required_role                   in varchar2 default null,
    p_required_patch                  in number   default null,
    p_allow_duplicate_submissions     in varchar2 default c_y,
    p_on_dup_submission_goto_url      in varchar2 default null,
    p_reload_on_submit                in varchar2 default 'S',
    p_warn_on_unsaved_changes         in varchar2 default c_y,
    p_html_page_header                in varchar2 default null,
    p_html_page_onload                in varchar2 default null,
    p_javascript_file_urls            in varchar2 default null,
    p_javascript_code                 in varchar2 default null,
    p_javascript_code_onload          in varchar2 default null,
    p_css_file_urls                   in varchar2 default null,
    p_inline_css                      in varchar2 default null,
    p_page_is_protected_y_n           in varchar2 default null,
    p_page_is_public_y_n              in varchar2 default c_n,
    p_protection_level                in varchar2 default c_n,
    p_error_handling_function         in varchar2 default null,
    p_error_notification_text         in varchar2 default null,
    p_page_comment                    in varchar2 default null,
    --
    p_dialog_title                    in varchar2 default null,
    p_dialog_height                   in varchar2 default null,
    p_dialog_width                    in varchar2 default null,
    p_dialog_max_width                in varchar2 default null,
    p_dialog_attributes               in varchar2 default null,
    p_dialog_css_classes              in varchar2 default null,
    p_dialog_chained                  in varchar2 default c_y,
    --
    p_overwrite_navigation_list       in varchar2 default c_n,
    p_navigation_list_position        in varchar2 default null,
    p_navigation_list_id              in number   default null,
    p_navigation_list_template_id     in number   default null,
    p_nav_list_template_options       in varchar2 default null,
    --
    p_tab_name                        in varchar2 default null,  -- current tab name
    --
    p_auto_tab_set                    in varchar2 default null,
    p_auto_tab_text                   in varchar2 default null,
    p_auto_parent_tab_set             in varchar2 default null,
    p_auto_parent_tab_text            in varchar2 default null,
    --
    p_autocomplete_on_off             in varchar2 default null,
    p_page_transition                 in varchar2 default null,
    p_popup_transition                in varchar2 default null,
    --
    p_browser_cache                   in varchar2 default null,
    p_deep_linking                    in varchar2 default null,
    p_rejoin_existing_sessions        in varchar2 default null,
    --
    p_read_only_when_type             in varchar2 default null,
    p_read_only_when                  in varchar2 default null,
    p_read_only_when2                 in varchar2 default null,
    --
    p_cache_mode                      in varchar2 default null,-- 5.0 replacement for p_cache_page_yn and p_cache_by_user_yn
    p_cache_page_yn                   in varchar2 default c_n, -- pre 5.0
    p_cache_timeout_seconds           in number   default null,
    p_cache_by_user_yn                in varchar2 default null,-- pre 5.0
    p_cache_when_condition_type       in varchar2 default null,
    p_cache_when_condition_e1         in varchar2 default null,
    p_cache_when_condition_e2         in varchar2 default null,
    --
    p_group_id                        in number   default null,
    --
    p_page_component_map              in varchar2 default null,
    --
    p_last_updated_by                 in varchar2 default null,
    p_last_upd_yyyymmddhh24miss       in varchar2 default null,
    --
    p_created_by                      in varchar2 default null,
    p_created_on_yyyymmddhh24miss     in varchar2 default null );

--==============================================================================
procedure create_page_group (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_group_name                      in varchar2 default null,
    p_group_desc                      in varchar2 default null );

--==============================================================================
procedure create_page_help (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_help_text                       in varchar2 default null );

--==============================================================================
procedure update_page (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_tab_set                         in varchar2 default null,
    p_name                            in varchar2 default null,
    p_step_title                      in varchar2 default null,
    p_step_sub_title                  in varchar2 default null,
    p_step_sub_title_type             in varchar2 default null,
    p_welcome_text                    in varchar2 default null,
    p_box_welcome_text                in varchar2 default null,
    p_box_footer_text                 in varchar2 default null,
    p_footer_text                     in varchar2 default null,
    p_help_text                       in varchar2 default null,
    p_step_template                   in varchar2 default null,
    p_box_image                       in varchar2 default null,
    p_required_role                   in varchar2 default null,
    p_required_patch                  in number   default null,
    p_page_comment                    in varchar2 default null);

--==============================================================================
procedure remove_page (
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default null );

--==============================================================================
--
-- B U T T O N S
--
--==============================================================================
procedure create_page_button (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_flow_step_id                    in number   default current_page_id,
    p_button_sequence                 in number   default null,
    p_button_plug_id                  in number   default null,
    p_button_position                 in varchar2 default 'BODY',
    p_button_name                     in varchar2 default null,
    p_button_static_id                in varchar2 default null,
    p_button_template_id              in number   default null,
    p_button_template_options         in varchar2 default null,
    p_button_image                    in varchar2 default null,
    p_button_is_hot                   in varchar2 default c_n,
    p_button_image_alt                in varchar2 default null,
    p_button_alignment                in varchar2 default 'RIGHT',
    p_button_redirect_url             in varchar2 default null,
    p_button_action                   in varchar2 default null,
    p_button_execute_validations      in varchar2 default c_y,
    p_warn_on_unsaved_changes         in varchar2 default 'I',
    p_confirm_message                 in varchar2 default null,
    p_confirm_style                   in varchar2 default null,
    p_button_condition                in varchar2 default null,
    p_button_condition2               in varchar2 default null,
    p_button_condition_type           in varchar2 default null,
    p_button_image_attributes         in varchar2 default null,
    p_button_css_classes              in varchar2 default null,
    p_icon_css_classes                in varchar2 default null,
    p_button_cattributes              in varchar2 default null,
    p_request_source                  in varchar2 default null,
    p_request_source_type             in varchar2 default null,
    p_pre_element_text                in varchar2 default null,
    p_post_element_text               in varchar2 default null,
    p_grid_column_attributes          in varchar2 default null,
    p_grid_column_css_classes         in varchar2 default null,
    p_grid_new_grid                   in boolean  default false,
    p_grid_new_row                    in varchar2 default null,
    p_grid_row_css_classes            in varchar2 default null,
    p_grid_new_column                 in varchar2 default null,
    p_grid_column_span                in number   default null,
    p_grid_row_span                   in number   default null,
    p_grid_column                     in number   default null,
    p_security_scheme                 in varchar2 default null,
    p_required_patch                  in number   default null,
    p_button_comment                  in varchar2 default null,
    p_database_action                 in varchar2 default null ) ;

--==============================================================================
--
-- B R A N C H E S
--
--==============================================================================
procedure create_page_branch (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_flow_step_id                    in number   default current_page_id,
    p_branch_name                     in varchar2 default null,
    p_branch_action                   in varchar2 default null,
    p_branch_point                    in varchar2 default null,
    p_branch_type                     in varchar2 default null,
    p_branch_language                 in varchar2 default null,
    p_branch_when_button_id           in number   default null,
    p_branch_sequence                 in number   default null,
    p_branch_condition_type           in varchar2 default null,
    p_branch_condition                in varchar2 default null,
    p_branch_condition_text           in varchar2 default null,
    p_save_state_before_branch_yn     in varchar2 default c_n,
    p_security_scheme                 in varchar2 default null,
    p_required_patch                  in number   default null,
    p_branch_comment                  in varchar2 default null );

--==============================================================================
--
-- P A G E   I T E M S
--
--==============================================================================
procedure create_page_item_group(
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_flow_step_id                    in number   default current_page_id,
    p_page_plug_id                    in number,
    p_label                           in varchar2,
    p_display_sequence                in number,
    p_icon_css_classes                in varchar2 default null,
    p_css_classes                     in varchar2 default null,
    --
    p_suggestions_type                in varchar2 default null,
    p_suggestions_language            in varchar2 default null,
    p_suggestions_source              in varchar2 default null,
    p_max_suggestions                 in number   default null,
    --
    p_fc_filter_combination           in varchar2,
    p_fc_max_height                   in number   default null,
    p_fc_show_label                   in boolean  default null,
    p_fc_collapsible                  in boolean  default false,
    p_fc_initial_collapsed            in boolean  default null,
    --
    p_fc_compute_counts               in boolean  default true,
    p_fc_show_counts                  in boolean  default true,
    p_fc_zero_count_entries           in varchar2 default 'H',
    p_fc_show_selected_first          in boolean  default false,
    p_fc_sort_by_top_counts           in boolean  default false,
    p_fc_show_more_count              in number   default null,
    p_fc_show_chart                   in boolean  default null,
    p_fc_initial_chart                in boolean  default null,
    p_fc_toggleable                   in boolean  default false,
    p_fc_initial_toggled              in boolean  default null,
    --
    p_condition_expr1                 in varchar2 default null,
    p_condition_expr2                 in varchar2 default null,
    p_condition_type                  in varchar2 default null,
    --
    p_group_comment                   in varchar2 default null,
    --
    p_build_option_id                 in number   default null,
    p_authorization_scheme            in varchar2 default null );

--==============================================================================
procedure create_page_item (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_flow_step_id                    in number   default current_page_id,
    p_item_group_id                   in number   default null,
    p_name                            in varchar2 default null,
    p_name_length                     in number   default null,
    p_data_type                       in varchar2 default 'VARCHAR',
    p_source_data_type                in varchar2 default null,
    p_is_required                     in boolean  default false,
    p_is_primary_key                  in boolean  default false,
    p_is_query_only                   in boolean  default false,
    p_standard_validations            in varchar2 default null,
    p_accept_processing               in varchar2 default 'REPLACE_EXISTING',
    p_item_sequence                   in number   default null,
    p_item_plug_id                    in number   default null,
    p_item_display_point              in varchar2 default 'BODY',
    p_item_source_plug_id             in number   default null,
    p_use_cache_before_default        in varchar2 default 'YES',
    p_item_default                    in varchar2 default null,
    p_item_default_type               in varchar2 default 'STATIC_TEXT_WITH_SUBSTITUTIONS',
    p_item_default_language           in varchar2 default null,
    p_prompt                          in varchar2 default null,
    p_placeholder                     in varchar2 default null,
    p_pre_element_text                in varchar2 default null,
    p_post_element_text               in varchar2 default null,
    p_format_mask                     in varchar2 default null,
    p_source                          in varchar2 default null,
    p_source_type                     in varchar2 default 'ALWAYS_NULL',
    p_source_language                 in varchar2 default null,
    p_source_post_computation         in varchar2 default null,
    p_display_as                      in varchar2 default null,
    p_lov_language                    in varchar2 default null,
    p_named_lov                       in varchar2 default null,
    p_lov                             in varchar2 default null,
    p_lov_columns                     in number   default null, -- deprecated
    p_lov_display_extra               in varchar2 default null,
    p_lov_display_null                in varchar2 default 'NO',
    p_lov_null_text                   in varchar2 default null,
    p_lov_null_value                  in varchar2 default null,
    p_lov_translated                  in varchar2 default c_n,
    p_lov_cascade_parent_items        in varchar2 default null,
    p_lov_cascade_parent_column       in varchar2 default null,
    p_ajax_items_to_submit            in varchar2 default null,
    p_ajax_optimize_refresh           in varchar2 default null,
    p_cSize                           in number   default null,
    p_cMaxlength                      in number   default null,
    p_cHeight                         in number   default null,
    p_cAttributes                     in varchar2 default null,
    p_cAttributes_element             in varchar2 default null,
    p_tag_css_classes                 in varchar2 default null,
    p_icon_css_classes                in varchar2 default null,
    p_tag_attributes                  in varchar2 default null,
    p_tag_attributes2                 in varchar2 default null,
    p_new_grid                        in boolean  default false,
    p_begin_on_new_line               in varchar2 default c_y,
    p_grid_row_css_classes            in varchar2 default null,
    p_begin_on_new_field              in varchar2 default c_y,
    p_colspan                         in number   default null,
    p_rowspan                         in number   default null,
    p_grid_column                     in number   default null,
    p_grid_label_column_span          in number   default null,
    p_grid_column_css_classes         in varchar2 default null,
    p_button_image                    in varchar2 default null,
    p_button_image_attr               in varchar2 default null,
    p_label_alignment                 in varchar2 default 'LEFT',
    p_field_alignment                 in varchar2 default 'LEFT',
    p_field_template                  in varchar2 default null,
    p_item_css_classes                in varchar2 default null,
    p_item_icon_css_classes           in varchar2 default null,
    p_item_template_options           in varchar2 default null,
    p_depending_on_id                 in number   default null,
    p_depending_on_condition_type     in varchar2 default null,
    p_depending_on_expression         in varchar2 default null,
    p_display_when                    in varchar2 default null,
    p_display_when2                   in varchar2 default null,
    p_display_when_type               in varchar2 default null,
    p_warn_on_unsaved_changes         in varchar2 default null,
    p_is_Persistent                   in varchar2 default c_y,
    p_javascript                      in varchar2 default null,
    p_security_scheme                 in varchar2 default null,
    p_required_patch                  in number   default null,
    p_item_comment                    in varchar2 default null,
    p_help_text                       in varchar2 default null,
    p_inline_help_text                in varchar2 default null,
    --
    p_read_only_when                  in varchar2 default null,
    p_read_only_when2                 in varchar2 default null,
    p_read_only_when_type             in varchar2 default null,
    p_read_only_disp_attr             in varchar2 default null,
    --
    p_protection_level                in varchar  default c_n,
    p_escape_on_http_input            in varchar2 default null,
    p_escape_on_http_output           in varchar2 default c_y,
    p_restricted_characters           in varchar2 default null,
    --
    p_encrypt_session_state_yn        in varchar2 default null,
    --
    p_plugin_init_javascript_code     in varchar2 default null,
    --
    p_attribute_01                    in varchar2 default null,
    p_attribute_02                    in varchar2 default null,
    p_attribute_03                    in varchar2 default null,
    p_attribute_04                    in varchar2 default null,
    p_attribute_05                    in varchar2 default null,
    p_attribute_06                    in varchar2 default null,
    p_attribute_07                    in varchar2 default null,
    p_attribute_08                    in varchar2 default null,
    p_attribute_09                    in varchar2 default null,
    p_attribute_10                    in varchar2 default null,
    p_attribute_11                    in varchar2 default null,
    p_attribute_12                    in varchar2 default null,
    p_attribute_13                    in varchar2 default null,
    p_attribute_14                    in varchar2 default null,
    p_attribute_15                    in varchar2 default null,
    --
    p_fc_max_height                   in number   default null,
    p_fc_show_label                   in boolean  default null,
    p_fc_collapsible                  in boolean  default null,
    p_fc_initial_collapsed            in boolean  default null,
    p_fc_compute_counts               in boolean  default null,
    p_fc_show_counts                  in boolean  default null,
    p_fc_zero_count_entries           in varchar2 default null,
    p_fc_show_more_count              in number   default null,
    p_fc_filter_values                in boolean  default null,
    p_fc_sort_by_top_counts           in boolean  default null,
    p_fc_show_selected_first          in boolean  default null,
    p_fc_show_chart                   in boolean  default null,
    p_fc_initial_chart                in boolean  default null,
    p_fc_actions_filter               in boolean  default null,
    p_fc_toggleable                   in boolean  default null,
    p_fc_initial_toggled              in boolean  default null,
    --
    p_multi_value_type                in varchar2 default null,
    p_multi_value_separator           in varchar2 default null,
    p_multi_value_trim_space          in boolean  default null,
    p_fc_filter_combination           in varchar2 default null,
    --
    p_show_quick_picks                in varchar2 default c_n,
    p_quick_pick_label_01             in varchar2 default null,
    p_quick_pick_value_01             in varchar2 default null,
    p_quick_pick_label_02             in varchar2 default null,
    p_quick_pick_value_02             in varchar2 default null,
    p_quick_pick_label_03             in varchar2 default null,
    p_quick_pick_value_03             in varchar2 default null,
    p_quick_pick_label_04             in varchar2 default null,
    p_quick_pick_value_04             in varchar2 default null,
    p_quick_pick_label_05             in varchar2 default null,
    p_quick_pick_value_05             in varchar2 default null,
    p_quick_pick_label_06             in varchar2 default null,
    p_quick_pick_value_06             in varchar2 default null,
    p_quick_pick_label_07             in varchar2 default null,
    p_quick_pick_value_07             in varchar2 default null,
    p_quick_pick_label_08             in varchar2 default null,
    p_quick_pick_value_08             in varchar2 default null,
    p_quick_pick_label_09             in varchar2 default null,
    p_quick_pick_value_09             in varchar2 default null,
    p_quick_pick_label_10             in varchar2 default null,
    p_quick_pick_value_10             in varchar2 default null,
    p_quick_pick_link_attr            in varchar2 default null,
    --
    p_suggestions_type                in varchar2 default null,
    p_suggestions_language            in varchar2 default null,
    p_suggestions_source              in varchar2 default null,
    p_max_suggestions                 in number   default null,
    --
    p_reference_id                    in number   default null,
    --
    p_button_execute_validations      in varchar2 default c_y,
    p_button_action                   in varchar2 default null,
    p_button_redirect_url             in varchar2 default null,
    p_button_is_hot                   in varchar2 default null );

--==============================================================================
--
-- P A G E   P R O C E S S I N G
--
--==============================================================================
procedure create_page_computation (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_flow_step_id                    in number   default current_page_id,
    p_computation_sequence            in number   default null,
    p_computation_item                in varchar2 default null,
    p_computation_point               in varchar2 default 'AFTER_SUBMIT',
    p_computation_item_type           in varchar2 default null,
    p_computation_type                in varchar2 default 'SQL_EXPRESSION',
    p_computation_language            in varchar2 default null,
    p_computation_processed           in varchar2 default 'REPLACE_EXISTING',
    p_computation                     in varchar2 default null,
    p_computation_comment             in varchar2 default null,
    p_compute_when                    in varchar2 default null,
    p_compute_when_type               in varchar2 default null,
    p_computation_error_message       in varchar2 default null,
    p_compute_when_text               in varchar2 default null,
    p_security_scheme                 in varchar2 default null,
    p_required_patch                  in number   default null );

--==============================================================================
procedure create_page_validation (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_flow_step_id                    in number   default current_page_id,
    p_tabular_form_region_id          in number   default null,
    p_validation_name                 in varchar2 default null,
    p_validation_sequence             in number   default null,
    p_validation                      in varchar2 default null,
    p_validation2                     in varchar2 default null,
    p_validation_type                 in varchar2 default null,
    p_error_message                   in varchar2 default null,
    p_always_execute                  in varchar2 default c_n,
    p_validation_condition            in varchar2 default null,
    p_validation_condition2           in varchar2 default null,
    p_validation_condition_type       in varchar2 default null,
    p_exec_cond_for_each_row          in varchar2 default c_n,
    p_only_for_changed_rows           in varchar2 default c_y,
    p_when_button_pressed             in varchar2 default null,
    p_associated_item                 in number   default null,
    p_associated_column               in varchar2 default null,
    p_error_display_location          in varchar2 default 'ON_ERROR_PAGE',
    p_security_scheme                 in varchar2 default null,
    p_required_patch                  in number   default null,
    p_validation_comment              in varchar2 default null );

--==============================================================================
procedure create_page_process (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_flow_step_id                    in number   default current_page_id,
    p_process_sequence                in number   default null,
    p_process_point                   in varchar2,
    p_process_type                    in varchar2 default 'PLSQL',
    p_process_name                    in varchar2 default null,
    p_region_id                       in number   default null,
    p_process_sql                     in varchar2 default null,
    p_process_sql_clob                in varchar2 default null,
    p_process_clob_language           in varchar2 default null,
    p_location                        in varchar2 default 'LOCAL',
    p_remote_server_id                in number   default null,
    p_web_src_module_id               in number   default null,
    p_web_src_operation_id            in number   default null,
    p_attribute_01                    in varchar2 default null,
    p_attribute_02                    in varchar2 default null,
    p_attribute_03                    in varchar2 default null,
    p_attribute_04                    in varchar2 default null,
    p_attribute_05                    in varchar2 default null,
    p_attribute_06                    in varchar2 default null,
    p_attribute_07                    in varchar2 default null,
    p_attribute_08                    in varchar2 default null,
    p_attribute_09                    in varchar2 default null,
    p_attribute_10                    in varchar2 default null,
    p_attribute_11                    in varchar2 default null,
    p_attribute_12                    in varchar2 default null,
    p_attribute_13                    in varchar2 default null,
    p_attribute_14                    in varchar2 default null,
    p_attribute_15                    in varchar2 default null,
    p_process_error_message           in varchar2 default null,
    p_error_display_location          in varchar2 default 'ON_ERROR_PAGE',
    p_process_when_button_id          in number   default null,
    p_process_when                    in varchar2 default null,
    p_process_when_type               in varchar2 default null,
    p_process_when2                   in varchar2 default null,
    p_exec_cond_for_each_row          in varchar2 default c_n,
    p_only_for_changed_rows           in varchar2 default c_y,
    p_process_when_type2              in varchar2 default null,
    p_process_success_message         in varchar2 default null,
    p_security_scheme                 in varchar2 default null,
    p_required_patch                  in number   default null,
    p_process_is_stateful_y_n         in varchar2 default c_n,
    p_return_key_into_item1           in varchar2 default null,
    p_return_key_into_item2           in varchar2 default null,
    p_process_item_name               in varchar2 default null,
    p_process_comment                 in varchar2 default null,
    p_runtime_where_clause            in varchar2 default null );

--==============================================================================
procedure set_page_process_source (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_process_sql_clob                in varchar2 default null );

--==============================================================================
--
-- D Y N A M I C    A C T I O N S
--
--==============================================================================
procedure create_page_da_event (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_name                            in varchar2,
    p_event_sequence                  in number,
    p_triggering_element_type         in varchar2 default null,
    p_triggering_region_id            in number   default null,
    p_triggering_button_id            in number   default null,
    p_triggering_element              in varchar2 default null,
    p_condition_element_type          in varchar2 default null,
    p_condition_element               in varchar2 default null,
    p_triggering_condition_type       in varchar2 default null,
    p_triggering_expression           in varchar2 default null,
    p_bind_type                       in varchar2,
    p_bind_delegate_to_selector       in varchar2 default null,
    p_bind_event_type                 in varchar2,
    p_bind_event_type_custom          in varchar2 default null,
    p_bind_event_data                 in varchar2 default null,
    p_display_when_type               in varchar2 default null,
    p_display_when_cond               in varchar2 default null,
    p_display_when_cond2              in varchar2 default null,
    p_required_patch                  in number   default null,
    p_security_scheme                 in varchar2 default null,
    p_da_event_comment                in varchar2 default null );

--==============================================================================
procedure create_page_da_action (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_event_id                        in number,
    p_event_result                    in varchar2,
    p_action_sequence                 in number,
    p_execute_on_page_init            in varchar2,
    p_stop_execution_on_error         in varchar2 default c_y,
    p_wait_for_result                 in varchar2 default null,
    p_name                            in varchar2 default null,
    p_action                          in varchar2,
    p_affected_elements_type          in varchar2 default null,
    p_affected_region_id              in number   default null,
    p_affected_button_id              in number   default null,
    p_affected_elements               in varchar2 default null,
    p_plugin_init_javascript_code     in varchar2 default null,
    p_attribute_01                    in varchar2 default null,
    p_attribute_02                    in varchar2 default null,
    p_attribute_03                    in varchar2 default null,
    p_attribute_04                    in varchar2 default null,
    p_attribute_05                    in varchar2 default null,
    p_attribute_06                    in varchar2 default null,
    p_attribute_07                    in varchar2 default null,
    p_attribute_08                    in varchar2 default null,
    p_attribute_09                    in varchar2 default null,
    p_attribute_10                    in varchar2 default null,
    p_attribute_11                    in varchar2 default null,
    p_attribute_12                    in varchar2 default null,
    p_attribute_13                    in varchar2 default null,
    p_attribute_14                    in varchar2 default null,
    p_attribute_15                    in varchar2 default null,
    p_client_condition_type           in varchar2 default null,
    p_client_condition_elem_type      in varchar2 default null,
    p_client_condition_element        in varchar2 default null,
    p_client_condition_expression     in varchar2 default null,
    p_server_condition_type           in varchar2 default null,
    p_server_condition_expr1          in varchar2 default null,
    p_server_condition_expr2          in varchar2 default null,
    p_build_option_id                 in number   default null,
    p_security_scheme                 in varchar2 default null,
    p_da_action_comment               in varchar2 default null );

--==============================================================================
--
-- R E G I O N S
--
--==============================================================================
procedure create_page_plug (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_plug_name                       in varchar2 default null,
    p_region_name                     in varchar2 default null,
    p_parent_plug_id                  in number   default null,
    p_plug_display_point              in varchar2 default 'BODY',
    p_plug_template                   in number   default null,
    p_plug_display_sequence           in varchar2 default null,
    p_include_in_reg_disp_sel_yn      in varchar2 default c_n,
    p_region_css_classes              in varchar2 default null,
    p_icon_css_classes                in varchar2 default null,
    p_region_sub_css_classes          in varchar2 default null,
    p_region_template_options         in varchar2 default null,
    p_component_template_options      in varchar2 default null,
    p_region_attributes               in varchar2 default null,
    p_report_attributes               in varchar2 default null,
    p_escape_on_http_output           in varchar2 default c_n,
    p_plug_new_grid                   in boolean  default false,
    p_plug_new_grid_row               in boolean  default true,
    p_plug_grid_row_css_classes       in varchar2 default null,
    p_plug_new_grid_column            in boolean  default true,
    p_plug_grid_column_span           in number   default null,
    p_plug_grid_column_css_classes    in varchar2 default null,
    p_plug_display_column             in varchar2 default null,
    p_plug_item_display_point         in varchar2 default 'ABOVE',
    p_plug_source_type                in varchar2 default 'NATIVE_STATIC',
    p_location                        in varchar2 default 'LOCAL',
    p_web_src_module_id               in number   default null,
    p_use_local_sync_table            in boolean  default null,
    p_remote_server_id                in number   default null,
    p_query_type                      in varchar2 default null,
    p_function_body_language          in varchar2 default null,
    p_plug_source                     in varchar2 default null,
    p_query_owner                     in varchar2 default null,
    p_query_table                     in varchar2 default null,
    p_query_where                     in varchar2 default null,
    p_query_order_by_type             in varchar2 default null,
    p_query_order_by                  in varchar2 default null,
    p_source_post_processing          in varchar2 default null,
    p_include_rowid_column            in boolean  default null,
    p_optimizer_hint                  in varchar2 default null,
    p_remote_sql_caching              in varchar2 default null,
    p_remote_sql_invalidate_when      in varchar2 default null,
    p_external_filter_expr            in varchar2 default null,
    p_external_order_by_type          in varchar2 default null,
    p_external_order_by_expr          in varchar2 default null,
    p_is_editable                     in boolean  default null,
    p_edit_operations                 in varchar2 default null,
    p_edit_row_operations_column      in varchar2 default null,
    p_add_authorization_scheme        in varchar2 default null,
    p_update_authorization_scheme     in varchar2 default null,
    p_delete_authorization_scheme     in varchar2 default null,
    p_lost_update_check_type          in varchar2 default null,
    p_row_version_column              in varchar2 default null,
    p_add_row_if_empty                in boolean  default null,
    p_lazy_loading                    in boolean  default null,
    p_list_id                         in number   default null,
    p_menu_id                         in number   default null,
    p_master_region_id                in number   default null,
    p_filtered_region_id              in number   default null,
    p_plug_display_error_message      in varchar2 default null, -- obsolete
    p_plug_create_link_text           in varchar2 default null,
    p_plug_create_link_target         in varchar2 default null,
    p_plug_create_image               in varchar2 default null,
    p_plug_create_image_attributes    in varchar2 default null,
    p_plug_edit_link_text             in varchar2 default null,
    p_plug_edit_link_target           in varchar2 default null,
    p_plug_edit_image                 in varchar2 default null,
    p_plug_edit_image_attributes      in varchar2 default null,
    p_plug_expand_link_text           in varchar2 default null,
    p_plug_expand_link_target         in varchar2 default null,
    p_plug_expand_image               in varchar2 default null,
    p_plug_expand_image_attributes    in varchar2 default null,
    p_plug_close_link_text            in varchar2 default null,
    p_plug_close_link_target          in varchar2 default null,
    p_plug_close_image                in varchar2 default null,
    p_plug_close_image_attributes     in varchar2 default null,
    p_plug_required_role              in varchar2 default null,
    p_plug_display_when_condition     in varchar2 default null,
    p_plug_display_when_cond2         in varchar2 default null,
    p_plug_display_condition_type     in varchar2 default null,
    --
    p_plug_read_only_when_type        in varchar2 default null,
    p_plug_read_only_when             in varchar2 default null,
    p_plug_read_only_when2            in varchar2 default null,
    --
    p_plug_header                     in varchar2 default null,
    p_plug_footer                     in varchar2 default null,
    p_plug_override_reg_pos           in varchar2 default null,
    p_plug_customized                 in varchar2 default null,
    p_plug_customized_name            in varchar2 default null,
    p_translate_title                 in varchar2 default c_y,
    p_ajax_enabled                    in varchar2 default null,
    p_ajax_items_to_submit            in varchar2 default null,
    p_rest_enabled                    in varchar2 default c_n,
    --
    p_region_image                    in varchar2 default null,
    p_region_image_attr               in varchar2 default null,
    p_region_image_alt_text           in varchar2 default null,
    --
    p_plug_query_row_template         in number   default null,
    p_plug_query_max_columns          in number   default null,
    p_plug_query_headings             in varchar2 default null,
    p_plug_query_headings_type        in varchar2 default 'COLON_DELMITED_LIST',
    p_plug_query_num_rows             in number   default null,
    p_plug_query_hit_highlighting     in varchar2 default null,
    p_plug_query_options              in varchar2 default null,
    p_plug_query_format_out           in varchar2 default null,
    p_plug_query_show_nulls_as        in varchar2 default null,
    p_plug_query_col_allignments      in varchar2 default null,
    p_plug_query_break_cols           in varchar2 default null,
    p_plug_query_sum_cols             in varchar2 default null,
    p_plug_query_number_formats       in varchar2 default null,
    p_plug_query_table_border         in varchar2 default null,
    p_plug_column_width               in varchar2 default null,
    p_plug_query_no_data_found        in varchar2 default null,
    p_no_data_found_icon_classes      in varchar2 default null,
    p_plug_query_more_data            in varchar2 default null,
    p_plug_ignore_pagination          in number   default null,
    p_plug_query_num_rows_item        in varchar2 default null,
    p_plug_query_num_rows_type        in varchar2 default null,
    p_plug_query_row_count_max        in number   default null,
    p_show_total_row_count            in boolean  default null,
    p_plug_query_asc_image            in varchar2 default null,
    p_plug_query_asc_image_attr       in varchar2 default null,
    p_plug_query_desc_image           in varchar2 default null,
    p_plug_query_desc_image_attr      in varchar2 default null,
    --
    p_plug_query_exp_filename         in varchar2 default null,
    p_plug_query_exp_separator        in varchar2 default null,
    p_plug_query_exp_enclosed_by      in varchar2 default null,
    p_plug_query_strip_html           in varchar2 default null,
    p_plug_query_parse_override       in varchar2 default null,
    --
    p_pagination_display_position     in varchar2 default null,
    p_report_total_text_format        in varchar2 default null,
    p_break_column_text_format        in varchar2 default null,
    p_break_before_row                in varchar2 default null,
    p_break_generic_column            in varchar2 default null,
    p_break_after_row                 in varchar2 default null,
    p_break_type_flag                 in varchar2 default null,
    p_break_repeat_heading_format     in varchar2 default null,
    p_csv_output                      in varchar2 default null,
    p_csv_output_link_text            in varchar2 default null,
    p_supplemental_text               in varchar2 default null,
    p_print_url                       in varchar2 default null,
    p_print_url_label                 in varchar2 default null,
    --
    p_prn_output                      in varchar2 default null,
    p_prn_print_server_overwrite      in varchar2 default null,
    p_prn_template_id                 in number   default null,
    p_prn_format                      in varchar2 default null,
    p_prn_format_item                 in varchar2 default null,
    p_prn_output_show_link            in varchar2 default null,
    p_prn_output_link_text            in varchar2 default null,
    p_prn_output_file_name            in varchar2 default null,
    p_prn_content_disposition         in varchar2 default null,
    p_prn_document_header             in varchar2 default null,
    p_prn_units                       in varchar2 default null,
    p_prn_paper_size                  in varchar2 default null,
    p_prn_width_units                 in varchar2 default null,
    p_prn_width                       in number   default null,
    p_prn_height                      in number   default null,
    p_prn_orientation                 in varchar2 default null,
    p_prn_page_header                 in varchar2 default null,
    p_prn_page_header_font_color      in varchar2 default null,
    p_prn_page_header_font_family     in varchar2 default null,
    p_prn_page_header_font_weight     in varchar2 default null,
    p_prn_page_header_font_size       in varchar2 default null,
    p_prn_page_footer                 in varchar2 default null,
    p_prn_page_footer_font_color      in varchar2 default null,
    p_prn_page_footer_font_family     in varchar2 default null,
    p_prn_page_footer_font_weight     in varchar2 default null,
    p_prn_page_footer_font_size       in varchar2 default null,
    p_prn_header_bg_color             in varchar2 default null,
    p_prn_header_font_color           in varchar2 default null,
    p_prn_header_font_family          in varchar2 default null,
    p_prn_header_font_weight          in varchar2 default null,
    p_prn_header_font_size            in varchar2 default null,
    p_prn_body_bg_color               in varchar2 default null,
    p_prn_body_font_color             in varchar2 default null,
    p_prn_body_font_family            in varchar2 default null,
    p_prn_body_font_weight            in varchar2 default null,
    p_prn_body_font_size              in varchar2 default null,
    p_prn_border_width                in number   default null,
    --
    p_shared_query_id                 in number   default null,
    --
    p_plug_url_text_begin             in varchar2 default null,
    p_plug_url_text_end               in varchar2 default null,
    p_java_entry_point                in varchar2 default null,
    --
    p_plug_caching                    in varchar2 default 'NOCACHE',
    p_plug_caching_session_state      in varchar2 default null,
    p_plug_caching_max_age_in_sec     in varchar2 default null,
    p_plug_cache_when_cond_type       in varchar2 default null,
    p_plug_cache_when_condition_e1    in varchar2 default null,
    p_plug_cache_when_condition_e2    in varchar2 default null,
    p_plug_cache_depends_on_items     in varchar2 default null,
    --
    p_plug_chart_font_size            in varchar2 default null,
    p_plug_chart_max_rows             in varchar2 default null,
    p_plug_chart_num_mask             in varchar2 default null,
    p_plug_chart_scale                in varchar2 default null,
    p_plug_chart_axis                 in varchar2 default null,
    p_plug_chart_show_summary         in varchar2 default null,
    --
    p_menu_template_id                in number   default null,
    p_list_template_id                in number   default null,
    --
    p_required_patch                  in varchar2 default null,
    p_plug_comment                    in varchar2 default null,
    --
    p_use_custom_item_layout          in varchar2 default null,
    p_custom_item_layout              in varchar2 default null,
    --
    p_prn_page_header_alignment       in varchar2 default null,
    p_prn_page_footer_alignment       in varchar2 default null,
    p_prn_border_color                in varchar2 default null,
    p_sort_null                       in varchar2 default null,
    --
    p_fixed_header                    in varchar2 default null,
    p_fixed_header_max_height         in number   default null,
    --
    p_plugin_init_javascript_code     in varchar2 default null,
    --
    p_attribute_01                    in varchar2 default null,
    p_attribute_02                    in varchar2 default null,
    p_attribute_03                    in varchar2 default null,
    p_attribute_04                    in varchar2 default null,
    p_attribute_05                    in varchar2 default null,
    p_attribute_06                    in varchar2 default null,
    p_attribute_07                    in varchar2 default null,
    p_attribute_08                    in varchar2 default null,
    p_attribute_09                    in varchar2 default null,
    p_attribute_10                    in varchar2 default null,
    p_attribute_11                    in varchar2 default null,
    p_attribute_12                    in varchar2 default null,
    p_attribute_13                    in varchar2 default null,
    p_attribute_14                    in varchar2 default null,
    p_attribute_15                    in varchar2 default null,
    p_attribute_16                    in varchar2 default null,
    p_attribute_17                    in varchar2 default null,
    p_attribute_18                    in varchar2 default null,
    p_attribute_19                    in varchar2 default null,
    p_attribute_20                    in varchar2 default null,
    p_attribute_21                    in varchar2 default null,
    p_attribute_22                    in varchar2 default null,
    p_attribute_23                    in varchar2 default null,
    p_attribute_24                    in varchar2 default null,
    p_attribute_25                    in varchar2 default null );

--==============================================================================
procedure set_region_column_width (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_plug_column_width               in varchar2 default null);

--==============================================================================
procedure create_report_region (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_name                            in varchar2 default null,
    p_region_name                     in varchar2 default null,
    p_parent_plug_id                  in number   default null,
    p_template                        in number   default null,
    p_display_sequence                in varchar2 default null,
    p_include_in_reg_disp_sel_yn      in varchar2 default c_n,
    p_region_css_classes              in varchar2 default null,
    p_icon_css_classes                in varchar2 default null,
    p_region_sub_css_classes          in varchar2 default null,
    p_region_template_options         in varchar2 default null,
    p_component_template_options      in varchar2 default null,
    p_region_attributes               in varchar2 default null,
    p_report_attributes               in varchar2 default null,
    p_new_grid                        in boolean  default false,
    p_new_grid_row                    in boolean  default true,
    p_grid_row_css_classes            in varchar2 default null,
    p_new_grid_column                 in boolean  default true,
    p_grid_column_span                in number   default null,
    p_grid_column_css_classes         in varchar2 default null,
    p_display_column                  in varchar2 default null,
    p_display_point                   in varchar2 default 'BODY',
    p_item_display_point              in varchar2 default 'ABOVE',
    p_source_type                     in varchar2 default null,
    p_location                        in varchar2 default 'LOCAL',
    p_web_src_module_id               in number   default null,
    p_use_local_sync_table            in boolean  default null,
    p_remote_server_id                in number   default null,
    p_query_type                      in varchar2 default null,
    p_function_body_language          in varchar2 default null,
    p_source                          in varchar2 default null,
    p_query_owner                     in varchar2 default null,
    p_query_table                     in varchar2 default null,
    p_query_where                     in varchar2 default null,
    p_query_order_by_type             in varchar2 default null,
    p_query_order_by                  in varchar2 default null,
    p_source_post_processing          in varchar2 default null,
    p_include_rowid_column            in boolean  default null,
    p_optimizer_hint                  in varchar2 default null,
    p_remote_sql_caching              in varchar2 default null,
    p_remote_sql_invalidate_when      in varchar2 default null,
    p_external_filter_expr            in varchar2 default null,
    p_external_order_by_type          in varchar2 default null,
    p_external_order_by_expr          in varchar2 default null,
    p_display_error_message           in varchar2 default null, /* obsolete */
    p_required_role                   in varchar2 default null,
    p_display_when_condition          in varchar2 default null,
    p_display_when_cond2              in varchar2 default null,
    p_display_condition_type          in varchar2 default null,
    --
    p_read_only_when_type             in varchar2 default null,
    p_read_only_when                  in varchar2 default null,
    p_read_only_when2                 in varchar2 default null,
    --
    p_header                          in varchar2 default null,
    p_footer                          in varchar2 default null,
    p_override_reg_pos                in varchar2 default null,
    p_customized                      in varchar2 default null,
    p_customized_name                 in varchar2 default null,
    p_translate_title                 in varchar2 default c_y,
    p_ajax_enabled                    in varchar2 default c_n,
    p_ajax_items_to_submit            in varchar2 default null,
    p_rest_enabled                    in varchar2 default c_n,
    p_region_image                    in varchar2 default null,
    p_region_image_attr               in varchar2 default null,
    p_region_image_alt_text           in varchar2 default null,
    p_fixed_header                    in varchar2 default 'PAGE',
    p_fixed_header_max_height         in number   default null,
    --
    p_lazy_loading                    in boolean  default false,
    --
    p_query_row_template              in number   default null,
    p_plug_query_max_columns          in number   default null,
    p_query_headings                  in varchar2 default null,
    p_query_headings_type             in varchar2 default 'COLON_DELMITED_LIST',
    p_query_num_rows                  in number   default null,
    p_query_options                   in varchar2 default null,
    p_query_show_nulls_as             in varchar2 default null,
    p_query_break_cols                in varchar2 default null,
    p_query_no_data_found             in varchar2 default null,
    p_query_more_data                 in varchar2 default null,
    p_ignore_pagination               in number   default null,
    p_query_num_rows_item             in varchar2 default null,
    p_query_num_rows_type             in varchar2 default null,
    p_query_row_count_max             in number   default null,
    --
    p_pagination_display_position     in varchar2 default null,
    p_report_total_text_format        in varchar2 default null,
    p_break_column_text_format        in varchar2 default null,
    p_break_before_row                in varchar2 default null,
    p_break_generic_column            in varchar2 default null,
    p_break_after_row                 in varchar2 default null,
    p_break_type_flag                 in varchar2 default null,
    p_break_repeat_heading_format     in varchar2 default null,
    p_csv_output                      in varchar2 default null,
    p_csv_output_link_text            in varchar2 default null,
    p_supplemental_text               in varchar2 default null,
    p_print_url                       in varchar2 default null,
    p_print_url_label                 in varchar2 default null,
    --
    p_prn_output                      in varchar2 default null,
    p_prn_print_server_overwrite      in varchar2 default null,
    p_prn_template_id                 in number   default null,
    p_prn_format                      in varchar2 default null,
    p_prn_format_item                 in varchar2 default null,
    p_prn_output_show_link            in varchar2 default null,
    p_prn_output_link_text            in varchar2 default null,
    p_prn_output_file_name            in varchar2 default null,
    p_prn_content_disposition         in varchar2 default null,
    p_prn_document_header             in varchar2 default null,
    p_prn_units                       in varchar2 default null,
    p_prn_paper_size                  in varchar2 default null,
    p_prn_width_units                 in varchar2 default null,
    p_prn_width                       in number   default null,
    p_prn_height                      in number   default null,
    p_prn_orientation                 in varchar2 default null,
    p_prn_page_header                 in varchar2 default null,
    p_prn_page_header_font_color      in varchar2 default null,
    p_prn_page_header_font_family     in varchar2 default null,
    p_prn_page_header_font_weight     in varchar2 default null,
    p_prn_page_header_font_size       in varchar2 default null,
    p_prn_page_footer                 in varchar2 default null,
    p_prn_page_footer_font_color      in varchar2 default null,
    p_prn_page_footer_font_family     in varchar2 default null,
    p_prn_page_footer_font_weight     in varchar2 default null,
    p_prn_page_footer_font_size       in varchar2 default null,
    p_prn_header_bg_color             in varchar2 default null,
    p_prn_header_font_color           in varchar2 default null,
    p_prn_header_font_family          in varchar2 default null,
    p_prn_header_font_weight          in varchar2 default null,
    p_prn_header_font_size            in varchar2 default null,
    p_prn_body_bg_color               in varchar2 default null,
    p_prn_body_font_color             in varchar2 default null,
    p_prn_body_font_family            in varchar2 default null,
    p_prn_body_font_weight            in varchar2 default null,
    p_prn_body_font_size              in varchar2 default null,
    p_prn_border_width                in number   default null,
    --
    p_shared_query_id                 in number   default null,
    --
    p_query_asc_image                 in varchar2 default 'arrow_down_gray_dark.gif',
    p_query_asc_image_attr            in varchar2 default 'width="13" height="12"',
    p_query_desc_image                in varchar2 default 'arrow_up_gray_dark.gif',
    p_query_desc_image_attr           in varchar2 default 'width="13" height="12"',
    --
    p_plug_query_exp_filename         in varchar2 default null,
    p_plug_query_exp_separator        in varchar2 default null,
    p_plug_query_exp_enclosed_by      in varchar2 default null,
    p_plug_query_strip_html           in varchar2 default null,
    p_plug_query_parse_override       in varchar2 default null,
    --
    p_required_patch                  in varchar2 default null,
    p_comment                         in varchar2 default null,
    --
    p_plug_column_width               in varchar2 default null,
    --
    p_prn_page_header_alignment       in varchar2 default null,
    p_prn_page_footer_alignment       in varchar2 default null,
    p_prn_border_color                in varchar2 default null,
    p_sort_null                       in varchar2 default null,
    --
    p_plug_caching                    in varchar2 default 'NOCACHE',
    p_plug_caching_session_state      in varchar2 default null,
    p_plug_caching_max_age_in_sec     in varchar2 default null,
    p_plug_cache_when_cond_type       in varchar2 default null,
    p_plug_cache_when_condition_e1    in varchar2 default null,
    p_plug_cache_when_condition_e2    in varchar2 default null,
    p_plug_cache_depends_on_items     in varchar2 default null );

--==============================================================================
procedure create_report_columns(
    p_id                              in number   default null,
    p_region_id                       in number   default current_region_id,
    p_flow_id                         in number   default null, -- defaults to region's flow id
    p_query_column_id                 in number   default null,
    p_form_element_id                 in number   default null,
    p_column_alias                    in varchar2 default null,
    p_static_id                       in varchar2 default null,
    p_column_display_sequence         in varchar2 default null,
    p_column_heading                  in varchar2 default null,
    p_use_as_row_header               in varchar2 default c_n,
    p_column_format                   in varchar2 default null,
    p_column_html_expression          in varchar2 default null,
    p_column_css_class                in varchar2 default null,
    p_column_css_style                in varchar2 default null,
    p_column_hit_highlight            in varchar2 default null,
    p_column_link                     in varchar2 default null,
    p_column_linktext                 in varchar2 default null,
    p_column_link_attr                in varchar2 default null,
    p_column_alignment                in varchar2 default 'LEFT',
    p_heading_alignment               in varchar2 default 'CENTER',
    p_default_sort_column_sequence    in varchar2 default '0',
    p_default_sort_dir                in varchar2 default null,
    p_disable_sort_column             in varchar2 default c_y,
    p_sum_column                      in varchar2 default c_n,
    p_hidden_column                   in varchar2 default c_n,
    p_display_when_cond_type          in varchar2 default null,
    p_display_when_condition          in varchar2 default null,
    p_display_when_condition2         in varchar2 default null,
    p_report_column_required_role     in varchar2 default null,
    p_security_group_id               in varchar2 default null,
    p_last_updated_by                 in varchar2 default null,
    p_last_updated_on                 in varchar2 default null,
    p_display_as                      in varchar2 default 'ESCAPE_SC',
    p_named_lov                       in varchar2 default null,
    p_inline_lov                      in varchar2 default null,
    p_lov_language                    in varchar2 default null,
    p_lov_show_nulls                  in varchar2 default null,
    p_lov_null_text                   in varchar2 default null,
    p_lov_null_value                  in varchar2 default null,
    p_report_column_width             in varchar2 default null,
    p_column_width                    in varchar2 default null,
    p_column_height                   in varchar2 default null,
    p_css_classes                     in varchar2 default null,
    p_cattributes                     in varchar2 default null,
    p_cattributes_element             in varchar2 default null,
    p_column_field_template           in number   default null,
    p_is_required                     in boolean  default false,
    p_standard_validations            in varchar2 default null,
    --
    p_attribute_01                    in varchar2 default null,
    p_attribute_02                    in varchar2 default null,
    p_attribute_03                    in varchar2 default null,
    p_attribute_04                    in varchar2 default null,
    p_attribute_05                    in varchar2 default null,
    p_attribute_06                    in varchar2 default null,
    p_attribute_07                    in varchar2 default null,
    p_attribute_08                    in varchar2 default null,
    p_attribute_09                    in varchar2 default null,
    p_attribute_10                    in varchar2 default null,
    p_attribute_11                    in varchar2 default null,
    p_attribute_12                    in varchar2 default null,
    p_attribute_13                    in varchar2 default null,
    p_attribute_14                    in varchar2 default null,
    p_attribute_15                    in varchar2 default null,
    --
    p_pk_col_source_type              in varchar2 default null,
    p_pk_col_source                   in varchar2 default null,
    p_derived_column                  in varchar2 default null,
    --
    p_column_default                  in varchar2 default null,
    p_column_default_type             in varchar2 default null,
    p_lov_display_extra               in varchar2 default null,
    --
    p_include_in_export               in varchar2 default null,
    p_print_col_width                 in varchar2 default null,
    p_print_col_align                 in varchar2 default null,
    --
    p_ref_schema                      in varchar2 default null,
    p_ref_table_name                  in varchar2 default null,
    p_ref_column_name                 in varchar2 default null,
    --
    p_column_link_checksum_type       in varchar2 default null,
    --
    p_required_patch                  in number   default null,
    --
    p_column_comment                  in varchar2 default null );

--==============================================================================
procedure set_plug_source (
    p_id                              in number   default null,
    p_plug_source                     in varchar2 default null);

--==============================================================================
procedure set_plug_query_heading (
    p_id                              in number   default null,
    p_plug_query_heading              in varchar2 default null);

--==============================================================================
procedure create_chart_series_attr (
    p_id                              in number   default null,
    p_region_id                       in number   default current_region_id,
    p_series_id                       in number   default null,
    p_a001                            in varchar2 default null,
    p_a002                            in varchar2 default null,
    p_a003                            in varchar2 default null,
    p_a004                            in varchar2 default null,
    p_a005                            in varchar2 default null,
    p_a006                            in varchar2 default null,
    p_a007                            in varchar2 default null,
    p_a008                            in varchar2 default null,
    p_a009                            in varchar2 default null,
    p_a010                            in varchar2 default null,
    p_a011                            in varchar2 default null,
    p_a012                            in varchar2 default null,
    p_a013                            in varchar2 default null,
    p_a014                            in varchar2 default null,
    p_a015                            in varchar2 default null,
    p_a016                            in varchar2 default null,
    p_a017                            in varchar2 default null,
    p_a018                            in varchar2 default null,
    p_a019                            in varchar2 default null,
    p_a020                            in varchar2 default null,
    p_a021                            in varchar2 default null,
    p_a022                            in varchar2 default null,
    p_a023                            in varchar2 default null,
    p_a024                            in varchar2 default null,
    p_a025                            in varchar2 default null,
    p_a026                            in varchar2 default null,
    p_a027                            in varchar2 default null,
    p_a028                            in varchar2 default null,
    p_a029                            in varchar2 default null,
    p_a030                            in varchar2 default null,
    p_a031                            in varchar2 default null,
    p_a032                            in varchar2 default null,
    p_a033                            in varchar2 default null,
    p_a034                            in varchar2 default null,
    p_a035                            in varchar2 default null,
    p_a036                            in varchar2 default null,
    p_a037                            in varchar2 default null,
    p_a038                            in varchar2 default null,
    p_a039                            in varchar2 default null,
    p_a040                            in varchar2 default null,
    p_a041                            in varchar2 default null,
    p_a042                            in varchar2 default null,
    p_a043                            in varchar2 default null,
    p_a044                            in varchar2 default null,
    p_a045                            in varchar2 default null,
    p_a046                            in varchar2 default null,
    p_a047                            in varchar2 default null,
    p_a048                            in varchar2 default null,
    p_a049                            in varchar2 default null,
    p_a050                            in varchar2 default null );

--==============================================================================
procedure create_generic_attr (
    p_id                              in number   default null,
    p_region_id                       in number   default current_region_id,
    p_attribute_id                    in number   default null,
    p_attribute_value                 in varchar2 default null );

--==============================================================================
procedure create_region_rpt_cols (
    p_id                              in number,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_plug_id                         in number   default current_region_id,
    p_column_sequence                 in number,
    p_query_column_name               in varchar2,
    p_display_as                      in varchar2 default null,
    p_named_lov                       in number   default null,
    p_inline_lov                      in varchar2 default null,
    p_lov_show_nulls                  in varchar2 default null,
    p_lov_null_text                   in varchar2 default null,
    p_lov_null_value                  in varchar2 default null,
    p_column_width                    in number   default null,
    p_column_height                   in number   default null,
    p_cattributes                     in varchar2 default null,
    p_column_comment                  in varchar2 default null );

--==============================================================================
procedure create_region_column_group(
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_region_id                       in number   default current_region_id,
    p_heading                         in varchar2,
    p_label                           in varchar2 default null );

--==============================================================================
procedure create_region_column(
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_region_id                       in number   default current_region_id,
    p_name                            in varchar2,
    p_source_type                     in varchar2 default null,
    p_source_expression               in varchar2 default null,
    p_data_type                       in varchar2 default null,
    p_is_query_only                   in boolean  default null,
    p_item_type                       in varchar2 default null,
    p_is_visible                      in boolean  default null,
    p_heading                         in varchar2 default null,
    p_label                           in varchar2 default null,
    p_heading_alignment               in varchar2 default null,
    p_display_sequence                in number,
    p_value_alignment                 in varchar2 default null,
    p_value_css_classes               in varchar2 default null,
    p_value_attributes                in varchar2 default null,
    p_group_id                        in number   default null,
    p_use_group_for                   in varchar2 default null,
    p_stretch                         in varchar2 default null,
    --
    p_plugin_init_javascript_code     in varchar2 default null,
    --
    p_attribute_01                    in varchar2 default null,
    p_attribute_02                    in varchar2 default null,
    p_attribute_03                    in varchar2 default null,
    p_attribute_04                    in varchar2 default null,
    p_attribute_05                    in varchar2 default null,
    p_attribute_06                    in varchar2 default null,
    p_attribute_07                    in varchar2 default null,
    p_attribute_08                    in varchar2 default null,
    p_attribute_09                    in varchar2 default null,
    p_attribute_10                    in varchar2 default null,
    p_attribute_11                    in varchar2 default null,
    p_attribute_12                    in varchar2 default null,
    p_attribute_13                    in varchar2 default null,
    p_attribute_14                    in varchar2 default null,
    p_attribute_15                    in varchar2 default null,
    p_attribute_16                    in varchar2 default null,
    p_attribute_17                    in varchar2 default null,
    p_attribute_18                    in varchar2 default null,
    p_attribute_19                    in varchar2 default null,
    p_attribute_20                    in varchar2 default null,
    p_attribute_21                    in varchar2 default null,
    p_attribute_22                    in varchar2 default null,
    p_attribute_23                    in varchar2 default null,
    p_attribute_24                    in varchar2 default null,
    p_attribute_25                    in varchar2 default null,
    --
    p_format_mask                     in varchar2 default null,
    p_item_width                      in number   default null,
    p_item_height                     in number   default null,
    p_item_placeholder                in varchar2 default null,
    p_item_css_classes                in varchar2 default null,
    p_item_icon_css_classes           in varchar2 default null,
    p_item_attributes                 in varchar2 default null,
    p_is_required                     in boolean  default null,
    p_max_length                      in number   default null,
    p_lov_type                        in varchar2 default null,
    p_lov_language                    in varchar2 default null,
    p_lov_id                          in number   default null,
    p_lov_source                      in varchar2 default null,
    p_lov_display_extra               in boolean  default null,
    p_lov_display_null                in boolean  default null,
    p_lov_null_text                   in varchar2 default null,
    p_lov_null_value                  in varchar2 default null,
    p_lov_cascade_parent_items        in varchar2 default null,
    p_ajax_items_to_submit            in varchar2 default null,
    p_ajax_optimize_refresh           in boolean  default null,
    p_link_target                     in varchar2 default null,
    p_link_text                       in varchar2 default null,
    p_link_attributes                 in varchar2 default null,
    p_enable_filter                   in boolean  default null,
    p_filter_operators                in varchar2 default null,
    p_filter_is_required              in boolean  default null,
    p_filter_text_case                in varchar2 default null,
    p_filter_exact_match              in boolean  default null,
    p_filter_date_ranges              in varchar2 default null,
    p_filter_lov_type                 in varchar2 default null,
    p_filter_lov_language             in varchar2 default null,
    p_filter_lov_id                   in number   default null,
    p_filter_lov_query                in varchar2 default null,
    p_static_id                       in varchar2 default null,
    p_use_as_row_header               in boolean  default false,
    p_javascript_code                 in varchar2 default null,
    p_enable_sort_group               in boolean  default null,
    p_enable_control_break            in boolean  default null,
    p_enable_hide                     in boolean  default null,
    p_enable_pivot                    in boolean  default null,
    p_is_primary_key                  in boolean  default null,
    p_parent_column_id                in number   default null,
    p_default_type                    in varchar2 default null,
    p_default_language                in varchar2 default null,
    p_default_expression              in varchar2 default null,
    p_duplicate_value                 in boolean  default null,
    p_include_in_export               in boolean  default null,
    p_display_condition_type          in varchar2 default null,
    p_display_condition               in varchar2 default null,
    p_display_condition2              in varchar2 default null,
    p_readonly_condition_type         in varchar2 default null,
    p_readonly_condition              in varchar2 default null,
    p_readonly_condition2             in varchar2 default null,
    p_readonly_for_each_row           in boolean  default null,
    p_escape_on_http_output           in boolean  default null,
    p_security_scheme                 in varchar2 default null,
    p_restricted_characters           in varchar2 default null,
    p_help_text                       in varchar2 default null,
    p_required_patch                  in number   default null,
    p_column_comment                  in varchar2 default null );

--==============================================================================
--
-- F L A S H   C H A R T S
--
--==============================================================================
procedure create_flash_chart (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_region_id                       in number   default current_region_id,
    p_default_chart_type              in varchar2 default null,
    p_chart_title                     in varchar2 default null,
    p_chart_width                     in number   default null,
    p_chart_height                    in number   default null,
    p_chart_animation                 in varchar2 default null,
    p_display_attr                    in varchar2 default null,
    p_dial_tick_attr                  in varchar2 default null,
    p_margins                         in varchar2 default null,
    p_omit_label_interval             in number   default null,
    --
    p_bgtype                          in varchar2 default null,
    p_bgcolor1                        in varchar2 default null,
    p_bgcolor2                        in varchar2 default null,
    p_gradient_rotation               in number   default null,
    p_color_scheme                    in varchar2 default null,
    p_custom_colors                   in varchar2 default null,
    --
    p_x_axis_title                    in varchar2 default null,
    p_x_axis_min                      in number   default null,
    p_x_axis_max                      in number   default null,
    p_x_axis_grid_spacing             in number   default null,
    p_x_axis_prefix                   in varchar2 default null,
    p_x_axis_postfix                  in varchar2 default null,
    p_x_axis_group_sep                in varchar2 default null,
    p_x_axis_decimal_place            in number   default null,
    --
    p_y_axis_title                    in varchar2 default null,
    p_y_axis_min                      in number   default null,
    p_y_axis_max                      in number   default null,
    p_y_axis_grid_spacing             in number   default null,
    p_y_axis_prefix                   in varchar2 default null,
    p_y_axis_postfix                  in varchar2 default null,
    p_y_axis_group_sep                in varchar2 default null,
    p_y_axis_decimal_place            in number   default null,
    --
    p_async_update                    in varchar2 default null,
    p_async_time                      in number   default null,
    --
    p_names_font                      in varchar2 default null,
    p_names_rotation                  in number   default null,
    p_values_font                     in varchar2 default null,
    p_values_rotation                 in number   default null,
    p_hints_font                      in varchar2 default null,
    p_legend_font                     in varchar2 default null,
    p_grid_labels_font                in varchar2 default null,
    p_chart_title_font                in varchar2 default null,
    p_x_axis_title_font               in varchar2 default null,
    p_y_axis_title_font               in varchar2 default null,
    --
    p_use_chart_xml                   in varchar2 default null,
    p_chart_xml                       in varchar2 default null,
    p_attribute_01                    in varchar2 default null,
    p_attribute_02                    in varchar2 default null,
    p_attribute_03                    in varchar2 default null,
    p_attribute_04                    in varchar2 default null,
    p_attribute_05                    in varchar2 default null );

--==============================================================================
procedure create_flash_chart5 (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_region_id                       in number   default current_region_id,
    p_default_chart_type              in varchar2 default null,
    p_chart_title                     in varchar2 default null,
    p_chart_rendering                 in varchar2 default 'FLASH_PREFERRED',
    p_chart_name                      in varchar2 default null,
    p_chart_width                     in number   default null,
    p_chart_height                    in number   default null,
    p_chart_animation                 in varchar2 default null,
    p_display_attr                    in varchar2 default null,
    p_dial_tick_attr                  in varchar2 default null,
    p_gantt_attr                      in varchar2 default null,
    p_pie_attr                        in varchar2 default 'Outside:::',
    p_map_attr                        in varchar2 default null,
    p_map_source                      in varchar2 default null,
    p_margins                         in varchar2 default null,
    p_omit_label_interval             in number   default null,
    --
    p_bgtype                          in varchar2 default null,
    p_bgcolor1                        in varchar2 default null,
    p_bgcolor2                        in varchar2 default null,
    p_gradient_rotation               in number   default null,
    p_grid_bgtype                     in varchar2 default null,
    p_grid_bgcolor1                   in varchar2 default null,
    p_grid_bgcolor2                   in varchar2 default null,
    p_grid_gradient_rotation          in number   default null,
    p_color_scheme                    in varchar2 default null,
    p_custom_colors                   in varchar2 default null,
    p_map_undef_color_scheme          in varchar2 default null,
    p_map_undef_custom_colors         in varchar2 default null,
    --
    p_x_axis_title                    in varchar2 default null,
    p_x_axis_min                      in number   default null,
    p_x_axis_max                      in number   default null,
    p_x_axis_grid_spacing             in number   default null,  -- obsolete
    p_x_axis_decimal_place            in number   default null,
    p_x_axis_prefix                   in varchar2 default null,
    p_x_axis_postfix                  in varchar2 default null,
    p_x_axis_label_rotation           in varchar2 default null,
    p_x_axis_label_font               in varchar2 default null,
    p_x_axis_major_interval           in number   default null,
    p_x_axis_minor_interval           in number   default null,
    --
    p_y_axis_title                    in varchar2 default null,
    p_y_axis_min                      in number   default null,
    p_y_axis_max                      in number   default null,
    p_y_axis_grid_spacing             in number   default null,  -- obsolete
    p_y_axis_decimal_place            in number   default null,
    p_y_axis_prefix                   in varchar2 default null,
    p_y_axis_postfix                  in varchar2 default null,
    p_y_axis_label_rotation           in varchar2 default null,
    p_y_axis_label_font               in varchar2 default null,
    p_y_axis_major_interval           in number   default null,
    p_y_axis_minor_interval           in number   default null,
    --
    p_extra_y_axis_min                in number   default null,
    p_extra_y_axis_max                in number   default null,
    --
    p_async_update                    in varchar2 default null,
    p_async_time                      in number   default null,
    --
    p_legend_title                    in varchar2 default null,
    p_legend_title_font               in varchar2 default null,
    --
    p_names_font                      in varchar2 default null,
    p_names_rotation                  in number   default null,
    p_values_font                     in varchar2 default null,
    p_values_rotation                 in number   default null,
    p_values_prefix                   in varchar2 default null,
    p_values_postfix                  in varchar2 default null,
    p_hints_font                      in varchar2 default null,
    p_legend_font                     in varchar2 default null,
    p_grid_labels_font                in varchar2 default null,
    p_chart_title_font                in varchar2 default null,
    p_x_axis_title_font               in varchar2 default null,
    p_x_axis_title_rotation           in varchar2 default null,
    p_y_axis_title_font               in varchar2 default null,
    p_y_axis_title_rotation           in varchar2 default null,
    p_gauge_labels_font               in varchar2 default null,
    --
    p_use_chart_xml                   in varchar2 default null,
    p_chart_xml                       in varchar2 default null );

--==============================================================================
procedure create_flash_chart5_series (
    p_id                              in number   default null,
    p_chart_id                        in number   default null,
    p_flow_id                         in number   default null, -- defaults to chart's flow id
    p_series_seq                      in number   default null,
    p_series_name                     in varchar2 default null,
    p_series_query                    in varchar2 default null,
    p_series_type                     in varchar2 default null,
    p_series_required_role            in varchar2 default null,
    p_required_patch                  in number   default null,
    p_series_query_type               in varchar2 default null,
    p_series_ajax_items_to_submit     in varchar2 default null,
    p_series_query_parse_opt          in varchar2 default null,
    p_series_query_no_data_found      in varchar2 default null,
    p_series_query_row_count_max      in number   default null,
    p_action_link                     in varchar2 default null,
    p_show_action_link                in varchar2 default null,
    p_action_link_checksum_type       in varchar2 default null,
    p_display_when_cond_type          in varchar2 default null,
    p_display_when_condition          in varchar2 default null,
    p_display_when_condition2         in varchar2 default null );

--==============================================================================
--
-- J E T   C H A R T S
--
--==============================================================================
procedure create_jet_chart (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_region_id                       in number   default current_region_id,
    p_chart_type                      in varchar2 default 'area',
    p_title                           in varchar2 default null,
    p_width                           in varchar2 default null,
    p_height                          in varchar2 default null,
    p_animation_on_display            in varchar2 default 'auto',
    p_animation_on_data_change        in varchar2 default 'auto',
    p_orientation                     in varchar2 default null,
    p_data_cursor                     in varchar2 default null,
    p_data_cursor_behavior            in varchar2 default null,
    p_hide_and_show_behavior          in varchar2 default null,
    p_hover_behavior                  in varchar2 default null,
    p_stack                           in varchar2 default 'off',
    p_stack_label                     in varchar2 default 'off',
    p_stack_font_family               in varchar2 default null,
    p_stack_font_style                in varchar2 default null,
    p_stack_font_size                 in varchar2 default null,
    p_stack_font_color                in varchar2 default null,
    p_spark_chart                     in varchar2 default null,
    p_connect_nulls                   in varchar2 default c_y,
    p_stock_render_as                 in varchar2 default null,
    p_dial_indicator                  in varchar2 default null,
    p_dial_background                 in varchar2 default null,
    p_value_min                       in number   default null,
    p_value_text_type                 in varchar2 default null,
    p_value_position                  in varchar2 default 'auto',
    p_value_format_type               in varchar2 default null,
    p_value_decimal_places            in number   default null,
    p_value_currency                  in varchar2 default null,
    p_value_numeric_pattern           in varchar2 default null,
    p_value_format_scaling            in varchar2 default null,
    p_sorting                         in varchar2 default null,
    p_fill_multi_series_gaps          in boolean  default true,
    p_zoom_and_scroll                 in varchar2 default null,
    p_zoom_direction                  in varchar2 default null,
    p_initial_zooming                 in varchar2 default null,
    p_tooltip_rendered                in varchar2 default null,
    p_show_series_name                in boolean  default true,
    p_show_group_name                 in boolean  default true,
    p_show_value                      in boolean  default true,
    p_show_label                      in boolean  default true,
    p_show_row                        in boolean  default true,
    p_show_start                      in boolean  default true,
    p_show_end                        in boolean  default true,
    p_show_progress                   in boolean  default true,
    p_show_baseline                   in boolean  default true,
    p_custom_tooltip                  in varchar2 default null,
    p_legend_rendered                 in varchar2 default 'on',
    p_legend_title                    in varchar2 default null,
    p_legend_position                 in varchar2 default 'auto',
    p_legend_font_family              in varchar2 default null,
    p_legend_font_style               in varchar2 default null,
    p_legend_font_size                in varchar2 default null,
    p_legend_font_color               in varchar2 default null,
    p_overview_rendered               in varchar2 default 'off',
    p_overview_height                 in varchar2 default null,
    p_pie_other_threshold             in number   default null,
    p_pie_selection_effect            in varchar2 default null,
    p_time_axis_type                  in varchar2 default null,
    p_no_data_found_message           in varchar2 default null,
    p_horizontal_grid                 in varchar2 default 'auto',
    p_vertical_grid                   in varchar2 default 'auto',
    p_row_axis_rendered               in varchar2 default null,
    p_gantt_axis_position             in varchar2 default null,
    p_gauge_orientation               in varchar2 default 'circular',
    p_gauge_indicator_size            in number   default null,
    p_gauge_inner_radius              in number   default null,
    p_gauge_plot_area                 in varchar2 default 'on',
    p_gauge_start_angle               in number   default null,
    p_gauge_angle_extent              in number   default null,
    p_show_gauge_value                in boolean  default true,
    p_javascript_code                 in varchar2 default null,
    p_automatic_refresh_interval      in number   default null);

--==============================================================================
procedure create_jet_chart_axis (
    p_id                              in number   default null,
    p_chart_id                        in number   default null,
    p_static_id                       in varchar2 default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_axis                            in varchar2 default null,
    p_is_rendered                     in varchar2 default null,
    p_title                           in varchar2 default null,
    p_title_font_family               in varchar2 default null,
    p_title_font_style                in varchar2 default null,
    p_title_font_size                 in varchar2 default null,
    p_title_font_color                in varchar2 default null,
    p_min                             in number   default null,
    p_max                             in number   default null,
    p_format_type                     in varchar2 default null,
    p_decimal_places                  in number   default null,
    p_currency                        in varchar2 default null,
    p_numeric_pattern                 in varchar2 default null,
    p_format_scaling                  in varchar2 default null,
    p_scaling                         in varchar2 default null,
    p_baseline_scaling                in varchar2 default 'zero',
    p_step                            in number   default null,
    p_position                        in varchar2 default null,
    p_major_tick_rendered             in varchar2 default 'auto',
    p_min_step                        in number   default null,
    p_minor_tick_rendered             in varchar2 default 'auto',
    p_minor_step                      in number   default null,
    p_tick_label_rendered             in varchar2 default 'on',
    p_tick_label_rotation             in varchar2 default null,
    p_tick_label_position             in varchar2 default null,
    p_tick_label_font_family          in varchar2 default null,
    p_tick_label_font_style           in varchar2 default null,
    p_tick_label_font_size            in varchar2 default null,
    p_tick_label_font_color           in varchar2 default null,
    p_split_dual_y                    in varchar2 default null,
    p_splitter_position               in number   default null,
    p_axis_scale                      in varchar2 default null,
    p_zoom_order_seconds              in boolean  default false,
    p_zoom_order_minutes              in boolean  default false,
    p_zoom_order_hours                in boolean  default false,
    p_zoom_order_days                 in boolean  default false,
    p_zoom_order_weeks                in boolean  default false,
    p_zoom_order_months               in boolean  default false,
    p_zoom_order_quarters             in boolean  default false,
    p_zoom_order_years                in boolean  default false);

--==============================================================================
procedure create_jet_chart_series (
    p_id                              in number   default null,
    p_chart_id                        in number   default null,
    p_static_id                       in varchar2 default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_seq                             in number   default null,
    p_name                            in varchar2 default null,
    p_data_source_type                in varchar2 default null,
    p_function_body_language          in varchar2 default null,
    p_data_source                     in varchar2 default null,
    p_max_row_count                   in varchar2 default null,
    p_ajax_items_to_submit            in varchar2 default null,
    p_location                        in varchar2 default 'LOCAL',
    p_web_src_module_id               in number   default null,
    p_use_local_sync_table            in boolean  default null,
    p_remote_server_id                in number   default null,
    p_query_owner                     in varchar2 default null,
    p_query_table                     in varchar2 default null,
    p_query_where                     in varchar2 default null,
    p_query_order_by_type             in varchar2 default null,
    p_query_order_by                  in varchar2 default null,
    p_source_post_processing          in varchar2 default null,
    p_include_rowid_column            in boolean  default null,
    p_optimizer_hint                  in varchar2 default null,
    p_remote_sql_caching              in varchar2 default null,
    p_remote_sql_invalidate_when      in varchar2 default null,
    p_external_filter_expr            in varchar2 default null,
    p_external_order_by_type          in varchar2 default null,
    p_external_order_by_expr          in varchar2 default null,
    p_series_type                     in varchar2 default null,
    p_series_name_column_name         in varchar2 default null,
    p_items_value_column_name         in varchar2 default null,
    p_items_low_column_name           in varchar2 default null,
    p_items_high_column_name          in varchar2 default null,
    p_items_open_column_name          in varchar2 default null,
    p_items_close_column_name         in varchar2 default null,
    p_items_volume_column_name        in varchar2 default null,
    p_items_x_column_name             in varchar2 default null,
    p_items_y_column_name             in varchar2 default null,
    p_items_z_column_name             in varchar2 default null,
    p_items_target_value              in varchar2 default null,
    p_items_min_value                 in varchar2 default null,
    p_items_max_value                 in varchar2 default null,
    p_group_name_column_name          in varchar2 default null,
    p_group_short_desc_column_name    in varchar2 default null,
    p_items_label_column_name         in varchar2 default null,
    p_items_short_desc_column_name    in varchar2 default null,
    p_custom_column_name              in varchar2 default null,
    p_aggregate_function              in varchar2 default null,
    p_color                           in varchar2 default null,
    p_q2_color                        in varchar2 default null,
    p_q3_color                        in varchar2 default null,
    p_line_style                      in varchar2 default null,
    p_line_width                      in number   default null,
    p_line_type                       in varchar2 default null,
    p_marker_rendered                 in varchar2 default null,
    p_marker_shape                    in varchar2 default null,
    p_assigned_to_y2                  in varchar2 default null,
    p_stack_category                  in varchar2 default null,
    p_items_label_rendered            in boolean  default true,
    p_items_label_position            in varchar2 default null,
    p_items_label_display_as          in varchar2 default 'PERCENT',
    p_items_label_css_classes         in varchar2 default null,
    p_items_label_font_family         in varchar2 default null,
    p_items_label_font_style          in varchar2 default null,
    p_items_label_font_size           in varchar2 default null,
    p_items_label_font_color          in varchar2 default null,
    p_gantt_start_date_source         in varchar2 default null,
    p_gantt_start_date_column         in varchar2 default null,
    p_gantt_start_date_item           in varchar2 default null,
    p_gantt_end_date_source           in varchar2 default null,
    p_gantt_end_date_column           in varchar2 default null,
    p_gantt_end_date_item             in varchar2 default null,
    p_gantt_row_id                    in varchar2 default null,
    p_gantt_row_name                  in varchar2 default null,
    p_gantt_task_id                   in varchar2 default null,
    p_gantt_task_name                 in varchar2 default null,
    p_gantt_task_start_date           in varchar2 default null,
    p_gantt_task_end_date             in varchar2 default null,
    p_gantt_task_css_style            in varchar2 default null,
    p_gantt_task_css_class            in varchar2 default null,
    p_gantt_predecessor_task_id       in varchar2 default null,
    p_gantt_successor_task_id         in varchar2 default null,
    p_gantt_baseline_start_column     in varchar2 default null,
    p_gantt_baseline_end_column       in varchar2 default null,
    p_gantt_baseline_css_class        in varchar2 default null,
    p_gantt_progress_column           in varchar2 default null,
    p_gantt_progress_css_class        in varchar2 default null,
    p_gantt_viewport_start_source     in varchar2 default null,
    p_gantt_viewport_start_column     in varchar2 default null,
    p_gantt_viewport_start_item       in varchar2 default null,
    p_gantt_viewport_end_source       in varchar2 default null,
    p_gantt_viewport_end_column       in varchar2 default null,
    p_gantt_viewport_end_item         in varchar2 default null,
    p_task_label_position             in varchar2 default null,
    p_gauge_plot_area_color           in varchar2 default null,
    p_threshold_values                in varchar2 default null,
    p_threshold_colors                in varchar2 default null,
    p_threshold_display               in varchar2 default 'onIndicator',
    p_reference_line_values           in varchar2 default null,
    p_reference_line_colors           in varchar2 default null,
    p_link_target                     in varchar2 default null,
    p_link_target_type                in varchar2 default null,
    p_security_scheme                 in varchar2 default null,
    p_required_patch                  in number   default null,
    p_series_comment                  in varchar2 default null,
    p_display_when_cond_type          in varchar2 default null,
    p_display_when_condition          in varchar2 default null,
    p_display_when_condition2         in varchar2 default null );

--==============================================================================
--
-- C A R D
--
--==============================================================================
procedure create_card (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_region_id                       in number   default current_region_id,
    p_layout_type                     in varchar2 default 'GRID',
    p_grid_column_count               in number   default null,
    p_component_css_classes           in varchar2 default null,
    p_card_appearance                 in varchar2 default null,
    p_card_css_classes                in varchar2 default null,
    p_title_adv_formatting            in boolean  default false,
    p_title_column_name               in varchar2 default null,
    p_title_html_expr                 in varchar2 default null,
    p_title_css_classes               in varchar2 default null,
    p_sub_title_adv_formatting        in boolean  default false,
    p_sub_title_column_name           in varchar2 default null,
    p_sub_title_html_expr             in varchar2 default null,
    p_sub_title_css_classes           in varchar2 default null,
    p_body_adv_formatting             in boolean  default false,
    p_body_column_name                in varchar2 default null,
    p_body_html_expr                  in varchar2 default null,
    p_body_css_classes                in varchar2 default null,
    p_second_body_adv_formatting      in boolean  default false,
    p_second_body_column_name         in varchar2 default null,
    p_second_body_html_expr           in varchar2 default null,
    p_second_body_css_classes         in varchar2 default null,
    p_icon_source_type                in varchar2 default null,
    p_icon_class_column_name          in varchar2 default null,
    p_icon_blob_column_name           in varchar2 default null,
    p_icon_image_url                  in varchar2 default null,
    p_icon_css_classes                in varchar2 default null,
    p_icon_position                   in varchar2 default null,
    p_icon_description                in varchar2 default null,
    p_badge_column_name               in varchar2 default null,
    p_badge_label                     in varchar2 default null,
    p_badge_css_classes               in varchar2 default null,
    p_media_adv_formatting            in boolean  default false,
    p_media_html_expr                 in varchar2 default null,
    p_media_source_type               in varchar2 default null,
    p_media_url                       in varchar2 default null,
    p_media_url_column_name           in varchar2 default null,
    p_media_blob_column_name          in varchar2 default null,
    p_media_display_position          in varchar2 default null,
    p_media_appearance                in varchar2 default null,
    p_media_sizing                    in varchar2 default null,
    p_media_css_classes               in varchar2 default null,
    p_media_description               in varchar2 default null,
    p_pk1_column_name                 in varchar2 default null,
    p_pk2_column_name                 in varchar2 default null,
    p_mime_type_column_name           in varchar2 default null,
    p_last_updated_column_name        in varchar2 default null );

--==============================================================================
procedure create_card_action (
    p_id                              in number   default null,
    p_card_id                         in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_action_type                     in varchar2 default 'BUTTON',
    p_position                        in varchar2 default null,
    p_display_sequence                in number   default null,
    p_label                           in varchar2 default null,
    p_link_target_type                in varchar2 default null,
    p_link_target                     in varchar2 default null,
    p_link_attributes                 in varchar2 default null,
    p_button_display_type             in varchar2 default null,
    p_icon_css_classes                in varchar2 default null,
    p_action_css_classes              in varchar2 default null,
    p_is_hot                          in boolean  default null,
    p_condition_type                  in varchar2 default null,
    p_condition_expr1                 in varchar2 default null,
    p_condition_expr2                 in varchar2 default null,
    p_exec_cond_for_each_row          in boolean  default null,
    p_authorization_scheme            in varchar2 default null,
    p_build_option_id                 in number   default null,
    p_action_comments                 in varchar2 default null );

--==============================================================================
--
-- M A P
--
--==============================================================================
procedure create_map_region (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_region_id                       in number   default current_region_id,
    p_height                          in number,
    p_tilelayer_type                  in varchar2 default 'DEFAULT',
    p_tilelayer_name_default          in varchar2 default null,
    p_tilelayer_name_dark             in varchar2 default null,
    p_navigation_bar_type             in varchar2,
    p_navigation_bar_position         in varchar2 default null,
    p_init_position_zoom_type         in varchar2,
    p_init_position_from_browser      in boolean  default null,
    p_init_position_zoom_source       in varchar2 default null,
    p_init_position_geometry_type     in varchar2 default null,
    p_init_position_geometry_col      in varchar2 default null,
    p_init_position_lon_column        in varchar2 default null,
    p_init_position_lat_column        in varchar2 default null,
    p_init_zoomlevel_column           in varchar2 default null,
    p_init_position_lon_static        in varchar2 default null,
    p_init_position_lat_static        in varchar2 default null,
    p_init_zoomlevel_static           in varchar2 default null,
    p_layer_messages_position         in varchar2 default null,
    p_layer_messages_selector         in varchar2 default null,
    p_show_legend                     in boolean  default true,
    p_legend_title                    in varchar2 default null,
    p_legend_position                 in varchar2 default null,
    p_legend_position_selector        in varchar2 default null,
    p_legend_css_classes              in varchar2 default null,
    p_map_status_item                 in varchar2 default null,
    p_features                        in varchar2 default null,
    p_copyright_notice                in varchar2 default null,
    p_custom_styles                   in varchar2 default null,
    p_unit_system                     in varchar2 default 'METRIC',
    p_unit_system_page_item_name      in varchar2 default null );

--==============================================================================
procedure create_map_region_layer (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_map_region_id                   in number,
    p_name                            in varchar2,
    p_label                           in varchar2 default null,
    p_layer_type                      in varchar2,
    p_display_sequence                in number,
    p_visible_min_zoom_level          in number   default null,
    p_visible_max_zoom_level          in number   default null,
    p_location                        in varchar2,
    p_query_type                      in varchar2 default null,
    p_table_owner                     in varchar2 default null,
    p_table_name                      in varchar2 default null,
    p_where_clause                    in varchar2 default null,
    p_order_by_clause                 in varchar2 default null,
    p_include_rowid_column            in boolean  default null,
    p_layer_source                    in varchar2 default null,
    p_function_body_language          in varchar2 default null,
    p_optimizer_hint                  in varchar2 default null,
    p_web_src_module_id               in number   default null,
    p_use_local_sync_table            in boolean  default null,
    p_source_post_processing          in varchar2 default null,
    p_external_filter_expr            in varchar2 default null,
    p_external_order_by_expr          in varchar2 default null,
    p_remote_server_id                in number   default null,
    p_remote_sql_caching              in varchar2 default null,
    p_remote_sql_invalidate_when      in varchar2 default null,
    p_items_to_submit                 in varchar2 default null,
    p_max_row_count                   in number   default null,
    p_no_data_found_message           in varchar2 default null,
    p_no_data_found_icon_classes      in varchar2 default null,
    p_more_data_found_message         in varchar2 default null,
    p_has_spatial_index               in boolean  default null,
    p_row_assignment_column           in varchar2 default null,
    p_row_assignment_value            in varchar2 default null,
    p_pk_column                       in varchar2 default null,
    p_geometry_column_data_type       in varchar2,
    p_geometry_column                 in varchar2 default null,
    p_longitude_column                in varchar2 default null,
    p_latitude_column                 in varchar2 default null,
    p_stroke_color                    in varchar2 default null,
    p_stroke_width                    in number   default null,
    p_stroke_style                    in varchar2 default null,
    p_fill_color                      in varchar2 default null,
    p_fill_color_is_spectrum          in boolean  default null,
    p_fill_color_spectr_name          in varchar2 default null,
    p_fill_color_spectr_type          in varchar2 default null,
    p_fill_value_column               in varchar2 default null,
    p_fill_opacity                    in number   default null,
    p_extrude_value_column            in varchar2 default null,
    p_extrude_unit                    in varchar2 default null,
    p_point_display_type              in varchar2 default null,
    p_point_icon_source_type          in varchar2 default null,
    p_point_icon_class_column         in varchar2 default null,
    p_point_icon_image_url            in varchar2 default null,
    p_point_icon_css_classes          in varchar2 default null,
    p_point_svg_shape                 in varchar2 default null,
    p_point_svg_shape_scale           in varchar2 default null,
    p_feature_clustering              in boolean  default null,
    p_cluster_threshold_pixels        in number   default null,
    p_cluster_point_image_path        in varchar2 default null,
    p_cluster_point_css_classes       in varchar2 default null,
    p_cluster_point_svg_shape         in varchar2 default null,
    p_cluster_point_svg_shp_scale     in varchar2 default null,
    p_cluster_point_svg_fill_color    in varchar2 default null,
    p_cluster_tooltip                 in varchar2 default null,
    p_tooltip_adv_formatting          in boolean  default null,
    p_tooltip_column                  in varchar2 default null,
    p_tooltip_html_expr               in varchar2 default null,
    p_tooltip_css_classes             in varchar2 default null,
    p_info_window_adv_formatting      in boolean  default null,
    p_info_window_title_column        in varchar2 default null,
    p_info_window_body_column         in varchar2 default null,
    p_info_window_html_expr           in varchar2 default null,
    p_info_window_css_classes         in varchar2 default null,
    p_link_target_type                in varchar2 default null,
    p_link_target                     in varchar2 default null,
    p_display_in_legend               in boolean  default true,
    p_legend_icon_css_classes         in varchar2 default null,
    p_allow_hide                      in boolean  default null,
    p_condition_type                  in varchar2 default null,
    p_condition_expr1                 in varchar2 default null,
    p_condition_expr2                 in varchar2 default null,
    p_exec_cond_for_each_row          in boolean  default null,
    p_authorization_scheme            in varchar2 default null,
    p_build_option_id                 in number   default null,
    p_layer_comments                  in varchar2 default null );

--==============================================================================
--
-- I N T E R A C T I V E   R E P O R T S
--
--==============================================================================
procedure create_worksheet (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_region_id                       in number   default current_region_id,
    p_name                            in varchar2 default null,
    p_folder_id                       in number   default null,
    p_alias                           in varchar2 default null,
    p_report_id_item                  in varchar2 default null,
    p_max_row_count                   in varchar2 default null,
    p_max_row_count_message           in varchar2 default null,
    p_no_data_found_message           in varchar2 default null,
    p_max_rows_per_page               in varchar2 default null,
    p_search_button_label             in varchar2 default null,
    p_page_items_to_submit            in varchar2 default null, -- obsolete, is stored in wwv_flow_page_plugs.ajax_items_to_submit now
    p_sort_asc_image                  in varchar2 default null,
    p_sort_asc_image_attr             in varchar2 default null,
    p_sort_desc_image                 in varchar2 default null,
    p_sort_desc_image_attr            in varchar2 default null,
    --
    p_sql_query                       in varchar2 default null,
    p_base_table_or_view              in varchar2 default null,
    p_base_pk1                        in varchar2 default null,
    p_base_pk2                        in varchar2 default null,
    p_base_pk3                        in varchar2 default null,
    p_sql_hint                        in varchar2 default null,
    p_oracle_text_index_column        in varchar2 default null,
    --
    p_status                          in varchar2 default 'AVAILABLE_FOR_OWNER',
    --
    p_allow_report_saving             in varchar2 default c_y,
    p_allow_save_rpt_public           in varchar2 default c_n,
    p_save_rpt_public_auth_scheme     in varchar2 default null,
    p_allow_report_categories         in varchar2 default c_y,
    p_show_nulls_as                   in varchar2 default null,
    p_pagination_type                 in varchar2 default null,
    p_pagination_display_pos          in varchar2 default null,
    p_button_template                 in number   default null,  -- obsolete
    p_show_finder_drop_down           in varchar2 default c_y,
    p_show_display_row_count          in varchar2 default c_n,
    p_show_search_bar                 in varchar2 default c_y,
    p_show_search_textbox             in varchar2 default c_y,
    p_show_actions_menu               in varchar2 default c_y,
    p_actions_menu_icon               in varchar2 default null,  -- obsolete
    p_finder_icon                     in varchar2 default null,  -- obsolete
    p_report_list_mode                in varchar2 default null,
    p_fixed_header                    in varchar2 default 'PAGE',
    p_fixed_header_max_height         in number   default null,
    --
    p_lazy_loading                    in boolean  default false,
    --
    p_show_detail_link                in varchar2 default c_y,
    p_show_select_columns             in varchar2 default c_y,
    p_show_rows_per_page              in varchar2 default c_y,
    p_show_filter                     in varchar2 default c_y,
    p_show_sort                       in varchar2 default c_y,
    p_show_control_break              in varchar2 default c_y,
    p_show_highlight                  in varchar2 default c_y,
    p_show_computation                in varchar2 default c_y,
    p_show_aggregate                  in varchar2 default c_y,
    p_show_chart                      in varchar2 default c_y,
    p_show_group_by                   in varchar2 default c_y,
    p_show_pivot                      in varchar2 default c_y,
    p_show_notify                     in varchar2 default c_n,
    p_show_calendar                   in varchar2 default c_y,
    p_show_flashback                  in varchar2 default c_y,
    p_show_reset                      in varchar2 default c_y,
    p_show_download                   in varchar2 default c_y,
    p_show_help                       in varchar2 default c_y,
    p_download_auth_scheme            in varchar2 default null,
    p_download_formats                in varchar2 default null,
    p_download_filename               in varchar2 default null,
    p_enable_mail_download            in varchar2 default c_y,
    p_csv_output_separator            in varchar2 default null,
    p_csv_output_enclosed_by          in varchar2 default null,
    p_supplemental_text               in varchar2 default null,
    --
    p_email_from                      in varchar2 default null,
    --
    p_detail_link                     in varchar2 default null,
    p_detail_link_text                in varchar2 default null,
    p_detail_link_attr                in varchar2 default null,
    p_detail_link_checksum_type       in varchar2 default null,
    p_detail_link_condition_type      in varchar2 default null,
    p_detail_link_cond                in varchar2 default null,
    p_detail_link_cond2               in varchar2 default null,
    p_detail_link_auth_scheme         in varchar2 default null,
    --
    p_allow_exclude_null_values       in varchar2 default c_y,
    p_allow_hide_extra_columns        in varchar2 default c_y,
    --
    p_max_query_cost                  in varchar2 default null,
    p_max_flashback                   in varchar2 default null,
    p_worksheet_flags                 in varchar2 default null,
    --
    p_icon_view_enabled_yn            in varchar2 default c_n,
    p_icon_view_use_custom            in varchar2 default c_n,
    p_icon_view_custom_link           in varchar2 default null,
    p_icon_view_link_column           in varchar2 default null,
    p_icon_view_img_src_column        in varchar2 default null,
    p_icon_view_label_column          in varchar2 default null,
    p_icon_view_img_attr_text         in varchar2 default null,
    p_icon_view_alt_text              in varchar2 default null,
    p_icon_view_title_text            in varchar2 default null,
    p_icon_view_columns_per_row       in number   default null,
    p_detail_view_enabled_yn          in varchar2 default c_n,
    p_detail_view_before_rows         in varchar2 default null,
    p_detail_view_for_each_row        in varchar2 default null,
    p_detail_view_after_rows          in varchar2 default null,
    --
    p_description                     in varchar2 default null,
    p_owner                           in varchar2 default null,
    --
    p_internal_uid                    in number default null );

--==============================================================================
procedure create_worksheet_column (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_worksheet_id                    in number   default current_worksheet_id,
    p_websheet_id                     in number   default null,  -- obsolte in 22.1
    --
    p_db_column_name                  in varchar2 default null,
    p_display_order                   in number   default null,
    p_group_id                        in number   default null,
    p_column_identifier               in varchar2 default null,
    p_column_expr                     in varchar2 default null,
    p_column_label                    in varchar2 default null,
    p_report_label                    in varchar2 default null,
    p_sync_form_label                 in varchar2 default c_y,
    --
    p_display_in_default_rpt          in varchar2 default c_y,
    p_column_html_expression          in varchar2 default null,
    p_column_link                     in varchar2 default null,
    p_column_linktext                 in varchar2 default null,
    p_column_link_attr                in varchar2 default null,
    p_column_link_checksum_type       in varchar2 default null,
    --
    p_is_sortable                     in varchar2 default c_y,
    p_allow_sorting                   in varchar2 default c_y,
    p_allow_filtering                 in varchar2 default c_y,
    p_allow_highlighting              in varchar2 default c_y,
    p_allow_ctrl_breaks               in varchar2 default c_y,
    p_allow_aggregations              in varchar2 default c_y,
    p_allow_computations              in varchar2 default c_y,
    p_allow_charting                  in varchar2 default c_y,
    p_allow_group_by                  in varchar2 default c_y,
    p_allow_pivot                     in varchar2 default c_y,
    p_allow_hide                      in varchar2 default c_y,
    --
    p_use_custom                      in varchar2 default null,
    p_custom_filter                   in varchar2 default null,
    p_base_column                     in varchar2 default null,
    p_allow_filters                   in varchar2 default null,
    --
    p_others_may_edit                 in varchar2 default c_y,
    p_others_may_view                 in varchar2 default c_y,
    --
    p_column_type                     in varchar2 default null,
    p_display_as                      in varchar2 default 'TEXT',
    p_display_text_as                 in varchar2 default 'ESCAPE_SC',
    p_heading_alignment               in varchar2 default 'CENTER',
    p_column_alignment                in varchar2 default 'LEFT',
    p_max_length                      in number   default null,
    p_display_width                   in number   default null,
    p_display_height                  in number   default null,
    --
    p_allow_null                      in varchar2 default null,
    p_format_mask                     in varchar2 default null,
    p_tz_dependent                    in varchar2 default null,
    p_static_id                       in varchar2 default null,
    p_css_classes                     in varchar2 default null,
    --
    p_rich_text_format                in varchar2 default null,
    --
    p_fact_table_key                  in varchar2 default null,
    p_dimension_table                 in varchar2 default null,
    p_dimension_table_id              in varchar2 default null,
    p_dimension_table_value           in varchar2 default null,
    --
    p_rpt_distinct_lov                in varchar2 default null,
    p_rpt_lov                         in varchar2 default null,
    p_rpt_named_lov                   in number   default null,
    p_rpt_show_filter_lov             in varchar2 default 'D',
    p_rpt_filter_date_ranges          in varchar2 default 'ALL',
    --
    p_static_lov                      in varchar2 default null,
    p_lov_null_text                   in varchar2 default null,
    p_lov_allow_new_values            in varchar2 default null,
    p_lov_is_distinct_values          in varchar2 default null,
    p_lov_num_columns                 in number   default null,
    p_lov_id                          in number   default null,
    --
    p_computation_type                in varchar2 default null,
    p_computation_expr_1              in varchar2 default null,
    p_computation_expr_2              in varchar2 default null,
    --
    p_validation_type                 in varchar2 default null,
    p_validation_expr_1               in varchar2 default null,
    p_validation_expr_2               in varchar2 default null,
    --
    p_display_condition_type          in varchar2 default null,
    p_display_condition               in varchar2 default null,
    p_display_condition2              in varchar2 default null,
    --
    p_use_as_row_header               in varchar2 default c_n,
    p_default_value                   in varchar2 default null,
    p_default_when                    in varchar2 default null,
    p_help_text                       in varchar2 default null,
    p_security_scheme                 in varchar2 default null,
    p_column_flags                    in varchar2 default null,
    p_required_patch                  in number   default null,
    p_column_comment                  in varchar2 default null );

--==============================================================================
procedure create_worksheet_col_group (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_worksheet_id                    in number   default current_worksheet_id,
    p_websheet_id                     in number   default null,  -- obsolte in 22.1
    p_name                            in varchar2 default null,
    p_description                     in varchar2 default null,
    p_display_sequence                in number   default null );

--==============================================================================
procedure create_worksheet_rpt (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_worksheet_id                    in number   default current_worksheet_id,
    p_websheet_id                     in number   default null,  -- obsolte in 22.1
    p_session_id                      in number   default null,
    p_base_report_id                  in number   default null,
    p_application_user                in varchar2 default null,
    p_name                            in varchar2 default null,
    p_description                     in varchar2 default null,
    p_report_seq                      in number   default null,
    p_report_type                     in varchar2 default null,
    p_report_alias                    in varchar2 default null,
    p_status                          in varchar2 default 'PRIVATE',
    p_category_id                     in number   default null,
    p_autosave                        in varchar2 default null,
    p_is_default                      in varchar2 default c_n,
    --
    p_display_rows                    in number   default 50,
    p_view_mode                       in varchar2 default null,
    p_report_columns                  in varchar2 default null,
    --
    p_sort_column_1                   in varchar2 default null,
    p_sort_direction_1                in varchar2 default null,
    p_sort_column_2                   in varchar2 default null,
    p_sort_direction_2                in varchar2 default null,
    p_sort_column_3                   in varchar2 default null,
    p_sort_direction_3                in varchar2 default null,
    p_sort_column_4                   in varchar2 default null,
    p_sort_direction_4                in varchar2 default null,
    p_sort_column_5                   in varchar2 default null,
    p_sort_direction_5                in varchar2 default null,
    p_sort_column_6                   in varchar2 default null,
    p_sort_direction_6                in varchar2 default null,
    --
    p_break_on                        in varchar2 default null,
    p_break_enabled_on                in varchar2 default null,
    p_control_break_options           in varchar2 default null,
    --
    p_sum_columns_on_break            in varchar2 default null,
    p_avg_columns_on_break            in varchar2 default null,
    p_max_columns_on_break            in varchar2 default null,
    p_min_columns_on_break            in varchar2 default null,
    p_median_columns_on_break         in varchar2 default null,
    p_mode_columns_on_break           in varchar2 default null,
    p_count_columns_on_break          in varchar2 default null,
    p_count_distnt_col_on_break       in varchar2 default null,
    --
    p_flashback_mins_ago              in varchar2 default null,
    p_flashback_enabled               in varchar2 default c_n,
    --
    p_chart_type                      in varchar2 default null,
    p_chart_3d                        in varchar2 default null,
    p_chart_label_column              in varchar2 default null,
    p_chart_label_title               in varchar2 default null,
    p_chart_value_column              in varchar2 default null,
    p_chart_aggregate                 in varchar2 default null,
    p_chart_value_title               in varchar2 default null,
    p_chart_sorting                   in varchar2 default null,
    p_chart_orientation               in varchar2 default null,
    --
    p_calendar_date_column            in varchar2 default null,
    p_calendar_display_column         in varchar2 default null );

--==============================================================================
procedure create_worksheet_condition (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_worksheet_id                    in number   default current_worksheet_id,
    p_websheet_id                     in number   default null,  -- obsolte in 22.1
    p_report_id                       in number   default null,
    p_name                            in varchar2 default null,
    p_condition_type                  in varchar2 default null,
    p_allow_delete                    in varchar2 default null,
    --
    p_column_name                     in varchar2 default null,
    p_operator                        in varchar2 default null,
    p_expr_type                       in varchar2 default null,
    p_expr                            in varchar2 default null,
    p_expr2                           in varchar2 default null,
    p_time_zone                       in varchar2 default null,
    p_condition_sql                   in varchar2 default null,
    p_condition_display               in varchar2 default null,
    --
    p_enabled                         in varchar2 default null,
    --
    p_highlight_sequence              in number   default null,
    p_row_bg_color                    in varchar2 default null,
    p_row_font_color                  in varchar2 default null,
    p_row_format                      in varchar2 default null,
    p_column_bg_color                 in varchar2 default null,
    p_column_font_color               in varchar2 default null,
    p_column_format                   in varchar2 default null );

--==============================================================================
procedure create_worksheet_computation (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_worksheet_id                    in number   default current_worksheet_id,
    p_websheet_id                     in number   default null,  -- obsolte in 22.1
    p_report_id                       in number   default null,
    --
    p_db_column_name                  in varchar2 default null,
    p_column_identifier               in varchar2 default null,
    p_computation_expr                in varchar2 default null,
    p_format_mask                     in varchar2 default null,
    p_column_type                     in varchar2 default null,
    --
    p_column_label                    in varchar2 default null,
    p_report_label                    in varchar2 default null );

--==============================================================================
procedure create_worksheet_group_by (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_worksheet_id                    in number   default current_worksheet_id,
    p_websheet_id                     in number   default null,  -- obsolte in 22.1
    p_report_id                       in number   default null,
    --
    p_group_by_columns                in varchar2 default null,
    p_function_01                     in varchar2 default null,
    p_function_column_01              in varchar2 default null,
    p_function_db_column_name_01      in varchar2 default null,
    p_function_label_01               in varchar2 default null,
    p_function_format_mask_01         in varchar2 default null,
    p_function_sum_01                 in varchar2 default null,
    p_function_02                     in varchar2 default null,
    p_function_column_02              in varchar2 default null,
    p_function_db_column_name_02      in varchar2 default null,
    p_function_label_02               in varchar2 default null,
    p_function_format_mask_02         in varchar2 default null,
    p_function_sum_02                 in varchar2 default null,
    p_function_03                     in varchar2 default null,
    p_function_column_03              in varchar2 default null,
    p_function_db_column_name_03      in varchar2 default null,
    p_function_label_03               in varchar2 default null,
    p_function_format_mask_03         in varchar2 default null,
    p_function_sum_03                 in varchar2 default null,
    p_function_04                     in varchar2 default null,
    p_function_column_04              in varchar2 default null,
    p_function_db_column_name_04      in varchar2 default null,
    p_function_label_04               in varchar2 default null,
    p_function_format_mask_04         in varchar2 default null,
    p_function_sum_04                 in varchar2 default null,
    p_function_05                     in varchar2 default null,
    p_function_column_05              in varchar2 default null,
    p_function_db_column_name_05      in varchar2 default null,
    p_function_label_05               in varchar2 default null,
    p_function_format_mask_05         in varchar2 default null,
    p_function_sum_05                 in varchar2 default null,
    p_function_06                     in varchar2 default null,
    p_function_column_06              in varchar2 default null,
    p_function_db_column_name_06      in varchar2 default null,
    p_function_label_06               in varchar2 default null,
    p_function_format_mask_06         in varchar2 default null,
    p_function_sum_06                 in varchar2 default null,
    p_function_07                     in varchar2 default null,
    p_function_column_07              in varchar2 default null,
    p_function_db_column_name_07      in varchar2 default null,
    p_function_label_07               in varchar2 default null,
    p_function_format_mask_07         in varchar2 default null,
    p_function_sum_07                 in varchar2 default null,
    p_function_08                     in varchar2 default null,
    p_function_column_08              in varchar2 default null,
    p_function_db_column_name_08      in varchar2 default null,
    p_function_label_08               in varchar2 default null,
    p_function_format_mask_08         in varchar2 default null,
    p_function_sum_08                 in varchar2 default null,
    p_function_09                     in varchar2 default null,
    p_function_column_09              in varchar2 default null,
    p_function_db_column_name_09      in varchar2 default null,
    p_function_label_09               in varchar2 default null,
    p_function_format_mask_09         in varchar2 default null,
    p_function_sum_09                 in varchar2 default null,
    p_function_10                     in varchar2 default null,
    p_function_column_10              in varchar2 default null,
    p_function_db_column_name_10      in varchar2 default null,
    p_function_label_10               in varchar2 default null,
    p_function_format_mask_10         in varchar2 default null,
    p_function_sum_10                 in varchar2 default null,
    p_function_11                     in varchar2 default null,
    p_function_column_11              in varchar2 default null,
    p_function_db_column_name_11      in varchar2 default null,
    p_function_label_11               in varchar2 default null,
    p_function_format_mask_11         in varchar2 default null,
    p_function_sum_11                 in varchar2 default null,
    p_function_12                     in varchar2 default null,
    p_function_column_12              in varchar2 default null,
    p_function_db_column_name_12      in varchar2 default null,
    p_function_label_12               in varchar2 default null,
    p_function_format_mask_12         in varchar2 default null,
    p_function_sum_12                 in varchar2 default null,
    p_sort_column_01                  in varchar2 default null,
    p_sort_direction_01               in varchar2 default null,
    p_sort_column_02                  in varchar2 default null,
    p_sort_direction_02               in varchar2 default null,
    p_sort_column_03                  in varchar2 default null,
    p_sort_direction_03               in varchar2 default null,
    p_sort_column_04                  in varchar2 default null,
    p_sort_direction_04               in varchar2 default null,
    p_sort_column_05                  in varchar2 default null,
    p_sort_direction_05               in varchar2 default null,
    p_sort_column_06                  in varchar2 default null,
    p_sort_direction_06               in varchar2 default null,
    p_sort_column_07                  in varchar2 default null,
    p_sort_direction_07               in varchar2 default null,
    p_sort_column_08                  in varchar2 default null,
    p_sort_direction_08               in varchar2 default null,
    p_sort_column_09                  in varchar2 default null,
    p_sort_direction_09               in varchar2 default null,
    p_sort_column_10                  in varchar2 default null,
    p_sort_direction_10               in varchar2 default null,
    p_sort_column_11                  in varchar2 default null,
    p_sort_direction_11               in varchar2 default null,
    p_sort_column_12                  in varchar2 default null,
    p_sort_direction_12               in varchar2 default null );

--==============================================================================
procedure create_worksheet_notify (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_worksheet_id                    in number   default current_worksheet_id,
    p_websheet_id                     in number   default null,  -- obsolte in 22.1
    p_report_id                       in number   default null,
    p_session_id                      in number   default null,
    p_owner                           in varchar2 default null,
    p_language                        in varchar2 default null,
    p_download_format                 in varchar2 default 'HTML',
    p_strip_rich_text                 in varchar2 default null,
    p_data_only                       in varchar2 default null,
    p_pdf_page_size                   in varchar2 default null,
    p_pdf_page_orientation            in varchar2 default null,
    p_pdf_accessible                  in varchar2 default null,
    p_skip_no_data_found              in varchar2 default c_n,
    p_email_from                      in varchar2 default null,
    p_email_subject                   in varchar2 default null,
    p_email_address                   in varchar2 default null,
    p_start_date                      in varchar2 default null,
    p_end_date                        in varchar2 default null,
    p_end_day                         in number   default null,
    p_end_day_unit                    in varchar2 default null,
    p_offset_date                     in varchar2 default null,
    p_notify_interval                 in varchar2 default null,
    p_status                          in varchar2 default null,
    p_notify_error                    in varchar2 default null );

--==============================================================================
procedure create_worksheet_pivot (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_worksheet_id                    in number   default current_worksheet_id,
    p_websheet_id                     in number   default null,  -- obsolte in 22.1
    p_report_id                       in number   default null,
    --
    p_pivot_columns                   in varchar2 default null,
    p_row_columns                     in varchar2 default null );

--==============================================================================
procedure create_worksheet_pivot_agg (
    p_id                              in number   default null,
    p_pivot_id                        in number   default null,
    p_display_seq                     in number   default null,
    p_function_name                   in varchar2 default null,
    p_column_name                     in varchar2 default null,
    p_db_column_name                  in varchar2 default null,
    p_column_label                    in varchar2 default null,
    p_format_mask                     in varchar2 default null,
    p_display_sum                     in varchar2 default c_n );

--==============================================================================
procedure create_worksheet_pivot_sort (
    p_id                              in number   default null,
    p_pivot_id                        in number   default null,
    p_sort_seq                        in number   default null,
    p_sort_column_name                in varchar2 default null,
    p_sort_direction                  in varchar2 default null );

--==============================================================================
--
-- I N T E R A C T I V E   G R I D
--
--==============================================================================
procedure create_interactive_grid(
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_region_id                       in number   default current_region_id,
    p_internal_uid                    in number   default null,
    p_is_editable                     in boolean  default false,
    p_edit_operations                 in varchar2 default null,
    p_edit_row_operations_column      in varchar2 default null,
    p_add_authorization_scheme        in varchar2 default null,
    p_update_authorization_scheme     in varchar2 default null,
    p_delete_authorization_scheme     in varchar2 default null,
    p_lost_update_check_type          in varchar2 default null,
    p_row_version_column              in varchar2 default null,
    p_add_row_if_empty                in boolean  default null,
    p_submit_checked_rows             in boolean  default null,
    p_lazy_loading                    in boolean  default false,
    p_requires_filter                 in boolean  default false,
    p_max_row_count                   in number   default null,
    p_show_nulls_as                   in varchar2 default null,
    p_select_first_row                in boolean  default true,
    p_fixed_row_height                in boolean  default true,
    p_pagination_type                 in varchar2 default 'SCROLL',
    p_show_total_row_count            in boolean  default true,
    p_no_data_found_message           in varchar2 default null,
    p_max_row_count_message           in varchar2 default null,
    p_show_toolbar                    in boolean  default true,
    p_toolbar_buttons                 in varchar2 default 'SEARCH_COLUMN:SEARCH_FIELD:ACTIONS_MENU:RESET:SAVE',
    p_add_button_label                in varchar2 default null,
    p_enable_save_public_report       in boolean  default false,
    p_public_report_auth_scheme       in varchar2 default null,
    p_enable_subscriptions            in boolean  default true,
    p_enable_flashback                in boolean  default true,
    p_define_chart_view               in boolean  default true,
    p_enable_download                 in boolean  default true,
    p_download_auth_scheme            in varchar2 default null,
    p_download_formats                in varchar2 default 'CSV:HTML:PDF:XLSX',
    p_download_filename               in varchar2 default null,
    p_enable_mail_download            in boolean  default true,
    p_csv_separator                   in varchar2 default null,
    p_csv_enclosed_by                 in varchar2 default null,
    p_supplemental_text               in varchar2 default null,
    p_fixed_header                    in varchar2 default 'PAGE',
    p_fixed_header_max_height         in number   default null,
    p_show_icon_view                  in boolean  default false,
    p_icon_view_use_custom            in boolean  default null,
    p_icon_view_custom                in varchar2 default null,
    p_icon_view_icon_type             in varchar2 default null,
    p_icon_view_icon_column           in varchar2 default null,
    p_icon_view_icon_attributes       in varchar2 default null,
    p_icon_view_link_target           in varchar2 default null,
    p_icon_view_link_attributes       in varchar2 default null,
    p_icon_view_label_column          in varchar2 default null,
    p_show_detail_view                in boolean  default false,
    p_detail_view_before_rows         in varchar2 default null,
    p_detail_view_for_each_row        in varchar2 default null,
    p_detail_view_after_rows          in varchar2 default null,
    p_oracle_text_index_column        in varchar2 default null,
    p_email_from                      in varchar2 default null,
    p_javascript_code                 in varchar2 default null,
    p_help_text                       in varchar2 default null );

--==============================================================================
procedure create_ig_report(
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_interactive_grid_id             in number,
    p_name                            in varchar2 default null,
    p_static_id                       in varchar2 default null,
    p_description                     in varchar2 default null,
    p_type                            in varchar2,
    p_default_view                    in varchar2,
    p_authorization_scheme            in varchar2 default null,
    p_application_user                in varchar2 default null,
    p_rows_per_page                   in number   default null,
    p_show_row_number                 in boolean  default false,
    p_settings_area_expanded          in boolean  default true,
    p_flashback_mins_ago              in number   default null,
    p_flashback_is_enabled            in boolean  default null );

--==============================================================================
procedure create_ig_report_view(
    p_id                              in number   default null,
    p_report_id                       in number,
    p_view_type                       in varchar2,
    p_breaks_expanded                 in boolean  default null,
    p_stretch_columns                 in boolean  default null,
    p_srv_exclude_null_values         in boolean  default null,
    p_srv_only_display_columns        in boolean  default null,
    p_edit_mode                       in boolean  default null,
    p_chart_type                      in varchar2 default null,
    p_chart_orientation               in varchar2 default null,
    p_chart_stack                     in varchar2 default null,
    p_axis_label                      in varchar2 default null,
    p_axis_value                      in varchar2 default null,
    p_axis_value_decimal_places       in number   default null );

--==============================================================================
procedure create_ig_report_compute(
    p_id                              in number   default null,
    p_report_id                       in number,
    p_view_id                         in number   default null,
    p_function                        in varchar2,
    p_column_id                       in number   default null,
    p_comp_column_id                  in number   default null,
    p_partition_by_clause             in varchar2 default null,
    p_order_by_clause                 in varchar2 default null,
    p_sql_expression                  in varchar2 default null,
    p_data_type                       in varchar2 default null,
    p_heading                         in varchar2 default null,
    p_label                           in varchar2 default null,
    p_heading_alignment               in varchar2 default null,
    p_column_alignment                in varchar2 default null,
    p_group_id                        in number   default null,
    p_use_group_for                   in varchar2 default null,
    p_format_mask                     in varchar2 default null,
    p_is_enabled                      in boolean  default true );

--==============================================================================
procedure create_ig_report_filter(
    p_id                              in number   default null,
    p_report_id                       in number,
    p_view_id                         in number   default null,
    p_type                            in varchar2,
    p_name                            in varchar2 default null,
    p_column_id                       in number   default null,
    p_comp_column_id                  in number   default null,
    p_operator                        in varchar2 default null,
    p_is_case_sensitive               in boolean  default null,
    p_expression                      in varchar2 default null,
    p_is_enabled                      in boolean  default true );

--==============================================================================
procedure create_ig_report_column(
    p_id                              in number   default null,
    p_view_id                         in number,
    p_display_seq                     in number,
    p_column_id                       in number   default null,
    p_comp_column_id                  in number   default null,
    p_is_visible                      in boolean  default true,
    p_is_frozen                       in boolean  default false,
    p_width                           in number   default null,
    p_priority                        in number   default null,
    p_sort_order                      in number   default null,
    p_break_order                     in number   default null,
    p_break_is_enabled                in boolean  default null,
    p_break_sort_direction            in varchar2 default null,
    p_break_sort_nulls                in varchar2 default null,
    p_sort_direction                  in varchar2 default null,
    p_sort_nulls                      in varchar2 default null );

--==============================================================================
procedure create_ig_report_highlight(
    p_id                              in number   default null,
    p_view_id                         in number,
    p_execution_seq                   in number,
    p_name                            in varchar2,
    p_column_id                       in number   default null,
    p_comp_column_id                  in number   default null,
    p_background_color                in varchar2 default null,
    p_text_color                      in varchar2 default null,
    p_condition_type                  in varchar2,
    p_condition_column_id             in number   default null,
    p_condition_comp_column_id        in number   default null,
    p_condition_operator              in varchar2 default null,
    p_condition_is_case_sensitive     in boolean  default null,
    p_condition_expression            in varchar2 default null,
    p_is_enabled                      in boolean  default true );

--==============================================================================
procedure create_ig_report_aggregate(
    p_id                              in number   default null,
    p_view_id                         in number,
    p_tooltip                         in varchar2 default null,
    p_function                        in varchar2,
    p_column_id                       in number   default null,
    p_comp_column_id                  in number   default null,
    p_show_grand_total                in boolean  default true,
    p_is_enabled                      in boolean  default true );

--==============================================================================
procedure create_ig_report_chart_col(
    p_id                              in number   default null,
    p_view_id                         in number,
    p_column_type                     in varchar2,
    p_column_id                       in number   default null,
    p_comp_column_id                  in number   default null,
    p_function                        in varchar2 default null,
    p_sort_order                      in number   default null,
    p_sort_direction                  in varchar2 default null,
    p_sort_nulls                      in varchar2 default null );

--==============================================================================
--
-- M I S C E L L A N E O U S
--
--==============================================================================
procedure set_page_help_text(
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_flow_step_id                    in number   default null,
    p_text                            in varchar2 default null);

--==============================================================================
procedure set_html_page_header(
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_flow_step_id                    in number   default null,
    p_text                            in varchar2 default null);

--==============================================================================
procedure update_page_item (
    p_flow_id                         in number,
    p_page_id                         in number,
    p_item_id                         in number,
    p_new_sequence                    in number,
    p_display_as                      in varchar2,
    p_new_name                        in varchar2,
    p_new_label                       in varchar2,
    p_new_begin_new_line              in varchar2,
    p_new_begin_new_field             in varchar2,
    p_attribute_01                    in varchar2,
    p_attribute_02                    in varchar2,
    p_attribute_03                    in varchar2,
    p_attribute_04                    in varchar2,
    p_attribute_05                    in varchar2,
    p_attribute_06                    in varchar2,
    p_attribute_07                    in varchar2,
    p_attribute_08                    in varchar2,
    p_attribute_09                    in varchar2,
    p_attribute_10                    in varchar2,
    p_attribute_11                    in varchar2,
    p_attribute_12                    in varchar2,
    p_attribute_13                    in varchar2,
    p_attribute_14                    in varchar2,
    p_attribute_15                    in varchar2);

--==============================================================================
--
-- L E G A C Y
--
--==============================================================================
procedure create_calendar (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_plug_name                       in varchar2 default null,
    p_region_name                     in varchar2 default null,
    p_parent_plug_id                  in number   default null,
    p_plug_display_point              in varchar2 default 'BODY',
    p_plug_template                   in number   default null,
    p_plug_display_sequence           in varchar2 default null,
    p_include_in_reg_disp_sel_yn      in varchar2 default c_n,
    p_region_css_classes              in varchar2 default null,
    p_region_attributes               in varchar2 default null,
    p_report_attributes               in varchar2 default null,
    p_plug_new_grid                   in boolean  default false,
    p_plug_new_grid_row               in boolean  default true,
    p_plug_grid_row_css_classes       in varchar2 default null,
    p_plug_new_grid_column            in boolean  default true,
    p_plug_grid_column_span           in number   default null,
    p_plug_grid_column_css_classes    in varchar2 default null,
    p_plug_display_column             in varchar2 default null,
    p_plug_item_display_point         in varchar2 default 'ABOVE',
    p_plug_source_type                in varchar2 default null,
    p_location                        in varchar2 default 'LOCAL',
    p_web_src_module_id               in number   default null,
    p_use_local_sync_table            in boolean  default null,
    p_remote_server_id                in number   default null,
    p_query_type                      in varchar2 default null,
    p_function_body_language          in varchar2 default null,
    p_plug_source                     in varchar2 default null,
    p_query_owner                     in varchar2 default null,
    p_query_table                     in varchar2 default null,
    p_query_where                     in varchar2 default null,
    p_query_order_by_type             in varchar2 default null,
    p_query_order_by                  in varchar2 default null,
    p_source_post_processing          in varchar2 default null,
    p_include_rowid_column            in boolean  default null,
    p_optimizer_hint                  in varchar2 default null,
    p_remote_sql_caching              in varchar2 default null,
    p_remote_sql_invalidate_when      in varchar2 default null,
    p_external_filter_expr            in varchar2 default null,
    p_external_order_by_type          in varchar2 default null,
    p_external_order_by_expr          in varchar2 default null,
    p_plug_display_error_message      in varchar2 default null, /* obsolete */
    p_plug_required_role              in varchar2 default null,
    p_plug_display_when_condition     in varchar2 default null,
    p_plug_display_when_cond2         in varchar2 default null,
    p_plug_display_condition_type     in varchar2 default null,
    --
    p_plug_read_only_when_type        in varchar2 default null,
    p_plug_read_only_when             in varchar2 default null,
    p_plug_read_only_when2            in varchar2 default null,
    --
    p_plug_header                     in varchar2 default null,
    p_plug_footer                     in varchar2 default null,
    p_plug_override_reg_pos           in varchar2 default null,
    p_plug_customized                 in varchar2 default null,
    p_plug_customized_name            in varchar2 default null,
    p_translate_title                 in varchar2 default c_y,
    p_rest_enabled                    in varchar2 default c_n,
    --
    p_region_image                    in varchar2 default null,
    p_region_image_attr               in varchar2 default null,
    p_region_image_alt_text           in varchar2 default null,
    --
    p_plug_caching                    in varchar2 default 'NOCACHE',
    p_plug_caching_session_state      in varchar2 default null,
    p_plug_caching_max_age_in_sec     in varchar2 default null,
    p_plug_cache_when_cond_type       in varchar2 default null,
    p_plug_cache_when_condition_e1    in varchar2 default null,
    p_plug_cache_when_condition_e2    in varchar2 default null,
    p_plug_cache_depends_on_items     in varchar2 default null,
    p_escape_on_http_output           in varchar2 default c_n,
    --
    p_required_patch                  in varchar2 default null,
    p_plug_comment                    in varchar2 default null,
    --
    p_cal_id                          in number   default null,
    p_start_date                      in varchar2 default null,
    p_end_date                        in varchar2 default null,
    p_begin_at_start_of_interval      in varchar2 default c_y,
    p_date_item                       in varchar2 default null,
    p_end_date_item                   in varchar2 default null,
    p_display_as                      in varchar2 default null,
    p_display_item                    in varchar2 default null,
    p_display_type                    in varchar2 default null,
    p_item_format                     in varchar2 default null,
    p_easy_sql_owner                  in varchar2 default null,
    p_easy_sql_table                  in varchar2 default null,
    p_date_column                     in varchar2 default null,
    p_end_date_column                 in varchar2 default null,
    p_display_column                  in varchar2 default null,
    p_template_id                     in number   default null,
    p_start_of_week                   in number   default null,
    p_day_link                        in varchar2 default null,
    p_item_link                       in varchar2 default null,
    p_start_time                      in varchar2 default null,
    p_end_time                        in varchar2 default null,
    p_time_format                     in varchar2 default null,
    p_week_start_day                  in varchar2 default null,
    p_week_end_day                    in varchar2 default null,
    p_date_type_column                in varchar2 default null,
    p_calendar_type                   in varchar2 default null,
    p_include_custom_cal              in varchar2 default null,
    p_custom_cal_days                 in number   default 3,
    p_primary_key_column              in varchar2 default null,
    p_drag_drop_required_role         in varchar2 default null,
    p_drag_drop_process_id            in number   default null,
    p_item_link_primary_key_item      in varchar2 default null,
    p_item_link_date_item             in varchar2 default null,
    p_item_link_open_in               in varchar2 default 'W',
    p_include_time_with_date          in varchar2 default c_n,
    p_data_background_color           in varchar2 default null,
    p_data_text_color                 in varchar2 default null,
    p_agenda_cal_days_type            in varchar2 default 'MONTH',
    p_agenda_cal_days                 in number   default 30,
    p_calendar_comments               in varchar2 default null,
    --
    p_plug_column_width               in varchar2 default null );

--==============================================================================
procedure create_jstree  (
    p_id                              in number   default null,
    p_flow_id                         in number   default wwv_flow.g_flow_id,
    p_page_id                         in number   default current_page_id,
    p_region_id                       in number   default current_region_id,
    p_tree_template                   in varchar2 default null,
    p_tree_source                     in varchar2 default null,
    p_tree_query                      in varchar2 default null,
    p_tree_node_title                 in varchar2 default null,
    p_tree_node_value                 in varchar2 default null,
    p_tree_node_icon                  in varchar2 default null,
    p_tree_node_link                  in varchar2 default null,
    p_tree_node_hints                 in varchar2 default null,
    p_tree_start_item                 in varchar2 default null,
    p_tree_start_value                in varchar2 default null,
    p_tree_button_option              in varchar2 default null,
    p_show_node_link                  in varchar2 default null,
    p_node_link_checksum_type         in varchar2 default null,
    p_tree_comment                    in varchar2 default null,
    p_show_hints                      in varchar2 default null,
    p_tree_has_focus                  in varchar2 default null,
    p_tree_hint_text                  in varchar2 default null,
    p_tree_click_action               in varchar2 default null,
    p_selected_node                   in varchar2 default null);

end wwv_flow_imp_page;
/
show errors;
