set define '^' verify off
prompt ...wwv_flow_f4000_util
create or replace package wwv_flow_f4000_util as
--------------------------------------------------------------------------------
--
--  Copyright (c) Oracle Corporation 2006 - 2022. All Rights Reserved.
--
--  NAME
--    wwv_flow_f4000_util
--
--  DESCRIPTION
--    Oracle APEX logic
--
--  MODIFIED (MM/DD/YYYY)
--    mhichwa   06/16/2006 - Created
--
--------------------------------------------------------------------------------

function validate_blob_mask (
   p_mask         in varchar2 default null,
   p_app_id       in number   default null)
   return varchar2
   ;

function validate_db_column (
    p_parsing_schema in varchar2,
    p_owner          in varchar2,
    p_table_name     in varchar2,
    p_column_name    in varchar2 )
    return varchar2;

function get_next_app_page (
    p_request      in varchar2 default null,
    p_current_app  in number   default null,
    p_current_page in number   default null)
    return number
    ;

function get_build_opt_util
    return varchar2
    ;

procedure show_popup_images (
    p_return_item   in varchar2 default null,
    p_image_size    in number   default null,
    p_show          in varchar2 default null,
    p_category      in varchar2 default null)
    ;

procedure save_interactive_rpt_region (
    p_region_id                in number,
    p_flow_id                  in number,
    p_plug_name                in varchar2 default null,
    p_region_name              in varchar2 default null,
    p_region_template          in number default null,
    p_display_seq              in number default null,
    p_display_column           in number default null,
    p_display_point            in varchar2 default null,
    p_region_source            in varchar2 default null,
    p_breadcrumb_template      in number default null,
    p_list_template            in number default null,
    p_required_role            in varchar2 default null,
    p_display_when_cond        in varchar2 default null,
    p_display_when_cond2       in varchar2 default null,
    p_display_cond_type        in varchar2 default null,
    p_region_header            in varchar2 default null,
    p_region_footer            in varchar2 default null,
    p_region_column_width      in varchar2 default null,
    p_customized               in varchar2 default null,
    p_customized_name          in varchar2 default null,
    p_requied_patch            in number   default null,
    p_url_text_begin           in varchar2 default null,
    p_url_text_end             in varchar2 default null,
    p_translate_title          in varchar2 default null,
    p_comment                  in varchar2 default null);

procedure require_flow_id
   ;

-- for popup pages to implement help links
procedure show_help_link (
   p_lang           in varchar2 default null,
   p_session_id     in varchar2 default null,
   p_application_id in varchar2 default null,
   p_page_id        in varchar2 default null)
   ;

-- application level process
procedure set_flow_page
;

-- page 4000.602
procedure copy_list (
    p_copy_from_list_id   in number,
    p_new_list_name       in varchar2)
    ;

function copy_list (
    p_copy_from_list_id   in number,
    p_new_list_name       in varchar2)
    return number;

-- page 4000.663
procedure copy_list_from_app (
    p_copy_from_app_id    in  number,
    p_copy_from_list_id   in  number,
    p_new_list_name       in  varchar2,
    p_new_application_id  in  number,
    p_new_list_id         out number)
    ;


-- 4000.4651
procedure show_list_source (
   p_list_id        in number,
   p_application_id in number,
   p_session        in number)
   ;

-- 4000.4651
procedure show_region_tree_source (
   p_application    in number,
   p_id             in number,
   p_session        in number)
   ;

procedure create_list_entry_as_copy (
   p_id           in number,
   p_list_id      in number,
   p_new_sequence in number,
   p_new_text     in varchar2);

procedure show_workspace_images (
   p_search        in varchar2 default null,
   p_current_icon  in varchar2 default null,
   p_columns       in number default 3)
   ;
procedure show_application_images (
   p_search        in varchar2 default null,
   p_current_icon  in varchar2 default null,
   p_columns       in number default 3)
   ;

function get_edit_icons (
   p_item_name in varchar2 )
   return varchar2;

function is_valid_chart_query (
    p_flow_id            in number,
    p_security_group_id  in number,
    p_query              in varchar2
  ) return varchar2;

function is_valid_dial_chart_query (
    p_flow_id            in number,
    p_security_group_id  in number,
    p_query              in varchar2
  ) return varchar2;

--==============================================================================
-- Validates a LOV query which has to contain two columns.
-- If p_parse_as_schema is null, it will default to
-- wwv_flow_security.flow_owner for FB_FLOW_ID
--==============================================================================
function is_valid_lov_query (
    p_query            in varchar2,
    p_parse_as_schema  in varchar2 default null,
    p_min_column_count in number default 2,
    p_max_column_count in number default 2 )
    return varchar2;

--==============================================================================
function is_valid_list_query (
    p_query       varchar2,
    p_query_type  varchar2
) return varchar2;

--==============================================================================
-- Return if p_query contains an order by clause at the end.
-- Used by validations on 4000:420, 4000:4651, 4000:4796 and 4000:831
--==============================================================================
function is_query_with_order_by (
    p_query       in varchar2 )
    return boolean;

/* Used to validate buttons are compatible with Dynamic Actions */
procedure validate_da_compatible_button (
    p_flow_id                   in number,
    p_workspace_id              in number,
    p_button_template_id        in number,
    p_button_cattributes        in varchar2,
    p_error_item_template_chk   in varchar2     default null,
    p_error_item_attribute_chk  in varchar2     default null,
    p_error_display_location    in varchar2
);

/* Used to validate button style attributes */
procedure validate_button_style (
    p_style_item          in varchar2,
    p_tag_attr_item       in varchar2,
    p_image_item          in varchar2,
    p_image_attr_item     in varchar2,
    p_template_item       in varchar2
);

/* Checks if a button is referenced by any Dynamic Actions in an application */
procedure validate_da_on_delete_button (
    p_flow_id             in number,
    p_button_id           in number,
    p_workspace_id        in number
);

function check_plsql (
    p_sql               in varchar2,
    p_flow_id           in number,
    p_security_group_id in number,
    p_remote_server_id  in number  default null,
    p_escape_result     in boolean default true
) return varchar2 ;

--==============================================================================
-- Checks for a valid SQL statement
-- Returns the error text.
--==============================================================================
function check_sql (
    p_sql                 in varchar2,
    p_flow_id             in number   default nv('FB_FLOW_ID'),
    p_parse_as_schema     in varchar2 default null,
    p_min_column_count    in number,
    p_max_column_count    in number   default null,
    p_invalid_sql_error   in varchar2,
    p_column_count_error  in varchar2,
    p_column_name_invalid in varchar2 default null,
    p_column_not_unique   in varchar2 default null,
    p_escape_result       in boolean default true )
    return varchar2;

--==============================================================================
-- Checks for a valid SQL statement using wwv_flow_exec_dev API
-- Returns the error text.
--==============================================================================
function check_sql(
    p_sql                 in varchar2,
    p_flow_id             in number   default nv('FB_FLOW_ID'),
    p_remote_server_id    in number   default null,
    p_parse_as_schema     in varchar2 default null,
    p_min_column_count    in number   default null,
    p_max_column_count    in number   default null,
    p_escape_result       in boolean  default true )
    return varchar2;

procedure run_block
     ( p_sql       in varchar2,
       p_user      in varchar2,
       p_use_roles in boolean default FALSE);

function countem( p_sql in varchar2,
                  p_user in varchar2 ) return varchar2;

--==============================================================================
-- Checks for a valid report SQL statement
-- moved from wwv_render_report3 to here.
-- Returns the error text.
--==============================================================================
function is_valid_report_query (
    p_plug_source      varchar2,
    p_plug_source_type varchar2,
    p_owner            varchar2  default null,
    p_required_col_num number    default null )
return varchar2;

--==============================================================================
-- Checks whether the query returns 1 row and 1 column.
-- moved from wwv_flow_tree_region to here.
--==============================================================================
function is_valid_start_query(
    p_sql    in varchar2
) return boolean;

--==============================================================================
-- Test a legacy web service (app process P875_TEST_REST). The procedure writes
-- unescaped text to the HTP buffer. The caller is responsible for escaping (JS
-- functions p975_test_rest on page 975 and p875_test_rest on page 875).
--==============================================================================
procedure test_legacy_rest_service (
    p_url             in varchar2,
    p_proxy_override  in varchar2,
    p_method          in varchar2,
    p_username        in varchar2,
    p_password        in varchar2,
    p_body            in varchar2,
    p_parm_name       in wwv_flow_global.vc_arr2,
    p_parm_value      in wwv_flow_global.vc_arr2,
    p_http_headers    in wwv_flow_global.vc_arr2,
    p_http_hdr_values in wwv_flow_global.vc_arr2 );

--==============================================================================
-- Checks for a valid SQL statement
-- Returns the error text.
--==============================================================================
function validate_plsql_expressions (
    p_expression       in varchar2,
    p_expression_type  in varchar2 )
    return varchar2;

--==============================================================================
-- Procedure to initialize LOVs collection
-- This procedure is used in 4000:623
--==============================================================================
procedure init_lov_collection (
    p_collection_name   in varchar2,
    p_copy_from_flow_id in number,
    p_copy_from_page_id in number );

--==============================================================================
-- Procedure to initialize Lists collection
-- This procedure is used in 4000:625
--==============================================================================
procedure init_list_collection (
    p_collection_name   in varchar2,
    p_copy_from_flow_id in number,
    p_copy_from_page_id in number );

--==============================================================================
-- Procedure to initialize Authorization Scheme collection
-- This procedure is used in 4000:627
--==============================================================================
procedure init_authorization_collection (
    p_collection_name   in varchar2,
    p_copy_from_flow_id in number,
    p_copy_from_page_id in number );

--==============================================================================
-- Gallery: Initialize packaged app installation process
-- Stores uploaded app zip file in collection & returns json to frontend
-- Used in 4750:50
--==============================================================================
procedure init_install_app(
    p_target_page_id in number
);

--==============================================================================
-- Gallery: Removes a packaged app including supporting objects
-- Used in 4750:50
--==============================================================================
procedure remove_app(
    p_flow_id in wwv_flows.id%type
);

--==============================================================================
-- Gallery: Write global javascript variable gInstalledApps to page, this is used by frontend
-- logic to render cards based on this information, e.g. display delete or run app buttons
-- Used in 4750:50
--==============================================================================
procedure write_installed_apps_js;

--==============================================================================
-- Gallery: Fetch data from collection to init page items on install modal page
-- Used in 4750:40
--==============================================================================
procedure fetch_install_app_collection(
    p_app_name     out varchar2,
    p_app_desc     out varchar2,
    p_app_author   out wwv_flow_gallery_installs.author%type,
    p_app_int_name out wwv_flow_gallery_installs.internal_name%type,
    p_app_icon     out varchar2
);

--==============================================================================
-- Gallery: Install packaged app including supporting objects
-- Used in 4750:40
--==============================================================================
procedure install_app(
    p_flow_id      in out wwv_flows.id%type,
    p_owner        in varchar2,
    p_app_author   in wwv_flow_gallery_installs.author%type,
    p_app_int_name in wwv_flow_gallery_installs.internal_name%type
);

--==============================================================================
-- Checks whether the optional directives in an email template are valid.
-- Returns the error text.
--==============================================================================
function validate_email_template(
    p_template      in varchar2 ) 
    return varchar2;

--==============================================================================
-- Returns a sample API call signature to send an email using a template
--==============================================================================
function get_sample_email_api_usage(
    p_static_id     in varchar2,
    p_subject       in clob,
    p_html_header   in clob,
    p_html_body     in clob,
    p_html_footer   in clob,
    p_text_template in clob )
    return varchar2;

end wwv_flow_f4000_util;
/
show errors
